{"vars":[{"kind":2,"line":91,"name":"base","containerName":""},{"definition":"sub","name":"_initialize","containerName":"main::","range":{"end":{"line":112,"character":9999},"start":{"character":0,"line":105}},"kind":12,"children":[{"line":106,"kind":13,"localvar":"my","containerName":"_initialize","definition":"my","name":"$self"},{"containerName":"_initialize","name":"$self","kind":13,"line":107},{"containerName":"_initialize","name":"$self","kind":13,"line":107},{"name":"$self","containerName":"_initialize","kind":13,"line":108},{"containerName":"_initialize","name":"$self","line":108,"kind":13},{"kind":12,"line":108,"name":"_rearrange","containerName":"_initialize"},{"line":111,"kind":13,"containerName":"_initialize","name":"$self"}],"line":105},{"name":"_result","line":107,"kind":12},{"name":"_linkdist","line":107,"kind":12},{"line":108,"kind":12,"name":"_labels"},{"name":"SUPER","containerName":"_initialize","kind":12,"line":111},{"name":"next_tree","range":{"end":{"line":140,"character":9999},"start":{"character":0,"line":125}},"definition":"sub","containerName":"main::","signature":{"label":"next_tree($self)","documentation":"1;\n# $Id: cluster.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::TreeIO::cluster\n#\n# Contributed by Guillaume Rousse <Guillaume-dot-Rousse-at-inria-dot-fr>\n#\n# Copyright INRIA\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::TreeIO::cluster - A TreeIO driver module for parsing Algorithm::Cluster::treecluster() output\n\n=head1 SYNOPSIS\n\n  # do not use this module directly\n  use Bio::TreeIO;\n  use Algorithm::Cluster;\n  my ($result, $linkdist) = Algorithm::Cluster::treecluster(\n    distances => $matrix\n  );\n  my $treeio = Bio::TreeIO->new(\n    -format   => 'cluster',\n    -result   =>  $result,\n    -linkdist =>  $linkdist,\n    -labels   =>  $labels\n  );\n  my $tree = $treeio->next_tree;\n\n=head1 DESCRIPTION\n\nThis is a driver module for parsing Algorithm::Cluster::treecluster() output.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Guillaume Rousse\n\nEmail Guillaume-dot-Rousse-at-inria-dot-fr\n\n=head1 CONTRIBUTORS\n\nJason Stajich - jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::TreeIO::cluster;\nuse strict;\n\nuse Bio::Event::EventGeneratorI;\nuse IO::String;\n\nuse base qw(Bio::TreeIO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::TreeIO::cluster->new();\n Function: Builds a new Bio::TreeIO::cluster object for reading Algorithm::Cluster::treecluster output\n Returns : Bio::TreeIO::cluster\n Args    :-result   => Algorithm::Cluster result\n          -linkdist => distance between links\n          -labels   => node labels\n\n\nsub _initialize {\n  my $self = shift;\n  ($self->{_result},$self->{_linkdist},\n   $self->{_labels}) = $self->_rearrange([qw\n\t\t\t\t\t  (RESULT LINKDIST LABELS)],\n\t\t\t\t\t @_);\n  $self->SUPER::_initialize(@_);\n}\n\n=head2 next_tree\n\n Title   : next_tree\n Usage   : my $tree = $treeio->next_tree\n Function: Gets the next tree in the stream\n Returns : Bio::Tree::TreeI\n Args    : none","parameters":[{"label":"$self"}]},"detail":"($self)","kind":12,"children":[{"kind":13,"line":126,"name":"$self","definition":"my","containerName":"next_tree","localvar":"my"},{"name":"$self","containerName":"next_tree","line":127,"kind":13},{"containerName":"next_tree","name":"$self","kind":13,"line":128},{"name":"warn","containerName":"next_tree","line":128,"kind":12},{"line":131,"kind":13,"name":"$self","containerName":"next_tree"},{"containerName":"next_tree","name":"_eventHandler","kind":12,"line":131},{"containerName":"next_tree","name":"start_document","kind":12,"line":131},{"name":"$self","containerName":"next_tree","line":134,"kind":13},{"kind":12,"line":134,"containerName":"next_tree","name":"_eventHandler"},{"containerName":"next_tree","name":"start_element","kind":12,"line":134},{"containerName":"next_tree","name":"$self","kind":13,"line":135},{"name":"_recurse","containerName":"next_tree","kind":12,"line":135},{"containerName":"next_tree","name":"$self","line":136,"kind":13},{"kind":12,"line":136,"containerName":"next_tree","name":"_recurse"},{"kind":13,"line":137,"name":"$self","containerName":"next_tree"},{"containerName":"next_tree","name":"_eventHandler","line":137,"kind":12},{"containerName":"next_tree","name":"end_element","kind":12,"line":137},{"line":139,"kind":13,"name":"$self","containerName":"next_tree"},{"kind":12,"line":139,"containerName":"next_tree","name":"_eventHandler"},{"name":"end_document","containerName":"next_tree","kind":12,"line":139}],"line":125},{"name":"_result","line":127,"kind":12},{"kind":12,"line":134,"name":"Name"},{"name":"Name","kind":12,"line":137},{"range":{"end":{"character":9999,"line":181},"start":{"character":0,"line":142}},"name":"_recurse","detail":"($self,$line,$column)","signature":{"label":"_recurse($self,$line,$column)","parameters":[{"label":"$self"},{"label":"$line"},{"label":"$column"}],"documentation":""},"containerName":"main::","definition":"sub","line":142,"children":[{"line":143,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"_recurse"},{"kind":13,"line":143,"containerName":"_recurse","name":"$line"},{"name":"$column","containerName":"_recurse","line":143,"kind":13},{"kind":13,"line":145,"containerName":"_recurse","definition":"my","name":"$id","localvar":"my"},{"containerName":"_recurse","name":"$self","line":145,"kind":13},{"line":145,"kind":13,"name":"$line","containerName":"_recurse"},{"name":"$column","containerName":"_recurse","kind":13,"line":145},{"containerName":"_recurse","name":"$id","kind":13,"line":146},{"name":"$self","containerName":"_recurse","kind":13,"line":148},{"line":148,"kind":12,"containerName":"_recurse","name":"debug"},{"kind":13,"line":149,"containerName":"_recurse","name":"$self"},{"name":"debug","containerName":"_recurse","kind":12,"line":149},{"kind":13,"line":150,"containerName":"_recurse","name":"$self"},{"line":150,"kind":12,"containerName":"_recurse","name":"debug"},{"kind":13,"line":151,"name":"$self","containerName":"_recurse"},{"line":151,"kind":12,"containerName":"_recurse","name":"_eventHandler"},{"kind":12,"line":151,"name":"start_element","containerName":"_recurse"},{"kind":13,"line":152,"name":"$self","containerName":"_recurse"},{"kind":12,"line":152,"containerName":"_recurse","name":"_eventHandler"},{"line":152,"kind":12,"name":"start_element","containerName":"_recurse"},{"line":153,"kind":13,"name":"$self","containerName":"_recurse"},{"containerName":"_recurse","name":"_eventHandler","kind":12,"line":153},{"containerName":"_recurse","name":"characters","line":153,"kind":12},{"containerName":"_recurse","name":"$self","line":153,"kind":13},{"containerName":"_recurse","name":"$line","kind":13,"line":153},{"containerName":"_recurse","name":"$self","kind":13,"line":154},{"kind":12,"line":154,"name":"_eventHandler","containerName":"_recurse"},{"line":154,"kind":12,"name":"end_element","containerName":"_recurse"},{"kind":13,"line":155,"containerName":"_recurse","name":"$self"},{"line":155,"kind":12,"name":"_eventHandler","containerName":"_recurse"},{"containerName":"_recurse","name":"start_element","line":155,"kind":12},{"name":"$self","containerName":"_recurse","kind":13,"line":156},{"name":"_eventHandler","containerName":"_recurse","kind":12,"line":156},{"containerName":"_recurse","name":"characters","kind":12,"line":156},{"name":"$self","containerName":"_recurse","line":156,"kind":13},{"containerName":"_recurse","name":"$id","kind":13,"line":156},{"containerName":"_recurse","name":"$self","line":157,"kind":13},{"containerName":"_recurse","name":"_eventHandler","line":157,"kind":12},{"kind":12,"line":157,"name":"end_element","containerName":"_recurse"},{"kind":13,"line":158,"containerName":"_recurse","name":"$self"},{"kind":12,"line":158,"name":"_eventHandler","containerName":"_recurse"},{"name":"start_element","containerName":"_recurse","kind":12,"line":158},{"line":159,"kind":13,"containerName":"_recurse","name":"$self"},{"containerName":"_recurse","name":"_eventHandler","kind":12,"line":159},{"line":159,"kind":12,"containerName":"_recurse","name":"characters"},{"name":"$self","containerName":"_recurse","line":160,"kind":13},{"line":160,"kind":12,"containerName":"_recurse","name":"_eventHandler"},{"containerName":"_recurse","name":"end_element","line":160,"kind":12},{"containerName":"_recurse","name":"$self","line":161,"kind":13},{"containerName":"_recurse","name":"_eventHandler","line":161,"kind":12},{"line":161,"kind":12,"name":"end_element","containerName":"_recurse"},{"line":164,"kind":13,"name":"$self","containerName":"_recurse"},{"kind":12,"line":164,"containerName":"_recurse","name":"debug"},{"containerName":"_recurse","name":"$self","line":165,"kind":13},{"kind":12,"line":165,"containerName":"_recurse","name":"debug"},{"name":"$self","containerName":"_recurse","kind":13,"line":166},{"containerName":"_recurse","name":"_eventHandler","kind":12,"line":166},{"kind":12,"line":166,"name":"start_element","containerName":"_recurse"},{"containerName":"_recurse","name":"$self","line":167,"kind":13},{"containerName":"_recurse","name":"_eventHandler","line":167,"kind":12},{"name":"start_element","containerName":"_recurse","line":167,"kind":12},{"kind":13,"line":168,"containerName":"_recurse","name":"$self"},{"kind":12,"line":168,"name":"_eventHandler","containerName":"_recurse"},{"name":"characters","containerName":"_recurse","kind":12,"line":168},{"line":168,"kind":13,"containerName":"_recurse","name":"$self"},{"containerName":"_recurse","name":"$line","kind":13,"line":168},{"containerName":"_recurse","name":"$self","kind":13,"line":169},{"containerName":"_recurse","name":"_eventHandler","line":169,"kind":12},{"containerName":"_recurse","name":"end_element","line":169,"kind":12},{"name":"$self","containerName":"_recurse","kind":13,"line":170},{"kind":12,"line":170,"containerName":"_recurse","name":"_eventHandler"},{"line":170,"kind":12,"name":"start_element","containerName":"_recurse"},{"kind":13,"line":171,"containerName":"_recurse","name":"$self"},{"kind":12,"line":171,"name":"_eventHandler","containerName":"_recurse"},{"containerName":"_recurse","name":"characters","kind":12,"line":171},{"kind":13,"line":172,"containerName":"_recurse","name":"$self"},{"kind":12,"line":172,"containerName":"_recurse","name":"_eventHandler"},{"kind":12,"line":172,"name":"end_element","containerName":"_recurse"},{"containerName":"_recurse","name":"$self","kind":13,"line":173},{"kind":12,"line":173,"name":"_eventHandler","containerName":"_recurse"},{"line":173,"kind":12,"name":"start_element","containerName":"_recurse"},{"localvar":"my","name":"$child_id","definition":"my","containerName":"_recurse","line":174,"kind":13},{"name":"$id","containerName":"_recurse","line":174,"kind":13},{"containerName":"_recurse","name":"$self","line":175,"kind":13},{"kind":12,"line":175,"containerName":"_recurse","name":"_recurse"},{"name":"$child_id","containerName":"_recurse","kind":13,"line":175},{"kind":13,"line":176,"name":"$self","containerName":"_recurse"},{"kind":12,"line":176,"name":"_recurse","containerName":"_recurse"},{"line":176,"kind":13,"name":"$child_id","containerName":"_recurse"},{"name":"$self","containerName":"_recurse","kind":13,"line":177},{"line":177,"kind":12,"name":"_eventHandler","containerName":"_recurse"},{"line":177,"kind":12,"containerName":"_recurse","name":"end_element"},{"line":178,"kind":13,"containerName":"_recurse","name":"$self"},{"containerName":"_recurse","name":"_eventHandler","kind":12,"line":178},{"containerName":"_recurse","name":"end_element","kind":12,"line":178}],"kind":12},{"line":145,"kind":12,"name":"_result"},{"line":151,"kind":12,"name":"Name"},{"line":152,"kind":12,"name":"Name"},{"kind":12,"line":153,"name":"_linkdist"},{"name":"Name","kind":12,"line":154},{"name":"Name","line":155,"kind":12},{"kind":12,"line":156,"name":"_labels"},{"kind":12,"line":157,"name":"Name"},{"name":"Name","line":158,"kind":12},{"name":"Name","kind":12,"line":160},{"name":"Name","line":161,"kind":12},{"name":"Name","line":166,"kind":12},{"name":"Name","kind":12,"line":167},{"name":"_linkdist","line":168,"kind":12},{"kind":12,"line":169,"name":"Name"},{"kind":12,"line":170,"name":"Name"},{"name":"Name","kind":12,"line":172},{"name":"Name","kind":12,"line":173},{"name":"Name","kind":12,"line":177},{"name":"Name","line":178,"kind":12},{"children":[{"kind":12,"line":195,"name":"throw","containerName":"write_tree"}],"line":194,"kind":12,"range":{"start":{"character":0,"line":194},"end":{"line":196,"character":9999}},"name":"write_tree","definition":"sub","containerName":"main::"}],"version":5}