{"version":5,"vars":[{"kind":2,"line":106,"name":"vars","containerName":""},{"containerName":null,"name":"$PRECISION_DIGITS","kind":13,"line":109},{"containerName":"","name":"strict","line":109,"kind":2},{"containerName":null,"name":"$DefaultNodeType","line":110,"kind":13},{"line":111,"kind":13,"name":"%Defaults","containerName":null},{"kind":2,"line":119,"containerName":"","name":"base"},{"range":{"start":{"character":0,"line":143},"end":{"line":180,"character":9999}},"name":"new","line":143,"children":[{"kind":13,"line":144,"definition":"my","name":"$class","containerName":"new","localvar":"my"},{"containerName":"new","name":"@args","line":144,"kind":13},{"kind":13,"line":145,"containerName":"new","definition":"my","name":"$self","localvar":"my"},{"name":"$class","containerName":"new","kind":13,"line":145},{"containerName":"new","name":"@args","line":145,"kind":13},{"line":147,"kind":13,"containerName":"new","name":"$self"},{"kind":13,"line":148,"containerName":"new","name":"$self"},{"containerName":"new","name":"$nodetype","definition":"my","localvar":"my","kind":13,"line":149},{"containerName":"new","name":"$randtype","kind":13,"line":149},{"line":150,"kind":13,"containerName":"new","name":"$maxcount"},{"line":150,"kind":13,"name":"$samps","containerName":"new"},{"name":"$samplesize","containerName":"new","kind":13,"line":150},{"containerName":"new","name":"$taxa","line":151,"kind":13},{"name":"$num_taxa","containerName":"new","line":151,"kind":13},{"name":"$self","containerName":"new","line":151,"kind":13},{"line":151,"kind":12,"name":"_rearrange","containerName":"new"},{"line":158,"kind":13,"name":"@args","containerName":"new"},{"localvar":"my","containerName":"new","name":"@taxa","definition":"my","line":159,"kind":13},{"name":"$nodetype","containerName":"new","line":160,"kind":13},{"containerName":"new","name":"$DefaultNodeType","kind":13,"line":160},{"name":"$self","containerName":"new","line":161,"kind":13},{"line":161,"kind":12,"containerName":"new","name":"nodetype"},{"line":161,"kind":13,"name":"$nodetype","containerName":"new"},{"line":162,"kind":13,"name":"$taxa","containerName":"new"},{"containerName":"new","name":"$samps","line":162,"kind":13},{"line":162,"kind":13,"containerName":"new","name":"$samps"},{"containerName":"new","name":"$taxa","line":162,"kind":13},{"name":"$num_taxa","containerName":"new","line":163,"kind":13},{"kind":13,"line":163,"containerName":"new","name":"$samplesize"},{"containerName":"new","name":"$samplesize","kind":13,"line":163},{"kind":13,"line":163,"containerName":"new","name":"$num_taxa"},{"name":"$taxa","containerName":"new","kind":13,"line":164},{"kind":13,"line":165,"name":"$num_taxa","containerName":"new"},{"name":"$num_taxa","containerName":"new","kind":13,"line":165},{"line":166,"kind":13,"name":"$self","containerName":"new"},{"containerName":"new","name":"throw","kind":12,"line":166},{"containerName":"new","name":"$num_taxa","kind":13,"line":168},{"containerName":"new","name":"@taxa","kind":13,"line":168},{"name":"$taxa","containerName":"new","line":170,"kind":13},{"kind":13,"line":171,"name":"$self","containerName":"new"},{"name":"throw","containerName":"new","kind":12,"line":171},{"kind":13,"line":173,"containerName":"new","name":"@taxa"},{"containerName":"new","name":"$taxa","kind":13,"line":173},{"containerName":"new","name":"$self","kind":13,"line":176},{"line":176,"kind":12,"name":"taxa","containerName":"new"},{"name":"@taxa","containerName":"new","kind":13,"line":176},{"line":177,"kind":13,"containerName":"new","name":"$maxcount"},{"kind":13,"line":177,"containerName":"new","name":"$self"},{"name":"maxcount","containerName":"new","line":177,"kind":12},{"line":177,"kind":13,"name":"$maxcount","containerName":"new"},{"name":"$self","containerName":"new","line":178,"kind":13},{"containerName":"new","name":"$self","line":179,"kind":13}],"kind":12,"detail":"($class,@args)","signature":{"label":"new($class,@args)","documentation":"1;\n# $Id: RandomFactory.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tree::RandomFactory\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::RandomFactory - TreeFactory for generating Random Trees\n\n=head1 SYNOPSIS\n\n  use Bio::Tree::RandomFactory\n  my @taxonnames;\n  my $factory = Bio::Tree::RandomFactory->new( -taxa => \\@taxonnames,\n  \t\t\t\t\t      -maxcount => 10);\n\n  # or for anonymous samples\n\n  my $factory = Bio::Tree::RandomFactory->new( -num_taxa => 6,\n\t\t\t\t\t      -maxcount => 50);\n\n\n  my $tree = $factory->next_tree;\n\n=head1 DESCRIPTION\n\nBuilds a random tree every time next_tree is called or up to -maxcount times.\n\nThis module was originally written for Coalescent simulations see\nL<Bio::PopGen::Simulation::Coalescent>.  I've left the next_tree\nmethod intact although it is not generating random trees in the\nphylogenetic sense.  I would be happy for someone to provide\nalternative implementations which can be used here.  As written it\nwill generate random topologies but the branch lengths are built from\nassumptions in the coalescent and are not appropriate for phylogenetic\nanalyses.\n\nThis algorithm is based on the make_tree algorithm from Richard Hudson 1990.\n\nHudson, R. R. 1990. Gene genealogies and the coalescent\n       process. Pp. 1-44 in D. Futuyma and J.  Antonovics, eds. Oxford\n       surveys in evolutionary biology. Vol. 7. Oxford University\n       Press, New York\n\nSanderson, M ... \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-AT-bioperl.org\n\n=head1 CONTRIBUTORS\n\nMatthew Hahn, E<lt>matthew.hahn@duke.eduE<gt>\nMike Sanderson \n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tree::RandomFactory;\nuse vars qw($PRECISION_DIGITS $DefaultNodeType %Defaults);\nuse strict;\n\n$PRECISION_DIGITS = 3; # Precision for the branchlength\n$DefaultNodeType = 'Bio::Tree::Node';\n%Defaults = ('YuleRate'          => 1.0, # as set by Sanderson in Rates\n\t     'Speciation'        => 1.0, #\n\t     'DefaultTreeMethod' => 'yule',\n\t     );\n\nuse Bio::Tools::RandomDistFunctions;\nuse Bio::Tree::Tree;\n\nuse base qw(Bio::Root::Root Bio::Factory::TreeFactoryI);\n\n=head2 new\n\n Title   : new\n Usage   : my $factory = Bio::Tree::RandomFactory->new(-samples => \\@samples,\n\t\t\t\t\t\t      -maxcount=> $N);\n Function: Initializes a Bio::Tree::RandomFactory object\n Returns : Bio::Tree::RandomFactory\n Args    : -nodetype => Type of Nodes to create [default Bio::Tree::Node]\n           -maxcount => [optional] Maximum num trees to create\n           -randtype => Type of random trees so far support\n               - yule/backward_yule/BY [default]\n               - forward_yule/FY\n               - birthdeath_forward/BDF\n               - birthdeath_backwards/BDB\n\n\n          ONE of the following must be specified\n           -taxa     => $arrayref of taxa names\n           -num_taxa => integer indicating number of taxa in the tree","parameters":[{"label":"$class"},{"label":"@args"}]},"containerName":"main::","definition":"sub"},{"line":145,"kind":12,"name":"SUPER","containerName":"new"},{"name":"next_tree","range":{"end":{"character":9999,"line":228},"start":{"character":0,"line":197}},"definition":"sub","containerName":"main::","signature":{"documentation":"1;\n# $Id: RandomFactory.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tree::RandomFactory\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::RandomFactory - TreeFactory for generating Random Trees\n\n=head1 SYNOPSIS\n\n  use Bio::Tree::RandomFactory\n  my @taxonnames;\n  my $factory = Bio::Tree::RandomFactory->new( -taxa => \\@taxonnames,\n  \t\t\t\t\t      -maxcount => 10);\n\n  # or for anonymous samples\n\n  my $factory = Bio::Tree::RandomFactory->new( -num_taxa => 6,\n\t\t\t\t\t      -maxcount => 50);\n\n\n  my $tree = $factory->next_tree;\n\n=head1 DESCRIPTION\n\nBuilds a random tree every time next_tree is called or up to -maxcount times.\n\nThis module was originally written for Coalescent simulations see\nL<Bio::PopGen::Simulation::Coalescent>.  I've left the next_tree\nmethod intact although it is not generating random trees in the\nphylogenetic sense.  I would be happy for someone to provide\nalternative implementations which can be used here.  As written it\nwill generate random topologies but the branch lengths are built from\nassumptions in the coalescent and are not appropriate for phylogenetic\nanalyses.\n\nThis algorithm is based on the make_tree algorithm from Richard Hudson 1990.\n\nHudson, R. R. 1990. Gene genealogies and the coalescent\n       process. Pp. 1-44 in D. Futuyma and J.  Antonovics, eds. Oxford\n       surveys in evolutionary biology. Vol. 7. Oxford University\n       Press, New York\n\nSanderson, M ... \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-AT-bioperl.org\n\n=head1 CONTRIBUTORS\n\nMatthew Hahn, E<lt>matthew.hahn@duke.eduE<gt>\nMike Sanderson \n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tree::RandomFactory;\nuse vars qw($PRECISION_DIGITS $DefaultNodeType %Defaults);\nuse strict;\n\n$PRECISION_DIGITS = 3; # Precision for the branchlength\n$DefaultNodeType = 'Bio::Tree::Node';\n%Defaults = ('YuleRate'          => 1.0, # as set by Sanderson in Rates\n\t     'Speciation'        => 1.0, #\n\t     'DefaultTreeMethod' => 'yule',\n\t     );\n\nuse Bio::Tools::RandomDistFunctions;\nuse Bio::Tree::Tree;\n\nuse base qw(Bio::Root::Root Bio::Factory::TreeFactoryI);\n\n=head2 new\n\n Title   : new\n Usage   : my $factory = Bio::Tree::RandomFactory->new(-samples => \\@samples,\n\t\t\t\t\t\t      -maxcount=> $N);\n Function: Initializes a Bio::Tree::RandomFactory object\n Returns : Bio::Tree::RandomFactory\n Args    : -nodetype => Type of Nodes to create [default Bio::Tree::Node]\n           -maxcount => [optional] Maximum num trees to create\n           -randtype => Type of random trees so far support\n               - yule/backward_yule/BY [default]\n               - forward_yule/FY\n               - birthdeath_forward/BDF\n               - birthdeath_backwards/BDB\n\n\n          ONE of the following must be specified\n           -taxa     => $arrayref of taxa names\n           -num_taxa => integer indicating number of taxa in the tree\n\n\nsub new{\n   my ($class,@args) = @_;\n   my $self = $class->SUPER::new(@args);\n   \n   $self->{'_treecounter'} = 0;\n   $self->{'_maxcount'} = 0;\n   my ($nodetype,$randtype,\n       $maxcount, $samps,$samplesize,\n       $taxa, $num_taxa) = $self->_rearrange([qw(NODETYPE\n\t\t\t\t\t\t RANDTYPE\n\t\t\t\t\t\t MAXCOUNT\n\t\t\t\t\t\t SAMPLES\n\t\t\t\t\t\t SAMPLE_SIZE\n\t\t\t\t\t\t TAXA\n\t\t\t\t\t\t NUM_TAXA)],\n\t\t\t\t\t     @args);\n   my @taxa;\n   $nodetype ||= $DefaultNodeType;\n   $self->nodetype($nodetype);\n   $taxa = $samps if defined $samps && ! defined $taxa;\n   $num_taxa = $samplesize if $samplesize && ! $num_taxa;\n   if( ! defined $taxa ) { \n       if( ! defined $num_taxa || $num_taxa <= 0 ) { \n\t   $self->throw(\"Must specify a valid num_taxa if parameter -TAXA is not specified\");\n       }\n       foreach ( 1..$num_taxa ) { push @taxa, \"Taxon$_\"; }      \n   } else { \n       if( ref($taxa) !~ /ARRAY/i ) { \n\t   $self->throw(\"Must specify a valid ARRAY reference to the parameter -TAXA, did you forget a leading '\\\\'? for $taxa\");\n       }\n       @taxa = @$taxa;\n   }\n   \n   $self->taxa(\\@taxa);\n   defined $maxcount && $self->maxcount($maxcount);   \n   $self->{'_count'} = 0;\n   return $self;\n}\n\n=head2 next_tree\n\n Title   : next_tree\n Usage   : my $tree = $factory->next_tree\n Function: Returns a random tree based on the initialized number of nodes\n           NOTE: if maxcount is not specified on initialization or\n                 set to a valid integer, subsequent calls to next_tree will \n                 continue to return random trees and never return undef\n\n Returns : Bio::Tree::TreeI object\n Args    : none","parameters":[{"label":"$self"},{"label":"%options"}],"label":"next_tree($self,%options)"},"detail":"($self,%options)","kind":12,"children":[{"kind":13,"line":198,"name":"$self","definition":"my","containerName":"next_tree","localvar":"my"},{"kind":13,"line":198,"containerName":"next_tree","name":"%options"},{"kind":13,"line":199,"name":"$self","containerName":"next_tree"},{"name":"maxcount","containerName":"next_tree","kind":12,"line":199},{"name":"$self","containerName":"next_tree","kind":13,"line":200},{"line":200,"kind":13,"containerName":"next_tree","name":"$self"},{"name":"maxcount","containerName":"next_tree","line":200,"kind":12},{"line":201,"kind":13,"localvar":"my","name":"$rand_type","definition":"my","containerName":"next_tree"},{"kind":13,"line":201,"name":"$options","containerName":"next_tree"},{"containerName":"next_tree","name":"$self","kind":13,"line":201},{"name":"random_tree_method","containerName":"next_tree","kind":12,"line":201},{"kind":13,"line":202,"name":"$nodetype","definition":"my","containerName":"next_tree","localvar":"my"},{"line":202,"kind":13,"containerName":"next_tree","name":"$self"},{"containerName":"next_tree","name":"nodetype","kind":12,"line":202},{"definition":"my","name":"$treearray","containerName":"next_tree","localvar":"my","kind":13,"line":203},{"line":205,"kind":13,"containerName":"next_tree","name":"$rand_type"},{"line":207,"kind":13,"containerName":"next_tree","name":"$rand_type"},{"kind":13,"line":208,"name":"$treearray","containerName":"next_tree"},{"kind":13,"line":208,"containerName":"next_tree","name":"$self"},{"line":208,"kind":12,"containerName":"next_tree","name":"rand_birthdeath_backwards_tree"},{"name":"$rand_type","containerName":"next_tree","line":209,"kind":13},{"line":210,"kind":13,"name":"$rand_type","containerName":"next_tree"},{"localvar":"my","containerName":"next_tree","definition":"my","name":"$speciation","line":211,"kind":13},{"containerName":"next_tree","name":"$options","kind":13,"line":211},{"line":212,"kind":13,"name":"$treearray","containerName":"next_tree"},{"kind":13,"line":212,"name":"$self","containerName":"next_tree"},{"line":212,"kind":12,"containerName":"next_tree","name":"rand_yule_c_tree"},{"containerName":"next_tree","name":"$speciation","kind":13,"line":212},{"containerName":"next_tree","name":"$self","kind":13,"line":214},{"kind":12,"line":214,"name":"warn","containerName":"next_tree"},{"kind":13,"line":217,"containerName":"next_tree","name":"@nodes","definition":"my","localvar":"my"},{"localvar":"my","containerName":"next_tree","name":"$n","definition":"my","line":218,"kind":13},{"containerName":"next_tree","name":"$treearray","line":218,"kind":13},{"name":"$k","definition":"my","containerName":"next_tree","localvar":"my","kind":13,"line":219},{"name":"$n","containerName":"next_tree","line":220,"kind":13},{"kind":13,"line":220,"containerName":"next_tree","name":"$k"},{"kind":13,"line":221,"name":"$n","containerName":"next_tree"},{"line":221,"kind":13,"containerName":"next_tree","name":"$nodes"},{"line":221,"kind":13,"name":"$n","containerName":"next_tree"},{"containerName":"next_tree","name":"$k","line":221,"kind":13},{"name":"@nodes","containerName":"next_tree","kind":13,"line":223},{"name":"$nodetype","containerName":"next_tree","line":224,"kind":13},{"containerName":"next_tree","name":"new","line":224,"kind":12},{"name":"$n","containerName":"next_tree","line":224,"kind":13},{"kind":13,"line":225,"containerName":"next_tree","name":"$n"},{"kind":13,"line":226,"name":"$n","containerName":"next_tree"}],"line":197},{"localvar":"my","name":"$T","definition":"my","containerName":null,"line":229,"kind":13},{"kind":12,"line":229,"name":"Bio","containerName":"Tree::Tree"},{"containerName":"main::","name":"new","kind":12,"line":229},{"containerName":null,"name":"@nodes","kind":13,"line":229},{"name":"$T","containerName":null,"line":230,"kind":13},{"detail":"($self,$value)","signature":{"label":"maxcount($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: RandomFactory.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tree::RandomFactory\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::RandomFactory - TreeFactory for generating Random Trees\n\n=head1 SYNOPSIS\n\n  use Bio::Tree::RandomFactory\n  my @taxonnames;\n  my $factory = Bio::Tree::RandomFactory->new( -taxa => \\@taxonnames,\n  \t\t\t\t\t      -maxcount => 10);\n\n  # or for anonymous samples\n\n  my $factory = Bio::Tree::RandomFactory->new( -num_taxa => 6,\n\t\t\t\t\t      -maxcount => 50);\n\n\n  my $tree = $factory->next_tree;\n\n=head1 DESCRIPTION\n\nBuilds a random tree every time next_tree is called or up to -maxcount times.\n\nThis module was originally written for Coalescent simulations see\nL<Bio::PopGen::Simulation::Coalescent>.  I've left the next_tree\nmethod intact although it is not generating random trees in the\nphylogenetic sense.  I would be happy for someone to provide\nalternative implementations which can be used here.  As written it\nwill generate random topologies but the branch lengths are built from\nassumptions in the coalescent and are not appropriate for phylogenetic\nanalyses.\n\nThis algorithm is based on the make_tree algorithm from Richard Hudson 1990.\n\nHudson, R. R. 1990. Gene genealogies and the coalescent\n       process. Pp. 1-44 in D. Futuyma and J.  Antonovics, eds. Oxford\n       surveys in evolutionary biology. Vol. 7. Oxford University\n       Press, New York\n\nSanderson, M ... \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-AT-bioperl.org\n\n=head1 CONTRIBUTORS\n\nMatthew Hahn, E<lt>matthew.hahn@duke.eduE<gt>\nMike Sanderson \n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tree::RandomFactory;\nuse vars qw($PRECISION_DIGITS $DefaultNodeType %Defaults);\nuse strict;\n\n$PRECISION_DIGITS = 3; # Precision for the branchlength\n$DefaultNodeType = 'Bio::Tree::Node';\n%Defaults = ('YuleRate'          => 1.0, # as set by Sanderson in Rates\n\t     'Speciation'        => 1.0, #\n\t     'DefaultTreeMethod' => 'yule',\n\t     );\n\nuse Bio::Tools::RandomDistFunctions;\nuse Bio::Tree::Tree;\n\nuse base qw(Bio::Root::Root Bio::Factory::TreeFactoryI);\n\n=head2 new\n\n Title   : new\n Usage   : my $factory = Bio::Tree::RandomFactory->new(-samples => \\@samples,\n\t\t\t\t\t\t      -maxcount=> $N);\n Function: Initializes a Bio::Tree::RandomFactory object\n Returns : Bio::Tree::RandomFactory\n Args    : -nodetype => Type of Nodes to create [default Bio::Tree::Node]\n           -maxcount => [optional] Maximum num trees to create\n           -randtype => Type of random trees so far support\n               - yule/backward_yule/BY [default]\n               - forward_yule/FY\n               - birthdeath_forward/BDF\n               - birthdeath_backwards/BDB\n\n\n          ONE of the following must be specified\n           -taxa     => $arrayref of taxa names\n           -num_taxa => integer indicating number of taxa in the tree\n\n\nsub new{\n   my ($class,@args) = @_;\n   my $self = $class->SUPER::new(@args);\n   \n   $self->{'_treecounter'} = 0;\n   $self->{'_maxcount'} = 0;\n   my ($nodetype,$randtype,\n       $maxcount, $samps,$samplesize,\n       $taxa, $num_taxa) = $self->_rearrange([qw(NODETYPE\n\t\t\t\t\t\t RANDTYPE\n\t\t\t\t\t\t MAXCOUNT\n\t\t\t\t\t\t SAMPLES\n\t\t\t\t\t\t SAMPLE_SIZE\n\t\t\t\t\t\t TAXA\n\t\t\t\t\t\t NUM_TAXA)],\n\t\t\t\t\t     @args);\n   my @taxa;\n   $nodetype ||= $DefaultNodeType;\n   $self->nodetype($nodetype);\n   $taxa = $samps if defined $samps && ! defined $taxa;\n   $num_taxa = $samplesize if $samplesize && ! $num_taxa;\n   if( ! defined $taxa ) { \n       if( ! defined $num_taxa || $num_taxa <= 0 ) { \n\t   $self->throw(\"Must specify a valid num_taxa if parameter -TAXA is not specified\");\n       }\n       foreach ( 1..$num_taxa ) { push @taxa, \"Taxon$_\"; }      \n   } else { \n       if( ref($taxa) !~ /ARRAY/i ) { \n\t   $self->throw(\"Must specify a valid ARRAY reference to the parameter -TAXA, did you forget a leading '\\\\'? for $taxa\");\n       }\n       @taxa = @$taxa;\n   }\n   \n   $self->taxa(\\@taxa);\n   defined $maxcount && $self->maxcount($maxcount);   \n   $self->{'_count'} = 0;\n   return $self;\n}\n\n=head2 next_tree\n\n Title   : next_tree\n Usage   : my $tree = $factory->next_tree\n Function: Returns a random tree based on the initialized number of nodes\n           NOTE: if maxcount is not specified on initialization or\n                 set to a valid integer, subsequent calls to next_tree will \n                 continue to return random trees and never return undef\n\n Returns : Bio::Tree::TreeI object\n Args    : none\n\n\n\nsub next_tree{\n   my ($self,%options) = @_;\n   return if $self->maxcount && \n       $self->{'_count'}++ >= $self->maxcount;\n   my $rand_type = $options{'randtype'} || $self->random_tree_method;\n   my $nodetype = $self->nodetype;\n   my $treearray;\n\n   if( $rand_type =~ /(birthdeath_forward|birth|BDF)/i ) {\n\n   } elsif ( $rand_type =~ /(birthdeath_backward|BDB)/i ) {\n       $treearray = $self->rand_birthdeath_backwards_tree;       \n   } elsif( $rand_type =~ /(BY|backwards_yule)/i || \n\t    $rand_type =~ /^yule/i ) {\n       my $speciation = $options{'speciation'}; # can be undef\n       $treearray = $self->rand_yule_c_tree($speciation);       \n   } else { \n       $self->warn(\"unrecognized random type $rand_type\");\n   }\n   \n   my @nodes = ();   \n   foreach my $n ( @$treearray ) { \n       for my $k ( qw(desc1 desc2) ) {\n\t   next unless defined $n->{$k};\n\t   push @{$n->{'descendents'}}, $nodes[$n->{$k}];\n       }\n       push @nodes, \n       $nodetype->new(-id            => $n->{'nodenum'},\n\t\t      -branch_length => $n->{'time'},\n\t\t      -descendents   => $n->{'descendents'},\n\t\t      );\n   }\n   my $T = Bio::Tree::Tree->new(-root => pop @nodes );\n   return $T;\n}\n\n\n=head2 maxcount\n\n Title   : maxcount\n Usage   : $obj->maxcount($newval)\n Function: \n Returns : Maxcount value\n Args    : newvalue (optional)"},"containerName":"main::","definition":"sub","line":245,"children":[{"name":"$self","definition":"my","containerName":"maxcount","localvar":"my","kind":13,"line":246},{"name":"$value","containerName":"maxcount","line":246,"kind":13},{"containerName":"maxcount","name":"$value","line":247,"kind":13},{"containerName":"maxcount","name":"$value","kind":13,"line":248},{"containerName":"maxcount","name":"$self","line":249,"kind":13},{"kind":13,"line":251,"containerName":"maxcount","name":"$self"},{"name":"warn","containerName":"maxcount","line":251,"kind":12},{"line":252,"kind":13,"name":"$self","containerName":"maxcount"},{"kind":13,"line":255,"containerName":"maxcount","name":"$self"}],"kind":12,"range":{"end":{"character":9999,"line":256},"start":{"character":0,"line":245}},"name":"maxcount"},{"definition":"sub","name":"reset_count","containerName":"main::","range":{"end":{"character":9999,"line":272},"start":{"character":0,"line":270}},"kind":12,"children":[],"line":270},{"range":{"start":{"line":285,"character":0},"end":{"line":297,"character":9999}},"name":"taxa","line":285,"children":[{"line":286,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"taxa"},{"name":"$value","containerName":"taxa","line":286,"kind":13},{"name":"$value","containerName":"taxa","kind":13,"line":287},{"line":288,"kind":13,"containerName":"taxa","name":"$value"},{"containerName":"taxa","name":"$self","kind":13,"line":289},{"kind":12,"line":289,"name":"warn","containerName":"taxa"},{"line":290,"kind":13,"name":"$value","containerName":"taxa"},{"line":292,"kind":13,"name":"$self","containerName":"taxa"},{"kind":13,"line":292,"containerName":"taxa","name":"$value"},{"containerName":"taxa","name":"$self","kind":13,"line":293},{"name":"$value","containerName":"taxa","line":293,"kind":13},{"containerName":"taxa","name":"$self","kind":13,"line":295}],"kind":12,"detail":"($self,$value)","signature":{"label":"taxa($self,$value)","documentation":"1;\n# $Id: RandomFactory.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tree::RandomFactory\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::RandomFactory - TreeFactory for generating Random Trees\n\n=head1 SYNOPSIS\n\n  use Bio::Tree::RandomFactory\n  my @taxonnames;\n  my $factory = Bio::Tree::RandomFactory->new( -taxa => \\@taxonnames,\n  \t\t\t\t\t      -maxcount => 10);\n\n  # or for anonymous samples\n\n  my $factory = Bio::Tree::RandomFactory->new( -num_taxa => 6,\n\t\t\t\t\t      -maxcount => 50);\n\n\n  my $tree = $factory->next_tree;\n\n=head1 DESCRIPTION\n\nBuilds a random tree every time next_tree is called or up to -maxcount times.\n\nThis module was originally written for Coalescent simulations see\nL<Bio::PopGen::Simulation::Coalescent>.  I've left the next_tree\nmethod intact although it is not generating random trees in the\nphylogenetic sense.  I would be happy for someone to provide\nalternative implementations which can be used here.  As written it\nwill generate random topologies but the branch lengths are built from\nassumptions in the coalescent and are not appropriate for phylogenetic\nanalyses.\n\nThis algorithm is based on the make_tree algorithm from Richard Hudson 1990.\n\nHudson, R. R. 1990. Gene genealogies and the coalescent\n       process. Pp. 1-44 in D. Futuyma and J.  Antonovics, eds. Oxford\n       surveys in evolutionary biology. Vol. 7. Oxford University\n       Press, New York\n\nSanderson, M ... \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-AT-bioperl.org\n\n=head1 CONTRIBUTORS\n\nMatthew Hahn, E<lt>matthew.hahn@duke.eduE<gt>\nMike Sanderson \n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tree::RandomFactory;\nuse vars qw($PRECISION_DIGITS $DefaultNodeType %Defaults);\nuse strict;\n\n$PRECISION_DIGITS = 3; # Precision for the branchlength\n$DefaultNodeType = 'Bio::Tree::Node';\n%Defaults = ('YuleRate'          => 1.0, # as set by Sanderson in Rates\n\t     'Speciation'        => 1.0, #\n\t     'DefaultTreeMethod' => 'yule',\n\t     );\n\nuse Bio::Tools::RandomDistFunctions;\nuse Bio::Tree::Tree;\n\nuse base qw(Bio::Root::Root Bio::Factory::TreeFactoryI);\n\n=head2 new\n\n Title   : new\n Usage   : my $factory = Bio::Tree::RandomFactory->new(-samples => \\@samples,\n\t\t\t\t\t\t      -maxcount=> $N);\n Function: Initializes a Bio::Tree::RandomFactory object\n Returns : Bio::Tree::RandomFactory\n Args    : -nodetype => Type of Nodes to create [default Bio::Tree::Node]\n           -maxcount => [optional] Maximum num trees to create\n           -randtype => Type of random trees so far support\n               - yule/backward_yule/BY [default]\n               - forward_yule/FY\n               - birthdeath_forward/BDF\n               - birthdeath_backwards/BDB\n\n\n          ONE of the following must be specified\n           -taxa     => $arrayref of taxa names\n           -num_taxa => integer indicating number of taxa in the tree\n\n\nsub new{\n   my ($class,@args) = @_;\n   my $self = $class->SUPER::new(@args);\n   \n   $self->{'_treecounter'} = 0;\n   $self->{'_maxcount'} = 0;\n   my ($nodetype,$randtype,\n       $maxcount, $samps,$samplesize,\n       $taxa, $num_taxa) = $self->_rearrange([qw(NODETYPE\n\t\t\t\t\t\t RANDTYPE\n\t\t\t\t\t\t MAXCOUNT\n\t\t\t\t\t\t SAMPLES\n\t\t\t\t\t\t SAMPLE_SIZE\n\t\t\t\t\t\t TAXA\n\t\t\t\t\t\t NUM_TAXA)],\n\t\t\t\t\t     @args);\n   my @taxa;\n   $nodetype ||= $DefaultNodeType;\n   $self->nodetype($nodetype);\n   $taxa = $samps if defined $samps && ! defined $taxa;\n   $num_taxa = $samplesize if $samplesize && ! $num_taxa;\n   if( ! defined $taxa ) { \n       if( ! defined $num_taxa || $num_taxa <= 0 ) { \n\t   $self->throw(\"Must specify a valid num_taxa if parameter -TAXA is not specified\");\n       }\n       foreach ( 1..$num_taxa ) { push @taxa, \"Taxon$_\"; }      \n   } else { \n       if( ref($taxa) !~ /ARRAY/i ) { \n\t   $self->throw(\"Must specify a valid ARRAY reference to the parameter -TAXA, did you forget a leading '\\\\'? for $taxa\");\n       }\n       @taxa = @$taxa;\n   }\n   \n   $self->taxa(\\@taxa);\n   defined $maxcount && $self->maxcount($maxcount);   \n   $self->{'_count'} = 0;\n   return $self;\n}\n\n=head2 next_tree\n\n Title   : next_tree\n Usage   : my $tree = $factory->next_tree\n Function: Returns a random tree based on the initialized number of nodes\n           NOTE: if maxcount is not specified on initialization or\n                 set to a valid integer, subsequent calls to next_tree will \n                 continue to return random trees and never return undef\n\n Returns : Bio::Tree::TreeI object\n Args    : none\n\n\n\nsub next_tree{\n   my ($self,%options) = @_;\n   return if $self->maxcount && \n       $self->{'_count'}++ >= $self->maxcount;\n   my $rand_type = $options{'randtype'} || $self->random_tree_method;\n   my $nodetype = $self->nodetype;\n   my $treearray;\n\n   if( $rand_type =~ /(birthdeath_forward|birth|BDF)/i ) {\n\n   } elsif ( $rand_type =~ /(birthdeath_backward|BDB)/i ) {\n       $treearray = $self->rand_birthdeath_backwards_tree;       \n   } elsif( $rand_type =~ /(BY|backwards_yule)/i || \n\t    $rand_type =~ /^yule/i ) {\n       my $speciation = $options{'speciation'}; # can be undef\n       $treearray = $self->rand_yule_c_tree($speciation);       \n   } else { \n       $self->warn(\"unrecognized random type $rand_type\");\n   }\n   \n   my @nodes = ();   \n   foreach my $n ( @$treearray ) { \n       for my $k ( qw(desc1 desc2) ) {\n\t   next unless defined $n->{$k};\n\t   push @{$n->{'descendents'}}, $nodes[$n->{$k}];\n       }\n       push @nodes, \n       $nodetype->new(-id            => $n->{'nodenum'},\n\t\t      -branch_length => $n->{'time'},\n\t\t      -descendents   => $n->{'descendents'},\n\t\t      );\n   }\n   my $T = Bio::Tree::Tree->new(-root => pop @nodes );\n   return $T;\n}\n\n\n=head2 maxcount\n\n Title   : maxcount\n Usage   : $obj->maxcount($newval)\n Function: \n Returns : Maxcount value\n Args    : newvalue (optional)\n\n\n\nsub maxcount{\n   my ($self,$value) = @_;\n   if( defined $value) {\n       if( $value =~ /^(\\d+)/ ) { \n\t   $self->{'_maxcount'} = $1;\n       } else { \n\t   $self->warn(\"Must specify a valid Positive integer to maxcount\");\n\t   $self->{'_maxcount'} = 0;\n       }\n  }\n   return $self->{'_maxcount'};\n}\n\n\n=head2 reset_tree_count\n\n Title   : reset_tree_count\n Usage   : $factory->reset_tree_count;\n Function: Reset the tree counter\n Returns : none\n Args    : none\n\n\n\nsub reset_count{\n    shift->{'_count'} = 0;\n}\n\n=head2 taxa\n\n Title   : taxa\n Usage   : $obj->taxa($newval)\n Function: Set the leaf node names\n Returns : value of taxa\n Args    : Arrayref of Taxon names","parameters":[{"label":"$self"},{"label":"$value"}]},"containerName":"main::","definition":"sub"},{"range":{"end":{"character":9999,"line":313},"start":{"character":0,"line":310}},"name":"num_taxa","children":[{"line":311,"kind":13,"localvar":"my","containerName":"num_taxa","name":"$self","definition":"my"},{"name":"$self","containerName":"num_taxa","kind":13,"line":312}],"line":310,"kind":12,"signature":{"documentation":"1;\n# $Id: RandomFactory.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tree::RandomFactory\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::RandomFactory - TreeFactory for generating Random Trees\n\n=head1 SYNOPSIS\n\n  use Bio::Tree::RandomFactory\n  my @taxonnames;\n  my $factory = Bio::Tree::RandomFactory->new( -taxa => \\@taxonnames,\n  \t\t\t\t\t      -maxcount => 10);\n\n  # or for anonymous samples\n\n  my $factory = Bio::Tree::RandomFactory->new( -num_taxa => 6,\n\t\t\t\t\t      -maxcount => 50);\n\n\n  my $tree = $factory->next_tree;\n\n=head1 DESCRIPTION\n\nBuilds a random tree every time next_tree is called or up to -maxcount times.\n\nThis module was originally written for Coalescent simulations see\nL<Bio::PopGen::Simulation::Coalescent>.  I've left the next_tree\nmethod intact although it is not generating random trees in the\nphylogenetic sense.  I would be happy for someone to provide\nalternative implementations which can be used here.  As written it\nwill generate random topologies but the branch lengths are built from\nassumptions in the coalescent and are not appropriate for phylogenetic\nanalyses.\n\nThis algorithm is based on the make_tree algorithm from Richard Hudson 1990.\n\nHudson, R. R. 1990. Gene genealogies and the coalescent\n       process. Pp. 1-44 in D. Futuyma and J.  Antonovics, eds. Oxford\n       surveys in evolutionary biology. Vol. 7. Oxford University\n       Press, New York\n\nSanderson, M ... \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-AT-bioperl.org\n\n=head1 CONTRIBUTORS\n\nMatthew Hahn, E<lt>matthew.hahn@duke.eduE<gt>\nMike Sanderson \n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tree::RandomFactory;\nuse vars qw($PRECISION_DIGITS $DefaultNodeType %Defaults);\nuse strict;\n\n$PRECISION_DIGITS = 3; # Precision for the branchlength\n$DefaultNodeType = 'Bio::Tree::Node';\n%Defaults = ('YuleRate'          => 1.0, # as set by Sanderson in Rates\n\t     'Speciation'        => 1.0, #\n\t     'DefaultTreeMethod' => 'yule',\n\t     );\n\nuse Bio::Tools::RandomDistFunctions;\nuse Bio::Tree::Tree;\n\nuse base qw(Bio::Root::Root Bio::Factory::TreeFactoryI);\n\n=head2 new\n\n Title   : new\n Usage   : my $factory = Bio::Tree::RandomFactory->new(-samples => \\@samples,\n\t\t\t\t\t\t      -maxcount=> $N);\n Function: Initializes a Bio::Tree::RandomFactory object\n Returns : Bio::Tree::RandomFactory\n Args    : -nodetype => Type of Nodes to create [default Bio::Tree::Node]\n           -maxcount => [optional] Maximum num trees to create\n           -randtype => Type of random trees so far support\n               - yule/backward_yule/BY [default]\n               - forward_yule/FY\n               - birthdeath_forward/BDF\n               - birthdeath_backwards/BDB\n\n\n          ONE of the following must be specified\n           -taxa     => $arrayref of taxa names\n           -num_taxa => integer indicating number of taxa in the tree\n\n\nsub new{\n   my ($class,@args) = @_;\n   my $self = $class->SUPER::new(@args);\n   \n   $self->{'_treecounter'} = 0;\n   $self->{'_maxcount'} = 0;\n   my ($nodetype,$randtype,\n       $maxcount, $samps,$samplesize,\n       $taxa, $num_taxa) = $self->_rearrange([qw(NODETYPE\n\t\t\t\t\t\t RANDTYPE\n\t\t\t\t\t\t MAXCOUNT\n\t\t\t\t\t\t SAMPLES\n\t\t\t\t\t\t SAMPLE_SIZE\n\t\t\t\t\t\t TAXA\n\t\t\t\t\t\t NUM_TAXA)],\n\t\t\t\t\t     @args);\n   my @taxa;\n   $nodetype ||= $DefaultNodeType;\n   $self->nodetype($nodetype);\n   $taxa = $samps if defined $samps && ! defined $taxa;\n   $num_taxa = $samplesize if $samplesize && ! $num_taxa;\n   if( ! defined $taxa ) { \n       if( ! defined $num_taxa || $num_taxa <= 0 ) { \n\t   $self->throw(\"Must specify a valid num_taxa if parameter -TAXA is not specified\");\n       }\n       foreach ( 1..$num_taxa ) { push @taxa, \"Taxon$_\"; }      \n   } else { \n       if( ref($taxa) !~ /ARRAY/i ) { \n\t   $self->throw(\"Must specify a valid ARRAY reference to the parameter -TAXA, did you forget a leading '\\\\'? for $taxa\");\n       }\n       @taxa = @$taxa;\n   }\n   \n   $self->taxa(\\@taxa);\n   defined $maxcount && $self->maxcount($maxcount);   \n   $self->{'_count'} = 0;\n   return $self;\n}\n\n=head2 next_tree\n\n Title   : next_tree\n Usage   : my $tree = $factory->next_tree\n Function: Returns a random tree based on the initialized number of nodes\n           NOTE: if maxcount is not specified on initialization or\n                 set to a valid integer, subsequent calls to next_tree will \n                 continue to return random trees and never return undef\n\n Returns : Bio::Tree::TreeI object\n Args    : none\n\n\n\nsub next_tree{\n   my ($self,%options) = @_;\n   return if $self->maxcount && \n       $self->{'_count'}++ >= $self->maxcount;\n   my $rand_type = $options{'randtype'} || $self->random_tree_method;\n   my $nodetype = $self->nodetype;\n   my $treearray;\n\n   if( $rand_type =~ /(birthdeath_forward|birth|BDF)/i ) {\n\n   } elsif ( $rand_type =~ /(birthdeath_backward|BDB)/i ) {\n       $treearray = $self->rand_birthdeath_backwards_tree;       \n   } elsif( $rand_type =~ /(BY|backwards_yule)/i || \n\t    $rand_type =~ /^yule/i ) {\n       my $speciation = $options{'speciation'}; # can be undef\n       $treearray = $self->rand_yule_c_tree($speciation);       \n   } else { \n       $self->warn(\"unrecognized random type $rand_type\");\n   }\n   \n   my @nodes = ();   \n   foreach my $n ( @$treearray ) { \n       for my $k ( qw(desc1 desc2) ) {\n\t   next unless defined $n->{$k};\n\t   push @{$n->{'descendents'}}, $nodes[$n->{$k}];\n       }\n       push @nodes, \n       $nodetype->new(-id            => $n->{'nodenum'},\n\t\t      -branch_length => $n->{'time'},\n\t\t      -descendents   => $n->{'descendents'},\n\t\t      );\n   }\n   my $T = Bio::Tree::Tree->new(-root => pop @nodes );\n   return $T;\n}\n\n\n=head2 maxcount\n\n Title   : maxcount\n Usage   : $obj->maxcount($newval)\n Function: \n Returns : Maxcount value\n Args    : newvalue (optional)\n\n\n\nsub maxcount{\n   my ($self,$value) = @_;\n   if( defined $value) {\n       if( $value =~ /^(\\d+)/ ) { \n\t   $self->{'_maxcount'} = $1;\n       } else { \n\t   $self->warn(\"Must specify a valid Positive integer to maxcount\");\n\t   $self->{'_maxcount'} = 0;\n       }\n  }\n   return $self->{'_maxcount'};\n}\n\n\n=head2 reset_tree_count\n\n Title   : reset_tree_count\n Usage   : $factory->reset_tree_count;\n Function: Reset the tree counter\n Returns : none\n Args    : none\n\n\n\nsub reset_count{\n    shift->{'_count'} = 0;\n}\n\n=head2 taxa\n\n Title   : taxa\n Usage   : $obj->taxa($newval)\n Function: Set the leaf node names\n Returns : value of taxa\n Args    : Arrayref of Taxon names\n\n\n\nsub taxa {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\tif( ref($value) !~ /ARRAY/i ) { \n\t    $self->warn(\"Must specify a valid array ref to the method 'taxa'\");\n\t    $value = [];\n\t} \n\t$self->{'_taxa'} = $value;\n\t$self->{'_num_taxa'} = scalar @$value;\n    }\n    return $self->{'_taxa'};\n\n}\n\n=head2 num_taxa\n\n Title   : num_taxa\n Usage   : $obj->num_taxa($newval)\n Function: Get the number of Taxa\n Returns : value of num_taxa\n Args    : none","parameters":[{"label":"$self"}],"label":"num_taxa($self)"},"detail":"($self)","definition":"sub","containerName":"main::"},{"children":[{"localvar":"my","containerName":"random","definition":"my","name":"$self","line":333,"kind":13},{"kind":13,"line":333,"name":"$max","containerName":"random"},{"containerName":"random","name":"$max","line":334,"kind":13}],"line":332,"kind":12,"signature":{"parameters":[{"label":"$self"},{"label":"$max"}],"documentation":"1;\n# $Id: RandomFactory.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tree::RandomFactory\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::RandomFactory - TreeFactory for generating Random Trees\n\n=head1 SYNOPSIS\n\n  use Bio::Tree::RandomFactory\n  my @taxonnames;\n  my $factory = Bio::Tree::RandomFactory->new( -taxa => \\@taxonnames,\n  \t\t\t\t\t      -maxcount => 10);\n\n  # or for anonymous samples\n\n  my $factory = Bio::Tree::RandomFactory->new( -num_taxa => 6,\n\t\t\t\t\t      -maxcount => 50);\n\n\n  my $tree = $factory->next_tree;\n\n=head1 DESCRIPTION\n\nBuilds a random tree every time next_tree is called or up to -maxcount times.\n\nThis module was originally written for Coalescent simulations see\nL<Bio::PopGen::Simulation::Coalescent>.  I've left the next_tree\nmethod intact although it is not generating random trees in the\nphylogenetic sense.  I would be happy for someone to provide\nalternative implementations which can be used here.  As written it\nwill generate random topologies but the branch lengths are built from\nassumptions in the coalescent and are not appropriate for phylogenetic\nanalyses.\n\nThis algorithm is based on the make_tree algorithm from Richard Hudson 1990.\n\nHudson, R. R. 1990. Gene genealogies and the coalescent\n       process. Pp. 1-44 in D. Futuyma and J.  Antonovics, eds. Oxford\n       surveys in evolutionary biology. Vol. 7. Oxford University\n       Press, New York\n\nSanderson, M ... \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-AT-bioperl.org\n\n=head1 CONTRIBUTORS\n\nMatthew Hahn, E<lt>matthew.hahn@duke.eduE<gt>\nMike Sanderson \n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tree::RandomFactory;\nuse vars qw($PRECISION_DIGITS $DefaultNodeType %Defaults);\nuse strict;\n\n$PRECISION_DIGITS = 3; # Precision for the branchlength\n$DefaultNodeType = 'Bio::Tree::Node';\n%Defaults = ('YuleRate'          => 1.0, # as set by Sanderson in Rates\n\t     'Speciation'        => 1.0, #\n\t     'DefaultTreeMethod' => 'yule',\n\t     );\n\nuse Bio::Tools::RandomDistFunctions;\nuse Bio::Tree::Tree;\n\nuse base qw(Bio::Root::Root Bio::Factory::TreeFactoryI);\n\n=head2 new\n\n Title   : new\n Usage   : my $factory = Bio::Tree::RandomFactory->new(-samples => \\@samples,\n\t\t\t\t\t\t      -maxcount=> $N);\n Function: Initializes a Bio::Tree::RandomFactory object\n Returns : Bio::Tree::RandomFactory\n Args    : -nodetype => Type of Nodes to create [default Bio::Tree::Node]\n           -maxcount => [optional] Maximum num trees to create\n           -randtype => Type of random trees so far support\n               - yule/backward_yule/BY [default]\n               - forward_yule/FY\n               - birthdeath_forward/BDF\n               - birthdeath_backwards/BDB\n\n\n          ONE of the following must be specified\n           -taxa     => $arrayref of taxa names\n           -num_taxa => integer indicating number of taxa in the tree\n\n\nsub new{\n   my ($class,@args) = @_;\n   my $self = $class->SUPER::new(@args);\n   \n   $self->{'_treecounter'} = 0;\n   $self->{'_maxcount'} = 0;\n   my ($nodetype,$randtype,\n       $maxcount, $samps,$samplesize,\n       $taxa, $num_taxa) = $self->_rearrange([qw(NODETYPE\n\t\t\t\t\t\t RANDTYPE\n\t\t\t\t\t\t MAXCOUNT\n\t\t\t\t\t\t SAMPLES\n\t\t\t\t\t\t SAMPLE_SIZE\n\t\t\t\t\t\t TAXA\n\t\t\t\t\t\t NUM_TAXA)],\n\t\t\t\t\t     @args);\n   my @taxa;\n   $nodetype ||= $DefaultNodeType;\n   $self->nodetype($nodetype);\n   $taxa = $samps if defined $samps && ! defined $taxa;\n   $num_taxa = $samplesize if $samplesize && ! $num_taxa;\n   if( ! defined $taxa ) { \n       if( ! defined $num_taxa || $num_taxa <= 0 ) { \n\t   $self->throw(\"Must specify a valid num_taxa if parameter -TAXA is not specified\");\n       }\n       foreach ( 1..$num_taxa ) { push @taxa, \"Taxon$_\"; }      \n   } else { \n       if( ref($taxa) !~ /ARRAY/i ) { \n\t   $self->throw(\"Must specify a valid ARRAY reference to the parameter -TAXA, did you forget a leading '\\\\'? for $taxa\");\n       }\n       @taxa = @$taxa;\n   }\n   \n   $self->taxa(\\@taxa);\n   defined $maxcount && $self->maxcount($maxcount);   \n   $self->{'_count'} = 0;\n   return $self;\n}\n\n=head2 next_tree\n\n Title   : next_tree\n Usage   : my $tree = $factory->next_tree\n Function: Returns a random tree based on the initialized number of nodes\n           NOTE: if maxcount is not specified on initialization or\n                 set to a valid integer, subsequent calls to next_tree will \n                 continue to return random trees and never return undef\n\n Returns : Bio::Tree::TreeI object\n Args    : none\n\n\n\nsub next_tree{\n   my ($self,%options) = @_;\n   return if $self->maxcount && \n       $self->{'_count'}++ >= $self->maxcount;\n   my $rand_type = $options{'randtype'} || $self->random_tree_method;\n   my $nodetype = $self->nodetype;\n   my $treearray;\n\n   if( $rand_type =~ /(birthdeath_forward|birth|BDF)/i ) {\n\n   } elsif ( $rand_type =~ /(birthdeath_backward|BDB)/i ) {\n       $treearray = $self->rand_birthdeath_backwards_tree;       \n   } elsif( $rand_type =~ /(BY|backwards_yule)/i || \n\t    $rand_type =~ /^yule/i ) {\n       my $speciation = $options{'speciation'}; # can be undef\n       $treearray = $self->rand_yule_c_tree($speciation);       \n   } else { \n       $self->warn(\"unrecognized random type $rand_type\");\n   }\n   \n   my @nodes = ();   \n   foreach my $n ( @$treearray ) { \n       for my $k ( qw(desc1 desc2) ) {\n\t   next unless defined $n->{$k};\n\t   push @{$n->{'descendents'}}, $nodes[$n->{$k}];\n       }\n       push @nodes, \n       $nodetype->new(-id            => $n->{'nodenum'},\n\t\t      -branch_length => $n->{'time'},\n\t\t      -descendents   => $n->{'descendents'},\n\t\t      );\n   }\n   my $T = Bio::Tree::Tree->new(-root => pop @nodes );\n   return $T;\n}\n\n\n=head2 maxcount\n\n Title   : maxcount\n Usage   : $obj->maxcount($newval)\n Function: \n Returns : Maxcount value\n Args    : newvalue (optional)\n\n\n\nsub maxcount{\n   my ($self,$value) = @_;\n   if( defined $value) {\n       if( $value =~ /^(\\d+)/ ) { \n\t   $self->{'_maxcount'} = $1;\n       } else { \n\t   $self->warn(\"Must specify a valid Positive integer to maxcount\");\n\t   $self->{'_maxcount'} = 0;\n       }\n  }\n   return $self->{'_maxcount'};\n}\n\n\n=head2 reset_tree_count\n\n Title   : reset_tree_count\n Usage   : $factory->reset_tree_count;\n Function: Reset the tree counter\n Returns : none\n Args    : none\n\n\n\nsub reset_count{\n    shift->{'_count'} = 0;\n}\n\n=head2 taxa\n\n Title   : taxa\n Usage   : $obj->taxa($newval)\n Function: Set the leaf node names\n Returns : value of taxa\n Args    : Arrayref of Taxon names\n\n\n\nsub taxa {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\tif( ref($value) !~ /ARRAY/i ) { \n\t    $self->warn(\"Must specify a valid array ref to the method 'taxa'\");\n\t    $value = [];\n\t} \n\t$self->{'_taxa'} = $value;\n\t$self->{'_num_taxa'} = scalar @$value;\n    }\n    return $self->{'_taxa'};\n\n}\n\n=head2 num_taxa\n\n Title   : num_taxa\n Usage   : $obj->num_taxa($newval)\n Function: Get the number of Taxa\n Returns : value of num_taxa\n Args    : none\n\n\n\nsub num_taxa {\n    my ($self) = @_;\n    return  $self->{'_num_taxa'};\n}\n\n# alias old methods\n*num_samples = \\&num_taxa;\n*samples = \\&taxa;\n\n=head2 random\n\n Title   : random\n Usage   : my $rfloat = $node->random($size)\n Function: Generates a random number between 0 and $size\n           This is abstracted so that someone can override and provide their\n           own special RNG.  This is expected to be a uniform RNG.\n Returns : Floating point random\n Args    : $maximum size for random number (defaults to 1)","label":"random($self,$max)"},"detail":"($self,$max)","definition":"sub","containerName":"main::","range":{"start":{"character":0,"line":332},"end":{"line":335,"character":9999}},"name":"random"},{"kind":12,"line":350,"children":[{"localvar":"my","containerName":"random_tree_method","definition":"my","name":"$self","line":351,"kind":13},{"kind":13,"line":353,"containerName":"random_tree_method","name":"$self"},{"containerName":"random_tree_method","name":"$self","line":354,"kind":13},{"line":354,"kind":13,"containerName":"random_tree_method","name":"$Defaults"}],"containerName":"main::","name":"random_tree_method","definition":"sub","range":{"start":{"character":0,"line":350},"end":{"line":355,"character":9999}}},{"name":"nodetype","range":{"start":{"line":369,"character":0},"end":{"line":383,"character":9999}},"containerName":"main::","definition":"sub","detail":"($self,$value)","signature":{"documentation":"1;\n# $Id: RandomFactory.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tree::RandomFactory\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::RandomFactory - TreeFactory for generating Random Trees\n\n=head1 SYNOPSIS\n\n  use Bio::Tree::RandomFactory\n  my @taxonnames;\n  my $factory = Bio::Tree::RandomFactory->new( -taxa => \\@taxonnames,\n  \t\t\t\t\t      -maxcount => 10);\n\n  # or for anonymous samples\n\n  my $factory = Bio::Tree::RandomFactory->new( -num_taxa => 6,\n\t\t\t\t\t      -maxcount => 50);\n\n\n  my $tree = $factory->next_tree;\n\n=head1 DESCRIPTION\n\nBuilds a random tree every time next_tree is called or up to -maxcount times.\n\nThis module was originally written for Coalescent simulations see\nL<Bio::PopGen::Simulation::Coalescent>.  I've left the next_tree\nmethod intact although it is not generating random trees in the\nphylogenetic sense.  I would be happy for someone to provide\nalternative implementations which can be used here.  As written it\nwill generate random topologies but the branch lengths are built from\nassumptions in the coalescent and are not appropriate for phylogenetic\nanalyses.\n\nThis algorithm is based on the make_tree algorithm from Richard Hudson 1990.\n\nHudson, R. R. 1990. Gene genealogies and the coalescent\n       process. Pp. 1-44 in D. Futuyma and J.  Antonovics, eds. Oxford\n       surveys in evolutionary biology. Vol. 7. Oxford University\n       Press, New York\n\nSanderson, M ... \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-AT-bioperl.org\n\n=head1 CONTRIBUTORS\n\nMatthew Hahn, E<lt>matthew.hahn@duke.eduE<gt>\nMike Sanderson \n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tree::RandomFactory;\nuse vars qw($PRECISION_DIGITS $DefaultNodeType %Defaults);\nuse strict;\n\n$PRECISION_DIGITS = 3; # Precision for the branchlength\n$DefaultNodeType = 'Bio::Tree::Node';\n%Defaults = ('YuleRate'          => 1.0, # as set by Sanderson in Rates\n\t     'Speciation'        => 1.0, #\n\t     'DefaultTreeMethod' => 'yule',\n\t     );\n\nuse Bio::Tools::RandomDistFunctions;\nuse Bio::Tree::Tree;\n\nuse base qw(Bio::Root::Root Bio::Factory::TreeFactoryI);\n\n=head2 new\n\n Title   : new\n Usage   : my $factory = Bio::Tree::RandomFactory->new(-samples => \\@samples,\n\t\t\t\t\t\t      -maxcount=> $N);\n Function: Initializes a Bio::Tree::RandomFactory object\n Returns : Bio::Tree::RandomFactory\n Args    : -nodetype => Type of Nodes to create [default Bio::Tree::Node]\n           -maxcount => [optional] Maximum num trees to create\n           -randtype => Type of random trees so far support\n               - yule/backward_yule/BY [default]\n               - forward_yule/FY\n               - birthdeath_forward/BDF\n               - birthdeath_backwards/BDB\n\n\n          ONE of the following must be specified\n           -taxa     => $arrayref of taxa names\n           -num_taxa => integer indicating number of taxa in the tree\n\n\nsub new{\n   my ($class,@args) = @_;\n   my $self = $class->SUPER::new(@args);\n   \n   $self->{'_treecounter'} = 0;\n   $self->{'_maxcount'} = 0;\n   my ($nodetype,$randtype,\n       $maxcount, $samps,$samplesize,\n       $taxa, $num_taxa) = $self->_rearrange([qw(NODETYPE\n\t\t\t\t\t\t RANDTYPE\n\t\t\t\t\t\t MAXCOUNT\n\t\t\t\t\t\t SAMPLES\n\t\t\t\t\t\t SAMPLE_SIZE\n\t\t\t\t\t\t TAXA\n\t\t\t\t\t\t NUM_TAXA)],\n\t\t\t\t\t     @args);\n   my @taxa;\n   $nodetype ||= $DefaultNodeType;\n   $self->nodetype($nodetype);\n   $taxa = $samps if defined $samps && ! defined $taxa;\n   $num_taxa = $samplesize if $samplesize && ! $num_taxa;\n   if( ! defined $taxa ) { \n       if( ! defined $num_taxa || $num_taxa <= 0 ) { \n\t   $self->throw(\"Must specify a valid num_taxa if parameter -TAXA is not specified\");\n       }\n       foreach ( 1..$num_taxa ) { push @taxa, \"Taxon$_\"; }      \n   } else { \n       if( ref($taxa) !~ /ARRAY/i ) { \n\t   $self->throw(\"Must specify a valid ARRAY reference to the parameter -TAXA, did you forget a leading '\\\\'? for $taxa\");\n       }\n       @taxa = @$taxa;\n   }\n   \n   $self->taxa(\\@taxa);\n   defined $maxcount && $self->maxcount($maxcount);   \n   $self->{'_count'} = 0;\n   return $self;\n}\n\n=head2 next_tree\n\n Title   : next_tree\n Usage   : my $tree = $factory->next_tree\n Function: Returns a random tree based on the initialized number of nodes\n           NOTE: if maxcount is not specified on initialization or\n                 set to a valid integer, subsequent calls to next_tree will \n                 continue to return random trees and never return undef\n\n Returns : Bio::Tree::TreeI object\n Args    : none\n\n\n\nsub next_tree{\n   my ($self,%options) = @_;\n   return if $self->maxcount && \n       $self->{'_count'}++ >= $self->maxcount;\n   my $rand_type = $options{'randtype'} || $self->random_tree_method;\n   my $nodetype = $self->nodetype;\n   my $treearray;\n\n   if( $rand_type =~ /(birthdeath_forward|birth|BDF)/i ) {\n\n   } elsif ( $rand_type =~ /(birthdeath_backward|BDB)/i ) {\n       $treearray = $self->rand_birthdeath_backwards_tree;       \n   } elsif( $rand_type =~ /(BY|backwards_yule)/i || \n\t    $rand_type =~ /^yule/i ) {\n       my $speciation = $options{'speciation'}; # can be undef\n       $treearray = $self->rand_yule_c_tree($speciation);       \n   } else { \n       $self->warn(\"unrecognized random type $rand_type\");\n   }\n   \n   my @nodes = ();   \n   foreach my $n ( @$treearray ) { \n       for my $k ( qw(desc1 desc2) ) {\n\t   next unless defined $n->{$k};\n\t   push @{$n->{'descendents'}}, $nodes[$n->{$k}];\n       }\n       push @nodes, \n       $nodetype->new(-id            => $n->{'nodenum'},\n\t\t      -branch_length => $n->{'time'},\n\t\t      -descendents   => $n->{'descendents'},\n\t\t      );\n   }\n   my $T = Bio::Tree::Tree->new(-root => pop @nodes );\n   return $T;\n}\n\n\n=head2 maxcount\n\n Title   : maxcount\n Usage   : $obj->maxcount($newval)\n Function: \n Returns : Maxcount value\n Args    : newvalue (optional)\n\n\n\nsub maxcount{\n   my ($self,$value) = @_;\n   if( defined $value) {\n       if( $value =~ /^(\\d+)/ ) { \n\t   $self->{'_maxcount'} = $1;\n       } else { \n\t   $self->warn(\"Must specify a valid Positive integer to maxcount\");\n\t   $self->{'_maxcount'} = 0;\n       }\n  }\n   return $self->{'_maxcount'};\n}\n\n\n=head2 reset_tree_count\n\n Title   : reset_tree_count\n Usage   : $factory->reset_tree_count;\n Function: Reset the tree counter\n Returns : none\n Args    : none\n\n\n\nsub reset_count{\n    shift->{'_count'} = 0;\n}\n\n=head2 taxa\n\n Title   : taxa\n Usage   : $obj->taxa($newval)\n Function: Set the leaf node names\n Returns : value of taxa\n Args    : Arrayref of Taxon names\n\n\n\nsub taxa {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\tif( ref($value) !~ /ARRAY/i ) { \n\t    $self->warn(\"Must specify a valid array ref to the method 'taxa'\");\n\t    $value = [];\n\t} \n\t$self->{'_taxa'} = $value;\n\t$self->{'_num_taxa'} = scalar @$value;\n    }\n    return $self->{'_taxa'};\n\n}\n\n=head2 num_taxa\n\n Title   : num_taxa\n Usage   : $obj->num_taxa($newval)\n Function: Get the number of Taxa\n Returns : value of num_taxa\n Args    : none\n\n\n\nsub num_taxa {\n    my ($self) = @_;\n    return  $self->{'_num_taxa'};\n}\n\n# alias old methods\n*num_samples = \\&num_taxa;\n*samples = \\&taxa;\n\n=head2 random\n\n Title   : random\n Usage   : my $rfloat = $node->random($size)\n Function: Generates a random number between 0 and $size\n           This is abstracted so that someone can override and provide their\n           own special RNG.  This is expected to be a uniform RNG.\n Returns : Floating point random\n Args    : $maximum size for random number (defaults to 1)\n\n\n\nsub random{\n   my ($self,$max) = @_;\n   return rand($max);\n}\n\n\n=head2 random_tree_method\n\n Title   : random_tree_method\n Usage   : $obj->random_tree_method($newval)\n Function: \n Example : \n Returns : value of random_tree_method (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub random_tree_method{\n    my $self = shift;\n\n    return $self->{'random_tree_method'} = shift if @_;\n    return $self->{'random_tree_method'} || $Defaults{'DefaultTreeMethod'};\n}\n\n=head2 nodetype\n\n Title   : nodetype\n Usage   : $obj->nodetype($newval)\n Function: \n Example : \n Returns : value of nodetype (a scalar)\n Args    : on set, new value (a scalar or undef, optional)","parameters":[{"label":"$self"},{"label":"$value"}],"label":"nodetype($self,$value)"},"kind":12,"line":369,"children":[{"localvar":"my","containerName":"nodetype","definition":"my","name":"$self","line":370,"kind":13},{"kind":13,"line":370,"name":"$value","containerName":"nodetype"},{"containerName":"nodetype","name":"$value","kind":13,"line":371},{"kind":13,"line":373,"containerName":"nodetype","name":"$self"},{"name":"throw","containerName":"nodetype","line":373,"kind":12},{"name":"$self","containerName":"nodetype","line":373,"kind":13},{"line":376,"kind":13,"localvar":"my","definition":"my","name":"$a","containerName":"nodetype"},{"kind":13,"line":376,"name":"$value","containerName":"nodetype"},{"name":"$a","containerName":"nodetype","line":377,"kind":13},{"line":377,"kind":12,"name":"isa","containerName":"nodetype"},{"kind":13,"line":378,"name":"$self","containerName":"nodetype"},{"containerName":"nodetype","name":"throw","line":378,"kind":12},{"line":380,"kind":13,"containerName":"nodetype","name":"$self"},{"line":380,"kind":13,"containerName":"nodetype","name":"$value"},{"line":382,"kind":13,"containerName":"nodetype","name":"$self"}]},{"detail":"($self,$speciation)","signature":{"parameters":[{"label":"$self"},{"label":"$speciation"}],"documentation":" The assignment of times are based on Mike Sanderson's r8s code\n The topology assignment code is based on Richard Hudson's\n make_trees","label":"rand_yule_c_tree($self,$speciation)"},"containerName":"main::","definition":"sub","line":391,"children":[{"containerName":"rand_yule_c_tree","name":"$self","definition":"my","localvar":"my","kind":13,"line":392},{"line":392,"kind":13,"containerName":"rand_yule_c_tree","name":"$speciation"},{"name":"$speciation","containerName":"rand_yule_c_tree","kind":13,"line":393},{"name":"$Defaults","containerName":"rand_yule_c_tree","line":393,"kind":13},{"localvar":"my","definition":"my","name":"$n_taxa","containerName":"rand_yule_c_tree","line":394,"kind":13},{"line":394,"kind":13,"name":"$self","containerName":"rand_yule_c_tree"},{"kind":12,"line":394,"name":"num_taxa","containerName":"rand_yule_c_tree"},{"localvar":"my","name":"$taxa","definition":"my","containerName":"rand_yule_c_tree","line":395,"kind":13},{"name":"$self","containerName":"rand_yule_c_tree","kind":13,"line":395},{"line":395,"kind":12,"containerName":"rand_yule_c_tree","name":"taxa"},{"localvar":"my","containerName":"rand_yule_c_tree","definition":"my","name":"$nodetype","line":396,"kind":13},{"name":"$self","containerName":"rand_yule_c_tree","kind":13,"line":396},{"name":"nodetype","containerName":"rand_yule_c_tree","line":396,"kind":12},{"kind":13,"line":398,"containerName":"rand_yule_c_tree","name":"$randfuncs","definition":"my","localvar":"my"},{"line":398,"kind":12,"containerName":"rand_yule_c_tree","name":"new"},{"kind":13,"line":399,"definition":"my","name":"$rate","containerName":"rand_yule_c_tree","localvar":"my"},{"name":"$Defaults","containerName":"rand_yule_c_tree","kind":13,"line":399},{"kind":13,"line":400,"containerName":"rand_yule_c_tree","definition":"my","name":"@tree","localvar":"my"},{"name":"@list","containerName":"rand_yule_c_tree","line":400,"kind":13},{"name":"@times","containerName":"rand_yule_c_tree","kind":13,"line":400},{"kind":13,"line":400,"containerName":"rand_yule_c_tree","name":"$i"},{"name":"$in","containerName":"rand_yule_c_tree","line":400,"kind":13},{"kind":13,"line":401,"name":"$max","definition":"my","containerName":"rand_yule_c_tree","localvar":"my"},{"containerName":"rand_yule_c_tree","name":"$n_taxa","kind":13,"line":401},{"name":"$in","containerName":"rand_yule_c_tree","kind":13,"line":402},{"containerName":"rand_yule_c_tree","name":"$in","line":402,"kind":13},{"kind":13,"line":402,"name":"$max","containerName":"rand_yule_c_tree"},{"containerName":"rand_yule_c_tree","name":"$in","line":402,"kind":13},{"kind":13,"line":403,"name":"@tree","containerName":"rand_yule_c_tree"},{"kind":13,"line":406,"name":"$in","containerName":"rand_yule_c_tree"},{"line":406,"kind":13,"name":"$in","containerName":"rand_yule_c_tree"},{"name":"$n_taxa","containerName":"rand_yule_c_tree","line":406,"kind":13},{"kind":13,"line":406,"name":"$in","containerName":"rand_yule_c_tree"},{"name":"$tree","containerName":"rand_yule_c_tree","line":407,"kind":13},{"name":"$in","containerName":"rand_yule_c_tree","kind":13,"line":407},{"line":408,"kind":13,"name":"$tree","containerName":"rand_yule_c_tree"},{"line":408,"kind":13,"containerName":"rand_yule_c_tree","name":"$in"},{"kind":13,"line":409,"name":"$tree","containerName":"rand_yule_c_tree"},{"line":409,"kind":13,"containerName":"rand_yule_c_tree","name":"$in"},{"containerName":"rand_yule_c_tree","name":"$r","definition":"my","localvar":"my","kind":13,"line":410},{"name":"$taxa","containerName":"rand_yule_c_tree","line":410,"kind":13},{"name":"$in","containerName":"rand_yule_c_tree","line":410,"kind":13},{"name":"$tree","containerName":"rand_yule_c_tree","line":411,"kind":13},{"name":"$in","containerName":"rand_yule_c_tree","line":411,"kind":13},{"name":"$r","containerName":"rand_yule_c_tree","kind":13,"line":411},{"name":"@list","containerName":"rand_yule_c_tree","line":413,"kind":13},{"line":413,"kind":13,"containerName":"rand_yule_c_tree","name":"$in"},{"line":416,"kind":13,"name":"$i","containerName":"rand_yule_c_tree"},{"line":416,"kind":13,"containerName":"rand_yule_c_tree","name":"$i"},{"containerName":"rand_yule_c_tree","name":"$n_taxa","kind":13,"line":416},{"kind":13,"line":416,"name":"$i","containerName":"rand_yule_c_tree"},{"kind":13,"line":418,"containerName":"rand_yule_c_tree","name":"@times"},{"kind":13,"line":418,"containerName":"rand_yule_c_tree","name":"$randfuncs"},{"name":"rand_birth_distribution","containerName":"rand_yule_c_tree","kind":12,"line":418},{"name":"$speciation","containerName":"rand_yule_c_tree","kind":13,"line":418},{"kind":13,"line":421,"containerName":"rand_yule_c_tree","name":"@times"},{"line":421,"kind":13,"containerName":"rand_yule_c_tree","name":"$a"},{"containerName":"rand_yule_c_tree","name":"$b","kind":13,"line":421},{"line":421,"kind":13,"containerName":"rand_yule_c_tree","name":"@times"},{"line":423,"kind":13,"containerName":"rand_yule_c_tree","name":"$in"},{"kind":13,"line":423,"name":"$n_taxa","containerName":"rand_yule_c_tree"},{"name":"$in","containerName":"rand_yule_c_tree","kind":13,"line":423},{"line":423,"kind":13,"containerName":"rand_yule_c_tree","name":"$in"},{"line":424,"kind":13,"localvar":"my","containerName":"rand_yule_c_tree","name":"$time","definition":"my"},{"containerName":"rand_yule_c_tree","name":"@times","kind":13,"line":424},{"containerName":"rand_yule_c_tree","name":"$pick","definition":"my","localvar":"my","kind":13,"line":426},{"name":"$self","containerName":"rand_yule_c_tree","kind":13,"line":426},{"name":"random","containerName":"rand_yule_c_tree","line":426,"kind":12},{"line":426,"kind":13,"name":"$in","containerName":"rand_yule_c_tree"},{"kind":13,"line":427,"definition":"my","name":"$nodeindex","containerName":"rand_yule_c_tree","localvar":"my"},{"name":"$list","containerName":"rand_yule_c_tree","kind":13,"line":427},{"containerName":"rand_yule_c_tree","name":"$pick","kind":13,"line":427},{"kind":13,"line":428,"containerName":"rand_yule_c_tree","name":"$tree"},{"name":"$list","containerName":"rand_yule_c_tree","kind":13,"line":428},{"name":"$pick","containerName":"rand_yule_c_tree","line":428,"kind":13},{"line":428,"kind":13,"name":"$time","containerName":"rand_yule_c_tree"},{"line":429,"kind":13,"localvar":"my","definition":"my","name":"$swap","containerName":"rand_yule_c_tree"},{"kind":13,"line":429,"containerName":"rand_yule_c_tree","name":"$n_taxa"},{"containerName":"rand_yule_c_tree","name":"$in","line":429,"kind":13},{"kind":13,"line":430,"containerName":"rand_yule_c_tree","name":"$tree"},{"name":"$swap","containerName":"rand_yule_c_tree","line":430,"kind":13},{"containerName":"rand_yule_c_tree","name":"$nodeindex","line":430,"kind":13},{"kind":13,"line":431,"name":"$list","containerName":"rand_yule_c_tree"},{"line":431,"kind":13,"name":"$pick","containerName":"rand_yule_c_tree"},{"containerName":"rand_yule_c_tree","name":"$list","line":431,"kind":13},{"kind":13,"line":431,"containerName":"rand_yule_c_tree","name":"$in"},{"name":"$pick","containerName":"rand_yule_c_tree","line":433,"kind":13},{"containerName":"rand_yule_c_tree","name":"$in","line":433,"kind":13},{"kind":13,"line":434,"name":"$nodeindex","containerName":"rand_yule_c_tree"},{"name":"$list","containerName":"rand_yule_c_tree","line":434,"kind":13},{"containerName":"rand_yule_c_tree","name":"$pick","line":434,"kind":13},{"line":435,"kind":13,"name":"$tree","containerName":"rand_yule_c_tree"},{"line":435,"kind":13,"name":"$list","containerName":"rand_yule_c_tree"},{"containerName":"rand_yule_c_tree","name":"$pick","kind":13,"line":435},{"kind":13,"line":435,"containerName":"rand_yule_c_tree","name":"$time"},{"kind":13,"line":436,"name":"$tree","containerName":"rand_yule_c_tree"},{"name":"$swap","containerName":"rand_yule_c_tree","kind":13,"line":436},{"containerName":"rand_yule_c_tree","name":"$nodeindex","kind":13,"line":436},{"line":437,"kind":13,"containerName":"rand_yule_c_tree","name":"$list"},{"line":437,"kind":13,"name":"$pick","containerName":"rand_yule_c_tree"},{"containerName":"rand_yule_c_tree","name":"$swap","kind":13,"line":437},{"containerName":"rand_yule_c_tree","name":"$tree","kind":13,"line":439},{"kind":13,"line":439,"name":"@times","containerName":"rand_yule_c_tree"},{"name":"@tree","containerName":"rand_yule_c_tree","kind":13,"line":440}],"kind":12,"range":{"end":{"line":441,"character":9999},"start":{"character":0,"line":391}},"name":"rand_yule_c_tree"},{"name":"Bio","containerName":"Tools::RandomDistFunctions","line":398,"kind":12},{"line":445,"children":[{"containerName":"rand_birthdeath_backwards_tree","name":"$self","definition":"my","localvar":"my","kind":13,"line":446},{"line":447,"kind":13,"localvar":"my","name":"$n_taxa","definition":"my","containerName":"rand_birthdeath_backwards_tree"},{"line":447,"kind":13,"name":"$self","containerName":"rand_birthdeath_backwards_tree"},{"containerName":"rand_birthdeath_backwards_tree","name":"num_taxa","line":447,"kind":12},{"localvar":"my","containerName":"rand_birthdeath_backwards_tree","definition":"my","name":"$taxa","line":448,"kind":13},{"line":448,"kind":13,"containerName":"rand_birthdeath_backwards_tree","name":"$self"},{"kind":12,"line":448,"containerName":"rand_birthdeath_backwards_tree","name":"taxa"},{"localvar":"my","containerName":"rand_birthdeath_backwards_tree","definition":"my","name":"$randfuncs","line":450,"kind":13},{"name":"new","containerName":"rand_birthdeath_backwards_tree","line":450,"kind":12},{"containerName":"rand_birthdeath_backwards_tree","name":"$rate","definition":"my","localvar":"my","kind":13,"line":451},{"line":451,"kind":13,"containerName":"rand_birthdeath_backwards_tree","name":"$Defaults"},{"line":452,"kind":13,"localvar":"my","name":"@tree","definition":"my","containerName":"rand_birthdeath_backwards_tree"},{"name":"@list","containerName":"rand_birthdeath_backwards_tree","line":452,"kind":13},{"name":"@times","containerName":"rand_birthdeath_backwards_tree","kind":13,"line":452},{"kind":13,"line":452,"containerName":"rand_birthdeath_backwards_tree","name":"$i"},{"containerName":"rand_birthdeath_backwards_tree","name":"$in","kind":13,"line":452},{"kind":13,"line":453,"containerName":"rand_birthdeath_backwards_tree","definition":"my","name":"$max","localvar":"my"},{"name":"$n_taxa","containerName":"rand_birthdeath_backwards_tree","kind":13,"line":453},{"containerName":"rand_birthdeath_backwards_tree","name":"$in","kind":13,"line":454},{"containerName":"rand_birthdeath_backwards_tree","name":"$in","kind":13,"line":454},{"containerName":"rand_birthdeath_backwards_tree","name":"$max","line":454,"kind":13},{"kind":13,"line":454,"name":"$in","containerName":"rand_birthdeath_backwards_tree"},{"containerName":"rand_birthdeath_backwards_tree","name":"@tree","kind":13,"line":455},{"containerName":"rand_birthdeath_backwards_tree","name":"$in","line":458,"kind":13},{"name":"$in","containerName":"rand_birthdeath_backwards_tree","kind":13,"line":458},{"kind":13,"line":458,"name":"$n_taxa","containerName":"rand_birthdeath_backwards_tree"},{"name":"$in","containerName":"rand_birthdeath_backwards_tree","line":458,"kind":13},{"kind":13,"line":459,"name":"$tree","containerName":"rand_birthdeath_backwards_tree"},{"name":"$in","containerName":"rand_birthdeath_backwards_tree","kind":13,"line":459},{"containerName":"rand_birthdeath_backwards_tree","name":"$tree","line":460,"kind":13},{"kind":13,"line":460,"name":"$in","containerName":"rand_birthdeath_backwards_tree"},{"line":461,"kind":13,"containerName":"rand_birthdeath_backwards_tree","name":"$tree"},{"name":"$in","containerName":"rand_birthdeath_backwards_tree","line":461,"kind":13},{"localvar":"my","containerName":"rand_birthdeath_backwards_tree","definition":"my","name":"$r","line":462,"kind":13},{"name":"$taxa","containerName":"rand_birthdeath_backwards_tree","line":462,"kind":13},{"line":462,"kind":13,"name":"$in","containerName":"rand_birthdeath_backwards_tree"},{"kind":13,"line":464,"containerName":"rand_birthdeath_backwards_tree","name":"$tree"},{"name":"$in","containerName":"rand_birthdeath_backwards_tree","line":464,"kind":13},{"containerName":"rand_birthdeath_backwards_tree","name":"$r","kind":13,"line":464},{"containerName":"rand_birthdeath_backwards_tree","name":"@list","line":466,"kind":13},{"name":"$in","containerName":"rand_birthdeath_backwards_tree","line":466,"kind":13},{"name":"$time","definition":"my","containerName":"rand_birthdeath_backwards_tree","localvar":"my","kind":13,"line":468},{"kind":13,"line":471,"containerName":"rand_birthdeath_backwards_tree","name":"$in"},{"kind":13,"line":471,"containerName":"rand_birthdeath_backwards_tree","name":"$n_taxa"},{"line":471,"kind":13,"containerName":"rand_birthdeath_backwards_tree","name":"$in"},{"containerName":"rand_birthdeath_backwards_tree","name":"$in","line":471,"kind":13},{"containerName":"rand_birthdeath_backwards_tree","definition":"my","name":"$pick","localvar":"my","kind":13,"line":472},{"kind":13,"line":472,"containerName":"rand_birthdeath_backwards_tree","name":"$self"},{"name":"random","containerName":"rand_birthdeath_backwards_tree","kind":12,"line":472},{"name":"$in","containerName":"rand_birthdeath_backwards_tree","line":472,"kind":13},{"definition":"my","name":"$nodeindex","containerName":"rand_birthdeath_backwards_tree","localvar":"my","kind":13,"line":473},{"containerName":"rand_birthdeath_backwards_tree","name":"$list","kind":13,"line":473},{"name":"$pick","containerName":"rand_birthdeath_backwards_tree","line":473,"kind":13},{"kind":13,"line":474,"containerName":"rand_birthdeath_backwards_tree","definition":"my","name":"$swap","localvar":"my"},{"containerName":"rand_birthdeath_backwards_tree","name":"$n_taxa","kind":13,"line":474},{"name":"$in","containerName":"rand_birthdeath_backwards_tree","kind":13,"line":474},{"containerName":"rand_birthdeath_backwards_tree","name":"$time","kind":13,"line":475},{"line":475,"kind":13,"containerName":"rand_birthdeath_backwards_tree","name":"$randfuncs"},{"kind":12,"line":475,"containerName":"rand_birthdeath_backwards_tree","name":"rand_geometric_distribution"},{"name":"$n_taxa","containerName":"rand_birthdeath_backwards_tree","line":475,"kind":13},{"line":475,"kind":13,"containerName":"rand_birthdeath_backwards_tree","name":"$rate"},{"kind":13,"line":476,"containerName":"rand_birthdeath_backwards_tree","name":"$tree"},{"containerName":"rand_birthdeath_backwards_tree","name":"$list","line":476,"kind":13},{"containerName":"rand_birthdeath_backwards_tree","name":"$pick","kind":13,"line":476},{"kind":13,"line":476,"name":"$time","containerName":"rand_birthdeath_backwards_tree"},{"line":477,"kind":13,"containerName":"rand_birthdeath_backwards_tree","name":"$tree"},{"name":"$swap","containerName":"rand_birthdeath_backwards_tree","kind":13,"line":477},{"containerName":"rand_birthdeath_backwards_tree","name":"$nodeindex","line":477,"kind":13},{"containerName":"rand_birthdeath_backwards_tree","name":"$list","kind":13,"line":478},{"kind":13,"line":478,"name":"$pick","containerName":"rand_birthdeath_backwards_tree"},{"kind":13,"line":478,"name":"$list","containerName":"rand_birthdeath_backwards_tree"},{"kind":13,"line":478,"containerName":"rand_birthdeath_backwards_tree","name":"$in"},{"line":480,"kind":13,"containerName":"rand_birthdeath_backwards_tree","name":"$pick"},{"containerName":"rand_birthdeath_backwards_tree","name":"$in","line":480,"kind":13},{"containerName":"rand_birthdeath_backwards_tree","name":"$nodeindex","kind":13,"line":481},{"kind":13,"line":481,"name":"$list","containerName":"rand_birthdeath_backwards_tree"},{"line":481,"kind":13,"name":"$pick","containerName":"rand_birthdeath_backwards_tree"},{"kind":13,"line":482,"name":"$tree","containerName":"rand_birthdeath_backwards_tree"},{"line":482,"kind":13,"containerName":"rand_birthdeath_backwards_tree","name":"$list"},{"name":"$pick","containerName":"rand_birthdeath_backwards_tree","kind":13,"line":482},{"name":"$time","containerName":"rand_birthdeath_backwards_tree","line":482,"kind":13},{"name":"$tree","containerName":"rand_birthdeath_backwards_tree","kind":13,"line":483},{"name":"$swap","containerName":"rand_birthdeath_backwards_tree","line":483,"kind":13},{"name":"$nodeindex","containerName":"rand_birthdeath_backwards_tree","line":483,"kind":13},{"name":"$list","containerName":"rand_birthdeath_backwards_tree","line":484,"kind":13},{"containerName":"rand_birthdeath_backwards_tree","name":"$pick","line":484,"kind":13},{"name":"$swap","containerName":"rand_birthdeath_backwards_tree","line":484,"kind":13},{"line":486,"kind":13,"localvar":"my","name":"$root","definition":"my","containerName":"rand_birthdeath_backwards_tree"},{"kind":13,"line":486,"containerName":"rand_birthdeath_backwards_tree","name":"$tree"},{"line":487,"kind":13,"name":"$time","containerName":"rand_birthdeath_backwards_tree"},{"kind":13,"line":487,"containerName":"rand_birthdeath_backwards_tree","name":"$randfuncs"},{"line":487,"kind":12,"containerName":"rand_birthdeath_backwards_tree","name":"rand_geometric_distribution"},{"name":"$n_taxa","containerName":"rand_birthdeath_backwards_tree","kind":13,"line":487},{"line":487,"kind":13,"name":"$rate","containerName":"rand_birthdeath_backwards_tree"},{"name":"$root","containerName":"rand_birthdeath_backwards_tree","line":488,"kind":13},{"kind":13,"line":488,"name":"$time","containerName":"rand_birthdeath_backwards_tree"},{"kind":13,"line":491,"name":"$node","definition":"my","containerName":"rand_birthdeath_backwards_tree","localvar":"my"},{"containerName":"rand_birthdeath_backwards_tree","name":"@tree","line":491,"kind":13},{"line":492,"kind":13,"name":"$node","containerName":"rand_birthdeath_backwards_tree"},{"line":492,"kind":13,"containerName":"rand_birthdeath_backwards_tree","name":"$root"},{"line":494,"kind":13,"name":"@tree","containerName":"rand_birthdeath_backwards_tree"}],"kind":12,"detail":"($self)","signature":{"label":"rand_birthdeath_backwards_tree($self)","documentation":"","parameters":[{"label":"$self"}]},"containerName":"main::","definition":"sub","range":{"start":{"line":445,"character":0},"end":{"line":495,"character":9999}},"name":"rand_birthdeath_backwards_tree"},{"line":450,"kind":12,"containerName":"Tools::RandomDistFunctions","name":"Bio"},{"children":[],"line":502,"kind":12,"range":{"end":{"line":543,"character":9999},"start":{"line":502,"character":0}},"name":"rand_birth_death_tree","definition":"sub","containerName":"main::"}]}