{"version":5,"vars":[{"containerName":"","name":"base","kind":2,"line":91},{"signature":{"label":"new($class,@args)","documentation":"1;\n# $Id: NodeNHX.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tree::NodeNHX\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Aaron Mackey <amackey@virginia.edu>\n#\n# Copyright Aaron Mackey\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::NodeNHX - A Simple Tree Node with support for NHX tags\n\n=head1 SYNOPSIS\n\n    use Bio::Tree::NodeNHX;\n    my $nodeA = Bio::Tree::NodeNHX->new();\n    my $nodeL = Bio::Tree::NodeNHX->new();\n    my $nodeR = Bio::Tree::NodeNHX->new();\n\n    my $node = Bio::Tree::NodeNHX->new();\n    $node->add_Descendents($nodeL);\n    $node->add_Descendents($nodeR);\n\n    print \"node is not a leaf \\n\" if( $node->is_leaf);\n\n=head1 DESCRIPTION\n\nMakes a Tree Node with NHX tags, suitable for building a Tree.  See\nL<Bio::Tree::Node> for a full list of functionality.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Aaron Mackey\n\nEmail amackey@virginia.edu\n\n=head1 CONTRIBUTORS\n\nThe NHX (New Hampshire eXtended) format was created by Chris Zmasek,\nand is described at:\n\n  http://sourceforge.net/projects/forester-atv/\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Tree::NodeNHX;\nuse strict;\n\n\nuse base qw(Bio::Tree::Node);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tree::NodeNHX->new();\n Function: Builds a new Bio::Tree::NodeNHX object\n Returns : Bio::Tree::NodeNHX\n Args    : -left          => pointer to Left descendent (optional)\n           -right         => pointer to Right descenent (optional)\n\t   -branch_length => branch length [integer] (optional)\n           -bootstrap     => bootstrap value (string)\n           -description   => description of node\n           -id            => unique id for node\n           -nhx           => hashref of NHX tags and values","parameters":[{"label":"$class"},{"label":"@args"}]},"detail":"($class,@args)","definition":"sub","containerName":"main::","children":[{"containerName":"new","definition":"my","name":"$class","localvar":"my","kind":13,"line":110},{"line":110,"kind":13,"containerName":"new","name":"@args"},{"line":112,"kind":13,"localvar":"my","containerName":"new","name":"$self","definition":"my"},{"containerName":"new","name":"$class","line":112,"kind":13},{"name":"@args","containerName":"new","kind":13,"line":112},{"definition":"my","name":"$nhx","containerName":"new","localvar":"my","kind":13,"line":113},{"containerName":"new","name":"$self","kind":13,"line":113},{"name":"_rearrange","containerName":"new","line":113,"kind":12},{"kind":13,"line":113,"name":"@args","containerName":"new"},{"containerName":"new","name":"$self","line":114,"kind":13},{"line":114,"kind":12,"containerName":"new","name":"nhx_tag"},{"name":"$nhx","containerName":"new","line":114,"kind":13},{"kind":13,"line":115,"containerName":"new","name":"$self"}],"line":109,"kind":12,"range":{"start":{"line":109,"character":0},"end":{"character":9999,"line":116}},"name":"new"},{"kind":12,"line":112,"containerName":"new","name":"SUPER"},{"range":{"end":{"character":9999,"line":130},"start":{"character":0,"line":118}},"name":"DESTROY","signature":{"label":"DESTROY($self)","documentation":"","parameters":[{"label":"$self"}]},"detail":"($self)","definition":"sub","containerName":"main::","children":[{"name":"$self","definition":"my","containerName":"DESTROY","localvar":"my","kind":13,"line":119},{"name":"$self","containerName":"DESTROY","kind":13,"line":121},{"line":122,"kind":13,"name":"$self","containerName":"DESTROY"},{"line":123,"kind":13,"name":"$self","containerName":"DESTROY"},{"line":124,"kind":13,"localvar":"my","definition":"my","name":"$nodeid","containerName":"DESTROY"},{"kind":13,"line":124,"containerName":"DESTROY","name":"$node"},{"line":124,"kind":13,"name":"$self","containerName":"DESTROY"},{"line":125,"kind":13,"name":"$node","containerName":"DESTROY"},{"kind":13,"line":126,"name":"$node","containerName":"DESTROY"},{"line":126,"kind":12,"name":"DESTROY","containerName":"DESTROY"},{"name":"$node","containerName":"DESTROY","kind":13,"line":127},{"kind":13,"line":129,"containerName":"DESTROY","name":"$self"}],"line":118,"kind":12},{"containerName":"DESTROY","name":"SUPER","kind":12,"line":121},{"range":{"end":{"character":9999,"line":148},"start":{"line":133,"character":0}},"name":"to_string","line":133,"children":[{"kind":13,"line":134,"containerName":"to_string","definition":"my","name":"$self","localvar":"my"},{"localvar":"my","name":"@tags","definition":"my","containerName":"to_string","line":135,"kind":13},{"kind":13,"line":135,"name":"$self","containerName":"to_string"},{"containerName":"to_string","name":"get_all_tags","line":135,"kind":12},{"kind":13,"line":136,"containerName":"to_string","name":"$tagstr","definition":"my","localvar":"my"},{"containerName":"to_string","name":"@tags","kind":13,"line":137},{"containerName":"to_string","name":"$tagstr","kind":13,"line":138},{"containerName":"to_string","name":"$self","kind":13,"line":140},{"containerName":"to_string","name":"get_tag_values","kind":12,"line":140},{"kind":13,"line":141,"containerName":"to_string","name":"@tags"},{"containerName":"to_string","name":"$self","kind":13,"line":144},{"name":"id","containerName":"to_string","line":144,"kind":12},{"name":"$self","containerName":"to_string","kind":13,"line":144},{"line":144,"kind":12,"name":"id","containerName":"to_string"},{"line":145,"kind":13,"containerName":"to_string","name":"$self"},{"kind":12,"line":145,"containerName":"to_string","name":"branch_length"},{"kind":13,"line":146,"containerName":"to_string","name":"$self"},{"kind":12,"line":146,"containerName":"to_string","name":"branch_length"},{"kind":13,"line":147,"containerName":"to_string","name":"$tagstr"}],"kind":12,"detail":"($self)","signature":{"label":"to_string($self)","parameters":[{"label":"$self"}],"documentation":""},"containerName":"main::","definition":"sub"},{"line":163,"children":[{"containerName":"nhx_tag","name":"$self","definition":"my","localvar":"my","kind":13,"line":164},{"containerName":"nhx_tag","name":"$tags","line":164,"kind":13},{"containerName":"nhx_tag","name":"$tags","kind":13,"line":165},{"kind":13,"line":165,"name":"$tags","containerName":"nhx_tag"},{"definition":"my","name":"$tag","containerName":"nhx_tag","localvar":"my","kind":13,"line":166},{"containerName":"nhx_tag","name":"$val","kind":13,"line":166},{"line":166,"kind":13,"name":"$tags","containerName":"nhx_tag"},{"line":167,"kind":13,"name":"$val","containerName":"nhx_tag"},{"kind":13,"line":168,"containerName":"nhx_tag","name":"$v","definition":"my","localvar":"my"},{"line":168,"kind":13,"containerName":"nhx_tag","name":"$val"},{"kind":13,"line":169,"name":"$self","containerName":"nhx_tag"},{"name":"add_tag_value","containerName":"nhx_tag","kind":12,"line":169},{"name":"$tag","containerName":"nhx_tag","line":169,"kind":13},{"name":"$v","containerName":"nhx_tag","kind":13,"line":169},{"kind":13,"line":172,"name":"$self","containerName":"nhx_tag"},{"containerName":"nhx_tag","name":"add_tag_value","line":172,"kind":12},{"line":172,"kind":13,"name":"$tag","containerName":"nhx_tag"},{"line":172,"kind":13,"name":"$val","containerName":"nhx_tag"},{"line":175,"kind":13,"name":"$tags","containerName":"nhx_tag"},{"containerName":"nhx_tag","name":"$self","line":176,"kind":13},{"line":176,"kind":12,"name":"bootstrap","containerName":"nhx_tag"},{"name":"$tags","containerName":"nhx_tag","line":176,"kind":13},{"containerName":"nhx_tag","name":"$tags","kind":13,"line":178},{"line":178,"kind":13,"name":"$tags","containerName":"nhx_tag"},{"kind":13,"line":179,"containerName":"nhx_tag","name":"$self"},{"name":"debug","containerName":"nhx_tag","kind":12,"line":179},{"kind":13,"line":181,"containerName":"nhx_tag","name":"$self"},{"line":181,"kind":12,"name":"bootstrap","containerName":"nhx_tag"},{"line":181,"kind":13,"containerName":"nhx_tag","name":"$tags"}],"kind":12,"detail":"($self,$tags)","signature":{"label":"nhx_tag($self,$tags)","documentation":"1;\n# $Id: NodeNHX.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tree::NodeNHX\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Aaron Mackey <amackey@virginia.edu>\n#\n# Copyright Aaron Mackey\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::NodeNHX - A Simple Tree Node with support for NHX tags\n\n=head1 SYNOPSIS\n\n    use Bio::Tree::NodeNHX;\n    my $nodeA = Bio::Tree::NodeNHX->new();\n    my $nodeL = Bio::Tree::NodeNHX->new();\n    my $nodeR = Bio::Tree::NodeNHX->new();\n\n    my $node = Bio::Tree::NodeNHX->new();\n    $node->add_Descendents($nodeL);\n    $node->add_Descendents($nodeR);\n\n    print \"node is not a leaf \\n\" if( $node->is_leaf);\n\n=head1 DESCRIPTION\n\nMakes a Tree Node with NHX tags, suitable for building a Tree.  See\nL<Bio::Tree::Node> for a full list of functionality.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Aaron Mackey\n\nEmail amackey@virginia.edu\n\n=head1 CONTRIBUTORS\n\nThe NHX (New Hampshire eXtended) format was created by Chris Zmasek,\nand is described at:\n\n  http://sourceforge.net/projects/forester-atv/\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Tree::NodeNHX;\nuse strict;\n\n\nuse base qw(Bio::Tree::Node);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tree::NodeNHX->new();\n Function: Builds a new Bio::Tree::NodeNHX object\n Returns : Bio::Tree::NodeNHX\n Args    : -left          => pointer to Left descendent (optional)\n           -right         => pointer to Right descenent (optional)\n\t   -branch_length => branch length [integer] (optional)\n           -bootstrap     => bootstrap value (string)\n           -description   => description of node\n           -id            => unique id for node\n           -nhx           => hashref of NHX tags and values\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($nhx) = $self->_rearrange([qw(NHX)], @args);\n  $self->nhx_tag($nhx);\n  return $self;\n}\n\nsub DESTROY {\n    my ($self) = @_;\n    # try to insure that everything is cleaned up\n    $self->SUPER::DESTROY();\n    if( defined $self->{'_desc'} &&\n\tref($self->{'_desc'}) =~ /ARRAY/i ) {\n\twhile( my ($nodeid,$node) = each %{ $self->{'_desc'} } ) {\n\t    $node->{'_ancestor'} = undef; # insure no circular references\n\t    $node->DESTROY();\n\t    $node = undef;\n\t}\n\t$self->{'_desc'} = {};\n    }\n}\n\nsub to_string{\n   my ($self) = @_;\n   my @tags = $self->get_all_tags;\n   my $tagstr = '';\n   if( @tags ) {\n       $tagstr = '[' . join(\":\", \"&&NHX\", \n\t\t\t    map { \"$_=\" .join(',',\n\t\t\t\t\t      $self->get_tag_values($_))}\n\t\t\t    @tags ) . ']';\n   }\n   return sprintf(\"%s%s%s\",\n\t\t  defined $self->id ? $self->id : '',\n\t\t  defined $self->branch_length ? ':' . \n\t\t  $self->branch_length : ' ',\n\t\t  $tagstr);\n}\n\n=head2 nhx_tag\n\n Title   : nhx_tag\n Usage   : my $tag = $nodenhx->nhx_tag(%tags);\n Function: Set tag-value pairs for NHX nodes\n Returns : none\n Args    : hashref to update the tags/value pairs\n           OR \n           with a scalar value update the bootstrap value by default","parameters":[{"label":"$self"},{"label":"$tags"}]},"containerName":"main::","definition":"sub","range":{"start":{"line":163,"character":0},"end":{"line":183,"character":9999}},"name":"nhx_tag"}]}