{"version":5,"vars":[{"kind":2,"line":97,"name":"vars","containerName":""},{"containerName":null,"name":"$DefaultMethod","kind":13,"line":101},{"kind":2,"line":101,"name":"strict","containerName":""},{"kind":13,"line":102,"containerName":null,"name":"$Precision"},{"name":"base","containerName":"","line":107,"kind":2},{"line":120,"children":[{"line":121,"kind":13,"localvar":"my","name":"$class","definition":"my","containerName":"new"},{"containerName":"new","name":"@args","line":121,"kind":13},{"localvar":"my","containerName":"new","definition":"my","name":"$self","line":122,"kind":13},{"name":"$class","containerName":"new","kind":13,"line":122},{"containerName":"new","name":"@args","kind":13,"line":122},{"localvar":"my","containerName":"new","definition":"my","name":"$method","line":124,"kind":13},{"name":"$self","containerName":"new","kind":13,"line":124},{"kind":12,"line":124,"name":"_rearrange","containerName":"new"},{"containerName":"new","name":"@args","kind":13,"line":125},{"name":"$self","containerName":"new","kind":13,"line":126},{"line":126,"kind":12,"name":"method","containerName":"new"},{"name":"$method","containerName":"new","line":126,"kind":13},{"kind":13,"line":126,"containerName":"new","name":"$DefaultMethod"},{"kind":13,"line":127,"containerName":"new","name":"$self"}],"kind":12,"detail":"($class,@args)","signature":{"parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: DistanceFactory.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tree::DistanceFactory\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::DistanceFactory - Construct a tree using distance based methods\n\n=head1 SYNOPSIS\n\n  use Bio::Tree::DistanceFactory;\n  use Bio::AlignIO;\n  use Bio::Align::DNAStatistics;\n  my $tfactory = Bio::Tree::DistanceFactory->new(-method => \"NJ\");\n  my $stats    = Bio::Align::DNAStatistics->new();\n\n  my $alnin    = Bio::AlignIO->new(-format => 'clustalw',\n                                   -file   => 'file.aln');\n  my $aln = $alnin->next_aln;\n  # Of course matrix can come from a different place\n  # like PHYLIP if you prefer, Bio::Matrix::IO should be able\n  # to parse many things\n  my $jcmatrix = $stats->distance(-align => $aln, \n                                  -method => 'Jukes-Cantor');\n  my $tree = $tfactory->make_tree($jcmatrix);\n\n\n=head1 DESCRIPTION\n\nThis is a factory which will construct a phylogenetic tree based on\nthe pairwise sequence distances for a set of sequences.  Currently\nUPGMA (Sokal and Michener 1958) and NJ (Saitou and Nei 1987) tree\nconstruction methods are implemented.\n\n=head1 REFERENCES\n\nEddy SR, Durbin R, Krogh A, Mitchison G, (1998) \"Biological Sequence Analysis\",\nCambridge Univ Press, Cambridge, UK.\n\nHowe K, Bateman A, Durbin R, (2002) \"QuickTree: building huge\nNeighbour-Joining trees of protein sequences.\" Bioinformatics\n18(11):1546-1547.\n\nSaitou N and Nei M, (1987) \"The neighbor-joining method: a new method\nfor reconstructing phylogenetic trees.\" Mol Biol Evol 4(4):406-25.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::Tree::DistanceFactory;\nuse vars qw($DefaultMethod $Precision);\nuse strict;\n\n# some defaults\n$DefaultMethod = 'UPGMA';\n$Precision = 5;\n\nuse Bio::Tree::Node;\nuse Bio::Tree::Tree;\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tree::DistanceFactory->new();\n Function: Builds a new Bio::Tree::DistanceFactory object \n Returns : an instance of Bio::Tree::DistanceFactory\n Args    : -method => 'NJ' or 'UPGMA'","label":"new($class,@args)"},"containerName":"main::","definition":"sub","range":{"end":{"line":128,"character":9999},"start":{"character":0,"line":120}},"name":"new"},{"containerName":"new","name":"SUPER","line":122,"kind":12},{"name":"make_tree","range":{"start":{"character":0,"line":141},"end":{"character":9999,"line":159}},"kind":12,"children":[{"localvar":"my","containerName":"make_tree","definition":"my","name":"$self","line":142,"kind":13},{"containerName":"make_tree","name":"$matrix","line":142,"kind":13},{"kind":13,"line":143,"name":"$matrix","containerName":"make_tree"},{"kind":13,"line":143,"name":"$matrix","containerName":"make_tree"},{"line":144,"kind":13,"name":"$matrix","containerName":"make_tree"},{"containerName":"make_tree","name":"isa","line":144,"kind":12},{"line":145,"kind":13,"name":"$self","containerName":"make_tree"},{"name":"warn","containerName":"make_tree","kind":12,"line":145},{"localvar":"my","definition":"my","name":"$method","containerName":"make_tree","line":149,"kind":13},{"line":149,"kind":13,"containerName":"make_tree","name":"$self"},{"kind":12,"line":149,"name":"method","containerName":"make_tree"},{"containerName":"make_tree","name":"$method","line":150,"kind":13},{"containerName":"make_tree","name":"$self","line":151,"kind":13},{"containerName":"make_tree","name":"_nj","kind":12,"line":151},{"kind":13,"line":151,"name":"$matrix","containerName":"make_tree"},{"kind":13,"line":152,"containerName":"make_tree","name":"$method"},{"line":153,"kind":13,"name":"$self","containerName":"make_tree"},{"kind":12,"line":153,"name":"_upgma","containerName":"make_tree"},{"name":"$matrix","containerName":"make_tree","line":153,"kind":13},{"kind":13,"line":155,"name":"$self","containerName":"make_tree"},{"line":155,"kind":12,"containerName":"make_tree","name":"warn"}],"line":141,"definition":"sub","containerName":"main::","signature":{"label":"make_tree($self,$matrix)","parameters":[{"label":"$self"},{"label":"$matrix"}],"documentation":"1;\n# $Id: DistanceFactory.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tree::DistanceFactory\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::DistanceFactory - Construct a tree using distance based methods\n\n=head1 SYNOPSIS\n\n  use Bio::Tree::DistanceFactory;\n  use Bio::AlignIO;\n  use Bio::Align::DNAStatistics;\n  my $tfactory = Bio::Tree::DistanceFactory->new(-method => \"NJ\");\n  my $stats    = Bio::Align::DNAStatistics->new();\n\n  my $alnin    = Bio::AlignIO->new(-format => 'clustalw',\n                                   -file   => 'file.aln');\n  my $aln = $alnin->next_aln;\n  # Of course matrix can come from a different place\n  # like PHYLIP if you prefer, Bio::Matrix::IO should be able\n  # to parse many things\n  my $jcmatrix = $stats->distance(-align => $aln, \n                                  -method => 'Jukes-Cantor');\n  my $tree = $tfactory->make_tree($jcmatrix);\n\n\n=head1 DESCRIPTION\n\nThis is a factory which will construct a phylogenetic tree based on\nthe pairwise sequence distances for a set of sequences.  Currently\nUPGMA (Sokal and Michener 1958) and NJ (Saitou and Nei 1987) tree\nconstruction methods are implemented.\n\n=head1 REFERENCES\n\nEddy SR, Durbin R, Krogh A, Mitchison G, (1998) \"Biological Sequence Analysis\",\nCambridge Univ Press, Cambridge, UK.\n\nHowe K, Bateman A, Durbin R, (2002) \"QuickTree: building huge\nNeighbour-Joining trees of protein sequences.\" Bioinformatics\n18(11):1546-1547.\n\nSaitou N and Nei M, (1987) \"The neighbor-joining method: a new method\nfor reconstructing phylogenetic trees.\" Mol Biol Evol 4(4):406-25.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::Tree::DistanceFactory;\nuse vars qw($DefaultMethod $Precision);\nuse strict;\n\n# some defaults\n$DefaultMethod = 'UPGMA';\n$Precision = 5;\n\nuse Bio::Tree::Node;\nuse Bio::Tree::Tree;\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tree::DistanceFactory->new();\n Function: Builds a new Bio::Tree::DistanceFactory object \n Returns : an instance of Bio::Tree::DistanceFactory\n Args    : -method => 'NJ' or 'UPGMA'\n\n\n\nsub new {\n  my($class,@args) = @_;  \n  my $self = $class->SUPER::new(@args);\n\n  my ($method) = $self->_rearrange([qw(METHOD)],\n\t\t\t\t   @args);\n  $self->method($method || $DefaultMethod);\n  return $self;\n}\n\n=head2 make_tree\n\n Title   : make_tree\n Usage   : my $tree = $disttreefact->make_tree($matrix);\n Function: Build a Tree based on a distance matrix\n Returns : L<Bio::Tree::TreeI>\n Args    : L<Bio::Matrix::MatrixI> object"},"detail":"($self,$matrix)"},{"range":{"end":{"line":360,"character":9999},"start":{"line":176,"character":0}},"name":"_nj","children":[{"definition":"my","name":"$self","containerName":"_nj","localvar":"my","kind":13,"line":177},{"name":"$distmat","containerName":"_nj","kind":13,"line":177},{"line":184,"kind":13,"localvar":"my","definition":"my","name":"$precisionstr","containerName":"_nj"},{"localvar":"my","name":"@names","definition":"my","containerName":"_nj","line":186,"kind":13},{"containerName":"_nj","name":"$distmat","line":186,"kind":13},{"kind":12,"line":186,"name":"column_names","containerName":"_nj"},{"localvar":"my","name":"$N","definition":"my","containerName":"_nj","line":187,"kind":13},{"line":187,"kind":13,"containerName":"_nj","name":"@names"},{"line":188,"kind":13,"localvar":"my","containerName":"_nj","definition":"my","name":"$i"},{"line":188,"kind":13,"containerName":"_nj","name":"$j"},{"containerName":"_nj","name":"$m","kind":13,"line":188},{"name":"@nodes","containerName":"_nj","kind":13,"line":188},{"containerName":"_nj","name":"$mat","kind":13,"line":188},{"kind":13,"line":188,"name":"@r","containerName":"_nj"},{"name":"$L","definition":"my","containerName":"_nj","localvar":"my","kind":13,"line":189},{"line":189,"kind":13,"name":"$N","containerName":"_nj"},{"line":191,"kind":13,"containerName":"_nj","name":"$N"},{"containerName":"_nj","name":"$self","line":192,"kind":13},{"name":"warn","containerName":"_nj","kind":12,"line":192},{"containerName":"_nj","name":"$N","line":194,"kind":13},{"kind":13,"line":195,"name":"$i","containerName":"_nj"},{"localvar":"my","containerName":"_nj","name":"$d","definition":"my","line":196,"kind":13},{"name":"$precisionstr","containerName":"_nj","kind":13,"line":196},{"line":197,"kind":13,"containerName":"_nj","name":"$distmat"},{"containerName":"_nj","name":"get_entry","kind":12,"line":197},{"containerName":"_nj","name":"$names","kind":13,"line":197},{"kind":13,"line":197,"name":"$names","containerName":"_nj"},{"localvar":"my","name":"$root","definition":"my","containerName":"_nj","line":198,"kind":13},{"name":"new","containerName":"_nj","kind":12,"line":198},{"localvar":"my","definition":"my","name":"$nm","containerName":"_nj","line":199,"kind":13},{"line":199,"kind":13,"containerName":"_nj","name":"@names"},{"line":200,"kind":13,"containerName":"_nj","name":"$root"},{"containerName":"_nj","name":"add_Descendents","kind":12,"line":200},{"containerName":"_nj","name":"new","line":200,"kind":12},{"containerName":"_nj","name":"$nm","kind":13,"line":200},{"name":"$d","containerName":"_nj","kind":13,"line":201},{"kind":13,"line":203,"containerName":"_nj","name":"$root"},{"kind":13,"line":205,"name":"$c","definition":"my","containerName":"_nj","localvar":"my"},{"line":207,"kind":13,"containerName":"_nj","name":"$i"},{"name":"$i","containerName":"_nj","line":207,"kind":13},{"name":"$N","containerName":"_nj","kind":13,"line":207},{"line":207,"kind":13,"name":"$i","containerName":"_nj"},{"line":208,"kind":13,"containerName":"_nj","name":"@nodes"},{"line":208,"kind":12,"containerName":"_nj","name":"new"},{"kind":13,"line":208,"containerName":"_nj","name":"$names"},{"kind":13,"line":208,"name":"$i","containerName":"_nj"},{"definition":"my","name":"$ri","containerName":"_nj","localvar":"my","kind":13,"line":209},{"name":"$j","containerName":"_nj","line":210,"kind":13},{"line":210,"kind":13,"name":"$j","containerName":"_nj"},{"name":"$N","containerName":"_nj","kind":13,"line":210},{"line":210,"kind":13,"name":"$j","containerName":"_nj"},{"name":"$mat","containerName":"_nj","line":211,"kind":13},{"kind":13,"line":211,"containerName":"_nj","name":"$i"},{"containerName":"_nj","name":"$j","kind":13,"line":211},{"kind":13,"line":211,"name":"$distmat","containerName":"_nj"},{"name":"get_entry","containerName":"_nj","line":211,"kind":12},{"line":211,"kind":13,"containerName":"_nj","name":"$names"},{"name":"$i","containerName":"_nj","line":211,"kind":13},{"kind":13,"line":211,"name":"$names","containerName":"_nj"},{"line":211,"kind":13,"name":"$j","containerName":"_nj"},{"line":212,"kind":13,"name":"$ri","containerName":"_nj"},{"line":212,"kind":13,"name":"$mat","containerName":"_nj"},{"name":"$i","containerName":"_nj","kind":13,"line":212},{"line":212,"kind":13,"containerName":"_nj","name":"$j"},{"containerName":"_nj","name":"$r","kind":13,"line":214},{"line":214,"kind":13,"name":"$i","containerName":"_nj"},{"containerName":"_nj","name":"$ri","kind":13,"line":214},{"line":214,"kind":13,"containerName":"_nj","name":"$L"},{"kind":13,"line":217,"definition":"my","name":"$nodecount","containerName":"_nj","localvar":"my"},{"name":"$nodecount","containerName":"_nj","line":217,"kind":13},{"kind":13,"line":217,"containerName":"_nj","name":"$N"},{"line":217,"kind":13,"containerName":"_nj","name":"$nodecount"},{"localvar":"my","definition":"my","name":"$mini","containerName":"_nj","line":218,"kind":13},{"line":218,"kind":13,"containerName":"_nj","name":"$minj"},{"name":"$min","containerName":"_nj","line":218,"kind":13},{"line":219,"kind":13,"name":"$i","containerName":"_nj"},{"line":219,"kind":13,"name":"$i","containerName":"_nj"},{"containerName":"_nj","name":"$N","line":219,"kind":13},{"line":219,"kind":13,"containerName":"_nj","name":"$i"},{"line":220,"kind":13,"containerName":"_nj","name":"$nodes"},{"containerName":"_nj","name":"$i","kind":13,"line":220},{"line":221,"kind":13,"name":"$j","containerName":"_nj"},{"kind":13,"line":221,"name":"$j","containerName":"_nj"},{"line":221,"kind":13,"containerName":"_nj","name":"$i"},{"kind":13,"line":221,"containerName":"_nj","name":"$j"},{"kind":13,"line":222,"containerName":"_nj","name":"$nodes"},{"line":222,"kind":13,"name":"$j","containerName":"_nj"},{"kind":13,"line":223,"name":"$dist","definition":"my","containerName":"_nj","localvar":"my"},{"line":223,"kind":13,"name":"$mat","containerName":"_nj"},{"line":223,"kind":13,"containerName":"_nj","name":"$i"},{"kind":13,"line":223,"name":"$j","containerName":"_nj"},{"line":223,"kind":13,"containerName":"_nj","name":"$r"},{"containerName":"_nj","name":"$i","line":223,"kind":13},{"name":"$r","containerName":"_nj","line":223,"kind":13},{"name":"$j","containerName":"_nj","kind":13,"line":223},{"line":224,"kind":13,"containerName":"_nj","name":"$min"},{"line":225,"kind":13,"name":"$dist","containerName":"_nj"},{"containerName":"_nj","name":"$min","kind":13,"line":225},{"containerName":"_nj","name":"$mini","kind":13,"line":226},{"kind":13,"line":226,"name":"$minj","containerName":"_nj"},{"kind":13,"line":226,"containerName":"_nj","name":"$min"},{"name":"$i","containerName":"_nj","kind":13,"line":226},{"kind":13,"line":226,"containerName":"_nj","name":"$j"},{"kind":13,"line":226,"containerName":"_nj","name":"$dist"},{"localvar":"my","definition":"my","name":"$dij","containerName":"_nj","line":230,"kind":13},{"name":"$mat","containerName":"_nj","line":230,"kind":13},{"containerName":"_nj","name":"$mini","line":230,"kind":13},{"kind":13,"line":230,"containerName":"_nj","name":"$minj"},{"line":231,"kind":13,"localvar":"my","name":"$dist_i","definition":"my","containerName":"_nj"},{"line":231,"kind":13,"name":"$dij","containerName":"_nj"},{"kind":13,"line":231,"containerName":"_nj","name":"$r"},{"containerName":"_nj","name":"$mini","line":231,"kind":13},{"containerName":"_nj","name":"$r","line":231,"kind":13},{"name":"$minj","containerName":"_nj","line":231,"kind":13},{"localvar":"my","containerName":"_nj","name":"$dist_j","definition":"my","line":232,"kind":13},{"name":"$dij","containerName":"_nj","line":232,"kind":13},{"name":"$dist_i","containerName":"_nj","line":232,"kind":13},{"containerName":"_nj","name":"$dist_i","kind":13,"line":236},{"containerName":"_nj","name":"$dist_i","line":237,"kind":13},{"name":"$dist_j","containerName":"_nj","line":238,"kind":13},{"kind":13,"line":238,"name":"$dij","containerName":"_nj"},{"name":"$dist_j","containerName":"_nj","kind":13,"line":239},{"name":"$dist_j","containerName":"_nj","kind":13,"line":239},{"line":240,"kind":13,"name":"$dist_j","containerName":"_nj"},{"line":241,"kind":13,"name":"$dist_j","containerName":"_nj"},{"kind":13,"line":242,"containerName":"_nj","name":"$dist_i"},{"line":242,"kind":13,"name":"$dij","containerName":"_nj"},{"kind":13,"line":243,"name":"$dist_i","containerName":"_nj"},{"kind":13,"line":243,"name":"$dist_i","containerName":"_nj"},{"containerName":"_nj","name":"$nodes","kind":13,"line":246},{"containerName":"_nj","name":"$mini","kind":13,"line":246},{"line":246,"kind":12,"containerName":"_nj","name":"branch_length"},{"line":246,"kind":13,"name":"$precisionstr","containerName":"_nj"},{"kind":13,"line":246,"containerName":"_nj","name":"$dist_i"},{"line":247,"kind":13,"containerName":"_nj","name":"$nodes"},{"name":"$minj","containerName":"_nj","line":247,"kind":13},{"line":247,"kind":12,"containerName":"_nj","name":"branch_length"},{"name":"$precisionstr","containerName":"_nj","kind":13,"line":247},{"kind":13,"line":247,"name":"$dist_j","containerName":"_nj"},{"kind":13,"line":249,"containerName":"_nj","definition":"my","name":"$newnode","localvar":"my"},{"kind":12,"line":249,"name":"new","containerName":"_nj"},{"kind":13,"line":249,"name":"$nodes","containerName":"_nj"},{"containerName":"_nj","name":"$mini","line":249,"kind":13},{"containerName":"_nj","name":"$nodes","line":250,"kind":13},{"kind":13,"line":250,"containerName":"_nj","name":"$minj"},{"kind":13,"line":252,"containerName":"_nj","name":"$nodes"},{"line":252,"kind":13,"name":"$mini","containerName":"_nj"},{"name":"$newnode","containerName":"_nj","kind":13,"line":252},{"containerName":"_nj","name":"$nodes","line":253,"kind":13},{"containerName":"_nj","name":"$minj","kind":13,"line":253},{"line":256,"kind":13,"containerName":"_nj","name":"$r"},{"line":256,"kind":13,"containerName":"_nj","name":"$mini"},{"containerName":"_nj","definition":"my","name":"$dmi","localvar":"my","kind":13,"line":257},{"kind":13,"line":257,"containerName":"_nj","name":"$dmj"},{"containerName":"_nj","name":"$m","line":258,"kind":13},{"line":258,"kind":13,"containerName":"_nj","name":"$m"},{"line":258,"kind":13,"containerName":"_nj","name":"$N"},{"kind":13,"line":258,"name":"$m","containerName":"_nj"},{"name":"$nodes","containerName":"_nj","line":259,"kind":13},{"name":"$m","containerName":"_nj","line":259,"kind":13},{"kind":13,"line":260,"name":"$m","containerName":"_nj"},{"name":"$mini","containerName":"_nj","kind":13,"line":260},{"kind":13,"line":261,"containerName":"_nj","name":"$dmj"},{"containerName":"_nj","name":"$mat","kind":13,"line":261},{"containerName":"_nj","name":"$m","kind":13,"line":261},{"name":"$minj","containerName":"_nj","kind":13,"line":261},{"kind":13,"line":263,"definition":"my","name":"$row","containerName":"_nj","localvar":"my"},{"line":263,"kind":13,"containerName":"_nj","name":"$col"},{"line":264,"kind":13,"containerName":"_nj","name":"$row"},{"kind":13,"line":264,"containerName":"_nj","name":"$col"},{"containerName":"_nj","name":"$m","kind":13,"line":264},{"containerName":"_nj","name":"$mini","kind":13,"line":264},{"containerName":"_nj","name":"$dmi","line":265,"kind":13},{"name":"$mat","containerName":"_nj","kind":13,"line":265},{"name":"$row","containerName":"_nj","line":265,"kind":13},{"line":265,"kind":13,"containerName":"_nj","name":"$col"},{"definition":"my","name":"$dmk","containerName":"_nj","localvar":"my","kind":13,"line":281},{"name":"$mat","containerName":"_nj","line":281,"kind":13},{"containerName":"_nj","name":"$row","kind":13,"line":281},{"name":"$col","containerName":"_nj","kind":13,"line":281},{"line":281,"kind":13,"containerName":"_nj","name":"$mat"},{"line":281,"kind":13,"containerName":"_nj","name":"$col"},{"name":"$row","containerName":"_nj","kind":13,"line":281},{"kind":13,"line":282,"containerName":"_nj","name":"$dmi"},{"kind":13,"line":282,"containerName":"_nj","name":"$dmj"},{"line":282,"kind":13,"name":"$dij","containerName":"_nj"},{"kind":13,"line":288,"containerName":"_nj","name":"$r"},{"line":288,"kind":13,"containerName":"_nj","name":"$m"},{"containerName":"_nj","name":"$r","kind":13,"line":288},{"name":"$m","containerName":"_nj","line":288,"kind":13},{"containerName":"_nj","name":"$L","line":288,"kind":13},{"name":"$dmi","containerName":"_nj","line":288,"kind":13},{"kind":13,"line":288,"containerName":"_nj","name":"$dmj"},{"name":"$mat","containerName":"_nj","line":289,"kind":13},{"kind":13,"line":289,"name":"$row","containerName":"_nj"},{"containerName":"_nj","name":"$col","line":289,"kind":13},{"line":289,"kind":13,"containerName":"_nj","name":"$L"},{"kind":13,"line":290,"containerName":"_nj","name":"$r"},{"line":290,"kind":13,"name":"$mini","containerName":"_nj"},{"kind":13,"line":290,"containerName":"_nj","name":"$dmk"},{"kind":13,"line":293,"containerName":"_nj","name":"$L"},{"containerName":"_nj","name":"$r","line":294,"kind":13},{"line":294,"kind":13,"containerName":"_nj","name":"$mini"},{"line":294,"kind":13,"containerName":"_nj","name":"$L"},{"kind":13,"line":298,"containerName":"_nj","definition":"my","name":"@leftovernodes","localvar":"my"},{"line":298,"kind":13,"name":"@leftovers","containerName":"_nj"},{"name":"$k","definition":"my","containerName":"_nj","localvar":"my","kind":13,"line":299},{"containerName":"_nj","name":"$k","line":299,"kind":13},{"containerName":"_nj","name":"$N","kind":13,"line":299},{"name":"$k","containerName":"_nj","kind":13,"line":299},{"line":300,"kind":13,"containerName":"_nj","name":"$nodes"},{"line":300,"kind":13,"name":"$k","containerName":"_nj"},{"name":"@leftovers","containerName":"_nj","line":301,"kind":13},{"kind":13,"line":301,"containerName":"_nj","name":"$k"},{"line":302,"kind":13,"containerName":"_nj","name":"@leftovernodes"},{"containerName":"_nj","name":"$nodes","line":302,"kind":13},{"containerName":"_nj","name":"$k","line":302,"kind":13},{"kind":13,"line":305,"name":"$l_0","definition":"my","containerName":"_nj","localvar":"my"},{"containerName":"_nj","name":"$l_1","kind":13,"line":305},{"kind":13,"line":305,"name":"$l_2","containerName":"_nj"},{"containerName":"_nj","name":"@leftovers","kind":13,"line":305},{"localvar":"my","containerName":"_nj","name":"$dist_i","definition":"my","line":307,"kind":13},{"containerName":"_nj","name":"$mat","kind":13,"line":307},{"name":"$l_1","containerName":"_nj","line":307,"kind":13},{"name":"$l_0","containerName":"_nj","kind":13,"line":307},{"containerName":"_nj","name":"$mat","line":307,"kind":13},{"containerName":"_nj","name":"$l_2","kind":13,"line":307},{"line":307,"kind":13,"name":"$l_0","containerName":"_nj"},{"line":308,"kind":13,"name":"$mat","containerName":"_nj"},{"name":"$l_2","containerName":"_nj","kind":13,"line":308},{"kind":13,"line":308,"name":"$l_1","containerName":"_nj"},{"kind":13,"line":310,"definition":"my","name":"$dist_j","containerName":"_nj","localvar":"my"},{"kind":13,"line":310,"name":"$mat","containerName":"_nj"},{"name":"$l_1","containerName":"_nj","kind":13,"line":310},{"containerName":"_nj","name":"$l_0","line":310,"kind":13},{"containerName":"_nj","name":"$dist_i","line":310,"kind":13},{"kind":13,"line":311,"containerName":"_nj","name":"$dist_k","definition":"my","localvar":"my"},{"kind":13,"line":311,"name":"$mat","containerName":"_nj"},{"containerName":"_nj","name":"$l_2","line":311,"kind":13},{"kind":13,"line":311,"containerName":"_nj","name":"$l_0"},{"name":"$dist_i","containerName":"_nj","line":311,"kind":13},{"kind":13,"line":314,"containerName":"_nj","name":"$dist_i"},{"containerName":"_nj","name":"$dist_i","line":315,"kind":13},{"name":"$dist_j","containerName":"_nj","kind":13,"line":316},{"line":316,"kind":13,"containerName":"_nj","name":"$mat"},{"kind":13,"line":316,"name":"$l_1","containerName":"_nj"},{"kind":13,"line":316,"name":"$l_0","containerName":"_nj"},{"line":317,"kind":13,"containerName":"_nj","name":"$dist_k"},{"line":317,"kind":13,"name":"$mat","containerName":"_nj"},{"kind":13,"line":317,"name":"$l_2","containerName":"_nj"},{"kind":13,"line":317,"containerName":"_nj","name":"$l_0"},{"containerName":"_nj","name":"$dist_j","line":318,"kind":13},{"line":319,"kind":13,"containerName":"_nj","name":"$dist_j"},{"name":"$dist_k","containerName":"_nj","kind":13,"line":320},{"kind":13,"line":320,"containerName":"_nj","name":"$mat"},{"line":320,"kind":13,"containerName":"_nj","name":"$l_2"},{"name":"$l_0","containerName":"_nj","line":320,"kind":13},{"line":320,"kind":13,"name":"$mat","containerName":"_nj"},{"kind":13,"line":320,"containerName":"_nj","name":"$l_2"},{"containerName":"_nj","name":"$l_1","kind":13,"line":320},{"containerName":"_nj","name":"$dist_k","line":321,"kind":13},{"kind":13,"line":321,"name":"$dist_k","containerName":"_nj"},{"line":322,"kind":13,"containerName":"_nj","name":"$dist_k"},{"containerName":"_nj","name":"$dist_k","kind":13,"line":323},{"line":324,"kind":13,"containerName":"_nj","name":"$dist_j"},{"line":324,"kind":13,"name":"$mat","containerName":"_nj"},{"kind":13,"line":324,"name":"$l_1","containerName":"_nj"},{"kind":13,"line":324,"containerName":"_nj","name":"$l_0"},{"line":324,"kind":13,"name":"$mat","containerName":"_nj"},{"containerName":"_nj","name":"$l_2","line":324,"kind":13},{"kind":13,"line":324,"containerName":"_nj","name":"$l_1"},{"line":325,"kind":13,"name":"$dist_j","containerName":"_nj"},{"name":"$dist_j","containerName":"_nj","kind":13,"line":325},{"name":"$dist_j","containerName":"_nj","line":327,"kind":13},{"kind":13,"line":328,"containerName":"_nj","name":"$dist_j"},{"line":329,"kind":13,"name":"$dist_i","containerName":"_nj"},{"containerName":"_nj","name":"$mat","kind":13,"line":329},{"line":329,"kind":13,"containerName":"_nj","name":"$l_1"},{"line":329,"kind":13,"containerName":"_nj","name":"$l_0"},{"kind":13,"line":330,"name":"$dist_k","containerName":"_nj"},{"kind":13,"line":330,"name":"$mat","containerName":"_nj"},{"name":"$l_2","containerName":"_nj","kind":13,"line":330},{"kind":13,"line":330,"containerName":"_nj","name":"$l_1"},{"containerName":"_nj","name":"$dist_i","line":331,"kind":13},{"containerName":"_nj","name":"$dist_i","kind":13,"line":332},{"name":"$dist_k","containerName":"_nj","kind":13,"line":333},{"containerName":"_nj","name":"$mat","line":333,"kind":13},{"kind":13,"line":333,"containerName":"_nj","name":"$l_2"},{"kind":13,"line":333,"containerName":"_nj","name":"$l_0"},{"name":"$mat","containerName":"_nj","line":333,"kind":13},{"kind":13,"line":333,"containerName":"_nj","name":"$l_2"},{"containerName":"_nj","name":"$l_1","kind":13,"line":333},{"kind":13,"line":334,"name":"$dist_k","containerName":"_nj"},{"containerName":"_nj","name":"$dist_k","line":334,"kind":13},{"containerName":"_nj","name":"$dist_k","kind":13,"line":335},{"line":336,"kind":13,"containerName":"_nj","name":"$dist_k"},{"name":"$dist_i","containerName":"_nj","line":337,"kind":13},{"name":"$mat","containerName":"_nj","kind":13,"line":337},{"kind":13,"line":337,"containerName":"_nj","name":"$l_1"},{"name":"$l_0","containerName":"_nj","line":337,"kind":13},{"containerName":"_nj","name":"$mat","line":337,"kind":13},{"containerName":"_nj","name":"$l_2","kind":13,"line":337},{"name":"$l_0","containerName":"_nj","kind":13,"line":337},{"kind":13,"line":338,"containerName":"_nj","name":"$dist_i"},{"line":338,"kind":13,"containerName":"_nj","name":"$dist_i"},{"line":340,"kind":13,"containerName":"_nj","name":"$dist_k"},{"kind":13,"line":341,"name":"$dist_k","containerName":"_nj"},{"name":"$dist_i","containerName":"_nj","line":342,"kind":13},{"kind":13,"line":342,"containerName":"_nj","name":"$mat"},{"kind":13,"line":342,"containerName":"_nj","name":"$l_2"},{"line":342,"kind":13,"name":"$l_0","containerName":"_nj"},{"kind":13,"line":343,"containerName":"_nj","name":"$dist_j"},{"line":343,"kind":13,"containerName":"_nj","name":"$mat"},{"line":343,"kind":13,"name":"$l_2","containerName":"_nj"},{"containerName":"_nj","name":"$l_1","kind":13,"line":343},{"line":344,"kind":13,"containerName":"_nj","name":"$dist_i"},{"name":"$dist_i","containerName":"_nj","kind":13,"line":345},{"containerName":"_nj","name":"$dist_j","kind":13,"line":346},{"line":346,"kind":13,"containerName":"_nj","name":"$mat"},{"containerName":"_nj","name":"$l_1","kind":13,"line":346},{"kind":13,"line":346,"name":"$l_0","containerName":"_nj"},{"containerName":"_nj","name":"$mat","line":346,"kind":13},{"name":"$l_2","containerName":"_nj","kind":13,"line":346},{"name":"$l_1","containerName":"_nj","line":346,"kind":13},{"line":347,"kind":13,"containerName":"_nj","name":"$dist_j"},{"containerName":"_nj","name":"$dist_j","kind":13,"line":347},{"kind":13,"line":348,"containerName":"_nj","name":"$dist_j"},{"kind":13,"line":349,"containerName":"_nj","name":"$dist_j"},{"kind":13,"line":350,"name":"$dist_i","containerName":"_nj"},{"line":350,"kind":13,"containerName":"_nj","name":"$mat"},{"kind":13,"line":350,"name":"$l_1","containerName":"_nj"},{"line":350,"kind":13,"containerName":"_nj","name":"$l_0"},{"containerName":"_nj","name":"$mat","kind":13,"line":350},{"line":350,"kind":13,"name":"$l_2","containerName":"_nj"},{"name":"$l_0","containerName":"_nj","kind":13,"line":350},{"name":"$dist_i","containerName":"_nj","line":351,"kind":13},{"line":351,"kind":13,"name":"$dist_i","containerName":"_nj"},{"name":"$leftovernodes","containerName":"_nj","kind":13,"line":354},{"line":354,"kind":12,"containerName":"_nj","name":"branch_length"},{"line":354,"kind":13,"name":"$precisionstr","containerName":"_nj"},{"name":"$dist_i","containerName":"_nj","kind":13,"line":354},{"containerName":"_nj","name":"$leftovernodes","line":355,"kind":13},{"containerName":"_nj","name":"branch_length","kind":12,"line":355},{"line":355,"kind":13,"name":"$precisionstr","containerName":"_nj"},{"containerName":"_nj","name":"$dist_j","line":355,"kind":13},{"kind":13,"line":356,"containerName":"_nj","name":"$leftovernodes"},{"kind":12,"line":356,"name":"branch_length","containerName":"_nj"},{"line":356,"kind":13,"containerName":"_nj","name":"$precisionstr"},{"containerName":"_nj","name":"$dist_k","kind":13,"line":356},{"name":"new","containerName":"_nj","kind":12,"line":358},{"line":359,"kind":12,"name":"new","containerName":"_nj"},{"containerName":"_nj","name":"@leftovernodes","line":359,"kind":13}],"line":176,"kind":12,"signature":{"documentation":"1;\n# $Id: DistanceFactory.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tree::DistanceFactory\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::DistanceFactory - Construct a tree using distance based methods\n\n=head1 SYNOPSIS\n\n  use Bio::Tree::DistanceFactory;\n  use Bio::AlignIO;\n  use Bio::Align::DNAStatistics;\n  my $tfactory = Bio::Tree::DistanceFactory->new(-method => \"NJ\");\n  my $stats    = Bio::Align::DNAStatistics->new();\n\n  my $alnin    = Bio::AlignIO->new(-format => 'clustalw',\n                                   -file   => 'file.aln');\n  my $aln = $alnin->next_aln;\n  # Of course matrix can come from a different place\n  # like PHYLIP if you prefer, Bio::Matrix::IO should be able\n  # to parse many things\n  my $jcmatrix = $stats->distance(-align => $aln, \n                                  -method => 'Jukes-Cantor');\n  my $tree = $tfactory->make_tree($jcmatrix);\n\n\n=head1 DESCRIPTION\n\nThis is a factory which will construct a phylogenetic tree based on\nthe pairwise sequence distances for a set of sequences.  Currently\nUPGMA (Sokal and Michener 1958) and NJ (Saitou and Nei 1987) tree\nconstruction methods are implemented.\n\n=head1 REFERENCES\n\nEddy SR, Durbin R, Krogh A, Mitchison G, (1998) \"Biological Sequence Analysis\",\nCambridge Univ Press, Cambridge, UK.\n\nHowe K, Bateman A, Durbin R, (2002) \"QuickTree: building huge\nNeighbour-Joining trees of protein sequences.\" Bioinformatics\n18(11):1546-1547.\n\nSaitou N and Nei M, (1987) \"The neighbor-joining method: a new method\nfor reconstructing phylogenetic trees.\" Mol Biol Evol 4(4):406-25.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::Tree::DistanceFactory;\nuse vars qw($DefaultMethod $Precision);\nuse strict;\n\n# some defaults\n$DefaultMethod = 'UPGMA';\n$Precision = 5;\n\nuse Bio::Tree::Node;\nuse Bio::Tree::Tree;\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tree::DistanceFactory->new();\n Function: Builds a new Bio::Tree::DistanceFactory object \n Returns : an instance of Bio::Tree::DistanceFactory\n Args    : -method => 'NJ' or 'UPGMA'\n\n\n\nsub new {\n  my($class,@args) = @_;  \n  my $self = $class->SUPER::new(@args);\n\n  my ($method) = $self->_rearrange([qw(METHOD)],\n\t\t\t\t   @args);\n  $self->method($method || $DefaultMethod);\n  return $self;\n}\n\n=head2 make_tree\n\n Title   : make_tree\n Usage   : my $tree = $disttreefact->make_tree($matrix);\n Function: Build a Tree based on a distance matrix\n Returns : L<Bio::Tree::TreeI>\n Args    : L<Bio::Matrix::MatrixI> object\n\n\n\nsub make_tree{\n   my ($self,$matrix) = @_;\n   if( ! defined $matrix || !ref($matrix) || \n       ! $matrix->isa('Bio::Matrix::MatrixI') ) {\n       $self->warn(\"Need to provide a valid Bio::Matrix::MatrixI object to make_tree\");\n       return;\n   }\n\n   my $method = uc ($self->method);\n   if( $method =~ /NJ/i ) {\n       return $self->_nj($matrix);\n   } elsif( $method =~ /UPGMA/i ) {\n       return $self->_upgma($matrix);\n   } else { \n       $self->warn(\"Unknown tree construction method '$method'.  Cannot run.\");\n       return;\n   }\n   \n}\n\n\n=head2 _nj\n\n Title   : _nj\n Usage   : my $tree = $disttreefact->_nj($matrix);\n Function: Construct a tree based on distance matrix using the \n           Neighbor Joining algorithm (Saitou and Nei, 1987)\n           Implementation based on Kevin Howe's Quicktree implementation\n           and uses his tricks (some based on Bill Bruno's work) to eliminate\n           negative branch lengths\n Returns : L<Bio::Tree::TreeI>\n Args    : L<Bio::Matrix::MatrixI> object","parameters":[{"label":"$self"},{"label":"$distmat"}],"label":"_nj($self,$distmat)"},"detail":"($self,$distmat)","definition":"sub","containerName":"main::"},{"kind":12,"line":198,"containerName":"Tree::Node","name":"Bio"},{"name":"Bio","containerName":"Tree::Node","kind":12,"line":200},{"name":"Bio","containerName":"Tree::Tree","line":203,"kind":12},{"name":"Bio","containerName":"Tree::Node","kind":12,"line":208},{"line":249,"kind":12,"containerName":"Tree::Node","name":"Bio"},{"containerName":"Tree::Tree","name":"Bio","line":358,"kind":12},{"containerName":"Tree::Node","name":"Bio","line":358,"kind":12},{"range":{"end":{"line":453,"character":9999},"start":{"line":373,"character":0}},"name":"_upgma","line":373,"children":[{"kind":13,"line":374,"containerName":"_upgma","definition":"my","name":"$self","localvar":"my"},{"line":374,"kind":13,"name":"$distmat","containerName":"_upgma"},{"definition":"my","name":"$precisionstr","containerName":"_upgma","localvar":"my","kind":13,"line":382},{"localvar":"my","definition":"my","name":"$i","containerName":"_upgma","line":384,"kind":13},{"kind":13,"line":384,"name":"$j","containerName":"_upgma"},{"kind":13,"line":384,"name":"$x","containerName":"_upgma"},{"line":384,"kind":13,"name":"$y","containerName":"_upgma"},{"line":384,"kind":13,"name":"@dmat","containerName":"_upgma"},{"containerName":"_upgma","name":"@orig","line":384,"kind":13},{"kind":13,"line":384,"containerName":"_upgma","name":"@nodes"},{"line":386,"kind":13,"localvar":"my","name":"@names","definition":"my","containerName":"_upgma"},{"containerName":"_upgma","name":"$distmat","line":386,"kind":13},{"line":386,"kind":12,"name":"column_names","containerName":"_upgma"},{"localvar":"my","containerName":"_upgma","name":"$c","definition":"my","line":387,"kind":13},{"localvar":"my","containerName":"_upgma","definition":"my","name":"@clusters","line":388,"kind":13},{"name":"$r","definition":"my","containerName":"_upgma","localvar":"my","kind":13,"line":389},{"name":"$c","containerName":"_upgma","line":389,"kind":13},{"containerName":"_upgma","name":"$c","kind":13,"line":391},{"containerName":"_upgma","name":"$c","kind":13,"line":393},{"name":"$r","containerName":"_upgma","kind":13,"line":394},{"line":395,"kind":13,"name":"@names","containerName":"_upgma"},{"localvar":"my","definition":"my","name":"$K","containerName":"_upgma","line":397,"kind":13},{"containerName":"_upgma","name":"@clusters","line":397,"kind":13},{"containerName":"_upgma","name":"@mins","definition":"my","localvar":"my","kind":13,"line":398},{"kind":13,"line":398,"name":"$min","containerName":"_upgma"},{"containerName":"_upgma","name":"$i","line":399,"kind":13},{"line":399,"kind":13,"name":"$i","containerName":"_upgma"},{"line":399,"kind":13,"containerName":"_upgma","name":"$K"},{"line":399,"kind":13,"name":"$i","containerName":"_upgma"},{"line":400,"kind":13,"name":"$j","containerName":"_upgma"},{"kind":13,"line":400,"containerName":"_upgma","name":"$i"},{"line":400,"kind":13,"containerName":"_upgma","name":"$j"},{"name":"$K","containerName":"_upgma","line":400,"kind":13},{"kind":13,"line":400,"name":"$j","containerName":"_upgma"},{"line":401,"kind":13,"localvar":"my","containerName":"_upgma","name":"$d","definition":"my"},{"name":"$distmat","containerName":"_upgma","kind":13,"line":401},{"kind":12,"line":401,"containerName":"_upgma","name":"get_entry"},{"line":401,"kind":13,"name":"$names","containerName":"_upgma"},{"name":"$i","containerName":"_upgma","line":401,"kind":13},{"line":401,"kind":13,"containerName":"_upgma","name":"$names"},{"name":"$j","containerName":"_upgma","kind":13,"line":401},{"name":"$dmat","containerName":"_upgma","line":403,"kind":13},{"name":"$j","containerName":"_upgma","line":403,"kind":13},{"line":403,"kind":13,"name":"$i","containerName":"_upgma"},{"line":403,"kind":13,"containerName":"_upgma","name":"$dmat"},{"line":403,"kind":13,"name":"$i","containerName":"_upgma"},{"kind":13,"line":403,"containerName":"_upgma","name":"$j"},{"containerName":"_upgma","name":"$d","kind":13,"line":403},{"containerName":"_upgma","name":"$orig","kind":13,"line":404},{"line":404,"kind":13,"containerName":"_upgma","name":"$i"},{"line":404,"kind":13,"containerName":"_upgma","name":"$j"},{"line":404,"kind":13,"containerName":"_upgma","name":"$orig"},{"line":404,"kind":13,"name":"$j","containerName":"_upgma"},{"name":"$i","containerName":"_upgma","kind":13,"line":404},{"containerName":"_upgma","name":"$d","kind":13,"line":404},{"containerName":"_upgma","name":"$min","kind":13,"line":405},{"kind":13,"line":405,"name":"$d","containerName":"_upgma"},{"line":405,"kind":13,"name":"$min","containerName":"_upgma"},{"line":406,"kind":13,"name":"$min","containerName":"_upgma"},{"line":406,"kind":13,"name":"$min","containerName":"_upgma"},{"kind":13,"line":406,"containerName":"_upgma","name":"$d"},{"name":"@mins","containerName":"_upgma","kind":13,"line":407},{"kind":13,"line":407,"name":"$i","containerName":"_upgma"},{"kind":13,"line":407,"name":"$j","containerName":"_upgma"},{"name":"@mins","containerName":"_upgma","line":409,"kind":13},{"containerName":"_upgma","name":"$i","kind":13,"line":409},{"name":"$j","containerName":"_upgma","kind":13,"line":409},{"line":410,"kind":13,"name":"$min","containerName":"_upgma"},{"line":410,"kind":13,"containerName":"_upgma","name":"$d"},{"containerName":"_upgma","name":"$K","kind":13,"line":417},{"kind":13,"line":420,"name":"$min","containerName":"_upgma"},{"kind":13,"line":421,"containerName":"_upgma","name":"$i"},{"kind":13,"line":421,"name":"$i","containerName":"_upgma"},{"name":"$K","containerName":"_upgma","kind":13,"line":421},{"containerName":"_upgma","name":"$i","kind":13,"line":421},{"containerName":"_upgma","name":"$j","kind":13,"line":422},{"name":"$i","containerName":"_upgma","line":422,"kind":13},{"line":422,"kind":13,"name":"$j","containerName":"_upgma"},{"containerName":"_upgma","name":"$K","line":422,"kind":13},{"line":422,"kind":13,"name":"$j","containerName":"_upgma"},{"containerName":"_upgma","definition":"my","name":"$dij","localvar":"my","kind":13,"line":423},{"kind":13,"line":423,"containerName":"_upgma","name":"$dmat"},{"name":"$i","containerName":"_upgma","kind":13,"line":423},{"containerName":"_upgma","name":"$j","line":423,"kind":13},{"name":"$min","containerName":"_upgma","kind":13,"line":424},{"line":425,"kind":13,"containerName":"_upgma","name":"$dij"},{"name":"$min","containerName":"_upgma","line":425,"kind":13},{"containerName":"_upgma","name":"$min","line":426,"kind":13},{"name":"$min","containerName":"_upgma","line":427,"kind":13},{"containerName":"_upgma","name":"$dij","kind":13,"line":427},{"containerName":"_upgma","name":"@mins","kind":13,"line":428},{"name":"$i","containerName":"_upgma","kind":13,"line":428},{"name":"$j","containerName":"_upgma","line":428,"kind":13},{"kind":13,"line":430,"name":"@mins","containerName":"_upgma"},{"name":"$i","containerName":"_upgma","kind":13,"line":430},{"containerName":"_upgma","name":"$j","line":430,"kind":13},{"line":431,"kind":13,"containerName":"_upgma","name":"$min"},{"line":431,"kind":13,"name":"$dij","containerName":"_upgma"},{"line":438,"kind":13,"name":"$x","containerName":"_upgma"},{"kind":13,"line":438,"containerName":"_upgma","name":"$y"},{"containerName":"_upgma","name":"$mins","kind":13,"line":438},{"kind":13,"line":438,"name":"@mins","containerName":"_upgma"},{"kind":13,"line":442,"containerName":"_upgma","name":"$node","definition":"my","localvar":"my"},{"line":442,"kind":12,"name":"new","containerName":"_upgma"},{"containerName":"_upgma","name":"@subids","definition":"my","localvar":"my","kind":13,"line":443},{"line":444,"kind":13,"localvar":"my","containerName":"_upgma","name":"$cid","definition":"my"},{"kind":13,"line":444,"name":"$x","containerName":"_upgma"},{"kind":13,"line":444,"name":"$y","containerName":"_upgma"},{"containerName":"_upgma","definition":"my","name":"$nid","localvar":"my","kind":13,"line":445},{"kind":13,"line":445,"name":"$clusters","containerName":"_upgma"},{"name":"$cid","containerName":"_upgma","kind":13,"line":445},{"name":"$nodes","containerName":"_upgma","line":446,"kind":13},{"containerName":"_upgma","name":"$nid","line":446,"kind":13},{"line":447,"kind":13,"containerName":"_upgma","name":"$nodes"},{"name":"$nid","containerName":"_upgma","kind":13,"line":447},{"line":447,"kind":12,"name":"new","containerName":"_upgma"},{"line":447,"kind":13,"containerName":"_upgma","name":"$names"},{"kind":13,"line":447,"name":"$nid","containerName":"_upgma"},{"name":"$nodes","containerName":"_upgma","line":449,"kind":13},{"kind":13,"line":449,"name":"$nid","containerName":"_upgma"},{"line":450,"kind":12,"name":"branch_length","containerName":"_upgma"},{"containerName":"_upgma","name":"$precisionstr","kind":13,"line":450},{"containerName":"_upgma","name":"$min","line":450,"kind":13},{"containerName":"_upgma","name":"$clusters","line":450,"kind":13},{"kind":13,"line":450,"name":"$cid","containerName":"_upgma"},{"name":"$node","containerName":"_upgma","kind":13,"line":451},{"line":451,"kind":12,"name":"add_Descendent","containerName":"_upgma"},{"kind":13,"line":451,"containerName":"_upgma","name":"$nodes"},{"kind":13,"line":451,"containerName":"_upgma","name":"$nid"},{"line":452,"kind":13,"containerName":"_upgma","name":"@subids"},{"kind":13,"line":452,"name":"$clusters","containerName":"_upgma"},{"kind":13,"line":452,"name":"$cid","containerName":"_upgma"}],"kind":12,"detail":"($self,$distmat)","signature":{"label":"_upgma($self,$distmat)","documentation":"1;\n# $Id: DistanceFactory.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tree::DistanceFactory\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::DistanceFactory - Construct a tree using distance based methods\n\n=head1 SYNOPSIS\n\n  use Bio::Tree::DistanceFactory;\n  use Bio::AlignIO;\n  use Bio::Align::DNAStatistics;\n  my $tfactory = Bio::Tree::DistanceFactory->new(-method => \"NJ\");\n  my $stats    = Bio::Align::DNAStatistics->new();\n\n  my $alnin    = Bio::AlignIO->new(-format => 'clustalw',\n                                   -file   => 'file.aln');\n  my $aln = $alnin->next_aln;\n  # Of course matrix can come from a different place\n  # like PHYLIP if you prefer, Bio::Matrix::IO should be able\n  # to parse many things\n  my $jcmatrix = $stats->distance(-align => $aln, \n                                  -method => 'Jukes-Cantor');\n  my $tree = $tfactory->make_tree($jcmatrix);\n\n\n=head1 DESCRIPTION\n\nThis is a factory which will construct a phylogenetic tree based on\nthe pairwise sequence distances for a set of sequences.  Currently\nUPGMA (Sokal and Michener 1958) and NJ (Saitou and Nei 1987) tree\nconstruction methods are implemented.\n\n=head1 REFERENCES\n\nEddy SR, Durbin R, Krogh A, Mitchison G, (1998) \"Biological Sequence Analysis\",\nCambridge Univ Press, Cambridge, UK.\n\nHowe K, Bateman A, Durbin R, (2002) \"QuickTree: building huge\nNeighbour-Joining trees of protein sequences.\" Bioinformatics\n18(11):1546-1547.\n\nSaitou N and Nei M, (1987) \"The neighbor-joining method: a new method\nfor reconstructing phylogenetic trees.\" Mol Biol Evol 4(4):406-25.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::Tree::DistanceFactory;\nuse vars qw($DefaultMethod $Precision);\nuse strict;\n\n# some defaults\n$DefaultMethod = 'UPGMA';\n$Precision = 5;\n\nuse Bio::Tree::Node;\nuse Bio::Tree::Tree;\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tree::DistanceFactory->new();\n Function: Builds a new Bio::Tree::DistanceFactory object \n Returns : an instance of Bio::Tree::DistanceFactory\n Args    : -method => 'NJ' or 'UPGMA'\n\n\n\nsub new {\n  my($class,@args) = @_;  \n  my $self = $class->SUPER::new(@args);\n\n  my ($method) = $self->_rearrange([qw(METHOD)],\n\t\t\t\t   @args);\n  $self->method($method || $DefaultMethod);\n  return $self;\n}\n\n=head2 make_tree\n\n Title   : make_tree\n Usage   : my $tree = $disttreefact->make_tree($matrix);\n Function: Build a Tree based on a distance matrix\n Returns : L<Bio::Tree::TreeI>\n Args    : L<Bio::Matrix::MatrixI> object\n\n\n\nsub make_tree{\n   my ($self,$matrix) = @_;\n   if( ! defined $matrix || !ref($matrix) || \n       ! $matrix->isa('Bio::Matrix::MatrixI') ) {\n       $self->warn(\"Need to provide a valid Bio::Matrix::MatrixI object to make_tree\");\n       return;\n   }\n\n   my $method = uc ($self->method);\n   if( $method =~ /NJ/i ) {\n       return $self->_nj($matrix);\n   } elsif( $method =~ /UPGMA/i ) {\n       return $self->_upgma($matrix);\n   } else { \n       $self->warn(\"Unknown tree construction method '$method'.  Cannot run.\");\n       return;\n   }\n   \n}\n\n\n=head2 _nj\n\n Title   : _nj\n Usage   : my $tree = $disttreefact->_nj($matrix);\n Function: Construct a tree based on distance matrix using the \n           Neighbor Joining algorithm (Saitou and Nei, 1987)\n           Implementation based on Kevin Howe's Quicktree implementation\n           and uses his tricks (some based on Bill Bruno's work) to eliminate\n           negative branch lengths\n Returns : L<Bio::Tree::TreeI>\n Args    : L<Bio::Matrix::MatrixI> object\n\n\nsub _nj {\n   my ($self,$distmat) = @_;\n\n   # we assume type checking of $aln has already been done\n   # client shouldn't be calling this directly anyways, using the\n   # make_tree method is preferred\n   \n   # so that we can trim the number of digits shown as the branch length\n   my $precisionstr = \"%.$Precision\".\"f\";\n\n   my @names =  $distmat->column_names;\n   my $N = scalar @names;\n   my ($i,$j,$m,@nodes,$mat,@r);\n   my $L = $N;\n\n   if( $N < 2 ) {\n       $self->warn(\"Can only perform NJ treebuilding on sets of 2 or more species\\n\");\n       return;\n   } elsif( $N == 2 ) {\n       $i = 0;\n       my $d = sprintf($precisionstr,\n\t\t       $distmat->get_entry($names[0],$names[1]) / 2);\n       my $root = Bio::Tree::Node->new();\n       for my $nm ( @names ) {\n\t   $root->add_Descendents( Bio::Tree::Node->new(-id => $nm,\n\t\t\t\t\t\t\t-branch_length => $d));\n       }\n       return Bio::Tree::Tree(-root => $root);\n   }\n   my $c = 0;\n   \n   for ( $i = 0; $i < $N; $i++ ) {\n       push @nodes, Bio::Tree::Node->new(-id => $names[$i]);\n       my $ri = 0;\n       for( $j = 0; $j < $N; $j++ ) {\n\t   $mat->[$i][$j] = $distmat->get_entry($names[$i],$names[$j]);\n\t   $ri += $mat->[$i][$j];\n       }\n       $r[$i] = $ri / ($L -2);\n   }\n   \n   for( my $nodecount = 0; $nodecount < $N-3; $nodecount++) {\n       my ($mini,$minj,$min);\n       for($i = 0; $i < $N; $i++ ) {\n\t   next unless defined $nodes[$i];\n\t   for( $j = 0; $j < $i; $j++ ) {\n\t       next unless defined $nodes[$j];\n\t       my $dist = $mat->[$i][$j] - ($r[$i] + $r[$j]);\n\t       if( ! defined $min ||\n\t\t   $dist <= $min) {\n\t\t   ($mini,$minj,$min) = ($i,$j,$dist);\n\t       }\n\t   }\n       }\n       my $dij    = $mat->[$mini][$minj];\n       my $dist_i = ($dij + $r[$mini] - $r[$minj]) / 2;\n       my $dist_j = $dij - $dist_i;\n       \n       # deal with negative branch lengths\n       # per code in K.Howe's quicktree\n       if( $dist_i < 0 ) {\n\t   $dist_i = 0;\n\t   $dist_j = $dij;\n\t   $dist_j = 0 if( $dist_j < 0 );\n       } elsif( $dist_j < 0 ) { \n\t   $dist_j = 0;\n\t   $dist_i = $dij;\n\t   $dist_i = 0 if( $dist_i < 0 );\n       }\n       \n       $nodes[$mini]->branch_length(sprintf($precisionstr,$dist_i));\n       $nodes[$minj]->branch_length(sprintf($precisionstr,$dist_j));\n       \n       my $newnode = Bio::Tree::Node->new(-descendents => [ $nodes[$mini],\n\t\t\t\t\t\t\t    $nodes[$minj] ]);\n\n       $nodes[$mini] = $newnode;\n       delete $nodes[$minj];\n       \n       # update the distance matrix\n       $r[$mini] = 0;\n       my ($dmi,$dmj);\n       for( $m = 0; $m < $N; $m++ ) {\t   \n\t   next unless defined $nodes[$m];\n\t   if( $m != $mini ) {\n\t       $dmj = $mat->[$m][$minj];\n\t       \n\t       my ($row,$col);\n\t       ($row,$col) = ($m,$mini);\n\t       $dmi = $mat->[$row][$col];\n\t       \n\t       # from K.Howe's notes in quicktree\n\t       # we can actually adjust r[m] here, by using the form:\n\t       # rm = ((rm * numseqs) - dmi - dmj + dmk) / (numseqs-1)\n\n\t       # Note: in Bill Bruno's method for negative branch\n\t       # elimination, then if either dist_i is positive and\n\t       # dist_j is 0, or dist_i is zero and dist_j is positive\n\t       # (after adjustment) then the matrix entry is formed\n\t       # from the distance to the node in question (m) to the\n\t       # node with the zero branch length (whichever it was).\n\t       # I think my code already has the same effect; this is\n\t       # certainly true if dij is equal to dist_i + dist_j,\n\t       # which it should have been fixed to\n\n\t       my $dmk = $mat->[$row][$col] = $mat->[$col][$row] = \n\t\t   ($dmi + $dmj - $dij) / 2;\n\t       \n\t       # If we don't want to try and correct negative brlens\n\t       # this is essentially what is in Edddy et al, BSA book.\n\t       # $r[$m] = (($r[$m] * $L) - $dmi - $dmj + $dmk) / ($L-1);\n\t       # \n\t       $r[$m] = (($r[$m] * ($L - 2)) - $dmi - $dmj + \n\t\t\t $mat->[$row][$col]) / ( $L - 3);\n\t       $r[$mini] += $dmk;\n\t   }\n       }\n       $L--;\n       $r[$mini] /= $L - 2;\n   }\n   \n   # should be 3 nodes left\n   my (@leftovernodes,@leftovers);\n   for( my $k = 0; $k < $N; $k++ ) {\n       if( defined $nodes[$k] ) {\n\t   push @leftovers, $k;\n\t   push @leftovernodes, $nodes[$k];\n       }\n   }\n   my ($l_0,$l_1,$l_2) = @leftovers;\n   \n   my $dist_i = ( $mat->[$l_1][$l_0] + $mat->[$l_2][$l_0] -\n\t\t  $mat->[$l_2][$l_1] ) / 2;\n   \n   my $dist_j = ( $mat->[$l_1][$l_0] - $dist_i);\n   my $dist_k = ( $mat->[$l_2][$l_0] - $dist_i);\n\n   # This is Kev's code to get rid of negative branch lengths\n   if( $dist_i < 0 ) { \n       $dist_i = 0;\n       $dist_j = $mat->[$l_1][$l_0];\n       $dist_k = $mat->[$l_2][$l_0];\n       if( $dist_j < 0 ) { \n\t   $dist_j = 0;\n\t   $dist_k = ( $mat->[$l_2][$l_0] + $mat->[$l_2][$l_1] ) / 2;\n\t   $dist_k = 0 if( $dist_k < 0 );\n       } elsif( $dist_k < 0 ) {\n\t   $dist_k = 0;\n\t   $dist_j = ($mat->[$l_1][$l_0] + $mat->[$l_2][$l_1]) / 2;\n\t   $dist_j = 0 if( $dist_j < 0 );\n       }\n   } elsif( $dist_j < 0 ) {\n       $dist_j = 0;\n       $dist_i = $mat->[$l_1][$l_0];\n       $dist_k = $mat->[$l_2][$l_1];\n       if( $dist_i < 0 ) { \n\t   $dist_i = 0;\n\t   $dist_k = ( $mat->[$l_2][$l_0] + $mat->[$l_2][$l_1]) / 2;\n\t   $dist_k = 0 if( $dist_k  < 0 );\n       } elsif( $dist_k < 0 ) { \n\t   $dist_k = 0;\n\t   $dist_i = ( $mat->[$l_1][$l_0] + $mat->[$l_2][$l_0]) / 2;\n\t   $dist_i = 0 if( $dist_i < 0 );\n       }\n   } elsif( $dist_k < 0 ) {\n       $dist_k = 0;\n       $dist_i = $mat->[$l_2][$l_0];\n       $dist_j = $mat->[$l_2][$l_1];\n       if( $dist_i < 0 ) { \n\t   $dist_i = 0;\n\t   $dist_j = ( $mat->[$l_1][$l_0] + $mat->[$l_2][$l_1] ) / 2;\n\t   $dist_j = 0 if $dist_j < 0;\n       } elsif( $dist_j < 0  ) {\n\t   $dist_j = 0;\n\t   $dist_i = ($mat->[$l_1][$l_0] + $mat->[$l_2][$l_0]) / 2;\n\t   $dist_i = 0 if $dist_i < 0;\n       }\n   }\n   $leftovernodes[0]->branch_length(sprintf($precisionstr,$dist_i));\n   $leftovernodes[1]->branch_length(sprintf($precisionstr,$dist_j));\n   $leftovernodes[2]->branch_length(sprintf($precisionstr,$dist_k));\n\n   Bio::Tree::Tree->new(-root => Bio::Tree::Node->new\n\t\t\t(-descendents => \\@leftovernodes));\n}\n\n=head2 _upgma\n\n Title   : _upgma\n Usage   : my $tree = $disttreefact->_upgma($matrix);\n Function: Construct a tree based on alignment using UPGMA\n Returns : L<Bio::Tree::TreeI>\n Args    : L<Bio::Matrix::MatrixI> object","parameters":[{"label":"$self"},{"label":"$distmat"}]},"containerName":"main::","definition":"sub"},{"line":442,"kind":12,"name":"Bio","containerName":"Tree::Node"},{"line":447,"kind":12,"name":"Bio","containerName":"Tree::Node"},{"kind":13,"line":454,"containerName":null,"definition":"my","name":"%cluster","localvar":"my"},{"kind":13,"line":454,"name":"$c","containerName":null},{"line":455,"kind":13,"containerName":null,"name":"@min"},{"name":"@subids","containerName":null,"kind":13,"line":456},{"line":459,"kind":13,"name":"$K","containerName":null},{"name":"@nodes","containerName":null,"line":460,"kind":13},{"line":460,"kind":13,"containerName":null,"name":"%cluster"},{"name":"$node","containerName":null,"line":460,"kind":13},{"containerName":null,"name":"$y","line":461,"kind":13},{"kind":13,"line":461,"name":"%K","containerName":null},{"name":"@clusters","containerName":null,"kind":13,"line":462},{"name":"$y","containerName":null,"kind":13,"line":462},{"containerName":null,"name":"@clusters","line":462,"kind":13},{"name":"$K","containerName":null,"kind":13,"line":462},{"name":"@dmat","containerName":null,"line":463,"kind":13},{"containerName":null,"name":"$y","kind":13,"line":463},{"line":463,"kind":13,"name":"@dmat","containerName":null},{"kind":13,"line":463,"containerName":null,"name":"$K"},{"containerName":null,"name":"$i","line":464,"kind":13},{"line":464,"kind":13,"containerName":null,"name":"$i"},{"line":464,"kind":13,"name":"$K","containerName":null},{"containerName":null,"name":"%i","kind":13,"line":464},{"line":465,"kind":13,"name":"@dmat","containerName":null},{"kind":13,"line":465,"name":"@i","containerName":null},{"kind":13,"line":465,"containerName":null,"name":"$y"},{"kind":13,"line":465,"name":"@dmat","containerName":null},{"kind":13,"line":465,"containerName":null,"name":"@y"},{"line":465,"kind":13,"containerName":null,"name":"$i"},{"containerName":null,"name":"@clusters","line":468,"kind":13},{"kind":13,"line":468,"name":"$K","containerName":null},{"kind":13,"line":469,"containerName":null,"name":"@clusters"},{"line":469,"kind":13,"containerName":null,"name":"$x"},{"name":"$cluster","containerName":null,"kind":13,"line":469},{"line":471,"kind":13,"containerName":null,"name":"$i"},{"name":"$i","containerName":null,"line":471,"kind":13},{"containerName":null,"name":"$K","kind":13,"line":471},{"containerName":null,"name":"%i","line":471,"kind":13},{"containerName":null,"name":"$i","line":472,"kind":13},{"line":472,"kind":13,"name":"%x","containerName":null},{"line":473,"kind":13,"containerName":null,"name":"@dmat"},{"kind":13,"line":473,"name":"@i","containerName":null},{"name":"$x","containerName":null,"line":473,"kind":13},{"name":"@dmat","containerName":null,"line":473,"kind":13},{"name":"@x","containerName":null,"line":473,"kind":13},{"containerName":null,"name":"$i","line":473,"kind":13},{"name":"_upgma_distance","line":474,"kind":12},{"name":"@clusters","containerName":null,"line":474,"kind":13},{"containerName":null,"name":"$i","kind":13,"line":474},{"line":474,"kind":13,"name":"@clusters","containerName":null},{"name":"$x","containerName":null,"line":474,"kind":13},{"name":"@orig","containerName":null,"line":474,"kind":13},{"containerName":null,"name":"@dmat","line":476,"kind":13},{"name":"@i","containerName":null,"line":476,"kind":13},{"containerName":null,"name":"$i","kind":13,"line":476},{"line":481,"kind":13,"name":"@mins","containerName":null},{"line":482,"kind":13,"containerName":null,"name":"$min"},{"name":"Bio","containerName":"Tree::Tree","line":484,"kind":12},{"line":484,"kind":12,"name":"new","containerName":"main::"},{"name":"@nodes","containerName":null,"kind":13,"line":484},{"children":[{"kind":13,"line":495,"containerName":"_upgma_distance","name":"$cluster_i","definition":"my","localvar":"my"},{"line":495,"kind":13,"containerName":"_upgma_distance","name":"$cluster_j"},{"line":495,"kind":13,"name":"$distances","containerName":"_upgma_distance"},{"line":496,"kind":13,"localvar":"my","name":"$ilen","definition":"my","containerName":"_upgma_distance"},{"kind":13,"line":496,"name":"$cluster_i","containerName":"_upgma_distance"}],"line":494,"kind":12,"signature":{"label":"_upgma_distance($cluster_i,$cluster_j,$distances)","documentation":" calculate avg distance between clusters - be they\n single sequences or the combination of multiple seqences\n $cluster_i and $cluster_j are the clusters to operate on\n and $distances is a matrix (arrayref of arrayrefs) of pairwise\n differences indexed on the sequence ids -\n so $distances->[0][1] is the distance between sequences 0 and 1","parameters":[{"label":"$cluster_i"},{"label":"$cluster_j"},{"label":"$distances"}]},"detail":"($cluster_i,$cluster_j,$distances)","definition":"sub","containerName":"main::","range":{"start":{"character":0,"line":494},"end":{"line":496,"character":9999}},"name":"_upgma_distance"},{"kind":13,"line":497,"definition":"my","name":"$jlen","containerName":null,"localvar":"my"},{"kind":13,"line":497,"name":"%cluster_j","containerName":null},{"localvar":"my","containerName":null,"definition":"my","name":"$d","line":498,"kind":13},{"line":498,"kind":13,"containerName":null,"name":"$count"},{"definition":"my","name":"$i","containerName":null,"localvar":"my","kind":13,"line":499},{"line":499,"kind":13,"name":"$i","containerName":null},{"kind":13,"line":499,"name":"$ilen","containerName":null},{"name":"%i","containerName":null,"line":499,"kind":13},{"localvar":"my","containerName":null,"name":"$i_id","definition":"my","line":500,"kind":13},{"containerName":null,"name":"%cluster_i","line":500,"kind":13},{"line":500,"kind":13,"containerName":null,"name":"$i"},{"kind":13,"line":501,"containerName":null,"name":"$j","definition":"my","localvar":"my"},{"line":501,"kind":13,"containerName":null,"name":"$j"},{"name":"$jlen","containerName":null,"line":501,"kind":13},{"kind":13,"line":501,"containerName":null,"name":"%j"},{"localvar":"my","containerName":null,"name":"$j_id","definition":"my","line":502,"kind":13},{"kind":13,"line":502,"containerName":null,"name":"%cluster_j"},{"line":502,"kind":13,"containerName":null,"name":"$j"},{"kind":13,"line":503,"containerName":null,"name":"@distances"},{"containerName":null,"name":"@i_id","kind":13,"line":503},{"containerName":null,"name":"%j_id","kind":13,"line":503},{"name":"$d","containerName":null,"line":506,"kind":13},{"kind":13,"line":506,"containerName":null,"name":"@distances"},{"line":506,"kind":13,"containerName":null,"name":"@i_id"},{"kind":13,"line":506,"name":"$j_id","containerName":null},{"containerName":null,"name":"$count","line":508,"kind":13},{"line":511,"kind":13,"name":"$d","containerName":null},{"name":"$count","containerName":null,"kind":13,"line":511},{"definition":"sub","name":"method","containerName":"main::","range":{"start":{"character":0,"line":526},"end":{"character":9999,"line":530}},"kind":12,"children":[{"line":527,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"method"},{"line":528,"kind":13,"name":"$self","containerName":"method"},{"containerName":"method","name":"$self","line":529,"kind":13}],"line":526},{"detail":"($self,$matrix)","signature":{"parameters":[{"label":"$self"},{"label":"$matrix"}],"documentation":"1;\n# $Id: DistanceFactory.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tree::DistanceFactory\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::DistanceFactory - Construct a tree using distance based methods\n\n=head1 SYNOPSIS\n\n  use Bio::Tree::DistanceFactory;\n  use Bio::AlignIO;\n  use Bio::Align::DNAStatistics;\n  my $tfactory = Bio::Tree::DistanceFactory->new(-method => \"NJ\");\n  my $stats    = Bio::Align::DNAStatistics->new();\n\n  my $alnin    = Bio::AlignIO->new(-format => 'clustalw',\n                                   -file   => 'file.aln');\n  my $aln = $alnin->next_aln;\n  # Of course matrix can come from a different place\n  # like PHYLIP if you prefer, Bio::Matrix::IO should be able\n  # to parse many things\n  my $jcmatrix = $stats->distance(-align => $aln, \n                                  -method => 'Jukes-Cantor');\n  my $tree = $tfactory->make_tree($jcmatrix);\n\n\n=head1 DESCRIPTION\n\nThis is a factory which will construct a phylogenetic tree based on\nthe pairwise sequence distances for a set of sequences.  Currently\nUPGMA (Sokal and Michener 1958) and NJ (Saitou and Nei 1987) tree\nconstruction methods are implemented.\n\n=head1 REFERENCES\n\nEddy SR, Durbin R, Krogh A, Mitchison G, (1998) \"Biological Sequence Analysis\",\nCambridge Univ Press, Cambridge, UK.\n\nHowe K, Bateman A, Durbin R, (2002) \"QuickTree: building huge\nNeighbour-Joining trees of protein sequences.\" Bioinformatics\n18(11):1546-1547.\n\nSaitou N and Nei M, (1987) \"The neighbor-joining method: a new method\nfor reconstructing phylogenetic trees.\" Mol Biol Evol 4(4):406-25.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::Tree::DistanceFactory;\nuse vars qw($DefaultMethod $Precision);\nuse strict;\n\n# some defaults\n$DefaultMethod = 'UPGMA';\n$Precision = 5;\n\nuse Bio::Tree::Node;\nuse Bio::Tree::Tree;\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tree::DistanceFactory->new();\n Function: Builds a new Bio::Tree::DistanceFactory object \n Returns : an instance of Bio::Tree::DistanceFactory\n Args    : -method => 'NJ' or 'UPGMA'\n\n\n\nsub new {\n  my($class,@args) = @_;  \n  my $self = $class->SUPER::new(@args);\n\n  my ($method) = $self->_rearrange([qw(METHOD)],\n\t\t\t\t   @args);\n  $self->method($method || $DefaultMethod);\n  return $self;\n}\n\n=head2 make_tree\n\n Title   : make_tree\n Usage   : my $tree = $disttreefact->make_tree($matrix);\n Function: Build a Tree based on a distance matrix\n Returns : L<Bio::Tree::TreeI>\n Args    : L<Bio::Matrix::MatrixI> object\n\n\n\nsub make_tree{\n   my ($self,$matrix) = @_;\n   if( ! defined $matrix || !ref($matrix) || \n       ! $matrix->isa('Bio::Matrix::MatrixI') ) {\n       $self->warn(\"Need to provide a valid Bio::Matrix::MatrixI object to make_tree\");\n       return;\n   }\n\n   my $method = uc ($self->method);\n   if( $method =~ /NJ/i ) {\n       return $self->_nj($matrix);\n   } elsif( $method =~ /UPGMA/i ) {\n       return $self->_upgma($matrix);\n   } else { \n       $self->warn(\"Unknown tree construction method '$method'.  Cannot run.\");\n       return;\n   }\n   \n}\n\n\n=head2 _nj\n\n Title   : _nj\n Usage   : my $tree = $disttreefact->_nj($matrix);\n Function: Construct a tree based on distance matrix using the \n           Neighbor Joining algorithm (Saitou and Nei, 1987)\n           Implementation based on Kevin Howe's Quicktree implementation\n           and uses his tricks (some based on Bill Bruno's work) to eliminate\n           negative branch lengths\n Returns : L<Bio::Tree::TreeI>\n Args    : L<Bio::Matrix::MatrixI> object\n\n\nsub _nj {\n   my ($self,$distmat) = @_;\n\n   # we assume type checking of $aln has already been done\n   # client shouldn't be calling this directly anyways, using the\n   # make_tree method is preferred\n   \n   # so that we can trim the number of digits shown as the branch length\n   my $precisionstr = \"%.$Precision\".\"f\";\n\n   my @names =  $distmat->column_names;\n   my $N = scalar @names;\n   my ($i,$j,$m,@nodes,$mat,@r);\n   my $L = $N;\n\n   if( $N < 2 ) {\n       $self->warn(\"Can only perform NJ treebuilding on sets of 2 or more species\\n\");\n       return;\n   } elsif( $N == 2 ) {\n       $i = 0;\n       my $d = sprintf($precisionstr,\n\t\t       $distmat->get_entry($names[0],$names[1]) / 2);\n       my $root = Bio::Tree::Node->new();\n       for my $nm ( @names ) {\n\t   $root->add_Descendents( Bio::Tree::Node->new(-id => $nm,\n\t\t\t\t\t\t\t-branch_length => $d));\n       }\n       return Bio::Tree::Tree(-root => $root);\n   }\n   my $c = 0;\n   \n   for ( $i = 0; $i < $N; $i++ ) {\n       push @nodes, Bio::Tree::Node->new(-id => $names[$i]);\n       my $ri = 0;\n       for( $j = 0; $j < $N; $j++ ) {\n\t   $mat->[$i][$j] = $distmat->get_entry($names[$i],$names[$j]);\n\t   $ri += $mat->[$i][$j];\n       }\n       $r[$i] = $ri / ($L -2);\n   }\n   \n   for( my $nodecount = 0; $nodecount < $N-3; $nodecount++) {\n       my ($mini,$minj,$min);\n       for($i = 0; $i < $N; $i++ ) {\n\t   next unless defined $nodes[$i];\n\t   for( $j = 0; $j < $i; $j++ ) {\n\t       next unless defined $nodes[$j];\n\t       my $dist = $mat->[$i][$j] - ($r[$i] + $r[$j]);\n\t       if( ! defined $min ||\n\t\t   $dist <= $min) {\n\t\t   ($mini,$minj,$min) = ($i,$j,$dist);\n\t       }\n\t   }\n       }\n       my $dij    = $mat->[$mini][$minj];\n       my $dist_i = ($dij + $r[$mini] - $r[$minj]) / 2;\n       my $dist_j = $dij - $dist_i;\n       \n       # deal with negative branch lengths\n       # per code in K.Howe's quicktree\n       if( $dist_i < 0 ) {\n\t   $dist_i = 0;\n\t   $dist_j = $dij;\n\t   $dist_j = 0 if( $dist_j < 0 );\n       } elsif( $dist_j < 0 ) { \n\t   $dist_j = 0;\n\t   $dist_i = $dij;\n\t   $dist_i = 0 if( $dist_i < 0 );\n       }\n       \n       $nodes[$mini]->branch_length(sprintf($precisionstr,$dist_i));\n       $nodes[$minj]->branch_length(sprintf($precisionstr,$dist_j));\n       \n       my $newnode = Bio::Tree::Node->new(-descendents => [ $nodes[$mini],\n\t\t\t\t\t\t\t    $nodes[$minj] ]);\n\n       $nodes[$mini] = $newnode;\n       delete $nodes[$minj];\n       \n       # update the distance matrix\n       $r[$mini] = 0;\n       my ($dmi,$dmj);\n       for( $m = 0; $m < $N; $m++ ) {\t   \n\t   next unless defined $nodes[$m];\n\t   if( $m != $mini ) {\n\t       $dmj = $mat->[$m][$minj];\n\t       \n\t       my ($row,$col);\n\t       ($row,$col) = ($m,$mini);\n\t       $dmi = $mat->[$row][$col];\n\t       \n\t       # from K.Howe's notes in quicktree\n\t       # we can actually adjust r[m] here, by using the form:\n\t       # rm = ((rm * numseqs) - dmi - dmj + dmk) / (numseqs-1)\n\n\t       # Note: in Bill Bruno's method for negative branch\n\t       # elimination, then if either dist_i is positive and\n\t       # dist_j is 0, or dist_i is zero and dist_j is positive\n\t       # (after adjustment) then the matrix entry is formed\n\t       # from the distance to the node in question (m) to the\n\t       # node with the zero branch length (whichever it was).\n\t       # I think my code already has the same effect; this is\n\t       # certainly true if dij is equal to dist_i + dist_j,\n\t       # which it should have been fixed to\n\n\t       my $dmk = $mat->[$row][$col] = $mat->[$col][$row] = \n\t\t   ($dmi + $dmj - $dij) / 2;\n\t       \n\t       # If we don't want to try and correct negative brlens\n\t       # this is essentially what is in Edddy et al, BSA book.\n\t       # $r[$m] = (($r[$m] * $L) - $dmi - $dmj + $dmk) / ($L-1);\n\t       # \n\t       $r[$m] = (($r[$m] * ($L - 2)) - $dmi - $dmj + \n\t\t\t $mat->[$row][$col]) / ( $L - 3);\n\t       $r[$mini] += $dmk;\n\t   }\n       }\n       $L--;\n       $r[$mini] /= $L - 2;\n   }\n   \n   # should be 3 nodes left\n   my (@leftovernodes,@leftovers);\n   for( my $k = 0; $k < $N; $k++ ) {\n       if( defined $nodes[$k] ) {\n\t   push @leftovers, $k;\n\t   push @leftovernodes, $nodes[$k];\n       }\n   }\n   my ($l_0,$l_1,$l_2) = @leftovers;\n   \n   my $dist_i = ( $mat->[$l_1][$l_0] + $mat->[$l_2][$l_0] -\n\t\t  $mat->[$l_2][$l_1] ) / 2;\n   \n   my $dist_j = ( $mat->[$l_1][$l_0] - $dist_i);\n   my $dist_k = ( $mat->[$l_2][$l_0] - $dist_i);\n\n   # This is Kev's code to get rid of negative branch lengths\n   if( $dist_i < 0 ) { \n       $dist_i = 0;\n       $dist_j = $mat->[$l_1][$l_0];\n       $dist_k = $mat->[$l_2][$l_0];\n       if( $dist_j < 0 ) { \n\t   $dist_j = 0;\n\t   $dist_k = ( $mat->[$l_2][$l_0] + $mat->[$l_2][$l_1] ) / 2;\n\t   $dist_k = 0 if( $dist_k < 0 );\n       } elsif( $dist_k < 0 ) {\n\t   $dist_k = 0;\n\t   $dist_j = ($mat->[$l_1][$l_0] + $mat->[$l_2][$l_1]) / 2;\n\t   $dist_j = 0 if( $dist_j < 0 );\n       }\n   } elsif( $dist_j < 0 ) {\n       $dist_j = 0;\n       $dist_i = $mat->[$l_1][$l_0];\n       $dist_k = $mat->[$l_2][$l_1];\n       if( $dist_i < 0 ) { \n\t   $dist_i = 0;\n\t   $dist_k = ( $mat->[$l_2][$l_0] + $mat->[$l_2][$l_1]) / 2;\n\t   $dist_k = 0 if( $dist_k  < 0 );\n       } elsif( $dist_k < 0 ) { \n\t   $dist_k = 0;\n\t   $dist_i = ( $mat->[$l_1][$l_0] + $mat->[$l_2][$l_0]) / 2;\n\t   $dist_i = 0 if( $dist_i < 0 );\n       }\n   } elsif( $dist_k < 0 ) {\n       $dist_k = 0;\n       $dist_i = $mat->[$l_2][$l_0];\n       $dist_j = $mat->[$l_2][$l_1];\n       if( $dist_i < 0 ) { \n\t   $dist_i = 0;\n\t   $dist_j = ( $mat->[$l_1][$l_0] + $mat->[$l_2][$l_1] ) / 2;\n\t   $dist_j = 0 if $dist_j < 0;\n       } elsif( $dist_j < 0  ) {\n\t   $dist_j = 0;\n\t   $dist_i = ($mat->[$l_1][$l_0] + $mat->[$l_2][$l_0]) / 2;\n\t   $dist_i = 0 if $dist_i < 0;\n       }\n   }\n   $leftovernodes[0]->branch_length(sprintf($precisionstr,$dist_i));\n   $leftovernodes[1]->branch_length(sprintf($precisionstr,$dist_j));\n   $leftovernodes[2]->branch_length(sprintf($precisionstr,$dist_k));\n\n   Bio::Tree::Tree->new(-root => Bio::Tree::Node->new\n\t\t\t(-descendents => \\@leftovernodes));\n}\n\n=head2 _upgma\n\n Title   : _upgma\n Usage   : my $tree = $disttreefact->_upgma($matrix);\n Function: Construct a tree based on alignment using UPGMA\n Returns : L<Bio::Tree::TreeI>\n Args    : L<Bio::Matrix::MatrixI> object\n\n\n\nsub _upgma{\n   my ($self,$distmat) = @_;\n   # we assume type checking of $matrix has already been done\n   # client shouldn't be calling this directly anyways, using the\n   # make_tree method is preferred\n   \n   # algorithm, from Eddy, Durbin, Krogh, Mitchison, 1998\n   # originally by Sokal and Michener 1956\n\n   my $precisionstr = \"%.$Precision\".\"f\";\n   \n   my ($i,$j,$x,$y,@dmat,@orig,@nodes);\n\n   my @names = $distmat->column_names;\n   my $c = 0;\n   my @clusters = map { \n       my $r = { 'id'        => $c,\n\t\t 'height'    => 0,\n\t\t 'contains'  => [$c],\n\t     };\n       $c++;\n       $r;\n   } @names;\n\n   my $K = scalar @clusters;\n   my (@mins,$min);\n   for ( $i = 0; $i < $K; $i++ ) {\n       for( $j = $i+1; $j < $K; $j++ ) {\n\t   my $d =  $distmat->get_entry($names[$i],$names[$j]);\n\t   # get Min here on first time around, save 1 cycle\n\t   $dmat[$j][$i] = $dmat[$i][$j] = $d;\n\t   $orig[$i][$j] = $orig[$j][$i] = $d;\n\t   if ( ! defined $min || $d <= $min ) {\n\t       if( defined $min && $min == $d ) { \n\t\t   push @mins, [$i,$j];\n\t       } else { \n\t\t   @mins = [$i,$j];\n\t\t   $min  = $d;\n\t       }\n\t   }\n       }\n   }\n   # distance between each cluster is avg distance\n   # between pairs of sequences from each cluster\n   while( $K > 1 ) {       \n       # fencepost - we already have found the $min\n       # so very first time loop is executed we can skip checking\n       unless( defined $min ) {\n\t   for($i = 0; $i < $K; $i++ ) {\n\t       for( $j = $i+1; $j < $K; $j++ ) {\n\t\t   my $dij = $dmat[$i][$j];\n\t\t   if( ! defined $min ||\n\t\t       $dij <= $min) {\n\t\t       if( defined $min &&\n\t\t\t   $min == $dij ) { \n\t\t\t   push @mins, [$i,$j];\n\t\t       } else { \n\t\t\t   @mins = [ $i,$j ];\n\t\t\t   $min = $dij;\n\t\t       }\n\t\t   }\n\t       }\n\t   }\n       }\n       # randomly break ties\n       ($x,$y) = @{ $mins[int(rand(scalar @mins))] };   \n\n       # now we are going to join clusters x and y, make a new cluster\n\n       my $node = Bio::Tree::Node->new();   \n       my @subids;\n       for my $cid ( $x,$y ) {\n\t   my $nid = $clusters[$cid]->{'id'};\n\t   if( ! defined $nodes[$nid] ) {\n\t       $nodes[$nid] = Bio::Tree::Node->new(-id => $names[$nid]);\n\t   }\n\t   $nodes[$nid]->branch_length\n\t       (sprintf($precisionstr,$min/2 - $clusters[$cid]->{'height'}));\n\t   $node->add_Descendent($nodes[$nid]);\n\t   push @subids, @{ $clusters[$cid]->{'contains'} };\n       }\n       my $cluster = { 'id'       => $c++,\n\t\t       'height'   => $min / 2,\n\t\t       'contains' => [@subids],\n\t\t   };\n\n       $K--; # we are going to drop the last node so go ahead and decrement K\n       $nodes[$cluster->{'id'}] = $node;\n       if ( $y != $K ) {\n\t   $clusters[$y] = $clusters[$K];\n\t   $dmat[$y] = $dmat[$K];\n\t   for ( $i = 0; $i < $K; $i++ ) {\n\t       $dmat[$i][$y] = $dmat[$y][$i];\n\t   }\n       }\n       delete $clusters[$K];\n       $clusters[$x] = $cluster;\n       # now recalculate @dmat\n       for( $i = 0; $i < $K; $i++ ) {\t   \n\t   if( $i != $x) {\n\t       $dmat[$i][$x] = $dmat[$x][$i] = \n\t\t   &_upgma_distance($clusters[$i],$clusters[$x],\\@orig);\n\t   } else { \n\t       $dmat[$i][$i] = 0;\n\t   }\n       }\n       # reset so next loop iteration\n       # we will find minimum distance\n       @mins = ();\n       $min = undef;\n   }\n   Bio::Tree::Tree->new(-root => $nodes[-1]);\n}\n\n# calculate avg distance between clusters - be they\n# single sequences or the combination of multiple seqences\n# $cluster_i and $cluster_j are the clusters to operate on\n# and $distances is a matrix (arrayref of arrayrefs) of pairwise \n# differences indexed on the sequence ids - \n# so $distances->[0][1] is the distance between sequences 0 and 1\n\nsub _upgma_distance { \n    my ($cluster_i, $cluster_j, $distances) = @_;\n    my $ilen = scalar @{ $cluster_i->{'contains'} };\n    my $jlen = scalar @{ $cluster_j->{'contains'} };\n    my ($d,$count);\n    for( my $i = 0; $i < $ilen; $i++ ) {\n\tmy $i_id = $cluster_i->{'contains'}->[$i];\n\tfor( my $j = 0; $j < $jlen; $j++) {\t    \n\t    my $j_id = $cluster_j->{'contains'}->[$j];\n\t    if( ! defined $distances->[$i_id][$j_id] ) {\n\t\twarn(\"no value for $i_id $j_id\\n\");\n\t    } else { \n\t\t$d += $distances->[$i_id][$j_id];\n\t    }\n\t    $count++;\n\t}\n    }\n    return $d / $count;\n}\n\n=head2 method\n\n Title   : method\n Usage   : $obj->method($newval)\n Function: \n Example : \n Returns : value of method (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub method{\n    my $self = shift;\n    return $self->{'_method'} = shift if @_;\n    return $self->{'_method'};\n}\n\n\n=head2 check_additivity\n\n Title     : check_additivity\n Usage     : if( $distance->check_additivity($matrix) ) {\n             }\n Function  : See if matrix obeys additivity principal\n Returns   : boolean\n Args      : Bio::Matrix::MatrixI \n References: Based on a Java implementation by\n             Peter Sestoft, sestoft@dina.kvl.dk 1999-12-07 version 0.3\n             http://www.dina.kvl.dk/~sestoft/bsa.html\n             which in turn is based on algorithms described in \n             R. Durbin, S. Eddy, A. Krogh, G. Mitchison. \n             Biological Sequence Analysis CUP 1998, Chapter 7.","label":"check_additivity($self,$matrix)"},"containerName":"main::","definition":"sub","line":550,"children":[{"kind":13,"line":551,"definition":"my","name":"$self","containerName":"check_additivity","localvar":"my"},{"name":"$matrix","containerName":"check_additivity","kind":13,"line":551},{"containerName":"check_additivity","definition":"my","name":"@names","localvar":"my","kind":13,"line":552},{"containerName":"check_additivity","name":"$matrix","line":552,"kind":13},{"line":552,"kind":12,"containerName":"check_additivity","name":"column_names"},{"name":"$len","definition":"my","containerName":"check_additivity","localvar":"my","kind":13,"line":553},{"kind":13,"line":553,"name":"@names","containerName":"check_additivity"},{"line":554,"kind":13,"name":"$len","containerName":"check_additivity"},{"line":556,"kind":13,"localvar":"my","name":"$i","definition":"my","containerName":"check_additivity"},{"kind":13,"line":556,"name":"$i","containerName":"check_additivity"},{"name":"$len","containerName":"check_additivity","line":556,"kind":13},{"line":556,"kind":13,"containerName":"check_additivity","name":"$i"},{"line":557,"kind":13,"localvar":"my","definition":"my","name":"$j","containerName":"check_additivity"},{"kind":13,"line":557,"name":"$i","containerName":"check_additivity"},{"containerName":"check_additivity","name":"$j","line":557,"kind":13},{"name":"$len","containerName":"check_additivity","kind":13,"line":557},{"line":557,"kind":13,"containerName":"check_additivity","name":"$j"},{"localvar":"my","containerName":"check_additivity","definition":"my","name":"$k","line":558,"kind":13},{"containerName":"check_additivity","name":"$j","line":558,"kind":13},{"name":"$k","containerName":"check_additivity","kind":13,"line":558},{"kind":13,"line":558,"name":"$len","containerName":"check_additivity"},{"kind":13,"line":558,"name":"$k","containerName":"check_additivity"},{"containerName":"check_additivity","name":"$m","definition":"my","localvar":"my","kind":13,"line":559},{"name":"$k","containerName":"check_additivity","kind":13,"line":559},{"line":559,"kind":13,"name":"$m","containerName":"check_additivity"},{"line":559,"kind":13,"containerName":"check_additivity","name":"$len"},{"name":"$m","containerName":"check_additivity","line":559,"kind":13},{"name":"$DijDkm","definition":"my","containerName":"check_additivity","localvar":"my","kind":13,"line":560},{"kind":13,"line":560,"containerName":"check_additivity","name":"$matrix"},{"line":560,"kind":12,"name":"get_entry","containerName":"check_additivity"},{"containerName":"check_additivity","name":"$names","kind":13,"line":560},{"kind":13,"line":560,"name":"$i","containerName":"check_additivity"},{"kind":13,"line":560,"name":"$names","containerName":"check_additivity"},{"name":"$j","containerName":"check_additivity","kind":13,"line":560},{"kind":13,"line":561,"containerName":"check_additivity","name":"$matrix"},{"line":561,"kind":12,"name":"get_entry","containerName":"check_additivity"},{"containerName":"check_additivity","name":"$names","kind":13,"line":561},{"kind":13,"line":561,"name":"$k","containerName":"check_additivity"},{"line":561,"kind":13,"name":"$names","containerName":"check_additivity"},{"kind":13,"line":561,"name":"$m","containerName":"check_additivity"},{"kind":13,"line":562,"definition":"my","name":"$DikDjm","containerName":"check_additivity","localvar":"my"},{"name":"$matrix","containerName":"check_additivity","kind":13,"line":562},{"line":562,"kind":12,"name":"get_entry","containerName":"check_additivity"},{"name":"$names","containerName":"check_additivity","kind":13,"line":562},{"containerName":"check_additivity","name":"$i","kind":13,"line":562},{"name":"$names","containerName":"check_additivity","kind":13,"line":562},{"line":562,"kind":13,"containerName":"check_additivity","name":"$k"},{"name":"$matrix","containerName":"check_additivity","kind":13,"line":563},{"containerName":"check_additivity","name":"get_entry","line":563,"kind":12},{"line":563,"kind":13,"containerName":"check_additivity","name":"$names"},{"name":"$j","containerName":"check_additivity","kind":13,"line":563},{"line":563,"kind":13,"containerName":"check_additivity","name":"$names"},{"name":"$m","containerName":"check_additivity","kind":13,"line":563},{"kind":13,"line":564,"containerName":"check_additivity","definition":"my","name":"$DimDjk","localvar":"my"},{"name":"$matrix","containerName":"check_additivity","kind":13,"line":564},{"kind":12,"line":564,"name":"get_entry","containerName":"check_additivity"},{"name":"$names","containerName":"check_additivity","line":564,"kind":13},{"containerName":"check_additivity","name":"$i","kind":13,"line":564},{"kind":13,"line":564,"containerName":"check_additivity","name":"$names"},{"containerName":"check_additivity","name":"$m","kind":13,"line":564},{"kind":13,"line":565,"name":"$matrix","containerName":"check_additivity"},{"line":565,"kind":12,"name":"get_entry","containerName":"check_additivity"},{"line":565,"kind":13,"containerName":"check_additivity","name":"$names"},{"name":"$j","containerName":"check_additivity","kind":13,"line":565},{"containerName":"check_additivity","name":"$names","kind":13,"line":565},{"kind":13,"line":565,"containerName":"check_additivity","name":"$k"},{"line":566,"kind":13,"name":"$DijDkm","containerName":"check_additivity"},{"containerName":"check_additivity","name":"$DikDjm","kind":13,"line":566},{"name":"$DijDkm","containerName":"check_additivity","kind":13,"line":566},{"name":"$DimDjk","containerName":"check_additivity","line":566,"kind":13},{"line":567,"kind":13,"containerName":"check_additivity","name":"$DijDkm"},{"kind":13,"line":567,"containerName":"check_additivity","name":"$DimDjk"},{"kind":13,"line":567,"name":"$DijDkm","containerName":"check_additivity"},{"line":567,"kind":13,"containerName":"check_additivity","name":"$DikDjm"},{"containerName":"check_additivity","name":"$DikDjm","kind":13,"line":568},{"kind":13,"line":568,"name":"$DimDjk","containerName":"check_additivity"},{"name":"$DikDjm","containerName":"check_additivity","line":568,"kind":13},{"containerName":"check_additivity","name":"$DijDkm","kind":13,"line":568}],"kind":12,"range":{"start":{"line":550,"character":0},"end":{"line":576,"character":9999}},"name":"check_additivity"}]}