{"version":5,"vars":[{"name":"base","containerName":"","kind":2,"line":107},{"kind":13,"line":111,"name":"%DTASelect_pK","definition":"my","containerName":null,"localvar":"my"},{"name":"N_term","kind":12,"line":111},{"name":"C_term","line":119,"kind":12},{"kind":13,"line":124,"name":"%Emboss_pK","definition":"my","containerName":null,"localvar":"my"},{"kind":12,"line":124,"name":"N_term"},{"name":"C_term","line":132,"kind":12},{"range":{"start":{"line":174,"character":0},"end":{"character":9999,"line":183}},"name":"new","children":[{"line":175,"kind":13,"localvar":"my","name":"$class","definition":"my","containerName":"new"},{"name":"%opts","containerName":"new","line":175,"kind":13},{"kind":13,"line":176,"containerName":"new","definition":"my","name":"$self","localvar":"my"},{"kind":13,"line":176,"name":"$class","containerName":"new"},{"kind":13,"line":176,"name":"%opts","containerName":"new"},{"containerName":"new","name":"$self","line":177,"kind":13},{"kind":13,"line":177,"containerName":"new","name":"$self"},{"name":"$self","containerName":"new","line":177,"kind":13},{"containerName":"new","name":"$self","kind":13,"line":178},{"line":178,"kind":12,"name":"seq","containerName":"new"},{"containerName":"new","name":"$opts","kind":13,"line":178},{"line":178,"kind":13,"name":"$opts","containerName":"new"},{"line":179,"kind":13,"name":"$self","containerName":"new"},{"kind":12,"line":179,"containerName":"new","name":"pKset"},{"name":"$opts","containerName":"new","line":179,"kind":13},{"line":180,"kind":13,"containerName":"new","name":"$opts"},{"name":"$self","containerName":"new","line":180,"kind":13},{"containerName":"new","name":"places","line":180,"kind":12},{"kind":13,"line":180,"name":"$opts","containerName":"new"},{"name":"$self","containerName":"new","kind":13,"line":181},{"line":181,"kind":12,"containerName":"new","name":"places"},{"name":"$self","containerName":"new","kind":13,"line":182}],"line":174,"kind":12,"signature":{"parameters":[{"label":"$class"},{"label":"%opts"}],"documentation":"__END__\n# $Id: pICalculator.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::pICalculator\n#\n# Copyright (c) 2002, Merck & Co. Inc. All Rights Reserved.\n#\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::pICalculator - calculate the isoelectric point of a protein\n\n=head1 DESCRIPTION\n\nCalculates the isoelectric point of a protein, the pH at which there\nis no overall charge on the protein. Calculates the charge on a protein\nat a given pH. Can use built-in sets of pK values or custom pK sets.\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::pICalculator;\n  use Bio::SeqIO;\n\n  my $in = Bio::SeqIO->new( -fh => \\*STDIN ,\n                            -format => 'Fasta' );\n\n  my $calc = Bio::Tools::pICalculator->new(-places => 2,\n                                           -pKset => 'EMBOSS');\n\n  while ( my $seq = $in->next_seq ) {\n     $calc->seq($seq);\n     my $iep = $calc->iep;\n     print sprintf( \"%s\\t%s\\t%.2f\\n\",\n                    $seq->id,\n                    $iep,\n                    $calc->charge_at_pH($iep) );\n\n     for( my $i = 0; $i <= 14; $i += 0.5 ){\n        print sprintf( \"pH = %.2f\\tCharge = %.2f\\n\",\n                       $i,\n                       $calc->charge_at_pH($i) );\n     }\n  }\n\n=head1 SEE ALSO\n\nhttp://fields.scripps.edu/DTASelect/20010710-pI-Algorithm.pdf\nhttp://emboss.sourceforge.net/apps/cvs/emboss/apps/iep.html\nhttp://us.expasy.org/tools/pi_tool.html\n\n=head1 LIMITATIONS\n\nThere are various sources for the pK values of the amino acids. \nThe set of pK values chosen will affect the pI reported.\n\nThe charge state of each residue is assumed to be independent of \nthe others. Protein modifications (such as a phosphate group) that \nhave a charge are ignored.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions \npreferably to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the \nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nMark Southern (mark_southern@merck.com). From an algorithm by David \nTabb found at http://fields.scripps.edu/DTASelect/20010710-pI-Algorithm.pdf.\nModification for Bioperl, additional documentation by Brian Osborne.\n\n=head1 COPYRIGHT\n\nCopyright (c) 2002, Merck & Co. Inc. All Rights Reserved. This module is\nfree software. It may be used, redistributed and/or modified under the terms\nof the Perl Artistic License (see http://www.perl.com/perl/misc/Artistic.html)\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nPrivate methods are usually preceded by a _.\n\n\n# Let the code begin...\n\npackage Bio::Tools::pICalculator;\nuse strict;\n\n\nuse base qw(Bio::Root::Root);\n\n# pK values from the DTASelect program from Scripps\n# http://fields.scripps.edu/DTASelect\nmy $DTASelect_pK = {  N_term   =>  8.0,\n                      K        => 10.0, # Lys\n                      R        => 12.0, # Arg\n                      H        =>  6.5, # His\n                      D        =>  4.4, # Asp\n                      E        =>  4.4, # Glu\n                      C        =>  8.5, # Cys\n                      Y        => 10.0, # Tyr\n                      C_term   =>  3.1\n                    };\n\n# pK values from the iep program from EMBOSS\n# http://emboss.sourceforge.net/apps/cvs/emboss/apps/iep.html\nmy $Emboss_pK  = { N_term   =>  8.6,\n                   K        => 10.8, # Lys\n                   R        => 12.5, # Arg\n                   H        =>  6.5, # His\n                   D        =>  3.9, # Asp\n                   E        =>  4.1, # Glu\n                   C        =>  8.5, # Cys\n                   Y        => 10.1, # Tyr\n                   C_term   =>  3.6\n                 };\n\n=head2 desc\n\n Title   : new\n Usage   : Bio::Tools::pICalculator->new\n Function: Instantiates the Bio::Tools::pICalculator object\n Example : $calc = Bio::Tools::pICalculator->new( -pKset => \\%pKvalues,\n                                                  # a Bio::Seq object\n                                                  -seq => $seq,\n                                                  -places => 2 );\n           or:\n\n           $calc = Bio::Tools::pICalculator->new( -pKset => 'string',\n                                                  # a Bio::Seq object\n                                                  -seq => $seq,\n                                                  -places => 1 );\n\n           Constructs a new pICalculator. Arguments are a flattened hash.\n           Valid, optional keys are:\n\n           pKset - A reference to a hash with key value pairs for the \n                   pK values of the charged amino acids. Required keys\n                   are:\n\n                   N_term   C_term   K   R   H   D   E   C   Y\n\n           pKset - A string ( 'DTASelect' or 'EMBOSS' ) that will \n                   specify an internal set of pK values to be used. The \n                   default is 'EMBOSS'\n\n           seq - A Bio::Seq sequence object to analyze\n\n           places - The number of decimal places to use in the\n                    isoelectric point calculation. The default is 2.\n\n Returns : The description\n Args    : The description or none","label":"new($class,%opts)"},"detail":"($class,%opts)","definition":"sub","containerName":"main::"},{"name":"SUPER","containerName":"new","line":176,"kind":12},{"range":{"start":{"line":198,"character":0},"end":{"line":206,"character":9999}},"name":"seq","line":198,"children":[{"line":199,"kind":13,"localvar":"my","containerName":"seq","name":"$this","definition":"my"},{"kind":13,"line":199,"name":"$seq","containerName":"seq"},{"kind":13,"line":200,"containerName":"seq","name":"$seq"},{"kind":13,"line":200,"name":"$seq","containerName":"seq"},{"line":201,"kind":13,"containerName":"seq","name":"$this"},{"line":201,"kind":12,"containerName":"seq","name":"throw"},{"line":203,"kind":13,"containerName":"seq","name":"$this"},{"kind":13,"line":203,"containerName":"seq","name":"$seq"},{"name":"$this","containerName":"seq","kind":13,"line":204},{"name":"$seq","containerName":"seq","line":204,"kind":13},{"name":"$this","containerName":"seq","line":205,"kind":13}],"kind":12,"detail":"($this,$seq)","signature":{"parameters":[{"label":"$this"},{"label":"$seq"}],"documentation":"__END__\n# $Id: pICalculator.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::pICalculator\n#\n# Copyright (c) 2002, Merck & Co. Inc. All Rights Reserved.\n#\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::pICalculator - calculate the isoelectric point of a protein\n\n=head1 DESCRIPTION\n\nCalculates the isoelectric point of a protein, the pH at which there\nis no overall charge on the protein. Calculates the charge on a protein\nat a given pH. Can use built-in sets of pK values or custom pK sets.\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::pICalculator;\n  use Bio::SeqIO;\n\n  my $in = Bio::SeqIO->new( -fh => \\*STDIN ,\n                            -format => 'Fasta' );\n\n  my $calc = Bio::Tools::pICalculator->new(-places => 2,\n                                           -pKset => 'EMBOSS');\n\n  while ( my $seq = $in->next_seq ) {\n     $calc->seq($seq);\n     my $iep = $calc->iep;\n     print sprintf( \"%s\\t%s\\t%.2f\\n\",\n                    $seq->id,\n                    $iep,\n                    $calc->charge_at_pH($iep) );\n\n     for( my $i = 0; $i <= 14; $i += 0.5 ){\n        print sprintf( \"pH = %.2f\\tCharge = %.2f\\n\",\n                       $i,\n                       $calc->charge_at_pH($i) );\n     }\n  }\n\n=head1 SEE ALSO\n\nhttp://fields.scripps.edu/DTASelect/20010710-pI-Algorithm.pdf\nhttp://emboss.sourceforge.net/apps/cvs/emboss/apps/iep.html\nhttp://us.expasy.org/tools/pi_tool.html\n\n=head1 LIMITATIONS\n\nThere are various sources for the pK values of the amino acids. \nThe set of pK values chosen will affect the pI reported.\n\nThe charge state of each residue is assumed to be independent of \nthe others. Protein modifications (such as a phosphate group) that \nhave a charge are ignored.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions \npreferably to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the \nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nMark Southern (mark_southern@merck.com). From an algorithm by David \nTabb found at http://fields.scripps.edu/DTASelect/20010710-pI-Algorithm.pdf.\nModification for Bioperl, additional documentation by Brian Osborne.\n\n=head1 COPYRIGHT\n\nCopyright (c) 2002, Merck & Co. Inc. All Rights Reserved. This module is\nfree software. It may be used, redistributed and/or modified under the terms\nof the Perl Artistic License (see http://www.perl.com/perl/misc/Artistic.html)\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nPrivate methods are usually preceded by a _.\n\n\n# Let the code begin...\n\npackage Bio::Tools::pICalculator;\nuse strict;\n\n\nuse base qw(Bio::Root::Root);\n\n# pK values from the DTASelect program from Scripps\n# http://fields.scripps.edu/DTASelect\nmy $DTASelect_pK = {  N_term   =>  8.0,\n                      K        => 10.0, # Lys\n                      R        => 12.0, # Arg\n                      H        =>  6.5, # His\n                      D        =>  4.4, # Asp\n                      E        =>  4.4, # Glu\n                      C        =>  8.5, # Cys\n                      Y        => 10.0, # Tyr\n                      C_term   =>  3.1\n                    };\n\n# pK values from the iep program from EMBOSS\n# http://emboss.sourceforge.net/apps/cvs/emboss/apps/iep.html\nmy $Emboss_pK  = { N_term   =>  8.6,\n                   K        => 10.8, # Lys\n                   R        => 12.5, # Arg\n                   H        =>  6.5, # His\n                   D        =>  3.9, # Asp\n                   E        =>  4.1, # Glu\n                   C        =>  8.5, # Cys\n                   Y        => 10.1, # Tyr\n                   C_term   =>  3.6\n                 };\n\n=head2 desc\n\n Title   : new\n Usage   : Bio::Tools::pICalculator->new\n Function: Instantiates the Bio::Tools::pICalculator object\n Example : $calc = Bio::Tools::pICalculator->new( -pKset => \\%pKvalues,\n                                                  # a Bio::Seq object\n                                                  -seq => $seq,\n                                                  -places => 2 );\n           or:\n\n           $calc = Bio::Tools::pICalculator->new( -pKset => 'string',\n                                                  # a Bio::Seq object\n                                                  -seq => $seq,\n                                                  -places => 1 );\n\n           Constructs a new pICalculator. Arguments are a flattened hash.\n           Valid, optional keys are:\n\n           pKset - A reference to a hash with key value pairs for the \n                   pK values of the charged amino acids. Required keys\n                   are:\n\n                   N_term   C_term   K   R   H   D   E   C   Y\n\n           pKset - A string ( 'DTASelect' or 'EMBOSS' ) that will \n                   specify an internal set of pK values to be used. The \n                   default is 'EMBOSS'\n\n           seq - A Bio::Seq sequence object to analyze\n\n           places - The number of decimal places to use in the\n                    isoelectric point calculation. The default is 2.\n\n Returns : The description\n Args    : The description or none\n\n\nsub new {\n   my( $class, %opts ) = @_;\n   my $self = $class->SUPER::new(%opts);\n   $self = bless {}, ref $self || $self;\n   $self->seq( $opts{-seq} ) if exists $opts{-seq};\n   $self->pKset( $opts{-pKset} || 'EMBOSS' );\n   exists $opts{-places} ? $self->places( $opts{-places} ) :\n     $self->places(2);\n   return $self;\n}\n\n=head2 seq\n\n Title   : seq\n Usage   : $calc->seq($seqobj)\n Function: Sets or returns the Bio::Seq used in the calculation\n Example : $seqobj = Bio::Seq->new(-seq=>\"gghhhmmm\",-id=>\"GHM\");\n           $calc = Bio::Tools::pICalculator->new;\n           $calc->seq($seqobj);\n Returns : Bio::Seq object\n Args    : Bio::Seq object or none","label":"seq($this,$seq)"},"containerName":"main::","definition":"sub"},{"kind":12,"line":200,"containerName":"isa","name":"UNIVERSAL"},{"line":204,"kind":12,"name":"count_charged_residues"},{"containerName":"main::","definition":"sub","detail":"($this,$pKset)","signature":{"label":"pKset($this,$pKset)","parameters":[{"label":"$this"},{"label":"$pKset"}],"documentation":"__END__\n# $Id: pICalculator.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::pICalculator\n#\n# Copyright (c) 2002, Merck & Co. Inc. All Rights Reserved.\n#\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::pICalculator - calculate the isoelectric point of a protein\n\n=head1 DESCRIPTION\n\nCalculates the isoelectric point of a protein, the pH at which there\nis no overall charge on the protein. Calculates the charge on a protein\nat a given pH. Can use built-in sets of pK values or custom pK sets.\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::pICalculator;\n  use Bio::SeqIO;\n\n  my $in = Bio::SeqIO->new( -fh => \\*STDIN ,\n                            -format => 'Fasta' );\n\n  my $calc = Bio::Tools::pICalculator->new(-places => 2,\n                                           -pKset => 'EMBOSS');\n\n  while ( my $seq = $in->next_seq ) {\n     $calc->seq($seq);\n     my $iep = $calc->iep;\n     print sprintf( \"%s\\t%s\\t%.2f\\n\",\n                    $seq->id,\n                    $iep,\n                    $calc->charge_at_pH($iep) );\n\n     for( my $i = 0; $i <= 14; $i += 0.5 ){\n        print sprintf( \"pH = %.2f\\tCharge = %.2f\\n\",\n                       $i,\n                       $calc->charge_at_pH($i) );\n     }\n  }\n\n=head1 SEE ALSO\n\nhttp://fields.scripps.edu/DTASelect/20010710-pI-Algorithm.pdf\nhttp://emboss.sourceforge.net/apps/cvs/emboss/apps/iep.html\nhttp://us.expasy.org/tools/pi_tool.html\n\n=head1 LIMITATIONS\n\nThere are various sources for the pK values of the amino acids. \nThe set of pK values chosen will affect the pI reported.\n\nThe charge state of each residue is assumed to be independent of \nthe others. Protein modifications (such as a phosphate group) that \nhave a charge are ignored.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions \npreferably to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the \nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nMark Southern (mark_southern@merck.com). From an algorithm by David \nTabb found at http://fields.scripps.edu/DTASelect/20010710-pI-Algorithm.pdf.\nModification for Bioperl, additional documentation by Brian Osborne.\n\n=head1 COPYRIGHT\n\nCopyright (c) 2002, Merck & Co. Inc. All Rights Reserved. This module is\nfree software. It may be used, redistributed and/or modified under the terms\nof the Perl Artistic License (see http://www.perl.com/perl/misc/Artistic.html)\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nPrivate methods are usually preceded by a _.\n\n\n# Let the code begin...\n\npackage Bio::Tools::pICalculator;\nuse strict;\n\n\nuse base qw(Bio::Root::Root);\n\n# pK values from the DTASelect program from Scripps\n# http://fields.scripps.edu/DTASelect\nmy $DTASelect_pK = {  N_term   =>  8.0,\n                      K        => 10.0, # Lys\n                      R        => 12.0, # Arg\n                      H        =>  6.5, # His\n                      D        =>  4.4, # Asp\n                      E        =>  4.4, # Glu\n                      C        =>  8.5, # Cys\n                      Y        => 10.0, # Tyr\n                      C_term   =>  3.1\n                    };\n\n# pK values from the iep program from EMBOSS\n# http://emboss.sourceforge.net/apps/cvs/emboss/apps/iep.html\nmy $Emboss_pK  = { N_term   =>  8.6,\n                   K        => 10.8, # Lys\n                   R        => 12.5, # Arg\n                   H        =>  6.5, # His\n                   D        =>  3.9, # Asp\n                   E        =>  4.1, # Glu\n                   C        =>  8.5, # Cys\n                   Y        => 10.1, # Tyr\n                   C_term   =>  3.6\n                 };\n\n=head2 desc\n\n Title   : new\n Usage   : Bio::Tools::pICalculator->new\n Function: Instantiates the Bio::Tools::pICalculator object\n Example : $calc = Bio::Tools::pICalculator->new( -pKset => \\%pKvalues,\n                                                  # a Bio::Seq object\n                                                  -seq => $seq,\n                                                  -places => 2 );\n           or:\n\n           $calc = Bio::Tools::pICalculator->new( -pKset => 'string',\n                                                  # a Bio::Seq object\n                                                  -seq => $seq,\n                                                  -places => 1 );\n\n           Constructs a new pICalculator. Arguments are a flattened hash.\n           Valid, optional keys are:\n\n           pKset - A reference to a hash with key value pairs for the \n                   pK values of the charged amino acids. Required keys\n                   are:\n\n                   N_term   C_term   K   R   H   D   E   C   Y\n\n           pKset - A string ( 'DTASelect' or 'EMBOSS' ) that will \n                   specify an internal set of pK values to be used. The \n                   default is 'EMBOSS'\n\n           seq - A Bio::Seq sequence object to analyze\n\n           places - The number of decimal places to use in the\n                    isoelectric point calculation. The default is 2.\n\n Returns : The description\n Args    : The description or none\n\n\nsub new {\n   my( $class, %opts ) = @_;\n   my $self = $class->SUPER::new(%opts);\n   $self = bless {}, ref $self || $self;\n   $self->seq( $opts{-seq} ) if exists $opts{-seq};\n   $self->pKset( $opts{-pKset} || 'EMBOSS' );\n   exists $opts{-places} ? $self->places( $opts{-places} ) :\n     $self->places(2);\n   return $self;\n}\n\n=head2 seq\n\n Title   : seq\n Usage   : $calc->seq($seqobj)\n Function: Sets or returns the Bio::Seq used in the calculation\n Example : $seqobj = Bio::Seq->new(-seq=>\"gghhhmmm\",-id=>\"GHM\");\n           $calc = Bio::Tools::pICalculator->new;\n           $calc->seq($seqobj);\n Returns : Bio::Seq object\n Args    : Bio::Seq object or none\n\n\nsub seq {\n   my( $this, $seq ) = @_;\n   unless( defined $seq && UNIVERSAL::isa($seq,'Bio::Seq') ){\n      $this->throw(\"$seq is not a valid Bio::Seq object\");\n   }\n   $this->{-seq} = $seq;\n   $this->{-count} = count_charged_residues( $seq );\n   return $this->{-seq};\n}\n\n=head2 pKset\n\n Title   : pKset\n Usage   : $pkSet = $calc->pKSet(\\%pKSet)\n Function: Sets or returns the hash of pK values used in the calculation\n Example : $calc->pKset('emboss')\n Returns : reference to pKset hash\n Args    : The reference to a pKset hash, a string, or none. Examples:\n\n           pKset - A reference to a hash with key value pairs for the\n                   pK values of the charged amino acids. Required keys\n                   are:\n\n                   N_term   C_term   K   R   H   D   E   C   Y\n\n           pKset - A valid string ( 'DTASelect' or 'EMBOSS' ) that will \n                   specify an internal set of pK values to be used. The \n                   default is 'EMBOSS'"},"kind":12,"line":229,"children":[{"line":230,"kind":13,"localvar":"my","name":"$this","definition":"my","containerName":"pKset"},{"line":230,"kind":13,"name":"$pKset","containerName":"pKset"},{"kind":13,"line":231,"containerName":"pKset","name":"$pKset"},{"kind":13,"line":232,"containerName":"pKset","name":"$this"},{"name":"$pKset","containerName":"pKset","kind":13,"line":232},{"name":"$pKset","containerName":"pKset","line":233,"kind":13},{"kind":13,"line":234,"name":"$this","containerName":"pKset"},{"name":"$Emboss_pK","containerName":"pKset","line":234,"kind":13},{"line":235,"kind":13,"name":"$pKset","containerName":"pKset"},{"line":236,"kind":13,"containerName":"pKset","name":"$this"},{"name":"$DTASelect_pK","containerName":"pKset","kind":13,"line":236},{"kind":13,"line":238,"name":"$this","containerName":"pKset"},{"name":"$Emboss_pK","containerName":"pKset","kind":13,"line":238},{"containerName":"pKset","name":"$this","kind":13,"line":240}],"name":"pKset","range":{"start":{"character":0,"line":229},"end":{"character":9999,"line":241}}},{"children":[{"line":244,"kind":13,"localvar":"my","containerName":"places","definition":"my","name":"$this"},{"name":"$this","containerName":"places","kind":13,"line":245},{"line":246,"kind":13,"containerName":"places","name":"$this"}],"line":243,"kind":12,"range":{"end":{"character":9999,"line":247},"start":{"character":0,"line":243}},"definition":"sub","name":"places","containerName":"main::"},{"kind":12,"children":[{"localvar":"my","containerName":"iep","name":"$this","definition":"my","line":263,"kind":13},{"kind":13,"line":264,"name":"$this","containerName":"iep"},{"containerName":"iep","name":"$this","line":265,"kind":13},{"line":266,"kind":13,"name":"$this","containerName":"iep"},{"containerName":"iep","name":"$this","kind":13,"line":267}],"line":262,"definition":"sub","name":"iep","containerName":"main::","range":{"end":{"line":269,"character":9999},"start":{"character":0,"line":262}}},{"line":264,"kind":12,"name":"_calculate_iep"},{"definition":"sub","name":"charge_at_pH","containerName":"main::","range":{"end":{"character":9999,"line":288},"start":{"character":0,"line":284}},"kind":12,"children":[{"line":285,"kind":13,"localvar":"my","definition":"my","name":"$this","containerName":"charge_at_pH"},{"kind":13,"line":286,"name":"$this","containerName":"charge_at_pH"},{"kind":13,"line":287,"name":"$this","containerName":"charge_at_pH"}],"line":284},{"name":"_calculate_charge_at_pH","line":286,"kind":12},{"range":{"end":{"character":9999,"line":298},"start":{"line":290,"character":0}},"name":"count_charged_residues","definition":"sub","containerName":"main::","children":[{"line":291,"kind":13,"localvar":"my","containerName":"count_charged_residues","definition":"my","name":"$seq"},{"kind":13,"line":292,"containerName":"count_charged_residues","name":"$sequence","definition":"my","localvar":"my"},{"containerName":"count_charged_residues","name":"$seq","line":292,"kind":13},{"name":"seq","containerName":"count_charged_residues","kind":12,"line":292},{"containerName":"count_charged_residues","definition":"my","name":"$count","localvar":"my","kind":13,"line":293},{"line":295,"kind":13,"containerName":"count_charged_residues","name":"$count"},{"line":295,"kind":13,"name":"$sequence","containerName":"count_charged_residues"},{"containerName":"count_charged_residues","name":"$count","line":297,"kind":13}],"line":290,"kind":12},{"name":"_calculate_iep","range":{"end":{"character":9999,"line":319},"start":{"character":0,"line":300}},"kind":12,"line":300,"children":[{"line":301,"kind":13,"localvar":"my","containerName":"_calculate_iep","definition":"my","name":"$pK"},{"line":301,"kind":13,"name":"$places","containerName":"_calculate_iep"},{"kind":13,"line":301,"name":"$seq","containerName":"_calculate_iep"},{"line":301,"kind":13,"containerName":"_calculate_iep","name":"$count"},{"kind":13,"line":302,"name":"$pH","definition":"my","containerName":"_calculate_iep","localvar":"my"},{"localvar":"my","containerName":"_calculate_iep","name":"$step","definition":"my","line":303,"kind":13},{"containerName":"_calculate_iep","name":"$last_charge","definition":"my","localvar":"my","kind":13,"line":304},{"kind":13,"line":305,"name":"$format","definition":"my","containerName":"_calculate_iep","localvar":"my"},{"line":307,"kind":13,"containerName":"_calculate_iep","name":"$count"},{"line":308,"kind":13,"containerName":"_calculate_iep","name":"$count"},{"containerName":"_calculate_iep","name":"$seq","line":308,"kind":13},{"kind":13,"line":311,"name":"$charge","definition":"my","containerName":"_calculate_iep","localvar":"my"},{"kind":13,"line":311,"containerName":"_calculate_iep","name":"$pH"},{"line":311,"kind":13,"containerName":"_calculate_iep","name":"$pK"},{"line":311,"kind":13,"name":"$count","containerName":"_calculate_iep"},{"containerName":"_calculate_iep","name":"$format","kind":13,"line":312},{"line":312,"kind":13,"containerName":"_calculate_iep","name":"$charge"},{"kind":13,"line":313,"containerName":"_calculate_iep","name":"$format"},{"line":313,"kind":13,"containerName":"_calculate_iep","name":"$last_charge"},{"kind":13,"line":314,"name":"$charge","containerName":"_calculate_iep"},{"kind":13,"line":314,"containerName":"_calculate_iep","name":"$pH"},{"line":314,"kind":13,"containerName":"_calculate_iep","name":"$step"},{"containerName":"_calculate_iep","name":"$pH","kind":13,"line":314},{"kind":13,"line":314,"containerName":"_calculate_iep","name":"$step"},{"kind":13,"line":315,"name":"$step","containerName":"_calculate_iep"},{"kind":13,"line":316,"name":"$last_charge","containerName":"_calculate_iep"},{"name":"$charge","containerName":"_calculate_iep","kind":13,"line":316},{"kind":13,"line":318,"containerName":"_calculate_iep","name":"$format"},{"line":318,"kind":13,"name":"$pH","containerName":"_calculate_iep"}],"containerName":"main::","definition":"sub","detail":"($pK,$places,$seq,$count)","signature":{"label":"_calculate_iep($pK,$places,$seq,$count)","parameters":[{"label":"$pK"},{"label":"$places"},{"label":"$seq"},{"label":"$count"}],"documentation":""}},{"line":311,"kind":12,"name":"_calculate_charge_at_pH"},{"children":[{"localvar":"my","name":"$pH","definition":"my","containerName":"_calculate_charge_at_pH","line":325,"kind":13},{"kind":13,"line":325,"containerName":"_calculate_charge_at_pH","name":"$pK"},{"name":"$count","containerName":"_calculate_charge_at_pH","kind":13,"line":325},{"kind":13,"line":326,"definition":"my","name":"$charge","containerName":"_calculate_charge_at_pH","localvar":"my"},{"kind":13,"line":326,"name":"$pK","containerName":"_calculate_charge_at_pH"},{"kind":13,"line":326,"name":"$pH","containerName":"_calculate_charge_at_pH"},{"containerName":"_calculate_charge_at_pH","name":"$count","line":327,"kind":13},{"name":"$pK","containerName":"_calculate_charge_at_pH","line":327,"kind":13},{"kind":13,"line":327,"containerName":"_calculate_charge_at_pH","name":"$pH"},{"kind":13,"line":328,"containerName":"_calculate_charge_at_pH","name":"$count"},{"containerName":"_calculate_charge_at_pH","name":"$pK","line":328,"kind":13},{"kind":13,"line":328,"containerName":"_calculate_charge_at_pH","name":"$pH"},{"kind":13,"line":329,"containerName":"_calculate_charge_at_pH","name":"$count"},{"line":329,"kind":13,"name":"$pK","containerName":"_calculate_charge_at_pH"},{"kind":13,"line":329,"containerName":"_calculate_charge_at_pH","name":"$pH"},{"line":330,"kind":13,"name":"$count","containerName":"_calculate_charge_at_pH"},{"containerName":"_calculate_charge_at_pH","name":"$pH","kind":13,"line":330},{"kind":13,"line":330,"containerName":"_calculate_charge_at_pH","name":"$pK"},{"line":331,"kind":13,"containerName":"_calculate_charge_at_pH","name":"$count"},{"line":331,"kind":13,"name":"$pH","containerName":"_calculate_charge_at_pH"},{"line":331,"kind":13,"containerName":"_calculate_charge_at_pH","name":"$pK"},{"name":"$count","containerName":"_calculate_charge_at_pH","kind":13,"line":332},{"line":332,"kind":13,"containerName":"_calculate_charge_at_pH","name":"$pH"},{"kind":13,"line":332,"containerName":"_calculate_charge_at_pH","name":"$pK"},{"kind":13,"line":333,"name":"$count","containerName":"_calculate_charge_at_pH"},{"kind":13,"line":333,"containerName":"_calculate_charge_at_pH","name":"$pH"},{"kind":13,"line":333,"containerName":"_calculate_charge_at_pH","name":"$pK"},{"line":334,"kind":13,"name":"$pH","containerName":"_calculate_charge_at_pH"},{"containerName":"_calculate_charge_at_pH","name":"$pK","kind":13,"line":334},{"containerName":"_calculate_charge_at_pH","name":"$charge","line":335,"kind":13}],"line":323,"kind":12,"signature":{"label":"_calculate_charge_at_pH($pH,$pK,$count)","parameters":[{"label":"$pH"},{"label":"$pK"},{"label":"$count"}],"documentation":" it's the sum of all the partial charges for the\n termini and all of the charged aa's!"},"detail":"($pH,$pK,$count)","definition":"sub","containerName":"main::","range":{"end":{"line":336,"character":9999},"start":{"line":323,"character":0}},"name":"_calculate_charge_at_pH"},{"kind":12,"line":324,"name":"warnings"},{"line":326,"kind":12,"name":"_partial_charge"},{"name":"N_term","kind":12,"line":326},{"name":"_partial_charge","line":327,"kind":12},{"line":328,"kind":12,"name":"_partial_charge"},{"name":"_partial_charge","line":329,"kind":12},{"name":"_partial_charge","kind":12,"line":330},{"line":331,"kind":12,"name":"_partial_charge"},{"line":332,"kind":12,"name":"_partial_charge"},{"kind":12,"line":333,"name":"_partial_charge"},{"line":334,"kind":12,"name":"_partial_charge"},{"name":"C_term","kind":12,"line":334},{"line":340,"children":[{"kind":13,"line":341,"containerName":"_partial_charge","definition":"my","name":"$cr","localvar":"my"},{"containerName":"_partial_charge","name":"$cr","kind":13,"line":342},{"containerName":"_partial_charge","name":"$cr","line":342,"kind":13}],"kind":12,"range":{"end":{"line":343,"character":9999},"start":{"character":0,"line":340}},"containerName":"main::","name":"_partial_charge","definition":"sub"}]}