{"vars":[{"kind":2,"line":103,"containerName":"","name":"base"},{"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: isPcr.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::isPcr\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sheldon McKay <mckays@cshl.edu>\n#\n# Copyright Sheldon McKay\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::isPcr - Parse isPcr output and make features\n\n=head1 SYNOPSIS\n\n    # A simple annotation pipeline wrapper for isPcr data\n    # assuming isPcr data is already generated in file seq1.isPcr\n    # and sequence data is in fasta format in file called seq1.fa\n\n    # Note: this parser is meant for the default fasta output from\n    # isPcr.  bed and psl output formats are not supported.\n\n    use Bio::Tools::IsPcr;\n    use Bio::SeqIO;\n    my $parser = Bio::Tools::isPcr->new(-file => 'seq1.isPcr');\n    my $seqio = Bio::SeqIO->new(-format => 'fasta', -file => 'seq1.fa');\n    my $seq = $seqio->next_seq || die(\"cannot get a seq object from SeqIO\");\n\n    while( my $feat = $parser->next_feature ) {\n\t# add isPcr annotation to a sequence\n\t$seq->add_SeqFeature($feat);\n    }\n    my $seqout = Bio::SeqIO->new(-format => 'embl');\n    $seqout->write_seq($seq);\n\n\n=head1 DESCRIPTION\n\nThis object serves as a parser for isPcr data (in the default fasta\nformat), creating a Bio::SeqFeatureI for each isPcr hit.  \nThese can be processed or added as annotation to an existing\nBio::SeqI object for the purposes of automated annotation.\n\nThis module is adapted from the Bio::Tools::EPCR module\nwritten by Jason Stajich (jason-at-bioperl.org).\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sheldon McKay\n\nEmail mckays@cshl.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::isPcr;\nuse strict;\n\nuse Bio::SeqIO;\nuse Bio::SeqFeature::Generic;\n\n\nuse base qw(Bio::Root::Root);\n\n\n=head2 new\n\n Title   : new\n Usage   : my $ispcr = Bio::Tools::isPcr->new( -file => $file,\n\t\t\t\t\t      -primary => $fprimary, \n\t\t\t\t\t      -source => $fsource,\n\t\t\t\t\t      -groupclass => $fgroupclass);\n\n Function: Initializes a new isPcr parser\n Returns : Bio::Tools::isPcr\n Args    : -fh   => filehandle\n           OR\n           -file => filename\n\n           -primary => a string to be used as the common value for\n                       each features '-primary' tag.  Defaults to\n                       the sequence ontology term 'PCR_product'.  \n                       (This in turn maps to the GFF 'type'\n                       tag (aka 'method')).\n\n            -source => a string to be used as the common value for\n                       each features '-source' tag.  Defaults to\n                       'isPcr'. (This in turn maps to the GFF 'source'\n                       tag)\n\n            -groupclass => a string to be used as the name of the tag\n                           which will hold the sts marker namefirst\n                           attribute.  Defaults to 'name'.","label":"new($class,@args)"},"detail":"($class,@args)","kind":12,"children":[{"kind":13,"line":139,"name":"$class","definition":"my","containerName":"new","localvar":"my"},{"containerName":"new","name":"@args","kind":13,"line":139},{"kind":13,"line":141,"name":"$self","definition":"my","containerName":"new","localvar":"my"},{"containerName":"new","name":"$class","kind":13,"line":141},{"kind":13,"line":141,"name":"@args","containerName":"new"},{"localvar":"my","containerName":"new","name":"$primary","definition":"my","line":142,"kind":13},{"name":"$source","containerName":"new","kind":13,"line":142},{"kind":13,"line":142,"containerName":"new","name":"$groupclass"},{"name":"$self","containerName":"new","kind":13,"line":143},{"name":"_rearrange","containerName":"new","line":143,"kind":12},{"containerName":"new","name":"@args","line":143,"kind":13},{"name":"$self","containerName":"new","line":144,"kind":13},{"line":144,"kind":12,"name":"primary","containerName":"new"},{"kind":13,"line":144,"name":"$primary","containerName":"new"},{"containerName":"new","name":"$primary","line":144,"kind":13},{"containerName":"new","name":"$self","kind":13,"line":145},{"containerName":"new","name":"source","line":145,"kind":12},{"kind":13,"line":145,"containerName":"new","name":"$source"},{"name":"$source","containerName":"new","line":145,"kind":13},{"containerName":"new","name":"$self","line":146,"kind":13},{"name":"groupclass","containerName":"new","line":146,"kind":12},{"name":"$groupclass","containerName":"new","kind":13,"line":146},{"name":"$groupclass","containerName":"new","line":146,"kind":13},{"containerName":"new","name":"$self","kind":13,"line":149},{"name":"new","containerName":"new","line":149,"kind":12},{"containerName":"new","name":"@args","kind":13,"line":149},{"containerName":"new","name":"$self","kind":13,"line":151}],"line":138,"name":"new","range":{"end":{"character":9999,"line":152},"start":{"line":138,"character":0}}},{"name":"SUPER","containerName":"new","kind":12,"line":141},{"name":"io","line":149,"kind":12},{"name":"Bio","containerName":"SeqIO","kind":12,"line":149},{"name":"next_feature","range":{"end":{"line":201,"character":9999},"start":{"character":0,"line":167}},"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: isPcr.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::isPcr\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sheldon McKay <mckays@cshl.edu>\n#\n# Copyright Sheldon McKay\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::isPcr - Parse isPcr output and make features\n\n=head1 SYNOPSIS\n\n    # A simple annotation pipeline wrapper for isPcr data\n    # assuming isPcr data is already generated in file seq1.isPcr\n    # and sequence data is in fasta format in file called seq1.fa\n\n    # Note: this parser is meant for the default fasta output from\n    # isPcr.  bed and psl output formats are not supported.\n\n    use Bio::Tools::IsPcr;\n    use Bio::SeqIO;\n    my $parser = Bio::Tools::isPcr->new(-file => 'seq1.isPcr');\n    my $seqio = Bio::SeqIO->new(-format => 'fasta', -file => 'seq1.fa');\n    my $seq = $seqio->next_seq || die(\"cannot get a seq object from SeqIO\");\n\n    while( my $feat = $parser->next_feature ) {\n\t# add isPcr annotation to a sequence\n\t$seq->add_SeqFeature($feat);\n    }\n    my $seqout = Bio::SeqIO->new(-format => 'embl');\n    $seqout->write_seq($seq);\n\n\n=head1 DESCRIPTION\n\nThis object serves as a parser for isPcr data (in the default fasta\nformat), creating a Bio::SeqFeatureI for each isPcr hit.  \nThese can be processed or added as annotation to an existing\nBio::SeqI object for the purposes of automated annotation.\n\nThis module is adapted from the Bio::Tools::EPCR module\nwritten by Jason Stajich (jason-at-bioperl.org).\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sheldon McKay\n\nEmail mckays@cshl.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::isPcr;\nuse strict;\n\nuse Bio::SeqIO;\nuse Bio::SeqFeature::Generic;\n\n\nuse base qw(Bio::Root::Root);\n\n\n=head2 new\n\n Title   : new\n Usage   : my $ispcr = Bio::Tools::isPcr->new( -file => $file,\n\t\t\t\t\t      -primary => $fprimary, \n\t\t\t\t\t      -source => $fsource,\n\t\t\t\t\t      -groupclass => $fgroupclass);\n\n Function: Initializes a new isPcr parser\n Returns : Bio::Tools::isPcr\n Args    : -fh   => filehandle\n           OR\n           -file => filename\n\n           -primary => a string to be used as the common value for\n                       each features '-primary' tag.  Defaults to\n                       the sequence ontology term 'PCR_product'.  \n                       (This in turn maps to the GFF 'type'\n                       tag (aka 'method')).\n\n            -source => a string to be used as the common value for\n                       each features '-source' tag.  Defaults to\n                       'isPcr'. (This in turn maps to the GFF 'source'\n                       tag)\n\n            -groupclass => a string to be used as the name of the tag\n                           which will hold the sts marker namefirst\n                           attribute.  Defaults to 'name'.\n\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($primary,$source,$groupclass) = \n      $self->_rearrange([qw/PRIMARY SOURCE GROUPCLASS/],@args);\n  $self->primary(defined $primary ? $primary : 'PCR_product');\n  $self->source(defined $source ? $source : 'isPcr');\n  $self->groupclass(defined $groupclass ? $groupclass : 'name');\n\n  # default output for isPcr is fasta format\n  $self->{io} = Bio::SeqIO->new(-format => 'fasta', @args);\n\n  return $self;\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : $seqfeature = $obj->next_feature();\n Function: Returns the next feature available in the analysis result, or\n           undef if there are no more features.\n Example :\n Returns : A Bio::SeqFeatureI implementing object, or undef if there are no\n           more features.\n Args    : none    ","label":"next_feature($self)"},"detail":"($self)","kind":12,"children":[{"containerName":"next_feature","name":"$self","definition":"my","localvar":"my","kind":13,"line":168},{"containerName":"next_feature","definition":"my","name":"$result","localvar":"my","kind":13,"line":169},{"line":169,"kind":13,"name":"$self","containerName":"next_feature"},{"kind":12,"line":169,"name":"next_seq","containerName":"next_feature"},{"line":170,"kind":13,"name":"$result","containerName":"next_feature"},{"kind":13,"line":172,"containerName":"next_feature","definition":"my","name":"$seqname","localvar":"my"},{"kind":13,"line":172,"containerName":"next_feature","name":"$location"},{"kind":13,"line":172,"name":"$result","containerName":"next_feature"},{"kind":12,"line":172,"containerName":"next_feature","name":"primary_id"},{"localvar":"my","name":"$pcrname","definition":"my","containerName":"next_feature","line":173,"kind":13},{"line":173,"kind":13,"name":"$left","containerName":"next_feature"},{"containerName":"next_feature","name":"$right","line":173,"kind":13},{"containerName":"next_feature","name":"$result","kind":13,"line":173},{"kind":12,"line":173,"containerName":"next_feature","name":"desc"},{"containerName":"next_feature","name":"$start","definition":"my","localvar":"my","kind":13,"line":174},{"containerName":"next_feature","name":"$strand","kind":13,"line":174},{"containerName":"next_feature","name":"$end","kind":13,"line":174},{"line":174,"kind":13,"containerName":"next_feature","name":"$location"},{"localvar":"my","name":"$amplicon","definition":"my","containerName":"next_feature","line":175,"kind":13},{"line":175,"kind":13,"name":"$result","containerName":"next_feature"},{"name":"seq","containerName":"next_feature","kind":12,"line":175},{"name":"$self","containerName":"next_feature","kind":13,"line":179},{"line":179,"kind":13,"containerName":"next_feature","name":"$pcrname"},{"containerName":"next_feature","name":"$pcrname","line":180,"kind":13},{"kind":13,"line":183,"definition":"my","name":"$tags","containerName":"next_feature","localvar":"my"},{"name":"$self","containerName":"next_feature","line":184,"kind":13},{"name":"groupclass","containerName":"next_feature","kind":12,"line":184},{"containerName":"next_feature","name":"$pcrname","line":184,"kind":13},{"containerName":"next_feature","name":"$amplicon","line":185,"kind":13},{"line":186,"kind":13,"containerName":"next_feature","name":"$left"},{"line":188,"kind":13,"containerName":"next_feature","name":"$right"},{"kind":13,"line":190,"definition":"my","name":"$markerfeature","containerName":"next_feature","localvar":"my"},{"line":190,"kind":12,"name":"new","containerName":"next_feature"},{"kind":13,"line":191,"name":"$start","containerName":"next_feature"},{"line":192,"kind":13,"name":"$end","containerName":"next_feature"},{"line":193,"kind":13,"containerName":"next_feature","name":"$strand"},{"name":"$self","containerName":"next_feature","line":194,"kind":13},{"line":194,"kind":12,"name":"source","containerName":"next_feature"},{"name":"$self","containerName":"next_feature","line":195,"kind":13},{"line":195,"kind":12,"name":"primary","containerName":"next_feature"},{"containerName":"next_feature","name":"$seqname","kind":13,"line":196},{"line":198,"kind":13,"containerName":"next_feature","name":"$tags"},{"kind":13,"line":200,"containerName":"next_feature","name":"$markerfeature"}],"line":167},{"line":169,"kind":12,"name":"io"},{"name":"seen","kind":12,"line":179},{"line":185,"kind":12,"name":"amplicon"},{"name":"left_primer","line":186,"kind":12},{"kind":12,"line":187,"name":"right_primer"},{"name":"Bio","containerName":"SeqFeature::Generic","line":190,"kind":12},{"range":{"end":{"line":219,"character":9999},"start":{"character":0,"line":215}},"name":"source","definition":"sub","containerName":"main::","children":[{"localvar":"my","definition":"my","name":"$self","containerName":"source","line":216,"kind":13},{"kind":13,"line":217,"name":"$self","containerName":"source"},{"line":218,"kind":13,"containerName":"source","name":"$self"}],"line":215,"kind":12},{"line":233,"children":[{"definition":"my","name":"$self","containerName":"primary","localvar":"my","kind":13,"line":234},{"name":"$self","containerName":"primary","line":235,"kind":13},{"containerName":"primary","name":"$self","line":236,"kind":13}],"kind":12,"range":{"end":{"character":9999,"line":237},"start":{"character":0,"line":233}},"containerName":"main::","name":"primary","definition":"sub"},{"range":{"start":{"line":251,"character":0},"end":{"character":9999,"line":256}},"name":"groupclass","definition":"sub","containerName":"main::","children":[{"kind":13,"line":252,"containerName":"groupclass","name":"$self","definition":"my","localvar":"my"},{"containerName":"groupclass","name":"$self","kind":13,"line":254},{"containerName":"groupclass","name":"$self","kind":13,"line":255}],"line":251,"kind":12}],"version":5}