{"version":5,"vars":[{"containerName":"","name":"base","kind":2,"line":101},{"range":{"start":{"line":133,"character":0},"end":{"character":9999,"line":167}},"name":"new","line":133,"children":[{"line":134,"kind":13,"localvar":"my","containerName":"new","name":"$class","definition":"my"},{"kind":13,"line":134,"containerName":"new","name":"@args"},{"kind":13,"line":136,"containerName":"new","name":"$self","definition":"my","localvar":"my"},{"name":"$class","containerName":"new","line":136,"kind":13},{"name":"@args","containerName":"new","kind":13,"line":136},{"line":137,"kind":13,"localvar":"my","containerName":"new","definition":"my","name":"$primary"},{"name":"$source","containerName":"new","kind":13,"line":137},{"kind":13,"line":138,"containerName":"new","name":"$groupclass"},{"line":138,"kind":13,"containerName":"new","name":"$file"},{"line":138,"kind":13,"name":"$fh","containerName":"new"},{"containerName":"new","name":"$self","line":138,"kind":13},{"kind":12,"line":138,"containerName":"new","name":"_rearrange"},{"name":"@args","containerName":"new","kind":13,"line":141},{"containerName":"new","name":"$self","line":142,"kind":13},{"name":"primary","containerName":"new","line":142,"kind":12},{"line":142,"kind":13,"name":"$primary","containerName":"new"},{"containerName":"new","name":"$primary","line":142,"kind":13},{"line":143,"kind":13,"name":"$self","containerName":"new"},{"containerName":"new","name":"source","kind":12,"line":143},{"name":"$source","containerName":"new","line":143,"kind":13},{"kind":13,"line":143,"containerName":"new","name":"$source"},{"name":"$self","containerName":"new","kind":13,"line":144},{"containerName":"new","name":"groupclass","kind":12,"line":144},{"name":"$groupclass","containerName":"new","line":144,"kind":13},{"line":144,"kind":13,"name":"$groupclass","containerName":"new"},{"localvar":"my","name":"@result","definition":"my","containerName":"new","line":147,"kind":13},{"name":"$file","containerName":"new","line":149,"kind":13},{"line":150,"kind":13,"containerName":"new","name":"$file"},{"kind":13,"line":151,"name":"@result","containerName":"new"},{"name":"$fh","containerName":"new","line":154,"kind":13},{"name":"@result","containerName":"new","kind":13,"line":155},{"containerName":"new","name":"$fh","kind":13,"line":155},{"line":158,"kind":13,"containerName":"new","name":"$self"},{"containerName":"new","name":"throw","line":158,"kind":12},{"containerName":"new","name":"@result","line":162,"kind":13},{"name":"$self","containerName":"new","kind":13,"line":164},{"name":"@result","containerName":"new","line":164,"kind":13},{"containerName":"new","name":"$self","line":166,"kind":13}],"kind":12,"detail":"($class,@args)","signature":{"label":"new($class,@args)","documentation":"1;\n# $Id: ipcress.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::ipcress\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sheldon McKay <mckays@cshl.edu>\n#\n# Copyright Sheldon McKay\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::ipcress - Parse ipcress output and make features\n\n=head1 SYNOPSIS\n\n    # A simple annotation pipeline wrapper for ipcress data\n    # assuming ipcress data is already generated in file seq1.ipcress\n    # and sequence data is in fasta format in file called seq1.fa\n\n    use Bio::Tools::ipcress;\n    use Bio::SeqIO;\n    my $parser = Bio::Tools::ipcress->new(-file => 'seq1.ipcress');\n    my $seqio = Bio::SeqIO->new(-format => 'fasta', -file => 'seq1.fa');\n    my $seq = $seqio->next_seq || die(\"cannot get a seq object from SeqIO\");\n\n    while( my $feat = $parser->next_feature ) {\n\t# add ipcress annotation to a sequence\n\t$seq->add_SeqFeature($feat);\n    }\n    my $seqout = Bio::SeqIO->new(-format => 'embl');\n    $seqout->write_seq($seq);\n\n\n=head1 DESCRIPTION\n\nThis object serves as a parser for ipcress data, creating a\nBio::SeqFeatureI for each ipcress hit.  These can be processed or added\nas annotation to an existing Bio::SeqI object for the purposes of\nautomated annotation.\n\nThis module is adapted from the Bio::Tools::EPCR module\nwritten by Jason Stajich (jason-at-bioperl.org).\n\nIpcress is available through Guy Slater's Exonerate package \nhttp://www.ebi.ac.uk/~guy/exonerate/\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sheldon McKay\n\nEmail mckays@cshl.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::ipcress;\nuse strict;\n\nuse Bio::SeqFeature::Generic;\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : my $ipcress = Bio::Tools::ipcress->new(-file => $file,\n\t\t\t\t\t   -primary => $fprimary, \n\t\t\t\t\t   -source => $fsource, \n\t\t\t\t\t   -groupclass => $fgroupclass);\n Function: Initializes a new ipcress parser\n Returns : Bio::Tools::ipcress\n Args    : -fh   => filehandle\n           OR\n           -file => filename\n\n           -primary => a string to be used as the common value for\n                       each features '-primary' tag.  Defaults to\n                       the sequence ontology term 'PCR_product'.\n                       (This in turn maps to the GFF 'type'\n                       tag (aka 'method')).\n\n            -source => a string to be used as the common value for\n                       each features '-source' tag.  Defaults to\n                       'ipcress'. (This in turn maps to the GFF 'source'\n                       tag)\n\n             -groupclass => a string to be used as the name of the tag\n                           which will hold the sts marker namefirst\n                           attribute.  Defaults to 'name'.","parameters":[{"label":"$class"},{"label":"@args"}]},"containerName":"main::","definition":"sub"},{"name":"SUPER","containerName":"new","line":136,"kind":12},{"line":150,"kind":12,"name":"FH"},{"name":"FH","kind":12,"line":151},{"name":"FH","line":152,"kind":12},{"name":"result","kind":12,"line":164},{"name":"next_feature","range":{"start":{"line":182,"character":0},"end":{"character":9999,"line":184}},"kind":12,"line":182,"children":[{"line":183,"kind":13,"localvar":"my","containerName":"next_feature","definition":"my","name":"$self"},{"localvar":"my","containerName":"next_feature","name":"$result","definition":"my","line":184,"kind":13},{"name":"$self","containerName":"next_feature","line":184,"kind":13}],"containerName":"main::","definition":"sub","detail":"($self)","signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: ipcress.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::ipcress\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sheldon McKay <mckays@cshl.edu>\n#\n# Copyright Sheldon McKay\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::ipcress - Parse ipcress output and make features\n\n=head1 SYNOPSIS\n\n    # A simple annotation pipeline wrapper for ipcress data\n    # assuming ipcress data is already generated in file seq1.ipcress\n    # and sequence data is in fasta format in file called seq1.fa\n\n    use Bio::Tools::ipcress;\n    use Bio::SeqIO;\n    my $parser = Bio::Tools::ipcress->new(-file => 'seq1.ipcress');\n    my $seqio = Bio::SeqIO->new(-format => 'fasta', -file => 'seq1.fa');\n    my $seq = $seqio->next_seq || die(\"cannot get a seq object from SeqIO\");\n\n    while( my $feat = $parser->next_feature ) {\n\t# add ipcress annotation to a sequence\n\t$seq->add_SeqFeature($feat);\n    }\n    my $seqout = Bio::SeqIO->new(-format => 'embl');\n    $seqout->write_seq($seq);\n\n\n=head1 DESCRIPTION\n\nThis object serves as a parser for ipcress data, creating a\nBio::SeqFeatureI for each ipcress hit.  These can be processed or added\nas annotation to an existing Bio::SeqI object for the purposes of\nautomated annotation.\n\nThis module is adapted from the Bio::Tools::EPCR module\nwritten by Jason Stajich (jason-at-bioperl.org).\n\nIpcress is available through Guy Slater's Exonerate package \nhttp://www.ebi.ac.uk/~guy/exonerate/\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sheldon McKay\n\nEmail mckays@cshl.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::ipcress;\nuse strict;\n\nuse Bio::SeqFeature::Generic;\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : my $ipcress = Bio::Tools::ipcress->new(-file => $file,\n\t\t\t\t\t   -primary => $fprimary, \n\t\t\t\t\t   -source => $fsource, \n\t\t\t\t\t   -groupclass => $fgroupclass);\n Function: Initializes a new ipcress parser\n Returns : Bio::Tools::ipcress\n Args    : -fh   => filehandle\n           OR\n           -file => filename\n\n           -primary => a string to be used as the common value for\n                       each features '-primary' tag.  Defaults to\n                       the sequence ontology term 'PCR_product'.\n                       (This in turn maps to the GFF 'type'\n                       tag (aka 'method')).\n\n            -source => a string to be used as the common value for\n                       each features '-source' tag.  Defaults to\n                       'ipcress'. (This in turn maps to the GFF 'source'\n                       tag)\n\n             -groupclass => a string to be used as the name of the tag\n                           which will hold the sts marker namefirst\n                           attribute.  Defaults to 'name'.\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($primary, $source, \n      $groupclass, $file, $fh) = $self->_rearrange([qw(PRIMARY\n\t\t\t\t\t\t       SOURCE \n\t\t\t\t\t\t       GROUPCLASS\n\t\t\t\t\t\t       FILE FH)],@args);\n  $self->primary(defined $primary ? $primary : 'PCR_product');\n  $self->source(defined $source ? $source : 'ipcress');\n  $self->groupclass(defined $groupclass ? $groupclass : 'name');\n\n  local $/ = 'Ipcress result';\n  my @result;\n\n  if ($file) {\n      open FH, $file;\n      @result = (<FH>);\n      close FH;\n  }\n  elsif ($fh) {\n      @result = (<$fh>);\n  }\n  else {\n      $self->throw(\"Bio::Tools::ipcress: no input file\");\n  }\n\n\n  shift @result;\n\n  $self->{result} = \\@result;\n\n  return $self;\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : $seqfeature = $obj->next_feature();\n Function: Returns the next feature available in the analysis result, or\n           undef if there are no more features.\n Example :\n Returns : A Bio::SeqFeatureI implementing object, or undef if there are no\n           more features.\n Args    : none    ","label":"next_feature($self)"}},{"line":184,"kind":12,"name":"result"},{"kind":13,"line":185,"containerName":null,"name":"$result"},{"containerName":null,"name":"$result","line":187,"kind":13},{"localvar":"my","definition":"my","name":"@lines","containerName":null,"line":188,"kind":13},{"containerName":null,"name":"$result","kind":13,"line":188},{"kind":13,"line":189,"name":"$ipcress","definition":"my","containerName":null,"localvar":"my"},{"kind":13,"line":189,"name":"@lines","containerName":null},{"line":191,"kind":13,"localvar":"my","containerName":null,"definition":"my","name":"$seqname"},{"line":191,"kind":13,"name":"$mkrname","containerName":null},{"line":191,"kind":13,"containerName":null,"name":"$length"},{"line":191,"kind":13,"name":"$start","containerName":null},{"containerName":null,"name":"$mismatchL","kind":13,"line":191},{"containerName":null,"name":"$mismatchR","kind":13,"line":192},{"kind":13,"line":192,"name":"$desc","containerName":null},{"name":"$ipcress","containerName":null,"kind":13,"line":192},{"kind":13,"line":194,"definition":"my","name":"$end","containerName":null,"localvar":"my"},{"kind":13,"line":194,"name":"$start","containerName":null},{"kind":13,"line":194,"containerName":null,"name":"$length"},{"line":195,"kind":13,"name":"$start","containerName":null},{"line":197,"kind":13,"localvar":"my","definition":"my","name":"$strand","containerName":null},{"kind":13,"line":197,"name":"$desc","containerName":null},{"kind":13,"line":197,"containerName":null,"name":"$desc"},{"kind":13,"line":199,"containerName":null,"definition":"my","name":"$left","localvar":"my"},{"kind":13,"line":199,"containerName":null,"name":"@lines"},{"line":200,"kind":13,"containerName":null,"name":"$left"},{"line":201,"kind":13,"localvar":"my","containerName":null,"name":"$right","definition":"my"},{"kind":13,"line":201,"name":"@lines","containerName":null},{"name":"$right","containerName":null,"line":202,"kind":13},{"containerName":null,"name":"$right","line":203,"kind":13},{"line":203,"kind":13,"containerName":null,"name":"$right"},{"containerName":null,"name":"%self","kind":13,"line":207},{"line":207,"kind":12,"name":"seen"},{"containerName":null,"name":"%mkrname","line":207,"kind":13},{"name":"$mkrname","containerName":null,"line":208,"kind":13},{"localvar":"my","containerName":null,"definition":"my","name":"$markerfeature","line":212,"kind":13},{"line":212,"kind":12,"name":"Bio","containerName":"SeqFeature::Generic"},{"line":212,"kind":12,"name":"new","containerName":"main::"},{"kind":13,"line":213,"name":"$start","containerName":null},{"line":214,"kind":13,"containerName":null,"name":"$end"},{"containerName":null,"name":"$strand","line":215,"kind":13},{"name":"$self","containerName":null,"kind":13,"line":216},{"containerName":"main::","name":"source","kind":12,"line":216},{"name":"$self","containerName":null,"kind":13,"line":217},{"containerName":"main::","name":"primary","line":217,"kind":12},{"line":218,"kind":13,"containerName":null,"name":"%seqname"},{"name":"$self","containerName":null,"line":220,"kind":13},{"line":220,"kind":12,"name":"groupclass","containerName":"main::"},{"kind":13,"line":220,"containerName":null,"name":"$mkrname"},{"line":223,"kind":13,"name":"%strand","containerName":null},{"kind":13,"line":224,"name":"$markerfeature","containerName":null},{"kind":12,"line":224,"containerName":"main::","name":"add_tag_value"},{"kind":13,"line":227,"containerName":null,"name":"$markerfeature"},{"line":227,"kind":12,"name":"add_tag_value","containerName":"main::"},{"containerName":null,"name":"$left","line":227,"kind":13},{"kind":13,"line":228,"containerName":null,"name":"$markerfeature"},{"kind":12,"line":228,"containerName":"main::","name":"add_tag_value"},{"containerName":null,"name":"$right","kind":13,"line":228},{"kind":13,"line":229,"name":"$markerfeature","containerName":null},{"containerName":"main::","name":"add_tag_value","kind":12,"line":229},{"kind":13,"line":229,"containerName":null,"name":"$mismatchL"},{"name":"$mismatchL","containerName":null,"kind":13,"line":229},{"name":"$markerfeature","containerName":null,"line":230,"kind":13},{"name":"add_tag_value","containerName":"main::","kind":12,"line":230},{"kind":13,"line":230,"containerName":null,"name":"$mismatchR"},{"name":"$mismatchR","containerName":null,"line":230,"kind":13},{"line":232,"kind":13,"containerName":null,"name":"$markerfeature"},{"name":"source","definition":"sub","containerName":"main::","range":{"end":{"character":9999,"line":251},"start":{"line":247,"character":0}},"kind":12,"children":[{"localvar":"my","containerName":"source","definition":"my","name":"$self","line":248,"kind":13},{"line":249,"kind":13,"name":"$self","containerName":"source"},{"line":250,"kind":13,"containerName":"source","name":"$self"}],"line":247},{"kind":12,"children":[{"kind":13,"line":266,"name":"$self","definition":"my","containerName":"primary","localvar":"my"},{"name":"$self","containerName":"primary","kind":13,"line":267},{"kind":13,"line":268,"name":"$self","containerName":"primary"}],"line":265,"name":"primary","definition":"sub","containerName":"main::","range":{"end":{"character":9999,"line":269},"start":{"line":265,"character":0}}},{"range":{"start":{"character":0,"line":283},"end":{"character":9999,"line":288}},"containerName":"main::","definition":"sub","name":"groupclass","line":283,"children":[{"line":284,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"groupclass"},{"containerName":"groupclass","name":"$self","kind":13,"line":286},{"containerName":"groupclass","name":"$self","kind":13,"line":287}],"kind":12}]}