{"vars":[{"line":206,"kind":2,"name":"base","containerName":""},{"name":"vars","containerName":"","kind":2,"line":208},{"kind":13,"line":209,"name":"$ID","containerName":null},{"line":213,"kind":13,"localvar":"my","containerName":null,"definition":"my","name":"$PURINES"},{"localvar":"my","containerName":null,"name":"$PYRIMIDINES","definition":"my","line":214,"kind":13},{"containerName":null,"definition":"my","name":"$BEE","localvar":"my","kind":13,"line":215},{"kind":13,"line":216,"containerName":null,"name":"$ZED","definition":"my","localvar":"my"},{"kind":13,"line":217,"definition":"my","name":"$Regexp_chars","containerName":null,"localvar":"my"},{"kind":13,"line":220,"containerName":null,"definition":"my","name":"%Processed_braces","localvar":"my"},{"containerName":null,"name":"%Processed_asterics","line":220,"kind":13},{"range":{"end":{"line":264,"character":9999},"start":{"line":244,"character":0}},"name":"new","detail":"($class,%param)","signature":{"label":"new($class,%param)","documentation":"# $Id: SeqPattern.pm 16139 2009-09-18 21:11:23Z cjfields $\n#\n# bioperl module for Bio::Tools::SeqPattern\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by  Steve Chervitz  (sac-at-bioperl.org)\n#\n# Copyright  Steve Chervitz\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::SeqPattern - represent a sequence pattern or motif\n\n=head1 SYNOPSIS\n\n use Bio::Tools::SeqPattern;\n\n my $pat1     = 'T[GA]AA...TAAT';\n my $pattern1 = Bio::Tools::SeqPattern->new(-SEQ =>$pat1, -TYPE =>'Dna');\n\n my $pat2     = '[VILM]R(GXX){3,2}...[^PG]';\n my $pattern2 = Bio::Tools::SeqPattern->new(-SEQ =>$pat2, -TYPE =>'Amino');\n\n=head1 DESCRIPTION\n\nL<Bio::Tools::SeqPattern> module encapsulates generic data and\nmethods for manipulating regular expressions describing nucleic or\namino acid sequence patterns (a.k.a, \"motifs\").\n\nL<Bio::Tools::SeqPattern> is a concrete class that inherits from L<Bio::Seq>.\n\nThis class grew out of a need to have a standard module for doing routine\ntasks with sequence patterns such as:\n\n  -- Forming a reverse-complement version of a nucleotide sequence pattern\n  -- Expanding patterns containing ambiguity codes\n  -- Checking for invalid regexp characters\n  -- Untainting yet preserving special characters in the pattern\n\nOther features to look for in the future:\n\n  -- Full pattern syntax checking\n  -- Conversion between expanded and condensed forms of the pattern\n\n=head1 MOTIVATIONS\n\nA key motivation for L<Bio::Tools::SeqPattern> is to have a way to\ngenerate a reverse complement of a nucleotide sequence pattern.\nThis makes possible simultaneous pattern matching on both sense and\nanti-sense strands of a query sequence.\n\nIn principle, one could do such a search more inefficiently by testing\nagainst both sense and anti-sense versions of a sequence.\nIt is entirely equivalent to test a regexp containing both sense and\nanti-sense versions of the *pattern* against one copy of the sequence.\nThe latter approach is much more efficient since:\n\n   1) You need only one copy of the sequence.\n   2) Only one regexp is executed.\n   3) Regexp patterns are typically much smaller than sequences.\n\nPatterns can be quite complex and it is often difficult to\ngenerate the reverse complement pattern. The Bioperl SeqPattern.pm\naddresses this problem, providing a convenient set of tools\nfor working with biological sequence regular expressions.\n\nNot all patterns have been tested. If you discover a pattern that\nis not handled properly by Bio::Tools::SeqPattern.pm, please\nsend me some email (sac@bioperl.org). Thanks.\n\n=head1 OTHER FEATURES\n\n=head2 Extended Alphabet Support\n\nThis module supports the same set of ambiguity codes for nucleotide\nsequences as supported by L<Bio::Seq>. These ambiguity codes\ndefine the behavior or the L<expand> method.\n\n ------------------------------------------\n Symbol       Meaning      Nucleic Acid\n ------------------------------------------\n  A            A           (A)denine\n  C            C           (C)ytosine\n  G            G           (G)uanine\n  T            T           (T)hymine\n  U            U           (U)racil\n  M          A or C        a(M)ino group\n  R          A or G        pu(R)ine\n  W          A or T        (W)eak bond\n  S          C or G        (S)trong bond\n  Y          C or T        p(Y)rimidine\n  K          G or T        (K)eto group\n  V        A or C or G\n  H        A or C or T\n  D        A or G or T\n  B        C or G or T\n  X      G or A or T or C\n  N      G or A or T or C\n  .      G or A or T or C\n\n\n\n ------------------------------------------\n Symbol           Meaning\n ------------------------------------------\n A        Alanine\n C        Cysteine\n D        Aspartic Acid\n E        Glutamic Acid\n F        Phenylalanine\n G        Glycine\n H        Histidine\n I        Isoleucine\n K        Lysine\n L        Leucine\n M        Methionine\n N        Asparagine\n P        Proline\n Q        Glutamine\n R        Arginine\n S        Serine\n T        Threonine\n V        Valine\n W        Tryptophan\n Y        Tyrosine\n\n B        Aspartic Acid, Asparagine\n Z        Glutamic Acid, Glutamine\n X        Any amino acid\n .        Any amino acid\n\n\n=head2 Multiple Format Support\n\nUltimately, this module should be able to build SeqPattern.pm objects\nusing a variety of pattern formats such as ProSite, Blocks, Prints, GCG, etc.\nCurrently, this module only supports patterns using a grep-like syntax.\n\n=head1 USAGE\n\nA simple demo script called seq_pattern.pl is included in the examples/\ndirectory of the central Bioperl distribution.\n\n=head1 SEE ALSO\n\nL<Bio::Seq> - Lightweight sequence object.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules.  Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nSteve Chervitz, sac-at-bioperl.org\n\n=head1 COPYRIGHT\n\nCopyright (c) 1997-8 Steve Chervitz. All Rights Reserved.\nThis module is free software; you can redistribute it and/or\nmodify it under the same terms as Perl itself.\n\n\n#\n##\n###\n#### END of main POD documentation.\n###\n##\n#'\n# CREATED : 28 Aug 1997\n\n\npackage Bio::Tools::SeqPattern;\n\nuse base qw(Bio::Root::Root);\nuse strict;\nuse vars qw ($ID);\n$ID  = 'Bio::Tools::SeqPattern';\n\n## These constants may be more appropriate in a Bio::Dictionary.pm\n## type of class.\nmy $PURINES      = 'AG';\nmy $PYRIMIDINES  = 'CT';\nmy $BEE      = 'DN';\nmy $ZED      = 'EQ';\nmy $Regexp_chars = '\\w,.\\*()\\[\\]<>\\{\\}^\\$';  # quoted for use in regexps\n\n## Package variables used in reverse complementing.\nmy (%Processed_braces, %Processed_asterics);\n\n#####################################################################################\n##                                 CONSTRUCTOR                                     ##\n#####################################################################################\n\n=head1 new\n\n Title     : new\n Usage     : my $seqpat = Bio::Tools::SeqPattern->new();\n Purpose   : Verifies that the type is correct for superclass (Bio::Seq.pm)\n           : and calls superclass constructor last.\n Returns   : n/a\n Argument  : Parameters passed to new()\n Throws    : Exception if the pattern string (seq) is empty.\n Comments  : The process of creating a new SeqPattern.pm object\n           : ensures that the pattern string is untained.\n\nSee Also   : L<Bio::Root::Root::new>,\n             L<Bio::Seq::_initialize>","parameters":[{"label":"$class"},{"label":"%param"}]},"containerName":"main::","definition":"sub","line":244,"children":[{"localvar":"my","name":"$class","definition":"my","containerName":"new","line":246,"kind":13},{"line":246,"kind":13,"containerName":"new","name":"%param"},{"line":248,"kind":13,"localvar":"my","containerName":"new","name":"$self","definition":"my"},{"kind":13,"line":248,"name":"$class","containerName":"new"},{"name":"%param","containerName":"new","line":248,"kind":13},{"line":249,"kind":13,"localvar":"my","containerName":"new","definition":"my","name":"$seq"},{"kind":13,"line":249,"containerName":"new","name":"$type"},{"kind":13,"line":249,"containerName":"new","name":"$self"},{"containerName":"new","name":"_rearrange","kind":12,"line":249},{"name":"%param","containerName":"new","line":249,"kind":13},{"name":"$seq","containerName":"new","kind":13,"line":251},{"kind":13,"line":251,"containerName":"new","name":"$self"},{"containerName":"new","name":"throw","kind":12,"line":251},{"containerName":"new","definition":"my","name":"$t","localvar":"my","kind":13,"line":252},{"containerName":"new","name":"$type","kind":13,"line":254},{"containerName":"new","name":"$t","kind":13,"line":255},{"containerName":"new","name":"$type","line":256,"kind":13},{"name":"$t","containerName":"new","kind":13,"line":257},{"line":259,"kind":13,"containerName":"new","name":"$seq"},{"containerName":"new","name":"$self","line":260,"kind":13},{"line":260,"kind":12,"name":"str","containerName":"new"},{"kind":13,"line":260,"name":"$seq","containerName":"new"},{"containerName":"new","name":"$self","kind":13,"line":261},{"line":261,"kind":12,"name":"type","containerName":"new"},{"containerName":"new","name":"$t","kind":13,"line":261},{"containerName":"new","name":"$self","kind":13,"line":263}],"kind":12},{"line":248,"kind":12,"containerName":"new","name":"SUPER"},{"name":"alphabet_ok","range":{"start":{"character":0,"line":287},"end":{"character":9999,"line":307}},"containerName":"main::","definition":"sub","detail":"($self)","signature":{"parameters":[{"label":"$self"}],"documentation":"# $Id: SeqPattern.pm 16139 2009-09-18 21:11:23Z cjfields $\n#\n# bioperl module for Bio::Tools::SeqPattern\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by  Steve Chervitz  (sac-at-bioperl.org)\n#\n# Copyright  Steve Chervitz\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::SeqPattern - represent a sequence pattern or motif\n\n=head1 SYNOPSIS\n\n use Bio::Tools::SeqPattern;\n\n my $pat1     = 'T[GA]AA...TAAT';\n my $pattern1 = Bio::Tools::SeqPattern->new(-SEQ =>$pat1, -TYPE =>'Dna');\n\n my $pat2     = '[VILM]R(GXX){3,2}...[^PG]';\n my $pattern2 = Bio::Tools::SeqPattern->new(-SEQ =>$pat2, -TYPE =>'Amino');\n\n=head1 DESCRIPTION\n\nL<Bio::Tools::SeqPattern> module encapsulates generic data and\nmethods for manipulating regular expressions describing nucleic or\namino acid sequence patterns (a.k.a, \"motifs\").\n\nL<Bio::Tools::SeqPattern> is a concrete class that inherits from L<Bio::Seq>.\n\nThis class grew out of a need to have a standard module for doing routine\ntasks with sequence patterns such as:\n\n  -- Forming a reverse-complement version of a nucleotide sequence pattern\n  -- Expanding patterns containing ambiguity codes\n  -- Checking for invalid regexp characters\n  -- Untainting yet preserving special characters in the pattern\n\nOther features to look for in the future:\n\n  -- Full pattern syntax checking\n  -- Conversion between expanded and condensed forms of the pattern\n\n=head1 MOTIVATIONS\n\nA key motivation for L<Bio::Tools::SeqPattern> is to have a way to\ngenerate a reverse complement of a nucleotide sequence pattern.\nThis makes possible simultaneous pattern matching on both sense and\nanti-sense strands of a query sequence.\n\nIn principle, one could do such a search more inefficiently by testing\nagainst both sense and anti-sense versions of a sequence.\nIt is entirely equivalent to test a regexp containing both sense and\nanti-sense versions of the *pattern* against one copy of the sequence.\nThe latter approach is much more efficient since:\n\n   1) You need only one copy of the sequence.\n   2) Only one regexp is executed.\n   3) Regexp patterns are typically much smaller than sequences.\n\nPatterns can be quite complex and it is often difficult to\ngenerate the reverse complement pattern. The Bioperl SeqPattern.pm\naddresses this problem, providing a convenient set of tools\nfor working with biological sequence regular expressions.\n\nNot all patterns have been tested. If you discover a pattern that\nis not handled properly by Bio::Tools::SeqPattern.pm, please\nsend me some email (sac@bioperl.org). Thanks.\n\n=head1 OTHER FEATURES\n\n=head2 Extended Alphabet Support\n\nThis module supports the same set of ambiguity codes for nucleotide\nsequences as supported by L<Bio::Seq>. These ambiguity codes\ndefine the behavior or the L<expand> method.\n\n ------------------------------------------\n Symbol       Meaning      Nucleic Acid\n ------------------------------------------\n  A            A           (A)denine\n  C            C           (C)ytosine\n  G            G           (G)uanine\n  T            T           (T)hymine\n  U            U           (U)racil\n  M          A or C        a(M)ino group\n  R          A or G        pu(R)ine\n  W          A or T        (W)eak bond\n  S          C or G        (S)trong bond\n  Y          C or T        p(Y)rimidine\n  K          G or T        (K)eto group\n  V        A or C or G\n  H        A or C or T\n  D        A or G or T\n  B        C or G or T\n  X      G or A or T or C\n  N      G or A or T or C\n  .      G or A or T or C\n\n\n\n ------------------------------------------\n Symbol           Meaning\n ------------------------------------------\n A        Alanine\n C        Cysteine\n D        Aspartic Acid\n E        Glutamic Acid\n F        Phenylalanine\n G        Glycine\n H        Histidine\n I        Isoleucine\n K        Lysine\n L        Leucine\n M        Methionine\n N        Asparagine\n P        Proline\n Q        Glutamine\n R        Arginine\n S        Serine\n T        Threonine\n V        Valine\n W        Tryptophan\n Y        Tyrosine\n\n B        Aspartic Acid, Asparagine\n Z        Glutamic Acid, Glutamine\n X        Any amino acid\n .        Any amino acid\n\n\n=head2 Multiple Format Support\n\nUltimately, this module should be able to build SeqPattern.pm objects\nusing a variety of pattern formats such as ProSite, Blocks, Prints, GCG, etc.\nCurrently, this module only supports patterns using a grep-like syntax.\n\n=head1 USAGE\n\nA simple demo script called seq_pattern.pl is included in the examples/\ndirectory of the central Bioperl distribution.\n\n=head1 SEE ALSO\n\nL<Bio::Seq> - Lightweight sequence object.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules.  Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nSteve Chervitz, sac-at-bioperl.org\n\n=head1 COPYRIGHT\n\nCopyright (c) 1997-8 Steve Chervitz. All Rights Reserved.\nThis module is free software; you can redistribute it and/or\nmodify it under the same terms as Perl itself.\n\n\n#\n##\n###\n#### END of main POD documentation.\n###\n##\n#'\n# CREATED : 28 Aug 1997\n\n\npackage Bio::Tools::SeqPattern;\n\nuse base qw(Bio::Root::Root);\nuse strict;\nuse vars qw ($ID);\n$ID  = 'Bio::Tools::SeqPattern';\n\n## These constants may be more appropriate in a Bio::Dictionary.pm\n## type of class.\nmy $PURINES      = 'AG';\nmy $PYRIMIDINES  = 'CT';\nmy $BEE      = 'DN';\nmy $ZED      = 'EQ';\nmy $Regexp_chars = '\\w,.\\*()\\[\\]<>\\{\\}^\\$';  # quoted for use in regexps\n\n## Package variables used in reverse complementing.\nmy (%Processed_braces, %Processed_asterics);\n\n#####################################################################################\n##                                 CONSTRUCTOR                                     ##\n#####################################################################################\n\n=head1 new\n\n Title     : new\n Usage     : my $seqpat = Bio::Tools::SeqPattern->new();\n Purpose   : Verifies that the type is correct for superclass (Bio::Seq.pm)\n           : and calls superclass constructor last.\n Returns   : n/a\n Argument  : Parameters passed to new()\n Throws    : Exception if the pattern string (seq) is empty.\n Comments  : The process of creating a new SeqPattern.pm object\n           : ensures that the pattern string is untained.\n\nSee Also   : L<Bio::Root::Root::new>,\n             L<Bio::Seq::_initialize>\n\n\n#----------------\nsub new {\n#----------------\n    my($class, %param) = @_;\n\n    my $self = $class->SUPER::new(%param);\n    my ($seq,$type) = $self->_rearrange([qw(SEQ TYPE)], %param);\n\n    $seq || $self->throw(\"Empty pattern.\");\n    my $t;\n    # Get the type ready for Bio::Seq.pm\n    if ($type =~ /nuc|[dr]na/i) {\n\t$t = 'Dna';\n    } elsif ($type =~ /amino|pep|prot/i) {\n\t$t = 'Amino';\n    }\n    $seq =~ tr/a-z/A-Z/;  #ps 8/8/00 Canonicalize to upper case\n    $self->str($seq);\n    $self->type($t);\n\n    return $self;\n}\n\n\n=head1 alphabet_ok\n\n Title     : alphabet_ok\n Usage     : $mypat->alphabet_ok;\n Purpose   : Checks for invalid regexp characters.\n           : Overrides Bio::Seq::alphabet_ok() to allow\n           : additional regexp characters ,.*()[]<>{}^$\n           : in addition to the standard genetic alphabet.\n           : Also untaints the pattern and sets the sequence\n           : object's sequence to the untained string.\n Returns   : Boolean (1 | 0)\n Argument  : n/a\n Throws    : Exception if the pattern contains invalid characters.\n Comments  : Does not call the superclass method.\n           : Actually permits any alphanumeric, not just the\n           : standard genetic alphabet.\n\n----------------'","label":"alphabet_ok($self)"},"kind":12,"line":287,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"alphabet_ok","line":289,"kind":13},{"kind":13,"line":291,"name":"$self","containerName":"alphabet_ok"},{"line":293,"kind":13,"containerName":"alphabet_ok","name":"$self"},{"localvar":"my","containerName":"alphabet_ok","name":"$pat","definition":"my","line":295,"kind":13},{"line":295,"kind":13,"containerName":"alphabet_ok","name":"$self"},{"line":295,"kind":12,"containerName":"alphabet_ok","name":"seq"},{"kind":13,"line":297,"name":"$pat","containerName":"alphabet_ok"},{"kind":13,"line":298,"name":"$self","containerName":"alphabet_ok"},{"kind":12,"line":298,"containerName":"alphabet_ok","name":"throw"},{"kind":13,"line":303,"containerName":"alphabet_ok","name":"$pat"},{"name":"$self","containerName":"alphabet_ok","line":304,"kind":13},{"containerName":"alphabet_ok","name":"setseq","line":304,"kind":12}]},{"kind":12,"children":[{"kind":13,"line":327,"definition":"my","name":"$self","containerName":"expand","localvar":"my"},{"name":"$self","containerName":"expand","line":329,"kind":13},{"kind":12,"line":329,"containerName":"expand","name":"type"},{"line":329,"kind":13,"name":"$self","containerName":"expand"},{"name":"_expand_nuc","containerName":"expand","line":329,"kind":12},{"name":"$self","containerName":"expand","kind":13,"line":330},{"line":330,"kind":12,"containerName":"expand","name":"type"},{"kind":13,"line":330,"name":"$self","containerName":"expand"},{"name":"_expand_pep","containerName":"expand","kind":12,"line":330},{"kind":13,"line":332,"name":"$self","containerName":"expand"},{"line":332,"kind":12,"name":"throw","containerName":"expand"}],"line":325,"definition":"sub","name":"expand","containerName":"main::","range":{"end":{"character":9999,"line":334},"start":{"character":0,"line":325}}},{"range":{"start":{"line":351,"character":0},"end":{"character":9999,"line":374}},"name":"_expand_pep","signature":{"parameters":[{"label":"$self"},{"label":"$pat"}],"documentation":"# $Id: SeqPattern.pm 16139 2009-09-18 21:11:23Z cjfields $\n#\n# bioperl module for Bio::Tools::SeqPattern\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by  Steve Chervitz  (sac-at-bioperl.org)\n#\n# Copyright  Steve Chervitz\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::SeqPattern - represent a sequence pattern or motif\n\n=head1 SYNOPSIS\n\n use Bio::Tools::SeqPattern;\n\n my $pat1     = 'T[GA]AA...TAAT';\n my $pattern1 = Bio::Tools::SeqPattern->new(-SEQ =>$pat1, -TYPE =>'Dna');\n\n my $pat2     = '[VILM]R(GXX){3,2}...[^PG]';\n my $pattern2 = Bio::Tools::SeqPattern->new(-SEQ =>$pat2, -TYPE =>'Amino');\n\n=head1 DESCRIPTION\n\nL<Bio::Tools::SeqPattern> module encapsulates generic data and\nmethods for manipulating regular expressions describing nucleic or\namino acid sequence patterns (a.k.a, \"motifs\").\n\nL<Bio::Tools::SeqPattern> is a concrete class that inherits from L<Bio::Seq>.\n\nThis class grew out of a need to have a standard module for doing routine\ntasks with sequence patterns such as:\n\n  -- Forming a reverse-complement version of a nucleotide sequence pattern\n  -- Expanding patterns containing ambiguity codes\n  -- Checking for invalid regexp characters\n  -- Untainting yet preserving special characters in the pattern\n\nOther features to look for in the future:\n\n  -- Full pattern syntax checking\n  -- Conversion between expanded and condensed forms of the pattern\n\n=head1 MOTIVATIONS\n\nA key motivation for L<Bio::Tools::SeqPattern> is to have a way to\ngenerate a reverse complement of a nucleotide sequence pattern.\nThis makes possible simultaneous pattern matching on both sense and\nanti-sense strands of a query sequence.\n\nIn principle, one could do such a search more inefficiently by testing\nagainst both sense and anti-sense versions of a sequence.\nIt is entirely equivalent to test a regexp containing both sense and\nanti-sense versions of the *pattern* against one copy of the sequence.\nThe latter approach is much more efficient since:\n\n   1) You need only one copy of the sequence.\n   2) Only one regexp is executed.\n   3) Regexp patterns are typically much smaller than sequences.\n\nPatterns can be quite complex and it is often difficult to\ngenerate the reverse complement pattern. The Bioperl SeqPattern.pm\naddresses this problem, providing a convenient set of tools\nfor working with biological sequence regular expressions.\n\nNot all patterns have been tested. If you discover a pattern that\nis not handled properly by Bio::Tools::SeqPattern.pm, please\nsend me some email (sac@bioperl.org). Thanks.\n\n=head1 OTHER FEATURES\n\n=head2 Extended Alphabet Support\n\nThis module supports the same set of ambiguity codes for nucleotide\nsequences as supported by L<Bio::Seq>. These ambiguity codes\ndefine the behavior or the L<expand> method.\n\n ------------------------------------------\n Symbol       Meaning      Nucleic Acid\n ------------------------------------------\n  A            A           (A)denine\n  C            C           (C)ytosine\n  G            G           (G)uanine\n  T            T           (T)hymine\n  U            U           (U)racil\n  M          A or C        a(M)ino group\n  R          A or G        pu(R)ine\n  W          A or T        (W)eak bond\n  S          C or G        (S)trong bond\n  Y          C or T        p(Y)rimidine\n  K          G or T        (K)eto group\n  V        A or C or G\n  H        A or C or T\n  D        A or G or T\n  B        C or G or T\n  X      G or A or T or C\n  N      G or A or T or C\n  .      G or A or T or C\n\n\n\n ------------------------------------------\n Symbol           Meaning\n ------------------------------------------\n A        Alanine\n C        Cysteine\n D        Aspartic Acid\n E        Glutamic Acid\n F        Phenylalanine\n G        Glycine\n H        Histidine\n I        Isoleucine\n K        Lysine\n L        Leucine\n M        Methionine\n N        Asparagine\n P        Proline\n Q        Glutamine\n R        Arginine\n S        Serine\n T        Threonine\n V        Valine\n W        Tryptophan\n Y        Tyrosine\n\n B        Aspartic Acid, Asparagine\n Z        Glutamic Acid, Glutamine\n X        Any amino acid\n .        Any amino acid\n\n\n=head2 Multiple Format Support\n\nUltimately, this module should be able to build SeqPattern.pm objects\nusing a variety of pattern formats such as ProSite, Blocks, Prints, GCG, etc.\nCurrently, this module only supports patterns using a grep-like syntax.\n\n=head1 USAGE\n\nA simple demo script called seq_pattern.pl is included in the examples/\ndirectory of the central Bioperl distribution.\n\n=head1 SEE ALSO\n\nL<Bio::Seq> - Lightweight sequence object.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules.  Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nSteve Chervitz, sac-at-bioperl.org\n\n=head1 COPYRIGHT\n\nCopyright (c) 1997-8 Steve Chervitz. All Rights Reserved.\nThis module is free software; you can redistribute it and/or\nmodify it under the same terms as Perl itself.\n\n\n#\n##\n###\n#### END of main POD documentation.\n###\n##\n#'\n# CREATED : 28 Aug 1997\n\n\npackage Bio::Tools::SeqPattern;\n\nuse base qw(Bio::Root::Root);\nuse strict;\nuse vars qw ($ID);\n$ID  = 'Bio::Tools::SeqPattern';\n\n## These constants may be more appropriate in a Bio::Dictionary.pm\n## type of class.\nmy $PURINES      = 'AG';\nmy $PYRIMIDINES  = 'CT';\nmy $BEE      = 'DN';\nmy $ZED      = 'EQ';\nmy $Regexp_chars = '\\w,.\\*()\\[\\]<>\\{\\}^\\$';  # quoted for use in regexps\n\n## Package variables used in reverse complementing.\nmy (%Processed_braces, %Processed_asterics);\n\n#####################################################################################\n##                                 CONSTRUCTOR                                     ##\n#####################################################################################\n\n=head1 new\n\n Title     : new\n Usage     : my $seqpat = Bio::Tools::SeqPattern->new();\n Purpose   : Verifies that the type is correct for superclass (Bio::Seq.pm)\n           : and calls superclass constructor last.\n Returns   : n/a\n Argument  : Parameters passed to new()\n Throws    : Exception if the pattern string (seq) is empty.\n Comments  : The process of creating a new SeqPattern.pm object\n           : ensures that the pattern string is untained.\n\nSee Also   : L<Bio::Root::Root::new>,\n             L<Bio::Seq::_initialize>\n\n\n#----------------\nsub new {\n#----------------\n    my($class, %param) = @_;\n\n    my $self = $class->SUPER::new(%param);\n    my ($seq,$type) = $self->_rearrange([qw(SEQ TYPE)], %param);\n\n    $seq || $self->throw(\"Empty pattern.\");\n    my $t;\n    # Get the type ready for Bio::Seq.pm\n    if ($type =~ /nuc|[dr]na/i) {\n\t$t = 'Dna';\n    } elsif ($type =~ /amino|pep|prot/i) {\n\t$t = 'Amino';\n    }\n    $seq =~ tr/a-z/A-Z/;  #ps 8/8/00 Canonicalize to upper case\n    $self->str($seq);\n    $self->type($t);\n\n    return $self;\n}\n\n\n=head1 alphabet_ok\n\n Title     : alphabet_ok\n Usage     : $mypat->alphabet_ok;\n Purpose   : Checks for invalid regexp characters.\n           : Overrides Bio::Seq::alphabet_ok() to allow\n           : additional regexp characters ,.*()[]<>{}^$\n           : in addition to the standard genetic alphabet.\n           : Also untaints the pattern and sets the sequence\n           : object's sequence to the untained string.\n Returns   : Boolean (1 | 0)\n Argument  : n/a\n Throws    : Exception if the pattern contains invalid characters.\n Comments  : Does not call the superclass method.\n           : Actually permits any alphanumeric, not just the\n           : standard genetic alphabet.\n\n\n#----------------'\nsub alphabet_ok {\n#----------------\n    my( $self) = @_;\n\n    return 1 if $self->{'_alphabet_checked'};\n\n    $self->{'_alphabet_checked'} = 1;\n\n    my $pat = $self->seq();\n\n    if($pat =~ /[^$Regexp_chars]/io) {\n\t$self->throw(\"Pattern contains invalid characters: $pat\",\n\t\t     'Legal characters: a-z,A-Z,0-9,,.*()[]<>{}^$ ');\n    }\n\n    # Untaint pattern (makes code taint-safe).\n    $pat  =~ /([$Regexp_chars]+)/io;\n    $self->setseq(uc($1));\n#    print STDERR \"\\npattern ok: $pat\\n\";\n    1;\n}\n\n=head1 expand\n\n Title     : expand\n Usage     : $seqpat_object->expand();\n Purpose   : Expands the sequence pattern using special ambiguity codes.\n Example   : $pat = $seq_pat->expand();\n Returns   : String containing fully expanded sequence pattern\n Argument  : n/a\n Throws    : Exception if sequence type is not recognized\n           : (i.e., is not one of [DR]NA, Amino)\n\nSee Also   : L<Extended Alphabet Support>, L<_expand_pep>(), L<_expand_nuc>()\n\n\n#----------\nsub expand {\n#----------\n    my $self = shift;\n\n    if($self->type =~ /[DR]na/i) { $self->_expand_nuc(); }\n    elsif($self->type =~ /Amino/i) { $self->_expand_pep(); }\n    else{\n\t$self->throw(\"Don't know how to expand ${\\$self->type} patterns.\\n\");\n    }\n}\n\n\n=head1 _expand_pep\n\n Title     : _expand_pep\n Usage     : n/a; automatically called by expand()\n Purpose   : Expands peptide patterns\n Returns   : String (the expanded pattern)\n Argument  : String (the unexpanded pattern)\n Throws    : n/a\n\nSee Also   : L<expand>(), L<_expand_nuc>()","label":"_expand_pep($self,$pat)"},"detail":"($self,$pat)","definition":"sub","containerName":"main::","children":[{"definition":"my","name":"$self","containerName":"_expand_pep","localvar":"my","kind":13,"line":353},{"name":"$pat","containerName":"_expand_pep","kind":13,"line":353},{"line":354,"kind":13,"name":"$pat","containerName":"_expand_pep"},{"kind":13,"line":354,"name":"$self","containerName":"_expand_pep"},{"kind":12,"line":354,"name":"str","containerName":"_expand_pep"},{"containerName":"_expand_pep","name":"$pat","line":355,"kind":13},{"line":356,"kind":13,"containerName":"_expand_pep","name":"$pat"},{"line":357,"kind":13,"containerName":"_expand_pep","name":"$pat"},{"kind":13,"line":361,"containerName":"_expand_pep","name":"$pat"},{"name":"$pat","containerName":"_expand_pep","kind":13,"line":362},{"containerName":"_expand_pep","name":"$pat","kind":13,"line":363},{"kind":13,"line":364,"containerName":"_expand_pep","name":"$pat"},{"containerName":"_expand_pep","name":"$pat","kind":13,"line":365},{"line":367,"kind":13,"containerName":"_expand_pep","name":"$pat"},{"containerName":"_expand_pep","name":"$pat","kind":13,"line":368},{"line":370,"kind":13,"containerName":"_expand_pep","name":"$pat"},{"line":371,"kind":13,"name":"$pat","containerName":"_expand_pep"},{"containerName":"_expand_pep","name":"$pat","line":373,"kind":13}],"line":351,"kind":12},{"line":391,"children":[{"kind":13,"line":393,"containerName":"_expand_nuc","definition":"my","name":"$self","localvar":"my"},{"containerName":"_expand_nuc","name":"$pat","line":393,"kind":13},{"kind":13,"line":395,"containerName":"_expand_nuc","name":"$pat"},{"line":395,"kind":13,"containerName":"_expand_nuc","name":"$self"},{"kind":12,"line":395,"name":"str","containerName":"_expand_nuc"},{"name":"$pat","containerName":"_expand_nuc","line":396,"kind":13},{"kind":13,"line":397,"containerName":"_expand_nuc","name":"$pat"},{"name":"$pat","containerName":"_expand_nuc","line":398,"kind":13},{"kind":13,"line":399,"containerName":"_expand_nuc","name":"$pat"},{"name":"$pat","containerName":"_expand_nuc","kind":13,"line":400},{"kind":13,"line":401,"name":"$pat","containerName":"_expand_nuc"},{"kind":13,"line":405,"containerName":"_expand_nuc","name":"$pat"},{"containerName":"_expand_nuc","name":"$pat","kind":13,"line":406},{"kind":13,"line":407,"name":"$pat","containerName":"_expand_nuc"},{"name":"$pat","containerName":"_expand_nuc","kind":13,"line":408},{"line":409,"kind":13,"name":"$pat","containerName":"_expand_nuc"},{"line":410,"kind":13,"containerName":"_expand_nuc","name":"$pat"},{"name":"$pat","containerName":"_expand_nuc","line":411,"kind":13},{"line":412,"kind":13,"containerName":"_expand_nuc","name":"$pat"},{"line":413,"kind":13,"containerName":"_expand_nuc","name":"$pat"},{"line":414,"kind":13,"containerName":"_expand_nuc","name":"$pat"},{"containerName":"_expand_nuc","name":"$pat","kind":13,"line":415},{"kind":13,"line":416,"name":"$pat","containerName":"_expand_nuc"},{"kind":13,"line":417,"containerName":"_expand_nuc","name":"$pat"},{"kind":13,"line":418,"containerName":"_expand_nuc","name":"$pat"},{"containerName":"_expand_nuc","name":"$pat","kind":13,"line":419},{"line":420,"kind":13,"name":"$pat","containerName":"_expand_nuc"},{"kind":13,"line":421,"name":"$pat","containerName":"_expand_nuc"},{"line":422,"kind":13,"name":"$pat","containerName":"_expand_nuc"},{"kind":13,"line":423,"name":"$pat","containerName":"_expand_nuc"},{"containerName":"_expand_nuc","name":"$pat","line":424,"kind":13},{"containerName":"_expand_nuc","name":"$pat","kind":13,"line":425},{"kind":13,"line":427,"name":"$pat","containerName":"_expand_nuc"},{"containerName":"_expand_nuc","name":"$pat","line":428,"kind":13},{"containerName":"_expand_nuc","name":"$pat","line":429,"kind":13},{"kind":13,"line":430,"name":"$pat","containerName":"_expand_nuc"},{"line":431,"kind":13,"containerName":"_expand_nuc","name":"$pat"},{"kind":13,"line":432,"containerName":"_expand_nuc","name":"$pat"},{"name":"$pat","containerName":"_expand_nuc","kind":13,"line":433},{"name":"$pat","containerName":"_expand_nuc","kind":13,"line":434},{"line":435,"kind":13,"name":"$pat","containerName":"_expand_nuc"},{"kind":13,"line":436,"name":"$pat","containerName":"_expand_nuc"},{"name":"$pat","containerName":"_expand_nuc","kind":13,"line":438},{"line":439,"kind":13,"name":"$pat","containerName":"_expand_nuc"},{"kind":13,"line":441,"name":"$pat","containerName":"_expand_nuc"}],"kind":12,"detail":"($self,$pat)","signature":{"documentation":"# $Id: SeqPattern.pm 16139 2009-09-18 21:11:23Z cjfields $\n#\n# bioperl module for Bio::Tools::SeqPattern\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by  Steve Chervitz  (sac-at-bioperl.org)\n#\n# Copyright  Steve Chervitz\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::SeqPattern - represent a sequence pattern or motif\n\n=head1 SYNOPSIS\n\n use Bio::Tools::SeqPattern;\n\n my $pat1     = 'T[GA]AA...TAAT';\n my $pattern1 = Bio::Tools::SeqPattern->new(-SEQ =>$pat1, -TYPE =>'Dna');\n\n my $pat2     = '[VILM]R(GXX){3,2}...[^PG]';\n my $pattern2 = Bio::Tools::SeqPattern->new(-SEQ =>$pat2, -TYPE =>'Amino');\n\n=head1 DESCRIPTION\n\nL<Bio::Tools::SeqPattern> module encapsulates generic data and\nmethods for manipulating regular expressions describing nucleic or\namino acid sequence patterns (a.k.a, \"motifs\").\n\nL<Bio::Tools::SeqPattern> is a concrete class that inherits from L<Bio::Seq>.\n\nThis class grew out of a need to have a standard module for doing routine\ntasks with sequence patterns such as:\n\n  -- Forming a reverse-complement version of a nucleotide sequence pattern\n  -- Expanding patterns containing ambiguity codes\n  -- Checking for invalid regexp characters\n  -- Untainting yet preserving special characters in the pattern\n\nOther features to look for in the future:\n\n  -- Full pattern syntax checking\n  -- Conversion between expanded and condensed forms of the pattern\n\n=head1 MOTIVATIONS\n\nA key motivation for L<Bio::Tools::SeqPattern> is to have a way to\ngenerate a reverse complement of a nucleotide sequence pattern.\nThis makes possible simultaneous pattern matching on both sense and\nanti-sense strands of a query sequence.\n\nIn principle, one could do such a search more inefficiently by testing\nagainst both sense and anti-sense versions of a sequence.\nIt is entirely equivalent to test a regexp containing both sense and\nanti-sense versions of the *pattern* against one copy of the sequence.\nThe latter approach is much more efficient since:\n\n   1) You need only one copy of the sequence.\n   2) Only one regexp is executed.\n   3) Regexp patterns are typically much smaller than sequences.\n\nPatterns can be quite complex and it is often difficult to\ngenerate the reverse complement pattern. The Bioperl SeqPattern.pm\naddresses this problem, providing a convenient set of tools\nfor working with biological sequence regular expressions.\n\nNot all patterns have been tested. If you discover a pattern that\nis not handled properly by Bio::Tools::SeqPattern.pm, please\nsend me some email (sac@bioperl.org). Thanks.\n\n=head1 OTHER FEATURES\n\n=head2 Extended Alphabet Support\n\nThis module supports the same set of ambiguity codes for nucleotide\nsequences as supported by L<Bio::Seq>. These ambiguity codes\ndefine the behavior or the L<expand> method.\n\n ------------------------------------------\n Symbol       Meaning      Nucleic Acid\n ------------------------------------------\n  A            A           (A)denine\n  C            C           (C)ytosine\n  G            G           (G)uanine\n  T            T           (T)hymine\n  U            U           (U)racil\n  M          A or C        a(M)ino group\n  R          A or G        pu(R)ine\n  W          A or T        (W)eak bond\n  S          C or G        (S)trong bond\n  Y          C or T        p(Y)rimidine\n  K          G or T        (K)eto group\n  V        A or C or G\n  H        A or C or T\n  D        A or G or T\n  B        C or G or T\n  X      G or A or T or C\n  N      G or A or T or C\n  .      G or A or T or C\n\n\n\n ------------------------------------------\n Symbol           Meaning\n ------------------------------------------\n A        Alanine\n C        Cysteine\n D        Aspartic Acid\n E        Glutamic Acid\n F        Phenylalanine\n G        Glycine\n H        Histidine\n I        Isoleucine\n K        Lysine\n L        Leucine\n M        Methionine\n N        Asparagine\n P        Proline\n Q        Glutamine\n R        Arginine\n S        Serine\n T        Threonine\n V        Valine\n W        Tryptophan\n Y        Tyrosine\n\n B        Aspartic Acid, Asparagine\n Z        Glutamic Acid, Glutamine\n X        Any amino acid\n .        Any amino acid\n\n\n=head2 Multiple Format Support\n\nUltimately, this module should be able to build SeqPattern.pm objects\nusing a variety of pattern formats such as ProSite, Blocks, Prints, GCG, etc.\nCurrently, this module only supports patterns using a grep-like syntax.\n\n=head1 USAGE\n\nA simple demo script called seq_pattern.pl is included in the examples/\ndirectory of the central Bioperl distribution.\n\n=head1 SEE ALSO\n\nL<Bio::Seq> - Lightweight sequence object.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules.  Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nSteve Chervitz, sac-at-bioperl.org\n\n=head1 COPYRIGHT\n\nCopyright (c) 1997-8 Steve Chervitz. All Rights Reserved.\nThis module is free software; you can redistribute it and/or\nmodify it under the same terms as Perl itself.\n\n\n#\n##\n###\n#### END of main POD documentation.\n###\n##\n#'\n# CREATED : 28 Aug 1997\n\n\npackage Bio::Tools::SeqPattern;\n\nuse base qw(Bio::Root::Root);\nuse strict;\nuse vars qw ($ID);\n$ID  = 'Bio::Tools::SeqPattern';\n\n## These constants may be more appropriate in a Bio::Dictionary.pm\n## type of class.\nmy $PURINES      = 'AG';\nmy $PYRIMIDINES  = 'CT';\nmy $BEE      = 'DN';\nmy $ZED      = 'EQ';\nmy $Regexp_chars = '\\w,.\\*()\\[\\]<>\\{\\}^\\$';  # quoted for use in regexps\n\n## Package variables used in reverse complementing.\nmy (%Processed_braces, %Processed_asterics);\n\n#####################################################################################\n##                                 CONSTRUCTOR                                     ##\n#####################################################################################\n\n=head1 new\n\n Title     : new\n Usage     : my $seqpat = Bio::Tools::SeqPattern->new();\n Purpose   : Verifies that the type is correct for superclass (Bio::Seq.pm)\n           : and calls superclass constructor last.\n Returns   : n/a\n Argument  : Parameters passed to new()\n Throws    : Exception if the pattern string (seq) is empty.\n Comments  : The process of creating a new SeqPattern.pm object\n           : ensures that the pattern string is untained.\n\nSee Also   : L<Bio::Root::Root::new>,\n             L<Bio::Seq::_initialize>\n\n\n#----------------\nsub new {\n#----------------\n    my($class, %param) = @_;\n\n    my $self = $class->SUPER::new(%param);\n    my ($seq,$type) = $self->_rearrange([qw(SEQ TYPE)], %param);\n\n    $seq || $self->throw(\"Empty pattern.\");\n    my $t;\n    # Get the type ready for Bio::Seq.pm\n    if ($type =~ /nuc|[dr]na/i) {\n\t$t = 'Dna';\n    } elsif ($type =~ /amino|pep|prot/i) {\n\t$t = 'Amino';\n    }\n    $seq =~ tr/a-z/A-Z/;  #ps 8/8/00 Canonicalize to upper case\n    $self->str($seq);\n    $self->type($t);\n\n    return $self;\n}\n\n\n=head1 alphabet_ok\n\n Title     : alphabet_ok\n Usage     : $mypat->alphabet_ok;\n Purpose   : Checks for invalid regexp characters.\n           : Overrides Bio::Seq::alphabet_ok() to allow\n           : additional regexp characters ,.*()[]<>{}^$\n           : in addition to the standard genetic alphabet.\n           : Also untaints the pattern and sets the sequence\n           : object's sequence to the untained string.\n Returns   : Boolean (1 | 0)\n Argument  : n/a\n Throws    : Exception if the pattern contains invalid characters.\n Comments  : Does not call the superclass method.\n           : Actually permits any alphanumeric, not just the\n           : standard genetic alphabet.\n\n\n#----------------'\nsub alphabet_ok {\n#----------------\n    my( $self) = @_;\n\n    return 1 if $self->{'_alphabet_checked'};\n\n    $self->{'_alphabet_checked'} = 1;\n\n    my $pat = $self->seq();\n\n    if($pat =~ /[^$Regexp_chars]/io) {\n\t$self->throw(\"Pattern contains invalid characters: $pat\",\n\t\t     'Legal characters: a-z,A-Z,0-9,,.*()[]<>{}^$ ');\n    }\n\n    # Untaint pattern (makes code taint-safe).\n    $pat  =~ /([$Regexp_chars]+)/io;\n    $self->setseq(uc($1));\n#    print STDERR \"\\npattern ok: $pat\\n\";\n    1;\n}\n\n=head1 expand\n\n Title     : expand\n Usage     : $seqpat_object->expand();\n Purpose   : Expands the sequence pattern using special ambiguity codes.\n Example   : $pat = $seq_pat->expand();\n Returns   : String containing fully expanded sequence pattern\n Argument  : n/a\n Throws    : Exception if sequence type is not recognized\n           : (i.e., is not one of [DR]NA, Amino)\n\nSee Also   : L<Extended Alphabet Support>, L<_expand_pep>(), L<_expand_nuc>()\n\n\n#----------\nsub expand {\n#----------\n    my $self = shift;\n\n    if($self->type =~ /[DR]na/i) { $self->_expand_nuc(); }\n    elsif($self->type =~ /Amino/i) { $self->_expand_pep(); }\n    else{\n\t$self->throw(\"Don't know how to expand ${\\$self->type} patterns.\\n\");\n    }\n}\n\n\n=head1 _expand_pep\n\n Title     : _expand_pep\n Usage     : n/a; automatically called by expand()\n Purpose   : Expands peptide patterns\n Returns   : String (the expanded pattern)\n Argument  : String (the unexpanded pattern)\n Throws    : n/a\n\nSee Also   : L<expand>(), L<_expand_nuc>()\n\n\n#----------------\nsub _expand_pep {\n#----------------\n    my ($self,$pat) = @_;\n    $pat ||= $self->str;\n    $pat =~ s/X/./g;\n    $pat =~ s/^</\\^/;\n    $pat =~ s/>$/\\$/;\n\n    ## Avoid nested situations: [bmnq] --/--> [[$ZED]mnq]\n    ## Yet correctly deal with: fze[bmnq] ---> f[$BEE]e[$ZEDmnq]\n    if($pat =~ /\\[\\w*[BZ]\\w*\\]/) {\n\t$pat =~ s/\\[(\\w*)B(\\w*)\\]/\\[$1$ZED$2\\]/g;\n\t$pat =~ s/\\[(\\w*)Z(\\w*)\\]/\\[$1$BEE$2\\]/g;\n\t$pat =~ s/B/\\[$ZED\\]/g;\n\t$pat =~ s/Z/\\[$BEE\\]/g;\n    } else {\n\t$pat =~ s/B/\\[$ZED\\]/g;\n\t$pat =~ s/Z/\\[$BEE\\]/g;\n    }\n    $pat =~ s/\\((.)\\)/$1/g;  ## Doing these last since:\n    $pat =~ s/\\[(.)\\]/$1/g;  ## Pattern could contain [B] (for example)\n\n    return $pat;\n}\n\n\n\n=head1 _expand_nuc\n\n Title     : _expand_nuc\n Purpose   : Expands nucleotide patterns\n Returns   : String (the expanded pattern)\n Argument  : String (the unexpanded pattern)\n Throws    : n/a\n\nSee Also   : L<expand>(), L<_expand_pep>()","parameters":[{"label":"$self"},{"label":"$pat"}],"label":"_expand_nuc($self,$pat)"},"containerName":"main::","definition":"sub","range":{"end":{"line":442,"character":9999},"start":{"line":391,"character":0}},"name":"_expand_nuc"},{"range":{"end":{"line":518,"character":9999},"start":{"character":0,"line":473}},"name":"revcom","line":473,"children":[{"kind":13,"line":475,"containerName":"revcom","definition":"my","name":"$self","localvar":"my"},{"name":"$expand","containerName":"revcom","line":475,"kind":13},{"name":"$self","containerName":"revcom","line":477,"kind":13},{"line":477,"kind":12,"containerName":"revcom","name":"type"},{"name":"$self","containerName":"revcom","line":478,"kind":13},{"kind":12,"line":478,"containerName":"revcom","name":"throw"},{"kind":13,"line":482,"containerName":"revcom","name":"$expand"},{"kind":13,"line":483,"definition":"my","name":"$str","containerName":"revcom","localvar":"my"},{"name":"$self","containerName":"revcom","kind":13,"line":483},{"kind":12,"line":483,"containerName":"revcom","name":"str"},{"kind":13,"line":484,"name":"$str","containerName":"revcom"},{"localvar":"my","name":"$rev","definition":"my","containerName":"revcom","line":485,"kind":13},{"kind":13,"line":485,"containerName":"revcom","name":"$str"},{"kind":13,"line":486,"containerName":"revcom","name":"$rev"},{"containerName":"revcom","name":"$expand","kind":13,"line":488},{"containerName":"revcom","name":"$rev","line":489,"kind":13},{"containerName":"revcom","name":"$self","line":489,"kind":13},{"containerName":"revcom","name":"_expand_nuc","line":489,"kind":12},{"line":489,"kind":13,"name":"$rev","containerName":"revcom"},{"kind":13,"line":493,"containerName":"revcom","name":"%Processed_braces"},{"containerName":"revcom","name":"%Processed_asterics","line":494,"kind":13},{"localvar":"my","name":"$fixrev","definition":"my","containerName":"revcom","line":496,"kind":13},{"containerName":"revcom","name":"$rev","line":496,"kind":13},{"containerName":"revcom","name":"$fixrev","line":499,"kind":13},{"kind":13,"line":499,"name":"$fixrev","containerName":"revcom"},{"kind":13,"line":502,"name":"$fixrev","containerName":"revcom"},{"kind":13,"line":502,"containerName":"revcom","name":"$fixrev"},{"kind":13,"line":505,"name":"$fixrev","containerName":"revcom"},{"name":"$fixrev","containerName":"revcom","line":505,"kind":13},{"containerName":"revcom","name":"$fixrev","line":508,"kind":13},{"kind":13,"line":508,"containerName":"revcom","name":"$fixrev"},{"line":512,"kind":13,"containerName":"revcom","name":"$fixrev"},{"kind":13,"line":512,"name":"$fixrev","containerName":"revcom"},{"line":517,"kind":13,"name":"$fixrev","containerName":"revcom"},{"containerName":"revcom","name":"$self","kind":13,"line":517},{"line":517,"kind":12,"name":"type","containerName":"revcom"}],"kind":12,"detail":"($self,$expand)","signature":{"label":"revcom($self,$expand)","documentation":"# $Id: SeqPattern.pm 16139 2009-09-18 21:11:23Z cjfields $\n#\n# bioperl module for Bio::Tools::SeqPattern\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by  Steve Chervitz  (sac-at-bioperl.org)\n#\n# Copyright  Steve Chervitz\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::SeqPattern - represent a sequence pattern or motif\n\n=head1 SYNOPSIS\n\n use Bio::Tools::SeqPattern;\n\n my $pat1     = 'T[GA]AA...TAAT';\n my $pattern1 = Bio::Tools::SeqPattern->new(-SEQ =>$pat1, -TYPE =>'Dna');\n\n my $pat2     = '[VILM]R(GXX){3,2}...[^PG]';\n my $pattern2 = Bio::Tools::SeqPattern->new(-SEQ =>$pat2, -TYPE =>'Amino');\n\n=head1 DESCRIPTION\n\nL<Bio::Tools::SeqPattern> module encapsulates generic data and\nmethods for manipulating regular expressions describing nucleic or\namino acid sequence patterns (a.k.a, \"motifs\").\n\nL<Bio::Tools::SeqPattern> is a concrete class that inherits from L<Bio::Seq>.\n\nThis class grew out of a need to have a standard module for doing routine\ntasks with sequence patterns such as:\n\n  -- Forming a reverse-complement version of a nucleotide sequence pattern\n  -- Expanding patterns containing ambiguity codes\n  -- Checking for invalid regexp characters\n  -- Untainting yet preserving special characters in the pattern\n\nOther features to look for in the future:\n\n  -- Full pattern syntax checking\n  -- Conversion between expanded and condensed forms of the pattern\n\n=head1 MOTIVATIONS\n\nA key motivation for L<Bio::Tools::SeqPattern> is to have a way to\ngenerate a reverse complement of a nucleotide sequence pattern.\nThis makes possible simultaneous pattern matching on both sense and\nanti-sense strands of a query sequence.\n\nIn principle, one could do such a search more inefficiently by testing\nagainst both sense and anti-sense versions of a sequence.\nIt is entirely equivalent to test a regexp containing both sense and\nanti-sense versions of the *pattern* against one copy of the sequence.\nThe latter approach is much more efficient since:\n\n   1) You need only one copy of the sequence.\n   2) Only one regexp is executed.\n   3) Regexp patterns are typically much smaller than sequences.\n\nPatterns can be quite complex and it is often difficult to\ngenerate the reverse complement pattern. The Bioperl SeqPattern.pm\naddresses this problem, providing a convenient set of tools\nfor working with biological sequence regular expressions.\n\nNot all patterns have been tested. If you discover a pattern that\nis not handled properly by Bio::Tools::SeqPattern.pm, please\nsend me some email (sac@bioperl.org). Thanks.\n\n=head1 OTHER FEATURES\n\n=head2 Extended Alphabet Support\n\nThis module supports the same set of ambiguity codes for nucleotide\nsequences as supported by L<Bio::Seq>. These ambiguity codes\ndefine the behavior or the L<expand> method.\n\n ------------------------------------------\n Symbol       Meaning      Nucleic Acid\n ------------------------------------------\n  A            A           (A)denine\n  C            C           (C)ytosine\n  G            G           (G)uanine\n  T            T           (T)hymine\n  U            U           (U)racil\n  M          A or C        a(M)ino group\n  R          A or G        pu(R)ine\n  W          A or T        (W)eak bond\n  S          C or G        (S)trong bond\n  Y          C or T        p(Y)rimidine\n  K          G or T        (K)eto group\n  V        A or C or G\n  H        A or C or T\n  D        A or G or T\n  B        C or G or T\n  X      G or A or T or C\n  N      G or A or T or C\n  .      G or A or T or C\n\n\n\n ------------------------------------------\n Symbol           Meaning\n ------------------------------------------\n A        Alanine\n C        Cysteine\n D        Aspartic Acid\n E        Glutamic Acid\n F        Phenylalanine\n G        Glycine\n H        Histidine\n I        Isoleucine\n K        Lysine\n L        Leucine\n M        Methionine\n N        Asparagine\n P        Proline\n Q        Glutamine\n R        Arginine\n S        Serine\n T        Threonine\n V        Valine\n W        Tryptophan\n Y        Tyrosine\n\n B        Aspartic Acid, Asparagine\n Z        Glutamic Acid, Glutamine\n X        Any amino acid\n .        Any amino acid\n\n\n=head2 Multiple Format Support\n\nUltimately, this module should be able to build SeqPattern.pm objects\nusing a variety of pattern formats such as ProSite, Blocks, Prints, GCG, etc.\nCurrently, this module only supports patterns using a grep-like syntax.\n\n=head1 USAGE\n\nA simple demo script called seq_pattern.pl is included in the examples/\ndirectory of the central Bioperl distribution.\n\n=head1 SEE ALSO\n\nL<Bio::Seq> - Lightweight sequence object.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules.  Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nSteve Chervitz, sac-at-bioperl.org\n\n=head1 COPYRIGHT\n\nCopyright (c) 1997-8 Steve Chervitz. All Rights Reserved.\nThis module is free software; you can redistribute it and/or\nmodify it under the same terms as Perl itself.\n\n\n#\n##\n###\n#### END of main POD documentation.\n###\n##\n#'\n# CREATED : 28 Aug 1997\n\n\npackage Bio::Tools::SeqPattern;\n\nuse base qw(Bio::Root::Root);\nuse strict;\nuse vars qw ($ID);\n$ID  = 'Bio::Tools::SeqPattern';\n\n## These constants may be more appropriate in a Bio::Dictionary.pm\n## type of class.\nmy $PURINES      = 'AG';\nmy $PYRIMIDINES  = 'CT';\nmy $BEE      = 'DN';\nmy $ZED      = 'EQ';\nmy $Regexp_chars = '\\w,.\\*()\\[\\]<>\\{\\}^\\$';  # quoted for use in regexps\n\n## Package variables used in reverse complementing.\nmy (%Processed_braces, %Processed_asterics);\n\n#####################################################################################\n##                                 CONSTRUCTOR                                     ##\n#####################################################################################\n\n=head1 new\n\n Title     : new\n Usage     : my $seqpat = Bio::Tools::SeqPattern->new();\n Purpose   : Verifies that the type is correct for superclass (Bio::Seq.pm)\n           : and calls superclass constructor last.\n Returns   : n/a\n Argument  : Parameters passed to new()\n Throws    : Exception if the pattern string (seq) is empty.\n Comments  : The process of creating a new SeqPattern.pm object\n           : ensures that the pattern string is untained.\n\nSee Also   : L<Bio::Root::Root::new>,\n             L<Bio::Seq::_initialize>\n\n\n#----------------\nsub new {\n#----------------\n    my($class, %param) = @_;\n\n    my $self = $class->SUPER::new(%param);\n    my ($seq,$type) = $self->_rearrange([qw(SEQ TYPE)], %param);\n\n    $seq || $self->throw(\"Empty pattern.\");\n    my $t;\n    # Get the type ready for Bio::Seq.pm\n    if ($type =~ /nuc|[dr]na/i) {\n\t$t = 'Dna';\n    } elsif ($type =~ /amino|pep|prot/i) {\n\t$t = 'Amino';\n    }\n    $seq =~ tr/a-z/A-Z/;  #ps 8/8/00 Canonicalize to upper case\n    $self->str($seq);\n    $self->type($t);\n\n    return $self;\n}\n\n\n=head1 alphabet_ok\n\n Title     : alphabet_ok\n Usage     : $mypat->alphabet_ok;\n Purpose   : Checks for invalid regexp characters.\n           : Overrides Bio::Seq::alphabet_ok() to allow\n           : additional regexp characters ,.*()[]<>{}^$\n           : in addition to the standard genetic alphabet.\n           : Also untaints the pattern and sets the sequence\n           : object's sequence to the untained string.\n Returns   : Boolean (1 | 0)\n Argument  : n/a\n Throws    : Exception if the pattern contains invalid characters.\n Comments  : Does not call the superclass method.\n           : Actually permits any alphanumeric, not just the\n           : standard genetic alphabet.\n\n\n#----------------'\nsub alphabet_ok {\n#----------------\n    my( $self) = @_;\n\n    return 1 if $self->{'_alphabet_checked'};\n\n    $self->{'_alphabet_checked'} = 1;\n\n    my $pat = $self->seq();\n\n    if($pat =~ /[^$Regexp_chars]/io) {\n\t$self->throw(\"Pattern contains invalid characters: $pat\",\n\t\t     'Legal characters: a-z,A-Z,0-9,,.*()[]<>{}^$ ');\n    }\n\n    # Untaint pattern (makes code taint-safe).\n    $pat  =~ /([$Regexp_chars]+)/io;\n    $self->setseq(uc($1));\n#    print STDERR \"\\npattern ok: $pat\\n\";\n    1;\n}\n\n=head1 expand\n\n Title     : expand\n Usage     : $seqpat_object->expand();\n Purpose   : Expands the sequence pattern using special ambiguity codes.\n Example   : $pat = $seq_pat->expand();\n Returns   : String containing fully expanded sequence pattern\n Argument  : n/a\n Throws    : Exception if sequence type is not recognized\n           : (i.e., is not one of [DR]NA, Amino)\n\nSee Also   : L<Extended Alphabet Support>, L<_expand_pep>(), L<_expand_nuc>()\n\n\n#----------\nsub expand {\n#----------\n    my $self = shift;\n\n    if($self->type =~ /[DR]na/i) { $self->_expand_nuc(); }\n    elsif($self->type =~ /Amino/i) { $self->_expand_pep(); }\n    else{\n\t$self->throw(\"Don't know how to expand ${\\$self->type} patterns.\\n\");\n    }\n}\n\n\n=head1 _expand_pep\n\n Title     : _expand_pep\n Usage     : n/a; automatically called by expand()\n Purpose   : Expands peptide patterns\n Returns   : String (the expanded pattern)\n Argument  : String (the unexpanded pattern)\n Throws    : n/a\n\nSee Also   : L<expand>(), L<_expand_nuc>()\n\n\n#----------------\nsub _expand_pep {\n#----------------\n    my ($self,$pat) = @_;\n    $pat ||= $self->str;\n    $pat =~ s/X/./g;\n    $pat =~ s/^</\\^/;\n    $pat =~ s/>$/\\$/;\n\n    ## Avoid nested situations: [bmnq] --/--> [[$ZED]mnq]\n    ## Yet correctly deal with: fze[bmnq] ---> f[$BEE]e[$ZEDmnq]\n    if($pat =~ /\\[\\w*[BZ]\\w*\\]/) {\n\t$pat =~ s/\\[(\\w*)B(\\w*)\\]/\\[$1$ZED$2\\]/g;\n\t$pat =~ s/\\[(\\w*)Z(\\w*)\\]/\\[$1$BEE$2\\]/g;\n\t$pat =~ s/B/\\[$ZED\\]/g;\n\t$pat =~ s/Z/\\[$BEE\\]/g;\n    } else {\n\t$pat =~ s/B/\\[$ZED\\]/g;\n\t$pat =~ s/Z/\\[$BEE\\]/g;\n    }\n    $pat =~ s/\\((.)\\)/$1/g;  ## Doing these last since:\n    $pat =~ s/\\[(.)\\]/$1/g;  ## Pattern could contain [B] (for example)\n\n    return $pat;\n}\n\n\n\n=head1 _expand_nuc\n\n Title     : _expand_nuc\n Purpose   : Expands nucleotide patterns\n Returns   : String (the expanded pattern)\n Argument  : String (the unexpanded pattern)\n Throws    : n/a\n\nSee Also   : L<expand>(), L<_expand_pep>()\n\n\n#---------------\nsub _expand_nuc {\n#---------------\n    my ($self,$pat) = @_;\n\n    $pat ||= $self->str;\n    $pat =~ s/N|X/./g;\n    $pat =~ s/pu/R/ig;\n    $pat =~ s/py/Y/ig;\n    $pat =~ s/U/T/g;\n    $pat =~ s/^</\\^/;\n    $pat =~ s/>$/\\$/;\n\n    ## Avoid nested situations: [ya] --/--> [[ct]a]\n    ## Yet correctly deal with: sg[ya] ---> [gc]g[cta]\n    if($pat =~ /\\[\\w*[RYSWMK]\\w*\\]/) {\n\t$pat =~ s/\\[(\\w*)R(\\w*)\\]/\\[$1$PURINES$2\\]/g;\n\t$pat =~ s/\\[(\\w*)Y(\\w*)\\]/\\[$1$PYRIMIDINES$2\\]/g;\n\t$pat =~ s/\\[(\\w*)S(\\w*)\\]/\\[$1GC$2\\]/g;\n\t$pat =~ s/\\[(\\w*)W(\\w*)\\]/\\[$1AT$2\\]/g;\n\t$pat =~ s/\\[(\\w*)M(\\w*)\\]/\\[$1AC$2\\]/g;\n\t$pat =~ s/\\[(\\w*)K(\\w*)\\]/\\[$1GT$2\\]/g;\n\t$pat =~ s/\\[(\\w*)V(\\w*)\\]/\\[$1ACG$2\\]/g;\n\t$pat =~ s/\\[(\\w*)H(\\w*)\\]/\\[$1ACT$2\\]/g;\n\t$pat =~ s/\\[(\\w*)D(\\w*)\\]/\\[$1AGT$2\\]/g;\n\t$pat =~ s/\\[(\\w*)B(\\w*)\\]/\\[$1CGT$2\\]/g;\n\t$pat =~ s/R/\\[$PURINES\\]/g;\n\t$pat =~ s/Y/\\[$PYRIMIDINES\\]/g;\n\t$pat =~ s/S/\\[GC\\]/g;\n\t$pat =~ s/W/\\[AT\\]/g;\n\t$pat =~ s/M/\\[AC\\]/g;\n\t$pat =~ s/K/\\[GT\\]/g;\n\t$pat =~ s/V/\\[ACG\\]/g;\n\t$pat =~ s/H/\\[ACT\\]/g;\n\t$pat =~ s/D/\\[AGT\\]/g;\n\t$pat =~ s/B/\\[CGT\\]/g;\n    } else {\n\t$pat =~ s/R/\\[$PURINES\\]/g;\n\t$pat =~ s/Y/\\[$PYRIMIDINES\\]/g;\n\t$pat =~ s/S/\\[GC\\]/g;\n\t$pat =~ s/W/\\[AT\\]/g;\n\t$pat =~ s/M/\\[AC\\]/g;\n\t$pat =~ s/K/\\[GT\\]/g;\n\t$pat =~ s/V/\\[ACG\\]/g;\n\t$pat =~ s/H/\\[ACT\\]/g;\n\t$pat =~ s/D/\\[AGT\\]/g;\n\t$pat =~ s/B/\\[CGT\\]/g;\n    }\n    $pat =~ s/\\((.)\\)/$1/g;  ## Doing thses last since:\n    $pat =~ s/\\[(.)\\]/$1/g;  ## Pattern could contain [y] (for example)\n\n    return $pat;\n}\n\n\n\n=head1 revcom\n\n Title     : revcom\n Usage     : revcom([1]);\n Purpose   : Forms a pattern capable of recognizing the reverse complement\n           : version of a nucleotide sequence pattern.\n Example   : $pattern_object->revcom();\n           : $pattern_object->revcom(1); ## returns expanded rev complement pattern.\n Returns   : Object reference for a new Bio::Tools::SeqPattern containing\n           : the revcom of the current pattern as its sequence.\n Argument  : (1) boolean (optional) (default= false)\n           :     true : expand the pattern before rev-complementing.\n           :     false: don't expand pattern before or after rev-complementing.\n Throws    : Exception if called for amino acid sequence pattern.\n Comments  : This method permits the simultaneous searching of both\n           : sense and anti-sense versions of a nucleotide pattern\n           : by means of a grep-type of functionality in which any\n           : number of patterns may be or-ed into the recognition\n           : pattern.\n           : Overrides Bio::Seq::revcom() and calls it first thing.\n           : The order of _fixpat() calls is critical.\n\nSee Also   : L<Bio::Seq::revcom>, L</_fixpat_1>, L</_fixpat_2>, L</_fixpat_3>, L</_fixpat_4>, L</_fixpat_5>\n\n-----------'","parameters":[{"label":"$self"},{"label":"$expand"}]},"containerName":"main::","definition":"sub"},{"line":486,"kind":12,"name":"CORE","containerName":"reverse"},{"name":"_fixpat_1","line":496,"kind":12},{"name":"_fixpat_2","line":499,"kind":12},{"name":"_fixpat_3","line":502,"kind":12},{"kind":12,"line":505,"name":"_fixpat_4"},{"name":"_fixpat_5","kind":12,"line":508},{"name":"_fixpat_6","line":512,"kind":12},{"name":"Bio","containerName":"Tools::SeqPattern","line":517,"kind":12},{"line":533,"children":[{"line":534,"kind":13,"localvar":"my","containerName":"backtranslate","definition":"my","name":"$self"},{"name":"$self","containerName":"backtranslate","line":537,"kind":13},{"containerName":"backtranslate","name":"_load_module","kind":12,"line":537},{"kind":12,"line":538,"containerName":"backtranslate","name":"import"},{"kind":13,"line":540,"name":"$self","containerName":"backtranslate"},{"containerName":"backtranslate","name":"type","line":540,"kind":12},{"containerName":"backtranslate","name":"$self","kind":13,"line":541},{"containerName":"backtranslate","name":"throw","line":541,"kind":12},{"kind":12,"line":546,"name":"new","containerName":"backtranslate"},{"kind":13,"line":547,"containerName":"backtranslate","name":"$self"},{"line":547,"kind":12,"containerName":"backtranslate","name":"str"}],"kind":12,"range":{"start":{"line":533,"character":0},"end":{"character":9999,"line":550}},"containerName":"main::","definition":"sub","name":"backtranslate"},{"name":"Bio","containerName":"Tools::SeqPattern::Backtranslate","line":538,"kind":12},{"kind":12,"line":547,"name":"_reverse_translate_motif"},{"name":"_fixpat_1","definition":"sub","containerName":"main::","range":{"end":{"line":619,"character":9999},"start":{"line":569,"character":0}},"kind":12,"children":[{"containerName":"_fixpat_1","definition":"my","name":"$pat","localvar":"my","kind":13,"line":571},{"kind":13,"line":574,"name":"@done","definition":"my","containerName":"_fixpat_1","localvar":"my"},{"line":574,"kind":13,"containerName":"_fixpat_1","name":"@parts"},{"containerName":"_fixpat_1","name":"$pat","line":576,"kind":13},{"containerName":"_fixpat_1","name":"@done","line":576,"kind":13},{"name":"$pat","containerName":"_fixpat_1","kind":13,"line":576},{"kind":13,"line":577,"containerName":"_fixpat_1","name":"$pat"},{"containerName":"_fixpat_1","name":"@parts","line":580,"kind":13},{"line":580,"kind":13,"containerName":"_fixpat_1","name":"$pat"},{"line":581,"kind":13,"name":"@done","containerName":"_fixpat_1"},{"name":"$parts","containerName":"_fixpat_1","line":581,"kind":13},{"name":"$pat","containerName":"_fixpat_1","line":582,"kind":13},{"containerName":"_fixpat_1","name":"$parts","kind":13,"line":582},{"kind":13,"line":584,"containerName":"_fixpat_1","name":"$pat"},{"kind":13,"line":586,"name":"$pat","containerName":"_fixpat_1"},{"name":"@done","containerName":"_fixpat_1","line":586,"kind":13},{"kind":13,"line":589,"containerName":"_fixpat_1","name":"@done"},{"name":"$pat","containerName":"_fixpat_1","line":591,"kind":13},{"kind":13,"line":591,"name":"@done","containerName":"_fixpat_1"},{"line":591,"kind":13,"name":"$pat","containerName":"_fixpat_1"},{"containerName":"_fixpat_1","name":"$pat","line":592,"kind":13},{"line":595,"kind":13,"name":"@parts","containerName":"_fixpat_1"},{"name":"$pat","containerName":"_fixpat_1","line":595,"kind":13},{"name":"@done","containerName":"_fixpat_1","kind":13,"line":596},{"kind":13,"line":596,"name":"$parts","containerName":"_fixpat_1"},{"line":597,"kind":13,"containerName":"_fixpat_1","name":"$pat"},{"kind":13,"line":597,"containerName":"_fixpat_1","name":"$parts"},{"kind":13,"line":599,"containerName":"_fixpat_1","name":"$pat"},{"line":601,"kind":13,"name":"$pat","containerName":"_fixpat_1"},{"line":601,"kind":13,"name":"@done","containerName":"_fixpat_1"},{"name":"@done","containerName":"_fixpat_1","line":604,"kind":13},{"containerName":"_fixpat_1","name":"$pat","kind":13,"line":606},{"kind":13,"line":606,"name":"@done","containerName":"_fixpat_1"},{"containerName":"_fixpat_1","name":"$pat","line":606,"kind":13},{"kind":13,"line":607,"containerName":"_fixpat_1","name":"$pat"},{"kind":13,"line":608,"name":"$Processed_asterics","containerName":"_fixpat_1"},{"kind":13,"line":611,"containerName":"_fixpat_1","name":"@parts"},{"kind":13,"line":611,"name":"$pat","containerName":"_fixpat_1"},{"containerName":"_fixpat_1","name":"@done","line":612,"kind":13},{"line":612,"kind":13,"name":"$parts","containerName":"_fixpat_1"},{"line":613,"kind":13,"name":"$pat","containerName":"_fixpat_1"},{"kind":13,"line":613,"name":"$parts","containerName":"_fixpat_1"},{"line":615,"kind":13,"containerName":"_fixpat_1","name":"$pat"},{"line":617,"kind":13,"containerName":"_fixpat_1","name":"@done"}],"line":569},{"line":638,"children":[{"line":640,"kind":13,"localvar":"my","name":"$pat","definition":"my","containerName":"_fixpat_2"},{"localvar":"my","name":"@done","definition":"my","containerName":"_fixpat_2","line":643,"kind":13},{"line":643,"kind":13,"name":"@parts","containerName":"_fixpat_2"},{"name":"$braces","containerName":"_fixpat_2","line":643,"kind":13},{"kind":13,"line":646,"containerName":"_fixpat_2","name":"$pat"},{"kind":13,"line":646,"name":"@done","containerName":"_fixpat_2"},{"name":"$pat","containerName":"_fixpat_2","line":646,"kind":13},{"containerName":"_fixpat_2","name":"$braces","kind":13,"line":647},{"name":"$braces","containerName":"_fixpat_2","line":648,"kind":13},{"containerName":"_fixpat_2","name":"$Processed_braces","kind":13,"line":649},{"containerName":"_fixpat_2","name":"@parts","line":651,"kind":13},{"kind":13,"line":651,"name":"$pat","containerName":"_fixpat_2"},{"name":"@done","containerName":"_fixpat_2","line":652,"kind":13},{"kind":13,"line":652,"name":"$parts","containerName":"_fixpat_2"},{"line":653,"kind":13,"containerName":"_fixpat_2","name":"$pat"},{"kind":13,"line":653,"name":"$parts","containerName":"_fixpat_2"},{"kind":13,"line":655,"containerName":"_fixpat_2","name":"$pat"},{"name":"@done","containerName":"_fixpat_2","kind":13,"line":657}],"kind":12,"range":{"end":{"line":658,"character":9999},"start":{"line":638,"character":0}},"containerName":"main::","name":"_fixpat_2","definition":"sub"},{"range":{"end":{"character":9999,"line":708},"start":{"character":0,"line":676}},"containerName":"main::","definition":"sub","name":"_fixpat_3","line":676,"children":[{"localvar":"my","name":"$pat","definition":"my","containerName":"_fixpat_3","line":678,"kind":13},{"localvar":"my","containerName":"_fixpat_3","name":"@done","definition":"my","line":680,"kind":13},{"name":"@parts","containerName":"_fixpat_3","kind":13,"line":680},{"line":680,"kind":13,"name":"$braces","containerName":"_fixpat_3"},{"containerName":"_fixpat_3","name":"$newpat","kind":13,"line":680},{"line":680,"kind":13,"name":"$oldpat","containerName":"_fixpat_3"},{"kind":13,"line":683,"name":"$pat","containerName":"_fixpat_3"},{"name":"$newpat","containerName":"_fixpat_3","line":684,"kind":13},{"line":694,"kind":13,"containerName":"_fixpat_3","name":"$pat"},{"line":694,"kind":13,"containerName":"_fixpat_3","name":"$newpat"},{"name":"$pat","containerName":"_fixpat_3","kind":13,"line":696},{"kind":13,"line":697,"name":"$pat","containerName":"_fixpat_3"},{"line":699,"kind":13,"name":"@done","containerName":"_fixpat_3"},{"containerName":"_fixpat_3","name":"$pat","line":699,"kind":13},{"name":"@parts","containerName":"_fixpat_3","line":701,"kind":13},{"line":701,"kind":13,"name":"$pat","containerName":"_fixpat_3"},{"kind":13,"line":702,"containerName":"_fixpat_3","name":"@done"},{"line":702,"kind":13,"name":"$parts","containerName":"_fixpat_3"},{"name":"$pat","containerName":"_fixpat_3","kind":13,"line":703},{"kind":13,"line":703,"name":"$parts","containerName":"_fixpat_3"},{"line":705,"kind":13,"containerName":"_fixpat_3","name":"$pat"},{"name":"@done","containerName":"_fixpat_3","kind":13,"line":707}],"kind":12},{"line":726,"children":[{"localvar":"my","definition":"my","name":"$pat","containerName":"_fixpat_4","line":728,"kind":13},{"line":730,"kind":13,"localvar":"my","definition":"my","name":"@done","containerName":"_fixpat_4"},{"line":730,"kind":13,"name":"@parts","containerName":"_fixpat_4"},{"containerName":"_fixpat_4","name":"$braces","line":730,"kind":13},{"line":730,"kind":13,"containerName":"_fixpat_4","name":"$newpat"},{"kind":13,"line":730,"name":"$oldpat","containerName":"_fixpat_4"},{"containerName":"_fixpat_4","name":"$pat","kind":13,"line":734},{"containerName":"_fixpat_4","name":"$newpat","kind":13,"line":735},{"containerName":"_fixpat_4","name":"$oldpat","line":736,"kind":13},{"name":"$braces","containerName":"_fixpat_4","kind":13,"line":738},{"name":"$braces","containerName":"_fixpat_4","kind":13,"line":739},{"kind":13,"line":740,"name":"$braces","containerName":"_fixpat_4"},{"containerName":"_fixpat_4","name":"$Processed_braces","kind":13,"line":741},{"containerName":"_fixpat_4","name":"$Processed_asterics","kind":13,"line":741},{"name":"$pat","containerName":"_fixpat_4","kind":13,"line":742},{"kind":13,"line":742,"containerName":"_fixpat_4","name":"$oldpat"},{"line":745,"kind":13,"containerName":"_fixpat_4","name":"$pat"},{"name":"$newpat","containerName":"_fixpat_4","line":745,"kind":13},{"kind":13,"line":748,"containerName":"_fixpat_4","name":"$pat"},{"name":"$pat","containerName":"_fixpat_4","kind":13,"line":749},{"kind":13,"line":751,"name":"@done","containerName":"_fixpat_4"},{"kind":13,"line":751,"name":"$pat","containerName":"_fixpat_4"},{"containerName":"_fixpat_4","name":"@parts","kind":13,"line":754},{"kind":13,"line":754,"containerName":"_fixpat_4","name":"$pat"},{"name":"@done","containerName":"_fixpat_4","line":755,"kind":13},{"line":755,"kind":13,"name":"$parts","containerName":"_fixpat_4"},{"kind":13,"line":756,"name":"$pat","containerName":"_fixpat_4"},{"containerName":"_fixpat_4","name":"$parts","line":756,"kind":13},{"containerName":"_fixpat_4","name":"$pat","line":758,"kind":13},{"containerName":"_fixpat_4","name":"@done","kind":13,"line":760}],"kind":12,"range":{"end":{"line":761,"character":9999},"start":{"line":726,"character":0}},"containerName":"main::","name":"_fixpat_4","definition":"sub"},{"containerName":"main::","definition":"sub","name":"_fixpat_5","range":{"end":{"line":812,"character":9999},"start":{"line":780,"character":0}},"kind":12,"line":780,"children":[{"containerName":"_fixpat_5","definition":"my","name":"$pat","localvar":"my","kind":13,"line":782},{"line":784,"kind":13,"localvar":"my","name":"@done","definition":"my","containerName":"_fixpat_5"},{"name":"@parts","containerName":"_fixpat_5","line":784,"kind":13},{"kind":13,"line":784,"containerName":"_fixpat_5","name":"$newpat"},{"name":"$oldpat","containerName":"_fixpat_5","kind":13,"line":784},{"kind":13,"line":788,"name":"$pat","containerName":"_fixpat_5"},{"containerName":"_fixpat_5","name":"$newpat","line":789,"kind":13},{"kind":13,"line":790,"containerName":"_fixpat_5","name":"$oldpat"},{"line":792,"kind":13,"containerName":"_fixpat_5","name":"$Processed_asterics"},{"name":"$pat","containerName":"_fixpat_5","kind":13,"line":793},{"line":793,"kind":13,"name":"$oldpat","containerName":"_fixpat_5"},{"name":"$pat","containerName":"_fixpat_5","kind":13,"line":796},{"line":796,"kind":13,"name":"$newpat","containerName":"_fixpat_5"},{"containerName":"_fixpat_5","name":"$pat","line":799,"kind":13},{"containerName":"_fixpat_5","name":"$pat","kind":13,"line":800},{"containerName":"_fixpat_5","name":"@done","line":802,"kind":13},{"kind":13,"line":802,"containerName":"_fixpat_5","name":"$pat"},{"line":805,"kind":13,"containerName":"_fixpat_5","name":"@parts"},{"line":805,"kind":13,"name":"$pat","containerName":"_fixpat_5"},{"line":806,"kind":13,"containerName":"_fixpat_5","name":"@done"},{"containerName":"_fixpat_5","name":"$parts","kind":13,"line":806},{"kind":13,"line":807,"name":"$pat","containerName":"_fixpat_5"},{"name":"$parts","containerName":"_fixpat_5","kind":13,"line":807},{"kind":13,"line":809,"name":"$pat","containerName":"_fixpat_5"},{"containerName":"_fixpat_5","name":"@done","line":811,"kind":13}]},{"kind":12,"children":[{"kind":13,"line":843,"containerName":"_fixpat_6","name":"$pat","definition":"my","localvar":"my"},{"kind":13,"line":844,"name":"@done","definition":"my","containerName":"_fixpat_6","localvar":"my"},{"name":"@parts","containerName":"_fixpat_6","kind":13,"line":844},{"name":"@done","containerName":"_fixpat_6","line":846,"kind":13},{"containerName":"_fixpat_6","name":"$pat","kind":13,"line":848},{"kind":13,"line":848,"containerName":"_fixpat_6","name":"@done"},{"name":"$pat","containerName":"_fixpat_6","kind":13,"line":848},{"definition":"my","name":"$quantifier","containerName":"_fixpat_6","localvar":"my","kind":13,"line":849},{"line":850,"kind":13,"containerName":"_fixpat_6","name":"$pat"},{"line":850,"kind":13,"name":"$quantifier","containerName":"_fixpat_6"},{"kind":13,"line":855,"containerName":"_fixpat_6","name":"@parts"},{"line":855,"kind":13,"name":"$pat","containerName":"_fixpat_6"},{"kind":13,"line":856,"name":"@done","containerName":"_fixpat_6"},{"containerName":"_fixpat_6","name":"$parts","kind":13,"line":856},{"name":"$pat","containerName":"_fixpat_6","line":857,"kind":13},{"name":"$parts","containerName":"_fixpat_6","kind":13,"line":857},{"line":859,"kind":13,"name":"$pat","containerName":"_fixpat_6"},{"kind":13,"line":861,"containerName":"_fixpat_6","name":"@done"}],"line":841,"definition":"sub","name":"_fixpat_6","containerName":"main::","range":{"end":{"line":863,"character":9999},"start":{"line":841,"character":0}}},{"children":[{"line":877,"kind":13,"localvar":"my","name":"$obj","definition":"my","containerName":"str"},{"line":879,"kind":13,"localvar":"my","name":"$value","definition":"my","containerName":"str"},{"containerName":"str","name":"$obj","kind":13,"line":880},{"containerName":"str","name":"$value","kind":13,"line":880},{"name":"$obj","containerName":"str","line":882,"kind":13}],"line":876,"kind":12,"range":{"start":{"character":0,"line":876},"end":{"line":884,"character":9999}},"name":"str","definition":"sub","containerName":"main::"},{"definition":"sub","name":"type","containerName":"main::","range":{"end":{"line":905,"character":9999},"start":{"character":0,"line":897}},"kind":12,"children":[{"kind":13,"line":898,"containerName":"type","definition":"my","name":"$obj","localvar":"my"},{"name":"$value","definition":"my","containerName":"type","localvar":"my","kind":13,"line":900},{"kind":13,"line":901,"name":"$obj","containerName":"type"},{"containerName":"type","name":"$value","line":901,"kind":13},{"name":"$obj","containerName":"type","line":903,"kind":13}],"line":897}],"version":5}