{"vars":[{"line":92,"kind":2,"name":"base","containerName":""},{"name":"Path","containerName":"File::Spec::File","line":95,"kind":2},{"name":"run","range":{"start":{"character":0,"line":109},"end":{"line":112,"character":9999}},"kind":12,"line":109,"children":[{"name":"$self","definition":"my","containerName":"run","localvar":"my","kind":13,"line":110},{"name":"@args","containerName":"run","kind":13,"line":110},{"line":111,"kind":13,"containerName":"run","name":"$self"},{"name":"throw_not_implemented","containerName":"run","kind":12,"line":111}],"containerName":"main::","definition":"sub","detail":"($self,@args)","signature":{"documentation":"1;\n# $Id: WrapperBase.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Run::WrapperBase\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Run::WrapperBase - A Base object for wrappers around executables\n\n=head1 SYNOPSIS\n\n  # do not use this object directly, it provides the following methods\n  # for its subclasses\n\n  my $errstr = $obj->error_string();\n  my $exe    = $obj->executable();\n  $obj->save_tempfiles($booleanflag)\n  my $outfile= $obj->outfile_name();\n  my $tempdir= $obj->tempdir(); # get a temporary dir for executing\n  my $io     = $obj->io;  # Bio::Root::IO object\n  my $cleanup= $obj->cleanup(); # remove tempfiles\n\n  $obj->run({-arg1 => $value});\n\n=head1 DESCRIPTION\n\nThis is a basic module from which to build executable wrapper modules.\nIt has some basic methods to help when implementing new modules.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track of\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Run::WrapperBase;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse base qw(Bio::Root::Root);\n\nuse File::Spec;\nuse File::Path qw(); # don't import anything\n\n=head2 run\n\n Title   : run\n Usage   : $wrapper->run({ARGS HERE});\n Function: Support generic running with args passed in\n           as a hashref\n Returns : Depends on the implementation, status OR data\n Args    : hashref of named arguments","parameters":[{"label":"$self"},{"label":"@args"}],"label":"run($self,@args)"}},{"kind":12,"line":126,"children":[{"line":127,"kind":13,"localvar":"my","containerName":"error_string","definition":"my","name":"$self"},{"containerName":"error_string","name":"$value","line":127,"kind":13},{"name":"$value","containerName":"error_string","kind":13,"line":128},{"line":129,"kind":13,"name":"$self","containerName":"error_string"},{"name":"$value","containerName":"error_string","kind":13,"line":129},{"containerName":"error_string","name":"$self","line":131,"kind":13}],"containerName":"main::","definition":"sub","detail":"($self,$value)","signature":{"label":"error_string($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: WrapperBase.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Run::WrapperBase\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Run::WrapperBase - A Base object for wrappers around executables\n\n=head1 SYNOPSIS\n\n  # do not use this object directly, it provides the following methods\n  # for its subclasses\n\n  my $errstr = $obj->error_string();\n  my $exe    = $obj->executable();\n  $obj->save_tempfiles($booleanflag)\n  my $outfile= $obj->outfile_name();\n  my $tempdir= $obj->tempdir(); # get a temporary dir for executing\n  my $io     = $obj->io;  # Bio::Root::IO object\n  my $cleanup= $obj->cleanup(); # remove tempfiles\n\n  $obj->run({-arg1 => $value});\n\n=head1 DESCRIPTION\n\nThis is a basic module from which to build executable wrapper modules.\nIt has some basic methods to help when implementing new modules.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track of\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Run::WrapperBase;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse base qw(Bio::Root::Root);\n\nuse File::Spec;\nuse File::Path qw(); # don't import anything\n\n=head2 run\n\n Title   : run\n Usage   : $wrapper->run({ARGS HERE});\n Function: Support generic running with args passed in\n           as a hashref\n Returns : Depends on the implementation, status OR data\n Args    : hashref of named arguments\n\n\n\nsub run {\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 error_string\n\n Title   : error_string\n Usage   : $obj->error_string($newval)\n Function: Where the output from the last analysis run is stored.\n Returns : value of error_string\n Args    : newvalue (optional)"},"name":"error_string","range":{"end":{"character":9999,"line":132},"start":{"character":0,"line":126}}},{"name":"arguments","range":{"start":{"character":0,"line":145},"end":{"character":9999,"line":151}},"kind":12,"line":145,"children":[{"definition":"my","name":"$self","containerName":"arguments","localvar":"my","kind":13,"line":146},{"kind":13,"line":146,"containerName":"arguments","name":"$value"},{"kind":13,"line":147,"name":"$value","containerName":"arguments"},{"name":"$self","containerName":"arguments","kind":13,"line":148},{"line":148,"kind":13,"containerName":"arguments","name":"$value"},{"containerName":"arguments","name":"$self","line":150,"kind":13}],"containerName":"main::","definition":"sub","detail":"($self,$value)","signature":{"label":"arguments($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: WrapperBase.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Run::WrapperBase\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Run::WrapperBase - A Base object for wrappers around executables\n\n=head1 SYNOPSIS\n\n  # do not use this object directly, it provides the following methods\n  # for its subclasses\n\n  my $errstr = $obj->error_string();\n  my $exe    = $obj->executable();\n  $obj->save_tempfiles($booleanflag)\n  my $outfile= $obj->outfile_name();\n  my $tempdir= $obj->tempdir(); # get a temporary dir for executing\n  my $io     = $obj->io;  # Bio::Root::IO object\n  my $cleanup= $obj->cleanup(); # remove tempfiles\n\n  $obj->run({-arg1 => $value});\n\n=head1 DESCRIPTION\n\nThis is a basic module from which to build executable wrapper modules.\nIt has some basic methods to help when implementing new modules.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track of\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Run::WrapperBase;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse base qw(Bio::Root::Root);\n\nuse File::Spec;\nuse File::Path qw(); # don't import anything\n\n=head2 run\n\n Title   : run\n Usage   : $wrapper->run({ARGS HERE});\n Function: Support generic running with args passed in\n           as a hashref\n Returns : Depends on the implementation, status OR data\n Args    : hashref of named arguments\n\n\n\nsub run {\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 error_string\n\n Title   : error_string\n Usage   : $obj->error_string($newval)\n Function: Where the output from the last analysis run is stored.\n Returns : value of error_string\n Args    : newvalue (optional)\n\n\n\nsub error_string{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'_error_string'} = $value;\n    }\n    return $self->{'_error_string'} || '';\n}\n\n=head2 arguments\n\n Title   : arguments\n Usage   : $obj->arguments($newval)\n Function: Commandline parameters \n Returns : value of arguments\n Args    : newvalue (optional)"}},{"line":166,"children":[{"kind":13,"line":167,"definition":"my","name":"$self","containerName":"no_param_checks","localvar":"my"},{"kind":13,"line":167,"containerName":"no_param_checks","name":"$value"},{"name":"$value","containerName":"no_param_checks","kind":13,"line":168},{"containerName":"no_param_checks","name":"$self","kind":13,"line":168},{"name":"$value","containerName":"no_param_checks","kind":13,"line":169},{"containerName":"no_param_checks","name":"$value","line":169,"kind":13},{"name":"$self","containerName":"no_param_checks","line":170,"kind":13},{"containerName":"no_param_checks","name":"$value","line":170,"kind":13},{"name":"$self","containerName":"no_param_checks","kind":13,"line":172}],"kind":12,"detail":"($self,$value)","signature":{"documentation":"1;\n# $Id: WrapperBase.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Run::WrapperBase\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Run::WrapperBase - A Base object for wrappers around executables\n\n=head1 SYNOPSIS\n\n  # do not use this object directly, it provides the following methods\n  # for its subclasses\n\n  my $errstr = $obj->error_string();\n  my $exe    = $obj->executable();\n  $obj->save_tempfiles($booleanflag)\n  my $outfile= $obj->outfile_name();\n  my $tempdir= $obj->tempdir(); # get a temporary dir for executing\n  my $io     = $obj->io;  # Bio::Root::IO object\n  my $cleanup= $obj->cleanup(); # remove tempfiles\n\n  $obj->run({-arg1 => $value});\n\n=head1 DESCRIPTION\n\nThis is a basic module from which to build executable wrapper modules.\nIt has some basic methods to help when implementing new modules.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track of\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Run::WrapperBase;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse base qw(Bio::Root::Root);\n\nuse File::Spec;\nuse File::Path qw(); # don't import anything\n\n=head2 run\n\n Title   : run\n Usage   : $wrapper->run({ARGS HERE});\n Function: Support generic running with args passed in\n           as a hashref\n Returns : Depends on the implementation, status OR data\n Args    : hashref of named arguments\n\n\n\nsub run {\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 error_string\n\n Title   : error_string\n Usage   : $obj->error_string($newval)\n Function: Where the output from the last analysis run is stored.\n Returns : value of error_string\n Args    : newvalue (optional)\n\n\n\nsub error_string{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'_error_string'} = $value;\n    }\n    return $self->{'_error_string'} || '';\n}\n\n=head2 arguments\n\n Title   : arguments\n Usage   : $obj->arguments($newval)\n Function: Commandline parameters \n Returns : value of arguments\n Args    : newvalue (optional)\n\n\n\nsub arguments {\n  my ($self,$value) = @_;\n  if(defined $value) {\n    $self->{'_arguments'} = $value;\n  }\n  return $self->{'_arguments'} || '';\n}\n\n\n=head2 no_param_checks\n\n Title   : no_param_checks\n Usage   : $obj->no_param_checks($newval)\n Function: Boolean flag as to whether or not we should\n           trust the sanity checks for parameter values\n Returns : value of no_param_checks\n Args    : newvalue (optional)","parameters":[{"label":"$self"},{"label":"$value"}],"label":"no_param_checks($self,$value)"},"containerName":"main::","definition":"sub","range":{"end":{"line":173,"character":9999},"start":{"line":166,"character":0}},"name":"no_param_checks"},{"containerName":"main::","name":"save_tempfiles","definition":"sub","range":{"end":{"line":191,"character":9999},"start":{"line":188,"character":0}},"kind":12,"line":188,"children":[{"localvar":"my","containerName":"save_tempfiles","name":"$self","definition":"my","line":189,"kind":13},{"kind":13,"line":190,"name":"$self","containerName":"save_tempfiles"},{"line":190,"kind":12,"name":"io","containerName":"save_tempfiles"},{"line":190,"kind":12,"name":"save_tempfiles","containerName":"save_tempfiles"}]},{"line":205,"children":[{"kind":13,"line":206,"name":"$self","definition":"my","containerName":"outfile_name","localvar":"my"},{"containerName":"outfile_name","name":"$nm","line":206,"kind":13},{"kind":13,"line":207,"containerName":"outfile_name","name":"$nm"},{"containerName":"outfile_name","name":"$self","line":207,"kind":13},{"kind":13,"line":208,"name":"$nm","containerName":"outfile_name"},{"kind":13,"line":208,"name":"$nm","containerName":"outfile_name"},{"line":209,"kind":13,"containerName":"outfile_name","name":"$self"},{"name":"$nm","containerName":"outfile_name","kind":13,"line":209},{"kind":13,"line":211,"name":"$self","containerName":"outfile_name"}],"kind":12,"detail":"($self,$nm)","signature":{"parameters":[{"label":"$self"},{"label":"$nm"}],"documentation":"1;\n# $Id: WrapperBase.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Run::WrapperBase\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Run::WrapperBase - A Base object for wrappers around executables\n\n=head1 SYNOPSIS\n\n  # do not use this object directly, it provides the following methods\n  # for its subclasses\n\n  my $errstr = $obj->error_string();\n  my $exe    = $obj->executable();\n  $obj->save_tempfiles($booleanflag)\n  my $outfile= $obj->outfile_name();\n  my $tempdir= $obj->tempdir(); # get a temporary dir for executing\n  my $io     = $obj->io;  # Bio::Root::IO object\n  my $cleanup= $obj->cleanup(); # remove tempfiles\n\n  $obj->run({-arg1 => $value});\n\n=head1 DESCRIPTION\n\nThis is a basic module from which to build executable wrapper modules.\nIt has some basic methods to help when implementing new modules.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track of\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Run::WrapperBase;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse base qw(Bio::Root::Root);\n\nuse File::Spec;\nuse File::Path qw(); # don't import anything\n\n=head2 run\n\n Title   : run\n Usage   : $wrapper->run({ARGS HERE});\n Function: Support generic running with args passed in\n           as a hashref\n Returns : Depends on the implementation, status OR data\n Args    : hashref of named arguments\n\n\n\nsub run {\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 error_string\n\n Title   : error_string\n Usage   : $obj->error_string($newval)\n Function: Where the output from the last analysis run is stored.\n Returns : value of error_string\n Args    : newvalue (optional)\n\n\n\nsub error_string{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'_error_string'} = $value;\n    }\n    return $self->{'_error_string'} || '';\n}\n\n=head2 arguments\n\n Title   : arguments\n Usage   : $obj->arguments($newval)\n Function: Commandline parameters \n Returns : value of arguments\n Args    : newvalue (optional)\n\n\n\nsub arguments {\n  my ($self,$value) = @_;\n  if(defined $value) {\n    $self->{'_arguments'} = $value;\n  }\n  return $self->{'_arguments'} || '';\n}\n\n\n=head2 no_param_checks\n\n Title   : no_param_checks\n Usage   : $obj->no_param_checks($newval)\n Function: Boolean flag as to whether or not we should\n           trust the sanity checks for parameter values\n Returns : value of no_param_checks\n Args    : newvalue (optional)\n\n\n\nsub no_param_checks{\n   my ($self,$value) = @_;\n   if( defined $value || ! defined $self->{'no_param_checks'} ) {\n       $value = 0 unless defined $value;\n      $self->{'no_param_checks'} = $value;\n    }\n    return $self->{'no_param_checks'};\n}\n\n=head2 save_tempfiles\n\n Title   : save_tempfiles\n Usage   : $obj->save_tempfiles($newval)\n Function: Get/set the choice of if tempfiles in the temp dir (see tempdir())\n           are kept or cleaned up. Default is '0', ie. delete temp files.\n           NB:\u00caThis must be set to the desired value PRIOR to first creating\n           a temp dir with tempdir().\n Returns : boolean\n Args    : none to get, boolean to set\n\n\nsub save_tempfiles{\n    my $self = shift;\n    return $self->io->save_tempfiles(@_);\n}\n\n=head2 outfile_name\n\n Title   : outfile_name\n Usage   : my $outfile = $wrapper->outfile_name();\n Function: Get/Set the name of the output file for this run\n           (if you wanted to do something special)\n Returns : string\n Args    : [optional] string to set value to","label":"outfile_name($self,$nm)"},"containerName":"main::","definition":"sub","range":{"end":{"line":212,"character":9999},"start":{"line":205,"character":0}},"name":"outfile_name"},{"line":226,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"tempdir","line":227,"kind":13},{"containerName":"tempdir","name":"$self","kind":13,"line":229},{"containerName":"tempdir","name":"$self","kind":13,"line":230},{"containerName":"tempdir","name":"$self","line":231,"kind":13},{"name":"$self","containerName":"tempdir","line":231,"kind":13},{"kind":12,"line":231,"name":"io","containerName":"tempdir"},{"line":231,"kind":12,"name":"tempdir","containerName":"tempdir"},{"name":"$self","containerName":"tempdir","kind":13,"line":231},{"line":231,"kind":12,"containerName":"tempdir","name":"save_tempfiles"},{"kind":13,"line":233,"containerName":"tempdir","name":"$self"},{"line":234,"kind":13,"containerName":"tempdir","name":"$self"},{"kind":13,"line":236,"containerName":"tempdir","name":"$self"}],"kind":12,"range":{"end":{"line":237,"character":9999},"start":{"line":226,"character":0}},"containerName":"main::","name":"tempdir","definition":"sub"},{"name":"CLEANUP","kind":12,"line":231},{"range":{"start":{"line":250,"character":0},"end":{"line":257,"character":9999}},"name":"cleanup","children":[{"kind":13,"line":251,"containerName":"cleanup","definition":"my","name":"$self","localvar":"my"},{"line":252,"kind":13,"name":"$self","containerName":"cleanup"},{"kind":12,"line":252,"containerName":"cleanup","name":"io"},{"kind":12,"line":252,"name":"_io_cleanup","containerName":"cleanup"},{"kind":13,"line":253,"containerName":"cleanup","name":"$self"},{"name":"$self","containerName":"cleanup","line":253,"kind":13},{"localvar":"my","containerName":"cleanup","name":"$verbose","definition":"my","line":254,"kind":13},{"name":"$self","containerName":"cleanup","kind":13,"line":254},{"kind":12,"line":254,"name":"verbose","containerName":"cleanup"},{"containerName":"cleanup","name":"$self","line":255,"kind":13},{"kind":13,"line":255,"name":"$verbose","containerName":"cleanup"}],"line":250,"kind":12,"signature":{"documentation":"1;\n# $Id: WrapperBase.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Run::WrapperBase\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Run::WrapperBase - A Base object for wrappers around executables\n\n=head1 SYNOPSIS\n\n  # do not use this object directly, it provides the following methods\n  # for its subclasses\n\n  my $errstr = $obj->error_string();\n  my $exe    = $obj->executable();\n  $obj->save_tempfiles($booleanflag)\n  my $outfile= $obj->outfile_name();\n  my $tempdir= $obj->tempdir(); # get a temporary dir for executing\n  my $io     = $obj->io;  # Bio::Root::IO object\n  my $cleanup= $obj->cleanup(); # remove tempfiles\n\n  $obj->run({-arg1 => $value});\n\n=head1 DESCRIPTION\n\nThis is a basic module from which to build executable wrapper modules.\nIt has some basic methods to help when implementing new modules.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track of\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Run::WrapperBase;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse base qw(Bio::Root::Root);\n\nuse File::Spec;\nuse File::Path qw(); # don't import anything\n\n=head2 run\n\n Title   : run\n Usage   : $wrapper->run({ARGS HERE});\n Function: Support generic running with args passed in\n           as a hashref\n Returns : Depends on the implementation, status OR data\n Args    : hashref of named arguments\n\n\n\nsub run {\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 error_string\n\n Title   : error_string\n Usage   : $obj->error_string($newval)\n Function: Where the output from the last analysis run is stored.\n Returns : value of error_string\n Args    : newvalue (optional)\n\n\n\nsub error_string{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'_error_string'} = $value;\n    }\n    return $self->{'_error_string'} || '';\n}\n\n=head2 arguments\n\n Title   : arguments\n Usage   : $obj->arguments($newval)\n Function: Commandline parameters \n Returns : value of arguments\n Args    : newvalue (optional)\n\n\n\nsub arguments {\n  my ($self,$value) = @_;\n  if(defined $value) {\n    $self->{'_arguments'} = $value;\n  }\n  return $self->{'_arguments'} || '';\n}\n\n\n=head2 no_param_checks\n\n Title   : no_param_checks\n Usage   : $obj->no_param_checks($newval)\n Function: Boolean flag as to whether or not we should\n           trust the sanity checks for parameter values\n Returns : value of no_param_checks\n Args    : newvalue (optional)\n\n\n\nsub no_param_checks{\n   my ($self,$value) = @_;\n   if( defined $value || ! defined $self->{'no_param_checks'} ) {\n       $value = 0 unless defined $value;\n      $self->{'no_param_checks'} = $value;\n    }\n    return $self->{'no_param_checks'};\n}\n\n=head2 save_tempfiles\n\n Title   : save_tempfiles\n Usage   : $obj->save_tempfiles($newval)\n Function: Get/set the choice of if tempfiles in the temp dir (see tempdir())\n           are kept or cleaned up. Default is '0', ie. delete temp files.\n           NB:\u00caThis must be set to the desired value PRIOR to first creating\n           a temp dir with tempdir().\n Returns : boolean\n Args    : none to get, boolean to set\n\n\nsub save_tempfiles{\n    my $self = shift;\n    return $self->io->save_tempfiles(@_);\n}\n\n=head2 outfile_name\n\n Title   : outfile_name\n Usage   : my $outfile = $wrapper->outfile_name();\n Function: Get/Set the name of the output file for this run\n           (if you wanted to do something special)\n Returns : string\n Args    : [optional] string to set value to\n\n\n\nsub outfile_name{\n   my ($self,$nm) = @_;\n   if( defined $nm || ! defined $self->{'_outfilename'} ) { \n       $nm = 'mlc' unless defined $nm;\n       $self->{'_outfilename'} = $nm;\n   }\n   return $self->{'_outfilename'};\n}\n\n\n=head2 tempdir\n\n Title   : tempdir\n Usage   : my $tmpdir = $self->tempdir();\n Function: Retrieve a temporary directory name (which is created)\n Returns : string which is the name of the temporary directory\n Args    : none\n\n\n\nsub tempdir{\n   my ($self) = shift;\n\n   $self->{'_tmpdir'} = shift if @_;\n   unless( $self->{'_tmpdir'} ) {\n       $self->{'_tmpdir'} = $self->io->tempdir(CLEANUP => ! $self->save_tempfiles );\n   }\n   unless( -d $self->{'_tmpdir'} ) {\n       mkdir($self->{'_tmpdir'},0777);\n   }\n   return $self->{'_tmpdir'};\n}\n\n=head2 cleanup\n\n Title   : cleanup\n Usage   : $wrapper->cleanup();\n Function: Will cleanup the tempdir directory\n Returns : none\n Args    : none","parameters":[{"label":"$self"}],"label":"cleanup($self)"},"detail":"($self)","definition":"sub","containerName":"main::"},{"kind":12,"line":255,"containerName":"Path::rmtree","name":"File"},{"name":"io","range":{"start":{"line":270,"character":0},"end":{"line":276,"character":9999}},"kind":12,"line":270,"children":[{"localvar":"my","containerName":"io","name":"$self","definition":"my","line":271,"kind":13},{"line":272,"kind":13,"name":"$self","containerName":"io"},{"containerName":"io","name":"$self","line":273,"kind":13},{"kind":12,"line":273,"containerName":"io","name":"new"},{"line":273,"kind":13,"name":"$self","containerName":"io"},{"name":"verbose","containerName":"io","kind":12,"line":273},{"containerName":"io","name":"$self","line":275,"kind":13}],"containerName":"main::","definition":"sub","detail":"($self)","signature":{"documentation":"1;\n# $Id: WrapperBase.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Run::WrapperBase\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Run::WrapperBase - A Base object for wrappers around executables\n\n=head1 SYNOPSIS\n\n  # do not use this object directly, it provides the following methods\n  # for its subclasses\n\n  my $errstr = $obj->error_string();\n  my $exe    = $obj->executable();\n  $obj->save_tempfiles($booleanflag)\n  my $outfile= $obj->outfile_name();\n  my $tempdir= $obj->tempdir(); # get a temporary dir for executing\n  my $io     = $obj->io;  # Bio::Root::IO object\n  my $cleanup= $obj->cleanup(); # remove tempfiles\n\n  $obj->run({-arg1 => $value});\n\n=head1 DESCRIPTION\n\nThis is a basic module from which to build executable wrapper modules.\nIt has some basic methods to help when implementing new modules.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track of\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Run::WrapperBase;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse base qw(Bio::Root::Root);\n\nuse File::Spec;\nuse File::Path qw(); # don't import anything\n\n=head2 run\n\n Title   : run\n Usage   : $wrapper->run({ARGS HERE});\n Function: Support generic running with args passed in\n           as a hashref\n Returns : Depends on the implementation, status OR data\n Args    : hashref of named arguments\n\n\n\nsub run {\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 error_string\n\n Title   : error_string\n Usage   : $obj->error_string($newval)\n Function: Where the output from the last analysis run is stored.\n Returns : value of error_string\n Args    : newvalue (optional)\n\n\n\nsub error_string{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'_error_string'} = $value;\n    }\n    return $self->{'_error_string'} || '';\n}\n\n=head2 arguments\n\n Title   : arguments\n Usage   : $obj->arguments($newval)\n Function: Commandline parameters \n Returns : value of arguments\n Args    : newvalue (optional)\n\n\n\nsub arguments {\n  my ($self,$value) = @_;\n  if(defined $value) {\n    $self->{'_arguments'} = $value;\n  }\n  return $self->{'_arguments'} || '';\n}\n\n\n=head2 no_param_checks\n\n Title   : no_param_checks\n Usage   : $obj->no_param_checks($newval)\n Function: Boolean flag as to whether or not we should\n           trust the sanity checks for parameter values\n Returns : value of no_param_checks\n Args    : newvalue (optional)\n\n\n\nsub no_param_checks{\n   my ($self,$value) = @_;\n   if( defined $value || ! defined $self->{'no_param_checks'} ) {\n       $value = 0 unless defined $value;\n      $self->{'no_param_checks'} = $value;\n    }\n    return $self->{'no_param_checks'};\n}\n\n=head2 save_tempfiles\n\n Title   : save_tempfiles\n Usage   : $obj->save_tempfiles($newval)\n Function: Get/set the choice of if tempfiles in the temp dir (see tempdir())\n           are kept or cleaned up. Default is '0', ie. delete temp files.\n           NB:\u00caThis must be set to the desired value PRIOR to first creating\n           a temp dir with tempdir().\n Returns : boolean\n Args    : none to get, boolean to set\n\n\nsub save_tempfiles{\n    my $self = shift;\n    return $self->io->save_tempfiles(@_);\n}\n\n=head2 outfile_name\n\n Title   : outfile_name\n Usage   : my $outfile = $wrapper->outfile_name();\n Function: Get/Set the name of the output file for this run\n           (if you wanted to do something special)\n Returns : string\n Args    : [optional] string to set value to\n\n\n\nsub outfile_name{\n   my ($self,$nm) = @_;\n   if( defined $nm || ! defined $self->{'_outfilename'} ) { \n       $nm = 'mlc' unless defined $nm;\n       $self->{'_outfilename'} = $nm;\n   }\n   return $self->{'_outfilename'};\n}\n\n\n=head2 tempdir\n\n Title   : tempdir\n Usage   : my $tmpdir = $self->tempdir();\n Function: Retrieve a temporary directory name (which is created)\n Returns : string which is the name of the temporary directory\n Args    : none\n\n\n\nsub tempdir{\n   my ($self) = shift;\n\n   $self->{'_tmpdir'} = shift if @_;\n   unless( $self->{'_tmpdir'} ) {\n       $self->{'_tmpdir'} = $self->io->tempdir(CLEANUP => ! $self->save_tempfiles );\n   }\n   unless( -d $self->{'_tmpdir'} ) {\n       mkdir($self->{'_tmpdir'},0777);\n   }\n   return $self->{'_tmpdir'};\n}\n\n=head2 cleanup\n\n Title   : cleanup\n Usage   : $wrapper->cleanup();\n Function: Will cleanup the tempdir directory\n Returns : none\n Args    : none\n\n\n\nsub cleanup{\n   my ($self) = @_;\n   $self->io->_io_cleanup();\n   if( defined $self->{'_tmpdir'} && -d $self->{'_tmpdir'} ) {\n      my $verbose = ($self->verbose >= 1) ? 1 : 0;\n      File::Path::rmtree( $self->{'_tmpdir'}, $verbose);\n   }\n}\n\n=head2 io\n\n Title   : io\n Usage   : $obj->io($newval)\n Function: Gets a Bio::Root::IO object\n Returns : Bio::Root::IO object\n Args    : none","parameters":[{"label":"$self"}],"label":"io($self)"}},{"name":"Bio","containerName":"Root::IO","kind":12,"line":273},{"name":"version","range":{"end":{"line":292,"character":9999},"start":{"line":289,"character":0}},"containerName":"main::","definition":"sub","detail":"($self,@args)","signature":{"label":"version($self,@args)","documentation":"1;\n# $Id: WrapperBase.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Run::WrapperBase\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Run::WrapperBase - A Base object for wrappers around executables\n\n=head1 SYNOPSIS\n\n  # do not use this object directly, it provides the following methods\n  # for its subclasses\n\n  my $errstr = $obj->error_string();\n  my $exe    = $obj->executable();\n  $obj->save_tempfiles($booleanflag)\n  my $outfile= $obj->outfile_name();\n  my $tempdir= $obj->tempdir(); # get a temporary dir for executing\n  my $io     = $obj->io;  # Bio::Root::IO object\n  my $cleanup= $obj->cleanup(); # remove tempfiles\n\n  $obj->run({-arg1 => $value});\n\n=head1 DESCRIPTION\n\nThis is a basic module from which to build executable wrapper modules.\nIt has some basic methods to help when implementing new modules.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track of\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Run::WrapperBase;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse base qw(Bio::Root::Root);\n\nuse File::Spec;\nuse File::Path qw(); # don't import anything\n\n=head2 run\n\n Title   : run\n Usage   : $wrapper->run({ARGS HERE});\n Function: Support generic running with args passed in\n           as a hashref\n Returns : Depends on the implementation, status OR data\n Args    : hashref of named arguments\n\n\n\nsub run {\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 error_string\n\n Title   : error_string\n Usage   : $obj->error_string($newval)\n Function: Where the output from the last analysis run is stored.\n Returns : value of error_string\n Args    : newvalue (optional)\n\n\n\nsub error_string{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'_error_string'} = $value;\n    }\n    return $self->{'_error_string'} || '';\n}\n\n=head2 arguments\n\n Title   : arguments\n Usage   : $obj->arguments($newval)\n Function: Commandline parameters \n Returns : value of arguments\n Args    : newvalue (optional)\n\n\n\nsub arguments {\n  my ($self,$value) = @_;\n  if(defined $value) {\n    $self->{'_arguments'} = $value;\n  }\n  return $self->{'_arguments'} || '';\n}\n\n\n=head2 no_param_checks\n\n Title   : no_param_checks\n Usage   : $obj->no_param_checks($newval)\n Function: Boolean flag as to whether or not we should\n           trust the sanity checks for parameter values\n Returns : value of no_param_checks\n Args    : newvalue (optional)\n\n\n\nsub no_param_checks{\n   my ($self,$value) = @_;\n   if( defined $value || ! defined $self->{'no_param_checks'} ) {\n       $value = 0 unless defined $value;\n      $self->{'no_param_checks'} = $value;\n    }\n    return $self->{'no_param_checks'};\n}\n\n=head2 save_tempfiles\n\n Title   : save_tempfiles\n Usage   : $obj->save_tempfiles($newval)\n Function: Get/set the choice of if tempfiles in the temp dir (see tempdir())\n           are kept or cleaned up. Default is '0', ie. delete temp files.\n           NB:\u00caThis must be set to the desired value PRIOR to first creating\n           a temp dir with tempdir().\n Returns : boolean\n Args    : none to get, boolean to set\n\n\nsub save_tempfiles{\n    my $self = shift;\n    return $self->io->save_tempfiles(@_);\n}\n\n=head2 outfile_name\n\n Title   : outfile_name\n Usage   : my $outfile = $wrapper->outfile_name();\n Function: Get/Set the name of the output file for this run\n           (if you wanted to do something special)\n Returns : string\n Args    : [optional] string to set value to\n\n\n\nsub outfile_name{\n   my ($self,$nm) = @_;\n   if( defined $nm || ! defined $self->{'_outfilename'} ) { \n       $nm = 'mlc' unless defined $nm;\n       $self->{'_outfilename'} = $nm;\n   }\n   return $self->{'_outfilename'};\n}\n\n\n=head2 tempdir\n\n Title   : tempdir\n Usage   : my $tmpdir = $self->tempdir();\n Function: Retrieve a temporary directory name (which is created)\n Returns : string which is the name of the temporary directory\n Args    : none\n\n\n\nsub tempdir{\n   my ($self) = shift;\n\n   $self->{'_tmpdir'} = shift if @_;\n   unless( $self->{'_tmpdir'} ) {\n       $self->{'_tmpdir'} = $self->io->tempdir(CLEANUP => ! $self->save_tempfiles );\n   }\n   unless( -d $self->{'_tmpdir'} ) {\n       mkdir($self->{'_tmpdir'},0777);\n   }\n   return $self->{'_tmpdir'};\n}\n\n=head2 cleanup\n\n Title   : cleanup\n Usage   : $wrapper->cleanup();\n Function: Will cleanup the tempdir directory\n Returns : none\n Args    : none\n\n\n\nsub cleanup{\n   my ($self) = @_;\n   $self->io->_io_cleanup();\n   if( defined $self->{'_tmpdir'} && -d $self->{'_tmpdir'} ) {\n      my $verbose = ($self->verbose >= 1) ? 1 : 0;\n      File::Path::rmtree( $self->{'_tmpdir'}, $verbose);\n   }\n}\n\n=head2 io\n\n Title   : io\n Usage   : $obj->io($newval)\n Function: Gets a Bio::Root::IO object\n Returns : Bio::Root::IO object\n Args    : none\n\n\n\nsub io{\n   my ($self) = @_;\n   unless( defined $self->{'io'} ) {\n       $self->{'io'} = Bio::Root::IO->new(-verbose => $self->verbose);\n   }\n    return $self->{'io'};\n}\n\n=head2 version\n\n Title   : version\n Usage   : $version = $wrapper->version()\n Function: Returns the program version (if available)\n Returns : string representing version of the program \n Args    : [Optional] value to (re)set version string","parameters":[{"label":"$self"},{"label":"@args"}]},"kind":12,"line":289,"children":[{"line":290,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"version"},{"name":"@args","containerName":"version","kind":13,"line":290}]},{"children":[{"line":306,"kind":13,"localvar":"my","containerName":"executable","definition":"my","name":"$self"},{"kind":13,"line":306,"containerName":"executable","name":"$exe"},{"containerName":"executable","name":"$warn","line":306,"kind":13},{"kind":13,"line":308,"name":"$exe","containerName":"executable"},{"containerName":"executable","name":"$self","kind":13,"line":309},{"containerName":"executable","name":"$exe","kind":13,"line":309},{"containerName":"executable","name":"$self","kind":13,"line":312},{"localvar":"my","definition":"my","name":"$prog_path","containerName":"executable","line":313,"kind":13},{"line":313,"kind":13,"containerName":"executable","name":"$self"},{"name":"program_path","containerName":"executable","kind":12,"line":313},{"line":315,"kind":13,"containerName":"executable","name":"$prog_path"},{"name":"$prog_path","containerName":"executable","line":316,"kind":13},{"containerName":"executable","name":"$prog_path","line":316,"kind":13},{"containerName":"executable","name":"$self","line":317,"kind":13},{"containerName":"executable","name":"$prog_path","line":317,"kind":13},{"kind":13,"line":319,"containerName":"executable","name":"$self"},{"containerName":"executable","name":"program_dir","kind":12,"line":319},{"containerName":"executable","name":"$self","line":320,"kind":13},{"containerName":"executable","name":"warn","kind":12,"line":320},{"kind":13,"line":320,"name":"$warn","containerName":"executable"},{"kind":13,"line":323,"name":"$self","containerName":"executable"},{"kind":13,"line":324,"containerName":"executable","name":"$exe","definition":"my","localvar":"my"},{"kind":13,"line":325,"containerName":"executable","name":"$exe"},{"name":"$self","containerName":"executable","kind":13,"line":325},{"containerName":"executable","name":"io","line":325,"kind":12},{"line":325,"kind":12,"name":"exists_exe","containerName":"executable"},{"name":"$self","containerName":"executable","kind":13,"line":325},{"containerName":"executable","name":"program_name","line":325,"kind":12},{"line":325,"kind":13,"name":"$exe","containerName":"executable"},{"name":"$self","containerName":"executable","line":326,"kind":13},{"name":"$exe","containerName":"executable","kind":13,"line":326},{"line":329,"kind":13,"name":"$self","containerName":"executable"},{"line":329,"kind":12,"name":"warn","containerName":"executable"},{"name":"$self","containerName":"executable","kind":13,"line":329},{"line":329,"kind":12,"name":"program_name","containerName":"executable"},{"name":"$warn","containerName":"executable","line":329,"kind":13},{"line":330,"kind":13,"containerName":"executable","name":"$self"},{"line":334,"kind":13,"containerName":"executable","name":"$self"}],"line":305,"kind":12,"signature":{"label":"executable($self,$exe,$warn)","documentation":"1;\n# $Id: WrapperBase.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Run::WrapperBase\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Run::WrapperBase - A Base object for wrappers around executables\n\n=head1 SYNOPSIS\n\n  # do not use this object directly, it provides the following methods\n  # for its subclasses\n\n  my $errstr = $obj->error_string();\n  my $exe    = $obj->executable();\n  $obj->save_tempfiles($booleanflag)\n  my $outfile= $obj->outfile_name();\n  my $tempdir= $obj->tempdir(); # get a temporary dir for executing\n  my $io     = $obj->io;  # Bio::Root::IO object\n  my $cleanup= $obj->cleanup(); # remove tempfiles\n\n  $obj->run({-arg1 => $value});\n\n=head1 DESCRIPTION\n\nThis is a basic module from which to build executable wrapper modules.\nIt has some basic methods to help when implementing new modules.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track of\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Run::WrapperBase;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse base qw(Bio::Root::Root);\n\nuse File::Spec;\nuse File::Path qw(); # don't import anything\n\n=head2 run\n\n Title   : run\n Usage   : $wrapper->run({ARGS HERE});\n Function: Support generic running with args passed in\n           as a hashref\n Returns : Depends on the implementation, status OR data\n Args    : hashref of named arguments\n\n\n\nsub run {\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 error_string\n\n Title   : error_string\n Usage   : $obj->error_string($newval)\n Function: Where the output from the last analysis run is stored.\n Returns : value of error_string\n Args    : newvalue (optional)\n\n\n\nsub error_string{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'_error_string'} = $value;\n    }\n    return $self->{'_error_string'} || '';\n}\n\n=head2 arguments\n\n Title   : arguments\n Usage   : $obj->arguments($newval)\n Function: Commandline parameters \n Returns : value of arguments\n Args    : newvalue (optional)\n\n\n\nsub arguments {\n  my ($self,$value) = @_;\n  if(defined $value) {\n    $self->{'_arguments'} = $value;\n  }\n  return $self->{'_arguments'} || '';\n}\n\n\n=head2 no_param_checks\n\n Title   : no_param_checks\n Usage   : $obj->no_param_checks($newval)\n Function: Boolean flag as to whether or not we should\n           trust the sanity checks for parameter values\n Returns : value of no_param_checks\n Args    : newvalue (optional)\n\n\n\nsub no_param_checks{\n   my ($self,$value) = @_;\n   if( defined $value || ! defined $self->{'no_param_checks'} ) {\n       $value = 0 unless defined $value;\n      $self->{'no_param_checks'} = $value;\n    }\n    return $self->{'no_param_checks'};\n}\n\n=head2 save_tempfiles\n\n Title   : save_tempfiles\n Usage   : $obj->save_tempfiles($newval)\n Function: Get/set the choice of if tempfiles in the temp dir (see tempdir())\n           are kept or cleaned up. Default is '0', ie. delete temp files.\n           NB:\u00caThis must be set to the desired value PRIOR to first creating\n           a temp dir with tempdir().\n Returns : boolean\n Args    : none to get, boolean to set\n\n\nsub save_tempfiles{\n    my $self = shift;\n    return $self->io->save_tempfiles(@_);\n}\n\n=head2 outfile_name\n\n Title   : outfile_name\n Usage   : my $outfile = $wrapper->outfile_name();\n Function: Get/Set the name of the output file for this run\n           (if you wanted to do something special)\n Returns : string\n Args    : [optional] string to set value to\n\n\n\nsub outfile_name{\n   my ($self,$nm) = @_;\n   if( defined $nm || ! defined $self->{'_outfilename'} ) { \n       $nm = 'mlc' unless defined $nm;\n       $self->{'_outfilename'} = $nm;\n   }\n   return $self->{'_outfilename'};\n}\n\n\n=head2 tempdir\n\n Title   : tempdir\n Usage   : my $tmpdir = $self->tempdir();\n Function: Retrieve a temporary directory name (which is created)\n Returns : string which is the name of the temporary directory\n Args    : none\n\n\n\nsub tempdir{\n   my ($self) = shift;\n\n   $self->{'_tmpdir'} = shift if @_;\n   unless( $self->{'_tmpdir'} ) {\n       $self->{'_tmpdir'} = $self->io->tempdir(CLEANUP => ! $self->save_tempfiles );\n   }\n   unless( -d $self->{'_tmpdir'} ) {\n       mkdir($self->{'_tmpdir'},0777);\n   }\n   return $self->{'_tmpdir'};\n}\n\n=head2 cleanup\n\n Title   : cleanup\n Usage   : $wrapper->cleanup();\n Function: Will cleanup the tempdir directory\n Returns : none\n Args    : none\n\n\n\nsub cleanup{\n   my ($self) = @_;\n   $self->io->_io_cleanup();\n   if( defined $self->{'_tmpdir'} && -d $self->{'_tmpdir'} ) {\n      my $verbose = ($self->verbose >= 1) ? 1 : 0;\n      File::Path::rmtree( $self->{'_tmpdir'}, $verbose);\n   }\n}\n\n=head2 io\n\n Title   : io\n Usage   : $obj->io($newval)\n Function: Gets a Bio::Root::IO object\n Returns : Bio::Root::IO object\n Args    : none\n\n\n\nsub io{\n   my ($self) = @_;\n   unless( defined $self->{'io'} ) {\n       $self->{'io'} = Bio::Root::IO->new(-verbose => $self->verbose);\n   }\n    return $self->{'io'};\n}\n\n=head2 version\n\n Title   : version\n Usage   : $version = $wrapper->version()\n Function: Returns the program version (if available)\n Returns : string representing version of the program \n Args    : [Optional] value to (re)set version string\n\n\n\nsub version{\n   my ($self,@args) = @_;\n   return;\n}\n\n=head2 executable\n\n Title   : executable\n Usage   : my $exe = $factory->executable();\n Function: Finds the full path to the executable\n Returns : string representing the full path to the exe\n Args    : [optional] name of executable to set path to\n           [optional] boolean flag whether or not warn when exe is not found","parameters":[{"label":"$self"},{"label":"$exe"},{"label":"$warn"}]},"detail":"($self,$exe,$warn)","definition":"sub","containerName":"main::","range":{"start":{"line":305,"character":0},"end":{"line":335,"character":9999}},"name":"executable"},{"name":"program_path","range":{"start":{"character":0,"line":347},"end":{"character":9999,"line":353}},"kind":12,"children":[{"localvar":"my","containerName":"program_path","name":"$self","definition":"my","line":348,"kind":13},{"kind":13,"line":349,"name":"@path","definition":"my","containerName":"program_path","localvar":"my"},{"kind":13,"line":350,"name":"@path","containerName":"program_path"},{"line":350,"kind":13,"containerName":"program_path","name":"$self"},{"name":"program_dir","containerName":"program_path","line":350,"kind":12},{"line":350,"kind":13,"containerName":"program_path","name":"$self"},{"name":"program_dir","containerName":"program_path","kind":12,"line":350},{"kind":13,"line":351,"containerName":"program_path","name":"@path"},{"line":351,"kind":13,"name":"$self","containerName":"program_path"},{"line":351,"kind":12,"name":"program_name","containerName":"program_path"},{"kind":13,"line":351,"containerName":"program_path","name":"$self"},{"containerName":"program_path","name":"program_name","kind":12,"line":351},{"line":352,"kind":12,"containerName":"program_path","name":"catfile"},{"line":352,"kind":13,"containerName":"program_path","name":"@path"}],"line":347,"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: WrapperBase.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Run::WrapperBase\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Run::WrapperBase - A Base object for wrappers around executables\n\n=head1 SYNOPSIS\n\n  # do not use this object directly, it provides the following methods\n  # for its subclasses\n\n  my $errstr = $obj->error_string();\n  my $exe    = $obj->executable();\n  $obj->save_tempfiles($booleanflag)\n  my $outfile= $obj->outfile_name();\n  my $tempdir= $obj->tempdir(); # get a temporary dir for executing\n  my $io     = $obj->io;  # Bio::Root::IO object\n  my $cleanup= $obj->cleanup(); # remove tempfiles\n\n  $obj->run({-arg1 => $value});\n\n=head1 DESCRIPTION\n\nThis is a basic module from which to build executable wrapper modules.\nIt has some basic methods to help when implementing new modules.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track of\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Run::WrapperBase;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse base qw(Bio::Root::Root);\n\nuse File::Spec;\nuse File::Path qw(); # don't import anything\n\n=head2 run\n\n Title   : run\n Usage   : $wrapper->run({ARGS HERE});\n Function: Support generic running with args passed in\n           as a hashref\n Returns : Depends on the implementation, status OR data\n Args    : hashref of named arguments\n\n\n\nsub run {\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 error_string\n\n Title   : error_string\n Usage   : $obj->error_string($newval)\n Function: Where the output from the last analysis run is stored.\n Returns : value of error_string\n Args    : newvalue (optional)\n\n\n\nsub error_string{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'_error_string'} = $value;\n    }\n    return $self->{'_error_string'} || '';\n}\n\n=head2 arguments\n\n Title   : arguments\n Usage   : $obj->arguments($newval)\n Function: Commandline parameters \n Returns : value of arguments\n Args    : newvalue (optional)\n\n\n\nsub arguments {\n  my ($self,$value) = @_;\n  if(defined $value) {\n    $self->{'_arguments'} = $value;\n  }\n  return $self->{'_arguments'} || '';\n}\n\n\n=head2 no_param_checks\n\n Title   : no_param_checks\n Usage   : $obj->no_param_checks($newval)\n Function: Boolean flag as to whether or not we should\n           trust the sanity checks for parameter values\n Returns : value of no_param_checks\n Args    : newvalue (optional)\n\n\n\nsub no_param_checks{\n   my ($self,$value) = @_;\n   if( defined $value || ! defined $self->{'no_param_checks'} ) {\n       $value = 0 unless defined $value;\n      $self->{'no_param_checks'} = $value;\n    }\n    return $self->{'no_param_checks'};\n}\n\n=head2 save_tempfiles\n\n Title   : save_tempfiles\n Usage   : $obj->save_tempfiles($newval)\n Function: Get/set the choice of if tempfiles in the temp dir (see tempdir())\n           are kept or cleaned up. Default is '0', ie. delete temp files.\n           NB:\u00caThis must be set to the desired value PRIOR to first creating\n           a temp dir with tempdir().\n Returns : boolean\n Args    : none to get, boolean to set\n\n\nsub save_tempfiles{\n    my $self = shift;\n    return $self->io->save_tempfiles(@_);\n}\n\n=head2 outfile_name\n\n Title   : outfile_name\n Usage   : my $outfile = $wrapper->outfile_name();\n Function: Get/Set the name of the output file for this run\n           (if you wanted to do something special)\n Returns : string\n Args    : [optional] string to set value to\n\n\n\nsub outfile_name{\n   my ($self,$nm) = @_;\n   if( defined $nm || ! defined $self->{'_outfilename'} ) { \n       $nm = 'mlc' unless defined $nm;\n       $self->{'_outfilename'} = $nm;\n   }\n   return $self->{'_outfilename'};\n}\n\n\n=head2 tempdir\n\n Title   : tempdir\n Usage   : my $tmpdir = $self->tempdir();\n Function: Retrieve a temporary directory name (which is created)\n Returns : string which is the name of the temporary directory\n Args    : none\n\n\n\nsub tempdir{\n   my ($self) = shift;\n\n   $self->{'_tmpdir'} = shift if @_;\n   unless( $self->{'_tmpdir'} ) {\n       $self->{'_tmpdir'} = $self->io->tempdir(CLEANUP => ! $self->save_tempfiles );\n   }\n   unless( -d $self->{'_tmpdir'} ) {\n       mkdir($self->{'_tmpdir'},0777);\n   }\n   return $self->{'_tmpdir'};\n}\n\n=head2 cleanup\n\n Title   : cleanup\n Usage   : $wrapper->cleanup();\n Function: Will cleanup the tempdir directory\n Returns : none\n Args    : none\n\n\n\nsub cleanup{\n   my ($self) = @_;\n   $self->io->_io_cleanup();\n   if( defined $self->{'_tmpdir'} && -d $self->{'_tmpdir'} ) {\n      my $verbose = ($self->verbose >= 1) ? 1 : 0;\n      File::Path::rmtree( $self->{'_tmpdir'}, $verbose);\n   }\n}\n\n=head2 io\n\n Title   : io\n Usage   : $obj->io($newval)\n Function: Gets a Bio::Root::IO object\n Returns : Bio::Root::IO object\n Args    : none\n\n\n\nsub io{\n   my ($self) = @_;\n   unless( defined $self->{'io'} ) {\n       $self->{'io'} = Bio::Root::IO->new(-verbose => $self->verbose);\n   }\n    return $self->{'io'};\n}\n\n=head2 version\n\n Title   : version\n Usage   : $version = $wrapper->version()\n Function: Returns the program version (if available)\n Returns : string representing version of the program \n Args    : [Optional] value to (re)set version string\n\n\n\nsub version{\n   my ($self,@args) = @_;\n   return;\n}\n\n=head2 executable\n\n Title   : executable\n Usage   : my $exe = $factory->executable();\n Function: Finds the full path to the executable\n Returns : string representing the full path to the exe\n Args    : [optional] name of executable to set path to\n           [optional] boolean flag whether or not warn when exe is not found\n\n\nsub executable {\n    my ($self, $exe, $warn) = @_;\n    \n    if (defined $exe) {\n        $self->{'_pathtoexe'} = $exe;\n    }\n    \n    unless( defined $self->{'_pathtoexe'} ) {\n        my $prog_path = $self->program_path;\n        \n        if ($prog_path) {\n            if (-e $prog_path && -x $prog_path) {\n                $self->{'_pathtoexe'} = $prog_path;\n            }\n            elsif ($self->program_dir) {\n                $self->warn(\"executable not found in $prog_path, trying system path...\") if $warn;\n            }\n        }\n        unless ($self->{'_pathtoexe'}) {\n            my $exe;\n            if (($exe = $self->io->exists_exe($self->program_name)) && -x $exe) {\n                $self->{'_pathtoexe'} = $exe;\n            }\n            else {\n                $self->warn(\"Cannot find executable for \".$self->program_name) if $warn;\n                $self->{'_pathtoexe'} = undef;\n            }\n        }\n    }\n    $self->{'_pathtoexe'};\n}\n\n=head2 program_path\n\n Title   : program_path\n Usage   : my $path = $factory->program_path();\n Function: Builds path for executable \n Returns : string representing the full path to the exe\n Args    : none","label":"program_path($self)"},"detail":"($self)"},{"kind":12,"line":352,"containerName":"Spec","name":"File"},{"line":366,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"program_dir","line":367,"kind":13},{"name":"$self","containerName":"program_dir","line":368,"kind":13},{"containerName":"program_dir","name":"throw_not_implemented","line":368,"kind":12}],"kind":12,"detail":"($self)","signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: WrapperBase.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Run::WrapperBase\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Run::WrapperBase - A Base object for wrappers around executables\n\n=head1 SYNOPSIS\n\n  # do not use this object directly, it provides the following methods\n  # for its subclasses\n\n  my $errstr = $obj->error_string();\n  my $exe    = $obj->executable();\n  $obj->save_tempfiles($booleanflag)\n  my $outfile= $obj->outfile_name();\n  my $tempdir= $obj->tempdir(); # get a temporary dir for executing\n  my $io     = $obj->io;  # Bio::Root::IO object\n  my $cleanup= $obj->cleanup(); # remove tempfiles\n\n  $obj->run({-arg1 => $value});\n\n=head1 DESCRIPTION\n\nThis is a basic module from which to build executable wrapper modules.\nIt has some basic methods to help when implementing new modules.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track of\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Run::WrapperBase;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse base qw(Bio::Root::Root);\n\nuse File::Spec;\nuse File::Path qw(); # don't import anything\n\n=head2 run\n\n Title   : run\n Usage   : $wrapper->run({ARGS HERE});\n Function: Support generic running with args passed in\n           as a hashref\n Returns : Depends on the implementation, status OR data\n Args    : hashref of named arguments\n\n\n\nsub run {\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 error_string\n\n Title   : error_string\n Usage   : $obj->error_string($newval)\n Function: Where the output from the last analysis run is stored.\n Returns : value of error_string\n Args    : newvalue (optional)\n\n\n\nsub error_string{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'_error_string'} = $value;\n    }\n    return $self->{'_error_string'} || '';\n}\n\n=head2 arguments\n\n Title   : arguments\n Usage   : $obj->arguments($newval)\n Function: Commandline parameters \n Returns : value of arguments\n Args    : newvalue (optional)\n\n\n\nsub arguments {\n  my ($self,$value) = @_;\n  if(defined $value) {\n    $self->{'_arguments'} = $value;\n  }\n  return $self->{'_arguments'} || '';\n}\n\n\n=head2 no_param_checks\n\n Title   : no_param_checks\n Usage   : $obj->no_param_checks($newval)\n Function: Boolean flag as to whether or not we should\n           trust the sanity checks for parameter values\n Returns : value of no_param_checks\n Args    : newvalue (optional)\n\n\n\nsub no_param_checks{\n   my ($self,$value) = @_;\n   if( defined $value || ! defined $self->{'no_param_checks'} ) {\n       $value = 0 unless defined $value;\n      $self->{'no_param_checks'} = $value;\n    }\n    return $self->{'no_param_checks'};\n}\n\n=head2 save_tempfiles\n\n Title   : save_tempfiles\n Usage   : $obj->save_tempfiles($newval)\n Function: Get/set the choice of if tempfiles in the temp dir (see tempdir())\n           are kept or cleaned up. Default is '0', ie. delete temp files.\n           NB:\u00caThis must be set to the desired value PRIOR to first creating\n           a temp dir with tempdir().\n Returns : boolean\n Args    : none to get, boolean to set\n\n\nsub save_tempfiles{\n    my $self = shift;\n    return $self->io->save_tempfiles(@_);\n}\n\n=head2 outfile_name\n\n Title   : outfile_name\n Usage   : my $outfile = $wrapper->outfile_name();\n Function: Get/Set the name of the output file for this run\n           (if you wanted to do something special)\n Returns : string\n Args    : [optional] string to set value to\n\n\n\nsub outfile_name{\n   my ($self,$nm) = @_;\n   if( defined $nm || ! defined $self->{'_outfilename'} ) { \n       $nm = 'mlc' unless defined $nm;\n       $self->{'_outfilename'} = $nm;\n   }\n   return $self->{'_outfilename'};\n}\n\n\n=head2 tempdir\n\n Title   : tempdir\n Usage   : my $tmpdir = $self->tempdir();\n Function: Retrieve a temporary directory name (which is created)\n Returns : string which is the name of the temporary directory\n Args    : none\n\n\n\nsub tempdir{\n   my ($self) = shift;\n\n   $self->{'_tmpdir'} = shift if @_;\n   unless( $self->{'_tmpdir'} ) {\n       $self->{'_tmpdir'} = $self->io->tempdir(CLEANUP => ! $self->save_tempfiles );\n   }\n   unless( -d $self->{'_tmpdir'} ) {\n       mkdir($self->{'_tmpdir'},0777);\n   }\n   return $self->{'_tmpdir'};\n}\n\n=head2 cleanup\n\n Title   : cleanup\n Usage   : $wrapper->cleanup();\n Function: Will cleanup the tempdir directory\n Returns : none\n Args    : none\n\n\n\nsub cleanup{\n   my ($self) = @_;\n   $self->io->_io_cleanup();\n   if( defined $self->{'_tmpdir'} && -d $self->{'_tmpdir'} ) {\n      my $verbose = ($self->verbose >= 1) ? 1 : 0;\n      File::Path::rmtree( $self->{'_tmpdir'}, $verbose);\n   }\n}\n\n=head2 io\n\n Title   : io\n Usage   : $obj->io($newval)\n Function: Gets a Bio::Root::IO object\n Returns : Bio::Root::IO object\n Args    : none\n\n\n\nsub io{\n   my ($self) = @_;\n   unless( defined $self->{'io'} ) {\n       $self->{'io'} = Bio::Root::IO->new(-verbose => $self->verbose);\n   }\n    return $self->{'io'};\n}\n\n=head2 version\n\n Title   : version\n Usage   : $version = $wrapper->version()\n Function: Returns the program version (if available)\n Returns : string representing version of the program \n Args    : [Optional] value to (re)set version string\n\n\n\nsub version{\n   my ($self,@args) = @_;\n   return;\n}\n\n=head2 executable\n\n Title   : executable\n Usage   : my $exe = $factory->executable();\n Function: Finds the full path to the executable\n Returns : string representing the full path to the exe\n Args    : [optional] name of executable to set path to\n           [optional] boolean flag whether or not warn when exe is not found\n\n\nsub executable {\n    my ($self, $exe, $warn) = @_;\n    \n    if (defined $exe) {\n        $self->{'_pathtoexe'} = $exe;\n    }\n    \n    unless( defined $self->{'_pathtoexe'} ) {\n        my $prog_path = $self->program_path;\n        \n        if ($prog_path) {\n            if (-e $prog_path && -x $prog_path) {\n                $self->{'_pathtoexe'} = $prog_path;\n            }\n            elsif ($self->program_dir) {\n                $self->warn(\"executable not found in $prog_path, trying system path...\") if $warn;\n            }\n        }\n        unless ($self->{'_pathtoexe'}) {\n            my $exe;\n            if (($exe = $self->io->exists_exe($self->program_name)) && -x $exe) {\n                $self->{'_pathtoexe'} = $exe;\n            }\n            else {\n                $self->warn(\"Cannot find executable for \".$self->program_name) if $warn;\n                $self->{'_pathtoexe'} = undef;\n            }\n        }\n    }\n    $self->{'_pathtoexe'};\n}\n\n=head2 program_path\n\n Title   : program_path\n Usage   : my $path = $factory->program_path();\n Function: Builds path for executable \n Returns : string representing the full path to the exe\n Args    : none\n\n\nsub program_path {\n   my ($self) = @_;\n   my @path;\n   push @path, $self->program_dir if $self->program_dir;\n   push @path, $self->program_name.($^O =~ /mswin/i ? '.exe' : '') if $self->program_name;\n   return File::Spec->catfile(@path);\n}\n\n=head2 program_dir\n\n Title   : program_dir\n Usage   : my $dir = $factory->program_dir();\n Function: Abstract get method for dir of program. To be implemented\n           by wrapper.\n Returns : string representing program directory \n Args    : none ","label":"program_dir($self)"},"containerName":"main::","definition":"sub","range":{"end":{"line":369,"character":9999},"start":{"character":0,"line":366}},"name":"program_dir"},{"range":{"end":{"line":385,"character":9999},"start":{"character":0,"line":382}},"name":"program_name","signature":{"documentation":"1;\n# $Id: WrapperBase.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Run::WrapperBase\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Run::WrapperBase - A Base object for wrappers around executables\n\n=head1 SYNOPSIS\n\n  # do not use this object directly, it provides the following methods\n  # for its subclasses\n\n  my $errstr = $obj->error_string();\n  my $exe    = $obj->executable();\n  $obj->save_tempfiles($booleanflag)\n  my $outfile= $obj->outfile_name();\n  my $tempdir= $obj->tempdir(); # get a temporary dir for executing\n  my $io     = $obj->io;  # Bio::Root::IO object\n  my $cleanup= $obj->cleanup(); # remove tempfiles\n\n  $obj->run({-arg1 => $value});\n\n=head1 DESCRIPTION\n\nThis is a basic module from which to build executable wrapper modules.\nIt has some basic methods to help when implementing new modules.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track of\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Run::WrapperBase;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse base qw(Bio::Root::Root);\n\nuse File::Spec;\nuse File::Path qw(); # don't import anything\n\n=head2 run\n\n Title   : run\n Usage   : $wrapper->run({ARGS HERE});\n Function: Support generic running with args passed in\n           as a hashref\n Returns : Depends on the implementation, status OR data\n Args    : hashref of named arguments\n\n\n\nsub run {\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 error_string\n\n Title   : error_string\n Usage   : $obj->error_string($newval)\n Function: Where the output from the last analysis run is stored.\n Returns : value of error_string\n Args    : newvalue (optional)\n\n\n\nsub error_string{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'_error_string'} = $value;\n    }\n    return $self->{'_error_string'} || '';\n}\n\n=head2 arguments\n\n Title   : arguments\n Usage   : $obj->arguments($newval)\n Function: Commandline parameters \n Returns : value of arguments\n Args    : newvalue (optional)\n\n\n\nsub arguments {\n  my ($self,$value) = @_;\n  if(defined $value) {\n    $self->{'_arguments'} = $value;\n  }\n  return $self->{'_arguments'} || '';\n}\n\n\n=head2 no_param_checks\n\n Title   : no_param_checks\n Usage   : $obj->no_param_checks($newval)\n Function: Boolean flag as to whether or not we should\n           trust the sanity checks for parameter values\n Returns : value of no_param_checks\n Args    : newvalue (optional)\n\n\n\nsub no_param_checks{\n   my ($self,$value) = @_;\n   if( defined $value || ! defined $self->{'no_param_checks'} ) {\n       $value = 0 unless defined $value;\n      $self->{'no_param_checks'} = $value;\n    }\n    return $self->{'no_param_checks'};\n}\n\n=head2 save_tempfiles\n\n Title   : save_tempfiles\n Usage   : $obj->save_tempfiles($newval)\n Function: Get/set the choice of if tempfiles in the temp dir (see tempdir())\n           are kept or cleaned up. Default is '0', ie. delete temp files.\n           NB:\u00caThis must be set to the desired value PRIOR to first creating\n           a temp dir with tempdir().\n Returns : boolean\n Args    : none to get, boolean to set\n\n\nsub save_tempfiles{\n    my $self = shift;\n    return $self->io->save_tempfiles(@_);\n}\n\n=head2 outfile_name\n\n Title   : outfile_name\n Usage   : my $outfile = $wrapper->outfile_name();\n Function: Get/Set the name of the output file for this run\n           (if you wanted to do something special)\n Returns : string\n Args    : [optional] string to set value to\n\n\n\nsub outfile_name{\n   my ($self,$nm) = @_;\n   if( defined $nm || ! defined $self->{'_outfilename'} ) { \n       $nm = 'mlc' unless defined $nm;\n       $self->{'_outfilename'} = $nm;\n   }\n   return $self->{'_outfilename'};\n}\n\n\n=head2 tempdir\n\n Title   : tempdir\n Usage   : my $tmpdir = $self->tempdir();\n Function: Retrieve a temporary directory name (which is created)\n Returns : string which is the name of the temporary directory\n Args    : none\n\n\n\nsub tempdir{\n   my ($self) = shift;\n\n   $self->{'_tmpdir'} = shift if @_;\n   unless( $self->{'_tmpdir'} ) {\n       $self->{'_tmpdir'} = $self->io->tempdir(CLEANUP => ! $self->save_tempfiles );\n   }\n   unless( -d $self->{'_tmpdir'} ) {\n       mkdir($self->{'_tmpdir'},0777);\n   }\n   return $self->{'_tmpdir'};\n}\n\n=head2 cleanup\n\n Title   : cleanup\n Usage   : $wrapper->cleanup();\n Function: Will cleanup the tempdir directory\n Returns : none\n Args    : none\n\n\n\nsub cleanup{\n   my ($self) = @_;\n   $self->io->_io_cleanup();\n   if( defined $self->{'_tmpdir'} && -d $self->{'_tmpdir'} ) {\n      my $verbose = ($self->verbose >= 1) ? 1 : 0;\n      File::Path::rmtree( $self->{'_tmpdir'}, $verbose);\n   }\n}\n\n=head2 io\n\n Title   : io\n Usage   : $obj->io($newval)\n Function: Gets a Bio::Root::IO object\n Returns : Bio::Root::IO object\n Args    : none\n\n\n\nsub io{\n   my ($self) = @_;\n   unless( defined $self->{'io'} ) {\n       $self->{'io'} = Bio::Root::IO->new(-verbose => $self->verbose);\n   }\n    return $self->{'io'};\n}\n\n=head2 version\n\n Title   : version\n Usage   : $version = $wrapper->version()\n Function: Returns the program version (if available)\n Returns : string representing version of the program \n Args    : [Optional] value to (re)set version string\n\n\n\nsub version{\n   my ($self,@args) = @_;\n   return;\n}\n\n=head2 executable\n\n Title   : executable\n Usage   : my $exe = $factory->executable();\n Function: Finds the full path to the executable\n Returns : string representing the full path to the exe\n Args    : [optional] name of executable to set path to\n           [optional] boolean flag whether or not warn when exe is not found\n\n\nsub executable {\n    my ($self, $exe, $warn) = @_;\n    \n    if (defined $exe) {\n        $self->{'_pathtoexe'} = $exe;\n    }\n    \n    unless( defined $self->{'_pathtoexe'} ) {\n        my $prog_path = $self->program_path;\n        \n        if ($prog_path) {\n            if (-e $prog_path && -x $prog_path) {\n                $self->{'_pathtoexe'} = $prog_path;\n            }\n            elsif ($self->program_dir) {\n                $self->warn(\"executable not found in $prog_path, trying system path...\") if $warn;\n            }\n        }\n        unless ($self->{'_pathtoexe'}) {\n            my $exe;\n            if (($exe = $self->io->exists_exe($self->program_name)) && -x $exe) {\n                $self->{'_pathtoexe'} = $exe;\n            }\n            else {\n                $self->warn(\"Cannot find executable for \".$self->program_name) if $warn;\n                $self->{'_pathtoexe'} = undef;\n            }\n        }\n    }\n    $self->{'_pathtoexe'};\n}\n\n=head2 program_path\n\n Title   : program_path\n Usage   : my $path = $factory->program_path();\n Function: Builds path for executable \n Returns : string representing the full path to the exe\n Args    : none\n\n\nsub program_path {\n   my ($self) = @_;\n   my @path;\n   push @path, $self->program_dir if $self->program_dir;\n   push @path, $self->program_name.($^O =~ /mswin/i ? '.exe' : '') if $self->program_name;\n   return File::Spec->catfile(@path);\n}\n\n=head2 program_dir\n\n Title   : program_dir\n Usage   : my $dir = $factory->program_dir();\n Function: Abstract get method for dir of program. To be implemented\n           by wrapper.\n Returns : string representing program directory \n Args    : none \n\n\nsub program_dir {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 program_name\n\n Title   : program_name\n Usage   : my $name = $factory->program_name();\n Function: Abstract get method for name of program. To be implemented\n           by wrapper.\n Returns : string representing program name\n Args    : none","parameters":[{"label":"$self"}],"label":"program_name($self)"},"detail":"($self)","definition":"sub","containerName":"main::","children":[{"definition":"my","name":"$self","containerName":"program_name","localvar":"my","kind":13,"line":383},{"line":384,"kind":13,"containerName":"program_name","name":"$self"},{"containerName":"program_name","name":"throw_not_implemented","kind":12,"line":384}],"line":382,"kind":12},{"line":399,"children":[{"kind":13,"line":400,"containerName":"quiet","definition":"my","name":"$self","localvar":"my"},{"kind":13,"line":401,"name":"$self","containerName":"quiet"},{"line":402,"kind":13,"containerName":"quiet","name":"$self"}],"kind":12,"range":{"start":{"line":399,"character":0},"end":{"line":403,"character":9999}},"containerName":"main::","name":"quiet","definition":"sub"},{"name":"quiet","kind":12,"line":401},{"kind":12,"line":402,"name":"quiet"},{"children":[{"kind":13,"line":443,"containerName":"_setparams","name":"$self","definition":"my","localvar":"my"},{"kind":13,"line":443,"containerName":"_setparams","name":"@args"},{"localvar":"my","definition":"my","name":"$params","containerName":"_setparams","line":445,"kind":13},{"containerName":"_setparams","name":"$switches","line":445,"kind":13},{"name":"$join","containerName":"_setparams","line":445,"kind":13},{"containerName":"_setparams","name":"$lc","kind":13,"line":445},{"line":445,"kind":13,"containerName":"_setparams","name":"$d"},{"name":"$dd","containerName":"_setparams","kind":13,"line":445},{"line":445,"kind":13,"name":"$md","containerName":"_setparams"},{"kind":13,"line":445,"name":"$utd","containerName":"_setparams"},{"containerName":"_setparams","name":"$self","kind":13,"line":446},{"line":446,"kind":12,"containerName":"_setparams","name":"_rearrange"},{"containerName":"_setparams","name":"@args","line":453,"kind":13},{"name":"$self","containerName":"_setparams","line":454,"kind":13},{"containerName":"_setparams","name":"throw","line":454,"kind":12},{"line":454,"kind":13,"name":"$params","containerName":"_setparams"},{"kind":13,"line":454,"name":"$switches","containerName":"_setparams"},{"line":455,"kind":13,"containerName":"_setparams","name":"$self"},{"kind":12,"line":455,"name":"throw","containerName":"_setparams"},{"name":"$d","containerName":"_setparams","line":455,"kind":13},{"line":455,"kind":13,"name":"$dd","containerName":"_setparams"},{"line":455,"kind":13,"containerName":"_setparams","name":"$md"},{"containerName":"_setparams","name":"$join","kind":13,"line":456},{"localvar":"my","containerName":"_setparams","name":"%params","definition":"my","line":458,"kind":13},{"name":"$params","containerName":"_setparams","kind":13,"line":458},{"containerName":"_setparams","name":"$params","line":458,"kind":13}],"line":442,"kind":12,"signature":{"label":"_setparams($self,@args)","documentation":"1;\n# $Id: WrapperBase.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Run::WrapperBase\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Run::WrapperBase - A Base object for wrappers around executables\n\n=head1 SYNOPSIS\n\n  # do not use this object directly, it provides the following methods\n  # for its subclasses\n\n  my $errstr = $obj->error_string();\n  my $exe    = $obj->executable();\n  $obj->save_tempfiles($booleanflag)\n  my $outfile= $obj->outfile_name();\n  my $tempdir= $obj->tempdir(); # get a temporary dir for executing\n  my $io     = $obj->io;  # Bio::Root::IO object\n  my $cleanup= $obj->cleanup(); # remove tempfiles\n\n  $obj->run({-arg1 => $value});\n\n=head1 DESCRIPTION\n\nThis is a basic module from which to build executable wrapper modules.\nIt has some basic methods to help when implementing new modules.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track of\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Run::WrapperBase;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse base qw(Bio::Root::Root);\n\nuse File::Spec;\nuse File::Path qw(); # don't import anything\n\n=head2 run\n\n Title   : run\n Usage   : $wrapper->run({ARGS HERE});\n Function: Support generic running with args passed in\n           as a hashref\n Returns : Depends on the implementation, status OR data\n Args    : hashref of named arguments\n\n\n\nsub run {\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 error_string\n\n Title   : error_string\n Usage   : $obj->error_string($newval)\n Function: Where the output from the last analysis run is stored.\n Returns : value of error_string\n Args    : newvalue (optional)\n\n\n\nsub error_string{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'_error_string'} = $value;\n    }\n    return $self->{'_error_string'} || '';\n}\n\n=head2 arguments\n\n Title   : arguments\n Usage   : $obj->arguments($newval)\n Function: Commandline parameters \n Returns : value of arguments\n Args    : newvalue (optional)\n\n\n\nsub arguments {\n  my ($self,$value) = @_;\n  if(defined $value) {\n    $self->{'_arguments'} = $value;\n  }\n  return $self->{'_arguments'} || '';\n}\n\n\n=head2 no_param_checks\n\n Title   : no_param_checks\n Usage   : $obj->no_param_checks($newval)\n Function: Boolean flag as to whether or not we should\n           trust the sanity checks for parameter values\n Returns : value of no_param_checks\n Args    : newvalue (optional)\n\n\n\nsub no_param_checks{\n   my ($self,$value) = @_;\n   if( defined $value || ! defined $self->{'no_param_checks'} ) {\n       $value = 0 unless defined $value;\n      $self->{'no_param_checks'} = $value;\n    }\n    return $self->{'no_param_checks'};\n}\n\n=head2 save_tempfiles\n\n Title   : save_tempfiles\n Usage   : $obj->save_tempfiles($newval)\n Function: Get/set the choice of if tempfiles in the temp dir (see tempdir())\n           are kept or cleaned up. Default is '0', ie. delete temp files.\n           NB:\u00caThis must be set to the desired value PRIOR to first creating\n           a temp dir with tempdir().\n Returns : boolean\n Args    : none to get, boolean to set\n\n\nsub save_tempfiles{\n    my $self = shift;\n    return $self->io->save_tempfiles(@_);\n}\n\n=head2 outfile_name\n\n Title   : outfile_name\n Usage   : my $outfile = $wrapper->outfile_name();\n Function: Get/Set the name of the output file for this run\n           (if you wanted to do something special)\n Returns : string\n Args    : [optional] string to set value to\n\n\n\nsub outfile_name{\n   my ($self,$nm) = @_;\n   if( defined $nm || ! defined $self->{'_outfilename'} ) { \n       $nm = 'mlc' unless defined $nm;\n       $self->{'_outfilename'} = $nm;\n   }\n   return $self->{'_outfilename'};\n}\n\n\n=head2 tempdir\n\n Title   : tempdir\n Usage   : my $tmpdir = $self->tempdir();\n Function: Retrieve a temporary directory name (which is created)\n Returns : string which is the name of the temporary directory\n Args    : none\n\n\n\nsub tempdir{\n   my ($self) = shift;\n\n   $self->{'_tmpdir'} = shift if @_;\n   unless( $self->{'_tmpdir'} ) {\n       $self->{'_tmpdir'} = $self->io->tempdir(CLEANUP => ! $self->save_tempfiles );\n   }\n   unless( -d $self->{'_tmpdir'} ) {\n       mkdir($self->{'_tmpdir'},0777);\n   }\n   return $self->{'_tmpdir'};\n}\n\n=head2 cleanup\n\n Title   : cleanup\n Usage   : $wrapper->cleanup();\n Function: Will cleanup the tempdir directory\n Returns : none\n Args    : none\n\n\n\nsub cleanup{\n   my ($self) = @_;\n   $self->io->_io_cleanup();\n   if( defined $self->{'_tmpdir'} && -d $self->{'_tmpdir'} ) {\n      my $verbose = ($self->verbose >= 1) ? 1 : 0;\n      File::Path::rmtree( $self->{'_tmpdir'}, $verbose);\n   }\n}\n\n=head2 io\n\n Title   : io\n Usage   : $obj->io($newval)\n Function: Gets a Bio::Root::IO object\n Returns : Bio::Root::IO object\n Args    : none\n\n\n\nsub io{\n   my ($self) = @_;\n   unless( defined $self->{'io'} ) {\n       $self->{'io'} = Bio::Root::IO->new(-verbose => $self->verbose);\n   }\n    return $self->{'io'};\n}\n\n=head2 version\n\n Title   : version\n Usage   : $version = $wrapper->version()\n Function: Returns the program version (if available)\n Returns : string representing version of the program \n Args    : [Optional] value to (re)set version string\n\n\n\nsub version{\n   my ($self,@args) = @_;\n   return;\n}\n\n=head2 executable\n\n Title   : executable\n Usage   : my $exe = $factory->executable();\n Function: Finds the full path to the executable\n Returns : string representing the full path to the exe\n Args    : [optional] name of executable to set path to\n           [optional] boolean flag whether or not warn when exe is not found\n\n\nsub executable {\n    my ($self, $exe, $warn) = @_;\n    \n    if (defined $exe) {\n        $self->{'_pathtoexe'} = $exe;\n    }\n    \n    unless( defined $self->{'_pathtoexe'} ) {\n        my $prog_path = $self->program_path;\n        \n        if ($prog_path) {\n            if (-e $prog_path && -x $prog_path) {\n                $self->{'_pathtoexe'} = $prog_path;\n            }\n            elsif ($self->program_dir) {\n                $self->warn(\"executable not found in $prog_path, trying system path...\") if $warn;\n            }\n        }\n        unless ($self->{'_pathtoexe'}) {\n            my $exe;\n            if (($exe = $self->io->exists_exe($self->program_name)) && -x $exe) {\n                $self->{'_pathtoexe'} = $exe;\n            }\n            else {\n                $self->warn(\"Cannot find executable for \".$self->program_name) if $warn;\n                $self->{'_pathtoexe'} = undef;\n            }\n        }\n    }\n    $self->{'_pathtoexe'};\n}\n\n=head2 program_path\n\n Title   : program_path\n Usage   : my $path = $factory->program_path();\n Function: Builds path for executable \n Returns : string representing the full path to the exe\n Args    : none\n\n\nsub program_path {\n   my ($self) = @_;\n   my @path;\n   push @path, $self->program_dir if $self->program_dir;\n   push @path, $self->program_name.($^O =~ /mswin/i ? '.exe' : '') if $self->program_name;\n   return File::Spec->catfile(@path);\n}\n\n=head2 program_dir\n\n Title   : program_dir\n Usage   : my $dir = $factory->program_dir();\n Function: Abstract get method for dir of program. To be implemented\n           by wrapper.\n Returns : string representing program directory \n Args    : none \n\n\nsub program_dir {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 program_name\n\n Title   : program_name\n Usage   : my $name = $factory->program_name();\n Function: Abstract get method for name of program. To be implemented\n           by wrapper.\n Returns : string representing program name\n Args    : none\n\n\nsub program_name {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 quiet\n\n Title   : quiet\n Usage   : $factory->quiet(1);\n           if ($factory->quiet()) { ... }\n Function: Get/set the quiet state. Can be used by wrappers to control if\n           program output is printed to the console or not.\n Returns : boolean\n Args    : none to get, boolean to set\n\n\nsub quiet {\n    my $self = shift;\n    if (@_) { $self->{quiet} = shift }\n    return $self->{quiet} || 0;\n}\n\n=head2  _setparams()\n\n Title   : _setparams\n Usage   : $params = $self->_setparams(-params => [qw(window evalue_cutoff)])\n Function: For internal use by wrapper modules to build parameter strings\n           suitable for sending to the program being wrapped. For each method\n           name supplied, calls the method and adds the method name (as modified\n           by optional things) along with its value (unless a switch) to the\n           parameter string\n Example : $params = $self->_setparams(-params => [qw(window evalue_cutoff)],\n                                       -switches => [qw(simple large all)],\n                                       -double_dash => 1,\n                                       -underscore_to_dash => 1);\n           If window() and simple() had not been previously called, but\n           evalue_cutoff(0.5), large(1) and all(0) had been called, $params\n           would be ' --evalue-cutoff 0.5 --large'\n Returns : parameter string\n Args    : -params => [] or {}  # array ref of method names to call,\n                                  or hash ref where keys are method names and\n                                  values are how those names should be output\n                                  in the params string\n           -switches => [] or {}# as for -params, but no value is printed for\n                                  these methods\n           -join => string      # define how parameters and their values are\n                                  joined, default ' '. (eg. could be '=' for\n                                  param=value)\n           -lc => boolean       # lc() method names prior to output in string\n           -dash => boolean     # prefix all method names with a single dash\n           -double_dash => bool # prefix all method names with a double dash\n           -mixed_dash => bool  # prefix single-character method names with a\n                                # single dash, and multi-character method names\n                                # with a double-dash\n           -underscore_to_dash => boolean # convert all underscores in method\n                                            names to dashes","parameters":[{"label":"$self"},{"label":"@args"}]},"detail":"($self,@args)","definition":"sub","containerName":"main::","range":{"start":{"character":0,"line":442},"end":{"character":9999,"line":458}},"name":"_setparams"},{"kind":13,"line":458,"containerName":null,"name":"$params"},{"definition":"my","name":"%switches","containerName":null,"localvar":"my","kind":13,"line":459},{"kind":13,"line":459,"name":"$switches","containerName":null},{"line":459,"kind":13,"name":"%switches","containerName":null},{"line":459,"kind":13,"name":"$switches","containerName":null},{"kind":13,"line":461,"containerName":null,"definition":"my","name":"$param_string","localvar":"my"},{"kind":13,"line":462,"definition":"my","name":"$hash_ref","containerName":null,"localvar":"my"},{"line":462,"kind":13,"containerName":null,"name":"%params"},{"kind":13,"line":462,"name":"%switches","containerName":null},{"localvar":"my","containerName":null,"definition":"my","name":"$method","line":463,"kind":13},{"name":"$method_out","containerName":null,"kind":13,"line":463},{"containerName":null,"name":"%hash_ref","line":463,"kind":13},{"localvar":"my","name":"$value","definition":"my","containerName":null,"line":464,"kind":13},{"line":464,"kind":13,"name":"$self","containerName":null},{"name":"$method","containerName":null,"kind":13,"line":464},{"kind":13,"line":465,"containerName":null,"name":"$value"},{"kind":13,"line":466,"containerName":null,"name":"%switches"},{"kind":13,"line":466,"containerName":null,"name":"$method"},{"line":466,"kind":13,"name":"$value","containerName":null},{"containerName":null,"name":"$method_out","line":468,"kind":13},{"containerName":null,"name":"$method_out","line":468,"kind":13},{"containerName":null,"name":"$lc","line":468,"kind":13},{"localvar":"my","definition":"my","name":"$method_length","containerName":null,"line":469,"kind":13},{"name":"$method_out","containerName":null,"kind":13,"line":469},{"containerName":null,"name":"$md","line":469,"kind":13},{"line":470,"kind":13,"containerName":null,"name":"$method_out"},{"kind":13,"line":470,"containerName":null,"name":"$method_out"},{"line":470,"kind":13,"containerName":null,"name":"$d"},{"name":"$md","containerName":null,"line":470,"kind":13},{"kind":13,"line":470,"containerName":null,"name":"$method_length"},{"name":"$method_out","containerName":null,"kind":13,"line":471},{"line":471,"kind":13,"name":"$method_out","containerName":null},{"kind":13,"line":471,"containerName":null,"name":"$dd"},{"kind":13,"line":471,"containerName":null,"name":"$md"},{"kind":13,"line":471,"containerName":null,"name":"$method_length"},{"containerName":null,"name":"$method_out","line":472,"kind":13},{"name":"$utd","containerName":null,"line":472,"kind":13},{"name":"%params","containerName":null,"kind":13,"line":475},{"containerName":null,"name":"$method","line":475,"kind":13},{"name":"%value","containerName":null,"line":475,"kind":13},{"line":476,"kind":13,"containerName":null,"name":"$value"},{"containerName":null,"name":"$value","kind":13,"line":476},{"name":"$param_string","containerName":null,"kind":13,"line":479},{"containerName":null,"name":"$method_out","kind":13,"line":479},{"kind":13,"line":479,"name":"%switches","containerName":null},{"name":"$method","containerName":null,"kind":13,"line":479},{"line":479,"kind":13,"containerName":null,"name":"$join"},{"name":"$value","containerName":null,"kind":13,"line":479},{"line":483,"kind":13,"containerName":null,"name":"$param_string"},{"kind":12,"line":486,"children":[{"name":"$self","definition":"my","containerName":"DESTROY","localvar":"my","kind":13,"line":487},{"kind":13,"line":488,"containerName":"DESTROY","name":"$self"},{"kind":12,"line":488,"containerName":"DESTROY","name":"save_tempfiles"},{"name":"$self","containerName":"DESTROY","line":489,"kind":13},{"name":"cleanup","containerName":"DESTROY","line":489,"kind":12},{"name":"$self","containerName":"DESTROY","kind":13,"line":491}],"containerName":"main::","definition":"sub","name":"DESTROY","range":{"start":{"character":0,"line":486},"end":{"line":492,"character":9999}}},{"name":"SUPER","containerName":"DESTROY","kind":12,"line":491}],"version":5}