{"version":5,"vars":[{"kind":2,"line":159,"containerName":"","name":"base"},{"kind":13,"line":161,"definition":"our","name":"$MotifTag","containerName":"main::"},{"containerName":null,"name":"$SrcTag","kind":13,"line":161},{"kind":13,"line":161,"containerName":null,"name":"$DescTag"},{"name":"_initialize","range":{"end":{"line":190,"character":9999},"start":{"character":0,"line":176}},"kind":12,"line":176,"children":[{"kind":13,"line":177,"name":"$self","definition":"my","containerName":"_initialize","localvar":"my"},{"name":"@args","containerName":"_initialize","line":177,"kind":13},{"kind":13,"line":178,"name":"$self","containerName":"_initialize"},{"kind":12,"line":178,"name":"warn","containerName":"_initialize"},{"line":179,"kind":13,"containerName":"_initialize","name":"$self"},{"kind":13,"line":179,"name":"@args","containerName":"_initialize"},{"localvar":"my","name":"$motiftag","definition":"my","containerName":"_initialize","line":180,"kind":13},{"name":"$desctag","containerName":"_initialize","kind":13,"line":180},{"line":180,"kind":13,"containerName":"_initialize","name":"$srctag"},{"name":"$self","containerName":"_initialize","kind":13,"line":180},{"kind":13,"line":184,"containerName":"_initialize","name":"@args"},{"line":185,"kind":13,"name":"$self","containerName":"_initialize"},{"kind":12,"line":185,"containerName":"_initialize","name":"motif_tag"},{"kind":13,"line":185,"containerName":"_initialize","name":"$motiftag"},{"containerName":"_initialize","name":"$motiftag","line":185,"kind":13},{"containerName":"_initialize","name":"$MotifTag","kind":13,"line":185},{"kind":13,"line":186,"name":"$self","containerName":"_initialize"},{"containerName":"_initialize","name":"source_tag","kind":12,"line":186},{"containerName":"_initialize","name":"$srctag","kind":13,"line":186},{"line":186,"kind":13,"name":"$srctag","containerName":"_initialize"},{"line":186,"kind":13,"containerName":"_initialize","name":"$SrcTag"},{"kind":13,"line":187,"containerName":"_initialize","name":"$self"},{"line":187,"kind":12,"name":"desc_tag","containerName":"_initialize"},{"kind":13,"line":187,"containerName":"_initialize","name":"$desctag"},{"line":187,"kind":13,"name":"$desctag","containerName":"_initialize"},{"containerName":"_initialize","name":"$DescTag","line":187,"kind":13},{"containerName":"_initialize","name":"$self","kind":13,"line":188}],"containerName":"main::","definition":"sub","detail":"($self,@args)","signature":{"documentation":"1;\n# $Id: RNAMotif.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::RNAMotif\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields <cjfields-at-uiuc-dot-edu>\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::RNAMotif - A parser for RNAMotif output\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::RNAMotif;\n  my $parser = Bio::Tools::RNAMotif->new(-file => $rna_output,\n                                        -motiftag => 'protein_bind'\n                                        -desctag => 'TRAP_binding');\n  #parse the results\n  while( my $motif = $parser->next_prediction) {\n    # do something here\n  }\n\n=head1 DESCRIPTION\n\nParses raw RNAMotif output.  RNAMotif uses a RNA profile, consisting\nof sequence and structural elements stored in a descriptor file, to\nsearch for potential motifs in a DNA sequence file.  For more\ninformation, see:\n\nMacke TJ, Ecker DJ, Gutell RR, Gautheret D, Case DA, Sampath R. \nRNAMotif, an RNA secondary structure definition and search algorithm.\nNucleic Acids Res. 2001 Nov 15;29(22):4724-35. \nhttp://www.scripps.edu/mb/case/casegr-sh-3.5.html.\n\nThis module is not currently complete.  As is, it will parse raw\nRNAMotif output (i.e. information not passed through the secondary\nprograms rmfmt or rm2ct) and pack information into\nBio::SeqFeature::Generic objects.  Currently, parsing extra output\nutilized by the sprintf() function in an RNAMotif descriptor is not\nimplemented; this information is instead packed into the score tag,\nwhich can be accessed by using the following:\n\n  my ($score) = $feature->score; \n\nIf the score contains anything besides a digit, it will throw a\nwarning that sprintf() may have been used.\nSeveral values have also been added in the 'tag' hash.  These can be\naccessed using the following syntax:\n\n  my ($entry) = $feature->get_Annotations('secstructure');\n\nAdded tags are : \n\n   descline     - entire description line (in case the regex used for\n                  sequence ID doesn't adequately catch the name\n   descfile     - name of the descriptor file (may include path to file)\n   secstrucure  - contains structural information from the descriptor\n                  used as a query\n   sequence     - sequence of motif, separated by spaces according to\n                  matches to the structure in the descriptor (in\n                  SecStructure).\n\nSee t/RNAMotif.t for example usage.\n\nThe clean_features method can also be used to return a list of seqfeatures (in a\nBio::SeqFeature::Collection object) that are within a particular region.   RNAMotif\nis prone with some descriptors to returning redundant hits; an attempt to rectify\nthis problem is attempted with RNAMotif's companion program rmprune, which returns\nthe structure with the longest helices (and theoretically the best scoring structure).\nHowever, this doesn't take into account alternative foldings which may score better.\nThis method adds a bit more flexibility, giving the user the ability to screen folds\nbased on where the feature is found and the score.  Passing a positive integer x\nscreens SeqFeatures based on the highest score within x bp, while a negative integer\nscreens based on the lowest score. So, to return the highest scoring values within\n20 bp (likely using an arbitrary scroing system in the SCORE section of a descriptor\nfile), one could use:\n\n  $list = $obj->clean_features(20); \n\n... and returning the lowest scoring structures within the same region (when the\nscore is based on calculated free energies from efn2) can be accomplished\nby the following:\n\n  $list = $obj->clean_features(-20);\n\nIf you wanted the best feature in a sequence, you could set this to a large number,\npreferrably on that exceeds the bases in a sequence\n\n  $list = $obj->clean_features(10000000);\n\nEach seqfeature in the collection can then be acted upon:\n\n  @sf = $list->get_all_features;\n  for my $f (@sf) {\n    # do crazy things here\n  }\n\nAt some point a more complicated feature object may be used to support\nthis data rather than forcing most of the information into tag/value\npairs in a SeqFeature::Generic.  This will hopefully allow for more\nflexible analysis of data (specifically RNA secondary structural\ndata).  It works for now...\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Fields\n\nEmail cjfields-at-uiuc-dot-edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tools::RNAMotif;\nuse strict;\n\nuse Bio::SeqFeature::Generic;\nuse Bio::SeqFeature::Collection;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\nour($MotifTag,$SrcTag,$DescTag) = qw(misc_binding RNAMotif rnamotif);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::RNAMotif->new();\n Function: Builds a new Bio::Tools::RNAMotif object \n Returns : an instance of Bio::Tools::RNAMotif\n Args    : -fh/-file for input filename\n           -motiftag => primary tag used in gene features (default 'misc_binding')\n           -desctag => tag used for display_name name (default 'rnamotif')\n           -srctag  => source tag used in all features (default 'RNAMotif')","parameters":[{"label":"$self"},{"label":"@args"}],"label":"_initialize($self,@args)"}},{"name":"SUPER","containerName":"_initialize","line":179,"kind":12},{"containerName":"_rearrange","name":"SUPER","kind":12,"line":180},{"range":{"end":{"line":216,"character":9999},"start":{"character":0,"line":211}},"containerName":"main::","name":"motif_tag","definition":"sub","line":211,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"motif_tag","line":212,"kind":13},{"name":"$self","containerName":"motif_tag","kind":13,"line":214},{"name":"$self","containerName":"motif_tag","kind":13,"line":215}],"kind":12},{"containerName":"main::","definition":"sub","name":"source_tag","range":{"end":{"line":235,"character":9999},"start":{"line":230,"character":0}},"kind":12,"line":230,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"source_tag","line":231,"kind":13},{"name":"$self","containerName":"source_tag","line":233,"kind":13},{"containerName":"source_tag","name":"$self","kind":13,"line":234}]},{"range":{"start":{"line":253,"character":0},"end":{"character":9999,"line":258}},"containerName":"main::","definition":"sub","name":"desc_tag","line":253,"children":[{"localvar":"my","containerName":"desc_tag","name":"$self","definition":"my","line":254,"kind":13},{"line":256,"kind":13,"name":"$self","containerName":"desc_tag"},{"kind":13,"line":257,"name":"$self","containerName":"desc_tag"}],"kind":12},{"children":[{"definition":"my","name":"$self","containerName":"analysis_method","localvar":"my","kind":13,"line":273},{"name":"$method","containerName":"analysis_method","line":273,"kind":13},{"name":"$method","containerName":"analysis_method","line":274,"kind":13},{"kind":13,"line":274,"containerName":"analysis_method","name":"$method"},{"name":"$self","containerName":"analysis_method","line":275,"kind":13},{"containerName":"analysis_method","name":"throw","kind":12,"line":275},{"kind":13,"line":275,"containerName":"analysis_method","name":"$self"},{"kind":13,"line":277,"containerName":"analysis_method","name":"$self"},{"name":"$method","containerName":"analysis_method","line":277,"kind":13}],"line":271,"kind":12,"signature":{"label":"analysis_method($self,$method)","parameters":[{"label":"$self"},{"label":"$method"}],"documentation":"1;\n# $Id: RNAMotif.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::RNAMotif\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields <cjfields-at-uiuc-dot-edu>\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::RNAMotif - A parser for RNAMotif output\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::RNAMotif;\n  my $parser = Bio::Tools::RNAMotif->new(-file => $rna_output,\n                                        -motiftag => 'protein_bind'\n                                        -desctag => 'TRAP_binding');\n  #parse the results\n  while( my $motif = $parser->next_prediction) {\n    # do something here\n  }\n\n=head1 DESCRIPTION\n\nParses raw RNAMotif output.  RNAMotif uses a RNA profile, consisting\nof sequence and structural elements stored in a descriptor file, to\nsearch for potential motifs in a DNA sequence file.  For more\ninformation, see:\n\nMacke TJ, Ecker DJ, Gutell RR, Gautheret D, Case DA, Sampath R. \nRNAMotif, an RNA secondary structure definition and search algorithm.\nNucleic Acids Res. 2001 Nov 15;29(22):4724-35. \nhttp://www.scripps.edu/mb/case/casegr-sh-3.5.html.\n\nThis module is not currently complete.  As is, it will parse raw\nRNAMotif output (i.e. information not passed through the secondary\nprograms rmfmt or rm2ct) and pack information into\nBio::SeqFeature::Generic objects.  Currently, parsing extra output\nutilized by the sprintf() function in an RNAMotif descriptor is not\nimplemented; this information is instead packed into the score tag,\nwhich can be accessed by using the following:\n\n  my ($score) = $feature->score; \n\nIf the score contains anything besides a digit, it will throw a\nwarning that sprintf() may have been used.\nSeveral values have also been added in the 'tag' hash.  These can be\naccessed using the following syntax:\n\n  my ($entry) = $feature->get_Annotations('secstructure');\n\nAdded tags are : \n\n   descline     - entire description line (in case the regex used for\n                  sequence ID doesn't adequately catch the name\n   descfile     - name of the descriptor file (may include path to file)\n   secstrucure  - contains structural information from the descriptor\n                  used as a query\n   sequence     - sequence of motif, separated by spaces according to\n                  matches to the structure in the descriptor (in\n                  SecStructure).\n\nSee t/RNAMotif.t for example usage.\n\nThe clean_features method can also be used to return a list of seqfeatures (in a\nBio::SeqFeature::Collection object) that are within a particular region.   RNAMotif\nis prone with some descriptors to returning redundant hits; an attempt to rectify\nthis problem is attempted with RNAMotif's companion program rmprune, which returns\nthe structure with the longest helices (and theoretically the best scoring structure).\nHowever, this doesn't take into account alternative foldings which may score better.\nThis method adds a bit more flexibility, giving the user the ability to screen folds\nbased on where the feature is found and the score.  Passing a positive integer x\nscreens SeqFeatures based on the highest score within x bp, while a negative integer\nscreens based on the lowest score. So, to return the highest scoring values within\n20 bp (likely using an arbitrary scroing system in the SCORE section of a descriptor\nfile), one could use:\n\n  $list = $obj->clean_features(20); \n\n... and returning the lowest scoring structures within the same region (when the\nscore is based on calculated free energies from efn2) can be accomplished\nby the following:\n\n  $list = $obj->clean_features(-20);\n\nIf you wanted the best feature in a sequence, you could set this to a large number,\npreferrably on that exceeds the bases in a sequence\n\n  $list = $obj->clean_features(10000000);\n\nEach seqfeature in the collection can then be acted upon:\n\n  @sf = $list->get_all_features;\n  for my $f (@sf) {\n    # do crazy things here\n  }\n\nAt some point a more complicated feature object may be used to support\nthis data rather than forcing most of the information into tag/value\npairs in a SeqFeature::Generic.  This will hopefully allow for more\nflexible analysis of data (specifically RNA secondary structural\ndata).  It works for now...\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Fields\n\nEmail cjfields-at-uiuc-dot-edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tools::RNAMotif;\nuse strict;\n\nuse Bio::SeqFeature::Generic;\nuse Bio::SeqFeature::Collection;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\nour($MotifTag,$SrcTag,$DescTag) = qw(misc_binding RNAMotif rnamotif);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::RNAMotif->new();\n Function: Builds a new Bio::Tools::RNAMotif object \n Returns : an instance of Bio::Tools::RNAMotif\n Args    : -fh/-file for input filename\n           -motiftag => primary tag used in gene features (default 'misc_binding')\n           -desctag => tag used for display_name name (default 'rnamotif')\n           -srctag  => source tag used in all features (default 'RNAMotif')\n\n\nsub _initialize {\n  my($self,@args) = @_;\n  $self->warn('Use of this module is deprecated.  Use Bio::SearchIO::rnamotif instead');\n  $self->SUPER::_initialize(@args);\n  my ($motiftag,$desctag,$srctag) =  $self->SUPER::_rearrange([qw(MOTIFTAG\n                                                                  DESCTAG\n                                                                  SRCTAG\n                                 )],\n                                  @args);\n  $self->motif_tag(defined $motiftag ? $motiftag : $MotifTag);\n  $self->source_tag(defined $srctag ? $srctag : $SrcTag);\n  $self->desc_tag(defined $desctag ? $desctag : $DescTag);\n  $self->{'_sec_structure' => '',\n          '_dfile' => ''};\n}\n\n=head2 motif_tag\n\n Title   : motif_tag\n Usage   : $obj->motif_tag($newval)\n Function: Get/Set the value used for 'motif_tag', which is used for setting the\n           primary_tag.\n           Default is 'misc_binding' as set by the global $MotifTag.\n           'misc_binding' is used here because a conserved RNA motif is capable\n           of binding proteins (regulatory proteins), antisense RNA (siRNA),\n           small molecules (riboswitches), or nothing at all (tRNA,\n           terminators, etc.).  It is recommended that this be changed to other\n           tags ('misc_RNA', 'protein_binding', 'tRNA', etc.) where appropriate.\n           For more information, see:\n           http://www.ncbi.nlm.nih.gov/collab/FT/index.html\n Returns : value of motif_tag (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub motif_tag{\n    my $self = shift;\n\n    return $self->{'motif_tag'} = shift if @_;\n    return $self->{'motif_tag'};\n}\n\n=head2 source_tag\n\n Title   : source_tag\n Usage   : $obj->source_tag($newval)\n Function: Get/Set the value used for the 'source_tag'.\n           Default is 'RNAMotif' as set by the global $SrcTag\n Returns : value of source_tag (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub source_tag{\n    my $self = shift;\n\n    return $self->{'source_tag'} = shift if @_;\n    return $self->{'source_tag'};\n}\n\n\n=head2 desc_tag\n\n Title   : desc_tag\n Usage   : $obj->desc_tag($newval)\n Function: Get/Set the value used for the query motif.  This will be placed in\n           the tag '-display_name'.  Default is 'rnamotif' as set by the global\n           $DescTag.  Use this to manually set the descriptor (motif searched for).\n           Since there is no way for this module to tell what the motif is from the\n           name of the descriptor file or the RNAMotif output, this should\n           be set every time an RNAMotif object is instantiated for clarity\n Returns : value of exon_tag (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub desc_tag{\n    my $self = shift;\n\n    return $self->{'desc_tag'} = shift if @_;\n    return $self->{'desc_tag'};\n}\n\n=head2 analysis_method\n\n Usage     : $obj->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /RNAMotif/i.\n Returns   : String\n Argument  : n/a"},"detail":"($self,$method)","definition":"sub","containerName":"main::","range":{"end":{"line":278,"character":9999},"start":{"line":271,"character":0}},"name":"analysis_method"},{"name":"SUPER","containerName":"analysis_method","line":277,"kind":12},{"range":{"start":{"character":0,"line":297},"end":{"line":303,"character":9999}},"name":"next_feature","line":297,"children":[{"kind":13,"line":298,"name":"$self","definition":"my","containerName":"next_feature","localvar":"my"},{"kind":13,"line":298,"name":"@args","containerName":"next_feature"},{"name":"$self","containerName":"next_feature","line":302,"kind":13},{"kind":12,"line":302,"name":"next_prediction","containerName":"next_feature"},{"containerName":"next_feature","name":"@args","line":302,"kind":13}],"kind":12,"detail":"($self,@args)","signature":{"documentation":"1;\n# $Id: RNAMotif.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::RNAMotif\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields <cjfields-at-uiuc-dot-edu>\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::RNAMotif - A parser for RNAMotif output\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::RNAMotif;\n  my $parser = Bio::Tools::RNAMotif->new(-file => $rna_output,\n                                        -motiftag => 'protein_bind'\n                                        -desctag => 'TRAP_binding');\n  #parse the results\n  while( my $motif = $parser->next_prediction) {\n    # do something here\n  }\n\n=head1 DESCRIPTION\n\nParses raw RNAMotif output.  RNAMotif uses a RNA profile, consisting\nof sequence and structural elements stored in a descriptor file, to\nsearch for potential motifs in a DNA sequence file.  For more\ninformation, see:\n\nMacke TJ, Ecker DJ, Gutell RR, Gautheret D, Case DA, Sampath R. \nRNAMotif, an RNA secondary structure definition and search algorithm.\nNucleic Acids Res. 2001 Nov 15;29(22):4724-35. \nhttp://www.scripps.edu/mb/case/casegr-sh-3.5.html.\n\nThis module is not currently complete.  As is, it will parse raw\nRNAMotif output (i.e. information not passed through the secondary\nprograms rmfmt or rm2ct) and pack information into\nBio::SeqFeature::Generic objects.  Currently, parsing extra output\nutilized by the sprintf() function in an RNAMotif descriptor is not\nimplemented; this information is instead packed into the score tag,\nwhich can be accessed by using the following:\n\n  my ($score) = $feature->score; \n\nIf the score contains anything besides a digit, it will throw a\nwarning that sprintf() may have been used.\nSeveral values have also been added in the 'tag' hash.  These can be\naccessed using the following syntax:\n\n  my ($entry) = $feature->get_Annotations('secstructure');\n\nAdded tags are : \n\n   descline     - entire description line (in case the regex used for\n                  sequence ID doesn't adequately catch the name\n   descfile     - name of the descriptor file (may include path to file)\n   secstrucure  - contains structural information from the descriptor\n                  used as a query\n   sequence     - sequence of motif, separated by spaces according to\n                  matches to the structure in the descriptor (in\n                  SecStructure).\n\nSee t/RNAMotif.t for example usage.\n\nThe clean_features method can also be used to return a list of seqfeatures (in a\nBio::SeqFeature::Collection object) that are within a particular region.   RNAMotif\nis prone with some descriptors to returning redundant hits; an attempt to rectify\nthis problem is attempted with RNAMotif's companion program rmprune, which returns\nthe structure with the longest helices (and theoretically the best scoring structure).\nHowever, this doesn't take into account alternative foldings which may score better.\nThis method adds a bit more flexibility, giving the user the ability to screen folds\nbased on where the feature is found and the score.  Passing a positive integer x\nscreens SeqFeatures based on the highest score within x bp, while a negative integer\nscreens based on the lowest score. So, to return the highest scoring values within\n20 bp (likely using an arbitrary scroing system in the SCORE section of a descriptor\nfile), one could use:\n\n  $list = $obj->clean_features(20); \n\n... and returning the lowest scoring structures within the same region (when the\nscore is based on calculated free energies from efn2) can be accomplished\nby the following:\n\n  $list = $obj->clean_features(-20);\n\nIf you wanted the best feature in a sequence, you could set this to a large number,\npreferrably on that exceeds the bases in a sequence\n\n  $list = $obj->clean_features(10000000);\n\nEach seqfeature in the collection can then be acted upon:\n\n  @sf = $list->get_all_features;\n  for my $f (@sf) {\n    # do crazy things here\n  }\n\nAt some point a more complicated feature object may be used to support\nthis data rather than forcing most of the information into tag/value\npairs in a SeqFeature::Generic.  This will hopefully allow for more\nflexible analysis of data (specifically RNA secondary structural\ndata).  It works for now...\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Fields\n\nEmail cjfields-at-uiuc-dot-edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tools::RNAMotif;\nuse strict;\n\nuse Bio::SeqFeature::Generic;\nuse Bio::SeqFeature::Collection;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\nour($MotifTag,$SrcTag,$DescTag) = qw(misc_binding RNAMotif rnamotif);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::RNAMotif->new();\n Function: Builds a new Bio::Tools::RNAMotif object \n Returns : an instance of Bio::Tools::RNAMotif\n Args    : -fh/-file for input filename\n           -motiftag => primary tag used in gene features (default 'misc_binding')\n           -desctag => tag used for display_name name (default 'rnamotif')\n           -srctag  => source tag used in all features (default 'RNAMotif')\n\n\nsub _initialize {\n  my($self,@args) = @_;\n  $self->warn('Use of this module is deprecated.  Use Bio::SearchIO::rnamotif instead');\n  $self->SUPER::_initialize(@args);\n  my ($motiftag,$desctag,$srctag) =  $self->SUPER::_rearrange([qw(MOTIFTAG\n                                                                  DESCTAG\n                                                                  SRCTAG\n                                 )],\n                                  @args);\n  $self->motif_tag(defined $motiftag ? $motiftag : $MotifTag);\n  $self->source_tag(defined $srctag ? $srctag : $SrcTag);\n  $self->desc_tag(defined $desctag ? $desctag : $DescTag);\n  $self->{'_sec_structure' => '',\n          '_dfile' => ''};\n}\n\n=head2 motif_tag\n\n Title   : motif_tag\n Usage   : $obj->motif_tag($newval)\n Function: Get/Set the value used for 'motif_tag', which is used for setting the\n           primary_tag.\n           Default is 'misc_binding' as set by the global $MotifTag.\n           'misc_binding' is used here because a conserved RNA motif is capable\n           of binding proteins (regulatory proteins), antisense RNA (siRNA),\n           small molecules (riboswitches), or nothing at all (tRNA,\n           terminators, etc.).  It is recommended that this be changed to other\n           tags ('misc_RNA', 'protein_binding', 'tRNA', etc.) where appropriate.\n           For more information, see:\n           http://www.ncbi.nlm.nih.gov/collab/FT/index.html\n Returns : value of motif_tag (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub motif_tag{\n    my $self = shift;\n\n    return $self->{'motif_tag'} = shift if @_;\n    return $self->{'motif_tag'};\n}\n\n=head2 source_tag\n\n Title   : source_tag\n Usage   : $obj->source_tag($newval)\n Function: Get/Set the value used for the 'source_tag'.\n           Default is 'RNAMotif' as set by the global $SrcTag\n Returns : value of source_tag (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub source_tag{\n    my $self = shift;\n\n    return $self->{'source_tag'} = shift if @_;\n    return $self->{'source_tag'};\n}\n\n\n=head2 desc_tag\n\n Title   : desc_tag\n Usage   : $obj->desc_tag($newval)\n Function: Get/Set the value used for the query motif.  This will be placed in\n           the tag '-display_name'.  Default is 'rnamotif' as set by the global\n           $DescTag.  Use this to manually set the descriptor (motif searched for).\n           Since there is no way for this module to tell what the motif is from the\n           name of the descriptor file or the RNAMotif output, this should\n           be set every time an RNAMotif object is instantiated for clarity\n Returns : value of exon_tag (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub desc_tag{\n    my $self = shift;\n\n    return $self->{'desc_tag'} = shift if @_;\n    return $self->{'desc_tag'};\n}\n\n=head2 analysis_method\n\n Usage     : $obj->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /RNAMotif/i.\n Returns   : String\n Argument  : n/a\n\n\n#-------------\nsub analysis_method { \n#-------------\n    my ($self, $method) = @_;  \n    if($method && ($method !~ /RNAMotif/i)) {\n    $self->throw(\"method $method not supported in \" . ref($self));\n    }\n    return $self->SUPER::analysis_method($method);\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : while($gene = $obj->next_feature()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the RNAMotif result\n           file. Call this method repeatedly until FALSE is returned.\n           The returned object is actually a SeqFeatureI implementing object.\n           This method is required for classes implementing the\n           SeqAnalysisParserI interface, and is merely an alias for \n           next_prediction() at present.\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    : None (at present)","parameters":[{"label":"$self"},{"label":"@args"}],"label":"next_feature($self,@args)"},"containerName":"main::","definition":"sub"},{"range":{"start":{"line":318,"character":0},"end":{"character":9999,"line":375}},"name":"next_prediction","detail":"($self)","signature":{"label":"next_prediction($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: RNAMotif.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::RNAMotif\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields <cjfields-at-uiuc-dot-edu>\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::RNAMotif - A parser for RNAMotif output\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::RNAMotif;\n  my $parser = Bio::Tools::RNAMotif->new(-file => $rna_output,\n                                        -motiftag => 'protein_bind'\n                                        -desctag => 'TRAP_binding');\n  #parse the results\n  while( my $motif = $parser->next_prediction) {\n    # do something here\n  }\n\n=head1 DESCRIPTION\n\nParses raw RNAMotif output.  RNAMotif uses a RNA profile, consisting\nof sequence and structural elements stored in a descriptor file, to\nsearch for potential motifs in a DNA sequence file.  For more\ninformation, see:\n\nMacke TJ, Ecker DJ, Gutell RR, Gautheret D, Case DA, Sampath R. \nRNAMotif, an RNA secondary structure definition and search algorithm.\nNucleic Acids Res. 2001 Nov 15;29(22):4724-35. \nhttp://www.scripps.edu/mb/case/casegr-sh-3.5.html.\n\nThis module is not currently complete.  As is, it will parse raw\nRNAMotif output (i.e. information not passed through the secondary\nprograms rmfmt or rm2ct) and pack information into\nBio::SeqFeature::Generic objects.  Currently, parsing extra output\nutilized by the sprintf() function in an RNAMotif descriptor is not\nimplemented; this information is instead packed into the score tag,\nwhich can be accessed by using the following:\n\n  my ($score) = $feature->score; \n\nIf the score contains anything besides a digit, it will throw a\nwarning that sprintf() may have been used.\nSeveral values have also been added in the 'tag' hash.  These can be\naccessed using the following syntax:\n\n  my ($entry) = $feature->get_Annotations('secstructure');\n\nAdded tags are : \n\n   descline     - entire description line (in case the regex used for\n                  sequence ID doesn't adequately catch the name\n   descfile     - name of the descriptor file (may include path to file)\n   secstrucure  - contains structural information from the descriptor\n                  used as a query\n   sequence     - sequence of motif, separated by spaces according to\n                  matches to the structure in the descriptor (in\n                  SecStructure).\n\nSee t/RNAMotif.t for example usage.\n\nThe clean_features method can also be used to return a list of seqfeatures (in a\nBio::SeqFeature::Collection object) that are within a particular region.   RNAMotif\nis prone with some descriptors to returning redundant hits; an attempt to rectify\nthis problem is attempted with RNAMotif's companion program rmprune, which returns\nthe structure with the longest helices (and theoretically the best scoring structure).\nHowever, this doesn't take into account alternative foldings which may score better.\nThis method adds a bit more flexibility, giving the user the ability to screen folds\nbased on where the feature is found and the score.  Passing a positive integer x\nscreens SeqFeatures based on the highest score within x bp, while a negative integer\nscreens based on the lowest score. So, to return the highest scoring values within\n20 bp (likely using an arbitrary scroing system in the SCORE section of a descriptor\nfile), one could use:\n\n  $list = $obj->clean_features(20); \n\n... and returning the lowest scoring structures within the same region (when the\nscore is based on calculated free energies from efn2) can be accomplished\nby the following:\n\n  $list = $obj->clean_features(-20);\n\nIf you wanted the best feature in a sequence, you could set this to a large number,\npreferrably on that exceeds the bases in a sequence\n\n  $list = $obj->clean_features(10000000);\n\nEach seqfeature in the collection can then be acted upon:\n\n  @sf = $list->get_all_features;\n  for my $f (@sf) {\n    # do crazy things here\n  }\n\nAt some point a more complicated feature object may be used to support\nthis data rather than forcing most of the information into tag/value\npairs in a SeqFeature::Generic.  This will hopefully allow for more\nflexible analysis of data (specifically RNA secondary structural\ndata).  It works for now...\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Fields\n\nEmail cjfields-at-uiuc-dot-edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tools::RNAMotif;\nuse strict;\n\nuse Bio::SeqFeature::Generic;\nuse Bio::SeqFeature::Collection;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\nour($MotifTag,$SrcTag,$DescTag) = qw(misc_binding RNAMotif rnamotif);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::RNAMotif->new();\n Function: Builds a new Bio::Tools::RNAMotif object \n Returns : an instance of Bio::Tools::RNAMotif\n Args    : -fh/-file for input filename\n           -motiftag => primary tag used in gene features (default 'misc_binding')\n           -desctag => tag used for display_name name (default 'rnamotif')\n           -srctag  => source tag used in all features (default 'RNAMotif')\n\n\nsub _initialize {\n  my($self,@args) = @_;\n  $self->warn('Use of this module is deprecated.  Use Bio::SearchIO::rnamotif instead');\n  $self->SUPER::_initialize(@args);\n  my ($motiftag,$desctag,$srctag) =  $self->SUPER::_rearrange([qw(MOTIFTAG\n                                                                  DESCTAG\n                                                                  SRCTAG\n                                 )],\n                                  @args);\n  $self->motif_tag(defined $motiftag ? $motiftag : $MotifTag);\n  $self->source_tag(defined $srctag ? $srctag : $SrcTag);\n  $self->desc_tag(defined $desctag ? $desctag : $DescTag);\n  $self->{'_sec_structure' => '',\n          '_dfile' => ''};\n}\n\n=head2 motif_tag\n\n Title   : motif_tag\n Usage   : $obj->motif_tag($newval)\n Function: Get/Set the value used for 'motif_tag', which is used for setting the\n           primary_tag.\n           Default is 'misc_binding' as set by the global $MotifTag.\n           'misc_binding' is used here because a conserved RNA motif is capable\n           of binding proteins (regulatory proteins), antisense RNA (siRNA),\n           small molecules (riboswitches), or nothing at all (tRNA,\n           terminators, etc.).  It is recommended that this be changed to other\n           tags ('misc_RNA', 'protein_binding', 'tRNA', etc.) where appropriate.\n           For more information, see:\n           http://www.ncbi.nlm.nih.gov/collab/FT/index.html\n Returns : value of motif_tag (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub motif_tag{\n    my $self = shift;\n\n    return $self->{'motif_tag'} = shift if @_;\n    return $self->{'motif_tag'};\n}\n\n=head2 source_tag\n\n Title   : source_tag\n Usage   : $obj->source_tag($newval)\n Function: Get/Set the value used for the 'source_tag'.\n           Default is 'RNAMotif' as set by the global $SrcTag\n Returns : value of source_tag (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub source_tag{\n    my $self = shift;\n\n    return $self->{'source_tag'} = shift if @_;\n    return $self->{'source_tag'};\n}\n\n\n=head2 desc_tag\n\n Title   : desc_tag\n Usage   : $obj->desc_tag($newval)\n Function: Get/Set the value used for the query motif.  This will be placed in\n           the tag '-display_name'.  Default is 'rnamotif' as set by the global\n           $DescTag.  Use this to manually set the descriptor (motif searched for).\n           Since there is no way for this module to tell what the motif is from the\n           name of the descriptor file or the RNAMotif output, this should\n           be set every time an RNAMotif object is instantiated for clarity\n Returns : value of exon_tag (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub desc_tag{\n    my $self = shift;\n\n    return $self->{'desc_tag'} = shift if @_;\n    return $self->{'desc_tag'};\n}\n\n=head2 analysis_method\n\n Usage     : $obj->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /RNAMotif/i.\n Returns   : String\n Argument  : n/a\n\n\n#-------------\nsub analysis_method { \n#-------------\n    my ($self, $method) = @_;  \n    if($method && ($method !~ /RNAMotif/i)) {\n    $self->throw(\"method $method not supported in \" . ref($self));\n    }\n    return $self->SUPER::analysis_method($method);\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : while($gene = $obj->next_feature()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the RNAMotif result\n           file. Call this method repeatedly until FALSE is returned.\n           The returned object is actually a SeqFeatureI implementing object.\n           This method is required for classes implementing the\n           SeqAnalysisParserI interface, and is merely an alias for \n           next_prediction() at present.\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    : None (at present)\n\n\nsub next_feature {\n    my ($self,@args) = @_;\n    # even though next_prediction doesn't expect any args (and this method\n    # does neither), we pass on args in order to be prepared if this changes\n    # ever\n    return $self->next_prediction(@args);\n}\n\n=head2 next_prediction\n\n Title   : next_prediction\n Usage   : while($gene = $obj->next_prediction()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the RNAMotif result\n           file. Call this method repeatedly until FALSE is returned.\n Returns : A Bio::SeqFeature::Generic object\n Args    : None (at present)"},"containerName":"main::","definition":"sub","line":318,"children":[{"line":319,"kind":13,"localvar":"my","containerName":"next_prediction","name":"$self","definition":"my"},{"kind":13,"line":320,"name":"$motiftag","definition":"my","containerName":"next_prediction","localvar":"my"},{"kind":13,"line":320,"name":"$srctag","containerName":"next_prediction"},{"name":"$desctag","containerName":"next_prediction","line":320,"kind":13},{"kind":13,"line":320,"containerName":"next_prediction","name":"$self"},{"kind":12,"line":320,"name":"motif_tag","containerName":"next_prediction"},{"name":"$self","containerName":"next_prediction","kind":13,"line":321},{"containerName":"next_prediction","name":"source_tag","line":321,"kind":12},{"name":"$self","containerName":"next_prediction","line":322,"kind":13},{"line":322,"kind":12,"containerName":"next_prediction","name":"desc_tag"},{"kind":13,"line":323,"containerName":"next_prediction","name":"$score","definition":"my","localvar":"my"},{"name":"$strand","containerName":"next_prediction","kind":13,"line":323},{"kind":13,"line":323,"containerName":"next_prediction","name":"$start"},{"line":323,"kind":13,"containerName":"next_prediction","name":"$length"},{"kind":13,"line":323,"containerName":"next_prediction","name":"$sequence"},{"line":323,"kind":13,"containerName":"next_prediction","name":"$end"},{"line":323,"kind":13,"containerName":"next_prediction","name":"$seqid"},{"containerName":"next_prediction","name":"$description","line":323,"kind":13},{"name":"$self","containerName":"next_prediction","line":324,"kind":13},{"name":"_readline","containerName":"next_prediction","line":324,"kind":12},{"kind":13,"line":327,"containerName":"next_prediction","name":"$self"},{"kind":13,"line":330,"containerName":"next_prediction","name":"$self"},{"containerName":"next_prediction","name":"$self","kind":13,"line":332},{"kind":12,"line":332,"containerName":"next_prediction","name":"_readline"},{"kind":13,"line":335,"containerName":"next_prediction","name":"$seqid"},{"line":336,"kind":13,"name":"$description","containerName":"next_prediction"},{"containerName":"next_prediction","name":"$seqid","line":337,"kind":13},{"line":338,"kind":13,"containerName":"next_prediction","name":"$seqid"},{"containerName":"next_prediction","name":"$score","line":350,"kind":13},{"kind":13,"line":350,"containerName":"next_prediction","name":"$strand"},{"containerName":"next_prediction","name":"$start","line":350,"kind":13},{"line":350,"kind":13,"name":"$length","containerName":"next_prediction"},{"name":"$sequence","containerName":"next_prediction","kind":13,"line":350},{"containerName":"next_prediction","name":"$end","kind":13,"line":350},{"kind":13,"line":352,"containerName":"next_prediction","name":"$strand"},{"containerName":"next_prediction","name":"$end","kind":13,"line":353},{"containerName":"next_prediction","name":"$start","kind":13,"line":353},{"containerName":"next_prediction","name":"$length","line":353,"kind":13},{"line":354,"kind":13,"name":"$strand","containerName":"next_prediction"},{"kind":13,"line":356,"containerName":"next_prediction","name":"$end"},{"containerName":"next_prediction","name":"$start","kind":13,"line":356},{"line":356,"kind":13,"containerName":"next_prediction","name":"$length"},{"containerName":"next_prediction","name":"$start","line":357,"kind":13},{"name":"$end","containerName":"next_prediction","line":357,"kind":13},{"kind":13,"line":357,"containerName":"next_prediction","name":"$strand"},{"kind":13,"line":357,"name":"$end","containerName":"next_prediction"},{"containerName":"next_prediction","name":"$start","line":357,"kind":13},{"line":359,"kind":13,"localvar":"my","containerName":"next_prediction","definition":"my","name":"$gene"},{"name":"new","containerName":"next_prediction","kind":12,"line":359},{"name":"$seqid","containerName":"next_prediction","kind":13,"line":359},{"name":"$start","containerName":"next_prediction","kind":13,"line":360},{"containerName":"next_prediction","name":"$end","line":361,"kind":13},{"containerName":"next_prediction","name":"$strand","kind":13,"line":362},{"name":"$score","containerName":"next_prediction","line":363,"kind":13},{"kind":13,"line":364,"name":"$motiftag","containerName":"next_prediction"},{"name":"$srctag","containerName":"next_prediction","line":365,"kind":13},{"kind":13,"line":366,"containerName":"next_prediction","name":"$desctag"},{"line":368,"kind":13,"containerName":"next_prediction","name":"$description"},{"line":369,"kind":13,"name":"$self","containerName":"next_prediction"},{"kind":13,"line":370,"name":"$self","containerName":"next_prediction"},{"kind":13,"line":371,"name":"$sequence","containerName":"next_prediction"},{"name":"$gene","containerName":"next_prediction","kind":13,"line":372}],"kind":12},{"containerName":"SeqFeature::Generic","name":"Bio","kind":12,"line":359},{"definition":"sub","name":"clean_features","containerName":"main::","range":{"end":{"character":9999,"line":425},"start":{"character":0,"line":388}},"kind":12,"children":[{"containerName":"clean_features","name":"$self","definition":"my","localvar":"my","kind":13,"line":389},{"localvar":"my","containerName":"clean_features","definition":"my","name":"$bp","line":390,"kind":13},{"name":"$self","containerName":"clean_features","kind":13,"line":391},{"name":"throw","containerName":"clean_features","line":391,"kind":12},{"kind":13,"line":391,"name":"$bp","containerName":"clean_features"},{"name":"$self","containerName":"clean_features","line":392,"kind":13},{"kind":12,"line":392,"name":"throw","containerName":"clean_features"},{"containerName":"clean_features","name":"$bp","kind":13,"line":392},{"kind":13,"line":392,"name":"$bp","containerName":"clean_features"},{"containerName":"clean_features","name":"$b","definition":"my","localvar":"my","kind":13,"line":393},{"line":393,"kind":13,"name":"$sf2","containerName":"clean_features"},{"containerName":"clean_features","name":"@list","definition":"my","localvar":"my","kind":13,"line":394},{"localvar":"my","name":"@features","definition":"my","containerName":"clean_features","line":395,"kind":13},{"line":396,"kind":13,"localvar":"my","containerName":"clean_features","name":"$pred","definition":"my"},{"containerName":"clean_features","name":"$self","line":396,"kind":13},{"name":"next_prediction","containerName":"clean_features","line":396,"kind":12},{"containerName":"clean_features","name":"@features","line":397,"kind":13},{"kind":13,"line":397,"name":"$pred","containerName":"clean_features"},{"kind":13,"line":399,"name":"@features","containerName":"clean_features"},{"line":400,"kind":13,"containerName":"clean_features","name":"$b"},{"line":400,"kind":13,"name":"@features","containerName":"clean_features"},{"name":"$b","containerName":"clean_features","line":400,"kind":13},{"name":"$sf2","containerName":"clean_features","kind":13,"line":401},{"name":"@features","containerName":"clean_features","kind":13,"line":401},{"kind":13,"line":403,"containerName":"clean_features","name":"$sf2"},{"line":404,"kind":13,"containerName":"clean_features","name":"$b"},{"kind":12,"line":404,"name":"seq_id","containerName":"clean_features"},{"containerName":"clean_features","name":"$sf2","line":404,"kind":13},{"line":404,"kind":12,"name":"seq_id","containerName":"clean_features"},{"kind":13,"line":406,"containerName":"clean_features","name":"$b"},{"containerName":"clean_features","name":"start","kind":12,"line":406},{"containerName":"clean_features","name":"$sf2","line":406,"kind":13},{"line":406,"kind":12,"containerName":"clean_features","name":"start"},{"name":"$bp","containerName":"clean_features","kind":13,"line":406},{"line":408,"kind":13,"name":"$bp","containerName":"clean_features"},{"kind":13,"line":408,"name":"$b","containerName":"clean_features"},{"kind":12,"line":408,"containerName":"clean_features","name":"score"},{"kind":13,"line":408,"name":"$sf2","containerName":"clean_features"},{"kind":12,"line":408,"name":"score","containerName":"clean_features"},{"line":409,"kind":13,"name":"$bp","containerName":"clean_features"},{"containerName":"clean_features","name":"$b","line":409,"kind":13},{"name":"score","containerName":"clean_features","line":409,"kind":12},{"name":"$sf2","containerName":"clean_features","line":409,"kind":13},{"line":409,"kind":12,"containerName":"clean_features","name":"score"},{"containerName":"clean_features","name":"$b","line":410,"kind":13},{"name":"$sf2","containerName":"clean_features","kind":13,"line":410},{"kind":13,"line":416,"name":"@list","containerName":"clean_features"},{"kind":13,"line":416,"containerName":"clean_features","name":"$b"},{"name":"$b","containerName":"clean_features","line":417,"kind":13},{"kind":13,"line":417,"name":"$sf2","containerName":"clean_features"},{"containerName":"clean_features","name":"@list","line":421,"kind":13},{"containerName":"clean_features","name":"$b","line":421,"kind":13},{"name":"$b","containerName":"clean_features","line":421,"kind":13},{"kind":13,"line":422,"name":"$col","definition":"my","containerName":"clean_features","localvar":"my"},{"name":"new","containerName":"clean_features","kind":12,"line":422},{"kind":13,"line":423,"name":"$col","containerName":"clean_features"},{"line":423,"kind":12,"name":"add_features","containerName":"clean_features"},{"containerName":"clean_features","name":"@list","kind":13,"line":423},{"line":424,"kind":13,"containerName":"clean_features","name":"$col"}],"line":388},{"name":"Bio","containerName":"SeqFeature::Collection","kind":12,"line":422}]}