{"vars":[{"kind":2,"line":89,"name":"base","containerName":""},{"line":91,"children":[{"kind":13,"line":92,"containerName":"_initialize_state","name":"$self","definition":"my","localvar":"my"},{"name":"@args","containerName":"_initialize_state","kind":13,"line":92},{"kind":13,"line":95,"containerName":"_initialize_state","name":"$self"},{"containerName":"_initialize_state","name":"@args","kind":13,"line":95},{"line":98,"kind":13,"containerName":"_initialize_state","name":"$self"},{"name":"$self","containerName":"_initialize_state","line":99,"kind":13},{"name":"$self","containerName":"_initialize_state","line":101,"kind":13},{"name":"$self","containerName":"_initialize_state","line":103,"kind":13}],"kind":12,"detail":"($self,@args)","signature":{"documentation":"","parameters":[{"label":"$self"},{"label":"@args"}],"label":"_initialize_state($self,@args)"},"containerName":"main::","definition":"sub","range":{"start":{"character":0,"line":91},"end":{"line":104,"character":9999}},"name":"_initialize_state"},{"containerName":"_initialize_state","name":"SUPER","line":95,"kind":12},{"range":{"start":{"character":0,"line":117},"end":{"character":9999,"line":124}},"name":"analysis_method","detail":"($self,$method)","signature":{"parameters":[{"label":"$self"},{"label":"$method"}],"documentation":"1;\n# BioPerl module for Bio::Tools::Pseudowise\n#\n# $Id: Pseudowise.pm 16123 2009-09-17 12:57:27Z cjfields $\n# \n# Copyright Jason Stajich, Fugu Team \n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Pseudowise - Results of one Pseudowise run\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::Pseudowise;\n\n  my $parser = Bio::Tools::Pseudowise->new(-file=>\"pw.out\");\n  while(my $feat = $parser->next_result){\n      push @feat, $feat;\n  }\n\n=head1 DESCRIPTION\n\nPseudowise is a pseudogene prediction program written by Ewan Birney\nas part of the Wise Package. This module is the parser for the output\nof the program.\n\nhttp://www.sanger.ac.uk/software/wise2\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nPrevious committed by the Fugu Team \n\nRe-written by Jason Stajich jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. \nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Pseudowise;\nuse strict;\nuse Symbol;\n\nuse Bio::Root::Root;\nuse Bio::SeqFeature::Generic;\nuse Bio::SeqFeature::Gene::Exon;\nuse Bio::SeqFeature::FeaturePair;\nuse Bio::SeqFeature::Gene::Transcript;\nuse Bio::SeqFeature::Gene::GeneStructure;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\nsub _initialize_state {\n    my ($self,@args) = @_;\n\n    # first call the inherited method!\n    $self->SUPER::_initialize_state(@args);\n\n    # our private state variables\n    $self->{'_preds_parsed'} = 0;\n    $self->{'_has_cds'} = 0;\n    # array of pre-parsed predictions\n    $self->{'_preds'} = [];\n    # seq stack\n    $self->{'_seqstack'} = [];\n}\n\n=head2 analysis_method\n\n Usage     : $pseudowise->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /pseudowise/i.\n Returns   : String\n Argument  : n/a","label":"analysis_method($self,$method)"},"containerName":"main::","definition":"sub","line":117,"children":[{"containerName":"analysis_method","name":"$self","definition":"my","localvar":"my","kind":13,"line":119},{"containerName":"analysis_method","name":"$method","line":119,"kind":13},{"containerName":"analysis_method","name":"$method","line":120,"kind":13},{"kind":13,"line":120,"containerName":"analysis_method","name":"$method"},{"kind":13,"line":121,"name":"$self","containerName":"analysis_method"},{"line":121,"kind":12,"containerName":"analysis_method","name":"throw"},{"name":"$self","containerName":"analysis_method","line":121,"kind":13},{"name":"$self","containerName":"analysis_method","kind":13,"line":123},{"name":"$method","containerName":"analysis_method","kind":13,"line":123}],"kind":12},{"name":"SUPER","containerName":"analysis_method","kind":12,"line":123},{"kind":12,"line":141,"children":[{"kind":12,"line":142,"name":"next_prediction","containerName":"next_feature"}],"containerName":"main::","name":"next_feature","definition":"sub","range":{"end":{"character":9999,"line":143},"start":{"line":141,"character":0}}},{"children":[{"definition":"my","name":"$self","containerName":"next_prediction","localvar":"my","kind":13,"line":164},{"line":166,"kind":13,"name":"$self","containerName":"next_prediction"},{"line":166,"kind":12,"containerName":"next_prediction","name":"_parse_predictions"},{"line":166,"kind":13,"containerName":"next_prediction","name":"$self"},{"kind":12,"line":166,"containerName":"next_prediction","name":"_predictions_parsed"},{"line":169,"kind":13,"name":"$self","containerName":"next_prediction"},{"containerName":"next_prediction","name":"_prediction","line":169,"kind":12}],"line":163,"kind":12,"signature":{"label":"next_prediction($self)","documentation":"1;\n# BioPerl module for Bio::Tools::Pseudowise\n#\n# $Id: Pseudowise.pm 16123 2009-09-17 12:57:27Z cjfields $\n# \n# Copyright Jason Stajich, Fugu Team \n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Pseudowise - Results of one Pseudowise run\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::Pseudowise;\n\n  my $parser = Bio::Tools::Pseudowise->new(-file=>\"pw.out\");\n  while(my $feat = $parser->next_result){\n      push @feat, $feat;\n  }\n\n=head1 DESCRIPTION\n\nPseudowise is a pseudogene prediction program written by Ewan Birney\nas part of the Wise Package. This module is the parser for the output\nof the program.\n\nhttp://www.sanger.ac.uk/software/wise2\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nPrevious committed by the Fugu Team \n\nRe-written by Jason Stajich jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. \nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Pseudowise;\nuse strict;\nuse Symbol;\n\nuse Bio::Root::Root;\nuse Bio::SeqFeature::Generic;\nuse Bio::SeqFeature::Gene::Exon;\nuse Bio::SeqFeature::FeaturePair;\nuse Bio::SeqFeature::Gene::Transcript;\nuse Bio::SeqFeature::Gene::GeneStructure;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\nsub _initialize_state {\n    my ($self,@args) = @_;\n\n    # first call the inherited method!\n    $self->SUPER::_initialize_state(@args);\n\n    # our private state variables\n    $self->{'_preds_parsed'} = 0;\n    $self->{'_has_cds'} = 0;\n    # array of pre-parsed predictions\n    $self->{'_preds'} = [];\n    # seq stack\n    $self->{'_seqstack'} = [];\n}\n\n=head2 analysis_method\n\n Usage     : $pseudowise->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /pseudowise/i.\n Returns   : String\n Argument  : n/a\n\n\n#-------------\nsub analysis_method { \n#-------------\n    my ($self, $method) = @_;  \n    if($method && ($method !~ /pseudowise/i)) {\n\t$self->throw(\"method $method not supported in \" . ref($self));\n    }\n    return $self->SUPER::analysis_method($method);\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : $seqfeature = $obj->next_feature();\n Function: Returns the next feature available in the analysis result, or\n           undef if there are no more features.\n Example :\n Returns : A Bio::SeqFeatureI implementing object, or undef if there are no\n           more features.\n Args    : none\n\nSee Also  L<Bio::SeqFeatureI>\n\n\nsub next_feature {\n    return shift->next_prediction(@_);\n}\n\n\n=head2 next_prediction\n\n Title   : next_prediction\n Usage   : while($gene = $pseudowise->next_prediction()) {\n                  # do something\n           }\n Function: Returns the gene of the Pseudowise result\n           file. Call this method repeatedly until FALSE is returned.\n\n Example :\n Returns : a Bio::SeqFeature::Generic \n Args    : none\n\nSee Also L<Bio::SeqFeature::Generic>","parameters":[{"label":"$self"}]},"detail":"($self)","definition":"sub","containerName":"main::","range":{"end":{"line":170,"character":9999},"start":{"line":163,"character":0}},"name":"next_prediction"},{"range":{"start":{"line":183,"character":0},"end":{"character":9999,"line":232}},"name":"_parse_predictions","detail":"($self)","signature":{"label":"_parse_predictions($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# BioPerl module for Bio::Tools::Pseudowise\n#\n# $Id: Pseudowise.pm 16123 2009-09-17 12:57:27Z cjfields $\n# \n# Copyright Jason Stajich, Fugu Team \n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Pseudowise - Results of one Pseudowise run\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::Pseudowise;\n\n  my $parser = Bio::Tools::Pseudowise->new(-file=>\"pw.out\");\n  while(my $feat = $parser->next_result){\n      push @feat, $feat;\n  }\n\n=head1 DESCRIPTION\n\nPseudowise is a pseudogene prediction program written by Ewan Birney\nas part of the Wise Package. This module is the parser for the output\nof the program.\n\nhttp://www.sanger.ac.uk/software/wise2\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nPrevious committed by the Fugu Team \n\nRe-written by Jason Stajich jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. \nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Pseudowise;\nuse strict;\nuse Symbol;\n\nuse Bio::Root::Root;\nuse Bio::SeqFeature::Generic;\nuse Bio::SeqFeature::Gene::Exon;\nuse Bio::SeqFeature::FeaturePair;\nuse Bio::SeqFeature::Gene::Transcript;\nuse Bio::SeqFeature::Gene::GeneStructure;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\nsub _initialize_state {\n    my ($self,@args) = @_;\n\n    # first call the inherited method!\n    $self->SUPER::_initialize_state(@args);\n\n    # our private state variables\n    $self->{'_preds_parsed'} = 0;\n    $self->{'_has_cds'} = 0;\n    # array of pre-parsed predictions\n    $self->{'_preds'} = [];\n    # seq stack\n    $self->{'_seqstack'} = [];\n}\n\n=head2 analysis_method\n\n Usage     : $pseudowise->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /pseudowise/i.\n Returns   : String\n Argument  : n/a\n\n\n#-------------\nsub analysis_method { \n#-------------\n    my ($self, $method) = @_;  \n    if($method && ($method !~ /pseudowise/i)) {\n\t$self->throw(\"method $method not supported in \" . ref($self));\n    }\n    return $self->SUPER::analysis_method($method);\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : $seqfeature = $obj->next_feature();\n Function: Returns the next feature available in the analysis result, or\n           undef if there are no more features.\n Example :\n Returns : A Bio::SeqFeatureI implementing object, or undef if there are no\n           more features.\n Args    : none\n\nSee Also  L<Bio::SeqFeatureI>\n\n\nsub next_feature {\n    return shift->next_prediction(@_);\n}\n\n\n=head2 next_prediction\n\n Title   : next_prediction\n Usage   : while($gene = $pseudowise->next_prediction()) {\n                  # do something\n           }\n Function: Returns the gene of the Pseudowise result\n           file. Call this method repeatedly until FALSE is returned.\n\n Example :\n Returns : a Bio::SeqFeature::Generic \n Args    : none\n\nSee Also L<Bio::SeqFeature::Generic>\n\n\nsub next_prediction {\n    my ($self) = @_;\n    # if the prediction section hasn't been parsed yet, we do this now\n    $self->_parse_predictions unless $self->_predictions_parsed;\n\n    # get next gene structure\n    return $self->_prediction();\n}\n\n=head2 _parse_predictions\n\n Title   : _parse_predictions()\n Usage   : $obj->_parse_predictions()\n Function: Parses the prediction section. Automatically called by\n           next_prediction() if not yet done.\n Example :\n Returns : "},"containerName":"main::","definition":"sub","line":183,"children":[{"localvar":"my","containerName":"_parse_predictions","definition":"my","name":"$self","line":184,"kind":13},{"containerName":"_parse_predictions","definition":"my","name":"$gene","localvar":"my","kind":13,"line":185},{"kind":13,"line":186,"name":"@genes","definition":"my","containerName":"_parse_predictions","localvar":"my"},{"line":190,"kind":13,"localvar":"my","containerName":"_parse_predictions","definition":"my","name":"%tags"},{"kind":13,"line":191,"name":"$self","containerName":"_parse_predictions"},{"line":191,"kind":12,"containerName":"_parse_predictions","name":"_readline"},{"kind":13,"line":193,"name":"$tags","containerName":"_parse_predictions"},{"line":195,"kind":13,"containerName":"_parse_predictions","name":"$gene"},{"kind":13,"line":196,"containerName":"_parse_predictions","name":"$gene"},{"kind":13,"line":197,"name":"%tags","containerName":"_parse_predictions"},{"containerName":"_parse_predictions","name":"$gene","line":200,"kind":13},{"containerName":"_parse_predictions","name":"new","kind":12,"line":200},{"containerName":"_parse_predictions","name":"%tags","kind":13,"line":203},{"kind":13,"line":204,"containerName":"_parse_predictions","name":"@genes"},{"name":"$gene","containerName":"_parse_predictions","kind":13,"line":204},{"name":"$gene","containerName":"_parse_predictions","line":207,"kind":13},{"name":"start","containerName":"_parse_predictions","kind":12,"line":207},{"containerName":"_parse_predictions","name":"$gene","kind":13,"line":208},{"line":208,"kind":12,"name":"end","containerName":"_parse_predictions"},{"name":"$gene","containerName":"_parse_predictions","kind":13,"line":209},{"name":"strand","containerName":"_parse_predictions","kind":12,"line":209},{"name":"$gene","containerName":"_parse_predictions","kind":13,"line":211},{"name":"start","containerName":"_parse_predictions","line":211,"kind":12},{"name":"$gene","containerName":"_parse_predictions","line":212,"kind":13},{"name":"end","containerName":"_parse_predictions","line":212,"kind":12},{"line":213,"kind":13,"name":"$gene","containerName":"_parse_predictions"},{"name":"strand","containerName":"_parse_predictions","kind":12,"line":213},{"name":"$s","definition":"my","containerName":"_parse_predictions","localvar":"my","kind":13,"line":216},{"containerName":"_parse_predictions","name":"$e","kind":13,"line":216},{"containerName":"_parse_predictions","name":"$st","line":216,"kind":13},{"containerName":"_parse_predictions","name":"$s","line":217,"kind":13},{"kind":13,"line":217,"name":"$e","containerName":"_parse_predictions"},{"name":"$s","containerName":"_parse_predictions","kind":13,"line":218},{"kind":13,"line":218,"name":"$e","containerName":"_parse_predictions"},{"containerName":"_parse_predictions","name":"$st","line":218,"kind":13},{"line":218,"kind":13,"containerName":"_parse_predictions","name":"$e"},{"containerName":"_parse_predictions","name":"$s","kind":13,"line":218},{"localvar":"my","containerName":"_parse_predictions","definition":"my","name":"$exon","line":220,"kind":13},{"kind":12,"line":220,"containerName":"_parse_predictions","name":"new"},{"kind":13,"line":221,"name":"$s","containerName":"_parse_predictions"},{"containerName":"_parse_predictions","name":"$e","kind":13,"line":222},{"kind":13,"line":223,"containerName":"_parse_predictions","name":"$st"},{"line":227,"kind":13,"name":"$gene","containerName":"_parse_predictions"},{"line":227,"kind":12,"name":"add_sub_SeqFeature","containerName":"_parse_predictions"},{"line":227,"kind":13,"containerName":"_parse_predictions","name":"$exon"},{"kind":13,"line":230,"name":"$self","containerName":"_parse_predictions"},{"line":230,"kind":12,"containerName":"_parse_predictions","name":"_add_prediction"},{"name":"@genes","containerName":"_parse_predictions","kind":13,"line":230},{"name":"$self","containerName":"_parse_predictions","line":231,"kind":13},{"containerName":"_parse_predictions","name":"_predictions_parsed","kind":12,"line":231}],"kind":12},{"name":"Bio","containerName":"SeqFeature::Generic","line":200,"kind":12},{"line":220,"kind":12,"containerName":"SeqFeature::Generic","name":"Bio"},{"children":[{"containerName":"_prediction","definition":"my","name":"$self","localvar":"my","kind":13,"line":245},{"name":"$self","containerName":"_prediction","kind":13,"line":246}],"line":244,"kind":12,"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# BioPerl module for Bio::Tools::Pseudowise\n#\n# $Id: Pseudowise.pm 16123 2009-09-17 12:57:27Z cjfields $\n# \n# Copyright Jason Stajich, Fugu Team \n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Pseudowise - Results of one Pseudowise run\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::Pseudowise;\n\n  my $parser = Bio::Tools::Pseudowise->new(-file=>\"pw.out\");\n  while(my $feat = $parser->next_result){\n      push @feat, $feat;\n  }\n\n=head1 DESCRIPTION\n\nPseudowise is a pseudogene prediction program written by Ewan Birney\nas part of the Wise Package. This module is the parser for the output\nof the program.\n\nhttp://www.sanger.ac.uk/software/wise2\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nPrevious committed by the Fugu Team \n\nRe-written by Jason Stajich jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. \nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Pseudowise;\nuse strict;\nuse Symbol;\n\nuse Bio::Root::Root;\nuse Bio::SeqFeature::Generic;\nuse Bio::SeqFeature::Gene::Exon;\nuse Bio::SeqFeature::FeaturePair;\nuse Bio::SeqFeature::Gene::Transcript;\nuse Bio::SeqFeature::Gene::GeneStructure;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\nsub _initialize_state {\n    my ($self,@args) = @_;\n\n    # first call the inherited method!\n    $self->SUPER::_initialize_state(@args);\n\n    # our private state variables\n    $self->{'_preds_parsed'} = 0;\n    $self->{'_has_cds'} = 0;\n    # array of pre-parsed predictions\n    $self->{'_preds'} = [];\n    # seq stack\n    $self->{'_seqstack'} = [];\n}\n\n=head2 analysis_method\n\n Usage     : $pseudowise->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /pseudowise/i.\n Returns   : String\n Argument  : n/a\n\n\n#-------------\nsub analysis_method { \n#-------------\n    my ($self, $method) = @_;  \n    if($method && ($method !~ /pseudowise/i)) {\n\t$self->throw(\"method $method not supported in \" . ref($self));\n    }\n    return $self->SUPER::analysis_method($method);\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : $seqfeature = $obj->next_feature();\n Function: Returns the next feature available in the analysis result, or\n           undef if there are no more features.\n Example :\n Returns : A Bio::SeqFeatureI implementing object, or undef if there are no\n           more features.\n Args    : none\n\nSee Also  L<Bio::SeqFeatureI>\n\n\nsub next_feature {\n    return shift->next_prediction(@_);\n}\n\n\n=head2 next_prediction\n\n Title   : next_prediction\n Usage   : while($gene = $pseudowise->next_prediction()) {\n                  # do something\n           }\n Function: Returns the gene of the Pseudowise result\n           file. Call this method repeatedly until FALSE is returned.\n\n Example :\n Returns : a Bio::SeqFeature::Generic \n Args    : none\n\nSee Also L<Bio::SeqFeature::Generic>\n\n\nsub next_prediction {\n    my ($self) = @_;\n    # if the prediction section hasn't been parsed yet, we do this now\n    $self->_parse_predictions unless $self->_predictions_parsed;\n\n    # get next gene structure\n    return $self->_prediction();\n}\n\n=head2 _parse_predictions\n\n Title   : _parse_predictions()\n Usage   : $obj->_parse_predictions()\n Function: Parses the prediction section. Automatically called by\n           next_prediction() if not yet done.\n Example :\n Returns : \n\n\nsub _parse_predictions {\n    my ($self) = @_;\n    my $gene;\n    my @genes;\n\n    local $/= \"\\n\";\n    local($_);\n    my %tags;\n    while (defined( $_ = $self->_readline)){ \n\tif( /^(Total codons|\\S+)\\s+:\\s+(\\S+)/ ) {\n\t    $tags{$1} = $2;\n\t} elsif(m!^//! ) {\n\t    if( $gene ) {\n\t\t$gene = undef;\n\t\t%tags = ();\n\t    }\n\t} elsif (/Gene\\s+(\\d+)\\s*$/i) {\n\t    $gene = Bio::SeqFeature::Generic->new \n\t\t( -primary => 'pseudogene',\n\t\t  -source  => 'pseudowise',\n\t\t  -tag     => \\%tags);\n\t    push @genes, $gene;\n\t} elsif( /Gene\\s+(\\d+)\\s+(\\d+)/i ) {\n\t    if( $1 < $2 ) {\n\t\t$gene->start($1);\n\t\t$gene->end($2);\n\t\t$gene->strand(1);\n\t    } else {\n\t\t$gene->start($2);\n\t\t$gene->end($1);\n\t\t$gene->strand(-1);\n\t    }\n\t} elsif (/Exon\\s+(\\d+)\\s+(\\d+)\\s+phase\\s+(\\S+)/i) {\n\t    my ($s,$e,$st) = ($1,$2,1);\n\t    if( $s > $e) {\n\t\t($s,$e,$st)=($e,$s,-1);\n\t    }\n\t    my $exon = Bio::SeqFeature::Generic->new \n\t\t( -start   => $s,\n\t\t  -end     => $e,\n\t\t  -strand  => $st,\n\t\t  -primary => 'exon',\n\t\t  -source  => 'pseudowise',\n\t\t  -tag     => {'frame'  => $3});\n\t    $gene->add_sub_SeqFeature($exon);\n\t} \n    }\n    $self->_add_prediction(\\@genes);\n    $self->_predictions_parsed(1);\n}\n\n=head1 _prediction\n\n Title   : _prediction()\n Usage   : $gene = $obj->_prediction()\n Function: internal\n Example :\n Returns : ","label":"_prediction($self)"},"detail":"($self)","definition":"sub","containerName":"main::","range":{"start":{"character":0,"line":244},"end":{"character":9999,"line":246}},"name":"_prediction"},{"name":"_add_prediction","range":{"start":{"character":0,"line":259},"end":{"line":265,"character":9999}},"containerName":"main::","definition":"sub","detail":"($self,$gene)","signature":{"label":"_add_prediction($self,$gene)","parameters":[{"label":"$self"},{"label":"$gene"}],"documentation":"1;\n# BioPerl module for Bio::Tools::Pseudowise\n#\n# $Id: Pseudowise.pm 16123 2009-09-17 12:57:27Z cjfields $\n# \n# Copyright Jason Stajich, Fugu Team \n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Pseudowise - Results of one Pseudowise run\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::Pseudowise;\n\n  my $parser = Bio::Tools::Pseudowise->new(-file=>\"pw.out\");\n  while(my $feat = $parser->next_result){\n      push @feat, $feat;\n  }\n\n=head1 DESCRIPTION\n\nPseudowise is a pseudogene prediction program written by Ewan Birney\nas part of the Wise Package. This module is the parser for the output\nof the program.\n\nhttp://www.sanger.ac.uk/software/wise2\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nPrevious committed by the Fugu Team \n\nRe-written by Jason Stajich jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. \nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Pseudowise;\nuse strict;\nuse Symbol;\n\nuse Bio::Root::Root;\nuse Bio::SeqFeature::Generic;\nuse Bio::SeqFeature::Gene::Exon;\nuse Bio::SeqFeature::FeaturePair;\nuse Bio::SeqFeature::Gene::Transcript;\nuse Bio::SeqFeature::Gene::GeneStructure;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\nsub _initialize_state {\n    my ($self,@args) = @_;\n\n    # first call the inherited method!\n    $self->SUPER::_initialize_state(@args);\n\n    # our private state variables\n    $self->{'_preds_parsed'} = 0;\n    $self->{'_has_cds'} = 0;\n    # array of pre-parsed predictions\n    $self->{'_preds'} = [];\n    # seq stack\n    $self->{'_seqstack'} = [];\n}\n\n=head2 analysis_method\n\n Usage     : $pseudowise->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /pseudowise/i.\n Returns   : String\n Argument  : n/a\n\n\n#-------------\nsub analysis_method { \n#-------------\n    my ($self, $method) = @_;  \n    if($method && ($method !~ /pseudowise/i)) {\n\t$self->throw(\"method $method not supported in \" . ref($self));\n    }\n    return $self->SUPER::analysis_method($method);\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : $seqfeature = $obj->next_feature();\n Function: Returns the next feature available in the analysis result, or\n           undef if there are no more features.\n Example :\n Returns : A Bio::SeqFeatureI implementing object, or undef if there are no\n           more features.\n Args    : none\n\nSee Also  L<Bio::SeqFeatureI>\n\n\nsub next_feature {\n    return shift->next_prediction(@_);\n}\n\n\n=head2 next_prediction\n\n Title   : next_prediction\n Usage   : while($gene = $pseudowise->next_prediction()) {\n                  # do something\n           }\n Function: Returns the gene of the Pseudowise result\n           file. Call this method repeatedly until FALSE is returned.\n\n Example :\n Returns : a Bio::SeqFeature::Generic \n Args    : none\n\nSee Also L<Bio::SeqFeature::Generic>\n\n\nsub next_prediction {\n    my ($self) = @_;\n    # if the prediction section hasn't been parsed yet, we do this now\n    $self->_parse_predictions unless $self->_predictions_parsed;\n\n    # get next gene structure\n    return $self->_prediction();\n}\n\n=head2 _parse_predictions\n\n Title   : _parse_predictions()\n Usage   : $obj->_parse_predictions()\n Function: Parses the prediction section. Automatically called by\n           next_prediction() if not yet done.\n Example :\n Returns : \n\n\nsub _parse_predictions {\n    my ($self) = @_;\n    my $gene;\n    my @genes;\n\n    local $/= \"\\n\";\n    local($_);\n    my %tags;\n    while (defined( $_ = $self->_readline)){ \n\tif( /^(Total codons|\\S+)\\s+:\\s+(\\S+)/ ) {\n\t    $tags{$1} = $2;\n\t} elsif(m!^//! ) {\n\t    if( $gene ) {\n\t\t$gene = undef;\n\t\t%tags = ();\n\t    }\n\t} elsif (/Gene\\s+(\\d+)\\s*$/i) {\n\t    $gene = Bio::SeqFeature::Generic->new \n\t\t( -primary => 'pseudogene',\n\t\t  -source  => 'pseudowise',\n\t\t  -tag     => \\%tags);\n\t    push @genes, $gene;\n\t} elsif( /Gene\\s+(\\d+)\\s+(\\d+)/i ) {\n\t    if( $1 < $2 ) {\n\t\t$gene->start($1);\n\t\t$gene->end($2);\n\t\t$gene->strand(1);\n\t    } else {\n\t\t$gene->start($2);\n\t\t$gene->end($1);\n\t\t$gene->strand(-1);\n\t    }\n\t} elsif (/Exon\\s+(\\d+)\\s+(\\d+)\\s+phase\\s+(\\S+)/i) {\n\t    my ($s,$e,$st) = ($1,$2,1);\n\t    if( $s > $e) {\n\t\t($s,$e,$st)=($e,$s,-1);\n\t    }\n\t    my $exon = Bio::SeqFeature::Generic->new \n\t\t( -start   => $s,\n\t\t  -end     => $e,\n\t\t  -strand  => $st,\n\t\t  -primary => 'exon',\n\t\t  -source  => 'pseudowise',\n\t\t  -tag     => {'frame'  => $3});\n\t    $gene->add_sub_SeqFeature($exon);\n\t} \n    }\n    $self->_add_prediction(\\@genes);\n    $self->_predictions_parsed(1);\n}\n\n=head1 _prediction\n\n Title   : _prediction()\n Usage   : $gene = $obj->_prediction()\n Function: internal\n Example :\n Returns : \n\n\nsub _prediction {\n    my ($self) = @_;\n    return shift(@{$self->{'_preds'} || []});\n}\n\n=head2 _add_prediction\n\n Title   : _add_prediction()\n Usage   : $obj->_add_prediction($gene)\n Function: internal\n Example :\n Returns : "},"kind":12,"line":259,"children":[{"line":260,"kind":13,"localvar":"my","containerName":"_add_prediction","name":"$self","definition":"my"},{"name":"$gene","containerName":"_add_prediction","line":260,"kind":13},{"name":"$self","containerName":"_add_prediction","line":261,"kind":13},{"line":263,"kind":13,"containerName":"_add_prediction","name":"$gene"},{"containerName":"_add_prediction","name":"$self","line":264,"kind":13},{"line":264,"kind":13,"containerName":"_add_prediction","name":"$gene"}]},{"name":"%self","containerName":null,"line":266,"kind":13},{"kind":13,"line":266,"containerName":null,"name":"$gene"},{"name":"_predictions_parsed","range":{"end":{"line":288,"character":9999},"start":{"character":0,"line":280}},"definition":"sub","containerName":"main::","signature":{"label":"_predictions_parsed($self,$val)","documentation":"1;\n# BioPerl module for Bio::Tools::Pseudowise\n#\n# $Id: Pseudowise.pm 16123 2009-09-17 12:57:27Z cjfields $\n# \n# Copyright Jason Stajich, Fugu Team \n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Pseudowise - Results of one Pseudowise run\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::Pseudowise;\n\n  my $parser = Bio::Tools::Pseudowise->new(-file=>\"pw.out\");\n  while(my $feat = $parser->next_result){\n      push @feat, $feat;\n  }\n\n=head1 DESCRIPTION\n\nPseudowise is a pseudogene prediction program written by Ewan Birney\nas part of the Wise Package. This module is the parser for the output\nof the program.\n\nhttp://www.sanger.ac.uk/software/wise2\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nPrevious committed by the Fugu Team \n\nRe-written by Jason Stajich jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. \nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Pseudowise;\nuse strict;\nuse Symbol;\n\nuse Bio::Root::Root;\nuse Bio::SeqFeature::Generic;\nuse Bio::SeqFeature::Gene::Exon;\nuse Bio::SeqFeature::FeaturePair;\nuse Bio::SeqFeature::Gene::Transcript;\nuse Bio::SeqFeature::Gene::GeneStructure;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\nsub _initialize_state {\n    my ($self,@args) = @_;\n\n    # first call the inherited method!\n    $self->SUPER::_initialize_state(@args);\n\n    # our private state variables\n    $self->{'_preds_parsed'} = 0;\n    $self->{'_has_cds'} = 0;\n    # array of pre-parsed predictions\n    $self->{'_preds'} = [];\n    # seq stack\n    $self->{'_seqstack'} = [];\n}\n\n=head2 analysis_method\n\n Usage     : $pseudowise->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /pseudowise/i.\n Returns   : String\n Argument  : n/a\n\n\n#-------------\nsub analysis_method { \n#-------------\n    my ($self, $method) = @_;  \n    if($method && ($method !~ /pseudowise/i)) {\n\t$self->throw(\"method $method not supported in \" . ref($self));\n    }\n    return $self->SUPER::analysis_method($method);\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : $seqfeature = $obj->next_feature();\n Function: Returns the next feature available in the analysis result, or\n           undef if there are no more features.\n Example :\n Returns : A Bio::SeqFeatureI implementing object, or undef if there are no\n           more features.\n Args    : none\n\nSee Also  L<Bio::SeqFeatureI>\n\n\nsub next_feature {\n    return shift->next_prediction(@_);\n}\n\n\n=head2 next_prediction\n\n Title   : next_prediction\n Usage   : while($gene = $pseudowise->next_prediction()) {\n                  # do something\n           }\n Function: Returns the gene of the Pseudowise result\n           file. Call this method repeatedly until FALSE is returned.\n\n Example :\n Returns : a Bio::SeqFeature::Generic \n Args    : none\n\nSee Also L<Bio::SeqFeature::Generic>\n\n\nsub next_prediction {\n    my ($self) = @_;\n    # if the prediction section hasn't been parsed yet, we do this now\n    $self->_parse_predictions unless $self->_predictions_parsed;\n\n    # get next gene structure\n    return $self->_prediction();\n}\n\n=head2 _parse_predictions\n\n Title   : _parse_predictions()\n Usage   : $obj->_parse_predictions()\n Function: Parses the prediction section. Automatically called by\n           next_prediction() if not yet done.\n Example :\n Returns : \n\n\nsub _parse_predictions {\n    my ($self) = @_;\n    my $gene;\n    my @genes;\n\n    local $/= \"\\n\";\n    local($_);\n    my %tags;\n    while (defined( $_ = $self->_readline)){ \n\tif( /^(Total codons|\\S+)\\s+:\\s+(\\S+)/ ) {\n\t    $tags{$1} = $2;\n\t} elsif(m!^//! ) {\n\t    if( $gene ) {\n\t\t$gene = undef;\n\t\t%tags = ();\n\t    }\n\t} elsif (/Gene\\s+(\\d+)\\s*$/i) {\n\t    $gene = Bio::SeqFeature::Generic->new \n\t\t( -primary => 'pseudogene',\n\t\t  -source  => 'pseudowise',\n\t\t  -tag     => \\%tags);\n\t    push @genes, $gene;\n\t} elsif( /Gene\\s+(\\d+)\\s+(\\d+)/i ) {\n\t    if( $1 < $2 ) {\n\t\t$gene->start($1);\n\t\t$gene->end($2);\n\t\t$gene->strand(1);\n\t    } else {\n\t\t$gene->start($2);\n\t\t$gene->end($1);\n\t\t$gene->strand(-1);\n\t    }\n\t} elsif (/Exon\\s+(\\d+)\\s+(\\d+)\\s+phase\\s+(\\S+)/i) {\n\t    my ($s,$e,$st) = ($1,$2,1);\n\t    if( $s > $e) {\n\t\t($s,$e,$st)=($e,$s,-1);\n\t    }\n\t    my $exon = Bio::SeqFeature::Generic->new \n\t\t( -start   => $s,\n\t\t  -end     => $e,\n\t\t  -strand  => $st,\n\t\t  -primary => 'exon',\n\t\t  -source  => 'pseudowise',\n\t\t  -tag     => {'frame'  => $3});\n\t    $gene->add_sub_SeqFeature($exon);\n\t} \n    }\n    $self->_add_prediction(\\@genes);\n    $self->_predictions_parsed(1);\n}\n\n=head1 _prediction\n\n Title   : _prediction()\n Usage   : $gene = $obj->_prediction()\n Function: internal\n Example :\n Returns : \n\n\nsub _prediction {\n    my ($self) = @_;\n    return shift(@{$self->{'_preds'} || []});\n}\n\n=head2 _add_prediction\n\n Title   : _add_prediction()\n Usage   : $obj->_add_prediction($gene)\n Function: internal\n Example :\n Returns : \n\n\nsub _add_prediction {\n    my ($self, $gene) = @_;\n    $self->{'_preds'} ||= [];\n\n    if( ref($gene) =~ /ARRAY/ ) {\n\tpush(@{$self->{'_preds'}}, @$gene);\n    } else {\n\tpush(@{$self->{'_preds'}}, $gene);\n    }\n}\n\n=head2 _predictions_parsed\n\n Title   : _predictions_parsed\n Usage   : $obj->_predictions_parsed\n Function: internal\n Example :\n Returns : TRUE or FALSE","parameters":[{"label":"$self"},{"label":"$val"}]},"detail":"($self,$val)","kind":12,"children":[{"line":281,"kind":13,"localvar":"my","containerName":"_predictions_parsed","name":"$self","definition":"my"},{"containerName":"_predictions_parsed","name":"$val","line":281,"kind":13},{"line":283,"kind":13,"name":"$self","containerName":"_predictions_parsed"},{"kind":13,"line":283,"name":"$val","containerName":"_predictions_parsed"},{"line":283,"kind":13,"containerName":"_predictions_parsed","name":"$val"},{"name":"$self","containerName":"_predictions_parsed","kind":13,"line":284},{"kind":13,"line":285,"containerName":"_predictions_parsed","name":"$self"},{"name":"$self","containerName":"_predictions_parsed","line":287,"kind":13}],"line":280}],"version":5}