{"vars":[{"line":33,"kind":2,"name":"vars","containerName":""},{"line":39,"kind":2,"containerName":"","name":"base"},{"containerName":null,"name":"@FORMATS","kind":13,"line":40},{"children":[{"kind":13,"line":52,"containerName":"new","name":"$class","definition":"my","localvar":"my"},{"name":"@args","containerName":"new","kind":13,"line":52},{"line":53,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"new"},{"name":"$class","containerName":"new","kind":13,"line":53},{"name":"@args","containerName":"new","line":53,"kind":13},{"containerName":"new","name":"$self","kind":13,"line":54},{"kind":12,"line":54,"name":"_initialize_io","containerName":"new"},{"containerName":"new","name":"@args","kind":13,"line":54},{"kind":13,"line":55,"definition":"my","name":"$format","containerName":"new","localvar":"my"},{"kind":13,"line":55,"containerName":"new","name":"$self"},{"containerName":"new","name":"_rearrange","line":55,"kind":12},{"name":"@args","containerName":"new","kind":13,"line":55},{"line":56,"kind":13,"containerName":"new","name":"$format"},{"line":56,"kind":13,"name":"$self","containerName":"new"},{"line":56,"kind":12,"name":"throw","containerName":"new"},{"line":57,"kind":13,"containerName":"new","name":"@FORMATS"},{"name":"$self","containerName":"new","line":58,"kind":13},{"line":58,"kind":12,"containerName":"new","name":"format"},{"name":"$format","containerName":"new","kind":13,"line":58},{"kind":13,"line":60,"containerName":"new","name":"$self"},{"containerName":"new","name":"throw","line":60,"kind":12},{"kind":13,"line":62,"name":"$self","containerName":"new"}],"line":51,"kind":12,"signature":{"label":"new($class,@args)","parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n\n=head1 NAME\n\nBio::Tools::PrositeScan - Parser for ps_scan result\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::PrositeScan;\n\n  my $factory = Bio::Tools::PrositeScan->new(\n      -file => 'out.PrositeScan'\n  );\n\n  while(my $match = $factory->next_prediction){\n      #  $match is of Bio::SeqFeature::FeaturePair\n      my $q_id = $fatch->feature1->seq_id;\n      my $h_id = $fatch->feature2->seq_id;\n  }\n\n=head1 DESCRIPTION\n\nThis is the parser of the output of ps_scan program. It takes either a file\nhandler or a file name, and returns a Bio::SeqFeature::FeaturePair object.\n\n=head1 AUTHOR\n\nJuguang Xiao, juguang@tll.org.sg\n\n\n# Let the code begin...\n\npackage Bio::Tools::PrositeScan;\nuse vars qw(@FORMATS);\nuse strict;\nuse Bio::Seq;\nuse Bio::SeqFeature::Generic;\nuse Bio::SeqFeature::FeaturePair;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n@FORMATS = qw(SCAN FASTA PSA MSA PFF MATCHLIST);\n\n=head2 new\n\n  Title   : new\n  Usage   : Bio::Tools::PrositeScan->new(-file => 'out.PrositeScan');\n            Bio::Tools::PrositeScan->new(-fh => \\*FH);\n  Returns : L<Bio::Tools::PrositeScan>"},"detail":"($class,@args)","definition":"sub","containerName":"main::","range":{"end":{"character":9999,"line":63},"start":{"character":0,"line":51}},"name":"new"},{"kind":12,"line":53,"name":"SUPER","containerName":"new"},{"kind":13,"line":66,"name":"$self","definition":"my","containerName":null,"localvar":"my"},{"kind":13,"line":67,"name":"%self","containerName":null},{"name":"_format","kind":12,"line":67},{"kind":13,"line":68,"containerName":null,"name":"%self"},{"name":"_format","kind":12,"line":68},{"line":83,"children":[{"kind":13,"line":84,"name":"$self","definition":"my","containerName":"next_prediction","localvar":"my"},{"kind":13,"line":85,"containerName":"next_prediction","name":"$self"},{"line":85,"kind":12,"name":"_parsed","containerName":"next_prediction"},{"line":86,"kind":13,"name":"$self","containerName":"next_prediction"},{"name":"_parse","containerName":"next_prediction","kind":12,"line":86},{"name":"$self","containerName":"next_prediction","line":87,"kind":13},{"name":"_parsed","containerName":"next_prediction","line":87,"kind":12},{"line":89,"kind":13,"containerName":"next_prediction","name":"$self"}],"kind":12,"detail":"($self)","signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n\n=head1 NAME\n\nBio::Tools::PrositeScan - Parser for ps_scan result\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::PrositeScan;\n\n  my $factory = Bio::Tools::PrositeScan->new(\n      -file => 'out.PrositeScan'\n  );\n\n  while(my $match = $factory->next_prediction){\n      #  $match is of Bio::SeqFeature::FeaturePair\n      my $q_id = $fatch->feature1->seq_id;\n      my $h_id = $fatch->feature2->seq_id;\n  }\n\n=head1 DESCRIPTION\n\nThis is the parser of the output of ps_scan program. It takes either a file\nhandler or a file name, and returns a Bio::SeqFeature::FeaturePair object.\n\n=head1 AUTHOR\n\nJuguang Xiao, juguang@tll.org.sg\n\n\n# Let the code begin...\n\npackage Bio::Tools::PrositeScan;\nuse vars qw(@FORMATS);\nuse strict;\nuse Bio::Seq;\nuse Bio::SeqFeature::Generic;\nuse Bio::SeqFeature::FeaturePair;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n@FORMATS = qw(SCAN FASTA PSA MSA PFF MATCHLIST);\n\n=head2 new\n\n  Title   : new\n  Usage   : Bio::Tools::PrositeScan->new(-file => 'out.PrositeScan');\n            Bio::Tools::PrositeScan->new(-fh => \\*FH);\n  Returns : L<Bio::Tools::PrositeScan>\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    $self->_initialize_io(@args);\n    my ($format) = $self->_rearrange([qw(FORMAT)], @args);\n    $format || $self->throw(\"format needed\");\n    if(grep /^$format$/i, @FORMATS){\n        $self->format($format);\n    }else{\n        $self->throw(\"Invalid format, [$format]\");\n    }\n    return $self;\n}\n\nsub format {\n    my $self = shift;\n    return $self->{_format} = shift if(@_);\n    return $self->{_format};\n}\n\n=head2 next_prediction\n\n  Title   : new\n  Usage   : \n      while($result = $factory->next_prediction){\n          ;\n      }\n\n  Returns : a Bio::SeqFeature::FeaturePair object","label":"next_prediction($self)"},"containerName":"main::","definition":"sub","range":{"start":{"character":0,"line":83},"end":{"character":9999,"line":89}},"name":"next_prediction"},{"line":89,"kind":12,"name":"_matches"},{"kind":12,"line":92,"children":[{"containerName":"next_result","name":"next_prediction","line":93,"kind":12}],"containerName":"main::","name":"next_result","definition":"sub","range":{"end":{"line":94,"character":9999},"start":{"character":0,"line":92}}},{"kind":12,"children":[{"localvar":"my","containerName":"_parsed","definition":"my","name":"$self","line":97,"kind":13},{"containerName":"_parsed","name":"$self","line":98,"kind":13},{"kind":13,"line":99,"containerName":"_parsed","name":"$self"}],"line":96,"definition":"sub","name":"_parsed","containerName":"main::","range":{"start":{"line":96,"character":0},"end":{"line":100,"character":9999}}},{"line":98,"kind":12,"name":"_parsed"},{"name":"_parsed","line":99,"kind":12},{"name":"_parse","definition":"sub","containerName":"main::","range":{"end":{"character":9999,"line":110},"start":{"character":0,"line":102}},"kind":12,"children":[{"line":103,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"_parse"},{"localvar":"my","definition":"my","name":"$format","containerName":"_parse","line":104,"kind":13},{"name":"$self","containerName":"_parse","line":104,"kind":13},{"name":"format","containerName":"_parse","line":104,"kind":12},{"line":105,"kind":13,"containerName":"_parse","name":"$self"},{"line":105,"kind":12,"name":"format","containerName":"_parse"},{"containerName":"_parse","name":"$self","kind":13,"line":106},{"containerName":"_parse","name":"_parse_fasta","kind":12,"line":106},{"name":"$self","containerName":"_parse","kind":13,"line":108},{"kind":12,"line":108,"name":"throw","containerName":"_parse"}],"line":102},{"range":{"start":{"character":0,"line":112},"end":{"character":9999,"line":154}},"name":"_parse_fasta","line":112,"children":[{"localvar":"my","containerName":"_parse_fasta","name":"$self","definition":"my","line":113,"kind":13},{"containerName":"_parse_fasta","name":"@matches","definition":"my","localvar":"my","kind":13,"line":114},{"definition":"my","name":"$fp","containerName":"_parse_fasta","localvar":"my","kind":13,"line":115},{"line":116,"kind":13,"localvar":"my","containerName":"_parse_fasta","definition":"my","name":"$seq"},{"containerName":"_parse_fasta","name":"$self","kind":13,"line":117},{"line":117,"kind":12,"name":"_readline","containerName":"_parse_fasta"},{"line":120,"kind":13,"localvar":"my","containerName":"_parse_fasta","definition":"my","name":"$fasta_head"},{"containerName":"_parse_fasta","name":"$fasta_head","line":121,"kind":13},{"line":122,"kind":13,"localvar":"my","containerName":"_parse_fasta","name":"$q_id","definition":"my"},{"containerName":"_parse_fasta","definition":"my","name":"$q_start","localvar":"my","kind":13,"line":123},{"kind":13,"line":124,"name":"$q_end","definition":"my","containerName":"_parse_fasta","localvar":"my"},{"containerName":"_parse_fasta","name":"$h_id","definition":"my","localvar":"my","kind":13,"line":125},{"name":"$fp","containerName":"_parse_fasta","line":126,"kind":13},{"containerName":"_parse_fasta","name":"$self","kind":13,"line":127},{"name":"_attach_seq","containerName":"_parse_fasta","line":127,"kind":12},{"containerName":"_parse_fasta","name":"$seq","kind":13,"line":127},{"kind":13,"line":127,"name":"$fp","containerName":"_parse_fasta"},{"containerName":"_parse_fasta","name":"@matches","kind":13,"line":128},{"line":128,"kind":13,"name":"$fp","containerName":"_parse_fasta"},{"containerName":"_parse_fasta","name":"$fp","kind":13,"line":130},{"kind":12,"line":130,"name":"new","containerName":"_parse_fasta"},{"name":"new","containerName":"_parse_fasta","kind":12,"line":131},{"name":"$q_id","containerName":"_parse_fasta","line":132,"kind":13},{"kind":13,"line":133,"name":"$q_start","containerName":"_parse_fasta"},{"line":135,"kind":13,"name":"$q_end","containerName":"_parse_fasta"},{"line":136,"kind":12,"name":"new","containerName":"_parse_fasta"},{"kind":13,"line":137,"name":"$h_id","containerName":"_parse_fasta"},{"line":142,"kind":13,"containerName":"_parse_fasta","name":"$seq"},{"line":144,"kind":13,"containerName":"_parse_fasta","name":"$self"},{"name":"throw","containerName":"_parse_fasta","kind":12,"line":144},{"containerName":"_parse_fasta","name":"$seq","line":147,"kind":13},{"containerName":"_parse_fasta","name":"$fp","kind":13,"line":150},{"name":"$self","containerName":"_parse_fasta","kind":13,"line":151},{"containerName":"_parse_fasta","name":"_attach_seq","kind":12,"line":151},{"name":"$seq","containerName":"_parse_fasta","kind":13,"line":151},{"containerName":"_parse_fasta","name":"$fp","line":151,"kind":13},{"kind":13,"line":152,"containerName":"_parse_fasta","name":"@matches"},{"containerName":"_parse_fasta","name":"$fp","kind":13,"line":152},{"name":"$self","containerName":"_parse_fasta","kind":13,"line":154}],"kind":12,"detail":"($self)","signature":{"documentation":"","parameters":[{"label":"$self"}],"label":"_parse_fasta($self)"},"containerName":"main::","definition":"sub"},{"kind":12,"line":130,"name":"Bio","containerName":"SeqFeature::FeaturePair"},{"line":131,"kind":12,"name":"Bio","containerName":"SeqFeature::Generic"},{"kind":12,"line":136,"name":"Bio","containerName":"SeqFeature::Generic"},{"name":"_matches","kind":12,"line":154},{"containerName":null,"name":"@matches","line":154,"kind":13},{"name":"_attach_seq","range":{"start":{"line":158,"character":0},"end":{"character":9999,"line":167}},"definition":"sub","containerName":"main::","signature":{"label":"_attach_seq($self,$seq,$fp)","documentation":"","parameters":[{"label":"$self"},{"label":"$seq"},{"label":"$fp"}]},"detail":"($self,$seq,$fp)","kind":12,"children":[{"containerName":"_attach_seq","name":"$self","definition":"my","localvar":"my","kind":13,"line":159},{"kind":13,"line":159,"containerName":"_attach_seq","name":"$seq"},{"containerName":"_attach_seq","name":"$fp","kind":13,"line":159},{"kind":13,"line":160,"containerName":"_attach_seq","name":"$fp"},{"localvar":"my","containerName":"_attach_seq","name":"$whole_seq","definition":"my","line":161,"kind":13},{"line":161,"kind":13,"name":"$fp","containerName":"_attach_seq"},{"line":161,"kind":12,"name":"start","containerName":"_attach_seq"},{"containerName":"_attach_seq","name":"$whole_seq","kind":13,"line":162},{"kind":13,"line":162,"name":"$seq","containerName":"_attach_seq"},{"name":"$fp","containerName":"_attach_seq","kind":13,"line":163},{"containerName":"_attach_seq","name":"feature1","line":163,"kind":12},{"containerName":"_attach_seq","name":"attach_seq","kind":12,"line":163},{"containerName":"_attach_seq","name":"new","kind":12,"line":164},{"name":"$whole_seq","containerName":"_attach_seq","kind":13,"line":164}],"line":158},{"containerName":"Seq","name":"Bio","kind":12,"line":164}],"version":5}