{"version":5,"vars":[{"containerName":"","name":"base","kind":2,"line":119},{"name":"new","range":{"end":{"character":9999,"line":139},"start":{"line":132,"character":0}},"kind":12,"children":[{"kind":13,"line":133,"containerName":"new","definition":"my","name":"$class","localvar":"my"},{"kind":13,"line":133,"containerName":"new","name":"@args"},{"kind":13,"line":135,"definition":"my","name":"$self","containerName":"new","localvar":"my"},{"line":135,"kind":13,"name":"$class","containerName":"new"},{"name":"@args","containerName":"new","line":135,"kind":13},{"kind":13,"line":136,"containerName":"new","name":"$self"},{"name":"_initialize_io","containerName":"new","line":136,"kind":12},{"kind":13,"line":136,"containerName":"new","name":"@args"},{"containerName":"new","name":"$self","line":138,"kind":13}],"line":132,"definition":"sub","containerName":"main::","signature":{"label":"new($class,@args)","parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: Molphy.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Phylo::Molphy\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Phylo::Molphy - parser for Molphy output\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::Phylo::Molphy;\n  my $parser = Bio::Tools::Phylo::Molphy->new(-file => 'output.protml');\n  while( my $r = $parser->next_result ) {\n    # r is a Bio::Tools::Phylo::Molphy::Result object\n\n    # print the model name\n    print $r->model, \"\\n\";\n\n    # get the substitution matrix\n    # this is a hash of 3letter aa codes -> 3letter aa codes representing\n    # substitution rate\n    my $smat = $r->substitution_matrix;\n    print \"Arg -> Gln substitution rate is %d\\n\", \n          $smat->{'Arg'}->{'Gln'}, \"\\n\";\n\n    # get the transition probablity matrix\n    # this is a hash of 3letter aa codes -> 3letter aa codes representing\n    # transition probabilty\n    my $tmat = $r->transition_probability_matrix;\n    print \"Arg -> Gln transition probablity is %.2f\\n\", \n          $tmat->{'Arg'}->{'Gln'}, \"\\n\";\n\n    # get the frequency for each of the residues\n    my $rfreqs = $r->residue_frequencies;\n\n    foreach my $residue ( keys %{$rfreqs} ) {\n       printf \"residue %s  expected freq: %.2f observed freq: %.2f\\n\",\n              $residue,$rfreqs->{$residue}->[0], $rfreqs->{$residue}->[1];     \n    }\n\n    my @trees;\n    while( my $t = $r->next_tree ) {\n        push @trees, $t;\n    }\n\n    print \"search space is \", $r->search_space, \"\\n\",\n          \"1st tree score is \", $trees[0]->score, \"\\n\";\n\n    # writing to STDOUT, use -file => '>filename' to specify a file\n    my $out = Bio::TreeIO->new(-format => \"newick\");\n    $out->write_tree($trees[0]); # writing only the 1st tree\n  }\n\n=head1 DESCRIPTION\n\nA parser for Molphy output (protml,dnaml)\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Phylo::Molphy;\nuse strict;\n\nuse Bio::Tools::Phylo::Molphy::Result;\nuse Bio::TreeIO;\nuse IO::String;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::Phylo::Molphy->new();\n Function: Builds a new Bio::Tools::Phylo::Molphy object \n Returns : Bio::Tools::Phylo::Molphy\n Args    : -fh/-file => $val, # for initing input, see Bio::Root::IO"},"detail":"($class,@args)"},{"containerName":"new","name":"SUPER","line":135,"kind":12},{"range":{"end":{"character":9999,"line":269},"start":{"character":0,"line":152}},"name":"next_result","signature":{"label":"next_result($self)","documentation":"1;\n# $Id: Molphy.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Phylo::Molphy\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Phylo::Molphy - parser for Molphy output\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::Phylo::Molphy;\n  my $parser = Bio::Tools::Phylo::Molphy->new(-file => 'output.protml');\n  while( my $r = $parser->next_result ) {\n    # r is a Bio::Tools::Phylo::Molphy::Result object\n\n    # print the model name\n    print $r->model, \"\\n\";\n\n    # get the substitution matrix\n    # this is a hash of 3letter aa codes -> 3letter aa codes representing\n    # substitution rate\n    my $smat = $r->substitution_matrix;\n    print \"Arg -> Gln substitution rate is %d\\n\", \n          $smat->{'Arg'}->{'Gln'}, \"\\n\";\n\n    # get the transition probablity matrix\n    # this is a hash of 3letter aa codes -> 3letter aa codes representing\n    # transition probabilty\n    my $tmat = $r->transition_probability_matrix;\n    print \"Arg -> Gln transition probablity is %.2f\\n\", \n          $tmat->{'Arg'}->{'Gln'}, \"\\n\";\n\n    # get the frequency for each of the residues\n    my $rfreqs = $r->residue_frequencies;\n\n    foreach my $residue ( keys %{$rfreqs} ) {\n       printf \"residue %s  expected freq: %.2f observed freq: %.2f\\n\",\n              $residue,$rfreqs->{$residue}->[0], $rfreqs->{$residue}->[1];     \n    }\n\n    my @trees;\n    while( my $t = $r->next_tree ) {\n        push @trees, $t;\n    }\n\n    print \"search space is \", $r->search_space, \"\\n\",\n          \"1st tree score is \", $trees[0]->score, \"\\n\";\n\n    # writing to STDOUT, use -file => '>filename' to specify a file\n    my $out = Bio::TreeIO->new(-format => \"newick\");\n    $out->write_tree($trees[0]); # writing only the 1st tree\n  }\n\n=head1 DESCRIPTION\n\nA parser for Molphy output (protml,dnaml)\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Phylo::Molphy;\nuse strict;\n\nuse Bio::Tools::Phylo::Molphy::Result;\nuse Bio::TreeIO;\nuse IO::String;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::Phylo::Molphy->new();\n Function: Builds a new Bio::Tools::Phylo::Molphy object \n Returns : Bio::Tools::Phylo::Molphy\n Args    : -fh/-file => $val, # for initing input, see Bio::Root::IO\n\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  $self->_initialize_io(@args);\n\n  return $self;\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $r = $molphy->next_result\n Function: Get the next result set from parser data\n Returns : Bio::Tools::Phylo::Molphy::Result object\n Args    : none","parameters":[{"label":"$self"}]},"detail":"($self)","definition":"sub","containerName":"main::","children":[{"kind":13,"line":153,"containerName":"next_result","definition":"my","name":"$self","localvar":"my"},{"kind":13,"line":156,"name":"$state","definition":"my","containerName":"next_result","localvar":"my"},{"kind":13,"line":156,"containerName":"next_result","name":"$transition_ct"},{"name":"@transition_matrix","containerName":"next_result","kind":13,"line":157},{"containerName":"next_result","name":"%transition_mat","line":157,"kind":13},{"containerName":"next_result","name":"@resloc","kind":13,"line":157},{"localvar":"my","containerName":"next_result","definition":"my","name":"%subst_matrix","line":158,"kind":13},{"line":158,"kind":13,"name":"@treelines","containerName":"next_result"},{"kind":13,"line":158,"containerName":"next_result","name":"@treedata"},{"containerName":"next_result","name":"%frequencies","line":158,"kind":13},{"kind":13,"line":159,"definition":"my","name":"$treenum","containerName":"next_result","localvar":"my"},{"name":"$possible_trees","containerName":"next_result","line":159,"kind":13},{"containerName":"next_result","name":"$model","kind":13,"line":159},{"localvar":"my","containerName":"next_result","name":"$trans_type","definition":"my","line":160,"kind":13},{"name":"$trans_amount","containerName":"next_result","line":160,"kind":13},{"line":161,"kind":13,"localvar":"my","containerName":"next_result","name":"$parsed","definition":"my"},{"name":"$self","containerName":"next_result","kind":13,"line":162},{"containerName":"next_result","name":"_readline","line":162,"kind":12},{"containerName":"next_result","name":"$parsed","line":163,"kind":13},{"name":"%subst_matrix","containerName":"next_result","kind":13,"line":165},{"line":166,"kind":13,"name":"$self","containerName":"next_result"},{"name":"_pushback","containerName":"next_result","kind":12,"line":166},{"kind":13,"line":169,"containerName":"next_result","name":"$state"},{"line":170,"kind":13,"localvar":"my","containerName":"next_result","definition":"my","name":"@tempdata"},{"containerName":"next_result","name":"@resloc","line":171,"kind":13},{"containerName":"next_result","name":"$self","line":172,"kind":13},{"containerName":"next_result","name":"_readline","line":172,"kind":12},{"containerName":"next_result","definition":"my","name":"@data","localvar":"my","kind":13,"line":177},{"kind":13,"line":178,"name":"$i","definition":"my","containerName":"next_result","localvar":"my"},{"localvar":"my","containerName":"next_result","definition":"my","name":"$l","line":179,"kind":13},{"containerName":"next_result","name":"@data","line":179,"kind":13},{"line":180,"kind":13,"name":"$l","containerName":"next_result"},{"line":181,"kind":13,"name":"@resloc","containerName":"next_result"},{"kind":13,"line":181,"name":"$l","containerName":"next_result"},{"kind":13,"line":183,"containerName":"next_result","name":"$i"},{"containerName":"next_result","name":"@tempdata","line":185,"kind":13},{"name":"@data","containerName":"next_result","line":185,"kind":13},{"kind":13,"line":187,"name":"$i","definition":"my","containerName":"next_result","localvar":"my"},{"kind":13,"line":188,"containerName":"next_result","name":"$row","definition":"my","localvar":"my"},{"containerName":"next_result","name":"@tempdata","kind":13,"line":188},{"localvar":"my","containerName":"next_result","definition":"my","name":"$j","line":189,"kind":13},{"line":190,"kind":13,"localvar":"my","containerName":"next_result","definition":"my","name":"$col"},{"name":"$row","containerName":"next_result","line":190,"kind":13},{"containerName":"next_result","name":"$i","line":191,"kind":13},{"kind":13,"line":191,"containerName":"next_result","name":"$j"},{"kind":13,"line":193,"name":"$subst_matrix","containerName":"next_result"},{"line":193,"kind":13,"name":"$resloc","containerName":"next_result"},{"name":"$i","containerName":"next_result","kind":13,"line":193},{"containerName":"next_result","name":"$resloc","line":193,"kind":13},{"kind":13,"line":193,"containerName":"next_result","name":"$j"},{"name":"$subst_matrix","containerName":"next_result","kind":13,"line":195},{"name":"$resloc","containerName":"next_result","line":195,"kind":13},{"line":195,"kind":13,"containerName":"next_result","name":"$i"},{"name":"$resloc","containerName":"next_result","kind":13,"line":195},{"line":195,"kind":13,"name":"$j","containerName":"next_result"},{"kind":13,"line":195,"name":"$col","containerName":"next_result"},{"kind":13,"line":197,"name":"$j","containerName":"next_result"},{"name":"$i","containerName":"next_result","kind":13,"line":199},{"kind":13,"line":203,"containerName":"next_result","name":"$state"},{"line":204,"kind":13,"localvar":"my","containerName":"next_result","definition":"my","name":"$newtrans_type"},{"line":205,"kind":13,"containerName":"next_result","name":"$trans_amount"},{"containerName":"next_result","name":"$trans_type","kind":13,"line":206},{"kind":13,"line":208,"containerName":"next_result","name":"$i","definition":"my","localvar":"my"},{"localvar":"my","name":"$row","definition":"my","containerName":"next_result","line":209,"kind":13},{"line":209,"kind":13,"containerName":"next_result","name":"@transition_matrix"},{"name":"$j","definition":"my","containerName":"next_result","localvar":"my","kind":13,"line":210},{"containerName":"next_result","definition":"my","name":"$col","localvar":"my","kind":13,"line":211},{"line":211,"kind":13,"containerName":"next_result","name":"$row"},{"containerName":"next_result","name":"$transition_mat","line":212,"kind":13},{"name":"$trans_type","containerName":"next_result","kind":13,"line":212},{"line":212,"kind":13,"name":"$resloc","containerName":"next_result"},{"line":212,"kind":13,"name":"$i","containerName":"next_result"},{"name":"$resloc","containerName":"next_result","line":212,"kind":13},{"containerName":"next_result","name":"$j","kind":13,"line":212},{"kind":13,"line":212,"name":"$col","containerName":"next_result"},{"line":213,"kind":13,"name":"$j","containerName":"next_result"},{"kind":13,"line":215,"name":"$i","containerName":"next_result"},{"containerName":"next_result","name":"$trans_type","line":218,"kind":13},{"kind":13,"line":218,"name":"$newtrans_type","containerName":"next_result"},{"line":219,"kind":13,"name":"$transition_ct","containerName":"next_result"},{"kind":13,"line":220,"containerName":"next_result","name":"@transition_matrix"},{"line":223,"kind":13,"containerName":"next_result","name":"$state"},{"name":"$self","containerName":"next_result","line":224,"kind":13},{"line":224,"kind":12,"name":"_readline","containerName":"next_result"},{"kind":13,"line":225,"name":"$self","containerName":"next_result"},{"kind":12,"line":225,"containerName":"next_result","name":"_readline"},{"kind":13,"line":227,"containerName":"next_result","name":"$self"},{"kind":12,"line":227,"name":"_pushback","containerName":"next_result"},{"localvar":"my","containerName":"next_result","definition":"my","name":"$index","line":232,"kind":13},{"name":"$res","containerName":"next_result","line":232,"kind":13},{"containerName":"next_result","name":"$model","line":232,"kind":13},{"kind":13,"line":232,"name":"$data","containerName":"next_result"},{"kind":13,"line":233,"containerName":"next_result","name":"$frequencies"},{"name":"$res","containerName":"next_result","line":233,"kind":13},{"containerName":"next_result","name":"$model","line":233,"kind":13},{"line":233,"kind":13,"name":"$data","containerName":"next_result"},{"localvar":"my","containerName":"next_result","name":"@save","definition":"my","line":236,"kind":13},{"containerName":"next_result","name":"$i","definition":"my","localvar":"my","kind":13,"line":238},{"containerName":"next_result","definition":"my","name":"$row","localvar":"my","kind":13,"line":239},{"kind":13,"line":239,"containerName":"next_result","name":"@transition_matrix"},{"kind":13,"line":240,"definition":"my","name":"$j","containerName":"next_result","localvar":"my"},{"line":241,"kind":13,"localvar":"my","containerName":"next_result","definition":"my","name":"$col"},{"kind":13,"line":241,"name":"$row","containerName":"next_result"},{"containerName":"next_result","name":"$transition_mat","line":242,"kind":13},{"name":"$trans_type","containerName":"next_result","kind":13,"line":242},{"containerName":"next_result","name":"$resloc","line":242,"kind":13},{"containerName":"next_result","name":"$i","kind":13,"line":242},{"name":"$resloc","containerName":"next_result","kind":13,"line":242},{"name":"$j","containerName":"next_result","line":242,"kind":13},{"line":242,"kind":13,"name":"$col","containerName":"next_result"},{"kind":13,"line":243,"containerName":"next_result","name":"$j"},{"line":245,"kind":13,"name":"$i","containerName":"next_result"},{"kind":13,"line":247,"name":"$treenum","containerName":"next_result"},{"name":"$self","containerName":"next_result","line":248,"kind":13},{"containerName":"next_result","name":"_pushback","kind":12,"line":248},{"kind":13,"line":252,"name":"$state","containerName":"next_result"},{"containerName":"next_result","name":"$treenum","kind":13,"line":253},{"kind":13,"line":253,"containerName":"next_result","name":"$possible_trees"},{"name":"$model","containerName":"next_result","kind":13,"line":253},{"kind":13,"line":253,"name":"@save","containerName":"next_result"},{"name":"$model","containerName":"next_result","line":254,"kind":13},{"kind":13,"line":255,"containerName":"next_result","name":"$state"},{"kind":13,"line":259,"name":"$trans_type","containerName":"next_result"},{"kind":13,"line":261,"name":"$transition_matrix","containerName":"next_result"},{"name":"$transition_ct","containerName":"next_result","line":261,"kind":13},{"name":"$transition_ct","containerName":"next_result","line":262,"kind":13},{"containerName":"next_result","name":"$transition_ct","line":262,"kind":13},{"containerName":"next_result","name":"$trans_type","kind":13,"line":263},{"line":265,"kind":13,"localvar":"my","name":"$res","definition":"my","containerName":"next_result"},{"line":265,"kind":13,"containerName":"next_result","name":"@row"},{"containerName":"next_result","name":"$transition_ct","kind":13,"line":266},{"name":"$transition_matrix","containerName":"next_result","kind":13,"line":267},{"kind":13,"line":267,"name":"$transition_ct","containerName":"next_result"},{"line":267,"kind":13,"containerName":"next_result","name":"@row"}],"line":152,"kind":12},{"line":269,"kind":13,"name":"%state","containerName":null},{"line":271,"kind":13,"name":"@treedata","containerName":null},{"line":275,"kind":13,"name":"@treelines","containerName":null},{"kind":13,"line":279,"definition":"my","name":"@trees","containerName":null,"localvar":"my"},{"kind":13,"line":280,"containerName":null,"name":"@treelines"},{"definition":"my","name":"$strdat","containerName":null,"localvar":"my","kind":13,"line":281},{"name":"IO","containerName":"String","line":281,"kind":12},{"name":"new","containerName":"main::","kind":12,"line":281},{"kind":13,"line":281,"name":"@treelines","containerName":null},{"localvar":"my","name":"$treeio","definition":"my","containerName":null,"line":282,"kind":13},{"containerName":"TreeIO","name":"Bio","kind":12,"line":282},{"containerName":"main::","name":"new","kind":12,"line":282},{"line":282,"kind":13,"name":"$strdat","containerName":null},{"containerName":null,"name":"$tree","definition":"my","localvar":"my","kind":13,"line":284},{"containerName":null,"name":"$treeio","line":284,"kind":13},{"line":284,"kind":12,"name":"next_tree","containerName":"main::"},{"kind":13,"line":285,"containerName":null,"name":"@treedata"},{"localvar":"my","containerName":null,"name":"$dat","definition":"my","line":286,"kind":13},{"kind":13,"line":286,"name":"@treedata","containerName":null},{"kind":13,"line":288,"name":"$tree","containerName":null},{"kind":12,"line":288,"containerName":"main::","name":"id"},{"line":288,"kind":13,"name":"@dat","containerName":null},{"name":"$tree","containerName":null,"line":289,"kind":13},{"kind":12,"line":289,"name":"score","containerName":"main::"},{"containerName":null,"name":"@dat","line":289,"kind":13},{"name":"@trees","containerName":null,"kind":13,"line":291},{"name":"$tree","containerName":null,"kind":13,"line":291},{"containerName":null,"name":"$parsed","line":294,"kind":13},{"line":295,"kind":13,"localvar":"my","name":"$result","definition":"my","containerName":null},{"line":295,"kind":12,"name":"Bio","containerName":"Tools::Phylo::Molphy::Result"},{"name":"new","containerName":"main::","line":296,"kind":12},{"containerName":null,"name":"@trees","kind":13,"line":296},{"line":297,"kind":13,"name":"%subst_matrix","containerName":null},{"containerName":null,"name":"%frequencies","kind":13,"line":298},{"containerName":null,"name":"$model","line":299,"kind":13},{"line":300,"kind":13,"containerName":null,"name":"$possible_trees"},{"line":302,"kind":13,"localvar":"my","definition":"my","name":"$type","containerName":null},{"kind":13,"line":302,"containerName":null,"name":"$mat"},{"containerName":null,"name":"%transition_mat","kind":13,"line":302},{"containerName":null,"name":"$result","kind":13,"line":303},{"containerName":"main::","name":"transition_probability_matrix","kind":12,"line":303},{"line":303,"kind":13,"containerName":null,"name":"$type"},{"line":303,"kind":13,"containerName":null,"name":"$mat"},{"name":"$result","containerName":null,"line":305,"kind":13}]}