{"vars":[{"kind":2,"line":109,"containerName":"","name":"base"},{"definition":"sub","containerName":"main::","signature":{"label":"_initialize_state($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":""},"detail":"($self,@args)","kind":12,"children":[{"kind":13,"line":112,"definition":"my","name":"$self","containerName":"_initialize_state","localvar":"my"},{"line":112,"kind":13,"containerName":"_initialize_state","name":"@args"},{"name":"$make","definition":"my","containerName":"_initialize_state","localvar":"my","kind":13,"line":115},{"kind":13,"line":115,"containerName":"_initialize_state","name":"$self"},{"name":"@args","containerName":"_initialize_state","kind":13,"line":115},{"kind":13,"line":118,"containerName":"_initialize_state","name":"$strand","definition":"my","localvar":"my"},{"containerName":"_initialize_state","name":"$params","line":118,"kind":13},{"containerName":"_initialize_state","name":"$self","kind":13,"line":119},{"name":"_rearrange","containerName":"_initialize_state","kind":12,"line":119},{"containerName":"_initialize_state","name":"@args","kind":13,"line":121},{"kind":13,"line":124,"containerName":"_initialize_state","name":"$strand"},{"kind":13,"line":124,"containerName":"_initialize_state","name":"$strand"},{"containerName":"_initialize_state","name":"$self","line":125,"kind":13},{"containerName":"_initialize_state","name":"$strand","line":125,"kind":13},{"kind":13,"line":126,"containerName":"_initialize_state","name":"$self"},{"containerName":"_initialize_state","name":"$self","line":127,"kind":13},{"kind":13,"line":129,"name":"$self","containerName":"_initialize_state"}],"line":111,"name":"_initialize_state","range":{"start":{"character":0,"line":111},"end":{"line":130,"character":9999}}},{"kind":12,"line":115,"name":"SUPER","containerName":"_initialize_state"},{"name":"analysis_method","range":{"start":{"line":143,"character":0},"end":{"line":150,"character":9999}},"kind":12,"line":143,"children":[{"kind":13,"line":145,"definition":"my","name":"$self","containerName":"analysis_method","localvar":"my"},{"containerName":"analysis_method","name":"$method","line":145,"kind":13},{"containerName":"analysis_method","name":"$method","line":146,"kind":13},{"name":"$method","containerName":"analysis_method","line":146,"kind":13},{"containerName":"analysis_method","name":"$self","line":147,"kind":13},{"kind":12,"line":147,"name":"throw","containerName":"analysis_method"},{"kind":13,"line":147,"containerName":"analysis_method","name":"$self"},{"containerName":"analysis_method","name":"$self","kind":13,"line":149},{"kind":13,"line":149,"name":"$method","containerName":"analysis_method"}],"containerName":"main::","definition":"sub","detail":"($self,$method)","signature":{"label":"analysis_method($self,$method)","parameters":[{"label":"$self"},{"label":"$method"}],"documentation":"1;\n# $Id: MZEF.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::MZEF\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp-at-gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::MZEF - Results of one MZEF run\n\n=head1 SYNOPSIS\n\n   $mzef = Bio::Tools::MZEF->new(-file => 'result.mzef');\n   # filehandle:\n   $mzef = Bio::Tools::MZEF->new( -fh  => \\*INPUT );\n   # to indicate that the sequence was reversed prior to feeding it to MZEF\n   # and that you want to have this reflected in the strand() attribute of \n   # the exons, as well have the coordinates translated to the non-reversed\n   # sequence\n   $mzef = Bio::Tools::MZEF->new( -file   => 'result.mzef',\n                                  -strand => -1 );\n\n   # parse the results\n   # note: this class is-a Bio::Tools::AnalysisResult which implements\n   # Bio::SeqAnalysisParserI, i.e., $genscan->next_feature() is the same\n   while($gene = $mzef->next_prediction()) {\n       # $gene is an instance of Bio::Tools::Prediction::Gene\n\n       # $gene->exons() returns an array of \n       # Bio::Tools::Prediction::Exon objects\n       # all exons:\n       @exon_arr = $gene->exons();\n\n       # internal exons only\n       @intrl_exons = $gene->exons('Internal');\n       # note that presently MZEF predicts only internal exons!\n   }\n\n   # essential if you gave a filename at initialization (otherwise the file\n   # will stay open)\n   $mzef->close();\n\n=head1 DESCRIPTION\n\nThe MZEF module provides a parser for MZEF gene structure prediction\noutput.\n\nThis module inherits off L<Bio::Tools::AnalysisResult> and therefore\nimplements L<Bio::SeqAnalysisParserI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp-at-gmx.net (or hilmar.lapp-at-pharma.novartis.com)\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::MZEF;\nuse strict;\n\nuse Bio::Tools::Prediction::Gene;\nuse Bio::Tools::Prediction::Exon;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\nsub _initialize_state {\n    my($self,@args) = @_;\n\n    # first call the inherited method!\n    my $make = $self->SUPER::_initialize_state(@args);\n\n    # handle our own parameters\n    my ($strand, $params) =\n\t$self->_rearrange([qw(STRAND\n\t\t\t      )],\n\t\t\t  @args);\n\n    # our private state variables\n    $strand = 1 unless defined($strand);\n    $self->{'_strand'} = $strand;\n    $self->{'_preds_parsed'} = 0;\n    $self->{'_has_cds'} = 0;\n    # array of pre-parsed predictions\n    $self->{'_preds'} = [];\n}\n\n=head2 analysis_method\n\n Usage     : $mzef->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /mzef/i.\n Returns   : String\n Argument  : n/a"}},{"line":149,"kind":12,"name":"SUPER","containerName":"analysis_method"},{"signature":{"documentation":"1;\n# $Id: MZEF.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::MZEF\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp-at-gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::MZEF - Results of one MZEF run\n\n=head1 SYNOPSIS\n\n   $mzef = Bio::Tools::MZEF->new(-file => 'result.mzef');\n   # filehandle:\n   $mzef = Bio::Tools::MZEF->new( -fh  => \\*INPUT );\n   # to indicate that the sequence was reversed prior to feeding it to MZEF\n   # and that you want to have this reflected in the strand() attribute of \n   # the exons, as well have the coordinates translated to the non-reversed\n   # sequence\n   $mzef = Bio::Tools::MZEF->new( -file   => 'result.mzef',\n                                  -strand => -1 );\n\n   # parse the results\n   # note: this class is-a Bio::Tools::AnalysisResult which implements\n   # Bio::SeqAnalysisParserI, i.e., $genscan->next_feature() is the same\n   while($gene = $mzef->next_prediction()) {\n       # $gene is an instance of Bio::Tools::Prediction::Gene\n\n       # $gene->exons() returns an array of \n       # Bio::Tools::Prediction::Exon objects\n       # all exons:\n       @exon_arr = $gene->exons();\n\n       # internal exons only\n       @intrl_exons = $gene->exons('Internal');\n       # note that presently MZEF predicts only internal exons!\n   }\n\n   # essential if you gave a filename at initialization (otherwise the file\n   # will stay open)\n   $mzef->close();\n\n=head1 DESCRIPTION\n\nThe MZEF module provides a parser for MZEF gene structure prediction\noutput.\n\nThis module inherits off L<Bio::Tools::AnalysisResult> and therefore\nimplements L<Bio::SeqAnalysisParserI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp-at-gmx.net (or hilmar.lapp-at-pharma.novartis.com)\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::MZEF;\nuse strict;\n\nuse Bio::Tools::Prediction::Gene;\nuse Bio::Tools::Prediction::Exon;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\nsub _initialize_state {\n    my($self,@args) = @_;\n\n    # first call the inherited method!\n    my $make = $self->SUPER::_initialize_state(@args);\n\n    # handle our own parameters\n    my ($strand, $params) =\n\t$self->_rearrange([qw(STRAND\n\t\t\t      )],\n\t\t\t  @args);\n\n    # our private state variables\n    $strand = 1 unless defined($strand);\n    $self->{'_strand'} = $strand;\n    $self->{'_preds_parsed'} = 0;\n    $self->{'_has_cds'} = 0;\n    # array of pre-parsed predictions\n    $self->{'_preds'} = [];\n}\n\n=head2 analysis_method\n\n Usage     : $mzef->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /mzef/i.\n Returns   : String\n Argument  : n/a\n\n\n#-------------\nsub analysis_method { \n#-------------\n    my ($self, $method) = @_;  \n    if($method && ($method !~ /mzef/i)) {\n\t$self->throw(\"method $method not supported in \" . ref($self));\n    }\n    return $self->SUPER::analysis_method($method);\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : while($gene = $mzef->next_feature()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the MZEF result\n           file. Call this method repeatedly until FALSE is returned.\n\n           The returned object is actually a SeqFeatureI implementing object.\n           This method is required for classes implementing the\n           SeqAnalysisParserI interface, and is merely an alias for \n           next_prediction() at present.\n\n           Note that with the present version of MZEF there will only be one\n           object returned, because MZEF does not predict individual genes\n           but just potential internal exons.\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :","parameters":[{"label":"$self"},{"label":"@args"}],"label":"next_feature($self,@args)"},"detail":"($self,@args)","definition":"sub","containerName":"main::","children":[{"localvar":"my","containerName":"next_feature","definition":"my","name":"$self","line":176,"kind":13},{"name":"@args","containerName":"next_feature","line":176,"kind":13},{"line":180,"kind":13,"name":"$self","containerName":"next_feature"},{"kind":12,"line":180,"name":"next_prediction","containerName":"next_feature"},{"name":"@args","containerName":"next_feature","line":180,"kind":13}],"line":175,"kind":12,"range":{"end":{"line":181,"character":9999},"start":{"line":175,"character":0}},"name":"next_feature"},{"range":{"start":{"line":201,"character":0},"end":{"character":9999,"line":210}},"name":"next_prediction","children":[{"localvar":"my","name":"$self","definition":"my","containerName":"next_prediction","line":202,"kind":13},{"containerName":"next_prediction","definition":"my","name":"$gene","localvar":"my","kind":13,"line":203},{"kind":13,"line":206,"name":"$self","containerName":"next_prediction"},{"name":"_parse_predictions","containerName":"next_prediction","line":206,"kind":12},{"line":206,"kind":13,"name":"$self","containerName":"next_prediction"},{"kind":12,"line":206,"name":"_predictions_parsed","containerName":"next_prediction"},{"containerName":"next_prediction","name":"$self","kind":13,"line":209},{"line":209,"kind":12,"name":"_prediction","containerName":"next_prediction"}],"line":201,"kind":12,"signature":{"label":"next_prediction($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: MZEF.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::MZEF\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp-at-gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::MZEF - Results of one MZEF run\n\n=head1 SYNOPSIS\n\n   $mzef = Bio::Tools::MZEF->new(-file => 'result.mzef');\n   # filehandle:\n   $mzef = Bio::Tools::MZEF->new( -fh  => \\*INPUT );\n   # to indicate that the sequence was reversed prior to feeding it to MZEF\n   # and that you want to have this reflected in the strand() attribute of \n   # the exons, as well have the coordinates translated to the non-reversed\n   # sequence\n   $mzef = Bio::Tools::MZEF->new( -file   => 'result.mzef',\n                                  -strand => -1 );\n\n   # parse the results\n   # note: this class is-a Bio::Tools::AnalysisResult which implements\n   # Bio::SeqAnalysisParserI, i.e., $genscan->next_feature() is the same\n   while($gene = $mzef->next_prediction()) {\n       # $gene is an instance of Bio::Tools::Prediction::Gene\n\n       # $gene->exons() returns an array of \n       # Bio::Tools::Prediction::Exon objects\n       # all exons:\n       @exon_arr = $gene->exons();\n\n       # internal exons only\n       @intrl_exons = $gene->exons('Internal');\n       # note that presently MZEF predicts only internal exons!\n   }\n\n   # essential if you gave a filename at initialization (otherwise the file\n   # will stay open)\n   $mzef->close();\n\n=head1 DESCRIPTION\n\nThe MZEF module provides a parser for MZEF gene structure prediction\noutput.\n\nThis module inherits off L<Bio::Tools::AnalysisResult> and therefore\nimplements L<Bio::SeqAnalysisParserI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp-at-gmx.net (or hilmar.lapp-at-pharma.novartis.com)\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::MZEF;\nuse strict;\n\nuse Bio::Tools::Prediction::Gene;\nuse Bio::Tools::Prediction::Exon;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\nsub _initialize_state {\n    my($self,@args) = @_;\n\n    # first call the inherited method!\n    my $make = $self->SUPER::_initialize_state(@args);\n\n    # handle our own parameters\n    my ($strand, $params) =\n\t$self->_rearrange([qw(STRAND\n\t\t\t      )],\n\t\t\t  @args);\n\n    # our private state variables\n    $strand = 1 unless defined($strand);\n    $self->{'_strand'} = $strand;\n    $self->{'_preds_parsed'} = 0;\n    $self->{'_has_cds'} = 0;\n    # array of pre-parsed predictions\n    $self->{'_preds'} = [];\n}\n\n=head2 analysis_method\n\n Usage     : $mzef->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /mzef/i.\n Returns   : String\n Argument  : n/a\n\n\n#-------------\nsub analysis_method { \n#-------------\n    my ($self, $method) = @_;  \n    if($method && ($method !~ /mzef/i)) {\n\t$self->throw(\"method $method not supported in \" . ref($self));\n    }\n    return $self->SUPER::analysis_method($method);\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : while($gene = $mzef->next_feature()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the MZEF result\n           file. Call this method repeatedly until FALSE is returned.\n\n           The returned object is actually a SeqFeatureI implementing object.\n           This method is required for classes implementing the\n           SeqAnalysisParserI interface, and is merely an alias for \n           next_prediction() at present.\n\n           Note that with the present version of MZEF there will only be one\n           object returned, because MZEF does not predict individual genes\n           but just potential internal exons.\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :\n\n\nsub next_feature {\n    my ($self,@args) = @_;\n    # even though next_prediction doesn't expect any args (and this method\n    # does neither), we pass on args in order to be prepared if this changes\n    # ever\n    return $self->next_prediction(@args);\n}\n\n=head2 next_prediction\n\n Title   : next_prediction\n Usage   : while($gene = $mzef->next_prediction()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the MZEF result\n           file. Call this method repeatedly until FALSE is returned.\n\n           Note that with the present version of MZEF there will only be one\n           object returned, because MZEF does not predict individual genes\n           but just potential internal exons.\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :"},"detail":"($self)","definition":"sub","containerName":"main::"},{"children":[{"line":224,"kind":13,"localvar":"my","containerName":"_parse_predictions","name":"$self","definition":"my"},{"containerName":"_parse_predictions","definition":"my","name":"$method","localvar":"my","kind":13,"line":225},{"localvar":"my","definition":"my","name":"$exon_tag","containerName":"_parse_predictions","line":226,"kind":13},{"line":227,"kind":13,"localvar":"my","name":"$gene","definition":"my","containerName":"_parse_predictions"},{"name":"$seqlen","definition":"my","containerName":"_parse_predictions","localvar":"my","kind":13,"line":229},{"line":230,"kind":13,"localvar":"my","containerName":"_parse_predictions","name":"$prednr","definition":"my"},{"name":"$self","containerName":"_parse_predictions","line":232,"kind":13},{"kind":12,"line":232,"name":"_readline","containerName":"_parse_predictions"},{"containerName":"_parse_predictions","name":"$gene","line":235,"kind":13},{"containerName":"_parse_predictions","name":"$gene","line":236,"kind":13},{"kind":12,"line":236,"name":"new","containerName":"_parse_predictions"},{"localvar":"my","containerName":"_parse_predictions","definition":"my","name":"$start","line":242,"kind":13},{"kind":13,"line":242,"containerName":"_parse_predictions","name":"$end"},{"name":"@flds","definition":"my","containerName":"_parse_predictions","localvar":"my","kind":13,"line":248},{"containerName":"_parse_predictions","name":"$predobj","definition":"my","localvar":"my","kind":13,"line":251},{"line":251,"kind":12,"name":"new","containerName":"_parse_predictions"},{"containerName":"_parse_predictions","name":"$predobj","line":253,"kind":13},{"containerName":"_parse_predictions","name":"source_tag","kind":12,"line":253},{"name":"$predobj","containerName":"_parse_predictions","line":254,"kind":13},{"name":"significance","containerName":"_parse_predictions","kind":12,"line":254},{"line":254,"kind":13,"containerName":"_parse_predictions","name":"$flds"},{"kind":13,"line":255,"name":"$predobj","containerName":"_parse_predictions"},{"name":"score","containerName":"_parse_predictions","line":255,"kind":12},{"line":255,"kind":13,"name":"$flds","containerName":"_parse_predictions"},{"kind":13,"line":256,"containerName":"_parse_predictions","name":"$predobj"},{"name":"strand","containerName":"_parse_predictions","line":256,"kind":12},{"kind":13,"line":256,"name":"$self","containerName":"_parse_predictions"},{"containerName":"_parse_predictions","name":"$predobj","line":257,"kind":13},{"kind":12,"line":257,"containerName":"_parse_predictions","name":"strand"},{"kind":13,"line":258,"name":"$predobj","containerName":"_parse_predictions"},{"name":"start","containerName":"_parse_predictions","kind":12,"line":258},{"line":258,"kind":13,"name":"$start","containerName":"_parse_predictions"},{"kind":13,"line":259,"containerName":"_parse_predictions","name":"$predobj"},{"name":"end","containerName":"_parse_predictions","kind":12,"line":259},{"kind":13,"line":259,"name":"$end","containerName":"_parse_predictions"},{"containerName":"_parse_predictions","name":"$predobj","kind":13,"line":261},{"name":"start","containerName":"_parse_predictions","kind":12,"line":261},{"containerName":"_parse_predictions","name":"$seqlen","kind":13,"line":261},{"containerName":"_parse_predictions","name":"$end","line":261,"kind":13},{"kind":13,"line":262,"containerName":"_parse_predictions","name":"$predobj"},{"kind":12,"line":262,"name":"end","containerName":"_parse_predictions"},{"line":262,"kind":13,"containerName":"_parse_predictions","name":"$seqlen"},{"line":262,"kind":13,"name":"$start","containerName":"_parse_predictions"},{"line":265,"kind":13,"name":"$predobj","containerName":"_parse_predictions"},{"name":"start_signal_score","containerName":"_parse_predictions","line":265,"kind":12},{"containerName":"_parse_predictions","name":"$flds","kind":13,"line":265},{"line":266,"kind":13,"name":"$predobj","containerName":"_parse_predictions"},{"kind":12,"line":266,"name":"end_signal_score","containerName":"_parse_predictions"},{"kind":13,"line":266,"containerName":"_parse_predictions","name":"$flds"},{"kind":13,"line":267,"name":"$predobj","containerName":"_parse_predictions"},{"line":267,"kind":12,"containerName":"_parse_predictions","name":"coding_signal_score"},{"line":267,"kind":13,"containerName":"_parse_predictions","name":"$flds"},{"localvar":"my","containerName":"_parse_predictions","definition":"my","name":"$frm","line":270,"kind":13},{"line":270,"kind":13,"containerName":"_parse_predictions","name":"$flds"},{"line":271,"kind":13,"name":"$predobj","containerName":"_parse_predictions"},{"containerName":"_parse_predictions","name":"frame","kind":12,"line":271},{"name":"$frm","containerName":"_parse_predictions","line":271,"kind":13},{"kind":13,"line":271,"containerName":"_parse_predictions","name":"$frm"},{"line":272,"kind":13,"containerName":"_parse_predictions","name":"$predobj"},{"line":272,"kind":12,"containerName":"_parse_predictions","name":"primary_tag"},{"line":272,"kind":13,"containerName":"_parse_predictions","name":"$exon_tag"},{"kind":13,"line":273,"name":"$predobj","containerName":"_parse_predictions"},{"line":273,"kind":12,"name":"is_coding","containerName":"_parse_predictions"},{"kind":13,"line":276,"name":"$gene","containerName":"_parse_predictions"},{"name":"add_exon","containerName":"_parse_predictions","kind":12,"line":276},{"containerName":"_parse_predictions","name":"$predobj","line":276,"kind":13},{"line":280,"kind":13,"name":"$self","containerName":"_parse_predictions"},{"containerName":"_parse_predictions","name":"analysis_method","kind":12,"line":280},{"containerName":"_parse_predictions","name":"$seqlen","line":286,"kind":13},{"kind":13,"line":291,"name":"$self","containerName":"_parse_predictions"},{"containerName":"_parse_predictions","name":"_add_prediction","line":291,"kind":12},{"containerName":"_parse_predictions","name":"$gene","line":291,"kind":13},{"kind":13,"line":291,"name":"$gene","containerName":"_parse_predictions"},{"containerName":"_parse_predictions","name":"$self","line":292,"kind":13},{"containerName":"_parse_predictions","name":"_predictions_parsed","kind":12,"line":292}],"line":223,"kind":12,"signature":{"documentation":"1;\n# $Id: MZEF.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::MZEF\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp-at-gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::MZEF - Results of one MZEF run\n\n=head1 SYNOPSIS\n\n   $mzef = Bio::Tools::MZEF->new(-file => 'result.mzef');\n   # filehandle:\n   $mzef = Bio::Tools::MZEF->new( -fh  => \\*INPUT );\n   # to indicate that the sequence was reversed prior to feeding it to MZEF\n   # and that you want to have this reflected in the strand() attribute of \n   # the exons, as well have the coordinates translated to the non-reversed\n   # sequence\n   $mzef = Bio::Tools::MZEF->new( -file   => 'result.mzef',\n                                  -strand => -1 );\n\n   # parse the results\n   # note: this class is-a Bio::Tools::AnalysisResult which implements\n   # Bio::SeqAnalysisParserI, i.e., $genscan->next_feature() is the same\n   while($gene = $mzef->next_prediction()) {\n       # $gene is an instance of Bio::Tools::Prediction::Gene\n\n       # $gene->exons() returns an array of \n       # Bio::Tools::Prediction::Exon objects\n       # all exons:\n       @exon_arr = $gene->exons();\n\n       # internal exons only\n       @intrl_exons = $gene->exons('Internal');\n       # note that presently MZEF predicts only internal exons!\n   }\n\n   # essential if you gave a filename at initialization (otherwise the file\n   # will stay open)\n   $mzef->close();\n\n=head1 DESCRIPTION\n\nThe MZEF module provides a parser for MZEF gene structure prediction\noutput.\n\nThis module inherits off L<Bio::Tools::AnalysisResult> and therefore\nimplements L<Bio::SeqAnalysisParserI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp-at-gmx.net (or hilmar.lapp-at-pharma.novartis.com)\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::MZEF;\nuse strict;\n\nuse Bio::Tools::Prediction::Gene;\nuse Bio::Tools::Prediction::Exon;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\nsub _initialize_state {\n    my($self,@args) = @_;\n\n    # first call the inherited method!\n    my $make = $self->SUPER::_initialize_state(@args);\n\n    # handle our own parameters\n    my ($strand, $params) =\n\t$self->_rearrange([qw(STRAND\n\t\t\t      )],\n\t\t\t  @args);\n\n    # our private state variables\n    $strand = 1 unless defined($strand);\n    $self->{'_strand'} = $strand;\n    $self->{'_preds_parsed'} = 0;\n    $self->{'_has_cds'} = 0;\n    # array of pre-parsed predictions\n    $self->{'_preds'} = [];\n}\n\n=head2 analysis_method\n\n Usage     : $mzef->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /mzef/i.\n Returns   : String\n Argument  : n/a\n\n\n#-------------\nsub analysis_method { \n#-------------\n    my ($self, $method) = @_;  \n    if($method && ($method !~ /mzef/i)) {\n\t$self->throw(\"method $method not supported in \" . ref($self));\n    }\n    return $self->SUPER::analysis_method($method);\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : while($gene = $mzef->next_feature()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the MZEF result\n           file. Call this method repeatedly until FALSE is returned.\n\n           The returned object is actually a SeqFeatureI implementing object.\n           This method is required for classes implementing the\n           SeqAnalysisParserI interface, and is merely an alias for \n           next_prediction() at present.\n\n           Note that with the present version of MZEF there will only be one\n           object returned, because MZEF does not predict individual genes\n           but just potential internal exons.\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :\n\n\nsub next_feature {\n    my ($self,@args) = @_;\n    # even though next_prediction doesn't expect any args (and this method\n    # does neither), we pass on args in order to be prepared if this changes\n    # ever\n    return $self->next_prediction(@args);\n}\n\n=head2 next_prediction\n\n Title   : next_prediction\n Usage   : while($gene = $mzef->next_prediction()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the MZEF result\n           file. Call this method repeatedly until FALSE is returned.\n\n           Note that with the present version of MZEF there will only be one\n           object returned, because MZEF does not predict individual genes\n           but just potential internal exons.\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :\n\n\nsub next_prediction {\n    my ($self) = @_;\n    my $gene;\n\n    # if the prediction section hasn't been parsed yet, we do this now\n    $self->_parse_predictions() unless $self->_predictions_parsed();\n\n    # return the next gene structure (transcript)\n    return $self->_prediction();\n}\n\n=head2 _parse_predictions\n\n Title   : _parse_predictions()\n Usage   : $obj->_parse_predictions()\n Function: Parses the prediction section. Automatically called by\n           next_prediction() if not yet done.\n Example :\n Returns : ","parameters":[{"label":"$self"}],"label":"_parse_predictions($self)"},"detail":"($self)","definition":"sub","containerName":"main::","range":{"start":{"line":223,"character":0},"end":{"line":293,"character":9999}},"name":"_parse_predictions"},{"containerName":"Tools::Prediction::Gene","name":"Bio","line":236,"kind":12},{"kind":12,"line":251,"name":"Bio","containerName":"Tools::Prediction::Exon"},{"kind":12,"children":[{"line":306,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"_prediction"},{"containerName":"_prediction","name":"$self","kind":13,"line":308},{"containerName":"_prediction","name":"$self","kind":13,"line":308}],"line":305,"definition":"sub","containerName":"main::","signature":{"documentation":"1;\n# $Id: MZEF.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::MZEF\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp-at-gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::MZEF - Results of one MZEF run\n\n=head1 SYNOPSIS\n\n   $mzef = Bio::Tools::MZEF->new(-file => 'result.mzef');\n   # filehandle:\n   $mzef = Bio::Tools::MZEF->new( -fh  => \\*INPUT );\n   # to indicate that the sequence was reversed prior to feeding it to MZEF\n   # and that you want to have this reflected in the strand() attribute of \n   # the exons, as well have the coordinates translated to the non-reversed\n   # sequence\n   $mzef = Bio::Tools::MZEF->new( -file   => 'result.mzef',\n                                  -strand => -1 );\n\n   # parse the results\n   # note: this class is-a Bio::Tools::AnalysisResult which implements\n   # Bio::SeqAnalysisParserI, i.e., $genscan->next_feature() is the same\n   while($gene = $mzef->next_prediction()) {\n       # $gene is an instance of Bio::Tools::Prediction::Gene\n\n       # $gene->exons() returns an array of \n       # Bio::Tools::Prediction::Exon objects\n       # all exons:\n       @exon_arr = $gene->exons();\n\n       # internal exons only\n       @intrl_exons = $gene->exons('Internal');\n       # note that presently MZEF predicts only internal exons!\n   }\n\n   # essential if you gave a filename at initialization (otherwise the file\n   # will stay open)\n   $mzef->close();\n\n=head1 DESCRIPTION\n\nThe MZEF module provides a parser for MZEF gene structure prediction\noutput.\n\nThis module inherits off L<Bio::Tools::AnalysisResult> and therefore\nimplements L<Bio::SeqAnalysisParserI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp-at-gmx.net (or hilmar.lapp-at-pharma.novartis.com)\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::MZEF;\nuse strict;\n\nuse Bio::Tools::Prediction::Gene;\nuse Bio::Tools::Prediction::Exon;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\nsub _initialize_state {\n    my($self,@args) = @_;\n\n    # first call the inherited method!\n    my $make = $self->SUPER::_initialize_state(@args);\n\n    # handle our own parameters\n    my ($strand, $params) =\n\t$self->_rearrange([qw(STRAND\n\t\t\t      )],\n\t\t\t  @args);\n\n    # our private state variables\n    $strand = 1 unless defined($strand);\n    $self->{'_strand'} = $strand;\n    $self->{'_preds_parsed'} = 0;\n    $self->{'_has_cds'} = 0;\n    # array of pre-parsed predictions\n    $self->{'_preds'} = [];\n}\n\n=head2 analysis_method\n\n Usage     : $mzef->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /mzef/i.\n Returns   : String\n Argument  : n/a\n\n\n#-------------\nsub analysis_method { \n#-------------\n    my ($self, $method) = @_;  \n    if($method && ($method !~ /mzef/i)) {\n\t$self->throw(\"method $method not supported in \" . ref($self));\n    }\n    return $self->SUPER::analysis_method($method);\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : while($gene = $mzef->next_feature()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the MZEF result\n           file. Call this method repeatedly until FALSE is returned.\n\n           The returned object is actually a SeqFeatureI implementing object.\n           This method is required for classes implementing the\n           SeqAnalysisParserI interface, and is merely an alias for \n           next_prediction() at present.\n\n           Note that with the present version of MZEF there will only be one\n           object returned, because MZEF does not predict individual genes\n           but just potential internal exons.\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :\n\n\nsub next_feature {\n    my ($self,@args) = @_;\n    # even though next_prediction doesn't expect any args (and this method\n    # does neither), we pass on args in order to be prepared if this changes\n    # ever\n    return $self->next_prediction(@args);\n}\n\n=head2 next_prediction\n\n Title   : next_prediction\n Usage   : while($gene = $mzef->next_prediction()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the MZEF result\n           file. Call this method repeatedly until FALSE is returned.\n\n           Note that with the present version of MZEF there will only be one\n           object returned, because MZEF does not predict individual genes\n           but just potential internal exons.\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :\n\n\nsub next_prediction {\n    my ($self) = @_;\n    my $gene;\n\n    # if the prediction section hasn't been parsed yet, we do this now\n    $self->_parse_predictions() unless $self->_predictions_parsed();\n\n    # return the next gene structure (transcript)\n    return $self->_prediction();\n}\n\n=head2 _parse_predictions\n\n Title   : _parse_predictions()\n Usage   : $obj->_parse_predictions()\n Function: Parses the prediction section. Automatically called by\n           next_prediction() if not yet done.\n Example :\n Returns : \n\n\nsub _parse_predictions {\n    my ($self) = @_;\n    my ($method); # set but not used presently\n    my $exon_tag = \"InternalExon\";\n    my $gene;\n    # my $seqname; # name given in output is poorly formatted\n    my $seqlen;\n    my $prednr = 1;\n\n    while(defined($_ = $self->_readline())) {\n\tif(/^\\s*(\\d+)\\s*-\\s*(\\d+)\\s+/) {\n\t    # exon or signal\n\t    if(! defined($gene)) {\n\t\t$gene = Bio::Tools::Prediction::Gene->new(\n                                       '-primary' => \"GenePrediction$prednr\",\n\t\t\t\t       '-source' => 'MZEF');\n\t    }\n\t    # we handle start-end first because may not be space delimited\n\t    # for large numbers\n\t    my ($start,$end) = ($1,$2);\n\t    s/^\\s*(\\d+)\\s*-\\s*(\\d+)\\s+//;\n\t    # split the rest into fields\n\t    chomp();\n\t    # format: Coordinates P Fr1 Fr2 Fr3 Orf 3ss Cds 5ss\n\t    # index:              0   1   2   3   4   5   6   7\n\t    my @flds = split(' ', $_);\n\t    # create the feature object depending on the type of signal --\n\t    # which is always an (internal) exon for MZEF\n\t    my $predobj = Bio::Tools::Prediction::Exon->new();\n\t    # set common fields\n\t    $predobj->source_tag('MZEF');\n\t    $predobj->significance($flds[0]);\n\t    $predobj->score($flds[0]); # what shall we set as overall score?\n\t    $predobj->strand($self->{'_strand'}); # MZEF searches only one\n\t    if($predobj->strand() == 1) {\n\t\t$predobj->start($start);\n\t\t$predobj->end($end);\n\t    } else {\n\t\t$predobj->start($seqlen-$end+1);\n\t\t$predobj->end($seqlen-$start+1);\n\t    }\n\t    # set scores\n\t    $predobj->start_signal_score($flds[5]);\n\t    $predobj->end_signal_score($flds[7]);\n\t    $predobj->coding_signal_score($flds[6]);\n\t    # frame -- we simply extract the one with highest score from the\n\t    # orf field, and store the individual scores for now\n\t    my $frm = index($flds[4], \"1\");\n\t    $predobj->frame(($frm < 0) ? undef : $frm);\n\t    $predobj->primary_tag($exon_tag);\n\t    $predobj->is_coding(1);\n\t    # add to gene structure (should be done only when start and end\n\t    # are set, in order to allow for proper expansion of the range)\n\t    $gene->add_exon($predobj);\t\t\n\t    next;\n\t}\n\tif(/^\\s*Internal .*(MZEF)/) {\n\t    $self->analysis_method($1);\n\t    next;\n\t}\n\tif(/^\\s*File_Name:\\s+(\\S+)\\s+Sequence_length:\\s+(\\d+)/) {\n\t    # $seqname = $1; # this is too poor currently (file name truncated\n                             # to 10 chars) in order to be sensible enough\n\t    $seqlen = $2;\n\t    next;\n\t}\n    }\n    # $gene->seq_id($seqname);\n    $self->_add_prediction($gene) if defined($gene);\n    $self->_predictions_parsed(1);\n}\n\n=head2 _prediction\n\n Title   : _prediction()\n Usage   : $gene = $obj->_prediction()\n Function: internal\n Example :\n Returns : ","parameters":[{"label":"$self"}],"label":"_prediction($self)"},"detail":"($self)","name":"_prediction","range":{"start":{"line":305,"character":0},"end":{"character":9999,"line":308}}},{"kind":13,"line":309,"containerName":null,"name":"%self"},{"name":"_add_prediction","range":{"end":{"character":9999,"line":328},"start":{"line":322,"character":0}},"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"$gene"}],"documentation":"1;\n# $Id: MZEF.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::MZEF\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp-at-gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::MZEF - Results of one MZEF run\n\n=head1 SYNOPSIS\n\n   $mzef = Bio::Tools::MZEF->new(-file => 'result.mzef');\n   # filehandle:\n   $mzef = Bio::Tools::MZEF->new( -fh  => \\*INPUT );\n   # to indicate that the sequence was reversed prior to feeding it to MZEF\n   # and that you want to have this reflected in the strand() attribute of \n   # the exons, as well have the coordinates translated to the non-reversed\n   # sequence\n   $mzef = Bio::Tools::MZEF->new( -file   => 'result.mzef',\n                                  -strand => -1 );\n\n   # parse the results\n   # note: this class is-a Bio::Tools::AnalysisResult which implements\n   # Bio::SeqAnalysisParserI, i.e., $genscan->next_feature() is the same\n   while($gene = $mzef->next_prediction()) {\n       # $gene is an instance of Bio::Tools::Prediction::Gene\n\n       # $gene->exons() returns an array of \n       # Bio::Tools::Prediction::Exon objects\n       # all exons:\n       @exon_arr = $gene->exons();\n\n       # internal exons only\n       @intrl_exons = $gene->exons('Internal');\n       # note that presently MZEF predicts only internal exons!\n   }\n\n   # essential if you gave a filename at initialization (otherwise the file\n   # will stay open)\n   $mzef->close();\n\n=head1 DESCRIPTION\n\nThe MZEF module provides a parser for MZEF gene structure prediction\noutput.\n\nThis module inherits off L<Bio::Tools::AnalysisResult> and therefore\nimplements L<Bio::SeqAnalysisParserI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp-at-gmx.net (or hilmar.lapp-at-pharma.novartis.com)\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::MZEF;\nuse strict;\n\nuse Bio::Tools::Prediction::Gene;\nuse Bio::Tools::Prediction::Exon;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\nsub _initialize_state {\n    my($self,@args) = @_;\n\n    # first call the inherited method!\n    my $make = $self->SUPER::_initialize_state(@args);\n\n    # handle our own parameters\n    my ($strand, $params) =\n\t$self->_rearrange([qw(STRAND\n\t\t\t      )],\n\t\t\t  @args);\n\n    # our private state variables\n    $strand = 1 unless defined($strand);\n    $self->{'_strand'} = $strand;\n    $self->{'_preds_parsed'} = 0;\n    $self->{'_has_cds'} = 0;\n    # array of pre-parsed predictions\n    $self->{'_preds'} = [];\n}\n\n=head2 analysis_method\n\n Usage     : $mzef->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /mzef/i.\n Returns   : String\n Argument  : n/a\n\n\n#-------------\nsub analysis_method { \n#-------------\n    my ($self, $method) = @_;  \n    if($method && ($method !~ /mzef/i)) {\n\t$self->throw(\"method $method not supported in \" . ref($self));\n    }\n    return $self->SUPER::analysis_method($method);\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : while($gene = $mzef->next_feature()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the MZEF result\n           file. Call this method repeatedly until FALSE is returned.\n\n           The returned object is actually a SeqFeatureI implementing object.\n           This method is required for classes implementing the\n           SeqAnalysisParserI interface, and is merely an alias for \n           next_prediction() at present.\n\n           Note that with the present version of MZEF there will only be one\n           object returned, because MZEF does not predict individual genes\n           but just potential internal exons.\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :\n\n\nsub next_feature {\n    my ($self,@args) = @_;\n    # even though next_prediction doesn't expect any args (and this method\n    # does neither), we pass on args in order to be prepared if this changes\n    # ever\n    return $self->next_prediction(@args);\n}\n\n=head2 next_prediction\n\n Title   : next_prediction\n Usage   : while($gene = $mzef->next_prediction()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the MZEF result\n           file. Call this method repeatedly until FALSE is returned.\n\n           Note that with the present version of MZEF there will only be one\n           object returned, because MZEF does not predict individual genes\n           but just potential internal exons.\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :\n\n\nsub next_prediction {\n    my ($self) = @_;\n    my $gene;\n\n    # if the prediction section hasn't been parsed yet, we do this now\n    $self->_parse_predictions() unless $self->_predictions_parsed();\n\n    # return the next gene structure (transcript)\n    return $self->_prediction();\n}\n\n=head2 _parse_predictions\n\n Title   : _parse_predictions()\n Usage   : $obj->_parse_predictions()\n Function: Parses the prediction section. Automatically called by\n           next_prediction() if not yet done.\n Example :\n Returns : \n\n\nsub _parse_predictions {\n    my ($self) = @_;\n    my ($method); # set but not used presently\n    my $exon_tag = \"InternalExon\";\n    my $gene;\n    # my $seqname; # name given in output is poorly formatted\n    my $seqlen;\n    my $prednr = 1;\n\n    while(defined($_ = $self->_readline())) {\n\tif(/^\\s*(\\d+)\\s*-\\s*(\\d+)\\s+/) {\n\t    # exon or signal\n\t    if(! defined($gene)) {\n\t\t$gene = Bio::Tools::Prediction::Gene->new(\n                                       '-primary' => \"GenePrediction$prednr\",\n\t\t\t\t       '-source' => 'MZEF');\n\t    }\n\t    # we handle start-end first because may not be space delimited\n\t    # for large numbers\n\t    my ($start,$end) = ($1,$2);\n\t    s/^\\s*(\\d+)\\s*-\\s*(\\d+)\\s+//;\n\t    # split the rest into fields\n\t    chomp();\n\t    # format: Coordinates P Fr1 Fr2 Fr3 Orf 3ss Cds 5ss\n\t    # index:              0   1   2   3   4   5   6   7\n\t    my @flds = split(' ', $_);\n\t    # create the feature object depending on the type of signal --\n\t    # which is always an (internal) exon for MZEF\n\t    my $predobj = Bio::Tools::Prediction::Exon->new();\n\t    # set common fields\n\t    $predobj->source_tag('MZEF');\n\t    $predobj->significance($flds[0]);\n\t    $predobj->score($flds[0]); # what shall we set as overall score?\n\t    $predobj->strand($self->{'_strand'}); # MZEF searches only one\n\t    if($predobj->strand() == 1) {\n\t\t$predobj->start($start);\n\t\t$predobj->end($end);\n\t    } else {\n\t\t$predobj->start($seqlen-$end+1);\n\t\t$predobj->end($seqlen-$start+1);\n\t    }\n\t    # set scores\n\t    $predobj->start_signal_score($flds[5]);\n\t    $predobj->end_signal_score($flds[7]);\n\t    $predobj->coding_signal_score($flds[6]);\n\t    # frame -- we simply extract the one with highest score from the\n\t    # orf field, and store the individual scores for now\n\t    my $frm = index($flds[4], \"1\");\n\t    $predobj->frame(($frm < 0) ? undef : $frm);\n\t    $predobj->primary_tag($exon_tag);\n\t    $predobj->is_coding(1);\n\t    # add to gene structure (should be done only when start and end\n\t    # are set, in order to allow for proper expansion of the range)\n\t    $gene->add_exon($predobj);\t\t\n\t    next;\n\t}\n\tif(/^\\s*Internal .*(MZEF)/) {\n\t    $self->analysis_method($1);\n\t    next;\n\t}\n\tif(/^\\s*File_Name:\\s+(\\S+)\\s+Sequence_length:\\s+(\\d+)/) {\n\t    # $seqname = $1; # this is too poor currently (file name truncated\n                             # to 10 chars) in order to be sensible enough\n\t    $seqlen = $2;\n\t    next;\n\t}\n    }\n    # $gene->seq_id($seqname);\n    $self->_add_prediction($gene) if defined($gene);\n    $self->_predictions_parsed(1);\n}\n\n=head2 _prediction\n\n Title   : _prediction()\n Usage   : $gene = $obj->_prediction()\n Function: internal\n Example :\n Returns : \n\n\nsub _prediction {\n    my ($self) = @_;\n\n    return unless(exists($self->{'_preds'}) && @{$self->{'_preds'}});\n    return shift(@{$self->{'_preds'}});\n}\n\n=head2 _add_prediction\n\n Title   : _add_prediction()\n Usage   : $obj->_add_prediction($gene)\n Function: internal\n Example :\n Returns : ","label":"_add_prediction($self,$gene)"},"detail":"($self,$gene)","kind":12,"children":[{"name":"$self","definition":"my","containerName":"_add_prediction","localvar":"my","kind":13,"line":323},{"name":"$gene","containerName":"_add_prediction","kind":13,"line":323},{"kind":13,"line":325,"containerName":"_add_prediction","name":"$self"},{"containerName":"_add_prediction","name":"$self","kind":13,"line":326},{"containerName":"_add_prediction","name":"$self","line":328,"kind":13}],"line":322},{"kind":13,"line":328,"name":"$gene","containerName":null},{"range":{"start":{"character":0,"line":341},"end":{"character":9999,"line":349}},"name":"_predictions_parsed","signature":{"parameters":[{"label":"$self"},{"label":"$val"}],"documentation":"1;\n# $Id: MZEF.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::MZEF\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp-at-gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::MZEF - Results of one MZEF run\n\n=head1 SYNOPSIS\n\n   $mzef = Bio::Tools::MZEF->new(-file => 'result.mzef');\n   # filehandle:\n   $mzef = Bio::Tools::MZEF->new( -fh  => \\*INPUT );\n   # to indicate that the sequence was reversed prior to feeding it to MZEF\n   # and that you want to have this reflected in the strand() attribute of \n   # the exons, as well have the coordinates translated to the non-reversed\n   # sequence\n   $mzef = Bio::Tools::MZEF->new( -file   => 'result.mzef',\n                                  -strand => -1 );\n\n   # parse the results\n   # note: this class is-a Bio::Tools::AnalysisResult which implements\n   # Bio::SeqAnalysisParserI, i.e., $genscan->next_feature() is the same\n   while($gene = $mzef->next_prediction()) {\n       # $gene is an instance of Bio::Tools::Prediction::Gene\n\n       # $gene->exons() returns an array of \n       # Bio::Tools::Prediction::Exon objects\n       # all exons:\n       @exon_arr = $gene->exons();\n\n       # internal exons only\n       @intrl_exons = $gene->exons('Internal');\n       # note that presently MZEF predicts only internal exons!\n   }\n\n   # essential if you gave a filename at initialization (otherwise the file\n   # will stay open)\n   $mzef->close();\n\n=head1 DESCRIPTION\n\nThe MZEF module provides a parser for MZEF gene structure prediction\noutput.\n\nThis module inherits off L<Bio::Tools::AnalysisResult> and therefore\nimplements L<Bio::SeqAnalysisParserI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp-at-gmx.net (or hilmar.lapp-at-pharma.novartis.com)\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::MZEF;\nuse strict;\n\nuse Bio::Tools::Prediction::Gene;\nuse Bio::Tools::Prediction::Exon;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\nsub _initialize_state {\n    my($self,@args) = @_;\n\n    # first call the inherited method!\n    my $make = $self->SUPER::_initialize_state(@args);\n\n    # handle our own parameters\n    my ($strand, $params) =\n\t$self->_rearrange([qw(STRAND\n\t\t\t      )],\n\t\t\t  @args);\n\n    # our private state variables\n    $strand = 1 unless defined($strand);\n    $self->{'_strand'} = $strand;\n    $self->{'_preds_parsed'} = 0;\n    $self->{'_has_cds'} = 0;\n    # array of pre-parsed predictions\n    $self->{'_preds'} = [];\n}\n\n=head2 analysis_method\n\n Usage     : $mzef->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /mzef/i.\n Returns   : String\n Argument  : n/a\n\n\n#-------------\nsub analysis_method { \n#-------------\n    my ($self, $method) = @_;  \n    if($method && ($method !~ /mzef/i)) {\n\t$self->throw(\"method $method not supported in \" . ref($self));\n    }\n    return $self->SUPER::analysis_method($method);\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : while($gene = $mzef->next_feature()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the MZEF result\n           file. Call this method repeatedly until FALSE is returned.\n\n           The returned object is actually a SeqFeatureI implementing object.\n           This method is required for classes implementing the\n           SeqAnalysisParserI interface, and is merely an alias for \n           next_prediction() at present.\n\n           Note that with the present version of MZEF there will only be one\n           object returned, because MZEF does not predict individual genes\n           but just potential internal exons.\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :\n\n\nsub next_feature {\n    my ($self,@args) = @_;\n    # even though next_prediction doesn't expect any args (and this method\n    # does neither), we pass on args in order to be prepared if this changes\n    # ever\n    return $self->next_prediction(@args);\n}\n\n=head2 next_prediction\n\n Title   : next_prediction\n Usage   : while($gene = $mzef->next_prediction()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the MZEF result\n           file. Call this method repeatedly until FALSE is returned.\n\n           Note that with the present version of MZEF there will only be one\n           object returned, because MZEF does not predict individual genes\n           but just potential internal exons.\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :\n\n\nsub next_prediction {\n    my ($self) = @_;\n    my $gene;\n\n    # if the prediction section hasn't been parsed yet, we do this now\n    $self->_parse_predictions() unless $self->_predictions_parsed();\n\n    # return the next gene structure (transcript)\n    return $self->_prediction();\n}\n\n=head2 _parse_predictions\n\n Title   : _parse_predictions()\n Usage   : $obj->_parse_predictions()\n Function: Parses the prediction section. Automatically called by\n           next_prediction() if not yet done.\n Example :\n Returns : \n\n\nsub _parse_predictions {\n    my ($self) = @_;\n    my ($method); # set but not used presently\n    my $exon_tag = \"InternalExon\";\n    my $gene;\n    # my $seqname; # name given in output is poorly formatted\n    my $seqlen;\n    my $prednr = 1;\n\n    while(defined($_ = $self->_readline())) {\n\tif(/^\\s*(\\d+)\\s*-\\s*(\\d+)\\s+/) {\n\t    # exon or signal\n\t    if(! defined($gene)) {\n\t\t$gene = Bio::Tools::Prediction::Gene->new(\n                                       '-primary' => \"GenePrediction$prednr\",\n\t\t\t\t       '-source' => 'MZEF');\n\t    }\n\t    # we handle start-end first because may not be space delimited\n\t    # for large numbers\n\t    my ($start,$end) = ($1,$2);\n\t    s/^\\s*(\\d+)\\s*-\\s*(\\d+)\\s+//;\n\t    # split the rest into fields\n\t    chomp();\n\t    # format: Coordinates P Fr1 Fr2 Fr3 Orf 3ss Cds 5ss\n\t    # index:              0   1   2   3   4   5   6   7\n\t    my @flds = split(' ', $_);\n\t    # create the feature object depending on the type of signal --\n\t    # which is always an (internal) exon for MZEF\n\t    my $predobj = Bio::Tools::Prediction::Exon->new();\n\t    # set common fields\n\t    $predobj->source_tag('MZEF');\n\t    $predobj->significance($flds[0]);\n\t    $predobj->score($flds[0]); # what shall we set as overall score?\n\t    $predobj->strand($self->{'_strand'}); # MZEF searches only one\n\t    if($predobj->strand() == 1) {\n\t\t$predobj->start($start);\n\t\t$predobj->end($end);\n\t    } else {\n\t\t$predobj->start($seqlen-$end+1);\n\t\t$predobj->end($seqlen-$start+1);\n\t    }\n\t    # set scores\n\t    $predobj->start_signal_score($flds[5]);\n\t    $predobj->end_signal_score($flds[7]);\n\t    $predobj->coding_signal_score($flds[6]);\n\t    # frame -- we simply extract the one with highest score from the\n\t    # orf field, and store the individual scores for now\n\t    my $frm = index($flds[4], \"1\");\n\t    $predobj->frame(($frm < 0) ? undef : $frm);\n\t    $predobj->primary_tag($exon_tag);\n\t    $predobj->is_coding(1);\n\t    # add to gene structure (should be done only when start and end\n\t    # are set, in order to allow for proper expansion of the range)\n\t    $gene->add_exon($predobj);\t\t\n\t    next;\n\t}\n\tif(/^\\s*Internal .*(MZEF)/) {\n\t    $self->analysis_method($1);\n\t    next;\n\t}\n\tif(/^\\s*File_Name:\\s+(\\S+)\\s+Sequence_length:\\s+(\\d+)/) {\n\t    # $seqname = $1; # this is too poor currently (file name truncated\n                             # to 10 chars) in order to be sensible enough\n\t    $seqlen = $2;\n\t    next;\n\t}\n    }\n    # $gene->seq_id($seqname);\n    $self->_add_prediction($gene) if defined($gene);\n    $self->_predictions_parsed(1);\n}\n\n=head2 _prediction\n\n Title   : _prediction()\n Usage   : $gene = $obj->_prediction()\n Function: internal\n Example :\n Returns : \n\n\nsub _prediction {\n    my ($self) = @_;\n\n    return unless(exists($self->{'_preds'}) && @{$self->{'_preds'}});\n    return shift(@{$self->{'_preds'}});\n}\n\n=head2 _add_prediction\n\n Title   : _add_prediction()\n Usage   : $obj->_add_prediction($gene)\n Function: internal\n Example :\n Returns : \n\n\nsub _add_prediction {\n    my ($self, $gene) = @_;\n\n    if(! exists($self->{'_preds'})) {\n\t$self->{'_preds'} = [];\n    }\n    push(@{$self->{'_preds'}}, $gene);\n}\n\n=head2 _predictions_parsed\n\n Title   : _predictions_parsed\n Usage   : $obj->_predictions_parsed\n Function: internal\n Example :\n Returns : TRUE or FALSE","label":"_predictions_parsed($self,$val)"},"detail":"($self,$val)","definition":"sub","containerName":"main::","children":[{"line":342,"kind":13,"localvar":"my","containerName":"_predictions_parsed","name":"$self","definition":"my"},{"name":"$val","containerName":"_predictions_parsed","kind":13,"line":342},{"line":344,"kind":13,"name":"$self","containerName":"_predictions_parsed"},{"line":344,"kind":13,"containerName":"_predictions_parsed","name":"$val"},{"containerName":"_predictions_parsed","name":"$val","kind":13,"line":344},{"line":345,"kind":13,"name":"$self","containerName":"_predictions_parsed"},{"containerName":"_predictions_parsed","name":"$self","line":346,"kind":13},{"containerName":"_predictions_parsed","name":"$self","line":348,"kind":13}],"line":341,"kind":12}],"version":5}