{"version":5,"vars":[{"kind":2,"line":167,"containerName":"","name":"vars"},{"containerName":"","name":"base","kind":2,"line":171},{"containerName":null,"name":"@ATTR","line":172,"kind":13},{"kind":13,"line":173,"definition":"my","name":"$attr","containerName":null,"localvar":"my"},{"name":"@ATTR","containerName":null,"line":173,"kind":13},{"kind":13,"line":174,"name":"%OK_FIELD","containerName":null},{"line":174,"kind":13,"containerName":null,"name":"$attr"},{"children":[{"localvar":"my","containerName":"AUTOLOAD","name":"$self","definition":"my","line":178,"kind":13},{"localvar":"my","definition":"my","name":"$attr","containerName":"AUTOLOAD","line":179,"kind":13},{"line":179,"kind":13,"containerName":"AUTOLOAD","name":"$AUTOLOAD"},{"kind":13,"line":180,"containerName":"AUTOLOAD","name":"$attr"},{"name":"$attr","containerName":"AUTOLOAD","kind":13,"line":181},{"name":"$attr","containerName":"AUTOLOAD","kind":13,"line":181},{"containerName":"AUTOLOAD","name":"$self","line":182,"kind":13},{"line":182,"kind":12,"containerName":"AUTOLOAD","name":"throw"},{"line":182,"kind":13,"name":"$OK_FIELD","containerName":"AUTOLOAD"},{"name":"$attr","containerName":"AUTOLOAD","line":182,"kind":13},{"kind":13,"line":183,"name":"$self","containerName":"AUTOLOAD"},{"line":183,"kind":13,"name":"$attr","containerName":"AUTOLOAD"},{"line":184,"kind":13,"containerName":"AUTOLOAD","name":"$self"},{"containerName":"AUTOLOAD","name":"$attr","line":184,"kind":13}],"line":177,"kind":12,"range":{"start":{"line":177,"character":0},"end":{"character":9999,"line":185}},"name":"AUTOLOAD","definition":"sub","containerName":"main::"},{"range":{"end":{"character":9999,"line":244},"start":{"line":232,"character":0}},"name":"new","signature":{"parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: Lucy.pm 16123 2009-09-17 12:57:27Z cjfields $ \n#\n# BioPerl module for Bio::Tools::Lucy\n#\n# Copyright Her Majesty the Queen of England\n# written by Andrew Walsh (paeruginosa@hotmail.com) during employment with \n# Agriculture and Agri-food Canada, Cereal Research Centre, Winnipeg, MB\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Lucy - Object for analyzing the output from Lucy,\n  a vector and quality trimming program from TIGR\n\n=head1 SYNOPSIS\n\n  # Create the Lucy object from an existing Lucy output file\n  @params = ('seqfile' => 'lucy.seq', 'lucy_verbose' => 1);\n  $lucyObj = Bio::Tools::Lucy->new(@params);\n\n  # Get names of all sequences\n  $names = $lucyObj->get_sequence_names();\n\n  #  Print seq and qual values for sequences >400 bp in order to run CAP3\n  foreach $name (@$names) {\n      next unless $lucyObj->length_clear($name) > 400;\n      print SEQ \">$name\\n\", $lucyObj->sequence($name), \"\\n\";\n      print QUAL \">$name\\n\", $lucyObj->quality($name), \"\\n\";\n  }\n\n  # Get an array of Bio::PrimarySeq objects\n  @seqObjs = $lucyObj->get_Seq_Objs();\n\n\n=head1 DESCRIPTION\n\nBio::Tools::Lucy.pm provides methods for analyzing the sequence and\nquality values generated by Lucy program from TIGR.\n\nLucy will identify vector, poly-A/T tails, and poor quality regions in\na sequence.  (www.genomics.purdue.edu/gcg/other/lucy.pdf)\n\nThe input to Lucy can be the Phred sequence and quality files\ngenerated from running Phred on a set of chromatograms.\n\nLucy can be obtained (free of charge to academic users) from\nwww.tigr.org/softlab\n\nThere are a few methods that will only be available if you make some\nminor changes to the source for Lucy and then recompile.  The changes\nare in the 'lucy.c' file and there is a diff between the original and\nthe modified file in the Appendix\n\nPlease contact the author of this module if you have any problems\nmaking these modifications.\n\nYou do not have to make these modifications to use this module.\n\n=head2 Creating a Lucy object\n\n  @params = ('seqfile' => 'lucy.seq', 'adv_stderr' => 1, \n\t     'fwd_desig' => '_F', 'rev_desig' => '_R');\n  $lucyObj = Bio::Tools::Lucy->new(@params);\n\n=head2 Using a Lucy object\n\n  You should get an array with the sequence names in order to use\n  accessor methods.  Note: The Lucy binary program will fail unless\n  the sequence names provided as input are unique.\n\n  $names_ref = $lucyObj->get_sequence_names();\n\n  This code snippet will produce a Fasta format file with sequence\n  lengths and %GC in the description line.\n\n  foreach $name (@$names) {\n      print FILE \">$name\\t\",\n\t\t $lucyObj->length_clear($name), \"\\t\",\n\t\t $lucyObj->per_GC($name), \"\\n\",\n\t\t $lucyObj->sequence($name), \"\\n\";\n  }\n\n\n  Print seq and qual values for sequences >400 bp in order to assemble\n  them with CAP3 (or other assembler).\n\n  foreach $name (@$names) {\n      next unless $lucyObj->length_clear($name) > 400;\n      print SEQ \">$name\\n\", $lucyObj->sequence($name), \"\\n\";\n      print QUAL \">$name\\n\", $lucyObj->quality($name), \"\\n\";\n  }\n\n  Get all the sequences as Bio::PrimarySeq objects (eg., for use with\n  Bio::Tools::Run::StandaloneBlast to perform BLAST).\n\n  @seqObjs = $lucyObj->get_Seq_Objs();\n\n  Or use only those sequences that are full length and have a Poly-A\n  tail.\n\n  foreach $name (@$names) {\n      next unless ($lucyObj->full_length($name) and $lucy->polyA($name));\n      push @seqObjs, $lucyObj->get_Seq_Obj($name);\n  }\n\n\n  Get the names of those sequences that were rejected by Lucy.\n\n  $rejects_ref = $lucyObj->get_rejects();\n\n  Print the names of the rejects and 1 letter code for reason they\n  were rejected.\n\n  foreach $key (sort keys %$rejects_ref) {\n      print \"$key:  \", $rejects_ref->{$key};\n  }\n\n  There is a lot of other information available about the sequences\n  analyzed by Lucy (see APPENDIX).  This module can be used with the\n  DBI module to store this sequence information in a database.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules.  Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nAndrew G. Walsh\t\tpaeruginosa@hotmail.com\n\n=head1 APPENDIX\n\nMethods available to Lucy objects are described below.  Please note\nthat any method beginning with an underscore is considered internal\nand should not be called directly.\n\n\n\npackage Bio::Tools::Lucy;\n\nuse vars qw($AUTOLOAD @ATTR %OK_FIELD);\nuse strict;\nuse Bio::PrimarySeq;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n@ATTR = qw(seqfile qualfile stderrfile infofile lucy_verbose fwd_desig rev_desig adv_stderr); \nforeach my $attr (@ATTR) {\n    $OK_FIELD{$attr}++\n}\n\nsub AUTOLOAD {\n    my $self = shift;\n    my $attr = $AUTOLOAD;\n    $attr =~ s/.*:://;\n    $attr = lc $attr;\n    $self->throw(\"Unallowed parameter: $attr !\") unless $OK_FIELD{$attr};\n    $self->{$attr} = shift if @_;\n    return $self->{$attr};\n}\n\n=head2 new\n\n Title\t :  new\n Usage\t :  $lucyObj = Bio::Tools::Lucy->new(seqfile => lucy.seq, rev_desig => '_R', \n\t    fwd_desig => '_F')\n Function:  creates a Lucy object from Lucy analysis files\n Returns :  reference to Bio::Tools::Lucy object\n Args\t :  seqfile\tFasta sequence file generated by Lucy\n\t       qualfile\tQuality values file generated by Lucy\n\t       infofile\tInfo file created when Lucy is run with -debug \n                     'infofile' option\n\t       stderrfile\tStandard error captured from Lucy when Lucy is run \n\t\t\t with -info option and STDERR is directed to stderrfile \n\t\t\t (ie. lucy ... 2> stderrfile).\n\t\t\t Info in this file will include sequences dropped for low \n\t\t\t quality. If you've modified Lucy source (see adv_stderr below), \n\t\t\t it will also include info on which sequences were dropped because \n\t\t\t they were vector, too short, had no insert, and whether a poly-A \n\t\t\t tail was found (if Lucy was run with -cdna option).\n\t       lucy_verbose verbosity level (0-1).  \n\t       fwd_desig\tThe string used to determine whether sequence is a \n          forward read.  \n\t\t\t The parser will assume that this match will occus at the \n\t\t\t end of the sequence name string.\n\t       rev_desig\tAs above, for reverse reads. \n \t       adv_stderr\tCan be set to a true value (1).  Will only work if \n          you have modified \n\t\t\t the Lucy source code as outlined in DESCRIPTION and capture \n\t\t\t the standard error from Lucy.\n\nIf you don't provide filenames for qualfile, infofile or stderrfile,\nthe module will assume that .qual, .info, and .stderr are the file\nextensions and search in the same directory as the .seq file for these\nfiles.\n\nFor example, if you create a Lucy object with $lucyObj =\nBio::Tools::Lucy-E<gt>new(seqfile =E<gt>lucy.seq), the module will\nfind lucy.qual, lucy.info and lucy.stderr.\n\nYou can omit any or all of the quality, info or stderr files, but you\nwill not be able to use all of the object methods (see method\ndocumentation below).","label":"new($class,@args)"},"detail":"($class,@args)","definition":"sub","containerName":"main::","children":[{"kind":13,"line":233,"definition":"my","name":"$class","containerName":"new","localvar":"my"},{"name":"@args","containerName":"new","line":233,"kind":13},{"localvar":"my","containerName":"new","name":"$self","definition":"my","line":234,"kind":13},{"kind":13,"line":234,"containerName":"new","name":"$class"},{"line":234,"kind":13,"containerName":"new","name":"@args"},{"localvar":"my","containerName":"new","definition":"my","name":"$attr","line":235,"kind":13},{"line":235,"kind":13,"name":"$value","containerName":"new"},{"containerName":"new","name":"@args","kind":13,"line":236},{"line":237,"kind":13,"name":"$attr","containerName":"new"},{"name":"@args","containerName":"new","kind":13,"line":237},{"line":238,"kind":13,"containerName":"new","name":"$attr"},{"line":238,"kind":13,"name":"$attr","containerName":"new"},{"kind":13,"line":239,"name":"$value","containerName":"new"},{"containerName":"new","name":"@args","kind":13,"line":239},{"containerName":"new","name":"$self","line":240,"kind":13},{"name":"$attr","containerName":"new","kind":13,"line":240},{"containerName":"new","name":"$value","kind":13,"line":240},{"line":242,"kind":13,"name":"$self","containerName":"new"},{"kind":13,"line":243,"containerName":"new","name":"$self"}],"line":232,"kind":12},{"containerName":"new","name":"SUPER","line":234,"kind":12},{"name":"_parse","line":242,"kind":12},{"kind":12,"line":256,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"_parse","line":257,"kind":13},{"kind":13,"line":258,"name":"$self","containerName":"_parse"},{"line":259,"kind":13,"localvar":"my","containerName":"_parse","name":"$file","definition":"my"},{"line":261,"kind":13,"containerName":"_parse","name":"$self"},{"containerName":"_parse","name":"warn","line":261,"kind":12},{"line":261,"kind":13,"containerName":"_parse","name":"$self"},{"kind":13,"line":262,"name":"$SEQ","definition":"my","containerName":"_parse","localvar":"my"},{"containerName":"_parse","name":"$self","line":262,"kind":13},{"kind":13,"line":262,"containerName":"_parse","name":"$self"},{"line":262,"kind":12,"containerName":"_parse","name":"throw"},{"kind":13,"line":263,"definition":"my","name":"$name","containerName":"_parse","localvar":"my"},{"name":"$line","containerName":"_parse","line":263,"kind":13},{"line":264,"kind":13,"localvar":"my","definition":"my","name":"$seq","containerName":"_parse"},{"definition":"my","name":"@lines","containerName":"_parse","localvar":"my","kind":13,"line":265},{"containerName":"_parse","name":"$SEQ","kind":13,"line":265},{"name":"$line","containerName":"_parse","line":266,"kind":13},{"name":"@lines","containerName":"_parse","kind":13,"line":266},{"kind":13,"line":267,"containerName":"_parse","name":"$line"},{"line":268,"kind":13,"name":"$line","containerName":"_parse"},{"line":269,"kind":13,"containerName":"_parse","name":"$name"},{"line":270,"kind":13,"containerName":"_parse","name":"$self"},{"kind":13,"line":271,"containerName":"_parse","name":"$self"},{"containerName":"_parse","name":"$name","kind":13,"line":271},{"line":271,"kind":13,"name":"$name","containerName":"_parse"},{"line":273,"kind":13,"name":"$self","containerName":"_parse"},{"kind":13,"line":274,"name":"$self","containerName":"_parse"},{"kind":13,"line":274,"containerName":"_parse","name":"$name"},{"line":274,"kind":13,"containerName":"_parse","name":"$name"},{"line":276,"kind":13,"name":"$self","containerName":"_parse"},{"line":276,"kind":13,"name":"$name","containerName":"_parse"},{"containerName":"_parse","name":"$self","line":277,"kind":13},{"containerName":"_parse","name":"$name","line":277,"kind":13},{"containerName":"_parse","name":"$self","kind":13,"line":278},{"kind":13,"line":278,"containerName":"_parse","name":"$name"},{"line":279,"kind":13,"name":"$self","containerName":"_parse"},{"line":279,"kind":13,"containerName":"_parse","name":"$name"},{"name":"$self","containerName":"_parse","kind":13,"line":280},{"containerName":"_parse","name":"$name","line":280,"kind":13},{"name":"$self","containerName":"_parse","kind":13,"line":281},{"name":"$name","containerName":"_parse","line":281,"kind":13},{"containerName":"_parse","name":"$seq","line":281,"kind":13},{"definition":"my","name":"$beg","containerName":"_parse","localvar":"my","kind":13,"line":282},{"kind":13,"line":283,"containerName":"_parse","name":"$seq"},{"line":283,"kind":13,"containerName":"_parse","name":"$self"},{"containerName":"_parse","name":"$name","line":283,"kind":13},{"line":283,"kind":13,"name":"$seq","containerName":"_parse"},{"name":"$beg","containerName":"_parse","line":283,"kind":13},{"kind":13,"line":283,"name":"$beg","containerName":"_parse"},{"kind":13,"line":284,"name":"$count","definition":"my","containerName":"_parse","localvar":"my"},{"line":284,"kind":13,"containerName":"_parse","name":"$self"},{"kind":13,"line":284,"containerName":"_parse","name":"$name"},{"kind":13,"line":284,"name":"$seq","containerName":"_parse"},{"kind":13,"line":285,"containerName":"_parse","name":"$countGC","definition":"my","localvar":"my"},{"containerName":"_parse","name":"$seq","kind":13,"line":285},{"containerName":"_parse","name":"$self","kind":13,"line":286},{"kind":13,"line":286,"containerName":"_parse","name":"$name"},{"containerName":"_parse","name":"$countGC","line":286,"kind":13},{"name":"$count","containerName":"_parse","kind":13,"line":286},{"line":287,"kind":13,"name":"$seq","containerName":"_parse"},{"name":"$seq","containerName":"_parse","line":290,"kind":13},{"containerName":"_parse","name":"$line","line":290,"kind":13},{"name":"$seq","containerName":"_parse","kind":13,"line":290},{"containerName":"_parse","name":"$self","line":295,"kind":13},{"localvar":"my","definition":"my","name":"$QUAL","containerName":"_parse","line":296,"kind":13},{"name":"$self","containerName":"_parse","kind":13,"line":296},{"kind":12,"line":296,"name":"throw","containerName":"_parse"},{"name":"@lines","containerName":"_parse","kind":13,"line":297},{"containerName":"_parse","name":"$QUAL","kind":13,"line":297},{"containerName":"_parse","name":"$self","kind":13,"line":300},{"line":300,"kind":12,"containerName":"_parse","name":"warn"},{"containerName":"_parse","name":"$self","kind":13,"line":300},{"name":"$self","containerName":"_parse","kind":13,"line":301},{"kind":12,"line":301,"name":"qualfile","containerName":"_parse"},{"line":302,"kind":13,"localvar":"my","name":"$QUAL","definition":"my","containerName":"_parse"},{"containerName":"_parse","name":"$self","kind":13,"line":302},{"name":"throw","containerName":"_parse","line":302,"kind":12},{"line":303,"kind":13,"name":"@lines","containerName":"_parse"},{"kind":13,"line":303,"name":"$QUAL","containerName":"_parse"},{"kind":13,"line":306,"name":"$self","containerName":"_parse"},{"kind":12,"line":306,"name":"warn","containerName":"_parse"},{"kind":13,"line":306,"containerName":"_parse","name":"$self"},{"kind":13,"line":307,"containerName":"_parse","name":"@lines"},{"localvar":"my","containerName":"_parse","name":"@vals","definition":"my","line":310,"kind":13},{"containerName":"_parse","name":"@slice","line":310,"kind":13},{"containerName":"_parse","name":"$num","line":310,"kind":13},{"containerName":"_parse","name":"$tot","line":310,"kind":13},{"line":310,"kind":13,"containerName":"_parse","name":"$vals"},{"definition":"my","name":"$qual","containerName":"_parse","localvar":"my","kind":13,"line":311},{"kind":13,"line":312,"containerName":"_parse","name":"$line"},{"name":"@lines","containerName":"_parse","kind":13,"line":312},{"line":313,"kind":13,"containerName":"_parse","name":"$line"},{"name":"$line","containerName":"_parse","kind":13,"line":314},{"containerName":"_parse","name":"$name","kind":13,"line":315},{"name":"@vals","containerName":"_parse","kind":13,"line":316},{"line":316,"kind":13,"containerName":"_parse","name":"$qual"},{"line":317,"kind":13,"containerName":"_parse","name":"@slice"},{"line":317,"kind":13,"name":"@vals","containerName":"_parse"},{"kind":13,"line":317,"containerName":"_parse","name":"$self"},{"containerName":"_parse","name":"$name","line":317,"kind":13},{"containerName":"_parse","name":"$self","line":317,"kind":13},{"containerName":"_parse","name":"$name","line":317,"kind":13},{"line":318,"kind":13,"containerName":"_parse","name":"$vals"},{"line":318,"kind":13,"name":"@slice","containerName":"_parse"},{"line":319,"kind":13,"name":"$self","containerName":"_parse"},{"line":319,"kind":13,"containerName":"_parse","name":"$name"},{"line":319,"kind":13,"containerName":"_parse","name":"$vals"},{"kind":13,"line":320,"name":"$qual","containerName":"_parse"},{"line":321,"kind":13,"containerName":"_parse","name":"$num"},{"kind":13,"line":321,"containerName":"_parse","name":"@slice"},{"line":322,"kind":13,"containerName":"_parse","name":"$tot"},{"name":"$num","containerName":"_parse","kind":13,"line":322},{"name":"$num","containerName":"_parse","kind":13,"line":324},{"name":"@slice","containerName":"_parse","line":324,"kind":13},{"containerName":"_parse","name":"$self","kind":13,"line":325},{"line":325,"kind":13,"containerName":"_parse","name":"$name"},{"containerName":"_parse","name":"$tot","line":325,"kind":13},{"line":325,"kind":13,"name":"$num","containerName":"_parse"},{"kind":13,"line":326,"name":"$tot","containerName":"_parse"},{"name":"$qual","containerName":"_parse","kind":13,"line":329},{"containerName":"_parse","name":"$line","line":329,"kind":13},{"name":"$qual","containerName":"_parse","line":329,"kind":13},{"kind":13,"line":334,"name":"$self","containerName":"_parse"},{"line":335,"kind":13,"localvar":"my","definition":"my","name":"$INFO","containerName":"_parse"},{"line":335,"kind":13,"containerName":"_parse","name":"$self"},{"line":335,"kind":12,"containerName":"_parse","name":"throw"},{"line":336,"kind":13,"containerName":"_parse","name":"@lines"},{"kind":13,"line":336,"containerName":"_parse","name":"$INFO"},{"name":"$self","containerName":"_parse","kind":13,"line":339},{"line":339,"kind":12,"name":"warn","containerName":"_parse"},{"containerName":"_parse","name":"$self","kind":13,"line":339},{"name":"$self","containerName":"_parse","line":340,"kind":13},{"kind":12,"line":340,"name":"infofile","containerName":"_parse"},{"line":341,"kind":13,"localvar":"my","containerName":"_parse","name":"$INFO","definition":"my"},{"name":"$self","containerName":"_parse","line":341,"kind":13},{"line":341,"kind":12,"name":"throw","containerName":"_parse"},{"name":"@lines","containerName":"_parse","kind":13,"line":342},{"name":"$INFO","containerName":"_parse","kind":13,"line":342},{"name":"$self","containerName":"_parse","kind":13,"line":345},{"name":"warn","containerName":"_parse","kind":12,"line":345},{"containerName":"_parse","name":"$self","kind":13,"line":345},{"name":"@lines","containerName":"_parse","line":346,"kind":13},{"line":349,"kind":13,"name":"@lines","containerName":"_parse"},{"containerName":"_parse","name":"$self","line":352,"kind":13},{"name":"$self","containerName":"_parse","kind":13,"line":352},{"kind":13,"line":358,"name":"$self","containerName":"_parse"},{"line":359,"kind":13,"localvar":"my","containerName":"_parse","definition":"my","name":"$STDERR_LUCY"},{"containerName":"_parse","name":"$self","line":359,"kind":13},{"name":"throw","containerName":"_parse","line":359,"kind":12},{"kind":13,"line":360,"containerName":"_parse","name":"@lines"},{"kind":13,"line":360,"containerName":"_parse","name":"$STDERR_LUCY"},{"containerName":"_parse","name":"$self","kind":13,"line":363},{"containerName":"_parse","name":"warn","kind":12,"line":363},{"containerName":"_parse","name":"$self","line":363,"kind":13},{"containerName":"_parse","name":"$self","kind":13,"line":364},{"containerName":"_parse","name":"stderrfile","kind":12,"line":364},{"localvar":"my","name":"$STDERR_LUCY","definition":"my","containerName":"_parse","line":365,"kind":13},{"containerName":"_parse","name":"$self","kind":13,"line":365},{"line":365,"kind":12,"name":"throw","containerName":"_parse"},{"name":"@lines","containerName":"_parse","line":366,"kind":13},{"line":366,"kind":13,"containerName":"_parse","name":"$STDERR_LUCY"},{"name":"$self","containerName":"_parse","line":369,"kind":13},{"line":369,"kind":12,"name":"warn","containerName":"_parse"},{"name":"$self","containerName":"_parse","line":369,"kind":13},{"name":"@lines","containerName":"_parse","line":370,"kind":13},{"line":373,"kind":13,"name":"$self","containerName":"_parse"},{"line":374,"kind":13,"name":"@lines","containerName":"_parse"},{"line":375,"kind":13,"name":"$self","containerName":"_parse"},{"kind":13,"line":376,"name":"$self","containerName":"_parse"},{"containerName":"_parse","name":"$self","kind":13,"line":377},{"line":378,"kind":13,"containerName":"_parse","name":"$self"},{"kind":13,"line":379,"name":"$self","containerName":"_parse"},{"containerName":"_parse","name":"$self","kind":13,"line":381},{"containerName":"_parse","name":"$self","kind":13,"line":382},{"kind":13,"line":387,"containerName":"_parse","name":"@lines"},{"kind":13,"line":388,"name":"$self","containerName":"_parse"}],"containerName":"main::","definition":"sub","name":"_parse","range":{"end":{"line":391,"character":9999},"start":{"line":256,"character":0}}},{"kind":12,"line":258,"name":"seqfile"},{"line":261,"kind":12,"name":"lucy_verbose"},{"name":"seqfile","line":262,"kind":12},{"line":270,"kind":12,"name":"fwd_desig"},{"name":"sequences","kind":12,"line":271},{"name":"direction","kind":12,"line":271},{"line":273,"kind":12,"name":"rev_desig"},{"name":"sequences","kind":12,"line":274},{"line":274,"kind":12,"name":"direction"},{"line":276,"kind":12,"name":"sequences"},{"line":276,"kind":12,"name":"min_clone_len"},{"line":277,"kind":12,"name":"sequences"},{"name":"max_clone_len","line":277,"kind":12},{"name":"sequences","line":278,"kind":12},{"kind":12,"line":278,"name":"med_clone_len"},{"name":"sequences","kind":12,"line":279},{"name":"beg_clear","line":279,"kind":12},{"name":"sequences","line":280,"kind":12},{"line":280,"kind":12,"name":"end_clear"},{"name":"sequences","kind":12,"line":281},{"kind":12,"line":281,"name":"length_raw"},{"name":"sequences","line":283,"kind":12},{"name":"sequence","kind":12,"line":283},{"name":"sequences","line":284,"kind":12},{"line":284,"kind":12,"name":"length_clear"},{"kind":12,"line":286,"name":"sequences"},{"kind":12,"line":286,"name":"per_GC"},{"line":295,"kind":12,"name":"qualfile"},{"line":300,"kind":12,"name":"lucy_verbose"},{"line":306,"kind":12,"name":"lucy_verbose"},{"name":"sequences","line":317,"kind":12},{"kind":12,"line":317,"name":"beg_clear"},{"line":317,"kind":12,"name":"sequences"},{"name":"end_clear","line":317,"kind":12},{"name":"sequences","line":319,"kind":12},{"name":"quality","line":319,"kind":12},{"name":"sequences","kind":12,"line":325},{"line":325,"kind":12,"name":"avg_quality"},{"name":"infofile","line":334,"kind":12},{"kind":12,"line":339,"name":"lucy_verbose"},{"name":"lucy_verbose","kind":12,"line":345},{"kind":12,"line":352,"name":"sequences"},{"name":"full_length","line":352,"kind":12},{"line":352,"kind":12,"name":"sequences"},{"line":358,"kind":12,"name":"stderrfile"},{"line":363,"kind":12,"name":"lucy_verbose"},{"line":369,"kind":12,"name":"lucy_verbose"},{"name":"adv_stderr","kind":12,"line":373},{"name":"reject","line":375,"kind":12},{"kind":12,"line":376,"name":"reject"},{"name":"reject","line":377,"kind":12},{"kind":12,"line":378,"name":"reject"},{"name":"sequences","line":379,"kind":12},{"kind":12,"line":379,"name":"polyA"},{"line":381,"kind":12,"name":"reject"},{"kind":12,"line":382,"name":"sequences"},{"line":388,"kind":12,"name":"reject"},{"containerName":"main::","definition":"sub","name":"get_Seq_Objs","range":{"end":{"character":9999,"line":408},"start":{"character":0,"line":405}},"kind":12,"line":405,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"get_Seq_Objs","line":406,"kind":13},{"localvar":"my","containerName":"get_Seq_Objs","name":"$seqobj","definition":"my","line":407,"kind":13},{"name":"@seqobjs","containerName":"get_Seq_Objs","kind":13,"line":407},{"localvar":"my","definition":"my","name":"$key","containerName":"get_Seq_Objs","line":408,"kind":13},{"name":"$self","containerName":"get_Seq_Objs","line":408,"kind":13}]},{"name":"sequences","kind":12,"line":408},{"containerName":null,"name":"$seqobj","kind":13,"line":409},{"line":409,"kind":12,"containerName":"PrimarySeq","name":"Bio"},{"containerName":"main::","name":"new","kind":12,"line":409},{"name":"@seqobjs","containerName":null,"kind":13,"line":411},{"name":"$seqobj","containerName":null,"kind":13,"line":411},{"containerName":null,"name":"@seqobjs","line":413,"kind":13},{"range":{"end":{"character":9999,"line":432},"start":{"line":427,"character":0}},"name":"get_Seq_Obj","detail":"($self,$key)","signature":{"label":"get_Seq_Obj($self,$key)","documentation":"1;\n# $Id: Lucy.pm 16123 2009-09-17 12:57:27Z cjfields $ \n#\n# BioPerl module for Bio::Tools::Lucy\n#\n# Copyright Her Majesty the Queen of England\n# written by Andrew Walsh (paeruginosa@hotmail.com) during employment with \n# Agriculture and Agri-food Canada, Cereal Research Centre, Winnipeg, MB\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Lucy - Object for analyzing the output from Lucy,\n  a vector and quality trimming program from TIGR\n\n=head1 SYNOPSIS\n\n  # Create the Lucy object from an existing Lucy output file\n  @params = ('seqfile' => 'lucy.seq', 'lucy_verbose' => 1);\n  $lucyObj = Bio::Tools::Lucy->new(@params);\n\n  # Get names of all sequences\n  $names = $lucyObj->get_sequence_names();\n\n  #  Print seq and qual values for sequences >400 bp in order to run CAP3\n  foreach $name (@$names) {\n      next unless $lucyObj->length_clear($name) > 400;\n      print SEQ \">$name\\n\", $lucyObj->sequence($name), \"\\n\";\n      print QUAL \">$name\\n\", $lucyObj->quality($name), \"\\n\";\n  }\n\n  # Get an array of Bio::PrimarySeq objects\n  @seqObjs = $lucyObj->get_Seq_Objs();\n\n\n=head1 DESCRIPTION\n\nBio::Tools::Lucy.pm provides methods for analyzing the sequence and\nquality values generated by Lucy program from TIGR.\n\nLucy will identify vector, poly-A/T tails, and poor quality regions in\na sequence.  (www.genomics.purdue.edu/gcg/other/lucy.pdf)\n\nThe input to Lucy can be the Phred sequence and quality files\ngenerated from running Phred on a set of chromatograms.\n\nLucy can be obtained (free of charge to academic users) from\nwww.tigr.org/softlab\n\nThere are a few methods that will only be available if you make some\nminor changes to the source for Lucy and then recompile.  The changes\nare in the 'lucy.c' file and there is a diff between the original and\nthe modified file in the Appendix\n\nPlease contact the author of this module if you have any problems\nmaking these modifications.\n\nYou do not have to make these modifications to use this module.\n\n=head2 Creating a Lucy object\n\n  @params = ('seqfile' => 'lucy.seq', 'adv_stderr' => 1, \n\t     'fwd_desig' => '_F', 'rev_desig' => '_R');\n  $lucyObj = Bio::Tools::Lucy->new(@params);\n\n=head2 Using a Lucy object\n\n  You should get an array with the sequence names in order to use\n  accessor methods.  Note: The Lucy binary program will fail unless\n  the sequence names provided as input are unique.\n\n  $names_ref = $lucyObj->get_sequence_names();\n\n  This code snippet will produce a Fasta format file with sequence\n  lengths and %GC in the description line.\n\n  foreach $name (@$names) {\n      print FILE \">$name\\t\",\n\t\t $lucyObj->length_clear($name), \"\\t\",\n\t\t $lucyObj->per_GC($name), \"\\n\",\n\t\t $lucyObj->sequence($name), \"\\n\";\n  }\n\n\n  Print seq and qual values for sequences >400 bp in order to assemble\n  them with CAP3 (or other assembler).\n\n  foreach $name (@$names) {\n      next unless $lucyObj->length_clear($name) > 400;\n      print SEQ \">$name\\n\", $lucyObj->sequence($name), \"\\n\";\n      print QUAL \">$name\\n\", $lucyObj->quality($name), \"\\n\";\n  }\n\n  Get all the sequences as Bio::PrimarySeq objects (eg., for use with\n  Bio::Tools::Run::StandaloneBlast to perform BLAST).\n\n  @seqObjs = $lucyObj->get_Seq_Objs();\n\n  Or use only those sequences that are full length and have a Poly-A\n  tail.\n\n  foreach $name (@$names) {\n      next unless ($lucyObj->full_length($name) and $lucy->polyA($name));\n      push @seqObjs, $lucyObj->get_Seq_Obj($name);\n  }\n\n\n  Get the names of those sequences that were rejected by Lucy.\n\n  $rejects_ref = $lucyObj->get_rejects();\n\n  Print the names of the rejects and 1 letter code for reason they\n  were rejected.\n\n  foreach $key (sort keys %$rejects_ref) {\n      print \"$key:  \", $rejects_ref->{$key};\n  }\n\n  There is a lot of other information available about the sequences\n  analyzed by Lucy (see APPENDIX).  This module can be used with the\n  DBI module to store this sequence information in a database.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules.  Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nAndrew G. Walsh\t\tpaeruginosa@hotmail.com\n\n=head1 APPENDIX\n\nMethods available to Lucy objects are described below.  Please note\nthat any method beginning with an underscore is considered internal\nand should not be called directly.\n\n\n\npackage Bio::Tools::Lucy;\n\nuse vars qw($AUTOLOAD @ATTR %OK_FIELD);\nuse strict;\nuse Bio::PrimarySeq;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n@ATTR = qw(seqfile qualfile stderrfile infofile lucy_verbose fwd_desig rev_desig adv_stderr); \nforeach my $attr (@ATTR) {\n    $OK_FIELD{$attr}++\n}\n\nsub AUTOLOAD {\n    my $self = shift;\n    my $attr = $AUTOLOAD;\n    $attr =~ s/.*:://;\n    $attr = lc $attr;\n    $self->throw(\"Unallowed parameter: $attr !\") unless $OK_FIELD{$attr};\n    $self->{$attr} = shift if @_;\n    return $self->{$attr};\n}\n\n=head2 new\n\n Title\t :  new\n Usage\t :  $lucyObj = Bio::Tools::Lucy->new(seqfile => lucy.seq, rev_desig => '_R', \n\t    fwd_desig => '_F')\n Function:  creates a Lucy object from Lucy analysis files\n Returns :  reference to Bio::Tools::Lucy object\n Args\t :  seqfile\tFasta sequence file generated by Lucy\n\t       qualfile\tQuality values file generated by Lucy\n\t       infofile\tInfo file created when Lucy is run with -debug \n                     'infofile' option\n\t       stderrfile\tStandard error captured from Lucy when Lucy is run \n\t\t\t with -info option and STDERR is directed to stderrfile \n\t\t\t (ie. lucy ... 2> stderrfile).\n\t\t\t Info in this file will include sequences dropped for low \n\t\t\t quality. If you've modified Lucy source (see adv_stderr below), \n\t\t\t it will also include info on which sequences were dropped because \n\t\t\t they were vector, too short, had no insert, and whether a poly-A \n\t\t\t tail was found (if Lucy was run with -cdna option).\n\t       lucy_verbose verbosity level (0-1).  \n\t       fwd_desig\tThe string used to determine whether sequence is a \n          forward read.  \n\t\t\t The parser will assume that this match will occus at the \n\t\t\t end of the sequence name string.\n\t       rev_desig\tAs above, for reverse reads. \n \t       adv_stderr\tCan be set to a true value (1).  Will only work if \n          you have modified \n\t\t\t the Lucy source code as outlined in DESCRIPTION and capture \n\t\t\t the standard error from Lucy.\n\nIf you don't provide filenames for qualfile, infofile or stderrfile,\nthe module will assume that .qual, .info, and .stderr are the file\nextensions and search in the same directory as the .seq file for these\nfiles.\n\nFor example, if you create a Lucy object with $lucyObj =\nBio::Tools::Lucy-E<gt>new(seqfile =E<gt>lucy.seq), the module will\nfind lucy.qual, lucy.info and lucy.stderr.\n\nYou can omit any or all of the quality, info or stderr files, but you\nwill not be able to use all of the object methods (see method\ndocumentation below).\n\n\nsub new {\n\tmy ($class,@args) = @_;\n\tmy $self = $class->SUPER::new(@args);\n\tmy ($attr, $value);\n\twhile (@args) {\n\t\t$attr = shift @args;\n\t\t$attr = lc $attr;\n\t\t$value = shift @args;\n\t\t$self->{$attr} = $value;\n\t}\n\t&_parse($self);\n\treturn $self;\n}\n\n=head2 _parse\n\n Title\t :  _parse\n Usage\t :  n/a (internal function)\n Function:  called by new() to parse Lucy output files\n Returns :  nothing\n Args\t :  none\n\n\nsub _parse {\n\tmy $self = shift;\n\t$self->{seqfile} =~ /^(\\S+)\\.\\S+$/;\n\tmy $file = $1;\n\n\t$self->warn(\"Opening $self->{seqfile} for parsing...\\n\") if $self->{lucy_verbose};\n\topen my $SEQ, $self->{seqfile} or $self->throw(\"Could not open sequence file: $self->{seqfile}\");\n\tmy ($name, $line);\n\tmy $seq = \"\";\n\tmy @lines = <$SEQ>;\n\twhile ($line = pop @lines) {\n\t\tchomp $line;\n\t\tif ($line =~ /^>(\\S+)\\s+(\\d+)\\s+(\\d+)\\s+(\\d+)\\s+(\\d+)\\s+(\\d+)/) {    \n\t\t\t$name = $1;\n\t\t\tif ($self->{fwd_desig}) {\n\t\t\t\t$self->{sequences}{$name}{direction} = \"F\" if $name =~ /^(\\S+)($self->{fwd_desig})$/;\n\t\t\t}\n\t\t\tif ($self->{rev_desig}) {\n\t\t\t\t$self->{sequences}{$name}{direction} = \"R\" if $name =~ /^(\\S+)($self->{rev_desig})$/;\n\t\t\t}\n\t\t\t$self->{sequences}{$name}{min_clone_len} = $2; # this is used for TIGR Assembler, as are $3 and $4\n\t\t\t$self->{sequences}{$name}{max_clone_len} = $3;\n\t\t\t$self->{sequences}{$name}{med_clone_len} = $4; \n\t\t\t$self->{sequences}{$name}{beg_clear} = $5;\n\t\t\t$self->{sequences}{$name}{end_clear} = $6;\n\t\t\t$self->{sequences}{$name}{length_raw} = $seq =~ tr/[AGCTN]//; # from what I've seen, these are the bases Phred calls.  Please let me know if I'm wrong.     \n\t\t\tmy $beg = $5-1; # substr function begins with index 0\n\t\t\t$seq = $self->{sequences}{$name}{sequence} = substr ($seq, $beg, $6-$beg);\n\t\t\tmy $count = $self->{sequences}{$name}{length_clear} = $seq =~ tr/[AGCTN]//;\n\t\t\tmy $countGC =  $seq =~ tr/[GC]//;\n\t\t\t$self->{sequences}{$name}{per_GC} = $countGC/$count * 100;\n\t\t\t$seq = \"\";\n\t\t}\n\t\telse {\n\t\t\t$seq = $line.$seq;\n\t\t}\n\t}\n\n\t# now parse quality values (check for presence of quality file first) \n\tif ($self->{qualfile}) {\n\t\topen my $QUAL, \"$self->{qualfile}\" or $self->throw(\"Could not open quality file: $self->{qualfile}\");\n\t\t@lines = <$QUAL>;\n\t}\n\telsif (-e \"$file.qual\") {\n\t\t$self->warn(\"You did not set qualfile, but I'm opening $file.qual\\n\") if $self->{lucy_verbose};\n\t$self->qualfile(\"$file.qual\");\n\t\topen my $QUAL, \"$file.qual\" or $self->throw(\"Could not open quality file: $file.qual\");\n\t\t@lines = <$QUAL>;\n\t}\n    else {\n\t\t $self->warn(\"I did not find a quality file.  You will not be able to use all of the accessor methods.\\n\") if $self->{lucy_verbose};\n\t\t @lines = ();\n    }\n\n\tmy (@vals, @slice, $num, $tot, $vals);  \n\tmy $qual = \"\"; \n\twhile ($line = pop @lines) {\n\t\tchomp $line;\n\t\tif ($line =~ /^>(\\S+)/) {\n\t\t\t$name = $1;\n\t\t\t@vals = split /\\s/ , $qual;\n\t\t\t@slice = @vals[$self->{sequences}{$name}{beg_clear} - 1 .. $self->{sequences}{$name}{end_clear} - 1];\n\t\t\t$vals = join \"\\t\", @slice;\n\t\t\t$self->{sequences}{$name}{quality} = $vals;\n\t\t\t$qual = \"\";\n\t\t\tforeach $num (@slice) {\n\t\t\t\t$tot += $num;\n\t\t\t}\n\t\t\t$num = @slice;\n\t\t\t$self->{sequences}{$name}{avg_quality} = $tot/$num;\n\t\t\t$tot = 0;\n\t\t}\n\t\telse {\n\t\t\t$qual = $line.$qual;\n\t\t}\n\t}\n\n\t# determine whether reads are full length\n\tif ($self->{infofile}) {\n\t\topen my $INFO, \"$self->{infofile}\" or $self->throw(\"Could not open info file: $self->{infofile}\");\n\t\t@lines = <$INFO>;\n\t}\n\telsif (-e \"$file.info\") {\n\t\t$self->warn(\"You did not set infofile, but I'm opening $file.info\\n\") if $self->{lucy_verbose};\n\t\t$self->infofile(\"$file.info\");\n\t\topen my $INFO, \"$file.info\" or $self->throw(\"Could not open info file: $file.info\");\n\t\t@lines = <$INFO>;\n\t}\n\telse {\n\t\t$self->warn(\"I did not find an info file.  You will not be able to use all of the accessor methods.\\n\") if $self->{lucy_verbose};\n\t\t@lines = ();\n\t}\n\n\tforeach (@lines) {\n\t\t/^(\\S+).+CLV\\s+(\\d+)\\s+(\\d+)$/;\n\t\tif ($2>0 && $3>0) {\n\t\t\t$self->{sequences}{$1}{full_length} = 1 if $self->{sequences}{$1}; # will show cleavage info for rejected sequences too\n\t\t}\n\t}\n\n\n\t# parse rejects (and presence of poly-A if Lucy has been modified)\n\tif ($self->{stderrfile}) {\n\t\topen my $STDERR_LUCY, \"$self->{stderrfile}\" or $self->throw(\"Could not open quality file: $self->{stderrfile}\");\n\t\t@lines = <$STDERR_LUCY>;\n\t}\n\telsif (-e \"$file.stderr\") {\n\t\t$self->warn(\"You did not set stderrfile, but I'm opening $file.stderr\\n\") if $self->{lucy_verbose};\n\t\t$self->stderrfile(\"$file.stderr\");\n\t\topen my $STDERR_LUCY, \"$file.stderr\" or $self->throw(\"Could not open quality file: $file.stderr\");\n\t\t@lines = <$STDERR_LUCY>;\n\t}\n\telse {\n\t\t$self->warn(\"I did not find a standard error file.  You will not be able to use all of the accessor methods.\\n\") if $self->{lucy_verbose};\n\t\t@lines = ();\n\t}\n\n\tif ($self->{adv_stderr}) {\n\t\tforeach (@lines) {\n\t\t\t$self->{reject}{$1} = \"Q\" if /dropping\\s+(\\S+)/;\n\t\t\t$self->{reject}{$1} = \"V\" if /Vector: (\\S+)/;\n\t\t\t$self->{reject}{$1} = \"E\" if /Empty: (\\S+)/;\n\t\t\t$self->{reject}{$1} = \"S\" if m{Short/ no insert: (\\S+)};\n\t\t\t$self->{sequences}{$1}{polyA} = 1 if /(\\S+) has PolyA/;\n\t\t\tif (/Dropped PolyA: (\\S+)/) {\n\t\t\t\t$self->{reject}{$1} = \"P\";\n\t\t\t\tdelete $self->{sequences}{$1};\n\t\t\t}\n\t\t}\n\t}\n\telse {\n\t\tforeach (@lines) {\n\t\t\t$self->{reject}{$1} = \"R\" if /dropping\\s+(\\S+)/;\n\t\t}\n\t}\n}\n\n=head2 get_Seq_Objs\n\n Title   :  get_Seq_Objs\n Usage   :  $lucyObj->get_Seq_Objs()\n Function:  returns an array of references to Bio::PrimarySeq objects \n\t    where -id = 'sequence name' and -seq = 'sequence'\n\n Returns :  array of Bio::PrimarySeq objects\n Args\t :  none\n\n\nsub get_Seq_Objs {\n    my $self = shift;\n    my($seqobj, @seqobjs);\n    foreach my $key (sort keys %{$self->{sequences}}) {\n\t$seqobj = Bio::PrimarySeq->new( -seq => \"$self->{sequences}{$key}{sequence}\",\n\t\t\t\t\t-id => \"$key\");\n\tpush @seqobjs, $seqobj;\n    }\n    return \\@seqobjs;\n} \n\n=head2 get_Seq_Obj\n\n Title   :  get_Seq_Obj\n Usage   :  $lucyObj->get_Seq_Obj($seqname)\n Function:  returns reference to a Bio::PrimarySeq object where -id = 'sequence name'\n\t    and -seq = 'sequence'\n Returns :  reference to Bio::PrimarySeq object\n Args\t :  name of a sequence ","parameters":[{"label":"$self"},{"label":"$key"}]},"containerName":"main::","definition":"sub","line":427,"children":[{"definition":"my","name":"$self","containerName":"get_Seq_Obj","localvar":"my","kind":13,"line":428},{"containerName":"get_Seq_Obj","name":"$key","line":428,"kind":13},{"line":429,"kind":13,"localvar":"my","definition":"my","name":"$seqobj","containerName":"get_Seq_Obj"},{"containerName":"get_Seq_Obj","name":"new","line":429,"kind":12},{"containerName":"get_Seq_Obj","name":"$seqobj","kind":13,"line":431}],"kind":12},{"name":"Bio","containerName":"PrimarySeq","line":429,"kind":12},{"kind":12,"children":[{"kind":13,"line":447,"definition":"my","name":"$self","containerName":"get_sequence_names","localvar":"my"},{"localvar":"my","containerName":"get_sequence_names","name":"@keys","definition":"my","line":448,"kind":13},{"line":448,"kind":13,"name":"$self","containerName":"get_sequence_names"}],"line":446,"name":"get_sequence_names","definition":"sub","containerName":"main::","range":{"start":{"character":0,"line":446},"end":{"line":448,"character":9999}}},{"name":"sequences","line":448,"kind":12},{"containerName":null,"name":"@keys","kind":13,"line":449},{"children":[{"containerName":"sequence","name":"$self","definition":"my","localvar":"my","kind":13,"line":463},{"kind":13,"line":463,"name":"$key","containerName":"sequence"},{"line":464,"kind":13,"containerName":"sequence","name":"$self"},{"line":464,"kind":13,"containerName":"sequence","name":"$key"}],"line":462,"kind":12,"signature":{"documentation":"1;\n# $Id: Lucy.pm 16123 2009-09-17 12:57:27Z cjfields $ \n#\n# BioPerl module for Bio::Tools::Lucy\n#\n# Copyright Her Majesty the Queen of England\n# written by Andrew Walsh (paeruginosa@hotmail.com) during employment with \n# Agriculture and Agri-food Canada, Cereal Research Centre, Winnipeg, MB\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Lucy - Object for analyzing the output from Lucy,\n  a vector and quality trimming program from TIGR\n\n=head1 SYNOPSIS\n\n  # Create the Lucy object from an existing Lucy output file\n  @params = ('seqfile' => 'lucy.seq', 'lucy_verbose' => 1);\n  $lucyObj = Bio::Tools::Lucy->new(@params);\n\n  # Get names of all sequences\n  $names = $lucyObj->get_sequence_names();\n\n  #  Print seq and qual values for sequences >400 bp in order to run CAP3\n  foreach $name (@$names) {\n      next unless $lucyObj->length_clear($name) > 400;\n      print SEQ \">$name\\n\", $lucyObj->sequence($name), \"\\n\";\n      print QUAL \">$name\\n\", $lucyObj->quality($name), \"\\n\";\n  }\n\n  # Get an array of Bio::PrimarySeq objects\n  @seqObjs = $lucyObj->get_Seq_Objs();\n\n\n=head1 DESCRIPTION\n\nBio::Tools::Lucy.pm provides methods for analyzing the sequence and\nquality values generated by Lucy program from TIGR.\n\nLucy will identify vector, poly-A/T tails, and poor quality regions in\na sequence.  (www.genomics.purdue.edu/gcg/other/lucy.pdf)\n\nThe input to Lucy can be the Phred sequence and quality files\ngenerated from running Phred on a set of chromatograms.\n\nLucy can be obtained (free of charge to academic users) from\nwww.tigr.org/softlab\n\nThere are a few methods that will only be available if you make some\nminor changes to the source for Lucy and then recompile.  The changes\nare in the 'lucy.c' file and there is a diff between the original and\nthe modified file in the Appendix\n\nPlease contact the author of this module if you have any problems\nmaking these modifications.\n\nYou do not have to make these modifications to use this module.\n\n=head2 Creating a Lucy object\n\n  @params = ('seqfile' => 'lucy.seq', 'adv_stderr' => 1, \n\t     'fwd_desig' => '_F', 'rev_desig' => '_R');\n  $lucyObj = Bio::Tools::Lucy->new(@params);\n\n=head2 Using a Lucy object\n\n  You should get an array with the sequence names in order to use\n  accessor methods.  Note: The Lucy binary program will fail unless\n  the sequence names provided as input are unique.\n\n  $names_ref = $lucyObj->get_sequence_names();\n\n  This code snippet will produce a Fasta format file with sequence\n  lengths and %GC in the description line.\n\n  foreach $name (@$names) {\n      print FILE \">$name\\t\",\n\t\t $lucyObj->length_clear($name), \"\\t\",\n\t\t $lucyObj->per_GC($name), \"\\n\",\n\t\t $lucyObj->sequence($name), \"\\n\";\n  }\n\n\n  Print seq and qual values for sequences >400 bp in order to assemble\n  them with CAP3 (or other assembler).\n\n  foreach $name (@$names) {\n      next unless $lucyObj->length_clear($name) > 400;\n      print SEQ \">$name\\n\", $lucyObj->sequence($name), \"\\n\";\n      print QUAL \">$name\\n\", $lucyObj->quality($name), \"\\n\";\n  }\n\n  Get all the sequences as Bio::PrimarySeq objects (eg., for use with\n  Bio::Tools::Run::StandaloneBlast to perform BLAST).\n\n  @seqObjs = $lucyObj->get_Seq_Objs();\n\n  Or use only those sequences that are full length and have a Poly-A\n  tail.\n\n  foreach $name (@$names) {\n      next unless ($lucyObj->full_length($name) and $lucy->polyA($name));\n      push @seqObjs, $lucyObj->get_Seq_Obj($name);\n  }\n\n\n  Get the names of those sequences that were rejected by Lucy.\n\n  $rejects_ref = $lucyObj->get_rejects();\n\n  Print the names of the rejects and 1 letter code for reason they\n  were rejected.\n\n  foreach $key (sort keys %$rejects_ref) {\n      print \"$key:  \", $rejects_ref->{$key};\n  }\n\n  There is a lot of other information available about the sequences\n  analyzed by Lucy (see APPENDIX).  This module can be used with the\n  DBI module to store this sequence information in a database.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules.  Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nAndrew G. Walsh\t\tpaeruginosa@hotmail.com\n\n=head1 APPENDIX\n\nMethods available to Lucy objects are described below.  Please note\nthat any method beginning with an underscore is considered internal\nand should not be called directly.\n\n\n\npackage Bio::Tools::Lucy;\n\nuse vars qw($AUTOLOAD @ATTR %OK_FIELD);\nuse strict;\nuse Bio::PrimarySeq;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n@ATTR = qw(seqfile qualfile stderrfile infofile lucy_verbose fwd_desig rev_desig adv_stderr); \nforeach my $attr (@ATTR) {\n    $OK_FIELD{$attr}++\n}\n\nsub AUTOLOAD {\n    my $self = shift;\n    my $attr = $AUTOLOAD;\n    $attr =~ s/.*:://;\n    $attr = lc $attr;\n    $self->throw(\"Unallowed parameter: $attr !\") unless $OK_FIELD{$attr};\n    $self->{$attr} = shift if @_;\n    return $self->{$attr};\n}\n\n=head2 new\n\n Title\t :  new\n Usage\t :  $lucyObj = Bio::Tools::Lucy->new(seqfile => lucy.seq, rev_desig => '_R', \n\t    fwd_desig => '_F')\n Function:  creates a Lucy object from Lucy analysis files\n Returns :  reference to Bio::Tools::Lucy object\n Args\t :  seqfile\tFasta sequence file generated by Lucy\n\t       qualfile\tQuality values file generated by Lucy\n\t       infofile\tInfo file created when Lucy is run with -debug \n                     'infofile' option\n\t       stderrfile\tStandard error captured from Lucy when Lucy is run \n\t\t\t with -info option and STDERR is directed to stderrfile \n\t\t\t (ie. lucy ... 2> stderrfile).\n\t\t\t Info in this file will include sequences dropped for low \n\t\t\t quality. If you've modified Lucy source (see adv_stderr below), \n\t\t\t it will also include info on which sequences were dropped because \n\t\t\t they were vector, too short, had no insert, and whether a poly-A \n\t\t\t tail was found (if Lucy was run with -cdna option).\n\t       lucy_verbose verbosity level (0-1).  \n\t       fwd_desig\tThe string used to determine whether sequence is a \n          forward read.  \n\t\t\t The parser will assume that this match will occus at the \n\t\t\t end of the sequence name string.\n\t       rev_desig\tAs above, for reverse reads. \n \t       adv_stderr\tCan be set to a true value (1).  Will only work if \n          you have modified \n\t\t\t the Lucy source code as outlined in DESCRIPTION and capture \n\t\t\t the standard error from Lucy.\n\nIf you don't provide filenames for qualfile, infofile or stderrfile,\nthe module will assume that .qual, .info, and .stderr are the file\nextensions and search in the same directory as the .seq file for these\nfiles.\n\nFor example, if you create a Lucy object with $lucyObj =\nBio::Tools::Lucy-E<gt>new(seqfile =E<gt>lucy.seq), the module will\nfind lucy.qual, lucy.info and lucy.stderr.\n\nYou can omit any or all of the quality, info or stderr files, but you\nwill not be able to use all of the object methods (see method\ndocumentation below).\n\n\nsub new {\n\tmy ($class,@args) = @_;\n\tmy $self = $class->SUPER::new(@args);\n\tmy ($attr, $value);\n\twhile (@args) {\n\t\t$attr = shift @args;\n\t\t$attr = lc $attr;\n\t\t$value = shift @args;\n\t\t$self->{$attr} = $value;\n\t}\n\t&_parse($self);\n\treturn $self;\n}\n\n=head2 _parse\n\n Title\t :  _parse\n Usage\t :  n/a (internal function)\n Function:  called by new() to parse Lucy output files\n Returns :  nothing\n Args\t :  none\n\n\nsub _parse {\n\tmy $self = shift;\n\t$self->{seqfile} =~ /^(\\S+)\\.\\S+$/;\n\tmy $file = $1;\n\n\t$self->warn(\"Opening $self->{seqfile} for parsing...\\n\") if $self->{lucy_verbose};\n\topen my $SEQ, $self->{seqfile} or $self->throw(\"Could not open sequence file: $self->{seqfile}\");\n\tmy ($name, $line);\n\tmy $seq = \"\";\n\tmy @lines = <$SEQ>;\n\twhile ($line = pop @lines) {\n\t\tchomp $line;\n\t\tif ($line =~ /^>(\\S+)\\s+(\\d+)\\s+(\\d+)\\s+(\\d+)\\s+(\\d+)\\s+(\\d+)/) {    \n\t\t\t$name = $1;\n\t\t\tif ($self->{fwd_desig}) {\n\t\t\t\t$self->{sequences}{$name}{direction} = \"F\" if $name =~ /^(\\S+)($self->{fwd_desig})$/;\n\t\t\t}\n\t\t\tif ($self->{rev_desig}) {\n\t\t\t\t$self->{sequences}{$name}{direction} = \"R\" if $name =~ /^(\\S+)($self->{rev_desig})$/;\n\t\t\t}\n\t\t\t$self->{sequences}{$name}{min_clone_len} = $2; # this is used for TIGR Assembler, as are $3 and $4\n\t\t\t$self->{sequences}{$name}{max_clone_len} = $3;\n\t\t\t$self->{sequences}{$name}{med_clone_len} = $4; \n\t\t\t$self->{sequences}{$name}{beg_clear} = $5;\n\t\t\t$self->{sequences}{$name}{end_clear} = $6;\n\t\t\t$self->{sequences}{$name}{length_raw} = $seq =~ tr/[AGCTN]//; # from what I've seen, these are the bases Phred calls.  Please let me know if I'm wrong.     \n\t\t\tmy $beg = $5-1; # substr function begins with index 0\n\t\t\t$seq = $self->{sequences}{$name}{sequence} = substr ($seq, $beg, $6-$beg);\n\t\t\tmy $count = $self->{sequences}{$name}{length_clear} = $seq =~ tr/[AGCTN]//;\n\t\t\tmy $countGC =  $seq =~ tr/[GC]//;\n\t\t\t$self->{sequences}{$name}{per_GC} = $countGC/$count * 100;\n\t\t\t$seq = \"\";\n\t\t}\n\t\telse {\n\t\t\t$seq = $line.$seq;\n\t\t}\n\t}\n\n\t# now parse quality values (check for presence of quality file first) \n\tif ($self->{qualfile}) {\n\t\topen my $QUAL, \"$self->{qualfile}\" or $self->throw(\"Could not open quality file: $self->{qualfile}\");\n\t\t@lines = <$QUAL>;\n\t}\n\telsif (-e \"$file.qual\") {\n\t\t$self->warn(\"You did not set qualfile, but I'm opening $file.qual\\n\") if $self->{lucy_verbose};\n\t$self->qualfile(\"$file.qual\");\n\t\topen my $QUAL, \"$file.qual\" or $self->throw(\"Could not open quality file: $file.qual\");\n\t\t@lines = <$QUAL>;\n\t}\n    else {\n\t\t $self->warn(\"I did not find a quality file.  You will not be able to use all of the accessor methods.\\n\") if $self->{lucy_verbose};\n\t\t @lines = ();\n    }\n\n\tmy (@vals, @slice, $num, $tot, $vals);  \n\tmy $qual = \"\"; \n\twhile ($line = pop @lines) {\n\t\tchomp $line;\n\t\tif ($line =~ /^>(\\S+)/) {\n\t\t\t$name = $1;\n\t\t\t@vals = split /\\s/ , $qual;\n\t\t\t@slice = @vals[$self->{sequences}{$name}{beg_clear} - 1 .. $self->{sequences}{$name}{end_clear} - 1];\n\t\t\t$vals = join \"\\t\", @slice;\n\t\t\t$self->{sequences}{$name}{quality} = $vals;\n\t\t\t$qual = \"\";\n\t\t\tforeach $num (@slice) {\n\t\t\t\t$tot += $num;\n\t\t\t}\n\t\t\t$num = @slice;\n\t\t\t$self->{sequences}{$name}{avg_quality} = $tot/$num;\n\t\t\t$tot = 0;\n\t\t}\n\t\telse {\n\t\t\t$qual = $line.$qual;\n\t\t}\n\t}\n\n\t# determine whether reads are full length\n\tif ($self->{infofile}) {\n\t\topen my $INFO, \"$self->{infofile}\" or $self->throw(\"Could not open info file: $self->{infofile}\");\n\t\t@lines = <$INFO>;\n\t}\n\telsif (-e \"$file.info\") {\n\t\t$self->warn(\"You did not set infofile, but I'm opening $file.info\\n\") if $self->{lucy_verbose};\n\t\t$self->infofile(\"$file.info\");\n\t\topen my $INFO, \"$file.info\" or $self->throw(\"Could not open info file: $file.info\");\n\t\t@lines = <$INFO>;\n\t}\n\telse {\n\t\t$self->warn(\"I did not find an info file.  You will not be able to use all of the accessor methods.\\n\") if $self->{lucy_verbose};\n\t\t@lines = ();\n\t}\n\n\tforeach (@lines) {\n\t\t/^(\\S+).+CLV\\s+(\\d+)\\s+(\\d+)$/;\n\t\tif ($2>0 && $3>0) {\n\t\t\t$self->{sequences}{$1}{full_length} = 1 if $self->{sequences}{$1}; # will show cleavage info for rejected sequences too\n\t\t}\n\t}\n\n\n\t# parse rejects (and presence of poly-A if Lucy has been modified)\n\tif ($self->{stderrfile}) {\n\t\topen my $STDERR_LUCY, \"$self->{stderrfile}\" or $self->throw(\"Could not open quality file: $self->{stderrfile}\");\n\t\t@lines = <$STDERR_LUCY>;\n\t}\n\telsif (-e \"$file.stderr\") {\n\t\t$self->warn(\"You did not set stderrfile, but I'm opening $file.stderr\\n\") if $self->{lucy_verbose};\n\t\t$self->stderrfile(\"$file.stderr\");\n\t\topen my $STDERR_LUCY, \"$file.stderr\" or $self->throw(\"Could not open quality file: $file.stderr\");\n\t\t@lines = <$STDERR_LUCY>;\n\t}\n\telse {\n\t\t$self->warn(\"I did not find a standard error file.  You will not be able to use all of the accessor methods.\\n\") if $self->{lucy_verbose};\n\t\t@lines = ();\n\t}\n\n\tif ($self->{adv_stderr}) {\n\t\tforeach (@lines) {\n\t\t\t$self->{reject}{$1} = \"Q\" if /dropping\\s+(\\S+)/;\n\t\t\t$self->{reject}{$1} = \"V\" if /Vector: (\\S+)/;\n\t\t\t$self->{reject}{$1} = \"E\" if /Empty: (\\S+)/;\n\t\t\t$self->{reject}{$1} = \"S\" if m{Short/ no insert: (\\S+)};\n\t\t\t$self->{sequences}{$1}{polyA} = 1 if /(\\S+) has PolyA/;\n\t\t\tif (/Dropped PolyA: (\\S+)/) {\n\t\t\t\t$self->{reject}{$1} = \"P\";\n\t\t\t\tdelete $self->{sequences}{$1};\n\t\t\t}\n\t\t}\n\t}\n\telse {\n\t\tforeach (@lines) {\n\t\t\t$self->{reject}{$1} = \"R\" if /dropping\\s+(\\S+)/;\n\t\t}\n\t}\n}\n\n=head2 get_Seq_Objs\n\n Title   :  get_Seq_Objs\n Usage   :  $lucyObj->get_Seq_Objs()\n Function:  returns an array of references to Bio::PrimarySeq objects \n\t    where -id = 'sequence name' and -seq = 'sequence'\n\n Returns :  array of Bio::PrimarySeq objects\n Args\t :  none\n\n\nsub get_Seq_Objs {\n    my $self = shift;\n    my($seqobj, @seqobjs);\n    foreach my $key (sort keys %{$self->{sequences}}) {\n\t$seqobj = Bio::PrimarySeq->new( -seq => \"$self->{sequences}{$key}{sequence}\",\n\t\t\t\t\t-id => \"$key\");\n\tpush @seqobjs, $seqobj;\n    }\n    return \\@seqobjs;\n} \n\n=head2 get_Seq_Obj\n\n Title   :  get_Seq_Obj\n Usage   :  $lucyObj->get_Seq_Obj($seqname)\n Function:  returns reference to a Bio::PrimarySeq object where -id = 'sequence name'\n\t    and -seq = 'sequence'\n Returns :  reference to Bio::PrimarySeq object\n Args\t :  name of a sequence \n\n\nsub get_Seq_Obj {\n    my ($self, $key) = @_;\n    my $seqobj = Bio::PrimarySeq->new( -seq => \"$self->{sequences}{$key}{sequence}\",\n                                    -id => \"$key\");\n    return $seqobj;\n}\n\n=head2 get_sequence_names\n\n Title   :  get_sequence_names\n Usage   :  $lucyObj->get_sequence_names\n Function:  returns reference to an array of names of the sequences analyzed by Lucy.\n\t    These names are required for most of the accessor methods.  \n\t    Note: The Lucy binary will fail unless sequence names are unique.\n Returns :  array reference\n Args\t :  none \n\n\nsub get_sequence_names {\n    my $self = shift;\n    my @keys = sort keys %{$self->{sequences}};\n    return \\@keys;\n}\n\n=head2 sequence\n\n Title   :  sequence\n Usage   :  $lucyObj->sequence($seqname)\n Function:  returns the DNA sequence of one of the sequences analyzed by Lucy.\n Returns :  string\n Args\t :  name of a sequence                   ","parameters":[{"label":"$self"},{"label":"$key"}],"label":"sequence($self,$key)"},"detail":"($self,$key)","definition":"sub","containerName":"main::","range":{"start":{"line":462,"character":0},"end":{"character":9999,"line":465}},"name":"sequence"},{"line":464,"kind":12,"name":"sequences"},{"name":"sequence","kind":12,"line":464},{"name":"quality","range":{"end":{"line":481,"character":9999},"start":{"line":478,"character":0}},"kind":12,"children":[{"line":479,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"quality"},{"containerName":"quality","name":"$key","line":479,"kind":13},{"name":"$self","containerName":"quality","line":480,"kind":13},{"line":480,"kind":13,"containerName":"quality","name":"$key"}],"line":478,"definition":"sub","containerName":"main::","signature":{"label":"quality($self,$key)","parameters":[{"label":"$self"},{"label":"$key"}],"documentation":"1;\n# $Id: Lucy.pm 16123 2009-09-17 12:57:27Z cjfields $ \n#\n# BioPerl module for Bio::Tools::Lucy\n#\n# Copyright Her Majesty the Queen of England\n# written by Andrew Walsh (paeruginosa@hotmail.com) during employment with \n# Agriculture and Agri-food Canada, Cereal Research Centre, Winnipeg, MB\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Lucy - Object for analyzing the output from Lucy,\n  a vector and quality trimming program from TIGR\n\n=head1 SYNOPSIS\n\n  # Create the Lucy object from an existing Lucy output file\n  @params = ('seqfile' => 'lucy.seq', 'lucy_verbose' => 1);\n  $lucyObj = Bio::Tools::Lucy->new(@params);\n\n  # Get names of all sequences\n  $names = $lucyObj->get_sequence_names();\n\n  #  Print seq and qual values for sequences >400 bp in order to run CAP3\n  foreach $name (@$names) {\n      next unless $lucyObj->length_clear($name) > 400;\n      print SEQ \">$name\\n\", $lucyObj->sequence($name), \"\\n\";\n      print QUAL \">$name\\n\", $lucyObj->quality($name), \"\\n\";\n  }\n\n  # Get an array of Bio::PrimarySeq objects\n  @seqObjs = $lucyObj->get_Seq_Objs();\n\n\n=head1 DESCRIPTION\n\nBio::Tools::Lucy.pm provides methods for analyzing the sequence and\nquality values generated by Lucy program from TIGR.\n\nLucy will identify vector, poly-A/T tails, and poor quality regions in\na sequence.  (www.genomics.purdue.edu/gcg/other/lucy.pdf)\n\nThe input to Lucy can be the Phred sequence and quality files\ngenerated from running Phred on a set of chromatograms.\n\nLucy can be obtained (free of charge to academic users) from\nwww.tigr.org/softlab\n\nThere are a few methods that will only be available if you make some\nminor changes to the source for Lucy and then recompile.  The changes\nare in the 'lucy.c' file and there is a diff between the original and\nthe modified file in the Appendix\n\nPlease contact the author of this module if you have any problems\nmaking these modifications.\n\nYou do not have to make these modifications to use this module.\n\n=head2 Creating a Lucy object\n\n  @params = ('seqfile' => 'lucy.seq', 'adv_stderr' => 1, \n\t     'fwd_desig' => '_F', 'rev_desig' => '_R');\n  $lucyObj = Bio::Tools::Lucy->new(@params);\n\n=head2 Using a Lucy object\n\n  You should get an array with the sequence names in order to use\n  accessor methods.  Note: The Lucy binary program will fail unless\n  the sequence names provided as input are unique.\n\n  $names_ref = $lucyObj->get_sequence_names();\n\n  This code snippet will produce a Fasta format file with sequence\n  lengths and %GC in the description line.\n\n  foreach $name (@$names) {\n      print FILE \">$name\\t\",\n\t\t $lucyObj->length_clear($name), \"\\t\",\n\t\t $lucyObj->per_GC($name), \"\\n\",\n\t\t $lucyObj->sequence($name), \"\\n\";\n  }\n\n\n  Print seq and qual values for sequences >400 bp in order to assemble\n  them with CAP3 (or other assembler).\n\n  foreach $name (@$names) {\n      next unless $lucyObj->length_clear($name) > 400;\n      print SEQ \">$name\\n\", $lucyObj->sequence($name), \"\\n\";\n      print QUAL \">$name\\n\", $lucyObj->quality($name), \"\\n\";\n  }\n\n  Get all the sequences as Bio::PrimarySeq objects (eg., for use with\n  Bio::Tools::Run::StandaloneBlast to perform BLAST).\n\n  @seqObjs = $lucyObj->get_Seq_Objs();\n\n  Or use only those sequences that are full length and have a Poly-A\n  tail.\n\n  foreach $name (@$names) {\n      next unless ($lucyObj->full_length($name) and $lucy->polyA($name));\n      push @seqObjs, $lucyObj->get_Seq_Obj($name);\n  }\n\n\n  Get the names of those sequences that were rejected by Lucy.\n\n  $rejects_ref = $lucyObj->get_rejects();\n\n  Print the names of the rejects and 1 letter code for reason they\n  were rejected.\n\n  foreach $key (sort keys %$rejects_ref) {\n      print \"$key:  \", $rejects_ref->{$key};\n  }\n\n  There is a lot of other information available about the sequences\n  analyzed by Lucy (see APPENDIX).  This module can be used with the\n  DBI module to store this sequence information in a database.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules.  Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nAndrew G. Walsh\t\tpaeruginosa@hotmail.com\n\n=head1 APPENDIX\n\nMethods available to Lucy objects are described below.  Please note\nthat any method beginning with an underscore is considered internal\nand should not be called directly.\n\n\n\npackage Bio::Tools::Lucy;\n\nuse vars qw($AUTOLOAD @ATTR %OK_FIELD);\nuse strict;\nuse Bio::PrimarySeq;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n@ATTR = qw(seqfile qualfile stderrfile infofile lucy_verbose fwd_desig rev_desig adv_stderr); \nforeach my $attr (@ATTR) {\n    $OK_FIELD{$attr}++\n}\n\nsub AUTOLOAD {\n    my $self = shift;\n    my $attr = $AUTOLOAD;\n    $attr =~ s/.*:://;\n    $attr = lc $attr;\n    $self->throw(\"Unallowed parameter: $attr !\") unless $OK_FIELD{$attr};\n    $self->{$attr} = shift if @_;\n    return $self->{$attr};\n}\n\n=head2 new\n\n Title\t :  new\n Usage\t :  $lucyObj = Bio::Tools::Lucy->new(seqfile => lucy.seq, rev_desig => '_R', \n\t    fwd_desig => '_F')\n Function:  creates a Lucy object from Lucy analysis files\n Returns :  reference to Bio::Tools::Lucy object\n Args\t :  seqfile\tFasta sequence file generated by Lucy\n\t       qualfile\tQuality values file generated by Lucy\n\t       infofile\tInfo file created when Lucy is run with -debug \n                     'infofile' option\n\t       stderrfile\tStandard error captured from Lucy when Lucy is run \n\t\t\t with -info option and STDERR is directed to stderrfile \n\t\t\t (ie. lucy ... 2> stderrfile).\n\t\t\t Info in this file will include sequences dropped for low \n\t\t\t quality. If you've modified Lucy source (see adv_stderr below), \n\t\t\t it will also include info on which sequences were dropped because \n\t\t\t they were vector, too short, had no insert, and whether a poly-A \n\t\t\t tail was found (if Lucy was run with -cdna option).\n\t       lucy_verbose verbosity level (0-1).  \n\t       fwd_desig\tThe string used to determine whether sequence is a \n          forward read.  \n\t\t\t The parser will assume that this match will occus at the \n\t\t\t end of the sequence name string.\n\t       rev_desig\tAs above, for reverse reads. \n \t       adv_stderr\tCan be set to a true value (1).  Will only work if \n          you have modified \n\t\t\t the Lucy source code as outlined in DESCRIPTION and capture \n\t\t\t the standard error from Lucy.\n\nIf you don't provide filenames for qualfile, infofile or stderrfile,\nthe module will assume that .qual, .info, and .stderr are the file\nextensions and search in the same directory as the .seq file for these\nfiles.\n\nFor example, if you create a Lucy object with $lucyObj =\nBio::Tools::Lucy-E<gt>new(seqfile =E<gt>lucy.seq), the module will\nfind lucy.qual, lucy.info and lucy.stderr.\n\nYou can omit any or all of the quality, info or stderr files, but you\nwill not be able to use all of the object methods (see method\ndocumentation below).\n\n\nsub new {\n\tmy ($class,@args) = @_;\n\tmy $self = $class->SUPER::new(@args);\n\tmy ($attr, $value);\n\twhile (@args) {\n\t\t$attr = shift @args;\n\t\t$attr = lc $attr;\n\t\t$value = shift @args;\n\t\t$self->{$attr} = $value;\n\t}\n\t&_parse($self);\n\treturn $self;\n}\n\n=head2 _parse\n\n Title\t :  _parse\n Usage\t :  n/a (internal function)\n Function:  called by new() to parse Lucy output files\n Returns :  nothing\n Args\t :  none\n\n\nsub _parse {\n\tmy $self = shift;\n\t$self->{seqfile} =~ /^(\\S+)\\.\\S+$/;\n\tmy $file = $1;\n\n\t$self->warn(\"Opening $self->{seqfile} for parsing...\\n\") if $self->{lucy_verbose};\n\topen my $SEQ, $self->{seqfile} or $self->throw(\"Could not open sequence file: $self->{seqfile}\");\n\tmy ($name, $line);\n\tmy $seq = \"\";\n\tmy @lines = <$SEQ>;\n\twhile ($line = pop @lines) {\n\t\tchomp $line;\n\t\tif ($line =~ /^>(\\S+)\\s+(\\d+)\\s+(\\d+)\\s+(\\d+)\\s+(\\d+)\\s+(\\d+)/) {    \n\t\t\t$name = $1;\n\t\t\tif ($self->{fwd_desig}) {\n\t\t\t\t$self->{sequences}{$name}{direction} = \"F\" if $name =~ /^(\\S+)($self->{fwd_desig})$/;\n\t\t\t}\n\t\t\tif ($self->{rev_desig}) {\n\t\t\t\t$self->{sequences}{$name}{direction} = \"R\" if $name =~ /^(\\S+)($self->{rev_desig})$/;\n\t\t\t}\n\t\t\t$self->{sequences}{$name}{min_clone_len} = $2; # this is used for TIGR Assembler, as are $3 and $4\n\t\t\t$self->{sequences}{$name}{max_clone_len} = $3;\n\t\t\t$self->{sequences}{$name}{med_clone_len} = $4; \n\t\t\t$self->{sequences}{$name}{beg_clear} = $5;\n\t\t\t$self->{sequences}{$name}{end_clear} = $6;\n\t\t\t$self->{sequences}{$name}{length_raw} = $seq =~ tr/[AGCTN]//; # from what I've seen, these are the bases Phred calls.  Please let me know if I'm wrong.     \n\t\t\tmy $beg = $5-1; # substr function begins with index 0\n\t\t\t$seq = $self->{sequences}{$name}{sequence} = substr ($seq, $beg, $6-$beg);\n\t\t\tmy $count = $self->{sequences}{$name}{length_clear} = $seq =~ tr/[AGCTN]//;\n\t\t\tmy $countGC =  $seq =~ tr/[GC]//;\n\t\t\t$self->{sequences}{$name}{per_GC} = $countGC/$count * 100;\n\t\t\t$seq = \"\";\n\t\t}\n\t\telse {\n\t\t\t$seq = $line.$seq;\n\t\t}\n\t}\n\n\t# now parse quality values (check for presence of quality file first) \n\tif ($self->{qualfile}) {\n\t\topen my $QUAL, \"$self->{qualfile}\" or $self->throw(\"Could not open quality file: $self->{qualfile}\");\n\t\t@lines = <$QUAL>;\n\t}\n\telsif (-e \"$file.qual\") {\n\t\t$self->warn(\"You did not set qualfile, but I'm opening $file.qual\\n\") if $self->{lucy_verbose};\n\t$self->qualfile(\"$file.qual\");\n\t\topen my $QUAL, \"$file.qual\" or $self->throw(\"Could not open quality file: $file.qual\");\n\t\t@lines = <$QUAL>;\n\t}\n    else {\n\t\t $self->warn(\"I did not find a quality file.  You will not be able to use all of the accessor methods.\\n\") if $self->{lucy_verbose};\n\t\t @lines = ();\n    }\n\n\tmy (@vals, @slice, $num, $tot, $vals);  \n\tmy $qual = \"\"; \n\twhile ($line = pop @lines) {\n\t\tchomp $line;\n\t\tif ($line =~ /^>(\\S+)/) {\n\t\t\t$name = $1;\n\t\t\t@vals = split /\\s/ , $qual;\n\t\t\t@slice = @vals[$self->{sequences}{$name}{beg_clear} - 1 .. $self->{sequences}{$name}{end_clear} - 1];\n\t\t\t$vals = join \"\\t\", @slice;\n\t\t\t$self->{sequences}{$name}{quality} = $vals;\n\t\t\t$qual = \"\";\n\t\t\tforeach $num (@slice) {\n\t\t\t\t$tot += $num;\n\t\t\t}\n\t\t\t$num = @slice;\n\t\t\t$self->{sequences}{$name}{avg_quality} = $tot/$num;\n\t\t\t$tot = 0;\n\t\t}\n\t\telse {\n\t\t\t$qual = $line.$qual;\n\t\t}\n\t}\n\n\t# determine whether reads are full length\n\tif ($self->{infofile}) {\n\t\topen my $INFO, \"$self->{infofile}\" or $self->throw(\"Could not open info file: $self->{infofile}\");\n\t\t@lines = <$INFO>;\n\t}\n\telsif (-e \"$file.info\") {\n\t\t$self->warn(\"You did not set infofile, but I'm opening $file.info\\n\") if $self->{lucy_verbose};\n\t\t$self->infofile(\"$file.info\");\n\t\topen my $INFO, \"$file.info\" or $self->throw(\"Could not open info file: $file.info\");\n\t\t@lines = <$INFO>;\n\t}\n\telse {\n\t\t$self->warn(\"I did not find an info file.  You will not be able to use all of the accessor methods.\\n\") if $self->{lucy_verbose};\n\t\t@lines = ();\n\t}\n\n\tforeach (@lines) {\n\t\t/^(\\S+).+CLV\\s+(\\d+)\\s+(\\d+)$/;\n\t\tif ($2>0 && $3>0) {\n\t\t\t$self->{sequences}{$1}{full_length} = 1 if $self->{sequences}{$1}; # will show cleavage info for rejected sequences too\n\t\t}\n\t}\n\n\n\t# parse rejects (and presence of poly-A if Lucy has been modified)\n\tif ($self->{stderrfile}) {\n\t\topen my $STDERR_LUCY, \"$self->{stderrfile}\" or $self->throw(\"Could not open quality file: $self->{stderrfile}\");\n\t\t@lines = <$STDERR_LUCY>;\n\t}\n\telsif (-e \"$file.stderr\") {\n\t\t$self->warn(\"You did not set stderrfile, but I'm opening $file.stderr\\n\") if $self->{lucy_verbose};\n\t\t$self->stderrfile(\"$file.stderr\");\n\t\topen my $STDERR_LUCY, \"$file.stderr\" or $self->throw(\"Could not open quality file: $file.stderr\");\n\t\t@lines = <$STDERR_LUCY>;\n\t}\n\telse {\n\t\t$self->warn(\"I did not find a standard error file.  You will not be able to use all of the accessor methods.\\n\") if $self->{lucy_verbose};\n\t\t@lines = ();\n\t}\n\n\tif ($self->{adv_stderr}) {\n\t\tforeach (@lines) {\n\t\t\t$self->{reject}{$1} = \"Q\" if /dropping\\s+(\\S+)/;\n\t\t\t$self->{reject}{$1} = \"V\" if /Vector: (\\S+)/;\n\t\t\t$self->{reject}{$1} = \"E\" if /Empty: (\\S+)/;\n\t\t\t$self->{reject}{$1} = \"S\" if m{Short/ no insert: (\\S+)};\n\t\t\t$self->{sequences}{$1}{polyA} = 1 if /(\\S+) has PolyA/;\n\t\t\tif (/Dropped PolyA: (\\S+)/) {\n\t\t\t\t$self->{reject}{$1} = \"P\";\n\t\t\t\tdelete $self->{sequences}{$1};\n\t\t\t}\n\t\t}\n\t}\n\telse {\n\t\tforeach (@lines) {\n\t\t\t$self->{reject}{$1} = \"R\" if /dropping\\s+(\\S+)/;\n\t\t}\n\t}\n}\n\n=head2 get_Seq_Objs\n\n Title   :  get_Seq_Objs\n Usage   :  $lucyObj->get_Seq_Objs()\n Function:  returns an array of references to Bio::PrimarySeq objects \n\t    where -id = 'sequence name' and -seq = 'sequence'\n\n Returns :  array of Bio::PrimarySeq objects\n Args\t :  none\n\n\nsub get_Seq_Objs {\n    my $self = shift;\n    my($seqobj, @seqobjs);\n    foreach my $key (sort keys %{$self->{sequences}}) {\n\t$seqobj = Bio::PrimarySeq->new( -seq => \"$self->{sequences}{$key}{sequence}\",\n\t\t\t\t\t-id => \"$key\");\n\tpush @seqobjs, $seqobj;\n    }\n    return \\@seqobjs;\n} \n\n=head2 get_Seq_Obj\n\n Title   :  get_Seq_Obj\n Usage   :  $lucyObj->get_Seq_Obj($seqname)\n Function:  returns reference to a Bio::PrimarySeq object where -id = 'sequence name'\n\t    and -seq = 'sequence'\n Returns :  reference to Bio::PrimarySeq object\n Args\t :  name of a sequence \n\n\nsub get_Seq_Obj {\n    my ($self, $key) = @_;\n    my $seqobj = Bio::PrimarySeq->new( -seq => \"$self->{sequences}{$key}{sequence}\",\n                                    -id => \"$key\");\n    return $seqobj;\n}\n\n=head2 get_sequence_names\n\n Title   :  get_sequence_names\n Usage   :  $lucyObj->get_sequence_names\n Function:  returns reference to an array of names of the sequences analyzed by Lucy.\n\t    These names are required for most of the accessor methods.  \n\t    Note: The Lucy binary will fail unless sequence names are unique.\n Returns :  array reference\n Args\t :  none \n\n\nsub get_sequence_names {\n    my $self = shift;\n    my @keys = sort keys %{$self->{sequences}};\n    return \\@keys;\n}\n\n=head2 sequence\n\n Title   :  sequence\n Usage   :  $lucyObj->sequence($seqname)\n Function:  returns the DNA sequence of one of the sequences analyzed by Lucy.\n Returns :  string\n Args\t :  name of a sequence                   \n\n\nsub sequence {\n    my ($self, $key) = @_;\n    return $self->{sequences}{$key}{sequence};\n}\n\n=head2 quality\n\n Title   :  quality\n Usage   :  $lucyObj->quality($seqname)\n Function:  returns the quality values of one of the sequences analyzed by Lucy.\n\t    This method depends on the user having provided a quality file.\n Returns :  string\n Args    :  name of a sequence"},"detail":"($self,$key)"},{"kind":12,"line":480,"name":"sequences"},{"name":"quality","line":480,"kind":12},{"children":[{"kind":13,"line":494,"definition":"my","name":"$self","containerName":"avg_quality","localvar":"my"},{"name":"$key","containerName":"avg_quality","kind":13,"line":494},{"kind":13,"line":495,"containerName":"avg_quality","name":"$self"},{"name":"$key","containerName":"avg_quality","line":495,"kind":13}],"line":493,"kind":12,"signature":{"label":"avg_quality($self,$key)","parameters":[{"label":"$self"},{"label":"$key"}],"documentation":"1;\n# $Id: Lucy.pm 16123 2009-09-17 12:57:27Z cjfields $ \n#\n# BioPerl module for Bio::Tools::Lucy\n#\n# Copyright Her Majesty the Queen of England\n# written by Andrew Walsh (paeruginosa@hotmail.com) during employment with \n# Agriculture and Agri-food Canada, Cereal Research Centre, Winnipeg, MB\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Lucy - Object for analyzing the output from Lucy,\n  a vector and quality trimming program from TIGR\n\n=head1 SYNOPSIS\n\n  # Create the Lucy object from an existing Lucy output file\n  @params = ('seqfile' => 'lucy.seq', 'lucy_verbose' => 1);\n  $lucyObj = Bio::Tools::Lucy->new(@params);\n\n  # Get names of all sequences\n  $names = $lucyObj->get_sequence_names();\n\n  #  Print seq and qual values for sequences >400 bp in order to run CAP3\n  foreach $name (@$names) {\n      next unless $lucyObj->length_clear($name) > 400;\n      print SEQ \">$name\\n\", $lucyObj->sequence($name), \"\\n\";\n      print QUAL \">$name\\n\", $lucyObj->quality($name), \"\\n\";\n  }\n\n  # Get an array of Bio::PrimarySeq objects\n  @seqObjs = $lucyObj->get_Seq_Objs();\n\n\n=head1 DESCRIPTION\n\nBio::Tools::Lucy.pm provides methods for analyzing the sequence and\nquality values generated by Lucy program from TIGR.\n\nLucy will identify vector, poly-A/T tails, and poor quality regions in\na sequence.  (www.genomics.purdue.edu/gcg/other/lucy.pdf)\n\nThe input to Lucy can be the Phred sequence and quality files\ngenerated from running Phred on a set of chromatograms.\n\nLucy can be obtained (free of charge to academic users) from\nwww.tigr.org/softlab\n\nThere are a few methods that will only be available if you make some\nminor changes to the source for Lucy and then recompile.  The changes\nare in the 'lucy.c' file and there is a diff between the original and\nthe modified file in the Appendix\n\nPlease contact the author of this module if you have any problems\nmaking these modifications.\n\nYou do not have to make these modifications to use this module.\n\n=head2 Creating a Lucy object\n\n  @params = ('seqfile' => 'lucy.seq', 'adv_stderr' => 1, \n\t     'fwd_desig' => '_F', 'rev_desig' => '_R');\n  $lucyObj = Bio::Tools::Lucy->new(@params);\n\n=head2 Using a Lucy object\n\n  You should get an array with the sequence names in order to use\n  accessor methods.  Note: The Lucy binary program will fail unless\n  the sequence names provided as input are unique.\n\n  $names_ref = $lucyObj->get_sequence_names();\n\n  This code snippet will produce a Fasta format file with sequence\n  lengths and %GC in the description line.\n\n  foreach $name (@$names) {\n      print FILE \">$name\\t\",\n\t\t $lucyObj->length_clear($name), \"\\t\",\n\t\t $lucyObj->per_GC($name), \"\\n\",\n\t\t $lucyObj->sequence($name), \"\\n\";\n  }\n\n\n  Print seq and qual values for sequences >400 bp in order to assemble\n  them with CAP3 (or other assembler).\n\n  foreach $name (@$names) {\n      next unless $lucyObj->length_clear($name) > 400;\n      print SEQ \">$name\\n\", $lucyObj->sequence($name), \"\\n\";\n      print QUAL \">$name\\n\", $lucyObj->quality($name), \"\\n\";\n  }\n\n  Get all the sequences as Bio::PrimarySeq objects (eg., for use with\n  Bio::Tools::Run::StandaloneBlast to perform BLAST).\n\n  @seqObjs = $lucyObj->get_Seq_Objs();\n\n  Or use only those sequences that are full length and have a Poly-A\n  tail.\n\n  foreach $name (@$names) {\n      next unless ($lucyObj->full_length($name) and $lucy->polyA($name));\n      push @seqObjs, $lucyObj->get_Seq_Obj($name);\n  }\n\n\n  Get the names of those sequences that were rejected by Lucy.\n\n  $rejects_ref = $lucyObj->get_rejects();\n\n  Print the names of the rejects and 1 letter code for reason they\n  were rejected.\n\n  foreach $key (sort keys %$rejects_ref) {\n      print \"$key:  \", $rejects_ref->{$key};\n  }\n\n  There is a lot of other information available about the sequences\n  analyzed by Lucy (see APPENDIX).  This module can be used with the\n  DBI module to store this sequence information in a database.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules.  Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nAndrew G. Walsh\t\tpaeruginosa@hotmail.com\n\n=head1 APPENDIX\n\nMethods available to Lucy objects are described below.  Please note\nthat any method beginning with an underscore is considered internal\nand should not be called directly.\n\n\n\npackage Bio::Tools::Lucy;\n\nuse vars qw($AUTOLOAD @ATTR %OK_FIELD);\nuse strict;\nuse Bio::PrimarySeq;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n@ATTR = qw(seqfile qualfile stderrfile infofile lucy_verbose fwd_desig rev_desig adv_stderr); \nforeach my $attr (@ATTR) {\n    $OK_FIELD{$attr}++\n}\n\nsub AUTOLOAD {\n    my $self = shift;\n    my $attr = $AUTOLOAD;\n    $attr =~ s/.*:://;\n    $attr = lc $attr;\n    $self->throw(\"Unallowed parameter: $attr !\") unless $OK_FIELD{$attr};\n    $self->{$attr} = shift if @_;\n    return $self->{$attr};\n}\n\n=head2 new\n\n Title\t :  new\n Usage\t :  $lucyObj = Bio::Tools::Lucy->new(seqfile => lucy.seq, rev_desig => '_R', \n\t    fwd_desig => '_F')\n Function:  creates a Lucy object from Lucy analysis files\n Returns :  reference to Bio::Tools::Lucy object\n Args\t :  seqfile\tFasta sequence file generated by Lucy\n\t       qualfile\tQuality values file generated by Lucy\n\t       infofile\tInfo file created when Lucy is run with -debug \n                     'infofile' option\n\t       stderrfile\tStandard error captured from Lucy when Lucy is run \n\t\t\t with -info option and STDERR is directed to stderrfile \n\t\t\t (ie. lucy ... 2> stderrfile).\n\t\t\t Info in this file will include sequences dropped for low \n\t\t\t quality. If you've modified Lucy source (see adv_stderr below), \n\t\t\t it will also include info on which sequences were dropped because \n\t\t\t they were vector, too short, had no insert, and whether a poly-A \n\t\t\t tail was found (if Lucy was run with -cdna option).\n\t       lucy_verbose verbosity level (0-1).  \n\t       fwd_desig\tThe string used to determine whether sequence is a \n          forward read.  \n\t\t\t The parser will assume that this match will occus at the \n\t\t\t end of the sequence name string.\n\t       rev_desig\tAs above, for reverse reads. \n \t       adv_stderr\tCan be set to a true value (1).  Will only work if \n          you have modified \n\t\t\t the Lucy source code as outlined in DESCRIPTION and capture \n\t\t\t the standard error from Lucy.\n\nIf you don't provide filenames for qualfile, infofile or stderrfile,\nthe module will assume that .qual, .info, and .stderr are the file\nextensions and search in the same directory as the .seq file for these\nfiles.\n\nFor example, if you create a Lucy object with $lucyObj =\nBio::Tools::Lucy-E<gt>new(seqfile =E<gt>lucy.seq), the module will\nfind lucy.qual, lucy.info and lucy.stderr.\n\nYou can omit any or all of the quality, info or stderr files, but you\nwill not be able to use all of the object methods (see method\ndocumentation below).\n\n\nsub new {\n\tmy ($class,@args) = @_;\n\tmy $self = $class->SUPER::new(@args);\n\tmy ($attr, $value);\n\twhile (@args) {\n\t\t$attr = shift @args;\n\t\t$attr = lc $attr;\n\t\t$value = shift @args;\n\t\t$self->{$attr} = $value;\n\t}\n\t&_parse($self);\n\treturn $self;\n}\n\n=head2 _parse\n\n Title\t :  _parse\n Usage\t :  n/a (internal function)\n Function:  called by new() to parse Lucy output files\n Returns :  nothing\n Args\t :  none\n\n\nsub _parse {\n\tmy $self = shift;\n\t$self->{seqfile} =~ /^(\\S+)\\.\\S+$/;\n\tmy $file = $1;\n\n\t$self->warn(\"Opening $self->{seqfile} for parsing...\\n\") if $self->{lucy_verbose};\n\topen my $SEQ, $self->{seqfile} or $self->throw(\"Could not open sequence file: $self->{seqfile}\");\n\tmy ($name, $line);\n\tmy $seq = \"\";\n\tmy @lines = <$SEQ>;\n\twhile ($line = pop @lines) {\n\t\tchomp $line;\n\t\tif ($line =~ /^>(\\S+)\\s+(\\d+)\\s+(\\d+)\\s+(\\d+)\\s+(\\d+)\\s+(\\d+)/) {    \n\t\t\t$name = $1;\n\t\t\tif ($self->{fwd_desig}) {\n\t\t\t\t$self->{sequences}{$name}{direction} = \"F\" if $name =~ /^(\\S+)($self->{fwd_desig})$/;\n\t\t\t}\n\t\t\tif ($self->{rev_desig}) {\n\t\t\t\t$self->{sequences}{$name}{direction} = \"R\" if $name =~ /^(\\S+)($self->{rev_desig})$/;\n\t\t\t}\n\t\t\t$self->{sequences}{$name}{min_clone_len} = $2; # this is used for TIGR Assembler, as are $3 and $4\n\t\t\t$self->{sequences}{$name}{max_clone_len} = $3;\n\t\t\t$self->{sequences}{$name}{med_clone_len} = $4; \n\t\t\t$self->{sequences}{$name}{beg_clear} = $5;\n\t\t\t$self->{sequences}{$name}{end_clear} = $6;\n\t\t\t$self->{sequences}{$name}{length_raw} = $seq =~ tr/[AGCTN]//; # from what I've seen, these are the bases Phred calls.  Please let me know if I'm wrong.     \n\t\t\tmy $beg = $5-1; # substr function begins with index 0\n\t\t\t$seq = $self->{sequences}{$name}{sequence} = substr ($seq, $beg, $6-$beg);\n\t\t\tmy $count = $self->{sequences}{$name}{length_clear} = $seq =~ tr/[AGCTN]//;\n\t\t\tmy $countGC =  $seq =~ tr/[GC]//;\n\t\t\t$self->{sequences}{$name}{per_GC} = $countGC/$count * 100;\n\t\t\t$seq = \"\";\n\t\t}\n\t\telse {\n\t\t\t$seq = $line.$seq;\n\t\t}\n\t}\n\n\t# now parse quality values (check for presence of quality file first) \n\tif ($self->{qualfile}) {\n\t\topen my $QUAL, \"$self->{qualfile}\" or $self->throw(\"Could not open quality file: $self->{qualfile}\");\n\t\t@lines = <$QUAL>;\n\t}\n\telsif (-e \"$file.qual\") {\n\t\t$self->warn(\"You did not set qualfile, but I'm opening $file.qual\\n\") if $self->{lucy_verbose};\n\t$self->qualfile(\"$file.qual\");\n\t\topen my $QUAL, \"$file.qual\" or $self->throw(\"Could not open quality file: $file.qual\");\n\t\t@lines = <$QUAL>;\n\t}\n    else {\n\t\t $self->warn(\"I did not find a quality file.  You will not be able to use all of the accessor methods.\\n\") if $self->{lucy_verbose};\n\t\t @lines = ();\n    }\n\n\tmy (@vals, @slice, $num, $tot, $vals);  \n\tmy $qual = \"\"; \n\twhile ($line = pop @lines) {\n\t\tchomp $line;\n\t\tif ($line =~ /^>(\\S+)/) {\n\t\t\t$name = $1;\n\t\t\t@vals = split /\\s/ , $qual;\n\t\t\t@slice = @vals[$self->{sequences}{$name}{beg_clear} - 1 .. $self->{sequences}{$name}{end_clear} - 1];\n\t\t\t$vals = join \"\\t\", @slice;\n\t\t\t$self->{sequences}{$name}{quality} = $vals;\n\t\t\t$qual = \"\";\n\t\t\tforeach $num (@slice) {\n\t\t\t\t$tot += $num;\n\t\t\t}\n\t\t\t$num = @slice;\n\t\t\t$self->{sequences}{$name}{avg_quality} = $tot/$num;\n\t\t\t$tot = 0;\n\t\t}\n\t\telse {\n\t\t\t$qual = $line.$qual;\n\t\t}\n\t}\n\n\t# determine whether reads are full length\n\tif ($self->{infofile}) {\n\t\topen my $INFO, \"$self->{infofile}\" or $self->throw(\"Could not open info file: $self->{infofile}\");\n\t\t@lines = <$INFO>;\n\t}\n\telsif (-e \"$file.info\") {\n\t\t$self->warn(\"You did not set infofile, but I'm opening $file.info\\n\") if $self->{lucy_verbose};\n\t\t$self->infofile(\"$file.info\");\n\t\topen my $INFO, \"$file.info\" or $self->throw(\"Could not open info file: $file.info\");\n\t\t@lines = <$INFO>;\n\t}\n\telse {\n\t\t$self->warn(\"I did not find an info file.  You will not be able to use all of the accessor methods.\\n\") if $self->{lucy_verbose};\n\t\t@lines = ();\n\t}\n\n\tforeach (@lines) {\n\t\t/^(\\S+).+CLV\\s+(\\d+)\\s+(\\d+)$/;\n\t\tif ($2>0 && $3>0) {\n\t\t\t$self->{sequences}{$1}{full_length} = 1 if $self->{sequences}{$1}; # will show cleavage info for rejected sequences too\n\t\t}\n\t}\n\n\n\t# parse rejects (and presence of poly-A if Lucy has been modified)\n\tif ($self->{stderrfile}) {\n\t\topen my $STDERR_LUCY, \"$self->{stderrfile}\" or $self->throw(\"Could not open quality file: $self->{stderrfile}\");\n\t\t@lines = <$STDERR_LUCY>;\n\t}\n\telsif (-e \"$file.stderr\") {\n\t\t$self->warn(\"You did not set stderrfile, but I'm opening $file.stderr\\n\") if $self->{lucy_verbose};\n\t\t$self->stderrfile(\"$file.stderr\");\n\t\topen my $STDERR_LUCY, \"$file.stderr\" or $self->throw(\"Could not open quality file: $file.stderr\");\n\t\t@lines = <$STDERR_LUCY>;\n\t}\n\telse {\n\t\t$self->warn(\"I did not find a standard error file.  You will not be able to use all of the accessor methods.\\n\") if $self->{lucy_verbose};\n\t\t@lines = ();\n\t}\n\n\tif ($self->{adv_stderr}) {\n\t\tforeach (@lines) {\n\t\t\t$self->{reject}{$1} = \"Q\" if /dropping\\s+(\\S+)/;\n\t\t\t$self->{reject}{$1} = \"V\" if /Vector: (\\S+)/;\n\t\t\t$self->{reject}{$1} = \"E\" if /Empty: (\\S+)/;\n\t\t\t$self->{reject}{$1} = \"S\" if m{Short/ no insert: (\\S+)};\n\t\t\t$self->{sequences}{$1}{polyA} = 1 if /(\\S+) has PolyA/;\n\t\t\tif (/Dropped PolyA: (\\S+)/) {\n\t\t\t\t$self->{reject}{$1} = \"P\";\n\t\t\t\tdelete $self->{sequences}{$1};\n\t\t\t}\n\t\t}\n\t}\n\telse {\n\t\tforeach (@lines) {\n\t\t\t$self->{reject}{$1} = \"R\" if /dropping\\s+(\\S+)/;\n\t\t}\n\t}\n}\n\n=head2 get_Seq_Objs\n\n Title   :  get_Seq_Objs\n Usage   :  $lucyObj->get_Seq_Objs()\n Function:  returns an array of references to Bio::PrimarySeq objects \n\t    where -id = 'sequence name' and -seq = 'sequence'\n\n Returns :  array of Bio::PrimarySeq objects\n Args\t :  none\n\n\nsub get_Seq_Objs {\n    my $self = shift;\n    my($seqobj, @seqobjs);\n    foreach my $key (sort keys %{$self->{sequences}}) {\n\t$seqobj = Bio::PrimarySeq->new( -seq => \"$self->{sequences}{$key}{sequence}\",\n\t\t\t\t\t-id => \"$key\");\n\tpush @seqobjs, $seqobj;\n    }\n    return \\@seqobjs;\n} \n\n=head2 get_Seq_Obj\n\n Title   :  get_Seq_Obj\n Usage   :  $lucyObj->get_Seq_Obj($seqname)\n Function:  returns reference to a Bio::PrimarySeq object where -id = 'sequence name'\n\t    and -seq = 'sequence'\n Returns :  reference to Bio::PrimarySeq object\n Args\t :  name of a sequence \n\n\nsub get_Seq_Obj {\n    my ($self, $key) = @_;\n    my $seqobj = Bio::PrimarySeq->new( -seq => \"$self->{sequences}{$key}{sequence}\",\n                                    -id => \"$key\");\n    return $seqobj;\n}\n\n=head2 get_sequence_names\n\n Title   :  get_sequence_names\n Usage   :  $lucyObj->get_sequence_names\n Function:  returns reference to an array of names of the sequences analyzed by Lucy.\n\t    These names are required for most of the accessor methods.  \n\t    Note: The Lucy binary will fail unless sequence names are unique.\n Returns :  array reference\n Args\t :  none \n\n\nsub get_sequence_names {\n    my $self = shift;\n    my @keys = sort keys %{$self->{sequences}};\n    return \\@keys;\n}\n\n=head2 sequence\n\n Title   :  sequence\n Usage   :  $lucyObj->sequence($seqname)\n Function:  returns the DNA sequence of one of the sequences analyzed by Lucy.\n Returns :  string\n Args\t :  name of a sequence                   \n\n\nsub sequence {\n    my ($self, $key) = @_;\n    return $self->{sequences}{$key}{sequence};\n}\n\n=head2 quality\n\n Title   :  quality\n Usage   :  $lucyObj->quality($seqname)\n Function:  returns the quality values of one of the sequences analyzed by Lucy.\n\t    This method depends on the user having provided a quality file.\n Returns :  string\n Args    :  name of a sequence\n\n\nsub quality {\n    my($self, $key) = @_;\n    return $self->{sequences}{$key}{quality};\n}\n\n=head2 avg_quality\n\n Title   :  avg_quality\n Usage   :  $lucyObj->avg_quality($seqname)\n Function:  returns the average quality value for one of the sequences analyzed by Lucy.\n Returns :  float\n Args    :  name of a sequence"},"detail":"($self,$key)","definition":"sub","containerName":"main::","range":{"start":{"line":493,"character":0},"end":{"line":496,"character":9999}},"name":"avg_quality"},{"line":495,"kind":12,"name":"sequences"},{"line":495,"kind":12,"name":"avg_quality"},{"children":[{"kind":13,"line":512,"containerName":"direction","definition":"my","name":"$self","localvar":"my"},{"line":512,"kind":13,"name":"$key","containerName":"direction"},{"name":"$self","containerName":"direction","line":513,"kind":13},{"containerName":"direction","name":"$key","kind":13,"line":513},{"kind":13,"line":513,"containerName":"direction","name":"$self"},{"name":"$key","containerName":"direction","line":513,"kind":13}],"line":511,"kind":12,"signature":{"label":"direction($self,$key)","documentation":"1;\n# $Id: Lucy.pm 16123 2009-09-17 12:57:27Z cjfields $ \n#\n# BioPerl module for Bio::Tools::Lucy\n#\n# Copyright Her Majesty the Queen of England\n# written by Andrew Walsh (paeruginosa@hotmail.com) during employment with \n# Agriculture and Agri-food Canada, Cereal Research Centre, Winnipeg, MB\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Lucy - Object for analyzing the output from Lucy,\n  a vector and quality trimming program from TIGR\n\n=head1 SYNOPSIS\n\n  # Create the Lucy object from an existing Lucy output file\n  @params = ('seqfile' => 'lucy.seq', 'lucy_verbose' => 1);\n  $lucyObj = Bio::Tools::Lucy->new(@params);\n\n  # Get names of all sequences\n  $names = $lucyObj->get_sequence_names();\n\n  #  Print seq and qual values for sequences >400 bp in order to run CAP3\n  foreach $name (@$names) {\n      next unless $lucyObj->length_clear($name) > 400;\n      print SEQ \">$name\\n\", $lucyObj->sequence($name), \"\\n\";\n      print QUAL \">$name\\n\", $lucyObj->quality($name), \"\\n\";\n  }\n\n  # Get an array of Bio::PrimarySeq objects\n  @seqObjs = $lucyObj->get_Seq_Objs();\n\n\n=head1 DESCRIPTION\n\nBio::Tools::Lucy.pm provides methods for analyzing the sequence and\nquality values generated by Lucy program from TIGR.\n\nLucy will identify vector, poly-A/T tails, and poor quality regions in\na sequence.  (www.genomics.purdue.edu/gcg/other/lucy.pdf)\n\nThe input to Lucy can be the Phred sequence and quality files\ngenerated from running Phred on a set of chromatograms.\n\nLucy can be obtained (free of charge to academic users) from\nwww.tigr.org/softlab\n\nThere are a few methods that will only be available if you make some\nminor changes to the source for Lucy and then recompile.  The changes\nare in the 'lucy.c' file and there is a diff between the original and\nthe modified file in the Appendix\n\nPlease contact the author of this module if you have any problems\nmaking these modifications.\n\nYou do not have to make these modifications to use this module.\n\n=head2 Creating a Lucy object\n\n  @params = ('seqfile' => 'lucy.seq', 'adv_stderr' => 1, \n\t     'fwd_desig' => '_F', 'rev_desig' => '_R');\n  $lucyObj = Bio::Tools::Lucy->new(@params);\n\n=head2 Using a Lucy object\n\n  You should get an array with the sequence names in order to use\n  accessor methods.  Note: The Lucy binary program will fail unless\n  the sequence names provided as input are unique.\n\n  $names_ref = $lucyObj->get_sequence_names();\n\n  This code snippet will produce a Fasta format file with sequence\n  lengths and %GC in the description line.\n\n  foreach $name (@$names) {\n      print FILE \">$name\\t\",\n\t\t $lucyObj->length_clear($name), \"\\t\",\n\t\t $lucyObj->per_GC($name), \"\\n\",\n\t\t $lucyObj->sequence($name), \"\\n\";\n  }\n\n\n  Print seq and qual values for sequences >400 bp in order to assemble\n  them with CAP3 (or other assembler).\n\n  foreach $name (@$names) {\n      next unless $lucyObj->length_clear($name) > 400;\n      print SEQ \">$name\\n\", $lucyObj->sequence($name), \"\\n\";\n      print QUAL \">$name\\n\", $lucyObj->quality($name), \"\\n\";\n  }\n\n  Get all the sequences as Bio::PrimarySeq objects (eg., for use with\n  Bio::Tools::Run::StandaloneBlast to perform BLAST).\n\n  @seqObjs = $lucyObj->get_Seq_Objs();\n\n  Or use only those sequences that are full length and have a Poly-A\n  tail.\n\n  foreach $name (@$names) {\n      next unless ($lucyObj->full_length($name) and $lucy->polyA($name));\n      push @seqObjs, $lucyObj->get_Seq_Obj($name);\n  }\n\n\n  Get the names of those sequences that were rejected by Lucy.\n\n  $rejects_ref = $lucyObj->get_rejects();\n\n  Print the names of the rejects and 1 letter code for reason they\n  were rejected.\n\n  foreach $key (sort keys %$rejects_ref) {\n      print \"$key:  \", $rejects_ref->{$key};\n  }\n\n  There is a lot of other information available about the sequences\n  analyzed by Lucy (see APPENDIX).  This module can be used with the\n  DBI module to store this sequence information in a database.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules.  Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nAndrew G. Walsh\t\tpaeruginosa@hotmail.com\n\n=head1 APPENDIX\n\nMethods available to Lucy objects are described below.  Please note\nthat any method beginning with an underscore is considered internal\nand should not be called directly.\n\n\n\npackage Bio::Tools::Lucy;\n\nuse vars qw($AUTOLOAD @ATTR %OK_FIELD);\nuse strict;\nuse Bio::PrimarySeq;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n@ATTR = qw(seqfile qualfile stderrfile infofile lucy_verbose fwd_desig rev_desig adv_stderr); \nforeach my $attr (@ATTR) {\n    $OK_FIELD{$attr}++\n}\n\nsub AUTOLOAD {\n    my $self = shift;\n    my $attr = $AUTOLOAD;\n    $attr =~ s/.*:://;\n    $attr = lc $attr;\n    $self->throw(\"Unallowed parameter: $attr !\") unless $OK_FIELD{$attr};\n    $self->{$attr} = shift if @_;\n    return $self->{$attr};\n}\n\n=head2 new\n\n Title\t :  new\n Usage\t :  $lucyObj = Bio::Tools::Lucy->new(seqfile => lucy.seq, rev_desig => '_R', \n\t    fwd_desig => '_F')\n Function:  creates a Lucy object from Lucy analysis files\n Returns :  reference to Bio::Tools::Lucy object\n Args\t :  seqfile\tFasta sequence file generated by Lucy\n\t       qualfile\tQuality values file generated by Lucy\n\t       infofile\tInfo file created when Lucy is run with -debug \n                     'infofile' option\n\t       stderrfile\tStandard error captured from Lucy when Lucy is run \n\t\t\t with -info option and STDERR is directed to stderrfile \n\t\t\t (ie. lucy ... 2> stderrfile).\n\t\t\t Info in this file will include sequences dropped for low \n\t\t\t quality. If you've modified Lucy source (see adv_stderr below), \n\t\t\t it will also include info on which sequences were dropped because \n\t\t\t they were vector, too short, had no insert, and whether a poly-A \n\t\t\t tail was found (if Lucy was run with -cdna option).\n\t       lucy_verbose verbosity level (0-1).  \n\t       fwd_desig\tThe string used to determine whether sequence is a \n          forward read.  \n\t\t\t The parser will assume that this match will occus at the \n\t\t\t end of the sequence name string.\n\t       rev_desig\tAs above, for reverse reads. \n \t       adv_stderr\tCan be set to a true value (1).  Will only work if \n          you have modified \n\t\t\t the Lucy source code as outlined in DESCRIPTION and capture \n\t\t\t the standard error from Lucy.\n\nIf you don't provide filenames for qualfile, infofile or stderrfile,\nthe module will assume that .qual, .info, and .stderr are the file\nextensions and search in the same directory as the .seq file for these\nfiles.\n\nFor example, if you create a Lucy object with $lucyObj =\nBio::Tools::Lucy-E<gt>new(seqfile =E<gt>lucy.seq), the module will\nfind lucy.qual, lucy.info and lucy.stderr.\n\nYou can omit any or all of the quality, info or stderr files, but you\nwill not be able to use all of the object methods (see method\ndocumentation below).\n\n\nsub new {\n\tmy ($class,@args) = @_;\n\tmy $self = $class->SUPER::new(@args);\n\tmy ($attr, $value);\n\twhile (@args) {\n\t\t$attr = shift @args;\n\t\t$attr = lc $attr;\n\t\t$value = shift @args;\n\t\t$self->{$attr} = $value;\n\t}\n\t&_parse($self);\n\treturn $self;\n}\n\n=head2 _parse\n\n Title\t :  _parse\n Usage\t :  n/a (internal function)\n Function:  called by new() to parse Lucy output files\n Returns :  nothing\n Args\t :  none\n\n\nsub _parse {\n\tmy $self = shift;\n\t$self->{seqfile} =~ /^(\\S+)\\.\\S+$/;\n\tmy $file = $1;\n\n\t$self->warn(\"Opening $self->{seqfile} for parsing...\\n\") if $self->{lucy_verbose};\n\topen my $SEQ, $self->{seqfile} or $self->throw(\"Could not open sequence file: $self->{seqfile}\");\n\tmy ($name, $line);\n\tmy $seq = \"\";\n\tmy @lines = <$SEQ>;\n\twhile ($line = pop @lines) {\n\t\tchomp $line;\n\t\tif ($line =~ /^>(\\S+)\\s+(\\d+)\\s+(\\d+)\\s+(\\d+)\\s+(\\d+)\\s+(\\d+)/) {    \n\t\t\t$name = $1;\n\t\t\tif ($self->{fwd_desig}) {\n\t\t\t\t$self->{sequences}{$name}{direction} = \"F\" if $name =~ /^(\\S+)($self->{fwd_desig})$/;\n\t\t\t}\n\t\t\tif ($self->{rev_desig}) {\n\t\t\t\t$self->{sequences}{$name}{direction} = \"R\" if $name =~ /^(\\S+)($self->{rev_desig})$/;\n\t\t\t}\n\t\t\t$self->{sequences}{$name}{min_clone_len} = $2; # this is used for TIGR Assembler, as are $3 and $4\n\t\t\t$self->{sequences}{$name}{max_clone_len} = $3;\n\t\t\t$self->{sequences}{$name}{med_clone_len} = $4; \n\t\t\t$self->{sequences}{$name}{beg_clear} = $5;\n\t\t\t$self->{sequences}{$name}{end_clear} = $6;\n\t\t\t$self->{sequences}{$name}{length_raw} = $seq =~ tr/[AGCTN]//; # from what I've seen, these are the bases Phred calls.  Please let me know if I'm wrong.     \n\t\t\tmy $beg = $5-1; # substr function begins with index 0\n\t\t\t$seq = $self->{sequences}{$name}{sequence} = substr ($seq, $beg, $6-$beg);\n\t\t\tmy $count = $self->{sequences}{$name}{length_clear} = $seq =~ tr/[AGCTN]//;\n\t\t\tmy $countGC =  $seq =~ tr/[GC]//;\n\t\t\t$self->{sequences}{$name}{per_GC} = $countGC/$count * 100;\n\t\t\t$seq = \"\";\n\t\t}\n\t\telse {\n\t\t\t$seq = $line.$seq;\n\t\t}\n\t}\n\n\t# now parse quality values (check for presence of quality file first) \n\tif ($self->{qualfile}) {\n\t\topen my $QUAL, \"$self->{qualfile}\" or $self->throw(\"Could not open quality file: $self->{qualfile}\");\n\t\t@lines = <$QUAL>;\n\t}\n\telsif (-e \"$file.qual\") {\n\t\t$self->warn(\"You did not set qualfile, but I'm opening $file.qual\\n\") if $self->{lucy_verbose};\n\t$self->qualfile(\"$file.qual\");\n\t\topen my $QUAL, \"$file.qual\" or $self->throw(\"Could not open quality file: $file.qual\");\n\t\t@lines = <$QUAL>;\n\t}\n    else {\n\t\t $self->warn(\"I did not find a quality file.  You will not be able to use all of the accessor methods.\\n\") if $self->{lucy_verbose};\n\t\t @lines = ();\n    }\n\n\tmy (@vals, @slice, $num, $tot, $vals);  \n\tmy $qual = \"\"; \n\twhile ($line = pop @lines) {\n\t\tchomp $line;\n\t\tif ($line =~ /^>(\\S+)/) {\n\t\t\t$name = $1;\n\t\t\t@vals = split /\\s/ , $qual;\n\t\t\t@slice = @vals[$self->{sequences}{$name}{beg_clear} - 1 .. $self->{sequences}{$name}{end_clear} - 1];\n\t\t\t$vals = join \"\\t\", @slice;\n\t\t\t$self->{sequences}{$name}{quality} = $vals;\n\t\t\t$qual = \"\";\n\t\t\tforeach $num (@slice) {\n\t\t\t\t$tot += $num;\n\t\t\t}\n\t\t\t$num = @slice;\n\t\t\t$self->{sequences}{$name}{avg_quality} = $tot/$num;\n\t\t\t$tot = 0;\n\t\t}\n\t\telse {\n\t\t\t$qual = $line.$qual;\n\t\t}\n\t}\n\n\t# determine whether reads are full length\n\tif ($self->{infofile}) {\n\t\topen my $INFO, \"$self->{infofile}\" or $self->throw(\"Could not open info file: $self->{infofile}\");\n\t\t@lines = <$INFO>;\n\t}\n\telsif (-e \"$file.info\") {\n\t\t$self->warn(\"You did not set infofile, but I'm opening $file.info\\n\") if $self->{lucy_verbose};\n\t\t$self->infofile(\"$file.info\");\n\t\topen my $INFO, \"$file.info\" or $self->throw(\"Could not open info file: $file.info\");\n\t\t@lines = <$INFO>;\n\t}\n\telse {\n\t\t$self->warn(\"I did not find an info file.  You will not be able to use all of the accessor methods.\\n\") if $self->{lucy_verbose};\n\t\t@lines = ();\n\t}\n\n\tforeach (@lines) {\n\t\t/^(\\S+).+CLV\\s+(\\d+)\\s+(\\d+)$/;\n\t\tif ($2>0 && $3>0) {\n\t\t\t$self->{sequences}{$1}{full_length} = 1 if $self->{sequences}{$1}; # will show cleavage info for rejected sequences too\n\t\t}\n\t}\n\n\n\t# parse rejects (and presence of poly-A if Lucy has been modified)\n\tif ($self->{stderrfile}) {\n\t\topen my $STDERR_LUCY, \"$self->{stderrfile}\" or $self->throw(\"Could not open quality file: $self->{stderrfile}\");\n\t\t@lines = <$STDERR_LUCY>;\n\t}\n\telsif (-e \"$file.stderr\") {\n\t\t$self->warn(\"You did not set stderrfile, but I'm opening $file.stderr\\n\") if $self->{lucy_verbose};\n\t\t$self->stderrfile(\"$file.stderr\");\n\t\topen my $STDERR_LUCY, \"$file.stderr\" or $self->throw(\"Could not open quality file: $file.stderr\");\n\t\t@lines = <$STDERR_LUCY>;\n\t}\n\telse {\n\t\t$self->warn(\"I did not find a standard error file.  You will not be able to use all of the accessor methods.\\n\") if $self->{lucy_verbose};\n\t\t@lines = ();\n\t}\n\n\tif ($self->{adv_stderr}) {\n\t\tforeach (@lines) {\n\t\t\t$self->{reject}{$1} = \"Q\" if /dropping\\s+(\\S+)/;\n\t\t\t$self->{reject}{$1} = \"V\" if /Vector: (\\S+)/;\n\t\t\t$self->{reject}{$1} = \"E\" if /Empty: (\\S+)/;\n\t\t\t$self->{reject}{$1} = \"S\" if m{Short/ no insert: (\\S+)};\n\t\t\t$self->{sequences}{$1}{polyA} = 1 if /(\\S+) has PolyA/;\n\t\t\tif (/Dropped PolyA: (\\S+)/) {\n\t\t\t\t$self->{reject}{$1} = \"P\";\n\t\t\t\tdelete $self->{sequences}{$1};\n\t\t\t}\n\t\t}\n\t}\n\telse {\n\t\tforeach (@lines) {\n\t\t\t$self->{reject}{$1} = \"R\" if /dropping\\s+(\\S+)/;\n\t\t}\n\t}\n}\n\n=head2 get_Seq_Objs\n\n Title   :  get_Seq_Objs\n Usage   :  $lucyObj->get_Seq_Objs()\n Function:  returns an array of references to Bio::PrimarySeq objects \n\t    where -id = 'sequence name' and -seq = 'sequence'\n\n Returns :  array of Bio::PrimarySeq objects\n Args\t :  none\n\n\nsub get_Seq_Objs {\n    my $self = shift;\n    my($seqobj, @seqobjs);\n    foreach my $key (sort keys %{$self->{sequences}}) {\n\t$seqobj = Bio::PrimarySeq->new( -seq => \"$self->{sequences}{$key}{sequence}\",\n\t\t\t\t\t-id => \"$key\");\n\tpush @seqobjs, $seqobj;\n    }\n    return \\@seqobjs;\n} \n\n=head2 get_Seq_Obj\n\n Title   :  get_Seq_Obj\n Usage   :  $lucyObj->get_Seq_Obj($seqname)\n Function:  returns reference to a Bio::PrimarySeq object where -id = 'sequence name'\n\t    and -seq = 'sequence'\n Returns :  reference to Bio::PrimarySeq object\n Args\t :  name of a sequence \n\n\nsub get_Seq_Obj {\n    my ($self, $key) = @_;\n    my $seqobj = Bio::PrimarySeq->new( -seq => \"$self->{sequences}{$key}{sequence}\",\n                                    -id => \"$key\");\n    return $seqobj;\n}\n\n=head2 get_sequence_names\n\n Title   :  get_sequence_names\n Usage   :  $lucyObj->get_sequence_names\n Function:  returns reference to an array of names of the sequences analyzed by Lucy.\n\t    These names are required for most of the accessor methods.  \n\t    Note: The Lucy binary will fail unless sequence names are unique.\n Returns :  array reference\n Args\t :  none \n\n\nsub get_sequence_names {\n    my $self = shift;\n    my @keys = sort keys %{$self->{sequences}};\n    return \\@keys;\n}\n\n=head2 sequence\n\n Title   :  sequence\n Usage   :  $lucyObj->sequence($seqname)\n Function:  returns the DNA sequence of one of the sequences analyzed by Lucy.\n Returns :  string\n Args\t :  name of a sequence                   \n\n\nsub sequence {\n    my ($self, $key) = @_;\n    return $self->{sequences}{$key}{sequence};\n}\n\n=head2 quality\n\n Title   :  quality\n Usage   :  $lucyObj->quality($seqname)\n Function:  returns the quality values of one of the sequences analyzed by Lucy.\n\t    This method depends on the user having provided a quality file.\n Returns :  string\n Args    :  name of a sequence\n\n\nsub quality {\n    my($self, $key) = @_;\n    return $self->{sequences}{$key}{quality};\n}\n\n=head2 avg_quality\n\n Title   :  avg_quality\n Usage   :  $lucyObj->avg_quality($seqname)\n Function:  returns the average quality value for one of the sequences analyzed by Lucy.\n Returns :  float\n Args    :  name of a sequence\n\n\nsub avg_quality {\n    my($self, $key) = @_;\n    return $self->{sequences}{$key}{avg_quality};\n}\n\n=head2 direction\n\n Title   :  direction\n Usage   :  $lucyObj->direction($seqname)\n Function:  returns the direction for one of the sequences analyzed by Lucy\n\t    providing that 'fwd_desig' or 'rev_desig' were set when the\n \t    Lucy object was created.\n\t    Strings returned are: 'F' for forward, 'R' for reverse.  \n Returns :  string \n Args    :  name of a sequence","parameters":[{"label":"$self"},{"label":"$key"}]},"detail":"($self,$key)","definition":"sub","containerName":"main::","range":{"end":{"line":515,"character":9999},"start":{"character":0,"line":511}},"name":"direction"},{"name":"sequences","line":513,"kind":12},{"name":"direction","kind":12,"line":513},{"name":"sequences","kind":12,"line":513},{"name":"direction","line":513,"kind":12},{"range":{"start":{"character":0,"line":528},"end":{"character":9999,"line":531}},"name":"length_raw","line":528,"children":[{"localvar":"my","containerName":"length_raw","definition":"my","name":"$self","line":529,"kind":13},{"line":529,"kind":13,"name":"$key","containerName":"length_raw"},{"line":530,"kind":13,"containerName":"length_raw","name":"$self"},{"name":"$key","containerName":"length_raw","line":530,"kind":13}],"kind":12,"detail":"($self,$key)","signature":{"documentation":"1;\n# $Id: Lucy.pm 16123 2009-09-17 12:57:27Z cjfields $ \n#\n# BioPerl module for Bio::Tools::Lucy\n#\n# Copyright Her Majesty the Queen of England\n# written by Andrew Walsh (paeruginosa@hotmail.com) during employment with \n# Agriculture and Agri-food Canada, Cereal Research Centre, Winnipeg, MB\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Lucy - Object for analyzing the output from Lucy,\n  a vector and quality trimming program from TIGR\n\n=head1 SYNOPSIS\n\n  # Create the Lucy object from an existing Lucy output file\n  @params = ('seqfile' => 'lucy.seq', 'lucy_verbose' => 1);\n  $lucyObj = Bio::Tools::Lucy->new(@params);\n\n  # Get names of all sequences\n  $names = $lucyObj->get_sequence_names();\n\n  #  Print seq and qual values for sequences >400 bp in order to run CAP3\n  foreach $name (@$names) {\n      next unless $lucyObj->length_clear($name) > 400;\n      print SEQ \">$name\\n\", $lucyObj->sequence($name), \"\\n\";\n      print QUAL \">$name\\n\", $lucyObj->quality($name), \"\\n\";\n  }\n\n  # Get an array of Bio::PrimarySeq objects\n  @seqObjs = $lucyObj->get_Seq_Objs();\n\n\n=head1 DESCRIPTION\n\nBio::Tools::Lucy.pm provides methods for analyzing the sequence and\nquality values generated by Lucy program from TIGR.\n\nLucy will identify vector, poly-A/T tails, and poor quality regions in\na sequence.  (www.genomics.purdue.edu/gcg/other/lucy.pdf)\n\nThe input to Lucy can be the Phred sequence and quality files\ngenerated from running Phred on a set of chromatograms.\n\nLucy can be obtained (free of charge to academic users) from\nwww.tigr.org/softlab\n\nThere are a few methods that will only be available if you make some\nminor changes to the source for Lucy and then recompile.  The changes\nare in the 'lucy.c' file and there is a diff between the original and\nthe modified file in the Appendix\n\nPlease contact the author of this module if you have any problems\nmaking these modifications.\n\nYou do not have to make these modifications to use this module.\n\n=head2 Creating a Lucy object\n\n  @params = ('seqfile' => 'lucy.seq', 'adv_stderr' => 1, \n\t     'fwd_desig' => '_F', 'rev_desig' => '_R');\n  $lucyObj = Bio::Tools::Lucy->new(@params);\n\n=head2 Using a Lucy object\n\n  You should get an array with the sequence names in order to use\n  accessor methods.  Note: The Lucy binary program will fail unless\n  the sequence names provided as input are unique.\n\n  $names_ref = $lucyObj->get_sequence_names();\n\n  This code snippet will produce a Fasta format file with sequence\n  lengths and %GC in the description line.\n\n  foreach $name (@$names) {\n      print FILE \">$name\\t\",\n\t\t $lucyObj->length_clear($name), \"\\t\",\n\t\t $lucyObj->per_GC($name), \"\\n\",\n\t\t $lucyObj->sequence($name), \"\\n\";\n  }\n\n\n  Print seq and qual values for sequences >400 bp in order to assemble\n  them with CAP3 (or other assembler).\n\n  foreach $name (@$names) {\n      next unless $lucyObj->length_clear($name) > 400;\n      print SEQ \">$name\\n\", $lucyObj->sequence($name), \"\\n\";\n      print QUAL \">$name\\n\", $lucyObj->quality($name), \"\\n\";\n  }\n\n  Get all the sequences as Bio::PrimarySeq objects (eg., for use with\n  Bio::Tools::Run::StandaloneBlast to perform BLAST).\n\n  @seqObjs = $lucyObj->get_Seq_Objs();\n\n  Or use only those sequences that are full length and have a Poly-A\n  tail.\n\n  foreach $name (@$names) {\n      next unless ($lucyObj->full_length($name) and $lucy->polyA($name));\n      push @seqObjs, $lucyObj->get_Seq_Obj($name);\n  }\n\n\n  Get the names of those sequences that were rejected by Lucy.\n\n  $rejects_ref = $lucyObj->get_rejects();\n\n  Print the names of the rejects and 1 letter code for reason they\n  were rejected.\n\n  foreach $key (sort keys %$rejects_ref) {\n      print \"$key:  \", $rejects_ref->{$key};\n  }\n\n  There is a lot of other information available about the sequences\n  analyzed by Lucy (see APPENDIX).  This module can be used with the\n  DBI module to store this sequence information in a database.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules.  Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nAndrew G. Walsh\t\tpaeruginosa@hotmail.com\n\n=head1 APPENDIX\n\nMethods available to Lucy objects are described below.  Please note\nthat any method beginning with an underscore is considered internal\nand should not be called directly.\n\n\n\npackage Bio::Tools::Lucy;\n\nuse vars qw($AUTOLOAD @ATTR %OK_FIELD);\nuse strict;\nuse Bio::PrimarySeq;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n@ATTR = qw(seqfile qualfile stderrfile infofile lucy_verbose fwd_desig rev_desig adv_stderr); \nforeach my $attr (@ATTR) {\n    $OK_FIELD{$attr}++\n}\n\nsub AUTOLOAD {\n    my $self = shift;\n    my $attr = $AUTOLOAD;\n    $attr =~ s/.*:://;\n    $attr = lc $attr;\n    $self->throw(\"Unallowed parameter: $attr !\") unless $OK_FIELD{$attr};\n    $self->{$attr} = shift if @_;\n    return $self->{$attr};\n}\n\n=head2 new\n\n Title\t :  new\n Usage\t :  $lucyObj = Bio::Tools::Lucy->new(seqfile => lucy.seq, rev_desig => '_R', \n\t    fwd_desig => '_F')\n Function:  creates a Lucy object from Lucy analysis files\n Returns :  reference to Bio::Tools::Lucy object\n Args\t :  seqfile\tFasta sequence file generated by Lucy\n\t       qualfile\tQuality values file generated by Lucy\n\t       infofile\tInfo file created when Lucy is run with -debug \n                     'infofile' option\n\t       stderrfile\tStandard error captured from Lucy when Lucy is run \n\t\t\t with -info option and STDERR is directed to stderrfile \n\t\t\t (ie. lucy ... 2> stderrfile).\n\t\t\t Info in this file will include sequences dropped for low \n\t\t\t quality. If you've modified Lucy source (see adv_stderr below), \n\t\t\t it will also include info on which sequences were dropped because \n\t\t\t they were vector, too short, had no insert, and whether a poly-A \n\t\t\t tail was found (if Lucy was run with -cdna option).\n\t       lucy_verbose verbosity level (0-1).  \n\t       fwd_desig\tThe string used to determine whether sequence is a \n          forward read.  \n\t\t\t The parser will assume that this match will occus at the \n\t\t\t end of the sequence name string.\n\t       rev_desig\tAs above, for reverse reads. \n \t       adv_stderr\tCan be set to a true value (1).  Will only work if \n          you have modified \n\t\t\t the Lucy source code as outlined in DESCRIPTION and capture \n\t\t\t the standard error from Lucy.\n\nIf you don't provide filenames for qualfile, infofile or stderrfile,\nthe module will assume that .qual, .info, and .stderr are the file\nextensions and search in the same directory as the .seq file for these\nfiles.\n\nFor example, if you create a Lucy object with $lucyObj =\nBio::Tools::Lucy-E<gt>new(seqfile =E<gt>lucy.seq), the module will\nfind lucy.qual, lucy.info and lucy.stderr.\n\nYou can omit any or all of the quality, info or stderr files, but you\nwill not be able to use all of the object methods (see method\ndocumentation below).\n\n\nsub new {\n\tmy ($class,@args) = @_;\n\tmy $self = $class->SUPER::new(@args);\n\tmy ($attr, $value);\n\twhile (@args) {\n\t\t$attr = shift @args;\n\t\t$attr = lc $attr;\n\t\t$value = shift @args;\n\t\t$self->{$attr} = $value;\n\t}\n\t&_parse($self);\n\treturn $self;\n}\n\n=head2 _parse\n\n Title\t :  _parse\n Usage\t :  n/a (internal function)\n Function:  called by new() to parse Lucy output files\n Returns :  nothing\n Args\t :  none\n\n\nsub _parse {\n\tmy $self = shift;\n\t$self->{seqfile} =~ /^(\\S+)\\.\\S+$/;\n\tmy $file = $1;\n\n\t$self->warn(\"Opening $self->{seqfile} for parsing...\\n\") if $self->{lucy_verbose};\n\topen my $SEQ, $self->{seqfile} or $self->throw(\"Could not open sequence file: $self->{seqfile}\");\n\tmy ($name, $line);\n\tmy $seq = \"\";\n\tmy @lines = <$SEQ>;\n\twhile ($line = pop @lines) {\n\t\tchomp $line;\n\t\tif ($line =~ /^>(\\S+)\\s+(\\d+)\\s+(\\d+)\\s+(\\d+)\\s+(\\d+)\\s+(\\d+)/) {    \n\t\t\t$name = $1;\n\t\t\tif ($self->{fwd_desig}) {\n\t\t\t\t$self->{sequences}{$name}{direction} = \"F\" if $name =~ /^(\\S+)($self->{fwd_desig})$/;\n\t\t\t}\n\t\t\tif ($self->{rev_desig}) {\n\t\t\t\t$self->{sequences}{$name}{direction} = \"R\" if $name =~ /^(\\S+)($self->{rev_desig})$/;\n\t\t\t}\n\t\t\t$self->{sequences}{$name}{min_clone_len} = $2; # this is used for TIGR Assembler, as are $3 and $4\n\t\t\t$self->{sequences}{$name}{max_clone_len} = $3;\n\t\t\t$self->{sequences}{$name}{med_clone_len} = $4; \n\t\t\t$self->{sequences}{$name}{beg_clear} = $5;\n\t\t\t$self->{sequences}{$name}{end_clear} = $6;\n\t\t\t$self->{sequences}{$name}{length_raw} = $seq =~ tr/[AGCTN]//; # from what I've seen, these are the bases Phred calls.  Please let me know if I'm wrong.     \n\t\t\tmy $beg = $5-1; # substr function begins with index 0\n\t\t\t$seq = $self->{sequences}{$name}{sequence} = substr ($seq, $beg, $6-$beg);\n\t\t\tmy $count = $self->{sequences}{$name}{length_clear} = $seq =~ tr/[AGCTN]//;\n\t\t\tmy $countGC =  $seq =~ tr/[GC]//;\n\t\t\t$self->{sequences}{$name}{per_GC} = $countGC/$count * 100;\n\t\t\t$seq = \"\";\n\t\t}\n\t\telse {\n\t\t\t$seq = $line.$seq;\n\t\t}\n\t}\n\n\t# now parse quality values (check for presence of quality file first) \n\tif ($self->{qualfile}) {\n\t\topen my $QUAL, \"$self->{qualfile}\" or $self->throw(\"Could not open quality file: $self->{qualfile}\");\n\t\t@lines = <$QUAL>;\n\t}\n\telsif (-e \"$file.qual\") {\n\t\t$self->warn(\"You did not set qualfile, but I'm opening $file.qual\\n\") if $self->{lucy_verbose};\n\t$self->qualfile(\"$file.qual\");\n\t\topen my $QUAL, \"$file.qual\" or $self->throw(\"Could not open quality file: $file.qual\");\n\t\t@lines = <$QUAL>;\n\t}\n    else {\n\t\t $self->warn(\"I did not find a quality file.  You will not be able to use all of the accessor methods.\\n\") if $self->{lucy_verbose};\n\t\t @lines = ();\n    }\n\n\tmy (@vals, @slice, $num, $tot, $vals);  \n\tmy $qual = \"\"; \n\twhile ($line = pop @lines) {\n\t\tchomp $line;\n\t\tif ($line =~ /^>(\\S+)/) {\n\t\t\t$name = $1;\n\t\t\t@vals = split /\\s/ , $qual;\n\t\t\t@slice = @vals[$self->{sequences}{$name}{beg_clear} - 1 .. $self->{sequences}{$name}{end_clear} - 1];\n\t\t\t$vals = join \"\\t\", @slice;\n\t\t\t$self->{sequences}{$name}{quality} = $vals;\n\t\t\t$qual = \"\";\n\t\t\tforeach $num (@slice) {\n\t\t\t\t$tot += $num;\n\t\t\t}\n\t\t\t$num = @slice;\n\t\t\t$self->{sequences}{$name}{avg_quality} = $tot/$num;\n\t\t\t$tot = 0;\n\t\t}\n\t\telse {\n\t\t\t$qual = $line.$qual;\n\t\t}\n\t}\n\n\t# determine whether reads are full length\n\tif ($self->{infofile}) {\n\t\topen my $INFO, \"$self->{infofile}\" or $self->throw(\"Could not open info file: $self->{infofile}\");\n\t\t@lines = <$INFO>;\n\t}\n\telsif (-e \"$file.info\") {\n\t\t$self->warn(\"You did not set infofile, but I'm opening $file.info\\n\") if $self->{lucy_verbose};\n\t\t$self->infofile(\"$file.info\");\n\t\topen my $INFO, \"$file.info\" or $self->throw(\"Could not open info file: $file.info\");\n\t\t@lines = <$INFO>;\n\t}\n\telse {\n\t\t$self->warn(\"I did not find an info file.  You will not be able to use all of the accessor methods.\\n\") if $self->{lucy_verbose};\n\t\t@lines = ();\n\t}\n\n\tforeach (@lines) {\n\t\t/^(\\S+).+CLV\\s+(\\d+)\\s+(\\d+)$/;\n\t\tif ($2>0 && $3>0) {\n\t\t\t$self->{sequences}{$1}{full_length} = 1 if $self->{sequences}{$1}; # will show cleavage info for rejected sequences too\n\t\t}\n\t}\n\n\n\t# parse rejects (and presence of poly-A if Lucy has been modified)\n\tif ($self->{stderrfile}) {\n\t\topen my $STDERR_LUCY, \"$self->{stderrfile}\" or $self->throw(\"Could not open quality file: $self->{stderrfile}\");\n\t\t@lines = <$STDERR_LUCY>;\n\t}\n\telsif (-e \"$file.stderr\") {\n\t\t$self->warn(\"You did not set stderrfile, but I'm opening $file.stderr\\n\") if $self->{lucy_verbose};\n\t\t$self->stderrfile(\"$file.stderr\");\n\t\topen my $STDERR_LUCY, \"$file.stderr\" or $self->throw(\"Could not open quality file: $file.stderr\");\n\t\t@lines = <$STDERR_LUCY>;\n\t}\n\telse {\n\t\t$self->warn(\"I did not find a standard error file.  You will not be able to use all of the accessor methods.\\n\") if $self->{lucy_verbose};\n\t\t@lines = ();\n\t}\n\n\tif ($self->{adv_stderr}) {\n\t\tforeach (@lines) {\n\t\t\t$self->{reject}{$1} = \"Q\" if /dropping\\s+(\\S+)/;\n\t\t\t$self->{reject}{$1} = \"V\" if /Vector: (\\S+)/;\n\t\t\t$self->{reject}{$1} = \"E\" if /Empty: (\\S+)/;\n\t\t\t$self->{reject}{$1} = \"S\" if m{Short/ no insert: (\\S+)};\n\t\t\t$self->{sequences}{$1}{polyA} = 1 if /(\\S+) has PolyA/;\n\t\t\tif (/Dropped PolyA: (\\S+)/) {\n\t\t\t\t$self->{reject}{$1} = \"P\";\n\t\t\t\tdelete $self->{sequences}{$1};\n\t\t\t}\n\t\t}\n\t}\n\telse {\n\t\tforeach (@lines) {\n\t\t\t$self->{reject}{$1} = \"R\" if /dropping\\s+(\\S+)/;\n\t\t}\n\t}\n}\n\n=head2 get_Seq_Objs\n\n Title   :  get_Seq_Objs\n Usage   :  $lucyObj->get_Seq_Objs()\n Function:  returns an array of references to Bio::PrimarySeq objects \n\t    where -id = 'sequence name' and -seq = 'sequence'\n\n Returns :  array of Bio::PrimarySeq objects\n Args\t :  none\n\n\nsub get_Seq_Objs {\n    my $self = shift;\n    my($seqobj, @seqobjs);\n    foreach my $key (sort keys %{$self->{sequences}}) {\n\t$seqobj = Bio::PrimarySeq->new( -seq => \"$self->{sequences}{$key}{sequence}\",\n\t\t\t\t\t-id => \"$key\");\n\tpush @seqobjs, $seqobj;\n    }\n    return \\@seqobjs;\n} \n\n=head2 get_Seq_Obj\n\n Title   :  get_Seq_Obj\n Usage   :  $lucyObj->get_Seq_Obj($seqname)\n Function:  returns reference to a Bio::PrimarySeq object where -id = 'sequence name'\n\t    and -seq = 'sequence'\n Returns :  reference to Bio::PrimarySeq object\n Args\t :  name of a sequence \n\n\nsub get_Seq_Obj {\n    my ($self, $key) = @_;\n    my $seqobj = Bio::PrimarySeq->new( -seq => \"$self->{sequences}{$key}{sequence}\",\n                                    -id => \"$key\");\n    return $seqobj;\n}\n\n=head2 get_sequence_names\n\n Title   :  get_sequence_names\n Usage   :  $lucyObj->get_sequence_names\n Function:  returns reference to an array of names of the sequences analyzed by Lucy.\n\t    These names are required for most of the accessor methods.  \n\t    Note: The Lucy binary will fail unless sequence names are unique.\n Returns :  array reference\n Args\t :  none \n\n\nsub get_sequence_names {\n    my $self = shift;\n    my @keys = sort keys %{$self->{sequences}};\n    return \\@keys;\n}\n\n=head2 sequence\n\n Title   :  sequence\n Usage   :  $lucyObj->sequence($seqname)\n Function:  returns the DNA sequence of one of the sequences analyzed by Lucy.\n Returns :  string\n Args\t :  name of a sequence                   \n\n\nsub sequence {\n    my ($self, $key) = @_;\n    return $self->{sequences}{$key}{sequence};\n}\n\n=head2 quality\n\n Title   :  quality\n Usage   :  $lucyObj->quality($seqname)\n Function:  returns the quality values of one of the sequences analyzed by Lucy.\n\t    This method depends on the user having provided a quality file.\n Returns :  string\n Args    :  name of a sequence\n\n\nsub quality {\n    my($self, $key) = @_;\n    return $self->{sequences}{$key}{quality};\n}\n\n=head2 avg_quality\n\n Title   :  avg_quality\n Usage   :  $lucyObj->avg_quality($seqname)\n Function:  returns the average quality value for one of the sequences analyzed by Lucy.\n Returns :  float\n Args    :  name of a sequence\n\n\nsub avg_quality {\n    my($self, $key) = @_;\n    return $self->{sequences}{$key}{avg_quality};\n}\n\n=head2 direction\n\n Title   :  direction\n Usage   :  $lucyObj->direction($seqname)\n Function:  returns the direction for one of the sequences analyzed by Lucy\n\t    providing that 'fwd_desig' or 'rev_desig' were set when the\n \t    Lucy object was created.\n\t    Strings returned are: 'F' for forward, 'R' for reverse.  \n Returns :  string \n Args    :  name of a sequence\n\n\nsub direction {\n    my($self, $key) = @_;\n    return $self->{sequences}{$key}{direction} if $self->{sequences}{$key}{direction}; \n    return \"\";\n}\n\n=head2 length_raw\n\n Title   :  length_raw\n Usage   :  $lucyObj->length_raw($seqname)\n Function:  returns the length of a DNA sequence prior to quality/ vector \n\t    trimming by Lucy.\n Returns :  integer\n Args    :  name of a sequence","parameters":[{"label":"$self"},{"label":"$key"}],"label":"length_raw($self,$key)"},"containerName":"main::","definition":"sub"},{"line":530,"kind":12,"name":"sequences"},{"name":"length_raw","line":530,"kind":12},{"name":"length_clear","range":{"start":{"character":0,"line":544},"end":{"line":547,"character":9999}},"kind":12,"line":544,"children":[{"line":545,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"length_clear"},{"name":"$key","containerName":"length_clear","line":545,"kind":13},{"name":"$self","containerName":"length_clear","line":546,"kind":13},{"name":"$key","containerName":"length_clear","kind":13,"line":546}],"containerName":"main::","definition":"sub","detail":"($self,$key)","signature":{"documentation":"1;\n# $Id: Lucy.pm 16123 2009-09-17 12:57:27Z cjfields $ \n#\n# BioPerl module for Bio::Tools::Lucy\n#\n# Copyright Her Majesty the Queen of England\n# written by Andrew Walsh (paeruginosa@hotmail.com) during employment with \n# Agriculture and Agri-food Canada, Cereal Research Centre, Winnipeg, MB\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Lucy - Object for analyzing the output from Lucy,\n  a vector and quality trimming program from TIGR\n\n=head1 SYNOPSIS\n\n  # Create the Lucy object from an existing Lucy output file\n  @params = ('seqfile' => 'lucy.seq', 'lucy_verbose' => 1);\n  $lucyObj = Bio::Tools::Lucy->new(@params);\n\n  # Get names of all sequences\n  $names = $lucyObj->get_sequence_names();\n\n  #  Print seq and qual values for sequences >400 bp in order to run CAP3\n  foreach $name (@$names) {\n      next unless $lucyObj->length_clear($name) > 400;\n      print SEQ \">$name\\n\", $lucyObj->sequence($name), \"\\n\";\n      print QUAL \">$name\\n\", $lucyObj->quality($name), \"\\n\";\n  }\n\n  # Get an array of Bio::PrimarySeq objects\n  @seqObjs = $lucyObj->get_Seq_Objs();\n\n\n=head1 DESCRIPTION\n\nBio::Tools::Lucy.pm provides methods for analyzing the sequence and\nquality values generated by Lucy program from TIGR.\n\nLucy will identify vector, poly-A/T tails, and poor quality regions in\na sequence.  (www.genomics.purdue.edu/gcg/other/lucy.pdf)\n\nThe input to Lucy can be the Phred sequence and quality files\ngenerated from running Phred on a set of chromatograms.\n\nLucy can be obtained (free of charge to academic users) from\nwww.tigr.org/softlab\n\nThere are a few methods that will only be available if you make some\nminor changes to the source for Lucy and then recompile.  The changes\nare in the 'lucy.c' file and there is a diff between the original and\nthe modified file in the Appendix\n\nPlease contact the author of this module if you have any problems\nmaking these modifications.\n\nYou do not have to make these modifications to use this module.\n\n=head2 Creating a Lucy object\n\n  @params = ('seqfile' => 'lucy.seq', 'adv_stderr' => 1, \n\t     'fwd_desig' => '_F', 'rev_desig' => '_R');\n  $lucyObj = Bio::Tools::Lucy->new(@params);\n\n=head2 Using a Lucy object\n\n  You should get an array with the sequence names in order to use\n  accessor methods.  Note: The Lucy binary program will fail unless\n  the sequence names provided as input are unique.\n\n  $names_ref = $lucyObj->get_sequence_names();\n\n  This code snippet will produce a Fasta format file with sequence\n  lengths and %GC in the description line.\n\n  foreach $name (@$names) {\n      print FILE \">$name\\t\",\n\t\t $lucyObj->length_clear($name), \"\\t\",\n\t\t $lucyObj->per_GC($name), \"\\n\",\n\t\t $lucyObj->sequence($name), \"\\n\";\n  }\n\n\n  Print seq and qual values for sequences >400 bp in order to assemble\n  them with CAP3 (or other assembler).\n\n  foreach $name (@$names) {\n      next unless $lucyObj->length_clear($name) > 400;\n      print SEQ \">$name\\n\", $lucyObj->sequence($name), \"\\n\";\n      print QUAL \">$name\\n\", $lucyObj->quality($name), \"\\n\";\n  }\n\n  Get all the sequences as Bio::PrimarySeq objects (eg., for use with\n  Bio::Tools::Run::StandaloneBlast to perform BLAST).\n\n  @seqObjs = $lucyObj->get_Seq_Objs();\n\n  Or use only those sequences that are full length and have a Poly-A\n  tail.\n\n  foreach $name (@$names) {\n      next unless ($lucyObj->full_length($name) and $lucy->polyA($name));\n      push @seqObjs, $lucyObj->get_Seq_Obj($name);\n  }\n\n\n  Get the names of those sequences that were rejected by Lucy.\n\n  $rejects_ref = $lucyObj->get_rejects();\n\n  Print the names of the rejects and 1 letter code for reason they\n  were rejected.\n\n  foreach $key (sort keys %$rejects_ref) {\n      print \"$key:  \", $rejects_ref->{$key};\n  }\n\n  There is a lot of other information available about the sequences\n  analyzed by Lucy (see APPENDIX).  This module can be used with the\n  DBI module to store this sequence information in a database.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules.  Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nAndrew G. Walsh\t\tpaeruginosa@hotmail.com\n\n=head1 APPENDIX\n\nMethods available to Lucy objects are described below.  Please note\nthat any method beginning with an underscore is considered internal\nand should not be called directly.\n\n\n\npackage Bio::Tools::Lucy;\n\nuse vars qw($AUTOLOAD @ATTR %OK_FIELD);\nuse strict;\nuse Bio::PrimarySeq;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n@ATTR = qw(seqfile qualfile stderrfile infofile lucy_verbose fwd_desig rev_desig adv_stderr); \nforeach my $attr (@ATTR) {\n    $OK_FIELD{$attr}++\n}\n\nsub AUTOLOAD {\n    my $self = shift;\n    my $attr = $AUTOLOAD;\n    $attr =~ s/.*:://;\n    $attr = lc $attr;\n    $self->throw(\"Unallowed parameter: $attr !\") unless $OK_FIELD{$attr};\n    $self->{$attr} = shift if @_;\n    return $self->{$attr};\n}\n\n=head2 new\n\n Title\t :  new\n Usage\t :  $lucyObj = Bio::Tools::Lucy->new(seqfile => lucy.seq, rev_desig => '_R', \n\t    fwd_desig => '_F')\n Function:  creates a Lucy object from Lucy analysis files\n Returns :  reference to Bio::Tools::Lucy object\n Args\t :  seqfile\tFasta sequence file generated by Lucy\n\t       qualfile\tQuality values file generated by Lucy\n\t       infofile\tInfo file created when Lucy is run with -debug \n                     'infofile' option\n\t       stderrfile\tStandard error captured from Lucy when Lucy is run \n\t\t\t with -info option and STDERR is directed to stderrfile \n\t\t\t (ie. lucy ... 2> stderrfile).\n\t\t\t Info in this file will include sequences dropped for low \n\t\t\t quality. If you've modified Lucy source (see adv_stderr below), \n\t\t\t it will also include info on which sequences were dropped because \n\t\t\t they were vector, too short, had no insert, and whether a poly-A \n\t\t\t tail was found (if Lucy was run with -cdna option).\n\t       lucy_verbose verbosity level (0-1).  \n\t       fwd_desig\tThe string used to determine whether sequence is a \n          forward read.  \n\t\t\t The parser will assume that this match will occus at the \n\t\t\t end of the sequence name string.\n\t       rev_desig\tAs above, for reverse reads. \n \t       adv_stderr\tCan be set to a true value (1).  Will only work if \n          you have modified \n\t\t\t the Lucy source code as outlined in DESCRIPTION and capture \n\t\t\t the standard error from Lucy.\n\nIf you don't provide filenames for qualfile, infofile or stderrfile,\nthe module will assume that .qual, .info, and .stderr are the file\nextensions and search in the same directory as the .seq file for these\nfiles.\n\nFor example, if you create a Lucy object with $lucyObj =\nBio::Tools::Lucy-E<gt>new(seqfile =E<gt>lucy.seq), the module will\nfind lucy.qual, lucy.info and lucy.stderr.\n\nYou can omit any or all of the quality, info or stderr files, but you\nwill not be able to use all of the object methods (see method\ndocumentation below).\n\n\nsub new {\n\tmy ($class,@args) = @_;\n\tmy $self = $class->SUPER::new(@args);\n\tmy ($attr, $value);\n\twhile (@args) {\n\t\t$attr = shift @args;\n\t\t$attr = lc $attr;\n\t\t$value = shift @args;\n\t\t$self->{$attr} = $value;\n\t}\n\t&_parse($self);\n\treturn $self;\n}\n\n=head2 _parse\n\n Title\t :  _parse\n Usage\t :  n/a (internal function)\n Function:  called by new() to parse Lucy output files\n Returns :  nothing\n Args\t :  none\n\n\nsub _parse {\n\tmy $self = shift;\n\t$self->{seqfile} =~ /^(\\S+)\\.\\S+$/;\n\tmy $file = $1;\n\n\t$self->warn(\"Opening $self->{seqfile} for parsing...\\n\") if $self->{lucy_verbose};\n\topen my $SEQ, $self->{seqfile} or $self->throw(\"Could not open sequence file: $self->{seqfile}\");\n\tmy ($name, $line);\n\tmy $seq = \"\";\n\tmy @lines = <$SEQ>;\n\twhile ($line = pop @lines) {\n\t\tchomp $line;\n\t\tif ($line =~ /^>(\\S+)\\s+(\\d+)\\s+(\\d+)\\s+(\\d+)\\s+(\\d+)\\s+(\\d+)/) {    \n\t\t\t$name = $1;\n\t\t\tif ($self->{fwd_desig}) {\n\t\t\t\t$self->{sequences}{$name}{direction} = \"F\" if $name =~ /^(\\S+)($self->{fwd_desig})$/;\n\t\t\t}\n\t\t\tif ($self->{rev_desig}) {\n\t\t\t\t$self->{sequences}{$name}{direction} = \"R\" if $name =~ /^(\\S+)($self->{rev_desig})$/;\n\t\t\t}\n\t\t\t$self->{sequences}{$name}{min_clone_len} = $2; # this is used for TIGR Assembler, as are $3 and $4\n\t\t\t$self->{sequences}{$name}{max_clone_len} = $3;\n\t\t\t$self->{sequences}{$name}{med_clone_len} = $4; \n\t\t\t$self->{sequences}{$name}{beg_clear} = $5;\n\t\t\t$self->{sequences}{$name}{end_clear} = $6;\n\t\t\t$self->{sequences}{$name}{length_raw} = $seq =~ tr/[AGCTN]//; # from what I've seen, these are the bases Phred calls.  Please let me know if I'm wrong.     \n\t\t\tmy $beg = $5-1; # substr function begins with index 0\n\t\t\t$seq = $self->{sequences}{$name}{sequence} = substr ($seq, $beg, $6-$beg);\n\t\t\tmy $count = $self->{sequences}{$name}{length_clear} = $seq =~ tr/[AGCTN]//;\n\t\t\tmy $countGC =  $seq =~ tr/[GC]//;\n\t\t\t$self->{sequences}{$name}{per_GC} = $countGC/$count * 100;\n\t\t\t$seq = \"\";\n\t\t}\n\t\telse {\n\t\t\t$seq = $line.$seq;\n\t\t}\n\t}\n\n\t# now parse quality values (check for presence of quality file first) \n\tif ($self->{qualfile}) {\n\t\topen my $QUAL, \"$self->{qualfile}\" or $self->throw(\"Could not open quality file: $self->{qualfile}\");\n\t\t@lines = <$QUAL>;\n\t}\n\telsif (-e \"$file.qual\") {\n\t\t$self->warn(\"You did not set qualfile, but I'm opening $file.qual\\n\") if $self->{lucy_verbose};\n\t$self->qualfile(\"$file.qual\");\n\t\topen my $QUAL, \"$file.qual\" or $self->throw(\"Could not open quality file: $file.qual\");\n\t\t@lines = <$QUAL>;\n\t}\n    else {\n\t\t $self->warn(\"I did not find a quality file.  You will not be able to use all of the accessor methods.\\n\") if $self->{lucy_verbose};\n\t\t @lines = ();\n    }\n\n\tmy (@vals, @slice, $num, $tot, $vals);  \n\tmy $qual = \"\"; \n\twhile ($line = pop @lines) {\n\t\tchomp $line;\n\t\tif ($line =~ /^>(\\S+)/) {\n\t\t\t$name = $1;\n\t\t\t@vals = split /\\s/ , $qual;\n\t\t\t@slice = @vals[$self->{sequences}{$name}{beg_clear} - 1 .. $self->{sequences}{$name}{end_clear} - 1];\n\t\t\t$vals = join \"\\t\", @slice;\n\t\t\t$self->{sequences}{$name}{quality} = $vals;\n\t\t\t$qual = \"\";\n\t\t\tforeach $num (@slice) {\n\t\t\t\t$tot += $num;\n\t\t\t}\n\t\t\t$num = @slice;\n\t\t\t$self->{sequences}{$name}{avg_quality} = $tot/$num;\n\t\t\t$tot = 0;\n\t\t}\n\t\telse {\n\t\t\t$qual = $line.$qual;\n\t\t}\n\t}\n\n\t# determine whether reads are full length\n\tif ($self->{infofile}) {\n\t\topen my $INFO, \"$self->{infofile}\" or $self->throw(\"Could not open info file: $self->{infofile}\");\n\t\t@lines = <$INFO>;\n\t}\n\telsif (-e \"$file.info\") {\n\t\t$self->warn(\"You did not set infofile, but I'm opening $file.info\\n\") if $self->{lucy_verbose};\n\t\t$self->infofile(\"$file.info\");\n\t\topen my $INFO, \"$file.info\" or $self->throw(\"Could not open info file: $file.info\");\n\t\t@lines = <$INFO>;\n\t}\n\telse {\n\t\t$self->warn(\"I did not find an info file.  You will not be able to use all of the accessor methods.\\n\") if $self->{lucy_verbose};\n\t\t@lines = ();\n\t}\n\n\tforeach (@lines) {\n\t\t/^(\\S+).+CLV\\s+(\\d+)\\s+(\\d+)$/;\n\t\tif ($2>0 && $3>0) {\n\t\t\t$self->{sequences}{$1}{full_length} = 1 if $self->{sequences}{$1}; # will show cleavage info for rejected sequences too\n\t\t}\n\t}\n\n\n\t# parse rejects (and presence of poly-A if Lucy has been modified)\n\tif ($self->{stderrfile}) {\n\t\topen my $STDERR_LUCY, \"$self->{stderrfile}\" or $self->throw(\"Could not open quality file: $self->{stderrfile}\");\n\t\t@lines = <$STDERR_LUCY>;\n\t}\n\telsif (-e \"$file.stderr\") {\n\t\t$self->warn(\"You did not set stderrfile, but I'm opening $file.stderr\\n\") if $self->{lucy_verbose};\n\t\t$self->stderrfile(\"$file.stderr\");\n\t\topen my $STDERR_LUCY, \"$file.stderr\" or $self->throw(\"Could not open quality file: $file.stderr\");\n\t\t@lines = <$STDERR_LUCY>;\n\t}\n\telse {\n\t\t$self->warn(\"I did not find a standard error file.  You will not be able to use all of the accessor methods.\\n\") if $self->{lucy_verbose};\n\t\t@lines = ();\n\t}\n\n\tif ($self->{adv_stderr}) {\n\t\tforeach (@lines) {\n\t\t\t$self->{reject}{$1} = \"Q\" if /dropping\\s+(\\S+)/;\n\t\t\t$self->{reject}{$1} = \"V\" if /Vector: (\\S+)/;\n\t\t\t$self->{reject}{$1} = \"E\" if /Empty: (\\S+)/;\n\t\t\t$self->{reject}{$1} = \"S\" if m{Short/ no insert: (\\S+)};\n\t\t\t$self->{sequences}{$1}{polyA} = 1 if /(\\S+) has PolyA/;\n\t\t\tif (/Dropped PolyA: (\\S+)/) {\n\t\t\t\t$self->{reject}{$1} = \"P\";\n\t\t\t\tdelete $self->{sequences}{$1};\n\t\t\t}\n\t\t}\n\t}\n\telse {\n\t\tforeach (@lines) {\n\t\t\t$self->{reject}{$1} = \"R\" if /dropping\\s+(\\S+)/;\n\t\t}\n\t}\n}\n\n=head2 get_Seq_Objs\n\n Title   :  get_Seq_Objs\n Usage   :  $lucyObj->get_Seq_Objs()\n Function:  returns an array of references to Bio::PrimarySeq objects \n\t    where -id = 'sequence name' and -seq = 'sequence'\n\n Returns :  array of Bio::PrimarySeq objects\n Args\t :  none\n\n\nsub get_Seq_Objs {\n    my $self = shift;\n    my($seqobj, @seqobjs);\n    foreach my $key (sort keys %{$self->{sequences}}) {\n\t$seqobj = Bio::PrimarySeq->new( -seq => \"$self->{sequences}{$key}{sequence}\",\n\t\t\t\t\t-id => \"$key\");\n\tpush @seqobjs, $seqobj;\n    }\n    return \\@seqobjs;\n} \n\n=head2 get_Seq_Obj\n\n Title   :  get_Seq_Obj\n Usage   :  $lucyObj->get_Seq_Obj($seqname)\n Function:  returns reference to a Bio::PrimarySeq object where -id = 'sequence name'\n\t    and -seq = 'sequence'\n Returns :  reference to Bio::PrimarySeq object\n Args\t :  name of a sequence \n\n\nsub get_Seq_Obj {\n    my ($self, $key) = @_;\n    my $seqobj = Bio::PrimarySeq->new( -seq => \"$self->{sequences}{$key}{sequence}\",\n                                    -id => \"$key\");\n    return $seqobj;\n}\n\n=head2 get_sequence_names\n\n Title   :  get_sequence_names\n Usage   :  $lucyObj->get_sequence_names\n Function:  returns reference to an array of names of the sequences analyzed by Lucy.\n\t    These names are required for most of the accessor methods.  \n\t    Note: The Lucy binary will fail unless sequence names are unique.\n Returns :  array reference\n Args\t :  none \n\n\nsub get_sequence_names {\n    my $self = shift;\n    my @keys = sort keys %{$self->{sequences}};\n    return \\@keys;\n}\n\n=head2 sequence\n\n Title   :  sequence\n Usage   :  $lucyObj->sequence($seqname)\n Function:  returns the DNA sequence of one of the sequences analyzed by Lucy.\n Returns :  string\n Args\t :  name of a sequence                   \n\n\nsub sequence {\n    my ($self, $key) = @_;\n    return $self->{sequences}{$key}{sequence};\n}\n\n=head2 quality\n\n Title   :  quality\n Usage   :  $lucyObj->quality($seqname)\n Function:  returns the quality values of one of the sequences analyzed by Lucy.\n\t    This method depends on the user having provided a quality file.\n Returns :  string\n Args    :  name of a sequence\n\n\nsub quality {\n    my($self, $key) = @_;\n    return $self->{sequences}{$key}{quality};\n}\n\n=head2 avg_quality\n\n Title   :  avg_quality\n Usage   :  $lucyObj->avg_quality($seqname)\n Function:  returns the average quality value for one of the sequences analyzed by Lucy.\n Returns :  float\n Args    :  name of a sequence\n\n\nsub avg_quality {\n    my($self, $key) = @_;\n    return $self->{sequences}{$key}{avg_quality};\n}\n\n=head2 direction\n\n Title   :  direction\n Usage   :  $lucyObj->direction($seqname)\n Function:  returns the direction for one of the sequences analyzed by Lucy\n\t    providing that 'fwd_desig' or 'rev_desig' were set when the\n \t    Lucy object was created.\n\t    Strings returned are: 'F' for forward, 'R' for reverse.  \n Returns :  string \n Args    :  name of a sequence\n\n\nsub direction {\n    my($self, $key) = @_;\n    return $self->{sequences}{$key}{direction} if $self->{sequences}{$key}{direction}; \n    return \"\";\n}\n\n=head2 length_raw\n\n Title   :  length_raw\n Usage   :  $lucyObj->length_raw($seqname)\n Function:  returns the length of a DNA sequence prior to quality/ vector \n\t    trimming by Lucy.\n Returns :  integer\n Args    :  name of a sequence\n\n\nsub length_raw {\n    my($self, $key) = @_;\n    return $self->{sequences}{$key}{length_raw};\n}\n\n=head2 length_clear\n\n Title   :  length_clear\n Usage   :  $lucyObj->length_clear($seqname)\n Function:  returns the length of a DNA sequence following quality/ vector   \n            trimming by Lucy.\n Returns :  integer\n Args    :  name of a sequence","parameters":[{"label":"$self"},{"label":"$key"}],"label":"length_clear($self,$key)"}},{"line":546,"kind":12,"name":"sequences"},{"name":"length_clear","line":546,"kind":12},{"range":{"start":{"line":560,"character":0},"end":{"line":563,"character":9999}},"name":"start_clear","line":560,"children":[{"containerName":"start_clear","name":"$self","definition":"my","localvar":"my","kind":13,"line":561},{"name":"$key","containerName":"start_clear","kind":13,"line":561},{"kind":13,"line":562,"name":"$self","containerName":"start_clear"},{"kind":13,"line":562,"name":"$key","containerName":"start_clear"}],"kind":12,"detail":"($self,$key)","signature":{"documentation":"1;\n# $Id: Lucy.pm 16123 2009-09-17 12:57:27Z cjfields $ \n#\n# BioPerl module for Bio::Tools::Lucy\n#\n# Copyright Her Majesty the Queen of England\n# written by Andrew Walsh (paeruginosa@hotmail.com) during employment with \n# Agriculture and Agri-food Canada, Cereal Research Centre, Winnipeg, MB\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Lucy - Object for analyzing the output from Lucy,\n  a vector and quality trimming program from TIGR\n\n=head1 SYNOPSIS\n\n  # Create the Lucy object from an existing Lucy output file\n  @params = ('seqfile' => 'lucy.seq', 'lucy_verbose' => 1);\n  $lucyObj = Bio::Tools::Lucy->new(@params);\n\n  # Get names of all sequences\n  $names = $lucyObj->get_sequence_names();\n\n  #  Print seq and qual values for sequences >400 bp in order to run CAP3\n  foreach $name (@$names) {\n      next unless $lucyObj->length_clear($name) > 400;\n      print SEQ \">$name\\n\", $lucyObj->sequence($name), \"\\n\";\n      print QUAL \">$name\\n\", $lucyObj->quality($name), \"\\n\";\n  }\n\n  # Get an array of Bio::PrimarySeq objects\n  @seqObjs = $lucyObj->get_Seq_Objs();\n\n\n=head1 DESCRIPTION\n\nBio::Tools::Lucy.pm provides methods for analyzing the sequence and\nquality values generated by Lucy program from TIGR.\n\nLucy will identify vector, poly-A/T tails, and poor quality regions in\na sequence.  (www.genomics.purdue.edu/gcg/other/lucy.pdf)\n\nThe input to Lucy can be the Phred sequence and quality files\ngenerated from running Phred on a set of chromatograms.\n\nLucy can be obtained (free of charge to academic users) from\nwww.tigr.org/softlab\n\nThere are a few methods that will only be available if you make some\nminor changes to the source for Lucy and then recompile.  The changes\nare in the 'lucy.c' file and there is a diff between the original and\nthe modified file in the Appendix\n\nPlease contact the author of this module if you have any problems\nmaking these modifications.\n\nYou do not have to make these modifications to use this module.\n\n=head2 Creating a Lucy object\n\n  @params = ('seqfile' => 'lucy.seq', 'adv_stderr' => 1, \n\t     'fwd_desig' => '_F', 'rev_desig' => '_R');\n  $lucyObj = Bio::Tools::Lucy->new(@params);\n\n=head2 Using a Lucy object\n\n  You should get an array with the sequence names in order to use\n  accessor methods.  Note: The Lucy binary program will fail unless\n  the sequence names provided as input are unique.\n\n  $names_ref = $lucyObj->get_sequence_names();\n\n  This code snippet will produce a Fasta format file with sequence\n  lengths and %GC in the description line.\n\n  foreach $name (@$names) {\n      print FILE \">$name\\t\",\n\t\t $lucyObj->length_clear($name), \"\\t\",\n\t\t $lucyObj->per_GC($name), \"\\n\",\n\t\t $lucyObj->sequence($name), \"\\n\";\n  }\n\n\n  Print seq and qual values for sequences >400 bp in order to assemble\n  them with CAP3 (or other assembler).\n\n  foreach $name (@$names) {\n      next unless $lucyObj->length_clear($name) > 400;\n      print SEQ \">$name\\n\", $lucyObj->sequence($name), \"\\n\";\n      print QUAL \">$name\\n\", $lucyObj->quality($name), \"\\n\";\n  }\n\n  Get all the sequences as Bio::PrimarySeq objects (eg., for use with\n  Bio::Tools::Run::StandaloneBlast to perform BLAST).\n\n  @seqObjs = $lucyObj->get_Seq_Objs();\n\n  Or use only those sequences that are full length and have a Poly-A\n  tail.\n\n  foreach $name (@$names) {\n      next unless ($lucyObj->full_length($name) and $lucy->polyA($name));\n      push @seqObjs, $lucyObj->get_Seq_Obj($name);\n  }\n\n\n  Get the names of those sequences that were rejected by Lucy.\n\n  $rejects_ref = $lucyObj->get_rejects();\n\n  Print the names of the rejects and 1 letter code for reason they\n  were rejected.\n\n  foreach $key (sort keys %$rejects_ref) {\n      print \"$key:  \", $rejects_ref->{$key};\n  }\n\n  There is a lot of other information available about the sequences\n  analyzed by Lucy (see APPENDIX).  This module can be used with the\n  DBI module to store this sequence information in a database.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules.  Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nAndrew G. Walsh\t\tpaeruginosa@hotmail.com\n\n=head1 APPENDIX\n\nMethods available to Lucy objects are described below.  Please note\nthat any method beginning with an underscore is considered internal\nand should not be called directly.\n\n\n\npackage Bio::Tools::Lucy;\n\nuse vars qw($AUTOLOAD @ATTR %OK_FIELD);\nuse strict;\nuse Bio::PrimarySeq;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n@ATTR = qw(seqfile qualfile stderrfile infofile lucy_verbose fwd_desig rev_desig adv_stderr); \nforeach my $attr (@ATTR) {\n    $OK_FIELD{$attr}++\n}\n\nsub AUTOLOAD {\n    my $self = shift;\n    my $attr = $AUTOLOAD;\n    $attr =~ s/.*:://;\n    $attr = lc $attr;\n    $self->throw(\"Unallowed parameter: $attr !\") unless $OK_FIELD{$attr};\n    $self->{$attr} = shift if @_;\n    return $self->{$attr};\n}\n\n=head2 new\n\n Title\t :  new\n Usage\t :  $lucyObj = Bio::Tools::Lucy->new(seqfile => lucy.seq, rev_desig => '_R', \n\t    fwd_desig => '_F')\n Function:  creates a Lucy object from Lucy analysis files\n Returns :  reference to Bio::Tools::Lucy object\n Args\t :  seqfile\tFasta sequence file generated by Lucy\n\t       qualfile\tQuality values file generated by Lucy\n\t       infofile\tInfo file created when Lucy is run with -debug \n                     'infofile' option\n\t       stderrfile\tStandard error captured from Lucy when Lucy is run \n\t\t\t with -info option and STDERR is directed to stderrfile \n\t\t\t (ie. lucy ... 2> stderrfile).\n\t\t\t Info in this file will include sequences dropped for low \n\t\t\t quality. If you've modified Lucy source (see adv_stderr below), \n\t\t\t it will also include info on which sequences were dropped because \n\t\t\t they were vector, too short, had no insert, and whether a poly-A \n\t\t\t tail was found (if Lucy was run with -cdna option).\n\t       lucy_verbose verbosity level (0-1).  \n\t       fwd_desig\tThe string used to determine whether sequence is a \n          forward read.  \n\t\t\t The parser will assume that this match will occus at the \n\t\t\t end of the sequence name string.\n\t       rev_desig\tAs above, for reverse reads. \n \t       adv_stderr\tCan be set to a true value (1).  Will only work if \n          you have modified \n\t\t\t the Lucy source code as outlined in DESCRIPTION and capture \n\t\t\t the standard error from Lucy.\n\nIf you don't provide filenames for qualfile, infofile or stderrfile,\nthe module will assume that .qual, .info, and .stderr are the file\nextensions and search in the same directory as the .seq file for these\nfiles.\n\nFor example, if you create a Lucy object with $lucyObj =\nBio::Tools::Lucy-E<gt>new(seqfile =E<gt>lucy.seq), the module will\nfind lucy.qual, lucy.info and lucy.stderr.\n\nYou can omit any or all of the quality, info or stderr files, but you\nwill not be able to use all of the object methods (see method\ndocumentation below).\n\n\nsub new {\n\tmy ($class,@args) = @_;\n\tmy $self = $class->SUPER::new(@args);\n\tmy ($attr, $value);\n\twhile (@args) {\n\t\t$attr = shift @args;\n\t\t$attr = lc $attr;\n\t\t$value = shift @args;\n\t\t$self->{$attr} = $value;\n\t}\n\t&_parse($self);\n\treturn $self;\n}\n\n=head2 _parse\n\n Title\t :  _parse\n Usage\t :  n/a (internal function)\n Function:  called by new() to parse Lucy output files\n Returns :  nothing\n Args\t :  none\n\n\nsub _parse {\n\tmy $self = shift;\n\t$self->{seqfile} =~ /^(\\S+)\\.\\S+$/;\n\tmy $file = $1;\n\n\t$self->warn(\"Opening $self->{seqfile} for parsing...\\n\") if $self->{lucy_verbose};\n\topen my $SEQ, $self->{seqfile} or $self->throw(\"Could not open sequence file: $self->{seqfile}\");\n\tmy ($name, $line);\n\tmy $seq = \"\";\n\tmy @lines = <$SEQ>;\n\twhile ($line = pop @lines) {\n\t\tchomp $line;\n\t\tif ($line =~ /^>(\\S+)\\s+(\\d+)\\s+(\\d+)\\s+(\\d+)\\s+(\\d+)\\s+(\\d+)/) {    \n\t\t\t$name = $1;\n\t\t\tif ($self->{fwd_desig}) {\n\t\t\t\t$self->{sequences}{$name}{direction} = \"F\" if $name =~ /^(\\S+)($self->{fwd_desig})$/;\n\t\t\t}\n\t\t\tif ($self->{rev_desig}) {\n\t\t\t\t$self->{sequences}{$name}{direction} = \"R\" if $name =~ /^(\\S+)($self->{rev_desig})$/;\n\t\t\t}\n\t\t\t$self->{sequences}{$name}{min_clone_len} = $2; # this is used for TIGR Assembler, as are $3 and $4\n\t\t\t$self->{sequences}{$name}{max_clone_len} = $3;\n\t\t\t$self->{sequences}{$name}{med_clone_len} = $4; \n\t\t\t$self->{sequences}{$name}{beg_clear} = $5;\n\t\t\t$self->{sequences}{$name}{end_clear} = $6;\n\t\t\t$self->{sequences}{$name}{length_raw} = $seq =~ tr/[AGCTN]//; # from what I've seen, these are the bases Phred calls.  Please let me know if I'm wrong.     \n\t\t\tmy $beg = $5-1; # substr function begins with index 0\n\t\t\t$seq = $self->{sequences}{$name}{sequence} = substr ($seq, $beg, $6-$beg);\n\t\t\tmy $count = $self->{sequences}{$name}{length_clear} = $seq =~ tr/[AGCTN]//;\n\t\t\tmy $countGC =  $seq =~ tr/[GC]//;\n\t\t\t$self->{sequences}{$name}{per_GC} = $countGC/$count * 100;\n\t\t\t$seq = \"\";\n\t\t}\n\t\telse {\n\t\t\t$seq = $line.$seq;\n\t\t}\n\t}\n\n\t# now parse quality values (check for presence of quality file first) \n\tif ($self->{qualfile}) {\n\t\topen my $QUAL, \"$self->{qualfile}\" or $self->throw(\"Could not open quality file: $self->{qualfile}\");\n\t\t@lines = <$QUAL>;\n\t}\n\telsif (-e \"$file.qual\") {\n\t\t$self->warn(\"You did not set qualfile, but I'm opening $file.qual\\n\") if $self->{lucy_verbose};\n\t$self->qualfile(\"$file.qual\");\n\t\topen my $QUAL, \"$file.qual\" or $self->throw(\"Could not open quality file: $file.qual\");\n\t\t@lines = <$QUAL>;\n\t}\n    else {\n\t\t $self->warn(\"I did not find a quality file.  You will not be able to use all of the accessor methods.\\n\") if $self->{lucy_verbose};\n\t\t @lines = ();\n    }\n\n\tmy (@vals, @slice, $num, $tot, $vals);  \n\tmy $qual = \"\"; \n\twhile ($line = pop @lines) {\n\t\tchomp $line;\n\t\tif ($line =~ /^>(\\S+)/) {\n\t\t\t$name = $1;\n\t\t\t@vals = split /\\s/ , $qual;\n\t\t\t@slice = @vals[$self->{sequences}{$name}{beg_clear} - 1 .. $self->{sequences}{$name}{end_clear} - 1];\n\t\t\t$vals = join \"\\t\", @slice;\n\t\t\t$self->{sequences}{$name}{quality} = $vals;\n\t\t\t$qual = \"\";\n\t\t\tforeach $num (@slice) {\n\t\t\t\t$tot += $num;\n\t\t\t}\n\t\t\t$num = @slice;\n\t\t\t$self->{sequences}{$name}{avg_quality} = $tot/$num;\n\t\t\t$tot = 0;\n\t\t}\n\t\telse {\n\t\t\t$qual = $line.$qual;\n\t\t}\n\t}\n\n\t# determine whether reads are full length\n\tif ($self->{infofile}) {\n\t\topen my $INFO, \"$self->{infofile}\" or $self->throw(\"Could not open info file: $self->{infofile}\");\n\t\t@lines = <$INFO>;\n\t}\n\telsif (-e \"$file.info\") {\n\t\t$self->warn(\"You did not set infofile, but I'm opening $file.info\\n\") if $self->{lucy_verbose};\n\t\t$self->infofile(\"$file.info\");\n\t\topen my $INFO, \"$file.info\" or $self->throw(\"Could not open info file: $file.info\");\n\t\t@lines = <$INFO>;\n\t}\n\telse {\n\t\t$self->warn(\"I did not find an info file.  You will not be able to use all of the accessor methods.\\n\") if $self->{lucy_verbose};\n\t\t@lines = ();\n\t}\n\n\tforeach (@lines) {\n\t\t/^(\\S+).+CLV\\s+(\\d+)\\s+(\\d+)$/;\n\t\tif ($2>0 && $3>0) {\n\t\t\t$self->{sequences}{$1}{full_length} = 1 if $self->{sequences}{$1}; # will show cleavage info for rejected sequences too\n\t\t}\n\t}\n\n\n\t# parse rejects (and presence of poly-A if Lucy has been modified)\n\tif ($self->{stderrfile}) {\n\t\topen my $STDERR_LUCY, \"$self->{stderrfile}\" or $self->throw(\"Could not open quality file: $self->{stderrfile}\");\n\t\t@lines = <$STDERR_LUCY>;\n\t}\n\telsif (-e \"$file.stderr\") {\n\t\t$self->warn(\"You did not set stderrfile, but I'm opening $file.stderr\\n\") if $self->{lucy_verbose};\n\t\t$self->stderrfile(\"$file.stderr\");\n\t\topen my $STDERR_LUCY, \"$file.stderr\" or $self->throw(\"Could not open quality file: $file.stderr\");\n\t\t@lines = <$STDERR_LUCY>;\n\t}\n\telse {\n\t\t$self->warn(\"I did not find a standard error file.  You will not be able to use all of the accessor methods.\\n\") if $self->{lucy_verbose};\n\t\t@lines = ();\n\t}\n\n\tif ($self->{adv_stderr}) {\n\t\tforeach (@lines) {\n\t\t\t$self->{reject}{$1} = \"Q\" if /dropping\\s+(\\S+)/;\n\t\t\t$self->{reject}{$1} = \"V\" if /Vector: (\\S+)/;\n\t\t\t$self->{reject}{$1} = \"E\" if /Empty: (\\S+)/;\n\t\t\t$self->{reject}{$1} = \"S\" if m{Short/ no insert: (\\S+)};\n\t\t\t$self->{sequences}{$1}{polyA} = 1 if /(\\S+) has PolyA/;\n\t\t\tif (/Dropped PolyA: (\\S+)/) {\n\t\t\t\t$self->{reject}{$1} = \"P\";\n\t\t\t\tdelete $self->{sequences}{$1};\n\t\t\t}\n\t\t}\n\t}\n\telse {\n\t\tforeach (@lines) {\n\t\t\t$self->{reject}{$1} = \"R\" if /dropping\\s+(\\S+)/;\n\t\t}\n\t}\n}\n\n=head2 get_Seq_Objs\n\n Title   :  get_Seq_Objs\n Usage   :  $lucyObj->get_Seq_Objs()\n Function:  returns an array of references to Bio::PrimarySeq objects \n\t    where -id = 'sequence name' and -seq = 'sequence'\n\n Returns :  array of Bio::PrimarySeq objects\n Args\t :  none\n\n\nsub get_Seq_Objs {\n    my $self = shift;\n    my($seqobj, @seqobjs);\n    foreach my $key (sort keys %{$self->{sequences}}) {\n\t$seqobj = Bio::PrimarySeq->new( -seq => \"$self->{sequences}{$key}{sequence}\",\n\t\t\t\t\t-id => \"$key\");\n\tpush @seqobjs, $seqobj;\n    }\n    return \\@seqobjs;\n} \n\n=head2 get_Seq_Obj\n\n Title   :  get_Seq_Obj\n Usage   :  $lucyObj->get_Seq_Obj($seqname)\n Function:  returns reference to a Bio::PrimarySeq object where -id = 'sequence name'\n\t    and -seq = 'sequence'\n Returns :  reference to Bio::PrimarySeq object\n Args\t :  name of a sequence \n\n\nsub get_Seq_Obj {\n    my ($self, $key) = @_;\n    my $seqobj = Bio::PrimarySeq->new( -seq => \"$self->{sequences}{$key}{sequence}\",\n                                    -id => \"$key\");\n    return $seqobj;\n}\n\n=head2 get_sequence_names\n\n Title   :  get_sequence_names\n Usage   :  $lucyObj->get_sequence_names\n Function:  returns reference to an array of names of the sequences analyzed by Lucy.\n\t    These names are required for most of the accessor methods.  \n\t    Note: The Lucy binary will fail unless sequence names are unique.\n Returns :  array reference\n Args\t :  none \n\n\nsub get_sequence_names {\n    my $self = shift;\n    my @keys = sort keys %{$self->{sequences}};\n    return \\@keys;\n}\n\n=head2 sequence\n\n Title   :  sequence\n Usage   :  $lucyObj->sequence($seqname)\n Function:  returns the DNA sequence of one of the sequences analyzed by Lucy.\n Returns :  string\n Args\t :  name of a sequence                   \n\n\nsub sequence {\n    my ($self, $key) = @_;\n    return $self->{sequences}{$key}{sequence};\n}\n\n=head2 quality\n\n Title   :  quality\n Usage   :  $lucyObj->quality($seqname)\n Function:  returns the quality values of one of the sequences analyzed by Lucy.\n\t    This method depends on the user having provided a quality file.\n Returns :  string\n Args    :  name of a sequence\n\n\nsub quality {\n    my($self, $key) = @_;\n    return $self->{sequences}{$key}{quality};\n}\n\n=head2 avg_quality\n\n Title   :  avg_quality\n Usage   :  $lucyObj->avg_quality($seqname)\n Function:  returns the average quality value for one of the sequences analyzed by Lucy.\n Returns :  float\n Args    :  name of a sequence\n\n\nsub avg_quality {\n    my($self, $key) = @_;\n    return $self->{sequences}{$key}{avg_quality};\n}\n\n=head2 direction\n\n Title   :  direction\n Usage   :  $lucyObj->direction($seqname)\n Function:  returns the direction for one of the sequences analyzed by Lucy\n\t    providing that 'fwd_desig' or 'rev_desig' were set when the\n \t    Lucy object was created.\n\t    Strings returned are: 'F' for forward, 'R' for reverse.  \n Returns :  string \n Args    :  name of a sequence\n\n\nsub direction {\n    my($self, $key) = @_;\n    return $self->{sequences}{$key}{direction} if $self->{sequences}{$key}{direction}; \n    return \"\";\n}\n\n=head2 length_raw\n\n Title   :  length_raw\n Usage   :  $lucyObj->length_raw($seqname)\n Function:  returns the length of a DNA sequence prior to quality/ vector \n\t    trimming by Lucy.\n Returns :  integer\n Args    :  name of a sequence\n\n\nsub length_raw {\n    my($self, $key) = @_;\n    return $self->{sequences}{$key}{length_raw};\n}\n\n=head2 length_clear\n\n Title   :  length_clear\n Usage   :  $lucyObj->length_clear($seqname)\n Function:  returns the length of a DNA sequence following quality/ vector   \n            trimming by Lucy.\n Returns :  integer\n Args    :  name of a sequence\n\n\nsub length_clear {\n    my($self, $key) = @_;\n    return $self->{sequences}{$key}{length_clear};\n}\n\n=head2 start_clear\n\n Title   :  start_clear\n Usage   :  $lucyObj->start_clear($seqname)\n Function:  returns the beginning position of good quality, vector free DNA sequence \n\t    determined by Lucy.\n Returns :  integer\n Args    :  name of a sequence","parameters":[{"label":"$self"},{"label":"$key"}],"label":"start_clear($self,$key)"},"containerName":"main::","definition":"sub"},{"name":"sequences","kind":12,"line":562},{"kind":12,"line":562,"name":"beg_clear"},{"range":{"end":{"line":580,"character":9999},"start":{"character":0,"line":577}},"name":"end_clear","children":[{"localvar":"my","definition":"my","name":"$self","containerName":"end_clear","line":578,"kind":13},{"containerName":"end_clear","name":"$key","kind":13,"line":578},{"kind":13,"line":579,"name":"$self","containerName":"end_clear"},{"containerName":"end_clear","name":"$key","line":579,"kind":13}],"line":577,"kind":12,"signature":{"label":"end_clear($self,$key)","parameters":[{"label":"$self"},{"label":"$key"}],"documentation":"1;\n# $Id: Lucy.pm 16123 2009-09-17 12:57:27Z cjfields $ \n#\n# BioPerl module for Bio::Tools::Lucy\n#\n# Copyright Her Majesty the Queen of England\n# written by Andrew Walsh (paeruginosa@hotmail.com) during employment with \n# Agriculture and Agri-food Canada, Cereal Research Centre, Winnipeg, MB\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Lucy - Object for analyzing the output from Lucy,\n  a vector and quality trimming program from TIGR\n\n=head1 SYNOPSIS\n\n  # Create the Lucy object from an existing Lucy output file\n  @params = ('seqfile' => 'lucy.seq', 'lucy_verbose' => 1);\n  $lucyObj = Bio::Tools::Lucy->new(@params);\n\n  # Get names of all sequences\n  $names = $lucyObj->get_sequence_names();\n\n  #  Print seq and qual values for sequences >400 bp in order to run CAP3\n  foreach $name (@$names) {\n      next unless $lucyObj->length_clear($name) > 400;\n      print SEQ \">$name\\n\", $lucyObj->sequence($name), \"\\n\";\n      print QUAL \">$name\\n\", $lucyObj->quality($name), \"\\n\";\n  }\n\n  # Get an array of Bio::PrimarySeq objects\n  @seqObjs = $lucyObj->get_Seq_Objs();\n\n\n=head1 DESCRIPTION\n\nBio::Tools::Lucy.pm provides methods for analyzing the sequence and\nquality values generated by Lucy program from TIGR.\n\nLucy will identify vector, poly-A/T tails, and poor quality regions in\na sequence.  (www.genomics.purdue.edu/gcg/other/lucy.pdf)\n\nThe input to Lucy can be the Phred sequence and quality files\ngenerated from running Phred on a set of chromatograms.\n\nLucy can be obtained (free of charge to academic users) from\nwww.tigr.org/softlab\n\nThere are a few methods that will only be available if you make some\nminor changes to the source for Lucy and then recompile.  The changes\nare in the 'lucy.c' file and there is a diff between the original and\nthe modified file in the Appendix\n\nPlease contact the author of this module if you have any problems\nmaking these modifications.\n\nYou do not have to make these modifications to use this module.\n\n=head2 Creating a Lucy object\n\n  @params = ('seqfile' => 'lucy.seq', 'adv_stderr' => 1, \n\t     'fwd_desig' => '_F', 'rev_desig' => '_R');\n  $lucyObj = Bio::Tools::Lucy->new(@params);\n\n=head2 Using a Lucy object\n\n  You should get an array with the sequence names in order to use\n  accessor methods.  Note: The Lucy binary program will fail unless\n  the sequence names provided as input are unique.\n\n  $names_ref = $lucyObj->get_sequence_names();\n\n  This code snippet will produce a Fasta format file with sequence\n  lengths and %GC in the description line.\n\n  foreach $name (@$names) {\n      print FILE \">$name\\t\",\n\t\t $lucyObj->length_clear($name), \"\\t\",\n\t\t $lucyObj->per_GC($name), \"\\n\",\n\t\t $lucyObj->sequence($name), \"\\n\";\n  }\n\n\n  Print seq and qual values for sequences >400 bp in order to assemble\n  them with CAP3 (or other assembler).\n\n  foreach $name (@$names) {\n      next unless $lucyObj->length_clear($name) > 400;\n      print SEQ \">$name\\n\", $lucyObj->sequence($name), \"\\n\";\n      print QUAL \">$name\\n\", $lucyObj->quality($name), \"\\n\";\n  }\n\n  Get all the sequences as Bio::PrimarySeq objects (eg., for use with\n  Bio::Tools::Run::StandaloneBlast to perform BLAST).\n\n  @seqObjs = $lucyObj->get_Seq_Objs();\n\n  Or use only those sequences that are full length and have a Poly-A\n  tail.\n\n  foreach $name (@$names) {\n      next unless ($lucyObj->full_length($name) and $lucy->polyA($name));\n      push @seqObjs, $lucyObj->get_Seq_Obj($name);\n  }\n\n\n  Get the names of those sequences that were rejected by Lucy.\n\n  $rejects_ref = $lucyObj->get_rejects();\n\n  Print the names of the rejects and 1 letter code for reason they\n  were rejected.\n\n  foreach $key (sort keys %$rejects_ref) {\n      print \"$key:  \", $rejects_ref->{$key};\n  }\n\n  There is a lot of other information available about the sequences\n  analyzed by Lucy (see APPENDIX).  This module can be used with the\n  DBI module to store this sequence information in a database.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules.  Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nAndrew G. Walsh\t\tpaeruginosa@hotmail.com\n\n=head1 APPENDIX\n\nMethods available to Lucy objects are described below.  Please note\nthat any method beginning with an underscore is considered internal\nand should not be called directly.\n\n\n\npackage Bio::Tools::Lucy;\n\nuse vars qw($AUTOLOAD @ATTR %OK_FIELD);\nuse strict;\nuse Bio::PrimarySeq;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n@ATTR = qw(seqfile qualfile stderrfile infofile lucy_verbose fwd_desig rev_desig adv_stderr); \nforeach my $attr (@ATTR) {\n    $OK_FIELD{$attr}++\n}\n\nsub AUTOLOAD {\n    my $self = shift;\n    my $attr = $AUTOLOAD;\n    $attr =~ s/.*:://;\n    $attr = lc $attr;\n    $self->throw(\"Unallowed parameter: $attr !\") unless $OK_FIELD{$attr};\n    $self->{$attr} = shift if @_;\n    return $self->{$attr};\n}\n\n=head2 new\n\n Title\t :  new\n Usage\t :  $lucyObj = Bio::Tools::Lucy->new(seqfile => lucy.seq, rev_desig => '_R', \n\t    fwd_desig => '_F')\n Function:  creates a Lucy object from Lucy analysis files\n Returns :  reference to Bio::Tools::Lucy object\n Args\t :  seqfile\tFasta sequence file generated by Lucy\n\t       qualfile\tQuality values file generated by Lucy\n\t       infofile\tInfo file created when Lucy is run with -debug \n                     'infofile' option\n\t       stderrfile\tStandard error captured from Lucy when Lucy is run \n\t\t\t with -info option and STDERR is directed to stderrfile \n\t\t\t (ie. lucy ... 2> stderrfile).\n\t\t\t Info in this file will include sequences dropped for low \n\t\t\t quality. If you've modified Lucy source (see adv_stderr below), \n\t\t\t it will also include info on which sequences were dropped because \n\t\t\t they were vector, too short, had no insert, and whether a poly-A \n\t\t\t tail was found (if Lucy was run with -cdna option).\n\t       lucy_verbose verbosity level (0-1).  \n\t       fwd_desig\tThe string used to determine whether sequence is a \n          forward read.  \n\t\t\t The parser will assume that this match will occus at the \n\t\t\t end of the sequence name string.\n\t       rev_desig\tAs above, for reverse reads. \n \t       adv_stderr\tCan be set to a true value (1).  Will only work if \n          you have modified \n\t\t\t the Lucy source code as outlined in DESCRIPTION and capture \n\t\t\t the standard error from Lucy.\n\nIf you don't provide filenames for qualfile, infofile or stderrfile,\nthe module will assume that .qual, .info, and .stderr are the file\nextensions and search in the same directory as the .seq file for these\nfiles.\n\nFor example, if you create a Lucy object with $lucyObj =\nBio::Tools::Lucy-E<gt>new(seqfile =E<gt>lucy.seq), the module will\nfind lucy.qual, lucy.info and lucy.stderr.\n\nYou can omit any or all of the quality, info or stderr files, but you\nwill not be able to use all of the object methods (see method\ndocumentation below).\n\n\nsub new {\n\tmy ($class,@args) = @_;\n\tmy $self = $class->SUPER::new(@args);\n\tmy ($attr, $value);\n\twhile (@args) {\n\t\t$attr = shift @args;\n\t\t$attr = lc $attr;\n\t\t$value = shift @args;\n\t\t$self->{$attr} = $value;\n\t}\n\t&_parse($self);\n\treturn $self;\n}\n\n=head2 _parse\n\n Title\t :  _parse\n Usage\t :  n/a (internal function)\n Function:  called by new() to parse Lucy output files\n Returns :  nothing\n Args\t :  none\n\n\nsub _parse {\n\tmy $self = shift;\n\t$self->{seqfile} =~ /^(\\S+)\\.\\S+$/;\n\tmy $file = $1;\n\n\t$self->warn(\"Opening $self->{seqfile} for parsing...\\n\") if $self->{lucy_verbose};\n\topen my $SEQ, $self->{seqfile} or $self->throw(\"Could not open sequence file: $self->{seqfile}\");\n\tmy ($name, $line);\n\tmy $seq = \"\";\n\tmy @lines = <$SEQ>;\n\twhile ($line = pop @lines) {\n\t\tchomp $line;\n\t\tif ($line =~ /^>(\\S+)\\s+(\\d+)\\s+(\\d+)\\s+(\\d+)\\s+(\\d+)\\s+(\\d+)/) {    \n\t\t\t$name = $1;\n\t\t\tif ($self->{fwd_desig}) {\n\t\t\t\t$self->{sequences}{$name}{direction} = \"F\" if $name =~ /^(\\S+)($self->{fwd_desig})$/;\n\t\t\t}\n\t\t\tif ($self->{rev_desig}) {\n\t\t\t\t$self->{sequences}{$name}{direction} = \"R\" if $name =~ /^(\\S+)($self->{rev_desig})$/;\n\t\t\t}\n\t\t\t$self->{sequences}{$name}{min_clone_len} = $2; # this is used for TIGR Assembler, as are $3 and $4\n\t\t\t$self->{sequences}{$name}{max_clone_len} = $3;\n\t\t\t$self->{sequences}{$name}{med_clone_len} = $4; \n\t\t\t$self->{sequences}{$name}{beg_clear} = $5;\n\t\t\t$self->{sequences}{$name}{end_clear} = $6;\n\t\t\t$self->{sequences}{$name}{length_raw} = $seq =~ tr/[AGCTN]//; # from what I've seen, these are the bases Phred calls.  Please let me know if I'm wrong.     \n\t\t\tmy $beg = $5-1; # substr function begins with index 0\n\t\t\t$seq = $self->{sequences}{$name}{sequence} = substr ($seq, $beg, $6-$beg);\n\t\t\tmy $count = $self->{sequences}{$name}{length_clear} = $seq =~ tr/[AGCTN]//;\n\t\t\tmy $countGC =  $seq =~ tr/[GC]//;\n\t\t\t$self->{sequences}{$name}{per_GC} = $countGC/$count * 100;\n\t\t\t$seq = \"\";\n\t\t}\n\t\telse {\n\t\t\t$seq = $line.$seq;\n\t\t}\n\t}\n\n\t# now parse quality values (check for presence of quality file first) \n\tif ($self->{qualfile}) {\n\t\topen my $QUAL, \"$self->{qualfile}\" or $self->throw(\"Could not open quality file: $self->{qualfile}\");\n\t\t@lines = <$QUAL>;\n\t}\n\telsif (-e \"$file.qual\") {\n\t\t$self->warn(\"You did not set qualfile, but I'm opening $file.qual\\n\") if $self->{lucy_verbose};\n\t$self->qualfile(\"$file.qual\");\n\t\topen my $QUAL, \"$file.qual\" or $self->throw(\"Could not open quality file: $file.qual\");\n\t\t@lines = <$QUAL>;\n\t}\n    else {\n\t\t $self->warn(\"I did not find a quality file.  You will not be able to use all of the accessor methods.\\n\") if $self->{lucy_verbose};\n\t\t @lines = ();\n    }\n\n\tmy (@vals, @slice, $num, $tot, $vals);  \n\tmy $qual = \"\"; \n\twhile ($line = pop @lines) {\n\t\tchomp $line;\n\t\tif ($line =~ /^>(\\S+)/) {\n\t\t\t$name = $1;\n\t\t\t@vals = split /\\s/ , $qual;\n\t\t\t@slice = @vals[$self->{sequences}{$name}{beg_clear} - 1 .. $self->{sequences}{$name}{end_clear} - 1];\n\t\t\t$vals = join \"\\t\", @slice;\n\t\t\t$self->{sequences}{$name}{quality} = $vals;\n\t\t\t$qual = \"\";\n\t\t\tforeach $num (@slice) {\n\t\t\t\t$tot += $num;\n\t\t\t}\n\t\t\t$num = @slice;\n\t\t\t$self->{sequences}{$name}{avg_quality} = $tot/$num;\n\t\t\t$tot = 0;\n\t\t}\n\t\telse {\n\t\t\t$qual = $line.$qual;\n\t\t}\n\t}\n\n\t# determine whether reads are full length\n\tif ($self->{infofile}) {\n\t\topen my $INFO, \"$self->{infofile}\" or $self->throw(\"Could not open info file: $self->{infofile}\");\n\t\t@lines = <$INFO>;\n\t}\n\telsif (-e \"$file.info\") {\n\t\t$self->warn(\"You did not set infofile, but I'm opening $file.info\\n\") if $self->{lucy_verbose};\n\t\t$self->infofile(\"$file.info\");\n\t\topen my $INFO, \"$file.info\" or $self->throw(\"Could not open info file: $file.info\");\n\t\t@lines = <$INFO>;\n\t}\n\telse {\n\t\t$self->warn(\"I did not find an info file.  You will not be able to use all of the accessor methods.\\n\") if $self->{lucy_verbose};\n\t\t@lines = ();\n\t}\n\n\tforeach (@lines) {\n\t\t/^(\\S+).+CLV\\s+(\\d+)\\s+(\\d+)$/;\n\t\tif ($2>0 && $3>0) {\n\t\t\t$self->{sequences}{$1}{full_length} = 1 if $self->{sequences}{$1}; # will show cleavage info for rejected sequences too\n\t\t}\n\t}\n\n\n\t# parse rejects (and presence of poly-A if Lucy has been modified)\n\tif ($self->{stderrfile}) {\n\t\topen my $STDERR_LUCY, \"$self->{stderrfile}\" or $self->throw(\"Could not open quality file: $self->{stderrfile}\");\n\t\t@lines = <$STDERR_LUCY>;\n\t}\n\telsif (-e \"$file.stderr\") {\n\t\t$self->warn(\"You did not set stderrfile, but I'm opening $file.stderr\\n\") if $self->{lucy_verbose};\n\t\t$self->stderrfile(\"$file.stderr\");\n\t\topen my $STDERR_LUCY, \"$file.stderr\" or $self->throw(\"Could not open quality file: $file.stderr\");\n\t\t@lines = <$STDERR_LUCY>;\n\t}\n\telse {\n\t\t$self->warn(\"I did not find a standard error file.  You will not be able to use all of the accessor methods.\\n\") if $self->{lucy_verbose};\n\t\t@lines = ();\n\t}\n\n\tif ($self->{adv_stderr}) {\n\t\tforeach (@lines) {\n\t\t\t$self->{reject}{$1} = \"Q\" if /dropping\\s+(\\S+)/;\n\t\t\t$self->{reject}{$1} = \"V\" if /Vector: (\\S+)/;\n\t\t\t$self->{reject}{$1} = \"E\" if /Empty: (\\S+)/;\n\t\t\t$self->{reject}{$1} = \"S\" if m{Short/ no insert: (\\S+)};\n\t\t\t$self->{sequences}{$1}{polyA} = 1 if /(\\S+) has PolyA/;\n\t\t\tif (/Dropped PolyA: (\\S+)/) {\n\t\t\t\t$self->{reject}{$1} = \"P\";\n\t\t\t\tdelete $self->{sequences}{$1};\n\t\t\t}\n\t\t}\n\t}\n\telse {\n\t\tforeach (@lines) {\n\t\t\t$self->{reject}{$1} = \"R\" if /dropping\\s+(\\S+)/;\n\t\t}\n\t}\n}\n\n=head2 get_Seq_Objs\n\n Title   :  get_Seq_Objs\n Usage   :  $lucyObj->get_Seq_Objs()\n Function:  returns an array of references to Bio::PrimarySeq objects \n\t    where -id = 'sequence name' and -seq = 'sequence'\n\n Returns :  array of Bio::PrimarySeq objects\n Args\t :  none\n\n\nsub get_Seq_Objs {\n    my $self = shift;\n    my($seqobj, @seqobjs);\n    foreach my $key (sort keys %{$self->{sequences}}) {\n\t$seqobj = Bio::PrimarySeq->new( -seq => \"$self->{sequences}{$key}{sequence}\",\n\t\t\t\t\t-id => \"$key\");\n\tpush @seqobjs, $seqobj;\n    }\n    return \\@seqobjs;\n} \n\n=head2 get_Seq_Obj\n\n Title   :  get_Seq_Obj\n Usage   :  $lucyObj->get_Seq_Obj($seqname)\n Function:  returns reference to a Bio::PrimarySeq object where -id = 'sequence name'\n\t    and -seq = 'sequence'\n Returns :  reference to Bio::PrimarySeq object\n Args\t :  name of a sequence \n\n\nsub get_Seq_Obj {\n    my ($self, $key) = @_;\n    my $seqobj = Bio::PrimarySeq->new( -seq => \"$self->{sequences}{$key}{sequence}\",\n                                    -id => \"$key\");\n    return $seqobj;\n}\n\n=head2 get_sequence_names\n\n Title   :  get_sequence_names\n Usage   :  $lucyObj->get_sequence_names\n Function:  returns reference to an array of names of the sequences analyzed by Lucy.\n\t    These names are required for most of the accessor methods.  \n\t    Note: The Lucy binary will fail unless sequence names are unique.\n Returns :  array reference\n Args\t :  none \n\n\nsub get_sequence_names {\n    my $self = shift;\n    my @keys = sort keys %{$self->{sequences}};\n    return \\@keys;\n}\n\n=head2 sequence\n\n Title   :  sequence\n Usage   :  $lucyObj->sequence($seqname)\n Function:  returns the DNA sequence of one of the sequences analyzed by Lucy.\n Returns :  string\n Args\t :  name of a sequence                   \n\n\nsub sequence {\n    my ($self, $key) = @_;\n    return $self->{sequences}{$key}{sequence};\n}\n\n=head2 quality\n\n Title   :  quality\n Usage   :  $lucyObj->quality($seqname)\n Function:  returns the quality values of one of the sequences analyzed by Lucy.\n\t    This method depends on the user having provided a quality file.\n Returns :  string\n Args    :  name of a sequence\n\n\nsub quality {\n    my($self, $key) = @_;\n    return $self->{sequences}{$key}{quality};\n}\n\n=head2 avg_quality\n\n Title   :  avg_quality\n Usage   :  $lucyObj->avg_quality($seqname)\n Function:  returns the average quality value for one of the sequences analyzed by Lucy.\n Returns :  float\n Args    :  name of a sequence\n\n\nsub avg_quality {\n    my($self, $key) = @_;\n    return $self->{sequences}{$key}{avg_quality};\n}\n\n=head2 direction\n\n Title   :  direction\n Usage   :  $lucyObj->direction($seqname)\n Function:  returns the direction for one of the sequences analyzed by Lucy\n\t    providing that 'fwd_desig' or 'rev_desig' were set when the\n \t    Lucy object was created.\n\t    Strings returned are: 'F' for forward, 'R' for reverse.  \n Returns :  string \n Args    :  name of a sequence\n\n\nsub direction {\n    my($self, $key) = @_;\n    return $self->{sequences}{$key}{direction} if $self->{sequences}{$key}{direction}; \n    return \"\";\n}\n\n=head2 length_raw\n\n Title   :  length_raw\n Usage   :  $lucyObj->length_raw($seqname)\n Function:  returns the length of a DNA sequence prior to quality/ vector \n\t    trimming by Lucy.\n Returns :  integer\n Args    :  name of a sequence\n\n\nsub length_raw {\n    my($self, $key) = @_;\n    return $self->{sequences}{$key}{length_raw};\n}\n\n=head2 length_clear\n\n Title   :  length_clear\n Usage   :  $lucyObj->length_clear($seqname)\n Function:  returns the length of a DNA sequence following quality/ vector   \n            trimming by Lucy.\n Returns :  integer\n Args    :  name of a sequence\n\n\nsub length_clear {\n    my($self, $key) = @_;\n    return $self->{sequences}{$key}{length_clear};\n}\n\n=head2 start_clear\n\n Title   :  start_clear\n Usage   :  $lucyObj->start_clear($seqname)\n Function:  returns the beginning position of good quality, vector free DNA sequence \n\t    determined by Lucy.\n Returns :  integer\n Args    :  name of a sequence\n\n\nsub start_clear {\n    my($self, $key) = @_;\n    return $self->{sequences}{$key}{beg_clear};\n}\n\n\n=head2 end_clear\n\n Title   :  end_clear\n Usage   :  $lucyObj->end_clear($seqname)\n Function:  returns the ending position of good quality, vector free DNA sequence\n            determined by Lucy.\n Returns :  integer\n Args    :  name of a sequence"},"detail":"($self,$key)","definition":"sub","containerName":"main::"},{"line":579,"kind":12,"name":"sequences"},{"line":579,"kind":12,"name":"end_clear"},{"kind":12,"children":[{"kind":13,"line":594,"containerName":"per_GC","definition":"my","name":"$self","localvar":"my"},{"name":"$key","containerName":"per_GC","kind":13,"line":594},{"kind":13,"line":595,"name":"$self","containerName":"per_GC"},{"name":"$key","containerName":"per_GC","kind":13,"line":595}],"line":593,"definition":"sub","containerName":"main::","signature":{"label":"per_GC($self,$key)","documentation":"1;\n# $Id: Lucy.pm 16123 2009-09-17 12:57:27Z cjfields $ \n#\n# BioPerl module for Bio::Tools::Lucy\n#\n# Copyright Her Majesty the Queen of England\n# written by Andrew Walsh (paeruginosa@hotmail.com) during employment with \n# Agriculture and Agri-food Canada, Cereal Research Centre, Winnipeg, MB\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Lucy - Object for analyzing the output from Lucy,\n  a vector and quality trimming program from TIGR\n\n=head1 SYNOPSIS\n\n  # Create the Lucy object from an existing Lucy output file\n  @params = ('seqfile' => 'lucy.seq', 'lucy_verbose' => 1);\n  $lucyObj = Bio::Tools::Lucy->new(@params);\n\n  # Get names of all sequences\n  $names = $lucyObj->get_sequence_names();\n\n  #  Print seq and qual values for sequences >400 bp in order to run CAP3\n  foreach $name (@$names) {\n      next unless $lucyObj->length_clear($name) > 400;\n      print SEQ \">$name\\n\", $lucyObj->sequence($name), \"\\n\";\n      print QUAL \">$name\\n\", $lucyObj->quality($name), \"\\n\";\n  }\n\n  # Get an array of Bio::PrimarySeq objects\n  @seqObjs = $lucyObj->get_Seq_Objs();\n\n\n=head1 DESCRIPTION\n\nBio::Tools::Lucy.pm provides methods for analyzing the sequence and\nquality values generated by Lucy program from TIGR.\n\nLucy will identify vector, poly-A/T tails, and poor quality regions in\na sequence.  (www.genomics.purdue.edu/gcg/other/lucy.pdf)\n\nThe input to Lucy can be the Phred sequence and quality files\ngenerated from running Phred on a set of chromatograms.\n\nLucy can be obtained (free of charge to academic users) from\nwww.tigr.org/softlab\n\nThere are a few methods that will only be available if you make some\nminor changes to the source for Lucy and then recompile.  The changes\nare in the 'lucy.c' file and there is a diff between the original and\nthe modified file in the Appendix\n\nPlease contact the author of this module if you have any problems\nmaking these modifications.\n\nYou do not have to make these modifications to use this module.\n\n=head2 Creating a Lucy object\n\n  @params = ('seqfile' => 'lucy.seq', 'adv_stderr' => 1, \n\t     'fwd_desig' => '_F', 'rev_desig' => '_R');\n  $lucyObj = Bio::Tools::Lucy->new(@params);\n\n=head2 Using a Lucy object\n\n  You should get an array with the sequence names in order to use\n  accessor methods.  Note: The Lucy binary program will fail unless\n  the sequence names provided as input are unique.\n\n  $names_ref = $lucyObj->get_sequence_names();\n\n  This code snippet will produce a Fasta format file with sequence\n  lengths and %GC in the description line.\n\n  foreach $name (@$names) {\n      print FILE \">$name\\t\",\n\t\t $lucyObj->length_clear($name), \"\\t\",\n\t\t $lucyObj->per_GC($name), \"\\n\",\n\t\t $lucyObj->sequence($name), \"\\n\";\n  }\n\n\n  Print seq and qual values for sequences >400 bp in order to assemble\n  them with CAP3 (or other assembler).\n\n  foreach $name (@$names) {\n      next unless $lucyObj->length_clear($name) > 400;\n      print SEQ \">$name\\n\", $lucyObj->sequence($name), \"\\n\";\n      print QUAL \">$name\\n\", $lucyObj->quality($name), \"\\n\";\n  }\n\n  Get all the sequences as Bio::PrimarySeq objects (eg., for use with\n  Bio::Tools::Run::StandaloneBlast to perform BLAST).\n\n  @seqObjs = $lucyObj->get_Seq_Objs();\n\n  Or use only those sequences that are full length and have a Poly-A\n  tail.\n\n  foreach $name (@$names) {\n      next unless ($lucyObj->full_length($name) and $lucy->polyA($name));\n      push @seqObjs, $lucyObj->get_Seq_Obj($name);\n  }\n\n\n  Get the names of those sequences that were rejected by Lucy.\n\n  $rejects_ref = $lucyObj->get_rejects();\n\n  Print the names of the rejects and 1 letter code for reason they\n  were rejected.\n\n  foreach $key (sort keys %$rejects_ref) {\n      print \"$key:  \", $rejects_ref->{$key};\n  }\n\n  There is a lot of other information available about the sequences\n  analyzed by Lucy (see APPENDIX).  This module can be used with the\n  DBI module to store this sequence information in a database.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules.  Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nAndrew G. Walsh\t\tpaeruginosa@hotmail.com\n\n=head1 APPENDIX\n\nMethods available to Lucy objects are described below.  Please note\nthat any method beginning with an underscore is considered internal\nand should not be called directly.\n\n\n\npackage Bio::Tools::Lucy;\n\nuse vars qw($AUTOLOAD @ATTR %OK_FIELD);\nuse strict;\nuse Bio::PrimarySeq;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n@ATTR = qw(seqfile qualfile stderrfile infofile lucy_verbose fwd_desig rev_desig adv_stderr); \nforeach my $attr (@ATTR) {\n    $OK_FIELD{$attr}++\n}\n\nsub AUTOLOAD {\n    my $self = shift;\n    my $attr = $AUTOLOAD;\n    $attr =~ s/.*:://;\n    $attr = lc $attr;\n    $self->throw(\"Unallowed parameter: $attr !\") unless $OK_FIELD{$attr};\n    $self->{$attr} = shift if @_;\n    return $self->{$attr};\n}\n\n=head2 new\n\n Title\t :  new\n Usage\t :  $lucyObj = Bio::Tools::Lucy->new(seqfile => lucy.seq, rev_desig => '_R', \n\t    fwd_desig => '_F')\n Function:  creates a Lucy object from Lucy analysis files\n Returns :  reference to Bio::Tools::Lucy object\n Args\t :  seqfile\tFasta sequence file generated by Lucy\n\t       qualfile\tQuality values file generated by Lucy\n\t       infofile\tInfo file created when Lucy is run with -debug \n                     'infofile' option\n\t       stderrfile\tStandard error captured from Lucy when Lucy is run \n\t\t\t with -info option and STDERR is directed to stderrfile \n\t\t\t (ie. lucy ... 2> stderrfile).\n\t\t\t Info in this file will include sequences dropped for low \n\t\t\t quality. If you've modified Lucy source (see adv_stderr below), \n\t\t\t it will also include info on which sequences were dropped because \n\t\t\t they were vector, too short, had no insert, and whether a poly-A \n\t\t\t tail was found (if Lucy was run with -cdna option).\n\t       lucy_verbose verbosity level (0-1).  \n\t       fwd_desig\tThe string used to determine whether sequence is a \n          forward read.  \n\t\t\t The parser will assume that this match will occus at the \n\t\t\t end of the sequence name string.\n\t       rev_desig\tAs above, for reverse reads. \n \t       adv_stderr\tCan be set to a true value (1).  Will only work if \n          you have modified \n\t\t\t the Lucy source code as outlined in DESCRIPTION and capture \n\t\t\t the standard error from Lucy.\n\nIf you don't provide filenames for qualfile, infofile or stderrfile,\nthe module will assume that .qual, .info, and .stderr are the file\nextensions and search in the same directory as the .seq file for these\nfiles.\n\nFor example, if you create a Lucy object with $lucyObj =\nBio::Tools::Lucy-E<gt>new(seqfile =E<gt>lucy.seq), the module will\nfind lucy.qual, lucy.info and lucy.stderr.\n\nYou can omit any or all of the quality, info or stderr files, but you\nwill not be able to use all of the object methods (see method\ndocumentation below).\n\n\nsub new {\n\tmy ($class,@args) = @_;\n\tmy $self = $class->SUPER::new(@args);\n\tmy ($attr, $value);\n\twhile (@args) {\n\t\t$attr = shift @args;\n\t\t$attr = lc $attr;\n\t\t$value = shift @args;\n\t\t$self->{$attr} = $value;\n\t}\n\t&_parse($self);\n\treturn $self;\n}\n\n=head2 _parse\n\n Title\t :  _parse\n Usage\t :  n/a (internal function)\n Function:  called by new() to parse Lucy output files\n Returns :  nothing\n Args\t :  none\n\n\nsub _parse {\n\tmy $self = shift;\n\t$self->{seqfile} =~ /^(\\S+)\\.\\S+$/;\n\tmy $file = $1;\n\n\t$self->warn(\"Opening $self->{seqfile} for parsing...\\n\") if $self->{lucy_verbose};\n\topen my $SEQ, $self->{seqfile} or $self->throw(\"Could not open sequence file: $self->{seqfile}\");\n\tmy ($name, $line);\n\tmy $seq = \"\";\n\tmy @lines = <$SEQ>;\n\twhile ($line = pop @lines) {\n\t\tchomp $line;\n\t\tif ($line =~ /^>(\\S+)\\s+(\\d+)\\s+(\\d+)\\s+(\\d+)\\s+(\\d+)\\s+(\\d+)/) {    \n\t\t\t$name = $1;\n\t\t\tif ($self->{fwd_desig}) {\n\t\t\t\t$self->{sequences}{$name}{direction} = \"F\" if $name =~ /^(\\S+)($self->{fwd_desig})$/;\n\t\t\t}\n\t\t\tif ($self->{rev_desig}) {\n\t\t\t\t$self->{sequences}{$name}{direction} = \"R\" if $name =~ /^(\\S+)($self->{rev_desig})$/;\n\t\t\t}\n\t\t\t$self->{sequences}{$name}{min_clone_len} = $2; # this is used for TIGR Assembler, as are $3 and $4\n\t\t\t$self->{sequences}{$name}{max_clone_len} = $3;\n\t\t\t$self->{sequences}{$name}{med_clone_len} = $4; \n\t\t\t$self->{sequences}{$name}{beg_clear} = $5;\n\t\t\t$self->{sequences}{$name}{end_clear} = $6;\n\t\t\t$self->{sequences}{$name}{length_raw} = $seq =~ tr/[AGCTN]//; # from what I've seen, these are the bases Phred calls.  Please let me know if I'm wrong.     \n\t\t\tmy $beg = $5-1; # substr function begins with index 0\n\t\t\t$seq = $self->{sequences}{$name}{sequence} = substr ($seq, $beg, $6-$beg);\n\t\t\tmy $count = $self->{sequences}{$name}{length_clear} = $seq =~ tr/[AGCTN]//;\n\t\t\tmy $countGC =  $seq =~ tr/[GC]//;\n\t\t\t$self->{sequences}{$name}{per_GC} = $countGC/$count * 100;\n\t\t\t$seq = \"\";\n\t\t}\n\t\telse {\n\t\t\t$seq = $line.$seq;\n\t\t}\n\t}\n\n\t# now parse quality values (check for presence of quality file first) \n\tif ($self->{qualfile}) {\n\t\topen my $QUAL, \"$self->{qualfile}\" or $self->throw(\"Could not open quality file: $self->{qualfile}\");\n\t\t@lines = <$QUAL>;\n\t}\n\telsif (-e \"$file.qual\") {\n\t\t$self->warn(\"You did not set qualfile, but I'm opening $file.qual\\n\") if $self->{lucy_verbose};\n\t$self->qualfile(\"$file.qual\");\n\t\topen my $QUAL, \"$file.qual\" or $self->throw(\"Could not open quality file: $file.qual\");\n\t\t@lines = <$QUAL>;\n\t}\n    else {\n\t\t $self->warn(\"I did not find a quality file.  You will not be able to use all of the accessor methods.\\n\") if $self->{lucy_verbose};\n\t\t @lines = ();\n    }\n\n\tmy (@vals, @slice, $num, $tot, $vals);  \n\tmy $qual = \"\"; \n\twhile ($line = pop @lines) {\n\t\tchomp $line;\n\t\tif ($line =~ /^>(\\S+)/) {\n\t\t\t$name = $1;\n\t\t\t@vals = split /\\s/ , $qual;\n\t\t\t@slice = @vals[$self->{sequences}{$name}{beg_clear} - 1 .. $self->{sequences}{$name}{end_clear} - 1];\n\t\t\t$vals = join \"\\t\", @slice;\n\t\t\t$self->{sequences}{$name}{quality} = $vals;\n\t\t\t$qual = \"\";\n\t\t\tforeach $num (@slice) {\n\t\t\t\t$tot += $num;\n\t\t\t}\n\t\t\t$num = @slice;\n\t\t\t$self->{sequences}{$name}{avg_quality} = $tot/$num;\n\t\t\t$tot = 0;\n\t\t}\n\t\telse {\n\t\t\t$qual = $line.$qual;\n\t\t}\n\t}\n\n\t# determine whether reads are full length\n\tif ($self->{infofile}) {\n\t\topen my $INFO, \"$self->{infofile}\" or $self->throw(\"Could not open info file: $self->{infofile}\");\n\t\t@lines = <$INFO>;\n\t}\n\telsif (-e \"$file.info\") {\n\t\t$self->warn(\"You did not set infofile, but I'm opening $file.info\\n\") if $self->{lucy_verbose};\n\t\t$self->infofile(\"$file.info\");\n\t\topen my $INFO, \"$file.info\" or $self->throw(\"Could not open info file: $file.info\");\n\t\t@lines = <$INFO>;\n\t}\n\telse {\n\t\t$self->warn(\"I did not find an info file.  You will not be able to use all of the accessor methods.\\n\") if $self->{lucy_verbose};\n\t\t@lines = ();\n\t}\n\n\tforeach (@lines) {\n\t\t/^(\\S+).+CLV\\s+(\\d+)\\s+(\\d+)$/;\n\t\tif ($2>0 && $3>0) {\n\t\t\t$self->{sequences}{$1}{full_length} = 1 if $self->{sequences}{$1}; # will show cleavage info for rejected sequences too\n\t\t}\n\t}\n\n\n\t# parse rejects (and presence of poly-A if Lucy has been modified)\n\tif ($self->{stderrfile}) {\n\t\topen my $STDERR_LUCY, \"$self->{stderrfile}\" or $self->throw(\"Could not open quality file: $self->{stderrfile}\");\n\t\t@lines = <$STDERR_LUCY>;\n\t}\n\telsif (-e \"$file.stderr\") {\n\t\t$self->warn(\"You did not set stderrfile, but I'm opening $file.stderr\\n\") if $self->{lucy_verbose};\n\t\t$self->stderrfile(\"$file.stderr\");\n\t\topen my $STDERR_LUCY, \"$file.stderr\" or $self->throw(\"Could not open quality file: $file.stderr\");\n\t\t@lines = <$STDERR_LUCY>;\n\t}\n\telse {\n\t\t$self->warn(\"I did not find a standard error file.  You will not be able to use all of the accessor methods.\\n\") if $self->{lucy_verbose};\n\t\t@lines = ();\n\t}\n\n\tif ($self->{adv_stderr}) {\n\t\tforeach (@lines) {\n\t\t\t$self->{reject}{$1} = \"Q\" if /dropping\\s+(\\S+)/;\n\t\t\t$self->{reject}{$1} = \"V\" if /Vector: (\\S+)/;\n\t\t\t$self->{reject}{$1} = \"E\" if /Empty: (\\S+)/;\n\t\t\t$self->{reject}{$1} = \"S\" if m{Short/ no insert: (\\S+)};\n\t\t\t$self->{sequences}{$1}{polyA} = 1 if /(\\S+) has PolyA/;\n\t\t\tif (/Dropped PolyA: (\\S+)/) {\n\t\t\t\t$self->{reject}{$1} = \"P\";\n\t\t\t\tdelete $self->{sequences}{$1};\n\t\t\t}\n\t\t}\n\t}\n\telse {\n\t\tforeach (@lines) {\n\t\t\t$self->{reject}{$1} = \"R\" if /dropping\\s+(\\S+)/;\n\t\t}\n\t}\n}\n\n=head2 get_Seq_Objs\n\n Title   :  get_Seq_Objs\n Usage   :  $lucyObj->get_Seq_Objs()\n Function:  returns an array of references to Bio::PrimarySeq objects \n\t    where -id = 'sequence name' and -seq = 'sequence'\n\n Returns :  array of Bio::PrimarySeq objects\n Args\t :  none\n\n\nsub get_Seq_Objs {\n    my $self = shift;\n    my($seqobj, @seqobjs);\n    foreach my $key (sort keys %{$self->{sequences}}) {\n\t$seqobj = Bio::PrimarySeq->new( -seq => \"$self->{sequences}{$key}{sequence}\",\n\t\t\t\t\t-id => \"$key\");\n\tpush @seqobjs, $seqobj;\n    }\n    return \\@seqobjs;\n} \n\n=head2 get_Seq_Obj\n\n Title   :  get_Seq_Obj\n Usage   :  $lucyObj->get_Seq_Obj($seqname)\n Function:  returns reference to a Bio::PrimarySeq object where -id = 'sequence name'\n\t    and -seq = 'sequence'\n Returns :  reference to Bio::PrimarySeq object\n Args\t :  name of a sequence \n\n\nsub get_Seq_Obj {\n    my ($self, $key) = @_;\n    my $seqobj = Bio::PrimarySeq->new( -seq => \"$self->{sequences}{$key}{sequence}\",\n                                    -id => \"$key\");\n    return $seqobj;\n}\n\n=head2 get_sequence_names\n\n Title   :  get_sequence_names\n Usage   :  $lucyObj->get_sequence_names\n Function:  returns reference to an array of names of the sequences analyzed by Lucy.\n\t    These names are required for most of the accessor methods.  \n\t    Note: The Lucy binary will fail unless sequence names are unique.\n Returns :  array reference\n Args\t :  none \n\n\nsub get_sequence_names {\n    my $self = shift;\n    my @keys = sort keys %{$self->{sequences}};\n    return \\@keys;\n}\n\n=head2 sequence\n\n Title   :  sequence\n Usage   :  $lucyObj->sequence($seqname)\n Function:  returns the DNA sequence of one of the sequences analyzed by Lucy.\n Returns :  string\n Args\t :  name of a sequence                   \n\n\nsub sequence {\n    my ($self, $key) = @_;\n    return $self->{sequences}{$key}{sequence};\n}\n\n=head2 quality\n\n Title   :  quality\n Usage   :  $lucyObj->quality($seqname)\n Function:  returns the quality values of one of the sequences analyzed by Lucy.\n\t    This method depends on the user having provided a quality file.\n Returns :  string\n Args    :  name of a sequence\n\n\nsub quality {\n    my($self, $key) = @_;\n    return $self->{sequences}{$key}{quality};\n}\n\n=head2 avg_quality\n\n Title   :  avg_quality\n Usage   :  $lucyObj->avg_quality($seqname)\n Function:  returns the average quality value for one of the sequences analyzed by Lucy.\n Returns :  float\n Args    :  name of a sequence\n\n\nsub avg_quality {\n    my($self, $key) = @_;\n    return $self->{sequences}{$key}{avg_quality};\n}\n\n=head2 direction\n\n Title   :  direction\n Usage   :  $lucyObj->direction($seqname)\n Function:  returns the direction for one of the sequences analyzed by Lucy\n\t    providing that 'fwd_desig' or 'rev_desig' were set when the\n \t    Lucy object was created.\n\t    Strings returned are: 'F' for forward, 'R' for reverse.  \n Returns :  string \n Args    :  name of a sequence\n\n\nsub direction {\n    my($self, $key) = @_;\n    return $self->{sequences}{$key}{direction} if $self->{sequences}{$key}{direction}; \n    return \"\";\n}\n\n=head2 length_raw\n\n Title   :  length_raw\n Usage   :  $lucyObj->length_raw($seqname)\n Function:  returns the length of a DNA sequence prior to quality/ vector \n\t    trimming by Lucy.\n Returns :  integer\n Args    :  name of a sequence\n\n\nsub length_raw {\n    my($self, $key) = @_;\n    return $self->{sequences}{$key}{length_raw};\n}\n\n=head2 length_clear\n\n Title   :  length_clear\n Usage   :  $lucyObj->length_clear($seqname)\n Function:  returns the length of a DNA sequence following quality/ vector   \n            trimming by Lucy.\n Returns :  integer\n Args    :  name of a sequence\n\n\nsub length_clear {\n    my($self, $key) = @_;\n    return $self->{sequences}{$key}{length_clear};\n}\n\n=head2 start_clear\n\n Title   :  start_clear\n Usage   :  $lucyObj->start_clear($seqname)\n Function:  returns the beginning position of good quality, vector free DNA sequence \n\t    determined by Lucy.\n Returns :  integer\n Args    :  name of a sequence\n\n\nsub start_clear {\n    my($self, $key) = @_;\n    return $self->{sequences}{$key}{beg_clear};\n}\n\n\n=head2 end_clear\n\n Title   :  end_clear\n Usage   :  $lucyObj->end_clear($seqname)\n Function:  returns the ending position of good quality, vector free DNA sequence\n            determined by Lucy.\n Returns :  integer\n Args    :  name of a sequence\n\n\nsub end_clear {\n    my($self, $key) = @_;\n    return $self->{sequences}{$key}{end_clear};\n}\n\n=head2 per_GC\n\n Title   :  per_GC\n Usage   :  $lucyObj->per_GC($seqname)\n Function:  returns the percente of the good quality, vector free DNA sequence\n            determined by Lucy.\n Returns :  float\n Args    :  name of a sequence","parameters":[{"label":"$self"},{"label":"$key"}]},"detail":"($self,$key)","name":"per_GC","range":{"end":{"character":9999,"line":596},"start":{"line":593,"character":0}}},{"name":"sequences","kind":12,"line":595},{"kind":12,"line":595,"name":"per_GC"},{"signature":{"parameters":[{"label":"$self"},{"label":"$key"}],"documentation":"1;\n# $Id: Lucy.pm 16123 2009-09-17 12:57:27Z cjfields $ \n#\n# BioPerl module for Bio::Tools::Lucy\n#\n# Copyright Her Majesty the Queen of England\n# written by Andrew Walsh (paeruginosa@hotmail.com) during employment with \n# Agriculture and Agri-food Canada, Cereal Research Centre, Winnipeg, MB\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Lucy - Object for analyzing the output from Lucy,\n  a vector and quality trimming program from TIGR\n\n=head1 SYNOPSIS\n\n  # Create the Lucy object from an existing Lucy output file\n  @params = ('seqfile' => 'lucy.seq', 'lucy_verbose' => 1);\n  $lucyObj = Bio::Tools::Lucy->new(@params);\n\n  # Get names of all sequences\n  $names = $lucyObj->get_sequence_names();\n\n  #  Print seq and qual values for sequences >400 bp in order to run CAP3\n  foreach $name (@$names) {\n      next unless $lucyObj->length_clear($name) > 400;\n      print SEQ \">$name\\n\", $lucyObj->sequence($name), \"\\n\";\n      print QUAL \">$name\\n\", $lucyObj->quality($name), \"\\n\";\n  }\n\n  # Get an array of Bio::PrimarySeq objects\n  @seqObjs = $lucyObj->get_Seq_Objs();\n\n\n=head1 DESCRIPTION\n\nBio::Tools::Lucy.pm provides methods for analyzing the sequence and\nquality values generated by Lucy program from TIGR.\n\nLucy will identify vector, poly-A/T tails, and poor quality regions in\na sequence.  (www.genomics.purdue.edu/gcg/other/lucy.pdf)\n\nThe input to Lucy can be the Phred sequence and quality files\ngenerated from running Phred on a set of chromatograms.\n\nLucy can be obtained (free of charge to academic users) from\nwww.tigr.org/softlab\n\nThere are a few methods that will only be available if you make some\nminor changes to the source for Lucy and then recompile.  The changes\nare in the 'lucy.c' file and there is a diff between the original and\nthe modified file in the Appendix\n\nPlease contact the author of this module if you have any problems\nmaking these modifications.\n\nYou do not have to make these modifications to use this module.\n\n=head2 Creating a Lucy object\n\n  @params = ('seqfile' => 'lucy.seq', 'adv_stderr' => 1, \n\t     'fwd_desig' => '_F', 'rev_desig' => '_R');\n  $lucyObj = Bio::Tools::Lucy->new(@params);\n\n=head2 Using a Lucy object\n\n  You should get an array with the sequence names in order to use\n  accessor methods.  Note: The Lucy binary program will fail unless\n  the sequence names provided as input are unique.\n\n  $names_ref = $lucyObj->get_sequence_names();\n\n  This code snippet will produce a Fasta format file with sequence\n  lengths and %GC in the description line.\n\n  foreach $name (@$names) {\n      print FILE \">$name\\t\",\n\t\t $lucyObj->length_clear($name), \"\\t\",\n\t\t $lucyObj->per_GC($name), \"\\n\",\n\t\t $lucyObj->sequence($name), \"\\n\";\n  }\n\n\n  Print seq and qual values for sequences >400 bp in order to assemble\n  them with CAP3 (or other assembler).\n\n  foreach $name (@$names) {\n      next unless $lucyObj->length_clear($name) > 400;\n      print SEQ \">$name\\n\", $lucyObj->sequence($name), \"\\n\";\n      print QUAL \">$name\\n\", $lucyObj->quality($name), \"\\n\";\n  }\n\n  Get all the sequences as Bio::PrimarySeq objects (eg., for use with\n  Bio::Tools::Run::StandaloneBlast to perform BLAST).\n\n  @seqObjs = $lucyObj->get_Seq_Objs();\n\n  Or use only those sequences that are full length and have a Poly-A\n  tail.\n\n  foreach $name (@$names) {\n      next unless ($lucyObj->full_length($name) and $lucy->polyA($name));\n      push @seqObjs, $lucyObj->get_Seq_Obj($name);\n  }\n\n\n  Get the names of those sequences that were rejected by Lucy.\n\n  $rejects_ref = $lucyObj->get_rejects();\n\n  Print the names of the rejects and 1 letter code for reason they\n  were rejected.\n\n  foreach $key (sort keys %$rejects_ref) {\n      print \"$key:  \", $rejects_ref->{$key};\n  }\n\n  There is a lot of other information available about the sequences\n  analyzed by Lucy (see APPENDIX).  This module can be used with the\n  DBI module to store this sequence information in a database.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules.  Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nAndrew G. Walsh\t\tpaeruginosa@hotmail.com\n\n=head1 APPENDIX\n\nMethods available to Lucy objects are described below.  Please note\nthat any method beginning with an underscore is considered internal\nand should not be called directly.\n\n\n\npackage Bio::Tools::Lucy;\n\nuse vars qw($AUTOLOAD @ATTR %OK_FIELD);\nuse strict;\nuse Bio::PrimarySeq;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n@ATTR = qw(seqfile qualfile stderrfile infofile lucy_verbose fwd_desig rev_desig adv_stderr); \nforeach my $attr (@ATTR) {\n    $OK_FIELD{$attr}++\n}\n\nsub AUTOLOAD {\n    my $self = shift;\n    my $attr = $AUTOLOAD;\n    $attr =~ s/.*:://;\n    $attr = lc $attr;\n    $self->throw(\"Unallowed parameter: $attr !\") unless $OK_FIELD{$attr};\n    $self->{$attr} = shift if @_;\n    return $self->{$attr};\n}\n\n=head2 new\n\n Title\t :  new\n Usage\t :  $lucyObj = Bio::Tools::Lucy->new(seqfile => lucy.seq, rev_desig => '_R', \n\t    fwd_desig => '_F')\n Function:  creates a Lucy object from Lucy analysis files\n Returns :  reference to Bio::Tools::Lucy object\n Args\t :  seqfile\tFasta sequence file generated by Lucy\n\t       qualfile\tQuality values file generated by Lucy\n\t       infofile\tInfo file created when Lucy is run with -debug \n                     'infofile' option\n\t       stderrfile\tStandard error captured from Lucy when Lucy is run \n\t\t\t with -info option and STDERR is directed to stderrfile \n\t\t\t (ie. lucy ... 2> stderrfile).\n\t\t\t Info in this file will include sequences dropped for low \n\t\t\t quality. If you've modified Lucy source (see adv_stderr below), \n\t\t\t it will also include info on which sequences were dropped because \n\t\t\t they were vector, too short, had no insert, and whether a poly-A \n\t\t\t tail was found (if Lucy was run with -cdna option).\n\t       lucy_verbose verbosity level (0-1).  \n\t       fwd_desig\tThe string used to determine whether sequence is a \n          forward read.  \n\t\t\t The parser will assume that this match will occus at the \n\t\t\t end of the sequence name string.\n\t       rev_desig\tAs above, for reverse reads. \n \t       adv_stderr\tCan be set to a true value (1).  Will only work if \n          you have modified \n\t\t\t the Lucy source code as outlined in DESCRIPTION and capture \n\t\t\t the standard error from Lucy.\n\nIf you don't provide filenames for qualfile, infofile or stderrfile,\nthe module will assume that .qual, .info, and .stderr are the file\nextensions and search in the same directory as the .seq file for these\nfiles.\n\nFor example, if you create a Lucy object with $lucyObj =\nBio::Tools::Lucy-E<gt>new(seqfile =E<gt>lucy.seq), the module will\nfind lucy.qual, lucy.info and lucy.stderr.\n\nYou can omit any or all of the quality, info or stderr files, but you\nwill not be able to use all of the object methods (see method\ndocumentation below).\n\n\nsub new {\n\tmy ($class,@args) = @_;\n\tmy $self = $class->SUPER::new(@args);\n\tmy ($attr, $value);\n\twhile (@args) {\n\t\t$attr = shift @args;\n\t\t$attr = lc $attr;\n\t\t$value = shift @args;\n\t\t$self->{$attr} = $value;\n\t}\n\t&_parse($self);\n\treturn $self;\n}\n\n=head2 _parse\n\n Title\t :  _parse\n Usage\t :  n/a (internal function)\n Function:  called by new() to parse Lucy output files\n Returns :  nothing\n Args\t :  none\n\n\nsub _parse {\n\tmy $self = shift;\n\t$self->{seqfile} =~ /^(\\S+)\\.\\S+$/;\n\tmy $file = $1;\n\n\t$self->warn(\"Opening $self->{seqfile} for parsing...\\n\") if $self->{lucy_verbose};\n\topen my $SEQ, $self->{seqfile} or $self->throw(\"Could not open sequence file: $self->{seqfile}\");\n\tmy ($name, $line);\n\tmy $seq = \"\";\n\tmy @lines = <$SEQ>;\n\twhile ($line = pop @lines) {\n\t\tchomp $line;\n\t\tif ($line =~ /^>(\\S+)\\s+(\\d+)\\s+(\\d+)\\s+(\\d+)\\s+(\\d+)\\s+(\\d+)/) {    \n\t\t\t$name = $1;\n\t\t\tif ($self->{fwd_desig}) {\n\t\t\t\t$self->{sequences}{$name}{direction} = \"F\" if $name =~ /^(\\S+)($self->{fwd_desig})$/;\n\t\t\t}\n\t\t\tif ($self->{rev_desig}) {\n\t\t\t\t$self->{sequences}{$name}{direction} = \"R\" if $name =~ /^(\\S+)($self->{rev_desig})$/;\n\t\t\t}\n\t\t\t$self->{sequences}{$name}{min_clone_len} = $2; # this is used for TIGR Assembler, as are $3 and $4\n\t\t\t$self->{sequences}{$name}{max_clone_len} = $3;\n\t\t\t$self->{sequences}{$name}{med_clone_len} = $4; \n\t\t\t$self->{sequences}{$name}{beg_clear} = $5;\n\t\t\t$self->{sequences}{$name}{end_clear} = $6;\n\t\t\t$self->{sequences}{$name}{length_raw} = $seq =~ tr/[AGCTN]//; # from what I've seen, these are the bases Phred calls.  Please let me know if I'm wrong.     \n\t\t\tmy $beg = $5-1; # substr function begins with index 0\n\t\t\t$seq = $self->{sequences}{$name}{sequence} = substr ($seq, $beg, $6-$beg);\n\t\t\tmy $count = $self->{sequences}{$name}{length_clear} = $seq =~ tr/[AGCTN]//;\n\t\t\tmy $countGC =  $seq =~ tr/[GC]//;\n\t\t\t$self->{sequences}{$name}{per_GC} = $countGC/$count * 100;\n\t\t\t$seq = \"\";\n\t\t}\n\t\telse {\n\t\t\t$seq = $line.$seq;\n\t\t}\n\t}\n\n\t# now parse quality values (check for presence of quality file first) \n\tif ($self->{qualfile}) {\n\t\topen my $QUAL, \"$self->{qualfile}\" or $self->throw(\"Could not open quality file: $self->{qualfile}\");\n\t\t@lines = <$QUAL>;\n\t}\n\telsif (-e \"$file.qual\") {\n\t\t$self->warn(\"You did not set qualfile, but I'm opening $file.qual\\n\") if $self->{lucy_verbose};\n\t$self->qualfile(\"$file.qual\");\n\t\topen my $QUAL, \"$file.qual\" or $self->throw(\"Could not open quality file: $file.qual\");\n\t\t@lines = <$QUAL>;\n\t}\n    else {\n\t\t $self->warn(\"I did not find a quality file.  You will not be able to use all of the accessor methods.\\n\") if $self->{lucy_verbose};\n\t\t @lines = ();\n    }\n\n\tmy (@vals, @slice, $num, $tot, $vals);  \n\tmy $qual = \"\"; \n\twhile ($line = pop @lines) {\n\t\tchomp $line;\n\t\tif ($line =~ /^>(\\S+)/) {\n\t\t\t$name = $1;\n\t\t\t@vals = split /\\s/ , $qual;\n\t\t\t@slice = @vals[$self->{sequences}{$name}{beg_clear} - 1 .. $self->{sequences}{$name}{end_clear} - 1];\n\t\t\t$vals = join \"\\t\", @slice;\n\t\t\t$self->{sequences}{$name}{quality} = $vals;\n\t\t\t$qual = \"\";\n\t\t\tforeach $num (@slice) {\n\t\t\t\t$tot += $num;\n\t\t\t}\n\t\t\t$num = @slice;\n\t\t\t$self->{sequences}{$name}{avg_quality} = $tot/$num;\n\t\t\t$tot = 0;\n\t\t}\n\t\telse {\n\t\t\t$qual = $line.$qual;\n\t\t}\n\t}\n\n\t# determine whether reads are full length\n\tif ($self->{infofile}) {\n\t\topen my $INFO, \"$self->{infofile}\" or $self->throw(\"Could not open info file: $self->{infofile}\");\n\t\t@lines = <$INFO>;\n\t}\n\telsif (-e \"$file.info\") {\n\t\t$self->warn(\"You did not set infofile, but I'm opening $file.info\\n\") if $self->{lucy_verbose};\n\t\t$self->infofile(\"$file.info\");\n\t\topen my $INFO, \"$file.info\" or $self->throw(\"Could not open info file: $file.info\");\n\t\t@lines = <$INFO>;\n\t}\n\telse {\n\t\t$self->warn(\"I did not find an info file.  You will not be able to use all of the accessor methods.\\n\") if $self->{lucy_verbose};\n\t\t@lines = ();\n\t}\n\n\tforeach (@lines) {\n\t\t/^(\\S+).+CLV\\s+(\\d+)\\s+(\\d+)$/;\n\t\tif ($2>0 && $3>0) {\n\t\t\t$self->{sequences}{$1}{full_length} = 1 if $self->{sequences}{$1}; # will show cleavage info for rejected sequences too\n\t\t}\n\t}\n\n\n\t# parse rejects (and presence of poly-A if Lucy has been modified)\n\tif ($self->{stderrfile}) {\n\t\topen my $STDERR_LUCY, \"$self->{stderrfile}\" or $self->throw(\"Could not open quality file: $self->{stderrfile}\");\n\t\t@lines = <$STDERR_LUCY>;\n\t}\n\telsif (-e \"$file.stderr\") {\n\t\t$self->warn(\"You did not set stderrfile, but I'm opening $file.stderr\\n\") if $self->{lucy_verbose};\n\t\t$self->stderrfile(\"$file.stderr\");\n\t\topen my $STDERR_LUCY, \"$file.stderr\" or $self->throw(\"Could not open quality file: $file.stderr\");\n\t\t@lines = <$STDERR_LUCY>;\n\t}\n\telse {\n\t\t$self->warn(\"I did not find a standard error file.  You will not be able to use all of the accessor methods.\\n\") if $self->{lucy_verbose};\n\t\t@lines = ();\n\t}\n\n\tif ($self->{adv_stderr}) {\n\t\tforeach (@lines) {\n\t\t\t$self->{reject}{$1} = \"Q\" if /dropping\\s+(\\S+)/;\n\t\t\t$self->{reject}{$1} = \"V\" if /Vector: (\\S+)/;\n\t\t\t$self->{reject}{$1} = \"E\" if /Empty: (\\S+)/;\n\t\t\t$self->{reject}{$1} = \"S\" if m{Short/ no insert: (\\S+)};\n\t\t\t$self->{sequences}{$1}{polyA} = 1 if /(\\S+) has PolyA/;\n\t\t\tif (/Dropped PolyA: (\\S+)/) {\n\t\t\t\t$self->{reject}{$1} = \"P\";\n\t\t\t\tdelete $self->{sequences}{$1};\n\t\t\t}\n\t\t}\n\t}\n\telse {\n\t\tforeach (@lines) {\n\t\t\t$self->{reject}{$1} = \"R\" if /dropping\\s+(\\S+)/;\n\t\t}\n\t}\n}\n\n=head2 get_Seq_Objs\n\n Title   :  get_Seq_Objs\n Usage   :  $lucyObj->get_Seq_Objs()\n Function:  returns an array of references to Bio::PrimarySeq objects \n\t    where -id = 'sequence name' and -seq = 'sequence'\n\n Returns :  array of Bio::PrimarySeq objects\n Args\t :  none\n\n\nsub get_Seq_Objs {\n    my $self = shift;\n    my($seqobj, @seqobjs);\n    foreach my $key (sort keys %{$self->{sequences}}) {\n\t$seqobj = Bio::PrimarySeq->new( -seq => \"$self->{sequences}{$key}{sequence}\",\n\t\t\t\t\t-id => \"$key\");\n\tpush @seqobjs, $seqobj;\n    }\n    return \\@seqobjs;\n} \n\n=head2 get_Seq_Obj\n\n Title   :  get_Seq_Obj\n Usage   :  $lucyObj->get_Seq_Obj($seqname)\n Function:  returns reference to a Bio::PrimarySeq object where -id = 'sequence name'\n\t    and -seq = 'sequence'\n Returns :  reference to Bio::PrimarySeq object\n Args\t :  name of a sequence \n\n\nsub get_Seq_Obj {\n    my ($self, $key) = @_;\n    my $seqobj = Bio::PrimarySeq->new( -seq => \"$self->{sequences}{$key}{sequence}\",\n                                    -id => \"$key\");\n    return $seqobj;\n}\n\n=head2 get_sequence_names\n\n Title   :  get_sequence_names\n Usage   :  $lucyObj->get_sequence_names\n Function:  returns reference to an array of names of the sequences analyzed by Lucy.\n\t    These names are required for most of the accessor methods.  \n\t    Note: The Lucy binary will fail unless sequence names are unique.\n Returns :  array reference\n Args\t :  none \n\n\nsub get_sequence_names {\n    my $self = shift;\n    my @keys = sort keys %{$self->{sequences}};\n    return \\@keys;\n}\n\n=head2 sequence\n\n Title   :  sequence\n Usage   :  $lucyObj->sequence($seqname)\n Function:  returns the DNA sequence of one of the sequences analyzed by Lucy.\n Returns :  string\n Args\t :  name of a sequence                   \n\n\nsub sequence {\n    my ($self, $key) = @_;\n    return $self->{sequences}{$key}{sequence};\n}\n\n=head2 quality\n\n Title   :  quality\n Usage   :  $lucyObj->quality($seqname)\n Function:  returns the quality values of one of the sequences analyzed by Lucy.\n\t    This method depends on the user having provided a quality file.\n Returns :  string\n Args    :  name of a sequence\n\n\nsub quality {\n    my($self, $key) = @_;\n    return $self->{sequences}{$key}{quality};\n}\n\n=head2 avg_quality\n\n Title   :  avg_quality\n Usage   :  $lucyObj->avg_quality($seqname)\n Function:  returns the average quality value for one of the sequences analyzed by Lucy.\n Returns :  float\n Args    :  name of a sequence\n\n\nsub avg_quality {\n    my($self, $key) = @_;\n    return $self->{sequences}{$key}{avg_quality};\n}\n\n=head2 direction\n\n Title   :  direction\n Usage   :  $lucyObj->direction($seqname)\n Function:  returns the direction for one of the sequences analyzed by Lucy\n\t    providing that 'fwd_desig' or 'rev_desig' were set when the\n \t    Lucy object was created.\n\t    Strings returned are: 'F' for forward, 'R' for reverse.  \n Returns :  string \n Args    :  name of a sequence\n\n\nsub direction {\n    my($self, $key) = @_;\n    return $self->{sequences}{$key}{direction} if $self->{sequences}{$key}{direction}; \n    return \"\";\n}\n\n=head2 length_raw\n\n Title   :  length_raw\n Usage   :  $lucyObj->length_raw($seqname)\n Function:  returns the length of a DNA sequence prior to quality/ vector \n\t    trimming by Lucy.\n Returns :  integer\n Args    :  name of a sequence\n\n\nsub length_raw {\n    my($self, $key) = @_;\n    return $self->{sequences}{$key}{length_raw};\n}\n\n=head2 length_clear\n\n Title   :  length_clear\n Usage   :  $lucyObj->length_clear($seqname)\n Function:  returns the length of a DNA sequence following quality/ vector   \n            trimming by Lucy.\n Returns :  integer\n Args    :  name of a sequence\n\n\nsub length_clear {\n    my($self, $key) = @_;\n    return $self->{sequences}{$key}{length_clear};\n}\n\n=head2 start_clear\n\n Title   :  start_clear\n Usage   :  $lucyObj->start_clear($seqname)\n Function:  returns the beginning position of good quality, vector free DNA sequence \n\t    determined by Lucy.\n Returns :  integer\n Args    :  name of a sequence\n\n\nsub start_clear {\n    my($self, $key) = @_;\n    return $self->{sequences}{$key}{beg_clear};\n}\n\n\n=head2 end_clear\n\n Title   :  end_clear\n Usage   :  $lucyObj->end_clear($seqname)\n Function:  returns the ending position of good quality, vector free DNA sequence\n            determined by Lucy.\n Returns :  integer\n Args    :  name of a sequence\n\n\nsub end_clear {\n    my($self, $key) = @_;\n    return $self->{sequences}{$key}{end_clear};\n}\n\n=head2 per_GC\n\n Title   :  per_GC\n Usage   :  $lucyObj->per_GC($seqname)\n Function:  returns the percente of the good quality, vector free DNA sequence\n            determined by Lucy.\n Returns :  float\n Args    :  name of a sequence\n\n\nsub per_GC {\n    my($self, $key) = @_;\n    return $self->{sequences}{$key}{per_GC};\n}\n\n=head2 full_length\n\n Title   :  full_length\n Usage   :  $lucyObj->full_length($seqname)\n Function:  returns the truth value for whether or not the sequence read was\n            full length (ie. vector present on both ends of read).  This method\n            depends on the user having provided the 'info' file (Lucy must be\n            run with the -debug 'info_filename' option to get this file).\n Returns :  boolean \n Args    :  name of a sequence","label":"full_length($self,$key)"},"detail":"($self,$key)","definition":"sub","containerName":"main::","children":[{"kind":13,"line":612,"name":"$self","definition":"my","containerName":"full_length","localvar":"my"},{"kind":13,"line":612,"containerName":"full_length","name":"$key"},{"containerName":"full_length","name":"$self","kind":13,"line":613},{"containerName":"full_length","name":"$key","kind":13,"line":613}],"line":611,"kind":12,"range":{"start":{"line":611,"character":0},"end":{"character":9999,"line":615}},"name":"full_length"},{"name":"sequences","line":613,"kind":12},{"kind":12,"line":613,"name":"full_length"},{"range":{"start":{"line":631,"character":0},"end":{"character":9999,"line":635}},"name":"polyA","line":631,"children":[{"localvar":"my","containerName":"polyA","definition":"my","name":"$self","line":632,"kind":13},{"containerName":"polyA","name":"$key","line":632,"kind":13},{"containerName":"polyA","name":"$self","kind":13,"line":633},{"containerName":"polyA","name":"$key","kind":13,"line":633}],"kind":12,"detail":"($self,$key)","signature":{"parameters":[{"label":"$self"},{"label":"$key"}],"documentation":"1;\n# $Id: Lucy.pm 16123 2009-09-17 12:57:27Z cjfields $ \n#\n# BioPerl module for Bio::Tools::Lucy\n#\n# Copyright Her Majesty the Queen of England\n# written by Andrew Walsh (paeruginosa@hotmail.com) during employment with \n# Agriculture and Agri-food Canada, Cereal Research Centre, Winnipeg, MB\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Lucy - Object for analyzing the output from Lucy,\n  a vector and quality trimming program from TIGR\n\n=head1 SYNOPSIS\n\n  # Create the Lucy object from an existing Lucy output file\n  @params = ('seqfile' => 'lucy.seq', 'lucy_verbose' => 1);\n  $lucyObj = Bio::Tools::Lucy->new(@params);\n\n  # Get names of all sequences\n  $names = $lucyObj->get_sequence_names();\n\n  #  Print seq and qual values for sequences >400 bp in order to run CAP3\n  foreach $name (@$names) {\n      next unless $lucyObj->length_clear($name) > 400;\n      print SEQ \">$name\\n\", $lucyObj->sequence($name), \"\\n\";\n      print QUAL \">$name\\n\", $lucyObj->quality($name), \"\\n\";\n  }\n\n  # Get an array of Bio::PrimarySeq objects\n  @seqObjs = $lucyObj->get_Seq_Objs();\n\n\n=head1 DESCRIPTION\n\nBio::Tools::Lucy.pm provides methods for analyzing the sequence and\nquality values generated by Lucy program from TIGR.\n\nLucy will identify vector, poly-A/T tails, and poor quality regions in\na sequence.  (www.genomics.purdue.edu/gcg/other/lucy.pdf)\n\nThe input to Lucy can be the Phred sequence and quality files\ngenerated from running Phred on a set of chromatograms.\n\nLucy can be obtained (free of charge to academic users) from\nwww.tigr.org/softlab\n\nThere are a few methods that will only be available if you make some\nminor changes to the source for Lucy and then recompile.  The changes\nare in the 'lucy.c' file and there is a diff between the original and\nthe modified file in the Appendix\n\nPlease contact the author of this module if you have any problems\nmaking these modifications.\n\nYou do not have to make these modifications to use this module.\n\n=head2 Creating a Lucy object\n\n  @params = ('seqfile' => 'lucy.seq', 'adv_stderr' => 1, \n\t     'fwd_desig' => '_F', 'rev_desig' => '_R');\n  $lucyObj = Bio::Tools::Lucy->new(@params);\n\n=head2 Using a Lucy object\n\n  You should get an array with the sequence names in order to use\n  accessor methods.  Note: The Lucy binary program will fail unless\n  the sequence names provided as input are unique.\n\n  $names_ref = $lucyObj->get_sequence_names();\n\n  This code snippet will produce a Fasta format file with sequence\n  lengths and %GC in the description line.\n\n  foreach $name (@$names) {\n      print FILE \">$name\\t\",\n\t\t $lucyObj->length_clear($name), \"\\t\",\n\t\t $lucyObj->per_GC($name), \"\\n\",\n\t\t $lucyObj->sequence($name), \"\\n\";\n  }\n\n\n  Print seq and qual values for sequences >400 bp in order to assemble\n  them with CAP3 (or other assembler).\n\n  foreach $name (@$names) {\n      next unless $lucyObj->length_clear($name) > 400;\n      print SEQ \">$name\\n\", $lucyObj->sequence($name), \"\\n\";\n      print QUAL \">$name\\n\", $lucyObj->quality($name), \"\\n\";\n  }\n\n  Get all the sequences as Bio::PrimarySeq objects (eg., for use with\n  Bio::Tools::Run::StandaloneBlast to perform BLAST).\n\n  @seqObjs = $lucyObj->get_Seq_Objs();\n\n  Or use only those sequences that are full length and have a Poly-A\n  tail.\n\n  foreach $name (@$names) {\n      next unless ($lucyObj->full_length($name) and $lucy->polyA($name));\n      push @seqObjs, $lucyObj->get_Seq_Obj($name);\n  }\n\n\n  Get the names of those sequences that were rejected by Lucy.\n\n  $rejects_ref = $lucyObj->get_rejects();\n\n  Print the names of the rejects and 1 letter code for reason they\n  were rejected.\n\n  foreach $key (sort keys %$rejects_ref) {\n      print \"$key:  \", $rejects_ref->{$key};\n  }\n\n  There is a lot of other information available about the sequences\n  analyzed by Lucy (see APPENDIX).  This module can be used with the\n  DBI module to store this sequence information in a database.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules.  Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nAndrew G. Walsh\t\tpaeruginosa@hotmail.com\n\n=head1 APPENDIX\n\nMethods available to Lucy objects are described below.  Please note\nthat any method beginning with an underscore is considered internal\nand should not be called directly.\n\n\n\npackage Bio::Tools::Lucy;\n\nuse vars qw($AUTOLOAD @ATTR %OK_FIELD);\nuse strict;\nuse Bio::PrimarySeq;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n@ATTR = qw(seqfile qualfile stderrfile infofile lucy_verbose fwd_desig rev_desig adv_stderr); \nforeach my $attr (@ATTR) {\n    $OK_FIELD{$attr}++\n}\n\nsub AUTOLOAD {\n    my $self = shift;\n    my $attr = $AUTOLOAD;\n    $attr =~ s/.*:://;\n    $attr = lc $attr;\n    $self->throw(\"Unallowed parameter: $attr !\") unless $OK_FIELD{$attr};\n    $self->{$attr} = shift if @_;\n    return $self->{$attr};\n}\n\n=head2 new\n\n Title\t :  new\n Usage\t :  $lucyObj = Bio::Tools::Lucy->new(seqfile => lucy.seq, rev_desig => '_R', \n\t    fwd_desig => '_F')\n Function:  creates a Lucy object from Lucy analysis files\n Returns :  reference to Bio::Tools::Lucy object\n Args\t :  seqfile\tFasta sequence file generated by Lucy\n\t       qualfile\tQuality values file generated by Lucy\n\t       infofile\tInfo file created when Lucy is run with -debug \n                     'infofile' option\n\t       stderrfile\tStandard error captured from Lucy when Lucy is run \n\t\t\t with -info option and STDERR is directed to stderrfile \n\t\t\t (ie. lucy ... 2> stderrfile).\n\t\t\t Info in this file will include sequences dropped for low \n\t\t\t quality. If you've modified Lucy source (see adv_stderr below), \n\t\t\t it will also include info on which sequences were dropped because \n\t\t\t they were vector, too short, had no insert, and whether a poly-A \n\t\t\t tail was found (if Lucy was run with -cdna option).\n\t       lucy_verbose verbosity level (0-1).  \n\t       fwd_desig\tThe string used to determine whether sequence is a \n          forward read.  \n\t\t\t The parser will assume that this match will occus at the \n\t\t\t end of the sequence name string.\n\t       rev_desig\tAs above, for reverse reads. \n \t       adv_stderr\tCan be set to a true value (1).  Will only work if \n          you have modified \n\t\t\t the Lucy source code as outlined in DESCRIPTION and capture \n\t\t\t the standard error from Lucy.\n\nIf you don't provide filenames for qualfile, infofile or stderrfile,\nthe module will assume that .qual, .info, and .stderr are the file\nextensions and search in the same directory as the .seq file for these\nfiles.\n\nFor example, if you create a Lucy object with $lucyObj =\nBio::Tools::Lucy-E<gt>new(seqfile =E<gt>lucy.seq), the module will\nfind lucy.qual, lucy.info and lucy.stderr.\n\nYou can omit any or all of the quality, info or stderr files, but you\nwill not be able to use all of the object methods (see method\ndocumentation below).\n\n\nsub new {\n\tmy ($class,@args) = @_;\n\tmy $self = $class->SUPER::new(@args);\n\tmy ($attr, $value);\n\twhile (@args) {\n\t\t$attr = shift @args;\n\t\t$attr = lc $attr;\n\t\t$value = shift @args;\n\t\t$self->{$attr} = $value;\n\t}\n\t&_parse($self);\n\treturn $self;\n}\n\n=head2 _parse\n\n Title\t :  _parse\n Usage\t :  n/a (internal function)\n Function:  called by new() to parse Lucy output files\n Returns :  nothing\n Args\t :  none\n\n\nsub _parse {\n\tmy $self = shift;\n\t$self->{seqfile} =~ /^(\\S+)\\.\\S+$/;\n\tmy $file = $1;\n\n\t$self->warn(\"Opening $self->{seqfile} for parsing...\\n\") if $self->{lucy_verbose};\n\topen my $SEQ, $self->{seqfile} or $self->throw(\"Could not open sequence file: $self->{seqfile}\");\n\tmy ($name, $line);\n\tmy $seq = \"\";\n\tmy @lines = <$SEQ>;\n\twhile ($line = pop @lines) {\n\t\tchomp $line;\n\t\tif ($line =~ /^>(\\S+)\\s+(\\d+)\\s+(\\d+)\\s+(\\d+)\\s+(\\d+)\\s+(\\d+)/) {    \n\t\t\t$name = $1;\n\t\t\tif ($self->{fwd_desig}) {\n\t\t\t\t$self->{sequences}{$name}{direction} = \"F\" if $name =~ /^(\\S+)($self->{fwd_desig})$/;\n\t\t\t}\n\t\t\tif ($self->{rev_desig}) {\n\t\t\t\t$self->{sequences}{$name}{direction} = \"R\" if $name =~ /^(\\S+)($self->{rev_desig})$/;\n\t\t\t}\n\t\t\t$self->{sequences}{$name}{min_clone_len} = $2; # this is used for TIGR Assembler, as are $3 and $4\n\t\t\t$self->{sequences}{$name}{max_clone_len} = $3;\n\t\t\t$self->{sequences}{$name}{med_clone_len} = $4; \n\t\t\t$self->{sequences}{$name}{beg_clear} = $5;\n\t\t\t$self->{sequences}{$name}{end_clear} = $6;\n\t\t\t$self->{sequences}{$name}{length_raw} = $seq =~ tr/[AGCTN]//; # from what I've seen, these are the bases Phred calls.  Please let me know if I'm wrong.     \n\t\t\tmy $beg = $5-1; # substr function begins with index 0\n\t\t\t$seq = $self->{sequences}{$name}{sequence} = substr ($seq, $beg, $6-$beg);\n\t\t\tmy $count = $self->{sequences}{$name}{length_clear} = $seq =~ tr/[AGCTN]//;\n\t\t\tmy $countGC =  $seq =~ tr/[GC]//;\n\t\t\t$self->{sequences}{$name}{per_GC} = $countGC/$count * 100;\n\t\t\t$seq = \"\";\n\t\t}\n\t\telse {\n\t\t\t$seq = $line.$seq;\n\t\t}\n\t}\n\n\t# now parse quality values (check for presence of quality file first) \n\tif ($self->{qualfile}) {\n\t\topen my $QUAL, \"$self->{qualfile}\" or $self->throw(\"Could not open quality file: $self->{qualfile}\");\n\t\t@lines = <$QUAL>;\n\t}\n\telsif (-e \"$file.qual\") {\n\t\t$self->warn(\"You did not set qualfile, but I'm opening $file.qual\\n\") if $self->{lucy_verbose};\n\t$self->qualfile(\"$file.qual\");\n\t\topen my $QUAL, \"$file.qual\" or $self->throw(\"Could not open quality file: $file.qual\");\n\t\t@lines = <$QUAL>;\n\t}\n    else {\n\t\t $self->warn(\"I did not find a quality file.  You will not be able to use all of the accessor methods.\\n\") if $self->{lucy_verbose};\n\t\t @lines = ();\n    }\n\n\tmy (@vals, @slice, $num, $tot, $vals);  \n\tmy $qual = \"\"; \n\twhile ($line = pop @lines) {\n\t\tchomp $line;\n\t\tif ($line =~ /^>(\\S+)/) {\n\t\t\t$name = $1;\n\t\t\t@vals = split /\\s/ , $qual;\n\t\t\t@slice = @vals[$self->{sequences}{$name}{beg_clear} - 1 .. $self->{sequences}{$name}{end_clear} - 1];\n\t\t\t$vals = join \"\\t\", @slice;\n\t\t\t$self->{sequences}{$name}{quality} = $vals;\n\t\t\t$qual = \"\";\n\t\t\tforeach $num (@slice) {\n\t\t\t\t$tot += $num;\n\t\t\t}\n\t\t\t$num = @slice;\n\t\t\t$self->{sequences}{$name}{avg_quality} = $tot/$num;\n\t\t\t$tot = 0;\n\t\t}\n\t\telse {\n\t\t\t$qual = $line.$qual;\n\t\t}\n\t}\n\n\t# determine whether reads are full length\n\tif ($self->{infofile}) {\n\t\topen my $INFO, \"$self->{infofile}\" or $self->throw(\"Could not open info file: $self->{infofile}\");\n\t\t@lines = <$INFO>;\n\t}\n\telsif (-e \"$file.info\") {\n\t\t$self->warn(\"You did not set infofile, but I'm opening $file.info\\n\") if $self->{lucy_verbose};\n\t\t$self->infofile(\"$file.info\");\n\t\topen my $INFO, \"$file.info\" or $self->throw(\"Could not open info file: $file.info\");\n\t\t@lines = <$INFO>;\n\t}\n\telse {\n\t\t$self->warn(\"I did not find an info file.  You will not be able to use all of the accessor methods.\\n\") if $self->{lucy_verbose};\n\t\t@lines = ();\n\t}\n\n\tforeach (@lines) {\n\t\t/^(\\S+).+CLV\\s+(\\d+)\\s+(\\d+)$/;\n\t\tif ($2>0 && $3>0) {\n\t\t\t$self->{sequences}{$1}{full_length} = 1 if $self->{sequences}{$1}; # will show cleavage info for rejected sequences too\n\t\t}\n\t}\n\n\n\t# parse rejects (and presence of poly-A if Lucy has been modified)\n\tif ($self->{stderrfile}) {\n\t\topen my $STDERR_LUCY, \"$self->{stderrfile}\" or $self->throw(\"Could not open quality file: $self->{stderrfile}\");\n\t\t@lines = <$STDERR_LUCY>;\n\t}\n\telsif (-e \"$file.stderr\") {\n\t\t$self->warn(\"You did not set stderrfile, but I'm opening $file.stderr\\n\") if $self->{lucy_verbose};\n\t\t$self->stderrfile(\"$file.stderr\");\n\t\topen my $STDERR_LUCY, \"$file.stderr\" or $self->throw(\"Could not open quality file: $file.stderr\");\n\t\t@lines = <$STDERR_LUCY>;\n\t}\n\telse {\n\t\t$self->warn(\"I did not find a standard error file.  You will not be able to use all of the accessor methods.\\n\") if $self->{lucy_verbose};\n\t\t@lines = ();\n\t}\n\n\tif ($self->{adv_stderr}) {\n\t\tforeach (@lines) {\n\t\t\t$self->{reject}{$1} = \"Q\" if /dropping\\s+(\\S+)/;\n\t\t\t$self->{reject}{$1} = \"V\" if /Vector: (\\S+)/;\n\t\t\t$self->{reject}{$1} = \"E\" if /Empty: (\\S+)/;\n\t\t\t$self->{reject}{$1} = \"S\" if m{Short/ no insert: (\\S+)};\n\t\t\t$self->{sequences}{$1}{polyA} = 1 if /(\\S+) has PolyA/;\n\t\t\tif (/Dropped PolyA: (\\S+)/) {\n\t\t\t\t$self->{reject}{$1} = \"P\";\n\t\t\t\tdelete $self->{sequences}{$1};\n\t\t\t}\n\t\t}\n\t}\n\telse {\n\t\tforeach (@lines) {\n\t\t\t$self->{reject}{$1} = \"R\" if /dropping\\s+(\\S+)/;\n\t\t}\n\t}\n}\n\n=head2 get_Seq_Objs\n\n Title   :  get_Seq_Objs\n Usage   :  $lucyObj->get_Seq_Objs()\n Function:  returns an array of references to Bio::PrimarySeq objects \n\t    where -id = 'sequence name' and -seq = 'sequence'\n\n Returns :  array of Bio::PrimarySeq objects\n Args\t :  none\n\n\nsub get_Seq_Objs {\n    my $self = shift;\n    my($seqobj, @seqobjs);\n    foreach my $key (sort keys %{$self->{sequences}}) {\n\t$seqobj = Bio::PrimarySeq->new( -seq => \"$self->{sequences}{$key}{sequence}\",\n\t\t\t\t\t-id => \"$key\");\n\tpush @seqobjs, $seqobj;\n    }\n    return \\@seqobjs;\n} \n\n=head2 get_Seq_Obj\n\n Title   :  get_Seq_Obj\n Usage   :  $lucyObj->get_Seq_Obj($seqname)\n Function:  returns reference to a Bio::PrimarySeq object where -id = 'sequence name'\n\t    and -seq = 'sequence'\n Returns :  reference to Bio::PrimarySeq object\n Args\t :  name of a sequence \n\n\nsub get_Seq_Obj {\n    my ($self, $key) = @_;\n    my $seqobj = Bio::PrimarySeq->new( -seq => \"$self->{sequences}{$key}{sequence}\",\n                                    -id => \"$key\");\n    return $seqobj;\n}\n\n=head2 get_sequence_names\n\n Title   :  get_sequence_names\n Usage   :  $lucyObj->get_sequence_names\n Function:  returns reference to an array of names of the sequences analyzed by Lucy.\n\t    These names are required for most of the accessor methods.  \n\t    Note: The Lucy binary will fail unless sequence names are unique.\n Returns :  array reference\n Args\t :  none \n\n\nsub get_sequence_names {\n    my $self = shift;\n    my @keys = sort keys %{$self->{sequences}};\n    return \\@keys;\n}\n\n=head2 sequence\n\n Title   :  sequence\n Usage   :  $lucyObj->sequence($seqname)\n Function:  returns the DNA sequence of one of the sequences analyzed by Lucy.\n Returns :  string\n Args\t :  name of a sequence                   \n\n\nsub sequence {\n    my ($self, $key) = @_;\n    return $self->{sequences}{$key}{sequence};\n}\n\n=head2 quality\n\n Title   :  quality\n Usage   :  $lucyObj->quality($seqname)\n Function:  returns the quality values of one of the sequences analyzed by Lucy.\n\t    This method depends on the user having provided a quality file.\n Returns :  string\n Args    :  name of a sequence\n\n\nsub quality {\n    my($self, $key) = @_;\n    return $self->{sequences}{$key}{quality};\n}\n\n=head2 avg_quality\n\n Title   :  avg_quality\n Usage   :  $lucyObj->avg_quality($seqname)\n Function:  returns the average quality value for one of the sequences analyzed by Lucy.\n Returns :  float\n Args    :  name of a sequence\n\n\nsub avg_quality {\n    my($self, $key) = @_;\n    return $self->{sequences}{$key}{avg_quality};\n}\n\n=head2 direction\n\n Title   :  direction\n Usage   :  $lucyObj->direction($seqname)\n Function:  returns the direction for one of the sequences analyzed by Lucy\n\t    providing that 'fwd_desig' or 'rev_desig' were set when the\n \t    Lucy object was created.\n\t    Strings returned are: 'F' for forward, 'R' for reverse.  \n Returns :  string \n Args    :  name of a sequence\n\n\nsub direction {\n    my($self, $key) = @_;\n    return $self->{sequences}{$key}{direction} if $self->{sequences}{$key}{direction}; \n    return \"\";\n}\n\n=head2 length_raw\n\n Title   :  length_raw\n Usage   :  $lucyObj->length_raw($seqname)\n Function:  returns the length of a DNA sequence prior to quality/ vector \n\t    trimming by Lucy.\n Returns :  integer\n Args    :  name of a sequence\n\n\nsub length_raw {\n    my($self, $key) = @_;\n    return $self->{sequences}{$key}{length_raw};\n}\n\n=head2 length_clear\n\n Title   :  length_clear\n Usage   :  $lucyObj->length_clear($seqname)\n Function:  returns the length of a DNA sequence following quality/ vector   \n            trimming by Lucy.\n Returns :  integer\n Args    :  name of a sequence\n\n\nsub length_clear {\n    my($self, $key) = @_;\n    return $self->{sequences}{$key}{length_clear};\n}\n\n=head2 start_clear\n\n Title   :  start_clear\n Usage   :  $lucyObj->start_clear($seqname)\n Function:  returns the beginning position of good quality, vector free DNA sequence \n\t    determined by Lucy.\n Returns :  integer\n Args    :  name of a sequence\n\n\nsub start_clear {\n    my($self, $key) = @_;\n    return $self->{sequences}{$key}{beg_clear};\n}\n\n\n=head2 end_clear\n\n Title   :  end_clear\n Usage   :  $lucyObj->end_clear($seqname)\n Function:  returns the ending position of good quality, vector free DNA sequence\n            determined by Lucy.\n Returns :  integer\n Args    :  name of a sequence\n\n\nsub end_clear {\n    my($self, $key) = @_;\n    return $self->{sequences}{$key}{end_clear};\n}\n\n=head2 per_GC\n\n Title   :  per_GC\n Usage   :  $lucyObj->per_GC($seqname)\n Function:  returns the percente of the good quality, vector free DNA sequence\n            determined by Lucy.\n Returns :  float\n Args    :  name of a sequence\n\n\nsub per_GC {\n    my($self, $key) = @_;\n    return $self->{sequences}{$key}{per_GC};\n}\n\n=head2 full_length\n\n Title   :  full_length\n Usage   :  $lucyObj->full_length($seqname)\n Function:  returns the truth value for whether or not the sequence read was\n            full length (ie. vector present on both ends of read).  This method\n            depends on the user having provided the 'info' file (Lucy must be\n            run with the -debug 'info_filename' option to get this file).\n Returns :  boolean \n Args    :  name of a sequence\n\n\nsub full_length {\n    my($self, $key) = @_;\n    return 1 if $self->{sequences}{$key}{full_length};\n    return 0;\n}\n\n=head2 polyA\n\n Title   :  polyA\n Usage   :  $lucyObj->polyA($seqname)\n Function:  returns the truth value for whether or not a poly-A tail was detected\n            and clipped by Lucy.  This method depends on the user having modified\n            the source for Lucy as outlined in DESCRIPTION and invoking Lucy with\n            the -cdna option and saving the standard error.\n            Note, the final sequence will not show the poly-A/T region.\n Returns :  boolean\n Args    :  name of a sequence","label":"polyA($self,$key)"},"containerName":"main::","definition":"sub"},{"name":"sequences","kind":12,"line":633},{"name":"polyA","line":633,"kind":12},{"name":"get_rejects","definition":"sub","containerName":"main::","range":{"end":{"line":659,"character":9999},"start":{"line":656,"character":0}},"kind":12,"children":[{"containerName":"get_rejects","definition":"my","name":"$self","localvar":"my","kind":13,"line":657},{"kind":13,"line":658,"containerName":"get_rejects","name":"$self"}],"line":656},{"name":"reject","kind":12,"line":658}]}