{"version":5,"vars":[{"containerName":"","name":"base","line":136,"kind":2},{"containerName":"main::","definition":"sub","detail":"($self,@args)","signature":{"label":"_initialize_state($self,@args)","documentation":"","parameters":[{"label":"$self"},{"label":"@args"}]},"kind":12,"line":138,"children":[{"localvar":"my","containerName":"_initialize_state","definition":"my","name":"$self","line":139,"kind":13},{"containerName":"_initialize_state","name":"@args","line":139,"kind":13},{"localvar":"my","name":"$make","definition":"my","containerName":"_initialize_state","line":142,"kind":13},{"containerName":"_initialize_state","name":"$self","line":142,"kind":13},{"name":"@args","containerName":"_initialize_state","line":142,"kind":13},{"containerName":"_initialize_state","name":"$self","kind":13,"line":144},{"containerName":"_initialize_state","name":"$self","line":146,"kind":13}],"name":"_initialize_state","range":{"start":{"line":138,"character":0},"end":{"character":9999,"line":147}}},{"kind":12,"line":142,"containerName":"_initialize_state","name":"SUPER"},{"containerName":"main::","definition":"sub","detail":"($class,@args)","signature":{"parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: Glimmer.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Glimmer\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Glimmer - parser for Glimmer 2.X/3.X prokaryotic and \nGlimmerM/GlimmerHMM eukaryotic gene predictions\n\n=head1 SYNOPSIS\n\n   use Bio::Tools::Glimmer;\n\n   # file\n   my $parser = Bio::Tools::Glimmer->new(-file => $file);\n   # filehandle:\n   $parser = Bio::Tools::Glimmer->new( -fh  => \\*INPUT );\n   # provide a sequence identifier (Glimmer 2.X)\n   my $parser = Bio::Tools::Glimmer->new(-file => $file, -seqname => seqname);\n   # force format (override automatic detection)\n   my $parser = Bio::Tools::Glimmer->new(-file => $file, -format => 'GlimmerM');\n\n   # parse the results\n   # note: this class is-a Bio::Tools::AnalysisResult which implements\n   # Bio::SeqAnalysisParserI, i.e., $glimmer->next_feature() is the same\n\n   while(my $gene = $parser->next_prediction()) {\n       # For eukaryotic input (GlimmerM/GlimmerHMM), $gene will be an instance\n       # of Bio::Tools::Prediction::Gene, which inherits off\n       # Bio::SeqFeature::Gene::Transcript, and $gene->exons() will return an\n       # array of Bio::Tools::Prediction::Exon objects.\n       # For prokaryotic input (Glimmer2.X/Glimmer3.X), $gene will be an\n       # instance of Bio::SeqFeature::Generic\n\n       # all exons (eukaryotic only):\n       @exon_arr = $gene->exons();\n       # initial exons only\n       @init_exons = $gene->exons('Initial');\n       # internal exons only\n       @intrl_exons = $gene->exons('Internal');\n       # terminal exons only\n       @term_exons = $gene->exons('Terminal');\n   }\n\n=head1 DESCRIPTION\n\nThis is a module for parsing Glimmer, GlimmerM and GlimmerHMM predictions.  \nIt will create gene objects from the prediction report which can \nbe attached to a sequence using Bioperl objects, or output as GFF \nsuitable for loading into Bio::DB::GFF for use with Gbrowse.\n\nGlimmer is open source and available at\nL<http://www.cbcb.umd.edu/software/glimmer/>.\n\nGlimmerM is open source and available at \nL<http://www.tigr.org/software/glimmerm/>.\n\nGlimmerHMM is open source and available at\nL<http://www.cbcb.umd.edu/software/GlimmerHMM/>.\n\nNote that Glimmer 2.X will only process the first\nsequence in a fasta file, and the prediction report does not contain any\nsort of sequence identifier\n\nNote that Glimmer 3.X produces two output files.  This module only parses\nthe .predict file.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nemail or the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nTorsten Seemann\n\nMark Johnson\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Glimmer;\nuse strict;\n\nuse Bio::Factory::FTLocationFactory;\nuse Bio::Tools::Prediction::Gene;\nuse Bio::Tools::Prediction::Exon;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\nsub _initialize_state {\n    my($self,@args) = @_;\n\n    # first call the inherited method!\n    my $make = $self->SUPER::_initialize_state(@args);\n\n    $self->{'_preds_parsed'} = 0;\n    # array of pre-parsed predictions\n    $self->{'_preds'} = [];\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::Glimmer->new();\n Function: Builds a new Bio::Tools::Glimmer object \n Returns : an instance of Bio::Tools::Glimmer\n Args    : format ('Glimmer', 'GlimmerM', 'GlimmerHMM'), seqname","label":"new($class,@args)"},"kind":12,"line":160,"children":[{"kind":13,"line":161,"containerName":"new","name":"$class","definition":"my","localvar":"my"},{"line":161,"kind":13,"name":"@args","containerName":"new"},{"kind":13,"line":163,"containerName":"new","name":"$self","definition":"my","localvar":"my"},{"containerName":"new","name":"$class","kind":13,"line":163},{"containerName":"new","name":"@args","kind":13,"line":163},{"line":165,"kind":13,"localvar":"my","name":"$format","definition":"my","containerName":"new"},{"kind":13,"line":165,"containerName":"new","name":"$seqname"},{"kind":13,"line":165,"containerName":"new","name":"$seqlength"},{"containerName":"new","name":"$detail","line":165,"kind":13},{"kind":13,"line":166,"name":"$self","containerName":"new"},{"kind":12,"line":166,"containerName":"new","name":"_rearrange"},{"containerName":"new","name":"@args","kind":13,"line":166},{"line":169,"kind":13,"name":"$format","containerName":"new"},{"containerName":"new","name":"$format","line":170,"kind":13},{"containerName":"new","name":"$format","line":171,"kind":13},{"containerName":"new","name":"$format","kind":13,"line":172},{"kind":13,"line":174,"containerName":"new","name":"$self"},{"kind":12,"line":174,"containerName":"new","name":"_format"},{"containerName":"new","name":"$format","kind":13,"line":174},{"name":"$detail","containerName":"new","kind":13,"line":177},{"line":178,"kind":13,"containerName":"new","name":"$self"},{"containerName":"new","name":"_format","line":178,"kind":12},{"kind":13,"line":179,"containerName":"new","name":"$self"},{"kind":12,"line":179,"name":"_detail_file","containerName":"new"},{"line":179,"kind":13,"name":"$detail","containerName":"new"},{"kind":13,"line":183,"containerName":"new","name":"$self"},{"kind":12,"line":183,"name":"_seqname","containerName":"new"},{"line":183,"kind":13,"containerName":"new","name":"$seqname"},{"kind":13,"line":183,"name":"$seqname","containerName":"new"},{"kind":13,"line":186,"containerName":"new","name":"$self"},{"line":186,"kind":12,"containerName":"new","name":"_seqlength"},{"kind":13,"line":186,"name":"$seqlength","containerName":"new"},{"line":186,"kind":13,"name":"$seqlength","containerName":"new"},{"name":"$self","containerName":"new","line":188,"kind":13}],"name":"new","range":{"end":{"line":189,"character":9999},"start":{"character":0,"line":160}}},{"containerName":"new","name":"SUPER","line":163,"kind":12},{"range":{"start":{"line":202,"character":0},"end":{"character":9999,"line":209}},"name":"analysis_method","signature":{"label":"analysis_method($self,$method)","parameters":[{"label":"$self"},{"label":"$method"}],"documentation":"1;\n# $Id: Glimmer.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Glimmer\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Glimmer - parser for Glimmer 2.X/3.X prokaryotic and \nGlimmerM/GlimmerHMM eukaryotic gene predictions\n\n=head1 SYNOPSIS\n\n   use Bio::Tools::Glimmer;\n\n   # file\n   my $parser = Bio::Tools::Glimmer->new(-file => $file);\n   # filehandle:\n   $parser = Bio::Tools::Glimmer->new( -fh  => \\*INPUT );\n   # provide a sequence identifier (Glimmer 2.X)\n   my $parser = Bio::Tools::Glimmer->new(-file => $file, -seqname => seqname);\n   # force format (override automatic detection)\n   my $parser = Bio::Tools::Glimmer->new(-file => $file, -format => 'GlimmerM');\n\n   # parse the results\n   # note: this class is-a Bio::Tools::AnalysisResult which implements\n   # Bio::SeqAnalysisParserI, i.e., $glimmer->next_feature() is the same\n\n   while(my $gene = $parser->next_prediction()) {\n       # For eukaryotic input (GlimmerM/GlimmerHMM), $gene will be an instance\n       # of Bio::Tools::Prediction::Gene, which inherits off\n       # Bio::SeqFeature::Gene::Transcript, and $gene->exons() will return an\n       # array of Bio::Tools::Prediction::Exon objects.\n       # For prokaryotic input (Glimmer2.X/Glimmer3.X), $gene will be an\n       # instance of Bio::SeqFeature::Generic\n\n       # all exons (eukaryotic only):\n       @exon_arr = $gene->exons();\n       # initial exons only\n       @init_exons = $gene->exons('Initial');\n       # internal exons only\n       @intrl_exons = $gene->exons('Internal');\n       # terminal exons only\n       @term_exons = $gene->exons('Terminal');\n   }\n\n=head1 DESCRIPTION\n\nThis is a module for parsing Glimmer, GlimmerM and GlimmerHMM predictions.  \nIt will create gene objects from the prediction report which can \nbe attached to a sequence using Bioperl objects, or output as GFF \nsuitable for loading into Bio::DB::GFF for use with Gbrowse.\n\nGlimmer is open source and available at\nL<http://www.cbcb.umd.edu/software/glimmer/>.\n\nGlimmerM is open source and available at \nL<http://www.tigr.org/software/glimmerm/>.\n\nGlimmerHMM is open source and available at\nL<http://www.cbcb.umd.edu/software/GlimmerHMM/>.\n\nNote that Glimmer 2.X will only process the first\nsequence in a fasta file, and the prediction report does not contain any\nsort of sequence identifier\n\nNote that Glimmer 3.X produces two output files.  This module only parses\nthe .predict file.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nemail or the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nTorsten Seemann\n\nMark Johnson\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Glimmer;\nuse strict;\n\nuse Bio::Factory::FTLocationFactory;\nuse Bio::Tools::Prediction::Gene;\nuse Bio::Tools::Prediction::Exon;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\nsub _initialize_state {\n    my($self,@args) = @_;\n\n    # first call the inherited method!\n    my $make = $self->SUPER::_initialize_state(@args);\n\n    $self->{'_preds_parsed'} = 0;\n    # array of pre-parsed predictions\n    $self->{'_preds'} = [];\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::Glimmer->new();\n Function: Builds a new Bio::Tools::Glimmer object \n Returns : an instance of Bio::Tools::Glimmer\n Args    : format ('Glimmer', 'GlimmerM', 'GlimmerHMM'), seqname\n\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  my ($format, $seqname, $seqlength, $detail) =\n      $self->_rearrange([qw(FORMAT SEQNAME SEQLENGTH DETAIL)], @args);\n\n  # override automagic format detection\n  if (defined($format) &&\n      (($format eq 'Glimmer')  ||\n       ($format eq 'GlimmerM') ||\n       ($format eq 'GlimmerHMM'))\n  ) {\n      $self->_format($format);\n  }\n  \n  if (defined($detail)) {\n      $self->_format('Glimmer');\n      $self->_detail_file($detail);\n  }\n  \n  # hardwire seq_id when creating gene and exon objects (Glimmer 2.X)\n  $self->_seqname($seqname) if defined($seqname);\n  \n  # store the length of the input sequence (Glimmer 2.X)\n  $self->_seqlength($seqlength) if defined($seqlength);\n  \n  return $self;\n}\n\n=head2 analysis_method\n\n Usage     : $glimmer->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /glimmer/i.\n Returns   : String\n Argument  : n/a"},"detail":"($self,$method)","definition":"sub","containerName":"main::","children":[{"name":"$self","definition":"my","containerName":"analysis_method","localvar":"my","kind":13,"line":204},{"name":"$method","containerName":"analysis_method","kind":13,"line":204},{"line":205,"kind":13,"name":"$method","containerName":"analysis_method"},{"line":205,"kind":13,"name":"$method","containerName":"analysis_method"},{"containerName":"analysis_method","name":"$self","line":206,"kind":13},{"kind":12,"line":206,"containerName":"analysis_method","name":"throw"},{"kind":13,"line":206,"name":"$self","containerName":"analysis_method"},{"kind":13,"line":208,"containerName":"analysis_method","name":"$self"},{"containerName":"analysis_method","name":"$method","line":208,"kind":13}],"line":202,"kind":12},{"line":208,"kind":12,"containerName":"analysis_method","name":"SUPER"},{"range":{"start":{"character":0,"line":231},"end":{"character":9999,"line":237}},"name":"next_feature","children":[{"localvar":"my","containerName":"next_feature","name":"$self","definition":"my","line":232,"kind":13},{"name":"@args","containerName":"next_feature","kind":13,"line":232},{"kind":13,"line":236,"containerName":"next_feature","name":"$self"},{"name":"next_prediction","containerName":"next_feature","kind":12,"line":236},{"line":236,"kind":13,"name":"@args","containerName":"next_feature"}],"line":231,"kind":12,"signature":{"label":"next_feature($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: Glimmer.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Glimmer\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Glimmer - parser for Glimmer 2.X/3.X prokaryotic and \nGlimmerM/GlimmerHMM eukaryotic gene predictions\n\n=head1 SYNOPSIS\n\n   use Bio::Tools::Glimmer;\n\n   # file\n   my $parser = Bio::Tools::Glimmer->new(-file => $file);\n   # filehandle:\n   $parser = Bio::Tools::Glimmer->new( -fh  => \\*INPUT );\n   # provide a sequence identifier (Glimmer 2.X)\n   my $parser = Bio::Tools::Glimmer->new(-file => $file, -seqname => seqname);\n   # force format (override automatic detection)\n   my $parser = Bio::Tools::Glimmer->new(-file => $file, -format => 'GlimmerM');\n\n   # parse the results\n   # note: this class is-a Bio::Tools::AnalysisResult which implements\n   # Bio::SeqAnalysisParserI, i.e., $glimmer->next_feature() is the same\n\n   while(my $gene = $parser->next_prediction()) {\n       # For eukaryotic input (GlimmerM/GlimmerHMM), $gene will be an instance\n       # of Bio::Tools::Prediction::Gene, which inherits off\n       # Bio::SeqFeature::Gene::Transcript, and $gene->exons() will return an\n       # array of Bio::Tools::Prediction::Exon objects.\n       # For prokaryotic input (Glimmer2.X/Glimmer3.X), $gene will be an\n       # instance of Bio::SeqFeature::Generic\n\n       # all exons (eukaryotic only):\n       @exon_arr = $gene->exons();\n       # initial exons only\n       @init_exons = $gene->exons('Initial');\n       # internal exons only\n       @intrl_exons = $gene->exons('Internal');\n       # terminal exons only\n       @term_exons = $gene->exons('Terminal');\n   }\n\n=head1 DESCRIPTION\n\nThis is a module for parsing Glimmer, GlimmerM and GlimmerHMM predictions.  \nIt will create gene objects from the prediction report which can \nbe attached to a sequence using Bioperl objects, or output as GFF \nsuitable for loading into Bio::DB::GFF for use with Gbrowse.\n\nGlimmer is open source and available at\nL<http://www.cbcb.umd.edu/software/glimmer/>.\n\nGlimmerM is open source and available at \nL<http://www.tigr.org/software/glimmerm/>.\n\nGlimmerHMM is open source and available at\nL<http://www.cbcb.umd.edu/software/GlimmerHMM/>.\n\nNote that Glimmer 2.X will only process the first\nsequence in a fasta file, and the prediction report does not contain any\nsort of sequence identifier\n\nNote that Glimmer 3.X produces two output files.  This module only parses\nthe .predict file.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nemail or the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nTorsten Seemann\n\nMark Johnson\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Glimmer;\nuse strict;\n\nuse Bio::Factory::FTLocationFactory;\nuse Bio::Tools::Prediction::Gene;\nuse Bio::Tools::Prediction::Exon;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\nsub _initialize_state {\n    my($self,@args) = @_;\n\n    # first call the inherited method!\n    my $make = $self->SUPER::_initialize_state(@args);\n\n    $self->{'_preds_parsed'} = 0;\n    # array of pre-parsed predictions\n    $self->{'_preds'} = [];\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::Glimmer->new();\n Function: Builds a new Bio::Tools::Glimmer object \n Returns : an instance of Bio::Tools::Glimmer\n Args    : format ('Glimmer', 'GlimmerM', 'GlimmerHMM'), seqname\n\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  my ($format, $seqname, $seqlength, $detail) =\n      $self->_rearrange([qw(FORMAT SEQNAME SEQLENGTH DETAIL)], @args);\n\n  # override automagic format detection\n  if (defined($format) &&\n      (($format eq 'Glimmer')  ||\n       ($format eq 'GlimmerM') ||\n       ($format eq 'GlimmerHMM'))\n  ) {\n      $self->_format($format);\n  }\n  \n  if (defined($detail)) {\n      $self->_format('Glimmer');\n      $self->_detail_file($detail);\n  }\n  \n  # hardwire seq_id when creating gene and exon objects (Glimmer 2.X)\n  $self->_seqname($seqname) if defined($seqname);\n  \n  # store the length of the input sequence (Glimmer 2.X)\n  $self->_seqlength($seqlength) if defined($seqlength);\n  \n  return $self;\n}\n\n=head2 analysis_method\n\n Usage     : $glimmer->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /glimmer/i.\n Returns   : String\n Argument  : n/a\n\n\n#-------------\nsub analysis_method { \n#-------------\n    my ($self, $method) = @_;  \n    if($method && ($method !~ /glimmer/i)) {\n\t$self->throw(\"method $method not supported in \" . ref($self));\n    }\n    return $self->SUPER::analysis_method($method);\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : while($gene = $glimmer->next_feature()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the Glimmer result\n           file. Call this method repeatedly until FALSE is returned.\n\n           The returned object is actually a SeqFeatureI implementing object.\n           This method is required for classes implementing the\n           SeqAnalysisParserI interface, and is merely an alias for \n           next_prediction() at present.\n\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :"},"detail":"($self,@args)","definition":"sub","containerName":"main::"},{"line":254,"children":[{"line":255,"kind":13,"localvar":"my","containerName":"next_prediction","name":"$self","definition":"my"},{"localvar":"my","definition":"my","name":"$gene","containerName":"next_prediction","line":256,"kind":13},{"line":259,"kind":13,"name":"$self","containerName":"next_prediction"},{"containerName":"next_prediction","name":"_parse_predictions","line":259,"kind":12},{"containerName":"next_prediction","name":"$self","line":259,"kind":13},{"name":"_predictions_parsed","containerName":"next_prediction","kind":12,"line":259},{"name":"$gene","containerName":"next_prediction","kind":13,"line":262},{"name":"$self","containerName":"next_prediction","kind":13,"line":262},{"kind":12,"line":262,"name":"_prediction","containerName":"next_prediction"},{"line":263,"kind":13,"name":"$gene","containerName":"next_prediction"}],"kind":12,"detail":"($self)","signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Glimmer.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Glimmer\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Glimmer - parser for Glimmer 2.X/3.X prokaryotic and \nGlimmerM/GlimmerHMM eukaryotic gene predictions\n\n=head1 SYNOPSIS\n\n   use Bio::Tools::Glimmer;\n\n   # file\n   my $parser = Bio::Tools::Glimmer->new(-file => $file);\n   # filehandle:\n   $parser = Bio::Tools::Glimmer->new( -fh  => \\*INPUT );\n   # provide a sequence identifier (Glimmer 2.X)\n   my $parser = Bio::Tools::Glimmer->new(-file => $file, -seqname => seqname);\n   # force format (override automatic detection)\n   my $parser = Bio::Tools::Glimmer->new(-file => $file, -format => 'GlimmerM');\n\n   # parse the results\n   # note: this class is-a Bio::Tools::AnalysisResult which implements\n   # Bio::SeqAnalysisParserI, i.e., $glimmer->next_feature() is the same\n\n   while(my $gene = $parser->next_prediction()) {\n       # For eukaryotic input (GlimmerM/GlimmerHMM), $gene will be an instance\n       # of Bio::Tools::Prediction::Gene, which inherits off\n       # Bio::SeqFeature::Gene::Transcript, and $gene->exons() will return an\n       # array of Bio::Tools::Prediction::Exon objects.\n       # For prokaryotic input (Glimmer2.X/Glimmer3.X), $gene will be an\n       # instance of Bio::SeqFeature::Generic\n\n       # all exons (eukaryotic only):\n       @exon_arr = $gene->exons();\n       # initial exons only\n       @init_exons = $gene->exons('Initial');\n       # internal exons only\n       @intrl_exons = $gene->exons('Internal');\n       # terminal exons only\n       @term_exons = $gene->exons('Terminal');\n   }\n\n=head1 DESCRIPTION\n\nThis is a module for parsing Glimmer, GlimmerM and GlimmerHMM predictions.  \nIt will create gene objects from the prediction report which can \nbe attached to a sequence using Bioperl objects, or output as GFF \nsuitable for loading into Bio::DB::GFF for use with Gbrowse.\n\nGlimmer is open source and available at\nL<http://www.cbcb.umd.edu/software/glimmer/>.\n\nGlimmerM is open source and available at \nL<http://www.tigr.org/software/glimmerm/>.\n\nGlimmerHMM is open source and available at\nL<http://www.cbcb.umd.edu/software/GlimmerHMM/>.\n\nNote that Glimmer 2.X will only process the first\nsequence in a fasta file, and the prediction report does not contain any\nsort of sequence identifier\n\nNote that Glimmer 3.X produces two output files.  This module only parses\nthe .predict file.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nemail or the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nTorsten Seemann\n\nMark Johnson\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Glimmer;\nuse strict;\n\nuse Bio::Factory::FTLocationFactory;\nuse Bio::Tools::Prediction::Gene;\nuse Bio::Tools::Prediction::Exon;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\nsub _initialize_state {\n    my($self,@args) = @_;\n\n    # first call the inherited method!\n    my $make = $self->SUPER::_initialize_state(@args);\n\n    $self->{'_preds_parsed'} = 0;\n    # array of pre-parsed predictions\n    $self->{'_preds'} = [];\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::Glimmer->new();\n Function: Builds a new Bio::Tools::Glimmer object \n Returns : an instance of Bio::Tools::Glimmer\n Args    : format ('Glimmer', 'GlimmerM', 'GlimmerHMM'), seqname\n\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  my ($format, $seqname, $seqlength, $detail) =\n      $self->_rearrange([qw(FORMAT SEQNAME SEQLENGTH DETAIL)], @args);\n\n  # override automagic format detection\n  if (defined($format) &&\n      (($format eq 'Glimmer')  ||\n       ($format eq 'GlimmerM') ||\n       ($format eq 'GlimmerHMM'))\n  ) {\n      $self->_format($format);\n  }\n  \n  if (defined($detail)) {\n      $self->_format('Glimmer');\n      $self->_detail_file($detail);\n  }\n  \n  # hardwire seq_id when creating gene and exon objects (Glimmer 2.X)\n  $self->_seqname($seqname) if defined($seqname);\n  \n  # store the length of the input sequence (Glimmer 2.X)\n  $self->_seqlength($seqlength) if defined($seqlength);\n  \n  return $self;\n}\n\n=head2 analysis_method\n\n Usage     : $glimmer->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /glimmer/i.\n Returns   : String\n Argument  : n/a\n\n\n#-------------\nsub analysis_method { \n#-------------\n    my ($self, $method) = @_;  \n    if($method && ($method !~ /glimmer/i)) {\n\t$self->throw(\"method $method not supported in \" . ref($self));\n    }\n    return $self->SUPER::analysis_method($method);\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : while($gene = $glimmer->next_feature()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the Glimmer result\n           file. Call this method repeatedly until FALSE is returned.\n\n           The returned object is actually a SeqFeatureI implementing object.\n           This method is required for classes implementing the\n           SeqAnalysisParserI interface, and is merely an alias for \n           next_prediction() at present.\n\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :\n\n\nsub next_feature {\n    my ($self,@args) = @_;\n    # even though next_prediction doesn't expect any args (and this method\n    # does neither), we pass on args in order to be prepared if this changes\n    # ever\n    return $self->next_prediction(@args);\n}\n\n=head2 next_prediction\n\n Title   : next_prediction\n Usage   : while($gene = $glimmer->next_prediction()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the Glimmer result\n           file. Call this method repeatedly until FALSE is returned.\n\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :","label":"next_prediction($self)"},"containerName":"main::","definition":"sub","range":{"end":{"line":264,"character":9999},"start":{"character":0,"line":254}},"name":"next_prediction"},{"name":"_parse_predictions","range":{"end":{"line":325,"character":9999},"start":{"character":0,"line":277}},"definition":"sub","containerName":"main::","signature":{"label":"_parse_predictions($self)","documentation":"1;\n# $Id: Glimmer.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Glimmer\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Glimmer - parser for Glimmer 2.X/3.X prokaryotic and \nGlimmerM/GlimmerHMM eukaryotic gene predictions\n\n=head1 SYNOPSIS\n\n   use Bio::Tools::Glimmer;\n\n   # file\n   my $parser = Bio::Tools::Glimmer->new(-file => $file);\n   # filehandle:\n   $parser = Bio::Tools::Glimmer->new( -fh  => \\*INPUT );\n   # provide a sequence identifier (Glimmer 2.X)\n   my $parser = Bio::Tools::Glimmer->new(-file => $file, -seqname => seqname);\n   # force format (override automatic detection)\n   my $parser = Bio::Tools::Glimmer->new(-file => $file, -format => 'GlimmerM');\n\n   # parse the results\n   # note: this class is-a Bio::Tools::AnalysisResult which implements\n   # Bio::SeqAnalysisParserI, i.e., $glimmer->next_feature() is the same\n\n   while(my $gene = $parser->next_prediction()) {\n       # For eukaryotic input (GlimmerM/GlimmerHMM), $gene will be an instance\n       # of Bio::Tools::Prediction::Gene, which inherits off\n       # Bio::SeqFeature::Gene::Transcript, and $gene->exons() will return an\n       # array of Bio::Tools::Prediction::Exon objects.\n       # For prokaryotic input (Glimmer2.X/Glimmer3.X), $gene will be an\n       # instance of Bio::SeqFeature::Generic\n\n       # all exons (eukaryotic only):\n       @exon_arr = $gene->exons();\n       # initial exons only\n       @init_exons = $gene->exons('Initial');\n       # internal exons only\n       @intrl_exons = $gene->exons('Internal');\n       # terminal exons only\n       @term_exons = $gene->exons('Terminal');\n   }\n\n=head1 DESCRIPTION\n\nThis is a module for parsing Glimmer, GlimmerM and GlimmerHMM predictions.  \nIt will create gene objects from the prediction report which can \nbe attached to a sequence using Bioperl objects, or output as GFF \nsuitable for loading into Bio::DB::GFF for use with Gbrowse.\n\nGlimmer is open source and available at\nL<http://www.cbcb.umd.edu/software/glimmer/>.\n\nGlimmerM is open source and available at \nL<http://www.tigr.org/software/glimmerm/>.\n\nGlimmerHMM is open source and available at\nL<http://www.cbcb.umd.edu/software/GlimmerHMM/>.\n\nNote that Glimmer 2.X will only process the first\nsequence in a fasta file, and the prediction report does not contain any\nsort of sequence identifier\n\nNote that Glimmer 3.X produces two output files.  This module only parses\nthe .predict file.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nemail or the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nTorsten Seemann\n\nMark Johnson\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Glimmer;\nuse strict;\n\nuse Bio::Factory::FTLocationFactory;\nuse Bio::Tools::Prediction::Gene;\nuse Bio::Tools::Prediction::Exon;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\nsub _initialize_state {\n    my($self,@args) = @_;\n\n    # first call the inherited method!\n    my $make = $self->SUPER::_initialize_state(@args);\n\n    $self->{'_preds_parsed'} = 0;\n    # array of pre-parsed predictions\n    $self->{'_preds'} = [];\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::Glimmer->new();\n Function: Builds a new Bio::Tools::Glimmer object \n Returns : an instance of Bio::Tools::Glimmer\n Args    : format ('Glimmer', 'GlimmerM', 'GlimmerHMM'), seqname\n\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  my ($format, $seqname, $seqlength, $detail) =\n      $self->_rearrange([qw(FORMAT SEQNAME SEQLENGTH DETAIL)], @args);\n\n  # override automagic format detection\n  if (defined($format) &&\n      (($format eq 'Glimmer')  ||\n       ($format eq 'GlimmerM') ||\n       ($format eq 'GlimmerHMM'))\n  ) {\n      $self->_format($format);\n  }\n  \n  if (defined($detail)) {\n      $self->_format('Glimmer');\n      $self->_detail_file($detail);\n  }\n  \n  # hardwire seq_id when creating gene and exon objects (Glimmer 2.X)\n  $self->_seqname($seqname) if defined($seqname);\n  \n  # store the length of the input sequence (Glimmer 2.X)\n  $self->_seqlength($seqlength) if defined($seqlength);\n  \n  return $self;\n}\n\n=head2 analysis_method\n\n Usage     : $glimmer->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /glimmer/i.\n Returns   : String\n Argument  : n/a\n\n\n#-------------\nsub analysis_method { \n#-------------\n    my ($self, $method) = @_;  \n    if($method && ($method !~ /glimmer/i)) {\n\t$self->throw(\"method $method not supported in \" . ref($self));\n    }\n    return $self->SUPER::analysis_method($method);\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : while($gene = $glimmer->next_feature()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the Glimmer result\n           file. Call this method repeatedly until FALSE is returned.\n\n           The returned object is actually a SeqFeatureI implementing object.\n           This method is required for classes implementing the\n           SeqAnalysisParserI interface, and is merely an alias for \n           next_prediction() at present.\n\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :\n\n\nsub next_feature {\n    my ($self,@args) = @_;\n    # even though next_prediction doesn't expect any args (and this method\n    # does neither), we pass on args in order to be prepared if this changes\n    # ever\n    return $self->next_prediction(@args);\n}\n\n=head2 next_prediction\n\n Title   : next_prediction\n Usage   : while($gene = $glimmer->next_prediction()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the Glimmer result\n           file. Call this method repeatedly until FALSE is returned.\n\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :\n\n\nsub next_prediction {\n    my ($self) = @_;\n    my $gene;\n\n    # if the prediction section hasn't been parsed yet, we do this now\n    $self->_parse_predictions() unless $self->_predictions_parsed();\n    \n    # get next gene structure\n    $gene = $self->_prediction();\n    return $gene;\n}\n\n=head2 _parse_predictions\n\n Title   : _parse_predictions()\n Usage   : $obj->_parse_predictions()\n Function: Parses the prediction section. Automatically called by\n           next_prediction() if not yet done.\n Example :\n Returns : ","parameters":[{"label":"$self"}]},"detail":"($self)","kind":12,"children":[{"localvar":"my","containerName":"_parse_predictions","definition":"my","name":"$self","line":279,"kind":13},{"kind":13,"line":282,"definition":"my","name":"%method","containerName":"_parse_predictions","localvar":"my"},{"line":289,"kind":13,"localvar":"my","name":"$format","definition":"my","containerName":"_parse_predictions"},{"name":"$self","containerName":"_parse_predictions","line":289,"kind":13},{"containerName":"_parse_predictions","name":"_format","line":289,"kind":12},{"containerName":"_parse_predictions","name":"$format","kind":13,"line":291},{"kind":13,"line":293,"containerName":"_parse_predictions","definition":"my","name":"$line","localvar":"my"},{"line":293,"kind":13,"containerName":"_parse_predictions","name":"$self"},{"line":293,"kind":12,"name":"_readline","containerName":"_parse_predictions"},{"containerName":"_parse_predictions","name":"$line","kind":13,"line":295},{"containerName":"_parse_predictions","name":"$format","kind":13,"line":296},{"name":"$self","containerName":"_parse_predictions","kind":13,"line":297},{"line":297,"kind":12,"name":"_pushback","containerName":"_parse_predictions"},{"line":297,"kind":13,"name":"$line","containerName":"_parse_predictions"},{"containerName":"_parse_predictions","name":"$line","line":300,"kind":13},{"line":301,"kind":13,"containerName":"_parse_predictions","name":"$format"},{"line":302,"kind":13,"containerName":"_parse_predictions","name":"$self"},{"name":"_pushback","containerName":"_parse_predictions","line":302,"kind":12},{"line":302,"kind":13,"name":"$line","containerName":"_parse_predictions"},{"containerName":"_parse_predictions","name":"$line","kind":13,"line":305},{"name":"$format","containerName":"_parse_predictions","line":306,"kind":13},{"name":"$self","containerName":"_parse_predictions","line":307,"kind":13},{"kind":12,"line":307,"name":"_pushback","containerName":"_parse_predictions"},{"name":"$line","containerName":"_parse_predictions","line":307,"kind":13},{"name":"$line","containerName":"_parse_predictions","line":310,"kind":13},{"name":"$format","containerName":"_parse_predictions","line":311,"kind":13},{"containerName":"_parse_predictions","name":"$self","line":312,"kind":13},{"line":312,"kind":12,"containerName":"_parse_predictions","name":"_pushback"},{"name":"$line","containerName":"_parse_predictions","kind":13,"line":312},{"containerName":"_parse_predictions","name":"$method","definition":"my","localvar":"my","kind":13,"line":320},{"name":"$method","containerName":"_parse_predictions","kind":13,"line":321},{"line":321,"kind":13,"containerName":"_parse_predictions","name":"$format"},{"kind":13,"line":321,"name":"$method","containerName":"_parse_predictions"},{"kind":13,"line":321,"name":"$format","containerName":"_parse_predictions"},{"line":321,"kind":13,"name":"$method","containerName":"_parse_predictions"},{"line":323,"kind":13,"containerName":"_parse_predictions","name":"$self"},{"kind":13,"line":323,"name":"$method","containerName":"_parse_predictions"}],"line":277},{"kind":12,"children":[{"kind":13,"line":340,"containerName":"_parse_eukaryotic","definition":"my","name":"$self","localvar":"my"},{"kind":13,"line":342,"name":"$gene","definition":"my","containerName":"_parse_eukaryotic","localvar":"my"},{"containerName":"_parse_eukaryotic","name":"$seqname","line":342,"kind":13},{"kind":13,"line":342,"name":"$seqlen","containerName":"_parse_eukaryotic"},{"name":"$source","containerName":"_parse_eukaryotic","kind":13,"line":342},{"kind":13,"line":342,"name":"$lastgenenum","containerName":"_parse_eukaryotic"},{"containerName":"_parse_eukaryotic","name":"$self","line":344,"kind":13},{"line":344,"kind":12,"containerName":"_parse_eukaryotic","name":"_readline"},{"line":346,"kind":13,"containerName":"_parse_eukaryotic","name":"$source"},{"kind":13,"line":349,"containerName":"_parse_eukaryotic","name":"$source"},{"containerName":"_parse_eukaryotic","name":"$seqname","kind":13,"line":352},{"kind":13,"line":355,"containerName":"_parse_eukaryotic","name":"$seqlen"},{"containerName":"_parse_eukaryotic","name":"$genenum","definition":"my","localvar":"my","kind":13,"line":368},{"line":368,"kind":13,"name":"$exonnum","containerName":"_parse_eukaryotic"},{"name":"$strand","containerName":"_parse_eukaryotic","line":368,"kind":13},{"kind":13,"line":368,"containerName":"_parse_eukaryotic","name":"$type"},{"kind":13,"line":368,"name":"$start","containerName":"_parse_eukaryotic"},{"line":368,"kind":13,"containerName":"_parse_eukaryotic","name":"$end"},{"line":368,"kind":13,"name":"$len","containerName":"_parse_eukaryotic"},{"line":370,"kind":13,"name":"$lastgenenum","containerName":"_parse_eukaryotic"},{"line":370,"kind":13,"name":"$lastgenenum","containerName":"_parse_eukaryotic"},{"name":"$genenum","containerName":"_parse_eukaryotic","line":370,"kind":13},{"containerName":"_parse_eukaryotic","name":"$self","kind":13,"line":371},{"line":371,"kind":12,"containerName":"_parse_eukaryotic","name":"_add_prediction"},{"kind":13,"line":371,"name":"$gene","containerName":"_parse_eukaryotic"},{"containerName":"_parse_eukaryotic","name":"$gene","kind":13,"line":371},{"line":372,"kind":13,"name":"$gene","containerName":"_parse_eukaryotic"},{"name":"new","containerName":"_parse_eukaryotic","kind":12,"line":373},{"name":"$seqname","containerName":"_parse_eukaryotic","line":374,"kind":13},{"containerName":"_parse_eukaryotic","name":"$source","line":376,"kind":13},{"line":380,"kind":13,"localvar":"my","name":"$exon","definition":"my","containerName":"_parse_eukaryotic"},{"name":"new","containerName":"_parse_eukaryotic","line":381,"kind":12},{"line":381,"kind":13,"containerName":"_parse_eukaryotic","name":"$seqname"},{"containerName":"_parse_eukaryotic","name":"$start","kind":13,"line":382},{"kind":13,"line":383,"name":"$end","containerName":"_parse_eukaryotic"},{"name":"$strand","containerName":"_parse_eukaryotic","kind":13,"line":384},{"containerName":"_parse_eukaryotic","name":"$source","line":385,"kind":13},{"kind":13,"line":389,"name":"$gene","containerName":"_parse_eukaryotic"},{"name":"add_exon","containerName":"_parse_eukaryotic","kind":12,"line":389},{"kind":13,"line":389,"containerName":"_parse_eukaryotic","name":"$exon"},{"name":"$type","containerName":"_parse_eukaryotic","kind":13,"line":389},{"line":390,"kind":13,"containerName":"_parse_eukaryotic","name":"$lastgenenum"},{"name":"$genenum","containerName":"_parse_eukaryotic","line":390,"kind":13},{"kind":13,"line":393,"name":"$self","containerName":"_parse_eukaryotic"},{"containerName":"_parse_eukaryotic","name":"_add_prediction","kind":12,"line":393},{"containerName":"_parse_eukaryotic","name":"$gene","line":393,"kind":13},{"line":393,"kind":13,"containerName":"_parse_eukaryotic","name":"$gene"},{"name":"$self","containerName":"_parse_eukaryotic","line":394,"kind":13},{"kind":12,"line":394,"name":"_predictions_parsed","containerName":"_parse_eukaryotic"}],"line":339,"definition":"sub","containerName":"main::","signature":{"label":"_parse_eukaryotic($self)","documentation":"1;\n# $Id: Glimmer.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Glimmer\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Glimmer - parser for Glimmer 2.X/3.X prokaryotic and \nGlimmerM/GlimmerHMM eukaryotic gene predictions\n\n=head1 SYNOPSIS\n\n   use Bio::Tools::Glimmer;\n\n   # file\n   my $parser = Bio::Tools::Glimmer->new(-file => $file);\n   # filehandle:\n   $parser = Bio::Tools::Glimmer->new( -fh  => \\*INPUT );\n   # provide a sequence identifier (Glimmer 2.X)\n   my $parser = Bio::Tools::Glimmer->new(-file => $file, -seqname => seqname);\n   # force format (override automatic detection)\n   my $parser = Bio::Tools::Glimmer->new(-file => $file, -format => 'GlimmerM');\n\n   # parse the results\n   # note: this class is-a Bio::Tools::AnalysisResult which implements\n   # Bio::SeqAnalysisParserI, i.e., $glimmer->next_feature() is the same\n\n   while(my $gene = $parser->next_prediction()) {\n       # For eukaryotic input (GlimmerM/GlimmerHMM), $gene will be an instance\n       # of Bio::Tools::Prediction::Gene, which inherits off\n       # Bio::SeqFeature::Gene::Transcript, and $gene->exons() will return an\n       # array of Bio::Tools::Prediction::Exon objects.\n       # For prokaryotic input (Glimmer2.X/Glimmer3.X), $gene will be an\n       # instance of Bio::SeqFeature::Generic\n\n       # all exons (eukaryotic only):\n       @exon_arr = $gene->exons();\n       # initial exons only\n       @init_exons = $gene->exons('Initial');\n       # internal exons only\n       @intrl_exons = $gene->exons('Internal');\n       # terminal exons only\n       @term_exons = $gene->exons('Terminal');\n   }\n\n=head1 DESCRIPTION\n\nThis is a module for parsing Glimmer, GlimmerM and GlimmerHMM predictions.  \nIt will create gene objects from the prediction report which can \nbe attached to a sequence using Bioperl objects, or output as GFF \nsuitable for loading into Bio::DB::GFF for use with Gbrowse.\n\nGlimmer is open source and available at\nL<http://www.cbcb.umd.edu/software/glimmer/>.\n\nGlimmerM is open source and available at \nL<http://www.tigr.org/software/glimmerm/>.\n\nGlimmerHMM is open source and available at\nL<http://www.cbcb.umd.edu/software/GlimmerHMM/>.\n\nNote that Glimmer 2.X will only process the first\nsequence in a fasta file, and the prediction report does not contain any\nsort of sequence identifier\n\nNote that Glimmer 3.X produces two output files.  This module only parses\nthe .predict file.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nemail or the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nTorsten Seemann\n\nMark Johnson\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Glimmer;\nuse strict;\n\nuse Bio::Factory::FTLocationFactory;\nuse Bio::Tools::Prediction::Gene;\nuse Bio::Tools::Prediction::Exon;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\nsub _initialize_state {\n    my($self,@args) = @_;\n\n    # first call the inherited method!\n    my $make = $self->SUPER::_initialize_state(@args);\n\n    $self->{'_preds_parsed'} = 0;\n    # array of pre-parsed predictions\n    $self->{'_preds'} = [];\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::Glimmer->new();\n Function: Builds a new Bio::Tools::Glimmer object \n Returns : an instance of Bio::Tools::Glimmer\n Args    : format ('Glimmer', 'GlimmerM', 'GlimmerHMM'), seqname\n\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  my ($format, $seqname, $seqlength, $detail) =\n      $self->_rearrange([qw(FORMAT SEQNAME SEQLENGTH DETAIL)], @args);\n\n  # override automagic format detection\n  if (defined($format) &&\n      (($format eq 'Glimmer')  ||\n       ($format eq 'GlimmerM') ||\n       ($format eq 'GlimmerHMM'))\n  ) {\n      $self->_format($format);\n  }\n  \n  if (defined($detail)) {\n      $self->_format('Glimmer');\n      $self->_detail_file($detail);\n  }\n  \n  # hardwire seq_id when creating gene and exon objects (Glimmer 2.X)\n  $self->_seqname($seqname) if defined($seqname);\n  \n  # store the length of the input sequence (Glimmer 2.X)\n  $self->_seqlength($seqlength) if defined($seqlength);\n  \n  return $self;\n}\n\n=head2 analysis_method\n\n Usage     : $glimmer->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /glimmer/i.\n Returns   : String\n Argument  : n/a\n\n\n#-------------\nsub analysis_method { \n#-------------\n    my ($self, $method) = @_;  \n    if($method && ($method !~ /glimmer/i)) {\n\t$self->throw(\"method $method not supported in \" . ref($self));\n    }\n    return $self->SUPER::analysis_method($method);\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : while($gene = $glimmer->next_feature()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the Glimmer result\n           file. Call this method repeatedly until FALSE is returned.\n\n           The returned object is actually a SeqFeatureI implementing object.\n           This method is required for classes implementing the\n           SeqAnalysisParserI interface, and is merely an alias for \n           next_prediction() at present.\n\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :\n\n\nsub next_feature {\n    my ($self,@args) = @_;\n    # even though next_prediction doesn't expect any args (and this method\n    # does neither), we pass on args in order to be prepared if this changes\n    # ever\n    return $self->next_prediction(@args);\n}\n\n=head2 next_prediction\n\n Title   : next_prediction\n Usage   : while($gene = $glimmer->next_prediction()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the Glimmer result\n           file. Call this method repeatedly until FALSE is returned.\n\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :\n\n\nsub next_prediction {\n    my ($self) = @_;\n    my $gene;\n\n    # if the prediction section hasn't been parsed yet, we do this now\n    $self->_parse_predictions() unless $self->_predictions_parsed();\n    \n    # get next gene structure\n    $gene = $self->_prediction();\n    return $gene;\n}\n\n=head2 _parse_predictions\n\n Title   : _parse_predictions()\n Usage   : $obj->_parse_predictions()\n Function: Parses the prediction section. Automatically called by\n           next_prediction() if not yet done.\n Example :\n Returns : \n\n\nsub _parse_predictions {\n\n    my ($self) = @_;\n\n    \n    my %method = (\n                  'Glimmer'    => '_parse_prokaryotic',\n                  'GlimmerM'   => '_parse_eukaryotic',\n                  'GlimmerHMM' => '_parse_eukaryotic',\n                  '_DEFAULT_'  => '_parse_eukaryotic',\n              );\n    \n    my $format = $self->_format();\n    \n    if (!$format) {\n        \n        while (my $line = $self->_readline()) {\n\n            if ( $line =~ /^Glimmer\\S*\\s+\\(Version\\s*\\S+\\)/ ) {\n                $format = 'GlimmerM';\n                $self->_pushback($line);\n                last;\n            }\n            elsif ( $line =~ /^Glimmer\\S*$/ ) {\n                $format = 'GlimmerHMM';\n                $self->_pushback($line);\n                last;\n            }\n            elsif ($line =~ /^Putative Genes:$/) {\n                $format = 'Glimmer';\n                $self->_pushback($line);\n                last;\n            }\n            elsif ($line =~ /^>(\\S+)/) {\n                $format = 'Glimmer';\n                $self->_pushback($line);\n                last;\n            }\n            \n        }\n        \n    }\n\n    my $method =\n        (exists($method{$format})) ? $method{$format} : $method{'_DEFAULT_'};\n\n    return $self->$method();\n    \n}\n\n\n=head2 _parse_eukaryotic\n\n Title   : _parse_eukaryotic()\n Usage   : $obj->_parse_eukaryotic()\n Function: Parses the prediction section. Automatically called by\n           next_prediction() if not yet done.\n Example :\n Returns : ","parameters":[{"label":"$self"}]},"detail":"($self)","name":"_parse_eukaryotic","range":{"start":{"character":0,"line":339},"end":{"line":395,"character":9999}}},{"name":"Bio","containerName":"Tools::Prediction::Gene","line":372,"kind":12},{"name":"Bio","containerName":"Tools::Prediction::Exon","kind":12,"line":380},{"name":"_parse_prokaryotic","range":{"end":{"line":581,"character":9999},"start":{"character":0,"line":408}},"kind":12,"children":[{"line":409,"kind":13,"localvar":"my","containerName":"_parse_prokaryotic","definition":"my","name":"$self"},{"localvar":"my","containerName":"_parse_prokaryotic","name":"$source","definition":"my","line":412,"kind":13},{"containerName":"_parse_prokaryotic","definition":"my","name":"%seqlength","localvar":"my","kind":13,"line":417},{"line":428,"kind":13,"localvar":"my","containerName":"_parse_prokaryotic","definition":"my","name":"$seqname"},{"kind":13,"line":428,"containerName":"_parse_prokaryotic","name":"$self"},{"name":"_seqname","containerName":"_parse_prokaryotic","line":428,"kind":12},{"localvar":"my","name":"$seqlength","definition":"my","containerName":"_parse_prokaryotic","line":429,"kind":13},{"containerName":"_parse_prokaryotic","name":"$self","line":429,"kind":13},{"name":"_seqlength","containerName":"_parse_prokaryotic","line":429,"kind":12},{"line":431,"kind":13,"containerName":"_parse_prokaryotic","name":"$seqlength"},{"kind":13,"line":432,"name":"$seqlength","containerName":"_parse_prokaryotic"},{"name":"$seqname","containerName":"_parse_prokaryotic","kind":13,"line":432},{"name":"$seqlength","containerName":"_parse_prokaryotic","line":433,"kind":13},{"name":"$detail_file","definition":"my","containerName":"_parse_prokaryotic","localvar":"my","kind":13,"line":436},{"line":436,"kind":13,"name":"$self","containerName":"_parse_prokaryotic"},{"name":"_detail_file","containerName":"_parse_prokaryotic","line":436,"kind":12},{"containerName":"_parse_prokaryotic","name":"$detail_file","kind":13,"line":438},{"line":440,"kind":13,"localvar":"my","definition":"my","name":"$io","containerName":"_parse_prokaryotic"},{"line":440,"kind":12,"name":"new","containerName":"_parse_prokaryotic"},{"kind":13,"line":440,"name":"$detail_file","containerName":"_parse_prokaryotic"},{"localvar":"my","containerName":"_parse_prokaryotic","name":"$seqname","definition":"my","line":441,"kind":13},{"kind":13,"line":443,"containerName":"_parse_prokaryotic","name":"$io"},{"name":"_readline","containerName":"_parse_prokaryotic","kind":12,"line":443},{"kind":13,"line":445,"name":"$seqname","containerName":"_parse_prokaryotic"},{"containerName":"_parse_prokaryotic","name":"$seqname","kind":13,"line":449},{"containerName":"_parse_prokaryotic","name":"$seqlength","kind":13,"line":450},{"containerName":"_parse_prokaryotic","name":"$seqname","line":450,"kind":13},{"kind":13,"line":456,"definition":"my","name":"$location_factory","containerName":"_parse_prokaryotic","localvar":"my"},{"name":"new","containerName":"_parse_prokaryotic","line":456,"kind":12},{"name":"$self","containerName":"_parse_prokaryotic","kind":13,"line":458},{"kind":12,"line":458,"containerName":"_parse_prokaryotic","name":"_readline"},{"name":"$source","containerName":"_parse_prokaryotic","kind":13,"line":463},{"name":"$seqname","containerName":"_parse_prokaryotic","kind":13,"line":468},{"line":469,"kind":13,"name":"$seqlength","containerName":"_parse_prokaryotic"},{"name":"$seqlength","containerName":"_parse_prokaryotic","line":469,"kind":13},{"kind":13,"line":469,"name":"$seqname","containerName":"_parse_prokaryotic"},{"containerName":"_parse_prokaryotic","name":"$source","kind":13,"line":470},{"kind":13,"line":485,"definition":"my","name":"$genenum","containerName":"_parse_prokaryotic","localvar":"my"},{"line":485,"kind":13,"name":"$start","containerName":"_parse_prokaryotic"},{"name":"$end","containerName":"_parse_prokaryotic","kind":13,"line":485},{"containerName":"_parse_prokaryotic","name":"$strand","kind":13,"line":485},{"line":485,"kind":13,"name":"$frame","containerName":"_parse_prokaryotic"},{"line":485,"kind":13,"name":"$score","containerName":"_parse_prokaryotic"},{"containerName":"_parse_prokaryotic","definition":"my","name":"$circular_prediction","localvar":"my","kind":13,"line":488},{"containerName":"_parse_prokaryotic","name":"$strand","line":492,"kind":13},{"containerName":"_parse_prokaryotic","name":"$start","kind":13,"line":493},{"containerName":"_parse_prokaryotic","name":"$end","kind":13,"line":493},{"kind":13,"line":494,"containerName":"_parse_prokaryotic","name":"$circular_prediction"},{"name":"$start","containerName":"_parse_prokaryotic","kind":13,"line":498},{"kind":13,"line":498,"containerName":"_parse_prokaryotic","name":"$end"},{"containerName":"_parse_prokaryotic","name":"$circular_prediction","kind":13,"line":499},{"kind":13,"line":503,"containerName":"_parse_prokaryotic","name":"$circular_prediction"},{"line":504,"kind":13,"name":"$seqlength","containerName":"_parse_prokaryotic"},{"line":505,"kind":13,"containerName":"_parse_prokaryotic","name":"$self"},{"kind":12,"line":505,"containerName":"_parse_prokaryotic","name":"throw"},{"kind":13,"line":514,"name":"$source","containerName":"_parse_prokaryotic"},{"containerName":"_parse_prokaryotic","name":"$strand","line":515,"kind":13},{"kind":13,"line":516,"containerName":"_parse_prokaryotic","name":"$end"},{"kind":13,"line":519,"name":"$end","containerName":"_parse_prokaryotic"},{"line":528,"kind":13,"localvar":"my","containerName":"_parse_prokaryotic","definition":"my","name":"$fst"},{"line":528,"kind":13,"containerName":"_parse_prokaryotic","name":"$fend"},{"localvar":"my","containerName":"_parse_prokaryotic","definition":"my","name":"$coord","line":529,"kind":13},{"line":529,"kind":13,"containerName":"_parse_prokaryotic","name":"$start"},{"name":"$end","containerName":"_parse_prokaryotic","line":529,"kind":13},{"containerName":"_parse_prokaryotic","name":"$coord","line":530,"kind":13},{"kind":13,"line":531,"name":"$coord","containerName":"_parse_prokaryotic"},{"kind":13,"line":532,"name":"$fst","containerName":"_parse_prokaryotic"},{"name":"$seqlength","containerName":"_parse_prokaryotic","kind":13,"line":533},{"name":"$coord","containerName":"_parse_prokaryotic","kind":13,"line":533},{"containerName":"_parse_prokaryotic","name":"$seqlength","line":533,"kind":13},{"kind":13,"line":534,"containerName":"_parse_prokaryotic","name":"$coord"},{"name":"$fend","containerName":"_parse_prokaryotic","kind":13,"line":535},{"line":539,"kind":13,"localvar":"my","name":"$location_string","definition":"my","containerName":"_parse_prokaryotic"},{"name":"$circular_prediction","containerName":"_parse_prokaryotic","line":541,"kind":13},{"kind":13,"line":542,"containerName":"_parse_prokaryotic","name":"$strand"},{"name":"$location_string","containerName":"_parse_prokaryotic","line":543,"kind":13},{"containerName":"_parse_prokaryotic","name":"$location_string","kind":13,"line":546},{"line":551,"kind":13,"name":"$strand","containerName":"_parse_prokaryotic"},{"containerName":"_parse_prokaryotic","name":"$fst","kind":13,"line":551},{"name":"$fend","containerName":"_parse_prokaryotic","kind":13,"line":551},{"containerName":"_parse_prokaryotic","name":"$start","kind":13,"line":551},{"line":551,"kind":13,"name":"$end","containerName":"_parse_prokaryotic"},{"containerName":"_parse_prokaryotic","name":"$start","line":552,"kind":13},{"name":"$end","containerName":"_parse_prokaryotic","kind":13,"line":552},{"kind":13,"line":552,"containerName":"_parse_prokaryotic","name":"$end"},{"name":"$start","containerName":"_parse_prokaryotic","line":552,"kind":13},{"line":554,"kind":13,"containerName":"_parse_prokaryotic","name":"$location_string"},{"name":"$location_object","definition":"my","containerName":"_parse_prokaryotic","localvar":"my","kind":13,"line":557},{"name":"$location_factory","containerName":"_parse_prokaryotic","kind":13,"line":558},{"containerName":"_parse_prokaryotic","name":"from_string","kind":12,"line":558},{"containerName":"_parse_prokaryotic","name":"$location_string","line":558,"kind":13},{"line":561,"kind":13,"name":"$frame","containerName":"_parse_prokaryotic"},{"line":563,"kind":13,"localvar":"my","definition":"my","name":"$gene","containerName":"_parse_prokaryotic"},{"containerName":"_parse_prokaryotic","name":"new","line":564,"kind":12},{"containerName":"_parse_prokaryotic","name":"$seqname","kind":13,"line":565},{"name":"$location_object","containerName":"_parse_prokaryotic","kind":13,"line":566},{"name":"$strand","containerName":"_parse_prokaryotic","kind":13,"line":567},{"name":"$frame","containerName":"_parse_prokaryotic","line":568,"kind":13},{"containerName":"_parse_prokaryotic","name":"$source","kind":13,"line":569},{"kind":13,"line":573,"containerName":"_parse_prokaryotic","name":"$score"},{"name":"$self","containerName":"_parse_prokaryotic","kind":13,"line":576},{"name":"_add_prediction","containerName":"_parse_prokaryotic","kind":12,"line":576},{"line":576,"kind":13,"name":"$gene","containerName":"_parse_prokaryotic"},{"line":580,"kind":13,"containerName":"_parse_prokaryotic","name":"$self"},{"name":"_predictions_parsed","containerName":"_parse_prokaryotic","line":580,"kind":12}],"line":408,"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Glimmer.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Glimmer\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Glimmer - parser for Glimmer 2.X/3.X prokaryotic and \nGlimmerM/GlimmerHMM eukaryotic gene predictions\n\n=head1 SYNOPSIS\n\n   use Bio::Tools::Glimmer;\n\n   # file\n   my $parser = Bio::Tools::Glimmer->new(-file => $file);\n   # filehandle:\n   $parser = Bio::Tools::Glimmer->new( -fh  => \\*INPUT );\n   # provide a sequence identifier (Glimmer 2.X)\n   my $parser = Bio::Tools::Glimmer->new(-file => $file, -seqname => seqname);\n   # force format (override automatic detection)\n   my $parser = Bio::Tools::Glimmer->new(-file => $file, -format => 'GlimmerM');\n\n   # parse the results\n   # note: this class is-a Bio::Tools::AnalysisResult which implements\n   # Bio::SeqAnalysisParserI, i.e., $glimmer->next_feature() is the same\n\n   while(my $gene = $parser->next_prediction()) {\n       # For eukaryotic input (GlimmerM/GlimmerHMM), $gene will be an instance\n       # of Bio::Tools::Prediction::Gene, which inherits off\n       # Bio::SeqFeature::Gene::Transcript, and $gene->exons() will return an\n       # array of Bio::Tools::Prediction::Exon objects.\n       # For prokaryotic input (Glimmer2.X/Glimmer3.X), $gene will be an\n       # instance of Bio::SeqFeature::Generic\n\n       # all exons (eukaryotic only):\n       @exon_arr = $gene->exons();\n       # initial exons only\n       @init_exons = $gene->exons('Initial');\n       # internal exons only\n       @intrl_exons = $gene->exons('Internal');\n       # terminal exons only\n       @term_exons = $gene->exons('Terminal');\n   }\n\n=head1 DESCRIPTION\n\nThis is a module for parsing Glimmer, GlimmerM and GlimmerHMM predictions.  \nIt will create gene objects from the prediction report which can \nbe attached to a sequence using Bioperl objects, or output as GFF \nsuitable for loading into Bio::DB::GFF for use with Gbrowse.\n\nGlimmer is open source and available at\nL<http://www.cbcb.umd.edu/software/glimmer/>.\n\nGlimmerM is open source and available at \nL<http://www.tigr.org/software/glimmerm/>.\n\nGlimmerHMM is open source and available at\nL<http://www.cbcb.umd.edu/software/GlimmerHMM/>.\n\nNote that Glimmer 2.X will only process the first\nsequence in a fasta file, and the prediction report does not contain any\nsort of sequence identifier\n\nNote that Glimmer 3.X produces two output files.  This module only parses\nthe .predict file.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nemail or the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nTorsten Seemann\n\nMark Johnson\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Glimmer;\nuse strict;\n\nuse Bio::Factory::FTLocationFactory;\nuse Bio::Tools::Prediction::Gene;\nuse Bio::Tools::Prediction::Exon;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\nsub _initialize_state {\n    my($self,@args) = @_;\n\n    # first call the inherited method!\n    my $make = $self->SUPER::_initialize_state(@args);\n\n    $self->{'_preds_parsed'} = 0;\n    # array of pre-parsed predictions\n    $self->{'_preds'} = [];\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::Glimmer->new();\n Function: Builds a new Bio::Tools::Glimmer object \n Returns : an instance of Bio::Tools::Glimmer\n Args    : format ('Glimmer', 'GlimmerM', 'GlimmerHMM'), seqname\n\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  my ($format, $seqname, $seqlength, $detail) =\n      $self->_rearrange([qw(FORMAT SEQNAME SEQLENGTH DETAIL)], @args);\n\n  # override automagic format detection\n  if (defined($format) &&\n      (($format eq 'Glimmer')  ||\n       ($format eq 'GlimmerM') ||\n       ($format eq 'GlimmerHMM'))\n  ) {\n      $self->_format($format);\n  }\n  \n  if (defined($detail)) {\n      $self->_format('Glimmer');\n      $self->_detail_file($detail);\n  }\n  \n  # hardwire seq_id when creating gene and exon objects (Glimmer 2.X)\n  $self->_seqname($seqname) if defined($seqname);\n  \n  # store the length of the input sequence (Glimmer 2.X)\n  $self->_seqlength($seqlength) if defined($seqlength);\n  \n  return $self;\n}\n\n=head2 analysis_method\n\n Usage     : $glimmer->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /glimmer/i.\n Returns   : String\n Argument  : n/a\n\n\n#-------------\nsub analysis_method { \n#-------------\n    my ($self, $method) = @_;  \n    if($method && ($method !~ /glimmer/i)) {\n\t$self->throw(\"method $method not supported in \" . ref($self));\n    }\n    return $self->SUPER::analysis_method($method);\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : while($gene = $glimmer->next_feature()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the Glimmer result\n           file. Call this method repeatedly until FALSE is returned.\n\n           The returned object is actually a SeqFeatureI implementing object.\n           This method is required for classes implementing the\n           SeqAnalysisParserI interface, and is merely an alias for \n           next_prediction() at present.\n\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :\n\n\nsub next_feature {\n    my ($self,@args) = @_;\n    # even though next_prediction doesn't expect any args (and this method\n    # does neither), we pass on args in order to be prepared if this changes\n    # ever\n    return $self->next_prediction(@args);\n}\n\n=head2 next_prediction\n\n Title   : next_prediction\n Usage   : while($gene = $glimmer->next_prediction()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the Glimmer result\n           file. Call this method repeatedly until FALSE is returned.\n\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :\n\n\nsub next_prediction {\n    my ($self) = @_;\n    my $gene;\n\n    # if the prediction section hasn't been parsed yet, we do this now\n    $self->_parse_predictions() unless $self->_predictions_parsed();\n    \n    # get next gene structure\n    $gene = $self->_prediction();\n    return $gene;\n}\n\n=head2 _parse_predictions\n\n Title   : _parse_predictions()\n Usage   : $obj->_parse_predictions()\n Function: Parses the prediction section. Automatically called by\n           next_prediction() if not yet done.\n Example :\n Returns : \n\n\nsub _parse_predictions {\n\n    my ($self) = @_;\n\n    \n    my %method = (\n                  'Glimmer'    => '_parse_prokaryotic',\n                  'GlimmerM'   => '_parse_eukaryotic',\n                  'GlimmerHMM' => '_parse_eukaryotic',\n                  '_DEFAULT_'  => '_parse_eukaryotic',\n              );\n    \n    my $format = $self->_format();\n    \n    if (!$format) {\n        \n        while (my $line = $self->_readline()) {\n\n            if ( $line =~ /^Glimmer\\S*\\s+\\(Version\\s*\\S+\\)/ ) {\n                $format = 'GlimmerM';\n                $self->_pushback($line);\n                last;\n            }\n            elsif ( $line =~ /^Glimmer\\S*$/ ) {\n                $format = 'GlimmerHMM';\n                $self->_pushback($line);\n                last;\n            }\n            elsif ($line =~ /^Putative Genes:$/) {\n                $format = 'Glimmer';\n                $self->_pushback($line);\n                last;\n            }\n            elsif ($line =~ /^>(\\S+)/) {\n                $format = 'Glimmer';\n                $self->_pushback($line);\n                last;\n            }\n            \n        }\n        \n    }\n\n    my $method =\n        (exists($method{$format})) ? $method{$format} : $method{'_DEFAULT_'};\n\n    return $self->$method();\n    \n}\n\n\n=head2 _parse_eukaryotic\n\n Title   : _parse_eukaryotic()\n Usage   : $obj->_parse_eukaryotic()\n Function: Parses the prediction section. Automatically called by\n           next_prediction() if not yet done.\n Example :\n Returns : \n\n\nsub _parse_eukaryotic {\n    my ($self) = @_;\n\n    my ($gene,$seqname,$seqlen,$source,$lastgenenum);\n    \n    while(defined($_ = $self->_readline())) {\n\tif( /^(Glimmer\\S*)\\s+\\(Version\\s*(\\S+)\\)/ ) {\n\t    $source = \"$1_$2\";\n\t    next;\n\t} elsif( /^(GlimmerHMM\\S*)$/ ) { # GlimmerHMM has no version\n\t    $source = $1;\n\t    next;\n\t} elsif(/^Sequence name:\\s+(.+)$/ ) {\n\t    $seqname = $1;\n\t    next;\n\t} elsif( /^Sequence length:\\s+(\\S+)/ ) {\n\t    $seqlen = $1;\n\t    next;\n\t} elsif( m/^(Predicted genes)|(Gene)|\\s+\\#/ || /^\\s+$/ ) { \n\t    next;\n\t    \n\t} elsif( # GlimmerM/HMM gene-exon prediction line\n\t\t /^\\s+(\\d+)\\s+ # gene num\n\t\t (\\d+)\\s+      # exon num\n\t\t ([\\+\\-])\\s+   # strand\n\t\t (\\S+)\\s+      # exon type\n\t\t (\\d+)\\s+(\\d+) # exon start, end\n\t\t \\s+(\\d+)      # exon length\t\t \n\t\t /ox ) {\n\t    my ($genenum,$exonnum,$strand,$type,$start,$end,$len) = \n\t\t( $1,$2,$3,$4,$5,$6,$7);\n\t    if( ! $lastgenenum || $lastgenenum != $genenum) {\t\t\n\t\t$self->_add_prediction($gene) if ( $gene );\n\t\t$gene = Bio::Tools::Prediction::Gene->new\n\t\t    (\n\t\t     '-seq_id'      => $seqname,\n\t\t     '-primary_tag' => \"gene\",\n\t\t     '-source_tag'  => $source,\n\t\t     '-tag'         => { 'Group' => \"GenePrediction$genenum\"},\n\t\t     );\n\t    }\n\t    my $exon = Bio::Tools::Prediction::Exon->new\n\t\t('-seq_id'     => $seqname,\n\t\t '-start'      => $start,\n\t\t '-end'        => $end,\n\t\t '-strand'     => $strand eq '-' ? '-1' : '1',\n\t\t '-source_tag' => $source,\n\t\t '-primary_tag'=> 'exon',\n\t\t '-tag'         => { 'Group' => \"GenePrediction$genenum\"},\n\t\t );\n\t    $gene->add_exon($exon,lc($type));\n\t    $lastgenenum = $genenum;\n\t}\n    }\n    $self->_add_prediction($gene) if( $gene );\n    $self->_predictions_parsed(1);\n}\n\n=head2 _parse_prokaryotic\n\n Title   : _parse_prokaryotic()\n Usage   : $obj->_parse_prokaryotic()\n Function: Parses the prediction section. Automatically called by\n           next_prediction() if not yet done.\n Example :\n Returns : ","label":"_parse_prokaryotic($self)"},"detail":"($self)"},{"kind":12,"line":440,"name":"Bio","containerName":"Root::IO"},{"kind":12,"line":456,"name":"Bio","containerName":"Factory::FTLocationFactory"},{"line":563,"kind":12,"name":"Bio","containerName":"SeqFeature::Generic"},{"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"_prediction","line":594,"kind":13},{"containerName":"_prediction","name":"$self","line":596,"kind":13},{"containerName":"_prediction","name":"$self","line":596,"kind":13}],"line":593,"kind":12,"signature":{"documentation":"1;\n# $Id: Glimmer.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Glimmer\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Glimmer - parser for Glimmer 2.X/3.X prokaryotic and \nGlimmerM/GlimmerHMM eukaryotic gene predictions\n\n=head1 SYNOPSIS\n\n   use Bio::Tools::Glimmer;\n\n   # file\n   my $parser = Bio::Tools::Glimmer->new(-file => $file);\n   # filehandle:\n   $parser = Bio::Tools::Glimmer->new( -fh  => \\*INPUT );\n   # provide a sequence identifier (Glimmer 2.X)\n   my $parser = Bio::Tools::Glimmer->new(-file => $file, -seqname => seqname);\n   # force format (override automatic detection)\n   my $parser = Bio::Tools::Glimmer->new(-file => $file, -format => 'GlimmerM');\n\n   # parse the results\n   # note: this class is-a Bio::Tools::AnalysisResult which implements\n   # Bio::SeqAnalysisParserI, i.e., $glimmer->next_feature() is the same\n\n   while(my $gene = $parser->next_prediction()) {\n       # For eukaryotic input (GlimmerM/GlimmerHMM), $gene will be an instance\n       # of Bio::Tools::Prediction::Gene, which inherits off\n       # Bio::SeqFeature::Gene::Transcript, and $gene->exons() will return an\n       # array of Bio::Tools::Prediction::Exon objects.\n       # For prokaryotic input (Glimmer2.X/Glimmer3.X), $gene will be an\n       # instance of Bio::SeqFeature::Generic\n\n       # all exons (eukaryotic only):\n       @exon_arr = $gene->exons();\n       # initial exons only\n       @init_exons = $gene->exons('Initial');\n       # internal exons only\n       @intrl_exons = $gene->exons('Internal');\n       # terminal exons only\n       @term_exons = $gene->exons('Terminal');\n   }\n\n=head1 DESCRIPTION\n\nThis is a module for parsing Glimmer, GlimmerM and GlimmerHMM predictions.  \nIt will create gene objects from the prediction report which can \nbe attached to a sequence using Bioperl objects, or output as GFF \nsuitable for loading into Bio::DB::GFF for use with Gbrowse.\n\nGlimmer is open source and available at\nL<http://www.cbcb.umd.edu/software/glimmer/>.\n\nGlimmerM is open source and available at \nL<http://www.tigr.org/software/glimmerm/>.\n\nGlimmerHMM is open source and available at\nL<http://www.cbcb.umd.edu/software/GlimmerHMM/>.\n\nNote that Glimmer 2.X will only process the first\nsequence in a fasta file, and the prediction report does not contain any\nsort of sequence identifier\n\nNote that Glimmer 3.X produces two output files.  This module only parses\nthe .predict file.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nemail or the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nTorsten Seemann\n\nMark Johnson\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Glimmer;\nuse strict;\n\nuse Bio::Factory::FTLocationFactory;\nuse Bio::Tools::Prediction::Gene;\nuse Bio::Tools::Prediction::Exon;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\nsub _initialize_state {\n    my($self,@args) = @_;\n\n    # first call the inherited method!\n    my $make = $self->SUPER::_initialize_state(@args);\n\n    $self->{'_preds_parsed'} = 0;\n    # array of pre-parsed predictions\n    $self->{'_preds'} = [];\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::Glimmer->new();\n Function: Builds a new Bio::Tools::Glimmer object \n Returns : an instance of Bio::Tools::Glimmer\n Args    : format ('Glimmer', 'GlimmerM', 'GlimmerHMM'), seqname\n\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  my ($format, $seqname, $seqlength, $detail) =\n      $self->_rearrange([qw(FORMAT SEQNAME SEQLENGTH DETAIL)], @args);\n\n  # override automagic format detection\n  if (defined($format) &&\n      (($format eq 'Glimmer')  ||\n       ($format eq 'GlimmerM') ||\n       ($format eq 'GlimmerHMM'))\n  ) {\n      $self->_format($format);\n  }\n  \n  if (defined($detail)) {\n      $self->_format('Glimmer');\n      $self->_detail_file($detail);\n  }\n  \n  # hardwire seq_id when creating gene and exon objects (Glimmer 2.X)\n  $self->_seqname($seqname) if defined($seqname);\n  \n  # store the length of the input sequence (Glimmer 2.X)\n  $self->_seqlength($seqlength) if defined($seqlength);\n  \n  return $self;\n}\n\n=head2 analysis_method\n\n Usage     : $glimmer->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /glimmer/i.\n Returns   : String\n Argument  : n/a\n\n\n#-------------\nsub analysis_method { \n#-------------\n    my ($self, $method) = @_;  \n    if($method && ($method !~ /glimmer/i)) {\n\t$self->throw(\"method $method not supported in \" . ref($self));\n    }\n    return $self->SUPER::analysis_method($method);\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : while($gene = $glimmer->next_feature()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the Glimmer result\n           file. Call this method repeatedly until FALSE is returned.\n\n           The returned object is actually a SeqFeatureI implementing object.\n           This method is required for classes implementing the\n           SeqAnalysisParserI interface, and is merely an alias for \n           next_prediction() at present.\n\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :\n\n\nsub next_feature {\n    my ($self,@args) = @_;\n    # even though next_prediction doesn't expect any args (and this method\n    # does neither), we pass on args in order to be prepared if this changes\n    # ever\n    return $self->next_prediction(@args);\n}\n\n=head2 next_prediction\n\n Title   : next_prediction\n Usage   : while($gene = $glimmer->next_prediction()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the Glimmer result\n           file. Call this method repeatedly until FALSE is returned.\n\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :\n\n\nsub next_prediction {\n    my ($self) = @_;\n    my $gene;\n\n    # if the prediction section hasn't been parsed yet, we do this now\n    $self->_parse_predictions() unless $self->_predictions_parsed();\n    \n    # get next gene structure\n    $gene = $self->_prediction();\n    return $gene;\n}\n\n=head2 _parse_predictions\n\n Title   : _parse_predictions()\n Usage   : $obj->_parse_predictions()\n Function: Parses the prediction section. Automatically called by\n           next_prediction() if not yet done.\n Example :\n Returns : \n\n\nsub _parse_predictions {\n\n    my ($self) = @_;\n\n    \n    my %method = (\n                  'Glimmer'    => '_parse_prokaryotic',\n                  'GlimmerM'   => '_parse_eukaryotic',\n                  'GlimmerHMM' => '_parse_eukaryotic',\n                  '_DEFAULT_'  => '_parse_eukaryotic',\n              );\n    \n    my $format = $self->_format();\n    \n    if (!$format) {\n        \n        while (my $line = $self->_readline()) {\n\n            if ( $line =~ /^Glimmer\\S*\\s+\\(Version\\s*\\S+\\)/ ) {\n                $format = 'GlimmerM';\n                $self->_pushback($line);\n                last;\n            }\n            elsif ( $line =~ /^Glimmer\\S*$/ ) {\n                $format = 'GlimmerHMM';\n                $self->_pushback($line);\n                last;\n            }\n            elsif ($line =~ /^Putative Genes:$/) {\n                $format = 'Glimmer';\n                $self->_pushback($line);\n                last;\n            }\n            elsif ($line =~ /^>(\\S+)/) {\n                $format = 'Glimmer';\n                $self->_pushback($line);\n                last;\n            }\n            \n        }\n        \n    }\n\n    my $method =\n        (exists($method{$format})) ? $method{$format} : $method{'_DEFAULT_'};\n\n    return $self->$method();\n    \n}\n\n\n=head2 _parse_eukaryotic\n\n Title   : _parse_eukaryotic()\n Usage   : $obj->_parse_eukaryotic()\n Function: Parses the prediction section. Automatically called by\n           next_prediction() if not yet done.\n Example :\n Returns : \n\n\nsub _parse_eukaryotic {\n    my ($self) = @_;\n\n    my ($gene,$seqname,$seqlen,$source,$lastgenenum);\n    \n    while(defined($_ = $self->_readline())) {\n\tif( /^(Glimmer\\S*)\\s+\\(Version\\s*(\\S+)\\)/ ) {\n\t    $source = \"$1_$2\";\n\t    next;\n\t} elsif( /^(GlimmerHMM\\S*)$/ ) { # GlimmerHMM has no version\n\t    $source = $1;\n\t    next;\n\t} elsif(/^Sequence name:\\s+(.+)$/ ) {\n\t    $seqname = $1;\n\t    next;\n\t} elsif( /^Sequence length:\\s+(\\S+)/ ) {\n\t    $seqlen = $1;\n\t    next;\n\t} elsif( m/^(Predicted genes)|(Gene)|\\s+\\#/ || /^\\s+$/ ) { \n\t    next;\n\t    \n\t} elsif( # GlimmerM/HMM gene-exon prediction line\n\t\t /^\\s+(\\d+)\\s+ # gene num\n\t\t (\\d+)\\s+      # exon num\n\t\t ([\\+\\-])\\s+   # strand\n\t\t (\\S+)\\s+      # exon type\n\t\t (\\d+)\\s+(\\d+) # exon start, end\n\t\t \\s+(\\d+)      # exon length\t\t \n\t\t /ox ) {\n\t    my ($genenum,$exonnum,$strand,$type,$start,$end,$len) = \n\t\t( $1,$2,$3,$4,$5,$6,$7);\n\t    if( ! $lastgenenum || $lastgenenum != $genenum) {\t\t\n\t\t$self->_add_prediction($gene) if ( $gene );\n\t\t$gene = Bio::Tools::Prediction::Gene->new\n\t\t    (\n\t\t     '-seq_id'      => $seqname,\n\t\t     '-primary_tag' => \"gene\",\n\t\t     '-source_tag'  => $source,\n\t\t     '-tag'         => { 'Group' => \"GenePrediction$genenum\"},\n\t\t     );\n\t    }\n\t    my $exon = Bio::Tools::Prediction::Exon->new\n\t\t('-seq_id'     => $seqname,\n\t\t '-start'      => $start,\n\t\t '-end'        => $end,\n\t\t '-strand'     => $strand eq '-' ? '-1' : '1',\n\t\t '-source_tag' => $source,\n\t\t '-primary_tag'=> 'exon',\n\t\t '-tag'         => { 'Group' => \"GenePrediction$genenum\"},\n\t\t );\n\t    $gene->add_exon($exon,lc($type));\n\t    $lastgenenum = $genenum;\n\t}\n    }\n    $self->_add_prediction($gene) if( $gene );\n    $self->_predictions_parsed(1);\n}\n\n=head2 _parse_prokaryotic\n\n Title   : _parse_prokaryotic()\n Usage   : $obj->_parse_prokaryotic()\n Function: Parses the prediction section. Automatically called by\n           next_prediction() if not yet done.\n Example :\n Returns : \n\n\nsub _parse_prokaryotic {\n    my ($self) = @_;\n\n    # default value, possibly overriden later\n    my $source = 'Glimmer';\n\n    # Store the sequence length(s) here, either from the\n    # seqlength arg to the constructor, or from the\n    # Glimmer 3.X detail file\n    my %seqlength = ( );\n    \n    # Glimmer 2.X does not provide a sequence identifer\n    # in the prediction report (will default to unknown\n    # if not specified in the seqname arg to the\n    # constructor\n    #\n    # Glimmer 2.X does not report the length of the\n    # input sequence, either (will default to undef\n    # if not specified in the seqlength arg to the\n    # constructor\n    my $seqname = $self->_seqname();\n    my $seqlength = $self->_seqlength();\n\n    if (defined($seqlength)) {\n        $seqlength{$seqname} = $seqlength\n    }\n\n    # Parse the detail file, if we have one (Glimmer 3.X)\n    my $detail_file = $self->_detail_file();\n    \n    if (defined($detail_file)) {\n\n        my $io = Bio::Root::IO->new(-file => $detail_file);\n        my $seqname;\n        \n        while (defined($_ = $io->_readline())) {\n            if ($_ =~ /^>(\\S+)/) {\n                $seqname = $1;\n                next;\n            }\n\n            if (defined($seqname) && ($_ =~ /^Sequence length = (\\d+)$/)) {\n                $seqlength{$seqname} = $1;\n                next;\n            }\n        }\n    }\n    \n    my $location_factory = Bio::Factory::FTLocationFactory->new();\n    \n    while(defined($_ = $self->_readline())) {\n        # Glimmer 3.X does provide a sequence identifier -\n        # beware whitespace at the end (comes through from\n        # the fasta file)\n        if ($_ =~ /^Putative Genes:$/) {\n            $source = 'Glimmer_2.X';\n            next;\n        }\n        # Glimmer 3.X sequence identifier\n        elsif ($_ =~ /^>(\\S+)/) {\n            $seqname = $1;\n            $seqlength = $seqlength{$seqname};\n            $source = 'Glimmer_3.X';\n            next;\n        }        \n        elsif (\n               # Glimmer 2.X prediction \n               (/^\\s+(\\d+)\\s+      # gene num\n                (\\d+)\\s+(\\d+)\\s+   # start, end\n                \\[([\\+\\-])(\\d{1})\\s+ # strand, frame\n                /ox ) ||\n               # Glimmer 3.X prediction\n               (/^[^\\d]+(\\d+)\\s+    # orf (numeric portion)\n                (\\d+)\\s+(\\d+)\\s+   # start, end\n                ([\\+\\-])(\\d{1})\\s+   # strand, frame\n                ([\\d\\.]+)          # score\n                /ox)) {\n\t    my ($genenum,$start,$end,$strand,$frame,$score) = \n\t\t( $1,$2,$3,$4,$5,$6 );\n\n            my $circular_prediction = 0;\n\n            # Check for a circular prediction before we\n            # start fiddling with the coordinates\n            if ($strand eq '+') {\n                if ($start > $end) {\n                    $circular_prediction = 1;\n                }\n            }\n            else {\n                if ($start < $end) {\n                    $circular_prediction = 1;\n                }\n            }\n\n            if ($circular_prediction) {\n                unless (defined($seqlength)) {\n                    $self->throw(\"need to know the sequence length to handle wraparound genes\");\n                }\n            }\n            \n            # Glimmer 2.X predictions do not include\n            # the stop codon - this might extend the\n            # prediction off either end of the sequence.\n            # This works fine even on circular/wraparound\n            # predictions.  \n            if ($source eq 'Glimmer_2.X') {\n                if ($strand eq '+') { \n                    $end += 3;\n                }\n                else {\n                    $end -= 3;\n                }\n            }\n\n            # We might have extended a Glimmer 2.X prediction\n            # beyond the boundaries of the input sequence.\n            # Also, Glimmer 3.X (with -X) will output predictions\n            # with coordinates less than 1 or greater than the\n            # length of the sequence.\n            my ($fst, $fend);\n            foreach my $coord ($start, $end) {\n                if ($coord < 1) {\n                    $coord = '<1';\n                    $fst++;\n                } elsif (defined($seqlength) && ($coord > $seqlength)) {\n                    $coord = \">$seqlength\";\n                    $fend++;\n                }\n            }\n            \n            my $location_string;\n\n            if ($circular_prediction) {\n                if ($strand eq '+') {\n                    $location_string = \"join($start..$seqlength,1..$end)\";\n                }\n                else {\n                    $location_string = \"join($start..1,$seqlength..$end)\";\n                }\n                }\n            else {\n                # start must always be less than end for gene locations\n                if ($strand eq '-' && !$fst && !$fend && $start > $end) {\n                    ($start, $end) = ($end, $start);\n                }\n                $location_string = \"$start..$end\";\n            }\n            \n            my $location_object =\n                $location_factory->from_string($location_string);\n            \n            # convert glimmer's frame range from 1-3 to SeqFeature's 0-2.\n            $frame--;\n            \n            my $gene = Bio::SeqFeature::Generic->new\n                (\n                 '-seq_id'      => $seqname,\n                 '-location'   => $location_object,\n                 '-strand'     => $strand eq '-' ? '-1' : '1',\n                 '-frame'\t\t=> $frame,\n                 '-source_tag'  => $source,\n                 '-display_name' => \"orf$genenum\",\n                 '-primary_tag'=> 'gene',\n                 '-tag'         => { 'Group' => \"GenePrediction_$genenum\"},\n                 '-score'       => $score || undef\n             );\n            \n            $self->_add_prediction($gene) \n\t}\n    }\n    \n    $self->_predictions_parsed(1);\n}\n\n=head2 _prediction\n\n Title   : _prediction()\n Usage   : $gene = $obj->_prediction()\n Function: internal\n Example :\n Returns : ","parameters":[{"label":"$self"}],"label":"_prediction($self)"},"detail":"($self)","definition":"sub","containerName":"main::","range":{"start":{"line":593,"character":0},"end":{"character":9999,"line":596}},"name":"_prediction"},{"containerName":null,"name":"%self","kind":13,"line":597},{"name":"_add_prediction","range":{"end":{"line":616,"character":9999},"start":{"character":0,"line":610}},"containerName":"main::","definition":"sub","detail":"($self,$gene)","signature":{"documentation":"1;\n# $Id: Glimmer.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Glimmer\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Glimmer - parser for Glimmer 2.X/3.X prokaryotic and \nGlimmerM/GlimmerHMM eukaryotic gene predictions\n\n=head1 SYNOPSIS\n\n   use Bio::Tools::Glimmer;\n\n   # file\n   my $parser = Bio::Tools::Glimmer->new(-file => $file);\n   # filehandle:\n   $parser = Bio::Tools::Glimmer->new( -fh  => \\*INPUT );\n   # provide a sequence identifier (Glimmer 2.X)\n   my $parser = Bio::Tools::Glimmer->new(-file => $file, -seqname => seqname);\n   # force format (override automatic detection)\n   my $parser = Bio::Tools::Glimmer->new(-file => $file, -format => 'GlimmerM');\n\n   # parse the results\n   # note: this class is-a Bio::Tools::AnalysisResult which implements\n   # Bio::SeqAnalysisParserI, i.e., $glimmer->next_feature() is the same\n\n   while(my $gene = $parser->next_prediction()) {\n       # For eukaryotic input (GlimmerM/GlimmerHMM), $gene will be an instance\n       # of Bio::Tools::Prediction::Gene, which inherits off\n       # Bio::SeqFeature::Gene::Transcript, and $gene->exons() will return an\n       # array of Bio::Tools::Prediction::Exon objects.\n       # For prokaryotic input (Glimmer2.X/Glimmer3.X), $gene will be an\n       # instance of Bio::SeqFeature::Generic\n\n       # all exons (eukaryotic only):\n       @exon_arr = $gene->exons();\n       # initial exons only\n       @init_exons = $gene->exons('Initial');\n       # internal exons only\n       @intrl_exons = $gene->exons('Internal');\n       # terminal exons only\n       @term_exons = $gene->exons('Terminal');\n   }\n\n=head1 DESCRIPTION\n\nThis is a module for parsing Glimmer, GlimmerM and GlimmerHMM predictions.  \nIt will create gene objects from the prediction report which can \nbe attached to a sequence using Bioperl objects, or output as GFF \nsuitable for loading into Bio::DB::GFF for use with Gbrowse.\n\nGlimmer is open source and available at\nL<http://www.cbcb.umd.edu/software/glimmer/>.\n\nGlimmerM is open source and available at \nL<http://www.tigr.org/software/glimmerm/>.\n\nGlimmerHMM is open source and available at\nL<http://www.cbcb.umd.edu/software/GlimmerHMM/>.\n\nNote that Glimmer 2.X will only process the first\nsequence in a fasta file, and the prediction report does not contain any\nsort of sequence identifier\n\nNote that Glimmer 3.X produces two output files.  This module only parses\nthe .predict file.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nemail or the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nTorsten Seemann\n\nMark Johnson\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Glimmer;\nuse strict;\n\nuse Bio::Factory::FTLocationFactory;\nuse Bio::Tools::Prediction::Gene;\nuse Bio::Tools::Prediction::Exon;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\nsub _initialize_state {\n    my($self,@args) = @_;\n\n    # first call the inherited method!\n    my $make = $self->SUPER::_initialize_state(@args);\n\n    $self->{'_preds_parsed'} = 0;\n    # array of pre-parsed predictions\n    $self->{'_preds'} = [];\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::Glimmer->new();\n Function: Builds a new Bio::Tools::Glimmer object \n Returns : an instance of Bio::Tools::Glimmer\n Args    : format ('Glimmer', 'GlimmerM', 'GlimmerHMM'), seqname\n\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  my ($format, $seqname, $seqlength, $detail) =\n      $self->_rearrange([qw(FORMAT SEQNAME SEQLENGTH DETAIL)], @args);\n\n  # override automagic format detection\n  if (defined($format) &&\n      (($format eq 'Glimmer')  ||\n       ($format eq 'GlimmerM') ||\n       ($format eq 'GlimmerHMM'))\n  ) {\n      $self->_format($format);\n  }\n  \n  if (defined($detail)) {\n      $self->_format('Glimmer');\n      $self->_detail_file($detail);\n  }\n  \n  # hardwire seq_id when creating gene and exon objects (Glimmer 2.X)\n  $self->_seqname($seqname) if defined($seqname);\n  \n  # store the length of the input sequence (Glimmer 2.X)\n  $self->_seqlength($seqlength) if defined($seqlength);\n  \n  return $self;\n}\n\n=head2 analysis_method\n\n Usage     : $glimmer->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /glimmer/i.\n Returns   : String\n Argument  : n/a\n\n\n#-------------\nsub analysis_method { \n#-------------\n    my ($self, $method) = @_;  \n    if($method && ($method !~ /glimmer/i)) {\n\t$self->throw(\"method $method not supported in \" . ref($self));\n    }\n    return $self->SUPER::analysis_method($method);\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : while($gene = $glimmer->next_feature()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the Glimmer result\n           file. Call this method repeatedly until FALSE is returned.\n\n           The returned object is actually a SeqFeatureI implementing object.\n           This method is required for classes implementing the\n           SeqAnalysisParserI interface, and is merely an alias for \n           next_prediction() at present.\n\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :\n\n\nsub next_feature {\n    my ($self,@args) = @_;\n    # even though next_prediction doesn't expect any args (and this method\n    # does neither), we pass on args in order to be prepared if this changes\n    # ever\n    return $self->next_prediction(@args);\n}\n\n=head2 next_prediction\n\n Title   : next_prediction\n Usage   : while($gene = $glimmer->next_prediction()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the Glimmer result\n           file. Call this method repeatedly until FALSE is returned.\n\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :\n\n\nsub next_prediction {\n    my ($self) = @_;\n    my $gene;\n\n    # if the prediction section hasn't been parsed yet, we do this now\n    $self->_parse_predictions() unless $self->_predictions_parsed();\n    \n    # get next gene structure\n    $gene = $self->_prediction();\n    return $gene;\n}\n\n=head2 _parse_predictions\n\n Title   : _parse_predictions()\n Usage   : $obj->_parse_predictions()\n Function: Parses the prediction section. Automatically called by\n           next_prediction() if not yet done.\n Example :\n Returns : \n\n\nsub _parse_predictions {\n\n    my ($self) = @_;\n\n    \n    my %method = (\n                  'Glimmer'    => '_parse_prokaryotic',\n                  'GlimmerM'   => '_parse_eukaryotic',\n                  'GlimmerHMM' => '_parse_eukaryotic',\n                  '_DEFAULT_'  => '_parse_eukaryotic',\n              );\n    \n    my $format = $self->_format();\n    \n    if (!$format) {\n        \n        while (my $line = $self->_readline()) {\n\n            if ( $line =~ /^Glimmer\\S*\\s+\\(Version\\s*\\S+\\)/ ) {\n                $format = 'GlimmerM';\n                $self->_pushback($line);\n                last;\n            }\n            elsif ( $line =~ /^Glimmer\\S*$/ ) {\n                $format = 'GlimmerHMM';\n                $self->_pushback($line);\n                last;\n            }\n            elsif ($line =~ /^Putative Genes:$/) {\n                $format = 'Glimmer';\n                $self->_pushback($line);\n                last;\n            }\n            elsif ($line =~ /^>(\\S+)/) {\n                $format = 'Glimmer';\n                $self->_pushback($line);\n                last;\n            }\n            \n        }\n        \n    }\n\n    my $method =\n        (exists($method{$format})) ? $method{$format} : $method{'_DEFAULT_'};\n\n    return $self->$method();\n    \n}\n\n\n=head2 _parse_eukaryotic\n\n Title   : _parse_eukaryotic()\n Usage   : $obj->_parse_eukaryotic()\n Function: Parses the prediction section. Automatically called by\n           next_prediction() if not yet done.\n Example :\n Returns : \n\n\nsub _parse_eukaryotic {\n    my ($self) = @_;\n\n    my ($gene,$seqname,$seqlen,$source,$lastgenenum);\n    \n    while(defined($_ = $self->_readline())) {\n\tif( /^(Glimmer\\S*)\\s+\\(Version\\s*(\\S+)\\)/ ) {\n\t    $source = \"$1_$2\";\n\t    next;\n\t} elsif( /^(GlimmerHMM\\S*)$/ ) { # GlimmerHMM has no version\n\t    $source = $1;\n\t    next;\n\t} elsif(/^Sequence name:\\s+(.+)$/ ) {\n\t    $seqname = $1;\n\t    next;\n\t} elsif( /^Sequence length:\\s+(\\S+)/ ) {\n\t    $seqlen = $1;\n\t    next;\n\t} elsif( m/^(Predicted genes)|(Gene)|\\s+\\#/ || /^\\s+$/ ) { \n\t    next;\n\t    \n\t} elsif( # GlimmerM/HMM gene-exon prediction line\n\t\t /^\\s+(\\d+)\\s+ # gene num\n\t\t (\\d+)\\s+      # exon num\n\t\t ([\\+\\-])\\s+   # strand\n\t\t (\\S+)\\s+      # exon type\n\t\t (\\d+)\\s+(\\d+) # exon start, end\n\t\t \\s+(\\d+)      # exon length\t\t \n\t\t /ox ) {\n\t    my ($genenum,$exonnum,$strand,$type,$start,$end,$len) = \n\t\t( $1,$2,$3,$4,$5,$6,$7);\n\t    if( ! $lastgenenum || $lastgenenum != $genenum) {\t\t\n\t\t$self->_add_prediction($gene) if ( $gene );\n\t\t$gene = Bio::Tools::Prediction::Gene->new\n\t\t    (\n\t\t     '-seq_id'      => $seqname,\n\t\t     '-primary_tag' => \"gene\",\n\t\t     '-source_tag'  => $source,\n\t\t     '-tag'         => { 'Group' => \"GenePrediction$genenum\"},\n\t\t     );\n\t    }\n\t    my $exon = Bio::Tools::Prediction::Exon->new\n\t\t('-seq_id'     => $seqname,\n\t\t '-start'      => $start,\n\t\t '-end'        => $end,\n\t\t '-strand'     => $strand eq '-' ? '-1' : '1',\n\t\t '-source_tag' => $source,\n\t\t '-primary_tag'=> 'exon',\n\t\t '-tag'         => { 'Group' => \"GenePrediction$genenum\"},\n\t\t );\n\t    $gene->add_exon($exon,lc($type));\n\t    $lastgenenum = $genenum;\n\t}\n    }\n    $self->_add_prediction($gene) if( $gene );\n    $self->_predictions_parsed(1);\n}\n\n=head2 _parse_prokaryotic\n\n Title   : _parse_prokaryotic()\n Usage   : $obj->_parse_prokaryotic()\n Function: Parses the prediction section. Automatically called by\n           next_prediction() if not yet done.\n Example :\n Returns : \n\n\nsub _parse_prokaryotic {\n    my ($self) = @_;\n\n    # default value, possibly overriden later\n    my $source = 'Glimmer';\n\n    # Store the sequence length(s) here, either from the\n    # seqlength arg to the constructor, or from the\n    # Glimmer 3.X detail file\n    my %seqlength = ( );\n    \n    # Glimmer 2.X does not provide a sequence identifer\n    # in the prediction report (will default to unknown\n    # if not specified in the seqname arg to the\n    # constructor\n    #\n    # Glimmer 2.X does not report the length of the\n    # input sequence, either (will default to undef\n    # if not specified in the seqlength arg to the\n    # constructor\n    my $seqname = $self->_seqname();\n    my $seqlength = $self->_seqlength();\n\n    if (defined($seqlength)) {\n        $seqlength{$seqname} = $seqlength\n    }\n\n    # Parse the detail file, if we have one (Glimmer 3.X)\n    my $detail_file = $self->_detail_file();\n    \n    if (defined($detail_file)) {\n\n        my $io = Bio::Root::IO->new(-file => $detail_file);\n        my $seqname;\n        \n        while (defined($_ = $io->_readline())) {\n            if ($_ =~ /^>(\\S+)/) {\n                $seqname = $1;\n                next;\n            }\n\n            if (defined($seqname) && ($_ =~ /^Sequence length = (\\d+)$/)) {\n                $seqlength{$seqname} = $1;\n                next;\n            }\n        }\n    }\n    \n    my $location_factory = Bio::Factory::FTLocationFactory->new();\n    \n    while(defined($_ = $self->_readline())) {\n        # Glimmer 3.X does provide a sequence identifier -\n        # beware whitespace at the end (comes through from\n        # the fasta file)\n        if ($_ =~ /^Putative Genes:$/) {\n            $source = 'Glimmer_2.X';\n            next;\n        }\n        # Glimmer 3.X sequence identifier\n        elsif ($_ =~ /^>(\\S+)/) {\n            $seqname = $1;\n            $seqlength = $seqlength{$seqname};\n            $source = 'Glimmer_3.X';\n            next;\n        }        \n        elsif (\n               # Glimmer 2.X prediction \n               (/^\\s+(\\d+)\\s+      # gene num\n                (\\d+)\\s+(\\d+)\\s+   # start, end\n                \\[([\\+\\-])(\\d{1})\\s+ # strand, frame\n                /ox ) ||\n               # Glimmer 3.X prediction\n               (/^[^\\d]+(\\d+)\\s+    # orf (numeric portion)\n                (\\d+)\\s+(\\d+)\\s+   # start, end\n                ([\\+\\-])(\\d{1})\\s+   # strand, frame\n                ([\\d\\.]+)          # score\n                /ox)) {\n\t    my ($genenum,$start,$end,$strand,$frame,$score) = \n\t\t( $1,$2,$3,$4,$5,$6 );\n\n            my $circular_prediction = 0;\n\n            # Check for a circular prediction before we\n            # start fiddling with the coordinates\n            if ($strand eq '+') {\n                if ($start > $end) {\n                    $circular_prediction = 1;\n                }\n            }\n            else {\n                if ($start < $end) {\n                    $circular_prediction = 1;\n                }\n            }\n\n            if ($circular_prediction) {\n                unless (defined($seqlength)) {\n                    $self->throw(\"need to know the sequence length to handle wraparound genes\");\n                }\n            }\n            \n            # Glimmer 2.X predictions do not include\n            # the stop codon - this might extend the\n            # prediction off either end of the sequence.\n            # This works fine even on circular/wraparound\n            # predictions.  \n            if ($source eq 'Glimmer_2.X') {\n                if ($strand eq '+') { \n                    $end += 3;\n                }\n                else {\n                    $end -= 3;\n                }\n            }\n\n            # We might have extended a Glimmer 2.X prediction\n            # beyond the boundaries of the input sequence.\n            # Also, Glimmer 3.X (with -X) will output predictions\n            # with coordinates less than 1 or greater than the\n            # length of the sequence.\n            my ($fst, $fend);\n            foreach my $coord ($start, $end) {\n                if ($coord < 1) {\n                    $coord = '<1';\n                    $fst++;\n                } elsif (defined($seqlength) && ($coord > $seqlength)) {\n                    $coord = \">$seqlength\";\n                    $fend++;\n                }\n            }\n            \n            my $location_string;\n\n            if ($circular_prediction) {\n                if ($strand eq '+') {\n                    $location_string = \"join($start..$seqlength,1..$end)\";\n                }\n                else {\n                    $location_string = \"join($start..1,$seqlength..$end)\";\n                }\n                }\n            else {\n                # start must always be less than end for gene locations\n                if ($strand eq '-' && !$fst && !$fend && $start > $end) {\n                    ($start, $end) = ($end, $start);\n                }\n                $location_string = \"$start..$end\";\n            }\n            \n            my $location_object =\n                $location_factory->from_string($location_string);\n            \n            # convert glimmer's frame range from 1-3 to SeqFeature's 0-2.\n            $frame--;\n            \n            my $gene = Bio::SeqFeature::Generic->new\n                (\n                 '-seq_id'      => $seqname,\n                 '-location'   => $location_object,\n                 '-strand'     => $strand eq '-' ? '-1' : '1',\n                 '-frame'\t\t=> $frame,\n                 '-source_tag'  => $source,\n                 '-display_name' => \"orf$genenum\",\n                 '-primary_tag'=> 'gene',\n                 '-tag'         => { 'Group' => \"GenePrediction_$genenum\"},\n                 '-score'       => $score || undef\n             );\n            \n            $self->_add_prediction($gene) \n\t}\n    }\n    \n    $self->_predictions_parsed(1);\n}\n\n=head2 _prediction\n\n Title   : _prediction()\n Usage   : $gene = $obj->_prediction()\n Function: internal\n Example :\n Returns : \n\n\nsub _prediction {\n    my ($self) = @_;\n\n    return unless(exists($self->{'_preds'}) && @{$self->{'_preds'}});\n    return shift(@{$self->{'_preds'}});\n}\n\n=head2 _add_prediction\n\n Title   : _add_prediction()\n Usage   : $obj->_add_prediction($gene)\n Function: internal\n Example :\n Returns : ","parameters":[{"label":"$self"},{"label":"$gene"}],"label":"_add_prediction($self,$gene)"},"kind":12,"line":610,"children":[{"definition":"my","name":"$self","containerName":"_add_prediction","localvar":"my","kind":13,"line":611},{"name":"$gene","containerName":"_add_prediction","kind":13,"line":611},{"kind":13,"line":613,"name":"$self","containerName":"_add_prediction"},{"name":"$self","containerName":"_add_prediction","line":614,"kind":13},{"name":"$self","containerName":"_add_prediction","line":616,"kind":13}]},{"kind":13,"line":616,"name":"$gene","containerName":null},{"kind":12,"line":629,"children":[{"name":"$self","definition":"my","containerName":"_predictions_parsed","localvar":"my","kind":13,"line":630},{"line":630,"kind":13,"containerName":"_predictions_parsed","name":"$val"},{"kind":13,"line":632,"containerName":"_predictions_parsed","name":"$self"},{"line":632,"kind":13,"containerName":"_predictions_parsed","name":"$val"},{"line":632,"kind":13,"containerName":"_predictions_parsed","name":"$val"},{"containerName":"_predictions_parsed","name":"$self","line":633,"kind":13},{"line":634,"kind":13,"name":"$self","containerName":"_predictions_parsed"},{"kind":13,"line":636,"name":"$self","containerName":"_predictions_parsed"}],"containerName":"main::","definition":"sub","detail":"($self,$val)","signature":{"parameters":[{"label":"$self"},{"label":"$val"}],"documentation":"1;\n# $Id: Glimmer.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Glimmer\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Glimmer - parser for Glimmer 2.X/3.X prokaryotic and \nGlimmerM/GlimmerHMM eukaryotic gene predictions\n\n=head1 SYNOPSIS\n\n   use Bio::Tools::Glimmer;\n\n   # file\n   my $parser = Bio::Tools::Glimmer->new(-file => $file);\n   # filehandle:\n   $parser = Bio::Tools::Glimmer->new( -fh  => \\*INPUT );\n   # provide a sequence identifier (Glimmer 2.X)\n   my $parser = Bio::Tools::Glimmer->new(-file => $file, -seqname => seqname);\n   # force format (override automatic detection)\n   my $parser = Bio::Tools::Glimmer->new(-file => $file, -format => 'GlimmerM');\n\n   # parse the results\n   # note: this class is-a Bio::Tools::AnalysisResult which implements\n   # Bio::SeqAnalysisParserI, i.e., $glimmer->next_feature() is the same\n\n   while(my $gene = $parser->next_prediction()) {\n       # For eukaryotic input (GlimmerM/GlimmerHMM), $gene will be an instance\n       # of Bio::Tools::Prediction::Gene, which inherits off\n       # Bio::SeqFeature::Gene::Transcript, and $gene->exons() will return an\n       # array of Bio::Tools::Prediction::Exon objects.\n       # For prokaryotic input (Glimmer2.X/Glimmer3.X), $gene will be an\n       # instance of Bio::SeqFeature::Generic\n\n       # all exons (eukaryotic only):\n       @exon_arr = $gene->exons();\n       # initial exons only\n       @init_exons = $gene->exons('Initial');\n       # internal exons only\n       @intrl_exons = $gene->exons('Internal');\n       # terminal exons only\n       @term_exons = $gene->exons('Terminal');\n   }\n\n=head1 DESCRIPTION\n\nThis is a module for parsing Glimmer, GlimmerM and GlimmerHMM predictions.  \nIt will create gene objects from the prediction report which can \nbe attached to a sequence using Bioperl objects, or output as GFF \nsuitable for loading into Bio::DB::GFF for use with Gbrowse.\n\nGlimmer is open source and available at\nL<http://www.cbcb.umd.edu/software/glimmer/>.\n\nGlimmerM is open source and available at \nL<http://www.tigr.org/software/glimmerm/>.\n\nGlimmerHMM is open source and available at\nL<http://www.cbcb.umd.edu/software/GlimmerHMM/>.\n\nNote that Glimmer 2.X will only process the first\nsequence in a fasta file, and the prediction report does not contain any\nsort of sequence identifier\n\nNote that Glimmer 3.X produces two output files.  This module only parses\nthe .predict file.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nemail or the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nTorsten Seemann\n\nMark Johnson\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Glimmer;\nuse strict;\n\nuse Bio::Factory::FTLocationFactory;\nuse Bio::Tools::Prediction::Gene;\nuse Bio::Tools::Prediction::Exon;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\nsub _initialize_state {\n    my($self,@args) = @_;\n\n    # first call the inherited method!\n    my $make = $self->SUPER::_initialize_state(@args);\n\n    $self->{'_preds_parsed'} = 0;\n    # array of pre-parsed predictions\n    $self->{'_preds'} = [];\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::Glimmer->new();\n Function: Builds a new Bio::Tools::Glimmer object \n Returns : an instance of Bio::Tools::Glimmer\n Args    : format ('Glimmer', 'GlimmerM', 'GlimmerHMM'), seqname\n\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  my ($format, $seqname, $seqlength, $detail) =\n      $self->_rearrange([qw(FORMAT SEQNAME SEQLENGTH DETAIL)], @args);\n\n  # override automagic format detection\n  if (defined($format) &&\n      (($format eq 'Glimmer')  ||\n       ($format eq 'GlimmerM') ||\n       ($format eq 'GlimmerHMM'))\n  ) {\n      $self->_format($format);\n  }\n  \n  if (defined($detail)) {\n      $self->_format('Glimmer');\n      $self->_detail_file($detail);\n  }\n  \n  # hardwire seq_id when creating gene and exon objects (Glimmer 2.X)\n  $self->_seqname($seqname) if defined($seqname);\n  \n  # store the length of the input sequence (Glimmer 2.X)\n  $self->_seqlength($seqlength) if defined($seqlength);\n  \n  return $self;\n}\n\n=head2 analysis_method\n\n Usage     : $glimmer->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /glimmer/i.\n Returns   : String\n Argument  : n/a\n\n\n#-------------\nsub analysis_method { \n#-------------\n    my ($self, $method) = @_;  \n    if($method && ($method !~ /glimmer/i)) {\n\t$self->throw(\"method $method not supported in \" . ref($self));\n    }\n    return $self->SUPER::analysis_method($method);\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : while($gene = $glimmer->next_feature()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the Glimmer result\n           file. Call this method repeatedly until FALSE is returned.\n\n           The returned object is actually a SeqFeatureI implementing object.\n           This method is required for classes implementing the\n           SeqAnalysisParserI interface, and is merely an alias for \n           next_prediction() at present.\n\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :\n\n\nsub next_feature {\n    my ($self,@args) = @_;\n    # even though next_prediction doesn't expect any args (and this method\n    # does neither), we pass on args in order to be prepared if this changes\n    # ever\n    return $self->next_prediction(@args);\n}\n\n=head2 next_prediction\n\n Title   : next_prediction\n Usage   : while($gene = $glimmer->next_prediction()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the Glimmer result\n           file. Call this method repeatedly until FALSE is returned.\n\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :\n\n\nsub next_prediction {\n    my ($self) = @_;\n    my $gene;\n\n    # if the prediction section hasn't been parsed yet, we do this now\n    $self->_parse_predictions() unless $self->_predictions_parsed();\n    \n    # get next gene structure\n    $gene = $self->_prediction();\n    return $gene;\n}\n\n=head2 _parse_predictions\n\n Title   : _parse_predictions()\n Usage   : $obj->_parse_predictions()\n Function: Parses the prediction section. Automatically called by\n           next_prediction() if not yet done.\n Example :\n Returns : \n\n\nsub _parse_predictions {\n\n    my ($self) = @_;\n\n    \n    my %method = (\n                  'Glimmer'    => '_parse_prokaryotic',\n                  'GlimmerM'   => '_parse_eukaryotic',\n                  'GlimmerHMM' => '_parse_eukaryotic',\n                  '_DEFAULT_'  => '_parse_eukaryotic',\n              );\n    \n    my $format = $self->_format();\n    \n    if (!$format) {\n        \n        while (my $line = $self->_readline()) {\n\n            if ( $line =~ /^Glimmer\\S*\\s+\\(Version\\s*\\S+\\)/ ) {\n                $format = 'GlimmerM';\n                $self->_pushback($line);\n                last;\n            }\n            elsif ( $line =~ /^Glimmer\\S*$/ ) {\n                $format = 'GlimmerHMM';\n                $self->_pushback($line);\n                last;\n            }\n            elsif ($line =~ /^Putative Genes:$/) {\n                $format = 'Glimmer';\n                $self->_pushback($line);\n                last;\n            }\n            elsif ($line =~ /^>(\\S+)/) {\n                $format = 'Glimmer';\n                $self->_pushback($line);\n                last;\n            }\n            \n        }\n        \n    }\n\n    my $method =\n        (exists($method{$format})) ? $method{$format} : $method{'_DEFAULT_'};\n\n    return $self->$method();\n    \n}\n\n\n=head2 _parse_eukaryotic\n\n Title   : _parse_eukaryotic()\n Usage   : $obj->_parse_eukaryotic()\n Function: Parses the prediction section. Automatically called by\n           next_prediction() if not yet done.\n Example :\n Returns : \n\n\nsub _parse_eukaryotic {\n    my ($self) = @_;\n\n    my ($gene,$seqname,$seqlen,$source,$lastgenenum);\n    \n    while(defined($_ = $self->_readline())) {\n\tif( /^(Glimmer\\S*)\\s+\\(Version\\s*(\\S+)\\)/ ) {\n\t    $source = \"$1_$2\";\n\t    next;\n\t} elsif( /^(GlimmerHMM\\S*)$/ ) { # GlimmerHMM has no version\n\t    $source = $1;\n\t    next;\n\t} elsif(/^Sequence name:\\s+(.+)$/ ) {\n\t    $seqname = $1;\n\t    next;\n\t} elsif( /^Sequence length:\\s+(\\S+)/ ) {\n\t    $seqlen = $1;\n\t    next;\n\t} elsif( m/^(Predicted genes)|(Gene)|\\s+\\#/ || /^\\s+$/ ) { \n\t    next;\n\t    \n\t} elsif( # GlimmerM/HMM gene-exon prediction line\n\t\t /^\\s+(\\d+)\\s+ # gene num\n\t\t (\\d+)\\s+      # exon num\n\t\t ([\\+\\-])\\s+   # strand\n\t\t (\\S+)\\s+      # exon type\n\t\t (\\d+)\\s+(\\d+) # exon start, end\n\t\t \\s+(\\d+)      # exon length\t\t \n\t\t /ox ) {\n\t    my ($genenum,$exonnum,$strand,$type,$start,$end,$len) = \n\t\t( $1,$2,$3,$4,$5,$6,$7);\n\t    if( ! $lastgenenum || $lastgenenum != $genenum) {\t\t\n\t\t$self->_add_prediction($gene) if ( $gene );\n\t\t$gene = Bio::Tools::Prediction::Gene->new\n\t\t    (\n\t\t     '-seq_id'      => $seqname,\n\t\t     '-primary_tag' => \"gene\",\n\t\t     '-source_tag'  => $source,\n\t\t     '-tag'         => { 'Group' => \"GenePrediction$genenum\"},\n\t\t     );\n\t    }\n\t    my $exon = Bio::Tools::Prediction::Exon->new\n\t\t('-seq_id'     => $seqname,\n\t\t '-start'      => $start,\n\t\t '-end'        => $end,\n\t\t '-strand'     => $strand eq '-' ? '-1' : '1',\n\t\t '-source_tag' => $source,\n\t\t '-primary_tag'=> 'exon',\n\t\t '-tag'         => { 'Group' => \"GenePrediction$genenum\"},\n\t\t );\n\t    $gene->add_exon($exon,lc($type));\n\t    $lastgenenum = $genenum;\n\t}\n    }\n    $self->_add_prediction($gene) if( $gene );\n    $self->_predictions_parsed(1);\n}\n\n=head2 _parse_prokaryotic\n\n Title   : _parse_prokaryotic()\n Usage   : $obj->_parse_prokaryotic()\n Function: Parses the prediction section. Automatically called by\n           next_prediction() if not yet done.\n Example :\n Returns : \n\n\nsub _parse_prokaryotic {\n    my ($self) = @_;\n\n    # default value, possibly overriden later\n    my $source = 'Glimmer';\n\n    # Store the sequence length(s) here, either from the\n    # seqlength arg to the constructor, or from the\n    # Glimmer 3.X detail file\n    my %seqlength = ( );\n    \n    # Glimmer 2.X does not provide a sequence identifer\n    # in the prediction report (will default to unknown\n    # if not specified in the seqname arg to the\n    # constructor\n    #\n    # Glimmer 2.X does not report the length of the\n    # input sequence, either (will default to undef\n    # if not specified in the seqlength arg to the\n    # constructor\n    my $seqname = $self->_seqname();\n    my $seqlength = $self->_seqlength();\n\n    if (defined($seqlength)) {\n        $seqlength{$seqname} = $seqlength\n    }\n\n    # Parse the detail file, if we have one (Glimmer 3.X)\n    my $detail_file = $self->_detail_file();\n    \n    if (defined($detail_file)) {\n\n        my $io = Bio::Root::IO->new(-file => $detail_file);\n        my $seqname;\n        \n        while (defined($_ = $io->_readline())) {\n            if ($_ =~ /^>(\\S+)/) {\n                $seqname = $1;\n                next;\n            }\n\n            if (defined($seqname) && ($_ =~ /^Sequence length = (\\d+)$/)) {\n                $seqlength{$seqname} = $1;\n                next;\n            }\n        }\n    }\n    \n    my $location_factory = Bio::Factory::FTLocationFactory->new();\n    \n    while(defined($_ = $self->_readline())) {\n        # Glimmer 3.X does provide a sequence identifier -\n        # beware whitespace at the end (comes through from\n        # the fasta file)\n        if ($_ =~ /^Putative Genes:$/) {\n            $source = 'Glimmer_2.X';\n            next;\n        }\n        # Glimmer 3.X sequence identifier\n        elsif ($_ =~ /^>(\\S+)/) {\n            $seqname = $1;\n            $seqlength = $seqlength{$seqname};\n            $source = 'Glimmer_3.X';\n            next;\n        }        \n        elsif (\n               # Glimmer 2.X prediction \n               (/^\\s+(\\d+)\\s+      # gene num\n                (\\d+)\\s+(\\d+)\\s+   # start, end\n                \\[([\\+\\-])(\\d{1})\\s+ # strand, frame\n                /ox ) ||\n               # Glimmer 3.X prediction\n               (/^[^\\d]+(\\d+)\\s+    # orf (numeric portion)\n                (\\d+)\\s+(\\d+)\\s+   # start, end\n                ([\\+\\-])(\\d{1})\\s+   # strand, frame\n                ([\\d\\.]+)          # score\n                /ox)) {\n\t    my ($genenum,$start,$end,$strand,$frame,$score) = \n\t\t( $1,$2,$3,$4,$5,$6 );\n\n            my $circular_prediction = 0;\n\n            # Check for a circular prediction before we\n            # start fiddling with the coordinates\n            if ($strand eq '+') {\n                if ($start > $end) {\n                    $circular_prediction = 1;\n                }\n            }\n            else {\n                if ($start < $end) {\n                    $circular_prediction = 1;\n                }\n            }\n\n            if ($circular_prediction) {\n                unless (defined($seqlength)) {\n                    $self->throw(\"need to know the sequence length to handle wraparound genes\");\n                }\n            }\n            \n            # Glimmer 2.X predictions do not include\n            # the stop codon - this might extend the\n            # prediction off either end of the sequence.\n            # This works fine even on circular/wraparound\n            # predictions.  \n            if ($source eq 'Glimmer_2.X') {\n                if ($strand eq '+') { \n                    $end += 3;\n                }\n                else {\n                    $end -= 3;\n                }\n            }\n\n            # We might have extended a Glimmer 2.X prediction\n            # beyond the boundaries of the input sequence.\n            # Also, Glimmer 3.X (with -X) will output predictions\n            # with coordinates less than 1 or greater than the\n            # length of the sequence.\n            my ($fst, $fend);\n            foreach my $coord ($start, $end) {\n                if ($coord < 1) {\n                    $coord = '<1';\n                    $fst++;\n                } elsif (defined($seqlength) && ($coord > $seqlength)) {\n                    $coord = \">$seqlength\";\n                    $fend++;\n                }\n            }\n            \n            my $location_string;\n\n            if ($circular_prediction) {\n                if ($strand eq '+') {\n                    $location_string = \"join($start..$seqlength,1..$end)\";\n                }\n                else {\n                    $location_string = \"join($start..1,$seqlength..$end)\";\n                }\n                }\n            else {\n                # start must always be less than end for gene locations\n                if ($strand eq '-' && !$fst && !$fend && $start > $end) {\n                    ($start, $end) = ($end, $start);\n                }\n                $location_string = \"$start..$end\";\n            }\n            \n            my $location_object =\n                $location_factory->from_string($location_string);\n            \n            # convert glimmer's frame range from 1-3 to SeqFeature's 0-2.\n            $frame--;\n            \n            my $gene = Bio::SeqFeature::Generic->new\n                (\n                 '-seq_id'      => $seqname,\n                 '-location'   => $location_object,\n                 '-strand'     => $strand eq '-' ? '-1' : '1',\n                 '-frame'\t\t=> $frame,\n                 '-source_tag'  => $source,\n                 '-display_name' => \"orf$genenum\",\n                 '-primary_tag'=> 'gene',\n                 '-tag'         => { 'Group' => \"GenePrediction_$genenum\"},\n                 '-score'       => $score || undef\n             );\n            \n            $self->_add_prediction($gene) \n\t}\n    }\n    \n    $self->_predictions_parsed(1);\n}\n\n=head2 _prediction\n\n Title   : _prediction()\n Usage   : $gene = $obj->_prediction()\n Function: internal\n Example :\n Returns : \n\n\nsub _prediction {\n    my ($self) = @_;\n\n    return unless(exists($self->{'_preds'}) && @{$self->{'_preds'}});\n    return shift(@{$self->{'_preds'}});\n}\n\n=head2 _add_prediction\n\n Title   : _add_prediction()\n Usage   : $obj->_add_prediction($gene)\n Function: internal\n Example :\n Returns : \n\n\nsub _add_prediction {\n    my ($self, $gene) = @_;\n\n    if(! exists($self->{'_preds'})) {\n\t$self->{'_preds'} = [];\n    }\n    push(@{$self->{'_preds'}}, $gene);\n}\n\n=head2 _predictions_parsed\n\n Title   : _predictions_parsed\n Usage   : $obj->_predictions_parsed\n Function: internal\n Example :\n Returns : TRUE or FALSE","label":"_predictions_parsed($self,$val)"},"name":"_predictions_parsed","range":{"end":{"character":9999,"line":637},"start":{"character":0,"line":629}}},{"detail":"($self,$val)","signature":{"label":"_seqname($self,$val)","parameters":[{"label":"$self"},{"label":"$val"}],"documentation":"1;\n# $Id: Glimmer.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Glimmer\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Glimmer - parser for Glimmer 2.X/3.X prokaryotic and \nGlimmerM/GlimmerHMM eukaryotic gene predictions\n\n=head1 SYNOPSIS\n\n   use Bio::Tools::Glimmer;\n\n   # file\n   my $parser = Bio::Tools::Glimmer->new(-file => $file);\n   # filehandle:\n   $parser = Bio::Tools::Glimmer->new( -fh  => \\*INPUT );\n   # provide a sequence identifier (Glimmer 2.X)\n   my $parser = Bio::Tools::Glimmer->new(-file => $file, -seqname => seqname);\n   # force format (override automatic detection)\n   my $parser = Bio::Tools::Glimmer->new(-file => $file, -format => 'GlimmerM');\n\n   # parse the results\n   # note: this class is-a Bio::Tools::AnalysisResult which implements\n   # Bio::SeqAnalysisParserI, i.e., $glimmer->next_feature() is the same\n\n   while(my $gene = $parser->next_prediction()) {\n       # For eukaryotic input (GlimmerM/GlimmerHMM), $gene will be an instance\n       # of Bio::Tools::Prediction::Gene, which inherits off\n       # Bio::SeqFeature::Gene::Transcript, and $gene->exons() will return an\n       # array of Bio::Tools::Prediction::Exon objects.\n       # For prokaryotic input (Glimmer2.X/Glimmer3.X), $gene will be an\n       # instance of Bio::SeqFeature::Generic\n\n       # all exons (eukaryotic only):\n       @exon_arr = $gene->exons();\n       # initial exons only\n       @init_exons = $gene->exons('Initial');\n       # internal exons only\n       @intrl_exons = $gene->exons('Internal');\n       # terminal exons only\n       @term_exons = $gene->exons('Terminal');\n   }\n\n=head1 DESCRIPTION\n\nThis is a module for parsing Glimmer, GlimmerM and GlimmerHMM predictions.  \nIt will create gene objects from the prediction report which can \nbe attached to a sequence using Bioperl objects, or output as GFF \nsuitable for loading into Bio::DB::GFF for use with Gbrowse.\n\nGlimmer is open source and available at\nL<http://www.cbcb.umd.edu/software/glimmer/>.\n\nGlimmerM is open source and available at \nL<http://www.tigr.org/software/glimmerm/>.\n\nGlimmerHMM is open source and available at\nL<http://www.cbcb.umd.edu/software/GlimmerHMM/>.\n\nNote that Glimmer 2.X will only process the first\nsequence in a fasta file, and the prediction report does not contain any\nsort of sequence identifier\n\nNote that Glimmer 3.X produces two output files.  This module only parses\nthe .predict file.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nemail or the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nTorsten Seemann\n\nMark Johnson\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Glimmer;\nuse strict;\n\nuse Bio::Factory::FTLocationFactory;\nuse Bio::Tools::Prediction::Gene;\nuse Bio::Tools::Prediction::Exon;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\nsub _initialize_state {\n    my($self,@args) = @_;\n\n    # first call the inherited method!\n    my $make = $self->SUPER::_initialize_state(@args);\n\n    $self->{'_preds_parsed'} = 0;\n    # array of pre-parsed predictions\n    $self->{'_preds'} = [];\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::Glimmer->new();\n Function: Builds a new Bio::Tools::Glimmer object \n Returns : an instance of Bio::Tools::Glimmer\n Args    : format ('Glimmer', 'GlimmerM', 'GlimmerHMM'), seqname\n\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  my ($format, $seqname, $seqlength, $detail) =\n      $self->_rearrange([qw(FORMAT SEQNAME SEQLENGTH DETAIL)], @args);\n\n  # override automagic format detection\n  if (defined($format) &&\n      (($format eq 'Glimmer')  ||\n       ($format eq 'GlimmerM') ||\n       ($format eq 'GlimmerHMM'))\n  ) {\n      $self->_format($format);\n  }\n  \n  if (defined($detail)) {\n      $self->_format('Glimmer');\n      $self->_detail_file($detail);\n  }\n  \n  # hardwire seq_id when creating gene and exon objects (Glimmer 2.X)\n  $self->_seqname($seqname) if defined($seqname);\n  \n  # store the length of the input sequence (Glimmer 2.X)\n  $self->_seqlength($seqlength) if defined($seqlength);\n  \n  return $self;\n}\n\n=head2 analysis_method\n\n Usage     : $glimmer->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /glimmer/i.\n Returns   : String\n Argument  : n/a\n\n\n#-------------\nsub analysis_method { \n#-------------\n    my ($self, $method) = @_;  \n    if($method && ($method !~ /glimmer/i)) {\n\t$self->throw(\"method $method not supported in \" . ref($self));\n    }\n    return $self->SUPER::analysis_method($method);\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : while($gene = $glimmer->next_feature()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the Glimmer result\n           file. Call this method repeatedly until FALSE is returned.\n\n           The returned object is actually a SeqFeatureI implementing object.\n           This method is required for classes implementing the\n           SeqAnalysisParserI interface, and is merely an alias for \n           next_prediction() at present.\n\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :\n\n\nsub next_feature {\n    my ($self,@args) = @_;\n    # even though next_prediction doesn't expect any args (and this method\n    # does neither), we pass on args in order to be prepared if this changes\n    # ever\n    return $self->next_prediction(@args);\n}\n\n=head2 next_prediction\n\n Title   : next_prediction\n Usage   : while($gene = $glimmer->next_prediction()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the Glimmer result\n           file. Call this method repeatedly until FALSE is returned.\n\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :\n\n\nsub next_prediction {\n    my ($self) = @_;\n    my $gene;\n\n    # if the prediction section hasn't been parsed yet, we do this now\n    $self->_parse_predictions() unless $self->_predictions_parsed();\n    \n    # get next gene structure\n    $gene = $self->_prediction();\n    return $gene;\n}\n\n=head2 _parse_predictions\n\n Title   : _parse_predictions()\n Usage   : $obj->_parse_predictions()\n Function: Parses the prediction section. Automatically called by\n           next_prediction() if not yet done.\n Example :\n Returns : \n\n\nsub _parse_predictions {\n\n    my ($self) = @_;\n\n    \n    my %method = (\n                  'Glimmer'    => '_parse_prokaryotic',\n                  'GlimmerM'   => '_parse_eukaryotic',\n                  'GlimmerHMM' => '_parse_eukaryotic',\n                  '_DEFAULT_'  => '_parse_eukaryotic',\n              );\n    \n    my $format = $self->_format();\n    \n    if (!$format) {\n        \n        while (my $line = $self->_readline()) {\n\n            if ( $line =~ /^Glimmer\\S*\\s+\\(Version\\s*\\S+\\)/ ) {\n                $format = 'GlimmerM';\n                $self->_pushback($line);\n                last;\n            }\n            elsif ( $line =~ /^Glimmer\\S*$/ ) {\n                $format = 'GlimmerHMM';\n                $self->_pushback($line);\n                last;\n            }\n            elsif ($line =~ /^Putative Genes:$/) {\n                $format = 'Glimmer';\n                $self->_pushback($line);\n                last;\n            }\n            elsif ($line =~ /^>(\\S+)/) {\n                $format = 'Glimmer';\n                $self->_pushback($line);\n                last;\n            }\n            \n        }\n        \n    }\n\n    my $method =\n        (exists($method{$format})) ? $method{$format} : $method{'_DEFAULT_'};\n\n    return $self->$method();\n    \n}\n\n\n=head2 _parse_eukaryotic\n\n Title   : _parse_eukaryotic()\n Usage   : $obj->_parse_eukaryotic()\n Function: Parses the prediction section. Automatically called by\n           next_prediction() if not yet done.\n Example :\n Returns : \n\n\nsub _parse_eukaryotic {\n    my ($self) = @_;\n\n    my ($gene,$seqname,$seqlen,$source,$lastgenenum);\n    \n    while(defined($_ = $self->_readline())) {\n\tif( /^(Glimmer\\S*)\\s+\\(Version\\s*(\\S+)\\)/ ) {\n\t    $source = \"$1_$2\";\n\t    next;\n\t} elsif( /^(GlimmerHMM\\S*)$/ ) { # GlimmerHMM has no version\n\t    $source = $1;\n\t    next;\n\t} elsif(/^Sequence name:\\s+(.+)$/ ) {\n\t    $seqname = $1;\n\t    next;\n\t} elsif( /^Sequence length:\\s+(\\S+)/ ) {\n\t    $seqlen = $1;\n\t    next;\n\t} elsif( m/^(Predicted genes)|(Gene)|\\s+\\#/ || /^\\s+$/ ) { \n\t    next;\n\t    \n\t} elsif( # GlimmerM/HMM gene-exon prediction line\n\t\t /^\\s+(\\d+)\\s+ # gene num\n\t\t (\\d+)\\s+      # exon num\n\t\t ([\\+\\-])\\s+   # strand\n\t\t (\\S+)\\s+      # exon type\n\t\t (\\d+)\\s+(\\d+) # exon start, end\n\t\t \\s+(\\d+)      # exon length\t\t \n\t\t /ox ) {\n\t    my ($genenum,$exonnum,$strand,$type,$start,$end,$len) = \n\t\t( $1,$2,$3,$4,$5,$6,$7);\n\t    if( ! $lastgenenum || $lastgenenum != $genenum) {\t\t\n\t\t$self->_add_prediction($gene) if ( $gene );\n\t\t$gene = Bio::Tools::Prediction::Gene->new\n\t\t    (\n\t\t     '-seq_id'      => $seqname,\n\t\t     '-primary_tag' => \"gene\",\n\t\t     '-source_tag'  => $source,\n\t\t     '-tag'         => { 'Group' => \"GenePrediction$genenum\"},\n\t\t     );\n\t    }\n\t    my $exon = Bio::Tools::Prediction::Exon->new\n\t\t('-seq_id'     => $seqname,\n\t\t '-start'      => $start,\n\t\t '-end'        => $end,\n\t\t '-strand'     => $strand eq '-' ? '-1' : '1',\n\t\t '-source_tag' => $source,\n\t\t '-primary_tag'=> 'exon',\n\t\t '-tag'         => { 'Group' => \"GenePrediction$genenum\"},\n\t\t );\n\t    $gene->add_exon($exon,lc($type));\n\t    $lastgenenum = $genenum;\n\t}\n    }\n    $self->_add_prediction($gene) if( $gene );\n    $self->_predictions_parsed(1);\n}\n\n=head2 _parse_prokaryotic\n\n Title   : _parse_prokaryotic()\n Usage   : $obj->_parse_prokaryotic()\n Function: Parses the prediction section. Automatically called by\n           next_prediction() if not yet done.\n Example :\n Returns : \n\n\nsub _parse_prokaryotic {\n    my ($self) = @_;\n\n    # default value, possibly overriden later\n    my $source = 'Glimmer';\n\n    # Store the sequence length(s) here, either from the\n    # seqlength arg to the constructor, or from the\n    # Glimmer 3.X detail file\n    my %seqlength = ( );\n    \n    # Glimmer 2.X does not provide a sequence identifer\n    # in the prediction report (will default to unknown\n    # if not specified in the seqname arg to the\n    # constructor\n    #\n    # Glimmer 2.X does not report the length of the\n    # input sequence, either (will default to undef\n    # if not specified in the seqlength arg to the\n    # constructor\n    my $seqname = $self->_seqname();\n    my $seqlength = $self->_seqlength();\n\n    if (defined($seqlength)) {\n        $seqlength{$seqname} = $seqlength\n    }\n\n    # Parse the detail file, if we have one (Glimmer 3.X)\n    my $detail_file = $self->_detail_file();\n    \n    if (defined($detail_file)) {\n\n        my $io = Bio::Root::IO->new(-file => $detail_file);\n        my $seqname;\n        \n        while (defined($_ = $io->_readline())) {\n            if ($_ =~ /^>(\\S+)/) {\n                $seqname = $1;\n                next;\n            }\n\n            if (defined($seqname) && ($_ =~ /^Sequence length = (\\d+)$/)) {\n                $seqlength{$seqname} = $1;\n                next;\n            }\n        }\n    }\n    \n    my $location_factory = Bio::Factory::FTLocationFactory->new();\n    \n    while(defined($_ = $self->_readline())) {\n        # Glimmer 3.X does provide a sequence identifier -\n        # beware whitespace at the end (comes through from\n        # the fasta file)\n        if ($_ =~ /^Putative Genes:$/) {\n            $source = 'Glimmer_2.X';\n            next;\n        }\n        # Glimmer 3.X sequence identifier\n        elsif ($_ =~ /^>(\\S+)/) {\n            $seqname = $1;\n            $seqlength = $seqlength{$seqname};\n            $source = 'Glimmer_3.X';\n            next;\n        }        \n        elsif (\n               # Glimmer 2.X prediction \n               (/^\\s+(\\d+)\\s+      # gene num\n                (\\d+)\\s+(\\d+)\\s+   # start, end\n                \\[([\\+\\-])(\\d{1})\\s+ # strand, frame\n                /ox ) ||\n               # Glimmer 3.X prediction\n               (/^[^\\d]+(\\d+)\\s+    # orf (numeric portion)\n                (\\d+)\\s+(\\d+)\\s+   # start, end\n                ([\\+\\-])(\\d{1})\\s+   # strand, frame\n                ([\\d\\.]+)          # score\n                /ox)) {\n\t    my ($genenum,$start,$end,$strand,$frame,$score) = \n\t\t( $1,$2,$3,$4,$5,$6 );\n\n            my $circular_prediction = 0;\n\n            # Check for a circular prediction before we\n            # start fiddling with the coordinates\n            if ($strand eq '+') {\n                if ($start > $end) {\n                    $circular_prediction = 1;\n                }\n            }\n            else {\n                if ($start < $end) {\n                    $circular_prediction = 1;\n                }\n            }\n\n            if ($circular_prediction) {\n                unless (defined($seqlength)) {\n                    $self->throw(\"need to know the sequence length to handle wraparound genes\");\n                }\n            }\n            \n            # Glimmer 2.X predictions do not include\n            # the stop codon - this might extend the\n            # prediction off either end of the sequence.\n            # This works fine even on circular/wraparound\n            # predictions.  \n            if ($source eq 'Glimmer_2.X') {\n                if ($strand eq '+') { \n                    $end += 3;\n                }\n                else {\n                    $end -= 3;\n                }\n            }\n\n            # We might have extended a Glimmer 2.X prediction\n            # beyond the boundaries of the input sequence.\n            # Also, Glimmer 3.X (with -X) will output predictions\n            # with coordinates less than 1 or greater than the\n            # length of the sequence.\n            my ($fst, $fend);\n            foreach my $coord ($start, $end) {\n                if ($coord < 1) {\n                    $coord = '<1';\n                    $fst++;\n                } elsif (defined($seqlength) && ($coord > $seqlength)) {\n                    $coord = \">$seqlength\";\n                    $fend++;\n                }\n            }\n            \n            my $location_string;\n\n            if ($circular_prediction) {\n                if ($strand eq '+') {\n                    $location_string = \"join($start..$seqlength,1..$end)\";\n                }\n                else {\n                    $location_string = \"join($start..1,$seqlength..$end)\";\n                }\n                }\n            else {\n                # start must always be less than end for gene locations\n                if ($strand eq '-' && !$fst && !$fend && $start > $end) {\n                    ($start, $end) = ($end, $start);\n                }\n                $location_string = \"$start..$end\";\n            }\n            \n            my $location_object =\n                $location_factory->from_string($location_string);\n            \n            # convert glimmer's frame range from 1-3 to SeqFeature's 0-2.\n            $frame--;\n            \n            my $gene = Bio::SeqFeature::Generic->new\n                (\n                 '-seq_id'      => $seqname,\n                 '-location'   => $location_object,\n                 '-strand'     => $strand eq '-' ? '-1' : '1',\n                 '-frame'\t\t=> $frame,\n                 '-source_tag'  => $source,\n                 '-display_name' => \"orf$genenum\",\n                 '-primary_tag'=> 'gene',\n                 '-tag'         => { 'Group' => \"GenePrediction_$genenum\"},\n                 '-score'       => $score || undef\n             );\n            \n            $self->_add_prediction($gene) \n\t}\n    }\n    \n    $self->_predictions_parsed(1);\n}\n\n=head2 _prediction\n\n Title   : _prediction()\n Usage   : $gene = $obj->_prediction()\n Function: internal\n Example :\n Returns : \n\n\nsub _prediction {\n    my ($self) = @_;\n\n    return unless(exists($self->{'_preds'}) && @{$self->{'_preds'}});\n    return shift(@{$self->{'_preds'}});\n}\n\n=head2 _add_prediction\n\n Title   : _add_prediction()\n Usage   : $obj->_add_prediction($gene)\n Function: internal\n Example :\n Returns : \n\n\nsub _add_prediction {\n    my ($self, $gene) = @_;\n\n    if(! exists($self->{'_preds'})) {\n\t$self->{'_preds'} = [];\n    }\n    push(@{$self->{'_preds'}}, $gene);\n}\n\n=head2 _predictions_parsed\n\n Title   : _predictions_parsed\n Usage   : $obj->_predictions_parsed\n Function: internal\n Example :\n Returns : TRUE or FALSE\n\n\nsub _predictions_parsed {\n    my ($self, $val) = @_;\n\n    $self->{'_preds_parsed'} = $val if $val;\n    if(! exists($self->{'_preds_parsed'})) {\n\t$self->{'_preds_parsed'} = 0;\n    }\n    return $self->{'_preds_parsed'};\n}\n\n=head2 _seqname\n\n Title   : _seqname\n Usage   : $obj->_seqname($seqname)\n Function: internal (for Glimmer 2.X)\n Example :\n Returns : String"},"containerName":"main::","definition":"sub","line":649,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"_seqname","line":650,"kind":13},{"containerName":"_seqname","name":"$val","line":650,"kind":13},{"kind":13,"line":652,"name":"$self","containerName":"_seqname"},{"kind":13,"line":652,"name":"$val","containerName":"_seqname"},{"name":"$val","containerName":"_seqname","line":652,"kind":13},{"name":"$self","containerName":"_seqname","kind":13,"line":653},{"line":654,"kind":13,"containerName":"_seqname","name":"$self"},{"line":656,"kind":13,"name":"$self","containerName":"_seqname"}],"kind":12,"range":{"end":{"character":9999,"line":657},"start":{"line":649,"character":0}},"name":"_seqname"},{"range":{"end":{"character":9999,"line":674},"start":{"line":669,"character":0}},"name":"_seqlength","children":[{"kind":13,"line":670,"name":"$self","definition":"my","containerName":"_seqlength","localvar":"my"},{"name":"$val","containerName":"_seqlength","line":670,"kind":13},{"kind":13,"line":672,"name":"$self","containerName":"_seqlength"},{"containerName":"_seqlength","name":"$val","kind":13,"line":672},{"containerName":"_seqlength","name":"$val","line":672,"kind":13},{"kind":13,"line":673,"containerName":"_seqlength","name":"$self"}],"line":669,"kind":12,"signature":{"label":"_seqlength($self,$val)","parameters":[{"label":"$self"},{"label":"$val"}],"documentation":"1;\n# $Id: Glimmer.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Glimmer\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Glimmer - parser for Glimmer 2.X/3.X prokaryotic and \nGlimmerM/GlimmerHMM eukaryotic gene predictions\n\n=head1 SYNOPSIS\n\n   use Bio::Tools::Glimmer;\n\n   # file\n   my $parser = Bio::Tools::Glimmer->new(-file => $file);\n   # filehandle:\n   $parser = Bio::Tools::Glimmer->new( -fh  => \\*INPUT );\n   # provide a sequence identifier (Glimmer 2.X)\n   my $parser = Bio::Tools::Glimmer->new(-file => $file, -seqname => seqname);\n   # force format (override automatic detection)\n   my $parser = Bio::Tools::Glimmer->new(-file => $file, -format => 'GlimmerM');\n\n   # parse the results\n   # note: this class is-a Bio::Tools::AnalysisResult which implements\n   # Bio::SeqAnalysisParserI, i.e., $glimmer->next_feature() is the same\n\n   while(my $gene = $parser->next_prediction()) {\n       # For eukaryotic input (GlimmerM/GlimmerHMM), $gene will be an instance\n       # of Bio::Tools::Prediction::Gene, which inherits off\n       # Bio::SeqFeature::Gene::Transcript, and $gene->exons() will return an\n       # array of Bio::Tools::Prediction::Exon objects.\n       # For prokaryotic input (Glimmer2.X/Glimmer3.X), $gene will be an\n       # instance of Bio::SeqFeature::Generic\n\n       # all exons (eukaryotic only):\n       @exon_arr = $gene->exons();\n       # initial exons only\n       @init_exons = $gene->exons('Initial');\n       # internal exons only\n       @intrl_exons = $gene->exons('Internal');\n       # terminal exons only\n       @term_exons = $gene->exons('Terminal');\n   }\n\n=head1 DESCRIPTION\n\nThis is a module for parsing Glimmer, GlimmerM and GlimmerHMM predictions.  \nIt will create gene objects from the prediction report which can \nbe attached to a sequence using Bioperl objects, or output as GFF \nsuitable for loading into Bio::DB::GFF for use with Gbrowse.\n\nGlimmer is open source and available at\nL<http://www.cbcb.umd.edu/software/glimmer/>.\n\nGlimmerM is open source and available at \nL<http://www.tigr.org/software/glimmerm/>.\n\nGlimmerHMM is open source and available at\nL<http://www.cbcb.umd.edu/software/GlimmerHMM/>.\n\nNote that Glimmer 2.X will only process the first\nsequence in a fasta file, and the prediction report does not contain any\nsort of sequence identifier\n\nNote that Glimmer 3.X produces two output files.  This module only parses\nthe .predict file.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nemail or the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nTorsten Seemann\n\nMark Johnson\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Glimmer;\nuse strict;\n\nuse Bio::Factory::FTLocationFactory;\nuse Bio::Tools::Prediction::Gene;\nuse Bio::Tools::Prediction::Exon;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\nsub _initialize_state {\n    my($self,@args) = @_;\n\n    # first call the inherited method!\n    my $make = $self->SUPER::_initialize_state(@args);\n\n    $self->{'_preds_parsed'} = 0;\n    # array of pre-parsed predictions\n    $self->{'_preds'} = [];\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::Glimmer->new();\n Function: Builds a new Bio::Tools::Glimmer object \n Returns : an instance of Bio::Tools::Glimmer\n Args    : format ('Glimmer', 'GlimmerM', 'GlimmerHMM'), seqname\n\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  my ($format, $seqname, $seqlength, $detail) =\n      $self->_rearrange([qw(FORMAT SEQNAME SEQLENGTH DETAIL)], @args);\n\n  # override automagic format detection\n  if (defined($format) &&\n      (($format eq 'Glimmer')  ||\n       ($format eq 'GlimmerM') ||\n       ($format eq 'GlimmerHMM'))\n  ) {\n      $self->_format($format);\n  }\n  \n  if (defined($detail)) {\n      $self->_format('Glimmer');\n      $self->_detail_file($detail);\n  }\n  \n  # hardwire seq_id when creating gene and exon objects (Glimmer 2.X)\n  $self->_seqname($seqname) if defined($seqname);\n  \n  # store the length of the input sequence (Glimmer 2.X)\n  $self->_seqlength($seqlength) if defined($seqlength);\n  \n  return $self;\n}\n\n=head2 analysis_method\n\n Usage     : $glimmer->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /glimmer/i.\n Returns   : String\n Argument  : n/a\n\n\n#-------------\nsub analysis_method { \n#-------------\n    my ($self, $method) = @_;  \n    if($method && ($method !~ /glimmer/i)) {\n\t$self->throw(\"method $method not supported in \" . ref($self));\n    }\n    return $self->SUPER::analysis_method($method);\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : while($gene = $glimmer->next_feature()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the Glimmer result\n           file. Call this method repeatedly until FALSE is returned.\n\n           The returned object is actually a SeqFeatureI implementing object.\n           This method is required for classes implementing the\n           SeqAnalysisParserI interface, and is merely an alias for \n           next_prediction() at present.\n\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :\n\n\nsub next_feature {\n    my ($self,@args) = @_;\n    # even though next_prediction doesn't expect any args (and this method\n    # does neither), we pass on args in order to be prepared if this changes\n    # ever\n    return $self->next_prediction(@args);\n}\n\n=head2 next_prediction\n\n Title   : next_prediction\n Usage   : while($gene = $glimmer->next_prediction()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the Glimmer result\n           file. Call this method repeatedly until FALSE is returned.\n\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :\n\n\nsub next_prediction {\n    my ($self) = @_;\n    my $gene;\n\n    # if the prediction section hasn't been parsed yet, we do this now\n    $self->_parse_predictions() unless $self->_predictions_parsed();\n    \n    # get next gene structure\n    $gene = $self->_prediction();\n    return $gene;\n}\n\n=head2 _parse_predictions\n\n Title   : _parse_predictions()\n Usage   : $obj->_parse_predictions()\n Function: Parses the prediction section. Automatically called by\n           next_prediction() if not yet done.\n Example :\n Returns : \n\n\nsub _parse_predictions {\n\n    my ($self) = @_;\n\n    \n    my %method = (\n                  'Glimmer'    => '_parse_prokaryotic',\n                  'GlimmerM'   => '_parse_eukaryotic',\n                  'GlimmerHMM' => '_parse_eukaryotic',\n                  '_DEFAULT_'  => '_parse_eukaryotic',\n              );\n    \n    my $format = $self->_format();\n    \n    if (!$format) {\n        \n        while (my $line = $self->_readline()) {\n\n            if ( $line =~ /^Glimmer\\S*\\s+\\(Version\\s*\\S+\\)/ ) {\n                $format = 'GlimmerM';\n                $self->_pushback($line);\n                last;\n            }\n            elsif ( $line =~ /^Glimmer\\S*$/ ) {\n                $format = 'GlimmerHMM';\n                $self->_pushback($line);\n                last;\n            }\n            elsif ($line =~ /^Putative Genes:$/) {\n                $format = 'Glimmer';\n                $self->_pushback($line);\n                last;\n            }\n            elsif ($line =~ /^>(\\S+)/) {\n                $format = 'Glimmer';\n                $self->_pushback($line);\n                last;\n            }\n            \n        }\n        \n    }\n\n    my $method =\n        (exists($method{$format})) ? $method{$format} : $method{'_DEFAULT_'};\n\n    return $self->$method();\n    \n}\n\n\n=head2 _parse_eukaryotic\n\n Title   : _parse_eukaryotic()\n Usage   : $obj->_parse_eukaryotic()\n Function: Parses the prediction section. Automatically called by\n           next_prediction() if not yet done.\n Example :\n Returns : \n\n\nsub _parse_eukaryotic {\n    my ($self) = @_;\n\n    my ($gene,$seqname,$seqlen,$source,$lastgenenum);\n    \n    while(defined($_ = $self->_readline())) {\n\tif( /^(Glimmer\\S*)\\s+\\(Version\\s*(\\S+)\\)/ ) {\n\t    $source = \"$1_$2\";\n\t    next;\n\t} elsif( /^(GlimmerHMM\\S*)$/ ) { # GlimmerHMM has no version\n\t    $source = $1;\n\t    next;\n\t} elsif(/^Sequence name:\\s+(.+)$/ ) {\n\t    $seqname = $1;\n\t    next;\n\t} elsif( /^Sequence length:\\s+(\\S+)/ ) {\n\t    $seqlen = $1;\n\t    next;\n\t} elsif( m/^(Predicted genes)|(Gene)|\\s+\\#/ || /^\\s+$/ ) { \n\t    next;\n\t    \n\t} elsif( # GlimmerM/HMM gene-exon prediction line\n\t\t /^\\s+(\\d+)\\s+ # gene num\n\t\t (\\d+)\\s+      # exon num\n\t\t ([\\+\\-])\\s+   # strand\n\t\t (\\S+)\\s+      # exon type\n\t\t (\\d+)\\s+(\\d+) # exon start, end\n\t\t \\s+(\\d+)      # exon length\t\t \n\t\t /ox ) {\n\t    my ($genenum,$exonnum,$strand,$type,$start,$end,$len) = \n\t\t( $1,$2,$3,$4,$5,$6,$7);\n\t    if( ! $lastgenenum || $lastgenenum != $genenum) {\t\t\n\t\t$self->_add_prediction($gene) if ( $gene );\n\t\t$gene = Bio::Tools::Prediction::Gene->new\n\t\t    (\n\t\t     '-seq_id'      => $seqname,\n\t\t     '-primary_tag' => \"gene\",\n\t\t     '-source_tag'  => $source,\n\t\t     '-tag'         => { 'Group' => \"GenePrediction$genenum\"},\n\t\t     );\n\t    }\n\t    my $exon = Bio::Tools::Prediction::Exon->new\n\t\t('-seq_id'     => $seqname,\n\t\t '-start'      => $start,\n\t\t '-end'        => $end,\n\t\t '-strand'     => $strand eq '-' ? '-1' : '1',\n\t\t '-source_tag' => $source,\n\t\t '-primary_tag'=> 'exon',\n\t\t '-tag'         => { 'Group' => \"GenePrediction$genenum\"},\n\t\t );\n\t    $gene->add_exon($exon,lc($type));\n\t    $lastgenenum = $genenum;\n\t}\n    }\n    $self->_add_prediction($gene) if( $gene );\n    $self->_predictions_parsed(1);\n}\n\n=head2 _parse_prokaryotic\n\n Title   : _parse_prokaryotic()\n Usage   : $obj->_parse_prokaryotic()\n Function: Parses the prediction section. Automatically called by\n           next_prediction() if not yet done.\n Example :\n Returns : \n\n\nsub _parse_prokaryotic {\n    my ($self) = @_;\n\n    # default value, possibly overriden later\n    my $source = 'Glimmer';\n\n    # Store the sequence length(s) here, either from the\n    # seqlength arg to the constructor, or from the\n    # Glimmer 3.X detail file\n    my %seqlength = ( );\n    \n    # Glimmer 2.X does not provide a sequence identifer\n    # in the prediction report (will default to unknown\n    # if not specified in the seqname arg to the\n    # constructor\n    #\n    # Glimmer 2.X does not report the length of the\n    # input sequence, either (will default to undef\n    # if not specified in the seqlength arg to the\n    # constructor\n    my $seqname = $self->_seqname();\n    my $seqlength = $self->_seqlength();\n\n    if (defined($seqlength)) {\n        $seqlength{$seqname} = $seqlength\n    }\n\n    # Parse the detail file, if we have one (Glimmer 3.X)\n    my $detail_file = $self->_detail_file();\n    \n    if (defined($detail_file)) {\n\n        my $io = Bio::Root::IO->new(-file => $detail_file);\n        my $seqname;\n        \n        while (defined($_ = $io->_readline())) {\n            if ($_ =~ /^>(\\S+)/) {\n                $seqname = $1;\n                next;\n            }\n\n            if (defined($seqname) && ($_ =~ /^Sequence length = (\\d+)$/)) {\n                $seqlength{$seqname} = $1;\n                next;\n            }\n        }\n    }\n    \n    my $location_factory = Bio::Factory::FTLocationFactory->new();\n    \n    while(defined($_ = $self->_readline())) {\n        # Glimmer 3.X does provide a sequence identifier -\n        # beware whitespace at the end (comes through from\n        # the fasta file)\n        if ($_ =~ /^Putative Genes:$/) {\n            $source = 'Glimmer_2.X';\n            next;\n        }\n        # Glimmer 3.X sequence identifier\n        elsif ($_ =~ /^>(\\S+)/) {\n            $seqname = $1;\n            $seqlength = $seqlength{$seqname};\n            $source = 'Glimmer_3.X';\n            next;\n        }        \n        elsif (\n               # Glimmer 2.X prediction \n               (/^\\s+(\\d+)\\s+      # gene num\n                (\\d+)\\s+(\\d+)\\s+   # start, end\n                \\[([\\+\\-])(\\d{1})\\s+ # strand, frame\n                /ox ) ||\n               # Glimmer 3.X prediction\n               (/^[^\\d]+(\\d+)\\s+    # orf (numeric portion)\n                (\\d+)\\s+(\\d+)\\s+   # start, end\n                ([\\+\\-])(\\d{1})\\s+   # strand, frame\n                ([\\d\\.]+)          # score\n                /ox)) {\n\t    my ($genenum,$start,$end,$strand,$frame,$score) = \n\t\t( $1,$2,$3,$4,$5,$6 );\n\n            my $circular_prediction = 0;\n\n            # Check for a circular prediction before we\n            # start fiddling with the coordinates\n            if ($strand eq '+') {\n                if ($start > $end) {\n                    $circular_prediction = 1;\n                }\n            }\n            else {\n                if ($start < $end) {\n                    $circular_prediction = 1;\n                }\n            }\n\n            if ($circular_prediction) {\n                unless (defined($seqlength)) {\n                    $self->throw(\"need to know the sequence length to handle wraparound genes\");\n                }\n            }\n            \n            # Glimmer 2.X predictions do not include\n            # the stop codon - this might extend the\n            # prediction off either end of the sequence.\n            # This works fine even on circular/wraparound\n            # predictions.  \n            if ($source eq 'Glimmer_2.X') {\n                if ($strand eq '+') { \n                    $end += 3;\n                }\n                else {\n                    $end -= 3;\n                }\n            }\n\n            # We might have extended a Glimmer 2.X prediction\n            # beyond the boundaries of the input sequence.\n            # Also, Glimmer 3.X (with -X) will output predictions\n            # with coordinates less than 1 or greater than the\n            # length of the sequence.\n            my ($fst, $fend);\n            foreach my $coord ($start, $end) {\n                if ($coord < 1) {\n                    $coord = '<1';\n                    $fst++;\n                } elsif (defined($seqlength) && ($coord > $seqlength)) {\n                    $coord = \">$seqlength\";\n                    $fend++;\n                }\n            }\n            \n            my $location_string;\n\n            if ($circular_prediction) {\n                if ($strand eq '+') {\n                    $location_string = \"join($start..$seqlength,1..$end)\";\n                }\n                else {\n                    $location_string = \"join($start..1,$seqlength..$end)\";\n                }\n                }\n            else {\n                # start must always be less than end for gene locations\n                if ($strand eq '-' && !$fst && !$fend && $start > $end) {\n                    ($start, $end) = ($end, $start);\n                }\n                $location_string = \"$start..$end\";\n            }\n            \n            my $location_object =\n                $location_factory->from_string($location_string);\n            \n            # convert glimmer's frame range from 1-3 to SeqFeature's 0-2.\n            $frame--;\n            \n            my $gene = Bio::SeqFeature::Generic->new\n                (\n                 '-seq_id'      => $seqname,\n                 '-location'   => $location_object,\n                 '-strand'     => $strand eq '-' ? '-1' : '1',\n                 '-frame'\t\t=> $frame,\n                 '-source_tag'  => $source,\n                 '-display_name' => \"orf$genenum\",\n                 '-primary_tag'=> 'gene',\n                 '-tag'         => { 'Group' => \"GenePrediction_$genenum\"},\n                 '-score'       => $score || undef\n             );\n            \n            $self->_add_prediction($gene) \n\t}\n    }\n    \n    $self->_predictions_parsed(1);\n}\n\n=head2 _prediction\n\n Title   : _prediction()\n Usage   : $gene = $obj->_prediction()\n Function: internal\n Example :\n Returns : \n\n\nsub _prediction {\n    my ($self) = @_;\n\n    return unless(exists($self->{'_preds'}) && @{$self->{'_preds'}});\n    return shift(@{$self->{'_preds'}});\n}\n\n=head2 _add_prediction\n\n Title   : _add_prediction()\n Usage   : $obj->_add_prediction($gene)\n Function: internal\n Example :\n Returns : \n\n\nsub _add_prediction {\n    my ($self, $gene) = @_;\n\n    if(! exists($self->{'_preds'})) {\n\t$self->{'_preds'} = [];\n    }\n    push(@{$self->{'_preds'}}, $gene);\n}\n\n=head2 _predictions_parsed\n\n Title   : _predictions_parsed\n Usage   : $obj->_predictions_parsed\n Function: internal\n Example :\n Returns : TRUE or FALSE\n\n\nsub _predictions_parsed {\n    my ($self, $val) = @_;\n\n    $self->{'_preds_parsed'} = $val if $val;\n    if(! exists($self->{'_preds_parsed'})) {\n\t$self->{'_preds_parsed'} = 0;\n    }\n    return $self->{'_preds_parsed'};\n}\n\n=head2 _seqname\n\n Title   : _seqname\n Usage   : $obj->_seqname($seqname)\n Function: internal (for Glimmer 2.X)\n Example :\n Returns : String\n\n\nsub _seqname {\n    my ($self, $val) = @_;\n\n    $self->{'_seqname'} = $val if $val;\n    if(! exists($self->{'_seqname'})) {\n\t$self->{'_seqname'} = 'unknown';\n    }\n    return $self->{'_seqname'};\n}\n\n=head2 _seqlength\n\n Title   : _seqlength\n Usage   : $obj->_seqlength($seqlength)\n Function: internal (for Glimmer 2.X)\n Example :\n Returns : String"},"detail":"($self,$val)","definition":"sub","containerName":"main::"},{"range":{"start":{"line":686,"character":0},"end":{"character":9999,"line":692}},"name":"_format","detail":"($self,$val)","signature":{"parameters":[{"label":"$self"},{"label":"$val"}],"documentation":"1;\n# $Id: Glimmer.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Glimmer\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Glimmer - parser for Glimmer 2.X/3.X prokaryotic and \nGlimmerM/GlimmerHMM eukaryotic gene predictions\n\n=head1 SYNOPSIS\n\n   use Bio::Tools::Glimmer;\n\n   # file\n   my $parser = Bio::Tools::Glimmer->new(-file => $file);\n   # filehandle:\n   $parser = Bio::Tools::Glimmer->new( -fh  => \\*INPUT );\n   # provide a sequence identifier (Glimmer 2.X)\n   my $parser = Bio::Tools::Glimmer->new(-file => $file, -seqname => seqname);\n   # force format (override automatic detection)\n   my $parser = Bio::Tools::Glimmer->new(-file => $file, -format => 'GlimmerM');\n\n   # parse the results\n   # note: this class is-a Bio::Tools::AnalysisResult which implements\n   # Bio::SeqAnalysisParserI, i.e., $glimmer->next_feature() is the same\n\n   while(my $gene = $parser->next_prediction()) {\n       # For eukaryotic input (GlimmerM/GlimmerHMM), $gene will be an instance\n       # of Bio::Tools::Prediction::Gene, which inherits off\n       # Bio::SeqFeature::Gene::Transcript, and $gene->exons() will return an\n       # array of Bio::Tools::Prediction::Exon objects.\n       # For prokaryotic input (Glimmer2.X/Glimmer3.X), $gene will be an\n       # instance of Bio::SeqFeature::Generic\n\n       # all exons (eukaryotic only):\n       @exon_arr = $gene->exons();\n       # initial exons only\n       @init_exons = $gene->exons('Initial');\n       # internal exons only\n       @intrl_exons = $gene->exons('Internal');\n       # terminal exons only\n       @term_exons = $gene->exons('Terminal');\n   }\n\n=head1 DESCRIPTION\n\nThis is a module for parsing Glimmer, GlimmerM and GlimmerHMM predictions.  \nIt will create gene objects from the prediction report which can \nbe attached to a sequence using Bioperl objects, or output as GFF \nsuitable for loading into Bio::DB::GFF for use with Gbrowse.\n\nGlimmer is open source and available at\nL<http://www.cbcb.umd.edu/software/glimmer/>.\n\nGlimmerM is open source and available at \nL<http://www.tigr.org/software/glimmerm/>.\n\nGlimmerHMM is open source and available at\nL<http://www.cbcb.umd.edu/software/GlimmerHMM/>.\n\nNote that Glimmer 2.X will only process the first\nsequence in a fasta file, and the prediction report does not contain any\nsort of sequence identifier\n\nNote that Glimmer 3.X produces two output files.  This module only parses\nthe .predict file.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nemail or the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nTorsten Seemann\n\nMark Johnson\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Glimmer;\nuse strict;\n\nuse Bio::Factory::FTLocationFactory;\nuse Bio::Tools::Prediction::Gene;\nuse Bio::Tools::Prediction::Exon;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\nsub _initialize_state {\n    my($self,@args) = @_;\n\n    # first call the inherited method!\n    my $make = $self->SUPER::_initialize_state(@args);\n\n    $self->{'_preds_parsed'} = 0;\n    # array of pre-parsed predictions\n    $self->{'_preds'} = [];\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::Glimmer->new();\n Function: Builds a new Bio::Tools::Glimmer object \n Returns : an instance of Bio::Tools::Glimmer\n Args    : format ('Glimmer', 'GlimmerM', 'GlimmerHMM'), seqname\n\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  my ($format, $seqname, $seqlength, $detail) =\n      $self->_rearrange([qw(FORMAT SEQNAME SEQLENGTH DETAIL)], @args);\n\n  # override automagic format detection\n  if (defined($format) &&\n      (($format eq 'Glimmer')  ||\n       ($format eq 'GlimmerM') ||\n       ($format eq 'GlimmerHMM'))\n  ) {\n      $self->_format($format);\n  }\n  \n  if (defined($detail)) {\n      $self->_format('Glimmer');\n      $self->_detail_file($detail);\n  }\n  \n  # hardwire seq_id when creating gene and exon objects (Glimmer 2.X)\n  $self->_seqname($seqname) if defined($seqname);\n  \n  # store the length of the input sequence (Glimmer 2.X)\n  $self->_seqlength($seqlength) if defined($seqlength);\n  \n  return $self;\n}\n\n=head2 analysis_method\n\n Usage     : $glimmer->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /glimmer/i.\n Returns   : String\n Argument  : n/a\n\n\n#-------------\nsub analysis_method { \n#-------------\n    my ($self, $method) = @_;  \n    if($method && ($method !~ /glimmer/i)) {\n\t$self->throw(\"method $method not supported in \" . ref($self));\n    }\n    return $self->SUPER::analysis_method($method);\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : while($gene = $glimmer->next_feature()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the Glimmer result\n           file. Call this method repeatedly until FALSE is returned.\n\n           The returned object is actually a SeqFeatureI implementing object.\n           This method is required for classes implementing the\n           SeqAnalysisParserI interface, and is merely an alias for \n           next_prediction() at present.\n\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :\n\n\nsub next_feature {\n    my ($self,@args) = @_;\n    # even though next_prediction doesn't expect any args (and this method\n    # does neither), we pass on args in order to be prepared if this changes\n    # ever\n    return $self->next_prediction(@args);\n}\n\n=head2 next_prediction\n\n Title   : next_prediction\n Usage   : while($gene = $glimmer->next_prediction()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the Glimmer result\n           file. Call this method repeatedly until FALSE is returned.\n\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :\n\n\nsub next_prediction {\n    my ($self) = @_;\n    my $gene;\n\n    # if the prediction section hasn't been parsed yet, we do this now\n    $self->_parse_predictions() unless $self->_predictions_parsed();\n    \n    # get next gene structure\n    $gene = $self->_prediction();\n    return $gene;\n}\n\n=head2 _parse_predictions\n\n Title   : _parse_predictions()\n Usage   : $obj->_parse_predictions()\n Function: Parses the prediction section. Automatically called by\n           next_prediction() if not yet done.\n Example :\n Returns : \n\n\nsub _parse_predictions {\n\n    my ($self) = @_;\n\n    \n    my %method = (\n                  'Glimmer'    => '_parse_prokaryotic',\n                  'GlimmerM'   => '_parse_eukaryotic',\n                  'GlimmerHMM' => '_parse_eukaryotic',\n                  '_DEFAULT_'  => '_parse_eukaryotic',\n              );\n    \n    my $format = $self->_format();\n    \n    if (!$format) {\n        \n        while (my $line = $self->_readline()) {\n\n            if ( $line =~ /^Glimmer\\S*\\s+\\(Version\\s*\\S+\\)/ ) {\n                $format = 'GlimmerM';\n                $self->_pushback($line);\n                last;\n            }\n            elsif ( $line =~ /^Glimmer\\S*$/ ) {\n                $format = 'GlimmerHMM';\n                $self->_pushback($line);\n                last;\n            }\n            elsif ($line =~ /^Putative Genes:$/) {\n                $format = 'Glimmer';\n                $self->_pushback($line);\n                last;\n            }\n            elsif ($line =~ /^>(\\S+)/) {\n                $format = 'Glimmer';\n                $self->_pushback($line);\n                last;\n            }\n            \n        }\n        \n    }\n\n    my $method =\n        (exists($method{$format})) ? $method{$format} : $method{'_DEFAULT_'};\n\n    return $self->$method();\n    \n}\n\n\n=head2 _parse_eukaryotic\n\n Title   : _parse_eukaryotic()\n Usage   : $obj->_parse_eukaryotic()\n Function: Parses the prediction section. Automatically called by\n           next_prediction() if not yet done.\n Example :\n Returns : \n\n\nsub _parse_eukaryotic {\n    my ($self) = @_;\n\n    my ($gene,$seqname,$seqlen,$source,$lastgenenum);\n    \n    while(defined($_ = $self->_readline())) {\n\tif( /^(Glimmer\\S*)\\s+\\(Version\\s*(\\S+)\\)/ ) {\n\t    $source = \"$1_$2\";\n\t    next;\n\t} elsif( /^(GlimmerHMM\\S*)$/ ) { # GlimmerHMM has no version\n\t    $source = $1;\n\t    next;\n\t} elsif(/^Sequence name:\\s+(.+)$/ ) {\n\t    $seqname = $1;\n\t    next;\n\t} elsif( /^Sequence length:\\s+(\\S+)/ ) {\n\t    $seqlen = $1;\n\t    next;\n\t} elsif( m/^(Predicted genes)|(Gene)|\\s+\\#/ || /^\\s+$/ ) { \n\t    next;\n\t    \n\t} elsif( # GlimmerM/HMM gene-exon prediction line\n\t\t /^\\s+(\\d+)\\s+ # gene num\n\t\t (\\d+)\\s+      # exon num\n\t\t ([\\+\\-])\\s+   # strand\n\t\t (\\S+)\\s+      # exon type\n\t\t (\\d+)\\s+(\\d+) # exon start, end\n\t\t \\s+(\\d+)      # exon length\t\t \n\t\t /ox ) {\n\t    my ($genenum,$exonnum,$strand,$type,$start,$end,$len) = \n\t\t( $1,$2,$3,$4,$5,$6,$7);\n\t    if( ! $lastgenenum || $lastgenenum != $genenum) {\t\t\n\t\t$self->_add_prediction($gene) if ( $gene );\n\t\t$gene = Bio::Tools::Prediction::Gene->new\n\t\t    (\n\t\t     '-seq_id'      => $seqname,\n\t\t     '-primary_tag' => \"gene\",\n\t\t     '-source_tag'  => $source,\n\t\t     '-tag'         => { 'Group' => \"GenePrediction$genenum\"},\n\t\t     );\n\t    }\n\t    my $exon = Bio::Tools::Prediction::Exon->new\n\t\t('-seq_id'     => $seqname,\n\t\t '-start'      => $start,\n\t\t '-end'        => $end,\n\t\t '-strand'     => $strand eq '-' ? '-1' : '1',\n\t\t '-source_tag' => $source,\n\t\t '-primary_tag'=> 'exon',\n\t\t '-tag'         => { 'Group' => \"GenePrediction$genenum\"},\n\t\t );\n\t    $gene->add_exon($exon,lc($type));\n\t    $lastgenenum = $genenum;\n\t}\n    }\n    $self->_add_prediction($gene) if( $gene );\n    $self->_predictions_parsed(1);\n}\n\n=head2 _parse_prokaryotic\n\n Title   : _parse_prokaryotic()\n Usage   : $obj->_parse_prokaryotic()\n Function: Parses the prediction section. Automatically called by\n           next_prediction() if not yet done.\n Example :\n Returns : \n\n\nsub _parse_prokaryotic {\n    my ($self) = @_;\n\n    # default value, possibly overriden later\n    my $source = 'Glimmer';\n\n    # Store the sequence length(s) here, either from the\n    # seqlength arg to the constructor, or from the\n    # Glimmer 3.X detail file\n    my %seqlength = ( );\n    \n    # Glimmer 2.X does not provide a sequence identifer\n    # in the prediction report (will default to unknown\n    # if not specified in the seqname arg to the\n    # constructor\n    #\n    # Glimmer 2.X does not report the length of the\n    # input sequence, either (will default to undef\n    # if not specified in the seqlength arg to the\n    # constructor\n    my $seqname = $self->_seqname();\n    my $seqlength = $self->_seqlength();\n\n    if (defined($seqlength)) {\n        $seqlength{$seqname} = $seqlength\n    }\n\n    # Parse the detail file, if we have one (Glimmer 3.X)\n    my $detail_file = $self->_detail_file();\n    \n    if (defined($detail_file)) {\n\n        my $io = Bio::Root::IO->new(-file => $detail_file);\n        my $seqname;\n        \n        while (defined($_ = $io->_readline())) {\n            if ($_ =~ /^>(\\S+)/) {\n                $seqname = $1;\n                next;\n            }\n\n            if (defined($seqname) && ($_ =~ /^Sequence length = (\\d+)$/)) {\n                $seqlength{$seqname} = $1;\n                next;\n            }\n        }\n    }\n    \n    my $location_factory = Bio::Factory::FTLocationFactory->new();\n    \n    while(defined($_ = $self->_readline())) {\n        # Glimmer 3.X does provide a sequence identifier -\n        # beware whitespace at the end (comes through from\n        # the fasta file)\n        if ($_ =~ /^Putative Genes:$/) {\n            $source = 'Glimmer_2.X';\n            next;\n        }\n        # Glimmer 3.X sequence identifier\n        elsif ($_ =~ /^>(\\S+)/) {\n            $seqname = $1;\n            $seqlength = $seqlength{$seqname};\n            $source = 'Glimmer_3.X';\n            next;\n        }        \n        elsif (\n               # Glimmer 2.X prediction \n               (/^\\s+(\\d+)\\s+      # gene num\n                (\\d+)\\s+(\\d+)\\s+   # start, end\n                \\[([\\+\\-])(\\d{1})\\s+ # strand, frame\n                /ox ) ||\n               # Glimmer 3.X prediction\n               (/^[^\\d]+(\\d+)\\s+    # orf (numeric portion)\n                (\\d+)\\s+(\\d+)\\s+   # start, end\n                ([\\+\\-])(\\d{1})\\s+   # strand, frame\n                ([\\d\\.]+)          # score\n                /ox)) {\n\t    my ($genenum,$start,$end,$strand,$frame,$score) = \n\t\t( $1,$2,$3,$4,$5,$6 );\n\n            my $circular_prediction = 0;\n\n            # Check for a circular prediction before we\n            # start fiddling with the coordinates\n            if ($strand eq '+') {\n                if ($start > $end) {\n                    $circular_prediction = 1;\n                }\n            }\n            else {\n                if ($start < $end) {\n                    $circular_prediction = 1;\n                }\n            }\n\n            if ($circular_prediction) {\n                unless (defined($seqlength)) {\n                    $self->throw(\"need to know the sequence length to handle wraparound genes\");\n                }\n            }\n            \n            # Glimmer 2.X predictions do not include\n            # the stop codon - this might extend the\n            # prediction off either end of the sequence.\n            # This works fine even on circular/wraparound\n            # predictions.  \n            if ($source eq 'Glimmer_2.X') {\n                if ($strand eq '+') { \n                    $end += 3;\n                }\n                else {\n                    $end -= 3;\n                }\n            }\n\n            # We might have extended a Glimmer 2.X prediction\n            # beyond the boundaries of the input sequence.\n            # Also, Glimmer 3.X (with -X) will output predictions\n            # with coordinates less than 1 or greater than the\n            # length of the sequence.\n            my ($fst, $fend);\n            foreach my $coord ($start, $end) {\n                if ($coord < 1) {\n                    $coord = '<1';\n                    $fst++;\n                } elsif (defined($seqlength) && ($coord > $seqlength)) {\n                    $coord = \">$seqlength\";\n                    $fend++;\n                }\n            }\n            \n            my $location_string;\n\n            if ($circular_prediction) {\n                if ($strand eq '+') {\n                    $location_string = \"join($start..$seqlength,1..$end)\";\n                }\n                else {\n                    $location_string = \"join($start..1,$seqlength..$end)\";\n                }\n                }\n            else {\n                # start must always be less than end for gene locations\n                if ($strand eq '-' && !$fst && !$fend && $start > $end) {\n                    ($start, $end) = ($end, $start);\n                }\n                $location_string = \"$start..$end\";\n            }\n            \n            my $location_object =\n                $location_factory->from_string($location_string);\n            \n            # convert glimmer's frame range from 1-3 to SeqFeature's 0-2.\n            $frame--;\n            \n            my $gene = Bio::SeqFeature::Generic->new\n                (\n                 '-seq_id'      => $seqname,\n                 '-location'   => $location_object,\n                 '-strand'     => $strand eq '-' ? '-1' : '1',\n                 '-frame'\t\t=> $frame,\n                 '-source_tag'  => $source,\n                 '-display_name' => \"orf$genenum\",\n                 '-primary_tag'=> 'gene',\n                 '-tag'         => { 'Group' => \"GenePrediction_$genenum\"},\n                 '-score'       => $score || undef\n             );\n            \n            $self->_add_prediction($gene) \n\t}\n    }\n    \n    $self->_predictions_parsed(1);\n}\n\n=head2 _prediction\n\n Title   : _prediction()\n Usage   : $gene = $obj->_prediction()\n Function: internal\n Example :\n Returns : \n\n\nsub _prediction {\n    my ($self) = @_;\n\n    return unless(exists($self->{'_preds'}) && @{$self->{'_preds'}});\n    return shift(@{$self->{'_preds'}});\n}\n\n=head2 _add_prediction\n\n Title   : _add_prediction()\n Usage   : $obj->_add_prediction($gene)\n Function: internal\n Example :\n Returns : \n\n\nsub _add_prediction {\n    my ($self, $gene) = @_;\n\n    if(! exists($self->{'_preds'})) {\n\t$self->{'_preds'} = [];\n    }\n    push(@{$self->{'_preds'}}, $gene);\n}\n\n=head2 _predictions_parsed\n\n Title   : _predictions_parsed\n Usage   : $obj->_predictions_parsed\n Function: internal\n Example :\n Returns : TRUE or FALSE\n\n\nsub _predictions_parsed {\n    my ($self, $val) = @_;\n\n    $self->{'_preds_parsed'} = $val if $val;\n    if(! exists($self->{'_preds_parsed'})) {\n\t$self->{'_preds_parsed'} = 0;\n    }\n    return $self->{'_preds_parsed'};\n}\n\n=head2 _seqname\n\n Title   : _seqname\n Usage   : $obj->_seqname($seqname)\n Function: internal (for Glimmer 2.X)\n Example :\n Returns : String\n\n\nsub _seqname {\n    my ($self, $val) = @_;\n\n    $self->{'_seqname'} = $val if $val;\n    if(! exists($self->{'_seqname'})) {\n\t$self->{'_seqname'} = 'unknown';\n    }\n    return $self->{'_seqname'};\n}\n\n=head2 _seqlength\n\n Title   : _seqlength\n Usage   : $obj->_seqlength($seqlength)\n Function: internal (for Glimmer 2.X)\n Example :\n Returns : String\n\n\nsub _seqlength {\n    my ($self, $val) = @_;\n\n    $self->{'_seqlength'} = $val if $val;\n    return $self->{'_seqlength'};\n}\n\n=head2 _format\n\n Title   : _format\n Usage   : $obj->_format($format)\n Function: internal\n Example :\n Returns : String","label":"_format($self,$val)"},"containerName":"main::","definition":"sub","line":686,"children":[{"line":687,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"_format"},{"name":"$val","containerName":"_format","line":687,"kind":13},{"name":"$self","containerName":"_format","kind":13,"line":689},{"line":689,"kind":13,"name":"$val","containerName":"_format"},{"name":"$val","containerName":"_format","kind":13,"line":689},{"name":"$self","containerName":"_format","kind":13,"line":691}],"kind":12},{"range":{"start":{"line":704,"character":0},"end":{"line":709,"character":9999}},"name":"_detail_file","signature":{"label":"_detail_file($self,$val)","documentation":"1;\n# $Id: Glimmer.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Glimmer\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Glimmer - parser for Glimmer 2.X/3.X prokaryotic and \nGlimmerM/GlimmerHMM eukaryotic gene predictions\n\n=head1 SYNOPSIS\n\n   use Bio::Tools::Glimmer;\n\n   # file\n   my $parser = Bio::Tools::Glimmer->new(-file => $file);\n   # filehandle:\n   $parser = Bio::Tools::Glimmer->new( -fh  => \\*INPUT );\n   # provide a sequence identifier (Glimmer 2.X)\n   my $parser = Bio::Tools::Glimmer->new(-file => $file, -seqname => seqname);\n   # force format (override automatic detection)\n   my $parser = Bio::Tools::Glimmer->new(-file => $file, -format => 'GlimmerM');\n\n   # parse the results\n   # note: this class is-a Bio::Tools::AnalysisResult which implements\n   # Bio::SeqAnalysisParserI, i.e., $glimmer->next_feature() is the same\n\n   while(my $gene = $parser->next_prediction()) {\n       # For eukaryotic input (GlimmerM/GlimmerHMM), $gene will be an instance\n       # of Bio::Tools::Prediction::Gene, which inherits off\n       # Bio::SeqFeature::Gene::Transcript, and $gene->exons() will return an\n       # array of Bio::Tools::Prediction::Exon objects.\n       # For prokaryotic input (Glimmer2.X/Glimmer3.X), $gene will be an\n       # instance of Bio::SeqFeature::Generic\n\n       # all exons (eukaryotic only):\n       @exon_arr = $gene->exons();\n       # initial exons only\n       @init_exons = $gene->exons('Initial');\n       # internal exons only\n       @intrl_exons = $gene->exons('Internal');\n       # terminal exons only\n       @term_exons = $gene->exons('Terminal');\n   }\n\n=head1 DESCRIPTION\n\nThis is a module for parsing Glimmer, GlimmerM and GlimmerHMM predictions.  \nIt will create gene objects from the prediction report which can \nbe attached to a sequence using Bioperl objects, or output as GFF \nsuitable for loading into Bio::DB::GFF for use with Gbrowse.\n\nGlimmer is open source and available at\nL<http://www.cbcb.umd.edu/software/glimmer/>.\n\nGlimmerM is open source and available at \nL<http://www.tigr.org/software/glimmerm/>.\n\nGlimmerHMM is open source and available at\nL<http://www.cbcb.umd.edu/software/GlimmerHMM/>.\n\nNote that Glimmer 2.X will only process the first\nsequence in a fasta file, and the prediction report does not contain any\nsort of sequence identifier\n\nNote that Glimmer 3.X produces two output files.  This module only parses\nthe .predict file.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nemail or the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nTorsten Seemann\n\nMark Johnson\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Glimmer;\nuse strict;\n\nuse Bio::Factory::FTLocationFactory;\nuse Bio::Tools::Prediction::Gene;\nuse Bio::Tools::Prediction::Exon;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\nsub _initialize_state {\n    my($self,@args) = @_;\n\n    # first call the inherited method!\n    my $make = $self->SUPER::_initialize_state(@args);\n\n    $self->{'_preds_parsed'} = 0;\n    # array of pre-parsed predictions\n    $self->{'_preds'} = [];\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::Glimmer->new();\n Function: Builds a new Bio::Tools::Glimmer object \n Returns : an instance of Bio::Tools::Glimmer\n Args    : format ('Glimmer', 'GlimmerM', 'GlimmerHMM'), seqname\n\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  my ($format, $seqname, $seqlength, $detail) =\n      $self->_rearrange([qw(FORMAT SEQNAME SEQLENGTH DETAIL)], @args);\n\n  # override automagic format detection\n  if (defined($format) &&\n      (($format eq 'Glimmer')  ||\n       ($format eq 'GlimmerM') ||\n       ($format eq 'GlimmerHMM'))\n  ) {\n      $self->_format($format);\n  }\n  \n  if (defined($detail)) {\n      $self->_format('Glimmer');\n      $self->_detail_file($detail);\n  }\n  \n  # hardwire seq_id when creating gene and exon objects (Glimmer 2.X)\n  $self->_seqname($seqname) if defined($seqname);\n  \n  # store the length of the input sequence (Glimmer 2.X)\n  $self->_seqlength($seqlength) if defined($seqlength);\n  \n  return $self;\n}\n\n=head2 analysis_method\n\n Usage     : $glimmer->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /glimmer/i.\n Returns   : String\n Argument  : n/a\n\n\n#-------------\nsub analysis_method { \n#-------------\n    my ($self, $method) = @_;  \n    if($method && ($method !~ /glimmer/i)) {\n\t$self->throw(\"method $method not supported in \" . ref($self));\n    }\n    return $self->SUPER::analysis_method($method);\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : while($gene = $glimmer->next_feature()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the Glimmer result\n           file. Call this method repeatedly until FALSE is returned.\n\n           The returned object is actually a SeqFeatureI implementing object.\n           This method is required for classes implementing the\n           SeqAnalysisParserI interface, and is merely an alias for \n           next_prediction() at present.\n\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :\n\n\nsub next_feature {\n    my ($self,@args) = @_;\n    # even though next_prediction doesn't expect any args (and this method\n    # does neither), we pass on args in order to be prepared if this changes\n    # ever\n    return $self->next_prediction(@args);\n}\n\n=head2 next_prediction\n\n Title   : next_prediction\n Usage   : while($gene = $glimmer->next_prediction()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the Glimmer result\n           file. Call this method repeatedly until FALSE is returned.\n\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :\n\n\nsub next_prediction {\n    my ($self) = @_;\n    my $gene;\n\n    # if the prediction section hasn't been parsed yet, we do this now\n    $self->_parse_predictions() unless $self->_predictions_parsed();\n    \n    # get next gene structure\n    $gene = $self->_prediction();\n    return $gene;\n}\n\n=head2 _parse_predictions\n\n Title   : _parse_predictions()\n Usage   : $obj->_parse_predictions()\n Function: Parses the prediction section. Automatically called by\n           next_prediction() if not yet done.\n Example :\n Returns : \n\n\nsub _parse_predictions {\n\n    my ($self) = @_;\n\n    \n    my %method = (\n                  'Glimmer'    => '_parse_prokaryotic',\n                  'GlimmerM'   => '_parse_eukaryotic',\n                  'GlimmerHMM' => '_parse_eukaryotic',\n                  '_DEFAULT_'  => '_parse_eukaryotic',\n              );\n    \n    my $format = $self->_format();\n    \n    if (!$format) {\n        \n        while (my $line = $self->_readline()) {\n\n            if ( $line =~ /^Glimmer\\S*\\s+\\(Version\\s*\\S+\\)/ ) {\n                $format = 'GlimmerM';\n                $self->_pushback($line);\n                last;\n            }\n            elsif ( $line =~ /^Glimmer\\S*$/ ) {\n                $format = 'GlimmerHMM';\n                $self->_pushback($line);\n                last;\n            }\n            elsif ($line =~ /^Putative Genes:$/) {\n                $format = 'Glimmer';\n                $self->_pushback($line);\n                last;\n            }\n            elsif ($line =~ /^>(\\S+)/) {\n                $format = 'Glimmer';\n                $self->_pushback($line);\n                last;\n            }\n            \n        }\n        \n    }\n\n    my $method =\n        (exists($method{$format})) ? $method{$format} : $method{'_DEFAULT_'};\n\n    return $self->$method();\n    \n}\n\n\n=head2 _parse_eukaryotic\n\n Title   : _parse_eukaryotic()\n Usage   : $obj->_parse_eukaryotic()\n Function: Parses the prediction section. Automatically called by\n           next_prediction() if not yet done.\n Example :\n Returns : \n\n\nsub _parse_eukaryotic {\n    my ($self) = @_;\n\n    my ($gene,$seqname,$seqlen,$source,$lastgenenum);\n    \n    while(defined($_ = $self->_readline())) {\n\tif( /^(Glimmer\\S*)\\s+\\(Version\\s*(\\S+)\\)/ ) {\n\t    $source = \"$1_$2\";\n\t    next;\n\t} elsif( /^(GlimmerHMM\\S*)$/ ) { # GlimmerHMM has no version\n\t    $source = $1;\n\t    next;\n\t} elsif(/^Sequence name:\\s+(.+)$/ ) {\n\t    $seqname = $1;\n\t    next;\n\t} elsif( /^Sequence length:\\s+(\\S+)/ ) {\n\t    $seqlen = $1;\n\t    next;\n\t} elsif( m/^(Predicted genes)|(Gene)|\\s+\\#/ || /^\\s+$/ ) { \n\t    next;\n\t    \n\t} elsif( # GlimmerM/HMM gene-exon prediction line\n\t\t /^\\s+(\\d+)\\s+ # gene num\n\t\t (\\d+)\\s+      # exon num\n\t\t ([\\+\\-])\\s+   # strand\n\t\t (\\S+)\\s+      # exon type\n\t\t (\\d+)\\s+(\\d+) # exon start, end\n\t\t \\s+(\\d+)      # exon length\t\t \n\t\t /ox ) {\n\t    my ($genenum,$exonnum,$strand,$type,$start,$end,$len) = \n\t\t( $1,$2,$3,$4,$5,$6,$7);\n\t    if( ! $lastgenenum || $lastgenenum != $genenum) {\t\t\n\t\t$self->_add_prediction($gene) if ( $gene );\n\t\t$gene = Bio::Tools::Prediction::Gene->new\n\t\t    (\n\t\t     '-seq_id'      => $seqname,\n\t\t     '-primary_tag' => \"gene\",\n\t\t     '-source_tag'  => $source,\n\t\t     '-tag'         => { 'Group' => \"GenePrediction$genenum\"},\n\t\t     );\n\t    }\n\t    my $exon = Bio::Tools::Prediction::Exon->new\n\t\t('-seq_id'     => $seqname,\n\t\t '-start'      => $start,\n\t\t '-end'        => $end,\n\t\t '-strand'     => $strand eq '-' ? '-1' : '1',\n\t\t '-source_tag' => $source,\n\t\t '-primary_tag'=> 'exon',\n\t\t '-tag'         => { 'Group' => \"GenePrediction$genenum\"},\n\t\t );\n\t    $gene->add_exon($exon,lc($type));\n\t    $lastgenenum = $genenum;\n\t}\n    }\n    $self->_add_prediction($gene) if( $gene );\n    $self->_predictions_parsed(1);\n}\n\n=head2 _parse_prokaryotic\n\n Title   : _parse_prokaryotic()\n Usage   : $obj->_parse_prokaryotic()\n Function: Parses the prediction section. Automatically called by\n           next_prediction() if not yet done.\n Example :\n Returns : \n\n\nsub _parse_prokaryotic {\n    my ($self) = @_;\n\n    # default value, possibly overriden later\n    my $source = 'Glimmer';\n\n    # Store the sequence length(s) here, either from the\n    # seqlength arg to the constructor, or from the\n    # Glimmer 3.X detail file\n    my %seqlength = ( );\n    \n    # Glimmer 2.X does not provide a sequence identifer\n    # in the prediction report (will default to unknown\n    # if not specified in the seqname arg to the\n    # constructor\n    #\n    # Glimmer 2.X does not report the length of the\n    # input sequence, either (will default to undef\n    # if not specified in the seqlength arg to the\n    # constructor\n    my $seqname = $self->_seqname();\n    my $seqlength = $self->_seqlength();\n\n    if (defined($seqlength)) {\n        $seqlength{$seqname} = $seqlength\n    }\n\n    # Parse the detail file, if we have one (Glimmer 3.X)\n    my $detail_file = $self->_detail_file();\n    \n    if (defined($detail_file)) {\n\n        my $io = Bio::Root::IO->new(-file => $detail_file);\n        my $seqname;\n        \n        while (defined($_ = $io->_readline())) {\n            if ($_ =~ /^>(\\S+)/) {\n                $seqname = $1;\n                next;\n            }\n\n            if (defined($seqname) && ($_ =~ /^Sequence length = (\\d+)$/)) {\n                $seqlength{$seqname} = $1;\n                next;\n            }\n        }\n    }\n    \n    my $location_factory = Bio::Factory::FTLocationFactory->new();\n    \n    while(defined($_ = $self->_readline())) {\n        # Glimmer 3.X does provide a sequence identifier -\n        # beware whitespace at the end (comes through from\n        # the fasta file)\n        if ($_ =~ /^Putative Genes:$/) {\n            $source = 'Glimmer_2.X';\n            next;\n        }\n        # Glimmer 3.X sequence identifier\n        elsif ($_ =~ /^>(\\S+)/) {\n            $seqname = $1;\n            $seqlength = $seqlength{$seqname};\n            $source = 'Glimmer_3.X';\n            next;\n        }        \n        elsif (\n               # Glimmer 2.X prediction \n               (/^\\s+(\\d+)\\s+      # gene num\n                (\\d+)\\s+(\\d+)\\s+   # start, end\n                \\[([\\+\\-])(\\d{1})\\s+ # strand, frame\n                /ox ) ||\n               # Glimmer 3.X prediction\n               (/^[^\\d]+(\\d+)\\s+    # orf (numeric portion)\n                (\\d+)\\s+(\\d+)\\s+   # start, end\n                ([\\+\\-])(\\d{1})\\s+   # strand, frame\n                ([\\d\\.]+)          # score\n                /ox)) {\n\t    my ($genenum,$start,$end,$strand,$frame,$score) = \n\t\t( $1,$2,$3,$4,$5,$6 );\n\n            my $circular_prediction = 0;\n\n            # Check for a circular prediction before we\n            # start fiddling with the coordinates\n            if ($strand eq '+') {\n                if ($start > $end) {\n                    $circular_prediction = 1;\n                }\n            }\n            else {\n                if ($start < $end) {\n                    $circular_prediction = 1;\n                }\n            }\n\n            if ($circular_prediction) {\n                unless (defined($seqlength)) {\n                    $self->throw(\"need to know the sequence length to handle wraparound genes\");\n                }\n            }\n            \n            # Glimmer 2.X predictions do not include\n            # the stop codon - this might extend the\n            # prediction off either end of the sequence.\n            # This works fine even on circular/wraparound\n            # predictions.  \n            if ($source eq 'Glimmer_2.X') {\n                if ($strand eq '+') { \n                    $end += 3;\n                }\n                else {\n                    $end -= 3;\n                }\n            }\n\n            # We might have extended a Glimmer 2.X prediction\n            # beyond the boundaries of the input sequence.\n            # Also, Glimmer 3.X (with -X) will output predictions\n            # with coordinates less than 1 or greater than the\n            # length of the sequence.\n            my ($fst, $fend);\n            foreach my $coord ($start, $end) {\n                if ($coord < 1) {\n                    $coord = '<1';\n                    $fst++;\n                } elsif (defined($seqlength) && ($coord > $seqlength)) {\n                    $coord = \">$seqlength\";\n                    $fend++;\n                }\n            }\n            \n            my $location_string;\n\n            if ($circular_prediction) {\n                if ($strand eq '+') {\n                    $location_string = \"join($start..$seqlength,1..$end)\";\n                }\n                else {\n                    $location_string = \"join($start..1,$seqlength..$end)\";\n                }\n                }\n            else {\n                # start must always be less than end for gene locations\n                if ($strand eq '-' && !$fst && !$fend && $start > $end) {\n                    ($start, $end) = ($end, $start);\n                }\n                $location_string = \"$start..$end\";\n            }\n            \n            my $location_object =\n                $location_factory->from_string($location_string);\n            \n            # convert glimmer's frame range from 1-3 to SeqFeature's 0-2.\n            $frame--;\n            \n            my $gene = Bio::SeqFeature::Generic->new\n                (\n                 '-seq_id'      => $seqname,\n                 '-location'   => $location_object,\n                 '-strand'     => $strand eq '-' ? '-1' : '1',\n                 '-frame'\t\t=> $frame,\n                 '-source_tag'  => $source,\n                 '-display_name' => \"orf$genenum\",\n                 '-primary_tag'=> 'gene',\n                 '-tag'         => { 'Group' => \"GenePrediction_$genenum\"},\n                 '-score'       => $score || undef\n             );\n            \n            $self->_add_prediction($gene) \n\t}\n    }\n    \n    $self->_predictions_parsed(1);\n}\n\n=head2 _prediction\n\n Title   : _prediction()\n Usage   : $gene = $obj->_prediction()\n Function: internal\n Example :\n Returns : \n\n\nsub _prediction {\n    my ($self) = @_;\n\n    return unless(exists($self->{'_preds'}) && @{$self->{'_preds'}});\n    return shift(@{$self->{'_preds'}});\n}\n\n=head2 _add_prediction\n\n Title   : _add_prediction()\n Usage   : $obj->_add_prediction($gene)\n Function: internal\n Example :\n Returns : \n\n\nsub _add_prediction {\n    my ($self, $gene) = @_;\n\n    if(! exists($self->{'_preds'})) {\n\t$self->{'_preds'} = [];\n    }\n    push(@{$self->{'_preds'}}, $gene);\n}\n\n=head2 _predictions_parsed\n\n Title   : _predictions_parsed\n Usage   : $obj->_predictions_parsed\n Function: internal\n Example :\n Returns : TRUE or FALSE\n\n\nsub _predictions_parsed {\n    my ($self, $val) = @_;\n\n    $self->{'_preds_parsed'} = $val if $val;\n    if(! exists($self->{'_preds_parsed'})) {\n\t$self->{'_preds_parsed'} = 0;\n    }\n    return $self->{'_preds_parsed'};\n}\n\n=head2 _seqname\n\n Title   : _seqname\n Usage   : $obj->_seqname($seqname)\n Function: internal (for Glimmer 2.X)\n Example :\n Returns : String\n\n\nsub _seqname {\n    my ($self, $val) = @_;\n\n    $self->{'_seqname'} = $val if $val;\n    if(! exists($self->{'_seqname'})) {\n\t$self->{'_seqname'} = 'unknown';\n    }\n    return $self->{'_seqname'};\n}\n\n=head2 _seqlength\n\n Title   : _seqlength\n Usage   : $obj->_seqlength($seqlength)\n Function: internal (for Glimmer 2.X)\n Example :\n Returns : String\n\n\nsub _seqlength {\n    my ($self, $val) = @_;\n\n    $self->{'_seqlength'} = $val if $val;\n    return $self->{'_seqlength'};\n}\n\n=head2 _format\n\n Title   : _format\n Usage   : $obj->_format($format)\n Function: internal\n Example :\n Returns : String\n\n\nsub _format {\n    my ($self, $val) = @_;\n\n    $self->{'_format'} = $val if $val;\n\n    return $self->{'_format'};\n}\n\n=head2 _detail_file\n\n Title   : _detail_file\n Usage   : $obj->_detail_file($filename)\n Function: internal (for Glimmer 3.X)\n Example :\n Returns : String","parameters":[{"label":"$self"},{"label":"$val"}]},"detail":"($self,$val)","definition":"sub","containerName":"main::","children":[{"kind":13,"line":705,"containerName":"_detail_file","definition":"my","name":"$self","localvar":"my"},{"name":"$val","containerName":"_detail_file","line":705,"kind":13},{"containerName":"_detail_file","name":"$self","kind":13,"line":707},{"name":"$val","containerName":"_detail_file","line":707,"kind":13},{"containerName":"_detail_file","name":"$val","kind":13,"line":707},{"kind":13,"line":708,"name":"$self","containerName":"_detail_file"}],"line":704,"kind":12}]}