{"version":5,"vars":[{"kind":2,"line":82,"name":"vars","containerName":""},{"line":93,"kind":2,"containerName":"","name":"base"},{"containerName":null,"name":"$Srctag","kind":13,"line":94},{"containerName":"main::","definition":"sub","detail":"($class,@args)","signature":{"label":"new($class,@args)","documentation":"1;\n# $Id: Genewise.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Genewise\n#\n# Copyright Fugu Team \n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Genewise - Results of one Genewise run\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::Genewise;\n  my $gw = Bio::Tools::Genewise(-file=>\"genewise.out\");\n\n  while (my $gene = $gw->next_prediction){\n    my @transcripts = $gene->transcripts;\n      foreach my $t(@transcripts){\n        my @exons =  $t->exons;\n        foreach my $e(@exons){\n            print $e->start.\" \".$e->end.\"\\n\";\n        }\n      }\n  }\n\n=head1 DESCRIPTION\n\nThis is the parser for the output of Genewise. It takes either a file\nhandle or a file name and returns a \nBio::SeqFeature::Gene::GeneStructure object.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Fugu Team, Jason Stajich \n\n Email: fugui@worf.fugu-sg.org\n Email: jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Genewise;\nuse vars qw($Srctag);\nuse strict;\nuse Symbol;\n\nuse Bio::Tools::AnalysisResult;\nuse Bio::SeqFeature::Generic;\nuse Bio::SeqFeature::Gene::Exon;\nuse Bio::SeqFeature::FeaturePair;\nuse Bio::SeqFeature::Gene::Transcript;\nuse Bio::SeqFeature::Gene::GeneStructure;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n$Srctag = 'genewise';\n\n=head2 new\n\n Title   : new\n Usage   : $obj->new(-file=>\"genewise.out\");\n           $obj->new(-fh=>\\*GW);\n Function: Constructor for genewise wrapper. Takes either a file or filehandle\n Example :\n Returns : Bio::Tools::Genewise object\n\nSee L<Bio::Tools::Genewise>","parameters":[{"label":"$class"},{"label":"@args"}]},"kind":12,"line":109,"children":[{"localvar":"my","name":"$class","definition":"my","containerName":"new","line":110,"kind":13},{"containerName":"new","name":"@args","kind":13,"line":110},{"containerName":"new","name":"$self","definition":"my","localvar":"my","kind":13,"line":111},{"line":111,"kind":13,"containerName":"new","name":"$class"},{"line":111,"kind":13,"name":"@args","containerName":"new"},{"name":"$self","containerName":"new","line":112,"kind":13},{"kind":12,"line":112,"name":"_initialize_io","containerName":"new"},{"name":"@args","containerName":"new","kind":13,"line":112},{"containerName":"new","name":"$self","line":113,"kind":13}],"name":"new","range":{"end":{"line":114,"character":9999},"start":{"character":0,"line":109}}},{"containerName":"new","name":"SUPER","line":111,"kind":12},{"definition":"sub","containerName":"main::","signature":{"label":"_get_strand($self,$start,$end)","documentation":"1;\n# $Id: Genewise.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Genewise\n#\n# Copyright Fugu Team \n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Genewise - Results of one Genewise run\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::Genewise;\n  my $gw = Bio::Tools::Genewise(-file=>\"genewise.out\");\n\n  while (my $gene = $gw->next_prediction){\n    my @transcripts = $gene->transcripts;\n      foreach my $t(@transcripts){\n        my @exons =  $t->exons;\n        foreach my $e(@exons){\n            print $e->start.\" \".$e->end.\"\\n\";\n        }\n      }\n  }\n\n=head1 DESCRIPTION\n\nThis is the parser for the output of Genewise. It takes either a file\nhandle or a file name and returns a \nBio::SeqFeature::Gene::GeneStructure object.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Fugu Team, Jason Stajich \n\n Email: fugui@worf.fugu-sg.org\n Email: jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Genewise;\nuse vars qw($Srctag);\nuse strict;\nuse Symbol;\n\nuse Bio::Tools::AnalysisResult;\nuse Bio::SeqFeature::Generic;\nuse Bio::SeqFeature::Gene::Exon;\nuse Bio::SeqFeature::FeaturePair;\nuse Bio::SeqFeature::Gene::Transcript;\nuse Bio::SeqFeature::Gene::GeneStructure;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n$Srctag = 'genewise';\n\n=head2 new\n\n Title   : new\n Usage   : $obj->new(-file=>\"genewise.out\");\n           $obj->new(-fh=>\\*GW);\n Function: Constructor for genewise wrapper. Takes either a file or filehandle\n Example :\n Returns : Bio::Tools::Genewise object\n\nSee L<Bio::Tools::Genewise>\n\n\nsub new {\n  my($class,@args) = @_;\n  my $self = $class->SUPER::new(@args);\n  $self->_initialize_io(@args);\n  return $self;\n}\n\n=head2 _get_strand\n\n Title   : _get_strand\n Usage   : $obj->_get_strand\n Function: takes start and end values, swap them if start>end and \n           returns end\n Example :\n Returns :$start,$end,$strand","parameters":[{"label":"$self"},{"label":"$start"},{"label":"$end"}]},"detail":"($self,$start,$end)","kind":12,"children":[{"localvar":"my","containerName":"_get_strand","name":"$self","definition":"my","line":128,"kind":13},{"kind":13,"line":128,"name":"$start","containerName":"_get_strand"},{"containerName":"_get_strand","name":"$end","line":128,"kind":13},{"containerName":"_get_strand","name":"$start","line":129,"kind":13},{"line":129,"kind":13,"name":"$self","containerName":"_get_strand"},{"containerName":"_get_strand","name":"throw","kind":12,"line":129},{"line":130,"kind":13,"containerName":"_get_strand","name":"$end"},{"name":"$self","containerName":"_get_strand","kind":13,"line":130},{"name":"throw","containerName":"_get_strand","kind":12,"line":130},{"localvar":"my","containerName":"_get_strand","name":"$strand","definition":"my","line":131,"kind":13},{"line":132,"kind":13,"name":"$start","containerName":"_get_strand"},{"kind":13,"line":132,"name":"$end","containerName":"_get_strand"},{"line":133,"kind":13,"localvar":"my","definition":"my","name":"$tmp","containerName":"_get_strand"},{"containerName":"_get_strand","name":"$start","line":133,"kind":13},{"containerName":"_get_strand","name":"$start","line":134,"kind":13},{"kind":13,"line":134,"name":"$end","containerName":"_get_strand"},{"line":135,"kind":13,"name":"$end","containerName":"_get_strand"},{"line":135,"kind":13,"name":"$tmp","containerName":"_get_strand"},{"name":"$strand","containerName":"_get_strand","kind":13,"line":136},{"kind":13,"line":139,"containerName":"_get_strand","name":"$strand"},{"name":"$start","containerName":"_get_strand","kind":13,"line":141},{"name":"$end","containerName":"_get_strand","kind":13,"line":141},{"containerName":"_get_strand","name":"$strand","line":141,"kind":13}],"line":127,"name":"_get_strand","range":{"start":{"character":0,"line":127},"end":{"line":142,"character":9999}}},{"range":{"start":{"line":153,"character":0},"end":{"character":9999,"line":157}},"name":"_score","definition":"sub","containerName":"main::","children":[{"definition":"my","name":"$self","containerName":"_score","localvar":"my","kind":13,"line":154},{"kind":13,"line":155,"containerName":"_score","name":"$self"},{"kind":13,"line":156,"name":"$self","containerName":"_score"}],"line":153,"kind":12},{"range":{"start":{"character":0,"line":168},"end":{"character":9999,"line":172}},"containerName":"main::","definition":"sub","name":"_prot_id","line":168,"children":[{"definition":"my","name":"$self","containerName":"_prot_id","localvar":"my","kind":13,"line":169},{"containerName":"_prot_id","name":"$self","kind":13,"line":170},{"name":"$self","containerName":"_prot_id","kind":13,"line":171}],"kind":12},{"kind":12,"line":184,"children":[{"kind":13,"line":185,"containerName":"_target_id","name":"$self","definition":"my","localvar":"my"},{"containerName":"_target_id","name":"$self","kind":13,"line":186},{"line":187,"kind":13,"name":"$self","containerName":"_target_id"}],"containerName":"main::","definition":"sub","name":"_target_id","range":{"end":{"line":188,"character":9999},"start":{"line":184,"character":0}}},{"range":{"end":{"character":9999,"line":216},"start":{"line":209,"character":0}},"name":"next_prediction","children":[{"line":210,"kind":13,"localvar":"my","containerName":"next_prediction","definition":"my","name":"$self"},{"name":"$self","containerName":"next_prediction","line":212,"kind":13},{"name":"parsed","containerName":"next_prediction","line":212,"kind":12},{"line":213,"kind":13,"name":"$self","containerName":"next_prediction"},{"containerName":"next_prediction","name":"_parse_genes","line":213,"kind":12},{"name":"$self","containerName":"next_prediction","kind":13,"line":214},{"containerName":"next_prediction","name":"parsed","kind":12,"line":214},{"kind":13,"line":216,"containerName":"next_prediction","name":"$self"}],"line":209,"kind":12,"signature":{"label":"next_prediction($self)","documentation":"1;\n# $Id: Genewise.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Genewise\n#\n# Copyright Fugu Team \n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Genewise - Results of one Genewise run\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::Genewise;\n  my $gw = Bio::Tools::Genewise(-file=>\"genewise.out\");\n\n  while (my $gene = $gw->next_prediction){\n    my @transcripts = $gene->transcripts;\n      foreach my $t(@transcripts){\n        my @exons =  $t->exons;\n        foreach my $e(@exons){\n            print $e->start.\" \".$e->end.\"\\n\";\n        }\n      }\n  }\n\n=head1 DESCRIPTION\n\nThis is the parser for the output of Genewise. It takes either a file\nhandle or a file name and returns a \nBio::SeqFeature::Gene::GeneStructure object.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Fugu Team, Jason Stajich \n\n Email: fugui@worf.fugu-sg.org\n Email: jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Genewise;\nuse vars qw($Srctag);\nuse strict;\nuse Symbol;\n\nuse Bio::Tools::AnalysisResult;\nuse Bio::SeqFeature::Generic;\nuse Bio::SeqFeature::Gene::Exon;\nuse Bio::SeqFeature::FeaturePair;\nuse Bio::SeqFeature::Gene::Transcript;\nuse Bio::SeqFeature::Gene::GeneStructure;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n$Srctag = 'genewise';\n\n=head2 new\n\n Title   : new\n Usage   : $obj->new(-file=>\"genewise.out\");\n           $obj->new(-fh=>\\*GW);\n Function: Constructor for genewise wrapper. Takes either a file or filehandle\n Example :\n Returns : Bio::Tools::Genewise object\n\nSee L<Bio::Tools::Genewise>\n\n\nsub new {\n  my($class,@args) = @_;\n  my $self = $class->SUPER::new(@args);\n  $self->_initialize_io(@args);\n  return $self;\n}\n\n=head2 _get_strand\n\n Title   : _get_strand\n Usage   : $obj->_get_strand\n Function: takes start and end values, swap them if start>end and \n           returns end\n Example :\n Returns :$start,$end,$strand\n\n\nsub _get_strand {\n  my ($self,$start,$end) = @_;\n  defined($start) || $self->throw(\"Need a start\");\n  defined($end)   || $self->throw(\"Need an end\");\n  my $strand;\n  if ($start > $end) {\n    my $tmp = $start;\n    $start = $end;\n    $end = $tmp;\n    $strand = -1;\n  }\n  else {\n    $strand = 1;\n  }\n  return ($start,$end,$strand);\n}\n\n=head2 _score\n\n Title   : _score\n Usage   : $obj->_score\n Function: get/set for score info\n Returns : a score value\n\n\nsub _score {\n    my $self = shift;\n    return $self->{'_score'} = shift if @_;\n    return $self->{'_score'};\n}\n\n=head2 _prot_id\n\n Title   : _prot_id\n Usage   : $obj->_prot_id\n Function: get/set for protein id \n Returns :a protein id\n\n\nsub _prot_id {\n    my $self = shift;\n    return $self->{'_prot_id'} = shift if @_;\n    return $self->{'_prot_id'};\n}\n\n=head2 _target_id\n\n Title   : _target_id\n Usage   : $obj->_target_id\n Function: get/set for genomic sequence id\n Example :\n Returns :a target id\n\n\nsub _target_id {\n    my $self = shift;\n    return $self->{'_target_id'} = shift if @_;\n    return $self->{'_target_id'};\n}\n\n\n=head2 next_prediction\n\n Title   : next_prediction\n Usage   : while($gene = $genewise->next_prediction()) {\n                  # do something\n           }\n Function: Returns the gene structure prediction of the Genewise result\n           file. Call this method repeatedly until FALSE is returned.\n\n Example :\n Returns : a Bio::SeqFeature::Gene::GeneStructure object\n Args    :\n\nSee L<Bio::SeqFeature::Gene::GeneStructure>","parameters":[{"label":"$self"}]},"detail":"($self)","definition":"sub","containerName":"main::"},{"kind":12,"children":[{"localvar":"my","containerName":"parsed","name":"$self","definition":"my","line":220,"kind":13},{"line":221,"kind":13,"name":"$self","containerName":"parsed"},{"name":"$self","containerName":"parsed","kind":13,"line":222}],"line":219,"definition":"sub","name":"parsed","containerName":"main::","range":{"start":{"line":219,"character":0},"end":{"line":223,"character":9999}}},{"range":{"start":{"line":225,"character":0},"end":{"line":355,"character":9999}},"name":"_parse_genes","line":225,"children":[{"line":226,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"_parse_genes"},{"kind":13,"line":227,"containerName":"_parse_genes","name":"@alignments","definition":"my","localvar":"my"},{"name":"@genes","containerName":"_parse_genes","kind":13,"line":227},{"line":230,"kind":13,"name":"$self","containerName":"_parse_genes"},{"line":230,"kind":12,"name":"_readline","containerName":"_parse_genes"},{"kind":13,"line":231,"containerName":"_parse_genes","name":"$self"},{"containerName":"_parse_genes","name":"debug","line":231,"kind":12},{"name":"$alignments","containerName":"_parse_genes","kind":13,"line":233},{"kind":13,"line":236,"name":"$self","containerName":"_parse_genes"},{"name":"_score","containerName":"_parse_genes","kind":12,"line":236},{"containerName":"_parse_genes","name":"$self","kind":13,"line":240},{"line":240,"kind":12,"name":"_prot_id","containerName":"_parse_genes"},{"line":244,"kind":13,"name":"$self","containerName":"_parse_genes"},{"line":244,"kind":12,"name":"_target_id","containerName":"_parse_genes"},{"localvar":"my","definition":"my","name":"@genes_txt","containerName":"_parse_genes","line":248,"kind":13},{"containerName":"_parse_genes","name":"@genes_txt","line":249,"kind":13},{"kind":13,"line":250,"name":"$gene_num","definition":"my","containerName":"_parse_genes","localvar":"my"},{"line":251,"kind":13,"localvar":"my","definition":"my","name":"$gene_txt","containerName":"_parse_genes"},{"line":251,"kind":13,"name":"@genes_txt","containerName":"_parse_genes"},{"line":252,"kind":13,"localvar":"my","definition":"my","name":"$score","containerName":"_parse_genes"},{"containerName":"_parse_genes","name":"$alignments","kind":13,"line":252},{"containerName":"_parse_genes","name":"$gene_num","line":252,"kind":13},{"kind":13,"line":255,"containerName":"_parse_genes","name":"$g_start","definition":"my","localvar":"my"},{"line":255,"kind":13,"name":"$g_end","containerName":"_parse_genes"},{"kind":13,"line":255,"name":"$type","containerName":"_parse_genes"},{"containerName":"_parse_genes","name":"$gene_txt","kind":13,"line":256},{"definition":"my","name":"$g_strand","containerName":"_parse_genes","localvar":"my","kind":13,"line":261},{"containerName":"_parse_genes","name":"$source_tag","definition":"my","localvar":"my","kind":13,"line":262},{"containerName":"_parse_genes","name":"$type","kind":13,"line":262},{"kind":13,"line":262,"containerName":"_parse_genes","name":"$Srctag"},{"name":"$genes","definition":"my","containerName":"_parse_genes","localvar":"my","kind":13,"line":263},{"line":264,"kind":12,"name":"new","containerName":"_parse_genes"},{"line":264,"kind":13,"name":"$source_tag","containerName":"_parse_genes"},{"name":"$self","containerName":"_parse_genes","kind":13,"line":265},{"line":265,"kind":12,"containerName":"_parse_genes","name":"_score"},{"kind":13,"line":267,"name":"$genes","containerName":"_parse_genes"},{"line":267,"kind":12,"containerName":"_parse_genes","name":"add_tag_value"},{"kind":13,"line":267,"name":"$self","containerName":"_parse_genes"},{"kind":12,"line":267,"containerName":"_parse_genes","name":"_prot_id"},{"definition":"my","name":"$transcript","containerName":"_parse_genes","localvar":"my","kind":13,"line":268},{"kind":12,"line":269,"name":"new","containerName":"_parse_genes"},{"kind":13,"line":269,"containerName":"_parse_genes","name":"$source_tag"},{"name":"$score","containerName":"_parse_genes","kind":13,"line":270},{"name":"$g_start","containerName":"_parse_genes","kind":13,"line":271},{"name":"$g_end","containerName":"_parse_genes","line":271,"kind":13},{"name":"$g_strand","containerName":"_parse_genes","line":271,"kind":13},{"line":271,"kind":13,"containerName":"_parse_genes","name":"$self"},{"name":"_get_strand","containerName":"_parse_genes","line":271,"kind":12},{"kind":13,"line":271,"containerName":"_parse_genes","name":"$g_start"},{"kind":13,"line":271,"name":"$g_end","containerName":"_parse_genes"},{"name":"$genes","containerName":"_parse_genes","line":272,"kind":13},{"line":272,"kind":12,"containerName":"_parse_genes","name":"strand"},{"kind":13,"line":272,"containerName":"_parse_genes","name":"$g_strand"},{"line":275,"kind":13,"localvar":"my","containerName":"_parse_genes","name":"@exons","definition":"my"},{"containerName":"_parse_genes","name":"@exons","line":276,"kind":13},{"name":"$gene_txt","containerName":"_parse_genes","line":276,"kind":13},{"containerName":"_parse_genes","name":"@exons","kind":13,"line":277},{"containerName":"_parse_genes","name":"$gene_txt","line":277,"kind":13},{"containerName":"_parse_genes","name":"$nbr","definition":"my","localvar":"my","kind":13,"line":279},{"name":"$e","definition":"my","containerName":"_parse_genes","localvar":"my","kind":13,"line":282},{"containerName":"_parse_genes","name":"@exons","line":282,"kind":13},{"name":"$e_start","definition":"my","containerName":"_parse_genes","localvar":"my","kind":13,"line":283},{"line":283,"kind":13,"containerName":"_parse_genes","name":"$e_end"},{"kind":13,"line":283,"containerName":"_parse_genes","name":"$phase"},{"containerName":"_parse_genes","name":"$e","kind":13,"line":284},{"localvar":"my","containerName":"_parse_genes","name":"$e_strand","definition":"my","line":289,"kind":13},{"kind":13,"line":290,"name":"$e_start","containerName":"_parse_genes"},{"name":"$e_end","containerName":"_parse_genes","kind":13,"line":290},{"kind":13,"line":290,"name":"$e_strand","containerName":"_parse_genes"},{"line":290,"kind":13,"containerName":"_parse_genes","name":"$self"},{"line":290,"kind":12,"name":"_get_strand","containerName":"_parse_genes"},{"name":"$e_start","containerName":"_parse_genes","line":290,"kind":13},{"kind":13,"line":291,"containerName":"_parse_genes","name":"$e_end"},{"containerName":"_parse_genes","name":"$transcript","line":292,"kind":13},{"kind":12,"line":292,"name":"strand","containerName":"_parse_genes"},{"line":292,"kind":13,"name":"$e_strand","containerName":"_parse_genes"},{"name":"$transcript","containerName":"_parse_genes","line":292,"kind":13},{"line":292,"kind":12,"containerName":"_parse_genes","name":"strand"},{"kind":13,"line":293,"name":"$exon","definition":"my","containerName":"_parse_genes","localvar":"my"},{"containerName":"_parse_genes","name":"new","line":294,"kind":12},{"kind":13,"line":294,"name":"$self","containerName":"_parse_genes"},{"containerName":"_parse_genes","name":"_target_id","kind":12,"line":294},{"line":295,"kind":13,"containerName":"_parse_genes","name":"$source_tag"},{"kind":13,"line":296,"containerName":"_parse_genes","name":"$e_start"},{"containerName":"_parse_genes","name":"$e_end","line":297,"kind":13},{"kind":13,"line":298,"name":"$score","containerName":"_parse_genes"},{"kind":13,"line":300,"containerName":"_parse_genes","name":"$e_strand"},{"name":"$exon","containerName":"_parse_genes","kind":13,"line":302},{"containerName":"_parse_genes","name":"add_tag_value","line":302,"kind":12},{"line":302,"kind":13,"containerName":"_parse_genes","name":"$phase"},{"line":303,"kind":13,"name":"$exon","containerName":"_parse_genes"},{"kind":12,"line":303,"name":"is_coding","containerName":"_parse_genes"},{"kind":13,"line":304,"containerName":"_parse_genes","name":"$self"},{"containerName":"_parse_genes","name":"_prot_id","line":304,"kind":12},{"line":305,"kind":13,"containerName":"_parse_genes","name":"$exon"},{"kind":12,"line":305,"containerName":"_parse_genes","name":"add_tag_value"},{"containerName":"_parse_genes","name":"$self","kind":13,"line":305},{"line":305,"kind":12,"name":"_prot_id","containerName":"_parse_genes"},{"name":"$exon","containerName":"_parse_genes","kind":13,"line":307},{"kind":12,"line":307,"containerName":"_parse_genes","name":"add_tag_value"},{"line":307,"kind":13,"containerName":"_parse_genes","name":"$nbr"},{"line":308,"kind":13,"containerName":"_parse_genes","name":"$e"},{"line":309,"kind":13,"localvar":"my","name":"$geno_start","definition":"my","containerName":"_parse_genes"},{"containerName":"_parse_genes","name":"$geno_end","kind":13,"line":309},{"line":310,"kind":13,"containerName":"_parse_genes","name":"$prot_start"},{"name":"$prot_end","containerName":"_parse_genes","kind":13,"line":310},{"name":"$prot_strand","definition":"my","containerName":"_parse_genes","localvar":"my","kind":13,"line":311},{"containerName":"_parse_genes","name":"$prot_start","kind":13,"line":312},{"containerName":"_parse_genes","name":"$prot_end","line":312,"kind":13},{"kind":13,"line":313,"containerName":"_parse_genes","name":"$prot_strand"},{"name":"$self","containerName":"_parse_genes","kind":13,"line":313},{"kind":12,"line":313,"name":"_get_strand","containerName":"_parse_genes"},{"containerName":"_parse_genes","name":"$prot_start","kind":13,"line":313},{"kind":13,"line":313,"name":"$prot_end","containerName":"_parse_genes"},{"containerName":"_parse_genes","definition":"my","name":"$pf","localvar":"my","kind":13,"line":314},{"containerName":"_parse_genes","name":"new","line":315,"kind":12},{"name":"$prot_start","containerName":"_parse_genes","line":315,"kind":13},{"name":"$prot_end","containerName":"_parse_genes","kind":13,"line":316},{"containerName":"_parse_genes","name":"$self","kind":13,"line":317},{"containerName":"_parse_genes","name":"_prot_id","kind":12,"line":317},{"line":318,"kind":13,"name":"$score","containerName":"_parse_genes"},{"kind":13,"line":319,"containerName":"_parse_genes","name":"$prot_strand"},{"name":"$source_tag","containerName":"_parse_genes","kind":13,"line":320},{"containerName":"_parse_genes","definition":"my","name":"$geno_strand","localvar":"my","kind":13,"line":322},{"line":323,"kind":13,"containerName":"_parse_genes","name":"$geno_start"},{"line":323,"kind":13,"containerName":"_parse_genes","name":"$geno_end"},{"kind":13,"line":324,"containerName":"_parse_genes","name":"$geno_strand"},{"kind":13,"line":324,"containerName":"_parse_genes","name":"$self"},{"containerName":"_parse_genes","name":"_get_strand","kind":12,"line":324},{"name":"$geno_start","containerName":"_parse_genes","line":324,"kind":13},{"kind":13,"line":324,"name":"$geno_end","containerName":"_parse_genes"},{"localvar":"my","name":"$gf","definition":"my","containerName":"_parse_genes","line":325,"kind":13},{"containerName":"_parse_genes","name":"new","kind":12,"line":325},{"name":"$geno_start","containerName":"_parse_genes","line":326,"kind":13},{"kind":13,"line":327,"containerName":"_parse_genes","name":"$geno_end"},{"name":"$self","containerName":"_parse_genes","line":328,"kind":13},{"kind":12,"line":328,"name":"_target_id","containerName":"_parse_genes"},{"containerName":"_parse_genes","name":"$score","kind":13,"line":329},{"name":"$geno_strand","containerName":"_parse_genes","line":330,"kind":13},{"name":"$source_tag","containerName":"_parse_genes","kind":13,"line":331},{"kind":13,"line":333,"containerName":"_parse_genes","name":"$fp","definition":"my","localvar":"my"},{"kind":12,"line":334,"containerName":"_parse_genes","name":"new"},{"name":"$gf","containerName":"_parse_genes","line":334,"kind":13},{"line":335,"kind":13,"containerName":"_parse_genes","name":"$pf"},{"kind":13,"line":336,"name":"$exon","containerName":"_parse_genes"},{"name":"add_tag_value","containerName":"_parse_genes","line":336,"kind":12},{"containerName":"_parse_genes","name":"$fp","line":336,"kind":13},{"containerName":"_parse_genes","name":"$self","line":337,"kind":13},{"kind":12,"line":337,"name":"_prot_id","containerName":"_parse_genes"},{"containerName":"_parse_genes","name":"$exon","kind":13,"line":338},{"name":"add_tag_value","containerName":"_parse_genes","line":338,"kind":12},{"name":"$self","containerName":"_parse_genes","kind":13,"line":338},{"kind":12,"line":338,"name":"_prot_id","containerName":"_parse_genes"},{"kind":13,"line":339,"name":"$exon","containerName":"_parse_genes"},{"containerName":"_parse_genes","name":"add_tag_value","kind":12,"line":339},{"kind":13,"line":339,"containerName":"_parse_genes","name":"$prot_start"},{"name":"$exon","containerName":"_parse_genes","kind":13,"line":340},{"line":340,"kind":12,"containerName":"_parse_genes","name":"add_tag_value"},{"kind":13,"line":340,"containerName":"_parse_genes","name":"$prot_end"},{"containerName":"_parse_genes","name":"$transcript","line":343,"kind":13},{"kind":12,"line":343,"containerName":"_parse_genes","name":"add_exon"},{"line":343,"kind":13,"containerName":"_parse_genes","name":"$exon"},{"containerName":"_parse_genes","name":"$transcript","kind":13,"line":345},{"kind":12,"line":345,"containerName":"_parse_genes","name":"seq_id"},{"name":"$self","containerName":"_parse_genes","line":345,"kind":13},{"name":"_target_id","containerName":"_parse_genes","kind":12,"line":345},{"kind":13,"line":346,"containerName":"_parse_genes","name":"$transcript"},{"line":346,"kind":12,"name":"add_tag_value","containerName":"_parse_genes"},{"line":346,"kind":13,"name":"$self","containerName":"_parse_genes"},{"line":346,"kind":12,"name":"_prot_id","containerName":"_parse_genes"},{"containerName":"_parse_genes","name":"$transcript","line":347,"kind":13},{"kind":12,"line":347,"containerName":"_parse_genes","name":"add_tag_value"},{"kind":13,"line":347,"containerName":"_parse_genes","name":"$self"},{"containerName":"_parse_genes","name":"_prot_id","kind":12,"line":347},{"line":348,"kind":13,"name":"$genes","containerName":"_parse_genes"},{"kind":12,"line":348,"containerName":"_parse_genes","name":"add_transcript"},{"kind":13,"line":348,"name":"$transcript","containerName":"_parse_genes"},{"kind":13,"line":349,"name":"$genes","containerName":"_parse_genes"},{"kind":12,"line":349,"containerName":"_parse_genes","name":"seq_id"},{"name":"$self","containerName":"_parse_genes","line":349,"kind":13},{"name":"_target_id","containerName":"_parse_genes","line":349,"kind":12},{"line":350,"kind":13,"name":"@genes","containerName":"_parse_genes"},{"line":350,"kind":13,"containerName":"_parse_genes","name":"$genes"},{"kind":13,"line":351,"name":"$gene_num","containerName":"_parse_genes"},{"line":354,"kind":13,"name":"$self","containerName":"_parse_genes"},{"containerName":"_parse_genes","name":"@genes","line":354,"kind":13}],"kind":12,"detail":"($self)","signature":{"parameters":[{"label":"$self"}],"documentation":"","label":"_parse_genes($self)"},"containerName":"main::","definition":"sub"},{"line":263,"kind":12,"name":"Bio","containerName":"SeqFeature::Gene::GeneStructure"},{"name":"Bio","containerName":"SeqFeature::Gene::Transcript","line":268,"kind":12},{"kind":12,"line":293,"containerName":"SeqFeature::Gene::Exon","name":"Bio"},{"line":314,"kind":12,"name":"Bio","containerName":"SeqFeature::Generic"},{"containerName":"SeqFeature::Generic","name":"Bio","line":325,"kind":12},{"name":"Bio","containerName":"SeqFeature::FeaturePair","line":333,"kind":12}]}