{"vars":[{"name":"vars","containerName":"","kind":2,"line":147},{"containerName":"","name":"base","line":154,"kind":2},{"kind":13,"line":156,"definition":"my","name":"$i","containerName":null,"localvar":"my"},{"kind":13,"line":157,"definition":"my","name":"%GFF3_ID_Tags","containerName":null,"localvar":"my"},{"name":"%i","containerName":null,"kind":13,"line":157},{"containerName":null,"definition":"my","name":"$gff3_featureID","localvar":"my","kind":13,"line":180},{"signature":{"label":"_incrementGFF3ID($self)","parameters":[{"label":"$self"}],"documentation":""},"detail":"($self)","definition":"sub","containerName":"main::","children":[{"containerName":"_incrementGFF3ID","name":"$self","definition":"my","localvar":"my","kind":13,"line":183},{"line":184,"kind":13,"name":"$gff3_featureID","containerName":"_incrementGFF3ID"}],"line":182,"kind":12,"range":{"start":{"line":182,"character":0},"end":{"line":185,"character":9999}},"name":"_incrementGFF3ID"},{"range":{"start":{"character":0,"line":189},"end":{"character":9999,"line":206}},"name":"new","line":189,"children":[{"line":190,"kind":13,"localvar":"my","name":"$class","definition":"my","containerName":"new"},{"kind":13,"line":190,"name":"@args","containerName":"new"},{"line":191,"kind":13,"localvar":"my","containerName":"new","name":"$self","definition":"my"},{"name":"$class","containerName":"new","line":191,"kind":13},{"name":"@args","containerName":"new","kind":13,"line":191},{"localvar":"my","containerName":"new","definition":"my","name":"$gff_version","line":193,"kind":13},{"line":193,"kind":13,"name":"$noparse","containerName":"new"},{"containerName":"new","name":"$self","kind":13,"line":193},{"kind":12,"line":193,"containerName":"new","name":"_rearrange"},{"containerName":"new","name":"@args","kind":13,"line":193},{"line":196,"kind":13,"containerName":"new","name":"$self"},{"name":"_initialize_io","containerName":"new","kind":12,"line":196},{"kind":13,"line":196,"containerName":"new","name":"@args"},{"containerName":"new","name":"$self","kind":13,"line":197},{"name":"_parse_header","containerName":"new","kind":12,"line":197},{"containerName":"new","name":"$noparse","kind":13,"line":197},{"kind":13,"line":199,"containerName":"new","name":"$gff_version"},{"kind":13,"line":200,"containerName":"new","name":"$self"},{"name":"gff_version","containerName":"new","line":200,"kind":12},{"line":200,"kind":13,"containerName":"new","name":"$gff_version"},{"kind":13,"line":201,"name":"$self","containerName":"new"},{"line":201,"kind":12,"containerName":"new","name":"throw"},{"containerName":"new","name":"$gff_version","kind":13,"line":202},{"containerName":"new","name":"$self","line":204,"kind":13},{"name":"$self","containerName":"new","kind":13,"line":205}],"kind":12,"detail":"($class,@args)","signature":{"label":"new($class,@args)","parameters":[{"label":"$class"},{"label":"@args"}],"documentation":""},"containerName":"main::","definition":"sub"},{"name":"SUPER","containerName":"new","line":191,"kind":12},{"name":"_parse_header","range":{"start":{"line":221,"character":0},"end":{"character":9999,"line":277}},"kind":12,"children":[{"kind":13,"line":222,"containerName":"_parse_header","name":"$self","definition":"my","localvar":"my"},{"localvar":"my","definition":"my","name":"@unhandled","containerName":"_parse_header","line":224,"kind":13},{"localvar":"my","containerName":"_parse_header","name":"$line","definition":"my","line":228,"kind":13},{"name":"$self","containerName":"_parse_header","kind":13,"line":228},{"name":"_readline","containerName":"_parse_header","line":228,"kind":12},{"line":229,"kind":13,"localvar":"my","containerName":"_parse_header","name":"$handled","definition":"my"},{"line":231,"kind":13,"name":"$line","containerName":"_parse_header"},{"kind":13,"line":232,"name":"$seqid","definition":"my","containerName":"_parse_header","localvar":"my"},{"kind":13,"line":232,"name":"$start","containerName":"_parse_header"},{"kind":13,"line":232,"name":"$end","containerName":"_parse_header"},{"line":233,"kind":13,"name":"$self","containerName":"_parse_header"},{"containerName":"_parse_header","name":"new","kind":12,"line":234},{"kind":13,"line":235,"containerName":"_parse_header","name":"$seqid"},{"name":"$start","containerName":"_parse_header","kind":13,"line":236},{"line":237,"kind":13,"containerName":"_parse_header","name":"$end"},{"kind":13,"line":238,"containerName":"_parse_header","name":"$end"},{"line":238,"kind":13,"containerName":"_parse_header","name":"$start"},{"kind":13,"line":240,"containerName":"_parse_header","name":"$handled"},{"containerName":"_parse_header","name":"$line","line":241,"kind":13},{"containerName":"_parse_header","name":"$self","line":243,"kind":13},{"containerName":"_parse_header","name":"warn","line":243,"kind":12},{"name":"$line","containerName":"_parse_header","line":244,"kind":13},{"name":"$self","containerName":"_parse_header","kind":13,"line":246},{"containerName":"_parse_header","name":"warn","kind":12,"line":246},{"name":"$line","containerName":"_parse_header","kind":13,"line":247},{"name":"$self","containerName":"_parse_header","line":249,"kind":13},{"containerName":"_parse_header","name":"warn","kind":12,"line":249},{"containerName":"_parse_header","name":"$line","line":250,"kind":13},{"line":252,"kind":13,"name":"$self","containerName":"_parse_header"},{"name":"warn","containerName":"_parse_header","kind":12,"line":252},{"containerName":"_parse_header","name":"$line","line":253,"kind":13},{"kind":13,"line":255,"containerName":"_parse_header","name":"$line"},{"line":255,"kind":13,"containerName":"_parse_header","name":"$self"},{"kind":12,"line":255,"containerName":"_parse_header","name":"_readline"},{"name":"$line","containerName":"_parse_header","line":256,"kind":13},{"kind":13,"line":257,"name":"$self","containerName":"_parse_header"},{"kind":12,"line":257,"name":"throw","containerName":"_parse_header"},{"line":262,"kind":13,"name":"$line","containerName":"_parse_header"},{"name":"$seq","definition":"my","containerName":"_parse_header","localvar":"my","kind":13,"line":264},{"line":264,"kind":13,"containerName":"_parse_header","name":"$self"},{"line":264,"kind":12,"containerName":"_parse_header","name":"_parse_sequence"},{"line":264,"kind":13,"name":"$line","containerName":"_parse_header"},{"kind":13,"line":265,"name":"$seq","containerName":"_parse_header"},{"kind":13,"line":266,"name":"$self","containerName":"_parse_header"},{"name":"_seq_by_id_h","containerName":"_parse_header","line":266,"kind":12},{"name":"$seq","containerName":"_parse_header","line":266,"kind":13},{"kind":12,"line":266,"name":"primary_id","containerName":"_parse_header"},{"line":266,"kind":13,"name":"$seq","containerName":"_parse_header"},{"line":271,"kind":13,"name":"$handled","containerName":"_parse_header"},{"kind":13,"line":272,"containerName":"_parse_header","name":"@unhandled"},{"containerName":"_parse_header","name":"$line","kind":13,"line":273},{"line":276,"kind":13,"name":"$line","containerName":"_parse_header"}],"line":221,"definition":"sub","containerName":"main::","signature":{"label":"_parse_header($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: GFF.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::GFF\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by the Bioperl core team\n#\n# Copyright Matthew Pocock\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::GFF - A Bio::SeqAnalysisParserI compliant GFF format parser\n\n=head1 SYNOPSIS\n\n    use Bio::Tools::GFF;\n\n    # specify input via -fh or -file\n    my $gffio = Bio::Tools::GFF->new(-fh => \\*STDIN, -gff_version => 2);\n    my $feature;\n    # loop over the input stream\n    while($feature = $gffio->next_feature()) {\n        # do something with feature\n    }\n    $gffio->close();\n\n    # you can also obtain a GFF parser as a SeqAnalasisParserI in\n    # HT analysis pipelines (see Bio::SeqAnalysisParserI and\n    # Bio::Factory::SeqAnalysisParserFactory)\n    my $factory = Bio::Factory::SeqAnalysisParserFactory->new();\n    my $parser = $factory->get_parser(-input => \\*STDIN, -method => \"gff\");\n    while($feature = $parser->next_feature()) {\n        # do something with feature\n    }\n\n=head1 DESCRIPTION\n\nThis class provides a simple GFF parser and writer. In the sense of a\nSeqAnalysisParser, it parses an input file or stream into SeqFeatureI\nobjects, but is not in any way specific to a particular analysis\nprogram and the output that program produces.\n\nThat is, if you can get your analysis program spit out GFF, here is\nyour result parser.\n\n=head1 GFF3 AND SEQUENCE DATA\n\nGFF3 supports sequence data; see\n\nhttp://www.sequenceontology.org/gff3.shtml\n\nThere are a number of ways to deal with this -\n\nIf you call\n\n  $gffio->ignore_sequence(1)\n\nprior to parsing the sequence data is ignored; this is useful if you\njust want the features. It avoids the memory overhead in building and\ncaching sequences\n\nAlternatively, you can call either\n\n  $gffio->get_seqs()\n\nOr\n\n  $gffio->seq_id_by_h()\n\nAt the B<end> of parsing to get either a list or hashref of Bio::Seq\nobjects (see the documentation for each of these methods)\n\nNote that these objects will not have the features attached - you have\nto do this yourself, OR call\n\n  $gffio->features_attached_to_seqs(1)\n\nPRIOR to parsing; this will ensure that the Seqs have the features\nattached; ie you will then be able to call\n\n  $seq->get_SeqFeatures();\n\nAnd use Bio::SeqIO methods\n\nNote that auto-attaching the features to seqs will incur a higher\nmemory overhead as the features must be cached until the sequence data\nis found\n\n=head1 TODO\n\nMake a Bio::SeqIO class specifically for GFF3 with sequence data\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Matthew Pocock\n\nEmail mrp-at-sanger.ac.uk\n\n=head1 CONTRIBUTORS \n\nJason Stajich, jason-at-biperl-dot-org\nChris Mungall, cjm-at-fruitfly-dot-org\nSteffen Grossmann [SG], grossman at molgen.mpg.de\nMalcolm Cook, mec-at-stowers-institute.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tools::GFF;\n\nuse vars qw($HAS_HTML_ENTITIES);\nuse strict;\n\nuse Bio::Seq::SeqFactory;\nuse Bio::LocatableSeq;\nuse Bio::SeqFeature::Generic;\n\nuse base qw(Bio::Root::Root Bio::SeqAnalysisParserI Bio::Root::IO);\n\nmy $i = 0;\nmy %GFF3_ID_Tags = map { $_ => $i++ } qw(ID Parent Target);\n\n=head2 new\n\n Title   : new\n Usage   : my $parser = Bio::Tools::GFF->new(-gff_version => 2,\n\t\t\t\t\t    -file        => \"filename.gff\");\n           or\n           my $writer = Bio::Tools::GFF->new(-gff_version => 3,\n\t\t\t\t\t    -file        => \">filename.gff3\");\n Function: Creates a new instance. Recognized named parameters are -file, -fh,\n           and -gff_version.\n Returns : a new object\n Args    : named parameters\n           -gff_version => [1,2,3]\n\n\n\n{   # make a class variable such that we can generate unique ID's over\n    # a session, no matter how many instances of GFF.pm we make\n    # since these have to be unique within the scope of a GFF file.\n    \n    my $gff3_featureID = 0;\n    \n    sub _incrementGFF3ID {\n        my ($self) = @_;\n        return ++ $gff3_featureID;\n    }\n}\n\n\nsub new {\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n  \n  my ($gff_version, $noparse) = $self->_rearrange([qw(GFF_VERSION NOPARSE)],@args);\n\n  # initialize IO\n  $self->_initialize_io(@args);\n  $self->_parse_header() unless $noparse;\n\n  $gff_version ||= 2;\n  if( ! $self->gff_version($gff_version) )  {\n      $self->throw(\"Can't build a GFF object with the unknown version \".\n\t\t   $gff_version);\n  }\n  $self->{'_first'} = 1;\n  return $self;\n}\n\n=head2 _parse_header\n\n Title   : _parse_header\n Usage   : $gffio->_parse_header()\n Function: used to turn parse GFF header lines.  currently\n           produces Bio::LocatableSeq objects from ##sequence-region\n           lines\n Returns : 1 on success\n Args    : none"},"detail":"($self)"},{"kind":12,"line":233,"containerName":"LocatableSeq","name":"Bio"},{"name":"unescape","line":235,"kind":12},{"line":279,"kind":13,"localvar":"my","containerName":null,"definition":"my","name":"$line"},{"line":279,"kind":13,"name":"@unhandled","containerName":null},{"containerName":null,"name":"$self","line":280,"kind":13},{"containerName":"main::","name":"_pushback","line":280,"kind":12},{"kind":13,"line":280,"containerName":null,"name":"$line"},{"definition":"sub","containerName":"main::","signature":{"label":"_parse_sequence($self,$line)","documentation":"","parameters":[{"label":"$self"},{"label":"$line"}]},"detail":"($self,$line)","kind":12,"children":[{"definition":"my","name":"$self","containerName":"_parse_sequence","localvar":"my","kind":13,"line":287},{"line":287,"kind":13,"name":"$line","containerName":"_parse_sequence"},{"line":289,"kind":13,"name":"$line","containerName":"_parse_sequence"},{"localvar":"my","definition":"my","name":"$seqid","containerName":"_parse_sequence","line":291,"kind":13},{"containerName":"_parse_sequence","name":"$seqid","line":292,"kind":13},{"localvar":"my","containerName":"_parse_sequence","definition":"my","name":"$desc","line":293,"kind":13},{"kind":13,"line":294,"name":"$seqid","containerName":"_parse_sequence"},{"containerName":"_parse_sequence","name":"$seqid","kind":13,"line":295},{"kind":13,"line":295,"name":"$desc","containerName":"_parse_sequence"},{"localvar":"my","definition":"my","name":"$res","containerName":"_parse_sequence","line":297,"kind":13},{"localvar":"my","containerName":"_parse_sequence","name":"$line","definition":"my","line":298,"kind":13},{"kind":13,"line":298,"name":"$self","containerName":"_parse_sequence"},{"line":298,"kind":12,"name":"_readline","containerName":"_parse_sequence"},{"kind":13,"line":299,"name":"$line","containerName":"_parse_sequence"},{"name":"$line","containerName":"_parse_sequence","kind":13,"line":302},{"name":"$self","containerName":"_parse_sequence","line":303,"kind":13},{"name":"_pushback","containerName":"_parse_sequence","kind":12,"line":303},{"line":303,"kind":13,"containerName":"_parse_sequence","name":"$line"},{"name":"$line","containerName":"_parse_sequence","kind":13,"line":306},{"containerName":"_parse_sequence","name":"$res","kind":13,"line":307},{"line":307,"kind":13,"name":"$line","containerName":"_parse_sequence"},{"line":309,"kind":13,"containerName":"_parse_sequence","name":"$self"},{"line":309,"kind":12,"containerName":"_parse_sequence","name":"ignore_sequence"},{"kind":13,"line":311,"containerName":"_parse_sequence","definition":"my","name":"$seqfactory","localvar":"my"},{"line":311,"kind":12,"name":"new","containerName":"_parse_sequence"},{"line":312,"kind":13,"localvar":"my","containerName":"_parse_sequence","name":"$seq","definition":"my"},{"containerName":"_parse_sequence","name":"$seqfactory","kind":13,"line":312},{"line":312,"kind":12,"containerName":"_parse_sequence","name":"create"},{"containerName":"_parse_sequence","name":"$res","line":312,"kind":13},{"line":313,"kind":13,"containerName":"_parse_sequence","name":"$seqid"},{"name":"$desc","containerName":"_parse_sequence","line":314,"kind":13},{"name":"$seq","containerName":"_parse_sequence","line":315,"kind":13},{"kind":12,"line":315,"name":"accession_number","containerName":"_parse_sequence"},{"containerName":"_parse_sequence","name":"$seqid","kind":13,"line":315},{"name":"$self","containerName":"_parse_sequence","kind":13,"line":316},{"kind":12,"line":316,"containerName":"_parse_sequence","name":"features_attached_to_seqs"},{"line":317,"kind":13,"localvar":"my","name":"@feats","definition":"my","containerName":"_parse_sequence"},{"kind":13,"line":318,"containerName":"_parse_sequence","name":"$self"},{"line":318,"kind":12,"name":"_feature_idx_by_seq_id","containerName":"_parse_sequence"},{"name":"$seqid","containerName":"_parse_sequence","line":318,"kind":13},{"containerName":"_parse_sequence","name":"$seq","line":319,"kind":13},{"name":"add_SeqFeature","containerName":"_parse_sequence","line":319,"kind":12},{"containerName":"_parse_sequence","name":"@feats","line":319,"kind":13},{"line":320,"kind":13,"containerName":"_parse_sequence","name":"$self"},{"containerName":"_parse_sequence","name":"_feature_idx_by_seq_id","kind":12,"line":320},{"line":320,"kind":13,"name":"$seqid","containerName":"_parse_sequence"}],"line":286,"name":"_parse_sequence","range":{"end":{"character":9999,"line":321},"start":{"character":0,"line":286}}},{"name":"Bio","containerName":"Seq::SeqFactory","line":311,"kind":12},{"name":"%seq","containerName":null,"kind":13,"line":322},{"kind":13,"line":325,"name":"$self","containerName":null},{"line":325,"kind":12,"name":"throw","containerName":"main::"},{"name":"next_segment","range":{"start":{"character":0,"line":344},"end":{"line":346,"character":9999}},"kind":12,"line":344,"children":[{"kind":13,"line":345,"containerName":"next_segment","name":"$self","definition":"my","localvar":"my"},{"name":"@args","containerName":"next_segment","line":345,"kind":13},{"line":346,"kind":13,"name":"$self","containerName":"next_segment"}],"containerName":"main::","definition":"sub","detail":"($self,@args)","signature":{"label":"next_segment($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: GFF.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::GFF\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by the Bioperl core team\n#\n# Copyright Matthew Pocock\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::GFF - A Bio::SeqAnalysisParserI compliant GFF format parser\n\n=head1 SYNOPSIS\n\n    use Bio::Tools::GFF;\n\n    # specify input via -fh or -file\n    my $gffio = Bio::Tools::GFF->new(-fh => \\*STDIN, -gff_version => 2);\n    my $feature;\n    # loop over the input stream\n    while($feature = $gffio->next_feature()) {\n        # do something with feature\n    }\n    $gffio->close();\n\n    # you can also obtain a GFF parser as a SeqAnalasisParserI in\n    # HT analysis pipelines (see Bio::SeqAnalysisParserI and\n    # Bio::Factory::SeqAnalysisParserFactory)\n    my $factory = Bio::Factory::SeqAnalysisParserFactory->new();\n    my $parser = $factory->get_parser(-input => \\*STDIN, -method => \"gff\");\n    while($feature = $parser->next_feature()) {\n        # do something with feature\n    }\n\n=head1 DESCRIPTION\n\nThis class provides a simple GFF parser and writer. In the sense of a\nSeqAnalysisParser, it parses an input file or stream into SeqFeatureI\nobjects, but is not in any way specific to a particular analysis\nprogram and the output that program produces.\n\nThat is, if you can get your analysis program spit out GFF, here is\nyour result parser.\n\n=head1 GFF3 AND SEQUENCE DATA\n\nGFF3 supports sequence data; see\n\nhttp://www.sequenceontology.org/gff3.shtml\n\nThere are a number of ways to deal with this -\n\nIf you call\n\n  $gffio->ignore_sequence(1)\n\nprior to parsing the sequence data is ignored; this is useful if you\njust want the features. It avoids the memory overhead in building and\ncaching sequences\n\nAlternatively, you can call either\n\n  $gffio->get_seqs()\n\nOr\n\n  $gffio->seq_id_by_h()\n\nAt the B<end> of parsing to get either a list or hashref of Bio::Seq\nobjects (see the documentation for each of these methods)\n\nNote that these objects will not have the features attached - you have\nto do this yourself, OR call\n\n  $gffio->features_attached_to_seqs(1)\n\nPRIOR to parsing; this will ensure that the Seqs have the features\nattached; ie you will then be able to call\n\n  $seq->get_SeqFeatures();\n\nAnd use Bio::SeqIO methods\n\nNote that auto-attaching the features to seqs will incur a higher\nmemory overhead as the features must be cached until the sequence data\nis found\n\n=head1 TODO\n\nMake a Bio::SeqIO class specifically for GFF3 with sequence data\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Matthew Pocock\n\nEmail mrp-at-sanger.ac.uk\n\n=head1 CONTRIBUTORS \n\nJason Stajich, jason-at-biperl-dot-org\nChris Mungall, cjm-at-fruitfly-dot-org\nSteffen Grossmann [SG], grossman at molgen.mpg.de\nMalcolm Cook, mec-at-stowers-institute.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tools::GFF;\n\nuse vars qw($HAS_HTML_ENTITIES);\nuse strict;\n\nuse Bio::Seq::SeqFactory;\nuse Bio::LocatableSeq;\nuse Bio::SeqFeature::Generic;\n\nuse base qw(Bio::Root::Root Bio::SeqAnalysisParserI Bio::Root::IO);\n\nmy $i = 0;\nmy %GFF3_ID_Tags = map { $_ => $i++ } qw(ID Parent Target);\n\n=head2 new\n\n Title   : new\n Usage   : my $parser = Bio::Tools::GFF->new(-gff_version => 2,\n\t\t\t\t\t    -file        => \"filename.gff\");\n           or\n           my $writer = Bio::Tools::GFF->new(-gff_version => 3,\n\t\t\t\t\t    -file        => \">filename.gff3\");\n Function: Creates a new instance. Recognized named parameters are -file, -fh,\n           and -gff_version.\n Returns : a new object\n Args    : named parameters\n           -gff_version => [1,2,3]\n\n\n\n{   # make a class variable such that we can generate unique ID's over\n    # a session, no matter how many instances of GFF.pm we make\n    # since these have to be unique within the scope of a GFF file.\n    \n    my $gff3_featureID = 0;\n    \n    sub _incrementGFF3ID {\n        my ($self) = @_;\n        return ++ $gff3_featureID;\n    }\n}\n\n\nsub new {\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n  \n  my ($gff_version, $noparse) = $self->_rearrange([qw(GFF_VERSION NOPARSE)],@args);\n\n  # initialize IO\n  $self->_initialize_io(@args);\n  $self->_parse_header() unless $noparse;\n\n  $gff_version ||= 2;\n  if( ! $self->gff_version($gff_version) )  {\n      $self->throw(\"Can't build a GFF object with the unknown version \".\n\t\t   $gff_version);\n  }\n  $self->{'_first'} = 1;\n  return $self;\n}\n\n=head2 _parse_header\n\n Title   : _parse_header\n Usage   : $gffio->_parse_header()\n Function: used to turn parse GFF header lines.  currently\n           produces Bio::LocatableSeq objects from ##sequence-region\n           lines\n Returns : 1 on success\n Args    : none\n\n\n\nsub _parse_header{\n   my ($self) = @_;\n\n   my @unhandled;\n   local $^W = 0; # hide warnings when we try and parse from a file opened\n                  # for writing - there isn't really a better way to do\n                  # AFAIK - cannot detech if a FH is read or write.\n   while(my $line = $self->_readline()){\n \t my $handled = 0;\n\t next if /^\\s+$/;\n\t if($line =~ /^\\#\\#sequence-region\\s+(\\S+)\\s+(\\S+)\\s+(\\S+)\\s*/){\n\t   my($seqid,$start,$end) = ($1,$2,$3);\n\t   push @{ $self->{'segments'} }, Bio::LocatableSeq->new\n\t       (\n\t\t-id    => unescape($seqid),\n\t\t-start => $start,\n\t\t-end   => $end,\n                -length => ($end - $start + 1),  ## make the length explicit\n\t\t);\n\t   $handled = 1;\n\t } elsif($line =~ /^(\\#\\#feature-ontology)/) {\n\t   #to be implemented\n\t   $self->warn(\"$1 header tag parsing unimplemented\");\n\t } elsif($line =~ /^(\\#\\#attribute-ontology)/) {\n\t   #to be implemented\n\t   $self->warn(\"$1 header tag parsing unimplemented\");\n\t } elsif($line =~ /^(\\#\\#source-ontology)/) {\n\t   #to be implemented\n\t   $self->warn(\"$1 header tag parsing unimplemented\");\n\t } elsif($line =~ /^(\\#\\#\\#)/) {\n\t   #to be implemented\n\t   $self->warn(\"$1 header tag parsing unimplemented\");\n\t } elsif($line =~ /^(\\#\\#FASTA)/) {\n            # initial ##FASTA is optional - artemis does not use it\n            $line = $self->_readline();\n            if ($line !~ /^\\>(\\S+)/) {\n                $self->throw(\"##FASTA directive must be followed by fasta header, not: $line\");\n            }\n\t } else {\n         }\n         \n         if ($line =~ /^\\>(.*)/) {\n             # seq data can be at header or footer\n             my $seq = $self->_parse_sequence($line);\n             if ($seq) {\n                 $self->_seq_by_id_h->{$seq->primary_id} = $seq;\n             }\n         }\n             \n\n \t if(!$handled){\n\t   push @unhandled, $line\n \t }\n\n\t #looks like the header is over!\n\t last unless $line =~ /^\\#/;\n   }\n\n   foreach my $line (@unhandled){\n\t $self->_pushback($line);\n   }\n\n   return 1;\n}\n\nsub _parse_sequence {\n    my ($self, $line) = @_;\n\n    if ($line =~ /^\\>(.*)/) {\n        \n        my $seqid = $1;\n        $seqid =~ s/\\s+$//;\n        my $desc = '';\n        if ($seqid =~ /(\\S+)\\s+(.*)/) {\n            ($seqid, $desc) = ($1,$2);\n        }\n        my $res = '';\n        while (my $line = $self->_readline) {\n            if ($line =~ /^\\#/) {\n                last;\n            }\n            if ($line =~ /^\\>/) {\n                $self->_pushback($line);\n                last;\n            }\n            $line =~ s/\\s//g;\n            $res .= $line;\n        }\n        return if $self->ignore_sequence;\n\n        my $seqfactory = Bio::Seq::SeqFactory->new('Bio::Seq');\n        my $seq = $seqfactory->create(-seq=>$res, \n                                      -id=>$seqid,\n                                      -desc=>$desc);\n        $seq->accession_number($seqid);\n        if ($self->features_attached_to_seqs) {\n            my @feats = \n              @{$self->_feature_idx_by_seq_id->{$seqid}};\n            $seq->add_SeqFeature($_) foreach @feats;\n            @{$self->_feature_idx_by_seq_id->{$seqid}} = ();\n        }\n        return $seq;\n    }\n    else {\n        $self->throw(\"expected fasta header, not: $line\");\n    }\n}\n\n\n=head2 next_segment\n\n Title   : next_segment\n Usage   : my $seq = $gffio->next_segment;\n Function: Returns a Bio::LocatableSeq object corresponding to a \n           GFF \"##sequence-region\" header line.\n Example :\n Returns : A Bio::LocatableSeq object, or undef if\n           there are no more sequences.\n Args    : none"}},{"kind":13,"line":346,"containerName":null,"name":"%self"},{"range":{"end":{"character":9999,"line":396},"start":{"character":0,"line":363}},"name":"next_feature","detail":"($self)","signature":{"label":"next_feature($self)","documentation":"1;\n# $Id: GFF.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::GFF\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by the Bioperl core team\n#\n# Copyright Matthew Pocock\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::GFF - A Bio::SeqAnalysisParserI compliant GFF format parser\n\n=head1 SYNOPSIS\n\n    use Bio::Tools::GFF;\n\n    # specify input via -fh or -file\n    my $gffio = Bio::Tools::GFF->new(-fh => \\*STDIN, -gff_version => 2);\n    my $feature;\n    # loop over the input stream\n    while($feature = $gffio->next_feature()) {\n        # do something with feature\n    }\n    $gffio->close();\n\n    # you can also obtain a GFF parser as a SeqAnalasisParserI in\n    # HT analysis pipelines (see Bio::SeqAnalysisParserI and\n    # Bio::Factory::SeqAnalysisParserFactory)\n    my $factory = Bio::Factory::SeqAnalysisParserFactory->new();\n    my $parser = $factory->get_parser(-input => \\*STDIN, -method => \"gff\");\n    while($feature = $parser->next_feature()) {\n        # do something with feature\n    }\n\n=head1 DESCRIPTION\n\nThis class provides a simple GFF parser and writer. In the sense of a\nSeqAnalysisParser, it parses an input file or stream into SeqFeatureI\nobjects, but is not in any way specific to a particular analysis\nprogram and the output that program produces.\n\nThat is, if you can get your analysis program spit out GFF, here is\nyour result parser.\n\n=head1 GFF3 AND SEQUENCE DATA\n\nGFF3 supports sequence data; see\n\nhttp://www.sequenceontology.org/gff3.shtml\n\nThere are a number of ways to deal with this -\n\nIf you call\n\n  $gffio->ignore_sequence(1)\n\nprior to parsing the sequence data is ignored; this is useful if you\njust want the features. It avoids the memory overhead in building and\ncaching sequences\n\nAlternatively, you can call either\n\n  $gffio->get_seqs()\n\nOr\n\n  $gffio->seq_id_by_h()\n\nAt the B<end> of parsing to get either a list or hashref of Bio::Seq\nobjects (see the documentation for each of these methods)\n\nNote that these objects will not have the features attached - you have\nto do this yourself, OR call\n\n  $gffio->features_attached_to_seqs(1)\n\nPRIOR to parsing; this will ensure that the Seqs have the features\nattached; ie you will then be able to call\n\n  $seq->get_SeqFeatures();\n\nAnd use Bio::SeqIO methods\n\nNote that auto-attaching the features to seqs will incur a higher\nmemory overhead as the features must be cached until the sequence data\nis found\n\n=head1 TODO\n\nMake a Bio::SeqIO class specifically for GFF3 with sequence data\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Matthew Pocock\n\nEmail mrp-at-sanger.ac.uk\n\n=head1 CONTRIBUTORS \n\nJason Stajich, jason-at-biperl-dot-org\nChris Mungall, cjm-at-fruitfly-dot-org\nSteffen Grossmann [SG], grossman at molgen.mpg.de\nMalcolm Cook, mec-at-stowers-institute.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tools::GFF;\n\nuse vars qw($HAS_HTML_ENTITIES);\nuse strict;\n\nuse Bio::Seq::SeqFactory;\nuse Bio::LocatableSeq;\nuse Bio::SeqFeature::Generic;\n\nuse base qw(Bio::Root::Root Bio::SeqAnalysisParserI Bio::Root::IO);\n\nmy $i = 0;\nmy %GFF3_ID_Tags = map { $_ => $i++ } qw(ID Parent Target);\n\n=head2 new\n\n Title   : new\n Usage   : my $parser = Bio::Tools::GFF->new(-gff_version => 2,\n\t\t\t\t\t    -file        => \"filename.gff\");\n           or\n           my $writer = Bio::Tools::GFF->new(-gff_version => 3,\n\t\t\t\t\t    -file        => \">filename.gff3\");\n Function: Creates a new instance. Recognized named parameters are -file, -fh,\n           and -gff_version.\n Returns : a new object\n Args    : named parameters\n           -gff_version => [1,2,3]\n\n\n\n{   # make a class variable such that we can generate unique ID's over\n    # a session, no matter how many instances of GFF.pm we make\n    # since these have to be unique within the scope of a GFF file.\n    \n    my $gff3_featureID = 0;\n    \n    sub _incrementGFF3ID {\n        my ($self) = @_;\n        return ++ $gff3_featureID;\n    }\n}\n\n\nsub new {\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n  \n  my ($gff_version, $noparse) = $self->_rearrange([qw(GFF_VERSION NOPARSE)],@args);\n\n  # initialize IO\n  $self->_initialize_io(@args);\n  $self->_parse_header() unless $noparse;\n\n  $gff_version ||= 2;\n  if( ! $self->gff_version($gff_version) )  {\n      $self->throw(\"Can't build a GFF object with the unknown version \".\n\t\t   $gff_version);\n  }\n  $self->{'_first'} = 1;\n  return $self;\n}\n\n=head2 _parse_header\n\n Title   : _parse_header\n Usage   : $gffio->_parse_header()\n Function: used to turn parse GFF header lines.  currently\n           produces Bio::LocatableSeq objects from ##sequence-region\n           lines\n Returns : 1 on success\n Args    : none\n\n\n\nsub _parse_header{\n   my ($self) = @_;\n\n   my @unhandled;\n   local $^W = 0; # hide warnings when we try and parse from a file opened\n                  # for writing - there isn't really a better way to do\n                  # AFAIK - cannot detech if a FH is read or write.\n   while(my $line = $self->_readline()){\n \t my $handled = 0;\n\t next if /^\\s+$/;\n\t if($line =~ /^\\#\\#sequence-region\\s+(\\S+)\\s+(\\S+)\\s+(\\S+)\\s*/){\n\t   my($seqid,$start,$end) = ($1,$2,$3);\n\t   push @{ $self->{'segments'} }, Bio::LocatableSeq->new\n\t       (\n\t\t-id    => unescape($seqid),\n\t\t-start => $start,\n\t\t-end   => $end,\n                -length => ($end - $start + 1),  ## make the length explicit\n\t\t);\n\t   $handled = 1;\n\t } elsif($line =~ /^(\\#\\#feature-ontology)/) {\n\t   #to be implemented\n\t   $self->warn(\"$1 header tag parsing unimplemented\");\n\t } elsif($line =~ /^(\\#\\#attribute-ontology)/) {\n\t   #to be implemented\n\t   $self->warn(\"$1 header tag parsing unimplemented\");\n\t } elsif($line =~ /^(\\#\\#source-ontology)/) {\n\t   #to be implemented\n\t   $self->warn(\"$1 header tag parsing unimplemented\");\n\t } elsif($line =~ /^(\\#\\#\\#)/) {\n\t   #to be implemented\n\t   $self->warn(\"$1 header tag parsing unimplemented\");\n\t } elsif($line =~ /^(\\#\\#FASTA)/) {\n            # initial ##FASTA is optional - artemis does not use it\n            $line = $self->_readline();\n            if ($line !~ /^\\>(\\S+)/) {\n                $self->throw(\"##FASTA directive must be followed by fasta header, not: $line\");\n            }\n\t } else {\n         }\n         \n         if ($line =~ /^\\>(.*)/) {\n             # seq data can be at header or footer\n             my $seq = $self->_parse_sequence($line);\n             if ($seq) {\n                 $self->_seq_by_id_h->{$seq->primary_id} = $seq;\n             }\n         }\n             \n\n \t if(!$handled){\n\t   push @unhandled, $line\n \t }\n\n\t #looks like the header is over!\n\t last unless $line =~ /^\\#/;\n   }\n\n   foreach my $line (@unhandled){\n\t $self->_pushback($line);\n   }\n\n   return 1;\n}\n\nsub _parse_sequence {\n    my ($self, $line) = @_;\n\n    if ($line =~ /^\\>(.*)/) {\n        \n        my $seqid = $1;\n        $seqid =~ s/\\s+$//;\n        my $desc = '';\n        if ($seqid =~ /(\\S+)\\s+(.*)/) {\n            ($seqid, $desc) = ($1,$2);\n        }\n        my $res = '';\n        while (my $line = $self->_readline) {\n            if ($line =~ /^\\#/) {\n                last;\n            }\n            if ($line =~ /^\\>/) {\n                $self->_pushback($line);\n                last;\n            }\n            $line =~ s/\\s//g;\n            $res .= $line;\n        }\n        return if $self->ignore_sequence;\n\n        my $seqfactory = Bio::Seq::SeqFactory->new('Bio::Seq');\n        my $seq = $seqfactory->create(-seq=>$res, \n                                      -id=>$seqid,\n                                      -desc=>$desc);\n        $seq->accession_number($seqid);\n        if ($self->features_attached_to_seqs) {\n            my @feats = \n              @{$self->_feature_idx_by_seq_id->{$seqid}};\n            $seq->add_SeqFeature($_) foreach @feats;\n            @{$self->_feature_idx_by_seq_id->{$seqid}} = ();\n        }\n        return $seq;\n    }\n    else {\n        $self->throw(\"expected fasta header, not: $line\");\n    }\n}\n\n\n=head2 next_segment\n\n Title   : next_segment\n Usage   : my $seq = $gffio->next_segment;\n Function: Returns a Bio::LocatableSeq object corresponding to a \n           GFF \"##sequence-region\" header line.\n Example :\n Returns : A Bio::LocatableSeq object, or undef if\n           there are no more sequences.\n Args    : none\n\n\n\nsub next_segment{\n   my ($self,@args) = @_;\n   return shift @{ $self->{'segments'} } if defined $self->{'segments'};\n   return;\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : $seqfeature = $gffio->next_feature();\n Function: Returns the next feature available in the input file or stream, or\n           undef if there are no more features.\n Example :\n Returns : A Bio::SeqFeatureI implementing object, or undef if there are no\n           more features.\n Args    : none    ","parameters":[{"label":"$self"}]},"containerName":"main::","definition":"sub","line":363,"children":[{"name":"$self","definition":"my","containerName":"next_feature","localvar":"my","kind":13,"line":364},{"kind":13,"line":366,"containerName":"next_feature","definition":"my","name":"$gff_string","localvar":"my"},{"containerName":"next_feature","name":"$gff_string","kind":13,"line":370},{"kind":13,"line":370,"containerName":"next_feature","name":"$self"},{"containerName":"next_feature","name":"_readline","line":370,"kind":12},{"kind":13,"line":370,"containerName":"next_feature","name":"$gff_string"},{"kind":13,"line":371,"name":"$gff_string","containerName":"next_feature"},{"line":374,"kind":13,"containerName":"next_feature","name":"$gff_string"},{"line":374,"kind":13,"containerName":"next_feature","name":"$gff_string"},{"name":"$gff_string","containerName":"next_feature","kind":13,"line":375},{"name":"$gff_string","containerName":"next_feature","kind":13,"line":377},{"localvar":"my","containerName":"next_feature","definition":"my","name":"$seq","line":379,"kind":13},{"name":"$self","containerName":"next_feature","line":379,"kind":13},{"line":379,"kind":12,"containerName":"next_feature","name":"_parse_sequence"},{"line":379,"kind":13,"name":"$gff_string","containerName":"next_feature"},{"containerName":"next_feature","name":"$seq","line":380,"kind":13},{"line":381,"kind":13,"containerName":"next_feature","name":"$self"},{"kind":12,"line":381,"containerName":"next_feature","name":"_seq_by_id_h"},{"containerName":"next_feature","name":"$seq","line":381,"kind":13},{"line":381,"kind":12,"containerName":"next_feature","name":"primary_id"},{"kind":13,"line":381,"containerName":"next_feature","name":"$seq"},{"name":"$gff_string","containerName":"next_feature","line":382,"kind":13},{"kind":13,"line":382,"containerName":"next_feature","name":"$self"},{"containerName":"next_feature","name":"_readline","line":382,"kind":12},{"name":"$gff_string","containerName":"next_feature","line":383,"kind":13},{"kind":13,"line":388,"name":"$gff_string","containerName":"next_feature"},{"definition":"my","name":"$feat","containerName":"next_feature","localvar":"my","kind":13,"line":390},{"name":"new","containerName":"next_feature","kind":12,"line":390},{"kind":13,"line":391,"containerName":"next_feature","name":"$self"},{"name":"from_gff_string","containerName":"next_feature","line":391,"kind":12},{"name":"$feat","containerName":"next_feature","kind":13,"line":391},{"line":391,"kind":13,"name":"$gff_string","containerName":"next_feature"},{"name":"$self","containerName":"next_feature","kind":13,"line":393},{"containerName":"next_feature","name":"features_attached_to_seqs","kind":12,"line":393},{"line":394,"kind":13,"containerName":"next_feature","name":"$self"},{"kind":12,"line":394,"containerName":"next_feature","name":"_feature_idx_by_seq_id"},{"line":394,"kind":13,"containerName":"next_feature","name":"$feat"},{"kind":12,"line":394,"containerName":"next_feature","name":"seq_id"},{"line":395,"kind":13,"containerName":"next_feature","name":"$feat"}],"kind":12},{"line":390,"kind":12,"containerName":"SeqFeature::Generic","name":"Bio"},{"name":"$feat","containerName":null,"kind":13,"line":398},{"containerName":"main::","name":"_feature_idx_by_seq_id","definition":"sub","range":{"start":{"character":0,"line":401},"end":{"character":9999,"line":407}},"kind":12,"line":401,"children":[{"kind":13,"line":402,"containerName":"_feature_idx_by_seq_id","definition":"my","name":"$self","localvar":"my"},{"line":403,"kind":13,"containerName":"_feature_idx_by_seq_id","name":"$self"},{"kind":13,"line":404,"containerName":"_feature_idx_by_seq_id","name":"$self"},{"containerName":"_feature_idx_by_seq_id","name":"$self","kind":13,"line":405},{"kind":13,"line":406,"name":"$self","containerName":"_feature_idx_by_seq_id"}]},{"kind":12,"line":403,"name":"__feature_idx_by_seq_id"},{"line":404,"kind":12,"name":"__feature_idx_by_seq_id"},{"name":"__feature_idx_by_seq_id","line":405,"kind":12},{"kind":12,"line":406,"name":"__feature_idx_by_seq_id"},{"signature":{"documentation":"1;\n# $Id: GFF.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::GFF\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by the Bioperl core team\n#\n# Copyright Matthew Pocock\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::GFF - A Bio::SeqAnalysisParserI compliant GFF format parser\n\n=head1 SYNOPSIS\n\n    use Bio::Tools::GFF;\n\n    # specify input via -fh or -file\n    my $gffio = Bio::Tools::GFF->new(-fh => \\*STDIN, -gff_version => 2);\n    my $feature;\n    # loop over the input stream\n    while($feature = $gffio->next_feature()) {\n        # do something with feature\n    }\n    $gffio->close();\n\n    # you can also obtain a GFF parser as a SeqAnalasisParserI in\n    # HT analysis pipelines (see Bio::SeqAnalysisParserI and\n    # Bio::Factory::SeqAnalysisParserFactory)\n    my $factory = Bio::Factory::SeqAnalysisParserFactory->new();\n    my $parser = $factory->get_parser(-input => \\*STDIN, -method => \"gff\");\n    while($feature = $parser->next_feature()) {\n        # do something with feature\n    }\n\n=head1 DESCRIPTION\n\nThis class provides a simple GFF parser and writer. In the sense of a\nSeqAnalysisParser, it parses an input file or stream into SeqFeatureI\nobjects, but is not in any way specific to a particular analysis\nprogram and the output that program produces.\n\nThat is, if you can get your analysis program spit out GFF, here is\nyour result parser.\n\n=head1 GFF3 AND SEQUENCE DATA\n\nGFF3 supports sequence data; see\n\nhttp://www.sequenceontology.org/gff3.shtml\n\nThere are a number of ways to deal with this -\n\nIf you call\n\n  $gffio->ignore_sequence(1)\n\nprior to parsing the sequence data is ignored; this is useful if you\njust want the features. It avoids the memory overhead in building and\ncaching sequences\n\nAlternatively, you can call either\n\n  $gffio->get_seqs()\n\nOr\n\n  $gffio->seq_id_by_h()\n\nAt the B<end> of parsing to get either a list or hashref of Bio::Seq\nobjects (see the documentation for each of these methods)\n\nNote that these objects will not have the features attached - you have\nto do this yourself, OR call\n\n  $gffio->features_attached_to_seqs(1)\n\nPRIOR to parsing; this will ensure that the Seqs have the features\nattached; ie you will then be able to call\n\n  $seq->get_SeqFeatures();\n\nAnd use Bio::SeqIO methods\n\nNote that auto-attaching the features to seqs will incur a higher\nmemory overhead as the features must be cached until the sequence data\nis found\n\n=head1 TODO\n\nMake a Bio::SeqIO class specifically for GFF3 with sequence data\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Matthew Pocock\n\nEmail mrp-at-sanger.ac.uk\n\n=head1 CONTRIBUTORS \n\nJason Stajich, jason-at-biperl-dot-org\nChris Mungall, cjm-at-fruitfly-dot-org\nSteffen Grossmann [SG], grossman at molgen.mpg.de\nMalcolm Cook, mec-at-stowers-institute.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tools::GFF;\n\nuse vars qw($HAS_HTML_ENTITIES);\nuse strict;\n\nuse Bio::Seq::SeqFactory;\nuse Bio::LocatableSeq;\nuse Bio::SeqFeature::Generic;\n\nuse base qw(Bio::Root::Root Bio::SeqAnalysisParserI Bio::Root::IO);\n\nmy $i = 0;\nmy %GFF3_ID_Tags = map { $_ => $i++ } qw(ID Parent Target);\n\n=head2 new\n\n Title   : new\n Usage   : my $parser = Bio::Tools::GFF->new(-gff_version => 2,\n\t\t\t\t\t    -file        => \"filename.gff\");\n           or\n           my $writer = Bio::Tools::GFF->new(-gff_version => 3,\n\t\t\t\t\t    -file        => \">filename.gff3\");\n Function: Creates a new instance. Recognized named parameters are -file, -fh,\n           and -gff_version.\n Returns : a new object\n Args    : named parameters\n           -gff_version => [1,2,3]\n\n\n\n{   # make a class variable such that we can generate unique ID's over\n    # a session, no matter how many instances of GFF.pm we make\n    # since these have to be unique within the scope of a GFF file.\n    \n    my $gff3_featureID = 0;\n    \n    sub _incrementGFF3ID {\n        my ($self) = @_;\n        return ++ $gff3_featureID;\n    }\n}\n\n\nsub new {\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n  \n  my ($gff_version, $noparse) = $self->_rearrange([qw(GFF_VERSION NOPARSE)],@args);\n\n  # initialize IO\n  $self->_initialize_io(@args);\n  $self->_parse_header() unless $noparse;\n\n  $gff_version ||= 2;\n  if( ! $self->gff_version($gff_version) )  {\n      $self->throw(\"Can't build a GFF object with the unknown version \".\n\t\t   $gff_version);\n  }\n  $self->{'_first'} = 1;\n  return $self;\n}\n\n=head2 _parse_header\n\n Title   : _parse_header\n Usage   : $gffio->_parse_header()\n Function: used to turn parse GFF header lines.  currently\n           produces Bio::LocatableSeq objects from ##sequence-region\n           lines\n Returns : 1 on success\n Args    : none\n\n\n\nsub _parse_header{\n   my ($self) = @_;\n\n   my @unhandled;\n   local $^W = 0; # hide warnings when we try and parse from a file opened\n                  # for writing - there isn't really a better way to do\n                  # AFAIK - cannot detech if a FH is read or write.\n   while(my $line = $self->_readline()){\n \t my $handled = 0;\n\t next if /^\\s+$/;\n\t if($line =~ /^\\#\\#sequence-region\\s+(\\S+)\\s+(\\S+)\\s+(\\S+)\\s*/){\n\t   my($seqid,$start,$end) = ($1,$2,$3);\n\t   push @{ $self->{'segments'} }, Bio::LocatableSeq->new\n\t       (\n\t\t-id    => unescape($seqid),\n\t\t-start => $start,\n\t\t-end   => $end,\n                -length => ($end - $start + 1),  ## make the length explicit\n\t\t);\n\t   $handled = 1;\n\t } elsif($line =~ /^(\\#\\#feature-ontology)/) {\n\t   #to be implemented\n\t   $self->warn(\"$1 header tag parsing unimplemented\");\n\t } elsif($line =~ /^(\\#\\#attribute-ontology)/) {\n\t   #to be implemented\n\t   $self->warn(\"$1 header tag parsing unimplemented\");\n\t } elsif($line =~ /^(\\#\\#source-ontology)/) {\n\t   #to be implemented\n\t   $self->warn(\"$1 header tag parsing unimplemented\");\n\t } elsif($line =~ /^(\\#\\#\\#)/) {\n\t   #to be implemented\n\t   $self->warn(\"$1 header tag parsing unimplemented\");\n\t } elsif($line =~ /^(\\#\\#FASTA)/) {\n            # initial ##FASTA is optional - artemis does not use it\n            $line = $self->_readline();\n            if ($line !~ /^\\>(\\S+)/) {\n                $self->throw(\"##FASTA directive must be followed by fasta header, not: $line\");\n            }\n\t } else {\n         }\n         \n         if ($line =~ /^\\>(.*)/) {\n             # seq data can be at header or footer\n             my $seq = $self->_parse_sequence($line);\n             if ($seq) {\n                 $self->_seq_by_id_h->{$seq->primary_id} = $seq;\n             }\n         }\n             \n\n \t if(!$handled){\n\t   push @unhandled, $line\n \t }\n\n\t #looks like the header is over!\n\t last unless $line =~ /^\\#/;\n   }\n\n   foreach my $line (@unhandled){\n\t $self->_pushback($line);\n   }\n\n   return 1;\n}\n\nsub _parse_sequence {\n    my ($self, $line) = @_;\n\n    if ($line =~ /^\\>(.*)/) {\n        \n        my $seqid = $1;\n        $seqid =~ s/\\s+$//;\n        my $desc = '';\n        if ($seqid =~ /(\\S+)\\s+(.*)/) {\n            ($seqid, $desc) = ($1,$2);\n        }\n        my $res = '';\n        while (my $line = $self->_readline) {\n            if ($line =~ /^\\#/) {\n                last;\n            }\n            if ($line =~ /^\\>/) {\n                $self->_pushback($line);\n                last;\n            }\n            $line =~ s/\\s//g;\n            $res .= $line;\n        }\n        return if $self->ignore_sequence;\n\n        my $seqfactory = Bio::Seq::SeqFactory->new('Bio::Seq');\n        my $seq = $seqfactory->create(-seq=>$res, \n                                      -id=>$seqid,\n                                      -desc=>$desc);\n        $seq->accession_number($seqid);\n        if ($self->features_attached_to_seqs) {\n            my @feats = \n              @{$self->_feature_idx_by_seq_id->{$seqid}};\n            $seq->add_SeqFeature($_) foreach @feats;\n            @{$self->_feature_idx_by_seq_id->{$seqid}} = ();\n        }\n        return $seq;\n    }\n    else {\n        $self->throw(\"expected fasta header, not: $line\");\n    }\n}\n\n\n=head2 next_segment\n\n Title   : next_segment\n Usage   : my $seq = $gffio->next_segment;\n Function: Returns a Bio::LocatableSeq object corresponding to a \n           GFF \"##sequence-region\" header line.\n Example :\n Returns : A Bio::LocatableSeq object, or undef if\n           there are no more sequences.\n Args    : none\n\n\n\nsub next_segment{\n   my ($self,@args) = @_;\n   return shift @{ $self->{'segments'} } if defined $self->{'segments'};\n   return;\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : $seqfeature = $gffio->next_feature();\n Function: Returns the next feature available in the input file or stream, or\n           undef if there are no more features.\n Example :\n Returns : A Bio::SeqFeatureI implementing object, or undef if there are no\n           more features.\n Args    : none    \n\n\nsub next_feature {\n    my ($self) = @_;\n    \n    my $gff_string;\n    \n    # be graceful about empty lines or comments, and make sure we return undef\n    # if the input's consumed\n    while(($gff_string = $self->_readline()) && defined($gff_string)) {\t\n        if ($gff_string =~ /^\\#\\#\\#/) {\n            # all forward refs have been seen; TODO\n        }\n        next if($gff_string =~ /^\\#/ || $gff_string =~ /^\\s*$/ ||\n                $gff_string =~ m{^//});\n\n        while ($gff_string =~ /^\\>(.+)/) {\n            # fasta can be in header or footer\n            my $seq = $self->_parse_sequence($gff_string);\n            if ($seq) {\n                $self->_seq_by_id_h->{$seq->primary_id} = $seq;\n                $gff_string = $self->_readline;\n                last unless $gff_string;\n            }\n        }\n        last; \n    }\n    return unless $gff_string;\n\n    my $feat = Bio::SeqFeature::Generic->new();\n    $self->from_gff_string($feat, $gff_string);\n\n    if ($self->features_attached_to_seqs) {\n        push(@{$self->_feature_idx_by_seq_id->{$feat->seq_id}},\n             $feat);\n    }\n\n    return $feat;\n}\n\nsub _feature_idx_by_seq_id {\n    my $self = shift;\n    $self->{__feature_idx_by_seq_id} = shift if @_;\n    $self->{__feature_idx_by_seq_id} = {}\n      unless $self->{__feature_idx_by_seq_id};\n    return $self->{__feature_idx_by_seq_id};\n}\n\n\n=head2 from_gff_string\n\n Title   : from_gff_string\n Usage   : $gff->from_gff_string($feature, $gff_string);\n Function: Sets properties of a SeqFeatureI object from a GFF-formatted\n           string. Interpretation of the string depends on the version\n           that has been specified at initialization.\n\n           This method is used by next_feature(). It actually dispatches to\n           one of the version-specific (private) methods.\n Example :\n Returns : void\n Args    : A Bio::SeqFeatureI implementing object to be initialized\n           The GFF-formatted string to initialize it from","parameters":[{"label":"$self"},{"label":"$feat"},{"label":"$gff_string"}],"label":"from_gff_string($self,$feat,$gff_string)"},"detail":"($self,$feat,$gff_string)","definition":"sub","containerName":"main::","children":[{"localvar":"my","name":"$self","definition":"my","containerName":"from_gff_string","line":428,"kind":13},{"name":"$feat","containerName":"from_gff_string","line":428,"kind":13},{"name":"$gff_string","containerName":"from_gff_string","kind":13,"line":428},{"name":"$self","containerName":"from_gff_string","line":430,"kind":13},{"name":"gff_version","containerName":"from_gff_string","kind":12,"line":430},{"line":431,"kind":13,"containerName":"from_gff_string","name":"$self"},{"containerName":"from_gff_string","name":"_from_gff1_string","line":431,"kind":12},{"name":"$feat","containerName":"from_gff_string","line":431,"kind":13},{"kind":13,"line":431,"containerName":"from_gff_string","name":"$gff_string"},{"name":"$self","containerName":"from_gff_string","line":432,"kind":13},{"containerName":"from_gff_string","name":"gff_version","line":432,"kind":12},{"line":433,"kind":13,"name":"$self","containerName":"from_gff_string"},{"containerName":"from_gff_string","name":"_from_gff3_string","kind":12,"line":433},{"containerName":"from_gff_string","name":"$feat","kind":13,"line":433},{"kind":13,"line":433,"name":"$gff_string","containerName":"from_gff_string"},{"name":"$self","containerName":"from_gff_string","line":435,"kind":13},{"containerName":"from_gff_string","name":"_from_gff2_string","line":435,"kind":12},{"line":435,"kind":13,"containerName":"from_gff_string","name":"$feat"},{"name":"$gff_string","containerName":"from_gff_string","line":435,"kind":13}],"line":427,"kind":12,"range":{"start":{"character":0,"line":427},"end":{"line":437,"character":9999}},"name":"from_gff_string"},{"range":{"end":{"character":9999,"line":484},"start":{"character":0,"line":451}},"name":"_from_gff1_string","line":451,"children":[{"line":452,"kind":13,"localvar":"my","definition":"my","name":"$gff","containerName":"_from_gff1_string"},{"kind":13,"line":452,"containerName":"_from_gff1_string","name":"$feat"},{"line":452,"kind":13,"containerName":"_from_gff1_string","name":"$string"},{"name":"$string","containerName":"_from_gff1_string","line":453,"kind":13},{"line":454,"kind":13,"localvar":"my","name":"$seqname","definition":"my","containerName":"_from_gff1_string"},{"kind":13,"line":454,"containerName":"_from_gff1_string","name":"$source"},{"name":"$primary","containerName":"_from_gff1_string","kind":13,"line":454},{"containerName":"_from_gff1_string","name":"$start","line":454,"kind":13},{"name":"$end","containerName":"_from_gff1_string","kind":13,"line":454},{"containerName":"_from_gff1_string","name":"$score","line":454,"kind":13},{"kind":13,"line":455,"name":"$strand","containerName":"_from_gff1_string"},{"name":"$frame","containerName":"_from_gff1_string","line":455,"kind":13},{"containerName":"_from_gff1_string","name":"@group","line":455,"kind":13},{"name":"$string","containerName":"_from_gff1_string","kind":13,"line":455},{"containerName":"_from_gff1_string","name":"$frame","line":457,"kind":13},{"name":"$feat","containerName":"_from_gff1_string","kind":13,"line":458},{"name":"throw","containerName":"_from_gff1_string","kind":12,"line":458},{"name":"$frame","containerName":"_from_gff1_string","kind":13,"line":460},{"name":"$frame","containerName":"_from_gff1_string","kind":13,"line":460},{"line":461,"kind":13,"name":"$feat","containerName":"_from_gff1_string"},{"containerName":"_from_gff1_string","name":"seq_id","kind":12,"line":461},{"name":"$seqname","containerName":"_from_gff1_string","line":461,"kind":13},{"line":462,"kind":13,"containerName":"_from_gff1_string","name":"$feat"},{"line":462,"kind":12,"containerName":"_from_gff1_string","name":"source_tag"},{"kind":13,"line":462,"name":"$source","containerName":"_from_gff1_string"},{"kind":13,"line":463,"name":"$feat","containerName":"_from_gff1_string"},{"containerName":"_from_gff1_string","name":"primary_tag","kind":12,"line":463},{"name":"$primary","containerName":"_from_gff1_string","kind":13,"line":463},{"kind":13,"line":464,"containerName":"_from_gff1_string","name":"$feat"},{"containerName":"_from_gff1_string","name":"start","kind":12,"line":464},{"kind":13,"line":464,"containerName":"_from_gff1_string","name":"$start"},{"name":"$feat","containerName":"_from_gff1_string","line":465,"kind":13},{"kind":12,"line":465,"name":"end","containerName":"_from_gff1_string"},{"name":"$end","containerName":"_from_gff1_string","line":465,"kind":13},{"name":"$feat","containerName":"_from_gff1_string","line":466,"kind":13},{"kind":12,"line":466,"name":"frame","containerName":"_from_gff1_string"},{"containerName":"_from_gff1_string","name":"$frame","kind":13,"line":466},{"name":"$score","containerName":"_from_gff1_string","line":467,"kind":13},{"name":"$feat","containerName":"_from_gff1_string","line":470,"kind":13},{"name":"score","containerName":"_from_gff1_string","kind":12,"line":470},{"containerName":"_from_gff1_string","name":"$score","line":470,"kind":13},{"name":"$strand","containerName":"_from_gff1_string","line":472,"kind":13},{"kind":13,"line":472,"name":"$feat","containerName":"_from_gff1_string"},{"kind":12,"line":472,"name":"strand","containerName":"_from_gff1_string"},{"kind":13,"line":473,"containerName":"_from_gff1_string","name":"$strand"},{"line":473,"kind":13,"name":"$feat","containerName":"_from_gff1_string"},{"containerName":"_from_gff1_string","name":"strand","line":473,"kind":12},{"kind":13,"line":474,"containerName":"_from_gff1_string","name":"$strand"},{"name":"$feat","containerName":"_from_gff1_string","line":474,"kind":13},{"line":474,"kind":12,"containerName":"_from_gff1_string","name":"strand"},{"localvar":"my","definition":"my","name":"$g","containerName":"_from_gff1_string","line":475,"kind":13},{"line":475,"kind":13,"name":"@group","containerName":"_from_gff1_string"},{"containerName":"_from_gff1_string","name":"$g","line":476,"kind":13},{"localvar":"my","containerName":"_from_gff1_string","definition":"my","name":"$tag","line":477,"kind":13},{"line":478,"kind":13,"localvar":"my","containerName":"_from_gff1_string","definition":"my","name":"$value"},{"name":"$feat","containerName":"_from_gff1_string","line":479,"kind":13},{"line":479,"kind":12,"containerName":"_from_gff1_string","name":"add_tag_value"},{"containerName":"_from_gff1_string","name":"$feat","line":481,"kind":13},{"containerName":"_from_gff1_string","name":"add_tag_value","kind":12,"line":481},{"line":481,"kind":13,"containerName":"_from_gff1_string","name":"$g"}],"kind":12,"detail":"($gff,$feat,$string)","signature":{"parameters":[{"label":"$gff"},{"label":"$feat"},{"label":"$string"}],"documentation":"1;\n# $Id: GFF.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::GFF\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by the Bioperl core team\n#\n# Copyright Matthew Pocock\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::GFF - A Bio::SeqAnalysisParserI compliant GFF format parser\n\n=head1 SYNOPSIS\n\n    use Bio::Tools::GFF;\n\n    # specify input via -fh or -file\n    my $gffio = Bio::Tools::GFF->new(-fh => \\*STDIN, -gff_version => 2);\n    my $feature;\n    # loop over the input stream\n    while($feature = $gffio->next_feature()) {\n        # do something with feature\n    }\n    $gffio->close();\n\n    # you can also obtain a GFF parser as a SeqAnalasisParserI in\n    # HT analysis pipelines (see Bio::SeqAnalysisParserI and\n    # Bio::Factory::SeqAnalysisParserFactory)\n    my $factory = Bio::Factory::SeqAnalysisParserFactory->new();\n    my $parser = $factory->get_parser(-input => \\*STDIN, -method => \"gff\");\n    while($feature = $parser->next_feature()) {\n        # do something with feature\n    }\n\n=head1 DESCRIPTION\n\nThis class provides a simple GFF parser and writer. In the sense of a\nSeqAnalysisParser, it parses an input file or stream into SeqFeatureI\nobjects, but is not in any way specific to a particular analysis\nprogram and the output that program produces.\n\nThat is, if you can get your analysis program spit out GFF, here is\nyour result parser.\n\n=head1 GFF3 AND SEQUENCE DATA\n\nGFF3 supports sequence data; see\n\nhttp://www.sequenceontology.org/gff3.shtml\n\nThere are a number of ways to deal with this -\n\nIf you call\n\n  $gffio->ignore_sequence(1)\n\nprior to parsing the sequence data is ignored; this is useful if you\njust want the features. It avoids the memory overhead in building and\ncaching sequences\n\nAlternatively, you can call either\n\n  $gffio->get_seqs()\n\nOr\n\n  $gffio->seq_id_by_h()\n\nAt the B<end> of parsing to get either a list or hashref of Bio::Seq\nobjects (see the documentation for each of these methods)\n\nNote that these objects will not have the features attached - you have\nto do this yourself, OR call\n\n  $gffio->features_attached_to_seqs(1)\n\nPRIOR to parsing; this will ensure that the Seqs have the features\nattached; ie you will then be able to call\n\n  $seq->get_SeqFeatures();\n\nAnd use Bio::SeqIO methods\n\nNote that auto-attaching the features to seqs will incur a higher\nmemory overhead as the features must be cached until the sequence data\nis found\n\n=head1 TODO\n\nMake a Bio::SeqIO class specifically for GFF3 with sequence data\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Matthew Pocock\n\nEmail mrp-at-sanger.ac.uk\n\n=head1 CONTRIBUTORS \n\nJason Stajich, jason-at-biperl-dot-org\nChris Mungall, cjm-at-fruitfly-dot-org\nSteffen Grossmann [SG], grossman at molgen.mpg.de\nMalcolm Cook, mec-at-stowers-institute.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tools::GFF;\n\nuse vars qw($HAS_HTML_ENTITIES);\nuse strict;\n\nuse Bio::Seq::SeqFactory;\nuse Bio::LocatableSeq;\nuse Bio::SeqFeature::Generic;\n\nuse base qw(Bio::Root::Root Bio::SeqAnalysisParserI Bio::Root::IO);\n\nmy $i = 0;\nmy %GFF3_ID_Tags = map { $_ => $i++ } qw(ID Parent Target);\n\n=head2 new\n\n Title   : new\n Usage   : my $parser = Bio::Tools::GFF->new(-gff_version => 2,\n\t\t\t\t\t    -file        => \"filename.gff\");\n           or\n           my $writer = Bio::Tools::GFF->new(-gff_version => 3,\n\t\t\t\t\t    -file        => \">filename.gff3\");\n Function: Creates a new instance. Recognized named parameters are -file, -fh,\n           and -gff_version.\n Returns : a new object\n Args    : named parameters\n           -gff_version => [1,2,3]\n\n\n\n{   # make a class variable such that we can generate unique ID's over\n    # a session, no matter how many instances of GFF.pm we make\n    # since these have to be unique within the scope of a GFF file.\n    \n    my $gff3_featureID = 0;\n    \n    sub _incrementGFF3ID {\n        my ($self) = @_;\n        return ++ $gff3_featureID;\n    }\n}\n\n\nsub new {\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n  \n  my ($gff_version, $noparse) = $self->_rearrange([qw(GFF_VERSION NOPARSE)],@args);\n\n  # initialize IO\n  $self->_initialize_io(@args);\n  $self->_parse_header() unless $noparse;\n\n  $gff_version ||= 2;\n  if( ! $self->gff_version($gff_version) )  {\n      $self->throw(\"Can't build a GFF object with the unknown version \".\n\t\t   $gff_version);\n  }\n  $self->{'_first'} = 1;\n  return $self;\n}\n\n=head2 _parse_header\n\n Title   : _parse_header\n Usage   : $gffio->_parse_header()\n Function: used to turn parse GFF header lines.  currently\n           produces Bio::LocatableSeq objects from ##sequence-region\n           lines\n Returns : 1 on success\n Args    : none\n\n\n\nsub _parse_header{\n   my ($self) = @_;\n\n   my @unhandled;\n   local $^W = 0; # hide warnings when we try and parse from a file opened\n                  # for writing - there isn't really a better way to do\n                  # AFAIK - cannot detech if a FH is read or write.\n   while(my $line = $self->_readline()){\n \t my $handled = 0;\n\t next if /^\\s+$/;\n\t if($line =~ /^\\#\\#sequence-region\\s+(\\S+)\\s+(\\S+)\\s+(\\S+)\\s*/){\n\t   my($seqid,$start,$end) = ($1,$2,$3);\n\t   push @{ $self->{'segments'} }, Bio::LocatableSeq->new\n\t       (\n\t\t-id    => unescape($seqid),\n\t\t-start => $start,\n\t\t-end   => $end,\n                -length => ($end - $start + 1),  ## make the length explicit\n\t\t);\n\t   $handled = 1;\n\t } elsif($line =~ /^(\\#\\#feature-ontology)/) {\n\t   #to be implemented\n\t   $self->warn(\"$1 header tag parsing unimplemented\");\n\t } elsif($line =~ /^(\\#\\#attribute-ontology)/) {\n\t   #to be implemented\n\t   $self->warn(\"$1 header tag parsing unimplemented\");\n\t } elsif($line =~ /^(\\#\\#source-ontology)/) {\n\t   #to be implemented\n\t   $self->warn(\"$1 header tag parsing unimplemented\");\n\t } elsif($line =~ /^(\\#\\#\\#)/) {\n\t   #to be implemented\n\t   $self->warn(\"$1 header tag parsing unimplemented\");\n\t } elsif($line =~ /^(\\#\\#FASTA)/) {\n            # initial ##FASTA is optional - artemis does not use it\n            $line = $self->_readline();\n            if ($line !~ /^\\>(\\S+)/) {\n                $self->throw(\"##FASTA directive must be followed by fasta header, not: $line\");\n            }\n\t } else {\n         }\n         \n         if ($line =~ /^\\>(.*)/) {\n             # seq data can be at header or footer\n             my $seq = $self->_parse_sequence($line);\n             if ($seq) {\n                 $self->_seq_by_id_h->{$seq->primary_id} = $seq;\n             }\n         }\n             \n\n \t if(!$handled){\n\t   push @unhandled, $line\n \t }\n\n\t #looks like the header is over!\n\t last unless $line =~ /^\\#/;\n   }\n\n   foreach my $line (@unhandled){\n\t $self->_pushback($line);\n   }\n\n   return 1;\n}\n\nsub _parse_sequence {\n    my ($self, $line) = @_;\n\n    if ($line =~ /^\\>(.*)/) {\n        \n        my $seqid = $1;\n        $seqid =~ s/\\s+$//;\n        my $desc = '';\n        if ($seqid =~ /(\\S+)\\s+(.*)/) {\n            ($seqid, $desc) = ($1,$2);\n        }\n        my $res = '';\n        while (my $line = $self->_readline) {\n            if ($line =~ /^\\#/) {\n                last;\n            }\n            if ($line =~ /^\\>/) {\n                $self->_pushback($line);\n                last;\n            }\n            $line =~ s/\\s//g;\n            $res .= $line;\n        }\n        return if $self->ignore_sequence;\n\n        my $seqfactory = Bio::Seq::SeqFactory->new('Bio::Seq');\n        my $seq = $seqfactory->create(-seq=>$res, \n                                      -id=>$seqid,\n                                      -desc=>$desc);\n        $seq->accession_number($seqid);\n        if ($self->features_attached_to_seqs) {\n            my @feats = \n              @{$self->_feature_idx_by_seq_id->{$seqid}};\n            $seq->add_SeqFeature($_) foreach @feats;\n            @{$self->_feature_idx_by_seq_id->{$seqid}} = ();\n        }\n        return $seq;\n    }\n    else {\n        $self->throw(\"expected fasta header, not: $line\");\n    }\n}\n\n\n=head2 next_segment\n\n Title   : next_segment\n Usage   : my $seq = $gffio->next_segment;\n Function: Returns a Bio::LocatableSeq object corresponding to a \n           GFF \"##sequence-region\" header line.\n Example :\n Returns : A Bio::LocatableSeq object, or undef if\n           there are no more sequences.\n Args    : none\n\n\n\nsub next_segment{\n   my ($self,@args) = @_;\n   return shift @{ $self->{'segments'} } if defined $self->{'segments'};\n   return;\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : $seqfeature = $gffio->next_feature();\n Function: Returns the next feature available in the input file or stream, or\n           undef if there are no more features.\n Example :\n Returns : A Bio::SeqFeatureI implementing object, or undef if there are no\n           more features.\n Args    : none    \n\n\nsub next_feature {\n    my ($self) = @_;\n    \n    my $gff_string;\n    \n    # be graceful about empty lines or comments, and make sure we return undef\n    # if the input's consumed\n    while(($gff_string = $self->_readline()) && defined($gff_string)) {\t\n        if ($gff_string =~ /^\\#\\#\\#/) {\n            # all forward refs have been seen; TODO\n        }\n        next if($gff_string =~ /^\\#/ || $gff_string =~ /^\\s*$/ ||\n                $gff_string =~ m{^//});\n\n        while ($gff_string =~ /^\\>(.+)/) {\n            # fasta can be in header or footer\n            my $seq = $self->_parse_sequence($gff_string);\n            if ($seq) {\n                $self->_seq_by_id_h->{$seq->primary_id} = $seq;\n                $gff_string = $self->_readline;\n                last unless $gff_string;\n            }\n        }\n        last; \n    }\n    return unless $gff_string;\n\n    my $feat = Bio::SeqFeature::Generic->new();\n    $self->from_gff_string($feat, $gff_string);\n\n    if ($self->features_attached_to_seqs) {\n        push(@{$self->_feature_idx_by_seq_id->{$feat->seq_id}},\n             $feat);\n    }\n\n    return $feat;\n}\n\nsub _feature_idx_by_seq_id {\n    my $self = shift;\n    $self->{__feature_idx_by_seq_id} = shift if @_;\n    $self->{__feature_idx_by_seq_id} = {}\n      unless $self->{__feature_idx_by_seq_id};\n    return $self->{__feature_idx_by_seq_id};\n}\n\n\n=head2 from_gff_string\n\n Title   : from_gff_string\n Usage   : $gff->from_gff_string($feature, $gff_string);\n Function: Sets properties of a SeqFeatureI object from a GFF-formatted\n           string. Interpretation of the string depends on the version\n           that has been specified at initialization.\n\n           This method is used by next_feature(). It actually dispatches to\n           one of the version-specific (private) methods.\n Example :\n Returns : void\n Args    : A Bio::SeqFeatureI implementing object to be initialized\n           The GFF-formatted string to initialize it from\n\n\nsub from_gff_string {\n    my ($self, $feat, $gff_string) = @_;\n\n    if($self->gff_version() == 1)  {\n\treturn $self->_from_gff1_string($feat, $gff_string);\n    } elsif( $self->gff_version() == 3 ) {\n\treturn $self->_from_gff3_string($feat, $gff_string);\n    } else {\n\treturn $self->_from_gff2_string($feat, $gff_string);\n    }\n}\n\n=head2 _from_gff1_string\n\n Title   : _from_gff1_string\n Usage   :\n Function:\n Example :\n Returns : void\n Args    : A Bio::SeqFeatureI implementing object to be initialized\n           The GFF-formatted string to initialize it from","label":"_from_gff1_string($gff,$feat,$string)"},"containerName":"main::","definition":"sub"},{"range":{"start":{"character":0,"line":499},"end":{"line":598,"character":9999}},"name":"_from_gff2_string","detail":"($gff,$feat,$string)","signature":{"parameters":[{"label":"$gff"},{"label":"$feat"},{"label":"$string"}],"documentation":"1;\n# $Id: GFF.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::GFF\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by the Bioperl core team\n#\n# Copyright Matthew Pocock\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::GFF - A Bio::SeqAnalysisParserI compliant GFF format parser\n\n=head1 SYNOPSIS\n\n    use Bio::Tools::GFF;\n\n    # specify input via -fh or -file\n    my $gffio = Bio::Tools::GFF->new(-fh => \\*STDIN, -gff_version => 2);\n    my $feature;\n    # loop over the input stream\n    while($feature = $gffio->next_feature()) {\n        # do something with feature\n    }\n    $gffio->close();\n\n    # you can also obtain a GFF parser as a SeqAnalasisParserI in\n    # HT analysis pipelines (see Bio::SeqAnalysisParserI and\n    # Bio::Factory::SeqAnalysisParserFactory)\n    my $factory = Bio::Factory::SeqAnalysisParserFactory->new();\n    my $parser = $factory->get_parser(-input => \\*STDIN, -method => \"gff\");\n    while($feature = $parser->next_feature()) {\n        # do something with feature\n    }\n\n=head1 DESCRIPTION\n\nThis class provides a simple GFF parser and writer. In the sense of a\nSeqAnalysisParser, it parses an input file or stream into SeqFeatureI\nobjects, but is not in any way specific to a particular analysis\nprogram and the output that program produces.\n\nThat is, if you can get your analysis program spit out GFF, here is\nyour result parser.\n\n=head1 GFF3 AND SEQUENCE DATA\n\nGFF3 supports sequence data; see\n\nhttp://www.sequenceontology.org/gff3.shtml\n\nThere are a number of ways to deal with this -\n\nIf you call\n\n  $gffio->ignore_sequence(1)\n\nprior to parsing the sequence data is ignored; this is useful if you\njust want the features. It avoids the memory overhead in building and\ncaching sequences\n\nAlternatively, you can call either\n\n  $gffio->get_seqs()\n\nOr\n\n  $gffio->seq_id_by_h()\n\nAt the B<end> of parsing to get either a list or hashref of Bio::Seq\nobjects (see the documentation for each of these methods)\n\nNote that these objects will not have the features attached - you have\nto do this yourself, OR call\n\n  $gffio->features_attached_to_seqs(1)\n\nPRIOR to parsing; this will ensure that the Seqs have the features\nattached; ie you will then be able to call\n\n  $seq->get_SeqFeatures();\n\nAnd use Bio::SeqIO methods\n\nNote that auto-attaching the features to seqs will incur a higher\nmemory overhead as the features must be cached until the sequence data\nis found\n\n=head1 TODO\n\nMake a Bio::SeqIO class specifically for GFF3 with sequence data\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Matthew Pocock\n\nEmail mrp-at-sanger.ac.uk\n\n=head1 CONTRIBUTORS \n\nJason Stajich, jason-at-biperl-dot-org\nChris Mungall, cjm-at-fruitfly-dot-org\nSteffen Grossmann [SG], grossman at molgen.mpg.de\nMalcolm Cook, mec-at-stowers-institute.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tools::GFF;\n\nuse vars qw($HAS_HTML_ENTITIES);\nuse strict;\n\nuse Bio::Seq::SeqFactory;\nuse Bio::LocatableSeq;\nuse Bio::SeqFeature::Generic;\n\nuse base qw(Bio::Root::Root Bio::SeqAnalysisParserI Bio::Root::IO);\n\nmy $i = 0;\nmy %GFF3_ID_Tags = map { $_ => $i++ } qw(ID Parent Target);\n\n=head2 new\n\n Title   : new\n Usage   : my $parser = Bio::Tools::GFF->new(-gff_version => 2,\n\t\t\t\t\t    -file        => \"filename.gff\");\n           or\n           my $writer = Bio::Tools::GFF->new(-gff_version => 3,\n\t\t\t\t\t    -file        => \">filename.gff3\");\n Function: Creates a new instance. Recognized named parameters are -file, -fh,\n           and -gff_version.\n Returns : a new object\n Args    : named parameters\n           -gff_version => [1,2,3]\n\n\n\n{   # make a class variable such that we can generate unique ID's over\n    # a session, no matter how many instances of GFF.pm we make\n    # since these have to be unique within the scope of a GFF file.\n    \n    my $gff3_featureID = 0;\n    \n    sub _incrementGFF3ID {\n        my ($self) = @_;\n        return ++ $gff3_featureID;\n    }\n}\n\n\nsub new {\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n  \n  my ($gff_version, $noparse) = $self->_rearrange([qw(GFF_VERSION NOPARSE)],@args);\n\n  # initialize IO\n  $self->_initialize_io(@args);\n  $self->_parse_header() unless $noparse;\n\n  $gff_version ||= 2;\n  if( ! $self->gff_version($gff_version) )  {\n      $self->throw(\"Can't build a GFF object with the unknown version \".\n\t\t   $gff_version);\n  }\n  $self->{'_first'} = 1;\n  return $self;\n}\n\n=head2 _parse_header\n\n Title   : _parse_header\n Usage   : $gffio->_parse_header()\n Function: used to turn parse GFF header lines.  currently\n           produces Bio::LocatableSeq objects from ##sequence-region\n           lines\n Returns : 1 on success\n Args    : none\n\n\n\nsub _parse_header{\n   my ($self) = @_;\n\n   my @unhandled;\n   local $^W = 0; # hide warnings when we try and parse from a file opened\n                  # for writing - there isn't really a better way to do\n                  # AFAIK - cannot detech if a FH is read or write.\n   while(my $line = $self->_readline()){\n \t my $handled = 0;\n\t next if /^\\s+$/;\n\t if($line =~ /^\\#\\#sequence-region\\s+(\\S+)\\s+(\\S+)\\s+(\\S+)\\s*/){\n\t   my($seqid,$start,$end) = ($1,$2,$3);\n\t   push @{ $self->{'segments'} }, Bio::LocatableSeq->new\n\t       (\n\t\t-id    => unescape($seqid),\n\t\t-start => $start,\n\t\t-end   => $end,\n                -length => ($end - $start + 1),  ## make the length explicit\n\t\t);\n\t   $handled = 1;\n\t } elsif($line =~ /^(\\#\\#feature-ontology)/) {\n\t   #to be implemented\n\t   $self->warn(\"$1 header tag parsing unimplemented\");\n\t } elsif($line =~ /^(\\#\\#attribute-ontology)/) {\n\t   #to be implemented\n\t   $self->warn(\"$1 header tag parsing unimplemented\");\n\t } elsif($line =~ /^(\\#\\#source-ontology)/) {\n\t   #to be implemented\n\t   $self->warn(\"$1 header tag parsing unimplemented\");\n\t } elsif($line =~ /^(\\#\\#\\#)/) {\n\t   #to be implemented\n\t   $self->warn(\"$1 header tag parsing unimplemented\");\n\t } elsif($line =~ /^(\\#\\#FASTA)/) {\n            # initial ##FASTA is optional - artemis does not use it\n            $line = $self->_readline();\n            if ($line !~ /^\\>(\\S+)/) {\n                $self->throw(\"##FASTA directive must be followed by fasta header, not: $line\");\n            }\n\t } else {\n         }\n         \n         if ($line =~ /^\\>(.*)/) {\n             # seq data can be at header or footer\n             my $seq = $self->_parse_sequence($line);\n             if ($seq) {\n                 $self->_seq_by_id_h->{$seq->primary_id} = $seq;\n             }\n         }\n             \n\n \t if(!$handled){\n\t   push @unhandled, $line\n \t }\n\n\t #looks like the header is over!\n\t last unless $line =~ /^\\#/;\n   }\n\n   foreach my $line (@unhandled){\n\t $self->_pushback($line);\n   }\n\n   return 1;\n}\n\nsub _parse_sequence {\n    my ($self, $line) = @_;\n\n    if ($line =~ /^\\>(.*)/) {\n        \n        my $seqid = $1;\n        $seqid =~ s/\\s+$//;\n        my $desc = '';\n        if ($seqid =~ /(\\S+)\\s+(.*)/) {\n            ($seqid, $desc) = ($1,$2);\n        }\n        my $res = '';\n        while (my $line = $self->_readline) {\n            if ($line =~ /^\\#/) {\n                last;\n            }\n            if ($line =~ /^\\>/) {\n                $self->_pushback($line);\n                last;\n            }\n            $line =~ s/\\s//g;\n            $res .= $line;\n        }\n        return if $self->ignore_sequence;\n\n        my $seqfactory = Bio::Seq::SeqFactory->new('Bio::Seq');\n        my $seq = $seqfactory->create(-seq=>$res, \n                                      -id=>$seqid,\n                                      -desc=>$desc);\n        $seq->accession_number($seqid);\n        if ($self->features_attached_to_seqs) {\n            my @feats = \n              @{$self->_feature_idx_by_seq_id->{$seqid}};\n            $seq->add_SeqFeature($_) foreach @feats;\n            @{$self->_feature_idx_by_seq_id->{$seqid}} = ();\n        }\n        return $seq;\n    }\n    else {\n        $self->throw(\"expected fasta header, not: $line\");\n    }\n}\n\n\n=head2 next_segment\n\n Title   : next_segment\n Usage   : my $seq = $gffio->next_segment;\n Function: Returns a Bio::LocatableSeq object corresponding to a \n           GFF \"##sequence-region\" header line.\n Example :\n Returns : A Bio::LocatableSeq object, or undef if\n           there are no more sequences.\n Args    : none\n\n\n\nsub next_segment{\n   my ($self,@args) = @_;\n   return shift @{ $self->{'segments'} } if defined $self->{'segments'};\n   return;\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : $seqfeature = $gffio->next_feature();\n Function: Returns the next feature available in the input file or stream, or\n           undef if there are no more features.\n Example :\n Returns : A Bio::SeqFeatureI implementing object, or undef if there are no\n           more features.\n Args    : none    \n\n\nsub next_feature {\n    my ($self) = @_;\n    \n    my $gff_string;\n    \n    # be graceful about empty lines or comments, and make sure we return undef\n    # if the input's consumed\n    while(($gff_string = $self->_readline()) && defined($gff_string)) {\t\n        if ($gff_string =~ /^\\#\\#\\#/) {\n            # all forward refs have been seen; TODO\n        }\n        next if($gff_string =~ /^\\#/ || $gff_string =~ /^\\s*$/ ||\n                $gff_string =~ m{^//});\n\n        while ($gff_string =~ /^\\>(.+)/) {\n            # fasta can be in header or footer\n            my $seq = $self->_parse_sequence($gff_string);\n            if ($seq) {\n                $self->_seq_by_id_h->{$seq->primary_id} = $seq;\n                $gff_string = $self->_readline;\n                last unless $gff_string;\n            }\n        }\n        last; \n    }\n    return unless $gff_string;\n\n    my $feat = Bio::SeqFeature::Generic->new();\n    $self->from_gff_string($feat, $gff_string);\n\n    if ($self->features_attached_to_seqs) {\n        push(@{$self->_feature_idx_by_seq_id->{$feat->seq_id}},\n             $feat);\n    }\n\n    return $feat;\n}\n\nsub _feature_idx_by_seq_id {\n    my $self = shift;\n    $self->{__feature_idx_by_seq_id} = shift if @_;\n    $self->{__feature_idx_by_seq_id} = {}\n      unless $self->{__feature_idx_by_seq_id};\n    return $self->{__feature_idx_by_seq_id};\n}\n\n\n=head2 from_gff_string\n\n Title   : from_gff_string\n Usage   : $gff->from_gff_string($feature, $gff_string);\n Function: Sets properties of a SeqFeatureI object from a GFF-formatted\n           string. Interpretation of the string depends on the version\n           that has been specified at initialization.\n\n           This method is used by next_feature(). It actually dispatches to\n           one of the version-specific (private) methods.\n Example :\n Returns : void\n Args    : A Bio::SeqFeatureI implementing object to be initialized\n           The GFF-formatted string to initialize it from\n\n\nsub from_gff_string {\n    my ($self, $feat, $gff_string) = @_;\n\n    if($self->gff_version() == 1)  {\n\treturn $self->_from_gff1_string($feat, $gff_string);\n    } elsif( $self->gff_version() == 3 ) {\n\treturn $self->_from_gff3_string($feat, $gff_string);\n    } else {\n\treturn $self->_from_gff2_string($feat, $gff_string);\n    }\n}\n\n=head2 _from_gff1_string\n\n Title   : _from_gff1_string\n Usage   :\n Function:\n Example :\n Returns : void\n Args    : A Bio::SeqFeatureI implementing object to be initialized\n           The GFF-formatted string to initialize it from\n\n\nsub _from_gff1_string {\n   my ($gff, $feat, $string) = @_;\n   chomp $string;\n   my ($seqname, $source, $primary, $start, $end, $score, \n       $strand, $frame, @group) = split(/\\t/, $string);\n\n   if ( !defined $frame ) {\n       $feat->throw(\"[$string] does not look like GFF to me\");\n   }\n   $frame = 0 unless( $frame =~ /^\\d+$/);\n   $feat->seq_id($seqname);\n   $feat->source_tag($source);\n   $feat->primary_tag($primary);\n   $feat->start($start);\n   $feat->end($end);\n   $feat->frame($frame);\n   if ( $score eq '.' ) {\n       #$feat->score(undef);\n   } else {\n       $feat->score($score);\n   }\n   if ( $strand eq '-' ) { $feat->strand(-1); }\n   if ( $strand eq '+' ) { $feat->strand(1); }\n   if ( $strand eq '.' ) { $feat->strand(0); }\n   foreach my $g ( @group ) {\n       if ( $g =~ /(\\S+)=(\\S+)/ ) {\n\t   my $tag = $1;\n\t   my $value = $2;\n\t   $feat->add_tag_value($1, $2);\n       } else {\n\t   $feat->add_tag_value('group', $g);\n       }\n   }\n}\n\n=head2 _from_gff2_string\n\n Title   : _from_gff2_string\n Usage   :\n Function:\n Example :\n Returns : void\n Args    : A Bio::SeqFeatureI implementing object to be initialized\n           The GFF2-formatted string to initialize it from","label":"_from_gff2_string($gff,$feat,$string)"},"containerName":"main::","definition":"sub","line":499,"children":[{"kind":13,"line":500,"definition":"my","name":"$gff","containerName":"_from_gff2_string","localvar":"my"},{"name":"$feat","containerName":"_from_gff2_string","line":500,"kind":13},{"containerName":"_from_gff2_string","name":"$string","line":500,"kind":13},{"containerName":"_from_gff2_string","name":"$string","line":501,"kind":13},{"localvar":"my","containerName":"_from_gff2_string","name":"$seqname","definition":"my","line":513,"kind":13},{"containerName":"_from_gff2_string","name":"$source","line":513,"kind":13},{"kind":13,"line":513,"name":"$primary","containerName":"_from_gff2_string"},{"containerName":"_from_gff2_string","name":"$start","kind":13,"line":513},{"name":"$end","containerName":"_from_gff2_string","kind":13,"line":514},{"line":514,"kind":13,"name":"$score","containerName":"_from_gff2_string"},{"kind":13,"line":514,"containerName":"_from_gff2_string","name":"$strand"},{"kind":13,"line":514,"name":"$frame","containerName":"_from_gff2_string"},{"line":514,"kind":13,"containerName":"_from_gff2_string","name":"@attribs"},{"line":514,"kind":13,"containerName":"_from_gff2_string","name":"$string"},{"containerName":"_from_gff2_string","name":"$attribs","definition":"my","localvar":"my","kind":13,"line":515},{"kind":13,"line":515,"containerName":"_from_gff2_string","name":"@attribs"},{"containerName":"_from_gff2_string","name":"$frame","kind":13,"line":517},{"line":518,"kind":13,"containerName":"_from_gff2_string","name":"$feat"},{"kind":12,"line":518,"name":"throw","containerName":"_from_gff2_string"},{"containerName":"_from_gff2_string","name":"$feat","line":520,"kind":13},{"containerName":"_from_gff2_string","name":"seq_id","kind":12,"line":520},{"name":"$seqname","containerName":"_from_gff2_string","line":520,"kind":13},{"kind":13,"line":521,"containerName":"_from_gff2_string","name":"$feat"},{"kind":12,"line":521,"containerName":"_from_gff2_string","name":"source_tag"},{"line":521,"kind":13,"containerName":"_from_gff2_string","name":"$source"},{"kind":13,"line":522,"containerName":"_from_gff2_string","name":"$feat"},{"containerName":"_from_gff2_string","name":"primary_tag","kind":12,"line":522},{"line":522,"kind":13,"name":"$primary","containerName":"_from_gff2_string"},{"kind":13,"line":523,"name":"$feat","containerName":"_from_gff2_string"},{"line":523,"kind":12,"name":"start","containerName":"_from_gff2_string"},{"containerName":"_from_gff2_string","name":"$start","line":523,"kind":13},{"line":524,"kind":13,"name":"$feat","containerName":"_from_gff2_string"},{"kind":12,"line":524,"name":"end","containerName":"_from_gff2_string"},{"containerName":"_from_gff2_string","name":"$end","kind":13,"line":524},{"kind":13,"line":525,"name":"$feat","containerName":"_from_gff2_string"},{"kind":12,"line":525,"name":"frame","containerName":"_from_gff2_string"},{"line":525,"kind":13,"containerName":"_from_gff2_string","name":"$frame"},{"kind":13,"line":526,"name":"$score","containerName":"_from_gff2_string"},{"line":529,"kind":13,"containerName":"_from_gff2_string","name":"$feat"},{"containerName":"_from_gff2_string","name":"score","kind":12,"line":529},{"line":529,"kind":13,"containerName":"_from_gff2_string","name":"$score"},{"containerName":"_from_gff2_string","name":"$strand","line":531,"kind":13},{"name":"$feat","containerName":"_from_gff2_string","kind":13,"line":531},{"name":"strand","containerName":"_from_gff2_string","kind":12,"line":531},{"line":532,"kind":13,"name":"$strand","containerName":"_from_gff2_string"},{"line":532,"kind":13,"name":"$feat","containerName":"_from_gff2_string"},{"line":532,"kind":12,"containerName":"_from_gff2_string","name":"strand"},{"name":"$strand","containerName":"_from_gff2_string","line":533,"kind":13},{"name":"$feat","containerName":"_from_gff2_string","kind":13,"line":533},{"line":533,"kind":12,"name":"strand","containerName":"_from_gff2_string"},{"localvar":"my","containerName":"_from_gff2_string","definition":"my","name":"$flag","line":545,"kind":13},{"localvar":"my","definition":"my","name":"@parsed","containerName":"_from_gff2_string","line":546,"kind":13},{"containerName":"_from_gff2_string","definition":"my","name":"$a","localvar":"my","kind":13,"line":551},{"name":"$attribs","containerName":"_from_gff2_string","line":551,"kind":13},{"line":553,"kind":13,"containerName":"_from_gff2_string","name":"$a"},{"name":"$flag","containerName":"_from_gff2_string","line":553,"kind":13},{"name":"$flag","containerName":"_from_gff2_string","kind":13,"line":553},{"kind":13,"line":554,"name":"$a","containerName":"_from_gff2_string"},{"name":"$flag","containerName":"_from_gff2_string","line":554,"kind":13},{"line":554,"kind":13,"name":"$a","containerName":"_from_gff2_string"},{"containerName":"_from_gff2_string","name":"$a","line":555,"kind":13},{"kind":13,"line":555,"name":"$flag","containerName":"_from_gff2_string"},{"line":556,"kind":13,"name":"@parsed","containerName":"_from_gff2_string"},{"kind":13,"line":556,"name":"$a","containerName":"_from_gff2_string"},{"containerName":"_from_gff2_string","name":"$attribs","kind":13,"line":558},{"name":"@parsed","containerName":"_from_gff2_string","kind":13,"line":558},{"localvar":"my","definition":"my","name":"@key_vals","containerName":"_from_gff2_string","line":563,"kind":13},{"kind":13,"line":563,"name":"$attribs","containerName":"_from_gff2_string"},{"name":"$pair","definition":"my","containerName":"_from_gff2_string","localvar":"my","kind":13,"line":565},{"line":565,"kind":13,"containerName":"_from_gff2_string","name":"@key_vals"},{"containerName":"_from_gff2_string","name":"$pair","kind":13,"line":567},{"localvar":"my","containerName":"_from_gff2_string","definition":"my","name":"$blank","line":570,"kind":13},{"kind":13,"line":570,"containerName":"_from_gff2_string","name":"$key"},{"name":"$values","containerName":"_from_gff2_string","line":570,"kind":13},{"containerName":"_from_gff2_string","name":"$pair","line":570,"kind":13},{"containerName":"_from_gff2_string","name":"$values","kind":13,"line":573},{"containerName":"_from_gff2_string","definition":"my","name":"@values","localvar":"my","kind":13,"line":574},{"kind":13,"line":577,"containerName":"_from_gff2_string","name":"$values"},{"containerName":"_from_gff2_string","name":"@values","kind":13,"line":580},{"kind":13,"line":586,"containerName":"_from_gff2_string","definition":"my","name":"@othervals","localvar":"my"},{"containerName":"_from_gff2_string","name":"$values","line":586,"kind":13},{"localvar":"my","containerName":"_from_gff2_string","name":"$othervalue","definition":"my","line":587,"kind":13},{"kind":13,"line":587,"containerName":"_from_gff2_string","name":"@othervals"},{"line":590,"kind":13,"containerName":"_from_gff2_string","name":"$othervalue"},{"kind":13,"line":590,"name":"@values","containerName":"_from_gff2_string"},{"line":590,"kind":13,"containerName":"_from_gff2_string","name":"$othervalue"},{"line":593,"kind":13,"localvar":"my","name":"$value","definition":"my","containerName":"_from_gff2_string"},{"containerName":"_from_gff2_string","name":"@values","kind":13,"line":593},{"name":"$feat","containerName":"_from_gff2_string","line":594,"kind":13},{"containerName":"_from_gff2_string","name":"add_tag_value","line":594,"kind":12},{"line":594,"kind":13,"containerName":"_from_gff2_string","name":"$key"},{"line":594,"kind":13,"name":"$value","containerName":"_from_gff2_string"}],"kind":12},{"name":"last","kind":12,"line":555},{"containerName":"length","name":"CORE","kind":12,"line":590},{"name":"_from_gff3_string","range":{"start":{"character":0,"line":601},"end":{"line":637,"character":9999}},"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$gff"},{"label":"$feat"},{"label":"$string"}],"documentation":"","label":"_from_gff3_string($gff,$feat,$string)"},"detail":"($gff,$feat,$string)","kind":12,"children":[{"line":602,"kind":13,"localvar":"my","name":"$gff","definition":"my","containerName":"_from_gff3_string"},{"kind":13,"line":602,"containerName":"_from_gff3_string","name":"$feat"},{"name":"$string","containerName":"_from_gff3_string","kind":13,"line":602},{"kind":13,"line":603,"name":"$string","containerName":"_from_gff3_string"},{"line":609,"kind":13,"localvar":"my","definition":"my","name":"$seqname","containerName":"_from_gff3_string"},{"containerName":"_from_gff3_string","name":"$source","kind":13,"line":609},{"name":"$primary","containerName":"_from_gff3_string","line":609,"kind":13},{"kind":13,"line":609,"containerName":"_from_gff3_string","name":"$start"},{"name":"$end","containerName":"_from_gff3_string","line":609,"kind":13},{"name":"$score","containerName":"_from_gff3_string","kind":13,"line":610},{"containerName":"_from_gff3_string","name":"$strand","kind":13,"line":610},{"kind":13,"line":610,"containerName":"_from_gff3_string","name":"$frame"},{"name":"$groups","containerName":"_from_gff3_string","kind":13,"line":610},{"line":610,"kind":13,"containerName":"_from_gff3_string","name":"$string"},{"containerName":"_from_gff3_string","name":"$frame","line":612,"kind":13},{"kind":13,"line":613,"name":"$feat","containerName":"_from_gff3_string"},{"name":"throw","containerName":"_from_gff3_string","kind":12,"line":613},{"containerName":"_from_gff3_string","name":"$feat","kind":13,"line":615},{"name":"seq_id","containerName":"_from_gff3_string","line":615,"kind":12},{"kind":13,"line":615,"name":"$seqname","containerName":"_from_gff3_string"},{"containerName":"_from_gff3_string","name":"$feat","kind":13,"line":616},{"containerName":"_from_gff3_string","name":"source_tag","line":616,"kind":12},{"kind":13,"line":616,"name":"$source","containerName":"_from_gff3_string"},{"containerName":"_from_gff3_string","name":"$feat","kind":13,"line":617},{"containerName":"_from_gff3_string","name":"primary_tag","line":617,"kind":12},{"name":"$primary","containerName":"_from_gff3_string","line":617,"kind":13},{"line":618,"kind":13,"containerName":"_from_gff3_string","name":"$feat"},{"containerName":"_from_gff3_string","name":"start","line":618,"kind":12},{"containerName":"_from_gff3_string","name":"$start","line":618,"kind":13},{"kind":13,"line":619,"containerName":"_from_gff3_string","name":"$feat"},{"containerName":"_from_gff3_string","name":"end","line":619,"kind":12},{"containerName":"_from_gff3_string","name":"$end","line":619,"kind":13},{"name":"$feat","containerName":"_from_gff3_string","line":620,"kind":13},{"kind":12,"line":620,"containerName":"_from_gff3_string","name":"frame"},{"kind":13,"line":620,"name":"$frame","containerName":"_from_gff3_string"},{"name":"$score","containerName":"_from_gff3_string","line":621,"kind":13},{"line":624,"kind":13,"name":"$feat","containerName":"_from_gff3_string"},{"containerName":"_from_gff3_string","name":"score","kind":12,"line":624},{"name":"$score","containerName":"_from_gff3_string","kind":13,"line":624},{"name":"$strand","containerName":"_from_gff3_string","line":626,"kind":13},{"containerName":"_from_gff3_string","name":"$feat","line":626,"kind":13},{"line":626,"kind":12,"name":"strand","containerName":"_from_gff3_string"},{"line":627,"kind":13,"name":"$strand","containerName":"_from_gff3_string"},{"kind":13,"line":627,"name":"$feat","containerName":"_from_gff3_string"},{"name":"strand","containerName":"_from_gff3_string","line":627,"kind":12},{"name":"$strand","containerName":"_from_gff3_string","kind":13,"line":628},{"containerName":"_from_gff3_string","name":"$feat","line":628,"kind":13},{"containerName":"_from_gff3_string","name":"strand","line":628,"kind":12},{"kind":13,"line":629,"definition":"my","name":"@groups","containerName":"_from_gff3_string","localvar":"my"},{"containerName":"_from_gff3_string","name":"$groups","kind":13,"line":629},{"localvar":"my","containerName":"_from_gff3_string","name":"$group","definition":"my","line":631,"kind":13},{"name":"@groups","containerName":"_from_gff3_string","line":631,"kind":13},{"kind":13,"line":632,"definition":"my","name":"$tag","containerName":"_from_gff3_string","localvar":"my"},{"line":632,"kind":13,"name":"$value","containerName":"_from_gff3_string"},{"line":632,"kind":13,"name":"$group","containerName":"_from_gff3_string"},{"line":633,"kind":13,"containerName":"_from_gff3_string","name":"$tag"},{"kind":13,"line":633,"containerName":"_from_gff3_string","name":"$tag"},{"kind":13,"line":634,"name":"@values","definition":"my","containerName":"_from_gff3_string","localvar":"my"},{"name":"$value","containerName":"_from_gff3_string","line":634,"kind":13},{"kind":13,"line":635,"containerName":"_from_gff3_string","name":"$v","definition":"my","localvar":"my"},{"line":635,"kind":13,"containerName":"_from_gff3_string","name":"@values"},{"name":"$feat","containerName":"_from_gff3_string","line":635,"kind":13},{"name":"add_tag_value","containerName":"_from_gff3_string","kind":12,"line":635},{"kind":13,"line":635,"name":"$tag","containerName":"_from_gff3_string"},{"containerName":"_from_gff3_string","name":"$v","line":635,"kind":13}],"line":601},{"line":633,"kind":12,"name":"unescape"},{"name":"unescape","line":634,"kind":12},{"range":{"end":{"line":645,"character":9999},"start":{"character":0,"line":640}},"definition":"sub","name":"unescape","containerName":"main::","children":[{"line":641,"kind":13,"localvar":"my","containerName":"unescape","name":"$v","definition":"my"},{"containerName":"unescape","name":"$v","line":642,"kind":13},{"line":643,"kind":13,"containerName":"unescape","name":"$v"},{"containerName":"unescape","name":"$v","line":644,"kind":13}],"line":640,"kind":12},{"range":{"start":{"character":0,"line":658},"end":{"line":668,"character":9999}},"name":"write_feature","signature":{"label":"write_feature($self,@features)","parameters":[{"label":"$self"},{"label":"@features"}],"documentation":"1;\n# $Id: GFF.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::GFF\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by the Bioperl core team\n#\n# Copyright Matthew Pocock\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::GFF - A Bio::SeqAnalysisParserI compliant GFF format parser\n\n=head1 SYNOPSIS\n\n    use Bio::Tools::GFF;\n\n    # specify input via -fh or -file\n    my $gffio = Bio::Tools::GFF->new(-fh => \\*STDIN, -gff_version => 2);\n    my $feature;\n    # loop over the input stream\n    while($feature = $gffio->next_feature()) {\n        # do something with feature\n    }\n    $gffio->close();\n\n    # you can also obtain a GFF parser as a SeqAnalasisParserI in\n    # HT analysis pipelines (see Bio::SeqAnalysisParserI and\n    # Bio::Factory::SeqAnalysisParserFactory)\n    my $factory = Bio::Factory::SeqAnalysisParserFactory->new();\n    my $parser = $factory->get_parser(-input => \\*STDIN, -method => \"gff\");\n    while($feature = $parser->next_feature()) {\n        # do something with feature\n    }\n\n=head1 DESCRIPTION\n\nThis class provides a simple GFF parser and writer. In the sense of a\nSeqAnalysisParser, it parses an input file or stream into SeqFeatureI\nobjects, but is not in any way specific to a particular analysis\nprogram and the output that program produces.\n\nThat is, if you can get your analysis program spit out GFF, here is\nyour result parser.\n\n=head1 GFF3 AND SEQUENCE DATA\n\nGFF3 supports sequence data; see\n\nhttp://www.sequenceontology.org/gff3.shtml\n\nThere are a number of ways to deal with this -\n\nIf you call\n\n  $gffio->ignore_sequence(1)\n\nprior to parsing the sequence data is ignored; this is useful if you\njust want the features. It avoids the memory overhead in building and\ncaching sequences\n\nAlternatively, you can call either\n\n  $gffio->get_seqs()\n\nOr\n\n  $gffio->seq_id_by_h()\n\nAt the B<end> of parsing to get either a list or hashref of Bio::Seq\nobjects (see the documentation for each of these methods)\n\nNote that these objects will not have the features attached - you have\nto do this yourself, OR call\n\n  $gffio->features_attached_to_seqs(1)\n\nPRIOR to parsing; this will ensure that the Seqs have the features\nattached; ie you will then be able to call\n\n  $seq->get_SeqFeatures();\n\nAnd use Bio::SeqIO methods\n\nNote that auto-attaching the features to seqs will incur a higher\nmemory overhead as the features must be cached until the sequence data\nis found\n\n=head1 TODO\n\nMake a Bio::SeqIO class specifically for GFF3 with sequence data\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Matthew Pocock\n\nEmail mrp-at-sanger.ac.uk\n\n=head1 CONTRIBUTORS \n\nJason Stajich, jason-at-biperl-dot-org\nChris Mungall, cjm-at-fruitfly-dot-org\nSteffen Grossmann [SG], grossman at molgen.mpg.de\nMalcolm Cook, mec-at-stowers-institute.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tools::GFF;\n\nuse vars qw($HAS_HTML_ENTITIES);\nuse strict;\n\nuse Bio::Seq::SeqFactory;\nuse Bio::LocatableSeq;\nuse Bio::SeqFeature::Generic;\n\nuse base qw(Bio::Root::Root Bio::SeqAnalysisParserI Bio::Root::IO);\n\nmy $i = 0;\nmy %GFF3_ID_Tags = map { $_ => $i++ } qw(ID Parent Target);\n\n=head2 new\n\n Title   : new\n Usage   : my $parser = Bio::Tools::GFF->new(-gff_version => 2,\n\t\t\t\t\t    -file        => \"filename.gff\");\n           or\n           my $writer = Bio::Tools::GFF->new(-gff_version => 3,\n\t\t\t\t\t    -file        => \">filename.gff3\");\n Function: Creates a new instance. Recognized named parameters are -file, -fh,\n           and -gff_version.\n Returns : a new object\n Args    : named parameters\n           -gff_version => [1,2,3]\n\n\n\n{   # make a class variable such that we can generate unique ID's over\n    # a session, no matter how many instances of GFF.pm we make\n    # since these have to be unique within the scope of a GFF file.\n    \n    my $gff3_featureID = 0;\n    \n    sub _incrementGFF3ID {\n        my ($self) = @_;\n        return ++ $gff3_featureID;\n    }\n}\n\n\nsub new {\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n  \n  my ($gff_version, $noparse) = $self->_rearrange([qw(GFF_VERSION NOPARSE)],@args);\n\n  # initialize IO\n  $self->_initialize_io(@args);\n  $self->_parse_header() unless $noparse;\n\n  $gff_version ||= 2;\n  if( ! $self->gff_version($gff_version) )  {\n      $self->throw(\"Can't build a GFF object with the unknown version \".\n\t\t   $gff_version);\n  }\n  $self->{'_first'} = 1;\n  return $self;\n}\n\n=head2 _parse_header\n\n Title   : _parse_header\n Usage   : $gffio->_parse_header()\n Function: used to turn parse GFF header lines.  currently\n           produces Bio::LocatableSeq objects from ##sequence-region\n           lines\n Returns : 1 on success\n Args    : none\n\n\n\nsub _parse_header{\n   my ($self) = @_;\n\n   my @unhandled;\n   local $^W = 0; # hide warnings when we try and parse from a file opened\n                  # for writing - there isn't really a better way to do\n                  # AFAIK - cannot detech if a FH is read or write.\n   while(my $line = $self->_readline()){\n \t my $handled = 0;\n\t next if /^\\s+$/;\n\t if($line =~ /^\\#\\#sequence-region\\s+(\\S+)\\s+(\\S+)\\s+(\\S+)\\s*/){\n\t   my($seqid,$start,$end) = ($1,$2,$3);\n\t   push @{ $self->{'segments'} }, Bio::LocatableSeq->new\n\t       (\n\t\t-id    => unescape($seqid),\n\t\t-start => $start,\n\t\t-end   => $end,\n                -length => ($end - $start + 1),  ## make the length explicit\n\t\t);\n\t   $handled = 1;\n\t } elsif($line =~ /^(\\#\\#feature-ontology)/) {\n\t   #to be implemented\n\t   $self->warn(\"$1 header tag parsing unimplemented\");\n\t } elsif($line =~ /^(\\#\\#attribute-ontology)/) {\n\t   #to be implemented\n\t   $self->warn(\"$1 header tag parsing unimplemented\");\n\t } elsif($line =~ /^(\\#\\#source-ontology)/) {\n\t   #to be implemented\n\t   $self->warn(\"$1 header tag parsing unimplemented\");\n\t } elsif($line =~ /^(\\#\\#\\#)/) {\n\t   #to be implemented\n\t   $self->warn(\"$1 header tag parsing unimplemented\");\n\t } elsif($line =~ /^(\\#\\#FASTA)/) {\n            # initial ##FASTA is optional - artemis does not use it\n            $line = $self->_readline();\n            if ($line !~ /^\\>(\\S+)/) {\n                $self->throw(\"##FASTA directive must be followed by fasta header, not: $line\");\n            }\n\t } else {\n         }\n         \n         if ($line =~ /^\\>(.*)/) {\n             # seq data can be at header or footer\n             my $seq = $self->_parse_sequence($line);\n             if ($seq) {\n                 $self->_seq_by_id_h->{$seq->primary_id} = $seq;\n             }\n         }\n             \n\n \t if(!$handled){\n\t   push @unhandled, $line\n \t }\n\n\t #looks like the header is over!\n\t last unless $line =~ /^\\#/;\n   }\n\n   foreach my $line (@unhandled){\n\t $self->_pushback($line);\n   }\n\n   return 1;\n}\n\nsub _parse_sequence {\n    my ($self, $line) = @_;\n\n    if ($line =~ /^\\>(.*)/) {\n        \n        my $seqid = $1;\n        $seqid =~ s/\\s+$//;\n        my $desc = '';\n        if ($seqid =~ /(\\S+)\\s+(.*)/) {\n            ($seqid, $desc) = ($1,$2);\n        }\n        my $res = '';\n        while (my $line = $self->_readline) {\n            if ($line =~ /^\\#/) {\n                last;\n            }\n            if ($line =~ /^\\>/) {\n                $self->_pushback($line);\n                last;\n            }\n            $line =~ s/\\s//g;\n            $res .= $line;\n        }\n        return if $self->ignore_sequence;\n\n        my $seqfactory = Bio::Seq::SeqFactory->new('Bio::Seq');\n        my $seq = $seqfactory->create(-seq=>$res, \n                                      -id=>$seqid,\n                                      -desc=>$desc);\n        $seq->accession_number($seqid);\n        if ($self->features_attached_to_seqs) {\n            my @feats = \n              @{$self->_feature_idx_by_seq_id->{$seqid}};\n            $seq->add_SeqFeature($_) foreach @feats;\n            @{$self->_feature_idx_by_seq_id->{$seqid}} = ();\n        }\n        return $seq;\n    }\n    else {\n        $self->throw(\"expected fasta header, not: $line\");\n    }\n}\n\n\n=head2 next_segment\n\n Title   : next_segment\n Usage   : my $seq = $gffio->next_segment;\n Function: Returns a Bio::LocatableSeq object corresponding to a \n           GFF \"##sequence-region\" header line.\n Example :\n Returns : A Bio::LocatableSeq object, or undef if\n           there are no more sequences.\n Args    : none\n\n\n\nsub next_segment{\n   my ($self,@args) = @_;\n   return shift @{ $self->{'segments'} } if defined $self->{'segments'};\n   return;\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : $seqfeature = $gffio->next_feature();\n Function: Returns the next feature available in the input file or stream, or\n           undef if there are no more features.\n Example :\n Returns : A Bio::SeqFeatureI implementing object, or undef if there are no\n           more features.\n Args    : none    \n\n\nsub next_feature {\n    my ($self) = @_;\n    \n    my $gff_string;\n    \n    # be graceful about empty lines or comments, and make sure we return undef\n    # if the input's consumed\n    while(($gff_string = $self->_readline()) && defined($gff_string)) {\t\n        if ($gff_string =~ /^\\#\\#\\#/) {\n            # all forward refs have been seen; TODO\n        }\n        next if($gff_string =~ /^\\#/ || $gff_string =~ /^\\s*$/ ||\n                $gff_string =~ m{^//});\n\n        while ($gff_string =~ /^\\>(.+)/) {\n            # fasta can be in header or footer\n            my $seq = $self->_parse_sequence($gff_string);\n            if ($seq) {\n                $self->_seq_by_id_h->{$seq->primary_id} = $seq;\n                $gff_string = $self->_readline;\n                last unless $gff_string;\n            }\n        }\n        last; \n    }\n    return unless $gff_string;\n\n    my $feat = Bio::SeqFeature::Generic->new();\n    $self->from_gff_string($feat, $gff_string);\n\n    if ($self->features_attached_to_seqs) {\n        push(@{$self->_feature_idx_by_seq_id->{$feat->seq_id}},\n             $feat);\n    }\n\n    return $feat;\n}\n\nsub _feature_idx_by_seq_id {\n    my $self = shift;\n    $self->{__feature_idx_by_seq_id} = shift if @_;\n    $self->{__feature_idx_by_seq_id} = {}\n      unless $self->{__feature_idx_by_seq_id};\n    return $self->{__feature_idx_by_seq_id};\n}\n\n\n=head2 from_gff_string\n\n Title   : from_gff_string\n Usage   : $gff->from_gff_string($feature, $gff_string);\n Function: Sets properties of a SeqFeatureI object from a GFF-formatted\n           string. Interpretation of the string depends on the version\n           that has been specified at initialization.\n\n           This method is used by next_feature(). It actually dispatches to\n           one of the version-specific (private) methods.\n Example :\n Returns : void\n Args    : A Bio::SeqFeatureI implementing object to be initialized\n           The GFF-formatted string to initialize it from\n\n\nsub from_gff_string {\n    my ($self, $feat, $gff_string) = @_;\n\n    if($self->gff_version() == 1)  {\n\treturn $self->_from_gff1_string($feat, $gff_string);\n    } elsif( $self->gff_version() == 3 ) {\n\treturn $self->_from_gff3_string($feat, $gff_string);\n    } else {\n\treturn $self->_from_gff2_string($feat, $gff_string);\n    }\n}\n\n=head2 _from_gff1_string\n\n Title   : _from_gff1_string\n Usage   :\n Function:\n Example :\n Returns : void\n Args    : A Bio::SeqFeatureI implementing object to be initialized\n           The GFF-formatted string to initialize it from\n\n\nsub _from_gff1_string {\n   my ($gff, $feat, $string) = @_;\n   chomp $string;\n   my ($seqname, $source, $primary, $start, $end, $score, \n       $strand, $frame, @group) = split(/\\t/, $string);\n\n   if ( !defined $frame ) {\n       $feat->throw(\"[$string] does not look like GFF to me\");\n   }\n   $frame = 0 unless( $frame =~ /^\\d+$/);\n   $feat->seq_id($seqname);\n   $feat->source_tag($source);\n   $feat->primary_tag($primary);\n   $feat->start($start);\n   $feat->end($end);\n   $feat->frame($frame);\n   if ( $score eq '.' ) {\n       #$feat->score(undef);\n   } else {\n       $feat->score($score);\n   }\n   if ( $strand eq '-' ) { $feat->strand(-1); }\n   if ( $strand eq '+' ) { $feat->strand(1); }\n   if ( $strand eq '.' ) { $feat->strand(0); }\n   foreach my $g ( @group ) {\n       if ( $g =~ /(\\S+)=(\\S+)/ ) {\n\t   my $tag = $1;\n\t   my $value = $2;\n\t   $feat->add_tag_value($1, $2);\n       } else {\n\t   $feat->add_tag_value('group', $g);\n       }\n   }\n}\n\n=head2 _from_gff2_string\n\n Title   : _from_gff2_string\n Usage   :\n Function:\n Example :\n Returns : void\n Args    : A Bio::SeqFeatureI implementing object to be initialized\n           The GFF2-formatted string to initialize it from\n\n\n\nsub _from_gff2_string {\n   my ($gff, $feat, $string) = @_;\n   chomp($string);\n\n   # according to the Sanger website, GFF2 should be single-tab\n   # separated elements, and the free-text at the end should contain\n   # text-translated tab symbols but no \"real\" tabs, so splitting on\n   # \\t is safe, and $attribs gets the entire attributes field to be\n   # parsed later\n   \n   # sendu: but the tag value pair can (should?) be separated by a tab. The\n   # 'no tabs' thing seems to apply only to the free text that is allowed for\n   # the value\n\n   my ($seqname, $source, $primary, $start, \n       $end, $score, $strand, $frame, @attribs) = split(/\\t+/, $string);\n   my $attribs = join ' ', @attribs;\n   \n   if ( !defined $frame ) {\n       $feat->throw(\"[$string] does not look like GFF2 to me\");\n   }\n   $feat->seq_id($seqname);\n   $feat->source_tag($source);\n   $feat->primary_tag($primary);\n   $feat->start($start);\n   $feat->end($end);\n   $feat->frame($frame);\n   if ( $score eq '.' ) {\n       # $feat->score(undef);\n   } else {\n       $feat->score($score);\n   }\n   if ( $strand eq '-' ) { $feat->strand(-1); }\n   if ( $strand eq '+' ) { $feat->strand(1); }\n   if ( $strand eq '.' ) { $feat->strand(0); }\n\n\n   #  <Begin Inefficient Code from Mark Wilkinson> \n   # this routine is necessay to allow the presence of semicolons in\n   # quoted text Semicolons are the delimiting character for new\n   # tag/value attributes.  it is more or less a \"state\" machine, with\n   # the \"quoted\" flag going up and down as we pass thorugh quotes to\n   # distinguish free-text semicolon and hash symbols from GFF control\n   # characters\n   \n   \n   my $flag = 0; # this could be changed to a bit and just be twiddled\n   my @parsed;\n\n   # run through each character one at a time and check it\n   # NOTE: changed to foreach loop which is more efficient in perl\n   # --jasons\n   for my $a ( split //, $attribs ) { \n       # flag up on entering quoted text, down on leaving it\n       if( $a eq '\"') { $flag = ( $flag == 0 ) ? 1:0 }\n       elsif( $a eq ';' && $flag ) { $a = \"INSERT_SEMICOLON_HERE\"}\n       elsif( $a eq '#' && ! $flag ) { last } \n       push @parsed, $a;\n   }\n   $attribs = join \"\", @parsed; # rejoin into a single string\n\n   # <End Inefficient Code>   \n   # Please feel free to fix this and make it more \"perlish\"\n\n   my @key_vals = split /;/, $attribs;   # attributes are semicolon-delimited\n\n   foreach my $pair ( @key_vals ) {\n       # replace semicolons that were removed from free-text above.\n       $pair =~ s/INSERT_SEMICOLON_HERE/;/g;        \n\n       # separate the key from the value\n       my ($blank, $key, $values) = split  /^\\s*([\\w\\d]+)\\s/, $pair; \n\n\n       if( defined $values ) {\n\t   my @values;\n\t   # free text is quoted, so match each free-text block\n\t   # and remove it from the $values string\n\t   while ($values =~ s/\"(.*?)\"//){\n\t       # and push it on to the list of values (tags may have\n\t       # more than one value... and the value may be undef)\t       \n\t       push @values, $1;\n\t   }\n\n\t   # and what is left over should be space-separated\n\t   # non-free-text values\n\n\t   my @othervals = split /\\s+/, $values;  \n\t   foreach my $othervalue(@othervals){\n\t       # get rid of any empty strings which might \n\t       # result from the split\n\t       if (CORE::length($othervalue) > 0) {push @values, $othervalue}  \n\t   }\n\n\t   foreach my $value(@values){\n\t       $feat->add_tag_value($key, $value);\n\t   }\n       }\n   }\n}\n\n\nsub _from_gff3_string {\n    my ($gff, $feat, $string) = @_;\n    chomp($string);\n\n    # according to the now nearly final GFF3 spec, columns should \n    # be tab separated, allowing unescaped spaces to occur in\n    # column 9\n\n    my ($seqname, $source, $primary, $start, $end, \n\t$score, $strand, $frame, $groups) = split(/\\t/, $string);\n    \n    if ( ! defined $frame ) {\n\t$feat->throw(\"[$string] does not look like GFF3 to me\");\n    }\n    $feat->seq_id($seqname);\n    $feat->source_tag($source);\n    $feat->primary_tag($primary);\n    $feat->start($start);\n    $feat->end($end);\n    $feat->frame($frame);\n    if ( $score eq '.' ) {\n\t#$feat->score(undef);\n    } else {\n\t$feat->score($score);\n    }\n    if ( $strand eq '-' ) { $feat->strand(-1); }\n    if ( $strand eq '+' ) { $feat->strand(1); }\n    if ( $strand eq '.' ) { $feat->strand(0); }\n    my @groups = split(/\\s*;\\s*/, $groups);\n\n    for my $group (@groups) {\n\tmy ($tag,$value) = split /=/,$group;\n\t$tag             = unescape($tag);\n\tmy @values       = map {unescape($_)} split /,/,$value;\n\tfor my $v ( @values ) {  $feat->add_tag_value($tag,$v); }\n    }\n}\n\n# taken from Bio::DB::GFF\nsub unescape {\n  my $v = shift;\n  $v =~ tr/+/ /;\n  $v =~ s/%([0-9a-fA-F]{2})/chr hex($1)/ge;\n  return $v;\n}\n\n=head2 write_feature\n\n Title   : write_feature\n Usage   : $gffio->write_feature($feature);\n Function: Writes the specified SeqFeatureI object in GFF format to the stream\n           associated with this instance.\n Returns : none\n Args    : An array of Bio::SeqFeatureI implementing objects to be serialized"},"detail":"($self,@features)","definition":"sub","containerName":"main::","children":[{"line":659,"kind":13,"localvar":"my","containerName":"write_feature","name":"$self","definition":"my"},{"line":659,"kind":13,"containerName":"write_feature","name":"@features"},{"containerName":"write_feature","name":"@features","line":660,"kind":13},{"line":661,"kind":13,"name":"$self","containerName":"write_feature"},{"kind":13,"line":661,"name":"$self","containerName":"write_feature"},{"containerName":"write_feature","name":"gff_version","kind":12,"line":661},{"line":662,"kind":13,"containerName":"write_feature","name":"$self"},{"kind":12,"line":662,"name":"_print","containerName":"write_feature"},{"containerName":"write_feature","name":"$self","kind":13,"line":664},{"localvar":"my","definition":"my","name":"$feature","containerName":"write_feature","line":665,"kind":13},{"line":665,"kind":13,"name":"@features","containerName":"write_feature"},{"line":666,"kind":13,"name":"$self","containerName":"write_feature"},{"kind":12,"line":666,"name":"_print","containerName":"write_feature"},{"kind":13,"line":666,"containerName":"write_feature","name":"$self"},{"name":"gff_string","containerName":"write_feature","kind":12,"line":666},{"kind":13,"line":666,"name":"$feature","containerName":"write_feature"}],"line":658,"kind":12},{"containerName":"main::","definition":"sub","detail":"($self,$feature)","signature":{"documentation":"1;\n# $Id: GFF.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::GFF\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by the Bioperl core team\n#\n# Copyright Matthew Pocock\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::GFF - A Bio::SeqAnalysisParserI compliant GFF format parser\n\n=head1 SYNOPSIS\n\n    use Bio::Tools::GFF;\n\n    # specify input via -fh or -file\n    my $gffio = Bio::Tools::GFF->new(-fh => \\*STDIN, -gff_version => 2);\n    my $feature;\n    # loop over the input stream\n    while($feature = $gffio->next_feature()) {\n        # do something with feature\n    }\n    $gffio->close();\n\n    # you can also obtain a GFF parser as a SeqAnalasisParserI in\n    # HT analysis pipelines (see Bio::SeqAnalysisParserI and\n    # Bio::Factory::SeqAnalysisParserFactory)\n    my $factory = Bio::Factory::SeqAnalysisParserFactory->new();\n    my $parser = $factory->get_parser(-input => \\*STDIN, -method => \"gff\");\n    while($feature = $parser->next_feature()) {\n        # do something with feature\n    }\n\n=head1 DESCRIPTION\n\nThis class provides a simple GFF parser and writer. In the sense of a\nSeqAnalysisParser, it parses an input file or stream into SeqFeatureI\nobjects, but is not in any way specific to a particular analysis\nprogram and the output that program produces.\n\nThat is, if you can get your analysis program spit out GFF, here is\nyour result parser.\n\n=head1 GFF3 AND SEQUENCE DATA\n\nGFF3 supports sequence data; see\n\nhttp://www.sequenceontology.org/gff3.shtml\n\nThere are a number of ways to deal with this -\n\nIf you call\n\n  $gffio->ignore_sequence(1)\n\nprior to parsing the sequence data is ignored; this is useful if you\njust want the features. It avoids the memory overhead in building and\ncaching sequences\n\nAlternatively, you can call either\n\n  $gffio->get_seqs()\n\nOr\n\n  $gffio->seq_id_by_h()\n\nAt the B<end> of parsing to get either a list or hashref of Bio::Seq\nobjects (see the documentation for each of these methods)\n\nNote that these objects will not have the features attached - you have\nto do this yourself, OR call\n\n  $gffio->features_attached_to_seqs(1)\n\nPRIOR to parsing; this will ensure that the Seqs have the features\nattached; ie you will then be able to call\n\n  $seq->get_SeqFeatures();\n\nAnd use Bio::SeqIO methods\n\nNote that auto-attaching the features to seqs will incur a higher\nmemory overhead as the features must be cached until the sequence data\nis found\n\n=head1 TODO\n\nMake a Bio::SeqIO class specifically for GFF3 with sequence data\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Matthew Pocock\n\nEmail mrp-at-sanger.ac.uk\n\n=head1 CONTRIBUTORS \n\nJason Stajich, jason-at-biperl-dot-org\nChris Mungall, cjm-at-fruitfly-dot-org\nSteffen Grossmann [SG], grossman at molgen.mpg.de\nMalcolm Cook, mec-at-stowers-institute.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tools::GFF;\n\nuse vars qw($HAS_HTML_ENTITIES);\nuse strict;\n\nuse Bio::Seq::SeqFactory;\nuse Bio::LocatableSeq;\nuse Bio::SeqFeature::Generic;\n\nuse base qw(Bio::Root::Root Bio::SeqAnalysisParserI Bio::Root::IO);\n\nmy $i = 0;\nmy %GFF3_ID_Tags = map { $_ => $i++ } qw(ID Parent Target);\n\n=head2 new\n\n Title   : new\n Usage   : my $parser = Bio::Tools::GFF->new(-gff_version => 2,\n\t\t\t\t\t    -file        => \"filename.gff\");\n           or\n           my $writer = Bio::Tools::GFF->new(-gff_version => 3,\n\t\t\t\t\t    -file        => \">filename.gff3\");\n Function: Creates a new instance. Recognized named parameters are -file, -fh,\n           and -gff_version.\n Returns : a new object\n Args    : named parameters\n           -gff_version => [1,2,3]\n\n\n\n{   # make a class variable such that we can generate unique ID's over\n    # a session, no matter how many instances of GFF.pm we make\n    # since these have to be unique within the scope of a GFF file.\n    \n    my $gff3_featureID = 0;\n    \n    sub _incrementGFF3ID {\n        my ($self) = @_;\n        return ++ $gff3_featureID;\n    }\n}\n\n\nsub new {\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n  \n  my ($gff_version, $noparse) = $self->_rearrange([qw(GFF_VERSION NOPARSE)],@args);\n\n  # initialize IO\n  $self->_initialize_io(@args);\n  $self->_parse_header() unless $noparse;\n\n  $gff_version ||= 2;\n  if( ! $self->gff_version($gff_version) )  {\n      $self->throw(\"Can't build a GFF object with the unknown version \".\n\t\t   $gff_version);\n  }\n  $self->{'_first'} = 1;\n  return $self;\n}\n\n=head2 _parse_header\n\n Title   : _parse_header\n Usage   : $gffio->_parse_header()\n Function: used to turn parse GFF header lines.  currently\n           produces Bio::LocatableSeq objects from ##sequence-region\n           lines\n Returns : 1 on success\n Args    : none\n\n\n\nsub _parse_header{\n   my ($self) = @_;\n\n   my @unhandled;\n   local $^W = 0; # hide warnings when we try and parse from a file opened\n                  # for writing - there isn't really a better way to do\n                  # AFAIK - cannot detech if a FH is read or write.\n   while(my $line = $self->_readline()){\n \t my $handled = 0;\n\t next if /^\\s+$/;\n\t if($line =~ /^\\#\\#sequence-region\\s+(\\S+)\\s+(\\S+)\\s+(\\S+)\\s*/){\n\t   my($seqid,$start,$end) = ($1,$2,$3);\n\t   push @{ $self->{'segments'} }, Bio::LocatableSeq->new\n\t       (\n\t\t-id    => unescape($seqid),\n\t\t-start => $start,\n\t\t-end   => $end,\n                -length => ($end - $start + 1),  ## make the length explicit\n\t\t);\n\t   $handled = 1;\n\t } elsif($line =~ /^(\\#\\#feature-ontology)/) {\n\t   #to be implemented\n\t   $self->warn(\"$1 header tag parsing unimplemented\");\n\t } elsif($line =~ /^(\\#\\#attribute-ontology)/) {\n\t   #to be implemented\n\t   $self->warn(\"$1 header tag parsing unimplemented\");\n\t } elsif($line =~ /^(\\#\\#source-ontology)/) {\n\t   #to be implemented\n\t   $self->warn(\"$1 header tag parsing unimplemented\");\n\t } elsif($line =~ /^(\\#\\#\\#)/) {\n\t   #to be implemented\n\t   $self->warn(\"$1 header tag parsing unimplemented\");\n\t } elsif($line =~ /^(\\#\\#FASTA)/) {\n            # initial ##FASTA is optional - artemis does not use it\n            $line = $self->_readline();\n            if ($line !~ /^\\>(\\S+)/) {\n                $self->throw(\"##FASTA directive must be followed by fasta header, not: $line\");\n            }\n\t } else {\n         }\n         \n         if ($line =~ /^\\>(.*)/) {\n             # seq data can be at header or footer\n             my $seq = $self->_parse_sequence($line);\n             if ($seq) {\n                 $self->_seq_by_id_h->{$seq->primary_id} = $seq;\n             }\n         }\n             \n\n \t if(!$handled){\n\t   push @unhandled, $line\n \t }\n\n\t #looks like the header is over!\n\t last unless $line =~ /^\\#/;\n   }\n\n   foreach my $line (@unhandled){\n\t $self->_pushback($line);\n   }\n\n   return 1;\n}\n\nsub _parse_sequence {\n    my ($self, $line) = @_;\n\n    if ($line =~ /^\\>(.*)/) {\n        \n        my $seqid = $1;\n        $seqid =~ s/\\s+$//;\n        my $desc = '';\n        if ($seqid =~ /(\\S+)\\s+(.*)/) {\n            ($seqid, $desc) = ($1,$2);\n        }\n        my $res = '';\n        while (my $line = $self->_readline) {\n            if ($line =~ /^\\#/) {\n                last;\n            }\n            if ($line =~ /^\\>/) {\n                $self->_pushback($line);\n                last;\n            }\n            $line =~ s/\\s//g;\n            $res .= $line;\n        }\n        return if $self->ignore_sequence;\n\n        my $seqfactory = Bio::Seq::SeqFactory->new('Bio::Seq');\n        my $seq = $seqfactory->create(-seq=>$res, \n                                      -id=>$seqid,\n                                      -desc=>$desc);\n        $seq->accession_number($seqid);\n        if ($self->features_attached_to_seqs) {\n            my @feats = \n              @{$self->_feature_idx_by_seq_id->{$seqid}};\n            $seq->add_SeqFeature($_) foreach @feats;\n            @{$self->_feature_idx_by_seq_id->{$seqid}} = ();\n        }\n        return $seq;\n    }\n    else {\n        $self->throw(\"expected fasta header, not: $line\");\n    }\n}\n\n\n=head2 next_segment\n\n Title   : next_segment\n Usage   : my $seq = $gffio->next_segment;\n Function: Returns a Bio::LocatableSeq object corresponding to a \n           GFF \"##sequence-region\" header line.\n Example :\n Returns : A Bio::LocatableSeq object, or undef if\n           there are no more sequences.\n Args    : none\n\n\n\nsub next_segment{\n   my ($self,@args) = @_;\n   return shift @{ $self->{'segments'} } if defined $self->{'segments'};\n   return;\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : $seqfeature = $gffio->next_feature();\n Function: Returns the next feature available in the input file or stream, or\n           undef if there are no more features.\n Example :\n Returns : A Bio::SeqFeatureI implementing object, or undef if there are no\n           more features.\n Args    : none    \n\n\nsub next_feature {\n    my ($self) = @_;\n    \n    my $gff_string;\n    \n    # be graceful about empty lines or comments, and make sure we return undef\n    # if the input's consumed\n    while(($gff_string = $self->_readline()) && defined($gff_string)) {\t\n        if ($gff_string =~ /^\\#\\#\\#/) {\n            # all forward refs have been seen; TODO\n        }\n        next if($gff_string =~ /^\\#/ || $gff_string =~ /^\\s*$/ ||\n                $gff_string =~ m{^//});\n\n        while ($gff_string =~ /^\\>(.+)/) {\n            # fasta can be in header or footer\n            my $seq = $self->_parse_sequence($gff_string);\n            if ($seq) {\n                $self->_seq_by_id_h->{$seq->primary_id} = $seq;\n                $gff_string = $self->_readline;\n                last unless $gff_string;\n            }\n        }\n        last; \n    }\n    return unless $gff_string;\n\n    my $feat = Bio::SeqFeature::Generic->new();\n    $self->from_gff_string($feat, $gff_string);\n\n    if ($self->features_attached_to_seqs) {\n        push(@{$self->_feature_idx_by_seq_id->{$feat->seq_id}},\n             $feat);\n    }\n\n    return $feat;\n}\n\nsub _feature_idx_by_seq_id {\n    my $self = shift;\n    $self->{__feature_idx_by_seq_id} = shift if @_;\n    $self->{__feature_idx_by_seq_id} = {}\n      unless $self->{__feature_idx_by_seq_id};\n    return $self->{__feature_idx_by_seq_id};\n}\n\n\n=head2 from_gff_string\n\n Title   : from_gff_string\n Usage   : $gff->from_gff_string($feature, $gff_string);\n Function: Sets properties of a SeqFeatureI object from a GFF-formatted\n           string. Interpretation of the string depends on the version\n           that has been specified at initialization.\n\n           This method is used by next_feature(). It actually dispatches to\n           one of the version-specific (private) methods.\n Example :\n Returns : void\n Args    : A Bio::SeqFeatureI implementing object to be initialized\n           The GFF-formatted string to initialize it from\n\n\nsub from_gff_string {\n    my ($self, $feat, $gff_string) = @_;\n\n    if($self->gff_version() == 1)  {\n\treturn $self->_from_gff1_string($feat, $gff_string);\n    } elsif( $self->gff_version() == 3 ) {\n\treturn $self->_from_gff3_string($feat, $gff_string);\n    } else {\n\treturn $self->_from_gff2_string($feat, $gff_string);\n    }\n}\n\n=head2 _from_gff1_string\n\n Title   : _from_gff1_string\n Usage   :\n Function:\n Example :\n Returns : void\n Args    : A Bio::SeqFeatureI implementing object to be initialized\n           The GFF-formatted string to initialize it from\n\n\nsub _from_gff1_string {\n   my ($gff, $feat, $string) = @_;\n   chomp $string;\n   my ($seqname, $source, $primary, $start, $end, $score, \n       $strand, $frame, @group) = split(/\\t/, $string);\n\n   if ( !defined $frame ) {\n       $feat->throw(\"[$string] does not look like GFF to me\");\n   }\n   $frame = 0 unless( $frame =~ /^\\d+$/);\n   $feat->seq_id($seqname);\n   $feat->source_tag($source);\n   $feat->primary_tag($primary);\n   $feat->start($start);\n   $feat->end($end);\n   $feat->frame($frame);\n   if ( $score eq '.' ) {\n       #$feat->score(undef);\n   } else {\n       $feat->score($score);\n   }\n   if ( $strand eq '-' ) { $feat->strand(-1); }\n   if ( $strand eq '+' ) { $feat->strand(1); }\n   if ( $strand eq '.' ) { $feat->strand(0); }\n   foreach my $g ( @group ) {\n       if ( $g =~ /(\\S+)=(\\S+)/ ) {\n\t   my $tag = $1;\n\t   my $value = $2;\n\t   $feat->add_tag_value($1, $2);\n       } else {\n\t   $feat->add_tag_value('group', $g);\n       }\n   }\n}\n\n=head2 _from_gff2_string\n\n Title   : _from_gff2_string\n Usage   :\n Function:\n Example :\n Returns : void\n Args    : A Bio::SeqFeatureI implementing object to be initialized\n           The GFF2-formatted string to initialize it from\n\n\n\nsub _from_gff2_string {\n   my ($gff, $feat, $string) = @_;\n   chomp($string);\n\n   # according to the Sanger website, GFF2 should be single-tab\n   # separated elements, and the free-text at the end should contain\n   # text-translated tab symbols but no \"real\" tabs, so splitting on\n   # \\t is safe, and $attribs gets the entire attributes field to be\n   # parsed later\n   \n   # sendu: but the tag value pair can (should?) be separated by a tab. The\n   # 'no tabs' thing seems to apply only to the free text that is allowed for\n   # the value\n\n   my ($seqname, $source, $primary, $start, \n       $end, $score, $strand, $frame, @attribs) = split(/\\t+/, $string);\n   my $attribs = join ' ', @attribs;\n   \n   if ( !defined $frame ) {\n       $feat->throw(\"[$string] does not look like GFF2 to me\");\n   }\n   $feat->seq_id($seqname);\n   $feat->source_tag($source);\n   $feat->primary_tag($primary);\n   $feat->start($start);\n   $feat->end($end);\n   $feat->frame($frame);\n   if ( $score eq '.' ) {\n       # $feat->score(undef);\n   } else {\n       $feat->score($score);\n   }\n   if ( $strand eq '-' ) { $feat->strand(-1); }\n   if ( $strand eq '+' ) { $feat->strand(1); }\n   if ( $strand eq '.' ) { $feat->strand(0); }\n\n\n   #  <Begin Inefficient Code from Mark Wilkinson> \n   # this routine is necessay to allow the presence of semicolons in\n   # quoted text Semicolons are the delimiting character for new\n   # tag/value attributes.  it is more or less a \"state\" machine, with\n   # the \"quoted\" flag going up and down as we pass thorugh quotes to\n   # distinguish free-text semicolon and hash symbols from GFF control\n   # characters\n   \n   \n   my $flag = 0; # this could be changed to a bit and just be twiddled\n   my @parsed;\n\n   # run through each character one at a time and check it\n   # NOTE: changed to foreach loop which is more efficient in perl\n   # --jasons\n   for my $a ( split //, $attribs ) { \n       # flag up on entering quoted text, down on leaving it\n       if( $a eq '\"') { $flag = ( $flag == 0 ) ? 1:0 }\n       elsif( $a eq ';' && $flag ) { $a = \"INSERT_SEMICOLON_HERE\"}\n       elsif( $a eq '#' && ! $flag ) { last } \n       push @parsed, $a;\n   }\n   $attribs = join \"\", @parsed; # rejoin into a single string\n\n   # <End Inefficient Code>   \n   # Please feel free to fix this and make it more \"perlish\"\n\n   my @key_vals = split /;/, $attribs;   # attributes are semicolon-delimited\n\n   foreach my $pair ( @key_vals ) {\n       # replace semicolons that were removed from free-text above.\n       $pair =~ s/INSERT_SEMICOLON_HERE/;/g;        \n\n       # separate the key from the value\n       my ($blank, $key, $values) = split  /^\\s*([\\w\\d]+)\\s/, $pair; \n\n\n       if( defined $values ) {\n\t   my @values;\n\t   # free text is quoted, so match each free-text block\n\t   # and remove it from the $values string\n\t   while ($values =~ s/\"(.*?)\"//){\n\t       # and push it on to the list of values (tags may have\n\t       # more than one value... and the value may be undef)\t       \n\t       push @values, $1;\n\t   }\n\n\t   # and what is left over should be space-separated\n\t   # non-free-text values\n\n\t   my @othervals = split /\\s+/, $values;  \n\t   foreach my $othervalue(@othervals){\n\t       # get rid of any empty strings which might \n\t       # result from the split\n\t       if (CORE::length($othervalue) > 0) {push @values, $othervalue}  \n\t   }\n\n\t   foreach my $value(@values){\n\t       $feat->add_tag_value($key, $value);\n\t   }\n       }\n   }\n}\n\n\nsub _from_gff3_string {\n    my ($gff, $feat, $string) = @_;\n    chomp($string);\n\n    # according to the now nearly final GFF3 spec, columns should \n    # be tab separated, allowing unescaped spaces to occur in\n    # column 9\n\n    my ($seqname, $source, $primary, $start, $end, \n\t$score, $strand, $frame, $groups) = split(/\\t/, $string);\n    \n    if ( ! defined $frame ) {\n\t$feat->throw(\"[$string] does not look like GFF3 to me\");\n    }\n    $feat->seq_id($seqname);\n    $feat->source_tag($source);\n    $feat->primary_tag($primary);\n    $feat->start($start);\n    $feat->end($end);\n    $feat->frame($frame);\n    if ( $score eq '.' ) {\n\t#$feat->score(undef);\n    } else {\n\t$feat->score($score);\n    }\n    if ( $strand eq '-' ) { $feat->strand(-1); }\n    if ( $strand eq '+' ) { $feat->strand(1); }\n    if ( $strand eq '.' ) { $feat->strand(0); }\n    my @groups = split(/\\s*;\\s*/, $groups);\n\n    for my $group (@groups) {\n\tmy ($tag,$value) = split /=/,$group;\n\t$tag             = unescape($tag);\n\tmy @values       = map {unescape($_)} split /,/,$value;\n\tfor my $v ( @values ) {  $feat->add_tag_value($tag,$v); }\n    }\n}\n\n# taken from Bio::DB::GFF\nsub unescape {\n  my $v = shift;\n  $v =~ tr/+/ /;\n  $v =~ s/%([0-9a-fA-F]{2})/chr hex($1)/ge;\n  return $v;\n}\n\n=head2 write_feature\n\n Title   : write_feature\n Usage   : $gffio->write_feature($feature);\n Function: Writes the specified SeqFeatureI object in GFF format to the stream\n           associated with this instance.\n Returns : none\n Args    : An array of Bio::SeqFeatureI implementing objects to be serialized\n\n\nsub write_feature {\n    my ($self, @features) = @_;\n    return unless @features;\n    if( $self->{'_first'} && $self->gff_version() == 3 ) {\n\t$self->_print(\"##gff-version 3\\n\");\n    }\n    $self->{'_first'} = 0;\n    foreach my $feature ( @features ) {\n\t$self->_print($self->gff_string($feature).\"\\n\");\n    }\n}\n\n=head2 gff_string\n\n Title   : gff_string\n Usage   : $gffstr = $gffio->gff_string($feature);\n Function: Obtain the GFF-formatted representation of a SeqFeatureI object.\n           The formatting depends on the version specified at initialization.\n\n           This method is used by write_feature(). It actually dispatches to\n           one of the version-specific (private) methods.\n Example :\n Returns : A GFF-formatted string representation of the SeqFeature\n Args    : A Bio::SeqFeatureI implementing object to be GFF-stringified","parameters":[{"label":"$self"},{"label":"$feature"}],"label":"gff_string($self,$feature)"},"kind":12,"line":685,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"gff_string","line":686,"kind":13},{"kind":13,"line":686,"containerName":"gff_string","name":"$feature"},{"name":"$self","containerName":"gff_string","kind":13,"line":688},{"name":"gff_version","containerName":"gff_string","kind":12,"line":688},{"name":"$self","containerName":"gff_string","kind":13,"line":689},{"containerName":"gff_string","name":"_gff1_string","kind":12,"line":689},{"kind":13,"line":689,"containerName":"gff_string","name":"$feature"},{"kind":13,"line":690,"name":"$self","containerName":"gff_string"},{"kind":12,"line":690,"name":"gff_version","containerName":"gff_string"},{"kind":13,"line":691,"name":"$self","containerName":"gff_string"},{"name":"_gff3_string","containerName":"gff_string","kind":12,"line":691},{"containerName":"gff_string","name":"$feature","kind":13,"line":691},{"line":692,"kind":13,"containerName":"gff_string","name":"$self"},{"containerName":"gff_string","name":"gff_version","kind":12,"line":692},{"containerName":"gff_string","name":"$self","kind":13,"line":693},{"kind":12,"line":693,"containerName":"gff_string","name":"_gff25_string"},{"name":"$feature","containerName":"gff_string","line":693,"kind":13},{"line":695,"kind":13,"containerName":"gff_string","name":"$self"},{"name":"_gff2_string","containerName":"gff_string","kind":12,"line":695},{"kind":13,"line":695,"containerName":"gff_string","name":"$feature"}],"name":"gff_string","range":{"start":{"character":0,"line":685},"end":{"character":9999,"line":697}}},{"name":"_gff1_string","range":{"end":{"line":759,"character":9999},"start":{"character":0,"line":710}},"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$gff"},{"label":"$feat"}],"documentation":"1;\n# $Id: GFF.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::GFF\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by the Bioperl core team\n#\n# Copyright Matthew Pocock\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::GFF - A Bio::SeqAnalysisParserI compliant GFF format parser\n\n=head1 SYNOPSIS\n\n    use Bio::Tools::GFF;\n\n    # specify input via -fh or -file\n    my $gffio = Bio::Tools::GFF->new(-fh => \\*STDIN, -gff_version => 2);\n    my $feature;\n    # loop over the input stream\n    while($feature = $gffio->next_feature()) {\n        # do something with feature\n    }\n    $gffio->close();\n\n    # you can also obtain a GFF parser as a SeqAnalasisParserI in\n    # HT analysis pipelines (see Bio::SeqAnalysisParserI and\n    # Bio::Factory::SeqAnalysisParserFactory)\n    my $factory = Bio::Factory::SeqAnalysisParserFactory->new();\n    my $parser = $factory->get_parser(-input => \\*STDIN, -method => \"gff\");\n    while($feature = $parser->next_feature()) {\n        # do something with feature\n    }\n\n=head1 DESCRIPTION\n\nThis class provides a simple GFF parser and writer. In the sense of a\nSeqAnalysisParser, it parses an input file or stream into SeqFeatureI\nobjects, but is not in any way specific to a particular analysis\nprogram and the output that program produces.\n\nThat is, if you can get your analysis program spit out GFF, here is\nyour result parser.\n\n=head1 GFF3 AND SEQUENCE DATA\n\nGFF3 supports sequence data; see\n\nhttp://www.sequenceontology.org/gff3.shtml\n\nThere are a number of ways to deal with this -\n\nIf you call\n\n  $gffio->ignore_sequence(1)\n\nprior to parsing the sequence data is ignored; this is useful if you\njust want the features. It avoids the memory overhead in building and\ncaching sequences\n\nAlternatively, you can call either\n\n  $gffio->get_seqs()\n\nOr\n\n  $gffio->seq_id_by_h()\n\nAt the B<end> of parsing to get either a list or hashref of Bio::Seq\nobjects (see the documentation for each of these methods)\n\nNote that these objects will not have the features attached - you have\nto do this yourself, OR call\n\n  $gffio->features_attached_to_seqs(1)\n\nPRIOR to parsing; this will ensure that the Seqs have the features\nattached; ie you will then be able to call\n\n  $seq->get_SeqFeatures();\n\nAnd use Bio::SeqIO methods\n\nNote that auto-attaching the features to seqs will incur a higher\nmemory overhead as the features must be cached until the sequence data\nis found\n\n=head1 TODO\n\nMake a Bio::SeqIO class specifically for GFF3 with sequence data\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Matthew Pocock\n\nEmail mrp-at-sanger.ac.uk\n\n=head1 CONTRIBUTORS \n\nJason Stajich, jason-at-biperl-dot-org\nChris Mungall, cjm-at-fruitfly-dot-org\nSteffen Grossmann [SG], grossman at molgen.mpg.de\nMalcolm Cook, mec-at-stowers-institute.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tools::GFF;\n\nuse vars qw($HAS_HTML_ENTITIES);\nuse strict;\n\nuse Bio::Seq::SeqFactory;\nuse Bio::LocatableSeq;\nuse Bio::SeqFeature::Generic;\n\nuse base qw(Bio::Root::Root Bio::SeqAnalysisParserI Bio::Root::IO);\n\nmy $i = 0;\nmy %GFF3_ID_Tags = map { $_ => $i++ } qw(ID Parent Target);\n\n=head2 new\n\n Title   : new\n Usage   : my $parser = Bio::Tools::GFF->new(-gff_version => 2,\n\t\t\t\t\t    -file        => \"filename.gff\");\n           or\n           my $writer = Bio::Tools::GFF->new(-gff_version => 3,\n\t\t\t\t\t    -file        => \">filename.gff3\");\n Function: Creates a new instance. Recognized named parameters are -file, -fh,\n           and -gff_version.\n Returns : a new object\n Args    : named parameters\n           -gff_version => [1,2,3]\n\n\n\n{   # make a class variable such that we can generate unique ID's over\n    # a session, no matter how many instances of GFF.pm we make\n    # since these have to be unique within the scope of a GFF file.\n    \n    my $gff3_featureID = 0;\n    \n    sub _incrementGFF3ID {\n        my ($self) = @_;\n        return ++ $gff3_featureID;\n    }\n}\n\n\nsub new {\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n  \n  my ($gff_version, $noparse) = $self->_rearrange([qw(GFF_VERSION NOPARSE)],@args);\n\n  # initialize IO\n  $self->_initialize_io(@args);\n  $self->_parse_header() unless $noparse;\n\n  $gff_version ||= 2;\n  if( ! $self->gff_version($gff_version) )  {\n      $self->throw(\"Can't build a GFF object with the unknown version \".\n\t\t   $gff_version);\n  }\n  $self->{'_first'} = 1;\n  return $self;\n}\n\n=head2 _parse_header\n\n Title   : _parse_header\n Usage   : $gffio->_parse_header()\n Function: used to turn parse GFF header lines.  currently\n           produces Bio::LocatableSeq objects from ##sequence-region\n           lines\n Returns : 1 on success\n Args    : none\n\n\n\nsub _parse_header{\n   my ($self) = @_;\n\n   my @unhandled;\n   local $^W = 0; # hide warnings when we try and parse from a file opened\n                  # for writing - there isn't really a better way to do\n                  # AFAIK - cannot detech if a FH is read or write.\n   while(my $line = $self->_readline()){\n \t my $handled = 0;\n\t next if /^\\s+$/;\n\t if($line =~ /^\\#\\#sequence-region\\s+(\\S+)\\s+(\\S+)\\s+(\\S+)\\s*/){\n\t   my($seqid,$start,$end) = ($1,$2,$3);\n\t   push @{ $self->{'segments'} }, Bio::LocatableSeq->new\n\t       (\n\t\t-id    => unescape($seqid),\n\t\t-start => $start,\n\t\t-end   => $end,\n                -length => ($end - $start + 1),  ## make the length explicit\n\t\t);\n\t   $handled = 1;\n\t } elsif($line =~ /^(\\#\\#feature-ontology)/) {\n\t   #to be implemented\n\t   $self->warn(\"$1 header tag parsing unimplemented\");\n\t } elsif($line =~ /^(\\#\\#attribute-ontology)/) {\n\t   #to be implemented\n\t   $self->warn(\"$1 header tag parsing unimplemented\");\n\t } elsif($line =~ /^(\\#\\#source-ontology)/) {\n\t   #to be implemented\n\t   $self->warn(\"$1 header tag parsing unimplemented\");\n\t } elsif($line =~ /^(\\#\\#\\#)/) {\n\t   #to be implemented\n\t   $self->warn(\"$1 header tag parsing unimplemented\");\n\t } elsif($line =~ /^(\\#\\#FASTA)/) {\n            # initial ##FASTA is optional - artemis does not use it\n            $line = $self->_readline();\n            if ($line !~ /^\\>(\\S+)/) {\n                $self->throw(\"##FASTA directive must be followed by fasta header, not: $line\");\n            }\n\t } else {\n         }\n         \n         if ($line =~ /^\\>(.*)/) {\n             # seq data can be at header or footer\n             my $seq = $self->_parse_sequence($line);\n             if ($seq) {\n                 $self->_seq_by_id_h->{$seq->primary_id} = $seq;\n             }\n         }\n             \n\n \t if(!$handled){\n\t   push @unhandled, $line\n \t }\n\n\t #looks like the header is over!\n\t last unless $line =~ /^\\#/;\n   }\n\n   foreach my $line (@unhandled){\n\t $self->_pushback($line);\n   }\n\n   return 1;\n}\n\nsub _parse_sequence {\n    my ($self, $line) = @_;\n\n    if ($line =~ /^\\>(.*)/) {\n        \n        my $seqid = $1;\n        $seqid =~ s/\\s+$//;\n        my $desc = '';\n        if ($seqid =~ /(\\S+)\\s+(.*)/) {\n            ($seqid, $desc) = ($1,$2);\n        }\n        my $res = '';\n        while (my $line = $self->_readline) {\n            if ($line =~ /^\\#/) {\n                last;\n            }\n            if ($line =~ /^\\>/) {\n                $self->_pushback($line);\n                last;\n            }\n            $line =~ s/\\s//g;\n            $res .= $line;\n        }\n        return if $self->ignore_sequence;\n\n        my $seqfactory = Bio::Seq::SeqFactory->new('Bio::Seq');\n        my $seq = $seqfactory->create(-seq=>$res, \n                                      -id=>$seqid,\n                                      -desc=>$desc);\n        $seq->accession_number($seqid);\n        if ($self->features_attached_to_seqs) {\n            my @feats = \n              @{$self->_feature_idx_by_seq_id->{$seqid}};\n            $seq->add_SeqFeature($_) foreach @feats;\n            @{$self->_feature_idx_by_seq_id->{$seqid}} = ();\n        }\n        return $seq;\n    }\n    else {\n        $self->throw(\"expected fasta header, not: $line\");\n    }\n}\n\n\n=head2 next_segment\n\n Title   : next_segment\n Usage   : my $seq = $gffio->next_segment;\n Function: Returns a Bio::LocatableSeq object corresponding to a \n           GFF \"##sequence-region\" header line.\n Example :\n Returns : A Bio::LocatableSeq object, or undef if\n           there are no more sequences.\n Args    : none\n\n\n\nsub next_segment{\n   my ($self,@args) = @_;\n   return shift @{ $self->{'segments'} } if defined $self->{'segments'};\n   return;\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : $seqfeature = $gffio->next_feature();\n Function: Returns the next feature available in the input file or stream, or\n           undef if there are no more features.\n Example :\n Returns : A Bio::SeqFeatureI implementing object, or undef if there are no\n           more features.\n Args    : none    \n\n\nsub next_feature {\n    my ($self) = @_;\n    \n    my $gff_string;\n    \n    # be graceful about empty lines or comments, and make sure we return undef\n    # if the input's consumed\n    while(($gff_string = $self->_readline()) && defined($gff_string)) {\t\n        if ($gff_string =~ /^\\#\\#\\#/) {\n            # all forward refs have been seen; TODO\n        }\n        next if($gff_string =~ /^\\#/ || $gff_string =~ /^\\s*$/ ||\n                $gff_string =~ m{^//});\n\n        while ($gff_string =~ /^\\>(.+)/) {\n            # fasta can be in header or footer\n            my $seq = $self->_parse_sequence($gff_string);\n            if ($seq) {\n                $self->_seq_by_id_h->{$seq->primary_id} = $seq;\n                $gff_string = $self->_readline;\n                last unless $gff_string;\n            }\n        }\n        last; \n    }\n    return unless $gff_string;\n\n    my $feat = Bio::SeqFeature::Generic->new();\n    $self->from_gff_string($feat, $gff_string);\n\n    if ($self->features_attached_to_seqs) {\n        push(@{$self->_feature_idx_by_seq_id->{$feat->seq_id}},\n             $feat);\n    }\n\n    return $feat;\n}\n\nsub _feature_idx_by_seq_id {\n    my $self = shift;\n    $self->{__feature_idx_by_seq_id} = shift if @_;\n    $self->{__feature_idx_by_seq_id} = {}\n      unless $self->{__feature_idx_by_seq_id};\n    return $self->{__feature_idx_by_seq_id};\n}\n\n\n=head2 from_gff_string\n\n Title   : from_gff_string\n Usage   : $gff->from_gff_string($feature, $gff_string);\n Function: Sets properties of a SeqFeatureI object from a GFF-formatted\n           string. Interpretation of the string depends on the version\n           that has been specified at initialization.\n\n           This method is used by next_feature(). It actually dispatches to\n           one of the version-specific (private) methods.\n Example :\n Returns : void\n Args    : A Bio::SeqFeatureI implementing object to be initialized\n           The GFF-formatted string to initialize it from\n\n\nsub from_gff_string {\n    my ($self, $feat, $gff_string) = @_;\n\n    if($self->gff_version() == 1)  {\n\treturn $self->_from_gff1_string($feat, $gff_string);\n    } elsif( $self->gff_version() == 3 ) {\n\treturn $self->_from_gff3_string($feat, $gff_string);\n    } else {\n\treturn $self->_from_gff2_string($feat, $gff_string);\n    }\n}\n\n=head2 _from_gff1_string\n\n Title   : _from_gff1_string\n Usage   :\n Function:\n Example :\n Returns : void\n Args    : A Bio::SeqFeatureI implementing object to be initialized\n           The GFF-formatted string to initialize it from\n\n\nsub _from_gff1_string {\n   my ($gff, $feat, $string) = @_;\n   chomp $string;\n   my ($seqname, $source, $primary, $start, $end, $score, \n       $strand, $frame, @group) = split(/\\t/, $string);\n\n   if ( !defined $frame ) {\n       $feat->throw(\"[$string] does not look like GFF to me\");\n   }\n   $frame = 0 unless( $frame =~ /^\\d+$/);\n   $feat->seq_id($seqname);\n   $feat->source_tag($source);\n   $feat->primary_tag($primary);\n   $feat->start($start);\n   $feat->end($end);\n   $feat->frame($frame);\n   if ( $score eq '.' ) {\n       #$feat->score(undef);\n   } else {\n       $feat->score($score);\n   }\n   if ( $strand eq '-' ) { $feat->strand(-1); }\n   if ( $strand eq '+' ) { $feat->strand(1); }\n   if ( $strand eq '.' ) { $feat->strand(0); }\n   foreach my $g ( @group ) {\n       if ( $g =~ /(\\S+)=(\\S+)/ ) {\n\t   my $tag = $1;\n\t   my $value = $2;\n\t   $feat->add_tag_value($1, $2);\n       } else {\n\t   $feat->add_tag_value('group', $g);\n       }\n   }\n}\n\n=head2 _from_gff2_string\n\n Title   : _from_gff2_string\n Usage   :\n Function:\n Example :\n Returns : void\n Args    : A Bio::SeqFeatureI implementing object to be initialized\n           The GFF2-formatted string to initialize it from\n\n\n\nsub _from_gff2_string {\n   my ($gff, $feat, $string) = @_;\n   chomp($string);\n\n   # according to the Sanger website, GFF2 should be single-tab\n   # separated elements, and the free-text at the end should contain\n   # text-translated tab symbols but no \"real\" tabs, so splitting on\n   # \\t is safe, and $attribs gets the entire attributes field to be\n   # parsed later\n   \n   # sendu: but the tag value pair can (should?) be separated by a tab. The\n   # 'no tabs' thing seems to apply only to the free text that is allowed for\n   # the value\n\n   my ($seqname, $source, $primary, $start, \n       $end, $score, $strand, $frame, @attribs) = split(/\\t+/, $string);\n   my $attribs = join ' ', @attribs;\n   \n   if ( !defined $frame ) {\n       $feat->throw(\"[$string] does not look like GFF2 to me\");\n   }\n   $feat->seq_id($seqname);\n   $feat->source_tag($source);\n   $feat->primary_tag($primary);\n   $feat->start($start);\n   $feat->end($end);\n   $feat->frame($frame);\n   if ( $score eq '.' ) {\n       # $feat->score(undef);\n   } else {\n       $feat->score($score);\n   }\n   if ( $strand eq '-' ) { $feat->strand(-1); }\n   if ( $strand eq '+' ) { $feat->strand(1); }\n   if ( $strand eq '.' ) { $feat->strand(0); }\n\n\n   #  <Begin Inefficient Code from Mark Wilkinson> \n   # this routine is necessay to allow the presence of semicolons in\n   # quoted text Semicolons are the delimiting character for new\n   # tag/value attributes.  it is more or less a \"state\" machine, with\n   # the \"quoted\" flag going up and down as we pass thorugh quotes to\n   # distinguish free-text semicolon and hash symbols from GFF control\n   # characters\n   \n   \n   my $flag = 0; # this could be changed to a bit and just be twiddled\n   my @parsed;\n\n   # run through each character one at a time and check it\n   # NOTE: changed to foreach loop which is more efficient in perl\n   # --jasons\n   for my $a ( split //, $attribs ) { \n       # flag up on entering quoted text, down on leaving it\n       if( $a eq '\"') { $flag = ( $flag == 0 ) ? 1:0 }\n       elsif( $a eq ';' && $flag ) { $a = \"INSERT_SEMICOLON_HERE\"}\n       elsif( $a eq '#' && ! $flag ) { last } \n       push @parsed, $a;\n   }\n   $attribs = join \"\", @parsed; # rejoin into a single string\n\n   # <End Inefficient Code>   \n   # Please feel free to fix this and make it more \"perlish\"\n\n   my @key_vals = split /;/, $attribs;   # attributes are semicolon-delimited\n\n   foreach my $pair ( @key_vals ) {\n       # replace semicolons that were removed from free-text above.\n       $pair =~ s/INSERT_SEMICOLON_HERE/;/g;        \n\n       # separate the key from the value\n       my ($blank, $key, $values) = split  /^\\s*([\\w\\d]+)\\s/, $pair; \n\n\n       if( defined $values ) {\n\t   my @values;\n\t   # free text is quoted, so match each free-text block\n\t   # and remove it from the $values string\n\t   while ($values =~ s/\"(.*?)\"//){\n\t       # and push it on to the list of values (tags may have\n\t       # more than one value... and the value may be undef)\t       \n\t       push @values, $1;\n\t   }\n\n\t   # and what is left over should be space-separated\n\t   # non-free-text values\n\n\t   my @othervals = split /\\s+/, $values;  \n\t   foreach my $othervalue(@othervals){\n\t       # get rid of any empty strings which might \n\t       # result from the split\n\t       if (CORE::length($othervalue) > 0) {push @values, $othervalue}  \n\t   }\n\n\t   foreach my $value(@values){\n\t       $feat->add_tag_value($key, $value);\n\t   }\n       }\n   }\n}\n\n\nsub _from_gff3_string {\n    my ($gff, $feat, $string) = @_;\n    chomp($string);\n\n    # according to the now nearly final GFF3 spec, columns should \n    # be tab separated, allowing unescaped spaces to occur in\n    # column 9\n\n    my ($seqname, $source, $primary, $start, $end, \n\t$score, $strand, $frame, $groups) = split(/\\t/, $string);\n    \n    if ( ! defined $frame ) {\n\t$feat->throw(\"[$string] does not look like GFF3 to me\");\n    }\n    $feat->seq_id($seqname);\n    $feat->source_tag($source);\n    $feat->primary_tag($primary);\n    $feat->start($start);\n    $feat->end($end);\n    $feat->frame($frame);\n    if ( $score eq '.' ) {\n\t#$feat->score(undef);\n    } else {\n\t$feat->score($score);\n    }\n    if ( $strand eq '-' ) { $feat->strand(-1); }\n    if ( $strand eq '+' ) { $feat->strand(1); }\n    if ( $strand eq '.' ) { $feat->strand(0); }\n    my @groups = split(/\\s*;\\s*/, $groups);\n\n    for my $group (@groups) {\n\tmy ($tag,$value) = split /=/,$group;\n\t$tag             = unescape($tag);\n\tmy @values       = map {unescape($_)} split /,/,$value;\n\tfor my $v ( @values ) {  $feat->add_tag_value($tag,$v); }\n    }\n}\n\n# taken from Bio::DB::GFF\nsub unescape {\n  my $v = shift;\n  $v =~ tr/+/ /;\n  $v =~ s/%([0-9a-fA-F]{2})/chr hex($1)/ge;\n  return $v;\n}\n\n=head2 write_feature\n\n Title   : write_feature\n Usage   : $gffio->write_feature($feature);\n Function: Writes the specified SeqFeatureI object in GFF format to the stream\n           associated with this instance.\n Returns : none\n Args    : An array of Bio::SeqFeatureI implementing objects to be serialized\n\n\nsub write_feature {\n    my ($self, @features) = @_;\n    return unless @features;\n    if( $self->{'_first'} && $self->gff_version() == 3 ) {\n\t$self->_print(\"##gff-version 3\\n\");\n    }\n    $self->{'_first'} = 0;\n    foreach my $feature ( @features ) {\n\t$self->_print($self->gff_string($feature).\"\\n\");\n    }\n}\n\n=head2 gff_string\n\n Title   : gff_string\n Usage   : $gffstr = $gffio->gff_string($feature);\n Function: Obtain the GFF-formatted representation of a SeqFeatureI object.\n           The formatting depends on the version specified at initialization.\n\n           This method is used by write_feature(). It actually dispatches to\n           one of the version-specific (private) methods.\n Example :\n Returns : A GFF-formatted string representation of the SeqFeature\n Args    : A Bio::SeqFeatureI implementing object to be GFF-stringified\n\n\nsub gff_string{\n    my ($self, $feature) = @_;\n\n    if($self->gff_version() == 1) {\n    \treturn $self->_gff1_string($feature);\n    } elsif( $self->gff_version() == 3 ) {\n    \treturn $self->_gff3_string($feature);\n    } elsif( $self->gff_version() == 2.5 ) {\n    \treturn $self->_gff25_string($feature);\n    } else {\n    \treturn $self->_gff2_string($feature);\n    }\n}\n\n=head2 _gff1_string\n\n Title   : _gff1_string\n Usage   : $gffstr = $gffio->_gff1_string\n Function: \n Example :\n Returns : A GFF1-formatted string representation of the SeqFeature\n Args    : A Bio::SeqFeatureI implementing object to be GFF-stringified","label":"_gff1_string($gff,$feat)"},"detail":"($gff,$feat)","kind":12,"children":[{"kind":13,"line":711,"definition":"my","name":"$gff","containerName":"_gff1_string","localvar":"my"},{"kind":13,"line":711,"containerName":"_gff1_string","name":"$feat"},{"line":712,"kind":13,"localvar":"my","definition":"my","name":"$str","containerName":"_gff1_string"},{"name":"$score","containerName":"_gff1_string","kind":13,"line":712},{"containerName":"_gff1_string","name":"$frame","kind":13,"line":712},{"name":"$name","containerName":"_gff1_string","line":712,"kind":13},{"line":712,"kind":13,"containerName":"_gff1_string","name":"$strand"},{"line":714,"kind":13,"name":"$feat","containerName":"_gff1_string"},{"name":"can","containerName":"_gff1_string","line":714,"kind":12},{"name":"$score","containerName":"_gff1_string","line":715,"kind":13},{"containerName":"_gff1_string","name":"$feat","kind":13,"line":715},{"line":715,"kind":12,"name":"score","containerName":"_gff1_string"},{"name":"$score","containerName":"_gff1_string","line":717,"kind":13},{"kind":13,"line":717,"name":"$score","containerName":"_gff1_string"},{"kind":13,"line":719,"name":"$feat","containerName":"_gff1_string"},{"line":719,"kind":12,"name":"can","containerName":"_gff1_string"},{"name":"$frame","containerName":"_gff1_string","line":720,"kind":13},{"containerName":"_gff1_string","name":"$feat","kind":13,"line":720},{"kind":12,"line":720,"name":"frame","containerName":"_gff1_string"},{"kind":13,"line":722,"name":"$frame","containerName":"_gff1_string"},{"kind":13,"line":722,"name":"$frame","containerName":"_gff1_string"},{"name":"$strand","containerName":"_gff1_string","kind":13,"line":724},{"name":"$feat","containerName":"_gff1_string","line":724,"kind":13},{"kind":12,"line":724,"containerName":"_gff1_string","name":"strand"},{"name":"$strand","containerName":"_gff1_string","kind":13,"line":725},{"name":"$strand","containerName":"_gff1_string","line":726,"kind":13},{"name":"$strand","containerName":"_gff1_string","kind":13,"line":727},{"kind":13,"line":728,"containerName":"_gff1_string","name":"$strand"},{"kind":13,"line":729,"name":"$feat","containerName":"_gff1_string"},{"kind":12,"line":729,"containerName":"_gff1_string","name":"strand"},{"name":"$strand","containerName":"_gff1_string","line":730,"kind":13},{"line":733,"kind":13,"name":"$feat","containerName":"_gff1_string"},{"containerName":"_gff1_string","name":"can","kind":12,"line":733},{"line":734,"kind":13,"containerName":"_gff1_string","name":"$name"},{"name":"$feat","containerName":"_gff1_string","kind":13,"line":734},{"kind":12,"line":734,"containerName":"_gff1_string","name":"seq_id"},{"line":735,"kind":13,"name":"$name","containerName":"_gff1_string"},{"name":"$name","containerName":"_gff1_string","line":737,"kind":13},{"containerName":"_gff1_string","name":"$str","kind":13,"line":741},{"line":742,"kind":13,"containerName":"_gff1_string","name":"$name"},{"kind":13,"line":743,"name":"$feat","containerName":"_gff1_string"},{"line":743,"kind":12,"containerName":"_gff1_string","name":"source_tag"},{"name":"$feat","containerName":"_gff1_string","kind":13,"line":744},{"line":744,"kind":12,"containerName":"_gff1_string","name":"primary_tag"},{"containerName":"_gff1_string","name":"$feat","line":745,"kind":13},{"kind":12,"line":745,"containerName":"_gff1_string","name":"start"},{"line":746,"kind":13,"name":"$feat","containerName":"_gff1_string"},{"name":"end","containerName":"_gff1_string","kind":12,"line":746},{"kind":13,"line":747,"name":"$score","containerName":"_gff1_string"},{"line":748,"kind":13,"containerName":"_gff1_string","name":"$strand"},{"containerName":"_gff1_string","name":"$frame","kind":13,"line":749},{"line":751,"kind":13,"localvar":"my","name":"$tag","definition":"my","containerName":"_gff1_string"},{"line":751,"kind":13,"name":"$feat","containerName":"_gff1_string"},{"name":"all_tags","containerName":"_gff1_string","line":751,"kind":12},{"line":752,"kind":13,"localvar":"my","definition":"my","name":"$value","containerName":"_gff1_string"},{"name":"$feat","containerName":"_gff1_string","kind":13,"line":752},{"containerName":"_gff1_string","name":"each_tag_value","line":752,"kind":12},{"kind":13,"line":752,"containerName":"_gff1_string","name":"$tag"},{"containerName":"_gff1_string","name":"$str","line":753,"kind":13},{"line":753,"kind":13,"containerName":"_gff1_string","name":"$value"},{"containerName":"_gff1_string","name":"$str","kind":13,"line":758}],"line":710},{"signature":{"parameters":[{"label":"$gff"},{"label":"$origfeat"}],"documentation":"1;\n# $Id: GFF.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::GFF\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by the Bioperl core team\n#\n# Copyright Matthew Pocock\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::GFF - A Bio::SeqAnalysisParserI compliant GFF format parser\n\n=head1 SYNOPSIS\n\n    use Bio::Tools::GFF;\n\n    # specify input via -fh or -file\n    my $gffio = Bio::Tools::GFF->new(-fh => \\*STDIN, -gff_version => 2);\n    my $feature;\n    # loop over the input stream\n    while($feature = $gffio->next_feature()) {\n        # do something with feature\n    }\n    $gffio->close();\n\n    # you can also obtain a GFF parser as a SeqAnalasisParserI in\n    # HT analysis pipelines (see Bio::SeqAnalysisParserI and\n    # Bio::Factory::SeqAnalysisParserFactory)\n    my $factory = Bio::Factory::SeqAnalysisParserFactory->new();\n    my $parser = $factory->get_parser(-input => \\*STDIN, -method => \"gff\");\n    while($feature = $parser->next_feature()) {\n        # do something with feature\n    }\n\n=head1 DESCRIPTION\n\nThis class provides a simple GFF parser and writer. In the sense of a\nSeqAnalysisParser, it parses an input file or stream into SeqFeatureI\nobjects, but is not in any way specific to a particular analysis\nprogram and the output that program produces.\n\nThat is, if you can get your analysis program spit out GFF, here is\nyour result parser.\n\n=head1 GFF3 AND SEQUENCE DATA\n\nGFF3 supports sequence data; see\n\nhttp://www.sequenceontology.org/gff3.shtml\n\nThere are a number of ways to deal with this -\n\nIf you call\n\n  $gffio->ignore_sequence(1)\n\nprior to parsing the sequence data is ignored; this is useful if you\njust want the features. It avoids the memory overhead in building and\ncaching sequences\n\nAlternatively, you can call either\n\n  $gffio->get_seqs()\n\nOr\n\n  $gffio->seq_id_by_h()\n\nAt the B<end> of parsing to get either a list or hashref of Bio::Seq\nobjects (see the documentation for each of these methods)\n\nNote that these objects will not have the features attached - you have\nto do this yourself, OR call\n\n  $gffio->features_attached_to_seqs(1)\n\nPRIOR to parsing; this will ensure that the Seqs have the features\nattached; ie you will then be able to call\n\n  $seq->get_SeqFeatures();\n\nAnd use Bio::SeqIO methods\n\nNote that auto-attaching the features to seqs will incur a higher\nmemory overhead as the features must be cached until the sequence data\nis found\n\n=head1 TODO\n\nMake a Bio::SeqIO class specifically for GFF3 with sequence data\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Matthew Pocock\n\nEmail mrp-at-sanger.ac.uk\n\n=head1 CONTRIBUTORS \n\nJason Stajich, jason-at-biperl-dot-org\nChris Mungall, cjm-at-fruitfly-dot-org\nSteffen Grossmann [SG], grossman at molgen.mpg.de\nMalcolm Cook, mec-at-stowers-institute.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tools::GFF;\n\nuse vars qw($HAS_HTML_ENTITIES);\nuse strict;\n\nuse Bio::Seq::SeqFactory;\nuse Bio::LocatableSeq;\nuse Bio::SeqFeature::Generic;\n\nuse base qw(Bio::Root::Root Bio::SeqAnalysisParserI Bio::Root::IO);\n\nmy $i = 0;\nmy %GFF3_ID_Tags = map { $_ => $i++ } qw(ID Parent Target);\n\n=head2 new\n\n Title   : new\n Usage   : my $parser = Bio::Tools::GFF->new(-gff_version => 2,\n\t\t\t\t\t    -file        => \"filename.gff\");\n           or\n           my $writer = Bio::Tools::GFF->new(-gff_version => 3,\n\t\t\t\t\t    -file        => \">filename.gff3\");\n Function: Creates a new instance. Recognized named parameters are -file, -fh,\n           and -gff_version.\n Returns : a new object\n Args    : named parameters\n           -gff_version => [1,2,3]\n\n\n\n{   # make a class variable such that we can generate unique ID's over\n    # a session, no matter how many instances of GFF.pm we make\n    # since these have to be unique within the scope of a GFF file.\n    \n    my $gff3_featureID = 0;\n    \n    sub _incrementGFF3ID {\n        my ($self) = @_;\n        return ++ $gff3_featureID;\n    }\n}\n\n\nsub new {\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n  \n  my ($gff_version, $noparse) = $self->_rearrange([qw(GFF_VERSION NOPARSE)],@args);\n\n  # initialize IO\n  $self->_initialize_io(@args);\n  $self->_parse_header() unless $noparse;\n\n  $gff_version ||= 2;\n  if( ! $self->gff_version($gff_version) )  {\n      $self->throw(\"Can't build a GFF object with the unknown version \".\n\t\t   $gff_version);\n  }\n  $self->{'_first'} = 1;\n  return $self;\n}\n\n=head2 _parse_header\n\n Title   : _parse_header\n Usage   : $gffio->_parse_header()\n Function: used to turn parse GFF header lines.  currently\n           produces Bio::LocatableSeq objects from ##sequence-region\n           lines\n Returns : 1 on success\n Args    : none\n\n\n\nsub _parse_header{\n   my ($self) = @_;\n\n   my @unhandled;\n   local $^W = 0; # hide warnings when we try and parse from a file opened\n                  # for writing - there isn't really a better way to do\n                  # AFAIK - cannot detech if a FH is read or write.\n   while(my $line = $self->_readline()){\n \t my $handled = 0;\n\t next if /^\\s+$/;\n\t if($line =~ /^\\#\\#sequence-region\\s+(\\S+)\\s+(\\S+)\\s+(\\S+)\\s*/){\n\t   my($seqid,$start,$end) = ($1,$2,$3);\n\t   push @{ $self->{'segments'} }, Bio::LocatableSeq->new\n\t       (\n\t\t-id    => unescape($seqid),\n\t\t-start => $start,\n\t\t-end   => $end,\n                -length => ($end - $start + 1),  ## make the length explicit\n\t\t);\n\t   $handled = 1;\n\t } elsif($line =~ /^(\\#\\#feature-ontology)/) {\n\t   #to be implemented\n\t   $self->warn(\"$1 header tag parsing unimplemented\");\n\t } elsif($line =~ /^(\\#\\#attribute-ontology)/) {\n\t   #to be implemented\n\t   $self->warn(\"$1 header tag parsing unimplemented\");\n\t } elsif($line =~ /^(\\#\\#source-ontology)/) {\n\t   #to be implemented\n\t   $self->warn(\"$1 header tag parsing unimplemented\");\n\t } elsif($line =~ /^(\\#\\#\\#)/) {\n\t   #to be implemented\n\t   $self->warn(\"$1 header tag parsing unimplemented\");\n\t } elsif($line =~ /^(\\#\\#FASTA)/) {\n            # initial ##FASTA is optional - artemis does not use it\n            $line = $self->_readline();\n            if ($line !~ /^\\>(\\S+)/) {\n                $self->throw(\"##FASTA directive must be followed by fasta header, not: $line\");\n            }\n\t } else {\n         }\n         \n         if ($line =~ /^\\>(.*)/) {\n             # seq data can be at header or footer\n             my $seq = $self->_parse_sequence($line);\n             if ($seq) {\n                 $self->_seq_by_id_h->{$seq->primary_id} = $seq;\n             }\n         }\n             \n\n \t if(!$handled){\n\t   push @unhandled, $line\n \t }\n\n\t #looks like the header is over!\n\t last unless $line =~ /^\\#/;\n   }\n\n   foreach my $line (@unhandled){\n\t $self->_pushback($line);\n   }\n\n   return 1;\n}\n\nsub _parse_sequence {\n    my ($self, $line) = @_;\n\n    if ($line =~ /^\\>(.*)/) {\n        \n        my $seqid = $1;\n        $seqid =~ s/\\s+$//;\n        my $desc = '';\n        if ($seqid =~ /(\\S+)\\s+(.*)/) {\n            ($seqid, $desc) = ($1,$2);\n        }\n        my $res = '';\n        while (my $line = $self->_readline) {\n            if ($line =~ /^\\#/) {\n                last;\n            }\n            if ($line =~ /^\\>/) {\n                $self->_pushback($line);\n                last;\n            }\n            $line =~ s/\\s//g;\n            $res .= $line;\n        }\n        return if $self->ignore_sequence;\n\n        my $seqfactory = Bio::Seq::SeqFactory->new('Bio::Seq');\n        my $seq = $seqfactory->create(-seq=>$res, \n                                      -id=>$seqid,\n                                      -desc=>$desc);\n        $seq->accession_number($seqid);\n        if ($self->features_attached_to_seqs) {\n            my @feats = \n              @{$self->_feature_idx_by_seq_id->{$seqid}};\n            $seq->add_SeqFeature($_) foreach @feats;\n            @{$self->_feature_idx_by_seq_id->{$seqid}} = ();\n        }\n        return $seq;\n    }\n    else {\n        $self->throw(\"expected fasta header, not: $line\");\n    }\n}\n\n\n=head2 next_segment\n\n Title   : next_segment\n Usage   : my $seq = $gffio->next_segment;\n Function: Returns a Bio::LocatableSeq object corresponding to a \n           GFF \"##sequence-region\" header line.\n Example :\n Returns : A Bio::LocatableSeq object, or undef if\n           there are no more sequences.\n Args    : none\n\n\n\nsub next_segment{\n   my ($self,@args) = @_;\n   return shift @{ $self->{'segments'} } if defined $self->{'segments'};\n   return;\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : $seqfeature = $gffio->next_feature();\n Function: Returns the next feature available in the input file or stream, or\n           undef if there are no more features.\n Example :\n Returns : A Bio::SeqFeatureI implementing object, or undef if there are no\n           more features.\n Args    : none    \n\n\nsub next_feature {\n    my ($self) = @_;\n    \n    my $gff_string;\n    \n    # be graceful about empty lines or comments, and make sure we return undef\n    # if the input's consumed\n    while(($gff_string = $self->_readline()) && defined($gff_string)) {\t\n        if ($gff_string =~ /^\\#\\#\\#/) {\n            # all forward refs have been seen; TODO\n        }\n        next if($gff_string =~ /^\\#/ || $gff_string =~ /^\\s*$/ ||\n                $gff_string =~ m{^//});\n\n        while ($gff_string =~ /^\\>(.+)/) {\n            # fasta can be in header or footer\n            my $seq = $self->_parse_sequence($gff_string);\n            if ($seq) {\n                $self->_seq_by_id_h->{$seq->primary_id} = $seq;\n                $gff_string = $self->_readline;\n                last unless $gff_string;\n            }\n        }\n        last; \n    }\n    return unless $gff_string;\n\n    my $feat = Bio::SeqFeature::Generic->new();\n    $self->from_gff_string($feat, $gff_string);\n\n    if ($self->features_attached_to_seqs) {\n        push(@{$self->_feature_idx_by_seq_id->{$feat->seq_id}},\n             $feat);\n    }\n\n    return $feat;\n}\n\nsub _feature_idx_by_seq_id {\n    my $self = shift;\n    $self->{__feature_idx_by_seq_id} = shift if @_;\n    $self->{__feature_idx_by_seq_id} = {}\n      unless $self->{__feature_idx_by_seq_id};\n    return $self->{__feature_idx_by_seq_id};\n}\n\n\n=head2 from_gff_string\n\n Title   : from_gff_string\n Usage   : $gff->from_gff_string($feature, $gff_string);\n Function: Sets properties of a SeqFeatureI object from a GFF-formatted\n           string. Interpretation of the string depends on the version\n           that has been specified at initialization.\n\n           This method is used by next_feature(). It actually dispatches to\n           one of the version-specific (private) methods.\n Example :\n Returns : void\n Args    : A Bio::SeqFeatureI implementing object to be initialized\n           The GFF-formatted string to initialize it from\n\n\nsub from_gff_string {\n    my ($self, $feat, $gff_string) = @_;\n\n    if($self->gff_version() == 1)  {\n\treturn $self->_from_gff1_string($feat, $gff_string);\n    } elsif( $self->gff_version() == 3 ) {\n\treturn $self->_from_gff3_string($feat, $gff_string);\n    } else {\n\treturn $self->_from_gff2_string($feat, $gff_string);\n    }\n}\n\n=head2 _from_gff1_string\n\n Title   : _from_gff1_string\n Usage   :\n Function:\n Example :\n Returns : void\n Args    : A Bio::SeqFeatureI implementing object to be initialized\n           The GFF-formatted string to initialize it from\n\n\nsub _from_gff1_string {\n   my ($gff, $feat, $string) = @_;\n   chomp $string;\n   my ($seqname, $source, $primary, $start, $end, $score, \n       $strand, $frame, @group) = split(/\\t/, $string);\n\n   if ( !defined $frame ) {\n       $feat->throw(\"[$string] does not look like GFF to me\");\n   }\n   $frame = 0 unless( $frame =~ /^\\d+$/);\n   $feat->seq_id($seqname);\n   $feat->source_tag($source);\n   $feat->primary_tag($primary);\n   $feat->start($start);\n   $feat->end($end);\n   $feat->frame($frame);\n   if ( $score eq '.' ) {\n       #$feat->score(undef);\n   } else {\n       $feat->score($score);\n   }\n   if ( $strand eq '-' ) { $feat->strand(-1); }\n   if ( $strand eq '+' ) { $feat->strand(1); }\n   if ( $strand eq '.' ) { $feat->strand(0); }\n   foreach my $g ( @group ) {\n       if ( $g =~ /(\\S+)=(\\S+)/ ) {\n\t   my $tag = $1;\n\t   my $value = $2;\n\t   $feat->add_tag_value($1, $2);\n       } else {\n\t   $feat->add_tag_value('group', $g);\n       }\n   }\n}\n\n=head2 _from_gff2_string\n\n Title   : _from_gff2_string\n Usage   :\n Function:\n Example :\n Returns : void\n Args    : A Bio::SeqFeatureI implementing object to be initialized\n           The GFF2-formatted string to initialize it from\n\n\n\nsub _from_gff2_string {\n   my ($gff, $feat, $string) = @_;\n   chomp($string);\n\n   # according to the Sanger website, GFF2 should be single-tab\n   # separated elements, and the free-text at the end should contain\n   # text-translated tab symbols but no \"real\" tabs, so splitting on\n   # \\t is safe, and $attribs gets the entire attributes field to be\n   # parsed later\n   \n   # sendu: but the tag value pair can (should?) be separated by a tab. The\n   # 'no tabs' thing seems to apply only to the free text that is allowed for\n   # the value\n\n   my ($seqname, $source, $primary, $start, \n       $end, $score, $strand, $frame, @attribs) = split(/\\t+/, $string);\n   my $attribs = join ' ', @attribs;\n   \n   if ( !defined $frame ) {\n       $feat->throw(\"[$string] does not look like GFF2 to me\");\n   }\n   $feat->seq_id($seqname);\n   $feat->source_tag($source);\n   $feat->primary_tag($primary);\n   $feat->start($start);\n   $feat->end($end);\n   $feat->frame($frame);\n   if ( $score eq '.' ) {\n       # $feat->score(undef);\n   } else {\n       $feat->score($score);\n   }\n   if ( $strand eq '-' ) { $feat->strand(-1); }\n   if ( $strand eq '+' ) { $feat->strand(1); }\n   if ( $strand eq '.' ) { $feat->strand(0); }\n\n\n   #  <Begin Inefficient Code from Mark Wilkinson> \n   # this routine is necessay to allow the presence of semicolons in\n   # quoted text Semicolons are the delimiting character for new\n   # tag/value attributes.  it is more or less a \"state\" machine, with\n   # the \"quoted\" flag going up and down as we pass thorugh quotes to\n   # distinguish free-text semicolon and hash symbols from GFF control\n   # characters\n   \n   \n   my $flag = 0; # this could be changed to a bit and just be twiddled\n   my @parsed;\n\n   # run through each character one at a time and check it\n   # NOTE: changed to foreach loop which is more efficient in perl\n   # --jasons\n   for my $a ( split //, $attribs ) { \n       # flag up on entering quoted text, down on leaving it\n       if( $a eq '\"') { $flag = ( $flag == 0 ) ? 1:0 }\n       elsif( $a eq ';' && $flag ) { $a = \"INSERT_SEMICOLON_HERE\"}\n       elsif( $a eq '#' && ! $flag ) { last } \n       push @parsed, $a;\n   }\n   $attribs = join \"\", @parsed; # rejoin into a single string\n\n   # <End Inefficient Code>   \n   # Please feel free to fix this and make it more \"perlish\"\n\n   my @key_vals = split /;/, $attribs;   # attributes are semicolon-delimited\n\n   foreach my $pair ( @key_vals ) {\n       # replace semicolons that were removed from free-text above.\n       $pair =~ s/INSERT_SEMICOLON_HERE/;/g;        \n\n       # separate the key from the value\n       my ($blank, $key, $values) = split  /^\\s*([\\w\\d]+)\\s/, $pair; \n\n\n       if( defined $values ) {\n\t   my @values;\n\t   # free text is quoted, so match each free-text block\n\t   # and remove it from the $values string\n\t   while ($values =~ s/\"(.*?)\"//){\n\t       # and push it on to the list of values (tags may have\n\t       # more than one value... and the value may be undef)\t       \n\t       push @values, $1;\n\t   }\n\n\t   # and what is left over should be space-separated\n\t   # non-free-text values\n\n\t   my @othervals = split /\\s+/, $values;  \n\t   foreach my $othervalue(@othervals){\n\t       # get rid of any empty strings which might \n\t       # result from the split\n\t       if (CORE::length($othervalue) > 0) {push @values, $othervalue}  \n\t   }\n\n\t   foreach my $value(@values){\n\t       $feat->add_tag_value($key, $value);\n\t   }\n       }\n   }\n}\n\n\nsub _from_gff3_string {\n    my ($gff, $feat, $string) = @_;\n    chomp($string);\n\n    # according to the now nearly final GFF3 spec, columns should \n    # be tab separated, allowing unescaped spaces to occur in\n    # column 9\n\n    my ($seqname, $source, $primary, $start, $end, \n\t$score, $strand, $frame, $groups) = split(/\\t/, $string);\n    \n    if ( ! defined $frame ) {\n\t$feat->throw(\"[$string] does not look like GFF3 to me\");\n    }\n    $feat->seq_id($seqname);\n    $feat->source_tag($source);\n    $feat->primary_tag($primary);\n    $feat->start($start);\n    $feat->end($end);\n    $feat->frame($frame);\n    if ( $score eq '.' ) {\n\t#$feat->score(undef);\n    } else {\n\t$feat->score($score);\n    }\n    if ( $strand eq '-' ) { $feat->strand(-1); }\n    if ( $strand eq '+' ) { $feat->strand(1); }\n    if ( $strand eq '.' ) { $feat->strand(0); }\n    my @groups = split(/\\s*;\\s*/, $groups);\n\n    for my $group (@groups) {\n\tmy ($tag,$value) = split /=/,$group;\n\t$tag             = unescape($tag);\n\tmy @values       = map {unescape($_)} split /,/,$value;\n\tfor my $v ( @values ) {  $feat->add_tag_value($tag,$v); }\n    }\n}\n\n# taken from Bio::DB::GFF\nsub unescape {\n  my $v = shift;\n  $v =~ tr/+/ /;\n  $v =~ s/%([0-9a-fA-F]{2})/chr hex($1)/ge;\n  return $v;\n}\n\n=head2 write_feature\n\n Title   : write_feature\n Usage   : $gffio->write_feature($feature);\n Function: Writes the specified SeqFeatureI object in GFF format to the stream\n           associated with this instance.\n Returns : none\n Args    : An array of Bio::SeqFeatureI implementing objects to be serialized\n\n\nsub write_feature {\n    my ($self, @features) = @_;\n    return unless @features;\n    if( $self->{'_first'} && $self->gff_version() == 3 ) {\n\t$self->_print(\"##gff-version 3\\n\");\n    }\n    $self->{'_first'} = 0;\n    foreach my $feature ( @features ) {\n\t$self->_print($self->gff_string($feature).\"\\n\");\n    }\n}\n\n=head2 gff_string\n\n Title   : gff_string\n Usage   : $gffstr = $gffio->gff_string($feature);\n Function: Obtain the GFF-formatted representation of a SeqFeatureI object.\n           The formatting depends on the version specified at initialization.\n\n           This method is used by write_feature(). It actually dispatches to\n           one of the version-specific (private) methods.\n Example :\n Returns : A GFF-formatted string representation of the SeqFeature\n Args    : A Bio::SeqFeatureI implementing object to be GFF-stringified\n\n\nsub gff_string{\n    my ($self, $feature) = @_;\n\n    if($self->gff_version() == 1) {\n    \treturn $self->_gff1_string($feature);\n    } elsif( $self->gff_version() == 3 ) {\n    \treturn $self->_gff3_string($feature);\n    } elsif( $self->gff_version() == 2.5 ) {\n    \treturn $self->_gff25_string($feature);\n    } else {\n    \treturn $self->_gff2_string($feature);\n    }\n}\n\n=head2 _gff1_string\n\n Title   : _gff1_string\n Usage   : $gffstr = $gffio->_gff1_string\n Function: \n Example :\n Returns : A GFF1-formatted string representation of the SeqFeature\n Args    : A Bio::SeqFeatureI implementing object to be GFF-stringified\n\n\nsub _gff1_string{\n   my ($gff, $feat) = @_;\n   my ($str,$score,$frame,$name,$strand);\n\n   if( $feat->can('score') ) {\n       $score = $feat->score();\n   }\n   $score = '.' unless defined $score;\n\n   if( $feat->can('frame') ) {\n       $frame = $feat->frame();\n   }\n   $frame = '.' unless defined $frame;\n\n   $strand = $feat->strand();\n   if(! $strand) {\n       $strand = \".\";\n   } elsif( $strand == 1 ) {\n       $strand = '+';\n   } elsif ( $feat->strand == -1 ) {\n       $strand = '-';\n   }\n   \n   if( $feat->can('seqname') ) {\n       $name = $feat->seq_id();\n       $name ||= 'SEQ';\n   } else {\n       $name = 'SEQ';\n   }\n\n\n   $str = join(\"\\t\",\n                 $name,\n\t\t $feat->source_tag(),\n\t\t $feat->primary_tag(),\n\t\t $feat->start(),\n\t\t $feat->end(),\n\t\t $score,\n\t\t $strand,\n\t\t $frame);\n\n   foreach my $tag ( $feat->all_tags ) {\n       foreach my $value ( $feat->each_tag_value($tag) ) {\n\t   $str .= \" $tag=$value\" if $value;\n       }\n   }\n\n\n   return $str;\n}\n\n=head2 _gff2_string\n\n Title   : _gff2_string\n Usage   : $gffstr = $gffio->_gff2_string\n Function: \n Example :\n Returns : A GFF2-formatted string representation of the SeqFeature\n Args    : A Bio::SeqFeatureI implementing object to be GFF2-stringified","label":"_gff2_string($gff,$origfeat)"},"detail":"($gff,$origfeat)","definition":"sub","containerName":"main::","children":[{"localvar":"my","name":"$gff","definition":"my","containerName":"_gff2_string","line":773,"kind":13},{"name":"$origfeat","containerName":"_gff2_string","line":773,"kind":13},{"containerName":"_gff2_string","name":"$feat","definition":"my","localvar":"my","kind":13,"line":774},{"kind":13,"line":775,"containerName":"_gff2_string","name":"$origfeat"},{"containerName":"_gff2_string","name":"isa","line":775,"kind":12},{"name":"$feat","containerName":"_gff2_string","kind":13,"line":776},{"name":"$origfeat","containerName":"_gff2_string","line":776,"kind":13},{"line":776,"kind":12,"containerName":"_gff2_string","name":"feature2"},{"kind":13,"line":778,"containerName":"_gff2_string","name":"$feat"},{"kind":13,"line":778,"name":"$origfeat","containerName":"_gff2_string"},{"kind":13,"line":780,"definition":"my","name":"$str1","containerName":"_gff2_string","localvar":"my"},{"kind":13,"line":780,"name":"$str2","containerName":"_gff2_string"},{"kind":13,"line":780,"containerName":"_gff2_string","name":"$score"},{"name":"$frame","containerName":"_gff2_string","line":780,"kind":13},{"name":"$name","containerName":"_gff2_string","line":780,"kind":13},{"line":780,"kind":13,"containerName":"_gff2_string","name":"$strand"},{"name":"$feat","containerName":"_gff2_string","line":782,"kind":13},{"kind":12,"line":782,"containerName":"_gff2_string","name":"can"},{"name":"$score","containerName":"_gff2_string","kind":13,"line":783},{"line":783,"kind":13,"name":"$feat","containerName":"_gff2_string"},{"line":783,"kind":12,"containerName":"_gff2_string","name":"score"},{"kind":13,"line":785,"name":"$score","containerName":"_gff2_string"},{"containerName":"_gff2_string","name":"$score","kind":13,"line":785},{"containerName":"_gff2_string","name":"$feat","line":787,"kind":13},{"containerName":"_gff2_string","name":"can","line":787,"kind":12},{"containerName":"_gff2_string","name":"$frame","kind":13,"line":788},{"containerName":"_gff2_string","name":"$feat","line":788,"kind":13},{"line":788,"kind":12,"containerName":"_gff2_string","name":"frame"},{"containerName":"_gff2_string","name":"$frame","kind":13,"line":790},{"line":790,"kind":13,"name":"$frame","containerName":"_gff2_string"},{"line":792,"kind":13,"containerName":"_gff2_string","name":"$strand"},{"line":792,"kind":13,"containerName":"_gff2_string","name":"$feat"},{"kind":12,"line":792,"containerName":"_gff2_string","name":"strand"},{"name":"$strand","containerName":"_gff2_string","kind":13,"line":793},{"name":"$strand","containerName":"_gff2_string","kind":13,"line":794},{"name":"$strand","containerName":"_gff2_string","line":795,"kind":13},{"kind":13,"line":796,"containerName":"_gff2_string","name":"$strand"},{"name":"$feat","containerName":"_gff2_string","line":797,"kind":13},{"kind":12,"line":797,"name":"strand","containerName":"_gff2_string"},{"kind":13,"line":798,"name":"$strand","containerName":"_gff2_string"},{"containerName":"_gff2_string","name":"$feat","line":801,"kind":13},{"name":"can","containerName":"_gff2_string","line":801,"kind":12},{"name":"$name","containerName":"_gff2_string","line":802,"kind":13},{"name":"$feat","containerName":"_gff2_string","line":802,"kind":13},{"name":"seq_id","containerName":"_gff2_string","line":802,"kind":12},{"containerName":"_gff2_string","name":"$name","line":803,"kind":13},{"line":805,"kind":13,"containerName":"_gff2_string","name":"$name"},{"name":"$str1","containerName":"_gff2_string","line":807,"kind":13},{"name":"$name","containerName":"_gff2_string","line":808,"kind":13},{"line":809,"kind":13,"containerName":"_gff2_string","name":"$feat"},{"containerName":"_gff2_string","name":"source_tag","kind":12,"line":809},{"name":"$feat","containerName":"_gff2_string","kind":13,"line":810},{"name":"primary_tag","containerName":"_gff2_string","kind":12,"line":810},{"containerName":"_gff2_string","name":"$feat","kind":13,"line":811},{"name":"start","containerName":"_gff2_string","kind":12,"line":811},{"line":812,"kind":13,"containerName":"_gff2_string","name":"$feat"},{"line":812,"kind":12,"name":"end","containerName":"_gff2_string"},{"name":"$score","containerName":"_gff2_string","line":813,"kind":13},{"containerName":"_gff2_string","name":"$strand","kind":13,"line":814},{"line":815,"kind":13,"name":"$frame","containerName":"_gff2_string"},{"kind":13,"line":828,"name":"@all_tags","definition":"my","containerName":"_gff2_string","localvar":"my"},{"containerName":"_gff2_string","name":"$feat","line":828,"kind":13},{"containerName":"_gff2_string","name":"all_tags","line":828,"kind":12},{"localvar":"my","name":"@group","definition":"my","containerName":"_gff2_string","line":829,"kind":13},{"containerName":"_gff2_string","name":"@all_tags","line":830,"kind":13},{"containerName":"_gff2_string","name":"$tag","definition":"my","localvar":"my","kind":13,"line":831},{"name":"@all_tags","containerName":"_gff2_string","kind":13,"line":831},{"containerName":"_gff2_string","definition":"my","name":"@v","localvar":"my","kind":13,"line":832},{"definition":"my","name":"$value","containerName":"_gff2_string","localvar":"my","kind":13,"line":833},{"line":833,"kind":13,"name":"$feat","containerName":"_gff2_string"},{"line":833,"kind":12,"name":"each_tag_value","containerName":"_gff2_string"},{"kind":13,"line":833,"containerName":"_gff2_string","name":"$tag"},{"line":834,"kind":13,"containerName":"_gff2_string","name":"$value"},{"kind":13,"line":834,"containerName":"_gff2_string","name":"$value"},{"line":835,"kind":13,"containerName":"_gff2_string","name":"$value"},{"kind":13,"line":836,"name":"$value","containerName":"_gff2_string"},{"kind":13,"line":837,"name":"$value","containerName":"_gff2_string"},{"line":839,"kind":13,"name":"$value","containerName":"_gff2_string"},{"containerName":"_gff2_string","name":"$value","kind":13,"line":840},{"line":840,"kind":13,"name":"$value","containerName":"_gff2_string"},{"line":845,"kind":13,"containerName":"_gff2_string","name":"@v"},{"containerName":"_gff2_string","name":"$value","kind":13,"line":845},{"name":"@group","containerName":"_gff2_string","kind":13,"line":848},{"line":848,"kind":13,"containerName":"_gff2_string","name":"@v"},{"line":851,"kind":13,"name":"$str2","containerName":"_gff2_string"},{"containerName":"_gff2_string","name":"@group","kind":13,"line":851},{"containerName":"_gff2_string","name":"$feat","kind":13,"line":853},{"kind":12,"line":853,"containerName":"_gff2_string","name":"has_tag"},{"line":854,"kind":13,"containerName":"_gff2_string","name":"$feat"},{"line":854,"kind":12,"containerName":"_gff2_string","name":"has_tag"},{"containerName":"_gff2_string","name":"$origfeat","kind":13,"line":855},{"name":"isa","containerName":"_gff2_string","line":855,"kind":12},{"name":"$str2","containerName":"_gff2_string","line":856,"kind":13},{"containerName":"_gff2_string","name":"$origfeat","kind":13,"line":856},{"containerName":"_gff2_string","name":"feature1","kind":12,"line":856},{"name":"seq_id","containerName":"_gff2_string","kind":12,"line":856},{"kind":13,"line":857,"name":"$origfeat","containerName":"_gff2_string"},{"kind":12,"line":857,"containerName":"_gff2_string","name":"feature1"},{"line":857,"kind":12,"name":"strand","containerName":"_gff2_string"},{"name":"$origfeat","containerName":"_gff2_string","line":858,"kind":13},{"kind":12,"line":858,"name":"feature1","containerName":"_gff2_string"},{"kind":12,"line":858,"containerName":"_gff2_string","name":"end"},{"name":"$origfeat","containerName":"_gff2_string","kind":13,"line":859},{"line":859,"kind":12,"name":"feature1","containerName":"_gff2_string"},{"kind":12,"line":859,"name":"start","containerName":"_gff2_string"},{"containerName":"_gff2_string","name":"$origfeat","line":860,"kind":13},{"containerName":"_gff2_string","name":"feature1","kind":12,"line":860},{"containerName":"_gff2_string","name":"start","kind":12,"line":860},{"containerName":"_gff2_string","name":"$origfeat","line":861,"kind":13},{"name":"feature1","containerName":"_gff2_string","line":861,"kind":12},{"name":"end","containerName":"_gff2_string","kind":12,"line":861},{"kind":13,"line":862,"containerName":"_gff2_string","name":"$str2"},{"containerName":"_gff2_string","name":"$str2","kind":13,"line":862},{"kind":13,"line":864,"name":"$str1","containerName":"_gff2_string"},{"containerName":"_gff2_string","name":"$str2","line":864,"kind":13}],"line":772,"kind":12,"range":{"start":{"character":0,"line":772},"end":{"character":9999,"line":865}},"name":"_gff2_string"},{"containerName":"main::","definition":"sub","detail":"($gff,$origfeat)","signature":{"documentation":"1;\n# $Id: GFF.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::GFF\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by the Bioperl core team\n#\n# Copyright Matthew Pocock\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::GFF - A Bio::SeqAnalysisParserI compliant GFF format parser\n\n=head1 SYNOPSIS\n\n    use Bio::Tools::GFF;\n\n    # specify input via -fh or -file\n    my $gffio = Bio::Tools::GFF->new(-fh => \\*STDIN, -gff_version => 2);\n    my $feature;\n    # loop over the input stream\n    while($feature = $gffio->next_feature()) {\n        # do something with feature\n    }\n    $gffio->close();\n\n    # you can also obtain a GFF parser as a SeqAnalasisParserI in\n    # HT analysis pipelines (see Bio::SeqAnalysisParserI and\n    # Bio::Factory::SeqAnalysisParserFactory)\n    my $factory = Bio::Factory::SeqAnalysisParserFactory->new();\n    my $parser = $factory->get_parser(-input => \\*STDIN, -method => \"gff\");\n    while($feature = $parser->next_feature()) {\n        # do something with feature\n    }\n\n=head1 DESCRIPTION\n\nThis class provides a simple GFF parser and writer. In the sense of a\nSeqAnalysisParser, it parses an input file or stream into SeqFeatureI\nobjects, but is not in any way specific to a particular analysis\nprogram and the output that program produces.\n\nThat is, if you can get your analysis program spit out GFF, here is\nyour result parser.\n\n=head1 GFF3 AND SEQUENCE DATA\n\nGFF3 supports sequence data; see\n\nhttp://www.sequenceontology.org/gff3.shtml\n\nThere are a number of ways to deal with this -\n\nIf you call\n\n  $gffio->ignore_sequence(1)\n\nprior to parsing the sequence data is ignored; this is useful if you\njust want the features. It avoids the memory overhead in building and\ncaching sequences\n\nAlternatively, you can call either\n\n  $gffio->get_seqs()\n\nOr\n\n  $gffio->seq_id_by_h()\n\nAt the B<end> of parsing to get either a list or hashref of Bio::Seq\nobjects (see the documentation for each of these methods)\n\nNote that these objects will not have the features attached - you have\nto do this yourself, OR call\n\n  $gffio->features_attached_to_seqs(1)\n\nPRIOR to parsing; this will ensure that the Seqs have the features\nattached; ie you will then be able to call\n\n  $seq->get_SeqFeatures();\n\nAnd use Bio::SeqIO methods\n\nNote that auto-attaching the features to seqs will incur a higher\nmemory overhead as the features must be cached until the sequence data\nis found\n\n=head1 TODO\n\nMake a Bio::SeqIO class specifically for GFF3 with sequence data\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Matthew Pocock\n\nEmail mrp-at-sanger.ac.uk\n\n=head1 CONTRIBUTORS \n\nJason Stajich, jason-at-biperl-dot-org\nChris Mungall, cjm-at-fruitfly-dot-org\nSteffen Grossmann [SG], grossman at molgen.mpg.de\nMalcolm Cook, mec-at-stowers-institute.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tools::GFF;\n\nuse vars qw($HAS_HTML_ENTITIES);\nuse strict;\n\nuse Bio::Seq::SeqFactory;\nuse Bio::LocatableSeq;\nuse Bio::SeqFeature::Generic;\n\nuse base qw(Bio::Root::Root Bio::SeqAnalysisParserI Bio::Root::IO);\n\nmy $i = 0;\nmy %GFF3_ID_Tags = map { $_ => $i++ } qw(ID Parent Target);\n\n=head2 new\n\n Title   : new\n Usage   : my $parser = Bio::Tools::GFF->new(-gff_version => 2,\n\t\t\t\t\t    -file        => \"filename.gff\");\n           or\n           my $writer = Bio::Tools::GFF->new(-gff_version => 3,\n\t\t\t\t\t    -file        => \">filename.gff3\");\n Function: Creates a new instance. Recognized named parameters are -file, -fh,\n           and -gff_version.\n Returns : a new object\n Args    : named parameters\n           -gff_version => [1,2,3]\n\n\n\n{   # make a class variable such that we can generate unique ID's over\n    # a session, no matter how many instances of GFF.pm we make\n    # since these have to be unique within the scope of a GFF file.\n    \n    my $gff3_featureID = 0;\n    \n    sub _incrementGFF3ID {\n        my ($self) = @_;\n        return ++ $gff3_featureID;\n    }\n}\n\n\nsub new {\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n  \n  my ($gff_version, $noparse) = $self->_rearrange([qw(GFF_VERSION NOPARSE)],@args);\n\n  # initialize IO\n  $self->_initialize_io(@args);\n  $self->_parse_header() unless $noparse;\n\n  $gff_version ||= 2;\n  if( ! $self->gff_version($gff_version) )  {\n      $self->throw(\"Can't build a GFF object with the unknown version \".\n\t\t   $gff_version);\n  }\n  $self->{'_first'} = 1;\n  return $self;\n}\n\n=head2 _parse_header\n\n Title   : _parse_header\n Usage   : $gffio->_parse_header()\n Function: used to turn parse GFF header lines.  currently\n           produces Bio::LocatableSeq objects from ##sequence-region\n           lines\n Returns : 1 on success\n Args    : none\n\n\n\nsub _parse_header{\n   my ($self) = @_;\n\n   my @unhandled;\n   local $^W = 0; # hide warnings when we try and parse from a file opened\n                  # for writing - there isn't really a better way to do\n                  # AFAIK - cannot detech if a FH is read or write.\n   while(my $line = $self->_readline()){\n \t my $handled = 0;\n\t next if /^\\s+$/;\n\t if($line =~ /^\\#\\#sequence-region\\s+(\\S+)\\s+(\\S+)\\s+(\\S+)\\s*/){\n\t   my($seqid,$start,$end) = ($1,$2,$3);\n\t   push @{ $self->{'segments'} }, Bio::LocatableSeq->new\n\t       (\n\t\t-id    => unescape($seqid),\n\t\t-start => $start,\n\t\t-end   => $end,\n                -length => ($end - $start + 1),  ## make the length explicit\n\t\t);\n\t   $handled = 1;\n\t } elsif($line =~ /^(\\#\\#feature-ontology)/) {\n\t   #to be implemented\n\t   $self->warn(\"$1 header tag parsing unimplemented\");\n\t } elsif($line =~ /^(\\#\\#attribute-ontology)/) {\n\t   #to be implemented\n\t   $self->warn(\"$1 header tag parsing unimplemented\");\n\t } elsif($line =~ /^(\\#\\#source-ontology)/) {\n\t   #to be implemented\n\t   $self->warn(\"$1 header tag parsing unimplemented\");\n\t } elsif($line =~ /^(\\#\\#\\#)/) {\n\t   #to be implemented\n\t   $self->warn(\"$1 header tag parsing unimplemented\");\n\t } elsif($line =~ /^(\\#\\#FASTA)/) {\n            # initial ##FASTA is optional - artemis does not use it\n            $line = $self->_readline();\n            if ($line !~ /^\\>(\\S+)/) {\n                $self->throw(\"##FASTA directive must be followed by fasta header, not: $line\");\n            }\n\t } else {\n         }\n         \n         if ($line =~ /^\\>(.*)/) {\n             # seq data can be at header or footer\n             my $seq = $self->_parse_sequence($line);\n             if ($seq) {\n                 $self->_seq_by_id_h->{$seq->primary_id} = $seq;\n             }\n         }\n             \n\n \t if(!$handled){\n\t   push @unhandled, $line\n \t }\n\n\t #looks like the header is over!\n\t last unless $line =~ /^\\#/;\n   }\n\n   foreach my $line (@unhandled){\n\t $self->_pushback($line);\n   }\n\n   return 1;\n}\n\nsub _parse_sequence {\n    my ($self, $line) = @_;\n\n    if ($line =~ /^\\>(.*)/) {\n        \n        my $seqid = $1;\n        $seqid =~ s/\\s+$//;\n        my $desc = '';\n        if ($seqid =~ /(\\S+)\\s+(.*)/) {\n            ($seqid, $desc) = ($1,$2);\n        }\n        my $res = '';\n        while (my $line = $self->_readline) {\n            if ($line =~ /^\\#/) {\n                last;\n            }\n            if ($line =~ /^\\>/) {\n                $self->_pushback($line);\n                last;\n            }\n            $line =~ s/\\s//g;\n            $res .= $line;\n        }\n        return if $self->ignore_sequence;\n\n        my $seqfactory = Bio::Seq::SeqFactory->new('Bio::Seq');\n        my $seq = $seqfactory->create(-seq=>$res, \n                                      -id=>$seqid,\n                                      -desc=>$desc);\n        $seq->accession_number($seqid);\n        if ($self->features_attached_to_seqs) {\n            my @feats = \n              @{$self->_feature_idx_by_seq_id->{$seqid}};\n            $seq->add_SeqFeature($_) foreach @feats;\n            @{$self->_feature_idx_by_seq_id->{$seqid}} = ();\n        }\n        return $seq;\n    }\n    else {\n        $self->throw(\"expected fasta header, not: $line\");\n    }\n}\n\n\n=head2 next_segment\n\n Title   : next_segment\n Usage   : my $seq = $gffio->next_segment;\n Function: Returns a Bio::LocatableSeq object corresponding to a \n           GFF \"##sequence-region\" header line.\n Example :\n Returns : A Bio::LocatableSeq object, or undef if\n           there are no more sequences.\n Args    : none\n\n\n\nsub next_segment{\n   my ($self,@args) = @_;\n   return shift @{ $self->{'segments'} } if defined $self->{'segments'};\n   return;\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : $seqfeature = $gffio->next_feature();\n Function: Returns the next feature available in the input file or stream, or\n           undef if there are no more features.\n Example :\n Returns : A Bio::SeqFeatureI implementing object, or undef if there are no\n           more features.\n Args    : none    \n\n\nsub next_feature {\n    my ($self) = @_;\n    \n    my $gff_string;\n    \n    # be graceful about empty lines or comments, and make sure we return undef\n    # if the input's consumed\n    while(($gff_string = $self->_readline()) && defined($gff_string)) {\t\n        if ($gff_string =~ /^\\#\\#\\#/) {\n            # all forward refs have been seen; TODO\n        }\n        next if($gff_string =~ /^\\#/ || $gff_string =~ /^\\s*$/ ||\n                $gff_string =~ m{^//});\n\n        while ($gff_string =~ /^\\>(.+)/) {\n            # fasta can be in header or footer\n            my $seq = $self->_parse_sequence($gff_string);\n            if ($seq) {\n                $self->_seq_by_id_h->{$seq->primary_id} = $seq;\n                $gff_string = $self->_readline;\n                last unless $gff_string;\n            }\n        }\n        last; \n    }\n    return unless $gff_string;\n\n    my $feat = Bio::SeqFeature::Generic->new();\n    $self->from_gff_string($feat, $gff_string);\n\n    if ($self->features_attached_to_seqs) {\n        push(@{$self->_feature_idx_by_seq_id->{$feat->seq_id}},\n             $feat);\n    }\n\n    return $feat;\n}\n\nsub _feature_idx_by_seq_id {\n    my $self = shift;\n    $self->{__feature_idx_by_seq_id} = shift if @_;\n    $self->{__feature_idx_by_seq_id} = {}\n      unless $self->{__feature_idx_by_seq_id};\n    return $self->{__feature_idx_by_seq_id};\n}\n\n\n=head2 from_gff_string\n\n Title   : from_gff_string\n Usage   : $gff->from_gff_string($feature, $gff_string);\n Function: Sets properties of a SeqFeatureI object from a GFF-formatted\n           string. Interpretation of the string depends on the version\n           that has been specified at initialization.\n\n           This method is used by next_feature(). It actually dispatches to\n           one of the version-specific (private) methods.\n Example :\n Returns : void\n Args    : A Bio::SeqFeatureI implementing object to be initialized\n           The GFF-formatted string to initialize it from\n\n\nsub from_gff_string {\n    my ($self, $feat, $gff_string) = @_;\n\n    if($self->gff_version() == 1)  {\n\treturn $self->_from_gff1_string($feat, $gff_string);\n    } elsif( $self->gff_version() == 3 ) {\n\treturn $self->_from_gff3_string($feat, $gff_string);\n    } else {\n\treturn $self->_from_gff2_string($feat, $gff_string);\n    }\n}\n\n=head2 _from_gff1_string\n\n Title   : _from_gff1_string\n Usage   :\n Function:\n Example :\n Returns : void\n Args    : A Bio::SeqFeatureI implementing object to be initialized\n           The GFF-formatted string to initialize it from\n\n\nsub _from_gff1_string {\n   my ($gff, $feat, $string) = @_;\n   chomp $string;\n   my ($seqname, $source, $primary, $start, $end, $score, \n       $strand, $frame, @group) = split(/\\t/, $string);\n\n   if ( !defined $frame ) {\n       $feat->throw(\"[$string] does not look like GFF to me\");\n   }\n   $frame = 0 unless( $frame =~ /^\\d+$/);\n   $feat->seq_id($seqname);\n   $feat->source_tag($source);\n   $feat->primary_tag($primary);\n   $feat->start($start);\n   $feat->end($end);\n   $feat->frame($frame);\n   if ( $score eq '.' ) {\n       #$feat->score(undef);\n   } else {\n       $feat->score($score);\n   }\n   if ( $strand eq '-' ) { $feat->strand(-1); }\n   if ( $strand eq '+' ) { $feat->strand(1); }\n   if ( $strand eq '.' ) { $feat->strand(0); }\n   foreach my $g ( @group ) {\n       if ( $g =~ /(\\S+)=(\\S+)/ ) {\n\t   my $tag = $1;\n\t   my $value = $2;\n\t   $feat->add_tag_value($1, $2);\n       } else {\n\t   $feat->add_tag_value('group', $g);\n       }\n   }\n}\n\n=head2 _from_gff2_string\n\n Title   : _from_gff2_string\n Usage   :\n Function:\n Example :\n Returns : void\n Args    : A Bio::SeqFeatureI implementing object to be initialized\n           The GFF2-formatted string to initialize it from\n\n\n\nsub _from_gff2_string {\n   my ($gff, $feat, $string) = @_;\n   chomp($string);\n\n   # according to the Sanger website, GFF2 should be single-tab\n   # separated elements, and the free-text at the end should contain\n   # text-translated tab symbols but no \"real\" tabs, so splitting on\n   # \\t is safe, and $attribs gets the entire attributes field to be\n   # parsed later\n   \n   # sendu: but the tag value pair can (should?) be separated by a tab. The\n   # 'no tabs' thing seems to apply only to the free text that is allowed for\n   # the value\n\n   my ($seqname, $source, $primary, $start, \n       $end, $score, $strand, $frame, @attribs) = split(/\\t+/, $string);\n   my $attribs = join ' ', @attribs;\n   \n   if ( !defined $frame ) {\n       $feat->throw(\"[$string] does not look like GFF2 to me\");\n   }\n   $feat->seq_id($seqname);\n   $feat->source_tag($source);\n   $feat->primary_tag($primary);\n   $feat->start($start);\n   $feat->end($end);\n   $feat->frame($frame);\n   if ( $score eq '.' ) {\n       # $feat->score(undef);\n   } else {\n       $feat->score($score);\n   }\n   if ( $strand eq '-' ) { $feat->strand(-1); }\n   if ( $strand eq '+' ) { $feat->strand(1); }\n   if ( $strand eq '.' ) { $feat->strand(0); }\n\n\n   #  <Begin Inefficient Code from Mark Wilkinson> \n   # this routine is necessay to allow the presence of semicolons in\n   # quoted text Semicolons are the delimiting character for new\n   # tag/value attributes.  it is more or less a \"state\" machine, with\n   # the \"quoted\" flag going up and down as we pass thorugh quotes to\n   # distinguish free-text semicolon and hash symbols from GFF control\n   # characters\n   \n   \n   my $flag = 0; # this could be changed to a bit and just be twiddled\n   my @parsed;\n\n   # run through each character one at a time and check it\n   # NOTE: changed to foreach loop which is more efficient in perl\n   # --jasons\n   for my $a ( split //, $attribs ) { \n       # flag up on entering quoted text, down on leaving it\n       if( $a eq '\"') { $flag = ( $flag == 0 ) ? 1:0 }\n       elsif( $a eq ';' && $flag ) { $a = \"INSERT_SEMICOLON_HERE\"}\n       elsif( $a eq '#' && ! $flag ) { last } \n       push @parsed, $a;\n   }\n   $attribs = join \"\", @parsed; # rejoin into a single string\n\n   # <End Inefficient Code>   \n   # Please feel free to fix this and make it more \"perlish\"\n\n   my @key_vals = split /;/, $attribs;   # attributes are semicolon-delimited\n\n   foreach my $pair ( @key_vals ) {\n       # replace semicolons that were removed from free-text above.\n       $pair =~ s/INSERT_SEMICOLON_HERE/;/g;        \n\n       # separate the key from the value\n       my ($blank, $key, $values) = split  /^\\s*([\\w\\d]+)\\s/, $pair; \n\n\n       if( defined $values ) {\n\t   my @values;\n\t   # free text is quoted, so match each free-text block\n\t   # and remove it from the $values string\n\t   while ($values =~ s/\"(.*?)\"//){\n\t       # and push it on to the list of values (tags may have\n\t       # more than one value... and the value may be undef)\t       \n\t       push @values, $1;\n\t   }\n\n\t   # and what is left over should be space-separated\n\t   # non-free-text values\n\n\t   my @othervals = split /\\s+/, $values;  \n\t   foreach my $othervalue(@othervals){\n\t       # get rid of any empty strings which might \n\t       # result from the split\n\t       if (CORE::length($othervalue) > 0) {push @values, $othervalue}  \n\t   }\n\n\t   foreach my $value(@values){\n\t       $feat->add_tag_value($key, $value);\n\t   }\n       }\n   }\n}\n\n\nsub _from_gff3_string {\n    my ($gff, $feat, $string) = @_;\n    chomp($string);\n\n    # according to the now nearly final GFF3 spec, columns should \n    # be tab separated, allowing unescaped spaces to occur in\n    # column 9\n\n    my ($seqname, $source, $primary, $start, $end, \n\t$score, $strand, $frame, $groups) = split(/\\t/, $string);\n    \n    if ( ! defined $frame ) {\n\t$feat->throw(\"[$string] does not look like GFF3 to me\");\n    }\n    $feat->seq_id($seqname);\n    $feat->source_tag($source);\n    $feat->primary_tag($primary);\n    $feat->start($start);\n    $feat->end($end);\n    $feat->frame($frame);\n    if ( $score eq '.' ) {\n\t#$feat->score(undef);\n    } else {\n\t$feat->score($score);\n    }\n    if ( $strand eq '-' ) { $feat->strand(-1); }\n    if ( $strand eq '+' ) { $feat->strand(1); }\n    if ( $strand eq '.' ) { $feat->strand(0); }\n    my @groups = split(/\\s*;\\s*/, $groups);\n\n    for my $group (@groups) {\n\tmy ($tag,$value) = split /=/,$group;\n\t$tag             = unescape($tag);\n\tmy @values       = map {unescape($_)} split /,/,$value;\n\tfor my $v ( @values ) {  $feat->add_tag_value($tag,$v); }\n    }\n}\n\n# taken from Bio::DB::GFF\nsub unescape {\n  my $v = shift;\n  $v =~ tr/+/ /;\n  $v =~ s/%([0-9a-fA-F]{2})/chr hex($1)/ge;\n  return $v;\n}\n\n=head2 write_feature\n\n Title   : write_feature\n Usage   : $gffio->write_feature($feature);\n Function: Writes the specified SeqFeatureI object in GFF format to the stream\n           associated with this instance.\n Returns : none\n Args    : An array of Bio::SeqFeatureI implementing objects to be serialized\n\n\nsub write_feature {\n    my ($self, @features) = @_;\n    return unless @features;\n    if( $self->{'_first'} && $self->gff_version() == 3 ) {\n\t$self->_print(\"##gff-version 3\\n\");\n    }\n    $self->{'_first'} = 0;\n    foreach my $feature ( @features ) {\n\t$self->_print($self->gff_string($feature).\"\\n\");\n    }\n}\n\n=head2 gff_string\n\n Title   : gff_string\n Usage   : $gffstr = $gffio->gff_string($feature);\n Function: Obtain the GFF-formatted representation of a SeqFeatureI object.\n           The formatting depends on the version specified at initialization.\n\n           This method is used by write_feature(). It actually dispatches to\n           one of the version-specific (private) methods.\n Example :\n Returns : A GFF-formatted string representation of the SeqFeature\n Args    : A Bio::SeqFeatureI implementing object to be GFF-stringified\n\n\nsub gff_string{\n    my ($self, $feature) = @_;\n\n    if($self->gff_version() == 1) {\n    \treturn $self->_gff1_string($feature);\n    } elsif( $self->gff_version() == 3 ) {\n    \treturn $self->_gff3_string($feature);\n    } elsif( $self->gff_version() == 2.5 ) {\n    \treturn $self->_gff25_string($feature);\n    } else {\n    \treturn $self->_gff2_string($feature);\n    }\n}\n\n=head2 _gff1_string\n\n Title   : _gff1_string\n Usage   : $gffstr = $gffio->_gff1_string\n Function: \n Example :\n Returns : A GFF1-formatted string representation of the SeqFeature\n Args    : A Bio::SeqFeatureI implementing object to be GFF-stringified\n\n\nsub _gff1_string{\n   my ($gff, $feat) = @_;\n   my ($str,$score,$frame,$name,$strand);\n\n   if( $feat->can('score') ) {\n       $score = $feat->score();\n   }\n   $score = '.' unless defined $score;\n\n   if( $feat->can('frame') ) {\n       $frame = $feat->frame();\n   }\n   $frame = '.' unless defined $frame;\n\n   $strand = $feat->strand();\n   if(! $strand) {\n       $strand = \".\";\n   } elsif( $strand == 1 ) {\n       $strand = '+';\n   } elsif ( $feat->strand == -1 ) {\n       $strand = '-';\n   }\n   \n   if( $feat->can('seqname') ) {\n       $name = $feat->seq_id();\n       $name ||= 'SEQ';\n   } else {\n       $name = 'SEQ';\n   }\n\n\n   $str = join(\"\\t\",\n                 $name,\n\t\t $feat->source_tag(),\n\t\t $feat->primary_tag(),\n\t\t $feat->start(),\n\t\t $feat->end(),\n\t\t $score,\n\t\t $strand,\n\t\t $frame);\n\n   foreach my $tag ( $feat->all_tags ) {\n       foreach my $value ( $feat->each_tag_value($tag) ) {\n\t   $str .= \" $tag=$value\" if $value;\n       }\n   }\n\n\n   return $str;\n}\n\n=head2 _gff2_string\n\n Title   : _gff2_string\n Usage   : $gffstr = $gffio->_gff2_string\n Function: \n Example :\n Returns : A GFF2-formatted string representation of the SeqFeature\n Args    : A Bio::SeqFeatureI implementing object to be GFF2-stringified\n\n\nsub _gff2_string{\n   my ($gff, $origfeat) = @_;\n    my $feat;\n   if ($origfeat->isa('Bio::SeqFeature::FeaturePair')){\n       $feat = $origfeat->feature2;\n   } else {\n       $feat = $origfeat;\n   }\n   my ($str1, $str2,$score,$frame,$name,$strand);\n\n   if( $feat->can('score') ) {\n       $score = $feat->score();\n   }\n   $score = '.' unless defined $score;\n\n   if( $feat->can('frame') ) {\n       $frame = $feat->frame();\n   }\n   $frame = '.' unless defined $frame;\n\n   $strand = $feat->strand();\n   if(! $strand) {\n       $strand = \".\";\n   } elsif( $strand == 1 ) {\n       $strand = '+';\n   } elsif ( $feat->strand == -1 ) {\n       $strand = '-';\n   }\n\n   if( $feat->can('seqname') ) {\n       $name = $feat->seq_id();\n       $name ||= 'SEQ';\n   } else {\n       $name = 'SEQ';\n   }\n   $str1 = join(\"\\t\",\n                 $name,\n\t\t $feat->source_tag(),\n\t\t $feat->primary_tag(),\n\t\t $feat->start(),\n\t\t $feat->end(),\n\t\t $score,\n\t\t $strand,\n\t\t $frame);\n   # the routine below is the only modification I made to the original\n   # ->gff_string routine (above) as on November 17th, 2000, the\n   # Sanger webpage describing GFF2 format reads: \"From version 2\n   # onwards, the attribute field must have a tag value structure\n   # following the syntax used within objects in a .ace file,\n   # flattened onto one line by semicolon separators. Tags must be\n   # standard identifiers ([A-Za-z][A-Za-z0-9_]*).  Free text values\n   # must be quoted with double quotes\".\n\n   # MW\n\n   \n   my @all_tags = $feat->all_tags;\n   my @group;\n   if (@all_tags) {  # only play this game if it is worth playing...\n       foreach my $tag ( @all_tags ) {\n\t   my @v;\n\t   foreach my $value ( $feat->each_tag_value($tag) ) {\n \t       unless( defined $value && length($value) ) {\n\t\t   $value = '\"\"';\n\t       } elsif ($value =~ /[^A-Za-z0-9_]/){\n\t\t   $value =~ s/\\t/\\\\t/g; # substitute tab and newline \n\t\t                         # characters\n\t\t   $value =~ s/\\n/\\\\n/g; # to their UNIX equivalents\n\t\t   $value = '\"' . $value . '\" ';\n\t       }                                 # if the value contains \n\t                                         # anything other than valid \n\t                                         # tag/value characters, then \n\t                                         # quote it\n\t       push @v, $value;\n\t       # for this tag (allowed in GFF2 and .ace format)\n\t   }\n\t   push @group, \"$tag \".join(\" \", @v);\n       }\n   }\n   $str2 .= join(' ; ', @group);\n   # Add Target information for Feature Pairs\n   if( ! $feat->has_tag('Target') && # This is a bad hack IMHO\n       ! $feat->has_tag('Group') &&\n       $origfeat->isa('Bio::SeqFeature::FeaturePair') ) {\n       $str2 = sprintf(\"Target %s %d %d\", $origfeat->feature1->seq_id,\n\t\t       ( $origfeat->feature1->strand < 0 ? \n\t\t\t ( $origfeat->feature1->end,\n\t\t\t   $origfeat->feature1->start) :\n\t\t\t ( $origfeat->feature1->start,\n\t\t\t   $origfeat->feature1->end) \n\t\t\t )) . ($str2?\" ; \".$str2:\"\");  # need to put Target information before other tag/value pairs - mw\n   }\n   return $str1.\"\\t\".$str2;\n}\n\n\n\n=head2 _gff25_string\n\n Title   : _gff25_string\n Usage   : $gffstr = $gffio->_gff2_string\n Function: To get a format of GFF that is peculiar to Gbrowse/Bio::DB::GFF\n Example :\n Returns : A GFF2.5-formatted string representation of the SeqFeature\n Args    : A Bio::SeqFeatureI implementing object to be GFF2.5-stringified","parameters":[{"label":"$gff"},{"label":"$origfeat"}],"label":"_gff25_string($gff,$origfeat)"},"kind":12,"line":880,"children":[{"name":"$gff","definition":"my","containerName":"_gff25_string","localvar":"my","kind":13,"line":881},{"name":"$origfeat","containerName":"_gff25_string","kind":13,"line":881},{"line":882,"kind":13,"localvar":"my","name":"$feat","definition":"my","containerName":"_gff25_string"},{"name":"$origfeat","containerName":"_gff25_string","kind":13,"line":883},{"name":"isa","containerName":"_gff25_string","kind":12,"line":883},{"line":884,"kind":13,"containerName":"_gff25_string","name":"$feat"},{"kind":13,"line":884,"containerName":"_gff25_string","name":"$origfeat"},{"name":"feature2","containerName":"_gff25_string","kind":12,"line":884},{"line":886,"kind":13,"name":"$feat","containerName":"_gff25_string"},{"kind":13,"line":886,"containerName":"_gff25_string","name":"$origfeat"},{"kind":13,"line":888,"name":"$str1","definition":"my","containerName":"_gff25_string","localvar":"my"},{"name":"$str2","containerName":"_gff25_string","line":888,"kind":13},{"name":"$score","containerName":"_gff25_string","kind":13,"line":888},{"kind":13,"line":888,"containerName":"_gff25_string","name":"$frame"},{"line":888,"kind":13,"containerName":"_gff25_string","name":"$name"},{"kind":13,"line":888,"name":"$strand","containerName":"_gff25_string"},{"kind":13,"line":890,"name":"$feat","containerName":"_gff25_string"},{"name":"can","containerName":"_gff25_string","kind":12,"line":890},{"kind":13,"line":891,"name":"$score","containerName":"_gff25_string"},{"containerName":"_gff25_string","name":"$feat","line":891,"kind":13},{"line":891,"kind":12,"containerName":"_gff25_string","name":"score"},{"line":893,"kind":13,"name":"$score","containerName":"_gff25_string"},{"name":"$score","containerName":"_gff25_string","kind":13,"line":893},{"containerName":"_gff25_string","name":"$feat","kind":13,"line":895},{"name":"can","containerName":"_gff25_string","line":895,"kind":12},{"kind":13,"line":896,"name":"$frame","containerName":"_gff25_string"},{"name":"$feat","containerName":"_gff25_string","line":896,"kind":13},{"name":"frame","containerName":"_gff25_string","kind":12,"line":896},{"line":898,"kind":13,"name":"$frame","containerName":"_gff25_string"},{"containerName":"_gff25_string","name":"$frame","line":898,"kind":13},{"name":"$strand","containerName":"_gff25_string","line":900,"kind":13},{"name":"$feat","containerName":"_gff25_string","kind":13,"line":900},{"name":"strand","containerName":"_gff25_string","kind":12,"line":900},{"kind":13,"line":901,"containerName":"_gff25_string","name":"$strand"},{"name":"$strand","containerName":"_gff25_string","kind":13,"line":902},{"kind":13,"line":903,"containerName":"_gff25_string","name":"$strand"},{"name":"$strand","containerName":"_gff25_string","line":904,"kind":13},{"line":905,"kind":13,"containerName":"_gff25_string","name":"$feat"},{"name":"strand","containerName":"_gff25_string","kind":12,"line":905},{"kind":13,"line":906,"containerName":"_gff25_string","name":"$strand"},{"containerName":"_gff25_string","name":"$feat","kind":13,"line":909},{"kind":12,"line":909,"name":"can","containerName":"_gff25_string"},{"name":"$name","containerName":"_gff25_string","kind":13,"line":910},{"line":910,"kind":13,"containerName":"_gff25_string","name":"$feat"},{"containerName":"_gff25_string","name":"seq_id","line":910,"kind":12},{"name":"$name","containerName":"_gff25_string","line":911,"kind":13},{"line":913,"kind":13,"containerName":"_gff25_string","name":"$name"},{"kind":13,"line":915,"containerName":"_gff25_string","name":"$str1"},{"containerName":"_gff25_string","name":"$name","line":916,"kind":13},{"line":917,"kind":13,"containerName":"_gff25_string","name":"$feat"},{"kind":12,"line":917,"name":"source_tag","containerName":"_gff25_string"},{"containerName":"_gff25_string","name":"$feat","kind":13,"line":918},{"kind":12,"line":918,"containerName":"_gff25_string","name":"primary_tag"},{"kind":13,"line":919,"name":"$feat","containerName":"_gff25_string"},{"kind":12,"line":919,"name":"start","containerName":"_gff25_string"},{"containerName":"_gff25_string","name":"$feat","line":920,"kind":13},{"name":"end","containerName":"_gff25_string","kind":12,"line":920},{"kind":13,"line":921,"name":"$score","containerName":"_gff25_string"},{"containerName":"_gff25_string","name":"$strand","line":922,"kind":13},{"containerName":"_gff25_string","name":"$frame","kind":13,"line":923},{"line":925,"kind":13,"localvar":"my","name":"@all_tags","definition":"my","containerName":"_gff25_string"},{"name":"$feat","containerName":"_gff25_string","kind":13,"line":925},{"kind":12,"line":925,"name":"all_tags","containerName":"_gff25_string"},{"kind":13,"line":926,"containerName":"_gff25_string","name":"@group","definition":"my","localvar":"my"},{"line":926,"kind":13,"localvar":"my","name":"@firstgroup","definition":"my","containerName":"_gff25_string"},{"kind":13,"line":927,"containerName":"_gff25_string","name":"@all_tags"},{"kind":13,"line":928,"name":"$tag","definition":"my","containerName":"_gff25_string","localvar":"my"},{"kind":13,"line":928,"containerName":"_gff25_string","name":"@all_tags"},{"containerName":"_gff25_string","name":"@v","definition":"my","localvar":"my","kind":13,"line":929},{"localvar":"my","definition":"my","name":"$value","containerName":"_gff25_string","line":930,"kind":13},{"name":"$feat","containerName":"_gff25_string","kind":13,"line":930},{"name":"each_tag_value","containerName":"_gff25_string","kind":12,"line":930},{"name":"$tag","containerName":"_gff25_string","line":930,"kind":13},{"line":931,"kind":13,"containerName":"_gff25_string","name":"$value"},{"containerName":"_gff25_string","name":"$value","kind":13,"line":931},{"line":932,"kind":13,"containerName":"_gff25_string","name":"$value"},{"name":"$value","containerName":"_gff25_string","kind":13,"line":933},{"line":934,"kind":13,"name":"$value","containerName":"_gff25_string"},{"line":936,"kind":13,"name":"$value","containerName":"_gff25_string"},{"name":"$value","containerName":"_gff25_string","line":937,"kind":13},{"line":937,"kind":13,"name":"$value","containerName":"_gff25_string"},{"kind":13,"line":942,"name":"@v","containerName":"_gff25_string"},{"kind":13,"line":942,"containerName":"_gff25_string","name":"$value"},{"name":"$tag","containerName":"_gff25_string","kind":13,"line":945},{"name":"$tag","containerName":"_gff25_string","kind":13,"line":945},{"name":"@firstgroup","containerName":"_gff25_string","line":946,"kind":13},{"line":946,"kind":13,"containerName":"_gff25_string","name":"@v"},{"line":948,"kind":13,"containerName":"_gff25_string","name":"@group"},{"containerName":"_gff25_string","name":"@v","line":948,"kind":13},{"containerName":"_gff25_string","name":"$str2","kind":13,"line":952},{"name":"@firstgroup","containerName":"_gff25_string","line":952,"kind":13},{"containerName":"_gff25_string","name":"@group","line":952,"kind":13},{"kind":13,"line":954,"name":"$feat","containerName":"_gff25_string"},{"line":954,"kind":12,"containerName":"_gff25_string","name":"has_tag"},{"name":"$feat","containerName":"_gff25_string","line":955,"kind":13},{"kind":12,"line":955,"containerName":"_gff25_string","name":"has_tag"},{"containerName":"_gff25_string","name":"$origfeat","kind":13,"line":956},{"kind":12,"line":956,"containerName":"_gff25_string","name":"isa"},{"name":"$str2","containerName":"_gff25_string","line":957,"kind":13},{"name":"$origfeat","containerName":"_gff25_string","line":957,"kind":13},{"line":957,"kind":12,"containerName":"_gff25_string","name":"feature1"},{"line":957,"kind":12,"containerName":"_gff25_string","name":"seq_id"},{"containerName":"_gff25_string","name":"$origfeat","line":958,"kind":13},{"kind":12,"line":958,"containerName":"_gff25_string","name":"feature1"},{"name":"strand","containerName":"_gff25_string","line":958,"kind":12},{"containerName":"_gff25_string","name":"$origfeat","line":959,"kind":13},{"kind":12,"line":959,"containerName":"_gff25_string","name":"feature1"},{"containerName":"_gff25_string","name":"end","line":959,"kind":12},{"line":960,"kind":13,"containerName":"_gff25_string","name":"$origfeat"},{"containerName":"_gff25_string","name":"feature1","line":960,"kind":12},{"kind":12,"line":960,"name":"start","containerName":"_gff25_string"},{"name":"$origfeat","containerName":"_gff25_string","line":961,"kind":13},{"containerName":"_gff25_string","name":"feature1","kind":12,"line":961},{"name":"start","containerName":"_gff25_string","kind":12,"line":961},{"line":962,"kind":13,"containerName":"_gff25_string","name":"$origfeat"},{"name":"feature1","containerName":"_gff25_string","kind":12,"line":962},{"kind":12,"line":962,"name":"end","containerName":"_gff25_string"},{"line":963,"kind":13,"name":"$str2","containerName":"_gff25_string"},{"containerName":"_gff25_string","name":"$str2","kind":13,"line":963},{"containerName":"_gff25_string","name":"$str1","line":965,"kind":13},{"line":965,"kind":13,"name":"$str2","containerName":"_gff25_string"}],"name":"_gff25_string","range":{"start":{"character":0,"line":880},"end":{"character":9999,"line":966}}},{"name":"_gff3_string","range":{"start":{"line":980,"character":0},"end":{"character":9999,"line":1130}},"kind":12,"children":[{"definition":"my","name":"$gff","containerName":"_gff3_string","localvar":"my","kind":13,"line":981},{"containerName":"_gff3_string","name":"$origfeat","kind":13,"line":981},{"localvar":"my","containerName":"_gff3_string","name":"$feat","definition":"my","line":982,"kind":13},{"name":"$origfeat","containerName":"_gff3_string","kind":13,"line":983},{"kind":12,"line":983,"name":"isa","containerName":"_gff3_string"},{"kind":13,"line":984,"name":"$feat","containerName":"_gff3_string"},{"kind":13,"line":984,"name":"$origfeat","containerName":"_gff3_string"},{"name":"feature2","containerName":"_gff3_string","kind":12,"line":984},{"containerName":"_gff3_string","name":"$feat","kind":13,"line":986},{"kind":13,"line":986,"name":"$origfeat","containerName":"_gff3_string"},{"localvar":"my","containerName":"_gff3_string","name":"$ID","definition":"my","line":989,"kind":13},{"name":"$gff","containerName":"_gff3_string","kind":13,"line":989},{"kind":12,"line":989,"containerName":"_gff3_string","name":"_incrementGFF3ID"},{"line":991,"kind":13,"localvar":"my","definition":"my","name":"$score","containerName":"_gff3_string"},{"kind":13,"line":991,"name":"$frame","containerName":"_gff3_string"},{"containerName":"_gff3_string","name":"$name","line":991,"kind":13},{"containerName":"_gff3_string","name":"$strand","kind":13,"line":991},{"name":"$feat","containerName":"_gff3_string","line":993,"kind":13},{"kind":12,"line":993,"containerName":"_gff3_string","name":"can"},{"line":994,"kind":13,"containerName":"_gff3_string","name":"$score"},{"line":994,"kind":13,"containerName":"_gff3_string","name":"$feat"},{"kind":12,"line":994,"containerName":"_gff3_string","name":"score"},{"containerName":"_gff3_string","name":"$score","line":996,"kind":13},{"line":996,"kind":13,"name":"$score","containerName":"_gff3_string"},{"name":"$feat","containerName":"_gff3_string","kind":13,"line":998},{"line":998,"kind":12,"name":"can","containerName":"_gff3_string"},{"line":999,"kind":13,"containerName":"_gff3_string","name":"$frame"},{"containerName":"_gff3_string","name":"$feat","kind":13,"line":999},{"line":999,"kind":12,"name":"frame","containerName":"_gff3_string"},{"kind":13,"line":1001,"containerName":"_gff3_string","name":"$frame"},{"line":1001,"kind":13,"containerName":"_gff3_string","name":"$frame"},{"name":"$strand","containerName":"_gff3_string","kind":13,"line":1003},{"name":"$feat","containerName":"_gff3_string","line":1003,"kind":13},{"containerName":"_gff3_string","name":"strand","kind":12,"line":1003},{"containerName":"_gff3_string","name":"$strand","line":1005,"kind":13},{"containerName":"_gff3_string","name":"$strand","kind":13,"line":1006},{"containerName":"_gff3_string","name":"$strand","kind":13,"line":1007},{"line":1008,"kind":13,"containerName":"_gff3_string","name":"$strand"},{"kind":13,"line":1009,"containerName":"_gff3_string","name":"$feat"},{"name":"strand","containerName":"_gff3_string","line":1009,"kind":12},{"kind":13,"line":1010,"containerName":"_gff3_string","name":"$strand"},{"containerName":"_gff3_string","name":"$feat","kind":13,"line":1013},{"name":"can","containerName":"_gff3_string","line":1013,"kind":12},{"name":"$name","containerName":"_gff3_string","line":1014,"kind":13},{"kind":13,"line":1014,"name":"$feat","containerName":"_gff3_string"},{"line":1014,"kind":12,"containerName":"_gff3_string","name":"seq_id"},{"name":"$name","containerName":"_gff3_string","kind":13,"line":1015},{"name":"$name","containerName":"_gff3_string","line":1017,"kind":13},{"localvar":"my","containerName":"_gff3_string","name":"@groups","definition":"my","line":1020,"kind":13},{"line":1023,"kind":13,"localvar":"my","definition":"my","name":"@all_tags","containerName":"_gff3_string"},{"kind":13,"line":1023,"containerName":"_gff3_string","name":"$GFF3_ID_Tags"},{"containerName":"_gff3_string","name":"$feat","kind":13,"line":1023},{"kind":12,"line":1023,"containerName":"_gff3_string","name":"all_tags"},{"kind":13,"line":1024,"containerName":"_gff3_string","name":"$t","definition":"my","localvar":"my"},{"name":"$GFF3_ID_Tags","containerName":"_gff3_string","line":1024,"kind":13},{"containerName":"_gff3_string","name":"$b","kind":13,"line":1024},{"line":1024,"kind":13,"containerName":"_gff3_string","name":"$GFF3_ID_Tags"},{"containerName":"_gff3_string","name":"$a","kind":13,"line":1024},{"kind":13,"line":1025,"name":"%GFF3_ID_Tags","containerName":"_gff3_string"},{"containerName":"_gff3_string","name":"@all_tags","line":1026,"kind":13},{"name":"$t","containerName":"_gff3_string","line":1026,"kind":13},{"line":1026,"kind":13,"name":"$feat","containerName":"_gff3_string"},{"kind":12,"line":1026,"name":"has_tag","containerName":"_gff3_string"},{"line":1026,"kind":13,"name":"$t","containerName":"_gff3_string"},{"localvar":"my","containerName":"_gff3_string","name":"$tag","definition":"my","line":1029,"kind":13},{"containerName":"_gff3_string","name":"@all_tags","kind":13,"line":1029},{"line":1031,"kind":13,"containerName":"_gff3_string","name":"$tag"},{"line":1031,"kind":13,"name":"$origfeat","containerName":"_gff3_string"},{"kind":12,"line":1031,"containerName":"_gff3_string","name":"isa"},{"localvar":"my","containerName":"_gff3_string","name":"$target_id","definition":"my","line":1033,"kind":13},{"kind":13,"line":1033,"containerName":"_gff3_string","name":"$b"},{"line":1033,"kind":13,"name":"$e","containerName":"_gff3_string"},{"name":"$strand","containerName":"_gff3_string","kind":13,"line":1033},{"containerName":"_gff3_string","name":"$feat","kind":13,"line":1033},{"kind":12,"line":1033,"containerName":"_gff3_string","name":"get_tag_values"},{"kind":13,"line":1033,"name":"$tag","containerName":"_gff3_string"},{"kind":13,"line":1034,"containerName":"_gff3_string","name":"$e"},{"line":1034,"kind":13,"containerName":"_gff3_string","name":"$b"},{"containerName":"_gff3_string","name":"$target_id","line":1034,"kind":13},{"name":"$b","containerName":"_gff3_string","kind":13,"line":1035},{"kind":13,"line":1035,"containerName":"_gff3_string","name":"$e"},{"line":1035,"kind":13,"containerName":"_gff3_string","name":"$e"},{"containerName":"_gff3_string","name":"$b","kind":13,"line":1035},{"name":"$strand","containerName":"_gff3_string","line":1035,"kind":13},{"containerName":"_gff3_string","name":"$strand","kind":13,"line":1035},{"line":1036,"kind":13,"containerName":"_gff3_string","name":"$target_id"},{"line":1037,"kind":13,"name":"@groups","containerName":"_gff3_string"},{"kind":13,"line":1037,"name":"$target_id","containerName":"_gff3_string"},{"line":1037,"kind":13,"name":"$b","containerName":"_gff3_string"},{"containerName":"_gff3_string","name":"$e","kind":13,"line":1037},{"line":1041,"kind":13,"localvar":"my","containerName":"_gff3_string","definition":"my","name":"$valuestr"},{"line":1045,"kind":13,"localvar":"my","definition":"my","name":"@v","containerName":"_gff3_string"},{"line":1046,"kind":13,"localvar":"my","containerName":"_gff3_string","name":"$value","definition":"my"},{"line":1046,"kind":13,"containerName":"_gff3_string","name":"$feat"},{"name":"each_tag_value","containerName":"_gff3_string","line":1046,"kind":12},{"containerName":"_gff3_string","name":"$tag","kind":13,"line":1046},{"kind":13,"line":1047,"containerName":"_gff3_string","name":"$value"},{"containerName":"_gff3_string","name":"$value","line":1047,"kind":13},{"name":"$value","containerName":"_gff3_string","kind":13,"line":1049},{"containerName":"_gff3_string","name":"$value","line":1050,"kind":13},{"containerName":"_gff3_string","name":"$value","line":1050,"kind":13},{"line":1050,"kind":12,"name":"text","containerName":"_gff3_string"},{"kind":13,"line":1053,"name":"$value","containerName":"_gff3_string"},{"kind":13,"line":1054,"containerName":"_gff3_string","name":"$value"},{"name":"$value","containerName":"_gff3_string","line":1056,"kind":13},{"line":1061,"kind":13,"name":"$value","containerName":"_gff3_string"},{"containerName":"_gff3_string","name":"$value","line":1066,"kind":13},{"kind":13,"line":1068,"name":"@v","containerName":"_gff3_string"},{"name":"$value","containerName":"_gff3_string","kind":13,"line":1068},{"containerName":"_gff3_string","name":"$tag","line":1071,"kind":13},{"name":"$tag","containerName":"_gff3_string","kind":13,"line":1071},{"line":1071,"kind":13,"containerName":"_gff3_string","name":"$tag"},{"name":"@groups","containerName":"_gff3_string","kind":13,"line":1074},{"containerName":"_gff3_string","name":"@v","kind":13,"line":1074},{"containerName":"_gff3_string","name":"$feat","line":1077,"kind":13},{"containerName":"_gff3_string","name":"has_tag","kind":12,"line":1077},{"name":"$feat","containerName":"_gff3_string","kind":13,"line":1078},{"kind":12,"line":1078,"containerName":"_gff3_string","name":"has_tag"},{"line":1079,"kind":13,"containerName":"_gff3_string","name":"$origfeat"},{"kind":12,"line":1079,"name":"isa","containerName":"_gff3_string"},{"containerName":"_gff3_string","definition":"my","name":"$target_id","localvar":"my","kind":13,"line":1081},{"name":"$origfeat","containerName":"_gff3_string","kind":13,"line":1081},{"kind":12,"line":1081,"name":"feature1","containerName":"_gff3_string"},{"line":1081,"kind":12,"containerName":"_gff3_string","name":"seq_id"},{"line":1082,"kind":13,"containerName":"_gff3_string","name":"$target_id"},{"containerName":"_gff3_string","name":"@groups","line":1084,"kind":13},{"line":1085,"kind":13,"containerName":"_gff3_string","name":"$target_id"},{"containerName":"_gff3_string","name":"$origfeat","line":1086,"kind":13},{"kind":12,"line":1086,"name":"feature1","containerName":"_gff3_string"},{"kind":12,"line":1086,"name":"strand","containerName":"_gff3_string"},{"containerName":"_gff3_string","name":"$origfeat","line":1087,"kind":13},{"name":"feature1","containerName":"_gff3_string","kind":12,"line":1087},{"name":"end","containerName":"_gff3_string","line":1087,"kind":12},{"kind":13,"line":1088,"name":"$origfeat","containerName":"_gff3_string"},{"containerName":"_gff3_string","name":"feature1","line":1088,"kind":12},{"line":1088,"kind":12,"name":"start","containerName":"_gff3_string"},{"kind":13,"line":1089,"name":"$origfeat","containerName":"_gff3_string"},{"name":"feature1","containerName":"_gff3_string","line":1089,"kind":12},{"line":1089,"kind":12,"containerName":"_gff3_string","name":"start"},{"containerName":"_gff3_string","name":"$origfeat","kind":13,"line":1090},{"kind":12,"line":1090,"containerName":"_gff3_string","name":"feature1"},{"kind":12,"line":1090,"name":"end","containerName":"_gff3_string"},{"line":1095,"kind":13,"name":"$feat","containerName":"_gff3_string"},{"containerName":"_gff3_string","name":"can","kind":12,"line":1095},{"line":1095,"kind":13,"name":"$feat","containerName":"_gff3_string"},{"line":1095,"kind":12,"name":"name","containerName":"_gff3_string"},{"kind":13,"line":1097,"name":"@groups","containerName":"_gff3_string"},{"line":1097,"kind":13,"name":"$feat","containerName":"_gff3_string"},{"kind":12,"line":1097,"containerName":"_gff3_string","name":"name"},{"localvar":"my","definition":"my","name":"$gff_string","containerName":"_gff3_string","line":1100,"kind":13},{"line":1101,"kind":13,"containerName":"_gff3_string","name":"$feat"},{"name":"location","containerName":"_gff3_string","line":1101,"kind":12},{"containerName":"_gff3_string","name":"isa","kind":12,"line":1101},{"containerName":"_gff3_string","definition":"my","name":"@locs","localvar":"my","kind":13,"line":1102},{"containerName":"_gff3_string","name":"$feat","kind":13,"line":1102},{"kind":12,"line":1102,"containerName":"_gff3_string","name":"location"},{"kind":12,"line":1102,"name":"each_Location","containerName":"_gff3_string"},{"line":1103,"kind":13,"localvar":"my","containerName":"_gff3_string","name":"$loc","definition":"my"},{"containerName":"_gff3_string","name":"@locs","kind":13,"line":1103},{"name":"$gff_string","containerName":"_gff3_string","kind":13,"line":1104},{"line":1105,"kind":13,"containerName":"_gff3_string","name":"$name"},{"containerName":"_gff3_string","name":"$feat","kind":13,"line":1106},{"name":"source_tag","containerName":"_gff3_string","line":1106,"kind":12},{"line":1107,"kind":13,"name":"$feat","containerName":"_gff3_string"},{"kind":12,"line":1107,"name":"primary_tag","containerName":"_gff3_string"},{"line":1108,"kind":13,"name":"$loc","containerName":"_gff3_string"},{"name":"start","containerName":"_gff3_string","kind":12,"line":1108},{"name":"$loc","containerName":"_gff3_string","line":1109,"kind":13},{"name":"end","containerName":"_gff3_string","kind":12,"line":1109},{"line":1110,"kind":13,"name":"$score","containerName":"_gff3_string"},{"name":"$strand","containerName":"_gff3_string","line":1111,"kind":13},{"line":1112,"kind":13,"name":"$frame","containerName":"_gff3_string"},{"name":"@groups","containerName":"_gff3_string","kind":13,"line":1113},{"containerName":"_gff3_string","name":"$gff_string","kind":13,"line":1115},{"line":1116,"kind":13,"containerName":"_gff3_string","name":"$gff_string"},{"name":"$gff_string","containerName":"_gff3_string","kind":13,"line":1118},{"line":1119,"kind":13,"name":"$name","containerName":"_gff3_string"},{"kind":13,"line":1120,"containerName":"_gff3_string","name":"$feat"},{"kind":12,"line":1120,"containerName":"_gff3_string","name":"source_tag"},{"containerName":"_gff3_string","name":"$feat","kind":13,"line":1121},{"name":"primary_tag","containerName":"_gff3_string","line":1121,"kind":12},{"name":"$feat","containerName":"_gff3_string","line":1122,"kind":13},{"line":1122,"kind":12,"containerName":"_gff3_string","name":"start"},{"containerName":"_gff3_string","name":"$feat","kind":13,"line":1123},{"line":1123,"kind":12,"containerName":"_gff3_string","name":"end"},{"kind":13,"line":1124,"containerName":"_gff3_string","name":"$score"},{"containerName":"_gff3_string","name":"$strand","line":1125,"kind":13},{"kind":13,"line":1126,"name":"$frame","containerName":"_gff3_string"},{"containerName":"_gff3_string","name":"@groups","line":1127,"kind":13},{"kind":13,"line":1129,"containerName":"_gff3_string","name":"$gff_string"}],"line":980,"definition":"sub","containerName":"main::","signature":{"label":"_gff3_string($gff,$origfeat)","documentation":"1;\n# $Id: GFF.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::GFF\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by the Bioperl core team\n#\n# Copyright Matthew Pocock\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::GFF - A Bio::SeqAnalysisParserI compliant GFF format parser\n\n=head1 SYNOPSIS\n\n    use Bio::Tools::GFF;\n\n    # specify input via -fh or -file\n    my $gffio = Bio::Tools::GFF->new(-fh => \\*STDIN, -gff_version => 2);\n    my $feature;\n    # loop over the input stream\n    while($feature = $gffio->next_feature()) {\n        # do something with feature\n    }\n    $gffio->close();\n\n    # you can also obtain a GFF parser as a SeqAnalasisParserI in\n    # HT analysis pipelines (see Bio::SeqAnalysisParserI and\n    # Bio::Factory::SeqAnalysisParserFactory)\n    my $factory = Bio::Factory::SeqAnalysisParserFactory->new();\n    my $parser = $factory->get_parser(-input => \\*STDIN, -method => \"gff\");\n    while($feature = $parser->next_feature()) {\n        # do something with feature\n    }\n\n=head1 DESCRIPTION\n\nThis class provides a simple GFF parser and writer. In the sense of a\nSeqAnalysisParser, it parses an input file or stream into SeqFeatureI\nobjects, but is not in any way specific to a particular analysis\nprogram and the output that program produces.\n\nThat is, if you can get your analysis program spit out GFF, here is\nyour result parser.\n\n=head1 GFF3 AND SEQUENCE DATA\n\nGFF3 supports sequence data; see\n\nhttp://www.sequenceontology.org/gff3.shtml\n\nThere are a number of ways to deal with this -\n\nIf you call\n\n  $gffio->ignore_sequence(1)\n\nprior to parsing the sequence data is ignored; this is useful if you\njust want the features. It avoids the memory overhead in building and\ncaching sequences\n\nAlternatively, you can call either\n\n  $gffio->get_seqs()\n\nOr\n\n  $gffio->seq_id_by_h()\n\nAt the B<end> of parsing to get either a list or hashref of Bio::Seq\nobjects (see the documentation for each of these methods)\n\nNote that these objects will not have the features attached - you have\nto do this yourself, OR call\n\n  $gffio->features_attached_to_seqs(1)\n\nPRIOR to parsing; this will ensure that the Seqs have the features\nattached; ie you will then be able to call\n\n  $seq->get_SeqFeatures();\n\nAnd use Bio::SeqIO methods\n\nNote that auto-attaching the features to seqs will incur a higher\nmemory overhead as the features must be cached until the sequence data\nis found\n\n=head1 TODO\n\nMake a Bio::SeqIO class specifically for GFF3 with sequence data\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Matthew Pocock\n\nEmail mrp-at-sanger.ac.uk\n\n=head1 CONTRIBUTORS \n\nJason Stajich, jason-at-biperl-dot-org\nChris Mungall, cjm-at-fruitfly-dot-org\nSteffen Grossmann [SG], grossman at molgen.mpg.de\nMalcolm Cook, mec-at-stowers-institute.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tools::GFF;\n\nuse vars qw($HAS_HTML_ENTITIES);\nuse strict;\n\nuse Bio::Seq::SeqFactory;\nuse Bio::LocatableSeq;\nuse Bio::SeqFeature::Generic;\n\nuse base qw(Bio::Root::Root Bio::SeqAnalysisParserI Bio::Root::IO);\n\nmy $i = 0;\nmy %GFF3_ID_Tags = map { $_ => $i++ } qw(ID Parent Target);\n\n=head2 new\n\n Title   : new\n Usage   : my $parser = Bio::Tools::GFF->new(-gff_version => 2,\n\t\t\t\t\t    -file        => \"filename.gff\");\n           or\n           my $writer = Bio::Tools::GFF->new(-gff_version => 3,\n\t\t\t\t\t    -file        => \">filename.gff3\");\n Function: Creates a new instance. Recognized named parameters are -file, -fh,\n           and -gff_version.\n Returns : a new object\n Args    : named parameters\n           -gff_version => [1,2,3]\n\n\n\n{   # make a class variable such that we can generate unique ID's over\n    # a session, no matter how many instances of GFF.pm we make\n    # since these have to be unique within the scope of a GFF file.\n    \n    my $gff3_featureID = 0;\n    \n    sub _incrementGFF3ID {\n        my ($self) = @_;\n        return ++ $gff3_featureID;\n    }\n}\n\n\nsub new {\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n  \n  my ($gff_version, $noparse) = $self->_rearrange([qw(GFF_VERSION NOPARSE)],@args);\n\n  # initialize IO\n  $self->_initialize_io(@args);\n  $self->_parse_header() unless $noparse;\n\n  $gff_version ||= 2;\n  if( ! $self->gff_version($gff_version) )  {\n      $self->throw(\"Can't build a GFF object with the unknown version \".\n\t\t   $gff_version);\n  }\n  $self->{'_first'} = 1;\n  return $self;\n}\n\n=head2 _parse_header\n\n Title   : _parse_header\n Usage   : $gffio->_parse_header()\n Function: used to turn parse GFF header lines.  currently\n           produces Bio::LocatableSeq objects from ##sequence-region\n           lines\n Returns : 1 on success\n Args    : none\n\n\n\nsub _parse_header{\n   my ($self) = @_;\n\n   my @unhandled;\n   local $^W = 0; # hide warnings when we try and parse from a file opened\n                  # for writing - there isn't really a better way to do\n                  # AFAIK - cannot detech if a FH is read or write.\n   while(my $line = $self->_readline()){\n \t my $handled = 0;\n\t next if /^\\s+$/;\n\t if($line =~ /^\\#\\#sequence-region\\s+(\\S+)\\s+(\\S+)\\s+(\\S+)\\s*/){\n\t   my($seqid,$start,$end) = ($1,$2,$3);\n\t   push @{ $self->{'segments'} }, Bio::LocatableSeq->new\n\t       (\n\t\t-id    => unescape($seqid),\n\t\t-start => $start,\n\t\t-end   => $end,\n                -length => ($end - $start + 1),  ## make the length explicit\n\t\t);\n\t   $handled = 1;\n\t } elsif($line =~ /^(\\#\\#feature-ontology)/) {\n\t   #to be implemented\n\t   $self->warn(\"$1 header tag parsing unimplemented\");\n\t } elsif($line =~ /^(\\#\\#attribute-ontology)/) {\n\t   #to be implemented\n\t   $self->warn(\"$1 header tag parsing unimplemented\");\n\t } elsif($line =~ /^(\\#\\#source-ontology)/) {\n\t   #to be implemented\n\t   $self->warn(\"$1 header tag parsing unimplemented\");\n\t } elsif($line =~ /^(\\#\\#\\#)/) {\n\t   #to be implemented\n\t   $self->warn(\"$1 header tag parsing unimplemented\");\n\t } elsif($line =~ /^(\\#\\#FASTA)/) {\n            # initial ##FASTA is optional - artemis does not use it\n            $line = $self->_readline();\n            if ($line !~ /^\\>(\\S+)/) {\n                $self->throw(\"##FASTA directive must be followed by fasta header, not: $line\");\n            }\n\t } else {\n         }\n         \n         if ($line =~ /^\\>(.*)/) {\n             # seq data can be at header or footer\n             my $seq = $self->_parse_sequence($line);\n             if ($seq) {\n                 $self->_seq_by_id_h->{$seq->primary_id} = $seq;\n             }\n         }\n             \n\n \t if(!$handled){\n\t   push @unhandled, $line\n \t }\n\n\t #looks like the header is over!\n\t last unless $line =~ /^\\#/;\n   }\n\n   foreach my $line (@unhandled){\n\t $self->_pushback($line);\n   }\n\n   return 1;\n}\n\nsub _parse_sequence {\n    my ($self, $line) = @_;\n\n    if ($line =~ /^\\>(.*)/) {\n        \n        my $seqid = $1;\n        $seqid =~ s/\\s+$//;\n        my $desc = '';\n        if ($seqid =~ /(\\S+)\\s+(.*)/) {\n            ($seqid, $desc) = ($1,$2);\n        }\n        my $res = '';\n        while (my $line = $self->_readline) {\n            if ($line =~ /^\\#/) {\n                last;\n            }\n            if ($line =~ /^\\>/) {\n                $self->_pushback($line);\n                last;\n            }\n            $line =~ s/\\s//g;\n            $res .= $line;\n        }\n        return if $self->ignore_sequence;\n\n        my $seqfactory = Bio::Seq::SeqFactory->new('Bio::Seq');\n        my $seq = $seqfactory->create(-seq=>$res, \n                                      -id=>$seqid,\n                                      -desc=>$desc);\n        $seq->accession_number($seqid);\n        if ($self->features_attached_to_seqs) {\n            my @feats = \n              @{$self->_feature_idx_by_seq_id->{$seqid}};\n            $seq->add_SeqFeature($_) foreach @feats;\n            @{$self->_feature_idx_by_seq_id->{$seqid}} = ();\n        }\n        return $seq;\n    }\n    else {\n        $self->throw(\"expected fasta header, not: $line\");\n    }\n}\n\n\n=head2 next_segment\n\n Title   : next_segment\n Usage   : my $seq = $gffio->next_segment;\n Function: Returns a Bio::LocatableSeq object corresponding to a \n           GFF \"##sequence-region\" header line.\n Example :\n Returns : A Bio::LocatableSeq object, or undef if\n           there are no more sequences.\n Args    : none\n\n\n\nsub next_segment{\n   my ($self,@args) = @_;\n   return shift @{ $self->{'segments'} } if defined $self->{'segments'};\n   return;\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : $seqfeature = $gffio->next_feature();\n Function: Returns the next feature available in the input file or stream, or\n           undef if there are no more features.\n Example :\n Returns : A Bio::SeqFeatureI implementing object, or undef if there are no\n           more features.\n Args    : none    \n\n\nsub next_feature {\n    my ($self) = @_;\n    \n    my $gff_string;\n    \n    # be graceful about empty lines or comments, and make sure we return undef\n    # if the input's consumed\n    while(($gff_string = $self->_readline()) && defined($gff_string)) {\t\n        if ($gff_string =~ /^\\#\\#\\#/) {\n            # all forward refs have been seen; TODO\n        }\n        next if($gff_string =~ /^\\#/ || $gff_string =~ /^\\s*$/ ||\n                $gff_string =~ m{^//});\n\n        while ($gff_string =~ /^\\>(.+)/) {\n            # fasta can be in header or footer\n            my $seq = $self->_parse_sequence($gff_string);\n            if ($seq) {\n                $self->_seq_by_id_h->{$seq->primary_id} = $seq;\n                $gff_string = $self->_readline;\n                last unless $gff_string;\n            }\n        }\n        last; \n    }\n    return unless $gff_string;\n\n    my $feat = Bio::SeqFeature::Generic->new();\n    $self->from_gff_string($feat, $gff_string);\n\n    if ($self->features_attached_to_seqs) {\n        push(@{$self->_feature_idx_by_seq_id->{$feat->seq_id}},\n             $feat);\n    }\n\n    return $feat;\n}\n\nsub _feature_idx_by_seq_id {\n    my $self = shift;\n    $self->{__feature_idx_by_seq_id} = shift if @_;\n    $self->{__feature_idx_by_seq_id} = {}\n      unless $self->{__feature_idx_by_seq_id};\n    return $self->{__feature_idx_by_seq_id};\n}\n\n\n=head2 from_gff_string\n\n Title   : from_gff_string\n Usage   : $gff->from_gff_string($feature, $gff_string);\n Function: Sets properties of a SeqFeatureI object from a GFF-formatted\n           string. Interpretation of the string depends on the version\n           that has been specified at initialization.\n\n           This method is used by next_feature(). It actually dispatches to\n           one of the version-specific (private) methods.\n Example :\n Returns : void\n Args    : A Bio::SeqFeatureI implementing object to be initialized\n           The GFF-formatted string to initialize it from\n\n\nsub from_gff_string {\n    my ($self, $feat, $gff_string) = @_;\n\n    if($self->gff_version() == 1)  {\n\treturn $self->_from_gff1_string($feat, $gff_string);\n    } elsif( $self->gff_version() == 3 ) {\n\treturn $self->_from_gff3_string($feat, $gff_string);\n    } else {\n\treturn $self->_from_gff2_string($feat, $gff_string);\n    }\n}\n\n=head2 _from_gff1_string\n\n Title   : _from_gff1_string\n Usage   :\n Function:\n Example :\n Returns : void\n Args    : A Bio::SeqFeatureI implementing object to be initialized\n           The GFF-formatted string to initialize it from\n\n\nsub _from_gff1_string {\n   my ($gff, $feat, $string) = @_;\n   chomp $string;\n   my ($seqname, $source, $primary, $start, $end, $score, \n       $strand, $frame, @group) = split(/\\t/, $string);\n\n   if ( !defined $frame ) {\n       $feat->throw(\"[$string] does not look like GFF to me\");\n   }\n   $frame = 0 unless( $frame =~ /^\\d+$/);\n   $feat->seq_id($seqname);\n   $feat->source_tag($source);\n   $feat->primary_tag($primary);\n   $feat->start($start);\n   $feat->end($end);\n   $feat->frame($frame);\n   if ( $score eq '.' ) {\n       #$feat->score(undef);\n   } else {\n       $feat->score($score);\n   }\n   if ( $strand eq '-' ) { $feat->strand(-1); }\n   if ( $strand eq '+' ) { $feat->strand(1); }\n   if ( $strand eq '.' ) { $feat->strand(0); }\n   foreach my $g ( @group ) {\n       if ( $g =~ /(\\S+)=(\\S+)/ ) {\n\t   my $tag = $1;\n\t   my $value = $2;\n\t   $feat->add_tag_value($1, $2);\n       } else {\n\t   $feat->add_tag_value('group', $g);\n       }\n   }\n}\n\n=head2 _from_gff2_string\n\n Title   : _from_gff2_string\n Usage   :\n Function:\n Example :\n Returns : void\n Args    : A Bio::SeqFeatureI implementing object to be initialized\n           The GFF2-formatted string to initialize it from\n\n\n\nsub _from_gff2_string {\n   my ($gff, $feat, $string) = @_;\n   chomp($string);\n\n   # according to the Sanger website, GFF2 should be single-tab\n   # separated elements, and the free-text at the end should contain\n   # text-translated tab symbols but no \"real\" tabs, so splitting on\n   # \\t is safe, and $attribs gets the entire attributes field to be\n   # parsed later\n   \n   # sendu: but the tag value pair can (should?) be separated by a tab. The\n   # 'no tabs' thing seems to apply only to the free text that is allowed for\n   # the value\n\n   my ($seqname, $source, $primary, $start, \n       $end, $score, $strand, $frame, @attribs) = split(/\\t+/, $string);\n   my $attribs = join ' ', @attribs;\n   \n   if ( !defined $frame ) {\n       $feat->throw(\"[$string] does not look like GFF2 to me\");\n   }\n   $feat->seq_id($seqname);\n   $feat->source_tag($source);\n   $feat->primary_tag($primary);\n   $feat->start($start);\n   $feat->end($end);\n   $feat->frame($frame);\n   if ( $score eq '.' ) {\n       # $feat->score(undef);\n   } else {\n       $feat->score($score);\n   }\n   if ( $strand eq '-' ) { $feat->strand(-1); }\n   if ( $strand eq '+' ) { $feat->strand(1); }\n   if ( $strand eq '.' ) { $feat->strand(0); }\n\n\n   #  <Begin Inefficient Code from Mark Wilkinson> \n   # this routine is necessay to allow the presence of semicolons in\n   # quoted text Semicolons are the delimiting character for new\n   # tag/value attributes.  it is more or less a \"state\" machine, with\n   # the \"quoted\" flag going up and down as we pass thorugh quotes to\n   # distinguish free-text semicolon and hash symbols from GFF control\n   # characters\n   \n   \n   my $flag = 0; # this could be changed to a bit and just be twiddled\n   my @parsed;\n\n   # run through each character one at a time and check it\n   # NOTE: changed to foreach loop which is more efficient in perl\n   # --jasons\n   for my $a ( split //, $attribs ) { \n       # flag up on entering quoted text, down on leaving it\n       if( $a eq '\"') { $flag = ( $flag == 0 ) ? 1:0 }\n       elsif( $a eq ';' && $flag ) { $a = \"INSERT_SEMICOLON_HERE\"}\n       elsif( $a eq '#' && ! $flag ) { last } \n       push @parsed, $a;\n   }\n   $attribs = join \"\", @parsed; # rejoin into a single string\n\n   # <End Inefficient Code>   \n   # Please feel free to fix this and make it more \"perlish\"\n\n   my @key_vals = split /;/, $attribs;   # attributes are semicolon-delimited\n\n   foreach my $pair ( @key_vals ) {\n       # replace semicolons that were removed from free-text above.\n       $pair =~ s/INSERT_SEMICOLON_HERE/;/g;        \n\n       # separate the key from the value\n       my ($blank, $key, $values) = split  /^\\s*([\\w\\d]+)\\s/, $pair; \n\n\n       if( defined $values ) {\n\t   my @values;\n\t   # free text is quoted, so match each free-text block\n\t   # and remove it from the $values string\n\t   while ($values =~ s/\"(.*?)\"//){\n\t       # and push it on to the list of values (tags may have\n\t       # more than one value... and the value may be undef)\t       \n\t       push @values, $1;\n\t   }\n\n\t   # and what is left over should be space-separated\n\t   # non-free-text values\n\n\t   my @othervals = split /\\s+/, $values;  \n\t   foreach my $othervalue(@othervals){\n\t       # get rid of any empty strings which might \n\t       # result from the split\n\t       if (CORE::length($othervalue) > 0) {push @values, $othervalue}  \n\t   }\n\n\t   foreach my $value(@values){\n\t       $feat->add_tag_value($key, $value);\n\t   }\n       }\n   }\n}\n\n\nsub _from_gff3_string {\n    my ($gff, $feat, $string) = @_;\n    chomp($string);\n\n    # according to the now nearly final GFF3 spec, columns should \n    # be tab separated, allowing unescaped spaces to occur in\n    # column 9\n\n    my ($seqname, $source, $primary, $start, $end, \n\t$score, $strand, $frame, $groups) = split(/\\t/, $string);\n    \n    if ( ! defined $frame ) {\n\t$feat->throw(\"[$string] does not look like GFF3 to me\");\n    }\n    $feat->seq_id($seqname);\n    $feat->source_tag($source);\n    $feat->primary_tag($primary);\n    $feat->start($start);\n    $feat->end($end);\n    $feat->frame($frame);\n    if ( $score eq '.' ) {\n\t#$feat->score(undef);\n    } else {\n\t$feat->score($score);\n    }\n    if ( $strand eq '-' ) { $feat->strand(-1); }\n    if ( $strand eq '+' ) { $feat->strand(1); }\n    if ( $strand eq '.' ) { $feat->strand(0); }\n    my @groups = split(/\\s*;\\s*/, $groups);\n\n    for my $group (@groups) {\n\tmy ($tag,$value) = split /=/,$group;\n\t$tag             = unescape($tag);\n\tmy @values       = map {unescape($_)} split /,/,$value;\n\tfor my $v ( @values ) {  $feat->add_tag_value($tag,$v); }\n    }\n}\n\n# taken from Bio::DB::GFF\nsub unescape {\n  my $v = shift;\n  $v =~ tr/+/ /;\n  $v =~ s/%([0-9a-fA-F]{2})/chr hex($1)/ge;\n  return $v;\n}\n\n=head2 write_feature\n\n Title   : write_feature\n Usage   : $gffio->write_feature($feature);\n Function: Writes the specified SeqFeatureI object in GFF format to the stream\n           associated with this instance.\n Returns : none\n Args    : An array of Bio::SeqFeatureI implementing objects to be serialized\n\n\nsub write_feature {\n    my ($self, @features) = @_;\n    return unless @features;\n    if( $self->{'_first'} && $self->gff_version() == 3 ) {\n\t$self->_print(\"##gff-version 3\\n\");\n    }\n    $self->{'_first'} = 0;\n    foreach my $feature ( @features ) {\n\t$self->_print($self->gff_string($feature).\"\\n\");\n    }\n}\n\n=head2 gff_string\n\n Title   : gff_string\n Usage   : $gffstr = $gffio->gff_string($feature);\n Function: Obtain the GFF-formatted representation of a SeqFeatureI object.\n           The formatting depends on the version specified at initialization.\n\n           This method is used by write_feature(). It actually dispatches to\n           one of the version-specific (private) methods.\n Example :\n Returns : A GFF-formatted string representation of the SeqFeature\n Args    : A Bio::SeqFeatureI implementing object to be GFF-stringified\n\n\nsub gff_string{\n    my ($self, $feature) = @_;\n\n    if($self->gff_version() == 1) {\n    \treturn $self->_gff1_string($feature);\n    } elsif( $self->gff_version() == 3 ) {\n    \treturn $self->_gff3_string($feature);\n    } elsif( $self->gff_version() == 2.5 ) {\n    \treturn $self->_gff25_string($feature);\n    } else {\n    \treturn $self->_gff2_string($feature);\n    }\n}\n\n=head2 _gff1_string\n\n Title   : _gff1_string\n Usage   : $gffstr = $gffio->_gff1_string\n Function: \n Example :\n Returns : A GFF1-formatted string representation of the SeqFeature\n Args    : A Bio::SeqFeatureI implementing object to be GFF-stringified\n\n\nsub _gff1_string{\n   my ($gff, $feat) = @_;\n   my ($str,$score,$frame,$name,$strand);\n\n   if( $feat->can('score') ) {\n       $score = $feat->score();\n   }\n   $score = '.' unless defined $score;\n\n   if( $feat->can('frame') ) {\n       $frame = $feat->frame();\n   }\n   $frame = '.' unless defined $frame;\n\n   $strand = $feat->strand();\n   if(! $strand) {\n       $strand = \".\";\n   } elsif( $strand == 1 ) {\n       $strand = '+';\n   } elsif ( $feat->strand == -1 ) {\n       $strand = '-';\n   }\n   \n   if( $feat->can('seqname') ) {\n       $name = $feat->seq_id();\n       $name ||= 'SEQ';\n   } else {\n       $name = 'SEQ';\n   }\n\n\n   $str = join(\"\\t\",\n                 $name,\n\t\t $feat->source_tag(),\n\t\t $feat->primary_tag(),\n\t\t $feat->start(),\n\t\t $feat->end(),\n\t\t $score,\n\t\t $strand,\n\t\t $frame);\n\n   foreach my $tag ( $feat->all_tags ) {\n       foreach my $value ( $feat->each_tag_value($tag) ) {\n\t   $str .= \" $tag=$value\" if $value;\n       }\n   }\n\n\n   return $str;\n}\n\n=head2 _gff2_string\n\n Title   : _gff2_string\n Usage   : $gffstr = $gffio->_gff2_string\n Function: \n Example :\n Returns : A GFF2-formatted string representation of the SeqFeature\n Args    : A Bio::SeqFeatureI implementing object to be GFF2-stringified\n\n\nsub _gff2_string{\n   my ($gff, $origfeat) = @_;\n    my $feat;\n   if ($origfeat->isa('Bio::SeqFeature::FeaturePair')){\n       $feat = $origfeat->feature2;\n   } else {\n       $feat = $origfeat;\n   }\n   my ($str1, $str2,$score,$frame,$name,$strand);\n\n   if( $feat->can('score') ) {\n       $score = $feat->score();\n   }\n   $score = '.' unless defined $score;\n\n   if( $feat->can('frame') ) {\n       $frame = $feat->frame();\n   }\n   $frame = '.' unless defined $frame;\n\n   $strand = $feat->strand();\n   if(! $strand) {\n       $strand = \".\";\n   } elsif( $strand == 1 ) {\n       $strand = '+';\n   } elsif ( $feat->strand == -1 ) {\n       $strand = '-';\n   }\n\n   if( $feat->can('seqname') ) {\n       $name = $feat->seq_id();\n       $name ||= 'SEQ';\n   } else {\n       $name = 'SEQ';\n   }\n   $str1 = join(\"\\t\",\n                 $name,\n\t\t $feat->source_tag(),\n\t\t $feat->primary_tag(),\n\t\t $feat->start(),\n\t\t $feat->end(),\n\t\t $score,\n\t\t $strand,\n\t\t $frame);\n   # the routine below is the only modification I made to the original\n   # ->gff_string routine (above) as on November 17th, 2000, the\n   # Sanger webpage describing GFF2 format reads: \"From version 2\n   # onwards, the attribute field must have a tag value structure\n   # following the syntax used within objects in a .ace file,\n   # flattened onto one line by semicolon separators. Tags must be\n   # standard identifiers ([A-Za-z][A-Za-z0-9_]*).  Free text values\n   # must be quoted with double quotes\".\n\n   # MW\n\n   \n   my @all_tags = $feat->all_tags;\n   my @group;\n   if (@all_tags) {  # only play this game if it is worth playing...\n       foreach my $tag ( @all_tags ) {\n\t   my @v;\n\t   foreach my $value ( $feat->each_tag_value($tag) ) {\n \t       unless( defined $value && length($value) ) {\n\t\t   $value = '\"\"';\n\t       } elsif ($value =~ /[^A-Za-z0-9_]/){\n\t\t   $value =~ s/\\t/\\\\t/g; # substitute tab and newline \n\t\t                         # characters\n\t\t   $value =~ s/\\n/\\\\n/g; # to their UNIX equivalents\n\t\t   $value = '\"' . $value . '\" ';\n\t       }                                 # if the value contains \n\t                                         # anything other than valid \n\t                                         # tag/value characters, then \n\t                                         # quote it\n\t       push @v, $value;\n\t       # for this tag (allowed in GFF2 and .ace format)\n\t   }\n\t   push @group, \"$tag \".join(\" \", @v);\n       }\n   }\n   $str2 .= join(' ; ', @group);\n   # Add Target information for Feature Pairs\n   if( ! $feat->has_tag('Target') && # This is a bad hack IMHO\n       ! $feat->has_tag('Group') &&\n       $origfeat->isa('Bio::SeqFeature::FeaturePair') ) {\n       $str2 = sprintf(\"Target %s %d %d\", $origfeat->feature1->seq_id,\n\t\t       ( $origfeat->feature1->strand < 0 ? \n\t\t\t ( $origfeat->feature1->end,\n\t\t\t   $origfeat->feature1->start) :\n\t\t\t ( $origfeat->feature1->start,\n\t\t\t   $origfeat->feature1->end) \n\t\t\t )) . ($str2?\" ; \".$str2:\"\");  # need to put Target information before other tag/value pairs - mw\n   }\n   return $str1.\"\\t\".$str2;\n}\n\n\n\n=head2 _gff25_string\n\n Title   : _gff25_string\n Usage   : $gffstr = $gffio->_gff2_string\n Function: To get a format of GFF that is peculiar to Gbrowse/Bio::DB::GFF\n Example :\n Returns : A GFF2.5-formatted string representation of the SeqFeature\n Args    : A Bio::SeqFeatureI implementing object to be GFF2.5-stringified\n\n\nsub _gff25_string {\n    my ($gff, $origfeat) = @_;\n    my $feat;\n    if ($origfeat->isa('Bio::SeqFeature::FeaturePair')){\n\t$feat = $origfeat->feature2;\n    } else {\n\t$feat = $origfeat;\n    }\n    my ($str1, $str2,$score,$frame,$name,$strand);\n\n    if( $feat->can('score') ) {\n\t$score = $feat->score();\n    }\n    $score = '.' unless defined $score;\n\n    if( $feat->can('frame') ) {\n\t$frame = $feat->frame();\n    }\n    $frame = '.' unless defined $frame;\n\n    $strand = $feat->strand();\n    if(! $strand) {\n\t$strand = \".\";\n    } elsif( $strand == 1 ) {\n\t$strand = '+';\n    } elsif ( $feat->strand == -1 ) {\n\t$strand = '-';\n    }\n\n    if( $feat->can('seqname') ) {\n\t$name = $feat->seq_id();\n\t$name ||= 'SEQ';\n    } else {\n\t$name = 'SEQ';\n    }\n    $str1 = join(\"\\t\",\n                 $name,\n\t\t $feat->source_tag(),\n\t\t $feat->primary_tag(),\n\t\t $feat->start(),\n\t\t $feat->end(),\n\t\t $score,\n\t\t $strand,\n\t\t $frame);\n\n    my @all_tags = $feat->all_tags;\n    my @group; my @firstgroup;\n    if (@all_tags) {   # only play this game if it is worth playing...\n\tforeach my $tag ( @all_tags ) {\n\t    my @v;\n\t    foreach my $value ( $feat->each_tag_value($tag) ) {\n\t\tunless( defined $value && length($value) ) {\n\t\t    $value = '\"\"';\n\t\t} elsif ($value =~ /[^A-Za-z0-9_]/){\n\t\t    $value =~ s/\\t/\\\\t/g; # substitute tab and newline \n\t\t    # characters\n\t\t    $value =~ s/\\n/\\\\n/g; # to their UNIX equivalents\n\t\t    $value = '\"' . $value . '\" ';\n\t\t}\t\t# if the value contains \n\t\t# anything other than valid \n\t\t# tag/value characters, then \n\t\t# quote it\n\t\tpush @v, $value;\n\t\t# for this tag (allowed in GFF2 and .ace format)\n\t    }\n\t    if (($tag eq 'Group') || ($tag eq 'Target')){ # hopefully we wont get both...\n\t\tpush @firstgroup, \"$tag \".join(\" \", @v);\n\t\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t    push @group, \"$tag \".join(\" \", @v);\n\t\t\t\t\t\t\t}\n\t}\n\t\t   }\n    $str2 = join(' ; ', (@firstgroup, @group));\n    # Add Target information for Feature Pairs\n    if( ! $feat->has_tag('Target') && # This is a bad hack IMHO\n\t! $feat->has_tag('Group') &&\n\t$origfeat->isa('Bio::SeqFeature::FeaturePair') ) {\n\t$str2 = sprintf(\"Target %s ; tstart %d ; tend %d\", $origfeat->feature1->seq_id,\n\t\t\t( $origfeat->feature1->strand < 0 ? \n\t\t\t  ( $origfeat->feature1->end,\n\t\t\t    $origfeat->feature1->start) :\n\t\t\t  ( $origfeat->feature1->start,\n\t\t\t    $origfeat->feature1->end) \n\t\t\t)) . ($str2?\" ; \".$str2:\"\"); # need to put the target info before other tag/value pairs - mw\n    }\n    return $str1 . \"\\t\".  $str2;\n}\n\n\n=head2 _gff3_string\n\n  Title   : _gff3_string\n  Usage   : $gffstr = $gffio->_gff3_string\n  Function: \n  Example :\n  Returns : A GFF3-formatted string representation of the SeqFeature\n  Args    : A Bio::SeqFeatureI implementing object to be GFF3-stringified","parameters":[{"label":"$gff"},{"label":"$origfeat"}]},"detail":"($gff,$origfeat)"},{"kind":12,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"gff_version","line":1144,"kind":13},{"kind":13,"line":1144,"containerName":"gff_version","name":"$value"},{"name":"$value","containerName":"gff_version","line":1145,"kind":13},{"name":"$value","containerName":"gff_version","line":1145,"kind":13},{"line":1146,"kind":13,"name":"$self","containerName":"gff_version"},{"name":"$value","containerName":"gff_version","kind":13,"line":1146},{"kind":13,"line":1148,"name":"$self","containerName":"gff_version"}],"line":1143,"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: GFF.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::GFF\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by the Bioperl core team\n#\n# Copyright Matthew Pocock\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::GFF - A Bio::SeqAnalysisParserI compliant GFF format parser\n\n=head1 SYNOPSIS\n\n    use Bio::Tools::GFF;\n\n    # specify input via -fh or -file\n    my $gffio = Bio::Tools::GFF->new(-fh => \\*STDIN, -gff_version => 2);\n    my $feature;\n    # loop over the input stream\n    while($feature = $gffio->next_feature()) {\n        # do something with feature\n    }\n    $gffio->close();\n\n    # you can also obtain a GFF parser as a SeqAnalasisParserI in\n    # HT analysis pipelines (see Bio::SeqAnalysisParserI and\n    # Bio::Factory::SeqAnalysisParserFactory)\n    my $factory = Bio::Factory::SeqAnalysisParserFactory->new();\n    my $parser = $factory->get_parser(-input => \\*STDIN, -method => \"gff\");\n    while($feature = $parser->next_feature()) {\n        # do something with feature\n    }\n\n=head1 DESCRIPTION\n\nThis class provides a simple GFF parser and writer. In the sense of a\nSeqAnalysisParser, it parses an input file or stream into SeqFeatureI\nobjects, but is not in any way specific to a particular analysis\nprogram and the output that program produces.\n\nThat is, if you can get your analysis program spit out GFF, here is\nyour result parser.\n\n=head1 GFF3 AND SEQUENCE DATA\n\nGFF3 supports sequence data; see\n\nhttp://www.sequenceontology.org/gff3.shtml\n\nThere are a number of ways to deal with this -\n\nIf you call\n\n  $gffio->ignore_sequence(1)\n\nprior to parsing the sequence data is ignored; this is useful if you\njust want the features. It avoids the memory overhead in building and\ncaching sequences\n\nAlternatively, you can call either\n\n  $gffio->get_seqs()\n\nOr\n\n  $gffio->seq_id_by_h()\n\nAt the B<end> of parsing to get either a list or hashref of Bio::Seq\nobjects (see the documentation for each of these methods)\n\nNote that these objects will not have the features attached - you have\nto do this yourself, OR call\n\n  $gffio->features_attached_to_seqs(1)\n\nPRIOR to parsing; this will ensure that the Seqs have the features\nattached; ie you will then be able to call\n\n  $seq->get_SeqFeatures();\n\nAnd use Bio::SeqIO methods\n\nNote that auto-attaching the features to seqs will incur a higher\nmemory overhead as the features must be cached until the sequence data\nis found\n\n=head1 TODO\n\nMake a Bio::SeqIO class specifically for GFF3 with sequence data\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Matthew Pocock\n\nEmail mrp-at-sanger.ac.uk\n\n=head1 CONTRIBUTORS \n\nJason Stajich, jason-at-biperl-dot-org\nChris Mungall, cjm-at-fruitfly-dot-org\nSteffen Grossmann [SG], grossman at molgen.mpg.de\nMalcolm Cook, mec-at-stowers-institute.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tools::GFF;\n\nuse vars qw($HAS_HTML_ENTITIES);\nuse strict;\n\nuse Bio::Seq::SeqFactory;\nuse Bio::LocatableSeq;\nuse Bio::SeqFeature::Generic;\n\nuse base qw(Bio::Root::Root Bio::SeqAnalysisParserI Bio::Root::IO);\n\nmy $i = 0;\nmy %GFF3_ID_Tags = map { $_ => $i++ } qw(ID Parent Target);\n\n=head2 new\n\n Title   : new\n Usage   : my $parser = Bio::Tools::GFF->new(-gff_version => 2,\n\t\t\t\t\t    -file        => \"filename.gff\");\n           or\n           my $writer = Bio::Tools::GFF->new(-gff_version => 3,\n\t\t\t\t\t    -file        => \">filename.gff3\");\n Function: Creates a new instance. Recognized named parameters are -file, -fh,\n           and -gff_version.\n Returns : a new object\n Args    : named parameters\n           -gff_version => [1,2,3]\n\n\n\n{   # make a class variable such that we can generate unique ID's over\n    # a session, no matter how many instances of GFF.pm we make\n    # since these have to be unique within the scope of a GFF file.\n    \n    my $gff3_featureID = 0;\n    \n    sub _incrementGFF3ID {\n        my ($self) = @_;\n        return ++ $gff3_featureID;\n    }\n}\n\n\nsub new {\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n  \n  my ($gff_version, $noparse) = $self->_rearrange([qw(GFF_VERSION NOPARSE)],@args);\n\n  # initialize IO\n  $self->_initialize_io(@args);\n  $self->_parse_header() unless $noparse;\n\n  $gff_version ||= 2;\n  if( ! $self->gff_version($gff_version) )  {\n      $self->throw(\"Can't build a GFF object with the unknown version \".\n\t\t   $gff_version);\n  }\n  $self->{'_first'} = 1;\n  return $self;\n}\n\n=head2 _parse_header\n\n Title   : _parse_header\n Usage   : $gffio->_parse_header()\n Function: used to turn parse GFF header lines.  currently\n           produces Bio::LocatableSeq objects from ##sequence-region\n           lines\n Returns : 1 on success\n Args    : none\n\n\n\nsub _parse_header{\n   my ($self) = @_;\n\n   my @unhandled;\n   local $^W = 0; # hide warnings when we try and parse from a file opened\n                  # for writing - there isn't really a better way to do\n                  # AFAIK - cannot detech if a FH is read or write.\n   while(my $line = $self->_readline()){\n \t my $handled = 0;\n\t next if /^\\s+$/;\n\t if($line =~ /^\\#\\#sequence-region\\s+(\\S+)\\s+(\\S+)\\s+(\\S+)\\s*/){\n\t   my($seqid,$start,$end) = ($1,$2,$3);\n\t   push @{ $self->{'segments'} }, Bio::LocatableSeq->new\n\t       (\n\t\t-id    => unescape($seqid),\n\t\t-start => $start,\n\t\t-end   => $end,\n                -length => ($end - $start + 1),  ## make the length explicit\n\t\t);\n\t   $handled = 1;\n\t } elsif($line =~ /^(\\#\\#feature-ontology)/) {\n\t   #to be implemented\n\t   $self->warn(\"$1 header tag parsing unimplemented\");\n\t } elsif($line =~ /^(\\#\\#attribute-ontology)/) {\n\t   #to be implemented\n\t   $self->warn(\"$1 header tag parsing unimplemented\");\n\t } elsif($line =~ /^(\\#\\#source-ontology)/) {\n\t   #to be implemented\n\t   $self->warn(\"$1 header tag parsing unimplemented\");\n\t } elsif($line =~ /^(\\#\\#\\#)/) {\n\t   #to be implemented\n\t   $self->warn(\"$1 header tag parsing unimplemented\");\n\t } elsif($line =~ /^(\\#\\#FASTA)/) {\n            # initial ##FASTA is optional - artemis does not use it\n            $line = $self->_readline();\n            if ($line !~ /^\\>(\\S+)/) {\n                $self->throw(\"##FASTA directive must be followed by fasta header, not: $line\");\n            }\n\t } else {\n         }\n         \n         if ($line =~ /^\\>(.*)/) {\n             # seq data can be at header or footer\n             my $seq = $self->_parse_sequence($line);\n             if ($seq) {\n                 $self->_seq_by_id_h->{$seq->primary_id} = $seq;\n             }\n         }\n             \n\n \t if(!$handled){\n\t   push @unhandled, $line\n \t }\n\n\t #looks like the header is over!\n\t last unless $line =~ /^\\#/;\n   }\n\n   foreach my $line (@unhandled){\n\t $self->_pushback($line);\n   }\n\n   return 1;\n}\n\nsub _parse_sequence {\n    my ($self, $line) = @_;\n\n    if ($line =~ /^\\>(.*)/) {\n        \n        my $seqid = $1;\n        $seqid =~ s/\\s+$//;\n        my $desc = '';\n        if ($seqid =~ /(\\S+)\\s+(.*)/) {\n            ($seqid, $desc) = ($1,$2);\n        }\n        my $res = '';\n        while (my $line = $self->_readline) {\n            if ($line =~ /^\\#/) {\n                last;\n            }\n            if ($line =~ /^\\>/) {\n                $self->_pushback($line);\n                last;\n            }\n            $line =~ s/\\s//g;\n            $res .= $line;\n        }\n        return if $self->ignore_sequence;\n\n        my $seqfactory = Bio::Seq::SeqFactory->new('Bio::Seq');\n        my $seq = $seqfactory->create(-seq=>$res, \n                                      -id=>$seqid,\n                                      -desc=>$desc);\n        $seq->accession_number($seqid);\n        if ($self->features_attached_to_seqs) {\n            my @feats = \n              @{$self->_feature_idx_by_seq_id->{$seqid}};\n            $seq->add_SeqFeature($_) foreach @feats;\n            @{$self->_feature_idx_by_seq_id->{$seqid}} = ();\n        }\n        return $seq;\n    }\n    else {\n        $self->throw(\"expected fasta header, not: $line\");\n    }\n}\n\n\n=head2 next_segment\n\n Title   : next_segment\n Usage   : my $seq = $gffio->next_segment;\n Function: Returns a Bio::LocatableSeq object corresponding to a \n           GFF \"##sequence-region\" header line.\n Example :\n Returns : A Bio::LocatableSeq object, or undef if\n           there are no more sequences.\n Args    : none\n\n\n\nsub next_segment{\n   my ($self,@args) = @_;\n   return shift @{ $self->{'segments'} } if defined $self->{'segments'};\n   return;\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : $seqfeature = $gffio->next_feature();\n Function: Returns the next feature available in the input file or stream, or\n           undef if there are no more features.\n Example :\n Returns : A Bio::SeqFeatureI implementing object, or undef if there are no\n           more features.\n Args    : none    \n\n\nsub next_feature {\n    my ($self) = @_;\n    \n    my $gff_string;\n    \n    # be graceful about empty lines or comments, and make sure we return undef\n    # if the input's consumed\n    while(($gff_string = $self->_readline()) && defined($gff_string)) {\t\n        if ($gff_string =~ /^\\#\\#\\#/) {\n            # all forward refs have been seen; TODO\n        }\n        next if($gff_string =~ /^\\#/ || $gff_string =~ /^\\s*$/ ||\n                $gff_string =~ m{^//});\n\n        while ($gff_string =~ /^\\>(.+)/) {\n            # fasta can be in header or footer\n            my $seq = $self->_parse_sequence($gff_string);\n            if ($seq) {\n                $self->_seq_by_id_h->{$seq->primary_id} = $seq;\n                $gff_string = $self->_readline;\n                last unless $gff_string;\n            }\n        }\n        last; \n    }\n    return unless $gff_string;\n\n    my $feat = Bio::SeqFeature::Generic->new();\n    $self->from_gff_string($feat, $gff_string);\n\n    if ($self->features_attached_to_seqs) {\n        push(@{$self->_feature_idx_by_seq_id->{$feat->seq_id}},\n             $feat);\n    }\n\n    return $feat;\n}\n\nsub _feature_idx_by_seq_id {\n    my $self = shift;\n    $self->{__feature_idx_by_seq_id} = shift if @_;\n    $self->{__feature_idx_by_seq_id} = {}\n      unless $self->{__feature_idx_by_seq_id};\n    return $self->{__feature_idx_by_seq_id};\n}\n\n\n=head2 from_gff_string\n\n Title   : from_gff_string\n Usage   : $gff->from_gff_string($feature, $gff_string);\n Function: Sets properties of a SeqFeatureI object from a GFF-formatted\n           string. Interpretation of the string depends on the version\n           that has been specified at initialization.\n\n           This method is used by next_feature(). It actually dispatches to\n           one of the version-specific (private) methods.\n Example :\n Returns : void\n Args    : A Bio::SeqFeatureI implementing object to be initialized\n           The GFF-formatted string to initialize it from\n\n\nsub from_gff_string {\n    my ($self, $feat, $gff_string) = @_;\n\n    if($self->gff_version() == 1)  {\n\treturn $self->_from_gff1_string($feat, $gff_string);\n    } elsif( $self->gff_version() == 3 ) {\n\treturn $self->_from_gff3_string($feat, $gff_string);\n    } else {\n\treturn $self->_from_gff2_string($feat, $gff_string);\n    }\n}\n\n=head2 _from_gff1_string\n\n Title   : _from_gff1_string\n Usage   :\n Function:\n Example :\n Returns : void\n Args    : A Bio::SeqFeatureI implementing object to be initialized\n           The GFF-formatted string to initialize it from\n\n\nsub _from_gff1_string {\n   my ($gff, $feat, $string) = @_;\n   chomp $string;\n   my ($seqname, $source, $primary, $start, $end, $score, \n       $strand, $frame, @group) = split(/\\t/, $string);\n\n   if ( !defined $frame ) {\n       $feat->throw(\"[$string] does not look like GFF to me\");\n   }\n   $frame = 0 unless( $frame =~ /^\\d+$/);\n   $feat->seq_id($seqname);\n   $feat->source_tag($source);\n   $feat->primary_tag($primary);\n   $feat->start($start);\n   $feat->end($end);\n   $feat->frame($frame);\n   if ( $score eq '.' ) {\n       #$feat->score(undef);\n   } else {\n       $feat->score($score);\n   }\n   if ( $strand eq '-' ) { $feat->strand(-1); }\n   if ( $strand eq '+' ) { $feat->strand(1); }\n   if ( $strand eq '.' ) { $feat->strand(0); }\n   foreach my $g ( @group ) {\n       if ( $g =~ /(\\S+)=(\\S+)/ ) {\n\t   my $tag = $1;\n\t   my $value = $2;\n\t   $feat->add_tag_value($1, $2);\n       } else {\n\t   $feat->add_tag_value('group', $g);\n       }\n   }\n}\n\n=head2 _from_gff2_string\n\n Title   : _from_gff2_string\n Usage   :\n Function:\n Example :\n Returns : void\n Args    : A Bio::SeqFeatureI implementing object to be initialized\n           The GFF2-formatted string to initialize it from\n\n\n\nsub _from_gff2_string {\n   my ($gff, $feat, $string) = @_;\n   chomp($string);\n\n   # according to the Sanger website, GFF2 should be single-tab\n   # separated elements, and the free-text at the end should contain\n   # text-translated tab symbols but no \"real\" tabs, so splitting on\n   # \\t is safe, and $attribs gets the entire attributes field to be\n   # parsed later\n   \n   # sendu: but the tag value pair can (should?) be separated by a tab. The\n   # 'no tabs' thing seems to apply only to the free text that is allowed for\n   # the value\n\n   my ($seqname, $source, $primary, $start, \n       $end, $score, $strand, $frame, @attribs) = split(/\\t+/, $string);\n   my $attribs = join ' ', @attribs;\n   \n   if ( !defined $frame ) {\n       $feat->throw(\"[$string] does not look like GFF2 to me\");\n   }\n   $feat->seq_id($seqname);\n   $feat->source_tag($source);\n   $feat->primary_tag($primary);\n   $feat->start($start);\n   $feat->end($end);\n   $feat->frame($frame);\n   if ( $score eq '.' ) {\n       # $feat->score(undef);\n   } else {\n       $feat->score($score);\n   }\n   if ( $strand eq '-' ) { $feat->strand(-1); }\n   if ( $strand eq '+' ) { $feat->strand(1); }\n   if ( $strand eq '.' ) { $feat->strand(0); }\n\n\n   #  <Begin Inefficient Code from Mark Wilkinson> \n   # this routine is necessay to allow the presence of semicolons in\n   # quoted text Semicolons are the delimiting character for new\n   # tag/value attributes.  it is more or less a \"state\" machine, with\n   # the \"quoted\" flag going up and down as we pass thorugh quotes to\n   # distinguish free-text semicolon and hash symbols from GFF control\n   # characters\n   \n   \n   my $flag = 0; # this could be changed to a bit and just be twiddled\n   my @parsed;\n\n   # run through each character one at a time and check it\n   # NOTE: changed to foreach loop which is more efficient in perl\n   # --jasons\n   for my $a ( split //, $attribs ) { \n       # flag up on entering quoted text, down on leaving it\n       if( $a eq '\"') { $flag = ( $flag == 0 ) ? 1:0 }\n       elsif( $a eq ';' && $flag ) { $a = \"INSERT_SEMICOLON_HERE\"}\n       elsif( $a eq '#' && ! $flag ) { last } \n       push @parsed, $a;\n   }\n   $attribs = join \"\", @parsed; # rejoin into a single string\n\n   # <End Inefficient Code>   \n   # Please feel free to fix this and make it more \"perlish\"\n\n   my @key_vals = split /;/, $attribs;   # attributes are semicolon-delimited\n\n   foreach my $pair ( @key_vals ) {\n       # replace semicolons that were removed from free-text above.\n       $pair =~ s/INSERT_SEMICOLON_HERE/;/g;        \n\n       # separate the key from the value\n       my ($blank, $key, $values) = split  /^\\s*([\\w\\d]+)\\s/, $pair; \n\n\n       if( defined $values ) {\n\t   my @values;\n\t   # free text is quoted, so match each free-text block\n\t   # and remove it from the $values string\n\t   while ($values =~ s/\"(.*?)\"//){\n\t       # and push it on to the list of values (tags may have\n\t       # more than one value... and the value may be undef)\t       \n\t       push @values, $1;\n\t   }\n\n\t   # and what is left over should be space-separated\n\t   # non-free-text values\n\n\t   my @othervals = split /\\s+/, $values;  \n\t   foreach my $othervalue(@othervals){\n\t       # get rid of any empty strings which might \n\t       # result from the split\n\t       if (CORE::length($othervalue) > 0) {push @values, $othervalue}  \n\t   }\n\n\t   foreach my $value(@values){\n\t       $feat->add_tag_value($key, $value);\n\t   }\n       }\n   }\n}\n\n\nsub _from_gff3_string {\n    my ($gff, $feat, $string) = @_;\n    chomp($string);\n\n    # according to the now nearly final GFF3 spec, columns should \n    # be tab separated, allowing unescaped spaces to occur in\n    # column 9\n\n    my ($seqname, $source, $primary, $start, $end, \n\t$score, $strand, $frame, $groups) = split(/\\t/, $string);\n    \n    if ( ! defined $frame ) {\n\t$feat->throw(\"[$string] does not look like GFF3 to me\");\n    }\n    $feat->seq_id($seqname);\n    $feat->source_tag($source);\n    $feat->primary_tag($primary);\n    $feat->start($start);\n    $feat->end($end);\n    $feat->frame($frame);\n    if ( $score eq '.' ) {\n\t#$feat->score(undef);\n    } else {\n\t$feat->score($score);\n    }\n    if ( $strand eq '-' ) { $feat->strand(-1); }\n    if ( $strand eq '+' ) { $feat->strand(1); }\n    if ( $strand eq '.' ) { $feat->strand(0); }\n    my @groups = split(/\\s*;\\s*/, $groups);\n\n    for my $group (@groups) {\n\tmy ($tag,$value) = split /=/,$group;\n\t$tag             = unescape($tag);\n\tmy @values       = map {unescape($_)} split /,/,$value;\n\tfor my $v ( @values ) {  $feat->add_tag_value($tag,$v); }\n    }\n}\n\n# taken from Bio::DB::GFF\nsub unescape {\n  my $v = shift;\n  $v =~ tr/+/ /;\n  $v =~ s/%([0-9a-fA-F]{2})/chr hex($1)/ge;\n  return $v;\n}\n\n=head2 write_feature\n\n Title   : write_feature\n Usage   : $gffio->write_feature($feature);\n Function: Writes the specified SeqFeatureI object in GFF format to the stream\n           associated with this instance.\n Returns : none\n Args    : An array of Bio::SeqFeatureI implementing objects to be serialized\n\n\nsub write_feature {\n    my ($self, @features) = @_;\n    return unless @features;\n    if( $self->{'_first'} && $self->gff_version() == 3 ) {\n\t$self->_print(\"##gff-version 3\\n\");\n    }\n    $self->{'_first'} = 0;\n    foreach my $feature ( @features ) {\n\t$self->_print($self->gff_string($feature).\"\\n\");\n    }\n}\n\n=head2 gff_string\n\n Title   : gff_string\n Usage   : $gffstr = $gffio->gff_string($feature);\n Function: Obtain the GFF-formatted representation of a SeqFeatureI object.\n           The formatting depends on the version specified at initialization.\n\n           This method is used by write_feature(). It actually dispatches to\n           one of the version-specific (private) methods.\n Example :\n Returns : A GFF-formatted string representation of the SeqFeature\n Args    : A Bio::SeqFeatureI implementing object to be GFF-stringified\n\n\nsub gff_string{\n    my ($self, $feature) = @_;\n\n    if($self->gff_version() == 1) {\n    \treturn $self->_gff1_string($feature);\n    } elsif( $self->gff_version() == 3 ) {\n    \treturn $self->_gff3_string($feature);\n    } elsif( $self->gff_version() == 2.5 ) {\n    \treturn $self->_gff25_string($feature);\n    } else {\n    \treturn $self->_gff2_string($feature);\n    }\n}\n\n=head2 _gff1_string\n\n Title   : _gff1_string\n Usage   : $gffstr = $gffio->_gff1_string\n Function: \n Example :\n Returns : A GFF1-formatted string representation of the SeqFeature\n Args    : A Bio::SeqFeatureI implementing object to be GFF-stringified\n\n\nsub _gff1_string{\n   my ($gff, $feat) = @_;\n   my ($str,$score,$frame,$name,$strand);\n\n   if( $feat->can('score') ) {\n       $score = $feat->score();\n   }\n   $score = '.' unless defined $score;\n\n   if( $feat->can('frame') ) {\n       $frame = $feat->frame();\n   }\n   $frame = '.' unless defined $frame;\n\n   $strand = $feat->strand();\n   if(! $strand) {\n       $strand = \".\";\n   } elsif( $strand == 1 ) {\n       $strand = '+';\n   } elsif ( $feat->strand == -1 ) {\n       $strand = '-';\n   }\n   \n   if( $feat->can('seqname') ) {\n       $name = $feat->seq_id();\n       $name ||= 'SEQ';\n   } else {\n       $name = 'SEQ';\n   }\n\n\n   $str = join(\"\\t\",\n                 $name,\n\t\t $feat->source_tag(),\n\t\t $feat->primary_tag(),\n\t\t $feat->start(),\n\t\t $feat->end(),\n\t\t $score,\n\t\t $strand,\n\t\t $frame);\n\n   foreach my $tag ( $feat->all_tags ) {\n       foreach my $value ( $feat->each_tag_value($tag) ) {\n\t   $str .= \" $tag=$value\" if $value;\n       }\n   }\n\n\n   return $str;\n}\n\n=head2 _gff2_string\n\n Title   : _gff2_string\n Usage   : $gffstr = $gffio->_gff2_string\n Function: \n Example :\n Returns : A GFF2-formatted string representation of the SeqFeature\n Args    : A Bio::SeqFeatureI implementing object to be GFF2-stringified\n\n\nsub _gff2_string{\n   my ($gff, $origfeat) = @_;\n    my $feat;\n   if ($origfeat->isa('Bio::SeqFeature::FeaturePair')){\n       $feat = $origfeat->feature2;\n   } else {\n       $feat = $origfeat;\n   }\n   my ($str1, $str2,$score,$frame,$name,$strand);\n\n   if( $feat->can('score') ) {\n       $score = $feat->score();\n   }\n   $score = '.' unless defined $score;\n\n   if( $feat->can('frame') ) {\n       $frame = $feat->frame();\n   }\n   $frame = '.' unless defined $frame;\n\n   $strand = $feat->strand();\n   if(! $strand) {\n       $strand = \".\";\n   } elsif( $strand == 1 ) {\n       $strand = '+';\n   } elsif ( $feat->strand == -1 ) {\n       $strand = '-';\n   }\n\n   if( $feat->can('seqname') ) {\n       $name = $feat->seq_id();\n       $name ||= 'SEQ';\n   } else {\n       $name = 'SEQ';\n   }\n   $str1 = join(\"\\t\",\n                 $name,\n\t\t $feat->source_tag(),\n\t\t $feat->primary_tag(),\n\t\t $feat->start(),\n\t\t $feat->end(),\n\t\t $score,\n\t\t $strand,\n\t\t $frame);\n   # the routine below is the only modification I made to the original\n   # ->gff_string routine (above) as on November 17th, 2000, the\n   # Sanger webpage describing GFF2 format reads: \"From version 2\n   # onwards, the attribute field must have a tag value structure\n   # following the syntax used within objects in a .ace file,\n   # flattened onto one line by semicolon separators. Tags must be\n   # standard identifiers ([A-Za-z][A-Za-z0-9_]*).  Free text values\n   # must be quoted with double quotes\".\n\n   # MW\n\n   \n   my @all_tags = $feat->all_tags;\n   my @group;\n   if (@all_tags) {  # only play this game if it is worth playing...\n       foreach my $tag ( @all_tags ) {\n\t   my @v;\n\t   foreach my $value ( $feat->each_tag_value($tag) ) {\n \t       unless( defined $value && length($value) ) {\n\t\t   $value = '\"\"';\n\t       } elsif ($value =~ /[^A-Za-z0-9_]/){\n\t\t   $value =~ s/\\t/\\\\t/g; # substitute tab and newline \n\t\t                         # characters\n\t\t   $value =~ s/\\n/\\\\n/g; # to their UNIX equivalents\n\t\t   $value = '\"' . $value . '\" ';\n\t       }                                 # if the value contains \n\t                                         # anything other than valid \n\t                                         # tag/value characters, then \n\t                                         # quote it\n\t       push @v, $value;\n\t       # for this tag (allowed in GFF2 and .ace format)\n\t   }\n\t   push @group, \"$tag \".join(\" \", @v);\n       }\n   }\n   $str2 .= join(' ; ', @group);\n   # Add Target information for Feature Pairs\n   if( ! $feat->has_tag('Target') && # This is a bad hack IMHO\n       ! $feat->has_tag('Group') &&\n       $origfeat->isa('Bio::SeqFeature::FeaturePair') ) {\n       $str2 = sprintf(\"Target %s %d %d\", $origfeat->feature1->seq_id,\n\t\t       ( $origfeat->feature1->strand < 0 ? \n\t\t\t ( $origfeat->feature1->end,\n\t\t\t   $origfeat->feature1->start) :\n\t\t\t ( $origfeat->feature1->start,\n\t\t\t   $origfeat->feature1->end) \n\t\t\t )) . ($str2?\" ; \".$str2:\"\");  # need to put Target information before other tag/value pairs - mw\n   }\n   return $str1.\"\\t\".$str2;\n}\n\n\n\n=head2 _gff25_string\n\n Title   : _gff25_string\n Usage   : $gffstr = $gffio->_gff2_string\n Function: To get a format of GFF that is peculiar to Gbrowse/Bio::DB::GFF\n Example :\n Returns : A GFF2.5-formatted string representation of the SeqFeature\n Args    : A Bio::SeqFeatureI implementing object to be GFF2.5-stringified\n\n\nsub _gff25_string {\n    my ($gff, $origfeat) = @_;\n    my $feat;\n    if ($origfeat->isa('Bio::SeqFeature::FeaturePair')){\n\t$feat = $origfeat->feature2;\n    } else {\n\t$feat = $origfeat;\n    }\n    my ($str1, $str2,$score,$frame,$name,$strand);\n\n    if( $feat->can('score') ) {\n\t$score = $feat->score();\n    }\n    $score = '.' unless defined $score;\n\n    if( $feat->can('frame') ) {\n\t$frame = $feat->frame();\n    }\n    $frame = '.' unless defined $frame;\n\n    $strand = $feat->strand();\n    if(! $strand) {\n\t$strand = \".\";\n    } elsif( $strand == 1 ) {\n\t$strand = '+';\n    } elsif ( $feat->strand == -1 ) {\n\t$strand = '-';\n    }\n\n    if( $feat->can('seqname') ) {\n\t$name = $feat->seq_id();\n\t$name ||= 'SEQ';\n    } else {\n\t$name = 'SEQ';\n    }\n    $str1 = join(\"\\t\",\n                 $name,\n\t\t $feat->source_tag(),\n\t\t $feat->primary_tag(),\n\t\t $feat->start(),\n\t\t $feat->end(),\n\t\t $score,\n\t\t $strand,\n\t\t $frame);\n\n    my @all_tags = $feat->all_tags;\n    my @group; my @firstgroup;\n    if (@all_tags) {   # only play this game if it is worth playing...\n\tforeach my $tag ( @all_tags ) {\n\t    my @v;\n\t    foreach my $value ( $feat->each_tag_value($tag) ) {\n\t\tunless( defined $value && length($value) ) {\n\t\t    $value = '\"\"';\n\t\t} elsif ($value =~ /[^A-Za-z0-9_]/){\n\t\t    $value =~ s/\\t/\\\\t/g; # substitute tab and newline \n\t\t    # characters\n\t\t    $value =~ s/\\n/\\\\n/g; # to their UNIX equivalents\n\t\t    $value = '\"' . $value . '\" ';\n\t\t}\t\t# if the value contains \n\t\t# anything other than valid \n\t\t# tag/value characters, then \n\t\t# quote it\n\t\tpush @v, $value;\n\t\t# for this tag (allowed in GFF2 and .ace format)\n\t    }\n\t    if (($tag eq 'Group') || ($tag eq 'Target')){ # hopefully we wont get both...\n\t\tpush @firstgroup, \"$tag \".join(\" \", @v);\n\t\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t    push @group, \"$tag \".join(\" \", @v);\n\t\t\t\t\t\t\t}\n\t}\n\t\t   }\n    $str2 = join(' ; ', (@firstgroup, @group));\n    # Add Target information for Feature Pairs\n    if( ! $feat->has_tag('Target') && # This is a bad hack IMHO\n\t! $feat->has_tag('Group') &&\n\t$origfeat->isa('Bio::SeqFeature::FeaturePair') ) {\n\t$str2 = sprintf(\"Target %s ; tstart %d ; tend %d\", $origfeat->feature1->seq_id,\n\t\t\t( $origfeat->feature1->strand < 0 ? \n\t\t\t  ( $origfeat->feature1->end,\n\t\t\t    $origfeat->feature1->start) :\n\t\t\t  ( $origfeat->feature1->start,\n\t\t\t    $origfeat->feature1->end) \n\t\t\t)) . ($str2?\" ; \".$str2:\"\"); # need to put the target info before other tag/value pairs - mw\n    }\n    return $str1 . \"\\t\".  $str2;\n}\n\n\n=head2 _gff3_string\n\n  Title   : _gff3_string\n  Usage   : $gffstr = $gffio->_gff3_string\n  Function: \n  Example :\n  Returns : A GFF3-formatted string representation of the SeqFeature\n  Args    : A Bio::SeqFeatureI implementing object to be GFF3-stringified\n\n\nsub _gff3_string {\n    my ($gff, $origfeat) = @_;\n    my $feat;\n    if ($origfeat->isa('Bio::SeqFeature::FeaturePair')){\n\t$feat = $origfeat->feature2;\n    } else {\n\t$feat = $origfeat;\n    }\n\n    my $ID = $gff->_incrementGFF3ID();\n\n    my ($score,$frame,$name,$strand);\n\n    if( $feat->can('score') ) {\n\t$score = $feat->score();\n    }\n    $score = '.' unless defined $score;\n\n    if( $feat->can('frame') ) {\n\t$frame = $feat->frame();\n    }\n    $frame = '.' unless defined $frame;\n\n    $strand = $feat->strand();\n\n    if(! $strand) {\n\t$strand = \".\";\n    } elsif( $strand == 1 ) {\n\t$strand = '+';\n    } elsif ( $feat->strand == -1 ) {\n\t$strand = '-';\n    }\n\n    if( $feat->can('seqname') ) {\n\t$name = $feat->seq_id();\n\t$name ||= 'SEQ';\n    } else {\n\t$name = 'SEQ';\n    }\n\n    my @groups;\n\n    # force leading ID and Parent tags\n    my @all_tags =  grep { ! exists $GFF3_ID_Tags{$_} } $feat->all_tags;\n    for my $t ( sort { $GFF3_ID_Tags{$b} <=> $GFF3_ID_Tags{$a} }\n\t\tkeys %GFF3_ID_Tags ) {\n\tunshift @all_tags, $t if $feat->has_tag($t);\n    }\n\n    for my $tag ( @all_tags ) {\n\t# next if $tag eq 'Target';\n\tif ($tag eq 'Target' && ! $origfeat->isa('Bio::SeqFeature::FeaturePair')){  \n\t    # simple Target,start,stop\n\t    my($target_id, $b,$e,$strand) = $feat->get_tag_values($tag); \n\t    next unless(defined($e) && defined($b) && $target_id);\t\t\t\n\t    ($b,$e)= ($e,$b) if(defined $strand && $strand<0);\n\t    $target_id =~ s/([\\t\\n\\r%&\\=;,])/sprintf(\"%%%X\",ord($1))/ge;    \n\t    push @groups, sprintf(\"Target=%s %d %d\", $target_id,$b,$e);\n\t    next;\n\t}\n\n\tmy $valuestr;\t\n\t# a string which will hold one or more values \n\t# for this tag, with quoted free text and \n\t# space-separated individual values.\n\tmy @v;\n\tfor my $value ( $feat->each_tag_value($tag) ) {\t    \n\t    if(  defined $value && length($value) ) { \n\t\t\t\t#$value =~ tr/ /+/;  #spaces are allowed now\n                if ( ref $value eq 'Bio::Annotation::Comment') {\n                    $value = $value->text;\n                }\n\n\t\tif ($value =~ /[^a-zA-Z0-9\\,\\;\\=\\.:\\%\\^\\*\\$\\@\\!\\+\\_\\?\\-]/) {\n\t\t    $value =~ s/\\t/\\\\t/g; # substitute tab and newline \n\t\t    # characters\n\t\t    $value =~ s/\\n/\\\\n/g; # to their UNIX equivalents\n\n\t\t    # Unescaped quotes are not allowed in GFF3\n\t\t    #\t\t    $value = '\"' . $value . '\"';\n\t\t}\n\t\t$value =~ s/([\\t\\n\\r%&\\=;,])/sprintf(\"%%%X\",ord($1))/ge;\n\t    } else {\n\t\t\t\t# if it is completely empty, \n\t\t\t\t# then just make empty double \n\t\t\t\t# quotes\n\t\t$value = '\"\"';\n\t    }\n\t    push @v, $value;\n\t}\n\t# can we figure out how to improve this?\n\t$tag= lcfirst($tag) unless ($tag \n\t\t\t\t    =~ /^(ID|Name|Alias|Parent|Gap|Target|Derives_from|Note|Dbxref|Ontology_term)$/);\n\n\tpush @groups, \"$tag=\".join(\",\",@v);\n    }\n    # Add Target information for Feature Pairs\n    if( $feat->has_tag('Target') && \n\t! $feat->has_tag('Group') &&\n\t$origfeat->isa('Bio::SeqFeature::FeaturePair') ) {\n\n\tmy $target_id = $origfeat->feature1->seq_id;\n\t$target_id =~ s/([\\t\\n\\r%&\\=;,])/sprintf(\"%%%X\",ord($1))/ge;    \n\n\tpush @groups, sprintf(\"Target=%s %d %d\", \n\t\t\t      $target_id,\n\t\t\t      ( $origfeat->feature1->strand < 0 ? \n\t\t\t\t( $origfeat->feature1->end,\n\t\t\t\t  $origfeat->feature1->start) :\n\t\t\t\t( $origfeat->feature1->start,\n\t\t\t\t  $origfeat->feature1->end) \n\t\t\t\t));\n    }\n\n    # unshift @groups, \"ID=autogenerated$ID\" unless ($feat->has_tag('ID'));\n    if ( $feat->can('name') && defined($feat->name) ) {\n\t# such as might be for Bio::DB::SeqFeature\n\tunshift @groups, 'Name=' . $feat->name;\n    }\n\n    my $gff_string = \"\";\n    if ($feat->location->isa(\"Bio::Location::SplitLocationI\")) {\n\tmy @locs = $feat->location->each_Location;\n\tforeach my $loc (@locs) {\n\t    $gff_string .= join(\"\\t\",\n\t\t\t\t$name,\n\t\t\t\t$feat->source_tag() || '.',\n\t\t\t\t$feat->primary_tag(),\n\t\t\t\t$loc->start(),\n\t\t\t\t$loc->end(),\n\t\t\t\t$score,\n\t\t\t\t$strand,\n\t\t\t\t$frame,\n\t\t\t\tjoin(';', @groups)) . \"\\n\";\n\t}\n\tchop $gff_string;\n\treturn $gff_string;\n    } else {\n\t$gff_string = join(\"\\t\",\n\t\t\t   $name,\n\t\t\t   $feat->source_tag() || '.',\n\t\t\t   $feat->primary_tag(),\n\t\t\t   $feat->start(),\n\t\t\t   $feat->end(),\n\t\t\t   $score,\n\t\t\t   $strand,\n\t\t\t   $frame, \n\t\t\t   join(';', @groups));\n    }\n    return $gff_string;\n}\n\n=head2 gff_version\n\n  Title   : _gff_version\n  Usage   : $gffversion = $gffio->gff_version\n  Function: \n  Example :\n  Returns : The GFF version this parser will accept and emit.\n  Args    : none","label":"gff_version($self,$value)"},"detail":"($self,$value)","name":"gff_version","range":{"start":{"line":1143,"character":0},"end":{"line":1149,"character":9999}}},{"containerName":"main::","definition":"sub","name":"newFh","range":{"start":{"character":0,"line":1167},"end":{"line":1171,"character":9999}},"kind":12,"line":1167,"children":[{"name":"$class","definition":"my","containerName":"newFh","localvar":"my","kind":13,"line":1168},{"kind":13,"line":1169,"containerName":"newFh","definition":"my","name":"$self","localvar":"my"},{"line":1169,"kind":13,"containerName":"newFh","name":"$class"},{"containerName":"newFh","name":"new","kind":12,"line":1169},{"kind":13,"line":1170,"containerName":"newFh","name":"$self"},{"name":"fh","containerName":"newFh","line":1170,"kind":12}]},{"name":"fh","definition":"sub","containerName":"main::","range":{"start":{"line":1188,"character":0},"end":{"line":1194,"character":9999}},"kind":12,"children":[{"kind":13,"line":1189,"definition":"my","name":"$self","containerName":"fh","localvar":"my"},{"line":1190,"kind":13,"localvar":"my","definition":"my","name":"$class","containerName":"fh"},{"line":1190,"kind":13,"name":"$self","containerName":"fh"},{"kind":13,"line":1190,"containerName":"fh","name":"$self"},{"localvar":"my","definition":"my","name":"$s","containerName":"fh","line":1191,"kind":13},{"kind":13,"line":1192,"containerName":"fh","name":"$class"},{"containerName":"fh","name":"$self","line":1192,"kind":13},{"kind":13,"line":1193,"containerName":"fh","name":"$s"}],"line":1188},{"kind":12,"line":1192,"containerName":"gensym","name":"Symbol"},{"range":{"start":{"line":1203,"character":0},"end":{"line":1210,"character":9999}},"containerName":"main::","definition":"sub","name":"_seq_by_id_h","line":1203,"children":[{"kind":13,"line":1204,"definition":"my","name":"$self","containerName":"_seq_by_id_h","localvar":"my"},{"kind":13,"line":1206,"name":"$self","containerName":"_seq_by_id_h"},{"containerName":"_seq_by_id_h","name":"$self","kind":13,"line":1207},{"containerName":"_seq_by_id_h","name":"$self","line":1208,"kind":13},{"kind":13,"line":1209,"name":"$self","containerName":"_seq_by_id_h"}],"kind":12},{"signature":{"documentation":"1;\n# $Id: GFF.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::GFF\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by the Bioperl core team\n#\n# Copyright Matthew Pocock\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::GFF - A Bio::SeqAnalysisParserI compliant GFF format parser\n\n=head1 SYNOPSIS\n\n    use Bio::Tools::GFF;\n\n    # specify input via -fh or -file\n    my $gffio = Bio::Tools::GFF->new(-fh => \\*STDIN, -gff_version => 2);\n    my $feature;\n    # loop over the input stream\n    while($feature = $gffio->next_feature()) {\n        # do something with feature\n    }\n    $gffio->close();\n\n    # you can also obtain a GFF parser as a SeqAnalasisParserI in\n    # HT analysis pipelines (see Bio::SeqAnalysisParserI and\n    # Bio::Factory::SeqAnalysisParserFactory)\n    my $factory = Bio::Factory::SeqAnalysisParserFactory->new();\n    my $parser = $factory->get_parser(-input => \\*STDIN, -method => \"gff\");\n    while($feature = $parser->next_feature()) {\n        # do something with feature\n    }\n\n=head1 DESCRIPTION\n\nThis class provides a simple GFF parser and writer. In the sense of a\nSeqAnalysisParser, it parses an input file or stream into SeqFeatureI\nobjects, but is not in any way specific to a particular analysis\nprogram and the output that program produces.\n\nThat is, if you can get your analysis program spit out GFF, here is\nyour result parser.\n\n=head1 GFF3 AND SEQUENCE DATA\n\nGFF3 supports sequence data; see\n\nhttp://www.sequenceontology.org/gff3.shtml\n\nThere are a number of ways to deal with this -\n\nIf you call\n\n  $gffio->ignore_sequence(1)\n\nprior to parsing the sequence data is ignored; this is useful if you\njust want the features. It avoids the memory overhead in building and\ncaching sequences\n\nAlternatively, you can call either\n\n  $gffio->get_seqs()\n\nOr\n\n  $gffio->seq_id_by_h()\n\nAt the B<end> of parsing to get either a list or hashref of Bio::Seq\nobjects (see the documentation for each of these methods)\n\nNote that these objects will not have the features attached - you have\nto do this yourself, OR call\n\n  $gffio->features_attached_to_seqs(1)\n\nPRIOR to parsing; this will ensure that the Seqs have the features\nattached; ie you will then be able to call\n\n  $seq->get_SeqFeatures();\n\nAnd use Bio::SeqIO methods\n\nNote that auto-attaching the features to seqs will incur a higher\nmemory overhead as the features must be cached until the sequence data\nis found\n\n=head1 TODO\n\nMake a Bio::SeqIO class specifically for GFF3 with sequence data\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Matthew Pocock\n\nEmail mrp-at-sanger.ac.uk\n\n=head1 CONTRIBUTORS \n\nJason Stajich, jason-at-biperl-dot-org\nChris Mungall, cjm-at-fruitfly-dot-org\nSteffen Grossmann [SG], grossman at molgen.mpg.de\nMalcolm Cook, mec-at-stowers-institute.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tools::GFF;\n\nuse vars qw($HAS_HTML_ENTITIES);\nuse strict;\n\nuse Bio::Seq::SeqFactory;\nuse Bio::LocatableSeq;\nuse Bio::SeqFeature::Generic;\n\nuse base qw(Bio::Root::Root Bio::SeqAnalysisParserI Bio::Root::IO);\n\nmy $i = 0;\nmy %GFF3_ID_Tags = map { $_ => $i++ } qw(ID Parent Target);\n\n=head2 new\n\n Title   : new\n Usage   : my $parser = Bio::Tools::GFF->new(-gff_version => 2,\n\t\t\t\t\t    -file        => \"filename.gff\");\n           or\n           my $writer = Bio::Tools::GFF->new(-gff_version => 3,\n\t\t\t\t\t    -file        => \">filename.gff3\");\n Function: Creates a new instance. Recognized named parameters are -file, -fh,\n           and -gff_version.\n Returns : a new object\n Args    : named parameters\n           -gff_version => [1,2,3]\n\n\n\n{   # make a class variable such that we can generate unique ID's over\n    # a session, no matter how many instances of GFF.pm we make\n    # since these have to be unique within the scope of a GFF file.\n    \n    my $gff3_featureID = 0;\n    \n    sub _incrementGFF3ID {\n        my ($self) = @_;\n        return ++ $gff3_featureID;\n    }\n}\n\n\nsub new {\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n  \n  my ($gff_version, $noparse) = $self->_rearrange([qw(GFF_VERSION NOPARSE)],@args);\n\n  # initialize IO\n  $self->_initialize_io(@args);\n  $self->_parse_header() unless $noparse;\n\n  $gff_version ||= 2;\n  if( ! $self->gff_version($gff_version) )  {\n      $self->throw(\"Can't build a GFF object with the unknown version \".\n\t\t   $gff_version);\n  }\n  $self->{'_first'} = 1;\n  return $self;\n}\n\n=head2 _parse_header\n\n Title   : _parse_header\n Usage   : $gffio->_parse_header()\n Function: used to turn parse GFF header lines.  currently\n           produces Bio::LocatableSeq objects from ##sequence-region\n           lines\n Returns : 1 on success\n Args    : none\n\n\n\nsub _parse_header{\n   my ($self) = @_;\n\n   my @unhandled;\n   local $^W = 0; # hide warnings when we try and parse from a file opened\n                  # for writing - there isn't really a better way to do\n                  # AFAIK - cannot detech if a FH is read or write.\n   while(my $line = $self->_readline()){\n \t my $handled = 0;\n\t next if /^\\s+$/;\n\t if($line =~ /^\\#\\#sequence-region\\s+(\\S+)\\s+(\\S+)\\s+(\\S+)\\s*/){\n\t   my($seqid,$start,$end) = ($1,$2,$3);\n\t   push @{ $self->{'segments'} }, Bio::LocatableSeq->new\n\t       (\n\t\t-id    => unescape($seqid),\n\t\t-start => $start,\n\t\t-end   => $end,\n                -length => ($end - $start + 1),  ## make the length explicit\n\t\t);\n\t   $handled = 1;\n\t } elsif($line =~ /^(\\#\\#feature-ontology)/) {\n\t   #to be implemented\n\t   $self->warn(\"$1 header tag parsing unimplemented\");\n\t } elsif($line =~ /^(\\#\\#attribute-ontology)/) {\n\t   #to be implemented\n\t   $self->warn(\"$1 header tag parsing unimplemented\");\n\t } elsif($line =~ /^(\\#\\#source-ontology)/) {\n\t   #to be implemented\n\t   $self->warn(\"$1 header tag parsing unimplemented\");\n\t } elsif($line =~ /^(\\#\\#\\#)/) {\n\t   #to be implemented\n\t   $self->warn(\"$1 header tag parsing unimplemented\");\n\t } elsif($line =~ /^(\\#\\#FASTA)/) {\n            # initial ##FASTA is optional - artemis does not use it\n            $line = $self->_readline();\n            if ($line !~ /^\\>(\\S+)/) {\n                $self->throw(\"##FASTA directive must be followed by fasta header, not: $line\");\n            }\n\t } else {\n         }\n         \n         if ($line =~ /^\\>(.*)/) {\n             # seq data can be at header or footer\n             my $seq = $self->_parse_sequence($line);\n             if ($seq) {\n                 $self->_seq_by_id_h->{$seq->primary_id} = $seq;\n             }\n         }\n             \n\n \t if(!$handled){\n\t   push @unhandled, $line\n \t }\n\n\t #looks like the header is over!\n\t last unless $line =~ /^\\#/;\n   }\n\n   foreach my $line (@unhandled){\n\t $self->_pushback($line);\n   }\n\n   return 1;\n}\n\nsub _parse_sequence {\n    my ($self, $line) = @_;\n\n    if ($line =~ /^\\>(.*)/) {\n        \n        my $seqid = $1;\n        $seqid =~ s/\\s+$//;\n        my $desc = '';\n        if ($seqid =~ /(\\S+)\\s+(.*)/) {\n            ($seqid, $desc) = ($1,$2);\n        }\n        my $res = '';\n        while (my $line = $self->_readline) {\n            if ($line =~ /^\\#/) {\n                last;\n            }\n            if ($line =~ /^\\>/) {\n                $self->_pushback($line);\n                last;\n            }\n            $line =~ s/\\s//g;\n            $res .= $line;\n        }\n        return if $self->ignore_sequence;\n\n        my $seqfactory = Bio::Seq::SeqFactory->new('Bio::Seq');\n        my $seq = $seqfactory->create(-seq=>$res, \n                                      -id=>$seqid,\n                                      -desc=>$desc);\n        $seq->accession_number($seqid);\n        if ($self->features_attached_to_seqs) {\n            my @feats = \n              @{$self->_feature_idx_by_seq_id->{$seqid}};\n            $seq->add_SeqFeature($_) foreach @feats;\n            @{$self->_feature_idx_by_seq_id->{$seqid}} = ();\n        }\n        return $seq;\n    }\n    else {\n        $self->throw(\"expected fasta header, not: $line\");\n    }\n}\n\n\n=head2 next_segment\n\n Title   : next_segment\n Usage   : my $seq = $gffio->next_segment;\n Function: Returns a Bio::LocatableSeq object corresponding to a \n           GFF \"##sequence-region\" header line.\n Example :\n Returns : A Bio::LocatableSeq object, or undef if\n           there are no more sequences.\n Args    : none\n\n\n\nsub next_segment{\n   my ($self,@args) = @_;\n   return shift @{ $self->{'segments'} } if defined $self->{'segments'};\n   return;\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : $seqfeature = $gffio->next_feature();\n Function: Returns the next feature available in the input file or stream, or\n           undef if there are no more features.\n Example :\n Returns : A Bio::SeqFeatureI implementing object, or undef if there are no\n           more features.\n Args    : none    \n\n\nsub next_feature {\n    my ($self) = @_;\n    \n    my $gff_string;\n    \n    # be graceful about empty lines or comments, and make sure we return undef\n    # if the input's consumed\n    while(($gff_string = $self->_readline()) && defined($gff_string)) {\t\n        if ($gff_string =~ /^\\#\\#\\#/) {\n            # all forward refs have been seen; TODO\n        }\n        next if($gff_string =~ /^\\#/ || $gff_string =~ /^\\s*$/ ||\n                $gff_string =~ m{^//});\n\n        while ($gff_string =~ /^\\>(.+)/) {\n            # fasta can be in header or footer\n            my $seq = $self->_parse_sequence($gff_string);\n            if ($seq) {\n                $self->_seq_by_id_h->{$seq->primary_id} = $seq;\n                $gff_string = $self->_readline;\n                last unless $gff_string;\n            }\n        }\n        last; \n    }\n    return unless $gff_string;\n\n    my $feat = Bio::SeqFeature::Generic->new();\n    $self->from_gff_string($feat, $gff_string);\n\n    if ($self->features_attached_to_seqs) {\n        push(@{$self->_feature_idx_by_seq_id->{$feat->seq_id}},\n             $feat);\n    }\n\n    return $feat;\n}\n\nsub _feature_idx_by_seq_id {\n    my $self = shift;\n    $self->{__feature_idx_by_seq_id} = shift if @_;\n    $self->{__feature_idx_by_seq_id} = {}\n      unless $self->{__feature_idx_by_seq_id};\n    return $self->{__feature_idx_by_seq_id};\n}\n\n\n=head2 from_gff_string\n\n Title   : from_gff_string\n Usage   : $gff->from_gff_string($feature, $gff_string);\n Function: Sets properties of a SeqFeatureI object from a GFF-formatted\n           string. Interpretation of the string depends on the version\n           that has been specified at initialization.\n\n           This method is used by next_feature(). It actually dispatches to\n           one of the version-specific (private) methods.\n Example :\n Returns : void\n Args    : A Bio::SeqFeatureI implementing object to be initialized\n           The GFF-formatted string to initialize it from\n\n\nsub from_gff_string {\n    my ($self, $feat, $gff_string) = @_;\n\n    if($self->gff_version() == 1)  {\n\treturn $self->_from_gff1_string($feat, $gff_string);\n    } elsif( $self->gff_version() == 3 ) {\n\treturn $self->_from_gff3_string($feat, $gff_string);\n    } else {\n\treturn $self->_from_gff2_string($feat, $gff_string);\n    }\n}\n\n=head2 _from_gff1_string\n\n Title   : _from_gff1_string\n Usage   :\n Function:\n Example :\n Returns : void\n Args    : A Bio::SeqFeatureI implementing object to be initialized\n           The GFF-formatted string to initialize it from\n\n\nsub _from_gff1_string {\n   my ($gff, $feat, $string) = @_;\n   chomp $string;\n   my ($seqname, $source, $primary, $start, $end, $score, \n       $strand, $frame, @group) = split(/\\t/, $string);\n\n   if ( !defined $frame ) {\n       $feat->throw(\"[$string] does not look like GFF to me\");\n   }\n   $frame = 0 unless( $frame =~ /^\\d+$/);\n   $feat->seq_id($seqname);\n   $feat->source_tag($source);\n   $feat->primary_tag($primary);\n   $feat->start($start);\n   $feat->end($end);\n   $feat->frame($frame);\n   if ( $score eq '.' ) {\n       #$feat->score(undef);\n   } else {\n       $feat->score($score);\n   }\n   if ( $strand eq '-' ) { $feat->strand(-1); }\n   if ( $strand eq '+' ) { $feat->strand(1); }\n   if ( $strand eq '.' ) { $feat->strand(0); }\n   foreach my $g ( @group ) {\n       if ( $g =~ /(\\S+)=(\\S+)/ ) {\n\t   my $tag = $1;\n\t   my $value = $2;\n\t   $feat->add_tag_value($1, $2);\n       } else {\n\t   $feat->add_tag_value('group', $g);\n       }\n   }\n}\n\n=head2 _from_gff2_string\n\n Title   : _from_gff2_string\n Usage   :\n Function:\n Example :\n Returns : void\n Args    : A Bio::SeqFeatureI implementing object to be initialized\n           The GFF2-formatted string to initialize it from\n\n\n\nsub _from_gff2_string {\n   my ($gff, $feat, $string) = @_;\n   chomp($string);\n\n   # according to the Sanger website, GFF2 should be single-tab\n   # separated elements, and the free-text at the end should contain\n   # text-translated tab symbols but no \"real\" tabs, so splitting on\n   # \\t is safe, and $attribs gets the entire attributes field to be\n   # parsed later\n   \n   # sendu: but the tag value pair can (should?) be separated by a tab. The\n   # 'no tabs' thing seems to apply only to the free text that is allowed for\n   # the value\n\n   my ($seqname, $source, $primary, $start, \n       $end, $score, $strand, $frame, @attribs) = split(/\\t+/, $string);\n   my $attribs = join ' ', @attribs;\n   \n   if ( !defined $frame ) {\n       $feat->throw(\"[$string] does not look like GFF2 to me\");\n   }\n   $feat->seq_id($seqname);\n   $feat->source_tag($source);\n   $feat->primary_tag($primary);\n   $feat->start($start);\n   $feat->end($end);\n   $feat->frame($frame);\n   if ( $score eq '.' ) {\n       # $feat->score(undef);\n   } else {\n       $feat->score($score);\n   }\n   if ( $strand eq '-' ) { $feat->strand(-1); }\n   if ( $strand eq '+' ) { $feat->strand(1); }\n   if ( $strand eq '.' ) { $feat->strand(0); }\n\n\n   #  <Begin Inefficient Code from Mark Wilkinson> \n   # this routine is necessay to allow the presence of semicolons in\n   # quoted text Semicolons are the delimiting character for new\n   # tag/value attributes.  it is more or less a \"state\" machine, with\n   # the \"quoted\" flag going up and down as we pass thorugh quotes to\n   # distinguish free-text semicolon and hash symbols from GFF control\n   # characters\n   \n   \n   my $flag = 0; # this could be changed to a bit and just be twiddled\n   my @parsed;\n\n   # run through each character one at a time and check it\n   # NOTE: changed to foreach loop which is more efficient in perl\n   # --jasons\n   for my $a ( split //, $attribs ) { \n       # flag up on entering quoted text, down on leaving it\n       if( $a eq '\"') { $flag = ( $flag == 0 ) ? 1:0 }\n       elsif( $a eq ';' && $flag ) { $a = \"INSERT_SEMICOLON_HERE\"}\n       elsif( $a eq '#' && ! $flag ) { last } \n       push @parsed, $a;\n   }\n   $attribs = join \"\", @parsed; # rejoin into a single string\n\n   # <End Inefficient Code>   \n   # Please feel free to fix this and make it more \"perlish\"\n\n   my @key_vals = split /;/, $attribs;   # attributes are semicolon-delimited\n\n   foreach my $pair ( @key_vals ) {\n       # replace semicolons that were removed from free-text above.\n       $pair =~ s/INSERT_SEMICOLON_HERE/;/g;        \n\n       # separate the key from the value\n       my ($blank, $key, $values) = split  /^\\s*([\\w\\d]+)\\s/, $pair; \n\n\n       if( defined $values ) {\n\t   my @values;\n\t   # free text is quoted, so match each free-text block\n\t   # and remove it from the $values string\n\t   while ($values =~ s/\"(.*?)\"//){\n\t       # and push it on to the list of values (tags may have\n\t       # more than one value... and the value may be undef)\t       \n\t       push @values, $1;\n\t   }\n\n\t   # and what is left over should be space-separated\n\t   # non-free-text values\n\n\t   my @othervals = split /\\s+/, $values;  \n\t   foreach my $othervalue(@othervals){\n\t       # get rid of any empty strings which might \n\t       # result from the split\n\t       if (CORE::length($othervalue) > 0) {push @values, $othervalue}  \n\t   }\n\n\t   foreach my $value(@values){\n\t       $feat->add_tag_value($key, $value);\n\t   }\n       }\n   }\n}\n\n\nsub _from_gff3_string {\n    my ($gff, $feat, $string) = @_;\n    chomp($string);\n\n    # according to the now nearly final GFF3 spec, columns should \n    # be tab separated, allowing unescaped spaces to occur in\n    # column 9\n\n    my ($seqname, $source, $primary, $start, $end, \n\t$score, $strand, $frame, $groups) = split(/\\t/, $string);\n    \n    if ( ! defined $frame ) {\n\t$feat->throw(\"[$string] does not look like GFF3 to me\");\n    }\n    $feat->seq_id($seqname);\n    $feat->source_tag($source);\n    $feat->primary_tag($primary);\n    $feat->start($start);\n    $feat->end($end);\n    $feat->frame($frame);\n    if ( $score eq '.' ) {\n\t#$feat->score(undef);\n    } else {\n\t$feat->score($score);\n    }\n    if ( $strand eq '-' ) { $feat->strand(-1); }\n    if ( $strand eq '+' ) { $feat->strand(1); }\n    if ( $strand eq '.' ) { $feat->strand(0); }\n    my @groups = split(/\\s*;\\s*/, $groups);\n\n    for my $group (@groups) {\n\tmy ($tag,$value) = split /=/,$group;\n\t$tag             = unescape($tag);\n\tmy @values       = map {unescape($_)} split /,/,$value;\n\tfor my $v ( @values ) {  $feat->add_tag_value($tag,$v); }\n    }\n}\n\n# taken from Bio::DB::GFF\nsub unescape {\n  my $v = shift;\n  $v =~ tr/+/ /;\n  $v =~ s/%([0-9a-fA-F]{2})/chr hex($1)/ge;\n  return $v;\n}\n\n=head2 write_feature\n\n Title   : write_feature\n Usage   : $gffio->write_feature($feature);\n Function: Writes the specified SeqFeatureI object in GFF format to the stream\n           associated with this instance.\n Returns : none\n Args    : An array of Bio::SeqFeatureI implementing objects to be serialized\n\n\nsub write_feature {\n    my ($self, @features) = @_;\n    return unless @features;\n    if( $self->{'_first'} && $self->gff_version() == 3 ) {\n\t$self->_print(\"##gff-version 3\\n\");\n    }\n    $self->{'_first'} = 0;\n    foreach my $feature ( @features ) {\n\t$self->_print($self->gff_string($feature).\"\\n\");\n    }\n}\n\n=head2 gff_string\n\n Title   : gff_string\n Usage   : $gffstr = $gffio->gff_string($feature);\n Function: Obtain the GFF-formatted representation of a SeqFeatureI object.\n           The formatting depends on the version specified at initialization.\n\n           This method is used by write_feature(). It actually dispatches to\n           one of the version-specific (private) methods.\n Example :\n Returns : A GFF-formatted string representation of the SeqFeature\n Args    : A Bio::SeqFeatureI implementing object to be GFF-stringified\n\n\nsub gff_string{\n    my ($self, $feature) = @_;\n\n    if($self->gff_version() == 1) {\n    \treturn $self->_gff1_string($feature);\n    } elsif( $self->gff_version() == 3 ) {\n    \treturn $self->_gff3_string($feature);\n    } elsif( $self->gff_version() == 2.5 ) {\n    \treturn $self->_gff25_string($feature);\n    } else {\n    \treturn $self->_gff2_string($feature);\n    }\n}\n\n=head2 _gff1_string\n\n Title   : _gff1_string\n Usage   : $gffstr = $gffio->_gff1_string\n Function: \n Example :\n Returns : A GFF1-formatted string representation of the SeqFeature\n Args    : A Bio::SeqFeatureI implementing object to be GFF-stringified\n\n\nsub _gff1_string{\n   my ($gff, $feat) = @_;\n   my ($str,$score,$frame,$name,$strand);\n\n   if( $feat->can('score') ) {\n       $score = $feat->score();\n   }\n   $score = '.' unless defined $score;\n\n   if( $feat->can('frame') ) {\n       $frame = $feat->frame();\n   }\n   $frame = '.' unless defined $frame;\n\n   $strand = $feat->strand();\n   if(! $strand) {\n       $strand = \".\";\n   } elsif( $strand == 1 ) {\n       $strand = '+';\n   } elsif ( $feat->strand == -1 ) {\n       $strand = '-';\n   }\n   \n   if( $feat->can('seqname') ) {\n       $name = $feat->seq_id();\n       $name ||= 'SEQ';\n   } else {\n       $name = 'SEQ';\n   }\n\n\n   $str = join(\"\\t\",\n                 $name,\n\t\t $feat->source_tag(),\n\t\t $feat->primary_tag(),\n\t\t $feat->start(),\n\t\t $feat->end(),\n\t\t $score,\n\t\t $strand,\n\t\t $frame);\n\n   foreach my $tag ( $feat->all_tags ) {\n       foreach my $value ( $feat->each_tag_value($tag) ) {\n\t   $str .= \" $tag=$value\" if $value;\n       }\n   }\n\n\n   return $str;\n}\n\n=head2 _gff2_string\n\n Title   : _gff2_string\n Usage   : $gffstr = $gffio->_gff2_string\n Function: \n Example :\n Returns : A GFF2-formatted string representation of the SeqFeature\n Args    : A Bio::SeqFeatureI implementing object to be GFF2-stringified\n\n\nsub _gff2_string{\n   my ($gff, $origfeat) = @_;\n    my $feat;\n   if ($origfeat->isa('Bio::SeqFeature::FeaturePair')){\n       $feat = $origfeat->feature2;\n   } else {\n       $feat = $origfeat;\n   }\n   my ($str1, $str2,$score,$frame,$name,$strand);\n\n   if( $feat->can('score') ) {\n       $score = $feat->score();\n   }\n   $score = '.' unless defined $score;\n\n   if( $feat->can('frame') ) {\n       $frame = $feat->frame();\n   }\n   $frame = '.' unless defined $frame;\n\n   $strand = $feat->strand();\n   if(! $strand) {\n       $strand = \".\";\n   } elsif( $strand == 1 ) {\n       $strand = '+';\n   } elsif ( $feat->strand == -1 ) {\n       $strand = '-';\n   }\n\n   if( $feat->can('seqname') ) {\n       $name = $feat->seq_id();\n       $name ||= 'SEQ';\n   } else {\n       $name = 'SEQ';\n   }\n   $str1 = join(\"\\t\",\n                 $name,\n\t\t $feat->source_tag(),\n\t\t $feat->primary_tag(),\n\t\t $feat->start(),\n\t\t $feat->end(),\n\t\t $score,\n\t\t $strand,\n\t\t $frame);\n   # the routine below is the only modification I made to the original\n   # ->gff_string routine (above) as on November 17th, 2000, the\n   # Sanger webpage describing GFF2 format reads: \"From version 2\n   # onwards, the attribute field must have a tag value structure\n   # following the syntax used within objects in a .ace file,\n   # flattened onto one line by semicolon separators. Tags must be\n   # standard identifiers ([A-Za-z][A-Za-z0-9_]*).  Free text values\n   # must be quoted with double quotes\".\n\n   # MW\n\n   \n   my @all_tags = $feat->all_tags;\n   my @group;\n   if (@all_tags) {  # only play this game if it is worth playing...\n       foreach my $tag ( @all_tags ) {\n\t   my @v;\n\t   foreach my $value ( $feat->each_tag_value($tag) ) {\n \t       unless( defined $value && length($value) ) {\n\t\t   $value = '\"\"';\n\t       } elsif ($value =~ /[^A-Za-z0-9_]/){\n\t\t   $value =~ s/\\t/\\\\t/g; # substitute tab and newline \n\t\t                         # characters\n\t\t   $value =~ s/\\n/\\\\n/g; # to their UNIX equivalents\n\t\t   $value = '\"' . $value . '\" ';\n\t       }                                 # if the value contains \n\t                                         # anything other than valid \n\t                                         # tag/value characters, then \n\t                                         # quote it\n\t       push @v, $value;\n\t       # for this tag (allowed in GFF2 and .ace format)\n\t   }\n\t   push @group, \"$tag \".join(\" \", @v);\n       }\n   }\n   $str2 .= join(' ; ', @group);\n   # Add Target information for Feature Pairs\n   if( ! $feat->has_tag('Target') && # This is a bad hack IMHO\n       ! $feat->has_tag('Group') &&\n       $origfeat->isa('Bio::SeqFeature::FeaturePair') ) {\n       $str2 = sprintf(\"Target %s %d %d\", $origfeat->feature1->seq_id,\n\t\t       ( $origfeat->feature1->strand < 0 ? \n\t\t\t ( $origfeat->feature1->end,\n\t\t\t   $origfeat->feature1->start) :\n\t\t\t ( $origfeat->feature1->start,\n\t\t\t   $origfeat->feature1->end) \n\t\t\t )) . ($str2?\" ; \".$str2:\"\");  # need to put Target information before other tag/value pairs - mw\n   }\n   return $str1.\"\\t\".$str2;\n}\n\n\n\n=head2 _gff25_string\n\n Title   : _gff25_string\n Usage   : $gffstr = $gffio->_gff2_string\n Function: To get a format of GFF that is peculiar to Gbrowse/Bio::DB::GFF\n Example :\n Returns : A GFF2.5-formatted string representation of the SeqFeature\n Args    : A Bio::SeqFeatureI implementing object to be GFF2.5-stringified\n\n\nsub _gff25_string {\n    my ($gff, $origfeat) = @_;\n    my $feat;\n    if ($origfeat->isa('Bio::SeqFeature::FeaturePair')){\n\t$feat = $origfeat->feature2;\n    } else {\n\t$feat = $origfeat;\n    }\n    my ($str1, $str2,$score,$frame,$name,$strand);\n\n    if( $feat->can('score') ) {\n\t$score = $feat->score();\n    }\n    $score = '.' unless defined $score;\n\n    if( $feat->can('frame') ) {\n\t$frame = $feat->frame();\n    }\n    $frame = '.' unless defined $frame;\n\n    $strand = $feat->strand();\n    if(! $strand) {\n\t$strand = \".\";\n    } elsif( $strand == 1 ) {\n\t$strand = '+';\n    } elsif ( $feat->strand == -1 ) {\n\t$strand = '-';\n    }\n\n    if( $feat->can('seqname') ) {\n\t$name = $feat->seq_id();\n\t$name ||= 'SEQ';\n    } else {\n\t$name = 'SEQ';\n    }\n    $str1 = join(\"\\t\",\n                 $name,\n\t\t $feat->source_tag(),\n\t\t $feat->primary_tag(),\n\t\t $feat->start(),\n\t\t $feat->end(),\n\t\t $score,\n\t\t $strand,\n\t\t $frame);\n\n    my @all_tags = $feat->all_tags;\n    my @group; my @firstgroup;\n    if (@all_tags) {   # only play this game if it is worth playing...\n\tforeach my $tag ( @all_tags ) {\n\t    my @v;\n\t    foreach my $value ( $feat->each_tag_value($tag) ) {\n\t\tunless( defined $value && length($value) ) {\n\t\t    $value = '\"\"';\n\t\t} elsif ($value =~ /[^A-Za-z0-9_]/){\n\t\t    $value =~ s/\\t/\\\\t/g; # substitute tab and newline \n\t\t    # characters\n\t\t    $value =~ s/\\n/\\\\n/g; # to their UNIX equivalents\n\t\t    $value = '\"' . $value . '\" ';\n\t\t}\t\t# if the value contains \n\t\t# anything other than valid \n\t\t# tag/value characters, then \n\t\t# quote it\n\t\tpush @v, $value;\n\t\t# for this tag (allowed in GFF2 and .ace format)\n\t    }\n\t    if (($tag eq 'Group') || ($tag eq 'Target')){ # hopefully we wont get both...\n\t\tpush @firstgroup, \"$tag \".join(\" \", @v);\n\t\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t    push @group, \"$tag \".join(\" \", @v);\n\t\t\t\t\t\t\t}\n\t}\n\t\t   }\n    $str2 = join(' ; ', (@firstgroup, @group));\n    # Add Target information for Feature Pairs\n    if( ! $feat->has_tag('Target') && # This is a bad hack IMHO\n\t! $feat->has_tag('Group') &&\n\t$origfeat->isa('Bio::SeqFeature::FeaturePair') ) {\n\t$str2 = sprintf(\"Target %s ; tstart %d ; tend %d\", $origfeat->feature1->seq_id,\n\t\t\t( $origfeat->feature1->strand < 0 ? \n\t\t\t  ( $origfeat->feature1->end,\n\t\t\t    $origfeat->feature1->start) :\n\t\t\t  ( $origfeat->feature1->start,\n\t\t\t    $origfeat->feature1->end) \n\t\t\t)) . ($str2?\" ; \".$str2:\"\"); # need to put the target info before other tag/value pairs - mw\n    }\n    return $str1 . \"\\t\".  $str2;\n}\n\n\n=head2 _gff3_string\n\n  Title   : _gff3_string\n  Usage   : $gffstr = $gffio->_gff3_string\n  Function: \n  Example :\n  Returns : A GFF3-formatted string representation of the SeqFeature\n  Args    : A Bio::SeqFeatureI implementing object to be GFF3-stringified\n\n\nsub _gff3_string {\n    my ($gff, $origfeat) = @_;\n    my $feat;\n    if ($origfeat->isa('Bio::SeqFeature::FeaturePair')){\n\t$feat = $origfeat->feature2;\n    } else {\n\t$feat = $origfeat;\n    }\n\n    my $ID = $gff->_incrementGFF3ID();\n\n    my ($score,$frame,$name,$strand);\n\n    if( $feat->can('score') ) {\n\t$score = $feat->score();\n    }\n    $score = '.' unless defined $score;\n\n    if( $feat->can('frame') ) {\n\t$frame = $feat->frame();\n    }\n    $frame = '.' unless defined $frame;\n\n    $strand = $feat->strand();\n\n    if(! $strand) {\n\t$strand = \".\";\n    } elsif( $strand == 1 ) {\n\t$strand = '+';\n    } elsif ( $feat->strand == -1 ) {\n\t$strand = '-';\n    }\n\n    if( $feat->can('seqname') ) {\n\t$name = $feat->seq_id();\n\t$name ||= 'SEQ';\n    } else {\n\t$name = 'SEQ';\n    }\n\n    my @groups;\n\n    # force leading ID and Parent tags\n    my @all_tags =  grep { ! exists $GFF3_ID_Tags{$_} } $feat->all_tags;\n    for my $t ( sort { $GFF3_ID_Tags{$b} <=> $GFF3_ID_Tags{$a} }\n\t\tkeys %GFF3_ID_Tags ) {\n\tunshift @all_tags, $t if $feat->has_tag($t);\n    }\n\n    for my $tag ( @all_tags ) {\n\t# next if $tag eq 'Target';\n\tif ($tag eq 'Target' && ! $origfeat->isa('Bio::SeqFeature::FeaturePair')){  \n\t    # simple Target,start,stop\n\t    my($target_id, $b,$e,$strand) = $feat->get_tag_values($tag); \n\t    next unless(defined($e) && defined($b) && $target_id);\t\t\t\n\t    ($b,$e)= ($e,$b) if(defined $strand && $strand<0);\n\t    $target_id =~ s/([\\t\\n\\r%&\\=;,])/sprintf(\"%%%X\",ord($1))/ge;    \n\t    push @groups, sprintf(\"Target=%s %d %d\", $target_id,$b,$e);\n\t    next;\n\t}\n\n\tmy $valuestr;\t\n\t# a string which will hold one or more values \n\t# for this tag, with quoted free text and \n\t# space-separated individual values.\n\tmy @v;\n\tfor my $value ( $feat->each_tag_value($tag) ) {\t    \n\t    if(  defined $value && length($value) ) { \n\t\t\t\t#$value =~ tr/ /+/;  #spaces are allowed now\n                if ( ref $value eq 'Bio::Annotation::Comment') {\n                    $value = $value->text;\n                }\n\n\t\tif ($value =~ /[^a-zA-Z0-9\\,\\;\\=\\.:\\%\\^\\*\\$\\@\\!\\+\\_\\?\\-]/) {\n\t\t    $value =~ s/\\t/\\\\t/g; # substitute tab and newline \n\t\t    # characters\n\t\t    $value =~ s/\\n/\\\\n/g; # to their UNIX equivalents\n\n\t\t    # Unescaped quotes are not allowed in GFF3\n\t\t    #\t\t    $value = '\"' . $value . '\"';\n\t\t}\n\t\t$value =~ s/([\\t\\n\\r%&\\=;,])/sprintf(\"%%%X\",ord($1))/ge;\n\t    } else {\n\t\t\t\t# if it is completely empty, \n\t\t\t\t# then just make empty double \n\t\t\t\t# quotes\n\t\t$value = '\"\"';\n\t    }\n\t    push @v, $value;\n\t}\n\t# can we figure out how to improve this?\n\t$tag= lcfirst($tag) unless ($tag \n\t\t\t\t    =~ /^(ID|Name|Alias|Parent|Gap|Target|Derives_from|Note|Dbxref|Ontology_term)$/);\n\n\tpush @groups, \"$tag=\".join(\",\",@v);\n    }\n    # Add Target information for Feature Pairs\n    if( $feat->has_tag('Target') && \n\t! $feat->has_tag('Group') &&\n\t$origfeat->isa('Bio::SeqFeature::FeaturePair') ) {\n\n\tmy $target_id = $origfeat->feature1->seq_id;\n\t$target_id =~ s/([\\t\\n\\r%&\\=;,])/sprintf(\"%%%X\",ord($1))/ge;    \n\n\tpush @groups, sprintf(\"Target=%s %d %d\", \n\t\t\t      $target_id,\n\t\t\t      ( $origfeat->feature1->strand < 0 ? \n\t\t\t\t( $origfeat->feature1->end,\n\t\t\t\t  $origfeat->feature1->start) :\n\t\t\t\t( $origfeat->feature1->start,\n\t\t\t\t  $origfeat->feature1->end) \n\t\t\t\t));\n    }\n\n    # unshift @groups, \"ID=autogenerated$ID\" unless ($feat->has_tag('ID'));\n    if ( $feat->can('name') && defined($feat->name) ) {\n\t# such as might be for Bio::DB::SeqFeature\n\tunshift @groups, 'Name=' . $feat->name;\n    }\n\n    my $gff_string = \"\";\n    if ($feat->location->isa(\"Bio::Location::SplitLocationI\")) {\n\tmy @locs = $feat->location->each_Location;\n\tforeach my $loc (@locs) {\n\t    $gff_string .= join(\"\\t\",\n\t\t\t\t$name,\n\t\t\t\t$feat->source_tag() || '.',\n\t\t\t\t$feat->primary_tag(),\n\t\t\t\t$loc->start(),\n\t\t\t\t$loc->end(),\n\t\t\t\t$score,\n\t\t\t\t$strand,\n\t\t\t\t$frame,\n\t\t\t\tjoin(';', @groups)) . \"\\n\";\n\t}\n\tchop $gff_string;\n\treturn $gff_string;\n    } else {\n\t$gff_string = join(\"\\t\",\n\t\t\t   $name,\n\t\t\t   $feat->source_tag() || '.',\n\t\t\t   $feat->primary_tag(),\n\t\t\t   $feat->start(),\n\t\t\t   $feat->end(),\n\t\t\t   $score,\n\t\t\t   $strand,\n\t\t\t   $frame, \n\t\t\t   join(';', @groups));\n    }\n    return $gff_string;\n}\n\n=head2 gff_version\n\n  Title   : _gff_version\n  Usage   : $gffversion = $gffio->gff_version\n  Function: \n  Example :\n  Returns : The GFF version this parser will accept and emit.\n  Args    : none\n\n\nsub gff_version {\n    my ($self, $value) = @_;\n    if(defined $value && grep {$value == $_ } ( 1, 2, 2.5, 3)) {\n\t$self->{'GFF_VERSION'} = $value;\n    }\n    return $self->{'GFF_VERSION'};\n}\n\n# Make filehandles\n\n=head2 newFh\n\n Title   : newFh\n Usage   : $fh = Bio::Tools::GFF->newFh(-file=>$filename,-format=>'Format')\n Function: does a new() followed by an fh()\n Example : $fh = Bio::Tools::GFF->newFh(-file=>$filename,-format=>'Format')\n           $feature = <$fh>;            # read a feature object\n           print $fh $feature;          # write a feature object\n Returns : filehandle tied to the Bio::Tools::GFF class\n Args    :\n\n\n\nsub newFh {\n    my $class = shift;\n    return unless my $self = $class->new(@_);\n    return $self->fh;\n}\n\n=head2 fh\n\n Title   : fh\n Usage   : $obj->fh\n Function:\n Example : $fh = $obj->fh;      # make a tied filehandle\n           $feature = <$fh>;    # read a feature object\n           print $fh $feature;  # write a feature object\n Returns : filehandle tied to Bio::Tools::GFF class\n Args    : none\n\n\n\n\nsub fh {\n    my $self = shift;\n    my $class = ref($self) || $self;\n    my $s = Symbol::gensym;\n    tie $$s,$class,$self;\n    return $s;\n}\n\n# This accessor is used for accessing the Bio::Seq objects from a GFF3\n# file; if the file you are using has no sequence data you can ignore\n# this accessor\n\n# This accessor returns a hash reference containing Bio::Seq objects,\n# indexed by Bio::Seq->primary_id\n\nsub _seq_by_id_h {\n    my $self = shift;\n\n    return $self->{'_seq_by_id_h'} = shift if @_;\n    $self->{'_seq_by_id_h'} = {}\n    unless $self->{'_seq_by_id_h'};\n    return $self->{'_seq_by_id_h'};\n}\n\n=head2 get_seqs\n\n Title   : get_seqs\n Usage   :\n Function: Returns all Bio::Seq objects populated by GFF3 file\n Example :\n Returns : \n Args    :","parameters":[{"label":"$self"},{"label":"@args"}],"label":"get_seqs($self,@args)"},"detail":"($self,@args)","definition":"sub","containerName":"main::","children":[{"localvar":"my","definition":"my","name":"$self","containerName":"get_seqs","line":1224,"kind":13},{"containerName":"get_seqs","name":"@args","kind":13,"line":1224},{"name":"$self","containerName":"get_seqs","line":1225,"kind":13},{"containerName":"get_seqs","name":"_seq_by_id_h","kind":12,"line":1225}],"line":1223,"kind":12,"range":{"end":{"line":1225,"character":9999},"start":{"line":1223,"character":0}},"name":"get_seqs"},{"line":1249,"children":[{"line":1250,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"features_attached_to_seqs"},{"kind":13,"line":1252,"name":"$self","containerName":"features_attached_to_seqs"},{"containerName":"features_attached_to_seqs","name":"$self","line":1253,"kind":13}],"kind":12,"range":{"end":{"line":1254,"character":9999},"start":{"character":0,"line":1249}},"containerName":"main::","definition":"sub","name":"features_attached_to_seqs"},{"containerName":"main::","definition":"sub","name":"ignore_sequence","range":{"end":{"character":9999,"line":1276},"start":{"line":1271,"character":0}},"kind":12,"line":1271,"children":[{"kind":13,"line":1272,"containerName":"ignore_sequence","name":"$self","definition":"my","localvar":"my"},{"line":1274,"kind":13,"name":"$self","containerName":"ignore_sequence"},{"name":"$self","containerName":"ignore_sequence","line":1275,"kind":13}]},{"kind":12,"children":[{"line":1280,"kind":13,"localvar":"my","containerName":"DESTROY","name":"$self","definition":"my"},{"line":1281,"kind":13,"name":"$self","containerName":"DESTROY"},{"containerName":"DESTROY","name":"close","line":1281,"kind":12}],"line":1279,"definition":"sub","name":"DESTROY","containerName":"main::","range":{"start":{"character":0,"line":1279},"end":{"line":1282,"character":9999}}},{"line":1284,"children":[{"kind":13,"line":1285,"name":"$class","definition":"my","containerName":"TIEHANDLE","localvar":"my"},{"line":1285,"kind":13,"name":"$val","containerName":"TIEHANDLE"},{"line":1286,"kind":13,"name":"$val","containerName":"TIEHANDLE"},{"containerName":"TIEHANDLE","name":"$class","line":1286,"kind":13}],"kind":12,"detail":"($class,$val)","signature":{"documentation":"","parameters":[{"label":"$class"},{"label":"$val"}],"label":"TIEHANDLE($class,$val)"},"containerName":"main::","definition":"sub","range":{"end":{"character":9999,"line":1287},"start":{"character":0,"line":1284}},"name":"TIEHANDLE"},{"kind":12,"children":[{"kind":13,"line":1290,"containerName":"READLINE","name":"$self","definition":"my","localvar":"my"},{"line":1291,"kind":13,"name":"$self","containerName":"READLINE"},{"containerName":"READLINE","name":"next_feature","line":1291,"kind":12},{"line":1292,"kind":13,"localvar":"my","definition":"my","name":"@list","containerName":"READLINE"},{"name":"$obj","containerName":"READLINE","kind":13,"line":1292},{"name":"@list","containerName":"READLINE","kind":13,"line":1293},{"kind":13,"line":1293,"containerName":"READLINE","name":"$obj"},{"kind":13,"line":1293,"containerName":"READLINE","name":"$obj"},{"containerName":"READLINE","name":"$self","kind":13,"line":1293},{"name":"next_feature","containerName":"READLINE","kind":12,"line":1293},{"line":1294,"kind":13,"name":"@list","containerName":"READLINE"}],"line":1289,"definition":"sub","name":"READLINE","containerName":"main::","range":{"end":{"line":1295,"character":9999},"start":{"line":1289,"character":0}}},{"line":1297,"children":[{"containerName":"PRINT","definition":"my","name":"$self","localvar":"my","kind":13,"line":1298},{"name":"$self","containerName":"PRINT","kind":13,"line":1299},{"name":"write_feature","containerName":"PRINT","line":1299,"kind":12}],"kind":12,"range":{"end":{"line":1300,"character":9999},"start":{"character":0,"line":1297}},"containerName":"main::","name":"PRINT","definition":"sub"}],"version":5}