{"vars":[{"containerName":"","name":"base","line":113,"kind":2},{"localvar":"my","definition":"my","name":"%ExonTags","containerName":null,"line":115,"kind":13},{"kind":12,"line":120,"children":[{"localvar":"my","containerName":"_initialize_state","name":"$self","definition":"my","line":121,"kind":13},{"containerName":"_initialize_state","name":"@args","kind":13,"line":121},{"kind":13,"line":124,"name":"$self","containerName":"_initialize_state"},{"kind":13,"line":124,"containerName":"_initialize_state","name":"@args"},{"kind":13,"line":127,"name":"$self","containerName":"_initialize_state"},{"kind":13,"line":128,"name":"$self","containerName":"_initialize_state"},{"containerName":"_initialize_state","name":"$self","kind":13,"line":130},{"line":132,"kind":13,"containerName":"_initialize_state","name":"$self"}],"containerName":"main::","definition":"sub","detail":"($self,@args)","signature":{"label":"_initialize_state($self,@args)","documentation":"","parameters":[{"label":"$self"},{"label":"@args"}]},"name":"_initialize_state","range":{"end":{"line":133,"character":9999},"start":{"character":0,"line":120}}},{"line":124,"kind":12,"name":"SUPER","containerName":"_initialize_state"},{"kind":12,"children":[{"kind":13,"line":148,"containerName":"analysis_method","name":"$self","definition":"my","localvar":"my"},{"kind":13,"line":148,"containerName":"analysis_method","name":"$method"},{"line":149,"kind":13,"name":"$method","containerName":"analysis_method"},{"name":"$method","containerName":"analysis_method","kind":13,"line":149},{"name":"$self","containerName":"analysis_method","line":150,"kind":13},{"name":"throw","containerName":"analysis_method","kind":12,"line":150},{"name":"$self","containerName":"analysis_method","line":150,"kind":13},{"name":"$self","containerName":"analysis_method","line":152,"kind":13},{"name":"$method","containerName":"analysis_method","kind":13,"line":152}],"line":146,"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"$method"}],"documentation":"1;\n# $Id: Fgenesh.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Fgenesh\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christopher Dwan (chris@dwan.org)\n#\n# Copied, lock stock & barrel from Genscan.pm\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Fgenesh - parse results of one Fgenesh run\n\n=head1 SYNOPSIS\n\n   use Bio::Tools::Fgenesh;\n\n   $fgenesh = Bio::Tools::Fgenesh->new(-file => 'result.fgenesh');\n   # filehandle:\n   $fgenesh = Bio::Tools::Fgenesh->new( -fh  => \\*INPUT );\n\n   # parse the results\n   # note: this class is-a Bio::Tools::AnalysisResult which implements\n   # Bio::SeqAnalysisParserI, i.e., $fgensh->next_feature() is the same\n   while($gene = $fgenesh->next_prediction()) {\n       # $gene is an instance of Bio::Tools::Prediction::Gene, which inherits\n       # off Bio::SeqFeature::Gene::Transcript.\n       #\n       # $gene->exons() returns an array of \n       # Bio::Tools::Prediction::Exon objects\n       # all exons:\n       @exon_arr = $gene->exons();\n\n       # initial exons only\n       @init_exons = $gene->exons('Initial');\n       # internal exons only\n       @intrl_exons = $gene->exons('Internal');\n       # terminal exons only\n       @term_exons = $gene->exons('Terminal');\n       # singleton exons: \n       ($single_exon) = $gene->exons();\n   }\n\n   # essential if you gave a filename at initialization (otherwise the file\n   # will stay open)\n   $fgenesh->close();\n\n=head1 DESCRIPTION\n\nThe Fgenesh module provides a parser for Fgenesh (version 2) gene structure \nprediction output. It parses one gene prediction into a \nBio::SeqFeature::Gene::Transcript- derived object.\n\nThis module also implements the L<Bio::SeqAnalysisParserI> interface, and thus\ncan be used wherever such an object fits. \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Dwan\n\nEmail chris-at-dwan.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Fgenesh;\nuse strict;\nuse Symbol;\n\nuse Bio::Root::Root;\nuse Bio::Tools::Prediction::Gene;\nuse Bio::Tools::Prediction::Exon;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\nmy %ExonTags = ('CDSf' => 'Initial',\n\t\t'CDSi' => 'Internal',\n\t\t'CDSl' => 'Terminal',\n\t\t'CDSo' => 'Singleton');\n    \nsub _initialize_state {\n    my ($self,@args) = @_;\n    \n    # first call the inherited method!\n    $self->SUPER::_initialize_state(@args);\n\n    # our private state variables\n    $self->{'_preds_parsed'} = 0;\n    $self->{'_has_cds'} = 0;\n    # array of pre-parsed predictions\n    $self->{'_preds'} = [];\n    # seq stack\n    $self->{'_seqstack'} = [];\n}\n\n=head2 analysis_method\n\n Usage     : $genscan->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /genscan/i.\n Returns   : String\n Argument  : n/a","label":"analysis_method($self,$method)"},"detail":"($self,$method)","name":"analysis_method","range":{"start":{"character":0,"line":146},"end":{"line":153,"character":9999}}},{"name":"SUPER","containerName":"analysis_method","line":152,"kind":12},{"detail":"($self,@args)","signature":{"label":"next_feature($self,@args)","documentation":"1;\n# $Id: Fgenesh.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Fgenesh\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christopher Dwan (chris@dwan.org)\n#\n# Copied, lock stock & barrel from Genscan.pm\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Fgenesh - parse results of one Fgenesh run\n\n=head1 SYNOPSIS\n\n   use Bio::Tools::Fgenesh;\n\n   $fgenesh = Bio::Tools::Fgenesh->new(-file => 'result.fgenesh');\n   # filehandle:\n   $fgenesh = Bio::Tools::Fgenesh->new( -fh  => \\*INPUT );\n\n   # parse the results\n   # note: this class is-a Bio::Tools::AnalysisResult which implements\n   # Bio::SeqAnalysisParserI, i.e., $fgensh->next_feature() is the same\n   while($gene = $fgenesh->next_prediction()) {\n       # $gene is an instance of Bio::Tools::Prediction::Gene, which inherits\n       # off Bio::SeqFeature::Gene::Transcript.\n       #\n       # $gene->exons() returns an array of \n       # Bio::Tools::Prediction::Exon objects\n       # all exons:\n       @exon_arr = $gene->exons();\n\n       # initial exons only\n       @init_exons = $gene->exons('Initial');\n       # internal exons only\n       @intrl_exons = $gene->exons('Internal');\n       # terminal exons only\n       @term_exons = $gene->exons('Terminal');\n       # singleton exons: \n       ($single_exon) = $gene->exons();\n   }\n\n   # essential if you gave a filename at initialization (otherwise the file\n   # will stay open)\n   $fgenesh->close();\n\n=head1 DESCRIPTION\n\nThe Fgenesh module provides a parser for Fgenesh (version 2) gene structure \nprediction output. It parses one gene prediction into a \nBio::SeqFeature::Gene::Transcript- derived object.\n\nThis module also implements the L<Bio::SeqAnalysisParserI> interface, and thus\ncan be used wherever such an object fits. \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Dwan\n\nEmail chris-at-dwan.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Fgenesh;\nuse strict;\nuse Symbol;\n\nuse Bio::Root::Root;\nuse Bio::Tools::Prediction::Gene;\nuse Bio::Tools::Prediction::Exon;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\nmy %ExonTags = ('CDSf' => 'Initial',\n\t\t'CDSi' => 'Internal',\n\t\t'CDSl' => 'Terminal',\n\t\t'CDSo' => 'Singleton');\n    \nsub _initialize_state {\n    my ($self,@args) = @_;\n    \n    # first call the inherited method!\n    $self->SUPER::_initialize_state(@args);\n\n    # our private state variables\n    $self->{'_preds_parsed'} = 0;\n    $self->{'_has_cds'} = 0;\n    # array of pre-parsed predictions\n    $self->{'_preds'} = [];\n    # seq stack\n    $self->{'_seqstack'} = [];\n}\n\n=head2 analysis_method\n\n Usage     : $genscan->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /genscan/i.\n Returns   : String\n Argument  : n/a\n\n\n#-------------\nsub analysis_method { \n#-------------\n    my ($self, $method) = @_;  \n    if($method && ($method !~ /fgenesh/i)) {\n\t$self->throw(\"method $method not supported in \" . ref($self));\n    }\n    return $self->SUPER::analysis_method($method);\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : while($gene = $fgenesh->next_feature()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the Fgenesh result\n           file. Call this method repeatedly until FALSE is returned.\n\n           The returned object is actually a SeqFeatureI implementing object.\n           This method is required for classes implementing the\n           SeqAnalysisParserI interface, and is merely an alias for \n           next_prediction() at present.\n\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :","parameters":[{"label":"$self"},{"label":"@args"}]},"containerName":"main::","definition":"sub","line":175,"children":[{"kind":13,"line":176,"name":"$self","definition":"my","containerName":"next_feature","localvar":"my"},{"containerName":"next_feature","name":"@args","kind":13,"line":176},{"name":"$self","containerName":"next_feature","line":180,"kind":13},{"kind":12,"line":180,"containerName":"next_feature","name":"next_prediction"},{"kind":13,"line":180,"name":"@args","containerName":"next_feature"}],"kind":12,"range":{"end":{"line":181,"character":9999},"start":{"character":0,"line":175}},"name":"next_feature"},{"line":195,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"next_prediction","line":196,"kind":13},{"name":"$gene","definition":"my","containerName":"next_prediction","localvar":"my","kind":13,"line":197},{"kind":13,"line":200,"name":"$self","containerName":"next_prediction"},{"containerName":"next_prediction","name":"_parse_predictions","line":200,"kind":12},{"line":200,"kind":13,"containerName":"next_prediction","name":"$self"},{"line":200,"kind":12,"containerName":"next_prediction","name":"_predictions_parsed"},{"name":"$gene","containerName":"next_prediction","line":203,"kind":13},{"containerName":"next_prediction","name":"$self","kind":13,"line":203},{"name":"_prediction","containerName":"next_prediction","kind":12,"line":203},{"kind":13,"line":205,"name":"$gene","containerName":"next_prediction"},{"line":210,"kind":13,"localvar":"my","definition":"my","name":"$seqobj","containerName":"next_prediction"},{"kind":13,"line":210,"name":"$self","containerName":"next_prediction"},{"containerName":"next_prediction","definition":"my","name":"$id","localvar":"my","kind":13,"line":211},{"name":"$seq","containerName":"next_prediction","kind":13,"line":211},{"containerName":"next_prediction","name":"$seqobj","line":212,"kind":13},{"containerName":"next_prediction","name":"$id","line":213,"kind":13},{"line":213,"kind":13,"name":"$seq","containerName":"next_prediction"},{"containerName":"next_prediction","name":"$self","kind":13,"line":213},{"containerName":"next_prediction","name":"_read_fasta_seq","kind":12,"line":213},{"kind":13,"line":214,"containerName":"next_prediction","definition":"my","name":"$alphabet","localvar":"my"},{"name":"$id","containerName":"next_prediction","line":215,"kind":13},{"name":"$id","containerName":"next_prediction","line":215,"kind":13},{"line":215,"kind":13,"name":"$alphabet","containerName":"next_prediction"},{"line":216,"kind":13,"name":"$alphabet","containerName":"next_prediction"},{"containerName":"next_prediction","name":"$seqobj","kind":13,"line":217},{"kind":12,"line":217,"name":"new","containerName":"next_prediction"},{"line":217,"kind":13,"containerName":"next_prediction","name":"$seq"},{"containerName":"next_prediction","name":"$id","kind":13,"line":218},{"line":219,"kind":13,"name":"$alphabet","containerName":"next_prediction"},{"name":"$seqobj","containerName":"next_prediction","line":221,"kind":13},{"name":"$gene","containerName":"next_prediction","line":228,"kind":13},{"kind":12,"line":228,"name":"primary_tag","containerName":"next_prediction"},{"kind":13,"line":229,"name":"$prednr","definition":"my","containerName":"next_prediction","localvar":"my"},{"kind":13,"line":230,"containerName":"next_prediction","name":"$id"},{"kind":13,"line":232,"containerName":"next_prediction","name":"$self"},{"name":"$seqobj","containerName":"next_prediction","line":232,"kind":13},{"line":235,"kind":13,"containerName":"next_prediction","name":"$gene"},{"kind":12,"line":235,"containerName":"next_prediction","name":"predicted_protein"},{"line":235,"kind":13,"name":"$seqobj","containerName":"next_prediction"},{"name":"$self","containerName":"next_prediction","kind":13,"line":237},{"line":237,"kind":12,"name":"_has_cds","containerName":"next_prediction"},{"containerName":"next_prediction","name":"$gene","line":238,"kind":13},{"name":"predicted_cds","containerName":"next_prediction","line":238,"kind":12},{"containerName":"next_prediction","name":"$seqobj","line":238,"kind":13},{"name":"$id","containerName":"next_prediction","kind":13,"line":241},{"line":241,"kind":13,"containerName":"next_prediction","name":"$seq"},{"containerName":"next_prediction","name":"$self","kind":13,"line":241},{"name":"_read_fasta_seq","containerName":"next_prediction","line":241,"kind":12},{"kind":13,"line":242,"containerName":"next_prediction","name":"$id"},{"line":243,"kind":13,"name":"$id","containerName":"next_prediction"},{"kind":13,"line":243,"containerName":"next_prediction","name":"$seq"},{"line":243,"kind":13,"containerName":"next_prediction","name":"$self"},{"name":"_read_fasta_seq","containerName":"next_prediction","line":243,"kind":12},{"line":246,"kind":13,"name":"$seqobj","containerName":"next_prediction"},{"name":"new","containerName":"next_prediction","kind":12,"line":246},{"kind":13,"line":246,"name":"$seq","containerName":"next_prediction"},{"line":247,"kind":13,"containerName":"next_prediction","name":"$id"},{"name":"$gene","containerName":"next_prediction","line":249,"kind":13},{"name":"predicted_protein","containerName":"next_prediction","line":249,"kind":12},{"containerName":"next_prediction","name":"$seqobj","kind":13,"line":249}],"kind":12,"detail":"($self)","signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Fgenesh.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Fgenesh\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christopher Dwan (chris@dwan.org)\n#\n# Copied, lock stock & barrel from Genscan.pm\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Fgenesh - parse results of one Fgenesh run\n\n=head1 SYNOPSIS\n\n   use Bio::Tools::Fgenesh;\n\n   $fgenesh = Bio::Tools::Fgenesh->new(-file => 'result.fgenesh');\n   # filehandle:\n   $fgenesh = Bio::Tools::Fgenesh->new( -fh  => \\*INPUT );\n\n   # parse the results\n   # note: this class is-a Bio::Tools::AnalysisResult which implements\n   # Bio::SeqAnalysisParserI, i.e., $fgensh->next_feature() is the same\n   while($gene = $fgenesh->next_prediction()) {\n       # $gene is an instance of Bio::Tools::Prediction::Gene, which inherits\n       # off Bio::SeqFeature::Gene::Transcript.\n       #\n       # $gene->exons() returns an array of \n       # Bio::Tools::Prediction::Exon objects\n       # all exons:\n       @exon_arr = $gene->exons();\n\n       # initial exons only\n       @init_exons = $gene->exons('Initial');\n       # internal exons only\n       @intrl_exons = $gene->exons('Internal');\n       # terminal exons only\n       @term_exons = $gene->exons('Terminal');\n       # singleton exons: \n       ($single_exon) = $gene->exons();\n   }\n\n   # essential if you gave a filename at initialization (otherwise the file\n   # will stay open)\n   $fgenesh->close();\n\n=head1 DESCRIPTION\n\nThe Fgenesh module provides a parser for Fgenesh (version 2) gene structure \nprediction output. It parses one gene prediction into a \nBio::SeqFeature::Gene::Transcript- derived object.\n\nThis module also implements the L<Bio::SeqAnalysisParserI> interface, and thus\ncan be used wherever such an object fits. \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Dwan\n\nEmail chris-at-dwan.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Fgenesh;\nuse strict;\nuse Symbol;\n\nuse Bio::Root::Root;\nuse Bio::Tools::Prediction::Gene;\nuse Bio::Tools::Prediction::Exon;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\nmy %ExonTags = ('CDSf' => 'Initial',\n\t\t'CDSi' => 'Internal',\n\t\t'CDSl' => 'Terminal',\n\t\t'CDSo' => 'Singleton');\n    \nsub _initialize_state {\n    my ($self,@args) = @_;\n    \n    # first call the inherited method!\n    $self->SUPER::_initialize_state(@args);\n\n    # our private state variables\n    $self->{'_preds_parsed'} = 0;\n    $self->{'_has_cds'} = 0;\n    # array of pre-parsed predictions\n    $self->{'_preds'} = [];\n    # seq stack\n    $self->{'_seqstack'} = [];\n}\n\n=head2 analysis_method\n\n Usage     : $genscan->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /genscan/i.\n Returns   : String\n Argument  : n/a\n\n\n#-------------\nsub analysis_method { \n#-------------\n    my ($self, $method) = @_;  \n    if($method && ($method !~ /fgenesh/i)) {\n\t$self->throw(\"method $method not supported in \" . ref($self));\n    }\n    return $self->SUPER::analysis_method($method);\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : while($gene = $fgenesh->next_feature()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the Fgenesh result\n           file. Call this method repeatedly until FALSE is returned.\n\n           The returned object is actually a SeqFeatureI implementing object.\n           This method is required for classes implementing the\n           SeqAnalysisParserI interface, and is merely an alias for \n           next_prediction() at present.\n\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :\n\n\nsub next_feature {\n    my ($self,@args) = @_;\n    # even though next_prediction doesn't expect any args (and this method\n    # does neither), we pass on args in order to be prepared if this changes\n    # ever\n    return $self->next_prediction(@args);\n}\n\n=head2 next_prediction\n\n Title   : next_prediction\n Usage   : while($gene = $fgenesh->next_prediction()) { ... }\n Function: Returns the next gene structure prediction of the Genscan result\n           file. Call this method repeatedly until FALSE is returned.\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :","label":"next_prediction($self)"},"containerName":"main::","definition":"sub","range":{"start":{"character":0,"line":195},"end":{"character":9999,"line":252}},"name":"next_prediction"},{"line":217,"kind":12,"containerName":"PrimarySeq","name":"Bio"},{"name":"Bio","containerName":"PrimarySeq","line":246,"kind":12},{"containerName":null,"name":"$gene","line":255,"kind":13},{"range":{"end":{"line":409,"character":9999},"start":{"line":269,"character":0}},"name":"_parse_predictions","children":[{"localvar":"my","name":"$self","definition":"my","containerName":"_parse_predictions","line":270,"kind":13},{"line":271,"kind":13,"localvar":"my","containerName":"_parse_predictions","name":"$gene","definition":"my"},{"kind":13,"line":272,"containerName":"_parse_predictions","definition":"my","name":"$seqname","localvar":"my"},{"containerName":"_parse_predictions","name":"$self","kind":13,"line":274},{"line":274,"kind":12,"name":"_readline","containerName":"_parse_predictions"},{"localvar":"my","containerName":"_parse_predictions","name":"$line","definition":"my","line":277,"kind":13},{"localvar":"my","containerName":"_parse_predictions","name":"$prednr","definition":"my","line":280,"kind":13},{"localvar":"my","containerName":"_parse_predictions","name":"$strand","definition":"my","line":281,"kind":13},{"containerName":"_parse_predictions","name":"$gene","kind":13,"line":283},{"line":284,"kind":13,"name":"$gene","containerName":"_parse_predictions"},{"line":284,"kind":12,"name":"new","containerName":"_parse_predictions"},{"kind":13,"line":290,"definition":"my","name":"@flds","containerName":"_parse_predictions","localvar":"my"},{"line":290,"kind":13,"containerName":"_parse_predictions","name":"$line"},{"containerName":"_parse_predictions","name":"$predobj","definition":"my","localvar":"my","kind":13,"line":297},{"kind":13,"line":298,"containerName":"_parse_predictions","name":"$is_exon","definition":"my","localvar":"my"},{"line":298,"kind":13,"name":"$line","containerName":"_parse_predictions"},{"line":298,"kind":13,"name":"%ExonTags","containerName":"_parse_predictions"},{"kind":13,"line":299,"definition":"my","name":"$start","containerName":"_parse_predictions","localvar":"my"},{"line":299,"kind":13,"containerName":"_parse_predictions","name":"$end"},{"name":"$is_exon","containerName":"_parse_predictions","kind":13,"line":300},{"name":"$predobj","containerName":"_parse_predictions","line":301,"kind":13},{"containerName":"_parse_predictions","name":"new","kind":12,"line":301},{"kind":13,"line":302,"name":"$predobj","containerName":"_parse_predictions"},{"line":302,"kind":12,"name":"score","containerName":"_parse_predictions"},{"containerName":"_parse_predictions","name":"$flds","line":302,"kind":13},{"containerName":"_parse_predictions","name":"$start","line":303,"kind":13},{"name":"$flds","containerName":"_parse_predictions","kind":13,"line":303},{"line":304,"kind":13,"containerName":"_parse_predictions","name":"$end"},{"containerName":"_parse_predictions","name":"$flds","line":304,"kind":13},{"kind":13,"line":307,"containerName":"_parse_predictions","name":"$predobj"},{"line":307,"kind":12,"name":"new","containerName":"_parse_predictions"},{"containerName":"_parse_predictions","name":"$predobj","line":308,"kind":13},{"containerName":"_parse_predictions","name":"score","kind":12,"line":308},{"line":308,"kind":13,"containerName":"_parse_predictions","name":"$flds"},{"kind":13,"line":309,"name":"$start","containerName":"_parse_predictions"},{"kind":13,"line":309,"name":"$flds","containerName":"_parse_predictions"},{"name":"$end","containerName":"_parse_predictions","line":310,"kind":13},{"line":310,"kind":13,"name":"$flds","containerName":"_parse_predictions"},{"name":"$predobj","containerName":"_parse_predictions","kind":13,"line":313},{"line":313,"kind":12,"name":"source_tag","containerName":"_parse_predictions"},{"line":314,"kind":13,"name":"$predobj","containerName":"_parse_predictions"},{"name":"strand","containerName":"_parse_predictions","kind":12,"line":314},{"line":314,"kind":13,"containerName":"_parse_predictions","name":"$strand"},{"line":323,"kind":13,"containerName":"_parse_predictions","name":"$predobj"},{"kind":12,"line":323,"name":"start","containerName":"_parse_predictions"},{"name":"$start","containerName":"_parse_predictions","kind":13,"line":323},{"containerName":"_parse_predictions","name":"$predobj","line":324,"kind":13},{"containerName":"_parse_predictions","name":"end","line":324,"kind":12},{"containerName":"_parse_predictions","name":"$end","line":324,"kind":13},{"name":"$is_exon","containerName":"_parse_predictions","kind":13,"line":333},{"containerName":"_parse_predictions","name":"$predobj","kind":13,"line":335},{"kind":12,"line":335,"containerName":"_parse_predictions","name":"primary_tag"},{"kind":13,"line":335,"name":"$ExonTags","containerName":"_parse_predictions"},{"line":335,"kind":13,"name":"$flds","containerName":"_parse_predictions"},{"name":"$predobj","containerName":"_parse_predictions","kind":13,"line":336},{"kind":12,"line":336,"name":"is_coding","containerName":"_parse_predictions"},{"containerName":"_parse_predictions","name":"$cod_offset","definition":"my","localvar":"my","kind":13,"line":337},{"line":338,"kind":13,"containerName":"_parse_predictions","name":"$predobj"},{"name":"strand","containerName":"_parse_predictions","line":338,"kind":12},{"kind":13,"line":339,"containerName":"_parse_predictions","name":"$cod_offset"},{"containerName":"_parse_predictions","name":"$flds","kind":13,"line":339},{"kind":13,"line":339,"containerName":"_parse_predictions","name":"$predobj"},{"containerName":"_parse_predictions","name":"start","kind":12,"line":339},{"name":"$cod_offset","containerName":"_parse_predictions","kind":13,"line":342},{"name":"$cod_offset","containerName":"_parse_predictions","line":342,"kind":13},{"kind":13,"line":348,"containerName":"_parse_predictions","name":"$cod_offset"},{"kind":13,"line":348,"name":"$flds","containerName":"_parse_predictions"},{"line":348,"kind":13,"containerName":"_parse_predictions","name":"$predobj"},{"containerName":"_parse_predictions","name":"end","kind":12,"line":348},{"containerName":"_parse_predictions","name":"$cod_offset","line":352,"kind":13},{"line":352,"kind":13,"name":"$cod_offset","containerName":"_parse_predictions"},{"kind":13,"line":353,"name":"$cod_offset","containerName":"_parse_predictions"},{"name":"$cod_offset","containerName":"_parse_predictions","line":353,"kind":13},{"containerName":"_parse_predictions","name":"$predobj","kind":13,"line":358},{"containerName":"_parse_predictions","name":"frame","line":358,"kind":12},{"containerName":"_parse_predictions","name":"$cod_offset","kind":13,"line":358},{"name":"$gene","containerName":"_parse_predictions","line":361,"kind":13},{"line":361,"kind":12,"name":"add_exon","containerName":"_parse_predictions"},{"line":361,"kind":13,"name":"$predobj","containerName":"_parse_predictions"},{"line":361,"kind":13,"name":"$ExonTags","containerName":"_parse_predictions"},{"kind":13,"line":361,"name":"$flds","containerName":"_parse_predictions"},{"kind":13,"line":362,"name":"$flds","containerName":"_parse_predictions"},{"name":"$predobj","containerName":"_parse_predictions","line":363,"kind":13},{"kind":12,"line":363,"containerName":"_parse_predictions","name":"primary_tag"},{"kind":13,"line":364,"containerName":"_parse_predictions","name":"$gene"},{"line":364,"kind":12,"name":"poly_A_site","containerName":"_parse_predictions"},{"containerName":"_parse_predictions","name":"$predobj","line":364,"kind":13},{"name":"$flds","containerName":"_parse_predictions","kind":13,"line":365},{"kind":13,"line":366,"containerName":"_parse_predictions","name":"$predobj"},{"name":"primary_tag","containerName":"_parse_predictions","kind":12,"line":366},{"kind":13,"line":367,"containerName":"_parse_predictions","name":"$gene"},{"name":"add_promoter","containerName":"_parse_predictions","kind":12,"line":367},{"containerName":"_parse_predictions","name":"$predobj","line":367,"kind":13},{"name":"$self","containerName":"_parse_predictions","line":374,"kind":13},{"containerName":"_parse_predictions","name":"throw","kind":12,"line":374},{"kind":13,"line":374,"containerName":"_parse_predictions","name":"$line"},{"kind":13,"line":379,"name":"$gene","containerName":"_parse_predictions"},{"line":381,"kind":13,"containerName":"_parse_predictions","name":"$gene"},{"line":381,"kind":12,"containerName":"_parse_predictions","name":"seq_id"},{"name":"$seqname","containerName":"_parse_predictions","line":381,"kind":13},{"name":"$self","containerName":"_parse_predictions","kind":13,"line":382},{"name":"_add_prediction","containerName":"_parse_predictions","line":382,"kind":12},{"name":"$gene","containerName":"_parse_predictions","kind":13,"line":382},{"containerName":"_parse_predictions","name":"$gene","line":383,"kind":13},{"containerName":"_parse_predictions","name":"$self","kind":13,"line":388},{"containerName":"_parse_predictions","name":"analysis_method","kind":12,"line":388},{"name":"$self","containerName":"_parse_predictions","line":389,"kind":13},{"kind":12,"line":389,"name":"analysis_method_version","containerName":"_parse_predictions"},{"kind":13,"line":391,"name":"$self","containerName":"_parse_predictions"},{"line":391,"kind":12,"containerName":"_parse_predictions","name":"analysis_subject"},{"line":397,"kind":13,"name":"$seqname","containerName":"_parse_predictions"},{"line":403,"kind":13,"name":"$self","containerName":"_parse_predictions"},{"containerName":"_parse_predictions","name":"_pushback","kind":12,"line":403},{"name":"$self","containerName":"_parse_predictions","kind":13,"line":408},{"containerName":"_parse_predictions","name":"_predictions_parsed","kind":12,"line":408}],"line":269,"kind":12,"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Fgenesh.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Fgenesh\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christopher Dwan (chris@dwan.org)\n#\n# Copied, lock stock & barrel from Genscan.pm\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Fgenesh - parse results of one Fgenesh run\n\n=head1 SYNOPSIS\n\n   use Bio::Tools::Fgenesh;\n\n   $fgenesh = Bio::Tools::Fgenesh->new(-file => 'result.fgenesh');\n   # filehandle:\n   $fgenesh = Bio::Tools::Fgenesh->new( -fh  => \\*INPUT );\n\n   # parse the results\n   # note: this class is-a Bio::Tools::AnalysisResult which implements\n   # Bio::SeqAnalysisParserI, i.e., $fgensh->next_feature() is the same\n   while($gene = $fgenesh->next_prediction()) {\n       # $gene is an instance of Bio::Tools::Prediction::Gene, which inherits\n       # off Bio::SeqFeature::Gene::Transcript.\n       #\n       # $gene->exons() returns an array of \n       # Bio::Tools::Prediction::Exon objects\n       # all exons:\n       @exon_arr = $gene->exons();\n\n       # initial exons only\n       @init_exons = $gene->exons('Initial');\n       # internal exons only\n       @intrl_exons = $gene->exons('Internal');\n       # terminal exons only\n       @term_exons = $gene->exons('Terminal');\n       # singleton exons: \n       ($single_exon) = $gene->exons();\n   }\n\n   # essential if you gave a filename at initialization (otherwise the file\n   # will stay open)\n   $fgenesh->close();\n\n=head1 DESCRIPTION\n\nThe Fgenesh module provides a parser for Fgenesh (version 2) gene structure \nprediction output. It parses one gene prediction into a \nBio::SeqFeature::Gene::Transcript- derived object.\n\nThis module also implements the L<Bio::SeqAnalysisParserI> interface, and thus\ncan be used wherever such an object fits. \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Dwan\n\nEmail chris-at-dwan.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Fgenesh;\nuse strict;\nuse Symbol;\n\nuse Bio::Root::Root;\nuse Bio::Tools::Prediction::Gene;\nuse Bio::Tools::Prediction::Exon;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\nmy %ExonTags = ('CDSf' => 'Initial',\n\t\t'CDSi' => 'Internal',\n\t\t'CDSl' => 'Terminal',\n\t\t'CDSo' => 'Singleton');\n    \nsub _initialize_state {\n    my ($self,@args) = @_;\n    \n    # first call the inherited method!\n    $self->SUPER::_initialize_state(@args);\n\n    # our private state variables\n    $self->{'_preds_parsed'} = 0;\n    $self->{'_has_cds'} = 0;\n    # array of pre-parsed predictions\n    $self->{'_preds'} = [];\n    # seq stack\n    $self->{'_seqstack'} = [];\n}\n\n=head2 analysis_method\n\n Usage     : $genscan->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /genscan/i.\n Returns   : String\n Argument  : n/a\n\n\n#-------------\nsub analysis_method { \n#-------------\n    my ($self, $method) = @_;  \n    if($method && ($method !~ /fgenesh/i)) {\n\t$self->throw(\"method $method not supported in \" . ref($self));\n    }\n    return $self->SUPER::analysis_method($method);\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : while($gene = $fgenesh->next_feature()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the Fgenesh result\n           file. Call this method repeatedly until FALSE is returned.\n\n           The returned object is actually a SeqFeatureI implementing object.\n           This method is required for classes implementing the\n           SeqAnalysisParserI interface, and is merely an alias for \n           next_prediction() at present.\n\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :\n\n\nsub next_feature {\n    my ($self,@args) = @_;\n    # even though next_prediction doesn't expect any args (and this method\n    # does neither), we pass on args in order to be prepared if this changes\n    # ever\n    return $self->next_prediction(@args);\n}\n\n=head2 next_prediction\n\n Title   : next_prediction\n Usage   : while($gene = $fgenesh->next_prediction()) { ... }\n Function: Returns the next gene structure prediction of the Genscan result\n           file. Call this method repeatedly until FALSE is returned.\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :\n\n\nsub next_prediction {\n    my ($self) = @_;\n    my $gene;\n\n    # if the prediction section hasn't been parsed yet, we do this now\n    $self->_parse_predictions() unless $self->_predictions_parsed();\n\n    # get next gene structure\n    $gene = $self->_prediction();\n\n    if($gene) {\n\t# fill in predicted protein, and if available the predicted CDS\n\t#\n\n\t# use the seq stack if there's a seq on it\n\tmy $seqobj = pop(@{$self->{'_seqstack'}});\n        my ($id, $seq);\n\tunless ($seqobj) {\n\t   ($id, $seq) = $self->_read_fasta_seq();\n           my $alphabet;\n           if (($id =~ /mrna/) || ($id =~ /cds/)) { $alphabet = 'dna'; }\n           else { $alphabet = 'protein'; }\n           $seqobj = Bio::PrimarySeq->new('-seq'        => $seq,\n                                          '-display_id' => $id,\n                                          '-alphabet'   => $alphabet); \n        }\n\tif ($seqobj) {\n\n\t    # check that prediction number matches the prediction number\n\t    # indicated in the sequence id (there may be incomplete gene\n\t    # predictions that contain only signals with no associated protein\n            # prediction.\n\n\t    $gene->primary_tag() =~ /[^0-9]([0-9]+)$/;\n\t    my $prednr = $1;\n\t    if ($id !~ /_predicted_(\\w+)_$prednr/) {\n\t\t# this is not our sequence, so push back for next prediction\n\t\tpush(@{$self->{'_seqstack'}}, $seqobj);\n\t    } else {\n                if ($1 eq \"protein\") {\n\t\t  $gene->predicted_protein($seqobj);\n                } elsif (($1 eq \"mrna\") || ($1 eq \"cds\")) {\n                  $self->_has_cds(1);\n                  $gene->predicted_cds($seqobj);\n                  \n                  # Have to go back in and get the protein...\n                  ($id, $seq) = $self->_read_fasta_seq();\n                  if ($id =~ /_cds_/) { \n                    ($id, $seq) = $self->_read_fasta_seq(); \n                  }\n \n\t\t  $seqobj = Bio::PrimarySeq->new('-seq' => $seq,\n\t\t\t    \t\t         '-display_id' => $id,\n\t\t\t\t\t\t '-alphabet' => \"protein\");\n\t\t  $gene->predicted_protein($seqobj);\n\t\t}\n\t    }\n\t}\n    }\n\n    return $gene;\n}\n\n=head2 _parse_predictions\n\n Title   : _parse_predictions()\n Usage   : $obj->_parse_predictions()\n Function: Parses the prediction section. Automatically called by\n           next_prediction() if not yet done.\n Example :\n Returns : ","label":"_parse_predictions($self)"},"detail":"($self)","definition":"sub","containerName":"main::"},{"name":"Bio","containerName":"Tools::Prediction::Gene","line":284,"kind":12},{"containerName":"Tools::Prediction::Exon","name":"Bio","kind":12,"line":301},{"containerName":"SeqFeature::Generic","name":"Bio","line":307,"kind":12},{"name":"Predicted","line":401,"kind":12},{"kind":12,"line":401,"name":"protein"},{"detail":"($self)","signature":{"label":"_prediction($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Fgenesh.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Fgenesh\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christopher Dwan (chris@dwan.org)\n#\n# Copied, lock stock & barrel from Genscan.pm\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Fgenesh - parse results of one Fgenesh run\n\n=head1 SYNOPSIS\n\n   use Bio::Tools::Fgenesh;\n\n   $fgenesh = Bio::Tools::Fgenesh->new(-file => 'result.fgenesh');\n   # filehandle:\n   $fgenesh = Bio::Tools::Fgenesh->new( -fh  => \\*INPUT );\n\n   # parse the results\n   # note: this class is-a Bio::Tools::AnalysisResult which implements\n   # Bio::SeqAnalysisParserI, i.e., $fgensh->next_feature() is the same\n   while($gene = $fgenesh->next_prediction()) {\n       # $gene is an instance of Bio::Tools::Prediction::Gene, which inherits\n       # off Bio::SeqFeature::Gene::Transcript.\n       #\n       # $gene->exons() returns an array of \n       # Bio::Tools::Prediction::Exon objects\n       # all exons:\n       @exon_arr = $gene->exons();\n\n       # initial exons only\n       @init_exons = $gene->exons('Initial');\n       # internal exons only\n       @intrl_exons = $gene->exons('Internal');\n       # terminal exons only\n       @term_exons = $gene->exons('Terminal');\n       # singleton exons: \n       ($single_exon) = $gene->exons();\n   }\n\n   # essential if you gave a filename at initialization (otherwise the file\n   # will stay open)\n   $fgenesh->close();\n\n=head1 DESCRIPTION\n\nThe Fgenesh module provides a parser for Fgenesh (version 2) gene structure \nprediction output. It parses one gene prediction into a \nBio::SeqFeature::Gene::Transcript- derived object.\n\nThis module also implements the L<Bio::SeqAnalysisParserI> interface, and thus\ncan be used wherever such an object fits. \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Dwan\n\nEmail chris-at-dwan.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Fgenesh;\nuse strict;\nuse Symbol;\n\nuse Bio::Root::Root;\nuse Bio::Tools::Prediction::Gene;\nuse Bio::Tools::Prediction::Exon;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\nmy %ExonTags = ('CDSf' => 'Initial',\n\t\t'CDSi' => 'Internal',\n\t\t'CDSl' => 'Terminal',\n\t\t'CDSo' => 'Singleton');\n    \nsub _initialize_state {\n    my ($self,@args) = @_;\n    \n    # first call the inherited method!\n    $self->SUPER::_initialize_state(@args);\n\n    # our private state variables\n    $self->{'_preds_parsed'} = 0;\n    $self->{'_has_cds'} = 0;\n    # array of pre-parsed predictions\n    $self->{'_preds'} = [];\n    # seq stack\n    $self->{'_seqstack'} = [];\n}\n\n=head2 analysis_method\n\n Usage     : $genscan->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /genscan/i.\n Returns   : String\n Argument  : n/a\n\n\n#-------------\nsub analysis_method { \n#-------------\n    my ($self, $method) = @_;  \n    if($method && ($method !~ /fgenesh/i)) {\n\t$self->throw(\"method $method not supported in \" . ref($self));\n    }\n    return $self->SUPER::analysis_method($method);\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : while($gene = $fgenesh->next_feature()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the Fgenesh result\n           file. Call this method repeatedly until FALSE is returned.\n\n           The returned object is actually a SeqFeatureI implementing object.\n           This method is required for classes implementing the\n           SeqAnalysisParserI interface, and is merely an alias for \n           next_prediction() at present.\n\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :\n\n\nsub next_feature {\n    my ($self,@args) = @_;\n    # even though next_prediction doesn't expect any args (and this method\n    # does neither), we pass on args in order to be prepared if this changes\n    # ever\n    return $self->next_prediction(@args);\n}\n\n=head2 next_prediction\n\n Title   : next_prediction\n Usage   : while($gene = $fgenesh->next_prediction()) { ... }\n Function: Returns the next gene structure prediction of the Genscan result\n           file. Call this method repeatedly until FALSE is returned.\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :\n\n\nsub next_prediction {\n    my ($self) = @_;\n    my $gene;\n\n    # if the prediction section hasn't been parsed yet, we do this now\n    $self->_parse_predictions() unless $self->_predictions_parsed();\n\n    # get next gene structure\n    $gene = $self->_prediction();\n\n    if($gene) {\n\t# fill in predicted protein, and if available the predicted CDS\n\t#\n\n\t# use the seq stack if there's a seq on it\n\tmy $seqobj = pop(@{$self->{'_seqstack'}});\n        my ($id, $seq);\n\tunless ($seqobj) {\n\t   ($id, $seq) = $self->_read_fasta_seq();\n           my $alphabet;\n           if (($id =~ /mrna/) || ($id =~ /cds/)) { $alphabet = 'dna'; }\n           else { $alphabet = 'protein'; }\n           $seqobj = Bio::PrimarySeq->new('-seq'        => $seq,\n                                          '-display_id' => $id,\n                                          '-alphabet'   => $alphabet); \n        }\n\tif ($seqobj) {\n\n\t    # check that prediction number matches the prediction number\n\t    # indicated in the sequence id (there may be incomplete gene\n\t    # predictions that contain only signals with no associated protein\n            # prediction.\n\n\t    $gene->primary_tag() =~ /[^0-9]([0-9]+)$/;\n\t    my $prednr = $1;\n\t    if ($id !~ /_predicted_(\\w+)_$prednr/) {\n\t\t# this is not our sequence, so push back for next prediction\n\t\tpush(@{$self->{'_seqstack'}}, $seqobj);\n\t    } else {\n                if ($1 eq \"protein\") {\n\t\t  $gene->predicted_protein($seqobj);\n                } elsif (($1 eq \"mrna\") || ($1 eq \"cds\")) {\n                  $self->_has_cds(1);\n                  $gene->predicted_cds($seqobj);\n                  \n                  # Have to go back in and get the protein...\n                  ($id, $seq) = $self->_read_fasta_seq();\n                  if ($id =~ /_cds_/) { \n                    ($id, $seq) = $self->_read_fasta_seq(); \n                  }\n \n\t\t  $seqobj = Bio::PrimarySeq->new('-seq' => $seq,\n\t\t\t    \t\t         '-display_id' => $id,\n\t\t\t\t\t\t '-alphabet' => \"protein\");\n\t\t  $gene->predicted_protein($seqobj);\n\t\t}\n\t    }\n\t}\n    }\n\n    return $gene;\n}\n\n=head2 _parse_predictions\n\n Title   : _parse_predictions()\n Usage   : $obj->_parse_predictions()\n Function: Parses the prediction section. Automatically called by\n           next_prediction() if not yet done.\n Example :\n Returns : \n\n\nsub _parse_predictions {\n    my ($self) = @_;\n    my $gene;\n    my $seqname;\n\n    while(defined($_ = $self->_readline())) {\n\n\tif(/^\\s*(\\d+)\\s+([+\\-])/) {\n            my $line = $_;\n\n\t    # exon or signal\n\t    my $prednr = $1;\n            my $strand = ($2 eq '+') ? 1 : -1;\n\n\t    if(! defined($gene)) {\n\t\t$gene = Bio::Tools::Prediction::Gene->new(\n                                       '-primary' => \"GenePrediction$prednr\",\n\t\t\t\t       '-source' => 'Fgenesh');\n\t    }\n\t    # split into fields\n\t    chomp();\n\t    my @flds = split(/\\s+/, ' ' . $line);\n\t    ## NB - the above adds leading whitespace before the gene\n\t    ## number in case there was none (as quick patch to code\n\t    ## below which expects it but it is not present after 999\n\t    ## predictions!) This allows >999 predictions to be parsed.\n\n\t    # create the feature object depending on the type of signal\n\t    my $predobj;\n\t    my $is_exon = grep {$line =~ $_} keys(%ExonTags);\n            my ($start, $end);\n\t    if($is_exon) {\n\t\t$predobj = Bio::Tools::Prediction::Exon->new();\n                $predobj->score($flds[8]);\n                $start   = $flds[5];\n                $end     = $flds[7];\n\t    } else {\n\t\t# PolyA site, or TSS \n\t\t$predobj = Bio::SeqFeature::Generic->new();\n                $predobj->score($flds[5]);\n                $start   = $flds[4];\n                $end     = $flds[4];\n\t    }\n\t    # set common fields\n\t    $predobj->source_tag('Fgenesh');\n\t    $predobj->strand($strand);\n\n# Following tactical commenting-out made by\n# malcolm.cook@stowers-institute.org since coordinate reversal is\n# apparently vestigial copy/paste detritus from Genscan.pm origins of\n# this module and this is NOT needed for fgenesh (at least in v\n# 2.1.4).\n\n#\t    if($predobj->strand() == 1) {\n\t\t$predobj->start($start);\n\t\t$predobj->end($end);\n#\t    } else {\n#\t\t$predobj->end($start);\n#\t\t$predobj->start($end);\n#\t    }\n\n            # print STDERR \"start $start end $end\\n\";\n\t    # add to gene structure (should be done only when start and end\n\t    # are set, in order to allow for proper expansion of the range)\n\t    if($is_exon) {\n\t\t# first, set fields unique to exons\n\t\t$predobj->primary_tag($ExonTags{$flds[4]} . 'Exon');\n\t\t$predobj->is_coding(1);\n\t\tmy $cod_offset;\n\t\tif($predobj->strand() == 1) {\n\t\t    $cod_offset = ($flds[9] - $predobj->start()) % 3;\n\t\t    # Possible values are -2, -1, 0, 1, 2. -1 and -2 correspond\n\t\t    # to offsets 2 and 1, resp. Offset 3 is the same as 0.\n\t\t    $cod_offset += 3 if($cod_offset < 1);\t\t    \n\t\t} else {\n\t\t    # On the reverse strand the Genscan frame also refers to\n\t\t    # the first base of the first complete codon, but viewed\n\t\t    # from forward, which is the third base viewed from\n\t\t    # reverse.\n\t\t    $cod_offset = ($flds[11] - $predobj->end()) % 3;\n\t\t    # Possible values are -2, -1, 0, 1, 2. Due to the reverse\n\t\t    # situation, {2,-1} and {1,-2} correspond to offsets\n\t\t    # 1 and 2, resp. Offset 3 is the same as 0.\n\t\t    $cod_offset -= 3 if($cod_offset >= 0);\n\t\t    $cod_offset = -$cod_offset;\n\t\t}\n\t\t# Offsets 2 and 1 correspond to frame 1 and 2 (frame of exon\n\t\t# is the frame of the first base relative to the exon, or the\n\t\t# number of bases the first codon is missing).\n\t\t$predobj->frame(3 - $cod_offset);\n                # print STDERR \"  frame is \" . $predobj->frame() . \"\\n\";\n\t\t# then add to gene structure object\n\t\t$gene->add_exon($predobj, $ExonTags{$flds[1]});\t\t\n\t    } elsif($flds[3] eq 'PolA') {\n\t\t$predobj->primary_tag(\"PolyAsite\");\n\t\t$gene->poly_A_site($predobj);\n\t    } elsif($flds[3] eq 'TSS') {\n\t        $predobj->primary_tag(\"Promoter\"); # (hey! a TSS is NOT a promoter... what's going on here?...\n\t\t$gene->add_promoter($predobj);\n                #I'd like to do this (for now):\n\t\t#$predobj->primary_tag(\"TSS\"); #this is not the right model, but, it IS a feature at least.\n                #but the followg errs out\n\t\t#$gene->add_SeqFeature($predobj); #err: MSG: start is undefined when bounds at Bio::SeqFeature::Generic::add_SeqFeature 671 check since gene has no start yet\n\t    }\n\t    else {\n\t      $self->throw(\"unrecognized prediction line: \" . $line);\n\t    }\n\t    next;\n\t}\n\n\tif(/^\\s*$/ && defined($gene)) {\n\t    # current gene is completed\n\t    $gene->seq_id($seqname);\n\t    $self->_add_prediction($gene);\n\t    $gene = undef;\n\t    next;\n\t}\n\n\tif(/^(FGENESH)\\s+([\\d\\.]+)/) {\n\t    $self->analysis_method($1);\n\t    $self->analysis_method_version($2);\n            if (/\\s(\\S+)\\sgenomic DNA/) {\n              $self->analysis_subject($1);\n            }\n\t    next;\n\t}\n\n\tif(/^\\s*Seq name:\\s+(\\S+)/) {\n\t    $seqname = $1;\n\t    next;\n\t}\n        \n\t/^Predicted protein/ && do {\n\t    # section of predicted sequences\n\t    $self->_pushback($_);\n\t    last;\n\t};\n    }\n\n    $self->_predictions_parsed(1);\n}\n\n=head2 _prediction\n\n Title   : _prediction()\n Usage   : $gene = $obj->_prediction()\n Function: internal\n Example :\n Returns : "},"containerName":"main::","definition":"sub","line":421,"children":[{"definition":"my","name":"$self","containerName":"_prediction","localvar":"my","kind":13,"line":422},{"line":424,"kind":13,"name":"$self","containerName":"_prediction"},{"name":"$self","containerName":"_prediction","line":424,"kind":13}],"kind":12,"range":{"end":{"line":424,"character":9999},"start":{"line":421,"character":0}},"name":"_prediction"},{"name":"%self","containerName":null,"kind":13,"line":425},{"range":{"end":{"line":444,"character":9999},"start":{"line":438,"character":0}},"name":"_add_prediction","signature":{"label":"_add_prediction($self,$gene)","documentation":"1;\n# $Id: Fgenesh.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Fgenesh\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christopher Dwan (chris@dwan.org)\n#\n# Copied, lock stock & barrel from Genscan.pm\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Fgenesh - parse results of one Fgenesh run\n\n=head1 SYNOPSIS\n\n   use Bio::Tools::Fgenesh;\n\n   $fgenesh = Bio::Tools::Fgenesh->new(-file => 'result.fgenesh');\n   # filehandle:\n   $fgenesh = Bio::Tools::Fgenesh->new( -fh  => \\*INPUT );\n\n   # parse the results\n   # note: this class is-a Bio::Tools::AnalysisResult which implements\n   # Bio::SeqAnalysisParserI, i.e., $fgensh->next_feature() is the same\n   while($gene = $fgenesh->next_prediction()) {\n       # $gene is an instance of Bio::Tools::Prediction::Gene, which inherits\n       # off Bio::SeqFeature::Gene::Transcript.\n       #\n       # $gene->exons() returns an array of \n       # Bio::Tools::Prediction::Exon objects\n       # all exons:\n       @exon_arr = $gene->exons();\n\n       # initial exons only\n       @init_exons = $gene->exons('Initial');\n       # internal exons only\n       @intrl_exons = $gene->exons('Internal');\n       # terminal exons only\n       @term_exons = $gene->exons('Terminal');\n       # singleton exons: \n       ($single_exon) = $gene->exons();\n   }\n\n   # essential if you gave a filename at initialization (otherwise the file\n   # will stay open)\n   $fgenesh->close();\n\n=head1 DESCRIPTION\n\nThe Fgenesh module provides a parser for Fgenesh (version 2) gene structure \nprediction output. It parses one gene prediction into a \nBio::SeqFeature::Gene::Transcript- derived object.\n\nThis module also implements the L<Bio::SeqAnalysisParserI> interface, and thus\ncan be used wherever such an object fits. \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Dwan\n\nEmail chris-at-dwan.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Fgenesh;\nuse strict;\nuse Symbol;\n\nuse Bio::Root::Root;\nuse Bio::Tools::Prediction::Gene;\nuse Bio::Tools::Prediction::Exon;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\nmy %ExonTags = ('CDSf' => 'Initial',\n\t\t'CDSi' => 'Internal',\n\t\t'CDSl' => 'Terminal',\n\t\t'CDSo' => 'Singleton');\n    \nsub _initialize_state {\n    my ($self,@args) = @_;\n    \n    # first call the inherited method!\n    $self->SUPER::_initialize_state(@args);\n\n    # our private state variables\n    $self->{'_preds_parsed'} = 0;\n    $self->{'_has_cds'} = 0;\n    # array of pre-parsed predictions\n    $self->{'_preds'} = [];\n    # seq stack\n    $self->{'_seqstack'} = [];\n}\n\n=head2 analysis_method\n\n Usage     : $genscan->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /genscan/i.\n Returns   : String\n Argument  : n/a\n\n\n#-------------\nsub analysis_method { \n#-------------\n    my ($self, $method) = @_;  \n    if($method && ($method !~ /fgenesh/i)) {\n\t$self->throw(\"method $method not supported in \" . ref($self));\n    }\n    return $self->SUPER::analysis_method($method);\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : while($gene = $fgenesh->next_feature()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the Fgenesh result\n           file. Call this method repeatedly until FALSE is returned.\n\n           The returned object is actually a SeqFeatureI implementing object.\n           This method is required for classes implementing the\n           SeqAnalysisParserI interface, and is merely an alias for \n           next_prediction() at present.\n\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :\n\n\nsub next_feature {\n    my ($self,@args) = @_;\n    # even though next_prediction doesn't expect any args (and this method\n    # does neither), we pass on args in order to be prepared if this changes\n    # ever\n    return $self->next_prediction(@args);\n}\n\n=head2 next_prediction\n\n Title   : next_prediction\n Usage   : while($gene = $fgenesh->next_prediction()) { ... }\n Function: Returns the next gene structure prediction of the Genscan result\n           file. Call this method repeatedly until FALSE is returned.\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :\n\n\nsub next_prediction {\n    my ($self) = @_;\n    my $gene;\n\n    # if the prediction section hasn't been parsed yet, we do this now\n    $self->_parse_predictions() unless $self->_predictions_parsed();\n\n    # get next gene structure\n    $gene = $self->_prediction();\n\n    if($gene) {\n\t# fill in predicted protein, and if available the predicted CDS\n\t#\n\n\t# use the seq stack if there's a seq on it\n\tmy $seqobj = pop(@{$self->{'_seqstack'}});\n        my ($id, $seq);\n\tunless ($seqobj) {\n\t   ($id, $seq) = $self->_read_fasta_seq();\n           my $alphabet;\n           if (($id =~ /mrna/) || ($id =~ /cds/)) { $alphabet = 'dna'; }\n           else { $alphabet = 'protein'; }\n           $seqobj = Bio::PrimarySeq->new('-seq'        => $seq,\n                                          '-display_id' => $id,\n                                          '-alphabet'   => $alphabet); \n        }\n\tif ($seqobj) {\n\n\t    # check that prediction number matches the prediction number\n\t    # indicated in the sequence id (there may be incomplete gene\n\t    # predictions that contain only signals with no associated protein\n            # prediction.\n\n\t    $gene->primary_tag() =~ /[^0-9]([0-9]+)$/;\n\t    my $prednr = $1;\n\t    if ($id !~ /_predicted_(\\w+)_$prednr/) {\n\t\t# this is not our sequence, so push back for next prediction\n\t\tpush(@{$self->{'_seqstack'}}, $seqobj);\n\t    } else {\n                if ($1 eq \"protein\") {\n\t\t  $gene->predicted_protein($seqobj);\n                } elsif (($1 eq \"mrna\") || ($1 eq \"cds\")) {\n                  $self->_has_cds(1);\n                  $gene->predicted_cds($seqobj);\n                  \n                  # Have to go back in and get the protein...\n                  ($id, $seq) = $self->_read_fasta_seq();\n                  if ($id =~ /_cds_/) { \n                    ($id, $seq) = $self->_read_fasta_seq(); \n                  }\n \n\t\t  $seqobj = Bio::PrimarySeq->new('-seq' => $seq,\n\t\t\t    \t\t         '-display_id' => $id,\n\t\t\t\t\t\t '-alphabet' => \"protein\");\n\t\t  $gene->predicted_protein($seqobj);\n\t\t}\n\t    }\n\t}\n    }\n\n    return $gene;\n}\n\n=head2 _parse_predictions\n\n Title   : _parse_predictions()\n Usage   : $obj->_parse_predictions()\n Function: Parses the prediction section. Automatically called by\n           next_prediction() if not yet done.\n Example :\n Returns : \n\n\nsub _parse_predictions {\n    my ($self) = @_;\n    my $gene;\n    my $seqname;\n\n    while(defined($_ = $self->_readline())) {\n\n\tif(/^\\s*(\\d+)\\s+([+\\-])/) {\n            my $line = $_;\n\n\t    # exon or signal\n\t    my $prednr = $1;\n            my $strand = ($2 eq '+') ? 1 : -1;\n\n\t    if(! defined($gene)) {\n\t\t$gene = Bio::Tools::Prediction::Gene->new(\n                                       '-primary' => \"GenePrediction$prednr\",\n\t\t\t\t       '-source' => 'Fgenesh');\n\t    }\n\t    # split into fields\n\t    chomp();\n\t    my @flds = split(/\\s+/, ' ' . $line);\n\t    ## NB - the above adds leading whitespace before the gene\n\t    ## number in case there was none (as quick patch to code\n\t    ## below which expects it but it is not present after 999\n\t    ## predictions!) This allows >999 predictions to be parsed.\n\n\t    # create the feature object depending on the type of signal\n\t    my $predobj;\n\t    my $is_exon = grep {$line =~ $_} keys(%ExonTags);\n            my ($start, $end);\n\t    if($is_exon) {\n\t\t$predobj = Bio::Tools::Prediction::Exon->new();\n                $predobj->score($flds[8]);\n                $start   = $flds[5];\n                $end     = $flds[7];\n\t    } else {\n\t\t# PolyA site, or TSS \n\t\t$predobj = Bio::SeqFeature::Generic->new();\n                $predobj->score($flds[5]);\n                $start   = $flds[4];\n                $end     = $flds[4];\n\t    }\n\t    # set common fields\n\t    $predobj->source_tag('Fgenesh');\n\t    $predobj->strand($strand);\n\n# Following tactical commenting-out made by\n# malcolm.cook@stowers-institute.org since coordinate reversal is\n# apparently vestigial copy/paste detritus from Genscan.pm origins of\n# this module and this is NOT needed for fgenesh (at least in v\n# 2.1.4).\n\n#\t    if($predobj->strand() == 1) {\n\t\t$predobj->start($start);\n\t\t$predobj->end($end);\n#\t    } else {\n#\t\t$predobj->end($start);\n#\t\t$predobj->start($end);\n#\t    }\n\n            # print STDERR \"start $start end $end\\n\";\n\t    # add to gene structure (should be done only when start and end\n\t    # are set, in order to allow for proper expansion of the range)\n\t    if($is_exon) {\n\t\t# first, set fields unique to exons\n\t\t$predobj->primary_tag($ExonTags{$flds[4]} . 'Exon');\n\t\t$predobj->is_coding(1);\n\t\tmy $cod_offset;\n\t\tif($predobj->strand() == 1) {\n\t\t    $cod_offset = ($flds[9] - $predobj->start()) % 3;\n\t\t    # Possible values are -2, -1, 0, 1, 2. -1 and -2 correspond\n\t\t    # to offsets 2 and 1, resp. Offset 3 is the same as 0.\n\t\t    $cod_offset += 3 if($cod_offset < 1);\t\t    \n\t\t} else {\n\t\t    # On the reverse strand the Genscan frame also refers to\n\t\t    # the first base of the first complete codon, but viewed\n\t\t    # from forward, which is the third base viewed from\n\t\t    # reverse.\n\t\t    $cod_offset = ($flds[11] - $predobj->end()) % 3;\n\t\t    # Possible values are -2, -1, 0, 1, 2. Due to the reverse\n\t\t    # situation, {2,-1} and {1,-2} correspond to offsets\n\t\t    # 1 and 2, resp. Offset 3 is the same as 0.\n\t\t    $cod_offset -= 3 if($cod_offset >= 0);\n\t\t    $cod_offset = -$cod_offset;\n\t\t}\n\t\t# Offsets 2 and 1 correspond to frame 1 and 2 (frame of exon\n\t\t# is the frame of the first base relative to the exon, or the\n\t\t# number of bases the first codon is missing).\n\t\t$predobj->frame(3 - $cod_offset);\n                # print STDERR \"  frame is \" . $predobj->frame() . \"\\n\";\n\t\t# then add to gene structure object\n\t\t$gene->add_exon($predobj, $ExonTags{$flds[1]});\t\t\n\t    } elsif($flds[3] eq 'PolA') {\n\t\t$predobj->primary_tag(\"PolyAsite\");\n\t\t$gene->poly_A_site($predobj);\n\t    } elsif($flds[3] eq 'TSS') {\n\t        $predobj->primary_tag(\"Promoter\"); # (hey! a TSS is NOT a promoter... what's going on here?...\n\t\t$gene->add_promoter($predobj);\n                #I'd like to do this (for now):\n\t\t#$predobj->primary_tag(\"TSS\"); #this is not the right model, but, it IS a feature at least.\n                #but the followg errs out\n\t\t#$gene->add_SeqFeature($predobj); #err: MSG: start is undefined when bounds at Bio::SeqFeature::Generic::add_SeqFeature 671 check since gene has no start yet\n\t    }\n\t    else {\n\t      $self->throw(\"unrecognized prediction line: \" . $line);\n\t    }\n\t    next;\n\t}\n\n\tif(/^\\s*$/ && defined($gene)) {\n\t    # current gene is completed\n\t    $gene->seq_id($seqname);\n\t    $self->_add_prediction($gene);\n\t    $gene = undef;\n\t    next;\n\t}\n\n\tif(/^(FGENESH)\\s+([\\d\\.]+)/) {\n\t    $self->analysis_method($1);\n\t    $self->analysis_method_version($2);\n            if (/\\s(\\S+)\\sgenomic DNA/) {\n              $self->analysis_subject($1);\n            }\n\t    next;\n\t}\n\n\tif(/^\\s*Seq name:\\s+(\\S+)/) {\n\t    $seqname = $1;\n\t    next;\n\t}\n        \n\t/^Predicted protein/ && do {\n\t    # section of predicted sequences\n\t    $self->_pushback($_);\n\t    last;\n\t};\n    }\n\n    $self->_predictions_parsed(1);\n}\n\n=head2 _prediction\n\n Title   : _prediction()\n Usage   : $gene = $obj->_prediction()\n Function: internal\n Example :\n Returns : \n\n\nsub _prediction {\n    my ($self) = @_;\n\n    return unless(exists($self->{'_preds'}) && @{$self->{'_preds'}});\n    return shift(@{$self->{'_preds'}});\n}\n\n=head2 _add_prediction\n\n Title   : _add_prediction()\n Usage   : $obj->_add_prediction($gene)\n Function: internal\n Example :\n Returns : ","parameters":[{"label":"$self"},{"label":"$gene"}]},"detail":"($self,$gene)","definition":"sub","containerName":"main::","children":[{"definition":"my","name":"$self","containerName":"_add_prediction","localvar":"my","kind":13,"line":439},{"kind":13,"line":439,"name":"$gene","containerName":"_add_prediction"},{"line":441,"kind":13,"containerName":"_add_prediction","name":"$self"},{"name":"$self","containerName":"_add_prediction","line":442,"kind":13},{"line":444,"kind":13,"containerName":"_add_prediction","name":"$self"}],"line":438,"kind":12},{"kind":13,"line":444,"name":"$gene","containerName":null},{"range":{"start":{"character":0,"line":457},"end":{"character":9999,"line":465}},"name":"_predictions_parsed","children":[{"containerName":"_predictions_parsed","definition":"my","name":"$self","localvar":"my","kind":13,"line":458},{"kind":13,"line":458,"name":"$val","containerName":"_predictions_parsed"},{"line":460,"kind":13,"containerName":"_predictions_parsed","name":"$self"},{"name":"$val","containerName":"_predictions_parsed","kind":13,"line":460},{"containerName":"_predictions_parsed","name":"$val","line":460,"kind":13},{"line":461,"kind":13,"name":"$self","containerName":"_predictions_parsed"},{"kind":13,"line":462,"containerName":"_predictions_parsed","name":"$self"},{"containerName":"_predictions_parsed","name":"$self","line":464,"kind":13}],"line":457,"kind":12,"signature":{"label":"_predictions_parsed($self,$val)","documentation":"1;\n# $Id: Fgenesh.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Fgenesh\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christopher Dwan (chris@dwan.org)\n#\n# Copied, lock stock & barrel from Genscan.pm\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Fgenesh - parse results of one Fgenesh run\n\n=head1 SYNOPSIS\n\n   use Bio::Tools::Fgenesh;\n\n   $fgenesh = Bio::Tools::Fgenesh->new(-file => 'result.fgenesh');\n   # filehandle:\n   $fgenesh = Bio::Tools::Fgenesh->new( -fh  => \\*INPUT );\n\n   # parse the results\n   # note: this class is-a Bio::Tools::AnalysisResult which implements\n   # Bio::SeqAnalysisParserI, i.e., $fgensh->next_feature() is the same\n   while($gene = $fgenesh->next_prediction()) {\n       # $gene is an instance of Bio::Tools::Prediction::Gene, which inherits\n       # off Bio::SeqFeature::Gene::Transcript.\n       #\n       # $gene->exons() returns an array of \n       # Bio::Tools::Prediction::Exon objects\n       # all exons:\n       @exon_arr = $gene->exons();\n\n       # initial exons only\n       @init_exons = $gene->exons('Initial');\n       # internal exons only\n       @intrl_exons = $gene->exons('Internal');\n       # terminal exons only\n       @term_exons = $gene->exons('Terminal');\n       # singleton exons: \n       ($single_exon) = $gene->exons();\n   }\n\n   # essential if you gave a filename at initialization (otherwise the file\n   # will stay open)\n   $fgenesh->close();\n\n=head1 DESCRIPTION\n\nThe Fgenesh module provides a parser for Fgenesh (version 2) gene structure \nprediction output. It parses one gene prediction into a \nBio::SeqFeature::Gene::Transcript- derived object.\n\nThis module also implements the L<Bio::SeqAnalysisParserI> interface, and thus\ncan be used wherever such an object fits. \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Dwan\n\nEmail chris-at-dwan.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Fgenesh;\nuse strict;\nuse Symbol;\n\nuse Bio::Root::Root;\nuse Bio::Tools::Prediction::Gene;\nuse Bio::Tools::Prediction::Exon;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\nmy %ExonTags = ('CDSf' => 'Initial',\n\t\t'CDSi' => 'Internal',\n\t\t'CDSl' => 'Terminal',\n\t\t'CDSo' => 'Singleton');\n    \nsub _initialize_state {\n    my ($self,@args) = @_;\n    \n    # first call the inherited method!\n    $self->SUPER::_initialize_state(@args);\n\n    # our private state variables\n    $self->{'_preds_parsed'} = 0;\n    $self->{'_has_cds'} = 0;\n    # array of pre-parsed predictions\n    $self->{'_preds'} = [];\n    # seq stack\n    $self->{'_seqstack'} = [];\n}\n\n=head2 analysis_method\n\n Usage     : $genscan->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /genscan/i.\n Returns   : String\n Argument  : n/a\n\n\n#-------------\nsub analysis_method { \n#-------------\n    my ($self, $method) = @_;  \n    if($method && ($method !~ /fgenesh/i)) {\n\t$self->throw(\"method $method not supported in \" . ref($self));\n    }\n    return $self->SUPER::analysis_method($method);\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : while($gene = $fgenesh->next_feature()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the Fgenesh result\n           file. Call this method repeatedly until FALSE is returned.\n\n           The returned object is actually a SeqFeatureI implementing object.\n           This method is required for classes implementing the\n           SeqAnalysisParserI interface, and is merely an alias for \n           next_prediction() at present.\n\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :\n\n\nsub next_feature {\n    my ($self,@args) = @_;\n    # even though next_prediction doesn't expect any args (and this method\n    # does neither), we pass on args in order to be prepared if this changes\n    # ever\n    return $self->next_prediction(@args);\n}\n\n=head2 next_prediction\n\n Title   : next_prediction\n Usage   : while($gene = $fgenesh->next_prediction()) { ... }\n Function: Returns the next gene structure prediction of the Genscan result\n           file. Call this method repeatedly until FALSE is returned.\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :\n\n\nsub next_prediction {\n    my ($self) = @_;\n    my $gene;\n\n    # if the prediction section hasn't been parsed yet, we do this now\n    $self->_parse_predictions() unless $self->_predictions_parsed();\n\n    # get next gene structure\n    $gene = $self->_prediction();\n\n    if($gene) {\n\t# fill in predicted protein, and if available the predicted CDS\n\t#\n\n\t# use the seq stack if there's a seq on it\n\tmy $seqobj = pop(@{$self->{'_seqstack'}});\n        my ($id, $seq);\n\tunless ($seqobj) {\n\t   ($id, $seq) = $self->_read_fasta_seq();\n           my $alphabet;\n           if (($id =~ /mrna/) || ($id =~ /cds/)) { $alphabet = 'dna'; }\n           else { $alphabet = 'protein'; }\n           $seqobj = Bio::PrimarySeq->new('-seq'        => $seq,\n                                          '-display_id' => $id,\n                                          '-alphabet'   => $alphabet); \n        }\n\tif ($seqobj) {\n\n\t    # check that prediction number matches the prediction number\n\t    # indicated in the sequence id (there may be incomplete gene\n\t    # predictions that contain only signals with no associated protein\n            # prediction.\n\n\t    $gene->primary_tag() =~ /[^0-9]([0-9]+)$/;\n\t    my $prednr = $1;\n\t    if ($id !~ /_predicted_(\\w+)_$prednr/) {\n\t\t# this is not our sequence, so push back for next prediction\n\t\tpush(@{$self->{'_seqstack'}}, $seqobj);\n\t    } else {\n                if ($1 eq \"protein\") {\n\t\t  $gene->predicted_protein($seqobj);\n                } elsif (($1 eq \"mrna\") || ($1 eq \"cds\")) {\n                  $self->_has_cds(1);\n                  $gene->predicted_cds($seqobj);\n                  \n                  # Have to go back in and get the protein...\n                  ($id, $seq) = $self->_read_fasta_seq();\n                  if ($id =~ /_cds_/) { \n                    ($id, $seq) = $self->_read_fasta_seq(); \n                  }\n \n\t\t  $seqobj = Bio::PrimarySeq->new('-seq' => $seq,\n\t\t\t    \t\t         '-display_id' => $id,\n\t\t\t\t\t\t '-alphabet' => \"protein\");\n\t\t  $gene->predicted_protein($seqobj);\n\t\t}\n\t    }\n\t}\n    }\n\n    return $gene;\n}\n\n=head2 _parse_predictions\n\n Title   : _parse_predictions()\n Usage   : $obj->_parse_predictions()\n Function: Parses the prediction section. Automatically called by\n           next_prediction() if not yet done.\n Example :\n Returns : \n\n\nsub _parse_predictions {\n    my ($self) = @_;\n    my $gene;\n    my $seqname;\n\n    while(defined($_ = $self->_readline())) {\n\n\tif(/^\\s*(\\d+)\\s+([+\\-])/) {\n            my $line = $_;\n\n\t    # exon or signal\n\t    my $prednr = $1;\n            my $strand = ($2 eq '+') ? 1 : -1;\n\n\t    if(! defined($gene)) {\n\t\t$gene = Bio::Tools::Prediction::Gene->new(\n                                       '-primary' => \"GenePrediction$prednr\",\n\t\t\t\t       '-source' => 'Fgenesh');\n\t    }\n\t    # split into fields\n\t    chomp();\n\t    my @flds = split(/\\s+/, ' ' . $line);\n\t    ## NB - the above adds leading whitespace before the gene\n\t    ## number in case there was none (as quick patch to code\n\t    ## below which expects it but it is not present after 999\n\t    ## predictions!) This allows >999 predictions to be parsed.\n\n\t    # create the feature object depending on the type of signal\n\t    my $predobj;\n\t    my $is_exon = grep {$line =~ $_} keys(%ExonTags);\n            my ($start, $end);\n\t    if($is_exon) {\n\t\t$predobj = Bio::Tools::Prediction::Exon->new();\n                $predobj->score($flds[8]);\n                $start   = $flds[5];\n                $end     = $flds[7];\n\t    } else {\n\t\t# PolyA site, or TSS \n\t\t$predobj = Bio::SeqFeature::Generic->new();\n                $predobj->score($flds[5]);\n                $start   = $flds[4];\n                $end     = $flds[4];\n\t    }\n\t    # set common fields\n\t    $predobj->source_tag('Fgenesh');\n\t    $predobj->strand($strand);\n\n# Following tactical commenting-out made by\n# malcolm.cook@stowers-institute.org since coordinate reversal is\n# apparently vestigial copy/paste detritus from Genscan.pm origins of\n# this module and this is NOT needed for fgenesh (at least in v\n# 2.1.4).\n\n#\t    if($predobj->strand() == 1) {\n\t\t$predobj->start($start);\n\t\t$predobj->end($end);\n#\t    } else {\n#\t\t$predobj->end($start);\n#\t\t$predobj->start($end);\n#\t    }\n\n            # print STDERR \"start $start end $end\\n\";\n\t    # add to gene structure (should be done only when start and end\n\t    # are set, in order to allow for proper expansion of the range)\n\t    if($is_exon) {\n\t\t# first, set fields unique to exons\n\t\t$predobj->primary_tag($ExonTags{$flds[4]} . 'Exon');\n\t\t$predobj->is_coding(1);\n\t\tmy $cod_offset;\n\t\tif($predobj->strand() == 1) {\n\t\t    $cod_offset = ($flds[9] - $predobj->start()) % 3;\n\t\t    # Possible values are -2, -1, 0, 1, 2. -1 and -2 correspond\n\t\t    # to offsets 2 and 1, resp. Offset 3 is the same as 0.\n\t\t    $cod_offset += 3 if($cod_offset < 1);\t\t    \n\t\t} else {\n\t\t    # On the reverse strand the Genscan frame also refers to\n\t\t    # the first base of the first complete codon, but viewed\n\t\t    # from forward, which is the third base viewed from\n\t\t    # reverse.\n\t\t    $cod_offset = ($flds[11] - $predobj->end()) % 3;\n\t\t    # Possible values are -2, -1, 0, 1, 2. Due to the reverse\n\t\t    # situation, {2,-1} and {1,-2} correspond to offsets\n\t\t    # 1 and 2, resp. Offset 3 is the same as 0.\n\t\t    $cod_offset -= 3 if($cod_offset >= 0);\n\t\t    $cod_offset = -$cod_offset;\n\t\t}\n\t\t# Offsets 2 and 1 correspond to frame 1 and 2 (frame of exon\n\t\t# is the frame of the first base relative to the exon, or the\n\t\t# number of bases the first codon is missing).\n\t\t$predobj->frame(3 - $cod_offset);\n                # print STDERR \"  frame is \" . $predobj->frame() . \"\\n\";\n\t\t# then add to gene structure object\n\t\t$gene->add_exon($predobj, $ExonTags{$flds[1]});\t\t\n\t    } elsif($flds[3] eq 'PolA') {\n\t\t$predobj->primary_tag(\"PolyAsite\");\n\t\t$gene->poly_A_site($predobj);\n\t    } elsif($flds[3] eq 'TSS') {\n\t        $predobj->primary_tag(\"Promoter\"); # (hey! a TSS is NOT a promoter... what's going on here?...\n\t\t$gene->add_promoter($predobj);\n                #I'd like to do this (for now):\n\t\t#$predobj->primary_tag(\"TSS\"); #this is not the right model, but, it IS a feature at least.\n                #but the followg errs out\n\t\t#$gene->add_SeqFeature($predobj); #err: MSG: start is undefined when bounds at Bio::SeqFeature::Generic::add_SeqFeature 671 check since gene has no start yet\n\t    }\n\t    else {\n\t      $self->throw(\"unrecognized prediction line: \" . $line);\n\t    }\n\t    next;\n\t}\n\n\tif(/^\\s*$/ && defined($gene)) {\n\t    # current gene is completed\n\t    $gene->seq_id($seqname);\n\t    $self->_add_prediction($gene);\n\t    $gene = undef;\n\t    next;\n\t}\n\n\tif(/^(FGENESH)\\s+([\\d\\.]+)/) {\n\t    $self->analysis_method($1);\n\t    $self->analysis_method_version($2);\n            if (/\\s(\\S+)\\sgenomic DNA/) {\n              $self->analysis_subject($1);\n            }\n\t    next;\n\t}\n\n\tif(/^\\s*Seq name:\\s+(\\S+)/) {\n\t    $seqname = $1;\n\t    next;\n\t}\n        \n\t/^Predicted protein/ && do {\n\t    # section of predicted sequences\n\t    $self->_pushback($_);\n\t    last;\n\t};\n    }\n\n    $self->_predictions_parsed(1);\n}\n\n=head2 _prediction\n\n Title   : _prediction()\n Usage   : $gene = $obj->_prediction()\n Function: internal\n Example :\n Returns : \n\n\nsub _prediction {\n    my ($self) = @_;\n\n    return unless(exists($self->{'_preds'}) && @{$self->{'_preds'}});\n    return shift(@{$self->{'_preds'}});\n}\n\n=head2 _add_prediction\n\n Title   : _add_prediction()\n Usage   : $obj->_add_prediction($gene)\n Function: internal\n Example :\n Returns : \n\n\nsub _add_prediction {\n    my ($self, $gene) = @_;\n\n    if(! exists($self->{'_preds'})) {\n\t$self->{'_preds'} = [];\n    }\n    push(@{$self->{'_preds'}}, $gene);\n}\n\n=head2 _predictions_parsed\n\n Title   : _predictions_parsed\n Usage   : $obj->_predictions_parsed\n Function: internal\n Example :\n Returns : TRUE or FALSE","parameters":[{"label":"$self"},{"label":"$val"}]},"detail":"($self,$val)","definition":"sub","containerName":"main::"},{"definition":"sub","containerName":"main::","signature":{"label":"_has_cds($self,$val)","documentation":"1;\n# $Id: Fgenesh.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Fgenesh\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christopher Dwan (chris@dwan.org)\n#\n# Copied, lock stock & barrel from Genscan.pm\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Fgenesh - parse results of one Fgenesh run\n\n=head1 SYNOPSIS\n\n   use Bio::Tools::Fgenesh;\n\n   $fgenesh = Bio::Tools::Fgenesh->new(-file => 'result.fgenesh');\n   # filehandle:\n   $fgenesh = Bio::Tools::Fgenesh->new( -fh  => \\*INPUT );\n\n   # parse the results\n   # note: this class is-a Bio::Tools::AnalysisResult which implements\n   # Bio::SeqAnalysisParserI, i.e., $fgensh->next_feature() is the same\n   while($gene = $fgenesh->next_prediction()) {\n       # $gene is an instance of Bio::Tools::Prediction::Gene, which inherits\n       # off Bio::SeqFeature::Gene::Transcript.\n       #\n       # $gene->exons() returns an array of \n       # Bio::Tools::Prediction::Exon objects\n       # all exons:\n       @exon_arr = $gene->exons();\n\n       # initial exons only\n       @init_exons = $gene->exons('Initial');\n       # internal exons only\n       @intrl_exons = $gene->exons('Internal');\n       # terminal exons only\n       @term_exons = $gene->exons('Terminal');\n       # singleton exons: \n       ($single_exon) = $gene->exons();\n   }\n\n   # essential if you gave a filename at initialization (otherwise the file\n   # will stay open)\n   $fgenesh->close();\n\n=head1 DESCRIPTION\n\nThe Fgenesh module provides a parser for Fgenesh (version 2) gene structure \nprediction output. It parses one gene prediction into a \nBio::SeqFeature::Gene::Transcript- derived object.\n\nThis module also implements the L<Bio::SeqAnalysisParserI> interface, and thus\ncan be used wherever such an object fits. \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Dwan\n\nEmail chris-at-dwan.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Fgenesh;\nuse strict;\nuse Symbol;\n\nuse Bio::Root::Root;\nuse Bio::Tools::Prediction::Gene;\nuse Bio::Tools::Prediction::Exon;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\nmy %ExonTags = ('CDSf' => 'Initial',\n\t\t'CDSi' => 'Internal',\n\t\t'CDSl' => 'Terminal',\n\t\t'CDSo' => 'Singleton');\n    \nsub _initialize_state {\n    my ($self,@args) = @_;\n    \n    # first call the inherited method!\n    $self->SUPER::_initialize_state(@args);\n\n    # our private state variables\n    $self->{'_preds_parsed'} = 0;\n    $self->{'_has_cds'} = 0;\n    # array of pre-parsed predictions\n    $self->{'_preds'} = [];\n    # seq stack\n    $self->{'_seqstack'} = [];\n}\n\n=head2 analysis_method\n\n Usage     : $genscan->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /genscan/i.\n Returns   : String\n Argument  : n/a\n\n\n#-------------\nsub analysis_method { \n#-------------\n    my ($self, $method) = @_;  \n    if($method && ($method !~ /fgenesh/i)) {\n\t$self->throw(\"method $method not supported in \" . ref($self));\n    }\n    return $self->SUPER::analysis_method($method);\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : while($gene = $fgenesh->next_feature()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the Fgenesh result\n           file. Call this method repeatedly until FALSE is returned.\n\n           The returned object is actually a SeqFeatureI implementing object.\n           This method is required for classes implementing the\n           SeqAnalysisParserI interface, and is merely an alias for \n           next_prediction() at present.\n\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :\n\n\nsub next_feature {\n    my ($self,@args) = @_;\n    # even though next_prediction doesn't expect any args (and this method\n    # does neither), we pass on args in order to be prepared if this changes\n    # ever\n    return $self->next_prediction(@args);\n}\n\n=head2 next_prediction\n\n Title   : next_prediction\n Usage   : while($gene = $fgenesh->next_prediction()) { ... }\n Function: Returns the next gene structure prediction of the Genscan result\n           file. Call this method repeatedly until FALSE is returned.\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :\n\n\nsub next_prediction {\n    my ($self) = @_;\n    my $gene;\n\n    # if the prediction section hasn't been parsed yet, we do this now\n    $self->_parse_predictions() unless $self->_predictions_parsed();\n\n    # get next gene structure\n    $gene = $self->_prediction();\n\n    if($gene) {\n\t# fill in predicted protein, and if available the predicted CDS\n\t#\n\n\t# use the seq stack if there's a seq on it\n\tmy $seqobj = pop(@{$self->{'_seqstack'}});\n        my ($id, $seq);\n\tunless ($seqobj) {\n\t   ($id, $seq) = $self->_read_fasta_seq();\n           my $alphabet;\n           if (($id =~ /mrna/) || ($id =~ /cds/)) { $alphabet = 'dna'; }\n           else { $alphabet = 'protein'; }\n           $seqobj = Bio::PrimarySeq->new('-seq'        => $seq,\n                                          '-display_id' => $id,\n                                          '-alphabet'   => $alphabet); \n        }\n\tif ($seqobj) {\n\n\t    # check that prediction number matches the prediction number\n\t    # indicated in the sequence id (there may be incomplete gene\n\t    # predictions that contain only signals with no associated protein\n            # prediction.\n\n\t    $gene->primary_tag() =~ /[^0-9]([0-9]+)$/;\n\t    my $prednr = $1;\n\t    if ($id !~ /_predicted_(\\w+)_$prednr/) {\n\t\t# this is not our sequence, so push back for next prediction\n\t\tpush(@{$self->{'_seqstack'}}, $seqobj);\n\t    } else {\n                if ($1 eq \"protein\") {\n\t\t  $gene->predicted_protein($seqobj);\n                } elsif (($1 eq \"mrna\") || ($1 eq \"cds\")) {\n                  $self->_has_cds(1);\n                  $gene->predicted_cds($seqobj);\n                  \n                  # Have to go back in and get the protein...\n                  ($id, $seq) = $self->_read_fasta_seq();\n                  if ($id =~ /_cds_/) { \n                    ($id, $seq) = $self->_read_fasta_seq(); \n                  }\n \n\t\t  $seqobj = Bio::PrimarySeq->new('-seq' => $seq,\n\t\t\t    \t\t         '-display_id' => $id,\n\t\t\t\t\t\t '-alphabet' => \"protein\");\n\t\t  $gene->predicted_protein($seqobj);\n\t\t}\n\t    }\n\t}\n    }\n\n    return $gene;\n}\n\n=head2 _parse_predictions\n\n Title   : _parse_predictions()\n Usage   : $obj->_parse_predictions()\n Function: Parses the prediction section. Automatically called by\n           next_prediction() if not yet done.\n Example :\n Returns : \n\n\nsub _parse_predictions {\n    my ($self) = @_;\n    my $gene;\n    my $seqname;\n\n    while(defined($_ = $self->_readline())) {\n\n\tif(/^\\s*(\\d+)\\s+([+\\-])/) {\n            my $line = $_;\n\n\t    # exon or signal\n\t    my $prednr = $1;\n            my $strand = ($2 eq '+') ? 1 : -1;\n\n\t    if(! defined($gene)) {\n\t\t$gene = Bio::Tools::Prediction::Gene->new(\n                                       '-primary' => \"GenePrediction$prednr\",\n\t\t\t\t       '-source' => 'Fgenesh');\n\t    }\n\t    # split into fields\n\t    chomp();\n\t    my @flds = split(/\\s+/, ' ' . $line);\n\t    ## NB - the above adds leading whitespace before the gene\n\t    ## number in case there was none (as quick patch to code\n\t    ## below which expects it but it is not present after 999\n\t    ## predictions!) This allows >999 predictions to be parsed.\n\n\t    # create the feature object depending on the type of signal\n\t    my $predobj;\n\t    my $is_exon = grep {$line =~ $_} keys(%ExonTags);\n            my ($start, $end);\n\t    if($is_exon) {\n\t\t$predobj = Bio::Tools::Prediction::Exon->new();\n                $predobj->score($flds[8]);\n                $start   = $flds[5];\n                $end     = $flds[7];\n\t    } else {\n\t\t# PolyA site, or TSS \n\t\t$predobj = Bio::SeqFeature::Generic->new();\n                $predobj->score($flds[5]);\n                $start   = $flds[4];\n                $end     = $flds[4];\n\t    }\n\t    # set common fields\n\t    $predobj->source_tag('Fgenesh');\n\t    $predobj->strand($strand);\n\n# Following tactical commenting-out made by\n# malcolm.cook@stowers-institute.org since coordinate reversal is\n# apparently vestigial copy/paste detritus from Genscan.pm origins of\n# this module and this is NOT needed for fgenesh (at least in v\n# 2.1.4).\n\n#\t    if($predobj->strand() == 1) {\n\t\t$predobj->start($start);\n\t\t$predobj->end($end);\n#\t    } else {\n#\t\t$predobj->end($start);\n#\t\t$predobj->start($end);\n#\t    }\n\n            # print STDERR \"start $start end $end\\n\";\n\t    # add to gene structure (should be done only when start and end\n\t    # are set, in order to allow for proper expansion of the range)\n\t    if($is_exon) {\n\t\t# first, set fields unique to exons\n\t\t$predobj->primary_tag($ExonTags{$flds[4]} . 'Exon');\n\t\t$predobj->is_coding(1);\n\t\tmy $cod_offset;\n\t\tif($predobj->strand() == 1) {\n\t\t    $cod_offset = ($flds[9] - $predobj->start()) % 3;\n\t\t    # Possible values are -2, -1, 0, 1, 2. -1 and -2 correspond\n\t\t    # to offsets 2 and 1, resp. Offset 3 is the same as 0.\n\t\t    $cod_offset += 3 if($cod_offset < 1);\t\t    \n\t\t} else {\n\t\t    # On the reverse strand the Genscan frame also refers to\n\t\t    # the first base of the first complete codon, but viewed\n\t\t    # from forward, which is the third base viewed from\n\t\t    # reverse.\n\t\t    $cod_offset = ($flds[11] - $predobj->end()) % 3;\n\t\t    # Possible values are -2, -1, 0, 1, 2. Due to the reverse\n\t\t    # situation, {2,-1} and {1,-2} correspond to offsets\n\t\t    # 1 and 2, resp. Offset 3 is the same as 0.\n\t\t    $cod_offset -= 3 if($cod_offset >= 0);\n\t\t    $cod_offset = -$cod_offset;\n\t\t}\n\t\t# Offsets 2 and 1 correspond to frame 1 and 2 (frame of exon\n\t\t# is the frame of the first base relative to the exon, or the\n\t\t# number of bases the first codon is missing).\n\t\t$predobj->frame(3 - $cod_offset);\n                # print STDERR \"  frame is \" . $predobj->frame() . \"\\n\";\n\t\t# then add to gene structure object\n\t\t$gene->add_exon($predobj, $ExonTags{$flds[1]});\t\t\n\t    } elsif($flds[3] eq 'PolA') {\n\t\t$predobj->primary_tag(\"PolyAsite\");\n\t\t$gene->poly_A_site($predobj);\n\t    } elsif($flds[3] eq 'TSS') {\n\t        $predobj->primary_tag(\"Promoter\"); # (hey! a TSS is NOT a promoter... what's going on here?...\n\t\t$gene->add_promoter($predobj);\n                #I'd like to do this (for now):\n\t\t#$predobj->primary_tag(\"TSS\"); #this is not the right model, but, it IS a feature at least.\n                #but the followg errs out\n\t\t#$gene->add_SeqFeature($predobj); #err: MSG: start is undefined when bounds at Bio::SeqFeature::Generic::add_SeqFeature 671 check since gene has no start yet\n\t    }\n\t    else {\n\t      $self->throw(\"unrecognized prediction line: \" . $line);\n\t    }\n\t    next;\n\t}\n\n\tif(/^\\s*$/ && defined($gene)) {\n\t    # current gene is completed\n\t    $gene->seq_id($seqname);\n\t    $self->_add_prediction($gene);\n\t    $gene = undef;\n\t    next;\n\t}\n\n\tif(/^(FGENESH)\\s+([\\d\\.]+)/) {\n\t    $self->analysis_method($1);\n\t    $self->analysis_method_version($2);\n            if (/\\s(\\S+)\\sgenomic DNA/) {\n              $self->analysis_subject($1);\n            }\n\t    next;\n\t}\n\n\tif(/^\\s*Seq name:\\s+(\\S+)/) {\n\t    $seqname = $1;\n\t    next;\n\t}\n        \n\t/^Predicted protein/ && do {\n\t    # section of predicted sequences\n\t    $self->_pushback($_);\n\t    last;\n\t};\n    }\n\n    $self->_predictions_parsed(1);\n}\n\n=head2 _prediction\n\n Title   : _prediction()\n Usage   : $gene = $obj->_prediction()\n Function: internal\n Example :\n Returns : \n\n\nsub _prediction {\n    my ($self) = @_;\n\n    return unless(exists($self->{'_preds'}) && @{$self->{'_preds'}});\n    return shift(@{$self->{'_preds'}});\n}\n\n=head2 _add_prediction\n\n Title   : _add_prediction()\n Usage   : $obj->_add_prediction($gene)\n Function: internal\n Example :\n Returns : \n\n\nsub _add_prediction {\n    my ($self, $gene) = @_;\n\n    if(! exists($self->{'_preds'})) {\n\t$self->{'_preds'} = [];\n    }\n    push(@{$self->{'_preds'}}, $gene);\n}\n\n=head2 _predictions_parsed\n\n Title   : _predictions_parsed\n Usage   : $obj->_predictions_parsed\n Function: internal\n Example :\n Returns : TRUE or FALSE\n\n\nsub _predictions_parsed {\n    my ($self, $val) = @_;\n\n    $self->{'_preds_parsed'} = $val if $val;\n    if(! exists($self->{'_preds_parsed'})) {\n\t$self->{'_preds_parsed'} = 0;\n    }\n    return $self->{'_preds_parsed'};\n}\n\n=head2 _has_cds\n\n Title   : _has_cds()\n Usage   : $obj->_has_cds()\n Function: Whether or not the result contains the predicted CDSs, too.\n Example :\n Returns : TRUE or FALSE","parameters":[{"label":"$self"},{"label":"$val"}]},"detail":"($self,$val)","kind":12,"children":[{"kind":13,"line":478,"containerName":"_has_cds","name":"$self","definition":"my","localvar":"my"},{"line":478,"kind":13,"containerName":"_has_cds","name":"$val"},{"name":"$self","containerName":"_has_cds","line":480,"kind":13},{"kind":13,"line":480,"containerName":"_has_cds","name":"$val"},{"line":480,"kind":13,"name":"$val","containerName":"_has_cds"},{"line":481,"kind":13,"containerName":"_has_cds","name":"$self"},{"line":482,"kind":13,"name":"$self","containerName":"_has_cds"},{"line":484,"kind":13,"containerName":"_has_cds","name":"$self"}],"line":477,"name":"_has_cds","range":{"start":{"line":477,"character":0},"end":{"line":485,"character":9999}}},{"signature":{"documentation":"1;\n# $Id: Fgenesh.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Fgenesh\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christopher Dwan (chris@dwan.org)\n#\n# Copied, lock stock & barrel from Genscan.pm\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Fgenesh - parse results of one Fgenesh run\n\n=head1 SYNOPSIS\n\n   use Bio::Tools::Fgenesh;\n\n   $fgenesh = Bio::Tools::Fgenesh->new(-file => 'result.fgenesh');\n   # filehandle:\n   $fgenesh = Bio::Tools::Fgenesh->new( -fh  => \\*INPUT );\n\n   # parse the results\n   # note: this class is-a Bio::Tools::AnalysisResult which implements\n   # Bio::SeqAnalysisParserI, i.e., $fgensh->next_feature() is the same\n   while($gene = $fgenesh->next_prediction()) {\n       # $gene is an instance of Bio::Tools::Prediction::Gene, which inherits\n       # off Bio::SeqFeature::Gene::Transcript.\n       #\n       # $gene->exons() returns an array of \n       # Bio::Tools::Prediction::Exon objects\n       # all exons:\n       @exon_arr = $gene->exons();\n\n       # initial exons only\n       @init_exons = $gene->exons('Initial');\n       # internal exons only\n       @intrl_exons = $gene->exons('Internal');\n       # terminal exons only\n       @term_exons = $gene->exons('Terminal');\n       # singleton exons: \n       ($single_exon) = $gene->exons();\n   }\n\n   # essential if you gave a filename at initialization (otherwise the file\n   # will stay open)\n   $fgenesh->close();\n\n=head1 DESCRIPTION\n\nThe Fgenesh module provides a parser for Fgenesh (version 2) gene structure \nprediction output. It parses one gene prediction into a \nBio::SeqFeature::Gene::Transcript- derived object.\n\nThis module also implements the L<Bio::SeqAnalysisParserI> interface, and thus\ncan be used wherever such an object fits. \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Dwan\n\nEmail chris-at-dwan.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Fgenesh;\nuse strict;\nuse Symbol;\n\nuse Bio::Root::Root;\nuse Bio::Tools::Prediction::Gene;\nuse Bio::Tools::Prediction::Exon;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\nmy %ExonTags = ('CDSf' => 'Initial',\n\t\t'CDSi' => 'Internal',\n\t\t'CDSl' => 'Terminal',\n\t\t'CDSo' => 'Singleton');\n    \nsub _initialize_state {\n    my ($self,@args) = @_;\n    \n    # first call the inherited method!\n    $self->SUPER::_initialize_state(@args);\n\n    # our private state variables\n    $self->{'_preds_parsed'} = 0;\n    $self->{'_has_cds'} = 0;\n    # array of pre-parsed predictions\n    $self->{'_preds'} = [];\n    # seq stack\n    $self->{'_seqstack'} = [];\n}\n\n=head2 analysis_method\n\n Usage     : $genscan->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /genscan/i.\n Returns   : String\n Argument  : n/a\n\n\n#-------------\nsub analysis_method { \n#-------------\n    my ($self, $method) = @_;  \n    if($method && ($method !~ /fgenesh/i)) {\n\t$self->throw(\"method $method not supported in \" . ref($self));\n    }\n    return $self->SUPER::analysis_method($method);\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : while($gene = $fgenesh->next_feature()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the Fgenesh result\n           file. Call this method repeatedly until FALSE is returned.\n\n           The returned object is actually a SeqFeatureI implementing object.\n           This method is required for classes implementing the\n           SeqAnalysisParserI interface, and is merely an alias for \n           next_prediction() at present.\n\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :\n\n\nsub next_feature {\n    my ($self,@args) = @_;\n    # even though next_prediction doesn't expect any args (and this method\n    # does neither), we pass on args in order to be prepared if this changes\n    # ever\n    return $self->next_prediction(@args);\n}\n\n=head2 next_prediction\n\n Title   : next_prediction\n Usage   : while($gene = $fgenesh->next_prediction()) { ... }\n Function: Returns the next gene structure prediction of the Genscan result\n           file. Call this method repeatedly until FALSE is returned.\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :\n\n\nsub next_prediction {\n    my ($self) = @_;\n    my $gene;\n\n    # if the prediction section hasn't been parsed yet, we do this now\n    $self->_parse_predictions() unless $self->_predictions_parsed();\n\n    # get next gene structure\n    $gene = $self->_prediction();\n\n    if($gene) {\n\t# fill in predicted protein, and if available the predicted CDS\n\t#\n\n\t# use the seq stack if there's a seq on it\n\tmy $seqobj = pop(@{$self->{'_seqstack'}});\n        my ($id, $seq);\n\tunless ($seqobj) {\n\t   ($id, $seq) = $self->_read_fasta_seq();\n           my $alphabet;\n           if (($id =~ /mrna/) || ($id =~ /cds/)) { $alphabet = 'dna'; }\n           else { $alphabet = 'protein'; }\n           $seqobj = Bio::PrimarySeq->new('-seq'        => $seq,\n                                          '-display_id' => $id,\n                                          '-alphabet'   => $alphabet); \n        }\n\tif ($seqobj) {\n\n\t    # check that prediction number matches the prediction number\n\t    # indicated in the sequence id (there may be incomplete gene\n\t    # predictions that contain only signals with no associated protein\n            # prediction.\n\n\t    $gene->primary_tag() =~ /[^0-9]([0-9]+)$/;\n\t    my $prednr = $1;\n\t    if ($id !~ /_predicted_(\\w+)_$prednr/) {\n\t\t# this is not our sequence, so push back for next prediction\n\t\tpush(@{$self->{'_seqstack'}}, $seqobj);\n\t    } else {\n                if ($1 eq \"protein\") {\n\t\t  $gene->predicted_protein($seqobj);\n                } elsif (($1 eq \"mrna\") || ($1 eq \"cds\")) {\n                  $self->_has_cds(1);\n                  $gene->predicted_cds($seqobj);\n                  \n                  # Have to go back in and get the protein...\n                  ($id, $seq) = $self->_read_fasta_seq();\n                  if ($id =~ /_cds_/) { \n                    ($id, $seq) = $self->_read_fasta_seq(); \n                  }\n \n\t\t  $seqobj = Bio::PrimarySeq->new('-seq' => $seq,\n\t\t\t    \t\t         '-display_id' => $id,\n\t\t\t\t\t\t '-alphabet' => \"protein\");\n\t\t  $gene->predicted_protein($seqobj);\n\t\t}\n\t    }\n\t}\n    }\n\n    return $gene;\n}\n\n=head2 _parse_predictions\n\n Title   : _parse_predictions()\n Usage   : $obj->_parse_predictions()\n Function: Parses the prediction section. Automatically called by\n           next_prediction() if not yet done.\n Example :\n Returns : \n\n\nsub _parse_predictions {\n    my ($self) = @_;\n    my $gene;\n    my $seqname;\n\n    while(defined($_ = $self->_readline())) {\n\n\tif(/^\\s*(\\d+)\\s+([+\\-])/) {\n            my $line = $_;\n\n\t    # exon or signal\n\t    my $prednr = $1;\n            my $strand = ($2 eq '+') ? 1 : -1;\n\n\t    if(! defined($gene)) {\n\t\t$gene = Bio::Tools::Prediction::Gene->new(\n                                       '-primary' => \"GenePrediction$prednr\",\n\t\t\t\t       '-source' => 'Fgenesh');\n\t    }\n\t    # split into fields\n\t    chomp();\n\t    my @flds = split(/\\s+/, ' ' . $line);\n\t    ## NB - the above adds leading whitespace before the gene\n\t    ## number in case there was none (as quick patch to code\n\t    ## below which expects it but it is not present after 999\n\t    ## predictions!) This allows >999 predictions to be parsed.\n\n\t    # create the feature object depending on the type of signal\n\t    my $predobj;\n\t    my $is_exon = grep {$line =~ $_} keys(%ExonTags);\n            my ($start, $end);\n\t    if($is_exon) {\n\t\t$predobj = Bio::Tools::Prediction::Exon->new();\n                $predobj->score($flds[8]);\n                $start   = $flds[5];\n                $end     = $flds[7];\n\t    } else {\n\t\t# PolyA site, or TSS \n\t\t$predobj = Bio::SeqFeature::Generic->new();\n                $predobj->score($flds[5]);\n                $start   = $flds[4];\n                $end     = $flds[4];\n\t    }\n\t    # set common fields\n\t    $predobj->source_tag('Fgenesh');\n\t    $predobj->strand($strand);\n\n# Following tactical commenting-out made by\n# malcolm.cook@stowers-institute.org since coordinate reversal is\n# apparently vestigial copy/paste detritus from Genscan.pm origins of\n# this module and this is NOT needed for fgenesh (at least in v\n# 2.1.4).\n\n#\t    if($predobj->strand() == 1) {\n\t\t$predobj->start($start);\n\t\t$predobj->end($end);\n#\t    } else {\n#\t\t$predobj->end($start);\n#\t\t$predobj->start($end);\n#\t    }\n\n            # print STDERR \"start $start end $end\\n\";\n\t    # add to gene structure (should be done only when start and end\n\t    # are set, in order to allow for proper expansion of the range)\n\t    if($is_exon) {\n\t\t# first, set fields unique to exons\n\t\t$predobj->primary_tag($ExonTags{$flds[4]} . 'Exon');\n\t\t$predobj->is_coding(1);\n\t\tmy $cod_offset;\n\t\tif($predobj->strand() == 1) {\n\t\t    $cod_offset = ($flds[9] - $predobj->start()) % 3;\n\t\t    # Possible values are -2, -1, 0, 1, 2. -1 and -2 correspond\n\t\t    # to offsets 2 and 1, resp. Offset 3 is the same as 0.\n\t\t    $cod_offset += 3 if($cod_offset < 1);\t\t    \n\t\t} else {\n\t\t    # On the reverse strand the Genscan frame also refers to\n\t\t    # the first base of the first complete codon, but viewed\n\t\t    # from forward, which is the third base viewed from\n\t\t    # reverse.\n\t\t    $cod_offset = ($flds[11] - $predobj->end()) % 3;\n\t\t    # Possible values are -2, -1, 0, 1, 2. Due to the reverse\n\t\t    # situation, {2,-1} and {1,-2} correspond to offsets\n\t\t    # 1 and 2, resp. Offset 3 is the same as 0.\n\t\t    $cod_offset -= 3 if($cod_offset >= 0);\n\t\t    $cod_offset = -$cod_offset;\n\t\t}\n\t\t# Offsets 2 and 1 correspond to frame 1 and 2 (frame of exon\n\t\t# is the frame of the first base relative to the exon, or the\n\t\t# number of bases the first codon is missing).\n\t\t$predobj->frame(3 - $cod_offset);\n                # print STDERR \"  frame is \" . $predobj->frame() . \"\\n\";\n\t\t# then add to gene structure object\n\t\t$gene->add_exon($predobj, $ExonTags{$flds[1]});\t\t\n\t    } elsif($flds[3] eq 'PolA') {\n\t\t$predobj->primary_tag(\"PolyAsite\");\n\t\t$gene->poly_A_site($predobj);\n\t    } elsif($flds[3] eq 'TSS') {\n\t        $predobj->primary_tag(\"Promoter\"); # (hey! a TSS is NOT a promoter... what's going on here?...\n\t\t$gene->add_promoter($predobj);\n                #I'd like to do this (for now):\n\t\t#$predobj->primary_tag(\"TSS\"); #this is not the right model, but, it IS a feature at least.\n                #but the followg errs out\n\t\t#$gene->add_SeqFeature($predobj); #err: MSG: start is undefined when bounds at Bio::SeqFeature::Generic::add_SeqFeature 671 check since gene has no start yet\n\t    }\n\t    else {\n\t      $self->throw(\"unrecognized prediction line: \" . $line);\n\t    }\n\t    next;\n\t}\n\n\tif(/^\\s*$/ && defined($gene)) {\n\t    # current gene is completed\n\t    $gene->seq_id($seqname);\n\t    $self->_add_prediction($gene);\n\t    $gene = undef;\n\t    next;\n\t}\n\n\tif(/^(FGENESH)\\s+([\\d\\.]+)/) {\n\t    $self->analysis_method($1);\n\t    $self->analysis_method_version($2);\n            if (/\\s(\\S+)\\sgenomic DNA/) {\n              $self->analysis_subject($1);\n            }\n\t    next;\n\t}\n\n\tif(/^\\s*Seq name:\\s+(\\S+)/) {\n\t    $seqname = $1;\n\t    next;\n\t}\n        \n\t/^Predicted protein/ && do {\n\t    # section of predicted sequences\n\t    $self->_pushback($_);\n\t    last;\n\t};\n    }\n\n    $self->_predictions_parsed(1);\n}\n\n=head2 _prediction\n\n Title   : _prediction()\n Usage   : $gene = $obj->_prediction()\n Function: internal\n Example :\n Returns : \n\n\nsub _prediction {\n    my ($self) = @_;\n\n    return unless(exists($self->{'_preds'}) && @{$self->{'_preds'}});\n    return shift(@{$self->{'_preds'}});\n}\n\n=head2 _add_prediction\n\n Title   : _add_prediction()\n Usage   : $obj->_add_prediction($gene)\n Function: internal\n Example :\n Returns : \n\n\nsub _add_prediction {\n    my ($self, $gene) = @_;\n\n    if(! exists($self->{'_preds'})) {\n\t$self->{'_preds'} = [];\n    }\n    push(@{$self->{'_preds'}}, $gene);\n}\n\n=head2 _predictions_parsed\n\n Title   : _predictions_parsed\n Usage   : $obj->_predictions_parsed\n Function: internal\n Example :\n Returns : TRUE or FALSE\n\n\nsub _predictions_parsed {\n    my ($self, $val) = @_;\n\n    $self->{'_preds_parsed'} = $val if $val;\n    if(! exists($self->{'_preds_parsed'})) {\n\t$self->{'_preds_parsed'} = 0;\n    }\n    return $self->{'_preds_parsed'};\n}\n\n=head2 _has_cds\n\n Title   : _has_cds()\n Usage   : $obj->_has_cds()\n Function: Whether or not the result contains the predicted CDSs, too.\n Example :\n Returns : TRUE or FALSE\n\n\nsub _has_cds {\n    my ($self, $val) = @_;\n\n    $self->{'_has_cds'} = $val if $val;\n    if(! exists($self->{'_has_cds'})) {\n\t$self->{'_has_cds'} = 0;\n    }\n    return $self->{'_has_cds'};\n}\n\n=head2 _read_fasta_seq\n\n Title   : _read_fasta_seq()\n Usage   : ($id,$seqstr) = $obj->_read_fasta_seq();\n Function: Simple but specialised FASTA format sequence reader. Uses\n           $self->_readline() to retrieve input, and is able to strip off\n           the traling description lines.\n Example :\n Returns : An array of two elements: fasta_id & sequence","parameters":[{"label":"$self"}],"label":"_read_fasta_seq($self)"},"detail":"($self)","definition":"sub","containerName":"main::","children":[{"localvar":"my","definition":"my","name":"$self","containerName":"_read_fasta_seq","line":500,"kind":13},{"containerName":"_read_fasta_seq","definition":"my","name":"$id","localvar":"my","kind":13,"line":501},{"kind":13,"line":501,"name":"$seq","containerName":"_read_fasta_seq"},{"line":504,"kind":13,"localvar":"my","name":"$entry","definition":"my","containerName":"_read_fasta_seq"},{"kind":13,"line":504,"containerName":"_read_fasta_seq","name":"$self"},{"kind":12,"line":504,"containerName":"_read_fasta_seq","name":"_readline"},{"line":506,"kind":13,"name":"$entry","containerName":"_read_fasta_seq"},{"line":507,"kind":13,"name":"$entry","containerName":"_read_fasta_seq"},{"kind":13,"line":507,"name":"$self","containerName":"_read_fasta_seq"},{"containerName":"_read_fasta_seq","name":"_readline","line":507,"kind":12},{"kind":13,"line":507,"name":"$entry","containerName":"_read_fasta_seq"},{"containerName":"_read_fasta_seq","name":"$entry","line":511,"kind":13},{"line":512,"kind":13,"name":"$entry","containerName":"_read_fasta_seq"},{"line":514,"kind":13,"name":"$id","containerName":"_read_fasta_seq"},{"kind":13,"line":515,"containerName":"_read_fasta_seq","name":"$entry"},{"kind":13,"line":517,"name":"$id","containerName":"_read_fasta_seq"},{"name":"$entry","containerName":"_read_fasta_seq","kind":13,"line":518},{"name":"$id","containerName":"_read_fasta_seq","line":519,"kind":13},{"name":"$seq","containerName":"_read_fasta_seq","kind":13,"line":521},{"kind":13,"line":522,"containerName":"_read_fasta_seq","name":"$entry"},{"name":"$self","containerName":"_read_fasta_seq","kind":13,"line":522},{"kind":12,"line":522,"name":"_readline","containerName":"_read_fasta_seq"},{"definition":"my","name":"$done","containerName":"_read_fasta_seq","localvar":"my","kind":13,"line":525},{"containerName":"_read_fasta_seq","name":"$done","line":526,"kind":13},{"kind":13,"line":528,"name":"$entry","containerName":"_read_fasta_seq"},{"containerName":"_read_fasta_seq","name":"$id","line":528,"kind":13},{"kind":13,"line":530,"name":"$entry","containerName":"_read_fasta_seq"},{"containerName":"_read_fasta_seq","name":"$self","line":530,"kind":13},{"line":530,"kind":12,"name":"_readline","containerName":"_read_fasta_seq"},{"containerName":"_read_fasta_seq","name":"$seq","line":532,"kind":13},{"kind":13,"line":532,"name":"$entry","containerName":"_read_fasta_seq"},{"containerName":"_read_fasta_seq","name":"$entry","line":536,"kind":13},{"kind":13,"line":536,"containerName":"_read_fasta_seq","name":"$self"},{"containerName":"_read_fasta_seq","name":"_readline","line":536,"kind":12},{"containerName":"_read_fasta_seq","name":"$entry","kind":13,"line":537},{"kind":13,"line":538,"name":"$entry","containerName":"_read_fasta_seq"},{"name":"$id","containerName":"_read_fasta_seq","kind":13,"line":538},{"line":539,"kind":13,"containerName":"_read_fasta_seq","name":"$self"},{"name":"_pushback","containerName":"_read_fasta_seq","line":539,"kind":12},{"name":"$entry","containerName":"_read_fasta_seq","line":539,"kind":13},{"line":544,"kind":13,"containerName":"_read_fasta_seq","name":"$seq"},{"kind":13,"line":545,"containerName":"_read_fasta_seq","name":"$id"},{"line":545,"kind":13,"name":"$seq","containerName":"_read_fasta_seq"}],"line":499,"kind":12,"range":{"start":{"character":0,"line":499},"end":{"line":546,"character":9999}},"name":"_read_fasta_seq"}],"version":5}