{"version":5,"vars":[{"containerName":"","name":"vars","line":113,"kind":2},{"containerName":"strict::IO::String::Bio::SeqIO::HTTP::Request","name":"Common","line":117,"kind":2},{"line":120,"kind":2,"name":"base","containerName":""},{"kind":13,"line":122,"containerName":null,"name":"$FLOAT"},{"line":123,"kind":13,"localvar":"my","containerName":null,"definition":"my","name":"$URL"},{"localvar":"my","containerName":null,"definition":"my","name":"%ANALYSIS_SPEC","line":126,"kind":13},{"kind":13,"line":137,"containerName":null,"name":"@INPUT_SPEC","definition":"my","localvar":"my"},{"line":152,"kind":13,"localvar":"my","definition":"my","name":"%RESULT_SPEC","containerName":null},{"line":198,"children":[{"localvar":"my","containerName":"result","definition":"my","name":"$self","line":199,"kind":13},{"line":199,"kind":13,"containerName":"result","name":"$value"},{"line":201,"kind":13,"localvar":"my","name":"@predictions","definition":"my","containerName":"result"},{"line":202,"kind":13,"localvar":"my","containerName":"result","name":"@fts","definition":"my"},{"name":"$value","containerName":"result","kind":13,"line":204},{"localvar":"my","name":"$result","definition":"my","containerName":"result","line":206,"kind":13},{"containerName":"result","name":"new","kind":12,"line":206},{"kind":13,"line":206,"name":"$self","containerName":"result"},{"name":"$result","containerName":"result","line":207,"kind":13},{"kind":13,"line":210,"name":"$self","containerName":"result"},{"kind":12,"line":210,"name":"threshold","containerName":"result"},{"name":"@predictions","containerName":"result","line":211,"kind":13},{"kind":13,"line":213,"name":"$value","containerName":"result"},{"containerName":"result","name":"@predictions","line":214,"kind":13},{"containerName":"result","name":"@fts","line":215,"kind":13},{"line":216,"kind":12,"name":"new","containerName":"result"},{"kind":13,"line":224,"name":"@fts","containerName":"result"},{"containerName":"result","name":"@predictions","kind":13,"line":226},{"name":"$self","containerName":"result","line":229,"kind":13}],"kind":12,"detail":"($self,$value)","signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: NetPhos.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Analysis::Protein::NetPhos\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Richard Adams\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Analysis::Protein::NetPhos - a wrapper around NetPhos server\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::Analysis::Protein::NetPhos;\n\n  my $seq; # a Bio::PrimarySeqI object\n  my $threshold  = \"0.90\";\n\n  my $netphos = Bio::Tools::Analysis::Protein::NetPhos->new\n     ( -seq => $seq,\n       -threshold => $threshold );\n\n  # run NetPhos prediction on a sequence\n  my $netphos->run();\n\n  # alternatively you can say\n  $netphos->seq($seq)->threshold($threshold)->run;\n\n  die \"Could not get a result\" unless $netphos->status =~ /^COMPLETED/;\n\n  print $netphos->result;     # print raw prediction to STDOUT\n\n  foreach my $feat ( $netphos->result('Bio::SeqFeatureI') ) {\n\n      # do something to SeqFeature\n      # e.g. print as GFF\n      print $feat->gff_string, \"\\n\";\n      # or store within the sequence - if it is a Bio::RichSeqI\n      $seq->add_SeqFeature($feat)\n\n }\n\n=head1 DESCRIPTION\n\nThis class is wrapper around the NetPhos 2.0 server which produces\nneural network predictions for serine, threonine and tyrosine\nphosphorylation sites in eukaryotic proteins.\n\nSee L<http://www.cbs.dtu.dk/services/NetPhos/>.\n\nThis the first implentation of Bio::SimpleAnalysisI which hopefully\nwill make it easier to write wrappers on various services. This class\nuses a web resource and therefore inherits from Bio::WebAgent.\n\n=head1 SEE ALSO\n\nL<Bio::SimpleAnalysisI>, \nL<Bio::WebAgent>\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS\n\nRichard Adams, Richard.Adams@ed.ac.uk, \nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Analysis::Protein::NetPhos;\nuse vars qw($FLOAT);\nuse strict;\nuse IO::String;\nuse Bio::SeqIO;\nuse HTTP::Request::Common qw (POST);\nuse Bio::SeqFeature::Generic;\n\nuse base qw(Bio::Tools::Analysis::SimpleAnalysisBase);\n\n    $FLOAT = '[+-]?\\d*\\.\\d*';\n    my $URL = 'http://www.cbs.dtu.dk/cgi-bin/nph-webface';\n\n\n    my $ANALYSIS_SPEC =\n        {\n         'name'        => 'NetPhos',\n         'type'        => 'Protein',\n         'version'     => '2.0',\n         'supplier'    => 'Center for Biological Sequence Analysis,\n                           Technical University of Denmark',\n         'description' => 'Prediction of serine, threonine and tyrosine\n                             phosphorylation sites in eukaryotic proteins',\n        };\n\n    my $INPUT_SPEC =\n        [\n         {\n          'mandatory' => 'true',\n          'type'      => 'Bio::PrimarySeqI',\n          'name'      => 'seq',\n         },\n         {\n          'mandatory' => 'false',\n          'type'      => 'float',\n          'name'      => 'threshold',\n          'default'   => 0.8,\n         }\n        ];\n\n    my $RESULT_SPEC =\n        {\n         ''                 => 'bulk',  # same as undef\n         'Bio::SeqFeatureI' => 'ARRAY of Bio::SeqFeeature::Generic',\n         'raw'              => 'Array of [ position, score, residue ]'\n        };\n\n\n=head2 result\n\n Name    : result\n Usage   : $job->result (...)\n Returns : a result created by running an analysis\n Args    : none (but an implementation may choose\n           to add arguments for instructions how to process\n           the raw result)\n\nThe method returns a scalar representing a result of an executed\njob. If the job was terminated by an error the result may contain an\nerror message instead of the real data (or both, depending on the\nimplementation).\n\nThis implementation returns differently processed data depending on\nargument:\n\n=over 3\n\n* undef\n\nReturns the raw ASCII data stream but without HTML tags\n\n* 'Bio::SeqFeatureI'\n\nThe argument string defined the type of bioperl objects returned in an\narray.  The objects are L<Bio::SeqFeature::Generic>.\n\n* anything else\n\nArray of array references of [ position, score, residue].","label":"result($self,$value)"},"containerName":"main::","definition":"sub","range":{"start":{"line":198,"character":0},"end":{"line":230,"character":9999}},"name":"result"},{"containerName":"String","name":"IO","line":206,"kind":12},{"line":215,"kind":12,"name":"Bio","containerName":"SeqFeature::Generic"},{"kind":12,"line":221,"name":"score"},{"line":222,"kind":12,"name":"residue"},{"range":{"start":{"character":0,"line":241},"end":{"line":251,"character":9999}},"name":"threshold","detail":"($self,$value)","signature":{"documentation":"1;\n# $Id: NetPhos.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Analysis::Protein::NetPhos\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Richard Adams\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Analysis::Protein::NetPhos - a wrapper around NetPhos server\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::Analysis::Protein::NetPhos;\n\n  my $seq; # a Bio::PrimarySeqI object\n  my $threshold  = \"0.90\";\n\n  my $netphos = Bio::Tools::Analysis::Protein::NetPhos->new\n     ( -seq => $seq,\n       -threshold => $threshold );\n\n  # run NetPhos prediction on a sequence\n  my $netphos->run();\n\n  # alternatively you can say\n  $netphos->seq($seq)->threshold($threshold)->run;\n\n  die \"Could not get a result\" unless $netphos->status =~ /^COMPLETED/;\n\n  print $netphos->result;     # print raw prediction to STDOUT\n\n  foreach my $feat ( $netphos->result('Bio::SeqFeatureI') ) {\n\n      # do something to SeqFeature\n      # e.g. print as GFF\n      print $feat->gff_string, \"\\n\";\n      # or store within the sequence - if it is a Bio::RichSeqI\n      $seq->add_SeqFeature($feat)\n\n }\n\n=head1 DESCRIPTION\n\nThis class is wrapper around the NetPhos 2.0 server which produces\nneural network predictions for serine, threonine and tyrosine\nphosphorylation sites in eukaryotic proteins.\n\nSee L<http://www.cbs.dtu.dk/services/NetPhos/>.\n\nThis the first implentation of Bio::SimpleAnalysisI which hopefully\nwill make it easier to write wrappers on various services. This class\nuses a web resource and therefore inherits from Bio::WebAgent.\n\n=head1 SEE ALSO\n\nL<Bio::SimpleAnalysisI>, \nL<Bio::WebAgent>\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS\n\nRichard Adams, Richard.Adams@ed.ac.uk, \nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Analysis::Protein::NetPhos;\nuse vars qw($FLOAT);\nuse strict;\nuse IO::String;\nuse Bio::SeqIO;\nuse HTTP::Request::Common qw (POST);\nuse Bio::SeqFeature::Generic;\n\nuse base qw(Bio::Tools::Analysis::SimpleAnalysisBase);\n\n    $FLOAT = '[+-]?\\d*\\.\\d*';\n    my $URL = 'http://www.cbs.dtu.dk/cgi-bin/nph-webface';\n\n\n    my $ANALYSIS_SPEC =\n        {\n         'name'        => 'NetPhos',\n         'type'        => 'Protein',\n         'version'     => '2.0',\n         'supplier'    => 'Center for Biological Sequence Analysis,\n                           Technical University of Denmark',\n         'description' => 'Prediction of serine, threonine and tyrosine\n                             phosphorylation sites in eukaryotic proteins',\n        };\n\n    my $INPUT_SPEC =\n        [\n         {\n          'mandatory' => 'true',\n          'type'      => 'Bio::PrimarySeqI',\n          'name'      => 'seq',\n         },\n         {\n          'mandatory' => 'false',\n          'type'      => 'float',\n          'name'      => 'threshold',\n          'default'   => 0.8,\n         }\n        ];\n\n    my $RESULT_SPEC =\n        {\n         ''                 => 'bulk',  # same as undef\n         'Bio::SeqFeatureI' => 'ARRAY of Bio::SeqFeeature::Generic',\n         'raw'              => 'Array of [ position, score, residue ]'\n        };\n\n\n=head2 result\n\n Name    : result\n Usage   : $job->result (...)\n Returns : a result created by running an analysis\n Args    : none (but an implementation may choose\n           to add arguments for instructions how to process\n           the raw result)\n\nThe method returns a scalar representing a result of an executed\njob. If the job was terminated by an error the result may contain an\nerror message instead of the real data (or both, depending on the\nimplementation).\n\nThis implementation returns differently processed data depending on\nargument:\n\n=over 3\n\n* undef\n\nReturns the raw ASCII data stream but without HTML tags\n\n* 'Bio::SeqFeatureI'\n\nThe argument string defined the type of bioperl objects returned in an\narray.  The objects are L<Bio::SeqFeature::Generic>.\n\n* anything else\n\nArray of array references of [ position, score, residue].\n\n\n\n\n\nsub result {\n    my ($self,$value) = @_;\n\n    my @predictions;\n    my @fts;\n\n    if ($value ) {\n\n        my $result = IO::String->new($self->{'_result'});\n        while (<$result>) {\n            next if /^____/;\n            /^\\S+ +(\\d+) +\\w+ +(0\\.\\d+) +.([STY])/;\n            next unless $3 and $2 > $self->threshold;\n            push @predictions, [$1, $2, $3];\n        }\n        if ($value eq 'Bio::SeqFeatureI') {\n            foreach  (@predictions) {\n                push @fts, Bio::SeqFeature::Generic->new\n                    (-start   => $_->[0],\n                     -end     => $_->[0] ,\n                     -source  => 'NetPhos',\n                     -primary => 'Site',\n                     -tag     => {\n                               score   => $_->[1],\n                               residue => $_->[2] });\n            }\n            return @fts;\n        }\n        return \\@predictions;\n    }\n\n    return $self->{'_result'};\n}\n\n=head2  threshold\n\n Usage   : $job->threshold(...)\n Returns  : The significance threshold of a prediction\n Args     : None (retrieves value) or a value beween 0 and 1.\n Purpose  : Get/setter of the threshold to be sumitted for analysis.","parameters":[{"label":"$self"},{"label":"$value"}],"label":"threshold($self,$value)"},"containerName":"main::","definition":"sub","line":241,"children":[{"localvar":"my","containerName":"threshold","definition":"my","name":"$self","line":242,"kind":13},{"containerName":"threshold","name":"$value","line":242,"kind":13},{"line":243,"kind":13,"name":"$value","containerName":"threshold"},{"name":"$value","containerName":"threshold","line":244,"kind":13},{"name":"$value","containerName":"threshold","line":244,"kind":13},{"containerName":"threshold","name":"$value","kind":13,"line":244},{"name":"$self","containerName":"threshold","kind":13,"line":245},{"kind":12,"line":245,"containerName":"threshold","name":"throw"},{"containerName":"threshold","name":"$value","line":245,"kind":13},{"containerName":"threshold","name":"$self","line":247,"kind":13},{"containerName":"threshold","name":"$value","kind":13,"line":247},{"kind":13,"line":248,"name":"$self","containerName":"threshold"},{"line":250,"kind":13,"name":"$self","containerName":"threshold"},{"kind":13,"line":250,"containerName":"threshold","name":"$self"},{"kind":12,"line":250,"name":"input_spec","containerName":"threshold"}],"kind":12},{"containerName":"main::","definition":"sub","name":"_init","range":{"start":{"line":253,"character":0},"end":{"line":262,"character":9999}},"kind":12,"line":253,"children":[{"line":255,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"_init"},{"kind":13,"line":256,"name":"$self","containerName":"_init"},{"line":256,"kind":12,"containerName":"_init","name":"url"},{"kind":13,"line":256,"name":"$URL","containerName":"_init"},{"name":"$self","containerName":"_init","kind":13,"line":257},{"name":"$ANALYSIS_SPEC","containerName":"_init","kind":13,"line":257},{"line":258,"kind":13,"name":"$self","containerName":"_init"},{"line":258,"kind":13,"containerName":"_init","name":"$INPUT_SPEC"},{"containerName":"_init","name":"$self","line":259,"kind":13},{"name":"$RESULT_SPEC","containerName":"_init","line":259,"kind":13},{"kind":13,"line":260,"name":"$self","containerName":"_init"},{"containerName":"_init","name":"$ANALYSIS_SPEC","kind":13,"line":260},{"kind":13,"line":261,"name":"$self","containerName":"_init"}]},{"line":260,"kind":12,"name":"name"},{"line":264,"children":[{"localvar":"my","containerName":"_run","name":"$self","definition":"my","line":265,"kind":13},{"containerName":"_run","definition":"my","name":"$seq_fasta","localvar":"my","kind":13,"line":268},{"kind":13,"line":269,"definition":"my","name":"$stringfh","containerName":"_run","localvar":"my"},{"name":"$seq_fasta","containerName":"_run","kind":13,"line":269},{"localvar":"my","definition":"my","name":"$seqout","containerName":"_run","line":270,"kind":13},{"name":"new","containerName":"_run","line":270,"kind":12},{"line":270,"kind":13,"name":"$stringfh","containerName":"_run"},{"name":"$seqout","containerName":"_run","kind":13,"line":272},{"name":"write_seq","containerName":"_run","kind":12,"line":272},{"line":272,"kind":13,"containerName":"_run","name":"$self"},{"name":"seq","containerName":"_run","kind":12,"line":272},{"containerName":"_run","name":"$self","kind":13,"line":273},{"line":273,"kind":12,"name":"debug","containerName":"_run"},{"name":"$seq_fasta","containerName":"_run","line":273,"kind":13},{"containerName":"_run","name":"$self","line":276,"kind":13},{"kind":12,"line":276,"containerName":"_run","name":"sleep"},{"kind":13,"line":278,"containerName":"_run","name":"$self"},{"name":"status","containerName":"_run","line":278,"kind":12},{"line":280,"kind":13,"localvar":"my","containerName":"_run","name":"$request","definition":"my"},{"line":280,"kind":13,"name":"$self","containerName":"_run"},{"containerName":"_run","name":"url","kind":12,"line":280},{"name":"$seq_fasta","containerName":"_run","line":283,"kind":13},{"name":"$content","definition":"my","containerName":"_run","localvar":"my","kind":13,"line":284},{"kind":13,"line":284,"containerName":"_run","name":"$self"},{"containerName":"_run","name":"request","kind":12,"line":284},{"name":"$request","containerName":"_run","line":284,"kind":13},{"localvar":"my","containerName":"_run","definition":"my","name":"$text","line":285,"kind":13},{"name":"$content","containerName":"_run","line":285,"kind":13},{"line":285,"kind":12,"name":"content","containerName":"_run"},{"localvar":"my","name":"$result_url","definition":"my","containerName":"_run","line":287,"kind":13},{"line":287,"kind":13,"name":"$text","containerName":"_run"},{"name":"$result_url","containerName":"_run","kind":13,"line":288},{"containerName":"_run","name":"$self","kind":13,"line":289},{"name":"debug","containerName":"_run","line":289,"kind":12},{"line":291,"kind":13,"localvar":"my","definition":"my","name":"$ua2","containerName":"_run"},{"name":"$self","containerName":"_run","line":291,"kind":13},{"name":"clone","containerName":"_run","line":291,"kind":12},{"kind":13,"line":292,"definition":"my","name":"$content2","containerName":"_run","localvar":"my"},{"line":292,"kind":13,"name":"$ua2","containerName":"_run"},{"containerName":"_run","name":"request","line":292,"kind":12},{"name":"$result_url","containerName":"_run","kind":13,"line":292},{"localvar":"my","name":"$ua3","definition":"my","containerName":"_run","line":294,"kind":13},{"line":294,"kind":13,"containerName":"_run","name":"$self"},{"line":294,"kind":12,"containerName":"_run","name":"clone"},{"kind":13,"line":295,"containerName":"_run","name":"$result_url"},{"name":"$self","containerName":"_run","line":296,"kind":13},{"name":"debug","containerName":"_run","kind":12,"line":296},{"name":"$content3","definition":"my","containerName":"_run","localvar":"my","kind":13,"line":297},{"name":"$ua3","containerName":"_run","kind":13,"line":297},{"containerName":"_run","name":"request","line":297,"kind":12},{"containerName":"_run","name":"$result_url","line":297,"kind":13},{"line":299,"kind":13,"localvar":"my","containerName":"_run","definition":"my","name":"$response"},{"kind":13,"line":299,"name":"$content3","containerName":"_run"},{"containerName":"_run","name":"content","line":299,"kind":12},{"containerName":"_run","name":"$response","line":302,"kind":13},{"kind":13,"line":303,"name":"$response","containerName":"_run"},{"kind":13,"line":305,"name":"$self","containerName":"_run"},{"kind":13,"line":305,"containerName":"_run","name":"$response"},{"name":"$self","containerName":"_run","line":307,"kind":13},{"line":307,"kind":12,"name":"status","containerName":"_run"},{"name":"$response","containerName":"_run","kind":13,"line":307}],"kind":12,"range":{"start":{"line":264,"character":0},"end":{"character":9999,"line":309}},"containerName":"main::","definition":"sub","name":"_run"},{"name":"new","line":269,"kind":12},{"name":"IO","containerName":"String","kind":12,"line":269},{"line":270,"kind":12,"name":"Bio","containerName":"SeqIO"},{"name":"POST","line":280,"kind":12},{"name":"Content_Type","kind":12,"line":281},{"line":282,"kind":12,"name":"Content"},{"line":282,"kind":12,"name":"configfile"},{"name":"SEQPASTE","line":283,"kind":12},{"line":292,"kind":12,"name":"POST"},{"kind":12,"line":297,"name":"POST"}]}