{"vars":[{"line":114,"kind":2,"name":"Dumpvalue","containerName":""},{"line":118,"kind":2,"name":"base","containerName":""},{"line":120,"kind":13,"name":"%DEFAULTS","definition":"our","containerName":"main::"},{"range":{"start":{"character":0,"line":142},"end":{"character":9999,"line":165}},"name":"new","signature":{"documentation":"1;\n# $Id: Consed.pm 16123 2009-09-17 12:57:27Z cjfields $\n# Bio::Tools::Alignment::Consed\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chad Matsalla\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Alignment::Consed - A module to work with objects from consed .ace files\n\n=head1 SYNOPSIS\n\n  # a report for sequencing stuff\n  my $o_consed = Bio::Tools::Alignment::Consed->new( \n      -acefile => \"/path/to/an/acefile.ace.1\",\n      -verbose => 1);\n  my $foo = $o_consed->set_reverse_designator(\"r\");\n  my $bar = $o_consed->set_forward_designator(\"f\");\n\n  # get the contig numbers\n  my @keys = $o_consed->get_contigs();\n\n  # construct the doublets\n  my $setter_doublets = $o_consed->choose_doublets();\n\n  # get the doublets\n  my @doublets = $o_consed->get_doublets();\n\n=head1 DESCRIPTION\n\nL<Bio::Tools::Alignment::Consed> provides methods and objects to deal\nwith the output from the Consed software suite. Specifically,\ntakes an C<.ace> file and provides objects for the results.\n\nA word about doublets: This module was written to accomodate a large\nEST sequencing operation. In this case, EST's were sequenced from the\n3' and from the 5' end of the EST. The objective was to find a\nconsensus sequence for these two reads.  Thus, a contig of two is what\nwe wanted, and this contig should consist of the forward and reverse\nreads of a getn clone. For example, for a forward designator of \"F\"\nand a reverse designator of \"R\", if the two reads chad1F and chad1R\nwere in a single contig (for example Contig 5) it will be determined\nthat the consensus sequence for Contig 5 will be the sequence for\nclone chad1.\n\nDoublets are good!\n\nThis module parses C<.ace> and related files. A detailed list of methods\ncan be found at the end of this document.\n\nI wrote a detailed rationale for design that may explain the reasons\nwhy some things were done the way they were done. That document is\nbeyond the scope of this pod and can probably be found in the\ndirectory from which this module was 'made' or at\nL<http://www.dieselwurks.com/bioinformatics/consedpm_documentation.pdf>.\n\nNote that the POD in that document might be old but the original\nrationale still stands.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nEmail chad-at-dieselwurks.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n#' \n\npackage Bio::Tools::Alignment::Consed;\n\nuse strict;\n\nuse FileHandle;\nuse Dumpvalue qw(dumpValue);\nuse Bio::Tools::Alignment::Trim;\nuse File::Spec;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\nour %DEFAULTS = ( 'f_designator' => 'f',\n\t\t  'r_designator' => 'r');\n\n=head2 new()\n\n Title   : new(-acefile => $path_to_some_acefile, -verbose => \"1\")\n Usage   : $o_consed = Bio::Tools::Alignment::Consed->\n              new(-acefile => $path_to_some_acefile, -verbose => \"1\");\n Function: Construct the Bio::Tools::Alignment::Consed object. Sets\n\t   verbosity for the following procedures, if necessary:\n\t   1. Construct a new Bio::Tools::Alignment::Trim object, to\n\t   handle quality trimming 2. Read in the acefile and parse it\n\n Returns : A reference to a Bio::Tools::Alignment::Consed object.\n Args    : A hash. (-acefile) is the filename of an acefile. If a full path\n\t   is not specified \"./\" is prepended to the filename and used from\n\t   instantiation until destruction. If you want \n           Bio::Tools::Alignment::Consed to be noisy during parsing of\n           the acefile, specify some value for (-verbose).","parameters":[{"label":"$class"},{"label":"%args"}],"label":"new($class,%args)"},"detail":"($class,%args)","definition":"sub","containerName":"main::","children":[{"kind":13,"line":143,"definition":"my","name":"$class","containerName":"new","localvar":"my"},{"containerName":"new","name":"%args","kind":13,"line":143},{"localvar":"my","containerName":"new","name":"$self","definition":"my","line":144,"kind":13},{"line":144,"kind":13,"containerName":"new","name":"$class"},{"kind":13,"line":144,"containerName":"new","name":"%args"},{"name":"$self","containerName":"new","line":146,"kind":13},{"kind":13,"line":146,"containerName":"new","name":"$args"},{"line":156,"kind":13,"containerName":"new","name":"$self"},{"line":156,"kind":12,"containerName":"new","name":"splitpath"},{"name":"$self","containerName":"new","line":156,"kind":13},{"line":158,"kind":13,"name":"$self","containerName":"new"},{"line":158,"kind":12,"containerName":"new","name":"_initialize_io"},{"containerName":"new","name":"$self","line":158,"kind":13},{"line":159,"kind":13,"containerName":"new","name":"$self"},{"line":159,"kind":12,"name":"new","containerName":"new"},{"line":159,"kind":13,"containerName":"new","name":"$self"},{"name":"verbose","containerName":"new","kind":12,"line":159},{"name":"$self","containerName":"new","kind":13,"line":160},{"kind":12,"line":160,"name":"set_forward_designator","containerName":"new"},{"name":"$DEFAULTS","containerName":"new","kind":13,"line":160},{"line":161,"kind":13,"containerName":"new","name":"$self"},{"name":"set_reverse_designator","containerName":"new","line":161,"kind":12},{"containerName":"new","name":"$DEFAULTS","kind":13,"line":161},{"line":163,"kind":13,"containerName":"new","name":"$self"},{"line":163,"kind":12,"name":"_read_file","containerName":"new"},{"containerName":"new","name":"$self","line":164,"kind":13}],"line":142,"kind":12},{"kind":12,"line":144,"containerName":"new","name":"SUPER"},{"containerName":"Spec","name":"File","line":156,"kind":12},{"line":159,"kind":12,"name":"Bio","containerName":"Tools::Alignment::Trim"},{"range":{"start":{"line":191,"character":0},"end":{"character":9999,"line":191}},"definition":"sub","name":"set_verbose","containerName":"main::","children":[{"line":191,"kind":12,"containerName":"set_verbose","name":"verbose"}],"line":191,"kind":12},{"kind":12,"line":205,"children":[{"kind":13,"line":206,"definition":"my","name":"$self","containerName":"get_filename","localvar":"my"},{"line":207,"kind":13,"name":"$self","containerName":"get_filename"}],"containerName":"main::","name":"get_filename","definition":"sub","range":{"start":{"line":205,"character":0},"end":{"line":208,"character":9999}}},{"range":{"end":{"line":252,"character":9999},"start":{"character":0,"line":232}},"definition":"sub","name":"count_sequences_with_grep","containerName":"main::","children":[{"kind":13,"line":233,"containerName":"count_sequences_with_grep","definition":"my","name":"$self","localvar":"my"},{"line":234,"kind":13,"localvar":"my","containerName":"count_sequences_with_grep","name":"$working_dir","definition":"my"},{"line":234,"kind":13,"containerName":"count_sequences_with_grep","name":"$grep_cli"},{"containerName":"count_sequences_with_grep","name":"@total_grep_sequences","kind":13,"line":234},{"line":239,"kind":13,"localvar":"my","definition":"my","name":"$FILE","containerName":"count_sequences_with_grep"},{"line":239,"kind":13,"name":"$self","containerName":"count_sequences_with_grep"},{"containerName":"count_sequences_with_grep","name":"$self","line":239,"kind":13},{"kind":12,"line":239,"name":"warn","containerName":"count_sequences_with_grep"},{"containerName":"count_sequences_with_grep","name":"$self","kind":13,"line":239},{"localvar":"my","containerName":"count_sequences_with_grep","name":"$counter","definition":"my","line":240,"kind":13},{"line":241,"kind":13,"containerName":"count_sequences_with_grep","name":"$FILE"},{"containerName":"count_sequences_with_grep","name":"$counter","kind":13,"line":241},{"line":243,"kind":13,"name":"$FILE","containerName":"count_sequences_with_grep"},{"line":244,"kind":13,"localvar":"my","containerName":"count_sequences_with_grep","definition":"my","name":"$SINGLETS"},{"line":244,"kind":13,"name":"$self","containerName":"count_sequences_with_grep"},{"line":245,"kind":13,"localvar":"my","containerName":"count_sequences_with_grep","name":"$f","definition":"my"},{"containerName":"count_sequences_with_grep","name":"$SINGLETS","kind":13,"line":245},{"line":246,"kind":13,"containerName":"count_sequences_with_grep","name":"$f"},{"localvar":"my","name":"$FILE","definition":"my","containerName":"count_sequences_with_grep","line":247,"kind":13},{"containerName":"count_sequences_with_grep","name":"catfile","line":247,"kind":12},{"line":247,"kind":13,"name":"$self","containerName":"count_sequences_with_grep"},{"kind":13,"line":247,"name":"$f","containerName":"count_sequences_with_grep"},{"name":"$self","containerName":"count_sequences_with_grep","kind":13,"line":247},{"line":247,"kind":12,"name":"warn","containerName":"count_sequences_with_grep"},{"kind":12,"line":247,"name":"catfile","containerName":"count_sequences_with_grep"},{"line":247,"kind":13,"name":"$self","containerName":"count_sequences_with_grep"},{"name":"$f","containerName":"count_sequences_with_grep","kind":13,"line":247},{"kind":13,"line":248,"name":"$FILE","containerName":"count_sequences_with_grep"},{"kind":13,"line":248,"name":"$counter","containerName":"count_sequences_with_grep"},{"containerName":"count_sequences_with_grep","name":"$FILE","kind":13,"line":249},{"line":251,"kind":13,"containerName":"count_sequences_with_grep","name":"$counter"}],"line":232,"kind":12},{"containerName":"Spec","name":"File","line":247,"kind":12},{"kind":12,"line":247,"containerName":"Spec","name":"File"},{"line":264,"children":[{"kind":13,"line":265,"definition":"my","name":"$self","containerName":"get_path","localvar":"my"},{"name":"$self","containerName":"get_path","line":266,"kind":13}],"kind":12,"range":{"end":{"character":9999,"line":267},"start":{"line":264,"character":0}},"containerName":"main::","definition":"sub","name":"get_path"},{"range":{"start":{"line":284,"character":0},"end":{"character":9999,"line":286}},"name":"get_contigs","line":284,"children":[{"definition":"my","name":"$self","containerName":"get_contigs","localvar":"my","kind":13,"line":285},{"kind":13,"line":285,"containerName":"get_contigs","name":"$contig"},{"localvar":"my","containerName":"get_contigs","definition":"my","name":"@contigs","line":286,"kind":13},{"name":"$self","containerName":"get_contigs","line":286,"kind":13}],"kind":12,"detail":"($self,$contig)","signature":{"documentation":"1;\n# $Id: Consed.pm 16123 2009-09-17 12:57:27Z cjfields $\n# Bio::Tools::Alignment::Consed\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chad Matsalla\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Alignment::Consed - A module to work with objects from consed .ace files\n\n=head1 SYNOPSIS\n\n  # a report for sequencing stuff\n  my $o_consed = Bio::Tools::Alignment::Consed->new( \n      -acefile => \"/path/to/an/acefile.ace.1\",\n      -verbose => 1);\n  my $foo = $o_consed->set_reverse_designator(\"r\");\n  my $bar = $o_consed->set_forward_designator(\"f\");\n\n  # get the contig numbers\n  my @keys = $o_consed->get_contigs();\n\n  # construct the doublets\n  my $setter_doublets = $o_consed->choose_doublets();\n\n  # get the doublets\n  my @doublets = $o_consed->get_doublets();\n\n=head1 DESCRIPTION\n\nL<Bio::Tools::Alignment::Consed> provides methods and objects to deal\nwith the output from the Consed software suite. Specifically,\ntakes an C<.ace> file and provides objects for the results.\n\nA word about doublets: This module was written to accomodate a large\nEST sequencing operation. In this case, EST's were sequenced from the\n3' and from the 5' end of the EST. The objective was to find a\nconsensus sequence for these two reads.  Thus, a contig of two is what\nwe wanted, and this contig should consist of the forward and reverse\nreads of a getn clone. For example, for a forward designator of \"F\"\nand a reverse designator of \"R\", if the two reads chad1F and chad1R\nwere in a single contig (for example Contig 5) it will be determined\nthat the consensus sequence for Contig 5 will be the sequence for\nclone chad1.\n\nDoublets are good!\n\nThis module parses C<.ace> and related files. A detailed list of methods\ncan be found at the end of this document.\n\nI wrote a detailed rationale for design that may explain the reasons\nwhy some things were done the way they were done. That document is\nbeyond the scope of this pod and can probably be found in the\ndirectory from which this module was 'made' or at\nL<http://www.dieselwurks.com/bioinformatics/consedpm_documentation.pdf>.\n\nNote that the POD in that document might be old but the original\nrationale still stands.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nEmail chad-at-dieselwurks.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n#' \n\npackage Bio::Tools::Alignment::Consed;\n\nuse strict;\n\nuse FileHandle;\nuse Dumpvalue qw(dumpValue);\nuse Bio::Tools::Alignment::Trim;\nuse File::Spec;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\nour %DEFAULTS = ( 'f_designator' => 'f',\n\t\t  'r_designator' => 'r');\n\n=head2 new()\n\n Title   : new(-acefile => $path_to_some_acefile, -verbose => \"1\")\n Usage   : $o_consed = Bio::Tools::Alignment::Consed->\n              new(-acefile => $path_to_some_acefile, -verbose => \"1\");\n Function: Construct the Bio::Tools::Alignment::Consed object. Sets\n\t   verbosity for the following procedures, if necessary:\n\t   1. Construct a new Bio::Tools::Alignment::Trim object, to\n\t   handle quality trimming 2. Read in the acefile and parse it\n\n Returns : A reference to a Bio::Tools::Alignment::Consed object.\n Args    : A hash. (-acefile) is the filename of an acefile. If a full path\n\t   is not specified \"./\" is prepended to the filename and used from\n\t   instantiation until destruction. If you want \n           Bio::Tools::Alignment::Consed to be noisy during parsing of\n           the acefile, specify some value for (-verbose).\n\n\nsub new {\n    my ($class,%args) = @_;\n    my $self = $class->SUPER::new(%args);\n\n    $self->{'filename'} = $args{'-acefile'};\n\n    # this is special to UNIX and should probably use catfile : DONE!\n#    if (!($self->{'filename'} =~ m{/})) { \n#\t$self->{'filename'} = \"./\".$self->{'filename'}; \n#    } \n#    $self->{'filename'} =~ m/(.*\\/)(.*)ace.*$/;\n#    $self->{'path'} = $1;\n\n    # this is more generic and should work on most systems   \n    (undef, $self->{'path'}, undef) = File::Spec->splitpath($self->{'filename'});\n\n    $self->_initialize_io('-file'=>$self->{'filename'});\n    $self->{'o_trim'} = Bio::Tools::Alignment::Trim->new(-verbose => $self->verbose());\n    $self->set_forward_designator($DEFAULTS{'f_designator'});\n    $self->set_reverse_designator($DEFAULTS{'r_designator'});\n\n    $self->_read_file();\n    return $self;\n}\n\n=head2 set_verbose()\n\n Title   : set_verbose()\n Usage   : $o_consed->set_verbose(1);\n Function: Set the verbosity level for debugging messages. On instantiation\n\t   of the Bio::Tools::Alignment::Consed object the verbosity level\n           is set to 0 (quiet).\n Returns : 1 or 0.\n Args    : The verbosity levels are:\n\t      0 - quiet\n\t      1 - noisy\n\t      2 - noisier\n\t      3 - annoyingly noisy\n\nThis method for setting verbosity has largely been superseeded by a\nsub-by-sub way, where for every sub you can provide a (-verbose)\nswitch. I am doing converting this bit-by-bit so do not be surprised\nif some subs do not honour this.\n\n\n# from RootI\n\n# backwards compat\nsub set_verbose { (shift)->verbose(@_) }\n\n=head2 get_filename()\n\n Title   : get_filename()\n Usage   : $o_consed->get_filename();\n Function: Returns the name of the acefile being used by the\n\t   Bio::Tools::Alignment::Consed object.\n Returns : A scalar containing the name of a file.\n Args    : None.\n\n\n\nsub get_filename {\n    my $self = shift;\n    return $self->{'filename'};\n}\n\n=head2 count_sequences_with_grep()\n\n Title   : count_sequences_with_grep()\n Usage   : $o_consed->count_sequences_with_grep();\n Function: Use /bin/grep to scan through the files in the ace project dir\n\t   and count sequences in those files. I used this method in the\n\t   development of this module to verify that I was getting all of the\n\t   sequences. It works, but it is (I think) unix-like platform\n\t   dependent.\n Returns : A scalar containing the number of sequences in the ace project\n\t   directory.\n Args    : None.\n\nIf you are on a non-UNIX platform, you really do not have to use\nthis. It is more of a debugging routine designed to address very\nspecific problems.\n\nThis method was reimplemented to be platform independent with a pure\nperl implementation.  The above note can be ignored.\n\n\nsub count_sequences_with_grep {\n    my $self = shift;\n    my ($working_dir,$grep_cli,@total_grep_sequences);\n    # this should be migrated to a pure perl implementation ala\n    # Tom Christiansen's 'tcgrep'\n    # http://www.cpan.org/modules/by-authors/id/TOMC/scripts/tcgrep.gz\n\n    open(my $FILE, $self->{'filename'}) or do { $self->warn(\"cannot open file \".$self->{'filename'}. \" for grepping\"); return}; \n    my $counter =0;\n    while(<$FILE>) { $counter++ if(/^AF/); }\n\n    close $FILE;\n    opendir(my $SINGLETS,$self->{'path'});\n    foreach my $f ( readdir($SINGLETS) ) {\n\tnext unless ($f =~ /\\.singlets$/); \n\topen(my $FILE, File::Spec->catfile($self->{'path'},$f)) or do{ $self->warn(\"cannot open file \".File::Spec->catfile($self->{'path'},$f)); next };\n\twhile(<$FILE>) { $counter++ if(/^>/) }\n\tclose $FILE;\n    }\n    return $counter;\n}\n\n=head2 get_path()\n\n Title   : get_path()\n Usage   : $o_consed->get_path();\n Function: Returns the path to the acefile this object is working with.\n Returns : Scalar. The path to the working acefile.\n Args    : None.\n\n\nsub get_path {\n    my $self = shift;\n    return $self->{'path'};\n}\n\n=head2 get_contigs()\n\n Title   : get_contigs()\n Usage   : $o_consed->get_contigs();\n Function: Return the keys to the Bio::Tools::Alignment::Consed object.\n Returns : An array containing the keynames in the\n           Bio::Tools::Alignment::Consed object.\n Args    : None.\n\nThis would normally be used to get the keynames for some sort of\niterator. These keys are worthless in general day-to-day use because\nin the Consed acefile they are simply Contig1, Contig2, ...","parameters":[{"label":"$self"},{"label":"$contig"}],"label":"get_contigs($self,$contig)"},"containerName":"main::","definition":"sub"},{"kind":13,"line":287,"containerName":null,"name":"@contigs"},{"children":[{"kind":13,"line":302,"definition":"my","name":"$self","containerName":"get_class","localvar":"my"},{"containerName":"get_class","name":"$contig","kind":13,"line":302},{"line":303,"kind":13,"name":"$self","containerName":"get_class"},{"name":"$contig","containerName":"get_class","kind":13,"line":303}],"line":301,"kind":12,"signature":{"label":"get_class($self,$contig)","documentation":"1;\n# $Id: Consed.pm 16123 2009-09-17 12:57:27Z cjfields $\n# Bio::Tools::Alignment::Consed\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chad Matsalla\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Alignment::Consed - A module to work with objects from consed .ace files\n\n=head1 SYNOPSIS\n\n  # a report for sequencing stuff\n  my $o_consed = Bio::Tools::Alignment::Consed->new( \n      -acefile => \"/path/to/an/acefile.ace.1\",\n      -verbose => 1);\n  my $foo = $o_consed->set_reverse_designator(\"r\");\n  my $bar = $o_consed->set_forward_designator(\"f\");\n\n  # get the contig numbers\n  my @keys = $o_consed->get_contigs();\n\n  # construct the doublets\n  my $setter_doublets = $o_consed->choose_doublets();\n\n  # get the doublets\n  my @doublets = $o_consed->get_doublets();\n\n=head1 DESCRIPTION\n\nL<Bio::Tools::Alignment::Consed> provides methods and objects to deal\nwith the output from the Consed software suite. Specifically,\ntakes an C<.ace> file and provides objects for the results.\n\nA word about doublets: This module was written to accomodate a large\nEST sequencing operation. In this case, EST's were sequenced from the\n3' and from the 5' end of the EST. The objective was to find a\nconsensus sequence for these two reads.  Thus, a contig of two is what\nwe wanted, and this contig should consist of the forward and reverse\nreads of a getn clone. For example, for a forward designator of \"F\"\nand a reverse designator of \"R\", if the two reads chad1F and chad1R\nwere in a single contig (for example Contig 5) it will be determined\nthat the consensus sequence for Contig 5 will be the sequence for\nclone chad1.\n\nDoublets are good!\n\nThis module parses C<.ace> and related files. A detailed list of methods\ncan be found at the end of this document.\n\nI wrote a detailed rationale for design that may explain the reasons\nwhy some things were done the way they were done. That document is\nbeyond the scope of this pod and can probably be found in the\ndirectory from which this module was 'made' or at\nL<http://www.dieselwurks.com/bioinformatics/consedpm_documentation.pdf>.\n\nNote that the POD in that document might be old but the original\nrationale still stands.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nEmail chad-at-dieselwurks.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n#' \n\npackage Bio::Tools::Alignment::Consed;\n\nuse strict;\n\nuse FileHandle;\nuse Dumpvalue qw(dumpValue);\nuse Bio::Tools::Alignment::Trim;\nuse File::Spec;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\nour %DEFAULTS = ( 'f_designator' => 'f',\n\t\t  'r_designator' => 'r');\n\n=head2 new()\n\n Title   : new(-acefile => $path_to_some_acefile, -verbose => \"1\")\n Usage   : $o_consed = Bio::Tools::Alignment::Consed->\n              new(-acefile => $path_to_some_acefile, -verbose => \"1\");\n Function: Construct the Bio::Tools::Alignment::Consed object. Sets\n\t   verbosity for the following procedures, if necessary:\n\t   1. Construct a new Bio::Tools::Alignment::Trim object, to\n\t   handle quality trimming 2. Read in the acefile and parse it\n\n Returns : A reference to a Bio::Tools::Alignment::Consed object.\n Args    : A hash. (-acefile) is the filename of an acefile. If a full path\n\t   is not specified \"./\" is prepended to the filename and used from\n\t   instantiation until destruction. If you want \n           Bio::Tools::Alignment::Consed to be noisy during parsing of\n           the acefile, specify some value for (-verbose).\n\n\nsub new {\n    my ($class,%args) = @_;\n    my $self = $class->SUPER::new(%args);\n\n    $self->{'filename'} = $args{'-acefile'};\n\n    # this is special to UNIX and should probably use catfile : DONE!\n#    if (!($self->{'filename'} =~ m{/})) { \n#\t$self->{'filename'} = \"./\".$self->{'filename'}; \n#    } \n#    $self->{'filename'} =~ m/(.*\\/)(.*)ace.*$/;\n#    $self->{'path'} = $1;\n\n    # this is more generic and should work on most systems   \n    (undef, $self->{'path'}, undef) = File::Spec->splitpath($self->{'filename'});\n\n    $self->_initialize_io('-file'=>$self->{'filename'});\n    $self->{'o_trim'} = Bio::Tools::Alignment::Trim->new(-verbose => $self->verbose());\n    $self->set_forward_designator($DEFAULTS{'f_designator'});\n    $self->set_reverse_designator($DEFAULTS{'r_designator'});\n\n    $self->_read_file();\n    return $self;\n}\n\n=head2 set_verbose()\n\n Title   : set_verbose()\n Usage   : $o_consed->set_verbose(1);\n Function: Set the verbosity level for debugging messages. On instantiation\n\t   of the Bio::Tools::Alignment::Consed object the verbosity level\n           is set to 0 (quiet).\n Returns : 1 or 0.\n Args    : The verbosity levels are:\n\t      0 - quiet\n\t      1 - noisy\n\t      2 - noisier\n\t      3 - annoyingly noisy\n\nThis method for setting verbosity has largely been superseeded by a\nsub-by-sub way, where for every sub you can provide a (-verbose)\nswitch. I am doing converting this bit-by-bit so do not be surprised\nif some subs do not honour this.\n\n\n# from RootI\n\n# backwards compat\nsub set_verbose { (shift)->verbose(@_) }\n\n=head2 get_filename()\n\n Title   : get_filename()\n Usage   : $o_consed->get_filename();\n Function: Returns the name of the acefile being used by the\n\t   Bio::Tools::Alignment::Consed object.\n Returns : A scalar containing the name of a file.\n Args    : None.\n\n\n\nsub get_filename {\n    my $self = shift;\n    return $self->{'filename'};\n}\n\n=head2 count_sequences_with_grep()\n\n Title   : count_sequences_with_grep()\n Usage   : $o_consed->count_sequences_with_grep();\n Function: Use /bin/grep to scan through the files in the ace project dir\n\t   and count sequences in those files. I used this method in the\n\t   development of this module to verify that I was getting all of the\n\t   sequences. It works, but it is (I think) unix-like platform\n\t   dependent.\n Returns : A scalar containing the number of sequences in the ace project\n\t   directory.\n Args    : None.\n\nIf you are on a non-UNIX platform, you really do not have to use\nthis. It is more of a debugging routine designed to address very\nspecific problems.\n\nThis method was reimplemented to be platform independent with a pure\nperl implementation.  The above note can be ignored.\n\n\nsub count_sequences_with_grep {\n    my $self = shift;\n    my ($working_dir,$grep_cli,@total_grep_sequences);\n    # this should be migrated to a pure perl implementation ala\n    # Tom Christiansen's 'tcgrep'\n    # http://www.cpan.org/modules/by-authors/id/TOMC/scripts/tcgrep.gz\n\n    open(my $FILE, $self->{'filename'}) or do { $self->warn(\"cannot open file \".$self->{'filename'}. \" for grepping\"); return}; \n    my $counter =0;\n    while(<$FILE>) { $counter++ if(/^AF/); }\n\n    close $FILE;\n    opendir(my $SINGLETS,$self->{'path'});\n    foreach my $f ( readdir($SINGLETS) ) {\n\tnext unless ($f =~ /\\.singlets$/); \n\topen(my $FILE, File::Spec->catfile($self->{'path'},$f)) or do{ $self->warn(\"cannot open file \".File::Spec->catfile($self->{'path'},$f)); next };\n\twhile(<$FILE>) { $counter++ if(/^>/) }\n\tclose $FILE;\n    }\n    return $counter;\n}\n\n=head2 get_path()\n\n Title   : get_path()\n Usage   : $o_consed->get_path();\n Function: Returns the path to the acefile this object is working with.\n Returns : Scalar. The path to the working acefile.\n Args    : None.\n\n\nsub get_path {\n    my $self = shift;\n    return $self->{'path'};\n}\n\n=head2 get_contigs()\n\n Title   : get_contigs()\n Usage   : $o_consed->get_contigs();\n Function: Return the keys to the Bio::Tools::Alignment::Consed object.\n Returns : An array containing the keynames in the\n           Bio::Tools::Alignment::Consed object.\n Args    : None.\n\nThis would normally be used to get the keynames for some sort of\niterator. These keys are worthless in general day-to-day use because\nin the Consed acefile they are simply Contig1, Contig2, ...\n\n\nsub get_contigs {\n    my ($self,$contig) = @_;\n    my @contigs = sort keys %{$self->{'contigs'}};\n    return @contigs;\n}\n\n=head2 get_class($contig_keyname)\n\n Title   : get_class($contig_keyname)\n Usage   : $o_consed->get_class($contig_keyname);\n Function: Return the class name for this contig\n Returns : A scalar representing the class of this contig.\n Args    : None.\n Notes   : ","parameters":[{"label":"$self"},{"label":"$contig"}]},"detail":"($self,$contig)","definition":"sub","containerName":"main::","range":{"end":{"character":9999,"line":304},"start":{"line":301,"character":0}},"name":"get_class"},{"kind":12,"line":303,"name":"contigs"},{"kind":12,"line":303,"name":"class"},{"name":"get_quality_array","range":{"start":{"line":326,"character":0},"end":{"character":9999,"line":329}},"definition":"sub","containerName":"main::","signature":{"label":"get_quality_array($self,$contig)","parameters":[{"label":"$self"},{"label":"$contig"}],"documentation":"1;\n# $Id: Consed.pm 16123 2009-09-17 12:57:27Z cjfields $\n# Bio::Tools::Alignment::Consed\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chad Matsalla\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Alignment::Consed - A module to work with objects from consed .ace files\n\n=head1 SYNOPSIS\n\n  # a report for sequencing stuff\n  my $o_consed = Bio::Tools::Alignment::Consed->new( \n      -acefile => \"/path/to/an/acefile.ace.1\",\n      -verbose => 1);\n  my $foo = $o_consed->set_reverse_designator(\"r\");\n  my $bar = $o_consed->set_forward_designator(\"f\");\n\n  # get the contig numbers\n  my @keys = $o_consed->get_contigs();\n\n  # construct the doublets\n  my $setter_doublets = $o_consed->choose_doublets();\n\n  # get the doublets\n  my @doublets = $o_consed->get_doublets();\n\n=head1 DESCRIPTION\n\nL<Bio::Tools::Alignment::Consed> provides methods and objects to deal\nwith the output from the Consed software suite. Specifically,\ntakes an C<.ace> file and provides objects for the results.\n\nA word about doublets: This module was written to accomodate a large\nEST sequencing operation. In this case, EST's were sequenced from the\n3' and from the 5' end of the EST. The objective was to find a\nconsensus sequence for these two reads.  Thus, a contig of two is what\nwe wanted, and this contig should consist of the forward and reverse\nreads of a getn clone. For example, for a forward designator of \"F\"\nand a reverse designator of \"R\", if the two reads chad1F and chad1R\nwere in a single contig (for example Contig 5) it will be determined\nthat the consensus sequence for Contig 5 will be the sequence for\nclone chad1.\n\nDoublets are good!\n\nThis module parses C<.ace> and related files. A detailed list of methods\ncan be found at the end of this document.\n\nI wrote a detailed rationale for design that may explain the reasons\nwhy some things were done the way they were done. That document is\nbeyond the scope of this pod and can probably be found in the\ndirectory from which this module was 'made' or at\nL<http://www.dieselwurks.com/bioinformatics/consedpm_documentation.pdf>.\n\nNote that the POD in that document might be old but the original\nrationale still stands.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nEmail chad-at-dieselwurks.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n#' \n\npackage Bio::Tools::Alignment::Consed;\n\nuse strict;\n\nuse FileHandle;\nuse Dumpvalue qw(dumpValue);\nuse Bio::Tools::Alignment::Trim;\nuse File::Spec;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\nour %DEFAULTS = ( 'f_designator' => 'f',\n\t\t  'r_designator' => 'r');\n\n=head2 new()\n\n Title   : new(-acefile => $path_to_some_acefile, -verbose => \"1\")\n Usage   : $o_consed = Bio::Tools::Alignment::Consed->\n              new(-acefile => $path_to_some_acefile, -verbose => \"1\");\n Function: Construct the Bio::Tools::Alignment::Consed object. Sets\n\t   verbosity for the following procedures, if necessary:\n\t   1. Construct a new Bio::Tools::Alignment::Trim object, to\n\t   handle quality trimming 2. Read in the acefile and parse it\n\n Returns : A reference to a Bio::Tools::Alignment::Consed object.\n Args    : A hash. (-acefile) is the filename of an acefile. If a full path\n\t   is not specified \"./\" is prepended to the filename and used from\n\t   instantiation until destruction. If you want \n           Bio::Tools::Alignment::Consed to be noisy during parsing of\n           the acefile, specify some value for (-verbose).\n\n\nsub new {\n    my ($class,%args) = @_;\n    my $self = $class->SUPER::new(%args);\n\n    $self->{'filename'} = $args{'-acefile'};\n\n    # this is special to UNIX and should probably use catfile : DONE!\n#    if (!($self->{'filename'} =~ m{/})) { \n#\t$self->{'filename'} = \"./\".$self->{'filename'}; \n#    } \n#    $self->{'filename'} =~ m/(.*\\/)(.*)ace.*$/;\n#    $self->{'path'} = $1;\n\n    # this is more generic and should work on most systems   \n    (undef, $self->{'path'}, undef) = File::Spec->splitpath($self->{'filename'});\n\n    $self->_initialize_io('-file'=>$self->{'filename'});\n    $self->{'o_trim'} = Bio::Tools::Alignment::Trim->new(-verbose => $self->verbose());\n    $self->set_forward_designator($DEFAULTS{'f_designator'});\n    $self->set_reverse_designator($DEFAULTS{'r_designator'});\n\n    $self->_read_file();\n    return $self;\n}\n\n=head2 set_verbose()\n\n Title   : set_verbose()\n Usage   : $o_consed->set_verbose(1);\n Function: Set the verbosity level for debugging messages. On instantiation\n\t   of the Bio::Tools::Alignment::Consed object the verbosity level\n           is set to 0 (quiet).\n Returns : 1 or 0.\n Args    : The verbosity levels are:\n\t      0 - quiet\n\t      1 - noisy\n\t      2 - noisier\n\t      3 - annoyingly noisy\n\nThis method for setting verbosity has largely been superseeded by a\nsub-by-sub way, where for every sub you can provide a (-verbose)\nswitch. I am doing converting this bit-by-bit so do not be surprised\nif some subs do not honour this.\n\n\n# from RootI\n\n# backwards compat\nsub set_verbose { (shift)->verbose(@_) }\n\n=head2 get_filename()\n\n Title   : get_filename()\n Usage   : $o_consed->get_filename();\n Function: Returns the name of the acefile being used by the\n\t   Bio::Tools::Alignment::Consed object.\n Returns : A scalar containing the name of a file.\n Args    : None.\n\n\n\nsub get_filename {\n    my $self = shift;\n    return $self->{'filename'};\n}\n\n=head2 count_sequences_with_grep()\n\n Title   : count_sequences_with_grep()\n Usage   : $o_consed->count_sequences_with_grep();\n Function: Use /bin/grep to scan through the files in the ace project dir\n\t   and count sequences in those files. I used this method in the\n\t   development of this module to verify that I was getting all of the\n\t   sequences. It works, but it is (I think) unix-like platform\n\t   dependent.\n Returns : A scalar containing the number of sequences in the ace project\n\t   directory.\n Args    : None.\n\nIf you are on a non-UNIX platform, you really do not have to use\nthis. It is more of a debugging routine designed to address very\nspecific problems.\n\nThis method was reimplemented to be platform independent with a pure\nperl implementation.  The above note can be ignored.\n\n\nsub count_sequences_with_grep {\n    my $self = shift;\n    my ($working_dir,$grep_cli,@total_grep_sequences);\n    # this should be migrated to a pure perl implementation ala\n    # Tom Christiansen's 'tcgrep'\n    # http://www.cpan.org/modules/by-authors/id/TOMC/scripts/tcgrep.gz\n\n    open(my $FILE, $self->{'filename'}) or do { $self->warn(\"cannot open file \".$self->{'filename'}. \" for grepping\"); return}; \n    my $counter =0;\n    while(<$FILE>) { $counter++ if(/^AF/); }\n\n    close $FILE;\n    opendir(my $SINGLETS,$self->{'path'});\n    foreach my $f ( readdir($SINGLETS) ) {\n\tnext unless ($f =~ /\\.singlets$/); \n\topen(my $FILE, File::Spec->catfile($self->{'path'},$f)) or do{ $self->warn(\"cannot open file \".File::Spec->catfile($self->{'path'},$f)); next };\n\twhile(<$FILE>) { $counter++ if(/^>/) }\n\tclose $FILE;\n    }\n    return $counter;\n}\n\n=head2 get_path()\n\n Title   : get_path()\n Usage   : $o_consed->get_path();\n Function: Returns the path to the acefile this object is working with.\n Returns : Scalar. The path to the working acefile.\n Args    : None.\n\n\nsub get_path {\n    my $self = shift;\n    return $self->{'path'};\n}\n\n=head2 get_contigs()\n\n Title   : get_contigs()\n Usage   : $o_consed->get_contigs();\n Function: Return the keys to the Bio::Tools::Alignment::Consed object.\n Returns : An array containing the keynames in the\n           Bio::Tools::Alignment::Consed object.\n Args    : None.\n\nThis would normally be used to get the keynames for some sort of\niterator. These keys are worthless in general day-to-day use because\nin the Consed acefile they are simply Contig1, Contig2, ...\n\n\nsub get_contigs {\n    my ($self,$contig) = @_;\n    my @contigs = sort keys %{$self->{'contigs'}};\n    return @contigs;\n}\n\n=head2 get_class($contig_keyname)\n\n Title   : get_class($contig_keyname)\n Usage   : $o_consed->get_class($contig_keyname);\n Function: Return the class name for this contig\n Returns : A scalar representing the class of this contig.\n Args    : None.\n Notes   : \n\n\nsub get_class {\n    my ($self,$contig) = @_;\n    return $self->{contigs}->{$contig}->{class};\n}\n\n=head2 get_quality_array($contig_keyname)\n\n Title   : get_quality_array($contig_keyname)\n Usage   : $o_consed->get_quality_array($contig_keyname);\n Function: Returns the quality for the consensus sequence for the given\n\t   contig as an array. See get_quality_scalar to get this as a scalar.\n Returns : An array containing the quality for the consensus sequence with\n\t   the given keyname.\n Args    : The keyname of a contig. Note: This is a keyname. The key would\n\t   normally come from get_contigs.\n\nReturns an array, not a reference. Is this a bug? I<thinking> No.\nWell, maybe.  Why was this developed like this? I was using FreezeThaw\nfor object persistence, and when it froze out these arrays it took a\nlong time to thaw it. Much better as a scalar.\n\nSee L<get_quality_scalar()|get_quality_scalar>"},"detail":"($self,$contig)","kind":12,"children":[{"kind":13,"line":327,"name":"$self","definition":"my","containerName":"get_quality_array","localvar":"my"},{"kind":13,"line":327,"name":"$contig","containerName":"get_quality_array"},{"line":328,"kind":13,"containerName":"get_quality_array","name":"$self"},{"name":"$contig","containerName":"get_quality_array","line":328,"kind":13}],"line":326},{"line":328,"kind":12,"name":"contigs"},{"name":"quality","kind":12,"line":328},{"range":{"end":{"character":9999,"line":354},"start":{"line":351,"character":0}},"name":"get_quality_scalar","children":[{"line":352,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"get_quality_scalar"},{"kind":13,"line":352,"name":"$contig","containerName":"get_quality_scalar"},{"line":353,"kind":13,"containerName":"get_quality_scalar","name":"$self"},{"line":353,"kind":13,"containerName":"get_quality_scalar","name":"$contig"}],"line":351,"kind":12,"signature":{"parameters":[{"label":"$self"},{"label":"$contig"}],"documentation":"1;\n# $Id: Consed.pm 16123 2009-09-17 12:57:27Z cjfields $\n# Bio::Tools::Alignment::Consed\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chad Matsalla\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Alignment::Consed - A module to work with objects from consed .ace files\n\n=head1 SYNOPSIS\n\n  # a report for sequencing stuff\n  my $o_consed = Bio::Tools::Alignment::Consed->new( \n      -acefile => \"/path/to/an/acefile.ace.1\",\n      -verbose => 1);\n  my $foo = $o_consed->set_reverse_designator(\"r\");\n  my $bar = $o_consed->set_forward_designator(\"f\");\n\n  # get the contig numbers\n  my @keys = $o_consed->get_contigs();\n\n  # construct the doublets\n  my $setter_doublets = $o_consed->choose_doublets();\n\n  # get the doublets\n  my @doublets = $o_consed->get_doublets();\n\n=head1 DESCRIPTION\n\nL<Bio::Tools::Alignment::Consed> provides methods and objects to deal\nwith the output from the Consed software suite. Specifically,\ntakes an C<.ace> file and provides objects for the results.\n\nA word about doublets: This module was written to accomodate a large\nEST sequencing operation. In this case, EST's were sequenced from the\n3' and from the 5' end of the EST. The objective was to find a\nconsensus sequence for these two reads.  Thus, a contig of two is what\nwe wanted, and this contig should consist of the forward and reverse\nreads of a getn clone. For example, for a forward designator of \"F\"\nand a reverse designator of \"R\", if the two reads chad1F and chad1R\nwere in a single contig (for example Contig 5) it will be determined\nthat the consensus sequence for Contig 5 will be the sequence for\nclone chad1.\n\nDoublets are good!\n\nThis module parses C<.ace> and related files. A detailed list of methods\ncan be found at the end of this document.\n\nI wrote a detailed rationale for design that may explain the reasons\nwhy some things were done the way they were done. That document is\nbeyond the scope of this pod and can probably be found in the\ndirectory from which this module was 'made' or at\nL<http://www.dieselwurks.com/bioinformatics/consedpm_documentation.pdf>.\n\nNote that the POD in that document might be old but the original\nrationale still stands.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nEmail chad-at-dieselwurks.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n#' \n\npackage Bio::Tools::Alignment::Consed;\n\nuse strict;\n\nuse FileHandle;\nuse Dumpvalue qw(dumpValue);\nuse Bio::Tools::Alignment::Trim;\nuse File::Spec;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\nour %DEFAULTS = ( 'f_designator' => 'f',\n\t\t  'r_designator' => 'r');\n\n=head2 new()\n\n Title   : new(-acefile => $path_to_some_acefile, -verbose => \"1\")\n Usage   : $o_consed = Bio::Tools::Alignment::Consed->\n              new(-acefile => $path_to_some_acefile, -verbose => \"1\");\n Function: Construct the Bio::Tools::Alignment::Consed object. Sets\n\t   verbosity for the following procedures, if necessary:\n\t   1. Construct a new Bio::Tools::Alignment::Trim object, to\n\t   handle quality trimming 2. Read in the acefile and parse it\n\n Returns : A reference to a Bio::Tools::Alignment::Consed object.\n Args    : A hash. (-acefile) is the filename of an acefile. If a full path\n\t   is not specified \"./\" is prepended to the filename and used from\n\t   instantiation until destruction. If you want \n           Bio::Tools::Alignment::Consed to be noisy during parsing of\n           the acefile, specify some value for (-verbose).\n\n\nsub new {\n    my ($class,%args) = @_;\n    my $self = $class->SUPER::new(%args);\n\n    $self->{'filename'} = $args{'-acefile'};\n\n    # this is special to UNIX and should probably use catfile : DONE!\n#    if (!($self->{'filename'} =~ m{/})) { \n#\t$self->{'filename'} = \"./\".$self->{'filename'}; \n#    } \n#    $self->{'filename'} =~ m/(.*\\/)(.*)ace.*$/;\n#    $self->{'path'} = $1;\n\n    # this is more generic and should work on most systems   \n    (undef, $self->{'path'}, undef) = File::Spec->splitpath($self->{'filename'});\n\n    $self->_initialize_io('-file'=>$self->{'filename'});\n    $self->{'o_trim'} = Bio::Tools::Alignment::Trim->new(-verbose => $self->verbose());\n    $self->set_forward_designator($DEFAULTS{'f_designator'});\n    $self->set_reverse_designator($DEFAULTS{'r_designator'});\n\n    $self->_read_file();\n    return $self;\n}\n\n=head2 set_verbose()\n\n Title   : set_verbose()\n Usage   : $o_consed->set_verbose(1);\n Function: Set the verbosity level for debugging messages. On instantiation\n\t   of the Bio::Tools::Alignment::Consed object the verbosity level\n           is set to 0 (quiet).\n Returns : 1 or 0.\n Args    : The verbosity levels are:\n\t      0 - quiet\n\t      1 - noisy\n\t      2 - noisier\n\t      3 - annoyingly noisy\n\nThis method for setting verbosity has largely been superseeded by a\nsub-by-sub way, where for every sub you can provide a (-verbose)\nswitch. I am doing converting this bit-by-bit so do not be surprised\nif some subs do not honour this.\n\n\n# from RootI\n\n# backwards compat\nsub set_verbose { (shift)->verbose(@_) }\n\n=head2 get_filename()\n\n Title   : get_filename()\n Usage   : $o_consed->get_filename();\n Function: Returns the name of the acefile being used by the\n\t   Bio::Tools::Alignment::Consed object.\n Returns : A scalar containing the name of a file.\n Args    : None.\n\n\n\nsub get_filename {\n    my $self = shift;\n    return $self->{'filename'};\n}\n\n=head2 count_sequences_with_grep()\n\n Title   : count_sequences_with_grep()\n Usage   : $o_consed->count_sequences_with_grep();\n Function: Use /bin/grep to scan through the files in the ace project dir\n\t   and count sequences in those files. I used this method in the\n\t   development of this module to verify that I was getting all of the\n\t   sequences. It works, but it is (I think) unix-like platform\n\t   dependent.\n Returns : A scalar containing the number of sequences in the ace project\n\t   directory.\n Args    : None.\n\nIf you are on a non-UNIX platform, you really do not have to use\nthis. It is more of a debugging routine designed to address very\nspecific problems.\n\nThis method was reimplemented to be platform independent with a pure\nperl implementation.  The above note can be ignored.\n\n\nsub count_sequences_with_grep {\n    my $self = shift;\n    my ($working_dir,$grep_cli,@total_grep_sequences);\n    # this should be migrated to a pure perl implementation ala\n    # Tom Christiansen's 'tcgrep'\n    # http://www.cpan.org/modules/by-authors/id/TOMC/scripts/tcgrep.gz\n\n    open(my $FILE, $self->{'filename'}) or do { $self->warn(\"cannot open file \".$self->{'filename'}. \" for grepping\"); return}; \n    my $counter =0;\n    while(<$FILE>) { $counter++ if(/^AF/); }\n\n    close $FILE;\n    opendir(my $SINGLETS,$self->{'path'});\n    foreach my $f ( readdir($SINGLETS) ) {\n\tnext unless ($f =~ /\\.singlets$/); \n\topen(my $FILE, File::Spec->catfile($self->{'path'},$f)) or do{ $self->warn(\"cannot open file \".File::Spec->catfile($self->{'path'},$f)); next };\n\twhile(<$FILE>) { $counter++ if(/^>/) }\n\tclose $FILE;\n    }\n    return $counter;\n}\n\n=head2 get_path()\n\n Title   : get_path()\n Usage   : $o_consed->get_path();\n Function: Returns the path to the acefile this object is working with.\n Returns : Scalar. The path to the working acefile.\n Args    : None.\n\n\nsub get_path {\n    my $self = shift;\n    return $self->{'path'};\n}\n\n=head2 get_contigs()\n\n Title   : get_contigs()\n Usage   : $o_consed->get_contigs();\n Function: Return the keys to the Bio::Tools::Alignment::Consed object.\n Returns : An array containing the keynames in the\n           Bio::Tools::Alignment::Consed object.\n Args    : None.\n\nThis would normally be used to get the keynames for some sort of\niterator. These keys are worthless in general day-to-day use because\nin the Consed acefile they are simply Contig1, Contig2, ...\n\n\nsub get_contigs {\n    my ($self,$contig) = @_;\n    my @contigs = sort keys %{$self->{'contigs'}};\n    return @contigs;\n}\n\n=head2 get_class($contig_keyname)\n\n Title   : get_class($contig_keyname)\n Usage   : $o_consed->get_class($contig_keyname);\n Function: Return the class name for this contig\n Returns : A scalar representing the class of this contig.\n Args    : None.\n Notes   : \n\n\nsub get_class {\n    my ($self,$contig) = @_;\n    return $self->{contigs}->{$contig}->{class};\n}\n\n=head2 get_quality_array($contig_keyname)\n\n Title   : get_quality_array($contig_keyname)\n Usage   : $o_consed->get_quality_array($contig_keyname);\n Function: Returns the quality for the consensus sequence for the given\n\t   contig as an array. See get_quality_scalar to get this as a scalar.\n Returns : An array containing the quality for the consensus sequence with\n\t   the given keyname.\n Args    : The keyname of a contig. Note: This is a keyname. The key would\n\t   normally come from get_contigs.\n\nReturns an array, not a reference. Is this a bug? I<thinking> No.\nWell, maybe.  Why was this developed like this? I was using FreezeThaw\nfor object persistence, and when it froze out these arrays it took a\nlong time to thaw it. Much better as a scalar.\n\nSee L<get_quality_scalar()|get_quality_scalar>\n\n\nsub get_quality_array {\n    my ($self,$contig) = @_;\n    return split ' ', $self->{contigs}->{$contig}->{quality};\n}\n\n=head2 get_quality_scalar($contig_keyname)\n\n Title   : get_quality_scalar($contig_keyname)\n Usage   : $o_consed->get_quality_scalar($contig_keyname);\n Function: Returns the quality for the consensus sequence for the given\n\t   contig as a scalar. See get_quality_array to get this as an array.\n Returns : An scalar containing the quality for the consensus sequence with\n           the given keyname.\n Args    : The keyname of a contig. Note this is a _keyname_. The key would\n\t   normally come from get_contigs.\n\nWhy was this developed like this? I was using FreezeThaw for object\npersistence, and when it froze out these arrays it took a coon's age\nto thaw it. Much better as a scalar.\n\nSee L<get_quality_array()|get_quality_array>\n\n'","label":"get_quality_scalar($self,$contig)"},"detail":"($self,$contig)","definition":"sub","containerName":"main::"},{"range":{"start":{"line":375,"character":0},"end":{"line":394,"character":9999}},"containerName":"main::","name":"freeze_hash","definition":"sub","line":375,"children":[{"name":"$self","definition":"my","containerName":"freeze_hash","localvar":"my","kind":13,"line":376},{"name":"$self","containerName":"freeze_hash","kind":13,"line":377},{"kind":12,"line":377,"name":"warn","containerName":"freeze_hash"},{"kind":13,"line":380,"name":"$self","containerName":"freeze_hash"},{"containerName":"freeze_hash","name":"debug","line":380,"kind":12},{"line":382,"kind":13,"localvar":"my","name":"$filename","definition":"my","containerName":"freeze_hash"},{"name":"$self","containerName":"freeze_hash","kind":13,"line":382},{"containerName":"freeze_hash","name":"%contigs","definition":"my","localvar":"my","kind":13,"line":383},{"containerName":"freeze_hash","name":"$self","line":383,"kind":13},{"line":384,"kind":13,"localvar":"my","name":"$frozen","definition":"my","containerName":"freeze_hash"},{"containerName":"freeze_hash","name":"%contigs","line":384,"kind":13},{"localvar":"my","definition":"my","name":"$FREEZE","containerName":"freeze_hash","line":386,"kind":13},{"line":387,"kind":13,"containerName":"freeze_hash","name":"$self"},{"containerName":"freeze_hash","name":"warn","line":387,"kind":12},{"kind":13,"line":392,"containerName":"freeze_hash","name":"$FREEZE"},{"line":392,"kind":13,"name":"$frozen","containerName":"freeze_hash"}],"kind":12},{"name":"freeze","line":384,"kind":12},{"name":"get_members","range":{"end":{"character":9999,"line":417},"start":{"line":410,"character":0}},"containerName":"main::","definition":"sub","detail":"($self,$contig)","signature":{"parameters":[{"label":"$self"},{"label":"$contig"}],"documentation":"1;\n# $Id: Consed.pm 16123 2009-09-17 12:57:27Z cjfields $\n# Bio::Tools::Alignment::Consed\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chad Matsalla\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Alignment::Consed - A module to work with objects from consed .ace files\n\n=head1 SYNOPSIS\n\n  # a report for sequencing stuff\n  my $o_consed = Bio::Tools::Alignment::Consed->new( \n      -acefile => \"/path/to/an/acefile.ace.1\",\n      -verbose => 1);\n  my $foo = $o_consed->set_reverse_designator(\"r\");\n  my $bar = $o_consed->set_forward_designator(\"f\");\n\n  # get the contig numbers\n  my @keys = $o_consed->get_contigs();\n\n  # construct the doublets\n  my $setter_doublets = $o_consed->choose_doublets();\n\n  # get the doublets\n  my @doublets = $o_consed->get_doublets();\n\n=head1 DESCRIPTION\n\nL<Bio::Tools::Alignment::Consed> provides methods and objects to deal\nwith the output from the Consed software suite. Specifically,\ntakes an C<.ace> file and provides objects for the results.\n\nA word about doublets: This module was written to accomodate a large\nEST sequencing operation. In this case, EST's were sequenced from the\n3' and from the 5' end of the EST. The objective was to find a\nconsensus sequence for these two reads.  Thus, a contig of two is what\nwe wanted, and this contig should consist of the forward and reverse\nreads of a getn clone. For example, for a forward designator of \"F\"\nand a reverse designator of \"R\", if the two reads chad1F and chad1R\nwere in a single contig (for example Contig 5) it will be determined\nthat the consensus sequence for Contig 5 will be the sequence for\nclone chad1.\n\nDoublets are good!\n\nThis module parses C<.ace> and related files. A detailed list of methods\ncan be found at the end of this document.\n\nI wrote a detailed rationale for design that may explain the reasons\nwhy some things were done the way they were done. That document is\nbeyond the scope of this pod and can probably be found in the\ndirectory from which this module was 'made' or at\nL<http://www.dieselwurks.com/bioinformatics/consedpm_documentation.pdf>.\n\nNote that the POD in that document might be old but the original\nrationale still stands.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nEmail chad-at-dieselwurks.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n#' \n\npackage Bio::Tools::Alignment::Consed;\n\nuse strict;\n\nuse FileHandle;\nuse Dumpvalue qw(dumpValue);\nuse Bio::Tools::Alignment::Trim;\nuse File::Spec;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\nour %DEFAULTS = ( 'f_designator' => 'f',\n\t\t  'r_designator' => 'r');\n\n=head2 new()\n\n Title   : new(-acefile => $path_to_some_acefile, -verbose => \"1\")\n Usage   : $o_consed = Bio::Tools::Alignment::Consed->\n              new(-acefile => $path_to_some_acefile, -verbose => \"1\");\n Function: Construct the Bio::Tools::Alignment::Consed object. Sets\n\t   verbosity for the following procedures, if necessary:\n\t   1. Construct a new Bio::Tools::Alignment::Trim object, to\n\t   handle quality trimming 2. Read in the acefile and parse it\n\n Returns : A reference to a Bio::Tools::Alignment::Consed object.\n Args    : A hash. (-acefile) is the filename of an acefile. If a full path\n\t   is not specified \"./\" is prepended to the filename and used from\n\t   instantiation until destruction. If you want \n           Bio::Tools::Alignment::Consed to be noisy during parsing of\n           the acefile, specify some value for (-verbose).\n\n\nsub new {\n    my ($class,%args) = @_;\n    my $self = $class->SUPER::new(%args);\n\n    $self->{'filename'} = $args{'-acefile'};\n\n    # this is special to UNIX and should probably use catfile : DONE!\n#    if (!($self->{'filename'} =~ m{/})) { \n#\t$self->{'filename'} = \"./\".$self->{'filename'}; \n#    } \n#    $self->{'filename'} =~ m/(.*\\/)(.*)ace.*$/;\n#    $self->{'path'} = $1;\n\n    # this is more generic and should work on most systems   \n    (undef, $self->{'path'}, undef) = File::Spec->splitpath($self->{'filename'});\n\n    $self->_initialize_io('-file'=>$self->{'filename'});\n    $self->{'o_trim'} = Bio::Tools::Alignment::Trim->new(-verbose => $self->verbose());\n    $self->set_forward_designator($DEFAULTS{'f_designator'});\n    $self->set_reverse_designator($DEFAULTS{'r_designator'});\n\n    $self->_read_file();\n    return $self;\n}\n\n=head2 set_verbose()\n\n Title   : set_verbose()\n Usage   : $o_consed->set_verbose(1);\n Function: Set the verbosity level for debugging messages. On instantiation\n\t   of the Bio::Tools::Alignment::Consed object the verbosity level\n           is set to 0 (quiet).\n Returns : 1 or 0.\n Args    : The verbosity levels are:\n\t      0 - quiet\n\t      1 - noisy\n\t      2 - noisier\n\t      3 - annoyingly noisy\n\nThis method for setting verbosity has largely been superseeded by a\nsub-by-sub way, where for every sub you can provide a (-verbose)\nswitch. I am doing converting this bit-by-bit so do not be surprised\nif some subs do not honour this.\n\n\n# from RootI\n\n# backwards compat\nsub set_verbose { (shift)->verbose(@_) }\n\n=head2 get_filename()\n\n Title   : get_filename()\n Usage   : $o_consed->get_filename();\n Function: Returns the name of the acefile being used by the\n\t   Bio::Tools::Alignment::Consed object.\n Returns : A scalar containing the name of a file.\n Args    : None.\n\n\n\nsub get_filename {\n    my $self = shift;\n    return $self->{'filename'};\n}\n\n=head2 count_sequences_with_grep()\n\n Title   : count_sequences_with_grep()\n Usage   : $o_consed->count_sequences_with_grep();\n Function: Use /bin/grep to scan through the files in the ace project dir\n\t   and count sequences in those files. I used this method in the\n\t   development of this module to verify that I was getting all of the\n\t   sequences. It works, but it is (I think) unix-like platform\n\t   dependent.\n Returns : A scalar containing the number of sequences in the ace project\n\t   directory.\n Args    : None.\n\nIf you are on a non-UNIX platform, you really do not have to use\nthis. It is more of a debugging routine designed to address very\nspecific problems.\n\nThis method was reimplemented to be platform independent with a pure\nperl implementation.  The above note can be ignored.\n\n\nsub count_sequences_with_grep {\n    my $self = shift;\n    my ($working_dir,$grep_cli,@total_grep_sequences);\n    # this should be migrated to a pure perl implementation ala\n    # Tom Christiansen's 'tcgrep'\n    # http://www.cpan.org/modules/by-authors/id/TOMC/scripts/tcgrep.gz\n\n    open(my $FILE, $self->{'filename'}) or do { $self->warn(\"cannot open file \".$self->{'filename'}. \" for grepping\"); return}; \n    my $counter =0;\n    while(<$FILE>) { $counter++ if(/^AF/); }\n\n    close $FILE;\n    opendir(my $SINGLETS,$self->{'path'});\n    foreach my $f ( readdir($SINGLETS) ) {\n\tnext unless ($f =~ /\\.singlets$/); \n\topen(my $FILE, File::Spec->catfile($self->{'path'},$f)) or do{ $self->warn(\"cannot open file \".File::Spec->catfile($self->{'path'},$f)); next };\n\twhile(<$FILE>) { $counter++ if(/^>/) }\n\tclose $FILE;\n    }\n    return $counter;\n}\n\n=head2 get_path()\n\n Title   : get_path()\n Usage   : $o_consed->get_path();\n Function: Returns the path to the acefile this object is working with.\n Returns : Scalar. The path to the working acefile.\n Args    : None.\n\n\nsub get_path {\n    my $self = shift;\n    return $self->{'path'};\n}\n\n=head2 get_contigs()\n\n Title   : get_contigs()\n Usage   : $o_consed->get_contigs();\n Function: Return the keys to the Bio::Tools::Alignment::Consed object.\n Returns : An array containing the keynames in the\n           Bio::Tools::Alignment::Consed object.\n Args    : None.\n\nThis would normally be used to get the keynames for some sort of\niterator. These keys are worthless in general day-to-day use because\nin the Consed acefile they are simply Contig1, Contig2, ...\n\n\nsub get_contigs {\n    my ($self,$contig) = @_;\n    my @contigs = sort keys %{$self->{'contigs'}};\n    return @contigs;\n}\n\n=head2 get_class($contig_keyname)\n\n Title   : get_class($contig_keyname)\n Usage   : $o_consed->get_class($contig_keyname);\n Function: Return the class name for this contig\n Returns : A scalar representing the class of this contig.\n Args    : None.\n Notes   : \n\n\nsub get_class {\n    my ($self,$contig) = @_;\n    return $self->{contigs}->{$contig}->{class};\n}\n\n=head2 get_quality_array($contig_keyname)\n\n Title   : get_quality_array($contig_keyname)\n Usage   : $o_consed->get_quality_array($contig_keyname);\n Function: Returns the quality for the consensus sequence for the given\n\t   contig as an array. See get_quality_scalar to get this as a scalar.\n Returns : An array containing the quality for the consensus sequence with\n\t   the given keyname.\n Args    : The keyname of a contig. Note: This is a keyname. The key would\n\t   normally come from get_contigs.\n\nReturns an array, not a reference. Is this a bug? I<thinking> No.\nWell, maybe.  Why was this developed like this? I was using FreezeThaw\nfor object persistence, and when it froze out these arrays it took a\nlong time to thaw it. Much better as a scalar.\n\nSee L<get_quality_scalar()|get_quality_scalar>\n\n\nsub get_quality_array {\n    my ($self,$contig) = @_;\n    return split ' ', $self->{contigs}->{$contig}->{quality};\n}\n\n=head2 get_quality_scalar($contig_keyname)\n\n Title   : get_quality_scalar($contig_keyname)\n Usage   : $o_consed->get_quality_scalar($contig_keyname);\n Function: Returns the quality for the consensus sequence for the given\n\t   contig as a scalar. See get_quality_array to get this as an array.\n Returns : An scalar containing the quality for the consensus sequence with\n           the given keyname.\n Args    : The keyname of a contig. Note this is a _keyname_. The key would\n\t   normally come from get_contigs.\n\nWhy was this developed like this? I was using FreezeThaw for object\npersistence, and when it froze out these arrays it took a coon's age\nto thaw it. Much better as a scalar.\n\nSee L<get_quality_array()|get_quality_array>\n\n\n#'\nsub get_quality_scalar {\n    my ($self,$contig) = @_;\n    return $self->{'contigs'}->{$contig}->{'quality'};\n}\n\n=head2 freeze_hash()\n\n Title   : freeze_hash()\n Usage   : $o_consed->freeze_hash();\n\n Function: Use Ilya's FreezeThaw module to create a persistent data\n\t   object for this Bio::Tools::Alignment::Consed data\n\t   structure. In the case of AAFC, we use\n\t   Bio::Tools::Alignment::Consed to pre-process bunches of\n\t   sequences, freeze the structures, and send in a harvesting\n\t   robot later to do database stuff.\n Returns : 0 or 1;\n Args    : None.\n\nThis procedure was removed so Consed.pm won't require FreezeThaw.\n\n\n#'\nsub freeze_hash {\n    my $self = shift;\n    $self->warn(\"This method (freeze_hash) was removed \".\n                \"from the bioperl consed.pm. Sorry.\\n\");\n    if (1==2) {\n        $self->debug(\"Bio::Tools::Alignment::Consed::freeze_hash:\".\n                     \" \\$self->{path} is $self->{path}\\n\");\n        my $filename = $self->{'path'}.\"frozen\";\n        my %contigs = %{$self->{'contigs'}};\n        my $frozen = freeze(%contigs);\n        umask 0001;\n        open (my $FREEZE,\">$filename\") or do {\n            $self->warn( \"Bio::Tools::Alignment::Consed could not \".\n                         \"freeze the contig hash because the file \".\n                         \"($filename) could not be opened: $!\\n\");\n            return 1;\n        };\n        print $FREEZE $frozen;\n        return 0;\n    }\n}\n\n=head2 get_members($contig_keyname)\n\n Title   : get_members($contig_keyname)\n Usage   : $o_consed->get_members($contig_keyname);\n Function: Return the _names_ of the reads in this contig.\n Returns : An array containing the names of the reads in this contig.\n Args    : The keyname of a contig. Note this is a keyname. The keyname\n\t   would normally come from get_contigs.\n\nSee L<get_contigs()|get_contigs>","label":"get_members($self,$contig)"},"kind":12,"line":410,"children":[{"containerName":"get_members","name":"$self","definition":"my","localvar":"my","kind":13,"line":411},{"line":411,"kind":13,"name":"$contig","containerName":"get_members"},{"name":"$contig","containerName":"get_members","kind":13,"line":412},{"kind":13,"line":413,"containerName":"get_members","name":"$self"},{"kind":12,"line":413,"name":"warn","containerName":"get_members"},{"name":"$self","containerName":"get_members","kind":13,"line":417},{"name":"$contig","containerName":"get_members","line":417,"kind":13}]},{"name":"get_members_by_name","range":{"start":{"line":436,"character":0},"end":{"line":440,"character":9999}},"kind":12,"children":[{"kind":13,"line":437,"name":"$self","definition":"my","containerName":"get_members_by_name","localvar":"my"},{"kind":13,"line":437,"name":"$name","containerName":"get_members_by_name"},{"line":439,"kind":13,"localvar":"my","definition":"my","name":"@contigs_with_that_name","containerName":"get_members_by_name"},{"line":440,"kind":13,"localvar":"my","containerName":"get_members_by_name","name":"$currkey","definition":"my"},{"kind":13,"line":440,"name":"$self","containerName":"get_members_by_name"}],"line":436,"definition":"sub","containerName":"main::","signature":{"documentation":"1;\n# $Id: Consed.pm 16123 2009-09-17 12:57:27Z cjfields $\n# Bio::Tools::Alignment::Consed\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chad Matsalla\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Alignment::Consed - A module to work with objects from consed .ace files\n\n=head1 SYNOPSIS\n\n  # a report for sequencing stuff\n  my $o_consed = Bio::Tools::Alignment::Consed->new( \n      -acefile => \"/path/to/an/acefile.ace.1\",\n      -verbose => 1);\n  my $foo = $o_consed->set_reverse_designator(\"r\");\n  my $bar = $o_consed->set_forward_designator(\"f\");\n\n  # get the contig numbers\n  my @keys = $o_consed->get_contigs();\n\n  # construct the doublets\n  my $setter_doublets = $o_consed->choose_doublets();\n\n  # get the doublets\n  my @doublets = $o_consed->get_doublets();\n\n=head1 DESCRIPTION\n\nL<Bio::Tools::Alignment::Consed> provides methods and objects to deal\nwith the output from the Consed software suite. Specifically,\ntakes an C<.ace> file and provides objects for the results.\n\nA word about doublets: This module was written to accomodate a large\nEST sequencing operation. In this case, EST's were sequenced from the\n3' and from the 5' end of the EST. The objective was to find a\nconsensus sequence for these two reads.  Thus, a contig of two is what\nwe wanted, and this contig should consist of the forward and reverse\nreads of a getn clone. For example, for a forward designator of \"F\"\nand a reverse designator of \"R\", if the two reads chad1F and chad1R\nwere in a single contig (for example Contig 5) it will be determined\nthat the consensus sequence for Contig 5 will be the sequence for\nclone chad1.\n\nDoublets are good!\n\nThis module parses C<.ace> and related files. A detailed list of methods\ncan be found at the end of this document.\n\nI wrote a detailed rationale for design that may explain the reasons\nwhy some things were done the way they were done. That document is\nbeyond the scope of this pod and can probably be found in the\ndirectory from which this module was 'made' or at\nL<http://www.dieselwurks.com/bioinformatics/consedpm_documentation.pdf>.\n\nNote that the POD in that document might be old but the original\nrationale still stands.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nEmail chad-at-dieselwurks.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n#' \n\npackage Bio::Tools::Alignment::Consed;\n\nuse strict;\n\nuse FileHandle;\nuse Dumpvalue qw(dumpValue);\nuse Bio::Tools::Alignment::Trim;\nuse File::Spec;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\nour %DEFAULTS = ( 'f_designator' => 'f',\n\t\t  'r_designator' => 'r');\n\n=head2 new()\n\n Title   : new(-acefile => $path_to_some_acefile, -verbose => \"1\")\n Usage   : $o_consed = Bio::Tools::Alignment::Consed->\n              new(-acefile => $path_to_some_acefile, -verbose => \"1\");\n Function: Construct the Bio::Tools::Alignment::Consed object. Sets\n\t   verbosity for the following procedures, if necessary:\n\t   1. Construct a new Bio::Tools::Alignment::Trim object, to\n\t   handle quality trimming 2. Read in the acefile and parse it\n\n Returns : A reference to a Bio::Tools::Alignment::Consed object.\n Args    : A hash. (-acefile) is the filename of an acefile. If a full path\n\t   is not specified \"./\" is prepended to the filename and used from\n\t   instantiation until destruction. If you want \n           Bio::Tools::Alignment::Consed to be noisy during parsing of\n           the acefile, specify some value for (-verbose).\n\n\nsub new {\n    my ($class,%args) = @_;\n    my $self = $class->SUPER::new(%args);\n\n    $self->{'filename'} = $args{'-acefile'};\n\n    # this is special to UNIX and should probably use catfile : DONE!\n#    if (!($self->{'filename'} =~ m{/})) { \n#\t$self->{'filename'} = \"./\".$self->{'filename'}; \n#    } \n#    $self->{'filename'} =~ m/(.*\\/)(.*)ace.*$/;\n#    $self->{'path'} = $1;\n\n    # this is more generic and should work on most systems   \n    (undef, $self->{'path'}, undef) = File::Spec->splitpath($self->{'filename'});\n\n    $self->_initialize_io('-file'=>$self->{'filename'});\n    $self->{'o_trim'} = Bio::Tools::Alignment::Trim->new(-verbose => $self->verbose());\n    $self->set_forward_designator($DEFAULTS{'f_designator'});\n    $self->set_reverse_designator($DEFAULTS{'r_designator'});\n\n    $self->_read_file();\n    return $self;\n}\n\n=head2 set_verbose()\n\n Title   : set_verbose()\n Usage   : $o_consed->set_verbose(1);\n Function: Set the verbosity level for debugging messages. On instantiation\n\t   of the Bio::Tools::Alignment::Consed object the verbosity level\n           is set to 0 (quiet).\n Returns : 1 or 0.\n Args    : The verbosity levels are:\n\t      0 - quiet\n\t      1 - noisy\n\t      2 - noisier\n\t      3 - annoyingly noisy\n\nThis method for setting verbosity has largely been superseeded by a\nsub-by-sub way, where for every sub you can provide a (-verbose)\nswitch. I am doing converting this bit-by-bit so do not be surprised\nif some subs do not honour this.\n\n\n# from RootI\n\n# backwards compat\nsub set_verbose { (shift)->verbose(@_) }\n\n=head2 get_filename()\n\n Title   : get_filename()\n Usage   : $o_consed->get_filename();\n Function: Returns the name of the acefile being used by the\n\t   Bio::Tools::Alignment::Consed object.\n Returns : A scalar containing the name of a file.\n Args    : None.\n\n\n\nsub get_filename {\n    my $self = shift;\n    return $self->{'filename'};\n}\n\n=head2 count_sequences_with_grep()\n\n Title   : count_sequences_with_grep()\n Usage   : $o_consed->count_sequences_with_grep();\n Function: Use /bin/grep to scan through the files in the ace project dir\n\t   and count sequences in those files. I used this method in the\n\t   development of this module to verify that I was getting all of the\n\t   sequences. It works, but it is (I think) unix-like platform\n\t   dependent.\n Returns : A scalar containing the number of sequences in the ace project\n\t   directory.\n Args    : None.\n\nIf you are on a non-UNIX platform, you really do not have to use\nthis. It is more of a debugging routine designed to address very\nspecific problems.\n\nThis method was reimplemented to be platform independent with a pure\nperl implementation.  The above note can be ignored.\n\n\nsub count_sequences_with_grep {\n    my $self = shift;\n    my ($working_dir,$grep_cli,@total_grep_sequences);\n    # this should be migrated to a pure perl implementation ala\n    # Tom Christiansen's 'tcgrep'\n    # http://www.cpan.org/modules/by-authors/id/TOMC/scripts/tcgrep.gz\n\n    open(my $FILE, $self->{'filename'}) or do { $self->warn(\"cannot open file \".$self->{'filename'}. \" for grepping\"); return}; \n    my $counter =0;\n    while(<$FILE>) { $counter++ if(/^AF/); }\n\n    close $FILE;\n    opendir(my $SINGLETS,$self->{'path'});\n    foreach my $f ( readdir($SINGLETS) ) {\n\tnext unless ($f =~ /\\.singlets$/); \n\topen(my $FILE, File::Spec->catfile($self->{'path'},$f)) or do{ $self->warn(\"cannot open file \".File::Spec->catfile($self->{'path'},$f)); next };\n\twhile(<$FILE>) { $counter++ if(/^>/) }\n\tclose $FILE;\n    }\n    return $counter;\n}\n\n=head2 get_path()\n\n Title   : get_path()\n Usage   : $o_consed->get_path();\n Function: Returns the path to the acefile this object is working with.\n Returns : Scalar. The path to the working acefile.\n Args    : None.\n\n\nsub get_path {\n    my $self = shift;\n    return $self->{'path'};\n}\n\n=head2 get_contigs()\n\n Title   : get_contigs()\n Usage   : $o_consed->get_contigs();\n Function: Return the keys to the Bio::Tools::Alignment::Consed object.\n Returns : An array containing the keynames in the\n           Bio::Tools::Alignment::Consed object.\n Args    : None.\n\nThis would normally be used to get the keynames for some sort of\niterator. These keys are worthless in general day-to-day use because\nin the Consed acefile they are simply Contig1, Contig2, ...\n\n\nsub get_contigs {\n    my ($self,$contig) = @_;\n    my @contigs = sort keys %{$self->{'contigs'}};\n    return @contigs;\n}\n\n=head2 get_class($contig_keyname)\n\n Title   : get_class($contig_keyname)\n Usage   : $o_consed->get_class($contig_keyname);\n Function: Return the class name for this contig\n Returns : A scalar representing the class of this contig.\n Args    : None.\n Notes   : \n\n\nsub get_class {\n    my ($self,$contig) = @_;\n    return $self->{contigs}->{$contig}->{class};\n}\n\n=head2 get_quality_array($contig_keyname)\n\n Title   : get_quality_array($contig_keyname)\n Usage   : $o_consed->get_quality_array($contig_keyname);\n Function: Returns the quality for the consensus sequence for the given\n\t   contig as an array. See get_quality_scalar to get this as a scalar.\n Returns : An array containing the quality for the consensus sequence with\n\t   the given keyname.\n Args    : The keyname of a contig. Note: This is a keyname. The key would\n\t   normally come from get_contigs.\n\nReturns an array, not a reference. Is this a bug? I<thinking> No.\nWell, maybe.  Why was this developed like this? I was using FreezeThaw\nfor object persistence, and when it froze out these arrays it took a\nlong time to thaw it. Much better as a scalar.\n\nSee L<get_quality_scalar()|get_quality_scalar>\n\n\nsub get_quality_array {\n    my ($self,$contig) = @_;\n    return split ' ', $self->{contigs}->{$contig}->{quality};\n}\n\n=head2 get_quality_scalar($contig_keyname)\n\n Title   : get_quality_scalar($contig_keyname)\n Usage   : $o_consed->get_quality_scalar($contig_keyname);\n Function: Returns the quality for the consensus sequence for the given\n\t   contig as a scalar. See get_quality_array to get this as an array.\n Returns : An scalar containing the quality for the consensus sequence with\n           the given keyname.\n Args    : The keyname of a contig. Note this is a _keyname_. The key would\n\t   normally come from get_contigs.\n\nWhy was this developed like this? I was using FreezeThaw for object\npersistence, and when it froze out these arrays it took a coon's age\nto thaw it. Much better as a scalar.\n\nSee L<get_quality_array()|get_quality_array>\n\n\n#'\nsub get_quality_scalar {\n    my ($self,$contig) = @_;\n    return $self->{'contigs'}->{$contig}->{'quality'};\n}\n\n=head2 freeze_hash()\n\n Title   : freeze_hash()\n Usage   : $o_consed->freeze_hash();\n\n Function: Use Ilya's FreezeThaw module to create a persistent data\n\t   object for this Bio::Tools::Alignment::Consed data\n\t   structure. In the case of AAFC, we use\n\t   Bio::Tools::Alignment::Consed to pre-process bunches of\n\t   sequences, freeze the structures, and send in a harvesting\n\t   robot later to do database stuff.\n Returns : 0 or 1;\n Args    : None.\n\nThis procedure was removed so Consed.pm won't require FreezeThaw.\n\n\n#'\nsub freeze_hash {\n    my $self = shift;\n    $self->warn(\"This method (freeze_hash) was removed \".\n                \"from the bioperl consed.pm. Sorry.\\n\");\n    if (1==2) {\n        $self->debug(\"Bio::Tools::Alignment::Consed::freeze_hash:\".\n                     \" \\$self->{path} is $self->{path}\\n\");\n        my $filename = $self->{'path'}.\"frozen\";\n        my %contigs = %{$self->{'contigs'}};\n        my $frozen = freeze(%contigs);\n        umask 0001;\n        open (my $FREEZE,\">$filename\") or do {\n            $self->warn( \"Bio::Tools::Alignment::Consed could not \".\n                         \"freeze the contig hash because the file \".\n                         \"($filename) could not be opened: $!\\n\");\n            return 1;\n        };\n        print $FREEZE $frozen;\n        return 0;\n    }\n}\n\n=head2 get_members($contig_keyname)\n\n Title   : get_members($contig_keyname)\n Usage   : $o_consed->get_members($contig_keyname);\n Function: Return the _names_ of the reads in this contig.\n Returns : An array containing the names of the reads in this contig.\n Args    : The keyname of a contig. Note this is a keyname. The keyname\n\t   would normally come from get_contigs.\n\nSee L<get_contigs()|get_contigs>\n\n\nsub get_members {\n    my ($self,$contig) = @_;\n    if (!$contig) {\n\t$self->warn(\"You need to provide the name of a contig to \".\n                    \"use Bio::Tools::Alignment::Consed::get_members!\\n\");\n\treturn;\n    }\n    return @{$self->{'contigs'}->{$contig}->{'member_array'}};\n}\n\n=head2 get_members_by_name($some_arbitrary_name)\n\n Title   : get_members_by_name($some_arbitrary_name)\n Usage   : $o_consed->get_members_by_name($some_arbitrary_name);\n Function: Return the names of the reads in a contig. This is the name given\n\t   to $contig{key} based on what is in the contig. This is different\n\t   from the keys retrieved through get_contigs().\n Returns : An array containing the names of the reads in the contig with this\n\t   name.\n Args    : The name of a contig. Not a key, but a name.\n\nHighly inefficient. use some other method if possible.\nSee L<get_contigs()|get_contigs>","parameters":[{"label":"$self"},{"label":"$name"}],"label":"get_members_by_name($self,$name)"},"detail":"($self,$name)"},{"line":441,"kind":13,"name":"%self","containerName":null},{"line":441,"kind":13,"name":"%currkey","containerName":null},{"line":442,"kind":13,"name":"%self","containerName":null},{"name":"%currkey","containerName":null,"kind":13,"line":442},{"line":443,"kind":13,"name":"@contigs_with_that_name","containerName":null},{"containerName":null,"name":"$currkey","line":443,"kind":13},{"kind":13,"line":446,"containerName":null,"name":"$count","definition":"my","localvar":"my"},{"containerName":null,"name":"@contigs_with_that_name","kind":13,"line":446},{"kind":13,"line":447,"name":"%count","containerName":null},{"containerName":null,"name":"$contig_num","definition":"my","localvar":"my","kind":13,"line":448},{"containerName":null,"name":"@contigs_with_that_name","kind":13,"line":448},{"line":449,"kind":13,"name":"%self","containerName":null},{"name":"%contig_num","containerName":null,"line":449,"kind":13},{"children":[{"line":469,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"get_contig_number_by_name"},{"name":"$name","containerName":"get_contig_number_by_name","line":469,"kind":13},{"localvar":"my","definition":"my","name":"$currkey","containerName":"get_contig_number_by_name","line":470,"kind":13},{"line":470,"kind":13,"name":"$self","containerName":"get_contig_number_by_name"}],"line":468,"kind":12,"signature":{"label":"get_contig_number_by_name($self,$name)","documentation":"1;\n# $Id: Consed.pm 16123 2009-09-17 12:57:27Z cjfields $\n# Bio::Tools::Alignment::Consed\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chad Matsalla\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Alignment::Consed - A module to work with objects from consed .ace files\n\n=head1 SYNOPSIS\n\n  # a report for sequencing stuff\n  my $o_consed = Bio::Tools::Alignment::Consed->new( \n      -acefile => \"/path/to/an/acefile.ace.1\",\n      -verbose => 1);\n  my $foo = $o_consed->set_reverse_designator(\"r\");\n  my $bar = $o_consed->set_forward_designator(\"f\");\n\n  # get the contig numbers\n  my @keys = $o_consed->get_contigs();\n\n  # construct the doublets\n  my $setter_doublets = $o_consed->choose_doublets();\n\n  # get the doublets\n  my @doublets = $o_consed->get_doublets();\n\n=head1 DESCRIPTION\n\nL<Bio::Tools::Alignment::Consed> provides methods and objects to deal\nwith the output from the Consed software suite. Specifically,\ntakes an C<.ace> file and provides objects for the results.\n\nA word about doublets: This module was written to accomodate a large\nEST sequencing operation. In this case, EST's were sequenced from the\n3' and from the 5' end of the EST. The objective was to find a\nconsensus sequence for these two reads.  Thus, a contig of two is what\nwe wanted, and this contig should consist of the forward and reverse\nreads of a getn clone. For example, for a forward designator of \"F\"\nand a reverse designator of \"R\", if the two reads chad1F and chad1R\nwere in a single contig (for example Contig 5) it will be determined\nthat the consensus sequence for Contig 5 will be the sequence for\nclone chad1.\n\nDoublets are good!\n\nThis module parses C<.ace> and related files. A detailed list of methods\ncan be found at the end of this document.\n\nI wrote a detailed rationale for design that may explain the reasons\nwhy some things were done the way they were done. That document is\nbeyond the scope of this pod and can probably be found in the\ndirectory from which this module was 'made' or at\nL<http://www.dieselwurks.com/bioinformatics/consedpm_documentation.pdf>.\n\nNote that the POD in that document might be old but the original\nrationale still stands.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nEmail chad-at-dieselwurks.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n#' \n\npackage Bio::Tools::Alignment::Consed;\n\nuse strict;\n\nuse FileHandle;\nuse Dumpvalue qw(dumpValue);\nuse Bio::Tools::Alignment::Trim;\nuse File::Spec;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\nour %DEFAULTS = ( 'f_designator' => 'f',\n\t\t  'r_designator' => 'r');\n\n=head2 new()\n\n Title   : new(-acefile => $path_to_some_acefile, -verbose => \"1\")\n Usage   : $o_consed = Bio::Tools::Alignment::Consed->\n              new(-acefile => $path_to_some_acefile, -verbose => \"1\");\n Function: Construct the Bio::Tools::Alignment::Consed object. Sets\n\t   verbosity for the following procedures, if necessary:\n\t   1. Construct a new Bio::Tools::Alignment::Trim object, to\n\t   handle quality trimming 2. Read in the acefile and parse it\n\n Returns : A reference to a Bio::Tools::Alignment::Consed object.\n Args    : A hash. (-acefile) is the filename of an acefile. If a full path\n\t   is not specified \"./\" is prepended to the filename and used from\n\t   instantiation until destruction. If you want \n           Bio::Tools::Alignment::Consed to be noisy during parsing of\n           the acefile, specify some value for (-verbose).\n\n\nsub new {\n    my ($class,%args) = @_;\n    my $self = $class->SUPER::new(%args);\n\n    $self->{'filename'} = $args{'-acefile'};\n\n    # this is special to UNIX and should probably use catfile : DONE!\n#    if (!($self->{'filename'} =~ m{/})) { \n#\t$self->{'filename'} = \"./\".$self->{'filename'}; \n#    } \n#    $self->{'filename'} =~ m/(.*\\/)(.*)ace.*$/;\n#    $self->{'path'} = $1;\n\n    # this is more generic and should work on most systems   \n    (undef, $self->{'path'}, undef) = File::Spec->splitpath($self->{'filename'});\n\n    $self->_initialize_io('-file'=>$self->{'filename'});\n    $self->{'o_trim'} = Bio::Tools::Alignment::Trim->new(-verbose => $self->verbose());\n    $self->set_forward_designator($DEFAULTS{'f_designator'});\n    $self->set_reverse_designator($DEFAULTS{'r_designator'});\n\n    $self->_read_file();\n    return $self;\n}\n\n=head2 set_verbose()\n\n Title   : set_verbose()\n Usage   : $o_consed->set_verbose(1);\n Function: Set the verbosity level for debugging messages. On instantiation\n\t   of the Bio::Tools::Alignment::Consed object the verbosity level\n           is set to 0 (quiet).\n Returns : 1 or 0.\n Args    : The verbosity levels are:\n\t      0 - quiet\n\t      1 - noisy\n\t      2 - noisier\n\t      3 - annoyingly noisy\n\nThis method for setting verbosity has largely been superseeded by a\nsub-by-sub way, where for every sub you can provide a (-verbose)\nswitch. I am doing converting this bit-by-bit so do not be surprised\nif some subs do not honour this.\n\n\n# from RootI\n\n# backwards compat\nsub set_verbose { (shift)->verbose(@_) }\n\n=head2 get_filename()\n\n Title   : get_filename()\n Usage   : $o_consed->get_filename();\n Function: Returns the name of the acefile being used by the\n\t   Bio::Tools::Alignment::Consed object.\n Returns : A scalar containing the name of a file.\n Args    : None.\n\n\n\nsub get_filename {\n    my $self = shift;\n    return $self->{'filename'};\n}\n\n=head2 count_sequences_with_grep()\n\n Title   : count_sequences_with_grep()\n Usage   : $o_consed->count_sequences_with_grep();\n Function: Use /bin/grep to scan through the files in the ace project dir\n\t   and count sequences in those files. I used this method in the\n\t   development of this module to verify that I was getting all of the\n\t   sequences. It works, but it is (I think) unix-like platform\n\t   dependent.\n Returns : A scalar containing the number of sequences in the ace project\n\t   directory.\n Args    : None.\n\nIf you are on a non-UNIX platform, you really do not have to use\nthis. It is more of a debugging routine designed to address very\nspecific problems.\n\nThis method was reimplemented to be platform independent with a pure\nperl implementation.  The above note can be ignored.\n\n\nsub count_sequences_with_grep {\n    my $self = shift;\n    my ($working_dir,$grep_cli,@total_grep_sequences);\n    # this should be migrated to a pure perl implementation ala\n    # Tom Christiansen's 'tcgrep'\n    # http://www.cpan.org/modules/by-authors/id/TOMC/scripts/tcgrep.gz\n\n    open(my $FILE, $self->{'filename'}) or do { $self->warn(\"cannot open file \".$self->{'filename'}. \" for grepping\"); return}; \n    my $counter =0;\n    while(<$FILE>) { $counter++ if(/^AF/); }\n\n    close $FILE;\n    opendir(my $SINGLETS,$self->{'path'});\n    foreach my $f ( readdir($SINGLETS) ) {\n\tnext unless ($f =~ /\\.singlets$/); \n\topen(my $FILE, File::Spec->catfile($self->{'path'},$f)) or do{ $self->warn(\"cannot open file \".File::Spec->catfile($self->{'path'},$f)); next };\n\twhile(<$FILE>) { $counter++ if(/^>/) }\n\tclose $FILE;\n    }\n    return $counter;\n}\n\n=head2 get_path()\n\n Title   : get_path()\n Usage   : $o_consed->get_path();\n Function: Returns the path to the acefile this object is working with.\n Returns : Scalar. The path to the working acefile.\n Args    : None.\n\n\nsub get_path {\n    my $self = shift;\n    return $self->{'path'};\n}\n\n=head2 get_contigs()\n\n Title   : get_contigs()\n Usage   : $o_consed->get_contigs();\n Function: Return the keys to the Bio::Tools::Alignment::Consed object.\n Returns : An array containing the keynames in the\n           Bio::Tools::Alignment::Consed object.\n Args    : None.\n\nThis would normally be used to get the keynames for some sort of\niterator. These keys are worthless in general day-to-day use because\nin the Consed acefile they are simply Contig1, Contig2, ...\n\n\nsub get_contigs {\n    my ($self,$contig) = @_;\n    my @contigs = sort keys %{$self->{'contigs'}};\n    return @contigs;\n}\n\n=head2 get_class($contig_keyname)\n\n Title   : get_class($contig_keyname)\n Usage   : $o_consed->get_class($contig_keyname);\n Function: Return the class name for this contig\n Returns : A scalar representing the class of this contig.\n Args    : None.\n Notes   : \n\n\nsub get_class {\n    my ($self,$contig) = @_;\n    return $self->{contigs}->{$contig}->{class};\n}\n\n=head2 get_quality_array($contig_keyname)\n\n Title   : get_quality_array($contig_keyname)\n Usage   : $o_consed->get_quality_array($contig_keyname);\n Function: Returns the quality for the consensus sequence for the given\n\t   contig as an array. See get_quality_scalar to get this as a scalar.\n Returns : An array containing the quality for the consensus sequence with\n\t   the given keyname.\n Args    : The keyname of a contig. Note: This is a keyname. The key would\n\t   normally come from get_contigs.\n\nReturns an array, not a reference. Is this a bug? I<thinking> No.\nWell, maybe.  Why was this developed like this? I was using FreezeThaw\nfor object persistence, and when it froze out these arrays it took a\nlong time to thaw it. Much better as a scalar.\n\nSee L<get_quality_scalar()|get_quality_scalar>\n\n\nsub get_quality_array {\n    my ($self,$contig) = @_;\n    return split ' ', $self->{contigs}->{$contig}->{quality};\n}\n\n=head2 get_quality_scalar($contig_keyname)\n\n Title   : get_quality_scalar($contig_keyname)\n Usage   : $o_consed->get_quality_scalar($contig_keyname);\n Function: Returns the quality for the consensus sequence for the given\n\t   contig as a scalar. See get_quality_array to get this as an array.\n Returns : An scalar containing the quality for the consensus sequence with\n           the given keyname.\n Args    : The keyname of a contig. Note this is a _keyname_. The key would\n\t   normally come from get_contigs.\n\nWhy was this developed like this? I was using FreezeThaw for object\npersistence, and when it froze out these arrays it took a coon's age\nto thaw it. Much better as a scalar.\n\nSee L<get_quality_array()|get_quality_array>\n\n\n#'\nsub get_quality_scalar {\n    my ($self,$contig) = @_;\n    return $self->{'contigs'}->{$contig}->{'quality'};\n}\n\n=head2 freeze_hash()\n\n Title   : freeze_hash()\n Usage   : $o_consed->freeze_hash();\n\n Function: Use Ilya's FreezeThaw module to create a persistent data\n\t   object for this Bio::Tools::Alignment::Consed data\n\t   structure. In the case of AAFC, we use\n\t   Bio::Tools::Alignment::Consed to pre-process bunches of\n\t   sequences, freeze the structures, and send in a harvesting\n\t   robot later to do database stuff.\n Returns : 0 or 1;\n Args    : None.\n\nThis procedure was removed so Consed.pm won't require FreezeThaw.\n\n\n#'\nsub freeze_hash {\n    my $self = shift;\n    $self->warn(\"This method (freeze_hash) was removed \".\n                \"from the bioperl consed.pm. Sorry.\\n\");\n    if (1==2) {\n        $self->debug(\"Bio::Tools::Alignment::Consed::freeze_hash:\".\n                     \" \\$self->{path} is $self->{path}\\n\");\n        my $filename = $self->{'path'}.\"frozen\";\n        my %contigs = %{$self->{'contigs'}};\n        my $frozen = freeze(%contigs);\n        umask 0001;\n        open (my $FREEZE,\">$filename\") or do {\n            $self->warn( \"Bio::Tools::Alignment::Consed could not \".\n                         \"freeze the contig hash because the file \".\n                         \"($filename) could not be opened: $!\\n\");\n            return 1;\n        };\n        print $FREEZE $frozen;\n        return 0;\n    }\n}\n\n=head2 get_members($contig_keyname)\n\n Title   : get_members($contig_keyname)\n Usage   : $o_consed->get_members($contig_keyname);\n Function: Return the _names_ of the reads in this contig.\n Returns : An array containing the names of the reads in this contig.\n Args    : The keyname of a contig. Note this is a keyname. The keyname\n\t   would normally come from get_contigs.\n\nSee L<get_contigs()|get_contigs>\n\n\nsub get_members {\n    my ($self,$contig) = @_;\n    if (!$contig) {\n\t$self->warn(\"You need to provide the name of a contig to \".\n                    \"use Bio::Tools::Alignment::Consed::get_members!\\n\");\n\treturn;\n    }\n    return @{$self->{'contigs'}->{$contig}->{'member_array'}};\n}\n\n=head2 get_members_by_name($some_arbitrary_name)\n\n Title   : get_members_by_name($some_arbitrary_name)\n Usage   : $o_consed->get_members_by_name($some_arbitrary_name);\n Function: Return the names of the reads in a contig. This is the name given\n\t   to $contig{key} based on what is in the contig. This is different\n\t   from the keys retrieved through get_contigs().\n Returns : An array containing the names of the reads in the contig with this\n\t   name.\n Args    : The name of a contig. Not a key, but a name.\n\nHighly inefficient. use some other method if possible.\nSee L<get_contigs()|get_contigs>\n\n\nsub get_members_by_name {\n    my ($self,$name) = @_;\n    # build a list to try to screen for redundancy\n    my @contigs_with_that_name;\n    foreach my $currkey ( sort keys %{$self->{'contigs'}} ) {\n\tnext if (!$self->{'contigs'}->{$currkey}->{'name'});\n\tif ($self->{'contigs'}->{$currkey}->{'name'} eq \"$name\") {\n\t    push @contigs_with_that_name,$currkey;\n\t}\n    }\n    my $count = @contigs_with_that_name;\n    if ($count == 1) {\n\tmy $contig_num = $contigs_with_that_name[0];\n\treturn @{$self->{'contigs'}->{$contig_num}->{'member_array'}};\n    }\n}\n\n=head2 get_contig_number_by_name($some_arbitrary_name)\n\n Title   : get_contig_number_by_name($some_arbitrary_name)\n Usage   : $o_consed->get_contig_number_by_name($some_arbitrary_name);\n Function: Return the names of the reads in a contig. This is the name given\n\t   to $contig{key} based on what is in the contig. This is different\n\t   from the keys retrieved through get_contigs().\n Returns : An array containing the names of the reads in the contig with this\n\t   name.\n Args    : The name of a contig. Not a key, but a name.\n\nSee L<get_contigs()|get_contigs>","parameters":[{"label":"$self"},{"label":"$name"}]},"detail":"($self,$name)","definition":"sub","containerName":"main::","range":{"start":{"line":468,"character":0},"end":{"line":470,"character":9999}},"name":"get_contig_number_by_name"},{"name":"%self","containerName":null,"line":471,"kind":13},{"line":471,"kind":13,"containerName":null,"name":"%currkey"},{"kind":13,"line":472,"containerName":null,"name":"%self"},{"name":"%currkey","containerName":null,"line":472,"kind":13},{"kind":13,"line":473,"name":"$currkey","containerName":null},{"signature":{"label":"get_sequence($self,$contig)","documentation":"1;\n# $Id: Consed.pm 16123 2009-09-17 12:57:27Z cjfields $\n# Bio::Tools::Alignment::Consed\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chad Matsalla\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Alignment::Consed - A module to work with objects from consed .ace files\n\n=head1 SYNOPSIS\n\n  # a report for sequencing stuff\n  my $o_consed = Bio::Tools::Alignment::Consed->new( \n      -acefile => \"/path/to/an/acefile.ace.1\",\n      -verbose => 1);\n  my $foo = $o_consed->set_reverse_designator(\"r\");\n  my $bar = $o_consed->set_forward_designator(\"f\");\n\n  # get the contig numbers\n  my @keys = $o_consed->get_contigs();\n\n  # construct the doublets\n  my $setter_doublets = $o_consed->choose_doublets();\n\n  # get the doublets\n  my @doublets = $o_consed->get_doublets();\n\n=head1 DESCRIPTION\n\nL<Bio::Tools::Alignment::Consed> provides methods and objects to deal\nwith the output from the Consed software suite. Specifically,\ntakes an C<.ace> file and provides objects for the results.\n\nA word about doublets: This module was written to accomodate a large\nEST sequencing operation. In this case, EST's were sequenced from the\n3' and from the 5' end of the EST. The objective was to find a\nconsensus sequence for these two reads.  Thus, a contig of two is what\nwe wanted, and this contig should consist of the forward and reverse\nreads of a getn clone. For example, for a forward designator of \"F\"\nand a reverse designator of \"R\", if the two reads chad1F and chad1R\nwere in a single contig (for example Contig 5) it will be determined\nthat the consensus sequence for Contig 5 will be the sequence for\nclone chad1.\n\nDoublets are good!\n\nThis module parses C<.ace> and related files. A detailed list of methods\ncan be found at the end of this document.\n\nI wrote a detailed rationale for design that may explain the reasons\nwhy some things were done the way they were done. That document is\nbeyond the scope of this pod and can probably be found in the\ndirectory from which this module was 'made' or at\nL<http://www.dieselwurks.com/bioinformatics/consedpm_documentation.pdf>.\n\nNote that the POD in that document might be old but the original\nrationale still stands.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nEmail chad-at-dieselwurks.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n#' \n\npackage Bio::Tools::Alignment::Consed;\n\nuse strict;\n\nuse FileHandle;\nuse Dumpvalue qw(dumpValue);\nuse Bio::Tools::Alignment::Trim;\nuse File::Spec;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\nour %DEFAULTS = ( 'f_designator' => 'f',\n\t\t  'r_designator' => 'r');\n\n=head2 new()\n\n Title   : new(-acefile => $path_to_some_acefile, -verbose => \"1\")\n Usage   : $o_consed = Bio::Tools::Alignment::Consed->\n              new(-acefile => $path_to_some_acefile, -verbose => \"1\");\n Function: Construct the Bio::Tools::Alignment::Consed object. Sets\n\t   verbosity for the following procedures, if necessary:\n\t   1. Construct a new Bio::Tools::Alignment::Trim object, to\n\t   handle quality trimming 2. Read in the acefile and parse it\n\n Returns : A reference to a Bio::Tools::Alignment::Consed object.\n Args    : A hash. (-acefile) is the filename of an acefile. If a full path\n\t   is not specified \"./\" is prepended to the filename and used from\n\t   instantiation until destruction. If you want \n           Bio::Tools::Alignment::Consed to be noisy during parsing of\n           the acefile, specify some value for (-verbose).\n\n\nsub new {\n    my ($class,%args) = @_;\n    my $self = $class->SUPER::new(%args);\n\n    $self->{'filename'} = $args{'-acefile'};\n\n    # this is special to UNIX and should probably use catfile : DONE!\n#    if (!($self->{'filename'} =~ m{/})) { \n#\t$self->{'filename'} = \"./\".$self->{'filename'}; \n#    } \n#    $self->{'filename'} =~ m/(.*\\/)(.*)ace.*$/;\n#    $self->{'path'} = $1;\n\n    # this is more generic and should work on most systems   \n    (undef, $self->{'path'}, undef) = File::Spec->splitpath($self->{'filename'});\n\n    $self->_initialize_io('-file'=>$self->{'filename'});\n    $self->{'o_trim'} = Bio::Tools::Alignment::Trim->new(-verbose => $self->verbose());\n    $self->set_forward_designator($DEFAULTS{'f_designator'});\n    $self->set_reverse_designator($DEFAULTS{'r_designator'});\n\n    $self->_read_file();\n    return $self;\n}\n\n=head2 set_verbose()\n\n Title   : set_verbose()\n Usage   : $o_consed->set_verbose(1);\n Function: Set the verbosity level for debugging messages. On instantiation\n\t   of the Bio::Tools::Alignment::Consed object the verbosity level\n           is set to 0 (quiet).\n Returns : 1 or 0.\n Args    : The verbosity levels are:\n\t      0 - quiet\n\t      1 - noisy\n\t      2 - noisier\n\t      3 - annoyingly noisy\n\nThis method for setting verbosity has largely been superseeded by a\nsub-by-sub way, where for every sub you can provide a (-verbose)\nswitch. I am doing converting this bit-by-bit so do not be surprised\nif some subs do not honour this.\n\n\n# from RootI\n\n# backwards compat\nsub set_verbose { (shift)->verbose(@_) }\n\n=head2 get_filename()\n\n Title   : get_filename()\n Usage   : $o_consed->get_filename();\n Function: Returns the name of the acefile being used by the\n\t   Bio::Tools::Alignment::Consed object.\n Returns : A scalar containing the name of a file.\n Args    : None.\n\n\n\nsub get_filename {\n    my $self = shift;\n    return $self->{'filename'};\n}\n\n=head2 count_sequences_with_grep()\n\n Title   : count_sequences_with_grep()\n Usage   : $o_consed->count_sequences_with_grep();\n Function: Use /bin/grep to scan through the files in the ace project dir\n\t   and count sequences in those files. I used this method in the\n\t   development of this module to verify that I was getting all of the\n\t   sequences. It works, but it is (I think) unix-like platform\n\t   dependent.\n Returns : A scalar containing the number of sequences in the ace project\n\t   directory.\n Args    : None.\n\nIf you are on a non-UNIX platform, you really do not have to use\nthis. It is more of a debugging routine designed to address very\nspecific problems.\n\nThis method was reimplemented to be platform independent with a pure\nperl implementation.  The above note can be ignored.\n\n\nsub count_sequences_with_grep {\n    my $self = shift;\n    my ($working_dir,$grep_cli,@total_grep_sequences);\n    # this should be migrated to a pure perl implementation ala\n    # Tom Christiansen's 'tcgrep'\n    # http://www.cpan.org/modules/by-authors/id/TOMC/scripts/tcgrep.gz\n\n    open(my $FILE, $self->{'filename'}) or do { $self->warn(\"cannot open file \".$self->{'filename'}. \" for grepping\"); return}; \n    my $counter =0;\n    while(<$FILE>) { $counter++ if(/^AF/); }\n\n    close $FILE;\n    opendir(my $SINGLETS,$self->{'path'});\n    foreach my $f ( readdir($SINGLETS) ) {\n\tnext unless ($f =~ /\\.singlets$/); \n\topen(my $FILE, File::Spec->catfile($self->{'path'},$f)) or do{ $self->warn(\"cannot open file \".File::Spec->catfile($self->{'path'},$f)); next };\n\twhile(<$FILE>) { $counter++ if(/^>/) }\n\tclose $FILE;\n    }\n    return $counter;\n}\n\n=head2 get_path()\n\n Title   : get_path()\n Usage   : $o_consed->get_path();\n Function: Returns the path to the acefile this object is working with.\n Returns : Scalar. The path to the working acefile.\n Args    : None.\n\n\nsub get_path {\n    my $self = shift;\n    return $self->{'path'};\n}\n\n=head2 get_contigs()\n\n Title   : get_contigs()\n Usage   : $o_consed->get_contigs();\n Function: Return the keys to the Bio::Tools::Alignment::Consed object.\n Returns : An array containing the keynames in the\n           Bio::Tools::Alignment::Consed object.\n Args    : None.\n\nThis would normally be used to get the keynames for some sort of\niterator. These keys are worthless in general day-to-day use because\nin the Consed acefile they are simply Contig1, Contig2, ...\n\n\nsub get_contigs {\n    my ($self,$contig) = @_;\n    my @contigs = sort keys %{$self->{'contigs'}};\n    return @contigs;\n}\n\n=head2 get_class($contig_keyname)\n\n Title   : get_class($contig_keyname)\n Usage   : $o_consed->get_class($contig_keyname);\n Function: Return the class name for this contig\n Returns : A scalar representing the class of this contig.\n Args    : None.\n Notes   : \n\n\nsub get_class {\n    my ($self,$contig) = @_;\n    return $self->{contigs}->{$contig}->{class};\n}\n\n=head2 get_quality_array($contig_keyname)\n\n Title   : get_quality_array($contig_keyname)\n Usage   : $o_consed->get_quality_array($contig_keyname);\n Function: Returns the quality for the consensus sequence for the given\n\t   contig as an array. See get_quality_scalar to get this as a scalar.\n Returns : An array containing the quality for the consensus sequence with\n\t   the given keyname.\n Args    : The keyname of a contig. Note: This is a keyname. The key would\n\t   normally come from get_contigs.\n\nReturns an array, not a reference. Is this a bug? I<thinking> No.\nWell, maybe.  Why was this developed like this? I was using FreezeThaw\nfor object persistence, and when it froze out these arrays it took a\nlong time to thaw it. Much better as a scalar.\n\nSee L<get_quality_scalar()|get_quality_scalar>\n\n\nsub get_quality_array {\n    my ($self,$contig) = @_;\n    return split ' ', $self->{contigs}->{$contig}->{quality};\n}\n\n=head2 get_quality_scalar($contig_keyname)\n\n Title   : get_quality_scalar($contig_keyname)\n Usage   : $o_consed->get_quality_scalar($contig_keyname);\n Function: Returns the quality for the consensus sequence for the given\n\t   contig as a scalar. See get_quality_array to get this as an array.\n Returns : An scalar containing the quality for the consensus sequence with\n           the given keyname.\n Args    : The keyname of a contig. Note this is a _keyname_. The key would\n\t   normally come from get_contigs.\n\nWhy was this developed like this? I was using FreezeThaw for object\npersistence, and when it froze out these arrays it took a coon's age\nto thaw it. Much better as a scalar.\n\nSee L<get_quality_array()|get_quality_array>\n\n\n#'\nsub get_quality_scalar {\n    my ($self,$contig) = @_;\n    return $self->{'contigs'}->{$contig}->{'quality'};\n}\n\n=head2 freeze_hash()\n\n Title   : freeze_hash()\n Usage   : $o_consed->freeze_hash();\n\n Function: Use Ilya's FreezeThaw module to create a persistent data\n\t   object for this Bio::Tools::Alignment::Consed data\n\t   structure. In the case of AAFC, we use\n\t   Bio::Tools::Alignment::Consed to pre-process bunches of\n\t   sequences, freeze the structures, and send in a harvesting\n\t   robot later to do database stuff.\n Returns : 0 or 1;\n Args    : None.\n\nThis procedure was removed so Consed.pm won't require FreezeThaw.\n\n\n#'\nsub freeze_hash {\n    my $self = shift;\n    $self->warn(\"This method (freeze_hash) was removed \".\n                \"from the bioperl consed.pm. Sorry.\\n\");\n    if (1==2) {\n        $self->debug(\"Bio::Tools::Alignment::Consed::freeze_hash:\".\n                     \" \\$self->{path} is $self->{path}\\n\");\n        my $filename = $self->{'path'}.\"frozen\";\n        my %contigs = %{$self->{'contigs'}};\n        my $frozen = freeze(%contigs);\n        umask 0001;\n        open (my $FREEZE,\">$filename\") or do {\n            $self->warn( \"Bio::Tools::Alignment::Consed could not \".\n                         \"freeze the contig hash because the file \".\n                         \"($filename) could not be opened: $!\\n\");\n            return 1;\n        };\n        print $FREEZE $frozen;\n        return 0;\n    }\n}\n\n=head2 get_members($contig_keyname)\n\n Title   : get_members($contig_keyname)\n Usage   : $o_consed->get_members($contig_keyname);\n Function: Return the _names_ of the reads in this contig.\n Returns : An array containing the names of the reads in this contig.\n Args    : The keyname of a contig. Note this is a keyname. The keyname\n\t   would normally come from get_contigs.\n\nSee L<get_contigs()|get_contigs>\n\n\nsub get_members {\n    my ($self,$contig) = @_;\n    if (!$contig) {\n\t$self->warn(\"You need to provide the name of a contig to \".\n                    \"use Bio::Tools::Alignment::Consed::get_members!\\n\");\n\treturn;\n    }\n    return @{$self->{'contigs'}->{$contig}->{'member_array'}};\n}\n\n=head2 get_members_by_name($some_arbitrary_name)\n\n Title   : get_members_by_name($some_arbitrary_name)\n Usage   : $o_consed->get_members_by_name($some_arbitrary_name);\n Function: Return the names of the reads in a contig. This is the name given\n\t   to $contig{key} based on what is in the contig. This is different\n\t   from the keys retrieved through get_contigs().\n Returns : An array containing the names of the reads in the contig with this\n\t   name.\n Args    : The name of a contig. Not a key, but a name.\n\nHighly inefficient. use some other method if possible.\nSee L<get_contigs()|get_contigs>\n\n\nsub get_members_by_name {\n    my ($self,$name) = @_;\n    # build a list to try to screen for redundancy\n    my @contigs_with_that_name;\n    foreach my $currkey ( sort keys %{$self->{'contigs'}} ) {\n\tnext if (!$self->{'contigs'}->{$currkey}->{'name'});\n\tif ($self->{'contigs'}->{$currkey}->{'name'} eq \"$name\") {\n\t    push @contigs_with_that_name,$currkey;\n\t}\n    }\n    my $count = @contigs_with_that_name;\n    if ($count == 1) {\n\tmy $contig_num = $contigs_with_that_name[0];\n\treturn @{$self->{'contigs'}->{$contig_num}->{'member_array'}};\n    }\n}\n\n=head2 get_contig_number_by_name($some_arbitrary_name)\n\n Title   : get_contig_number_by_name($some_arbitrary_name)\n Usage   : $o_consed->get_contig_number_by_name($some_arbitrary_name);\n Function: Return the names of the reads in a contig. This is the name given\n\t   to $contig{key} based on what is in the contig. This is different\n\t   from the keys retrieved through get_contigs().\n Returns : An array containing the names of the reads in the contig with this\n\t   name.\n Args    : The name of a contig. Not a key, but a name.\n\nSee L<get_contigs()|get_contigs>\n\n\nsub get_contig_number_by_name {\n    my ($self,$name) = @_;\n    foreach my $currkey (sort keys %{$self->{'contigs'}}) {\n\tif ($self->{'contigs'}->{$currkey}->{'name'} && \n\t    $self->{'contigs'}->{$currkey}->{'name'} eq \"$name\") {\n\t    return $currkey;\n\t}\n    }\n}\t\n\n=head2 get_sequence($contig_keyname)\n\n Title   : get_sequence($contig_keyname)\n Usage   : $o_consed->get_sequence($contig_keyname); \n Function: Returns the consensus sequence for a given contig.\n Returns : A scalar containing a sequence.\n Args    : The keyname of a contig. Note this is a key. The key would\n\t   normally come from get_contigs.\n\nSee L<get_contigs()|get_contigs>","parameters":[{"label":"$self"},{"label":"$contig"}]},"detail":"($self,$contig)","definition":"sub","containerName":"main::","children":[{"localvar":"my","name":"$self","definition":"my","containerName":"get_sequence","line":492,"kind":13},{"line":492,"kind":13,"name":"$contig","containerName":"get_sequence"},{"name":"$self","containerName":"get_sequence","line":493,"kind":13},{"containerName":"get_sequence","name":"$contig","line":493,"kind":13}],"line":491,"kind":12,"range":{"end":{"line":494,"character":9999},"start":{"line":491,"character":0}},"name":"get_sequence"},{"range":{"end":{"character":9999,"line":521},"start":{"character":0,"line":510}},"name":"set_final_sequence","signature":{"documentation":"1;\n# $Id: Consed.pm 16123 2009-09-17 12:57:27Z cjfields $\n# Bio::Tools::Alignment::Consed\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chad Matsalla\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Alignment::Consed - A module to work with objects from consed .ace files\n\n=head1 SYNOPSIS\n\n  # a report for sequencing stuff\n  my $o_consed = Bio::Tools::Alignment::Consed->new( \n      -acefile => \"/path/to/an/acefile.ace.1\",\n      -verbose => 1);\n  my $foo = $o_consed->set_reverse_designator(\"r\");\n  my $bar = $o_consed->set_forward_designator(\"f\");\n\n  # get the contig numbers\n  my @keys = $o_consed->get_contigs();\n\n  # construct the doublets\n  my $setter_doublets = $o_consed->choose_doublets();\n\n  # get the doublets\n  my @doublets = $o_consed->get_doublets();\n\n=head1 DESCRIPTION\n\nL<Bio::Tools::Alignment::Consed> provides methods and objects to deal\nwith the output from the Consed software suite. Specifically,\ntakes an C<.ace> file and provides objects for the results.\n\nA word about doublets: This module was written to accomodate a large\nEST sequencing operation. In this case, EST's were sequenced from the\n3' and from the 5' end of the EST. The objective was to find a\nconsensus sequence for these two reads.  Thus, a contig of two is what\nwe wanted, and this contig should consist of the forward and reverse\nreads of a getn clone. For example, for a forward designator of \"F\"\nand a reverse designator of \"R\", if the two reads chad1F and chad1R\nwere in a single contig (for example Contig 5) it will be determined\nthat the consensus sequence for Contig 5 will be the sequence for\nclone chad1.\n\nDoublets are good!\n\nThis module parses C<.ace> and related files. A detailed list of methods\ncan be found at the end of this document.\n\nI wrote a detailed rationale for design that may explain the reasons\nwhy some things were done the way they were done. That document is\nbeyond the scope of this pod and can probably be found in the\ndirectory from which this module was 'made' or at\nL<http://www.dieselwurks.com/bioinformatics/consedpm_documentation.pdf>.\n\nNote that the POD in that document might be old but the original\nrationale still stands.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nEmail chad-at-dieselwurks.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n#' \n\npackage Bio::Tools::Alignment::Consed;\n\nuse strict;\n\nuse FileHandle;\nuse Dumpvalue qw(dumpValue);\nuse Bio::Tools::Alignment::Trim;\nuse File::Spec;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\nour %DEFAULTS = ( 'f_designator' => 'f',\n\t\t  'r_designator' => 'r');\n\n=head2 new()\n\n Title   : new(-acefile => $path_to_some_acefile, -verbose => \"1\")\n Usage   : $o_consed = Bio::Tools::Alignment::Consed->\n              new(-acefile => $path_to_some_acefile, -verbose => \"1\");\n Function: Construct the Bio::Tools::Alignment::Consed object. Sets\n\t   verbosity for the following procedures, if necessary:\n\t   1. Construct a new Bio::Tools::Alignment::Trim object, to\n\t   handle quality trimming 2. Read in the acefile and parse it\n\n Returns : A reference to a Bio::Tools::Alignment::Consed object.\n Args    : A hash. (-acefile) is the filename of an acefile. If a full path\n\t   is not specified \"./\" is prepended to the filename and used from\n\t   instantiation until destruction. If you want \n           Bio::Tools::Alignment::Consed to be noisy during parsing of\n           the acefile, specify some value for (-verbose).\n\n\nsub new {\n    my ($class,%args) = @_;\n    my $self = $class->SUPER::new(%args);\n\n    $self->{'filename'} = $args{'-acefile'};\n\n    # this is special to UNIX and should probably use catfile : DONE!\n#    if (!($self->{'filename'} =~ m{/})) { \n#\t$self->{'filename'} = \"./\".$self->{'filename'}; \n#    } \n#    $self->{'filename'} =~ m/(.*\\/)(.*)ace.*$/;\n#    $self->{'path'} = $1;\n\n    # this is more generic and should work on most systems   \n    (undef, $self->{'path'}, undef) = File::Spec->splitpath($self->{'filename'});\n\n    $self->_initialize_io('-file'=>$self->{'filename'});\n    $self->{'o_trim'} = Bio::Tools::Alignment::Trim->new(-verbose => $self->verbose());\n    $self->set_forward_designator($DEFAULTS{'f_designator'});\n    $self->set_reverse_designator($DEFAULTS{'r_designator'});\n\n    $self->_read_file();\n    return $self;\n}\n\n=head2 set_verbose()\n\n Title   : set_verbose()\n Usage   : $o_consed->set_verbose(1);\n Function: Set the verbosity level for debugging messages. On instantiation\n\t   of the Bio::Tools::Alignment::Consed object the verbosity level\n           is set to 0 (quiet).\n Returns : 1 or 0.\n Args    : The verbosity levels are:\n\t      0 - quiet\n\t      1 - noisy\n\t      2 - noisier\n\t      3 - annoyingly noisy\n\nThis method for setting verbosity has largely been superseeded by a\nsub-by-sub way, where for every sub you can provide a (-verbose)\nswitch. I am doing converting this bit-by-bit so do not be surprised\nif some subs do not honour this.\n\n\n# from RootI\n\n# backwards compat\nsub set_verbose { (shift)->verbose(@_) }\n\n=head2 get_filename()\n\n Title   : get_filename()\n Usage   : $o_consed->get_filename();\n Function: Returns the name of the acefile being used by the\n\t   Bio::Tools::Alignment::Consed object.\n Returns : A scalar containing the name of a file.\n Args    : None.\n\n\n\nsub get_filename {\n    my $self = shift;\n    return $self->{'filename'};\n}\n\n=head2 count_sequences_with_grep()\n\n Title   : count_sequences_with_grep()\n Usage   : $o_consed->count_sequences_with_grep();\n Function: Use /bin/grep to scan through the files in the ace project dir\n\t   and count sequences in those files. I used this method in the\n\t   development of this module to verify that I was getting all of the\n\t   sequences. It works, but it is (I think) unix-like platform\n\t   dependent.\n Returns : A scalar containing the number of sequences in the ace project\n\t   directory.\n Args    : None.\n\nIf you are on a non-UNIX platform, you really do not have to use\nthis. It is more of a debugging routine designed to address very\nspecific problems.\n\nThis method was reimplemented to be platform independent with a pure\nperl implementation.  The above note can be ignored.\n\n\nsub count_sequences_with_grep {\n    my $self = shift;\n    my ($working_dir,$grep_cli,@total_grep_sequences);\n    # this should be migrated to a pure perl implementation ala\n    # Tom Christiansen's 'tcgrep'\n    # http://www.cpan.org/modules/by-authors/id/TOMC/scripts/tcgrep.gz\n\n    open(my $FILE, $self->{'filename'}) or do { $self->warn(\"cannot open file \".$self->{'filename'}. \" for grepping\"); return}; \n    my $counter =0;\n    while(<$FILE>) { $counter++ if(/^AF/); }\n\n    close $FILE;\n    opendir(my $SINGLETS,$self->{'path'});\n    foreach my $f ( readdir($SINGLETS) ) {\n\tnext unless ($f =~ /\\.singlets$/); \n\topen(my $FILE, File::Spec->catfile($self->{'path'},$f)) or do{ $self->warn(\"cannot open file \".File::Spec->catfile($self->{'path'},$f)); next };\n\twhile(<$FILE>) { $counter++ if(/^>/) }\n\tclose $FILE;\n    }\n    return $counter;\n}\n\n=head2 get_path()\n\n Title   : get_path()\n Usage   : $o_consed->get_path();\n Function: Returns the path to the acefile this object is working with.\n Returns : Scalar. The path to the working acefile.\n Args    : None.\n\n\nsub get_path {\n    my $self = shift;\n    return $self->{'path'};\n}\n\n=head2 get_contigs()\n\n Title   : get_contigs()\n Usage   : $o_consed->get_contigs();\n Function: Return the keys to the Bio::Tools::Alignment::Consed object.\n Returns : An array containing the keynames in the\n           Bio::Tools::Alignment::Consed object.\n Args    : None.\n\nThis would normally be used to get the keynames for some sort of\niterator. These keys are worthless in general day-to-day use because\nin the Consed acefile they are simply Contig1, Contig2, ...\n\n\nsub get_contigs {\n    my ($self,$contig) = @_;\n    my @contigs = sort keys %{$self->{'contigs'}};\n    return @contigs;\n}\n\n=head2 get_class($contig_keyname)\n\n Title   : get_class($contig_keyname)\n Usage   : $o_consed->get_class($contig_keyname);\n Function: Return the class name for this contig\n Returns : A scalar representing the class of this contig.\n Args    : None.\n Notes   : \n\n\nsub get_class {\n    my ($self,$contig) = @_;\n    return $self->{contigs}->{$contig}->{class};\n}\n\n=head2 get_quality_array($contig_keyname)\n\n Title   : get_quality_array($contig_keyname)\n Usage   : $o_consed->get_quality_array($contig_keyname);\n Function: Returns the quality for the consensus sequence for the given\n\t   contig as an array. See get_quality_scalar to get this as a scalar.\n Returns : An array containing the quality for the consensus sequence with\n\t   the given keyname.\n Args    : The keyname of a contig. Note: This is a keyname. The key would\n\t   normally come from get_contigs.\n\nReturns an array, not a reference. Is this a bug? I<thinking> No.\nWell, maybe.  Why was this developed like this? I was using FreezeThaw\nfor object persistence, and when it froze out these arrays it took a\nlong time to thaw it. Much better as a scalar.\n\nSee L<get_quality_scalar()|get_quality_scalar>\n\n\nsub get_quality_array {\n    my ($self,$contig) = @_;\n    return split ' ', $self->{contigs}->{$contig}->{quality};\n}\n\n=head2 get_quality_scalar($contig_keyname)\n\n Title   : get_quality_scalar($contig_keyname)\n Usage   : $o_consed->get_quality_scalar($contig_keyname);\n Function: Returns the quality for the consensus sequence for the given\n\t   contig as a scalar. See get_quality_array to get this as an array.\n Returns : An scalar containing the quality for the consensus sequence with\n           the given keyname.\n Args    : The keyname of a contig. Note this is a _keyname_. The key would\n\t   normally come from get_contigs.\n\nWhy was this developed like this? I was using FreezeThaw for object\npersistence, and when it froze out these arrays it took a coon's age\nto thaw it. Much better as a scalar.\n\nSee L<get_quality_array()|get_quality_array>\n\n\n#'\nsub get_quality_scalar {\n    my ($self,$contig) = @_;\n    return $self->{'contigs'}->{$contig}->{'quality'};\n}\n\n=head2 freeze_hash()\n\n Title   : freeze_hash()\n Usage   : $o_consed->freeze_hash();\n\n Function: Use Ilya's FreezeThaw module to create a persistent data\n\t   object for this Bio::Tools::Alignment::Consed data\n\t   structure. In the case of AAFC, we use\n\t   Bio::Tools::Alignment::Consed to pre-process bunches of\n\t   sequences, freeze the structures, and send in a harvesting\n\t   robot later to do database stuff.\n Returns : 0 or 1;\n Args    : None.\n\nThis procedure was removed so Consed.pm won't require FreezeThaw.\n\n\n#'\nsub freeze_hash {\n    my $self = shift;\n    $self->warn(\"This method (freeze_hash) was removed \".\n                \"from the bioperl consed.pm. Sorry.\\n\");\n    if (1==2) {\n        $self->debug(\"Bio::Tools::Alignment::Consed::freeze_hash:\".\n                     \" \\$self->{path} is $self->{path}\\n\");\n        my $filename = $self->{'path'}.\"frozen\";\n        my %contigs = %{$self->{'contigs'}};\n        my $frozen = freeze(%contigs);\n        umask 0001;\n        open (my $FREEZE,\">$filename\") or do {\n            $self->warn( \"Bio::Tools::Alignment::Consed could not \".\n                         \"freeze the contig hash because the file \".\n                         \"($filename) could not be opened: $!\\n\");\n            return 1;\n        };\n        print $FREEZE $frozen;\n        return 0;\n    }\n}\n\n=head2 get_members($contig_keyname)\n\n Title   : get_members($contig_keyname)\n Usage   : $o_consed->get_members($contig_keyname);\n Function: Return the _names_ of the reads in this contig.\n Returns : An array containing the names of the reads in this contig.\n Args    : The keyname of a contig. Note this is a keyname. The keyname\n\t   would normally come from get_contigs.\n\nSee L<get_contigs()|get_contigs>\n\n\nsub get_members {\n    my ($self,$contig) = @_;\n    if (!$contig) {\n\t$self->warn(\"You need to provide the name of a contig to \".\n                    \"use Bio::Tools::Alignment::Consed::get_members!\\n\");\n\treturn;\n    }\n    return @{$self->{'contigs'}->{$contig}->{'member_array'}};\n}\n\n=head2 get_members_by_name($some_arbitrary_name)\n\n Title   : get_members_by_name($some_arbitrary_name)\n Usage   : $o_consed->get_members_by_name($some_arbitrary_name);\n Function: Return the names of the reads in a contig. This is the name given\n\t   to $contig{key} based on what is in the contig. This is different\n\t   from the keys retrieved through get_contigs().\n Returns : An array containing the names of the reads in the contig with this\n\t   name.\n Args    : The name of a contig. Not a key, but a name.\n\nHighly inefficient. use some other method if possible.\nSee L<get_contigs()|get_contigs>\n\n\nsub get_members_by_name {\n    my ($self,$name) = @_;\n    # build a list to try to screen for redundancy\n    my @contigs_with_that_name;\n    foreach my $currkey ( sort keys %{$self->{'contigs'}} ) {\n\tnext if (!$self->{'contigs'}->{$currkey}->{'name'});\n\tif ($self->{'contigs'}->{$currkey}->{'name'} eq \"$name\") {\n\t    push @contigs_with_that_name,$currkey;\n\t}\n    }\n    my $count = @contigs_with_that_name;\n    if ($count == 1) {\n\tmy $contig_num = $contigs_with_that_name[0];\n\treturn @{$self->{'contigs'}->{$contig_num}->{'member_array'}};\n    }\n}\n\n=head2 get_contig_number_by_name($some_arbitrary_name)\n\n Title   : get_contig_number_by_name($some_arbitrary_name)\n Usage   : $o_consed->get_contig_number_by_name($some_arbitrary_name);\n Function: Return the names of the reads in a contig. This is the name given\n\t   to $contig{key} based on what is in the contig. This is different\n\t   from the keys retrieved through get_contigs().\n Returns : An array containing the names of the reads in the contig with this\n\t   name.\n Args    : The name of a contig. Not a key, but a name.\n\nSee L<get_contigs()|get_contigs>\n\n\nsub get_contig_number_by_name {\n    my ($self,$name) = @_;\n    foreach my $currkey (sort keys %{$self->{'contigs'}}) {\n\tif ($self->{'contigs'}->{$currkey}->{'name'} && \n\t    $self->{'contigs'}->{$currkey}->{'name'} eq \"$name\") {\n\t    return $currkey;\n\t}\n    }\n}\t\n\n=head2 get_sequence($contig_keyname)\n\n Title   : get_sequence($contig_keyname)\n Usage   : $o_consed->get_sequence($contig_keyname); \n Function: Returns the consensus sequence for a given contig.\n Returns : A scalar containing a sequence.\n Args    : The keyname of a contig. Note this is a key. The key would\n\t   normally come from get_contigs.\n\nSee L<get_contigs()|get_contigs>\n\n\nsub get_sequence {\n    my ($self,$contig) = @_;\n    return $self->{'contigs'}->{$contig}->{'consensus'};\n}\n\n=head2 set_final_sequence($some_sequence)\n\n Title   : set_final_sequence($name,$some_sequence)\n Usage   : $o_consed->set_final_sequence($name,$some_sequence);\n Function: Provides a manual way to set the sequence for a given key in the\n\t   contig hash. Rarely used.\n Returns : 0 or 1;\n Args    : The name (not the keyname) of a contig and an arbitrary string.\n\nA method with a questionable and somewhat mysterious origin. May raise\nthe dead or something like that.","parameters":[{"label":"$self"},{"label":"$name"},{"label":"$sequence"}],"label":"set_final_sequence($self,$name,$sequence)"},"detail":"($self,$name,$sequence)","definition":"sub","containerName":"main::","children":[{"containerName":"set_final_sequence","name":"$self","definition":"my","localvar":"my","kind":13,"line":511},{"line":511,"kind":13,"name":"$name","containerName":"set_final_sequence"},{"line":511,"kind":13,"containerName":"set_final_sequence","name":"$sequence"},{"line":512,"kind":13,"containerName":"set_final_sequence","name":"$self"},{"containerName":"set_final_sequence","name":"$name","line":512,"kind":13},{"line":513,"kind":13,"containerName":"set_final_sequence","name":"$self"},{"line":513,"kind":12,"name":"warn","containerName":"set_final_sequence"},{"line":518,"kind":13,"name":"$self","containerName":"set_final_sequence"},{"containerName":"set_final_sequence","name":"$name","line":518,"kind":13},{"containerName":"set_final_sequence","name":"$sequence","kind":13,"line":518}],"line":510,"kind":12},{"containerName":"main::","definition":"sub","detail":"($self)","signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Consed.pm 16123 2009-09-17 12:57:27Z cjfields $\n# Bio::Tools::Alignment::Consed\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chad Matsalla\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Alignment::Consed - A module to work with objects from consed .ace files\n\n=head1 SYNOPSIS\n\n  # a report for sequencing stuff\n  my $o_consed = Bio::Tools::Alignment::Consed->new( \n      -acefile => \"/path/to/an/acefile.ace.1\",\n      -verbose => 1);\n  my $foo = $o_consed->set_reverse_designator(\"r\");\n  my $bar = $o_consed->set_forward_designator(\"f\");\n\n  # get the contig numbers\n  my @keys = $o_consed->get_contigs();\n\n  # construct the doublets\n  my $setter_doublets = $o_consed->choose_doublets();\n\n  # get the doublets\n  my @doublets = $o_consed->get_doublets();\n\n=head1 DESCRIPTION\n\nL<Bio::Tools::Alignment::Consed> provides methods and objects to deal\nwith the output from the Consed software suite. Specifically,\ntakes an C<.ace> file and provides objects for the results.\n\nA word about doublets: This module was written to accomodate a large\nEST sequencing operation. In this case, EST's were sequenced from the\n3' and from the 5' end of the EST. The objective was to find a\nconsensus sequence for these two reads.  Thus, a contig of two is what\nwe wanted, and this contig should consist of the forward and reverse\nreads of a getn clone. For example, for a forward designator of \"F\"\nand a reverse designator of \"R\", if the two reads chad1F and chad1R\nwere in a single contig (for example Contig 5) it will be determined\nthat the consensus sequence for Contig 5 will be the sequence for\nclone chad1.\n\nDoublets are good!\n\nThis module parses C<.ace> and related files. A detailed list of methods\ncan be found at the end of this document.\n\nI wrote a detailed rationale for design that may explain the reasons\nwhy some things were done the way they were done. That document is\nbeyond the scope of this pod and can probably be found in the\ndirectory from which this module was 'made' or at\nL<http://www.dieselwurks.com/bioinformatics/consedpm_documentation.pdf>.\n\nNote that the POD in that document might be old but the original\nrationale still stands.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nEmail chad-at-dieselwurks.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n#' \n\npackage Bio::Tools::Alignment::Consed;\n\nuse strict;\n\nuse FileHandle;\nuse Dumpvalue qw(dumpValue);\nuse Bio::Tools::Alignment::Trim;\nuse File::Spec;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\nour %DEFAULTS = ( 'f_designator' => 'f',\n\t\t  'r_designator' => 'r');\n\n=head2 new()\n\n Title   : new(-acefile => $path_to_some_acefile, -verbose => \"1\")\n Usage   : $o_consed = Bio::Tools::Alignment::Consed->\n              new(-acefile => $path_to_some_acefile, -verbose => \"1\");\n Function: Construct the Bio::Tools::Alignment::Consed object. Sets\n\t   verbosity for the following procedures, if necessary:\n\t   1. Construct a new Bio::Tools::Alignment::Trim object, to\n\t   handle quality trimming 2. Read in the acefile and parse it\n\n Returns : A reference to a Bio::Tools::Alignment::Consed object.\n Args    : A hash. (-acefile) is the filename of an acefile. If a full path\n\t   is not specified \"./\" is prepended to the filename and used from\n\t   instantiation until destruction. If you want \n           Bio::Tools::Alignment::Consed to be noisy during parsing of\n           the acefile, specify some value for (-verbose).\n\n\nsub new {\n    my ($class,%args) = @_;\n    my $self = $class->SUPER::new(%args);\n\n    $self->{'filename'} = $args{'-acefile'};\n\n    # this is special to UNIX and should probably use catfile : DONE!\n#    if (!($self->{'filename'} =~ m{/})) { \n#\t$self->{'filename'} = \"./\".$self->{'filename'}; \n#    } \n#    $self->{'filename'} =~ m/(.*\\/)(.*)ace.*$/;\n#    $self->{'path'} = $1;\n\n    # this is more generic and should work on most systems   \n    (undef, $self->{'path'}, undef) = File::Spec->splitpath($self->{'filename'});\n\n    $self->_initialize_io('-file'=>$self->{'filename'});\n    $self->{'o_trim'} = Bio::Tools::Alignment::Trim->new(-verbose => $self->verbose());\n    $self->set_forward_designator($DEFAULTS{'f_designator'});\n    $self->set_reverse_designator($DEFAULTS{'r_designator'});\n\n    $self->_read_file();\n    return $self;\n}\n\n=head2 set_verbose()\n\n Title   : set_verbose()\n Usage   : $o_consed->set_verbose(1);\n Function: Set the verbosity level for debugging messages. On instantiation\n\t   of the Bio::Tools::Alignment::Consed object the verbosity level\n           is set to 0 (quiet).\n Returns : 1 or 0.\n Args    : The verbosity levels are:\n\t      0 - quiet\n\t      1 - noisy\n\t      2 - noisier\n\t      3 - annoyingly noisy\n\nThis method for setting verbosity has largely been superseeded by a\nsub-by-sub way, where for every sub you can provide a (-verbose)\nswitch. I am doing converting this bit-by-bit so do not be surprised\nif some subs do not honour this.\n\n\n# from RootI\n\n# backwards compat\nsub set_verbose { (shift)->verbose(@_) }\n\n=head2 get_filename()\n\n Title   : get_filename()\n Usage   : $o_consed->get_filename();\n Function: Returns the name of the acefile being used by the\n\t   Bio::Tools::Alignment::Consed object.\n Returns : A scalar containing the name of a file.\n Args    : None.\n\n\n\nsub get_filename {\n    my $self = shift;\n    return $self->{'filename'};\n}\n\n=head2 count_sequences_with_grep()\n\n Title   : count_sequences_with_grep()\n Usage   : $o_consed->count_sequences_with_grep();\n Function: Use /bin/grep to scan through the files in the ace project dir\n\t   and count sequences in those files. I used this method in the\n\t   development of this module to verify that I was getting all of the\n\t   sequences. It works, but it is (I think) unix-like platform\n\t   dependent.\n Returns : A scalar containing the number of sequences in the ace project\n\t   directory.\n Args    : None.\n\nIf you are on a non-UNIX platform, you really do not have to use\nthis. It is more of a debugging routine designed to address very\nspecific problems.\n\nThis method was reimplemented to be platform independent with a pure\nperl implementation.  The above note can be ignored.\n\n\nsub count_sequences_with_grep {\n    my $self = shift;\n    my ($working_dir,$grep_cli,@total_grep_sequences);\n    # this should be migrated to a pure perl implementation ala\n    # Tom Christiansen's 'tcgrep'\n    # http://www.cpan.org/modules/by-authors/id/TOMC/scripts/tcgrep.gz\n\n    open(my $FILE, $self->{'filename'}) or do { $self->warn(\"cannot open file \".$self->{'filename'}. \" for grepping\"); return}; \n    my $counter =0;\n    while(<$FILE>) { $counter++ if(/^AF/); }\n\n    close $FILE;\n    opendir(my $SINGLETS,$self->{'path'});\n    foreach my $f ( readdir($SINGLETS) ) {\n\tnext unless ($f =~ /\\.singlets$/); \n\topen(my $FILE, File::Spec->catfile($self->{'path'},$f)) or do{ $self->warn(\"cannot open file \".File::Spec->catfile($self->{'path'},$f)); next };\n\twhile(<$FILE>) { $counter++ if(/^>/) }\n\tclose $FILE;\n    }\n    return $counter;\n}\n\n=head2 get_path()\n\n Title   : get_path()\n Usage   : $o_consed->get_path();\n Function: Returns the path to the acefile this object is working with.\n Returns : Scalar. The path to the working acefile.\n Args    : None.\n\n\nsub get_path {\n    my $self = shift;\n    return $self->{'path'};\n}\n\n=head2 get_contigs()\n\n Title   : get_contigs()\n Usage   : $o_consed->get_contigs();\n Function: Return the keys to the Bio::Tools::Alignment::Consed object.\n Returns : An array containing the keynames in the\n           Bio::Tools::Alignment::Consed object.\n Args    : None.\n\nThis would normally be used to get the keynames for some sort of\niterator. These keys are worthless in general day-to-day use because\nin the Consed acefile they are simply Contig1, Contig2, ...\n\n\nsub get_contigs {\n    my ($self,$contig) = @_;\n    my @contigs = sort keys %{$self->{'contigs'}};\n    return @contigs;\n}\n\n=head2 get_class($contig_keyname)\n\n Title   : get_class($contig_keyname)\n Usage   : $o_consed->get_class($contig_keyname);\n Function: Return the class name for this contig\n Returns : A scalar representing the class of this contig.\n Args    : None.\n Notes   : \n\n\nsub get_class {\n    my ($self,$contig) = @_;\n    return $self->{contigs}->{$contig}->{class};\n}\n\n=head2 get_quality_array($contig_keyname)\n\n Title   : get_quality_array($contig_keyname)\n Usage   : $o_consed->get_quality_array($contig_keyname);\n Function: Returns the quality for the consensus sequence for the given\n\t   contig as an array. See get_quality_scalar to get this as a scalar.\n Returns : An array containing the quality for the consensus sequence with\n\t   the given keyname.\n Args    : The keyname of a contig. Note: This is a keyname. The key would\n\t   normally come from get_contigs.\n\nReturns an array, not a reference. Is this a bug? I<thinking> No.\nWell, maybe.  Why was this developed like this? I was using FreezeThaw\nfor object persistence, and when it froze out these arrays it took a\nlong time to thaw it. Much better as a scalar.\n\nSee L<get_quality_scalar()|get_quality_scalar>\n\n\nsub get_quality_array {\n    my ($self,$contig) = @_;\n    return split ' ', $self->{contigs}->{$contig}->{quality};\n}\n\n=head2 get_quality_scalar($contig_keyname)\n\n Title   : get_quality_scalar($contig_keyname)\n Usage   : $o_consed->get_quality_scalar($contig_keyname);\n Function: Returns the quality for the consensus sequence for the given\n\t   contig as a scalar. See get_quality_array to get this as an array.\n Returns : An scalar containing the quality for the consensus sequence with\n           the given keyname.\n Args    : The keyname of a contig. Note this is a _keyname_. The key would\n\t   normally come from get_contigs.\n\nWhy was this developed like this? I was using FreezeThaw for object\npersistence, and when it froze out these arrays it took a coon's age\nto thaw it. Much better as a scalar.\n\nSee L<get_quality_array()|get_quality_array>\n\n\n#'\nsub get_quality_scalar {\n    my ($self,$contig) = @_;\n    return $self->{'contigs'}->{$contig}->{'quality'};\n}\n\n=head2 freeze_hash()\n\n Title   : freeze_hash()\n Usage   : $o_consed->freeze_hash();\n\n Function: Use Ilya's FreezeThaw module to create a persistent data\n\t   object for this Bio::Tools::Alignment::Consed data\n\t   structure. In the case of AAFC, we use\n\t   Bio::Tools::Alignment::Consed to pre-process bunches of\n\t   sequences, freeze the structures, and send in a harvesting\n\t   robot later to do database stuff.\n Returns : 0 or 1;\n Args    : None.\n\nThis procedure was removed so Consed.pm won't require FreezeThaw.\n\n\n#'\nsub freeze_hash {\n    my $self = shift;\n    $self->warn(\"This method (freeze_hash) was removed \".\n                \"from the bioperl consed.pm. Sorry.\\n\");\n    if (1==2) {\n        $self->debug(\"Bio::Tools::Alignment::Consed::freeze_hash:\".\n                     \" \\$self->{path} is $self->{path}\\n\");\n        my $filename = $self->{'path'}.\"frozen\";\n        my %contigs = %{$self->{'contigs'}};\n        my $frozen = freeze(%contigs);\n        umask 0001;\n        open (my $FREEZE,\">$filename\") or do {\n            $self->warn( \"Bio::Tools::Alignment::Consed could not \".\n                         \"freeze the contig hash because the file \".\n                         \"($filename) could not be opened: $!\\n\");\n            return 1;\n        };\n        print $FREEZE $frozen;\n        return 0;\n    }\n}\n\n=head2 get_members($contig_keyname)\n\n Title   : get_members($contig_keyname)\n Usage   : $o_consed->get_members($contig_keyname);\n Function: Return the _names_ of the reads in this contig.\n Returns : An array containing the names of the reads in this contig.\n Args    : The keyname of a contig. Note this is a keyname. The keyname\n\t   would normally come from get_contigs.\n\nSee L<get_contigs()|get_contigs>\n\n\nsub get_members {\n    my ($self,$contig) = @_;\n    if (!$contig) {\n\t$self->warn(\"You need to provide the name of a contig to \".\n                    \"use Bio::Tools::Alignment::Consed::get_members!\\n\");\n\treturn;\n    }\n    return @{$self->{'contigs'}->{$contig}->{'member_array'}};\n}\n\n=head2 get_members_by_name($some_arbitrary_name)\n\n Title   : get_members_by_name($some_arbitrary_name)\n Usage   : $o_consed->get_members_by_name($some_arbitrary_name);\n Function: Return the names of the reads in a contig. This is the name given\n\t   to $contig{key} based on what is in the contig. This is different\n\t   from the keys retrieved through get_contigs().\n Returns : An array containing the names of the reads in the contig with this\n\t   name.\n Args    : The name of a contig. Not a key, but a name.\n\nHighly inefficient. use some other method if possible.\nSee L<get_contigs()|get_contigs>\n\n\nsub get_members_by_name {\n    my ($self,$name) = @_;\n    # build a list to try to screen for redundancy\n    my @contigs_with_that_name;\n    foreach my $currkey ( sort keys %{$self->{'contigs'}} ) {\n\tnext if (!$self->{'contigs'}->{$currkey}->{'name'});\n\tif ($self->{'contigs'}->{$currkey}->{'name'} eq \"$name\") {\n\t    push @contigs_with_that_name,$currkey;\n\t}\n    }\n    my $count = @contigs_with_that_name;\n    if ($count == 1) {\n\tmy $contig_num = $contigs_with_that_name[0];\n\treturn @{$self->{'contigs'}->{$contig_num}->{'member_array'}};\n    }\n}\n\n=head2 get_contig_number_by_name($some_arbitrary_name)\n\n Title   : get_contig_number_by_name($some_arbitrary_name)\n Usage   : $o_consed->get_contig_number_by_name($some_arbitrary_name);\n Function: Return the names of the reads in a contig. This is the name given\n\t   to $contig{key} based on what is in the contig. This is different\n\t   from the keys retrieved through get_contigs().\n Returns : An array containing the names of the reads in the contig with this\n\t   name.\n Args    : The name of a contig. Not a key, but a name.\n\nSee L<get_contigs()|get_contigs>\n\n\nsub get_contig_number_by_name {\n    my ($self,$name) = @_;\n    foreach my $currkey (sort keys %{$self->{'contigs'}}) {\n\tif ($self->{'contigs'}->{$currkey}->{'name'} && \n\t    $self->{'contigs'}->{$currkey}->{'name'} eq \"$name\") {\n\t    return $currkey;\n\t}\n    }\n}\t\n\n=head2 get_sequence($contig_keyname)\n\n Title   : get_sequence($contig_keyname)\n Usage   : $o_consed->get_sequence($contig_keyname); \n Function: Returns the consensus sequence for a given contig.\n Returns : A scalar containing a sequence.\n Args    : The keyname of a contig. Note this is a key. The key would\n\t   normally come from get_contigs.\n\nSee L<get_contigs()|get_contigs>\n\n\nsub get_sequence {\n    my ($self,$contig) = @_;\n    return $self->{'contigs'}->{$contig}->{'consensus'};\n}\n\n=head2 set_final_sequence($some_sequence)\n\n Title   : set_final_sequence($name,$some_sequence)\n Usage   : $o_consed->set_final_sequence($name,$some_sequence);\n Function: Provides a manual way to set the sequence for a given key in the\n\t   contig hash. Rarely used.\n Returns : 0 or 1;\n Args    : The name (not the keyname) of a contig and an arbitrary string.\n\nA method with a questionable and somewhat mysterious origin. May raise\nthe dead or something like that.\n\n\nsub set_final_sequence {\n    my ($self,$name,$sequence) = @_;\n    if (!$self->{'contigs'}->{$name}) {\n\t$self->warn(\"You cannot set the final sequence for \".\n                    \"$name because it doesn't exist!\\n\");\n\treturn 1;\n    }\n    else {\n\t$self->{'contigs'}->{$name}->{'final_sequence'} = $sequence;\n    }\n    return 0;\n}\n\n=head2  _read_file()\n\n Title   : _read_file();\n Usage   : _read_file();\n Function: An internal subroutine used to read in an acefile and parse it\n\t   into a Bio::Tools::Alignment::Consed object.\n Returns : 0 or 1.\n Args    : Nothing.\n\nThis routine creates and saves the filhandle for reading the files in\n{fh}","label":"_read_file($self)"},"kind":12,"line":537,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"_read_file","line":538,"kind":13},{"name":"$line","definition":"my","containerName":"_read_file","localvar":"my","kind":13,"line":539},{"name":"$in_contig","containerName":"_read_file","kind":13,"line":539},{"line":539,"kind":13,"containerName":"_read_file","name":"$in_quality"},{"name":"$contig_number","containerName":"_read_file","kind":13,"line":539},{"line":539,"kind":13,"name":"$top","containerName":"_read_file"},{"containerName":"_read_file","name":"$line","line":541,"kind":13},{"line":541,"kind":13,"name":"$self","containerName":"_read_file"},{"kind":12,"line":541,"name":"_readline","containerName":"_read_file"},{"line":542,"kind":13,"containerName":"_read_file","name":"$line"},{"kind":13,"line":545,"containerName":"_read_file","name":"$line"},{"name":"$in_contig","containerName":"_read_file","kind":13,"line":548},{"kind":13,"line":549,"name":"$in_quality","containerName":"_read_file"},{"name":"$in_contig","containerName":"_read_file","line":552,"kind":13},{"containerName":"_read_file","name":"$in_contig","kind":13,"line":553},{"name":"$self","containerName":"_read_file","line":554,"kind":13},{"line":554,"kind":12,"containerName":"_read_file","name":"debug"},{"name":"$self","containerName":"_read_file","kind":13,"line":555},{"containerName":"_read_file","name":"$contig_number","line":555,"kind":13},{"containerName":"_read_file","name":"$line","line":555,"kind":13},{"containerName":"_read_file","name":"$in_quality","kind":13,"line":558},{"line":559,"kind":13,"containerName":"_read_file","name":"$line"},{"kind":13,"line":560,"containerName":"_read_file","name":"$in_quality"},{"line":571,"kind":13,"containerName":"_read_file","name":"$self"},{"name":"$contig_number","containerName":"_read_file","kind":13,"line":571},{"line":572,"kind":13,"name":"$self","containerName":"_read_file"},{"name":"$contig_number","containerName":"_read_file","kind":13,"line":572},{"line":573,"kind":13,"containerName":"_read_file","name":"$self"},{"line":573,"kind":13,"name":"$contig_number","containerName":"_read_file"},{"kind":13,"line":575,"name":"$self","containerName":"_read_file"},{"line":575,"kind":13,"containerName":"_read_file","name":"$contig_number"},{"line":575,"kind":13,"containerName":"_read_file","name":"$line"},{"kind":13,"line":578,"containerName":"_read_file","name":"$line"},{"name":"$in_quality","containerName":"_read_file","line":579,"kind":13},{"containerName":"_read_file","name":"$line","kind":13,"line":592},{"line":593,"kind":13,"containerName":"_read_file","name":"$line"},{"line":594,"kind":13,"containerName":"_read_file","name":"$contig_number"},{"containerName":"_read_file","name":"$self","line":596,"kind":13},{"name":"debug","containerName":"_read_file","line":596,"kind":12},{"name":"$self","containerName":"_read_file","kind":13,"line":598},{"kind":13,"line":598,"containerName":"_read_file","name":"$contig_number"},{"name":"$self","containerName":"_read_file","kind":13,"line":599},{"name":"$contig_number","containerName":"_read_file","kind":13,"line":599},{"line":600,"kind":13,"containerName":"_read_file","name":"$in_contig"},{"name":"$line","containerName":"_read_file","kind":13,"line":607},{"kind":13,"line":608,"name":"$line","containerName":"_read_file"},{"kind":13,"line":609,"definition":"my","name":"$member","containerName":"_read_file","localvar":"my"},{"name":"$self","containerName":"_read_file","line":610,"kind":13},{"line":610,"kind":13,"name":"$contig_number","containerName":"_read_file"},{"line":610,"kind":13,"containerName":"_read_file","name":"$member"},{"kind":13,"line":613,"name":"$line","containerName":"_read_file"},{"name":"$self","containerName":"_read_file","line":614,"kind":13},{"line":614,"kind":12,"name":"debug","containerName":"_read_file"},{"kind":13,"line":615,"name":"$line","containerName":"_read_file"},{"name":"$self","containerName":"_read_file","line":618,"kind":13},{"name":"$contig_number","containerName":"_read_file","line":618,"kind":13},{"kind":13,"line":621,"containerName":"_read_file","name":"$top"},{"kind":13,"line":622,"name":"$self","containerName":"_read_file"},{"line":622,"kind":12,"containerName":"_read_file","name":"debug"},{"containerName":"_read_file","name":"$self","kind":13,"line":623},{"line":623,"kind":13,"name":"$contig_number","containerName":"_read_file"},{"kind":13,"line":624,"name":"$self","containerName":"_read_file"},{"kind":12,"line":624,"name":"debug","containerName":"_read_file"},{"line":628,"kind":13,"containerName":"_read_file","name":"$self"},{"name":"$contig_number","containerName":"_read_file","kind":13,"line":628},{"containerName":"_read_file","name":"$self","line":629,"kind":13},{"line":629,"kind":13,"name":"$contig_number","containerName":"_read_file"},{"line":630,"kind":13,"containerName":"_read_file","name":"$self"},{"name":"$contig_number","containerName":"_read_file","kind":13,"line":630},{"line":633,"kind":13,"containerName":"_read_file","name":"$self"},{"name":"debug","containerName":"_read_file","line":633,"kind":12},{"name":"$self","containerName":"_read_file","line":637,"kind":13},{"containerName":"_read_file","name":"$contig_number","kind":13,"line":637},{"line":638,"kind":13,"name":"$self","containerName":"_read_file"},{"containerName":"_read_file","name":"$contig_number","kind":13,"line":638},{"kind":13,"line":639,"name":"$self","containerName":"_read_file"},{"containerName":"_read_file","name":"$contig_number","kind":13,"line":639},{"kind":13,"line":641,"name":"$top","containerName":"_read_file"},{"line":648,"kind":13,"name":"$self","containerName":"_read_file"},{"containerName":"_read_file","name":"$contig_number","kind":13,"line":648},{"containerName":"_read_file","name":"$self","line":649,"kind":13},{"containerName":"_read_file","name":"debug","kind":12,"line":649},{"containerName":"_read_file","name":"$self","line":650,"kind":13},{"line":650,"kind":13,"containerName":"_read_file","name":"$contig_number"},{"containerName":"_read_file","name":"$self","kind":13,"line":651},{"containerName":"_read_file","name":"$contig_number","kind":13,"line":651},{"kind":13,"line":652,"name":"$self","containerName":"_read_file"},{"name":"$contig_number","containerName":"_read_file","kind":13,"line":652},{"containerName":"_read_file","name":"$self","line":655,"kind":13},{"containerName":"_read_file","name":"debug","line":655,"kind":12},{"name":"$self","containerName":"_read_file","line":656,"kind":13},{"line":656,"kind":13,"name":"$contig_number","containerName":"_read_file"},{"line":657,"kind":13,"name":"$self","containerName":"_read_file"},{"line":657,"kind":13,"name":"$contig_number","containerName":"_read_file"},{"kind":13,"line":658,"name":"$self","containerName":"_read_file"},{"kind":13,"line":658,"name":"$contig_number","containerName":"_read_file"},{"containerName":"_read_file","name":"$top","kind":13,"line":660}],"name":"_read_file","range":{"end":{"line":663,"character":9999},"start":{"line":537,"character":0}}},{"children":[{"containerName":"set_reverse_designator","name":"$self","definition":"my","localvar":"my","kind":13,"line":683},{"name":"$reverse_designator","containerName":"set_reverse_designator","line":683,"kind":13},{"line":684,"kind":13,"name":"$self","containerName":"set_reverse_designator"},{"containerName":"set_reverse_designator","name":"$reverse_designator","line":684,"kind":13},{"name":"$self","containerName":"set_reverse_designator","kind":13,"line":685},{"containerName":"set_reverse_designator","name":"set_reverse_designator","line":685,"kind":12},{"name":"$reverse_designator","containerName":"set_reverse_designator","line":685,"kind":13},{"containerName":"set_reverse_designator","name":"$self","kind":13,"line":686}],"line":682,"kind":12,"signature":{"label":"set_reverse_designator($self,$reverse_designator)","parameters":[{"label":"$self"},{"label":"$reverse_designator"}],"documentation":"1;\n# $Id: Consed.pm 16123 2009-09-17 12:57:27Z cjfields $\n# Bio::Tools::Alignment::Consed\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chad Matsalla\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Alignment::Consed - A module to work with objects from consed .ace files\n\n=head1 SYNOPSIS\n\n  # a report for sequencing stuff\n  my $o_consed = Bio::Tools::Alignment::Consed->new( \n      -acefile => \"/path/to/an/acefile.ace.1\",\n      -verbose => 1);\n  my $foo = $o_consed->set_reverse_designator(\"r\");\n  my $bar = $o_consed->set_forward_designator(\"f\");\n\n  # get the contig numbers\n  my @keys = $o_consed->get_contigs();\n\n  # construct the doublets\n  my $setter_doublets = $o_consed->choose_doublets();\n\n  # get the doublets\n  my @doublets = $o_consed->get_doublets();\n\n=head1 DESCRIPTION\n\nL<Bio::Tools::Alignment::Consed> provides methods and objects to deal\nwith the output from the Consed software suite. Specifically,\ntakes an C<.ace> file and provides objects for the results.\n\nA word about doublets: This module was written to accomodate a large\nEST sequencing operation. In this case, EST's were sequenced from the\n3' and from the 5' end of the EST. The objective was to find a\nconsensus sequence for these two reads.  Thus, a contig of two is what\nwe wanted, and this contig should consist of the forward and reverse\nreads of a getn clone. For example, for a forward designator of \"F\"\nand a reverse designator of \"R\", if the two reads chad1F and chad1R\nwere in a single contig (for example Contig 5) it will be determined\nthat the consensus sequence for Contig 5 will be the sequence for\nclone chad1.\n\nDoublets are good!\n\nThis module parses C<.ace> and related files. A detailed list of methods\ncan be found at the end of this document.\n\nI wrote a detailed rationale for design that may explain the reasons\nwhy some things were done the way they were done. That document is\nbeyond the scope of this pod and can probably be found in the\ndirectory from which this module was 'made' or at\nL<http://www.dieselwurks.com/bioinformatics/consedpm_documentation.pdf>.\n\nNote that the POD in that document might be old but the original\nrationale still stands.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nEmail chad-at-dieselwurks.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n#' \n\npackage Bio::Tools::Alignment::Consed;\n\nuse strict;\n\nuse FileHandle;\nuse Dumpvalue qw(dumpValue);\nuse Bio::Tools::Alignment::Trim;\nuse File::Spec;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\nour %DEFAULTS = ( 'f_designator' => 'f',\n\t\t  'r_designator' => 'r');\n\n=head2 new()\n\n Title   : new(-acefile => $path_to_some_acefile, -verbose => \"1\")\n Usage   : $o_consed = Bio::Tools::Alignment::Consed->\n              new(-acefile => $path_to_some_acefile, -verbose => \"1\");\n Function: Construct the Bio::Tools::Alignment::Consed object. Sets\n\t   verbosity for the following procedures, if necessary:\n\t   1. Construct a new Bio::Tools::Alignment::Trim object, to\n\t   handle quality trimming 2. Read in the acefile and parse it\n\n Returns : A reference to a Bio::Tools::Alignment::Consed object.\n Args    : A hash. (-acefile) is the filename of an acefile. If a full path\n\t   is not specified \"./\" is prepended to the filename and used from\n\t   instantiation until destruction. If you want \n           Bio::Tools::Alignment::Consed to be noisy during parsing of\n           the acefile, specify some value for (-verbose).\n\n\nsub new {\n    my ($class,%args) = @_;\n    my $self = $class->SUPER::new(%args);\n\n    $self->{'filename'} = $args{'-acefile'};\n\n    # this is special to UNIX and should probably use catfile : DONE!\n#    if (!($self->{'filename'} =~ m{/})) { \n#\t$self->{'filename'} = \"./\".$self->{'filename'}; \n#    } \n#    $self->{'filename'} =~ m/(.*\\/)(.*)ace.*$/;\n#    $self->{'path'} = $1;\n\n    # this is more generic and should work on most systems   \n    (undef, $self->{'path'}, undef) = File::Spec->splitpath($self->{'filename'});\n\n    $self->_initialize_io('-file'=>$self->{'filename'});\n    $self->{'o_trim'} = Bio::Tools::Alignment::Trim->new(-verbose => $self->verbose());\n    $self->set_forward_designator($DEFAULTS{'f_designator'});\n    $self->set_reverse_designator($DEFAULTS{'r_designator'});\n\n    $self->_read_file();\n    return $self;\n}\n\n=head2 set_verbose()\n\n Title   : set_verbose()\n Usage   : $o_consed->set_verbose(1);\n Function: Set the verbosity level for debugging messages. On instantiation\n\t   of the Bio::Tools::Alignment::Consed object the verbosity level\n           is set to 0 (quiet).\n Returns : 1 or 0.\n Args    : The verbosity levels are:\n\t      0 - quiet\n\t      1 - noisy\n\t      2 - noisier\n\t      3 - annoyingly noisy\n\nThis method for setting verbosity has largely been superseeded by a\nsub-by-sub way, where for every sub you can provide a (-verbose)\nswitch. I am doing converting this bit-by-bit so do not be surprised\nif some subs do not honour this.\n\n\n# from RootI\n\n# backwards compat\nsub set_verbose { (shift)->verbose(@_) }\n\n=head2 get_filename()\n\n Title   : get_filename()\n Usage   : $o_consed->get_filename();\n Function: Returns the name of the acefile being used by the\n\t   Bio::Tools::Alignment::Consed object.\n Returns : A scalar containing the name of a file.\n Args    : None.\n\n\n\nsub get_filename {\n    my $self = shift;\n    return $self->{'filename'};\n}\n\n=head2 count_sequences_with_grep()\n\n Title   : count_sequences_with_grep()\n Usage   : $o_consed->count_sequences_with_grep();\n Function: Use /bin/grep to scan through the files in the ace project dir\n\t   and count sequences in those files. I used this method in the\n\t   development of this module to verify that I was getting all of the\n\t   sequences. It works, but it is (I think) unix-like platform\n\t   dependent.\n Returns : A scalar containing the number of sequences in the ace project\n\t   directory.\n Args    : None.\n\nIf you are on a non-UNIX platform, you really do not have to use\nthis. It is more of a debugging routine designed to address very\nspecific problems.\n\nThis method was reimplemented to be platform independent with a pure\nperl implementation.  The above note can be ignored.\n\n\nsub count_sequences_with_grep {\n    my $self = shift;\n    my ($working_dir,$grep_cli,@total_grep_sequences);\n    # this should be migrated to a pure perl implementation ala\n    # Tom Christiansen's 'tcgrep'\n    # http://www.cpan.org/modules/by-authors/id/TOMC/scripts/tcgrep.gz\n\n    open(my $FILE, $self->{'filename'}) or do { $self->warn(\"cannot open file \".$self->{'filename'}. \" for grepping\"); return}; \n    my $counter =0;\n    while(<$FILE>) { $counter++ if(/^AF/); }\n\n    close $FILE;\n    opendir(my $SINGLETS,$self->{'path'});\n    foreach my $f ( readdir($SINGLETS) ) {\n\tnext unless ($f =~ /\\.singlets$/); \n\topen(my $FILE, File::Spec->catfile($self->{'path'},$f)) or do{ $self->warn(\"cannot open file \".File::Spec->catfile($self->{'path'},$f)); next };\n\twhile(<$FILE>) { $counter++ if(/^>/) }\n\tclose $FILE;\n    }\n    return $counter;\n}\n\n=head2 get_path()\n\n Title   : get_path()\n Usage   : $o_consed->get_path();\n Function: Returns the path to the acefile this object is working with.\n Returns : Scalar. The path to the working acefile.\n Args    : None.\n\n\nsub get_path {\n    my $self = shift;\n    return $self->{'path'};\n}\n\n=head2 get_contigs()\n\n Title   : get_contigs()\n Usage   : $o_consed->get_contigs();\n Function: Return the keys to the Bio::Tools::Alignment::Consed object.\n Returns : An array containing the keynames in the\n           Bio::Tools::Alignment::Consed object.\n Args    : None.\n\nThis would normally be used to get the keynames for some sort of\niterator. These keys are worthless in general day-to-day use because\nin the Consed acefile they are simply Contig1, Contig2, ...\n\n\nsub get_contigs {\n    my ($self,$contig) = @_;\n    my @contigs = sort keys %{$self->{'contigs'}};\n    return @contigs;\n}\n\n=head2 get_class($contig_keyname)\n\n Title   : get_class($contig_keyname)\n Usage   : $o_consed->get_class($contig_keyname);\n Function: Return the class name for this contig\n Returns : A scalar representing the class of this contig.\n Args    : None.\n Notes   : \n\n\nsub get_class {\n    my ($self,$contig) = @_;\n    return $self->{contigs}->{$contig}->{class};\n}\n\n=head2 get_quality_array($contig_keyname)\n\n Title   : get_quality_array($contig_keyname)\n Usage   : $o_consed->get_quality_array($contig_keyname);\n Function: Returns the quality for the consensus sequence for the given\n\t   contig as an array. See get_quality_scalar to get this as a scalar.\n Returns : An array containing the quality for the consensus sequence with\n\t   the given keyname.\n Args    : The keyname of a contig. Note: This is a keyname. The key would\n\t   normally come from get_contigs.\n\nReturns an array, not a reference. Is this a bug? I<thinking> No.\nWell, maybe.  Why was this developed like this? I was using FreezeThaw\nfor object persistence, and when it froze out these arrays it took a\nlong time to thaw it. Much better as a scalar.\n\nSee L<get_quality_scalar()|get_quality_scalar>\n\n\nsub get_quality_array {\n    my ($self,$contig) = @_;\n    return split ' ', $self->{contigs}->{$contig}->{quality};\n}\n\n=head2 get_quality_scalar($contig_keyname)\n\n Title   : get_quality_scalar($contig_keyname)\n Usage   : $o_consed->get_quality_scalar($contig_keyname);\n Function: Returns the quality for the consensus sequence for the given\n\t   contig as a scalar. See get_quality_array to get this as an array.\n Returns : An scalar containing the quality for the consensus sequence with\n           the given keyname.\n Args    : The keyname of a contig. Note this is a _keyname_. The key would\n\t   normally come from get_contigs.\n\nWhy was this developed like this? I was using FreezeThaw for object\npersistence, and when it froze out these arrays it took a coon's age\nto thaw it. Much better as a scalar.\n\nSee L<get_quality_array()|get_quality_array>\n\n\n#'\nsub get_quality_scalar {\n    my ($self,$contig) = @_;\n    return $self->{'contigs'}->{$contig}->{'quality'};\n}\n\n=head2 freeze_hash()\n\n Title   : freeze_hash()\n Usage   : $o_consed->freeze_hash();\n\n Function: Use Ilya's FreezeThaw module to create a persistent data\n\t   object for this Bio::Tools::Alignment::Consed data\n\t   structure. In the case of AAFC, we use\n\t   Bio::Tools::Alignment::Consed to pre-process bunches of\n\t   sequences, freeze the structures, and send in a harvesting\n\t   robot later to do database stuff.\n Returns : 0 or 1;\n Args    : None.\n\nThis procedure was removed so Consed.pm won't require FreezeThaw.\n\n\n#'\nsub freeze_hash {\n    my $self = shift;\n    $self->warn(\"This method (freeze_hash) was removed \".\n                \"from the bioperl consed.pm. Sorry.\\n\");\n    if (1==2) {\n        $self->debug(\"Bio::Tools::Alignment::Consed::freeze_hash:\".\n                     \" \\$self->{path} is $self->{path}\\n\");\n        my $filename = $self->{'path'}.\"frozen\";\n        my %contigs = %{$self->{'contigs'}};\n        my $frozen = freeze(%contigs);\n        umask 0001;\n        open (my $FREEZE,\">$filename\") or do {\n            $self->warn( \"Bio::Tools::Alignment::Consed could not \".\n                         \"freeze the contig hash because the file \".\n                         \"($filename) could not be opened: $!\\n\");\n            return 1;\n        };\n        print $FREEZE $frozen;\n        return 0;\n    }\n}\n\n=head2 get_members($contig_keyname)\n\n Title   : get_members($contig_keyname)\n Usage   : $o_consed->get_members($contig_keyname);\n Function: Return the _names_ of the reads in this contig.\n Returns : An array containing the names of the reads in this contig.\n Args    : The keyname of a contig. Note this is a keyname. The keyname\n\t   would normally come from get_contigs.\n\nSee L<get_contigs()|get_contigs>\n\n\nsub get_members {\n    my ($self,$contig) = @_;\n    if (!$contig) {\n\t$self->warn(\"You need to provide the name of a contig to \".\n                    \"use Bio::Tools::Alignment::Consed::get_members!\\n\");\n\treturn;\n    }\n    return @{$self->{'contigs'}->{$contig}->{'member_array'}};\n}\n\n=head2 get_members_by_name($some_arbitrary_name)\n\n Title   : get_members_by_name($some_arbitrary_name)\n Usage   : $o_consed->get_members_by_name($some_arbitrary_name);\n Function: Return the names of the reads in a contig. This is the name given\n\t   to $contig{key} based on what is in the contig. This is different\n\t   from the keys retrieved through get_contigs().\n Returns : An array containing the names of the reads in the contig with this\n\t   name.\n Args    : The name of a contig. Not a key, but a name.\n\nHighly inefficient. use some other method if possible.\nSee L<get_contigs()|get_contigs>\n\n\nsub get_members_by_name {\n    my ($self,$name) = @_;\n    # build a list to try to screen for redundancy\n    my @contigs_with_that_name;\n    foreach my $currkey ( sort keys %{$self->{'contigs'}} ) {\n\tnext if (!$self->{'contigs'}->{$currkey}->{'name'});\n\tif ($self->{'contigs'}->{$currkey}->{'name'} eq \"$name\") {\n\t    push @contigs_with_that_name,$currkey;\n\t}\n    }\n    my $count = @contigs_with_that_name;\n    if ($count == 1) {\n\tmy $contig_num = $contigs_with_that_name[0];\n\treturn @{$self->{'contigs'}->{$contig_num}->{'member_array'}};\n    }\n}\n\n=head2 get_contig_number_by_name($some_arbitrary_name)\n\n Title   : get_contig_number_by_name($some_arbitrary_name)\n Usage   : $o_consed->get_contig_number_by_name($some_arbitrary_name);\n Function: Return the names of the reads in a contig. This is the name given\n\t   to $contig{key} based on what is in the contig. This is different\n\t   from the keys retrieved through get_contigs().\n Returns : An array containing the names of the reads in the contig with this\n\t   name.\n Args    : The name of a contig. Not a key, but a name.\n\nSee L<get_contigs()|get_contigs>\n\n\nsub get_contig_number_by_name {\n    my ($self,$name) = @_;\n    foreach my $currkey (sort keys %{$self->{'contigs'}}) {\n\tif ($self->{'contigs'}->{$currkey}->{'name'} && \n\t    $self->{'contigs'}->{$currkey}->{'name'} eq \"$name\") {\n\t    return $currkey;\n\t}\n    }\n}\t\n\n=head2 get_sequence($contig_keyname)\n\n Title   : get_sequence($contig_keyname)\n Usage   : $o_consed->get_sequence($contig_keyname); \n Function: Returns the consensus sequence for a given contig.\n Returns : A scalar containing a sequence.\n Args    : The keyname of a contig. Note this is a key. The key would\n\t   normally come from get_contigs.\n\nSee L<get_contigs()|get_contigs>\n\n\nsub get_sequence {\n    my ($self,$contig) = @_;\n    return $self->{'contigs'}->{$contig}->{'consensus'};\n}\n\n=head2 set_final_sequence($some_sequence)\n\n Title   : set_final_sequence($name,$some_sequence)\n Usage   : $o_consed->set_final_sequence($name,$some_sequence);\n Function: Provides a manual way to set the sequence for a given key in the\n\t   contig hash. Rarely used.\n Returns : 0 or 1;\n Args    : The name (not the keyname) of a contig and an arbitrary string.\n\nA method with a questionable and somewhat mysterious origin. May raise\nthe dead or something like that.\n\n\nsub set_final_sequence {\n    my ($self,$name,$sequence) = @_;\n    if (!$self->{'contigs'}->{$name}) {\n\t$self->warn(\"You cannot set the final sequence for \".\n                    \"$name because it doesn't exist!\\n\");\n\treturn 1;\n    }\n    else {\n\t$self->{'contigs'}->{$name}->{'final_sequence'} = $sequence;\n    }\n    return 0;\n}\n\n=head2  _read_file()\n\n Title   : _read_file();\n Usage   : _read_file();\n Function: An internal subroutine used to read in an acefile and parse it\n\t   into a Bio::Tools::Alignment::Consed object.\n Returns : 0 or 1.\n Args    : Nothing.\n\nThis routine creates and saves the filhandle for reading the files in\n{fh}\n\n\nsub _read_file {\n    my ($self) = @_;\n    my ($line,$in_contig,$in_quality,$contig_number,$top);\n    # make it easier to type $fhl\n    while (defined($line=$self->_readline()) ) {\n\tchomp $line;\n\t# check if there is anything on this line\n\t# if not, you can stop gathering consensus sequence\n\tif (!$line) {\n\t    # if the line is blank you are no longer to gather consensus \n\t    # sequence or quality values\n\t    $in_contig = 0;\n\t    $in_quality = 0;\n\t}\n\t# you are currently gathering consensus sequence\n\telsif ($in_contig) {\n\t    if ($in_contig == 1) {\n\t\t$self->debug(\"Adding $line to consensus of contig number $contig_number.\\n\");\n\t\t$self->{'contigs'}->{$contig_number}->{'consensus'} .= $line;\n\t    }\n\t}\n\telsif ($in_quality) {\n\t    if (!$line) {\n\t\t$in_quality = undef;\n\t    }\n\t    else {\n\n\t\t# I wrote this in here because acefiles produced by\n\t\t# cap3 do not have a leading space like the acefiles\n\t\t# produced by phrap and there is the potential to have\n\t\t# concatenated quality values like this: 2020 rather\n\t\t# then 20 20 whre lines collide. Thanks Andrew for\n\t\t# noticing.\n\n\t\tif ($self->{'contigs'}->{$contig_number}->{'quality'} &&\n                    !($self->{'contigs'}->{$contig_number}->{'quality'} =~ m/\\ $/)) {\n\t\t    $self->{'contigs'}->{$contig_number}->{'quality'} .= \" \";\n\t\t}\n\t\t$self->{'contigs'}->{$contig_number}->{'quality'} .= $line;\n\t    }\n\t}\n\telsif ($line =~ /^BQ/) {\n\t    $in_quality = 1;\n\t}\n\n\t# the line /^CO/ like this:\n\t# CO Contig1 796 1 1 U\n\t# can be broken down as follows:\n\t# CO - Contig!\n\t# Contig1 - the name of this contig\n\t# 796 - Number of bases in this contig\n\t# 1 - Number of reads in this contig\n\t# 1 - number of base segments in this contig\n\t# U - Uncomplemented\n\n\telsif ($line =~ /^CO/) {\n\t    $line =~ m/^CO\\ Contig(\\d+)\\ \\d+\\ \\d+\\ \\d+\\ (\\w)/;\n\t    $contig_number = $1;\n\t    if ($2 eq \"C\") {\n\t\t$self->debug(\"Contig $contig_number is complemented!\\n\");\n\t    }\n\t    $self->{'contigs'}->{$contig_number}->{'member_array'} = [];\n\t    $self->{'contigs'}->{$contig_number}->{'contig_direction'} = \"$2\";\n\t    $in_contig = 1;\n\t}\n\n\t# 000713\n\t# this BS is deprecated, I think.\n\t# haha, I am really witty. <ew>\n\n\telsif ($line =~ /^BSDEPRECATED/) {\n\t    $line =~ m/^BS\\s+\\d+\\s+\\d+\\s+(.+)/;\n\t    my $member = $1;\n\t    $self->{'contigs'}->{$contig_number}->{$member}++;\n\t}\n\t# the members of the contigs are determined by the AF line in the ace file\n\telsif ($line =~ /^AF/) {\n\t    $self->debug(\"I see an AF line here.\\n\");\n\t    $line =~ /^AF\\ (\\S+)\\ (\\w)\\ (\\S+)/;\n\n            # push the name of the current read onto the member array for this contig\n\t    push @{$self->{'contigs'}->{$contig_number}->{'member_array'}},$1;\n\n            # the first read in the contig will be named the \"top\" read\n\t    if (!$top) {\n\t\t$self->debug(\"\\$top is not set.\\n\");\n\t\tif ($self->{'contigs'}->{$contig_number}->{'contig_direction'} eq \"C\") {\n\t\t    $self->debug(\"Reversing the order of the reads. The bottom will be $1\\n\");\n\n\t\t    # if the contig sequence is marked as the\n\t\t    # complement, the top becomes the bottom and$\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_name'} = $1;\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_complement'} = $2;\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_start'} = $3;\n\t\t}\n\t\telse {\n\t\t    $self->debug(\"NOT reversing the order of the reads. \".\n                                 \"The top_name will be $1\\n\");\n\t\t    # if the contig sequence is marked as the\n\t\t    # complement, the top becomes the bottom and$\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_name'} = $1;\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_complement'} = $2;\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_start'} = $3;\n\t\t}\n\t\t$top = 1;\n\t    }\n\t    else {\n\n\t\t# if the contig sequence is marked as the complement,\n\t\t# the top becomes the bottom and the bottom becomes\n\t\t# the top\n\t\tif ($self->{'contigs'}->{$contig_number}->{'contig_direction'} eq \"C\") {\n\t\t    $self->debug(\"Reversing the order of the reads. The top will be $1\\n\");\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_name'} = $1;\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_complement'} = $2;\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_start'} = $3;\n\t\t}\n\t\telse {\n\t\t    $self->debug(\"NOT reversing the order of the reads. The bottom will be $1\\n\");\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_name'} = $1;\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_complement'} = $2;\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_start'} = $3;\n\t\t}\n\t\t$top = undef;\n\t    }\n\t}\n    }\n    return 0;\n}\n\n=head2 set_reverse_designator($some_string)\n\n Title   : set_reverse_designator($some_string)\n Usage   : $o_consed->set_reverse_designator($some_string);\n Function: Set the designator for the reverse read of contigs in this\n\t   Bio::Tools::Alignment::Consed object. Used to determine if\n           contigs containing two reads can be named.\n Returns : The value of $o_consed->{reverse_designator} so you can check\n\t   to see that it was set properly.\n Args    : An arbitrary string.\n\nMay be useful only to me. I<shrug>"},"detail":"($self,$reverse_designator)","definition":"sub","containerName":"main::","range":{"start":{"line":682,"character":0},"end":{"character":9999,"line":687}},"name":"set_reverse_designator"},{"signature":{"label":"set_forward_designator($self,$forward_designator)","documentation":"1;\n# $Id: Consed.pm 16123 2009-09-17 12:57:27Z cjfields $\n# Bio::Tools::Alignment::Consed\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chad Matsalla\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Alignment::Consed - A module to work with objects from consed .ace files\n\n=head1 SYNOPSIS\n\n  # a report for sequencing stuff\n  my $o_consed = Bio::Tools::Alignment::Consed->new( \n      -acefile => \"/path/to/an/acefile.ace.1\",\n      -verbose => 1);\n  my $foo = $o_consed->set_reverse_designator(\"r\");\n  my $bar = $o_consed->set_forward_designator(\"f\");\n\n  # get the contig numbers\n  my @keys = $o_consed->get_contigs();\n\n  # construct the doublets\n  my $setter_doublets = $o_consed->choose_doublets();\n\n  # get the doublets\n  my @doublets = $o_consed->get_doublets();\n\n=head1 DESCRIPTION\n\nL<Bio::Tools::Alignment::Consed> provides methods and objects to deal\nwith the output from the Consed software suite. Specifically,\ntakes an C<.ace> file and provides objects for the results.\n\nA word about doublets: This module was written to accomodate a large\nEST sequencing operation. In this case, EST's were sequenced from the\n3' and from the 5' end of the EST. The objective was to find a\nconsensus sequence for these two reads.  Thus, a contig of two is what\nwe wanted, and this contig should consist of the forward and reverse\nreads of a getn clone. For example, for a forward designator of \"F\"\nand a reverse designator of \"R\", if the two reads chad1F and chad1R\nwere in a single contig (for example Contig 5) it will be determined\nthat the consensus sequence for Contig 5 will be the sequence for\nclone chad1.\n\nDoublets are good!\n\nThis module parses C<.ace> and related files. A detailed list of methods\ncan be found at the end of this document.\n\nI wrote a detailed rationale for design that may explain the reasons\nwhy some things were done the way they were done. That document is\nbeyond the scope of this pod and can probably be found in the\ndirectory from which this module was 'made' or at\nL<http://www.dieselwurks.com/bioinformatics/consedpm_documentation.pdf>.\n\nNote that the POD in that document might be old but the original\nrationale still stands.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nEmail chad-at-dieselwurks.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n#' \n\npackage Bio::Tools::Alignment::Consed;\n\nuse strict;\n\nuse FileHandle;\nuse Dumpvalue qw(dumpValue);\nuse Bio::Tools::Alignment::Trim;\nuse File::Spec;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\nour %DEFAULTS = ( 'f_designator' => 'f',\n\t\t  'r_designator' => 'r');\n\n=head2 new()\n\n Title   : new(-acefile => $path_to_some_acefile, -verbose => \"1\")\n Usage   : $o_consed = Bio::Tools::Alignment::Consed->\n              new(-acefile => $path_to_some_acefile, -verbose => \"1\");\n Function: Construct the Bio::Tools::Alignment::Consed object. Sets\n\t   verbosity for the following procedures, if necessary:\n\t   1. Construct a new Bio::Tools::Alignment::Trim object, to\n\t   handle quality trimming 2. Read in the acefile and parse it\n\n Returns : A reference to a Bio::Tools::Alignment::Consed object.\n Args    : A hash. (-acefile) is the filename of an acefile. If a full path\n\t   is not specified \"./\" is prepended to the filename and used from\n\t   instantiation until destruction. If you want \n           Bio::Tools::Alignment::Consed to be noisy during parsing of\n           the acefile, specify some value for (-verbose).\n\n\nsub new {\n    my ($class,%args) = @_;\n    my $self = $class->SUPER::new(%args);\n\n    $self->{'filename'} = $args{'-acefile'};\n\n    # this is special to UNIX and should probably use catfile : DONE!\n#    if (!($self->{'filename'} =~ m{/})) { \n#\t$self->{'filename'} = \"./\".$self->{'filename'}; \n#    } \n#    $self->{'filename'} =~ m/(.*\\/)(.*)ace.*$/;\n#    $self->{'path'} = $1;\n\n    # this is more generic and should work on most systems   \n    (undef, $self->{'path'}, undef) = File::Spec->splitpath($self->{'filename'});\n\n    $self->_initialize_io('-file'=>$self->{'filename'});\n    $self->{'o_trim'} = Bio::Tools::Alignment::Trim->new(-verbose => $self->verbose());\n    $self->set_forward_designator($DEFAULTS{'f_designator'});\n    $self->set_reverse_designator($DEFAULTS{'r_designator'});\n\n    $self->_read_file();\n    return $self;\n}\n\n=head2 set_verbose()\n\n Title   : set_verbose()\n Usage   : $o_consed->set_verbose(1);\n Function: Set the verbosity level for debugging messages. On instantiation\n\t   of the Bio::Tools::Alignment::Consed object the verbosity level\n           is set to 0 (quiet).\n Returns : 1 or 0.\n Args    : The verbosity levels are:\n\t      0 - quiet\n\t      1 - noisy\n\t      2 - noisier\n\t      3 - annoyingly noisy\n\nThis method for setting verbosity has largely been superseeded by a\nsub-by-sub way, where for every sub you can provide a (-verbose)\nswitch. I am doing converting this bit-by-bit so do not be surprised\nif some subs do not honour this.\n\n\n# from RootI\n\n# backwards compat\nsub set_verbose { (shift)->verbose(@_) }\n\n=head2 get_filename()\n\n Title   : get_filename()\n Usage   : $o_consed->get_filename();\n Function: Returns the name of the acefile being used by the\n\t   Bio::Tools::Alignment::Consed object.\n Returns : A scalar containing the name of a file.\n Args    : None.\n\n\n\nsub get_filename {\n    my $self = shift;\n    return $self->{'filename'};\n}\n\n=head2 count_sequences_with_grep()\n\n Title   : count_sequences_with_grep()\n Usage   : $o_consed->count_sequences_with_grep();\n Function: Use /bin/grep to scan through the files in the ace project dir\n\t   and count sequences in those files. I used this method in the\n\t   development of this module to verify that I was getting all of the\n\t   sequences. It works, but it is (I think) unix-like platform\n\t   dependent.\n Returns : A scalar containing the number of sequences in the ace project\n\t   directory.\n Args    : None.\n\nIf you are on a non-UNIX platform, you really do not have to use\nthis. It is more of a debugging routine designed to address very\nspecific problems.\n\nThis method was reimplemented to be platform independent with a pure\nperl implementation.  The above note can be ignored.\n\n\nsub count_sequences_with_grep {\n    my $self = shift;\n    my ($working_dir,$grep_cli,@total_grep_sequences);\n    # this should be migrated to a pure perl implementation ala\n    # Tom Christiansen's 'tcgrep'\n    # http://www.cpan.org/modules/by-authors/id/TOMC/scripts/tcgrep.gz\n\n    open(my $FILE, $self->{'filename'}) or do { $self->warn(\"cannot open file \".$self->{'filename'}. \" for grepping\"); return}; \n    my $counter =0;\n    while(<$FILE>) { $counter++ if(/^AF/); }\n\n    close $FILE;\n    opendir(my $SINGLETS,$self->{'path'});\n    foreach my $f ( readdir($SINGLETS) ) {\n\tnext unless ($f =~ /\\.singlets$/); \n\topen(my $FILE, File::Spec->catfile($self->{'path'},$f)) or do{ $self->warn(\"cannot open file \".File::Spec->catfile($self->{'path'},$f)); next };\n\twhile(<$FILE>) { $counter++ if(/^>/) }\n\tclose $FILE;\n    }\n    return $counter;\n}\n\n=head2 get_path()\n\n Title   : get_path()\n Usage   : $o_consed->get_path();\n Function: Returns the path to the acefile this object is working with.\n Returns : Scalar. The path to the working acefile.\n Args    : None.\n\n\nsub get_path {\n    my $self = shift;\n    return $self->{'path'};\n}\n\n=head2 get_contigs()\n\n Title   : get_contigs()\n Usage   : $o_consed->get_contigs();\n Function: Return the keys to the Bio::Tools::Alignment::Consed object.\n Returns : An array containing the keynames in the\n           Bio::Tools::Alignment::Consed object.\n Args    : None.\n\nThis would normally be used to get the keynames for some sort of\niterator. These keys are worthless in general day-to-day use because\nin the Consed acefile they are simply Contig1, Contig2, ...\n\n\nsub get_contigs {\n    my ($self,$contig) = @_;\n    my @contigs = sort keys %{$self->{'contigs'}};\n    return @contigs;\n}\n\n=head2 get_class($contig_keyname)\n\n Title   : get_class($contig_keyname)\n Usage   : $o_consed->get_class($contig_keyname);\n Function: Return the class name for this contig\n Returns : A scalar representing the class of this contig.\n Args    : None.\n Notes   : \n\n\nsub get_class {\n    my ($self,$contig) = @_;\n    return $self->{contigs}->{$contig}->{class};\n}\n\n=head2 get_quality_array($contig_keyname)\n\n Title   : get_quality_array($contig_keyname)\n Usage   : $o_consed->get_quality_array($contig_keyname);\n Function: Returns the quality for the consensus sequence for the given\n\t   contig as an array. See get_quality_scalar to get this as a scalar.\n Returns : An array containing the quality for the consensus sequence with\n\t   the given keyname.\n Args    : The keyname of a contig. Note: This is a keyname. The key would\n\t   normally come from get_contigs.\n\nReturns an array, not a reference. Is this a bug? I<thinking> No.\nWell, maybe.  Why was this developed like this? I was using FreezeThaw\nfor object persistence, and when it froze out these arrays it took a\nlong time to thaw it. Much better as a scalar.\n\nSee L<get_quality_scalar()|get_quality_scalar>\n\n\nsub get_quality_array {\n    my ($self,$contig) = @_;\n    return split ' ', $self->{contigs}->{$contig}->{quality};\n}\n\n=head2 get_quality_scalar($contig_keyname)\n\n Title   : get_quality_scalar($contig_keyname)\n Usage   : $o_consed->get_quality_scalar($contig_keyname);\n Function: Returns the quality for the consensus sequence for the given\n\t   contig as a scalar. See get_quality_array to get this as an array.\n Returns : An scalar containing the quality for the consensus sequence with\n           the given keyname.\n Args    : The keyname of a contig. Note this is a _keyname_. The key would\n\t   normally come from get_contigs.\n\nWhy was this developed like this? I was using FreezeThaw for object\npersistence, and when it froze out these arrays it took a coon's age\nto thaw it. Much better as a scalar.\n\nSee L<get_quality_array()|get_quality_array>\n\n\n#'\nsub get_quality_scalar {\n    my ($self,$contig) = @_;\n    return $self->{'contigs'}->{$contig}->{'quality'};\n}\n\n=head2 freeze_hash()\n\n Title   : freeze_hash()\n Usage   : $o_consed->freeze_hash();\n\n Function: Use Ilya's FreezeThaw module to create a persistent data\n\t   object for this Bio::Tools::Alignment::Consed data\n\t   structure. In the case of AAFC, we use\n\t   Bio::Tools::Alignment::Consed to pre-process bunches of\n\t   sequences, freeze the structures, and send in a harvesting\n\t   robot later to do database stuff.\n Returns : 0 or 1;\n Args    : None.\n\nThis procedure was removed so Consed.pm won't require FreezeThaw.\n\n\n#'\nsub freeze_hash {\n    my $self = shift;\n    $self->warn(\"This method (freeze_hash) was removed \".\n                \"from the bioperl consed.pm. Sorry.\\n\");\n    if (1==2) {\n        $self->debug(\"Bio::Tools::Alignment::Consed::freeze_hash:\".\n                     \" \\$self->{path} is $self->{path}\\n\");\n        my $filename = $self->{'path'}.\"frozen\";\n        my %contigs = %{$self->{'contigs'}};\n        my $frozen = freeze(%contigs);\n        umask 0001;\n        open (my $FREEZE,\">$filename\") or do {\n            $self->warn( \"Bio::Tools::Alignment::Consed could not \".\n                         \"freeze the contig hash because the file \".\n                         \"($filename) could not be opened: $!\\n\");\n            return 1;\n        };\n        print $FREEZE $frozen;\n        return 0;\n    }\n}\n\n=head2 get_members($contig_keyname)\n\n Title   : get_members($contig_keyname)\n Usage   : $o_consed->get_members($contig_keyname);\n Function: Return the _names_ of the reads in this contig.\n Returns : An array containing the names of the reads in this contig.\n Args    : The keyname of a contig. Note this is a keyname. The keyname\n\t   would normally come from get_contigs.\n\nSee L<get_contigs()|get_contigs>\n\n\nsub get_members {\n    my ($self,$contig) = @_;\n    if (!$contig) {\n\t$self->warn(\"You need to provide the name of a contig to \".\n                    \"use Bio::Tools::Alignment::Consed::get_members!\\n\");\n\treturn;\n    }\n    return @{$self->{'contigs'}->{$contig}->{'member_array'}};\n}\n\n=head2 get_members_by_name($some_arbitrary_name)\n\n Title   : get_members_by_name($some_arbitrary_name)\n Usage   : $o_consed->get_members_by_name($some_arbitrary_name);\n Function: Return the names of the reads in a contig. This is the name given\n\t   to $contig{key} based on what is in the contig. This is different\n\t   from the keys retrieved through get_contigs().\n Returns : An array containing the names of the reads in the contig with this\n\t   name.\n Args    : The name of a contig. Not a key, but a name.\n\nHighly inefficient. use some other method if possible.\nSee L<get_contigs()|get_contigs>\n\n\nsub get_members_by_name {\n    my ($self,$name) = @_;\n    # build a list to try to screen for redundancy\n    my @contigs_with_that_name;\n    foreach my $currkey ( sort keys %{$self->{'contigs'}} ) {\n\tnext if (!$self->{'contigs'}->{$currkey}->{'name'});\n\tif ($self->{'contigs'}->{$currkey}->{'name'} eq \"$name\") {\n\t    push @contigs_with_that_name,$currkey;\n\t}\n    }\n    my $count = @contigs_with_that_name;\n    if ($count == 1) {\n\tmy $contig_num = $contigs_with_that_name[0];\n\treturn @{$self->{'contigs'}->{$contig_num}->{'member_array'}};\n    }\n}\n\n=head2 get_contig_number_by_name($some_arbitrary_name)\n\n Title   : get_contig_number_by_name($some_arbitrary_name)\n Usage   : $o_consed->get_contig_number_by_name($some_arbitrary_name);\n Function: Return the names of the reads in a contig. This is the name given\n\t   to $contig{key} based on what is in the contig. This is different\n\t   from the keys retrieved through get_contigs().\n Returns : An array containing the names of the reads in the contig with this\n\t   name.\n Args    : The name of a contig. Not a key, but a name.\n\nSee L<get_contigs()|get_contigs>\n\n\nsub get_contig_number_by_name {\n    my ($self,$name) = @_;\n    foreach my $currkey (sort keys %{$self->{'contigs'}}) {\n\tif ($self->{'contigs'}->{$currkey}->{'name'} && \n\t    $self->{'contigs'}->{$currkey}->{'name'} eq \"$name\") {\n\t    return $currkey;\n\t}\n    }\n}\t\n\n=head2 get_sequence($contig_keyname)\n\n Title   : get_sequence($contig_keyname)\n Usage   : $o_consed->get_sequence($contig_keyname); \n Function: Returns the consensus sequence for a given contig.\n Returns : A scalar containing a sequence.\n Args    : The keyname of a contig. Note this is a key. The key would\n\t   normally come from get_contigs.\n\nSee L<get_contigs()|get_contigs>\n\n\nsub get_sequence {\n    my ($self,$contig) = @_;\n    return $self->{'contigs'}->{$contig}->{'consensus'};\n}\n\n=head2 set_final_sequence($some_sequence)\n\n Title   : set_final_sequence($name,$some_sequence)\n Usage   : $o_consed->set_final_sequence($name,$some_sequence);\n Function: Provides a manual way to set the sequence for a given key in the\n\t   contig hash. Rarely used.\n Returns : 0 or 1;\n Args    : The name (not the keyname) of a contig and an arbitrary string.\n\nA method with a questionable and somewhat mysterious origin. May raise\nthe dead or something like that.\n\n\nsub set_final_sequence {\n    my ($self,$name,$sequence) = @_;\n    if (!$self->{'contigs'}->{$name}) {\n\t$self->warn(\"You cannot set the final sequence for \".\n                    \"$name because it doesn't exist!\\n\");\n\treturn 1;\n    }\n    else {\n\t$self->{'contigs'}->{$name}->{'final_sequence'} = $sequence;\n    }\n    return 0;\n}\n\n=head2  _read_file()\n\n Title   : _read_file();\n Usage   : _read_file();\n Function: An internal subroutine used to read in an acefile and parse it\n\t   into a Bio::Tools::Alignment::Consed object.\n Returns : 0 or 1.\n Args    : Nothing.\n\nThis routine creates and saves the filhandle for reading the files in\n{fh}\n\n\nsub _read_file {\n    my ($self) = @_;\n    my ($line,$in_contig,$in_quality,$contig_number,$top);\n    # make it easier to type $fhl\n    while (defined($line=$self->_readline()) ) {\n\tchomp $line;\n\t# check if there is anything on this line\n\t# if not, you can stop gathering consensus sequence\n\tif (!$line) {\n\t    # if the line is blank you are no longer to gather consensus \n\t    # sequence or quality values\n\t    $in_contig = 0;\n\t    $in_quality = 0;\n\t}\n\t# you are currently gathering consensus sequence\n\telsif ($in_contig) {\n\t    if ($in_contig == 1) {\n\t\t$self->debug(\"Adding $line to consensus of contig number $contig_number.\\n\");\n\t\t$self->{'contigs'}->{$contig_number}->{'consensus'} .= $line;\n\t    }\n\t}\n\telsif ($in_quality) {\n\t    if (!$line) {\n\t\t$in_quality = undef;\n\t    }\n\t    else {\n\n\t\t# I wrote this in here because acefiles produced by\n\t\t# cap3 do not have a leading space like the acefiles\n\t\t# produced by phrap and there is the potential to have\n\t\t# concatenated quality values like this: 2020 rather\n\t\t# then 20 20 whre lines collide. Thanks Andrew for\n\t\t# noticing.\n\n\t\tif ($self->{'contigs'}->{$contig_number}->{'quality'} &&\n                    !($self->{'contigs'}->{$contig_number}->{'quality'} =~ m/\\ $/)) {\n\t\t    $self->{'contigs'}->{$contig_number}->{'quality'} .= \" \";\n\t\t}\n\t\t$self->{'contigs'}->{$contig_number}->{'quality'} .= $line;\n\t    }\n\t}\n\telsif ($line =~ /^BQ/) {\n\t    $in_quality = 1;\n\t}\n\n\t# the line /^CO/ like this:\n\t# CO Contig1 796 1 1 U\n\t# can be broken down as follows:\n\t# CO - Contig!\n\t# Contig1 - the name of this contig\n\t# 796 - Number of bases in this contig\n\t# 1 - Number of reads in this contig\n\t# 1 - number of base segments in this contig\n\t# U - Uncomplemented\n\n\telsif ($line =~ /^CO/) {\n\t    $line =~ m/^CO\\ Contig(\\d+)\\ \\d+\\ \\d+\\ \\d+\\ (\\w)/;\n\t    $contig_number = $1;\n\t    if ($2 eq \"C\") {\n\t\t$self->debug(\"Contig $contig_number is complemented!\\n\");\n\t    }\n\t    $self->{'contigs'}->{$contig_number}->{'member_array'} = [];\n\t    $self->{'contigs'}->{$contig_number}->{'contig_direction'} = \"$2\";\n\t    $in_contig = 1;\n\t}\n\n\t# 000713\n\t# this BS is deprecated, I think.\n\t# haha, I am really witty. <ew>\n\n\telsif ($line =~ /^BSDEPRECATED/) {\n\t    $line =~ m/^BS\\s+\\d+\\s+\\d+\\s+(.+)/;\n\t    my $member = $1;\n\t    $self->{'contigs'}->{$contig_number}->{$member}++;\n\t}\n\t# the members of the contigs are determined by the AF line in the ace file\n\telsif ($line =~ /^AF/) {\n\t    $self->debug(\"I see an AF line here.\\n\");\n\t    $line =~ /^AF\\ (\\S+)\\ (\\w)\\ (\\S+)/;\n\n            # push the name of the current read onto the member array for this contig\n\t    push @{$self->{'contigs'}->{$contig_number}->{'member_array'}},$1;\n\n            # the first read in the contig will be named the \"top\" read\n\t    if (!$top) {\n\t\t$self->debug(\"\\$top is not set.\\n\");\n\t\tif ($self->{'contigs'}->{$contig_number}->{'contig_direction'} eq \"C\") {\n\t\t    $self->debug(\"Reversing the order of the reads. The bottom will be $1\\n\");\n\n\t\t    # if the contig sequence is marked as the\n\t\t    # complement, the top becomes the bottom and$\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_name'} = $1;\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_complement'} = $2;\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_start'} = $3;\n\t\t}\n\t\telse {\n\t\t    $self->debug(\"NOT reversing the order of the reads. \".\n                                 \"The top_name will be $1\\n\");\n\t\t    # if the contig sequence is marked as the\n\t\t    # complement, the top becomes the bottom and$\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_name'} = $1;\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_complement'} = $2;\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_start'} = $3;\n\t\t}\n\t\t$top = 1;\n\t    }\n\t    else {\n\n\t\t# if the contig sequence is marked as the complement,\n\t\t# the top becomes the bottom and the bottom becomes\n\t\t# the top\n\t\tif ($self->{'contigs'}->{$contig_number}->{'contig_direction'} eq \"C\") {\n\t\t    $self->debug(\"Reversing the order of the reads. The top will be $1\\n\");\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_name'} = $1;\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_complement'} = $2;\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_start'} = $3;\n\t\t}\n\t\telse {\n\t\t    $self->debug(\"NOT reversing the order of the reads. The bottom will be $1\\n\");\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_name'} = $1;\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_complement'} = $2;\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_start'} = $3;\n\t\t}\n\t\t$top = undef;\n\t    }\n\t}\n    }\n    return 0;\n}\n\n=head2 set_reverse_designator($some_string)\n\n Title   : set_reverse_designator($some_string)\n Usage   : $o_consed->set_reverse_designator($some_string);\n Function: Set the designator for the reverse read of contigs in this\n\t   Bio::Tools::Alignment::Consed object. Used to determine if\n           contigs containing two reads can be named.\n Returns : The value of $o_consed->{reverse_designator} so you can check\n\t   to see that it was set properly.\n Args    : An arbitrary string.\n\nMay be useful only to me. I<shrug>\n\n\nsub set_reverse_designator {\n    my ($self,$reverse_designator) = @_;\n    $self->{'reverse_designator'} = $reverse_designator;\n    $self->{'o_trim'}->set_reverse_designator($reverse_designator);\n    return $self->{'reverse_designator'};\n}\t\t\t\t# end set_reverse_designator\n\n=head2 set_forward_designator($some_string)\n\n Title   : set_forward_designator($some_string)\n Usage   : $o_consed->set_forward_designator($some_string);\n Function: Set the designator for the forward read of contigs in this\n\t   Bio::Tools::Alignment::Consed object. Used to determine if\n           contigs containing two reads can be named.\n Returns : The value of $o_consed->{forward_designator} so you can check\n\t   to see that it was set properly.\n Args    : An arbitrary string.\n\nMay be useful only to me. I<shrug>","parameters":[{"label":"$self"},{"label":"$forward_designator"}]},"detail":"($self,$forward_designator)","definition":"sub","containerName":"main::","children":[{"kind":13,"line":705,"containerName":"set_forward_designator","name":"$self","definition":"my","localvar":"my"},{"containerName":"set_forward_designator","name":"$forward_designator","line":705,"kind":13},{"line":706,"kind":13,"containerName":"set_forward_designator","name":"$self"},{"kind":13,"line":706,"name":"$forward_designator","containerName":"set_forward_designator"},{"line":707,"kind":13,"name":"$self","containerName":"set_forward_designator"},{"containerName":"set_forward_designator","name":"set_forward_designator","kind":12,"line":707},{"name":"$forward_designator","containerName":"set_forward_designator","line":707,"kind":13},{"containerName":"set_forward_designator","name":"$self","line":708,"kind":13}],"line":704,"kind":12,"range":{"end":{"line":709,"character":9999},"start":{"character":0,"line":704}},"name":"set_forward_designator"},{"range":{"end":{"line":729,"character":9999},"start":{"character":0,"line":723}},"name":"set_designator_ignore_case","signature":{"documentation":"1;\n# $Id: Consed.pm 16123 2009-09-17 12:57:27Z cjfields $\n# Bio::Tools::Alignment::Consed\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chad Matsalla\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Alignment::Consed - A module to work with objects from consed .ace files\n\n=head1 SYNOPSIS\n\n  # a report for sequencing stuff\n  my $o_consed = Bio::Tools::Alignment::Consed->new( \n      -acefile => \"/path/to/an/acefile.ace.1\",\n      -verbose => 1);\n  my $foo = $o_consed->set_reverse_designator(\"r\");\n  my $bar = $o_consed->set_forward_designator(\"f\");\n\n  # get the contig numbers\n  my @keys = $o_consed->get_contigs();\n\n  # construct the doublets\n  my $setter_doublets = $o_consed->choose_doublets();\n\n  # get the doublets\n  my @doublets = $o_consed->get_doublets();\n\n=head1 DESCRIPTION\n\nL<Bio::Tools::Alignment::Consed> provides methods and objects to deal\nwith the output from the Consed software suite. Specifically,\ntakes an C<.ace> file and provides objects for the results.\n\nA word about doublets: This module was written to accomodate a large\nEST sequencing operation. In this case, EST's were sequenced from the\n3' and from the 5' end of the EST. The objective was to find a\nconsensus sequence for these two reads.  Thus, a contig of two is what\nwe wanted, and this contig should consist of the forward and reverse\nreads of a getn clone. For example, for a forward designator of \"F\"\nand a reverse designator of \"R\", if the two reads chad1F and chad1R\nwere in a single contig (for example Contig 5) it will be determined\nthat the consensus sequence for Contig 5 will be the sequence for\nclone chad1.\n\nDoublets are good!\n\nThis module parses C<.ace> and related files. A detailed list of methods\ncan be found at the end of this document.\n\nI wrote a detailed rationale for design that may explain the reasons\nwhy some things were done the way they were done. That document is\nbeyond the scope of this pod and can probably be found in the\ndirectory from which this module was 'made' or at\nL<http://www.dieselwurks.com/bioinformatics/consedpm_documentation.pdf>.\n\nNote that the POD in that document might be old but the original\nrationale still stands.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nEmail chad-at-dieselwurks.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n#' \n\npackage Bio::Tools::Alignment::Consed;\n\nuse strict;\n\nuse FileHandle;\nuse Dumpvalue qw(dumpValue);\nuse Bio::Tools::Alignment::Trim;\nuse File::Spec;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\nour %DEFAULTS = ( 'f_designator' => 'f',\n\t\t  'r_designator' => 'r');\n\n=head2 new()\n\n Title   : new(-acefile => $path_to_some_acefile, -verbose => \"1\")\n Usage   : $o_consed = Bio::Tools::Alignment::Consed->\n              new(-acefile => $path_to_some_acefile, -verbose => \"1\");\n Function: Construct the Bio::Tools::Alignment::Consed object. Sets\n\t   verbosity for the following procedures, if necessary:\n\t   1. Construct a new Bio::Tools::Alignment::Trim object, to\n\t   handle quality trimming 2. Read in the acefile and parse it\n\n Returns : A reference to a Bio::Tools::Alignment::Consed object.\n Args    : A hash. (-acefile) is the filename of an acefile. If a full path\n\t   is not specified \"./\" is prepended to the filename and used from\n\t   instantiation until destruction. If you want \n           Bio::Tools::Alignment::Consed to be noisy during parsing of\n           the acefile, specify some value for (-verbose).\n\n\nsub new {\n    my ($class,%args) = @_;\n    my $self = $class->SUPER::new(%args);\n\n    $self->{'filename'} = $args{'-acefile'};\n\n    # this is special to UNIX and should probably use catfile : DONE!\n#    if (!($self->{'filename'} =~ m{/})) { \n#\t$self->{'filename'} = \"./\".$self->{'filename'}; \n#    } \n#    $self->{'filename'} =~ m/(.*\\/)(.*)ace.*$/;\n#    $self->{'path'} = $1;\n\n    # this is more generic and should work on most systems   \n    (undef, $self->{'path'}, undef) = File::Spec->splitpath($self->{'filename'});\n\n    $self->_initialize_io('-file'=>$self->{'filename'});\n    $self->{'o_trim'} = Bio::Tools::Alignment::Trim->new(-verbose => $self->verbose());\n    $self->set_forward_designator($DEFAULTS{'f_designator'});\n    $self->set_reverse_designator($DEFAULTS{'r_designator'});\n\n    $self->_read_file();\n    return $self;\n}\n\n=head2 set_verbose()\n\n Title   : set_verbose()\n Usage   : $o_consed->set_verbose(1);\n Function: Set the verbosity level for debugging messages. On instantiation\n\t   of the Bio::Tools::Alignment::Consed object the verbosity level\n           is set to 0 (quiet).\n Returns : 1 or 0.\n Args    : The verbosity levels are:\n\t      0 - quiet\n\t      1 - noisy\n\t      2 - noisier\n\t      3 - annoyingly noisy\n\nThis method for setting verbosity has largely been superseeded by a\nsub-by-sub way, where for every sub you can provide a (-verbose)\nswitch. I am doing converting this bit-by-bit so do not be surprised\nif some subs do not honour this.\n\n\n# from RootI\n\n# backwards compat\nsub set_verbose { (shift)->verbose(@_) }\n\n=head2 get_filename()\n\n Title   : get_filename()\n Usage   : $o_consed->get_filename();\n Function: Returns the name of the acefile being used by the\n\t   Bio::Tools::Alignment::Consed object.\n Returns : A scalar containing the name of a file.\n Args    : None.\n\n\n\nsub get_filename {\n    my $self = shift;\n    return $self->{'filename'};\n}\n\n=head2 count_sequences_with_grep()\n\n Title   : count_sequences_with_grep()\n Usage   : $o_consed->count_sequences_with_grep();\n Function: Use /bin/grep to scan through the files in the ace project dir\n\t   and count sequences in those files. I used this method in the\n\t   development of this module to verify that I was getting all of the\n\t   sequences. It works, but it is (I think) unix-like platform\n\t   dependent.\n Returns : A scalar containing the number of sequences in the ace project\n\t   directory.\n Args    : None.\n\nIf you are on a non-UNIX platform, you really do not have to use\nthis. It is more of a debugging routine designed to address very\nspecific problems.\n\nThis method was reimplemented to be platform independent with a pure\nperl implementation.  The above note can be ignored.\n\n\nsub count_sequences_with_grep {\n    my $self = shift;\n    my ($working_dir,$grep_cli,@total_grep_sequences);\n    # this should be migrated to a pure perl implementation ala\n    # Tom Christiansen's 'tcgrep'\n    # http://www.cpan.org/modules/by-authors/id/TOMC/scripts/tcgrep.gz\n\n    open(my $FILE, $self->{'filename'}) or do { $self->warn(\"cannot open file \".$self->{'filename'}. \" for grepping\"); return}; \n    my $counter =0;\n    while(<$FILE>) { $counter++ if(/^AF/); }\n\n    close $FILE;\n    opendir(my $SINGLETS,$self->{'path'});\n    foreach my $f ( readdir($SINGLETS) ) {\n\tnext unless ($f =~ /\\.singlets$/); \n\topen(my $FILE, File::Spec->catfile($self->{'path'},$f)) or do{ $self->warn(\"cannot open file \".File::Spec->catfile($self->{'path'},$f)); next };\n\twhile(<$FILE>) { $counter++ if(/^>/) }\n\tclose $FILE;\n    }\n    return $counter;\n}\n\n=head2 get_path()\n\n Title   : get_path()\n Usage   : $o_consed->get_path();\n Function: Returns the path to the acefile this object is working with.\n Returns : Scalar. The path to the working acefile.\n Args    : None.\n\n\nsub get_path {\n    my $self = shift;\n    return $self->{'path'};\n}\n\n=head2 get_contigs()\n\n Title   : get_contigs()\n Usage   : $o_consed->get_contigs();\n Function: Return the keys to the Bio::Tools::Alignment::Consed object.\n Returns : An array containing the keynames in the\n           Bio::Tools::Alignment::Consed object.\n Args    : None.\n\nThis would normally be used to get the keynames for some sort of\niterator. These keys are worthless in general day-to-day use because\nin the Consed acefile they are simply Contig1, Contig2, ...\n\n\nsub get_contigs {\n    my ($self,$contig) = @_;\n    my @contigs = sort keys %{$self->{'contigs'}};\n    return @contigs;\n}\n\n=head2 get_class($contig_keyname)\n\n Title   : get_class($contig_keyname)\n Usage   : $o_consed->get_class($contig_keyname);\n Function: Return the class name for this contig\n Returns : A scalar representing the class of this contig.\n Args    : None.\n Notes   : \n\n\nsub get_class {\n    my ($self,$contig) = @_;\n    return $self->{contigs}->{$contig}->{class};\n}\n\n=head2 get_quality_array($contig_keyname)\n\n Title   : get_quality_array($contig_keyname)\n Usage   : $o_consed->get_quality_array($contig_keyname);\n Function: Returns the quality for the consensus sequence for the given\n\t   contig as an array. See get_quality_scalar to get this as a scalar.\n Returns : An array containing the quality for the consensus sequence with\n\t   the given keyname.\n Args    : The keyname of a contig. Note: This is a keyname. The key would\n\t   normally come from get_contigs.\n\nReturns an array, not a reference. Is this a bug? I<thinking> No.\nWell, maybe.  Why was this developed like this? I was using FreezeThaw\nfor object persistence, and when it froze out these arrays it took a\nlong time to thaw it. Much better as a scalar.\n\nSee L<get_quality_scalar()|get_quality_scalar>\n\n\nsub get_quality_array {\n    my ($self,$contig) = @_;\n    return split ' ', $self->{contigs}->{$contig}->{quality};\n}\n\n=head2 get_quality_scalar($contig_keyname)\n\n Title   : get_quality_scalar($contig_keyname)\n Usage   : $o_consed->get_quality_scalar($contig_keyname);\n Function: Returns the quality for the consensus sequence for the given\n\t   contig as a scalar. See get_quality_array to get this as an array.\n Returns : An scalar containing the quality for the consensus sequence with\n           the given keyname.\n Args    : The keyname of a contig. Note this is a _keyname_. The key would\n\t   normally come from get_contigs.\n\nWhy was this developed like this? I was using FreezeThaw for object\npersistence, and when it froze out these arrays it took a coon's age\nto thaw it. Much better as a scalar.\n\nSee L<get_quality_array()|get_quality_array>\n\n\n#'\nsub get_quality_scalar {\n    my ($self,$contig) = @_;\n    return $self->{'contigs'}->{$contig}->{'quality'};\n}\n\n=head2 freeze_hash()\n\n Title   : freeze_hash()\n Usage   : $o_consed->freeze_hash();\n\n Function: Use Ilya's FreezeThaw module to create a persistent data\n\t   object for this Bio::Tools::Alignment::Consed data\n\t   structure. In the case of AAFC, we use\n\t   Bio::Tools::Alignment::Consed to pre-process bunches of\n\t   sequences, freeze the structures, and send in a harvesting\n\t   robot later to do database stuff.\n Returns : 0 or 1;\n Args    : None.\n\nThis procedure was removed so Consed.pm won't require FreezeThaw.\n\n\n#'\nsub freeze_hash {\n    my $self = shift;\n    $self->warn(\"This method (freeze_hash) was removed \".\n                \"from the bioperl consed.pm. Sorry.\\n\");\n    if (1==2) {\n        $self->debug(\"Bio::Tools::Alignment::Consed::freeze_hash:\".\n                     \" \\$self->{path} is $self->{path}\\n\");\n        my $filename = $self->{'path'}.\"frozen\";\n        my %contigs = %{$self->{'contigs'}};\n        my $frozen = freeze(%contigs);\n        umask 0001;\n        open (my $FREEZE,\">$filename\") or do {\n            $self->warn( \"Bio::Tools::Alignment::Consed could not \".\n                         \"freeze the contig hash because the file \".\n                         \"($filename) could not be opened: $!\\n\");\n            return 1;\n        };\n        print $FREEZE $frozen;\n        return 0;\n    }\n}\n\n=head2 get_members($contig_keyname)\n\n Title   : get_members($contig_keyname)\n Usage   : $o_consed->get_members($contig_keyname);\n Function: Return the _names_ of the reads in this contig.\n Returns : An array containing the names of the reads in this contig.\n Args    : The keyname of a contig. Note this is a keyname. The keyname\n\t   would normally come from get_contigs.\n\nSee L<get_contigs()|get_contigs>\n\n\nsub get_members {\n    my ($self,$contig) = @_;\n    if (!$contig) {\n\t$self->warn(\"You need to provide the name of a contig to \".\n                    \"use Bio::Tools::Alignment::Consed::get_members!\\n\");\n\treturn;\n    }\n    return @{$self->{'contigs'}->{$contig}->{'member_array'}};\n}\n\n=head2 get_members_by_name($some_arbitrary_name)\n\n Title   : get_members_by_name($some_arbitrary_name)\n Usage   : $o_consed->get_members_by_name($some_arbitrary_name);\n Function: Return the names of the reads in a contig. This is the name given\n\t   to $contig{key} based on what is in the contig. This is different\n\t   from the keys retrieved through get_contigs().\n Returns : An array containing the names of the reads in the contig with this\n\t   name.\n Args    : The name of a contig. Not a key, but a name.\n\nHighly inefficient. use some other method if possible.\nSee L<get_contigs()|get_contigs>\n\n\nsub get_members_by_name {\n    my ($self,$name) = @_;\n    # build a list to try to screen for redundancy\n    my @contigs_with_that_name;\n    foreach my $currkey ( sort keys %{$self->{'contigs'}} ) {\n\tnext if (!$self->{'contigs'}->{$currkey}->{'name'});\n\tif ($self->{'contigs'}->{$currkey}->{'name'} eq \"$name\") {\n\t    push @contigs_with_that_name,$currkey;\n\t}\n    }\n    my $count = @contigs_with_that_name;\n    if ($count == 1) {\n\tmy $contig_num = $contigs_with_that_name[0];\n\treturn @{$self->{'contigs'}->{$contig_num}->{'member_array'}};\n    }\n}\n\n=head2 get_contig_number_by_name($some_arbitrary_name)\n\n Title   : get_contig_number_by_name($some_arbitrary_name)\n Usage   : $o_consed->get_contig_number_by_name($some_arbitrary_name);\n Function: Return the names of the reads in a contig. This is the name given\n\t   to $contig{key} based on what is in the contig. This is different\n\t   from the keys retrieved through get_contigs().\n Returns : An array containing the names of the reads in the contig with this\n\t   name.\n Args    : The name of a contig. Not a key, but a name.\n\nSee L<get_contigs()|get_contigs>\n\n\nsub get_contig_number_by_name {\n    my ($self,$name) = @_;\n    foreach my $currkey (sort keys %{$self->{'contigs'}}) {\n\tif ($self->{'contigs'}->{$currkey}->{'name'} && \n\t    $self->{'contigs'}->{$currkey}->{'name'} eq \"$name\") {\n\t    return $currkey;\n\t}\n    }\n}\t\n\n=head2 get_sequence($contig_keyname)\n\n Title   : get_sequence($contig_keyname)\n Usage   : $o_consed->get_sequence($contig_keyname); \n Function: Returns the consensus sequence for a given contig.\n Returns : A scalar containing a sequence.\n Args    : The keyname of a contig. Note this is a key. The key would\n\t   normally come from get_contigs.\n\nSee L<get_contigs()|get_contigs>\n\n\nsub get_sequence {\n    my ($self,$contig) = @_;\n    return $self->{'contigs'}->{$contig}->{'consensus'};\n}\n\n=head2 set_final_sequence($some_sequence)\n\n Title   : set_final_sequence($name,$some_sequence)\n Usage   : $o_consed->set_final_sequence($name,$some_sequence);\n Function: Provides a manual way to set the sequence for a given key in the\n\t   contig hash. Rarely used.\n Returns : 0 or 1;\n Args    : The name (not the keyname) of a contig and an arbitrary string.\n\nA method with a questionable and somewhat mysterious origin. May raise\nthe dead or something like that.\n\n\nsub set_final_sequence {\n    my ($self,$name,$sequence) = @_;\n    if (!$self->{'contigs'}->{$name}) {\n\t$self->warn(\"You cannot set the final sequence for \".\n                    \"$name because it doesn't exist!\\n\");\n\treturn 1;\n    }\n    else {\n\t$self->{'contigs'}->{$name}->{'final_sequence'} = $sequence;\n    }\n    return 0;\n}\n\n=head2  _read_file()\n\n Title   : _read_file();\n Usage   : _read_file();\n Function: An internal subroutine used to read in an acefile and parse it\n\t   into a Bio::Tools::Alignment::Consed object.\n Returns : 0 or 1.\n Args    : Nothing.\n\nThis routine creates and saves the filhandle for reading the files in\n{fh}\n\n\nsub _read_file {\n    my ($self) = @_;\n    my ($line,$in_contig,$in_quality,$contig_number,$top);\n    # make it easier to type $fhl\n    while (defined($line=$self->_readline()) ) {\n\tchomp $line;\n\t# check if there is anything on this line\n\t# if not, you can stop gathering consensus sequence\n\tif (!$line) {\n\t    # if the line is blank you are no longer to gather consensus \n\t    # sequence or quality values\n\t    $in_contig = 0;\n\t    $in_quality = 0;\n\t}\n\t# you are currently gathering consensus sequence\n\telsif ($in_contig) {\n\t    if ($in_contig == 1) {\n\t\t$self->debug(\"Adding $line to consensus of contig number $contig_number.\\n\");\n\t\t$self->{'contigs'}->{$contig_number}->{'consensus'} .= $line;\n\t    }\n\t}\n\telsif ($in_quality) {\n\t    if (!$line) {\n\t\t$in_quality = undef;\n\t    }\n\t    else {\n\n\t\t# I wrote this in here because acefiles produced by\n\t\t# cap3 do not have a leading space like the acefiles\n\t\t# produced by phrap and there is the potential to have\n\t\t# concatenated quality values like this: 2020 rather\n\t\t# then 20 20 whre lines collide. Thanks Andrew for\n\t\t# noticing.\n\n\t\tif ($self->{'contigs'}->{$contig_number}->{'quality'} &&\n                    !($self->{'contigs'}->{$contig_number}->{'quality'} =~ m/\\ $/)) {\n\t\t    $self->{'contigs'}->{$contig_number}->{'quality'} .= \" \";\n\t\t}\n\t\t$self->{'contigs'}->{$contig_number}->{'quality'} .= $line;\n\t    }\n\t}\n\telsif ($line =~ /^BQ/) {\n\t    $in_quality = 1;\n\t}\n\n\t# the line /^CO/ like this:\n\t# CO Contig1 796 1 1 U\n\t# can be broken down as follows:\n\t# CO - Contig!\n\t# Contig1 - the name of this contig\n\t# 796 - Number of bases in this contig\n\t# 1 - Number of reads in this contig\n\t# 1 - number of base segments in this contig\n\t# U - Uncomplemented\n\n\telsif ($line =~ /^CO/) {\n\t    $line =~ m/^CO\\ Contig(\\d+)\\ \\d+\\ \\d+\\ \\d+\\ (\\w)/;\n\t    $contig_number = $1;\n\t    if ($2 eq \"C\") {\n\t\t$self->debug(\"Contig $contig_number is complemented!\\n\");\n\t    }\n\t    $self->{'contigs'}->{$contig_number}->{'member_array'} = [];\n\t    $self->{'contigs'}->{$contig_number}->{'contig_direction'} = \"$2\";\n\t    $in_contig = 1;\n\t}\n\n\t# 000713\n\t# this BS is deprecated, I think.\n\t# haha, I am really witty. <ew>\n\n\telsif ($line =~ /^BSDEPRECATED/) {\n\t    $line =~ m/^BS\\s+\\d+\\s+\\d+\\s+(.+)/;\n\t    my $member = $1;\n\t    $self->{'contigs'}->{$contig_number}->{$member}++;\n\t}\n\t# the members of the contigs are determined by the AF line in the ace file\n\telsif ($line =~ /^AF/) {\n\t    $self->debug(\"I see an AF line here.\\n\");\n\t    $line =~ /^AF\\ (\\S+)\\ (\\w)\\ (\\S+)/;\n\n            # push the name of the current read onto the member array for this contig\n\t    push @{$self->{'contigs'}->{$contig_number}->{'member_array'}},$1;\n\n            # the first read in the contig will be named the \"top\" read\n\t    if (!$top) {\n\t\t$self->debug(\"\\$top is not set.\\n\");\n\t\tif ($self->{'contigs'}->{$contig_number}->{'contig_direction'} eq \"C\") {\n\t\t    $self->debug(\"Reversing the order of the reads. The bottom will be $1\\n\");\n\n\t\t    # if the contig sequence is marked as the\n\t\t    # complement, the top becomes the bottom and$\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_name'} = $1;\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_complement'} = $2;\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_start'} = $3;\n\t\t}\n\t\telse {\n\t\t    $self->debug(\"NOT reversing the order of the reads. \".\n                                 \"The top_name will be $1\\n\");\n\t\t    # if the contig sequence is marked as the\n\t\t    # complement, the top becomes the bottom and$\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_name'} = $1;\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_complement'} = $2;\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_start'} = $3;\n\t\t}\n\t\t$top = 1;\n\t    }\n\t    else {\n\n\t\t# if the contig sequence is marked as the complement,\n\t\t# the top becomes the bottom and the bottom becomes\n\t\t# the top\n\t\tif ($self->{'contigs'}->{$contig_number}->{'contig_direction'} eq \"C\") {\n\t\t    $self->debug(\"Reversing the order of the reads. The top will be $1\\n\");\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_name'} = $1;\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_complement'} = $2;\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_start'} = $3;\n\t\t}\n\t\telse {\n\t\t    $self->debug(\"NOT reversing the order of the reads. The bottom will be $1\\n\");\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_name'} = $1;\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_complement'} = $2;\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_start'} = $3;\n\t\t}\n\t\t$top = undef;\n\t    }\n\t}\n    }\n    return 0;\n}\n\n=head2 set_reverse_designator($some_string)\n\n Title   : set_reverse_designator($some_string)\n Usage   : $o_consed->set_reverse_designator($some_string);\n Function: Set the designator for the reverse read of contigs in this\n\t   Bio::Tools::Alignment::Consed object. Used to determine if\n           contigs containing two reads can be named.\n Returns : The value of $o_consed->{reverse_designator} so you can check\n\t   to see that it was set properly.\n Args    : An arbitrary string.\n\nMay be useful only to me. I<shrug>\n\n\nsub set_reverse_designator {\n    my ($self,$reverse_designator) = @_;\n    $self->{'reverse_designator'} = $reverse_designator;\n    $self->{'o_trim'}->set_reverse_designator($reverse_designator);\n    return $self->{'reverse_designator'};\n}\t\t\t\t# end set_reverse_designator\n\n=head2 set_forward_designator($some_string)\n\n Title   : set_forward_designator($some_string)\n Usage   : $o_consed->set_forward_designator($some_string);\n Function: Set the designator for the forward read of contigs in this\n\t   Bio::Tools::Alignment::Consed object. Used to determine if\n           contigs containing two reads can be named.\n Returns : The value of $o_consed->{forward_designator} so you can check\n\t   to see that it was set properly.\n Args    : An arbitrary string.\n\nMay be useful only to me. I<shrug>\n\n\nsub set_forward_designator {\n    my ($self,$forward_designator) = @_;\n    $self->{'forward_designator'} = $forward_designator;\n    $self->{'o_trim'}->set_forward_designator($forward_designator);\n    return $self->{'forward_designator'};\n}\t\t\t\t# end set_forward_designator\n\n=head2 set_designator_ignore_case(\"yes\")\n\n Title   : set_designator_ignore_case(\"yes\")\n Usage   : $o_consed->set_designator_ignore_case(\"yes\");\n Function: Deprecated.\n Returns : Deprecated.\n Args    : Deprecated.\n\nDeprecated. Really. Trust me.","parameters":[{"label":"$self"},{"label":"$ignore_case"}],"label":"set_designator_ignore_case($self,$ignore_case)"},"detail":"($self,$ignore_case)","definition":"sub","containerName":"main::","children":[{"kind":13,"line":724,"definition":"my","name":"$self","containerName":"set_designator_ignore_case","localvar":"my"},{"containerName":"set_designator_ignore_case","name":"$ignore_case","line":724,"kind":13},{"kind":13,"line":725,"name":"$ignore_case","containerName":"set_designator_ignore_case"},{"name":"$self","containerName":"set_designator_ignore_case","kind":13,"line":726},{"line":728,"kind":13,"name":"$self","containerName":"set_designator_ignore_case"}],"line":723,"kind":12},{"range":{"start":{"character":0,"line":753},"end":{"line":762,"character":9999}},"name":"set_trim_points_singlets_and_singletons","signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Consed.pm 16123 2009-09-17 12:57:27Z cjfields $\n# Bio::Tools::Alignment::Consed\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chad Matsalla\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Alignment::Consed - A module to work with objects from consed .ace files\n\n=head1 SYNOPSIS\n\n  # a report for sequencing stuff\n  my $o_consed = Bio::Tools::Alignment::Consed->new( \n      -acefile => \"/path/to/an/acefile.ace.1\",\n      -verbose => 1);\n  my $foo = $o_consed->set_reverse_designator(\"r\");\n  my $bar = $o_consed->set_forward_designator(\"f\");\n\n  # get the contig numbers\n  my @keys = $o_consed->get_contigs();\n\n  # construct the doublets\n  my $setter_doublets = $o_consed->choose_doublets();\n\n  # get the doublets\n  my @doublets = $o_consed->get_doublets();\n\n=head1 DESCRIPTION\n\nL<Bio::Tools::Alignment::Consed> provides methods and objects to deal\nwith the output from the Consed software suite. Specifically,\ntakes an C<.ace> file and provides objects for the results.\n\nA word about doublets: This module was written to accomodate a large\nEST sequencing operation. In this case, EST's were sequenced from the\n3' and from the 5' end of the EST. The objective was to find a\nconsensus sequence for these two reads.  Thus, a contig of two is what\nwe wanted, and this contig should consist of the forward and reverse\nreads of a getn clone. For example, for a forward designator of \"F\"\nand a reverse designator of \"R\", if the two reads chad1F and chad1R\nwere in a single contig (for example Contig 5) it will be determined\nthat the consensus sequence for Contig 5 will be the sequence for\nclone chad1.\n\nDoublets are good!\n\nThis module parses C<.ace> and related files. A detailed list of methods\ncan be found at the end of this document.\n\nI wrote a detailed rationale for design that may explain the reasons\nwhy some things were done the way they were done. That document is\nbeyond the scope of this pod and can probably be found in the\ndirectory from which this module was 'made' or at\nL<http://www.dieselwurks.com/bioinformatics/consedpm_documentation.pdf>.\n\nNote that the POD in that document might be old but the original\nrationale still stands.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nEmail chad-at-dieselwurks.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n#' \n\npackage Bio::Tools::Alignment::Consed;\n\nuse strict;\n\nuse FileHandle;\nuse Dumpvalue qw(dumpValue);\nuse Bio::Tools::Alignment::Trim;\nuse File::Spec;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\nour %DEFAULTS = ( 'f_designator' => 'f',\n\t\t  'r_designator' => 'r');\n\n=head2 new()\n\n Title   : new(-acefile => $path_to_some_acefile, -verbose => \"1\")\n Usage   : $o_consed = Bio::Tools::Alignment::Consed->\n              new(-acefile => $path_to_some_acefile, -verbose => \"1\");\n Function: Construct the Bio::Tools::Alignment::Consed object. Sets\n\t   verbosity for the following procedures, if necessary:\n\t   1. Construct a new Bio::Tools::Alignment::Trim object, to\n\t   handle quality trimming 2. Read in the acefile and parse it\n\n Returns : A reference to a Bio::Tools::Alignment::Consed object.\n Args    : A hash. (-acefile) is the filename of an acefile. If a full path\n\t   is not specified \"./\" is prepended to the filename and used from\n\t   instantiation until destruction. If you want \n           Bio::Tools::Alignment::Consed to be noisy during parsing of\n           the acefile, specify some value for (-verbose).\n\n\nsub new {\n    my ($class,%args) = @_;\n    my $self = $class->SUPER::new(%args);\n\n    $self->{'filename'} = $args{'-acefile'};\n\n    # this is special to UNIX and should probably use catfile : DONE!\n#    if (!($self->{'filename'} =~ m{/})) { \n#\t$self->{'filename'} = \"./\".$self->{'filename'}; \n#    } \n#    $self->{'filename'} =~ m/(.*\\/)(.*)ace.*$/;\n#    $self->{'path'} = $1;\n\n    # this is more generic and should work on most systems   \n    (undef, $self->{'path'}, undef) = File::Spec->splitpath($self->{'filename'});\n\n    $self->_initialize_io('-file'=>$self->{'filename'});\n    $self->{'o_trim'} = Bio::Tools::Alignment::Trim->new(-verbose => $self->verbose());\n    $self->set_forward_designator($DEFAULTS{'f_designator'});\n    $self->set_reverse_designator($DEFAULTS{'r_designator'});\n\n    $self->_read_file();\n    return $self;\n}\n\n=head2 set_verbose()\n\n Title   : set_verbose()\n Usage   : $o_consed->set_verbose(1);\n Function: Set the verbosity level for debugging messages. On instantiation\n\t   of the Bio::Tools::Alignment::Consed object the verbosity level\n           is set to 0 (quiet).\n Returns : 1 or 0.\n Args    : The verbosity levels are:\n\t      0 - quiet\n\t      1 - noisy\n\t      2 - noisier\n\t      3 - annoyingly noisy\n\nThis method for setting verbosity has largely been superseeded by a\nsub-by-sub way, where for every sub you can provide a (-verbose)\nswitch. I am doing converting this bit-by-bit so do not be surprised\nif some subs do not honour this.\n\n\n# from RootI\n\n# backwards compat\nsub set_verbose { (shift)->verbose(@_) }\n\n=head2 get_filename()\n\n Title   : get_filename()\n Usage   : $o_consed->get_filename();\n Function: Returns the name of the acefile being used by the\n\t   Bio::Tools::Alignment::Consed object.\n Returns : A scalar containing the name of a file.\n Args    : None.\n\n\n\nsub get_filename {\n    my $self = shift;\n    return $self->{'filename'};\n}\n\n=head2 count_sequences_with_grep()\n\n Title   : count_sequences_with_grep()\n Usage   : $o_consed->count_sequences_with_grep();\n Function: Use /bin/grep to scan through the files in the ace project dir\n\t   and count sequences in those files. I used this method in the\n\t   development of this module to verify that I was getting all of the\n\t   sequences. It works, but it is (I think) unix-like platform\n\t   dependent.\n Returns : A scalar containing the number of sequences in the ace project\n\t   directory.\n Args    : None.\n\nIf you are on a non-UNIX platform, you really do not have to use\nthis. It is more of a debugging routine designed to address very\nspecific problems.\n\nThis method was reimplemented to be platform independent with a pure\nperl implementation.  The above note can be ignored.\n\n\nsub count_sequences_with_grep {\n    my $self = shift;\n    my ($working_dir,$grep_cli,@total_grep_sequences);\n    # this should be migrated to a pure perl implementation ala\n    # Tom Christiansen's 'tcgrep'\n    # http://www.cpan.org/modules/by-authors/id/TOMC/scripts/tcgrep.gz\n\n    open(my $FILE, $self->{'filename'}) or do { $self->warn(\"cannot open file \".$self->{'filename'}. \" for grepping\"); return}; \n    my $counter =0;\n    while(<$FILE>) { $counter++ if(/^AF/); }\n\n    close $FILE;\n    opendir(my $SINGLETS,$self->{'path'});\n    foreach my $f ( readdir($SINGLETS) ) {\n\tnext unless ($f =~ /\\.singlets$/); \n\topen(my $FILE, File::Spec->catfile($self->{'path'},$f)) or do{ $self->warn(\"cannot open file \".File::Spec->catfile($self->{'path'},$f)); next };\n\twhile(<$FILE>) { $counter++ if(/^>/) }\n\tclose $FILE;\n    }\n    return $counter;\n}\n\n=head2 get_path()\n\n Title   : get_path()\n Usage   : $o_consed->get_path();\n Function: Returns the path to the acefile this object is working with.\n Returns : Scalar. The path to the working acefile.\n Args    : None.\n\n\nsub get_path {\n    my $self = shift;\n    return $self->{'path'};\n}\n\n=head2 get_contigs()\n\n Title   : get_contigs()\n Usage   : $o_consed->get_contigs();\n Function: Return the keys to the Bio::Tools::Alignment::Consed object.\n Returns : An array containing the keynames in the\n           Bio::Tools::Alignment::Consed object.\n Args    : None.\n\nThis would normally be used to get the keynames for some sort of\niterator. These keys are worthless in general day-to-day use because\nin the Consed acefile they are simply Contig1, Contig2, ...\n\n\nsub get_contigs {\n    my ($self,$contig) = @_;\n    my @contigs = sort keys %{$self->{'contigs'}};\n    return @contigs;\n}\n\n=head2 get_class($contig_keyname)\n\n Title   : get_class($contig_keyname)\n Usage   : $o_consed->get_class($contig_keyname);\n Function: Return the class name for this contig\n Returns : A scalar representing the class of this contig.\n Args    : None.\n Notes   : \n\n\nsub get_class {\n    my ($self,$contig) = @_;\n    return $self->{contigs}->{$contig}->{class};\n}\n\n=head2 get_quality_array($contig_keyname)\n\n Title   : get_quality_array($contig_keyname)\n Usage   : $o_consed->get_quality_array($contig_keyname);\n Function: Returns the quality for the consensus sequence for the given\n\t   contig as an array. See get_quality_scalar to get this as a scalar.\n Returns : An array containing the quality for the consensus sequence with\n\t   the given keyname.\n Args    : The keyname of a contig. Note: This is a keyname. The key would\n\t   normally come from get_contigs.\n\nReturns an array, not a reference. Is this a bug? I<thinking> No.\nWell, maybe.  Why was this developed like this? I was using FreezeThaw\nfor object persistence, and when it froze out these arrays it took a\nlong time to thaw it. Much better as a scalar.\n\nSee L<get_quality_scalar()|get_quality_scalar>\n\n\nsub get_quality_array {\n    my ($self,$contig) = @_;\n    return split ' ', $self->{contigs}->{$contig}->{quality};\n}\n\n=head2 get_quality_scalar($contig_keyname)\n\n Title   : get_quality_scalar($contig_keyname)\n Usage   : $o_consed->get_quality_scalar($contig_keyname);\n Function: Returns the quality for the consensus sequence for the given\n\t   contig as a scalar. See get_quality_array to get this as an array.\n Returns : An scalar containing the quality for the consensus sequence with\n           the given keyname.\n Args    : The keyname of a contig. Note this is a _keyname_. The key would\n\t   normally come from get_contigs.\n\nWhy was this developed like this? I was using FreezeThaw for object\npersistence, and when it froze out these arrays it took a coon's age\nto thaw it. Much better as a scalar.\n\nSee L<get_quality_array()|get_quality_array>\n\n\n#'\nsub get_quality_scalar {\n    my ($self,$contig) = @_;\n    return $self->{'contigs'}->{$contig}->{'quality'};\n}\n\n=head2 freeze_hash()\n\n Title   : freeze_hash()\n Usage   : $o_consed->freeze_hash();\n\n Function: Use Ilya's FreezeThaw module to create a persistent data\n\t   object for this Bio::Tools::Alignment::Consed data\n\t   structure. In the case of AAFC, we use\n\t   Bio::Tools::Alignment::Consed to pre-process bunches of\n\t   sequences, freeze the structures, and send in a harvesting\n\t   robot later to do database stuff.\n Returns : 0 or 1;\n Args    : None.\n\nThis procedure was removed so Consed.pm won't require FreezeThaw.\n\n\n#'\nsub freeze_hash {\n    my $self = shift;\n    $self->warn(\"This method (freeze_hash) was removed \".\n                \"from the bioperl consed.pm. Sorry.\\n\");\n    if (1==2) {\n        $self->debug(\"Bio::Tools::Alignment::Consed::freeze_hash:\".\n                     \" \\$self->{path} is $self->{path}\\n\");\n        my $filename = $self->{'path'}.\"frozen\";\n        my %contigs = %{$self->{'contigs'}};\n        my $frozen = freeze(%contigs);\n        umask 0001;\n        open (my $FREEZE,\">$filename\") or do {\n            $self->warn( \"Bio::Tools::Alignment::Consed could not \".\n                         \"freeze the contig hash because the file \".\n                         \"($filename) could not be opened: $!\\n\");\n            return 1;\n        };\n        print $FREEZE $frozen;\n        return 0;\n    }\n}\n\n=head2 get_members($contig_keyname)\n\n Title   : get_members($contig_keyname)\n Usage   : $o_consed->get_members($contig_keyname);\n Function: Return the _names_ of the reads in this contig.\n Returns : An array containing the names of the reads in this contig.\n Args    : The keyname of a contig. Note this is a keyname. The keyname\n\t   would normally come from get_contigs.\n\nSee L<get_contigs()|get_contigs>\n\n\nsub get_members {\n    my ($self,$contig) = @_;\n    if (!$contig) {\n\t$self->warn(\"You need to provide the name of a contig to \".\n                    \"use Bio::Tools::Alignment::Consed::get_members!\\n\");\n\treturn;\n    }\n    return @{$self->{'contigs'}->{$contig}->{'member_array'}};\n}\n\n=head2 get_members_by_name($some_arbitrary_name)\n\n Title   : get_members_by_name($some_arbitrary_name)\n Usage   : $o_consed->get_members_by_name($some_arbitrary_name);\n Function: Return the names of the reads in a contig. This is the name given\n\t   to $contig{key} based on what is in the contig. This is different\n\t   from the keys retrieved through get_contigs().\n Returns : An array containing the names of the reads in the contig with this\n\t   name.\n Args    : The name of a contig. Not a key, but a name.\n\nHighly inefficient. use some other method if possible.\nSee L<get_contigs()|get_contigs>\n\n\nsub get_members_by_name {\n    my ($self,$name) = @_;\n    # build a list to try to screen for redundancy\n    my @contigs_with_that_name;\n    foreach my $currkey ( sort keys %{$self->{'contigs'}} ) {\n\tnext if (!$self->{'contigs'}->{$currkey}->{'name'});\n\tif ($self->{'contigs'}->{$currkey}->{'name'} eq \"$name\") {\n\t    push @contigs_with_that_name,$currkey;\n\t}\n    }\n    my $count = @contigs_with_that_name;\n    if ($count == 1) {\n\tmy $contig_num = $contigs_with_that_name[0];\n\treturn @{$self->{'contigs'}->{$contig_num}->{'member_array'}};\n    }\n}\n\n=head2 get_contig_number_by_name($some_arbitrary_name)\n\n Title   : get_contig_number_by_name($some_arbitrary_name)\n Usage   : $o_consed->get_contig_number_by_name($some_arbitrary_name);\n Function: Return the names of the reads in a contig. This is the name given\n\t   to $contig{key} based on what is in the contig. This is different\n\t   from the keys retrieved through get_contigs().\n Returns : An array containing the names of the reads in the contig with this\n\t   name.\n Args    : The name of a contig. Not a key, but a name.\n\nSee L<get_contigs()|get_contigs>\n\n\nsub get_contig_number_by_name {\n    my ($self,$name) = @_;\n    foreach my $currkey (sort keys %{$self->{'contigs'}}) {\n\tif ($self->{'contigs'}->{$currkey}->{'name'} && \n\t    $self->{'contigs'}->{$currkey}->{'name'} eq \"$name\") {\n\t    return $currkey;\n\t}\n    }\n}\t\n\n=head2 get_sequence($contig_keyname)\n\n Title   : get_sequence($contig_keyname)\n Usage   : $o_consed->get_sequence($contig_keyname); \n Function: Returns the consensus sequence for a given contig.\n Returns : A scalar containing a sequence.\n Args    : The keyname of a contig. Note this is a key. The key would\n\t   normally come from get_contigs.\n\nSee L<get_contigs()|get_contigs>\n\n\nsub get_sequence {\n    my ($self,$contig) = @_;\n    return $self->{'contigs'}->{$contig}->{'consensus'};\n}\n\n=head2 set_final_sequence($some_sequence)\n\n Title   : set_final_sequence($name,$some_sequence)\n Usage   : $o_consed->set_final_sequence($name,$some_sequence);\n Function: Provides a manual way to set the sequence for a given key in the\n\t   contig hash. Rarely used.\n Returns : 0 or 1;\n Args    : The name (not the keyname) of a contig and an arbitrary string.\n\nA method with a questionable and somewhat mysterious origin. May raise\nthe dead or something like that.\n\n\nsub set_final_sequence {\n    my ($self,$name,$sequence) = @_;\n    if (!$self->{'contigs'}->{$name}) {\n\t$self->warn(\"You cannot set the final sequence for \".\n                    \"$name because it doesn't exist!\\n\");\n\treturn 1;\n    }\n    else {\n\t$self->{'contigs'}->{$name}->{'final_sequence'} = $sequence;\n    }\n    return 0;\n}\n\n=head2  _read_file()\n\n Title   : _read_file();\n Usage   : _read_file();\n Function: An internal subroutine used to read in an acefile and parse it\n\t   into a Bio::Tools::Alignment::Consed object.\n Returns : 0 or 1.\n Args    : Nothing.\n\nThis routine creates and saves the filhandle for reading the files in\n{fh}\n\n\nsub _read_file {\n    my ($self) = @_;\n    my ($line,$in_contig,$in_quality,$contig_number,$top);\n    # make it easier to type $fhl\n    while (defined($line=$self->_readline()) ) {\n\tchomp $line;\n\t# check if there is anything on this line\n\t# if not, you can stop gathering consensus sequence\n\tif (!$line) {\n\t    # if the line is blank you are no longer to gather consensus \n\t    # sequence or quality values\n\t    $in_contig = 0;\n\t    $in_quality = 0;\n\t}\n\t# you are currently gathering consensus sequence\n\telsif ($in_contig) {\n\t    if ($in_contig == 1) {\n\t\t$self->debug(\"Adding $line to consensus of contig number $contig_number.\\n\");\n\t\t$self->{'contigs'}->{$contig_number}->{'consensus'} .= $line;\n\t    }\n\t}\n\telsif ($in_quality) {\n\t    if (!$line) {\n\t\t$in_quality = undef;\n\t    }\n\t    else {\n\n\t\t# I wrote this in here because acefiles produced by\n\t\t# cap3 do not have a leading space like the acefiles\n\t\t# produced by phrap and there is the potential to have\n\t\t# concatenated quality values like this: 2020 rather\n\t\t# then 20 20 whre lines collide. Thanks Andrew for\n\t\t# noticing.\n\n\t\tif ($self->{'contigs'}->{$contig_number}->{'quality'} &&\n                    !($self->{'contigs'}->{$contig_number}->{'quality'} =~ m/\\ $/)) {\n\t\t    $self->{'contigs'}->{$contig_number}->{'quality'} .= \" \";\n\t\t}\n\t\t$self->{'contigs'}->{$contig_number}->{'quality'} .= $line;\n\t    }\n\t}\n\telsif ($line =~ /^BQ/) {\n\t    $in_quality = 1;\n\t}\n\n\t# the line /^CO/ like this:\n\t# CO Contig1 796 1 1 U\n\t# can be broken down as follows:\n\t# CO - Contig!\n\t# Contig1 - the name of this contig\n\t# 796 - Number of bases in this contig\n\t# 1 - Number of reads in this contig\n\t# 1 - number of base segments in this contig\n\t# U - Uncomplemented\n\n\telsif ($line =~ /^CO/) {\n\t    $line =~ m/^CO\\ Contig(\\d+)\\ \\d+\\ \\d+\\ \\d+\\ (\\w)/;\n\t    $contig_number = $1;\n\t    if ($2 eq \"C\") {\n\t\t$self->debug(\"Contig $contig_number is complemented!\\n\");\n\t    }\n\t    $self->{'contigs'}->{$contig_number}->{'member_array'} = [];\n\t    $self->{'contigs'}->{$contig_number}->{'contig_direction'} = \"$2\";\n\t    $in_contig = 1;\n\t}\n\n\t# 000713\n\t# this BS is deprecated, I think.\n\t# haha, I am really witty. <ew>\n\n\telsif ($line =~ /^BSDEPRECATED/) {\n\t    $line =~ m/^BS\\s+\\d+\\s+\\d+\\s+(.+)/;\n\t    my $member = $1;\n\t    $self->{'contigs'}->{$contig_number}->{$member}++;\n\t}\n\t# the members of the contigs are determined by the AF line in the ace file\n\telsif ($line =~ /^AF/) {\n\t    $self->debug(\"I see an AF line here.\\n\");\n\t    $line =~ /^AF\\ (\\S+)\\ (\\w)\\ (\\S+)/;\n\n            # push the name of the current read onto the member array for this contig\n\t    push @{$self->{'contigs'}->{$contig_number}->{'member_array'}},$1;\n\n            # the first read in the contig will be named the \"top\" read\n\t    if (!$top) {\n\t\t$self->debug(\"\\$top is not set.\\n\");\n\t\tif ($self->{'contigs'}->{$contig_number}->{'contig_direction'} eq \"C\") {\n\t\t    $self->debug(\"Reversing the order of the reads. The bottom will be $1\\n\");\n\n\t\t    # if the contig sequence is marked as the\n\t\t    # complement, the top becomes the bottom and$\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_name'} = $1;\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_complement'} = $2;\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_start'} = $3;\n\t\t}\n\t\telse {\n\t\t    $self->debug(\"NOT reversing the order of the reads. \".\n                                 \"The top_name will be $1\\n\");\n\t\t    # if the contig sequence is marked as the\n\t\t    # complement, the top becomes the bottom and$\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_name'} = $1;\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_complement'} = $2;\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_start'} = $3;\n\t\t}\n\t\t$top = 1;\n\t    }\n\t    else {\n\n\t\t# if the contig sequence is marked as the complement,\n\t\t# the top becomes the bottom and the bottom becomes\n\t\t# the top\n\t\tif ($self->{'contigs'}->{$contig_number}->{'contig_direction'} eq \"C\") {\n\t\t    $self->debug(\"Reversing the order of the reads. The top will be $1\\n\");\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_name'} = $1;\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_complement'} = $2;\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_start'} = $3;\n\t\t}\n\t\telse {\n\t\t    $self->debug(\"NOT reversing the order of the reads. The bottom will be $1\\n\");\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_name'} = $1;\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_complement'} = $2;\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_start'} = $3;\n\t\t}\n\t\t$top = undef;\n\t    }\n\t}\n    }\n    return 0;\n}\n\n=head2 set_reverse_designator($some_string)\n\n Title   : set_reverse_designator($some_string)\n Usage   : $o_consed->set_reverse_designator($some_string);\n Function: Set the designator for the reverse read of contigs in this\n\t   Bio::Tools::Alignment::Consed object. Used to determine if\n           contigs containing two reads can be named.\n Returns : The value of $o_consed->{reverse_designator} so you can check\n\t   to see that it was set properly.\n Args    : An arbitrary string.\n\nMay be useful only to me. I<shrug>\n\n\nsub set_reverse_designator {\n    my ($self,$reverse_designator) = @_;\n    $self->{'reverse_designator'} = $reverse_designator;\n    $self->{'o_trim'}->set_reverse_designator($reverse_designator);\n    return $self->{'reverse_designator'};\n}\t\t\t\t# end set_reverse_designator\n\n=head2 set_forward_designator($some_string)\n\n Title   : set_forward_designator($some_string)\n Usage   : $o_consed->set_forward_designator($some_string);\n Function: Set the designator for the forward read of contigs in this\n\t   Bio::Tools::Alignment::Consed object. Used to determine if\n           contigs containing two reads can be named.\n Returns : The value of $o_consed->{forward_designator} so you can check\n\t   to see that it was set properly.\n Args    : An arbitrary string.\n\nMay be useful only to me. I<shrug>\n\n\nsub set_forward_designator {\n    my ($self,$forward_designator) = @_;\n    $self->{'forward_designator'} = $forward_designator;\n    $self->{'o_trim'}->set_forward_designator($forward_designator);\n    return $self->{'forward_designator'};\n}\t\t\t\t# end set_forward_designator\n\n=head2 set_designator_ignore_case(\"yes\")\n\n Title   : set_designator_ignore_case(\"yes\")\n Usage   : $o_consed->set_designator_ignore_case(\"yes\");\n Function: Deprecated.\n Returns : Deprecated.\n Args    : Deprecated.\n\nDeprecated. Really. Trust me.\n\n\nsub set_designator_ignore_case {\n    my ($self,$ignore_case) = @_;\n    if ($ignore_case eq \"yes\") {\n\t$self->{'designator_ignore_case'} = 1;\n    }\n    return $self->{'designator_ignore_case'};\n}\t\t\t\t# end set_designator_ignore_case\n\n=head2 set_trim_points_singlets_and_singletons()\n\n Title   : set_trim_points_singlets_and_singletons()\n Usage   : $o_consed->set_trim_points_singlets_and_singletons();\n Function: Set the trim points for singlets and singletons based on\n\t   quality.  Uses the Bio::Tools::Alignment::Trim object. Use\n\t   at your own risk because the Bio::Tools::Alignment::Trim\n\t   object was designed specifically for me and is mysterious\n\t   in its ways. Every time somebody other then me uses it a\n\t   swarm of locusts decends on a small Central American\n\t   village so do not say you weren't warned.\n Returns : Nothing.\n Args    : None.\n\nWorking on exceptions and warnings here.\n\nSee L<Bio::Tools::Alignment::Trim> for more information\n\n' to make my emacs happy","label":"set_trim_points_singlets_and_singletons($self)"},"detail":"($self)","definition":"sub","containerName":"main::","children":[{"kind":13,"line":754,"containerName":"set_trim_points_singlets_and_singletons","definition":"my","name":"$self","localvar":"my"},{"name":"$self","containerName":"set_trim_points_singlets_and_singletons","kind":13,"line":755},{"containerName":"set_trim_points_singlets_and_singletons","name":"debug","line":755,"kind":12},{"kind":13,"line":756,"containerName":"set_trim_points_singlets_and_singletons","definition":"my","name":"@points","localvar":"my"},{"kind":13,"line":756,"name":"$trimmed_sequence","containerName":"set_trim_points_singlets_and_singletons"},{"name":"$self","containerName":"set_trim_points_singlets_and_singletons","kind":13,"line":757},{"line":758,"kind":13,"name":"$self","containerName":"set_trim_points_singlets_and_singletons"},{"kind":12,"line":758,"name":"debug","containerName":"set_trim_points_singlets_and_singletons"},{"containerName":"set_trim_points_singlets_and_singletons","name":"$self","line":760,"kind":13},{"kind":12,"line":760,"containerName":"set_trim_points_singlets_and_singletons","name":"set_doublets"},{"line":762,"kind":13,"name":"$self","containerName":"set_trim_points_singlets_and_singletons"}],"line":753,"kind":12},{"name":"%self","containerName":null,"kind":13,"line":763},{"containerName":null,"name":"$self","kind":13,"line":764},{"kind":12,"line":764,"containerName":"main::","name":"debug"},{"definition":"my","name":"$sequence","containerName":null,"localvar":"my","kind":13,"line":770},{"name":"$quality","containerName":null,"line":770,"kind":13},{"line":770,"kind":13,"containerName":null,"name":"$name"},{"line":770,"kind":13,"name":"$class","containerName":null},{"containerName":null,"name":"$sequence","line":771,"kind":13},{"name":"%self","containerName":null,"kind":13,"line":771},{"name":"%self","containerName":null,"kind":13,"line":772},{"line":772,"kind":13,"containerName":null,"name":"%quality"},{"kind":13,"line":773,"containerName":null,"name":"$quality"},{"line":773,"kind":13,"containerName":null,"name":"%self"},{"containerName":null,"name":"$name","kind":13,"line":774},{"name":"%self","containerName":null,"line":774,"kind":13},{"name":"$class","containerName":null,"line":775,"kind":13},{"name":"%self","containerName":null,"line":775,"kind":13},{"line":776,"kind":13,"containerName":null,"name":"@points"},{"containerName":null,"name":"%self","kind":13,"line":776},{"kind":12,"line":776,"containerName":"main::","name":"trim_singlet"},{"line":776,"kind":13,"containerName":null,"name":"$sequence"},{"containerName":null,"name":"$quality","line":776,"kind":13},{"kind":13,"line":776,"name":"$name","containerName":null},{"name":"$class","containerName":null,"line":776,"kind":13},{"containerName":null,"name":"%self","line":777,"kind":13},{"kind":13,"line":777,"containerName":null,"name":"@points"},{"kind":13,"line":778,"containerName":null,"name":"%self"},{"containerName":null,"name":"@points","kind":13,"line":778},{"name":"%self","containerName":null,"kind":13,"line":779},{"containerName":null,"name":"%self","kind":13,"line":780},{"name":"contigs","kind":12,"line":780},{"line":780,"kind":13,"name":"@points","containerName":null},{"kind":13,"line":780,"name":"@points","containerName":null},{"name":"@points","containerName":null,"line":780,"kind":13},{"containerName":null,"name":"$self","line":783,"kind":13},{"kind":12,"line":783,"containerName":"main::","name":"debug"},{"range":{"end":{"line":814,"character":9999},"start":{"line":806,"character":0}},"definition":"sub","name":"set_trim_points_doublets","containerName":"main::","children":[{"localvar":"my","containerName":"set_trim_points_doublets","definition":"my","name":"$self","line":807,"kind":13},{"kind":13,"line":808,"containerName":"set_trim_points_doublets","definition":"my","name":"@points","localvar":"my"},{"containerName":"set_trim_points_doublets","name":"$self","line":809,"kind":13},{"kind":12,"line":809,"containerName":"set_trim_points_doublets","name":"debug"},{"name":"$self","containerName":"set_trim_points_doublets","kind":13,"line":812},{"name":"debug","containerName":"set_trim_points_doublets","line":812,"kind":12},{"line":814,"kind":13,"containerName":"set_trim_points_doublets","name":"$self"}],"line":806,"kind":12},{"line":815,"kind":13,"name":"%self","containerName":null},{"localvar":"my","definition":"my","name":"@quals","containerName":null,"line":817,"kind":13},{"containerName":null,"name":"%self","line":817,"kind":13},{"kind":13,"line":819,"containerName":null,"name":"@points"},{"containerName":null,"name":"%self","line":819,"kind":13},{"name":"o_trim","line":819,"kind":12},{"line":820,"kind":12,"name":"trim_doublet","containerName":"main::"},{"name":"%self","containerName":null,"line":820,"kind":13},{"line":821,"kind":13,"containerName":null,"name":"%self"},{"line":822,"kind":13,"name":"%self","containerName":null},{"name":"name","kind":12,"line":822},{"name":"%self","containerName":null,"kind":13,"line":823},{"name":"%self","containerName":null,"line":824,"kind":13},{"name":"@points","containerName":null,"line":824,"kind":13},{"name":"%self","containerName":null,"line":825,"kind":13},{"containerName":null,"name":"@points","kind":13,"line":825},{"containerName":null,"name":"%self","line":827,"kind":13},{"containerName":null,"name":"%self","kind":13,"line":828},{"name":"contigs","kind":12,"line":828},{"kind":13,"line":829,"containerName":null,"name":"@points"},{"name":"@points","containerName":null,"line":829,"kind":13},{"kind":13,"line":829,"name":"@points","containerName":null},{"line":833,"kind":13,"containerName":null,"name":"$self"},{"kind":12,"line":833,"name":"debug","containerName":"main::"},{"range":{"end":{"character":9999,"line":862},"start":{"line":849,"character":0}},"name":"get_trimmed_sequence_by_name","signature":{"documentation":"1;\n# $Id: Consed.pm 16123 2009-09-17 12:57:27Z cjfields $\n# Bio::Tools::Alignment::Consed\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chad Matsalla\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Alignment::Consed - A module to work with objects from consed .ace files\n\n=head1 SYNOPSIS\n\n  # a report for sequencing stuff\n  my $o_consed = Bio::Tools::Alignment::Consed->new( \n      -acefile => \"/path/to/an/acefile.ace.1\",\n      -verbose => 1);\n  my $foo = $o_consed->set_reverse_designator(\"r\");\n  my $bar = $o_consed->set_forward_designator(\"f\");\n\n  # get the contig numbers\n  my @keys = $o_consed->get_contigs();\n\n  # construct the doublets\n  my $setter_doublets = $o_consed->choose_doublets();\n\n  # get the doublets\n  my @doublets = $o_consed->get_doublets();\n\n=head1 DESCRIPTION\n\nL<Bio::Tools::Alignment::Consed> provides methods and objects to deal\nwith the output from the Consed software suite. Specifically,\ntakes an C<.ace> file and provides objects for the results.\n\nA word about doublets: This module was written to accomodate a large\nEST sequencing operation. In this case, EST's were sequenced from the\n3' and from the 5' end of the EST. The objective was to find a\nconsensus sequence for these two reads.  Thus, a contig of two is what\nwe wanted, and this contig should consist of the forward and reverse\nreads of a getn clone. For example, for a forward designator of \"F\"\nand a reverse designator of \"R\", if the two reads chad1F and chad1R\nwere in a single contig (for example Contig 5) it will be determined\nthat the consensus sequence for Contig 5 will be the sequence for\nclone chad1.\n\nDoublets are good!\n\nThis module parses C<.ace> and related files. A detailed list of methods\ncan be found at the end of this document.\n\nI wrote a detailed rationale for design that may explain the reasons\nwhy some things were done the way they were done. That document is\nbeyond the scope of this pod and can probably be found in the\ndirectory from which this module was 'made' or at\nL<http://www.dieselwurks.com/bioinformatics/consedpm_documentation.pdf>.\n\nNote that the POD in that document might be old but the original\nrationale still stands.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nEmail chad-at-dieselwurks.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n#' \n\npackage Bio::Tools::Alignment::Consed;\n\nuse strict;\n\nuse FileHandle;\nuse Dumpvalue qw(dumpValue);\nuse Bio::Tools::Alignment::Trim;\nuse File::Spec;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\nour %DEFAULTS = ( 'f_designator' => 'f',\n\t\t  'r_designator' => 'r');\n\n=head2 new()\n\n Title   : new(-acefile => $path_to_some_acefile, -verbose => \"1\")\n Usage   : $o_consed = Bio::Tools::Alignment::Consed->\n              new(-acefile => $path_to_some_acefile, -verbose => \"1\");\n Function: Construct the Bio::Tools::Alignment::Consed object. Sets\n\t   verbosity for the following procedures, if necessary:\n\t   1. Construct a new Bio::Tools::Alignment::Trim object, to\n\t   handle quality trimming 2. Read in the acefile and parse it\n\n Returns : A reference to a Bio::Tools::Alignment::Consed object.\n Args    : A hash. (-acefile) is the filename of an acefile. If a full path\n\t   is not specified \"./\" is prepended to the filename and used from\n\t   instantiation until destruction. If you want \n           Bio::Tools::Alignment::Consed to be noisy during parsing of\n           the acefile, specify some value for (-verbose).\n\n\nsub new {\n    my ($class,%args) = @_;\n    my $self = $class->SUPER::new(%args);\n\n    $self->{'filename'} = $args{'-acefile'};\n\n    # this is special to UNIX and should probably use catfile : DONE!\n#    if (!($self->{'filename'} =~ m{/})) { \n#\t$self->{'filename'} = \"./\".$self->{'filename'}; \n#    } \n#    $self->{'filename'} =~ m/(.*\\/)(.*)ace.*$/;\n#    $self->{'path'} = $1;\n\n    # this is more generic and should work on most systems   \n    (undef, $self->{'path'}, undef) = File::Spec->splitpath($self->{'filename'});\n\n    $self->_initialize_io('-file'=>$self->{'filename'});\n    $self->{'o_trim'} = Bio::Tools::Alignment::Trim->new(-verbose => $self->verbose());\n    $self->set_forward_designator($DEFAULTS{'f_designator'});\n    $self->set_reverse_designator($DEFAULTS{'r_designator'});\n\n    $self->_read_file();\n    return $self;\n}\n\n=head2 set_verbose()\n\n Title   : set_verbose()\n Usage   : $o_consed->set_verbose(1);\n Function: Set the verbosity level for debugging messages. On instantiation\n\t   of the Bio::Tools::Alignment::Consed object the verbosity level\n           is set to 0 (quiet).\n Returns : 1 or 0.\n Args    : The verbosity levels are:\n\t      0 - quiet\n\t      1 - noisy\n\t      2 - noisier\n\t      3 - annoyingly noisy\n\nThis method for setting verbosity has largely been superseeded by a\nsub-by-sub way, where for every sub you can provide a (-verbose)\nswitch. I am doing converting this bit-by-bit so do not be surprised\nif some subs do not honour this.\n\n\n# from RootI\n\n# backwards compat\nsub set_verbose { (shift)->verbose(@_) }\n\n=head2 get_filename()\n\n Title   : get_filename()\n Usage   : $o_consed->get_filename();\n Function: Returns the name of the acefile being used by the\n\t   Bio::Tools::Alignment::Consed object.\n Returns : A scalar containing the name of a file.\n Args    : None.\n\n\n\nsub get_filename {\n    my $self = shift;\n    return $self->{'filename'};\n}\n\n=head2 count_sequences_with_grep()\n\n Title   : count_sequences_with_grep()\n Usage   : $o_consed->count_sequences_with_grep();\n Function: Use /bin/grep to scan through the files in the ace project dir\n\t   and count sequences in those files. I used this method in the\n\t   development of this module to verify that I was getting all of the\n\t   sequences. It works, but it is (I think) unix-like platform\n\t   dependent.\n Returns : A scalar containing the number of sequences in the ace project\n\t   directory.\n Args    : None.\n\nIf you are on a non-UNIX platform, you really do not have to use\nthis. It is more of a debugging routine designed to address very\nspecific problems.\n\nThis method was reimplemented to be platform independent with a pure\nperl implementation.  The above note can be ignored.\n\n\nsub count_sequences_with_grep {\n    my $self = shift;\n    my ($working_dir,$grep_cli,@total_grep_sequences);\n    # this should be migrated to a pure perl implementation ala\n    # Tom Christiansen's 'tcgrep'\n    # http://www.cpan.org/modules/by-authors/id/TOMC/scripts/tcgrep.gz\n\n    open(my $FILE, $self->{'filename'}) or do { $self->warn(\"cannot open file \".$self->{'filename'}. \" for grepping\"); return}; \n    my $counter =0;\n    while(<$FILE>) { $counter++ if(/^AF/); }\n\n    close $FILE;\n    opendir(my $SINGLETS,$self->{'path'});\n    foreach my $f ( readdir($SINGLETS) ) {\n\tnext unless ($f =~ /\\.singlets$/); \n\topen(my $FILE, File::Spec->catfile($self->{'path'},$f)) or do{ $self->warn(\"cannot open file \".File::Spec->catfile($self->{'path'},$f)); next };\n\twhile(<$FILE>) { $counter++ if(/^>/) }\n\tclose $FILE;\n    }\n    return $counter;\n}\n\n=head2 get_path()\n\n Title   : get_path()\n Usage   : $o_consed->get_path();\n Function: Returns the path to the acefile this object is working with.\n Returns : Scalar. The path to the working acefile.\n Args    : None.\n\n\nsub get_path {\n    my $self = shift;\n    return $self->{'path'};\n}\n\n=head2 get_contigs()\n\n Title   : get_contigs()\n Usage   : $o_consed->get_contigs();\n Function: Return the keys to the Bio::Tools::Alignment::Consed object.\n Returns : An array containing the keynames in the\n           Bio::Tools::Alignment::Consed object.\n Args    : None.\n\nThis would normally be used to get the keynames for some sort of\niterator. These keys are worthless in general day-to-day use because\nin the Consed acefile they are simply Contig1, Contig2, ...\n\n\nsub get_contigs {\n    my ($self,$contig) = @_;\n    my @contigs = sort keys %{$self->{'contigs'}};\n    return @contigs;\n}\n\n=head2 get_class($contig_keyname)\n\n Title   : get_class($contig_keyname)\n Usage   : $o_consed->get_class($contig_keyname);\n Function: Return the class name for this contig\n Returns : A scalar representing the class of this contig.\n Args    : None.\n Notes   : \n\n\nsub get_class {\n    my ($self,$contig) = @_;\n    return $self->{contigs}->{$contig}->{class};\n}\n\n=head2 get_quality_array($contig_keyname)\n\n Title   : get_quality_array($contig_keyname)\n Usage   : $o_consed->get_quality_array($contig_keyname);\n Function: Returns the quality for the consensus sequence for the given\n\t   contig as an array. See get_quality_scalar to get this as a scalar.\n Returns : An array containing the quality for the consensus sequence with\n\t   the given keyname.\n Args    : The keyname of a contig. Note: This is a keyname. The key would\n\t   normally come from get_contigs.\n\nReturns an array, not a reference. Is this a bug? I<thinking> No.\nWell, maybe.  Why was this developed like this? I was using FreezeThaw\nfor object persistence, and when it froze out these arrays it took a\nlong time to thaw it. Much better as a scalar.\n\nSee L<get_quality_scalar()|get_quality_scalar>\n\n\nsub get_quality_array {\n    my ($self,$contig) = @_;\n    return split ' ', $self->{contigs}->{$contig}->{quality};\n}\n\n=head2 get_quality_scalar($contig_keyname)\n\n Title   : get_quality_scalar($contig_keyname)\n Usage   : $o_consed->get_quality_scalar($contig_keyname);\n Function: Returns the quality for the consensus sequence for the given\n\t   contig as a scalar. See get_quality_array to get this as an array.\n Returns : An scalar containing the quality for the consensus sequence with\n           the given keyname.\n Args    : The keyname of a contig. Note this is a _keyname_. The key would\n\t   normally come from get_contigs.\n\nWhy was this developed like this? I was using FreezeThaw for object\npersistence, and when it froze out these arrays it took a coon's age\nto thaw it. Much better as a scalar.\n\nSee L<get_quality_array()|get_quality_array>\n\n\n#'\nsub get_quality_scalar {\n    my ($self,$contig) = @_;\n    return $self->{'contigs'}->{$contig}->{'quality'};\n}\n\n=head2 freeze_hash()\n\n Title   : freeze_hash()\n Usage   : $o_consed->freeze_hash();\n\n Function: Use Ilya's FreezeThaw module to create a persistent data\n\t   object for this Bio::Tools::Alignment::Consed data\n\t   structure. In the case of AAFC, we use\n\t   Bio::Tools::Alignment::Consed to pre-process bunches of\n\t   sequences, freeze the structures, and send in a harvesting\n\t   robot later to do database stuff.\n Returns : 0 or 1;\n Args    : None.\n\nThis procedure was removed so Consed.pm won't require FreezeThaw.\n\n\n#'\nsub freeze_hash {\n    my $self = shift;\n    $self->warn(\"This method (freeze_hash) was removed \".\n                \"from the bioperl consed.pm. Sorry.\\n\");\n    if (1==2) {\n        $self->debug(\"Bio::Tools::Alignment::Consed::freeze_hash:\".\n                     \" \\$self->{path} is $self->{path}\\n\");\n        my $filename = $self->{'path'}.\"frozen\";\n        my %contigs = %{$self->{'contigs'}};\n        my $frozen = freeze(%contigs);\n        umask 0001;\n        open (my $FREEZE,\">$filename\") or do {\n            $self->warn( \"Bio::Tools::Alignment::Consed could not \".\n                         \"freeze the contig hash because the file \".\n                         \"($filename) could not be opened: $!\\n\");\n            return 1;\n        };\n        print $FREEZE $frozen;\n        return 0;\n    }\n}\n\n=head2 get_members($contig_keyname)\n\n Title   : get_members($contig_keyname)\n Usage   : $o_consed->get_members($contig_keyname);\n Function: Return the _names_ of the reads in this contig.\n Returns : An array containing the names of the reads in this contig.\n Args    : The keyname of a contig. Note this is a keyname. The keyname\n\t   would normally come from get_contigs.\n\nSee L<get_contigs()|get_contigs>\n\n\nsub get_members {\n    my ($self,$contig) = @_;\n    if (!$contig) {\n\t$self->warn(\"You need to provide the name of a contig to \".\n                    \"use Bio::Tools::Alignment::Consed::get_members!\\n\");\n\treturn;\n    }\n    return @{$self->{'contigs'}->{$contig}->{'member_array'}};\n}\n\n=head2 get_members_by_name($some_arbitrary_name)\n\n Title   : get_members_by_name($some_arbitrary_name)\n Usage   : $o_consed->get_members_by_name($some_arbitrary_name);\n Function: Return the names of the reads in a contig. This is the name given\n\t   to $contig{key} based on what is in the contig. This is different\n\t   from the keys retrieved through get_contigs().\n Returns : An array containing the names of the reads in the contig with this\n\t   name.\n Args    : The name of a contig. Not a key, but a name.\n\nHighly inefficient. use some other method if possible.\nSee L<get_contigs()|get_contigs>\n\n\nsub get_members_by_name {\n    my ($self,$name) = @_;\n    # build a list to try to screen for redundancy\n    my @contigs_with_that_name;\n    foreach my $currkey ( sort keys %{$self->{'contigs'}} ) {\n\tnext if (!$self->{'contigs'}->{$currkey}->{'name'});\n\tif ($self->{'contigs'}->{$currkey}->{'name'} eq \"$name\") {\n\t    push @contigs_with_that_name,$currkey;\n\t}\n    }\n    my $count = @contigs_with_that_name;\n    if ($count == 1) {\n\tmy $contig_num = $contigs_with_that_name[0];\n\treturn @{$self->{'contigs'}->{$contig_num}->{'member_array'}};\n    }\n}\n\n=head2 get_contig_number_by_name($some_arbitrary_name)\n\n Title   : get_contig_number_by_name($some_arbitrary_name)\n Usage   : $o_consed->get_contig_number_by_name($some_arbitrary_name);\n Function: Return the names of the reads in a contig. This is the name given\n\t   to $contig{key} based on what is in the contig. This is different\n\t   from the keys retrieved through get_contigs().\n Returns : An array containing the names of the reads in the contig with this\n\t   name.\n Args    : The name of a contig. Not a key, but a name.\n\nSee L<get_contigs()|get_contigs>\n\n\nsub get_contig_number_by_name {\n    my ($self,$name) = @_;\n    foreach my $currkey (sort keys %{$self->{'contigs'}}) {\n\tif ($self->{'contigs'}->{$currkey}->{'name'} && \n\t    $self->{'contigs'}->{$currkey}->{'name'} eq \"$name\") {\n\t    return $currkey;\n\t}\n    }\n}\t\n\n=head2 get_sequence($contig_keyname)\n\n Title   : get_sequence($contig_keyname)\n Usage   : $o_consed->get_sequence($contig_keyname); \n Function: Returns the consensus sequence for a given contig.\n Returns : A scalar containing a sequence.\n Args    : The keyname of a contig. Note this is a key. The key would\n\t   normally come from get_contigs.\n\nSee L<get_contigs()|get_contigs>\n\n\nsub get_sequence {\n    my ($self,$contig) = @_;\n    return $self->{'contigs'}->{$contig}->{'consensus'};\n}\n\n=head2 set_final_sequence($some_sequence)\n\n Title   : set_final_sequence($name,$some_sequence)\n Usage   : $o_consed->set_final_sequence($name,$some_sequence);\n Function: Provides a manual way to set the sequence for a given key in the\n\t   contig hash. Rarely used.\n Returns : 0 or 1;\n Args    : The name (not the keyname) of a contig and an arbitrary string.\n\nA method with a questionable and somewhat mysterious origin. May raise\nthe dead or something like that.\n\n\nsub set_final_sequence {\n    my ($self,$name,$sequence) = @_;\n    if (!$self->{'contigs'}->{$name}) {\n\t$self->warn(\"You cannot set the final sequence for \".\n                    \"$name because it doesn't exist!\\n\");\n\treturn 1;\n    }\n    else {\n\t$self->{'contigs'}->{$name}->{'final_sequence'} = $sequence;\n    }\n    return 0;\n}\n\n=head2  _read_file()\n\n Title   : _read_file();\n Usage   : _read_file();\n Function: An internal subroutine used to read in an acefile and parse it\n\t   into a Bio::Tools::Alignment::Consed object.\n Returns : 0 or 1.\n Args    : Nothing.\n\nThis routine creates and saves the filhandle for reading the files in\n{fh}\n\n\nsub _read_file {\n    my ($self) = @_;\n    my ($line,$in_contig,$in_quality,$contig_number,$top);\n    # make it easier to type $fhl\n    while (defined($line=$self->_readline()) ) {\n\tchomp $line;\n\t# check if there is anything on this line\n\t# if not, you can stop gathering consensus sequence\n\tif (!$line) {\n\t    # if the line is blank you are no longer to gather consensus \n\t    # sequence or quality values\n\t    $in_contig = 0;\n\t    $in_quality = 0;\n\t}\n\t# you are currently gathering consensus sequence\n\telsif ($in_contig) {\n\t    if ($in_contig == 1) {\n\t\t$self->debug(\"Adding $line to consensus of contig number $contig_number.\\n\");\n\t\t$self->{'contigs'}->{$contig_number}->{'consensus'} .= $line;\n\t    }\n\t}\n\telsif ($in_quality) {\n\t    if (!$line) {\n\t\t$in_quality = undef;\n\t    }\n\t    else {\n\n\t\t# I wrote this in here because acefiles produced by\n\t\t# cap3 do not have a leading space like the acefiles\n\t\t# produced by phrap and there is the potential to have\n\t\t# concatenated quality values like this: 2020 rather\n\t\t# then 20 20 whre lines collide. Thanks Andrew for\n\t\t# noticing.\n\n\t\tif ($self->{'contigs'}->{$contig_number}->{'quality'} &&\n                    !($self->{'contigs'}->{$contig_number}->{'quality'} =~ m/\\ $/)) {\n\t\t    $self->{'contigs'}->{$contig_number}->{'quality'} .= \" \";\n\t\t}\n\t\t$self->{'contigs'}->{$contig_number}->{'quality'} .= $line;\n\t    }\n\t}\n\telsif ($line =~ /^BQ/) {\n\t    $in_quality = 1;\n\t}\n\n\t# the line /^CO/ like this:\n\t# CO Contig1 796 1 1 U\n\t# can be broken down as follows:\n\t# CO - Contig!\n\t# Contig1 - the name of this contig\n\t# 796 - Number of bases in this contig\n\t# 1 - Number of reads in this contig\n\t# 1 - number of base segments in this contig\n\t# U - Uncomplemented\n\n\telsif ($line =~ /^CO/) {\n\t    $line =~ m/^CO\\ Contig(\\d+)\\ \\d+\\ \\d+\\ \\d+\\ (\\w)/;\n\t    $contig_number = $1;\n\t    if ($2 eq \"C\") {\n\t\t$self->debug(\"Contig $contig_number is complemented!\\n\");\n\t    }\n\t    $self->{'contigs'}->{$contig_number}->{'member_array'} = [];\n\t    $self->{'contigs'}->{$contig_number}->{'contig_direction'} = \"$2\";\n\t    $in_contig = 1;\n\t}\n\n\t# 000713\n\t# this BS is deprecated, I think.\n\t# haha, I am really witty. <ew>\n\n\telsif ($line =~ /^BSDEPRECATED/) {\n\t    $line =~ m/^BS\\s+\\d+\\s+\\d+\\s+(.+)/;\n\t    my $member = $1;\n\t    $self->{'contigs'}->{$contig_number}->{$member}++;\n\t}\n\t# the members of the contigs are determined by the AF line in the ace file\n\telsif ($line =~ /^AF/) {\n\t    $self->debug(\"I see an AF line here.\\n\");\n\t    $line =~ /^AF\\ (\\S+)\\ (\\w)\\ (\\S+)/;\n\n            # push the name of the current read onto the member array for this contig\n\t    push @{$self->{'contigs'}->{$contig_number}->{'member_array'}},$1;\n\n            # the first read in the contig will be named the \"top\" read\n\t    if (!$top) {\n\t\t$self->debug(\"\\$top is not set.\\n\");\n\t\tif ($self->{'contigs'}->{$contig_number}->{'contig_direction'} eq \"C\") {\n\t\t    $self->debug(\"Reversing the order of the reads. The bottom will be $1\\n\");\n\n\t\t    # if the contig sequence is marked as the\n\t\t    # complement, the top becomes the bottom and$\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_name'} = $1;\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_complement'} = $2;\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_start'} = $3;\n\t\t}\n\t\telse {\n\t\t    $self->debug(\"NOT reversing the order of the reads. \".\n                                 \"The top_name will be $1\\n\");\n\t\t    # if the contig sequence is marked as the\n\t\t    # complement, the top becomes the bottom and$\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_name'} = $1;\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_complement'} = $2;\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_start'} = $3;\n\t\t}\n\t\t$top = 1;\n\t    }\n\t    else {\n\n\t\t# if the contig sequence is marked as the complement,\n\t\t# the top becomes the bottom and the bottom becomes\n\t\t# the top\n\t\tif ($self->{'contigs'}->{$contig_number}->{'contig_direction'} eq \"C\") {\n\t\t    $self->debug(\"Reversing the order of the reads. The top will be $1\\n\");\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_name'} = $1;\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_complement'} = $2;\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_start'} = $3;\n\t\t}\n\t\telse {\n\t\t    $self->debug(\"NOT reversing the order of the reads. The bottom will be $1\\n\");\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_name'} = $1;\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_complement'} = $2;\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_start'} = $3;\n\t\t}\n\t\t$top = undef;\n\t    }\n\t}\n    }\n    return 0;\n}\n\n=head2 set_reverse_designator($some_string)\n\n Title   : set_reverse_designator($some_string)\n Usage   : $o_consed->set_reverse_designator($some_string);\n Function: Set the designator for the reverse read of contigs in this\n\t   Bio::Tools::Alignment::Consed object. Used to determine if\n           contigs containing two reads can be named.\n Returns : The value of $o_consed->{reverse_designator} so you can check\n\t   to see that it was set properly.\n Args    : An arbitrary string.\n\nMay be useful only to me. I<shrug>\n\n\nsub set_reverse_designator {\n    my ($self,$reverse_designator) = @_;\n    $self->{'reverse_designator'} = $reverse_designator;\n    $self->{'o_trim'}->set_reverse_designator($reverse_designator);\n    return $self->{'reverse_designator'};\n}\t\t\t\t# end set_reverse_designator\n\n=head2 set_forward_designator($some_string)\n\n Title   : set_forward_designator($some_string)\n Usage   : $o_consed->set_forward_designator($some_string);\n Function: Set the designator for the forward read of contigs in this\n\t   Bio::Tools::Alignment::Consed object. Used to determine if\n           contigs containing two reads can be named.\n Returns : The value of $o_consed->{forward_designator} so you can check\n\t   to see that it was set properly.\n Args    : An arbitrary string.\n\nMay be useful only to me. I<shrug>\n\n\nsub set_forward_designator {\n    my ($self,$forward_designator) = @_;\n    $self->{'forward_designator'} = $forward_designator;\n    $self->{'o_trim'}->set_forward_designator($forward_designator);\n    return $self->{'forward_designator'};\n}\t\t\t\t# end set_forward_designator\n\n=head2 set_designator_ignore_case(\"yes\")\n\n Title   : set_designator_ignore_case(\"yes\")\n Usage   : $o_consed->set_designator_ignore_case(\"yes\");\n Function: Deprecated.\n Returns : Deprecated.\n Args    : Deprecated.\n\nDeprecated. Really. Trust me.\n\n\nsub set_designator_ignore_case {\n    my ($self,$ignore_case) = @_;\n    if ($ignore_case eq \"yes\") {\n\t$self->{'designator_ignore_case'} = 1;\n    }\n    return $self->{'designator_ignore_case'};\n}\t\t\t\t# end set_designator_ignore_case\n\n=head2 set_trim_points_singlets_and_singletons()\n\n Title   : set_trim_points_singlets_and_singletons()\n Usage   : $o_consed->set_trim_points_singlets_and_singletons();\n Function: Set the trim points for singlets and singletons based on\n\t   quality.  Uses the Bio::Tools::Alignment::Trim object. Use\n\t   at your own risk because the Bio::Tools::Alignment::Trim\n\t   object was designed specifically for me and is mysterious\n\t   in its ways. Every time somebody other then me uses it a\n\t   swarm of locusts decends on a small Central American\n\t   village so do not say you weren't warned.\n Returns : Nothing.\n Args    : None.\n\nWorking on exceptions and warnings here.\n\nSee L<Bio::Tools::Alignment::Trim> for more information\n\n\n#' to make my emacs happy\n\nsub set_trim_points_singlets_and_singletons {\n    my ($self) = @_;\n    $self->debug(\"Consed.pm : \\$self is $self\\n\");\n    my (@points,$trimmed_sequence);\n    if (!$self->{'doublets_set'}) {\n        $self->debug(\"You need to set the doublets before you use \".\n                     \"set_trim_points_singlets_and_doublets. Doing that now.\");\n\t$self->set_doublets();\n    }\n    foreach (sort keys %{$self->{'contigs'}}) {\n\tif ($self->{'contigs'}->{$_}->{'class'} eq \"singlet\") {\n\t    $self->debug(\"Singlet $_\\n\");\n\t    # this is what Warehouse wants\n\t    #         my ($self,$sequence,$quality,$name) = @_;\n\t    # this is what Bio::Tools::Alignment::Trim::trim_singlet wants:\n\t    # my ($self,$sequence,$quality,$name,$class) = @_;\n\t    # the following several lines are to make the parameter passing legible.\n\t    my ($sequence,$quality,$name,$class);\n\t    $sequence = $self->{'contigs'}->{$_}->{'consensus'};\n\t    if (!$self->{'contigs'}->{$_}->{'quality'}) { $quality = \"unset\"; }\n\t    else { $quality = $self->{'contigs'}->{$_}->{'quality'}; }\n\t    $name = $self->{'contigs'}->{$_}->{'name'};\n\t    $class = $self->{'contigs'}->{$_}->{'class'};\n\t    @points = @{$self->{'o_trim'}->trim_singlet($sequence,$quality,$name,$class)};\n\t    $self->{'contigs'}->{$_}->{'start_point'} = $points[0];\n\t    $self->{'contigs'}->{$_}->{'end_point'} = $points[1];\n\t    $self->{'contigs'}->{$_}->{'sequence_trimmed'} = \n                substr($self->{contigs}->{$_}->{'consensus'},$points[0],$points[1]-$points[0]);\n\t}\n    }\n    $self->debug(\"Bio::Tools::Alignment::Consed::set_trim_points_singlets\".\n                 \"_and_singletons: Done setting the quality trimpoints.\\n\");\n    return;\n}  # end set_trim_points_singlet\n\n=head2 set_trim_points_doublets()\n\n Title   : set_trim_points_doublets()\n Usage   : $o_consed->set_trim_points_doublets();\n Function: Set the trim points for doublets based on quality. Uses the\n\t   Bio::Tools::Alignment::Trim object. Use at your own risk because\n           the Bio::Tools::Alignment::Trim object was designed specifically\n           for me and is mysterious in its ways. Every time somebody other\n           then me uses it you risk a biblical plague being loosed on your\n           city.\n Returns : Nothing.\n Args    : None.\n Notes   : Working on exceptions here.\n\nSee L<Bio::Tools::Alignment::Trim> for more information\n\n\nsub set_trim_points_doublets {\n    my $self = shift;\n    my @points;\n    $self->debug(\"Bio::Tools::Alignment::Consed::set_trim_points_doublets:\".\n                 \" Restoring zeros for doublets.\\n\");\n    # &show_missing_sequence($self);\n    $self->debug(\"Bio::Tools::Alignment::Consed::set_trim_points_doublets:\".\n                 \" Setting doublet trim points.\\n\");\n    foreach (sort keys %{$self->{'contigs'}}) {\n\tif ($self->{'contigs'}->{$_}->{'class'} eq \"doublet\") {\n            # my ($self,$sequence,$quality,$name,$class) = @_;\n            my @quals = split(' ',$self->{'contigs'}->{$_}->{'quality'});\n\n\t    @points = $self->{o_trim}->trim_doublet\n                ($self->{'contigs'}->{$_}->{'consensus'},\n                 $self->{'contigs'}->{$_}->{'quality'},\n                 $self->{'contigs'}->{$_}->{name},\n                 $self->{'contigs'}->{$_}->{'class'});\n\t    $self->{'contigs'}->{$_}->{'start_point'} = $points[0];\n\t    $self->{'contigs'}->{$_}->{'end_point'} = $points[1];\n            # now set this\n\t    $self->{'contigs'}->{$_}->{'sequence_trimmed'} =\n                substr($self->{contigs}->{$_}->{'consensus'},\n                       $points[0],$points[1]-$points[0]);\n\t    # 010102 the deprecated way to do things:\n\t}\n    }\n    $self->debug(\"Bio::Tools::Alignment::Consed::set_trim_points_doublets:\".\n                 \" Done setting doublet trim points.\\n\"); \n    return;\n} # end set_trim_points_doublets\n\n=head2 get_trimmed_sequence_by_name($name)\n\n Title   : get_trimmed_sequence_by_name($name)\n Usage   : $o_consed->get_trimmed_sequence_by_name($name);\n Function: Returns the trimmed_sequence of a contig with {name} eq $name.\n Returns : A scalar- the trimmed sequence.\n Args    : The {name} of a contig.\n Notes   : ","parameters":[{"label":"$self"},{"label":"$name"}],"label":"get_trimmed_sequence_by_name($self,$name)"},"detail":"($self,$name)","definition":"sub","containerName":"main::","children":[{"kind":13,"line":850,"containerName":"get_trimmed_sequence_by_name","name":"$self","definition":"my","localvar":"my"},{"name":"$name","containerName":"get_trimmed_sequence_by_name","kind":13,"line":850},{"line":851,"kind":13,"localvar":"my","name":"$trimmed_sequence","definition":"my","containerName":"get_trimmed_sequence_by_name"},{"kind":13,"line":852,"containerName":"get_trimmed_sequence_by_name","name":"$contigname","definition":"my","localvar":"my"},{"containerName":"get_trimmed_sequence_by_name","name":"$self","kind":13,"line":852},{"kind":13,"line":852,"containerName":"get_trimmed_sequence_by_name","name":"$name"},{"line":853,"kind":13,"localvar":"my","name":"$class","definition":"my","containerName":"get_trimmed_sequence_by_name"},{"containerName":"get_trimmed_sequence_by_name","name":"$self","line":853,"kind":13},{"kind":13,"line":853,"containerName":"get_trimmed_sequence_by_name","name":"$contigname"},{"name":"$self","containerName":"get_trimmed_sequence_by_name","kind":13,"line":861},{"name":"$contigname","containerName":"get_trimmed_sequence_by_name","kind":13,"line":861}],"line":849,"kind":12},{"signature":{"label":"set_dash_present_in_sequence_name($self,$dash_present)","documentation":"1;\n# $Id: Consed.pm 16123 2009-09-17 12:57:27Z cjfields $\n# Bio::Tools::Alignment::Consed\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chad Matsalla\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Alignment::Consed - A module to work with objects from consed .ace files\n\n=head1 SYNOPSIS\n\n  # a report for sequencing stuff\n  my $o_consed = Bio::Tools::Alignment::Consed->new( \n      -acefile => \"/path/to/an/acefile.ace.1\",\n      -verbose => 1);\n  my $foo = $o_consed->set_reverse_designator(\"r\");\n  my $bar = $o_consed->set_forward_designator(\"f\");\n\n  # get the contig numbers\n  my @keys = $o_consed->get_contigs();\n\n  # construct the doublets\n  my $setter_doublets = $o_consed->choose_doublets();\n\n  # get the doublets\n  my @doublets = $o_consed->get_doublets();\n\n=head1 DESCRIPTION\n\nL<Bio::Tools::Alignment::Consed> provides methods and objects to deal\nwith the output from the Consed software suite. Specifically,\ntakes an C<.ace> file and provides objects for the results.\n\nA word about doublets: This module was written to accomodate a large\nEST sequencing operation. In this case, EST's were sequenced from the\n3' and from the 5' end of the EST. The objective was to find a\nconsensus sequence for these two reads.  Thus, a contig of two is what\nwe wanted, and this contig should consist of the forward and reverse\nreads of a getn clone. For example, for a forward designator of \"F\"\nand a reverse designator of \"R\", if the two reads chad1F and chad1R\nwere in a single contig (for example Contig 5) it will be determined\nthat the consensus sequence for Contig 5 will be the sequence for\nclone chad1.\n\nDoublets are good!\n\nThis module parses C<.ace> and related files. A detailed list of methods\ncan be found at the end of this document.\n\nI wrote a detailed rationale for design that may explain the reasons\nwhy some things were done the way they were done. That document is\nbeyond the scope of this pod and can probably be found in the\ndirectory from which this module was 'made' or at\nL<http://www.dieselwurks.com/bioinformatics/consedpm_documentation.pdf>.\n\nNote that the POD in that document might be old but the original\nrationale still stands.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nEmail chad-at-dieselwurks.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n#' \n\npackage Bio::Tools::Alignment::Consed;\n\nuse strict;\n\nuse FileHandle;\nuse Dumpvalue qw(dumpValue);\nuse Bio::Tools::Alignment::Trim;\nuse File::Spec;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\nour %DEFAULTS = ( 'f_designator' => 'f',\n\t\t  'r_designator' => 'r');\n\n=head2 new()\n\n Title   : new(-acefile => $path_to_some_acefile, -verbose => \"1\")\n Usage   : $o_consed = Bio::Tools::Alignment::Consed->\n              new(-acefile => $path_to_some_acefile, -verbose => \"1\");\n Function: Construct the Bio::Tools::Alignment::Consed object. Sets\n\t   verbosity for the following procedures, if necessary:\n\t   1. Construct a new Bio::Tools::Alignment::Trim object, to\n\t   handle quality trimming 2. Read in the acefile and parse it\n\n Returns : A reference to a Bio::Tools::Alignment::Consed object.\n Args    : A hash. (-acefile) is the filename of an acefile. If a full path\n\t   is not specified \"./\" is prepended to the filename and used from\n\t   instantiation until destruction. If you want \n           Bio::Tools::Alignment::Consed to be noisy during parsing of\n           the acefile, specify some value for (-verbose).\n\n\nsub new {\n    my ($class,%args) = @_;\n    my $self = $class->SUPER::new(%args);\n\n    $self->{'filename'} = $args{'-acefile'};\n\n    # this is special to UNIX and should probably use catfile : DONE!\n#    if (!($self->{'filename'} =~ m{/})) { \n#\t$self->{'filename'} = \"./\".$self->{'filename'}; \n#    } \n#    $self->{'filename'} =~ m/(.*\\/)(.*)ace.*$/;\n#    $self->{'path'} = $1;\n\n    # this is more generic and should work on most systems   \n    (undef, $self->{'path'}, undef) = File::Spec->splitpath($self->{'filename'});\n\n    $self->_initialize_io('-file'=>$self->{'filename'});\n    $self->{'o_trim'} = Bio::Tools::Alignment::Trim->new(-verbose => $self->verbose());\n    $self->set_forward_designator($DEFAULTS{'f_designator'});\n    $self->set_reverse_designator($DEFAULTS{'r_designator'});\n\n    $self->_read_file();\n    return $self;\n}\n\n=head2 set_verbose()\n\n Title   : set_verbose()\n Usage   : $o_consed->set_verbose(1);\n Function: Set the verbosity level for debugging messages. On instantiation\n\t   of the Bio::Tools::Alignment::Consed object the verbosity level\n           is set to 0 (quiet).\n Returns : 1 or 0.\n Args    : The verbosity levels are:\n\t      0 - quiet\n\t      1 - noisy\n\t      2 - noisier\n\t      3 - annoyingly noisy\n\nThis method for setting verbosity has largely been superseeded by a\nsub-by-sub way, where for every sub you can provide a (-verbose)\nswitch. I am doing converting this bit-by-bit so do not be surprised\nif some subs do not honour this.\n\n\n# from RootI\n\n# backwards compat\nsub set_verbose { (shift)->verbose(@_) }\n\n=head2 get_filename()\n\n Title   : get_filename()\n Usage   : $o_consed->get_filename();\n Function: Returns the name of the acefile being used by the\n\t   Bio::Tools::Alignment::Consed object.\n Returns : A scalar containing the name of a file.\n Args    : None.\n\n\n\nsub get_filename {\n    my $self = shift;\n    return $self->{'filename'};\n}\n\n=head2 count_sequences_with_grep()\n\n Title   : count_sequences_with_grep()\n Usage   : $o_consed->count_sequences_with_grep();\n Function: Use /bin/grep to scan through the files in the ace project dir\n\t   and count sequences in those files. I used this method in the\n\t   development of this module to verify that I was getting all of the\n\t   sequences. It works, but it is (I think) unix-like platform\n\t   dependent.\n Returns : A scalar containing the number of sequences in the ace project\n\t   directory.\n Args    : None.\n\nIf you are on a non-UNIX platform, you really do not have to use\nthis. It is more of a debugging routine designed to address very\nspecific problems.\n\nThis method was reimplemented to be platform independent with a pure\nperl implementation.  The above note can be ignored.\n\n\nsub count_sequences_with_grep {\n    my $self = shift;\n    my ($working_dir,$grep_cli,@total_grep_sequences);\n    # this should be migrated to a pure perl implementation ala\n    # Tom Christiansen's 'tcgrep'\n    # http://www.cpan.org/modules/by-authors/id/TOMC/scripts/tcgrep.gz\n\n    open(my $FILE, $self->{'filename'}) or do { $self->warn(\"cannot open file \".$self->{'filename'}. \" for grepping\"); return}; \n    my $counter =0;\n    while(<$FILE>) { $counter++ if(/^AF/); }\n\n    close $FILE;\n    opendir(my $SINGLETS,$self->{'path'});\n    foreach my $f ( readdir($SINGLETS) ) {\n\tnext unless ($f =~ /\\.singlets$/); \n\topen(my $FILE, File::Spec->catfile($self->{'path'},$f)) or do{ $self->warn(\"cannot open file \".File::Spec->catfile($self->{'path'},$f)); next };\n\twhile(<$FILE>) { $counter++ if(/^>/) }\n\tclose $FILE;\n    }\n    return $counter;\n}\n\n=head2 get_path()\n\n Title   : get_path()\n Usage   : $o_consed->get_path();\n Function: Returns the path to the acefile this object is working with.\n Returns : Scalar. The path to the working acefile.\n Args    : None.\n\n\nsub get_path {\n    my $self = shift;\n    return $self->{'path'};\n}\n\n=head2 get_contigs()\n\n Title   : get_contigs()\n Usage   : $o_consed->get_contigs();\n Function: Return the keys to the Bio::Tools::Alignment::Consed object.\n Returns : An array containing the keynames in the\n           Bio::Tools::Alignment::Consed object.\n Args    : None.\n\nThis would normally be used to get the keynames for some sort of\niterator. These keys are worthless in general day-to-day use because\nin the Consed acefile they are simply Contig1, Contig2, ...\n\n\nsub get_contigs {\n    my ($self,$contig) = @_;\n    my @contigs = sort keys %{$self->{'contigs'}};\n    return @contigs;\n}\n\n=head2 get_class($contig_keyname)\n\n Title   : get_class($contig_keyname)\n Usage   : $o_consed->get_class($contig_keyname);\n Function: Return the class name for this contig\n Returns : A scalar representing the class of this contig.\n Args    : None.\n Notes   : \n\n\nsub get_class {\n    my ($self,$contig) = @_;\n    return $self->{contigs}->{$contig}->{class};\n}\n\n=head2 get_quality_array($contig_keyname)\n\n Title   : get_quality_array($contig_keyname)\n Usage   : $o_consed->get_quality_array($contig_keyname);\n Function: Returns the quality for the consensus sequence for the given\n\t   contig as an array. See get_quality_scalar to get this as a scalar.\n Returns : An array containing the quality for the consensus sequence with\n\t   the given keyname.\n Args    : The keyname of a contig. Note: This is a keyname. The key would\n\t   normally come from get_contigs.\n\nReturns an array, not a reference. Is this a bug? I<thinking> No.\nWell, maybe.  Why was this developed like this? I was using FreezeThaw\nfor object persistence, and when it froze out these arrays it took a\nlong time to thaw it. Much better as a scalar.\n\nSee L<get_quality_scalar()|get_quality_scalar>\n\n\nsub get_quality_array {\n    my ($self,$contig) = @_;\n    return split ' ', $self->{contigs}->{$contig}->{quality};\n}\n\n=head2 get_quality_scalar($contig_keyname)\n\n Title   : get_quality_scalar($contig_keyname)\n Usage   : $o_consed->get_quality_scalar($contig_keyname);\n Function: Returns the quality for the consensus sequence for the given\n\t   contig as a scalar. See get_quality_array to get this as an array.\n Returns : An scalar containing the quality for the consensus sequence with\n           the given keyname.\n Args    : The keyname of a contig. Note this is a _keyname_. The key would\n\t   normally come from get_contigs.\n\nWhy was this developed like this? I was using FreezeThaw for object\npersistence, and when it froze out these arrays it took a coon's age\nto thaw it. Much better as a scalar.\n\nSee L<get_quality_array()|get_quality_array>\n\n\n#'\nsub get_quality_scalar {\n    my ($self,$contig) = @_;\n    return $self->{'contigs'}->{$contig}->{'quality'};\n}\n\n=head2 freeze_hash()\n\n Title   : freeze_hash()\n Usage   : $o_consed->freeze_hash();\n\n Function: Use Ilya's FreezeThaw module to create a persistent data\n\t   object for this Bio::Tools::Alignment::Consed data\n\t   structure. In the case of AAFC, we use\n\t   Bio::Tools::Alignment::Consed to pre-process bunches of\n\t   sequences, freeze the structures, and send in a harvesting\n\t   robot later to do database stuff.\n Returns : 0 or 1;\n Args    : None.\n\nThis procedure was removed so Consed.pm won't require FreezeThaw.\n\n\n#'\nsub freeze_hash {\n    my $self = shift;\n    $self->warn(\"This method (freeze_hash) was removed \".\n                \"from the bioperl consed.pm. Sorry.\\n\");\n    if (1==2) {\n        $self->debug(\"Bio::Tools::Alignment::Consed::freeze_hash:\".\n                     \" \\$self->{path} is $self->{path}\\n\");\n        my $filename = $self->{'path'}.\"frozen\";\n        my %contigs = %{$self->{'contigs'}};\n        my $frozen = freeze(%contigs);\n        umask 0001;\n        open (my $FREEZE,\">$filename\") or do {\n            $self->warn( \"Bio::Tools::Alignment::Consed could not \".\n                         \"freeze the contig hash because the file \".\n                         \"($filename) could not be opened: $!\\n\");\n            return 1;\n        };\n        print $FREEZE $frozen;\n        return 0;\n    }\n}\n\n=head2 get_members($contig_keyname)\n\n Title   : get_members($contig_keyname)\n Usage   : $o_consed->get_members($contig_keyname);\n Function: Return the _names_ of the reads in this contig.\n Returns : An array containing the names of the reads in this contig.\n Args    : The keyname of a contig. Note this is a keyname. The keyname\n\t   would normally come from get_contigs.\n\nSee L<get_contigs()|get_contigs>\n\n\nsub get_members {\n    my ($self,$contig) = @_;\n    if (!$contig) {\n\t$self->warn(\"You need to provide the name of a contig to \".\n                    \"use Bio::Tools::Alignment::Consed::get_members!\\n\");\n\treturn;\n    }\n    return @{$self->{'contigs'}->{$contig}->{'member_array'}};\n}\n\n=head2 get_members_by_name($some_arbitrary_name)\n\n Title   : get_members_by_name($some_arbitrary_name)\n Usage   : $o_consed->get_members_by_name($some_arbitrary_name);\n Function: Return the names of the reads in a contig. This is the name given\n\t   to $contig{key} based on what is in the contig. This is different\n\t   from the keys retrieved through get_contigs().\n Returns : An array containing the names of the reads in the contig with this\n\t   name.\n Args    : The name of a contig. Not a key, but a name.\n\nHighly inefficient. use some other method if possible.\nSee L<get_contigs()|get_contigs>\n\n\nsub get_members_by_name {\n    my ($self,$name) = @_;\n    # build a list to try to screen for redundancy\n    my @contigs_with_that_name;\n    foreach my $currkey ( sort keys %{$self->{'contigs'}} ) {\n\tnext if (!$self->{'contigs'}->{$currkey}->{'name'});\n\tif ($self->{'contigs'}->{$currkey}->{'name'} eq \"$name\") {\n\t    push @contigs_with_that_name,$currkey;\n\t}\n    }\n    my $count = @contigs_with_that_name;\n    if ($count == 1) {\n\tmy $contig_num = $contigs_with_that_name[0];\n\treturn @{$self->{'contigs'}->{$contig_num}->{'member_array'}};\n    }\n}\n\n=head2 get_contig_number_by_name($some_arbitrary_name)\n\n Title   : get_contig_number_by_name($some_arbitrary_name)\n Usage   : $o_consed->get_contig_number_by_name($some_arbitrary_name);\n Function: Return the names of the reads in a contig. This is the name given\n\t   to $contig{key} based on what is in the contig. This is different\n\t   from the keys retrieved through get_contigs().\n Returns : An array containing the names of the reads in the contig with this\n\t   name.\n Args    : The name of a contig. Not a key, but a name.\n\nSee L<get_contigs()|get_contigs>\n\n\nsub get_contig_number_by_name {\n    my ($self,$name) = @_;\n    foreach my $currkey (sort keys %{$self->{'contigs'}}) {\n\tif ($self->{'contigs'}->{$currkey}->{'name'} && \n\t    $self->{'contigs'}->{$currkey}->{'name'} eq \"$name\") {\n\t    return $currkey;\n\t}\n    }\n}\t\n\n=head2 get_sequence($contig_keyname)\n\n Title   : get_sequence($contig_keyname)\n Usage   : $o_consed->get_sequence($contig_keyname); \n Function: Returns the consensus sequence for a given contig.\n Returns : A scalar containing a sequence.\n Args    : The keyname of a contig. Note this is a key. The key would\n\t   normally come from get_contigs.\n\nSee L<get_contigs()|get_contigs>\n\n\nsub get_sequence {\n    my ($self,$contig) = @_;\n    return $self->{'contigs'}->{$contig}->{'consensus'};\n}\n\n=head2 set_final_sequence($some_sequence)\n\n Title   : set_final_sequence($name,$some_sequence)\n Usage   : $o_consed->set_final_sequence($name,$some_sequence);\n Function: Provides a manual way to set the sequence for a given key in the\n\t   contig hash. Rarely used.\n Returns : 0 or 1;\n Args    : The name (not the keyname) of a contig and an arbitrary string.\n\nA method with a questionable and somewhat mysterious origin. May raise\nthe dead or something like that.\n\n\nsub set_final_sequence {\n    my ($self,$name,$sequence) = @_;\n    if (!$self->{'contigs'}->{$name}) {\n\t$self->warn(\"You cannot set the final sequence for \".\n                    \"$name because it doesn't exist!\\n\");\n\treturn 1;\n    }\n    else {\n\t$self->{'contigs'}->{$name}->{'final_sequence'} = $sequence;\n    }\n    return 0;\n}\n\n=head2  _read_file()\n\n Title   : _read_file();\n Usage   : _read_file();\n Function: An internal subroutine used to read in an acefile and parse it\n\t   into a Bio::Tools::Alignment::Consed object.\n Returns : 0 or 1.\n Args    : Nothing.\n\nThis routine creates and saves the filhandle for reading the files in\n{fh}\n\n\nsub _read_file {\n    my ($self) = @_;\n    my ($line,$in_contig,$in_quality,$contig_number,$top);\n    # make it easier to type $fhl\n    while (defined($line=$self->_readline()) ) {\n\tchomp $line;\n\t# check if there is anything on this line\n\t# if not, you can stop gathering consensus sequence\n\tif (!$line) {\n\t    # if the line is blank you are no longer to gather consensus \n\t    # sequence or quality values\n\t    $in_contig = 0;\n\t    $in_quality = 0;\n\t}\n\t# you are currently gathering consensus sequence\n\telsif ($in_contig) {\n\t    if ($in_contig == 1) {\n\t\t$self->debug(\"Adding $line to consensus of contig number $contig_number.\\n\");\n\t\t$self->{'contigs'}->{$contig_number}->{'consensus'} .= $line;\n\t    }\n\t}\n\telsif ($in_quality) {\n\t    if (!$line) {\n\t\t$in_quality = undef;\n\t    }\n\t    else {\n\n\t\t# I wrote this in here because acefiles produced by\n\t\t# cap3 do not have a leading space like the acefiles\n\t\t# produced by phrap and there is the potential to have\n\t\t# concatenated quality values like this: 2020 rather\n\t\t# then 20 20 whre lines collide. Thanks Andrew for\n\t\t# noticing.\n\n\t\tif ($self->{'contigs'}->{$contig_number}->{'quality'} &&\n                    !($self->{'contigs'}->{$contig_number}->{'quality'} =~ m/\\ $/)) {\n\t\t    $self->{'contigs'}->{$contig_number}->{'quality'} .= \" \";\n\t\t}\n\t\t$self->{'contigs'}->{$contig_number}->{'quality'} .= $line;\n\t    }\n\t}\n\telsif ($line =~ /^BQ/) {\n\t    $in_quality = 1;\n\t}\n\n\t# the line /^CO/ like this:\n\t# CO Contig1 796 1 1 U\n\t# can be broken down as follows:\n\t# CO - Contig!\n\t# Contig1 - the name of this contig\n\t# 796 - Number of bases in this contig\n\t# 1 - Number of reads in this contig\n\t# 1 - number of base segments in this contig\n\t# U - Uncomplemented\n\n\telsif ($line =~ /^CO/) {\n\t    $line =~ m/^CO\\ Contig(\\d+)\\ \\d+\\ \\d+\\ \\d+\\ (\\w)/;\n\t    $contig_number = $1;\n\t    if ($2 eq \"C\") {\n\t\t$self->debug(\"Contig $contig_number is complemented!\\n\");\n\t    }\n\t    $self->{'contigs'}->{$contig_number}->{'member_array'} = [];\n\t    $self->{'contigs'}->{$contig_number}->{'contig_direction'} = \"$2\";\n\t    $in_contig = 1;\n\t}\n\n\t# 000713\n\t# this BS is deprecated, I think.\n\t# haha, I am really witty. <ew>\n\n\telsif ($line =~ /^BSDEPRECATED/) {\n\t    $line =~ m/^BS\\s+\\d+\\s+\\d+\\s+(.+)/;\n\t    my $member = $1;\n\t    $self->{'contigs'}->{$contig_number}->{$member}++;\n\t}\n\t# the members of the contigs are determined by the AF line in the ace file\n\telsif ($line =~ /^AF/) {\n\t    $self->debug(\"I see an AF line here.\\n\");\n\t    $line =~ /^AF\\ (\\S+)\\ (\\w)\\ (\\S+)/;\n\n            # push the name of the current read onto the member array for this contig\n\t    push @{$self->{'contigs'}->{$contig_number}->{'member_array'}},$1;\n\n            # the first read in the contig will be named the \"top\" read\n\t    if (!$top) {\n\t\t$self->debug(\"\\$top is not set.\\n\");\n\t\tif ($self->{'contigs'}->{$contig_number}->{'contig_direction'} eq \"C\") {\n\t\t    $self->debug(\"Reversing the order of the reads. The bottom will be $1\\n\");\n\n\t\t    # if the contig sequence is marked as the\n\t\t    # complement, the top becomes the bottom and$\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_name'} = $1;\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_complement'} = $2;\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_start'} = $3;\n\t\t}\n\t\telse {\n\t\t    $self->debug(\"NOT reversing the order of the reads. \".\n                                 \"The top_name will be $1\\n\");\n\t\t    # if the contig sequence is marked as the\n\t\t    # complement, the top becomes the bottom and$\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_name'} = $1;\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_complement'} = $2;\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_start'} = $3;\n\t\t}\n\t\t$top = 1;\n\t    }\n\t    else {\n\n\t\t# if the contig sequence is marked as the complement,\n\t\t# the top becomes the bottom and the bottom becomes\n\t\t# the top\n\t\tif ($self->{'contigs'}->{$contig_number}->{'contig_direction'} eq \"C\") {\n\t\t    $self->debug(\"Reversing the order of the reads. The top will be $1\\n\");\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_name'} = $1;\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_complement'} = $2;\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_start'} = $3;\n\t\t}\n\t\telse {\n\t\t    $self->debug(\"NOT reversing the order of the reads. The bottom will be $1\\n\");\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_name'} = $1;\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_complement'} = $2;\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_start'} = $3;\n\t\t}\n\t\t$top = undef;\n\t    }\n\t}\n    }\n    return 0;\n}\n\n=head2 set_reverse_designator($some_string)\n\n Title   : set_reverse_designator($some_string)\n Usage   : $o_consed->set_reverse_designator($some_string);\n Function: Set the designator for the reverse read of contigs in this\n\t   Bio::Tools::Alignment::Consed object. Used to determine if\n           contigs containing two reads can be named.\n Returns : The value of $o_consed->{reverse_designator} so you can check\n\t   to see that it was set properly.\n Args    : An arbitrary string.\n\nMay be useful only to me. I<shrug>\n\n\nsub set_reverse_designator {\n    my ($self,$reverse_designator) = @_;\n    $self->{'reverse_designator'} = $reverse_designator;\n    $self->{'o_trim'}->set_reverse_designator($reverse_designator);\n    return $self->{'reverse_designator'};\n}\t\t\t\t# end set_reverse_designator\n\n=head2 set_forward_designator($some_string)\n\n Title   : set_forward_designator($some_string)\n Usage   : $o_consed->set_forward_designator($some_string);\n Function: Set the designator for the forward read of contigs in this\n\t   Bio::Tools::Alignment::Consed object. Used to determine if\n           contigs containing two reads can be named.\n Returns : The value of $o_consed->{forward_designator} so you can check\n\t   to see that it was set properly.\n Args    : An arbitrary string.\n\nMay be useful only to me. I<shrug>\n\n\nsub set_forward_designator {\n    my ($self,$forward_designator) = @_;\n    $self->{'forward_designator'} = $forward_designator;\n    $self->{'o_trim'}->set_forward_designator($forward_designator);\n    return $self->{'forward_designator'};\n}\t\t\t\t# end set_forward_designator\n\n=head2 set_designator_ignore_case(\"yes\")\n\n Title   : set_designator_ignore_case(\"yes\")\n Usage   : $o_consed->set_designator_ignore_case(\"yes\");\n Function: Deprecated.\n Returns : Deprecated.\n Args    : Deprecated.\n\nDeprecated. Really. Trust me.\n\n\nsub set_designator_ignore_case {\n    my ($self,$ignore_case) = @_;\n    if ($ignore_case eq \"yes\") {\n\t$self->{'designator_ignore_case'} = 1;\n    }\n    return $self->{'designator_ignore_case'};\n}\t\t\t\t# end set_designator_ignore_case\n\n=head2 set_trim_points_singlets_and_singletons()\n\n Title   : set_trim_points_singlets_and_singletons()\n Usage   : $o_consed->set_trim_points_singlets_and_singletons();\n Function: Set the trim points for singlets and singletons based on\n\t   quality.  Uses the Bio::Tools::Alignment::Trim object. Use\n\t   at your own risk because the Bio::Tools::Alignment::Trim\n\t   object was designed specifically for me and is mysterious\n\t   in its ways. Every time somebody other then me uses it a\n\t   swarm of locusts decends on a small Central American\n\t   village so do not say you weren't warned.\n Returns : Nothing.\n Args    : None.\n\nWorking on exceptions and warnings here.\n\nSee L<Bio::Tools::Alignment::Trim> for more information\n\n\n#' to make my emacs happy\n\nsub set_trim_points_singlets_and_singletons {\n    my ($self) = @_;\n    $self->debug(\"Consed.pm : \\$self is $self\\n\");\n    my (@points,$trimmed_sequence);\n    if (!$self->{'doublets_set'}) {\n        $self->debug(\"You need to set the doublets before you use \".\n                     \"set_trim_points_singlets_and_doublets. Doing that now.\");\n\t$self->set_doublets();\n    }\n    foreach (sort keys %{$self->{'contigs'}}) {\n\tif ($self->{'contigs'}->{$_}->{'class'} eq \"singlet\") {\n\t    $self->debug(\"Singlet $_\\n\");\n\t    # this is what Warehouse wants\n\t    #         my ($self,$sequence,$quality,$name) = @_;\n\t    # this is what Bio::Tools::Alignment::Trim::trim_singlet wants:\n\t    # my ($self,$sequence,$quality,$name,$class) = @_;\n\t    # the following several lines are to make the parameter passing legible.\n\t    my ($sequence,$quality,$name,$class);\n\t    $sequence = $self->{'contigs'}->{$_}->{'consensus'};\n\t    if (!$self->{'contigs'}->{$_}->{'quality'}) { $quality = \"unset\"; }\n\t    else { $quality = $self->{'contigs'}->{$_}->{'quality'}; }\n\t    $name = $self->{'contigs'}->{$_}->{'name'};\n\t    $class = $self->{'contigs'}->{$_}->{'class'};\n\t    @points = @{$self->{'o_trim'}->trim_singlet($sequence,$quality,$name,$class)};\n\t    $self->{'contigs'}->{$_}->{'start_point'} = $points[0];\n\t    $self->{'contigs'}->{$_}->{'end_point'} = $points[1];\n\t    $self->{'contigs'}->{$_}->{'sequence_trimmed'} = \n                substr($self->{contigs}->{$_}->{'consensus'},$points[0],$points[1]-$points[0]);\n\t}\n    }\n    $self->debug(\"Bio::Tools::Alignment::Consed::set_trim_points_singlets\".\n                 \"_and_singletons: Done setting the quality trimpoints.\\n\");\n    return;\n}  # end set_trim_points_singlet\n\n=head2 set_trim_points_doublets()\n\n Title   : set_trim_points_doublets()\n Usage   : $o_consed->set_trim_points_doublets();\n Function: Set the trim points for doublets based on quality. Uses the\n\t   Bio::Tools::Alignment::Trim object. Use at your own risk because\n           the Bio::Tools::Alignment::Trim object was designed specifically\n           for me and is mysterious in its ways. Every time somebody other\n           then me uses it you risk a biblical plague being loosed on your\n           city.\n Returns : Nothing.\n Args    : None.\n Notes   : Working on exceptions here.\n\nSee L<Bio::Tools::Alignment::Trim> for more information\n\n\nsub set_trim_points_doublets {\n    my $self = shift;\n    my @points;\n    $self->debug(\"Bio::Tools::Alignment::Consed::set_trim_points_doublets:\".\n                 \" Restoring zeros for doublets.\\n\");\n    # &show_missing_sequence($self);\n    $self->debug(\"Bio::Tools::Alignment::Consed::set_trim_points_doublets:\".\n                 \" Setting doublet trim points.\\n\");\n    foreach (sort keys %{$self->{'contigs'}}) {\n\tif ($self->{'contigs'}->{$_}->{'class'} eq \"doublet\") {\n            # my ($self,$sequence,$quality,$name,$class) = @_;\n            my @quals = split(' ',$self->{'contigs'}->{$_}->{'quality'});\n\n\t    @points = $self->{o_trim}->trim_doublet\n                ($self->{'contigs'}->{$_}->{'consensus'},\n                 $self->{'contigs'}->{$_}->{'quality'},\n                 $self->{'contigs'}->{$_}->{name},\n                 $self->{'contigs'}->{$_}->{'class'});\n\t    $self->{'contigs'}->{$_}->{'start_point'} = $points[0];\n\t    $self->{'contigs'}->{$_}->{'end_point'} = $points[1];\n            # now set this\n\t    $self->{'contigs'}->{$_}->{'sequence_trimmed'} =\n                substr($self->{contigs}->{$_}->{'consensus'},\n                       $points[0],$points[1]-$points[0]);\n\t    # 010102 the deprecated way to do things:\n\t}\n    }\n    $self->debug(\"Bio::Tools::Alignment::Consed::set_trim_points_doublets:\".\n                 \" Done setting doublet trim points.\\n\"); \n    return;\n} # end set_trim_points_doublets\n\n=head2 get_trimmed_sequence_by_name($name)\n\n Title   : get_trimmed_sequence_by_name($name)\n Usage   : $o_consed->get_trimmed_sequence_by_name($name);\n Function: Returns the trimmed_sequence of a contig with {name} eq $name.\n Returns : A scalar- the trimmed sequence.\n Args    : The {name} of a contig.\n Notes   : \n\n\nsub get_trimmed_sequence_by_name {\n    my ($self,$name) = @_;\n    my $trimmed_sequence;\n    my $contigname = &get_contig_number_by_name($self,$name);\n    my $class = $self->{'contigs'}->{$contigname}->{'class'};\n    # what is this business and who was smoking crack while writing this?\n    # if ($class eq \"singlet\") {\n    # send the sequence, the quality, and the name\n    # $trimmed_sequence = $self->{o_trim}->trim_singlet\n    #  ($self->{'contigs'}->{$contigname}->{consensus},\n    #   $self->{'contigs'}->{$contigname}->{'quality'},$name);\n    # }\n    return $self->{'contigs'}->{$contigname}->{'sequence_trimmed'};\n}\n\n=head2 set_dash_present_in_sequence_name(\"yes\")\n\n Title   : set_dash_present_in_sequence_name(\"yes\")\n Usage   : $o_consed->set_dash_present_in_sequence_name(\"yes\");\n Function: Deprecated. Part of an uncompleted thought. (\"Oooh! Shiny!\")\n Returns : Nothing.\n Args    : \"yes\" to set {dash_present_in_sequence_name} to 1\n Notes   : ","parameters":[{"label":"$self"},{"label":"$dash_present"}]},"detail":"($self,$dash_present)","definition":"sub","containerName":"main::","children":[{"localvar":"my","name":"$self","definition":"my","containerName":"set_dash_present_in_sequence_name","line":876,"kind":13},{"line":876,"kind":13,"name":"$dash_present","containerName":"set_dash_present_in_sequence_name"},{"line":877,"kind":13,"name":"$dash_present","containerName":"set_dash_present_in_sequence_name"},{"kind":13,"line":878,"name":"$self","containerName":"set_dash_present_in_sequence_name"},{"line":881,"kind":13,"name":"$self","containerName":"set_dash_present_in_sequence_name"},{"kind":13,"line":883,"name":"$self","containerName":"set_dash_present_in_sequence_name"}],"line":875,"kind":12,"range":{"end":{"line":884,"character":9999},"start":{"line":875,"character":0}},"name":"set_dash_present_in_sequence_name"},{"range":{"start":{"line":906,"character":0},"end":{"line":912,"character":9999}},"name":"set_doublets","line":906,"children":[{"localvar":"my","containerName":"set_doublets","definition":"my","name":"$self","line":907,"kind":13},{"name":"$self","containerName":"set_doublets","kind":13,"line":910},{"name":"set_designators","containerName":"set_doublets","kind":12,"line":910},{"name":"$self","containerName":"set_doublets","kind":13,"line":910},{"name":"$self","containerName":"set_doublets","line":911,"kind":13},{"localvar":"my","name":"$key_contig","definition":"my","containerName":"set_doublets","line":912,"kind":13},{"kind":13,"line":912,"name":"$self","containerName":"set_doublets"}],"kind":12,"detail":"($self)","signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Consed.pm 16123 2009-09-17 12:57:27Z cjfields $\n# Bio::Tools::Alignment::Consed\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chad Matsalla\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Alignment::Consed - A module to work with objects from consed .ace files\n\n=head1 SYNOPSIS\n\n  # a report for sequencing stuff\n  my $o_consed = Bio::Tools::Alignment::Consed->new( \n      -acefile => \"/path/to/an/acefile.ace.1\",\n      -verbose => 1);\n  my $foo = $o_consed->set_reverse_designator(\"r\");\n  my $bar = $o_consed->set_forward_designator(\"f\");\n\n  # get the contig numbers\n  my @keys = $o_consed->get_contigs();\n\n  # construct the doublets\n  my $setter_doublets = $o_consed->choose_doublets();\n\n  # get the doublets\n  my @doublets = $o_consed->get_doublets();\n\n=head1 DESCRIPTION\n\nL<Bio::Tools::Alignment::Consed> provides methods and objects to deal\nwith the output from the Consed software suite. Specifically,\ntakes an C<.ace> file and provides objects for the results.\n\nA word about doublets: This module was written to accomodate a large\nEST sequencing operation. In this case, EST's were sequenced from the\n3' and from the 5' end of the EST. The objective was to find a\nconsensus sequence for these two reads.  Thus, a contig of two is what\nwe wanted, and this contig should consist of the forward and reverse\nreads of a getn clone. For example, for a forward designator of \"F\"\nand a reverse designator of \"R\", if the two reads chad1F and chad1R\nwere in a single contig (for example Contig 5) it will be determined\nthat the consensus sequence for Contig 5 will be the sequence for\nclone chad1.\n\nDoublets are good!\n\nThis module parses C<.ace> and related files. A detailed list of methods\ncan be found at the end of this document.\n\nI wrote a detailed rationale for design that may explain the reasons\nwhy some things were done the way they were done. That document is\nbeyond the scope of this pod and can probably be found in the\ndirectory from which this module was 'made' or at\nL<http://www.dieselwurks.com/bioinformatics/consedpm_documentation.pdf>.\n\nNote that the POD in that document might be old but the original\nrationale still stands.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nEmail chad-at-dieselwurks.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n#' \n\npackage Bio::Tools::Alignment::Consed;\n\nuse strict;\n\nuse FileHandle;\nuse Dumpvalue qw(dumpValue);\nuse Bio::Tools::Alignment::Trim;\nuse File::Spec;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\nour %DEFAULTS = ( 'f_designator' => 'f',\n\t\t  'r_designator' => 'r');\n\n=head2 new()\n\n Title   : new(-acefile => $path_to_some_acefile, -verbose => \"1\")\n Usage   : $o_consed = Bio::Tools::Alignment::Consed->\n              new(-acefile => $path_to_some_acefile, -verbose => \"1\");\n Function: Construct the Bio::Tools::Alignment::Consed object. Sets\n\t   verbosity for the following procedures, if necessary:\n\t   1. Construct a new Bio::Tools::Alignment::Trim object, to\n\t   handle quality trimming 2. Read in the acefile and parse it\n\n Returns : A reference to a Bio::Tools::Alignment::Consed object.\n Args    : A hash. (-acefile) is the filename of an acefile. If a full path\n\t   is not specified \"./\" is prepended to the filename and used from\n\t   instantiation until destruction. If you want \n           Bio::Tools::Alignment::Consed to be noisy during parsing of\n           the acefile, specify some value for (-verbose).\n\n\nsub new {\n    my ($class,%args) = @_;\n    my $self = $class->SUPER::new(%args);\n\n    $self->{'filename'} = $args{'-acefile'};\n\n    # this is special to UNIX and should probably use catfile : DONE!\n#    if (!($self->{'filename'} =~ m{/})) { \n#\t$self->{'filename'} = \"./\".$self->{'filename'}; \n#    } \n#    $self->{'filename'} =~ m/(.*\\/)(.*)ace.*$/;\n#    $self->{'path'} = $1;\n\n    # this is more generic and should work on most systems   \n    (undef, $self->{'path'}, undef) = File::Spec->splitpath($self->{'filename'});\n\n    $self->_initialize_io('-file'=>$self->{'filename'});\n    $self->{'o_trim'} = Bio::Tools::Alignment::Trim->new(-verbose => $self->verbose());\n    $self->set_forward_designator($DEFAULTS{'f_designator'});\n    $self->set_reverse_designator($DEFAULTS{'r_designator'});\n\n    $self->_read_file();\n    return $self;\n}\n\n=head2 set_verbose()\n\n Title   : set_verbose()\n Usage   : $o_consed->set_verbose(1);\n Function: Set the verbosity level for debugging messages. On instantiation\n\t   of the Bio::Tools::Alignment::Consed object the verbosity level\n           is set to 0 (quiet).\n Returns : 1 or 0.\n Args    : The verbosity levels are:\n\t      0 - quiet\n\t      1 - noisy\n\t      2 - noisier\n\t      3 - annoyingly noisy\n\nThis method for setting verbosity has largely been superseeded by a\nsub-by-sub way, where for every sub you can provide a (-verbose)\nswitch. I am doing converting this bit-by-bit so do not be surprised\nif some subs do not honour this.\n\n\n# from RootI\n\n# backwards compat\nsub set_verbose { (shift)->verbose(@_) }\n\n=head2 get_filename()\n\n Title   : get_filename()\n Usage   : $o_consed->get_filename();\n Function: Returns the name of the acefile being used by the\n\t   Bio::Tools::Alignment::Consed object.\n Returns : A scalar containing the name of a file.\n Args    : None.\n\n\n\nsub get_filename {\n    my $self = shift;\n    return $self->{'filename'};\n}\n\n=head2 count_sequences_with_grep()\n\n Title   : count_sequences_with_grep()\n Usage   : $o_consed->count_sequences_with_grep();\n Function: Use /bin/grep to scan through the files in the ace project dir\n\t   and count sequences in those files. I used this method in the\n\t   development of this module to verify that I was getting all of the\n\t   sequences. It works, but it is (I think) unix-like platform\n\t   dependent.\n Returns : A scalar containing the number of sequences in the ace project\n\t   directory.\n Args    : None.\n\nIf you are on a non-UNIX platform, you really do not have to use\nthis. It is more of a debugging routine designed to address very\nspecific problems.\n\nThis method was reimplemented to be platform independent with a pure\nperl implementation.  The above note can be ignored.\n\n\nsub count_sequences_with_grep {\n    my $self = shift;\n    my ($working_dir,$grep_cli,@total_grep_sequences);\n    # this should be migrated to a pure perl implementation ala\n    # Tom Christiansen's 'tcgrep'\n    # http://www.cpan.org/modules/by-authors/id/TOMC/scripts/tcgrep.gz\n\n    open(my $FILE, $self->{'filename'}) or do { $self->warn(\"cannot open file \".$self->{'filename'}. \" for grepping\"); return}; \n    my $counter =0;\n    while(<$FILE>) { $counter++ if(/^AF/); }\n\n    close $FILE;\n    opendir(my $SINGLETS,$self->{'path'});\n    foreach my $f ( readdir($SINGLETS) ) {\n\tnext unless ($f =~ /\\.singlets$/); \n\topen(my $FILE, File::Spec->catfile($self->{'path'},$f)) or do{ $self->warn(\"cannot open file \".File::Spec->catfile($self->{'path'},$f)); next };\n\twhile(<$FILE>) { $counter++ if(/^>/) }\n\tclose $FILE;\n    }\n    return $counter;\n}\n\n=head2 get_path()\n\n Title   : get_path()\n Usage   : $o_consed->get_path();\n Function: Returns the path to the acefile this object is working with.\n Returns : Scalar. The path to the working acefile.\n Args    : None.\n\n\nsub get_path {\n    my $self = shift;\n    return $self->{'path'};\n}\n\n=head2 get_contigs()\n\n Title   : get_contigs()\n Usage   : $o_consed->get_contigs();\n Function: Return the keys to the Bio::Tools::Alignment::Consed object.\n Returns : An array containing the keynames in the\n           Bio::Tools::Alignment::Consed object.\n Args    : None.\n\nThis would normally be used to get the keynames for some sort of\niterator. These keys are worthless in general day-to-day use because\nin the Consed acefile they are simply Contig1, Contig2, ...\n\n\nsub get_contigs {\n    my ($self,$contig) = @_;\n    my @contigs = sort keys %{$self->{'contigs'}};\n    return @contigs;\n}\n\n=head2 get_class($contig_keyname)\n\n Title   : get_class($contig_keyname)\n Usage   : $o_consed->get_class($contig_keyname);\n Function: Return the class name for this contig\n Returns : A scalar representing the class of this contig.\n Args    : None.\n Notes   : \n\n\nsub get_class {\n    my ($self,$contig) = @_;\n    return $self->{contigs}->{$contig}->{class};\n}\n\n=head2 get_quality_array($contig_keyname)\n\n Title   : get_quality_array($contig_keyname)\n Usage   : $o_consed->get_quality_array($contig_keyname);\n Function: Returns the quality for the consensus sequence for the given\n\t   contig as an array. See get_quality_scalar to get this as a scalar.\n Returns : An array containing the quality for the consensus sequence with\n\t   the given keyname.\n Args    : The keyname of a contig. Note: This is a keyname. The key would\n\t   normally come from get_contigs.\n\nReturns an array, not a reference. Is this a bug? I<thinking> No.\nWell, maybe.  Why was this developed like this? I was using FreezeThaw\nfor object persistence, and when it froze out these arrays it took a\nlong time to thaw it. Much better as a scalar.\n\nSee L<get_quality_scalar()|get_quality_scalar>\n\n\nsub get_quality_array {\n    my ($self,$contig) = @_;\n    return split ' ', $self->{contigs}->{$contig}->{quality};\n}\n\n=head2 get_quality_scalar($contig_keyname)\n\n Title   : get_quality_scalar($contig_keyname)\n Usage   : $o_consed->get_quality_scalar($contig_keyname);\n Function: Returns the quality for the consensus sequence for the given\n\t   contig as a scalar. See get_quality_array to get this as an array.\n Returns : An scalar containing the quality for the consensus sequence with\n           the given keyname.\n Args    : The keyname of a contig. Note this is a _keyname_. The key would\n\t   normally come from get_contigs.\n\nWhy was this developed like this? I was using FreezeThaw for object\npersistence, and when it froze out these arrays it took a coon's age\nto thaw it. Much better as a scalar.\n\nSee L<get_quality_array()|get_quality_array>\n\n\n#'\nsub get_quality_scalar {\n    my ($self,$contig) = @_;\n    return $self->{'contigs'}->{$contig}->{'quality'};\n}\n\n=head2 freeze_hash()\n\n Title   : freeze_hash()\n Usage   : $o_consed->freeze_hash();\n\n Function: Use Ilya's FreezeThaw module to create a persistent data\n\t   object for this Bio::Tools::Alignment::Consed data\n\t   structure. In the case of AAFC, we use\n\t   Bio::Tools::Alignment::Consed to pre-process bunches of\n\t   sequences, freeze the structures, and send in a harvesting\n\t   robot later to do database stuff.\n Returns : 0 or 1;\n Args    : None.\n\nThis procedure was removed so Consed.pm won't require FreezeThaw.\n\n\n#'\nsub freeze_hash {\n    my $self = shift;\n    $self->warn(\"This method (freeze_hash) was removed \".\n                \"from the bioperl consed.pm. Sorry.\\n\");\n    if (1==2) {\n        $self->debug(\"Bio::Tools::Alignment::Consed::freeze_hash:\".\n                     \" \\$self->{path} is $self->{path}\\n\");\n        my $filename = $self->{'path'}.\"frozen\";\n        my %contigs = %{$self->{'contigs'}};\n        my $frozen = freeze(%contigs);\n        umask 0001;\n        open (my $FREEZE,\">$filename\") or do {\n            $self->warn( \"Bio::Tools::Alignment::Consed could not \".\n                         \"freeze the contig hash because the file \".\n                         \"($filename) could not be opened: $!\\n\");\n            return 1;\n        };\n        print $FREEZE $frozen;\n        return 0;\n    }\n}\n\n=head2 get_members($contig_keyname)\n\n Title   : get_members($contig_keyname)\n Usage   : $o_consed->get_members($contig_keyname);\n Function: Return the _names_ of the reads in this contig.\n Returns : An array containing the names of the reads in this contig.\n Args    : The keyname of a contig. Note this is a keyname. The keyname\n\t   would normally come from get_contigs.\n\nSee L<get_contigs()|get_contigs>\n\n\nsub get_members {\n    my ($self,$contig) = @_;\n    if (!$contig) {\n\t$self->warn(\"You need to provide the name of a contig to \".\n                    \"use Bio::Tools::Alignment::Consed::get_members!\\n\");\n\treturn;\n    }\n    return @{$self->{'contigs'}->{$contig}->{'member_array'}};\n}\n\n=head2 get_members_by_name($some_arbitrary_name)\n\n Title   : get_members_by_name($some_arbitrary_name)\n Usage   : $o_consed->get_members_by_name($some_arbitrary_name);\n Function: Return the names of the reads in a contig. This is the name given\n\t   to $contig{key} based on what is in the contig. This is different\n\t   from the keys retrieved through get_contigs().\n Returns : An array containing the names of the reads in the contig with this\n\t   name.\n Args    : The name of a contig. Not a key, but a name.\n\nHighly inefficient. use some other method if possible.\nSee L<get_contigs()|get_contigs>\n\n\nsub get_members_by_name {\n    my ($self,$name) = @_;\n    # build a list to try to screen for redundancy\n    my @contigs_with_that_name;\n    foreach my $currkey ( sort keys %{$self->{'contigs'}} ) {\n\tnext if (!$self->{'contigs'}->{$currkey}->{'name'});\n\tif ($self->{'contigs'}->{$currkey}->{'name'} eq \"$name\") {\n\t    push @contigs_with_that_name,$currkey;\n\t}\n    }\n    my $count = @contigs_with_that_name;\n    if ($count == 1) {\n\tmy $contig_num = $contigs_with_that_name[0];\n\treturn @{$self->{'contigs'}->{$contig_num}->{'member_array'}};\n    }\n}\n\n=head2 get_contig_number_by_name($some_arbitrary_name)\n\n Title   : get_contig_number_by_name($some_arbitrary_name)\n Usage   : $o_consed->get_contig_number_by_name($some_arbitrary_name);\n Function: Return the names of the reads in a contig. This is the name given\n\t   to $contig{key} based on what is in the contig. This is different\n\t   from the keys retrieved through get_contigs().\n Returns : An array containing the names of the reads in the contig with this\n\t   name.\n Args    : The name of a contig. Not a key, but a name.\n\nSee L<get_contigs()|get_contigs>\n\n\nsub get_contig_number_by_name {\n    my ($self,$name) = @_;\n    foreach my $currkey (sort keys %{$self->{'contigs'}}) {\n\tif ($self->{'contigs'}->{$currkey}->{'name'} && \n\t    $self->{'contigs'}->{$currkey}->{'name'} eq \"$name\") {\n\t    return $currkey;\n\t}\n    }\n}\t\n\n=head2 get_sequence($contig_keyname)\n\n Title   : get_sequence($contig_keyname)\n Usage   : $o_consed->get_sequence($contig_keyname); \n Function: Returns the consensus sequence for a given contig.\n Returns : A scalar containing a sequence.\n Args    : The keyname of a contig. Note this is a key. The key would\n\t   normally come from get_contigs.\n\nSee L<get_contigs()|get_contigs>\n\n\nsub get_sequence {\n    my ($self,$contig) = @_;\n    return $self->{'contigs'}->{$contig}->{'consensus'};\n}\n\n=head2 set_final_sequence($some_sequence)\n\n Title   : set_final_sequence($name,$some_sequence)\n Usage   : $o_consed->set_final_sequence($name,$some_sequence);\n Function: Provides a manual way to set the sequence for a given key in the\n\t   contig hash. Rarely used.\n Returns : 0 or 1;\n Args    : The name (not the keyname) of a contig and an arbitrary string.\n\nA method with a questionable and somewhat mysterious origin. May raise\nthe dead or something like that.\n\n\nsub set_final_sequence {\n    my ($self,$name,$sequence) = @_;\n    if (!$self->{'contigs'}->{$name}) {\n\t$self->warn(\"You cannot set the final sequence for \".\n                    \"$name because it doesn't exist!\\n\");\n\treturn 1;\n    }\n    else {\n\t$self->{'contigs'}->{$name}->{'final_sequence'} = $sequence;\n    }\n    return 0;\n}\n\n=head2  _read_file()\n\n Title   : _read_file();\n Usage   : _read_file();\n Function: An internal subroutine used to read in an acefile and parse it\n\t   into a Bio::Tools::Alignment::Consed object.\n Returns : 0 or 1.\n Args    : Nothing.\n\nThis routine creates and saves the filhandle for reading the files in\n{fh}\n\n\nsub _read_file {\n    my ($self) = @_;\n    my ($line,$in_contig,$in_quality,$contig_number,$top);\n    # make it easier to type $fhl\n    while (defined($line=$self->_readline()) ) {\n\tchomp $line;\n\t# check if there is anything on this line\n\t# if not, you can stop gathering consensus sequence\n\tif (!$line) {\n\t    # if the line is blank you are no longer to gather consensus \n\t    # sequence or quality values\n\t    $in_contig = 0;\n\t    $in_quality = 0;\n\t}\n\t# you are currently gathering consensus sequence\n\telsif ($in_contig) {\n\t    if ($in_contig == 1) {\n\t\t$self->debug(\"Adding $line to consensus of contig number $contig_number.\\n\");\n\t\t$self->{'contigs'}->{$contig_number}->{'consensus'} .= $line;\n\t    }\n\t}\n\telsif ($in_quality) {\n\t    if (!$line) {\n\t\t$in_quality = undef;\n\t    }\n\t    else {\n\n\t\t# I wrote this in here because acefiles produced by\n\t\t# cap3 do not have a leading space like the acefiles\n\t\t# produced by phrap and there is the potential to have\n\t\t# concatenated quality values like this: 2020 rather\n\t\t# then 20 20 whre lines collide. Thanks Andrew for\n\t\t# noticing.\n\n\t\tif ($self->{'contigs'}->{$contig_number}->{'quality'} &&\n                    !($self->{'contigs'}->{$contig_number}->{'quality'} =~ m/\\ $/)) {\n\t\t    $self->{'contigs'}->{$contig_number}->{'quality'} .= \" \";\n\t\t}\n\t\t$self->{'contigs'}->{$contig_number}->{'quality'} .= $line;\n\t    }\n\t}\n\telsif ($line =~ /^BQ/) {\n\t    $in_quality = 1;\n\t}\n\n\t# the line /^CO/ like this:\n\t# CO Contig1 796 1 1 U\n\t# can be broken down as follows:\n\t# CO - Contig!\n\t# Contig1 - the name of this contig\n\t# 796 - Number of bases in this contig\n\t# 1 - Number of reads in this contig\n\t# 1 - number of base segments in this contig\n\t# U - Uncomplemented\n\n\telsif ($line =~ /^CO/) {\n\t    $line =~ m/^CO\\ Contig(\\d+)\\ \\d+\\ \\d+\\ \\d+\\ (\\w)/;\n\t    $contig_number = $1;\n\t    if ($2 eq \"C\") {\n\t\t$self->debug(\"Contig $contig_number is complemented!\\n\");\n\t    }\n\t    $self->{'contigs'}->{$contig_number}->{'member_array'} = [];\n\t    $self->{'contigs'}->{$contig_number}->{'contig_direction'} = \"$2\";\n\t    $in_contig = 1;\n\t}\n\n\t# 000713\n\t# this BS is deprecated, I think.\n\t# haha, I am really witty. <ew>\n\n\telsif ($line =~ /^BSDEPRECATED/) {\n\t    $line =~ m/^BS\\s+\\d+\\s+\\d+\\s+(.+)/;\n\t    my $member = $1;\n\t    $self->{'contigs'}->{$contig_number}->{$member}++;\n\t}\n\t# the members of the contigs are determined by the AF line in the ace file\n\telsif ($line =~ /^AF/) {\n\t    $self->debug(\"I see an AF line here.\\n\");\n\t    $line =~ /^AF\\ (\\S+)\\ (\\w)\\ (\\S+)/;\n\n            # push the name of the current read onto the member array for this contig\n\t    push @{$self->{'contigs'}->{$contig_number}->{'member_array'}},$1;\n\n            # the first read in the contig will be named the \"top\" read\n\t    if (!$top) {\n\t\t$self->debug(\"\\$top is not set.\\n\");\n\t\tif ($self->{'contigs'}->{$contig_number}->{'contig_direction'} eq \"C\") {\n\t\t    $self->debug(\"Reversing the order of the reads. The bottom will be $1\\n\");\n\n\t\t    # if the contig sequence is marked as the\n\t\t    # complement, the top becomes the bottom and$\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_name'} = $1;\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_complement'} = $2;\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_start'} = $3;\n\t\t}\n\t\telse {\n\t\t    $self->debug(\"NOT reversing the order of the reads. \".\n                                 \"The top_name will be $1\\n\");\n\t\t    # if the contig sequence is marked as the\n\t\t    # complement, the top becomes the bottom and$\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_name'} = $1;\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_complement'} = $2;\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_start'} = $3;\n\t\t}\n\t\t$top = 1;\n\t    }\n\t    else {\n\n\t\t# if the contig sequence is marked as the complement,\n\t\t# the top becomes the bottom and the bottom becomes\n\t\t# the top\n\t\tif ($self->{'contigs'}->{$contig_number}->{'contig_direction'} eq \"C\") {\n\t\t    $self->debug(\"Reversing the order of the reads. The top will be $1\\n\");\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_name'} = $1;\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_complement'} = $2;\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_start'} = $3;\n\t\t}\n\t\telse {\n\t\t    $self->debug(\"NOT reversing the order of the reads. The bottom will be $1\\n\");\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_name'} = $1;\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_complement'} = $2;\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_start'} = $3;\n\t\t}\n\t\t$top = undef;\n\t    }\n\t}\n    }\n    return 0;\n}\n\n=head2 set_reverse_designator($some_string)\n\n Title   : set_reverse_designator($some_string)\n Usage   : $o_consed->set_reverse_designator($some_string);\n Function: Set the designator for the reverse read of contigs in this\n\t   Bio::Tools::Alignment::Consed object. Used to determine if\n           contigs containing two reads can be named.\n Returns : The value of $o_consed->{reverse_designator} so you can check\n\t   to see that it was set properly.\n Args    : An arbitrary string.\n\nMay be useful only to me. I<shrug>\n\n\nsub set_reverse_designator {\n    my ($self,$reverse_designator) = @_;\n    $self->{'reverse_designator'} = $reverse_designator;\n    $self->{'o_trim'}->set_reverse_designator($reverse_designator);\n    return $self->{'reverse_designator'};\n}\t\t\t\t# end set_reverse_designator\n\n=head2 set_forward_designator($some_string)\n\n Title   : set_forward_designator($some_string)\n Usage   : $o_consed->set_forward_designator($some_string);\n Function: Set the designator for the forward read of contigs in this\n\t   Bio::Tools::Alignment::Consed object. Used to determine if\n           contigs containing two reads can be named.\n Returns : The value of $o_consed->{forward_designator} so you can check\n\t   to see that it was set properly.\n Args    : An arbitrary string.\n\nMay be useful only to me. I<shrug>\n\n\nsub set_forward_designator {\n    my ($self,$forward_designator) = @_;\n    $self->{'forward_designator'} = $forward_designator;\n    $self->{'o_trim'}->set_forward_designator($forward_designator);\n    return $self->{'forward_designator'};\n}\t\t\t\t# end set_forward_designator\n\n=head2 set_designator_ignore_case(\"yes\")\n\n Title   : set_designator_ignore_case(\"yes\")\n Usage   : $o_consed->set_designator_ignore_case(\"yes\");\n Function: Deprecated.\n Returns : Deprecated.\n Args    : Deprecated.\n\nDeprecated. Really. Trust me.\n\n\nsub set_designator_ignore_case {\n    my ($self,$ignore_case) = @_;\n    if ($ignore_case eq \"yes\") {\n\t$self->{'designator_ignore_case'} = 1;\n    }\n    return $self->{'designator_ignore_case'};\n}\t\t\t\t# end set_designator_ignore_case\n\n=head2 set_trim_points_singlets_and_singletons()\n\n Title   : set_trim_points_singlets_and_singletons()\n Usage   : $o_consed->set_trim_points_singlets_and_singletons();\n Function: Set the trim points for singlets and singletons based on\n\t   quality.  Uses the Bio::Tools::Alignment::Trim object. Use\n\t   at your own risk because the Bio::Tools::Alignment::Trim\n\t   object was designed specifically for me and is mysterious\n\t   in its ways. Every time somebody other then me uses it a\n\t   swarm of locusts decends on a small Central American\n\t   village so do not say you weren't warned.\n Returns : Nothing.\n Args    : None.\n\nWorking on exceptions and warnings here.\n\nSee L<Bio::Tools::Alignment::Trim> for more information\n\n\n#' to make my emacs happy\n\nsub set_trim_points_singlets_and_singletons {\n    my ($self) = @_;\n    $self->debug(\"Consed.pm : \\$self is $self\\n\");\n    my (@points,$trimmed_sequence);\n    if (!$self->{'doublets_set'}) {\n        $self->debug(\"You need to set the doublets before you use \".\n                     \"set_trim_points_singlets_and_doublets. Doing that now.\");\n\t$self->set_doublets();\n    }\n    foreach (sort keys %{$self->{'contigs'}}) {\n\tif ($self->{'contigs'}->{$_}->{'class'} eq \"singlet\") {\n\t    $self->debug(\"Singlet $_\\n\");\n\t    # this is what Warehouse wants\n\t    #         my ($self,$sequence,$quality,$name) = @_;\n\t    # this is what Bio::Tools::Alignment::Trim::trim_singlet wants:\n\t    # my ($self,$sequence,$quality,$name,$class) = @_;\n\t    # the following several lines are to make the parameter passing legible.\n\t    my ($sequence,$quality,$name,$class);\n\t    $sequence = $self->{'contigs'}->{$_}->{'consensus'};\n\t    if (!$self->{'contigs'}->{$_}->{'quality'}) { $quality = \"unset\"; }\n\t    else { $quality = $self->{'contigs'}->{$_}->{'quality'}; }\n\t    $name = $self->{'contigs'}->{$_}->{'name'};\n\t    $class = $self->{'contigs'}->{$_}->{'class'};\n\t    @points = @{$self->{'o_trim'}->trim_singlet($sequence,$quality,$name,$class)};\n\t    $self->{'contigs'}->{$_}->{'start_point'} = $points[0];\n\t    $self->{'contigs'}->{$_}->{'end_point'} = $points[1];\n\t    $self->{'contigs'}->{$_}->{'sequence_trimmed'} = \n                substr($self->{contigs}->{$_}->{'consensus'},$points[0],$points[1]-$points[0]);\n\t}\n    }\n    $self->debug(\"Bio::Tools::Alignment::Consed::set_trim_points_singlets\".\n                 \"_and_singletons: Done setting the quality trimpoints.\\n\");\n    return;\n}  # end set_trim_points_singlet\n\n=head2 set_trim_points_doublets()\n\n Title   : set_trim_points_doublets()\n Usage   : $o_consed->set_trim_points_doublets();\n Function: Set the trim points for doublets based on quality. Uses the\n\t   Bio::Tools::Alignment::Trim object. Use at your own risk because\n           the Bio::Tools::Alignment::Trim object was designed specifically\n           for me and is mysterious in its ways. Every time somebody other\n           then me uses it you risk a biblical plague being loosed on your\n           city.\n Returns : Nothing.\n Args    : None.\n Notes   : Working on exceptions here.\n\nSee L<Bio::Tools::Alignment::Trim> for more information\n\n\nsub set_trim_points_doublets {\n    my $self = shift;\n    my @points;\n    $self->debug(\"Bio::Tools::Alignment::Consed::set_trim_points_doublets:\".\n                 \" Restoring zeros for doublets.\\n\");\n    # &show_missing_sequence($self);\n    $self->debug(\"Bio::Tools::Alignment::Consed::set_trim_points_doublets:\".\n                 \" Setting doublet trim points.\\n\");\n    foreach (sort keys %{$self->{'contigs'}}) {\n\tif ($self->{'contigs'}->{$_}->{'class'} eq \"doublet\") {\n            # my ($self,$sequence,$quality,$name,$class) = @_;\n            my @quals = split(' ',$self->{'contigs'}->{$_}->{'quality'});\n\n\t    @points = $self->{o_trim}->trim_doublet\n                ($self->{'contigs'}->{$_}->{'consensus'},\n                 $self->{'contigs'}->{$_}->{'quality'},\n                 $self->{'contigs'}->{$_}->{name},\n                 $self->{'contigs'}->{$_}->{'class'});\n\t    $self->{'contigs'}->{$_}->{'start_point'} = $points[0];\n\t    $self->{'contigs'}->{$_}->{'end_point'} = $points[1];\n            # now set this\n\t    $self->{'contigs'}->{$_}->{'sequence_trimmed'} =\n                substr($self->{contigs}->{$_}->{'consensus'},\n                       $points[0],$points[1]-$points[0]);\n\t    # 010102 the deprecated way to do things:\n\t}\n    }\n    $self->debug(\"Bio::Tools::Alignment::Consed::set_trim_points_doublets:\".\n                 \" Done setting doublet trim points.\\n\"); \n    return;\n} # end set_trim_points_doublets\n\n=head2 get_trimmed_sequence_by_name($name)\n\n Title   : get_trimmed_sequence_by_name($name)\n Usage   : $o_consed->get_trimmed_sequence_by_name($name);\n Function: Returns the trimmed_sequence of a contig with {name} eq $name.\n Returns : A scalar- the trimmed sequence.\n Args    : The {name} of a contig.\n Notes   : \n\n\nsub get_trimmed_sequence_by_name {\n    my ($self,$name) = @_;\n    my $trimmed_sequence;\n    my $contigname = &get_contig_number_by_name($self,$name);\n    my $class = $self->{'contigs'}->{$contigname}->{'class'};\n    # what is this business and who was smoking crack while writing this?\n    # if ($class eq \"singlet\") {\n    # send the sequence, the quality, and the name\n    # $trimmed_sequence = $self->{o_trim}->trim_singlet\n    #  ($self->{'contigs'}->{$contigname}->{consensus},\n    #   $self->{'contigs'}->{$contigname}->{'quality'},$name);\n    # }\n    return $self->{'contigs'}->{$contigname}->{'sequence_trimmed'};\n}\n\n=head2 set_dash_present_in_sequence_name(\"yes\")\n\n Title   : set_dash_present_in_sequence_name(\"yes\")\n Usage   : $o_consed->set_dash_present_in_sequence_name(\"yes\");\n Function: Deprecated. Part of an uncompleted thought. (\"Oooh! Shiny!\")\n Returns : Nothing.\n Args    : \"yes\" to set {dash_present_in_sequence_name} to 1\n Notes   : \n\n\nsub set_dash_present_in_sequence_name {\n    my ($self,$dash_present) = @_;\n    if ($dash_present eq \"yes\") {\n\t$self->{'dash_present_in_sequence_name'} = 1;\n    }\n    else {\n\t$self->{'dash_present_in_sequence_name'} = 0;\n    }\n    return $self->{'dash_present_in_sequence_name'};\n} # end set_dash_present_in_sequence_name\n\n=head2 set_doublets()\n\n Title   : set_doublets()\n Usage   : $o_consed->set_doublets();\n Function: Find pairs that have similar names and mark them as doublets\n\t   and set the {name}.\n Returns : 0 or 1.\n Args    : None.\n\nA complicated subroutine that iterates over the\nBio::Tools::Alignment::Consed looking for contigs of 2. If the forward\nand reverse designator are removed from each of the reads in\n{'member_array'} and the remaining reads are the same, {name} is set\nto that name and the contig's class is set as \"doublet\".  If any of\nthose cases fail the contig is marked as a \"pair\".\n\n' make my emacs happy","label":"set_doublets($self)"},"containerName":"main::","definition":"sub"},{"name":"%self","containerName":null,"line":916,"kind":13},{"kind":13,"line":916,"name":"%key_contig","containerName":null},{"name":"%self","containerName":null,"line":922,"kind":13},{"line":922,"kind":13,"containerName":null,"name":"%key_contig"},{"line":923,"kind":13,"name":"%self","containerName":null},{"name":"%key_contig","containerName":null,"line":923,"kind":13},{"containerName":null,"name":"$self","line":924,"kind":13},{"kind":12,"line":924,"containerName":"main::","name":"debug"},{"kind":13,"line":925,"name":"$name","definition":"my","containerName":null,"localvar":"my"},{"name":"_get_contig_name","kind":12,"line":925},{"kind":13,"line":925,"containerName":null,"name":"$self"},{"name":"%self","containerName":null,"line":925,"kind":13},{"line":925,"kind":13,"containerName":null,"name":"%key_contig"},{"line":926,"kind":13,"containerName":null,"name":"$self"},{"kind":12,"line":926,"containerName":"main::","name":"debug"},{"line":926,"kind":13,"containerName":null,"name":"$name"},{"name":"%name","containerName":null,"line":927,"kind":13},{"name":"%self","containerName":null,"kind":13,"line":928},{"name":"%key_contig","containerName":null,"kind":13,"line":928},{"name":"$name","containerName":null,"kind":13,"line":928},{"containerName":null,"name":"%self","line":929,"kind":13},{"line":929,"kind":13,"name":"%key_contig","containerName":null},{"kind":13,"line":931,"containerName":null,"name":"$self"},{"line":931,"kind":12,"name":"debug","containerName":"main::"},{"name":"%self","containerName":null,"kind":13,"line":932},{"kind":13,"line":932,"name":"%key_contig","containerName":null},{"name":"%self","containerName":null,"kind":13,"line":937},{"containerName":null,"name":"%key_contig","kind":13,"line":937},{"kind":13,"line":939,"name":"%self","containerName":null},{"name":"%key_contig","containerName":null,"kind":13,"line":939},{"name":"name","kind":12,"line":939},{"line":939,"kind":13,"containerName":null,"name":"%self"},{"kind":13,"line":939,"name":"%key_contig","containerName":null},{"line":941,"kind":13,"name":"%self","containerName":null},{"containerName":null,"name":"%key_contig","kind":13,"line":941},{"line":941,"kind":12,"name":"num_members"},{"containerName":null,"name":"%self","line":945,"kind":13},{"line":945,"kind":13,"containerName":null,"name":"%key_contig"},{"name":"%self","containerName":null,"line":946,"kind":13},{"kind":13,"line":946,"containerName":null,"name":"%key_contig"},{"name":"%self","containerName":null,"line":950,"kind":13},{"kind":13,"line":950,"name":"%key_contig","containerName":null},{"name":"%self","containerName":null,"kind":13,"line":951},{"kind":13,"line":951,"name":"%key_contig","containerName":null},{"containerName":null,"name":"%self","line":951,"kind":13},{"containerName":null,"name":"%key_contig","line":951,"kind":13},{"line":952,"kind":13,"containerName":null,"name":"%self"},{"name":"%key_contig","containerName":null,"kind":13,"line":952},{"line":954,"kind":13,"containerName":null,"name":"%self"},{"containerName":null,"name":"%key_contig","kind":13,"line":954},{"kind":13,"line":954,"containerName":null,"name":"%self"},{"name":"%key_contig","containerName":null,"kind":13,"line":954},{"name":"%self","containerName":null,"line":958,"kind":13},{"name":"set_singlets","range":{"end":{"character":9999,"line":1015},"start":{"line":974,"character":0}},"kind":12,"line":974,"children":[{"kind":13,"line":976,"containerName":"set_singlets","definition":"my","name":"$self","localvar":"my"},{"line":977,"kind":13,"containerName":"set_singlets","name":"$self"},{"containerName":"set_singlets","name":"debug","line":977,"kind":12},{"localvar":"my","name":"$full_filename","definition":"my","containerName":"set_singlets","line":978,"kind":13},{"line":978,"kind":13,"name":"$self","containerName":"set_singlets"},{"containerName":"set_singlets","name":"$self","kind":13,"line":979},{"kind":12,"line":979,"name":"debug","containerName":"set_singlets"},{"containerName":"set_singlets","name":"$full_filename","line":980,"kind":13},{"localvar":"my","containerName":"set_singlets","definition":"my","name":"$base_path","line":981,"kind":13},{"line":981,"kind":13,"containerName":"set_singlets","name":"$filename"},{"containerName":"set_singlets","name":"$self","line":982,"kind":13},{"containerName":"set_singlets","name":"debug","line":982,"kind":12},{"kind":13,"line":983,"name":"$filename","containerName":"set_singlets"},{"name":"$singletsfile","definition":"my","containerName":"set_singlets","localvar":"my","kind":13,"line":984},{"line":984,"kind":13,"name":"$base_path","containerName":"set_singlets"},{"line":985,"kind":13,"containerName":"set_singlets","name":"$self"},{"containerName":"set_singlets","name":"debug","line":985,"kind":12},{"containerName":"set_singlets","name":"$singletsfile","kind":13,"line":986},{"name":"$self","containerName":"set_singlets","kind":13,"line":988},{"line":991,"kind":13,"name":"$self","containerName":"set_singlets"},{"line":991,"kind":12,"containerName":"set_singlets","name":"debug"},{"kind":13,"line":992,"definition":"my","name":"$singlets_fh","containerName":"set_singlets","localvar":"my"},{"kind":12,"line":992,"containerName":"set_singlets","name":"new"},{"name":"$singletsfile","containerName":"set_singlets","kind":13,"line":992},{"name":"$sequence","definition":"my","containerName":"set_singlets","localvar":"my","kind":13,"line":993},{"name":"$name","containerName":"set_singlets","line":993,"kind":13},{"containerName":"set_singlets","name":"$count","line":993,"kind":13},{"containerName":"set_singlets","name":"$singlets_fh","kind":13,"line":994},{"line":994,"kind":12,"containerName":"set_singlets","name":"_readline"},{"line":997,"kind":13,"name":"$name","containerName":"set_singlets"},{"kind":13,"line":997,"containerName":"set_singlets","name":"$sequence"},{"name":"$self","containerName":"set_singlets","kind":13,"line":998},{"containerName":"set_singlets","name":"debug","line":998,"kind":12},{"name":"$self","containerName":"set_singlets","line":999,"kind":13},{"line":999,"kind":13,"containerName":"set_singlets","name":"$name"},{"line":999,"kind":13,"containerName":"set_singlets","name":"$name"},{"kind":13,"line":1000,"name":"$self","containerName":"set_singlets"},{"name":"$name","containerName":"set_singlets","line":1000,"kind":13},{"containerName":"set_singlets","name":"$sequence","kind":13,"line":1000},{"name":"$self","containerName":"set_singlets","line":1001,"kind":13},{"name":"$name","containerName":"set_singlets","line":1001,"kind":13},{"containerName":"set_singlets","name":"$name","kind":13,"line":1001},{"kind":13,"line":1002,"containerName":"set_singlets","name":"$self"},{"containerName":"set_singlets","name":"$name","line":1002,"kind":13},{"name":"$self","containerName":"set_singlets","kind":13,"line":1003},{"containerName":"set_singlets","name":"$name","line":1003,"kind":13},{"containerName":"set_singlets","name":"$sequence","line":1005,"kind":13},{"name":"$name","containerName":"set_singlets","line":1005,"kind":13},{"kind":13,"line":1006,"containerName":"set_singlets","name":"$count"},{"line":1008,"kind":13,"containerName":"set_singlets","name":"$name"},{"containerName":"set_singlets","name":"$name","line":1009,"kind":13},{"line":1011,"kind":13,"containerName":"set_singlets","name":"$name"},{"line":1014,"kind":13,"containerName":"set_singlets","name":"$sequence"}],"containerName":"main::","definition":"sub","detail":"($self)","signature":{"label":"set_singlets($self)","documentation":"1;\n# $Id: Consed.pm 16123 2009-09-17 12:57:27Z cjfields $\n# Bio::Tools::Alignment::Consed\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chad Matsalla\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Alignment::Consed - A module to work with objects from consed .ace files\n\n=head1 SYNOPSIS\n\n  # a report for sequencing stuff\n  my $o_consed = Bio::Tools::Alignment::Consed->new( \n      -acefile => \"/path/to/an/acefile.ace.1\",\n      -verbose => 1);\n  my $foo = $o_consed->set_reverse_designator(\"r\");\n  my $bar = $o_consed->set_forward_designator(\"f\");\n\n  # get the contig numbers\n  my @keys = $o_consed->get_contigs();\n\n  # construct the doublets\n  my $setter_doublets = $o_consed->choose_doublets();\n\n  # get the doublets\n  my @doublets = $o_consed->get_doublets();\n\n=head1 DESCRIPTION\n\nL<Bio::Tools::Alignment::Consed> provides methods and objects to deal\nwith the output from the Consed software suite. Specifically,\ntakes an C<.ace> file and provides objects for the results.\n\nA word about doublets: This module was written to accomodate a large\nEST sequencing operation. In this case, EST's were sequenced from the\n3' and from the 5' end of the EST. The objective was to find a\nconsensus sequence for these two reads.  Thus, a contig of two is what\nwe wanted, and this contig should consist of the forward and reverse\nreads of a getn clone. For example, for a forward designator of \"F\"\nand a reverse designator of \"R\", if the two reads chad1F and chad1R\nwere in a single contig (for example Contig 5) it will be determined\nthat the consensus sequence for Contig 5 will be the sequence for\nclone chad1.\n\nDoublets are good!\n\nThis module parses C<.ace> and related files. A detailed list of methods\ncan be found at the end of this document.\n\nI wrote a detailed rationale for design that may explain the reasons\nwhy some things were done the way they were done. That document is\nbeyond the scope of this pod and can probably be found in the\ndirectory from which this module was 'made' or at\nL<http://www.dieselwurks.com/bioinformatics/consedpm_documentation.pdf>.\n\nNote that the POD in that document might be old but the original\nrationale still stands.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nEmail chad-at-dieselwurks.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n#' \n\npackage Bio::Tools::Alignment::Consed;\n\nuse strict;\n\nuse FileHandle;\nuse Dumpvalue qw(dumpValue);\nuse Bio::Tools::Alignment::Trim;\nuse File::Spec;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\nour %DEFAULTS = ( 'f_designator' => 'f',\n\t\t  'r_designator' => 'r');\n\n=head2 new()\n\n Title   : new(-acefile => $path_to_some_acefile, -verbose => \"1\")\n Usage   : $o_consed = Bio::Tools::Alignment::Consed->\n              new(-acefile => $path_to_some_acefile, -verbose => \"1\");\n Function: Construct the Bio::Tools::Alignment::Consed object. Sets\n\t   verbosity for the following procedures, if necessary:\n\t   1. Construct a new Bio::Tools::Alignment::Trim object, to\n\t   handle quality trimming 2. Read in the acefile and parse it\n\n Returns : A reference to a Bio::Tools::Alignment::Consed object.\n Args    : A hash. (-acefile) is the filename of an acefile. If a full path\n\t   is not specified \"./\" is prepended to the filename and used from\n\t   instantiation until destruction. If you want \n           Bio::Tools::Alignment::Consed to be noisy during parsing of\n           the acefile, specify some value for (-verbose).\n\n\nsub new {\n    my ($class,%args) = @_;\n    my $self = $class->SUPER::new(%args);\n\n    $self->{'filename'} = $args{'-acefile'};\n\n    # this is special to UNIX and should probably use catfile : DONE!\n#    if (!($self->{'filename'} =~ m{/})) { \n#\t$self->{'filename'} = \"./\".$self->{'filename'}; \n#    } \n#    $self->{'filename'} =~ m/(.*\\/)(.*)ace.*$/;\n#    $self->{'path'} = $1;\n\n    # this is more generic and should work on most systems   \n    (undef, $self->{'path'}, undef) = File::Spec->splitpath($self->{'filename'});\n\n    $self->_initialize_io('-file'=>$self->{'filename'});\n    $self->{'o_trim'} = Bio::Tools::Alignment::Trim->new(-verbose => $self->verbose());\n    $self->set_forward_designator($DEFAULTS{'f_designator'});\n    $self->set_reverse_designator($DEFAULTS{'r_designator'});\n\n    $self->_read_file();\n    return $self;\n}\n\n=head2 set_verbose()\n\n Title   : set_verbose()\n Usage   : $o_consed->set_verbose(1);\n Function: Set the verbosity level for debugging messages. On instantiation\n\t   of the Bio::Tools::Alignment::Consed object the verbosity level\n           is set to 0 (quiet).\n Returns : 1 or 0.\n Args    : The verbosity levels are:\n\t      0 - quiet\n\t      1 - noisy\n\t      2 - noisier\n\t      3 - annoyingly noisy\n\nThis method for setting verbosity has largely been superseeded by a\nsub-by-sub way, where for every sub you can provide a (-verbose)\nswitch. I am doing converting this bit-by-bit so do not be surprised\nif some subs do not honour this.\n\n\n# from RootI\n\n# backwards compat\nsub set_verbose { (shift)->verbose(@_) }\n\n=head2 get_filename()\n\n Title   : get_filename()\n Usage   : $o_consed->get_filename();\n Function: Returns the name of the acefile being used by the\n\t   Bio::Tools::Alignment::Consed object.\n Returns : A scalar containing the name of a file.\n Args    : None.\n\n\n\nsub get_filename {\n    my $self = shift;\n    return $self->{'filename'};\n}\n\n=head2 count_sequences_with_grep()\n\n Title   : count_sequences_with_grep()\n Usage   : $o_consed->count_sequences_with_grep();\n Function: Use /bin/grep to scan through the files in the ace project dir\n\t   and count sequences in those files. I used this method in the\n\t   development of this module to verify that I was getting all of the\n\t   sequences. It works, but it is (I think) unix-like platform\n\t   dependent.\n Returns : A scalar containing the number of sequences in the ace project\n\t   directory.\n Args    : None.\n\nIf you are on a non-UNIX platform, you really do not have to use\nthis. It is more of a debugging routine designed to address very\nspecific problems.\n\nThis method was reimplemented to be platform independent with a pure\nperl implementation.  The above note can be ignored.\n\n\nsub count_sequences_with_grep {\n    my $self = shift;\n    my ($working_dir,$grep_cli,@total_grep_sequences);\n    # this should be migrated to a pure perl implementation ala\n    # Tom Christiansen's 'tcgrep'\n    # http://www.cpan.org/modules/by-authors/id/TOMC/scripts/tcgrep.gz\n\n    open(my $FILE, $self->{'filename'}) or do { $self->warn(\"cannot open file \".$self->{'filename'}. \" for grepping\"); return}; \n    my $counter =0;\n    while(<$FILE>) { $counter++ if(/^AF/); }\n\n    close $FILE;\n    opendir(my $SINGLETS,$self->{'path'});\n    foreach my $f ( readdir($SINGLETS) ) {\n\tnext unless ($f =~ /\\.singlets$/); \n\topen(my $FILE, File::Spec->catfile($self->{'path'},$f)) or do{ $self->warn(\"cannot open file \".File::Spec->catfile($self->{'path'},$f)); next };\n\twhile(<$FILE>) { $counter++ if(/^>/) }\n\tclose $FILE;\n    }\n    return $counter;\n}\n\n=head2 get_path()\n\n Title   : get_path()\n Usage   : $o_consed->get_path();\n Function: Returns the path to the acefile this object is working with.\n Returns : Scalar. The path to the working acefile.\n Args    : None.\n\n\nsub get_path {\n    my $self = shift;\n    return $self->{'path'};\n}\n\n=head2 get_contigs()\n\n Title   : get_contigs()\n Usage   : $o_consed->get_contigs();\n Function: Return the keys to the Bio::Tools::Alignment::Consed object.\n Returns : An array containing the keynames in the\n           Bio::Tools::Alignment::Consed object.\n Args    : None.\n\nThis would normally be used to get the keynames for some sort of\niterator. These keys are worthless in general day-to-day use because\nin the Consed acefile they are simply Contig1, Contig2, ...\n\n\nsub get_contigs {\n    my ($self,$contig) = @_;\n    my @contigs = sort keys %{$self->{'contigs'}};\n    return @contigs;\n}\n\n=head2 get_class($contig_keyname)\n\n Title   : get_class($contig_keyname)\n Usage   : $o_consed->get_class($contig_keyname);\n Function: Return the class name for this contig\n Returns : A scalar representing the class of this contig.\n Args    : None.\n Notes   : \n\n\nsub get_class {\n    my ($self,$contig) = @_;\n    return $self->{contigs}->{$contig}->{class};\n}\n\n=head2 get_quality_array($contig_keyname)\n\n Title   : get_quality_array($contig_keyname)\n Usage   : $o_consed->get_quality_array($contig_keyname);\n Function: Returns the quality for the consensus sequence for the given\n\t   contig as an array. See get_quality_scalar to get this as a scalar.\n Returns : An array containing the quality for the consensus sequence with\n\t   the given keyname.\n Args    : The keyname of a contig. Note: This is a keyname. The key would\n\t   normally come from get_contigs.\n\nReturns an array, not a reference. Is this a bug? I<thinking> No.\nWell, maybe.  Why was this developed like this? I was using FreezeThaw\nfor object persistence, and when it froze out these arrays it took a\nlong time to thaw it. Much better as a scalar.\n\nSee L<get_quality_scalar()|get_quality_scalar>\n\n\nsub get_quality_array {\n    my ($self,$contig) = @_;\n    return split ' ', $self->{contigs}->{$contig}->{quality};\n}\n\n=head2 get_quality_scalar($contig_keyname)\n\n Title   : get_quality_scalar($contig_keyname)\n Usage   : $o_consed->get_quality_scalar($contig_keyname);\n Function: Returns the quality for the consensus sequence for the given\n\t   contig as a scalar. See get_quality_array to get this as an array.\n Returns : An scalar containing the quality for the consensus sequence with\n           the given keyname.\n Args    : The keyname of a contig. Note this is a _keyname_. The key would\n\t   normally come from get_contigs.\n\nWhy was this developed like this? I was using FreezeThaw for object\npersistence, and when it froze out these arrays it took a coon's age\nto thaw it. Much better as a scalar.\n\nSee L<get_quality_array()|get_quality_array>\n\n\n#'\nsub get_quality_scalar {\n    my ($self,$contig) = @_;\n    return $self->{'contigs'}->{$contig}->{'quality'};\n}\n\n=head2 freeze_hash()\n\n Title   : freeze_hash()\n Usage   : $o_consed->freeze_hash();\n\n Function: Use Ilya's FreezeThaw module to create a persistent data\n\t   object for this Bio::Tools::Alignment::Consed data\n\t   structure. In the case of AAFC, we use\n\t   Bio::Tools::Alignment::Consed to pre-process bunches of\n\t   sequences, freeze the structures, and send in a harvesting\n\t   robot later to do database stuff.\n Returns : 0 or 1;\n Args    : None.\n\nThis procedure was removed so Consed.pm won't require FreezeThaw.\n\n\n#'\nsub freeze_hash {\n    my $self = shift;\n    $self->warn(\"This method (freeze_hash) was removed \".\n                \"from the bioperl consed.pm. Sorry.\\n\");\n    if (1==2) {\n        $self->debug(\"Bio::Tools::Alignment::Consed::freeze_hash:\".\n                     \" \\$self->{path} is $self->{path}\\n\");\n        my $filename = $self->{'path'}.\"frozen\";\n        my %contigs = %{$self->{'contigs'}};\n        my $frozen = freeze(%contigs);\n        umask 0001;\n        open (my $FREEZE,\">$filename\") or do {\n            $self->warn( \"Bio::Tools::Alignment::Consed could not \".\n                         \"freeze the contig hash because the file \".\n                         \"($filename) could not be opened: $!\\n\");\n            return 1;\n        };\n        print $FREEZE $frozen;\n        return 0;\n    }\n}\n\n=head2 get_members($contig_keyname)\n\n Title   : get_members($contig_keyname)\n Usage   : $o_consed->get_members($contig_keyname);\n Function: Return the _names_ of the reads in this contig.\n Returns : An array containing the names of the reads in this contig.\n Args    : The keyname of a contig. Note this is a keyname. The keyname\n\t   would normally come from get_contigs.\n\nSee L<get_contigs()|get_contigs>\n\n\nsub get_members {\n    my ($self,$contig) = @_;\n    if (!$contig) {\n\t$self->warn(\"You need to provide the name of a contig to \".\n                    \"use Bio::Tools::Alignment::Consed::get_members!\\n\");\n\treturn;\n    }\n    return @{$self->{'contigs'}->{$contig}->{'member_array'}};\n}\n\n=head2 get_members_by_name($some_arbitrary_name)\n\n Title   : get_members_by_name($some_arbitrary_name)\n Usage   : $o_consed->get_members_by_name($some_arbitrary_name);\n Function: Return the names of the reads in a contig. This is the name given\n\t   to $contig{key} based on what is in the contig. This is different\n\t   from the keys retrieved through get_contigs().\n Returns : An array containing the names of the reads in the contig with this\n\t   name.\n Args    : The name of a contig. Not a key, but a name.\n\nHighly inefficient. use some other method if possible.\nSee L<get_contigs()|get_contigs>\n\n\nsub get_members_by_name {\n    my ($self,$name) = @_;\n    # build a list to try to screen for redundancy\n    my @contigs_with_that_name;\n    foreach my $currkey ( sort keys %{$self->{'contigs'}} ) {\n\tnext if (!$self->{'contigs'}->{$currkey}->{'name'});\n\tif ($self->{'contigs'}->{$currkey}->{'name'} eq \"$name\") {\n\t    push @contigs_with_that_name,$currkey;\n\t}\n    }\n    my $count = @contigs_with_that_name;\n    if ($count == 1) {\n\tmy $contig_num = $contigs_with_that_name[0];\n\treturn @{$self->{'contigs'}->{$contig_num}->{'member_array'}};\n    }\n}\n\n=head2 get_contig_number_by_name($some_arbitrary_name)\n\n Title   : get_contig_number_by_name($some_arbitrary_name)\n Usage   : $o_consed->get_contig_number_by_name($some_arbitrary_name);\n Function: Return the names of the reads in a contig. This is the name given\n\t   to $contig{key} based on what is in the contig. This is different\n\t   from the keys retrieved through get_contigs().\n Returns : An array containing the names of the reads in the contig with this\n\t   name.\n Args    : The name of a contig. Not a key, but a name.\n\nSee L<get_contigs()|get_contigs>\n\n\nsub get_contig_number_by_name {\n    my ($self,$name) = @_;\n    foreach my $currkey (sort keys %{$self->{'contigs'}}) {\n\tif ($self->{'contigs'}->{$currkey}->{'name'} && \n\t    $self->{'contigs'}->{$currkey}->{'name'} eq \"$name\") {\n\t    return $currkey;\n\t}\n    }\n}\t\n\n=head2 get_sequence($contig_keyname)\n\n Title   : get_sequence($contig_keyname)\n Usage   : $o_consed->get_sequence($contig_keyname); \n Function: Returns the consensus sequence for a given contig.\n Returns : A scalar containing a sequence.\n Args    : The keyname of a contig. Note this is a key. The key would\n\t   normally come from get_contigs.\n\nSee L<get_contigs()|get_contigs>\n\n\nsub get_sequence {\n    my ($self,$contig) = @_;\n    return $self->{'contigs'}->{$contig}->{'consensus'};\n}\n\n=head2 set_final_sequence($some_sequence)\n\n Title   : set_final_sequence($name,$some_sequence)\n Usage   : $o_consed->set_final_sequence($name,$some_sequence);\n Function: Provides a manual way to set the sequence for a given key in the\n\t   contig hash. Rarely used.\n Returns : 0 or 1;\n Args    : The name (not the keyname) of a contig and an arbitrary string.\n\nA method with a questionable and somewhat mysterious origin. May raise\nthe dead or something like that.\n\n\nsub set_final_sequence {\n    my ($self,$name,$sequence) = @_;\n    if (!$self->{'contigs'}->{$name}) {\n\t$self->warn(\"You cannot set the final sequence for \".\n                    \"$name because it doesn't exist!\\n\");\n\treturn 1;\n    }\n    else {\n\t$self->{'contigs'}->{$name}->{'final_sequence'} = $sequence;\n    }\n    return 0;\n}\n\n=head2  _read_file()\n\n Title   : _read_file();\n Usage   : _read_file();\n Function: An internal subroutine used to read in an acefile and parse it\n\t   into a Bio::Tools::Alignment::Consed object.\n Returns : 0 or 1.\n Args    : Nothing.\n\nThis routine creates and saves the filhandle for reading the files in\n{fh}\n\n\nsub _read_file {\n    my ($self) = @_;\n    my ($line,$in_contig,$in_quality,$contig_number,$top);\n    # make it easier to type $fhl\n    while (defined($line=$self->_readline()) ) {\n\tchomp $line;\n\t# check if there is anything on this line\n\t# if not, you can stop gathering consensus sequence\n\tif (!$line) {\n\t    # if the line is blank you are no longer to gather consensus \n\t    # sequence or quality values\n\t    $in_contig = 0;\n\t    $in_quality = 0;\n\t}\n\t# you are currently gathering consensus sequence\n\telsif ($in_contig) {\n\t    if ($in_contig == 1) {\n\t\t$self->debug(\"Adding $line to consensus of contig number $contig_number.\\n\");\n\t\t$self->{'contigs'}->{$contig_number}->{'consensus'} .= $line;\n\t    }\n\t}\n\telsif ($in_quality) {\n\t    if (!$line) {\n\t\t$in_quality = undef;\n\t    }\n\t    else {\n\n\t\t# I wrote this in here because acefiles produced by\n\t\t# cap3 do not have a leading space like the acefiles\n\t\t# produced by phrap and there is the potential to have\n\t\t# concatenated quality values like this: 2020 rather\n\t\t# then 20 20 whre lines collide. Thanks Andrew for\n\t\t# noticing.\n\n\t\tif ($self->{'contigs'}->{$contig_number}->{'quality'} &&\n                    !($self->{'contigs'}->{$contig_number}->{'quality'} =~ m/\\ $/)) {\n\t\t    $self->{'contigs'}->{$contig_number}->{'quality'} .= \" \";\n\t\t}\n\t\t$self->{'contigs'}->{$contig_number}->{'quality'} .= $line;\n\t    }\n\t}\n\telsif ($line =~ /^BQ/) {\n\t    $in_quality = 1;\n\t}\n\n\t# the line /^CO/ like this:\n\t# CO Contig1 796 1 1 U\n\t# can be broken down as follows:\n\t# CO - Contig!\n\t# Contig1 - the name of this contig\n\t# 796 - Number of bases in this contig\n\t# 1 - Number of reads in this contig\n\t# 1 - number of base segments in this contig\n\t# U - Uncomplemented\n\n\telsif ($line =~ /^CO/) {\n\t    $line =~ m/^CO\\ Contig(\\d+)\\ \\d+\\ \\d+\\ \\d+\\ (\\w)/;\n\t    $contig_number = $1;\n\t    if ($2 eq \"C\") {\n\t\t$self->debug(\"Contig $contig_number is complemented!\\n\");\n\t    }\n\t    $self->{'contigs'}->{$contig_number}->{'member_array'} = [];\n\t    $self->{'contigs'}->{$contig_number}->{'contig_direction'} = \"$2\";\n\t    $in_contig = 1;\n\t}\n\n\t# 000713\n\t# this BS is deprecated, I think.\n\t# haha, I am really witty. <ew>\n\n\telsif ($line =~ /^BSDEPRECATED/) {\n\t    $line =~ m/^BS\\s+\\d+\\s+\\d+\\s+(.+)/;\n\t    my $member = $1;\n\t    $self->{'contigs'}->{$contig_number}->{$member}++;\n\t}\n\t# the members of the contigs are determined by the AF line in the ace file\n\telsif ($line =~ /^AF/) {\n\t    $self->debug(\"I see an AF line here.\\n\");\n\t    $line =~ /^AF\\ (\\S+)\\ (\\w)\\ (\\S+)/;\n\n            # push the name of the current read onto the member array for this contig\n\t    push @{$self->{'contigs'}->{$contig_number}->{'member_array'}},$1;\n\n            # the first read in the contig will be named the \"top\" read\n\t    if (!$top) {\n\t\t$self->debug(\"\\$top is not set.\\n\");\n\t\tif ($self->{'contigs'}->{$contig_number}->{'contig_direction'} eq \"C\") {\n\t\t    $self->debug(\"Reversing the order of the reads. The bottom will be $1\\n\");\n\n\t\t    # if the contig sequence is marked as the\n\t\t    # complement, the top becomes the bottom and$\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_name'} = $1;\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_complement'} = $2;\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_start'} = $3;\n\t\t}\n\t\telse {\n\t\t    $self->debug(\"NOT reversing the order of the reads. \".\n                                 \"The top_name will be $1\\n\");\n\t\t    # if the contig sequence is marked as the\n\t\t    # complement, the top becomes the bottom and$\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_name'} = $1;\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_complement'} = $2;\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_start'} = $3;\n\t\t}\n\t\t$top = 1;\n\t    }\n\t    else {\n\n\t\t# if the contig sequence is marked as the complement,\n\t\t# the top becomes the bottom and the bottom becomes\n\t\t# the top\n\t\tif ($self->{'contigs'}->{$contig_number}->{'contig_direction'} eq \"C\") {\n\t\t    $self->debug(\"Reversing the order of the reads. The top will be $1\\n\");\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_name'} = $1;\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_complement'} = $2;\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_start'} = $3;\n\t\t}\n\t\telse {\n\t\t    $self->debug(\"NOT reversing the order of the reads. The bottom will be $1\\n\");\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_name'} = $1;\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_complement'} = $2;\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_start'} = $3;\n\t\t}\n\t\t$top = undef;\n\t    }\n\t}\n    }\n    return 0;\n}\n\n=head2 set_reverse_designator($some_string)\n\n Title   : set_reverse_designator($some_string)\n Usage   : $o_consed->set_reverse_designator($some_string);\n Function: Set the designator for the reverse read of contigs in this\n\t   Bio::Tools::Alignment::Consed object. Used to determine if\n           contigs containing two reads can be named.\n Returns : The value of $o_consed->{reverse_designator} so you can check\n\t   to see that it was set properly.\n Args    : An arbitrary string.\n\nMay be useful only to me. I<shrug>\n\n\nsub set_reverse_designator {\n    my ($self,$reverse_designator) = @_;\n    $self->{'reverse_designator'} = $reverse_designator;\n    $self->{'o_trim'}->set_reverse_designator($reverse_designator);\n    return $self->{'reverse_designator'};\n}\t\t\t\t# end set_reverse_designator\n\n=head2 set_forward_designator($some_string)\n\n Title   : set_forward_designator($some_string)\n Usage   : $o_consed->set_forward_designator($some_string);\n Function: Set the designator for the forward read of contigs in this\n\t   Bio::Tools::Alignment::Consed object. Used to determine if\n           contigs containing two reads can be named.\n Returns : The value of $o_consed->{forward_designator} so you can check\n\t   to see that it was set properly.\n Args    : An arbitrary string.\n\nMay be useful only to me. I<shrug>\n\n\nsub set_forward_designator {\n    my ($self,$forward_designator) = @_;\n    $self->{'forward_designator'} = $forward_designator;\n    $self->{'o_trim'}->set_forward_designator($forward_designator);\n    return $self->{'forward_designator'};\n}\t\t\t\t# end set_forward_designator\n\n=head2 set_designator_ignore_case(\"yes\")\n\n Title   : set_designator_ignore_case(\"yes\")\n Usage   : $o_consed->set_designator_ignore_case(\"yes\");\n Function: Deprecated.\n Returns : Deprecated.\n Args    : Deprecated.\n\nDeprecated. Really. Trust me.\n\n\nsub set_designator_ignore_case {\n    my ($self,$ignore_case) = @_;\n    if ($ignore_case eq \"yes\") {\n\t$self->{'designator_ignore_case'} = 1;\n    }\n    return $self->{'designator_ignore_case'};\n}\t\t\t\t# end set_designator_ignore_case\n\n=head2 set_trim_points_singlets_and_singletons()\n\n Title   : set_trim_points_singlets_and_singletons()\n Usage   : $o_consed->set_trim_points_singlets_and_singletons();\n Function: Set the trim points for singlets and singletons based on\n\t   quality.  Uses the Bio::Tools::Alignment::Trim object. Use\n\t   at your own risk because the Bio::Tools::Alignment::Trim\n\t   object was designed specifically for me and is mysterious\n\t   in its ways. Every time somebody other then me uses it a\n\t   swarm of locusts decends on a small Central American\n\t   village so do not say you weren't warned.\n Returns : Nothing.\n Args    : None.\n\nWorking on exceptions and warnings here.\n\nSee L<Bio::Tools::Alignment::Trim> for more information\n\n\n#' to make my emacs happy\n\nsub set_trim_points_singlets_and_singletons {\n    my ($self) = @_;\n    $self->debug(\"Consed.pm : \\$self is $self\\n\");\n    my (@points,$trimmed_sequence);\n    if (!$self->{'doublets_set'}) {\n        $self->debug(\"You need to set the doublets before you use \".\n                     \"set_trim_points_singlets_and_doublets. Doing that now.\");\n\t$self->set_doublets();\n    }\n    foreach (sort keys %{$self->{'contigs'}}) {\n\tif ($self->{'contigs'}->{$_}->{'class'} eq \"singlet\") {\n\t    $self->debug(\"Singlet $_\\n\");\n\t    # this is what Warehouse wants\n\t    #         my ($self,$sequence,$quality,$name) = @_;\n\t    # this is what Bio::Tools::Alignment::Trim::trim_singlet wants:\n\t    # my ($self,$sequence,$quality,$name,$class) = @_;\n\t    # the following several lines are to make the parameter passing legible.\n\t    my ($sequence,$quality,$name,$class);\n\t    $sequence = $self->{'contigs'}->{$_}->{'consensus'};\n\t    if (!$self->{'contigs'}->{$_}->{'quality'}) { $quality = \"unset\"; }\n\t    else { $quality = $self->{'contigs'}->{$_}->{'quality'}; }\n\t    $name = $self->{'contigs'}->{$_}->{'name'};\n\t    $class = $self->{'contigs'}->{$_}->{'class'};\n\t    @points = @{$self->{'o_trim'}->trim_singlet($sequence,$quality,$name,$class)};\n\t    $self->{'contigs'}->{$_}->{'start_point'} = $points[0];\n\t    $self->{'contigs'}->{$_}->{'end_point'} = $points[1];\n\t    $self->{'contigs'}->{$_}->{'sequence_trimmed'} = \n                substr($self->{contigs}->{$_}->{'consensus'},$points[0],$points[1]-$points[0]);\n\t}\n    }\n    $self->debug(\"Bio::Tools::Alignment::Consed::set_trim_points_singlets\".\n                 \"_and_singletons: Done setting the quality trimpoints.\\n\");\n    return;\n}  # end set_trim_points_singlet\n\n=head2 set_trim_points_doublets()\n\n Title   : set_trim_points_doublets()\n Usage   : $o_consed->set_trim_points_doublets();\n Function: Set the trim points for doublets based on quality. Uses the\n\t   Bio::Tools::Alignment::Trim object. Use at your own risk because\n           the Bio::Tools::Alignment::Trim object was designed specifically\n           for me and is mysterious in its ways. Every time somebody other\n           then me uses it you risk a biblical plague being loosed on your\n           city.\n Returns : Nothing.\n Args    : None.\n Notes   : Working on exceptions here.\n\nSee L<Bio::Tools::Alignment::Trim> for more information\n\n\nsub set_trim_points_doublets {\n    my $self = shift;\n    my @points;\n    $self->debug(\"Bio::Tools::Alignment::Consed::set_trim_points_doublets:\".\n                 \" Restoring zeros for doublets.\\n\");\n    # &show_missing_sequence($self);\n    $self->debug(\"Bio::Tools::Alignment::Consed::set_trim_points_doublets:\".\n                 \" Setting doublet trim points.\\n\");\n    foreach (sort keys %{$self->{'contigs'}}) {\n\tif ($self->{'contigs'}->{$_}->{'class'} eq \"doublet\") {\n            # my ($self,$sequence,$quality,$name,$class) = @_;\n            my @quals = split(' ',$self->{'contigs'}->{$_}->{'quality'});\n\n\t    @points = $self->{o_trim}->trim_doublet\n                ($self->{'contigs'}->{$_}->{'consensus'},\n                 $self->{'contigs'}->{$_}->{'quality'},\n                 $self->{'contigs'}->{$_}->{name},\n                 $self->{'contigs'}->{$_}->{'class'});\n\t    $self->{'contigs'}->{$_}->{'start_point'} = $points[0];\n\t    $self->{'contigs'}->{$_}->{'end_point'} = $points[1];\n            # now set this\n\t    $self->{'contigs'}->{$_}->{'sequence_trimmed'} =\n                substr($self->{contigs}->{$_}->{'consensus'},\n                       $points[0],$points[1]-$points[0]);\n\t    # 010102 the deprecated way to do things:\n\t}\n    }\n    $self->debug(\"Bio::Tools::Alignment::Consed::set_trim_points_doublets:\".\n                 \" Done setting doublet trim points.\\n\"); \n    return;\n} # end set_trim_points_doublets\n\n=head2 get_trimmed_sequence_by_name($name)\n\n Title   : get_trimmed_sequence_by_name($name)\n Usage   : $o_consed->get_trimmed_sequence_by_name($name);\n Function: Returns the trimmed_sequence of a contig with {name} eq $name.\n Returns : A scalar- the trimmed sequence.\n Args    : The {name} of a contig.\n Notes   : \n\n\nsub get_trimmed_sequence_by_name {\n    my ($self,$name) = @_;\n    my $trimmed_sequence;\n    my $contigname = &get_contig_number_by_name($self,$name);\n    my $class = $self->{'contigs'}->{$contigname}->{'class'};\n    # what is this business and who was smoking crack while writing this?\n    # if ($class eq \"singlet\") {\n    # send the sequence, the quality, and the name\n    # $trimmed_sequence = $self->{o_trim}->trim_singlet\n    #  ($self->{'contigs'}->{$contigname}->{consensus},\n    #   $self->{'contigs'}->{$contigname}->{'quality'},$name);\n    # }\n    return $self->{'contigs'}->{$contigname}->{'sequence_trimmed'};\n}\n\n=head2 set_dash_present_in_sequence_name(\"yes\")\n\n Title   : set_dash_present_in_sequence_name(\"yes\")\n Usage   : $o_consed->set_dash_present_in_sequence_name(\"yes\");\n Function: Deprecated. Part of an uncompleted thought. (\"Oooh! Shiny!\")\n Returns : Nothing.\n Args    : \"yes\" to set {dash_present_in_sequence_name} to 1\n Notes   : \n\n\nsub set_dash_present_in_sequence_name {\n    my ($self,$dash_present) = @_;\n    if ($dash_present eq \"yes\") {\n\t$self->{'dash_present_in_sequence_name'} = 1;\n    }\n    else {\n\t$self->{'dash_present_in_sequence_name'} = 0;\n    }\n    return $self->{'dash_present_in_sequence_name'};\n} # end set_dash_present_in_sequence_name\n\n=head2 set_doublets()\n\n Title   : set_doublets()\n Usage   : $o_consed->set_doublets();\n Function: Find pairs that have similar names and mark them as doublets\n\t   and set the {name}.\n Returns : 0 or 1.\n Args    : None.\n\nA complicated subroutine that iterates over the\nBio::Tools::Alignment::Consed looking for contigs of 2. If the forward\nand reverse designator are removed from each of the reads in\n{'member_array'} and the remaining reads are the same, {name} is set\nto that name and the contig's class is set as \"doublet\".  If any of\nthose cases fail the contig is marked as a \"pair\".\n\n\n#' make my emacs happy\n\nsub set_doublets {\n    my ($self) = @_;\n    # set the designators in the Bio::Tools::Alignment::Trim object\n\n    $self->{'o_trim'}->set_designators($self->{'reverse_designator'},\n\t\t\t\t       $self->{'forward_designator'});\n    foreach my $key_contig (sort keys %{$self->{'contigs'}}) {\n\n\t# if there is a member array (why would there not be? This should be a die()able offence\n\t# but for now I will leave it\n\tif ($self->{'contigs'}->{$key_contig}->{'member_array'}) {\n\t    # if there are two reads in this contig \n\t    # i am pretty sure that this is wrong but i am keeping it for reference\n\t    # if (@{$self->{'contigs'}->{$key_contig}->{'member_array'}} == 2 || !$self->{'contigs'}->{$key_contig}->{'class'}) {\n\t    # <seconds later>\n\t    # <nod> WRONG. Was I on crack?\n\t    if (@{$self->{'contigs'}->{$key_contig}->{'member_array'}} == 2) {\n\t\t$self->{'contigs'}->{$key_contig}->{'num_members'} = 2;\n\t\t$self->debug(\"\\tThere are 2 members! Looking for the contig name...\\n\");\n\t\tmy $name = _get_contig_name($self,$self->{'contigs'}->{$key_contig}->{'member_array'});\n\t\t$self->debug(\"The name is $name\\n\") if defined $name;\n\t\tif ($name) {\n\t\t    $self->{'contigs'}->{$key_contig}->{'name'} = $name;\n\t\t    $self->{'contigs'}->{$key_contig}->{'class'} = \"doublet\";\n\t\t} else {\n\t\t    $self->debug(\"$key_contig is a pair.\\n\");\n\t\t    $self->{'contigs'}->{$key_contig}->{'class'} = \"pair\";\n\t\t}\n\t    }\n            # this is all fair and good but what about singlets?\n            # they have one reads in the member_array but certainly are not singletons\n\t    elsif (@{$self->{'contigs'}->{$key_contig}->{'member_array'}} == 1) {\n\t\t# set the name to be the name of the read\n\t\t$self->{'contigs'}->{$key_contig}->{name} = @{$self->{'contigs'}->{$key_contig}->{'member_array'}}[0];\n\t\t# set the number of members to be one\n\t\t$self->{'contigs'}->{$key_contig}->{num_members} = 1;\n\t\t# if this was a singlet, it would already belong to the class \"singlet\"\n\t\t# so leave it alone\n\t\t# if it is not a singlet, it is a singleton! lablel it appropriately\n\t\tunless ($self->{'contigs'}->{$key_contig}->{'class'}) {\n\t\t    $self->{'contigs'}->{$key_contig}->{'class'} = \"singleton\";\n\t\t}\n\t    }\n            # set the multiplet characteristics\n\t    elsif (@{$self->{'contigs'}->{$key_contig}->{'member_array'}} >= 3) {\n\t\t$self->{'contigs'}->{$key_contig}->{'num_members'} = @{$self->{'contigs'}->{$key_contig}->{'member_array'}};\n\t\t$self->{'contigs'}->{$key_contig}->{'class'} = \"multiplet\";\n\t    }\n\t    $self->{'contigs'}->{$key_contig}->{'num_members'} = @{$self->{'contigs'}->{$key_contig}->{'member_array'}};\n\n\t}\n    }\n    $self->{'doublets_set'} = \"done\";\n    return 0;\n}\t\t\t\t# end set_doublets\n\n=head2 set_singlets\n\n Title   : set_singlets\n Usage   : $o_consed->set_singlets();\n Function: Read in a singlets file and place them into the\n\t   Bio::Tools::Alignment::Consed object.\n Returns : Nothing.\n Args    : A scalar to turn on verbose parsing of the singlets file.\n Notes   : ","parameters":[{"label":"$self"}]}},{"name":"Bio","containerName":"Root::IO","kind":12,"line":992},{"name":"$name","containerName":null,"kind":13,"line":1016},{"containerName":null,"name":"%sequence","kind":13,"line":1016},{"line":1017,"kind":13,"name":"$self","containerName":null},{"containerName":"main::","name":"debug","kind":12,"line":1017},{"line":1018,"kind":13,"name":"%self","containerName":null},{"line":1018,"kind":13,"name":"%name","containerName":null},{"containerName":null,"name":"$name","line":1018,"kind":13},{"kind":13,"line":1019,"name":"%self","containerName":null},{"kind":13,"line":1019,"containerName":null,"name":"%name"},{"kind":13,"line":1019,"containerName":null,"name":"$sequence"},{"name":"%self","containerName":null,"line":1020,"kind":13},{"kind":13,"line":1020,"containerName":null,"name":"%name"},{"line":1020,"kind":13,"containerName":null,"name":"$name"},{"line":1021,"kind":13,"containerName":null,"name":"%self"},{"kind":13,"line":1021,"containerName":null,"name":"%name"},{"line":1022,"kind":13,"name":"%self","containerName":null},{"line":1022,"kind":13,"name":"%name","containerName":null},{"name":"$self","containerName":null,"kind":13,"line":1024},{"containerName":"main::","name":"debug","kind":12,"line":1024},{"name":"%self","containerName":null,"line":1025,"kind":13},{"containerName":"main::","definition":"sub","name":"get_singlets","range":{"start":{"line":1041,"character":0},"end":{"line":1051,"character":9999}},"kind":12,"line":1041,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"get_singlets","line":1044,"kind":13},{"containerName":"get_singlets","name":"$self","kind":13,"line":1045},{"kind":13,"line":1046,"containerName":"get_singlets","name":"$self"},{"kind":12,"line":1046,"name":"debug","containerName":"get_singlets"},{"line":1047,"kind":13,"name":"$self","containerName":"get_singlets"},{"name":"set_singlets","containerName":"get_singlets","kind":12,"line":1047},{"localvar":"my","name":"@singlets","definition":"my","containerName":"get_singlets","line":1050,"kind":13},{"line":1050,"kind":13,"name":"@array","containerName":"get_singlets"},{"line":1051,"kind":13,"localvar":"my","containerName":"get_singlets","definition":"my","name":"$key"},{"containerName":"get_singlets","name":"$self","line":1051,"kind":13}]},{"kind":12,"line":1045,"name":"singlets_set"},{"containerName":null,"name":"%self","kind":13,"line":1056},{"containerName":null,"name":"%key","line":1056,"kind":13},{"line":1059,"kind":13,"containerName":null,"name":"%self"},{"line":1059,"kind":13,"containerName":null,"name":"%key"},{"line":1060,"kind":13,"containerName":null,"name":"@singlets"},{"name":"$key","containerName":null,"kind":13,"line":1060},{"line":1063,"kind":13,"containerName":null,"name":"@singlets"},{"name":"set_quality_by_name","definition":"sub","containerName":"main::","range":{"end":{"line":1082,"character":9999},"start":{"character":0,"line":1078}},"kind":12,"children":[{"containerName":"set_quality_by_name","name":"$self","definition":"my","localvar":"my","kind":13,"line":1080},{"kind":13,"line":1080,"containerName":"set_quality_by_name","name":"$name"},{"line":1080,"kind":13,"containerName":"set_quality_by_name","name":"$quality"},{"localvar":"my","definition":"my","name":"$return","containerName":"set_quality_by_name","line":1081,"kind":13},{"containerName":"set_quality_by_name","name":"$self","line":1082,"kind":13}],"line":1078},{"containerName":null,"name":"%self","line":1083,"kind":13},{"line":1083,"kind":13,"containerName":null,"name":"%self"},{"name":"%self","containerName":null,"kind":13,"line":1084},{"name":"$quality","containerName":null,"kind":13,"line":1084},{"line":1085,"kind":13,"containerName":null,"name":"$return"},{"containerName":null,"name":"%return","line":1088,"kind":13},{"line":1105,"children":[{"localvar":"my","containerName":"set_singlet_quality","definition":"my","name":"$self","line":1106,"kind":13},{"containerName":"set_singlet_quality","definition":"my","name":"$full_filename","localvar":"my","kind":13,"line":1107},{"line":1107,"kind":13,"name":"$self","containerName":"set_singlet_quality"},{"line":1108,"kind":13,"name":"$full_filename","containerName":"set_singlet_quality"},{"kind":13,"line":1109,"name":"$base_path","definition":"my","containerName":"set_singlet_quality","localvar":"my"},{"name":"$filename","containerName":"set_singlet_quality","kind":13,"line":1109},{"line":1110,"kind":13,"localvar":"my","containerName":"set_singlet_quality","definition":"my","name":"$singletsfile"},{"containerName":"set_singlet_quality","name":"$base_path","line":1110,"kind":13},{"kind":13,"line":1110,"containerName":"set_singlet_quality","name":"$filename"},{"name":"$singletsfile","containerName":"set_singlet_quality","line":1111,"kind":13},{"line":1115,"kind":13,"name":"$self","containerName":"set_singlet_quality"},{"line":1115,"kind":12,"name":"warn","containerName":"set_singlet_quality"},{"localvar":"my","definition":"my","name":"$singlets_fh","containerName":"set_singlet_quality","line":1118,"kind":13},{"name":"new","containerName":"set_singlet_quality","kind":12,"line":1118},{"name":"$singletsfile","containerName":"set_singlet_quality","kind":13,"line":1118},{"line":1119,"kind":13,"localvar":"my","containerName":"set_singlet_quality","definition":"my","name":"$sequence"},{"line":1119,"kind":13,"containerName":"set_singlet_quality","name":"$name"},{"name":"$count","containerName":"set_singlet_quality","kind":13,"line":1119},{"kind":13,"line":1120,"containerName":"set_singlet_quality","definition":"my","name":"$identity","localvar":"my"},{"line":1120,"kind":13,"name":"$line","containerName":"set_singlet_quality"},{"name":"$quality","containerName":"set_singlet_quality","kind":13,"line":1120},{"line":1120,"kind":13,"containerName":"set_singlet_quality","name":"@qline"},{"name":"$line","containerName":"set_singlet_quality","kind":13,"line":1121},{"kind":13,"line":1121,"name":"$singlets_fh","containerName":"set_singlet_quality"},{"name":"_readline","containerName":"set_singlet_quality","line":1121,"kind":12},{"containerName":"set_singlet_quality","name":"$line","kind":13,"line":1122},{"kind":13,"line":1123,"name":"$line","containerName":"set_singlet_quality"},{"line":1124,"kind":13,"name":"$quality","containerName":"set_singlet_quality"},{"line":1125,"kind":13,"containerName":"set_singlet_quality","name":"$line"},{"line":1126,"kind":13,"containerName":"set_singlet_quality","name":"$identity"},{"containerName":"set_singlet_quality","name":"$self","line":1129,"kind":13},{"line":1129,"kind":13,"containerName":"set_singlet_quality","name":"$identity"},{"containerName":"set_singlet_quality","name":"$self","line":1130,"kind":13},{"containerName":"set_singlet_quality","name":"$identity","kind":13,"line":1130}],"kind":12,"range":{"end":{"line":1136,"character":9999},"start":{"line":1105,"character":0}},"containerName":"main::","definition":"sub","name":"set_singlet_quality"},{"name":"Bio","containerName":"Root::IO","kind":12,"line":1118},{"range":{"start":{"line":1149,"character":0},"end":{"character":9999,"line":1185}},"name":"set_contig_quality","definition":"sub","containerName":"main::","children":[{"line":1151,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"set_contig_quality"},{"name":"$self","containerName":"set_contig_quality","kind":13,"line":1155},{"line":1155,"kind":12,"name":"warn","containerName":"set_contig_quality"},{"containerName":"set_contig_quality","definition":"my","name":"$full_filename","localvar":"my","kind":13,"line":1156},{"name":"$self","containerName":"set_contig_quality","line":1156,"kind":13},{"containerName":"set_contig_quality","name":"$full_filename","kind":13,"line":1159},{"localvar":"my","containerName":"set_contig_quality","name":"$base_path","definition":"my","line":1160,"kind":13},{"name":"$filename","containerName":"set_contig_quality","kind":13,"line":1160},{"containerName":"set_contig_quality","definition":"my","name":"$singletsfile","localvar":"my","kind":13,"line":1161},{"containerName":"set_contig_quality","name":"$base_path","kind":13,"line":1161},{"name":"$filename","containerName":"set_contig_quality","line":1161,"kind":13},{"line":1162,"kind":13,"name":"$singletsfile","containerName":"set_contig_quality"},{"containerName":"set_contig_quality","name":"$self","line":1166,"kind":13},{"line":1166,"kind":12,"name":"warn","containerName":"set_contig_quality"},{"kind":13,"line":1169,"name":"$contig_quality_fh","definition":"my","containerName":"set_contig_quality","localvar":"my"},{"line":1169,"kind":12,"name":"new","containerName":"set_contig_quality"},{"name":"$singletsfile","containerName":"set_contig_quality","line":1169,"kind":13},{"containerName":"set_contig_quality","definition":"my","name":"$sequence","localvar":"my","kind":13,"line":1171},{"line":1171,"kind":13,"containerName":"set_contig_quality","name":"$name"},{"line":1171,"kind":13,"containerName":"set_contig_quality","name":"$count"},{"line":1171,"kind":13,"name":"$identity","containerName":"set_contig_quality"},{"name":"$line","containerName":"set_contig_quality","kind":13,"line":1171},{"name":"$quality","containerName":"set_contig_quality","kind":13,"line":1171},{"kind":13,"line":1172,"containerName":"set_contig_quality","name":"$line"},{"containerName":"set_contig_quality","name":"$contig_quality_fh","kind":13,"line":1172},{"containerName":"set_contig_quality","name":"_readline","line":1172,"kind":12},{"kind":13,"line":1173,"name":"$line","containerName":"set_contig_quality"},{"name":"$line","containerName":"set_contig_quality","kind":13,"line":1174},{"kind":13,"line":1175,"name":"$quality","containerName":"set_contig_quality"},{"line":1176,"kind":13,"containerName":"set_contig_quality","name":"$line"},{"line":1177,"kind":13,"name":"$identity","containerName":"set_contig_quality"},{"kind":13,"line":1180,"containerName":"set_contig_quality","name":"$self"},{"containerName":"set_contig_quality","name":"$identity","kind":13,"line":1180},{"containerName":"set_contig_quality","name":"$self","kind":13,"line":1181},{"name":"$identity","containerName":"set_contig_quality","kind":13,"line":1181}],"line":1149,"kind":12},{"kind":12,"line":1169,"containerName":"Root::IO","name":"Bio"},{"children":[{"line":1202,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"get_multiplets"},{"line":1203,"kind":13,"localvar":"my","containerName":"get_multiplets","definition":"my","name":"@multiplets"},{"name":"@array","containerName":"get_multiplets","line":1203,"kind":13},{"containerName":"get_multiplets","name":"$key","definition":"my","localvar":"my","kind":13,"line":1204},{"kind":13,"line":1204,"containerName":"get_multiplets","name":"$self"}],"line":1199,"kind":12,"range":{"start":{"line":1199,"character":0},"end":{"line":1204,"character":9999}},"definition":"sub","name":"get_multiplets","containerName":"main::"},{"kind":13,"line":1205,"name":"%self","containerName":null},{"kind":13,"line":1205,"name":"%key","containerName":null},{"containerName":null,"name":"%self","line":1206,"kind":13},{"name":"%key","containerName":null,"kind":13,"line":1206},{"kind":13,"line":1207,"name":"@multiplets","containerName":null},{"containerName":null,"name":"$key","line":1207,"kind":13},{"kind":13,"line":1211,"containerName":null,"name":"@multiplets"},{"children":[{"kind":13,"line":1228,"containerName":"get_all_members","definition":"my","name":"$self","localvar":"my"},{"line":1229,"kind":13,"localvar":"my","containerName":"get_all_members","name":"@members","definition":"my"},{"localvar":"my","containerName":"get_all_members","name":"$key","definition":"my","line":1230,"kind":13},{"name":"$self","containerName":"get_all_members","line":1230,"kind":13}],"line":1227,"kind":12,"range":{"end":{"line":1230,"character":9999},"start":{"character":0,"line":1227}},"definition":"sub","name":"get_all_members","containerName":"main::"},{"line":1231,"kind":13,"containerName":null,"name":"%key"},{"containerName":null,"name":"@members","line":1232,"kind":13},{"line":1232,"kind":13,"name":"%self","containerName":null},{"name":"%key","containerName":null,"line":1232,"kind":13},{"containerName":null,"name":"%self","kind":13,"line":1234},{"containerName":null,"name":"%key","kind":13,"line":1234},{"kind":13,"line":1235,"containerName":null,"name":"@members"},{"containerName":null,"name":"%self","kind":13,"line":1235},{"containerName":null,"name":"%key","line":1235,"kind":13},{"containerName":null,"name":"@members","kind":13,"line":1242},{"kind":12,"children":[{"kind":13,"line":1268,"containerName":"sum_lets","definition":"my","name":"$self","localvar":"my"},{"line":1268,"kind":13,"containerName":"sum_lets","name":"$total_only"},{"kind":13,"line":1269,"containerName":"sum_lets","name":"$count","definition":"my","localvar":"my"},{"containerName":"sum_lets","name":"$count_multiplets","line":1269,"kind":13},{"line":1269,"kind":13,"name":"$multiplet_count","containerName":"sum_lets"},{"containerName":"sum_lets","definition":"my","name":"$singlets","localvar":"my","kind":13,"line":1270},{"line":1270,"kind":13,"name":"$self","containerName":"sum_lets"},{"kind":13,"line":1270,"name":"$count","containerName":"sum_lets"},{"containerName":"sum_lets","name":"$singlets","line":1270,"kind":13},{"localvar":"my","containerName":"sum_lets","name":"$doublets","definition":"my","line":1271,"kind":13},{"name":"$self","containerName":"sum_lets","kind":13,"line":1271},{"kind":13,"line":1271,"name":"$count","containerName":"sum_lets"},{"kind":13,"line":1271,"containerName":"sum_lets","name":"$doublets"},{"definition":"my","name":"$pairs","containerName":"sum_lets","localvar":"my","kind":13,"line":1272},{"line":1272,"kind":13,"name":"$self","containerName":"sum_lets"},{"kind":13,"line":1272,"name":"$count","containerName":"sum_lets"},{"kind":13,"line":1272,"name":"$pairs","containerName":"sum_lets"},{"line":1273,"kind":13,"localvar":"my","containerName":"sum_lets","name":"$singletons","definition":"my"},{"line":1273,"kind":13,"name":"$self","containerName":"sum_lets"},{"name":"$count","containerName":"sum_lets","line":1273,"kind":13},{"kind":13,"line":1273,"name":"$singletons","containerName":"sum_lets"},{"line":1274,"kind":13,"localvar":"my","containerName":"sum_lets","name":"@multiplets","definition":"my"},{"containerName":"sum_lets","name":"$self","line":1274,"kind":13},{"line":1275,"kind":13,"name":"$count_multiplets","containerName":"sum_lets"},{"name":"@multiplets","containerName":"sum_lets","line":1275,"kind":13},{"line":1276,"kind":13,"localvar":"my","containerName":"sum_lets","name":"$return_string","definition":"my"},{"containerName":"sum_lets","name":"@multiplets","line":1277,"kind":13},{"kind":13,"line":1278,"definition":"my","name":"$number_members","containerName":"sum_lets","localvar":"my"},{"name":"$self","containerName":"sum_lets","line":1278,"kind":13},{"line":1279,"kind":13,"containerName":"sum_lets","name":"$multiplet_count"},{"name":"$number_members","containerName":"sum_lets","line":1279,"kind":13},{"line":1281,"kind":13,"name":"$multiplet_count","containerName":"sum_lets"},{"kind":13,"line":1282,"name":"$count","containerName":"sum_lets"},{"line":1282,"kind":13,"containerName":"sum_lets","name":"$multiplet_count"}],"line":1267,"definition":"sub","containerName":"main::","signature":{"label":"sum_lets($self,$total_only)","documentation":"1;\n# $Id: Consed.pm 16123 2009-09-17 12:57:27Z cjfields $\n# Bio::Tools::Alignment::Consed\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chad Matsalla\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Alignment::Consed - A module to work with objects from consed .ace files\n\n=head1 SYNOPSIS\n\n  # a report for sequencing stuff\n  my $o_consed = Bio::Tools::Alignment::Consed->new( \n      -acefile => \"/path/to/an/acefile.ace.1\",\n      -verbose => 1);\n  my $foo = $o_consed->set_reverse_designator(\"r\");\n  my $bar = $o_consed->set_forward_designator(\"f\");\n\n  # get the contig numbers\n  my @keys = $o_consed->get_contigs();\n\n  # construct the doublets\n  my $setter_doublets = $o_consed->choose_doublets();\n\n  # get the doublets\n  my @doublets = $o_consed->get_doublets();\n\n=head1 DESCRIPTION\n\nL<Bio::Tools::Alignment::Consed> provides methods and objects to deal\nwith the output from the Consed software suite. Specifically,\ntakes an C<.ace> file and provides objects for the results.\n\nA word about doublets: This module was written to accomodate a large\nEST sequencing operation. In this case, EST's were sequenced from the\n3' and from the 5' end of the EST. The objective was to find a\nconsensus sequence for these two reads.  Thus, a contig of two is what\nwe wanted, and this contig should consist of the forward and reverse\nreads of a getn clone. For example, for a forward designator of \"F\"\nand a reverse designator of \"R\", if the two reads chad1F and chad1R\nwere in a single contig (for example Contig 5) it will be determined\nthat the consensus sequence for Contig 5 will be the sequence for\nclone chad1.\n\nDoublets are good!\n\nThis module parses C<.ace> and related files. A detailed list of methods\ncan be found at the end of this document.\n\nI wrote a detailed rationale for design that may explain the reasons\nwhy some things were done the way they were done. That document is\nbeyond the scope of this pod and can probably be found in the\ndirectory from which this module was 'made' or at\nL<http://www.dieselwurks.com/bioinformatics/consedpm_documentation.pdf>.\n\nNote that the POD in that document might be old but the original\nrationale still stands.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nEmail chad-at-dieselwurks.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n#' \n\npackage Bio::Tools::Alignment::Consed;\n\nuse strict;\n\nuse FileHandle;\nuse Dumpvalue qw(dumpValue);\nuse Bio::Tools::Alignment::Trim;\nuse File::Spec;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\nour %DEFAULTS = ( 'f_designator' => 'f',\n\t\t  'r_designator' => 'r');\n\n=head2 new()\n\n Title   : new(-acefile => $path_to_some_acefile, -verbose => \"1\")\n Usage   : $o_consed = Bio::Tools::Alignment::Consed->\n              new(-acefile => $path_to_some_acefile, -verbose => \"1\");\n Function: Construct the Bio::Tools::Alignment::Consed object. Sets\n\t   verbosity for the following procedures, if necessary:\n\t   1. Construct a new Bio::Tools::Alignment::Trim object, to\n\t   handle quality trimming 2. Read in the acefile and parse it\n\n Returns : A reference to a Bio::Tools::Alignment::Consed object.\n Args    : A hash. (-acefile) is the filename of an acefile. If a full path\n\t   is not specified \"./\" is prepended to the filename and used from\n\t   instantiation until destruction. If you want \n           Bio::Tools::Alignment::Consed to be noisy during parsing of\n           the acefile, specify some value for (-verbose).\n\n\nsub new {\n    my ($class,%args) = @_;\n    my $self = $class->SUPER::new(%args);\n\n    $self->{'filename'} = $args{'-acefile'};\n\n    # this is special to UNIX and should probably use catfile : DONE!\n#    if (!($self->{'filename'} =~ m{/})) { \n#\t$self->{'filename'} = \"./\".$self->{'filename'}; \n#    } \n#    $self->{'filename'} =~ m/(.*\\/)(.*)ace.*$/;\n#    $self->{'path'} = $1;\n\n    # this is more generic and should work on most systems   \n    (undef, $self->{'path'}, undef) = File::Spec->splitpath($self->{'filename'});\n\n    $self->_initialize_io('-file'=>$self->{'filename'});\n    $self->{'o_trim'} = Bio::Tools::Alignment::Trim->new(-verbose => $self->verbose());\n    $self->set_forward_designator($DEFAULTS{'f_designator'});\n    $self->set_reverse_designator($DEFAULTS{'r_designator'});\n\n    $self->_read_file();\n    return $self;\n}\n\n=head2 set_verbose()\n\n Title   : set_verbose()\n Usage   : $o_consed->set_verbose(1);\n Function: Set the verbosity level for debugging messages. On instantiation\n\t   of the Bio::Tools::Alignment::Consed object the verbosity level\n           is set to 0 (quiet).\n Returns : 1 or 0.\n Args    : The verbosity levels are:\n\t      0 - quiet\n\t      1 - noisy\n\t      2 - noisier\n\t      3 - annoyingly noisy\n\nThis method for setting verbosity has largely been superseeded by a\nsub-by-sub way, where for every sub you can provide a (-verbose)\nswitch. I am doing converting this bit-by-bit so do not be surprised\nif some subs do not honour this.\n\n\n# from RootI\n\n# backwards compat\nsub set_verbose { (shift)->verbose(@_) }\n\n=head2 get_filename()\n\n Title   : get_filename()\n Usage   : $o_consed->get_filename();\n Function: Returns the name of the acefile being used by the\n\t   Bio::Tools::Alignment::Consed object.\n Returns : A scalar containing the name of a file.\n Args    : None.\n\n\n\nsub get_filename {\n    my $self = shift;\n    return $self->{'filename'};\n}\n\n=head2 count_sequences_with_grep()\n\n Title   : count_sequences_with_grep()\n Usage   : $o_consed->count_sequences_with_grep();\n Function: Use /bin/grep to scan through the files in the ace project dir\n\t   and count sequences in those files. I used this method in the\n\t   development of this module to verify that I was getting all of the\n\t   sequences. It works, but it is (I think) unix-like platform\n\t   dependent.\n Returns : A scalar containing the number of sequences in the ace project\n\t   directory.\n Args    : None.\n\nIf you are on a non-UNIX platform, you really do not have to use\nthis. It is more of a debugging routine designed to address very\nspecific problems.\n\nThis method was reimplemented to be platform independent with a pure\nperl implementation.  The above note can be ignored.\n\n\nsub count_sequences_with_grep {\n    my $self = shift;\n    my ($working_dir,$grep_cli,@total_grep_sequences);\n    # this should be migrated to a pure perl implementation ala\n    # Tom Christiansen's 'tcgrep'\n    # http://www.cpan.org/modules/by-authors/id/TOMC/scripts/tcgrep.gz\n\n    open(my $FILE, $self->{'filename'}) or do { $self->warn(\"cannot open file \".$self->{'filename'}. \" for grepping\"); return}; \n    my $counter =0;\n    while(<$FILE>) { $counter++ if(/^AF/); }\n\n    close $FILE;\n    opendir(my $SINGLETS,$self->{'path'});\n    foreach my $f ( readdir($SINGLETS) ) {\n\tnext unless ($f =~ /\\.singlets$/); \n\topen(my $FILE, File::Spec->catfile($self->{'path'},$f)) or do{ $self->warn(\"cannot open file \".File::Spec->catfile($self->{'path'},$f)); next };\n\twhile(<$FILE>) { $counter++ if(/^>/) }\n\tclose $FILE;\n    }\n    return $counter;\n}\n\n=head2 get_path()\n\n Title   : get_path()\n Usage   : $o_consed->get_path();\n Function: Returns the path to the acefile this object is working with.\n Returns : Scalar. The path to the working acefile.\n Args    : None.\n\n\nsub get_path {\n    my $self = shift;\n    return $self->{'path'};\n}\n\n=head2 get_contigs()\n\n Title   : get_contigs()\n Usage   : $o_consed->get_contigs();\n Function: Return the keys to the Bio::Tools::Alignment::Consed object.\n Returns : An array containing the keynames in the\n           Bio::Tools::Alignment::Consed object.\n Args    : None.\n\nThis would normally be used to get the keynames for some sort of\niterator. These keys are worthless in general day-to-day use because\nin the Consed acefile they are simply Contig1, Contig2, ...\n\n\nsub get_contigs {\n    my ($self,$contig) = @_;\n    my @contigs = sort keys %{$self->{'contigs'}};\n    return @contigs;\n}\n\n=head2 get_class($contig_keyname)\n\n Title   : get_class($contig_keyname)\n Usage   : $o_consed->get_class($contig_keyname);\n Function: Return the class name for this contig\n Returns : A scalar representing the class of this contig.\n Args    : None.\n Notes   : \n\n\nsub get_class {\n    my ($self,$contig) = @_;\n    return $self->{contigs}->{$contig}->{class};\n}\n\n=head2 get_quality_array($contig_keyname)\n\n Title   : get_quality_array($contig_keyname)\n Usage   : $o_consed->get_quality_array($contig_keyname);\n Function: Returns the quality for the consensus sequence for the given\n\t   contig as an array. See get_quality_scalar to get this as a scalar.\n Returns : An array containing the quality for the consensus sequence with\n\t   the given keyname.\n Args    : The keyname of a contig. Note: This is a keyname. The key would\n\t   normally come from get_contigs.\n\nReturns an array, not a reference. Is this a bug? I<thinking> No.\nWell, maybe.  Why was this developed like this? I was using FreezeThaw\nfor object persistence, and when it froze out these arrays it took a\nlong time to thaw it. Much better as a scalar.\n\nSee L<get_quality_scalar()|get_quality_scalar>\n\n\nsub get_quality_array {\n    my ($self,$contig) = @_;\n    return split ' ', $self->{contigs}->{$contig}->{quality};\n}\n\n=head2 get_quality_scalar($contig_keyname)\n\n Title   : get_quality_scalar($contig_keyname)\n Usage   : $o_consed->get_quality_scalar($contig_keyname);\n Function: Returns the quality for the consensus sequence for the given\n\t   contig as a scalar. See get_quality_array to get this as an array.\n Returns : An scalar containing the quality for the consensus sequence with\n           the given keyname.\n Args    : The keyname of a contig. Note this is a _keyname_. The key would\n\t   normally come from get_contigs.\n\nWhy was this developed like this? I was using FreezeThaw for object\npersistence, and when it froze out these arrays it took a coon's age\nto thaw it. Much better as a scalar.\n\nSee L<get_quality_array()|get_quality_array>\n\n\n#'\nsub get_quality_scalar {\n    my ($self,$contig) = @_;\n    return $self->{'contigs'}->{$contig}->{'quality'};\n}\n\n=head2 freeze_hash()\n\n Title   : freeze_hash()\n Usage   : $o_consed->freeze_hash();\n\n Function: Use Ilya's FreezeThaw module to create a persistent data\n\t   object for this Bio::Tools::Alignment::Consed data\n\t   structure. In the case of AAFC, we use\n\t   Bio::Tools::Alignment::Consed to pre-process bunches of\n\t   sequences, freeze the structures, and send in a harvesting\n\t   robot later to do database stuff.\n Returns : 0 or 1;\n Args    : None.\n\nThis procedure was removed so Consed.pm won't require FreezeThaw.\n\n\n#'\nsub freeze_hash {\n    my $self = shift;\n    $self->warn(\"This method (freeze_hash) was removed \".\n                \"from the bioperl consed.pm. Sorry.\\n\");\n    if (1==2) {\n        $self->debug(\"Bio::Tools::Alignment::Consed::freeze_hash:\".\n                     \" \\$self->{path} is $self->{path}\\n\");\n        my $filename = $self->{'path'}.\"frozen\";\n        my %contigs = %{$self->{'contigs'}};\n        my $frozen = freeze(%contigs);\n        umask 0001;\n        open (my $FREEZE,\">$filename\") or do {\n            $self->warn( \"Bio::Tools::Alignment::Consed could not \".\n                         \"freeze the contig hash because the file \".\n                         \"($filename) could not be opened: $!\\n\");\n            return 1;\n        };\n        print $FREEZE $frozen;\n        return 0;\n    }\n}\n\n=head2 get_members($contig_keyname)\n\n Title   : get_members($contig_keyname)\n Usage   : $o_consed->get_members($contig_keyname);\n Function: Return the _names_ of the reads in this contig.\n Returns : An array containing the names of the reads in this contig.\n Args    : The keyname of a contig. Note this is a keyname. The keyname\n\t   would normally come from get_contigs.\n\nSee L<get_contigs()|get_contigs>\n\n\nsub get_members {\n    my ($self,$contig) = @_;\n    if (!$contig) {\n\t$self->warn(\"You need to provide the name of a contig to \".\n                    \"use Bio::Tools::Alignment::Consed::get_members!\\n\");\n\treturn;\n    }\n    return @{$self->{'contigs'}->{$contig}->{'member_array'}};\n}\n\n=head2 get_members_by_name($some_arbitrary_name)\n\n Title   : get_members_by_name($some_arbitrary_name)\n Usage   : $o_consed->get_members_by_name($some_arbitrary_name);\n Function: Return the names of the reads in a contig. This is the name given\n\t   to $contig{key} based on what is in the contig. This is different\n\t   from the keys retrieved through get_contigs().\n Returns : An array containing the names of the reads in the contig with this\n\t   name.\n Args    : The name of a contig. Not a key, but a name.\n\nHighly inefficient. use some other method if possible.\nSee L<get_contigs()|get_contigs>\n\n\nsub get_members_by_name {\n    my ($self,$name) = @_;\n    # build a list to try to screen for redundancy\n    my @contigs_with_that_name;\n    foreach my $currkey ( sort keys %{$self->{'contigs'}} ) {\n\tnext if (!$self->{'contigs'}->{$currkey}->{'name'});\n\tif ($self->{'contigs'}->{$currkey}->{'name'} eq \"$name\") {\n\t    push @contigs_with_that_name,$currkey;\n\t}\n    }\n    my $count = @contigs_with_that_name;\n    if ($count == 1) {\n\tmy $contig_num = $contigs_with_that_name[0];\n\treturn @{$self->{'contigs'}->{$contig_num}->{'member_array'}};\n    }\n}\n\n=head2 get_contig_number_by_name($some_arbitrary_name)\n\n Title   : get_contig_number_by_name($some_arbitrary_name)\n Usage   : $o_consed->get_contig_number_by_name($some_arbitrary_name);\n Function: Return the names of the reads in a contig. This is the name given\n\t   to $contig{key} based on what is in the contig. This is different\n\t   from the keys retrieved through get_contigs().\n Returns : An array containing the names of the reads in the contig with this\n\t   name.\n Args    : The name of a contig. Not a key, but a name.\n\nSee L<get_contigs()|get_contigs>\n\n\nsub get_contig_number_by_name {\n    my ($self,$name) = @_;\n    foreach my $currkey (sort keys %{$self->{'contigs'}}) {\n\tif ($self->{'contigs'}->{$currkey}->{'name'} && \n\t    $self->{'contigs'}->{$currkey}->{'name'} eq \"$name\") {\n\t    return $currkey;\n\t}\n    }\n}\t\n\n=head2 get_sequence($contig_keyname)\n\n Title   : get_sequence($contig_keyname)\n Usage   : $o_consed->get_sequence($contig_keyname); \n Function: Returns the consensus sequence for a given contig.\n Returns : A scalar containing a sequence.\n Args    : The keyname of a contig. Note this is a key. The key would\n\t   normally come from get_contigs.\n\nSee L<get_contigs()|get_contigs>\n\n\nsub get_sequence {\n    my ($self,$contig) = @_;\n    return $self->{'contigs'}->{$contig}->{'consensus'};\n}\n\n=head2 set_final_sequence($some_sequence)\n\n Title   : set_final_sequence($name,$some_sequence)\n Usage   : $o_consed->set_final_sequence($name,$some_sequence);\n Function: Provides a manual way to set the sequence for a given key in the\n\t   contig hash. Rarely used.\n Returns : 0 or 1;\n Args    : The name (not the keyname) of a contig and an arbitrary string.\n\nA method with a questionable and somewhat mysterious origin. May raise\nthe dead or something like that.\n\n\nsub set_final_sequence {\n    my ($self,$name,$sequence) = @_;\n    if (!$self->{'contigs'}->{$name}) {\n\t$self->warn(\"You cannot set the final sequence for \".\n                    \"$name because it doesn't exist!\\n\");\n\treturn 1;\n    }\n    else {\n\t$self->{'contigs'}->{$name}->{'final_sequence'} = $sequence;\n    }\n    return 0;\n}\n\n=head2  _read_file()\n\n Title   : _read_file();\n Usage   : _read_file();\n Function: An internal subroutine used to read in an acefile and parse it\n\t   into a Bio::Tools::Alignment::Consed object.\n Returns : 0 or 1.\n Args    : Nothing.\n\nThis routine creates and saves the filhandle for reading the files in\n{fh}\n\n\nsub _read_file {\n    my ($self) = @_;\n    my ($line,$in_contig,$in_quality,$contig_number,$top);\n    # make it easier to type $fhl\n    while (defined($line=$self->_readline()) ) {\n\tchomp $line;\n\t# check if there is anything on this line\n\t# if not, you can stop gathering consensus sequence\n\tif (!$line) {\n\t    # if the line is blank you are no longer to gather consensus \n\t    # sequence or quality values\n\t    $in_contig = 0;\n\t    $in_quality = 0;\n\t}\n\t# you are currently gathering consensus sequence\n\telsif ($in_contig) {\n\t    if ($in_contig == 1) {\n\t\t$self->debug(\"Adding $line to consensus of contig number $contig_number.\\n\");\n\t\t$self->{'contigs'}->{$contig_number}->{'consensus'} .= $line;\n\t    }\n\t}\n\telsif ($in_quality) {\n\t    if (!$line) {\n\t\t$in_quality = undef;\n\t    }\n\t    else {\n\n\t\t# I wrote this in here because acefiles produced by\n\t\t# cap3 do not have a leading space like the acefiles\n\t\t# produced by phrap and there is the potential to have\n\t\t# concatenated quality values like this: 2020 rather\n\t\t# then 20 20 whre lines collide. Thanks Andrew for\n\t\t# noticing.\n\n\t\tif ($self->{'contigs'}->{$contig_number}->{'quality'} &&\n                    !($self->{'contigs'}->{$contig_number}->{'quality'} =~ m/\\ $/)) {\n\t\t    $self->{'contigs'}->{$contig_number}->{'quality'} .= \" \";\n\t\t}\n\t\t$self->{'contigs'}->{$contig_number}->{'quality'} .= $line;\n\t    }\n\t}\n\telsif ($line =~ /^BQ/) {\n\t    $in_quality = 1;\n\t}\n\n\t# the line /^CO/ like this:\n\t# CO Contig1 796 1 1 U\n\t# can be broken down as follows:\n\t# CO - Contig!\n\t# Contig1 - the name of this contig\n\t# 796 - Number of bases in this contig\n\t# 1 - Number of reads in this contig\n\t# 1 - number of base segments in this contig\n\t# U - Uncomplemented\n\n\telsif ($line =~ /^CO/) {\n\t    $line =~ m/^CO\\ Contig(\\d+)\\ \\d+\\ \\d+\\ \\d+\\ (\\w)/;\n\t    $contig_number = $1;\n\t    if ($2 eq \"C\") {\n\t\t$self->debug(\"Contig $contig_number is complemented!\\n\");\n\t    }\n\t    $self->{'contigs'}->{$contig_number}->{'member_array'} = [];\n\t    $self->{'contigs'}->{$contig_number}->{'contig_direction'} = \"$2\";\n\t    $in_contig = 1;\n\t}\n\n\t# 000713\n\t# this BS is deprecated, I think.\n\t# haha, I am really witty. <ew>\n\n\telsif ($line =~ /^BSDEPRECATED/) {\n\t    $line =~ m/^BS\\s+\\d+\\s+\\d+\\s+(.+)/;\n\t    my $member = $1;\n\t    $self->{'contigs'}->{$contig_number}->{$member}++;\n\t}\n\t# the members of the contigs are determined by the AF line in the ace file\n\telsif ($line =~ /^AF/) {\n\t    $self->debug(\"I see an AF line here.\\n\");\n\t    $line =~ /^AF\\ (\\S+)\\ (\\w)\\ (\\S+)/;\n\n            # push the name of the current read onto the member array for this contig\n\t    push @{$self->{'contigs'}->{$contig_number}->{'member_array'}},$1;\n\n            # the first read in the contig will be named the \"top\" read\n\t    if (!$top) {\n\t\t$self->debug(\"\\$top is not set.\\n\");\n\t\tif ($self->{'contigs'}->{$contig_number}->{'contig_direction'} eq \"C\") {\n\t\t    $self->debug(\"Reversing the order of the reads. The bottom will be $1\\n\");\n\n\t\t    # if the contig sequence is marked as the\n\t\t    # complement, the top becomes the bottom and$\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_name'} = $1;\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_complement'} = $2;\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_start'} = $3;\n\t\t}\n\t\telse {\n\t\t    $self->debug(\"NOT reversing the order of the reads. \".\n                                 \"The top_name will be $1\\n\");\n\t\t    # if the contig sequence is marked as the\n\t\t    # complement, the top becomes the bottom and$\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_name'} = $1;\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_complement'} = $2;\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_start'} = $3;\n\t\t}\n\t\t$top = 1;\n\t    }\n\t    else {\n\n\t\t# if the contig sequence is marked as the complement,\n\t\t# the top becomes the bottom and the bottom becomes\n\t\t# the top\n\t\tif ($self->{'contigs'}->{$contig_number}->{'contig_direction'} eq \"C\") {\n\t\t    $self->debug(\"Reversing the order of the reads. The top will be $1\\n\");\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_name'} = $1;\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_complement'} = $2;\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_start'} = $3;\n\t\t}\n\t\telse {\n\t\t    $self->debug(\"NOT reversing the order of the reads. The bottom will be $1\\n\");\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_name'} = $1;\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_complement'} = $2;\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_start'} = $3;\n\t\t}\n\t\t$top = undef;\n\t    }\n\t}\n    }\n    return 0;\n}\n\n=head2 set_reverse_designator($some_string)\n\n Title   : set_reverse_designator($some_string)\n Usage   : $o_consed->set_reverse_designator($some_string);\n Function: Set the designator for the reverse read of contigs in this\n\t   Bio::Tools::Alignment::Consed object. Used to determine if\n           contigs containing two reads can be named.\n Returns : The value of $o_consed->{reverse_designator} so you can check\n\t   to see that it was set properly.\n Args    : An arbitrary string.\n\nMay be useful only to me. I<shrug>\n\n\nsub set_reverse_designator {\n    my ($self,$reverse_designator) = @_;\n    $self->{'reverse_designator'} = $reverse_designator;\n    $self->{'o_trim'}->set_reverse_designator($reverse_designator);\n    return $self->{'reverse_designator'};\n}\t\t\t\t# end set_reverse_designator\n\n=head2 set_forward_designator($some_string)\n\n Title   : set_forward_designator($some_string)\n Usage   : $o_consed->set_forward_designator($some_string);\n Function: Set the designator for the forward read of contigs in this\n\t   Bio::Tools::Alignment::Consed object. Used to determine if\n           contigs containing two reads can be named.\n Returns : The value of $o_consed->{forward_designator} so you can check\n\t   to see that it was set properly.\n Args    : An arbitrary string.\n\nMay be useful only to me. I<shrug>\n\n\nsub set_forward_designator {\n    my ($self,$forward_designator) = @_;\n    $self->{'forward_designator'} = $forward_designator;\n    $self->{'o_trim'}->set_forward_designator($forward_designator);\n    return $self->{'forward_designator'};\n}\t\t\t\t# end set_forward_designator\n\n=head2 set_designator_ignore_case(\"yes\")\n\n Title   : set_designator_ignore_case(\"yes\")\n Usage   : $o_consed->set_designator_ignore_case(\"yes\");\n Function: Deprecated.\n Returns : Deprecated.\n Args    : Deprecated.\n\nDeprecated. Really. Trust me.\n\n\nsub set_designator_ignore_case {\n    my ($self,$ignore_case) = @_;\n    if ($ignore_case eq \"yes\") {\n\t$self->{'designator_ignore_case'} = 1;\n    }\n    return $self->{'designator_ignore_case'};\n}\t\t\t\t# end set_designator_ignore_case\n\n=head2 set_trim_points_singlets_and_singletons()\n\n Title   : set_trim_points_singlets_and_singletons()\n Usage   : $o_consed->set_trim_points_singlets_and_singletons();\n Function: Set the trim points for singlets and singletons based on\n\t   quality.  Uses the Bio::Tools::Alignment::Trim object. Use\n\t   at your own risk because the Bio::Tools::Alignment::Trim\n\t   object was designed specifically for me and is mysterious\n\t   in its ways. Every time somebody other then me uses it a\n\t   swarm of locusts decends on a small Central American\n\t   village so do not say you weren't warned.\n Returns : Nothing.\n Args    : None.\n\nWorking on exceptions and warnings here.\n\nSee L<Bio::Tools::Alignment::Trim> for more information\n\n\n#' to make my emacs happy\n\nsub set_trim_points_singlets_and_singletons {\n    my ($self) = @_;\n    $self->debug(\"Consed.pm : \\$self is $self\\n\");\n    my (@points,$trimmed_sequence);\n    if (!$self->{'doublets_set'}) {\n        $self->debug(\"You need to set the doublets before you use \".\n                     \"set_trim_points_singlets_and_doublets. Doing that now.\");\n\t$self->set_doublets();\n    }\n    foreach (sort keys %{$self->{'contigs'}}) {\n\tif ($self->{'contigs'}->{$_}->{'class'} eq \"singlet\") {\n\t    $self->debug(\"Singlet $_\\n\");\n\t    # this is what Warehouse wants\n\t    #         my ($self,$sequence,$quality,$name) = @_;\n\t    # this is what Bio::Tools::Alignment::Trim::trim_singlet wants:\n\t    # my ($self,$sequence,$quality,$name,$class) = @_;\n\t    # the following several lines are to make the parameter passing legible.\n\t    my ($sequence,$quality,$name,$class);\n\t    $sequence = $self->{'contigs'}->{$_}->{'consensus'};\n\t    if (!$self->{'contigs'}->{$_}->{'quality'}) { $quality = \"unset\"; }\n\t    else { $quality = $self->{'contigs'}->{$_}->{'quality'}; }\n\t    $name = $self->{'contigs'}->{$_}->{'name'};\n\t    $class = $self->{'contigs'}->{$_}->{'class'};\n\t    @points = @{$self->{'o_trim'}->trim_singlet($sequence,$quality,$name,$class)};\n\t    $self->{'contigs'}->{$_}->{'start_point'} = $points[0];\n\t    $self->{'contigs'}->{$_}->{'end_point'} = $points[1];\n\t    $self->{'contigs'}->{$_}->{'sequence_trimmed'} = \n                substr($self->{contigs}->{$_}->{'consensus'},$points[0],$points[1]-$points[0]);\n\t}\n    }\n    $self->debug(\"Bio::Tools::Alignment::Consed::set_trim_points_singlets\".\n                 \"_and_singletons: Done setting the quality trimpoints.\\n\");\n    return;\n}  # end set_trim_points_singlet\n\n=head2 set_trim_points_doublets()\n\n Title   : set_trim_points_doublets()\n Usage   : $o_consed->set_trim_points_doublets();\n Function: Set the trim points for doublets based on quality. Uses the\n\t   Bio::Tools::Alignment::Trim object. Use at your own risk because\n           the Bio::Tools::Alignment::Trim object was designed specifically\n           for me and is mysterious in its ways. Every time somebody other\n           then me uses it you risk a biblical plague being loosed on your\n           city.\n Returns : Nothing.\n Args    : None.\n Notes   : Working on exceptions here.\n\nSee L<Bio::Tools::Alignment::Trim> for more information\n\n\nsub set_trim_points_doublets {\n    my $self = shift;\n    my @points;\n    $self->debug(\"Bio::Tools::Alignment::Consed::set_trim_points_doublets:\".\n                 \" Restoring zeros for doublets.\\n\");\n    # &show_missing_sequence($self);\n    $self->debug(\"Bio::Tools::Alignment::Consed::set_trim_points_doublets:\".\n                 \" Setting doublet trim points.\\n\");\n    foreach (sort keys %{$self->{'contigs'}}) {\n\tif ($self->{'contigs'}->{$_}->{'class'} eq \"doublet\") {\n            # my ($self,$sequence,$quality,$name,$class) = @_;\n            my @quals = split(' ',$self->{'contigs'}->{$_}->{'quality'});\n\n\t    @points = $self->{o_trim}->trim_doublet\n                ($self->{'contigs'}->{$_}->{'consensus'},\n                 $self->{'contigs'}->{$_}->{'quality'},\n                 $self->{'contigs'}->{$_}->{name},\n                 $self->{'contigs'}->{$_}->{'class'});\n\t    $self->{'contigs'}->{$_}->{'start_point'} = $points[0];\n\t    $self->{'contigs'}->{$_}->{'end_point'} = $points[1];\n            # now set this\n\t    $self->{'contigs'}->{$_}->{'sequence_trimmed'} =\n                substr($self->{contigs}->{$_}->{'consensus'},\n                       $points[0],$points[1]-$points[0]);\n\t    # 010102 the deprecated way to do things:\n\t}\n    }\n    $self->debug(\"Bio::Tools::Alignment::Consed::set_trim_points_doublets:\".\n                 \" Done setting doublet trim points.\\n\"); \n    return;\n} # end set_trim_points_doublets\n\n=head2 get_trimmed_sequence_by_name($name)\n\n Title   : get_trimmed_sequence_by_name($name)\n Usage   : $o_consed->get_trimmed_sequence_by_name($name);\n Function: Returns the trimmed_sequence of a contig with {name} eq $name.\n Returns : A scalar- the trimmed sequence.\n Args    : The {name} of a contig.\n Notes   : \n\n\nsub get_trimmed_sequence_by_name {\n    my ($self,$name) = @_;\n    my $trimmed_sequence;\n    my $contigname = &get_contig_number_by_name($self,$name);\n    my $class = $self->{'contigs'}->{$contigname}->{'class'};\n    # what is this business and who was smoking crack while writing this?\n    # if ($class eq \"singlet\") {\n    # send the sequence, the quality, and the name\n    # $trimmed_sequence = $self->{o_trim}->trim_singlet\n    #  ($self->{'contigs'}->{$contigname}->{consensus},\n    #   $self->{'contigs'}->{$contigname}->{'quality'},$name);\n    # }\n    return $self->{'contigs'}->{$contigname}->{'sequence_trimmed'};\n}\n\n=head2 set_dash_present_in_sequence_name(\"yes\")\n\n Title   : set_dash_present_in_sequence_name(\"yes\")\n Usage   : $o_consed->set_dash_present_in_sequence_name(\"yes\");\n Function: Deprecated. Part of an uncompleted thought. (\"Oooh! Shiny!\")\n Returns : Nothing.\n Args    : \"yes\" to set {dash_present_in_sequence_name} to 1\n Notes   : \n\n\nsub set_dash_present_in_sequence_name {\n    my ($self,$dash_present) = @_;\n    if ($dash_present eq \"yes\") {\n\t$self->{'dash_present_in_sequence_name'} = 1;\n    }\n    else {\n\t$self->{'dash_present_in_sequence_name'} = 0;\n    }\n    return $self->{'dash_present_in_sequence_name'};\n} # end set_dash_present_in_sequence_name\n\n=head2 set_doublets()\n\n Title   : set_doublets()\n Usage   : $o_consed->set_doublets();\n Function: Find pairs that have similar names and mark them as doublets\n\t   and set the {name}.\n Returns : 0 or 1.\n Args    : None.\n\nA complicated subroutine that iterates over the\nBio::Tools::Alignment::Consed looking for contigs of 2. If the forward\nand reverse designator are removed from each of the reads in\n{'member_array'} and the remaining reads are the same, {name} is set\nto that name and the contig's class is set as \"doublet\".  If any of\nthose cases fail the contig is marked as a \"pair\".\n\n\n#' make my emacs happy\n\nsub set_doublets {\n    my ($self) = @_;\n    # set the designators in the Bio::Tools::Alignment::Trim object\n\n    $self->{'o_trim'}->set_designators($self->{'reverse_designator'},\n\t\t\t\t       $self->{'forward_designator'});\n    foreach my $key_contig (sort keys %{$self->{'contigs'}}) {\n\n\t# if there is a member array (why would there not be? This should be a die()able offence\n\t# but for now I will leave it\n\tif ($self->{'contigs'}->{$key_contig}->{'member_array'}) {\n\t    # if there are two reads in this contig \n\t    # i am pretty sure that this is wrong but i am keeping it for reference\n\t    # if (@{$self->{'contigs'}->{$key_contig}->{'member_array'}} == 2 || !$self->{'contigs'}->{$key_contig}->{'class'}) {\n\t    # <seconds later>\n\t    # <nod> WRONG. Was I on crack?\n\t    if (@{$self->{'contigs'}->{$key_contig}->{'member_array'}} == 2) {\n\t\t$self->{'contigs'}->{$key_contig}->{'num_members'} = 2;\n\t\t$self->debug(\"\\tThere are 2 members! Looking for the contig name...\\n\");\n\t\tmy $name = _get_contig_name($self,$self->{'contigs'}->{$key_contig}->{'member_array'});\n\t\t$self->debug(\"The name is $name\\n\") if defined $name;\n\t\tif ($name) {\n\t\t    $self->{'contigs'}->{$key_contig}->{'name'} = $name;\n\t\t    $self->{'contigs'}->{$key_contig}->{'class'} = \"doublet\";\n\t\t} else {\n\t\t    $self->debug(\"$key_contig is a pair.\\n\");\n\t\t    $self->{'contigs'}->{$key_contig}->{'class'} = \"pair\";\n\t\t}\n\t    }\n            # this is all fair and good but what about singlets?\n            # they have one reads in the member_array but certainly are not singletons\n\t    elsif (@{$self->{'contigs'}->{$key_contig}->{'member_array'}} == 1) {\n\t\t# set the name to be the name of the read\n\t\t$self->{'contigs'}->{$key_contig}->{name} = @{$self->{'contigs'}->{$key_contig}->{'member_array'}}[0];\n\t\t# set the number of members to be one\n\t\t$self->{'contigs'}->{$key_contig}->{num_members} = 1;\n\t\t# if this was a singlet, it would already belong to the class \"singlet\"\n\t\t# so leave it alone\n\t\t# if it is not a singlet, it is a singleton! lablel it appropriately\n\t\tunless ($self->{'contigs'}->{$key_contig}->{'class'}) {\n\t\t    $self->{'contigs'}->{$key_contig}->{'class'} = \"singleton\";\n\t\t}\n\t    }\n            # set the multiplet characteristics\n\t    elsif (@{$self->{'contigs'}->{$key_contig}->{'member_array'}} >= 3) {\n\t\t$self->{'contigs'}->{$key_contig}->{'num_members'} = @{$self->{'contigs'}->{$key_contig}->{'member_array'}};\n\t\t$self->{'contigs'}->{$key_contig}->{'class'} = \"multiplet\";\n\t    }\n\t    $self->{'contigs'}->{$key_contig}->{'num_members'} = @{$self->{'contigs'}->{$key_contig}->{'member_array'}};\n\n\t}\n    }\n    $self->{'doublets_set'} = \"done\";\n    return 0;\n}\t\t\t\t# end set_doublets\n\n=head2 set_singlets\n\n Title   : set_singlets\n Usage   : $o_consed->set_singlets();\n Function: Read in a singlets file and place them into the\n\t   Bio::Tools::Alignment::Consed object.\n Returns : Nothing.\n Args    : A scalar to turn on verbose parsing of the singlets file.\n Notes   : \n\n\nsub set_singlets {\n    # parse out the contents of the singlets file\n    my ($self) = @_;\n    $self->debug(\"Bio::Tools::Alignment::Consed Adding singlets to the contig hash...\\n\"); \n    my $full_filename = $self->{'filename'};\n    $self->debug(\"Bio::Tools::Alignment::Consed::set_singlets: \\$full_filename is $full_filename\\n\");\n    $full_filename =~ m/(.*\\/)(.*ace.*)$/; \t\t\t       \n    my ($base_path,$filename) = ($1,$2);\n    $self->debug(\"Bio::Tools::Alignment::Consed::set_singlets: singlets filename is $filename and \\$base_path is $base_path\\n\");\n    $filename =~ m/(.*)ace.*$/;\n    my $singletsfile = $base_path.$1.\"singlets\";\n    $self->debug(\"\\$singletsfile is $singletsfile\\n\");\n     if (!-f $singletsfile) {\n          # there is no singlets file.\n          $self->{'singlets_set'} = \"done\";\n          return;\n     }\n\t$self->debug(\"$singletsfile is indeed a file. Trying to open it...\\n\");\n    my $singlets_fh = Bio::Root::IO->new(-file => $singletsfile);\n    my ($sequence,$name,$count);\n    while ($_ = $singlets_fh->_readline()) {\n\tchomp $_;\n\tif (/\\>/) {\n\t    if ($name && $sequence) {\n\t\t$self->debug(\"Adding $name with sequence $sequence to hash...\\n\");\n\t\tpush @{$self->{'contigs'}->{$name}->{'member_array'}},$name;\n\t\t$self->{'contigs'}->{$name}->{'consensus'} = $sequence;\n\t\t$self->{'contigs'}->{$name}->{'name'} = $name;\n\t\t$self->{'contigs'}->{$name}->{\"singlet\"} = 1;\n\t\t$self->{'contigs'}->{$name}->{'class'} = \"singlet\";\n\t    }\n\t    $sequence = $name = undef;\n\t    $count++;\n\t    m/^\\>(.*)\\s\\sCHROMAT/;\n\t    $name = $1;\n\t    if (!$name) {\n\t\tm/\\>(\\S+)\\s/;\n\t\t$name = $1;\n\t    }\n\t}\n\telse { $sequence .= $_; }\t\n    }\n    if ($name && $sequence) {\n\t$self->debug(\"Pushing the last of the singlets ($name)\\n\");\n\t@{$self->{'contigs'}->{$name}->{'member_array'}} = $name;\n\t$self->{'contigs'}->{$name}->{'consensus'} = $sequence;\n\t$self->{'contigs'}->{$name}->{'name'} = $name;\n\t$self->{'contigs'}->{$name}->{\"singlet\"} = 1;\n\t$self->{'contigs'}->{$name}->{'class'} = \"singlet\";\n    }\n    $self->debug(\"Bio::Tools::Alignment::Consed::set_singlets: Done adding singlets to the singlets hash.\\n\");\n    $self->{'singlets_set'} = \"done\";\n    return 0;\n}\t\t\t\t# end sub set_singlets\n\n=head2 get_singlets()\n\n Title   : get_singlets()\n Usage   : $o_consed->get_singlets();\n Function: Return the keynames of the singlets.\n Returns : An array containing the keynames of all \n           Bio::Tools::Alignment::Consed sequences in the class \"singlet\".\n Args    : None.\n Notes   : \n\n\nsub get_singlets {\n    # returns an array of singlet names\n    # singlets have \"singlet\"=1 in the hash\n    my $self = shift;\n    if (!$self->{singlets_set}) {\n\t$self->debug(\"You need to set the singlets before you get them. Doing that now.\");\n\t$self->set_singlets();\n    }\t\n\n    my (@singlets,@array);\n    foreach my $key (sort keys %{$self->{'contigs'}}) {\n\t# @array = @{$Consed::contigs{$key}->{'member_array'}};\n\t# somethimes a user will try to get a list of singlets before the classes for the rest of the\n\t# contigs has been set (see t/test.t for how I figured this out. <bah>\t\t\t\n\t# so either way, just return class=singlets\n\tif (!$self->{'contigs'}->{$key}->{'class'}) {\n\t    # print(\"$key has no class. why?\\n\");\n\t}\n\telsif ($self->{'contigs'}->{$key}->{'class'} eq \"singlet\") {\n\t    push @singlets,$key;\n\t}\n    }\n    return @singlets;\n}\n\n=head2 set_quality_by_name($name,$quality)\n\n Title   : set_quality_by_name($name,$quality)\n Usage   : $o_consed->set_quality_by_name($name,$quality);\n Function: Deprecated. Make the contig with {name} have {'quality'} $quality.\n           Probably used for testing.\n Returns : Nothing.\n Args    : The name of a contig and a scalar for its quality.\n Notes   : Deprecated.\n\n\nsub set_quality_by_name {\n    # this is likely deprecated\n    my ($self,$name,$quality) = shift;\n    my $return;\n    foreach (sort keys %{$self->{'contigs'}}) {\n\tif ($self->{'contigs'} eq \"$name\" || $self->{'contigs'}->{'name'} eq \"$name\") {\n\t    $self->{'contigs'}->{'quality'} = $quality;\n\t    $return=1;\n\t}\n    }\n    if ($return) { return \"0\"; } else { return \"1\"; }\n}\t\t\t\t# end set quality by name\n\n=head2 set_singlet_quality()\n\n Title   : set_singlet_quality()\n Usage   : $o_consed->set_singlet_quality();\n Function: For each singlet, go to the appropriate file in phd_dir and read\n           in the phred quality for that read and place it into {'quality'}\n Returns : 0 or 1.\n Args    : None.\n Notes   : This is the next subroutine that will receive substantial revision\n           in the next little while. It really should eval the creation of\n           Bio::Tools::Alignment::Phred objects and go from there. \n\n\nsub set_singlet_quality {\n    my $self = shift;\n    my $full_filename = $self->{'filename'};\n    $full_filename =~ m/(.*\\/)(.*)ace.*$/;\n    my ($base_path,$filename) = ($1,\"$2\".\"qual\");\n    my $singletsfile = $base_path.$filename;\n    if (-f $singletsfile) {\n\t# print(\"$singletsfile is indeed a file. Trying to open it...\\n\");\n    }\n    else {\n\t$self->warn(\"$singletsfile is not a file. Sorry.\\n\");\n\treturn;\n    }\n\tmy $singlets_fh = Bio::Root::IO->new(-file => $singletsfile);\n\tmy ($sequence,$name,$count);\n    my ($identity,$line,$quality,@qline);\n    while ($line = $singlets_fh->_readline()) {\n\tchomp $line;\n\tif ($line =~ /^\\>/) {\n\t    $quality = undef;\n\t    $line =~ m/\\>(\\S*)\\s/;\n\t    $identity = $1;\n\t}\n\telse {\n\t    if ($self->{'contigs'}->{$identity}) {\n\t\t$self->{'contigs'}->{$identity}->{'quality'} .= \"$line \";\n\t    }\n\t}\n\n    }\n    return 0;\n}\n\n=head2 set_contig_quality()\n\n Title   : set_contig_quality()\n Usage   : $o_consed->set_contig_quality();\n Function: Deprecated.\n Returns : Deprecated.\n Args    : Deprecated.\n Notes   : Deprecated. Really. Trust me.\n\n\nsub set_contig_quality {\n    # note: contigs _include_ singletons but _not_ singlets\n    my ($self) = shift;\n          # the unexpected results I am referring to here are a doubling of quality values.\n          # the profanity I uttered on discovering this reminded me of the simpsons:\n          # Ned Flanders: \"That is the loudest profanity I have ever heard!\"\n     $self->warn(\"set_contig_quality is deprecated and will likely produce unexpected results\");\n    my $full_filename = $self->{'filename'};\n    # Run_SRC3700_2000-08-01_73+74.fasta.screen.contigs.qual\n    # from Consed.pm\n    $full_filename =~ m/(.*\\/)(.*)ace.*$/;\n    my ($base_path,$filename) = ($1,\"$2\".\"contigs.qual\");\n    my $singletsfile = $base_path.$filename;\n    if (-f $singletsfile) {\n\t# print(\"$singletsfile is indeed a file. Trying to open it...\\n\");\n    }\n    else {\n\t$self->warn(\"Bio::Tools::Alignment::Consed::set_contig_quality $singletsfile is not a file. Sorry.\\n\");\n\treturn;\n    }\n    my $contig_quality_fh = Bio::Root::IO->new(-file => $singletsfile);\n\n    my ($sequence,$name,$count,$identity,$line,$quality);\n    while ($line = $contig_quality_fh->_readline()) {\n\tchomp $line;\n\tif ($line =~ /^\\>/) {\n\t    $quality = undef;\n\t    $line =~ m/\\>.*Contig(\\d+)\\s/;\n\t    $identity = $1;\n\t}\n\telse {\n\t    if ($self->{'contigs'}->{$identity} ) {\n\t\t$self->{'contigs'}->{$identity}->{'quality'} .= \" $line\";\n\t    }\n\t}\n    }\n}\t\t\t\t# end set_contig_quality\n\n=head2 get_multiplets()\n\n Title   : get_multiplets()\n Usage   : $o_consed->get_multiplets();\n Function: Return the keynames of the multiplets.\n Returns : Returns an array containing the keynames of all \n           Bio::Tools::Alignment::Consed sequences in the class \"multiplet\".\n Args    : None.\n Notes   : \n\n\nsub get_multiplets {\n\t    # returns an array of multiplet names\n\t    # multiplets have # members > 2\n    my $self = shift;\n    my (@multiplets,@array);\n    foreach my $key (sort keys %{$self->{'contigs'}}) {\n\tif ($self->{'contigs'}->{$key}->{'class'}) {\n\t    if ($self->{'contigs'}->{$key}->{'class'} eq \"multiplet\") {\n\t\tpush @multiplets,$key;\n\t    }\n\t}\n    }\n    return @multiplets;\n}\n\n=head2 get_all_members()\n\n  Title   : get_all_members()\n  Usage   : @all_members = $o_consed->get_all_members();\n  Function: Return a list of all of the read names in the \n            Bio::Tools::Alignment::Consed object.\n  Returns : An array containing all of the elements in all of the\n            {'member_array'}s.\n  Args    : None.\n  Notes   : \n\n\nsub get_all_members {\n    my $self = shift;\n    my @members;\n    foreach my $key (sort keys %{$self->{'contigs'}}) {\n\tif ($key =~ /^singlet/) {\n\t    push @members,$self->{'contigs'}->{$key}->{'member_array'}[0];\n\t}\n\telsif ($self->{'contigs'}->{$key}->{'member_array'}) {\n\t    push @members,@{$self->{'contigs'}->{$key}->{'member_array'}};\n\t}\n\t# else {\n\t#\tprint(\"Bio::Tools::Alignment::Consed: $key is _not_ an array. Pushing $self->{'contigs'}->{$key}->{'member_array'} onto \\@members\\n\");\n\t#\tpush @members,$self->{'contigs'}->{$key}->{'member_array'};\n\t# }\n    }\n    return @members;\n}\n\n=head2 sum_lets($total_only)\n\n Title   : sum_lets($total_only)\n Usage   : $statistics = $o_consed->sum_lets($total_only);\n Function: Provide numbers for how many sequences were accounted for in the\n           Bio::Tools::Alignment::Consed object.\n Returns : If a scalar is present, returns the total number of\n           sequences accounted for in all classes. If no scalar passed\n           then returns a string that looks like this:\n           Singt/singn/doub/pair/mult/total : 2,0,1(2),0(0),0(0),4\n           This example means the following: There were 1 singlets.\n           There were 0 singletons.  There were 1 doublets for a total\n           of 2 sequences in this class.  There were 0 pairs for a\n           total of 0 sequences in this class.  There were 0\n           multiplets for a total of 0 sequences in this class.  There\n           were a total of 4 sequences accounted for in the\n           Bio::Tools::Alignment::Consed object.   \n Args : A scalar is optional to change the way the numbers are returned.  \n Notes:","parameters":[{"label":"$self"},{"label":"$total_only"}]},"detail":"($self,$total_only)","name":"sum_lets","range":{"start":{"line":1267,"character":0},"end":{"character":9999,"line":1289}}},{"kind":12,"line":1271,"name":"get_doublets"},{"name":"get_pairs","line":1272,"kind":12},{"name":"get_singletons","line":1273,"kind":12},{"name":"num_members","line":1278,"kind":12},{"kind":12,"line":1286,"name":"strict"},{"containerName":null,"name":"%multiplet_count","line":1291,"kind":13},{"line":1291,"kind":13,"name":"$multiplet_count","containerName":null},{"name":"%total_only","containerName":null,"line":1292,"kind":13},{"line":1293,"kind":13,"name":"$count","containerName":null},{"name":"$return_string","containerName":null,"line":1295,"kind":13},{"line":1297,"kind":13,"containerName":null,"name":"$doublets"},{"name":"$pairs","containerName":null,"line":1297,"kind":13},{"line":1299,"kind":13,"name":"$return_string","containerName":null},{"name":"write_stats","definition":"sub","containerName":"main::","range":{"end":{"line":1335,"character":9999},"start":{"character":0,"line":1322}},"kind":12,"children":[{"containerName":"write_stats","definition":"my","name":"$self","localvar":"my","kind":13,"line":1325},{"line":1326,"kind":13,"localvar":"my","containerName":"write_stats","definition":"my","name":"$stats_filename"},{"kind":13,"line":1326,"containerName":"write_stats","name":"$self"},{"name":"$statistics_raw","definition":"my","containerName":"write_stats","localvar":"my","kind":13,"line":1327},{"kind":13,"line":1327,"name":"$self","containerName":"write_stats"},{"kind":12,"line":1327,"name":"sum_lets","containerName":"write_stats"},{"definition":"my","name":"$statsfilecontents","containerName":"write_stats","localvar":"my","kind":13,"line":1328},{"containerName":"write_stats","name":"$statistics_raw","line":1328,"kind":13},{"kind":13,"line":1330,"definition":"my","name":"$fh","containerName":"write_stats","localvar":"my"},{"containerName":"write_stats","name":"new","kind":12,"line":1330},{"line":1332,"kind":13,"name":"$fh","containerName":"write_stats"},{"kind":12,"line":1332,"name":"_print","containerName":"write_stats"},{"name":"$fh","containerName":"write_stats","kind":13,"line":1334},{"name":"close","containerName":"write_stats","kind":12,"line":1334}],"line":1322},{"kind":12,"line":1330,"containerName":"Root::IO","name":"Bio"},{"line":1349,"children":[{"containerName":"get_singletons","name":"$self","definition":"my","localvar":"my","kind":13,"line":1352},{"kind":13,"line":1353,"name":"@singletons","definition":"my","containerName":"get_singletons","localvar":"my"},{"line":1353,"kind":13,"containerName":"get_singletons","name":"@array"},{"line":1354,"kind":13,"localvar":"my","containerName":"get_singletons","name":"$key","definition":"my"},{"containerName":"get_singletons","name":"$self","kind":13,"line":1354}],"kind":12,"range":{"start":{"character":0,"line":1349},"end":{"line":1354,"character":9999}},"containerName":"main::","definition":"sub","name":"get_singletons"},{"name":"%self","containerName":null,"line":1355,"kind":13},{"line":1355,"kind":13,"containerName":null,"name":"%key"},{"containerName":null,"name":"%self","line":1361,"kind":13},{"name":"%key","containerName":null,"kind":13,"line":1361},{"line":1362,"kind":13,"containerName":null,"name":"@array"},{"containerName":null,"name":"%self","line":1362,"kind":13},{"containerName":null,"name":"%key","line":1362,"kind":13},{"name":"$num_array_elem","definition":"my","containerName":null,"localvar":"my","kind":13,"line":1364},{"containerName":null,"name":"@array","kind":13,"line":1364},{"containerName":null,"name":"$num_array_elem","kind":13,"line":1365},{"kind":13,"line":1365,"containerName":null,"name":"%self"},{"name":"%key","containerName":null,"kind":13,"line":1365},{"containerName":null,"name":"%self","kind":13,"line":1365},{"kind":13,"line":1365,"name":"%key","containerName":null},{"containerName":null,"name":"@singletons","line":1365,"kind":13},{"containerName":null,"name":"$key","line":1365,"kind":13},{"kind":13,"line":1367,"name":"@singletons","containerName":null},{"children":[{"line":1385,"kind":13,"localvar":"my","containerName":"get_pairs","definition":"my","name":"$self"},{"containerName":"get_pairs","name":"@pairs","definition":"my","localvar":"my","kind":13,"line":1386},{"containerName":"get_pairs","name":"@array","kind":13,"line":1386},{"name":"$key","definition":"my","containerName":"get_pairs","localvar":"my","kind":13,"line":1387},{"name":"$self","containerName":"get_pairs","line":1387,"kind":13}],"line":1382,"kind":12,"range":{"end":{"line":1387,"character":9999},"start":{"character":0,"line":1382}},"definition":"sub","name":"get_pairs","containerName":"main::"},{"containerName":null,"name":"%self","kind":13,"line":1388},{"line":1388,"kind":13,"containerName":null,"name":"%key"},{"name":"%self","containerName":null,"line":1389,"kind":13},{"containerName":null,"name":"%key","line":1389,"kind":13},{"containerName":null,"name":"%self","kind":13,"line":1390},{"kind":13,"line":1390,"name":"%key","containerName":null},{"containerName":null,"name":"@pairs","kind":13,"line":1391},{"kind":13,"line":1391,"containerName":null,"name":"$key"},{"kind":13,"line":1395,"containerName":null,"name":"@pairs"},{"range":{"end":{"line":1412,"character":9999},"start":{"character":0,"line":1409}},"name":"get_name","children":[{"kind":13,"line":1410,"containerName":"get_name","name":"$self","definition":"my","localvar":"my"},{"containerName":"get_name","name":"$contig","line":1410,"kind":13},{"kind":13,"line":1411,"name":"$self","containerName":"get_name"},{"kind":13,"line":1411,"name":"$contig","containerName":"get_name"}],"line":1409,"kind":12,"signature":{"label":"get_name($self,$contig)","parameters":[{"label":"$self"},{"label":"$contig"}],"documentation":"1;\n# $Id: Consed.pm 16123 2009-09-17 12:57:27Z cjfields $\n# Bio::Tools::Alignment::Consed\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chad Matsalla\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Alignment::Consed - A module to work with objects from consed .ace files\n\n=head1 SYNOPSIS\n\n  # a report for sequencing stuff\n  my $o_consed = Bio::Tools::Alignment::Consed->new( \n      -acefile => \"/path/to/an/acefile.ace.1\",\n      -verbose => 1);\n  my $foo = $o_consed->set_reverse_designator(\"r\");\n  my $bar = $o_consed->set_forward_designator(\"f\");\n\n  # get the contig numbers\n  my @keys = $o_consed->get_contigs();\n\n  # construct the doublets\n  my $setter_doublets = $o_consed->choose_doublets();\n\n  # get the doublets\n  my @doublets = $o_consed->get_doublets();\n\n=head1 DESCRIPTION\n\nL<Bio::Tools::Alignment::Consed> provides methods and objects to deal\nwith the output from the Consed software suite. Specifically,\ntakes an C<.ace> file and provides objects for the results.\n\nA word about doublets: This module was written to accomodate a large\nEST sequencing operation. In this case, EST's were sequenced from the\n3' and from the 5' end of the EST. The objective was to find a\nconsensus sequence for these two reads.  Thus, a contig of two is what\nwe wanted, and this contig should consist of the forward and reverse\nreads of a getn clone. For example, for a forward designator of \"F\"\nand a reverse designator of \"R\", if the two reads chad1F and chad1R\nwere in a single contig (for example Contig 5) it will be determined\nthat the consensus sequence for Contig 5 will be the sequence for\nclone chad1.\n\nDoublets are good!\n\nThis module parses C<.ace> and related files. A detailed list of methods\ncan be found at the end of this document.\n\nI wrote a detailed rationale for design that may explain the reasons\nwhy some things were done the way they were done. That document is\nbeyond the scope of this pod and can probably be found in the\ndirectory from which this module was 'made' or at\nL<http://www.dieselwurks.com/bioinformatics/consedpm_documentation.pdf>.\n\nNote that the POD in that document might be old but the original\nrationale still stands.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nEmail chad-at-dieselwurks.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n#' \n\npackage Bio::Tools::Alignment::Consed;\n\nuse strict;\n\nuse FileHandle;\nuse Dumpvalue qw(dumpValue);\nuse Bio::Tools::Alignment::Trim;\nuse File::Spec;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\nour %DEFAULTS = ( 'f_designator' => 'f',\n\t\t  'r_designator' => 'r');\n\n=head2 new()\n\n Title   : new(-acefile => $path_to_some_acefile, -verbose => \"1\")\n Usage   : $o_consed = Bio::Tools::Alignment::Consed->\n              new(-acefile => $path_to_some_acefile, -verbose => \"1\");\n Function: Construct the Bio::Tools::Alignment::Consed object. Sets\n\t   verbosity for the following procedures, if necessary:\n\t   1. Construct a new Bio::Tools::Alignment::Trim object, to\n\t   handle quality trimming 2. Read in the acefile and parse it\n\n Returns : A reference to a Bio::Tools::Alignment::Consed object.\n Args    : A hash. (-acefile) is the filename of an acefile. If a full path\n\t   is not specified \"./\" is prepended to the filename and used from\n\t   instantiation until destruction. If you want \n           Bio::Tools::Alignment::Consed to be noisy during parsing of\n           the acefile, specify some value for (-verbose).\n\n\nsub new {\n    my ($class,%args) = @_;\n    my $self = $class->SUPER::new(%args);\n\n    $self->{'filename'} = $args{'-acefile'};\n\n    # this is special to UNIX and should probably use catfile : DONE!\n#    if (!($self->{'filename'} =~ m{/})) { \n#\t$self->{'filename'} = \"./\".$self->{'filename'}; \n#    } \n#    $self->{'filename'} =~ m/(.*\\/)(.*)ace.*$/;\n#    $self->{'path'} = $1;\n\n    # this is more generic and should work on most systems   \n    (undef, $self->{'path'}, undef) = File::Spec->splitpath($self->{'filename'});\n\n    $self->_initialize_io('-file'=>$self->{'filename'});\n    $self->{'o_trim'} = Bio::Tools::Alignment::Trim->new(-verbose => $self->verbose());\n    $self->set_forward_designator($DEFAULTS{'f_designator'});\n    $self->set_reverse_designator($DEFAULTS{'r_designator'});\n\n    $self->_read_file();\n    return $self;\n}\n\n=head2 set_verbose()\n\n Title   : set_verbose()\n Usage   : $o_consed->set_verbose(1);\n Function: Set the verbosity level for debugging messages. On instantiation\n\t   of the Bio::Tools::Alignment::Consed object the verbosity level\n           is set to 0 (quiet).\n Returns : 1 or 0.\n Args    : The verbosity levels are:\n\t      0 - quiet\n\t      1 - noisy\n\t      2 - noisier\n\t      3 - annoyingly noisy\n\nThis method for setting verbosity has largely been superseeded by a\nsub-by-sub way, where for every sub you can provide a (-verbose)\nswitch. I am doing converting this bit-by-bit so do not be surprised\nif some subs do not honour this.\n\n\n# from RootI\n\n# backwards compat\nsub set_verbose { (shift)->verbose(@_) }\n\n=head2 get_filename()\n\n Title   : get_filename()\n Usage   : $o_consed->get_filename();\n Function: Returns the name of the acefile being used by the\n\t   Bio::Tools::Alignment::Consed object.\n Returns : A scalar containing the name of a file.\n Args    : None.\n\n\n\nsub get_filename {\n    my $self = shift;\n    return $self->{'filename'};\n}\n\n=head2 count_sequences_with_grep()\n\n Title   : count_sequences_with_grep()\n Usage   : $o_consed->count_sequences_with_grep();\n Function: Use /bin/grep to scan through the files in the ace project dir\n\t   and count sequences in those files. I used this method in the\n\t   development of this module to verify that I was getting all of the\n\t   sequences. It works, but it is (I think) unix-like platform\n\t   dependent.\n Returns : A scalar containing the number of sequences in the ace project\n\t   directory.\n Args    : None.\n\nIf you are on a non-UNIX platform, you really do not have to use\nthis. It is more of a debugging routine designed to address very\nspecific problems.\n\nThis method was reimplemented to be platform independent with a pure\nperl implementation.  The above note can be ignored.\n\n\nsub count_sequences_with_grep {\n    my $self = shift;\n    my ($working_dir,$grep_cli,@total_grep_sequences);\n    # this should be migrated to a pure perl implementation ala\n    # Tom Christiansen's 'tcgrep'\n    # http://www.cpan.org/modules/by-authors/id/TOMC/scripts/tcgrep.gz\n\n    open(my $FILE, $self->{'filename'}) or do { $self->warn(\"cannot open file \".$self->{'filename'}. \" for grepping\"); return}; \n    my $counter =0;\n    while(<$FILE>) { $counter++ if(/^AF/); }\n\n    close $FILE;\n    opendir(my $SINGLETS,$self->{'path'});\n    foreach my $f ( readdir($SINGLETS) ) {\n\tnext unless ($f =~ /\\.singlets$/); \n\topen(my $FILE, File::Spec->catfile($self->{'path'},$f)) or do{ $self->warn(\"cannot open file \".File::Spec->catfile($self->{'path'},$f)); next };\n\twhile(<$FILE>) { $counter++ if(/^>/) }\n\tclose $FILE;\n    }\n    return $counter;\n}\n\n=head2 get_path()\n\n Title   : get_path()\n Usage   : $o_consed->get_path();\n Function: Returns the path to the acefile this object is working with.\n Returns : Scalar. The path to the working acefile.\n Args    : None.\n\n\nsub get_path {\n    my $self = shift;\n    return $self->{'path'};\n}\n\n=head2 get_contigs()\n\n Title   : get_contigs()\n Usage   : $o_consed->get_contigs();\n Function: Return the keys to the Bio::Tools::Alignment::Consed object.\n Returns : An array containing the keynames in the\n           Bio::Tools::Alignment::Consed object.\n Args    : None.\n\nThis would normally be used to get the keynames for some sort of\niterator. These keys are worthless in general day-to-day use because\nin the Consed acefile they are simply Contig1, Contig2, ...\n\n\nsub get_contigs {\n    my ($self,$contig) = @_;\n    my @contigs = sort keys %{$self->{'contigs'}};\n    return @contigs;\n}\n\n=head2 get_class($contig_keyname)\n\n Title   : get_class($contig_keyname)\n Usage   : $o_consed->get_class($contig_keyname);\n Function: Return the class name for this contig\n Returns : A scalar representing the class of this contig.\n Args    : None.\n Notes   : \n\n\nsub get_class {\n    my ($self,$contig) = @_;\n    return $self->{contigs}->{$contig}->{class};\n}\n\n=head2 get_quality_array($contig_keyname)\n\n Title   : get_quality_array($contig_keyname)\n Usage   : $o_consed->get_quality_array($contig_keyname);\n Function: Returns the quality for the consensus sequence for the given\n\t   contig as an array. See get_quality_scalar to get this as a scalar.\n Returns : An array containing the quality for the consensus sequence with\n\t   the given keyname.\n Args    : The keyname of a contig. Note: This is a keyname. The key would\n\t   normally come from get_contigs.\n\nReturns an array, not a reference. Is this a bug? I<thinking> No.\nWell, maybe.  Why was this developed like this? I was using FreezeThaw\nfor object persistence, and when it froze out these arrays it took a\nlong time to thaw it. Much better as a scalar.\n\nSee L<get_quality_scalar()|get_quality_scalar>\n\n\nsub get_quality_array {\n    my ($self,$contig) = @_;\n    return split ' ', $self->{contigs}->{$contig}->{quality};\n}\n\n=head2 get_quality_scalar($contig_keyname)\n\n Title   : get_quality_scalar($contig_keyname)\n Usage   : $o_consed->get_quality_scalar($contig_keyname);\n Function: Returns the quality for the consensus sequence for the given\n\t   contig as a scalar. See get_quality_array to get this as an array.\n Returns : An scalar containing the quality for the consensus sequence with\n           the given keyname.\n Args    : The keyname of a contig. Note this is a _keyname_. The key would\n\t   normally come from get_contigs.\n\nWhy was this developed like this? I was using FreezeThaw for object\npersistence, and when it froze out these arrays it took a coon's age\nto thaw it. Much better as a scalar.\n\nSee L<get_quality_array()|get_quality_array>\n\n\n#'\nsub get_quality_scalar {\n    my ($self,$contig) = @_;\n    return $self->{'contigs'}->{$contig}->{'quality'};\n}\n\n=head2 freeze_hash()\n\n Title   : freeze_hash()\n Usage   : $o_consed->freeze_hash();\n\n Function: Use Ilya's FreezeThaw module to create a persistent data\n\t   object for this Bio::Tools::Alignment::Consed data\n\t   structure. In the case of AAFC, we use\n\t   Bio::Tools::Alignment::Consed to pre-process bunches of\n\t   sequences, freeze the structures, and send in a harvesting\n\t   robot later to do database stuff.\n Returns : 0 or 1;\n Args    : None.\n\nThis procedure was removed so Consed.pm won't require FreezeThaw.\n\n\n#'\nsub freeze_hash {\n    my $self = shift;\n    $self->warn(\"This method (freeze_hash) was removed \".\n                \"from the bioperl consed.pm. Sorry.\\n\");\n    if (1==2) {\n        $self->debug(\"Bio::Tools::Alignment::Consed::freeze_hash:\".\n                     \" \\$self->{path} is $self->{path}\\n\");\n        my $filename = $self->{'path'}.\"frozen\";\n        my %contigs = %{$self->{'contigs'}};\n        my $frozen = freeze(%contigs);\n        umask 0001;\n        open (my $FREEZE,\">$filename\") or do {\n            $self->warn( \"Bio::Tools::Alignment::Consed could not \".\n                         \"freeze the contig hash because the file \".\n                         \"($filename) could not be opened: $!\\n\");\n            return 1;\n        };\n        print $FREEZE $frozen;\n        return 0;\n    }\n}\n\n=head2 get_members($contig_keyname)\n\n Title   : get_members($contig_keyname)\n Usage   : $o_consed->get_members($contig_keyname);\n Function: Return the _names_ of the reads in this contig.\n Returns : An array containing the names of the reads in this contig.\n Args    : The keyname of a contig. Note this is a keyname. The keyname\n\t   would normally come from get_contigs.\n\nSee L<get_contigs()|get_contigs>\n\n\nsub get_members {\n    my ($self,$contig) = @_;\n    if (!$contig) {\n\t$self->warn(\"You need to provide the name of a contig to \".\n                    \"use Bio::Tools::Alignment::Consed::get_members!\\n\");\n\treturn;\n    }\n    return @{$self->{'contigs'}->{$contig}->{'member_array'}};\n}\n\n=head2 get_members_by_name($some_arbitrary_name)\n\n Title   : get_members_by_name($some_arbitrary_name)\n Usage   : $o_consed->get_members_by_name($some_arbitrary_name);\n Function: Return the names of the reads in a contig. This is the name given\n\t   to $contig{key} based on what is in the contig. This is different\n\t   from the keys retrieved through get_contigs().\n Returns : An array containing the names of the reads in the contig with this\n\t   name.\n Args    : The name of a contig. Not a key, but a name.\n\nHighly inefficient. use some other method if possible.\nSee L<get_contigs()|get_contigs>\n\n\nsub get_members_by_name {\n    my ($self,$name) = @_;\n    # build a list to try to screen for redundancy\n    my @contigs_with_that_name;\n    foreach my $currkey ( sort keys %{$self->{'contigs'}} ) {\n\tnext if (!$self->{'contigs'}->{$currkey}->{'name'});\n\tif ($self->{'contigs'}->{$currkey}->{'name'} eq \"$name\") {\n\t    push @contigs_with_that_name,$currkey;\n\t}\n    }\n    my $count = @contigs_with_that_name;\n    if ($count == 1) {\n\tmy $contig_num = $contigs_with_that_name[0];\n\treturn @{$self->{'contigs'}->{$contig_num}->{'member_array'}};\n    }\n}\n\n=head2 get_contig_number_by_name($some_arbitrary_name)\n\n Title   : get_contig_number_by_name($some_arbitrary_name)\n Usage   : $o_consed->get_contig_number_by_name($some_arbitrary_name);\n Function: Return the names of the reads in a contig. This is the name given\n\t   to $contig{key} based on what is in the contig. This is different\n\t   from the keys retrieved through get_contigs().\n Returns : An array containing the names of the reads in the contig with this\n\t   name.\n Args    : The name of a contig. Not a key, but a name.\n\nSee L<get_contigs()|get_contigs>\n\n\nsub get_contig_number_by_name {\n    my ($self,$name) = @_;\n    foreach my $currkey (sort keys %{$self->{'contigs'}}) {\n\tif ($self->{'contigs'}->{$currkey}->{'name'} && \n\t    $self->{'contigs'}->{$currkey}->{'name'} eq \"$name\") {\n\t    return $currkey;\n\t}\n    }\n}\t\n\n=head2 get_sequence($contig_keyname)\n\n Title   : get_sequence($contig_keyname)\n Usage   : $o_consed->get_sequence($contig_keyname); \n Function: Returns the consensus sequence for a given contig.\n Returns : A scalar containing a sequence.\n Args    : The keyname of a contig. Note this is a key. The key would\n\t   normally come from get_contigs.\n\nSee L<get_contigs()|get_contigs>\n\n\nsub get_sequence {\n    my ($self,$contig) = @_;\n    return $self->{'contigs'}->{$contig}->{'consensus'};\n}\n\n=head2 set_final_sequence($some_sequence)\n\n Title   : set_final_sequence($name,$some_sequence)\n Usage   : $o_consed->set_final_sequence($name,$some_sequence);\n Function: Provides a manual way to set the sequence for a given key in the\n\t   contig hash. Rarely used.\n Returns : 0 or 1;\n Args    : The name (not the keyname) of a contig and an arbitrary string.\n\nA method with a questionable and somewhat mysterious origin. May raise\nthe dead or something like that.\n\n\nsub set_final_sequence {\n    my ($self,$name,$sequence) = @_;\n    if (!$self->{'contigs'}->{$name}) {\n\t$self->warn(\"You cannot set the final sequence for \".\n                    \"$name because it doesn't exist!\\n\");\n\treturn 1;\n    }\n    else {\n\t$self->{'contigs'}->{$name}->{'final_sequence'} = $sequence;\n    }\n    return 0;\n}\n\n=head2  _read_file()\n\n Title   : _read_file();\n Usage   : _read_file();\n Function: An internal subroutine used to read in an acefile and parse it\n\t   into a Bio::Tools::Alignment::Consed object.\n Returns : 0 or 1.\n Args    : Nothing.\n\nThis routine creates and saves the filhandle for reading the files in\n{fh}\n\n\nsub _read_file {\n    my ($self) = @_;\n    my ($line,$in_contig,$in_quality,$contig_number,$top);\n    # make it easier to type $fhl\n    while (defined($line=$self->_readline()) ) {\n\tchomp $line;\n\t# check if there is anything on this line\n\t# if not, you can stop gathering consensus sequence\n\tif (!$line) {\n\t    # if the line is blank you are no longer to gather consensus \n\t    # sequence or quality values\n\t    $in_contig = 0;\n\t    $in_quality = 0;\n\t}\n\t# you are currently gathering consensus sequence\n\telsif ($in_contig) {\n\t    if ($in_contig == 1) {\n\t\t$self->debug(\"Adding $line to consensus of contig number $contig_number.\\n\");\n\t\t$self->{'contigs'}->{$contig_number}->{'consensus'} .= $line;\n\t    }\n\t}\n\telsif ($in_quality) {\n\t    if (!$line) {\n\t\t$in_quality = undef;\n\t    }\n\t    else {\n\n\t\t# I wrote this in here because acefiles produced by\n\t\t# cap3 do not have a leading space like the acefiles\n\t\t# produced by phrap and there is the potential to have\n\t\t# concatenated quality values like this: 2020 rather\n\t\t# then 20 20 whre lines collide. Thanks Andrew for\n\t\t# noticing.\n\n\t\tif ($self->{'contigs'}->{$contig_number}->{'quality'} &&\n                    !($self->{'contigs'}->{$contig_number}->{'quality'} =~ m/\\ $/)) {\n\t\t    $self->{'contigs'}->{$contig_number}->{'quality'} .= \" \";\n\t\t}\n\t\t$self->{'contigs'}->{$contig_number}->{'quality'} .= $line;\n\t    }\n\t}\n\telsif ($line =~ /^BQ/) {\n\t    $in_quality = 1;\n\t}\n\n\t# the line /^CO/ like this:\n\t# CO Contig1 796 1 1 U\n\t# can be broken down as follows:\n\t# CO - Contig!\n\t# Contig1 - the name of this contig\n\t# 796 - Number of bases in this contig\n\t# 1 - Number of reads in this contig\n\t# 1 - number of base segments in this contig\n\t# U - Uncomplemented\n\n\telsif ($line =~ /^CO/) {\n\t    $line =~ m/^CO\\ Contig(\\d+)\\ \\d+\\ \\d+\\ \\d+\\ (\\w)/;\n\t    $contig_number = $1;\n\t    if ($2 eq \"C\") {\n\t\t$self->debug(\"Contig $contig_number is complemented!\\n\");\n\t    }\n\t    $self->{'contigs'}->{$contig_number}->{'member_array'} = [];\n\t    $self->{'contigs'}->{$contig_number}->{'contig_direction'} = \"$2\";\n\t    $in_contig = 1;\n\t}\n\n\t# 000713\n\t# this BS is deprecated, I think.\n\t# haha, I am really witty. <ew>\n\n\telsif ($line =~ /^BSDEPRECATED/) {\n\t    $line =~ m/^BS\\s+\\d+\\s+\\d+\\s+(.+)/;\n\t    my $member = $1;\n\t    $self->{'contigs'}->{$contig_number}->{$member}++;\n\t}\n\t# the members of the contigs are determined by the AF line in the ace file\n\telsif ($line =~ /^AF/) {\n\t    $self->debug(\"I see an AF line here.\\n\");\n\t    $line =~ /^AF\\ (\\S+)\\ (\\w)\\ (\\S+)/;\n\n            # push the name of the current read onto the member array for this contig\n\t    push @{$self->{'contigs'}->{$contig_number}->{'member_array'}},$1;\n\n            # the first read in the contig will be named the \"top\" read\n\t    if (!$top) {\n\t\t$self->debug(\"\\$top is not set.\\n\");\n\t\tif ($self->{'contigs'}->{$contig_number}->{'contig_direction'} eq \"C\") {\n\t\t    $self->debug(\"Reversing the order of the reads. The bottom will be $1\\n\");\n\n\t\t    # if the contig sequence is marked as the\n\t\t    # complement, the top becomes the bottom and$\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_name'} = $1;\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_complement'} = $2;\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_start'} = $3;\n\t\t}\n\t\telse {\n\t\t    $self->debug(\"NOT reversing the order of the reads. \".\n                                 \"The top_name will be $1\\n\");\n\t\t    # if the contig sequence is marked as the\n\t\t    # complement, the top becomes the bottom and$\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_name'} = $1;\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_complement'} = $2;\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_start'} = $3;\n\t\t}\n\t\t$top = 1;\n\t    }\n\t    else {\n\n\t\t# if the contig sequence is marked as the complement,\n\t\t# the top becomes the bottom and the bottom becomes\n\t\t# the top\n\t\tif ($self->{'contigs'}->{$contig_number}->{'contig_direction'} eq \"C\") {\n\t\t    $self->debug(\"Reversing the order of the reads. The top will be $1\\n\");\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_name'} = $1;\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_complement'} = $2;\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_start'} = $3;\n\t\t}\n\t\telse {\n\t\t    $self->debug(\"NOT reversing the order of the reads. The bottom will be $1\\n\");\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_name'} = $1;\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_complement'} = $2;\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_start'} = $3;\n\t\t}\n\t\t$top = undef;\n\t    }\n\t}\n    }\n    return 0;\n}\n\n=head2 set_reverse_designator($some_string)\n\n Title   : set_reverse_designator($some_string)\n Usage   : $o_consed->set_reverse_designator($some_string);\n Function: Set the designator for the reverse read of contigs in this\n\t   Bio::Tools::Alignment::Consed object. Used to determine if\n           contigs containing two reads can be named.\n Returns : The value of $o_consed->{reverse_designator} so you can check\n\t   to see that it was set properly.\n Args    : An arbitrary string.\n\nMay be useful only to me. I<shrug>\n\n\nsub set_reverse_designator {\n    my ($self,$reverse_designator) = @_;\n    $self->{'reverse_designator'} = $reverse_designator;\n    $self->{'o_trim'}->set_reverse_designator($reverse_designator);\n    return $self->{'reverse_designator'};\n}\t\t\t\t# end set_reverse_designator\n\n=head2 set_forward_designator($some_string)\n\n Title   : set_forward_designator($some_string)\n Usage   : $o_consed->set_forward_designator($some_string);\n Function: Set the designator for the forward read of contigs in this\n\t   Bio::Tools::Alignment::Consed object. Used to determine if\n           contigs containing two reads can be named.\n Returns : The value of $o_consed->{forward_designator} so you can check\n\t   to see that it was set properly.\n Args    : An arbitrary string.\n\nMay be useful only to me. I<shrug>\n\n\nsub set_forward_designator {\n    my ($self,$forward_designator) = @_;\n    $self->{'forward_designator'} = $forward_designator;\n    $self->{'o_trim'}->set_forward_designator($forward_designator);\n    return $self->{'forward_designator'};\n}\t\t\t\t# end set_forward_designator\n\n=head2 set_designator_ignore_case(\"yes\")\n\n Title   : set_designator_ignore_case(\"yes\")\n Usage   : $o_consed->set_designator_ignore_case(\"yes\");\n Function: Deprecated.\n Returns : Deprecated.\n Args    : Deprecated.\n\nDeprecated. Really. Trust me.\n\n\nsub set_designator_ignore_case {\n    my ($self,$ignore_case) = @_;\n    if ($ignore_case eq \"yes\") {\n\t$self->{'designator_ignore_case'} = 1;\n    }\n    return $self->{'designator_ignore_case'};\n}\t\t\t\t# end set_designator_ignore_case\n\n=head2 set_trim_points_singlets_and_singletons()\n\n Title   : set_trim_points_singlets_and_singletons()\n Usage   : $o_consed->set_trim_points_singlets_and_singletons();\n Function: Set the trim points for singlets and singletons based on\n\t   quality.  Uses the Bio::Tools::Alignment::Trim object. Use\n\t   at your own risk because the Bio::Tools::Alignment::Trim\n\t   object was designed specifically for me and is mysterious\n\t   in its ways. Every time somebody other then me uses it a\n\t   swarm of locusts decends on a small Central American\n\t   village so do not say you weren't warned.\n Returns : Nothing.\n Args    : None.\n\nWorking on exceptions and warnings here.\n\nSee L<Bio::Tools::Alignment::Trim> for more information\n\n\n#' to make my emacs happy\n\nsub set_trim_points_singlets_and_singletons {\n    my ($self) = @_;\n    $self->debug(\"Consed.pm : \\$self is $self\\n\");\n    my (@points,$trimmed_sequence);\n    if (!$self->{'doublets_set'}) {\n        $self->debug(\"You need to set the doublets before you use \".\n                     \"set_trim_points_singlets_and_doublets. Doing that now.\");\n\t$self->set_doublets();\n    }\n    foreach (sort keys %{$self->{'contigs'}}) {\n\tif ($self->{'contigs'}->{$_}->{'class'} eq \"singlet\") {\n\t    $self->debug(\"Singlet $_\\n\");\n\t    # this is what Warehouse wants\n\t    #         my ($self,$sequence,$quality,$name) = @_;\n\t    # this is what Bio::Tools::Alignment::Trim::trim_singlet wants:\n\t    # my ($self,$sequence,$quality,$name,$class) = @_;\n\t    # the following several lines are to make the parameter passing legible.\n\t    my ($sequence,$quality,$name,$class);\n\t    $sequence = $self->{'contigs'}->{$_}->{'consensus'};\n\t    if (!$self->{'contigs'}->{$_}->{'quality'}) { $quality = \"unset\"; }\n\t    else { $quality = $self->{'contigs'}->{$_}->{'quality'}; }\n\t    $name = $self->{'contigs'}->{$_}->{'name'};\n\t    $class = $self->{'contigs'}->{$_}->{'class'};\n\t    @points = @{$self->{'o_trim'}->trim_singlet($sequence,$quality,$name,$class)};\n\t    $self->{'contigs'}->{$_}->{'start_point'} = $points[0];\n\t    $self->{'contigs'}->{$_}->{'end_point'} = $points[1];\n\t    $self->{'contigs'}->{$_}->{'sequence_trimmed'} = \n                substr($self->{contigs}->{$_}->{'consensus'},$points[0],$points[1]-$points[0]);\n\t}\n    }\n    $self->debug(\"Bio::Tools::Alignment::Consed::set_trim_points_singlets\".\n                 \"_and_singletons: Done setting the quality trimpoints.\\n\");\n    return;\n}  # end set_trim_points_singlet\n\n=head2 set_trim_points_doublets()\n\n Title   : set_trim_points_doublets()\n Usage   : $o_consed->set_trim_points_doublets();\n Function: Set the trim points for doublets based on quality. Uses the\n\t   Bio::Tools::Alignment::Trim object. Use at your own risk because\n           the Bio::Tools::Alignment::Trim object was designed specifically\n           for me and is mysterious in its ways. Every time somebody other\n           then me uses it you risk a biblical plague being loosed on your\n           city.\n Returns : Nothing.\n Args    : None.\n Notes   : Working on exceptions here.\n\nSee L<Bio::Tools::Alignment::Trim> for more information\n\n\nsub set_trim_points_doublets {\n    my $self = shift;\n    my @points;\n    $self->debug(\"Bio::Tools::Alignment::Consed::set_trim_points_doublets:\".\n                 \" Restoring zeros for doublets.\\n\");\n    # &show_missing_sequence($self);\n    $self->debug(\"Bio::Tools::Alignment::Consed::set_trim_points_doublets:\".\n                 \" Setting doublet trim points.\\n\");\n    foreach (sort keys %{$self->{'contigs'}}) {\n\tif ($self->{'contigs'}->{$_}->{'class'} eq \"doublet\") {\n            # my ($self,$sequence,$quality,$name,$class) = @_;\n            my @quals = split(' ',$self->{'contigs'}->{$_}->{'quality'});\n\n\t    @points = $self->{o_trim}->trim_doublet\n                ($self->{'contigs'}->{$_}->{'consensus'},\n                 $self->{'contigs'}->{$_}->{'quality'},\n                 $self->{'contigs'}->{$_}->{name},\n                 $self->{'contigs'}->{$_}->{'class'});\n\t    $self->{'contigs'}->{$_}->{'start_point'} = $points[0];\n\t    $self->{'contigs'}->{$_}->{'end_point'} = $points[1];\n            # now set this\n\t    $self->{'contigs'}->{$_}->{'sequence_trimmed'} =\n                substr($self->{contigs}->{$_}->{'consensus'},\n                       $points[0],$points[1]-$points[0]);\n\t    # 010102 the deprecated way to do things:\n\t}\n    }\n    $self->debug(\"Bio::Tools::Alignment::Consed::set_trim_points_doublets:\".\n                 \" Done setting doublet trim points.\\n\"); \n    return;\n} # end set_trim_points_doublets\n\n=head2 get_trimmed_sequence_by_name($name)\n\n Title   : get_trimmed_sequence_by_name($name)\n Usage   : $o_consed->get_trimmed_sequence_by_name($name);\n Function: Returns the trimmed_sequence of a contig with {name} eq $name.\n Returns : A scalar- the trimmed sequence.\n Args    : The {name} of a contig.\n Notes   : \n\n\nsub get_trimmed_sequence_by_name {\n    my ($self,$name) = @_;\n    my $trimmed_sequence;\n    my $contigname = &get_contig_number_by_name($self,$name);\n    my $class = $self->{'contigs'}->{$contigname}->{'class'};\n    # what is this business and who was smoking crack while writing this?\n    # if ($class eq \"singlet\") {\n    # send the sequence, the quality, and the name\n    # $trimmed_sequence = $self->{o_trim}->trim_singlet\n    #  ($self->{'contigs'}->{$contigname}->{consensus},\n    #   $self->{'contigs'}->{$contigname}->{'quality'},$name);\n    # }\n    return $self->{'contigs'}->{$contigname}->{'sequence_trimmed'};\n}\n\n=head2 set_dash_present_in_sequence_name(\"yes\")\n\n Title   : set_dash_present_in_sequence_name(\"yes\")\n Usage   : $o_consed->set_dash_present_in_sequence_name(\"yes\");\n Function: Deprecated. Part of an uncompleted thought. (\"Oooh! Shiny!\")\n Returns : Nothing.\n Args    : \"yes\" to set {dash_present_in_sequence_name} to 1\n Notes   : \n\n\nsub set_dash_present_in_sequence_name {\n    my ($self,$dash_present) = @_;\n    if ($dash_present eq \"yes\") {\n\t$self->{'dash_present_in_sequence_name'} = 1;\n    }\n    else {\n\t$self->{'dash_present_in_sequence_name'} = 0;\n    }\n    return $self->{'dash_present_in_sequence_name'};\n} # end set_dash_present_in_sequence_name\n\n=head2 set_doublets()\n\n Title   : set_doublets()\n Usage   : $o_consed->set_doublets();\n Function: Find pairs that have similar names and mark them as doublets\n\t   and set the {name}.\n Returns : 0 or 1.\n Args    : None.\n\nA complicated subroutine that iterates over the\nBio::Tools::Alignment::Consed looking for contigs of 2. If the forward\nand reverse designator are removed from each of the reads in\n{'member_array'} and the remaining reads are the same, {name} is set\nto that name and the contig's class is set as \"doublet\".  If any of\nthose cases fail the contig is marked as a \"pair\".\n\n\n#' make my emacs happy\n\nsub set_doublets {\n    my ($self) = @_;\n    # set the designators in the Bio::Tools::Alignment::Trim object\n\n    $self->{'o_trim'}->set_designators($self->{'reverse_designator'},\n\t\t\t\t       $self->{'forward_designator'});\n    foreach my $key_contig (sort keys %{$self->{'contigs'}}) {\n\n\t# if there is a member array (why would there not be? This should be a die()able offence\n\t# but for now I will leave it\n\tif ($self->{'contigs'}->{$key_contig}->{'member_array'}) {\n\t    # if there are two reads in this contig \n\t    # i am pretty sure that this is wrong but i am keeping it for reference\n\t    # if (@{$self->{'contigs'}->{$key_contig}->{'member_array'}} == 2 || !$self->{'contigs'}->{$key_contig}->{'class'}) {\n\t    # <seconds later>\n\t    # <nod> WRONG. Was I on crack?\n\t    if (@{$self->{'contigs'}->{$key_contig}->{'member_array'}} == 2) {\n\t\t$self->{'contigs'}->{$key_contig}->{'num_members'} = 2;\n\t\t$self->debug(\"\\tThere are 2 members! Looking for the contig name...\\n\");\n\t\tmy $name = _get_contig_name($self,$self->{'contigs'}->{$key_contig}->{'member_array'});\n\t\t$self->debug(\"The name is $name\\n\") if defined $name;\n\t\tif ($name) {\n\t\t    $self->{'contigs'}->{$key_contig}->{'name'} = $name;\n\t\t    $self->{'contigs'}->{$key_contig}->{'class'} = \"doublet\";\n\t\t} else {\n\t\t    $self->debug(\"$key_contig is a pair.\\n\");\n\t\t    $self->{'contigs'}->{$key_contig}->{'class'} = \"pair\";\n\t\t}\n\t    }\n            # this is all fair and good but what about singlets?\n            # they have one reads in the member_array but certainly are not singletons\n\t    elsif (@{$self->{'contigs'}->{$key_contig}->{'member_array'}} == 1) {\n\t\t# set the name to be the name of the read\n\t\t$self->{'contigs'}->{$key_contig}->{name} = @{$self->{'contigs'}->{$key_contig}->{'member_array'}}[0];\n\t\t# set the number of members to be one\n\t\t$self->{'contigs'}->{$key_contig}->{num_members} = 1;\n\t\t# if this was a singlet, it would already belong to the class \"singlet\"\n\t\t# so leave it alone\n\t\t# if it is not a singlet, it is a singleton! lablel it appropriately\n\t\tunless ($self->{'contigs'}->{$key_contig}->{'class'}) {\n\t\t    $self->{'contigs'}->{$key_contig}->{'class'} = \"singleton\";\n\t\t}\n\t    }\n            # set the multiplet characteristics\n\t    elsif (@{$self->{'contigs'}->{$key_contig}->{'member_array'}} >= 3) {\n\t\t$self->{'contigs'}->{$key_contig}->{'num_members'} = @{$self->{'contigs'}->{$key_contig}->{'member_array'}};\n\t\t$self->{'contigs'}->{$key_contig}->{'class'} = \"multiplet\";\n\t    }\n\t    $self->{'contigs'}->{$key_contig}->{'num_members'} = @{$self->{'contigs'}->{$key_contig}->{'member_array'}};\n\n\t}\n    }\n    $self->{'doublets_set'} = \"done\";\n    return 0;\n}\t\t\t\t# end set_doublets\n\n=head2 set_singlets\n\n Title   : set_singlets\n Usage   : $o_consed->set_singlets();\n Function: Read in a singlets file and place them into the\n\t   Bio::Tools::Alignment::Consed object.\n Returns : Nothing.\n Args    : A scalar to turn on verbose parsing of the singlets file.\n Notes   : \n\n\nsub set_singlets {\n    # parse out the contents of the singlets file\n    my ($self) = @_;\n    $self->debug(\"Bio::Tools::Alignment::Consed Adding singlets to the contig hash...\\n\"); \n    my $full_filename = $self->{'filename'};\n    $self->debug(\"Bio::Tools::Alignment::Consed::set_singlets: \\$full_filename is $full_filename\\n\");\n    $full_filename =~ m/(.*\\/)(.*ace.*)$/; \t\t\t       \n    my ($base_path,$filename) = ($1,$2);\n    $self->debug(\"Bio::Tools::Alignment::Consed::set_singlets: singlets filename is $filename and \\$base_path is $base_path\\n\");\n    $filename =~ m/(.*)ace.*$/;\n    my $singletsfile = $base_path.$1.\"singlets\";\n    $self->debug(\"\\$singletsfile is $singletsfile\\n\");\n     if (!-f $singletsfile) {\n          # there is no singlets file.\n          $self->{'singlets_set'} = \"done\";\n          return;\n     }\n\t$self->debug(\"$singletsfile is indeed a file. Trying to open it...\\n\");\n    my $singlets_fh = Bio::Root::IO->new(-file => $singletsfile);\n    my ($sequence,$name,$count);\n    while ($_ = $singlets_fh->_readline()) {\n\tchomp $_;\n\tif (/\\>/) {\n\t    if ($name && $sequence) {\n\t\t$self->debug(\"Adding $name with sequence $sequence to hash...\\n\");\n\t\tpush @{$self->{'contigs'}->{$name}->{'member_array'}},$name;\n\t\t$self->{'contigs'}->{$name}->{'consensus'} = $sequence;\n\t\t$self->{'contigs'}->{$name}->{'name'} = $name;\n\t\t$self->{'contigs'}->{$name}->{\"singlet\"} = 1;\n\t\t$self->{'contigs'}->{$name}->{'class'} = \"singlet\";\n\t    }\n\t    $sequence = $name = undef;\n\t    $count++;\n\t    m/^\\>(.*)\\s\\sCHROMAT/;\n\t    $name = $1;\n\t    if (!$name) {\n\t\tm/\\>(\\S+)\\s/;\n\t\t$name = $1;\n\t    }\n\t}\n\telse { $sequence .= $_; }\t\n    }\n    if ($name && $sequence) {\n\t$self->debug(\"Pushing the last of the singlets ($name)\\n\");\n\t@{$self->{'contigs'}->{$name}->{'member_array'}} = $name;\n\t$self->{'contigs'}->{$name}->{'consensus'} = $sequence;\n\t$self->{'contigs'}->{$name}->{'name'} = $name;\n\t$self->{'contigs'}->{$name}->{\"singlet\"} = 1;\n\t$self->{'contigs'}->{$name}->{'class'} = \"singlet\";\n    }\n    $self->debug(\"Bio::Tools::Alignment::Consed::set_singlets: Done adding singlets to the singlets hash.\\n\");\n    $self->{'singlets_set'} = \"done\";\n    return 0;\n}\t\t\t\t# end sub set_singlets\n\n=head2 get_singlets()\n\n Title   : get_singlets()\n Usage   : $o_consed->get_singlets();\n Function: Return the keynames of the singlets.\n Returns : An array containing the keynames of all \n           Bio::Tools::Alignment::Consed sequences in the class \"singlet\".\n Args    : None.\n Notes   : \n\n\nsub get_singlets {\n    # returns an array of singlet names\n    # singlets have \"singlet\"=1 in the hash\n    my $self = shift;\n    if (!$self->{singlets_set}) {\n\t$self->debug(\"You need to set the singlets before you get them. Doing that now.\");\n\t$self->set_singlets();\n    }\t\n\n    my (@singlets,@array);\n    foreach my $key (sort keys %{$self->{'contigs'}}) {\n\t# @array = @{$Consed::contigs{$key}->{'member_array'}};\n\t# somethimes a user will try to get a list of singlets before the classes for the rest of the\n\t# contigs has been set (see t/test.t for how I figured this out. <bah>\t\t\t\n\t# so either way, just return class=singlets\n\tif (!$self->{'contigs'}->{$key}->{'class'}) {\n\t    # print(\"$key has no class. why?\\n\");\n\t}\n\telsif ($self->{'contigs'}->{$key}->{'class'} eq \"singlet\") {\n\t    push @singlets,$key;\n\t}\n    }\n    return @singlets;\n}\n\n=head2 set_quality_by_name($name,$quality)\n\n Title   : set_quality_by_name($name,$quality)\n Usage   : $o_consed->set_quality_by_name($name,$quality);\n Function: Deprecated. Make the contig with {name} have {'quality'} $quality.\n           Probably used for testing.\n Returns : Nothing.\n Args    : The name of a contig and a scalar for its quality.\n Notes   : Deprecated.\n\n\nsub set_quality_by_name {\n    # this is likely deprecated\n    my ($self,$name,$quality) = shift;\n    my $return;\n    foreach (sort keys %{$self->{'contigs'}}) {\n\tif ($self->{'contigs'} eq \"$name\" || $self->{'contigs'}->{'name'} eq \"$name\") {\n\t    $self->{'contigs'}->{'quality'} = $quality;\n\t    $return=1;\n\t}\n    }\n    if ($return) { return \"0\"; } else { return \"1\"; }\n}\t\t\t\t# end set quality by name\n\n=head2 set_singlet_quality()\n\n Title   : set_singlet_quality()\n Usage   : $o_consed->set_singlet_quality();\n Function: For each singlet, go to the appropriate file in phd_dir and read\n           in the phred quality for that read and place it into {'quality'}\n Returns : 0 or 1.\n Args    : None.\n Notes   : This is the next subroutine that will receive substantial revision\n           in the next little while. It really should eval the creation of\n           Bio::Tools::Alignment::Phred objects and go from there. \n\n\nsub set_singlet_quality {\n    my $self = shift;\n    my $full_filename = $self->{'filename'};\n    $full_filename =~ m/(.*\\/)(.*)ace.*$/;\n    my ($base_path,$filename) = ($1,\"$2\".\"qual\");\n    my $singletsfile = $base_path.$filename;\n    if (-f $singletsfile) {\n\t# print(\"$singletsfile is indeed a file. Trying to open it...\\n\");\n    }\n    else {\n\t$self->warn(\"$singletsfile is not a file. Sorry.\\n\");\n\treturn;\n    }\n\tmy $singlets_fh = Bio::Root::IO->new(-file => $singletsfile);\n\tmy ($sequence,$name,$count);\n    my ($identity,$line,$quality,@qline);\n    while ($line = $singlets_fh->_readline()) {\n\tchomp $line;\n\tif ($line =~ /^\\>/) {\n\t    $quality = undef;\n\t    $line =~ m/\\>(\\S*)\\s/;\n\t    $identity = $1;\n\t}\n\telse {\n\t    if ($self->{'contigs'}->{$identity}) {\n\t\t$self->{'contigs'}->{$identity}->{'quality'} .= \"$line \";\n\t    }\n\t}\n\n    }\n    return 0;\n}\n\n=head2 set_contig_quality()\n\n Title   : set_contig_quality()\n Usage   : $o_consed->set_contig_quality();\n Function: Deprecated.\n Returns : Deprecated.\n Args    : Deprecated.\n Notes   : Deprecated. Really. Trust me.\n\n\nsub set_contig_quality {\n    # note: contigs _include_ singletons but _not_ singlets\n    my ($self) = shift;\n          # the unexpected results I am referring to here are a doubling of quality values.\n          # the profanity I uttered on discovering this reminded me of the simpsons:\n          # Ned Flanders: \"That is the loudest profanity I have ever heard!\"\n     $self->warn(\"set_contig_quality is deprecated and will likely produce unexpected results\");\n    my $full_filename = $self->{'filename'};\n    # Run_SRC3700_2000-08-01_73+74.fasta.screen.contigs.qual\n    # from Consed.pm\n    $full_filename =~ m/(.*\\/)(.*)ace.*$/;\n    my ($base_path,$filename) = ($1,\"$2\".\"contigs.qual\");\n    my $singletsfile = $base_path.$filename;\n    if (-f $singletsfile) {\n\t# print(\"$singletsfile is indeed a file. Trying to open it...\\n\");\n    }\n    else {\n\t$self->warn(\"Bio::Tools::Alignment::Consed::set_contig_quality $singletsfile is not a file. Sorry.\\n\");\n\treturn;\n    }\n    my $contig_quality_fh = Bio::Root::IO->new(-file => $singletsfile);\n\n    my ($sequence,$name,$count,$identity,$line,$quality);\n    while ($line = $contig_quality_fh->_readline()) {\n\tchomp $line;\n\tif ($line =~ /^\\>/) {\n\t    $quality = undef;\n\t    $line =~ m/\\>.*Contig(\\d+)\\s/;\n\t    $identity = $1;\n\t}\n\telse {\n\t    if ($self->{'contigs'}->{$identity} ) {\n\t\t$self->{'contigs'}->{$identity}->{'quality'} .= \" $line\";\n\t    }\n\t}\n    }\n}\t\t\t\t# end set_contig_quality\n\n=head2 get_multiplets()\n\n Title   : get_multiplets()\n Usage   : $o_consed->get_multiplets();\n Function: Return the keynames of the multiplets.\n Returns : Returns an array containing the keynames of all \n           Bio::Tools::Alignment::Consed sequences in the class \"multiplet\".\n Args    : None.\n Notes   : \n\n\nsub get_multiplets {\n\t    # returns an array of multiplet names\n\t    # multiplets have # members > 2\n    my $self = shift;\n    my (@multiplets,@array);\n    foreach my $key (sort keys %{$self->{'contigs'}}) {\n\tif ($self->{'contigs'}->{$key}->{'class'}) {\n\t    if ($self->{'contigs'}->{$key}->{'class'} eq \"multiplet\") {\n\t\tpush @multiplets,$key;\n\t    }\n\t}\n    }\n    return @multiplets;\n}\n\n=head2 get_all_members()\n\n  Title   : get_all_members()\n  Usage   : @all_members = $o_consed->get_all_members();\n  Function: Return a list of all of the read names in the \n            Bio::Tools::Alignment::Consed object.\n  Returns : An array containing all of the elements in all of the\n            {'member_array'}s.\n  Args    : None.\n  Notes   : \n\n\nsub get_all_members {\n    my $self = shift;\n    my @members;\n    foreach my $key (sort keys %{$self->{'contigs'}}) {\n\tif ($key =~ /^singlet/) {\n\t    push @members,$self->{'contigs'}->{$key}->{'member_array'}[0];\n\t}\n\telsif ($self->{'contigs'}->{$key}->{'member_array'}) {\n\t    push @members,@{$self->{'contigs'}->{$key}->{'member_array'}};\n\t}\n\t# else {\n\t#\tprint(\"Bio::Tools::Alignment::Consed: $key is _not_ an array. Pushing $self->{'contigs'}->{$key}->{'member_array'} onto \\@members\\n\");\n\t#\tpush @members,$self->{'contigs'}->{$key}->{'member_array'};\n\t# }\n    }\n    return @members;\n}\n\n=head2 sum_lets($total_only)\n\n Title   : sum_lets($total_only)\n Usage   : $statistics = $o_consed->sum_lets($total_only);\n Function: Provide numbers for how many sequences were accounted for in the\n           Bio::Tools::Alignment::Consed object.\n Returns : If a scalar is present, returns the total number of\n           sequences accounted for in all classes. If no scalar passed\n           then returns a string that looks like this:\n           Singt/singn/doub/pair/mult/total : 2,0,1(2),0(0),0(0),4\n           This example means the following: There were 1 singlets.\n           There were 0 singletons.  There were 1 doublets for a total\n           of 2 sequences in this class.  There were 0 pairs for a\n           total of 0 sequences in this class.  There were 0\n           multiplets for a total of 0 sequences in this class.  There\n           were a total of 4 sequences accounted for in the\n           Bio::Tools::Alignment::Consed object.   \n Args : A scalar is optional to change the way the numbers are returned.  \n Notes:\n\n\nsub sum_lets {\n    my ($self,$total_only) = @_;\n    my ($count,$count_multiplets,$multiplet_count);\n    my $singlets = &get_singlets($self); $count += $singlets;\n    my $doublets = &get_doublets($self); $count += ($doublets * 2);\n    my $pairs = &get_pairs($self); $count += ($pairs * 2);\n    my $singletons = &get_singletons($self); $count += $singletons;\n    my @multiplets = &get_multiplets($self);\n    $count_multiplets = @multiplets;\n    my $return_string;\n    foreach (@multiplets) {\n\tmy $number_members = $self->{'contigs'}->{$_}->{num_members};\t\n\t$multiplet_count += $number_members;\n    }\n    if ($multiplet_count) {\n\t$count += $multiplet_count;\n    }\n    foreach (qw(multiplet_count singlets doublets pairs singletons\n                multiplets count_multiplets)) {\n\tno strict 'refs';\t# renege for the block\n\tif (!${$_}) {\n            ${$_} = 0;\n\t}\n    }\n    if (!$multiplet_count) { $multiplet_count = 0; }\n    if ($total_only) {\n        return $count;\n    }\n    $return_string = \"Singt/singn/doub/pair/mult/total : \".\n        \"$singlets,$singletons,$doublets(\".\n         ($doublets*2).\"),$pairs(\".($pairs*2).\n        \"),$count_multiplets($multiplet_count),$count\";\n    return $return_string;\n}\n\n=head2 write_stats()\n\n Title   : write_stats()\n Usage   : $o_consed->write_stats();\n Function: Write a file called \"statistics\" containing numbers similar to\n\t   those provided in sum_lets().\n Returns : Nothing. Write a file in $o_consed->{path} containing something\n\t   like this:\n\n           0,0,50(100),0(0),0(0),100\n\n           Where the numbers provided are in the format described in the\n\t   documentation for sum_lets().\n Args    : None.\n Notes   : This might break platform independence, I do not know.\n\nSee L<sum_lets()|sum_lets>\n\n\nsub write_stats {\n    # worry about platform dependence here?\n    # oh shucksdarn.\n    my $self = shift;\n    my $stats_filename = $self->{'path'}.\"statistics\";\n    my $statistics_raw = $self->sum_lets;\n    my ($statsfilecontents) = $statistics_raw =~ s/.*\\ \\:\\ //g;\n    umask 0001;\n    my $fh = Bio::Root::IO->new(-file=>\"$stats_filename\");\n    # open(STATSFILE,\">$stats_filename\") or print(\"Could not open the statsfile: $!\\n\");\n    $fh->_print(\"$statsfilecontents\");\n    # close STATSFILE;\n    $fh->close();\n}\n\n=head2 get_singletons()\n\n Title   : get_singletons()\n Usage   : @singletons = $o_consed->get_singletons();\n Function: Return the keynames of the singletons.\n Returns : Returns an array containing the keynames of all\n\t   Bio::Tools::Alignment::Consed sequences in the class \"singleton\".\n Args    : None.\n Notes   : \n\n\nsub get_singletons {\n\t\t# returns an array of singleton names\n\t\t# singletons are contigs with one member (see consed documentation)\n\tmy $self = shift;\n\tmy (@singletons,@array);\n\tforeach my $key (sort keys %{$self->{'contigs'}}) {\n\t\tif ($self->{'contigs'}->{$key}->{'class'}) {\n\t\t    # print (\"$key class: $self->{'contigs'}->{$key}->{'class'}\\n\");\n\t\t}\n\t\telse {\n\t\t    # print(\"$key belongs to no class. why?\\n\");\n\t\t}\n\t\tif ($self->{'contigs'}->{$key}->{'member_array'}) {\n\t\t\t@array = @{$self->{'contigs'}->{$key}->{'member_array'}};\n\t\t}\n\t\tmy $num_array_elem = @array;\n\t\tif ($num_array_elem == 1 && $self->{'contigs'}->{$key}->{'class'} && $self->{'contigs'}->{$key}->{'class'} eq \"singleton\") { push @singletons,$key; }\n\t}\n\treturn @singletons;\n}\n\n=head2 get_pairs()\n\n Title   : get_pairs()\n Usage   : @pairs = $o_consed->get_pairs();\n Function: Return the keynames of the pairs.\n Returns : Returns an array containing the keynames of all\n           Bio::Tools::Alignment::Consed sequences in the class \"pair\".\n Args    : None.\n Notes   : \n\n\nsub get_pairs {\n    # returns an array of pair contig names\n    # a pair is a contig of two where the names do not match\n    my $self = shift;\n    my (@pairs,@array);\n    foreach my $key (sort keys %{$self->{'contigs'}}) {\n        if ($self->{'contigs'}->{$key}->{'member_array'}) {\n            if (@{$self->{'contigs'}->{$key}->{'member_array'}} == 2 &&\n                $self->{'contigs'}->{$key}->{'class'} eq \"pair\") {\n                push @pairs,$key;\n            }\n        }\n    }\n    return @pairs;\n}\n\n=head2 get_name($contig_keyname)\n\n Title   : get_name($contig_keyname)\n Usage   : $name = $o_consed->get_name($contig_keyname);\n Function: Return the {name} for $contig_keyname.\n Returns : A string. ({name})\n Args    : A contig keyname.\n Notes   : "},"detail":"($self,$contig)","definition":"sub","containerName":"main::"},{"line":1426,"children":[{"line":1427,"kind":13,"localvar":"my","containerName":"_get_contig_name","name":"$self","definition":"my"},{"containerName":"_get_contig_name","name":"$r_array","line":1427,"kind":13},{"kind":13,"line":1428,"containerName":"_get_contig_name","name":"@contig_members","definition":"my","localvar":"my"},{"line":1428,"kind":13,"containerName":"_get_contig_name","name":"$r_array"},{"name":"@name_nodir","definition":"my","containerName":"_get_contig_name","localvar":"my","kind":13,"line":1429},{"name":"@contig_members","containerName":"_get_contig_name","line":1430,"kind":13},{"localvar":"my","containerName":"_get_contig_name","name":"$forward_designator","definition":"my","line":1434,"kind":13},{"line":1434,"kind":13,"containerName":"_get_contig_name","name":"$self"},{"kind":13,"line":1435,"containerName":"_get_contig_name","name":"$reverse_designator","definition":"my","localvar":"my"},{"name":"$self","containerName":"_get_contig_name","kind":13,"line":1435},{"kind":13,"line":1436,"definition":"my","name":"$any_hits","containerName":"_get_contig_name","localvar":"my"},{"containerName":"_get_contig_name","name":"$name","definition":"my","localvar":"my","kind":13,"line":1437},{"line":1438,"kind":13,"localvar":"my","definition":"my","name":"$suffix","containerName":"_get_contig_name"},{"containerName":"_get_contig_name","name":"$name","line":1439,"kind":13},{"name":"$suffix","containerName":"_get_contig_name","kind":13,"line":1442},{"name":"$suffix","containerName":"_get_contig_name","kind":13,"line":1446},{"containerName":"_get_contig_name","name":"$suffix","line":1447,"kind":13},{"containerName":"_get_contig_name","name":"$suffix","line":1447,"kind":13},{"name":"@name_nodir","containerName":"_get_contig_name","kind":13,"line":1448},{"kind":13,"line":1448,"name":"$name","containerName":"_get_contig_name"},{"name":"@name_nodir","containerName":"_get_contig_name","line":1452,"kind":13},{"kind":13,"line":1457,"name":"$mismatch","definition":"my","containerName":"_get_contig_name","localvar":"my"},{"containerName":"_get_contig_name","name":"$counter","definition":"my","localvar":"my","kind":13,"line":1458},{"kind":13,"line":1458,"name":"$counter","containerName":"_get_contig_name"},{"kind":13,"line":1458,"name":"@name_nodir","containerName":"_get_contig_name"},{"line":1458,"kind":13,"containerName":"_get_contig_name","name":"$counter"},{"kind":13,"line":1459,"name":"$name_nodir","containerName":"_get_contig_name"},{"kind":13,"line":1459,"name":"$name_nodir","containerName":"_get_contig_name"},{"name":"$counter","containerName":"_get_contig_name","line":1459,"kind":13},{"kind":13,"line":1460,"containerName":"_get_contig_name","name":"$mismatch"},{"line":1462,"kind":13,"containerName":"_get_contig_name","name":"$mismatch"},{"name":"$name_nodir","containerName":"_get_contig_name","kind":13,"line":1464}],"kind":12,"detail":"($self,$r_array)","signature":{"parameters":[{"label":"$self"},{"label":"$r_array"}],"documentation":"1;\n# $Id: Consed.pm 16123 2009-09-17 12:57:27Z cjfields $\n# Bio::Tools::Alignment::Consed\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chad Matsalla\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Alignment::Consed - A module to work with objects from consed .ace files\n\n=head1 SYNOPSIS\n\n  # a report for sequencing stuff\n  my $o_consed = Bio::Tools::Alignment::Consed->new( \n      -acefile => \"/path/to/an/acefile.ace.1\",\n      -verbose => 1);\n  my $foo = $o_consed->set_reverse_designator(\"r\");\n  my $bar = $o_consed->set_forward_designator(\"f\");\n\n  # get the contig numbers\n  my @keys = $o_consed->get_contigs();\n\n  # construct the doublets\n  my $setter_doublets = $o_consed->choose_doublets();\n\n  # get the doublets\n  my @doublets = $o_consed->get_doublets();\n\n=head1 DESCRIPTION\n\nL<Bio::Tools::Alignment::Consed> provides methods and objects to deal\nwith the output from the Consed software suite. Specifically,\ntakes an C<.ace> file and provides objects for the results.\n\nA word about doublets: This module was written to accomodate a large\nEST sequencing operation. In this case, EST's were sequenced from the\n3' and from the 5' end of the EST. The objective was to find a\nconsensus sequence for these two reads.  Thus, a contig of two is what\nwe wanted, and this contig should consist of the forward and reverse\nreads of a getn clone. For example, for a forward designator of \"F\"\nand a reverse designator of \"R\", if the two reads chad1F and chad1R\nwere in a single contig (for example Contig 5) it will be determined\nthat the consensus sequence for Contig 5 will be the sequence for\nclone chad1.\n\nDoublets are good!\n\nThis module parses C<.ace> and related files. A detailed list of methods\ncan be found at the end of this document.\n\nI wrote a detailed rationale for design that may explain the reasons\nwhy some things were done the way they were done. That document is\nbeyond the scope of this pod and can probably be found in the\ndirectory from which this module was 'made' or at\nL<http://www.dieselwurks.com/bioinformatics/consedpm_documentation.pdf>.\n\nNote that the POD in that document might be old but the original\nrationale still stands.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nEmail chad-at-dieselwurks.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n#' \n\npackage Bio::Tools::Alignment::Consed;\n\nuse strict;\n\nuse FileHandle;\nuse Dumpvalue qw(dumpValue);\nuse Bio::Tools::Alignment::Trim;\nuse File::Spec;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\nour %DEFAULTS = ( 'f_designator' => 'f',\n\t\t  'r_designator' => 'r');\n\n=head2 new()\n\n Title   : new(-acefile => $path_to_some_acefile, -verbose => \"1\")\n Usage   : $o_consed = Bio::Tools::Alignment::Consed->\n              new(-acefile => $path_to_some_acefile, -verbose => \"1\");\n Function: Construct the Bio::Tools::Alignment::Consed object. Sets\n\t   verbosity for the following procedures, if necessary:\n\t   1. Construct a new Bio::Tools::Alignment::Trim object, to\n\t   handle quality trimming 2. Read in the acefile and parse it\n\n Returns : A reference to a Bio::Tools::Alignment::Consed object.\n Args    : A hash. (-acefile) is the filename of an acefile. If a full path\n\t   is not specified \"./\" is prepended to the filename and used from\n\t   instantiation until destruction. If you want \n           Bio::Tools::Alignment::Consed to be noisy during parsing of\n           the acefile, specify some value for (-verbose).\n\n\nsub new {\n    my ($class,%args) = @_;\n    my $self = $class->SUPER::new(%args);\n\n    $self->{'filename'} = $args{'-acefile'};\n\n    # this is special to UNIX and should probably use catfile : DONE!\n#    if (!($self->{'filename'} =~ m{/})) { \n#\t$self->{'filename'} = \"./\".$self->{'filename'}; \n#    } \n#    $self->{'filename'} =~ m/(.*\\/)(.*)ace.*$/;\n#    $self->{'path'} = $1;\n\n    # this is more generic and should work on most systems   \n    (undef, $self->{'path'}, undef) = File::Spec->splitpath($self->{'filename'});\n\n    $self->_initialize_io('-file'=>$self->{'filename'});\n    $self->{'o_trim'} = Bio::Tools::Alignment::Trim->new(-verbose => $self->verbose());\n    $self->set_forward_designator($DEFAULTS{'f_designator'});\n    $self->set_reverse_designator($DEFAULTS{'r_designator'});\n\n    $self->_read_file();\n    return $self;\n}\n\n=head2 set_verbose()\n\n Title   : set_verbose()\n Usage   : $o_consed->set_verbose(1);\n Function: Set the verbosity level for debugging messages. On instantiation\n\t   of the Bio::Tools::Alignment::Consed object the verbosity level\n           is set to 0 (quiet).\n Returns : 1 or 0.\n Args    : The verbosity levels are:\n\t      0 - quiet\n\t      1 - noisy\n\t      2 - noisier\n\t      3 - annoyingly noisy\n\nThis method for setting verbosity has largely been superseeded by a\nsub-by-sub way, where for every sub you can provide a (-verbose)\nswitch. I am doing converting this bit-by-bit so do not be surprised\nif some subs do not honour this.\n\n\n# from RootI\n\n# backwards compat\nsub set_verbose { (shift)->verbose(@_) }\n\n=head2 get_filename()\n\n Title   : get_filename()\n Usage   : $o_consed->get_filename();\n Function: Returns the name of the acefile being used by the\n\t   Bio::Tools::Alignment::Consed object.\n Returns : A scalar containing the name of a file.\n Args    : None.\n\n\n\nsub get_filename {\n    my $self = shift;\n    return $self->{'filename'};\n}\n\n=head2 count_sequences_with_grep()\n\n Title   : count_sequences_with_grep()\n Usage   : $o_consed->count_sequences_with_grep();\n Function: Use /bin/grep to scan through the files in the ace project dir\n\t   and count sequences in those files. I used this method in the\n\t   development of this module to verify that I was getting all of the\n\t   sequences. It works, but it is (I think) unix-like platform\n\t   dependent.\n Returns : A scalar containing the number of sequences in the ace project\n\t   directory.\n Args    : None.\n\nIf you are on a non-UNIX platform, you really do not have to use\nthis. It is more of a debugging routine designed to address very\nspecific problems.\n\nThis method was reimplemented to be platform independent with a pure\nperl implementation.  The above note can be ignored.\n\n\nsub count_sequences_with_grep {\n    my $self = shift;\n    my ($working_dir,$grep_cli,@total_grep_sequences);\n    # this should be migrated to a pure perl implementation ala\n    # Tom Christiansen's 'tcgrep'\n    # http://www.cpan.org/modules/by-authors/id/TOMC/scripts/tcgrep.gz\n\n    open(my $FILE, $self->{'filename'}) or do { $self->warn(\"cannot open file \".$self->{'filename'}. \" for grepping\"); return}; \n    my $counter =0;\n    while(<$FILE>) { $counter++ if(/^AF/); }\n\n    close $FILE;\n    opendir(my $SINGLETS,$self->{'path'});\n    foreach my $f ( readdir($SINGLETS) ) {\n\tnext unless ($f =~ /\\.singlets$/); \n\topen(my $FILE, File::Spec->catfile($self->{'path'},$f)) or do{ $self->warn(\"cannot open file \".File::Spec->catfile($self->{'path'},$f)); next };\n\twhile(<$FILE>) { $counter++ if(/^>/) }\n\tclose $FILE;\n    }\n    return $counter;\n}\n\n=head2 get_path()\n\n Title   : get_path()\n Usage   : $o_consed->get_path();\n Function: Returns the path to the acefile this object is working with.\n Returns : Scalar. The path to the working acefile.\n Args    : None.\n\n\nsub get_path {\n    my $self = shift;\n    return $self->{'path'};\n}\n\n=head2 get_contigs()\n\n Title   : get_contigs()\n Usage   : $o_consed->get_contigs();\n Function: Return the keys to the Bio::Tools::Alignment::Consed object.\n Returns : An array containing the keynames in the\n           Bio::Tools::Alignment::Consed object.\n Args    : None.\n\nThis would normally be used to get the keynames for some sort of\niterator. These keys are worthless in general day-to-day use because\nin the Consed acefile they are simply Contig1, Contig2, ...\n\n\nsub get_contigs {\n    my ($self,$contig) = @_;\n    my @contigs = sort keys %{$self->{'contigs'}};\n    return @contigs;\n}\n\n=head2 get_class($contig_keyname)\n\n Title   : get_class($contig_keyname)\n Usage   : $o_consed->get_class($contig_keyname);\n Function: Return the class name for this contig\n Returns : A scalar representing the class of this contig.\n Args    : None.\n Notes   : \n\n\nsub get_class {\n    my ($self,$contig) = @_;\n    return $self->{contigs}->{$contig}->{class};\n}\n\n=head2 get_quality_array($contig_keyname)\n\n Title   : get_quality_array($contig_keyname)\n Usage   : $o_consed->get_quality_array($contig_keyname);\n Function: Returns the quality for the consensus sequence for the given\n\t   contig as an array. See get_quality_scalar to get this as a scalar.\n Returns : An array containing the quality for the consensus sequence with\n\t   the given keyname.\n Args    : The keyname of a contig. Note: This is a keyname. The key would\n\t   normally come from get_contigs.\n\nReturns an array, not a reference. Is this a bug? I<thinking> No.\nWell, maybe.  Why was this developed like this? I was using FreezeThaw\nfor object persistence, and when it froze out these arrays it took a\nlong time to thaw it. Much better as a scalar.\n\nSee L<get_quality_scalar()|get_quality_scalar>\n\n\nsub get_quality_array {\n    my ($self,$contig) = @_;\n    return split ' ', $self->{contigs}->{$contig}->{quality};\n}\n\n=head2 get_quality_scalar($contig_keyname)\n\n Title   : get_quality_scalar($contig_keyname)\n Usage   : $o_consed->get_quality_scalar($contig_keyname);\n Function: Returns the quality for the consensus sequence for the given\n\t   contig as a scalar. See get_quality_array to get this as an array.\n Returns : An scalar containing the quality for the consensus sequence with\n           the given keyname.\n Args    : The keyname of a contig. Note this is a _keyname_. The key would\n\t   normally come from get_contigs.\n\nWhy was this developed like this? I was using FreezeThaw for object\npersistence, and when it froze out these arrays it took a coon's age\nto thaw it. Much better as a scalar.\n\nSee L<get_quality_array()|get_quality_array>\n\n\n#'\nsub get_quality_scalar {\n    my ($self,$contig) = @_;\n    return $self->{'contigs'}->{$contig}->{'quality'};\n}\n\n=head2 freeze_hash()\n\n Title   : freeze_hash()\n Usage   : $o_consed->freeze_hash();\n\n Function: Use Ilya's FreezeThaw module to create a persistent data\n\t   object for this Bio::Tools::Alignment::Consed data\n\t   structure. In the case of AAFC, we use\n\t   Bio::Tools::Alignment::Consed to pre-process bunches of\n\t   sequences, freeze the structures, and send in a harvesting\n\t   robot later to do database stuff.\n Returns : 0 or 1;\n Args    : None.\n\nThis procedure was removed so Consed.pm won't require FreezeThaw.\n\n\n#'\nsub freeze_hash {\n    my $self = shift;\n    $self->warn(\"This method (freeze_hash) was removed \".\n                \"from the bioperl consed.pm. Sorry.\\n\");\n    if (1==2) {\n        $self->debug(\"Bio::Tools::Alignment::Consed::freeze_hash:\".\n                     \" \\$self->{path} is $self->{path}\\n\");\n        my $filename = $self->{'path'}.\"frozen\";\n        my %contigs = %{$self->{'contigs'}};\n        my $frozen = freeze(%contigs);\n        umask 0001;\n        open (my $FREEZE,\">$filename\") or do {\n            $self->warn( \"Bio::Tools::Alignment::Consed could not \".\n                         \"freeze the contig hash because the file \".\n                         \"($filename) could not be opened: $!\\n\");\n            return 1;\n        };\n        print $FREEZE $frozen;\n        return 0;\n    }\n}\n\n=head2 get_members($contig_keyname)\n\n Title   : get_members($contig_keyname)\n Usage   : $o_consed->get_members($contig_keyname);\n Function: Return the _names_ of the reads in this contig.\n Returns : An array containing the names of the reads in this contig.\n Args    : The keyname of a contig. Note this is a keyname. The keyname\n\t   would normally come from get_contigs.\n\nSee L<get_contigs()|get_contigs>\n\n\nsub get_members {\n    my ($self,$contig) = @_;\n    if (!$contig) {\n\t$self->warn(\"You need to provide the name of a contig to \".\n                    \"use Bio::Tools::Alignment::Consed::get_members!\\n\");\n\treturn;\n    }\n    return @{$self->{'contigs'}->{$contig}->{'member_array'}};\n}\n\n=head2 get_members_by_name($some_arbitrary_name)\n\n Title   : get_members_by_name($some_arbitrary_name)\n Usage   : $o_consed->get_members_by_name($some_arbitrary_name);\n Function: Return the names of the reads in a contig. This is the name given\n\t   to $contig{key} based on what is in the contig. This is different\n\t   from the keys retrieved through get_contigs().\n Returns : An array containing the names of the reads in the contig with this\n\t   name.\n Args    : The name of a contig. Not a key, but a name.\n\nHighly inefficient. use some other method if possible.\nSee L<get_contigs()|get_contigs>\n\n\nsub get_members_by_name {\n    my ($self,$name) = @_;\n    # build a list to try to screen for redundancy\n    my @contigs_with_that_name;\n    foreach my $currkey ( sort keys %{$self->{'contigs'}} ) {\n\tnext if (!$self->{'contigs'}->{$currkey}->{'name'});\n\tif ($self->{'contigs'}->{$currkey}->{'name'} eq \"$name\") {\n\t    push @contigs_with_that_name,$currkey;\n\t}\n    }\n    my $count = @contigs_with_that_name;\n    if ($count == 1) {\n\tmy $contig_num = $contigs_with_that_name[0];\n\treturn @{$self->{'contigs'}->{$contig_num}->{'member_array'}};\n    }\n}\n\n=head2 get_contig_number_by_name($some_arbitrary_name)\n\n Title   : get_contig_number_by_name($some_arbitrary_name)\n Usage   : $o_consed->get_contig_number_by_name($some_arbitrary_name);\n Function: Return the names of the reads in a contig. This is the name given\n\t   to $contig{key} based on what is in the contig. This is different\n\t   from the keys retrieved through get_contigs().\n Returns : An array containing the names of the reads in the contig with this\n\t   name.\n Args    : The name of a contig. Not a key, but a name.\n\nSee L<get_contigs()|get_contigs>\n\n\nsub get_contig_number_by_name {\n    my ($self,$name) = @_;\n    foreach my $currkey (sort keys %{$self->{'contigs'}}) {\n\tif ($self->{'contigs'}->{$currkey}->{'name'} && \n\t    $self->{'contigs'}->{$currkey}->{'name'} eq \"$name\") {\n\t    return $currkey;\n\t}\n    }\n}\t\n\n=head2 get_sequence($contig_keyname)\n\n Title   : get_sequence($contig_keyname)\n Usage   : $o_consed->get_sequence($contig_keyname); \n Function: Returns the consensus sequence for a given contig.\n Returns : A scalar containing a sequence.\n Args    : The keyname of a contig. Note this is a key. The key would\n\t   normally come from get_contigs.\n\nSee L<get_contigs()|get_contigs>\n\n\nsub get_sequence {\n    my ($self,$contig) = @_;\n    return $self->{'contigs'}->{$contig}->{'consensus'};\n}\n\n=head2 set_final_sequence($some_sequence)\n\n Title   : set_final_sequence($name,$some_sequence)\n Usage   : $o_consed->set_final_sequence($name,$some_sequence);\n Function: Provides a manual way to set the sequence for a given key in the\n\t   contig hash. Rarely used.\n Returns : 0 or 1;\n Args    : The name (not the keyname) of a contig and an arbitrary string.\n\nA method with a questionable and somewhat mysterious origin. May raise\nthe dead or something like that.\n\n\nsub set_final_sequence {\n    my ($self,$name,$sequence) = @_;\n    if (!$self->{'contigs'}->{$name}) {\n\t$self->warn(\"You cannot set the final sequence for \".\n                    \"$name because it doesn't exist!\\n\");\n\treturn 1;\n    }\n    else {\n\t$self->{'contigs'}->{$name}->{'final_sequence'} = $sequence;\n    }\n    return 0;\n}\n\n=head2  _read_file()\n\n Title   : _read_file();\n Usage   : _read_file();\n Function: An internal subroutine used to read in an acefile and parse it\n\t   into a Bio::Tools::Alignment::Consed object.\n Returns : 0 or 1.\n Args    : Nothing.\n\nThis routine creates and saves the filhandle for reading the files in\n{fh}\n\n\nsub _read_file {\n    my ($self) = @_;\n    my ($line,$in_contig,$in_quality,$contig_number,$top);\n    # make it easier to type $fhl\n    while (defined($line=$self->_readline()) ) {\n\tchomp $line;\n\t# check if there is anything on this line\n\t# if not, you can stop gathering consensus sequence\n\tif (!$line) {\n\t    # if the line is blank you are no longer to gather consensus \n\t    # sequence or quality values\n\t    $in_contig = 0;\n\t    $in_quality = 0;\n\t}\n\t# you are currently gathering consensus sequence\n\telsif ($in_contig) {\n\t    if ($in_contig == 1) {\n\t\t$self->debug(\"Adding $line to consensus of contig number $contig_number.\\n\");\n\t\t$self->{'contigs'}->{$contig_number}->{'consensus'} .= $line;\n\t    }\n\t}\n\telsif ($in_quality) {\n\t    if (!$line) {\n\t\t$in_quality = undef;\n\t    }\n\t    else {\n\n\t\t# I wrote this in here because acefiles produced by\n\t\t# cap3 do not have a leading space like the acefiles\n\t\t# produced by phrap and there is the potential to have\n\t\t# concatenated quality values like this: 2020 rather\n\t\t# then 20 20 whre lines collide. Thanks Andrew for\n\t\t# noticing.\n\n\t\tif ($self->{'contigs'}->{$contig_number}->{'quality'} &&\n                    !($self->{'contigs'}->{$contig_number}->{'quality'} =~ m/\\ $/)) {\n\t\t    $self->{'contigs'}->{$contig_number}->{'quality'} .= \" \";\n\t\t}\n\t\t$self->{'contigs'}->{$contig_number}->{'quality'} .= $line;\n\t    }\n\t}\n\telsif ($line =~ /^BQ/) {\n\t    $in_quality = 1;\n\t}\n\n\t# the line /^CO/ like this:\n\t# CO Contig1 796 1 1 U\n\t# can be broken down as follows:\n\t# CO - Contig!\n\t# Contig1 - the name of this contig\n\t# 796 - Number of bases in this contig\n\t# 1 - Number of reads in this contig\n\t# 1 - number of base segments in this contig\n\t# U - Uncomplemented\n\n\telsif ($line =~ /^CO/) {\n\t    $line =~ m/^CO\\ Contig(\\d+)\\ \\d+\\ \\d+\\ \\d+\\ (\\w)/;\n\t    $contig_number = $1;\n\t    if ($2 eq \"C\") {\n\t\t$self->debug(\"Contig $contig_number is complemented!\\n\");\n\t    }\n\t    $self->{'contigs'}->{$contig_number}->{'member_array'} = [];\n\t    $self->{'contigs'}->{$contig_number}->{'contig_direction'} = \"$2\";\n\t    $in_contig = 1;\n\t}\n\n\t# 000713\n\t# this BS is deprecated, I think.\n\t# haha, I am really witty. <ew>\n\n\telsif ($line =~ /^BSDEPRECATED/) {\n\t    $line =~ m/^BS\\s+\\d+\\s+\\d+\\s+(.+)/;\n\t    my $member = $1;\n\t    $self->{'contigs'}->{$contig_number}->{$member}++;\n\t}\n\t# the members of the contigs are determined by the AF line in the ace file\n\telsif ($line =~ /^AF/) {\n\t    $self->debug(\"I see an AF line here.\\n\");\n\t    $line =~ /^AF\\ (\\S+)\\ (\\w)\\ (\\S+)/;\n\n            # push the name of the current read onto the member array for this contig\n\t    push @{$self->{'contigs'}->{$contig_number}->{'member_array'}},$1;\n\n            # the first read in the contig will be named the \"top\" read\n\t    if (!$top) {\n\t\t$self->debug(\"\\$top is not set.\\n\");\n\t\tif ($self->{'contigs'}->{$contig_number}->{'contig_direction'} eq \"C\") {\n\t\t    $self->debug(\"Reversing the order of the reads. The bottom will be $1\\n\");\n\n\t\t    # if the contig sequence is marked as the\n\t\t    # complement, the top becomes the bottom and$\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_name'} = $1;\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_complement'} = $2;\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_start'} = $3;\n\t\t}\n\t\telse {\n\t\t    $self->debug(\"NOT reversing the order of the reads. \".\n                                 \"The top_name will be $1\\n\");\n\t\t    # if the contig sequence is marked as the\n\t\t    # complement, the top becomes the bottom and$\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_name'} = $1;\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_complement'} = $2;\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_start'} = $3;\n\t\t}\n\t\t$top = 1;\n\t    }\n\t    else {\n\n\t\t# if the contig sequence is marked as the complement,\n\t\t# the top becomes the bottom and the bottom becomes\n\t\t# the top\n\t\tif ($self->{'contigs'}->{$contig_number}->{'contig_direction'} eq \"C\") {\n\t\t    $self->debug(\"Reversing the order of the reads. The top will be $1\\n\");\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_name'} = $1;\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_complement'} = $2;\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_start'} = $3;\n\t\t}\n\t\telse {\n\t\t    $self->debug(\"NOT reversing the order of the reads. The bottom will be $1\\n\");\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_name'} = $1;\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_complement'} = $2;\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_start'} = $3;\n\t\t}\n\t\t$top = undef;\n\t    }\n\t}\n    }\n    return 0;\n}\n\n=head2 set_reverse_designator($some_string)\n\n Title   : set_reverse_designator($some_string)\n Usage   : $o_consed->set_reverse_designator($some_string);\n Function: Set the designator for the reverse read of contigs in this\n\t   Bio::Tools::Alignment::Consed object. Used to determine if\n           contigs containing two reads can be named.\n Returns : The value of $o_consed->{reverse_designator} so you can check\n\t   to see that it was set properly.\n Args    : An arbitrary string.\n\nMay be useful only to me. I<shrug>\n\n\nsub set_reverse_designator {\n    my ($self,$reverse_designator) = @_;\n    $self->{'reverse_designator'} = $reverse_designator;\n    $self->{'o_trim'}->set_reverse_designator($reverse_designator);\n    return $self->{'reverse_designator'};\n}\t\t\t\t# end set_reverse_designator\n\n=head2 set_forward_designator($some_string)\n\n Title   : set_forward_designator($some_string)\n Usage   : $o_consed->set_forward_designator($some_string);\n Function: Set the designator for the forward read of contigs in this\n\t   Bio::Tools::Alignment::Consed object. Used to determine if\n           contigs containing two reads can be named.\n Returns : The value of $o_consed->{forward_designator} so you can check\n\t   to see that it was set properly.\n Args    : An arbitrary string.\n\nMay be useful only to me. I<shrug>\n\n\nsub set_forward_designator {\n    my ($self,$forward_designator) = @_;\n    $self->{'forward_designator'} = $forward_designator;\n    $self->{'o_trim'}->set_forward_designator($forward_designator);\n    return $self->{'forward_designator'};\n}\t\t\t\t# end set_forward_designator\n\n=head2 set_designator_ignore_case(\"yes\")\n\n Title   : set_designator_ignore_case(\"yes\")\n Usage   : $o_consed->set_designator_ignore_case(\"yes\");\n Function: Deprecated.\n Returns : Deprecated.\n Args    : Deprecated.\n\nDeprecated. Really. Trust me.\n\n\nsub set_designator_ignore_case {\n    my ($self,$ignore_case) = @_;\n    if ($ignore_case eq \"yes\") {\n\t$self->{'designator_ignore_case'} = 1;\n    }\n    return $self->{'designator_ignore_case'};\n}\t\t\t\t# end set_designator_ignore_case\n\n=head2 set_trim_points_singlets_and_singletons()\n\n Title   : set_trim_points_singlets_and_singletons()\n Usage   : $o_consed->set_trim_points_singlets_and_singletons();\n Function: Set the trim points for singlets and singletons based on\n\t   quality.  Uses the Bio::Tools::Alignment::Trim object. Use\n\t   at your own risk because the Bio::Tools::Alignment::Trim\n\t   object was designed specifically for me and is mysterious\n\t   in its ways. Every time somebody other then me uses it a\n\t   swarm of locusts decends on a small Central American\n\t   village so do not say you weren't warned.\n Returns : Nothing.\n Args    : None.\n\nWorking on exceptions and warnings here.\n\nSee L<Bio::Tools::Alignment::Trim> for more information\n\n\n#' to make my emacs happy\n\nsub set_trim_points_singlets_and_singletons {\n    my ($self) = @_;\n    $self->debug(\"Consed.pm : \\$self is $self\\n\");\n    my (@points,$trimmed_sequence);\n    if (!$self->{'doublets_set'}) {\n        $self->debug(\"You need to set the doublets before you use \".\n                     \"set_trim_points_singlets_and_doublets. Doing that now.\");\n\t$self->set_doublets();\n    }\n    foreach (sort keys %{$self->{'contigs'}}) {\n\tif ($self->{'contigs'}->{$_}->{'class'} eq \"singlet\") {\n\t    $self->debug(\"Singlet $_\\n\");\n\t    # this is what Warehouse wants\n\t    #         my ($self,$sequence,$quality,$name) = @_;\n\t    # this is what Bio::Tools::Alignment::Trim::trim_singlet wants:\n\t    # my ($self,$sequence,$quality,$name,$class) = @_;\n\t    # the following several lines are to make the parameter passing legible.\n\t    my ($sequence,$quality,$name,$class);\n\t    $sequence = $self->{'contigs'}->{$_}->{'consensus'};\n\t    if (!$self->{'contigs'}->{$_}->{'quality'}) { $quality = \"unset\"; }\n\t    else { $quality = $self->{'contigs'}->{$_}->{'quality'}; }\n\t    $name = $self->{'contigs'}->{$_}->{'name'};\n\t    $class = $self->{'contigs'}->{$_}->{'class'};\n\t    @points = @{$self->{'o_trim'}->trim_singlet($sequence,$quality,$name,$class)};\n\t    $self->{'contigs'}->{$_}->{'start_point'} = $points[0];\n\t    $self->{'contigs'}->{$_}->{'end_point'} = $points[1];\n\t    $self->{'contigs'}->{$_}->{'sequence_trimmed'} = \n                substr($self->{contigs}->{$_}->{'consensus'},$points[0],$points[1]-$points[0]);\n\t}\n    }\n    $self->debug(\"Bio::Tools::Alignment::Consed::set_trim_points_singlets\".\n                 \"_and_singletons: Done setting the quality trimpoints.\\n\");\n    return;\n}  # end set_trim_points_singlet\n\n=head2 set_trim_points_doublets()\n\n Title   : set_trim_points_doublets()\n Usage   : $o_consed->set_trim_points_doublets();\n Function: Set the trim points for doublets based on quality. Uses the\n\t   Bio::Tools::Alignment::Trim object. Use at your own risk because\n           the Bio::Tools::Alignment::Trim object was designed specifically\n           for me and is mysterious in its ways. Every time somebody other\n           then me uses it you risk a biblical plague being loosed on your\n           city.\n Returns : Nothing.\n Args    : None.\n Notes   : Working on exceptions here.\n\nSee L<Bio::Tools::Alignment::Trim> for more information\n\n\nsub set_trim_points_doublets {\n    my $self = shift;\n    my @points;\n    $self->debug(\"Bio::Tools::Alignment::Consed::set_trim_points_doublets:\".\n                 \" Restoring zeros for doublets.\\n\");\n    # &show_missing_sequence($self);\n    $self->debug(\"Bio::Tools::Alignment::Consed::set_trim_points_doublets:\".\n                 \" Setting doublet trim points.\\n\");\n    foreach (sort keys %{$self->{'contigs'}}) {\n\tif ($self->{'contigs'}->{$_}->{'class'} eq \"doublet\") {\n            # my ($self,$sequence,$quality,$name,$class) = @_;\n            my @quals = split(' ',$self->{'contigs'}->{$_}->{'quality'});\n\n\t    @points = $self->{o_trim}->trim_doublet\n                ($self->{'contigs'}->{$_}->{'consensus'},\n                 $self->{'contigs'}->{$_}->{'quality'},\n                 $self->{'contigs'}->{$_}->{name},\n                 $self->{'contigs'}->{$_}->{'class'});\n\t    $self->{'contigs'}->{$_}->{'start_point'} = $points[0];\n\t    $self->{'contigs'}->{$_}->{'end_point'} = $points[1];\n            # now set this\n\t    $self->{'contigs'}->{$_}->{'sequence_trimmed'} =\n                substr($self->{contigs}->{$_}->{'consensus'},\n                       $points[0],$points[1]-$points[0]);\n\t    # 010102 the deprecated way to do things:\n\t}\n    }\n    $self->debug(\"Bio::Tools::Alignment::Consed::set_trim_points_doublets:\".\n                 \" Done setting doublet trim points.\\n\"); \n    return;\n} # end set_trim_points_doublets\n\n=head2 get_trimmed_sequence_by_name($name)\n\n Title   : get_trimmed_sequence_by_name($name)\n Usage   : $o_consed->get_trimmed_sequence_by_name($name);\n Function: Returns the trimmed_sequence of a contig with {name} eq $name.\n Returns : A scalar- the trimmed sequence.\n Args    : The {name} of a contig.\n Notes   : \n\n\nsub get_trimmed_sequence_by_name {\n    my ($self,$name) = @_;\n    my $trimmed_sequence;\n    my $contigname = &get_contig_number_by_name($self,$name);\n    my $class = $self->{'contigs'}->{$contigname}->{'class'};\n    # what is this business and who was smoking crack while writing this?\n    # if ($class eq \"singlet\") {\n    # send the sequence, the quality, and the name\n    # $trimmed_sequence = $self->{o_trim}->trim_singlet\n    #  ($self->{'contigs'}->{$contigname}->{consensus},\n    #   $self->{'contigs'}->{$contigname}->{'quality'},$name);\n    # }\n    return $self->{'contigs'}->{$contigname}->{'sequence_trimmed'};\n}\n\n=head2 set_dash_present_in_sequence_name(\"yes\")\n\n Title   : set_dash_present_in_sequence_name(\"yes\")\n Usage   : $o_consed->set_dash_present_in_sequence_name(\"yes\");\n Function: Deprecated. Part of an uncompleted thought. (\"Oooh! Shiny!\")\n Returns : Nothing.\n Args    : \"yes\" to set {dash_present_in_sequence_name} to 1\n Notes   : \n\n\nsub set_dash_present_in_sequence_name {\n    my ($self,$dash_present) = @_;\n    if ($dash_present eq \"yes\") {\n\t$self->{'dash_present_in_sequence_name'} = 1;\n    }\n    else {\n\t$self->{'dash_present_in_sequence_name'} = 0;\n    }\n    return $self->{'dash_present_in_sequence_name'};\n} # end set_dash_present_in_sequence_name\n\n=head2 set_doublets()\n\n Title   : set_doublets()\n Usage   : $o_consed->set_doublets();\n Function: Find pairs that have similar names and mark them as doublets\n\t   and set the {name}.\n Returns : 0 or 1.\n Args    : None.\n\nA complicated subroutine that iterates over the\nBio::Tools::Alignment::Consed looking for contigs of 2. If the forward\nand reverse designator are removed from each of the reads in\n{'member_array'} and the remaining reads are the same, {name} is set\nto that name and the contig's class is set as \"doublet\".  If any of\nthose cases fail the contig is marked as a \"pair\".\n\n\n#' make my emacs happy\n\nsub set_doublets {\n    my ($self) = @_;\n    # set the designators in the Bio::Tools::Alignment::Trim object\n\n    $self->{'o_trim'}->set_designators($self->{'reverse_designator'},\n\t\t\t\t       $self->{'forward_designator'});\n    foreach my $key_contig (sort keys %{$self->{'contigs'}}) {\n\n\t# if there is a member array (why would there not be? This should be a die()able offence\n\t# but for now I will leave it\n\tif ($self->{'contigs'}->{$key_contig}->{'member_array'}) {\n\t    # if there are two reads in this contig \n\t    # i am pretty sure that this is wrong but i am keeping it for reference\n\t    # if (@{$self->{'contigs'}->{$key_contig}->{'member_array'}} == 2 || !$self->{'contigs'}->{$key_contig}->{'class'}) {\n\t    # <seconds later>\n\t    # <nod> WRONG. Was I on crack?\n\t    if (@{$self->{'contigs'}->{$key_contig}->{'member_array'}} == 2) {\n\t\t$self->{'contigs'}->{$key_contig}->{'num_members'} = 2;\n\t\t$self->debug(\"\\tThere are 2 members! Looking for the contig name...\\n\");\n\t\tmy $name = _get_contig_name($self,$self->{'contigs'}->{$key_contig}->{'member_array'});\n\t\t$self->debug(\"The name is $name\\n\") if defined $name;\n\t\tif ($name) {\n\t\t    $self->{'contigs'}->{$key_contig}->{'name'} = $name;\n\t\t    $self->{'contigs'}->{$key_contig}->{'class'} = \"doublet\";\n\t\t} else {\n\t\t    $self->debug(\"$key_contig is a pair.\\n\");\n\t\t    $self->{'contigs'}->{$key_contig}->{'class'} = \"pair\";\n\t\t}\n\t    }\n            # this is all fair and good but what about singlets?\n            # they have one reads in the member_array but certainly are not singletons\n\t    elsif (@{$self->{'contigs'}->{$key_contig}->{'member_array'}} == 1) {\n\t\t# set the name to be the name of the read\n\t\t$self->{'contigs'}->{$key_contig}->{name} = @{$self->{'contigs'}->{$key_contig}->{'member_array'}}[0];\n\t\t# set the number of members to be one\n\t\t$self->{'contigs'}->{$key_contig}->{num_members} = 1;\n\t\t# if this was a singlet, it would already belong to the class \"singlet\"\n\t\t# so leave it alone\n\t\t# if it is not a singlet, it is a singleton! lablel it appropriately\n\t\tunless ($self->{'contigs'}->{$key_contig}->{'class'}) {\n\t\t    $self->{'contigs'}->{$key_contig}->{'class'} = \"singleton\";\n\t\t}\n\t    }\n            # set the multiplet characteristics\n\t    elsif (@{$self->{'contigs'}->{$key_contig}->{'member_array'}} >= 3) {\n\t\t$self->{'contigs'}->{$key_contig}->{'num_members'} = @{$self->{'contigs'}->{$key_contig}->{'member_array'}};\n\t\t$self->{'contigs'}->{$key_contig}->{'class'} = \"multiplet\";\n\t    }\n\t    $self->{'contigs'}->{$key_contig}->{'num_members'} = @{$self->{'contigs'}->{$key_contig}->{'member_array'}};\n\n\t}\n    }\n    $self->{'doublets_set'} = \"done\";\n    return 0;\n}\t\t\t\t# end set_doublets\n\n=head2 set_singlets\n\n Title   : set_singlets\n Usage   : $o_consed->set_singlets();\n Function: Read in a singlets file and place them into the\n\t   Bio::Tools::Alignment::Consed object.\n Returns : Nothing.\n Args    : A scalar to turn on verbose parsing of the singlets file.\n Notes   : \n\n\nsub set_singlets {\n    # parse out the contents of the singlets file\n    my ($self) = @_;\n    $self->debug(\"Bio::Tools::Alignment::Consed Adding singlets to the contig hash...\\n\"); \n    my $full_filename = $self->{'filename'};\n    $self->debug(\"Bio::Tools::Alignment::Consed::set_singlets: \\$full_filename is $full_filename\\n\");\n    $full_filename =~ m/(.*\\/)(.*ace.*)$/; \t\t\t       \n    my ($base_path,$filename) = ($1,$2);\n    $self->debug(\"Bio::Tools::Alignment::Consed::set_singlets: singlets filename is $filename and \\$base_path is $base_path\\n\");\n    $filename =~ m/(.*)ace.*$/;\n    my $singletsfile = $base_path.$1.\"singlets\";\n    $self->debug(\"\\$singletsfile is $singletsfile\\n\");\n     if (!-f $singletsfile) {\n          # there is no singlets file.\n          $self->{'singlets_set'} = \"done\";\n          return;\n     }\n\t$self->debug(\"$singletsfile is indeed a file. Trying to open it...\\n\");\n    my $singlets_fh = Bio::Root::IO->new(-file => $singletsfile);\n    my ($sequence,$name,$count);\n    while ($_ = $singlets_fh->_readline()) {\n\tchomp $_;\n\tif (/\\>/) {\n\t    if ($name && $sequence) {\n\t\t$self->debug(\"Adding $name with sequence $sequence to hash...\\n\");\n\t\tpush @{$self->{'contigs'}->{$name}->{'member_array'}},$name;\n\t\t$self->{'contigs'}->{$name}->{'consensus'} = $sequence;\n\t\t$self->{'contigs'}->{$name}->{'name'} = $name;\n\t\t$self->{'contigs'}->{$name}->{\"singlet\"} = 1;\n\t\t$self->{'contigs'}->{$name}->{'class'} = \"singlet\";\n\t    }\n\t    $sequence = $name = undef;\n\t    $count++;\n\t    m/^\\>(.*)\\s\\sCHROMAT/;\n\t    $name = $1;\n\t    if (!$name) {\n\t\tm/\\>(\\S+)\\s/;\n\t\t$name = $1;\n\t    }\n\t}\n\telse { $sequence .= $_; }\t\n    }\n    if ($name && $sequence) {\n\t$self->debug(\"Pushing the last of the singlets ($name)\\n\");\n\t@{$self->{'contigs'}->{$name}->{'member_array'}} = $name;\n\t$self->{'contigs'}->{$name}->{'consensus'} = $sequence;\n\t$self->{'contigs'}->{$name}->{'name'} = $name;\n\t$self->{'contigs'}->{$name}->{\"singlet\"} = 1;\n\t$self->{'contigs'}->{$name}->{'class'} = \"singlet\";\n    }\n    $self->debug(\"Bio::Tools::Alignment::Consed::set_singlets: Done adding singlets to the singlets hash.\\n\");\n    $self->{'singlets_set'} = \"done\";\n    return 0;\n}\t\t\t\t# end sub set_singlets\n\n=head2 get_singlets()\n\n Title   : get_singlets()\n Usage   : $o_consed->get_singlets();\n Function: Return the keynames of the singlets.\n Returns : An array containing the keynames of all \n           Bio::Tools::Alignment::Consed sequences in the class \"singlet\".\n Args    : None.\n Notes   : \n\n\nsub get_singlets {\n    # returns an array of singlet names\n    # singlets have \"singlet\"=1 in the hash\n    my $self = shift;\n    if (!$self->{singlets_set}) {\n\t$self->debug(\"You need to set the singlets before you get them. Doing that now.\");\n\t$self->set_singlets();\n    }\t\n\n    my (@singlets,@array);\n    foreach my $key (sort keys %{$self->{'contigs'}}) {\n\t# @array = @{$Consed::contigs{$key}->{'member_array'}};\n\t# somethimes a user will try to get a list of singlets before the classes for the rest of the\n\t# contigs has been set (see t/test.t for how I figured this out. <bah>\t\t\t\n\t# so either way, just return class=singlets\n\tif (!$self->{'contigs'}->{$key}->{'class'}) {\n\t    # print(\"$key has no class. why?\\n\");\n\t}\n\telsif ($self->{'contigs'}->{$key}->{'class'} eq \"singlet\") {\n\t    push @singlets,$key;\n\t}\n    }\n    return @singlets;\n}\n\n=head2 set_quality_by_name($name,$quality)\n\n Title   : set_quality_by_name($name,$quality)\n Usage   : $o_consed->set_quality_by_name($name,$quality);\n Function: Deprecated. Make the contig with {name} have {'quality'} $quality.\n           Probably used for testing.\n Returns : Nothing.\n Args    : The name of a contig and a scalar for its quality.\n Notes   : Deprecated.\n\n\nsub set_quality_by_name {\n    # this is likely deprecated\n    my ($self,$name,$quality) = shift;\n    my $return;\n    foreach (sort keys %{$self->{'contigs'}}) {\n\tif ($self->{'contigs'} eq \"$name\" || $self->{'contigs'}->{'name'} eq \"$name\") {\n\t    $self->{'contigs'}->{'quality'} = $quality;\n\t    $return=1;\n\t}\n    }\n    if ($return) { return \"0\"; } else { return \"1\"; }\n}\t\t\t\t# end set quality by name\n\n=head2 set_singlet_quality()\n\n Title   : set_singlet_quality()\n Usage   : $o_consed->set_singlet_quality();\n Function: For each singlet, go to the appropriate file in phd_dir and read\n           in the phred quality for that read and place it into {'quality'}\n Returns : 0 or 1.\n Args    : None.\n Notes   : This is the next subroutine that will receive substantial revision\n           in the next little while. It really should eval the creation of\n           Bio::Tools::Alignment::Phred objects and go from there. \n\n\nsub set_singlet_quality {\n    my $self = shift;\n    my $full_filename = $self->{'filename'};\n    $full_filename =~ m/(.*\\/)(.*)ace.*$/;\n    my ($base_path,$filename) = ($1,\"$2\".\"qual\");\n    my $singletsfile = $base_path.$filename;\n    if (-f $singletsfile) {\n\t# print(\"$singletsfile is indeed a file. Trying to open it...\\n\");\n    }\n    else {\n\t$self->warn(\"$singletsfile is not a file. Sorry.\\n\");\n\treturn;\n    }\n\tmy $singlets_fh = Bio::Root::IO->new(-file => $singletsfile);\n\tmy ($sequence,$name,$count);\n    my ($identity,$line,$quality,@qline);\n    while ($line = $singlets_fh->_readline()) {\n\tchomp $line;\n\tif ($line =~ /^\\>/) {\n\t    $quality = undef;\n\t    $line =~ m/\\>(\\S*)\\s/;\n\t    $identity = $1;\n\t}\n\telse {\n\t    if ($self->{'contigs'}->{$identity}) {\n\t\t$self->{'contigs'}->{$identity}->{'quality'} .= \"$line \";\n\t    }\n\t}\n\n    }\n    return 0;\n}\n\n=head2 set_contig_quality()\n\n Title   : set_contig_quality()\n Usage   : $o_consed->set_contig_quality();\n Function: Deprecated.\n Returns : Deprecated.\n Args    : Deprecated.\n Notes   : Deprecated. Really. Trust me.\n\n\nsub set_contig_quality {\n    # note: contigs _include_ singletons but _not_ singlets\n    my ($self) = shift;\n          # the unexpected results I am referring to here are a doubling of quality values.\n          # the profanity I uttered on discovering this reminded me of the simpsons:\n          # Ned Flanders: \"That is the loudest profanity I have ever heard!\"\n     $self->warn(\"set_contig_quality is deprecated and will likely produce unexpected results\");\n    my $full_filename = $self->{'filename'};\n    # Run_SRC3700_2000-08-01_73+74.fasta.screen.contigs.qual\n    # from Consed.pm\n    $full_filename =~ m/(.*\\/)(.*)ace.*$/;\n    my ($base_path,$filename) = ($1,\"$2\".\"contigs.qual\");\n    my $singletsfile = $base_path.$filename;\n    if (-f $singletsfile) {\n\t# print(\"$singletsfile is indeed a file. Trying to open it...\\n\");\n    }\n    else {\n\t$self->warn(\"Bio::Tools::Alignment::Consed::set_contig_quality $singletsfile is not a file. Sorry.\\n\");\n\treturn;\n    }\n    my $contig_quality_fh = Bio::Root::IO->new(-file => $singletsfile);\n\n    my ($sequence,$name,$count,$identity,$line,$quality);\n    while ($line = $contig_quality_fh->_readline()) {\n\tchomp $line;\n\tif ($line =~ /^\\>/) {\n\t    $quality = undef;\n\t    $line =~ m/\\>.*Contig(\\d+)\\s/;\n\t    $identity = $1;\n\t}\n\telse {\n\t    if ($self->{'contigs'}->{$identity} ) {\n\t\t$self->{'contigs'}->{$identity}->{'quality'} .= \" $line\";\n\t    }\n\t}\n    }\n}\t\t\t\t# end set_contig_quality\n\n=head2 get_multiplets()\n\n Title   : get_multiplets()\n Usage   : $o_consed->get_multiplets();\n Function: Return the keynames of the multiplets.\n Returns : Returns an array containing the keynames of all \n           Bio::Tools::Alignment::Consed sequences in the class \"multiplet\".\n Args    : None.\n Notes   : \n\n\nsub get_multiplets {\n\t    # returns an array of multiplet names\n\t    # multiplets have # members > 2\n    my $self = shift;\n    my (@multiplets,@array);\n    foreach my $key (sort keys %{$self->{'contigs'}}) {\n\tif ($self->{'contigs'}->{$key}->{'class'}) {\n\t    if ($self->{'contigs'}->{$key}->{'class'} eq \"multiplet\") {\n\t\tpush @multiplets,$key;\n\t    }\n\t}\n    }\n    return @multiplets;\n}\n\n=head2 get_all_members()\n\n  Title   : get_all_members()\n  Usage   : @all_members = $o_consed->get_all_members();\n  Function: Return a list of all of the read names in the \n            Bio::Tools::Alignment::Consed object.\n  Returns : An array containing all of the elements in all of the\n            {'member_array'}s.\n  Args    : None.\n  Notes   : \n\n\nsub get_all_members {\n    my $self = shift;\n    my @members;\n    foreach my $key (sort keys %{$self->{'contigs'}}) {\n\tif ($key =~ /^singlet/) {\n\t    push @members,$self->{'contigs'}->{$key}->{'member_array'}[0];\n\t}\n\telsif ($self->{'contigs'}->{$key}->{'member_array'}) {\n\t    push @members,@{$self->{'contigs'}->{$key}->{'member_array'}};\n\t}\n\t# else {\n\t#\tprint(\"Bio::Tools::Alignment::Consed: $key is _not_ an array. Pushing $self->{'contigs'}->{$key}->{'member_array'} onto \\@members\\n\");\n\t#\tpush @members,$self->{'contigs'}->{$key}->{'member_array'};\n\t# }\n    }\n    return @members;\n}\n\n=head2 sum_lets($total_only)\n\n Title   : sum_lets($total_only)\n Usage   : $statistics = $o_consed->sum_lets($total_only);\n Function: Provide numbers for how many sequences were accounted for in the\n           Bio::Tools::Alignment::Consed object.\n Returns : If a scalar is present, returns the total number of\n           sequences accounted for in all classes. If no scalar passed\n           then returns a string that looks like this:\n           Singt/singn/doub/pair/mult/total : 2,0,1(2),0(0),0(0),4\n           This example means the following: There were 1 singlets.\n           There were 0 singletons.  There were 1 doublets for a total\n           of 2 sequences in this class.  There were 0 pairs for a\n           total of 0 sequences in this class.  There were 0\n           multiplets for a total of 0 sequences in this class.  There\n           were a total of 4 sequences accounted for in the\n           Bio::Tools::Alignment::Consed object.   \n Args : A scalar is optional to change the way the numbers are returned.  \n Notes:\n\n\nsub sum_lets {\n    my ($self,$total_only) = @_;\n    my ($count,$count_multiplets,$multiplet_count);\n    my $singlets = &get_singlets($self); $count += $singlets;\n    my $doublets = &get_doublets($self); $count += ($doublets * 2);\n    my $pairs = &get_pairs($self); $count += ($pairs * 2);\n    my $singletons = &get_singletons($self); $count += $singletons;\n    my @multiplets = &get_multiplets($self);\n    $count_multiplets = @multiplets;\n    my $return_string;\n    foreach (@multiplets) {\n\tmy $number_members = $self->{'contigs'}->{$_}->{num_members};\t\n\t$multiplet_count += $number_members;\n    }\n    if ($multiplet_count) {\n\t$count += $multiplet_count;\n    }\n    foreach (qw(multiplet_count singlets doublets pairs singletons\n                multiplets count_multiplets)) {\n\tno strict 'refs';\t# renege for the block\n\tif (!${$_}) {\n            ${$_} = 0;\n\t}\n    }\n    if (!$multiplet_count) { $multiplet_count = 0; }\n    if ($total_only) {\n        return $count;\n    }\n    $return_string = \"Singt/singn/doub/pair/mult/total : \".\n        \"$singlets,$singletons,$doublets(\".\n         ($doublets*2).\"),$pairs(\".($pairs*2).\n        \"),$count_multiplets($multiplet_count),$count\";\n    return $return_string;\n}\n\n=head2 write_stats()\n\n Title   : write_stats()\n Usage   : $o_consed->write_stats();\n Function: Write a file called \"statistics\" containing numbers similar to\n\t   those provided in sum_lets().\n Returns : Nothing. Write a file in $o_consed->{path} containing something\n\t   like this:\n\n           0,0,50(100),0(0),0(0),100\n\n           Where the numbers provided are in the format described in the\n\t   documentation for sum_lets().\n Args    : None.\n Notes   : This might break platform independence, I do not know.\n\nSee L<sum_lets()|sum_lets>\n\n\nsub write_stats {\n    # worry about platform dependence here?\n    # oh shucksdarn.\n    my $self = shift;\n    my $stats_filename = $self->{'path'}.\"statistics\";\n    my $statistics_raw = $self->sum_lets;\n    my ($statsfilecontents) = $statistics_raw =~ s/.*\\ \\:\\ //g;\n    umask 0001;\n    my $fh = Bio::Root::IO->new(-file=>\"$stats_filename\");\n    # open(STATSFILE,\">$stats_filename\") or print(\"Could not open the statsfile: $!\\n\");\n    $fh->_print(\"$statsfilecontents\");\n    # close STATSFILE;\n    $fh->close();\n}\n\n=head2 get_singletons()\n\n Title   : get_singletons()\n Usage   : @singletons = $o_consed->get_singletons();\n Function: Return the keynames of the singletons.\n Returns : Returns an array containing the keynames of all\n\t   Bio::Tools::Alignment::Consed sequences in the class \"singleton\".\n Args    : None.\n Notes   : \n\n\nsub get_singletons {\n\t\t# returns an array of singleton names\n\t\t# singletons are contigs with one member (see consed documentation)\n\tmy $self = shift;\n\tmy (@singletons,@array);\n\tforeach my $key (sort keys %{$self->{'contigs'}}) {\n\t\tif ($self->{'contigs'}->{$key}->{'class'}) {\n\t\t    # print (\"$key class: $self->{'contigs'}->{$key}->{'class'}\\n\");\n\t\t}\n\t\telse {\n\t\t    # print(\"$key belongs to no class. why?\\n\");\n\t\t}\n\t\tif ($self->{'contigs'}->{$key}->{'member_array'}) {\n\t\t\t@array = @{$self->{'contigs'}->{$key}->{'member_array'}};\n\t\t}\n\t\tmy $num_array_elem = @array;\n\t\tif ($num_array_elem == 1 && $self->{'contigs'}->{$key}->{'class'} && $self->{'contigs'}->{$key}->{'class'} eq \"singleton\") { push @singletons,$key; }\n\t}\n\treturn @singletons;\n}\n\n=head2 get_pairs()\n\n Title   : get_pairs()\n Usage   : @pairs = $o_consed->get_pairs();\n Function: Return the keynames of the pairs.\n Returns : Returns an array containing the keynames of all\n           Bio::Tools::Alignment::Consed sequences in the class \"pair\".\n Args    : None.\n Notes   : \n\n\nsub get_pairs {\n    # returns an array of pair contig names\n    # a pair is a contig of two where the names do not match\n    my $self = shift;\n    my (@pairs,@array);\n    foreach my $key (sort keys %{$self->{'contigs'}}) {\n        if ($self->{'contigs'}->{$key}->{'member_array'}) {\n            if (@{$self->{'contigs'}->{$key}->{'member_array'}} == 2 &&\n                $self->{'contigs'}->{$key}->{'class'} eq \"pair\") {\n                push @pairs,$key;\n            }\n        }\n    }\n    return @pairs;\n}\n\n=head2 get_name($contig_keyname)\n\n Title   : get_name($contig_keyname)\n Usage   : $name = $o_consed->get_name($contig_keyname);\n Function: Return the {name} for $contig_keyname.\n Returns : A string. ({name})\n Args    : A contig keyname.\n Notes   : \n\n\nsub get_name {\n    my ($self,$contig) = @_;\n    return $self->{'contigs'}->{$contig}->{'name'};\n}\n\n=head2 _get_contig_name(\\@array_containing_reads)\n\n Title   : _get_contig_name(\\@array_containing_reads)\n Usage   : $o_consed->_get_contig_name(\\@array_containing_reads);\n Function: The logic for the set_doublets subroutine.\n Returns : The name for this contig.\n Args    : A reference to an array containing read names.\n Notes   : Depends on reverse_designator. Be sure this is set the way you\n\t   intend.","label":"_get_contig_name($self,$r_array)"},"containerName":"main::","definition":"sub","range":{"end":{"line":1468,"character":9999},"start":{"character":0,"line":1426}},"name":"_get_contig_name"},{"definition":"sub","name":"get_doublets","containerName":"main::","range":{"end":{"line":1489,"character":9999},"start":{"character":0,"line":1482}},"kind":12,"children":[{"kind":13,"line":1483,"containerName":"get_doublets","definition":"my","name":"$self","localvar":"my"},{"kind":13,"line":1484,"containerName":"get_doublets","name":"$self"},{"line":1485,"kind":13,"name":"$self","containerName":"get_doublets"},{"kind":12,"line":1485,"name":"warn","containerName":"get_doublets"},{"containerName":"get_doublets","name":"$self","kind":13,"line":1486},{"line":1486,"kind":12,"containerName":"get_doublets","name":"set_doublets"},{"line":1488,"kind":13,"localvar":"my","containerName":"get_doublets","name":"@doublets","definition":"my"},{"kind":13,"line":1489,"name":"$self","containerName":"get_doublets"}],"line":1482},{"kind":12,"line":1484,"name":"doublets_set"},{"kind":13,"line":1490,"name":"%self","containerName":null},{"kind":12,"line":1490,"name":"name"},{"kind":13,"line":1490,"containerName":null,"name":"%self"},{"kind":13,"line":1491,"name":"@doublets","containerName":null},{"line":1494,"kind":13,"containerName":null,"name":"@doublets"},{"range":{"end":{"line":1515,"character":9999},"start":{"line":1509,"character":0}},"definition":"sub","name":"dump_hash","containerName":"main::","children":[{"kind":13,"line":1510,"containerName":"dump_hash","name":"$self","definition":"my","localvar":"my"},{"containerName":"dump_hash","name":"$dumper","definition":"my","localvar":"my","kind":13,"line":1511},{"name":"$self","containerName":"dump_hash","kind":13,"line":1512},{"kind":12,"line":1512,"name":"debug","containerName":"dump_hash"},{"line":1514,"kind":13,"name":"$dumper","containerName":"dump_hash"},{"line":1514,"kind":12,"name":"dumpValue","containerName":"dump_hash"},{"containerName":"dump_hash","name":"$self","kind":13,"line":1514}],"line":1509,"kind":12},{"kind":12,"line":1511,"name":"Dumpvalue"},{"signature":{"label":"dump_hash_compact($self,$sequence)","parameters":[{"label":"$self"},{"label":"$sequence"}],"documentation":"1;\n# $Id: Consed.pm 16123 2009-09-17 12:57:27Z cjfields $\n# Bio::Tools::Alignment::Consed\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chad Matsalla\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Alignment::Consed - A module to work with objects from consed .ace files\n\n=head1 SYNOPSIS\n\n  # a report for sequencing stuff\n  my $o_consed = Bio::Tools::Alignment::Consed->new( \n      -acefile => \"/path/to/an/acefile.ace.1\",\n      -verbose => 1);\n  my $foo = $o_consed->set_reverse_designator(\"r\");\n  my $bar = $o_consed->set_forward_designator(\"f\");\n\n  # get the contig numbers\n  my @keys = $o_consed->get_contigs();\n\n  # construct the doublets\n  my $setter_doublets = $o_consed->choose_doublets();\n\n  # get the doublets\n  my @doublets = $o_consed->get_doublets();\n\n=head1 DESCRIPTION\n\nL<Bio::Tools::Alignment::Consed> provides methods and objects to deal\nwith the output from the Consed software suite. Specifically,\ntakes an C<.ace> file and provides objects for the results.\n\nA word about doublets: This module was written to accomodate a large\nEST sequencing operation. In this case, EST's were sequenced from the\n3' and from the 5' end of the EST. The objective was to find a\nconsensus sequence for these two reads.  Thus, a contig of two is what\nwe wanted, and this contig should consist of the forward and reverse\nreads of a getn clone. For example, for a forward designator of \"F\"\nand a reverse designator of \"R\", if the two reads chad1F and chad1R\nwere in a single contig (for example Contig 5) it will be determined\nthat the consensus sequence for Contig 5 will be the sequence for\nclone chad1.\n\nDoublets are good!\n\nThis module parses C<.ace> and related files. A detailed list of methods\ncan be found at the end of this document.\n\nI wrote a detailed rationale for design that may explain the reasons\nwhy some things were done the way they were done. That document is\nbeyond the scope of this pod and can probably be found in the\ndirectory from which this module was 'made' or at\nL<http://www.dieselwurks.com/bioinformatics/consedpm_documentation.pdf>.\n\nNote that the POD in that document might be old but the original\nrationale still stands.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nEmail chad-at-dieselwurks.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n#' \n\npackage Bio::Tools::Alignment::Consed;\n\nuse strict;\n\nuse FileHandle;\nuse Dumpvalue qw(dumpValue);\nuse Bio::Tools::Alignment::Trim;\nuse File::Spec;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\nour %DEFAULTS = ( 'f_designator' => 'f',\n\t\t  'r_designator' => 'r');\n\n=head2 new()\n\n Title   : new(-acefile => $path_to_some_acefile, -verbose => \"1\")\n Usage   : $o_consed = Bio::Tools::Alignment::Consed->\n              new(-acefile => $path_to_some_acefile, -verbose => \"1\");\n Function: Construct the Bio::Tools::Alignment::Consed object. Sets\n\t   verbosity for the following procedures, if necessary:\n\t   1. Construct a new Bio::Tools::Alignment::Trim object, to\n\t   handle quality trimming 2. Read in the acefile and parse it\n\n Returns : A reference to a Bio::Tools::Alignment::Consed object.\n Args    : A hash. (-acefile) is the filename of an acefile. If a full path\n\t   is not specified \"./\" is prepended to the filename and used from\n\t   instantiation until destruction. If you want \n           Bio::Tools::Alignment::Consed to be noisy during parsing of\n           the acefile, specify some value for (-verbose).\n\n\nsub new {\n    my ($class,%args) = @_;\n    my $self = $class->SUPER::new(%args);\n\n    $self->{'filename'} = $args{'-acefile'};\n\n    # this is special to UNIX and should probably use catfile : DONE!\n#    if (!($self->{'filename'} =~ m{/})) { \n#\t$self->{'filename'} = \"./\".$self->{'filename'}; \n#    } \n#    $self->{'filename'} =~ m/(.*\\/)(.*)ace.*$/;\n#    $self->{'path'} = $1;\n\n    # this is more generic and should work on most systems   \n    (undef, $self->{'path'}, undef) = File::Spec->splitpath($self->{'filename'});\n\n    $self->_initialize_io('-file'=>$self->{'filename'});\n    $self->{'o_trim'} = Bio::Tools::Alignment::Trim->new(-verbose => $self->verbose());\n    $self->set_forward_designator($DEFAULTS{'f_designator'});\n    $self->set_reverse_designator($DEFAULTS{'r_designator'});\n\n    $self->_read_file();\n    return $self;\n}\n\n=head2 set_verbose()\n\n Title   : set_verbose()\n Usage   : $o_consed->set_verbose(1);\n Function: Set the verbosity level for debugging messages. On instantiation\n\t   of the Bio::Tools::Alignment::Consed object the verbosity level\n           is set to 0 (quiet).\n Returns : 1 or 0.\n Args    : The verbosity levels are:\n\t      0 - quiet\n\t      1 - noisy\n\t      2 - noisier\n\t      3 - annoyingly noisy\n\nThis method for setting verbosity has largely been superseeded by a\nsub-by-sub way, where for every sub you can provide a (-verbose)\nswitch. I am doing converting this bit-by-bit so do not be surprised\nif some subs do not honour this.\n\n\n# from RootI\n\n# backwards compat\nsub set_verbose { (shift)->verbose(@_) }\n\n=head2 get_filename()\n\n Title   : get_filename()\n Usage   : $o_consed->get_filename();\n Function: Returns the name of the acefile being used by the\n\t   Bio::Tools::Alignment::Consed object.\n Returns : A scalar containing the name of a file.\n Args    : None.\n\n\n\nsub get_filename {\n    my $self = shift;\n    return $self->{'filename'};\n}\n\n=head2 count_sequences_with_grep()\n\n Title   : count_sequences_with_grep()\n Usage   : $o_consed->count_sequences_with_grep();\n Function: Use /bin/grep to scan through the files in the ace project dir\n\t   and count sequences in those files. I used this method in the\n\t   development of this module to verify that I was getting all of the\n\t   sequences. It works, but it is (I think) unix-like platform\n\t   dependent.\n Returns : A scalar containing the number of sequences in the ace project\n\t   directory.\n Args    : None.\n\nIf you are on a non-UNIX platform, you really do not have to use\nthis. It is more of a debugging routine designed to address very\nspecific problems.\n\nThis method was reimplemented to be platform independent with a pure\nperl implementation.  The above note can be ignored.\n\n\nsub count_sequences_with_grep {\n    my $self = shift;\n    my ($working_dir,$grep_cli,@total_grep_sequences);\n    # this should be migrated to a pure perl implementation ala\n    # Tom Christiansen's 'tcgrep'\n    # http://www.cpan.org/modules/by-authors/id/TOMC/scripts/tcgrep.gz\n\n    open(my $FILE, $self->{'filename'}) or do { $self->warn(\"cannot open file \".$self->{'filename'}. \" for grepping\"); return}; \n    my $counter =0;\n    while(<$FILE>) { $counter++ if(/^AF/); }\n\n    close $FILE;\n    opendir(my $SINGLETS,$self->{'path'});\n    foreach my $f ( readdir($SINGLETS) ) {\n\tnext unless ($f =~ /\\.singlets$/); \n\topen(my $FILE, File::Spec->catfile($self->{'path'},$f)) or do{ $self->warn(\"cannot open file \".File::Spec->catfile($self->{'path'},$f)); next };\n\twhile(<$FILE>) { $counter++ if(/^>/) }\n\tclose $FILE;\n    }\n    return $counter;\n}\n\n=head2 get_path()\n\n Title   : get_path()\n Usage   : $o_consed->get_path();\n Function: Returns the path to the acefile this object is working with.\n Returns : Scalar. The path to the working acefile.\n Args    : None.\n\n\nsub get_path {\n    my $self = shift;\n    return $self->{'path'};\n}\n\n=head2 get_contigs()\n\n Title   : get_contigs()\n Usage   : $o_consed->get_contigs();\n Function: Return the keys to the Bio::Tools::Alignment::Consed object.\n Returns : An array containing the keynames in the\n           Bio::Tools::Alignment::Consed object.\n Args    : None.\n\nThis would normally be used to get the keynames for some sort of\niterator. These keys are worthless in general day-to-day use because\nin the Consed acefile they are simply Contig1, Contig2, ...\n\n\nsub get_contigs {\n    my ($self,$contig) = @_;\n    my @contigs = sort keys %{$self->{'contigs'}};\n    return @contigs;\n}\n\n=head2 get_class($contig_keyname)\n\n Title   : get_class($contig_keyname)\n Usage   : $o_consed->get_class($contig_keyname);\n Function: Return the class name for this contig\n Returns : A scalar representing the class of this contig.\n Args    : None.\n Notes   : \n\n\nsub get_class {\n    my ($self,$contig) = @_;\n    return $self->{contigs}->{$contig}->{class};\n}\n\n=head2 get_quality_array($contig_keyname)\n\n Title   : get_quality_array($contig_keyname)\n Usage   : $o_consed->get_quality_array($contig_keyname);\n Function: Returns the quality for the consensus sequence for the given\n\t   contig as an array. See get_quality_scalar to get this as a scalar.\n Returns : An array containing the quality for the consensus sequence with\n\t   the given keyname.\n Args    : The keyname of a contig. Note: This is a keyname. The key would\n\t   normally come from get_contigs.\n\nReturns an array, not a reference. Is this a bug? I<thinking> No.\nWell, maybe.  Why was this developed like this? I was using FreezeThaw\nfor object persistence, and when it froze out these arrays it took a\nlong time to thaw it. Much better as a scalar.\n\nSee L<get_quality_scalar()|get_quality_scalar>\n\n\nsub get_quality_array {\n    my ($self,$contig) = @_;\n    return split ' ', $self->{contigs}->{$contig}->{quality};\n}\n\n=head2 get_quality_scalar($contig_keyname)\n\n Title   : get_quality_scalar($contig_keyname)\n Usage   : $o_consed->get_quality_scalar($contig_keyname);\n Function: Returns the quality for the consensus sequence for the given\n\t   contig as a scalar. See get_quality_array to get this as an array.\n Returns : An scalar containing the quality for the consensus sequence with\n           the given keyname.\n Args    : The keyname of a contig. Note this is a _keyname_. The key would\n\t   normally come from get_contigs.\n\nWhy was this developed like this? I was using FreezeThaw for object\npersistence, and when it froze out these arrays it took a coon's age\nto thaw it. Much better as a scalar.\n\nSee L<get_quality_array()|get_quality_array>\n\n\n#'\nsub get_quality_scalar {\n    my ($self,$contig) = @_;\n    return $self->{'contigs'}->{$contig}->{'quality'};\n}\n\n=head2 freeze_hash()\n\n Title   : freeze_hash()\n Usage   : $o_consed->freeze_hash();\n\n Function: Use Ilya's FreezeThaw module to create a persistent data\n\t   object for this Bio::Tools::Alignment::Consed data\n\t   structure. In the case of AAFC, we use\n\t   Bio::Tools::Alignment::Consed to pre-process bunches of\n\t   sequences, freeze the structures, and send in a harvesting\n\t   robot later to do database stuff.\n Returns : 0 or 1;\n Args    : None.\n\nThis procedure was removed so Consed.pm won't require FreezeThaw.\n\n\n#'\nsub freeze_hash {\n    my $self = shift;\n    $self->warn(\"This method (freeze_hash) was removed \".\n                \"from the bioperl consed.pm. Sorry.\\n\");\n    if (1==2) {\n        $self->debug(\"Bio::Tools::Alignment::Consed::freeze_hash:\".\n                     \" \\$self->{path} is $self->{path}\\n\");\n        my $filename = $self->{'path'}.\"frozen\";\n        my %contigs = %{$self->{'contigs'}};\n        my $frozen = freeze(%contigs);\n        umask 0001;\n        open (my $FREEZE,\">$filename\") or do {\n            $self->warn( \"Bio::Tools::Alignment::Consed could not \".\n                         \"freeze the contig hash because the file \".\n                         \"($filename) could not be opened: $!\\n\");\n            return 1;\n        };\n        print $FREEZE $frozen;\n        return 0;\n    }\n}\n\n=head2 get_members($contig_keyname)\n\n Title   : get_members($contig_keyname)\n Usage   : $o_consed->get_members($contig_keyname);\n Function: Return the _names_ of the reads in this contig.\n Returns : An array containing the names of the reads in this contig.\n Args    : The keyname of a contig. Note this is a keyname. The keyname\n\t   would normally come from get_contigs.\n\nSee L<get_contigs()|get_contigs>\n\n\nsub get_members {\n    my ($self,$contig) = @_;\n    if (!$contig) {\n\t$self->warn(\"You need to provide the name of a contig to \".\n                    \"use Bio::Tools::Alignment::Consed::get_members!\\n\");\n\treturn;\n    }\n    return @{$self->{'contigs'}->{$contig}->{'member_array'}};\n}\n\n=head2 get_members_by_name($some_arbitrary_name)\n\n Title   : get_members_by_name($some_arbitrary_name)\n Usage   : $o_consed->get_members_by_name($some_arbitrary_name);\n Function: Return the names of the reads in a contig. This is the name given\n\t   to $contig{key} based on what is in the contig. This is different\n\t   from the keys retrieved through get_contigs().\n Returns : An array containing the names of the reads in the contig with this\n\t   name.\n Args    : The name of a contig. Not a key, but a name.\n\nHighly inefficient. use some other method if possible.\nSee L<get_contigs()|get_contigs>\n\n\nsub get_members_by_name {\n    my ($self,$name) = @_;\n    # build a list to try to screen for redundancy\n    my @contigs_with_that_name;\n    foreach my $currkey ( sort keys %{$self->{'contigs'}} ) {\n\tnext if (!$self->{'contigs'}->{$currkey}->{'name'});\n\tif ($self->{'contigs'}->{$currkey}->{'name'} eq \"$name\") {\n\t    push @contigs_with_that_name,$currkey;\n\t}\n    }\n    my $count = @contigs_with_that_name;\n    if ($count == 1) {\n\tmy $contig_num = $contigs_with_that_name[0];\n\treturn @{$self->{'contigs'}->{$contig_num}->{'member_array'}};\n    }\n}\n\n=head2 get_contig_number_by_name($some_arbitrary_name)\n\n Title   : get_contig_number_by_name($some_arbitrary_name)\n Usage   : $o_consed->get_contig_number_by_name($some_arbitrary_name);\n Function: Return the names of the reads in a contig. This is the name given\n\t   to $contig{key} based on what is in the contig. This is different\n\t   from the keys retrieved through get_contigs().\n Returns : An array containing the names of the reads in the contig with this\n\t   name.\n Args    : The name of a contig. Not a key, but a name.\n\nSee L<get_contigs()|get_contigs>\n\n\nsub get_contig_number_by_name {\n    my ($self,$name) = @_;\n    foreach my $currkey (sort keys %{$self->{'contigs'}}) {\n\tif ($self->{'contigs'}->{$currkey}->{'name'} && \n\t    $self->{'contigs'}->{$currkey}->{'name'} eq \"$name\") {\n\t    return $currkey;\n\t}\n    }\n}\t\n\n=head2 get_sequence($contig_keyname)\n\n Title   : get_sequence($contig_keyname)\n Usage   : $o_consed->get_sequence($contig_keyname); \n Function: Returns the consensus sequence for a given contig.\n Returns : A scalar containing a sequence.\n Args    : The keyname of a contig. Note this is a key. The key would\n\t   normally come from get_contigs.\n\nSee L<get_contigs()|get_contigs>\n\n\nsub get_sequence {\n    my ($self,$contig) = @_;\n    return $self->{'contigs'}->{$contig}->{'consensus'};\n}\n\n=head2 set_final_sequence($some_sequence)\n\n Title   : set_final_sequence($name,$some_sequence)\n Usage   : $o_consed->set_final_sequence($name,$some_sequence);\n Function: Provides a manual way to set the sequence for a given key in the\n\t   contig hash. Rarely used.\n Returns : 0 or 1;\n Args    : The name (not the keyname) of a contig and an arbitrary string.\n\nA method with a questionable and somewhat mysterious origin. May raise\nthe dead or something like that.\n\n\nsub set_final_sequence {\n    my ($self,$name,$sequence) = @_;\n    if (!$self->{'contigs'}->{$name}) {\n\t$self->warn(\"You cannot set the final sequence for \".\n                    \"$name because it doesn't exist!\\n\");\n\treturn 1;\n    }\n    else {\n\t$self->{'contigs'}->{$name}->{'final_sequence'} = $sequence;\n    }\n    return 0;\n}\n\n=head2  _read_file()\n\n Title   : _read_file();\n Usage   : _read_file();\n Function: An internal subroutine used to read in an acefile and parse it\n\t   into a Bio::Tools::Alignment::Consed object.\n Returns : 0 or 1.\n Args    : Nothing.\n\nThis routine creates and saves the filhandle for reading the files in\n{fh}\n\n\nsub _read_file {\n    my ($self) = @_;\n    my ($line,$in_contig,$in_quality,$contig_number,$top);\n    # make it easier to type $fhl\n    while (defined($line=$self->_readline()) ) {\n\tchomp $line;\n\t# check if there is anything on this line\n\t# if not, you can stop gathering consensus sequence\n\tif (!$line) {\n\t    # if the line is blank you are no longer to gather consensus \n\t    # sequence or quality values\n\t    $in_contig = 0;\n\t    $in_quality = 0;\n\t}\n\t# you are currently gathering consensus sequence\n\telsif ($in_contig) {\n\t    if ($in_contig == 1) {\n\t\t$self->debug(\"Adding $line to consensus of contig number $contig_number.\\n\");\n\t\t$self->{'contigs'}->{$contig_number}->{'consensus'} .= $line;\n\t    }\n\t}\n\telsif ($in_quality) {\n\t    if (!$line) {\n\t\t$in_quality = undef;\n\t    }\n\t    else {\n\n\t\t# I wrote this in here because acefiles produced by\n\t\t# cap3 do not have a leading space like the acefiles\n\t\t# produced by phrap and there is the potential to have\n\t\t# concatenated quality values like this: 2020 rather\n\t\t# then 20 20 whre lines collide. Thanks Andrew for\n\t\t# noticing.\n\n\t\tif ($self->{'contigs'}->{$contig_number}->{'quality'} &&\n                    !($self->{'contigs'}->{$contig_number}->{'quality'} =~ m/\\ $/)) {\n\t\t    $self->{'contigs'}->{$contig_number}->{'quality'} .= \" \";\n\t\t}\n\t\t$self->{'contigs'}->{$contig_number}->{'quality'} .= $line;\n\t    }\n\t}\n\telsif ($line =~ /^BQ/) {\n\t    $in_quality = 1;\n\t}\n\n\t# the line /^CO/ like this:\n\t# CO Contig1 796 1 1 U\n\t# can be broken down as follows:\n\t# CO - Contig!\n\t# Contig1 - the name of this contig\n\t# 796 - Number of bases in this contig\n\t# 1 - Number of reads in this contig\n\t# 1 - number of base segments in this contig\n\t# U - Uncomplemented\n\n\telsif ($line =~ /^CO/) {\n\t    $line =~ m/^CO\\ Contig(\\d+)\\ \\d+\\ \\d+\\ \\d+\\ (\\w)/;\n\t    $contig_number = $1;\n\t    if ($2 eq \"C\") {\n\t\t$self->debug(\"Contig $contig_number is complemented!\\n\");\n\t    }\n\t    $self->{'contigs'}->{$contig_number}->{'member_array'} = [];\n\t    $self->{'contigs'}->{$contig_number}->{'contig_direction'} = \"$2\";\n\t    $in_contig = 1;\n\t}\n\n\t# 000713\n\t# this BS is deprecated, I think.\n\t# haha, I am really witty. <ew>\n\n\telsif ($line =~ /^BSDEPRECATED/) {\n\t    $line =~ m/^BS\\s+\\d+\\s+\\d+\\s+(.+)/;\n\t    my $member = $1;\n\t    $self->{'contigs'}->{$contig_number}->{$member}++;\n\t}\n\t# the members of the contigs are determined by the AF line in the ace file\n\telsif ($line =~ /^AF/) {\n\t    $self->debug(\"I see an AF line here.\\n\");\n\t    $line =~ /^AF\\ (\\S+)\\ (\\w)\\ (\\S+)/;\n\n            # push the name of the current read onto the member array for this contig\n\t    push @{$self->{'contigs'}->{$contig_number}->{'member_array'}},$1;\n\n            # the first read in the contig will be named the \"top\" read\n\t    if (!$top) {\n\t\t$self->debug(\"\\$top is not set.\\n\");\n\t\tif ($self->{'contigs'}->{$contig_number}->{'contig_direction'} eq \"C\") {\n\t\t    $self->debug(\"Reversing the order of the reads. The bottom will be $1\\n\");\n\n\t\t    # if the contig sequence is marked as the\n\t\t    # complement, the top becomes the bottom and$\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_name'} = $1;\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_complement'} = $2;\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_start'} = $3;\n\t\t}\n\t\telse {\n\t\t    $self->debug(\"NOT reversing the order of the reads. \".\n                                 \"The top_name will be $1\\n\");\n\t\t    # if the contig sequence is marked as the\n\t\t    # complement, the top becomes the bottom and$\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_name'} = $1;\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_complement'} = $2;\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_start'} = $3;\n\t\t}\n\t\t$top = 1;\n\t    }\n\t    else {\n\n\t\t# if the contig sequence is marked as the complement,\n\t\t# the top becomes the bottom and the bottom becomes\n\t\t# the top\n\t\tif ($self->{'contigs'}->{$contig_number}->{'contig_direction'} eq \"C\") {\n\t\t    $self->debug(\"Reversing the order of the reads. The top will be $1\\n\");\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_name'} = $1;\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_complement'} = $2;\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_start'} = $3;\n\t\t}\n\t\telse {\n\t\t    $self->debug(\"NOT reversing the order of the reads. The bottom will be $1\\n\");\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_name'} = $1;\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_complement'} = $2;\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_start'} = $3;\n\t\t}\n\t\t$top = undef;\n\t    }\n\t}\n    }\n    return 0;\n}\n\n=head2 set_reverse_designator($some_string)\n\n Title   : set_reverse_designator($some_string)\n Usage   : $o_consed->set_reverse_designator($some_string);\n Function: Set the designator for the reverse read of contigs in this\n\t   Bio::Tools::Alignment::Consed object. Used to determine if\n           contigs containing two reads can be named.\n Returns : The value of $o_consed->{reverse_designator} so you can check\n\t   to see that it was set properly.\n Args    : An arbitrary string.\n\nMay be useful only to me. I<shrug>\n\n\nsub set_reverse_designator {\n    my ($self,$reverse_designator) = @_;\n    $self->{'reverse_designator'} = $reverse_designator;\n    $self->{'o_trim'}->set_reverse_designator($reverse_designator);\n    return $self->{'reverse_designator'};\n}\t\t\t\t# end set_reverse_designator\n\n=head2 set_forward_designator($some_string)\n\n Title   : set_forward_designator($some_string)\n Usage   : $o_consed->set_forward_designator($some_string);\n Function: Set the designator for the forward read of contigs in this\n\t   Bio::Tools::Alignment::Consed object. Used to determine if\n           contigs containing two reads can be named.\n Returns : The value of $o_consed->{forward_designator} so you can check\n\t   to see that it was set properly.\n Args    : An arbitrary string.\n\nMay be useful only to me. I<shrug>\n\n\nsub set_forward_designator {\n    my ($self,$forward_designator) = @_;\n    $self->{'forward_designator'} = $forward_designator;\n    $self->{'o_trim'}->set_forward_designator($forward_designator);\n    return $self->{'forward_designator'};\n}\t\t\t\t# end set_forward_designator\n\n=head2 set_designator_ignore_case(\"yes\")\n\n Title   : set_designator_ignore_case(\"yes\")\n Usage   : $o_consed->set_designator_ignore_case(\"yes\");\n Function: Deprecated.\n Returns : Deprecated.\n Args    : Deprecated.\n\nDeprecated. Really. Trust me.\n\n\nsub set_designator_ignore_case {\n    my ($self,$ignore_case) = @_;\n    if ($ignore_case eq \"yes\") {\n\t$self->{'designator_ignore_case'} = 1;\n    }\n    return $self->{'designator_ignore_case'};\n}\t\t\t\t# end set_designator_ignore_case\n\n=head2 set_trim_points_singlets_and_singletons()\n\n Title   : set_trim_points_singlets_and_singletons()\n Usage   : $o_consed->set_trim_points_singlets_and_singletons();\n Function: Set the trim points for singlets and singletons based on\n\t   quality.  Uses the Bio::Tools::Alignment::Trim object. Use\n\t   at your own risk because the Bio::Tools::Alignment::Trim\n\t   object was designed specifically for me and is mysterious\n\t   in its ways. Every time somebody other then me uses it a\n\t   swarm of locusts decends on a small Central American\n\t   village so do not say you weren't warned.\n Returns : Nothing.\n Args    : None.\n\nWorking on exceptions and warnings here.\n\nSee L<Bio::Tools::Alignment::Trim> for more information\n\n\n#' to make my emacs happy\n\nsub set_trim_points_singlets_and_singletons {\n    my ($self) = @_;\n    $self->debug(\"Consed.pm : \\$self is $self\\n\");\n    my (@points,$trimmed_sequence);\n    if (!$self->{'doublets_set'}) {\n        $self->debug(\"You need to set the doublets before you use \".\n                     \"set_trim_points_singlets_and_doublets. Doing that now.\");\n\t$self->set_doublets();\n    }\n    foreach (sort keys %{$self->{'contigs'}}) {\n\tif ($self->{'contigs'}->{$_}->{'class'} eq \"singlet\") {\n\t    $self->debug(\"Singlet $_\\n\");\n\t    # this is what Warehouse wants\n\t    #         my ($self,$sequence,$quality,$name) = @_;\n\t    # this is what Bio::Tools::Alignment::Trim::trim_singlet wants:\n\t    # my ($self,$sequence,$quality,$name,$class) = @_;\n\t    # the following several lines are to make the parameter passing legible.\n\t    my ($sequence,$quality,$name,$class);\n\t    $sequence = $self->{'contigs'}->{$_}->{'consensus'};\n\t    if (!$self->{'contigs'}->{$_}->{'quality'}) { $quality = \"unset\"; }\n\t    else { $quality = $self->{'contigs'}->{$_}->{'quality'}; }\n\t    $name = $self->{'contigs'}->{$_}->{'name'};\n\t    $class = $self->{'contigs'}->{$_}->{'class'};\n\t    @points = @{$self->{'o_trim'}->trim_singlet($sequence,$quality,$name,$class)};\n\t    $self->{'contigs'}->{$_}->{'start_point'} = $points[0];\n\t    $self->{'contigs'}->{$_}->{'end_point'} = $points[1];\n\t    $self->{'contigs'}->{$_}->{'sequence_trimmed'} = \n                substr($self->{contigs}->{$_}->{'consensus'},$points[0],$points[1]-$points[0]);\n\t}\n    }\n    $self->debug(\"Bio::Tools::Alignment::Consed::set_trim_points_singlets\".\n                 \"_and_singletons: Done setting the quality trimpoints.\\n\");\n    return;\n}  # end set_trim_points_singlet\n\n=head2 set_trim_points_doublets()\n\n Title   : set_trim_points_doublets()\n Usage   : $o_consed->set_trim_points_doublets();\n Function: Set the trim points for doublets based on quality. Uses the\n\t   Bio::Tools::Alignment::Trim object. Use at your own risk because\n           the Bio::Tools::Alignment::Trim object was designed specifically\n           for me and is mysterious in its ways. Every time somebody other\n           then me uses it you risk a biblical plague being loosed on your\n           city.\n Returns : Nothing.\n Args    : None.\n Notes   : Working on exceptions here.\n\nSee L<Bio::Tools::Alignment::Trim> for more information\n\n\nsub set_trim_points_doublets {\n    my $self = shift;\n    my @points;\n    $self->debug(\"Bio::Tools::Alignment::Consed::set_trim_points_doublets:\".\n                 \" Restoring zeros for doublets.\\n\");\n    # &show_missing_sequence($self);\n    $self->debug(\"Bio::Tools::Alignment::Consed::set_trim_points_doublets:\".\n                 \" Setting doublet trim points.\\n\");\n    foreach (sort keys %{$self->{'contigs'}}) {\n\tif ($self->{'contigs'}->{$_}->{'class'} eq \"doublet\") {\n            # my ($self,$sequence,$quality,$name,$class) = @_;\n            my @quals = split(' ',$self->{'contigs'}->{$_}->{'quality'});\n\n\t    @points = $self->{o_trim}->trim_doublet\n                ($self->{'contigs'}->{$_}->{'consensus'},\n                 $self->{'contigs'}->{$_}->{'quality'},\n                 $self->{'contigs'}->{$_}->{name},\n                 $self->{'contigs'}->{$_}->{'class'});\n\t    $self->{'contigs'}->{$_}->{'start_point'} = $points[0];\n\t    $self->{'contigs'}->{$_}->{'end_point'} = $points[1];\n            # now set this\n\t    $self->{'contigs'}->{$_}->{'sequence_trimmed'} =\n                substr($self->{contigs}->{$_}->{'consensus'},\n                       $points[0],$points[1]-$points[0]);\n\t    # 010102 the deprecated way to do things:\n\t}\n    }\n    $self->debug(\"Bio::Tools::Alignment::Consed::set_trim_points_doublets:\".\n                 \" Done setting doublet trim points.\\n\"); \n    return;\n} # end set_trim_points_doublets\n\n=head2 get_trimmed_sequence_by_name($name)\n\n Title   : get_trimmed_sequence_by_name($name)\n Usage   : $o_consed->get_trimmed_sequence_by_name($name);\n Function: Returns the trimmed_sequence of a contig with {name} eq $name.\n Returns : A scalar- the trimmed sequence.\n Args    : The {name} of a contig.\n Notes   : \n\n\nsub get_trimmed_sequence_by_name {\n    my ($self,$name) = @_;\n    my $trimmed_sequence;\n    my $contigname = &get_contig_number_by_name($self,$name);\n    my $class = $self->{'contigs'}->{$contigname}->{'class'};\n    # what is this business and who was smoking crack while writing this?\n    # if ($class eq \"singlet\") {\n    # send the sequence, the quality, and the name\n    # $trimmed_sequence = $self->{o_trim}->trim_singlet\n    #  ($self->{'contigs'}->{$contigname}->{consensus},\n    #   $self->{'contigs'}->{$contigname}->{'quality'},$name);\n    # }\n    return $self->{'contigs'}->{$contigname}->{'sequence_trimmed'};\n}\n\n=head2 set_dash_present_in_sequence_name(\"yes\")\n\n Title   : set_dash_present_in_sequence_name(\"yes\")\n Usage   : $o_consed->set_dash_present_in_sequence_name(\"yes\");\n Function: Deprecated. Part of an uncompleted thought. (\"Oooh! Shiny!\")\n Returns : Nothing.\n Args    : \"yes\" to set {dash_present_in_sequence_name} to 1\n Notes   : \n\n\nsub set_dash_present_in_sequence_name {\n    my ($self,$dash_present) = @_;\n    if ($dash_present eq \"yes\") {\n\t$self->{'dash_present_in_sequence_name'} = 1;\n    }\n    else {\n\t$self->{'dash_present_in_sequence_name'} = 0;\n    }\n    return $self->{'dash_present_in_sequence_name'};\n} # end set_dash_present_in_sequence_name\n\n=head2 set_doublets()\n\n Title   : set_doublets()\n Usage   : $o_consed->set_doublets();\n Function: Find pairs that have similar names and mark them as doublets\n\t   and set the {name}.\n Returns : 0 or 1.\n Args    : None.\n\nA complicated subroutine that iterates over the\nBio::Tools::Alignment::Consed looking for contigs of 2. If the forward\nand reverse designator are removed from each of the reads in\n{'member_array'} and the remaining reads are the same, {name} is set\nto that name and the contig's class is set as \"doublet\".  If any of\nthose cases fail the contig is marked as a \"pair\".\n\n\n#' make my emacs happy\n\nsub set_doublets {\n    my ($self) = @_;\n    # set the designators in the Bio::Tools::Alignment::Trim object\n\n    $self->{'o_trim'}->set_designators($self->{'reverse_designator'},\n\t\t\t\t       $self->{'forward_designator'});\n    foreach my $key_contig (sort keys %{$self->{'contigs'}}) {\n\n\t# if there is a member array (why would there not be? This should be a die()able offence\n\t# but for now I will leave it\n\tif ($self->{'contigs'}->{$key_contig}->{'member_array'}) {\n\t    # if there are two reads in this contig \n\t    # i am pretty sure that this is wrong but i am keeping it for reference\n\t    # if (@{$self->{'contigs'}->{$key_contig}->{'member_array'}} == 2 || !$self->{'contigs'}->{$key_contig}->{'class'}) {\n\t    # <seconds later>\n\t    # <nod> WRONG. Was I on crack?\n\t    if (@{$self->{'contigs'}->{$key_contig}->{'member_array'}} == 2) {\n\t\t$self->{'contigs'}->{$key_contig}->{'num_members'} = 2;\n\t\t$self->debug(\"\\tThere are 2 members! Looking for the contig name...\\n\");\n\t\tmy $name = _get_contig_name($self,$self->{'contigs'}->{$key_contig}->{'member_array'});\n\t\t$self->debug(\"The name is $name\\n\") if defined $name;\n\t\tif ($name) {\n\t\t    $self->{'contigs'}->{$key_contig}->{'name'} = $name;\n\t\t    $self->{'contigs'}->{$key_contig}->{'class'} = \"doublet\";\n\t\t} else {\n\t\t    $self->debug(\"$key_contig is a pair.\\n\");\n\t\t    $self->{'contigs'}->{$key_contig}->{'class'} = \"pair\";\n\t\t}\n\t    }\n            # this is all fair and good but what about singlets?\n            # they have one reads in the member_array but certainly are not singletons\n\t    elsif (@{$self->{'contigs'}->{$key_contig}->{'member_array'}} == 1) {\n\t\t# set the name to be the name of the read\n\t\t$self->{'contigs'}->{$key_contig}->{name} = @{$self->{'contigs'}->{$key_contig}->{'member_array'}}[0];\n\t\t# set the number of members to be one\n\t\t$self->{'contigs'}->{$key_contig}->{num_members} = 1;\n\t\t# if this was a singlet, it would already belong to the class \"singlet\"\n\t\t# so leave it alone\n\t\t# if it is not a singlet, it is a singleton! lablel it appropriately\n\t\tunless ($self->{'contigs'}->{$key_contig}->{'class'}) {\n\t\t    $self->{'contigs'}->{$key_contig}->{'class'} = \"singleton\";\n\t\t}\n\t    }\n            # set the multiplet characteristics\n\t    elsif (@{$self->{'contigs'}->{$key_contig}->{'member_array'}} >= 3) {\n\t\t$self->{'contigs'}->{$key_contig}->{'num_members'} = @{$self->{'contigs'}->{$key_contig}->{'member_array'}};\n\t\t$self->{'contigs'}->{$key_contig}->{'class'} = \"multiplet\";\n\t    }\n\t    $self->{'contigs'}->{$key_contig}->{'num_members'} = @{$self->{'contigs'}->{$key_contig}->{'member_array'}};\n\n\t}\n    }\n    $self->{'doublets_set'} = \"done\";\n    return 0;\n}\t\t\t\t# end set_doublets\n\n=head2 set_singlets\n\n Title   : set_singlets\n Usage   : $o_consed->set_singlets();\n Function: Read in a singlets file and place them into the\n\t   Bio::Tools::Alignment::Consed object.\n Returns : Nothing.\n Args    : A scalar to turn on verbose parsing of the singlets file.\n Notes   : \n\n\nsub set_singlets {\n    # parse out the contents of the singlets file\n    my ($self) = @_;\n    $self->debug(\"Bio::Tools::Alignment::Consed Adding singlets to the contig hash...\\n\"); \n    my $full_filename = $self->{'filename'};\n    $self->debug(\"Bio::Tools::Alignment::Consed::set_singlets: \\$full_filename is $full_filename\\n\");\n    $full_filename =~ m/(.*\\/)(.*ace.*)$/; \t\t\t       \n    my ($base_path,$filename) = ($1,$2);\n    $self->debug(\"Bio::Tools::Alignment::Consed::set_singlets: singlets filename is $filename and \\$base_path is $base_path\\n\");\n    $filename =~ m/(.*)ace.*$/;\n    my $singletsfile = $base_path.$1.\"singlets\";\n    $self->debug(\"\\$singletsfile is $singletsfile\\n\");\n     if (!-f $singletsfile) {\n          # there is no singlets file.\n          $self->{'singlets_set'} = \"done\";\n          return;\n     }\n\t$self->debug(\"$singletsfile is indeed a file. Trying to open it...\\n\");\n    my $singlets_fh = Bio::Root::IO->new(-file => $singletsfile);\n    my ($sequence,$name,$count);\n    while ($_ = $singlets_fh->_readline()) {\n\tchomp $_;\n\tif (/\\>/) {\n\t    if ($name && $sequence) {\n\t\t$self->debug(\"Adding $name with sequence $sequence to hash...\\n\");\n\t\tpush @{$self->{'contigs'}->{$name}->{'member_array'}},$name;\n\t\t$self->{'contigs'}->{$name}->{'consensus'} = $sequence;\n\t\t$self->{'contigs'}->{$name}->{'name'} = $name;\n\t\t$self->{'contigs'}->{$name}->{\"singlet\"} = 1;\n\t\t$self->{'contigs'}->{$name}->{'class'} = \"singlet\";\n\t    }\n\t    $sequence = $name = undef;\n\t    $count++;\n\t    m/^\\>(.*)\\s\\sCHROMAT/;\n\t    $name = $1;\n\t    if (!$name) {\n\t\tm/\\>(\\S+)\\s/;\n\t\t$name = $1;\n\t    }\n\t}\n\telse { $sequence .= $_; }\t\n    }\n    if ($name && $sequence) {\n\t$self->debug(\"Pushing the last of the singlets ($name)\\n\");\n\t@{$self->{'contigs'}->{$name}->{'member_array'}} = $name;\n\t$self->{'contigs'}->{$name}->{'consensus'} = $sequence;\n\t$self->{'contigs'}->{$name}->{'name'} = $name;\n\t$self->{'contigs'}->{$name}->{\"singlet\"} = 1;\n\t$self->{'contigs'}->{$name}->{'class'} = \"singlet\";\n    }\n    $self->debug(\"Bio::Tools::Alignment::Consed::set_singlets: Done adding singlets to the singlets hash.\\n\");\n    $self->{'singlets_set'} = \"done\";\n    return 0;\n}\t\t\t\t# end sub set_singlets\n\n=head2 get_singlets()\n\n Title   : get_singlets()\n Usage   : $o_consed->get_singlets();\n Function: Return the keynames of the singlets.\n Returns : An array containing the keynames of all \n           Bio::Tools::Alignment::Consed sequences in the class \"singlet\".\n Args    : None.\n Notes   : \n\n\nsub get_singlets {\n    # returns an array of singlet names\n    # singlets have \"singlet\"=1 in the hash\n    my $self = shift;\n    if (!$self->{singlets_set}) {\n\t$self->debug(\"You need to set the singlets before you get them. Doing that now.\");\n\t$self->set_singlets();\n    }\t\n\n    my (@singlets,@array);\n    foreach my $key (sort keys %{$self->{'contigs'}}) {\n\t# @array = @{$Consed::contigs{$key}->{'member_array'}};\n\t# somethimes a user will try to get a list of singlets before the classes for the rest of the\n\t# contigs has been set (see t/test.t for how I figured this out. <bah>\t\t\t\n\t# so either way, just return class=singlets\n\tif (!$self->{'contigs'}->{$key}->{'class'}) {\n\t    # print(\"$key has no class. why?\\n\");\n\t}\n\telsif ($self->{'contigs'}->{$key}->{'class'} eq \"singlet\") {\n\t    push @singlets,$key;\n\t}\n    }\n    return @singlets;\n}\n\n=head2 set_quality_by_name($name,$quality)\n\n Title   : set_quality_by_name($name,$quality)\n Usage   : $o_consed->set_quality_by_name($name,$quality);\n Function: Deprecated. Make the contig with {name} have {'quality'} $quality.\n           Probably used for testing.\n Returns : Nothing.\n Args    : The name of a contig and a scalar for its quality.\n Notes   : Deprecated.\n\n\nsub set_quality_by_name {\n    # this is likely deprecated\n    my ($self,$name,$quality) = shift;\n    my $return;\n    foreach (sort keys %{$self->{'contigs'}}) {\n\tif ($self->{'contigs'} eq \"$name\" || $self->{'contigs'}->{'name'} eq \"$name\") {\n\t    $self->{'contigs'}->{'quality'} = $quality;\n\t    $return=1;\n\t}\n    }\n    if ($return) { return \"0\"; } else { return \"1\"; }\n}\t\t\t\t# end set quality by name\n\n=head2 set_singlet_quality()\n\n Title   : set_singlet_quality()\n Usage   : $o_consed->set_singlet_quality();\n Function: For each singlet, go to the appropriate file in phd_dir and read\n           in the phred quality for that read and place it into {'quality'}\n Returns : 0 or 1.\n Args    : None.\n Notes   : This is the next subroutine that will receive substantial revision\n           in the next little while. It really should eval the creation of\n           Bio::Tools::Alignment::Phred objects and go from there. \n\n\nsub set_singlet_quality {\n    my $self = shift;\n    my $full_filename = $self->{'filename'};\n    $full_filename =~ m/(.*\\/)(.*)ace.*$/;\n    my ($base_path,$filename) = ($1,\"$2\".\"qual\");\n    my $singletsfile = $base_path.$filename;\n    if (-f $singletsfile) {\n\t# print(\"$singletsfile is indeed a file. Trying to open it...\\n\");\n    }\n    else {\n\t$self->warn(\"$singletsfile is not a file. Sorry.\\n\");\n\treturn;\n    }\n\tmy $singlets_fh = Bio::Root::IO->new(-file => $singletsfile);\n\tmy ($sequence,$name,$count);\n    my ($identity,$line,$quality,@qline);\n    while ($line = $singlets_fh->_readline()) {\n\tchomp $line;\n\tif ($line =~ /^\\>/) {\n\t    $quality = undef;\n\t    $line =~ m/\\>(\\S*)\\s/;\n\t    $identity = $1;\n\t}\n\telse {\n\t    if ($self->{'contigs'}->{$identity}) {\n\t\t$self->{'contigs'}->{$identity}->{'quality'} .= \"$line \";\n\t    }\n\t}\n\n    }\n    return 0;\n}\n\n=head2 set_contig_quality()\n\n Title   : set_contig_quality()\n Usage   : $o_consed->set_contig_quality();\n Function: Deprecated.\n Returns : Deprecated.\n Args    : Deprecated.\n Notes   : Deprecated. Really. Trust me.\n\n\nsub set_contig_quality {\n    # note: contigs _include_ singletons but _not_ singlets\n    my ($self) = shift;\n          # the unexpected results I am referring to here are a doubling of quality values.\n          # the profanity I uttered on discovering this reminded me of the simpsons:\n          # Ned Flanders: \"That is the loudest profanity I have ever heard!\"\n     $self->warn(\"set_contig_quality is deprecated and will likely produce unexpected results\");\n    my $full_filename = $self->{'filename'};\n    # Run_SRC3700_2000-08-01_73+74.fasta.screen.contigs.qual\n    # from Consed.pm\n    $full_filename =~ m/(.*\\/)(.*)ace.*$/;\n    my ($base_path,$filename) = ($1,\"$2\".\"contigs.qual\");\n    my $singletsfile = $base_path.$filename;\n    if (-f $singletsfile) {\n\t# print(\"$singletsfile is indeed a file. Trying to open it...\\n\");\n    }\n    else {\n\t$self->warn(\"Bio::Tools::Alignment::Consed::set_contig_quality $singletsfile is not a file. Sorry.\\n\");\n\treturn;\n    }\n    my $contig_quality_fh = Bio::Root::IO->new(-file => $singletsfile);\n\n    my ($sequence,$name,$count,$identity,$line,$quality);\n    while ($line = $contig_quality_fh->_readline()) {\n\tchomp $line;\n\tif ($line =~ /^\\>/) {\n\t    $quality = undef;\n\t    $line =~ m/\\>.*Contig(\\d+)\\s/;\n\t    $identity = $1;\n\t}\n\telse {\n\t    if ($self->{'contigs'}->{$identity} ) {\n\t\t$self->{'contigs'}->{$identity}->{'quality'} .= \" $line\";\n\t    }\n\t}\n    }\n}\t\t\t\t# end set_contig_quality\n\n=head2 get_multiplets()\n\n Title   : get_multiplets()\n Usage   : $o_consed->get_multiplets();\n Function: Return the keynames of the multiplets.\n Returns : Returns an array containing the keynames of all \n           Bio::Tools::Alignment::Consed sequences in the class \"multiplet\".\n Args    : None.\n Notes   : \n\n\nsub get_multiplets {\n\t    # returns an array of multiplet names\n\t    # multiplets have # members > 2\n    my $self = shift;\n    my (@multiplets,@array);\n    foreach my $key (sort keys %{$self->{'contigs'}}) {\n\tif ($self->{'contigs'}->{$key}->{'class'}) {\n\t    if ($self->{'contigs'}->{$key}->{'class'} eq \"multiplet\") {\n\t\tpush @multiplets,$key;\n\t    }\n\t}\n    }\n    return @multiplets;\n}\n\n=head2 get_all_members()\n\n  Title   : get_all_members()\n  Usage   : @all_members = $o_consed->get_all_members();\n  Function: Return a list of all of the read names in the \n            Bio::Tools::Alignment::Consed object.\n  Returns : An array containing all of the elements in all of the\n            {'member_array'}s.\n  Args    : None.\n  Notes   : \n\n\nsub get_all_members {\n    my $self = shift;\n    my @members;\n    foreach my $key (sort keys %{$self->{'contigs'}}) {\n\tif ($key =~ /^singlet/) {\n\t    push @members,$self->{'contigs'}->{$key}->{'member_array'}[0];\n\t}\n\telsif ($self->{'contigs'}->{$key}->{'member_array'}) {\n\t    push @members,@{$self->{'contigs'}->{$key}->{'member_array'}};\n\t}\n\t# else {\n\t#\tprint(\"Bio::Tools::Alignment::Consed: $key is _not_ an array. Pushing $self->{'contigs'}->{$key}->{'member_array'} onto \\@members\\n\");\n\t#\tpush @members,$self->{'contigs'}->{$key}->{'member_array'};\n\t# }\n    }\n    return @members;\n}\n\n=head2 sum_lets($total_only)\n\n Title   : sum_lets($total_only)\n Usage   : $statistics = $o_consed->sum_lets($total_only);\n Function: Provide numbers for how many sequences were accounted for in the\n           Bio::Tools::Alignment::Consed object.\n Returns : If a scalar is present, returns the total number of\n           sequences accounted for in all classes. If no scalar passed\n           then returns a string that looks like this:\n           Singt/singn/doub/pair/mult/total : 2,0,1(2),0(0),0(0),4\n           This example means the following: There were 1 singlets.\n           There were 0 singletons.  There were 1 doublets for a total\n           of 2 sequences in this class.  There were 0 pairs for a\n           total of 0 sequences in this class.  There were 0\n           multiplets for a total of 0 sequences in this class.  There\n           were a total of 4 sequences accounted for in the\n           Bio::Tools::Alignment::Consed object.   \n Args : A scalar is optional to change the way the numbers are returned.  \n Notes:\n\n\nsub sum_lets {\n    my ($self,$total_only) = @_;\n    my ($count,$count_multiplets,$multiplet_count);\n    my $singlets = &get_singlets($self); $count += $singlets;\n    my $doublets = &get_doublets($self); $count += ($doublets * 2);\n    my $pairs = &get_pairs($self); $count += ($pairs * 2);\n    my $singletons = &get_singletons($self); $count += $singletons;\n    my @multiplets = &get_multiplets($self);\n    $count_multiplets = @multiplets;\n    my $return_string;\n    foreach (@multiplets) {\n\tmy $number_members = $self->{'contigs'}->{$_}->{num_members};\t\n\t$multiplet_count += $number_members;\n    }\n    if ($multiplet_count) {\n\t$count += $multiplet_count;\n    }\n    foreach (qw(multiplet_count singlets doublets pairs singletons\n                multiplets count_multiplets)) {\n\tno strict 'refs';\t# renege for the block\n\tif (!${$_}) {\n            ${$_} = 0;\n\t}\n    }\n    if (!$multiplet_count) { $multiplet_count = 0; }\n    if ($total_only) {\n        return $count;\n    }\n    $return_string = \"Singt/singn/doub/pair/mult/total : \".\n        \"$singlets,$singletons,$doublets(\".\n         ($doublets*2).\"),$pairs(\".($pairs*2).\n        \"),$count_multiplets($multiplet_count),$count\";\n    return $return_string;\n}\n\n=head2 write_stats()\n\n Title   : write_stats()\n Usage   : $o_consed->write_stats();\n Function: Write a file called \"statistics\" containing numbers similar to\n\t   those provided in sum_lets().\n Returns : Nothing. Write a file in $o_consed->{path} containing something\n\t   like this:\n\n           0,0,50(100),0(0),0(0),100\n\n           Where the numbers provided are in the format described in the\n\t   documentation for sum_lets().\n Args    : None.\n Notes   : This might break platform independence, I do not know.\n\nSee L<sum_lets()|sum_lets>\n\n\nsub write_stats {\n    # worry about platform dependence here?\n    # oh shucksdarn.\n    my $self = shift;\n    my $stats_filename = $self->{'path'}.\"statistics\";\n    my $statistics_raw = $self->sum_lets;\n    my ($statsfilecontents) = $statistics_raw =~ s/.*\\ \\:\\ //g;\n    umask 0001;\n    my $fh = Bio::Root::IO->new(-file=>\"$stats_filename\");\n    # open(STATSFILE,\">$stats_filename\") or print(\"Could not open the statsfile: $!\\n\");\n    $fh->_print(\"$statsfilecontents\");\n    # close STATSFILE;\n    $fh->close();\n}\n\n=head2 get_singletons()\n\n Title   : get_singletons()\n Usage   : @singletons = $o_consed->get_singletons();\n Function: Return the keynames of the singletons.\n Returns : Returns an array containing the keynames of all\n\t   Bio::Tools::Alignment::Consed sequences in the class \"singleton\".\n Args    : None.\n Notes   : \n\n\nsub get_singletons {\n\t\t# returns an array of singleton names\n\t\t# singletons are contigs with one member (see consed documentation)\n\tmy $self = shift;\n\tmy (@singletons,@array);\n\tforeach my $key (sort keys %{$self->{'contigs'}}) {\n\t\tif ($self->{'contigs'}->{$key}->{'class'}) {\n\t\t    # print (\"$key class: $self->{'contigs'}->{$key}->{'class'}\\n\");\n\t\t}\n\t\telse {\n\t\t    # print(\"$key belongs to no class. why?\\n\");\n\t\t}\n\t\tif ($self->{'contigs'}->{$key}->{'member_array'}) {\n\t\t\t@array = @{$self->{'contigs'}->{$key}->{'member_array'}};\n\t\t}\n\t\tmy $num_array_elem = @array;\n\t\tif ($num_array_elem == 1 && $self->{'contigs'}->{$key}->{'class'} && $self->{'contigs'}->{$key}->{'class'} eq \"singleton\") { push @singletons,$key; }\n\t}\n\treturn @singletons;\n}\n\n=head2 get_pairs()\n\n Title   : get_pairs()\n Usage   : @pairs = $o_consed->get_pairs();\n Function: Return the keynames of the pairs.\n Returns : Returns an array containing the keynames of all\n           Bio::Tools::Alignment::Consed sequences in the class \"pair\".\n Args    : None.\n Notes   : \n\n\nsub get_pairs {\n    # returns an array of pair contig names\n    # a pair is a contig of two where the names do not match\n    my $self = shift;\n    my (@pairs,@array);\n    foreach my $key (sort keys %{$self->{'contigs'}}) {\n        if ($self->{'contigs'}->{$key}->{'member_array'}) {\n            if (@{$self->{'contigs'}->{$key}->{'member_array'}} == 2 &&\n                $self->{'contigs'}->{$key}->{'class'} eq \"pair\") {\n                push @pairs,$key;\n            }\n        }\n    }\n    return @pairs;\n}\n\n=head2 get_name($contig_keyname)\n\n Title   : get_name($contig_keyname)\n Usage   : $name = $o_consed->get_name($contig_keyname);\n Function: Return the {name} for $contig_keyname.\n Returns : A string. ({name})\n Args    : A contig keyname.\n Notes   : \n\n\nsub get_name {\n    my ($self,$contig) = @_;\n    return $self->{'contigs'}->{$contig}->{'name'};\n}\n\n=head2 _get_contig_name(\\@array_containing_reads)\n\n Title   : _get_contig_name(\\@array_containing_reads)\n Usage   : $o_consed->_get_contig_name(\\@array_containing_reads);\n Function: The logic for the set_doublets subroutine.\n Returns : The name for this contig.\n Args    : A reference to an array containing read names.\n Notes   : Depends on reverse_designator. Be sure this is set the way you\n\t   intend.\n\n\nsub _get_contig_name {\n    my ($self,$r_array) = @_;\n    my @contig_members = @$r_array;\n    my @name_nodir;\n    foreach (@contig_members) {\n        # how can I distinguish the clone name from the direction label?\n        # look for $Consed::reverse_designator and $Consed::forward_designator\n        # what if you do not find _any_ of those?\n        my $forward_designator = $self->{'forward_designator'} || \"f\";\n        my $reverse_designator = $self->{'reverse_designator'} || \"r\";\n        my $any_hits = /(.+)($forward_designator.*)/ || /(.+)($reverse_designator.*)/||/(.+)(_.+)/;\n        my $name = $1;\n        my $suffix = $2;\n        if ($name) {\n            # print(\"\\t\\$name is $name \");\n        }\n        if ($suffix) {\n            # print(\"and \\$suffix is $suffix.\\n\");\n        }\n                                # Jee, I hope we get a naming convention soon\n        if ($suffix) {\n            if ($suffix =~ /^$forward_designator/ || $suffix =~ /^$reverse_designator/) {\n                push @name_nodir,$name;\n            }\n\t\t\t\t# bugwatch here! should this be unnested?\n            else {\n                push @name_nodir,\"$name$suffix\";\n            }\n        }\n    }\n    # print(\"\\@name_nodir: @name_nodir\\n\");\n    my $mismatch = 0;\n    for (my $counter=0; $counter<@name_nodir;$counter++) {\n        next if ($name_nodir[0] eq $name_nodir[$counter]);\n        $mismatch = 1;\n    }\n    if ($mismatch == 0) {\n        # print(\"\\tYou have a cohesive contig named $name_nodir[0].\\n\\n\");\n        return $name_nodir[0];\n    } else {\n        # print(\"\\tYou have mixed names in this contig.\\n\\n\");\n    }\n}                               # end _get_contig_name\n\n=head2 get_doublets()\n\n Title   : get_doublets()\n Usage   : @doublets = $o_consed->get_doublets();\n Function: Return the keynames of the doublets.\n Returns : Returns an array containing the keynames of all\n           Bio::Tools::Alignment::Consed sequences in the class \"doublet\".\n Args    : None.\n Notes   : \n\n\nsub get_doublets {\n    my $self = shift;\n    if (!$self->{doublets_set}) {\n        $self->warn(\"You need to set the doublets before you can get them. Doing that now.\");\n        $self->set_doublets();\n    }\n    my @doublets;\n    foreach (sort keys %{$self->{'contigs'}}) {\n        if ($self->{'contigs'}->{$_}->{name} && $self->{'contigs'}->{$_}->{'class'} eq \"doublet\") {\n            push @doublets,$_;\n        }\n    }\n    return @doublets;\n}                               # end get_doublets\n\n=head2 dump_hash()\n\n Title   : dump_hash()\n Usage   : $o_consed->dump_hash();\n Function: Use dumpvar.pl to dump out the Bio::Tools::Alignment::Consed\n           object to STDOUT.\n Returns : Nothing.\n Args    : None.\n Notes   : I used this a lot in debugging.\n\n\nsub dump_hash {\n    my $self = shift;\n    my $dumper = new Dumpvalue;\n    $self->debug( \"Bio::Tools::Alignment::Consed::dump_hash - \".\n                  \"The following is the contents of the contig hash...\\n\");\n    $dumper->dumpValue($self->{'contigs'});\n}\n\n=head2 dump_hash_compact()\n\n Title   : dump_hash_compact()\n Usage   : $o_consed->dump_hash_compact();\n Function: Dump out the Bio::Tools::Alignment::Consed object in a compact way.\n Returns : Nothing.\n Args    : Nothing.\n Notes   : Cleaner then dumpValue(), dumpHash(). I used this a lot in\n           debugging."},"detail":"($self,$sequence)","definition":"sub","containerName":"main::","children":[{"kind":13,"line":1531,"containerName":"dump_hash_compact","definition":"my","name":"$self","localvar":"my"},{"line":1531,"kind":13,"name":"$sequence","containerName":"dump_hash_compact"},{"kind":13,"line":1533,"containerName":"dump_hash_compact","name":"@singlets","definition":"my","localvar":"my"},{"containerName":"dump_hash_compact","name":"$self","line":1533,"kind":13},{"containerName":"dump_hash_compact","name":"get_singlets","line":1533,"kind":12},{"definition":"my","name":"@singletons","containerName":"dump_hash_compact","localvar":"my","kind":13,"line":1534},{"line":1534,"kind":13,"containerName":"dump_hash_compact","name":"$self"},{"name":"get_singletons","containerName":"dump_hash_compact","kind":12,"line":1534},{"containerName":"dump_hash_compact","definition":"my","name":"@doublets","localvar":"my","kind":13,"line":1535},{"line":1535,"kind":13,"containerName":"dump_hash_compact","name":"$self"},{"name":"get_doublets","containerName":"dump_hash_compact","kind":12,"line":1535},{"name":"@pairs","definition":"my","containerName":"dump_hash_compact","localvar":"my","kind":13,"line":1536},{"kind":13,"line":1536,"name":"$self","containerName":"dump_hash_compact"},{"containerName":"dump_hash_compact","name":"get_pairs","kind":12,"line":1536},{"containerName":"dump_hash_compact","name":"@multiplets","definition":"my","localvar":"my","kind":13,"line":1537},{"name":"$self","containerName":"dump_hash_compact","line":1537,"kind":13},{"kind":12,"line":1537,"name":"get_multiplets","containerName":"dump_hash_compact"},{"kind":13,"line":1539,"name":"@singlets","containerName":"dump_hash_compact"},{"line":1540,"kind":13,"localvar":"my","name":"@members","definition":"my","containerName":"dump_hash_compact"},{"name":"$self","containerName":"dump_hash_compact","line":1540,"kind":13},{"name":"get_members","containerName":"dump_hash_compact","line":1540,"kind":12},{"kind":13,"line":1541,"name":"$self","containerName":"dump_hash_compact"},{"line":1541,"kind":12,"containerName":"dump_hash_compact","name":"get_name"},{"name":"@members","containerName":"dump_hash_compact","kind":13,"line":1541},{"name":"$self","containerName":"dump_hash_compact","kind":13,"line":1542},{"name":"@singletons","containerName":"dump_hash_compact","kind":13,"line":1549},{"kind":13,"line":1550,"name":"@members","definition":"my","containerName":"dump_hash_compact","localvar":"my"},{"name":"$self","containerName":"dump_hash_compact","line":1550,"kind":13},{"name":"get_members","containerName":"dump_hash_compact","line":1550,"kind":12},{"containerName":"dump_hash_compact","name":"$self","kind":13,"line":1551},{"name":"get_name","containerName":"dump_hash_compact","line":1551,"kind":12},{"name":"@members","containerName":"dump_hash_compact","line":1551,"kind":13},{"containerName":"dump_hash_compact","name":"$self","kind":13,"line":1552},{"definition":"my","name":"$pair","containerName":"dump_hash_compact","localvar":"my","kind":13,"line":1558},{"kind":13,"line":1558,"name":"@pairs","containerName":"dump_hash_compact"},{"containerName":"dump_hash_compact","name":"@members","definition":"my","localvar":"my","kind":13,"line":1559},{"kind":13,"line":1559,"name":"$self","containerName":"dump_hash_compact"},{"containerName":"dump_hash_compact","name":"get_members","kind":12,"line":1559},{"name":"$pair","containerName":"dump_hash_compact","kind":13,"line":1559},{"containerName":"dump_hash_compact","definition":"my","name":"$name","localvar":"my","kind":13,"line":1560},{"containerName":"dump_hash_compact","name":"$self","line":1561,"kind":13},{"containerName":"dump_hash_compact","name":"get_name","line":1561,"kind":12},{"line":1561,"kind":13,"containerName":"dump_hash_compact","name":"$pair"},{"line":1562,"kind":13,"containerName":"dump_hash_compact","name":"$name"},{"name":"$name","containerName":"dump_hash_compact","line":1564,"kind":13},{"name":"$self","containerName":"dump_hash_compact","kind":13,"line":1564},{"name":"get_name","containerName":"dump_hash_compact","kind":12,"line":1564},{"containerName":"dump_hash_compact","name":"$pair","line":1564,"kind":13},{"name":"@members","containerName":"dump_hash_compact","kind":13,"line":1566},{"kind":13,"line":1568,"containerName":"dump_hash_compact","name":"@doublets"},{"localvar":"my","containerName":"dump_hash_compact","definition":"my","name":"@members","line":1569,"kind":13},{"line":1569,"kind":13,"name":"$self","containerName":"dump_hash_compact"},{"name":"get_members_by_name","containerName":"dump_hash_compact","line":1569,"kind":12},{"line":1570,"kind":13,"name":"@members","containerName":"dump_hash_compact"},{"containerName":"dump_hash_compact","name":"$contig_number","definition":"my","localvar":"my","kind":13,"line":1571},{"line":1571,"kind":13,"containerName":"dump_hash_compact","name":"$self"},{"line":1572,"kind":13,"containerName":"dump_hash_compact","name":"$self"},{"kind":13,"line":1572,"name":"$contig_number","containerName":"dump_hash_compact"},{"containerName":"dump_hash_compact","name":"@multiplets","kind":13,"line":1579},{"localvar":"my","name":"@members","definition":"my","containerName":"dump_hash_compact","line":1580,"kind":13},{"name":"$self","containerName":"dump_hash_compact","kind":13,"line":1580},{"name":"get_members","containerName":"dump_hash_compact","kind":12,"line":1580},{"line":1581,"kind":13,"containerName":"dump_hash_compact","name":"@members"}],"line":1529,"kind":12,"range":{"start":{"character":0,"line":1529},"end":{"line":1583,"character":9999}},"name":"dump_hash_compact"},{"line":1530,"kind":12,"name":"strict"},{"kind":12,"line":1606,"children":[{"kind":13,"line":1608,"containerName":"get_phreds","name":"$self","definition":"my","localvar":"my"},{"kind":13,"line":1609,"definition":"my","name":"$current_contig","containerName":"get_phreds","localvar":"my"},{"containerName":"get_phreds","name":"$current_contig","line":1610,"kind":13},{"name":"$self","containerName":"get_phreds","kind":13,"line":1610}],"containerName":"main::","name":"get_phreds","definition":"sub","range":{"start":{"line":1606,"character":0},"end":{"line":1610,"character":9999}}},{"containerName":null,"name":"%self","line":1611,"kind":13},{"containerName":null,"name":"%current_contig","line":1611,"kind":13},{"name":"$self","containerName":null,"line":1612,"kind":13},{"kind":12,"line":1612,"name":"debug","containerName":"main::"},{"line":1613,"kind":13,"localvar":"my","containerName":null,"name":"$r_phreds_top","definition":"my"},{"kind":12,"line":1613,"name":"parse_phd"},{"kind":13,"line":1613,"name":"$self","containerName":null},{"line":1613,"kind":13,"containerName":null,"name":"%self"},{"containerName":null,"name":"%current_contig","line":1613,"kind":13},{"containerName":null,"name":"$r_phreds_bottom","definition":"my","localvar":"my","kind":13,"line":1614},{"line":1614,"kind":12,"name":"parse_phd"},{"kind":13,"line":1614,"containerName":null,"name":"$self"},{"name":"%self","containerName":null,"kind":13,"line":1614},{"containerName":null,"name":"%current_contig","line":1614,"kind":13},{"containerName":null,"name":"%self","line":1615,"kind":13},{"kind":13,"line":1615,"name":"%current_contig","containerName":null},{"line":1617,"kind":13,"name":"$r_phreds_top","containerName":null},{"line":1617,"kind":12,"name":"reverse_and_complement"},{"kind":13,"line":1617,"name":"$r_phreds_top","containerName":null},{"line":1619,"kind":13,"name":"%self","containerName":null},{"line":1619,"kind":13,"name":"%current_contig","containerName":null},{"kind":13,"line":1620,"name":"$r_phreds_bottom","containerName":null},{"name":"reverse_and_complement","line":1620,"kind":12},{"line":1620,"kind":13,"containerName":null,"name":"$r_phreds_bottom"},{"name":"%self","containerName":null,"kind":13,"line":1622},{"name":"%current_contig","containerName":null,"line":1622,"kind":13},{"line":1622,"kind":13,"name":"$r_phreds_top","containerName":null},{"name":"%self","containerName":null,"line":1623,"kind":13},{"containerName":null,"name":"%current_contig","kind":13,"line":1623},{"line":1623,"kind":13,"name":"$r_phreds_bottom","containerName":null},{"detail":"($self,$sequence_name)","signature":{"parameters":[{"label":"$self"},{"label":"$sequence_name"}],"documentation":"1;\n# $Id: Consed.pm 16123 2009-09-17 12:57:27Z cjfields $\n# Bio::Tools::Alignment::Consed\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chad Matsalla\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Alignment::Consed - A module to work with objects from consed .ace files\n\n=head1 SYNOPSIS\n\n  # a report for sequencing stuff\n  my $o_consed = Bio::Tools::Alignment::Consed->new( \n      -acefile => \"/path/to/an/acefile.ace.1\",\n      -verbose => 1);\n  my $foo = $o_consed->set_reverse_designator(\"r\");\n  my $bar = $o_consed->set_forward_designator(\"f\");\n\n  # get the contig numbers\n  my @keys = $o_consed->get_contigs();\n\n  # construct the doublets\n  my $setter_doublets = $o_consed->choose_doublets();\n\n  # get the doublets\n  my @doublets = $o_consed->get_doublets();\n\n=head1 DESCRIPTION\n\nL<Bio::Tools::Alignment::Consed> provides methods and objects to deal\nwith the output from the Consed software suite. Specifically,\ntakes an C<.ace> file and provides objects for the results.\n\nA word about doublets: This module was written to accomodate a large\nEST sequencing operation. In this case, EST's were sequenced from the\n3' and from the 5' end of the EST. The objective was to find a\nconsensus sequence for these two reads.  Thus, a contig of two is what\nwe wanted, and this contig should consist of the forward and reverse\nreads of a getn clone. For example, for a forward designator of \"F\"\nand a reverse designator of \"R\", if the two reads chad1F and chad1R\nwere in a single contig (for example Contig 5) it will be determined\nthat the consensus sequence for Contig 5 will be the sequence for\nclone chad1.\n\nDoublets are good!\n\nThis module parses C<.ace> and related files. A detailed list of methods\ncan be found at the end of this document.\n\nI wrote a detailed rationale for design that may explain the reasons\nwhy some things were done the way they were done. That document is\nbeyond the scope of this pod and can probably be found in the\ndirectory from which this module was 'made' or at\nL<http://www.dieselwurks.com/bioinformatics/consedpm_documentation.pdf>.\n\nNote that the POD in that document might be old but the original\nrationale still stands.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nEmail chad-at-dieselwurks.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n#' \n\npackage Bio::Tools::Alignment::Consed;\n\nuse strict;\n\nuse FileHandle;\nuse Dumpvalue qw(dumpValue);\nuse Bio::Tools::Alignment::Trim;\nuse File::Spec;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\nour %DEFAULTS = ( 'f_designator' => 'f',\n\t\t  'r_designator' => 'r');\n\n=head2 new()\n\n Title   : new(-acefile => $path_to_some_acefile, -verbose => \"1\")\n Usage   : $o_consed = Bio::Tools::Alignment::Consed->\n              new(-acefile => $path_to_some_acefile, -verbose => \"1\");\n Function: Construct the Bio::Tools::Alignment::Consed object. Sets\n\t   verbosity for the following procedures, if necessary:\n\t   1. Construct a new Bio::Tools::Alignment::Trim object, to\n\t   handle quality trimming 2. Read in the acefile and parse it\n\n Returns : A reference to a Bio::Tools::Alignment::Consed object.\n Args    : A hash. (-acefile) is the filename of an acefile. If a full path\n\t   is not specified \"./\" is prepended to the filename and used from\n\t   instantiation until destruction. If you want \n           Bio::Tools::Alignment::Consed to be noisy during parsing of\n           the acefile, specify some value for (-verbose).\n\n\nsub new {\n    my ($class,%args) = @_;\n    my $self = $class->SUPER::new(%args);\n\n    $self->{'filename'} = $args{'-acefile'};\n\n    # this is special to UNIX and should probably use catfile : DONE!\n#    if (!($self->{'filename'} =~ m{/})) { \n#\t$self->{'filename'} = \"./\".$self->{'filename'}; \n#    } \n#    $self->{'filename'} =~ m/(.*\\/)(.*)ace.*$/;\n#    $self->{'path'} = $1;\n\n    # this is more generic and should work on most systems   \n    (undef, $self->{'path'}, undef) = File::Spec->splitpath($self->{'filename'});\n\n    $self->_initialize_io('-file'=>$self->{'filename'});\n    $self->{'o_trim'} = Bio::Tools::Alignment::Trim->new(-verbose => $self->verbose());\n    $self->set_forward_designator($DEFAULTS{'f_designator'});\n    $self->set_reverse_designator($DEFAULTS{'r_designator'});\n\n    $self->_read_file();\n    return $self;\n}\n\n=head2 set_verbose()\n\n Title   : set_verbose()\n Usage   : $o_consed->set_verbose(1);\n Function: Set the verbosity level for debugging messages. On instantiation\n\t   of the Bio::Tools::Alignment::Consed object the verbosity level\n           is set to 0 (quiet).\n Returns : 1 or 0.\n Args    : The verbosity levels are:\n\t      0 - quiet\n\t      1 - noisy\n\t      2 - noisier\n\t      3 - annoyingly noisy\n\nThis method for setting verbosity has largely been superseeded by a\nsub-by-sub way, where for every sub you can provide a (-verbose)\nswitch. I am doing converting this bit-by-bit so do not be surprised\nif some subs do not honour this.\n\n\n# from RootI\n\n# backwards compat\nsub set_verbose { (shift)->verbose(@_) }\n\n=head2 get_filename()\n\n Title   : get_filename()\n Usage   : $o_consed->get_filename();\n Function: Returns the name of the acefile being used by the\n\t   Bio::Tools::Alignment::Consed object.\n Returns : A scalar containing the name of a file.\n Args    : None.\n\n\n\nsub get_filename {\n    my $self = shift;\n    return $self->{'filename'};\n}\n\n=head2 count_sequences_with_grep()\n\n Title   : count_sequences_with_grep()\n Usage   : $o_consed->count_sequences_with_grep();\n Function: Use /bin/grep to scan through the files in the ace project dir\n\t   and count sequences in those files. I used this method in the\n\t   development of this module to verify that I was getting all of the\n\t   sequences. It works, but it is (I think) unix-like platform\n\t   dependent.\n Returns : A scalar containing the number of sequences in the ace project\n\t   directory.\n Args    : None.\n\nIf you are on a non-UNIX platform, you really do not have to use\nthis. It is more of a debugging routine designed to address very\nspecific problems.\n\nThis method was reimplemented to be platform independent with a pure\nperl implementation.  The above note can be ignored.\n\n\nsub count_sequences_with_grep {\n    my $self = shift;\n    my ($working_dir,$grep_cli,@total_grep_sequences);\n    # this should be migrated to a pure perl implementation ala\n    # Tom Christiansen's 'tcgrep'\n    # http://www.cpan.org/modules/by-authors/id/TOMC/scripts/tcgrep.gz\n\n    open(my $FILE, $self->{'filename'}) or do { $self->warn(\"cannot open file \".$self->{'filename'}. \" for grepping\"); return}; \n    my $counter =0;\n    while(<$FILE>) { $counter++ if(/^AF/); }\n\n    close $FILE;\n    opendir(my $SINGLETS,$self->{'path'});\n    foreach my $f ( readdir($SINGLETS) ) {\n\tnext unless ($f =~ /\\.singlets$/); \n\topen(my $FILE, File::Spec->catfile($self->{'path'},$f)) or do{ $self->warn(\"cannot open file \".File::Spec->catfile($self->{'path'},$f)); next };\n\twhile(<$FILE>) { $counter++ if(/^>/) }\n\tclose $FILE;\n    }\n    return $counter;\n}\n\n=head2 get_path()\n\n Title   : get_path()\n Usage   : $o_consed->get_path();\n Function: Returns the path to the acefile this object is working with.\n Returns : Scalar. The path to the working acefile.\n Args    : None.\n\n\nsub get_path {\n    my $self = shift;\n    return $self->{'path'};\n}\n\n=head2 get_contigs()\n\n Title   : get_contigs()\n Usage   : $o_consed->get_contigs();\n Function: Return the keys to the Bio::Tools::Alignment::Consed object.\n Returns : An array containing the keynames in the\n           Bio::Tools::Alignment::Consed object.\n Args    : None.\n\nThis would normally be used to get the keynames for some sort of\niterator. These keys are worthless in general day-to-day use because\nin the Consed acefile they are simply Contig1, Contig2, ...\n\n\nsub get_contigs {\n    my ($self,$contig) = @_;\n    my @contigs = sort keys %{$self->{'contigs'}};\n    return @contigs;\n}\n\n=head2 get_class($contig_keyname)\n\n Title   : get_class($contig_keyname)\n Usage   : $o_consed->get_class($contig_keyname);\n Function: Return the class name for this contig\n Returns : A scalar representing the class of this contig.\n Args    : None.\n Notes   : \n\n\nsub get_class {\n    my ($self,$contig) = @_;\n    return $self->{contigs}->{$contig}->{class};\n}\n\n=head2 get_quality_array($contig_keyname)\n\n Title   : get_quality_array($contig_keyname)\n Usage   : $o_consed->get_quality_array($contig_keyname);\n Function: Returns the quality for the consensus sequence for the given\n\t   contig as an array. See get_quality_scalar to get this as a scalar.\n Returns : An array containing the quality for the consensus sequence with\n\t   the given keyname.\n Args    : The keyname of a contig. Note: This is a keyname. The key would\n\t   normally come from get_contigs.\n\nReturns an array, not a reference. Is this a bug? I<thinking> No.\nWell, maybe.  Why was this developed like this? I was using FreezeThaw\nfor object persistence, and when it froze out these arrays it took a\nlong time to thaw it. Much better as a scalar.\n\nSee L<get_quality_scalar()|get_quality_scalar>\n\n\nsub get_quality_array {\n    my ($self,$contig) = @_;\n    return split ' ', $self->{contigs}->{$contig}->{quality};\n}\n\n=head2 get_quality_scalar($contig_keyname)\n\n Title   : get_quality_scalar($contig_keyname)\n Usage   : $o_consed->get_quality_scalar($contig_keyname);\n Function: Returns the quality for the consensus sequence for the given\n\t   contig as a scalar. See get_quality_array to get this as an array.\n Returns : An scalar containing the quality for the consensus sequence with\n           the given keyname.\n Args    : The keyname of a contig. Note this is a _keyname_. The key would\n\t   normally come from get_contigs.\n\nWhy was this developed like this? I was using FreezeThaw for object\npersistence, and when it froze out these arrays it took a coon's age\nto thaw it. Much better as a scalar.\n\nSee L<get_quality_array()|get_quality_array>\n\n\n#'\nsub get_quality_scalar {\n    my ($self,$contig) = @_;\n    return $self->{'contigs'}->{$contig}->{'quality'};\n}\n\n=head2 freeze_hash()\n\n Title   : freeze_hash()\n Usage   : $o_consed->freeze_hash();\n\n Function: Use Ilya's FreezeThaw module to create a persistent data\n\t   object for this Bio::Tools::Alignment::Consed data\n\t   structure. In the case of AAFC, we use\n\t   Bio::Tools::Alignment::Consed to pre-process bunches of\n\t   sequences, freeze the structures, and send in a harvesting\n\t   robot later to do database stuff.\n Returns : 0 or 1;\n Args    : None.\n\nThis procedure was removed so Consed.pm won't require FreezeThaw.\n\n\n#'\nsub freeze_hash {\n    my $self = shift;\n    $self->warn(\"This method (freeze_hash) was removed \".\n                \"from the bioperl consed.pm. Sorry.\\n\");\n    if (1==2) {\n        $self->debug(\"Bio::Tools::Alignment::Consed::freeze_hash:\".\n                     \" \\$self->{path} is $self->{path}\\n\");\n        my $filename = $self->{'path'}.\"frozen\";\n        my %contigs = %{$self->{'contigs'}};\n        my $frozen = freeze(%contigs);\n        umask 0001;\n        open (my $FREEZE,\">$filename\") or do {\n            $self->warn( \"Bio::Tools::Alignment::Consed could not \".\n                         \"freeze the contig hash because the file \".\n                         \"($filename) could not be opened: $!\\n\");\n            return 1;\n        };\n        print $FREEZE $frozen;\n        return 0;\n    }\n}\n\n=head2 get_members($contig_keyname)\n\n Title   : get_members($contig_keyname)\n Usage   : $o_consed->get_members($contig_keyname);\n Function: Return the _names_ of the reads in this contig.\n Returns : An array containing the names of the reads in this contig.\n Args    : The keyname of a contig. Note this is a keyname. The keyname\n\t   would normally come from get_contigs.\n\nSee L<get_contigs()|get_contigs>\n\n\nsub get_members {\n    my ($self,$contig) = @_;\n    if (!$contig) {\n\t$self->warn(\"You need to provide the name of a contig to \".\n                    \"use Bio::Tools::Alignment::Consed::get_members!\\n\");\n\treturn;\n    }\n    return @{$self->{'contigs'}->{$contig}->{'member_array'}};\n}\n\n=head2 get_members_by_name($some_arbitrary_name)\n\n Title   : get_members_by_name($some_arbitrary_name)\n Usage   : $o_consed->get_members_by_name($some_arbitrary_name);\n Function: Return the names of the reads in a contig. This is the name given\n\t   to $contig{key} based on what is in the contig. This is different\n\t   from the keys retrieved through get_contigs().\n Returns : An array containing the names of the reads in the contig with this\n\t   name.\n Args    : The name of a contig. Not a key, but a name.\n\nHighly inefficient. use some other method if possible.\nSee L<get_contigs()|get_contigs>\n\n\nsub get_members_by_name {\n    my ($self,$name) = @_;\n    # build a list to try to screen for redundancy\n    my @contigs_with_that_name;\n    foreach my $currkey ( sort keys %{$self->{'contigs'}} ) {\n\tnext if (!$self->{'contigs'}->{$currkey}->{'name'});\n\tif ($self->{'contigs'}->{$currkey}->{'name'} eq \"$name\") {\n\t    push @contigs_with_that_name,$currkey;\n\t}\n    }\n    my $count = @contigs_with_that_name;\n    if ($count == 1) {\n\tmy $contig_num = $contigs_with_that_name[0];\n\treturn @{$self->{'contigs'}->{$contig_num}->{'member_array'}};\n    }\n}\n\n=head2 get_contig_number_by_name($some_arbitrary_name)\n\n Title   : get_contig_number_by_name($some_arbitrary_name)\n Usage   : $o_consed->get_contig_number_by_name($some_arbitrary_name);\n Function: Return the names of the reads in a contig. This is the name given\n\t   to $contig{key} based on what is in the contig. This is different\n\t   from the keys retrieved through get_contigs().\n Returns : An array containing the names of the reads in the contig with this\n\t   name.\n Args    : The name of a contig. Not a key, but a name.\n\nSee L<get_contigs()|get_contigs>\n\n\nsub get_contig_number_by_name {\n    my ($self,$name) = @_;\n    foreach my $currkey (sort keys %{$self->{'contigs'}}) {\n\tif ($self->{'contigs'}->{$currkey}->{'name'} && \n\t    $self->{'contigs'}->{$currkey}->{'name'} eq \"$name\") {\n\t    return $currkey;\n\t}\n    }\n}\t\n\n=head2 get_sequence($contig_keyname)\n\n Title   : get_sequence($contig_keyname)\n Usage   : $o_consed->get_sequence($contig_keyname); \n Function: Returns the consensus sequence for a given contig.\n Returns : A scalar containing a sequence.\n Args    : The keyname of a contig. Note this is a key. The key would\n\t   normally come from get_contigs.\n\nSee L<get_contigs()|get_contigs>\n\n\nsub get_sequence {\n    my ($self,$contig) = @_;\n    return $self->{'contigs'}->{$contig}->{'consensus'};\n}\n\n=head2 set_final_sequence($some_sequence)\n\n Title   : set_final_sequence($name,$some_sequence)\n Usage   : $o_consed->set_final_sequence($name,$some_sequence);\n Function: Provides a manual way to set the sequence for a given key in the\n\t   contig hash. Rarely used.\n Returns : 0 or 1;\n Args    : The name (not the keyname) of a contig and an arbitrary string.\n\nA method with a questionable and somewhat mysterious origin. May raise\nthe dead or something like that.\n\n\nsub set_final_sequence {\n    my ($self,$name,$sequence) = @_;\n    if (!$self->{'contigs'}->{$name}) {\n\t$self->warn(\"You cannot set the final sequence for \".\n                    \"$name because it doesn't exist!\\n\");\n\treturn 1;\n    }\n    else {\n\t$self->{'contigs'}->{$name}->{'final_sequence'} = $sequence;\n    }\n    return 0;\n}\n\n=head2  _read_file()\n\n Title   : _read_file();\n Usage   : _read_file();\n Function: An internal subroutine used to read in an acefile and parse it\n\t   into a Bio::Tools::Alignment::Consed object.\n Returns : 0 or 1.\n Args    : Nothing.\n\nThis routine creates and saves the filhandle for reading the files in\n{fh}\n\n\nsub _read_file {\n    my ($self) = @_;\n    my ($line,$in_contig,$in_quality,$contig_number,$top);\n    # make it easier to type $fhl\n    while (defined($line=$self->_readline()) ) {\n\tchomp $line;\n\t# check if there is anything on this line\n\t# if not, you can stop gathering consensus sequence\n\tif (!$line) {\n\t    # if the line is blank you are no longer to gather consensus \n\t    # sequence or quality values\n\t    $in_contig = 0;\n\t    $in_quality = 0;\n\t}\n\t# you are currently gathering consensus sequence\n\telsif ($in_contig) {\n\t    if ($in_contig == 1) {\n\t\t$self->debug(\"Adding $line to consensus of contig number $contig_number.\\n\");\n\t\t$self->{'contigs'}->{$contig_number}->{'consensus'} .= $line;\n\t    }\n\t}\n\telsif ($in_quality) {\n\t    if (!$line) {\n\t\t$in_quality = undef;\n\t    }\n\t    else {\n\n\t\t# I wrote this in here because acefiles produced by\n\t\t# cap3 do not have a leading space like the acefiles\n\t\t# produced by phrap and there is the potential to have\n\t\t# concatenated quality values like this: 2020 rather\n\t\t# then 20 20 whre lines collide. Thanks Andrew for\n\t\t# noticing.\n\n\t\tif ($self->{'contigs'}->{$contig_number}->{'quality'} &&\n                    !($self->{'contigs'}->{$contig_number}->{'quality'} =~ m/\\ $/)) {\n\t\t    $self->{'contigs'}->{$contig_number}->{'quality'} .= \" \";\n\t\t}\n\t\t$self->{'contigs'}->{$contig_number}->{'quality'} .= $line;\n\t    }\n\t}\n\telsif ($line =~ /^BQ/) {\n\t    $in_quality = 1;\n\t}\n\n\t# the line /^CO/ like this:\n\t# CO Contig1 796 1 1 U\n\t# can be broken down as follows:\n\t# CO - Contig!\n\t# Contig1 - the name of this contig\n\t# 796 - Number of bases in this contig\n\t# 1 - Number of reads in this contig\n\t# 1 - number of base segments in this contig\n\t# U - Uncomplemented\n\n\telsif ($line =~ /^CO/) {\n\t    $line =~ m/^CO\\ Contig(\\d+)\\ \\d+\\ \\d+\\ \\d+\\ (\\w)/;\n\t    $contig_number = $1;\n\t    if ($2 eq \"C\") {\n\t\t$self->debug(\"Contig $contig_number is complemented!\\n\");\n\t    }\n\t    $self->{'contigs'}->{$contig_number}->{'member_array'} = [];\n\t    $self->{'contigs'}->{$contig_number}->{'contig_direction'} = \"$2\";\n\t    $in_contig = 1;\n\t}\n\n\t# 000713\n\t# this BS is deprecated, I think.\n\t# haha, I am really witty. <ew>\n\n\telsif ($line =~ /^BSDEPRECATED/) {\n\t    $line =~ m/^BS\\s+\\d+\\s+\\d+\\s+(.+)/;\n\t    my $member = $1;\n\t    $self->{'contigs'}->{$contig_number}->{$member}++;\n\t}\n\t# the members of the contigs are determined by the AF line in the ace file\n\telsif ($line =~ /^AF/) {\n\t    $self->debug(\"I see an AF line here.\\n\");\n\t    $line =~ /^AF\\ (\\S+)\\ (\\w)\\ (\\S+)/;\n\n            # push the name of the current read onto the member array for this contig\n\t    push @{$self->{'contigs'}->{$contig_number}->{'member_array'}},$1;\n\n            # the first read in the contig will be named the \"top\" read\n\t    if (!$top) {\n\t\t$self->debug(\"\\$top is not set.\\n\");\n\t\tif ($self->{'contigs'}->{$contig_number}->{'contig_direction'} eq \"C\") {\n\t\t    $self->debug(\"Reversing the order of the reads. The bottom will be $1\\n\");\n\n\t\t    # if the contig sequence is marked as the\n\t\t    # complement, the top becomes the bottom and$\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_name'} = $1;\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_complement'} = $2;\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_start'} = $3;\n\t\t}\n\t\telse {\n\t\t    $self->debug(\"NOT reversing the order of the reads. \".\n                                 \"The top_name will be $1\\n\");\n\t\t    # if the contig sequence is marked as the\n\t\t    # complement, the top becomes the bottom and$\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_name'} = $1;\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_complement'} = $2;\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_start'} = $3;\n\t\t}\n\t\t$top = 1;\n\t    }\n\t    else {\n\n\t\t# if the contig sequence is marked as the complement,\n\t\t# the top becomes the bottom and the bottom becomes\n\t\t# the top\n\t\tif ($self->{'contigs'}->{$contig_number}->{'contig_direction'} eq \"C\") {\n\t\t    $self->debug(\"Reversing the order of the reads. The top will be $1\\n\");\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_name'} = $1;\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_complement'} = $2;\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_start'} = $3;\n\t\t}\n\t\telse {\n\t\t    $self->debug(\"NOT reversing the order of the reads. The bottom will be $1\\n\");\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_name'} = $1;\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_complement'} = $2;\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_start'} = $3;\n\t\t}\n\t\t$top = undef;\n\t    }\n\t}\n    }\n    return 0;\n}\n\n=head2 set_reverse_designator($some_string)\n\n Title   : set_reverse_designator($some_string)\n Usage   : $o_consed->set_reverse_designator($some_string);\n Function: Set the designator for the reverse read of contigs in this\n\t   Bio::Tools::Alignment::Consed object. Used to determine if\n           contigs containing two reads can be named.\n Returns : The value of $o_consed->{reverse_designator} so you can check\n\t   to see that it was set properly.\n Args    : An arbitrary string.\n\nMay be useful only to me. I<shrug>\n\n\nsub set_reverse_designator {\n    my ($self,$reverse_designator) = @_;\n    $self->{'reverse_designator'} = $reverse_designator;\n    $self->{'o_trim'}->set_reverse_designator($reverse_designator);\n    return $self->{'reverse_designator'};\n}\t\t\t\t# end set_reverse_designator\n\n=head2 set_forward_designator($some_string)\n\n Title   : set_forward_designator($some_string)\n Usage   : $o_consed->set_forward_designator($some_string);\n Function: Set the designator for the forward read of contigs in this\n\t   Bio::Tools::Alignment::Consed object. Used to determine if\n           contigs containing two reads can be named.\n Returns : The value of $o_consed->{forward_designator} so you can check\n\t   to see that it was set properly.\n Args    : An arbitrary string.\n\nMay be useful only to me. I<shrug>\n\n\nsub set_forward_designator {\n    my ($self,$forward_designator) = @_;\n    $self->{'forward_designator'} = $forward_designator;\n    $self->{'o_trim'}->set_forward_designator($forward_designator);\n    return $self->{'forward_designator'};\n}\t\t\t\t# end set_forward_designator\n\n=head2 set_designator_ignore_case(\"yes\")\n\n Title   : set_designator_ignore_case(\"yes\")\n Usage   : $o_consed->set_designator_ignore_case(\"yes\");\n Function: Deprecated.\n Returns : Deprecated.\n Args    : Deprecated.\n\nDeprecated. Really. Trust me.\n\n\nsub set_designator_ignore_case {\n    my ($self,$ignore_case) = @_;\n    if ($ignore_case eq \"yes\") {\n\t$self->{'designator_ignore_case'} = 1;\n    }\n    return $self->{'designator_ignore_case'};\n}\t\t\t\t# end set_designator_ignore_case\n\n=head2 set_trim_points_singlets_and_singletons()\n\n Title   : set_trim_points_singlets_and_singletons()\n Usage   : $o_consed->set_trim_points_singlets_and_singletons();\n Function: Set the trim points for singlets and singletons based on\n\t   quality.  Uses the Bio::Tools::Alignment::Trim object. Use\n\t   at your own risk because the Bio::Tools::Alignment::Trim\n\t   object was designed specifically for me and is mysterious\n\t   in its ways. Every time somebody other then me uses it a\n\t   swarm of locusts decends on a small Central American\n\t   village so do not say you weren't warned.\n Returns : Nothing.\n Args    : None.\n\nWorking on exceptions and warnings here.\n\nSee L<Bio::Tools::Alignment::Trim> for more information\n\n\n#' to make my emacs happy\n\nsub set_trim_points_singlets_and_singletons {\n    my ($self) = @_;\n    $self->debug(\"Consed.pm : \\$self is $self\\n\");\n    my (@points,$trimmed_sequence);\n    if (!$self->{'doublets_set'}) {\n        $self->debug(\"You need to set the doublets before you use \".\n                     \"set_trim_points_singlets_and_doublets. Doing that now.\");\n\t$self->set_doublets();\n    }\n    foreach (sort keys %{$self->{'contigs'}}) {\n\tif ($self->{'contigs'}->{$_}->{'class'} eq \"singlet\") {\n\t    $self->debug(\"Singlet $_\\n\");\n\t    # this is what Warehouse wants\n\t    #         my ($self,$sequence,$quality,$name) = @_;\n\t    # this is what Bio::Tools::Alignment::Trim::trim_singlet wants:\n\t    # my ($self,$sequence,$quality,$name,$class) = @_;\n\t    # the following several lines are to make the parameter passing legible.\n\t    my ($sequence,$quality,$name,$class);\n\t    $sequence = $self->{'contigs'}->{$_}->{'consensus'};\n\t    if (!$self->{'contigs'}->{$_}->{'quality'}) { $quality = \"unset\"; }\n\t    else { $quality = $self->{'contigs'}->{$_}->{'quality'}; }\n\t    $name = $self->{'contigs'}->{$_}->{'name'};\n\t    $class = $self->{'contigs'}->{$_}->{'class'};\n\t    @points = @{$self->{'o_trim'}->trim_singlet($sequence,$quality,$name,$class)};\n\t    $self->{'contigs'}->{$_}->{'start_point'} = $points[0];\n\t    $self->{'contigs'}->{$_}->{'end_point'} = $points[1];\n\t    $self->{'contigs'}->{$_}->{'sequence_trimmed'} = \n                substr($self->{contigs}->{$_}->{'consensus'},$points[0],$points[1]-$points[0]);\n\t}\n    }\n    $self->debug(\"Bio::Tools::Alignment::Consed::set_trim_points_singlets\".\n                 \"_and_singletons: Done setting the quality trimpoints.\\n\");\n    return;\n}  # end set_trim_points_singlet\n\n=head2 set_trim_points_doublets()\n\n Title   : set_trim_points_doublets()\n Usage   : $o_consed->set_trim_points_doublets();\n Function: Set the trim points for doublets based on quality. Uses the\n\t   Bio::Tools::Alignment::Trim object. Use at your own risk because\n           the Bio::Tools::Alignment::Trim object was designed specifically\n           for me and is mysterious in its ways. Every time somebody other\n           then me uses it you risk a biblical plague being loosed on your\n           city.\n Returns : Nothing.\n Args    : None.\n Notes   : Working on exceptions here.\n\nSee L<Bio::Tools::Alignment::Trim> for more information\n\n\nsub set_trim_points_doublets {\n    my $self = shift;\n    my @points;\n    $self->debug(\"Bio::Tools::Alignment::Consed::set_trim_points_doublets:\".\n                 \" Restoring zeros for doublets.\\n\");\n    # &show_missing_sequence($self);\n    $self->debug(\"Bio::Tools::Alignment::Consed::set_trim_points_doublets:\".\n                 \" Setting doublet trim points.\\n\");\n    foreach (sort keys %{$self->{'contigs'}}) {\n\tif ($self->{'contigs'}->{$_}->{'class'} eq \"doublet\") {\n            # my ($self,$sequence,$quality,$name,$class) = @_;\n            my @quals = split(' ',$self->{'contigs'}->{$_}->{'quality'});\n\n\t    @points = $self->{o_trim}->trim_doublet\n                ($self->{'contigs'}->{$_}->{'consensus'},\n                 $self->{'contigs'}->{$_}->{'quality'},\n                 $self->{'contigs'}->{$_}->{name},\n                 $self->{'contigs'}->{$_}->{'class'});\n\t    $self->{'contigs'}->{$_}->{'start_point'} = $points[0];\n\t    $self->{'contigs'}->{$_}->{'end_point'} = $points[1];\n            # now set this\n\t    $self->{'contigs'}->{$_}->{'sequence_trimmed'} =\n                substr($self->{contigs}->{$_}->{'consensus'},\n                       $points[0],$points[1]-$points[0]);\n\t    # 010102 the deprecated way to do things:\n\t}\n    }\n    $self->debug(\"Bio::Tools::Alignment::Consed::set_trim_points_doublets:\".\n                 \" Done setting doublet trim points.\\n\"); \n    return;\n} # end set_trim_points_doublets\n\n=head2 get_trimmed_sequence_by_name($name)\n\n Title   : get_trimmed_sequence_by_name($name)\n Usage   : $o_consed->get_trimmed_sequence_by_name($name);\n Function: Returns the trimmed_sequence of a contig with {name} eq $name.\n Returns : A scalar- the trimmed sequence.\n Args    : The {name} of a contig.\n Notes   : \n\n\nsub get_trimmed_sequence_by_name {\n    my ($self,$name) = @_;\n    my $trimmed_sequence;\n    my $contigname = &get_contig_number_by_name($self,$name);\n    my $class = $self->{'contigs'}->{$contigname}->{'class'};\n    # what is this business and who was smoking crack while writing this?\n    # if ($class eq \"singlet\") {\n    # send the sequence, the quality, and the name\n    # $trimmed_sequence = $self->{o_trim}->trim_singlet\n    #  ($self->{'contigs'}->{$contigname}->{consensus},\n    #   $self->{'contigs'}->{$contigname}->{'quality'},$name);\n    # }\n    return $self->{'contigs'}->{$contigname}->{'sequence_trimmed'};\n}\n\n=head2 set_dash_present_in_sequence_name(\"yes\")\n\n Title   : set_dash_present_in_sequence_name(\"yes\")\n Usage   : $o_consed->set_dash_present_in_sequence_name(\"yes\");\n Function: Deprecated. Part of an uncompleted thought. (\"Oooh! Shiny!\")\n Returns : Nothing.\n Args    : \"yes\" to set {dash_present_in_sequence_name} to 1\n Notes   : \n\n\nsub set_dash_present_in_sequence_name {\n    my ($self,$dash_present) = @_;\n    if ($dash_present eq \"yes\") {\n\t$self->{'dash_present_in_sequence_name'} = 1;\n    }\n    else {\n\t$self->{'dash_present_in_sequence_name'} = 0;\n    }\n    return $self->{'dash_present_in_sequence_name'};\n} # end set_dash_present_in_sequence_name\n\n=head2 set_doublets()\n\n Title   : set_doublets()\n Usage   : $o_consed->set_doublets();\n Function: Find pairs that have similar names and mark them as doublets\n\t   and set the {name}.\n Returns : 0 or 1.\n Args    : None.\n\nA complicated subroutine that iterates over the\nBio::Tools::Alignment::Consed looking for contigs of 2. If the forward\nand reverse designator are removed from each of the reads in\n{'member_array'} and the remaining reads are the same, {name} is set\nto that name and the contig's class is set as \"doublet\".  If any of\nthose cases fail the contig is marked as a \"pair\".\n\n\n#' make my emacs happy\n\nsub set_doublets {\n    my ($self) = @_;\n    # set the designators in the Bio::Tools::Alignment::Trim object\n\n    $self->{'o_trim'}->set_designators($self->{'reverse_designator'},\n\t\t\t\t       $self->{'forward_designator'});\n    foreach my $key_contig (sort keys %{$self->{'contigs'}}) {\n\n\t# if there is a member array (why would there not be? This should be a die()able offence\n\t# but for now I will leave it\n\tif ($self->{'contigs'}->{$key_contig}->{'member_array'}) {\n\t    # if there are two reads in this contig \n\t    # i am pretty sure that this is wrong but i am keeping it for reference\n\t    # if (@{$self->{'contigs'}->{$key_contig}->{'member_array'}} == 2 || !$self->{'contigs'}->{$key_contig}->{'class'}) {\n\t    # <seconds later>\n\t    # <nod> WRONG. Was I on crack?\n\t    if (@{$self->{'contigs'}->{$key_contig}->{'member_array'}} == 2) {\n\t\t$self->{'contigs'}->{$key_contig}->{'num_members'} = 2;\n\t\t$self->debug(\"\\tThere are 2 members! Looking for the contig name...\\n\");\n\t\tmy $name = _get_contig_name($self,$self->{'contigs'}->{$key_contig}->{'member_array'});\n\t\t$self->debug(\"The name is $name\\n\") if defined $name;\n\t\tif ($name) {\n\t\t    $self->{'contigs'}->{$key_contig}->{'name'} = $name;\n\t\t    $self->{'contigs'}->{$key_contig}->{'class'} = \"doublet\";\n\t\t} else {\n\t\t    $self->debug(\"$key_contig is a pair.\\n\");\n\t\t    $self->{'contigs'}->{$key_contig}->{'class'} = \"pair\";\n\t\t}\n\t    }\n            # this is all fair and good but what about singlets?\n            # they have one reads in the member_array but certainly are not singletons\n\t    elsif (@{$self->{'contigs'}->{$key_contig}->{'member_array'}} == 1) {\n\t\t# set the name to be the name of the read\n\t\t$self->{'contigs'}->{$key_contig}->{name} = @{$self->{'contigs'}->{$key_contig}->{'member_array'}}[0];\n\t\t# set the number of members to be one\n\t\t$self->{'contigs'}->{$key_contig}->{num_members} = 1;\n\t\t# if this was a singlet, it would already belong to the class \"singlet\"\n\t\t# so leave it alone\n\t\t# if it is not a singlet, it is a singleton! lablel it appropriately\n\t\tunless ($self->{'contigs'}->{$key_contig}->{'class'}) {\n\t\t    $self->{'contigs'}->{$key_contig}->{'class'} = \"singleton\";\n\t\t}\n\t    }\n            # set the multiplet characteristics\n\t    elsif (@{$self->{'contigs'}->{$key_contig}->{'member_array'}} >= 3) {\n\t\t$self->{'contigs'}->{$key_contig}->{'num_members'} = @{$self->{'contigs'}->{$key_contig}->{'member_array'}};\n\t\t$self->{'contigs'}->{$key_contig}->{'class'} = \"multiplet\";\n\t    }\n\t    $self->{'contigs'}->{$key_contig}->{'num_members'} = @{$self->{'contigs'}->{$key_contig}->{'member_array'}};\n\n\t}\n    }\n    $self->{'doublets_set'} = \"done\";\n    return 0;\n}\t\t\t\t# end set_doublets\n\n=head2 set_singlets\n\n Title   : set_singlets\n Usage   : $o_consed->set_singlets();\n Function: Read in a singlets file and place them into the\n\t   Bio::Tools::Alignment::Consed object.\n Returns : Nothing.\n Args    : A scalar to turn on verbose parsing of the singlets file.\n Notes   : \n\n\nsub set_singlets {\n    # parse out the contents of the singlets file\n    my ($self) = @_;\n    $self->debug(\"Bio::Tools::Alignment::Consed Adding singlets to the contig hash...\\n\"); \n    my $full_filename = $self->{'filename'};\n    $self->debug(\"Bio::Tools::Alignment::Consed::set_singlets: \\$full_filename is $full_filename\\n\");\n    $full_filename =~ m/(.*\\/)(.*ace.*)$/; \t\t\t       \n    my ($base_path,$filename) = ($1,$2);\n    $self->debug(\"Bio::Tools::Alignment::Consed::set_singlets: singlets filename is $filename and \\$base_path is $base_path\\n\");\n    $filename =~ m/(.*)ace.*$/;\n    my $singletsfile = $base_path.$1.\"singlets\";\n    $self->debug(\"\\$singletsfile is $singletsfile\\n\");\n     if (!-f $singletsfile) {\n          # there is no singlets file.\n          $self->{'singlets_set'} = \"done\";\n          return;\n     }\n\t$self->debug(\"$singletsfile is indeed a file. Trying to open it...\\n\");\n    my $singlets_fh = Bio::Root::IO->new(-file => $singletsfile);\n    my ($sequence,$name,$count);\n    while ($_ = $singlets_fh->_readline()) {\n\tchomp $_;\n\tif (/\\>/) {\n\t    if ($name && $sequence) {\n\t\t$self->debug(\"Adding $name with sequence $sequence to hash...\\n\");\n\t\tpush @{$self->{'contigs'}->{$name}->{'member_array'}},$name;\n\t\t$self->{'contigs'}->{$name}->{'consensus'} = $sequence;\n\t\t$self->{'contigs'}->{$name}->{'name'} = $name;\n\t\t$self->{'contigs'}->{$name}->{\"singlet\"} = 1;\n\t\t$self->{'contigs'}->{$name}->{'class'} = \"singlet\";\n\t    }\n\t    $sequence = $name = undef;\n\t    $count++;\n\t    m/^\\>(.*)\\s\\sCHROMAT/;\n\t    $name = $1;\n\t    if (!$name) {\n\t\tm/\\>(\\S+)\\s/;\n\t\t$name = $1;\n\t    }\n\t}\n\telse { $sequence .= $_; }\t\n    }\n    if ($name && $sequence) {\n\t$self->debug(\"Pushing the last of the singlets ($name)\\n\");\n\t@{$self->{'contigs'}->{$name}->{'member_array'}} = $name;\n\t$self->{'contigs'}->{$name}->{'consensus'} = $sequence;\n\t$self->{'contigs'}->{$name}->{'name'} = $name;\n\t$self->{'contigs'}->{$name}->{\"singlet\"} = 1;\n\t$self->{'contigs'}->{$name}->{'class'} = \"singlet\";\n    }\n    $self->debug(\"Bio::Tools::Alignment::Consed::set_singlets: Done adding singlets to the singlets hash.\\n\");\n    $self->{'singlets_set'} = \"done\";\n    return 0;\n}\t\t\t\t# end sub set_singlets\n\n=head2 get_singlets()\n\n Title   : get_singlets()\n Usage   : $o_consed->get_singlets();\n Function: Return the keynames of the singlets.\n Returns : An array containing the keynames of all \n           Bio::Tools::Alignment::Consed sequences in the class \"singlet\".\n Args    : None.\n Notes   : \n\n\nsub get_singlets {\n    # returns an array of singlet names\n    # singlets have \"singlet\"=1 in the hash\n    my $self = shift;\n    if (!$self->{singlets_set}) {\n\t$self->debug(\"You need to set the singlets before you get them. Doing that now.\");\n\t$self->set_singlets();\n    }\t\n\n    my (@singlets,@array);\n    foreach my $key (sort keys %{$self->{'contigs'}}) {\n\t# @array = @{$Consed::contigs{$key}->{'member_array'}};\n\t# somethimes a user will try to get a list of singlets before the classes for the rest of the\n\t# contigs has been set (see t/test.t for how I figured this out. <bah>\t\t\t\n\t# so either way, just return class=singlets\n\tif (!$self->{'contigs'}->{$key}->{'class'}) {\n\t    # print(\"$key has no class. why?\\n\");\n\t}\n\telsif ($self->{'contigs'}->{$key}->{'class'} eq \"singlet\") {\n\t    push @singlets,$key;\n\t}\n    }\n    return @singlets;\n}\n\n=head2 set_quality_by_name($name,$quality)\n\n Title   : set_quality_by_name($name,$quality)\n Usage   : $o_consed->set_quality_by_name($name,$quality);\n Function: Deprecated. Make the contig with {name} have {'quality'} $quality.\n           Probably used for testing.\n Returns : Nothing.\n Args    : The name of a contig and a scalar for its quality.\n Notes   : Deprecated.\n\n\nsub set_quality_by_name {\n    # this is likely deprecated\n    my ($self,$name,$quality) = shift;\n    my $return;\n    foreach (sort keys %{$self->{'contigs'}}) {\n\tif ($self->{'contigs'} eq \"$name\" || $self->{'contigs'}->{'name'} eq \"$name\") {\n\t    $self->{'contigs'}->{'quality'} = $quality;\n\t    $return=1;\n\t}\n    }\n    if ($return) { return \"0\"; } else { return \"1\"; }\n}\t\t\t\t# end set quality by name\n\n=head2 set_singlet_quality()\n\n Title   : set_singlet_quality()\n Usage   : $o_consed->set_singlet_quality();\n Function: For each singlet, go to the appropriate file in phd_dir and read\n           in the phred quality for that read and place it into {'quality'}\n Returns : 0 or 1.\n Args    : None.\n Notes   : This is the next subroutine that will receive substantial revision\n           in the next little while. It really should eval the creation of\n           Bio::Tools::Alignment::Phred objects and go from there. \n\n\nsub set_singlet_quality {\n    my $self = shift;\n    my $full_filename = $self->{'filename'};\n    $full_filename =~ m/(.*\\/)(.*)ace.*$/;\n    my ($base_path,$filename) = ($1,\"$2\".\"qual\");\n    my $singletsfile = $base_path.$filename;\n    if (-f $singletsfile) {\n\t# print(\"$singletsfile is indeed a file. Trying to open it...\\n\");\n    }\n    else {\n\t$self->warn(\"$singletsfile is not a file. Sorry.\\n\");\n\treturn;\n    }\n\tmy $singlets_fh = Bio::Root::IO->new(-file => $singletsfile);\n\tmy ($sequence,$name,$count);\n    my ($identity,$line,$quality,@qline);\n    while ($line = $singlets_fh->_readline()) {\n\tchomp $line;\n\tif ($line =~ /^\\>/) {\n\t    $quality = undef;\n\t    $line =~ m/\\>(\\S*)\\s/;\n\t    $identity = $1;\n\t}\n\telse {\n\t    if ($self->{'contigs'}->{$identity}) {\n\t\t$self->{'contigs'}->{$identity}->{'quality'} .= \"$line \";\n\t    }\n\t}\n\n    }\n    return 0;\n}\n\n=head2 set_contig_quality()\n\n Title   : set_contig_quality()\n Usage   : $o_consed->set_contig_quality();\n Function: Deprecated.\n Returns : Deprecated.\n Args    : Deprecated.\n Notes   : Deprecated. Really. Trust me.\n\n\nsub set_contig_quality {\n    # note: contigs _include_ singletons but _not_ singlets\n    my ($self) = shift;\n          # the unexpected results I am referring to here are a doubling of quality values.\n          # the profanity I uttered on discovering this reminded me of the simpsons:\n          # Ned Flanders: \"That is the loudest profanity I have ever heard!\"\n     $self->warn(\"set_contig_quality is deprecated and will likely produce unexpected results\");\n    my $full_filename = $self->{'filename'};\n    # Run_SRC3700_2000-08-01_73+74.fasta.screen.contigs.qual\n    # from Consed.pm\n    $full_filename =~ m/(.*\\/)(.*)ace.*$/;\n    my ($base_path,$filename) = ($1,\"$2\".\"contigs.qual\");\n    my $singletsfile = $base_path.$filename;\n    if (-f $singletsfile) {\n\t# print(\"$singletsfile is indeed a file. Trying to open it...\\n\");\n    }\n    else {\n\t$self->warn(\"Bio::Tools::Alignment::Consed::set_contig_quality $singletsfile is not a file. Sorry.\\n\");\n\treturn;\n    }\n    my $contig_quality_fh = Bio::Root::IO->new(-file => $singletsfile);\n\n    my ($sequence,$name,$count,$identity,$line,$quality);\n    while ($line = $contig_quality_fh->_readline()) {\n\tchomp $line;\n\tif ($line =~ /^\\>/) {\n\t    $quality = undef;\n\t    $line =~ m/\\>.*Contig(\\d+)\\s/;\n\t    $identity = $1;\n\t}\n\telse {\n\t    if ($self->{'contigs'}->{$identity} ) {\n\t\t$self->{'contigs'}->{$identity}->{'quality'} .= \" $line\";\n\t    }\n\t}\n    }\n}\t\t\t\t# end set_contig_quality\n\n=head2 get_multiplets()\n\n Title   : get_multiplets()\n Usage   : $o_consed->get_multiplets();\n Function: Return the keynames of the multiplets.\n Returns : Returns an array containing the keynames of all \n           Bio::Tools::Alignment::Consed sequences in the class \"multiplet\".\n Args    : None.\n Notes   : \n\n\nsub get_multiplets {\n\t    # returns an array of multiplet names\n\t    # multiplets have # members > 2\n    my $self = shift;\n    my (@multiplets,@array);\n    foreach my $key (sort keys %{$self->{'contigs'}}) {\n\tif ($self->{'contigs'}->{$key}->{'class'}) {\n\t    if ($self->{'contigs'}->{$key}->{'class'} eq \"multiplet\") {\n\t\tpush @multiplets,$key;\n\t    }\n\t}\n    }\n    return @multiplets;\n}\n\n=head2 get_all_members()\n\n  Title   : get_all_members()\n  Usage   : @all_members = $o_consed->get_all_members();\n  Function: Return a list of all of the read names in the \n            Bio::Tools::Alignment::Consed object.\n  Returns : An array containing all of the elements in all of the\n            {'member_array'}s.\n  Args    : None.\n  Notes   : \n\n\nsub get_all_members {\n    my $self = shift;\n    my @members;\n    foreach my $key (sort keys %{$self->{'contigs'}}) {\n\tif ($key =~ /^singlet/) {\n\t    push @members,$self->{'contigs'}->{$key}->{'member_array'}[0];\n\t}\n\telsif ($self->{'contigs'}->{$key}->{'member_array'}) {\n\t    push @members,@{$self->{'contigs'}->{$key}->{'member_array'}};\n\t}\n\t# else {\n\t#\tprint(\"Bio::Tools::Alignment::Consed: $key is _not_ an array. Pushing $self->{'contigs'}->{$key}->{'member_array'} onto \\@members\\n\");\n\t#\tpush @members,$self->{'contigs'}->{$key}->{'member_array'};\n\t# }\n    }\n    return @members;\n}\n\n=head2 sum_lets($total_only)\n\n Title   : sum_lets($total_only)\n Usage   : $statistics = $o_consed->sum_lets($total_only);\n Function: Provide numbers for how many sequences were accounted for in the\n           Bio::Tools::Alignment::Consed object.\n Returns : If a scalar is present, returns the total number of\n           sequences accounted for in all classes. If no scalar passed\n           then returns a string that looks like this:\n           Singt/singn/doub/pair/mult/total : 2,0,1(2),0(0),0(0),4\n           This example means the following: There were 1 singlets.\n           There were 0 singletons.  There were 1 doublets for a total\n           of 2 sequences in this class.  There were 0 pairs for a\n           total of 0 sequences in this class.  There were 0\n           multiplets for a total of 0 sequences in this class.  There\n           were a total of 4 sequences accounted for in the\n           Bio::Tools::Alignment::Consed object.   \n Args : A scalar is optional to change the way the numbers are returned.  \n Notes:\n\n\nsub sum_lets {\n    my ($self,$total_only) = @_;\n    my ($count,$count_multiplets,$multiplet_count);\n    my $singlets = &get_singlets($self); $count += $singlets;\n    my $doublets = &get_doublets($self); $count += ($doublets * 2);\n    my $pairs = &get_pairs($self); $count += ($pairs * 2);\n    my $singletons = &get_singletons($self); $count += $singletons;\n    my @multiplets = &get_multiplets($self);\n    $count_multiplets = @multiplets;\n    my $return_string;\n    foreach (@multiplets) {\n\tmy $number_members = $self->{'contigs'}->{$_}->{num_members};\t\n\t$multiplet_count += $number_members;\n    }\n    if ($multiplet_count) {\n\t$count += $multiplet_count;\n    }\n    foreach (qw(multiplet_count singlets doublets pairs singletons\n                multiplets count_multiplets)) {\n\tno strict 'refs';\t# renege for the block\n\tif (!${$_}) {\n            ${$_} = 0;\n\t}\n    }\n    if (!$multiplet_count) { $multiplet_count = 0; }\n    if ($total_only) {\n        return $count;\n    }\n    $return_string = \"Singt/singn/doub/pair/mult/total : \".\n        \"$singlets,$singletons,$doublets(\".\n         ($doublets*2).\"),$pairs(\".($pairs*2).\n        \"),$count_multiplets($multiplet_count),$count\";\n    return $return_string;\n}\n\n=head2 write_stats()\n\n Title   : write_stats()\n Usage   : $o_consed->write_stats();\n Function: Write a file called \"statistics\" containing numbers similar to\n\t   those provided in sum_lets().\n Returns : Nothing. Write a file in $o_consed->{path} containing something\n\t   like this:\n\n           0,0,50(100),0(0),0(0),100\n\n           Where the numbers provided are in the format described in the\n\t   documentation for sum_lets().\n Args    : None.\n Notes   : This might break platform independence, I do not know.\n\nSee L<sum_lets()|sum_lets>\n\n\nsub write_stats {\n    # worry about platform dependence here?\n    # oh shucksdarn.\n    my $self = shift;\n    my $stats_filename = $self->{'path'}.\"statistics\";\n    my $statistics_raw = $self->sum_lets;\n    my ($statsfilecontents) = $statistics_raw =~ s/.*\\ \\:\\ //g;\n    umask 0001;\n    my $fh = Bio::Root::IO->new(-file=>\"$stats_filename\");\n    # open(STATSFILE,\">$stats_filename\") or print(\"Could not open the statsfile: $!\\n\");\n    $fh->_print(\"$statsfilecontents\");\n    # close STATSFILE;\n    $fh->close();\n}\n\n=head2 get_singletons()\n\n Title   : get_singletons()\n Usage   : @singletons = $o_consed->get_singletons();\n Function: Return the keynames of the singletons.\n Returns : Returns an array containing the keynames of all\n\t   Bio::Tools::Alignment::Consed sequences in the class \"singleton\".\n Args    : None.\n Notes   : \n\n\nsub get_singletons {\n\t\t# returns an array of singleton names\n\t\t# singletons are contigs with one member (see consed documentation)\n\tmy $self = shift;\n\tmy (@singletons,@array);\n\tforeach my $key (sort keys %{$self->{'contigs'}}) {\n\t\tif ($self->{'contigs'}->{$key}->{'class'}) {\n\t\t    # print (\"$key class: $self->{'contigs'}->{$key}->{'class'}\\n\");\n\t\t}\n\t\telse {\n\t\t    # print(\"$key belongs to no class. why?\\n\");\n\t\t}\n\t\tif ($self->{'contigs'}->{$key}->{'member_array'}) {\n\t\t\t@array = @{$self->{'contigs'}->{$key}->{'member_array'}};\n\t\t}\n\t\tmy $num_array_elem = @array;\n\t\tif ($num_array_elem == 1 && $self->{'contigs'}->{$key}->{'class'} && $self->{'contigs'}->{$key}->{'class'} eq \"singleton\") { push @singletons,$key; }\n\t}\n\treturn @singletons;\n}\n\n=head2 get_pairs()\n\n Title   : get_pairs()\n Usage   : @pairs = $o_consed->get_pairs();\n Function: Return the keynames of the pairs.\n Returns : Returns an array containing the keynames of all\n           Bio::Tools::Alignment::Consed sequences in the class \"pair\".\n Args    : None.\n Notes   : \n\n\nsub get_pairs {\n    # returns an array of pair contig names\n    # a pair is a contig of two where the names do not match\n    my $self = shift;\n    my (@pairs,@array);\n    foreach my $key (sort keys %{$self->{'contigs'}}) {\n        if ($self->{'contigs'}->{$key}->{'member_array'}) {\n            if (@{$self->{'contigs'}->{$key}->{'member_array'}} == 2 &&\n                $self->{'contigs'}->{$key}->{'class'} eq \"pair\") {\n                push @pairs,$key;\n            }\n        }\n    }\n    return @pairs;\n}\n\n=head2 get_name($contig_keyname)\n\n Title   : get_name($contig_keyname)\n Usage   : $name = $o_consed->get_name($contig_keyname);\n Function: Return the {name} for $contig_keyname.\n Returns : A string. ({name})\n Args    : A contig keyname.\n Notes   : \n\n\nsub get_name {\n    my ($self,$contig) = @_;\n    return $self->{'contigs'}->{$contig}->{'name'};\n}\n\n=head2 _get_contig_name(\\@array_containing_reads)\n\n Title   : _get_contig_name(\\@array_containing_reads)\n Usage   : $o_consed->_get_contig_name(\\@array_containing_reads);\n Function: The logic for the set_doublets subroutine.\n Returns : The name for this contig.\n Args    : A reference to an array containing read names.\n Notes   : Depends on reverse_designator. Be sure this is set the way you\n\t   intend.\n\n\nsub _get_contig_name {\n    my ($self,$r_array) = @_;\n    my @contig_members = @$r_array;\n    my @name_nodir;\n    foreach (@contig_members) {\n        # how can I distinguish the clone name from the direction label?\n        # look for $Consed::reverse_designator and $Consed::forward_designator\n        # what if you do not find _any_ of those?\n        my $forward_designator = $self->{'forward_designator'} || \"f\";\n        my $reverse_designator = $self->{'reverse_designator'} || \"r\";\n        my $any_hits = /(.+)($forward_designator.*)/ || /(.+)($reverse_designator.*)/||/(.+)(_.+)/;\n        my $name = $1;\n        my $suffix = $2;\n        if ($name) {\n            # print(\"\\t\\$name is $name \");\n        }\n        if ($suffix) {\n            # print(\"and \\$suffix is $suffix.\\n\");\n        }\n                                # Jee, I hope we get a naming convention soon\n        if ($suffix) {\n            if ($suffix =~ /^$forward_designator/ || $suffix =~ /^$reverse_designator/) {\n                push @name_nodir,$name;\n            }\n\t\t\t\t# bugwatch here! should this be unnested?\n            else {\n                push @name_nodir,\"$name$suffix\";\n            }\n        }\n    }\n    # print(\"\\@name_nodir: @name_nodir\\n\");\n    my $mismatch = 0;\n    for (my $counter=0; $counter<@name_nodir;$counter++) {\n        next if ($name_nodir[0] eq $name_nodir[$counter]);\n        $mismatch = 1;\n    }\n    if ($mismatch == 0) {\n        # print(\"\\tYou have a cohesive contig named $name_nodir[0].\\n\\n\");\n        return $name_nodir[0];\n    } else {\n        # print(\"\\tYou have mixed names in this contig.\\n\\n\");\n    }\n}                               # end _get_contig_name\n\n=head2 get_doublets()\n\n Title   : get_doublets()\n Usage   : @doublets = $o_consed->get_doublets();\n Function: Return the keynames of the doublets.\n Returns : Returns an array containing the keynames of all\n           Bio::Tools::Alignment::Consed sequences in the class \"doublet\".\n Args    : None.\n Notes   : \n\n\nsub get_doublets {\n    my $self = shift;\n    if (!$self->{doublets_set}) {\n        $self->warn(\"You need to set the doublets before you can get them. Doing that now.\");\n        $self->set_doublets();\n    }\n    my @doublets;\n    foreach (sort keys %{$self->{'contigs'}}) {\n        if ($self->{'contigs'}->{$_}->{name} && $self->{'contigs'}->{$_}->{'class'} eq \"doublet\") {\n            push @doublets,$_;\n        }\n    }\n    return @doublets;\n}                               # end get_doublets\n\n=head2 dump_hash()\n\n Title   : dump_hash()\n Usage   : $o_consed->dump_hash();\n Function: Use dumpvar.pl to dump out the Bio::Tools::Alignment::Consed\n           object to STDOUT.\n Returns : Nothing.\n Args    : None.\n Notes   : I used this a lot in debugging.\n\n\nsub dump_hash {\n    my $self = shift;\n    my $dumper = new Dumpvalue;\n    $self->debug( \"Bio::Tools::Alignment::Consed::dump_hash - \".\n                  \"The following is the contents of the contig hash...\\n\");\n    $dumper->dumpValue($self->{'contigs'});\n}\n\n=head2 dump_hash_compact()\n\n Title   : dump_hash_compact()\n Usage   : $o_consed->dump_hash_compact();\n Function: Dump out the Bio::Tools::Alignment::Consed object in a compact way.\n Returns : Nothing.\n Args    : Nothing.\n Notes   : Cleaner then dumpValue(), dumpHash(). I used this a lot in\n           debugging.\n\n\nsub dump_hash_compact {\n    no strict 'refs';           # renege for the block\n    my ($self,$sequence) = @_;\n    # get the classes\n    my @singlets = $self->get_singlets();\n    my @singletons = $self->get_singletons();\n    my @doublets = $self->get_doublets();\n    my @pairs = $self->get_pairs();\n    my @multiplets = $self->get_multiplets();\n    print(\"Name\\tClass\\tMembers\\tQuality?\\n\");\n    foreach (@singlets) {\n        my @members = $self->get_members($_);\n        print($self->get_name($_).\"\\tsinglets\\t\".(join',',@members).\"\\t\");\n        if ($self->{'contigs'}->{$_}->{'quality'}) {\n            print(\"qualities found here\\n\");\n        } else {\n            print(\"no qualities found here\\n\");\n        }\n\n    }\n    foreach (@singletons) {\n        my @members = $self->get_members($_);\n        print($self->get_name($_).\"\\tsingletons\\t\".(join',',@members).\"\\t\");\n        if ($self->{'contigs'}->{$_}->{'quality'}) {\n            print(\"qualities found here\\n\");\n        } else {\n            print(\"no qualities found here\\n\");\n        }\n    }\n    foreach my $pair (@pairs) {\n        my @members = $self->get_members($pair);\n        my $name;\n        if (!$self->get_name($pair)) {\n            $name = \"BLANK\";\n        } else {\n            $name = $self->get_name($pair);\n        }\n        print(\"$name\\tpairs\\t\".(join',',@members).\"\\n\");\n    }\n    foreach (@doublets) {\n        my @members = $self->get_members_by_name($_);\n        print(\"$_\\tdoublets\\t\".(join',',@members).\"\\t\");\n        my $contig_number = &get_contig_number_by_name($self,$_);\n        if ($self->{'contigs'}->{$contig_number}->{'quality'}) {\n            print(\"qualities found here\\n\");\n        } else {\n            print(\"no qualities found here\\n\");\n        }\n        # print($_.\"\\tdoublets\\t\".(join',',@members).\"\\n\");\n    }\n    foreach (@multiplets) {\n        my @members = $self->get_members($_);\n        print(\"Contig $_\".\"\\tmultiplets\\t\".(join',',@members).\"\\n\");\n    }\n}                               # end dump_hash_compact\n\n=head2 get_phreds()\n\n Title   : get_phreds()\n Usage   : @phreds = $o_consed->get_phreds();\n Function: For each doublet in the Bio::Tools::Alignment::Consed hash, go\n           and get the phreds for the top and bottom reads. Place them into\n           {top_phreds} and {bottom_phreds}.\n Returns : Nothing.\n Args    : Nothing.\n\nRequires parse_phd() and reverse_and_complement(). I realize that it\nwould be much more elegant to pull qualities as required but there\nwere certain \"features\" in the acefile that required a bit more\ndetailed work be done to get the qualities for certain parts of the\nconsensus sequence. In order to make _sure_ that this was done\nproperly I wrote things to do all steps and then I used dump_hash()\nand checked each one to ensure expected bahavior. I have never changed\nthis, so there you are.\n\n\nsub get_phreds {\n    # this subroutine is the target of a rewrite to use the Bio::Tools::Alignment::Phred object.\n    my $self = shift;    \n    my $current_contig;\n    foreach $current_contig (sort keys %{$self->{'contigs'}}) {\t\n\tif ($self->{'contigs'}->{$current_contig}->{'class'} eq \"doublet\") {\n\t    $self->debug(\"$current_contig is a doublet. Going to parse_phd for top($self->{'contigs'}->{$current_contig}->{'top_name'}) and bottom($self->{'contigs'}->{$current_contig}->{'bottom_name'})\\n\");\n\t    my $r_phreds_top = &parse_phd($self,$self->{'contigs'}->{$current_contig}->{'top_name'});\n\t    my $r_phreds_bottom = &parse_phd($self,$self->{'contigs'}->{$current_contig}->{'bottom_name'});\n\t    if ($self->{'contigs'}->{$current_contig}->{'top_complement'} eq \"C\") {\n\t\t# print(\"Reversing and complementing...\\n\");\n\t\t$r_phreds_top = &reverse_and_complement($r_phreds_top);\n\t    }\n\t    if ($self->{'contigs'}->{$current_contig}->{'bottom_complement'} eq \"C\") {\n\t\t$r_phreds_bottom = &reverse_and_complement($r_phreds_bottom);\n\t    }\n\t    $self->{'contigs'}->{$current_contig}->{'top_phreds'} = $r_phreds_top;\n\t    $self->{'contigs'}->{$current_contig}->{'bottom_phreds'} = $r_phreds_bottom;\n\t}\n    }\n}\n\n=head2 parse_phd($read_name)\n\n Title   : parse_phd($read_name)\n Usage   : $o_consed->parse_phd($read_name);\n Function: Suck in the contents of a .phd file.\n Returns : A reference to an array containing the quality values for the read.\n Args    : The name of a read.\n Notes   : This is a significantly weak subroutine because it was always\n\t   intended that these functions, along with the functions provided by\n\t   get_phreds() be put into the Bio::SeqIO:phd module. This is done\n           now but the Bio::Tools::Alignment::Consed module has not be\n           rewritten to reflect this change.\n\nSee L<Bio::SeqIO::phd> for more information.","label":"parse_phd($self,$sequence_name)"},"containerName":"main::","definition":"sub","line":1645,"children":[{"kind":13,"line":1646,"name":"$self","definition":"my","containerName":"parse_phd","localvar":"my"},{"name":"$sequence_name","containerName":"parse_phd","kind":13,"line":1646},{"line":1647,"kind":13,"containerName":"parse_phd","name":"$self"},{"containerName":"parse_phd","name":"debug","kind":12,"line":1647},{"containerName":"parse_phd","name":"$in_dna","definition":"my","localvar":"my","kind":13,"line":1648},{"line":1649,"kind":13,"localvar":"my","name":"$base_number","definition":"my","containerName":"parse_phd"},{"line":1650,"kind":13,"localvar":"my","definition":"my","name":"@bases","containerName":"parse_phd"},{"line":1650,"kind":13,"name":"@current_line","containerName":"parse_phd"},{"containerName":"parse_phd","name":"$fh","definition":"my","localvar":"my","kind":13,"line":1652},{"containerName":"parse_phd","name":"new","line":1653,"kind":12},{"name":"$fh","containerName":"parse_phd","kind":13,"line":1654},{"containerName":"parse_phd","name":"_readline","line":1654,"kind":12},{"containerName":"parse_phd","name":"$in_dna","kind":13,"line":1657},{"line":1659,"kind":13,"name":"$in_dna","containerName":"parse_phd"},{"containerName":"parse_phd","name":"@bases","kind":13,"line":1660},{"name":"@bases","containerName":"parse_phd","line":1662,"kind":13}],"kind":12,"range":{"start":{"character":0,"line":1645},"end":{"character":9999,"line":1663}},"name":"parse_phd"},{"line":1652,"kind":12,"containerName":"Root::IO","name":"Bio"},{"range":{"start":{"character":0,"line":1676},"end":{"line":1681,"character":9999}},"name":"reverse_and_complement","definition":"sub","containerName":"main::","children":[{"definition":"my","name":"$r_source","containerName":"reverse_and_complement","localvar":"my","kind":13,"line":1677},{"localvar":"my","name":"$r_destination","definition":"my","containerName":"reverse_and_complement","line":1678,"kind":13},{"line":1679,"kind":13,"name":"$r_destination","containerName":"reverse_and_complement"},{"name":"$r_source","containerName":"reverse_and_complement","kind":13,"line":1679},{"line":1679,"kind":13,"containerName":"reverse_and_complement","name":"$r_destination"},{"kind":13,"line":1680,"containerName":"reverse_and_complement","name":"$r_destination"}],"line":1676,"kind":12},{"kind":12,"line":1679,"name":"reverse_recurse"},{"children":[{"kind":13,"line":1699,"containerName":"reverse_recurse","name":"$r_source","definition":"my","localvar":"my"},{"name":"$r_destination","definition":"my","containerName":"reverse_recurse","localvar":"my","kind":13,"line":1699},{"kind":13,"line":1700,"containerName":"reverse_recurse","name":"$r_source"},{"containerName":"reverse_recurse","name":"$r_destination","kind":13,"line":1701},{"containerName":"reverse_recurse","name":"$r_source","kind":13,"line":1703},{"kind":13,"line":1705,"name":"$r_destination","containerName":"reverse_recurse"},{"line":1706,"kind":13,"containerName":"reverse_recurse","name":"$r_source"},{"kind":13,"line":1706,"containerName":"reverse_recurse","name":"$r_destination"}],"line":1698,"kind":12,"signature":{"documentation":"1;\n# $Id: Consed.pm 16123 2009-09-17 12:57:27Z cjfields $\n# Bio::Tools::Alignment::Consed\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chad Matsalla\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Alignment::Consed - A module to work with objects from consed .ace files\n\n=head1 SYNOPSIS\n\n  # a report for sequencing stuff\n  my $o_consed = Bio::Tools::Alignment::Consed->new( \n      -acefile => \"/path/to/an/acefile.ace.1\",\n      -verbose => 1);\n  my $foo = $o_consed->set_reverse_designator(\"r\");\n  my $bar = $o_consed->set_forward_designator(\"f\");\n\n  # get the contig numbers\n  my @keys = $o_consed->get_contigs();\n\n  # construct the doublets\n  my $setter_doublets = $o_consed->choose_doublets();\n\n  # get the doublets\n  my @doublets = $o_consed->get_doublets();\n\n=head1 DESCRIPTION\n\nL<Bio::Tools::Alignment::Consed> provides methods and objects to deal\nwith the output from the Consed software suite. Specifically,\ntakes an C<.ace> file and provides objects for the results.\n\nA word about doublets: This module was written to accomodate a large\nEST sequencing operation. In this case, EST's were sequenced from the\n3' and from the 5' end of the EST. The objective was to find a\nconsensus sequence for these two reads.  Thus, a contig of two is what\nwe wanted, and this contig should consist of the forward and reverse\nreads of a getn clone. For example, for a forward designator of \"F\"\nand a reverse designator of \"R\", if the two reads chad1F and chad1R\nwere in a single contig (for example Contig 5) it will be determined\nthat the consensus sequence for Contig 5 will be the sequence for\nclone chad1.\n\nDoublets are good!\n\nThis module parses C<.ace> and related files. A detailed list of methods\ncan be found at the end of this document.\n\nI wrote a detailed rationale for design that may explain the reasons\nwhy some things were done the way they were done. That document is\nbeyond the scope of this pod and can probably be found in the\ndirectory from which this module was 'made' or at\nL<http://www.dieselwurks.com/bioinformatics/consedpm_documentation.pdf>.\n\nNote that the POD in that document might be old but the original\nrationale still stands.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nEmail chad-at-dieselwurks.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n#' \n\npackage Bio::Tools::Alignment::Consed;\n\nuse strict;\n\nuse FileHandle;\nuse Dumpvalue qw(dumpValue);\nuse Bio::Tools::Alignment::Trim;\nuse File::Spec;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\nour %DEFAULTS = ( 'f_designator' => 'f',\n\t\t  'r_designator' => 'r');\n\n=head2 new()\n\n Title   : new(-acefile => $path_to_some_acefile, -verbose => \"1\")\n Usage   : $o_consed = Bio::Tools::Alignment::Consed->\n              new(-acefile => $path_to_some_acefile, -verbose => \"1\");\n Function: Construct the Bio::Tools::Alignment::Consed object. Sets\n\t   verbosity for the following procedures, if necessary:\n\t   1. Construct a new Bio::Tools::Alignment::Trim object, to\n\t   handle quality trimming 2. Read in the acefile and parse it\n\n Returns : A reference to a Bio::Tools::Alignment::Consed object.\n Args    : A hash. (-acefile) is the filename of an acefile. If a full path\n\t   is not specified \"./\" is prepended to the filename and used from\n\t   instantiation until destruction. If you want \n           Bio::Tools::Alignment::Consed to be noisy during parsing of\n           the acefile, specify some value for (-verbose).\n\n\nsub new {\n    my ($class,%args) = @_;\n    my $self = $class->SUPER::new(%args);\n\n    $self->{'filename'} = $args{'-acefile'};\n\n    # this is special to UNIX and should probably use catfile : DONE!\n#    if (!($self->{'filename'} =~ m{/})) { \n#\t$self->{'filename'} = \"./\".$self->{'filename'}; \n#    } \n#    $self->{'filename'} =~ m/(.*\\/)(.*)ace.*$/;\n#    $self->{'path'} = $1;\n\n    # this is more generic and should work on most systems   \n    (undef, $self->{'path'}, undef) = File::Spec->splitpath($self->{'filename'});\n\n    $self->_initialize_io('-file'=>$self->{'filename'});\n    $self->{'o_trim'} = Bio::Tools::Alignment::Trim->new(-verbose => $self->verbose());\n    $self->set_forward_designator($DEFAULTS{'f_designator'});\n    $self->set_reverse_designator($DEFAULTS{'r_designator'});\n\n    $self->_read_file();\n    return $self;\n}\n\n=head2 set_verbose()\n\n Title   : set_verbose()\n Usage   : $o_consed->set_verbose(1);\n Function: Set the verbosity level for debugging messages. On instantiation\n\t   of the Bio::Tools::Alignment::Consed object the verbosity level\n           is set to 0 (quiet).\n Returns : 1 or 0.\n Args    : The verbosity levels are:\n\t      0 - quiet\n\t      1 - noisy\n\t      2 - noisier\n\t      3 - annoyingly noisy\n\nThis method for setting verbosity has largely been superseeded by a\nsub-by-sub way, where for every sub you can provide a (-verbose)\nswitch. I am doing converting this bit-by-bit so do not be surprised\nif some subs do not honour this.\n\n\n# from RootI\n\n# backwards compat\nsub set_verbose { (shift)->verbose(@_) }\n\n=head2 get_filename()\n\n Title   : get_filename()\n Usage   : $o_consed->get_filename();\n Function: Returns the name of the acefile being used by the\n\t   Bio::Tools::Alignment::Consed object.\n Returns : A scalar containing the name of a file.\n Args    : None.\n\n\n\nsub get_filename {\n    my $self = shift;\n    return $self->{'filename'};\n}\n\n=head2 count_sequences_with_grep()\n\n Title   : count_sequences_with_grep()\n Usage   : $o_consed->count_sequences_with_grep();\n Function: Use /bin/grep to scan through the files in the ace project dir\n\t   and count sequences in those files. I used this method in the\n\t   development of this module to verify that I was getting all of the\n\t   sequences. It works, but it is (I think) unix-like platform\n\t   dependent.\n Returns : A scalar containing the number of sequences in the ace project\n\t   directory.\n Args    : None.\n\nIf you are on a non-UNIX platform, you really do not have to use\nthis. It is more of a debugging routine designed to address very\nspecific problems.\n\nThis method was reimplemented to be platform independent with a pure\nperl implementation.  The above note can be ignored.\n\n\nsub count_sequences_with_grep {\n    my $self = shift;\n    my ($working_dir,$grep_cli,@total_grep_sequences);\n    # this should be migrated to a pure perl implementation ala\n    # Tom Christiansen's 'tcgrep'\n    # http://www.cpan.org/modules/by-authors/id/TOMC/scripts/tcgrep.gz\n\n    open(my $FILE, $self->{'filename'}) or do { $self->warn(\"cannot open file \".$self->{'filename'}. \" for grepping\"); return}; \n    my $counter =0;\n    while(<$FILE>) { $counter++ if(/^AF/); }\n\n    close $FILE;\n    opendir(my $SINGLETS,$self->{'path'});\n    foreach my $f ( readdir($SINGLETS) ) {\n\tnext unless ($f =~ /\\.singlets$/); \n\topen(my $FILE, File::Spec->catfile($self->{'path'},$f)) or do{ $self->warn(\"cannot open file \".File::Spec->catfile($self->{'path'},$f)); next };\n\twhile(<$FILE>) { $counter++ if(/^>/) }\n\tclose $FILE;\n    }\n    return $counter;\n}\n\n=head2 get_path()\n\n Title   : get_path()\n Usage   : $o_consed->get_path();\n Function: Returns the path to the acefile this object is working with.\n Returns : Scalar. The path to the working acefile.\n Args    : None.\n\n\nsub get_path {\n    my $self = shift;\n    return $self->{'path'};\n}\n\n=head2 get_contigs()\n\n Title   : get_contigs()\n Usage   : $o_consed->get_contigs();\n Function: Return the keys to the Bio::Tools::Alignment::Consed object.\n Returns : An array containing the keynames in the\n           Bio::Tools::Alignment::Consed object.\n Args    : None.\n\nThis would normally be used to get the keynames for some sort of\niterator. These keys are worthless in general day-to-day use because\nin the Consed acefile they are simply Contig1, Contig2, ...\n\n\nsub get_contigs {\n    my ($self,$contig) = @_;\n    my @contigs = sort keys %{$self->{'contigs'}};\n    return @contigs;\n}\n\n=head2 get_class($contig_keyname)\n\n Title   : get_class($contig_keyname)\n Usage   : $o_consed->get_class($contig_keyname);\n Function: Return the class name for this contig\n Returns : A scalar representing the class of this contig.\n Args    : None.\n Notes   : \n\n\nsub get_class {\n    my ($self,$contig) = @_;\n    return $self->{contigs}->{$contig}->{class};\n}\n\n=head2 get_quality_array($contig_keyname)\n\n Title   : get_quality_array($contig_keyname)\n Usage   : $o_consed->get_quality_array($contig_keyname);\n Function: Returns the quality for the consensus sequence for the given\n\t   contig as an array. See get_quality_scalar to get this as a scalar.\n Returns : An array containing the quality for the consensus sequence with\n\t   the given keyname.\n Args    : The keyname of a contig. Note: This is a keyname. The key would\n\t   normally come from get_contigs.\n\nReturns an array, not a reference. Is this a bug? I<thinking> No.\nWell, maybe.  Why was this developed like this? I was using FreezeThaw\nfor object persistence, and when it froze out these arrays it took a\nlong time to thaw it. Much better as a scalar.\n\nSee L<get_quality_scalar()|get_quality_scalar>\n\n\nsub get_quality_array {\n    my ($self,$contig) = @_;\n    return split ' ', $self->{contigs}->{$contig}->{quality};\n}\n\n=head2 get_quality_scalar($contig_keyname)\n\n Title   : get_quality_scalar($contig_keyname)\n Usage   : $o_consed->get_quality_scalar($contig_keyname);\n Function: Returns the quality for the consensus sequence for the given\n\t   contig as a scalar. See get_quality_array to get this as an array.\n Returns : An scalar containing the quality for the consensus sequence with\n           the given keyname.\n Args    : The keyname of a contig. Note this is a _keyname_. The key would\n\t   normally come from get_contigs.\n\nWhy was this developed like this? I was using FreezeThaw for object\npersistence, and when it froze out these arrays it took a coon's age\nto thaw it. Much better as a scalar.\n\nSee L<get_quality_array()|get_quality_array>\n\n\n#'\nsub get_quality_scalar {\n    my ($self,$contig) = @_;\n    return $self->{'contigs'}->{$contig}->{'quality'};\n}\n\n=head2 freeze_hash()\n\n Title   : freeze_hash()\n Usage   : $o_consed->freeze_hash();\n\n Function: Use Ilya's FreezeThaw module to create a persistent data\n\t   object for this Bio::Tools::Alignment::Consed data\n\t   structure. In the case of AAFC, we use\n\t   Bio::Tools::Alignment::Consed to pre-process bunches of\n\t   sequences, freeze the structures, and send in a harvesting\n\t   robot later to do database stuff.\n Returns : 0 or 1;\n Args    : None.\n\nThis procedure was removed so Consed.pm won't require FreezeThaw.\n\n\n#'\nsub freeze_hash {\n    my $self = shift;\n    $self->warn(\"This method (freeze_hash) was removed \".\n                \"from the bioperl consed.pm. Sorry.\\n\");\n    if (1==2) {\n        $self->debug(\"Bio::Tools::Alignment::Consed::freeze_hash:\".\n                     \" \\$self->{path} is $self->{path}\\n\");\n        my $filename = $self->{'path'}.\"frozen\";\n        my %contigs = %{$self->{'contigs'}};\n        my $frozen = freeze(%contigs);\n        umask 0001;\n        open (my $FREEZE,\">$filename\") or do {\n            $self->warn( \"Bio::Tools::Alignment::Consed could not \".\n                         \"freeze the contig hash because the file \".\n                         \"($filename) could not be opened: $!\\n\");\n            return 1;\n        };\n        print $FREEZE $frozen;\n        return 0;\n    }\n}\n\n=head2 get_members($contig_keyname)\n\n Title   : get_members($contig_keyname)\n Usage   : $o_consed->get_members($contig_keyname);\n Function: Return the _names_ of the reads in this contig.\n Returns : An array containing the names of the reads in this contig.\n Args    : The keyname of a contig. Note this is a keyname. The keyname\n\t   would normally come from get_contigs.\n\nSee L<get_contigs()|get_contigs>\n\n\nsub get_members {\n    my ($self,$contig) = @_;\n    if (!$contig) {\n\t$self->warn(\"You need to provide the name of a contig to \".\n                    \"use Bio::Tools::Alignment::Consed::get_members!\\n\");\n\treturn;\n    }\n    return @{$self->{'contigs'}->{$contig}->{'member_array'}};\n}\n\n=head2 get_members_by_name($some_arbitrary_name)\n\n Title   : get_members_by_name($some_arbitrary_name)\n Usage   : $o_consed->get_members_by_name($some_arbitrary_name);\n Function: Return the names of the reads in a contig. This is the name given\n\t   to $contig{key} based on what is in the contig. This is different\n\t   from the keys retrieved through get_contigs().\n Returns : An array containing the names of the reads in the contig with this\n\t   name.\n Args    : The name of a contig. Not a key, but a name.\n\nHighly inefficient. use some other method if possible.\nSee L<get_contigs()|get_contigs>\n\n\nsub get_members_by_name {\n    my ($self,$name) = @_;\n    # build a list to try to screen for redundancy\n    my @contigs_with_that_name;\n    foreach my $currkey ( sort keys %{$self->{'contigs'}} ) {\n\tnext if (!$self->{'contigs'}->{$currkey}->{'name'});\n\tif ($self->{'contigs'}->{$currkey}->{'name'} eq \"$name\") {\n\t    push @contigs_with_that_name,$currkey;\n\t}\n    }\n    my $count = @contigs_with_that_name;\n    if ($count == 1) {\n\tmy $contig_num = $contigs_with_that_name[0];\n\treturn @{$self->{'contigs'}->{$contig_num}->{'member_array'}};\n    }\n}\n\n=head2 get_contig_number_by_name($some_arbitrary_name)\n\n Title   : get_contig_number_by_name($some_arbitrary_name)\n Usage   : $o_consed->get_contig_number_by_name($some_arbitrary_name);\n Function: Return the names of the reads in a contig. This is the name given\n\t   to $contig{key} based on what is in the contig. This is different\n\t   from the keys retrieved through get_contigs().\n Returns : An array containing the names of the reads in the contig with this\n\t   name.\n Args    : The name of a contig. Not a key, but a name.\n\nSee L<get_contigs()|get_contigs>\n\n\nsub get_contig_number_by_name {\n    my ($self,$name) = @_;\n    foreach my $currkey (sort keys %{$self->{'contigs'}}) {\n\tif ($self->{'contigs'}->{$currkey}->{'name'} && \n\t    $self->{'contigs'}->{$currkey}->{'name'} eq \"$name\") {\n\t    return $currkey;\n\t}\n    }\n}\t\n\n=head2 get_sequence($contig_keyname)\n\n Title   : get_sequence($contig_keyname)\n Usage   : $o_consed->get_sequence($contig_keyname); \n Function: Returns the consensus sequence for a given contig.\n Returns : A scalar containing a sequence.\n Args    : The keyname of a contig. Note this is a key. The key would\n\t   normally come from get_contigs.\n\nSee L<get_contigs()|get_contigs>\n\n\nsub get_sequence {\n    my ($self,$contig) = @_;\n    return $self->{'contigs'}->{$contig}->{'consensus'};\n}\n\n=head2 set_final_sequence($some_sequence)\n\n Title   : set_final_sequence($name,$some_sequence)\n Usage   : $o_consed->set_final_sequence($name,$some_sequence);\n Function: Provides a manual way to set the sequence for a given key in the\n\t   contig hash. Rarely used.\n Returns : 0 or 1;\n Args    : The name (not the keyname) of a contig and an arbitrary string.\n\nA method with a questionable and somewhat mysterious origin. May raise\nthe dead or something like that.\n\n\nsub set_final_sequence {\n    my ($self,$name,$sequence) = @_;\n    if (!$self->{'contigs'}->{$name}) {\n\t$self->warn(\"You cannot set the final sequence for \".\n                    \"$name because it doesn't exist!\\n\");\n\treturn 1;\n    }\n    else {\n\t$self->{'contigs'}->{$name}->{'final_sequence'} = $sequence;\n    }\n    return 0;\n}\n\n=head2  _read_file()\n\n Title   : _read_file();\n Usage   : _read_file();\n Function: An internal subroutine used to read in an acefile and parse it\n\t   into a Bio::Tools::Alignment::Consed object.\n Returns : 0 or 1.\n Args    : Nothing.\n\nThis routine creates and saves the filhandle for reading the files in\n{fh}\n\n\nsub _read_file {\n    my ($self) = @_;\n    my ($line,$in_contig,$in_quality,$contig_number,$top);\n    # make it easier to type $fhl\n    while (defined($line=$self->_readline()) ) {\n\tchomp $line;\n\t# check if there is anything on this line\n\t# if not, you can stop gathering consensus sequence\n\tif (!$line) {\n\t    # if the line is blank you are no longer to gather consensus \n\t    # sequence or quality values\n\t    $in_contig = 0;\n\t    $in_quality = 0;\n\t}\n\t# you are currently gathering consensus sequence\n\telsif ($in_contig) {\n\t    if ($in_contig == 1) {\n\t\t$self->debug(\"Adding $line to consensus of contig number $contig_number.\\n\");\n\t\t$self->{'contigs'}->{$contig_number}->{'consensus'} .= $line;\n\t    }\n\t}\n\telsif ($in_quality) {\n\t    if (!$line) {\n\t\t$in_quality = undef;\n\t    }\n\t    else {\n\n\t\t# I wrote this in here because acefiles produced by\n\t\t# cap3 do not have a leading space like the acefiles\n\t\t# produced by phrap and there is the potential to have\n\t\t# concatenated quality values like this: 2020 rather\n\t\t# then 20 20 whre lines collide. Thanks Andrew for\n\t\t# noticing.\n\n\t\tif ($self->{'contigs'}->{$contig_number}->{'quality'} &&\n                    !($self->{'contigs'}->{$contig_number}->{'quality'} =~ m/\\ $/)) {\n\t\t    $self->{'contigs'}->{$contig_number}->{'quality'} .= \" \";\n\t\t}\n\t\t$self->{'contigs'}->{$contig_number}->{'quality'} .= $line;\n\t    }\n\t}\n\telsif ($line =~ /^BQ/) {\n\t    $in_quality = 1;\n\t}\n\n\t# the line /^CO/ like this:\n\t# CO Contig1 796 1 1 U\n\t# can be broken down as follows:\n\t# CO - Contig!\n\t# Contig1 - the name of this contig\n\t# 796 - Number of bases in this contig\n\t# 1 - Number of reads in this contig\n\t# 1 - number of base segments in this contig\n\t# U - Uncomplemented\n\n\telsif ($line =~ /^CO/) {\n\t    $line =~ m/^CO\\ Contig(\\d+)\\ \\d+\\ \\d+\\ \\d+\\ (\\w)/;\n\t    $contig_number = $1;\n\t    if ($2 eq \"C\") {\n\t\t$self->debug(\"Contig $contig_number is complemented!\\n\");\n\t    }\n\t    $self->{'contigs'}->{$contig_number}->{'member_array'} = [];\n\t    $self->{'contigs'}->{$contig_number}->{'contig_direction'} = \"$2\";\n\t    $in_contig = 1;\n\t}\n\n\t# 000713\n\t# this BS is deprecated, I think.\n\t# haha, I am really witty. <ew>\n\n\telsif ($line =~ /^BSDEPRECATED/) {\n\t    $line =~ m/^BS\\s+\\d+\\s+\\d+\\s+(.+)/;\n\t    my $member = $1;\n\t    $self->{'contigs'}->{$contig_number}->{$member}++;\n\t}\n\t# the members of the contigs are determined by the AF line in the ace file\n\telsif ($line =~ /^AF/) {\n\t    $self->debug(\"I see an AF line here.\\n\");\n\t    $line =~ /^AF\\ (\\S+)\\ (\\w)\\ (\\S+)/;\n\n            # push the name of the current read onto the member array for this contig\n\t    push @{$self->{'contigs'}->{$contig_number}->{'member_array'}},$1;\n\n            # the first read in the contig will be named the \"top\" read\n\t    if (!$top) {\n\t\t$self->debug(\"\\$top is not set.\\n\");\n\t\tif ($self->{'contigs'}->{$contig_number}->{'contig_direction'} eq \"C\") {\n\t\t    $self->debug(\"Reversing the order of the reads. The bottom will be $1\\n\");\n\n\t\t    # if the contig sequence is marked as the\n\t\t    # complement, the top becomes the bottom and$\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_name'} = $1;\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_complement'} = $2;\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_start'} = $3;\n\t\t}\n\t\telse {\n\t\t    $self->debug(\"NOT reversing the order of the reads. \".\n                                 \"The top_name will be $1\\n\");\n\t\t    # if the contig sequence is marked as the\n\t\t    # complement, the top becomes the bottom and$\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_name'} = $1;\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_complement'} = $2;\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_start'} = $3;\n\t\t}\n\t\t$top = 1;\n\t    }\n\t    else {\n\n\t\t# if the contig sequence is marked as the complement,\n\t\t# the top becomes the bottom and the bottom becomes\n\t\t# the top\n\t\tif ($self->{'contigs'}->{$contig_number}->{'contig_direction'} eq \"C\") {\n\t\t    $self->debug(\"Reversing the order of the reads. The top will be $1\\n\");\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_name'} = $1;\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_complement'} = $2;\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_start'} = $3;\n\t\t}\n\t\telse {\n\t\t    $self->debug(\"NOT reversing the order of the reads. The bottom will be $1\\n\");\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_name'} = $1;\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_complement'} = $2;\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_start'} = $3;\n\t\t}\n\t\t$top = undef;\n\t    }\n\t}\n    }\n    return 0;\n}\n\n=head2 set_reverse_designator($some_string)\n\n Title   : set_reverse_designator($some_string)\n Usage   : $o_consed->set_reverse_designator($some_string);\n Function: Set the designator for the reverse read of contigs in this\n\t   Bio::Tools::Alignment::Consed object. Used to determine if\n           contigs containing two reads can be named.\n Returns : The value of $o_consed->{reverse_designator} so you can check\n\t   to see that it was set properly.\n Args    : An arbitrary string.\n\nMay be useful only to me. I<shrug>\n\n\nsub set_reverse_designator {\n    my ($self,$reverse_designator) = @_;\n    $self->{'reverse_designator'} = $reverse_designator;\n    $self->{'o_trim'}->set_reverse_designator($reverse_designator);\n    return $self->{'reverse_designator'};\n}\t\t\t\t# end set_reverse_designator\n\n=head2 set_forward_designator($some_string)\n\n Title   : set_forward_designator($some_string)\n Usage   : $o_consed->set_forward_designator($some_string);\n Function: Set the designator for the forward read of contigs in this\n\t   Bio::Tools::Alignment::Consed object. Used to determine if\n           contigs containing two reads can be named.\n Returns : The value of $o_consed->{forward_designator} so you can check\n\t   to see that it was set properly.\n Args    : An arbitrary string.\n\nMay be useful only to me. I<shrug>\n\n\nsub set_forward_designator {\n    my ($self,$forward_designator) = @_;\n    $self->{'forward_designator'} = $forward_designator;\n    $self->{'o_trim'}->set_forward_designator($forward_designator);\n    return $self->{'forward_designator'};\n}\t\t\t\t# end set_forward_designator\n\n=head2 set_designator_ignore_case(\"yes\")\n\n Title   : set_designator_ignore_case(\"yes\")\n Usage   : $o_consed->set_designator_ignore_case(\"yes\");\n Function: Deprecated.\n Returns : Deprecated.\n Args    : Deprecated.\n\nDeprecated. Really. Trust me.\n\n\nsub set_designator_ignore_case {\n    my ($self,$ignore_case) = @_;\n    if ($ignore_case eq \"yes\") {\n\t$self->{'designator_ignore_case'} = 1;\n    }\n    return $self->{'designator_ignore_case'};\n}\t\t\t\t# end set_designator_ignore_case\n\n=head2 set_trim_points_singlets_and_singletons()\n\n Title   : set_trim_points_singlets_and_singletons()\n Usage   : $o_consed->set_trim_points_singlets_and_singletons();\n Function: Set the trim points for singlets and singletons based on\n\t   quality.  Uses the Bio::Tools::Alignment::Trim object. Use\n\t   at your own risk because the Bio::Tools::Alignment::Trim\n\t   object was designed specifically for me and is mysterious\n\t   in its ways. Every time somebody other then me uses it a\n\t   swarm of locusts decends on a small Central American\n\t   village so do not say you weren't warned.\n Returns : Nothing.\n Args    : None.\n\nWorking on exceptions and warnings here.\n\nSee L<Bio::Tools::Alignment::Trim> for more information\n\n\n#' to make my emacs happy\n\nsub set_trim_points_singlets_and_singletons {\n    my ($self) = @_;\n    $self->debug(\"Consed.pm : \\$self is $self\\n\");\n    my (@points,$trimmed_sequence);\n    if (!$self->{'doublets_set'}) {\n        $self->debug(\"You need to set the doublets before you use \".\n                     \"set_trim_points_singlets_and_doublets. Doing that now.\");\n\t$self->set_doublets();\n    }\n    foreach (sort keys %{$self->{'contigs'}}) {\n\tif ($self->{'contigs'}->{$_}->{'class'} eq \"singlet\") {\n\t    $self->debug(\"Singlet $_\\n\");\n\t    # this is what Warehouse wants\n\t    #         my ($self,$sequence,$quality,$name) = @_;\n\t    # this is what Bio::Tools::Alignment::Trim::trim_singlet wants:\n\t    # my ($self,$sequence,$quality,$name,$class) = @_;\n\t    # the following several lines are to make the parameter passing legible.\n\t    my ($sequence,$quality,$name,$class);\n\t    $sequence = $self->{'contigs'}->{$_}->{'consensus'};\n\t    if (!$self->{'contigs'}->{$_}->{'quality'}) { $quality = \"unset\"; }\n\t    else { $quality = $self->{'contigs'}->{$_}->{'quality'}; }\n\t    $name = $self->{'contigs'}->{$_}->{'name'};\n\t    $class = $self->{'contigs'}->{$_}->{'class'};\n\t    @points = @{$self->{'o_trim'}->trim_singlet($sequence,$quality,$name,$class)};\n\t    $self->{'contigs'}->{$_}->{'start_point'} = $points[0];\n\t    $self->{'contigs'}->{$_}->{'end_point'} = $points[1];\n\t    $self->{'contigs'}->{$_}->{'sequence_trimmed'} = \n                substr($self->{contigs}->{$_}->{'consensus'},$points[0],$points[1]-$points[0]);\n\t}\n    }\n    $self->debug(\"Bio::Tools::Alignment::Consed::set_trim_points_singlets\".\n                 \"_and_singletons: Done setting the quality trimpoints.\\n\");\n    return;\n}  # end set_trim_points_singlet\n\n=head2 set_trim_points_doublets()\n\n Title   : set_trim_points_doublets()\n Usage   : $o_consed->set_trim_points_doublets();\n Function: Set the trim points for doublets based on quality. Uses the\n\t   Bio::Tools::Alignment::Trim object. Use at your own risk because\n           the Bio::Tools::Alignment::Trim object was designed specifically\n           for me and is mysterious in its ways. Every time somebody other\n           then me uses it you risk a biblical plague being loosed on your\n           city.\n Returns : Nothing.\n Args    : None.\n Notes   : Working on exceptions here.\n\nSee L<Bio::Tools::Alignment::Trim> for more information\n\n\nsub set_trim_points_doublets {\n    my $self = shift;\n    my @points;\n    $self->debug(\"Bio::Tools::Alignment::Consed::set_trim_points_doublets:\".\n                 \" Restoring zeros for doublets.\\n\");\n    # &show_missing_sequence($self);\n    $self->debug(\"Bio::Tools::Alignment::Consed::set_trim_points_doublets:\".\n                 \" Setting doublet trim points.\\n\");\n    foreach (sort keys %{$self->{'contigs'}}) {\n\tif ($self->{'contigs'}->{$_}->{'class'} eq \"doublet\") {\n            # my ($self,$sequence,$quality,$name,$class) = @_;\n            my @quals = split(' ',$self->{'contigs'}->{$_}->{'quality'});\n\n\t    @points = $self->{o_trim}->trim_doublet\n                ($self->{'contigs'}->{$_}->{'consensus'},\n                 $self->{'contigs'}->{$_}->{'quality'},\n                 $self->{'contigs'}->{$_}->{name},\n                 $self->{'contigs'}->{$_}->{'class'});\n\t    $self->{'contigs'}->{$_}->{'start_point'} = $points[0];\n\t    $self->{'contigs'}->{$_}->{'end_point'} = $points[1];\n            # now set this\n\t    $self->{'contigs'}->{$_}->{'sequence_trimmed'} =\n                substr($self->{contigs}->{$_}->{'consensus'},\n                       $points[0],$points[1]-$points[0]);\n\t    # 010102 the deprecated way to do things:\n\t}\n    }\n    $self->debug(\"Bio::Tools::Alignment::Consed::set_trim_points_doublets:\".\n                 \" Done setting doublet trim points.\\n\"); \n    return;\n} # end set_trim_points_doublets\n\n=head2 get_trimmed_sequence_by_name($name)\n\n Title   : get_trimmed_sequence_by_name($name)\n Usage   : $o_consed->get_trimmed_sequence_by_name($name);\n Function: Returns the trimmed_sequence of a contig with {name} eq $name.\n Returns : A scalar- the trimmed sequence.\n Args    : The {name} of a contig.\n Notes   : \n\n\nsub get_trimmed_sequence_by_name {\n    my ($self,$name) = @_;\n    my $trimmed_sequence;\n    my $contigname = &get_contig_number_by_name($self,$name);\n    my $class = $self->{'contigs'}->{$contigname}->{'class'};\n    # what is this business and who was smoking crack while writing this?\n    # if ($class eq \"singlet\") {\n    # send the sequence, the quality, and the name\n    # $trimmed_sequence = $self->{o_trim}->trim_singlet\n    #  ($self->{'contigs'}->{$contigname}->{consensus},\n    #   $self->{'contigs'}->{$contigname}->{'quality'},$name);\n    # }\n    return $self->{'contigs'}->{$contigname}->{'sequence_trimmed'};\n}\n\n=head2 set_dash_present_in_sequence_name(\"yes\")\n\n Title   : set_dash_present_in_sequence_name(\"yes\")\n Usage   : $o_consed->set_dash_present_in_sequence_name(\"yes\");\n Function: Deprecated. Part of an uncompleted thought. (\"Oooh! Shiny!\")\n Returns : Nothing.\n Args    : \"yes\" to set {dash_present_in_sequence_name} to 1\n Notes   : \n\n\nsub set_dash_present_in_sequence_name {\n    my ($self,$dash_present) = @_;\n    if ($dash_present eq \"yes\") {\n\t$self->{'dash_present_in_sequence_name'} = 1;\n    }\n    else {\n\t$self->{'dash_present_in_sequence_name'} = 0;\n    }\n    return $self->{'dash_present_in_sequence_name'};\n} # end set_dash_present_in_sequence_name\n\n=head2 set_doublets()\n\n Title   : set_doublets()\n Usage   : $o_consed->set_doublets();\n Function: Find pairs that have similar names and mark them as doublets\n\t   and set the {name}.\n Returns : 0 or 1.\n Args    : None.\n\nA complicated subroutine that iterates over the\nBio::Tools::Alignment::Consed looking for contigs of 2. If the forward\nand reverse designator are removed from each of the reads in\n{'member_array'} and the remaining reads are the same, {name} is set\nto that name and the contig's class is set as \"doublet\".  If any of\nthose cases fail the contig is marked as a \"pair\".\n\n\n#' make my emacs happy\n\nsub set_doublets {\n    my ($self) = @_;\n    # set the designators in the Bio::Tools::Alignment::Trim object\n\n    $self->{'o_trim'}->set_designators($self->{'reverse_designator'},\n\t\t\t\t       $self->{'forward_designator'});\n    foreach my $key_contig (sort keys %{$self->{'contigs'}}) {\n\n\t# if there is a member array (why would there not be? This should be a die()able offence\n\t# but for now I will leave it\n\tif ($self->{'contigs'}->{$key_contig}->{'member_array'}) {\n\t    # if there are two reads in this contig \n\t    # i am pretty sure that this is wrong but i am keeping it for reference\n\t    # if (@{$self->{'contigs'}->{$key_contig}->{'member_array'}} == 2 || !$self->{'contigs'}->{$key_contig}->{'class'}) {\n\t    # <seconds later>\n\t    # <nod> WRONG. Was I on crack?\n\t    if (@{$self->{'contigs'}->{$key_contig}->{'member_array'}} == 2) {\n\t\t$self->{'contigs'}->{$key_contig}->{'num_members'} = 2;\n\t\t$self->debug(\"\\tThere are 2 members! Looking for the contig name...\\n\");\n\t\tmy $name = _get_contig_name($self,$self->{'contigs'}->{$key_contig}->{'member_array'});\n\t\t$self->debug(\"The name is $name\\n\") if defined $name;\n\t\tif ($name) {\n\t\t    $self->{'contigs'}->{$key_contig}->{'name'} = $name;\n\t\t    $self->{'contigs'}->{$key_contig}->{'class'} = \"doublet\";\n\t\t} else {\n\t\t    $self->debug(\"$key_contig is a pair.\\n\");\n\t\t    $self->{'contigs'}->{$key_contig}->{'class'} = \"pair\";\n\t\t}\n\t    }\n            # this is all fair and good but what about singlets?\n            # they have one reads in the member_array but certainly are not singletons\n\t    elsif (@{$self->{'contigs'}->{$key_contig}->{'member_array'}} == 1) {\n\t\t# set the name to be the name of the read\n\t\t$self->{'contigs'}->{$key_contig}->{name} = @{$self->{'contigs'}->{$key_contig}->{'member_array'}}[0];\n\t\t# set the number of members to be one\n\t\t$self->{'contigs'}->{$key_contig}->{num_members} = 1;\n\t\t# if this was a singlet, it would already belong to the class \"singlet\"\n\t\t# so leave it alone\n\t\t# if it is not a singlet, it is a singleton! lablel it appropriately\n\t\tunless ($self->{'contigs'}->{$key_contig}->{'class'}) {\n\t\t    $self->{'contigs'}->{$key_contig}->{'class'} = \"singleton\";\n\t\t}\n\t    }\n            # set the multiplet characteristics\n\t    elsif (@{$self->{'contigs'}->{$key_contig}->{'member_array'}} >= 3) {\n\t\t$self->{'contigs'}->{$key_contig}->{'num_members'} = @{$self->{'contigs'}->{$key_contig}->{'member_array'}};\n\t\t$self->{'contigs'}->{$key_contig}->{'class'} = \"multiplet\";\n\t    }\n\t    $self->{'contigs'}->{$key_contig}->{'num_members'} = @{$self->{'contigs'}->{$key_contig}->{'member_array'}};\n\n\t}\n    }\n    $self->{'doublets_set'} = \"done\";\n    return 0;\n}\t\t\t\t# end set_doublets\n\n=head2 set_singlets\n\n Title   : set_singlets\n Usage   : $o_consed->set_singlets();\n Function: Read in a singlets file and place them into the\n\t   Bio::Tools::Alignment::Consed object.\n Returns : Nothing.\n Args    : A scalar to turn on verbose parsing of the singlets file.\n Notes   : \n\n\nsub set_singlets {\n    # parse out the contents of the singlets file\n    my ($self) = @_;\n    $self->debug(\"Bio::Tools::Alignment::Consed Adding singlets to the contig hash...\\n\"); \n    my $full_filename = $self->{'filename'};\n    $self->debug(\"Bio::Tools::Alignment::Consed::set_singlets: \\$full_filename is $full_filename\\n\");\n    $full_filename =~ m/(.*\\/)(.*ace.*)$/; \t\t\t       \n    my ($base_path,$filename) = ($1,$2);\n    $self->debug(\"Bio::Tools::Alignment::Consed::set_singlets: singlets filename is $filename and \\$base_path is $base_path\\n\");\n    $filename =~ m/(.*)ace.*$/;\n    my $singletsfile = $base_path.$1.\"singlets\";\n    $self->debug(\"\\$singletsfile is $singletsfile\\n\");\n     if (!-f $singletsfile) {\n          # there is no singlets file.\n          $self->{'singlets_set'} = \"done\";\n          return;\n     }\n\t$self->debug(\"$singletsfile is indeed a file. Trying to open it...\\n\");\n    my $singlets_fh = Bio::Root::IO->new(-file => $singletsfile);\n    my ($sequence,$name,$count);\n    while ($_ = $singlets_fh->_readline()) {\n\tchomp $_;\n\tif (/\\>/) {\n\t    if ($name && $sequence) {\n\t\t$self->debug(\"Adding $name with sequence $sequence to hash...\\n\");\n\t\tpush @{$self->{'contigs'}->{$name}->{'member_array'}},$name;\n\t\t$self->{'contigs'}->{$name}->{'consensus'} = $sequence;\n\t\t$self->{'contigs'}->{$name}->{'name'} = $name;\n\t\t$self->{'contigs'}->{$name}->{\"singlet\"} = 1;\n\t\t$self->{'contigs'}->{$name}->{'class'} = \"singlet\";\n\t    }\n\t    $sequence = $name = undef;\n\t    $count++;\n\t    m/^\\>(.*)\\s\\sCHROMAT/;\n\t    $name = $1;\n\t    if (!$name) {\n\t\tm/\\>(\\S+)\\s/;\n\t\t$name = $1;\n\t    }\n\t}\n\telse { $sequence .= $_; }\t\n    }\n    if ($name && $sequence) {\n\t$self->debug(\"Pushing the last of the singlets ($name)\\n\");\n\t@{$self->{'contigs'}->{$name}->{'member_array'}} = $name;\n\t$self->{'contigs'}->{$name}->{'consensus'} = $sequence;\n\t$self->{'contigs'}->{$name}->{'name'} = $name;\n\t$self->{'contigs'}->{$name}->{\"singlet\"} = 1;\n\t$self->{'contigs'}->{$name}->{'class'} = \"singlet\";\n    }\n    $self->debug(\"Bio::Tools::Alignment::Consed::set_singlets: Done adding singlets to the singlets hash.\\n\");\n    $self->{'singlets_set'} = \"done\";\n    return 0;\n}\t\t\t\t# end sub set_singlets\n\n=head2 get_singlets()\n\n Title   : get_singlets()\n Usage   : $o_consed->get_singlets();\n Function: Return the keynames of the singlets.\n Returns : An array containing the keynames of all \n           Bio::Tools::Alignment::Consed sequences in the class \"singlet\".\n Args    : None.\n Notes   : \n\n\nsub get_singlets {\n    # returns an array of singlet names\n    # singlets have \"singlet\"=1 in the hash\n    my $self = shift;\n    if (!$self->{singlets_set}) {\n\t$self->debug(\"You need to set the singlets before you get them. Doing that now.\");\n\t$self->set_singlets();\n    }\t\n\n    my (@singlets,@array);\n    foreach my $key (sort keys %{$self->{'contigs'}}) {\n\t# @array = @{$Consed::contigs{$key}->{'member_array'}};\n\t# somethimes a user will try to get a list of singlets before the classes for the rest of the\n\t# contigs has been set (see t/test.t for how I figured this out. <bah>\t\t\t\n\t# so either way, just return class=singlets\n\tif (!$self->{'contigs'}->{$key}->{'class'}) {\n\t    # print(\"$key has no class. why?\\n\");\n\t}\n\telsif ($self->{'contigs'}->{$key}->{'class'} eq \"singlet\") {\n\t    push @singlets,$key;\n\t}\n    }\n    return @singlets;\n}\n\n=head2 set_quality_by_name($name,$quality)\n\n Title   : set_quality_by_name($name,$quality)\n Usage   : $o_consed->set_quality_by_name($name,$quality);\n Function: Deprecated. Make the contig with {name} have {'quality'} $quality.\n           Probably used for testing.\n Returns : Nothing.\n Args    : The name of a contig and a scalar for its quality.\n Notes   : Deprecated.\n\n\nsub set_quality_by_name {\n    # this is likely deprecated\n    my ($self,$name,$quality) = shift;\n    my $return;\n    foreach (sort keys %{$self->{'contigs'}}) {\n\tif ($self->{'contigs'} eq \"$name\" || $self->{'contigs'}->{'name'} eq \"$name\") {\n\t    $self->{'contigs'}->{'quality'} = $quality;\n\t    $return=1;\n\t}\n    }\n    if ($return) { return \"0\"; } else { return \"1\"; }\n}\t\t\t\t# end set quality by name\n\n=head2 set_singlet_quality()\n\n Title   : set_singlet_quality()\n Usage   : $o_consed->set_singlet_quality();\n Function: For each singlet, go to the appropriate file in phd_dir and read\n           in the phred quality for that read and place it into {'quality'}\n Returns : 0 or 1.\n Args    : None.\n Notes   : This is the next subroutine that will receive substantial revision\n           in the next little while. It really should eval the creation of\n           Bio::Tools::Alignment::Phred objects and go from there. \n\n\nsub set_singlet_quality {\n    my $self = shift;\n    my $full_filename = $self->{'filename'};\n    $full_filename =~ m/(.*\\/)(.*)ace.*$/;\n    my ($base_path,$filename) = ($1,\"$2\".\"qual\");\n    my $singletsfile = $base_path.$filename;\n    if (-f $singletsfile) {\n\t# print(\"$singletsfile is indeed a file. Trying to open it...\\n\");\n    }\n    else {\n\t$self->warn(\"$singletsfile is not a file. Sorry.\\n\");\n\treturn;\n    }\n\tmy $singlets_fh = Bio::Root::IO->new(-file => $singletsfile);\n\tmy ($sequence,$name,$count);\n    my ($identity,$line,$quality,@qline);\n    while ($line = $singlets_fh->_readline()) {\n\tchomp $line;\n\tif ($line =~ /^\\>/) {\n\t    $quality = undef;\n\t    $line =~ m/\\>(\\S*)\\s/;\n\t    $identity = $1;\n\t}\n\telse {\n\t    if ($self->{'contigs'}->{$identity}) {\n\t\t$self->{'contigs'}->{$identity}->{'quality'} .= \"$line \";\n\t    }\n\t}\n\n    }\n    return 0;\n}\n\n=head2 set_contig_quality()\n\n Title   : set_contig_quality()\n Usage   : $o_consed->set_contig_quality();\n Function: Deprecated.\n Returns : Deprecated.\n Args    : Deprecated.\n Notes   : Deprecated. Really. Trust me.\n\n\nsub set_contig_quality {\n    # note: contigs _include_ singletons but _not_ singlets\n    my ($self) = shift;\n          # the unexpected results I am referring to here are a doubling of quality values.\n          # the profanity I uttered on discovering this reminded me of the simpsons:\n          # Ned Flanders: \"That is the loudest profanity I have ever heard!\"\n     $self->warn(\"set_contig_quality is deprecated and will likely produce unexpected results\");\n    my $full_filename = $self->{'filename'};\n    # Run_SRC3700_2000-08-01_73+74.fasta.screen.contigs.qual\n    # from Consed.pm\n    $full_filename =~ m/(.*\\/)(.*)ace.*$/;\n    my ($base_path,$filename) = ($1,\"$2\".\"contigs.qual\");\n    my $singletsfile = $base_path.$filename;\n    if (-f $singletsfile) {\n\t# print(\"$singletsfile is indeed a file. Trying to open it...\\n\");\n    }\n    else {\n\t$self->warn(\"Bio::Tools::Alignment::Consed::set_contig_quality $singletsfile is not a file. Sorry.\\n\");\n\treturn;\n    }\n    my $contig_quality_fh = Bio::Root::IO->new(-file => $singletsfile);\n\n    my ($sequence,$name,$count,$identity,$line,$quality);\n    while ($line = $contig_quality_fh->_readline()) {\n\tchomp $line;\n\tif ($line =~ /^\\>/) {\n\t    $quality = undef;\n\t    $line =~ m/\\>.*Contig(\\d+)\\s/;\n\t    $identity = $1;\n\t}\n\telse {\n\t    if ($self->{'contigs'}->{$identity} ) {\n\t\t$self->{'contigs'}->{$identity}->{'quality'} .= \" $line\";\n\t    }\n\t}\n    }\n}\t\t\t\t# end set_contig_quality\n\n=head2 get_multiplets()\n\n Title   : get_multiplets()\n Usage   : $o_consed->get_multiplets();\n Function: Return the keynames of the multiplets.\n Returns : Returns an array containing the keynames of all \n           Bio::Tools::Alignment::Consed sequences in the class \"multiplet\".\n Args    : None.\n Notes   : \n\n\nsub get_multiplets {\n\t    # returns an array of multiplet names\n\t    # multiplets have # members > 2\n    my $self = shift;\n    my (@multiplets,@array);\n    foreach my $key (sort keys %{$self->{'contigs'}}) {\n\tif ($self->{'contigs'}->{$key}->{'class'}) {\n\t    if ($self->{'contigs'}->{$key}->{'class'} eq \"multiplet\") {\n\t\tpush @multiplets,$key;\n\t    }\n\t}\n    }\n    return @multiplets;\n}\n\n=head2 get_all_members()\n\n  Title   : get_all_members()\n  Usage   : @all_members = $o_consed->get_all_members();\n  Function: Return a list of all of the read names in the \n            Bio::Tools::Alignment::Consed object.\n  Returns : An array containing all of the elements in all of the\n            {'member_array'}s.\n  Args    : None.\n  Notes   : \n\n\nsub get_all_members {\n    my $self = shift;\n    my @members;\n    foreach my $key (sort keys %{$self->{'contigs'}}) {\n\tif ($key =~ /^singlet/) {\n\t    push @members,$self->{'contigs'}->{$key}->{'member_array'}[0];\n\t}\n\telsif ($self->{'contigs'}->{$key}->{'member_array'}) {\n\t    push @members,@{$self->{'contigs'}->{$key}->{'member_array'}};\n\t}\n\t# else {\n\t#\tprint(\"Bio::Tools::Alignment::Consed: $key is _not_ an array. Pushing $self->{'contigs'}->{$key}->{'member_array'} onto \\@members\\n\");\n\t#\tpush @members,$self->{'contigs'}->{$key}->{'member_array'};\n\t# }\n    }\n    return @members;\n}\n\n=head2 sum_lets($total_only)\n\n Title   : sum_lets($total_only)\n Usage   : $statistics = $o_consed->sum_lets($total_only);\n Function: Provide numbers for how many sequences were accounted for in the\n           Bio::Tools::Alignment::Consed object.\n Returns : If a scalar is present, returns the total number of\n           sequences accounted for in all classes. If no scalar passed\n           then returns a string that looks like this:\n           Singt/singn/doub/pair/mult/total : 2,0,1(2),0(0),0(0),4\n           This example means the following: There were 1 singlets.\n           There were 0 singletons.  There were 1 doublets for a total\n           of 2 sequences in this class.  There were 0 pairs for a\n           total of 0 sequences in this class.  There were 0\n           multiplets for a total of 0 sequences in this class.  There\n           were a total of 4 sequences accounted for in the\n           Bio::Tools::Alignment::Consed object.   \n Args : A scalar is optional to change the way the numbers are returned.  \n Notes:\n\n\nsub sum_lets {\n    my ($self,$total_only) = @_;\n    my ($count,$count_multiplets,$multiplet_count);\n    my $singlets = &get_singlets($self); $count += $singlets;\n    my $doublets = &get_doublets($self); $count += ($doublets * 2);\n    my $pairs = &get_pairs($self); $count += ($pairs * 2);\n    my $singletons = &get_singletons($self); $count += $singletons;\n    my @multiplets = &get_multiplets($self);\n    $count_multiplets = @multiplets;\n    my $return_string;\n    foreach (@multiplets) {\n\tmy $number_members = $self->{'contigs'}->{$_}->{num_members};\t\n\t$multiplet_count += $number_members;\n    }\n    if ($multiplet_count) {\n\t$count += $multiplet_count;\n    }\n    foreach (qw(multiplet_count singlets doublets pairs singletons\n                multiplets count_multiplets)) {\n\tno strict 'refs';\t# renege for the block\n\tif (!${$_}) {\n            ${$_} = 0;\n\t}\n    }\n    if (!$multiplet_count) { $multiplet_count = 0; }\n    if ($total_only) {\n        return $count;\n    }\n    $return_string = \"Singt/singn/doub/pair/mult/total : \".\n        \"$singlets,$singletons,$doublets(\".\n         ($doublets*2).\"),$pairs(\".($pairs*2).\n        \"),$count_multiplets($multiplet_count),$count\";\n    return $return_string;\n}\n\n=head2 write_stats()\n\n Title   : write_stats()\n Usage   : $o_consed->write_stats();\n Function: Write a file called \"statistics\" containing numbers similar to\n\t   those provided in sum_lets().\n Returns : Nothing. Write a file in $o_consed->{path} containing something\n\t   like this:\n\n           0,0,50(100),0(0),0(0),100\n\n           Where the numbers provided are in the format described in the\n\t   documentation for sum_lets().\n Args    : None.\n Notes   : This might break platform independence, I do not know.\n\nSee L<sum_lets()|sum_lets>\n\n\nsub write_stats {\n    # worry about platform dependence here?\n    # oh shucksdarn.\n    my $self = shift;\n    my $stats_filename = $self->{'path'}.\"statistics\";\n    my $statistics_raw = $self->sum_lets;\n    my ($statsfilecontents) = $statistics_raw =~ s/.*\\ \\:\\ //g;\n    umask 0001;\n    my $fh = Bio::Root::IO->new(-file=>\"$stats_filename\");\n    # open(STATSFILE,\">$stats_filename\") or print(\"Could not open the statsfile: $!\\n\");\n    $fh->_print(\"$statsfilecontents\");\n    # close STATSFILE;\n    $fh->close();\n}\n\n=head2 get_singletons()\n\n Title   : get_singletons()\n Usage   : @singletons = $o_consed->get_singletons();\n Function: Return the keynames of the singletons.\n Returns : Returns an array containing the keynames of all\n\t   Bio::Tools::Alignment::Consed sequences in the class \"singleton\".\n Args    : None.\n Notes   : \n\n\nsub get_singletons {\n\t\t# returns an array of singleton names\n\t\t# singletons are contigs with one member (see consed documentation)\n\tmy $self = shift;\n\tmy (@singletons,@array);\n\tforeach my $key (sort keys %{$self->{'contigs'}}) {\n\t\tif ($self->{'contigs'}->{$key}->{'class'}) {\n\t\t    # print (\"$key class: $self->{'contigs'}->{$key}->{'class'}\\n\");\n\t\t}\n\t\telse {\n\t\t    # print(\"$key belongs to no class. why?\\n\");\n\t\t}\n\t\tif ($self->{'contigs'}->{$key}->{'member_array'}) {\n\t\t\t@array = @{$self->{'contigs'}->{$key}->{'member_array'}};\n\t\t}\n\t\tmy $num_array_elem = @array;\n\t\tif ($num_array_elem == 1 && $self->{'contigs'}->{$key}->{'class'} && $self->{'contigs'}->{$key}->{'class'} eq \"singleton\") { push @singletons,$key; }\n\t}\n\treturn @singletons;\n}\n\n=head2 get_pairs()\n\n Title   : get_pairs()\n Usage   : @pairs = $o_consed->get_pairs();\n Function: Return the keynames of the pairs.\n Returns : Returns an array containing the keynames of all\n           Bio::Tools::Alignment::Consed sequences in the class \"pair\".\n Args    : None.\n Notes   : \n\n\nsub get_pairs {\n    # returns an array of pair contig names\n    # a pair is a contig of two where the names do not match\n    my $self = shift;\n    my (@pairs,@array);\n    foreach my $key (sort keys %{$self->{'contigs'}}) {\n        if ($self->{'contigs'}->{$key}->{'member_array'}) {\n            if (@{$self->{'contigs'}->{$key}->{'member_array'}} == 2 &&\n                $self->{'contigs'}->{$key}->{'class'} eq \"pair\") {\n                push @pairs,$key;\n            }\n        }\n    }\n    return @pairs;\n}\n\n=head2 get_name($contig_keyname)\n\n Title   : get_name($contig_keyname)\n Usage   : $name = $o_consed->get_name($contig_keyname);\n Function: Return the {name} for $contig_keyname.\n Returns : A string. ({name})\n Args    : A contig keyname.\n Notes   : \n\n\nsub get_name {\n    my ($self,$contig) = @_;\n    return $self->{'contigs'}->{$contig}->{'name'};\n}\n\n=head2 _get_contig_name(\\@array_containing_reads)\n\n Title   : _get_contig_name(\\@array_containing_reads)\n Usage   : $o_consed->_get_contig_name(\\@array_containing_reads);\n Function: The logic for the set_doublets subroutine.\n Returns : The name for this contig.\n Args    : A reference to an array containing read names.\n Notes   : Depends on reverse_designator. Be sure this is set the way you\n\t   intend.\n\n\nsub _get_contig_name {\n    my ($self,$r_array) = @_;\n    my @contig_members = @$r_array;\n    my @name_nodir;\n    foreach (@contig_members) {\n        # how can I distinguish the clone name from the direction label?\n        # look for $Consed::reverse_designator and $Consed::forward_designator\n        # what if you do not find _any_ of those?\n        my $forward_designator = $self->{'forward_designator'} || \"f\";\n        my $reverse_designator = $self->{'reverse_designator'} || \"r\";\n        my $any_hits = /(.+)($forward_designator.*)/ || /(.+)($reverse_designator.*)/||/(.+)(_.+)/;\n        my $name = $1;\n        my $suffix = $2;\n        if ($name) {\n            # print(\"\\t\\$name is $name \");\n        }\n        if ($suffix) {\n            # print(\"and \\$suffix is $suffix.\\n\");\n        }\n                                # Jee, I hope we get a naming convention soon\n        if ($suffix) {\n            if ($suffix =~ /^$forward_designator/ || $suffix =~ /^$reverse_designator/) {\n                push @name_nodir,$name;\n            }\n\t\t\t\t# bugwatch here! should this be unnested?\n            else {\n                push @name_nodir,\"$name$suffix\";\n            }\n        }\n    }\n    # print(\"\\@name_nodir: @name_nodir\\n\");\n    my $mismatch = 0;\n    for (my $counter=0; $counter<@name_nodir;$counter++) {\n        next if ($name_nodir[0] eq $name_nodir[$counter]);\n        $mismatch = 1;\n    }\n    if ($mismatch == 0) {\n        # print(\"\\tYou have a cohesive contig named $name_nodir[0].\\n\\n\");\n        return $name_nodir[0];\n    } else {\n        # print(\"\\tYou have mixed names in this contig.\\n\\n\");\n    }\n}                               # end _get_contig_name\n\n=head2 get_doublets()\n\n Title   : get_doublets()\n Usage   : @doublets = $o_consed->get_doublets();\n Function: Return the keynames of the doublets.\n Returns : Returns an array containing the keynames of all\n           Bio::Tools::Alignment::Consed sequences in the class \"doublet\".\n Args    : None.\n Notes   : \n\n\nsub get_doublets {\n    my $self = shift;\n    if (!$self->{doublets_set}) {\n        $self->warn(\"You need to set the doublets before you can get them. Doing that now.\");\n        $self->set_doublets();\n    }\n    my @doublets;\n    foreach (sort keys %{$self->{'contigs'}}) {\n        if ($self->{'contigs'}->{$_}->{name} && $self->{'contigs'}->{$_}->{'class'} eq \"doublet\") {\n            push @doublets,$_;\n        }\n    }\n    return @doublets;\n}                               # end get_doublets\n\n=head2 dump_hash()\n\n Title   : dump_hash()\n Usage   : $o_consed->dump_hash();\n Function: Use dumpvar.pl to dump out the Bio::Tools::Alignment::Consed\n           object to STDOUT.\n Returns : Nothing.\n Args    : None.\n Notes   : I used this a lot in debugging.\n\n\nsub dump_hash {\n    my $self = shift;\n    my $dumper = new Dumpvalue;\n    $self->debug( \"Bio::Tools::Alignment::Consed::dump_hash - \".\n                  \"The following is the contents of the contig hash...\\n\");\n    $dumper->dumpValue($self->{'contigs'});\n}\n\n=head2 dump_hash_compact()\n\n Title   : dump_hash_compact()\n Usage   : $o_consed->dump_hash_compact();\n Function: Dump out the Bio::Tools::Alignment::Consed object in a compact way.\n Returns : Nothing.\n Args    : Nothing.\n Notes   : Cleaner then dumpValue(), dumpHash(). I used this a lot in\n           debugging.\n\n\nsub dump_hash_compact {\n    no strict 'refs';           # renege for the block\n    my ($self,$sequence) = @_;\n    # get the classes\n    my @singlets = $self->get_singlets();\n    my @singletons = $self->get_singletons();\n    my @doublets = $self->get_doublets();\n    my @pairs = $self->get_pairs();\n    my @multiplets = $self->get_multiplets();\n    print(\"Name\\tClass\\tMembers\\tQuality?\\n\");\n    foreach (@singlets) {\n        my @members = $self->get_members($_);\n        print($self->get_name($_).\"\\tsinglets\\t\".(join',',@members).\"\\t\");\n        if ($self->{'contigs'}->{$_}->{'quality'}) {\n            print(\"qualities found here\\n\");\n        } else {\n            print(\"no qualities found here\\n\");\n        }\n\n    }\n    foreach (@singletons) {\n        my @members = $self->get_members($_);\n        print($self->get_name($_).\"\\tsingletons\\t\".(join',',@members).\"\\t\");\n        if ($self->{'contigs'}->{$_}->{'quality'}) {\n            print(\"qualities found here\\n\");\n        } else {\n            print(\"no qualities found here\\n\");\n        }\n    }\n    foreach my $pair (@pairs) {\n        my @members = $self->get_members($pair);\n        my $name;\n        if (!$self->get_name($pair)) {\n            $name = \"BLANK\";\n        } else {\n            $name = $self->get_name($pair);\n        }\n        print(\"$name\\tpairs\\t\".(join',',@members).\"\\n\");\n    }\n    foreach (@doublets) {\n        my @members = $self->get_members_by_name($_);\n        print(\"$_\\tdoublets\\t\".(join',',@members).\"\\t\");\n        my $contig_number = &get_contig_number_by_name($self,$_);\n        if ($self->{'contigs'}->{$contig_number}->{'quality'}) {\n            print(\"qualities found here\\n\");\n        } else {\n            print(\"no qualities found here\\n\");\n        }\n        # print($_.\"\\tdoublets\\t\".(join',',@members).\"\\n\");\n    }\n    foreach (@multiplets) {\n        my @members = $self->get_members($_);\n        print(\"Contig $_\".\"\\tmultiplets\\t\".(join',',@members).\"\\n\");\n    }\n}                               # end dump_hash_compact\n\n=head2 get_phreds()\n\n Title   : get_phreds()\n Usage   : @phreds = $o_consed->get_phreds();\n Function: For each doublet in the Bio::Tools::Alignment::Consed hash, go\n           and get the phreds for the top and bottom reads. Place them into\n           {top_phreds} and {bottom_phreds}.\n Returns : Nothing.\n Args    : Nothing.\n\nRequires parse_phd() and reverse_and_complement(). I realize that it\nwould be much more elegant to pull qualities as required but there\nwere certain \"features\" in the acefile that required a bit more\ndetailed work be done to get the qualities for certain parts of the\nconsensus sequence. In order to make _sure_ that this was done\nproperly I wrote things to do all steps and then I used dump_hash()\nand checked each one to ensure expected bahavior. I have never changed\nthis, so there you are.\n\n\nsub get_phreds {\n    # this subroutine is the target of a rewrite to use the Bio::Tools::Alignment::Phred object.\n    my $self = shift;    \n    my $current_contig;\n    foreach $current_contig (sort keys %{$self->{'contigs'}}) {\t\n\tif ($self->{'contigs'}->{$current_contig}->{'class'} eq \"doublet\") {\n\t    $self->debug(\"$current_contig is a doublet. Going to parse_phd for top($self->{'contigs'}->{$current_contig}->{'top_name'}) and bottom($self->{'contigs'}->{$current_contig}->{'bottom_name'})\\n\");\n\t    my $r_phreds_top = &parse_phd($self,$self->{'contigs'}->{$current_contig}->{'top_name'});\n\t    my $r_phreds_bottom = &parse_phd($self,$self->{'contigs'}->{$current_contig}->{'bottom_name'});\n\t    if ($self->{'contigs'}->{$current_contig}->{'top_complement'} eq \"C\") {\n\t\t# print(\"Reversing and complementing...\\n\");\n\t\t$r_phreds_top = &reverse_and_complement($r_phreds_top);\n\t    }\n\t    if ($self->{'contigs'}->{$current_contig}->{'bottom_complement'} eq \"C\") {\n\t\t$r_phreds_bottom = &reverse_and_complement($r_phreds_bottom);\n\t    }\n\t    $self->{'contigs'}->{$current_contig}->{'top_phreds'} = $r_phreds_top;\n\t    $self->{'contigs'}->{$current_contig}->{'bottom_phreds'} = $r_phreds_bottom;\n\t}\n    }\n}\n\n=head2 parse_phd($read_name)\n\n Title   : parse_phd($read_name)\n Usage   : $o_consed->parse_phd($read_name);\n Function: Suck in the contents of a .phd file.\n Returns : A reference to an array containing the quality values for the read.\n Args    : The name of a read.\n Notes   : This is a significantly weak subroutine because it was always\n\t   intended that these functions, along with the functions provided by\n\t   get_phreds() be put into the Bio::SeqIO:phd module. This is done\n           now but the Bio::Tools::Alignment::Consed module has not be\n           rewritten to reflect this change.\n\nSee L<Bio::SeqIO::phd> for more information.\n\n\nsub parse_phd {\n    my ($self,$sequence_name) = @_;\n    $self->debug(\"Parsing phd for $sequence_name\\n\");\n    my $in_dna = 0;\n    my $base_number = 0;\n    my (@bases,@current_line);\n    # print(\"parse_phd: $sequence_name\\n\");\n    my $fh = Bio::Root::IO->new\n        (-file=>\"$self->{path}/../phd_dir/$sequence_name.phd.1\");\n    while ($fh->_readline()) {\n\t# print(\"Reading a line from a phredfile!\\n\");\n\tchomp;\n\tif (/^BEGIN_DNA/) { $in_dna = 1; next}\n\tif (/^END_DNA/) { last; }\n\tif (!$in_dna) { next; }\n\tpush(@bases,$_);\n    }\n    return \\@bases;\n}\n\n=head2 reverse_and_complement(\\@source)\n\n Title   : reverse_and_complement(\\@source)\n Usage   : $reference_to_array = $o_consed->reverse_and_complement(\\@source);\n Function: A stub for the recursive routine reverse_recurse().\n Returns : A reference to a reversed and complemented array of phred data.\n Args    : A reference to an array of phred data.\n Notes   : \n\n\nsub reverse_and_complement {\n    my $r_source = shift;\n    my $r_destination;\n    $r_destination = &reverse_recurse($r_source,$r_destination);\n    return $r_destination;\n}\n\n=head2 reverse_recurse($r_source,$r_destination)\n\n Title   : reverse_recurse(\\@source,\\@destination)\n Usage   : $o_consed->reverse_recurse(\\@source,\\@destination);\n Function: A recursive routine to reverse and complement an array of\n           phred data.\n Returns : A reference to an array containing reversed phred data.\n Args    : A reference to a source array and a reverence to a destination\n\t   array.\n\nRecursion is kewl, but this sub should likely be _reverse_recurse.","parameters":[{"label":"$$"}],"label":"reverse_recurse($$)"},"detail":"($$)","definition":"sub","containerName":"main::","range":{"start":{"line":1698,"character":0},"end":{"character":9999,"line":1707}},"name":"reverse_recurse"},{"range":{"start":{"line":1725,"character":0},"end":{"character":9999,"line":1733}},"name":"show_missing_sequence","detail":"()","signature":{"label":"show_missing_sequence()","parameters":[],"documentation":"1;\n# $Id: Consed.pm 16123 2009-09-17 12:57:27Z cjfields $\n# Bio::Tools::Alignment::Consed\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chad Matsalla\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Alignment::Consed - A module to work with objects from consed .ace files\n\n=head1 SYNOPSIS\n\n  # a report for sequencing stuff\n  my $o_consed = Bio::Tools::Alignment::Consed->new( \n      -acefile => \"/path/to/an/acefile.ace.1\",\n      -verbose => 1);\n  my $foo = $o_consed->set_reverse_designator(\"r\");\n  my $bar = $o_consed->set_forward_designator(\"f\");\n\n  # get the contig numbers\n  my @keys = $o_consed->get_contigs();\n\n  # construct the doublets\n  my $setter_doublets = $o_consed->choose_doublets();\n\n  # get the doublets\n  my @doublets = $o_consed->get_doublets();\n\n=head1 DESCRIPTION\n\nL<Bio::Tools::Alignment::Consed> provides methods and objects to deal\nwith the output from the Consed software suite. Specifically,\ntakes an C<.ace> file and provides objects for the results.\n\nA word about doublets: This module was written to accomodate a large\nEST sequencing operation. In this case, EST's were sequenced from the\n3' and from the 5' end of the EST. The objective was to find a\nconsensus sequence for these two reads.  Thus, a contig of two is what\nwe wanted, and this contig should consist of the forward and reverse\nreads of a getn clone. For example, for a forward designator of \"F\"\nand a reverse designator of \"R\", if the two reads chad1F and chad1R\nwere in a single contig (for example Contig 5) it will be determined\nthat the consensus sequence for Contig 5 will be the sequence for\nclone chad1.\n\nDoublets are good!\n\nThis module parses C<.ace> and related files. A detailed list of methods\ncan be found at the end of this document.\n\nI wrote a detailed rationale for design that may explain the reasons\nwhy some things were done the way they were done. That document is\nbeyond the scope of this pod and can probably be found in the\ndirectory from which this module was 'made' or at\nL<http://www.dieselwurks.com/bioinformatics/consedpm_documentation.pdf>.\n\nNote that the POD in that document might be old but the original\nrationale still stands.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nEmail chad-at-dieselwurks.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n#' \n\npackage Bio::Tools::Alignment::Consed;\n\nuse strict;\n\nuse FileHandle;\nuse Dumpvalue qw(dumpValue);\nuse Bio::Tools::Alignment::Trim;\nuse File::Spec;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\nour %DEFAULTS = ( 'f_designator' => 'f',\n\t\t  'r_designator' => 'r');\n\n=head2 new()\n\n Title   : new(-acefile => $path_to_some_acefile, -verbose => \"1\")\n Usage   : $o_consed = Bio::Tools::Alignment::Consed->\n              new(-acefile => $path_to_some_acefile, -verbose => \"1\");\n Function: Construct the Bio::Tools::Alignment::Consed object. Sets\n\t   verbosity for the following procedures, if necessary:\n\t   1. Construct a new Bio::Tools::Alignment::Trim object, to\n\t   handle quality trimming 2. Read in the acefile and parse it\n\n Returns : A reference to a Bio::Tools::Alignment::Consed object.\n Args    : A hash. (-acefile) is the filename of an acefile. If a full path\n\t   is not specified \"./\" is prepended to the filename and used from\n\t   instantiation until destruction. If you want \n           Bio::Tools::Alignment::Consed to be noisy during parsing of\n           the acefile, specify some value for (-verbose).\n\n\nsub new {\n    my ($class,%args) = @_;\n    my $self = $class->SUPER::new(%args);\n\n    $self->{'filename'} = $args{'-acefile'};\n\n    # this is special to UNIX and should probably use catfile : DONE!\n#    if (!($self->{'filename'} =~ m{/})) { \n#\t$self->{'filename'} = \"./\".$self->{'filename'}; \n#    } \n#    $self->{'filename'} =~ m/(.*\\/)(.*)ace.*$/;\n#    $self->{'path'} = $1;\n\n    # this is more generic and should work on most systems   \n    (undef, $self->{'path'}, undef) = File::Spec->splitpath($self->{'filename'});\n\n    $self->_initialize_io('-file'=>$self->{'filename'});\n    $self->{'o_trim'} = Bio::Tools::Alignment::Trim->new(-verbose => $self->verbose());\n    $self->set_forward_designator($DEFAULTS{'f_designator'});\n    $self->set_reverse_designator($DEFAULTS{'r_designator'});\n\n    $self->_read_file();\n    return $self;\n}\n\n=head2 set_verbose()\n\n Title   : set_verbose()\n Usage   : $o_consed->set_verbose(1);\n Function: Set the verbosity level for debugging messages. On instantiation\n\t   of the Bio::Tools::Alignment::Consed object the verbosity level\n           is set to 0 (quiet).\n Returns : 1 or 0.\n Args    : The verbosity levels are:\n\t      0 - quiet\n\t      1 - noisy\n\t      2 - noisier\n\t      3 - annoyingly noisy\n\nThis method for setting verbosity has largely been superseeded by a\nsub-by-sub way, where for every sub you can provide a (-verbose)\nswitch. I am doing converting this bit-by-bit so do not be surprised\nif some subs do not honour this.\n\n\n# from RootI\n\n# backwards compat\nsub set_verbose { (shift)->verbose(@_) }\n\n=head2 get_filename()\n\n Title   : get_filename()\n Usage   : $o_consed->get_filename();\n Function: Returns the name of the acefile being used by the\n\t   Bio::Tools::Alignment::Consed object.\n Returns : A scalar containing the name of a file.\n Args    : None.\n\n\n\nsub get_filename {\n    my $self = shift;\n    return $self->{'filename'};\n}\n\n=head2 count_sequences_with_grep()\n\n Title   : count_sequences_with_grep()\n Usage   : $o_consed->count_sequences_with_grep();\n Function: Use /bin/grep to scan through the files in the ace project dir\n\t   and count sequences in those files. I used this method in the\n\t   development of this module to verify that I was getting all of the\n\t   sequences. It works, but it is (I think) unix-like platform\n\t   dependent.\n Returns : A scalar containing the number of sequences in the ace project\n\t   directory.\n Args    : None.\n\nIf you are on a non-UNIX platform, you really do not have to use\nthis. It is more of a debugging routine designed to address very\nspecific problems.\n\nThis method was reimplemented to be platform independent with a pure\nperl implementation.  The above note can be ignored.\n\n\nsub count_sequences_with_grep {\n    my $self = shift;\n    my ($working_dir,$grep_cli,@total_grep_sequences);\n    # this should be migrated to a pure perl implementation ala\n    # Tom Christiansen's 'tcgrep'\n    # http://www.cpan.org/modules/by-authors/id/TOMC/scripts/tcgrep.gz\n\n    open(my $FILE, $self->{'filename'}) or do { $self->warn(\"cannot open file \".$self->{'filename'}. \" for grepping\"); return}; \n    my $counter =0;\n    while(<$FILE>) { $counter++ if(/^AF/); }\n\n    close $FILE;\n    opendir(my $SINGLETS,$self->{'path'});\n    foreach my $f ( readdir($SINGLETS) ) {\n\tnext unless ($f =~ /\\.singlets$/); \n\topen(my $FILE, File::Spec->catfile($self->{'path'},$f)) or do{ $self->warn(\"cannot open file \".File::Spec->catfile($self->{'path'},$f)); next };\n\twhile(<$FILE>) { $counter++ if(/^>/) }\n\tclose $FILE;\n    }\n    return $counter;\n}\n\n=head2 get_path()\n\n Title   : get_path()\n Usage   : $o_consed->get_path();\n Function: Returns the path to the acefile this object is working with.\n Returns : Scalar. The path to the working acefile.\n Args    : None.\n\n\nsub get_path {\n    my $self = shift;\n    return $self->{'path'};\n}\n\n=head2 get_contigs()\n\n Title   : get_contigs()\n Usage   : $o_consed->get_contigs();\n Function: Return the keys to the Bio::Tools::Alignment::Consed object.\n Returns : An array containing the keynames in the\n           Bio::Tools::Alignment::Consed object.\n Args    : None.\n\nThis would normally be used to get the keynames for some sort of\niterator. These keys are worthless in general day-to-day use because\nin the Consed acefile they are simply Contig1, Contig2, ...\n\n\nsub get_contigs {\n    my ($self,$contig) = @_;\n    my @contigs = sort keys %{$self->{'contigs'}};\n    return @contigs;\n}\n\n=head2 get_class($contig_keyname)\n\n Title   : get_class($contig_keyname)\n Usage   : $o_consed->get_class($contig_keyname);\n Function: Return the class name for this contig\n Returns : A scalar representing the class of this contig.\n Args    : None.\n Notes   : \n\n\nsub get_class {\n    my ($self,$contig) = @_;\n    return $self->{contigs}->{$contig}->{class};\n}\n\n=head2 get_quality_array($contig_keyname)\n\n Title   : get_quality_array($contig_keyname)\n Usage   : $o_consed->get_quality_array($contig_keyname);\n Function: Returns the quality for the consensus sequence for the given\n\t   contig as an array. See get_quality_scalar to get this as a scalar.\n Returns : An array containing the quality for the consensus sequence with\n\t   the given keyname.\n Args    : The keyname of a contig. Note: This is a keyname. The key would\n\t   normally come from get_contigs.\n\nReturns an array, not a reference. Is this a bug? I<thinking> No.\nWell, maybe.  Why was this developed like this? I was using FreezeThaw\nfor object persistence, and when it froze out these arrays it took a\nlong time to thaw it. Much better as a scalar.\n\nSee L<get_quality_scalar()|get_quality_scalar>\n\n\nsub get_quality_array {\n    my ($self,$contig) = @_;\n    return split ' ', $self->{contigs}->{$contig}->{quality};\n}\n\n=head2 get_quality_scalar($contig_keyname)\n\n Title   : get_quality_scalar($contig_keyname)\n Usage   : $o_consed->get_quality_scalar($contig_keyname);\n Function: Returns the quality for the consensus sequence for the given\n\t   contig as a scalar. See get_quality_array to get this as an array.\n Returns : An scalar containing the quality for the consensus sequence with\n           the given keyname.\n Args    : The keyname of a contig. Note this is a _keyname_. The key would\n\t   normally come from get_contigs.\n\nWhy was this developed like this? I was using FreezeThaw for object\npersistence, and when it froze out these arrays it took a coon's age\nto thaw it. Much better as a scalar.\n\nSee L<get_quality_array()|get_quality_array>\n\n\n#'\nsub get_quality_scalar {\n    my ($self,$contig) = @_;\n    return $self->{'contigs'}->{$contig}->{'quality'};\n}\n\n=head2 freeze_hash()\n\n Title   : freeze_hash()\n Usage   : $o_consed->freeze_hash();\n\n Function: Use Ilya's FreezeThaw module to create a persistent data\n\t   object for this Bio::Tools::Alignment::Consed data\n\t   structure. In the case of AAFC, we use\n\t   Bio::Tools::Alignment::Consed to pre-process bunches of\n\t   sequences, freeze the structures, and send in a harvesting\n\t   robot later to do database stuff.\n Returns : 0 or 1;\n Args    : None.\n\nThis procedure was removed so Consed.pm won't require FreezeThaw.\n\n\n#'\nsub freeze_hash {\n    my $self = shift;\n    $self->warn(\"This method (freeze_hash) was removed \".\n                \"from the bioperl consed.pm. Sorry.\\n\");\n    if (1==2) {\n        $self->debug(\"Bio::Tools::Alignment::Consed::freeze_hash:\".\n                     \" \\$self->{path} is $self->{path}\\n\");\n        my $filename = $self->{'path'}.\"frozen\";\n        my %contigs = %{$self->{'contigs'}};\n        my $frozen = freeze(%contigs);\n        umask 0001;\n        open (my $FREEZE,\">$filename\") or do {\n            $self->warn( \"Bio::Tools::Alignment::Consed could not \".\n                         \"freeze the contig hash because the file \".\n                         \"($filename) could not be opened: $!\\n\");\n            return 1;\n        };\n        print $FREEZE $frozen;\n        return 0;\n    }\n}\n\n=head2 get_members($contig_keyname)\n\n Title   : get_members($contig_keyname)\n Usage   : $o_consed->get_members($contig_keyname);\n Function: Return the _names_ of the reads in this contig.\n Returns : An array containing the names of the reads in this contig.\n Args    : The keyname of a contig. Note this is a keyname. The keyname\n\t   would normally come from get_contigs.\n\nSee L<get_contigs()|get_contigs>\n\n\nsub get_members {\n    my ($self,$contig) = @_;\n    if (!$contig) {\n\t$self->warn(\"You need to provide the name of a contig to \".\n                    \"use Bio::Tools::Alignment::Consed::get_members!\\n\");\n\treturn;\n    }\n    return @{$self->{'contigs'}->{$contig}->{'member_array'}};\n}\n\n=head2 get_members_by_name($some_arbitrary_name)\n\n Title   : get_members_by_name($some_arbitrary_name)\n Usage   : $o_consed->get_members_by_name($some_arbitrary_name);\n Function: Return the names of the reads in a contig. This is the name given\n\t   to $contig{key} based on what is in the contig. This is different\n\t   from the keys retrieved through get_contigs().\n Returns : An array containing the names of the reads in the contig with this\n\t   name.\n Args    : The name of a contig. Not a key, but a name.\n\nHighly inefficient. use some other method if possible.\nSee L<get_contigs()|get_contigs>\n\n\nsub get_members_by_name {\n    my ($self,$name) = @_;\n    # build a list to try to screen for redundancy\n    my @contigs_with_that_name;\n    foreach my $currkey ( sort keys %{$self->{'contigs'}} ) {\n\tnext if (!$self->{'contigs'}->{$currkey}->{'name'});\n\tif ($self->{'contigs'}->{$currkey}->{'name'} eq \"$name\") {\n\t    push @contigs_with_that_name,$currkey;\n\t}\n    }\n    my $count = @contigs_with_that_name;\n    if ($count == 1) {\n\tmy $contig_num = $contigs_with_that_name[0];\n\treturn @{$self->{'contigs'}->{$contig_num}->{'member_array'}};\n    }\n}\n\n=head2 get_contig_number_by_name($some_arbitrary_name)\n\n Title   : get_contig_number_by_name($some_arbitrary_name)\n Usage   : $o_consed->get_contig_number_by_name($some_arbitrary_name);\n Function: Return the names of the reads in a contig. This is the name given\n\t   to $contig{key} based on what is in the contig. This is different\n\t   from the keys retrieved through get_contigs().\n Returns : An array containing the names of the reads in the contig with this\n\t   name.\n Args    : The name of a contig. Not a key, but a name.\n\nSee L<get_contigs()|get_contigs>\n\n\nsub get_contig_number_by_name {\n    my ($self,$name) = @_;\n    foreach my $currkey (sort keys %{$self->{'contigs'}}) {\n\tif ($self->{'contigs'}->{$currkey}->{'name'} && \n\t    $self->{'contigs'}->{$currkey}->{'name'} eq \"$name\") {\n\t    return $currkey;\n\t}\n    }\n}\t\n\n=head2 get_sequence($contig_keyname)\n\n Title   : get_sequence($contig_keyname)\n Usage   : $o_consed->get_sequence($contig_keyname); \n Function: Returns the consensus sequence for a given contig.\n Returns : A scalar containing a sequence.\n Args    : The keyname of a contig. Note this is a key. The key would\n\t   normally come from get_contigs.\n\nSee L<get_contigs()|get_contigs>\n\n\nsub get_sequence {\n    my ($self,$contig) = @_;\n    return $self->{'contigs'}->{$contig}->{'consensus'};\n}\n\n=head2 set_final_sequence($some_sequence)\n\n Title   : set_final_sequence($name,$some_sequence)\n Usage   : $o_consed->set_final_sequence($name,$some_sequence);\n Function: Provides a manual way to set the sequence for a given key in the\n\t   contig hash. Rarely used.\n Returns : 0 or 1;\n Args    : The name (not the keyname) of a contig and an arbitrary string.\n\nA method with a questionable and somewhat mysterious origin. May raise\nthe dead or something like that.\n\n\nsub set_final_sequence {\n    my ($self,$name,$sequence) = @_;\n    if (!$self->{'contigs'}->{$name}) {\n\t$self->warn(\"You cannot set the final sequence for \".\n                    \"$name because it doesn't exist!\\n\");\n\treturn 1;\n    }\n    else {\n\t$self->{'contigs'}->{$name}->{'final_sequence'} = $sequence;\n    }\n    return 0;\n}\n\n=head2  _read_file()\n\n Title   : _read_file();\n Usage   : _read_file();\n Function: An internal subroutine used to read in an acefile and parse it\n\t   into a Bio::Tools::Alignment::Consed object.\n Returns : 0 or 1.\n Args    : Nothing.\n\nThis routine creates and saves the filhandle for reading the files in\n{fh}\n\n\nsub _read_file {\n    my ($self) = @_;\n    my ($line,$in_contig,$in_quality,$contig_number,$top);\n    # make it easier to type $fhl\n    while (defined($line=$self->_readline()) ) {\n\tchomp $line;\n\t# check if there is anything on this line\n\t# if not, you can stop gathering consensus sequence\n\tif (!$line) {\n\t    # if the line is blank you are no longer to gather consensus \n\t    # sequence or quality values\n\t    $in_contig = 0;\n\t    $in_quality = 0;\n\t}\n\t# you are currently gathering consensus sequence\n\telsif ($in_contig) {\n\t    if ($in_contig == 1) {\n\t\t$self->debug(\"Adding $line to consensus of contig number $contig_number.\\n\");\n\t\t$self->{'contigs'}->{$contig_number}->{'consensus'} .= $line;\n\t    }\n\t}\n\telsif ($in_quality) {\n\t    if (!$line) {\n\t\t$in_quality = undef;\n\t    }\n\t    else {\n\n\t\t# I wrote this in here because acefiles produced by\n\t\t# cap3 do not have a leading space like the acefiles\n\t\t# produced by phrap and there is the potential to have\n\t\t# concatenated quality values like this: 2020 rather\n\t\t# then 20 20 whre lines collide. Thanks Andrew for\n\t\t# noticing.\n\n\t\tif ($self->{'contigs'}->{$contig_number}->{'quality'} &&\n                    !($self->{'contigs'}->{$contig_number}->{'quality'} =~ m/\\ $/)) {\n\t\t    $self->{'contigs'}->{$contig_number}->{'quality'} .= \" \";\n\t\t}\n\t\t$self->{'contigs'}->{$contig_number}->{'quality'} .= $line;\n\t    }\n\t}\n\telsif ($line =~ /^BQ/) {\n\t    $in_quality = 1;\n\t}\n\n\t# the line /^CO/ like this:\n\t# CO Contig1 796 1 1 U\n\t# can be broken down as follows:\n\t# CO - Contig!\n\t# Contig1 - the name of this contig\n\t# 796 - Number of bases in this contig\n\t# 1 - Number of reads in this contig\n\t# 1 - number of base segments in this contig\n\t# U - Uncomplemented\n\n\telsif ($line =~ /^CO/) {\n\t    $line =~ m/^CO\\ Contig(\\d+)\\ \\d+\\ \\d+\\ \\d+\\ (\\w)/;\n\t    $contig_number = $1;\n\t    if ($2 eq \"C\") {\n\t\t$self->debug(\"Contig $contig_number is complemented!\\n\");\n\t    }\n\t    $self->{'contigs'}->{$contig_number}->{'member_array'} = [];\n\t    $self->{'contigs'}->{$contig_number}->{'contig_direction'} = \"$2\";\n\t    $in_contig = 1;\n\t}\n\n\t# 000713\n\t# this BS is deprecated, I think.\n\t# haha, I am really witty. <ew>\n\n\telsif ($line =~ /^BSDEPRECATED/) {\n\t    $line =~ m/^BS\\s+\\d+\\s+\\d+\\s+(.+)/;\n\t    my $member = $1;\n\t    $self->{'contigs'}->{$contig_number}->{$member}++;\n\t}\n\t# the members of the contigs are determined by the AF line in the ace file\n\telsif ($line =~ /^AF/) {\n\t    $self->debug(\"I see an AF line here.\\n\");\n\t    $line =~ /^AF\\ (\\S+)\\ (\\w)\\ (\\S+)/;\n\n            # push the name of the current read onto the member array for this contig\n\t    push @{$self->{'contigs'}->{$contig_number}->{'member_array'}},$1;\n\n            # the first read in the contig will be named the \"top\" read\n\t    if (!$top) {\n\t\t$self->debug(\"\\$top is not set.\\n\");\n\t\tif ($self->{'contigs'}->{$contig_number}->{'contig_direction'} eq \"C\") {\n\t\t    $self->debug(\"Reversing the order of the reads. The bottom will be $1\\n\");\n\n\t\t    # if the contig sequence is marked as the\n\t\t    # complement, the top becomes the bottom and$\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_name'} = $1;\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_complement'} = $2;\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_start'} = $3;\n\t\t}\n\t\telse {\n\t\t    $self->debug(\"NOT reversing the order of the reads. \".\n                                 \"The top_name will be $1\\n\");\n\t\t    # if the contig sequence is marked as the\n\t\t    # complement, the top becomes the bottom and$\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_name'} = $1;\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_complement'} = $2;\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_start'} = $3;\n\t\t}\n\t\t$top = 1;\n\t    }\n\t    else {\n\n\t\t# if the contig sequence is marked as the complement,\n\t\t# the top becomes the bottom and the bottom becomes\n\t\t# the top\n\t\tif ($self->{'contigs'}->{$contig_number}->{'contig_direction'} eq \"C\") {\n\t\t    $self->debug(\"Reversing the order of the reads. The top will be $1\\n\");\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_name'} = $1;\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_complement'} = $2;\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_start'} = $3;\n\t\t}\n\t\telse {\n\t\t    $self->debug(\"NOT reversing the order of the reads. The bottom will be $1\\n\");\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_name'} = $1;\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_complement'} = $2;\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_start'} = $3;\n\t\t}\n\t\t$top = undef;\n\t    }\n\t}\n    }\n    return 0;\n}\n\n=head2 set_reverse_designator($some_string)\n\n Title   : set_reverse_designator($some_string)\n Usage   : $o_consed->set_reverse_designator($some_string);\n Function: Set the designator for the reverse read of contigs in this\n\t   Bio::Tools::Alignment::Consed object. Used to determine if\n           contigs containing two reads can be named.\n Returns : The value of $o_consed->{reverse_designator} so you can check\n\t   to see that it was set properly.\n Args    : An arbitrary string.\n\nMay be useful only to me. I<shrug>\n\n\nsub set_reverse_designator {\n    my ($self,$reverse_designator) = @_;\n    $self->{'reverse_designator'} = $reverse_designator;\n    $self->{'o_trim'}->set_reverse_designator($reverse_designator);\n    return $self->{'reverse_designator'};\n}\t\t\t\t# end set_reverse_designator\n\n=head2 set_forward_designator($some_string)\n\n Title   : set_forward_designator($some_string)\n Usage   : $o_consed->set_forward_designator($some_string);\n Function: Set the designator for the forward read of contigs in this\n\t   Bio::Tools::Alignment::Consed object. Used to determine if\n           contigs containing two reads can be named.\n Returns : The value of $o_consed->{forward_designator} so you can check\n\t   to see that it was set properly.\n Args    : An arbitrary string.\n\nMay be useful only to me. I<shrug>\n\n\nsub set_forward_designator {\n    my ($self,$forward_designator) = @_;\n    $self->{'forward_designator'} = $forward_designator;\n    $self->{'o_trim'}->set_forward_designator($forward_designator);\n    return $self->{'forward_designator'};\n}\t\t\t\t# end set_forward_designator\n\n=head2 set_designator_ignore_case(\"yes\")\n\n Title   : set_designator_ignore_case(\"yes\")\n Usage   : $o_consed->set_designator_ignore_case(\"yes\");\n Function: Deprecated.\n Returns : Deprecated.\n Args    : Deprecated.\n\nDeprecated. Really. Trust me.\n\n\nsub set_designator_ignore_case {\n    my ($self,$ignore_case) = @_;\n    if ($ignore_case eq \"yes\") {\n\t$self->{'designator_ignore_case'} = 1;\n    }\n    return $self->{'designator_ignore_case'};\n}\t\t\t\t# end set_designator_ignore_case\n\n=head2 set_trim_points_singlets_and_singletons()\n\n Title   : set_trim_points_singlets_and_singletons()\n Usage   : $o_consed->set_trim_points_singlets_and_singletons();\n Function: Set the trim points for singlets and singletons based on\n\t   quality.  Uses the Bio::Tools::Alignment::Trim object. Use\n\t   at your own risk because the Bio::Tools::Alignment::Trim\n\t   object was designed specifically for me and is mysterious\n\t   in its ways. Every time somebody other then me uses it a\n\t   swarm of locusts decends on a small Central American\n\t   village so do not say you weren't warned.\n Returns : Nothing.\n Args    : None.\n\nWorking on exceptions and warnings here.\n\nSee L<Bio::Tools::Alignment::Trim> for more information\n\n\n#' to make my emacs happy\n\nsub set_trim_points_singlets_and_singletons {\n    my ($self) = @_;\n    $self->debug(\"Consed.pm : \\$self is $self\\n\");\n    my (@points,$trimmed_sequence);\n    if (!$self->{'doublets_set'}) {\n        $self->debug(\"You need to set the doublets before you use \".\n                     \"set_trim_points_singlets_and_doublets. Doing that now.\");\n\t$self->set_doublets();\n    }\n    foreach (sort keys %{$self->{'contigs'}}) {\n\tif ($self->{'contigs'}->{$_}->{'class'} eq \"singlet\") {\n\t    $self->debug(\"Singlet $_\\n\");\n\t    # this is what Warehouse wants\n\t    #         my ($self,$sequence,$quality,$name) = @_;\n\t    # this is what Bio::Tools::Alignment::Trim::trim_singlet wants:\n\t    # my ($self,$sequence,$quality,$name,$class) = @_;\n\t    # the following several lines are to make the parameter passing legible.\n\t    my ($sequence,$quality,$name,$class);\n\t    $sequence = $self->{'contigs'}->{$_}->{'consensus'};\n\t    if (!$self->{'contigs'}->{$_}->{'quality'}) { $quality = \"unset\"; }\n\t    else { $quality = $self->{'contigs'}->{$_}->{'quality'}; }\n\t    $name = $self->{'contigs'}->{$_}->{'name'};\n\t    $class = $self->{'contigs'}->{$_}->{'class'};\n\t    @points = @{$self->{'o_trim'}->trim_singlet($sequence,$quality,$name,$class)};\n\t    $self->{'contigs'}->{$_}->{'start_point'} = $points[0];\n\t    $self->{'contigs'}->{$_}->{'end_point'} = $points[1];\n\t    $self->{'contigs'}->{$_}->{'sequence_trimmed'} = \n                substr($self->{contigs}->{$_}->{'consensus'},$points[0],$points[1]-$points[0]);\n\t}\n    }\n    $self->debug(\"Bio::Tools::Alignment::Consed::set_trim_points_singlets\".\n                 \"_and_singletons: Done setting the quality trimpoints.\\n\");\n    return;\n}  # end set_trim_points_singlet\n\n=head2 set_trim_points_doublets()\n\n Title   : set_trim_points_doublets()\n Usage   : $o_consed->set_trim_points_doublets();\n Function: Set the trim points for doublets based on quality. Uses the\n\t   Bio::Tools::Alignment::Trim object. Use at your own risk because\n           the Bio::Tools::Alignment::Trim object was designed specifically\n           for me and is mysterious in its ways. Every time somebody other\n           then me uses it you risk a biblical plague being loosed on your\n           city.\n Returns : Nothing.\n Args    : None.\n Notes   : Working on exceptions here.\n\nSee L<Bio::Tools::Alignment::Trim> for more information\n\n\nsub set_trim_points_doublets {\n    my $self = shift;\n    my @points;\n    $self->debug(\"Bio::Tools::Alignment::Consed::set_trim_points_doublets:\".\n                 \" Restoring zeros for doublets.\\n\");\n    # &show_missing_sequence($self);\n    $self->debug(\"Bio::Tools::Alignment::Consed::set_trim_points_doublets:\".\n                 \" Setting doublet trim points.\\n\");\n    foreach (sort keys %{$self->{'contigs'}}) {\n\tif ($self->{'contigs'}->{$_}->{'class'} eq \"doublet\") {\n            # my ($self,$sequence,$quality,$name,$class) = @_;\n            my @quals = split(' ',$self->{'contigs'}->{$_}->{'quality'});\n\n\t    @points = $self->{o_trim}->trim_doublet\n                ($self->{'contigs'}->{$_}->{'consensus'},\n                 $self->{'contigs'}->{$_}->{'quality'},\n                 $self->{'contigs'}->{$_}->{name},\n                 $self->{'contigs'}->{$_}->{'class'});\n\t    $self->{'contigs'}->{$_}->{'start_point'} = $points[0];\n\t    $self->{'contigs'}->{$_}->{'end_point'} = $points[1];\n            # now set this\n\t    $self->{'contigs'}->{$_}->{'sequence_trimmed'} =\n                substr($self->{contigs}->{$_}->{'consensus'},\n                       $points[0],$points[1]-$points[0]);\n\t    # 010102 the deprecated way to do things:\n\t}\n    }\n    $self->debug(\"Bio::Tools::Alignment::Consed::set_trim_points_doublets:\".\n                 \" Done setting doublet trim points.\\n\"); \n    return;\n} # end set_trim_points_doublets\n\n=head2 get_trimmed_sequence_by_name($name)\n\n Title   : get_trimmed_sequence_by_name($name)\n Usage   : $o_consed->get_trimmed_sequence_by_name($name);\n Function: Returns the trimmed_sequence of a contig with {name} eq $name.\n Returns : A scalar- the trimmed sequence.\n Args    : The {name} of a contig.\n Notes   : \n\n\nsub get_trimmed_sequence_by_name {\n    my ($self,$name) = @_;\n    my $trimmed_sequence;\n    my $contigname = &get_contig_number_by_name($self,$name);\n    my $class = $self->{'contigs'}->{$contigname}->{'class'};\n    # what is this business and who was smoking crack while writing this?\n    # if ($class eq \"singlet\") {\n    # send the sequence, the quality, and the name\n    # $trimmed_sequence = $self->{o_trim}->trim_singlet\n    #  ($self->{'contigs'}->{$contigname}->{consensus},\n    #   $self->{'contigs'}->{$contigname}->{'quality'},$name);\n    # }\n    return $self->{'contigs'}->{$contigname}->{'sequence_trimmed'};\n}\n\n=head2 set_dash_present_in_sequence_name(\"yes\")\n\n Title   : set_dash_present_in_sequence_name(\"yes\")\n Usage   : $o_consed->set_dash_present_in_sequence_name(\"yes\");\n Function: Deprecated. Part of an uncompleted thought. (\"Oooh! Shiny!\")\n Returns : Nothing.\n Args    : \"yes\" to set {dash_present_in_sequence_name} to 1\n Notes   : \n\n\nsub set_dash_present_in_sequence_name {\n    my ($self,$dash_present) = @_;\n    if ($dash_present eq \"yes\") {\n\t$self->{'dash_present_in_sequence_name'} = 1;\n    }\n    else {\n\t$self->{'dash_present_in_sequence_name'} = 0;\n    }\n    return $self->{'dash_present_in_sequence_name'};\n} # end set_dash_present_in_sequence_name\n\n=head2 set_doublets()\n\n Title   : set_doublets()\n Usage   : $o_consed->set_doublets();\n Function: Find pairs that have similar names and mark them as doublets\n\t   and set the {name}.\n Returns : 0 or 1.\n Args    : None.\n\nA complicated subroutine that iterates over the\nBio::Tools::Alignment::Consed looking for contigs of 2. If the forward\nand reverse designator are removed from each of the reads in\n{'member_array'} and the remaining reads are the same, {name} is set\nto that name and the contig's class is set as \"doublet\".  If any of\nthose cases fail the contig is marked as a \"pair\".\n\n\n#' make my emacs happy\n\nsub set_doublets {\n    my ($self) = @_;\n    # set the designators in the Bio::Tools::Alignment::Trim object\n\n    $self->{'o_trim'}->set_designators($self->{'reverse_designator'},\n\t\t\t\t       $self->{'forward_designator'});\n    foreach my $key_contig (sort keys %{$self->{'contigs'}}) {\n\n\t# if there is a member array (why would there not be? This should be a die()able offence\n\t# but for now I will leave it\n\tif ($self->{'contigs'}->{$key_contig}->{'member_array'}) {\n\t    # if there are two reads in this contig \n\t    # i am pretty sure that this is wrong but i am keeping it for reference\n\t    # if (@{$self->{'contigs'}->{$key_contig}->{'member_array'}} == 2 || !$self->{'contigs'}->{$key_contig}->{'class'}) {\n\t    # <seconds later>\n\t    # <nod> WRONG. Was I on crack?\n\t    if (@{$self->{'contigs'}->{$key_contig}->{'member_array'}} == 2) {\n\t\t$self->{'contigs'}->{$key_contig}->{'num_members'} = 2;\n\t\t$self->debug(\"\\tThere are 2 members! Looking for the contig name...\\n\");\n\t\tmy $name = _get_contig_name($self,$self->{'contigs'}->{$key_contig}->{'member_array'});\n\t\t$self->debug(\"The name is $name\\n\") if defined $name;\n\t\tif ($name) {\n\t\t    $self->{'contigs'}->{$key_contig}->{'name'} = $name;\n\t\t    $self->{'contigs'}->{$key_contig}->{'class'} = \"doublet\";\n\t\t} else {\n\t\t    $self->debug(\"$key_contig is a pair.\\n\");\n\t\t    $self->{'contigs'}->{$key_contig}->{'class'} = \"pair\";\n\t\t}\n\t    }\n            # this is all fair and good but what about singlets?\n            # they have one reads in the member_array but certainly are not singletons\n\t    elsif (@{$self->{'contigs'}->{$key_contig}->{'member_array'}} == 1) {\n\t\t# set the name to be the name of the read\n\t\t$self->{'contigs'}->{$key_contig}->{name} = @{$self->{'contigs'}->{$key_contig}->{'member_array'}}[0];\n\t\t# set the number of members to be one\n\t\t$self->{'contigs'}->{$key_contig}->{num_members} = 1;\n\t\t# if this was a singlet, it would already belong to the class \"singlet\"\n\t\t# so leave it alone\n\t\t# if it is not a singlet, it is a singleton! lablel it appropriately\n\t\tunless ($self->{'contigs'}->{$key_contig}->{'class'}) {\n\t\t    $self->{'contigs'}->{$key_contig}->{'class'} = \"singleton\";\n\t\t}\n\t    }\n            # set the multiplet characteristics\n\t    elsif (@{$self->{'contigs'}->{$key_contig}->{'member_array'}} >= 3) {\n\t\t$self->{'contigs'}->{$key_contig}->{'num_members'} = @{$self->{'contigs'}->{$key_contig}->{'member_array'}};\n\t\t$self->{'contigs'}->{$key_contig}->{'class'} = \"multiplet\";\n\t    }\n\t    $self->{'contigs'}->{$key_contig}->{'num_members'} = @{$self->{'contigs'}->{$key_contig}->{'member_array'}};\n\n\t}\n    }\n    $self->{'doublets_set'} = \"done\";\n    return 0;\n}\t\t\t\t# end set_doublets\n\n=head2 set_singlets\n\n Title   : set_singlets\n Usage   : $o_consed->set_singlets();\n Function: Read in a singlets file and place them into the\n\t   Bio::Tools::Alignment::Consed object.\n Returns : Nothing.\n Args    : A scalar to turn on verbose parsing of the singlets file.\n Notes   : \n\n\nsub set_singlets {\n    # parse out the contents of the singlets file\n    my ($self) = @_;\n    $self->debug(\"Bio::Tools::Alignment::Consed Adding singlets to the contig hash...\\n\"); \n    my $full_filename = $self->{'filename'};\n    $self->debug(\"Bio::Tools::Alignment::Consed::set_singlets: \\$full_filename is $full_filename\\n\");\n    $full_filename =~ m/(.*\\/)(.*ace.*)$/; \t\t\t       \n    my ($base_path,$filename) = ($1,$2);\n    $self->debug(\"Bio::Tools::Alignment::Consed::set_singlets: singlets filename is $filename and \\$base_path is $base_path\\n\");\n    $filename =~ m/(.*)ace.*$/;\n    my $singletsfile = $base_path.$1.\"singlets\";\n    $self->debug(\"\\$singletsfile is $singletsfile\\n\");\n     if (!-f $singletsfile) {\n          # there is no singlets file.\n          $self->{'singlets_set'} = \"done\";\n          return;\n     }\n\t$self->debug(\"$singletsfile is indeed a file. Trying to open it...\\n\");\n    my $singlets_fh = Bio::Root::IO->new(-file => $singletsfile);\n    my ($sequence,$name,$count);\n    while ($_ = $singlets_fh->_readline()) {\n\tchomp $_;\n\tif (/\\>/) {\n\t    if ($name && $sequence) {\n\t\t$self->debug(\"Adding $name with sequence $sequence to hash...\\n\");\n\t\tpush @{$self->{'contigs'}->{$name}->{'member_array'}},$name;\n\t\t$self->{'contigs'}->{$name}->{'consensus'} = $sequence;\n\t\t$self->{'contigs'}->{$name}->{'name'} = $name;\n\t\t$self->{'contigs'}->{$name}->{\"singlet\"} = 1;\n\t\t$self->{'contigs'}->{$name}->{'class'} = \"singlet\";\n\t    }\n\t    $sequence = $name = undef;\n\t    $count++;\n\t    m/^\\>(.*)\\s\\sCHROMAT/;\n\t    $name = $1;\n\t    if (!$name) {\n\t\tm/\\>(\\S+)\\s/;\n\t\t$name = $1;\n\t    }\n\t}\n\telse { $sequence .= $_; }\t\n    }\n    if ($name && $sequence) {\n\t$self->debug(\"Pushing the last of the singlets ($name)\\n\");\n\t@{$self->{'contigs'}->{$name}->{'member_array'}} = $name;\n\t$self->{'contigs'}->{$name}->{'consensus'} = $sequence;\n\t$self->{'contigs'}->{$name}->{'name'} = $name;\n\t$self->{'contigs'}->{$name}->{\"singlet\"} = 1;\n\t$self->{'contigs'}->{$name}->{'class'} = \"singlet\";\n    }\n    $self->debug(\"Bio::Tools::Alignment::Consed::set_singlets: Done adding singlets to the singlets hash.\\n\");\n    $self->{'singlets_set'} = \"done\";\n    return 0;\n}\t\t\t\t# end sub set_singlets\n\n=head2 get_singlets()\n\n Title   : get_singlets()\n Usage   : $o_consed->get_singlets();\n Function: Return the keynames of the singlets.\n Returns : An array containing the keynames of all \n           Bio::Tools::Alignment::Consed sequences in the class \"singlet\".\n Args    : None.\n Notes   : \n\n\nsub get_singlets {\n    # returns an array of singlet names\n    # singlets have \"singlet\"=1 in the hash\n    my $self = shift;\n    if (!$self->{singlets_set}) {\n\t$self->debug(\"You need to set the singlets before you get them. Doing that now.\");\n\t$self->set_singlets();\n    }\t\n\n    my (@singlets,@array);\n    foreach my $key (sort keys %{$self->{'contigs'}}) {\n\t# @array = @{$Consed::contigs{$key}->{'member_array'}};\n\t# somethimes a user will try to get a list of singlets before the classes for the rest of the\n\t# contigs has been set (see t/test.t for how I figured this out. <bah>\t\t\t\n\t# so either way, just return class=singlets\n\tif (!$self->{'contigs'}->{$key}->{'class'}) {\n\t    # print(\"$key has no class. why?\\n\");\n\t}\n\telsif ($self->{'contigs'}->{$key}->{'class'} eq \"singlet\") {\n\t    push @singlets,$key;\n\t}\n    }\n    return @singlets;\n}\n\n=head2 set_quality_by_name($name,$quality)\n\n Title   : set_quality_by_name($name,$quality)\n Usage   : $o_consed->set_quality_by_name($name,$quality);\n Function: Deprecated. Make the contig with {name} have {'quality'} $quality.\n           Probably used for testing.\n Returns : Nothing.\n Args    : The name of a contig and a scalar for its quality.\n Notes   : Deprecated.\n\n\nsub set_quality_by_name {\n    # this is likely deprecated\n    my ($self,$name,$quality) = shift;\n    my $return;\n    foreach (sort keys %{$self->{'contigs'}}) {\n\tif ($self->{'contigs'} eq \"$name\" || $self->{'contigs'}->{'name'} eq \"$name\") {\n\t    $self->{'contigs'}->{'quality'} = $quality;\n\t    $return=1;\n\t}\n    }\n    if ($return) { return \"0\"; } else { return \"1\"; }\n}\t\t\t\t# end set quality by name\n\n=head2 set_singlet_quality()\n\n Title   : set_singlet_quality()\n Usage   : $o_consed->set_singlet_quality();\n Function: For each singlet, go to the appropriate file in phd_dir and read\n           in the phred quality for that read and place it into {'quality'}\n Returns : 0 or 1.\n Args    : None.\n Notes   : This is the next subroutine that will receive substantial revision\n           in the next little while. It really should eval the creation of\n           Bio::Tools::Alignment::Phred objects and go from there. \n\n\nsub set_singlet_quality {\n    my $self = shift;\n    my $full_filename = $self->{'filename'};\n    $full_filename =~ m/(.*\\/)(.*)ace.*$/;\n    my ($base_path,$filename) = ($1,\"$2\".\"qual\");\n    my $singletsfile = $base_path.$filename;\n    if (-f $singletsfile) {\n\t# print(\"$singletsfile is indeed a file. Trying to open it...\\n\");\n    }\n    else {\n\t$self->warn(\"$singletsfile is not a file. Sorry.\\n\");\n\treturn;\n    }\n\tmy $singlets_fh = Bio::Root::IO->new(-file => $singletsfile);\n\tmy ($sequence,$name,$count);\n    my ($identity,$line,$quality,@qline);\n    while ($line = $singlets_fh->_readline()) {\n\tchomp $line;\n\tif ($line =~ /^\\>/) {\n\t    $quality = undef;\n\t    $line =~ m/\\>(\\S*)\\s/;\n\t    $identity = $1;\n\t}\n\telse {\n\t    if ($self->{'contigs'}->{$identity}) {\n\t\t$self->{'contigs'}->{$identity}->{'quality'} .= \"$line \";\n\t    }\n\t}\n\n    }\n    return 0;\n}\n\n=head2 set_contig_quality()\n\n Title   : set_contig_quality()\n Usage   : $o_consed->set_contig_quality();\n Function: Deprecated.\n Returns : Deprecated.\n Args    : Deprecated.\n Notes   : Deprecated. Really. Trust me.\n\n\nsub set_contig_quality {\n    # note: contigs _include_ singletons but _not_ singlets\n    my ($self) = shift;\n          # the unexpected results I am referring to here are a doubling of quality values.\n          # the profanity I uttered on discovering this reminded me of the simpsons:\n          # Ned Flanders: \"That is the loudest profanity I have ever heard!\"\n     $self->warn(\"set_contig_quality is deprecated and will likely produce unexpected results\");\n    my $full_filename = $self->{'filename'};\n    # Run_SRC3700_2000-08-01_73+74.fasta.screen.contigs.qual\n    # from Consed.pm\n    $full_filename =~ m/(.*\\/)(.*)ace.*$/;\n    my ($base_path,$filename) = ($1,\"$2\".\"contigs.qual\");\n    my $singletsfile = $base_path.$filename;\n    if (-f $singletsfile) {\n\t# print(\"$singletsfile is indeed a file. Trying to open it...\\n\");\n    }\n    else {\n\t$self->warn(\"Bio::Tools::Alignment::Consed::set_contig_quality $singletsfile is not a file. Sorry.\\n\");\n\treturn;\n    }\n    my $contig_quality_fh = Bio::Root::IO->new(-file => $singletsfile);\n\n    my ($sequence,$name,$count,$identity,$line,$quality);\n    while ($line = $contig_quality_fh->_readline()) {\n\tchomp $line;\n\tif ($line =~ /^\\>/) {\n\t    $quality = undef;\n\t    $line =~ m/\\>.*Contig(\\d+)\\s/;\n\t    $identity = $1;\n\t}\n\telse {\n\t    if ($self->{'contigs'}->{$identity} ) {\n\t\t$self->{'contigs'}->{$identity}->{'quality'} .= \" $line\";\n\t    }\n\t}\n    }\n}\t\t\t\t# end set_contig_quality\n\n=head2 get_multiplets()\n\n Title   : get_multiplets()\n Usage   : $o_consed->get_multiplets();\n Function: Return the keynames of the multiplets.\n Returns : Returns an array containing the keynames of all \n           Bio::Tools::Alignment::Consed sequences in the class \"multiplet\".\n Args    : None.\n Notes   : \n\n\nsub get_multiplets {\n\t    # returns an array of multiplet names\n\t    # multiplets have # members > 2\n    my $self = shift;\n    my (@multiplets,@array);\n    foreach my $key (sort keys %{$self->{'contigs'}}) {\n\tif ($self->{'contigs'}->{$key}->{'class'}) {\n\t    if ($self->{'contigs'}->{$key}->{'class'} eq \"multiplet\") {\n\t\tpush @multiplets,$key;\n\t    }\n\t}\n    }\n    return @multiplets;\n}\n\n=head2 get_all_members()\n\n  Title   : get_all_members()\n  Usage   : @all_members = $o_consed->get_all_members();\n  Function: Return a list of all of the read names in the \n            Bio::Tools::Alignment::Consed object.\n  Returns : An array containing all of the elements in all of the\n            {'member_array'}s.\n  Args    : None.\n  Notes   : \n\n\nsub get_all_members {\n    my $self = shift;\n    my @members;\n    foreach my $key (sort keys %{$self->{'contigs'}}) {\n\tif ($key =~ /^singlet/) {\n\t    push @members,$self->{'contigs'}->{$key}->{'member_array'}[0];\n\t}\n\telsif ($self->{'contigs'}->{$key}->{'member_array'}) {\n\t    push @members,@{$self->{'contigs'}->{$key}->{'member_array'}};\n\t}\n\t# else {\n\t#\tprint(\"Bio::Tools::Alignment::Consed: $key is _not_ an array. Pushing $self->{'contigs'}->{$key}->{'member_array'} onto \\@members\\n\");\n\t#\tpush @members,$self->{'contigs'}->{$key}->{'member_array'};\n\t# }\n    }\n    return @members;\n}\n\n=head2 sum_lets($total_only)\n\n Title   : sum_lets($total_only)\n Usage   : $statistics = $o_consed->sum_lets($total_only);\n Function: Provide numbers for how many sequences were accounted for in the\n           Bio::Tools::Alignment::Consed object.\n Returns : If a scalar is present, returns the total number of\n           sequences accounted for in all classes. If no scalar passed\n           then returns a string that looks like this:\n           Singt/singn/doub/pair/mult/total : 2,0,1(2),0(0),0(0),4\n           This example means the following: There were 1 singlets.\n           There were 0 singletons.  There were 1 doublets for a total\n           of 2 sequences in this class.  There were 0 pairs for a\n           total of 0 sequences in this class.  There were 0\n           multiplets for a total of 0 sequences in this class.  There\n           were a total of 4 sequences accounted for in the\n           Bio::Tools::Alignment::Consed object.   \n Args : A scalar is optional to change the way the numbers are returned.  \n Notes:\n\n\nsub sum_lets {\n    my ($self,$total_only) = @_;\n    my ($count,$count_multiplets,$multiplet_count);\n    my $singlets = &get_singlets($self); $count += $singlets;\n    my $doublets = &get_doublets($self); $count += ($doublets * 2);\n    my $pairs = &get_pairs($self); $count += ($pairs * 2);\n    my $singletons = &get_singletons($self); $count += $singletons;\n    my @multiplets = &get_multiplets($self);\n    $count_multiplets = @multiplets;\n    my $return_string;\n    foreach (@multiplets) {\n\tmy $number_members = $self->{'contigs'}->{$_}->{num_members};\t\n\t$multiplet_count += $number_members;\n    }\n    if ($multiplet_count) {\n\t$count += $multiplet_count;\n    }\n    foreach (qw(multiplet_count singlets doublets pairs singletons\n                multiplets count_multiplets)) {\n\tno strict 'refs';\t# renege for the block\n\tif (!${$_}) {\n            ${$_} = 0;\n\t}\n    }\n    if (!$multiplet_count) { $multiplet_count = 0; }\n    if ($total_only) {\n        return $count;\n    }\n    $return_string = \"Singt/singn/doub/pair/mult/total : \".\n        \"$singlets,$singletons,$doublets(\".\n         ($doublets*2).\"),$pairs(\".($pairs*2).\n        \"),$count_multiplets($multiplet_count),$count\";\n    return $return_string;\n}\n\n=head2 write_stats()\n\n Title   : write_stats()\n Usage   : $o_consed->write_stats();\n Function: Write a file called \"statistics\" containing numbers similar to\n\t   those provided in sum_lets().\n Returns : Nothing. Write a file in $o_consed->{path} containing something\n\t   like this:\n\n           0,0,50(100),0(0),0(0),100\n\n           Where the numbers provided are in the format described in the\n\t   documentation for sum_lets().\n Args    : None.\n Notes   : This might break platform independence, I do not know.\n\nSee L<sum_lets()|sum_lets>\n\n\nsub write_stats {\n    # worry about platform dependence here?\n    # oh shucksdarn.\n    my $self = shift;\n    my $stats_filename = $self->{'path'}.\"statistics\";\n    my $statistics_raw = $self->sum_lets;\n    my ($statsfilecontents) = $statistics_raw =~ s/.*\\ \\:\\ //g;\n    umask 0001;\n    my $fh = Bio::Root::IO->new(-file=>\"$stats_filename\");\n    # open(STATSFILE,\">$stats_filename\") or print(\"Could not open the statsfile: $!\\n\");\n    $fh->_print(\"$statsfilecontents\");\n    # close STATSFILE;\n    $fh->close();\n}\n\n=head2 get_singletons()\n\n Title   : get_singletons()\n Usage   : @singletons = $o_consed->get_singletons();\n Function: Return the keynames of the singletons.\n Returns : Returns an array containing the keynames of all\n\t   Bio::Tools::Alignment::Consed sequences in the class \"singleton\".\n Args    : None.\n Notes   : \n\n\nsub get_singletons {\n\t\t# returns an array of singleton names\n\t\t# singletons are contigs with one member (see consed documentation)\n\tmy $self = shift;\n\tmy (@singletons,@array);\n\tforeach my $key (sort keys %{$self->{'contigs'}}) {\n\t\tif ($self->{'contigs'}->{$key}->{'class'}) {\n\t\t    # print (\"$key class: $self->{'contigs'}->{$key}->{'class'}\\n\");\n\t\t}\n\t\telse {\n\t\t    # print(\"$key belongs to no class. why?\\n\");\n\t\t}\n\t\tif ($self->{'contigs'}->{$key}->{'member_array'}) {\n\t\t\t@array = @{$self->{'contigs'}->{$key}->{'member_array'}};\n\t\t}\n\t\tmy $num_array_elem = @array;\n\t\tif ($num_array_elem == 1 && $self->{'contigs'}->{$key}->{'class'} && $self->{'contigs'}->{$key}->{'class'} eq \"singleton\") { push @singletons,$key; }\n\t}\n\treturn @singletons;\n}\n\n=head2 get_pairs()\n\n Title   : get_pairs()\n Usage   : @pairs = $o_consed->get_pairs();\n Function: Return the keynames of the pairs.\n Returns : Returns an array containing the keynames of all\n           Bio::Tools::Alignment::Consed sequences in the class \"pair\".\n Args    : None.\n Notes   : \n\n\nsub get_pairs {\n    # returns an array of pair contig names\n    # a pair is a contig of two where the names do not match\n    my $self = shift;\n    my (@pairs,@array);\n    foreach my $key (sort keys %{$self->{'contigs'}}) {\n        if ($self->{'contigs'}->{$key}->{'member_array'}) {\n            if (@{$self->{'contigs'}->{$key}->{'member_array'}} == 2 &&\n                $self->{'contigs'}->{$key}->{'class'} eq \"pair\") {\n                push @pairs,$key;\n            }\n        }\n    }\n    return @pairs;\n}\n\n=head2 get_name($contig_keyname)\n\n Title   : get_name($contig_keyname)\n Usage   : $name = $o_consed->get_name($contig_keyname);\n Function: Return the {name} for $contig_keyname.\n Returns : A string. ({name})\n Args    : A contig keyname.\n Notes   : \n\n\nsub get_name {\n    my ($self,$contig) = @_;\n    return $self->{'contigs'}->{$contig}->{'name'};\n}\n\n=head2 _get_contig_name(\\@array_containing_reads)\n\n Title   : _get_contig_name(\\@array_containing_reads)\n Usage   : $o_consed->_get_contig_name(\\@array_containing_reads);\n Function: The logic for the set_doublets subroutine.\n Returns : The name for this contig.\n Args    : A reference to an array containing read names.\n Notes   : Depends on reverse_designator. Be sure this is set the way you\n\t   intend.\n\n\nsub _get_contig_name {\n    my ($self,$r_array) = @_;\n    my @contig_members = @$r_array;\n    my @name_nodir;\n    foreach (@contig_members) {\n        # how can I distinguish the clone name from the direction label?\n        # look for $Consed::reverse_designator and $Consed::forward_designator\n        # what if you do not find _any_ of those?\n        my $forward_designator = $self->{'forward_designator'} || \"f\";\n        my $reverse_designator = $self->{'reverse_designator'} || \"r\";\n        my $any_hits = /(.+)($forward_designator.*)/ || /(.+)($reverse_designator.*)/||/(.+)(_.+)/;\n        my $name = $1;\n        my $suffix = $2;\n        if ($name) {\n            # print(\"\\t\\$name is $name \");\n        }\n        if ($suffix) {\n            # print(\"and \\$suffix is $suffix.\\n\");\n        }\n                                # Jee, I hope we get a naming convention soon\n        if ($suffix) {\n            if ($suffix =~ /^$forward_designator/ || $suffix =~ /^$reverse_designator/) {\n                push @name_nodir,$name;\n            }\n\t\t\t\t# bugwatch here! should this be unnested?\n            else {\n                push @name_nodir,\"$name$suffix\";\n            }\n        }\n    }\n    # print(\"\\@name_nodir: @name_nodir\\n\");\n    my $mismatch = 0;\n    for (my $counter=0; $counter<@name_nodir;$counter++) {\n        next if ($name_nodir[0] eq $name_nodir[$counter]);\n        $mismatch = 1;\n    }\n    if ($mismatch == 0) {\n        # print(\"\\tYou have a cohesive contig named $name_nodir[0].\\n\\n\");\n        return $name_nodir[0];\n    } else {\n        # print(\"\\tYou have mixed names in this contig.\\n\\n\");\n    }\n}                               # end _get_contig_name\n\n=head2 get_doublets()\n\n Title   : get_doublets()\n Usage   : @doublets = $o_consed->get_doublets();\n Function: Return the keynames of the doublets.\n Returns : Returns an array containing the keynames of all\n           Bio::Tools::Alignment::Consed sequences in the class \"doublet\".\n Args    : None.\n Notes   : \n\n\nsub get_doublets {\n    my $self = shift;\n    if (!$self->{doublets_set}) {\n        $self->warn(\"You need to set the doublets before you can get them. Doing that now.\");\n        $self->set_doublets();\n    }\n    my @doublets;\n    foreach (sort keys %{$self->{'contigs'}}) {\n        if ($self->{'contigs'}->{$_}->{name} && $self->{'contigs'}->{$_}->{'class'} eq \"doublet\") {\n            push @doublets,$_;\n        }\n    }\n    return @doublets;\n}                               # end get_doublets\n\n=head2 dump_hash()\n\n Title   : dump_hash()\n Usage   : $o_consed->dump_hash();\n Function: Use dumpvar.pl to dump out the Bio::Tools::Alignment::Consed\n           object to STDOUT.\n Returns : Nothing.\n Args    : None.\n Notes   : I used this a lot in debugging.\n\n\nsub dump_hash {\n    my $self = shift;\n    my $dumper = new Dumpvalue;\n    $self->debug( \"Bio::Tools::Alignment::Consed::dump_hash - \".\n                  \"The following is the contents of the contig hash...\\n\");\n    $dumper->dumpValue($self->{'contigs'});\n}\n\n=head2 dump_hash_compact()\n\n Title   : dump_hash_compact()\n Usage   : $o_consed->dump_hash_compact();\n Function: Dump out the Bio::Tools::Alignment::Consed object in a compact way.\n Returns : Nothing.\n Args    : Nothing.\n Notes   : Cleaner then dumpValue(), dumpHash(). I used this a lot in\n           debugging.\n\n\nsub dump_hash_compact {\n    no strict 'refs';           # renege for the block\n    my ($self,$sequence) = @_;\n    # get the classes\n    my @singlets = $self->get_singlets();\n    my @singletons = $self->get_singletons();\n    my @doublets = $self->get_doublets();\n    my @pairs = $self->get_pairs();\n    my @multiplets = $self->get_multiplets();\n    print(\"Name\\tClass\\tMembers\\tQuality?\\n\");\n    foreach (@singlets) {\n        my @members = $self->get_members($_);\n        print($self->get_name($_).\"\\tsinglets\\t\".(join',',@members).\"\\t\");\n        if ($self->{'contigs'}->{$_}->{'quality'}) {\n            print(\"qualities found here\\n\");\n        } else {\n            print(\"no qualities found here\\n\");\n        }\n\n    }\n    foreach (@singletons) {\n        my @members = $self->get_members($_);\n        print($self->get_name($_).\"\\tsingletons\\t\".(join',',@members).\"\\t\");\n        if ($self->{'contigs'}->{$_}->{'quality'}) {\n            print(\"qualities found here\\n\");\n        } else {\n            print(\"no qualities found here\\n\");\n        }\n    }\n    foreach my $pair (@pairs) {\n        my @members = $self->get_members($pair);\n        my $name;\n        if (!$self->get_name($pair)) {\n            $name = \"BLANK\";\n        } else {\n            $name = $self->get_name($pair);\n        }\n        print(\"$name\\tpairs\\t\".(join',',@members).\"\\n\");\n    }\n    foreach (@doublets) {\n        my @members = $self->get_members_by_name($_);\n        print(\"$_\\tdoublets\\t\".(join',',@members).\"\\t\");\n        my $contig_number = &get_contig_number_by_name($self,$_);\n        if ($self->{'contigs'}->{$contig_number}->{'quality'}) {\n            print(\"qualities found here\\n\");\n        } else {\n            print(\"no qualities found here\\n\");\n        }\n        # print($_.\"\\tdoublets\\t\".(join',',@members).\"\\n\");\n    }\n    foreach (@multiplets) {\n        my @members = $self->get_members($_);\n        print(\"Contig $_\".\"\\tmultiplets\\t\".(join',',@members).\"\\n\");\n    }\n}                               # end dump_hash_compact\n\n=head2 get_phreds()\n\n Title   : get_phreds()\n Usage   : @phreds = $o_consed->get_phreds();\n Function: For each doublet in the Bio::Tools::Alignment::Consed hash, go\n           and get the phreds for the top and bottom reads. Place them into\n           {top_phreds} and {bottom_phreds}.\n Returns : Nothing.\n Args    : Nothing.\n\nRequires parse_phd() and reverse_and_complement(). I realize that it\nwould be much more elegant to pull qualities as required but there\nwere certain \"features\" in the acefile that required a bit more\ndetailed work be done to get the qualities for certain parts of the\nconsensus sequence. In order to make _sure_ that this was done\nproperly I wrote things to do all steps and then I used dump_hash()\nand checked each one to ensure expected bahavior. I have never changed\nthis, so there you are.\n\n\nsub get_phreds {\n    # this subroutine is the target of a rewrite to use the Bio::Tools::Alignment::Phred object.\n    my $self = shift;    \n    my $current_contig;\n    foreach $current_contig (sort keys %{$self->{'contigs'}}) {\t\n\tif ($self->{'contigs'}->{$current_contig}->{'class'} eq \"doublet\") {\n\t    $self->debug(\"$current_contig is a doublet. Going to parse_phd for top($self->{'contigs'}->{$current_contig}->{'top_name'}) and bottom($self->{'contigs'}->{$current_contig}->{'bottom_name'})\\n\");\n\t    my $r_phreds_top = &parse_phd($self,$self->{'contigs'}->{$current_contig}->{'top_name'});\n\t    my $r_phreds_bottom = &parse_phd($self,$self->{'contigs'}->{$current_contig}->{'bottom_name'});\n\t    if ($self->{'contigs'}->{$current_contig}->{'top_complement'} eq \"C\") {\n\t\t# print(\"Reversing and complementing...\\n\");\n\t\t$r_phreds_top = &reverse_and_complement($r_phreds_top);\n\t    }\n\t    if ($self->{'contigs'}->{$current_contig}->{'bottom_complement'} eq \"C\") {\n\t\t$r_phreds_bottom = &reverse_and_complement($r_phreds_bottom);\n\t    }\n\t    $self->{'contigs'}->{$current_contig}->{'top_phreds'} = $r_phreds_top;\n\t    $self->{'contigs'}->{$current_contig}->{'bottom_phreds'} = $r_phreds_bottom;\n\t}\n    }\n}\n\n=head2 parse_phd($read_name)\n\n Title   : parse_phd($read_name)\n Usage   : $o_consed->parse_phd($read_name);\n Function: Suck in the contents of a .phd file.\n Returns : A reference to an array containing the quality values for the read.\n Args    : The name of a read.\n Notes   : This is a significantly weak subroutine because it was always\n\t   intended that these functions, along with the functions provided by\n\t   get_phreds() be put into the Bio::SeqIO:phd module. This is done\n           now but the Bio::Tools::Alignment::Consed module has not be\n           rewritten to reflect this change.\n\nSee L<Bio::SeqIO::phd> for more information.\n\n\nsub parse_phd {\n    my ($self,$sequence_name) = @_;\n    $self->debug(\"Parsing phd for $sequence_name\\n\");\n    my $in_dna = 0;\n    my $base_number = 0;\n    my (@bases,@current_line);\n    # print(\"parse_phd: $sequence_name\\n\");\n    my $fh = Bio::Root::IO->new\n        (-file=>\"$self->{path}/../phd_dir/$sequence_name.phd.1\");\n    while ($fh->_readline()) {\n\t# print(\"Reading a line from a phredfile!\\n\");\n\tchomp;\n\tif (/^BEGIN_DNA/) { $in_dna = 1; next}\n\tif (/^END_DNA/) { last; }\n\tif (!$in_dna) { next; }\n\tpush(@bases,$_);\n    }\n    return \\@bases;\n}\n\n=head2 reverse_and_complement(\\@source)\n\n Title   : reverse_and_complement(\\@source)\n Usage   : $reference_to_array = $o_consed->reverse_and_complement(\\@source);\n Function: A stub for the recursive routine reverse_recurse().\n Returns : A reference to a reversed and complemented array of phred data.\n Args    : A reference to an array of phred data.\n Notes   : \n\n\nsub reverse_and_complement {\n    my $r_source = shift;\n    my $r_destination;\n    $r_destination = &reverse_recurse($r_source,$r_destination);\n    return $r_destination;\n}\n\n=head2 reverse_recurse($r_source,$r_destination)\n\n Title   : reverse_recurse(\\@source,\\@destination)\n Usage   : $o_consed->reverse_recurse(\\@source,\\@destination);\n Function: A recursive routine to reverse and complement an array of\n           phred data.\n Returns : A reference to an array containing reversed phred data.\n Args    : A reference to a source array and a reverence to a destination\n\t   array.\n\nRecursion is kewl, but this sub should likely be _reverse_recurse.\n\n\n\nsub reverse_recurse($$) {\n    my ($r_source,my $r_destination) = @_;\n    if (!@$r_source) {\n        return $r_destination;\n    }\n    $_=pop(@$r_source);\n    s/c/g/ || s/g/c/ || s/a/t/ || s/t/a/;\n    push(@$r_destination,$_);\n    &reverse_recurse($r_source,$r_destination);\n}\n\n=head2 show_missing_sequence()\n\n Title   : show_missing_sequence();\n Usage   : $o_consed->show_missing_sequence();\n Function: Used by set_trim_points_doublets() to fill in quality values where\n\t   consed (phrap?) set them to 0 at the beginning and/or end of the\n\t   consensus sequences.\n Returns : Nothing.\n Args    : None.\n\nActs on doublets only. Really very somewhat quite ugly. A disgusting\nkludge. I<insert pride here> It was written stepwise with no real plan\nbecause it was not really evident why consed (phrap?)  was doing this."},"containerName":"main::","definition":"sub","line":1725,"children":[{"definition":"my","name":"$self","containerName":"show_missing_sequence","localvar":"my","kind":13,"line":1730},{"line":1731,"kind":13,"name":"$self","containerName":"show_missing_sequence"},{"localvar":"my","containerName":"show_missing_sequence","definition":"my","name":"$current_contig","line":1732,"kind":13},{"name":"@qualities","containerName":"show_missing_sequence","kind":13,"line":1732},{"kind":13,"line":1733,"name":"$current_contig","containerName":"show_missing_sequence"},{"line":1733,"kind":13,"name":"$self","containerName":"show_missing_sequence"}],"kind":12},{"kind":13,"line":1734,"containerName":null,"name":"%self"},{"containerName":null,"name":"%current_contig","kind":13,"line":1734},{"line":1735,"kind":13,"localvar":"my","containerName":null,"name":"$number_leading_xs","definition":"my"},{"definition":"my","name":"$number_trailing_xs","containerName":null,"localvar":"my","kind":13,"line":1736},{"localvar":"my","containerName":null,"name":"$measurer","definition":"my","line":1737,"kind":13},{"kind":13,"line":1737,"containerName":null,"name":"%self"},{"name":"%current_contig","containerName":null,"kind":13,"line":1737},{"name":"%measurer","containerName":null,"line":1738,"kind":13},{"kind":13,"line":1739,"name":"$number_leading_xs","containerName":null},{"containerName":null,"name":"%measurer","kind":13,"line":1741},{"name":"$number_trailing_xs","containerName":null,"line":1742,"kind":13},{"line":1744,"kind":13,"name":"@qualities","containerName":null},{"containerName":null,"name":"%self","kind":13,"line":1744},{"kind":13,"line":1744,"containerName":null,"name":"%current_contig"},{"kind":13,"line":1745,"containerName":null,"definition":"my","name":"$in_initial_zeros","localvar":"my"},{"containerName":null,"definition":"my","name":"$count","localvar":"my","kind":13,"line":1746},{"kind":13,"line":1746,"name":"$count","containerName":null},{"line":1746,"kind":13,"containerName":null,"name":"@qualities"},{"containerName":null,"name":"%count","line":1746,"kind":13},{"line":1747,"kind":13,"name":"@qualities","containerName":null},{"kind":13,"line":1747,"name":"%count","containerName":null},{"localvar":"my","containerName":null,"definition":"my","name":"$quality","line":1748,"kind":13},{"name":"$top_phred_position","containerName":null,"line":1748,"kind":13},{"containerName":null,"name":"$bottom_phred_position","kind":13,"line":1748},{"containerName":null,"name":"$top_phred_data","kind":13,"line":1748},{"containerName":null,"name":"$bottom_phred_data","kind":13,"line":1748},{"kind":13,"line":1752,"name":"$top_quality_here","definition":"my","containerName":null,"localvar":"my"},{"line":1752,"kind":13,"name":"%self","containerName":null},{"name":"%current_contig","containerName":null,"line":1752,"kind":13},{"name":"%self","containerName":null,"kind":13,"line":1752},{"containerName":null,"name":"%current_contig","line":1752,"kind":13},{"kind":13,"line":1752,"containerName":null,"name":"$count"},{"kind":13,"line":1753,"containerName":null,"name":"$bottom_quality_here","definition":"my","localvar":"my"},{"name":"%self","containerName":null,"line":1753,"kind":13},{"containerName":null,"name":"%current_contig","line":1753,"kind":13},{"line":1753,"kind":13,"containerName":null,"name":"%self"},{"kind":13,"line":1753,"name":"%current_contig","containerName":null},{"line":1753,"kind":13,"name":"$count","containerName":null},{"line":1754,"kind":13,"name":"$bottom_quality_here","containerName":null},{"containerName":null,"name":"%self","kind":13,"line":1754},{"name":"%current_contig","containerName":null,"line":1754,"kind":13},{"line":1754,"kind":13,"containerName":null,"name":"%count"},{"line":1755,"kind":13,"name":"$bottom_quality_here","containerName":null},{"name":"%top_quality_here","containerName":null,"line":1757,"kind":13},{"line":1758,"kind":13,"containerName":null,"name":"$top_quality_here"},{"line":1761,"kind":13,"containerName":null,"name":"$count"},{"kind":13,"line":1761,"name":"%number_leading_xs","containerName":null},{"line":1764,"kind":13,"localvar":"my","containerName":null,"name":"$quality","definition":"my"},{"line":1764,"kind":13,"name":"$top_quality_here","containerName":null},{"name":"$quality","containerName":null,"kind":13,"line":1765},{"name":"$quality","containerName":null,"kind":13,"line":1766},{"containerName":null,"name":"@qualities","line":1769,"kind":13},{"kind":13,"line":1769,"containerName":null,"name":"$count"},{"name":"%quality","containerName":null,"line":1769,"kind":13},{"kind":13,"line":1790,"name":"%bottom_quality_here","containerName":null},{"containerName":null,"name":"$top_quality_here","line":1795,"kind":13},{"containerName":null,"name":"$quality","kind":13,"line":1796},{"name":"%top_quality_here","containerName":null,"kind":13,"line":1797},{"line":1802,"kind":13,"containerName":null,"name":"$bottom_quality_here"},{"containerName":null,"name":"%quality","kind":13,"line":1803},{"name":"$top_quality_here","containerName":null,"line":1811,"kind":13},{"line":1812,"kind":13,"localvar":"my","name":"$top_quality","definition":"my","containerName":null},{"kind":13,"line":1814,"containerName":null,"name":"$bottom_quality_here"},{"containerName":null,"definition":"my","name":"$bottom_quality","localvar":"my","kind":13,"line":1815},{"kind":13,"line":1818,"name":"$bottom_quality","containerName":null},{"kind":13,"line":1818,"name":"%top_quality","containerName":null},{"line":1820,"kind":13,"containerName":null,"name":"$quality"},{"line":1820,"kind":13,"name":"%bottom_quality","containerName":null},{"line":1823,"kind":13,"name":"$quality","containerName":null},{"containerName":null,"name":"$top_quality","kind":13,"line":1823},{"containerName":null,"name":"%quality","kind":13,"line":1826},{"line":1831,"kind":13,"name":"@qualities","containerName":null},{"name":"$count","containerName":null,"kind":13,"line":1831},{"kind":13,"line":1831,"name":"$quality","containerName":null},{"name":"@qualities","containerName":null,"kind":13,"line":1837},{"name":"%self","containerName":null,"kind":13,"line":1838},{"containerName":null,"name":"%current_contig","line":1838,"kind":13},{"line":1838,"kind":13,"name":"@qualities","containerName":null},{"containerName":null,"name":"%self","line":1840,"kind":13},{"containerName":null,"name":"%current_contig","kind":13,"line":1840},{"name":"%self","containerName":null,"kind":13,"line":1841},{"containerName":null,"name":"%current_contig","kind":13,"line":1841},{"kind":13,"line":1842,"containerName":null,"name":"$count","definition":"my","localvar":"my"}],"version":5}