{"vars":[{"name":"base","containerName":"","kind":2,"line":86},{"definition":"sub","containerName":"main::","signature":{"documentation":"1;\n# $Id: SymbolI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Symbol::SymbolI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Symbol::SymbolI - Interface for a Symbol\n\n=head1 SYNOPSIS\n\n    # get a Bio::Symbol::SymbolI object somehow\n\n    my ($name,$token) = ($symbol->name, $symbol->token);\n    my @symbols       = $symbol->symbols;\n    my $matches       = $symbol->matches;\n\n=head1 DESCRIPTION\n\nSymbol represents a single token in the sequence. Symbol can have\nmultiple synonyms or matches within the same Alphabet, which\nmakes possible to represent ambiguity codes and gaps.\n\nSymbols can be also composed from ordered list other symbols. For\nexample, codons can be represented by single Symbol using a\ncompound Alphabet made from three DNA Alphabets.\n\nThis module was implemented for the purposes of meeting the\nBSANE/BioCORBA spec 0.3 only.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Symbol::SymbolI;\nuse strict;\nuse base qw(Bio::Root::RootI);\n\n=head2 Bio::Symbol::SymbolI interface methods\n\n\n=head2 name\n\n Title   : name\n Usage   : my $name = $symbol->name();\n Function: Get/Set Descriptive name for Symbol\n Returns : string\n Args    : (optional) string","parameters":[{"label":"$self"},{"label":"@args"}],"label":"name($self,@args)"},"detail":"($self,@args)","kind":12,"children":[{"containerName":"name","name":"$self","definition":"my","localvar":"my","kind":13,"line":103},{"kind":13,"line":103,"containerName":"name","name":"@args"},{"kind":13,"line":104,"containerName":"name","name":"$self"},{"line":104,"kind":12,"containerName":"name","name":"throw_not_implemented"}],"line":102,"name":"name","range":{"end":{"line":105,"character":9999},"start":{"character":0,"line":102}}},{"line":118,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"token","line":119,"kind":13},{"line":119,"kind":13,"containerName":"token","name":"@args"},{"name":"$self","containerName":"token","line":120,"kind":13},{"line":120,"kind":12,"name":"throw_not_implemented","containerName":"token"}],"kind":12,"detail":"($self,@args)","signature":{"label":"token($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: SymbolI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Symbol::SymbolI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Symbol::SymbolI - Interface for a Symbol\n\n=head1 SYNOPSIS\n\n    # get a Bio::Symbol::SymbolI object somehow\n\n    my ($name,$token) = ($symbol->name, $symbol->token);\n    my @symbols       = $symbol->symbols;\n    my $matches       = $symbol->matches;\n\n=head1 DESCRIPTION\n\nSymbol represents a single token in the sequence. Symbol can have\nmultiple synonyms or matches within the same Alphabet, which\nmakes possible to represent ambiguity codes and gaps.\n\nSymbols can be also composed from ordered list other symbols. For\nexample, codons can be represented by single Symbol using a\ncompound Alphabet made from three DNA Alphabets.\n\nThis module was implemented for the purposes of meeting the\nBSANE/BioCORBA spec 0.3 only.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Symbol::SymbolI;\nuse strict;\nuse base qw(Bio::Root::RootI);\n\n=head2 Bio::Symbol::SymbolI interface methods\n\n\n=head2 name\n\n Title   : name\n Usage   : my $name = $symbol->name();\n Function: Get/Set Descriptive name for Symbol\n Returns : string\n Args    : (optional) string\n\n\nsub name{\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 token\n\n Title   : token\n Usage   : my $token = $self->token();\n Function: Get/Set token for this symbol\n Example : Letter A,C,G,or T for a DNA alphabet Symbol\n Returns : string\n Args    : (optional) string"},"containerName":"main::","definition":"sub","range":{"start":{"line":118,"character":0},"end":{"character":9999,"line":121}},"name":"token"},{"containerName":"main::","definition":"sub","detail":"($self,@args)","signature":{"documentation":"1;\n# $Id: SymbolI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Symbol::SymbolI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Symbol::SymbolI - Interface for a Symbol\n\n=head1 SYNOPSIS\n\n    # get a Bio::Symbol::SymbolI object somehow\n\n    my ($name,$token) = ($symbol->name, $symbol->token);\n    my @symbols       = $symbol->symbols;\n    my $matches       = $symbol->matches;\n\n=head1 DESCRIPTION\n\nSymbol represents a single token in the sequence. Symbol can have\nmultiple synonyms or matches within the same Alphabet, which\nmakes possible to represent ambiguity codes and gaps.\n\nSymbols can be also composed from ordered list other symbols. For\nexample, codons can be represented by single Symbol using a\ncompound Alphabet made from three DNA Alphabets.\n\nThis module was implemented for the purposes of meeting the\nBSANE/BioCORBA spec 0.3 only.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Symbol::SymbolI;\nuse strict;\nuse base qw(Bio::Root::RootI);\n\n=head2 Bio::Symbol::SymbolI interface methods\n\n\n=head2 name\n\n Title   : name\n Usage   : my $name = $symbol->name();\n Function: Get/Set Descriptive name for Symbol\n Returns : string\n Args    : (optional) string\n\n\nsub name{\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 token\n\n Title   : token\n Usage   : my $token = $self->token();\n Function: Get/Set token for this symbol\n Example : Letter A,C,G,or T for a DNA alphabet Symbol\n Returns : string\n Args    : (optional) string\n\n\nsub token{\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 symbols\n\n Title   : symbols\n Usage   : my @symbols = $self->symbols();\n Function: Get/Set Symbols this Symbol is composed from\n Example : A codon is composed of 3 DNA symbols\n Returns : Array of Bio::Symbol::SymbolI objects\n Args    : (optional) Array of Bio::Symbol::SymbolI objects","parameters":[{"label":"$self"},{"label":"@args"}],"label":"symbols($self,@args)"},"kind":12,"line":135,"children":[{"name":"$self","definition":"my","containerName":"symbols","localvar":"my","kind":13,"line":136},{"kind":13,"line":136,"name":"@args","containerName":"symbols"},{"containerName":"symbols","name":"$self","kind":13,"line":137},{"name":"throw_not_implemented","containerName":"symbols","line":137,"kind":12}],"name":"symbols","range":{"end":{"character":9999,"line":138},"start":{"line":135,"character":0}}},{"kind":12,"children":[{"line":154,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"matches"},{"name":"@args","containerName":"matches","line":154,"kind":13},{"containerName":"matches","name":"$self","kind":13,"line":155},{"line":155,"kind":12,"name":"throw_not_implemented","containerName":"matches"}],"line":153,"definition":"sub","containerName":"main::","signature":{"label":"matches($self,@args)","documentation":"1;\n# $Id: SymbolI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Symbol::SymbolI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Symbol::SymbolI - Interface for a Symbol\n\n=head1 SYNOPSIS\n\n    # get a Bio::Symbol::SymbolI object somehow\n\n    my ($name,$token) = ($symbol->name, $symbol->token);\n    my @symbols       = $symbol->symbols;\n    my $matches       = $symbol->matches;\n\n=head1 DESCRIPTION\n\nSymbol represents a single token in the sequence. Symbol can have\nmultiple synonyms or matches within the same Alphabet, which\nmakes possible to represent ambiguity codes and gaps.\n\nSymbols can be also composed from ordered list other symbols. For\nexample, codons can be represented by single Symbol using a\ncompound Alphabet made from three DNA Alphabets.\n\nThis module was implemented for the purposes of meeting the\nBSANE/BioCORBA spec 0.3 only.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Symbol::SymbolI;\nuse strict;\nuse base qw(Bio::Root::RootI);\n\n=head2 Bio::Symbol::SymbolI interface methods\n\n\n=head2 name\n\n Title   : name\n Usage   : my $name = $symbol->name();\n Function: Get/Set Descriptive name for Symbol\n Returns : string\n Args    : (optional) string\n\n\nsub name{\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 token\n\n Title   : token\n Usage   : my $token = $self->token();\n Function: Get/Set token for this symbol\n Example : Letter A,C,G,or T for a DNA alphabet Symbol\n Returns : string\n Args    : (optional) string\n\n\nsub token{\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 symbols\n\n Title   : symbols\n Usage   : my @symbols = $self->symbols();\n Function: Get/Set Symbols this Symbol is composed from\n Example : A codon is composed of 3 DNA symbols\n Returns : Array of Bio::Symbol::SymbolI objects\n Args    : (optional) Array of Bio::Symbol::SymbolI objects\n\n\n\nsub symbols{\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 matches\n\n Title   : matches\n Usage   : my $matchalphabet = $symbol->matches();\n Function: Get/Set (Sub) alphabet of symbols matched by this symbol\n           including the symbol itself (i.e. if symbol is DNA\n           ambiguity code W then the matches contains symbols for W\n           and T)\n Returns : Bio::Symbol::AlphabetI\n Args    : (optional) Bio::Symbol::AlphabetI","parameters":[{"label":"$self"},{"label":"@args"}]},"detail":"($self,@args)","name":"matches","range":{"start":{"line":153,"character":0},"end":{"line":156,"character":9999}}},{"signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: SymbolI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Symbol::SymbolI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Symbol::SymbolI - Interface for a Symbol\n\n=head1 SYNOPSIS\n\n    # get a Bio::Symbol::SymbolI object somehow\n\n    my ($name,$token) = ($symbol->name, $symbol->token);\n    my @symbols       = $symbol->symbols;\n    my $matches       = $symbol->matches;\n\n=head1 DESCRIPTION\n\nSymbol represents a single token in the sequence. Symbol can have\nmultiple synonyms or matches within the same Alphabet, which\nmakes possible to represent ambiguity codes and gaps.\n\nSymbols can be also composed from ordered list other symbols. For\nexample, codons can be represented by single Symbol using a\ncompound Alphabet made from three DNA Alphabets.\n\nThis module was implemented for the purposes of meeting the\nBSANE/BioCORBA spec 0.3 only.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Symbol::SymbolI;\nuse strict;\nuse base qw(Bio::Root::RootI);\n\n=head2 Bio::Symbol::SymbolI interface methods\n\n\n=head2 name\n\n Title   : name\n Usage   : my $name = $symbol->name();\n Function: Get/Set Descriptive name for Symbol\n Returns : string\n Args    : (optional) string\n\n\nsub name{\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 token\n\n Title   : token\n Usage   : my $token = $self->token();\n Function: Get/Set token for this symbol\n Example : Letter A,C,G,or T for a DNA alphabet Symbol\n Returns : string\n Args    : (optional) string\n\n\nsub token{\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 symbols\n\n Title   : symbols\n Usage   : my @symbols = $self->symbols();\n Function: Get/Set Symbols this Symbol is composed from\n Example : A codon is composed of 3 DNA symbols\n Returns : Array of Bio::Symbol::SymbolI objects\n Args    : (optional) Array of Bio::Symbol::SymbolI objects\n\n\n\nsub symbols{\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 matches\n\n Title   : matches\n Usage   : my $matchalphabet = $symbol->matches();\n Function: Get/Set (Sub) alphabet of symbols matched by this symbol\n           including the symbol itself (i.e. if symbol is DNA\n           ambiguity code W then the matches contains symbols for W\n           and T)\n Returns : Bio::Symbol::AlphabetI\n Args    : (optional) Bio::Symbol::AlphabetI\n\n\nsub matches{\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();   \n}\n\n=head2 equals\n\n Title   : equals\n Usage   : if( $symbol->equals($symbol2) ) { }\n Function: Tests if a symbol is equal to another \n Returns : Boolean\n Args    : Bio::Symbol::SymbolI","label":"equals($self,@args)"},"detail":"($self,@args)","definition":"sub","containerName":"main::","children":[{"kind":13,"line":169,"containerName":"equals","definition":"my","name":"$self","localvar":"my"},{"line":169,"kind":13,"name":"@args","containerName":"equals"},{"line":170,"kind":13,"containerName":"equals","name":"$self"},{"name":"throw_not_implemented","containerName":"equals","kind":12,"line":170}],"line":168,"kind":12,"range":{"end":{"character":9999,"line":171},"start":{"line":168,"character":0}},"name":"equals"}],"version":5}