{"version":5,"vars":[{"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"symbols","line":99,"kind":13},{"name":"@args","containerName":"symbols","kind":13,"line":99},{"kind":13,"line":100,"containerName":"symbols","name":"$self"},{"kind":12,"line":100,"containerName":"symbols","name":"throw_not_implemented"}],"line":98,"kind":12,"signature":{"documentation":"1;\n# $Id: AlphabetI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Symbol::AlphabetI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Symbol::AlphabetI - A Symbol Alphabet\n\n=head1 SYNOPSIS\n\n    # get a Bio::Symbol::AlphabetI object somehow\n    my @symbols = $alphabet->symbols;\n    my @subalphas = $alphabet->alphabets;\n    if( $alphabet->contains($symbol) ) {\n\t# do something\n    }\n\n=head1 DESCRIPTION\n\nAlphabet contains set of symbols, which can be concatenated to form\nsymbol lists. Sequence string, for example, is stringified\nrepresentation of the symbol list (tokens of symbols).\n\nThis module was implemented for the purposes of meeting the\nBSANE/BioCORBA spec 0.3 only.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Symbol::AlphabetI;\nuse strict;\nuse Bio::Root::RootI;\n\n=head2 AlphabetI Interface methods\n\n\n=head2 symbols\n\n Title   : symbols\n Usage   : my @symbols = $alphabet->symbols();\n Function: Get/Set Symbol list for an alphabet\n           List of symbols, which make up this alphabet.\n Returns : Array of L<Bio::Symbol::SymbolI> objects\n Args    : (optional) Array of L<Bio::Symbol::SymbolI> objects","parameters":[{"label":"$self"},{"label":"@args"}],"label":"symbols($self,@args)"},"detail":"($self,@args)","definition":"sub","containerName":"main::","range":{"end":{"line":101,"character":9999},"start":{"character":0,"line":98}},"name":"symbols"},{"containerName":"strict::Bio::Root","name":"RootI","kind":2,"line":99},{"range":{"start":{"line":114,"character":0},"end":{"character":9999,"line":117}},"name":"alphabets","line":114,"children":[{"kind":13,"line":115,"name":"$self","definition":"my","containerName":"alphabets","localvar":"my"},{"containerName":"alphabets","name":"@args","kind":13,"line":115},{"line":116,"kind":13,"name":"$self","containerName":"alphabets"},{"kind":12,"line":116,"containerName":"alphabets","name":"throw_not_implemented"}],"kind":12,"detail":"($self,@args)","signature":{"label":"alphabets($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: AlphabetI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Symbol::AlphabetI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Symbol::AlphabetI - A Symbol Alphabet\n\n=head1 SYNOPSIS\n\n    # get a Bio::Symbol::AlphabetI object somehow\n    my @symbols = $alphabet->symbols;\n    my @subalphas = $alphabet->alphabets;\n    if( $alphabet->contains($symbol) ) {\n\t# do something\n    }\n\n=head1 DESCRIPTION\n\nAlphabet contains set of symbols, which can be concatenated to form\nsymbol lists. Sequence string, for example, is stringified\nrepresentation of the symbol list (tokens of symbols).\n\nThis module was implemented for the purposes of meeting the\nBSANE/BioCORBA spec 0.3 only.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Symbol::AlphabetI;\nuse strict;\nuse Bio::Root::RootI;\n\n=head2 AlphabetI Interface methods\n\n\n=head2 symbols\n\n Title   : symbols\n Usage   : my @symbols = $alphabet->symbols();\n Function: Get/Set Symbol list for an alphabet\n           List of symbols, which make up this alphabet.\n Returns : Array of L<Bio::Symbol::SymbolI> objects\n Args    : (optional) Array of L<Bio::Symbol::SymbolI> objects\n\n\nsub symbols{\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 alphabets\n\n Title   : alphabets\n Usage   : my @alphabets = $alphabet->alphabets();\n Function: Get/Set Sub Alphabet list for an alphabet \n           Sub-alphabets. E.g. codons made from DNAxDNAxDNA alphabets\n Returns : Array of L<Bio::Symbol::AlphabetI> objects\n Args    : (optional) Array of L<Bio::Symbol::AlphabetI> objects"},"containerName":"main::","definition":"sub"},{"definition":"sub","containerName":"main::","signature":{"label":"contains($self,@args)","documentation":"1;\n# $Id: AlphabetI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Symbol::AlphabetI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Symbol::AlphabetI - A Symbol Alphabet\n\n=head1 SYNOPSIS\n\n    # get a Bio::Symbol::AlphabetI object somehow\n    my @symbols = $alphabet->symbols;\n    my @subalphas = $alphabet->alphabets;\n    if( $alphabet->contains($symbol) ) {\n\t# do something\n    }\n\n=head1 DESCRIPTION\n\nAlphabet contains set of symbols, which can be concatenated to form\nsymbol lists. Sequence string, for example, is stringified\nrepresentation of the symbol list (tokens of symbols).\n\nThis module was implemented for the purposes of meeting the\nBSANE/BioCORBA spec 0.3 only.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Symbol::AlphabetI;\nuse strict;\nuse Bio::Root::RootI;\n\n=head2 AlphabetI Interface methods\n\n\n=head2 symbols\n\n Title   : symbols\n Usage   : my @symbols = $alphabet->symbols();\n Function: Get/Set Symbol list for an alphabet\n           List of symbols, which make up this alphabet.\n Returns : Array of L<Bio::Symbol::SymbolI> objects\n Args    : (optional) Array of L<Bio::Symbol::SymbolI> objects\n\n\nsub symbols{\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 alphabets\n\n Title   : alphabets\n Usage   : my @alphabets = $alphabet->alphabets();\n Function: Get/Set Sub Alphabet list for an alphabet \n           Sub-alphabets. E.g. codons made from DNAxDNAxDNA alphabets\n Returns : Array of L<Bio::Symbol::AlphabetI> objects\n Args    : (optional) Array of L<Bio::Symbol::AlphabetI> objects\n\n\nsub alphabets{\n    my ($self,@args) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 contains\n\n Title   : contains\n Usage   : if($alphabet->contains($symbol)) { }\n Function: Tests of Symbol is contained in this alphabet\n Returns : Boolean\n Args    : L<Bio::Symbol::SymbolI>","parameters":[{"label":"$self"},{"label":"@args"}]},"detail":"($self,@args)","kind":12,"children":[{"kind":13,"line":130,"name":"$self","definition":"my","containerName":"contains","localvar":"my"},{"line":130,"kind":13,"containerName":"contains","name":"@args"},{"containerName":"contains","name":"$self","kind":13,"line":131},{"kind":12,"line":131,"name":"throw_not_implemented","containerName":"contains"}],"line":129,"name":"contains","range":{"end":{"character":9999,"line":132},"start":{"line":129,"character":0}}}]}