{"vars":[{"containerName":"","name":"base","line":220,"kind":2},{"containerName":null,"name":"$entry","definition":"my","localvar":"my","kind":13,"line":234},{"range":{"end":{"character":9999,"line":259},"start":{"line":236,"character":0}},"name":"new","children":[{"line":237,"kind":13,"localvar":"my","containerName":"new","definition":"my","name":"$caller"},{"kind":13,"line":237,"containerName":"new","name":"@args"},{"localvar":"my","definition":"my","name":"$class","containerName":"new","line":238,"kind":13},{"kind":13,"line":238,"name":"$caller","containerName":"new"},{"name":"$caller","containerName":"new","kind":13,"line":238},{"name":"$class","containerName":"new","line":242,"kind":13},{"containerName":"new","name":"$self","definition":"my","localvar":"my","kind":13,"line":243},{"containerName":"new","name":"$class","line":243,"kind":13},{"kind":13,"line":243,"containerName":"new","name":"@args"},{"line":244,"kind":13,"name":"$self","containerName":"new"},{"line":244,"kind":12,"containerName":"new","name":"_initialize"},{"name":"@args","containerName":"new","line":244,"kind":13},{"containerName":"new","name":"$self","line":245,"kind":13},{"localvar":"my","containerName":"new","definition":"my","name":"%param","line":248,"kind":13},{"line":248,"kind":13,"containerName":"new","name":"@args"},{"line":249,"kind":13,"name":"@param","containerName":"new"},{"name":"%param","containerName":"new","kind":13,"line":249},{"containerName":"new","name":"%param","kind":13,"line":249},{"localvar":"my","definition":"my","name":"$format","containerName":"new","line":250,"kind":13},{"containerName":"new","name":"$param","kind":13,"line":250},{"kind":13,"line":251,"name":"$class","containerName":"new"},{"line":251,"kind":12,"name":"_guess_format","containerName":"new"},{"containerName":"new","name":"$param","line":251,"kind":13},{"kind":13,"line":251,"name":"$ARGV","containerName":"new"},{"kind":13,"line":253,"containerName":"new","name":"$format"},{"kind":13,"line":256,"containerName":"new","name":"$format"},{"name":"new","containerName":"new","line":257,"kind":12},{"containerName":"new","name":"@args","line":257,"kind":13}],"line":236,"kind":12,"signature":{"parameters":[{"label":"$caller"},{"label":"@args"}],"documentation":"","label":"new($caller,@args)"},"detail":"($caller,@args)","definition":"sub","containerName":"main::"},{"line":243,"kind":12,"name":"SUPER","containerName":"new"},{"kind":12,"line":256,"name":"_load_format_module"},{"line":274,"children":[{"line":275,"kind":13,"localvar":"my","name":"$class","definition":"my","containerName":"newFh"},{"line":276,"kind":13,"localvar":"my","containerName":"newFh","name":"$self","definition":"my"},{"name":"$class","containerName":"newFh","line":276,"kind":13},{"kind":12,"line":276,"name":"new","containerName":"newFh"},{"containerName":"newFh","name":"$self","kind":13,"line":277},{"containerName":"newFh","name":"fh","line":277,"kind":12}],"kind":12,"range":{"start":{"line":274,"character":0},"end":{"line":278,"character":9999}},"containerName":"main::","name":"newFh","definition":"sub"},{"name":"fh","definition":"sub","containerName":"main::","range":{"end":{"line":300,"character":9999},"start":{"character":0,"line":294}},"kind":12,"children":[{"line":295,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"fh"},{"kind":13,"line":296,"name":"$class","definition":"my","containerName":"fh","localvar":"my"},{"name":"$self","containerName":"fh","line":296,"kind":13},{"containerName":"fh","name":"$self","line":296,"kind":13},{"line":297,"kind":13,"localvar":"my","definition":"my","name":"$s","containerName":"fh"},{"kind":13,"line":298,"containerName":"fh","name":"$class"},{"kind":13,"line":298,"containerName":"fh","name":"$self"},{"name":"$s","containerName":"fh","kind":13,"line":299}],"line":294},{"line":298,"kind":12,"name":"Symbol","containerName":"gensym"},{"detail":"($self,@args)","signature":{"documentation":" _initialize is chained for all SeqIO classes","parameters":[{"label":"$self"},{"label":"@args"}],"label":"_initialize($self,@args)"},"containerName":"main::","definition":"sub","line":305,"children":[{"kind":13,"line":306,"containerName":"_initialize","name":"$self","definition":"my","localvar":"my"},{"line":306,"kind":13,"containerName":"_initialize","name":"@args"},{"kind":13,"line":309,"containerName":"_initialize","name":"$self"},{"kind":13,"line":309,"containerName":"_initialize","name":"@args"},{"containerName":"_initialize","name":"$self","line":312,"kind":13},{"containerName":"_initialize","name":"_initialize_io","line":312,"kind":12},{"kind":13,"line":312,"name":"@args","containerName":"_initialize"}],"kind":12,"range":{"start":{"line":305,"character":0},"end":{"character":9999,"line":313}},"name":"_initialize"},{"containerName":"_initialize","name":"SUPER","kind":12,"line":309},{"name":"next_structure","range":{"start":{"character":0,"line":337},"end":{"character":9999,"line":340}},"definition":"sub","containerName":"main::","signature":{"label":"next_structure($self,$struc)","documentation":"1;\n# $Id: IO.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Structure::IO\n#\n# Copyright 2001, 2002 Kris Boulez\n#\n# You may distribute this module under the same terms as perl itself\n#\n# _history\n# October 18, 1999  Largely rewritten by Lincoln Stein\n# November 16, 2001 Copied Bio::SeqIO to Bio::Structure::IO and modified\n# \t\t\twhere needed. Factoring out common methods\n# \t\t\t(to Bio::Root::IO) might be a good idea.\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Structure::IO - Handler for Structure Formats\n\n=head1 SYNOPSIS\n\n    use Bio::Structure::IO;\n\n    $in  = Bio::Structure::IO->new(-file => \"inputfilename\",\n                                   -format => 'pdb');\n\n    while ( my $struc = $in->next_structure() ) {\n       print \"Structure \", $struc->id, \" number of models: \",\n             scalar $struc->model,\"\\n\";\n    }\n\n=head1 DESCRIPTION\n\nBio::Structure::IO is a handler module for the formats in the\nStructure::IO set (e.g. L<Bio::Structure::IO::pdb>). It is the officially\nsanctioned way of getting at the format objects, which most people\nshould use.\n\nThe Bio::Structure::IO system can be thought of like biological file\nhandles.  They are attached to filehandles with smart formatting rules\n(e.g. PDB format) and can either read or write structure objects\n(Bio::Structure objects, or more correctly, Bio::Structure::StructureI\nimplementing objects, of which Bio::Structure is one such object). If\nyou want to know what to do with a Bio::Structure object, read\nL<Bio::Structure>.\n\nThe idea is that you request a stream object for a particular format.\nAll the stream objects have a notion of an internal file that is read\nfrom or written to. A particular Structure::IO object instance is\nconfigured for either input or output. A specific example of a stream\nobject is the Bio::Structure::IO::pdb object.\n\nEach stream object has functions\n\n   $stream->next_structure();\n\nand\n\n   $stream->write_structure($struc);\n\nalso\n\n   $stream->type() # returns 'INPUT' or 'OUTPUT'\n\nAs an added bonus, you can recover a filehandle that is tied to the\nStructure::IOIO object, allowing you to use the standard E<lt>E<gt>\nand print operations to read and write structure::IOuence objects:\n\n    use Bio::Structure::IO;\n\n    $stream = Bio::Structure::IO->newFh(-format => 'pdb'); # read from standard input\n\n    while ( $structure = <$stream> ) {\n   \t# do something with $structure\n    }\n\nand\n\n    print $stream $structure; # when stream is in output mode\n\n\n=head1 CONSTRUCTORS\n\n=head2 Bio::Structure::IO-E<gt>new()\n\n   $stream = Bio::Structure::IO->new(-file => 'filename',   -format=>$format);\n   $stream = Bio::Structure::IO->new(-fh   => \\*FILEHANDLE, -format=>$format);\n   $stream = Bio::Structure::IO->new(-format => $format);\n\nThe new() class method constructs a new Bio::Structure::IO object. The\nreturned object can be used to retrieve or print Bio::Structure\nobjects.  new() accepts the following parameters:\n\n=over 4\n\n* -file\n\nA file path to be opened for reading or writing.  The usual Perl\nconventions apply:\n\n   'file'       # open file for reading\n   '>file'      # open file for writing\n   '>>file'     # open file for appending\n   '+<file'     # open file read/write\n   'command |'  # open a pipe from the command\n   '| command'  # open a pipe to the command\n\n* -fh\n\nYou may provide new() with a previously-opened filehandle.  For\nexample, to read from STDIN:\n\n   $strucIO = Bio::Structure::IO->new(-fh => \\*STDIN);\n\nNote that you must pass filehandles as references to globs.\n\nIf neither a filehandle nor a filename is specified, then the module\nwill read from the @ARGV array or STDIN, using the familiar E<lt>E<gt>\nsemantics.\n\n* -format\n\nSpecify the format of the file.  Supported formats include:\n\n   pdb         Protein Data Bank format\n\nIf no format is specified and a filename is given, then the module\nwill attempt to deduce it from the filename.  If this is unsuccessful,\nPDB format is assumed.\n\nThe format name is case insensitive.  'PDB', 'Pdb' and 'pdb' are\nall supported.\n\n\n=head2 Bio::Structure::IO-E<gt>newFh()\n\n   $fh = Bio::Structure::IO->newFh(-fh   => \\*FILEHANDLE, -format=>$format);\n   $fh = Bio::Structure::IO->newFh(-format => $format);\n   # etc.\n\nThis constructor behaves like new(), but returns a tied filehandle\nrather than a Bio::Structure::IO object.  You can read structures from this\nobject using the familiar E<lt>E<gt> operator, and write to it using\nprint().  The usual array and $_ semantics work.  For example, you can\nread all structure objects into an array like this:\n\n  @structures = <$fh>;\n\nOther operations, such as read(), sysread(), write(), close(), and printf()\nare not supported.\n\n=head1 OBJECT METHODS\n\nSee below for more detailed summaries.  The main methods are:\n\n=head2 $structure = $structIO-E<gt>next_structure()\n\nFetch the next structure from the stream.\n\n=head2 $structIO-E<gt>write_structure($struc [,$another_struc,...])\n\nWrite the specified structure(s) to the stream.\n\n=head2 TIEHANDLE(), READLINE(), PRINT()\n\nThese provide the tie interface.  See L<perltie> for more details.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.\nBug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS - Ewan Birney, Lincoln Stein, Kris Boulez\n\nEmail birney@ebi.ac.uk, lstein@cshl.org, kris.boulez@algonomics.com\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Structure::IO;\n\nuse strict;\n\nuse Bio::PrimarySeq;\nuse Symbol;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\n=head2 new\n\n Title   : new\n Usage   : $stream = Bio::Structure::IO->new(-file => $filename, -format => 'Format')\n Function: Returns a new structIOstream\n Returns : A Bio::Structure::IO handler initialised with the appropriate format\n Args    : -file => $filename\n           -format => format\n           -fh => filehandle to attach to\n\n\nmy $entry = 0;\n\nsub new {\n    my ($caller,@args) = @_;\n    my $class = ref($caller) || $caller;\n\n    # or do we want to call SUPER on an object if $caller is an\n    # object?\n    if( $class =~ /Bio::Structure::IO::(\\S+)/ ) {\n\tmy ($self) = $class->SUPER::new(@args);\n\t$self->_initialize(@args);\n\treturn $self;\n    } else {\n\n\tmy %param = @args;\n\t@param{ map { lc $_ } keys %param } = values %param; # lowercase keys\n\tmy $format = $param{'-format'} ||\n\t    $class->_guess_format( $param{-file} || $ARGV[0] ) ||\n\t\t'pdb';\n\t$format = \"\\L$format\";\t# normalize capitalization to lower case\n\n\t# normalize capitalization\n\treturn unless( &_load_format_module($format) );\n\treturn \"Bio::Structure::IO::$format\"->new(@args);\n    }\n}\n\n=head2 newFh\n\n Title   : newFh\n Usage   : $fh = Bio::Structure::IO->newFh(-file=>$filename,-format=>'Format')\n Function: does a new() followed by an fh()\n Example : $fh = Bio::Structure::IO->newFh(-file=>$filename,-format=>'Format')\n           $structure = <$fh>;   # read a structure object\n           print $fh $structure; # write a structure object\n Returns : filehandle tied to the Bio::Structure::IO::Fh class\n Args    :\n\n\nsub newFh {\n  my $class = shift;\n  return unless my $self = $class->new(@_);\n  return $self->fh;\n}\n\n=head2 fh\n\n Title   : fh\n Usage   : $obj->fh\n Function:\n Example : $fh = $obj->fh;      # make a tied filehandle\n           $structure = <$fh>;   # read a structure object\n           print $fh $structure; # write a structure object\n Returns : filehandle tied to the Bio::Structure::IO::Fh class\n Args    :\n\n\n\nsub fh {\n  my $self = shift;\n  my $class = ref($self) || $self;\n  my $s = Symbol::gensym;\n  tie $$s,$class,$self;\n  return $s;\n}\n\n\n# _initialize is chained for all SeqIO classes\n\nsub _initialize {\n    my($self, @args) = @_;\n\n    # not really necessary unless we put more in RootI\n    $self->SUPER::_initialize(@args);\n\n    # initialize the IO part\n    $self->_initialize_io(@args);\n}\n\n=head2 next_structure\n\n Title   : next_structure\n Usage   : $structure = stream->next_structure\n Function: Reads the next structure object from the stream and returns a\n           Bio::Structure::Entry object.\n\n           Certain driver modules may encounter entries in the stream that\n           are either misformatted or that use syntax not yet understood\n           by the driver. If such an incident is recoverable, e.g., by\n           dismissing a feature of a feature table or some other non-mandatory\n           part of an entry, the driver will issue a warning. In the case\n           of a non-recoverable situation an exception will be thrown.\n           Do not assume that you can resume parsing the same stream after\n           catching the exception. Note that you can always turn recoverable\n           errors into exceptions by calling $stream->verbose(2) (see\n           Bio::RootI POD page).\n Returns : a Bio::Structure::Entry object\n Args    : none","parameters":[{"label":"$self"},{"label":"$struc"}]},"detail":"($self,$struc)","kind":12,"children":[{"line":338,"kind":13,"localvar":"my","containerName":"next_structure","definition":"my","name":"$self"},{"containerName":"next_structure","name":"$struc","line":338,"kind":13},{"name":"$self","containerName":"next_structure","kind":13,"line":339},{"line":339,"kind":12,"containerName":"next_structure","name":"throw"}],"line":337},{"name":"write_seq","range":{"start":{"line":376,"character":0},"end":{"line":379,"character":9999}},"kind":12,"line":376,"children":[{"kind":13,"line":377,"definition":"my","name":"$self","containerName":"write_seq","localvar":"my"},{"name":"$struc","containerName":"write_seq","kind":13,"line":377},{"name":"$self","containerName":"write_seq","kind":13,"line":378},{"kind":12,"line":378,"containerName":"write_seq","name":"throw"}],"containerName":"main::","definition":"sub","detail":"($self,$struc)","signature":{"label":"write_seq($self,$struc)","documentation":"1;\n# $Id: IO.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Structure::IO\n#\n# Copyright 2001, 2002 Kris Boulez\n#\n# You may distribute this module under the same terms as perl itself\n#\n# _history\n# October 18, 1999  Largely rewritten by Lincoln Stein\n# November 16, 2001 Copied Bio::SeqIO to Bio::Structure::IO and modified\n# \t\t\twhere needed. Factoring out common methods\n# \t\t\t(to Bio::Root::IO) might be a good idea.\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Structure::IO - Handler for Structure Formats\n\n=head1 SYNOPSIS\n\n    use Bio::Structure::IO;\n\n    $in  = Bio::Structure::IO->new(-file => \"inputfilename\",\n                                   -format => 'pdb');\n\n    while ( my $struc = $in->next_structure() ) {\n       print \"Structure \", $struc->id, \" number of models: \",\n             scalar $struc->model,\"\\n\";\n    }\n\n=head1 DESCRIPTION\n\nBio::Structure::IO is a handler module for the formats in the\nStructure::IO set (e.g. L<Bio::Structure::IO::pdb>). It is the officially\nsanctioned way of getting at the format objects, which most people\nshould use.\n\nThe Bio::Structure::IO system can be thought of like biological file\nhandles.  They are attached to filehandles with smart formatting rules\n(e.g. PDB format) and can either read or write structure objects\n(Bio::Structure objects, or more correctly, Bio::Structure::StructureI\nimplementing objects, of which Bio::Structure is one such object). If\nyou want to know what to do with a Bio::Structure object, read\nL<Bio::Structure>.\n\nThe idea is that you request a stream object for a particular format.\nAll the stream objects have a notion of an internal file that is read\nfrom or written to. A particular Structure::IO object instance is\nconfigured for either input or output. A specific example of a stream\nobject is the Bio::Structure::IO::pdb object.\n\nEach stream object has functions\n\n   $stream->next_structure();\n\nand\n\n   $stream->write_structure($struc);\n\nalso\n\n   $stream->type() # returns 'INPUT' or 'OUTPUT'\n\nAs an added bonus, you can recover a filehandle that is tied to the\nStructure::IOIO object, allowing you to use the standard E<lt>E<gt>\nand print operations to read and write structure::IOuence objects:\n\n    use Bio::Structure::IO;\n\n    $stream = Bio::Structure::IO->newFh(-format => 'pdb'); # read from standard input\n\n    while ( $structure = <$stream> ) {\n   \t# do something with $structure\n    }\n\nand\n\n    print $stream $structure; # when stream is in output mode\n\n\n=head1 CONSTRUCTORS\n\n=head2 Bio::Structure::IO-E<gt>new()\n\n   $stream = Bio::Structure::IO->new(-file => 'filename',   -format=>$format);\n   $stream = Bio::Structure::IO->new(-fh   => \\*FILEHANDLE, -format=>$format);\n   $stream = Bio::Structure::IO->new(-format => $format);\n\nThe new() class method constructs a new Bio::Structure::IO object. The\nreturned object can be used to retrieve or print Bio::Structure\nobjects.  new() accepts the following parameters:\n\n=over 4\n\n* -file\n\nA file path to be opened for reading or writing.  The usual Perl\nconventions apply:\n\n   'file'       # open file for reading\n   '>file'      # open file for writing\n   '>>file'     # open file for appending\n   '+<file'     # open file read/write\n   'command |'  # open a pipe from the command\n   '| command'  # open a pipe to the command\n\n* -fh\n\nYou may provide new() with a previously-opened filehandle.  For\nexample, to read from STDIN:\n\n   $strucIO = Bio::Structure::IO->new(-fh => \\*STDIN);\n\nNote that you must pass filehandles as references to globs.\n\nIf neither a filehandle nor a filename is specified, then the module\nwill read from the @ARGV array or STDIN, using the familiar E<lt>E<gt>\nsemantics.\n\n* -format\n\nSpecify the format of the file.  Supported formats include:\n\n   pdb         Protein Data Bank format\n\nIf no format is specified and a filename is given, then the module\nwill attempt to deduce it from the filename.  If this is unsuccessful,\nPDB format is assumed.\n\nThe format name is case insensitive.  'PDB', 'Pdb' and 'pdb' are\nall supported.\n\n\n=head2 Bio::Structure::IO-E<gt>newFh()\n\n   $fh = Bio::Structure::IO->newFh(-fh   => \\*FILEHANDLE, -format=>$format);\n   $fh = Bio::Structure::IO->newFh(-format => $format);\n   # etc.\n\nThis constructor behaves like new(), but returns a tied filehandle\nrather than a Bio::Structure::IO object.  You can read structures from this\nobject using the familiar E<lt>E<gt> operator, and write to it using\nprint().  The usual array and $_ semantics work.  For example, you can\nread all structure objects into an array like this:\n\n  @structures = <$fh>;\n\nOther operations, such as read(), sysread(), write(), close(), and printf()\nare not supported.\n\n=head1 OBJECT METHODS\n\nSee below for more detailed summaries.  The main methods are:\n\n=head2 $structure = $structIO-E<gt>next_structure()\n\nFetch the next structure from the stream.\n\n=head2 $structIO-E<gt>write_structure($struc [,$another_struc,...])\n\nWrite the specified structure(s) to the stream.\n\n=head2 TIEHANDLE(), READLINE(), PRINT()\n\nThese provide the tie interface.  See L<perltie> for more details.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.\nBug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS - Ewan Birney, Lincoln Stein, Kris Boulez\n\nEmail birney@ebi.ac.uk, lstein@cshl.org, kris.boulez@algonomics.com\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Structure::IO;\n\nuse strict;\n\nuse Bio::PrimarySeq;\nuse Symbol;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\n=head2 new\n\n Title   : new\n Usage   : $stream = Bio::Structure::IO->new(-file => $filename, -format => 'Format')\n Function: Returns a new structIOstream\n Returns : A Bio::Structure::IO handler initialised with the appropriate format\n Args    : -file => $filename\n           -format => format\n           -fh => filehandle to attach to\n\n\nmy $entry = 0;\n\nsub new {\n    my ($caller,@args) = @_;\n    my $class = ref($caller) || $caller;\n\n    # or do we want to call SUPER on an object if $caller is an\n    # object?\n    if( $class =~ /Bio::Structure::IO::(\\S+)/ ) {\n\tmy ($self) = $class->SUPER::new(@args);\n\t$self->_initialize(@args);\n\treturn $self;\n    } else {\n\n\tmy %param = @args;\n\t@param{ map { lc $_ } keys %param } = values %param; # lowercase keys\n\tmy $format = $param{'-format'} ||\n\t    $class->_guess_format( $param{-file} || $ARGV[0] ) ||\n\t\t'pdb';\n\t$format = \"\\L$format\";\t# normalize capitalization to lower case\n\n\t# normalize capitalization\n\treturn unless( &_load_format_module($format) );\n\treturn \"Bio::Structure::IO::$format\"->new(@args);\n    }\n}\n\n=head2 newFh\n\n Title   : newFh\n Usage   : $fh = Bio::Structure::IO->newFh(-file=>$filename,-format=>'Format')\n Function: does a new() followed by an fh()\n Example : $fh = Bio::Structure::IO->newFh(-file=>$filename,-format=>'Format')\n           $structure = <$fh>;   # read a structure object\n           print $fh $structure; # write a structure object\n Returns : filehandle tied to the Bio::Structure::IO::Fh class\n Args    :\n\n\nsub newFh {\n  my $class = shift;\n  return unless my $self = $class->new(@_);\n  return $self->fh;\n}\n\n=head2 fh\n\n Title   : fh\n Usage   : $obj->fh\n Function:\n Example : $fh = $obj->fh;      # make a tied filehandle\n           $structure = <$fh>;   # read a structure object\n           print $fh $structure; # write a structure object\n Returns : filehandle tied to the Bio::Structure::IO::Fh class\n Args    :\n\n\n\nsub fh {\n  my $self = shift;\n  my $class = ref($self) || $self;\n  my $s = Symbol::gensym;\n  tie $$s,$class,$self;\n  return $s;\n}\n\n\n# _initialize is chained for all SeqIO classes\n\nsub _initialize {\n    my($self, @args) = @_;\n\n    # not really necessary unless we put more in RootI\n    $self->SUPER::_initialize(@args);\n\n    # initialize the IO part\n    $self->_initialize_io(@args);\n}\n\n=head2 next_structure\n\n Title   : next_structure\n Usage   : $structure = stream->next_structure\n Function: Reads the next structure object from the stream and returns a\n           Bio::Structure::Entry object.\n\n           Certain driver modules may encounter entries in the stream that\n           are either misformatted or that use syntax not yet understood\n           by the driver. If such an incident is recoverable, e.g., by\n           dismissing a feature of a feature table or some other non-mandatory\n           part of an entry, the driver will issue a warning. In the case\n           of a non-recoverable situation an exception will be thrown.\n           Do not assume that you can resume parsing the same stream after\n           catching the exception. Note that you can always turn recoverable\n           errors into exceptions by calling $stream->verbose(2) (see\n           Bio::RootI POD page).\n Returns : a Bio::Structure::Entry object\n Args    : none\n\n\nsub next_structure {\n   my ($self, $struc) = @_;\n   $self->throw(\"Sorry, you cannot read from a generic Bio::Structure::IO object.\");\n}\n\n# Do we want people to read out the sequence directly from a $structIO stream\n#\n##=head2 next_primary_seq\n##\n## Title   : next_primary_seq\n## Usage   : $seq = $stream->next_primary_seq\n## Function: Provides a primaryseq type of sequence object\n## Returns : A Bio::PrimarySeqI object\n## Args    : none\n##\n##\n##=cut\n##\n##sub next_primary_seq {\n##   my ($self) = @_;\n##\n##   # in this case, we default to next_seq. This is because\n##   # Bio::Seq's are Bio::PrimarySeqI objects. However we\n##   # expect certain sub classes to override this method to provide\n##   # less parsing heavy methods to retrieving the objects\n##\n##   return $self->next_seq();\n##}\n\n=head2 write_structure\n\n Title   : write_structure\n Usage   : $stream->write_structure($structure)\n Function: writes the $structure object into the stream\n Returns : 1 for success and 0 for error\n Args    : Bio::Structure object","parameters":[{"label":"$self"},{"label":"$struc"}]}},{"name":"_load_format_module","range":{"end":{"character":9999,"line":447},"start":{"character":0,"line":424}},"kind":12,"children":[{"kind":13,"line":425,"containerName":"_load_format_module","name":"$format","definition":"my","localvar":"my"},{"definition":"my","name":"$module","containerName":"_load_format_module","localvar":"my","kind":13,"line":426},{"line":426,"kind":13,"containerName":"_load_format_module","name":"$load"},{"containerName":"_load_format_module","name":"$m","line":426,"kind":13},{"containerName":"_load_format_module","name":"$module","line":428,"kind":13},{"containerName":"_load_format_module","name":"$load","kind":13,"line":429},{"line":431,"kind":13,"containerName":"_load_format_module","name":"$main"},{"kind":13,"line":431,"containerName":"_load_format_module","name":"$module"},{"kind":13,"line":433,"containerName":"_load_format_module","name":"$load"}],"line":424,"definition":"sub","containerName":"main::","signature":{"label":"_load_format_module($format)","parameters":[{"label":"$format"}],"documentation":"1;\n# $Id: IO.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Structure::IO\n#\n# Copyright 2001, 2002 Kris Boulez\n#\n# You may distribute this module under the same terms as perl itself\n#\n# _history\n# October 18, 1999  Largely rewritten by Lincoln Stein\n# November 16, 2001 Copied Bio::SeqIO to Bio::Structure::IO and modified\n# \t\t\twhere needed. Factoring out common methods\n# \t\t\t(to Bio::Root::IO) might be a good idea.\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Structure::IO - Handler for Structure Formats\n\n=head1 SYNOPSIS\n\n    use Bio::Structure::IO;\n\n    $in  = Bio::Structure::IO->new(-file => \"inputfilename\",\n                                   -format => 'pdb');\n\n    while ( my $struc = $in->next_structure() ) {\n       print \"Structure \", $struc->id, \" number of models: \",\n             scalar $struc->model,\"\\n\";\n    }\n\n=head1 DESCRIPTION\n\nBio::Structure::IO is a handler module for the formats in the\nStructure::IO set (e.g. L<Bio::Structure::IO::pdb>). It is the officially\nsanctioned way of getting at the format objects, which most people\nshould use.\n\nThe Bio::Structure::IO system can be thought of like biological file\nhandles.  They are attached to filehandles with smart formatting rules\n(e.g. PDB format) and can either read or write structure objects\n(Bio::Structure objects, or more correctly, Bio::Structure::StructureI\nimplementing objects, of which Bio::Structure is one such object). If\nyou want to know what to do with a Bio::Structure object, read\nL<Bio::Structure>.\n\nThe idea is that you request a stream object for a particular format.\nAll the stream objects have a notion of an internal file that is read\nfrom or written to. A particular Structure::IO object instance is\nconfigured for either input or output. A specific example of a stream\nobject is the Bio::Structure::IO::pdb object.\n\nEach stream object has functions\n\n   $stream->next_structure();\n\nand\n\n   $stream->write_structure($struc);\n\nalso\n\n   $stream->type() # returns 'INPUT' or 'OUTPUT'\n\nAs an added bonus, you can recover a filehandle that is tied to the\nStructure::IOIO object, allowing you to use the standard E<lt>E<gt>\nand print operations to read and write structure::IOuence objects:\n\n    use Bio::Structure::IO;\n\n    $stream = Bio::Structure::IO->newFh(-format => 'pdb'); # read from standard input\n\n    while ( $structure = <$stream> ) {\n   \t# do something with $structure\n    }\n\nand\n\n    print $stream $structure; # when stream is in output mode\n\n\n=head1 CONSTRUCTORS\n\n=head2 Bio::Structure::IO-E<gt>new()\n\n   $stream = Bio::Structure::IO->new(-file => 'filename',   -format=>$format);\n   $stream = Bio::Structure::IO->new(-fh   => \\*FILEHANDLE, -format=>$format);\n   $stream = Bio::Structure::IO->new(-format => $format);\n\nThe new() class method constructs a new Bio::Structure::IO object. The\nreturned object can be used to retrieve or print Bio::Structure\nobjects.  new() accepts the following parameters:\n\n=over 4\n\n* -file\n\nA file path to be opened for reading or writing.  The usual Perl\nconventions apply:\n\n   'file'       # open file for reading\n   '>file'      # open file for writing\n   '>>file'     # open file for appending\n   '+<file'     # open file read/write\n   'command |'  # open a pipe from the command\n   '| command'  # open a pipe to the command\n\n* -fh\n\nYou may provide new() with a previously-opened filehandle.  For\nexample, to read from STDIN:\n\n   $strucIO = Bio::Structure::IO->new(-fh => \\*STDIN);\n\nNote that you must pass filehandles as references to globs.\n\nIf neither a filehandle nor a filename is specified, then the module\nwill read from the @ARGV array or STDIN, using the familiar E<lt>E<gt>\nsemantics.\n\n* -format\n\nSpecify the format of the file.  Supported formats include:\n\n   pdb         Protein Data Bank format\n\nIf no format is specified and a filename is given, then the module\nwill attempt to deduce it from the filename.  If this is unsuccessful,\nPDB format is assumed.\n\nThe format name is case insensitive.  'PDB', 'Pdb' and 'pdb' are\nall supported.\n\n\n=head2 Bio::Structure::IO-E<gt>newFh()\n\n   $fh = Bio::Structure::IO->newFh(-fh   => \\*FILEHANDLE, -format=>$format);\n   $fh = Bio::Structure::IO->newFh(-format => $format);\n   # etc.\n\nThis constructor behaves like new(), but returns a tied filehandle\nrather than a Bio::Structure::IO object.  You can read structures from this\nobject using the familiar E<lt>E<gt> operator, and write to it using\nprint().  The usual array and $_ semantics work.  For example, you can\nread all structure objects into an array like this:\n\n  @structures = <$fh>;\n\nOther operations, such as read(), sysread(), write(), close(), and printf()\nare not supported.\n\n=head1 OBJECT METHODS\n\nSee below for more detailed summaries.  The main methods are:\n\n=head2 $structure = $structIO-E<gt>next_structure()\n\nFetch the next structure from the stream.\n\n=head2 $structIO-E<gt>write_structure($struc [,$another_struc,...])\n\nWrite the specified structure(s) to the stream.\n\n=head2 TIEHANDLE(), READLINE(), PRINT()\n\nThese provide the tie interface.  See L<perltie> for more details.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.\nBug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS - Ewan Birney, Lincoln Stein, Kris Boulez\n\nEmail birney@ebi.ac.uk, lstein@cshl.org, kris.boulez@algonomics.com\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Structure::IO;\n\nuse strict;\n\nuse Bio::PrimarySeq;\nuse Symbol;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\n=head2 new\n\n Title   : new\n Usage   : $stream = Bio::Structure::IO->new(-file => $filename, -format => 'Format')\n Function: Returns a new structIOstream\n Returns : A Bio::Structure::IO handler initialised with the appropriate format\n Args    : -file => $filename\n           -format => format\n           -fh => filehandle to attach to\n\n\nmy $entry = 0;\n\nsub new {\n    my ($caller,@args) = @_;\n    my $class = ref($caller) || $caller;\n\n    # or do we want to call SUPER on an object if $caller is an\n    # object?\n    if( $class =~ /Bio::Structure::IO::(\\S+)/ ) {\n\tmy ($self) = $class->SUPER::new(@args);\n\t$self->_initialize(@args);\n\treturn $self;\n    } else {\n\n\tmy %param = @args;\n\t@param{ map { lc $_ } keys %param } = values %param; # lowercase keys\n\tmy $format = $param{'-format'} ||\n\t    $class->_guess_format( $param{-file} || $ARGV[0] ) ||\n\t\t'pdb';\n\t$format = \"\\L$format\";\t# normalize capitalization to lower case\n\n\t# normalize capitalization\n\treturn unless( &_load_format_module($format) );\n\treturn \"Bio::Structure::IO::$format\"->new(@args);\n    }\n}\n\n=head2 newFh\n\n Title   : newFh\n Usage   : $fh = Bio::Structure::IO->newFh(-file=>$filename,-format=>'Format')\n Function: does a new() followed by an fh()\n Example : $fh = Bio::Structure::IO->newFh(-file=>$filename,-format=>'Format')\n           $structure = <$fh>;   # read a structure object\n           print $fh $structure; # write a structure object\n Returns : filehandle tied to the Bio::Structure::IO::Fh class\n Args    :\n\n\nsub newFh {\n  my $class = shift;\n  return unless my $self = $class->new(@_);\n  return $self->fh;\n}\n\n=head2 fh\n\n Title   : fh\n Usage   : $obj->fh\n Function:\n Example : $fh = $obj->fh;      # make a tied filehandle\n           $structure = <$fh>;   # read a structure object\n           print $fh $structure; # write a structure object\n Returns : filehandle tied to the Bio::Structure::IO::Fh class\n Args    :\n\n\n\nsub fh {\n  my $self = shift;\n  my $class = ref($self) || $self;\n  my $s = Symbol::gensym;\n  tie $$s,$class,$self;\n  return $s;\n}\n\n\n# _initialize is chained for all SeqIO classes\n\nsub _initialize {\n    my($self, @args) = @_;\n\n    # not really necessary unless we put more in RootI\n    $self->SUPER::_initialize(@args);\n\n    # initialize the IO part\n    $self->_initialize_io(@args);\n}\n\n=head2 next_structure\n\n Title   : next_structure\n Usage   : $structure = stream->next_structure\n Function: Reads the next structure object from the stream and returns a\n           Bio::Structure::Entry object.\n\n           Certain driver modules may encounter entries in the stream that\n           are either misformatted or that use syntax not yet understood\n           by the driver. If such an incident is recoverable, e.g., by\n           dismissing a feature of a feature table or some other non-mandatory\n           part of an entry, the driver will issue a warning. In the case\n           of a non-recoverable situation an exception will be thrown.\n           Do not assume that you can resume parsing the same stream after\n           catching the exception. Note that you can always turn recoverable\n           errors into exceptions by calling $stream->verbose(2) (see\n           Bio::RootI POD page).\n Returns : a Bio::Structure::Entry object\n Args    : none\n\n\nsub next_structure {\n   my ($self, $struc) = @_;\n   $self->throw(\"Sorry, you cannot read from a generic Bio::Structure::IO object.\");\n}\n\n# Do we want people to read out the sequence directly from a $structIO stream\n#\n##=head2 next_primary_seq\n##\n## Title   : next_primary_seq\n## Usage   : $seq = $stream->next_primary_seq\n## Function: Provides a primaryseq type of sequence object\n## Returns : A Bio::PrimarySeqI object\n## Args    : none\n##\n##\n##=cut\n##\n##sub next_primary_seq {\n##   my ($self) = @_;\n##\n##   # in this case, we default to next_seq. This is because\n##   # Bio::Seq's are Bio::PrimarySeqI objects. However we\n##   # expect certain sub classes to override this method to provide\n##   # less parsing heavy methods to retrieving the objects\n##\n##   return $self->next_seq();\n##}\n\n=head2 write_structure\n\n Title   : write_structure\n Usage   : $stream->write_structure($structure)\n Function: writes the $structure object into the stream\n Returns : 1 for success and 0 for error\n Args    : Bio::Structure object\n\n\nsub write_seq {\n    my ($self, $struc) = @_;\n    $self->throw(\"Sorry, you cannot write to a generic Bio::Structure::IO object.\");\n}\n\n\n# De we need this here\n#\n##=head2 alphabet\n##\n## Title   : alphabet\n## Usage   : $self->alphabet($newval)\n## Function: Set/get the molecule type for the Seq objects to be created.\n## Example : $seqio->alphabet('protein')\n## Returns : value of alphabet: 'dna', 'rna', or 'protein'\n## Args    : newvalue (optional)\n## Throws  : Exception if the argument is not one of 'dna', 'rna', or 'protein'\n##\n##=cut\n##\n##sub alphabet {\n##   my ($self, $value) = @_;\n##\n##   if ( defined $value) {\n##       # instead of hard-coding the allowed values once more, we check by\n##       # creating a dummy sequence object\n##       eval {\n##\t   my $seq = Bio::PrimarySeq->new('-alphabet' => $value);\n##       };\n##       if($@) {\n##\t   $self->throw(\"Invalid alphabet: $value\\n. See Bio::PrimarySeq for allowed values.\");\n##       }\n##       $self->{'alphabet'} = \"\\L$value\";\n##   }\n##   return $self->{'alphabet'};\n##}\n\n=head2 _load_format_module\n\n Title   : _load_format_module\n Usage   : *INTERNAL Structure::IO stuff*\n Function: Loads up (like use) a module at run time on demand\n Example :\n Returns :\n Args    :"},"detail":"($format)"},{"children":[{"localvar":"my","containerName":"_concatenate_lines","definition":"my","name":"$self","line":465,"kind":13},{"kind":13,"line":465,"containerName":"_concatenate_lines","name":"$s1"},{"name":"$s2","containerName":"_concatenate_lines","kind":13,"line":465},{"containerName":"_concatenate_lines","name":"$s1","kind":13,"line":466},{"name":"$s1","containerName":"_concatenate_lines","kind":13,"line":466},{"kind":13,"line":466,"name":"$s1","containerName":"_concatenate_lines"},{"name":"$s2","containerName":"_concatenate_lines","kind":13,"line":466},{"containerName":"_concatenate_lines","name":"$s1","line":467,"kind":13},{"line":467,"kind":13,"containerName":"_concatenate_lines","name":"$s1"},{"kind":13,"line":467,"containerName":"_concatenate_lines","name":"$s2"},{"kind":13,"line":467,"name":"$s2","containerName":"_concatenate_lines"}],"line":464,"kind":12,"signature":{"label":"_concatenate_lines($self,$s1,$s2)","documentation":"1;\n# $Id: IO.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Structure::IO\n#\n# Copyright 2001, 2002 Kris Boulez\n#\n# You may distribute this module under the same terms as perl itself\n#\n# _history\n# October 18, 1999  Largely rewritten by Lincoln Stein\n# November 16, 2001 Copied Bio::SeqIO to Bio::Structure::IO and modified\n# \t\t\twhere needed. Factoring out common methods\n# \t\t\t(to Bio::Root::IO) might be a good idea.\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Structure::IO - Handler for Structure Formats\n\n=head1 SYNOPSIS\n\n    use Bio::Structure::IO;\n\n    $in  = Bio::Structure::IO->new(-file => \"inputfilename\",\n                                   -format => 'pdb');\n\n    while ( my $struc = $in->next_structure() ) {\n       print \"Structure \", $struc->id, \" number of models: \",\n             scalar $struc->model,\"\\n\";\n    }\n\n=head1 DESCRIPTION\n\nBio::Structure::IO is a handler module for the formats in the\nStructure::IO set (e.g. L<Bio::Structure::IO::pdb>). It is the officially\nsanctioned way of getting at the format objects, which most people\nshould use.\n\nThe Bio::Structure::IO system can be thought of like biological file\nhandles.  They are attached to filehandles with smart formatting rules\n(e.g. PDB format) and can either read or write structure objects\n(Bio::Structure objects, or more correctly, Bio::Structure::StructureI\nimplementing objects, of which Bio::Structure is one such object). If\nyou want to know what to do with a Bio::Structure object, read\nL<Bio::Structure>.\n\nThe idea is that you request a stream object for a particular format.\nAll the stream objects have a notion of an internal file that is read\nfrom or written to. A particular Structure::IO object instance is\nconfigured for either input or output. A specific example of a stream\nobject is the Bio::Structure::IO::pdb object.\n\nEach stream object has functions\n\n   $stream->next_structure();\n\nand\n\n   $stream->write_structure($struc);\n\nalso\n\n   $stream->type() # returns 'INPUT' or 'OUTPUT'\n\nAs an added bonus, you can recover a filehandle that is tied to the\nStructure::IOIO object, allowing you to use the standard E<lt>E<gt>\nand print operations to read and write structure::IOuence objects:\n\n    use Bio::Structure::IO;\n\n    $stream = Bio::Structure::IO->newFh(-format => 'pdb'); # read from standard input\n\n    while ( $structure = <$stream> ) {\n   \t# do something with $structure\n    }\n\nand\n\n    print $stream $structure; # when stream is in output mode\n\n\n=head1 CONSTRUCTORS\n\n=head2 Bio::Structure::IO-E<gt>new()\n\n   $stream = Bio::Structure::IO->new(-file => 'filename',   -format=>$format);\n   $stream = Bio::Structure::IO->new(-fh   => \\*FILEHANDLE, -format=>$format);\n   $stream = Bio::Structure::IO->new(-format => $format);\n\nThe new() class method constructs a new Bio::Structure::IO object. The\nreturned object can be used to retrieve or print Bio::Structure\nobjects.  new() accepts the following parameters:\n\n=over 4\n\n* -file\n\nA file path to be opened for reading or writing.  The usual Perl\nconventions apply:\n\n   'file'       # open file for reading\n   '>file'      # open file for writing\n   '>>file'     # open file for appending\n   '+<file'     # open file read/write\n   'command |'  # open a pipe from the command\n   '| command'  # open a pipe to the command\n\n* -fh\n\nYou may provide new() with a previously-opened filehandle.  For\nexample, to read from STDIN:\n\n   $strucIO = Bio::Structure::IO->new(-fh => \\*STDIN);\n\nNote that you must pass filehandles as references to globs.\n\nIf neither a filehandle nor a filename is specified, then the module\nwill read from the @ARGV array or STDIN, using the familiar E<lt>E<gt>\nsemantics.\n\n* -format\n\nSpecify the format of the file.  Supported formats include:\n\n   pdb         Protein Data Bank format\n\nIf no format is specified and a filename is given, then the module\nwill attempt to deduce it from the filename.  If this is unsuccessful,\nPDB format is assumed.\n\nThe format name is case insensitive.  'PDB', 'Pdb' and 'pdb' are\nall supported.\n\n\n=head2 Bio::Structure::IO-E<gt>newFh()\n\n   $fh = Bio::Structure::IO->newFh(-fh   => \\*FILEHANDLE, -format=>$format);\n   $fh = Bio::Structure::IO->newFh(-format => $format);\n   # etc.\n\nThis constructor behaves like new(), but returns a tied filehandle\nrather than a Bio::Structure::IO object.  You can read structures from this\nobject using the familiar E<lt>E<gt> operator, and write to it using\nprint().  The usual array and $_ semantics work.  For example, you can\nread all structure objects into an array like this:\n\n  @structures = <$fh>;\n\nOther operations, such as read(), sysread(), write(), close(), and printf()\nare not supported.\n\n=head1 OBJECT METHODS\n\nSee below for more detailed summaries.  The main methods are:\n\n=head2 $structure = $structIO-E<gt>next_structure()\n\nFetch the next structure from the stream.\n\n=head2 $structIO-E<gt>write_structure($struc [,$another_struc,...])\n\nWrite the specified structure(s) to the stream.\n\n=head2 TIEHANDLE(), READLINE(), PRINT()\n\nThese provide the tie interface.  See L<perltie> for more details.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.\nBug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS - Ewan Birney, Lincoln Stein, Kris Boulez\n\nEmail birney@ebi.ac.uk, lstein@cshl.org, kris.boulez@algonomics.com\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Structure::IO;\n\nuse strict;\n\nuse Bio::PrimarySeq;\nuse Symbol;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\n=head2 new\n\n Title   : new\n Usage   : $stream = Bio::Structure::IO->new(-file => $filename, -format => 'Format')\n Function: Returns a new structIOstream\n Returns : A Bio::Structure::IO handler initialised with the appropriate format\n Args    : -file => $filename\n           -format => format\n           -fh => filehandle to attach to\n\n\nmy $entry = 0;\n\nsub new {\n    my ($caller,@args) = @_;\n    my $class = ref($caller) || $caller;\n\n    # or do we want to call SUPER on an object if $caller is an\n    # object?\n    if( $class =~ /Bio::Structure::IO::(\\S+)/ ) {\n\tmy ($self) = $class->SUPER::new(@args);\n\t$self->_initialize(@args);\n\treturn $self;\n    } else {\n\n\tmy %param = @args;\n\t@param{ map { lc $_ } keys %param } = values %param; # lowercase keys\n\tmy $format = $param{'-format'} ||\n\t    $class->_guess_format( $param{-file} || $ARGV[0] ) ||\n\t\t'pdb';\n\t$format = \"\\L$format\";\t# normalize capitalization to lower case\n\n\t# normalize capitalization\n\treturn unless( &_load_format_module($format) );\n\treturn \"Bio::Structure::IO::$format\"->new(@args);\n    }\n}\n\n=head2 newFh\n\n Title   : newFh\n Usage   : $fh = Bio::Structure::IO->newFh(-file=>$filename,-format=>'Format')\n Function: does a new() followed by an fh()\n Example : $fh = Bio::Structure::IO->newFh(-file=>$filename,-format=>'Format')\n           $structure = <$fh>;   # read a structure object\n           print $fh $structure; # write a structure object\n Returns : filehandle tied to the Bio::Structure::IO::Fh class\n Args    :\n\n\nsub newFh {\n  my $class = shift;\n  return unless my $self = $class->new(@_);\n  return $self->fh;\n}\n\n=head2 fh\n\n Title   : fh\n Usage   : $obj->fh\n Function:\n Example : $fh = $obj->fh;      # make a tied filehandle\n           $structure = <$fh>;   # read a structure object\n           print $fh $structure; # write a structure object\n Returns : filehandle tied to the Bio::Structure::IO::Fh class\n Args    :\n\n\n\nsub fh {\n  my $self = shift;\n  my $class = ref($self) || $self;\n  my $s = Symbol::gensym;\n  tie $$s,$class,$self;\n  return $s;\n}\n\n\n# _initialize is chained for all SeqIO classes\n\nsub _initialize {\n    my($self, @args) = @_;\n\n    # not really necessary unless we put more in RootI\n    $self->SUPER::_initialize(@args);\n\n    # initialize the IO part\n    $self->_initialize_io(@args);\n}\n\n=head2 next_structure\n\n Title   : next_structure\n Usage   : $structure = stream->next_structure\n Function: Reads the next structure object from the stream and returns a\n           Bio::Structure::Entry object.\n\n           Certain driver modules may encounter entries in the stream that\n           are either misformatted or that use syntax not yet understood\n           by the driver. If such an incident is recoverable, e.g., by\n           dismissing a feature of a feature table or some other non-mandatory\n           part of an entry, the driver will issue a warning. In the case\n           of a non-recoverable situation an exception will be thrown.\n           Do not assume that you can resume parsing the same stream after\n           catching the exception. Note that you can always turn recoverable\n           errors into exceptions by calling $stream->verbose(2) (see\n           Bio::RootI POD page).\n Returns : a Bio::Structure::Entry object\n Args    : none\n\n\nsub next_structure {\n   my ($self, $struc) = @_;\n   $self->throw(\"Sorry, you cannot read from a generic Bio::Structure::IO object.\");\n}\n\n# Do we want people to read out the sequence directly from a $structIO stream\n#\n##=head2 next_primary_seq\n##\n## Title   : next_primary_seq\n## Usage   : $seq = $stream->next_primary_seq\n## Function: Provides a primaryseq type of sequence object\n## Returns : A Bio::PrimarySeqI object\n## Args    : none\n##\n##\n##=cut\n##\n##sub next_primary_seq {\n##   my ($self) = @_;\n##\n##   # in this case, we default to next_seq. This is because\n##   # Bio::Seq's are Bio::PrimarySeqI objects. However we\n##   # expect certain sub classes to override this method to provide\n##   # less parsing heavy methods to retrieving the objects\n##\n##   return $self->next_seq();\n##}\n\n=head2 write_structure\n\n Title   : write_structure\n Usage   : $stream->write_structure($structure)\n Function: writes the $structure object into the stream\n Returns : 1 for success and 0 for error\n Args    : Bio::Structure object\n\n\nsub write_seq {\n    my ($self, $struc) = @_;\n    $self->throw(\"Sorry, you cannot write to a generic Bio::Structure::IO object.\");\n}\n\n\n# De we need this here\n#\n##=head2 alphabet\n##\n## Title   : alphabet\n## Usage   : $self->alphabet($newval)\n## Function: Set/get the molecule type for the Seq objects to be created.\n## Example : $seqio->alphabet('protein')\n## Returns : value of alphabet: 'dna', 'rna', or 'protein'\n## Args    : newvalue (optional)\n## Throws  : Exception if the argument is not one of 'dna', 'rna', or 'protein'\n##\n##=cut\n##\n##sub alphabet {\n##   my ($self, $value) = @_;\n##\n##   if ( defined $value) {\n##       # instead of hard-coding the allowed values once more, we check by\n##       # creating a dummy sequence object\n##       eval {\n##\t   my $seq = Bio::PrimarySeq->new('-alphabet' => $value);\n##       };\n##       if($@) {\n##\t   $self->throw(\"Invalid alphabet: $value\\n. See Bio::PrimarySeq for allowed values.\");\n##       }\n##       $self->{'alphabet'} = \"\\L$value\";\n##   }\n##   return $self->{'alphabet'};\n##}\n\n=head2 _load_format_module\n\n Title   : _load_format_module\n Usage   : *INTERNAL Structure::IO stuff*\n Function: Loads up (like use) a module at run time on demand\n Example :\n Returns :\n Args    :\n\n\nsub _load_format_module {\n  my ($format) = @_;\n  my ($module, $load, $m);\n\n  $module = \"_<Bio/Structure/IO/$format.pm\";\n  $load = \"Bio/Structure/IO/$format.pm\";\n\n  return 1 if $main::{$module};\n  eval {\n    require $load;\n  };\n  if ( $@ ) {\n    print STDERR <<END;\n$load: $format cannot be found\nException $@\nFor more information about the Structure::IO system please see the\nBio::Structure::IO docs.  This includes ways of checking for formats at\ncompile time, not run time\nEND\n  ;\n    return;\n  }\n  return 1;\n}\n\n=head2 _concatenate_lines\n\n Title   : _concatenate_lines\n Usage   : $s = _concatenate_lines($line, $continuation_line)\n Function: Private. Concatenates two strings assuming that the second stems\n           from a continuation line of the first. Adds a space between both\n           unless the first ends with a dash.\n\n           Takes care of either arg being empty.\n Example :\n Returns : A string.\n Args    :","parameters":[{"label":"$self"},{"label":"$s1"},{"label":"$s2"}]},"detail":"($self,$s1,$s2)","definition":"sub","containerName":"main::","range":{"start":{"character":0,"line":464},"end":{"character":9999,"line":468}},"name":"_concatenate_lines"},{"children":[{"name":"$self","definition":"my","containerName":"_filehandle","localvar":"my","kind":13,"line":483},{"containerName":"_filehandle","name":"@args","line":483,"kind":13},{"kind":13,"line":484,"containerName":"_filehandle","name":"$self"},{"kind":12,"line":484,"containerName":"_filehandle","name":"_fh"},{"kind":13,"line":484,"name":"@args","containerName":"_filehandle"}],"line":482,"kind":12,"signature":{"label":"_filehandle($self,@args)","documentation":"1;\n# $Id: IO.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Structure::IO\n#\n# Copyright 2001, 2002 Kris Boulez\n#\n# You may distribute this module under the same terms as perl itself\n#\n# _history\n# October 18, 1999  Largely rewritten by Lincoln Stein\n# November 16, 2001 Copied Bio::SeqIO to Bio::Structure::IO and modified\n# \t\t\twhere needed. Factoring out common methods\n# \t\t\t(to Bio::Root::IO) might be a good idea.\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Structure::IO - Handler for Structure Formats\n\n=head1 SYNOPSIS\n\n    use Bio::Structure::IO;\n\n    $in  = Bio::Structure::IO->new(-file => \"inputfilename\",\n                                   -format => 'pdb');\n\n    while ( my $struc = $in->next_structure() ) {\n       print \"Structure \", $struc->id, \" number of models: \",\n             scalar $struc->model,\"\\n\";\n    }\n\n=head1 DESCRIPTION\n\nBio::Structure::IO is a handler module for the formats in the\nStructure::IO set (e.g. L<Bio::Structure::IO::pdb>). It is the officially\nsanctioned way of getting at the format objects, which most people\nshould use.\n\nThe Bio::Structure::IO system can be thought of like biological file\nhandles.  They are attached to filehandles with smart formatting rules\n(e.g. PDB format) and can either read or write structure objects\n(Bio::Structure objects, or more correctly, Bio::Structure::StructureI\nimplementing objects, of which Bio::Structure is one such object). If\nyou want to know what to do with a Bio::Structure object, read\nL<Bio::Structure>.\n\nThe idea is that you request a stream object for a particular format.\nAll the stream objects have a notion of an internal file that is read\nfrom or written to. A particular Structure::IO object instance is\nconfigured for either input or output. A specific example of a stream\nobject is the Bio::Structure::IO::pdb object.\n\nEach stream object has functions\n\n   $stream->next_structure();\n\nand\n\n   $stream->write_structure($struc);\n\nalso\n\n   $stream->type() # returns 'INPUT' or 'OUTPUT'\n\nAs an added bonus, you can recover a filehandle that is tied to the\nStructure::IOIO object, allowing you to use the standard E<lt>E<gt>\nand print operations to read and write structure::IOuence objects:\n\n    use Bio::Structure::IO;\n\n    $stream = Bio::Structure::IO->newFh(-format => 'pdb'); # read from standard input\n\n    while ( $structure = <$stream> ) {\n   \t# do something with $structure\n    }\n\nand\n\n    print $stream $structure; # when stream is in output mode\n\n\n=head1 CONSTRUCTORS\n\n=head2 Bio::Structure::IO-E<gt>new()\n\n   $stream = Bio::Structure::IO->new(-file => 'filename',   -format=>$format);\n   $stream = Bio::Structure::IO->new(-fh   => \\*FILEHANDLE, -format=>$format);\n   $stream = Bio::Structure::IO->new(-format => $format);\n\nThe new() class method constructs a new Bio::Structure::IO object. The\nreturned object can be used to retrieve or print Bio::Structure\nobjects.  new() accepts the following parameters:\n\n=over 4\n\n* -file\n\nA file path to be opened for reading or writing.  The usual Perl\nconventions apply:\n\n   'file'       # open file for reading\n   '>file'      # open file for writing\n   '>>file'     # open file for appending\n   '+<file'     # open file read/write\n   'command |'  # open a pipe from the command\n   '| command'  # open a pipe to the command\n\n* -fh\n\nYou may provide new() with a previously-opened filehandle.  For\nexample, to read from STDIN:\n\n   $strucIO = Bio::Structure::IO->new(-fh => \\*STDIN);\n\nNote that you must pass filehandles as references to globs.\n\nIf neither a filehandle nor a filename is specified, then the module\nwill read from the @ARGV array or STDIN, using the familiar E<lt>E<gt>\nsemantics.\n\n* -format\n\nSpecify the format of the file.  Supported formats include:\n\n   pdb         Protein Data Bank format\n\nIf no format is specified and a filename is given, then the module\nwill attempt to deduce it from the filename.  If this is unsuccessful,\nPDB format is assumed.\n\nThe format name is case insensitive.  'PDB', 'Pdb' and 'pdb' are\nall supported.\n\n\n=head2 Bio::Structure::IO-E<gt>newFh()\n\n   $fh = Bio::Structure::IO->newFh(-fh   => \\*FILEHANDLE, -format=>$format);\n   $fh = Bio::Structure::IO->newFh(-format => $format);\n   # etc.\n\nThis constructor behaves like new(), but returns a tied filehandle\nrather than a Bio::Structure::IO object.  You can read structures from this\nobject using the familiar E<lt>E<gt> operator, and write to it using\nprint().  The usual array and $_ semantics work.  For example, you can\nread all structure objects into an array like this:\n\n  @structures = <$fh>;\n\nOther operations, such as read(), sysread(), write(), close(), and printf()\nare not supported.\n\n=head1 OBJECT METHODS\n\nSee below for more detailed summaries.  The main methods are:\n\n=head2 $structure = $structIO-E<gt>next_structure()\n\nFetch the next structure from the stream.\n\n=head2 $structIO-E<gt>write_structure($struc [,$another_struc,...])\n\nWrite the specified structure(s) to the stream.\n\n=head2 TIEHANDLE(), READLINE(), PRINT()\n\nThese provide the tie interface.  See L<perltie> for more details.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.\nBug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS - Ewan Birney, Lincoln Stein, Kris Boulez\n\nEmail birney@ebi.ac.uk, lstein@cshl.org, kris.boulez@algonomics.com\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Structure::IO;\n\nuse strict;\n\nuse Bio::PrimarySeq;\nuse Symbol;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\n=head2 new\n\n Title   : new\n Usage   : $stream = Bio::Structure::IO->new(-file => $filename, -format => 'Format')\n Function: Returns a new structIOstream\n Returns : A Bio::Structure::IO handler initialised with the appropriate format\n Args    : -file => $filename\n           -format => format\n           -fh => filehandle to attach to\n\n\nmy $entry = 0;\n\nsub new {\n    my ($caller,@args) = @_;\n    my $class = ref($caller) || $caller;\n\n    # or do we want to call SUPER on an object if $caller is an\n    # object?\n    if( $class =~ /Bio::Structure::IO::(\\S+)/ ) {\n\tmy ($self) = $class->SUPER::new(@args);\n\t$self->_initialize(@args);\n\treturn $self;\n    } else {\n\n\tmy %param = @args;\n\t@param{ map { lc $_ } keys %param } = values %param; # lowercase keys\n\tmy $format = $param{'-format'} ||\n\t    $class->_guess_format( $param{-file} || $ARGV[0] ) ||\n\t\t'pdb';\n\t$format = \"\\L$format\";\t# normalize capitalization to lower case\n\n\t# normalize capitalization\n\treturn unless( &_load_format_module($format) );\n\treturn \"Bio::Structure::IO::$format\"->new(@args);\n    }\n}\n\n=head2 newFh\n\n Title   : newFh\n Usage   : $fh = Bio::Structure::IO->newFh(-file=>$filename,-format=>'Format')\n Function: does a new() followed by an fh()\n Example : $fh = Bio::Structure::IO->newFh(-file=>$filename,-format=>'Format')\n           $structure = <$fh>;   # read a structure object\n           print $fh $structure; # write a structure object\n Returns : filehandle tied to the Bio::Structure::IO::Fh class\n Args    :\n\n\nsub newFh {\n  my $class = shift;\n  return unless my $self = $class->new(@_);\n  return $self->fh;\n}\n\n=head2 fh\n\n Title   : fh\n Usage   : $obj->fh\n Function:\n Example : $fh = $obj->fh;      # make a tied filehandle\n           $structure = <$fh>;   # read a structure object\n           print $fh $structure; # write a structure object\n Returns : filehandle tied to the Bio::Structure::IO::Fh class\n Args    :\n\n\n\nsub fh {\n  my $self = shift;\n  my $class = ref($self) || $self;\n  my $s = Symbol::gensym;\n  tie $$s,$class,$self;\n  return $s;\n}\n\n\n# _initialize is chained for all SeqIO classes\n\nsub _initialize {\n    my($self, @args) = @_;\n\n    # not really necessary unless we put more in RootI\n    $self->SUPER::_initialize(@args);\n\n    # initialize the IO part\n    $self->_initialize_io(@args);\n}\n\n=head2 next_structure\n\n Title   : next_structure\n Usage   : $structure = stream->next_structure\n Function: Reads the next structure object from the stream and returns a\n           Bio::Structure::Entry object.\n\n           Certain driver modules may encounter entries in the stream that\n           are either misformatted or that use syntax not yet understood\n           by the driver. If such an incident is recoverable, e.g., by\n           dismissing a feature of a feature table or some other non-mandatory\n           part of an entry, the driver will issue a warning. In the case\n           of a non-recoverable situation an exception will be thrown.\n           Do not assume that you can resume parsing the same stream after\n           catching the exception. Note that you can always turn recoverable\n           errors into exceptions by calling $stream->verbose(2) (see\n           Bio::RootI POD page).\n Returns : a Bio::Structure::Entry object\n Args    : none\n\n\nsub next_structure {\n   my ($self, $struc) = @_;\n   $self->throw(\"Sorry, you cannot read from a generic Bio::Structure::IO object.\");\n}\n\n# Do we want people to read out the sequence directly from a $structIO stream\n#\n##=head2 next_primary_seq\n##\n## Title   : next_primary_seq\n## Usage   : $seq = $stream->next_primary_seq\n## Function: Provides a primaryseq type of sequence object\n## Returns : A Bio::PrimarySeqI object\n## Args    : none\n##\n##\n##=cut\n##\n##sub next_primary_seq {\n##   my ($self) = @_;\n##\n##   # in this case, we default to next_seq. This is because\n##   # Bio::Seq's are Bio::PrimarySeqI objects. However we\n##   # expect certain sub classes to override this method to provide\n##   # less parsing heavy methods to retrieving the objects\n##\n##   return $self->next_seq();\n##}\n\n=head2 write_structure\n\n Title   : write_structure\n Usage   : $stream->write_structure($structure)\n Function: writes the $structure object into the stream\n Returns : 1 for success and 0 for error\n Args    : Bio::Structure object\n\n\nsub write_seq {\n    my ($self, $struc) = @_;\n    $self->throw(\"Sorry, you cannot write to a generic Bio::Structure::IO object.\");\n}\n\n\n# De we need this here\n#\n##=head2 alphabet\n##\n## Title   : alphabet\n## Usage   : $self->alphabet($newval)\n## Function: Set/get the molecule type for the Seq objects to be created.\n## Example : $seqio->alphabet('protein')\n## Returns : value of alphabet: 'dna', 'rna', or 'protein'\n## Args    : newvalue (optional)\n## Throws  : Exception if the argument is not one of 'dna', 'rna', or 'protein'\n##\n##=cut\n##\n##sub alphabet {\n##   my ($self, $value) = @_;\n##\n##   if ( defined $value) {\n##       # instead of hard-coding the allowed values once more, we check by\n##       # creating a dummy sequence object\n##       eval {\n##\t   my $seq = Bio::PrimarySeq->new('-alphabet' => $value);\n##       };\n##       if($@) {\n##\t   $self->throw(\"Invalid alphabet: $value\\n. See Bio::PrimarySeq for allowed values.\");\n##       }\n##       $self->{'alphabet'} = \"\\L$value\";\n##   }\n##   return $self->{'alphabet'};\n##}\n\n=head2 _load_format_module\n\n Title   : _load_format_module\n Usage   : *INTERNAL Structure::IO stuff*\n Function: Loads up (like use) a module at run time on demand\n Example :\n Returns :\n Args    :\n\n\nsub _load_format_module {\n  my ($format) = @_;\n  my ($module, $load, $m);\n\n  $module = \"_<Bio/Structure/IO/$format.pm\";\n  $load = \"Bio/Structure/IO/$format.pm\";\n\n  return 1 if $main::{$module};\n  eval {\n    require $load;\n  };\n  if ( $@ ) {\n    print STDERR <<END;\n$load: $format cannot be found\nException $@\nFor more information about the Structure::IO system please see the\nBio::Structure::IO docs.  This includes ways of checking for formats at\ncompile time, not run time\nEND\n  ;\n    return;\n  }\n  return 1;\n}\n\n=head2 _concatenate_lines\n\n Title   : _concatenate_lines\n Usage   : $s = _concatenate_lines($line, $continuation_line)\n Function: Private. Concatenates two strings assuming that the second stems\n           from a continuation line of the first. Adds a space between both\n           unless the first ends with a dash.\n\n           Takes care of either arg being empty.\n Example :\n Returns : A string.\n Args    :\n\n\nsub _concatenate_lines {\n    my ($self, $s1, $s2) = @_;\n    $s1 .= \" \" if($s1 && ($s1 !~ /-$/) && $s2);\n    return ($s1 ? $s1 : \"\") . ($s2 ? $s2 : \"\");\n}\n\n=head2 _filehandle\n\n Title   : _filehandle\n Usage   : $obj->_filehandle($newval)\n Function: This method is deprecated. Call _fh() instead.\n Example :\n Returns : value of _filehandle\n Args    : newvalue (optional)","parameters":[{"label":"$self"},{"label":"@args"}]},"detail":"($self,@args)","definition":"sub","containerName":"main::","range":{"end":{"line":485,"character":9999},"start":{"character":0,"line":482}},"name":"_filehandle"},{"definition":"sub","name":"_guess_format","containerName":"main::","range":{"end":{"character":9999,"line":511},"start":{"line":498,"character":0}},"kind":12,"children":[{"definition":"my","name":"$class","containerName":"_guess_format","localvar":"my","kind":13,"line":499}],"line":498},{"range":{"start":{"line":513,"character":0},"end":{"line":517,"character":9999}},"containerName":"main::","name":"DESTROY","definition":"sub","line":513,"children":[{"kind":13,"line":514,"definition":"my","name":"$self","containerName":"DESTROY","localvar":"my"},{"containerName":"DESTROY","name":"$self","kind":13,"line":516},{"line":516,"kind":12,"name":"close","containerName":"DESTROY"}],"kind":12},{"containerName":"main::","definition":"sub","detail":"($class,$val)","signature":{"label":"TIEHANDLE($class,$val)","parameters":[{"label":"$class"},{"label":"$val"}],"documentation":""},"kind":12,"line":519,"children":[{"name":"$class","definition":"my","containerName":"TIEHANDLE","localvar":"my","kind":13,"line":520},{"kind":13,"line":520,"name":"$val","containerName":"TIEHANDLE"},{"name":"$val","containerName":"TIEHANDLE","kind":13,"line":521},{"kind":13,"line":521,"containerName":"TIEHANDLE","name":"$class"}],"name":"TIEHANDLE","range":{"end":{"character":9999,"line":522},"start":{"character":0,"line":519}}},{"kind":12,"children":[{"kind":13,"line":525,"name":"$self","definition":"my","containerName":"READLINE","localvar":"my"},{"containerName":"READLINE","name":"$self","line":526,"kind":13},{"name":"next_seq","containerName":"READLINE","line":526,"kind":12},{"localvar":"my","containerName":"READLINE","name":"@list","definition":"my","line":527,"kind":13},{"kind":13,"line":527,"containerName":"READLINE","name":"$obj"},{"containerName":"READLINE","name":"@list","line":528,"kind":13},{"containerName":"READLINE","name":"$obj","kind":13,"line":528},{"kind":13,"line":528,"name":"$obj","containerName":"READLINE"},{"containerName":"READLINE","name":"$self","line":528,"kind":13},{"name":"next_seq","containerName":"READLINE","kind":12,"line":528},{"line":529,"kind":13,"name":"@list","containerName":"READLINE"}],"line":524,"definition":"sub","name":"READLINE","containerName":"main::","range":{"end":{"character":9999,"line":530},"start":{"line":524,"character":0}}},{"kind":12,"line":532,"children":[{"kind":13,"line":533,"name":"$self","definition":"my","containerName":"PRINT","localvar":"my"},{"name":"$self","containerName":"PRINT","line":534,"kind":13},{"line":534,"kind":12,"name":"write_seq","containerName":"PRINT"}],"containerName":"main::","name":"PRINT","definition":"sub","range":{"start":{"character":0,"line":532},"end":{"line":535,"character":9999}}}],"version":5}