{"vars":[{"line":92,"kind":2,"name":"base","containerName":""},{"signature":{"label":"_initialize($self,@args)","documentation":"","parameters":[{"label":"$self"},{"label":"@args"}]},"detail":"($self,@args)","definition":"sub","containerName":"main::","children":[{"containerName":"_initialize","name":"$self","definition":"my","localvar":"my","kind":13,"line":95},{"name":"@args","containerName":"_initialize","kind":13,"line":95},{"kind":13,"line":97,"name":"$self","containerName":"_initialize"},{"name":"@args","containerName":"_initialize","kind":13,"line":97},{"line":99,"kind":13,"name":"$self","containerName":"_initialize"},{"line":99,"kind":12,"name":"sequence_factory","containerName":"_initialize"},{"kind":13,"line":100,"name":"$self","containerName":"_initialize"},{"kind":12,"line":100,"containerName":"_initialize","name":"sequence_factory"},{"kind":12,"line":100,"name":"new","containerName":"_initialize"},{"name":"$self","containerName":"_initialize","kind":13,"line":103},{"containerName":"_initialize","name":"$self","kind":13,"line":104}],"line":94,"kind":12,"range":{"end":{"line":105,"character":9999},"start":{"line":94,"character":0}},"name":"_initialize"},{"line":97,"kind":12,"containerName":"_initialize","name":"SUPER"},{"containerName":"Seq::SeqFastaSpeedFactory","name":"Bio","line":100,"kind":12},{"name":"_parsed","line":104,"kind":12},{"name":"next_seq","range":{"end":{"line":122,"character":9999},"start":{"line":117,"character":0}},"kind":12,"line":117,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"next_seq","line":118,"kind":13},{"name":"$self","containerName":"next_seq","line":120,"kind":13},{"kind":12,"line":120,"name":"_get_seqs","containerName":"next_seq"},{"containerName":"next_seq","name":"$self","kind":13,"line":120},{"kind":13,"line":122,"name":"$self","containerName":"next_seq"}],"containerName":"main::","definition":"sub","detail":"($self)","signature":{"label":"next_seq($self)","parameters":[{"label":"$self"}],"documentation":"__END__\n# BioPerl module for Bio::SeqIO::tinyseq\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Donald Jackson, donald.jackson@bms.com\n#\n# Copyright Bristol-Myers Squibb\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::tinyseq - reading/writing sequences in NCBI TinySeq format\n\n=head1 SYNOPSIS\n\nDo not use this module directly; use the SeqIO handler system:\n\n  $stream = Bio::SeqIO->new( -file => $filename, -format => 'tinyseq' );\n\n  while ( my $seq = $stream->next_seq ) {\n    ....\n  }\n\n=head1 DESCRIPTION\n\nThis object reads and writes Bio::Seq objects to and from TinySeq XML\nformat.  A TinySeq is a lightweight XML file of sequence information,\nanalgous to FASTA format.\n\nSee L<http://www.ncbi.nlm.nih.gov/dtd/NCBI_TSeq.mod.dtd> for the DTD.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.bioperl.org\n\n=head1 SEE ALSO\n\nL<Bio::SeqIO>, L<Bio::Seq>.\n\n=head1 AUTHOR\n\nDonald Jackson, E<lt>donald.jackson@bms.comE<gt>\n\nParts of this module and the test script were patterned after Sheldon\nMcKay's L<Bio::SeqIO::game>.  If it breaks, however, it's my fault not\nhis ;).\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::SeqIO::tinyseq;\n\nuse strict;\nuse Bio::Seq::SeqFastaSpeedFactory;\nuse Bio::Species;\nuse Bio::SeqIO::tinyseq::tinyseqHandler;\nuse XML::Parser::PerlSAX;\nuse XML::Writer;\n\nuse base qw(Bio::SeqIO);\n\nsub _initialize {\n    my ($self, @args) = @_;\n\n    $self->SUPER::_initialize(@args);\n\n    unless (defined $self->sequence_factory) {\n\t$self->sequence_factory(Bio::Seq::SeqFastaSpeedFactory->new());\n    }\n\n    $self->{'_species_objects'} = {};\n    $self->{_parsed} = 0;\n}\n\n=head2 next_seq\n\n  Title\t\t: next_seq\n  Usage\t\t: $seq = $stream->next_seq()\n  Function\t: returns the next sequence in the stream\n  Returns\t: Bio::Seq object\n  Args\t\t: NONE"}},{"name":"_parsed","line":120,"kind":12},{"kind":12,"line":122,"name":"_seqlist"},{"signature":{"documentation":"__END__\n# BioPerl module for Bio::SeqIO::tinyseq\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Donald Jackson, donald.jackson@bms.com\n#\n# Copyright Bristol-Myers Squibb\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::tinyseq - reading/writing sequences in NCBI TinySeq format\n\n=head1 SYNOPSIS\n\nDo not use this module directly; use the SeqIO handler system:\n\n  $stream = Bio::SeqIO->new( -file => $filename, -format => 'tinyseq' );\n\n  while ( my $seq = $stream->next_seq ) {\n    ....\n  }\n\n=head1 DESCRIPTION\n\nThis object reads and writes Bio::Seq objects to and from TinySeq XML\nformat.  A TinySeq is a lightweight XML file of sequence information,\nanalgous to FASTA format.\n\nSee L<http://www.ncbi.nlm.nih.gov/dtd/NCBI_TSeq.mod.dtd> for the DTD.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.bioperl.org\n\n=head1 SEE ALSO\n\nL<Bio::SeqIO>, L<Bio::Seq>.\n\n=head1 AUTHOR\n\nDonald Jackson, E<lt>donald.jackson@bms.comE<gt>\n\nParts of this module and the test script were patterned after Sheldon\nMcKay's L<Bio::SeqIO::game>.  If it breaks, however, it's my fault not\nhis ;).\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::SeqIO::tinyseq;\n\nuse strict;\nuse Bio::Seq::SeqFastaSpeedFactory;\nuse Bio::Species;\nuse Bio::SeqIO::tinyseq::tinyseqHandler;\nuse XML::Parser::PerlSAX;\nuse XML::Writer;\n\nuse base qw(Bio::SeqIO);\n\nsub _initialize {\n    my ($self, @args) = @_;\n\n    $self->SUPER::_initialize(@args);\n\n    unless (defined $self->sequence_factory) {\n\t$self->sequence_factory(Bio::Seq::SeqFastaSpeedFactory->new());\n    }\n\n    $self->{'_species_objects'} = {};\n    $self->{_parsed} = 0;\n}\n\n=head2 next_seq\n\n  Title\t\t: next_seq\n  Usage\t\t: $seq = $stream->next_seq()\n  Function\t: returns the next sequence in the stream\n  Returns\t: Bio::Seq object\n  Args\t\t: NONE\n\n\nsub next_seq {\n    my ($self) = @_;\n\n    $self->_get_seqs() unless ($self->{_parsed});\n\n    return shift @{$self->{_seqlist}};\n}\n\n=head2 write_seq\n\n  Title\t\t: write_seq\n  Usage\t\t: $seq = $stream->write_seq(@sequence_objects); undef $stream\n  Function\t: outputs one or more sequence objects as TinySeq XML\n  Returns\t: 1 on success\n  Args\t\t: one or more sequence objects as TinySeq XML\n\nBecause the TSeq dtd includes closing tags after all sets are written,\nthe output will not be complete until the program terminates or the\nobject is forced out of scope (see close_writer()).  May not perfectly\nreproduce TSeq_sid element for all sequences","parameters":[{"label":"$self"},{"label":"@seqobjs"}],"label":"write_seq($self,@seqobjs)"},"detail":"($self,@seqobjs)","definition":"sub","containerName":"main::","children":[{"line":141,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"write_seq"},{"containerName":"write_seq","name":"@seqobjs","kind":13,"line":141},{"kind":13,"line":143,"name":"$self","containerName":"write_seq"},{"containerName":"write_seq","name":"throw","kind":12,"line":143},{"name":"@seqobjs","containerName":"write_seq","line":144,"kind":13},{"kind":13,"line":144,"name":"$seqobjs","containerName":"write_seq"},{"containerName":"write_seq","name":"isa","line":144,"kind":12},{"name":"$seqobjs","containerName":"write_seq","kind":13,"line":144},{"kind":12,"line":144,"containerName":"write_seq","name":"isa"},{"containerName":"write_seq","definition":"my","name":"$writer","localvar":"my","kind":13,"line":146},{"line":146,"kind":13,"name":"$self","containerName":"write_seq"},{"containerName":"write_seq","name":"_get_writer","line":146,"kind":12},{"line":148,"kind":13,"localvar":"my","name":"$seqobj","definition":"my","containerName":"write_seq"},{"line":148,"kind":13,"name":"@seqobjs","containerName":"write_seq"},{"line":149,"kind":13,"localvar":"my","containerName":"write_seq","name":"$id_element","definition":"my"},{"line":149,"kind":13,"containerName":"write_seq","name":"$id_value"},{"line":149,"kind":13,"containerName":"write_seq","name":"$self"},{"line":149,"kind":12,"name":"_get_idstring","containerName":"write_seq"},{"name":"$seqobj","containerName":"write_seq","line":149,"kind":13},{"containerName":"write_seq","name":"$writer","line":150,"kind":13},{"name":"startTag","containerName":"write_seq","kind":12,"line":150},{"containerName":"write_seq","name":"$writer","kind":13,"line":151},{"kind":12,"line":151,"containerName":"write_seq","name":"emptyTag"},{"line":151,"kind":13,"containerName":"write_seq","name":"$self"},{"containerName":"write_seq","name":"_convert_seqtype","kind":12,"line":151},{"kind":13,"line":151,"containerName":"write_seq","name":"$seqobj"},{"name":"$writer","containerName":"write_seq","kind":13,"line":152},{"containerName":"write_seq","name":"dataElement","kind":12,"line":152},{"containerName":"write_seq","name":"$seqobj","kind":13,"line":152},{"line":152,"kind":12,"containerName":"write_seq","name":"primary_id"},{"line":153,"kind":13,"containerName":"write_seq","name":"$writer"},{"kind":12,"line":153,"containerName":"write_seq","name":"dataElement"},{"kind":13,"line":153,"name":"$id_element","containerName":"write_seq"},{"line":153,"kind":13,"name":"$id_value","containerName":"write_seq"},{"containerName":"write_seq","name":"$writer","kind":13,"line":155},{"kind":12,"line":155,"name":"dataElement","containerName":"write_seq"},{"line":155,"kind":13,"name":"$seqobj","containerName":"write_seq"},{"containerName":"write_seq","name":"desc","line":155,"kind":12},{"line":156,"kind":13,"containerName":"write_seq","name":"$writer"},{"name":"dataElement","containerName":"write_seq","kind":12,"line":156},{"kind":13,"line":156,"containerName":"write_seq","name":"$seqobj"},{"kind":12,"line":156,"containerName":"write_seq","name":"length"},{"name":"$writer","containerName":"write_seq","kind":13,"line":157},{"name":"dataElement","containerName":"write_seq","line":157,"kind":12},{"name":"$seqobj","containerName":"write_seq","kind":13,"line":157},{"line":157,"kind":12,"name":"seq","containerName":"write_seq"},{"containerName":"write_seq","name":"$seqobj","line":159,"kind":13},{"name":"can","containerName":"write_seq","kind":12,"line":159},{"line":159,"kind":13,"name":"$seqobj","containerName":"write_seq"},{"kind":12,"line":159,"name":"species","containerName":"write_seq"},{"line":160,"kind":13,"name":"$self","containerName":"write_seq"},{"kind":12,"line":160,"name":"_write_species","containerName":"write_seq"},{"containerName":"write_seq","name":"$writer","kind":13,"line":160},{"line":160,"kind":13,"name":"$seqobj","containerName":"write_seq"},{"line":160,"kind":12,"name":"species","containerName":"write_seq"},{"line":163,"kind":13,"name":"$writer","containerName":"write_seq"},{"line":163,"kind":12,"containerName":"write_seq","name":"endTag"}],"line":140,"kind":12,"range":{"start":{"character":0,"line":140},"end":{"line":166,"character":9999}},"name":"write_seq"},{"line":151,"kind":12,"name":"value"},{"range":{"start":{"line":181,"character":0},"end":{"character":9999,"line":209}},"name":"_get_seqs","signature":{"documentation":"__END__\n# BioPerl module for Bio::SeqIO::tinyseq\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Donald Jackson, donald.jackson@bms.com\n#\n# Copyright Bristol-Myers Squibb\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::tinyseq - reading/writing sequences in NCBI TinySeq format\n\n=head1 SYNOPSIS\n\nDo not use this module directly; use the SeqIO handler system:\n\n  $stream = Bio::SeqIO->new( -file => $filename, -format => 'tinyseq' );\n\n  while ( my $seq = $stream->next_seq ) {\n    ....\n  }\n\n=head1 DESCRIPTION\n\nThis object reads and writes Bio::Seq objects to and from TinySeq XML\nformat.  A TinySeq is a lightweight XML file of sequence information,\nanalgous to FASTA format.\n\nSee L<http://www.ncbi.nlm.nih.gov/dtd/NCBI_TSeq.mod.dtd> for the DTD.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.bioperl.org\n\n=head1 SEE ALSO\n\nL<Bio::SeqIO>, L<Bio::Seq>.\n\n=head1 AUTHOR\n\nDonald Jackson, E<lt>donald.jackson@bms.comE<gt>\n\nParts of this module and the test script were patterned after Sheldon\nMcKay's L<Bio::SeqIO::game>.  If it breaks, however, it's my fault not\nhis ;).\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::SeqIO::tinyseq;\n\nuse strict;\nuse Bio::Seq::SeqFastaSpeedFactory;\nuse Bio::Species;\nuse Bio::SeqIO::tinyseq::tinyseqHandler;\nuse XML::Parser::PerlSAX;\nuse XML::Writer;\n\nuse base qw(Bio::SeqIO);\n\nsub _initialize {\n    my ($self, @args) = @_;\n\n    $self->SUPER::_initialize(@args);\n\n    unless (defined $self->sequence_factory) {\n\t$self->sequence_factory(Bio::Seq::SeqFastaSpeedFactory->new());\n    }\n\n    $self->{'_species_objects'} = {};\n    $self->{_parsed} = 0;\n}\n\n=head2 next_seq\n\n  Title\t\t: next_seq\n  Usage\t\t: $seq = $stream->next_seq()\n  Function\t: returns the next sequence in the stream\n  Returns\t: Bio::Seq object\n  Args\t\t: NONE\n\n\nsub next_seq {\n    my ($self) = @_;\n\n    $self->_get_seqs() unless ($self->{_parsed});\n\n    return shift @{$self->{_seqlist}};\n}\n\n=head2 write_seq\n\n  Title\t\t: write_seq\n  Usage\t\t: $seq = $stream->write_seq(@sequence_objects); undef $stream\n  Function\t: outputs one or more sequence objects as TinySeq XML\n  Returns\t: 1 on success\n  Args\t\t: one or more sequence objects as TinySeq XML\n\nBecause the TSeq dtd includes closing tags after all sets are written,\nthe output will not be complete until the program terminates or the\nobject is forced out of scope (see close_writer()).  May not perfectly\nreproduce TSeq_sid element for all sequences\n\n\nsub write_seq {\n    my ($self, @seqobjs) = @_;\n\n    $self->throw('write_seq must be called with at least one  Bio::SeqI or Bio::PrimarySeqI compliant object')\n\tunless (@seqobjs and ( $seqobjs[0]->isa('Bio::SeqI') || $seqobjs[0]->isa('Bio::PrimarySeqI')));\n\n    my $writer = $self->_get_writer;\n\n    foreach my $seqobj (@seqobjs) {\n\tmy ($id_element, $id_value) = $self->_get_idstring($seqobj);\n \t$writer->startTag('TSeq');\n\t$writer->emptyTag('TSeq_seqtype', value => $self->_convert_seqtype($seqobj));\n\t$writer->dataElement('TSeq_gi', $seqobj->primary_id || '');\n\t$writer->dataElement($id_element, $id_value);\n\t#$writer->dataElement('TSeq_orgname', $seqobj->taxid) if ($seqobj->can('taxid'); # just a placeholder\n\t$writer->dataElement('TSeq_defline', $seqobj->desc);\n\t$writer->dataElement('TSeq_length', $seqobj->length);\n\t$writer->dataElement('TSeq_sequence', $seqobj->seq);\n\n\tif ($seqobj->can('species') && $seqobj->species) {\n\t    $self->_write_species($writer, $seqobj->species);\n\t}\n\n\t$writer->endTag('TSeq');\n    }\n    1;\n}\n\n=head2 _get_seqs\n\n  Title\t\t: _get_seqs\n  Usage\t\t: Internal function - use next_seq() instead\n  Function\t: parses the XML and creates Bio::Seq objects\n  Returns\t: 1 on success\n  Args\t\t: NONE\n\nCurrently stores all sequence objects into memory.  I will work on do\nmore of a stream-based approach","parameters":[{"label":"$self"}],"label":"_get_seqs($self)"},"detail":"($self)","definition":"sub","containerName":"main::","children":[{"line":182,"kind":13,"localvar":"my","containerName":"_get_seqs","name":"$self","definition":"my"},{"kind":13,"line":184,"definition":"my","name":"$fh","containerName":"_get_seqs","localvar":"my"},{"line":184,"kind":13,"containerName":"_get_seqs","name":"$self"},{"line":184,"kind":12,"containerName":"_get_seqs","name":"_fh"},{"line":186,"kind":13,"localvar":"my","definition":"my","name":"$handler","containerName":"_get_seqs"},{"kind":12,"line":186,"name":"new","containerName":"_get_seqs"},{"containerName":"_get_seqs","name":"$parser","definition":"my","localvar":"my","kind":13,"line":187},{"containerName":"_get_seqs","name":"new","line":187,"kind":12},{"containerName":"_get_seqs","name":"$handler","kind":13,"line":187},{"localvar":"my","name":"@seqatts","definition":"my","containerName":"_get_seqs","line":189,"kind":13},{"name":"$parser","containerName":"_get_seqs","kind":13,"line":189},{"containerName":"_get_seqs","name":"parse","kind":12,"line":189},{"line":189,"kind":13,"containerName":"_get_seqs","name":"$fh"},{"line":191,"kind":13,"localvar":"my","containerName":"_get_seqs","definition":"my","name":"$factory"},{"name":"$self","containerName":"_get_seqs","kind":13,"line":191},{"line":191,"kind":12,"name":"sequence_factory","containerName":"_get_seqs"},{"line":193,"kind":13,"name":"$self","containerName":"_get_seqs"},{"localvar":"my","definition":"my","name":"$seqatt","containerName":"_get_seqs","line":194,"kind":13},{"line":194,"kind":13,"name":"@seqatts","containerName":"_get_seqs"},{"containerName":"_get_seqs","name":"$subatt","definition":"my","localvar":"my","kind":13,"line":195},{"line":195,"kind":13,"name":"$seqatt","containerName":"_get_seqs"},{"kind":13,"line":196,"name":"$seqobj","definition":"my","containerName":"_get_seqs","localvar":"my"},{"containerName":"_get_seqs","name":"$factory","kind":13,"line":196},{"line":196,"kind":12,"name":"create","containerName":"_get_seqs"},{"line":196,"kind":13,"name":"$subatt","containerName":"_get_seqs"},{"containerName":"_get_seqs","name":"$self","line":197,"kind":13},{"containerName":"_get_seqs","name":"_assign_identifier","line":197,"kind":12},{"kind":13,"line":197,"containerName":"_get_seqs","name":"$seqobj"},{"name":"$subatt","containerName":"_get_seqs","kind":13,"line":197},{"containerName":"_get_seqs","name":"$seqobj","line":199,"kind":13},{"containerName":"_get_seqs","name":"can","line":199,"kind":12},{"containerName":"_get_seqs","definition":"my","name":"$species","localvar":"my","kind":13,"line":203},{"name":"$self","containerName":"_get_seqs","line":203,"kind":13},{"name":"_get_species","containerName":"_get_seqs","kind":12,"line":203},{"line":203,"kind":13,"containerName":"_get_seqs","name":"$subatt"},{"kind":13,"line":203,"containerName":"_get_seqs","name":"$subatt"},{"kind":13,"line":204,"name":"$seqobj","containerName":"_get_seqs"},{"kind":12,"line":204,"name":"species","containerName":"_get_seqs"},{"name":"$species","containerName":"_get_seqs","kind":13,"line":204},{"name":"$species","containerName":"_get_seqs","line":204,"kind":13},{"name":"$self","containerName":"_get_seqs","kind":13,"line":207},{"name":"$seqobj","containerName":"_get_seqs","kind":13,"line":207}],"line":181,"kind":12},{"containerName":"SeqIO::tinyseq::tinyseqHandler","name":"Bio","kind":12,"line":186},{"kind":12,"line":187,"containerName":"Parser::PerlSAX","name":"XML"},{"kind":12,"line":187,"name":"Handler"},{"name":"Source","kind":12,"line":189},{"line":189,"kind":12,"name":"ByteStream"},{"name":"_seqlist","kind":12,"line":193},{"kind":12,"line":207,"name":"_seqlist"},{"containerName":null,"name":"%self","line":210,"kind":13},{"name":"_parsed","kind":12,"line":210},{"line":226,"children":[{"kind":13,"line":227,"name":"$self","definition":"my","containerName":"_get_species","localvar":"my"},{"containerName":"_get_species","name":"$orgname","kind":13,"line":227},{"line":227,"kind":13,"containerName":"_get_species","name":"$taxid"},{"containerName":"_get_species","name":"$self","line":229,"kind":13},{"kind":13,"line":229,"name":"$orgname","containerName":"_get_species"},{"localvar":"my","definition":"my","name":"$species","containerName":"_get_species","line":230,"kind":13},{"name":"$self","containerName":"_get_species","line":230,"kind":13},{"line":230,"kind":12,"name":"_create_species","containerName":"_get_species"},{"kind":13,"line":230,"containerName":"_get_species","name":"$orgname"},{"line":230,"kind":13,"name":"$taxid","containerName":"_get_species"},{"kind":13,"line":231,"containerName":"_get_species","name":"$self"},{"name":"$orgname","containerName":"_get_species","kind":13,"line":231},{"kind":13,"line":231,"containerName":"_get_species","name":"$species"},{"containerName":"_get_species","name":"$self","line":233,"kind":13},{"name":"$orgname","containerName":"_get_species","kind":13,"line":233}],"kind":12,"detail":"($self,$orgname,$taxid)","signature":{"label":"_get_species($self,$orgname,$taxid)","documentation":"__END__\n# BioPerl module for Bio::SeqIO::tinyseq\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Donald Jackson, donald.jackson@bms.com\n#\n# Copyright Bristol-Myers Squibb\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::tinyseq - reading/writing sequences in NCBI TinySeq format\n\n=head1 SYNOPSIS\n\nDo not use this module directly; use the SeqIO handler system:\n\n  $stream = Bio::SeqIO->new( -file => $filename, -format => 'tinyseq' );\n\n  while ( my $seq = $stream->next_seq ) {\n    ....\n  }\n\n=head1 DESCRIPTION\n\nThis object reads and writes Bio::Seq objects to and from TinySeq XML\nformat.  A TinySeq is a lightweight XML file of sequence information,\nanalgous to FASTA format.\n\nSee L<http://www.ncbi.nlm.nih.gov/dtd/NCBI_TSeq.mod.dtd> for the DTD.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.bioperl.org\n\n=head1 SEE ALSO\n\nL<Bio::SeqIO>, L<Bio::Seq>.\n\n=head1 AUTHOR\n\nDonald Jackson, E<lt>donald.jackson@bms.comE<gt>\n\nParts of this module and the test script were patterned after Sheldon\nMcKay's L<Bio::SeqIO::game>.  If it breaks, however, it's my fault not\nhis ;).\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::SeqIO::tinyseq;\n\nuse strict;\nuse Bio::Seq::SeqFastaSpeedFactory;\nuse Bio::Species;\nuse Bio::SeqIO::tinyseq::tinyseqHandler;\nuse XML::Parser::PerlSAX;\nuse XML::Writer;\n\nuse base qw(Bio::SeqIO);\n\nsub _initialize {\n    my ($self, @args) = @_;\n\n    $self->SUPER::_initialize(@args);\n\n    unless (defined $self->sequence_factory) {\n\t$self->sequence_factory(Bio::Seq::SeqFastaSpeedFactory->new());\n    }\n\n    $self->{'_species_objects'} = {};\n    $self->{_parsed} = 0;\n}\n\n=head2 next_seq\n\n  Title\t\t: next_seq\n  Usage\t\t: $seq = $stream->next_seq()\n  Function\t: returns the next sequence in the stream\n  Returns\t: Bio::Seq object\n  Args\t\t: NONE\n\n\nsub next_seq {\n    my ($self) = @_;\n\n    $self->_get_seqs() unless ($self->{_parsed});\n\n    return shift @{$self->{_seqlist}};\n}\n\n=head2 write_seq\n\n  Title\t\t: write_seq\n  Usage\t\t: $seq = $stream->write_seq(@sequence_objects); undef $stream\n  Function\t: outputs one or more sequence objects as TinySeq XML\n  Returns\t: 1 on success\n  Args\t\t: one or more sequence objects as TinySeq XML\n\nBecause the TSeq dtd includes closing tags after all sets are written,\nthe output will not be complete until the program terminates or the\nobject is forced out of scope (see close_writer()).  May not perfectly\nreproduce TSeq_sid element for all sequences\n\n\nsub write_seq {\n    my ($self, @seqobjs) = @_;\n\n    $self->throw('write_seq must be called with at least one  Bio::SeqI or Bio::PrimarySeqI compliant object')\n\tunless (@seqobjs and ( $seqobjs[0]->isa('Bio::SeqI') || $seqobjs[0]->isa('Bio::PrimarySeqI')));\n\n    my $writer = $self->_get_writer;\n\n    foreach my $seqobj (@seqobjs) {\n\tmy ($id_element, $id_value) = $self->_get_idstring($seqobj);\n \t$writer->startTag('TSeq');\n\t$writer->emptyTag('TSeq_seqtype', value => $self->_convert_seqtype($seqobj));\n\t$writer->dataElement('TSeq_gi', $seqobj->primary_id || '');\n\t$writer->dataElement($id_element, $id_value);\n\t#$writer->dataElement('TSeq_orgname', $seqobj->taxid) if ($seqobj->can('taxid'); # just a placeholder\n\t$writer->dataElement('TSeq_defline', $seqobj->desc);\n\t$writer->dataElement('TSeq_length', $seqobj->length);\n\t$writer->dataElement('TSeq_sequence', $seqobj->seq);\n\n\tif ($seqobj->can('species') && $seqobj->species) {\n\t    $self->_write_species($writer, $seqobj->species);\n\t}\n\n\t$writer->endTag('TSeq');\n    }\n    1;\n}\n\n=head2 _get_seqs\n\n  Title\t\t: _get_seqs\n  Usage\t\t: Internal function - use next_seq() instead\n  Function\t: parses the XML and creates Bio::Seq objects\n  Returns\t: 1 on success\n  Args\t\t: NONE\n\nCurrently stores all sequence objects into memory.  I will work on do\nmore of a stream-based approach\n\n\nsub _get_seqs {\n    my ($self) = @_;\n\n    my $fh = $self->_fh;\n\n    my $handler = Bio::SeqIO::tinyseq::tinyseqHandler->new();\n    my $parser = XML::Parser::PerlSAX->new( Handler => $handler );\n\n    my @seqatts = $parser->parse( Source => { ByteStream => $fh });\n\n    my $factory = $self->sequence_factory;\n\n    $self->{_seqlist} ||= [];\n    foreach my $seqatt(@seqatts) {\n\tforeach my $subatt(@$seqatt) { # why are there two hashes?\n\t    my $seqobj = $factory->create(%$subatt);\n\t    $self->_assign_identifier($seqobj, $subatt);\n\n\t    if ($seqobj->can('species')) {\n# \t\tmy $class = [reverse(split(/ /, $subatt->{'-organism'}))];\n# \t\tmy $species = Bio::Species->new( -classification\t=> $class,\n# \t\t\t\t\t\t -ncbi_taxid\t\t=> $subatt->{'-taxid'} );\n\t\tmy $species = $self->_get_species($subatt->{'-organism'}, $subatt->{'-taxid'});\n\t\t$seqobj->species($species) if ($species);\n\t    }\n\n\t    push(@{$self->{_seqlist}}, $seqobj);\n\t}\n    }\n    $self->{_parsed} = 1;\n}\n\n=head2 _get_species\n\n  Title\t\t: _get_species\n  Usage\t\t: Internal function\n  Function\t: gets a Bio::Species object from cache or creates as needed\n  Returns\t: a Bio::Species object on success, undef on failure\n  Args\t\t: a classification string (eg 'Homo sapiens') and\n                  a NCBI taxon id (optional)\n\nObjects are cached for parsing multiple sequence files.","parameters":[{"label":"$self"},{"label":"$orgname"},{"label":"$taxid"}]},"containerName":"main::","definition":"sub","range":{"start":{"line":226,"character":0},"end":{"line":234,"character":9999}},"name":"_get_species"},{"name":"_create_species","range":{"start":{"line":247,"character":0},"end":{"line":259,"character":9999}},"kind":12,"line":247,"children":[{"containerName":"_create_species","definition":"my","name":"$self","localvar":"my","kind":13,"line":248},{"name":"$orgname","containerName":"_create_species","kind":13,"line":248},{"name":"$taxid","containerName":"_create_species","line":248,"kind":13},{"kind":13,"line":249,"name":"$orgname","containerName":"_create_species"},{"line":251,"kind":13,"localvar":"my","definition":"my","name":"%params","containerName":"_create_species"},{"name":"$params","containerName":"_create_species","line":252,"kind":13},{"line":252,"kind":13,"name":"$orgname","containerName":"_create_species"},{"line":253,"kind":13,"name":"$params","containerName":"_create_species"},{"kind":13,"line":253,"name":"$taxid","containerName":"_create_species"},{"containerName":"_create_species","name":"$taxid","kind":13,"line":253},{"localvar":"my","definition":"my","name":"$species","containerName":"_create_species","line":255,"kind":13},{"line":255,"kind":12,"containerName":"_create_species","name":"new"},{"containerName":"_create_species","name":"%params","line":255,"kind":13},{"name":"$species","containerName":"_create_species","kind":13,"line":258}],"containerName":"main::","definition":"sub","detail":"($self,$orgname,$taxid)","signature":{"label":"_create_species($self,$orgname,$taxid)","documentation":"__END__\n# BioPerl module for Bio::SeqIO::tinyseq\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Donald Jackson, donald.jackson@bms.com\n#\n# Copyright Bristol-Myers Squibb\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::tinyseq - reading/writing sequences in NCBI TinySeq format\n\n=head1 SYNOPSIS\n\nDo not use this module directly; use the SeqIO handler system:\n\n  $stream = Bio::SeqIO->new( -file => $filename, -format => 'tinyseq' );\n\n  while ( my $seq = $stream->next_seq ) {\n    ....\n  }\n\n=head1 DESCRIPTION\n\nThis object reads and writes Bio::Seq objects to and from TinySeq XML\nformat.  A TinySeq is a lightweight XML file of sequence information,\nanalgous to FASTA format.\n\nSee L<http://www.ncbi.nlm.nih.gov/dtd/NCBI_TSeq.mod.dtd> for the DTD.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.bioperl.org\n\n=head1 SEE ALSO\n\nL<Bio::SeqIO>, L<Bio::Seq>.\n\n=head1 AUTHOR\n\nDonald Jackson, E<lt>donald.jackson@bms.comE<gt>\n\nParts of this module and the test script were patterned after Sheldon\nMcKay's L<Bio::SeqIO::game>.  If it breaks, however, it's my fault not\nhis ;).\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::SeqIO::tinyseq;\n\nuse strict;\nuse Bio::Seq::SeqFastaSpeedFactory;\nuse Bio::Species;\nuse Bio::SeqIO::tinyseq::tinyseqHandler;\nuse XML::Parser::PerlSAX;\nuse XML::Writer;\n\nuse base qw(Bio::SeqIO);\n\nsub _initialize {\n    my ($self, @args) = @_;\n\n    $self->SUPER::_initialize(@args);\n\n    unless (defined $self->sequence_factory) {\n\t$self->sequence_factory(Bio::Seq::SeqFastaSpeedFactory->new());\n    }\n\n    $self->{'_species_objects'} = {};\n    $self->{_parsed} = 0;\n}\n\n=head2 next_seq\n\n  Title\t\t: next_seq\n  Usage\t\t: $seq = $stream->next_seq()\n  Function\t: returns the next sequence in the stream\n  Returns\t: Bio::Seq object\n  Args\t\t: NONE\n\n\nsub next_seq {\n    my ($self) = @_;\n\n    $self->_get_seqs() unless ($self->{_parsed});\n\n    return shift @{$self->{_seqlist}};\n}\n\n=head2 write_seq\n\n  Title\t\t: write_seq\n  Usage\t\t: $seq = $stream->write_seq(@sequence_objects); undef $stream\n  Function\t: outputs one or more sequence objects as TinySeq XML\n  Returns\t: 1 on success\n  Args\t\t: one or more sequence objects as TinySeq XML\n\nBecause the TSeq dtd includes closing tags after all sets are written,\nthe output will not be complete until the program terminates or the\nobject is forced out of scope (see close_writer()).  May not perfectly\nreproduce TSeq_sid element for all sequences\n\n\nsub write_seq {\n    my ($self, @seqobjs) = @_;\n\n    $self->throw('write_seq must be called with at least one  Bio::SeqI or Bio::PrimarySeqI compliant object')\n\tunless (@seqobjs and ( $seqobjs[0]->isa('Bio::SeqI') || $seqobjs[0]->isa('Bio::PrimarySeqI')));\n\n    my $writer = $self->_get_writer;\n\n    foreach my $seqobj (@seqobjs) {\n\tmy ($id_element, $id_value) = $self->_get_idstring($seqobj);\n \t$writer->startTag('TSeq');\n\t$writer->emptyTag('TSeq_seqtype', value => $self->_convert_seqtype($seqobj));\n\t$writer->dataElement('TSeq_gi', $seqobj->primary_id || '');\n\t$writer->dataElement($id_element, $id_value);\n\t#$writer->dataElement('TSeq_orgname', $seqobj->taxid) if ($seqobj->can('taxid'); # just a placeholder\n\t$writer->dataElement('TSeq_defline', $seqobj->desc);\n\t$writer->dataElement('TSeq_length', $seqobj->length);\n\t$writer->dataElement('TSeq_sequence', $seqobj->seq);\n\n\tif ($seqobj->can('species') && $seqobj->species) {\n\t    $self->_write_species($writer, $seqobj->species);\n\t}\n\n\t$writer->endTag('TSeq');\n    }\n    1;\n}\n\n=head2 _get_seqs\n\n  Title\t\t: _get_seqs\n  Usage\t\t: Internal function - use next_seq() instead\n  Function\t: parses the XML and creates Bio::Seq objects\n  Returns\t: 1 on success\n  Args\t\t: NONE\n\nCurrently stores all sequence objects into memory.  I will work on do\nmore of a stream-based approach\n\n\nsub _get_seqs {\n    my ($self) = @_;\n\n    my $fh = $self->_fh;\n\n    my $handler = Bio::SeqIO::tinyseq::tinyseqHandler->new();\n    my $parser = XML::Parser::PerlSAX->new( Handler => $handler );\n\n    my @seqatts = $parser->parse( Source => { ByteStream => $fh });\n\n    my $factory = $self->sequence_factory;\n\n    $self->{_seqlist} ||= [];\n    foreach my $seqatt(@seqatts) {\n\tforeach my $subatt(@$seqatt) { # why are there two hashes?\n\t    my $seqobj = $factory->create(%$subatt);\n\t    $self->_assign_identifier($seqobj, $subatt);\n\n\t    if ($seqobj->can('species')) {\n# \t\tmy $class = [reverse(split(/ /, $subatt->{'-organism'}))];\n# \t\tmy $species = Bio::Species->new( -classification\t=> $class,\n# \t\t\t\t\t\t -ncbi_taxid\t\t=> $subatt->{'-taxid'} );\n\t\tmy $species = $self->_get_species($subatt->{'-organism'}, $subatt->{'-taxid'});\n\t\t$seqobj->species($species) if ($species);\n\t    }\n\n\t    push(@{$self->{_seqlist}}, $seqobj);\n\t}\n    }\n    $self->{_parsed} = 1;\n}\n\n=head2 _get_species\n\n  Title\t\t: _get_species\n  Usage\t\t: Internal function\n  Function\t: gets a Bio::Species object from cache or creates as needed\n  Returns\t: a Bio::Species object on success, undef on failure\n  Args\t\t: a classification string (eg 'Homo sapiens') and\n                  a NCBI taxon id (optional)\n\nObjects are cached for parsing multiple sequence files.\n\n\nsub _get_species {\n     my ($self, $orgname, $taxid) = @_;\n\n     unless ($self->{'_species_objects'}->{$orgname}) {\n\t my $species = $self->_create_species($orgname, $taxid);\n\t $self->{'_species_objects'}->{$orgname} = $species;\n     }\n     return $self->{'_species_objects'}->{$orgname};\n}\n\n=head2 _create_species\n\n  Title\t\t: _create_species\n  Usage\t\t: Internal function\n  Function\t: creates a Bio::Species object\n  Returns\t: a Bio::Species object on success, undef on failure\n  Args\t\t: a classification string (eg 'Homo sapiens') and\n                  a NCBI taxon id (optional)","parameters":[{"label":"$self"},{"label":"$orgname"},{"label":"$taxid"}]}},{"kind":12,"line":255,"containerName":"Species","name":"Bio"},{"kind":12,"children":[{"kind":13,"line":275,"name":"$self","definition":"my","containerName":"_assign_identifier","localvar":"my"},{"line":275,"kind":13,"containerName":"_assign_identifier","name":"$seqobj"},{"kind":13,"line":275,"containerName":"_assign_identifier","name":"$atts"},{"kind":13,"line":276,"name":"$accession","definition":"my","containerName":"_assign_identifier","localvar":"my"},{"line":276,"kind":13,"containerName":"_assign_identifier","name":"$version"},{"containerName":"_assign_identifier","name":"$atts","kind":13,"line":278},{"containerName":"_assign_identifier","name":"$accession","kind":13,"line":279},{"line":279,"kind":13,"containerName":"_assign_identifier","name":"$version"},{"kind":13,"line":279,"containerName":"_assign_identifier","name":"$atts"},{"name":"$atts","containerName":"_assign_identifier","kind":13,"line":281},{"line":282,"kind":13,"localvar":"my","containerName":"_assign_identifier","name":"$sidstring","definition":"my"},{"name":"$atts","containerName":"_assign_identifier","line":282,"kind":13},{"name":"$sidstring","containerName":"_assign_identifier","line":283,"kind":13},{"line":284,"kind":13,"name":"$sidstring","containerName":"_assign_identifier"},{"containerName":"_assign_identifier","name":"$accession","kind":13,"line":285},{"name":"$version","containerName":"_assign_identifier","line":285,"kind":13},{"kind":13,"line":285,"name":"$sidstring","containerName":"_assign_identifier"},{"containerName":"_assign_identifier","name":"$self","kind":13,"line":288},{"name":"throw","containerName":"_assign_identifier","kind":12,"line":288},{"name":"$seqobj","containerName":"_assign_identifier","kind":13,"line":290},{"containerName":"_assign_identifier","name":"accession_number","kind":12,"line":290},{"line":290,"kind":13,"name":"$accession","containerName":"_assign_identifier"},{"name":"$seqobj","containerName":"_assign_identifier","line":290,"kind":13},{"kind":12,"line":290,"name":"can","containerName":"_assign_identifier"},{"containerName":"_assign_identifier","name":"$seqobj","kind":13,"line":291},{"kind":12,"line":291,"containerName":"_assign_identifier","name":"version"},{"containerName":"_assign_identifier","name":"$version","line":291,"kind":13},{"containerName":"_assign_identifier","name":"$seqobj","line":291,"kind":13},{"line":291,"kind":12,"containerName":"_assign_identifier","name":"can"}],"line":274,"definition":"sub","containerName":"main::","signature":{"documentation":"__END__\n# BioPerl module for Bio::SeqIO::tinyseq\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Donald Jackson, donald.jackson@bms.com\n#\n# Copyright Bristol-Myers Squibb\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::tinyseq - reading/writing sequences in NCBI TinySeq format\n\n=head1 SYNOPSIS\n\nDo not use this module directly; use the SeqIO handler system:\n\n  $stream = Bio::SeqIO->new( -file => $filename, -format => 'tinyseq' );\n\n  while ( my $seq = $stream->next_seq ) {\n    ....\n  }\n\n=head1 DESCRIPTION\n\nThis object reads and writes Bio::Seq objects to and from TinySeq XML\nformat.  A TinySeq is a lightweight XML file of sequence information,\nanalgous to FASTA format.\n\nSee L<http://www.ncbi.nlm.nih.gov/dtd/NCBI_TSeq.mod.dtd> for the DTD.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.bioperl.org\n\n=head1 SEE ALSO\n\nL<Bio::SeqIO>, L<Bio::Seq>.\n\n=head1 AUTHOR\n\nDonald Jackson, E<lt>donald.jackson@bms.comE<gt>\n\nParts of this module and the test script were patterned after Sheldon\nMcKay's L<Bio::SeqIO::game>.  If it breaks, however, it's my fault not\nhis ;).\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::SeqIO::tinyseq;\n\nuse strict;\nuse Bio::Seq::SeqFastaSpeedFactory;\nuse Bio::Species;\nuse Bio::SeqIO::tinyseq::tinyseqHandler;\nuse XML::Parser::PerlSAX;\nuse XML::Writer;\n\nuse base qw(Bio::SeqIO);\n\nsub _initialize {\n    my ($self, @args) = @_;\n\n    $self->SUPER::_initialize(@args);\n\n    unless (defined $self->sequence_factory) {\n\t$self->sequence_factory(Bio::Seq::SeqFastaSpeedFactory->new());\n    }\n\n    $self->{'_species_objects'} = {};\n    $self->{_parsed} = 0;\n}\n\n=head2 next_seq\n\n  Title\t\t: next_seq\n  Usage\t\t: $seq = $stream->next_seq()\n  Function\t: returns the next sequence in the stream\n  Returns\t: Bio::Seq object\n  Args\t\t: NONE\n\n\nsub next_seq {\n    my ($self) = @_;\n\n    $self->_get_seqs() unless ($self->{_parsed});\n\n    return shift @{$self->{_seqlist}};\n}\n\n=head2 write_seq\n\n  Title\t\t: write_seq\n  Usage\t\t: $seq = $stream->write_seq(@sequence_objects); undef $stream\n  Function\t: outputs one or more sequence objects as TinySeq XML\n  Returns\t: 1 on success\n  Args\t\t: one or more sequence objects as TinySeq XML\n\nBecause the TSeq dtd includes closing tags after all sets are written,\nthe output will not be complete until the program terminates or the\nobject is forced out of scope (see close_writer()).  May not perfectly\nreproduce TSeq_sid element for all sequences\n\n\nsub write_seq {\n    my ($self, @seqobjs) = @_;\n\n    $self->throw('write_seq must be called with at least one  Bio::SeqI or Bio::PrimarySeqI compliant object')\n\tunless (@seqobjs and ( $seqobjs[0]->isa('Bio::SeqI') || $seqobjs[0]->isa('Bio::PrimarySeqI')));\n\n    my $writer = $self->_get_writer;\n\n    foreach my $seqobj (@seqobjs) {\n\tmy ($id_element, $id_value) = $self->_get_idstring($seqobj);\n \t$writer->startTag('TSeq');\n\t$writer->emptyTag('TSeq_seqtype', value => $self->_convert_seqtype($seqobj));\n\t$writer->dataElement('TSeq_gi', $seqobj->primary_id || '');\n\t$writer->dataElement($id_element, $id_value);\n\t#$writer->dataElement('TSeq_orgname', $seqobj->taxid) if ($seqobj->can('taxid'); # just a placeholder\n\t$writer->dataElement('TSeq_defline', $seqobj->desc);\n\t$writer->dataElement('TSeq_length', $seqobj->length);\n\t$writer->dataElement('TSeq_sequence', $seqobj->seq);\n\n\tif ($seqobj->can('species') && $seqobj->species) {\n\t    $self->_write_species($writer, $seqobj->species);\n\t}\n\n\t$writer->endTag('TSeq');\n    }\n    1;\n}\n\n=head2 _get_seqs\n\n  Title\t\t: _get_seqs\n  Usage\t\t: Internal function - use next_seq() instead\n  Function\t: parses the XML and creates Bio::Seq objects\n  Returns\t: 1 on success\n  Args\t\t: NONE\n\nCurrently stores all sequence objects into memory.  I will work on do\nmore of a stream-based approach\n\n\nsub _get_seqs {\n    my ($self) = @_;\n\n    my $fh = $self->_fh;\n\n    my $handler = Bio::SeqIO::tinyseq::tinyseqHandler->new();\n    my $parser = XML::Parser::PerlSAX->new( Handler => $handler );\n\n    my @seqatts = $parser->parse( Source => { ByteStream => $fh });\n\n    my $factory = $self->sequence_factory;\n\n    $self->{_seqlist} ||= [];\n    foreach my $seqatt(@seqatts) {\n\tforeach my $subatt(@$seqatt) { # why are there two hashes?\n\t    my $seqobj = $factory->create(%$subatt);\n\t    $self->_assign_identifier($seqobj, $subatt);\n\n\t    if ($seqobj->can('species')) {\n# \t\tmy $class = [reverse(split(/ /, $subatt->{'-organism'}))];\n# \t\tmy $species = Bio::Species->new( -classification\t=> $class,\n# \t\t\t\t\t\t -ncbi_taxid\t\t=> $subatt->{'-taxid'} );\n\t\tmy $species = $self->_get_species($subatt->{'-organism'}, $subatt->{'-taxid'});\n\t\t$seqobj->species($species) if ($species);\n\t    }\n\n\t    push(@{$self->{_seqlist}}, $seqobj);\n\t}\n    }\n    $self->{_parsed} = 1;\n}\n\n=head2 _get_species\n\n  Title\t\t: _get_species\n  Usage\t\t: Internal function\n  Function\t: gets a Bio::Species object from cache or creates as needed\n  Returns\t: a Bio::Species object on success, undef on failure\n  Args\t\t: a classification string (eg 'Homo sapiens') and\n                  a NCBI taxon id (optional)\n\nObjects are cached for parsing multiple sequence files.\n\n\nsub _get_species {\n     my ($self, $orgname, $taxid) = @_;\n\n     unless ($self->{'_species_objects'}->{$orgname}) {\n\t my $species = $self->_create_species($orgname, $taxid);\n\t $self->{'_species_objects'}->{$orgname} = $species;\n     }\n     return $self->{'_species_objects'}->{$orgname};\n}\n\n=head2 _create_species\n\n  Title\t\t: _create_species\n  Usage\t\t: Internal function\n  Function\t: creates a Bio::Species object\n  Returns\t: a Bio::Species object on success, undef on failure\n  Args\t\t: a classification string (eg 'Homo sapiens') and\n                  a NCBI taxon id (optional)\n\n\nsub _create_species {\n    my ($self, $orgname, $taxid) = @_;\n    return unless ($orgname); # not required in TinySeq dtd so don't throw an error\n\n    my %params;\n    $params{'-classification'} = [reverse(split(/ /, $orgname))];\n    $params{'-ncbi_taxid'} = $taxid if ($taxid);\n\n    my $species = Bio::Species->new(%params)\n\tor return;\n\n    return $species;\n}\n\n\n=head2 _assign_identifier\n\n  Title\t\t: _assign_identifier\n  Usage\t\t: Internal function\n  Function\t: looks for sequence accession\n  Returns\t: 1 on success\n  Args\t\t: NONE\n\nNCBI puts refseq accessions in TSeq_sid, others in TSeq_accver.","parameters":[{"label":"$self"},{"label":"$seqobj"},{"label":"$atts"}],"label":"_assign_identifier($self,$seqobj,$atts)"},"detail":"($self,$seqobj,$atts)","name":"_assign_identifier","range":{"end":{"line":293,"character":9999},"start":{"character":0,"line":274}}},{"name":"_convert_seqtype","range":{"start":{"line":304,"character":0},"end":{"line":313,"character":9999}},"definition":"sub","containerName":"main::","signature":{"documentation":"__END__\n# BioPerl module for Bio::SeqIO::tinyseq\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Donald Jackson, donald.jackson@bms.com\n#\n# Copyright Bristol-Myers Squibb\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::tinyseq - reading/writing sequences in NCBI TinySeq format\n\n=head1 SYNOPSIS\n\nDo not use this module directly; use the SeqIO handler system:\n\n  $stream = Bio::SeqIO->new( -file => $filename, -format => 'tinyseq' );\n\n  while ( my $seq = $stream->next_seq ) {\n    ....\n  }\n\n=head1 DESCRIPTION\n\nThis object reads and writes Bio::Seq objects to and from TinySeq XML\nformat.  A TinySeq is a lightweight XML file of sequence information,\nanalgous to FASTA format.\n\nSee L<http://www.ncbi.nlm.nih.gov/dtd/NCBI_TSeq.mod.dtd> for the DTD.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.bioperl.org\n\n=head1 SEE ALSO\n\nL<Bio::SeqIO>, L<Bio::Seq>.\n\n=head1 AUTHOR\n\nDonald Jackson, E<lt>donald.jackson@bms.comE<gt>\n\nParts of this module and the test script were patterned after Sheldon\nMcKay's L<Bio::SeqIO::game>.  If it breaks, however, it's my fault not\nhis ;).\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::SeqIO::tinyseq;\n\nuse strict;\nuse Bio::Seq::SeqFastaSpeedFactory;\nuse Bio::Species;\nuse Bio::SeqIO::tinyseq::tinyseqHandler;\nuse XML::Parser::PerlSAX;\nuse XML::Writer;\n\nuse base qw(Bio::SeqIO);\n\nsub _initialize {\n    my ($self, @args) = @_;\n\n    $self->SUPER::_initialize(@args);\n\n    unless (defined $self->sequence_factory) {\n\t$self->sequence_factory(Bio::Seq::SeqFastaSpeedFactory->new());\n    }\n\n    $self->{'_species_objects'} = {};\n    $self->{_parsed} = 0;\n}\n\n=head2 next_seq\n\n  Title\t\t: next_seq\n  Usage\t\t: $seq = $stream->next_seq()\n  Function\t: returns the next sequence in the stream\n  Returns\t: Bio::Seq object\n  Args\t\t: NONE\n\n\nsub next_seq {\n    my ($self) = @_;\n\n    $self->_get_seqs() unless ($self->{_parsed});\n\n    return shift @{$self->{_seqlist}};\n}\n\n=head2 write_seq\n\n  Title\t\t: write_seq\n  Usage\t\t: $seq = $stream->write_seq(@sequence_objects); undef $stream\n  Function\t: outputs one or more sequence objects as TinySeq XML\n  Returns\t: 1 on success\n  Args\t\t: one or more sequence objects as TinySeq XML\n\nBecause the TSeq dtd includes closing tags after all sets are written,\nthe output will not be complete until the program terminates or the\nobject is forced out of scope (see close_writer()).  May not perfectly\nreproduce TSeq_sid element for all sequences\n\n\nsub write_seq {\n    my ($self, @seqobjs) = @_;\n\n    $self->throw('write_seq must be called with at least one  Bio::SeqI or Bio::PrimarySeqI compliant object')\n\tunless (@seqobjs and ( $seqobjs[0]->isa('Bio::SeqI') || $seqobjs[0]->isa('Bio::PrimarySeqI')));\n\n    my $writer = $self->_get_writer;\n\n    foreach my $seqobj (@seqobjs) {\n\tmy ($id_element, $id_value) = $self->_get_idstring($seqobj);\n \t$writer->startTag('TSeq');\n\t$writer->emptyTag('TSeq_seqtype', value => $self->_convert_seqtype($seqobj));\n\t$writer->dataElement('TSeq_gi', $seqobj->primary_id || '');\n\t$writer->dataElement($id_element, $id_value);\n\t#$writer->dataElement('TSeq_orgname', $seqobj->taxid) if ($seqobj->can('taxid'); # just a placeholder\n\t$writer->dataElement('TSeq_defline', $seqobj->desc);\n\t$writer->dataElement('TSeq_length', $seqobj->length);\n\t$writer->dataElement('TSeq_sequence', $seqobj->seq);\n\n\tif ($seqobj->can('species') && $seqobj->species) {\n\t    $self->_write_species($writer, $seqobj->species);\n\t}\n\n\t$writer->endTag('TSeq');\n    }\n    1;\n}\n\n=head2 _get_seqs\n\n  Title\t\t: _get_seqs\n  Usage\t\t: Internal function - use next_seq() instead\n  Function\t: parses the XML and creates Bio::Seq objects\n  Returns\t: 1 on success\n  Args\t\t: NONE\n\nCurrently stores all sequence objects into memory.  I will work on do\nmore of a stream-based approach\n\n\nsub _get_seqs {\n    my ($self) = @_;\n\n    my $fh = $self->_fh;\n\n    my $handler = Bio::SeqIO::tinyseq::tinyseqHandler->new();\n    my $parser = XML::Parser::PerlSAX->new( Handler => $handler );\n\n    my @seqatts = $parser->parse( Source => { ByteStream => $fh });\n\n    my $factory = $self->sequence_factory;\n\n    $self->{_seqlist} ||= [];\n    foreach my $seqatt(@seqatts) {\n\tforeach my $subatt(@$seqatt) { # why are there two hashes?\n\t    my $seqobj = $factory->create(%$subatt);\n\t    $self->_assign_identifier($seqobj, $subatt);\n\n\t    if ($seqobj->can('species')) {\n# \t\tmy $class = [reverse(split(/ /, $subatt->{'-organism'}))];\n# \t\tmy $species = Bio::Species->new( -classification\t=> $class,\n# \t\t\t\t\t\t -ncbi_taxid\t\t=> $subatt->{'-taxid'} );\n\t\tmy $species = $self->_get_species($subatt->{'-organism'}, $subatt->{'-taxid'});\n\t\t$seqobj->species($species) if ($species);\n\t    }\n\n\t    push(@{$self->{_seqlist}}, $seqobj);\n\t}\n    }\n    $self->{_parsed} = 1;\n}\n\n=head2 _get_species\n\n  Title\t\t: _get_species\n  Usage\t\t: Internal function\n  Function\t: gets a Bio::Species object from cache or creates as needed\n  Returns\t: a Bio::Species object on success, undef on failure\n  Args\t\t: a classification string (eg 'Homo sapiens') and\n                  a NCBI taxon id (optional)\n\nObjects are cached for parsing multiple sequence files.\n\n\nsub _get_species {\n     my ($self, $orgname, $taxid) = @_;\n\n     unless ($self->{'_species_objects'}->{$orgname}) {\n\t my $species = $self->_create_species($orgname, $taxid);\n\t $self->{'_species_objects'}->{$orgname} = $species;\n     }\n     return $self->{'_species_objects'}->{$orgname};\n}\n\n=head2 _create_species\n\n  Title\t\t: _create_species\n  Usage\t\t: Internal function\n  Function\t: creates a Bio::Species object\n  Returns\t: a Bio::Species object on success, undef on failure\n  Args\t\t: a classification string (eg 'Homo sapiens') and\n                  a NCBI taxon id (optional)\n\n\nsub _create_species {\n    my ($self, $orgname, $taxid) = @_;\n    return unless ($orgname); # not required in TinySeq dtd so don't throw an error\n\n    my %params;\n    $params{'-classification'} = [reverse(split(/ /, $orgname))];\n    $params{'-ncbi_taxid'} = $taxid if ($taxid);\n\n    my $species = Bio::Species->new(%params)\n\tor return;\n\n    return $species;\n}\n\n\n=head2 _assign_identifier\n\n  Title\t\t: _assign_identifier\n  Usage\t\t: Internal function\n  Function\t: looks for sequence accession\n  Returns\t: 1 on success\n  Args\t\t: NONE\n\nNCBI puts refseq accessions in TSeq_sid, others in TSeq_accver.\n\n\nsub _assign_identifier {\n    my ($self, $seqobj, $atts) = @_;\n    my ($accession, $version);\n\n   if ($atts->{'-accver'}) {\n\t($accession, $version) = split(/\\./, $atts->{'-accver'});;\n    }\n    elsif ($atts->{'-sid'}) {\n\tmy $sidstring =$atts->{'-sid'};\n\t$sidstring =~ s/^.+?\\|//;\n\t$sidstring =~ s/\\|[^\\|]*//;\n\t($accession, $version) = split(/\\./, $sidstring);;\n    }\n    else {\n\t$self->throw('NO accession information found for this sequence');\n    }\n    $seqobj->accession_number($accession) if ($seqobj->can('accession_number'));\n    $seqobj->version($version) if ($seqobj->can('version'));\n\n}\n\n=head2 _convert_seqtype\n\n  Title\t\t: _convert_seqtype\n  Usage\t\t: Internal function\n  Function\t: maps Bio::Seq::alphabet() values [dna/rna/protein] onto\n                  TSeq_seqtype values [protein/nucleotide]","parameters":[{"label":"$self"},{"label":"$seqobj"}],"label":"_convert_seqtype($self,$seqobj)"},"detail":"($self,$seqobj)","kind":12,"children":[{"line":305,"kind":13,"localvar":"my","containerName":"_convert_seqtype","name":"$self","definition":"my"},{"kind":13,"line":305,"containerName":"_convert_seqtype","name":"$seqobj"},{"kind":13,"line":307,"containerName":"_convert_seqtype","name":"$seqobj"},{"line":307,"kind":12,"name":"alphabet","containerName":"_convert_seqtype"},{"containerName":"_convert_seqtype","name":"$seqobj","line":308,"kind":13},{"line":308,"kind":12,"containerName":"_convert_seqtype","name":"alphabet"},{"line":309,"kind":13,"containerName":"_convert_seqtype","name":"$seqobj"},{"line":309,"kind":12,"name":"alphabet","containerName":"_convert_seqtype"},{"name":"$self","containerName":"_convert_seqtype","kind":13,"line":312},{"name":"throw","containerName":"_convert_seqtype","line":312,"kind":12}],"line":304},{"children":[{"containerName":"_get_idstring","definition":"my","name":"$self","localvar":"my","kind":13,"line":326},{"containerName":"_get_idstring","name":"$seqobj","line":326,"kind":13},{"line":327,"kind":13,"localvar":"my","definition":"my","name":"$accver","containerName":"_get_idstring"},{"kind":13,"line":327,"containerName":"_get_idstring","name":"$seqobj"},{"name":"accession_number","containerName":"_get_idstring","kind":12,"line":327},{"line":328,"kind":13,"containerName":"_get_idstring","name":"$accver"},{"kind":13,"line":328,"name":"$seqobj","containerName":"_get_idstring"},{"containerName":"_get_idstring","name":"version","kind":12,"line":328},{"line":328,"kind":13,"containerName":"_get_idstring","name":"$seqobj"},{"containerName":"_get_idstring","name":"can","line":328,"kind":12},{"name":"$seqobj","containerName":"_get_idstring","kind":13,"line":328},{"name":"version","containerName":"_get_idstring","kind":12,"line":328},{"line":329,"kind":13,"name":"$accver","containerName":"_get_idstring"},{"line":330,"kind":13,"containerName":"_get_idstring","name":"$accver"},{"containerName":"_get_idstring","name":"$accver","kind":13,"line":333}],"line":324,"kind":12,"signature":{"label":"_get_idstring($self,$seqobj)","documentation":"__END__\n# BioPerl module for Bio::SeqIO::tinyseq\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Donald Jackson, donald.jackson@bms.com\n#\n# Copyright Bristol-Myers Squibb\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::tinyseq - reading/writing sequences in NCBI TinySeq format\n\n=head1 SYNOPSIS\n\nDo not use this module directly; use the SeqIO handler system:\n\n  $stream = Bio::SeqIO->new( -file => $filename, -format => 'tinyseq' );\n\n  while ( my $seq = $stream->next_seq ) {\n    ....\n  }\n\n=head1 DESCRIPTION\n\nThis object reads and writes Bio::Seq objects to and from TinySeq XML\nformat.  A TinySeq is a lightweight XML file of sequence information,\nanalgous to FASTA format.\n\nSee L<http://www.ncbi.nlm.nih.gov/dtd/NCBI_TSeq.mod.dtd> for the DTD.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.bioperl.org\n\n=head1 SEE ALSO\n\nL<Bio::SeqIO>, L<Bio::Seq>.\n\n=head1 AUTHOR\n\nDonald Jackson, E<lt>donald.jackson@bms.comE<gt>\n\nParts of this module and the test script were patterned after Sheldon\nMcKay's L<Bio::SeqIO::game>.  If it breaks, however, it's my fault not\nhis ;).\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::SeqIO::tinyseq;\n\nuse strict;\nuse Bio::Seq::SeqFastaSpeedFactory;\nuse Bio::Species;\nuse Bio::SeqIO::tinyseq::tinyseqHandler;\nuse XML::Parser::PerlSAX;\nuse XML::Writer;\n\nuse base qw(Bio::SeqIO);\n\nsub _initialize {\n    my ($self, @args) = @_;\n\n    $self->SUPER::_initialize(@args);\n\n    unless (defined $self->sequence_factory) {\n\t$self->sequence_factory(Bio::Seq::SeqFastaSpeedFactory->new());\n    }\n\n    $self->{'_species_objects'} = {};\n    $self->{_parsed} = 0;\n}\n\n=head2 next_seq\n\n  Title\t\t: next_seq\n  Usage\t\t: $seq = $stream->next_seq()\n  Function\t: returns the next sequence in the stream\n  Returns\t: Bio::Seq object\n  Args\t\t: NONE\n\n\nsub next_seq {\n    my ($self) = @_;\n\n    $self->_get_seqs() unless ($self->{_parsed});\n\n    return shift @{$self->{_seqlist}};\n}\n\n=head2 write_seq\n\n  Title\t\t: write_seq\n  Usage\t\t: $seq = $stream->write_seq(@sequence_objects); undef $stream\n  Function\t: outputs one or more sequence objects as TinySeq XML\n  Returns\t: 1 on success\n  Args\t\t: one or more sequence objects as TinySeq XML\n\nBecause the TSeq dtd includes closing tags after all sets are written,\nthe output will not be complete until the program terminates or the\nobject is forced out of scope (see close_writer()).  May not perfectly\nreproduce TSeq_sid element for all sequences\n\n\nsub write_seq {\n    my ($self, @seqobjs) = @_;\n\n    $self->throw('write_seq must be called with at least one  Bio::SeqI or Bio::PrimarySeqI compliant object')\n\tunless (@seqobjs and ( $seqobjs[0]->isa('Bio::SeqI') || $seqobjs[0]->isa('Bio::PrimarySeqI')));\n\n    my $writer = $self->_get_writer;\n\n    foreach my $seqobj (@seqobjs) {\n\tmy ($id_element, $id_value) = $self->_get_idstring($seqobj);\n \t$writer->startTag('TSeq');\n\t$writer->emptyTag('TSeq_seqtype', value => $self->_convert_seqtype($seqobj));\n\t$writer->dataElement('TSeq_gi', $seqobj->primary_id || '');\n\t$writer->dataElement($id_element, $id_value);\n\t#$writer->dataElement('TSeq_orgname', $seqobj->taxid) if ($seqobj->can('taxid'); # just a placeholder\n\t$writer->dataElement('TSeq_defline', $seqobj->desc);\n\t$writer->dataElement('TSeq_length', $seqobj->length);\n\t$writer->dataElement('TSeq_sequence', $seqobj->seq);\n\n\tif ($seqobj->can('species') && $seqobj->species) {\n\t    $self->_write_species($writer, $seqobj->species);\n\t}\n\n\t$writer->endTag('TSeq');\n    }\n    1;\n}\n\n=head2 _get_seqs\n\n  Title\t\t: _get_seqs\n  Usage\t\t: Internal function - use next_seq() instead\n  Function\t: parses the XML and creates Bio::Seq objects\n  Returns\t: 1 on success\n  Args\t\t: NONE\n\nCurrently stores all sequence objects into memory.  I will work on do\nmore of a stream-based approach\n\n\nsub _get_seqs {\n    my ($self) = @_;\n\n    my $fh = $self->_fh;\n\n    my $handler = Bio::SeqIO::tinyseq::tinyseqHandler->new();\n    my $parser = XML::Parser::PerlSAX->new( Handler => $handler );\n\n    my @seqatts = $parser->parse( Source => { ByteStream => $fh });\n\n    my $factory = $self->sequence_factory;\n\n    $self->{_seqlist} ||= [];\n    foreach my $seqatt(@seqatts) {\n\tforeach my $subatt(@$seqatt) { # why are there two hashes?\n\t    my $seqobj = $factory->create(%$subatt);\n\t    $self->_assign_identifier($seqobj, $subatt);\n\n\t    if ($seqobj->can('species')) {\n# \t\tmy $class = [reverse(split(/ /, $subatt->{'-organism'}))];\n# \t\tmy $species = Bio::Species->new( -classification\t=> $class,\n# \t\t\t\t\t\t -ncbi_taxid\t\t=> $subatt->{'-taxid'} );\n\t\tmy $species = $self->_get_species($subatt->{'-organism'}, $subatt->{'-taxid'});\n\t\t$seqobj->species($species) if ($species);\n\t    }\n\n\t    push(@{$self->{_seqlist}}, $seqobj);\n\t}\n    }\n    $self->{_parsed} = 1;\n}\n\n=head2 _get_species\n\n  Title\t\t: _get_species\n  Usage\t\t: Internal function\n  Function\t: gets a Bio::Species object from cache or creates as needed\n  Returns\t: a Bio::Species object on success, undef on failure\n  Args\t\t: a classification string (eg 'Homo sapiens') and\n                  a NCBI taxon id (optional)\n\nObjects are cached for parsing multiple sequence files.\n\n\nsub _get_species {\n     my ($self, $orgname, $taxid) = @_;\n\n     unless ($self->{'_species_objects'}->{$orgname}) {\n\t my $species = $self->_create_species($orgname, $taxid);\n\t $self->{'_species_objects'}->{$orgname} = $species;\n     }\n     return $self->{'_species_objects'}->{$orgname};\n}\n\n=head2 _create_species\n\n  Title\t\t: _create_species\n  Usage\t\t: Internal function\n  Function\t: creates a Bio::Species object\n  Returns\t: a Bio::Species object on success, undef on failure\n  Args\t\t: a classification string (eg 'Homo sapiens') and\n                  a NCBI taxon id (optional)\n\n\nsub _create_species {\n    my ($self, $orgname, $taxid) = @_;\n    return unless ($orgname); # not required in TinySeq dtd so don't throw an error\n\n    my %params;\n    $params{'-classification'} = [reverse(split(/ /, $orgname))];\n    $params{'-ncbi_taxid'} = $taxid if ($taxid);\n\n    my $species = Bio::Species->new(%params)\n\tor return;\n\n    return $species;\n}\n\n\n=head2 _assign_identifier\n\n  Title\t\t: _assign_identifier\n  Usage\t\t: Internal function\n  Function\t: looks for sequence accession\n  Returns\t: 1 on success\n  Args\t\t: NONE\n\nNCBI puts refseq accessions in TSeq_sid, others in TSeq_accver.\n\n\nsub _assign_identifier {\n    my ($self, $seqobj, $atts) = @_;\n    my ($accession, $version);\n\n   if ($atts->{'-accver'}) {\n\t($accession, $version) = split(/\\./, $atts->{'-accver'});;\n    }\n    elsif ($atts->{'-sid'}) {\n\tmy $sidstring =$atts->{'-sid'};\n\t$sidstring =~ s/^.+?\\|//;\n\t$sidstring =~ s/\\|[^\\|]*//;\n\t($accession, $version) = split(/\\./, $sidstring);;\n    }\n    else {\n\t$self->throw('NO accession information found for this sequence');\n    }\n    $seqobj->accession_number($accession) if ($seqobj->can('accession_number'));\n    $seqobj->version($version) if ($seqobj->can('version'));\n\n}\n\n=head2 _convert_seqtype\n\n  Title\t\t: _convert_seqtype\n  Usage\t\t: Internal function\n  Function\t: maps Bio::Seq::alphabet() values [dna/rna/protein] onto\n                  TSeq_seqtype values [protein/nucleotide]\n\n\nsub _convert_seqtype {\n    my ($self, $seqobj) = @_;\n\n    return 'protein' \tif ($seqobj->alphabet eq 'protein');\n    return 'nucleotide' if ($seqobj->alphabet eq 'dna');\n    return 'nucleotide' if ($seqobj->alphabet eq 'rna');\n\n    # if we get here there's a problem!\n    $self->throw(\"Alphabet not defined, can't assign type for $seqobj\");\n}\n\n=head2 _get_idstring\n\n  Title\t\t: _get_idstring\n  Usage\t\t: Internal function\n  Function\t: parse accession and version info from TSeq_accver\n                  or TSeq_sid","parameters":[{"label":"$self"},{"label":"$seqobj"}]},"detail":"($self,$seqobj)","definition":"sub","containerName":"main::","range":{"start":{"line":324,"character":0},"end":{"line":335,"character":9999}},"name":"_get_idstring"},{"name":"_get_writer","range":{"end":{"character":9999,"line":366},"start":{"character":0,"line":346}},"kind":12,"line":346,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"_get_writer","line":348,"kind":13},{"name":"$self","containerName":"_get_writer","kind":13,"line":350},{"localvar":"my","containerName":"_get_writer","name":"$fh","definition":"my","line":351,"kind":13},{"line":351,"kind":13,"name":"$self","containerName":"_get_writer"},{"name":"_fh","containerName":"_get_writer","kind":12,"line":351},{"containerName":"_get_writer","definition":"my","name":"$writer","localvar":"my","kind":13,"line":352},{"kind":12,"line":352,"containerName":"_get_writer","name":"new"},{"kind":13,"line":352,"containerName":"_get_writer","name":"$fh"},{"containerName":"_get_writer","name":"$writer","line":357,"kind":13},{"line":357,"kind":12,"name":"doctype","containerName":"_get_writer"},{"line":359,"kind":13,"name":"$writer","containerName":"_get_writer"},{"kind":12,"line":359,"containerName":"_get_writer","name":"comment"},{"name":"$Bio","containerName":"_get_writer","line":359,"kind":13},{"name":"$writer","containerName":"_get_writer","kind":13,"line":361},{"line":361,"kind":12,"containerName":"_get_writer","name":"startTag"},{"line":363,"kind":13,"name":"$self","containerName":"_get_writer"},{"kind":13,"line":363,"name":"$writer","containerName":"_get_writer"},{"name":"$self","containerName":"_get_writer","line":365,"kind":13}],"containerName":"main::","definition":"sub","detail":"($self)","signature":{"label":"_get_writer($self)","parameters":[{"label":"$self"}],"documentation":"__END__\n# BioPerl module for Bio::SeqIO::tinyseq\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Donald Jackson, donald.jackson@bms.com\n#\n# Copyright Bristol-Myers Squibb\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::tinyseq - reading/writing sequences in NCBI TinySeq format\n\n=head1 SYNOPSIS\n\nDo not use this module directly; use the SeqIO handler system:\n\n  $stream = Bio::SeqIO->new( -file => $filename, -format => 'tinyseq' );\n\n  while ( my $seq = $stream->next_seq ) {\n    ....\n  }\n\n=head1 DESCRIPTION\n\nThis object reads and writes Bio::Seq objects to and from TinySeq XML\nformat.  A TinySeq is a lightweight XML file of sequence information,\nanalgous to FASTA format.\n\nSee L<http://www.ncbi.nlm.nih.gov/dtd/NCBI_TSeq.mod.dtd> for the DTD.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.bioperl.org\n\n=head1 SEE ALSO\n\nL<Bio::SeqIO>, L<Bio::Seq>.\n\n=head1 AUTHOR\n\nDonald Jackson, E<lt>donald.jackson@bms.comE<gt>\n\nParts of this module and the test script were patterned after Sheldon\nMcKay's L<Bio::SeqIO::game>.  If it breaks, however, it's my fault not\nhis ;).\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::SeqIO::tinyseq;\n\nuse strict;\nuse Bio::Seq::SeqFastaSpeedFactory;\nuse Bio::Species;\nuse Bio::SeqIO::tinyseq::tinyseqHandler;\nuse XML::Parser::PerlSAX;\nuse XML::Writer;\n\nuse base qw(Bio::SeqIO);\n\nsub _initialize {\n    my ($self, @args) = @_;\n\n    $self->SUPER::_initialize(@args);\n\n    unless (defined $self->sequence_factory) {\n\t$self->sequence_factory(Bio::Seq::SeqFastaSpeedFactory->new());\n    }\n\n    $self->{'_species_objects'} = {};\n    $self->{_parsed} = 0;\n}\n\n=head2 next_seq\n\n  Title\t\t: next_seq\n  Usage\t\t: $seq = $stream->next_seq()\n  Function\t: returns the next sequence in the stream\n  Returns\t: Bio::Seq object\n  Args\t\t: NONE\n\n\nsub next_seq {\n    my ($self) = @_;\n\n    $self->_get_seqs() unless ($self->{_parsed});\n\n    return shift @{$self->{_seqlist}};\n}\n\n=head2 write_seq\n\n  Title\t\t: write_seq\n  Usage\t\t: $seq = $stream->write_seq(@sequence_objects); undef $stream\n  Function\t: outputs one or more sequence objects as TinySeq XML\n  Returns\t: 1 on success\n  Args\t\t: one or more sequence objects as TinySeq XML\n\nBecause the TSeq dtd includes closing tags after all sets are written,\nthe output will not be complete until the program terminates or the\nobject is forced out of scope (see close_writer()).  May not perfectly\nreproduce TSeq_sid element for all sequences\n\n\nsub write_seq {\n    my ($self, @seqobjs) = @_;\n\n    $self->throw('write_seq must be called with at least one  Bio::SeqI or Bio::PrimarySeqI compliant object')\n\tunless (@seqobjs and ( $seqobjs[0]->isa('Bio::SeqI') || $seqobjs[0]->isa('Bio::PrimarySeqI')));\n\n    my $writer = $self->_get_writer;\n\n    foreach my $seqobj (@seqobjs) {\n\tmy ($id_element, $id_value) = $self->_get_idstring($seqobj);\n \t$writer->startTag('TSeq');\n\t$writer->emptyTag('TSeq_seqtype', value => $self->_convert_seqtype($seqobj));\n\t$writer->dataElement('TSeq_gi', $seqobj->primary_id || '');\n\t$writer->dataElement($id_element, $id_value);\n\t#$writer->dataElement('TSeq_orgname', $seqobj->taxid) if ($seqobj->can('taxid'); # just a placeholder\n\t$writer->dataElement('TSeq_defline', $seqobj->desc);\n\t$writer->dataElement('TSeq_length', $seqobj->length);\n\t$writer->dataElement('TSeq_sequence', $seqobj->seq);\n\n\tif ($seqobj->can('species') && $seqobj->species) {\n\t    $self->_write_species($writer, $seqobj->species);\n\t}\n\n\t$writer->endTag('TSeq');\n    }\n    1;\n}\n\n=head2 _get_seqs\n\n  Title\t\t: _get_seqs\n  Usage\t\t: Internal function - use next_seq() instead\n  Function\t: parses the XML and creates Bio::Seq objects\n  Returns\t: 1 on success\n  Args\t\t: NONE\n\nCurrently stores all sequence objects into memory.  I will work on do\nmore of a stream-based approach\n\n\nsub _get_seqs {\n    my ($self) = @_;\n\n    my $fh = $self->_fh;\n\n    my $handler = Bio::SeqIO::tinyseq::tinyseqHandler->new();\n    my $parser = XML::Parser::PerlSAX->new( Handler => $handler );\n\n    my @seqatts = $parser->parse( Source => { ByteStream => $fh });\n\n    my $factory = $self->sequence_factory;\n\n    $self->{_seqlist} ||= [];\n    foreach my $seqatt(@seqatts) {\n\tforeach my $subatt(@$seqatt) { # why are there two hashes?\n\t    my $seqobj = $factory->create(%$subatt);\n\t    $self->_assign_identifier($seqobj, $subatt);\n\n\t    if ($seqobj->can('species')) {\n# \t\tmy $class = [reverse(split(/ /, $subatt->{'-organism'}))];\n# \t\tmy $species = Bio::Species->new( -classification\t=> $class,\n# \t\t\t\t\t\t -ncbi_taxid\t\t=> $subatt->{'-taxid'} );\n\t\tmy $species = $self->_get_species($subatt->{'-organism'}, $subatt->{'-taxid'});\n\t\t$seqobj->species($species) if ($species);\n\t    }\n\n\t    push(@{$self->{_seqlist}}, $seqobj);\n\t}\n    }\n    $self->{_parsed} = 1;\n}\n\n=head2 _get_species\n\n  Title\t\t: _get_species\n  Usage\t\t: Internal function\n  Function\t: gets a Bio::Species object from cache or creates as needed\n  Returns\t: a Bio::Species object on success, undef on failure\n  Args\t\t: a classification string (eg 'Homo sapiens') and\n                  a NCBI taxon id (optional)\n\nObjects are cached for parsing multiple sequence files.\n\n\nsub _get_species {\n     my ($self, $orgname, $taxid) = @_;\n\n     unless ($self->{'_species_objects'}->{$orgname}) {\n\t my $species = $self->_create_species($orgname, $taxid);\n\t $self->{'_species_objects'}->{$orgname} = $species;\n     }\n     return $self->{'_species_objects'}->{$orgname};\n}\n\n=head2 _create_species\n\n  Title\t\t: _create_species\n  Usage\t\t: Internal function\n  Function\t: creates a Bio::Species object\n  Returns\t: a Bio::Species object on success, undef on failure\n  Args\t\t: a classification string (eg 'Homo sapiens') and\n                  a NCBI taxon id (optional)\n\n\nsub _create_species {\n    my ($self, $orgname, $taxid) = @_;\n    return unless ($orgname); # not required in TinySeq dtd so don't throw an error\n\n    my %params;\n    $params{'-classification'} = [reverse(split(/ /, $orgname))];\n    $params{'-ncbi_taxid'} = $taxid if ($taxid);\n\n    my $species = Bio::Species->new(%params)\n\tor return;\n\n    return $species;\n}\n\n\n=head2 _assign_identifier\n\n  Title\t\t: _assign_identifier\n  Usage\t\t: Internal function\n  Function\t: looks for sequence accession\n  Returns\t: 1 on success\n  Args\t\t: NONE\n\nNCBI puts refseq accessions in TSeq_sid, others in TSeq_accver.\n\n\nsub _assign_identifier {\n    my ($self, $seqobj, $atts) = @_;\n    my ($accession, $version);\n\n   if ($atts->{'-accver'}) {\n\t($accession, $version) = split(/\\./, $atts->{'-accver'});;\n    }\n    elsif ($atts->{'-sid'}) {\n\tmy $sidstring =$atts->{'-sid'};\n\t$sidstring =~ s/^.+?\\|//;\n\t$sidstring =~ s/\\|[^\\|]*//;\n\t($accession, $version) = split(/\\./, $sidstring);;\n    }\n    else {\n\t$self->throw('NO accession information found for this sequence');\n    }\n    $seqobj->accession_number($accession) if ($seqobj->can('accession_number'));\n    $seqobj->version($version) if ($seqobj->can('version'));\n\n}\n\n=head2 _convert_seqtype\n\n  Title\t\t: _convert_seqtype\n  Usage\t\t: Internal function\n  Function\t: maps Bio::Seq::alphabet() values [dna/rna/protein] onto\n                  TSeq_seqtype values [protein/nucleotide]\n\n\nsub _convert_seqtype {\n    my ($self, $seqobj) = @_;\n\n    return 'protein' \tif ($seqobj->alphabet eq 'protein');\n    return 'nucleotide' if ($seqobj->alphabet eq 'dna');\n    return 'nucleotide' if ($seqobj->alphabet eq 'rna');\n\n    # if we get here there's a problem!\n    $self->throw(\"Alphabet not defined, can't assign type for $seqobj\");\n}\n\n=head2 _get_idstring\n\n  Title\t\t: _get_idstring\n  Usage\t\t: Internal function\n  Function\t: parse accession and version info from TSeq_accver\n                  or TSeq_sid\n\n\nsub _get_idstring {\n    # NCBI puts refseq ids in TSeq_sid, others in TSeq_accver.  No idea why.\n    my ($self, $seqobj) = @_;\n    my $accver = $seqobj->accession_number;\n    $accver .= '.' . $seqobj->version if ($seqobj->can('version') and $seqobj->version);\n    if ($accver =~ /^(NM_|NP_|XM_|XP_|NT_|NC_|NG_)/) {\n\treturn ('TSeq_sid', join('|', 'ref', $accver, ''));\n    }\n    else {\n\treturn ('TSeq_accver', $accver);\n    }\n}\n\n=head2 _get_writer\n\n  Title\t\t: _get_writer\n  Usage\t\t: Internal function\n  Function\t: instantiate XML::Writer object if needed,\n                  output initial XML"}},{"line":350,"kind":12,"name":"_writer"},{"line":352,"kind":12,"name":"XML","containerName":"Writer"},{"line":352,"kind":12,"name":"OUTPUT"},{"name":"DATA_MODE","kind":12,"line":353},{"kind":12,"line":354,"name":"DATA_INDENT"},{"kind":12,"line":355,"name":"NEWLINE"},{"line":359,"kind":12,"containerName":"tinyseq::VERSION","name":"SeqIO"},{"name":"_writer","kind":12,"line":363},{"kind":12,"line":365,"name":"_writer"},{"definition":"sub","containerName":"main::","signature":{"label":"close_writer($self)","documentation":"__END__\n# BioPerl module for Bio::SeqIO::tinyseq\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Donald Jackson, donald.jackson@bms.com\n#\n# Copyright Bristol-Myers Squibb\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::tinyseq - reading/writing sequences in NCBI TinySeq format\n\n=head1 SYNOPSIS\n\nDo not use this module directly; use the SeqIO handler system:\n\n  $stream = Bio::SeqIO->new( -file => $filename, -format => 'tinyseq' );\n\n  while ( my $seq = $stream->next_seq ) {\n    ....\n  }\n\n=head1 DESCRIPTION\n\nThis object reads and writes Bio::Seq objects to and from TinySeq XML\nformat.  A TinySeq is a lightweight XML file of sequence information,\nanalgous to FASTA format.\n\nSee L<http://www.ncbi.nlm.nih.gov/dtd/NCBI_TSeq.mod.dtd> for the DTD.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.bioperl.org\n\n=head1 SEE ALSO\n\nL<Bio::SeqIO>, L<Bio::Seq>.\n\n=head1 AUTHOR\n\nDonald Jackson, E<lt>donald.jackson@bms.comE<gt>\n\nParts of this module and the test script were patterned after Sheldon\nMcKay's L<Bio::SeqIO::game>.  If it breaks, however, it's my fault not\nhis ;).\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::SeqIO::tinyseq;\n\nuse strict;\nuse Bio::Seq::SeqFastaSpeedFactory;\nuse Bio::Species;\nuse Bio::SeqIO::tinyseq::tinyseqHandler;\nuse XML::Parser::PerlSAX;\nuse XML::Writer;\n\nuse base qw(Bio::SeqIO);\n\nsub _initialize {\n    my ($self, @args) = @_;\n\n    $self->SUPER::_initialize(@args);\n\n    unless (defined $self->sequence_factory) {\n\t$self->sequence_factory(Bio::Seq::SeqFastaSpeedFactory->new());\n    }\n\n    $self->{'_species_objects'} = {};\n    $self->{_parsed} = 0;\n}\n\n=head2 next_seq\n\n  Title\t\t: next_seq\n  Usage\t\t: $seq = $stream->next_seq()\n  Function\t: returns the next sequence in the stream\n  Returns\t: Bio::Seq object\n  Args\t\t: NONE\n\n\nsub next_seq {\n    my ($self) = @_;\n\n    $self->_get_seqs() unless ($self->{_parsed});\n\n    return shift @{$self->{_seqlist}};\n}\n\n=head2 write_seq\n\n  Title\t\t: write_seq\n  Usage\t\t: $seq = $stream->write_seq(@sequence_objects); undef $stream\n  Function\t: outputs one or more sequence objects as TinySeq XML\n  Returns\t: 1 on success\n  Args\t\t: one or more sequence objects as TinySeq XML\n\nBecause the TSeq dtd includes closing tags after all sets are written,\nthe output will not be complete until the program terminates or the\nobject is forced out of scope (see close_writer()).  May not perfectly\nreproduce TSeq_sid element for all sequences\n\n\nsub write_seq {\n    my ($self, @seqobjs) = @_;\n\n    $self->throw('write_seq must be called with at least one  Bio::SeqI or Bio::PrimarySeqI compliant object')\n\tunless (@seqobjs and ( $seqobjs[0]->isa('Bio::SeqI') || $seqobjs[0]->isa('Bio::PrimarySeqI')));\n\n    my $writer = $self->_get_writer;\n\n    foreach my $seqobj (@seqobjs) {\n\tmy ($id_element, $id_value) = $self->_get_idstring($seqobj);\n \t$writer->startTag('TSeq');\n\t$writer->emptyTag('TSeq_seqtype', value => $self->_convert_seqtype($seqobj));\n\t$writer->dataElement('TSeq_gi', $seqobj->primary_id || '');\n\t$writer->dataElement($id_element, $id_value);\n\t#$writer->dataElement('TSeq_orgname', $seqobj->taxid) if ($seqobj->can('taxid'); # just a placeholder\n\t$writer->dataElement('TSeq_defline', $seqobj->desc);\n\t$writer->dataElement('TSeq_length', $seqobj->length);\n\t$writer->dataElement('TSeq_sequence', $seqobj->seq);\n\n\tif ($seqobj->can('species') && $seqobj->species) {\n\t    $self->_write_species($writer, $seqobj->species);\n\t}\n\n\t$writer->endTag('TSeq');\n    }\n    1;\n}\n\n=head2 _get_seqs\n\n  Title\t\t: _get_seqs\n  Usage\t\t: Internal function - use next_seq() instead\n  Function\t: parses the XML and creates Bio::Seq objects\n  Returns\t: 1 on success\n  Args\t\t: NONE\n\nCurrently stores all sequence objects into memory.  I will work on do\nmore of a stream-based approach\n\n\nsub _get_seqs {\n    my ($self) = @_;\n\n    my $fh = $self->_fh;\n\n    my $handler = Bio::SeqIO::tinyseq::tinyseqHandler->new();\n    my $parser = XML::Parser::PerlSAX->new( Handler => $handler );\n\n    my @seqatts = $parser->parse( Source => { ByteStream => $fh });\n\n    my $factory = $self->sequence_factory;\n\n    $self->{_seqlist} ||= [];\n    foreach my $seqatt(@seqatts) {\n\tforeach my $subatt(@$seqatt) { # why are there two hashes?\n\t    my $seqobj = $factory->create(%$subatt);\n\t    $self->_assign_identifier($seqobj, $subatt);\n\n\t    if ($seqobj->can('species')) {\n# \t\tmy $class = [reverse(split(/ /, $subatt->{'-organism'}))];\n# \t\tmy $species = Bio::Species->new( -classification\t=> $class,\n# \t\t\t\t\t\t -ncbi_taxid\t\t=> $subatt->{'-taxid'} );\n\t\tmy $species = $self->_get_species($subatt->{'-organism'}, $subatt->{'-taxid'});\n\t\t$seqobj->species($species) if ($species);\n\t    }\n\n\t    push(@{$self->{_seqlist}}, $seqobj);\n\t}\n    }\n    $self->{_parsed} = 1;\n}\n\n=head2 _get_species\n\n  Title\t\t: _get_species\n  Usage\t\t: Internal function\n  Function\t: gets a Bio::Species object from cache or creates as needed\n  Returns\t: a Bio::Species object on success, undef on failure\n  Args\t\t: a classification string (eg 'Homo sapiens') and\n                  a NCBI taxon id (optional)\n\nObjects are cached for parsing multiple sequence files.\n\n\nsub _get_species {\n     my ($self, $orgname, $taxid) = @_;\n\n     unless ($self->{'_species_objects'}->{$orgname}) {\n\t my $species = $self->_create_species($orgname, $taxid);\n\t $self->{'_species_objects'}->{$orgname} = $species;\n     }\n     return $self->{'_species_objects'}->{$orgname};\n}\n\n=head2 _create_species\n\n  Title\t\t: _create_species\n  Usage\t\t: Internal function\n  Function\t: creates a Bio::Species object\n  Returns\t: a Bio::Species object on success, undef on failure\n  Args\t\t: a classification string (eg 'Homo sapiens') and\n                  a NCBI taxon id (optional)\n\n\nsub _create_species {\n    my ($self, $orgname, $taxid) = @_;\n    return unless ($orgname); # not required in TinySeq dtd so don't throw an error\n\n    my %params;\n    $params{'-classification'} = [reverse(split(/ /, $orgname))];\n    $params{'-ncbi_taxid'} = $taxid if ($taxid);\n\n    my $species = Bio::Species->new(%params)\n\tor return;\n\n    return $species;\n}\n\n\n=head2 _assign_identifier\n\n  Title\t\t: _assign_identifier\n  Usage\t\t: Internal function\n  Function\t: looks for sequence accession\n  Returns\t: 1 on success\n  Args\t\t: NONE\n\nNCBI puts refseq accessions in TSeq_sid, others in TSeq_accver.\n\n\nsub _assign_identifier {\n    my ($self, $seqobj, $atts) = @_;\n    my ($accession, $version);\n\n   if ($atts->{'-accver'}) {\n\t($accession, $version) = split(/\\./, $atts->{'-accver'});;\n    }\n    elsif ($atts->{'-sid'}) {\n\tmy $sidstring =$atts->{'-sid'};\n\t$sidstring =~ s/^.+?\\|//;\n\t$sidstring =~ s/\\|[^\\|]*//;\n\t($accession, $version) = split(/\\./, $sidstring);;\n    }\n    else {\n\t$self->throw('NO accession information found for this sequence');\n    }\n    $seqobj->accession_number($accession) if ($seqobj->can('accession_number'));\n    $seqobj->version($version) if ($seqobj->can('version'));\n\n}\n\n=head2 _convert_seqtype\n\n  Title\t\t: _convert_seqtype\n  Usage\t\t: Internal function\n  Function\t: maps Bio::Seq::alphabet() values [dna/rna/protein] onto\n                  TSeq_seqtype values [protein/nucleotide]\n\n\nsub _convert_seqtype {\n    my ($self, $seqobj) = @_;\n\n    return 'protein' \tif ($seqobj->alphabet eq 'protein');\n    return 'nucleotide' if ($seqobj->alphabet eq 'dna');\n    return 'nucleotide' if ($seqobj->alphabet eq 'rna');\n\n    # if we get here there's a problem!\n    $self->throw(\"Alphabet not defined, can't assign type for $seqobj\");\n}\n\n=head2 _get_idstring\n\n  Title\t\t: _get_idstring\n  Usage\t\t: Internal function\n  Function\t: parse accession and version info from TSeq_accver\n                  or TSeq_sid\n\n\nsub _get_idstring {\n    # NCBI puts refseq ids in TSeq_sid, others in TSeq_accver.  No idea why.\n    my ($self, $seqobj) = @_;\n    my $accver = $seqobj->accession_number;\n    $accver .= '.' . $seqobj->version if ($seqobj->can('version') and $seqobj->version);\n    if ($accver =~ /^(NM_|NP_|XM_|XP_|NT_|NC_|NG_)/) {\n\treturn ('TSeq_sid', join('|', 'ref', $accver, ''));\n    }\n    else {\n\treturn ('TSeq_accver', $accver);\n    }\n}\n\n=head2 _get_writer\n\n  Title\t\t: _get_writer\n  Usage\t\t: Internal function\n  Function\t: instantiate XML::Writer object if needed,\n                  output initial XML\n\n\nsub _get_writer {\n    # initialize writer, start doc so write_seq can work one at a time\n    my ($self) = @_;\n\n    unless ($self->{_writer}) {\n\tmy $fh = $self->_fh;\n\tmy $writer = XML::Writer->new(OUTPUT \t\t=> $fh,\n\t\t\t\t      DATA_MODE\t\t=> 1,\n\t\t\t\t      DATA_INDENT\t=> 2,\n\t\t\t\t      NEWLINE\t\t=> 1,\n\t\t\t\t      );\n\t$writer->doctype('TSeqSet', '-//NCBI//NCBI TSeq/EN', 'http://www.ncbi.nlm.nih.gov/dtd/NCBI_TSeq.dtd');\n\n\t$writer->comment(\"Generated by Bio::SeqIO::tinyseq VERSION \".$Bio::SeqIO::tinyseq::VERSION);\n\n\t$writer->startTag('TSeqSet');\n\n\t$self->{_writer} = $writer;\n    }\n    return $self->{_writer};\n}\n\n=head2 close_writer\n\n  Title\t\t: close_writer\n  Usage\t\t: $self->close_writer()\n  Function\t: terminate XML output\n  Args\t\t: NONE\n  Returns\t: 1 on success\n\nCalled automatically by DESTROY when object goes out of scope","parameters":[{"label":"$self"}]},"detail":"($self)","kind":12,"children":[{"kind":13,"line":382,"containerName":"close_writer","definition":"my","name":"$self","localvar":"my"},{"kind":13,"line":383,"name":"$self","containerName":"close_writer"},{"localvar":"my","name":"$writer","definition":"my","containerName":"close_writer","line":384,"kind":13},{"containerName":"close_writer","name":"$self","line":384,"kind":13},{"name":"$writer","containerName":"close_writer","line":385,"kind":13},{"line":385,"kind":12,"containerName":"close_writer","name":"endTag"},{"name":"$writer","containerName":"close_writer","kind":13,"line":386},{"line":386,"kind":12,"containerName":"close_writer","name":"end"},{"containerName":"close_writer","name":"$writer","kind":13,"line":387},{"kind":13,"line":389,"containerName":"close_writer","name":"$self"},{"line":389,"kind":12,"name":"_fh","containerName":"close_writer"},{"line":389,"kind":13,"name":"$self","containerName":"close_writer"},{"line":389,"kind":12,"name":"_fh","containerName":"close_writer"}],"line":380,"name":"close_writer","range":{"start":{"line":380,"character":0},"end":{"character":9999,"line":391}}},{"name":"_writer","line":383,"kind":12},{"name":"_writer","line":384,"kind":12},{"kind":12,"children":[{"kind":13,"line":394,"containerName":"_write_species","name":"$self","definition":"my","localvar":"my"},{"name":"$writer","containerName":"_write_species","kind":13,"line":394},{"kind":13,"line":394,"name":"$species","containerName":"_write_species"},{"kind":13,"line":395,"name":"$writer","containerName":"_write_species"},{"line":395,"kind":12,"containerName":"_write_species","name":"dataElement"},{"containerName":"_write_species","name":"$species","kind":13,"line":395},{"name":"binomial","containerName":"_write_species","kind":12,"line":395},{"kind":13,"line":396,"containerName":"_write_species","name":"$writer"},{"containerName":"_write_species","name":"dataElement","line":396,"kind":12},{"containerName":"_write_species","name":"$species","line":396,"kind":13},{"kind":12,"line":396,"name":"ncbi_taxid","containerName":"_write_species"},{"name":"$species","containerName":"_write_species","kind":13,"line":397},{"name":"ncbi_taxid","containerName":"_write_species","kind":12,"line":397}],"line":393,"definition":"sub","containerName":"main::","signature":{"documentation":"","parameters":[{"label":"$self"},{"label":"$writer"},{"label":"$species"}],"label":"_write_species($self,$writer,$species)"},"detail":"($self,$writer,$species)","name":"_write_species","range":{"start":{"character":0,"line":393},"end":{"character":9999,"line":398}}},{"range":{"start":{"line":400,"character":0},"end":{"line":405,"character":9999}},"name":"DESTROY","detail":"($self)","signature":{"label":"DESTROY($self)","documentation":"","parameters":[{"label":"$self"}]},"containerName":"main::","definition":"sub","line":400,"children":[{"kind":13,"line":402,"containerName":"DESTROY","definition":"my","name":"$self","localvar":"my"},{"line":403,"kind":13,"containerName":"DESTROY","name":"$self"},{"line":403,"kind":12,"name":"close_writer","containerName":"DESTROY"},{"name":"$self","containerName":"DESTROY","kind":13,"line":404}],"kind":12}],"version":5}