{"vars":[{"name":"base","containerName":"","kind":2,"line":96},{"name":"$c","definition":"my","containerName":null,"localvar":"my","kind":13,"line":98},{"line":98,"kind":12,"name":"new"},{"kind":12,"line":98,"name":"Convert","containerName":"Binary::C"},{"name":"ByteOrder","line":99,"kind":12},{"name":"Alignment","line":100,"kind":12},{"name":"%headerdef","definition":"my","containerName":null,"localvar":"my","kind":13,"line":103},{"name":"$headerdef","containerName":null,"kind":13,"line":107},{"name":"DATA","kind":12,"line":107},{"name":"$c","containerName":null,"kind":13,"line":109},{"containerName":"main::","name":"parse","kind":12,"line":109},{"kind":13,"line":109,"containerName":null,"name":"$headerdef"},{"localvar":"my","definition":"my","name":"$size_F_HEADER","containerName":null,"line":111,"kind":13},{"line":113,"kind":13,"name":"$size_F_HEADER","containerName":null},{"kind":13,"line":113,"containerName":null,"name":"$c"},{"containerName":"main::","name":"sizeof","kind":12,"line":113},{"localvar":"my","containerName":null,"definition":"my","name":"%alphabet2type","line":115,"kind":13},{"name":"dna","line":126,"kind":12},{"line":127,"kind":12,"name":"rna"},{"name":"protein","line":128,"kind":12},{"line":131,"kind":13,"localvar":"my","definition":"my","name":"%type2alphabet","containerName":null},{"containerName":null,"name":"%alphabet2type","line":131,"kind":13},{"children":[{"name":"$self","definition":"my","containerName":"_initialize","localvar":"my","kind":13,"line":134},{"name":"@args","containerName":"_initialize","kind":13,"line":134},{"name":"$self","containerName":"_initialize","line":135,"kind":13},{"containerName":"_initialize","name":"@args","kind":13,"line":135},{"kind":13,"line":136,"name":"$self","containerName":"_initialize"},{"kind":12,"line":136,"name":"sequence_factory","containerName":"_initialize"},{"kind":13,"line":137,"containerName":"_initialize","name":"$self"},{"line":137,"kind":12,"name":"sequence_factory","containerName":"_initialize"},{"name":"new","containerName":"_initialize","kind":12,"line":137},{"name":"$self","containerName":"_initialize","line":137,"kind":13},{"line":137,"kind":12,"containerName":"_initialize","name":"verbose"}],"line":133,"kind":12,"signature":{"label":"_initialize($self,@args)","documentation":"","parameters":[{"label":"$self"},{"label":"@args"}]},"detail":"($self,@args)","definition":"sub","containerName":"main::","range":{"start":{"character":0,"line":133},"end":{"line":140,"character":9999}},"name":"_initialize"},{"containerName":"_initialize","name":"SUPER","line":135,"kind":12},{"kind":12,"line":137,"name":"Bio","containerName":"Seq::SeqFactory"},{"range":{"end":{"character":9999,"line":173},"start":{"line":152,"character":0}},"name":"next_seq","children":[{"kind":13,"line":153,"containerName":"next_seq","definition":"my","name":"$self","localvar":"my"},{"localvar":"my","name":"$fh","definition":"my","containerName":"next_seq","line":154,"kind":13},{"line":154,"kind":13,"containerName":"next_seq","name":"$self"},{"line":154,"kind":12,"name":"_fh","containerName":"next_seq"},{"containerName":"next_seq","definition":"my","name":"$header","localvar":"my","kind":13,"line":155},{"name":"$sequence","containerName":"next_seq","kind":13,"line":155},{"kind":13,"line":155,"name":"$fulldesc","containerName":"next_seq"},{"containerName":"next_seq","name":"$fh","line":156,"kind":13},{"name":"$header","containerName":"next_seq","line":156,"kind":13},{"line":156,"kind":13,"name":"$size_F_HEADER","containerName":"next_seq"},{"line":157,"kind":13,"name":"$self","containerName":"next_seq"},{"containerName":"next_seq","name":"throw","line":157,"kind":12},{"containerName":"next_seq","name":"$self","line":157,"kind":13},{"containerName":"next_seq","name":"$self","line":158,"kind":13},{"line":158,"kind":12,"name":"throw","containerName":"next_seq"},{"name":"$self","containerName":"next_seq","kind":13,"line":158},{"containerName":"next_seq","name":"$header","kind":13,"line":158},{"name":"$size_F_HEADER","containerName":"next_seq","kind":13,"line":159},{"line":159,"kind":13,"name":"$header","containerName":"next_seq"},{"kind":13,"line":160,"definition":"my","name":"$headerdata","containerName":"next_seq","localvar":"my"},{"name":"$c","containerName":"next_seq","line":160,"kind":13},{"kind":12,"line":160,"name":"unpack","containerName":"next_seq"},{"kind":13,"line":160,"containerName":"next_seq","name":"$header"},{"line":161,"kind":13,"name":"$fh","containerName":"next_seq"},{"name":"$sequence","containerName":"next_seq","kind":13,"line":161},{"kind":13,"line":161,"name":"$headerdata","containerName":"next_seq"},{"containerName":"next_seq","name":"$fh","line":162,"kind":13},{"kind":13,"line":162,"containerName":"next_seq","name":"$fulldesc"},{"line":162,"kind":13,"containerName":"next_seq","name":"$headerdata"},{"kind":13,"line":163,"containerName":"next_seq","name":"$fulldesc"},{"kind":13,"line":165,"name":"$seq","definition":"my","containerName":"next_seq","localvar":"my"},{"kind":13,"line":165,"name":"$self","containerName":"next_seq"},{"line":165,"kind":12,"containerName":"next_seq","name":"sequence_factory"},{"kind":12,"line":165,"name":"create","containerName":"next_seq"},{"kind":13,"line":167,"name":"$sequence","containerName":"next_seq"},{"kind":13,"line":168,"name":"$fulldesc","containerName":"next_seq"},{"containerName":"next_seq","name":"$type2alphabet","kind":13,"line":169},{"containerName":"next_seq","name":"$headerdata","line":169,"kind":13},{"name":"$seq","containerName":"next_seq","kind":13,"line":172}],"line":152,"kind":12,"signature":{"parameters":[{"label":"$self"}],"documentation":"};\n# $Id: strider.pm 16123 2009-09-17 12:57:27Z cjfields $\n# BioPerl module for Bio::SeqIO::strider\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Malcolm Cook <mec@stowers-institute.org>\n#\n# You may distribute this module under the same terms as perl itself\n#\n# _history\n# April 7th, 2005  Malcolm Cook authored\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::strider - DNA strider sequence input/output stream\n\n=head1 SYNOPSIS\n\nDo not use this module directly.  Use it via the Bio::SeqIO class.\n\n=head1 DESCRIPTION\n\nThis object can transform Bio::Seq objects to and from strider\n'binary' format, as documented in the strider manual, in which the\nfirst 112 bytes are a header, following by the sequence, followed by a\nsequence description.\n\nNote: it does NOT assign any sequence identifier, since they are not\ncontained in the byte stream of the file; the Strider application\nsimply displays the name of the file on disk as the name of the\nsequence. The caller should set the id, probably based on the name of\nthe file (after possibly cleaning up whitespace, which ought not to be\nused as the id in most applications).\n\nNote: the strider 'comment' is mapped to the BioPerl 'description'\n(since there is no other text field, and description maps to defline\ntext).\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS - Malcolm Cook\n\nEmail: mec@stowers-institute.org\n\n=head1 CONTRIBUTORS\n\nModelled after Bio::SeqIO::fasta by Ewan Birney E<lt>birney@ebi.ac.ukE<gt> and\nLincoln Stein E<lt>lstein@cshl.orgE<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SeqIO::strider;\nuse strict;\nuse warnings;\n\n\nuse Bio::Seq::SeqFactory;\nuse Convert::Binary::C;\n\nuse base qw(Bio::SeqIO);\n\nmy $c = new Convert::Binary::C (\n\t\t\t\tByteOrder => 'BigEndian',\n\t\t\t\tAlignment => 2\n\t\t\t       );\n\nmy $headerdef;\n{local ($/);\n # See this file's __DATA__ section for the c structure definitions\n # for strider binary header data.  Here we slurp it all into $headerdef.\n $headerdef = <DATA>};\n\n$c->parse($headerdef);\n\nmy $size_F_HEADER = 112;\n\ndie \"expected strider header structure size of $size_F_HEADER\" unless $size_F_HEADER eq $c->sizeof('F_HEADER');\n\nmy %alphabet2type = (\n\t\t     # map between BioPerl alphabet and strider\n\t\t     # sequence type code.\n\n\t\t     # From Strider Documentation: the sequence type:\n\t\t     # 1, 2, 3 and 4 for DNA, DNA Degenerate, RNA and\n\t\t     # Protein sequence files, respectively.  \n\n\t\t     # TODO: determine 'DNA Degenerate' based on\n\t\t     # sequence alphabet?\n\n\t\t     dna => 1,\n\t\t     rna => 3,\n\t\t     protein => 4,\n\t\t    );\n\nmy %type2alphabet = reverse %alphabet2type;\n\nsub _initialize {\n  my($self,@args) = @_;\n  $self->SUPER::_initialize(@args);  \n  unless ( defined $self->sequence_factory ) {\n    $self->sequence_factory(Bio::Seq::SeqFactory->new(-verbose => $self->verbose(), \n\t\t\t\t\t\t      -type => 'Bio::Seq::RichSeq'));\n  }\n}\n\n=head2 next_seq\n\n Title   : next_seq\n Usage   : $seq = $stream->next_seq()\n Function: returns the next sequence in the stream\n Returns : Bio::Seq object\n Args    : NONE","label":"next_seq($self)"},"detail":"($self)","definition":"sub","containerName":"main::"},{"name":"nLength","kind":12,"line":161},{"name":"com_length","line":162,"kind":12},{"name":"type","kind":12,"line":169},{"children":[{"kind":13,"line":187,"name":"$self","definition":"my","containerName":"write_seq","localvar":"my"},{"line":187,"kind":13,"containerName":"write_seq","name":"@seq"},{"definition":"my","name":"$fh","containerName":"write_seq","localvar":"my","kind":13,"line":188},{"containerName":"write_seq","name":"$self","line":188,"kind":13},{"kind":12,"line":188,"name":"_fh","containerName":"write_seq"},{"kind":13,"line":189,"containerName":"write_seq","name":"$seq","definition":"my","localvar":"my"},{"name":"@seq","containerName":"write_seq","line":189,"kind":13},{"line":190,"kind":13,"containerName":"write_seq","name":"$self"},{"kind":12,"line":190,"name":"throw","containerName":"write_seq"},{"kind":13,"line":191,"containerName":"write_seq","name":"$seq"},{"containerName":"write_seq","name":"$seq","line":191,"kind":13},{"name":"$seq","containerName":"write_seq","line":191,"kind":13},{"containerName":"write_seq","name":"isa","kind":12,"line":191},{"kind":13,"line":192,"containerName":"write_seq","definition":"my","name":"$headerdata","localvar":"my"},{"containerName":"write_seq","name":"$c","kind":13,"line":192},{"kind":12,"line":192,"name":"pack","containerName":"write_seq"},{"containerName":"write_seq","name":"$alphabet2type","line":194,"kind":13},{"kind":13,"line":194,"name":"$seq","containerName":"write_seq"},{"containerName":"write_seq","name":"alphabet","line":194,"kind":12},{"containerName":"write_seq","name":"$alphabet2type","kind":13,"line":194},{"kind":13,"line":195,"containerName":"write_seq","name":"$seq"},{"containerName":"write_seq","name":"is_circular","line":195,"kind":12},{"line":196,"kind":13,"containerName":"write_seq","name":"$seq"},{"kind":12,"line":196,"containerName":"write_seq","name":"length"},{"name":"$seq","containerName":"write_seq","kind":13,"line":198},{"name":"desc","containerName":"write_seq","kind":12,"line":198},{"line":200,"kind":13,"name":"$fh","containerName":"write_seq"},{"line":200,"kind":13,"name":"$headerdata","containerName":"write_seq"},{"line":200,"kind":13,"containerName":"write_seq","name":"$seq"},{"containerName":"write_seq","name":"seq","line":200,"kind":12},{"containerName":"write_seq","name":"$seq","kind":13,"line":200},{"line":200,"kind":12,"name":"desc","containerName":"write_seq"}],"line":186,"kind":12,"signature":{"documentation":"};\n# $Id: strider.pm 16123 2009-09-17 12:57:27Z cjfields $\n# BioPerl module for Bio::SeqIO::strider\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Malcolm Cook <mec@stowers-institute.org>\n#\n# You may distribute this module under the same terms as perl itself\n#\n# _history\n# April 7th, 2005  Malcolm Cook authored\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::strider - DNA strider sequence input/output stream\n\n=head1 SYNOPSIS\n\nDo not use this module directly.  Use it via the Bio::SeqIO class.\n\n=head1 DESCRIPTION\n\nThis object can transform Bio::Seq objects to and from strider\n'binary' format, as documented in the strider manual, in which the\nfirst 112 bytes are a header, following by the sequence, followed by a\nsequence description.\n\nNote: it does NOT assign any sequence identifier, since they are not\ncontained in the byte stream of the file; the Strider application\nsimply displays the name of the file on disk as the name of the\nsequence. The caller should set the id, probably based on the name of\nthe file (after possibly cleaning up whitespace, which ought not to be\nused as the id in most applications).\n\nNote: the strider 'comment' is mapped to the BioPerl 'description'\n(since there is no other text field, and description maps to defline\ntext).\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS - Malcolm Cook\n\nEmail: mec@stowers-institute.org\n\n=head1 CONTRIBUTORS\n\nModelled after Bio::SeqIO::fasta by Ewan Birney E<lt>birney@ebi.ac.ukE<gt> and\nLincoln Stein E<lt>lstein@cshl.orgE<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SeqIO::strider;\nuse strict;\nuse warnings;\n\n\nuse Bio::Seq::SeqFactory;\nuse Convert::Binary::C;\n\nuse base qw(Bio::SeqIO);\n\nmy $c = new Convert::Binary::C (\n\t\t\t\tByteOrder => 'BigEndian',\n\t\t\t\tAlignment => 2\n\t\t\t       );\n\nmy $headerdef;\n{local ($/);\n # See this file's __DATA__ section for the c structure definitions\n # for strider binary header data.  Here we slurp it all into $headerdef.\n $headerdef = <DATA>};\n\n$c->parse($headerdef);\n\nmy $size_F_HEADER = 112;\n\ndie \"expected strider header structure size of $size_F_HEADER\" unless $size_F_HEADER eq $c->sizeof('F_HEADER');\n\nmy %alphabet2type = (\n\t\t     # map between BioPerl alphabet and strider\n\t\t     # sequence type code.\n\n\t\t     # From Strider Documentation: the sequence type:\n\t\t     # 1, 2, 3 and 4 for DNA, DNA Degenerate, RNA and\n\t\t     # Protein sequence files, respectively.  \n\n\t\t     # TODO: determine 'DNA Degenerate' based on\n\t\t     # sequence alphabet?\n\n\t\t     dna => 1,\n\t\t     rna => 3,\n\t\t     protein => 4,\n\t\t    );\n\nmy %type2alphabet = reverse %alphabet2type;\n\nsub _initialize {\n  my($self,@args) = @_;\n  $self->SUPER::_initialize(@args);  \n  unless ( defined $self->sequence_factory ) {\n    $self->sequence_factory(Bio::Seq::SeqFactory->new(-verbose => $self->verbose(), \n\t\t\t\t\t\t      -type => 'Bio::Seq::RichSeq'));\n  }\n}\n\n=head2 next_seq\n\n Title   : next_seq\n Usage   : $seq = $stream->next_seq()\n Function: returns the next sequence in the stream\n Returns : Bio::Seq object\n Args    : NONE\n\n\nsub next_seq {\n  my( $self ) = @_;\n  my $fh =  $self->_fh;\n  my ($header,$sequence,$fulldesc);\n  eval {read $fh,$header,$size_F_HEADER};\n  $self->throw (\"$@  while attempting to reading strider header from \" . $self->{'_file'}) if $@; \n  $self->throw(\"required $size_F_HEADER bytes while reading strider header in \" . $self->{'_file'} . \" but found: \" . length($header))  \n    unless $size_F_HEADER == length($header);\n  my $headerdata = $c->unpack('F_HEADER',$header) or return;\n  read $fh,$sequence,$headerdata->{nLength};\n  read $fh,$fulldesc,$headerdata->{com_length};\n  $fulldesc =~ s/\\cM/ /g;\t# gratuitous replacement of mac\n                                # linefeed with space.\n  my $seq = $self->sequence_factory->create(\n\t\t\t\t\t    # -id          => $main::ARGV, #might want to set this in caller to $ARGV.\n\t\t\t\t\t    -seq         => $sequence,\n\t\t\t\t\t    -desc        => $fulldesc,\n\t\t\t\t\t    -alphabet    => $type2alphabet{$headerdata->{type}} || 'dna',\n\t\t\t\t\t   );\n\n  return $seq;\n}\n\n=head2 write_seq\n\n Title   : write_seq\n Usage   : $stream->write_seq(@seq)\n Function: writes the $seq object into the stream\n Returns : 1 for success and 0 for error\n Args    : array of 1 to n Bio::PrimarySeqI objects","parameters":[{"label":"$self"},{"label":"@seq"}],"label":"write_seq($self,@seq)"},"detail":"($self,@seq)","definition":"sub","containerName":"main::","range":{"start":{"character":0,"line":186},"end":{"line":202,"character":9999}},"name":"write_seq"},{"name":"versionNb","line":193,"kind":12},{"name":"type","line":194,"kind":12},{"line":194,"kind":12,"name":"dna"},{"name":"topology","line":195,"kind":12},{"kind":12,"line":196,"name":"nLength"},{"line":197,"kind":12,"name":"nMinus"},{"kind":12,"line":198,"name":"com_length"}],"version":5}