{"version":5,"vars":[{"containerName":"","name":"vars","line":85,"kind":2},{"name":"$FASTALINELEN","containerName":null,"kind":13,"line":90},{"line":90,"kind":2,"name":"SeqFactory","containerName":"strict::Bio::Seq"},{"kind":2,"line":91,"containerName":"","name":"base"},{"name":"_initialize","range":{"start":{"character":0,"line":93},"end":{"line":101,"character":9999}},"containerName":"main::","definition":"sub","detail":"($self,@args)","signature":{"label":"_initialize($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":""},"kind":12,"line":93,"children":[{"kind":13,"line":94,"containerName":"_initialize","definition":"my","name":"$self","localvar":"my"},{"line":94,"kind":13,"containerName":"_initialize","name":"@args"},{"containerName":"_initialize","name":"$self","line":95,"kind":13},{"kind":13,"line":95,"name":"@args","containerName":"_initialize"},{"containerName":"_initialize","name":"$self","line":96,"kind":13},{"containerName":"_initialize","name":"sequence_factory","kind":12,"line":96},{"containerName":"_initialize","name":"$self","kind":13,"line":97},{"containerName":"_initialize","name":"sequence_factory","kind":12,"line":97},{"name":"new","containerName":"_initialize","kind":12,"line":98},{"name":"$self","containerName":"_initialize","kind":13,"line":98},{"line":98,"kind":12,"containerName":"_initialize","name":"verbose"}]},{"line":95,"kind":12,"containerName":"_initialize","name":"SUPER"},{"name":"Bio","containerName":"Seq::SeqFactory","kind":12,"line":97},{"containerName":"main::","definition":"sub","detail":"($self)","signature":{"label":"next_seq($self)","documentation":"1;\n# $Id: largefasta.pm 16123 2009-09-17 12:57:27Z cjfields $\n# BioPerl module for Bio::SeqIO::largefasta\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n# _history\n# \n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::largefasta - method i/o on very large fasta sequence files\n\n=head1 SYNOPSIS\n\nDo not use this module directly.  Use it via the Bio::SeqIO class.\n\n=head1 DESCRIPTION\n\nThis object can transform Bio::Seq objects to and from fasta flat\nfile databases.\n\nThis module handles very large sequence files by using the\nBio::Seq::LargePrimarySeq module to store all the sequence data in\na file.  This can be a problem if you have limited disk space on your\ncomputer because this will effectively cause 2 copies of the sequence\nfile to reside on disk for the life of the\nBio::Seq::LargePrimarySeq object.  The default location for this is\nspecified by the L<File::Spec>-E<gt>tmpdir routine which is usually /tmp\non UNIX.  If a sequence file is larger than the swap space (capacity\nof the /tmp dir) this could cause problems for the machine.  It is\npossible to set the directory where the temporary file is located by\nadding the following line to your code BEFORE calling next_seq. See\nL<Bio::Seq::LargePrimarySeq> for more information.\n\n    $Bio::Seq::LargePrimarySeq::DEFAULT_TEMP_DIR = 'newdir';\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS - Jason Stajich\n\nEmail: jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SeqIO::largefasta;\nuse vars qw($FASTALINELEN);\nuse strict;\n\nuse Bio::Seq::SeqFactory;\n\n$FASTALINELEN = 60;\nuse base qw(Bio::SeqIO);\n\nsub _initialize {\n  my($self,@args) = @_;\n  $self->SUPER::_initialize(@args);    \n  if( ! defined $self->sequence_factory ) {\n      $self->sequence_factory(Bio::Seq::SeqFactory->new\n\t\t\t      (-verbose => $self->verbose(), \n\t\t\t       -type => 'Bio::Seq::LargePrimarySeq'));      \n  }\n}\n\n=head2 next_seq\n\n Title   : next_seq\n Usage   : $seq = $stream->next_seq()\n Function: returns the next sequence in the stream\n Returns : A Bio::Seq::LargePrimarySeq object\n Args    : NONE","parameters":[{"label":"$self"}]},"kind":12,"line":113,"children":[{"definition":"my","name":"$self","containerName":"next_seq","localvar":"my","kind":13,"line":114},{"localvar":"my","containerName":"next_seq","definition":"my","name":"$largeseq","line":116,"kind":13},{"line":116,"kind":13,"containerName":"next_seq","name":"$self"},{"kind":12,"line":116,"name":"sequence_factory","containerName":"next_seq"},{"line":116,"kind":12,"containerName":"next_seq","name":"create"},{"line":117,"kind":13,"localvar":"my","definition":"my","name":"$id","containerName":"next_seq"},{"kind":13,"line":117,"containerName":"next_seq","name":"$fulldesc"},{"name":"$entry","containerName":"next_seq","kind":13,"line":117},{"kind":13,"line":118,"containerName":"next_seq","name":"$count","definition":"my","localvar":"my"},{"localvar":"my","name":"$seen","definition":"my","containerName":"next_seq","line":119,"kind":13},{"name":"$entry","containerName":"next_seq","kind":13,"line":120},{"line":120,"kind":13,"containerName":"next_seq","name":"$self"},{"line":120,"kind":12,"containerName":"next_seq","name":"_readline"},{"line":121,"kind":13,"containerName":"next_seq","name":"$seen"},{"line":121,"kind":13,"containerName":"next_seq","name":"$entry"},{"line":122,"kind":13,"name":"$self","containerName":"next_seq"},{"containerName":"next_seq","name":"_pushback","line":122,"kind":12},{"line":122,"kind":13,"containerName":"next_seq","name":"$entry"},{"line":123,"kind":13,"containerName":"next_seq","name":"$largeseq"},{"kind":13,"line":126,"containerName":"next_seq","name":"$entry"},{"kind":13,"line":126,"containerName":"next_seq","name":"$seen"},{"name":"$entry","containerName":"next_seq","kind":13,"line":127},{"kind":13,"line":128,"name":"$seen","containerName":"next_seq"},{"containerName":"next_seq","name":"$id","kind":13,"line":129},{"line":129,"kind":13,"containerName":"next_seq","name":"$fulldesc"},{"name":"$self","containerName":"next_seq","line":130,"kind":13},{"containerName":"next_seq","name":"warn","kind":12,"line":130},{"kind":13,"line":131,"name":"$largeseq","containerName":"next_seq"},{"line":131,"kind":12,"containerName":"next_seq","name":"display_id"},{"name":"$id","containerName":"next_seq","kind":13,"line":131},{"line":132,"kind":13,"containerName":"next_seq","name":"$largeseq"},{"kind":12,"line":132,"name":"primary_id","containerName":"next_seq"},{"containerName":"next_seq","name":"$id","line":132,"kind":13},{"name":"$largeseq","containerName":"next_seq","kind":13,"line":133},{"kind":12,"line":133,"containerName":"next_seq","name":"desc"},{"line":133,"kind":13,"containerName":"next_seq","name":"$fulldesc"},{"kind":13,"line":135,"name":"$entry","containerName":"next_seq"},{"line":136,"kind":13,"name":"$largeseq","containerName":"next_seq"},{"containerName":"next_seq","name":"add_sequence_as_string","line":136,"kind":12},{"name":"$entry","containerName":"next_seq","kind":13,"line":136},{"containerName":"next_seq","name":"$count","line":138,"kind":13},{"kind":13,"line":138,"containerName":"next_seq","name":"$self"},{"kind":12,"line":138,"name":"verbose","containerName":"next_seq"},{"containerName":"next_seq","name":"$seen","line":140,"kind":13},{"name":"$largeseq","containerName":"next_seq","line":141,"kind":13}],"name":"next_seq","range":{"start":{"line":113,"character":0},"end":{"character":9999,"line":142}}},{"name":"write_seq","range":{"start":{"line":155,"character":0},"end":{"line":176,"character":9999}},"containerName":"main::","definition":"sub","detail":"($self,@seq)","signature":{"documentation":"1;\n# $Id: largefasta.pm 16123 2009-09-17 12:57:27Z cjfields $\n# BioPerl module for Bio::SeqIO::largefasta\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n# _history\n# \n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::largefasta - method i/o on very large fasta sequence files\n\n=head1 SYNOPSIS\n\nDo not use this module directly.  Use it via the Bio::SeqIO class.\n\n=head1 DESCRIPTION\n\nThis object can transform Bio::Seq objects to and from fasta flat\nfile databases.\n\nThis module handles very large sequence files by using the\nBio::Seq::LargePrimarySeq module to store all the sequence data in\na file.  This can be a problem if you have limited disk space on your\ncomputer because this will effectively cause 2 copies of the sequence\nfile to reside on disk for the life of the\nBio::Seq::LargePrimarySeq object.  The default location for this is\nspecified by the L<File::Spec>-E<gt>tmpdir routine which is usually /tmp\non UNIX.  If a sequence file is larger than the swap space (capacity\nof the /tmp dir) this could cause problems for the machine.  It is\npossible to set the directory where the temporary file is located by\nadding the following line to your code BEFORE calling next_seq. See\nL<Bio::Seq::LargePrimarySeq> for more information.\n\n    $Bio::Seq::LargePrimarySeq::DEFAULT_TEMP_DIR = 'newdir';\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS - Jason Stajich\n\nEmail: jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SeqIO::largefasta;\nuse vars qw($FASTALINELEN);\nuse strict;\n\nuse Bio::Seq::SeqFactory;\n\n$FASTALINELEN = 60;\nuse base qw(Bio::SeqIO);\n\nsub _initialize {\n  my($self,@args) = @_;\n  $self->SUPER::_initialize(@args);    \n  if( ! defined $self->sequence_factory ) {\n      $self->sequence_factory(Bio::Seq::SeqFactory->new\n\t\t\t      (-verbose => $self->verbose(), \n\t\t\t       -type => 'Bio::Seq::LargePrimarySeq'));      \n  }\n}\n\n=head2 next_seq\n\n Title   : next_seq\n Usage   : $seq = $stream->next_seq()\n Function: returns the next sequence in the stream\n Returns : A Bio::Seq::LargePrimarySeq object\n Args    : NONE\n\n\nsub next_seq {\n    my ($self) = @_;\n#  local $/ = \"\\n\";\n    my $largeseq = $self->sequence_factory->create();\n    my ($id,$fulldesc,$entry);\n    my $count = 0;\n    my $seen = 0;\n    while( defined ($entry = $self->_readline) ) {\n\tif( $seen == 1 && $entry =~ /^\\s*>/ ) {\n\t    $self->_pushback($entry);\n\t    return $largeseq;\n\t}\n#\tif ( ($entry eq '>') || eof($self->_fh) ) { $seen = 1; next; }      \n\tif ( ($entry eq '>')  ) { $seen = 1; next; }      \n\telsif( $entry =~ /\\s*>(.+?)$/ ) {\n\t    $seen = 1;\n\t    ($id,$fulldesc) = ($1 =~ /^\\s*(\\S+)\\s*(.*)$/)\n\t\tor $self->warn(\"Can't parse fasta header\");\n\t    $largeseq->display_id($id);\n\t    $largeseq->primary_id($id);\t  \n\t    $largeseq->desc($fulldesc);\n\t} else {\n\t    $entry =~ s/\\s+//g;\n\t    $largeseq->add_sequence_as_string($entry);\n\t}\n\t(++$count % 1000 == 0 && $self->verbose() > 0) && print \"line $count\\n\";\n    }\n    return unless $seen;\n    return $largeseq;\n}\n\n=head2 write_seq\n\n Title   : write_seq\n Usage   : $stream->write_seq(@seq)\n Function: writes the $seq object into the stream\n Returns : 1 for success and 0 for error\n Args    : Bio::Seq object","parameters":[{"label":"$self"},{"label":"@seq"}],"label":"write_seq($self,@seq)"},"kind":12,"line":155,"children":[{"definition":"my","name":"$self","containerName":"write_seq","localvar":"my","kind":13,"line":156},{"kind":13,"line":156,"name":"@seq","containerName":"write_seq"},{"kind":13,"line":157,"definition":"my","name":"$seq","containerName":"write_seq","localvar":"my"},{"name":"@seq","containerName":"write_seq","kind":13,"line":157},{"kind":13,"line":158,"name":"$top","definition":"my","containerName":"write_seq","localvar":"my"},{"name":"$seq","containerName":"write_seq","kind":13,"line":158},{"name":"id","containerName":"write_seq","kind":12,"line":158},{"kind":13,"line":159,"containerName":"write_seq","name":"$seq"},{"name":"can","containerName":"write_seq","line":159,"kind":12},{"line":159,"kind":13,"localvar":"my","name":"$desc","definition":"my","containerName":"write_seq"},{"name":"$seq","containerName":"write_seq","line":159,"kind":13},{"line":159,"kind":12,"name":"desc","containerName":"write_seq"},{"line":160,"kind":13,"containerName":"write_seq","name":"$desc"},{"kind":13,"line":161,"containerName":"write_seq","name":"$top"},{"line":163,"kind":13,"name":"$self","containerName":"write_seq"},{"line":163,"kind":12,"name":"_print","containerName":"write_seq"},{"kind":13,"line":163,"name":"$top","containerName":"write_seq"},{"containerName":"write_seq","definition":"my","name":"$end","localvar":"my","kind":13,"line":164},{"line":164,"kind":13,"name":"$seq","containerName":"write_seq"},{"line":164,"kind":12,"containerName":"write_seq","name":"length"},{"kind":13,"line":165,"containerName":"write_seq","name":"$start","definition":"my","localvar":"my"},{"containerName":"write_seq","name":"$start","kind":13,"line":166},{"line":166,"kind":13,"name":"$end","containerName":"write_seq"},{"containerName":"write_seq","definition":"my","name":"$stop","localvar":"my","kind":13,"line":167},{"name":"$start","containerName":"write_seq","kind":13,"line":167},{"name":"$FASTALINELEN","containerName":"write_seq","line":167,"kind":13},{"line":168,"kind":13,"name":"$stop","containerName":"write_seq"},{"line":168,"kind":13,"name":"$end","containerName":"write_seq"},{"line":168,"kind":13,"containerName":"write_seq","name":"$stop"},{"name":"$end","containerName":"write_seq","line":168,"kind":13},{"containerName":"write_seq","name":"$self","line":169,"kind":13},{"line":169,"kind":12,"containerName":"write_seq","name":"_print"},{"containerName":"write_seq","name":"$seq","kind":13,"line":169},{"name":"subseq","containerName":"write_seq","kind":12,"line":169},{"containerName":"write_seq","name":"$start","kind":13,"line":169},{"name":"$stop","containerName":"write_seq","line":169,"kind":13},{"containerName":"write_seq","name":"$start","line":170,"kind":13},{"line":170,"kind":13,"name":"$FASTALINELEN","containerName":"write_seq"},{"kind":13,"line":174,"name":"$self","containerName":"write_seq"},{"containerName":"write_seq","name":"flush","line":174,"kind":12},{"containerName":"write_seq","name":"$self","line":174,"kind":13},{"name":"_flush_on_write","containerName":"write_seq","line":174,"kind":12},{"name":"$self","containerName":"write_seq","line":174,"kind":13},{"containerName":"write_seq","name":"_fh","line":174,"kind":12}]}]}