{"version":5,"vars":[{"name":"vars","containerName":"","kind":2,"line":79},{"name":"base","containerName":"","kind":2,"line":81},{"detail":"($caller,$seq,$ann,$comp,$map,$src)","signature":{"label":"new($caller,$seq,$ann,$comp,$map,$src)","parameters":[{"label":"$caller"},{"label":"$seq"},{"label":"$ann"},{"label":"$comp"},{"label":"$map"},{"label":"$src"}],"documentation":"1;\n# $Id: seqHandler.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqIO::game::seqHandler\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sheldon McKay <mckays@cshl.edu>\n#\n# You may distribute this module under the same terms as perl itself\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::game::seqHandler -- a class for handling game-XML sequences\n\n=head1 SYNOPSIS\n\nThis modules is not used directly\n\n=head1 DESCRIPTION\n\nBio::SeqIO::game::seqHandler processes all of the sequences associated with a game record\nand, via feature handlers, processes the associated annotations\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\nto one of the Bioperl mailing lists.\n\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sheldon McKay\n\nEmail mckays@cshl.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::SeqIO::game::seqHandler;\n\nuse Data::Dumper;\n\nuse Bio::SeqIO::game::featHandler;\nuse Bio::SeqFeature::Generic;\nuse Bio::Seq::RichSeq;\nuse Bio::Species;\nuse strict;\n\nuse vars qw {};\n\nuse base qw(Bio::SeqIO::game::gameSubs);\n\n=head2 new\n\n Title   : new\n Usage   : my $seqHandler = Bio::SeqIO::game::seqHandler->new($seq, $ann, $comp, $map, $src )\n Function: constructor method to create a sequence handler\n Returns : a sequence handler object\n Args    : $seq  -- an XML sequence element\n           $ann  -- a ref. to a list of <annotation> elements\n           $comp -- a ref. to a list of <computational_analysis> elements (not used yet)\n           $map  -- a <map_position> element\n           $src  -- a flag to indicate that the sequence already has a source feature"},"containerName":"main::","definition":"sub","line":97,"children":[{"line":98,"kind":13,"localvar":"my","name":"$caller","definition":"my","containerName":"new"},{"containerName":"new","name":"$seq","kind":13,"line":98},{"kind":13,"line":98,"name":"$ann","containerName":"new"},{"kind":13,"line":98,"containerName":"new","name":"$comp"},{"kind":13,"line":98,"name":"$map","containerName":"new"},{"containerName":"new","name":"$src","kind":13,"line":98},{"containerName":"new","definition":"my","name":"$class","localvar":"my","kind":13,"line":100},{"line":100,"kind":13,"containerName":"new","name":"$caller"},{"name":"$caller","containerName":"new","kind":13,"line":100},{"containerName":"new","name":"$self","definition":"my","localvar":"my","kind":13,"line":102},{"name":"$seq","containerName":"new","kind":13,"line":103},{"name":"$ann","containerName":"new","kind":13,"line":104},{"containerName":"new","name":"$comp","line":105,"kind":13},{"name":"$map","containerName":"new","line":106,"kind":13},{"name":"$src","containerName":"new","kind":13,"line":107},{"name":"$class","containerName":"new","kind":13,"line":110},{"name":"$self","containerName":"new","kind":13,"line":112}],"kind":12,"range":{"end":{"character":9999,"line":113},"start":{"line":97,"character":0}},"name":"new"},{"line":103,"kind":12,"name":"seqs"},{"kind":12,"line":104,"name":"anns"},{"line":105,"kind":12,"name":"comps"},{"kind":12,"line":106,"name":"map_pos"},{"name":"has_source","kind":12,"line":107},{"name":"seq_h","line":108,"kind":12},{"name":"ann_l","line":109,"kind":12},{"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"convert","line":128,"kind":13},{"localvar":"my","containerName":"convert","definition":"my","name":"@ann","line":129,"kind":13},{"kind":13,"line":129,"name":"$self","containerName":"convert"}],"line":127,"kind":12,"range":{"start":{"line":127,"character":0},"end":{"line":129,"character":9999}},"name":"convert","definition":"sub","containerName":"main::"},{"kind":12,"line":129,"name":"anns"},{"name":"%self","containerName":null,"kind":13,"line":129},{"line":129,"kind":12,"name":"anns"},{"definition":"my","name":"@seq","containerName":null,"localvar":"my","kind":13,"line":130},{"name":"%self","containerName":null,"line":130,"kind":13},{"line":130,"kind":12,"name":"seqs"},{"line":133,"kind":13,"localvar":"my","containerName":null,"name":"@comp","definition":"my"},{"name":"%self","containerName":null,"line":134,"kind":13},{"line":134,"kind":12,"name":"comps"},{"line":135,"kind":13,"containerName":null,"name":"@comp"},{"kind":13,"line":135,"containerName":null,"name":"%self"},{"kind":12,"line":135,"name":"comps"},{"containerName":null,"name":"@seq","line":139,"kind":13},{"kind":13,"line":140,"name":"$self","containerName":null},{"kind":12,"line":140,"name":"_add_seq","containerName":"main::"},{"name":"@ann","containerName":null,"line":144,"kind":13},{"name":"$self","containerName":null,"kind":13,"line":145},{"kind":12,"line":145,"containerName":"main::","name":"_annotation"},{"line":148,"kind":13,"name":"$self","containerName":null},{"name":"_order_feats","containerName":"main::","kind":12,"line":148},{"name":"%self","containerName":null,"kind":13,"line":148},{"kind":12,"line":148,"name":"seq_h"},{"line":162,"children":[{"line":163,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"_order_feats"},{"kind":13,"line":163,"containerName":"_order_feats","name":"$seqs"},{"line":164,"kind":13,"localvar":"my","containerName":"_order_feats","definition":"my","name":"$seq"},{"line":164,"kind":13,"name":"$self","containerName":"_order_feats"},{"line":165,"kind":13,"localvar":"my","definition":"my","name":"$id","containerName":"_order_feats"},{"name":"$seq","containerName":"_order_feats","line":165,"kind":13},{"name":"id","containerName":"_order_feats","line":165,"kind":12},{"line":166,"kind":13,"localvar":"my","definition":"my","name":"$ann","containerName":"_order_feats"},{"name":"$self","containerName":"_order_feats","line":166,"kind":13},{"localvar":"my","containerName":"_order_feats","name":"@src","definition":"my","line":169,"kind":13},{"containerName":"_order_feats","name":"primary_tag","kind":12,"line":169},{"kind":13,"line":169,"containerName":"_order_feats","name":"$ann"},{"line":171,"kind":13,"localvar":"my","containerName":"_order_feats","name":"@genes","definition":"my"},{"line":171,"kind":12,"name":"primary_tag","containerName":"_order_feats"},{"containerName":"_order_feats","name":"$ann","line":171,"kind":13},{"definition":"my","name":"@other","containerName":"_order_feats","localvar":"my","kind":13,"line":172},{"line":172,"kind":13,"containerName":"_order_feats","name":"$a"},{"kind":12,"line":172,"containerName":"_order_feats","name":"start"},{"name":"$b","containerName":"_order_feats","kind":13,"line":172},{"name":"start","containerName":"_order_feats","kind":12,"line":172},{"containerName":"_order_feats","name":"$b","kind":13,"line":172},{"kind":12,"line":172,"containerName":"_order_feats","name":"end"},{"kind":13,"line":172,"name":"$a","containerName":"_order_feats"},{"kind":12,"line":172,"name":"end","containerName":"_order_feats"},{"kind":12,"line":173,"containerName":"_order_feats","name":"primary_tag"},{"kind":12,"line":174,"containerName":"_order_feats","name":"primary_tag"},{"containerName":"_order_feats","name":"$ann","line":174,"kind":13},{"name":"$seq","containerName":"_order_feats","line":176,"kind":13},{"kind":13,"line":176,"containerName":"_order_feats","name":"@src"},{"name":"@genes","containerName":"_order_feats","line":176,"kind":13},{"kind":13,"line":176,"containerName":"_order_feats","name":"@other"}],"kind":12,"detail":"($self,$seqs)","signature":{"label":"_order_feats($self,$seqs)","documentation":"1;\n# $Id: seqHandler.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqIO::game::seqHandler\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sheldon McKay <mckays@cshl.edu>\n#\n# You may distribute this module under the same terms as perl itself\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::game::seqHandler -- a class for handling game-XML sequences\n\n=head1 SYNOPSIS\n\nThis modules is not used directly\n\n=head1 DESCRIPTION\n\nBio::SeqIO::game::seqHandler processes all of the sequences associated with a game record\nand, via feature handlers, processes the associated annotations\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\nto one of the Bioperl mailing lists.\n\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sheldon McKay\n\nEmail mckays@cshl.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::SeqIO::game::seqHandler;\n\nuse Data::Dumper;\n\nuse Bio::SeqIO::game::featHandler;\nuse Bio::SeqFeature::Generic;\nuse Bio::Seq::RichSeq;\nuse Bio::Species;\nuse strict;\n\nuse vars qw {};\n\nuse base qw(Bio::SeqIO::game::gameSubs);\n\n=head2 new\n\n Title   : new\n Usage   : my $seqHandler = Bio::SeqIO::game::seqHandler->new($seq, $ann, $comp, $map, $src )\n Function: constructor method to create a sequence handler\n Returns : a sequence handler object\n Args    : $seq  -- an XML sequence element\n           $ann  -- a ref. to a list of <annotation> elements\n           $comp -- a ref. to a list of <computational_analysis> elements (not used yet)\n           $map  -- a <map_position> element\n           $src  -- a flag to indicate that the sequence already has a source feature\n\n\nsub new {\n    my ($caller, $seq, $ann, $comp, $map, $src ) =  @_;\n\n    my $class = ref($caller) || $caller;\n\n    my $self = bless ( { \n\tseqs     => $seq,\n        anns     => $ann,\n        comps    => $comp,\n        map_pos  => $map,\n\thas_source => $src,\n        seq_h    => {},\n\tann_l    => []\n    }, $class );\n\n    return $self;\n}\n\n=head2 convert\n\n Title   : convert\n Usage   : @seqs = $seqHandler->convert\n Function: converts the main XML sequence element and associated annotations to Bio::\n Returns : a ref. to a an array containing the sequence object and a ref. to a list of  features\n Args    : none\n\n Note    : The features and sequence are kept apart to facilitate downstream filtering of features \n\n\nsub convert {\n    my $self = shift;\n    my @ann  = @{$self->{anns}} if defined $self->{anns};;\n    my @seq  = @{$self->{seqs}};\n    \n    # not used yet\n    my @comp;\n    if ( $self->{comps} ) {\n        @comp = @{$self->{comps}}    \n    }\n    \n    # process the sequence elements\n    for ( @seq ) {\n\t$self->_add_seq( $_ );\n    }\n    \n    # process the annotation elements\n    for ( @ann ) {\n\t$self->_annotation( $_ );\n    }\n    \n    return $self->_order_feats( $self->{seq_h} );\n}\n\n=head2 _order_feats\n\n Title   : _order_feats\n Usage   : $self->_order_feats( $self->{seq_h} )\n Function: an internal method to ensure the source feature comes first\n           and keep gene, mRNA and CDS features together \n Returns : a ref. to an array containing the sequence object and a ref. to a list of  features \n Args    : a ref. to a hash of sequences","parameters":[{"label":"$self"},{"label":"$seqs"}]},"containerName":"main::","definition":"sub","range":{"end":{"line":177,"character":9999},"start":{"line":162,"character":0}},"name":"_order_feats"},{"line":164,"kind":12,"name":"main_seq"},{"name":"ann_l","kind":12,"line":166},{"definition":"sub","containerName":"main::","signature":{"label":"_add_seq($self,$el)","documentation":"1;\n# $Id: seqHandler.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqIO::game::seqHandler\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sheldon McKay <mckays@cshl.edu>\n#\n# You may distribute this module under the same terms as perl itself\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::game::seqHandler -- a class for handling game-XML sequences\n\n=head1 SYNOPSIS\n\nThis modules is not used directly\n\n=head1 DESCRIPTION\n\nBio::SeqIO::game::seqHandler processes all of the sequences associated with a game record\nand, via feature handlers, processes the associated annotations\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\nto one of the Bioperl mailing lists.\n\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sheldon McKay\n\nEmail mckays@cshl.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::SeqIO::game::seqHandler;\n\nuse Data::Dumper;\n\nuse Bio::SeqIO::game::featHandler;\nuse Bio::SeqFeature::Generic;\nuse Bio::Seq::RichSeq;\nuse Bio::Species;\nuse strict;\n\nuse vars qw {};\n\nuse base qw(Bio::SeqIO::game::gameSubs);\n\n=head2 new\n\n Title   : new\n Usage   : my $seqHandler = Bio::SeqIO::game::seqHandler->new($seq, $ann, $comp, $map, $src )\n Function: constructor method to create a sequence handler\n Returns : a sequence handler object\n Args    : $seq  -- an XML sequence element\n           $ann  -- a ref. to a list of <annotation> elements\n           $comp -- a ref. to a list of <computational_analysis> elements (not used yet)\n           $map  -- a <map_position> element\n           $src  -- a flag to indicate that the sequence already has a source feature\n\n\nsub new {\n    my ($caller, $seq, $ann, $comp, $map, $src ) =  @_;\n\n    my $class = ref($caller) || $caller;\n\n    my $self = bless ( { \n\tseqs     => $seq,\n        anns     => $ann,\n        comps    => $comp,\n        map_pos  => $map,\n\thas_source => $src,\n        seq_h    => {},\n\tann_l    => []\n    }, $class );\n\n    return $self;\n}\n\n=head2 convert\n\n Title   : convert\n Usage   : @seqs = $seqHandler->convert\n Function: converts the main XML sequence element and associated annotations to Bio::\n Returns : a ref. to a an array containing the sequence object and a ref. to a list of  features\n Args    : none\n\n Note    : The features and sequence are kept apart to facilitate downstream filtering of features \n\n\nsub convert {\n    my $self = shift;\n    my @ann  = @{$self->{anns}} if defined $self->{anns};;\n    my @seq  = @{$self->{seqs}};\n    \n    # not used yet\n    my @comp;\n    if ( $self->{comps} ) {\n        @comp = @{$self->{comps}}    \n    }\n    \n    # process the sequence elements\n    for ( @seq ) {\n\t$self->_add_seq( $_ );\n    }\n    \n    # process the annotation elements\n    for ( @ann ) {\n\t$self->_annotation( $_ );\n    }\n    \n    return $self->_order_feats( $self->{seq_h} );\n}\n\n=head2 _order_feats\n\n Title   : _order_feats\n Usage   : $self->_order_feats( $self->{seq_h} )\n Function: an internal method to ensure the source feature comes first\n           and keep gene, mRNA and CDS features together \n Returns : a ref. to an array containing the sequence object and a ref. to a list of  features \n Args    : a ref. to a hash of sequences\n\n\nsub _order_feats {\n    my ($self, $seqs) = @_;\n    my $seq = $self->{main_seq};\n    my $id  = $seq->id;\n    my $ann = $self->{ann_l};\n\n    # make sure source(s) come first\n    my @src   = grep { $_->primary_tag =~ /source|origin|\\bregion\\b/ } @$ann;\n    # preserve gene->mRNA->CDS or ncRNA->gene->transcript order\n    my @genes = grep { $_->primary_tag =~ /gene|CDS|[a-z]+RNA|transcript/ } @$ann;\n    my @other = sort { $a->start <=> $b->start || $b->end   <=> $a->end  } \n                grep { $_->primary_tag !~ /source|origin|\\bregion\\b/ } \n                grep { $_->primary_tag !~ /gene|mRNA|CDS/ } @$ann;\n    \n    return [$seq, [@src, @genes, @other]];\n}\n\n=head2 _add_seq\n\n Title   : _add_seq\n Usage   : $self->_add_seq($seq_element)\n Function: an internal method to process the sequence elements\n Returns : nothing\n Args    : a sequence element","parameters":[{"label":"$self"},{"label":"$el"}]},"detail":"($self,$el)","kind":12,"children":[{"line":190,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"_add_seq"},{"kind":13,"line":190,"containerName":"_add_seq","name":"$el"},{"line":191,"kind":13,"localvar":"my","name":"$residues","definition":"my","containerName":"_add_seq"},{"line":193,"kind":13,"containerName":"_add_seq","name":"$el"},{"line":194,"kind":13,"containerName":"_add_seq","name":"$residues"},{"kind":13,"line":194,"name":"$el","containerName":"_add_seq"},{"name":"$residues","containerName":"_add_seq","line":195,"kind":13},{"containerName":"_add_seq","name":"$residues","kind":13,"line":196},{"kind":13,"line":197,"name":"$residues","containerName":"_add_seq"},{"localvar":"my","containerName":"_add_seq","definition":"my","name":"$id","line":203,"kind":13},{"name":"$el","containerName":"_add_seq","line":203,"kind":13},{"kind":13,"line":204,"name":"$ver","definition":"my","containerName":"_add_seq","localvar":"my"},{"containerName":"_add_seq","name":"$el","line":204,"kind":13},{"kind":13,"line":205,"containerName":"_add_seq","definition":"my","name":"$name","localvar":"my"},{"line":205,"kind":13,"containerName":"_add_seq","name":"$el"},{"kind":13,"line":207,"containerName":"_add_seq","name":"$name"},{"containerName":"_add_seq","name":"$name","kind":13,"line":207},{"containerName":"_add_seq","name":"$id","kind":13,"line":207},{"line":208,"kind":13,"containerName":"_add_seq","name":"$self"},{"name":"complain","containerName":"_add_seq","line":208,"kind":12},{"localvar":"my","definition":"my","name":"$seq","containerName":"_add_seq","line":212,"kind":13},{"kind":13,"line":212,"name":"$self","containerName":"_add_seq"},{"line":212,"kind":12,"containerName":"_add_seq","name":"_seq"},{"line":212,"kind":13,"name":"$id","containerName":"_add_seq"},{"line":215,"kind":13,"localvar":"my","containerName":"_add_seq","definition":"my","name":"$featHandler"},{"line":215,"kind":13,"name":"$self","containerName":"_add_seq"},{"containerName":"_add_seq","name":"_feat_handler","kind":12,"line":215},{"kind":13,"line":218,"containerName":"_add_seq","name":"$seq"},{"line":218,"kind":12,"containerName":"_add_seq","name":"seq"},{"name":"$residues","containerName":"_add_seq","kind":13,"line":218},{"line":219,"kind":13,"containerName":"_add_seq","name":"$seq"},{"containerName":"_add_seq","name":"seq_version","kind":12,"line":219},{"containerName":"_add_seq","name":"$ver","kind":13,"line":219},{"containerName":"_add_seq","name":"$ver","kind":13,"line":219},{"name":"$id","containerName":"_add_seq","kind":13,"line":222},{"containerName":"_add_seq","name":"$seq","line":223,"kind":13},{"line":223,"kind":12,"name":"accession","containerName":"_add_seq"},{"line":223,"kind":13,"name":"$id","containerName":"_add_seq"},{"containerName":"_add_seq","definition":"my","name":"$focus","localvar":"my","kind":13,"line":228},{"containerName":"_add_seq","name":"$el","kind":13,"line":229},{"line":230,"kind":13,"name":"$self","containerName":"_add_seq"},{"kind":13,"line":230,"containerName":"_add_seq","name":"$seq"},{"containerName":"_add_seq","name":"$focus","line":231,"kind":13},{"line":235,"kind":13,"localvar":"my","definition":"my","name":"$length","containerName":"_add_seq"},{"line":235,"kind":13,"containerName":"_add_seq","name":"$el"},{"containerName":"_add_seq","name":"$length","line":236,"kind":13},{"containerName":"_add_seq","name":"$seq","kind":13,"line":236},{"line":236,"kind":12,"containerName":"_add_seq","name":"length"},{"kind":13,"line":236,"containerName":"_add_seq","name":"$length"},{"containerName":"_add_seq","name":"$seq","kind":13,"line":237},{"name":"seq","containerName":"_add_seq","kind":12,"line":237},{"containerName":"_add_seq","name":"$length","line":237,"kind":13},{"containerName":"_add_seq","name":"$seq","kind":13,"line":237},{"name":"length","containerName":"_add_seq","line":237,"kind":12},{"kind":13,"line":237,"name":"$length","containerName":"_add_seq"},{"name":"$self","containerName":"_add_seq","line":238,"kind":13},{"name":"complain","containerName":"_add_seq","kind":12,"line":238},{"kind":13,"line":238,"name":"$seq","containerName":"_add_seq"},{"containerName":"_add_seq","name":"length","kind":12,"line":238},{"name":"$length","containerName":"_add_seq","line":239,"kind":13},{"name":"$seq","containerName":"_add_seq","line":240,"kind":13},{"containerName":"_add_seq","name":"seq","kind":12,"line":240},{"name":"$seq","containerName":"_add_seq","line":241,"kind":13},{"name":"length","containerName":"_add_seq","line":241,"kind":12},{"containerName":"_add_seq","name":"$length","kind":13,"line":241},{"localvar":"my","name":"$tags","definition":"my","containerName":"_add_seq","line":245,"kind":13},{"line":246,"kind":13,"containerName":"_add_seq","name":"$el"},{"containerName":"_add_seq","name":"$tags","line":247,"kind":13},{"containerName":"_add_seq","name":"$el","kind":13,"line":247},{"name":"$el","containerName":"_add_seq","kind":13,"line":249},{"containerName":"_add_seq","name":"$tags","line":250,"kind":13},{"name":"$tags","containerName":"_add_seq","kind":13,"line":251},{"kind":13,"line":251,"containerName":"_add_seq","name":"$self"},{"kind":12,"line":251,"containerName":"_add_seq","name":"dbxref"},{"kind":13,"line":251,"name":"$el","containerName":"_add_seq"}],"line":189,"name":"_add_seq","range":{"start":{"line":189,"character":0},"end":{"character":9999,"line":252}}},{"line":193,"kind":12,"name":"_residues"},{"kind":12,"line":194,"name":"_residues"},{"name":"Characters","line":194,"kind":12},{"name":"Attributes","kind":12,"line":203},{"kind":12,"line":203,"name":"id"},{"kind":12,"line":204,"name":"Attributes"},{"line":204,"kind":12,"name":"version"},{"line":205,"kind":12,"name":"_name"},{"kind":12,"line":205,"name":"Characters"},{"line":229,"kind":12,"name":"Attributes"},{"name":"focus","line":229,"kind":12},{"name":"main_seq","line":230,"kind":12},{"kind":12,"line":235,"name":"Attributes"},{"kind":12,"line":246,"name":"Attributes"},{"line":246,"kind":12,"name":"md5checksum"},{"kind":12,"line":247,"name":"md5checksum"},{"name":"Attributes","kind":12,"line":247},{"line":247,"kind":12,"name":"md5checksum"},{"kind":12,"line":249,"name":"_dbxref"},{"name":"dbxref","line":250,"kind":12},{"name":"dbxref","kind":12,"line":251},{"kind":12,"line":251,"name":"_dbxref"},{"containerName":null,"name":"%el","kind":13,"line":253},{"name":"_description","kind":12,"line":253},{"localvar":"my","name":"$desc","definition":"my","containerName":null,"line":254,"kind":13},{"kind":13,"line":254,"containerName":null,"name":"%el"},{"name":"_description","kind":12,"line":254},{"line":254,"kind":12,"name":"Characters"},{"name":"$seq","containerName":null,"line":255,"kind":13},{"line":255,"kind":12,"name":"description","containerName":"main::"},{"name":"$desc","containerName":null,"kind":13,"line":255},{"name":"%el","containerName":null,"line":257,"kind":13},{"line":257,"kind":12,"name":"_organism"},{"localvar":"my","name":"@organism","definition":"my","containerName":null,"line":258,"kind":13},{"containerName":null,"name":"%el","line":258,"kind":13},{"name":"_organism","line":258,"kind":12},{"kind":12,"line":258,"name":"Characters"},{"kind":13,"line":259,"containerName":null,"name":"@organism"},{"line":260,"kind":13,"containerName":null,"name":"$self"},{"line":260,"kind":12,"containerName":"main::","name":"complain"},{"line":263,"kind":13,"localvar":"my","name":"$species","definition":"my","containerName":null},{"name":"Bio","containerName":"Species","kind":12,"line":263},{"containerName":"main::","name":"new","kind":12,"line":263},{"kind":13,"line":263,"name":"@organism","containerName":null},{"line":264,"kind":13,"containerName":null,"name":"$seq"},{"kind":12,"line":264,"name":"species","containerName":"main::"},{"name":"$species","containerName":null,"kind":13,"line":264},{"kind":13,"line":267,"name":"$seq","containerName":null},{"line":267,"kind":12,"containerName":"main::","name":"species"},{"containerName":null,"name":"%tags","line":268,"kind":13},{"name":"organism","line":268,"kind":12},{"line":268,"kind":13,"name":"$seq","containerName":null},{"name":"species","containerName":"main::","line":268,"kind":12},{"containerName":"main::","name":"binomial","kind":12,"line":268},{"localvar":"my","containerName":null,"name":"$alphabet","definition":"my","line":284,"kind":13},{"line":284,"kind":13,"name":"%el","containerName":null},{"name":"Attributes","kind":12,"line":284},{"name":"type","line":284,"kind":12},{"kind":13,"line":285,"containerName":null,"name":"%alphabet"},{"containerName":null,"name":"$alphabet","kind":13,"line":286},{"name":"$alphabet","containerName":null,"line":287,"kind":13},{"kind":13,"line":288,"name":"$seq","containerName":null},{"containerName":"main::","name":"alphabet","line":288,"kind":12},{"kind":13,"line":288,"name":"$alphabet","containerName":null},{"kind":13,"line":292,"containerName":null,"name":"%self"},{"kind":12,"line":292,"name":"has_source"},{"kind":13,"line":292,"name":"%focus","containerName":null},{"kind":13,"line":296,"containerName":null,"name":"%focus"},{"name":"$self","containerName":null,"line":298,"kind":13},{"name":"_map_position","containerName":"main::","line":298,"kind":12},{"line":298,"kind":13,"name":"%self","containerName":null},{"name":"map_pos","kind":12,"line":298},{"kind":13,"line":298,"containerName":null,"name":"$seq"},{"kind":13,"line":299,"name":"%featHandler","containerName":null},{"name":"offset","kind":12,"line":299},{"line":299,"kind":13,"name":"%self","containerName":null},{"kind":12,"line":299,"name":"offset"},{"name":"$self","containerName":null,"line":303,"kind":13},{"line":303,"kind":12,"name":"flush","containerName":"main::"},{"name":"_map_position","range":{"start":{"character":0,"line":316},"end":{"line":381,"character":9999}},"kind":12,"line":316,"children":[{"line":317,"kind":13,"localvar":"my","containerName":"_map_position","definition":"my","name":"$self"},{"kind":13,"line":317,"name":"$el","containerName":"_map_position"},{"name":"$el","containerName":"_map_position","kind":13,"line":320},{"kind":13,"line":321,"containerName":"_map_position","name":"$self"},{"localvar":"my","definition":"my","name":"$arm","containerName":"_map_position","line":327,"kind":13},{"name":"$el","containerName":"_map_position","kind":13,"line":327},{"name":"$type","definition":"my","containerName":"_map_position","localvar":"my","kind":13,"line":328},{"kind":13,"line":328,"containerName":"_map_position","name":"$el"},{"definition":"my","name":"$loc","containerName":"_map_position","localvar":"my","kind":13,"line":329},{"containerName":"_map_position","name":"$el","kind":13,"line":329},{"line":330,"kind":13,"localvar":"my","containerName":"_map_position","definition":"my","name":"$start"},{"line":330,"kind":13,"name":"$loc","containerName":"_map_position"},{"localvar":"my","containerName":"_map_position","definition":"my","name":"$end","line":331,"kind":13},{"containerName":"_map_position","name":"$loc","line":331,"kind":13},{"kind":13,"line":337,"name":"$self","containerName":"_map_position"},{"line":337,"kind":13,"containerName":"_map_position","name":"$start"},{"line":339,"kind":13,"localvar":"my","containerName":"_map_position","name":"$seq_id","definition":"my"},{"kind":13,"line":339,"name":"$el","containerName":"_map_position"},{"line":340,"kind":13,"localvar":"my","containerName":"_map_position","name":"$seq","definition":"my"},{"kind":13,"line":340,"name":"$self","containerName":"_map_position"},{"containerName":"_map_position","name":"$seq_id","kind":13,"line":340},{"kind":13,"line":342,"name":"$seq","containerName":"_map_position"},{"kind":13,"line":343,"name":"$self","containerName":"_map_position"},{"line":343,"kind":12,"containerName":"_map_position","name":"throw"},{"line":345,"kind":13,"name":"$seq","containerName":"_map_position"},{"containerName":"_map_position","name":"$self","line":345,"kind":13},{"kind":13,"line":346,"name":"$self","containerName":"_map_position"},{"line":346,"kind":12,"name":"throw","containerName":"_map_position"},{"definition":"my","name":"$species","containerName":"_map_position","localvar":"my","kind":13,"line":349},{"containerName":"_map_position","name":"$self","line":352,"kind":13},{"definition":"my","name":"$feat","containerName":"_map_position","localvar":"my","kind":13,"line":353},{"name":"$self","containerName":"_map_position","line":353,"kind":13},{"containerName":"_map_position","name":"$feat","kind":13,"line":355},{"kind":12,"line":355,"name":"has_tag","containerName":"_map_position"},{"containerName":"_map_position","name":"$species","line":356,"kind":13},{"name":"$seq","containerName":"_map_position","line":356,"kind":13},{"line":356,"kind":12,"name":"species","containerName":"_map_position"},{"line":356,"kind":12,"name":"binomial","containerName":"_map_position"},{"containerName":"_map_position","name":"$feat","line":357,"kind":13},{"line":357,"kind":12,"name":"add_tag_value","containerName":"_map_position"},{"kind":13,"line":357,"containerName":"_map_position","name":"$species"},{"name":"%tags","definition":"my","containerName":"_map_position","localvar":"my","kind":13,"line":360},{"name":"$arm","containerName":"_map_position","line":361,"kind":13},{"kind":13,"line":364,"name":"$type","containerName":"_map_position"},{"kind":13,"line":366,"containerName":"_map_position","name":"%tags"},{"containerName":"_map_position","name":"$feat","line":367,"kind":13},{"kind":12,"line":367,"name":"add_tag_value","containerName":"_map_position"},{"kind":13,"line":367,"containerName":"_map_position","name":"$tags"},{"kind":13,"line":370,"containerName":"_map_position","name":"$seq"},{"containerName":"_map_position","name":"add_SeqFeature","line":370,"kind":12},{"name":"$feat","containerName":"_map_position","kind":13,"line":370},{"line":374,"kind":13,"localvar":"my","containerName":"_map_position","name":"$desc","definition":"my"},{"kind":13,"line":374,"name":"$seq","containerName":"_map_position"},{"kind":12,"line":374,"name":"description","containerName":"_map_position"},{"name":"$species","containerName":"_map_position","line":375,"kind":13},{"line":375,"kind":13,"containerName":"_map_position","name":"$arm"},{"line":375,"kind":13,"containerName":"_map_position","name":"$start"},{"containerName":"_map_position","name":"$end","kind":13,"line":375},{"containerName":"_map_position","name":"$desc","line":375,"kind":13},{"containerName":"_map_position","name":"$seq","line":376,"kind":13},{"name":"description","containerName":"_map_position","line":376,"kind":12},{"kind":13,"line":380,"containerName":"_map_position","name":"$self"},{"containerName":"_map_position","name":"flush","line":380,"kind":12}],"containerName":"main::","definition":"sub","detail":"($self,$el)","signature":{"label":"_map_position($self,$el)","documentation":"1;\n# $Id: seqHandler.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqIO::game::seqHandler\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sheldon McKay <mckays@cshl.edu>\n#\n# You may distribute this module under the same terms as perl itself\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::game::seqHandler -- a class for handling game-XML sequences\n\n=head1 SYNOPSIS\n\nThis modules is not used directly\n\n=head1 DESCRIPTION\n\nBio::SeqIO::game::seqHandler processes all of the sequences associated with a game record\nand, via feature handlers, processes the associated annotations\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\nto one of the Bioperl mailing lists.\n\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sheldon McKay\n\nEmail mckays@cshl.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::SeqIO::game::seqHandler;\n\nuse Data::Dumper;\n\nuse Bio::SeqIO::game::featHandler;\nuse Bio::SeqFeature::Generic;\nuse Bio::Seq::RichSeq;\nuse Bio::Species;\nuse strict;\n\nuse vars qw {};\n\nuse base qw(Bio::SeqIO::game::gameSubs);\n\n=head2 new\n\n Title   : new\n Usage   : my $seqHandler = Bio::SeqIO::game::seqHandler->new($seq, $ann, $comp, $map, $src )\n Function: constructor method to create a sequence handler\n Returns : a sequence handler object\n Args    : $seq  -- an XML sequence element\n           $ann  -- a ref. to a list of <annotation> elements\n           $comp -- a ref. to a list of <computational_analysis> elements (not used yet)\n           $map  -- a <map_position> element\n           $src  -- a flag to indicate that the sequence already has a source feature\n\n\nsub new {\n    my ($caller, $seq, $ann, $comp, $map, $src ) =  @_;\n\n    my $class = ref($caller) || $caller;\n\n    my $self = bless ( { \n\tseqs     => $seq,\n        anns     => $ann,\n        comps    => $comp,\n        map_pos  => $map,\n\thas_source => $src,\n        seq_h    => {},\n\tann_l    => []\n    }, $class );\n\n    return $self;\n}\n\n=head2 convert\n\n Title   : convert\n Usage   : @seqs = $seqHandler->convert\n Function: converts the main XML sequence element and associated annotations to Bio::\n Returns : a ref. to a an array containing the sequence object and a ref. to a list of  features\n Args    : none\n\n Note    : The features and sequence are kept apart to facilitate downstream filtering of features \n\n\nsub convert {\n    my $self = shift;\n    my @ann  = @{$self->{anns}} if defined $self->{anns};;\n    my @seq  = @{$self->{seqs}};\n    \n    # not used yet\n    my @comp;\n    if ( $self->{comps} ) {\n        @comp = @{$self->{comps}}    \n    }\n    \n    # process the sequence elements\n    for ( @seq ) {\n\t$self->_add_seq( $_ );\n    }\n    \n    # process the annotation elements\n    for ( @ann ) {\n\t$self->_annotation( $_ );\n    }\n    \n    return $self->_order_feats( $self->{seq_h} );\n}\n\n=head2 _order_feats\n\n Title   : _order_feats\n Usage   : $self->_order_feats( $self->{seq_h} )\n Function: an internal method to ensure the source feature comes first\n           and keep gene, mRNA and CDS features together \n Returns : a ref. to an array containing the sequence object and a ref. to a list of  features \n Args    : a ref. to a hash of sequences\n\n\nsub _order_feats {\n    my ($self, $seqs) = @_;\n    my $seq = $self->{main_seq};\n    my $id  = $seq->id;\n    my $ann = $self->{ann_l};\n\n    # make sure source(s) come first\n    my @src   = grep { $_->primary_tag =~ /source|origin|\\bregion\\b/ } @$ann;\n    # preserve gene->mRNA->CDS or ncRNA->gene->transcript order\n    my @genes = grep { $_->primary_tag =~ /gene|CDS|[a-z]+RNA|transcript/ } @$ann;\n    my @other = sort { $a->start <=> $b->start || $b->end   <=> $a->end  } \n                grep { $_->primary_tag !~ /source|origin|\\bregion\\b/ } \n                grep { $_->primary_tag !~ /gene|mRNA|CDS/ } @$ann;\n    \n    return [$seq, [@src, @genes, @other]];\n}\n\n=head2 _add_seq\n\n Title   : _add_seq\n Usage   : $self->_add_seq($seq_element)\n Function: an internal method to process the sequence elements\n Returns : nothing\n Args    : a sequence element\n\n\nsub _add_seq {\n    my ($self, $el) = @_;\n    my $residues = '';\n\n    if ($el->{_residues}) {\n        $residues = $el->{_residues}->{Characters};\n        $residues =~ s/[ \\n\\r]//g;\n        $residues =~ s/\\!//g;\n        $residues =~ tr/a-z/A-Z/;\n    } \n    else {\n\treturn 0;\n    }\n\n    my $id   = $el->{Attributes}->{id};\n    my $ver  = $el->{Attributes}->{version};\n    my $name = $el->{_name}->{Characters};\n    \n    if ($name && $name ne $id) {\n        $self->complain(\"The sequence name and unique ID do not match.  Using ID\");\n    }\n    \n    # get/set the sequence object\n    my $seq = $self->_seq($id);\n    \n    # get/set the feature handler\n    my $featHandler = $self->_feat_handler;\n    \n    # populate the sequence object\n    $seq->seq($residues);\n    $seq->seq_version($ver) if $ver;\n    \n    # assume the id is the accession number\n    if ( $id =~ /^\\w+$/ ) {\n\t$seq->accession($id);\n    }\n    \n    # If the focus attribute is set to \"true\", this is the main\n    # sequence\n    my $focus = 0;\n    if ( defined $el->{Attributes}->{focus} ) {\n        $self->{main_seq} = $seq;\n        $focus++;\n    }\n\n    # make sure real and annotated lengths match\n    my $length = $el->{Attributes}->{'length'};\n    $length && $seq->length(int($length));\n    if ( $seq->seq && defined($length) && $seq->length != int($length) ) {\n        $self->complain(\"The specified sequence has length \", $seq->length(),\n                        \" but the length attribute= \", $length);\n        $seq->seq( undef );\n        $seq->length( int($length) );\n    }\n\n    # deal with top-level annotations\n    my $tags = {};\n    if ( $el->{Attributes}->{md5checksum} ) {\n\t$tags->{md5checksum} = [$el->{Attributes}->{md5checksum}];\n    }\n    if ($el->{_dbxref}) {\n\t$tags->{dbxref} ||= [];\n        push @{$tags->{dbxref}}, $self->dbxref( $el->{_dbxref} );\n    }\n    if ($el->{_description}) {\n        my $desc = $el->{_description}->{Characters};\n        $seq->description( $desc );\n    } \n    if ($el->{_organism}) {\n        my @organism = split /\\s+/, $el->{_organism}->{Characters};\n        if (@organism < 2) {\n\t    $self->complain(\"Species name should have at least two words\");\n\t}\n\telse {\n\t    my $species = Bio::Species->new( -classification => [reverse @organism] );\n\t    $seq->species($species);\n\t}\n    }\n    if ( defined($seq->species) ) {\n\t$tags->{organism} = [$seq->species->binomial];\n    }\n#    elsif ($seq eq $self->{main_seq}) {\n#\t$self->warn(\"The source organism for this sequence was\\n\" .\n#\t\t    \"not specified.  I will guess Drosophila melanogaster.\\n\" .\n#\t\t    \"Otherwise, add <organism>Genus species</organism>\\n\" .\n#\t\t    \"to the main sequence element\");\n#\tmy @class = qw/ Eukaryota Metazoa Arthropoda Insecta Pterygota\n#\t                Neoptera Endopterygota Diptera Brachycera \n#\t                Muscomorpha Ephydroidea Drosophilidae Drosophila melanogaster/;\n#\tmy $species = Bio::Species->new( -classification => [ reverse @class ],\n#\t\t\t\t\t -common_name    => 'fruit fly' );\n#\t$seq->species( $species );\n#    }\n    \n    # convert GAME to bioperl molecule types\n    my $alphabet = $el->{Attributes}->{type};\n    if ( $alphabet ) {\n        $alphabet =~ s/aa/protein/;\n\t$alphabet =~ s/cdna/rna/;\n\t$seq->alphabet($alphabet);\n    }\n\n    # add a source feature if req'd\n    if ( !$self->{has_source} && $focus ) {\n\t#$self->{source} = $featHandler->add_source($seq->length, $tags);\n    }\n    \n    if ( $focus ) {\n        # add the map position\n        $self->_map_position( $self->{map_pos}, $seq );\n        $featHandler->{offset} = $self->{offset};\n    }\n    \n    # prune the sequence from the parse tree\n    $self->flush;\n}\n\n=head2 _map_position\n\n Title   : _map_position\n Usage   : $self->_map_position($map_posn_element)\n Function: an internal method to process the <map_position> element\n Returns : nothing\n Args    : a map_position element","parameters":[{"label":"$self"},{"label":"$el"}]}},{"kind":12,"line":321,"name":"offset"},{"name":"_arm","kind":12,"line":327},{"kind":12,"line":327,"name":"Characters"},{"name":"Attributes","line":328,"kind":12},{"name":"type","kind":12,"line":328},{"kind":12,"line":329,"name":"_span"},{"name":"_start","line":330,"kind":12},{"line":330,"kind":12,"name":"Characters"},{"kind":12,"line":331,"name":"_end"},{"kind":12,"line":331,"name":"Characters"},{"kind":12,"line":337,"name":"offset"},{"name":"Attributes","line":339,"kind":12},{"line":339,"kind":12,"name":"seq"},{"kind":12,"line":340,"name":"seq_h"},{"name":"main_seq","line":345,"kind":12},{"line":352,"kind":12,"name":"source"},{"kind":12,"line":353,"name":"source"},{"kind":12,"line":357,"name":"organism"},{"name":"mol_type","kind":12,"line":360},{"name":"chromosome","line":361,"kind":12},{"name":"location","line":362,"kind":12},{"name":"type","kind":12,"line":363},{"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"$el"}],"documentation":"1;\n# $Id: seqHandler.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqIO::game::seqHandler\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sheldon McKay <mckays@cshl.edu>\n#\n# You may distribute this module under the same terms as perl itself\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::game::seqHandler -- a class for handling game-XML sequences\n\n=head1 SYNOPSIS\n\nThis modules is not used directly\n\n=head1 DESCRIPTION\n\nBio::SeqIO::game::seqHandler processes all of the sequences associated with a game record\nand, via feature handlers, processes the associated annotations\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\nto one of the Bioperl mailing lists.\n\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sheldon McKay\n\nEmail mckays@cshl.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::SeqIO::game::seqHandler;\n\nuse Data::Dumper;\n\nuse Bio::SeqIO::game::featHandler;\nuse Bio::SeqFeature::Generic;\nuse Bio::Seq::RichSeq;\nuse Bio::Species;\nuse strict;\n\nuse vars qw {};\n\nuse base qw(Bio::SeqIO::game::gameSubs);\n\n=head2 new\n\n Title   : new\n Usage   : my $seqHandler = Bio::SeqIO::game::seqHandler->new($seq, $ann, $comp, $map, $src )\n Function: constructor method to create a sequence handler\n Returns : a sequence handler object\n Args    : $seq  -- an XML sequence element\n           $ann  -- a ref. to a list of <annotation> elements\n           $comp -- a ref. to a list of <computational_analysis> elements (not used yet)\n           $map  -- a <map_position> element\n           $src  -- a flag to indicate that the sequence already has a source feature\n\n\nsub new {\n    my ($caller, $seq, $ann, $comp, $map, $src ) =  @_;\n\n    my $class = ref($caller) || $caller;\n\n    my $self = bless ( { \n\tseqs     => $seq,\n        anns     => $ann,\n        comps    => $comp,\n        map_pos  => $map,\n\thas_source => $src,\n        seq_h    => {},\n\tann_l    => []\n    }, $class );\n\n    return $self;\n}\n\n=head2 convert\n\n Title   : convert\n Usage   : @seqs = $seqHandler->convert\n Function: converts the main XML sequence element and associated annotations to Bio::\n Returns : a ref. to a an array containing the sequence object and a ref. to a list of  features\n Args    : none\n\n Note    : The features and sequence are kept apart to facilitate downstream filtering of features \n\n\nsub convert {\n    my $self = shift;\n    my @ann  = @{$self->{anns}} if defined $self->{anns};;\n    my @seq  = @{$self->{seqs}};\n    \n    # not used yet\n    my @comp;\n    if ( $self->{comps} ) {\n        @comp = @{$self->{comps}}    \n    }\n    \n    # process the sequence elements\n    for ( @seq ) {\n\t$self->_add_seq( $_ );\n    }\n    \n    # process the annotation elements\n    for ( @ann ) {\n\t$self->_annotation( $_ );\n    }\n    \n    return $self->_order_feats( $self->{seq_h} );\n}\n\n=head2 _order_feats\n\n Title   : _order_feats\n Usage   : $self->_order_feats( $self->{seq_h} )\n Function: an internal method to ensure the source feature comes first\n           and keep gene, mRNA and CDS features together \n Returns : a ref. to an array containing the sequence object and a ref. to a list of  features \n Args    : a ref. to a hash of sequences\n\n\nsub _order_feats {\n    my ($self, $seqs) = @_;\n    my $seq = $self->{main_seq};\n    my $id  = $seq->id;\n    my $ann = $self->{ann_l};\n\n    # make sure source(s) come first\n    my @src   = grep { $_->primary_tag =~ /source|origin|\\bregion\\b/ } @$ann;\n    # preserve gene->mRNA->CDS or ncRNA->gene->transcript order\n    my @genes = grep { $_->primary_tag =~ /gene|CDS|[a-z]+RNA|transcript/ } @$ann;\n    my @other = sort { $a->start <=> $b->start || $b->end   <=> $a->end  } \n                grep { $_->primary_tag !~ /source|origin|\\bregion\\b/ } \n                grep { $_->primary_tag !~ /gene|mRNA|CDS/ } @$ann;\n    \n    return [$seq, [@src, @genes, @other]];\n}\n\n=head2 _add_seq\n\n Title   : _add_seq\n Usage   : $self->_add_seq($seq_element)\n Function: an internal method to process the sequence elements\n Returns : nothing\n Args    : a sequence element\n\n\nsub _add_seq {\n    my ($self, $el) = @_;\n    my $residues = '';\n\n    if ($el->{_residues}) {\n        $residues = $el->{_residues}->{Characters};\n        $residues =~ s/[ \\n\\r]//g;\n        $residues =~ s/\\!//g;\n        $residues =~ tr/a-z/A-Z/;\n    } \n    else {\n\treturn 0;\n    }\n\n    my $id   = $el->{Attributes}->{id};\n    my $ver  = $el->{Attributes}->{version};\n    my $name = $el->{_name}->{Characters};\n    \n    if ($name && $name ne $id) {\n        $self->complain(\"The sequence name and unique ID do not match.  Using ID\");\n    }\n    \n    # get/set the sequence object\n    my $seq = $self->_seq($id);\n    \n    # get/set the feature handler\n    my $featHandler = $self->_feat_handler;\n    \n    # populate the sequence object\n    $seq->seq($residues);\n    $seq->seq_version($ver) if $ver;\n    \n    # assume the id is the accession number\n    if ( $id =~ /^\\w+$/ ) {\n\t$seq->accession($id);\n    }\n    \n    # If the focus attribute is set to \"true\", this is the main\n    # sequence\n    my $focus = 0;\n    if ( defined $el->{Attributes}->{focus} ) {\n        $self->{main_seq} = $seq;\n        $focus++;\n    }\n\n    # make sure real and annotated lengths match\n    my $length = $el->{Attributes}->{'length'};\n    $length && $seq->length(int($length));\n    if ( $seq->seq && defined($length) && $seq->length != int($length) ) {\n        $self->complain(\"The specified sequence has length \", $seq->length(),\n                        \" but the length attribute= \", $length);\n        $seq->seq( undef );\n        $seq->length( int($length) );\n    }\n\n    # deal with top-level annotations\n    my $tags = {};\n    if ( $el->{Attributes}->{md5checksum} ) {\n\t$tags->{md5checksum} = [$el->{Attributes}->{md5checksum}];\n    }\n    if ($el->{_dbxref}) {\n\t$tags->{dbxref} ||= [];\n        push @{$tags->{dbxref}}, $self->dbxref( $el->{_dbxref} );\n    }\n    if ($el->{_description}) {\n        my $desc = $el->{_description}->{Characters};\n        $seq->description( $desc );\n    } \n    if ($el->{_organism}) {\n        my @organism = split /\\s+/, $el->{_organism}->{Characters};\n        if (@organism < 2) {\n\t    $self->complain(\"Species name should have at least two words\");\n\t}\n\telse {\n\t    my $species = Bio::Species->new( -classification => [reverse @organism] );\n\t    $seq->species($species);\n\t}\n    }\n    if ( defined($seq->species) ) {\n\t$tags->{organism} = [$seq->species->binomial];\n    }\n#    elsif ($seq eq $self->{main_seq}) {\n#\t$self->warn(\"The source organism for this sequence was\\n\" .\n#\t\t    \"not specified.  I will guess Drosophila melanogaster.\\n\" .\n#\t\t    \"Otherwise, add <organism>Genus species</organism>\\n\" .\n#\t\t    \"to the main sequence element\");\n#\tmy @class = qw/ Eukaryota Metazoa Arthropoda Insecta Pterygota\n#\t                Neoptera Endopterygota Diptera Brachycera \n#\t                Muscomorpha Ephydroidea Drosophilidae Drosophila melanogaster/;\n#\tmy $species = Bio::Species->new( -classification => [ reverse @class ],\n#\t\t\t\t\t -common_name    => 'fruit fly' );\n#\t$seq->species( $species );\n#    }\n    \n    # convert GAME to bioperl molecule types\n    my $alphabet = $el->{Attributes}->{type};\n    if ( $alphabet ) {\n        $alphabet =~ s/aa/protein/;\n\t$alphabet =~ s/cdna/rna/;\n\t$seq->alphabet($alphabet);\n    }\n\n    # add a source feature if req'd\n    if ( !$self->{has_source} && $focus ) {\n\t#$self->{source} = $featHandler->add_source($seq->length, $tags);\n    }\n    \n    if ( $focus ) {\n        # add the map position\n        $self->_map_position( $self->{map_pos}, $seq );\n        $featHandler->{offset} = $self->{offset};\n    }\n    \n    # prune the sequence from the parse tree\n    $self->flush;\n}\n\n=head2 _map_position\n\n Title   : _map_position\n Usage   : $self->_map_position($map_posn_element)\n Function: an internal method to process the <map_position> element\n Returns : nothing\n Args    : a map_position element\n\n\nsub _map_position {\n    my ($self, $el) = @_;\n\n    # we can live without it\n    if ( !$el ) {\n\t$self->{offset}= 0;\n\treturn 0;\n    }\n\n\n    # chromosome and coordinates\n    my $arm   = $el->{_arm}->{Characters};\n    my $type  = $el->{Attributes}->{type};\n    my $loc   = $el->{_span};\n    my $start = $loc->{_start}->{Characters};\n    my $end   = $loc->{_end}->{Characters};\n    \n    # define the offset (may be a partial sequence)\n    # The coordinates will be relative but the CDS description\n    # coordinates may be absolute if the game-XML comes from apollo \n    # or gadfly\n    $self->{offset} = $start - 1;\n\n    my $seq_id = $el->{Attributes}->{seq};\n    my $seq = $self->{seq_h}->{$seq_id};\n    \n    unless ( $seq ) {\n        $self->throw(\"Map position with no corresponding sequence object\");\n    }\n    unless ($seq eq $self->{main_seq}){\n        $self->throw(\"Map position does not correspond to the main sequence\");\n    }\n    \n    my $species = '';\n    \n    # create/update the top-level sequence feature if req'd\n    if ( $self->{source} ) {\n\tmy $feat = $self->{source};\n    \n\tunless ($feat->has_tag('organism')) {\n\t    $species = eval {$seq->species->binomial} || 'unknown species';\n\t    $feat->add_tag_value( organism => $species );\n\t}\n    \n\tmy %tags = ( mol_type   => \"genomic dna\",\n\t\t     chromosome => $arm,\n\t\t     location   => \"$start..$end\",\n\t\t     type       => $type\n\t\t     );\n    \n\tfor (keys %tags) {\n\t    $feat->add_tag_value( $_ => $tags{$_} );\n\t}\n        \n\t$seq->add_SeqFeature($feat);\n    }\n\n    # come up with a description if there is none\n    my $desc = $seq->description;\n    if ( $species && $arm && $start && $end && !$desc) {\n\t$seq->description(\"$species chromosome $arm $start..$end \" .\n\t                  \"segment of complete sequence\");\n    }\n    \n    $self->flush;\n}\n\n=head2 _annotation\n\n Title   : _annotation\n Usage   : $self->_annotation($annotation_element)\n Function: an internal method to process <annotation> elements\n Returns : nothing\n Args    : an annotation element","label":"_annotation($self,$el)"},"detail":"($self,$el)","kind":12,"children":[{"localvar":"my","containerName":"_annotation","definition":"my","name":"$self","line":394,"kind":13},{"containerName":"_annotation","name":"$el","kind":13,"line":394},{"kind":13,"line":396,"containerName":"_annotation","definition":"my","name":"$id","localvar":"my"},{"name":"$el","containerName":"_annotation","line":396,"kind":13},{"line":397,"kind":13,"localvar":"my","definition":"my","name":"$type","containerName":"_annotation"},{"kind":13,"line":397,"containerName":"_annotation","name":"$el"},{"definition":"my","name":"$tags","containerName":"_annotation","localvar":"my","kind":13,"line":398},{"line":399,"kind":13,"localvar":"my","definition":"my","name":"$gname","containerName":"_annotation"},{"name":"$el","containerName":"_annotation","kind":13,"line":399},{"kind":13,"line":399,"name":"$id","containerName":"_annotation"},{"name":"$el","containerName":"_annotation","line":399,"kind":13},{"localvar":"my","containerName":"_annotation","name":"$seqid","definition":"my","line":405,"kind":13},{"line":405,"kind":13,"name":"$self","containerName":"_annotation"},{"line":405,"kind":12,"containerName":"_annotation","name":"id"},{"kind":13,"line":406,"containerName":"_annotation","name":"$featHandler","definition":"my","localvar":"my"},{"name":"$self","containerName":"_annotation","kind":13,"line":406},{"line":406,"kind":12,"name":"_feat_handler","containerName":"_annotation"},{"line":408,"kind":13,"localvar":"my","containerName":"_annotation","definition":"my","name":"@feats"},{"line":410,"kind":13,"localvar":"my","containerName":"_annotation","definition":"my","name":"$child"},{"name":"$el","containerName":"_annotation","line":410,"kind":13}],"line":393,"name":"_annotation","range":{"end":{"line":410,"character":9999},"start":{"character":0,"line":393}}},{"name":"Attributes","line":396,"kind":12},{"name":"id","line":396,"kind":12},{"kind":12,"line":397,"name":"_type"},{"name":"Characters","line":397,"kind":12},{"name":"_name","kind":12,"line":399},{"name":"Characters","kind":12,"line":399},{"line":399,"kind":12,"name":"_name"},{"name":"Characters","line":399,"kind":12},{"kind":12,"line":405,"name":"main_seq"},{"kind":12,"line":410,"name":"Children"},{"line":411,"kind":13,"localvar":"my","containerName":null,"name":"$name","definition":"my"},{"kind":13,"line":411,"containerName":null,"name":"%child"},{"kind":12,"line":411,"name":"Name"},{"line":414,"kind":13,"name":"%name","containerName":null},{"line":415,"kind":13,"name":"%tags","containerName":null},{"name":"dbxref","line":415,"kind":12},{"kind":13,"line":416,"name":"%tags","containerName":null},{"line":416,"kind":12,"name":"dbxref"},{"name":"$self","containerName":null,"line":416,"kind":13},{"kind":12,"line":416,"containerName":"main::","name":"dbxref"},{"name":"$child","containerName":null,"kind":13,"line":416},{"containerName":null,"name":"%name","kind":13,"line":418},{"line":419,"kind":13,"name":"%tags","containerName":null},{"line":419,"kind":12,"name":"dbxref"},{"name":"%tags","containerName":null,"line":420,"kind":13},{"line":420,"kind":12,"name":"dbxref"},{"containerName":null,"name":"$self","line":420,"kind":13},{"containerName":"main::","name":"dbxref","line":420,"kind":12},{"kind":13,"line":420,"name":"%child","containerName":null},{"name":"_dbxref","kind":12,"line":420},{"containerName":null,"name":"%name","line":422,"kind":13},{"line":423,"kind":13,"name":"@feats","containerName":null},{"name":"$featHandler","containerName":null,"kind":13,"line":423},{"kind":12,"line":423,"name":"feature_set","containerName":"main::"},{"name":"$id","containerName":null,"line":423,"kind":13},{"containerName":null,"name":"$gname","kind":13,"line":423},{"containerName":null,"name":"$child","line":423,"kind":13},{"line":423,"kind":13,"containerName":null,"name":"$type"},{"line":425,"kind":13,"containerName":null,"name":"%name"},{"containerName":null,"name":"%tags","kind":13,"line":426},{"kind":12,"line":426,"name":"comment"},{"kind":13,"line":426,"containerName":null,"name":"$self"},{"line":426,"kind":12,"name":"comment","containerName":"main::"},{"kind":13,"line":426,"name":"$child","containerName":null},{"line":428,"kind":13,"name":"%name","containerName":null},{"containerName":null,"name":"$self","kind":13,"line":429},{"kind":12,"line":429,"name":"property","containerName":"main::"},{"name":"$child","containerName":null,"line":429,"kind":13},{"containerName":null,"name":"$tags","line":429,"kind":13},{"name":"%name","containerName":null,"kind":13,"line":431},{"containerName":null,"name":"$featHandler","kind":13,"line":434},{"line":434,"kind":12,"name":"has_gene","containerName":"main::"},{"containerName":null,"name":"$child","line":434,"kind":13},{"line":434,"kind":13,"containerName":null,"name":"$gname"},{"kind":13,"line":434,"name":"$id","containerName":null},{"line":441,"kind":13,"containerName":null,"name":"%name"},{"name":"%tags","containerName":null,"line":442,"kind":13},{"line":442,"kind":13,"name":"@name","containerName":null},{"line":442,"kind":13,"containerName":null,"name":"%child"},{"name":"Characters","line":442,"kind":12},{"line":444,"kind":13,"name":"%name","containerName":null},{"containerName":null,"name":"$self","kind":13,"line":445},{"line":445,"kind":12,"containerName":"main::","name":"complain"},{"name":"$featHandler","containerName":null,"line":453,"kind":13},{"kind":12,"line":453,"name":"has_gene","containerName":"main::"},{"line":453,"kind":13,"containerName":null,"name":"%type"},{"kind":13,"line":454,"name":"$featHandler","containerName":null},{"containerName":"main::","name":"has_gene","kind":12,"line":454},{"line":454,"kind":13,"name":"$el","containerName":null},{"line":454,"kind":13,"name":"$gname","containerName":null},{"kind":13,"line":454,"name":"$id","containerName":null},{"containerName":null,"name":"%tags","line":457,"kind":13},{"kind":12,"line":457,"name":"symbol"},{"kind":13,"line":458,"containerName":null,"name":"%tags"},{"line":458,"kind":12,"name":"gene"},{"line":459,"kind":13,"name":"%tags","containerName":null},{"kind":12,"line":459,"name":"gene"},{"name":"%tags","containerName":null,"kind":13,"line":459},{"name":"symbol","line":459,"kind":12},{"containerName":null,"name":"%tags","line":461,"kind":13},{"name":"symbol","kind":12,"line":461},{"name":"$featHandler","containerName":null,"kind":13,"line":465},{"name":"add_annotation","containerName":"main::","line":465,"kind":12},{"containerName":null,"name":"%self","kind":13,"line":465},{"name":"main_seq","line":465,"kind":12},{"name":"$type","containerName":null,"kind":13,"line":465},{"containerName":null,"name":"$id","line":465,"kind":13},{"line":465,"kind":13,"name":"$tags","containerName":null},{"name":"@feats","containerName":null,"line":465,"kind":13},{"name":"$self","containerName":null,"kind":13,"line":466},{"line":466,"kind":12,"containerName":"main::","name":"flush"},{"kind":12,"children":[{"containerName":"_seq","name":"$self","definition":"my","localvar":"my","kind":13,"line":482},{"name":"$id","containerName":"_seq","kind":13,"line":482},{"name":"$id","containerName":"_seq","line":483,"kind":13},{"name":"$self","containerName":"_seq","line":483,"kind":13},{"kind":12,"line":483,"name":"throw","containerName":"_seq"},{"localvar":"my","name":"$seq","definition":"my","containerName":"_seq","line":485,"kind":13},{"name":"$self","containerName":"_seq","line":487,"kind":13},{"kind":13,"line":487,"containerName":"_seq","name":"$id"},{"name":"$seq","containerName":"_seq","kind":13,"line":488},{"line":488,"kind":13,"containerName":"_seq","name":"$self"},{"containerName":"_seq","name":"$id","kind":13,"line":488},{"containerName":"_seq","name":"$seq","line":490,"kind":13},{"name":"new","containerName":"_seq","line":490,"kind":12},{"name":"$id","containerName":"_seq","line":490,"kind":13},{"name":"$self","containerName":"_seq","kind":13,"line":491},{"kind":13,"line":491,"name":"$id","containerName":"_seq"},{"name":"$seq","containerName":"_seq","kind":13,"line":491},{"name":"$seq","containerName":"_seq","line":494,"kind":13}],"line":481,"definition":"sub","containerName":"main::","signature":{"label":"_seq($self,$id)","parameters":[{"label":"$self"},{"label":"$id"}],"documentation":"1;\n# $Id: seqHandler.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqIO::game::seqHandler\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sheldon McKay <mckays@cshl.edu>\n#\n# You may distribute this module under the same terms as perl itself\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::game::seqHandler -- a class for handling game-XML sequences\n\n=head1 SYNOPSIS\n\nThis modules is not used directly\n\n=head1 DESCRIPTION\n\nBio::SeqIO::game::seqHandler processes all of the sequences associated with a game record\nand, via feature handlers, processes the associated annotations\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\nto one of the Bioperl mailing lists.\n\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sheldon McKay\n\nEmail mckays@cshl.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::SeqIO::game::seqHandler;\n\nuse Data::Dumper;\n\nuse Bio::SeqIO::game::featHandler;\nuse Bio::SeqFeature::Generic;\nuse Bio::Seq::RichSeq;\nuse Bio::Species;\nuse strict;\n\nuse vars qw {};\n\nuse base qw(Bio::SeqIO::game::gameSubs);\n\n=head2 new\n\n Title   : new\n Usage   : my $seqHandler = Bio::SeqIO::game::seqHandler->new($seq, $ann, $comp, $map, $src )\n Function: constructor method to create a sequence handler\n Returns : a sequence handler object\n Args    : $seq  -- an XML sequence element\n           $ann  -- a ref. to a list of <annotation> elements\n           $comp -- a ref. to a list of <computational_analysis> elements (not used yet)\n           $map  -- a <map_position> element\n           $src  -- a flag to indicate that the sequence already has a source feature\n\n\nsub new {\n    my ($caller, $seq, $ann, $comp, $map, $src ) =  @_;\n\n    my $class = ref($caller) || $caller;\n\n    my $self = bless ( { \n\tseqs     => $seq,\n        anns     => $ann,\n        comps    => $comp,\n        map_pos  => $map,\n\thas_source => $src,\n        seq_h    => {},\n\tann_l    => []\n    }, $class );\n\n    return $self;\n}\n\n=head2 convert\n\n Title   : convert\n Usage   : @seqs = $seqHandler->convert\n Function: converts the main XML sequence element and associated annotations to Bio::\n Returns : a ref. to a an array containing the sequence object and a ref. to a list of  features\n Args    : none\n\n Note    : The features and sequence are kept apart to facilitate downstream filtering of features \n\n\nsub convert {\n    my $self = shift;\n    my @ann  = @{$self->{anns}} if defined $self->{anns};;\n    my @seq  = @{$self->{seqs}};\n    \n    # not used yet\n    my @comp;\n    if ( $self->{comps} ) {\n        @comp = @{$self->{comps}}    \n    }\n    \n    # process the sequence elements\n    for ( @seq ) {\n\t$self->_add_seq( $_ );\n    }\n    \n    # process the annotation elements\n    for ( @ann ) {\n\t$self->_annotation( $_ );\n    }\n    \n    return $self->_order_feats( $self->{seq_h} );\n}\n\n=head2 _order_feats\n\n Title   : _order_feats\n Usage   : $self->_order_feats( $self->{seq_h} )\n Function: an internal method to ensure the source feature comes first\n           and keep gene, mRNA and CDS features together \n Returns : a ref. to an array containing the sequence object and a ref. to a list of  features \n Args    : a ref. to a hash of sequences\n\n\nsub _order_feats {\n    my ($self, $seqs) = @_;\n    my $seq = $self->{main_seq};\n    my $id  = $seq->id;\n    my $ann = $self->{ann_l};\n\n    # make sure source(s) come first\n    my @src   = grep { $_->primary_tag =~ /source|origin|\\bregion\\b/ } @$ann;\n    # preserve gene->mRNA->CDS or ncRNA->gene->transcript order\n    my @genes = grep { $_->primary_tag =~ /gene|CDS|[a-z]+RNA|transcript/ } @$ann;\n    my @other = sort { $a->start <=> $b->start || $b->end   <=> $a->end  } \n                grep { $_->primary_tag !~ /source|origin|\\bregion\\b/ } \n                grep { $_->primary_tag !~ /gene|mRNA|CDS/ } @$ann;\n    \n    return [$seq, [@src, @genes, @other]];\n}\n\n=head2 _add_seq\n\n Title   : _add_seq\n Usage   : $self->_add_seq($seq_element)\n Function: an internal method to process the sequence elements\n Returns : nothing\n Args    : a sequence element\n\n\nsub _add_seq {\n    my ($self, $el) = @_;\n    my $residues = '';\n\n    if ($el->{_residues}) {\n        $residues = $el->{_residues}->{Characters};\n        $residues =~ s/[ \\n\\r]//g;\n        $residues =~ s/\\!//g;\n        $residues =~ tr/a-z/A-Z/;\n    } \n    else {\n\treturn 0;\n    }\n\n    my $id   = $el->{Attributes}->{id};\n    my $ver  = $el->{Attributes}->{version};\n    my $name = $el->{_name}->{Characters};\n    \n    if ($name && $name ne $id) {\n        $self->complain(\"The sequence name and unique ID do not match.  Using ID\");\n    }\n    \n    # get/set the sequence object\n    my $seq = $self->_seq($id);\n    \n    # get/set the feature handler\n    my $featHandler = $self->_feat_handler;\n    \n    # populate the sequence object\n    $seq->seq($residues);\n    $seq->seq_version($ver) if $ver;\n    \n    # assume the id is the accession number\n    if ( $id =~ /^\\w+$/ ) {\n\t$seq->accession($id);\n    }\n    \n    # If the focus attribute is set to \"true\", this is the main\n    # sequence\n    my $focus = 0;\n    if ( defined $el->{Attributes}->{focus} ) {\n        $self->{main_seq} = $seq;\n        $focus++;\n    }\n\n    # make sure real and annotated lengths match\n    my $length = $el->{Attributes}->{'length'};\n    $length && $seq->length(int($length));\n    if ( $seq->seq && defined($length) && $seq->length != int($length) ) {\n        $self->complain(\"The specified sequence has length \", $seq->length(),\n                        \" but the length attribute= \", $length);\n        $seq->seq( undef );\n        $seq->length( int($length) );\n    }\n\n    # deal with top-level annotations\n    my $tags = {};\n    if ( $el->{Attributes}->{md5checksum} ) {\n\t$tags->{md5checksum} = [$el->{Attributes}->{md5checksum}];\n    }\n    if ($el->{_dbxref}) {\n\t$tags->{dbxref} ||= [];\n        push @{$tags->{dbxref}}, $self->dbxref( $el->{_dbxref} );\n    }\n    if ($el->{_description}) {\n        my $desc = $el->{_description}->{Characters};\n        $seq->description( $desc );\n    } \n    if ($el->{_organism}) {\n        my @organism = split /\\s+/, $el->{_organism}->{Characters};\n        if (@organism < 2) {\n\t    $self->complain(\"Species name should have at least two words\");\n\t}\n\telse {\n\t    my $species = Bio::Species->new( -classification => [reverse @organism] );\n\t    $seq->species($species);\n\t}\n    }\n    if ( defined($seq->species) ) {\n\t$tags->{organism} = [$seq->species->binomial];\n    }\n#    elsif ($seq eq $self->{main_seq}) {\n#\t$self->warn(\"The source organism for this sequence was\\n\" .\n#\t\t    \"not specified.  I will guess Drosophila melanogaster.\\n\" .\n#\t\t    \"Otherwise, add <organism>Genus species</organism>\\n\" .\n#\t\t    \"to the main sequence element\");\n#\tmy @class = qw/ Eukaryota Metazoa Arthropoda Insecta Pterygota\n#\t                Neoptera Endopterygota Diptera Brachycera \n#\t                Muscomorpha Ephydroidea Drosophilidae Drosophila melanogaster/;\n#\tmy $species = Bio::Species->new( -classification => [ reverse @class ],\n#\t\t\t\t\t -common_name    => 'fruit fly' );\n#\t$seq->species( $species );\n#    }\n    \n    # convert GAME to bioperl molecule types\n    my $alphabet = $el->{Attributes}->{type};\n    if ( $alphabet ) {\n        $alphabet =~ s/aa/protein/;\n\t$alphabet =~ s/cdna/rna/;\n\t$seq->alphabet($alphabet);\n    }\n\n    # add a source feature if req'd\n    if ( !$self->{has_source} && $focus ) {\n\t#$self->{source} = $featHandler->add_source($seq->length, $tags);\n    }\n    \n    if ( $focus ) {\n        # add the map position\n        $self->_map_position( $self->{map_pos}, $seq );\n        $featHandler->{offset} = $self->{offset};\n    }\n    \n    # prune the sequence from the parse tree\n    $self->flush;\n}\n\n=head2 _map_position\n\n Title   : _map_position\n Usage   : $self->_map_position($map_posn_element)\n Function: an internal method to process the <map_position> element\n Returns : nothing\n Args    : a map_position element\n\n\nsub _map_position {\n    my ($self, $el) = @_;\n\n    # we can live without it\n    if ( !$el ) {\n\t$self->{offset}= 0;\n\treturn 0;\n    }\n\n\n    # chromosome and coordinates\n    my $arm   = $el->{_arm}->{Characters};\n    my $type  = $el->{Attributes}->{type};\n    my $loc   = $el->{_span};\n    my $start = $loc->{_start}->{Characters};\n    my $end   = $loc->{_end}->{Characters};\n    \n    # define the offset (may be a partial sequence)\n    # The coordinates will be relative but the CDS description\n    # coordinates may be absolute if the game-XML comes from apollo \n    # or gadfly\n    $self->{offset} = $start - 1;\n\n    my $seq_id = $el->{Attributes}->{seq};\n    my $seq = $self->{seq_h}->{$seq_id};\n    \n    unless ( $seq ) {\n        $self->throw(\"Map position with no corresponding sequence object\");\n    }\n    unless ($seq eq $self->{main_seq}){\n        $self->throw(\"Map position does not correspond to the main sequence\");\n    }\n    \n    my $species = '';\n    \n    # create/update the top-level sequence feature if req'd\n    if ( $self->{source} ) {\n\tmy $feat = $self->{source};\n    \n\tunless ($feat->has_tag('organism')) {\n\t    $species = eval {$seq->species->binomial} || 'unknown species';\n\t    $feat->add_tag_value( organism => $species );\n\t}\n    \n\tmy %tags = ( mol_type   => \"genomic dna\",\n\t\t     chromosome => $arm,\n\t\t     location   => \"$start..$end\",\n\t\t     type       => $type\n\t\t     );\n    \n\tfor (keys %tags) {\n\t    $feat->add_tag_value( $_ => $tags{$_} );\n\t}\n        \n\t$seq->add_SeqFeature($feat);\n    }\n\n    # come up with a description if there is none\n    my $desc = $seq->description;\n    if ( $species && $arm && $start && $end && !$desc) {\n\t$seq->description(\"$species chromosome $arm $start..$end \" .\n\t                  \"segment of complete sequence\");\n    }\n    \n    $self->flush;\n}\n\n=head2 _annotation\n\n Title   : _annotation\n Usage   : $self->_annotation($annotation_element)\n Function: an internal method to process <annotation> elements\n Returns : nothing\n Args    : an annotation element\n\n\nsub _annotation {\n    my ($self, $el) = @_;\n\n    my $id      = $el->{Attributes}->{id};\n    my $type    = $el->{_type}->{Characters};\n    my $tags    = {};\n    my $gname   = $el->{_name}->{Characters} eq $id ? '' : $el->{_name}->{Characters};\n\n    # 'transposable element' is too long (breaks Bio::SeqIO::GenBank)\n    # $type =~ s/transposable_element/repeat_region/;\n    \n    # annotations must be on the main sequence\n    my $seqid = $self->{main_seq}->id;\n    my $featHandler = $self->_feat_handler;\n    \n    my @feats = ();\n    \n    for my $child ( @{$el->{Children}} ) {\n        my $name = $child->{Name};\n\t\n\t# these elements require special handling\n\tif ( $name eq 'dbxref' ) {\n\t    $tags->{dbxref} ||= [];\n\t    push @{$tags->{dbxref}}, $self->dbxref( $child );\n\t}\n\telsif ( $name eq 'aspect' ) {\n\t    $tags->{dbxref} ||= [];\n\t    push @{$tags->{dbxref}}, $self->dbxref( $child->{_dbxref} );\n\t}\n        elsif ( $name eq 'feature_set' ) {\n            push @feats, $featHandler->feature_set( $id, $gname, $child, $type );\n\t}\n        elsif ( $name eq 'comment' ) {\n\t    $tags->{comment} = [$self->comment( $child )];\n\t}\n\telsif ( $name eq 'property' ) {\n\t    $self->property( $child, $tags );\n\t}\n\telsif ( $name eq 'gene' ) {\n\t    # we may be dealing with an annotation that is not\n\t    # a gene, so we have to nest the gene inside it\n\t    $featHandler->has_gene( $child, $gname, $id )\n        }\n        \n\t# otherwise, tag/value pairs\n\t# -- mild dtd enforcement\n\t# synonym is not in the dtd but shows up in gadfly\n\t# annotations\t\n\telsif ( $name =~ /type|synonym/ ) {\n\t    $tags->{$name} = [$child->{Characters}];\n\t}\n\telsif ( $name ne 'name' ) {\n            $self->complain(\"Unrecognized element '$name'. I don't \" .\n                            \"know what to do with $name elements in \" .\n                            \"top-level sequence annotations.\" );\n        }\n\n    }\n\t\n    # add a gene annotation if required\n    unless ( $featHandler->has_gene || $type ne 'gene' ) {\n\t$featHandler->has_gene( $el, $gname, $id )\n    }\n\n    if ( $tags->{symbol} ) {\n        if ( !$tags->{gene} ) {\n\t   $tags->{gene} = $tags->{symbol};\n\t}\n\tdelete $tags->{symbol};\n    }\n    \n    \n    $featHandler->add_annotation( $self->{main_seq}, $type, $id, $tags, \\@feats );\n    $self->flush;\n}\n\n# get/set the sequence object\n\n=head2 _seq\n\n Title   : _seq\n Usage   : my $seq = $self->_seq\n Function: an internal sequence getter/setter\n Returns : a Bio::RichSeq object\n Args    : a sequence ID"},"detail":"($self,$id)","name":"_seq","range":{"start":{"line":481,"character":0},"end":{"character":9999,"line":495}}},{"name":"seq_h","line":487,"kind":12},{"name":"seq_h","kind":12,"line":488},{"line":490,"kind":12,"containerName":"Seq::RichSeq","name":"Bio"},{"line":491,"kind":12,"name":"seq_h"},{"kind":12,"line":509,"children":[{"localvar":"my","containerName":"_feat_handler","name":"$self","definition":"my","line":510,"kind":13},{"line":512,"kind":13,"localvar":"my","definition":"my","name":"$handler","containerName":"_feat_handler"},{"definition":"my","name":"$seq","containerName":"_feat_handler","localvar":"my","kind":13,"line":513},{"kind":13,"line":513,"containerName":"_feat_handler","name":"$self"},{"kind":13,"line":515,"containerName":"_feat_handler","name":"$self"},{"containerName":"_feat_handler","name":"$handler","kind":13,"line":516},{"kind":13,"line":516,"containerName":"_feat_handler","name":"$self"},{"containerName":"_feat_handler","definition":"my","name":"@args","localvar":"my","kind":13,"line":519},{"name":"$seq","containerName":"_feat_handler","kind":13,"line":519},{"name":"$self","containerName":"_feat_handler","kind":13,"line":519},{"containerName":"_feat_handler","name":"$self","line":519,"kind":13},{"line":520,"kind":13,"name":"$handler","containerName":"_feat_handler"},{"name":"new","containerName":"_feat_handler","line":520,"kind":12},{"line":520,"kind":13,"containerName":"_feat_handler","name":"@args"},{"line":521,"kind":13,"name":"$self","containerName":"_feat_handler"},{"kind":13,"line":521,"name":"$handler","containerName":"_feat_handler"},{"kind":13,"line":524,"name":"$handler","containerName":"_feat_handler"}],"containerName":"main::","name":"_feat_handler","definition":"sub","range":{"start":{"line":509,"character":0},"end":{"line":525,"character":9999}}},{"kind":12,"line":513,"name":"main_seq"},{"kind":12,"line":515,"name":"feat_handler"},{"name":"feat_handler","kind":12,"line":516},{"name":"seq_h","kind":12,"line":519},{"name":"ann_l","kind":12,"line":519},{"name":"Bio","containerName":"SeqIO::game::featHandler","line":520,"kind":12},{"line":521,"kind":12,"name":"feat_handler"}]}