{"version":5,"vars":[{"kind":2,"line":86,"name":"base","containerName":""},{"name":"_initialize","range":{"start":{"character":0,"line":88},"end":{"line":93,"character":9999}},"kind":12,"children":[{"line":89,"kind":13,"localvar":"my","containerName":"_initialize","definition":"my","name":"$self"},{"containerName":"_initialize","name":"@args","line":89,"kind":13},{"kind":13,"line":91,"name":"$self","containerName":"_initialize"},{"line":91,"kind":13,"containerName":"_initialize","name":"@args"}],"line":88,"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"","label":"_initialize($self,@args)"},"detail":"($self,@args)"},{"line":91,"kind":12,"containerName":"_initialize","name":"SUPER"},{"line":107,"children":[{"kind":13,"line":108,"containerName":"show_detail","definition":"my","name":"$self","localvar":"my"},{"line":110,"kind":13,"containerName":"show_detail","name":"$self"},{"kind":13,"line":111,"containerName":"show_detail","name":"$self"}],"kind":12,"range":{"end":{"line":112,"character":9999},"start":{"line":107,"character":0}},"containerName":"main::","definition":"sub","name":"show_detail"},{"range":{"start":{"character":0,"line":125},"end":{"character":9999,"line":128}},"name":"next_seq","children":[{"localvar":"my","containerName":"next_seq","definition":"my","name":"$self","line":126,"kind":13},{"name":"@args","containerName":"next_seq","line":126,"kind":13},{"line":127,"kind":13,"containerName":"next_seq","name":"$self"},{"name":"throw","containerName":"next_seq","kind":12,"line":127}],"line":125,"kind":12,"signature":{"documentation":"1;\n# $Id: asciitree.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqIO::asciitree\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Mungall <cjm@fruitfly.org>\n#\n# Copyright Chris Mungall\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::asciitree - asciitree sequence input/output stream\n\n=head1 SYNOPSIS\n\n  # It is probably best not to use this object directly, but\n  # rather go through the SeqIO handler system. Go:\n\n    $instream  = Bio::SeqIO->new(-file => $filename,\n                                 -format => 'chadoxml');\n    $outstream = Bio::SeqIO->new(-file => $filename,\n                                 -format => 'asciitree');\n\n    while ( my $seq = $instream->next_seq() ) {\n\t    $outstream->write_seq();\n    }\n\n\n=head1 DESCRIPTION\n\nThis is a WRITE-ONLY SeqIO module. It writes a Bio::SeqI object\ncontaining nested SeqFeature objects in such a way that the SeqFeature\ncontainment hierarchy is visible as a tree structure\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Mungall\n\nEmail cjm@fruitfly.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SeqIO::asciitree;\nuse strict;\n\n\nuse base qw(Bio::SeqIO);\n\nsub _initialize {\n    my($self,@args) = @_;\n\n    $self->SUPER::_initialize(@args);\n    # hash for functions for decoding keys.\n}\n\n=head2 show_detail\n\n Title   : show_detail\n Usage   : $obj->show_detail($newval)\n Function:\n Example :\n Returns : value of show_detail (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub show_detail{\n    my $self = shift;\n\n    return $self->{'show_detail'} = shift if @_;\n    return $self->{'show_detail'};\n}\n\n\n=head2 next_seq\n\n Title   : next_seq\n Usage   : $seq = $stream->next_seq()\n Function: returns the next sequence in the stream\n Returns : Bio::Seq object\n Args    :","parameters":[{"label":"$self"},{"label":"@args"}],"label":"next_seq($self,@args)"},"detail":"($self,@args)","definition":"sub","containerName":"main::"},{"children":[{"line":142,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"write_seq"},{"kind":13,"line":142,"containerName":"write_seq","name":"@seqs"},{"line":144,"kind":13,"localvar":"my","definition":"my","name":"$seq","containerName":"write_seq"},{"kind":13,"line":144,"name":"@seqs","containerName":"write_seq"},{"kind":13,"line":145,"containerName":"write_seq","name":"$self"},{"kind":12,"line":145,"name":"throw","containerName":"write_seq"},{"name":"$seq","containerName":"write_seq","kind":13,"line":145},{"line":147,"kind":13,"name":"$seq","containerName":"write_seq"},{"kind":13,"line":147,"name":"$seq","containerName":"write_seq"},{"kind":12,"line":147,"containerName":"write_seq","name":"isa"},{"line":148,"kind":13,"name":"$self","containerName":"write_seq"},{"name":"warn","containerName":"write_seq","kind":12,"line":148},{"name":"$self","containerName":"write_seq","line":150,"kind":13},{"name":"_print","containerName":"write_seq","kind":12,"line":150},{"kind":13,"line":150,"containerName":"write_seq","name":"$seq"},{"line":150,"kind":12,"name":"accession_number","containerName":"write_seq"},{"line":151,"kind":13,"containerName":"write_seq","name":"$self"},{"line":151,"kind":12,"name":"_print","containerName":"write_seq"},{"localvar":"my","containerName":"write_seq","name":"@top_sfs","definition":"my","line":152,"kind":13},{"containerName":"write_seq","name":"$seq","line":152,"kind":13},{"kind":12,"line":152,"name":"get_SeqFeatures","containerName":"write_seq"},{"kind":13,"line":153,"name":"$self","containerName":"write_seq"},{"line":153,"kind":12,"containerName":"write_seq","name":"write_indented_sf"},{"kind":13,"line":153,"name":"@top_sfs","containerName":"write_seq"}],"line":141,"kind":12,"signature":{"parameters":[{"label":"$self"},{"label":"@seqs"}],"documentation":"1;\n# $Id: asciitree.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqIO::asciitree\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Mungall <cjm@fruitfly.org>\n#\n# Copyright Chris Mungall\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::asciitree - asciitree sequence input/output stream\n\n=head1 SYNOPSIS\n\n  # It is probably best not to use this object directly, but\n  # rather go through the SeqIO handler system. Go:\n\n    $instream  = Bio::SeqIO->new(-file => $filename,\n                                 -format => 'chadoxml');\n    $outstream = Bio::SeqIO->new(-file => $filename,\n                                 -format => 'asciitree');\n\n    while ( my $seq = $instream->next_seq() ) {\n\t    $outstream->write_seq();\n    }\n\n\n=head1 DESCRIPTION\n\nThis is a WRITE-ONLY SeqIO module. It writes a Bio::SeqI object\ncontaining nested SeqFeature objects in such a way that the SeqFeature\ncontainment hierarchy is visible as a tree structure\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Mungall\n\nEmail cjm@fruitfly.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SeqIO::asciitree;\nuse strict;\n\n\nuse base qw(Bio::SeqIO);\n\nsub _initialize {\n    my($self,@args) = @_;\n\n    $self->SUPER::_initialize(@args);\n    # hash for functions for decoding keys.\n}\n\n=head2 show_detail\n\n Title   : show_detail\n Usage   : $obj->show_detail($newval)\n Function:\n Example :\n Returns : value of show_detail (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub show_detail{\n    my $self = shift;\n\n    return $self->{'show_detail'} = shift if @_;\n    return $self->{'show_detail'};\n}\n\n\n=head2 next_seq\n\n Title   : next_seq\n Usage   : $seq = $stream->next_seq()\n Function: returns the next sequence in the stream\n Returns : Bio::Seq object\n Args    :\n\n\nsub next_seq {\n    my ($self,@args) = @_;\n    $self->throw(\"This is a WRITE-ONLY adapter\");\n}\n\n\n=head2 write_seq\n\n Title   : write_seq\n Usage   : $stream->write_seq($seq)\n Function: writes the $seq object (must be seq) to the stream\n Returns : 1 for success and 0 for error\n Args    : array of 1 to n Bio::SeqI objects","label":"write_seq($self,@seqs)"},"detail":"($self,@seqs)","definition":"sub","containerName":"main::","range":{"start":{"character":0,"line":141},"end":{"line":155,"character":9999}},"name":"write_seq"},{"kind":12,"children":[{"kind":13,"line":158,"containerName":"write_indented_sf","definition":"my","name":"$self","localvar":"my"},{"localvar":"my","name":"$indent","definition":"my","containerName":"write_indented_sf","line":159,"kind":13},{"line":160,"kind":13,"localvar":"my","definition":"my","name":"@sfs","containerName":"write_indented_sf"},{"line":161,"kind":13,"localvar":"my","containerName":"write_indented_sf","definition":"my","name":"$sf"},{"kind":13,"line":161,"name":"@sfs","containerName":"write_indented_sf"},{"line":162,"kind":13,"localvar":"my","definition":"my","name":"$label","containerName":"write_indented_sf"},{"line":163,"kind":13,"containerName":"write_indented_sf","name":"$sf"},{"kind":12,"line":163,"name":"has_tag","containerName":"write_indented_sf"},{"line":164,"kind":13,"containerName":"write_indented_sf","name":"$label"},{"name":"$sf","containerName":"write_indented_sf","kind":13,"line":164},{"kind":12,"line":164,"name":"get_tag_values","containerName":"write_indented_sf"},{"name":"$sf","containerName":"write_indented_sf","kind":13,"line":166},{"kind":12,"line":166,"containerName":"write_indented_sf","name":"has_tag"},{"name":"$label","containerName":"write_indented_sf","kind":13,"line":167},{"name":"$sf","containerName":"write_indented_sf","line":167,"kind":13},{"line":167,"kind":12,"containerName":"write_indented_sf","name":"get_tag_values"},{"localvar":"my","definition":"my","name":"$COLS","containerName":"write_indented_sf","line":169,"kind":13},{"kind":13,"line":170,"containerName":"write_indented_sf","definition":"my","name":"$tab","localvar":"my"},{"localvar":"my","definition":"my","name":"@lines","containerName":"write_indented_sf","line":171,"kind":13},{"name":"$self","containerName":"write_indented_sf","kind":13,"line":172},{"kind":12,"line":172,"name":"show_detail","containerName":"write_indented_sf"},{"localvar":"my","containerName":"write_indented_sf","name":"@tags","definition":"my","line":173,"kind":13},{"containerName":"write_indented_sf","name":"$sf","line":173,"kind":13},{"name":"all_tags","containerName":"write_indented_sf","kind":12,"line":173},{"localvar":"my","containerName":"write_indented_sf","name":"$tag","definition":"my","line":174,"kind":13},{"containerName":"write_indented_sf","name":"@tags","line":174,"kind":13},{"line":175,"kind":13,"localvar":"my","containerName":"write_indented_sf","definition":"my","name":"@vals"},{"name":"$sf","containerName":"write_indented_sf","kind":13,"line":175},{"kind":12,"line":175,"containerName":"write_indented_sf","name":"get_tag_values"},{"name":"$tag","containerName":"write_indented_sf","kind":13,"line":175},{"definition":"my","name":"$val","containerName":"write_indented_sf","localvar":"my","kind":13,"line":176},{"kind":13,"line":176,"name":"@vals","containerName":"write_indented_sf"},{"kind":13,"line":177,"containerName":"write_indented_sf","name":"$val"},{"containerName":"write_indented_sf","name":"@lines","kind":13,"line":178},{"localvar":"my","definition":"my","name":"$cut","containerName":"write_indented_sf","line":180,"kind":13},{"name":"$val","containerName":"write_indented_sf","line":181,"kind":13},{"containerName":"write_indented_sf","name":"$COLS","line":181,"kind":13},{"line":181,"kind":13,"name":"$lines","containerName":"write_indented_sf"},{"kind":13,"line":182,"name":"$lines","containerName":"write_indented_sf"},{"kind":13,"line":183,"name":"$val","containerName":"write_indented_sf"},{"kind":13,"line":184,"name":"@lines","containerName":"write_indented_sf"},{"containerName":"write_indented_sf","name":"$tab","kind":13,"line":184},{"kind":13,"line":190,"definition":"my","name":"$detail","containerName":"write_indented_sf","localvar":"my"},{"name":"@lines","containerName":"write_indented_sf","line":190,"kind":13},{"localvar":"my","definition":"my","name":"@sub_sfs","containerName":"write_indented_sf","line":192,"kind":13},{"kind":13,"line":192,"containerName":"write_indented_sf","name":"$sf"},{"line":192,"kind":12,"containerName":"write_indented_sf","name":"get_SeqFeatures"},{"kind":13,"line":193,"name":"$locstr","definition":"my","containerName":"write_indented_sf","localvar":"my"},{"name":"@sub_sfs","containerName":"write_indented_sf","kind":13,"line":194},{"line":195,"kind":13,"name":"$locstr","containerName":"write_indented_sf"},{"containerName":"write_indented_sf","name":"$self","line":195,"kind":13},{"line":195,"kind":12,"containerName":"write_indented_sf","name":"_locstr"},{"kind":13,"line":195,"containerName":"write_indented_sf","name":"$sf"},{"kind":13,"line":197,"containerName":"write_indented_sf","name":"$col1","definition":"my","localvar":"my"},{"name":"$indent","containerName":"write_indented_sf","line":198,"kind":13},{"line":198,"kind":13,"containerName":"write_indented_sf","name":"$sf"},{"kind":12,"line":198,"containerName":"write_indented_sf","name":"primary_tag"},{"localvar":"my","name":"$line","definition":"my","containerName":"write_indented_sf","line":199,"kind":13},{"name":"$col1","containerName":"write_indented_sf","line":200,"kind":13},{"name":"$locstr","containerName":"write_indented_sf","line":200,"kind":13},{"kind":13,"line":201,"name":"$self","containerName":"write_indented_sf"},{"containerName":"write_indented_sf","name":"_print","line":201,"kind":12},{"containerName":"write_indented_sf","name":"$line","line":201,"kind":13},{"containerName":"write_indented_sf","name":"$detail","line":202,"kind":13},{"containerName":"write_indented_sf","name":"$self","line":203,"kind":13},{"containerName":"write_indented_sf","name":"_print","line":203,"kind":12},{"line":203,"kind":13,"containerName":"write_indented_sf","name":"$detail"},{"line":205,"kind":13,"name":"$self","containerName":"write_indented_sf"},{"name":"write_indented_sf","containerName":"write_indented_sf","line":205,"kind":12},{"kind":13,"line":205,"name":"$indent","containerName":"write_indented_sf"},{"containerName":"write_indented_sf","name":"@sub_sfs","line":205,"kind":13}],"line":157,"definition":"sub","name":"write_indented_sf","containerName":"main::","range":{"end":{"line":208,"character":9999},"start":{"line":157,"character":0}}},{"children":[{"kind":13,"line":211,"containerName":"_locstr","definition":"my","name":"$self","localvar":"my"},{"line":212,"kind":13,"localvar":"my","containerName":"_locstr","name":"$sf","definition":"my"},{"line":213,"kind":13,"localvar":"my","containerName":"_locstr","name":"$strand","definition":"my"},{"name":"$sf","containerName":"_locstr","line":213,"kind":13},{"containerName":"_locstr","name":"strand","kind":12,"line":213},{"localvar":"my","definition":"my","name":"$ss","containerName":"_locstr","line":214,"kind":13},{"name":"$ss","containerName":"_locstr","kind":13,"line":215},{"kind":13,"line":215,"name":"$strand","containerName":"_locstr"},{"kind":13,"line":216,"containerName":"_locstr","name":"$ss"},{"kind":13,"line":216,"containerName":"_locstr","name":"$strand"},{"kind":13,"line":218,"definition":"my","name":"$splitlocstr","containerName":"_locstr","localvar":"my"},{"name":"$sf","containerName":"_locstr","line":219,"kind":13},{"line":219,"kind":12,"containerName":"_locstr","name":"isa"},{"line":220,"kind":13,"localvar":"my","definition":"my","name":"@locs","containerName":"_locstr"},{"name":"$sf","containerName":"_locstr","kind":13,"line":220},{"kind":12,"line":220,"name":"location","containerName":"_locstr"},{"name":"$sf","containerName":"_locstr","line":221,"kind":13},{"name":"location","containerName":"_locstr","kind":12,"line":221},{"line":221,"kind":12,"containerName":"_locstr","name":"isa"},{"line":222,"kind":13,"name":"@locs","containerName":"_locstr"},{"containerName":"_locstr","name":"$sf","kind":13,"line":222},{"kind":12,"line":222,"containerName":"_locstr","name":"location"},{"name":"each_Location","containerName":"_locstr","line":222,"kind":12},{"containerName":"_locstr","name":"$splitlocstr","kind":13,"line":223},{"containerName":"_locstr","name":"$self","kind":13,"line":224},{"kind":12,"line":224,"name":"_locstr","containerName":"_locstr"},{"containerName":"_locstr","name":"@locs","kind":13,"line":224},{"containerName":"_locstr","name":"$sf","kind":13,"line":230},{"containerName":"_locstr","name":"start","kind":12,"line":230},{"line":230,"kind":13,"containerName":"_locstr","name":"$sf"},{"name":"end","containerName":"_locstr","line":230,"kind":12},{"containerName":"_locstr","name":"$ss","line":230,"kind":13}],"line":210,"kind":12,"range":{"end":{"character":9999,"line":231},"start":{"character":0,"line":210}},"definition":"sub","name":"_locstr","containerName":"main::"}]}