{"vars":[{"kind":2,"line":96,"name":"vars","containerName":""},{"kind":2,"line":100,"containerName":"strict::Bio::DB","name":"InMemoryCache"},{"name":"%HasInMemory","containerName":null,"kind":13,"line":100},{"kind":13,"line":101,"name":"$HasInMemory","containerName":null},{"kind":2,"line":108,"name":"base","containerName":""},{"name":"get_SeqFeatures","range":{"end":{"line":130,"character":9999},"start":{"line":126,"character":0}},"kind":12,"line":126,"children":[{"definition":"my","name":"$self","containerName":"get_SeqFeatures","localvar":"my","kind":13,"line":127},{"containerName":"get_SeqFeatures","name":"@args","line":127,"kind":13},{"kind":13,"line":129,"containerName":"get_SeqFeatures","name":"$self"},{"kind":12,"line":129,"name":"throw_not_implemented","containerName":"get_SeqFeatures"}],"containerName":"main::","definition":"sub","detail":"($self,@args)","signature":{"label":"get_SeqFeatures($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: SeqFeatureI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeatureI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeatureI - Abstract interface of a Sequence Feature\n\n=head1 SYNOPSIS\n\n    # get a seqfeature somehow, eg, from a Sequence with Features attached\n\n    foreach $feat ( $seq->get_SeqFeatures() ) {\n       print \"Feature from \", $feat->start, \"to \",\n\t       $feat->end, \" Primary tag  \", $feat->primary_tag,\n\t          \", produced by \", $feat->source_tag(), \"\\n\";\n\n       if( $feat->strand == 0 ) {\n\t\t    print \"Feature applicable to either strand\\n\";\n       } else {\n          print \"Feature on strand \", $feat->strand,\"\\n\"; # -1,1\n       }\n\n       print \"feature location is \",$feat->start, \"..\",\n          $feat->end, \" on strand \", $feat->strand, \"\\n\";\n       print \"easy utility to print locations in GenBank/EMBL way \",\n          $feat->location->to_FTstring(), \"\\n\";\n\n       foreach $tag ( $feat->get_all_tags() ) {\n\t\t    print \"Feature has tag \", $tag, \" with values, \",\n\t\t      join(' ',$feat->get_tag_values($tag)), \"\\n\";\n       }\n\t    print \"new feature\\n\" if $feat->has_tag('new');\n\t    # features can have sub features\n\t    my @subfeat = $feat->get_SeqFeatures();\n\t }\n\n=head1 DESCRIPTION\n\nThis interface is the functions one can expect for any Sequence\nFeature, whatever its implementation or whether it is a more complex\ntype (eg, a Gene). This object does not actually provide any\nimplemention, it just provides the definitions of what methods one can\ncall. See Bio::SeqFeature::Generic for a good standard implementation\nof this object\n\n=head1 FEEDBACK\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeatureI;\nuse vars qw($HasInMemory);\nuse strict;\nBEGIN {\n    eval { require Bio::DB::InMemoryCache };\n    if( $@ ) { $HasInMemory = 0 }\n    else { $HasInMemory = 1 }\n}\n\nuse Bio::Seq;\n\nuse Carp;\n\nuse base qw(Bio::RangeI);\n\n=head1 Bio::SeqFeatureI specific methods\n\nNew method interfaces.\n\n\n=head2 get_SeqFeatures\n\n Title   : get_SeqFeatures\n Usage   : @feats = $feat->get_SeqFeatures();\n Function: Returns an array of sub Sequence Features\n Returns : An array\n Args    : none"}},{"children":[{"kind":12,"line":143,"name":"throw_not_implemented","containerName":"display_name"}],"line":142,"kind":12,"range":{"start":{"line":142,"character":0},"end":{"line":144,"character":9999}},"name":"display_name","definition":"sub","containerName":"main::"},{"line":158,"children":[{"containerName":"primary_tag","definition":"my","name":"$self","localvar":"my","kind":13,"line":159},{"line":159,"kind":13,"name":"@args","containerName":"primary_tag"},{"containerName":"primary_tag","name":"$self","line":161,"kind":13},{"containerName":"primary_tag","name":"throw_not_implemented","line":161,"kind":12}],"kind":12,"detail":"($self,@args)","signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: SeqFeatureI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeatureI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeatureI - Abstract interface of a Sequence Feature\n\n=head1 SYNOPSIS\n\n    # get a seqfeature somehow, eg, from a Sequence with Features attached\n\n    foreach $feat ( $seq->get_SeqFeatures() ) {\n       print \"Feature from \", $feat->start, \"to \",\n\t       $feat->end, \" Primary tag  \", $feat->primary_tag,\n\t          \", produced by \", $feat->source_tag(), \"\\n\";\n\n       if( $feat->strand == 0 ) {\n\t\t    print \"Feature applicable to either strand\\n\";\n       } else {\n          print \"Feature on strand \", $feat->strand,\"\\n\"; # -1,1\n       }\n\n       print \"feature location is \",$feat->start, \"..\",\n          $feat->end, \" on strand \", $feat->strand, \"\\n\";\n       print \"easy utility to print locations in GenBank/EMBL way \",\n          $feat->location->to_FTstring(), \"\\n\";\n\n       foreach $tag ( $feat->get_all_tags() ) {\n\t\t    print \"Feature has tag \", $tag, \" with values, \",\n\t\t      join(' ',$feat->get_tag_values($tag)), \"\\n\";\n       }\n\t    print \"new feature\\n\" if $feat->has_tag('new');\n\t    # features can have sub features\n\t    my @subfeat = $feat->get_SeqFeatures();\n\t }\n\n=head1 DESCRIPTION\n\nThis interface is the functions one can expect for any Sequence\nFeature, whatever its implementation or whether it is a more complex\ntype (eg, a Gene). This object does not actually provide any\nimplemention, it just provides the definitions of what methods one can\ncall. See Bio::SeqFeature::Generic for a good standard implementation\nof this object\n\n=head1 FEEDBACK\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeatureI;\nuse vars qw($HasInMemory);\nuse strict;\nBEGIN {\n    eval { require Bio::DB::InMemoryCache };\n    if( $@ ) { $HasInMemory = 0 }\n    else { $HasInMemory = 1 }\n}\n\nuse Bio::Seq;\n\nuse Carp;\n\nuse base qw(Bio::RangeI);\n\n=head1 Bio::SeqFeatureI specific methods\n\nNew method interfaces.\n\n\n=head2 get_SeqFeatures\n\n Title   : get_SeqFeatures\n Usage   : @feats = $feat->get_SeqFeatures();\n Function: Returns an array of sub Sequence Features\n Returns : An array\n Args    : none\n\n\nsub get_SeqFeatures{\n   my ($self,@args) = @_;\n\n   $self->throw_not_implemented();\n}\n\n=head2 display_name\n\n Title   : display_name\n Usage   : $name = $feat->display_name()\n Function: Returns the human-readable name of the feature for displays.\n Returns : a string\n Args    : none\n\n\nsub display_name {\n    shift->throw_not_implemented();\n}\n\n=head2 primary_tag\n\n Title   : primary_tag\n Usage   : $tag = $feat->primary_tag()\n Function: Returns the primary tag for a feature,\n           eg 'exon'\n Returns : a string\n Args    : none","label":"primary_tag($self,@args)"},"containerName":"main::","definition":"sub","range":{"start":{"character":0,"line":158},"end":{"line":163,"character":9999}},"name":"primary_tag"},{"children":[{"kind":13,"line":178,"containerName":"source_tag","name":"$self","definition":"my","localvar":"my"},{"name":"@args","containerName":"source_tag","line":178,"kind":13},{"kind":13,"line":180,"containerName":"source_tag","name":"$self"},{"name":"throw_not_implemented","containerName":"source_tag","kind":12,"line":180}],"line":177,"kind":12,"signature":{"documentation":"1;\n# $Id: SeqFeatureI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeatureI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeatureI - Abstract interface of a Sequence Feature\n\n=head1 SYNOPSIS\n\n    # get a seqfeature somehow, eg, from a Sequence with Features attached\n\n    foreach $feat ( $seq->get_SeqFeatures() ) {\n       print \"Feature from \", $feat->start, \"to \",\n\t       $feat->end, \" Primary tag  \", $feat->primary_tag,\n\t          \", produced by \", $feat->source_tag(), \"\\n\";\n\n       if( $feat->strand == 0 ) {\n\t\t    print \"Feature applicable to either strand\\n\";\n       } else {\n          print \"Feature on strand \", $feat->strand,\"\\n\"; # -1,1\n       }\n\n       print \"feature location is \",$feat->start, \"..\",\n          $feat->end, \" on strand \", $feat->strand, \"\\n\";\n       print \"easy utility to print locations in GenBank/EMBL way \",\n          $feat->location->to_FTstring(), \"\\n\";\n\n       foreach $tag ( $feat->get_all_tags() ) {\n\t\t    print \"Feature has tag \", $tag, \" with values, \",\n\t\t      join(' ',$feat->get_tag_values($tag)), \"\\n\";\n       }\n\t    print \"new feature\\n\" if $feat->has_tag('new');\n\t    # features can have sub features\n\t    my @subfeat = $feat->get_SeqFeatures();\n\t }\n\n=head1 DESCRIPTION\n\nThis interface is the functions one can expect for any Sequence\nFeature, whatever its implementation or whether it is a more complex\ntype (eg, a Gene). This object does not actually provide any\nimplemention, it just provides the definitions of what methods one can\ncall. See Bio::SeqFeature::Generic for a good standard implementation\nof this object\n\n=head1 FEEDBACK\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeatureI;\nuse vars qw($HasInMemory);\nuse strict;\nBEGIN {\n    eval { require Bio::DB::InMemoryCache };\n    if( $@ ) { $HasInMemory = 0 }\n    else { $HasInMemory = 1 }\n}\n\nuse Bio::Seq;\n\nuse Carp;\n\nuse base qw(Bio::RangeI);\n\n=head1 Bio::SeqFeatureI specific methods\n\nNew method interfaces.\n\n\n=head2 get_SeqFeatures\n\n Title   : get_SeqFeatures\n Usage   : @feats = $feat->get_SeqFeatures();\n Function: Returns an array of sub Sequence Features\n Returns : An array\n Args    : none\n\n\nsub get_SeqFeatures{\n   my ($self,@args) = @_;\n\n   $self->throw_not_implemented();\n}\n\n=head2 display_name\n\n Title   : display_name\n Usage   : $name = $feat->display_name()\n Function: Returns the human-readable name of the feature for displays.\n Returns : a string\n Args    : none\n\n\nsub display_name {\n    shift->throw_not_implemented();\n}\n\n=head2 primary_tag\n\n Title   : primary_tag\n Usage   : $tag = $feat->primary_tag()\n Function: Returns the primary tag for a feature,\n           eg 'exon'\n Returns : a string\n Args    : none\n\n\n\nsub primary_tag{\n   my ($self,@args) = @_;\n\n   $self->throw_not_implemented();\n\n}\n\n=head2 source_tag\n\n Title   : source_tag\n Usage   : $tag = $feat->source_tag()\n Function: Returns the source tag for a feature,\n           eg, 'genscan'\n Returns : a string\n Args    : none","parameters":[{"label":"$self"},{"label":"@args"}],"label":"source_tag($self,@args)"},"detail":"($self,@args)","definition":"sub","containerName":"main::","range":{"start":{"character":0,"line":177},"end":{"character":9999,"line":181}},"name":"source_tag"},{"kind":12,"children":[{"kind":13,"line":194,"containerName":"has_tag","definition":"my","name":"$self","localvar":"my"},{"name":"@args","containerName":"has_tag","kind":13,"line":194},{"kind":13,"line":196,"containerName":"has_tag","name":"$self"},{"line":196,"kind":12,"name":"throw_not_implemented","containerName":"has_tag"}],"line":193,"definition":"sub","containerName":"main::","signature":{"label":"has_tag($self,@args)","documentation":"1;\n# $Id: SeqFeatureI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeatureI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeatureI - Abstract interface of a Sequence Feature\n\n=head1 SYNOPSIS\n\n    # get a seqfeature somehow, eg, from a Sequence with Features attached\n\n    foreach $feat ( $seq->get_SeqFeatures() ) {\n       print \"Feature from \", $feat->start, \"to \",\n\t       $feat->end, \" Primary tag  \", $feat->primary_tag,\n\t          \", produced by \", $feat->source_tag(), \"\\n\";\n\n       if( $feat->strand == 0 ) {\n\t\t    print \"Feature applicable to either strand\\n\";\n       } else {\n          print \"Feature on strand \", $feat->strand,\"\\n\"; # -1,1\n       }\n\n       print \"feature location is \",$feat->start, \"..\",\n          $feat->end, \" on strand \", $feat->strand, \"\\n\";\n       print \"easy utility to print locations in GenBank/EMBL way \",\n          $feat->location->to_FTstring(), \"\\n\";\n\n       foreach $tag ( $feat->get_all_tags() ) {\n\t\t    print \"Feature has tag \", $tag, \" with values, \",\n\t\t      join(' ',$feat->get_tag_values($tag)), \"\\n\";\n       }\n\t    print \"new feature\\n\" if $feat->has_tag('new');\n\t    # features can have sub features\n\t    my @subfeat = $feat->get_SeqFeatures();\n\t }\n\n=head1 DESCRIPTION\n\nThis interface is the functions one can expect for any Sequence\nFeature, whatever its implementation or whether it is a more complex\ntype (eg, a Gene). This object does not actually provide any\nimplemention, it just provides the definitions of what methods one can\ncall. See Bio::SeqFeature::Generic for a good standard implementation\nof this object\n\n=head1 FEEDBACK\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeatureI;\nuse vars qw($HasInMemory);\nuse strict;\nBEGIN {\n    eval { require Bio::DB::InMemoryCache };\n    if( $@ ) { $HasInMemory = 0 }\n    else { $HasInMemory = 1 }\n}\n\nuse Bio::Seq;\n\nuse Carp;\n\nuse base qw(Bio::RangeI);\n\n=head1 Bio::SeqFeatureI specific methods\n\nNew method interfaces.\n\n\n=head2 get_SeqFeatures\n\n Title   : get_SeqFeatures\n Usage   : @feats = $feat->get_SeqFeatures();\n Function: Returns an array of sub Sequence Features\n Returns : An array\n Args    : none\n\n\nsub get_SeqFeatures{\n   my ($self,@args) = @_;\n\n   $self->throw_not_implemented();\n}\n\n=head2 display_name\n\n Title   : display_name\n Usage   : $name = $feat->display_name()\n Function: Returns the human-readable name of the feature for displays.\n Returns : a string\n Args    : none\n\n\nsub display_name {\n    shift->throw_not_implemented();\n}\n\n=head2 primary_tag\n\n Title   : primary_tag\n Usage   : $tag = $feat->primary_tag()\n Function: Returns the primary tag for a feature,\n           eg 'exon'\n Returns : a string\n Args    : none\n\n\n\nsub primary_tag{\n   my ($self,@args) = @_;\n\n   $self->throw_not_implemented();\n\n}\n\n=head2 source_tag\n\n Title   : source_tag\n Usage   : $tag = $feat->source_tag()\n Function: Returns the source tag for a feature,\n           eg, 'genscan'\n Returns : a string\n Args    : none\n\n\n\nsub source_tag{\n   my ($self,@args) = @_;\n\n   $self->throw_not_implemented();\n}\n\n=head2 has_tag\n\n Title   : has_tag\n Usage   : $tag_exists = $self->has_tag('some_tag')\n Function: \n Returns : TRUE if the specified tag exists, and FALSE otherwise\n Args    :","parameters":[{"label":"$self"},{"label":"@args"}]},"detail":"($self,@args)","name":"has_tag","range":{"start":{"character":0,"line":193},"end":{"line":198,"character":9999}}},{"children":[{"kind":12,"line":213,"containerName":"get_tag_values","name":"throw_not_implemented"}],"line":212,"kind":12,"range":{"end":{"character":9999,"line":214},"start":{"line":212,"character":0}},"definition":"sub","name":"get_tag_values","containerName":"main::"},{"kind":12,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"get_tagset_values","line":234,"kind":13},{"name":"@args","containerName":"get_tagset_values","kind":13,"line":234},{"line":235,"kind":13,"localvar":"my","definition":"my","name":"@vals","containerName":"get_tagset_values"},{"line":236,"kind":13,"localvar":"my","containerName":"get_tagset_values","name":"$arg","definition":"my"},{"name":"@args","containerName":"get_tagset_values","line":236,"kind":13},{"line":237,"kind":13,"containerName":"get_tagset_values","name":"$self"},{"kind":12,"line":237,"name":"has_tag","containerName":"get_tagset_values"},{"name":"$arg","containerName":"get_tagset_values","kind":13,"line":237},{"kind":13,"line":238,"name":"@vals","containerName":"get_tagset_values"},{"kind":13,"line":238,"containerName":"get_tagset_values","name":"$self"},{"containerName":"get_tagset_values","name":"get_tag_values","line":238,"kind":12},{"containerName":"get_tagset_values","name":"$arg","line":238,"kind":13},{"containerName":"get_tagset_values","name":"@vals","line":241,"kind":13}],"line":233,"definition":"sub","containerName":"main::","signature":{"documentation":"1;\n# $Id: SeqFeatureI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeatureI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeatureI - Abstract interface of a Sequence Feature\n\n=head1 SYNOPSIS\n\n    # get a seqfeature somehow, eg, from a Sequence with Features attached\n\n    foreach $feat ( $seq->get_SeqFeatures() ) {\n       print \"Feature from \", $feat->start, \"to \",\n\t       $feat->end, \" Primary tag  \", $feat->primary_tag,\n\t          \", produced by \", $feat->source_tag(), \"\\n\";\n\n       if( $feat->strand == 0 ) {\n\t\t    print \"Feature applicable to either strand\\n\";\n       } else {\n          print \"Feature on strand \", $feat->strand,\"\\n\"; # -1,1\n       }\n\n       print \"feature location is \",$feat->start, \"..\",\n          $feat->end, \" on strand \", $feat->strand, \"\\n\";\n       print \"easy utility to print locations in GenBank/EMBL way \",\n          $feat->location->to_FTstring(), \"\\n\";\n\n       foreach $tag ( $feat->get_all_tags() ) {\n\t\t    print \"Feature has tag \", $tag, \" with values, \",\n\t\t      join(' ',$feat->get_tag_values($tag)), \"\\n\";\n       }\n\t    print \"new feature\\n\" if $feat->has_tag('new');\n\t    # features can have sub features\n\t    my @subfeat = $feat->get_SeqFeatures();\n\t }\n\n=head1 DESCRIPTION\n\nThis interface is the functions one can expect for any Sequence\nFeature, whatever its implementation or whether it is a more complex\ntype (eg, a Gene). This object does not actually provide any\nimplemention, it just provides the definitions of what methods one can\ncall. See Bio::SeqFeature::Generic for a good standard implementation\nof this object\n\n=head1 FEEDBACK\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeatureI;\nuse vars qw($HasInMemory);\nuse strict;\nBEGIN {\n    eval { require Bio::DB::InMemoryCache };\n    if( $@ ) { $HasInMemory = 0 }\n    else { $HasInMemory = 1 }\n}\n\nuse Bio::Seq;\n\nuse Carp;\n\nuse base qw(Bio::RangeI);\n\n=head1 Bio::SeqFeatureI specific methods\n\nNew method interfaces.\n\n\n=head2 get_SeqFeatures\n\n Title   : get_SeqFeatures\n Usage   : @feats = $feat->get_SeqFeatures();\n Function: Returns an array of sub Sequence Features\n Returns : An array\n Args    : none\n\n\nsub get_SeqFeatures{\n   my ($self,@args) = @_;\n\n   $self->throw_not_implemented();\n}\n\n=head2 display_name\n\n Title   : display_name\n Usage   : $name = $feat->display_name()\n Function: Returns the human-readable name of the feature for displays.\n Returns : a string\n Args    : none\n\n\nsub display_name {\n    shift->throw_not_implemented();\n}\n\n=head2 primary_tag\n\n Title   : primary_tag\n Usage   : $tag = $feat->primary_tag()\n Function: Returns the primary tag for a feature,\n           eg 'exon'\n Returns : a string\n Args    : none\n\n\n\nsub primary_tag{\n   my ($self,@args) = @_;\n\n   $self->throw_not_implemented();\n\n}\n\n=head2 source_tag\n\n Title   : source_tag\n Usage   : $tag = $feat->source_tag()\n Function: Returns the source tag for a feature,\n           eg, 'genscan'\n Returns : a string\n Args    : none\n\n\n\nsub source_tag{\n   my ($self,@args) = @_;\n\n   $self->throw_not_implemented();\n}\n\n=head2 has_tag\n\n Title   : has_tag\n Usage   : $tag_exists = $self->has_tag('some_tag')\n Function: \n Returns : TRUE if the specified tag exists, and FALSE otherwise\n Args    :\n\n\nsub has_tag{\n   my ($self,@args) = @_;\n\n   $self->throw_not_implemented();\n\n}\n\n=head2 get_tag_values\n\n Title   : get_tag_values\n Usage   : @values = $self->get_tag_values('some_tag')\n Function: \n Returns : An array comprising the values of the specified tag.\n Args    : a string\n\nthrows an exception if there is no such tag\n\n\nsub get_tag_values {\n    shift->throw_not_implemented();\n}\n\n=head2 get_tagset_values\n\n Title   : get_tagset_values\n Usage   : @values = $self->get_tagset_values(qw(label transcript_id product))\n Function: \n Returns : An array comprising the values of the specified tags, in order of tags\n Args    : An array of strings\n\ndoes NOT throw an exception if none of the tags are not present\n\nthis method is useful for getting a human-readable label for a\nSeqFeatureI; not all tags can be assumed to be present, so a list of\npossible tags in preferential order is provided\n\n interface + abstract method","parameters":[{"label":"$self"},{"label":"@args"}],"label":"get_tagset_values($self,@args)"},"detail":"($self,@args)","name":"get_tagset_values","range":{"end":{"character":9999,"line":242},"start":{"line":233,"character":0}}},{"line":255,"children":[{"kind":12,"line":256,"name":"throw_not_implemented","containerName":"get_all_tags"}],"kind":12,"range":{"start":{"line":255,"character":0},"end":{"character":9999,"line":257}},"containerName":"main::","definition":"sub","name":"get_all_tags"},{"children":[{"containerName":"attach_seq","name":"throw_not_implemented","kind":12,"line":289}],"line":288,"kind":12,"range":{"start":{"line":288,"character":0},"end":{"character":9999,"line":290}},"definition":"sub","name":"attach_seq","containerName":"main::"},{"containerName":"main::","definition":"sub","name":"seq","range":{"end":{"line":308,"character":9999},"start":{"line":306,"character":0}},"kind":12,"line":306,"children":[{"line":307,"kind":12,"name":"throw_not_implemented","containerName":"seq"}]},{"range":{"end":{"character":9999,"line":325},"start":{"line":323,"character":0}},"definition":"sub","name":"entire_seq","containerName":"main::","children":[{"name":"throw_not_implemented","containerName":"entire_seq","kind":12,"line":324}],"line":323,"kind":12},{"containerName":"main::","definition":"sub","name":"seq_id","range":{"start":{"character":0,"line":346},"end":{"line":348,"character":9999}},"kind":12,"line":346,"children":[{"kind":12,"line":347,"name":"throw_not_implemented","containerName":"seq_id"}]},{"kind":12,"children":[{"kind":13,"line":372,"containerName":"gff_string","definition":"my","name":"$self","localvar":"my"},{"name":"$formatter","containerName":"gff_string","kind":13,"line":372},{"line":374,"kind":13,"name":"$formatter","containerName":"gff_string"},{"kind":13,"line":374,"containerName":"gff_string","name":"$self"},{"kind":12,"line":374,"name":"_static_gff_formatter","containerName":"gff_string"},{"name":"$formatter","containerName":"gff_string","line":374,"kind":13},{"kind":13,"line":375,"name":"$formatter","containerName":"gff_string"},{"containerName":"gff_string","name":"gff_string","line":375,"kind":12},{"containerName":"gff_string","name":"$self","line":375,"kind":13}],"line":371,"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"$formatter"}],"documentation":"1;\n# $Id: SeqFeatureI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeatureI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeatureI - Abstract interface of a Sequence Feature\n\n=head1 SYNOPSIS\n\n    # get a seqfeature somehow, eg, from a Sequence with Features attached\n\n    foreach $feat ( $seq->get_SeqFeatures() ) {\n       print \"Feature from \", $feat->start, \"to \",\n\t       $feat->end, \" Primary tag  \", $feat->primary_tag,\n\t          \", produced by \", $feat->source_tag(), \"\\n\";\n\n       if( $feat->strand == 0 ) {\n\t\t    print \"Feature applicable to either strand\\n\";\n       } else {\n          print \"Feature on strand \", $feat->strand,\"\\n\"; # -1,1\n       }\n\n       print \"feature location is \",$feat->start, \"..\",\n          $feat->end, \" on strand \", $feat->strand, \"\\n\";\n       print \"easy utility to print locations in GenBank/EMBL way \",\n          $feat->location->to_FTstring(), \"\\n\";\n\n       foreach $tag ( $feat->get_all_tags() ) {\n\t\t    print \"Feature has tag \", $tag, \" with values, \",\n\t\t      join(' ',$feat->get_tag_values($tag)), \"\\n\";\n       }\n\t    print \"new feature\\n\" if $feat->has_tag('new');\n\t    # features can have sub features\n\t    my @subfeat = $feat->get_SeqFeatures();\n\t }\n\n=head1 DESCRIPTION\n\nThis interface is the functions one can expect for any Sequence\nFeature, whatever its implementation or whether it is a more complex\ntype (eg, a Gene). This object does not actually provide any\nimplemention, it just provides the definitions of what methods one can\ncall. See Bio::SeqFeature::Generic for a good standard implementation\nof this object\n\n=head1 FEEDBACK\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeatureI;\nuse vars qw($HasInMemory);\nuse strict;\nBEGIN {\n    eval { require Bio::DB::InMemoryCache };\n    if( $@ ) { $HasInMemory = 0 }\n    else { $HasInMemory = 1 }\n}\n\nuse Bio::Seq;\n\nuse Carp;\n\nuse base qw(Bio::RangeI);\n\n=head1 Bio::SeqFeatureI specific methods\n\nNew method interfaces.\n\n\n=head2 get_SeqFeatures\n\n Title   : get_SeqFeatures\n Usage   : @feats = $feat->get_SeqFeatures();\n Function: Returns an array of sub Sequence Features\n Returns : An array\n Args    : none\n\n\nsub get_SeqFeatures{\n   my ($self,@args) = @_;\n\n   $self->throw_not_implemented();\n}\n\n=head2 display_name\n\n Title   : display_name\n Usage   : $name = $feat->display_name()\n Function: Returns the human-readable name of the feature for displays.\n Returns : a string\n Args    : none\n\n\nsub display_name {\n    shift->throw_not_implemented();\n}\n\n=head2 primary_tag\n\n Title   : primary_tag\n Usage   : $tag = $feat->primary_tag()\n Function: Returns the primary tag for a feature,\n           eg 'exon'\n Returns : a string\n Args    : none\n\n\n\nsub primary_tag{\n   my ($self,@args) = @_;\n\n   $self->throw_not_implemented();\n\n}\n\n=head2 source_tag\n\n Title   : source_tag\n Usage   : $tag = $feat->source_tag()\n Function: Returns the source tag for a feature,\n           eg, 'genscan'\n Returns : a string\n Args    : none\n\n\n\nsub source_tag{\n   my ($self,@args) = @_;\n\n   $self->throw_not_implemented();\n}\n\n=head2 has_tag\n\n Title   : has_tag\n Usage   : $tag_exists = $self->has_tag('some_tag')\n Function: \n Returns : TRUE if the specified tag exists, and FALSE otherwise\n Args    :\n\n\nsub has_tag{\n   my ($self,@args) = @_;\n\n   $self->throw_not_implemented();\n\n}\n\n=head2 get_tag_values\n\n Title   : get_tag_values\n Usage   : @values = $self->get_tag_values('some_tag')\n Function: \n Returns : An array comprising the values of the specified tag.\n Args    : a string\n\nthrows an exception if there is no such tag\n\n\nsub get_tag_values {\n    shift->throw_not_implemented();\n}\n\n=head2 get_tagset_values\n\n Title   : get_tagset_values\n Usage   : @values = $self->get_tagset_values(qw(label transcript_id product))\n Function: \n Returns : An array comprising the values of the specified tags, in order of tags\n Args    : An array of strings\n\ndoes NOT throw an exception if none of the tags are not present\n\nthis method is useful for getting a human-readable label for a\nSeqFeatureI; not all tags can be assumed to be present, so a list of\npossible tags in preferential order is provided\n\n\n# interface + abstract method\nsub get_tagset_values {\n    my ($self, @args) = @_;\n    my @vals = ();\n    foreach my $arg (@args) {\n        if ($self->has_tag($arg)) {\n            push(@vals, $self->get_tag_values($arg));\n        }\n    }\n    return @vals;\n}\n\n=head2 get_all_tags\n\n Title   : get_all_tags\n Usage   : @tags = $feat->get_all_tags()\n Function: gives all tags for this feature\n Returns : an array of strings\n Args    : none\n\n\n\nsub get_all_tags{\n    shift->throw_not_implemented();\n}\n\n=head2 attach_seq\n\n Title   : attach_seq\n Usage   : $sf->attach_seq($seq)\n Function: Attaches a Bio::Seq object to this feature. This\n           Bio::Seq object is for the *entire* sequence: ie\n           from 1 to 10000\n\n           Note that it is not guaranteed that if you obtain a feature from\n           an object in bioperl, it will have a sequence attached. Also,\n           implementors of this interface can choose to provide an empty\n           implementation of this method. I.e., there is also no guarantee\n           that if you do attach a sequence, seq() or entire_seq() will not\n           return undef.\n\n           The reason that this method is here on the interface is to enable\n           you to call it on every SeqFeatureI compliant object, and\n           that it will be implemented in a useful way and set to a useful\n           value for the great majority of use cases. Implementors who choose\n           to ignore the call are encouraged to specifically state this in\n           their documentation.\n\n Example :\n Returns : TRUE on success\n Args    : a Bio::PrimarySeqI compliant object\n\n\n\nsub attach_seq {\n    shift->throw_not_implemented();\n}\n\n=head2 seq\n\n Title   : seq\n Usage   : $tseq = $sf->seq()\n Function: returns the truncated sequence (if there is a sequence attached)\n           for this feature\n Example :\n Returns : sub seq (a Bio::PrimarySeqI compliant object) on attached sequence\n           bounded by start & end, or undef if there is no sequence attached\n Args    : none\n\n\n\nsub seq {\n    shift->throw_not_implemented();\n}\n\n=head2 entire_seq\n\n Title   : entire_seq\n Usage   : $whole_seq = $sf->entire_seq()\n Function: gives the entire sequence that this seqfeature is attached to\n Example :\n Returns : a Bio::PrimarySeqI compliant object, or undef if there is no\n           sequence attached\n Args    : none\n\n\n\nsub entire_seq {\n    shift->throw_not_implemented();\n}\n\n\n=head2 seq_id\n\n Title   : seq_id\n Usage   : $obj->seq_id($newval)\n Function: There are many cases when you make a feature that you\n           do know the sequence name, but do not know its actual\n           sequence. This is an attribute such that you can store\n           the ID (e.g., display_id) of the sequence.\n\n           This attribute should *not* be used in GFF dumping, as\n           that should come from the collection in which the seq\n           feature was found.\n Returns : value of seq_id\n Args    : newvalue (optional)\n\n\n\nsub seq_id {\n    shift->throw_not_implemented();\n}\n\n=head2 gff_string\n\n Title   : gff_string\n Usage   : $str = $feat->gff_string;\n           $str = $feat->gff_string($gff_formatter);\n Function: Provides the feature information in GFF format.\n\n           The implementation provided here returns GFF2 by default. If you\n           want a different version, supply an object implementing a method\n           gff_string() accepting a SeqFeatureI object as argument. E.g., to\n           obtain GFF1 format, do the following:\n\n                my $gffio = Bio::Tools::GFF->new(-gff_version => 1);\n                $gff1str = $feat->gff_string($gff1io);\n\n Returns : A string\n Args    : Optionally, an object implementing gff_string().","label":"gff_string($self,$formatter)"},"detail":"($self,$formatter)","name":"gff_string","range":{"end":{"line":376,"character":9999},"start":{"character":0,"line":371}}},{"containerName":null,"definition":"my","name":"$static_gff_formatter","localvar":"my","kind":13,"line":378},{"name":"_static_gff_formatter","range":{"end":{"character":9999,"line":399},"start":{"line":392,"character":0}},"containerName":"main::","definition":"sub","detail":"($self,@args)","signature":{"label":"_static_gff_formatter($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: SeqFeatureI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeatureI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeatureI - Abstract interface of a Sequence Feature\n\n=head1 SYNOPSIS\n\n    # get a seqfeature somehow, eg, from a Sequence with Features attached\n\n    foreach $feat ( $seq->get_SeqFeatures() ) {\n       print \"Feature from \", $feat->start, \"to \",\n\t       $feat->end, \" Primary tag  \", $feat->primary_tag,\n\t          \", produced by \", $feat->source_tag(), \"\\n\";\n\n       if( $feat->strand == 0 ) {\n\t\t    print \"Feature applicable to either strand\\n\";\n       } else {\n          print \"Feature on strand \", $feat->strand,\"\\n\"; # -1,1\n       }\n\n       print \"feature location is \",$feat->start, \"..\",\n          $feat->end, \" on strand \", $feat->strand, \"\\n\";\n       print \"easy utility to print locations in GenBank/EMBL way \",\n          $feat->location->to_FTstring(), \"\\n\";\n\n       foreach $tag ( $feat->get_all_tags() ) {\n\t\t    print \"Feature has tag \", $tag, \" with values, \",\n\t\t      join(' ',$feat->get_tag_values($tag)), \"\\n\";\n       }\n\t    print \"new feature\\n\" if $feat->has_tag('new');\n\t    # features can have sub features\n\t    my @subfeat = $feat->get_SeqFeatures();\n\t }\n\n=head1 DESCRIPTION\n\nThis interface is the functions one can expect for any Sequence\nFeature, whatever its implementation or whether it is a more complex\ntype (eg, a Gene). This object does not actually provide any\nimplemention, it just provides the definitions of what methods one can\ncall. See Bio::SeqFeature::Generic for a good standard implementation\nof this object\n\n=head1 FEEDBACK\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeatureI;\nuse vars qw($HasInMemory);\nuse strict;\nBEGIN {\n    eval { require Bio::DB::InMemoryCache };\n    if( $@ ) { $HasInMemory = 0 }\n    else { $HasInMemory = 1 }\n}\n\nuse Bio::Seq;\n\nuse Carp;\n\nuse base qw(Bio::RangeI);\n\n=head1 Bio::SeqFeatureI specific methods\n\nNew method interfaces.\n\n\n=head2 get_SeqFeatures\n\n Title   : get_SeqFeatures\n Usage   : @feats = $feat->get_SeqFeatures();\n Function: Returns an array of sub Sequence Features\n Returns : An array\n Args    : none\n\n\nsub get_SeqFeatures{\n   my ($self,@args) = @_;\n\n   $self->throw_not_implemented();\n}\n\n=head2 display_name\n\n Title   : display_name\n Usage   : $name = $feat->display_name()\n Function: Returns the human-readable name of the feature for displays.\n Returns : a string\n Args    : none\n\n\nsub display_name {\n    shift->throw_not_implemented();\n}\n\n=head2 primary_tag\n\n Title   : primary_tag\n Usage   : $tag = $feat->primary_tag()\n Function: Returns the primary tag for a feature,\n           eg 'exon'\n Returns : a string\n Args    : none\n\n\n\nsub primary_tag{\n   my ($self,@args) = @_;\n\n   $self->throw_not_implemented();\n\n}\n\n=head2 source_tag\n\n Title   : source_tag\n Usage   : $tag = $feat->source_tag()\n Function: Returns the source tag for a feature,\n           eg, 'genscan'\n Returns : a string\n Args    : none\n\n\n\nsub source_tag{\n   my ($self,@args) = @_;\n\n   $self->throw_not_implemented();\n}\n\n=head2 has_tag\n\n Title   : has_tag\n Usage   : $tag_exists = $self->has_tag('some_tag')\n Function: \n Returns : TRUE if the specified tag exists, and FALSE otherwise\n Args    :\n\n\nsub has_tag{\n   my ($self,@args) = @_;\n\n   $self->throw_not_implemented();\n\n}\n\n=head2 get_tag_values\n\n Title   : get_tag_values\n Usage   : @values = $self->get_tag_values('some_tag')\n Function: \n Returns : An array comprising the values of the specified tag.\n Args    : a string\n\nthrows an exception if there is no such tag\n\n\nsub get_tag_values {\n    shift->throw_not_implemented();\n}\n\n=head2 get_tagset_values\n\n Title   : get_tagset_values\n Usage   : @values = $self->get_tagset_values(qw(label transcript_id product))\n Function: \n Returns : An array comprising the values of the specified tags, in order of tags\n Args    : An array of strings\n\ndoes NOT throw an exception if none of the tags are not present\n\nthis method is useful for getting a human-readable label for a\nSeqFeatureI; not all tags can be assumed to be present, so a list of\npossible tags in preferential order is provided\n\n\n# interface + abstract method\nsub get_tagset_values {\n    my ($self, @args) = @_;\n    my @vals = ();\n    foreach my $arg (@args) {\n        if ($self->has_tag($arg)) {\n            push(@vals, $self->get_tag_values($arg));\n        }\n    }\n    return @vals;\n}\n\n=head2 get_all_tags\n\n Title   : get_all_tags\n Usage   : @tags = $feat->get_all_tags()\n Function: gives all tags for this feature\n Returns : an array of strings\n Args    : none\n\n\n\nsub get_all_tags{\n    shift->throw_not_implemented();\n}\n\n=head2 attach_seq\n\n Title   : attach_seq\n Usage   : $sf->attach_seq($seq)\n Function: Attaches a Bio::Seq object to this feature. This\n           Bio::Seq object is for the *entire* sequence: ie\n           from 1 to 10000\n\n           Note that it is not guaranteed that if you obtain a feature from\n           an object in bioperl, it will have a sequence attached. Also,\n           implementors of this interface can choose to provide an empty\n           implementation of this method. I.e., there is also no guarantee\n           that if you do attach a sequence, seq() or entire_seq() will not\n           return undef.\n\n           The reason that this method is here on the interface is to enable\n           you to call it on every SeqFeatureI compliant object, and\n           that it will be implemented in a useful way and set to a useful\n           value for the great majority of use cases. Implementors who choose\n           to ignore the call are encouraged to specifically state this in\n           their documentation.\n\n Example :\n Returns : TRUE on success\n Args    : a Bio::PrimarySeqI compliant object\n\n\n\nsub attach_seq {\n    shift->throw_not_implemented();\n}\n\n=head2 seq\n\n Title   : seq\n Usage   : $tseq = $sf->seq()\n Function: returns the truncated sequence (if there is a sequence attached)\n           for this feature\n Example :\n Returns : sub seq (a Bio::PrimarySeqI compliant object) on attached sequence\n           bounded by start & end, or undef if there is no sequence attached\n Args    : none\n\n\n\nsub seq {\n    shift->throw_not_implemented();\n}\n\n=head2 entire_seq\n\n Title   : entire_seq\n Usage   : $whole_seq = $sf->entire_seq()\n Function: gives the entire sequence that this seqfeature is attached to\n Example :\n Returns : a Bio::PrimarySeqI compliant object, or undef if there is no\n           sequence attached\n Args    : none\n\n\n\nsub entire_seq {\n    shift->throw_not_implemented();\n}\n\n\n=head2 seq_id\n\n Title   : seq_id\n Usage   : $obj->seq_id($newval)\n Function: There are many cases when you make a feature that you\n           do know the sequence name, but do not know its actual\n           sequence. This is an attribute such that you can store\n           the ID (e.g., display_id) of the sequence.\n\n           This attribute should *not* be used in GFF dumping, as\n           that should come from the collection in which the seq\n           feature was found.\n Returns : value of seq_id\n Args    : newvalue (optional)\n\n\n\nsub seq_id {\n    shift->throw_not_implemented();\n}\n\n=head2 gff_string\n\n Title   : gff_string\n Usage   : $str = $feat->gff_string;\n           $str = $feat->gff_string($gff_formatter);\n Function: Provides the feature information in GFF format.\n\n           The implementation provided here returns GFF2 by default. If you\n           want a different version, supply an object implementing a method\n           gff_string() accepting a SeqFeatureI object as argument. E.g., to\n           obtain GFF1 format, do the following:\n\n                my $gffio = Bio::Tools::GFF->new(-gff_version => 1);\n                $gff1str = $feat->gff_string($gff1io);\n\n Returns : A string\n Args    : Optionally, an object implementing gff_string().\n\n\n\nsub gff_string{\n   my ($self,$formatter) = @_;\n\n   $formatter = $self->_static_gff_formatter unless $formatter;\n   return $formatter->gff_string($self);\n}\n\nmy $static_gff_formatter = undef;\n\n=head2 _static_gff_formatter\n\n Title   : _static_gff_formatter\n Usage   :\n Function:\n Example :\n Returns :\n Args    :"},"kind":12,"line":392,"children":[{"containerName":"_static_gff_formatter","name":"$self","definition":"my","localvar":"my","kind":13,"line":393},{"kind":13,"line":393,"name":"@args","containerName":"_static_gff_formatter"},{"name":"$static_gff_formatter","containerName":"_static_gff_formatter","kind":13,"line":395},{"containerName":"_static_gff_formatter","name":"$static_gff_formatter","kind":13,"line":396},{"name":"new","containerName":"_static_gff_formatter","kind":12,"line":396},{"name":"$static_gff_formatter","containerName":"_static_gff_formatter","line":398,"kind":13}]},{"containerName":"Tools::GFF","name":"Bio","kind":12,"line":395},{"containerName":"Tools::GFF","name":"Bio","line":396,"kind":12},{"children":[{"localvar":"my","containerName":"spliced_seq","name":"$self","definition":"my","line":451,"kind":13},{"kind":13,"line":452,"definition":"my","name":"@args","containerName":"spliced_seq","localvar":"my"},{"localvar":"my","containerName":"spliced_seq","definition":"my","name":"$db","line":453,"kind":13},{"line":453,"kind":13,"name":"$nosort","containerName":"spliced_seq"},{"containerName":"spliced_seq","name":"$phase","kind":13,"line":453},{"containerName":"spliced_seq","name":"$self","kind":13,"line":454},{"name":"_rearrange","containerName":"spliced_seq","kind":12,"line":454},{"line":454,"kind":13,"containerName":"spliced_seq","name":"@args"},{"line":457,"kind":13,"name":"$self","containerName":"spliced_seq"},{"kind":12,"line":457,"name":"entire_seq","containerName":"spliced_seq"},{"kind":12,"line":457,"name":"is_circular","containerName":"spliced_seq"},{"name":"$nosort","containerName":"spliced_seq","kind":13,"line":458},{"localvar":"my","containerName":"spliced_seq","definition":"my","name":"$old_api","line":462,"kind":13},{"name":"@args","containerName":"spliced_seq","line":462,"kind":13},{"line":463,"kind":13,"name":"@args","containerName":"spliced_seq"},{"kind":13,"line":463,"name":"$old_api","containerName":"spliced_seq"},{"name":"$self","containerName":"spliced_seq","line":464,"kind":13},{"containerName":"spliced_seq","name":"warn","kind":12,"line":464},{"containerName":"spliced_seq","name":"$db","kind":13,"line":466},{"name":"@args","containerName":"spliced_seq","line":466,"kind":13},{"kind":13,"line":466,"name":"@args","containerName":"spliced_seq"},{"kind":13,"line":467,"name":"$nosort","containerName":"spliced_seq"},{"containerName":"spliced_seq","name":"@args","kind":13,"line":467},{"containerName":"spliced_seq","name":"@args","line":467,"kind":13},{"name":"$phase","containerName":"spliced_seq","kind":13,"line":468},{"kind":13,"line":468,"name":"@args","containerName":"spliced_seq"},{"line":468,"kind":13,"containerName":"spliced_seq","name":"@args"},{"name":"$phase","containerName":"spliced_seq","line":471,"kind":13},{"containerName":"spliced_seq","name":"$phase","kind":13,"line":471},{"kind":13,"line":471,"containerName":"spliced_seq","name":"$phase"},{"containerName":"spliced_seq","name":"$self","line":472,"kind":13},{"containerName":"spliced_seq","name":"warn","line":472,"kind":12},{"line":473,"kind":13,"containerName":"spliced_seq","name":"$phase"},{"kind":13,"line":476,"name":"$db","containerName":"spliced_seq"},{"name":"$db","containerName":"spliced_seq","line":476,"kind":13},{"name":"$db","containerName":"spliced_seq","line":476,"kind":13},{"line":476,"kind":12,"name":"isa","containerName":"spliced_seq"},{"containerName":"spliced_seq","name":"$self","kind":13,"line":477},{"kind":12,"line":477,"name":"warn","containerName":"spliced_seq"},{"kind":13,"line":479,"containerName":"spliced_seq","name":"$db"},{"containerName":"spliced_seq","name":"$db","kind":13,"line":480},{"name":"$HasInMemory","containerName":"spliced_seq","line":480,"kind":13},{"kind":13,"line":481,"containerName":"spliced_seq","name":"$db"},{"containerName":"spliced_seq","name":"isa","line":481,"kind":12},{"containerName":"spliced_seq","name":"$db","kind":13,"line":482},{"containerName":"spliced_seq","name":"new","line":482,"kind":12},{"name":"$db","containerName":"spliced_seq","line":482,"kind":13},{"kind":13,"line":485,"name":"$self","containerName":"spliced_seq"},{"kind":12,"line":485,"name":"location","containerName":"spliced_seq"},{"containerName":"spliced_seq","name":"isa","kind":12,"line":485},{"containerName":"spliced_seq","name":"$phase","line":486,"kind":13},{"containerName":"spliced_seq","name":"$self","kind":13,"line":487},{"kind":12,"line":487,"containerName":"spliced_seq","name":"debug"},{"containerName":"spliced_seq","name":"$phase","line":487,"kind":13},{"kind":13,"line":487,"name":"$self","containerName":"spliced_seq"},{"name":"end","containerName":"spliced_seq","kind":12,"line":487},{"kind":13,"line":488,"name":"$seqstr","definition":"my","containerName":"spliced_seq","localvar":"my"},{"containerName":"spliced_seq","name":"$self","line":488,"kind":13},{"kind":12,"line":488,"containerName":"spliced_seq","name":"seq"},{"containerName":"spliced_seq","name":"seq","line":488,"kind":12},{"name":"$phase","containerName":"spliced_seq","line":488,"kind":13},{"line":489,"kind":13,"localvar":"my","containerName":"spliced_seq","definition":"my","name":"$out"},{"containerName":"spliced_seq","name":"new","line":489,"kind":12},{"containerName":"spliced_seq","name":"$self","kind":13,"line":489},{"containerName":"spliced_seq","name":"entire_seq","kind":12,"line":489},{"containerName":"spliced_seq","name":"display_id","line":490,"kind":12},{"containerName":"spliced_seq","name":"$seqstr","kind":13,"line":491},{"containerName":"spliced_seq","name":"$out","line":492,"kind":13},{"line":494,"kind":13,"containerName":"spliced_seq","name":"$self"},{"containerName":"spliced_seq","name":"seq","kind":12,"line":494},{"line":499,"kind":13,"containerName":"spliced_seq","name":"$self"},{"line":499,"kind":12,"containerName":"spliced_seq","name":"location"},{"line":499,"kind":12,"containerName":"spliced_seq","name":"isa"},{"containerName":"spliced_seq","name":"$self","kind":13,"line":500},{"line":500,"kind":12,"containerName":"spliced_seq","name":"throw"},{"localvar":"my","name":"$seqstr","definition":"my","containerName":"spliced_seq","line":503,"kind":13},{"definition":"my","name":"$seqid","containerName":"spliced_seq","localvar":"my","kind":13,"line":504},{"name":"$self","containerName":"spliced_seq","kind":13,"line":504},{"kind":12,"line":504,"containerName":"spliced_seq","name":"entire_seq"},{"containerName":"spliced_seq","name":"display_id","kind":12,"line":504},{"localvar":"my","containerName":"spliced_seq","name":"$mixed","definition":"my","line":512,"kind":13},{"name":"$mixedloc","containerName":"spliced_seq","line":512,"kind":13},{"line":512,"kind":13,"name":"$fstrand","containerName":"spliced_seq"},{"containerName":"spliced_seq","name":"$self","line":514,"kind":13},{"kind":12,"line":514,"name":"isa","containerName":"spliced_seq"},{"kind":13,"line":515,"containerName":"spliced_seq","name":"$self"},{"containerName":"spliced_seq","name":"absolute","line":515,"kind":12},{"name":"$self","containerName":"spliced_seq","line":516,"kind":13},{"containerName":"spliced_seq","name":"warn","kind":12,"line":516},{"containerName":"spliced_seq","name":"@locset","definition":"my","localvar":"my","kind":13,"line":519},{"line":519,"kind":13,"name":"$self","containerName":"spliced_seq"},{"kind":12,"line":519,"containerName":"spliced_seq","name":"location"},{"containerName":"spliced_seq","name":"each_Location","kind":12,"line":519},{"line":520,"kind":13,"localvar":"my","definition":"my","name":"@locs","containerName":"spliced_seq"},{"line":521,"kind":13,"containerName":"spliced_seq","name":"$nosort"},{"containerName":"spliced_seq","name":"@locs","kind":13,"line":522},{"line":527,"kind":13,"containerName":"spliced_seq","name":"$a"},{"kind":13,"line":527,"name":"$b","containerName":"spliced_seq"},{"containerName":"spliced_seq","name":"$fstrand","line":529,"kind":13},{"containerName":"spliced_seq","name":"strand","kind":12,"line":529},{"kind":13,"line":529,"containerName":"spliced_seq","name":"$fstrand"},{"containerName":"spliced_seq","name":"$mixed","kind":13,"line":530},{"line":530,"kind":12,"name":"strand","containerName":"spliced_seq"},{"containerName":"spliced_seq","name":"$fstrand","line":530,"kind":13},{"name":"strand","containerName":"spliced_seq","kind":12,"line":530},{"name":"seq_id","containerName":"spliced_seq","kind":12,"line":531},{"containerName":"spliced_seq","name":"$mixedloc","line":532,"kind":13},{"kind":12,"line":532,"containerName":"spliced_seq","name":"seq_id"},{"kind":13,"line":532,"name":"$seqid","containerName":"spliced_seq"},{"kind":12,"line":534,"name":"start","containerName":"spliced_seq"},{"kind":12,"line":534,"name":"strand","containerName":"spliced_seq"},{"containerName":"spliced_seq","name":"@locset","kind":13,"line":535},{"kind":13,"line":537,"name":"$mixed","containerName":"spliced_seq"},{"containerName":"spliced_seq","name":"$self","kind":13,"line":538},{"kind":12,"line":538,"containerName":"spliced_seq","name":"warn"},{"name":"@locs","containerName":"spliced_seq","line":539,"kind":13},{"name":"@locset","containerName":"spliced_seq","line":539,"kind":13},{"name":"@locs","containerName":"spliced_seq","line":543,"kind":13},{"kind":13,"line":543,"containerName":"spliced_seq","name":"@locset"},{"kind":13,"line":544,"containerName":"spliced_seq","name":"$fstrand"},{"line":544,"kind":13,"containerName":"spliced_seq","name":"$locs"},{"name":"strand","containerName":"spliced_seq","line":544,"kind":12},{"localvar":"my","containerName":"spliced_seq","definition":"my","name":"$loc","line":547,"kind":13},{"name":"@locs","containerName":"spliced_seq","kind":13,"line":547},{"line":548,"kind":13,"name":"$loc","containerName":"spliced_seq"},{"name":"isa","containerName":"spliced_seq","line":548,"kind":12},{"line":549,"kind":13,"name":"$self","containerName":"spliced_seq"},{"name":"throw","containerName":"spliced_seq","line":549,"kind":12},{"line":551,"kind":13,"localvar":"my","containerName":"spliced_seq","name":"$called_seq","definition":"my"},{"containerName":"spliced_seq","name":"$fstrand","kind":13,"line":552},{"line":552,"kind":13,"name":"$loc","containerName":"spliced_seq"},{"containerName":"spliced_seq","name":"strand","kind":12,"line":552},{"kind":13,"line":553,"containerName":"spliced_seq","name":"$self"},{"kind":12,"line":553,"containerName":"spliced_seq","name":"warn"},{"containerName":"spliced_seq","name":"$loc","line":557,"kind":13},{"line":557,"kind":12,"containerName":"spliced_seq","name":"seq_id"},{"name":"$loc","containerName":"spliced_seq","line":558,"kind":13},{"name":"seq_id","containerName":"spliced_seq","kind":12,"line":558},{"containerName":"spliced_seq","name":"$seqid","kind":13,"line":558},{"containerName":"spliced_seq","name":"$db","kind":13,"line":559},{"containerName":"spliced_seq","definition":"my","name":"$sid","localvar":"my","kind":13,"line":560},{"containerName":"spliced_seq","name":"$loc","kind":13,"line":560},{"name":"seq_id","containerName":"spliced_seq","kind":12,"line":560},{"line":561,"kind":13,"containerName":"spliced_seq","name":"$sid"},{"containerName":"spliced_seq","name":"$called_seq","kind":13,"line":563},{"kind":13,"line":563,"name":"$db","containerName":"spliced_seq"},{"containerName":"spliced_seq","name":"get_Seq_by_acc","line":563,"kind":12},{"name":"$sid","containerName":"spliced_seq","kind":13,"line":563},{"containerName":"spliced_seq","name":"$self","line":566,"kind":13},{"name":"warn","containerName":"spliced_seq","line":566,"kind":12},{"containerName":"spliced_seq","name":"$called_seq","line":567,"kind":13},{"line":570,"kind":13,"containerName":"spliced_seq","name":"$self"},{"name":"warn","containerName":"spliced_seq","line":570,"kind":12},{"containerName":"spliced_seq","name":"$loc","line":570,"kind":13},{"containerName":"spliced_seq","name":"seq_id","kind":12,"line":570},{"containerName":"spliced_seq","name":"$called_seq","kind":13,"line":571},{"kind":13,"line":573,"name":"$called_seq","containerName":"spliced_seq"},{"name":"$seqstr","containerName":"spliced_seq","kind":13,"line":574},{"name":"$self","containerName":"spliced_seq","kind":13,"line":574},{"name":"length","containerName":"spliced_seq","line":574,"kind":12},{"name":"$called_seq","containerName":"spliced_seq","line":578,"kind":13},{"line":578,"kind":13,"name":"$self","containerName":"spliced_seq"},{"name":"entire_seq","containerName":"spliced_seq","kind":12,"line":578},{"name":"$called_seq","containerName":"spliced_seq","line":582,"kind":13},{"containerName":"spliced_seq","name":"length","line":582,"kind":12},{"kind":13,"line":582,"containerName":"spliced_seq","name":"$loc"},{"line":582,"kind":12,"name":"end","containerName":"spliced_seq"},{"containerName":"spliced_seq","name":"$accession","definition":"my","localvar":"my","kind":13,"line":583},{"kind":13,"line":583,"containerName":"spliced_seq","name":"$called_seq"},{"name":"accession","containerName":"spliced_seq","line":583,"kind":12},{"line":584,"kind":13,"localvar":"my","definition":"my","name":"$end","containerName":"spliced_seq"},{"name":"$loc","containerName":"spliced_seq","line":584,"kind":13},{"line":584,"kind":12,"name":"end","containerName":"spliced_seq"},{"kind":13,"line":585,"definition":"my","name":"$length","containerName":"spliced_seq","localvar":"my"},{"containerName":"spliced_seq","name":"$called_seq","kind":13,"line":585},{"containerName":"spliced_seq","name":"length","kind":12,"line":585},{"containerName":"spliced_seq","name":"$orig_id","definition":"my","localvar":"my","kind":13,"line":586},{"name":"$self","containerName":"spliced_seq","kind":13,"line":586},{"name":"seq_id","containerName":"spliced_seq","line":586,"kind":12},{"localvar":"my","containerName":"spliced_seq","definition":"my","name":"$locus","line":587,"kind":13},{"containerName":"spliced_seq","name":"$self","kind":13,"line":587},{"line":587,"kind":12,"containerName":"spliced_seq","name":"get_tagset_values"},{"containerName":"spliced_seq","name":"$self","kind":13,"line":588},{"containerName":"spliced_seq","name":"throw","line":588,"kind":12},{"line":593,"kind":13,"containerName":"spliced_seq","name":"$self"},{"line":593,"kind":12,"name":"isa","containerName":"spliced_seq"},{"definition":"my","name":"$s","containerName":"spliced_seq","localvar":"my","kind":13,"line":594},{"name":"$e","containerName":"spliced_seq","kind":13,"line":594},{"line":594,"kind":13,"containerName":"spliced_seq","name":"$loc"},{"kind":12,"line":594,"name":"start","containerName":"spliced_seq"},{"kind":13,"line":594,"containerName":"spliced_seq","name":"$loc"},{"containerName":"spliced_seq","name":"end","kind":12,"line":594},{"containerName":"spliced_seq","name":"$seqstr","line":598,"kind":13},{"line":598,"kind":13,"name":"$called_seq","containerName":"spliced_seq"},{"kind":12,"line":598,"containerName":"spliced_seq","name":"subseq"},{"line":598,"kind":13,"name":"$s","containerName":"spliced_seq"},{"kind":13,"line":598,"name":"$e","containerName":"spliced_seq"},{"containerName":"spliced_seq","name":"seq","line":598,"kind":12},{"line":598,"kind":12,"name":"seq","containerName":"spliced_seq"},{"containerName":"spliced_seq","name":"$loc","line":601,"kind":13},{"line":601,"kind":12,"containerName":"spliced_seq","name":"strand"},{"name":"$seqstr","containerName":"spliced_seq","line":602,"kind":13},{"line":602,"kind":13,"containerName":"spliced_seq","name":"$called_seq"},{"line":602,"kind":12,"name":"subseq","containerName":"spliced_seq"},{"containerName":"spliced_seq","name":"$loc","line":602,"kind":13},{"kind":12,"line":602,"containerName":"spliced_seq","name":"start"},{"line":602,"kind":13,"containerName":"spliced_seq","name":"$loc"},{"kind":12,"line":602,"name":"end","containerName":"spliced_seq"},{"containerName":"spliced_seq","name":"$nosort","line":604,"kind":13},{"name":"$seqstr","containerName":"spliced_seq","line":605,"kind":13},{"name":"$called_seq","containerName":"spliced_seq","kind":13,"line":605},{"line":605,"kind":12,"name":"trunc","containerName":"spliced_seq"},{"line":605,"kind":13,"containerName":"spliced_seq","name":"$loc"},{"kind":12,"line":605,"containerName":"spliced_seq","name":"start"},{"line":605,"kind":13,"name":"$loc","containerName":"spliced_seq"},{"name":"end","containerName":"spliced_seq","line":605,"kind":12},{"line":605,"kind":12,"name":"revcom","containerName":"spliced_seq"},{"name":"seq","containerName":"spliced_seq","kind":12,"line":605},{"kind":13,"line":605,"containerName":"spliced_seq","name":"$seqstr"},{"kind":13,"line":607,"name":"$seqstr","containerName":"spliced_seq"},{"line":607,"kind":13,"name":"$called_seq","containerName":"spliced_seq"},{"containerName":"spliced_seq","name":"trunc","line":607,"kind":12},{"kind":13,"line":607,"name":"$loc","containerName":"spliced_seq"},{"kind":12,"line":607,"name":"start","containerName":"spliced_seq"},{"containerName":"spliced_seq","name":"$loc","line":607,"kind":13},{"kind":12,"line":607,"containerName":"spliced_seq","name":"end"},{"containerName":"spliced_seq","name":"revcom","kind":12,"line":607},{"containerName":"spliced_seq","name":"seq","line":607,"kind":12},{"name":"$phase","containerName":"spliced_seq","kind":13,"line":613},{"line":614,"kind":13,"name":"$seqstr","containerName":"spliced_seq"},{"containerName":"spliced_seq","name":"$seqstr","line":614,"kind":13},{"line":614,"kind":13,"containerName":"spliced_seq","name":"$phase"},{"definition":"my","name":"$out","containerName":"spliced_seq","localvar":"my","kind":13,"line":617},{"name":"new","containerName":"spliced_seq","kind":12,"line":617},{"name":"$self","containerName":"spliced_seq","kind":13,"line":617},{"line":617,"kind":12,"name":"entire_seq","containerName":"spliced_seq"},{"containerName":"spliced_seq","name":"display_id","kind":12,"line":618},{"kind":13,"line":619,"name":"$seqstr","containerName":"spliced_seq"},{"name":"$out","containerName":"spliced_seq","line":621,"kind":13}],"line":450,"kind":12,"range":{"start":{"line":450,"character":0},"end":{"character":9999,"line":622}},"name":"spliced_seq","definition":"sub","containerName":"main::"},{"kind":12,"line":482,"containerName":"DB::InMemoryCache","name":"Bio"},{"line":489,"kind":12,"containerName":"Seq","name":"Bio"},{"line":617,"kind":12,"containerName":"Seq","name":"Bio"},{"name":"location","range":{"end":{"line":640,"character":9999},"start":{"line":636,"character":0}},"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: SeqFeatureI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeatureI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeatureI - Abstract interface of a Sequence Feature\n\n=head1 SYNOPSIS\n\n    # get a seqfeature somehow, eg, from a Sequence with Features attached\n\n    foreach $feat ( $seq->get_SeqFeatures() ) {\n       print \"Feature from \", $feat->start, \"to \",\n\t       $feat->end, \" Primary tag  \", $feat->primary_tag,\n\t          \", produced by \", $feat->source_tag(), \"\\n\";\n\n       if( $feat->strand == 0 ) {\n\t\t    print \"Feature applicable to either strand\\n\";\n       } else {\n          print \"Feature on strand \", $feat->strand,\"\\n\"; # -1,1\n       }\n\n       print \"feature location is \",$feat->start, \"..\",\n          $feat->end, \" on strand \", $feat->strand, \"\\n\";\n       print \"easy utility to print locations in GenBank/EMBL way \",\n          $feat->location->to_FTstring(), \"\\n\";\n\n       foreach $tag ( $feat->get_all_tags() ) {\n\t\t    print \"Feature has tag \", $tag, \" with values, \",\n\t\t      join(' ',$feat->get_tag_values($tag)), \"\\n\";\n       }\n\t    print \"new feature\\n\" if $feat->has_tag('new');\n\t    # features can have sub features\n\t    my @subfeat = $feat->get_SeqFeatures();\n\t }\n\n=head1 DESCRIPTION\n\nThis interface is the functions one can expect for any Sequence\nFeature, whatever its implementation or whether it is a more complex\ntype (eg, a Gene). This object does not actually provide any\nimplemention, it just provides the definitions of what methods one can\ncall. See Bio::SeqFeature::Generic for a good standard implementation\nof this object\n\n=head1 FEEDBACK\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeatureI;\nuse vars qw($HasInMemory);\nuse strict;\nBEGIN {\n    eval { require Bio::DB::InMemoryCache };\n    if( $@ ) { $HasInMemory = 0 }\n    else { $HasInMemory = 1 }\n}\n\nuse Bio::Seq;\n\nuse Carp;\n\nuse base qw(Bio::RangeI);\n\n=head1 Bio::SeqFeatureI specific methods\n\nNew method interfaces.\n\n\n=head2 get_SeqFeatures\n\n Title   : get_SeqFeatures\n Usage   : @feats = $feat->get_SeqFeatures();\n Function: Returns an array of sub Sequence Features\n Returns : An array\n Args    : none\n\n\nsub get_SeqFeatures{\n   my ($self,@args) = @_;\n\n   $self->throw_not_implemented();\n}\n\n=head2 display_name\n\n Title   : display_name\n Usage   : $name = $feat->display_name()\n Function: Returns the human-readable name of the feature for displays.\n Returns : a string\n Args    : none\n\n\nsub display_name {\n    shift->throw_not_implemented();\n}\n\n=head2 primary_tag\n\n Title   : primary_tag\n Usage   : $tag = $feat->primary_tag()\n Function: Returns the primary tag for a feature,\n           eg 'exon'\n Returns : a string\n Args    : none\n\n\n\nsub primary_tag{\n   my ($self,@args) = @_;\n\n   $self->throw_not_implemented();\n\n}\n\n=head2 source_tag\n\n Title   : source_tag\n Usage   : $tag = $feat->source_tag()\n Function: Returns the source tag for a feature,\n           eg, 'genscan'\n Returns : a string\n Args    : none\n\n\n\nsub source_tag{\n   my ($self,@args) = @_;\n\n   $self->throw_not_implemented();\n}\n\n=head2 has_tag\n\n Title   : has_tag\n Usage   : $tag_exists = $self->has_tag('some_tag')\n Function: \n Returns : TRUE if the specified tag exists, and FALSE otherwise\n Args    :\n\n\nsub has_tag{\n   my ($self,@args) = @_;\n\n   $self->throw_not_implemented();\n\n}\n\n=head2 get_tag_values\n\n Title   : get_tag_values\n Usage   : @values = $self->get_tag_values('some_tag')\n Function: \n Returns : An array comprising the values of the specified tag.\n Args    : a string\n\nthrows an exception if there is no such tag\n\n\nsub get_tag_values {\n    shift->throw_not_implemented();\n}\n\n=head2 get_tagset_values\n\n Title   : get_tagset_values\n Usage   : @values = $self->get_tagset_values(qw(label transcript_id product))\n Function: \n Returns : An array comprising the values of the specified tags, in order of tags\n Args    : An array of strings\n\ndoes NOT throw an exception if none of the tags are not present\n\nthis method is useful for getting a human-readable label for a\nSeqFeatureI; not all tags can be assumed to be present, so a list of\npossible tags in preferential order is provided\n\n\n# interface + abstract method\nsub get_tagset_values {\n    my ($self, @args) = @_;\n    my @vals = ();\n    foreach my $arg (@args) {\n        if ($self->has_tag($arg)) {\n            push(@vals, $self->get_tag_values($arg));\n        }\n    }\n    return @vals;\n}\n\n=head2 get_all_tags\n\n Title   : get_all_tags\n Usage   : @tags = $feat->get_all_tags()\n Function: gives all tags for this feature\n Returns : an array of strings\n Args    : none\n\n\n\nsub get_all_tags{\n    shift->throw_not_implemented();\n}\n\n=head2 attach_seq\n\n Title   : attach_seq\n Usage   : $sf->attach_seq($seq)\n Function: Attaches a Bio::Seq object to this feature. This\n           Bio::Seq object is for the *entire* sequence: ie\n           from 1 to 10000\n\n           Note that it is not guaranteed that if you obtain a feature from\n           an object in bioperl, it will have a sequence attached. Also,\n           implementors of this interface can choose to provide an empty\n           implementation of this method. I.e., there is also no guarantee\n           that if you do attach a sequence, seq() or entire_seq() will not\n           return undef.\n\n           The reason that this method is here on the interface is to enable\n           you to call it on every SeqFeatureI compliant object, and\n           that it will be implemented in a useful way and set to a useful\n           value for the great majority of use cases. Implementors who choose\n           to ignore the call are encouraged to specifically state this in\n           their documentation.\n\n Example :\n Returns : TRUE on success\n Args    : a Bio::PrimarySeqI compliant object\n\n\n\nsub attach_seq {\n    shift->throw_not_implemented();\n}\n\n=head2 seq\n\n Title   : seq\n Usage   : $tseq = $sf->seq()\n Function: returns the truncated sequence (if there is a sequence attached)\n           for this feature\n Example :\n Returns : sub seq (a Bio::PrimarySeqI compliant object) on attached sequence\n           bounded by start & end, or undef if there is no sequence attached\n Args    : none\n\n\n\nsub seq {\n    shift->throw_not_implemented();\n}\n\n=head2 entire_seq\n\n Title   : entire_seq\n Usage   : $whole_seq = $sf->entire_seq()\n Function: gives the entire sequence that this seqfeature is attached to\n Example :\n Returns : a Bio::PrimarySeqI compliant object, or undef if there is no\n           sequence attached\n Args    : none\n\n\n\nsub entire_seq {\n    shift->throw_not_implemented();\n}\n\n\n=head2 seq_id\n\n Title   : seq_id\n Usage   : $obj->seq_id($newval)\n Function: There are many cases when you make a feature that you\n           do know the sequence name, but do not know its actual\n           sequence. This is an attribute such that you can store\n           the ID (e.g., display_id) of the sequence.\n\n           This attribute should *not* be used in GFF dumping, as\n           that should come from the collection in which the seq\n           feature was found.\n Returns : value of seq_id\n Args    : newvalue (optional)\n\n\n\nsub seq_id {\n    shift->throw_not_implemented();\n}\n\n=head2 gff_string\n\n Title   : gff_string\n Usage   : $str = $feat->gff_string;\n           $str = $feat->gff_string($gff_formatter);\n Function: Provides the feature information in GFF format.\n\n           The implementation provided here returns GFF2 by default. If you\n           want a different version, supply an object implementing a method\n           gff_string() accepting a SeqFeatureI object as argument. E.g., to\n           obtain GFF1 format, do the following:\n\n                my $gffio = Bio::Tools::GFF->new(-gff_version => 1);\n                $gff1str = $feat->gff_string($gff1io);\n\n Returns : A string\n Args    : Optionally, an object implementing gff_string().\n\n\n\nsub gff_string{\n   my ($self,$formatter) = @_;\n\n   $formatter = $self->_static_gff_formatter unless $formatter;\n   return $formatter->gff_string($self);\n}\n\nmy $static_gff_formatter = undef;\n\n=head2 _static_gff_formatter\n\n Title   : _static_gff_formatter\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub _static_gff_formatter{\n   my ($self,@args) = @_;\n   require Bio::Tools::GFF; # on the fly inclusion -- is this better?\n   if( !defined $static_gff_formatter ) {\n       $static_gff_formatter = Bio::Tools::GFF->new('-gff_version' => 2);\n   }\n   return $static_gff_formatter;\n}\n\n\n=head1 Decorating methods\n\nThese methods have an implementation provided by Bio::SeqFeatureI,\nbut can be validly overwritten by subclasses\n\n=head2 spliced_seq\n\n  Title   : spliced_seq\n\n  Usage   : $seq = $feature->spliced_seq()\n            $seq = $feature_with_remote_locations->spliced_seq($db_for_seqs)\n\n  Function: Provides a sequence of the feature which is the most\n            semantically \"relevant\" feature for this sequence. A default\n            implementation is provided which for simple cases returns just\n            the sequence, but for split cases, loops over the split location\n            to return the sequence. In the case of split locations with\n            remote locations, eg\n\n            join(AB000123:5567-5589,80..1144)\n\n            in the case when a database object is passed in, it will attempt\n            to retrieve the sequence from the database object, and \"Do the right thing\",\n            however if no database object is provided, it will generate the correct\n            number of N's (DNA) or X's (protein, though this is unlikely).\n\n            This function is deliberately \"magical\" attempting to second guess\n            what a user wants as \"the\" sequence for this feature.\n\n            Implementing classes are free to override this method with their\n            own magic if they have a better idea what the user wants.\n\n  Args    : [optional]\n            -db        A L<Bio::DB::RandomAccessI> compliant object if\n                       one needs to retrieve remote seqs.\n            -nosort    boolean if the locations should not be sorted\n                       by start location.  This may occur, for instance,\n                       in a circular sequence where a gene span starts\n                       before the end of the sequence and ends after the\n                       sequence start. Example : join(15685..16260,1..207)\n\t\t\t\t\t   (default = if sequence is_circular(), 1, otherwise 0)\n\t\t\t-phase     truncates the returned sequence based on the\n\t\t\t\t\t   intron phase (0,1,2).\n\n  Returns : A L<Bio::PrimarySeqI> object\n\n\nsub spliced_seq {\n    my $self = shift;\n\tmy @args = @_;\n\tmy ($db, $nosort, $phase) =\n\t   $self->_rearrange([qw(DB NOSORT PHASE)], @args);\n\t\n\t# set no_sort based on the parent sequence status\n\tif ($self->entire_seq->is_circular) {\n\t\t$nosort = 1;\n\t}\n\t\n\t# (added 7/7/06 to allow use old API (with warnings)\n\tmy $old_api = (!(grep {$_ =~ /(?:nosort|db|phase)/} @args)) ? 1 : 0;\n\tif (@args && $old_api) {\n\t\t$self->warn(q(API has changed; please use '-db' or '-nosort' ).\n                     qq(for args. See POD for more details.));\n\t\t$db = shift @args if @args;\n\t\t$nosort = shift @args if @args;\n\t\t$phase = shift @args if @args;\n\t};\n\t\n\tif (defined($phase) && ($phase < 0 || $phase > 2)) {\n\t    $self->warn(\"Phase must be 0,1, or 2.  Setting phase to 0...\");\n\t    $phase = 0;\n\t}\n\t\n\tif( $db && ref($db) && ! $db->isa('Bio::DB::RandomAccessI') ) {\n        $self->warn(\"Must pass in a valid Bio::DB::RandomAccessI object\".\n                    \" for access to remote locations for spliced_seq\");\n        $db = undef;\n    } elsif( defined $db && $HasInMemory &&\n            $db->isa('Bio::DB::InMemoryCache') ) {\n        $db = Bio::DB::InMemoryCache->new(-seqdb => $db);\n    }\n\n    if( ! $self->location->isa(\"Bio::Location::SplitLocationI\") ) {\n        if ($phase) {\n\t    $self->debug(\"Subseq start: \",$phase+1,\"\\tend: \",$self->end,\"\\n\");\n\t    my $seqstr = substr($self->seq->seq, $phase);\n\t    my $out = Bio::Seq->new( -id => $self->entire_seq->display_id\n\t\t\t\t. \"_spliced_feat\",\n\t\t\t -seq => $seqstr);\n\t    return $out;\n\t} else {\n\t    return $self->seq(); # nice and easy!\n\t}\n    }\n    \n    # redundant test, but the above ISA is probably not ideal.\n    if( ! $self->location->isa(\"Bio::Location::SplitLocationI\") ) {\n\t$self->throw(\"not atomic, not split, yikes, in trouble!\");\n    }\n\n    my $seqstr = '';\n    my $seqid = $self->entire_seq->display_id;\n    # This is to deal with reverse strand features\n    # so we are really sorting features 5' -> 3' on their strand\n    # i.e. rev strand features will be sorted largest to smallest\n    # as this how revcom CDSes seem to be annotated in genbank.\n    # Might need to eventually allow this to be programable?\n    # (can I mention how much fun this is NOT! --jason)\n\n    my ($mixed,$mixedloc, $fstrand) = (0);\n\n    if( $self->isa('Bio::Das::SegmentI') &&\n\t! $self->absolute ) {\n\t$self->warn(\"Calling spliced_seq with a Bio::Das::SegmentI which does have absolute set to 1 -- be warned you may not be getting things on the correct strand\");\n    }\n\n    my @locset = $self->location->each_Location;\n    my @locs;\n    if( ! $nosort ) {\n\t@locs = map { $_->[0] }\n\t# sort so that most negative is first basically to order\n\t# the features on the opposite strand 5'->3' on their strand\n\t# rather than they way most are input which is on the fwd strand\n\n\tsort { $a->[1] <=> $b->[1] } # Yes Tim, Schwartzian transformation\n\tmap {\n\t    $fstrand = $_->strand unless defined $fstrand;\n\t    $mixed = 1 if defined $_->strand && $fstrand != $_->strand;\n\t    if( defined $_->seq_id ) {\n\t\t$mixedloc = 1 if( $_->seq_id ne $seqid );\n\t    }\n\t    [ $_, $_->start * ($_->strand || 1)];\n\t} @locset;\n\n\tif ( $mixed ) {\n\t    $self->warn(\"Mixed strand locations, spliced seq using the input order rather than trying to sort\");\n\t    @locs = @locset;\n\t}\n    } else {\n\t# use the original order instead of trying to sort\n\t@locs = @locset;\n\t$fstrand = $locs[0]->strand;\n    }\n\n    foreach my $loc ( @locs ) {\n\tif( ! $loc->isa(\"Bio::Location::Atomic\") ) {\n\t    $self->throw(\"Can only deal with one level deep locations\");\n\t}\n\tmy $called_seq;\n\tif( $fstrand != $loc->strand ) {\n\t    $self->warn(\"feature strand is different from location strand!\");\n\t}\n\t# deal with remote sequences\n\n\tif( defined $loc->seq_id &&\n\t    $loc->seq_id ne $seqid ) {\n\t    if( defined $db ) {\n\t\tmy $sid = $loc->seq_id;\n\t\t$sid =~ s/\\.\\d+$//g;\n\t\teval {\n\t\t    $called_seq = $db->get_Seq_by_acc($sid);\n\t\t};\n\t\tif( $@ ) {\n\t\t    $self->warn(\"In attempting to join a remote location, sequence $sid was not in database. Will provide padding N's. Full exception \\n\\n$@\");\n\t\t    $called_seq = undef;\n\t\t}\n\t    } else {\n\t\t$self->warn( \"cannot get remote location for \".$loc->seq_id .\" without a valid Bio::DB::RandomAccessI database handle (like Bio::DB::GenBank)\");\n\t\t$called_seq = undef;\n\t    }\n\t    if( !defined $called_seq ) {\n\t\t$seqstr .= 'N' x $self->length;\n\t\tnext;\n\t    }\n\t} else {\n\t    $called_seq = $self->entire_seq;\n\t}\n\n    # does the called sequence make sense? Bug 1780\n    if ($called_seq->length < $loc->end) {\n        my $accession = $called_seq->accession;\n        my $end = $loc->end;\n        my $length = $called_seq->length;\n        my $orig_id = $self->seq_id; # originating sequence\n        my ($locus) = $self->get_tagset_values(\"locus_tag\");\n        $self->throw(\"Location end ($end) exceeds length ($length) of \".\n                     \"called sequence $accession.\\nCheck sequence version used in \".\n                     \"$locus locus-tagged SeqFeature in $orig_id.\");\n    }\n\n\tif( $self->isa('Bio::Das::SegmentI') ) {\n\t    my ($s,$e) = ($loc->start,$loc->end);\n\t\t# $called_seq is Bio::DB::GFF::RelSegment, as well as its subseq();\n\t\t# Bio::DB::GFF::RelSegment::seq() returns a Bio::PrimarySeq, and using seq()\n\t\t# in turn returns a string.  Confused?\n\t    $seqstr .= $called_seq->subseq($s,$e)->seq()->seq();\n\t} else {\n\t    # This is dumb, subseq should work on locations...\n\t    if( $loc->strand == 1 ) {\n\t\t$seqstr .= $called_seq->subseq($loc->start,$loc->end);\n\t    } else {\n\t\tif( $nosort ) {\n\t\t    $seqstr = $called_seq->trunc($loc->start,$loc->end)->revcom->seq() . $seqstr;\n\t\t} else {\n\t\t    $seqstr .= $called_seq->trunc($loc->start,$loc->end)->revcom->seq();\n\t\t}\n\t    }\n\t}\n    }\n    \n    if (defined($phase)) {\n\t$seqstr = substr($seqstr, $phase);\n    }\n    \n    my $out = Bio::Seq->new( -id => $self->entire_seq->display_id\n\t\t\t            . \"_spliced_feat\",\n\t\t\t     -seq => $seqstr);\n\n    return $out;\n}\n\n=head2 location\n\n Title   : location\n Usage   : my $location = $seqfeature->location()\n Function: returns a location object suitable for identifying location\n\t   of feature on sequence or parent feature\n Returns : Bio::LocationI object\n Args    : none","label":"location($self)"},"detail":"($self)","kind":12,"children":[{"definition":"my","name":"$self","containerName":"location","localvar":"my","kind":13,"line":637},{"name":"$self","containerName":"location","line":639,"kind":13},{"kind":12,"line":639,"name":"throw_not_implemented","containerName":"location"}],"line":636},{"range":{"end":{"character":9999,"line":676},"start":{"character":0,"line":656}},"name":"primary_id","definition":"sub","containerName":"main::","children":[{"kind":13,"line":657,"definition":"my","name":"$self","containerName":"primary_id","localvar":"my"},{"kind":13,"line":669,"containerName":"primary_id","name":"$self"},{"kind":12,"line":669,"containerName":"primary_id","name":"has_tag"},{"containerName":"primary_id","name":"$self","line":670,"kind":13},{"kind":12,"line":670,"name":"remove_tag","containerName":"primary_id"},{"kind":13,"line":672,"name":"$self","containerName":"primary_id"},{"line":672,"kind":12,"containerName":"primary_id","name":"add_tag_value"},{"line":674,"kind":13,"localvar":"my","containerName":"primary_id","name":"$id","definition":"my"},{"name":"$self","containerName":"primary_id","line":674,"kind":13},{"name":"get_tagset_values","containerName":"primary_id","kind":12,"line":674},{"kind":13,"line":675,"containerName":"primary_id","name":"$id"}],"line":656,"kind":12},{"line":678,"children":[{"name":"$self","definition":"my","containerName":"generate_unique_persistent_id","localvar":"my","kind":13,"line":680},{"name":"new","containerName":"generate_unique_persistent_id","kind":12,"line":682},{"containerName":"generate_unique_persistent_id","name":"generate_unique_persistent_id","kind":12,"line":682},{"name":"$self","containerName":"generate_unique_persistent_id","line":682,"kind":13}],"kind":12,"range":{"end":{"line":683,"character":9999},"start":{"line":678,"character":0}},"containerName":"main::","definition":"sub","name":"generate_unique_persistent_id"},{"kind":12,"line":682,"name":"Bio","containerName":"SeqFeature::Tools::IDHandler::Bio::SeqFeature::Tools::IDHandler"}],"version":5}