{"vars":[{"line":78,"kind":2,"containerName":"","name":"base"},{"range":{"start":{"character":0,"line":92},"end":{"character":9999,"line":102}},"name":"new","line":92,"children":[{"line":93,"kind":13,"localvar":"my","definition":"my","name":"$class","containerName":"new"},{"containerName":"new","name":"@args","kind":13,"line":93},{"name":"$self","definition":"my","containerName":"new","localvar":"my","kind":13,"line":94},{"kind":13,"line":94,"name":"$class","containerName":"new"},{"kind":13,"line":94,"name":"@args","containerName":"new"},{"kind":13,"line":96,"name":"$generate_id_sub","definition":"my","containerName":"new","localvar":"my"},{"containerName":"new","name":"$self","line":97,"kind":13},{"line":97,"kind":12,"containerName":"new","name":"_rearrange"},{"line":99,"kind":13,"containerName":"new","name":"@args"},{"kind":13,"line":101,"containerName":"new","name":"$self"}],"kind":12,"detail":"($class,@args)","signature":{"parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: IDHandler.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::SeqFeature::Tools::IDHandler\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Mungall <cjm@fruitfly.org>\n#\n# Copyright Chris Mungall\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Tools::IDHandler - maps $seq_feature-E<gt>primary_tag\n\n=head1 SYNOPSIS\n\n  use Bio::SeqIO;\n  use Bio::SeqFeature::Tools::IDHandler;\n\n\n=head1 DESCRIPTION\n\nClass to map $seq_feature-E<gt>primary_tag\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Mungall\n\nEmail:  cjm@fruitfly.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::SeqFeature::Tools::IDHandler;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : $unflattener = Bio::SeqFeature::Tools::IDHandler->new();\n Function: constructor\n Example : \n Returns : a new Bio::SeqFeature::Tools::IDHandler\n Args    : see below","label":"new($class,@args)"},"containerName":"main::","definition":"sub"},{"name":"SUPER","containerName":"new","kind":12,"line":94},{"name":"set_ParentIDs_from_hierarchy","range":{"start":{"line":124,"character":0},"end":{"line":165,"character":9999}},"kind":12,"line":124,"children":[{"kind":13,"line":125,"containerName":"set_ParentIDs_from_hierarchy","definition":"my","name":"$self","localvar":"my"},{"localvar":"my","name":"$featholder","definition":"my","containerName":"set_ParentIDs_from_hierarchy","line":126,"kind":13},{"kind":13,"line":132,"definition":"my","name":"@sfs","containerName":"set_ParentIDs_from_hierarchy","localvar":"my"},{"containerName":"set_ParentIDs_from_hierarchy","name":"$featholder","line":132,"kind":13},{"name":"get_SeqFeatures","containerName":"set_ParentIDs_from_hierarchy","kind":12,"line":132},{"name":"@all_sfs","definition":"my","containerName":"set_ParentIDs_from_hierarchy","localvar":"my","kind":13,"line":136},{"containerName":"set_ParentIDs_from_hierarchy","name":"$featholder","line":136,"kind":13},{"kind":12,"line":136,"name":"get_all_SeqFeatures","containerName":"set_ParentIDs_from_hierarchy"},{"kind":13,"line":137,"name":"@all_sfs","containerName":"set_ParentIDs_from_hierarchy"},{"line":138,"kind":12,"containerName":"set_ParentIDs_from_hierarchy","name":"has_tag"},{"kind":12,"line":139,"name":"remove_tag","containerName":"set_ParentIDs_from_hierarchy"},{"line":145,"kind":13,"containerName":"set_ParentIDs_from_hierarchy","name":"@sfs"},{"containerName":"set_ParentIDs_from_hierarchy","name":"$sf","definition":"my","localvar":"my","kind":13,"line":146},{"containerName":"set_ParentIDs_from_hierarchy","name":"@sfs","line":146,"kind":13},{"kind":13,"line":147,"containerName":"set_ParentIDs_from_hierarchy","name":"@subsfs","definition":"my","localvar":"my"},{"name":"$sf","containerName":"set_ParentIDs_from_hierarchy","line":147,"kind":13},{"line":147,"kind":12,"name":"get_SeqFeatures","containerName":"set_ParentIDs_from_hierarchy"},{"line":150,"kind":13,"localvar":"my","definition":"my","name":"$id","containerName":"set_ParentIDs_from_hierarchy"},{"line":150,"kind":13,"containerName":"set_ParentIDs_from_hierarchy","name":"$sf"},{"kind":12,"line":150,"name":"primary_id","containerName":"set_ParentIDs_from_hierarchy"},{"name":"$id","containerName":"set_ParentIDs_from_hierarchy","kind":13,"line":151},{"name":"$id","containerName":"set_ParentIDs_from_hierarchy","line":155,"kind":13},{"line":155,"kind":13,"containerName":"set_ParentIDs_from_hierarchy","name":"$sf"},{"containerName":"set_ParentIDs_from_hierarchy","name":"generate_unique_persistent_id","line":155,"kind":12},{"kind":13,"line":157,"name":"$subsf","definition":"my","containerName":"set_ParentIDs_from_hierarchy","localvar":"my"},{"name":"@subsfs","containerName":"set_ParentIDs_from_hierarchy","line":157,"kind":13},{"kind":13,"line":158,"name":"$subsf","containerName":"set_ParentIDs_from_hierarchy"},{"containerName":"set_ParentIDs_from_hierarchy","name":"add_tag_value","line":158,"kind":12},{"kind":13,"line":158,"containerName":"set_ParentIDs_from_hierarchy","name":"$id"},{"line":162,"kind":13,"name":"@sfs","containerName":"set_ParentIDs_from_hierarchy"},{"line":162,"kind":13,"containerName":"set_ParentIDs_from_hierarchy","name":"@subsfs"}],"containerName":"main::","definition":"sub","detail":"()","signature":{"label":"set_ParentIDs_from_hierarchy()","parameters":[],"documentation":"1;\n# $Id: IDHandler.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::SeqFeature::Tools::IDHandler\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Mungall <cjm@fruitfly.org>\n#\n# Copyright Chris Mungall\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Tools::IDHandler - maps $seq_feature-E<gt>primary_tag\n\n=head1 SYNOPSIS\n\n  use Bio::SeqIO;\n  use Bio::SeqFeature::Tools::IDHandler;\n\n\n=head1 DESCRIPTION\n\nClass to map $seq_feature-E<gt>primary_tag\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Mungall\n\nEmail:  cjm@fruitfly.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::SeqFeature::Tools::IDHandler;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : $unflattener = Bio::SeqFeature::Tools::IDHandler->new();\n Function: constructor\n Example : \n Returns : a new Bio::SeqFeature::Tools::IDHandler\n Args    : see below\n\n\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my($generate_id_sub) =\n\t$self->_rearrange([qw(GENERATE_ID_SUB\n\t\t\t     )],\n                          @args);\n\n    return $self; # success - we hope!\n}\n\n=head2 set_ParentIDs_from_hierarchy()\n\n Title   : set_ParentIDs_from_hierarchy()\n Usage   : $idhandler->set_ParentIDs_from_hierarchy($fholder)\n Function: populates tags Parent and ID via holder hierarchy\n Example :\n Returns : \n Args    : Bio::featureHolderI (either a SeqFeature or a Seq)\n\nThis is mainly for GFF3 export\n\nGFF3 uses the tags ID and Parent to represent the feature containment\nhierarchy; it does NOT use the feature holder tree\n\nThis method sets Parent (and ID for any parents not set) based on\nfeature holder/containement hierarchy, ready for GFF3 output\n\n method author: cjm@fruitfly.org"}},{"kind":12,"children":[{"line":180,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"create_hierarchy_from_ParentIDs"},{"line":180,"kind":13,"name":"$featholder","containerName":"create_hierarchy_from_ParentIDs"},{"kind":13,"line":180,"containerName":"create_hierarchy_from_ParentIDs","name":"@args"},{"kind":13,"line":182,"definition":"my","name":"@sfs","containerName":"create_hierarchy_from_ParentIDs","localvar":"my"},{"containerName":"create_hierarchy_from_ParentIDs","name":"$featholder","line":182,"kind":13},{"name":"get_all_SeqFeatures","containerName":"create_hierarchy_from_ParentIDs","kind":12,"line":182},{"line":183,"kind":13,"localvar":"my","containerName":"create_hierarchy_from_ParentIDs","name":"%sf_by_ID","definition":"my"},{"containerName":"create_hierarchy_from_ParentIDs","name":"@sfs","kind":13,"line":184},{"containerName":"create_hierarchy_from_ParentIDs","definition":"my","name":"$id","localvar":"my","kind":13,"line":185},{"name":"primary_id","containerName":"create_hierarchy_from_ParentIDs","kind":12,"line":185},{"containerName":"create_hierarchy_from_ParentIDs","name":"$id","line":186,"kind":13},{"line":187,"kind":13,"containerName":"create_hierarchy_from_ParentIDs","name":"$sf_by_ID"},{"line":187,"kind":13,"name":"$id","containerName":"create_hierarchy_from_ParentIDs"},{"name":"$featholder","containerName":"create_hierarchy_from_ParentIDs","kind":13,"line":188},{"kind":12,"line":188,"containerName":"create_hierarchy_from_ParentIDs","name":"throw"},{"name":"$sf_by_ID","containerName":"create_hierarchy_from_ParentIDs","kind":13,"line":190},{"name":"$id","containerName":"create_hierarchy_from_ParentIDs","line":190,"kind":13},{"containerName":"create_hierarchy_from_ParentIDs","name":"remove_SeqFeatures","line":191,"kind":12},{"name":"%sf_by_ID","containerName":"create_hierarchy_from_ParentIDs","kind":13,"line":193},{"localvar":"my","containerName":"create_hierarchy_from_ParentIDs","definition":"my","name":"@topsfs","line":200,"kind":13},{"localvar":"my","containerName":"create_hierarchy_from_ParentIDs","name":"@parents","definition":"my","line":202,"kind":13},{"containerName":"create_hierarchy_from_ParentIDs","name":"get_tagset_values","kind":12,"line":202},{"containerName":"create_hierarchy_from_ParentIDs","name":"$parent","definition":"my","localvar":"my","kind":13,"line":203},{"line":203,"kind":13,"name":"@parents","containerName":"create_hierarchy_from_ParentIDs"},{"kind":13,"line":204,"containerName":"create_hierarchy_from_ParentIDs","name":"$sf_by_ID"},{"line":204,"kind":13,"containerName":"create_hierarchy_from_ParentIDs","name":"$parent"},{"kind":12,"line":204,"containerName":"create_hierarchy_from_ParentIDs","name":"add_SeqFeature"},{"containerName":"create_hierarchy_from_ParentIDs","name":"$sf_by_ID","kind":13,"line":205},{"name":"$parent","containerName":"create_hierarchy_from_ParentIDs","kind":13,"line":205},{"line":207,"kind":13,"name":"@parents","containerName":"create_hierarchy_from_ParentIDs"},{"name":"@sfs","containerName":"create_hierarchy_from_ParentIDs","kind":13,"line":208},{"containerName":"create_hierarchy_from_ParentIDs","name":"$featholder","line":209,"kind":13},{"line":209,"kind":12,"name":"remove_SeqFeatures","containerName":"create_hierarchy_from_ParentIDs"},{"containerName":"create_hierarchy_from_ParentIDs","name":"$featholder","kind":13,"line":210},{"name":"add_SeqFeature","containerName":"create_hierarchy_from_ParentIDs","kind":12,"line":210},{"containerName":"create_hierarchy_from_ParentIDs","name":"@topsfs","kind":13,"line":210},{"kind":13,"line":211,"containerName":"create_hierarchy_from_ParentIDs","name":"@topsfs"}],"line":179,"definition":"sub","containerName":"main::","signature":{"label":"create_hierarchy_from_ParentIDs($self,$featholder,@args)","documentation":"1;\n# $Id: IDHandler.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::SeqFeature::Tools::IDHandler\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Mungall <cjm@fruitfly.org>\n#\n# Copyright Chris Mungall\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Tools::IDHandler - maps $seq_feature-E<gt>primary_tag\n\n=head1 SYNOPSIS\n\n  use Bio::SeqIO;\n  use Bio::SeqFeature::Tools::IDHandler;\n\n\n=head1 DESCRIPTION\n\nClass to map $seq_feature-E<gt>primary_tag\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Mungall\n\nEmail:  cjm@fruitfly.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::SeqFeature::Tools::IDHandler;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : $unflattener = Bio::SeqFeature::Tools::IDHandler->new();\n Function: constructor\n Example : \n Returns : a new Bio::SeqFeature::Tools::IDHandler\n Args    : see below\n\n\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my($generate_id_sub) =\n\t$self->_rearrange([qw(GENERATE_ID_SUB\n\t\t\t     )],\n                          @args);\n\n    return $self; # success - we hope!\n}\n\n=head2 set_ParentIDs_from_hierarchy()\n\n Title   : set_ParentIDs_from_hierarchy()\n Usage   : $idhandler->set_ParentIDs_from_hierarchy($fholder)\n Function: populates tags Parent and ID via holder hierarchy\n Example :\n Returns : \n Args    : Bio::featureHolderI (either a SeqFeature or a Seq)\n\nThis is mainly for GFF3 export\n\nGFF3 uses the tags ID and Parent to represent the feature containment\nhierarchy; it does NOT use the feature holder tree\n\nThis method sets Parent (and ID for any parents not set) based on\nfeature holder/containement hierarchy, ready for GFF3 output\n\n\n# method author: cjm@fruitfly.org\nsub set_ParentIDs_from_hierarchy(){\n   my $self = shift;\n   my ($featholder) = @_;\n\n   # we will traverse the tree of contained seqfeatures\n   # (a seqfeature is itself a holder)\n\n   # start with the top-level features\n   my @sfs = $featholder->get_SeqFeatures;\n\n   # clear existing parent tags\n   # (we assume this is the desired behaviour)\n   my @all_sfs = $featholder->get_all_SeqFeatures;\n   foreach (@all_sfs) {\n       if ($_->has_tag('Parent')) {\n           $_->remove_tag('Parent');\n       }\n   }\n   \n\n   # iterate until entire tree traversed\n   while (@sfs) {\n       my $sf = shift @sfs;\n       my @subsfs = $sf->get_SeqFeatures;\n\n       # see if the ID tag \n       my $id = $sf->primary_id;\n       if (!$id) {\n           # the skolem function feature(seq,start,end,type)\n           # is presumed to uniquely identify this feature, and\n           # to also be persistent\n           $id = $sf->generate_unique_persistent_id;\n       }\n       foreach my $subsf (@subsfs) {\n           $subsf->add_tag_value('Parent', $id);\n       }\n       \n       # push children on to end of stack (breadth first search)\n       push(@sfs, @subsfs);\n   }\n   return;\n}\n\n=head2 create_hierarchy_from_ParentIDs\n\n Title   : create_hierarchy_from_ParentIDs\n Usage   : $idhandler->set_ParentIDs_from_hierarchy($fholder)\n Function: inverse of set_ParentIDs_from_hierarchy\n Example :\n Returns : list of top SeqFeatures\n Args    :","parameters":[{"label":"$self"},{"label":"$featholder"},{"label":"@args"}]},"detail":"($self,$featholder,@args)","name":"create_hierarchy_from_ParentIDs","range":{"end":{"character":9999,"line":212},"start":{"line":179,"character":0}}},{"detail":"($self,$sf,@args)","signature":{"documentation":"1;\n# $Id: IDHandler.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::SeqFeature::Tools::IDHandler\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Mungall <cjm@fruitfly.org>\n#\n# Copyright Chris Mungall\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Tools::IDHandler - maps $seq_feature-E<gt>primary_tag\n\n=head1 SYNOPSIS\n\n  use Bio::SeqIO;\n  use Bio::SeqFeature::Tools::IDHandler;\n\n\n=head1 DESCRIPTION\n\nClass to map $seq_feature-E<gt>primary_tag\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Mungall\n\nEmail:  cjm@fruitfly.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::SeqFeature::Tools::IDHandler;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : $unflattener = Bio::SeqFeature::Tools::IDHandler->new();\n Function: constructor\n Example : \n Returns : a new Bio::SeqFeature::Tools::IDHandler\n Args    : see below\n\n\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my($generate_id_sub) =\n\t$self->_rearrange([qw(GENERATE_ID_SUB\n\t\t\t     )],\n                          @args);\n\n    return $self; # success - we hope!\n}\n\n=head2 set_ParentIDs_from_hierarchy()\n\n Title   : set_ParentIDs_from_hierarchy()\n Usage   : $idhandler->set_ParentIDs_from_hierarchy($fholder)\n Function: populates tags Parent and ID via holder hierarchy\n Example :\n Returns : \n Args    : Bio::featureHolderI (either a SeqFeature or a Seq)\n\nThis is mainly for GFF3 export\n\nGFF3 uses the tags ID and Parent to represent the feature containment\nhierarchy; it does NOT use the feature holder tree\n\nThis method sets Parent (and ID for any parents not set) based on\nfeature holder/containement hierarchy, ready for GFF3 output\n\n\n# method author: cjm@fruitfly.org\nsub set_ParentIDs_from_hierarchy(){\n   my $self = shift;\n   my ($featholder) = @_;\n\n   # we will traverse the tree of contained seqfeatures\n   # (a seqfeature is itself a holder)\n\n   # start with the top-level features\n   my @sfs = $featholder->get_SeqFeatures;\n\n   # clear existing parent tags\n   # (we assume this is the desired behaviour)\n   my @all_sfs = $featholder->get_all_SeqFeatures;\n   foreach (@all_sfs) {\n       if ($_->has_tag('Parent')) {\n           $_->remove_tag('Parent');\n       }\n   }\n   \n\n   # iterate until entire tree traversed\n   while (@sfs) {\n       my $sf = shift @sfs;\n       my @subsfs = $sf->get_SeqFeatures;\n\n       # see if the ID tag \n       my $id = $sf->primary_id;\n       if (!$id) {\n           # the skolem function feature(seq,start,end,type)\n           # is presumed to uniquely identify this feature, and\n           # to also be persistent\n           $id = $sf->generate_unique_persistent_id;\n       }\n       foreach my $subsf (@subsfs) {\n           $subsf->add_tag_value('Parent', $id);\n       }\n       \n       # push children on to end of stack (breadth first search)\n       push(@sfs, @subsfs);\n   }\n   return;\n}\n\n=head2 create_hierarchy_from_ParentIDs\n\n Title   : create_hierarchy_from_ParentIDs\n Usage   : $idhandler->set_ParentIDs_from_hierarchy($fholder)\n Function: inverse of set_ParentIDs_from_hierarchy\n Example :\n Returns : list of top SeqFeatures\n Args    :\n\n\n\nsub create_hierarchy_from_ParentIDs{\n   my ($self,$featholder,@args) = @_;\n\n   my @sfs = $featholder->get_all_SeqFeatures;\n   my %sf_by_ID = ();\n   foreach (@sfs) {\n       my $id = $_->primary_id;\n       next unless $id;\n       if ($sf_by_ID{$id}) {\n           $featholder->throw(\"DUPLICATE ID: $id\");\n       }\n       $sf_by_ID{$id} = $_;\n       $_->remove_SeqFeatures; # clear existing hierarchy (assume this is desired)\n   }\n   if (!%sf_by_ID) {\n       # warn??\n       # this is actually expected behaviour for some kinds of data;\n       # eg lists of STSs - no containment hierarchy\n       return;\n   }\n\n   my @topsfs = \n     grep {\n         my @parents = $_->get_tagset_values('Parent');\n         foreach my $parent (@parents) {\n             $sf_by_ID{$parent}->add_SeqFeature($_)\n\t\t if exists $sf_by_ID{$parent};\n         }\n         !@parents;\n     } @sfs;\n   $featholder->remove_SeqFeatures;\n   $featholder->add_SeqFeature($_) foreach @topsfs;\n   return @topsfs;\n}\n\n\n=head2 generate_unique_persistent_id\n\n Title   : generate_unique_persistent_id\n Usage   :\n Function: generates a unique and persistent identifier for this\n Example :\n Returns : value of primary_id (a scalar)\n Args    :\n\nWill generate an ID, B<and> set primary_id() (see above)\n\nThe ID is a string generated from \n\n  seq_id\n  primary_tag\n  start\n  end\n\nThere are three underlying assumptions: that all the above accessors\nare set; that seq_id is a persistent and unique identifier for the\nsequence containing this feature; and that \n\n  (seq_id, primary_tag, start, end) \n\nis a \"unique constraint\" over features\n\nThe ID is persistent, so long as none of these values change - if they\ndo, it is considered a seperate entity\n\n method author: cjm@fruitfly.org","parameters":[{"label":"$self"},{"label":"$sf"},{"label":"@args"}],"label":"generate_unique_persistent_id($self,$sf,@args)"},"containerName":"main::","definition":"sub","line":247,"children":[{"kind":13,"line":248,"name":"$self","definition":"my","containerName":"generate_unique_persistent_id","localvar":"my"},{"line":248,"kind":13,"containerName":"generate_unique_persistent_id","name":"$sf"},{"line":248,"kind":13,"containerName":"generate_unique_persistent_id","name":"@args"},{"kind":13,"line":250,"containerName":"generate_unique_persistent_id","definition":"my","name":"$id","localvar":"my"},{"line":251,"kind":13,"containerName":"generate_unique_persistent_id","name":"$sf"},{"line":251,"kind":12,"containerName":"generate_unique_persistent_id","name":"isa"},{"containerName":"generate_unique_persistent_id","name":"$sf","line":252,"kind":13},{"containerName":"generate_unique_persistent_id","name":"throw","line":252,"kind":12},{"localvar":"my","definition":"my","name":"$seq_id","containerName":"generate_unique_persistent_id","line":254,"kind":13},{"line":254,"kind":13,"containerName":"generate_unique_persistent_id","name":"$sf"},{"name":"seq_id","containerName":"generate_unique_persistent_id","kind":12,"line":254},{"containerName":"generate_unique_persistent_id","name":"$sf","kind":13,"line":254},{"line":254,"kind":12,"containerName":"generate_unique_persistent_id","name":"throw"},{"line":256,"kind":13,"containerName":"generate_unique_persistent_id","name":"$sf"},{"name":"has_tag","containerName":"generate_unique_persistent_id","line":256,"kind":12},{"line":257,"kind":13,"name":"$id","containerName":"generate_unique_persistent_id"},{"containerName":"generate_unique_persistent_id","name":"$sf","kind":13,"line":257},{"line":257,"kind":12,"name":"get_tag_values","containerName":"generate_unique_persistent_id"},{"containerName":"generate_unique_persistent_id","name":"$sf","line":259,"kind":13},{"name":"has_tag","containerName":"generate_unique_persistent_id","kind":12,"line":259},{"containerName":"generate_unique_persistent_id","name":"$id","kind":13,"line":260},{"containerName":"generate_unique_persistent_id","name":"$sf","kind":13,"line":260},{"containerName":"generate_unique_persistent_id","name":"get_tag_values","line":260,"kind":12},{"localvar":"my","name":"$source","definition":"my","containerName":"generate_unique_persistent_id","line":263,"kind":13},{"kind":13,"line":263,"containerName":"generate_unique_persistent_id","name":"$sf"},{"kind":12,"line":263,"name":"source_tag","containerName":"generate_unique_persistent_id"},{"kind":13,"line":263,"containerName":"generate_unique_persistent_id","name":"$sf"},{"kind":12,"line":263,"containerName":"generate_unique_persistent_id","name":"throw"},{"line":265,"kind":13,"localvar":"my","containerName":"generate_unique_persistent_id","name":"$start","definition":"my"},{"containerName":"generate_unique_persistent_id","name":"$sf","line":265,"kind":13},{"line":265,"kind":12,"containerName":"generate_unique_persistent_id","name":"start"},{"name":"$sf","containerName":"generate_unique_persistent_id","kind":13,"line":265},{"containerName":"generate_unique_persistent_id","name":"throw","line":265,"kind":12},{"definition":"my","name":"$end","containerName":"generate_unique_persistent_id","localvar":"my","kind":13,"line":266},{"name":"$sf","containerName":"generate_unique_persistent_id","kind":13,"line":266},{"kind":12,"line":266,"name":"end","containerName":"generate_unique_persistent_id"},{"containerName":"generate_unique_persistent_id","name":"$sf","kind":13,"line":266},{"containerName":"generate_unique_persistent_id","name":"throw","line":266,"kind":12},{"localvar":"my","name":"$type","definition":"my","containerName":"generate_unique_persistent_id","line":267,"kind":13},{"containerName":"generate_unique_persistent_id","name":"$sf","line":267,"kind":13},{"containerName":"generate_unique_persistent_id","name":"primary_tag","line":267,"kind":12},{"name":"$sf","containerName":"generate_unique_persistent_id","kind":13,"line":267},{"kind":12,"line":267,"name":"throw","containerName":"generate_unique_persistent_id"},{"line":269,"kind":13,"containerName":"generate_unique_persistent_id","name":"$id"},{"containerName":"generate_unique_persistent_id","name":"$sf","line":271,"kind":13},{"containerName":"generate_unique_persistent_id","name":"primary_id","kind":12,"line":271},{"kind":13,"line":271,"containerName":"generate_unique_persistent_id","name":"$id"},{"containerName":"generate_unique_persistent_id","name":"$id","line":272,"kind":13}],"kind":12,"range":{"end":{"line":273,"character":9999},"start":{"line":247,"character":0}},"name":"generate_unique_persistent_id"}],"version":5}