{"version":5,"vars":[{"kind":2,"line":91,"containerName":"","name":"vars"},{"kind":2,"line":97,"name":"base","containerName":""},{"line":120,"children":[{"line":121,"kind":13,"localvar":"my","name":"$class","definition":"my","containerName":"new"},{"kind":13,"line":121,"containerName":"new","name":"@args"},{"localvar":"my","containerName":"new","definition":"my","name":"$self","line":140,"kind":13},{"name":"$class","containerName":"new","line":140,"kind":13},{"kind":13,"line":141,"containerName":"new","name":"$feature1","definition":"my","localvar":"my"},{"kind":13,"line":141,"containerName":"new","name":"$feature2"},{"containerName":"new","name":"$featfact","kind":13,"line":141},{"line":142,"kind":13,"containerName":"new","name":"$self"},{"line":142,"kind":12,"name":"_rearrange","containerName":"new"},{"kind":13,"line":145,"name":"@args","containerName":"new"},{"name":"$self","containerName":"new","line":147,"kind":13},{"containerName":"new","name":"_register_for_cleanup","kind":12,"line":147},{"kind":13,"line":149,"name":"$featfact","containerName":"new"},{"containerName":"new","name":"$featfact","kind":13,"line":150},{"containerName":"new","name":"new","kind":12,"line":150},{"containerName":"new","name":"$self","line":154,"kind":13},{"kind":12,"line":154,"containerName":"new","name":"feature_factory"},{"containerName":"new","name":"$featfact","kind":13,"line":154},{"line":156,"kind":13,"containerName":"new","name":"$feature1"},{"kind":13,"line":156,"name":"$self","containerName":"new"},{"containerName":"new","name":"feature1","kind":12,"line":156},{"line":156,"kind":13,"containerName":"new","name":"$feature1"},{"line":157,"kind":13,"name":"$feature2","containerName":"new"},{"line":157,"kind":13,"containerName":"new","name":"$self"},{"kind":12,"line":157,"name":"feature2","containerName":"new"},{"name":"$feature2","containerName":"new","kind":13,"line":157},{"line":161,"kind":13,"containerName":"new","name":"$self"},{"line":161,"kind":12,"containerName":"new","name":"set_attributes"},{"name":"@args","containerName":"new","line":161,"kind":13},{"name":"$self","containerName":"new","line":164,"kind":13}],"kind":12,"detail":"($class,@args)","signature":{"documentation":"1;\n# $Id: FeaturePair.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::FeaturePair\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@sanger.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::FeaturePair - hold pair feature information e.g. blast hits\n\n=head1 SYNOPSIS\n\n    my $feat  = Bio::SeqFeature::FeaturePair->new(-feature1 => $f1,\n\t\t\t\t\t\t -feature2 => $f2,\n\t\t\t\t\t      );\n\n    # Bio::SeqFeatureI methods can be used\n\n    my $start = $feat->start;\n    my $end   = $feat->end;\n\n    # Bio::FeaturePair methods can be used\n    my $hstart = $feat->hstart;\n    my $hend   = $feat->hend;\n\n   my $feature1 = $feat->feature1;  # returns feature1 object\n\n=head1 DESCRIPTION\n\nA sequence feature object where the feature is itself a feature on\nanother sequence - e.g. a blast hit where residues 1-40 of a protein\nsequence SW:HBA_HUMAN has hit to bases 100 - 220 on a genomic sequence\nHS120G22.  The genomic sequence coordinates are used to create one\nsequence feature $f1 and the protein coordinates are used to create\nfeature $f2.  A FeaturePair object can then be made\n\n    my $fp = Bio::SeqFeature::FeaturePair->new(-feature1 => $f1,   # genomic\n\t\t\t\t\t      -feature2 => $f2,   # protein\n\t\t\t\t\t      );\n\nThis object can be used as a standard Bio::SeqFeatureI in which case\n\n    my $gstart = $fp->start  # returns start coord on feature1 - genomic seq.\n    my $gend   = $fp->end    # returns end coord on feature1.\n\nIn general standard Bio::SeqFeatureI method calls return information\nin feature1.\n\nData in the feature 2 object are generally obtained using the standard\nmethods prefixed by h (for hit!)\n\n    my $pstart = $fp->hstart # returns start coord on feature2 = protein seq.\n    my $pend   = $fp->hend   # returns end coord on feature2.\n\nIf you wish to swap feature1 and feature2 around :\n\n    $feat->invert\n\nso... \n\n    $feat->start # etc. returns data in $feature2 object\n\n\nNo sub_SeqFeatures or tags can be stored in this object directly.  Any\nfeatures or tags are expected to be stored in the contained objects\nfeature1, and feature2.\n\n=head1 CONTACT\n\nEwan Birney E<lt>birney@sanger.ac.ukE<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::FeaturePair;\nuse vars qw($AUTOLOAD);\nuse strict;\n\nuse Bio::SeqFeatureI;\nuse Bio::Factory::ObjectFactory;\n\nuse base qw(Bio::SeqFeature::Generic);\n\n=head2 new\n\n Title   : new\n Usage   :\n Function: Constructor for this module. Accepts the following parameters:\n\n             -feature1   Bio::SeqFeatureI-compliant object\n             -feature2   Bio::SeqFeatureI-compliant object\n             -feature_factory  Bio::Factory::ObjectFactoryI compliant\n                         object to be used when feature1 and/or feature2\n                         are accessed without explicitly set before. This\n                         is mostly useful for derived classes who want to\n                         set their preferred class for feature objects.\n\n Example :\n Returns : \n Args    : see above","parameters":[{"label":"$class"},{"label":"@args"}],"label":"new($class,@args)"},"containerName":"main::","definition":"sub","range":{"start":{"character":0,"line":120},"end":{"character":9999,"line":165}},"name":"new"},{"kind":12,"line":140,"containerName":"new","name":"SUPER"},{"kind":12,"line":147,"name":"cleanup_fp"},{"line":150,"kind":12,"containerName":"Factory::ObjectFactory","name":"Bio"},{"containerName":"main::","definition":"sub","detail":"($self,$arg)","signature":{"parameters":[{"label":"$self"},{"label":"$arg"}],"documentation":"1;\n# $Id: FeaturePair.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::FeaturePair\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@sanger.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::FeaturePair - hold pair feature information e.g. blast hits\n\n=head1 SYNOPSIS\n\n    my $feat  = Bio::SeqFeature::FeaturePair->new(-feature1 => $f1,\n\t\t\t\t\t\t -feature2 => $f2,\n\t\t\t\t\t      );\n\n    # Bio::SeqFeatureI methods can be used\n\n    my $start = $feat->start;\n    my $end   = $feat->end;\n\n    # Bio::FeaturePair methods can be used\n    my $hstart = $feat->hstart;\n    my $hend   = $feat->hend;\n\n   my $feature1 = $feat->feature1;  # returns feature1 object\n\n=head1 DESCRIPTION\n\nA sequence feature object where the feature is itself a feature on\nanother sequence - e.g. a blast hit where residues 1-40 of a protein\nsequence SW:HBA_HUMAN has hit to bases 100 - 220 on a genomic sequence\nHS120G22.  The genomic sequence coordinates are used to create one\nsequence feature $f1 and the protein coordinates are used to create\nfeature $f2.  A FeaturePair object can then be made\n\n    my $fp = Bio::SeqFeature::FeaturePair->new(-feature1 => $f1,   # genomic\n\t\t\t\t\t      -feature2 => $f2,   # protein\n\t\t\t\t\t      );\n\nThis object can be used as a standard Bio::SeqFeatureI in which case\n\n    my $gstart = $fp->start  # returns start coord on feature1 - genomic seq.\n    my $gend   = $fp->end    # returns end coord on feature1.\n\nIn general standard Bio::SeqFeatureI method calls return information\nin feature1.\n\nData in the feature 2 object are generally obtained using the standard\nmethods prefixed by h (for hit!)\n\n    my $pstart = $fp->hstart # returns start coord on feature2 = protein seq.\n    my $pend   = $fp->hend   # returns end coord on feature2.\n\nIf you wish to swap feature1 and feature2 around :\n\n    $feat->invert\n\nso... \n\n    $feat->start # etc. returns data in $feature2 object\n\n\nNo sub_SeqFeatures or tags can be stored in this object directly.  Any\nfeatures or tags are expected to be stored in the contained objects\nfeature1, and feature2.\n\n=head1 CONTACT\n\nEwan Birney E<lt>birney@sanger.ac.ukE<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::FeaturePair;\nuse vars qw($AUTOLOAD);\nuse strict;\n\nuse Bio::SeqFeatureI;\nuse Bio::Factory::ObjectFactory;\n\nuse base qw(Bio::SeqFeature::Generic);\n\n=head2 new\n\n Title   : new\n Usage   :\n Function: Constructor for this module. Accepts the following parameters:\n\n             -feature1   Bio::SeqFeatureI-compliant object\n             -feature2   Bio::SeqFeatureI-compliant object\n             -feature_factory  Bio::Factory::ObjectFactoryI compliant\n                         object to be used when feature1 and/or feature2\n                         are accessed without explicitly set before. This\n                         is mostly useful for derived classes who want to\n                         set their preferred class for feature objects.\n\n Example :\n Returns : \n Args    : see above\n\n\n\nsub new {\n    my ($class, @args) = @_;\n\n    #\n    # We've got a certain problem here that somewhat relates to chicken and\n    # eggs. The problem is, we override a lot of SeqFeatureI methods here\n    # to delegate them to either feature1 or feature2. If we pass along\n    # those attributes right away, we need feature1 or feature2 or the feature\n    # factory in place, or there is no way around the dreaded default, which\n    # is ugly too (as it necessitates subsequent copying if you wanted a\n    # different feature object class).\n    #\n    # So I decided to go with the lesser of two evils here: we need to assume\n    # here that we can set all attributes through set_attributes(), which we\n    # assume is no different from setting them through the constructor. This\n    # gives us a window to set the feature objects and the factory, such that\n    # any derived class doesn't have to worry about this any more.\n    #\n    # I'm happy to hear a better solution, but I think this one isn't so bad.\n    #\n    my $self = $class->SUPER::new();\n    my ($feature1,$feature2,$featfact) = \n\t$self->_rearrange([qw(FEATURE1\n\t\t\t      FEATURE2\n\t\t\t      FEATURE_FACTORY\n\t\t\t      )],@args);\n    \n    $self->_register_for_cleanup(\\&cleanup_fp);\n    # initialize the feature object factory if not provided\n    if(! $featfact) {\n\t$featfact = Bio::Factory::ObjectFactory->new(\n\t\t\t\t   -type => \"Bio::SeqFeature::Generic\",\n\t\t\t\t   -interface => \"Bio::SeqFeatureI\");\n    }\n    $self->feature_factory($featfact);\n    # Store the features in the object\n    $feature1 && $self->feature1($feature1);\n    $feature2 && $self->feature2($feature2);\n    \n    # OK. Now we're setup to store all the attributes, and they'll go right\n    # away into the right objects.\n    $self->set_attributes(@args);\n\n    # done - we hope\n    return $self;\n}\n\n=head2 feature1\n\n Title   : feature1\n Usage   : $f = $featpair->feature1\n           $featpair->feature1($feature)\n Function: Get/set for the query feature\n Returns : Bio::SeqFeatureI\n Args    : Bio::SeqFeatureI","label":"feature1($self,$arg)"},"kind":12,"line":179,"children":[{"kind":13,"line":180,"containerName":"feature1","name":"$self","definition":"my","localvar":"my"},{"name":"$arg","containerName":"feature1","line":180,"kind":13},{"name":"$arg","containerName":"feature1","line":181,"kind":13},{"kind":13,"line":181,"containerName":"feature1","name":"$self"},{"kind":13,"line":182,"containerName":"feature1","name":"$self"},{"line":182,"kind":12,"containerName":"feature1","name":"throw"},{"containerName":"feature1","name":"$self","line":183,"kind":13},{"name":"feature_factory","containerName":"feature1","kind":12,"line":183},{"containerName":"feature1","name":"$arg","line":184,"kind":13},{"name":"$self","containerName":"feature1","line":184,"kind":13},{"name":"feature_factory","containerName":"feature1","kind":12,"line":184},{"kind":12,"line":184,"name":"create_object","containerName":"feature1"},{"name":"$arg","containerName":"feature1","kind":13,"line":184},{"name":"$self","containerName":"feature1","kind":13,"line":185},{"containerName":"feature1","name":"throw","line":185,"kind":12},{"kind":13,"line":186,"containerName":"feature1","name":"$arg"},{"kind":13,"line":186,"name":"$arg","containerName":"feature1"},{"name":"isa","containerName":"feature1","line":186,"kind":12},{"kind":13,"line":187,"name":"$self","containerName":"feature1"},{"name":"$arg","containerName":"feature1","line":187,"kind":13},{"containerName":"feature1","name":"$self","line":189,"kind":13}],"name":"feature1","range":{"end":{"character":9999,"line":190},"start":{"character":0,"line":179}}},{"kind":12,"children":[{"localvar":"my","containerName":"feature2","name":"$self","definition":"my","line":205,"kind":13},{"name":"$arg","containerName":"feature2","line":205,"kind":13},{"name":"$arg","containerName":"feature2","line":207,"kind":13},{"name":"$self","containerName":"feature2","line":207,"kind":13},{"kind":13,"line":208,"containerName":"feature2","name":"$self"},{"containerName":"feature2","name":"throw","kind":12,"line":208},{"containerName":"feature2","name":"$self","kind":13,"line":209},{"containerName":"feature2","name":"feature_factory","line":209,"kind":12},{"containerName":"feature2","name":"$arg","line":210,"kind":13},{"kind":13,"line":210,"name":"$self","containerName":"feature2"},{"line":210,"kind":12,"containerName":"feature2","name":"feature_factory"},{"kind":12,"line":210,"name":"create_object","containerName":"feature2"},{"kind":13,"line":210,"name":"$arg","containerName":"feature2"},{"name":"$self","containerName":"feature2","line":211,"kind":13},{"line":211,"kind":12,"name":"throw","containerName":"feature2"},{"line":212,"kind":13,"containerName":"feature2","name":"$arg"},{"containerName":"feature2","name":"$arg","kind":13,"line":212},{"kind":12,"line":212,"containerName":"feature2","name":"isa"},{"name":"$self","containerName":"feature2","line":213,"kind":13},{"kind":13,"line":213,"containerName":"feature2","name":"$arg"},{"kind":13,"line":215,"containerName":"feature2","name":"$self"}],"line":204,"definition":"sub","containerName":"main::","signature":{"label":"feature2($self,$arg)","documentation":"1;\n# $Id: FeaturePair.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::FeaturePair\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@sanger.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::FeaturePair - hold pair feature information e.g. blast hits\n\n=head1 SYNOPSIS\n\n    my $feat  = Bio::SeqFeature::FeaturePair->new(-feature1 => $f1,\n\t\t\t\t\t\t -feature2 => $f2,\n\t\t\t\t\t      );\n\n    # Bio::SeqFeatureI methods can be used\n\n    my $start = $feat->start;\n    my $end   = $feat->end;\n\n    # Bio::FeaturePair methods can be used\n    my $hstart = $feat->hstart;\n    my $hend   = $feat->hend;\n\n   my $feature1 = $feat->feature1;  # returns feature1 object\n\n=head1 DESCRIPTION\n\nA sequence feature object where the feature is itself a feature on\nanother sequence - e.g. a blast hit where residues 1-40 of a protein\nsequence SW:HBA_HUMAN has hit to bases 100 - 220 on a genomic sequence\nHS120G22.  The genomic sequence coordinates are used to create one\nsequence feature $f1 and the protein coordinates are used to create\nfeature $f2.  A FeaturePair object can then be made\n\n    my $fp = Bio::SeqFeature::FeaturePair->new(-feature1 => $f1,   # genomic\n\t\t\t\t\t      -feature2 => $f2,   # protein\n\t\t\t\t\t      );\n\nThis object can be used as a standard Bio::SeqFeatureI in which case\n\n    my $gstart = $fp->start  # returns start coord on feature1 - genomic seq.\n    my $gend   = $fp->end    # returns end coord on feature1.\n\nIn general standard Bio::SeqFeatureI method calls return information\nin feature1.\n\nData in the feature 2 object are generally obtained using the standard\nmethods prefixed by h (for hit!)\n\n    my $pstart = $fp->hstart # returns start coord on feature2 = protein seq.\n    my $pend   = $fp->hend   # returns end coord on feature2.\n\nIf you wish to swap feature1 and feature2 around :\n\n    $feat->invert\n\nso... \n\n    $feat->start # etc. returns data in $feature2 object\n\n\nNo sub_SeqFeatures or tags can be stored in this object directly.  Any\nfeatures or tags are expected to be stored in the contained objects\nfeature1, and feature2.\n\n=head1 CONTACT\n\nEwan Birney E<lt>birney@sanger.ac.ukE<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::FeaturePair;\nuse vars qw($AUTOLOAD);\nuse strict;\n\nuse Bio::SeqFeatureI;\nuse Bio::Factory::ObjectFactory;\n\nuse base qw(Bio::SeqFeature::Generic);\n\n=head2 new\n\n Title   : new\n Usage   :\n Function: Constructor for this module. Accepts the following parameters:\n\n             -feature1   Bio::SeqFeatureI-compliant object\n             -feature2   Bio::SeqFeatureI-compliant object\n             -feature_factory  Bio::Factory::ObjectFactoryI compliant\n                         object to be used when feature1 and/or feature2\n                         are accessed without explicitly set before. This\n                         is mostly useful for derived classes who want to\n                         set their preferred class for feature objects.\n\n Example :\n Returns : \n Args    : see above\n\n\n\nsub new {\n    my ($class, @args) = @_;\n\n    #\n    # We've got a certain problem here that somewhat relates to chicken and\n    # eggs. The problem is, we override a lot of SeqFeatureI methods here\n    # to delegate them to either feature1 or feature2. If we pass along\n    # those attributes right away, we need feature1 or feature2 or the feature\n    # factory in place, or there is no way around the dreaded default, which\n    # is ugly too (as it necessitates subsequent copying if you wanted a\n    # different feature object class).\n    #\n    # So I decided to go with the lesser of two evils here: we need to assume\n    # here that we can set all attributes through set_attributes(), which we\n    # assume is no different from setting them through the constructor. This\n    # gives us a window to set the feature objects and the factory, such that\n    # any derived class doesn't have to worry about this any more.\n    #\n    # I'm happy to hear a better solution, but I think this one isn't so bad.\n    #\n    my $self = $class->SUPER::new();\n    my ($feature1,$feature2,$featfact) = \n\t$self->_rearrange([qw(FEATURE1\n\t\t\t      FEATURE2\n\t\t\t      FEATURE_FACTORY\n\t\t\t      )],@args);\n    \n    $self->_register_for_cleanup(\\&cleanup_fp);\n    # initialize the feature object factory if not provided\n    if(! $featfact) {\n\t$featfact = Bio::Factory::ObjectFactory->new(\n\t\t\t\t   -type => \"Bio::SeqFeature::Generic\",\n\t\t\t\t   -interface => \"Bio::SeqFeatureI\");\n    }\n    $self->feature_factory($featfact);\n    # Store the features in the object\n    $feature1 && $self->feature1($feature1);\n    $feature2 && $self->feature2($feature2);\n    \n    # OK. Now we're setup to store all the attributes, and they'll go right\n    # away into the right objects.\n    $self->set_attributes(@args);\n\n    # done - we hope\n    return $self;\n}\n\n=head2 feature1\n\n Title   : feature1\n Usage   : $f = $featpair->feature1\n           $featpair->feature1($feature)\n Function: Get/set for the query feature\n Returns : Bio::SeqFeatureI\n Args    : Bio::SeqFeatureI\n\n\n\nsub feature1 {\n    my ($self,$arg) = @_;    \n    if ( defined($arg) || !defined $self->{'feature1'} ) {\n\t$self->throw(\"internal error: feature factory not set!\") \n\t    unless $self->feature_factory;\n\t$arg = $self->feature_factory->create_object() unless( defined $arg);\n\t$self->throw(\"Argument [$arg] must be a Bio::SeqFeatureI\") \n\t    unless (ref($arg) && $arg->isa(\"Bio::SeqFeatureI\"));\n\t$self->{'feature1'} = $arg;\n    }\n    return $self->{'feature1'};\n}\n\n=head2 feature2\n\n Title   : feature2\n Usage   : $f = $featpair->feature2\n           $featpair->feature2($feature)\n Function: Get/set for the hit feature\n Returns : Bio::SeqFeatureI\n Args    : Bio::SeqFeatureI","parameters":[{"label":"$self"},{"label":"$arg"}]},"detail":"($self,$arg)","name":"feature2","range":{"start":{"line":204,"character":0},"end":{"character":9999,"line":216}}},{"containerName":"main::","name":"start","definition":"sub","range":{"end":{"line":231,"character":9999},"start":{"line":229,"character":0}},"kind":12,"line":229,"children":[{"line":230,"kind":12,"name":"feature1","containerName":"start"},{"containerName":"start","name":"start","line":230,"kind":12}]},{"range":{"start":{"line":245,"character":0},"end":{"character":9999,"line":247}},"name":"end","definition":"sub","containerName":"main::","children":[{"containerName":"end","name":"feature1","kind":12,"line":246},{"name":"end","containerName":"end","line":246,"kind":12}],"line":245,"kind":12},{"line":261,"children":[{"name":"feature1","containerName":"strand","kind":12,"line":262},{"line":262,"kind":12,"name":"strand","containerName":"strand"}],"kind":12,"range":{"end":{"character":9999,"line":263},"start":{"character":0,"line":261}},"containerName":"main::","name":"strand","definition":"sub"},{"kind":12,"line":276,"children":[{"name":"feature1","containerName":"location","line":277,"kind":12},{"line":277,"kind":12,"name":"location","containerName":"location"}],"containerName":"main::","name":"location","definition":"sub","range":{"end":{"character":9999,"line":278},"start":{"character":0,"line":276}}},{"line":292,"children":[{"kind":12,"line":293,"containerName":"score","name":"feature1"},{"name":"score","containerName":"score","line":293,"kind":12}],"kind":12,"range":{"end":{"line":294,"character":9999},"start":{"character":0,"line":292}},"containerName":"main::","definition":"sub","name":"score"},{"definition":"sub","name":"frame","containerName":"main::","range":{"start":{"line":308,"character":0},"end":{"line":310,"character":9999}},"kind":12,"children":[{"line":309,"kind":12,"containerName":"frame","name":"feature1"},{"line":309,"kind":12,"containerName":"frame","name":"frame"}],"line":308},{"range":{"end":{"line":325,"character":9999},"start":{"line":323,"character":0}},"containerName":"main::","definition":"sub","name":"primary_tag","line":323,"children":[{"kind":12,"line":324,"containerName":"primary_tag","name":"feature1"},{"name":"primary_tag","containerName":"primary_tag","kind":12,"line":324}],"kind":12},{"range":{"start":{"line":340,"character":0},"end":{"line":342,"character":9999}},"definition":"sub","name":"source_tag","containerName":"main::","children":[{"containerName":"source_tag","name":"feature1","line":341,"kind":12},{"kind":12,"line":341,"containerName":"source_tag","name":"source_tag"}],"line":340,"kind":12},{"children":[{"line":363,"kind":12,"containerName":"seq_id","name":"feature1"},{"name":"seq_id","containerName":"seq_id","line":363,"kind":12}],"line":362,"kind":12,"range":{"end":{"character":9999,"line":364},"start":{"character":0,"line":362}},"name":"seq_id","definition":"sub","containerName":"main::"},{"name":"hseq_id","definition":"sub","containerName":"main::","range":{"end":{"line":380,"character":9999},"start":{"character":0,"line":378}},"kind":12,"children":[{"name":"feature2","containerName":"hseq_id","line":379,"kind":12},{"line":379,"kind":12,"containerName":"hseq_id","name":"seq_id"}],"line":378},{"line":394,"children":[{"containerName":"hstart","name":"feature2","kind":12,"line":395},{"kind":12,"line":395,"name":"start","containerName":"hstart"}],"kind":12,"range":{"start":{"line":394,"character":0},"end":{"line":396,"character":9999}},"containerName":"main::","name":"hstart","definition":"sub"},{"definition":"sub","name":"hend","containerName":"main::","range":{"start":{"line":410,"character":0},"end":{"character":9999,"line":412}},"kind":12,"children":[{"name":"feature2","containerName":"hend","kind":12,"line":411},{"line":411,"kind":12,"name":"end","containerName":"hend"}],"line":410},{"containerName":"main::","name":"hstrand","definition":"sub","range":{"start":{"line":427,"character":0},"end":{"line":429,"character":9999}},"kind":12,"line":427,"children":[{"containerName":"hstrand","name":"feature2","kind":12,"line":428},{"kind":12,"line":428,"name":"strand","containerName":"hstrand"}]},{"kind":12,"children":[{"containerName":"hscore","name":"feature2","kind":12,"line":444},{"name":"score","containerName":"hscore","kind":12,"line":444}],"line":443,"definition":"sub","name":"hscore","containerName":"main::","range":{"start":{"line":443,"character":0},"end":{"character":9999,"line":445}}},{"kind":12,"line":459,"children":[{"name":"feature2","containerName":"hframe","line":460,"kind":12},{"kind":12,"line":460,"containerName":"hframe","name":"frame"}],"containerName":"main::","definition":"sub","name":"hframe","range":{"end":{"line":461,"character":9999},"start":{"character":0,"line":459}}},{"children":[{"line":475,"kind":12,"containerName":"hprimary_tag","name":"feature2"},{"name":"primary_tag","containerName":"hprimary_tag","line":475,"kind":12}],"line":474,"kind":12,"range":{"start":{"character":0,"line":474},"end":{"line":476,"character":9999}},"name":"hprimary_tag","definition":"sub","containerName":"main::"},{"range":{"start":{"character":0,"line":491},"end":{"character":9999,"line":493}},"name":"hsource_tag","definition":"sub","containerName":"main::","children":[{"line":492,"kind":12,"containerName":"hsource_tag","name":"feature2"},{"kind":12,"line":492,"containerName":"hsource_tag","name":"source_tag"}],"line":491,"kind":12},{"kind":12,"children":[{"localvar":"my","containerName":"invert","definition":"my","name":"$self","line":507,"kind":13},{"kind":13,"line":509,"containerName":"invert","name":"$tmp","definition":"my","localvar":"my"},{"name":"$self","containerName":"invert","kind":13,"line":509},{"containerName":"invert","name":"feature1","kind":12,"line":509},{"kind":13,"line":511,"containerName":"invert","name":"$self"},{"name":"feature1","containerName":"invert","line":511,"kind":12},{"containerName":"invert","name":"$self","line":511,"kind":13},{"containerName":"invert","name":"feature2","line":511,"kind":12},{"kind":13,"line":512,"containerName":"invert","name":"$self"},{"kind":12,"line":512,"containerName":"invert","name":"feature2"},{"name":"$tmp","containerName":"invert","kind":13,"line":512}],"line":506,"definition":"sub","containerName":"main::","signature":{"label":"invert($self)","documentation":"1;\n# $Id: FeaturePair.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::FeaturePair\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@sanger.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::FeaturePair - hold pair feature information e.g. blast hits\n\n=head1 SYNOPSIS\n\n    my $feat  = Bio::SeqFeature::FeaturePair->new(-feature1 => $f1,\n\t\t\t\t\t\t -feature2 => $f2,\n\t\t\t\t\t      );\n\n    # Bio::SeqFeatureI methods can be used\n\n    my $start = $feat->start;\n    my $end   = $feat->end;\n\n    # Bio::FeaturePair methods can be used\n    my $hstart = $feat->hstart;\n    my $hend   = $feat->hend;\n\n   my $feature1 = $feat->feature1;  # returns feature1 object\n\n=head1 DESCRIPTION\n\nA sequence feature object where the feature is itself a feature on\nanother sequence - e.g. a blast hit where residues 1-40 of a protein\nsequence SW:HBA_HUMAN has hit to bases 100 - 220 on a genomic sequence\nHS120G22.  The genomic sequence coordinates are used to create one\nsequence feature $f1 and the protein coordinates are used to create\nfeature $f2.  A FeaturePair object can then be made\n\n    my $fp = Bio::SeqFeature::FeaturePair->new(-feature1 => $f1,   # genomic\n\t\t\t\t\t      -feature2 => $f2,   # protein\n\t\t\t\t\t      );\n\nThis object can be used as a standard Bio::SeqFeatureI in which case\n\n    my $gstart = $fp->start  # returns start coord on feature1 - genomic seq.\n    my $gend   = $fp->end    # returns end coord on feature1.\n\nIn general standard Bio::SeqFeatureI method calls return information\nin feature1.\n\nData in the feature 2 object are generally obtained using the standard\nmethods prefixed by h (for hit!)\n\n    my $pstart = $fp->hstart # returns start coord on feature2 = protein seq.\n    my $pend   = $fp->hend   # returns end coord on feature2.\n\nIf you wish to swap feature1 and feature2 around :\n\n    $feat->invert\n\nso... \n\n    $feat->start # etc. returns data in $feature2 object\n\n\nNo sub_SeqFeatures or tags can be stored in this object directly.  Any\nfeatures or tags are expected to be stored in the contained objects\nfeature1, and feature2.\n\n=head1 CONTACT\n\nEwan Birney E<lt>birney@sanger.ac.ukE<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::FeaturePair;\nuse vars qw($AUTOLOAD);\nuse strict;\n\nuse Bio::SeqFeatureI;\nuse Bio::Factory::ObjectFactory;\n\nuse base qw(Bio::SeqFeature::Generic);\n\n=head2 new\n\n Title   : new\n Usage   :\n Function: Constructor for this module. Accepts the following parameters:\n\n             -feature1   Bio::SeqFeatureI-compliant object\n             -feature2   Bio::SeqFeatureI-compliant object\n             -feature_factory  Bio::Factory::ObjectFactoryI compliant\n                         object to be used when feature1 and/or feature2\n                         are accessed without explicitly set before. This\n                         is mostly useful for derived classes who want to\n                         set their preferred class for feature objects.\n\n Example :\n Returns : \n Args    : see above\n\n\n\nsub new {\n    my ($class, @args) = @_;\n\n    #\n    # We've got a certain problem here that somewhat relates to chicken and\n    # eggs. The problem is, we override a lot of SeqFeatureI methods here\n    # to delegate them to either feature1 or feature2. If we pass along\n    # those attributes right away, we need feature1 or feature2 or the feature\n    # factory in place, or there is no way around the dreaded default, which\n    # is ugly too (as it necessitates subsequent copying if you wanted a\n    # different feature object class).\n    #\n    # So I decided to go with the lesser of two evils here: we need to assume\n    # here that we can set all attributes through set_attributes(), which we\n    # assume is no different from setting them through the constructor. This\n    # gives us a window to set the feature objects and the factory, such that\n    # any derived class doesn't have to worry about this any more.\n    #\n    # I'm happy to hear a better solution, but I think this one isn't so bad.\n    #\n    my $self = $class->SUPER::new();\n    my ($feature1,$feature2,$featfact) = \n\t$self->_rearrange([qw(FEATURE1\n\t\t\t      FEATURE2\n\t\t\t      FEATURE_FACTORY\n\t\t\t      )],@args);\n    \n    $self->_register_for_cleanup(\\&cleanup_fp);\n    # initialize the feature object factory if not provided\n    if(! $featfact) {\n\t$featfact = Bio::Factory::ObjectFactory->new(\n\t\t\t\t   -type => \"Bio::SeqFeature::Generic\",\n\t\t\t\t   -interface => \"Bio::SeqFeatureI\");\n    }\n    $self->feature_factory($featfact);\n    # Store the features in the object\n    $feature1 && $self->feature1($feature1);\n    $feature2 && $self->feature2($feature2);\n    \n    # OK. Now we're setup to store all the attributes, and they'll go right\n    # away into the right objects.\n    $self->set_attributes(@args);\n\n    # done - we hope\n    return $self;\n}\n\n=head2 feature1\n\n Title   : feature1\n Usage   : $f = $featpair->feature1\n           $featpair->feature1($feature)\n Function: Get/set for the query feature\n Returns : Bio::SeqFeatureI\n Args    : Bio::SeqFeatureI\n\n\n\nsub feature1 {\n    my ($self,$arg) = @_;    \n    if ( defined($arg) || !defined $self->{'feature1'} ) {\n\t$self->throw(\"internal error: feature factory not set!\") \n\t    unless $self->feature_factory;\n\t$arg = $self->feature_factory->create_object() unless( defined $arg);\n\t$self->throw(\"Argument [$arg] must be a Bio::SeqFeatureI\") \n\t    unless (ref($arg) && $arg->isa(\"Bio::SeqFeatureI\"));\n\t$self->{'feature1'} = $arg;\n    }\n    return $self->{'feature1'};\n}\n\n=head2 feature2\n\n Title   : feature2\n Usage   : $f = $featpair->feature2\n           $featpair->feature2($feature)\n Function: Get/set for the hit feature\n Returns : Bio::SeqFeatureI\n Args    : Bio::SeqFeatureI\n\n\n\nsub feature2 {\n    my ($self,$arg) = @_;\n\n    if ( defined($arg) || ! defined $self->{'feature2'}) {\n\t$self->throw(\"internal error: feature factory not set!\") \n\t    unless $self->feature_factory;\n\t$arg = $self->feature_factory->create_object() unless( defined $arg);\n\t$self->throw(\"Argument [$arg] must be a Bio::SeqFeatureI\") \n\t    unless (ref($arg) && $arg->isa(\"Bio::SeqFeatureI\"));\n\t$self->{'feature2'} = $arg;\n    }\n    return $self->{'feature2'};\n}\n\n=head2 start\n\n Title   : start\n Usage   : $start = $featpair->start\n           $featpair->start(20)\n Function: Get/set on the start coordinate of feature1\n Returns : integer\n Args    : [optional] beginning of feature\n\n\nsub start {\n    return shift->feature1->start(@_);\n}\n\n=head2 end\n\n Title   : end\n Usage   : $end = $featpair->end\n           $featpair->end($end)\n Function: get/set on the end coordinate of feature1\n Returns : integer\n Args    : [optional] ending point of feature\n\n\n\nsub end{\n    return shift->feature1->end(@_);    \n}\n\n=head2 strand\n\n Title   : strand\n Usage   : $strand = $feat->strand()\n           $feat->strand($strand)\n Function: get/set on strand information, being 1,-1 or 0\n Returns : -1,1 or 0\n Args    : [optional] strand information to set\n\n\n\nsub strand{\n    return shift->feature1->strand(@_);    \n}\n\n=head2 location\n\n Title   : location\n Usage   : $location = $featpair->location\n           $featpair->location($location)\n Function: Get/set location object (using feature1)\n Returns : Bio::LocationI object\n Args    : [optional] LocationI to store\n\n\nsub location {\n    return shift->feature1->location(@_);\n}\n\n=head2 score\n\n Title   : score\n Usage   : $score = $feat->score()\n           $feat->score($score)\n Function: get/set on score information\n Returns : float\n Args    : none if get, the new value if set\n\n\n\nsub score {\n    return shift->feature1->score(@_);    \n}\n\n=head2 frame\n\n Title   : frame\n Usage   : $frame = $feat->frame()\n           $feat->frame($frame)\n Function: get/set on frame information\n Returns : 0,1,2\n Args    : none if get, the new value if set\n\n\n\nsub frame {\n    return shift->feature1->frame(@_);    \n}\n\n=head2 primary_tag\n\n Title   : primary_tag\n Usage   : $ptag = $featpair->primary_tag\n Function: get/set on the primary_tag of feature1\n Returns : 0,1,2\n Args    : none if get, the new value if set\n\n\n\nsub primary_tag{\n    return shift->feature1->primary_tag(@_);    \n}\n\n=head2 source_tag\n\n Title   : source_tag\n Usage   : $tag = $feat->source_tag()\n           $feat->source_tag('genscan');\n Function: Returns the source tag for a feature,\n           eg, 'genscan' \n Returns : a string \n Args    : none\n\n\n\nsub source_tag{\n    return shift->feature1->source_tag(@_);    \n}\n\n=head2 seqname\n\n Title   : seqname\n Usage   : $obj->seq_id($newval)\n Function: There are many cases when you make a feature that you\n           do know the sequence name, but do not know its actual\n           sequence. This is an attribute such that you can store \n           the seqname.\n\n           This attribute should *not* be used in GFF dumping, as\n           that should come from the collection in which the seq\n           feature was found.\n Returns : value of seqname\n Args    : newvalue (optional)\n\n\n\nsub seq_id{\n    return shift->feature1->seq_id(@_);    \n}\n\n=head2 hseqname\n\n Title   : hseqname\n Usage   : $featpair->hseqname($newval)\n Function: Get/set method for the name of\n           feature2.\n Returns : value of $feature2->seq_id\n Args    : newvalue (optional)\n\n\n\nsub hseq_id {\n    return shift->feature2->seq_id(@_);\n}\n\n\n=head2 hstart\n\n Title   : hstart\n Usage   : $start = $featpair->hstart\n           $featpair->hstart(20)\n Function: Get/set on the start coordinate of feature2\n Returns : integer\n Args    : none\n\n\nsub hstart {\n    return shift->feature2->start(@_);    \n}\n\n=head2 hend\n\n Title   : hend\n Usage   : $end = $featpair->hend\n           $featpair->hend($end)\n Function: get/set on the end coordinate of feature2\n Returns : integer\n Args    : none\n\n\n\nsub hend{\n    return shift->feature2->end(@_);    \n}\n\n\n=head2 hstrand\n\n Title   : hstrand\n Usage   : $strand = $feat->strand()\n           $feat->strand($strand)\n Function: get/set on strand information, being 1,-1 or 0\n Returns : -1,1 or 0\n Args    : none\n\n\n\nsub hstrand{\n    return shift->feature2->strand(@_);\n}\n\n=head2 hscore\n\n Title   : hscore\n Usage   : $score = $feat->score()\n           $feat->score($score)\n Function: get/set on score information\n Returns : float\n Args    : none if get, the new value if set\n\n\n\nsub hscore {\n    return shift->feature2->score(@_);    \n}\n\n=head2 hframe\n\n Title   : hframe\n Usage   : $frame = $feat->frame()\n           $feat->frame($frame)\n Function: get/set on frame information\n Returns : 0,1,2\n Args    : none if get, the new value if set\n\n\n\nsub hframe {\n    return shift->feature2->frame(@_);    \n}\n\n=head2 hprimary_tag\n\n Title   : hprimary_tag\n Usage   : $ptag = $featpair->hprimary_tag\n Function: Get/set on the primary_tag of feature2\n Returns : 0,1,2\n Args    : none if get, the new value if set\n\n\n\nsub hprimary_tag{\n    return shift->feature2->primary_tag(@_);    \n}\n\n=head2 hsource_tag\n\n Title   : hsource_tag\n Usage   : $tag = $feat->hsource_tag()\n           $feat->source_tag('genscan');\n Function: Returns the source tag for a feature,\n           eg, 'genscan' \n Returns : a string \n Args    : none\n\n\n\nsub hsource_tag{\n    return shift->feature2->source_tag(@_);\n}\n\n=head2 invert\n\n Title   : invert\n Usage   : $tag = $feat->invert\n Function: Swaps feature1 and feature2 around\n Returns : Nothing\n Args    : none","parameters":[{"label":"$self"}]},"detail":"($self)","name":"invert","range":{"end":{"line":514,"character":9999},"start":{"line":506,"character":0}}},{"kind":12,"children":[{"line":539,"kind":13,"localvar":"my","containerName":"feature_factory","definition":"my","name":"$self"},{"kind":13,"line":541,"containerName":"feature_factory","name":"$self"},{"line":542,"kind":13,"name":"$self","containerName":"feature_factory"}],"line":538,"name":"feature_factory","definition":"sub","containerName":"main::","range":{"end":{"line":543,"character":9999},"start":{"character":0,"line":538}}},{"line":551,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"hseqname","line":552,"kind":13},{"name":"$self","containerName":"hseqname","kind":13,"line":553},{"kind":12,"line":553,"containerName":"hseqname","name":"warn"},{"line":554,"kind":13,"name":"$self","containerName":"hseqname"},{"line":554,"kind":12,"containerName":"hseqname","name":"hseq_id"}],"kind":12,"range":{"end":{"line":555,"character":9999},"start":{"line":551,"character":0}},"containerName":"main::","definition":"sub","name":"hseqname"},{"name":"cleanup_fp","definition":"sub","containerName":"main::","range":{"end":{"line":560,"character":9999},"start":{"line":557,"character":0}},"kind":12,"children":[{"definition":"my","name":"$self","containerName":"cleanup_fp","localvar":"my","kind":13,"line":558},{"containerName":"cleanup_fp","name":"$self","line":559,"kind":13},{"kind":13,"line":559,"containerName":"cleanup_fp","name":"$self"}],"line":557}]}