{"vars":[{"containerName":"","name":"base","line":151,"kind":2},{"kind":12,"line":172,"children":[{"line":173,"kind":13,"localvar":"my","definition":"my","name":"$class","containerName":"new"},{"containerName":"new","name":"@args","line":173,"kind":13},{"localvar":"my","containerName":"new","name":"$self","definition":"my","line":175,"kind":13},{"name":"$class","containerName":"new","kind":13,"line":175},{"kind":13,"line":175,"containerName":"new","name":"@args"},{"kind":13,"line":177,"containerName":"new","definition":"my","name":"$feat","localvar":"my"},{"kind":13,"line":177,"name":"$anncoll","containerName":"new"},{"containerName":"new","name":"$fact","line":177,"kind":13},{"containerName":"new","name":"$self","line":178,"kind":13},{"line":178,"kind":12,"name":"_rearrange","containerName":"new"},{"containerName":"new","name":"@args","line":180,"kind":13},{"line":182,"kind":13,"containerName":"new","name":"$self"},{"containerName":"new","name":"feature","kind":12,"line":182},{"kind":13,"line":182,"containerName":"new","name":"$feat"},{"name":"$feat","containerName":"new","kind":13,"line":182},{"line":183,"kind":13,"name":"$self","containerName":"new"},{"kind":12,"line":183,"containerName":"new","name":"annotation"},{"name":"$anncoll","containerName":"new","line":183,"kind":13},{"line":183,"kind":13,"containerName":"new","name":"$feat"},{"name":"$self","containerName":"new","kind":13,"line":184},{"kind":12,"line":184,"containerName":"new","name":"tagvalue_object_factory"},{"kind":13,"line":184,"containerName":"new","name":"$fact"},{"kind":13,"line":184,"containerName":"new","name":"$fact"},{"containerName":"new","name":"$self","kind":13,"line":186}],"containerName":"main::","definition":"sub","detail":"($class,@args)","signature":{"label":"new($class,@args)","documentation":"1;\n# $Id: AnnotationAdaptor.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::AnnotationAdaptor\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp at gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n#\n# (c) Hilmar Lapp, hlapp at gmx.net, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n# \n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::AnnotationAdaptor - integrates SeqFeatureIs annotation\n\n=head1 SYNOPSIS\n\n   use Bio::SeqFeature::Generic;\n   use Bio::SeqFeature::AnnotationAdaptor;\n\n   # obtain a SeqFeatureI implementing object somehow\n   my $feat = Bio::SeqFeature::Generic->new(-start => 10, -end => 20);\n\n   # add tag/value annotation\n   $feat->add_tag_value(\"mytag\", \"value of tag mytag\");\n   $feat->add_tag_value(\"mytag\", \"another value of tag mytag\");\n\n   # Bio::SeqFeature::Generic also provides annotation(), which returns a\n   # Bio::AnnotationCollectionI compliant object\n   $feat->annotation->add_Annotation(\"dbxref\", $dblink);\n\n   # to integrate tag/value annotation with AnnotationCollectionI\n   # annotation, use this adaptor, which also implements \n   # Bio::AnnotationCollectionI\n   my $anncoll = Bio::SeqFeature::AnnotationAdaptor->new(-feature => $feat);\n\n   # this will now return tag/value pairs as \n   # Bio::Annotation::SimpleValue objects\n   my @anns = $anncoll->get_Annotations(\"mytag\");\n   # other added before annotation is available too\n   my @dblinks = $anncoll->get_Annotations(\"dbxref\");\n\n   # also supports transparent adding of tag/value pairs in \n   # Bio::AnnotationI flavor\n   my $tagval = Bio::Annotation::SimpleValue->new(-value => \"some value\",\n                                                  -tagname => \"some tag\");\n   $anncoll->add_Annotation($tagval);\n   # this is now also available from the feature's tag/value system\n   my @vals = $feat->each_tag_value(\"some tag\");\n\n=head1 DESCRIPTION\n\nL<Bio::SeqFeatureI> defines light-weight annotation of features\nthrough tag/value pairs. Conversely, L<Bio::AnnotationCollectionI>\ntogether with L<Bio::AnnotationI> defines an annotation bag, which is\nbetter typed, but more heavy-weight because it contains every single\npiece of annotation as objects. The frequently used base\nimplementation of Bio::SeqFeatureI, Bio::SeqFeature::Generic, defines\nan additional slot for AnnotationCollectionI-compliant annotation.\n\nThis adaptor provides a L<Bio::AnnotationCollectionI> compliant,\nunified, and integrated view on the annotation of L<Bio::SeqFeatureI>\nobjects, including tag/value pairs, and annotation through the\nannotation() method, if the object supports it. Code using this\nadaptor does not need to worry about the different ways of possibly\nannotating a SeqFeatureI object, but can instead assume that it\nstrictly follows the AnnotationCollectionI scheme. The price to pay is\nthat retrieving and adding annotation will always use objects instead\nof light-weight tag/value pairs.\n\nIn other words, this adaptor allows us to keep the best of both\nworlds. If you create tens of thousands of feature objects, and your\nonly annotation is tag/value pairs, you are best off using the\nfeatures' native tag/value system. If you create a smaller number of\nfeatures, but with rich and typed annotation mixed with tag/value\npairs, this adaptor may be for you. Since its implementation is by\ndouble-composition, you only need to create one instance of the\nadaptor. In order to transparently annotate a feature object, set the\nfeature using the feature() method. Every annotation you add will be\nadded to the feature object, and hence will not be lost when you set\nfeature() to the next object.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp at gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n#' Let the code begin...\n\n\npackage Bio::SeqFeature::AnnotationAdaptor;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Annotation::SimpleValue;\n\nuse base qw(Bio::Root::Root Bio::AnnotationCollectionI Bio::AnnotatableI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SeqFeature::AnnotationAdaptor->new();\n Function: Builds a new Bio::SeqFeature::AnnotationAdaptor object \n Returns : an instance of Bio::SeqFeature::AnnotationAdaptor\n Args    : Named parameters\n            -feature    the Bio::SeqFeatureI implementing object to adapt\n                        (mandatory to be passed here, or set via feature()\n                        before calling other methods)\n            -annotation the Bio::AnnotationCollectionI implementing object\n                        for storing richer annotation (this will default to\n                        the $feature->annotation() if it supports it)\n            -tagvalue_factory the object factory to use for creating tag/value\n                        pair representing objects","parameters":[{"label":"$class"},{"label":"@args"}]},"name":"new","range":{"start":{"character":0,"line":172},"end":{"line":187,"character":9999}}},{"name":"SUPER","containerName":"new","kind":12,"line":175},{"detail":"($self,$value)","signature":{"documentation":"1;\n# $Id: AnnotationAdaptor.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::AnnotationAdaptor\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp at gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n#\n# (c) Hilmar Lapp, hlapp at gmx.net, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n# \n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::AnnotationAdaptor - integrates SeqFeatureIs annotation\n\n=head1 SYNOPSIS\n\n   use Bio::SeqFeature::Generic;\n   use Bio::SeqFeature::AnnotationAdaptor;\n\n   # obtain a SeqFeatureI implementing object somehow\n   my $feat = Bio::SeqFeature::Generic->new(-start => 10, -end => 20);\n\n   # add tag/value annotation\n   $feat->add_tag_value(\"mytag\", \"value of tag mytag\");\n   $feat->add_tag_value(\"mytag\", \"another value of tag mytag\");\n\n   # Bio::SeqFeature::Generic also provides annotation(), which returns a\n   # Bio::AnnotationCollectionI compliant object\n   $feat->annotation->add_Annotation(\"dbxref\", $dblink);\n\n   # to integrate tag/value annotation with AnnotationCollectionI\n   # annotation, use this adaptor, which also implements \n   # Bio::AnnotationCollectionI\n   my $anncoll = Bio::SeqFeature::AnnotationAdaptor->new(-feature => $feat);\n\n   # this will now return tag/value pairs as \n   # Bio::Annotation::SimpleValue objects\n   my @anns = $anncoll->get_Annotations(\"mytag\");\n   # other added before annotation is available too\n   my @dblinks = $anncoll->get_Annotations(\"dbxref\");\n\n   # also supports transparent adding of tag/value pairs in \n   # Bio::AnnotationI flavor\n   my $tagval = Bio::Annotation::SimpleValue->new(-value => \"some value\",\n                                                  -tagname => \"some tag\");\n   $anncoll->add_Annotation($tagval);\n   # this is now also available from the feature's tag/value system\n   my @vals = $feat->each_tag_value(\"some tag\");\n\n=head1 DESCRIPTION\n\nL<Bio::SeqFeatureI> defines light-weight annotation of features\nthrough tag/value pairs. Conversely, L<Bio::AnnotationCollectionI>\ntogether with L<Bio::AnnotationI> defines an annotation bag, which is\nbetter typed, but more heavy-weight because it contains every single\npiece of annotation as objects. The frequently used base\nimplementation of Bio::SeqFeatureI, Bio::SeqFeature::Generic, defines\nan additional slot for AnnotationCollectionI-compliant annotation.\n\nThis adaptor provides a L<Bio::AnnotationCollectionI> compliant,\nunified, and integrated view on the annotation of L<Bio::SeqFeatureI>\nobjects, including tag/value pairs, and annotation through the\nannotation() method, if the object supports it. Code using this\nadaptor does not need to worry about the different ways of possibly\nannotating a SeqFeatureI object, but can instead assume that it\nstrictly follows the AnnotationCollectionI scheme. The price to pay is\nthat retrieving and adding annotation will always use objects instead\nof light-weight tag/value pairs.\n\nIn other words, this adaptor allows us to keep the best of both\nworlds. If you create tens of thousands of feature objects, and your\nonly annotation is tag/value pairs, you are best off using the\nfeatures' native tag/value system. If you create a smaller number of\nfeatures, but with rich and typed annotation mixed with tag/value\npairs, this adaptor may be for you. Since its implementation is by\ndouble-composition, you only need to create one instance of the\nadaptor. In order to transparently annotate a feature object, set the\nfeature using the feature() method. Every annotation you add will be\nadded to the feature object, and hence will not be lost when you set\nfeature() to the next object.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp at gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n#' Let the code begin...\n\n\npackage Bio::SeqFeature::AnnotationAdaptor;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Annotation::SimpleValue;\n\nuse base qw(Bio::Root::Root Bio::AnnotationCollectionI Bio::AnnotatableI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SeqFeature::AnnotationAdaptor->new();\n Function: Builds a new Bio::SeqFeature::AnnotationAdaptor object \n Returns : an instance of Bio::SeqFeature::AnnotationAdaptor\n Args    : Named parameters\n            -feature    the Bio::SeqFeatureI implementing object to adapt\n                        (mandatory to be passed here, or set via feature()\n                        before calling other methods)\n            -annotation the Bio::AnnotationCollectionI implementing object\n                        for storing richer annotation (this will default to\n                        the $feature->annotation() if it supports it)\n            -tagvalue_factory the object factory to use for creating tag/value\n                        pair representing objects\n\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  my ($feat,$anncoll,$fact) =\n\t$self->_rearrange([qw(FEATURE\n                          ANNOTATION\n                          TAGVALUE_FACTORY)], @args);\n\n  $self->feature($feat) if $feat;\n  $self->annotation($anncoll) if $feat;\n  $self->tagvalue_object_factory($fact) if $fact;\n\n  return $self;\n}\n\n=head2 feature\n\n Title   : feature\n Usage   : $obj->feature($newval)\n Function: Get/set the feature that this object adapts to an\n           AnnotationCollectionI.\n Example : \n Returns : value of feature (a Bio::SeqFeatureI compliant object)\n Args    : new value (a Bio::SeqFeatureI compliant object, optional)","parameters":[{"label":"$self"},{"label":"$value"}],"label":"feature($self,$value)"},"containerName":"main::","definition":"sub","line":202,"children":[{"kind":13,"line":203,"name":"$self","definition":"my","containerName":"feature","localvar":"my"},{"containerName":"feature","name":"$value","kind":13,"line":203},{"containerName":"feature","name":"$value","line":204,"kind":13},{"containerName":"feature","name":"$self","line":205,"kind":13},{"kind":13,"line":205,"name":"$value","containerName":"feature"},{"name":"$self","containerName":"feature","line":207,"kind":13}],"kind":12,"range":{"start":{"character":0,"line":202},"end":{"character":9999,"line":208}},"name":"feature"},{"name":"annotation","range":{"end":{"line":238,"character":9999},"start":{"line":227,"character":0}},"kind":12,"children":[{"localvar":"my","containerName":"annotation","definition":"my","name":"$self","line":228,"kind":13},{"containerName":"annotation","name":"$value","line":228,"kind":13},{"line":230,"kind":13,"name":"$value","containerName":"annotation"},{"containerName":"annotation","name":"$self","kind":13,"line":231},{"line":231,"kind":13,"containerName":"annotation","name":"$value"},{"containerName":"annotation","name":"$self","line":233,"kind":13},{"name":"$self","containerName":"annotation","line":234,"kind":13},{"containerName":"annotation","name":"feature","kind":12,"line":234},{"kind":12,"line":234,"containerName":"annotation","name":"can"},{"name":"$self","containerName":"annotation","kind":13,"line":235},{"kind":12,"line":235,"containerName":"annotation","name":"feature"},{"line":235,"kind":12,"name":"annotation","containerName":"annotation"},{"kind":13,"line":237,"containerName":"annotation","name":"$self"}],"line":227,"definition":"sub","containerName":"main::","signature":{"documentation":"1;\n# $Id: AnnotationAdaptor.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::AnnotationAdaptor\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp at gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n#\n# (c) Hilmar Lapp, hlapp at gmx.net, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n# \n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::AnnotationAdaptor - integrates SeqFeatureIs annotation\n\n=head1 SYNOPSIS\n\n   use Bio::SeqFeature::Generic;\n   use Bio::SeqFeature::AnnotationAdaptor;\n\n   # obtain a SeqFeatureI implementing object somehow\n   my $feat = Bio::SeqFeature::Generic->new(-start => 10, -end => 20);\n\n   # add tag/value annotation\n   $feat->add_tag_value(\"mytag\", \"value of tag mytag\");\n   $feat->add_tag_value(\"mytag\", \"another value of tag mytag\");\n\n   # Bio::SeqFeature::Generic also provides annotation(), which returns a\n   # Bio::AnnotationCollectionI compliant object\n   $feat->annotation->add_Annotation(\"dbxref\", $dblink);\n\n   # to integrate tag/value annotation with AnnotationCollectionI\n   # annotation, use this adaptor, which also implements \n   # Bio::AnnotationCollectionI\n   my $anncoll = Bio::SeqFeature::AnnotationAdaptor->new(-feature => $feat);\n\n   # this will now return tag/value pairs as \n   # Bio::Annotation::SimpleValue objects\n   my @anns = $anncoll->get_Annotations(\"mytag\");\n   # other added before annotation is available too\n   my @dblinks = $anncoll->get_Annotations(\"dbxref\");\n\n   # also supports transparent adding of tag/value pairs in \n   # Bio::AnnotationI flavor\n   my $tagval = Bio::Annotation::SimpleValue->new(-value => \"some value\",\n                                                  -tagname => \"some tag\");\n   $anncoll->add_Annotation($tagval);\n   # this is now also available from the feature's tag/value system\n   my @vals = $feat->each_tag_value(\"some tag\");\n\n=head1 DESCRIPTION\n\nL<Bio::SeqFeatureI> defines light-weight annotation of features\nthrough tag/value pairs. Conversely, L<Bio::AnnotationCollectionI>\ntogether with L<Bio::AnnotationI> defines an annotation bag, which is\nbetter typed, but more heavy-weight because it contains every single\npiece of annotation as objects. The frequently used base\nimplementation of Bio::SeqFeatureI, Bio::SeqFeature::Generic, defines\nan additional slot for AnnotationCollectionI-compliant annotation.\n\nThis adaptor provides a L<Bio::AnnotationCollectionI> compliant,\nunified, and integrated view on the annotation of L<Bio::SeqFeatureI>\nobjects, including tag/value pairs, and annotation through the\nannotation() method, if the object supports it. Code using this\nadaptor does not need to worry about the different ways of possibly\nannotating a SeqFeatureI object, but can instead assume that it\nstrictly follows the AnnotationCollectionI scheme. The price to pay is\nthat retrieving and adding annotation will always use objects instead\nof light-weight tag/value pairs.\n\nIn other words, this adaptor allows us to keep the best of both\nworlds. If you create tens of thousands of feature objects, and your\nonly annotation is tag/value pairs, you are best off using the\nfeatures' native tag/value system. If you create a smaller number of\nfeatures, but with rich and typed annotation mixed with tag/value\npairs, this adaptor may be for you. Since its implementation is by\ndouble-composition, you only need to create one instance of the\nadaptor. In order to transparently annotate a feature object, set the\nfeature using the feature() method. Every annotation you add will be\nadded to the feature object, and hence will not be lost when you set\nfeature() to the next object.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp at gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n#' Let the code begin...\n\n\npackage Bio::SeqFeature::AnnotationAdaptor;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Annotation::SimpleValue;\n\nuse base qw(Bio::Root::Root Bio::AnnotationCollectionI Bio::AnnotatableI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SeqFeature::AnnotationAdaptor->new();\n Function: Builds a new Bio::SeqFeature::AnnotationAdaptor object \n Returns : an instance of Bio::SeqFeature::AnnotationAdaptor\n Args    : Named parameters\n            -feature    the Bio::SeqFeatureI implementing object to adapt\n                        (mandatory to be passed here, or set via feature()\n                        before calling other methods)\n            -annotation the Bio::AnnotationCollectionI implementing object\n                        for storing richer annotation (this will default to\n                        the $feature->annotation() if it supports it)\n            -tagvalue_factory the object factory to use for creating tag/value\n                        pair representing objects\n\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  my ($feat,$anncoll,$fact) =\n\t$self->_rearrange([qw(FEATURE\n                          ANNOTATION\n                          TAGVALUE_FACTORY)], @args);\n\n  $self->feature($feat) if $feat;\n  $self->annotation($anncoll) if $feat;\n  $self->tagvalue_object_factory($fact) if $fact;\n\n  return $self;\n}\n\n=head2 feature\n\n Title   : feature\n Usage   : $obj->feature($newval)\n Function: Get/set the feature that this object adapts to an\n           AnnotationCollectionI.\n Example : \n Returns : value of feature (a Bio::SeqFeatureI compliant object)\n Args    : new value (a Bio::SeqFeatureI compliant object, optional)\n\n\n\nsub feature{\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'feature'} = $value;\n    }\n    return $self->{'feature'};\n}\n\n=head2 annotation\n\n Title   : annotation\n Usage   : $obj->annotation($newval)\n Function: Get/set the AnnotationCollectionI implementing object used by\n           this adaptor to store additional annotation that cannot be stored\n           by the SeqFeatureI itself.\n\n           If requested before having been set, the value will default to the\n           annotation object of the feature if it has one.\n Example : \n Returns : value of annotation (a Bio::AnnotationCollectionI compliant object)\n Args    : new value (a Bio::AnnotationCollectionI compliant object, optional)","parameters":[{"label":"$self"},{"label":"$value"}],"label":"annotation($self,$value)"},"detail":"($self,$value)"},{"kind":12,"children":[{"localvar":"my","containerName":"get_all_annotation_keys","name":"$self","definition":"my","line":255,"kind":13},{"line":256,"kind":13,"localvar":"my","name":"@keys","definition":"my","containerName":"get_all_annotation_keys"},{"containerName":"get_all_annotation_keys","name":"$self","line":259,"kind":13},{"containerName":"get_all_annotation_keys","name":"feature","line":259,"kind":12},{"containerName":"get_all_annotation_keys","name":"can","line":259,"kind":12},{"containerName":"get_all_annotation_keys","name":"@keys","kind":13,"line":260},{"containerName":"get_all_annotation_keys","name":"$self","kind":13,"line":260},{"line":260,"kind":12,"name":"feature","containerName":"get_all_annotation_keys"},{"kind":12,"line":260,"containerName":"get_all_annotation_keys","name":"get_all_tags"},{"containerName":"get_all_annotation_keys","name":"@keys","line":262,"kind":13},{"kind":13,"line":262,"name":"$self","containerName":"get_all_annotation_keys"},{"name":"feature","containerName":"get_all_annotation_keys","line":262,"kind":12},{"kind":12,"line":262,"name":"all_tags","containerName":"get_all_annotation_keys"},{"name":"$self","containerName":"get_all_annotation_keys","kind":13,"line":265},{"kind":12,"line":265,"name":"annotation","containerName":"get_all_annotation_keys"},{"name":"@keys","containerName":"get_all_annotation_keys","line":266,"kind":13},{"kind":13,"line":267,"name":"$self","containerName":"get_all_annotation_keys"},{"containerName":"get_all_annotation_keys","name":"feature","line":267,"kind":12},{"containerName":"get_all_annotation_keys","name":"has_tag","kind":12,"line":267},{"line":268,"kind":13,"containerName":"get_all_annotation_keys","name":"$self"},{"name":"annotation","containerName":"get_all_annotation_keys","kind":12,"line":268},{"containerName":"get_all_annotation_keys","name":"get_all_annotation_keys","kind":12,"line":268},{"name":"@keys","containerName":"get_all_annotation_keys","line":271,"kind":13}],"line":254,"definition":"sub","containerName":"main::","signature":{"label":"get_all_annotation_keys($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: AnnotationAdaptor.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::AnnotationAdaptor\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp at gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n#\n# (c) Hilmar Lapp, hlapp at gmx.net, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n# \n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::AnnotationAdaptor - integrates SeqFeatureIs annotation\n\n=head1 SYNOPSIS\n\n   use Bio::SeqFeature::Generic;\n   use Bio::SeqFeature::AnnotationAdaptor;\n\n   # obtain a SeqFeatureI implementing object somehow\n   my $feat = Bio::SeqFeature::Generic->new(-start => 10, -end => 20);\n\n   # add tag/value annotation\n   $feat->add_tag_value(\"mytag\", \"value of tag mytag\");\n   $feat->add_tag_value(\"mytag\", \"another value of tag mytag\");\n\n   # Bio::SeqFeature::Generic also provides annotation(), which returns a\n   # Bio::AnnotationCollectionI compliant object\n   $feat->annotation->add_Annotation(\"dbxref\", $dblink);\n\n   # to integrate tag/value annotation with AnnotationCollectionI\n   # annotation, use this adaptor, which also implements \n   # Bio::AnnotationCollectionI\n   my $anncoll = Bio::SeqFeature::AnnotationAdaptor->new(-feature => $feat);\n\n   # this will now return tag/value pairs as \n   # Bio::Annotation::SimpleValue objects\n   my @anns = $anncoll->get_Annotations(\"mytag\");\n   # other added before annotation is available too\n   my @dblinks = $anncoll->get_Annotations(\"dbxref\");\n\n   # also supports transparent adding of tag/value pairs in \n   # Bio::AnnotationI flavor\n   my $tagval = Bio::Annotation::SimpleValue->new(-value => \"some value\",\n                                                  -tagname => \"some tag\");\n   $anncoll->add_Annotation($tagval);\n   # this is now also available from the feature's tag/value system\n   my @vals = $feat->each_tag_value(\"some tag\");\n\n=head1 DESCRIPTION\n\nL<Bio::SeqFeatureI> defines light-weight annotation of features\nthrough tag/value pairs. Conversely, L<Bio::AnnotationCollectionI>\ntogether with L<Bio::AnnotationI> defines an annotation bag, which is\nbetter typed, but more heavy-weight because it contains every single\npiece of annotation as objects. The frequently used base\nimplementation of Bio::SeqFeatureI, Bio::SeqFeature::Generic, defines\nan additional slot for AnnotationCollectionI-compliant annotation.\n\nThis adaptor provides a L<Bio::AnnotationCollectionI> compliant,\nunified, and integrated view on the annotation of L<Bio::SeqFeatureI>\nobjects, including tag/value pairs, and annotation through the\nannotation() method, if the object supports it. Code using this\nadaptor does not need to worry about the different ways of possibly\nannotating a SeqFeatureI object, but can instead assume that it\nstrictly follows the AnnotationCollectionI scheme. The price to pay is\nthat retrieving and adding annotation will always use objects instead\nof light-weight tag/value pairs.\n\nIn other words, this adaptor allows us to keep the best of both\nworlds. If you create tens of thousands of feature objects, and your\nonly annotation is tag/value pairs, you are best off using the\nfeatures' native tag/value system. If you create a smaller number of\nfeatures, but with rich and typed annotation mixed with tag/value\npairs, this adaptor may be for you. Since its implementation is by\ndouble-composition, you only need to create one instance of the\nadaptor. In order to transparently annotate a feature object, set the\nfeature using the feature() method. Every annotation you add will be\nadded to the feature object, and hence will not be lost when you set\nfeature() to the next object.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp at gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n#' Let the code begin...\n\n\npackage Bio::SeqFeature::AnnotationAdaptor;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Annotation::SimpleValue;\n\nuse base qw(Bio::Root::Root Bio::AnnotationCollectionI Bio::AnnotatableI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SeqFeature::AnnotationAdaptor->new();\n Function: Builds a new Bio::SeqFeature::AnnotationAdaptor object \n Returns : an instance of Bio::SeqFeature::AnnotationAdaptor\n Args    : Named parameters\n            -feature    the Bio::SeqFeatureI implementing object to adapt\n                        (mandatory to be passed here, or set via feature()\n                        before calling other methods)\n            -annotation the Bio::AnnotationCollectionI implementing object\n                        for storing richer annotation (this will default to\n                        the $feature->annotation() if it supports it)\n            -tagvalue_factory the object factory to use for creating tag/value\n                        pair representing objects\n\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  my ($feat,$anncoll,$fact) =\n\t$self->_rearrange([qw(FEATURE\n                          ANNOTATION\n                          TAGVALUE_FACTORY)], @args);\n\n  $self->feature($feat) if $feat;\n  $self->annotation($anncoll) if $feat;\n  $self->tagvalue_object_factory($fact) if $fact;\n\n  return $self;\n}\n\n=head2 feature\n\n Title   : feature\n Usage   : $obj->feature($newval)\n Function: Get/set the feature that this object adapts to an\n           AnnotationCollectionI.\n Example : \n Returns : value of feature (a Bio::SeqFeatureI compliant object)\n Args    : new value (a Bio::SeqFeatureI compliant object, optional)\n\n\n\nsub feature{\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'feature'} = $value;\n    }\n    return $self->{'feature'};\n}\n\n=head2 annotation\n\n Title   : annotation\n Usage   : $obj->annotation($newval)\n Function: Get/set the AnnotationCollectionI implementing object used by\n           this adaptor to store additional annotation that cannot be stored\n           by the SeqFeatureI itself.\n\n           If requested before having been set, the value will default to the\n           annotation object of the feature if it has one.\n Example : \n Returns : value of annotation (a Bio::AnnotationCollectionI compliant object)\n Args    : new value (a Bio::AnnotationCollectionI compliant object, optional)\n\n\n\nsub annotation{\n    my ($self,$value) = @_;\n\n    if( defined $value) {\n        $self->{'annotation'} = $value;\n    }\n    if((! exists($self->{'annotation'})) &&\n       $self->feature()->can('annotation')) {\n        return $self->feature()->annotation();\n    }\n    return $self->{'annotation'};\n}\n\n=head1 AnnotationCollectionI implementing methods\n\n\n=head2 get_all_annotation_keys\n\n Title   : get_all_annotation_keys\n Usage   : $ac->get_all_annotation_keys()\n Function: gives back a list of annotation keys, which are simple text strings\n Returns : list of strings\n Args    : none"},"detail":"($self)","name":"get_all_annotation_keys","range":{"start":{"character":0,"line":254},"end":{"character":9999,"line":272}}},{"name":"get_Annotations","range":{"end":{"line":319,"character":9999},"start":{"character":0,"line":285}},"containerName":"main::","definition":"sub","detail":"($self,@keys)","signature":{"label":"get_Annotations($self,@keys)","documentation":"1;\n# $Id: AnnotationAdaptor.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::AnnotationAdaptor\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp at gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n#\n# (c) Hilmar Lapp, hlapp at gmx.net, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n# \n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::AnnotationAdaptor - integrates SeqFeatureIs annotation\n\n=head1 SYNOPSIS\n\n   use Bio::SeqFeature::Generic;\n   use Bio::SeqFeature::AnnotationAdaptor;\n\n   # obtain a SeqFeatureI implementing object somehow\n   my $feat = Bio::SeqFeature::Generic->new(-start => 10, -end => 20);\n\n   # add tag/value annotation\n   $feat->add_tag_value(\"mytag\", \"value of tag mytag\");\n   $feat->add_tag_value(\"mytag\", \"another value of tag mytag\");\n\n   # Bio::SeqFeature::Generic also provides annotation(), which returns a\n   # Bio::AnnotationCollectionI compliant object\n   $feat->annotation->add_Annotation(\"dbxref\", $dblink);\n\n   # to integrate tag/value annotation with AnnotationCollectionI\n   # annotation, use this adaptor, which also implements \n   # Bio::AnnotationCollectionI\n   my $anncoll = Bio::SeqFeature::AnnotationAdaptor->new(-feature => $feat);\n\n   # this will now return tag/value pairs as \n   # Bio::Annotation::SimpleValue objects\n   my @anns = $anncoll->get_Annotations(\"mytag\");\n   # other added before annotation is available too\n   my @dblinks = $anncoll->get_Annotations(\"dbxref\");\n\n   # also supports transparent adding of tag/value pairs in \n   # Bio::AnnotationI flavor\n   my $tagval = Bio::Annotation::SimpleValue->new(-value => \"some value\",\n                                                  -tagname => \"some tag\");\n   $anncoll->add_Annotation($tagval);\n   # this is now also available from the feature's tag/value system\n   my @vals = $feat->each_tag_value(\"some tag\");\n\n=head1 DESCRIPTION\n\nL<Bio::SeqFeatureI> defines light-weight annotation of features\nthrough tag/value pairs. Conversely, L<Bio::AnnotationCollectionI>\ntogether with L<Bio::AnnotationI> defines an annotation bag, which is\nbetter typed, but more heavy-weight because it contains every single\npiece of annotation as objects. The frequently used base\nimplementation of Bio::SeqFeatureI, Bio::SeqFeature::Generic, defines\nan additional slot for AnnotationCollectionI-compliant annotation.\n\nThis adaptor provides a L<Bio::AnnotationCollectionI> compliant,\nunified, and integrated view on the annotation of L<Bio::SeqFeatureI>\nobjects, including tag/value pairs, and annotation through the\nannotation() method, if the object supports it. Code using this\nadaptor does not need to worry about the different ways of possibly\nannotating a SeqFeatureI object, but can instead assume that it\nstrictly follows the AnnotationCollectionI scheme. The price to pay is\nthat retrieving and adding annotation will always use objects instead\nof light-weight tag/value pairs.\n\nIn other words, this adaptor allows us to keep the best of both\nworlds. If you create tens of thousands of feature objects, and your\nonly annotation is tag/value pairs, you are best off using the\nfeatures' native tag/value system. If you create a smaller number of\nfeatures, but with rich and typed annotation mixed with tag/value\npairs, this adaptor may be for you. Since its implementation is by\ndouble-composition, you only need to create one instance of the\nadaptor. In order to transparently annotate a feature object, set the\nfeature using the feature() method. Every annotation you add will be\nadded to the feature object, and hence will not be lost when you set\nfeature() to the next object.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp at gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n#' Let the code begin...\n\n\npackage Bio::SeqFeature::AnnotationAdaptor;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Annotation::SimpleValue;\n\nuse base qw(Bio::Root::Root Bio::AnnotationCollectionI Bio::AnnotatableI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SeqFeature::AnnotationAdaptor->new();\n Function: Builds a new Bio::SeqFeature::AnnotationAdaptor object \n Returns : an instance of Bio::SeqFeature::AnnotationAdaptor\n Args    : Named parameters\n            -feature    the Bio::SeqFeatureI implementing object to adapt\n                        (mandatory to be passed here, or set via feature()\n                        before calling other methods)\n            -annotation the Bio::AnnotationCollectionI implementing object\n                        for storing richer annotation (this will default to\n                        the $feature->annotation() if it supports it)\n            -tagvalue_factory the object factory to use for creating tag/value\n                        pair representing objects\n\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  my ($feat,$anncoll,$fact) =\n\t$self->_rearrange([qw(FEATURE\n                          ANNOTATION\n                          TAGVALUE_FACTORY)], @args);\n\n  $self->feature($feat) if $feat;\n  $self->annotation($anncoll) if $feat;\n  $self->tagvalue_object_factory($fact) if $fact;\n\n  return $self;\n}\n\n=head2 feature\n\n Title   : feature\n Usage   : $obj->feature($newval)\n Function: Get/set the feature that this object adapts to an\n           AnnotationCollectionI.\n Example : \n Returns : value of feature (a Bio::SeqFeatureI compliant object)\n Args    : new value (a Bio::SeqFeatureI compliant object, optional)\n\n\n\nsub feature{\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'feature'} = $value;\n    }\n    return $self->{'feature'};\n}\n\n=head2 annotation\n\n Title   : annotation\n Usage   : $obj->annotation($newval)\n Function: Get/set the AnnotationCollectionI implementing object used by\n           this adaptor to store additional annotation that cannot be stored\n           by the SeqFeatureI itself.\n\n           If requested before having been set, the value will default to the\n           annotation object of the feature if it has one.\n Example : \n Returns : value of annotation (a Bio::AnnotationCollectionI compliant object)\n Args    : new value (a Bio::AnnotationCollectionI compliant object, optional)\n\n\n\nsub annotation{\n    my ($self,$value) = @_;\n\n    if( defined $value) {\n        $self->{'annotation'} = $value;\n    }\n    if((! exists($self->{'annotation'})) &&\n       $self->feature()->can('annotation')) {\n        return $self->feature()->annotation();\n    }\n    return $self->{'annotation'};\n}\n\n=head1 AnnotationCollectionI implementing methods\n\n\n=head2 get_all_annotation_keys\n\n Title   : get_all_annotation_keys\n Usage   : $ac->get_all_annotation_keys()\n Function: gives back a list of annotation keys, which are simple text strings\n Returns : list of strings\n Args    : none\n\n\nsub get_all_annotation_keys{\n    my ($self) = @_;\n    my @keys = ();\n    \n    # get the tags from the feature object\n    if ($self->feature()->can('get_all_tags')) {\n        push(@keys, $self->feature()->get_all_tags());\n    } else {\n        push(@keys, $self->feature()->all_tags());\n    }\n    # ask the annotation implementation in addition, while avoiding duplicates\n    if($self->annotation()) {\n\tpush(@keys,\n\t     grep { ! $self->feature->has_tag($_); }\n\t          $self->annotation()->get_all_annotation_keys());\n    }\n    # done\n    return @keys;\n}\n\n\n=head2 get_Annotations\n\n Title   : get_Annotations\n Usage   : my @annotations = $collection->get_Annotations('key')\n Function: Retrieves all the Bio::AnnotationI objects for a specific key\n Returns : list of Bio::AnnotationI - empty if no objects stored for a key\n Args    : string which is key for annotations","parameters":[{"label":"$self"},{"label":"@keys"}]},"kind":12,"line":285,"children":[{"kind":13,"line":286,"containerName":"get_Annotations","name":"$self","definition":"my","localvar":"my"},{"kind":13,"line":286,"containerName":"get_Annotations","name":"@keys"},{"kind":13,"line":287,"name":"@anns","definition":"my","containerName":"get_Annotations","localvar":"my"},{"containerName":"get_Annotations","name":"$fact","definition":"my","localvar":"my","kind":13,"line":290},{"containerName":"get_Annotations","name":"$self","line":290,"kind":13},{"kind":12,"line":290,"name":"tagvalue_object_factory","containerName":"get_Annotations"},{"containerName":"get_Annotations","name":"@keys","kind":13,"line":293},{"containerName":"get_Annotations","name":"$self","kind":13,"line":293},{"containerName":"get_Annotations","name":"feature","kind":12,"line":293},{"line":293,"kind":12,"name":"all_tags","containerName":"get_Annotations"},{"kind":13,"line":293,"containerName":"get_Annotations","name":"@keys"},{"kind":13,"line":296,"definition":"my","name":"$key","containerName":"get_Annotations","localvar":"my"},{"kind":13,"line":296,"containerName":"get_Annotations","name":"@keys"},{"name":"$self","containerName":"get_Annotations","kind":13,"line":298},{"containerName":"get_Annotations","name":"feature","line":298,"kind":12},{"line":298,"kind":12,"containerName":"get_Annotations","name":"has_tag"},{"kind":13,"line":298,"name":"$key","containerName":"get_Annotations"},{"kind":13,"line":300,"definition":"my","name":"$val","containerName":"get_Annotations","localvar":"my"},{"name":"$self","containerName":"get_Annotations","line":300,"kind":13},{"name":"feature","containerName":"get_Annotations","kind":12,"line":300},{"containerName":"get_Annotations","name":"get_tag_values","kind":12,"line":300},{"containerName":"get_Annotations","name":"$key","line":300,"kind":13},{"containerName":"get_Annotations","name":"$ann","definition":"my","localvar":"my","kind":13,"line":301},{"name":"$fact","containerName":"get_Annotations","line":302,"kind":13},{"line":303,"kind":13,"containerName":"get_Annotations","name":"$ann"},{"name":"$fact","containerName":"get_Annotations","kind":13,"line":303},{"line":303,"kind":12,"name":"create_object","containerName":"get_Annotations"},{"line":303,"kind":13,"name":"$val","containerName":"get_Annotations"},{"line":303,"kind":13,"containerName":"get_Annotations","name":"$key"},{"line":305,"kind":13,"name":"$ann","containerName":"get_Annotations"},{"containerName":"get_Annotations","name":"new","kind":12,"line":305},{"containerName":"get_Annotations","name":"$val","line":305,"kind":13},{"line":306,"kind":13,"containerName":"get_Annotations","name":"$key"},{"name":"@anns","containerName":"get_Annotations","kind":13,"line":308},{"kind":13,"line":308,"name":"$ann","containerName":"get_Annotations"},{"name":"$self","containerName":"get_Annotations","kind":13,"line":313},{"name":"annotation","containerName":"get_Annotations","line":313,"kind":12},{"line":314,"kind":13,"name":"@anns","containerName":"get_Annotations"},{"name":"$self","containerName":"get_Annotations","line":314,"kind":13},{"name":"annotation","containerName":"get_Annotations","line":314,"kind":12},{"kind":12,"line":314,"containerName":"get_Annotations","name":"get_Annotations"},{"name":"@keys","containerName":"get_Annotations","kind":13,"line":314},{"containerName":"get_Annotations","name":"@anns","kind":13,"line":318}]},{"line":305,"kind":12,"containerName":"Annotation::SimpleValue","name":"Bio"},{"name":"get_num_of_annotations","range":{"end":{"line":349,"character":9999},"start":{"line":332,"character":0}},"kind":12,"line":332,"children":[{"name":"$self","definition":"my","containerName":"get_num_of_annotations","localvar":"my","kind":13,"line":333},{"line":336,"kind":13,"localvar":"my","containerName":"get_num_of_annotations","definition":"my","name":"$num_anns"},{"name":"$self","containerName":"get_num_of_annotations","kind":13,"line":338},{"name":"feature","containerName":"get_num_of_annotations","line":338,"kind":12},{"kind":12,"line":338,"containerName":"get_num_of_annotations","name":"all_tags"},{"containerName":"get_num_of_annotations","name":"$num_anns","line":339,"kind":13},{"name":"$self","containerName":"get_num_of_annotations","kind":13,"line":339},{"line":339,"kind":12,"name":"feature","containerName":"get_num_of_annotations"},{"line":339,"kind":12,"containerName":"get_num_of_annotations","name":"each_tag_value"},{"line":343,"kind":13,"containerName":"get_num_of_annotations","name":"$self"},{"name":"annotation","containerName":"get_num_of_annotations","kind":12,"line":343},{"kind":13,"line":344,"name":"$num_anns","containerName":"get_num_of_annotations"},{"line":344,"kind":13,"containerName":"get_num_of_annotations","name":"$self"},{"line":344,"kind":12,"containerName":"get_num_of_annotations","name":"annotation"},{"kind":12,"line":344,"containerName":"get_num_of_annotations","name":"get_num_of_annotations"},{"line":348,"kind":13,"containerName":"get_num_of_annotations","name":"$num_anns"}],"containerName":"main::","definition":"sub","detail":"($self)","signature":{"label":"get_num_of_annotations($self)","documentation":"1;\n# $Id: AnnotationAdaptor.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::AnnotationAdaptor\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp at gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n#\n# (c) Hilmar Lapp, hlapp at gmx.net, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n# \n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::AnnotationAdaptor - integrates SeqFeatureIs annotation\n\n=head1 SYNOPSIS\n\n   use Bio::SeqFeature::Generic;\n   use Bio::SeqFeature::AnnotationAdaptor;\n\n   # obtain a SeqFeatureI implementing object somehow\n   my $feat = Bio::SeqFeature::Generic->new(-start => 10, -end => 20);\n\n   # add tag/value annotation\n   $feat->add_tag_value(\"mytag\", \"value of tag mytag\");\n   $feat->add_tag_value(\"mytag\", \"another value of tag mytag\");\n\n   # Bio::SeqFeature::Generic also provides annotation(), which returns a\n   # Bio::AnnotationCollectionI compliant object\n   $feat->annotation->add_Annotation(\"dbxref\", $dblink);\n\n   # to integrate tag/value annotation with AnnotationCollectionI\n   # annotation, use this adaptor, which also implements \n   # Bio::AnnotationCollectionI\n   my $anncoll = Bio::SeqFeature::AnnotationAdaptor->new(-feature => $feat);\n\n   # this will now return tag/value pairs as \n   # Bio::Annotation::SimpleValue objects\n   my @anns = $anncoll->get_Annotations(\"mytag\");\n   # other added before annotation is available too\n   my @dblinks = $anncoll->get_Annotations(\"dbxref\");\n\n   # also supports transparent adding of tag/value pairs in \n   # Bio::AnnotationI flavor\n   my $tagval = Bio::Annotation::SimpleValue->new(-value => \"some value\",\n                                                  -tagname => \"some tag\");\n   $anncoll->add_Annotation($tagval);\n   # this is now also available from the feature's tag/value system\n   my @vals = $feat->each_tag_value(\"some tag\");\n\n=head1 DESCRIPTION\n\nL<Bio::SeqFeatureI> defines light-weight annotation of features\nthrough tag/value pairs. Conversely, L<Bio::AnnotationCollectionI>\ntogether with L<Bio::AnnotationI> defines an annotation bag, which is\nbetter typed, but more heavy-weight because it contains every single\npiece of annotation as objects. The frequently used base\nimplementation of Bio::SeqFeatureI, Bio::SeqFeature::Generic, defines\nan additional slot for AnnotationCollectionI-compliant annotation.\n\nThis adaptor provides a L<Bio::AnnotationCollectionI> compliant,\nunified, and integrated view on the annotation of L<Bio::SeqFeatureI>\nobjects, including tag/value pairs, and annotation through the\nannotation() method, if the object supports it. Code using this\nadaptor does not need to worry about the different ways of possibly\nannotating a SeqFeatureI object, but can instead assume that it\nstrictly follows the AnnotationCollectionI scheme. The price to pay is\nthat retrieving and adding annotation will always use objects instead\nof light-weight tag/value pairs.\n\nIn other words, this adaptor allows us to keep the best of both\nworlds. If you create tens of thousands of feature objects, and your\nonly annotation is tag/value pairs, you are best off using the\nfeatures' native tag/value system. If you create a smaller number of\nfeatures, but with rich and typed annotation mixed with tag/value\npairs, this adaptor may be for you. Since its implementation is by\ndouble-composition, you only need to create one instance of the\nadaptor. In order to transparently annotate a feature object, set the\nfeature using the feature() method. Every annotation you add will be\nadded to the feature object, and hence will not be lost when you set\nfeature() to the next object.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp at gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n#' Let the code begin...\n\n\npackage Bio::SeqFeature::AnnotationAdaptor;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Annotation::SimpleValue;\n\nuse base qw(Bio::Root::Root Bio::AnnotationCollectionI Bio::AnnotatableI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SeqFeature::AnnotationAdaptor->new();\n Function: Builds a new Bio::SeqFeature::AnnotationAdaptor object \n Returns : an instance of Bio::SeqFeature::AnnotationAdaptor\n Args    : Named parameters\n            -feature    the Bio::SeqFeatureI implementing object to adapt\n                        (mandatory to be passed here, or set via feature()\n                        before calling other methods)\n            -annotation the Bio::AnnotationCollectionI implementing object\n                        for storing richer annotation (this will default to\n                        the $feature->annotation() if it supports it)\n            -tagvalue_factory the object factory to use for creating tag/value\n                        pair representing objects\n\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  my ($feat,$anncoll,$fact) =\n\t$self->_rearrange([qw(FEATURE\n                          ANNOTATION\n                          TAGVALUE_FACTORY)], @args);\n\n  $self->feature($feat) if $feat;\n  $self->annotation($anncoll) if $feat;\n  $self->tagvalue_object_factory($fact) if $fact;\n\n  return $self;\n}\n\n=head2 feature\n\n Title   : feature\n Usage   : $obj->feature($newval)\n Function: Get/set the feature that this object adapts to an\n           AnnotationCollectionI.\n Example : \n Returns : value of feature (a Bio::SeqFeatureI compliant object)\n Args    : new value (a Bio::SeqFeatureI compliant object, optional)\n\n\n\nsub feature{\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'feature'} = $value;\n    }\n    return $self->{'feature'};\n}\n\n=head2 annotation\n\n Title   : annotation\n Usage   : $obj->annotation($newval)\n Function: Get/set the AnnotationCollectionI implementing object used by\n           this adaptor to store additional annotation that cannot be stored\n           by the SeqFeatureI itself.\n\n           If requested before having been set, the value will default to the\n           annotation object of the feature if it has one.\n Example : \n Returns : value of annotation (a Bio::AnnotationCollectionI compliant object)\n Args    : new value (a Bio::AnnotationCollectionI compliant object, optional)\n\n\n\nsub annotation{\n    my ($self,$value) = @_;\n\n    if( defined $value) {\n        $self->{'annotation'} = $value;\n    }\n    if((! exists($self->{'annotation'})) &&\n       $self->feature()->can('annotation')) {\n        return $self->feature()->annotation();\n    }\n    return $self->{'annotation'};\n}\n\n=head1 AnnotationCollectionI implementing methods\n\n\n=head2 get_all_annotation_keys\n\n Title   : get_all_annotation_keys\n Usage   : $ac->get_all_annotation_keys()\n Function: gives back a list of annotation keys, which are simple text strings\n Returns : list of strings\n Args    : none\n\n\nsub get_all_annotation_keys{\n    my ($self) = @_;\n    my @keys = ();\n    \n    # get the tags from the feature object\n    if ($self->feature()->can('get_all_tags')) {\n        push(@keys, $self->feature()->get_all_tags());\n    } else {\n        push(@keys, $self->feature()->all_tags());\n    }\n    # ask the annotation implementation in addition, while avoiding duplicates\n    if($self->annotation()) {\n\tpush(@keys,\n\t     grep { ! $self->feature->has_tag($_); }\n\t          $self->annotation()->get_all_annotation_keys());\n    }\n    # done\n    return @keys;\n}\n\n\n=head2 get_Annotations\n\n Title   : get_Annotations\n Usage   : my @annotations = $collection->get_Annotations('key')\n Function: Retrieves all the Bio::AnnotationI objects for a specific key\n Returns : list of Bio::AnnotationI - empty if no objects stored for a key\n Args    : string which is key for annotations\n\n\nsub get_Annotations{\n    my ($self, @keys) = @_;\n    my @anns = ();\n\n    # we need a annotation object factory\n    my $fact = $self->tagvalue_object_factory();\n\n    # get all tags if no keys have been provided\n    @keys = $self->feature->all_tags() unless @keys;\n\n    # build object for each value for each tag\n    foreach my $key (@keys) {\n      # protect against keys that aren't tags\n      next unless $self->feature->has_tag($key);\n      # add each tag/value pair as a SimpleValue object\n      foreach my $val ($self->feature()->get_tag_values($key)) {\n       my $ann;\n       if($fact) {\n          $ann = $fact->create_object(-value => $val, -tagname => $key);\n       } else {\n          $ann = Bio::Annotation::SimpleValue->new(-value => $val,\n                                                   -tagname => $key);\n       }\n       push(@anns, $ann);\n      }\n    }\n\n    # add what is in the annotation implementation if any\n    if($self->annotation()) {\n      push(@anns, $self->annotation->get_Annotations(@keys));\n    }\n\n    # done\n    return @anns;\n}\n\n=head2 get_num_of_annotations\n\n Title   : get_num_of_annotations\n Usage   : my $count = $collection->get_num_of_annotations()\n Function: Returns the count of all annotations stored in this collection \n Returns : integer\n Args    : none","parameters":[{"label":"$self"}]}},{"name":"add_Annotation","range":{"end":{"line":423,"character":9999},"start":{"character":0,"line":384}},"kind":12,"children":[{"kind":13,"line":385,"containerName":"add_Annotation","definition":"my","name":"$self","localvar":"my"},{"line":385,"kind":13,"containerName":"add_Annotation","name":"$key"},{"line":385,"kind":13,"name":"$object","containerName":"add_Annotation"},{"containerName":"add_Annotation","name":"$archetype","kind":13,"line":385},{"kind":13,"line":388,"containerName":"add_Annotation","name":"$key"},{"line":388,"kind":13,"name":"$key","containerName":"add_Annotation"},{"kind":12,"line":388,"containerName":"add_Annotation","name":"isa"},{"line":389,"kind":13,"containerName":"add_Annotation","name":"$object"},{"kind":13,"line":389,"containerName":"add_Annotation","name":"$object"},{"containerName":"add_Annotation","name":"$archetype","kind":13,"line":390},{"line":390,"kind":13,"name":"$object","containerName":"add_Annotation"},{"line":390,"kind":13,"containerName":"add_Annotation","name":"$object"},{"containerName":"add_Annotation","name":"$object","kind":13,"line":391},{"name":"$key","containerName":"add_Annotation","line":391,"kind":13},{"kind":13,"line":392,"containerName":"add_Annotation","name":"$key"},{"name":"$object","containerName":"add_Annotation","line":392,"kind":13},{"containerName":"add_Annotation","name":"tagname","kind":12,"line":392},{"kind":13,"line":393,"name":"$key","containerName":"add_Annotation"},{"containerName":"add_Annotation","name":"$key","kind":13,"line":393},{"line":393,"kind":12,"name":"name","containerName":"add_Annotation"},{"kind":13,"line":393,"name":"$key","containerName":"add_Annotation"},{"kind":13,"line":393,"containerName":"add_Annotation","name":"$key"},{"kind":13,"line":394,"containerName":"add_Annotation","name":"$self"},{"kind":12,"line":394,"name":"throw","containerName":"add_Annotation"},{"containerName":"add_Annotation","name":"$key","kind":13,"line":395},{"containerName":"add_Annotation","name":"$object","line":398,"kind":13},{"containerName":"add_Annotation","name":"$self","kind":13,"line":399},{"kind":12,"line":399,"name":"throw","containerName":"add_Annotation"},{"name":"$object","containerName":"add_Annotation","line":402,"kind":13},{"name":"$object","containerName":"add_Annotation","kind":13,"line":402},{"name":"isa","containerName":"add_Annotation","line":402,"kind":12},{"line":403,"kind":13,"name":"$self","containerName":"add_Annotation"},{"name":"throw","containerName":"add_Annotation","line":403,"kind":12},{"line":409,"kind":13,"name":"$object","containerName":"add_Annotation"},{"name":"isa","containerName":"add_Annotation","line":409,"kind":12},{"line":410,"kind":13,"containerName":"add_Annotation","name":"$self"},{"containerName":"add_Annotation","name":"feature","kind":12,"line":410},{"kind":12,"line":410,"name":"can","containerName":"add_Annotation"},{"name":"$self","containerName":"add_Annotation","kind":13,"line":411},{"kind":12,"line":411,"name":"feature","containerName":"add_Annotation"},{"kind":12,"line":411,"containerName":"add_Annotation","name":"add_tag_value"},{"name":"$key","containerName":"add_Annotation","kind":13,"line":411},{"line":411,"kind":13,"containerName":"add_Annotation","name":"$object"},{"kind":12,"line":411,"containerName":"add_Annotation","name":"value"},{"line":413,"kind":13,"localvar":"my","definition":"my","name":"$anncoll","containerName":"add_Annotation"},{"line":413,"kind":13,"containerName":"add_Annotation","name":"$self"},{"line":413,"kind":12,"name":"annotation","containerName":"add_Annotation"},{"kind":13,"line":414,"name":"$anncoll","containerName":"add_Annotation"},{"kind":13,"line":415,"name":"$anncoll","containerName":"add_Annotation"},{"containerName":"add_Annotation","name":"new","line":415,"kind":12},{"kind":13,"line":416,"containerName":"add_Annotation","name":"$self"},{"line":416,"kind":12,"name":"annotation","containerName":"add_Annotation"},{"kind":13,"line":416,"containerName":"add_Annotation","name":"$anncoll"},{"name":"$anncoll","containerName":"add_Annotation","line":418,"kind":13},{"name":"can","containerName":"add_Annotation","line":418,"kind":12},{"name":"$anncoll","containerName":"add_Annotation","line":419,"kind":13},{"kind":12,"line":419,"containerName":"add_Annotation","name":"add_Annotation"},{"containerName":"add_Annotation","name":"$key","line":419,"kind":13},{"name":"$object","containerName":"add_Annotation","kind":13,"line":419},{"containerName":"add_Annotation","name":"$archetype","kind":13,"line":419},{"line":421,"kind":13,"containerName":"add_Annotation","name":"$self"},{"containerName":"add_Annotation","name":"throw","line":421,"kind":12}],"line":384,"definition":"sub","containerName":"main::","signature":{"label":"add_Annotation($self,$key,$object,$archetype)","documentation":"1;\n# $Id: AnnotationAdaptor.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::AnnotationAdaptor\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp at gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n#\n# (c) Hilmar Lapp, hlapp at gmx.net, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n# \n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::AnnotationAdaptor - integrates SeqFeatureIs annotation\n\n=head1 SYNOPSIS\n\n   use Bio::SeqFeature::Generic;\n   use Bio::SeqFeature::AnnotationAdaptor;\n\n   # obtain a SeqFeatureI implementing object somehow\n   my $feat = Bio::SeqFeature::Generic->new(-start => 10, -end => 20);\n\n   # add tag/value annotation\n   $feat->add_tag_value(\"mytag\", \"value of tag mytag\");\n   $feat->add_tag_value(\"mytag\", \"another value of tag mytag\");\n\n   # Bio::SeqFeature::Generic also provides annotation(), which returns a\n   # Bio::AnnotationCollectionI compliant object\n   $feat->annotation->add_Annotation(\"dbxref\", $dblink);\n\n   # to integrate tag/value annotation with AnnotationCollectionI\n   # annotation, use this adaptor, which also implements \n   # Bio::AnnotationCollectionI\n   my $anncoll = Bio::SeqFeature::AnnotationAdaptor->new(-feature => $feat);\n\n   # this will now return tag/value pairs as \n   # Bio::Annotation::SimpleValue objects\n   my @anns = $anncoll->get_Annotations(\"mytag\");\n   # other added before annotation is available too\n   my @dblinks = $anncoll->get_Annotations(\"dbxref\");\n\n   # also supports transparent adding of tag/value pairs in \n   # Bio::AnnotationI flavor\n   my $tagval = Bio::Annotation::SimpleValue->new(-value => \"some value\",\n                                                  -tagname => \"some tag\");\n   $anncoll->add_Annotation($tagval);\n   # this is now also available from the feature's tag/value system\n   my @vals = $feat->each_tag_value(\"some tag\");\n\n=head1 DESCRIPTION\n\nL<Bio::SeqFeatureI> defines light-weight annotation of features\nthrough tag/value pairs. Conversely, L<Bio::AnnotationCollectionI>\ntogether with L<Bio::AnnotationI> defines an annotation bag, which is\nbetter typed, but more heavy-weight because it contains every single\npiece of annotation as objects. The frequently used base\nimplementation of Bio::SeqFeatureI, Bio::SeqFeature::Generic, defines\nan additional slot for AnnotationCollectionI-compliant annotation.\n\nThis adaptor provides a L<Bio::AnnotationCollectionI> compliant,\nunified, and integrated view on the annotation of L<Bio::SeqFeatureI>\nobjects, including tag/value pairs, and annotation through the\nannotation() method, if the object supports it. Code using this\nadaptor does not need to worry about the different ways of possibly\nannotating a SeqFeatureI object, but can instead assume that it\nstrictly follows the AnnotationCollectionI scheme. The price to pay is\nthat retrieving and adding annotation will always use objects instead\nof light-weight tag/value pairs.\n\nIn other words, this adaptor allows us to keep the best of both\nworlds. If you create tens of thousands of feature objects, and your\nonly annotation is tag/value pairs, you are best off using the\nfeatures' native tag/value system. If you create a smaller number of\nfeatures, but with rich and typed annotation mixed with tag/value\npairs, this adaptor may be for you. Since its implementation is by\ndouble-composition, you only need to create one instance of the\nadaptor. In order to transparently annotate a feature object, set the\nfeature using the feature() method. Every annotation you add will be\nadded to the feature object, and hence will not be lost when you set\nfeature() to the next object.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp at gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n#' Let the code begin...\n\n\npackage Bio::SeqFeature::AnnotationAdaptor;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Annotation::SimpleValue;\n\nuse base qw(Bio::Root::Root Bio::AnnotationCollectionI Bio::AnnotatableI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SeqFeature::AnnotationAdaptor->new();\n Function: Builds a new Bio::SeqFeature::AnnotationAdaptor object \n Returns : an instance of Bio::SeqFeature::AnnotationAdaptor\n Args    : Named parameters\n            -feature    the Bio::SeqFeatureI implementing object to adapt\n                        (mandatory to be passed here, or set via feature()\n                        before calling other methods)\n            -annotation the Bio::AnnotationCollectionI implementing object\n                        for storing richer annotation (this will default to\n                        the $feature->annotation() if it supports it)\n            -tagvalue_factory the object factory to use for creating tag/value\n                        pair representing objects\n\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  my ($feat,$anncoll,$fact) =\n\t$self->_rearrange([qw(FEATURE\n                          ANNOTATION\n                          TAGVALUE_FACTORY)], @args);\n\n  $self->feature($feat) if $feat;\n  $self->annotation($anncoll) if $feat;\n  $self->tagvalue_object_factory($fact) if $fact;\n\n  return $self;\n}\n\n=head2 feature\n\n Title   : feature\n Usage   : $obj->feature($newval)\n Function: Get/set the feature that this object adapts to an\n           AnnotationCollectionI.\n Example : \n Returns : value of feature (a Bio::SeqFeatureI compliant object)\n Args    : new value (a Bio::SeqFeatureI compliant object, optional)\n\n\n\nsub feature{\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'feature'} = $value;\n    }\n    return $self->{'feature'};\n}\n\n=head2 annotation\n\n Title   : annotation\n Usage   : $obj->annotation($newval)\n Function: Get/set the AnnotationCollectionI implementing object used by\n           this adaptor to store additional annotation that cannot be stored\n           by the SeqFeatureI itself.\n\n           If requested before having been set, the value will default to the\n           annotation object of the feature if it has one.\n Example : \n Returns : value of annotation (a Bio::AnnotationCollectionI compliant object)\n Args    : new value (a Bio::AnnotationCollectionI compliant object, optional)\n\n\n\nsub annotation{\n    my ($self,$value) = @_;\n\n    if( defined $value) {\n        $self->{'annotation'} = $value;\n    }\n    if((! exists($self->{'annotation'})) &&\n       $self->feature()->can('annotation')) {\n        return $self->feature()->annotation();\n    }\n    return $self->{'annotation'};\n}\n\n=head1 AnnotationCollectionI implementing methods\n\n\n=head2 get_all_annotation_keys\n\n Title   : get_all_annotation_keys\n Usage   : $ac->get_all_annotation_keys()\n Function: gives back a list of annotation keys, which are simple text strings\n Returns : list of strings\n Args    : none\n\n\nsub get_all_annotation_keys{\n    my ($self) = @_;\n    my @keys = ();\n    \n    # get the tags from the feature object\n    if ($self->feature()->can('get_all_tags')) {\n        push(@keys, $self->feature()->get_all_tags());\n    } else {\n        push(@keys, $self->feature()->all_tags());\n    }\n    # ask the annotation implementation in addition, while avoiding duplicates\n    if($self->annotation()) {\n\tpush(@keys,\n\t     grep { ! $self->feature->has_tag($_); }\n\t          $self->annotation()->get_all_annotation_keys());\n    }\n    # done\n    return @keys;\n}\n\n\n=head2 get_Annotations\n\n Title   : get_Annotations\n Usage   : my @annotations = $collection->get_Annotations('key')\n Function: Retrieves all the Bio::AnnotationI objects for a specific key\n Returns : list of Bio::AnnotationI - empty if no objects stored for a key\n Args    : string which is key for annotations\n\n\nsub get_Annotations{\n    my ($self, @keys) = @_;\n    my @anns = ();\n\n    # we need a annotation object factory\n    my $fact = $self->tagvalue_object_factory();\n\n    # get all tags if no keys have been provided\n    @keys = $self->feature->all_tags() unless @keys;\n\n    # build object for each value for each tag\n    foreach my $key (@keys) {\n      # protect against keys that aren't tags\n      next unless $self->feature->has_tag($key);\n      # add each tag/value pair as a SimpleValue object\n      foreach my $val ($self->feature()->get_tag_values($key)) {\n       my $ann;\n       if($fact) {\n          $ann = $fact->create_object(-value => $val, -tagname => $key);\n       } else {\n          $ann = Bio::Annotation::SimpleValue->new(-value => $val,\n                                                   -tagname => $key);\n       }\n       push(@anns, $ann);\n      }\n    }\n\n    # add what is in the annotation implementation if any\n    if($self->annotation()) {\n      push(@anns, $self->annotation->get_Annotations(@keys));\n    }\n\n    # done\n    return @anns;\n}\n\n=head2 get_num_of_annotations\n\n Title   : get_num_of_annotations\n Usage   : my $count = $collection->get_num_of_annotations()\n Function: Returns the count of all annotations stored in this collection \n Returns : integer\n Args    : none\n\n\n\nsub get_num_of_annotations{\n  my ($self) = @_;\n\n  # first, count the number of tags on the feature\n  my $num_anns = 0;\n\n  foreach ($self->feature()->all_tags()) {\n\t$num_anns += scalar( $self->feature()->each_tag_value($_));\n  }\n\n  # add from the annotation implementation if any\n  if($self->annotation()) {\n \t$num_anns += $self->annotation()->get_num_of_annotations();\n  }\n\n  # done\n  return $num_anns;\n}\n\n=head1 Implementation specific functions - to allow adding\n\n\n=head2 add_Annotation\n\n Title   : add_Annotation\n Usage   : $self->add_Annotation('reference',$object);\n           $self->add_Annotation($object,'Bio::MyInterface::DiseaseI');\n           $self->add_Annotation($object);\n           $self->add_Annotation('disease',$object,'Bio::MyInterface::DiseaseI');\n Function: Adds an annotation for a specific key.\n\n           If the key is omitted, the object to be added must provide a value\n           via its tagname().\n\n           If the archetype is provided, this and future objects added under\n           that tag have to comply with the archetype and will be rejected\n           otherwise.\n\n           This implementation will add all Bio::Annotation::SimpleValue\n           objects to the adapted features as tag/value pairs. Caveat: this\n           may potentially result in information loss if a derived object\n           is supplied.\n\n Returns : none\n Args    : annotation key ('disease', 'dblink', ...)\n           object to store (must be Bio::AnnotationI compliant)\n           [optional] object archetype to map future storage of object \n                      of these types to","parameters":[{"label":"$self"},{"label":"$key"},{"label":"$object"},{"label":"$archetype"}]},"detail":"($self,$key,$object,$archetype)"},{"name":"Bio","containerName":"Annotation::Collection","line":415,"kind":12},{"range":{"start":{"character":0,"line":445},"end":{"character":9999,"line":466}},"name":"remove_Annotations","detail":"($self,@keys)","signature":{"label":"remove_Annotations($self,@keys)","documentation":"1;\n# $Id: AnnotationAdaptor.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::AnnotationAdaptor\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp at gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n#\n# (c) Hilmar Lapp, hlapp at gmx.net, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n# \n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::AnnotationAdaptor - integrates SeqFeatureIs annotation\n\n=head1 SYNOPSIS\n\n   use Bio::SeqFeature::Generic;\n   use Bio::SeqFeature::AnnotationAdaptor;\n\n   # obtain a SeqFeatureI implementing object somehow\n   my $feat = Bio::SeqFeature::Generic->new(-start => 10, -end => 20);\n\n   # add tag/value annotation\n   $feat->add_tag_value(\"mytag\", \"value of tag mytag\");\n   $feat->add_tag_value(\"mytag\", \"another value of tag mytag\");\n\n   # Bio::SeqFeature::Generic also provides annotation(), which returns a\n   # Bio::AnnotationCollectionI compliant object\n   $feat->annotation->add_Annotation(\"dbxref\", $dblink);\n\n   # to integrate tag/value annotation with AnnotationCollectionI\n   # annotation, use this adaptor, which also implements \n   # Bio::AnnotationCollectionI\n   my $anncoll = Bio::SeqFeature::AnnotationAdaptor->new(-feature => $feat);\n\n   # this will now return tag/value pairs as \n   # Bio::Annotation::SimpleValue objects\n   my @anns = $anncoll->get_Annotations(\"mytag\");\n   # other added before annotation is available too\n   my @dblinks = $anncoll->get_Annotations(\"dbxref\");\n\n   # also supports transparent adding of tag/value pairs in \n   # Bio::AnnotationI flavor\n   my $tagval = Bio::Annotation::SimpleValue->new(-value => \"some value\",\n                                                  -tagname => \"some tag\");\n   $anncoll->add_Annotation($tagval);\n   # this is now also available from the feature's tag/value system\n   my @vals = $feat->each_tag_value(\"some tag\");\n\n=head1 DESCRIPTION\n\nL<Bio::SeqFeatureI> defines light-weight annotation of features\nthrough tag/value pairs. Conversely, L<Bio::AnnotationCollectionI>\ntogether with L<Bio::AnnotationI> defines an annotation bag, which is\nbetter typed, but more heavy-weight because it contains every single\npiece of annotation as objects. The frequently used base\nimplementation of Bio::SeqFeatureI, Bio::SeqFeature::Generic, defines\nan additional slot for AnnotationCollectionI-compliant annotation.\n\nThis adaptor provides a L<Bio::AnnotationCollectionI> compliant,\nunified, and integrated view on the annotation of L<Bio::SeqFeatureI>\nobjects, including tag/value pairs, and annotation through the\nannotation() method, if the object supports it. Code using this\nadaptor does not need to worry about the different ways of possibly\nannotating a SeqFeatureI object, but can instead assume that it\nstrictly follows the AnnotationCollectionI scheme. The price to pay is\nthat retrieving and adding annotation will always use objects instead\nof light-weight tag/value pairs.\n\nIn other words, this adaptor allows us to keep the best of both\nworlds. If you create tens of thousands of feature objects, and your\nonly annotation is tag/value pairs, you are best off using the\nfeatures' native tag/value system. If you create a smaller number of\nfeatures, but with rich and typed annotation mixed with tag/value\npairs, this adaptor may be for you. Since its implementation is by\ndouble-composition, you only need to create one instance of the\nadaptor. In order to transparently annotate a feature object, set the\nfeature using the feature() method. Every annotation you add will be\nadded to the feature object, and hence will not be lost when you set\nfeature() to the next object.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp at gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n#' Let the code begin...\n\n\npackage Bio::SeqFeature::AnnotationAdaptor;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Annotation::SimpleValue;\n\nuse base qw(Bio::Root::Root Bio::AnnotationCollectionI Bio::AnnotatableI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SeqFeature::AnnotationAdaptor->new();\n Function: Builds a new Bio::SeqFeature::AnnotationAdaptor object \n Returns : an instance of Bio::SeqFeature::AnnotationAdaptor\n Args    : Named parameters\n            -feature    the Bio::SeqFeatureI implementing object to adapt\n                        (mandatory to be passed here, or set via feature()\n                        before calling other methods)\n            -annotation the Bio::AnnotationCollectionI implementing object\n                        for storing richer annotation (this will default to\n                        the $feature->annotation() if it supports it)\n            -tagvalue_factory the object factory to use for creating tag/value\n                        pair representing objects\n\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  my ($feat,$anncoll,$fact) =\n\t$self->_rearrange([qw(FEATURE\n                          ANNOTATION\n                          TAGVALUE_FACTORY)], @args);\n\n  $self->feature($feat) if $feat;\n  $self->annotation($anncoll) if $feat;\n  $self->tagvalue_object_factory($fact) if $fact;\n\n  return $self;\n}\n\n=head2 feature\n\n Title   : feature\n Usage   : $obj->feature($newval)\n Function: Get/set the feature that this object adapts to an\n           AnnotationCollectionI.\n Example : \n Returns : value of feature (a Bio::SeqFeatureI compliant object)\n Args    : new value (a Bio::SeqFeatureI compliant object, optional)\n\n\n\nsub feature{\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'feature'} = $value;\n    }\n    return $self->{'feature'};\n}\n\n=head2 annotation\n\n Title   : annotation\n Usage   : $obj->annotation($newval)\n Function: Get/set the AnnotationCollectionI implementing object used by\n           this adaptor to store additional annotation that cannot be stored\n           by the SeqFeatureI itself.\n\n           If requested before having been set, the value will default to the\n           annotation object of the feature if it has one.\n Example : \n Returns : value of annotation (a Bio::AnnotationCollectionI compliant object)\n Args    : new value (a Bio::AnnotationCollectionI compliant object, optional)\n\n\n\nsub annotation{\n    my ($self,$value) = @_;\n\n    if( defined $value) {\n        $self->{'annotation'} = $value;\n    }\n    if((! exists($self->{'annotation'})) &&\n       $self->feature()->can('annotation')) {\n        return $self->feature()->annotation();\n    }\n    return $self->{'annotation'};\n}\n\n=head1 AnnotationCollectionI implementing methods\n\n\n=head2 get_all_annotation_keys\n\n Title   : get_all_annotation_keys\n Usage   : $ac->get_all_annotation_keys()\n Function: gives back a list of annotation keys, which are simple text strings\n Returns : list of strings\n Args    : none\n\n\nsub get_all_annotation_keys{\n    my ($self) = @_;\n    my @keys = ();\n    \n    # get the tags from the feature object\n    if ($self->feature()->can('get_all_tags')) {\n        push(@keys, $self->feature()->get_all_tags());\n    } else {\n        push(@keys, $self->feature()->all_tags());\n    }\n    # ask the annotation implementation in addition, while avoiding duplicates\n    if($self->annotation()) {\n\tpush(@keys,\n\t     grep { ! $self->feature->has_tag($_); }\n\t          $self->annotation()->get_all_annotation_keys());\n    }\n    # done\n    return @keys;\n}\n\n\n=head2 get_Annotations\n\n Title   : get_Annotations\n Usage   : my @annotations = $collection->get_Annotations('key')\n Function: Retrieves all the Bio::AnnotationI objects for a specific key\n Returns : list of Bio::AnnotationI - empty if no objects stored for a key\n Args    : string which is key for annotations\n\n\nsub get_Annotations{\n    my ($self, @keys) = @_;\n    my @anns = ();\n\n    # we need a annotation object factory\n    my $fact = $self->tagvalue_object_factory();\n\n    # get all tags if no keys have been provided\n    @keys = $self->feature->all_tags() unless @keys;\n\n    # build object for each value for each tag\n    foreach my $key (@keys) {\n      # protect against keys that aren't tags\n      next unless $self->feature->has_tag($key);\n      # add each tag/value pair as a SimpleValue object\n      foreach my $val ($self->feature()->get_tag_values($key)) {\n       my $ann;\n       if($fact) {\n          $ann = $fact->create_object(-value => $val, -tagname => $key);\n       } else {\n          $ann = Bio::Annotation::SimpleValue->new(-value => $val,\n                                                   -tagname => $key);\n       }\n       push(@anns, $ann);\n      }\n    }\n\n    # add what is in the annotation implementation if any\n    if($self->annotation()) {\n      push(@anns, $self->annotation->get_Annotations(@keys));\n    }\n\n    # done\n    return @anns;\n}\n\n=head2 get_num_of_annotations\n\n Title   : get_num_of_annotations\n Usage   : my $count = $collection->get_num_of_annotations()\n Function: Returns the count of all annotations stored in this collection \n Returns : integer\n Args    : none\n\n\n\nsub get_num_of_annotations{\n  my ($self) = @_;\n\n  # first, count the number of tags on the feature\n  my $num_anns = 0;\n\n  foreach ($self->feature()->all_tags()) {\n\t$num_anns += scalar( $self->feature()->each_tag_value($_));\n  }\n\n  # add from the annotation implementation if any\n  if($self->annotation()) {\n \t$num_anns += $self->annotation()->get_num_of_annotations();\n  }\n\n  # done\n  return $num_anns;\n}\n\n=head1 Implementation specific functions - to allow adding\n\n\n=head2 add_Annotation\n\n Title   : add_Annotation\n Usage   : $self->add_Annotation('reference',$object);\n           $self->add_Annotation($object,'Bio::MyInterface::DiseaseI');\n           $self->add_Annotation($object);\n           $self->add_Annotation('disease',$object,'Bio::MyInterface::DiseaseI');\n Function: Adds an annotation for a specific key.\n\n           If the key is omitted, the object to be added must provide a value\n           via its tagname().\n\n           If the archetype is provided, this and future objects added under\n           that tag have to comply with the archetype and will be rejected\n           otherwise.\n\n           This implementation will add all Bio::Annotation::SimpleValue\n           objects to the adapted features as tag/value pairs. Caveat: this\n           may potentially result in information loss if a derived object\n           is supplied.\n\n Returns : none\n Args    : annotation key ('disease', 'dblink', ...)\n           object to store (must be Bio::AnnotationI compliant)\n           [optional] object archetype to map future storage of object \n                      of these types to\n\n\nsub add_Annotation{\n    my ($self,$key,$object,$archetype) = @_;\n   \n    # if there's no key we use the tagname() as key\n    if(ref($key) && $key->isa(\"Bio::AnnotationI\") &&\n       (! ($object && ref($object)))) {\n\t$archetype = $object if $object;\n\t$object = $key;\n\t$key = $object->tagname();\n\t$key = $key->name() if $key && ref($key); # OntologyTermI\n\t$self->throw(\"Annotation object must have a tagname if key omitted\")\n\t    unless $key;\n    }\n    \n    if( !defined $object ) {\n\t$self->throw(\"Must have at least key and object in add_Annotation\");\n    }\n    \n    if( ! (ref($object) && $object->isa(\"Bio::AnnotationI\")) ) {\n\t$self->throw(\"object must be a Bio::AnnotationI compliant object, otherwise we wont add it!\");\n    }\n    \n    # ready to add -- if it's a SimpleValue, we add to the feature's tags,\n    # otherwise we'll add to the annotation collection implementation\n\n    if($object->isa(\"Bio::Annotation::SimpleValue\") &&\n       $self->feature()->can('add_tag_value')) {\n\treturn $self->feature()->add_tag_value($key, $object->value());\n    } else {\n\tmy $anncoll = $self->annotation();\n\tif(! $anncoll) {\n\t    $anncoll = Bio::Annotation::Collection->new();\n\t    $self->annotation($anncoll);\n\t}\n\tif($anncoll->can('add_Annotation')) {\n\t    return $anncoll->add_Annotation($key,$object,$archetype);\n\t}\n\t$self->throw(\"Annotation implementation does not allow adding!\");\n    }\n}\n\n=head2 remove_Annotations\n\n Title   : remove_Annotations\n Usage   :\n Function: Remove the annotations for the specified key from this\n           collection.\n\n           If the key happens to be a tag, then the tag is removed\n           from the feature.\n\n Example :\n Returns : an array Bio::AnnotationI compliant objects which were stored\n           under the given key(s)\n Args    : the key(s) (tag name(s), one or more strings) for which to\n           remove annotations (optional; if none given, flushes all\n           annotations)","parameters":[{"label":"$self"},{"label":"@keys"}]},"containerName":"main::","definition":"sub","line":445,"children":[{"line":446,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"remove_Annotations"},{"line":446,"kind":13,"containerName":"remove_Annotations","name":"@keys"},{"line":449,"kind":13,"name":"@keys","containerName":"remove_Annotations"},{"line":449,"kind":13,"name":"$self","containerName":"remove_Annotations"},{"kind":12,"line":449,"name":"get_all_annotation_keys","containerName":"remove_Annotations"},{"containerName":"remove_Annotations","name":"@keys","kind":13,"line":449},{"kind":13,"line":451,"containerName":"remove_Annotations","name":"@anns","definition":"my","localvar":"my"},{"kind":13,"line":451,"containerName":"remove_Annotations","name":"$self"},{"name":"get_Annotations","containerName":"remove_Annotations","kind":12,"line":451},{"containerName":"remove_Annotations","name":"@keys","kind":13,"line":451},{"definition":"my","name":"$key","containerName":"remove_Annotations","localvar":"my","kind":13,"line":453},{"containerName":"remove_Annotations","name":"@keys","line":453,"kind":13},{"line":455,"kind":13,"containerName":"remove_Annotations","name":"$self"},{"kind":12,"line":455,"containerName":"remove_Annotations","name":"feature"},{"line":455,"kind":12,"containerName":"remove_Annotations","name":"remove_tag"},{"name":"$key","containerName":"remove_Annotations","kind":13,"line":455},{"line":455,"kind":13,"containerName":"remove_Annotations","name":"$self"},{"containerName":"remove_Annotations","name":"feature","kind":12,"line":455},{"name":"has_tag","containerName":"remove_Annotations","line":455,"kind":12},{"name":"$key","containerName":"remove_Annotations","line":455,"kind":13},{"line":457,"kind":13,"localvar":"my","name":"$anncoll","definition":"my","containerName":"remove_Annotations"},{"line":457,"kind":13,"name":"$self","containerName":"remove_Annotations"},{"name":"annotation","containerName":"remove_Annotations","kind":12,"line":457},{"name":"$anncoll","containerName":"remove_Annotations","line":458,"kind":13},{"name":"$anncoll","containerName":"remove_Annotations","line":458,"kind":13},{"name":"can","containerName":"remove_Annotations","kind":12,"line":458},{"kind":13,"line":459,"containerName":"remove_Annotations","name":"$anncoll"},{"name":"remove_Annotations","containerName":"remove_Annotations","line":459,"kind":12},{"name":"$key","containerName":"remove_Annotations","line":459,"kind":13},{"kind":13,"line":460,"name":"$anncoll","containerName":"remove_Annotations"},{"line":461,"kind":13,"name":"$self","containerName":"remove_Annotations"},{"line":461,"kind":12,"containerName":"remove_Annotations","name":"warn"},{"kind":13,"line":461,"containerName":"remove_Annotations","name":"$anncoll"},{"name":"@anns","containerName":"remove_Annotations","kind":13,"line":465}],"kind":12},{"children":[{"kind":13,"line":493,"name":"$self","definition":"my","containerName":"tagvalue_object_factory","localvar":"my"},{"containerName":"tagvalue_object_factory","name":"$value","kind":13,"line":493},{"name":"$value","containerName":"tagvalue_object_factory","kind":13,"line":494},{"line":495,"kind":13,"name":"$self","containerName":"tagvalue_object_factory"},{"kind":13,"line":495,"name":"$value","containerName":"tagvalue_object_factory"},{"containerName":"tagvalue_object_factory","name":"$self","kind":13,"line":497}],"line":492,"kind":12,"signature":{"label":"tagvalue_object_factory($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: AnnotationAdaptor.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::AnnotationAdaptor\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp at gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n#\n# (c) Hilmar Lapp, hlapp at gmx.net, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n# \n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::AnnotationAdaptor - integrates SeqFeatureIs annotation\n\n=head1 SYNOPSIS\n\n   use Bio::SeqFeature::Generic;\n   use Bio::SeqFeature::AnnotationAdaptor;\n\n   # obtain a SeqFeatureI implementing object somehow\n   my $feat = Bio::SeqFeature::Generic->new(-start => 10, -end => 20);\n\n   # add tag/value annotation\n   $feat->add_tag_value(\"mytag\", \"value of tag mytag\");\n   $feat->add_tag_value(\"mytag\", \"another value of tag mytag\");\n\n   # Bio::SeqFeature::Generic also provides annotation(), which returns a\n   # Bio::AnnotationCollectionI compliant object\n   $feat->annotation->add_Annotation(\"dbxref\", $dblink);\n\n   # to integrate tag/value annotation with AnnotationCollectionI\n   # annotation, use this adaptor, which also implements \n   # Bio::AnnotationCollectionI\n   my $anncoll = Bio::SeqFeature::AnnotationAdaptor->new(-feature => $feat);\n\n   # this will now return tag/value pairs as \n   # Bio::Annotation::SimpleValue objects\n   my @anns = $anncoll->get_Annotations(\"mytag\");\n   # other added before annotation is available too\n   my @dblinks = $anncoll->get_Annotations(\"dbxref\");\n\n   # also supports transparent adding of tag/value pairs in \n   # Bio::AnnotationI flavor\n   my $tagval = Bio::Annotation::SimpleValue->new(-value => \"some value\",\n                                                  -tagname => \"some tag\");\n   $anncoll->add_Annotation($tagval);\n   # this is now also available from the feature's tag/value system\n   my @vals = $feat->each_tag_value(\"some tag\");\n\n=head1 DESCRIPTION\n\nL<Bio::SeqFeatureI> defines light-weight annotation of features\nthrough tag/value pairs. Conversely, L<Bio::AnnotationCollectionI>\ntogether with L<Bio::AnnotationI> defines an annotation bag, which is\nbetter typed, but more heavy-weight because it contains every single\npiece of annotation as objects. The frequently used base\nimplementation of Bio::SeqFeatureI, Bio::SeqFeature::Generic, defines\nan additional slot for AnnotationCollectionI-compliant annotation.\n\nThis adaptor provides a L<Bio::AnnotationCollectionI> compliant,\nunified, and integrated view on the annotation of L<Bio::SeqFeatureI>\nobjects, including tag/value pairs, and annotation through the\nannotation() method, if the object supports it. Code using this\nadaptor does not need to worry about the different ways of possibly\nannotating a SeqFeatureI object, but can instead assume that it\nstrictly follows the AnnotationCollectionI scheme. The price to pay is\nthat retrieving and adding annotation will always use objects instead\nof light-weight tag/value pairs.\n\nIn other words, this adaptor allows us to keep the best of both\nworlds. If you create tens of thousands of feature objects, and your\nonly annotation is tag/value pairs, you are best off using the\nfeatures' native tag/value system. If you create a smaller number of\nfeatures, but with rich and typed annotation mixed with tag/value\npairs, this adaptor may be for you. Since its implementation is by\ndouble-composition, you only need to create one instance of the\nadaptor. In order to transparently annotate a feature object, set the\nfeature using the feature() method. Every annotation you add will be\nadded to the feature object, and hence will not be lost when you set\nfeature() to the next object.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp at gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n#' Let the code begin...\n\n\npackage Bio::SeqFeature::AnnotationAdaptor;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Annotation::SimpleValue;\n\nuse base qw(Bio::Root::Root Bio::AnnotationCollectionI Bio::AnnotatableI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SeqFeature::AnnotationAdaptor->new();\n Function: Builds a new Bio::SeqFeature::AnnotationAdaptor object \n Returns : an instance of Bio::SeqFeature::AnnotationAdaptor\n Args    : Named parameters\n            -feature    the Bio::SeqFeatureI implementing object to adapt\n                        (mandatory to be passed here, or set via feature()\n                        before calling other methods)\n            -annotation the Bio::AnnotationCollectionI implementing object\n                        for storing richer annotation (this will default to\n                        the $feature->annotation() if it supports it)\n            -tagvalue_factory the object factory to use for creating tag/value\n                        pair representing objects\n\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  my ($feat,$anncoll,$fact) =\n\t$self->_rearrange([qw(FEATURE\n                          ANNOTATION\n                          TAGVALUE_FACTORY)], @args);\n\n  $self->feature($feat) if $feat;\n  $self->annotation($anncoll) if $feat;\n  $self->tagvalue_object_factory($fact) if $fact;\n\n  return $self;\n}\n\n=head2 feature\n\n Title   : feature\n Usage   : $obj->feature($newval)\n Function: Get/set the feature that this object adapts to an\n           AnnotationCollectionI.\n Example : \n Returns : value of feature (a Bio::SeqFeatureI compliant object)\n Args    : new value (a Bio::SeqFeatureI compliant object, optional)\n\n\n\nsub feature{\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'feature'} = $value;\n    }\n    return $self->{'feature'};\n}\n\n=head2 annotation\n\n Title   : annotation\n Usage   : $obj->annotation($newval)\n Function: Get/set the AnnotationCollectionI implementing object used by\n           this adaptor to store additional annotation that cannot be stored\n           by the SeqFeatureI itself.\n\n           If requested before having been set, the value will default to the\n           annotation object of the feature if it has one.\n Example : \n Returns : value of annotation (a Bio::AnnotationCollectionI compliant object)\n Args    : new value (a Bio::AnnotationCollectionI compliant object, optional)\n\n\n\nsub annotation{\n    my ($self,$value) = @_;\n\n    if( defined $value) {\n        $self->{'annotation'} = $value;\n    }\n    if((! exists($self->{'annotation'})) &&\n       $self->feature()->can('annotation')) {\n        return $self->feature()->annotation();\n    }\n    return $self->{'annotation'};\n}\n\n=head1 AnnotationCollectionI implementing methods\n\n\n=head2 get_all_annotation_keys\n\n Title   : get_all_annotation_keys\n Usage   : $ac->get_all_annotation_keys()\n Function: gives back a list of annotation keys, which are simple text strings\n Returns : list of strings\n Args    : none\n\n\nsub get_all_annotation_keys{\n    my ($self) = @_;\n    my @keys = ();\n    \n    # get the tags from the feature object\n    if ($self->feature()->can('get_all_tags')) {\n        push(@keys, $self->feature()->get_all_tags());\n    } else {\n        push(@keys, $self->feature()->all_tags());\n    }\n    # ask the annotation implementation in addition, while avoiding duplicates\n    if($self->annotation()) {\n\tpush(@keys,\n\t     grep { ! $self->feature->has_tag($_); }\n\t          $self->annotation()->get_all_annotation_keys());\n    }\n    # done\n    return @keys;\n}\n\n\n=head2 get_Annotations\n\n Title   : get_Annotations\n Usage   : my @annotations = $collection->get_Annotations('key')\n Function: Retrieves all the Bio::AnnotationI objects for a specific key\n Returns : list of Bio::AnnotationI - empty if no objects stored for a key\n Args    : string which is key for annotations\n\n\nsub get_Annotations{\n    my ($self, @keys) = @_;\n    my @anns = ();\n\n    # we need a annotation object factory\n    my $fact = $self->tagvalue_object_factory();\n\n    # get all tags if no keys have been provided\n    @keys = $self->feature->all_tags() unless @keys;\n\n    # build object for each value for each tag\n    foreach my $key (@keys) {\n      # protect against keys that aren't tags\n      next unless $self->feature->has_tag($key);\n      # add each tag/value pair as a SimpleValue object\n      foreach my $val ($self->feature()->get_tag_values($key)) {\n       my $ann;\n       if($fact) {\n          $ann = $fact->create_object(-value => $val, -tagname => $key);\n       } else {\n          $ann = Bio::Annotation::SimpleValue->new(-value => $val,\n                                                   -tagname => $key);\n       }\n       push(@anns, $ann);\n      }\n    }\n\n    # add what is in the annotation implementation if any\n    if($self->annotation()) {\n      push(@anns, $self->annotation->get_Annotations(@keys));\n    }\n\n    # done\n    return @anns;\n}\n\n=head2 get_num_of_annotations\n\n Title   : get_num_of_annotations\n Usage   : my $count = $collection->get_num_of_annotations()\n Function: Returns the count of all annotations stored in this collection \n Returns : integer\n Args    : none\n\n\n\nsub get_num_of_annotations{\n  my ($self) = @_;\n\n  # first, count the number of tags on the feature\n  my $num_anns = 0;\n\n  foreach ($self->feature()->all_tags()) {\n\t$num_anns += scalar( $self->feature()->each_tag_value($_));\n  }\n\n  # add from the annotation implementation if any\n  if($self->annotation()) {\n \t$num_anns += $self->annotation()->get_num_of_annotations();\n  }\n\n  # done\n  return $num_anns;\n}\n\n=head1 Implementation specific functions - to allow adding\n\n\n=head2 add_Annotation\n\n Title   : add_Annotation\n Usage   : $self->add_Annotation('reference',$object);\n           $self->add_Annotation($object,'Bio::MyInterface::DiseaseI');\n           $self->add_Annotation($object);\n           $self->add_Annotation('disease',$object,'Bio::MyInterface::DiseaseI');\n Function: Adds an annotation for a specific key.\n\n           If the key is omitted, the object to be added must provide a value\n           via its tagname().\n\n           If the archetype is provided, this and future objects added under\n           that tag have to comply with the archetype and will be rejected\n           otherwise.\n\n           This implementation will add all Bio::Annotation::SimpleValue\n           objects to the adapted features as tag/value pairs. Caveat: this\n           may potentially result in information loss if a derived object\n           is supplied.\n\n Returns : none\n Args    : annotation key ('disease', 'dblink', ...)\n           object to store (must be Bio::AnnotationI compliant)\n           [optional] object archetype to map future storage of object \n                      of these types to\n\n\nsub add_Annotation{\n    my ($self,$key,$object,$archetype) = @_;\n   \n    # if there's no key we use the tagname() as key\n    if(ref($key) && $key->isa(\"Bio::AnnotationI\") &&\n       (! ($object && ref($object)))) {\n\t$archetype = $object if $object;\n\t$object = $key;\n\t$key = $object->tagname();\n\t$key = $key->name() if $key && ref($key); # OntologyTermI\n\t$self->throw(\"Annotation object must have a tagname if key omitted\")\n\t    unless $key;\n    }\n    \n    if( !defined $object ) {\n\t$self->throw(\"Must have at least key and object in add_Annotation\");\n    }\n    \n    if( ! (ref($object) && $object->isa(\"Bio::AnnotationI\")) ) {\n\t$self->throw(\"object must be a Bio::AnnotationI compliant object, otherwise we wont add it!\");\n    }\n    \n    # ready to add -- if it's a SimpleValue, we add to the feature's tags,\n    # otherwise we'll add to the annotation collection implementation\n\n    if($object->isa(\"Bio::Annotation::SimpleValue\") &&\n       $self->feature()->can('add_tag_value')) {\n\treturn $self->feature()->add_tag_value($key, $object->value());\n    } else {\n\tmy $anncoll = $self->annotation();\n\tif(! $anncoll) {\n\t    $anncoll = Bio::Annotation::Collection->new();\n\t    $self->annotation($anncoll);\n\t}\n\tif($anncoll->can('add_Annotation')) {\n\t    return $anncoll->add_Annotation($key,$object,$archetype);\n\t}\n\t$self->throw(\"Annotation implementation does not allow adding!\");\n    }\n}\n\n=head2 remove_Annotations\n\n Title   : remove_Annotations\n Usage   :\n Function: Remove the annotations for the specified key from this\n           collection.\n\n           If the key happens to be a tag, then the tag is removed\n           from the feature.\n\n Example :\n Returns : an array Bio::AnnotationI compliant objects which were stored\n           under the given key(s)\n Args    : the key(s) (tag name(s), one or more strings) for which to\n           remove annotations (optional; if none given, flushes all\n           annotations)\n\n\n\nsub remove_Annotations{\n    my ($self, @keys) = @_;\n\n    # set to all keys if none are supplied\n    @keys = $self->get_all_annotation_keys() unless @keys;\n    # collect existing annotation\n    my @anns = $self->get_Annotations(@keys);\n    # flush\n    foreach my $key (@keys) {\n\t# delete the tag if it is one\n\t$self->feature->remove_tag($key) if $self->feature->has_tag($key);\n\t# and delegate to the annotation implementation \n\tmy $anncoll = $self->annotation();\n\tif($anncoll && $anncoll->can('remove_Annotations')) {\n\t    $anncoll->remove_Annotations($key);\n\t} elsif($anncoll) {\n\t    $self->warn(\"Annotation bundle implementation \".ref($anncoll).\n\t\t\t\" does not allow remove!\");\n\t}\n    }\n    return @anns;\n}\n\n=head1 Additional methods\n\n\n=head2 tagvalue_object_factory\n\n Title   : tagvalue_object_factory\n Usage   : $obj->tagval_object_factory($newval)\n Function: Get/set the object factory to use for creating objects that\n           represent tag/value pairs (e.g.,\n           Bio::Annotation::SimpleValue).\n\n           The object to be created is expected to follow\n           Bio::Annotation::SimpleValue in terms of supported\n           arguments at creation time, and the methods.\n\n Example : \n Returns : A Bio::Factory::ObjectFactoryI compliant object\n Args    : new value (a Bio::Factory::ObjectFactoryI compliant object, \n           optional)"},"detail":"($self,$value)","definition":"sub","containerName":"main::","range":{"end":{"line":498,"character":9999},"start":{"character":0,"line":492}},"name":"tagvalue_object_factory"}],"version":5}