{"vars":[{"kind":2,"line":127,"name":"base","containerName":""},{"name":"new","range":{"end":{"character":9999,"line":246},"start":{"character":0,"line":170}},"definition":"sub","containerName":"main::","signature":{"documentation":"1;\n# $Id: SeqWithQuality.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Seq::QualI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chad Matsalla <bioinformatics@dieselwurks.com\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::SeqWithQuality - Bioperl object packaging a sequence with its quality.\nDeprecated class, use Bio::Seq::Quality instead!\n\n=head1 SYNOPSIS\n\n    use Bio::PrimarySeq;\n    use Bio::Seq::PrimaryQual;\n    use Bio::Seq::SeqWithQuality;\n\n    # make from memory\n    my $qual = Bio::Seq::SeqWithQuality->new\n    ( -qual => '10 20 30 40 50 50 20 10',\n      -seq => 'ATCGATCG',\n      -id  => 'human_id',\n      -accession_number => 'AL000012',\n    );\n\n    # make from objects\n    # first, make a PrimarySeq object\n    my $seqobj = Bio::PrimarySeq->new\n    ( -seq => 'atcgatcg',\n      -id  => 'GeneFragment-12',\n      -accession_number => 'X78121',\n      -alphabet => 'dna'\n    );\n\n    # now make a PrimaryQual object\n    my $qualobj = Bio::Seq::PrimaryQual->new\n    ( -qual => '10 20 30 40 50 50 20 10',\n      -id  => 'GeneFragment-12',\n      -accession_number => 'X78121',\n      -alphabet => 'dna'\n    );\n\n    # now make the SeqWithQuality object\n    my $swqobj = Bio::Seq::SeqWithQuality->new\n    ( -seq  => $seqobj,\n      -qual => $qualobj\n    );\n    # done!\n\n    $swqobj->id(); # the id of the SeqWithQuality object\n    # may not match the the id of the sequence or\n    # of the quality (check the pod, luke)\n    $swqobj->seq(); # the sequence of the SeqWithQuality object\n    $swqobj->qual(); # the quality of the SeqWithQuality object\n\n    # to get out parts of the sequence.\n\n    print \"Sequence \", $seqobj->id(), \" with accession \",\n    $seqobj->accession, \" and desc \", $seqobj->desc, \"\\n\";\n\n    $string2 = $seqobj->subseq(1,40);\n\n=head1 DESCRIPTION\n\nThis object stores base quality values together with the sequence string.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nEmail bioinformatics@dieselwurks.com\n\n=head1 CONTRIBUTORS \n\nJason Stajich, jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\npackage Bio::Seq::SeqWithQuality;\n\n\nuse strict;\nuse Bio::PrimarySeq;\nuse Bio::Seq::PrimaryQual;\n\nuse base qw(Bio::Root::Root Bio::PrimarySeqI Bio::Seq::QualI);\n\n=head2 new()\n\n Title   : new()\n Usage   : $qual = Bio::Seq::SeqWithQuality ->new\n             ( -qual => '10 20 30 40 50 50 20 10',\n               -seq => 'ATCGATCG',\n               -id  => 'human_id',\n               -accession_number => 'AL000012',\n               -trace_indices    => '0 5 10 15 20 25 30 35'\n             );\n Function: Returns a new Bio::Seq::SeqWithQual object from basic\n           constructors.\n Returns : a new Bio::Seq::PrimaryQual object\n Args    : -qual can be a quality string (see Bio::Seq::PrimaryQual for more\n            information on this) or a reference to a Bio::Seq::PrimaryQual\n            object.\n           -seq can be a sequence string (see Bio::PrimarySeq for more\n            information on this) or a reference to a Bio::PrimaryQual object.\n           -seq, -id, -accession_number, -primary_id, -desc, -id behave like\n            this:\n             1. if they are provided on construction of the\n                 Bio::Seq::SeqWithQuality they will be set as the descriptors for\n                 the object unless changed by one of the following mechanisms:\n              a) $obj->set_common_descriptors() is used and both the -seq and\n                 the -qual object have the same descriptors. These common\n                 descriptors will then become the descriptors for the\n                 Bio::Seq::SeqWithQual object.\n              b) the descriptors are manually set using the seq(), id(),\n                 desc(), or accession_number(), primary_id(),\n             2. if no descriptors are provided, the new() constructor will see\n                if the descriptor used in the PrimarySeq and in the\n                PrimaryQual objects match. If they do, they will become\n                the descriptors for the SeqWithQuality object.\n             To eliminate ambiguity, I strongly suggest you set the\n             descriptors manually on construction of the object. Really.\n           -trace_indices : a space_delimited list of trace indices\n            (where would the peaks be drawn if this list of qualities\n            was to be plotted?)","parameters":[{"label":"$class"},{"label":"@args"}],"label":"new($class,@args)"},"detail":"($class,@args)","kind":12,"children":[{"definition":"my","name":"$class","containerName":"new","localvar":"my","kind":13,"line":171},{"containerName":"new","name":"@args","line":171,"kind":13},{"localvar":"my","containerName":"new","definition":"my","name":"$self","line":172,"kind":13},{"name":"$class","containerName":"new","line":172,"kind":13},{"kind":13,"line":172,"containerName":"new","name":"@args"},{"kind":13,"line":174,"name":"$self","containerName":"new"},{"line":175,"kind":13,"localvar":"my","containerName":"new","definition":"my","name":"$qual"},{"line":175,"kind":13,"containerName":"new","name":"$seq"},{"containerName":"new","name":"$id","line":175,"kind":13},{"kind":13,"line":175,"name":"$acc","containerName":"new"},{"name":"$pid","containerName":"new","kind":13,"line":175},{"containerName":"new","name":"$desc","kind":13,"line":175},{"kind":13,"line":175,"containerName":"new","name":"$given_id"},{"name":"$alphabet","containerName":"new","kind":13,"line":175},{"kind":13,"line":175,"containerName":"new","name":"$trace_indices"},{"kind":13,"line":176,"containerName":"new","name":"$self"},{"containerName":"new","name":"_rearrange","kind":12,"line":176},{"containerName":"new","name":"@args","kind":13,"line":177},{"line":179,"kind":13,"name":"$id","containerName":"new"},{"kind":13,"line":179,"containerName":"new","name":"$given_id"},{"containerName":"new","name":"$id","line":180,"kind":13},{"line":180,"kind":13,"containerName":"new","name":"$given_id"},{"containerName":"new","name":"$self","kind":13,"line":181},{"line":181,"kind":12,"containerName":"new","name":"throw"},{"line":184,"kind":13,"name":"$given_id","containerName":"new"},{"name":"$self","containerName":"new","line":185,"kind":13},{"name":"display_id","containerName":"new","line":185,"kind":12},{"containerName":"new","name":"$given_id","kind":13,"line":185},{"containerName":"new","name":"$id","kind":13,"line":186},{"line":186,"kind":13,"containerName":"new","name":"$given_id"},{"name":"$seq","containerName":"new","line":189,"kind":13},{"definition":"my","name":"$id","containerName":"new","localvar":"my","kind":13,"line":190},{"line":191,"kind":13,"name":"$self","containerName":"new"},{"line":192,"kind":13,"containerName":"new","name":"$self"},{"line":192,"kind":12,"name":"warn","containerName":"new"},{"line":196,"kind":13,"name":"$alphabet","containerName":"new"},{"containerName":"new","name":"$self","line":197,"kind":13},{"containerName":"new","name":"throw","kind":12,"line":197},{"containerName":"new","name":"$self","line":202,"kind":13},{"line":202,"kind":12,"containerName":"new","name":"new"},{"line":203,"kind":13,"name":"$acc","containerName":"new"},{"containerName":"new","name":"$pid","line":204,"kind":13},{"line":205,"kind":13,"containerName":"new","name":"$desc"},{"name":"$id","containerName":"new","line":206,"kind":13},{"containerName":"new","name":"$alphabet","line":207,"kind":13},{"containerName":"new","name":"$seq","kind":13,"line":208},{"containerName":"new","name":"isa","line":208,"kind":12},{"kind":13,"line":208,"name":"$seq","containerName":"new"},{"name":"isa","containerName":"new","kind":12,"line":208},{"containerName":"new","name":"$self","line":209,"kind":13},{"kind":13,"line":209,"containerName":"new","name":"$seq"},{"line":210,"kind":13,"name":"$seq","containerName":"new"},{"line":211,"kind":13,"name":"$self","containerName":"new"},{"kind":12,"line":211,"name":"throw","containerName":"new"},{"localvar":"my","definition":"my","name":"$seqobj","containerName":"new","line":215,"kind":13},{"name":"new","containerName":"new","kind":12,"line":215},{"line":215,"kind":13,"name":"$seq","containerName":"new"},{"kind":13,"line":216,"name":"$acc","containerName":"new"},{"kind":13,"line":217,"containerName":"new","name":"$pid"},{"line":218,"kind":13,"containerName":"new","name":"$desc"},{"line":219,"kind":13,"name":"$id","containerName":"new"},{"containerName":"new","name":"$self","line":220,"kind":13},{"kind":13,"line":220,"containerName":"new","name":"$seqobj"},{"kind":13,"line":223,"name":"$qual","containerName":"new"},{"name":"$self","containerName":"new","line":224,"kind":13},{"line":224,"kind":12,"containerName":"new","name":"new"},{"line":225,"kind":13,"containerName":"new","name":"$acc"},{"name":"$pid","containerName":"new","kind":13,"line":226},{"name":"$desc","containerName":"new","line":227,"kind":13},{"kind":13,"line":228,"containerName":"new","name":"$id"},{"containerName":"new","name":"$qual","line":229,"kind":13},{"name":"$self","containerName":"new","line":230,"kind":13},{"line":230,"kind":13,"containerName":"new","name":"$qual"},{"kind":13,"line":232,"containerName":"new","name":"$qualobj","definition":"my","localvar":"my"},{"name":"new","containerName":"new","kind":12,"line":232},{"containerName":"new","name":"$qual","kind":13,"line":232},{"kind":13,"line":233,"containerName":"new","name":"$acc"},{"containerName":"new","name":"$pid","kind":13,"line":234},{"line":235,"kind":13,"containerName":"new","name":"$desc"},{"kind":13,"line":236,"name":"$id","containerName":"new"},{"kind":13,"line":237,"containerName":"new","name":"$trace_indices"},{"containerName":"new","name":"$self","kind":13,"line":238},{"line":238,"kind":13,"name":"$qualobj","containerName":"new"},{"containerName":"new","name":"$self","kind":13,"line":241},{"containerName":"new","name":"_set_descriptors","line":241,"kind":12},{"name":"$qual","containerName":"new","line":241,"kind":13},{"line":241,"kind":13,"containerName":"new","name":"$seq"},{"line":241,"kind":13,"containerName":"new","name":"$id"},{"name":"$acc","containerName":"new","line":241,"kind":13},{"name":"$pid","containerName":"new","line":241,"kind":13},{"line":241,"kind":13,"name":"$desc","containerName":"new"},{"containerName":"new","name":"$given_id","kind":13,"line":241},{"line":241,"kind":13,"name":"$alphabet","containerName":"new"},{"kind":13,"line":242,"name":"$self","containerName":"new"},{"containerName":"new","name":"length","kind":12,"line":242},{"line":243,"kind":13,"containerName":"new","name":"$self"},{"line":243,"kind":12,"name":"deprecated","containerName":"new"},{"name":"$self","containerName":"new","line":245,"kind":13}],"line":170},{"name":"SUPER","containerName":"new","line":172,"kind":12},{"kind":12,"line":174,"name":"supress_warnings"},{"name":"supress_warnings","kind":12,"line":191},{"name":"seq_ref","line":202,"kind":12},{"kind":12,"line":202,"containerName":"PrimarySeq","name":"Bio"},{"name":"seq_ref","kind":12,"line":209},{"line":215,"kind":12,"containerName":"PrimarySeq","name":"Bio"},{"name":"seq_ref","kind":12,"line":220},{"line":224,"kind":12,"name":"qual_ref"},{"name":"Bio","containerName":"Seq::PrimaryQual","line":224,"kind":12},{"line":230,"kind":12,"name":"qual_ref"},{"name":"Bio","containerName":"Seq::PrimaryQual","line":232,"kind":12},{"line":238,"kind":12,"name":"qual_ref"},{"range":{"end":{"line":268,"character":9999},"start":{"line":259,"character":0}},"name":"_common_id","definition":"sub","containerName":"main::","children":[{"localvar":"my","containerName":"_common_id","name":"$self","definition":"my","line":260,"kind":13},{"name":"$self","containerName":"_common_id","line":261,"kind":13},{"containerName":"_common_id","name":"$self","kind":13,"line":261},{"line":262,"kind":13,"localvar":"my","containerName":"_common_id","definition":"my","name":"$sid"},{"line":262,"kind":13,"name":"$self","containerName":"_common_id"},{"line":262,"kind":12,"name":"display_id","containerName":"_common_id"},{"name":"$sid","containerName":"_common_id","kind":13,"line":263},{"containerName":"_common_id","name":"$self","line":264,"kind":13},{"line":264,"kind":12,"name":"display_id","containerName":"_common_id"},{"line":265,"kind":13,"containerName":"_common_id","name":"$sid"},{"containerName":"_common_id","name":"$sid","kind":13,"line":265},{"kind":13,"line":265,"name":"$self","containerName":"_common_id"},{"containerName":"_common_id","name":"display_id","line":265,"kind":12}],"line":259,"kind":12},{"kind":12,"line":261,"name":"seq_ref"},{"kind":12,"line":261,"name":"qual_ref"},{"line":262,"kind":12,"name":"seq_ref"},{"kind":12,"line":264,"name":"qual_ref"},{"name":"qual_ref","kind":12,"line":265},{"name":"_common_display_id","definition":"sub","containerName":"main::","range":{"start":{"line":281,"character":0},"end":{"line":284,"character":9999}},"kind":12,"children":[{"kind":13,"line":282,"name":"$self","definition":"my","containerName":"_common_display_id","localvar":"my"},{"line":283,"kind":13,"containerName":"_common_display_id","name":"$self"},{"kind":12,"line":283,"containerName":"_common_display_id","name":"common_id"}],"line":281},{"kind":12,"line":297,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"_common_accession_number","line":298,"kind":13},{"line":299,"kind":13,"containerName":"_common_accession_number","name":"$self"},{"name":"$self","containerName":"_common_accession_number","kind":13,"line":299},{"localvar":"my","containerName":"_common_accession_number","name":"$acc","definition":"my","line":300,"kind":13},{"kind":13,"line":300,"containerName":"_common_accession_number","name":"$self"},{"name":"accession_number","containerName":"_common_accession_number","line":300,"kind":12},{"kind":13,"line":302,"containerName":"_common_accession_number","name":"$acc"},{"name":"$acc","containerName":"_common_accession_number","kind":13,"line":304},{"containerName":"_common_accession_number","name":"$acc","line":304,"kind":13},{"containerName":"_common_accession_number","name":"$self","line":304,"kind":13},{"containerName":"_common_accession_number","name":"accession_number","line":304,"kind":12}],"containerName":"main::","name":"_common_accession_number","definition":"sub","range":{"start":{"line":297,"character":0},"end":{"character":9999,"line":307}}},{"line":299,"kind":12,"name":"seq_ref"},{"line":299,"kind":12,"name":"qual_ref"},{"line":300,"kind":12,"name":"seq_ref"},{"kind":12,"line":304,"name":"qual_ref"},{"children":[{"kind":13,"line":321,"containerName":"_common_primary_id","definition":"my","name":"$self","localvar":"my"},{"name":"$self","containerName":"_common_primary_id","kind":13,"line":322},{"kind":13,"line":322,"containerName":"_common_primary_id","name":"$self"},{"name":"$pid","definition":"my","containerName":"_common_primary_id","localvar":"my","kind":13,"line":323},{"kind":13,"line":323,"containerName":"_common_primary_id","name":"$self"},{"containerName":"_common_primary_id","name":"primary_id","line":323,"kind":12},{"kind":13,"line":324,"name":"$pid","containerName":"_common_primary_id"},{"line":325,"kind":13,"name":"$pid","containerName":"_common_primary_id"},{"name":"$pid","containerName":"_common_primary_id","line":325,"kind":13},{"kind":13,"line":325,"containerName":"_common_primary_id","name":"$self"},{"line":325,"kind":12,"containerName":"_common_primary_id","name":"primary_id"}],"line":320,"kind":12,"range":{"start":{"line":320,"character":0},"end":{"line":328,"character":9999}},"definition":"sub","name":"_common_primary_id","containerName":"main::"},{"line":322,"kind":12,"name":"seq_ref"},{"kind":12,"line":322,"name":"qual_ref"},{"name":"seq_ref","line":323,"kind":12},{"name":"qual_ref","line":325,"kind":12},{"kind":12,"children":[{"kind":13,"line":342,"containerName":"_common_desc","name":"$self","definition":"my","localvar":"my"},{"name":"$self","containerName":"_common_desc","line":343,"kind":13},{"kind":13,"line":343,"containerName":"_common_desc","name":"$self"},{"line":344,"kind":13,"localvar":"my","definition":"my","name":"$des","containerName":"_common_desc"},{"line":344,"kind":13,"name":"$self","containerName":"_common_desc"},{"line":344,"kind":12,"containerName":"_common_desc","name":"desc"},{"kind":13,"line":345,"name":"$des","containerName":"_common_desc"},{"line":346,"kind":13,"containerName":"_common_desc","name":"$des"},{"containerName":"_common_desc","name":"$des","line":346,"kind":13},{"containerName":"_common_desc","name":"$self","kind":13,"line":346},{"name":"desc","containerName":"_common_desc","kind":12,"line":346}],"line":341,"definition":"sub","name":"_common_desc","containerName":"main::","range":{"end":{"line":349,"character":9999},"start":{"line":341,"character":0}}},{"kind":12,"line":343,"name":"seq_ref"},{"kind":12,"line":343,"name":"qual_ref"},{"name":"seq_ref","kind":12,"line":344},{"line":346,"kind":12,"name":"qual_ref"},{"name":"set_common_descriptors","definition":"sub","containerName":"main::","range":{"end":{"line":372,"character":9999},"start":{"character":0,"line":364}},"kind":12,"children":[{"kind":13,"line":365,"containerName":"set_common_descriptors","name":"$self","definition":"my","localvar":"my"},{"kind":13,"line":366,"name":"$self","containerName":"set_common_descriptors"},{"kind":13,"line":366,"containerName":"set_common_descriptors","name":"$self"}],"line":364},{"line":366,"kind":12,"name":"seq_ref"},{"line":366,"kind":12,"name":"qual_ref"},{"children":[{"line":385,"kind":13,"localvar":"my","containerName":"alphabet","definition":"my","name":"$self"},{"name":"$self","containerName":"alphabet","kind":13,"line":386},{"kind":12,"line":386,"containerName":"alphabet","name":"alphabet"}],"line":384,"kind":12,"range":{"start":{"character":0,"line":384},"end":{"line":387,"character":9999}},"definition":"sub","name":"alphabet","containerName":"main::"},{"name":"seq_ref","kind":12,"line":386},{"detail":"($obj,$value)","signature":{"label":"display_id($obj,$value)","parameters":[{"label":"$obj"},{"label":"$value"}],"documentation":"1;\n# $Id: SeqWithQuality.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Seq::QualI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chad Matsalla <bioinformatics@dieselwurks.com\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::SeqWithQuality - Bioperl object packaging a sequence with its quality.\nDeprecated class, use Bio::Seq::Quality instead!\n\n=head1 SYNOPSIS\n\n    use Bio::PrimarySeq;\n    use Bio::Seq::PrimaryQual;\n    use Bio::Seq::SeqWithQuality;\n\n    # make from memory\n    my $qual = Bio::Seq::SeqWithQuality->new\n    ( -qual => '10 20 30 40 50 50 20 10',\n      -seq => 'ATCGATCG',\n      -id  => 'human_id',\n      -accession_number => 'AL000012',\n    );\n\n    # make from objects\n    # first, make a PrimarySeq object\n    my $seqobj = Bio::PrimarySeq->new\n    ( -seq => 'atcgatcg',\n      -id  => 'GeneFragment-12',\n      -accession_number => 'X78121',\n      -alphabet => 'dna'\n    );\n\n    # now make a PrimaryQual object\n    my $qualobj = Bio::Seq::PrimaryQual->new\n    ( -qual => '10 20 30 40 50 50 20 10',\n      -id  => 'GeneFragment-12',\n      -accession_number => 'X78121',\n      -alphabet => 'dna'\n    );\n\n    # now make the SeqWithQuality object\n    my $swqobj = Bio::Seq::SeqWithQuality->new\n    ( -seq  => $seqobj,\n      -qual => $qualobj\n    );\n    # done!\n\n    $swqobj->id(); # the id of the SeqWithQuality object\n    # may not match the the id of the sequence or\n    # of the quality (check the pod, luke)\n    $swqobj->seq(); # the sequence of the SeqWithQuality object\n    $swqobj->qual(); # the quality of the SeqWithQuality object\n\n    # to get out parts of the sequence.\n\n    print \"Sequence \", $seqobj->id(), \" with accession \",\n    $seqobj->accession, \" and desc \", $seqobj->desc, \"\\n\";\n\n    $string2 = $seqobj->subseq(1,40);\n\n=head1 DESCRIPTION\n\nThis object stores base quality values together with the sequence string.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nEmail bioinformatics@dieselwurks.com\n\n=head1 CONTRIBUTORS \n\nJason Stajich, jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\npackage Bio::Seq::SeqWithQuality;\n\n\nuse strict;\nuse Bio::PrimarySeq;\nuse Bio::Seq::PrimaryQual;\n\nuse base qw(Bio::Root::Root Bio::PrimarySeqI Bio::Seq::QualI);\n\n=head2 new()\n\n Title   : new()\n Usage   : $qual = Bio::Seq::SeqWithQuality ->new\n             ( -qual => '10 20 30 40 50 50 20 10',\n               -seq => 'ATCGATCG',\n               -id  => 'human_id',\n               -accession_number => 'AL000012',\n               -trace_indices    => '0 5 10 15 20 25 30 35'\n             );\n Function: Returns a new Bio::Seq::SeqWithQual object from basic\n           constructors.\n Returns : a new Bio::Seq::PrimaryQual object\n Args    : -qual can be a quality string (see Bio::Seq::PrimaryQual for more\n            information on this) or a reference to a Bio::Seq::PrimaryQual\n            object.\n           -seq can be a sequence string (see Bio::PrimarySeq for more\n            information on this) or a reference to a Bio::PrimaryQual object.\n           -seq, -id, -accession_number, -primary_id, -desc, -id behave like\n            this:\n             1. if they are provided on construction of the\n                 Bio::Seq::SeqWithQuality they will be set as the descriptors for\n                 the object unless changed by one of the following mechanisms:\n              a) $obj->set_common_descriptors() is used and both the -seq and\n                 the -qual object have the same descriptors. These common\n                 descriptors will then become the descriptors for the\n                 Bio::Seq::SeqWithQual object.\n              b) the descriptors are manually set using the seq(), id(),\n                 desc(), or accession_number(), primary_id(),\n             2. if no descriptors are provided, the new() constructor will see\n                if the descriptor used in the PrimarySeq and in the\n                PrimaryQual objects match. If they do, they will become\n                the descriptors for the SeqWithQuality object.\n             To eliminate ambiguity, I strongly suggest you set the\n             descriptors manually on construction of the object. Really.\n           -trace_indices : a space_delimited list of trace indices\n            (where would the peaks be drawn if this list of qualities\n            was to be plotted?)\n\n\nsub new {\n   my ($class, @args) = @_;\n   my $self = $class->SUPER::new(@args);\n   # default: turn OFF the warnings\n   $self->{supress_warnings} = 1;\n   my($qual,$seq,$id,$acc,$pid,$desc,$given_id,$alphabet,$trace_indices) =\n   $self->_rearrange([qw( QUAL SEQ DISPLAY_ID ACCESSION_NUMBER PRIMARY_ID DESC\n     ID ALPHABET TRACE_INDICES )], @args);\n   # Deal with the ID\n   if ( defined $id && defined $given_id ) {\n      if( $id ne $given_id ) {\n         $self->throw(\"Provided both id and display_id constructor functions. [$id] [$given_id]\");\n      }\n   }\n   if( defined $given_id ) {\n      $self->display_id($given_id);\n      $id = $given_id;\n   }\n   # Import sequence first\n   if (!$seq) {\n      my $id;\n      unless ($self->{supress_warnings} == 1) {\n         $self->warn(\"You did not provide sequence information during the \".\n           \"construction of a Bio::Seq::SeqWithQuality object. Sequence \".\n           \"components for this object will be empty.\");\n      }\n      if (!$alphabet) {\n         $self->throw(\"If you want me to create a PrimarySeq object for your \".\n           \"empty sequence <boggle> you must specify a -alphabet to satisfy \".\n           \"the constructor requirements for a Bio::PrimarySeq object with no \".\n           \"sequence. Read the POD for it, luke.\");\n      }\n      $self->{seq_ref} = Bio::PrimarySeq->new( -seq              =>  \"\",\n                                               -accession_number =>  $acc,\n                                               -primary_id       =>  $pid,\n                                               -desc             =>  $desc,\n                                               -display_id       =>  $id,\n                                               -alphabet         =>  $alphabet );\n   } elsif ($seq->isa('Bio::PrimarySeqI') || $seq->isa('Bio::SeqI')) {\n      $self->{seq_ref} = $seq;\n   } elsif (ref($seq)) {\n      $self->throw(\"You passed a seq argument into a SeqWithQUality object and\".\n        \" it was a reference ($seq) which did not inherit from Bio::SeqI or \".\n        \"Bio::PrimarySeqI. I don't know what to do with this!\");\n   } else {\n      my $seqobj = Bio::PrimarySeq->new( -seq              => $seq,\n                                         -accession_number => $acc,\n                                         -primary_id       => $pid,\n                                         -desc             => $desc,\n                                         -display_id       => $id   );\n      $self->{seq_ref} = $seqobj;\n   }\n   # Then import the quality scores\n   if (!defined($qual)) {\n      $self->{qual_ref} = Bio::Seq::PrimaryQual->new( -qual             => \"\",\n                                                      -accession_number => $acc,\n                                                      -primary_id       => $pid,\n                                                      -desc             => $desc,\n                                                      -display_id       => $id, );\n   } elsif (ref($qual) eq \"Bio::Seq::PrimaryQual\") {\n      $self->{qual_ref} = $qual;\n   } else {\n      my $qualobj = Bio::Seq::PrimaryQual->new( -qual             => $qual,\n                                                -accession_number => $acc,\n                                                -primary_id       => $pid,\n                                                -desc             => $desc,\n                                                -display_id       => $id,\n                                                -trace_indices    => $trace_indices );\n      $self->{qual_ref} = $qualobj;\n   }\n   # Now try to set the descriptors for this object\n   $self->_set_descriptors($qual,$seq,$id,$acc,$pid,$desc,$given_id,$alphabet);\n   $self->length();\n   $self->deprecated(\"deprecated class - use Bio::Seq::Quality instead\");\n\n   return $self;\n}\n\n=head2 _common_id()\n\n Title   : _common_id()\n Usage   : $common_id = $self->_common_id();\n Function: Compare the display_id of {qual_ref} and {seq_ref}.\n Returns : Nothing if they don't match. If they do return {seq_ref}->display_id()\n Args    : None.\n\n\n#'\nsub _common_id {\n   my $self = shift;\n   return if (!$self->{seq_ref} || !$self->{qual_ref});\n   my $sid = $self->{seq_ref}->display_id();\n   return if (!$sid);\n   return if (!$self->{qual_ref}->display_id());\n   return $sid if ($sid eq $self->{qual_ref}->display_id());\n   # should this become a warning?\n   # print(\"ids $sid and $self->{qual_ref}->display_id() do not match. Bummer.\\n\");\n}\n\n=head2 _common_display_id()\n\n Title   : _common_id()\n Usage   : $common_id = $self->_common_display_id();\n Function: Compare the display_id of {qual_ref} and {seq_ref}.\n Returns : Nothing if they don't match. If they do return {seq_ref}->display_id()\n Args    : None.\n\n\n#'\nsub _common_display_id {\n   my $self = shift;\n   $self->common_id();\n}\n\n=head2 _common_accession_number()\n\n Title   : _common_accession_number()\n Usage   : $common_id = $self->_common_accession_number();\n Function: Compare the accession_number() of {qual_ref} and {seq_ref}.\n Returns : Nothing if they don't match. If they do return {seq_ref}->accession_number()\n Args    : None.\n\n\n#'\nsub _common_accession_number {\n   my $self = shift;\n   return if ($self->{seq_ref} || $self->{qual_ref});\n   my $acc = $self->{seq_ref}->accession_number();\n   # if (!$acc) { print(\"the seqref has no acc.\\n\"); }\n   return if (!$acc);\n   # if ($acc eq $self->{qual_ref}->accession_number()) { print(\"$acc matches \".$self->{qual_ref}->accession_number().\"\\n\"); }\n   return $acc if ($acc eq $self->{qual_ref}->accession_number());\n   # should this become a warning?\n   # print(\"accession numbers $acc and $self->{qual_ref}->accession_number() do not match. Bummer.\\n\");\n}\n\n=head2 _common_primary_id()\n\n Title   : _common_primary_id()\n Usage   : $common_primard_id = $self->_common_primary_id();\n Function: Compare the primary_id of {qual_ref} and {seq_ref}.\n Returns : Nothing if they don't match. If they do return {seq_ref}->primary_id()\n Args    : None.\n\n\n#'\nsub _common_primary_id {\n   my $self = shift;\n   return if ($self->{seq_ref} || $self->{qual_ref});\n   my $pid = $self->{seq_ref}->primary_id();\n   return if (!$pid);\n   return $pid if ($pid eq $self->{qual_ref}->primary_id());\n   # should this become a warning?\n   # print(\"primary_ids $pid and $self->{qual_ref}->primary_id() do not match. Bummer.\\n\");\n}\n\n=head2 _common_desc()\n\n Title   : _common_desc()\n Usage   : $common_desc = $self->_common_desc();\n Function: Compare the desc of {qual_ref} and {seq_ref}.\n Returns : Nothing if they don't match. If they do return {seq_ref}->desc()\n Args    : None.\n\n\n#'\nsub _common_desc {\n   my $self = shift;\n   return if ($self->{seq_ref} || $self->{qual_ref});\n   my $des = $self->{seq_ref}->desc();\n   return if (!$des);\n   return $des if ($des eq $self->{qual_ref}->desc());\n   # should this become a warning?\n   # print(\"descriptions $des and $self->{qual_ref}->desc() do not match. Bummer.\\n\");\n}\n\n=head2 set_common_descriptors()\n\n Title   : set_common_descriptors()\n Usage   : $self->set_common_descriptors();\n Function: Compare the descriptors (id,accession_number,display_id,\n           primary_id, desc) for the PrimarySeq and PrimaryQual objects\n           within the SeqWithQuality object. If they match, make that\n           descriptor the descriptor for the SeqWithQuality object.\n Returns : Nothing.\n Args    : None.\n\n\nsub set_common_descriptors {\n   my $self = shift;\n   return if ($self->{seq_ref} || $self->{qual_ref});\n   &_common_id();\n   &_common_display_id();\n   &_common_accession_number();\n   &_common_primary_id();\n   &_common_desc();\n}\n\n=head2 alphabet()\n\n Title   : alphabet();\n Usage   : $molecule_type = $obj->alphabet();\n Function: Get the molecule type from the PrimarySeq object.\n Returns : What what PrimarySeq says the type of the sequence is.\n Args    : None.\n\n\nsub alphabet {\n   my $self = shift;\n   return $self->{seq_ref}->alphabet();\n}\n\n=head2 display_id()\n\n Title   : display_id()\n Usage   : $id_string = $obj->display_id();\n Function: Returns the display id, aka the common name of the Quality object.\n           The semantics of this is that it is the most likely string to be\n           used as an identifier of the quality sequence, and likely to have\n           \"human\" readability.  The id is equivalent to the ID field of the\n           GenBank/EMBL databanks and the id field of the Swissprot/sptrembl\n           database. In fasta format, the >(\\S+) is presumed to be the id,\n           though some people overload the id to embed other information.\n           Bioperl does not use any embedded information in the ID field,\n           and people are encouraged to use other mechanisms (accession\n           field for example, or extending the sequence object) to solve\n           this. Notice that $seq->id() maps to this function, mainly for\n           legacy/convience issues.\n           This method sets the display_id for the SeqWithQuality object.\n Returns : A string\n Args    : If a scalar is provided, it is set as the new display_id for\n           the SeqWithQuality object.\n Status  : Virtual"},"containerName":"main::","definition":"sub","line":413,"children":[{"definition":"my","name":"$obj","containerName":"display_id","localvar":"my","kind":13,"line":414},{"kind":13,"line":414,"containerName":"display_id","name":"$value"},{"name":"$value","containerName":"display_id","kind":13,"line":415},{"name":"$obj","containerName":"display_id","kind":13,"line":416},{"name":"$value","containerName":"display_id","kind":13,"line":416},{"name":"$obj","containerName":"display_id","line":418,"kind":13}],"kind":12,"range":{"start":{"character":0,"line":413},"end":{"line":420,"character":9999}},"name":"display_id"},{"name":"accession_number","range":{"end":{"line":452,"character":9999},"start":{"character":0,"line":442}},"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$obj"},{"label":"$acc"}],"documentation":"1;\n# $Id: SeqWithQuality.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Seq::QualI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chad Matsalla <bioinformatics@dieselwurks.com\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::SeqWithQuality - Bioperl object packaging a sequence with its quality.\nDeprecated class, use Bio::Seq::Quality instead!\n\n=head1 SYNOPSIS\n\n    use Bio::PrimarySeq;\n    use Bio::Seq::PrimaryQual;\n    use Bio::Seq::SeqWithQuality;\n\n    # make from memory\n    my $qual = Bio::Seq::SeqWithQuality->new\n    ( -qual => '10 20 30 40 50 50 20 10',\n      -seq => 'ATCGATCG',\n      -id  => 'human_id',\n      -accession_number => 'AL000012',\n    );\n\n    # make from objects\n    # first, make a PrimarySeq object\n    my $seqobj = Bio::PrimarySeq->new\n    ( -seq => 'atcgatcg',\n      -id  => 'GeneFragment-12',\n      -accession_number => 'X78121',\n      -alphabet => 'dna'\n    );\n\n    # now make a PrimaryQual object\n    my $qualobj = Bio::Seq::PrimaryQual->new\n    ( -qual => '10 20 30 40 50 50 20 10',\n      -id  => 'GeneFragment-12',\n      -accession_number => 'X78121',\n      -alphabet => 'dna'\n    );\n\n    # now make the SeqWithQuality object\n    my $swqobj = Bio::Seq::SeqWithQuality->new\n    ( -seq  => $seqobj,\n      -qual => $qualobj\n    );\n    # done!\n\n    $swqobj->id(); # the id of the SeqWithQuality object\n    # may not match the the id of the sequence or\n    # of the quality (check the pod, luke)\n    $swqobj->seq(); # the sequence of the SeqWithQuality object\n    $swqobj->qual(); # the quality of the SeqWithQuality object\n\n    # to get out parts of the sequence.\n\n    print \"Sequence \", $seqobj->id(), \" with accession \",\n    $seqobj->accession, \" and desc \", $seqobj->desc, \"\\n\";\n\n    $string2 = $seqobj->subseq(1,40);\n\n=head1 DESCRIPTION\n\nThis object stores base quality values together with the sequence string.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nEmail bioinformatics@dieselwurks.com\n\n=head1 CONTRIBUTORS \n\nJason Stajich, jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\npackage Bio::Seq::SeqWithQuality;\n\n\nuse strict;\nuse Bio::PrimarySeq;\nuse Bio::Seq::PrimaryQual;\n\nuse base qw(Bio::Root::Root Bio::PrimarySeqI Bio::Seq::QualI);\n\n=head2 new()\n\n Title   : new()\n Usage   : $qual = Bio::Seq::SeqWithQuality ->new\n             ( -qual => '10 20 30 40 50 50 20 10',\n               -seq => 'ATCGATCG',\n               -id  => 'human_id',\n               -accession_number => 'AL000012',\n               -trace_indices    => '0 5 10 15 20 25 30 35'\n             );\n Function: Returns a new Bio::Seq::SeqWithQual object from basic\n           constructors.\n Returns : a new Bio::Seq::PrimaryQual object\n Args    : -qual can be a quality string (see Bio::Seq::PrimaryQual for more\n            information on this) or a reference to a Bio::Seq::PrimaryQual\n            object.\n           -seq can be a sequence string (see Bio::PrimarySeq for more\n            information on this) or a reference to a Bio::PrimaryQual object.\n           -seq, -id, -accession_number, -primary_id, -desc, -id behave like\n            this:\n             1. if they are provided on construction of the\n                 Bio::Seq::SeqWithQuality they will be set as the descriptors for\n                 the object unless changed by one of the following mechanisms:\n              a) $obj->set_common_descriptors() is used and both the -seq and\n                 the -qual object have the same descriptors. These common\n                 descriptors will then become the descriptors for the\n                 Bio::Seq::SeqWithQual object.\n              b) the descriptors are manually set using the seq(), id(),\n                 desc(), or accession_number(), primary_id(),\n             2. if no descriptors are provided, the new() constructor will see\n                if the descriptor used in the PrimarySeq and in the\n                PrimaryQual objects match. If they do, they will become\n                the descriptors for the SeqWithQuality object.\n             To eliminate ambiguity, I strongly suggest you set the\n             descriptors manually on construction of the object. Really.\n           -trace_indices : a space_delimited list of trace indices\n            (where would the peaks be drawn if this list of qualities\n            was to be plotted?)\n\n\nsub new {\n   my ($class, @args) = @_;\n   my $self = $class->SUPER::new(@args);\n   # default: turn OFF the warnings\n   $self->{supress_warnings} = 1;\n   my($qual,$seq,$id,$acc,$pid,$desc,$given_id,$alphabet,$trace_indices) =\n   $self->_rearrange([qw( QUAL SEQ DISPLAY_ID ACCESSION_NUMBER PRIMARY_ID DESC\n     ID ALPHABET TRACE_INDICES )], @args);\n   # Deal with the ID\n   if ( defined $id && defined $given_id ) {\n      if( $id ne $given_id ) {\n         $self->throw(\"Provided both id and display_id constructor functions. [$id] [$given_id]\");\n      }\n   }\n   if( defined $given_id ) {\n      $self->display_id($given_id);\n      $id = $given_id;\n   }\n   # Import sequence first\n   if (!$seq) {\n      my $id;\n      unless ($self->{supress_warnings} == 1) {\n         $self->warn(\"You did not provide sequence information during the \".\n           \"construction of a Bio::Seq::SeqWithQuality object. Sequence \".\n           \"components for this object will be empty.\");\n      }\n      if (!$alphabet) {\n         $self->throw(\"If you want me to create a PrimarySeq object for your \".\n           \"empty sequence <boggle> you must specify a -alphabet to satisfy \".\n           \"the constructor requirements for a Bio::PrimarySeq object with no \".\n           \"sequence. Read the POD for it, luke.\");\n      }\n      $self->{seq_ref} = Bio::PrimarySeq->new( -seq              =>  \"\",\n                                               -accession_number =>  $acc,\n                                               -primary_id       =>  $pid,\n                                               -desc             =>  $desc,\n                                               -display_id       =>  $id,\n                                               -alphabet         =>  $alphabet );\n   } elsif ($seq->isa('Bio::PrimarySeqI') || $seq->isa('Bio::SeqI')) {\n      $self->{seq_ref} = $seq;\n   } elsif (ref($seq)) {\n      $self->throw(\"You passed a seq argument into a SeqWithQUality object and\".\n        \" it was a reference ($seq) which did not inherit from Bio::SeqI or \".\n        \"Bio::PrimarySeqI. I don't know what to do with this!\");\n   } else {\n      my $seqobj = Bio::PrimarySeq->new( -seq              => $seq,\n                                         -accession_number => $acc,\n                                         -primary_id       => $pid,\n                                         -desc             => $desc,\n                                         -display_id       => $id   );\n      $self->{seq_ref} = $seqobj;\n   }\n   # Then import the quality scores\n   if (!defined($qual)) {\n      $self->{qual_ref} = Bio::Seq::PrimaryQual->new( -qual             => \"\",\n                                                      -accession_number => $acc,\n                                                      -primary_id       => $pid,\n                                                      -desc             => $desc,\n                                                      -display_id       => $id, );\n   } elsif (ref($qual) eq \"Bio::Seq::PrimaryQual\") {\n      $self->{qual_ref} = $qual;\n   } else {\n      my $qualobj = Bio::Seq::PrimaryQual->new( -qual             => $qual,\n                                                -accession_number => $acc,\n                                                -primary_id       => $pid,\n                                                -desc             => $desc,\n                                                -display_id       => $id,\n                                                -trace_indices    => $trace_indices );\n      $self->{qual_ref} = $qualobj;\n   }\n   # Now try to set the descriptors for this object\n   $self->_set_descriptors($qual,$seq,$id,$acc,$pid,$desc,$given_id,$alphabet);\n   $self->length();\n   $self->deprecated(\"deprecated class - use Bio::Seq::Quality instead\");\n\n   return $self;\n}\n\n=head2 _common_id()\n\n Title   : _common_id()\n Usage   : $common_id = $self->_common_id();\n Function: Compare the display_id of {qual_ref} and {seq_ref}.\n Returns : Nothing if they don't match. If they do return {seq_ref}->display_id()\n Args    : None.\n\n\n#'\nsub _common_id {\n   my $self = shift;\n   return if (!$self->{seq_ref} || !$self->{qual_ref});\n   my $sid = $self->{seq_ref}->display_id();\n   return if (!$sid);\n   return if (!$self->{qual_ref}->display_id());\n   return $sid if ($sid eq $self->{qual_ref}->display_id());\n   # should this become a warning?\n   # print(\"ids $sid and $self->{qual_ref}->display_id() do not match. Bummer.\\n\");\n}\n\n=head2 _common_display_id()\n\n Title   : _common_id()\n Usage   : $common_id = $self->_common_display_id();\n Function: Compare the display_id of {qual_ref} and {seq_ref}.\n Returns : Nothing if they don't match. If they do return {seq_ref}->display_id()\n Args    : None.\n\n\n#'\nsub _common_display_id {\n   my $self = shift;\n   $self->common_id();\n}\n\n=head2 _common_accession_number()\n\n Title   : _common_accession_number()\n Usage   : $common_id = $self->_common_accession_number();\n Function: Compare the accession_number() of {qual_ref} and {seq_ref}.\n Returns : Nothing if they don't match. If they do return {seq_ref}->accession_number()\n Args    : None.\n\n\n#'\nsub _common_accession_number {\n   my $self = shift;\n   return if ($self->{seq_ref} || $self->{qual_ref});\n   my $acc = $self->{seq_ref}->accession_number();\n   # if (!$acc) { print(\"the seqref has no acc.\\n\"); }\n   return if (!$acc);\n   # if ($acc eq $self->{qual_ref}->accession_number()) { print(\"$acc matches \".$self->{qual_ref}->accession_number().\"\\n\"); }\n   return $acc if ($acc eq $self->{qual_ref}->accession_number());\n   # should this become a warning?\n   # print(\"accession numbers $acc and $self->{qual_ref}->accession_number() do not match. Bummer.\\n\");\n}\n\n=head2 _common_primary_id()\n\n Title   : _common_primary_id()\n Usage   : $common_primard_id = $self->_common_primary_id();\n Function: Compare the primary_id of {qual_ref} and {seq_ref}.\n Returns : Nothing if they don't match. If they do return {seq_ref}->primary_id()\n Args    : None.\n\n\n#'\nsub _common_primary_id {\n   my $self = shift;\n   return if ($self->{seq_ref} || $self->{qual_ref});\n   my $pid = $self->{seq_ref}->primary_id();\n   return if (!$pid);\n   return $pid if ($pid eq $self->{qual_ref}->primary_id());\n   # should this become a warning?\n   # print(\"primary_ids $pid and $self->{qual_ref}->primary_id() do not match. Bummer.\\n\");\n}\n\n=head2 _common_desc()\n\n Title   : _common_desc()\n Usage   : $common_desc = $self->_common_desc();\n Function: Compare the desc of {qual_ref} and {seq_ref}.\n Returns : Nothing if they don't match. If they do return {seq_ref}->desc()\n Args    : None.\n\n\n#'\nsub _common_desc {\n   my $self = shift;\n   return if ($self->{seq_ref} || $self->{qual_ref});\n   my $des = $self->{seq_ref}->desc();\n   return if (!$des);\n   return $des if ($des eq $self->{qual_ref}->desc());\n   # should this become a warning?\n   # print(\"descriptions $des and $self->{qual_ref}->desc() do not match. Bummer.\\n\");\n}\n\n=head2 set_common_descriptors()\n\n Title   : set_common_descriptors()\n Usage   : $self->set_common_descriptors();\n Function: Compare the descriptors (id,accession_number,display_id,\n           primary_id, desc) for the PrimarySeq and PrimaryQual objects\n           within the SeqWithQuality object. If they match, make that\n           descriptor the descriptor for the SeqWithQuality object.\n Returns : Nothing.\n Args    : None.\n\n\nsub set_common_descriptors {\n   my $self = shift;\n   return if ($self->{seq_ref} || $self->{qual_ref});\n   &_common_id();\n   &_common_display_id();\n   &_common_accession_number();\n   &_common_primary_id();\n   &_common_desc();\n}\n\n=head2 alphabet()\n\n Title   : alphabet();\n Usage   : $molecule_type = $obj->alphabet();\n Function: Get the molecule type from the PrimarySeq object.\n Returns : What what PrimarySeq says the type of the sequence is.\n Args    : None.\n\n\nsub alphabet {\n   my $self = shift;\n   return $self->{seq_ref}->alphabet();\n}\n\n=head2 display_id()\n\n Title   : display_id()\n Usage   : $id_string = $obj->display_id();\n Function: Returns the display id, aka the common name of the Quality object.\n           The semantics of this is that it is the most likely string to be\n           used as an identifier of the quality sequence, and likely to have\n           \"human\" readability.  The id is equivalent to the ID field of the\n           GenBank/EMBL databanks and the id field of the Swissprot/sptrembl\n           database. In fasta format, the >(\\S+) is presumed to be the id,\n           though some people overload the id to embed other information.\n           Bioperl does not use any embedded information in the ID field,\n           and people are encouraged to use other mechanisms (accession\n           field for example, or extending the sequence object) to solve\n           this. Notice that $seq->id() maps to this function, mainly for\n           legacy/convience issues.\n           This method sets the display_id for the SeqWithQuality object.\n Returns : A string\n Args    : If a scalar is provided, it is set as the new display_id for\n           the SeqWithQuality object.\n Status  : Virtual\n\n\nsub display_id {\n   my ($obj,$value) = @_;\n   if( defined $value) {\n      $obj->{'display_id'} = $value;\n    }\n    return $obj->{'display_id'};\n\n}\n\n=head2 accession_number()\n\n Title   : accession_number()\n Usage   : $unique_biological_key = $obj->accession_number();\n Function: Returns the unique biological id for a sequence, commonly\n           called the accession_number. For sequences from established\n           databases, the implementors should try to use the correct\n           accession number. Notice that primary_id() provides the unique id\n           for the implemetation, allowing multiple objects to have the same\n           accession number in a particular implementation. For sequences\n           with no accession number, this method should return \"unknown\".\n           This method sets the accession_number for the SeqWithQuality\n           object. \n Returns : A string (the value of accession_number)\n Args    : If a scalar is provided, it is set as the new accession_number\n           for the SeqWithQuality object.\n Status  : Virtual","label":"accession_number($obj,$acc)"},"detail":"($obj,$acc)","kind":12,"children":[{"containerName":"accession_number","name":"$obj","definition":"my","localvar":"my","kind":13,"line":443},{"kind":13,"line":443,"containerName":"accession_number","name":"$acc"},{"line":445,"kind":13,"containerName":"accession_number","name":"$acc"},{"kind":13,"line":446,"name":"$obj","containerName":"accession_number"},{"containerName":"accession_number","name":"$acc","kind":13,"line":446},{"kind":13,"line":448,"name":"$acc","containerName":"accession_number"},{"line":448,"kind":13,"name":"$obj","containerName":"accession_number"},{"line":449,"kind":13,"name":"$acc","containerName":"accession_number"},{"kind":13,"line":449,"containerName":"accession_number","name":"$acc"},{"line":451,"kind":13,"name":"$acc","containerName":"accession_number"}],"line":442},{"line":470,"children":[{"definition":"my","name":"$obj","containerName":"primary_id","localvar":"my","kind":13,"line":471},{"line":471,"kind":13,"name":"$value","containerName":"primary_id"},{"line":472,"kind":13,"name":"$value","containerName":"primary_id"},{"name":"$obj","containerName":"primary_id","kind":13,"line":473},{"containerName":"primary_id","name":"$value","line":473,"kind":13},{"containerName":"primary_id","name":"$obj","line":475,"kind":13}],"kind":12,"detail":"($obj,$value)","signature":{"parameters":[{"label":"$obj"},{"label":"$value"}],"documentation":"1;\n# $Id: SeqWithQuality.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Seq::QualI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chad Matsalla <bioinformatics@dieselwurks.com\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::SeqWithQuality - Bioperl object packaging a sequence with its quality.\nDeprecated class, use Bio::Seq::Quality instead!\n\n=head1 SYNOPSIS\n\n    use Bio::PrimarySeq;\n    use Bio::Seq::PrimaryQual;\n    use Bio::Seq::SeqWithQuality;\n\n    # make from memory\n    my $qual = Bio::Seq::SeqWithQuality->new\n    ( -qual => '10 20 30 40 50 50 20 10',\n      -seq => 'ATCGATCG',\n      -id  => 'human_id',\n      -accession_number => 'AL000012',\n    );\n\n    # make from objects\n    # first, make a PrimarySeq object\n    my $seqobj = Bio::PrimarySeq->new\n    ( -seq => 'atcgatcg',\n      -id  => 'GeneFragment-12',\n      -accession_number => 'X78121',\n      -alphabet => 'dna'\n    );\n\n    # now make a PrimaryQual object\n    my $qualobj = Bio::Seq::PrimaryQual->new\n    ( -qual => '10 20 30 40 50 50 20 10',\n      -id  => 'GeneFragment-12',\n      -accession_number => 'X78121',\n      -alphabet => 'dna'\n    );\n\n    # now make the SeqWithQuality object\n    my $swqobj = Bio::Seq::SeqWithQuality->new\n    ( -seq  => $seqobj,\n      -qual => $qualobj\n    );\n    # done!\n\n    $swqobj->id(); # the id of the SeqWithQuality object\n    # may not match the the id of the sequence or\n    # of the quality (check the pod, luke)\n    $swqobj->seq(); # the sequence of the SeqWithQuality object\n    $swqobj->qual(); # the quality of the SeqWithQuality object\n\n    # to get out parts of the sequence.\n\n    print \"Sequence \", $seqobj->id(), \" with accession \",\n    $seqobj->accession, \" and desc \", $seqobj->desc, \"\\n\";\n\n    $string2 = $seqobj->subseq(1,40);\n\n=head1 DESCRIPTION\n\nThis object stores base quality values together with the sequence string.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nEmail bioinformatics@dieselwurks.com\n\n=head1 CONTRIBUTORS \n\nJason Stajich, jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\npackage Bio::Seq::SeqWithQuality;\n\n\nuse strict;\nuse Bio::PrimarySeq;\nuse Bio::Seq::PrimaryQual;\n\nuse base qw(Bio::Root::Root Bio::PrimarySeqI Bio::Seq::QualI);\n\n=head2 new()\n\n Title   : new()\n Usage   : $qual = Bio::Seq::SeqWithQuality ->new\n             ( -qual => '10 20 30 40 50 50 20 10',\n               -seq => 'ATCGATCG',\n               -id  => 'human_id',\n               -accession_number => 'AL000012',\n               -trace_indices    => '0 5 10 15 20 25 30 35'\n             );\n Function: Returns a new Bio::Seq::SeqWithQual object from basic\n           constructors.\n Returns : a new Bio::Seq::PrimaryQual object\n Args    : -qual can be a quality string (see Bio::Seq::PrimaryQual for more\n            information on this) or a reference to a Bio::Seq::PrimaryQual\n            object.\n           -seq can be a sequence string (see Bio::PrimarySeq for more\n            information on this) or a reference to a Bio::PrimaryQual object.\n           -seq, -id, -accession_number, -primary_id, -desc, -id behave like\n            this:\n             1. if they are provided on construction of the\n                 Bio::Seq::SeqWithQuality they will be set as the descriptors for\n                 the object unless changed by one of the following mechanisms:\n              a) $obj->set_common_descriptors() is used and both the -seq and\n                 the -qual object have the same descriptors. These common\n                 descriptors will then become the descriptors for the\n                 Bio::Seq::SeqWithQual object.\n              b) the descriptors are manually set using the seq(), id(),\n                 desc(), or accession_number(), primary_id(),\n             2. if no descriptors are provided, the new() constructor will see\n                if the descriptor used in the PrimarySeq and in the\n                PrimaryQual objects match. If they do, they will become\n                the descriptors for the SeqWithQuality object.\n             To eliminate ambiguity, I strongly suggest you set the\n             descriptors manually on construction of the object. Really.\n           -trace_indices : a space_delimited list of trace indices\n            (where would the peaks be drawn if this list of qualities\n            was to be plotted?)\n\n\nsub new {\n   my ($class, @args) = @_;\n   my $self = $class->SUPER::new(@args);\n   # default: turn OFF the warnings\n   $self->{supress_warnings} = 1;\n   my($qual,$seq,$id,$acc,$pid,$desc,$given_id,$alphabet,$trace_indices) =\n   $self->_rearrange([qw( QUAL SEQ DISPLAY_ID ACCESSION_NUMBER PRIMARY_ID DESC\n     ID ALPHABET TRACE_INDICES )], @args);\n   # Deal with the ID\n   if ( defined $id && defined $given_id ) {\n      if( $id ne $given_id ) {\n         $self->throw(\"Provided both id and display_id constructor functions. [$id] [$given_id]\");\n      }\n   }\n   if( defined $given_id ) {\n      $self->display_id($given_id);\n      $id = $given_id;\n   }\n   # Import sequence first\n   if (!$seq) {\n      my $id;\n      unless ($self->{supress_warnings} == 1) {\n         $self->warn(\"You did not provide sequence information during the \".\n           \"construction of a Bio::Seq::SeqWithQuality object. Sequence \".\n           \"components for this object will be empty.\");\n      }\n      if (!$alphabet) {\n         $self->throw(\"If you want me to create a PrimarySeq object for your \".\n           \"empty sequence <boggle> you must specify a -alphabet to satisfy \".\n           \"the constructor requirements for a Bio::PrimarySeq object with no \".\n           \"sequence. Read the POD for it, luke.\");\n      }\n      $self->{seq_ref} = Bio::PrimarySeq->new( -seq              =>  \"\",\n                                               -accession_number =>  $acc,\n                                               -primary_id       =>  $pid,\n                                               -desc             =>  $desc,\n                                               -display_id       =>  $id,\n                                               -alphabet         =>  $alphabet );\n   } elsif ($seq->isa('Bio::PrimarySeqI') || $seq->isa('Bio::SeqI')) {\n      $self->{seq_ref} = $seq;\n   } elsif (ref($seq)) {\n      $self->throw(\"You passed a seq argument into a SeqWithQUality object and\".\n        \" it was a reference ($seq) which did not inherit from Bio::SeqI or \".\n        \"Bio::PrimarySeqI. I don't know what to do with this!\");\n   } else {\n      my $seqobj = Bio::PrimarySeq->new( -seq              => $seq,\n                                         -accession_number => $acc,\n                                         -primary_id       => $pid,\n                                         -desc             => $desc,\n                                         -display_id       => $id   );\n      $self->{seq_ref} = $seqobj;\n   }\n   # Then import the quality scores\n   if (!defined($qual)) {\n      $self->{qual_ref} = Bio::Seq::PrimaryQual->new( -qual             => \"\",\n                                                      -accession_number => $acc,\n                                                      -primary_id       => $pid,\n                                                      -desc             => $desc,\n                                                      -display_id       => $id, );\n   } elsif (ref($qual) eq \"Bio::Seq::PrimaryQual\") {\n      $self->{qual_ref} = $qual;\n   } else {\n      my $qualobj = Bio::Seq::PrimaryQual->new( -qual             => $qual,\n                                                -accession_number => $acc,\n                                                -primary_id       => $pid,\n                                                -desc             => $desc,\n                                                -display_id       => $id,\n                                                -trace_indices    => $trace_indices );\n      $self->{qual_ref} = $qualobj;\n   }\n   # Now try to set the descriptors for this object\n   $self->_set_descriptors($qual,$seq,$id,$acc,$pid,$desc,$given_id,$alphabet);\n   $self->length();\n   $self->deprecated(\"deprecated class - use Bio::Seq::Quality instead\");\n\n   return $self;\n}\n\n=head2 _common_id()\n\n Title   : _common_id()\n Usage   : $common_id = $self->_common_id();\n Function: Compare the display_id of {qual_ref} and {seq_ref}.\n Returns : Nothing if they don't match. If they do return {seq_ref}->display_id()\n Args    : None.\n\n\n#'\nsub _common_id {\n   my $self = shift;\n   return if (!$self->{seq_ref} || !$self->{qual_ref});\n   my $sid = $self->{seq_ref}->display_id();\n   return if (!$sid);\n   return if (!$self->{qual_ref}->display_id());\n   return $sid if ($sid eq $self->{qual_ref}->display_id());\n   # should this become a warning?\n   # print(\"ids $sid and $self->{qual_ref}->display_id() do not match. Bummer.\\n\");\n}\n\n=head2 _common_display_id()\n\n Title   : _common_id()\n Usage   : $common_id = $self->_common_display_id();\n Function: Compare the display_id of {qual_ref} and {seq_ref}.\n Returns : Nothing if they don't match. If they do return {seq_ref}->display_id()\n Args    : None.\n\n\n#'\nsub _common_display_id {\n   my $self = shift;\n   $self->common_id();\n}\n\n=head2 _common_accession_number()\n\n Title   : _common_accession_number()\n Usage   : $common_id = $self->_common_accession_number();\n Function: Compare the accession_number() of {qual_ref} and {seq_ref}.\n Returns : Nothing if they don't match. If they do return {seq_ref}->accession_number()\n Args    : None.\n\n\n#'\nsub _common_accession_number {\n   my $self = shift;\n   return if ($self->{seq_ref} || $self->{qual_ref});\n   my $acc = $self->{seq_ref}->accession_number();\n   # if (!$acc) { print(\"the seqref has no acc.\\n\"); }\n   return if (!$acc);\n   # if ($acc eq $self->{qual_ref}->accession_number()) { print(\"$acc matches \".$self->{qual_ref}->accession_number().\"\\n\"); }\n   return $acc if ($acc eq $self->{qual_ref}->accession_number());\n   # should this become a warning?\n   # print(\"accession numbers $acc and $self->{qual_ref}->accession_number() do not match. Bummer.\\n\");\n}\n\n=head2 _common_primary_id()\n\n Title   : _common_primary_id()\n Usage   : $common_primard_id = $self->_common_primary_id();\n Function: Compare the primary_id of {qual_ref} and {seq_ref}.\n Returns : Nothing if they don't match. If they do return {seq_ref}->primary_id()\n Args    : None.\n\n\n#'\nsub _common_primary_id {\n   my $self = shift;\n   return if ($self->{seq_ref} || $self->{qual_ref});\n   my $pid = $self->{seq_ref}->primary_id();\n   return if (!$pid);\n   return $pid if ($pid eq $self->{qual_ref}->primary_id());\n   # should this become a warning?\n   # print(\"primary_ids $pid and $self->{qual_ref}->primary_id() do not match. Bummer.\\n\");\n}\n\n=head2 _common_desc()\n\n Title   : _common_desc()\n Usage   : $common_desc = $self->_common_desc();\n Function: Compare the desc of {qual_ref} and {seq_ref}.\n Returns : Nothing if they don't match. If they do return {seq_ref}->desc()\n Args    : None.\n\n\n#'\nsub _common_desc {\n   my $self = shift;\n   return if ($self->{seq_ref} || $self->{qual_ref});\n   my $des = $self->{seq_ref}->desc();\n   return if (!$des);\n   return $des if ($des eq $self->{qual_ref}->desc());\n   # should this become a warning?\n   # print(\"descriptions $des and $self->{qual_ref}->desc() do not match. Bummer.\\n\");\n}\n\n=head2 set_common_descriptors()\n\n Title   : set_common_descriptors()\n Usage   : $self->set_common_descriptors();\n Function: Compare the descriptors (id,accession_number,display_id,\n           primary_id, desc) for the PrimarySeq and PrimaryQual objects\n           within the SeqWithQuality object. If they match, make that\n           descriptor the descriptor for the SeqWithQuality object.\n Returns : Nothing.\n Args    : None.\n\n\nsub set_common_descriptors {\n   my $self = shift;\n   return if ($self->{seq_ref} || $self->{qual_ref});\n   &_common_id();\n   &_common_display_id();\n   &_common_accession_number();\n   &_common_primary_id();\n   &_common_desc();\n}\n\n=head2 alphabet()\n\n Title   : alphabet();\n Usage   : $molecule_type = $obj->alphabet();\n Function: Get the molecule type from the PrimarySeq object.\n Returns : What what PrimarySeq says the type of the sequence is.\n Args    : None.\n\n\nsub alphabet {\n   my $self = shift;\n   return $self->{seq_ref}->alphabet();\n}\n\n=head2 display_id()\n\n Title   : display_id()\n Usage   : $id_string = $obj->display_id();\n Function: Returns the display id, aka the common name of the Quality object.\n           The semantics of this is that it is the most likely string to be\n           used as an identifier of the quality sequence, and likely to have\n           \"human\" readability.  The id is equivalent to the ID field of the\n           GenBank/EMBL databanks and the id field of the Swissprot/sptrembl\n           database. In fasta format, the >(\\S+) is presumed to be the id,\n           though some people overload the id to embed other information.\n           Bioperl does not use any embedded information in the ID field,\n           and people are encouraged to use other mechanisms (accession\n           field for example, or extending the sequence object) to solve\n           this. Notice that $seq->id() maps to this function, mainly for\n           legacy/convience issues.\n           This method sets the display_id for the SeqWithQuality object.\n Returns : A string\n Args    : If a scalar is provided, it is set as the new display_id for\n           the SeqWithQuality object.\n Status  : Virtual\n\n\nsub display_id {\n   my ($obj,$value) = @_;\n   if( defined $value) {\n      $obj->{'display_id'} = $value;\n    }\n    return $obj->{'display_id'};\n\n}\n\n=head2 accession_number()\n\n Title   : accession_number()\n Usage   : $unique_biological_key = $obj->accession_number();\n Function: Returns the unique biological id for a sequence, commonly\n           called the accession_number. For sequences from established\n           databases, the implementors should try to use the correct\n           accession number. Notice that primary_id() provides the unique id\n           for the implemetation, allowing multiple objects to have the same\n           accession number in a particular implementation. For sequences\n           with no accession number, this method should return \"unknown\".\n           This method sets the accession_number for the SeqWithQuality\n           object. \n Returns : A string (the value of accession_number)\n Args    : If a scalar is provided, it is set as the new accession_number\n           for the SeqWithQuality object.\n Status  : Virtual\n\n\nsub accession_number {\n    my( $obj, $acc ) = @_;\n\n    if (defined $acc) {\n        $obj->{'accession_number'} = $acc;\n    } else {\n        $acc = $obj->{'accession_number'};\n        $acc = 'unknown' unless defined $acc;\n    }\n    return $acc;\n}\n\n=head2 primary_id()\n\n Title   : primary_id()\n Usage   : $unique_implementation_key = $obj->primary_id();\n Function: Returns the unique id for this object in this implementation.\n           This allows implementations to manage their own object ids in a\n           way the implementaiton can control clients can expect one id to\n           map to one object. For sequences with no accession number, this\n           method should return a stringified memory location.\n           This method sets the primary_id for the SeqWithQuality object.\n Returns : A string. (the value of primary_id)\n Args    : If a scalar is provided, it is set as the new primary_id for\n           the SeqWithQuality object.","label":"primary_id($obj,$value)"},"containerName":"main::","definition":"sub","range":{"start":{"line":470,"character":0},"end":{"line":477,"character":9999}},"name":"primary_id"},{"range":{"start":{"character":0,"line":491},"end":{"line":499,"character":9999}},"name":"desc","detail":"($obj,$value)","signature":{"label":"desc($obj,$value)","parameters":[{"label":"$obj"},{"label":"$value"}],"documentation":"1;\n# $Id: SeqWithQuality.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Seq::QualI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chad Matsalla <bioinformatics@dieselwurks.com\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::SeqWithQuality - Bioperl object packaging a sequence with its quality.\nDeprecated class, use Bio::Seq::Quality instead!\n\n=head1 SYNOPSIS\n\n    use Bio::PrimarySeq;\n    use Bio::Seq::PrimaryQual;\n    use Bio::Seq::SeqWithQuality;\n\n    # make from memory\n    my $qual = Bio::Seq::SeqWithQuality->new\n    ( -qual => '10 20 30 40 50 50 20 10',\n      -seq => 'ATCGATCG',\n      -id  => 'human_id',\n      -accession_number => 'AL000012',\n    );\n\n    # make from objects\n    # first, make a PrimarySeq object\n    my $seqobj = Bio::PrimarySeq->new\n    ( -seq => 'atcgatcg',\n      -id  => 'GeneFragment-12',\n      -accession_number => 'X78121',\n      -alphabet => 'dna'\n    );\n\n    # now make a PrimaryQual object\n    my $qualobj = Bio::Seq::PrimaryQual->new\n    ( -qual => '10 20 30 40 50 50 20 10',\n      -id  => 'GeneFragment-12',\n      -accession_number => 'X78121',\n      -alphabet => 'dna'\n    );\n\n    # now make the SeqWithQuality object\n    my $swqobj = Bio::Seq::SeqWithQuality->new\n    ( -seq  => $seqobj,\n      -qual => $qualobj\n    );\n    # done!\n\n    $swqobj->id(); # the id of the SeqWithQuality object\n    # may not match the the id of the sequence or\n    # of the quality (check the pod, luke)\n    $swqobj->seq(); # the sequence of the SeqWithQuality object\n    $swqobj->qual(); # the quality of the SeqWithQuality object\n\n    # to get out parts of the sequence.\n\n    print \"Sequence \", $seqobj->id(), \" with accession \",\n    $seqobj->accession, \" and desc \", $seqobj->desc, \"\\n\";\n\n    $string2 = $seqobj->subseq(1,40);\n\n=head1 DESCRIPTION\n\nThis object stores base quality values together with the sequence string.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nEmail bioinformatics@dieselwurks.com\n\n=head1 CONTRIBUTORS \n\nJason Stajich, jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\npackage Bio::Seq::SeqWithQuality;\n\n\nuse strict;\nuse Bio::PrimarySeq;\nuse Bio::Seq::PrimaryQual;\n\nuse base qw(Bio::Root::Root Bio::PrimarySeqI Bio::Seq::QualI);\n\n=head2 new()\n\n Title   : new()\n Usage   : $qual = Bio::Seq::SeqWithQuality ->new\n             ( -qual => '10 20 30 40 50 50 20 10',\n               -seq => 'ATCGATCG',\n               -id  => 'human_id',\n               -accession_number => 'AL000012',\n               -trace_indices    => '0 5 10 15 20 25 30 35'\n             );\n Function: Returns a new Bio::Seq::SeqWithQual object from basic\n           constructors.\n Returns : a new Bio::Seq::PrimaryQual object\n Args    : -qual can be a quality string (see Bio::Seq::PrimaryQual for more\n            information on this) or a reference to a Bio::Seq::PrimaryQual\n            object.\n           -seq can be a sequence string (see Bio::PrimarySeq for more\n            information on this) or a reference to a Bio::PrimaryQual object.\n           -seq, -id, -accession_number, -primary_id, -desc, -id behave like\n            this:\n             1. if they are provided on construction of the\n                 Bio::Seq::SeqWithQuality they will be set as the descriptors for\n                 the object unless changed by one of the following mechanisms:\n              a) $obj->set_common_descriptors() is used and both the -seq and\n                 the -qual object have the same descriptors. These common\n                 descriptors will then become the descriptors for the\n                 Bio::Seq::SeqWithQual object.\n              b) the descriptors are manually set using the seq(), id(),\n                 desc(), or accession_number(), primary_id(),\n             2. if no descriptors are provided, the new() constructor will see\n                if the descriptor used in the PrimarySeq and in the\n                PrimaryQual objects match. If they do, they will become\n                the descriptors for the SeqWithQuality object.\n             To eliminate ambiguity, I strongly suggest you set the\n             descriptors manually on construction of the object. Really.\n           -trace_indices : a space_delimited list of trace indices\n            (where would the peaks be drawn if this list of qualities\n            was to be plotted?)\n\n\nsub new {\n   my ($class, @args) = @_;\n   my $self = $class->SUPER::new(@args);\n   # default: turn OFF the warnings\n   $self->{supress_warnings} = 1;\n   my($qual,$seq,$id,$acc,$pid,$desc,$given_id,$alphabet,$trace_indices) =\n   $self->_rearrange([qw( QUAL SEQ DISPLAY_ID ACCESSION_NUMBER PRIMARY_ID DESC\n     ID ALPHABET TRACE_INDICES )], @args);\n   # Deal with the ID\n   if ( defined $id && defined $given_id ) {\n      if( $id ne $given_id ) {\n         $self->throw(\"Provided both id and display_id constructor functions. [$id] [$given_id]\");\n      }\n   }\n   if( defined $given_id ) {\n      $self->display_id($given_id);\n      $id = $given_id;\n   }\n   # Import sequence first\n   if (!$seq) {\n      my $id;\n      unless ($self->{supress_warnings} == 1) {\n         $self->warn(\"You did not provide sequence information during the \".\n           \"construction of a Bio::Seq::SeqWithQuality object. Sequence \".\n           \"components for this object will be empty.\");\n      }\n      if (!$alphabet) {\n         $self->throw(\"If you want me to create a PrimarySeq object for your \".\n           \"empty sequence <boggle> you must specify a -alphabet to satisfy \".\n           \"the constructor requirements for a Bio::PrimarySeq object with no \".\n           \"sequence. Read the POD for it, luke.\");\n      }\n      $self->{seq_ref} = Bio::PrimarySeq->new( -seq              =>  \"\",\n                                               -accession_number =>  $acc,\n                                               -primary_id       =>  $pid,\n                                               -desc             =>  $desc,\n                                               -display_id       =>  $id,\n                                               -alphabet         =>  $alphabet );\n   } elsif ($seq->isa('Bio::PrimarySeqI') || $seq->isa('Bio::SeqI')) {\n      $self->{seq_ref} = $seq;\n   } elsif (ref($seq)) {\n      $self->throw(\"You passed a seq argument into a SeqWithQUality object and\".\n        \" it was a reference ($seq) which did not inherit from Bio::SeqI or \".\n        \"Bio::PrimarySeqI. I don't know what to do with this!\");\n   } else {\n      my $seqobj = Bio::PrimarySeq->new( -seq              => $seq,\n                                         -accession_number => $acc,\n                                         -primary_id       => $pid,\n                                         -desc             => $desc,\n                                         -display_id       => $id   );\n      $self->{seq_ref} = $seqobj;\n   }\n   # Then import the quality scores\n   if (!defined($qual)) {\n      $self->{qual_ref} = Bio::Seq::PrimaryQual->new( -qual             => \"\",\n                                                      -accession_number => $acc,\n                                                      -primary_id       => $pid,\n                                                      -desc             => $desc,\n                                                      -display_id       => $id, );\n   } elsif (ref($qual) eq \"Bio::Seq::PrimaryQual\") {\n      $self->{qual_ref} = $qual;\n   } else {\n      my $qualobj = Bio::Seq::PrimaryQual->new( -qual             => $qual,\n                                                -accession_number => $acc,\n                                                -primary_id       => $pid,\n                                                -desc             => $desc,\n                                                -display_id       => $id,\n                                                -trace_indices    => $trace_indices );\n      $self->{qual_ref} = $qualobj;\n   }\n   # Now try to set the descriptors for this object\n   $self->_set_descriptors($qual,$seq,$id,$acc,$pid,$desc,$given_id,$alphabet);\n   $self->length();\n   $self->deprecated(\"deprecated class - use Bio::Seq::Quality instead\");\n\n   return $self;\n}\n\n=head2 _common_id()\n\n Title   : _common_id()\n Usage   : $common_id = $self->_common_id();\n Function: Compare the display_id of {qual_ref} and {seq_ref}.\n Returns : Nothing if they don't match. If they do return {seq_ref}->display_id()\n Args    : None.\n\n\n#'\nsub _common_id {\n   my $self = shift;\n   return if (!$self->{seq_ref} || !$self->{qual_ref});\n   my $sid = $self->{seq_ref}->display_id();\n   return if (!$sid);\n   return if (!$self->{qual_ref}->display_id());\n   return $sid if ($sid eq $self->{qual_ref}->display_id());\n   # should this become a warning?\n   # print(\"ids $sid and $self->{qual_ref}->display_id() do not match. Bummer.\\n\");\n}\n\n=head2 _common_display_id()\n\n Title   : _common_id()\n Usage   : $common_id = $self->_common_display_id();\n Function: Compare the display_id of {qual_ref} and {seq_ref}.\n Returns : Nothing if they don't match. If they do return {seq_ref}->display_id()\n Args    : None.\n\n\n#'\nsub _common_display_id {\n   my $self = shift;\n   $self->common_id();\n}\n\n=head2 _common_accession_number()\n\n Title   : _common_accession_number()\n Usage   : $common_id = $self->_common_accession_number();\n Function: Compare the accession_number() of {qual_ref} and {seq_ref}.\n Returns : Nothing if they don't match. If they do return {seq_ref}->accession_number()\n Args    : None.\n\n\n#'\nsub _common_accession_number {\n   my $self = shift;\n   return if ($self->{seq_ref} || $self->{qual_ref});\n   my $acc = $self->{seq_ref}->accession_number();\n   # if (!$acc) { print(\"the seqref has no acc.\\n\"); }\n   return if (!$acc);\n   # if ($acc eq $self->{qual_ref}->accession_number()) { print(\"$acc matches \".$self->{qual_ref}->accession_number().\"\\n\"); }\n   return $acc if ($acc eq $self->{qual_ref}->accession_number());\n   # should this become a warning?\n   # print(\"accession numbers $acc and $self->{qual_ref}->accession_number() do not match. Bummer.\\n\");\n}\n\n=head2 _common_primary_id()\n\n Title   : _common_primary_id()\n Usage   : $common_primard_id = $self->_common_primary_id();\n Function: Compare the primary_id of {qual_ref} and {seq_ref}.\n Returns : Nothing if they don't match. If they do return {seq_ref}->primary_id()\n Args    : None.\n\n\n#'\nsub _common_primary_id {\n   my $self = shift;\n   return if ($self->{seq_ref} || $self->{qual_ref});\n   my $pid = $self->{seq_ref}->primary_id();\n   return if (!$pid);\n   return $pid if ($pid eq $self->{qual_ref}->primary_id());\n   # should this become a warning?\n   # print(\"primary_ids $pid and $self->{qual_ref}->primary_id() do not match. Bummer.\\n\");\n}\n\n=head2 _common_desc()\n\n Title   : _common_desc()\n Usage   : $common_desc = $self->_common_desc();\n Function: Compare the desc of {qual_ref} and {seq_ref}.\n Returns : Nothing if they don't match. If they do return {seq_ref}->desc()\n Args    : None.\n\n\n#'\nsub _common_desc {\n   my $self = shift;\n   return if ($self->{seq_ref} || $self->{qual_ref});\n   my $des = $self->{seq_ref}->desc();\n   return if (!$des);\n   return $des if ($des eq $self->{qual_ref}->desc());\n   # should this become a warning?\n   # print(\"descriptions $des and $self->{qual_ref}->desc() do not match. Bummer.\\n\");\n}\n\n=head2 set_common_descriptors()\n\n Title   : set_common_descriptors()\n Usage   : $self->set_common_descriptors();\n Function: Compare the descriptors (id,accession_number,display_id,\n           primary_id, desc) for the PrimarySeq and PrimaryQual objects\n           within the SeqWithQuality object. If they match, make that\n           descriptor the descriptor for the SeqWithQuality object.\n Returns : Nothing.\n Args    : None.\n\n\nsub set_common_descriptors {\n   my $self = shift;\n   return if ($self->{seq_ref} || $self->{qual_ref});\n   &_common_id();\n   &_common_display_id();\n   &_common_accession_number();\n   &_common_primary_id();\n   &_common_desc();\n}\n\n=head2 alphabet()\n\n Title   : alphabet();\n Usage   : $molecule_type = $obj->alphabet();\n Function: Get the molecule type from the PrimarySeq object.\n Returns : What what PrimarySeq says the type of the sequence is.\n Args    : None.\n\n\nsub alphabet {\n   my $self = shift;\n   return $self->{seq_ref}->alphabet();\n}\n\n=head2 display_id()\n\n Title   : display_id()\n Usage   : $id_string = $obj->display_id();\n Function: Returns the display id, aka the common name of the Quality object.\n           The semantics of this is that it is the most likely string to be\n           used as an identifier of the quality sequence, and likely to have\n           \"human\" readability.  The id is equivalent to the ID field of the\n           GenBank/EMBL databanks and the id field of the Swissprot/sptrembl\n           database. In fasta format, the >(\\S+) is presumed to be the id,\n           though some people overload the id to embed other information.\n           Bioperl does not use any embedded information in the ID field,\n           and people are encouraged to use other mechanisms (accession\n           field for example, or extending the sequence object) to solve\n           this. Notice that $seq->id() maps to this function, mainly for\n           legacy/convience issues.\n           This method sets the display_id for the SeqWithQuality object.\n Returns : A string\n Args    : If a scalar is provided, it is set as the new display_id for\n           the SeqWithQuality object.\n Status  : Virtual\n\n\nsub display_id {\n   my ($obj,$value) = @_;\n   if( defined $value) {\n      $obj->{'display_id'} = $value;\n    }\n    return $obj->{'display_id'};\n\n}\n\n=head2 accession_number()\n\n Title   : accession_number()\n Usage   : $unique_biological_key = $obj->accession_number();\n Function: Returns the unique biological id for a sequence, commonly\n           called the accession_number. For sequences from established\n           databases, the implementors should try to use the correct\n           accession number. Notice that primary_id() provides the unique id\n           for the implemetation, allowing multiple objects to have the same\n           accession number in a particular implementation. For sequences\n           with no accession number, this method should return \"unknown\".\n           This method sets the accession_number for the SeqWithQuality\n           object. \n Returns : A string (the value of accession_number)\n Args    : If a scalar is provided, it is set as the new accession_number\n           for the SeqWithQuality object.\n Status  : Virtual\n\n\nsub accession_number {\n    my( $obj, $acc ) = @_;\n\n    if (defined $acc) {\n        $obj->{'accession_number'} = $acc;\n    } else {\n        $acc = $obj->{'accession_number'};\n        $acc = 'unknown' unless defined $acc;\n    }\n    return $acc;\n}\n\n=head2 primary_id()\n\n Title   : primary_id()\n Usage   : $unique_implementation_key = $obj->primary_id();\n Function: Returns the unique id for this object in this implementation.\n           This allows implementations to manage their own object ids in a\n           way the implementaiton can control clients can expect one id to\n           map to one object. For sequences with no accession number, this\n           method should return a stringified memory location.\n           This method sets the primary_id for the SeqWithQuality object.\n Returns : A string. (the value of primary_id)\n Args    : If a scalar is provided, it is set as the new primary_id for\n           the SeqWithQuality object.\n\n\nsub primary_id {\n   my ($obj,$value) = @_;\n   if ($value) {\n      $obj->{'primary_id'} = $value;\n    }\n   return $obj->{'primary_id'};\n\n}\n\n=head2 desc()\n\n Title   : desc()\n Usage   : $qual->desc($newval); _or_ \n           $description = $qual->desc();\n Function: Get/set description text for this SeqWithQuality object.\n Returns : A string. (the value of desc)\n Args    : If a scalar is provided, it is set as the new desc for the\n           SeqWithQuality object."},"containerName":"main::","definition":"sub","line":491,"children":[{"localvar":"my","name":"$obj","definition":"my","containerName":"desc","line":494,"kind":13},{"name":"$value","containerName":"desc","line":494,"kind":13},{"name":"$value","containerName":"desc","line":495,"kind":13},{"containerName":"desc","name":"$obj","line":496,"kind":13},{"kind":13,"line":496,"name":"$value","containerName":"desc"},{"kind":13,"line":498,"containerName":"desc","name":"$obj"}],"kind":12},{"name":"id","range":{"end":{"line":521,"character":9999},"start":{"line":514,"character":0}},"kind":12,"children":[{"name":"$self","definition":"my","containerName":"id","localvar":"my","kind":13,"line":515},{"kind":13,"line":515,"name":"$value","containerName":"id"},{"containerName":"id","name":"$self","line":516,"kind":13},{"kind":13,"line":516,"name":"$self","containerName":"id"},{"containerName":"id","name":"throw","kind":12,"line":516},{"line":517,"kind":13,"name":"$value","containerName":"id"},{"kind":13,"line":518,"name":"$self","containerName":"id"},{"kind":12,"line":518,"name":"display_id","containerName":"id"},{"line":518,"kind":13,"name":"$value","containerName":"id"},{"name":"$self","containerName":"id","kind":13,"line":520},{"line":520,"kind":12,"containerName":"id","name":"display_id"}],"line":514,"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: SeqWithQuality.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Seq::QualI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chad Matsalla <bioinformatics@dieselwurks.com\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::SeqWithQuality - Bioperl object packaging a sequence with its quality.\nDeprecated class, use Bio::Seq::Quality instead!\n\n=head1 SYNOPSIS\n\n    use Bio::PrimarySeq;\n    use Bio::Seq::PrimaryQual;\n    use Bio::Seq::SeqWithQuality;\n\n    # make from memory\n    my $qual = Bio::Seq::SeqWithQuality->new\n    ( -qual => '10 20 30 40 50 50 20 10',\n      -seq => 'ATCGATCG',\n      -id  => 'human_id',\n      -accession_number => 'AL000012',\n    );\n\n    # make from objects\n    # first, make a PrimarySeq object\n    my $seqobj = Bio::PrimarySeq->new\n    ( -seq => 'atcgatcg',\n      -id  => 'GeneFragment-12',\n      -accession_number => 'X78121',\n      -alphabet => 'dna'\n    );\n\n    # now make a PrimaryQual object\n    my $qualobj = Bio::Seq::PrimaryQual->new\n    ( -qual => '10 20 30 40 50 50 20 10',\n      -id  => 'GeneFragment-12',\n      -accession_number => 'X78121',\n      -alphabet => 'dna'\n    );\n\n    # now make the SeqWithQuality object\n    my $swqobj = Bio::Seq::SeqWithQuality->new\n    ( -seq  => $seqobj,\n      -qual => $qualobj\n    );\n    # done!\n\n    $swqobj->id(); # the id of the SeqWithQuality object\n    # may not match the the id of the sequence or\n    # of the quality (check the pod, luke)\n    $swqobj->seq(); # the sequence of the SeqWithQuality object\n    $swqobj->qual(); # the quality of the SeqWithQuality object\n\n    # to get out parts of the sequence.\n\n    print \"Sequence \", $seqobj->id(), \" with accession \",\n    $seqobj->accession, \" and desc \", $seqobj->desc, \"\\n\";\n\n    $string2 = $seqobj->subseq(1,40);\n\n=head1 DESCRIPTION\n\nThis object stores base quality values together with the sequence string.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nEmail bioinformatics@dieselwurks.com\n\n=head1 CONTRIBUTORS \n\nJason Stajich, jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\npackage Bio::Seq::SeqWithQuality;\n\n\nuse strict;\nuse Bio::PrimarySeq;\nuse Bio::Seq::PrimaryQual;\n\nuse base qw(Bio::Root::Root Bio::PrimarySeqI Bio::Seq::QualI);\n\n=head2 new()\n\n Title   : new()\n Usage   : $qual = Bio::Seq::SeqWithQuality ->new\n             ( -qual => '10 20 30 40 50 50 20 10',\n               -seq => 'ATCGATCG',\n               -id  => 'human_id',\n               -accession_number => 'AL000012',\n               -trace_indices    => '0 5 10 15 20 25 30 35'\n             );\n Function: Returns a new Bio::Seq::SeqWithQual object from basic\n           constructors.\n Returns : a new Bio::Seq::PrimaryQual object\n Args    : -qual can be a quality string (see Bio::Seq::PrimaryQual for more\n            information on this) or a reference to a Bio::Seq::PrimaryQual\n            object.\n           -seq can be a sequence string (see Bio::PrimarySeq for more\n            information on this) or a reference to a Bio::PrimaryQual object.\n           -seq, -id, -accession_number, -primary_id, -desc, -id behave like\n            this:\n             1. if they are provided on construction of the\n                 Bio::Seq::SeqWithQuality they will be set as the descriptors for\n                 the object unless changed by one of the following mechanisms:\n              a) $obj->set_common_descriptors() is used and both the -seq and\n                 the -qual object have the same descriptors. These common\n                 descriptors will then become the descriptors for the\n                 Bio::Seq::SeqWithQual object.\n              b) the descriptors are manually set using the seq(), id(),\n                 desc(), or accession_number(), primary_id(),\n             2. if no descriptors are provided, the new() constructor will see\n                if the descriptor used in the PrimarySeq and in the\n                PrimaryQual objects match. If they do, they will become\n                the descriptors for the SeqWithQuality object.\n             To eliminate ambiguity, I strongly suggest you set the\n             descriptors manually on construction of the object. Really.\n           -trace_indices : a space_delimited list of trace indices\n            (where would the peaks be drawn if this list of qualities\n            was to be plotted?)\n\n\nsub new {\n   my ($class, @args) = @_;\n   my $self = $class->SUPER::new(@args);\n   # default: turn OFF the warnings\n   $self->{supress_warnings} = 1;\n   my($qual,$seq,$id,$acc,$pid,$desc,$given_id,$alphabet,$trace_indices) =\n   $self->_rearrange([qw( QUAL SEQ DISPLAY_ID ACCESSION_NUMBER PRIMARY_ID DESC\n     ID ALPHABET TRACE_INDICES )], @args);\n   # Deal with the ID\n   if ( defined $id && defined $given_id ) {\n      if( $id ne $given_id ) {\n         $self->throw(\"Provided both id and display_id constructor functions. [$id] [$given_id]\");\n      }\n   }\n   if( defined $given_id ) {\n      $self->display_id($given_id);\n      $id = $given_id;\n   }\n   # Import sequence first\n   if (!$seq) {\n      my $id;\n      unless ($self->{supress_warnings} == 1) {\n         $self->warn(\"You did not provide sequence information during the \".\n           \"construction of a Bio::Seq::SeqWithQuality object. Sequence \".\n           \"components for this object will be empty.\");\n      }\n      if (!$alphabet) {\n         $self->throw(\"If you want me to create a PrimarySeq object for your \".\n           \"empty sequence <boggle> you must specify a -alphabet to satisfy \".\n           \"the constructor requirements for a Bio::PrimarySeq object with no \".\n           \"sequence. Read the POD for it, luke.\");\n      }\n      $self->{seq_ref} = Bio::PrimarySeq->new( -seq              =>  \"\",\n                                               -accession_number =>  $acc,\n                                               -primary_id       =>  $pid,\n                                               -desc             =>  $desc,\n                                               -display_id       =>  $id,\n                                               -alphabet         =>  $alphabet );\n   } elsif ($seq->isa('Bio::PrimarySeqI') || $seq->isa('Bio::SeqI')) {\n      $self->{seq_ref} = $seq;\n   } elsif (ref($seq)) {\n      $self->throw(\"You passed a seq argument into a SeqWithQUality object and\".\n        \" it was a reference ($seq) which did not inherit from Bio::SeqI or \".\n        \"Bio::PrimarySeqI. I don't know what to do with this!\");\n   } else {\n      my $seqobj = Bio::PrimarySeq->new( -seq              => $seq,\n                                         -accession_number => $acc,\n                                         -primary_id       => $pid,\n                                         -desc             => $desc,\n                                         -display_id       => $id   );\n      $self->{seq_ref} = $seqobj;\n   }\n   # Then import the quality scores\n   if (!defined($qual)) {\n      $self->{qual_ref} = Bio::Seq::PrimaryQual->new( -qual             => \"\",\n                                                      -accession_number => $acc,\n                                                      -primary_id       => $pid,\n                                                      -desc             => $desc,\n                                                      -display_id       => $id, );\n   } elsif (ref($qual) eq \"Bio::Seq::PrimaryQual\") {\n      $self->{qual_ref} = $qual;\n   } else {\n      my $qualobj = Bio::Seq::PrimaryQual->new( -qual             => $qual,\n                                                -accession_number => $acc,\n                                                -primary_id       => $pid,\n                                                -desc             => $desc,\n                                                -display_id       => $id,\n                                                -trace_indices    => $trace_indices );\n      $self->{qual_ref} = $qualobj;\n   }\n   # Now try to set the descriptors for this object\n   $self->_set_descriptors($qual,$seq,$id,$acc,$pid,$desc,$given_id,$alphabet);\n   $self->length();\n   $self->deprecated(\"deprecated class - use Bio::Seq::Quality instead\");\n\n   return $self;\n}\n\n=head2 _common_id()\n\n Title   : _common_id()\n Usage   : $common_id = $self->_common_id();\n Function: Compare the display_id of {qual_ref} and {seq_ref}.\n Returns : Nothing if they don't match. If they do return {seq_ref}->display_id()\n Args    : None.\n\n\n#'\nsub _common_id {\n   my $self = shift;\n   return if (!$self->{seq_ref} || !$self->{qual_ref});\n   my $sid = $self->{seq_ref}->display_id();\n   return if (!$sid);\n   return if (!$self->{qual_ref}->display_id());\n   return $sid if ($sid eq $self->{qual_ref}->display_id());\n   # should this become a warning?\n   # print(\"ids $sid and $self->{qual_ref}->display_id() do not match. Bummer.\\n\");\n}\n\n=head2 _common_display_id()\n\n Title   : _common_id()\n Usage   : $common_id = $self->_common_display_id();\n Function: Compare the display_id of {qual_ref} and {seq_ref}.\n Returns : Nothing if they don't match. If they do return {seq_ref}->display_id()\n Args    : None.\n\n\n#'\nsub _common_display_id {\n   my $self = shift;\n   $self->common_id();\n}\n\n=head2 _common_accession_number()\n\n Title   : _common_accession_number()\n Usage   : $common_id = $self->_common_accession_number();\n Function: Compare the accession_number() of {qual_ref} and {seq_ref}.\n Returns : Nothing if they don't match. If they do return {seq_ref}->accession_number()\n Args    : None.\n\n\n#'\nsub _common_accession_number {\n   my $self = shift;\n   return if ($self->{seq_ref} || $self->{qual_ref});\n   my $acc = $self->{seq_ref}->accession_number();\n   # if (!$acc) { print(\"the seqref has no acc.\\n\"); }\n   return if (!$acc);\n   # if ($acc eq $self->{qual_ref}->accession_number()) { print(\"$acc matches \".$self->{qual_ref}->accession_number().\"\\n\"); }\n   return $acc if ($acc eq $self->{qual_ref}->accession_number());\n   # should this become a warning?\n   # print(\"accession numbers $acc and $self->{qual_ref}->accession_number() do not match. Bummer.\\n\");\n}\n\n=head2 _common_primary_id()\n\n Title   : _common_primary_id()\n Usage   : $common_primard_id = $self->_common_primary_id();\n Function: Compare the primary_id of {qual_ref} and {seq_ref}.\n Returns : Nothing if they don't match. If they do return {seq_ref}->primary_id()\n Args    : None.\n\n\n#'\nsub _common_primary_id {\n   my $self = shift;\n   return if ($self->{seq_ref} || $self->{qual_ref});\n   my $pid = $self->{seq_ref}->primary_id();\n   return if (!$pid);\n   return $pid if ($pid eq $self->{qual_ref}->primary_id());\n   # should this become a warning?\n   # print(\"primary_ids $pid and $self->{qual_ref}->primary_id() do not match. Bummer.\\n\");\n}\n\n=head2 _common_desc()\n\n Title   : _common_desc()\n Usage   : $common_desc = $self->_common_desc();\n Function: Compare the desc of {qual_ref} and {seq_ref}.\n Returns : Nothing if they don't match. If they do return {seq_ref}->desc()\n Args    : None.\n\n\n#'\nsub _common_desc {\n   my $self = shift;\n   return if ($self->{seq_ref} || $self->{qual_ref});\n   my $des = $self->{seq_ref}->desc();\n   return if (!$des);\n   return $des if ($des eq $self->{qual_ref}->desc());\n   # should this become a warning?\n   # print(\"descriptions $des and $self->{qual_ref}->desc() do not match. Bummer.\\n\");\n}\n\n=head2 set_common_descriptors()\n\n Title   : set_common_descriptors()\n Usage   : $self->set_common_descriptors();\n Function: Compare the descriptors (id,accession_number,display_id,\n           primary_id, desc) for the PrimarySeq and PrimaryQual objects\n           within the SeqWithQuality object. If they match, make that\n           descriptor the descriptor for the SeqWithQuality object.\n Returns : Nothing.\n Args    : None.\n\n\nsub set_common_descriptors {\n   my $self = shift;\n   return if ($self->{seq_ref} || $self->{qual_ref});\n   &_common_id();\n   &_common_display_id();\n   &_common_accession_number();\n   &_common_primary_id();\n   &_common_desc();\n}\n\n=head2 alphabet()\n\n Title   : alphabet();\n Usage   : $molecule_type = $obj->alphabet();\n Function: Get the molecule type from the PrimarySeq object.\n Returns : What what PrimarySeq says the type of the sequence is.\n Args    : None.\n\n\nsub alphabet {\n   my $self = shift;\n   return $self->{seq_ref}->alphabet();\n}\n\n=head2 display_id()\n\n Title   : display_id()\n Usage   : $id_string = $obj->display_id();\n Function: Returns the display id, aka the common name of the Quality object.\n           The semantics of this is that it is the most likely string to be\n           used as an identifier of the quality sequence, and likely to have\n           \"human\" readability.  The id is equivalent to the ID field of the\n           GenBank/EMBL databanks and the id field of the Swissprot/sptrembl\n           database. In fasta format, the >(\\S+) is presumed to be the id,\n           though some people overload the id to embed other information.\n           Bioperl does not use any embedded information in the ID field,\n           and people are encouraged to use other mechanisms (accession\n           field for example, or extending the sequence object) to solve\n           this. Notice that $seq->id() maps to this function, mainly for\n           legacy/convience issues.\n           This method sets the display_id for the SeqWithQuality object.\n Returns : A string\n Args    : If a scalar is provided, it is set as the new display_id for\n           the SeqWithQuality object.\n Status  : Virtual\n\n\nsub display_id {\n   my ($obj,$value) = @_;\n   if( defined $value) {\n      $obj->{'display_id'} = $value;\n    }\n    return $obj->{'display_id'};\n\n}\n\n=head2 accession_number()\n\n Title   : accession_number()\n Usage   : $unique_biological_key = $obj->accession_number();\n Function: Returns the unique biological id for a sequence, commonly\n           called the accession_number. For sequences from established\n           databases, the implementors should try to use the correct\n           accession number. Notice that primary_id() provides the unique id\n           for the implemetation, allowing multiple objects to have the same\n           accession number in a particular implementation. For sequences\n           with no accession number, this method should return \"unknown\".\n           This method sets the accession_number for the SeqWithQuality\n           object. \n Returns : A string (the value of accession_number)\n Args    : If a scalar is provided, it is set as the new accession_number\n           for the SeqWithQuality object.\n Status  : Virtual\n\n\nsub accession_number {\n    my( $obj, $acc ) = @_;\n\n    if (defined $acc) {\n        $obj->{'accession_number'} = $acc;\n    } else {\n        $acc = $obj->{'accession_number'};\n        $acc = 'unknown' unless defined $acc;\n    }\n    return $acc;\n}\n\n=head2 primary_id()\n\n Title   : primary_id()\n Usage   : $unique_implementation_key = $obj->primary_id();\n Function: Returns the unique id for this object in this implementation.\n           This allows implementations to manage their own object ids in a\n           way the implementaiton can control clients can expect one id to\n           map to one object. For sequences with no accession number, this\n           method should return a stringified memory location.\n           This method sets the primary_id for the SeqWithQuality object.\n Returns : A string. (the value of primary_id)\n Args    : If a scalar is provided, it is set as the new primary_id for\n           the SeqWithQuality object.\n\n\nsub primary_id {\n   my ($obj,$value) = @_;\n   if ($value) {\n      $obj->{'primary_id'} = $value;\n    }\n   return $obj->{'primary_id'};\n\n}\n\n=head2 desc()\n\n Title   : desc()\n Usage   : $qual->desc($newval); _or_ \n           $description = $qual->desc();\n Function: Get/set description text for this SeqWithQuality object.\n Returns : A string. (the value of desc)\n Args    : If a scalar is provided, it is set as the new desc for the\n           SeqWithQuality object.\n\n\nsub desc {\n   # a mechanism to set the disc for the SeqWithQuality object.\n   # probably will be used most often by set_common_features()\n   my ($obj,$value) = @_;\n   if( defined $value) {\n      $obj->{'desc'} = $value;\n   }\n   return $obj->{'desc'};\n}\n\n=head2 id()\n\n Title   : id()\n Usage   : $id = $qual->id();\n Function: Return the ID of the quality. This should normally be (and\n           actually is in the implementation provided here) just a synonym\n           for display_id().\n Returns : A string. (the value of id)\n Args    : If a scalar is provided, it is set as the new id for the\n           SeqWithQuality object.","label":"id($self,$value)"},"detail":"($self,$value)"},{"containerName":"main::","definition":"sub","detail":"($self,$value)","signature":{"label":"seq($self,$value)","documentation":"1;\n# $Id: SeqWithQuality.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Seq::QualI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chad Matsalla <bioinformatics@dieselwurks.com\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::SeqWithQuality - Bioperl object packaging a sequence with its quality.\nDeprecated class, use Bio::Seq::Quality instead!\n\n=head1 SYNOPSIS\n\n    use Bio::PrimarySeq;\n    use Bio::Seq::PrimaryQual;\n    use Bio::Seq::SeqWithQuality;\n\n    # make from memory\n    my $qual = Bio::Seq::SeqWithQuality->new\n    ( -qual => '10 20 30 40 50 50 20 10',\n      -seq => 'ATCGATCG',\n      -id  => 'human_id',\n      -accession_number => 'AL000012',\n    );\n\n    # make from objects\n    # first, make a PrimarySeq object\n    my $seqobj = Bio::PrimarySeq->new\n    ( -seq => 'atcgatcg',\n      -id  => 'GeneFragment-12',\n      -accession_number => 'X78121',\n      -alphabet => 'dna'\n    );\n\n    # now make a PrimaryQual object\n    my $qualobj = Bio::Seq::PrimaryQual->new\n    ( -qual => '10 20 30 40 50 50 20 10',\n      -id  => 'GeneFragment-12',\n      -accession_number => 'X78121',\n      -alphabet => 'dna'\n    );\n\n    # now make the SeqWithQuality object\n    my $swqobj = Bio::Seq::SeqWithQuality->new\n    ( -seq  => $seqobj,\n      -qual => $qualobj\n    );\n    # done!\n\n    $swqobj->id(); # the id of the SeqWithQuality object\n    # may not match the the id of the sequence or\n    # of the quality (check the pod, luke)\n    $swqobj->seq(); # the sequence of the SeqWithQuality object\n    $swqobj->qual(); # the quality of the SeqWithQuality object\n\n    # to get out parts of the sequence.\n\n    print \"Sequence \", $seqobj->id(), \" with accession \",\n    $seqobj->accession, \" and desc \", $seqobj->desc, \"\\n\";\n\n    $string2 = $seqobj->subseq(1,40);\n\n=head1 DESCRIPTION\n\nThis object stores base quality values together with the sequence string.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nEmail bioinformatics@dieselwurks.com\n\n=head1 CONTRIBUTORS \n\nJason Stajich, jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\npackage Bio::Seq::SeqWithQuality;\n\n\nuse strict;\nuse Bio::PrimarySeq;\nuse Bio::Seq::PrimaryQual;\n\nuse base qw(Bio::Root::Root Bio::PrimarySeqI Bio::Seq::QualI);\n\n=head2 new()\n\n Title   : new()\n Usage   : $qual = Bio::Seq::SeqWithQuality ->new\n             ( -qual => '10 20 30 40 50 50 20 10',\n               -seq => 'ATCGATCG',\n               -id  => 'human_id',\n               -accession_number => 'AL000012',\n               -trace_indices    => '0 5 10 15 20 25 30 35'\n             );\n Function: Returns a new Bio::Seq::SeqWithQual object from basic\n           constructors.\n Returns : a new Bio::Seq::PrimaryQual object\n Args    : -qual can be a quality string (see Bio::Seq::PrimaryQual for more\n            information on this) or a reference to a Bio::Seq::PrimaryQual\n            object.\n           -seq can be a sequence string (see Bio::PrimarySeq for more\n            information on this) or a reference to a Bio::PrimaryQual object.\n           -seq, -id, -accession_number, -primary_id, -desc, -id behave like\n            this:\n             1. if they are provided on construction of the\n                 Bio::Seq::SeqWithQuality they will be set as the descriptors for\n                 the object unless changed by one of the following mechanisms:\n              a) $obj->set_common_descriptors() is used and both the -seq and\n                 the -qual object have the same descriptors. These common\n                 descriptors will then become the descriptors for the\n                 Bio::Seq::SeqWithQual object.\n              b) the descriptors are manually set using the seq(), id(),\n                 desc(), or accession_number(), primary_id(),\n             2. if no descriptors are provided, the new() constructor will see\n                if the descriptor used in the PrimarySeq and in the\n                PrimaryQual objects match. If they do, they will become\n                the descriptors for the SeqWithQuality object.\n             To eliminate ambiguity, I strongly suggest you set the\n             descriptors manually on construction of the object. Really.\n           -trace_indices : a space_delimited list of trace indices\n            (where would the peaks be drawn if this list of qualities\n            was to be plotted?)\n\n\nsub new {\n   my ($class, @args) = @_;\n   my $self = $class->SUPER::new(@args);\n   # default: turn OFF the warnings\n   $self->{supress_warnings} = 1;\n   my($qual,$seq,$id,$acc,$pid,$desc,$given_id,$alphabet,$trace_indices) =\n   $self->_rearrange([qw( QUAL SEQ DISPLAY_ID ACCESSION_NUMBER PRIMARY_ID DESC\n     ID ALPHABET TRACE_INDICES )], @args);\n   # Deal with the ID\n   if ( defined $id && defined $given_id ) {\n      if( $id ne $given_id ) {\n         $self->throw(\"Provided both id and display_id constructor functions. [$id] [$given_id]\");\n      }\n   }\n   if( defined $given_id ) {\n      $self->display_id($given_id);\n      $id = $given_id;\n   }\n   # Import sequence first\n   if (!$seq) {\n      my $id;\n      unless ($self->{supress_warnings} == 1) {\n         $self->warn(\"You did not provide sequence information during the \".\n           \"construction of a Bio::Seq::SeqWithQuality object. Sequence \".\n           \"components for this object will be empty.\");\n      }\n      if (!$alphabet) {\n         $self->throw(\"If you want me to create a PrimarySeq object for your \".\n           \"empty sequence <boggle> you must specify a -alphabet to satisfy \".\n           \"the constructor requirements for a Bio::PrimarySeq object with no \".\n           \"sequence. Read the POD for it, luke.\");\n      }\n      $self->{seq_ref} = Bio::PrimarySeq->new( -seq              =>  \"\",\n                                               -accession_number =>  $acc,\n                                               -primary_id       =>  $pid,\n                                               -desc             =>  $desc,\n                                               -display_id       =>  $id,\n                                               -alphabet         =>  $alphabet );\n   } elsif ($seq->isa('Bio::PrimarySeqI') || $seq->isa('Bio::SeqI')) {\n      $self->{seq_ref} = $seq;\n   } elsif (ref($seq)) {\n      $self->throw(\"You passed a seq argument into a SeqWithQUality object and\".\n        \" it was a reference ($seq) which did not inherit from Bio::SeqI or \".\n        \"Bio::PrimarySeqI. I don't know what to do with this!\");\n   } else {\n      my $seqobj = Bio::PrimarySeq->new( -seq              => $seq,\n                                         -accession_number => $acc,\n                                         -primary_id       => $pid,\n                                         -desc             => $desc,\n                                         -display_id       => $id   );\n      $self->{seq_ref} = $seqobj;\n   }\n   # Then import the quality scores\n   if (!defined($qual)) {\n      $self->{qual_ref} = Bio::Seq::PrimaryQual->new( -qual             => \"\",\n                                                      -accession_number => $acc,\n                                                      -primary_id       => $pid,\n                                                      -desc             => $desc,\n                                                      -display_id       => $id, );\n   } elsif (ref($qual) eq \"Bio::Seq::PrimaryQual\") {\n      $self->{qual_ref} = $qual;\n   } else {\n      my $qualobj = Bio::Seq::PrimaryQual->new( -qual             => $qual,\n                                                -accession_number => $acc,\n                                                -primary_id       => $pid,\n                                                -desc             => $desc,\n                                                -display_id       => $id,\n                                                -trace_indices    => $trace_indices );\n      $self->{qual_ref} = $qualobj;\n   }\n   # Now try to set the descriptors for this object\n   $self->_set_descriptors($qual,$seq,$id,$acc,$pid,$desc,$given_id,$alphabet);\n   $self->length();\n   $self->deprecated(\"deprecated class - use Bio::Seq::Quality instead\");\n\n   return $self;\n}\n\n=head2 _common_id()\n\n Title   : _common_id()\n Usage   : $common_id = $self->_common_id();\n Function: Compare the display_id of {qual_ref} and {seq_ref}.\n Returns : Nothing if they don't match. If they do return {seq_ref}->display_id()\n Args    : None.\n\n\n#'\nsub _common_id {\n   my $self = shift;\n   return if (!$self->{seq_ref} || !$self->{qual_ref});\n   my $sid = $self->{seq_ref}->display_id();\n   return if (!$sid);\n   return if (!$self->{qual_ref}->display_id());\n   return $sid if ($sid eq $self->{qual_ref}->display_id());\n   # should this become a warning?\n   # print(\"ids $sid and $self->{qual_ref}->display_id() do not match. Bummer.\\n\");\n}\n\n=head2 _common_display_id()\n\n Title   : _common_id()\n Usage   : $common_id = $self->_common_display_id();\n Function: Compare the display_id of {qual_ref} and {seq_ref}.\n Returns : Nothing if they don't match. If they do return {seq_ref}->display_id()\n Args    : None.\n\n\n#'\nsub _common_display_id {\n   my $self = shift;\n   $self->common_id();\n}\n\n=head2 _common_accession_number()\n\n Title   : _common_accession_number()\n Usage   : $common_id = $self->_common_accession_number();\n Function: Compare the accession_number() of {qual_ref} and {seq_ref}.\n Returns : Nothing if they don't match. If they do return {seq_ref}->accession_number()\n Args    : None.\n\n\n#'\nsub _common_accession_number {\n   my $self = shift;\n   return if ($self->{seq_ref} || $self->{qual_ref});\n   my $acc = $self->{seq_ref}->accession_number();\n   # if (!$acc) { print(\"the seqref has no acc.\\n\"); }\n   return if (!$acc);\n   # if ($acc eq $self->{qual_ref}->accession_number()) { print(\"$acc matches \".$self->{qual_ref}->accession_number().\"\\n\"); }\n   return $acc if ($acc eq $self->{qual_ref}->accession_number());\n   # should this become a warning?\n   # print(\"accession numbers $acc and $self->{qual_ref}->accession_number() do not match. Bummer.\\n\");\n}\n\n=head2 _common_primary_id()\n\n Title   : _common_primary_id()\n Usage   : $common_primard_id = $self->_common_primary_id();\n Function: Compare the primary_id of {qual_ref} and {seq_ref}.\n Returns : Nothing if they don't match. If they do return {seq_ref}->primary_id()\n Args    : None.\n\n\n#'\nsub _common_primary_id {\n   my $self = shift;\n   return if ($self->{seq_ref} || $self->{qual_ref});\n   my $pid = $self->{seq_ref}->primary_id();\n   return if (!$pid);\n   return $pid if ($pid eq $self->{qual_ref}->primary_id());\n   # should this become a warning?\n   # print(\"primary_ids $pid and $self->{qual_ref}->primary_id() do not match. Bummer.\\n\");\n}\n\n=head2 _common_desc()\n\n Title   : _common_desc()\n Usage   : $common_desc = $self->_common_desc();\n Function: Compare the desc of {qual_ref} and {seq_ref}.\n Returns : Nothing if they don't match. If they do return {seq_ref}->desc()\n Args    : None.\n\n\n#'\nsub _common_desc {\n   my $self = shift;\n   return if ($self->{seq_ref} || $self->{qual_ref});\n   my $des = $self->{seq_ref}->desc();\n   return if (!$des);\n   return $des if ($des eq $self->{qual_ref}->desc());\n   # should this become a warning?\n   # print(\"descriptions $des and $self->{qual_ref}->desc() do not match. Bummer.\\n\");\n}\n\n=head2 set_common_descriptors()\n\n Title   : set_common_descriptors()\n Usage   : $self->set_common_descriptors();\n Function: Compare the descriptors (id,accession_number,display_id,\n           primary_id, desc) for the PrimarySeq and PrimaryQual objects\n           within the SeqWithQuality object. If they match, make that\n           descriptor the descriptor for the SeqWithQuality object.\n Returns : Nothing.\n Args    : None.\n\n\nsub set_common_descriptors {\n   my $self = shift;\n   return if ($self->{seq_ref} || $self->{qual_ref});\n   &_common_id();\n   &_common_display_id();\n   &_common_accession_number();\n   &_common_primary_id();\n   &_common_desc();\n}\n\n=head2 alphabet()\n\n Title   : alphabet();\n Usage   : $molecule_type = $obj->alphabet();\n Function: Get the molecule type from the PrimarySeq object.\n Returns : What what PrimarySeq says the type of the sequence is.\n Args    : None.\n\n\nsub alphabet {\n   my $self = shift;\n   return $self->{seq_ref}->alphabet();\n}\n\n=head2 display_id()\n\n Title   : display_id()\n Usage   : $id_string = $obj->display_id();\n Function: Returns the display id, aka the common name of the Quality object.\n           The semantics of this is that it is the most likely string to be\n           used as an identifier of the quality sequence, and likely to have\n           \"human\" readability.  The id is equivalent to the ID field of the\n           GenBank/EMBL databanks and the id field of the Swissprot/sptrembl\n           database. In fasta format, the >(\\S+) is presumed to be the id,\n           though some people overload the id to embed other information.\n           Bioperl does not use any embedded information in the ID field,\n           and people are encouraged to use other mechanisms (accession\n           field for example, or extending the sequence object) to solve\n           this. Notice that $seq->id() maps to this function, mainly for\n           legacy/convience issues.\n           This method sets the display_id for the SeqWithQuality object.\n Returns : A string\n Args    : If a scalar is provided, it is set as the new display_id for\n           the SeqWithQuality object.\n Status  : Virtual\n\n\nsub display_id {\n   my ($obj,$value) = @_;\n   if( defined $value) {\n      $obj->{'display_id'} = $value;\n    }\n    return $obj->{'display_id'};\n\n}\n\n=head2 accession_number()\n\n Title   : accession_number()\n Usage   : $unique_biological_key = $obj->accession_number();\n Function: Returns the unique biological id for a sequence, commonly\n           called the accession_number. For sequences from established\n           databases, the implementors should try to use the correct\n           accession number. Notice that primary_id() provides the unique id\n           for the implemetation, allowing multiple objects to have the same\n           accession number in a particular implementation. For sequences\n           with no accession number, this method should return \"unknown\".\n           This method sets the accession_number for the SeqWithQuality\n           object. \n Returns : A string (the value of accession_number)\n Args    : If a scalar is provided, it is set as the new accession_number\n           for the SeqWithQuality object.\n Status  : Virtual\n\n\nsub accession_number {\n    my( $obj, $acc ) = @_;\n\n    if (defined $acc) {\n        $obj->{'accession_number'} = $acc;\n    } else {\n        $acc = $obj->{'accession_number'};\n        $acc = 'unknown' unless defined $acc;\n    }\n    return $acc;\n}\n\n=head2 primary_id()\n\n Title   : primary_id()\n Usage   : $unique_implementation_key = $obj->primary_id();\n Function: Returns the unique id for this object in this implementation.\n           This allows implementations to manage their own object ids in a\n           way the implementaiton can control clients can expect one id to\n           map to one object. For sequences with no accession number, this\n           method should return a stringified memory location.\n           This method sets the primary_id for the SeqWithQuality object.\n Returns : A string. (the value of primary_id)\n Args    : If a scalar is provided, it is set as the new primary_id for\n           the SeqWithQuality object.\n\n\nsub primary_id {\n   my ($obj,$value) = @_;\n   if ($value) {\n      $obj->{'primary_id'} = $value;\n    }\n   return $obj->{'primary_id'};\n\n}\n\n=head2 desc()\n\n Title   : desc()\n Usage   : $qual->desc($newval); _or_ \n           $description = $qual->desc();\n Function: Get/set description text for this SeqWithQuality object.\n Returns : A string. (the value of desc)\n Args    : If a scalar is provided, it is set as the new desc for the\n           SeqWithQuality object.\n\n\nsub desc {\n   # a mechanism to set the disc for the SeqWithQuality object.\n   # probably will be used most often by set_common_features()\n   my ($obj,$value) = @_;\n   if( defined $value) {\n      $obj->{'desc'} = $value;\n   }\n   return $obj->{'desc'};\n}\n\n=head2 id()\n\n Title   : id()\n Usage   : $id = $qual->id();\n Function: Return the ID of the quality. This should normally be (and\n           actually is in the implementation provided here) just a synonym\n           for display_id().\n Returns : A string. (the value of id)\n Args    : If a scalar is provided, it is set as the new id for the\n           SeqWithQuality object.\n\n\nsub id {\n   my ($self,$value) = @_;\n   if (!$self) { $self->throw(\"no value for self in $value\"); }\n   if( defined $value ) {\n      return $self->display_id($value);\n   }\n   return $self->display_id();\n}\n\n=head2 seq\n\n Title   : seq()\n Usage   : $string    = $obj->seq(); _or_ $obj->seq(\"atctatcatca\");\n Function: Returns the sequence that is contained in the imbedded in the\n           PrimarySeq object within the SeqWithQuality object\n Returns : A scalar (the seq() value for the imbedded PrimarySeq object.)\n Args    : If a scalar is provided, the SeqWithQuality object will\n           attempt to set that as the sequence for the imbedded PrimarySeq\n           object. Otherwise, the value of seq() for the PrimarySeq object\n           is returned.\n Notes   : This is probably not a good idea because you then should call\n           length() to make sure that the sequence and quality are of the\n           same length. Even then, how can you make sure that this sequence\n           belongs with that quality? I provided this to give you rope to\n           hang yourself with. Tie it to a strong device and use a good\n           knot.","parameters":[{"label":"$self"},{"label":"$value"}]},"kind":12,"line":543,"children":[{"localvar":"my","containerName":"seq","name":"$self","definition":"my","line":544,"kind":13},{"kind":13,"line":544,"name":"$value","containerName":"seq"},{"name":"$value","containerName":"seq","line":545,"kind":13},{"kind":13,"line":546,"name":"$self","containerName":"seq"},{"line":546,"kind":12,"containerName":"seq","name":"seq"},{"name":"$value","containerName":"seq","line":546,"kind":13},{"line":547,"kind":13,"name":"$self","containerName":"seq"},{"name":"length","containerName":"seq","line":547,"kind":12},{"name":"$self","containerName":"seq","kind":13,"line":549},{"line":549,"kind":12,"name":"seq","containerName":"seq"}],"name":"seq","range":{"start":{"character":0,"line":543},"end":{"character":9999,"line":550}}},{"kind":12,"line":546,"name":"seq_ref"},{"name":"seq_ref","line":549,"kind":12},{"signature":{"label":"qual($self,$value)","documentation":"1;\n# $Id: SeqWithQuality.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Seq::QualI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chad Matsalla <bioinformatics@dieselwurks.com\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::SeqWithQuality - Bioperl object packaging a sequence with its quality.\nDeprecated class, use Bio::Seq::Quality instead!\n\n=head1 SYNOPSIS\n\n    use Bio::PrimarySeq;\n    use Bio::Seq::PrimaryQual;\n    use Bio::Seq::SeqWithQuality;\n\n    # make from memory\n    my $qual = Bio::Seq::SeqWithQuality->new\n    ( -qual => '10 20 30 40 50 50 20 10',\n      -seq => 'ATCGATCG',\n      -id  => 'human_id',\n      -accession_number => 'AL000012',\n    );\n\n    # make from objects\n    # first, make a PrimarySeq object\n    my $seqobj = Bio::PrimarySeq->new\n    ( -seq => 'atcgatcg',\n      -id  => 'GeneFragment-12',\n      -accession_number => 'X78121',\n      -alphabet => 'dna'\n    );\n\n    # now make a PrimaryQual object\n    my $qualobj = Bio::Seq::PrimaryQual->new\n    ( -qual => '10 20 30 40 50 50 20 10',\n      -id  => 'GeneFragment-12',\n      -accession_number => 'X78121',\n      -alphabet => 'dna'\n    );\n\n    # now make the SeqWithQuality object\n    my $swqobj = Bio::Seq::SeqWithQuality->new\n    ( -seq  => $seqobj,\n      -qual => $qualobj\n    );\n    # done!\n\n    $swqobj->id(); # the id of the SeqWithQuality object\n    # may not match the the id of the sequence or\n    # of the quality (check the pod, luke)\n    $swqobj->seq(); # the sequence of the SeqWithQuality object\n    $swqobj->qual(); # the quality of the SeqWithQuality object\n\n    # to get out parts of the sequence.\n\n    print \"Sequence \", $seqobj->id(), \" with accession \",\n    $seqobj->accession, \" and desc \", $seqobj->desc, \"\\n\";\n\n    $string2 = $seqobj->subseq(1,40);\n\n=head1 DESCRIPTION\n\nThis object stores base quality values together with the sequence string.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nEmail bioinformatics@dieselwurks.com\n\n=head1 CONTRIBUTORS \n\nJason Stajich, jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\npackage Bio::Seq::SeqWithQuality;\n\n\nuse strict;\nuse Bio::PrimarySeq;\nuse Bio::Seq::PrimaryQual;\n\nuse base qw(Bio::Root::Root Bio::PrimarySeqI Bio::Seq::QualI);\n\n=head2 new()\n\n Title   : new()\n Usage   : $qual = Bio::Seq::SeqWithQuality ->new\n             ( -qual => '10 20 30 40 50 50 20 10',\n               -seq => 'ATCGATCG',\n               -id  => 'human_id',\n               -accession_number => 'AL000012',\n               -trace_indices    => '0 5 10 15 20 25 30 35'\n             );\n Function: Returns a new Bio::Seq::SeqWithQual object from basic\n           constructors.\n Returns : a new Bio::Seq::PrimaryQual object\n Args    : -qual can be a quality string (see Bio::Seq::PrimaryQual for more\n            information on this) or a reference to a Bio::Seq::PrimaryQual\n            object.\n           -seq can be a sequence string (see Bio::PrimarySeq for more\n            information on this) or a reference to a Bio::PrimaryQual object.\n           -seq, -id, -accession_number, -primary_id, -desc, -id behave like\n            this:\n             1. if they are provided on construction of the\n                 Bio::Seq::SeqWithQuality they will be set as the descriptors for\n                 the object unless changed by one of the following mechanisms:\n              a) $obj->set_common_descriptors() is used and both the -seq and\n                 the -qual object have the same descriptors. These common\n                 descriptors will then become the descriptors for the\n                 Bio::Seq::SeqWithQual object.\n              b) the descriptors are manually set using the seq(), id(),\n                 desc(), or accession_number(), primary_id(),\n             2. if no descriptors are provided, the new() constructor will see\n                if the descriptor used in the PrimarySeq and in the\n                PrimaryQual objects match. If they do, they will become\n                the descriptors for the SeqWithQuality object.\n             To eliminate ambiguity, I strongly suggest you set the\n             descriptors manually on construction of the object. Really.\n           -trace_indices : a space_delimited list of trace indices\n            (where would the peaks be drawn if this list of qualities\n            was to be plotted?)\n\n\nsub new {\n   my ($class, @args) = @_;\n   my $self = $class->SUPER::new(@args);\n   # default: turn OFF the warnings\n   $self->{supress_warnings} = 1;\n   my($qual,$seq,$id,$acc,$pid,$desc,$given_id,$alphabet,$trace_indices) =\n   $self->_rearrange([qw( QUAL SEQ DISPLAY_ID ACCESSION_NUMBER PRIMARY_ID DESC\n     ID ALPHABET TRACE_INDICES )], @args);\n   # Deal with the ID\n   if ( defined $id && defined $given_id ) {\n      if( $id ne $given_id ) {\n         $self->throw(\"Provided both id and display_id constructor functions. [$id] [$given_id]\");\n      }\n   }\n   if( defined $given_id ) {\n      $self->display_id($given_id);\n      $id = $given_id;\n   }\n   # Import sequence first\n   if (!$seq) {\n      my $id;\n      unless ($self->{supress_warnings} == 1) {\n         $self->warn(\"You did not provide sequence information during the \".\n           \"construction of a Bio::Seq::SeqWithQuality object. Sequence \".\n           \"components for this object will be empty.\");\n      }\n      if (!$alphabet) {\n         $self->throw(\"If you want me to create a PrimarySeq object for your \".\n           \"empty sequence <boggle> you must specify a -alphabet to satisfy \".\n           \"the constructor requirements for a Bio::PrimarySeq object with no \".\n           \"sequence. Read the POD for it, luke.\");\n      }\n      $self->{seq_ref} = Bio::PrimarySeq->new( -seq              =>  \"\",\n                                               -accession_number =>  $acc,\n                                               -primary_id       =>  $pid,\n                                               -desc             =>  $desc,\n                                               -display_id       =>  $id,\n                                               -alphabet         =>  $alphabet );\n   } elsif ($seq->isa('Bio::PrimarySeqI') || $seq->isa('Bio::SeqI')) {\n      $self->{seq_ref} = $seq;\n   } elsif (ref($seq)) {\n      $self->throw(\"You passed a seq argument into a SeqWithQUality object and\".\n        \" it was a reference ($seq) which did not inherit from Bio::SeqI or \".\n        \"Bio::PrimarySeqI. I don't know what to do with this!\");\n   } else {\n      my $seqobj = Bio::PrimarySeq->new( -seq              => $seq,\n                                         -accession_number => $acc,\n                                         -primary_id       => $pid,\n                                         -desc             => $desc,\n                                         -display_id       => $id   );\n      $self->{seq_ref} = $seqobj;\n   }\n   # Then import the quality scores\n   if (!defined($qual)) {\n      $self->{qual_ref} = Bio::Seq::PrimaryQual->new( -qual             => \"\",\n                                                      -accession_number => $acc,\n                                                      -primary_id       => $pid,\n                                                      -desc             => $desc,\n                                                      -display_id       => $id, );\n   } elsif (ref($qual) eq \"Bio::Seq::PrimaryQual\") {\n      $self->{qual_ref} = $qual;\n   } else {\n      my $qualobj = Bio::Seq::PrimaryQual->new( -qual             => $qual,\n                                                -accession_number => $acc,\n                                                -primary_id       => $pid,\n                                                -desc             => $desc,\n                                                -display_id       => $id,\n                                                -trace_indices    => $trace_indices );\n      $self->{qual_ref} = $qualobj;\n   }\n   # Now try to set the descriptors for this object\n   $self->_set_descriptors($qual,$seq,$id,$acc,$pid,$desc,$given_id,$alphabet);\n   $self->length();\n   $self->deprecated(\"deprecated class - use Bio::Seq::Quality instead\");\n\n   return $self;\n}\n\n=head2 _common_id()\n\n Title   : _common_id()\n Usage   : $common_id = $self->_common_id();\n Function: Compare the display_id of {qual_ref} and {seq_ref}.\n Returns : Nothing if they don't match. If they do return {seq_ref}->display_id()\n Args    : None.\n\n\n#'\nsub _common_id {\n   my $self = shift;\n   return if (!$self->{seq_ref} || !$self->{qual_ref});\n   my $sid = $self->{seq_ref}->display_id();\n   return if (!$sid);\n   return if (!$self->{qual_ref}->display_id());\n   return $sid if ($sid eq $self->{qual_ref}->display_id());\n   # should this become a warning?\n   # print(\"ids $sid and $self->{qual_ref}->display_id() do not match. Bummer.\\n\");\n}\n\n=head2 _common_display_id()\n\n Title   : _common_id()\n Usage   : $common_id = $self->_common_display_id();\n Function: Compare the display_id of {qual_ref} and {seq_ref}.\n Returns : Nothing if they don't match. If they do return {seq_ref}->display_id()\n Args    : None.\n\n\n#'\nsub _common_display_id {\n   my $self = shift;\n   $self->common_id();\n}\n\n=head2 _common_accession_number()\n\n Title   : _common_accession_number()\n Usage   : $common_id = $self->_common_accession_number();\n Function: Compare the accession_number() of {qual_ref} and {seq_ref}.\n Returns : Nothing if they don't match. If they do return {seq_ref}->accession_number()\n Args    : None.\n\n\n#'\nsub _common_accession_number {\n   my $self = shift;\n   return if ($self->{seq_ref} || $self->{qual_ref});\n   my $acc = $self->{seq_ref}->accession_number();\n   # if (!$acc) { print(\"the seqref has no acc.\\n\"); }\n   return if (!$acc);\n   # if ($acc eq $self->{qual_ref}->accession_number()) { print(\"$acc matches \".$self->{qual_ref}->accession_number().\"\\n\"); }\n   return $acc if ($acc eq $self->{qual_ref}->accession_number());\n   # should this become a warning?\n   # print(\"accession numbers $acc and $self->{qual_ref}->accession_number() do not match. Bummer.\\n\");\n}\n\n=head2 _common_primary_id()\n\n Title   : _common_primary_id()\n Usage   : $common_primard_id = $self->_common_primary_id();\n Function: Compare the primary_id of {qual_ref} and {seq_ref}.\n Returns : Nothing if they don't match. If they do return {seq_ref}->primary_id()\n Args    : None.\n\n\n#'\nsub _common_primary_id {\n   my $self = shift;\n   return if ($self->{seq_ref} || $self->{qual_ref});\n   my $pid = $self->{seq_ref}->primary_id();\n   return if (!$pid);\n   return $pid if ($pid eq $self->{qual_ref}->primary_id());\n   # should this become a warning?\n   # print(\"primary_ids $pid and $self->{qual_ref}->primary_id() do not match. Bummer.\\n\");\n}\n\n=head2 _common_desc()\n\n Title   : _common_desc()\n Usage   : $common_desc = $self->_common_desc();\n Function: Compare the desc of {qual_ref} and {seq_ref}.\n Returns : Nothing if they don't match. If they do return {seq_ref}->desc()\n Args    : None.\n\n\n#'\nsub _common_desc {\n   my $self = shift;\n   return if ($self->{seq_ref} || $self->{qual_ref});\n   my $des = $self->{seq_ref}->desc();\n   return if (!$des);\n   return $des if ($des eq $self->{qual_ref}->desc());\n   # should this become a warning?\n   # print(\"descriptions $des and $self->{qual_ref}->desc() do not match. Bummer.\\n\");\n}\n\n=head2 set_common_descriptors()\n\n Title   : set_common_descriptors()\n Usage   : $self->set_common_descriptors();\n Function: Compare the descriptors (id,accession_number,display_id,\n           primary_id, desc) for the PrimarySeq and PrimaryQual objects\n           within the SeqWithQuality object. If they match, make that\n           descriptor the descriptor for the SeqWithQuality object.\n Returns : Nothing.\n Args    : None.\n\n\nsub set_common_descriptors {\n   my $self = shift;\n   return if ($self->{seq_ref} || $self->{qual_ref});\n   &_common_id();\n   &_common_display_id();\n   &_common_accession_number();\n   &_common_primary_id();\n   &_common_desc();\n}\n\n=head2 alphabet()\n\n Title   : alphabet();\n Usage   : $molecule_type = $obj->alphabet();\n Function: Get the molecule type from the PrimarySeq object.\n Returns : What what PrimarySeq says the type of the sequence is.\n Args    : None.\n\n\nsub alphabet {\n   my $self = shift;\n   return $self->{seq_ref}->alphabet();\n}\n\n=head2 display_id()\n\n Title   : display_id()\n Usage   : $id_string = $obj->display_id();\n Function: Returns the display id, aka the common name of the Quality object.\n           The semantics of this is that it is the most likely string to be\n           used as an identifier of the quality sequence, and likely to have\n           \"human\" readability.  The id is equivalent to the ID field of the\n           GenBank/EMBL databanks and the id field of the Swissprot/sptrembl\n           database. In fasta format, the >(\\S+) is presumed to be the id,\n           though some people overload the id to embed other information.\n           Bioperl does not use any embedded information in the ID field,\n           and people are encouraged to use other mechanisms (accession\n           field for example, or extending the sequence object) to solve\n           this. Notice that $seq->id() maps to this function, mainly for\n           legacy/convience issues.\n           This method sets the display_id for the SeqWithQuality object.\n Returns : A string\n Args    : If a scalar is provided, it is set as the new display_id for\n           the SeqWithQuality object.\n Status  : Virtual\n\n\nsub display_id {\n   my ($obj,$value) = @_;\n   if( defined $value) {\n      $obj->{'display_id'} = $value;\n    }\n    return $obj->{'display_id'};\n\n}\n\n=head2 accession_number()\n\n Title   : accession_number()\n Usage   : $unique_biological_key = $obj->accession_number();\n Function: Returns the unique biological id for a sequence, commonly\n           called the accession_number. For sequences from established\n           databases, the implementors should try to use the correct\n           accession number. Notice that primary_id() provides the unique id\n           for the implemetation, allowing multiple objects to have the same\n           accession number in a particular implementation. For sequences\n           with no accession number, this method should return \"unknown\".\n           This method sets the accession_number for the SeqWithQuality\n           object. \n Returns : A string (the value of accession_number)\n Args    : If a scalar is provided, it is set as the new accession_number\n           for the SeqWithQuality object.\n Status  : Virtual\n\n\nsub accession_number {\n    my( $obj, $acc ) = @_;\n\n    if (defined $acc) {\n        $obj->{'accession_number'} = $acc;\n    } else {\n        $acc = $obj->{'accession_number'};\n        $acc = 'unknown' unless defined $acc;\n    }\n    return $acc;\n}\n\n=head2 primary_id()\n\n Title   : primary_id()\n Usage   : $unique_implementation_key = $obj->primary_id();\n Function: Returns the unique id for this object in this implementation.\n           This allows implementations to manage their own object ids in a\n           way the implementaiton can control clients can expect one id to\n           map to one object. For sequences with no accession number, this\n           method should return a stringified memory location.\n           This method sets the primary_id for the SeqWithQuality object.\n Returns : A string. (the value of primary_id)\n Args    : If a scalar is provided, it is set as the new primary_id for\n           the SeqWithQuality object.\n\n\nsub primary_id {\n   my ($obj,$value) = @_;\n   if ($value) {\n      $obj->{'primary_id'} = $value;\n    }\n   return $obj->{'primary_id'};\n\n}\n\n=head2 desc()\n\n Title   : desc()\n Usage   : $qual->desc($newval); _or_ \n           $description = $qual->desc();\n Function: Get/set description text for this SeqWithQuality object.\n Returns : A string. (the value of desc)\n Args    : If a scalar is provided, it is set as the new desc for the\n           SeqWithQuality object.\n\n\nsub desc {\n   # a mechanism to set the disc for the SeqWithQuality object.\n   # probably will be used most often by set_common_features()\n   my ($obj,$value) = @_;\n   if( defined $value) {\n      $obj->{'desc'} = $value;\n   }\n   return $obj->{'desc'};\n}\n\n=head2 id()\n\n Title   : id()\n Usage   : $id = $qual->id();\n Function: Return the ID of the quality. This should normally be (and\n           actually is in the implementation provided here) just a synonym\n           for display_id().\n Returns : A string. (the value of id)\n Args    : If a scalar is provided, it is set as the new id for the\n           SeqWithQuality object.\n\n\nsub id {\n   my ($self,$value) = @_;\n   if (!$self) { $self->throw(\"no value for self in $value\"); }\n   if( defined $value ) {\n      return $self->display_id($value);\n   }\n   return $self->display_id();\n}\n\n=head2 seq\n\n Title   : seq()\n Usage   : $string    = $obj->seq(); _or_ $obj->seq(\"atctatcatca\");\n Function: Returns the sequence that is contained in the imbedded in the\n           PrimarySeq object within the SeqWithQuality object\n Returns : A scalar (the seq() value for the imbedded PrimarySeq object.)\n Args    : If a scalar is provided, the SeqWithQuality object will\n           attempt to set that as the sequence for the imbedded PrimarySeq\n           object. Otherwise, the value of seq() for the PrimarySeq object\n           is returned.\n Notes   : This is probably not a good idea because you then should call\n           length() to make sure that the sequence and quality are of the\n           same length. Even then, how can you make sure that this sequence\n           belongs with that quality? I provided this to give you rope to\n           hang yourself with. Tie it to a strong device and use a good\n           knot.\n\n\nsub seq {\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{seq_ref}->seq($value);\n      $self->length();\n   }\n   return $self->{seq_ref}->seq();\n}\n\n=head2 qual()\n\n Title   : qual()\n Usage   : @quality_values  = @{$obj->qual()}; _or_\n           $obj->qual(\"10 10 20 40 50\");\n Function: Returns the quality as imbedded in the PrimaryQual object\n           within the SeqWithQuality object.\n Returns : A reference to an array containing the quality values in the \n           PrimaryQual object.\n Args    : If a scalar is provided, the SeqWithQuality object will\n           attempt to set that as the quality for the imbedded PrimaryQual\n           object. Otherwise, the value of qual() for the PrimaryQual\n           object is returned.\n Notes   : This is probably not a good idea because you then should call\n           length() to make sure that the sequence and quality are of the\n           same length. Even then, how can you make sure that this sequence\n           belongs with that quality? I provided this to give you a strong\n           board with which to flagellate yourself. ","parameters":[{"label":"$self"},{"label":"$value"}]},"detail":"($self,$value)","definition":"sub","containerName":"main::","children":[{"line":574,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"qual"},{"line":574,"kind":13,"name":"$value","containerName":"qual"},{"kind":13,"line":576,"containerName":"qual","name":"$value"},{"containerName":"qual","name":"$self","line":577,"kind":13},{"name":"qual","containerName":"qual","line":577,"kind":12},{"containerName":"qual","name":"$value","kind":13,"line":577},{"line":579,"kind":13,"name":"$self","containerName":"qual"},{"name":"length","containerName":"qual","line":579,"kind":12},{"containerName":"qual","name":"$self","kind":13,"line":581},{"name":"qual","containerName":"qual","kind":12,"line":581}],"line":573,"kind":12,"range":{"start":{"character":0,"line":573},"end":{"character":9999,"line":582}},"name":"qual"},{"name":"qual_ref","kind":12,"line":577},{"name":"qual_ref","kind":12,"line":581},{"children":[{"kind":13,"line":608,"containerName":"trace_indices","name":"$self","definition":"my","localvar":"my"},{"name":"$value","containerName":"trace_indices","line":608,"kind":13},{"kind":13,"line":610,"containerName":"trace_indices","name":"$value"},{"name":"$self","containerName":"trace_indices","line":611,"kind":13},{"containerName":"trace_indices","name":"trace_indices","line":611,"kind":12},{"line":611,"kind":13,"name":"$value","containerName":"trace_indices"},{"kind":13,"line":613,"name":"$self","containerName":"trace_indices"},{"containerName":"trace_indices","name":"length","line":613,"kind":12},{"name":"$self","containerName":"trace_indices","line":615,"kind":13},{"name":"trace_indices","containerName":"trace_indices","kind":12,"line":615}],"line":607,"kind":12,"signature":{"label":"trace_indices($self,$value)","documentation":"1;\n# $Id: SeqWithQuality.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Seq::QualI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chad Matsalla <bioinformatics@dieselwurks.com\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::SeqWithQuality - Bioperl object packaging a sequence with its quality.\nDeprecated class, use Bio::Seq::Quality instead!\n\n=head1 SYNOPSIS\n\n    use Bio::PrimarySeq;\n    use Bio::Seq::PrimaryQual;\n    use Bio::Seq::SeqWithQuality;\n\n    # make from memory\n    my $qual = Bio::Seq::SeqWithQuality->new\n    ( -qual => '10 20 30 40 50 50 20 10',\n      -seq => 'ATCGATCG',\n      -id  => 'human_id',\n      -accession_number => 'AL000012',\n    );\n\n    # make from objects\n    # first, make a PrimarySeq object\n    my $seqobj = Bio::PrimarySeq->new\n    ( -seq => 'atcgatcg',\n      -id  => 'GeneFragment-12',\n      -accession_number => 'X78121',\n      -alphabet => 'dna'\n    );\n\n    # now make a PrimaryQual object\n    my $qualobj = Bio::Seq::PrimaryQual->new\n    ( -qual => '10 20 30 40 50 50 20 10',\n      -id  => 'GeneFragment-12',\n      -accession_number => 'X78121',\n      -alphabet => 'dna'\n    );\n\n    # now make the SeqWithQuality object\n    my $swqobj = Bio::Seq::SeqWithQuality->new\n    ( -seq  => $seqobj,\n      -qual => $qualobj\n    );\n    # done!\n\n    $swqobj->id(); # the id of the SeqWithQuality object\n    # may not match the the id of the sequence or\n    # of the quality (check the pod, luke)\n    $swqobj->seq(); # the sequence of the SeqWithQuality object\n    $swqobj->qual(); # the quality of the SeqWithQuality object\n\n    # to get out parts of the sequence.\n\n    print \"Sequence \", $seqobj->id(), \" with accession \",\n    $seqobj->accession, \" and desc \", $seqobj->desc, \"\\n\";\n\n    $string2 = $seqobj->subseq(1,40);\n\n=head1 DESCRIPTION\n\nThis object stores base quality values together with the sequence string.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nEmail bioinformatics@dieselwurks.com\n\n=head1 CONTRIBUTORS \n\nJason Stajich, jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\npackage Bio::Seq::SeqWithQuality;\n\n\nuse strict;\nuse Bio::PrimarySeq;\nuse Bio::Seq::PrimaryQual;\n\nuse base qw(Bio::Root::Root Bio::PrimarySeqI Bio::Seq::QualI);\n\n=head2 new()\n\n Title   : new()\n Usage   : $qual = Bio::Seq::SeqWithQuality ->new\n             ( -qual => '10 20 30 40 50 50 20 10',\n               -seq => 'ATCGATCG',\n               -id  => 'human_id',\n               -accession_number => 'AL000012',\n               -trace_indices    => '0 5 10 15 20 25 30 35'\n             );\n Function: Returns a new Bio::Seq::SeqWithQual object from basic\n           constructors.\n Returns : a new Bio::Seq::PrimaryQual object\n Args    : -qual can be a quality string (see Bio::Seq::PrimaryQual for more\n            information on this) or a reference to a Bio::Seq::PrimaryQual\n            object.\n           -seq can be a sequence string (see Bio::PrimarySeq for more\n            information on this) or a reference to a Bio::PrimaryQual object.\n           -seq, -id, -accession_number, -primary_id, -desc, -id behave like\n            this:\n             1. if they are provided on construction of the\n                 Bio::Seq::SeqWithQuality they will be set as the descriptors for\n                 the object unless changed by one of the following mechanisms:\n              a) $obj->set_common_descriptors() is used and both the -seq and\n                 the -qual object have the same descriptors. These common\n                 descriptors will then become the descriptors for the\n                 Bio::Seq::SeqWithQual object.\n              b) the descriptors are manually set using the seq(), id(),\n                 desc(), or accession_number(), primary_id(),\n             2. if no descriptors are provided, the new() constructor will see\n                if the descriptor used in the PrimarySeq and in the\n                PrimaryQual objects match. If they do, they will become\n                the descriptors for the SeqWithQuality object.\n             To eliminate ambiguity, I strongly suggest you set the\n             descriptors manually on construction of the object. Really.\n           -trace_indices : a space_delimited list of trace indices\n            (where would the peaks be drawn if this list of qualities\n            was to be plotted?)\n\n\nsub new {\n   my ($class, @args) = @_;\n   my $self = $class->SUPER::new(@args);\n   # default: turn OFF the warnings\n   $self->{supress_warnings} = 1;\n   my($qual,$seq,$id,$acc,$pid,$desc,$given_id,$alphabet,$trace_indices) =\n   $self->_rearrange([qw( QUAL SEQ DISPLAY_ID ACCESSION_NUMBER PRIMARY_ID DESC\n     ID ALPHABET TRACE_INDICES )], @args);\n   # Deal with the ID\n   if ( defined $id && defined $given_id ) {\n      if( $id ne $given_id ) {\n         $self->throw(\"Provided both id and display_id constructor functions. [$id] [$given_id]\");\n      }\n   }\n   if( defined $given_id ) {\n      $self->display_id($given_id);\n      $id = $given_id;\n   }\n   # Import sequence first\n   if (!$seq) {\n      my $id;\n      unless ($self->{supress_warnings} == 1) {\n         $self->warn(\"You did not provide sequence information during the \".\n           \"construction of a Bio::Seq::SeqWithQuality object. Sequence \".\n           \"components for this object will be empty.\");\n      }\n      if (!$alphabet) {\n         $self->throw(\"If you want me to create a PrimarySeq object for your \".\n           \"empty sequence <boggle> you must specify a -alphabet to satisfy \".\n           \"the constructor requirements for a Bio::PrimarySeq object with no \".\n           \"sequence. Read the POD for it, luke.\");\n      }\n      $self->{seq_ref} = Bio::PrimarySeq->new( -seq              =>  \"\",\n                                               -accession_number =>  $acc,\n                                               -primary_id       =>  $pid,\n                                               -desc             =>  $desc,\n                                               -display_id       =>  $id,\n                                               -alphabet         =>  $alphabet );\n   } elsif ($seq->isa('Bio::PrimarySeqI') || $seq->isa('Bio::SeqI')) {\n      $self->{seq_ref} = $seq;\n   } elsif (ref($seq)) {\n      $self->throw(\"You passed a seq argument into a SeqWithQUality object and\".\n        \" it was a reference ($seq) which did not inherit from Bio::SeqI or \".\n        \"Bio::PrimarySeqI. I don't know what to do with this!\");\n   } else {\n      my $seqobj = Bio::PrimarySeq->new( -seq              => $seq,\n                                         -accession_number => $acc,\n                                         -primary_id       => $pid,\n                                         -desc             => $desc,\n                                         -display_id       => $id   );\n      $self->{seq_ref} = $seqobj;\n   }\n   # Then import the quality scores\n   if (!defined($qual)) {\n      $self->{qual_ref} = Bio::Seq::PrimaryQual->new( -qual             => \"\",\n                                                      -accession_number => $acc,\n                                                      -primary_id       => $pid,\n                                                      -desc             => $desc,\n                                                      -display_id       => $id, );\n   } elsif (ref($qual) eq \"Bio::Seq::PrimaryQual\") {\n      $self->{qual_ref} = $qual;\n   } else {\n      my $qualobj = Bio::Seq::PrimaryQual->new( -qual             => $qual,\n                                                -accession_number => $acc,\n                                                -primary_id       => $pid,\n                                                -desc             => $desc,\n                                                -display_id       => $id,\n                                                -trace_indices    => $trace_indices );\n      $self->{qual_ref} = $qualobj;\n   }\n   # Now try to set the descriptors for this object\n   $self->_set_descriptors($qual,$seq,$id,$acc,$pid,$desc,$given_id,$alphabet);\n   $self->length();\n   $self->deprecated(\"deprecated class - use Bio::Seq::Quality instead\");\n\n   return $self;\n}\n\n=head2 _common_id()\n\n Title   : _common_id()\n Usage   : $common_id = $self->_common_id();\n Function: Compare the display_id of {qual_ref} and {seq_ref}.\n Returns : Nothing if they don't match. If they do return {seq_ref}->display_id()\n Args    : None.\n\n\n#'\nsub _common_id {\n   my $self = shift;\n   return if (!$self->{seq_ref} || !$self->{qual_ref});\n   my $sid = $self->{seq_ref}->display_id();\n   return if (!$sid);\n   return if (!$self->{qual_ref}->display_id());\n   return $sid if ($sid eq $self->{qual_ref}->display_id());\n   # should this become a warning?\n   # print(\"ids $sid and $self->{qual_ref}->display_id() do not match. Bummer.\\n\");\n}\n\n=head2 _common_display_id()\n\n Title   : _common_id()\n Usage   : $common_id = $self->_common_display_id();\n Function: Compare the display_id of {qual_ref} and {seq_ref}.\n Returns : Nothing if they don't match. If they do return {seq_ref}->display_id()\n Args    : None.\n\n\n#'\nsub _common_display_id {\n   my $self = shift;\n   $self->common_id();\n}\n\n=head2 _common_accession_number()\n\n Title   : _common_accession_number()\n Usage   : $common_id = $self->_common_accession_number();\n Function: Compare the accession_number() of {qual_ref} and {seq_ref}.\n Returns : Nothing if they don't match. If they do return {seq_ref}->accession_number()\n Args    : None.\n\n\n#'\nsub _common_accession_number {\n   my $self = shift;\n   return if ($self->{seq_ref} || $self->{qual_ref});\n   my $acc = $self->{seq_ref}->accession_number();\n   # if (!$acc) { print(\"the seqref has no acc.\\n\"); }\n   return if (!$acc);\n   # if ($acc eq $self->{qual_ref}->accession_number()) { print(\"$acc matches \".$self->{qual_ref}->accession_number().\"\\n\"); }\n   return $acc if ($acc eq $self->{qual_ref}->accession_number());\n   # should this become a warning?\n   # print(\"accession numbers $acc and $self->{qual_ref}->accession_number() do not match. Bummer.\\n\");\n}\n\n=head2 _common_primary_id()\n\n Title   : _common_primary_id()\n Usage   : $common_primard_id = $self->_common_primary_id();\n Function: Compare the primary_id of {qual_ref} and {seq_ref}.\n Returns : Nothing if they don't match. If they do return {seq_ref}->primary_id()\n Args    : None.\n\n\n#'\nsub _common_primary_id {\n   my $self = shift;\n   return if ($self->{seq_ref} || $self->{qual_ref});\n   my $pid = $self->{seq_ref}->primary_id();\n   return if (!$pid);\n   return $pid if ($pid eq $self->{qual_ref}->primary_id());\n   # should this become a warning?\n   # print(\"primary_ids $pid and $self->{qual_ref}->primary_id() do not match. Bummer.\\n\");\n}\n\n=head2 _common_desc()\n\n Title   : _common_desc()\n Usage   : $common_desc = $self->_common_desc();\n Function: Compare the desc of {qual_ref} and {seq_ref}.\n Returns : Nothing if they don't match. If they do return {seq_ref}->desc()\n Args    : None.\n\n\n#'\nsub _common_desc {\n   my $self = shift;\n   return if ($self->{seq_ref} || $self->{qual_ref});\n   my $des = $self->{seq_ref}->desc();\n   return if (!$des);\n   return $des if ($des eq $self->{qual_ref}->desc());\n   # should this become a warning?\n   # print(\"descriptions $des and $self->{qual_ref}->desc() do not match. Bummer.\\n\");\n}\n\n=head2 set_common_descriptors()\n\n Title   : set_common_descriptors()\n Usage   : $self->set_common_descriptors();\n Function: Compare the descriptors (id,accession_number,display_id,\n           primary_id, desc) for the PrimarySeq and PrimaryQual objects\n           within the SeqWithQuality object. If they match, make that\n           descriptor the descriptor for the SeqWithQuality object.\n Returns : Nothing.\n Args    : None.\n\n\nsub set_common_descriptors {\n   my $self = shift;\n   return if ($self->{seq_ref} || $self->{qual_ref});\n   &_common_id();\n   &_common_display_id();\n   &_common_accession_number();\n   &_common_primary_id();\n   &_common_desc();\n}\n\n=head2 alphabet()\n\n Title   : alphabet();\n Usage   : $molecule_type = $obj->alphabet();\n Function: Get the molecule type from the PrimarySeq object.\n Returns : What what PrimarySeq says the type of the sequence is.\n Args    : None.\n\n\nsub alphabet {\n   my $self = shift;\n   return $self->{seq_ref}->alphabet();\n}\n\n=head2 display_id()\n\n Title   : display_id()\n Usage   : $id_string = $obj->display_id();\n Function: Returns the display id, aka the common name of the Quality object.\n           The semantics of this is that it is the most likely string to be\n           used as an identifier of the quality sequence, and likely to have\n           \"human\" readability.  The id is equivalent to the ID field of the\n           GenBank/EMBL databanks and the id field of the Swissprot/sptrembl\n           database. In fasta format, the >(\\S+) is presumed to be the id,\n           though some people overload the id to embed other information.\n           Bioperl does not use any embedded information in the ID field,\n           and people are encouraged to use other mechanisms (accession\n           field for example, or extending the sequence object) to solve\n           this. Notice that $seq->id() maps to this function, mainly for\n           legacy/convience issues.\n           This method sets the display_id for the SeqWithQuality object.\n Returns : A string\n Args    : If a scalar is provided, it is set as the new display_id for\n           the SeqWithQuality object.\n Status  : Virtual\n\n\nsub display_id {\n   my ($obj,$value) = @_;\n   if( defined $value) {\n      $obj->{'display_id'} = $value;\n    }\n    return $obj->{'display_id'};\n\n}\n\n=head2 accession_number()\n\n Title   : accession_number()\n Usage   : $unique_biological_key = $obj->accession_number();\n Function: Returns the unique biological id for a sequence, commonly\n           called the accession_number. For sequences from established\n           databases, the implementors should try to use the correct\n           accession number. Notice that primary_id() provides the unique id\n           for the implemetation, allowing multiple objects to have the same\n           accession number in a particular implementation. For sequences\n           with no accession number, this method should return \"unknown\".\n           This method sets the accession_number for the SeqWithQuality\n           object. \n Returns : A string (the value of accession_number)\n Args    : If a scalar is provided, it is set as the new accession_number\n           for the SeqWithQuality object.\n Status  : Virtual\n\n\nsub accession_number {\n    my( $obj, $acc ) = @_;\n\n    if (defined $acc) {\n        $obj->{'accession_number'} = $acc;\n    } else {\n        $acc = $obj->{'accession_number'};\n        $acc = 'unknown' unless defined $acc;\n    }\n    return $acc;\n}\n\n=head2 primary_id()\n\n Title   : primary_id()\n Usage   : $unique_implementation_key = $obj->primary_id();\n Function: Returns the unique id for this object in this implementation.\n           This allows implementations to manage their own object ids in a\n           way the implementaiton can control clients can expect one id to\n           map to one object. For sequences with no accession number, this\n           method should return a stringified memory location.\n           This method sets the primary_id for the SeqWithQuality object.\n Returns : A string. (the value of primary_id)\n Args    : If a scalar is provided, it is set as the new primary_id for\n           the SeqWithQuality object.\n\n\nsub primary_id {\n   my ($obj,$value) = @_;\n   if ($value) {\n      $obj->{'primary_id'} = $value;\n    }\n   return $obj->{'primary_id'};\n\n}\n\n=head2 desc()\n\n Title   : desc()\n Usage   : $qual->desc($newval); _or_ \n           $description = $qual->desc();\n Function: Get/set description text for this SeqWithQuality object.\n Returns : A string. (the value of desc)\n Args    : If a scalar is provided, it is set as the new desc for the\n           SeqWithQuality object.\n\n\nsub desc {\n   # a mechanism to set the disc for the SeqWithQuality object.\n   # probably will be used most often by set_common_features()\n   my ($obj,$value) = @_;\n   if( defined $value) {\n      $obj->{'desc'} = $value;\n   }\n   return $obj->{'desc'};\n}\n\n=head2 id()\n\n Title   : id()\n Usage   : $id = $qual->id();\n Function: Return the ID of the quality. This should normally be (and\n           actually is in the implementation provided here) just a synonym\n           for display_id().\n Returns : A string. (the value of id)\n Args    : If a scalar is provided, it is set as the new id for the\n           SeqWithQuality object.\n\n\nsub id {\n   my ($self,$value) = @_;\n   if (!$self) { $self->throw(\"no value for self in $value\"); }\n   if( defined $value ) {\n      return $self->display_id($value);\n   }\n   return $self->display_id();\n}\n\n=head2 seq\n\n Title   : seq()\n Usage   : $string    = $obj->seq(); _or_ $obj->seq(\"atctatcatca\");\n Function: Returns the sequence that is contained in the imbedded in the\n           PrimarySeq object within the SeqWithQuality object\n Returns : A scalar (the seq() value for the imbedded PrimarySeq object.)\n Args    : If a scalar is provided, the SeqWithQuality object will\n           attempt to set that as the sequence for the imbedded PrimarySeq\n           object. Otherwise, the value of seq() for the PrimarySeq object\n           is returned.\n Notes   : This is probably not a good idea because you then should call\n           length() to make sure that the sequence and quality are of the\n           same length. Even then, how can you make sure that this sequence\n           belongs with that quality? I provided this to give you rope to\n           hang yourself with. Tie it to a strong device and use a good\n           knot.\n\n\nsub seq {\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{seq_ref}->seq($value);\n      $self->length();\n   }\n   return $self->{seq_ref}->seq();\n}\n\n=head2 qual()\n\n Title   : qual()\n Usage   : @quality_values  = @{$obj->qual()}; _or_\n           $obj->qual(\"10 10 20 40 50\");\n Function: Returns the quality as imbedded in the PrimaryQual object\n           within the SeqWithQuality object.\n Returns : A reference to an array containing the quality values in the \n           PrimaryQual object.\n Args    : If a scalar is provided, the SeqWithQuality object will\n           attempt to set that as the quality for the imbedded PrimaryQual\n           object. Otherwise, the value of qual() for the PrimaryQual\n           object is returned.\n Notes   : This is probably not a good idea because you then should call\n           length() to make sure that the sequence and quality are of the\n           same length. Even then, how can you make sure that this sequence\n           belongs with that quality? I provided this to give you a strong\n           board with which to flagellate yourself. \n\n\nsub qual {\n   my ($self,$value) = @_;\n\n   if( defined $value) {\n      $self->{qual_ref}->qual($value);\n      # update the lengths\n      $self->length();\n   }\n   return $self->{qual_ref}->qual();\n}\n\n\n\n=head2 trace_indices()\n\n Title   : trace_indices()\n Usage   : @trace_indice_values  = @{$obj->trace_indices()}; _or_\n           $obj->trace_indices(\"10 10 20 40 50\");\n Function: Returns the trace_indices as imbedded in the Primaryqual object\n           within the SeqWithQualiity object.\n Returns : A reference to an array containing the trace_indice values in the \n           PrimaryQual object.\n Args    : If a scalar is provided, the SeqWithuQuality object will\n           attempt to set that as the trace_indices for the imbedded PrimaryQual\n           object. Otherwise, the value of trace_indices() for the PrimaryQual\n           object is returned.\n Notes   : This is probably not a good idea because you then should call\n           length() to make sure that the sequence and trace_indices are of the\n           same length. Even then, how can you make sure that this sequence\n           belongs with that trace_indicex? I provided this to give you a strong\n           board with which to flagellate yourself. ","parameters":[{"label":"$self"},{"label":"$value"}]},"detail":"($self,$value)","definition":"sub","containerName":"main::","range":{"end":{"line":616,"character":9999},"start":{"character":0,"line":607}},"name":"trace_indices"},{"name":"qual_ref","kind":12,"line":611},{"line":615,"kind":12,"name":"qual_ref"},{"children":[{"line":633,"kind":13,"localvar":"my","containerName":"length","definition":"my","name":"$self"},{"name":"$self","containerName":"length","kind":13,"line":634},{"kind":13,"line":635,"containerName":"length","name":"$self"},{"containerName":"length","name":"$self","kind":13,"line":636},{"name":"warn","containerName":"length","line":636,"kind":12},{"containerName":"length","name":"$self","line":640,"kind":13},{"kind":13,"line":641,"containerName":"length","name":"$self"},{"kind":13,"line":642,"containerName":"length","name":"$self"},{"name":"warn","containerName":"length","kind":12,"line":642},{"kind":13,"line":646,"containerName":"length","name":"$seql","definition":"my","localvar":"my"},{"kind":13,"line":646,"containerName":"length","name":"$self"},{"containerName":"length","name":"length","kind":12,"line":646},{"line":648,"kind":13,"name":"$seql","containerName":"length"},{"containerName":"length","name":"$self","line":648,"kind":13},{"kind":12,"line":648,"name":"length","containerName":"length"},{"containerName":"length","name":"$self","line":649,"kind":13},{"name":"$self","containerName":"length","line":650,"kind":13},{"line":650,"kind":12,"containerName":"length","name":"warn"},{"name":"$seql","containerName":"length","line":650,"kind":13},{"line":651,"kind":13,"containerName":"length","name":"$self"},{"name":"length","containerName":"length","kind":12,"line":651},{"containerName":"length","name":"$self","line":654,"kind":13},{"line":656,"kind":13,"name":"$self","containerName":"length"},{"line":656,"kind":13,"containerName":"length","name":"$seql"},{"name":"$self","containerName":"length","line":658,"kind":13}],"line":632,"kind":12,"range":{"end":{"character":9999,"line":659},"start":{"character":0,"line":632}},"definition":"sub","name":"length","containerName":"main::"},{"name":"seq_ref","line":634,"kind":12},{"kind":12,"line":635,"name":"supress_warnings"},{"line":640,"kind":12,"name":"qual_ref"},{"name":"supress_warnings","line":641,"kind":12},{"line":646,"kind":12,"name":"seq_ref"},{"name":"qual_ref","line":648,"kind":12},{"line":649,"kind":12,"name":"supress_warnings"},{"name":"qual_ref","kind":12,"line":651},{"kind":12,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"qual_obj","line":676,"kind":13},{"containerName":"qual_obj","name":"$value","line":676,"kind":13},{"kind":13,"line":677,"containerName":"qual_obj","name":"$value"},{"kind":13,"line":678,"containerName":"qual_obj","name":"$value"},{"containerName":"qual_obj","name":"$self","kind":13,"line":679},{"kind":13,"line":679,"name":"$value","containerName":"qual_obj"},{"name":"$self","containerName":"qual_obj","kind":13,"line":680},{"name":"debug","containerName":"qual_obj","line":680,"kind":12},{"line":685,"kind":13,"name":"$self","containerName":"qual_obj"},{"containerName":"qual_obj","name":"debug","line":685,"kind":12},{"containerName":"qual_obj","name":"$self","kind":13,"line":691}],"line":675,"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: SeqWithQuality.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Seq::QualI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chad Matsalla <bioinformatics@dieselwurks.com\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::SeqWithQuality - Bioperl object packaging a sequence with its quality.\nDeprecated class, use Bio::Seq::Quality instead!\n\n=head1 SYNOPSIS\n\n    use Bio::PrimarySeq;\n    use Bio::Seq::PrimaryQual;\n    use Bio::Seq::SeqWithQuality;\n\n    # make from memory\n    my $qual = Bio::Seq::SeqWithQuality->new\n    ( -qual => '10 20 30 40 50 50 20 10',\n      -seq => 'ATCGATCG',\n      -id  => 'human_id',\n      -accession_number => 'AL000012',\n    );\n\n    # make from objects\n    # first, make a PrimarySeq object\n    my $seqobj = Bio::PrimarySeq->new\n    ( -seq => 'atcgatcg',\n      -id  => 'GeneFragment-12',\n      -accession_number => 'X78121',\n      -alphabet => 'dna'\n    );\n\n    # now make a PrimaryQual object\n    my $qualobj = Bio::Seq::PrimaryQual->new\n    ( -qual => '10 20 30 40 50 50 20 10',\n      -id  => 'GeneFragment-12',\n      -accession_number => 'X78121',\n      -alphabet => 'dna'\n    );\n\n    # now make the SeqWithQuality object\n    my $swqobj = Bio::Seq::SeqWithQuality->new\n    ( -seq  => $seqobj,\n      -qual => $qualobj\n    );\n    # done!\n\n    $swqobj->id(); # the id of the SeqWithQuality object\n    # may not match the the id of the sequence or\n    # of the quality (check the pod, luke)\n    $swqobj->seq(); # the sequence of the SeqWithQuality object\n    $swqobj->qual(); # the quality of the SeqWithQuality object\n\n    # to get out parts of the sequence.\n\n    print \"Sequence \", $seqobj->id(), \" with accession \",\n    $seqobj->accession, \" and desc \", $seqobj->desc, \"\\n\";\n\n    $string2 = $seqobj->subseq(1,40);\n\n=head1 DESCRIPTION\n\nThis object stores base quality values together with the sequence string.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nEmail bioinformatics@dieselwurks.com\n\n=head1 CONTRIBUTORS \n\nJason Stajich, jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\npackage Bio::Seq::SeqWithQuality;\n\n\nuse strict;\nuse Bio::PrimarySeq;\nuse Bio::Seq::PrimaryQual;\n\nuse base qw(Bio::Root::Root Bio::PrimarySeqI Bio::Seq::QualI);\n\n=head2 new()\n\n Title   : new()\n Usage   : $qual = Bio::Seq::SeqWithQuality ->new\n             ( -qual => '10 20 30 40 50 50 20 10',\n               -seq => 'ATCGATCG',\n               -id  => 'human_id',\n               -accession_number => 'AL000012',\n               -trace_indices    => '0 5 10 15 20 25 30 35'\n             );\n Function: Returns a new Bio::Seq::SeqWithQual object from basic\n           constructors.\n Returns : a new Bio::Seq::PrimaryQual object\n Args    : -qual can be a quality string (see Bio::Seq::PrimaryQual for more\n            information on this) or a reference to a Bio::Seq::PrimaryQual\n            object.\n           -seq can be a sequence string (see Bio::PrimarySeq for more\n            information on this) or a reference to a Bio::PrimaryQual object.\n           -seq, -id, -accession_number, -primary_id, -desc, -id behave like\n            this:\n             1. if they are provided on construction of the\n                 Bio::Seq::SeqWithQuality they will be set as the descriptors for\n                 the object unless changed by one of the following mechanisms:\n              a) $obj->set_common_descriptors() is used and both the -seq and\n                 the -qual object have the same descriptors. These common\n                 descriptors will then become the descriptors for the\n                 Bio::Seq::SeqWithQual object.\n              b) the descriptors are manually set using the seq(), id(),\n                 desc(), or accession_number(), primary_id(),\n             2. if no descriptors are provided, the new() constructor will see\n                if the descriptor used in the PrimarySeq and in the\n                PrimaryQual objects match. If they do, they will become\n                the descriptors for the SeqWithQuality object.\n             To eliminate ambiguity, I strongly suggest you set the\n             descriptors manually on construction of the object. Really.\n           -trace_indices : a space_delimited list of trace indices\n            (where would the peaks be drawn if this list of qualities\n            was to be plotted?)\n\n\nsub new {\n   my ($class, @args) = @_;\n   my $self = $class->SUPER::new(@args);\n   # default: turn OFF the warnings\n   $self->{supress_warnings} = 1;\n   my($qual,$seq,$id,$acc,$pid,$desc,$given_id,$alphabet,$trace_indices) =\n   $self->_rearrange([qw( QUAL SEQ DISPLAY_ID ACCESSION_NUMBER PRIMARY_ID DESC\n     ID ALPHABET TRACE_INDICES )], @args);\n   # Deal with the ID\n   if ( defined $id && defined $given_id ) {\n      if( $id ne $given_id ) {\n         $self->throw(\"Provided both id and display_id constructor functions. [$id] [$given_id]\");\n      }\n   }\n   if( defined $given_id ) {\n      $self->display_id($given_id);\n      $id = $given_id;\n   }\n   # Import sequence first\n   if (!$seq) {\n      my $id;\n      unless ($self->{supress_warnings} == 1) {\n         $self->warn(\"You did not provide sequence information during the \".\n           \"construction of a Bio::Seq::SeqWithQuality object. Sequence \".\n           \"components for this object will be empty.\");\n      }\n      if (!$alphabet) {\n         $self->throw(\"If you want me to create a PrimarySeq object for your \".\n           \"empty sequence <boggle> you must specify a -alphabet to satisfy \".\n           \"the constructor requirements for a Bio::PrimarySeq object with no \".\n           \"sequence. Read the POD for it, luke.\");\n      }\n      $self->{seq_ref} = Bio::PrimarySeq->new( -seq              =>  \"\",\n                                               -accession_number =>  $acc,\n                                               -primary_id       =>  $pid,\n                                               -desc             =>  $desc,\n                                               -display_id       =>  $id,\n                                               -alphabet         =>  $alphabet );\n   } elsif ($seq->isa('Bio::PrimarySeqI') || $seq->isa('Bio::SeqI')) {\n      $self->{seq_ref} = $seq;\n   } elsif (ref($seq)) {\n      $self->throw(\"You passed a seq argument into a SeqWithQUality object and\".\n        \" it was a reference ($seq) which did not inherit from Bio::SeqI or \".\n        \"Bio::PrimarySeqI. I don't know what to do with this!\");\n   } else {\n      my $seqobj = Bio::PrimarySeq->new( -seq              => $seq,\n                                         -accession_number => $acc,\n                                         -primary_id       => $pid,\n                                         -desc             => $desc,\n                                         -display_id       => $id   );\n      $self->{seq_ref} = $seqobj;\n   }\n   # Then import the quality scores\n   if (!defined($qual)) {\n      $self->{qual_ref} = Bio::Seq::PrimaryQual->new( -qual             => \"\",\n                                                      -accession_number => $acc,\n                                                      -primary_id       => $pid,\n                                                      -desc             => $desc,\n                                                      -display_id       => $id, );\n   } elsif (ref($qual) eq \"Bio::Seq::PrimaryQual\") {\n      $self->{qual_ref} = $qual;\n   } else {\n      my $qualobj = Bio::Seq::PrimaryQual->new( -qual             => $qual,\n                                                -accession_number => $acc,\n                                                -primary_id       => $pid,\n                                                -desc             => $desc,\n                                                -display_id       => $id,\n                                                -trace_indices    => $trace_indices );\n      $self->{qual_ref} = $qualobj;\n   }\n   # Now try to set the descriptors for this object\n   $self->_set_descriptors($qual,$seq,$id,$acc,$pid,$desc,$given_id,$alphabet);\n   $self->length();\n   $self->deprecated(\"deprecated class - use Bio::Seq::Quality instead\");\n\n   return $self;\n}\n\n=head2 _common_id()\n\n Title   : _common_id()\n Usage   : $common_id = $self->_common_id();\n Function: Compare the display_id of {qual_ref} and {seq_ref}.\n Returns : Nothing if they don't match. If they do return {seq_ref}->display_id()\n Args    : None.\n\n\n#'\nsub _common_id {\n   my $self = shift;\n   return if (!$self->{seq_ref} || !$self->{qual_ref});\n   my $sid = $self->{seq_ref}->display_id();\n   return if (!$sid);\n   return if (!$self->{qual_ref}->display_id());\n   return $sid if ($sid eq $self->{qual_ref}->display_id());\n   # should this become a warning?\n   # print(\"ids $sid and $self->{qual_ref}->display_id() do not match. Bummer.\\n\");\n}\n\n=head2 _common_display_id()\n\n Title   : _common_id()\n Usage   : $common_id = $self->_common_display_id();\n Function: Compare the display_id of {qual_ref} and {seq_ref}.\n Returns : Nothing if they don't match. If they do return {seq_ref}->display_id()\n Args    : None.\n\n\n#'\nsub _common_display_id {\n   my $self = shift;\n   $self->common_id();\n}\n\n=head2 _common_accession_number()\n\n Title   : _common_accession_number()\n Usage   : $common_id = $self->_common_accession_number();\n Function: Compare the accession_number() of {qual_ref} and {seq_ref}.\n Returns : Nothing if they don't match. If they do return {seq_ref}->accession_number()\n Args    : None.\n\n\n#'\nsub _common_accession_number {\n   my $self = shift;\n   return if ($self->{seq_ref} || $self->{qual_ref});\n   my $acc = $self->{seq_ref}->accession_number();\n   # if (!$acc) { print(\"the seqref has no acc.\\n\"); }\n   return if (!$acc);\n   # if ($acc eq $self->{qual_ref}->accession_number()) { print(\"$acc matches \".$self->{qual_ref}->accession_number().\"\\n\"); }\n   return $acc if ($acc eq $self->{qual_ref}->accession_number());\n   # should this become a warning?\n   # print(\"accession numbers $acc and $self->{qual_ref}->accession_number() do not match. Bummer.\\n\");\n}\n\n=head2 _common_primary_id()\n\n Title   : _common_primary_id()\n Usage   : $common_primard_id = $self->_common_primary_id();\n Function: Compare the primary_id of {qual_ref} and {seq_ref}.\n Returns : Nothing if they don't match. If they do return {seq_ref}->primary_id()\n Args    : None.\n\n\n#'\nsub _common_primary_id {\n   my $self = shift;\n   return if ($self->{seq_ref} || $self->{qual_ref});\n   my $pid = $self->{seq_ref}->primary_id();\n   return if (!$pid);\n   return $pid if ($pid eq $self->{qual_ref}->primary_id());\n   # should this become a warning?\n   # print(\"primary_ids $pid and $self->{qual_ref}->primary_id() do not match. Bummer.\\n\");\n}\n\n=head2 _common_desc()\n\n Title   : _common_desc()\n Usage   : $common_desc = $self->_common_desc();\n Function: Compare the desc of {qual_ref} and {seq_ref}.\n Returns : Nothing if they don't match. If they do return {seq_ref}->desc()\n Args    : None.\n\n\n#'\nsub _common_desc {\n   my $self = shift;\n   return if ($self->{seq_ref} || $self->{qual_ref});\n   my $des = $self->{seq_ref}->desc();\n   return if (!$des);\n   return $des if ($des eq $self->{qual_ref}->desc());\n   # should this become a warning?\n   # print(\"descriptions $des and $self->{qual_ref}->desc() do not match. Bummer.\\n\");\n}\n\n=head2 set_common_descriptors()\n\n Title   : set_common_descriptors()\n Usage   : $self->set_common_descriptors();\n Function: Compare the descriptors (id,accession_number,display_id,\n           primary_id, desc) for the PrimarySeq and PrimaryQual objects\n           within the SeqWithQuality object. If they match, make that\n           descriptor the descriptor for the SeqWithQuality object.\n Returns : Nothing.\n Args    : None.\n\n\nsub set_common_descriptors {\n   my $self = shift;\n   return if ($self->{seq_ref} || $self->{qual_ref});\n   &_common_id();\n   &_common_display_id();\n   &_common_accession_number();\n   &_common_primary_id();\n   &_common_desc();\n}\n\n=head2 alphabet()\n\n Title   : alphabet();\n Usage   : $molecule_type = $obj->alphabet();\n Function: Get the molecule type from the PrimarySeq object.\n Returns : What what PrimarySeq says the type of the sequence is.\n Args    : None.\n\n\nsub alphabet {\n   my $self = shift;\n   return $self->{seq_ref}->alphabet();\n}\n\n=head2 display_id()\n\n Title   : display_id()\n Usage   : $id_string = $obj->display_id();\n Function: Returns the display id, aka the common name of the Quality object.\n           The semantics of this is that it is the most likely string to be\n           used as an identifier of the quality sequence, and likely to have\n           \"human\" readability.  The id is equivalent to the ID field of the\n           GenBank/EMBL databanks and the id field of the Swissprot/sptrembl\n           database. In fasta format, the >(\\S+) is presumed to be the id,\n           though some people overload the id to embed other information.\n           Bioperl does not use any embedded information in the ID field,\n           and people are encouraged to use other mechanisms (accession\n           field for example, or extending the sequence object) to solve\n           this. Notice that $seq->id() maps to this function, mainly for\n           legacy/convience issues.\n           This method sets the display_id for the SeqWithQuality object.\n Returns : A string\n Args    : If a scalar is provided, it is set as the new display_id for\n           the SeqWithQuality object.\n Status  : Virtual\n\n\nsub display_id {\n   my ($obj,$value) = @_;\n   if( defined $value) {\n      $obj->{'display_id'} = $value;\n    }\n    return $obj->{'display_id'};\n\n}\n\n=head2 accession_number()\n\n Title   : accession_number()\n Usage   : $unique_biological_key = $obj->accession_number();\n Function: Returns the unique biological id for a sequence, commonly\n           called the accession_number. For sequences from established\n           databases, the implementors should try to use the correct\n           accession number. Notice that primary_id() provides the unique id\n           for the implemetation, allowing multiple objects to have the same\n           accession number in a particular implementation. For sequences\n           with no accession number, this method should return \"unknown\".\n           This method sets the accession_number for the SeqWithQuality\n           object. \n Returns : A string (the value of accession_number)\n Args    : If a scalar is provided, it is set as the new accession_number\n           for the SeqWithQuality object.\n Status  : Virtual\n\n\nsub accession_number {\n    my( $obj, $acc ) = @_;\n\n    if (defined $acc) {\n        $obj->{'accession_number'} = $acc;\n    } else {\n        $acc = $obj->{'accession_number'};\n        $acc = 'unknown' unless defined $acc;\n    }\n    return $acc;\n}\n\n=head2 primary_id()\n\n Title   : primary_id()\n Usage   : $unique_implementation_key = $obj->primary_id();\n Function: Returns the unique id for this object in this implementation.\n           This allows implementations to manage their own object ids in a\n           way the implementaiton can control clients can expect one id to\n           map to one object. For sequences with no accession number, this\n           method should return a stringified memory location.\n           This method sets the primary_id for the SeqWithQuality object.\n Returns : A string. (the value of primary_id)\n Args    : If a scalar is provided, it is set as the new primary_id for\n           the SeqWithQuality object.\n\n\nsub primary_id {\n   my ($obj,$value) = @_;\n   if ($value) {\n      $obj->{'primary_id'} = $value;\n    }\n   return $obj->{'primary_id'};\n\n}\n\n=head2 desc()\n\n Title   : desc()\n Usage   : $qual->desc($newval); _or_ \n           $description = $qual->desc();\n Function: Get/set description text for this SeqWithQuality object.\n Returns : A string. (the value of desc)\n Args    : If a scalar is provided, it is set as the new desc for the\n           SeqWithQuality object.\n\n\nsub desc {\n   # a mechanism to set the disc for the SeqWithQuality object.\n   # probably will be used most often by set_common_features()\n   my ($obj,$value) = @_;\n   if( defined $value) {\n      $obj->{'desc'} = $value;\n   }\n   return $obj->{'desc'};\n}\n\n=head2 id()\n\n Title   : id()\n Usage   : $id = $qual->id();\n Function: Return the ID of the quality. This should normally be (and\n           actually is in the implementation provided here) just a synonym\n           for display_id().\n Returns : A string. (the value of id)\n Args    : If a scalar is provided, it is set as the new id for the\n           SeqWithQuality object.\n\n\nsub id {\n   my ($self,$value) = @_;\n   if (!$self) { $self->throw(\"no value for self in $value\"); }\n   if( defined $value ) {\n      return $self->display_id($value);\n   }\n   return $self->display_id();\n}\n\n=head2 seq\n\n Title   : seq()\n Usage   : $string    = $obj->seq(); _or_ $obj->seq(\"atctatcatca\");\n Function: Returns the sequence that is contained in the imbedded in the\n           PrimarySeq object within the SeqWithQuality object\n Returns : A scalar (the seq() value for the imbedded PrimarySeq object.)\n Args    : If a scalar is provided, the SeqWithQuality object will\n           attempt to set that as the sequence for the imbedded PrimarySeq\n           object. Otherwise, the value of seq() for the PrimarySeq object\n           is returned.\n Notes   : This is probably not a good idea because you then should call\n           length() to make sure that the sequence and quality are of the\n           same length. Even then, how can you make sure that this sequence\n           belongs with that quality? I provided this to give you rope to\n           hang yourself with. Tie it to a strong device and use a good\n           knot.\n\n\nsub seq {\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{seq_ref}->seq($value);\n      $self->length();\n   }\n   return $self->{seq_ref}->seq();\n}\n\n=head2 qual()\n\n Title   : qual()\n Usage   : @quality_values  = @{$obj->qual()}; _or_\n           $obj->qual(\"10 10 20 40 50\");\n Function: Returns the quality as imbedded in the PrimaryQual object\n           within the SeqWithQuality object.\n Returns : A reference to an array containing the quality values in the \n           PrimaryQual object.\n Args    : If a scalar is provided, the SeqWithQuality object will\n           attempt to set that as the quality for the imbedded PrimaryQual\n           object. Otherwise, the value of qual() for the PrimaryQual\n           object is returned.\n Notes   : This is probably not a good idea because you then should call\n           length() to make sure that the sequence and quality are of the\n           same length. Even then, how can you make sure that this sequence\n           belongs with that quality? I provided this to give you a strong\n           board with which to flagellate yourself. \n\n\nsub qual {\n   my ($self,$value) = @_;\n\n   if( defined $value) {\n      $self->{qual_ref}->qual($value);\n      # update the lengths\n      $self->length();\n   }\n   return $self->{qual_ref}->qual();\n}\n\n\n\n=head2 trace_indices()\n\n Title   : trace_indices()\n Usage   : @trace_indice_values  = @{$obj->trace_indices()}; _or_\n           $obj->trace_indices(\"10 10 20 40 50\");\n Function: Returns the trace_indices as imbedded in the Primaryqual object\n           within the SeqWithQualiity object.\n Returns : A reference to an array containing the trace_indice values in the \n           PrimaryQual object.\n Args    : If a scalar is provided, the SeqWithuQuality object will\n           attempt to set that as the trace_indices for the imbedded PrimaryQual\n           object. Otherwise, the value of trace_indices() for the PrimaryQual\n           object is returned.\n Notes   : This is probably not a good idea because you then should call\n           length() to make sure that the sequence and trace_indices are of the\n           same length. Even then, how can you make sure that this sequence\n           belongs with that trace_indicex? I provided this to give you a strong\n           board with which to flagellate yourself. \n\n\nsub trace_indices {\n   my ($self,$value) = @_;\n\n   if( defined $value) {\n      $self->{qual_ref}->trace_indices($value);\n      # update the lengths\n      $self->length();\n   }\n   return $self->{qual_ref}->trace_indices();\n}\n\n\n\n\n=head2 length()\n\n Title   : length()\n Usage   : $length = $seqWqual->length();\n Function: Get the length of the SeqWithQuality sequence/quality.\n Returns : Returns the length of the sequence and quality if they are\n           both the same. Returns \"DIFFERENT\" if they differ.\n Args    : None.\n\n\nsub length {\n   my $self = shift;\n   if (!$self->{seq_ref}) {\n      unless ($self->{supress_warnings} == 1) {\n         $self->warn(\"Can't find {seq_ref} here in length().\");\n      }\n      return;\n   }\n   if (!$self->{qual_ref}) {\n      unless ($self->{supress_warnings} == 1) {\n         $self->warn(\"Can't find {qual_ref} here in length().\");\n      }\n      return;\n   }\n   my $seql = $self->{seq_ref}->length();\n\n   if ($seql != $self->{qual_ref}->length()) {\n      unless ($self->{supress_warnings} == 1) {\n         $self->warn(\"Sequence length (\".$seql.\") is different from quality \".\n           \"length (\".$self->{qual_ref}->length().\") in the SeqWithQuality \".\n           \"object. This can only lead to problems later.\");\n      }\n      $self->{'length'} = \"DIFFERENT\";\n   } else {\n      $self->{'length'} = $seql;\n   }\n   return $self->{'length'};\n}\n\n\n=head2 qual_obj\n\n Title   : qual_obj($different_obj)\n Usage   : $qualobj = $seqWqual->qual_obj(); _or_\n           $qualobj = $seqWqual->qual_obj($ref_to_primaryqual_obj);\n Function: Get the PrimaryQual object that is imbedded in the\n           SeqWithQuality object or if a reference to a PrimaryQual object\n           is provided, set this as the PrimaryQual object imbedded in the\n           SeqWithQuality object.\n Returns : A reference to a Bio::Seq::SeqWithQuality object.","label":"qual_obj($self,$value)"},"detail":"($self,$value)","name":"qual_obj","range":{"start":{"character":0,"line":675},"end":{"line":692,"character":9999}}},{"name":"qual_ref","line":679,"kind":12},{"line":691,"kind":12,"name":"qual_ref"},{"definition":"sub","containerName":"main::","signature":{"documentation":"1;\n# $Id: SeqWithQuality.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Seq::QualI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chad Matsalla <bioinformatics@dieselwurks.com\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::SeqWithQuality - Bioperl object packaging a sequence with its quality.\nDeprecated class, use Bio::Seq::Quality instead!\n\n=head1 SYNOPSIS\n\n    use Bio::PrimarySeq;\n    use Bio::Seq::PrimaryQual;\n    use Bio::Seq::SeqWithQuality;\n\n    # make from memory\n    my $qual = Bio::Seq::SeqWithQuality->new\n    ( -qual => '10 20 30 40 50 50 20 10',\n      -seq => 'ATCGATCG',\n      -id  => 'human_id',\n      -accession_number => 'AL000012',\n    );\n\n    # make from objects\n    # first, make a PrimarySeq object\n    my $seqobj = Bio::PrimarySeq->new\n    ( -seq => 'atcgatcg',\n      -id  => 'GeneFragment-12',\n      -accession_number => 'X78121',\n      -alphabet => 'dna'\n    );\n\n    # now make a PrimaryQual object\n    my $qualobj = Bio::Seq::PrimaryQual->new\n    ( -qual => '10 20 30 40 50 50 20 10',\n      -id  => 'GeneFragment-12',\n      -accession_number => 'X78121',\n      -alphabet => 'dna'\n    );\n\n    # now make the SeqWithQuality object\n    my $swqobj = Bio::Seq::SeqWithQuality->new\n    ( -seq  => $seqobj,\n      -qual => $qualobj\n    );\n    # done!\n\n    $swqobj->id(); # the id of the SeqWithQuality object\n    # may not match the the id of the sequence or\n    # of the quality (check the pod, luke)\n    $swqobj->seq(); # the sequence of the SeqWithQuality object\n    $swqobj->qual(); # the quality of the SeqWithQuality object\n\n    # to get out parts of the sequence.\n\n    print \"Sequence \", $seqobj->id(), \" with accession \",\n    $seqobj->accession, \" and desc \", $seqobj->desc, \"\\n\";\n\n    $string2 = $seqobj->subseq(1,40);\n\n=head1 DESCRIPTION\n\nThis object stores base quality values together with the sequence string.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nEmail bioinformatics@dieselwurks.com\n\n=head1 CONTRIBUTORS \n\nJason Stajich, jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\npackage Bio::Seq::SeqWithQuality;\n\n\nuse strict;\nuse Bio::PrimarySeq;\nuse Bio::Seq::PrimaryQual;\n\nuse base qw(Bio::Root::Root Bio::PrimarySeqI Bio::Seq::QualI);\n\n=head2 new()\n\n Title   : new()\n Usage   : $qual = Bio::Seq::SeqWithQuality ->new\n             ( -qual => '10 20 30 40 50 50 20 10',\n               -seq => 'ATCGATCG',\n               -id  => 'human_id',\n               -accession_number => 'AL000012',\n               -trace_indices    => '0 5 10 15 20 25 30 35'\n             );\n Function: Returns a new Bio::Seq::SeqWithQual object from basic\n           constructors.\n Returns : a new Bio::Seq::PrimaryQual object\n Args    : -qual can be a quality string (see Bio::Seq::PrimaryQual for more\n            information on this) or a reference to a Bio::Seq::PrimaryQual\n            object.\n           -seq can be a sequence string (see Bio::PrimarySeq for more\n            information on this) or a reference to a Bio::PrimaryQual object.\n           -seq, -id, -accession_number, -primary_id, -desc, -id behave like\n            this:\n             1. if they are provided on construction of the\n                 Bio::Seq::SeqWithQuality they will be set as the descriptors for\n                 the object unless changed by one of the following mechanisms:\n              a) $obj->set_common_descriptors() is used and both the -seq and\n                 the -qual object have the same descriptors. These common\n                 descriptors will then become the descriptors for the\n                 Bio::Seq::SeqWithQual object.\n              b) the descriptors are manually set using the seq(), id(),\n                 desc(), or accession_number(), primary_id(),\n             2. if no descriptors are provided, the new() constructor will see\n                if the descriptor used in the PrimarySeq and in the\n                PrimaryQual objects match. If they do, they will become\n                the descriptors for the SeqWithQuality object.\n             To eliminate ambiguity, I strongly suggest you set the\n             descriptors manually on construction of the object. Really.\n           -trace_indices : a space_delimited list of trace indices\n            (where would the peaks be drawn if this list of qualities\n            was to be plotted?)\n\n\nsub new {\n   my ($class, @args) = @_;\n   my $self = $class->SUPER::new(@args);\n   # default: turn OFF the warnings\n   $self->{supress_warnings} = 1;\n   my($qual,$seq,$id,$acc,$pid,$desc,$given_id,$alphabet,$trace_indices) =\n   $self->_rearrange([qw( QUAL SEQ DISPLAY_ID ACCESSION_NUMBER PRIMARY_ID DESC\n     ID ALPHABET TRACE_INDICES )], @args);\n   # Deal with the ID\n   if ( defined $id && defined $given_id ) {\n      if( $id ne $given_id ) {\n         $self->throw(\"Provided both id and display_id constructor functions. [$id] [$given_id]\");\n      }\n   }\n   if( defined $given_id ) {\n      $self->display_id($given_id);\n      $id = $given_id;\n   }\n   # Import sequence first\n   if (!$seq) {\n      my $id;\n      unless ($self->{supress_warnings} == 1) {\n         $self->warn(\"You did not provide sequence information during the \".\n           \"construction of a Bio::Seq::SeqWithQuality object. Sequence \".\n           \"components for this object will be empty.\");\n      }\n      if (!$alphabet) {\n         $self->throw(\"If you want me to create a PrimarySeq object for your \".\n           \"empty sequence <boggle> you must specify a -alphabet to satisfy \".\n           \"the constructor requirements for a Bio::PrimarySeq object with no \".\n           \"sequence. Read the POD for it, luke.\");\n      }\n      $self->{seq_ref} = Bio::PrimarySeq->new( -seq              =>  \"\",\n                                               -accession_number =>  $acc,\n                                               -primary_id       =>  $pid,\n                                               -desc             =>  $desc,\n                                               -display_id       =>  $id,\n                                               -alphabet         =>  $alphabet );\n   } elsif ($seq->isa('Bio::PrimarySeqI') || $seq->isa('Bio::SeqI')) {\n      $self->{seq_ref} = $seq;\n   } elsif (ref($seq)) {\n      $self->throw(\"You passed a seq argument into a SeqWithQUality object and\".\n        \" it was a reference ($seq) which did not inherit from Bio::SeqI or \".\n        \"Bio::PrimarySeqI. I don't know what to do with this!\");\n   } else {\n      my $seqobj = Bio::PrimarySeq->new( -seq              => $seq,\n                                         -accession_number => $acc,\n                                         -primary_id       => $pid,\n                                         -desc             => $desc,\n                                         -display_id       => $id   );\n      $self->{seq_ref} = $seqobj;\n   }\n   # Then import the quality scores\n   if (!defined($qual)) {\n      $self->{qual_ref} = Bio::Seq::PrimaryQual->new( -qual             => \"\",\n                                                      -accession_number => $acc,\n                                                      -primary_id       => $pid,\n                                                      -desc             => $desc,\n                                                      -display_id       => $id, );\n   } elsif (ref($qual) eq \"Bio::Seq::PrimaryQual\") {\n      $self->{qual_ref} = $qual;\n   } else {\n      my $qualobj = Bio::Seq::PrimaryQual->new( -qual             => $qual,\n                                                -accession_number => $acc,\n                                                -primary_id       => $pid,\n                                                -desc             => $desc,\n                                                -display_id       => $id,\n                                                -trace_indices    => $trace_indices );\n      $self->{qual_ref} = $qualobj;\n   }\n   # Now try to set the descriptors for this object\n   $self->_set_descriptors($qual,$seq,$id,$acc,$pid,$desc,$given_id,$alphabet);\n   $self->length();\n   $self->deprecated(\"deprecated class - use Bio::Seq::Quality instead\");\n\n   return $self;\n}\n\n=head2 _common_id()\n\n Title   : _common_id()\n Usage   : $common_id = $self->_common_id();\n Function: Compare the display_id of {qual_ref} and {seq_ref}.\n Returns : Nothing if they don't match. If they do return {seq_ref}->display_id()\n Args    : None.\n\n\n#'\nsub _common_id {\n   my $self = shift;\n   return if (!$self->{seq_ref} || !$self->{qual_ref});\n   my $sid = $self->{seq_ref}->display_id();\n   return if (!$sid);\n   return if (!$self->{qual_ref}->display_id());\n   return $sid if ($sid eq $self->{qual_ref}->display_id());\n   # should this become a warning?\n   # print(\"ids $sid and $self->{qual_ref}->display_id() do not match. Bummer.\\n\");\n}\n\n=head2 _common_display_id()\n\n Title   : _common_id()\n Usage   : $common_id = $self->_common_display_id();\n Function: Compare the display_id of {qual_ref} and {seq_ref}.\n Returns : Nothing if they don't match. If they do return {seq_ref}->display_id()\n Args    : None.\n\n\n#'\nsub _common_display_id {\n   my $self = shift;\n   $self->common_id();\n}\n\n=head2 _common_accession_number()\n\n Title   : _common_accession_number()\n Usage   : $common_id = $self->_common_accession_number();\n Function: Compare the accession_number() of {qual_ref} and {seq_ref}.\n Returns : Nothing if they don't match. If they do return {seq_ref}->accession_number()\n Args    : None.\n\n\n#'\nsub _common_accession_number {\n   my $self = shift;\n   return if ($self->{seq_ref} || $self->{qual_ref});\n   my $acc = $self->{seq_ref}->accession_number();\n   # if (!$acc) { print(\"the seqref has no acc.\\n\"); }\n   return if (!$acc);\n   # if ($acc eq $self->{qual_ref}->accession_number()) { print(\"$acc matches \".$self->{qual_ref}->accession_number().\"\\n\"); }\n   return $acc if ($acc eq $self->{qual_ref}->accession_number());\n   # should this become a warning?\n   # print(\"accession numbers $acc and $self->{qual_ref}->accession_number() do not match. Bummer.\\n\");\n}\n\n=head2 _common_primary_id()\n\n Title   : _common_primary_id()\n Usage   : $common_primard_id = $self->_common_primary_id();\n Function: Compare the primary_id of {qual_ref} and {seq_ref}.\n Returns : Nothing if they don't match. If they do return {seq_ref}->primary_id()\n Args    : None.\n\n\n#'\nsub _common_primary_id {\n   my $self = shift;\n   return if ($self->{seq_ref} || $self->{qual_ref});\n   my $pid = $self->{seq_ref}->primary_id();\n   return if (!$pid);\n   return $pid if ($pid eq $self->{qual_ref}->primary_id());\n   # should this become a warning?\n   # print(\"primary_ids $pid and $self->{qual_ref}->primary_id() do not match. Bummer.\\n\");\n}\n\n=head2 _common_desc()\n\n Title   : _common_desc()\n Usage   : $common_desc = $self->_common_desc();\n Function: Compare the desc of {qual_ref} and {seq_ref}.\n Returns : Nothing if they don't match. If they do return {seq_ref}->desc()\n Args    : None.\n\n\n#'\nsub _common_desc {\n   my $self = shift;\n   return if ($self->{seq_ref} || $self->{qual_ref});\n   my $des = $self->{seq_ref}->desc();\n   return if (!$des);\n   return $des if ($des eq $self->{qual_ref}->desc());\n   # should this become a warning?\n   # print(\"descriptions $des and $self->{qual_ref}->desc() do not match. Bummer.\\n\");\n}\n\n=head2 set_common_descriptors()\n\n Title   : set_common_descriptors()\n Usage   : $self->set_common_descriptors();\n Function: Compare the descriptors (id,accession_number,display_id,\n           primary_id, desc) for the PrimarySeq and PrimaryQual objects\n           within the SeqWithQuality object. If they match, make that\n           descriptor the descriptor for the SeqWithQuality object.\n Returns : Nothing.\n Args    : None.\n\n\nsub set_common_descriptors {\n   my $self = shift;\n   return if ($self->{seq_ref} || $self->{qual_ref});\n   &_common_id();\n   &_common_display_id();\n   &_common_accession_number();\n   &_common_primary_id();\n   &_common_desc();\n}\n\n=head2 alphabet()\n\n Title   : alphabet();\n Usage   : $molecule_type = $obj->alphabet();\n Function: Get the molecule type from the PrimarySeq object.\n Returns : What what PrimarySeq says the type of the sequence is.\n Args    : None.\n\n\nsub alphabet {\n   my $self = shift;\n   return $self->{seq_ref}->alphabet();\n}\n\n=head2 display_id()\n\n Title   : display_id()\n Usage   : $id_string = $obj->display_id();\n Function: Returns the display id, aka the common name of the Quality object.\n           The semantics of this is that it is the most likely string to be\n           used as an identifier of the quality sequence, and likely to have\n           \"human\" readability.  The id is equivalent to the ID field of the\n           GenBank/EMBL databanks and the id field of the Swissprot/sptrembl\n           database. In fasta format, the >(\\S+) is presumed to be the id,\n           though some people overload the id to embed other information.\n           Bioperl does not use any embedded information in the ID field,\n           and people are encouraged to use other mechanisms (accession\n           field for example, or extending the sequence object) to solve\n           this. Notice that $seq->id() maps to this function, mainly for\n           legacy/convience issues.\n           This method sets the display_id for the SeqWithQuality object.\n Returns : A string\n Args    : If a scalar is provided, it is set as the new display_id for\n           the SeqWithQuality object.\n Status  : Virtual\n\n\nsub display_id {\n   my ($obj,$value) = @_;\n   if( defined $value) {\n      $obj->{'display_id'} = $value;\n    }\n    return $obj->{'display_id'};\n\n}\n\n=head2 accession_number()\n\n Title   : accession_number()\n Usage   : $unique_biological_key = $obj->accession_number();\n Function: Returns the unique biological id for a sequence, commonly\n           called the accession_number. For sequences from established\n           databases, the implementors should try to use the correct\n           accession number. Notice that primary_id() provides the unique id\n           for the implemetation, allowing multiple objects to have the same\n           accession number in a particular implementation. For sequences\n           with no accession number, this method should return \"unknown\".\n           This method sets the accession_number for the SeqWithQuality\n           object. \n Returns : A string (the value of accession_number)\n Args    : If a scalar is provided, it is set as the new accession_number\n           for the SeqWithQuality object.\n Status  : Virtual\n\n\nsub accession_number {\n    my( $obj, $acc ) = @_;\n\n    if (defined $acc) {\n        $obj->{'accession_number'} = $acc;\n    } else {\n        $acc = $obj->{'accession_number'};\n        $acc = 'unknown' unless defined $acc;\n    }\n    return $acc;\n}\n\n=head2 primary_id()\n\n Title   : primary_id()\n Usage   : $unique_implementation_key = $obj->primary_id();\n Function: Returns the unique id for this object in this implementation.\n           This allows implementations to manage their own object ids in a\n           way the implementaiton can control clients can expect one id to\n           map to one object. For sequences with no accession number, this\n           method should return a stringified memory location.\n           This method sets the primary_id for the SeqWithQuality object.\n Returns : A string. (the value of primary_id)\n Args    : If a scalar is provided, it is set as the new primary_id for\n           the SeqWithQuality object.\n\n\nsub primary_id {\n   my ($obj,$value) = @_;\n   if ($value) {\n      $obj->{'primary_id'} = $value;\n    }\n   return $obj->{'primary_id'};\n\n}\n\n=head2 desc()\n\n Title   : desc()\n Usage   : $qual->desc($newval); _or_ \n           $description = $qual->desc();\n Function: Get/set description text for this SeqWithQuality object.\n Returns : A string. (the value of desc)\n Args    : If a scalar is provided, it is set as the new desc for the\n           SeqWithQuality object.\n\n\nsub desc {\n   # a mechanism to set the disc for the SeqWithQuality object.\n   # probably will be used most often by set_common_features()\n   my ($obj,$value) = @_;\n   if( defined $value) {\n      $obj->{'desc'} = $value;\n   }\n   return $obj->{'desc'};\n}\n\n=head2 id()\n\n Title   : id()\n Usage   : $id = $qual->id();\n Function: Return the ID of the quality. This should normally be (and\n           actually is in the implementation provided here) just a synonym\n           for display_id().\n Returns : A string. (the value of id)\n Args    : If a scalar is provided, it is set as the new id for the\n           SeqWithQuality object.\n\n\nsub id {\n   my ($self,$value) = @_;\n   if (!$self) { $self->throw(\"no value for self in $value\"); }\n   if( defined $value ) {\n      return $self->display_id($value);\n   }\n   return $self->display_id();\n}\n\n=head2 seq\n\n Title   : seq()\n Usage   : $string    = $obj->seq(); _or_ $obj->seq(\"atctatcatca\");\n Function: Returns the sequence that is contained in the imbedded in the\n           PrimarySeq object within the SeqWithQuality object\n Returns : A scalar (the seq() value for the imbedded PrimarySeq object.)\n Args    : If a scalar is provided, the SeqWithQuality object will\n           attempt to set that as the sequence for the imbedded PrimarySeq\n           object. Otherwise, the value of seq() for the PrimarySeq object\n           is returned.\n Notes   : This is probably not a good idea because you then should call\n           length() to make sure that the sequence and quality are of the\n           same length. Even then, how can you make sure that this sequence\n           belongs with that quality? I provided this to give you rope to\n           hang yourself with. Tie it to a strong device and use a good\n           knot.\n\n\nsub seq {\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{seq_ref}->seq($value);\n      $self->length();\n   }\n   return $self->{seq_ref}->seq();\n}\n\n=head2 qual()\n\n Title   : qual()\n Usage   : @quality_values  = @{$obj->qual()}; _or_\n           $obj->qual(\"10 10 20 40 50\");\n Function: Returns the quality as imbedded in the PrimaryQual object\n           within the SeqWithQuality object.\n Returns : A reference to an array containing the quality values in the \n           PrimaryQual object.\n Args    : If a scalar is provided, the SeqWithQuality object will\n           attempt to set that as the quality for the imbedded PrimaryQual\n           object. Otherwise, the value of qual() for the PrimaryQual\n           object is returned.\n Notes   : This is probably not a good idea because you then should call\n           length() to make sure that the sequence and quality are of the\n           same length. Even then, how can you make sure that this sequence\n           belongs with that quality? I provided this to give you a strong\n           board with which to flagellate yourself. \n\n\nsub qual {\n   my ($self,$value) = @_;\n\n   if( defined $value) {\n      $self->{qual_ref}->qual($value);\n      # update the lengths\n      $self->length();\n   }\n   return $self->{qual_ref}->qual();\n}\n\n\n\n=head2 trace_indices()\n\n Title   : trace_indices()\n Usage   : @trace_indice_values  = @{$obj->trace_indices()}; _or_\n           $obj->trace_indices(\"10 10 20 40 50\");\n Function: Returns the trace_indices as imbedded in the Primaryqual object\n           within the SeqWithQualiity object.\n Returns : A reference to an array containing the trace_indice values in the \n           PrimaryQual object.\n Args    : If a scalar is provided, the SeqWithuQuality object will\n           attempt to set that as the trace_indices for the imbedded PrimaryQual\n           object. Otherwise, the value of trace_indices() for the PrimaryQual\n           object is returned.\n Notes   : This is probably not a good idea because you then should call\n           length() to make sure that the sequence and trace_indices are of the\n           same length. Even then, how can you make sure that this sequence\n           belongs with that trace_indicex? I provided this to give you a strong\n           board with which to flagellate yourself. \n\n\nsub trace_indices {\n   my ($self,$value) = @_;\n\n   if( defined $value) {\n      $self->{qual_ref}->trace_indices($value);\n      # update the lengths\n      $self->length();\n   }\n   return $self->{qual_ref}->trace_indices();\n}\n\n\n\n\n=head2 length()\n\n Title   : length()\n Usage   : $length = $seqWqual->length();\n Function: Get the length of the SeqWithQuality sequence/quality.\n Returns : Returns the length of the sequence and quality if they are\n           both the same. Returns \"DIFFERENT\" if they differ.\n Args    : None.\n\n\nsub length {\n   my $self = shift;\n   if (!$self->{seq_ref}) {\n      unless ($self->{supress_warnings} == 1) {\n         $self->warn(\"Can't find {seq_ref} here in length().\");\n      }\n      return;\n   }\n   if (!$self->{qual_ref}) {\n      unless ($self->{supress_warnings} == 1) {\n         $self->warn(\"Can't find {qual_ref} here in length().\");\n      }\n      return;\n   }\n   my $seql = $self->{seq_ref}->length();\n\n   if ($seql != $self->{qual_ref}->length()) {\n      unless ($self->{supress_warnings} == 1) {\n         $self->warn(\"Sequence length (\".$seql.\") is different from quality \".\n           \"length (\".$self->{qual_ref}->length().\") in the SeqWithQuality \".\n           \"object. This can only lead to problems later.\");\n      }\n      $self->{'length'} = \"DIFFERENT\";\n   } else {\n      $self->{'length'} = $seql;\n   }\n   return $self->{'length'};\n}\n\n\n=head2 qual_obj\n\n Title   : qual_obj($different_obj)\n Usage   : $qualobj = $seqWqual->qual_obj(); _or_\n           $qualobj = $seqWqual->qual_obj($ref_to_primaryqual_obj);\n Function: Get the PrimaryQual object that is imbedded in the\n           SeqWithQuality object or if a reference to a PrimaryQual object\n           is provided, set this as the PrimaryQual object imbedded in the\n           SeqWithQuality object.\n Returns : A reference to a Bio::Seq::SeqWithQuality object.\n\n\nsub qual_obj {\n   my ($self,$value) = @_;\n   if (defined($value)) {\n      if (ref($value) eq \"Bio::Seq::PrimaryQual\") {\n         $self->{qual_ref} = $value;\n         $self->debug(\"You successfully changed the PrimaryQual object within \".\n           \"a SeqWithQuality object. ID's for the SeqWithQuality object may \".\n           \"now not be what you expect. Use something like \".\n           \"set_common_descriptors() to fix them if you care,\");\n      } else {\n         $self->debug(\"You tried to change the PrimaryQual object within a \".\n           \"SeqWithQuality object but you passed a reference to an object that\".\n           \" was not a Bio::Seq::PrimaryQual object. Thus your change failed. \".\n           \"Sorry.\\n\");\t    \n      }\n   }\n   return $self->{qual_ref};\n}\n\n\n=head2 seq_obj\n\n Title   : seq_obj()\n Usage   : $seqobj = $seqWqual->qual_obj(); _or_\n           $seqobj = $seqWqual->seq_obj($ref_to_primary_seq_obj);\n Function: Get the PrimarySeq object that is imbedded in the\n           SeqWithQuality object or if a reference to a PrimarySeq object is\n           provided, set this as the PrimarySeq object imbedded in the\n           SeqWithQuality object.\n Returns : A reference to a Bio::PrimarySeq object.","parameters":[{"label":"$self"},{"label":"$value"}],"label":"seq_obj($self,$value)"},"detail":"($self,$value)","kind":12,"children":[{"line":709,"kind":13,"localvar":"my","containerName":"seq_obj","name":"$self","definition":"my"},{"name":"$value","containerName":"seq_obj","kind":13,"line":709},{"containerName":"seq_obj","name":"$value","line":710,"kind":13},{"kind":13,"line":711,"name":"$value","containerName":"seq_obj"},{"line":712,"kind":13,"containerName":"seq_obj","name":"$self"},{"containerName":"seq_obj","name":"debug","kind":12,"line":712},{"line":717,"kind":13,"containerName":"seq_obj","name":"$self"},{"kind":12,"line":717,"containerName":"seq_obj","name":"debug"},{"name":"$self","containerName":"seq_obj","line":722,"kind":13}],"line":708,"name":"seq_obj","range":{"start":{"character":0,"line":708},"end":{"line":723,"character":9999}}},{"line":722,"kind":12,"name":"seq_ref"},{"definition":"sub","containerName":"main::","signature":{"documentation":"1;\n# $Id: SeqWithQuality.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Seq::QualI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chad Matsalla <bioinformatics@dieselwurks.com\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::SeqWithQuality - Bioperl object packaging a sequence with its quality.\nDeprecated class, use Bio::Seq::Quality instead!\n\n=head1 SYNOPSIS\n\n    use Bio::PrimarySeq;\n    use Bio::Seq::PrimaryQual;\n    use Bio::Seq::SeqWithQuality;\n\n    # make from memory\n    my $qual = Bio::Seq::SeqWithQuality->new\n    ( -qual => '10 20 30 40 50 50 20 10',\n      -seq => 'ATCGATCG',\n      -id  => 'human_id',\n      -accession_number => 'AL000012',\n    );\n\n    # make from objects\n    # first, make a PrimarySeq object\n    my $seqobj = Bio::PrimarySeq->new\n    ( -seq => 'atcgatcg',\n      -id  => 'GeneFragment-12',\n      -accession_number => 'X78121',\n      -alphabet => 'dna'\n    );\n\n    # now make a PrimaryQual object\n    my $qualobj = Bio::Seq::PrimaryQual->new\n    ( -qual => '10 20 30 40 50 50 20 10',\n      -id  => 'GeneFragment-12',\n      -accession_number => 'X78121',\n      -alphabet => 'dna'\n    );\n\n    # now make the SeqWithQuality object\n    my $swqobj = Bio::Seq::SeqWithQuality->new\n    ( -seq  => $seqobj,\n      -qual => $qualobj\n    );\n    # done!\n\n    $swqobj->id(); # the id of the SeqWithQuality object\n    # may not match the the id of the sequence or\n    # of the quality (check the pod, luke)\n    $swqobj->seq(); # the sequence of the SeqWithQuality object\n    $swqobj->qual(); # the quality of the SeqWithQuality object\n\n    # to get out parts of the sequence.\n\n    print \"Sequence \", $seqobj->id(), \" with accession \",\n    $seqobj->accession, \" and desc \", $seqobj->desc, \"\\n\";\n\n    $string2 = $seqobj->subseq(1,40);\n\n=head1 DESCRIPTION\n\nThis object stores base quality values together with the sequence string.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nEmail bioinformatics@dieselwurks.com\n\n=head1 CONTRIBUTORS \n\nJason Stajich, jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\npackage Bio::Seq::SeqWithQuality;\n\n\nuse strict;\nuse Bio::PrimarySeq;\nuse Bio::Seq::PrimaryQual;\n\nuse base qw(Bio::Root::Root Bio::PrimarySeqI Bio::Seq::QualI);\n\n=head2 new()\n\n Title   : new()\n Usage   : $qual = Bio::Seq::SeqWithQuality ->new\n             ( -qual => '10 20 30 40 50 50 20 10',\n               -seq => 'ATCGATCG',\n               -id  => 'human_id',\n               -accession_number => 'AL000012',\n               -trace_indices    => '0 5 10 15 20 25 30 35'\n             );\n Function: Returns a new Bio::Seq::SeqWithQual object from basic\n           constructors.\n Returns : a new Bio::Seq::PrimaryQual object\n Args    : -qual can be a quality string (see Bio::Seq::PrimaryQual for more\n            information on this) or a reference to a Bio::Seq::PrimaryQual\n            object.\n           -seq can be a sequence string (see Bio::PrimarySeq for more\n            information on this) or a reference to a Bio::PrimaryQual object.\n           -seq, -id, -accession_number, -primary_id, -desc, -id behave like\n            this:\n             1. if they are provided on construction of the\n                 Bio::Seq::SeqWithQuality they will be set as the descriptors for\n                 the object unless changed by one of the following mechanisms:\n              a) $obj->set_common_descriptors() is used and both the -seq and\n                 the -qual object have the same descriptors. These common\n                 descriptors will then become the descriptors for the\n                 Bio::Seq::SeqWithQual object.\n              b) the descriptors are manually set using the seq(), id(),\n                 desc(), or accession_number(), primary_id(),\n             2. if no descriptors are provided, the new() constructor will see\n                if the descriptor used in the PrimarySeq and in the\n                PrimaryQual objects match. If they do, they will become\n                the descriptors for the SeqWithQuality object.\n             To eliminate ambiguity, I strongly suggest you set the\n             descriptors manually on construction of the object. Really.\n           -trace_indices : a space_delimited list of trace indices\n            (where would the peaks be drawn if this list of qualities\n            was to be plotted?)\n\n\nsub new {\n   my ($class, @args) = @_;\n   my $self = $class->SUPER::new(@args);\n   # default: turn OFF the warnings\n   $self->{supress_warnings} = 1;\n   my($qual,$seq,$id,$acc,$pid,$desc,$given_id,$alphabet,$trace_indices) =\n   $self->_rearrange([qw( QUAL SEQ DISPLAY_ID ACCESSION_NUMBER PRIMARY_ID DESC\n     ID ALPHABET TRACE_INDICES )], @args);\n   # Deal with the ID\n   if ( defined $id && defined $given_id ) {\n      if( $id ne $given_id ) {\n         $self->throw(\"Provided both id and display_id constructor functions. [$id] [$given_id]\");\n      }\n   }\n   if( defined $given_id ) {\n      $self->display_id($given_id);\n      $id = $given_id;\n   }\n   # Import sequence first\n   if (!$seq) {\n      my $id;\n      unless ($self->{supress_warnings} == 1) {\n         $self->warn(\"You did not provide sequence information during the \".\n           \"construction of a Bio::Seq::SeqWithQuality object. Sequence \".\n           \"components for this object will be empty.\");\n      }\n      if (!$alphabet) {\n         $self->throw(\"If you want me to create a PrimarySeq object for your \".\n           \"empty sequence <boggle> you must specify a -alphabet to satisfy \".\n           \"the constructor requirements for a Bio::PrimarySeq object with no \".\n           \"sequence. Read the POD for it, luke.\");\n      }\n      $self->{seq_ref} = Bio::PrimarySeq->new( -seq              =>  \"\",\n                                               -accession_number =>  $acc,\n                                               -primary_id       =>  $pid,\n                                               -desc             =>  $desc,\n                                               -display_id       =>  $id,\n                                               -alphabet         =>  $alphabet );\n   } elsif ($seq->isa('Bio::PrimarySeqI') || $seq->isa('Bio::SeqI')) {\n      $self->{seq_ref} = $seq;\n   } elsif (ref($seq)) {\n      $self->throw(\"You passed a seq argument into a SeqWithQUality object and\".\n        \" it was a reference ($seq) which did not inherit from Bio::SeqI or \".\n        \"Bio::PrimarySeqI. I don't know what to do with this!\");\n   } else {\n      my $seqobj = Bio::PrimarySeq->new( -seq              => $seq,\n                                         -accession_number => $acc,\n                                         -primary_id       => $pid,\n                                         -desc             => $desc,\n                                         -display_id       => $id   );\n      $self->{seq_ref} = $seqobj;\n   }\n   # Then import the quality scores\n   if (!defined($qual)) {\n      $self->{qual_ref} = Bio::Seq::PrimaryQual->new( -qual             => \"\",\n                                                      -accession_number => $acc,\n                                                      -primary_id       => $pid,\n                                                      -desc             => $desc,\n                                                      -display_id       => $id, );\n   } elsif (ref($qual) eq \"Bio::Seq::PrimaryQual\") {\n      $self->{qual_ref} = $qual;\n   } else {\n      my $qualobj = Bio::Seq::PrimaryQual->new( -qual             => $qual,\n                                                -accession_number => $acc,\n                                                -primary_id       => $pid,\n                                                -desc             => $desc,\n                                                -display_id       => $id,\n                                                -trace_indices    => $trace_indices );\n      $self->{qual_ref} = $qualobj;\n   }\n   # Now try to set the descriptors for this object\n   $self->_set_descriptors($qual,$seq,$id,$acc,$pid,$desc,$given_id,$alphabet);\n   $self->length();\n   $self->deprecated(\"deprecated class - use Bio::Seq::Quality instead\");\n\n   return $self;\n}\n\n=head2 _common_id()\n\n Title   : _common_id()\n Usage   : $common_id = $self->_common_id();\n Function: Compare the display_id of {qual_ref} and {seq_ref}.\n Returns : Nothing if they don't match. If they do return {seq_ref}->display_id()\n Args    : None.\n\n\n#'\nsub _common_id {\n   my $self = shift;\n   return if (!$self->{seq_ref} || !$self->{qual_ref});\n   my $sid = $self->{seq_ref}->display_id();\n   return if (!$sid);\n   return if (!$self->{qual_ref}->display_id());\n   return $sid if ($sid eq $self->{qual_ref}->display_id());\n   # should this become a warning?\n   # print(\"ids $sid and $self->{qual_ref}->display_id() do not match. Bummer.\\n\");\n}\n\n=head2 _common_display_id()\n\n Title   : _common_id()\n Usage   : $common_id = $self->_common_display_id();\n Function: Compare the display_id of {qual_ref} and {seq_ref}.\n Returns : Nothing if they don't match. If they do return {seq_ref}->display_id()\n Args    : None.\n\n\n#'\nsub _common_display_id {\n   my $self = shift;\n   $self->common_id();\n}\n\n=head2 _common_accession_number()\n\n Title   : _common_accession_number()\n Usage   : $common_id = $self->_common_accession_number();\n Function: Compare the accession_number() of {qual_ref} and {seq_ref}.\n Returns : Nothing if they don't match. If they do return {seq_ref}->accession_number()\n Args    : None.\n\n\n#'\nsub _common_accession_number {\n   my $self = shift;\n   return if ($self->{seq_ref} || $self->{qual_ref});\n   my $acc = $self->{seq_ref}->accession_number();\n   # if (!$acc) { print(\"the seqref has no acc.\\n\"); }\n   return if (!$acc);\n   # if ($acc eq $self->{qual_ref}->accession_number()) { print(\"$acc matches \".$self->{qual_ref}->accession_number().\"\\n\"); }\n   return $acc if ($acc eq $self->{qual_ref}->accession_number());\n   # should this become a warning?\n   # print(\"accession numbers $acc and $self->{qual_ref}->accession_number() do not match. Bummer.\\n\");\n}\n\n=head2 _common_primary_id()\n\n Title   : _common_primary_id()\n Usage   : $common_primard_id = $self->_common_primary_id();\n Function: Compare the primary_id of {qual_ref} and {seq_ref}.\n Returns : Nothing if they don't match. If they do return {seq_ref}->primary_id()\n Args    : None.\n\n\n#'\nsub _common_primary_id {\n   my $self = shift;\n   return if ($self->{seq_ref} || $self->{qual_ref});\n   my $pid = $self->{seq_ref}->primary_id();\n   return if (!$pid);\n   return $pid if ($pid eq $self->{qual_ref}->primary_id());\n   # should this become a warning?\n   # print(\"primary_ids $pid and $self->{qual_ref}->primary_id() do not match. Bummer.\\n\");\n}\n\n=head2 _common_desc()\n\n Title   : _common_desc()\n Usage   : $common_desc = $self->_common_desc();\n Function: Compare the desc of {qual_ref} and {seq_ref}.\n Returns : Nothing if they don't match. If they do return {seq_ref}->desc()\n Args    : None.\n\n\n#'\nsub _common_desc {\n   my $self = shift;\n   return if ($self->{seq_ref} || $self->{qual_ref});\n   my $des = $self->{seq_ref}->desc();\n   return if (!$des);\n   return $des if ($des eq $self->{qual_ref}->desc());\n   # should this become a warning?\n   # print(\"descriptions $des and $self->{qual_ref}->desc() do not match. Bummer.\\n\");\n}\n\n=head2 set_common_descriptors()\n\n Title   : set_common_descriptors()\n Usage   : $self->set_common_descriptors();\n Function: Compare the descriptors (id,accession_number,display_id,\n           primary_id, desc) for the PrimarySeq and PrimaryQual objects\n           within the SeqWithQuality object. If they match, make that\n           descriptor the descriptor for the SeqWithQuality object.\n Returns : Nothing.\n Args    : None.\n\n\nsub set_common_descriptors {\n   my $self = shift;\n   return if ($self->{seq_ref} || $self->{qual_ref});\n   &_common_id();\n   &_common_display_id();\n   &_common_accession_number();\n   &_common_primary_id();\n   &_common_desc();\n}\n\n=head2 alphabet()\n\n Title   : alphabet();\n Usage   : $molecule_type = $obj->alphabet();\n Function: Get the molecule type from the PrimarySeq object.\n Returns : What what PrimarySeq says the type of the sequence is.\n Args    : None.\n\n\nsub alphabet {\n   my $self = shift;\n   return $self->{seq_ref}->alphabet();\n}\n\n=head2 display_id()\n\n Title   : display_id()\n Usage   : $id_string = $obj->display_id();\n Function: Returns the display id, aka the common name of the Quality object.\n           The semantics of this is that it is the most likely string to be\n           used as an identifier of the quality sequence, and likely to have\n           \"human\" readability.  The id is equivalent to the ID field of the\n           GenBank/EMBL databanks and the id field of the Swissprot/sptrembl\n           database. In fasta format, the >(\\S+) is presumed to be the id,\n           though some people overload the id to embed other information.\n           Bioperl does not use any embedded information in the ID field,\n           and people are encouraged to use other mechanisms (accession\n           field for example, or extending the sequence object) to solve\n           this. Notice that $seq->id() maps to this function, mainly for\n           legacy/convience issues.\n           This method sets the display_id for the SeqWithQuality object.\n Returns : A string\n Args    : If a scalar is provided, it is set as the new display_id for\n           the SeqWithQuality object.\n Status  : Virtual\n\n\nsub display_id {\n   my ($obj,$value) = @_;\n   if( defined $value) {\n      $obj->{'display_id'} = $value;\n    }\n    return $obj->{'display_id'};\n\n}\n\n=head2 accession_number()\n\n Title   : accession_number()\n Usage   : $unique_biological_key = $obj->accession_number();\n Function: Returns the unique biological id for a sequence, commonly\n           called the accession_number. For sequences from established\n           databases, the implementors should try to use the correct\n           accession number. Notice that primary_id() provides the unique id\n           for the implemetation, allowing multiple objects to have the same\n           accession number in a particular implementation. For sequences\n           with no accession number, this method should return \"unknown\".\n           This method sets the accession_number for the SeqWithQuality\n           object. \n Returns : A string (the value of accession_number)\n Args    : If a scalar is provided, it is set as the new accession_number\n           for the SeqWithQuality object.\n Status  : Virtual\n\n\nsub accession_number {\n    my( $obj, $acc ) = @_;\n\n    if (defined $acc) {\n        $obj->{'accession_number'} = $acc;\n    } else {\n        $acc = $obj->{'accession_number'};\n        $acc = 'unknown' unless defined $acc;\n    }\n    return $acc;\n}\n\n=head2 primary_id()\n\n Title   : primary_id()\n Usage   : $unique_implementation_key = $obj->primary_id();\n Function: Returns the unique id for this object in this implementation.\n           This allows implementations to manage their own object ids in a\n           way the implementaiton can control clients can expect one id to\n           map to one object. For sequences with no accession number, this\n           method should return a stringified memory location.\n           This method sets the primary_id for the SeqWithQuality object.\n Returns : A string. (the value of primary_id)\n Args    : If a scalar is provided, it is set as the new primary_id for\n           the SeqWithQuality object.\n\n\nsub primary_id {\n   my ($obj,$value) = @_;\n   if ($value) {\n      $obj->{'primary_id'} = $value;\n    }\n   return $obj->{'primary_id'};\n\n}\n\n=head2 desc()\n\n Title   : desc()\n Usage   : $qual->desc($newval); _or_ \n           $description = $qual->desc();\n Function: Get/set description text for this SeqWithQuality object.\n Returns : A string. (the value of desc)\n Args    : If a scalar is provided, it is set as the new desc for the\n           SeqWithQuality object.\n\n\nsub desc {\n   # a mechanism to set the disc for the SeqWithQuality object.\n   # probably will be used most often by set_common_features()\n   my ($obj,$value) = @_;\n   if( defined $value) {\n      $obj->{'desc'} = $value;\n   }\n   return $obj->{'desc'};\n}\n\n=head2 id()\n\n Title   : id()\n Usage   : $id = $qual->id();\n Function: Return the ID of the quality. This should normally be (and\n           actually is in the implementation provided here) just a synonym\n           for display_id().\n Returns : A string. (the value of id)\n Args    : If a scalar is provided, it is set as the new id for the\n           SeqWithQuality object.\n\n\nsub id {\n   my ($self,$value) = @_;\n   if (!$self) { $self->throw(\"no value for self in $value\"); }\n   if( defined $value ) {\n      return $self->display_id($value);\n   }\n   return $self->display_id();\n}\n\n=head2 seq\n\n Title   : seq()\n Usage   : $string    = $obj->seq(); _or_ $obj->seq(\"atctatcatca\");\n Function: Returns the sequence that is contained in the imbedded in the\n           PrimarySeq object within the SeqWithQuality object\n Returns : A scalar (the seq() value for the imbedded PrimarySeq object.)\n Args    : If a scalar is provided, the SeqWithQuality object will\n           attempt to set that as the sequence for the imbedded PrimarySeq\n           object. Otherwise, the value of seq() for the PrimarySeq object\n           is returned.\n Notes   : This is probably not a good idea because you then should call\n           length() to make sure that the sequence and quality are of the\n           same length. Even then, how can you make sure that this sequence\n           belongs with that quality? I provided this to give you rope to\n           hang yourself with. Tie it to a strong device and use a good\n           knot.\n\n\nsub seq {\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{seq_ref}->seq($value);\n      $self->length();\n   }\n   return $self->{seq_ref}->seq();\n}\n\n=head2 qual()\n\n Title   : qual()\n Usage   : @quality_values  = @{$obj->qual()}; _or_\n           $obj->qual(\"10 10 20 40 50\");\n Function: Returns the quality as imbedded in the PrimaryQual object\n           within the SeqWithQuality object.\n Returns : A reference to an array containing the quality values in the \n           PrimaryQual object.\n Args    : If a scalar is provided, the SeqWithQuality object will\n           attempt to set that as the quality for the imbedded PrimaryQual\n           object. Otherwise, the value of qual() for the PrimaryQual\n           object is returned.\n Notes   : This is probably not a good idea because you then should call\n           length() to make sure that the sequence and quality are of the\n           same length. Even then, how can you make sure that this sequence\n           belongs with that quality? I provided this to give you a strong\n           board with which to flagellate yourself. \n\n\nsub qual {\n   my ($self,$value) = @_;\n\n   if( defined $value) {\n      $self->{qual_ref}->qual($value);\n      # update the lengths\n      $self->length();\n   }\n   return $self->{qual_ref}->qual();\n}\n\n\n\n=head2 trace_indices()\n\n Title   : trace_indices()\n Usage   : @trace_indice_values  = @{$obj->trace_indices()}; _or_\n           $obj->trace_indices(\"10 10 20 40 50\");\n Function: Returns the trace_indices as imbedded in the Primaryqual object\n           within the SeqWithQualiity object.\n Returns : A reference to an array containing the trace_indice values in the \n           PrimaryQual object.\n Args    : If a scalar is provided, the SeqWithuQuality object will\n           attempt to set that as the trace_indices for the imbedded PrimaryQual\n           object. Otherwise, the value of trace_indices() for the PrimaryQual\n           object is returned.\n Notes   : This is probably not a good idea because you then should call\n           length() to make sure that the sequence and trace_indices are of the\n           same length. Even then, how can you make sure that this sequence\n           belongs with that trace_indicex? I provided this to give you a strong\n           board with which to flagellate yourself. \n\n\nsub trace_indices {\n   my ($self,$value) = @_;\n\n   if( defined $value) {\n      $self->{qual_ref}->trace_indices($value);\n      # update the lengths\n      $self->length();\n   }\n   return $self->{qual_ref}->trace_indices();\n}\n\n\n\n\n=head2 length()\n\n Title   : length()\n Usage   : $length = $seqWqual->length();\n Function: Get the length of the SeqWithQuality sequence/quality.\n Returns : Returns the length of the sequence and quality if they are\n           both the same. Returns \"DIFFERENT\" if they differ.\n Args    : None.\n\n\nsub length {\n   my $self = shift;\n   if (!$self->{seq_ref}) {\n      unless ($self->{supress_warnings} == 1) {\n         $self->warn(\"Can't find {seq_ref} here in length().\");\n      }\n      return;\n   }\n   if (!$self->{qual_ref}) {\n      unless ($self->{supress_warnings} == 1) {\n         $self->warn(\"Can't find {qual_ref} here in length().\");\n      }\n      return;\n   }\n   my $seql = $self->{seq_ref}->length();\n\n   if ($seql != $self->{qual_ref}->length()) {\n      unless ($self->{supress_warnings} == 1) {\n         $self->warn(\"Sequence length (\".$seql.\") is different from quality \".\n           \"length (\".$self->{qual_ref}->length().\") in the SeqWithQuality \".\n           \"object. This can only lead to problems later.\");\n      }\n      $self->{'length'} = \"DIFFERENT\";\n   } else {\n      $self->{'length'} = $seql;\n   }\n   return $self->{'length'};\n}\n\n\n=head2 qual_obj\n\n Title   : qual_obj($different_obj)\n Usage   : $qualobj = $seqWqual->qual_obj(); _or_\n           $qualobj = $seqWqual->qual_obj($ref_to_primaryqual_obj);\n Function: Get the PrimaryQual object that is imbedded in the\n           SeqWithQuality object or if a reference to a PrimaryQual object\n           is provided, set this as the PrimaryQual object imbedded in the\n           SeqWithQuality object.\n Returns : A reference to a Bio::Seq::SeqWithQuality object.\n\n\nsub qual_obj {\n   my ($self,$value) = @_;\n   if (defined($value)) {\n      if (ref($value) eq \"Bio::Seq::PrimaryQual\") {\n         $self->{qual_ref} = $value;\n         $self->debug(\"You successfully changed the PrimaryQual object within \".\n           \"a SeqWithQuality object. ID's for the SeqWithQuality object may \".\n           \"now not be what you expect. Use something like \".\n           \"set_common_descriptors() to fix them if you care,\");\n      } else {\n         $self->debug(\"You tried to change the PrimaryQual object within a \".\n           \"SeqWithQuality object but you passed a reference to an object that\".\n           \" was not a Bio::Seq::PrimaryQual object. Thus your change failed. \".\n           \"Sorry.\\n\");\t    \n      }\n   }\n   return $self->{qual_ref};\n}\n\n\n=head2 seq_obj\n\n Title   : seq_obj()\n Usage   : $seqobj = $seqWqual->qual_obj(); _or_\n           $seqobj = $seqWqual->seq_obj($ref_to_primary_seq_obj);\n Function: Get the PrimarySeq object that is imbedded in the\n           SeqWithQuality object or if a reference to a PrimarySeq object is\n           provided, set this as the PrimarySeq object imbedded in the\n           SeqWithQuality object.\n Returns : A reference to a Bio::PrimarySeq object.\n\n\nsub seq_obj {\n   my ($self,$value) = @_;\n   if( defined $value) {\n      if (ref($value) eq \"Bio::PrimarySeq\") {\n         $self->debug(\"You successfully changed the PrimarySeq object within a\".\n           \" SeqWithQuality object. ID's for the SeqWithQuality object may now\".\n           \" not be what you expect. Use something like \".\n           \"set_common_descriptors() to fix them if you care,\");\n      } else {\n         $self->debug(\"You tried to change the PrimarySeq object within a \".\n           \"SeqWithQuality object but you passed a reference to an object that\".\n           \" was not a Bio::PrimarySeq object. Thus your change failed. Sorry.\\n\");\n      }\n   }\n   return $self->{seq_ref};\n}\n\n=head2 _set_descriptors\n\n Title   : _set_descriptors()\n Usage   : $seqWqual->_qual_obj($qual,$seq,$id,$acc,$pid,$desc,$given_id,\n           $alphabet);\n Function: Set the descriptors for the SeqWithQuality object. Try to\n           match the descriptors in the PrimarySeq object and in the\n           PrimaryQual object if descriptors were not provided with\n           construction.\n Returns : Nothing.\n Args    : $qual,$seq,$id,$acc,$pid,$desc,$given_id,$alphabet as found\n           in the new() method.\n Notes   : Really only intended to be called by the new() method. If\n           you want to invoke a similar function try set_common_descriptors().","parameters":[{"label":"$self"},{"label":"$qual"},{"label":"$seq"},{"label":"$id"},{"label":"$acc"},{"label":"$pid"},{"label":"$desc"},{"label":"$given_id"},{"label":"$alphabet"}],"label":"_set_descriptors($self,$qual,$seq,$id,$acc,$pid,$desc,$given_id,$alphabet)"},"detail":"($self,$qual,$seq,$id,$acc,$pid,$desc,$given_id,$alphabet)","kind":12,"children":[{"line":744,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"_set_descriptors"},{"line":744,"kind":13,"name":"$qual","containerName":"_set_descriptors"},{"kind":13,"line":744,"name":"$seq","containerName":"_set_descriptors"},{"name":"$id","containerName":"_set_descriptors","kind":13,"line":744},{"name":"$acc","containerName":"_set_descriptors","kind":13,"line":744},{"line":744,"kind":13,"name":"$pid","containerName":"_set_descriptors"},{"name":"$desc","containerName":"_set_descriptors","line":744,"kind":13},{"name":"$given_id","containerName":"_set_descriptors","line":744,"kind":13},{"line":744,"kind":13,"name":"$alphabet","containerName":"_set_descriptors"},{"localvar":"my","definition":"my","name":"$c_id","containerName":"_set_descriptors","line":745,"kind":13},{"name":"$c_acc","containerName":"_set_descriptors","kind":13,"line":745},{"line":745,"kind":13,"name":"$c_pid","containerName":"_set_descriptors"},{"line":745,"kind":13,"name":"$c_desc","containerName":"_set_descriptors"},{"name":"$self","containerName":"_set_descriptors","line":746,"kind":13},{"line":746,"kind":12,"name":"display_id","containerName":"_set_descriptors"},{"name":"$c_id","containerName":"_set_descriptors","line":747,"kind":13},{"containerName":"_set_descriptors","name":"$self","kind":13,"line":747},{"line":747,"kind":12,"containerName":"_set_descriptors","name":"_common_id"},{"line":747,"kind":13,"name":"$self","containerName":"_set_descriptors"},{"kind":12,"line":747,"containerName":"_set_descriptors","name":"display_id"},{"kind":13,"line":747,"name":"$c_id","containerName":"_set_descriptors"},{"containerName":"_set_descriptors","name":"$self","kind":13,"line":749},{"line":752,"kind":13,"containerName":"_set_descriptors","name":"$self"},{"containerName":"_set_descriptors","name":"display_id","kind":12,"line":752},{"kind":13,"line":752,"name":"$self","containerName":"_set_descriptors"},{"kind":12,"line":752,"containerName":"_set_descriptors","name":"id"},{"containerName":"_set_descriptors","name":"$self","line":753,"kind":13},{"containerName":"_set_descriptors","name":"$self","kind":13,"line":754},{"name":"display_id","containerName":"_set_descriptors","kind":12,"line":754},{"name":"$self","containerName":"_set_descriptors","kind":13,"line":754},{"line":754,"kind":12,"containerName":"_set_descriptors","name":"id"},{"name":"$acc","containerName":"_set_descriptors","line":758,"kind":13},{"line":758,"kind":13,"containerName":"_set_descriptors","name":"$self"},{"name":"accession_number","containerName":"_set_descriptors","line":758,"kind":12},{"containerName":"_set_descriptors","name":"$acc","line":758,"kind":13},{"containerName":"_set_descriptors","name":"$c_acc","kind":13,"line":759},{"containerName":"_set_descriptors","name":"$self","kind":13,"line":759},{"line":759,"kind":12,"containerName":"_set_descriptors","name":"_common_accession_number"},{"kind":13,"line":759,"containerName":"_set_descriptors","name":"$self"},{"containerName":"_set_descriptors","name":"accession_number","line":759,"kind":12},{"name":"$c_acc","containerName":"_set_descriptors","line":759,"kind":13},{"name":"$pid","containerName":"_set_descriptors","line":760,"kind":13},{"line":760,"kind":13,"containerName":"_set_descriptors","name":"$self"},{"name":"primary_id","containerName":"_set_descriptors","line":760,"kind":12},{"containerName":"_set_descriptors","name":"$pid","kind":13,"line":760},{"kind":13,"line":761,"name":"$c_pid","containerName":"_set_descriptors"},{"containerName":"_set_descriptors","name":"$self","kind":13,"line":761},{"kind":12,"line":761,"containerName":"_set_descriptors","name":"_common_primary_id"},{"kind":13,"line":761,"containerName":"_set_descriptors","name":"$self"},{"line":761,"kind":12,"containerName":"_set_descriptors","name":"primary_id"},{"containerName":"_set_descriptors","name":"$c_pid","kind":13,"line":761},{"kind":13,"line":762,"containerName":"_set_descriptors","name":"$desc"},{"line":762,"kind":13,"containerName":"_set_descriptors","name":"$self"},{"containerName":"_set_descriptors","name":"desc","kind":12,"line":762},{"line":762,"kind":13,"name":"$desc","containerName":"_set_descriptors"},{"containerName":"_set_descriptors","name":"$c_desc","line":763,"kind":13},{"containerName":"_set_descriptors","name":"$self","line":763,"kind":13},{"name":"_common_desc","containerName":"_set_descriptors","kind":12,"line":763},{"kind":13,"line":763,"containerName":"_set_descriptors","name":"$self"},{"kind":12,"line":763,"containerName":"_set_descriptors","name":"desc"},{"line":763,"kind":13,"containerName":"_set_descriptors","name":"$c_desc"}],"line":743,"name":"_set_descriptors","range":{"end":{"character":9999,"line":764},"start":{"character":0,"line":743}}},{"line":749,"kind":12,"name":"seq_ref"},{"name":"seq_ref","kind":12,"line":752},{"name":"qual_ref","line":753,"kind":12},{"name":"qual_ref","kind":12,"line":754},{"name":"subseq","range":{"end":{"character":9999,"line":782},"start":{"character":0,"line":778}},"containerName":"main::","definition":"sub","detail":"($self,@args)","signature":{"documentation":"1;\n# $Id: SeqWithQuality.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Seq::QualI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chad Matsalla <bioinformatics@dieselwurks.com\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::SeqWithQuality - Bioperl object packaging a sequence with its quality.\nDeprecated class, use Bio::Seq::Quality instead!\n\n=head1 SYNOPSIS\n\n    use Bio::PrimarySeq;\n    use Bio::Seq::PrimaryQual;\n    use Bio::Seq::SeqWithQuality;\n\n    # make from memory\n    my $qual = Bio::Seq::SeqWithQuality->new\n    ( -qual => '10 20 30 40 50 50 20 10',\n      -seq => 'ATCGATCG',\n      -id  => 'human_id',\n      -accession_number => 'AL000012',\n    );\n\n    # make from objects\n    # first, make a PrimarySeq object\n    my $seqobj = Bio::PrimarySeq->new\n    ( -seq => 'atcgatcg',\n      -id  => 'GeneFragment-12',\n      -accession_number => 'X78121',\n      -alphabet => 'dna'\n    );\n\n    # now make a PrimaryQual object\n    my $qualobj = Bio::Seq::PrimaryQual->new\n    ( -qual => '10 20 30 40 50 50 20 10',\n      -id  => 'GeneFragment-12',\n      -accession_number => 'X78121',\n      -alphabet => 'dna'\n    );\n\n    # now make the SeqWithQuality object\n    my $swqobj = Bio::Seq::SeqWithQuality->new\n    ( -seq  => $seqobj,\n      -qual => $qualobj\n    );\n    # done!\n\n    $swqobj->id(); # the id of the SeqWithQuality object\n    # may not match the the id of the sequence or\n    # of the quality (check the pod, luke)\n    $swqobj->seq(); # the sequence of the SeqWithQuality object\n    $swqobj->qual(); # the quality of the SeqWithQuality object\n\n    # to get out parts of the sequence.\n\n    print \"Sequence \", $seqobj->id(), \" with accession \",\n    $seqobj->accession, \" and desc \", $seqobj->desc, \"\\n\";\n\n    $string2 = $seqobj->subseq(1,40);\n\n=head1 DESCRIPTION\n\nThis object stores base quality values together with the sequence string.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nEmail bioinformatics@dieselwurks.com\n\n=head1 CONTRIBUTORS \n\nJason Stajich, jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\npackage Bio::Seq::SeqWithQuality;\n\n\nuse strict;\nuse Bio::PrimarySeq;\nuse Bio::Seq::PrimaryQual;\n\nuse base qw(Bio::Root::Root Bio::PrimarySeqI Bio::Seq::QualI);\n\n=head2 new()\n\n Title   : new()\n Usage   : $qual = Bio::Seq::SeqWithQuality ->new\n             ( -qual => '10 20 30 40 50 50 20 10',\n               -seq => 'ATCGATCG',\n               -id  => 'human_id',\n               -accession_number => 'AL000012',\n               -trace_indices    => '0 5 10 15 20 25 30 35'\n             );\n Function: Returns a new Bio::Seq::SeqWithQual object from basic\n           constructors.\n Returns : a new Bio::Seq::PrimaryQual object\n Args    : -qual can be a quality string (see Bio::Seq::PrimaryQual for more\n            information on this) or a reference to a Bio::Seq::PrimaryQual\n            object.\n           -seq can be a sequence string (see Bio::PrimarySeq for more\n            information on this) or a reference to a Bio::PrimaryQual object.\n           -seq, -id, -accession_number, -primary_id, -desc, -id behave like\n            this:\n             1. if they are provided on construction of the\n                 Bio::Seq::SeqWithQuality they will be set as the descriptors for\n                 the object unless changed by one of the following mechanisms:\n              a) $obj->set_common_descriptors() is used and both the -seq and\n                 the -qual object have the same descriptors. These common\n                 descriptors will then become the descriptors for the\n                 Bio::Seq::SeqWithQual object.\n              b) the descriptors are manually set using the seq(), id(),\n                 desc(), or accession_number(), primary_id(),\n             2. if no descriptors are provided, the new() constructor will see\n                if the descriptor used in the PrimarySeq and in the\n                PrimaryQual objects match. If they do, they will become\n                the descriptors for the SeqWithQuality object.\n             To eliminate ambiguity, I strongly suggest you set the\n             descriptors manually on construction of the object. Really.\n           -trace_indices : a space_delimited list of trace indices\n            (where would the peaks be drawn if this list of qualities\n            was to be plotted?)\n\n\nsub new {\n   my ($class, @args) = @_;\n   my $self = $class->SUPER::new(@args);\n   # default: turn OFF the warnings\n   $self->{supress_warnings} = 1;\n   my($qual,$seq,$id,$acc,$pid,$desc,$given_id,$alphabet,$trace_indices) =\n   $self->_rearrange([qw( QUAL SEQ DISPLAY_ID ACCESSION_NUMBER PRIMARY_ID DESC\n     ID ALPHABET TRACE_INDICES )], @args);\n   # Deal with the ID\n   if ( defined $id && defined $given_id ) {\n      if( $id ne $given_id ) {\n         $self->throw(\"Provided both id and display_id constructor functions. [$id] [$given_id]\");\n      }\n   }\n   if( defined $given_id ) {\n      $self->display_id($given_id);\n      $id = $given_id;\n   }\n   # Import sequence first\n   if (!$seq) {\n      my $id;\n      unless ($self->{supress_warnings} == 1) {\n         $self->warn(\"You did not provide sequence information during the \".\n           \"construction of a Bio::Seq::SeqWithQuality object. Sequence \".\n           \"components for this object will be empty.\");\n      }\n      if (!$alphabet) {\n         $self->throw(\"If you want me to create a PrimarySeq object for your \".\n           \"empty sequence <boggle> you must specify a -alphabet to satisfy \".\n           \"the constructor requirements for a Bio::PrimarySeq object with no \".\n           \"sequence. Read the POD for it, luke.\");\n      }\n      $self->{seq_ref} = Bio::PrimarySeq->new( -seq              =>  \"\",\n                                               -accession_number =>  $acc,\n                                               -primary_id       =>  $pid,\n                                               -desc             =>  $desc,\n                                               -display_id       =>  $id,\n                                               -alphabet         =>  $alphabet );\n   } elsif ($seq->isa('Bio::PrimarySeqI') || $seq->isa('Bio::SeqI')) {\n      $self->{seq_ref} = $seq;\n   } elsif (ref($seq)) {\n      $self->throw(\"You passed a seq argument into a SeqWithQUality object and\".\n        \" it was a reference ($seq) which did not inherit from Bio::SeqI or \".\n        \"Bio::PrimarySeqI. I don't know what to do with this!\");\n   } else {\n      my $seqobj = Bio::PrimarySeq->new( -seq              => $seq,\n                                         -accession_number => $acc,\n                                         -primary_id       => $pid,\n                                         -desc             => $desc,\n                                         -display_id       => $id   );\n      $self->{seq_ref} = $seqobj;\n   }\n   # Then import the quality scores\n   if (!defined($qual)) {\n      $self->{qual_ref} = Bio::Seq::PrimaryQual->new( -qual             => \"\",\n                                                      -accession_number => $acc,\n                                                      -primary_id       => $pid,\n                                                      -desc             => $desc,\n                                                      -display_id       => $id, );\n   } elsif (ref($qual) eq \"Bio::Seq::PrimaryQual\") {\n      $self->{qual_ref} = $qual;\n   } else {\n      my $qualobj = Bio::Seq::PrimaryQual->new( -qual             => $qual,\n                                                -accession_number => $acc,\n                                                -primary_id       => $pid,\n                                                -desc             => $desc,\n                                                -display_id       => $id,\n                                                -trace_indices    => $trace_indices );\n      $self->{qual_ref} = $qualobj;\n   }\n   # Now try to set the descriptors for this object\n   $self->_set_descriptors($qual,$seq,$id,$acc,$pid,$desc,$given_id,$alphabet);\n   $self->length();\n   $self->deprecated(\"deprecated class - use Bio::Seq::Quality instead\");\n\n   return $self;\n}\n\n=head2 _common_id()\n\n Title   : _common_id()\n Usage   : $common_id = $self->_common_id();\n Function: Compare the display_id of {qual_ref} and {seq_ref}.\n Returns : Nothing if they don't match. If they do return {seq_ref}->display_id()\n Args    : None.\n\n\n#'\nsub _common_id {\n   my $self = shift;\n   return if (!$self->{seq_ref} || !$self->{qual_ref});\n   my $sid = $self->{seq_ref}->display_id();\n   return if (!$sid);\n   return if (!$self->{qual_ref}->display_id());\n   return $sid if ($sid eq $self->{qual_ref}->display_id());\n   # should this become a warning?\n   # print(\"ids $sid and $self->{qual_ref}->display_id() do not match. Bummer.\\n\");\n}\n\n=head2 _common_display_id()\n\n Title   : _common_id()\n Usage   : $common_id = $self->_common_display_id();\n Function: Compare the display_id of {qual_ref} and {seq_ref}.\n Returns : Nothing if they don't match. If they do return {seq_ref}->display_id()\n Args    : None.\n\n\n#'\nsub _common_display_id {\n   my $self = shift;\n   $self->common_id();\n}\n\n=head2 _common_accession_number()\n\n Title   : _common_accession_number()\n Usage   : $common_id = $self->_common_accession_number();\n Function: Compare the accession_number() of {qual_ref} and {seq_ref}.\n Returns : Nothing if they don't match. If they do return {seq_ref}->accession_number()\n Args    : None.\n\n\n#'\nsub _common_accession_number {\n   my $self = shift;\n   return if ($self->{seq_ref} || $self->{qual_ref});\n   my $acc = $self->{seq_ref}->accession_number();\n   # if (!$acc) { print(\"the seqref has no acc.\\n\"); }\n   return if (!$acc);\n   # if ($acc eq $self->{qual_ref}->accession_number()) { print(\"$acc matches \".$self->{qual_ref}->accession_number().\"\\n\"); }\n   return $acc if ($acc eq $self->{qual_ref}->accession_number());\n   # should this become a warning?\n   # print(\"accession numbers $acc and $self->{qual_ref}->accession_number() do not match. Bummer.\\n\");\n}\n\n=head2 _common_primary_id()\n\n Title   : _common_primary_id()\n Usage   : $common_primard_id = $self->_common_primary_id();\n Function: Compare the primary_id of {qual_ref} and {seq_ref}.\n Returns : Nothing if they don't match. If they do return {seq_ref}->primary_id()\n Args    : None.\n\n\n#'\nsub _common_primary_id {\n   my $self = shift;\n   return if ($self->{seq_ref} || $self->{qual_ref});\n   my $pid = $self->{seq_ref}->primary_id();\n   return if (!$pid);\n   return $pid if ($pid eq $self->{qual_ref}->primary_id());\n   # should this become a warning?\n   # print(\"primary_ids $pid and $self->{qual_ref}->primary_id() do not match. Bummer.\\n\");\n}\n\n=head2 _common_desc()\n\n Title   : _common_desc()\n Usage   : $common_desc = $self->_common_desc();\n Function: Compare the desc of {qual_ref} and {seq_ref}.\n Returns : Nothing if they don't match. If they do return {seq_ref}->desc()\n Args    : None.\n\n\n#'\nsub _common_desc {\n   my $self = shift;\n   return if ($self->{seq_ref} || $self->{qual_ref});\n   my $des = $self->{seq_ref}->desc();\n   return if (!$des);\n   return $des if ($des eq $self->{qual_ref}->desc());\n   # should this become a warning?\n   # print(\"descriptions $des and $self->{qual_ref}->desc() do not match. Bummer.\\n\");\n}\n\n=head2 set_common_descriptors()\n\n Title   : set_common_descriptors()\n Usage   : $self->set_common_descriptors();\n Function: Compare the descriptors (id,accession_number,display_id,\n           primary_id, desc) for the PrimarySeq and PrimaryQual objects\n           within the SeqWithQuality object. If they match, make that\n           descriptor the descriptor for the SeqWithQuality object.\n Returns : Nothing.\n Args    : None.\n\n\nsub set_common_descriptors {\n   my $self = shift;\n   return if ($self->{seq_ref} || $self->{qual_ref});\n   &_common_id();\n   &_common_display_id();\n   &_common_accession_number();\n   &_common_primary_id();\n   &_common_desc();\n}\n\n=head2 alphabet()\n\n Title   : alphabet();\n Usage   : $molecule_type = $obj->alphabet();\n Function: Get the molecule type from the PrimarySeq object.\n Returns : What what PrimarySeq says the type of the sequence is.\n Args    : None.\n\n\nsub alphabet {\n   my $self = shift;\n   return $self->{seq_ref}->alphabet();\n}\n\n=head2 display_id()\n\n Title   : display_id()\n Usage   : $id_string = $obj->display_id();\n Function: Returns the display id, aka the common name of the Quality object.\n           The semantics of this is that it is the most likely string to be\n           used as an identifier of the quality sequence, and likely to have\n           \"human\" readability.  The id is equivalent to the ID field of the\n           GenBank/EMBL databanks and the id field of the Swissprot/sptrembl\n           database. In fasta format, the >(\\S+) is presumed to be the id,\n           though some people overload the id to embed other information.\n           Bioperl does not use any embedded information in the ID field,\n           and people are encouraged to use other mechanisms (accession\n           field for example, or extending the sequence object) to solve\n           this. Notice that $seq->id() maps to this function, mainly for\n           legacy/convience issues.\n           This method sets the display_id for the SeqWithQuality object.\n Returns : A string\n Args    : If a scalar is provided, it is set as the new display_id for\n           the SeqWithQuality object.\n Status  : Virtual\n\n\nsub display_id {\n   my ($obj,$value) = @_;\n   if( defined $value) {\n      $obj->{'display_id'} = $value;\n    }\n    return $obj->{'display_id'};\n\n}\n\n=head2 accession_number()\n\n Title   : accession_number()\n Usage   : $unique_biological_key = $obj->accession_number();\n Function: Returns the unique biological id for a sequence, commonly\n           called the accession_number. For sequences from established\n           databases, the implementors should try to use the correct\n           accession number. Notice that primary_id() provides the unique id\n           for the implemetation, allowing multiple objects to have the same\n           accession number in a particular implementation. For sequences\n           with no accession number, this method should return \"unknown\".\n           This method sets the accession_number for the SeqWithQuality\n           object. \n Returns : A string (the value of accession_number)\n Args    : If a scalar is provided, it is set as the new accession_number\n           for the SeqWithQuality object.\n Status  : Virtual\n\n\nsub accession_number {\n    my( $obj, $acc ) = @_;\n\n    if (defined $acc) {\n        $obj->{'accession_number'} = $acc;\n    } else {\n        $acc = $obj->{'accession_number'};\n        $acc = 'unknown' unless defined $acc;\n    }\n    return $acc;\n}\n\n=head2 primary_id()\n\n Title   : primary_id()\n Usage   : $unique_implementation_key = $obj->primary_id();\n Function: Returns the unique id for this object in this implementation.\n           This allows implementations to manage their own object ids in a\n           way the implementaiton can control clients can expect one id to\n           map to one object. For sequences with no accession number, this\n           method should return a stringified memory location.\n           This method sets the primary_id for the SeqWithQuality object.\n Returns : A string. (the value of primary_id)\n Args    : If a scalar is provided, it is set as the new primary_id for\n           the SeqWithQuality object.\n\n\nsub primary_id {\n   my ($obj,$value) = @_;\n   if ($value) {\n      $obj->{'primary_id'} = $value;\n    }\n   return $obj->{'primary_id'};\n\n}\n\n=head2 desc()\n\n Title   : desc()\n Usage   : $qual->desc($newval); _or_ \n           $description = $qual->desc();\n Function: Get/set description text for this SeqWithQuality object.\n Returns : A string. (the value of desc)\n Args    : If a scalar is provided, it is set as the new desc for the\n           SeqWithQuality object.\n\n\nsub desc {\n   # a mechanism to set the disc for the SeqWithQuality object.\n   # probably will be used most often by set_common_features()\n   my ($obj,$value) = @_;\n   if( defined $value) {\n      $obj->{'desc'} = $value;\n   }\n   return $obj->{'desc'};\n}\n\n=head2 id()\n\n Title   : id()\n Usage   : $id = $qual->id();\n Function: Return the ID of the quality. This should normally be (and\n           actually is in the implementation provided here) just a synonym\n           for display_id().\n Returns : A string. (the value of id)\n Args    : If a scalar is provided, it is set as the new id for the\n           SeqWithQuality object.\n\n\nsub id {\n   my ($self,$value) = @_;\n   if (!$self) { $self->throw(\"no value for self in $value\"); }\n   if( defined $value ) {\n      return $self->display_id($value);\n   }\n   return $self->display_id();\n}\n\n=head2 seq\n\n Title   : seq()\n Usage   : $string    = $obj->seq(); _or_ $obj->seq(\"atctatcatca\");\n Function: Returns the sequence that is contained in the imbedded in the\n           PrimarySeq object within the SeqWithQuality object\n Returns : A scalar (the seq() value for the imbedded PrimarySeq object.)\n Args    : If a scalar is provided, the SeqWithQuality object will\n           attempt to set that as the sequence for the imbedded PrimarySeq\n           object. Otherwise, the value of seq() for the PrimarySeq object\n           is returned.\n Notes   : This is probably not a good idea because you then should call\n           length() to make sure that the sequence and quality are of the\n           same length. Even then, how can you make sure that this sequence\n           belongs with that quality? I provided this to give you rope to\n           hang yourself with. Tie it to a strong device and use a good\n           knot.\n\n\nsub seq {\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{seq_ref}->seq($value);\n      $self->length();\n   }\n   return $self->{seq_ref}->seq();\n}\n\n=head2 qual()\n\n Title   : qual()\n Usage   : @quality_values  = @{$obj->qual()}; _or_\n           $obj->qual(\"10 10 20 40 50\");\n Function: Returns the quality as imbedded in the PrimaryQual object\n           within the SeqWithQuality object.\n Returns : A reference to an array containing the quality values in the \n           PrimaryQual object.\n Args    : If a scalar is provided, the SeqWithQuality object will\n           attempt to set that as the quality for the imbedded PrimaryQual\n           object. Otherwise, the value of qual() for the PrimaryQual\n           object is returned.\n Notes   : This is probably not a good idea because you then should call\n           length() to make sure that the sequence and quality are of the\n           same length. Even then, how can you make sure that this sequence\n           belongs with that quality? I provided this to give you a strong\n           board with which to flagellate yourself. \n\n\nsub qual {\n   my ($self,$value) = @_;\n\n   if( defined $value) {\n      $self->{qual_ref}->qual($value);\n      # update the lengths\n      $self->length();\n   }\n   return $self->{qual_ref}->qual();\n}\n\n\n\n=head2 trace_indices()\n\n Title   : trace_indices()\n Usage   : @trace_indice_values  = @{$obj->trace_indices()}; _or_\n           $obj->trace_indices(\"10 10 20 40 50\");\n Function: Returns the trace_indices as imbedded in the Primaryqual object\n           within the SeqWithQualiity object.\n Returns : A reference to an array containing the trace_indice values in the \n           PrimaryQual object.\n Args    : If a scalar is provided, the SeqWithuQuality object will\n           attempt to set that as the trace_indices for the imbedded PrimaryQual\n           object. Otherwise, the value of trace_indices() for the PrimaryQual\n           object is returned.\n Notes   : This is probably not a good idea because you then should call\n           length() to make sure that the sequence and trace_indices are of the\n           same length. Even then, how can you make sure that this sequence\n           belongs with that trace_indicex? I provided this to give you a strong\n           board with which to flagellate yourself. \n\n\nsub trace_indices {\n   my ($self,$value) = @_;\n\n   if( defined $value) {\n      $self->{qual_ref}->trace_indices($value);\n      # update the lengths\n      $self->length();\n   }\n   return $self->{qual_ref}->trace_indices();\n}\n\n\n\n\n=head2 length()\n\n Title   : length()\n Usage   : $length = $seqWqual->length();\n Function: Get the length of the SeqWithQuality sequence/quality.\n Returns : Returns the length of the sequence and quality if they are\n           both the same. Returns \"DIFFERENT\" if they differ.\n Args    : None.\n\n\nsub length {\n   my $self = shift;\n   if (!$self->{seq_ref}) {\n      unless ($self->{supress_warnings} == 1) {\n         $self->warn(\"Can't find {seq_ref} here in length().\");\n      }\n      return;\n   }\n   if (!$self->{qual_ref}) {\n      unless ($self->{supress_warnings} == 1) {\n         $self->warn(\"Can't find {qual_ref} here in length().\");\n      }\n      return;\n   }\n   my $seql = $self->{seq_ref}->length();\n\n   if ($seql != $self->{qual_ref}->length()) {\n      unless ($self->{supress_warnings} == 1) {\n         $self->warn(\"Sequence length (\".$seql.\") is different from quality \".\n           \"length (\".$self->{qual_ref}->length().\") in the SeqWithQuality \".\n           \"object. This can only lead to problems later.\");\n      }\n      $self->{'length'} = \"DIFFERENT\";\n   } else {\n      $self->{'length'} = $seql;\n   }\n   return $self->{'length'};\n}\n\n\n=head2 qual_obj\n\n Title   : qual_obj($different_obj)\n Usage   : $qualobj = $seqWqual->qual_obj(); _or_\n           $qualobj = $seqWqual->qual_obj($ref_to_primaryqual_obj);\n Function: Get the PrimaryQual object that is imbedded in the\n           SeqWithQuality object or if a reference to a PrimaryQual object\n           is provided, set this as the PrimaryQual object imbedded in the\n           SeqWithQuality object.\n Returns : A reference to a Bio::Seq::SeqWithQuality object.\n\n\nsub qual_obj {\n   my ($self,$value) = @_;\n   if (defined($value)) {\n      if (ref($value) eq \"Bio::Seq::PrimaryQual\") {\n         $self->{qual_ref} = $value;\n         $self->debug(\"You successfully changed the PrimaryQual object within \".\n           \"a SeqWithQuality object. ID's for the SeqWithQuality object may \".\n           \"now not be what you expect. Use something like \".\n           \"set_common_descriptors() to fix them if you care,\");\n      } else {\n         $self->debug(\"You tried to change the PrimaryQual object within a \".\n           \"SeqWithQuality object but you passed a reference to an object that\".\n           \" was not a Bio::Seq::PrimaryQual object. Thus your change failed. \".\n           \"Sorry.\\n\");\t    \n      }\n   }\n   return $self->{qual_ref};\n}\n\n\n=head2 seq_obj\n\n Title   : seq_obj()\n Usage   : $seqobj = $seqWqual->qual_obj(); _or_\n           $seqobj = $seqWqual->seq_obj($ref_to_primary_seq_obj);\n Function: Get the PrimarySeq object that is imbedded in the\n           SeqWithQuality object or if a reference to a PrimarySeq object is\n           provided, set this as the PrimarySeq object imbedded in the\n           SeqWithQuality object.\n Returns : A reference to a Bio::PrimarySeq object.\n\n\nsub seq_obj {\n   my ($self,$value) = @_;\n   if( defined $value) {\n      if (ref($value) eq \"Bio::PrimarySeq\") {\n         $self->debug(\"You successfully changed the PrimarySeq object within a\".\n           \" SeqWithQuality object. ID's for the SeqWithQuality object may now\".\n           \" not be what you expect. Use something like \".\n           \"set_common_descriptors() to fix them if you care,\");\n      } else {\n         $self->debug(\"You tried to change the PrimarySeq object within a \".\n           \"SeqWithQuality object but you passed a reference to an object that\".\n           \" was not a Bio::PrimarySeq object. Thus your change failed. Sorry.\\n\");\n      }\n   }\n   return $self->{seq_ref};\n}\n\n=head2 _set_descriptors\n\n Title   : _set_descriptors()\n Usage   : $seqWqual->_qual_obj($qual,$seq,$id,$acc,$pid,$desc,$given_id,\n           $alphabet);\n Function: Set the descriptors for the SeqWithQuality object. Try to\n           match the descriptors in the PrimarySeq object and in the\n           PrimaryQual object if descriptors were not provided with\n           construction.\n Returns : Nothing.\n Args    : $qual,$seq,$id,$acc,$pid,$desc,$given_id,$alphabet as found\n           in the new() method.\n Notes   : Really only intended to be called by the new() method. If\n           you want to invoke a similar function try set_common_descriptors().\n\n\n\nsub _set_descriptors {\n   my ($self,$qual,$seq,$id,$acc,$pid,$desc,$given_id,$alphabet) = @_;\n   my ($c_id,$c_acc,$c_pid,$c_desc);\n   if (!$self->display_id()) {\n      if ($c_id = $self->_common_id() ) { $self->display_id($c_id); }\n      else {\n         if ($self->{seq_ref}) {\n            # print(\"Using seq_ref to set id to \".$self->{seq_ref}->display_id().\"\\n\");\n            # ::dumpValue($self->{seq_ref});\n            $self->display_id($self->{seq_ref}->id());\n         } elsif ($self->{qual_ref}) {\n            $self->display_id($self->{qual_ref}->id());\n         }\n      }\n   }\n   if ($acc) { $self->accession_number($acc); }\n   elsif ($c_acc = $self->_common_accession_number() ) { $self->accession_number($c_acc); }\n   if ($pid) { $self->primary_id($pid); }\n   elsif ($c_pid = $self->_common_primary_id() ) { $self->primary_id($c_pid); }\n   if ($desc) { $self->desc($desc); }\n   elsif ($c_desc = $self->_common_desc() ) { $self->desc($c_desc); }\n}\n\n=head2 subseq($start,$end)\n\n Title   : subseq($start,$end)\n Usage   : $subsequence = $obj->subseq($start,$end);\n Function: Returns the subseq from start to end, where the first base\n           is 1 and the number is inclusive, ie 1-2 are the first two\n           bases of the sequence.\n Returns : A string.\n Args    : Two positions.","parameters":[{"label":"$self"},{"label":"@args"}],"label":"subseq($self,@args)"},"kind":12,"line":778,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"subseq","line":779,"kind":13},{"kind":13,"line":779,"containerName":"subseq","name":"@args"},{"name":"$self","containerName":"subseq","line":781,"kind":13},{"line":781,"kind":12,"name":"subseq","containerName":"subseq"},{"name":"@args","containerName":"subseq","kind":13,"line":781}]},{"name":"seq_ref","kind":12,"line":781},{"kind":12,"line":796,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"baseat","line":797,"kind":13},{"containerName":"baseat","name":"$val","line":797,"kind":13},{"line":798,"kind":13,"containerName":"baseat","name":"$self"},{"line":798,"kind":12,"name":"subseq","containerName":"baseat"},{"name":"$val","containerName":"baseat","kind":13,"line":798},{"name":"$val","containerName":"baseat","kind":13,"line":798}],"containerName":"main::","definition":"sub","detail":"($self,$val)","signature":{"label":"baseat($self,$val)","parameters":[{"label":"$self"},{"label":"$val"}],"documentation":"1;\n# $Id: SeqWithQuality.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Seq::QualI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chad Matsalla <bioinformatics@dieselwurks.com\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::SeqWithQuality - Bioperl object packaging a sequence with its quality.\nDeprecated class, use Bio::Seq::Quality instead!\n\n=head1 SYNOPSIS\n\n    use Bio::PrimarySeq;\n    use Bio::Seq::PrimaryQual;\n    use Bio::Seq::SeqWithQuality;\n\n    # make from memory\n    my $qual = Bio::Seq::SeqWithQuality->new\n    ( -qual => '10 20 30 40 50 50 20 10',\n      -seq => 'ATCGATCG',\n      -id  => 'human_id',\n      -accession_number => 'AL000012',\n    );\n\n    # make from objects\n    # first, make a PrimarySeq object\n    my $seqobj = Bio::PrimarySeq->new\n    ( -seq => 'atcgatcg',\n      -id  => 'GeneFragment-12',\n      -accession_number => 'X78121',\n      -alphabet => 'dna'\n    );\n\n    # now make a PrimaryQual object\n    my $qualobj = Bio::Seq::PrimaryQual->new\n    ( -qual => '10 20 30 40 50 50 20 10',\n      -id  => 'GeneFragment-12',\n      -accession_number => 'X78121',\n      -alphabet => 'dna'\n    );\n\n    # now make the SeqWithQuality object\n    my $swqobj = Bio::Seq::SeqWithQuality->new\n    ( -seq  => $seqobj,\n      -qual => $qualobj\n    );\n    # done!\n\n    $swqobj->id(); # the id of the SeqWithQuality object\n    # may not match the the id of the sequence or\n    # of the quality (check the pod, luke)\n    $swqobj->seq(); # the sequence of the SeqWithQuality object\n    $swqobj->qual(); # the quality of the SeqWithQuality object\n\n    # to get out parts of the sequence.\n\n    print \"Sequence \", $seqobj->id(), \" with accession \",\n    $seqobj->accession, \" and desc \", $seqobj->desc, \"\\n\";\n\n    $string2 = $seqobj->subseq(1,40);\n\n=head1 DESCRIPTION\n\nThis object stores base quality values together with the sequence string.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nEmail bioinformatics@dieselwurks.com\n\n=head1 CONTRIBUTORS \n\nJason Stajich, jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\npackage Bio::Seq::SeqWithQuality;\n\n\nuse strict;\nuse Bio::PrimarySeq;\nuse Bio::Seq::PrimaryQual;\n\nuse base qw(Bio::Root::Root Bio::PrimarySeqI Bio::Seq::QualI);\n\n=head2 new()\n\n Title   : new()\n Usage   : $qual = Bio::Seq::SeqWithQuality ->new\n             ( -qual => '10 20 30 40 50 50 20 10',\n               -seq => 'ATCGATCG',\n               -id  => 'human_id',\n               -accession_number => 'AL000012',\n               -trace_indices    => '0 5 10 15 20 25 30 35'\n             );\n Function: Returns a new Bio::Seq::SeqWithQual object from basic\n           constructors.\n Returns : a new Bio::Seq::PrimaryQual object\n Args    : -qual can be a quality string (see Bio::Seq::PrimaryQual for more\n            information on this) or a reference to a Bio::Seq::PrimaryQual\n            object.\n           -seq can be a sequence string (see Bio::PrimarySeq for more\n            information on this) or a reference to a Bio::PrimaryQual object.\n           -seq, -id, -accession_number, -primary_id, -desc, -id behave like\n            this:\n             1. if they are provided on construction of the\n                 Bio::Seq::SeqWithQuality they will be set as the descriptors for\n                 the object unless changed by one of the following mechanisms:\n              a) $obj->set_common_descriptors() is used and both the -seq and\n                 the -qual object have the same descriptors. These common\n                 descriptors will then become the descriptors for the\n                 Bio::Seq::SeqWithQual object.\n              b) the descriptors are manually set using the seq(), id(),\n                 desc(), or accession_number(), primary_id(),\n             2. if no descriptors are provided, the new() constructor will see\n                if the descriptor used in the PrimarySeq and in the\n                PrimaryQual objects match. If they do, they will become\n                the descriptors for the SeqWithQuality object.\n             To eliminate ambiguity, I strongly suggest you set the\n             descriptors manually on construction of the object. Really.\n           -trace_indices : a space_delimited list of trace indices\n            (where would the peaks be drawn if this list of qualities\n            was to be plotted?)\n\n\nsub new {\n   my ($class, @args) = @_;\n   my $self = $class->SUPER::new(@args);\n   # default: turn OFF the warnings\n   $self->{supress_warnings} = 1;\n   my($qual,$seq,$id,$acc,$pid,$desc,$given_id,$alphabet,$trace_indices) =\n   $self->_rearrange([qw( QUAL SEQ DISPLAY_ID ACCESSION_NUMBER PRIMARY_ID DESC\n     ID ALPHABET TRACE_INDICES )], @args);\n   # Deal with the ID\n   if ( defined $id && defined $given_id ) {\n      if( $id ne $given_id ) {\n         $self->throw(\"Provided both id and display_id constructor functions. [$id] [$given_id]\");\n      }\n   }\n   if( defined $given_id ) {\n      $self->display_id($given_id);\n      $id = $given_id;\n   }\n   # Import sequence first\n   if (!$seq) {\n      my $id;\n      unless ($self->{supress_warnings} == 1) {\n         $self->warn(\"You did not provide sequence information during the \".\n           \"construction of a Bio::Seq::SeqWithQuality object. Sequence \".\n           \"components for this object will be empty.\");\n      }\n      if (!$alphabet) {\n         $self->throw(\"If you want me to create a PrimarySeq object for your \".\n           \"empty sequence <boggle> you must specify a -alphabet to satisfy \".\n           \"the constructor requirements for a Bio::PrimarySeq object with no \".\n           \"sequence. Read the POD for it, luke.\");\n      }\n      $self->{seq_ref} = Bio::PrimarySeq->new( -seq              =>  \"\",\n                                               -accession_number =>  $acc,\n                                               -primary_id       =>  $pid,\n                                               -desc             =>  $desc,\n                                               -display_id       =>  $id,\n                                               -alphabet         =>  $alphabet );\n   } elsif ($seq->isa('Bio::PrimarySeqI') || $seq->isa('Bio::SeqI')) {\n      $self->{seq_ref} = $seq;\n   } elsif (ref($seq)) {\n      $self->throw(\"You passed a seq argument into a SeqWithQUality object and\".\n        \" it was a reference ($seq) which did not inherit from Bio::SeqI or \".\n        \"Bio::PrimarySeqI. I don't know what to do with this!\");\n   } else {\n      my $seqobj = Bio::PrimarySeq->new( -seq              => $seq,\n                                         -accession_number => $acc,\n                                         -primary_id       => $pid,\n                                         -desc             => $desc,\n                                         -display_id       => $id   );\n      $self->{seq_ref} = $seqobj;\n   }\n   # Then import the quality scores\n   if (!defined($qual)) {\n      $self->{qual_ref} = Bio::Seq::PrimaryQual->new( -qual             => \"\",\n                                                      -accession_number => $acc,\n                                                      -primary_id       => $pid,\n                                                      -desc             => $desc,\n                                                      -display_id       => $id, );\n   } elsif (ref($qual) eq \"Bio::Seq::PrimaryQual\") {\n      $self->{qual_ref} = $qual;\n   } else {\n      my $qualobj = Bio::Seq::PrimaryQual->new( -qual             => $qual,\n                                                -accession_number => $acc,\n                                                -primary_id       => $pid,\n                                                -desc             => $desc,\n                                                -display_id       => $id,\n                                                -trace_indices    => $trace_indices );\n      $self->{qual_ref} = $qualobj;\n   }\n   # Now try to set the descriptors for this object\n   $self->_set_descriptors($qual,$seq,$id,$acc,$pid,$desc,$given_id,$alphabet);\n   $self->length();\n   $self->deprecated(\"deprecated class - use Bio::Seq::Quality instead\");\n\n   return $self;\n}\n\n=head2 _common_id()\n\n Title   : _common_id()\n Usage   : $common_id = $self->_common_id();\n Function: Compare the display_id of {qual_ref} and {seq_ref}.\n Returns : Nothing if they don't match. If they do return {seq_ref}->display_id()\n Args    : None.\n\n\n#'\nsub _common_id {\n   my $self = shift;\n   return if (!$self->{seq_ref} || !$self->{qual_ref});\n   my $sid = $self->{seq_ref}->display_id();\n   return if (!$sid);\n   return if (!$self->{qual_ref}->display_id());\n   return $sid if ($sid eq $self->{qual_ref}->display_id());\n   # should this become a warning?\n   # print(\"ids $sid and $self->{qual_ref}->display_id() do not match. Bummer.\\n\");\n}\n\n=head2 _common_display_id()\n\n Title   : _common_id()\n Usage   : $common_id = $self->_common_display_id();\n Function: Compare the display_id of {qual_ref} and {seq_ref}.\n Returns : Nothing if they don't match. If they do return {seq_ref}->display_id()\n Args    : None.\n\n\n#'\nsub _common_display_id {\n   my $self = shift;\n   $self->common_id();\n}\n\n=head2 _common_accession_number()\n\n Title   : _common_accession_number()\n Usage   : $common_id = $self->_common_accession_number();\n Function: Compare the accession_number() of {qual_ref} and {seq_ref}.\n Returns : Nothing if they don't match. If they do return {seq_ref}->accession_number()\n Args    : None.\n\n\n#'\nsub _common_accession_number {\n   my $self = shift;\n   return if ($self->{seq_ref} || $self->{qual_ref});\n   my $acc = $self->{seq_ref}->accession_number();\n   # if (!$acc) { print(\"the seqref has no acc.\\n\"); }\n   return if (!$acc);\n   # if ($acc eq $self->{qual_ref}->accession_number()) { print(\"$acc matches \".$self->{qual_ref}->accession_number().\"\\n\"); }\n   return $acc if ($acc eq $self->{qual_ref}->accession_number());\n   # should this become a warning?\n   # print(\"accession numbers $acc and $self->{qual_ref}->accession_number() do not match. Bummer.\\n\");\n}\n\n=head2 _common_primary_id()\n\n Title   : _common_primary_id()\n Usage   : $common_primard_id = $self->_common_primary_id();\n Function: Compare the primary_id of {qual_ref} and {seq_ref}.\n Returns : Nothing if they don't match. If they do return {seq_ref}->primary_id()\n Args    : None.\n\n\n#'\nsub _common_primary_id {\n   my $self = shift;\n   return if ($self->{seq_ref} || $self->{qual_ref});\n   my $pid = $self->{seq_ref}->primary_id();\n   return if (!$pid);\n   return $pid if ($pid eq $self->{qual_ref}->primary_id());\n   # should this become a warning?\n   # print(\"primary_ids $pid and $self->{qual_ref}->primary_id() do not match. Bummer.\\n\");\n}\n\n=head2 _common_desc()\n\n Title   : _common_desc()\n Usage   : $common_desc = $self->_common_desc();\n Function: Compare the desc of {qual_ref} and {seq_ref}.\n Returns : Nothing if they don't match. If they do return {seq_ref}->desc()\n Args    : None.\n\n\n#'\nsub _common_desc {\n   my $self = shift;\n   return if ($self->{seq_ref} || $self->{qual_ref});\n   my $des = $self->{seq_ref}->desc();\n   return if (!$des);\n   return $des if ($des eq $self->{qual_ref}->desc());\n   # should this become a warning?\n   # print(\"descriptions $des and $self->{qual_ref}->desc() do not match. Bummer.\\n\");\n}\n\n=head2 set_common_descriptors()\n\n Title   : set_common_descriptors()\n Usage   : $self->set_common_descriptors();\n Function: Compare the descriptors (id,accession_number,display_id,\n           primary_id, desc) for the PrimarySeq and PrimaryQual objects\n           within the SeqWithQuality object. If they match, make that\n           descriptor the descriptor for the SeqWithQuality object.\n Returns : Nothing.\n Args    : None.\n\n\nsub set_common_descriptors {\n   my $self = shift;\n   return if ($self->{seq_ref} || $self->{qual_ref});\n   &_common_id();\n   &_common_display_id();\n   &_common_accession_number();\n   &_common_primary_id();\n   &_common_desc();\n}\n\n=head2 alphabet()\n\n Title   : alphabet();\n Usage   : $molecule_type = $obj->alphabet();\n Function: Get the molecule type from the PrimarySeq object.\n Returns : What what PrimarySeq says the type of the sequence is.\n Args    : None.\n\n\nsub alphabet {\n   my $self = shift;\n   return $self->{seq_ref}->alphabet();\n}\n\n=head2 display_id()\n\n Title   : display_id()\n Usage   : $id_string = $obj->display_id();\n Function: Returns the display id, aka the common name of the Quality object.\n           The semantics of this is that it is the most likely string to be\n           used as an identifier of the quality sequence, and likely to have\n           \"human\" readability.  The id is equivalent to the ID field of the\n           GenBank/EMBL databanks and the id field of the Swissprot/sptrembl\n           database. In fasta format, the >(\\S+) is presumed to be the id,\n           though some people overload the id to embed other information.\n           Bioperl does not use any embedded information in the ID field,\n           and people are encouraged to use other mechanisms (accession\n           field for example, or extending the sequence object) to solve\n           this. Notice that $seq->id() maps to this function, mainly for\n           legacy/convience issues.\n           This method sets the display_id for the SeqWithQuality object.\n Returns : A string\n Args    : If a scalar is provided, it is set as the new display_id for\n           the SeqWithQuality object.\n Status  : Virtual\n\n\nsub display_id {\n   my ($obj,$value) = @_;\n   if( defined $value) {\n      $obj->{'display_id'} = $value;\n    }\n    return $obj->{'display_id'};\n\n}\n\n=head2 accession_number()\n\n Title   : accession_number()\n Usage   : $unique_biological_key = $obj->accession_number();\n Function: Returns the unique biological id for a sequence, commonly\n           called the accession_number. For sequences from established\n           databases, the implementors should try to use the correct\n           accession number. Notice that primary_id() provides the unique id\n           for the implemetation, allowing multiple objects to have the same\n           accession number in a particular implementation. For sequences\n           with no accession number, this method should return \"unknown\".\n           This method sets the accession_number for the SeqWithQuality\n           object. \n Returns : A string (the value of accession_number)\n Args    : If a scalar is provided, it is set as the new accession_number\n           for the SeqWithQuality object.\n Status  : Virtual\n\n\nsub accession_number {\n    my( $obj, $acc ) = @_;\n\n    if (defined $acc) {\n        $obj->{'accession_number'} = $acc;\n    } else {\n        $acc = $obj->{'accession_number'};\n        $acc = 'unknown' unless defined $acc;\n    }\n    return $acc;\n}\n\n=head2 primary_id()\n\n Title   : primary_id()\n Usage   : $unique_implementation_key = $obj->primary_id();\n Function: Returns the unique id for this object in this implementation.\n           This allows implementations to manage their own object ids in a\n           way the implementaiton can control clients can expect one id to\n           map to one object. For sequences with no accession number, this\n           method should return a stringified memory location.\n           This method sets the primary_id for the SeqWithQuality object.\n Returns : A string. (the value of primary_id)\n Args    : If a scalar is provided, it is set as the new primary_id for\n           the SeqWithQuality object.\n\n\nsub primary_id {\n   my ($obj,$value) = @_;\n   if ($value) {\n      $obj->{'primary_id'} = $value;\n    }\n   return $obj->{'primary_id'};\n\n}\n\n=head2 desc()\n\n Title   : desc()\n Usage   : $qual->desc($newval); _or_ \n           $description = $qual->desc();\n Function: Get/set description text for this SeqWithQuality object.\n Returns : A string. (the value of desc)\n Args    : If a scalar is provided, it is set as the new desc for the\n           SeqWithQuality object.\n\n\nsub desc {\n   # a mechanism to set the disc for the SeqWithQuality object.\n   # probably will be used most often by set_common_features()\n   my ($obj,$value) = @_;\n   if( defined $value) {\n      $obj->{'desc'} = $value;\n   }\n   return $obj->{'desc'};\n}\n\n=head2 id()\n\n Title   : id()\n Usage   : $id = $qual->id();\n Function: Return the ID of the quality. This should normally be (and\n           actually is in the implementation provided here) just a synonym\n           for display_id().\n Returns : A string. (the value of id)\n Args    : If a scalar is provided, it is set as the new id for the\n           SeqWithQuality object.\n\n\nsub id {\n   my ($self,$value) = @_;\n   if (!$self) { $self->throw(\"no value for self in $value\"); }\n   if( defined $value ) {\n      return $self->display_id($value);\n   }\n   return $self->display_id();\n}\n\n=head2 seq\n\n Title   : seq()\n Usage   : $string    = $obj->seq(); _or_ $obj->seq(\"atctatcatca\");\n Function: Returns the sequence that is contained in the imbedded in the\n           PrimarySeq object within the SeqWithQuality object\n Returns : A scalar (the seq() value for the imbedded PrimarySeq object.)\n Args    : If a scalar is provided, the SeqWithQuality object will\n           attempt to set that as the sequence for the imbedded PrimarySeq\n           object. Otherwise, the value of seq() for the PrimarySeq object\n           is returned.\n Notes   : This is probably not a good idea because you then should call\n           length() to make sure that the sequence and quality are of the\n           same length. Even then, how can you make sure that this sequence\n           belongs with that quality? I provided this to give you rope to\n           hang yourself with. Tie it to a strong device and use a good\n           knot.\n\n\nsub seq {\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{seq_ref}->seq($value);\n      $self->length();\n   }\n   return $self->{seq_ref}->seq();\n}\n\n=head2 qual()\n\n Title   : qual()\n Usage   : @quality_values  = @{$obj->qual()}; _or_\n           $obj->qual(\"10 10 20 40 50\");\n Function: Returns the quality as imbedded in the PrimaryQual object\n           within the SeqWithQuality object.\n Returns : A reference to an array containing the quality values in the \n           PrimaryQual object.\n Args    : If a scalar is provided, the SeqWithQuality object will\n           attempt to set that as the quality for the imbedded PrimaryQual\n           object. Otherwise, the value of qual() for the PrimaryQual\n           object is returned.\n Notes   : This is probably not a good idea because you then should call\n           length() to make sure that the sequence and quality are of the\n           same length. Even then, how can you make sure that this sequence\n           belongs with that quality? I provided this to give you a strong\n           board with which to flagellate yourself. \n\n\nsub qual {\n   my ($self,$value) = @_;\n\n   if( defined $value) {\n      $self->{qual_ref}->qual($value);\n      # update the lengths\n      $self->length();\n   }\n   return $self->{qual_ref}->qual();\n}\n\n\n\n=head2 trace_indices()\n\n Title   : trace_indices()\n Usage   : @trace_indice_values  = @{$obj->trace_indices()}; _or_\n           $obj->trace_indices(\"10 10 20 40 50\");\n Function: Returns the trace_indices as imbedded in the Primaryqual object\n           within the SeqWithQualiity object.\n Returns : A reference to an array containing the trace_indice values in the \n           PrimaryQual object.\n Args    : If a scalar is provided, the SeqWithuQuality object will\n           attempt to set that as the trace_indices for the imbedded PrimaryQual\n           object. Otherwise, the value of trace_indices() for the PrimaryQual\n           object is returned.\n Notes   : This is probably not a good idea because you then should call\n           length() to make sure that the sequence and trace_indices are of the\n           same length. Even then, how can you make sure that this sequence\n           belongs with that trace_indicex? I provided this to give you a strong\n           board with which to flagellate yourself. \n\n\nsub trace_indices {\n   my ($self,$value) = @_;\n\n   if( defined $value) {\n      $self->{qual_ref}->trace_indices($value);\n      # update the lengths\n      $self->length();\n   }\n   return $self->{qual_ref}->trace_indices();\n}\n\n\n\n\n=head2 length()\n\n Title   : length()\n Usage   : $length = $seqWqual->length();\n Function: Get the length of the SeqWithQuality sequence/quality.\n Returns : Returns the length of the sequence and quality if they are\n           both the same. Returns \"DIFFERENT\" if they differ.\n Args    : None.\n\n\nsub length {\n   my $self = shift;\n   if (!$self->{seq_ref}) {\n      unless ($self->{supress_warnings} == 1) {\n         $self->warn(\"Can't find {seq_ref} here in length().\");\n      }\n      return;\n   }\n   if (!$self->{qual_ref}) {\n      unless ($self->{supress_warnings} == 1) {\n         $self->warn(\"Can't find {qual_ref} here in length().\");\n      }\n      return;\n   }\n   my $seql = $self->{seq_ref}->length();\n\n   if ($seql != $self->{qual_ref}->length()) {\n      unless ($self->{supress_warnings} == 1) {\n         $self->warn(\"Sequence length (\".$seql.\") is different from quality \".\n           \"length (\".$self->{qual_ref}->length().\") in the SeqWithQuality \".\n           \"object. This can only lead to problems later.\");\n      }\n      $self->{'length'} = \"DIFFERENT\";\n   } else {\n      $self->{'length'} = $seql;\n   }\n   return $self->{'length'};\n}\n\n\n=head2 qual_obj\n\n Title   : qual_obj($different_obj)\n Usage   : $qualobj = $seqWqual->qual_obj(); _or_\n           $qualobj = $seqWqual->qual_obj($ref_to_primaryqual_obj);\n Function: Get the PrimaryQual object that is imbedded in the\n           SeqWithQuality object or if a reference to a PrimaryQual object\n           is provided, set this as the PrimaryQual object imbedded in the\n           SeqWithQuality object.\n Returns : A reference to a Bio::Seq::SeqWithQuality object.\n\n\nsub qual_obj {\n   my ($self,$value) = @_;\n   if (defined($value)) {\n      if (ref($value) eq \"Bio::Seq::PrimaryQual\") {\n         $self->{qual_ref} = $value;\n         $self->debug(\"You successfully changed the PrimaryQual object within \".\n           \"a SeqWithQuality object. ID's for the SeqWithQuality object may \".\n           \"now not be what you expect. Use something like \".\n           \"set_common_descriptors() to fix them if you care,\");\n      } else {\n         $self->debug(\"You tried to change the PrimaryQual object within a \".\n           \"SeqWithQuality object but you passed a reference to an object that\".\n           \" was not a Bio::Seq::PrimaryQual object. Thus your change failed. \".\n           \"Sorry.\\n\");\t    \n      }\n   }\n   return $self->{qual_ref};\n}\n\n\n=head2 seq_obj\n\n Title   : seq_obj()\n Usage   : $seqobj = $seqWqual->qual_obj(); _or_\n           $seqobj = $seqWqual->seq_obj($ref_to_primary_seq_obj);\n Function: Get the PrimarySeq object that is imbedded in the\n           SeqWithQuality object or if a reference to a PrimarySeq object is\n           provided, set this as the PrimarySeq object imbedded in the\n           SeqWithQuality object.\n Returns : A reference to a Bio::PrimarySeq object.\n\n\nsub seq_obj {\n   my ($self,$value) = @_;\n   if( defined $value) {\n      if (ref($value) eq \"Bio::PrimarySeq\") {\n         $self->debug(\"You successfully changed the PrimarySeq object within a\".\n           \" SeqWithQuality object. ID's for the SeqWithQuality object may now\".\n           \" not be what you expect. Use something like \".\n           \"set_common_descriptors() to fix them if you care,\");\n      } else {\n         $self->debug(\"You tried to change the PrimarySeq object within a \".\n           \"SeqWithQuality object but you passed a reference to an object that\".\n           \" was not a Bio::PrimarySeq object. Thus your change failed. Sorry.\\n\");\n      }\n   }\n   return $self->{seq_ref};\n}\n\n=head2 _set_descriptors\n\n Title   : _set_descriptors()\n Usage   : $seqWqual->_qual_obj($qual,$seq,$id,$acc,$pid,$desc,$given_id,\n           $alphabet);\n Function: Set the descriptors for the SeqWithQuality object. Try to\n           match the descriptors in the PrimarySeq object and in the\n           PrimaryQual object if descriptors were not provided with\n           construction.\n Returns : Nothing.\n Args    : $qual,$seq,$id,$acc,$pid,$desc,$given_id,$alphabet as found\n           in the new() method.\n Notes   : Really only intended to be called by the new() method. If\n           you want to invoke a similar function try set_common_descriptors().\n\n\n\nsub _set_descriptors {\n   my ($self,$qual,$seq,$id,$acc,$pid,$desc,$given_id,$alphabet) = @_;\n   my ($c_id,$c_acc,$c_pid,$c_desc);\n   if (!$self->display_id()) {\n      if ($c_id = $self->_common_id() ) { $self->display_id($c_id); }\n      else {\n         if ($self->{seq_ref}) {\n            # print(\"Using seq_ref to set id to \".$self->{seq_ref}->display_id().\"\\n\");\n            # ::dumpValue($self->{seq_ref});\n            $self->display_id($self->{seq_ref}->id());\n         } elsif ($self->{qual_ref}) {\n            $self->display_id($self->{qual_ref}->id());\n         }\n      }\n   }\n   if ($acc) { $self->accession_number($acc); }\n   elsif ($c_acc = $self->_common_accession_number() ) { $self->accession_number($c_acc); }\n   if ($pid) { $self->primary_id($pid); }\n   elsif ($c_pid = $self->_common_primary_id() ) { $self->primary_id($c_pid); }\n   if ($desc) { $self->desc($desc); }\n   elsif ($c_desc = $self->_common_desc() ) { $self->desc($c_desc); }\n}\n\n=head2 subseq($start,$end)\n\n Title   : subseq($start,$end)\n Usage   : $subsequence = $obj->subseq($start,$end);\n Function: Returns the subseq from start to end, where the first base\n           is 1 and the number is inclusive, ie 1-2 are the first two\n           bases of the sequence.\n Returns : A string.\n Args    : Two positions.\n\n\nsub subseq {\n    my ($self,@args) = @_;\n    # does a single value work?\n    return $self->{seq_ref}->subseq(@args);\n}\n\n=head2 baseat($position)\n\n Title   : baseat($position)\n Usage   : $base_at_position_6 = $obj->baseat(\"6\");\n Function: Returns a single base at the given position, where the first\n           base is 1 and the number is inclusive, ie 1-2 are the first two\n           bases of the sequence.\n Returns : A scalar.\n Args    : A position."},"name":"baseat","range":{"start":{"line":796,"character":0},"end":{"character":9999,"line":799}}},{"line":798,"kind":12,"name":"seq_ref"},{"range":{"start":{"line":814,"character":0},"end":{"line":817,"character":9999}},"name":"subqual","children":[{"line":815,"kind":13,"localvar":"my","containerName":"subqual","definition":"my","name":"$self"},{"containerName":"subqual","name":"@args","kind":13,"line":815},{"containerName":"subqual","name":"$self","kind":13,"line":816},{"name":"subqual","containerName":"subqual","line":816,"kind":12},{"line":816,"kind":13,"name":"@args","containerName":"subqual"}],"line":814,"kind":12,"signature":{"label":"subqual($self,@args)","documentation":"1;\n# $Id: SeqWithQuality.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Seq::QualI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chad Matsalla <bioinformatics@dieselwurks.com\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::SeqWithQuality - Bioperl object packaging a sequence with its quality.\nDeprecated class, use Bio::Seq::Quality instead!\n\n=head1 SYNOPSIS\n\n    use Bio::PrimarySeq;\n    use Bio::Seq::PrimaryQual;\n    use Bio::Seq::SeqWithQuality;\n\n    # make from memory\n    my $qual = Bio::Seq::SeqWithQuality->new\n    ( -qual => '10 20 30 40 50 50 20 10',\n      -seq => 'ATCGATCG',\n      -id  => 'human_id',\n      -accession_number => 'AL000012',\n    );\n\n    # make from objects\n    # first, make a PrimarySeq object\n    my $seqobj = Bio::PrimarySeq->new\n    ( -seq => 'atcgatcg',\n      -id  => 'GeneFragment-12',\n      -accession_number => 'X78121',\n      -alphabet => 'dna'\n    );\n\n    # now make a PrimaryQual object\n    my $qualobj = Bio::Seq::PrimaryQual->new\n    ( -qual => '10 20 30 40 50 50 20 10',\n      -id  => 'GeneFragment-12',\n      -accession_number => 'X78121',\n      -alphabet => 'dna'\n    );\n\n    # now make the SeqWithQuality object\n    my $swqobj = Bio::Seq::SeqWithQuality->new\n    ( -seq  => $seqobj,\n      -qual => $qualobj\n    );\n    # done!\n\n    $swqobj->id(); # the id of the SeqWithQuality object\n    # may not match the the id of the sequence or\n    # of the quality (check the pod, luke)\n    $swqobj->seq(); # the sequence of the SeqWithQuality object\n    $swqobj->qual(); # the quality of the SeqWithQuality object\n\n    # to get out parts of the sequence.\n\n    print \"Sequence \", $seqobj->id(), \" with accession \",\n    $seqobj->accession, \" and desc \", $seqobj->desc, \"\\n\";\n\n    $string2 = $seqobj->subseq(1,40);\n\n=head1 DESCRIPTION\n\nThis object stores base quality values together with the sequence string.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nEmail bioinformatics@dieselwurks.com\n\n=head1 CONTRIBUTORS \n\nJason Stajich, jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\npackage Bio::Seq::SeqWithQuality;\n\n\nuse strict;\nuse Bio::PrimarySeq;\nuse Bio::Seq::PrimaryQual;\n\nuse base qw(Bio::Root::Root Bio::PrimarySeqI Bio::Seq::QualI);\n\n=head2 new()\n\n Title   : new()\n Usage   : $qual = Bio::Seq::SeqWithQuality ->new\n             ( -qual => '10 20 30 40 50 50 20 10',\n               -seq => 'ATCGATCG',\n               -id  => 'human_id',\n               -accession_number => 'AL000012',\n               -trace_indices    => '0 5 10 15 20 25 30 35'\n             );\n Function: Returns a new Bio::Seq::SeqWithQual object from basic\n           constructors.\n Returns : a new Bio::Seq::PrimaryQual object\n Args    : -qual can be a quality string (see Bio::Seq::PrimaryQual for more\n            information on this) or a reference to a Bio::Seq::PrimaryQual\n            object.\n           -seq can be a sequence string (see Bio::PrimarySeq for more\n            information on this) or a reference to a Bio::PrimaryQual object.\n           -seq, -id, -accession_number, -primary_id, -desc, -id behave like\n            this:\n             1. if they are provided on construction of the\n                 Bio::Seq::SeqWithQuality they will be set as the descriptors for\n                 the object unless changed by one of the following mechanisms:\n              a) $obj->set_common_descriptors() is used and both the -seq and\n                 the -qual object have the same descriptors. These common\n                 descriptors will then become the descriptors for the\n                 Bio::Seq::SeqWithQual object.\n              b) the descriptors are manually set using the seq(), id(),\n                 desc(), or accession_number(), primary_id(),\n             2. if no descriptors are provided, the new() constructor will see\n                if the descriptor used in the PrimarySeq and in the\n                PrimaryQual objects match. If they do, they will become\n                the descriptors for the SeqWithQuality object.\n             To eliminate ambiguity, I strongly suggest you set the\n             descriptors manually on construction of the object. Really.\n           -trace_indices : a space_delimited list of trace indices\n            (where would the peaks be drawn if this list of qualities\n            was to be plotted?)\n\n\nsub new {\n   my ($class, @args) = @_;\n   my $self = $class->SUPER::new(@args);\n   # default: turn OFF the warnings\n   $self->{supress_warnings} = 1;\n   my($qual,$seq,$id,$acc,$pid,$desc,$given_id,$alphabet,$trace_indices) =\n   $self->_rearrange([qw( QUAL SEQ DISPLAY_ID ACCESSION_NUMBER PRIMARY_ID DESC\n     ID ALPHABET TRACE_INDICES )], @args);\n   # Deal with the ID\n   if ( defined $id && defined $given_id ) {\n      if( $id ne $given_id ) {\n         $self->throw(\"Provided both id and display_id constructor functions. [$id] [$given_id]\");\n      }\n   }\n   if( defined $given_id ) {\n      $self->display_id($given_id);\n      $id = $given_id;\n   }\n   # Import sequence first\n   if (!$seq) {\n      my $id;\n      unless ($self->{supress_warnings} == 1) {\n         $self->warn(\"You did not provide sequence information during the \".\n           \"construction of a Bio::Seq::SeqWithQuality object. Sequence \".\n           \"components for this object will be empty.\");\n      }\n      if (!$alphabet) {\n         $self->throw(\"If you want me to create a PrimarySeq object for your \".\n           \"empty sequence <boggle> you must specify a -alphabet to satisfy \".\n           \"the constructor requirements for a Bio::PrimarySeq object with no \".\n           \"sequence. Read the POD for it, luke.\");\n      }\n      $self->{seq_ref} = Bio::PrimarySeq->new( -seq              =>  \"\",\n                                               -accession_number =>  $acc,\n                                               -primary_id       =>  $pid,\n                                               -desc             =>  $desc,\n                                               -display_id       =>  $id,\n                                               -alphabet         =>  $alphabet );\n   } elsif ($seq->isa('Bio::PrimarySeqI') || $seq->isa('Bio::SeqI')) {\n      $self->{seq_ref} = $seq;\n   } elsif (ref($seq)) {\n      $self->throw(\"You passed a seq argument into a SeqWithQUality object and\".\n        \" it was a reference ($seq) which did not inherit from Bio::SeqI or \".\n        \"Bio::PrimarySeqI. I don't know what to do with this!\");\n   } else {\n      my $seqobj = Bio::PrimarySeq->new( -seq              => $seq,\n                                         -accession_number => $acc,\n                                         -primary_id       => $pid,\n                                         -desc             => $desc,\n                                         -display_id       => $id   );\n      $self->{seq_ref} = $seqobj;\n   }\n   # Then import the quality scores\n   if (!defined($qual)) {\n      $self->{qual_ref} = Bio::Seq::PrimaryQual->new( -qual             => \"\",\n                                                      -accession_number => $acc,\n                                                      -primary_id       => $pid,\n                                                      -desc             => $desc,\n                                                      -display_id       => $id, );\n   } elsif (ref($qual) eq \"Bio::Seq::PrimaryQual\") {\n      $self->{qual_ref} = $qual;\n   } else {\n      my $qualobj = Bio::Seq::PrimaryQual->new( -qual             => $qual,\n                                                -accession_number => $acc,\n                                                -primary_id       => $pid,\n                                                -desc             => $desc,\n                                                -display_id       => $id,\n                                                -trace_indices    => $trace_indices );\n      $self->{qual_ref} = $qualobj;\n   }\n   # Now try to set the descriptors for this object\n   $self->_set_descriptors($qual,$seq,$id,$acc,$pid,$desc,$given_id,$alphabet);\n   $self->length();\n   $self->deprecated(\"deprecated class - use Bio::Seq::Quality instead\");\n\n   return $self;\n}\n\n=head2 _common_id()\n\n Title   : _common_id()\n Usage   : $common_id = $self->_common_id();\n Function: Compare the display_id of {qual_ref} and {seq_ref}.\n Returns : Nothing if they don't match. If they do return {seq_ref}->display_id()\n Args    : None.\n\n\n#'\nsub _common_id {\n   my $self = shift;\n   return if (!$self->{seq_ref} || !$self->{qual_ref});\n   my $sid = $self->{seq_ref}->display_id();\n   return if (!$sid);\n   return if (!$self->{qual_ref}->display_id());\n   return $sid if ($sid eq $self->{qual_ref}->display_id());\n   # should this become a warning?\n   # print(\"ids $sid and $self->{qual_ref}->display_id() do not match. Bummer.\\n\");\n}\n\n=head2 _common_display_id()\n\n Title   : _common_id()\n Usage   : $common_id = $self->_common_display_id();\n Function: Compare the display_id of {qual_ref} and {seq_ref}.\n Returns : Nothing if they don't match. If they do return {seq_ref}->display_id()\n Args    : None.\n\n\n#'\nsub _common_display_id {\n   my $self = shift;\n   $self->common_id();\n}\n\n=head2 _common_accession_number()\n\n Title   : _common_accession_number()\n Usage   : $common_id = $self->_common_accession_number();\n Function: Compare the accession_number() of {qual_ref} and {seq_ref}.\n Returns : Nothing if they don't match. If they do return {seq_ref}->accession_number()\n Args    : None.\n\n\n#'\nsub _common_accession_number {\n   my $self = shift;\n   return if ($self->{seq_ref} || $self->{qual_ref});\n   my $acc = $self->{seq_ref}->accession_number();\n   # if (!$acc) { print(\"the seqref has no acc.\\n\"); }\n   return if (!$acc);\n   # if ($acc eq $self->{qual_ref}->accession_number()) { print(\"$acc matches \".$self->{qual_ref}->accession_number().\"\\n\"); }\n   return $acc if ($acc eq $self->{qual_ref}->accession_number());\n   # should this become a warning?\n   # print(\"accession numbers $acc and $self->{qual_ref}->accession_number() do not match. Bummer.\\n\");\n}\n\n=head2 _common_primary_id()\n\n Title   : _common_primary_id()\n Usage   : $common_primard_id = $self->_common_primary_id();\n Function: Compare the primary_id of {qual_ref} and {seq_ref}.\n Returns : Nothing if they don't match. If they do return {seq_ref}->primary_id()\n Args    : None.\n\n\n#'\nsub _common_primary_id {\n   my $self = shift;\n   return if ($self->{seq_ref} || $self->{qual_ref});\n   my $pid = $self->{seq_ref}->primary_id();\n   return if (!$pid);\n   return $pid if ($pid eq $self->{qual_ref}->primary_id());\n   # should this become a warning?\n   # print(\"primary_ids $pid and $self->{qual_ref}->primary_id() do not match. Bummer.\\n\");\n}\n\n=head2 _common_desc()\n\n Title   : _common_desc()\n Usage   : $common_desc = $self->_common_desc();\n Function: Compare the desc of {qual_ref} and {seq_ref}.\n Returns : Nothing if they don't match. If they do return {seq_ref}->desc()\n Args    : None.\n\n\n#'\nsub _common_desc {\n   my $self = shift;\n   return if ($self->{seq_ref} || $self->{qual_ref});\n   my $des = $self->{seq_ref}->desc();\n   return if (!$des);\n   return $des if ($des eq $self->{qual_ref}->desc());\n   # should this become a warning?\n   # print(\"descriptions $des and $self->{qual_ref}->desc() do not match. Bummer.\\n\");\n}\n\n=head2 set_common_descriptors()\n\n Title   : set_common_descriptors()\n Usage   : $self->set_common_descriptors();\n Function: Compare the descriptors (id,accession_number,display_id,\n           primary_id, desc) for the PrimarySeq and PrimaryQual objects\n           within the SeqWithQuality object. If they match, make that\n           descriptor the descriptor for the SeqWithQuality object.\n Returns : Nothing.\n Args    : None.\n\n\nsub set_common_descriptors {\n   my $self = shift;\n   return if ($self->{seq_ref} || $self->{qual_ref});\n   &_common_id();\n   &_common_display_id();\n   &_common_accession_number();\n   &_common_primary_id();\n   &_common_desc();\n}\n\n=head2 alphabet()\n\n Title   : alphabet();\n Usage   : $molecule_type = $obj->alphabet();\n Function: Get the molecule type from the PrimarySeq object.\n Returns : What what PrimarySeq says the type of the sequence is.\n Args    : None.\n\n\nsub alphabet {\n   my $self = shift;\n   return $self->{seq_ref}->alphabet();\n}\n\n=head2 display_id()\n\n Title   : display_id()\n Usage   : $id_string = $obj->display_id();\n Function: Returns the display id, aka the common name of the Quality object.\n           The semantics of this is that it is the most likely string to be\n           used as an identifier of the quality sequence, and likely to have\n           \"human\" readability.  The id is equivalent to the ID field of the\n           GenBank/EMBL databanks and the id field of the Swissprot/sptrembl\n           database. In fasta format, the >(\\S+) is presumed to be the id,\n           though some people overload the id to embed other information.\n           Bioperl does not use any embedded information in the ID field,\n           and people are encouraged to use other mechanisms (accession\n           field for example, or extending the sequence object) to solve\n           this. Notice that $seq->id() maps to this function, mainly for\n           legacy/convience issues.\n           This method sets the display_id for the SeqWithQuality object.\n Returns : A string\n Args    : If a scalar is provided, it is set as the new display_id for\n           the SeqWithQuality object.\n Status  : Virtual\n\n\nsub display_id {\n   my ($obj,$value) = @_;\n   if( defined $value) {\n      $obj->{'display_id'} = $value;\n    }\n    return $obj->{'display_id'};\n\n}\n\n=head2 accession_number()\n\n Title   : accession_number()\n Usage   : $unique_biological_key = $obj->accession_number();\n Function: Returns the unique biological id for a sequence, commonly\n           called the accession_number. For sequences from established\n           databases, the implementors should try to use the correct\n           accession number. Notice that primary_id() provides the unique id\n           for the implemetation, allowing multiple objects to have the same\n           accession number in a particular implementation. For sequences\n           with no accession number, this method should return \"unknown\".\n           This method sets the accession_number for the SeqWithQuality\n           object. \n Returns : A string (the value of accession_number)\n Args    : If a scalar is provided, it is set as the new accession_number\n           for the SeqWithQuality object.\n Status  : Virtual\n\n\nsub accession_number {\n    my( $obj, $acc ) = @_;\n\n    if (defined $acc) {\n        $obj->{'accession_number'} = $acc;\n    } else {\n        $acc = $obj->{'accession_number'};\n        $acc = 'unknown' unless defined $acc;\n    }\n    return $acc;\n}\n\n=head2 primary_id()\n\n Title   : primary_id()\n Usage   : $unique_implementation_key = $obj->primary_id();\n Function: Returns the unique id for this object in this implementation.\n           This allows implementations to manage their own object ids in a\n           way the implementaiton can control clients can expect one id to\n           map to one object. For sequences with no accession number, this\n           method should return a stringified memory location.\n           This method sets the primary_id for the SeqWithQuality object.\n Returns : A string. (the value of primary_id)\n Args    : If a scalar is provided, it is set as the new primary_id for\n           the SeqWithQuality object.\n\n\nsub primary_id {\n   my ($obj,$value) = @_;\n   if ($value) {\n      $obj->{'primary_id'} = $value;\n    }\n   return $obj->{'primary_id'};\n\n}\n\n=head2 desc()\n\n Title   : desc()\n Usage   : $qual->desc($newval); _or_ \n           $description = $qual->desc();\n Function: Get/set description text for this SeqWithQuality object.\n Returns : A string. (the value of desc)\n Args    : If a scalar is provided, it is set as the new desc for the\n           SeqWithQuality object.\n\n\nsub desc {\n   # a mechanism to set the disc for the SeqWithQuality object.\n   # probably will be used most often by set_common_features()\n   my ($obj,$value) = @_;\n   if( defined $value) {\n      $obj->{'desc'} = $value;\n   }\n   return $obj->{'desc'};\n}\n\n=head2 id()\n\n Title   : id()\n Usage   : $id = $qual->id();\n Function: Return the ID of the quality. This should normally be (and\n           actually is in the implementation provided here) just a synonym\n           for display_id().\n Returns : A string. (the value of id)\n Args    : If a scalar is provided, it is set as the new id for the\n           SeqWithQuality object.\n\n\nsub id {\n   my ($self,$value) = @_;\n   if (!$self) { $self->throw(\"no value for self in $value\"); }\n   if( defined $value ) {\n      return $self->display_id($value);\n   }\n   return $self->display_id();\n}\n\n=head2 seq\n\n Title   : seq()\n Usage   : $string    = $obj->seq(); _or_ $obj->seq(\"atctatcatca\");\n Function: Returns the sequence that is contained in the imbedded in the\n           PrimarySeq object within the SeqWithQuality object\n Returns : A scalar (the seq() value for the imbedded PrimarySeq object.)\n Args    : If a scalar is provided, the SeqWithQuality object will\n           attempt to set that as the sequence for the imbedded PrimarySeq\n           object. Otherwise, the value of seq() for the PrimarySeq object\n           is returned.\n Notes   : This is probably not a good idea because you then should call\n           length() to make sure that the sequence and quality are of the\n           same length. Even then, how can you make sure that this sequence\n           belongs with that quality? I provided this to give you rope to\n           hang yourself with. Tie it to a strong device and use a good\n           knot.\n\n\nsub seq {\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{seq_ref}->seq($value);\n      $self->length();\n   }\n   return $self->{seq_ref}->seq();\n}\n\n=head2 qual()\n\n Title   : qual()\n Usage   : @quality_values  = @{$obj->qual()}; _or_\n           $obj->qual(\"10 10 20 40 50\");\n Function: Returns the quality as imbedded in the PrimaryQual object\n           within the SeqWithQuality object.\n Returns : A reference to an array containing the quality values in the \n           PrimaryQual object.\n Args    : If a scalar is provided, the SeqWithQuality object will\n           attempt to set that as the quality for the imbedded PrimaryQual\n           object. Otherwise, the value of qual() for the PrimaryQual\n           object is returned.\n Notes   : This is probably not a good idea because you then should call\n           length() to make sure that the sequence and quality are of the\n           same length. Even then, how can you make sure that this sequence\n           belongs with that quality? I provided this to give you a strong\n           board with which to flagellate yourself. \n\n\nsub qual {\n   my ($self,$value) = @_;\n\n   if( defined $value) {\n      $self->{qual_ref}->qual($value);\n      # update the lengths\n      $self->length();\n   }\n   return $self->{qual_ref}->qual();\n}\n\n\n\n=head2 trace_indices()\n\n Title   : trace_indices()\n Usage   : @trace_indice_values  = @{$obj->trace_indices()}; _or_\n           $obj->trace_indices(\"10 10 20 40 50\");\n Function: Returns the trace_indices as imbedded in the Primaryqual object\n           within the SeqWithQualiity object.\n Returns : A reference to an array containing the trace_indice values in the \n           PrimaryQual object.\n Args    : If a scalar is provided, the SeqWithuQuality object will\n           attempt to set that as the trace_indices for the imbedded PrimaryQual\n           object. Otherwise, the value of trace_indices() for the PrimaryQual\n           object is returned.\n Notes   : This is probably not a good idea because you then should call\n           length() to make sure that the sequence and trace_indices are of the\n           same length. Even then, how can you make sure that this sequence\n           belongs with that trace_indicex? I provided this to give you a strong\n           board with which to flagellate yourself. \n\n\nsub trace_indices {\n   my ($self,$value) = @_;\n\n   if( defined $value) {\n      $self->{qual_ref}->trace_indices($value);\n      # update the lengths\n      $self->length();\n   }\n   return $self->{qual_ref}->trace_indices();\n}\n\n\n\n\n=head2 length()\n\n Title   : length()\n Usage   : $length = $seqWqual->length();\n Function: Get the length of the SeqWithQuality sequence/quality.\n Returns : Returns the length of the sequence and quality if they are\n           both the same. Returns \"DIFFERENT\" if they differ.\n Args    : None.\n\n\nsub length {\n   my $self = shift;\n   if (!$self->{seq_ref}) {\n      unless ($self->{supress_warnings} == 1) {\n         $self->warn(\"Can't find {seq_ref} here in length().\");\n      }\n      return;\n   }\n   if (!$self->{qual_ref}) {\n      unless ($self->{supress_warnings} == 1) {\n         $self->warn(\"Can't find {qual_ref} here in length().\");\n      }\n      return;\n   }\n   my $seql = $self->{seq_ref}->length();\n\n   if ($seql != $self->{qual_ref}->length()) {\n      unless ($self->{supress_warnings} == 1) {\n         $self->warn(\"Sequence length (\".$seql.\") is different from quality \".\n           \"length (\".$self->{qual_ref}->length().\") in the SeqWithQuality \".\n           \"object. This can only lead to problems later.\");\n      }\n      $self->{'length'} = \"DIFFERENT\";\n   } else {\n      $self->{'length'} = $seql;\n   }\n   return $self->{'length'};\n}\n\n\n=head2 qual_obj\n\n Title   : qual_obj($different_obj)\n Usage   : $qualobj = $seqWqual->qual_obj(); _or_\n           $qualobj = $seqWqual->qual_obj($ref_to_primaryqual_obj);\n Function: Get the PrimaryQual object that is imbedded in the\n           SeqWithQuality object or if a reference to a PrimaryQual object\n           is provided, set this as the PrimaryQual object imbedded in the\n           SeqWithQuality object.\n Returns : A reference to a Bio::Seq::SeqWithQuality object.\n\n\nsub qual_obj {\n   my ($self,$value) = @_;\n   if (defined($value)) {\n      if (ref($value) eq \"Bio::Seq::PrimaryQual\") {\n         $self->{qual_ref} = $value;\n         $self->debug(\"You successfully changed the PrimaryQual object within \".\n           \"a SeqWithQuality object. ID's for the SeqWithQuality object may \".\n           \"now not be what you expect. Use something like \".\n           \"set_common_descriptors() to fix them if you care,\");\n      } else {\n         $self->debug(\"You tried to change the PrimaryQual object within a \".\n           \"SeqWithQuality object but you passed a reference to an object that\".\n           \" was not a Bio::Seq::PrimaryQual object. Thus your change failed. \".\n           \"Sorry.\\n\");\t    \n      }\n   }\n   return $self->{qual_ref};\n}\n\n\n=head2 seq_obj\n\n Title   : seq_obj()\n Usage   : $seqobj = $seqWqual->qual_obj(); _or_\n           $seqobj = $seqWqual->seq_obj($ref_to_primary_seq_obj);\n Function: Get the PrimarySeq object that is imbedded in the\n           SeqWithQuality object or if a reference to a PrimarySeq object is\n           provided, set this as the PrimarySeq object imbedded in the\n           SeqWithQuality object.\n Returns : A reference to a Bio::PrimarySeq object.\n\n\nsub seq_obj {\n   my ($self,$value) = @_;\n   if( defined $value) {\n      if (ref($value) eq \"Bio::PrimarySeq\") {\n         $self->debug(\"You successfully changed the PrimarySeq object within a\".\n           \" SeqWithQuality object. ID's for the SeqWithQuality object may now\".\n           \" not be what you expect. Use something like \".\n           \"set_common_descriptors() to fix them if you care,\");\n      } else {\n         $self->debug(\"You tried to change the PrimarySeq object within a \".\n           \"SeqWithQuality object but you passed a reference to an object that\".\n           \" was not a Bio::PrimarySeq object. Thus your change failed. Sorry.\\n\");\n      }\n   }\n   return $self->{seq_ref};\n}\n\n=head2 _set_descriptors\n\n Title   : _set_descriptors()\n Usage   : $seqWqual->_qual_obj($qual,$seq,$id,$acc,$pid,$desc,$given_id,\n           $alphabet);\n Function: Set the descriptors for the SeqWithQuality object. Try to\n           match the descriptors in the PrimarySeq object and in the\n           PrimaryQual object if descriptors were not provided with\n           construction.\n Returns : Nothing.\n Args    : $qual,$seq,$id,$acc,$pid,$desc,$given_id,$alphabet as found\n           in the new() method.\n Notes   : Really only intended to be called by the new() method. If\n           you want to invoke a similar function try set_common_descriptors().\n\n\n\nsub _set_descriptors {\n   my ($self,$qual,$seq,$id,$acc,$pid,$desc,$given_id,$alphabet) = @_;\n   my ($c_id,$c_acc,$c_pid,$c_desc);\n   if (!$self->display_id()) {\n      if ($c_id = $self->_common_id() ) { $self->display_id($c_id); }\n      else {\n         if ($self->{seq_ref}) {\n            # print(\"Using seq_ref to set id to \".$self->{seq_ref}->display_id().\"\\n\");\n            # ::dumpValue($self->{seq_ref});\n            $self->display_id($self->{seq_ref}->id());\n         } elsif ($self->{qual_ref}) {\n            $self->display_id($self->{qual_ref}->id());\n         }\n      }\n   }\n   if ($acc) { $self->accession_number($acc); }\n   elsif ($c_acc = $self->_common_accession_number() ) { $self->accession_number($c_acc); }\n   if ($pid) { $self->primary_id($pid); }\n   elsif ($c_pid = $self->_common_primary_id() ) { $self->primary_id($c_pid); }\n   if ($desc) { $self->desc($desc); }\n   elsif ($c_desc = $self->_common_desc() ) { $self->desc($c_desc); }\n}\n\n=head2 subseq($start,$end)\n\n Title   : subseq($start,$end)\n Usage   : $subsequence = $obj->subseq($start,$end);\n Function: Returns the subseq from start to end, where the first base\n           is 1 and the number is inclusive, ie 1-2 are the first two\n           bases of the sequence.\n Returns : A string.\n Args    : Two positions.\n\n\nsub subseq {\n    my ($self,@args) = @_;\n    # does a single value work?\n    return $self->{seq_ref}->subseq(@args);\n}\n\n=head2 baseat($position)\n\n Title   : baseat($position)\n Usage   : $base_at_position_6 = $obj->baseat(\"6\");\n Function: Returns a single base at the given position, where the first\n           base is 1 and the number is inclusive, ie 1-2 are the first two\n           bases of the sequence.\n Returns : A scalar.\n Args    : A position.\n\n\nsub baseat {\n    my ($self,$val) = @_;\n    return $self->{seq_ref}->subseq($val,$val);\n}\n\n=head2 subqual($start,$end)\n\n Title   : subqual($start,$end)\n Usage   : @qualities = @{$obj->subqual(10,20);\n Function: returns the quality values from $start to $end, where the\n           first value is 1 and the number is inclusive, ie 1-2 are the\n           first two bases of the sequence. Start cannot be larger than\n           end but can be equal.\n Returns : A reference to an array.\n Args    : a start position and an end position","parameters":[{"label":"$self"},{"label":"@args"}]},"detail":"($self,@args)","definition":"sub","containerName":"main::"},{"kind":12,"line":816,"name":"qual_ref"},{"range":{"start":{"character":0,"line":832},"end":{"character":9999,"line":835}},"name":"qualat","detail":"($self,$val)","signature":{"label":"qualat($self,$val)","documentation":"1;\n# $Id: SeqWithQuality.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Seq::QualI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chad Matsalla <bioinformatics@dieselwurks.com\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::SeqWithQuality - Bioperl object packaging a sequence with its quality.\nDeprecated class, use Bio::Seq::Quality instead!\n\n=head1 SYNOPSIS\n\n    use Bio::PrimarySeq;\n    use Bio::Seq::PrimaryQual;\n    use Bio::Seq::SeqWithQuality;\n\n    # make from memory\n    my $qual = Bio::Seq::SeqWithQuality->new\n    ( -qual => '10 20 30 40 50 50 20 10',\n      -seq => 'ATCGATCG',\n      -id  => 'human_id',\n      -accession_number => 'AL000012',\n    );\n\n    # make from objects\n    # first, make a PrimarySeq object\n    my $seqobj = Bio::PrimarySeq->new\n    ( -seq => 'atcgatcg',\n      -id  => 'GeneFragment-12',\n      -accession_number => 'X78121',\n      -alphabet => 'dna'\n    );\n\n    # now make a PrimaryQual object\n    my $qualobj = Bio::Seq::PrimaryQual->new\n    ( -qual => '10 20 30 40 50 50 20 10',\n      -id  => 'GeneFragment-12',\n      -accession_number => 'X78121',\n      -alphabet => 'dna'\n    );\n\n    # now make the SeqWithQuality object\n    my $swqobj = Bio::Seq::SeqWithQuality->new\n    ( -seq  => $seqobj,\n      -qual => $qualobj\n    );\n    # done!\n\n    $swqobj->id(); # the id of the SeqWithQuality object\n    # may not match the the id of the sequence or\n    # of the quality (check the pod, luke)\n    $swqobj->seq(); # the sequence of the SeqWithQuality object\n    $swqobj->qual(); # the quality of the SeqWithQuality object\n\n    # to get out parts of the sequence.\n\n    print \"Sequence \", $seqobj->id(), \" with accession \",\n    $seqobj->accession, \" and desc \", $seqobj->desc, \"\\n\";\n\n    $string2 = $seqobj->subseq(1,40);\n\n=head1 DESCRIPTION\n\nThis object stores base quality values together with the sequence string.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nEmail bioinformatics@dieselwurks.com\n\n=head1 CONTRIBUTORS \n\nJason Stajich, jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\npackage Bio::Seq::SeqWithQuality;\n\n\nuse strict;\nuse Bio::PrimarySeq;\nuse Bio::Seq::PrimaryQual;\n\nuse base qw(Bio::Root::Root Bio::PrimarySeqI Bio::Seq::QualI);\n\n=head2 new()\n\n Title   : new()\n Usage   : $qual = Bio::Seq::SeqWithQuality ->new\n             ( -qual => '10 20 30 40 50 50 20 10',\n               -seq => 'ATCGATCG',\n               -id  => 'human_id',\n               -accession_number => 'AL000012',\n               -trace_indices    => '0 5 10 15 20 25 30 35'\n             );\n Function: Returns a new Bio::Seq::SeqWithQual object from basic\n           constructors.\n Returns : a new Bio::Seq::PrimaryQual object\n Args    : -qual can be a quality string (see Bio::Seq::PrimaryQual for more\n            information on this) or a reference to a Bio::Seq::PrimaryQual\n            object.\n           -seq can be a sequence string (see Bio::PrimarySeq for more\n            information on this) or a reference to a Bio::PrimaryQual object.\n           -seq, -id, -accession_number, -primary_id, -desc, -id behave like\n            this:\n             1. if they are provided on construction of the\n                 Bio::Seq::SeqWithQuality they will be set as the descriptors for\n                 the object unless changed by one of the following mechanisms:\n              a) $obj->set_common_descriptors() is used and both the -seq and\n                 the -qual object have the same descriptors. These common\n                 descriptors will then become the descriptors for the\n                 Bio::Seq::SeqWithQual object.\n              b) the descriptors are manually set using the seq(), id(),\n                 desc(), or accession_number(), primary_id(),\n             2. if no descriptors are provided, the new() constructor will see\n                if the descriptor used in the PrimarySeq and in the\n                PrimaryQual objects match. If they do, they will become\n                the descriptors for the SeqWithQuality object.\n             To eliminate ambiguity, I strongly suggest you set the\n             descriptors manually on construction of the object. Really.\n           -trace_indices : a space_delimited list of trace indices\n            (where would the peaks be drawn if this list of qualities\n            was to be plotted?)\n\n\nsub new {\n   my ($class, @args) = @_;\n   my $self = $class->SUPER::new(@args);\n   # default: turn OFF the warnings\n   $self->{supress_warnings} = 1;\n   my($qual,$seq,$id,$acc,$pid,$desc,$given_id,$alphabet,$trace_indices) =\n   $self->_rearrange([qw( QUAL SEQ DISPLAY_ID ACCESSION_NUMBER PRIMARY_ID DESC\n     ID ALPHABET TRACE_INDICES )], @args);\n   # Deal with the ID\n   if ( defined $id && defined $given_id ) {\n      if( $id ne $given_id ) {\n         $self->throw(\"Provided both id and display_id constructor functions. [$id] [$given_id]\");\n      }\n   }\n   if( defined $given_id ) {\n      $self->display_id($given_id);\n      $id = $given_id;\n   }\n   # Import sequence first\n   if (!$seq) {\n      my $id;\n      unless ($self->{supress_warnings} == 1) {\n         $self->warn(\"You did not provide sequence information during the \".\n           \"construction of a Bio::Seq::SeqWithQuality object. Sequence \".\n           \"components for this object will be empty.\");\n      }\n      if (!$alphabet) {\n         $self->throw(\"If you want me to create a PrimarySeq object for your \".\n           \"empty sequence <boggle> you must specify a -alphabet to satisfy \".\n           \"the constructor requirements for a Bio::PrimarySeq object with no \".\n           \"sequence. Read the POD for it, luke.\");\n      }\n      $self->{seq_ref} = Bio::PrimarySeq->new( -seq              =>  \"\",\n                                               -accession_number =>  $acc,\n                                               -primary_id       =>  $pid,\n                                               -desc             =>  $desc,\n                                               -display_id       =>  $id,\n                                               -alphabet         =>  $alphabet );\n   } elsif ($seq->isa('Bio::PrimarySeqI') || $seq->isa('Bio::SeqI')) {\n      $self->{seq_ref} = $seq;\n   } elsif (ref($seq)) {\n      $self->throw(\"You passed a seq argument into a SeqWithQUality object and\".\n        \" it was a reference ($seq) which did not inherit from Bio::SeqI or \".\n        \"Bio::PrimarySeqI. I don't know what to do with this!\");\n   } else {\n      my $seqobj = Bio::PrimarySeq->new( -seq              => $seq,\n                                         -accession_number => $acc,\n                                         -primary_id       => $pid,\n                                         -desc             => $desc,\n                                         -display_id       => $id   );\n      $self->{seq_ref} = $seqobj;\n   }\n   # Then import the quality scores\n   if (!defined($qual)) {\n      $self->{qual_ref} = Bio::Seq::PrimaryQual->new( -qual             => \"\",\n                                                      -accession_number => $acc,\n                                                      -primary_id       => $pid,\n                                                      -desc             => $desc,\n                                                      -display_id       => $id, );\n   } elsif (ref($qual) eq \"Bio::Seq::PrimaryQual\") {\n      $self->{qual_ref} = $qual;\n   } else {\n      my $qualobj = Bio::Seq::PrimaryQual->new( -qual             => $qual,\n                                                -accession_number => $acc,\n                                                -primary_id       => $pid,\n                                                -desc             => $desc,\n                                                -display_id       => $id,\n                                                -trace_indices    => $trace_indices );\n      $self->{qual_ref} = $qualobj;\n   }\n   # Now try to set the descriptors for this object\n   $self->_set_descriptors($qual,$seq,$id,$acc,$pid,$desc,$given_id,$alphabet);\n   $self->length();\n   $self->deprecated(\"deprecated class - use Bio::Seq::Quality instead\");\n\n   return $self;\n}\n\n=head2 _common_id()\n\n Title   : _common_id()\n Usage   : $common_id = $self->_common_id();\n Function: Compare the display_id of {qual_ref} and {seq_ref}.\n Returns : Nothing if they don't match. If they do return {seq_ref}->display_id()\n Args    : None.\n\n\n#'\nsub _common_id {\n   my $self = shift;\n   return if (!$self->{seq_ref} || !$self->{qual_ref});\n   my $sid = $self->{seq_ref}->display_id();\n   return if (!$sid);\n   return if (!$self->{qual_ref}->display_id());\n   return $sid if ($sid eq $self->{qual_ref}->display_id());\n   # should this become a warning?\n   # print(\"ids $sid and $self->{qual_ref}->display_id() do not match. Bummer.\\n\");\n}\n\n=head2 _common_display_id()\n\n Title   : _common_id()\n Usage   : $common_id = $self->_common_display_id();\n Function: Compare the display_id of {qual_ref} and {seq_ref}.\n Returns : Nothing if they don't match. If they do return {seq_ref}->display_id()\n Args    : None.\n\n\n#'\nsub _common_display_id {\n   my $self = shift;\n   $self->common_id();\n}\n\n=head2 _common_accession_number()\n\n Title   : _common_accession_number()\n Usage   : $common_id = $self->_common_accession_number();\n Function: Compare the accession_number() of {qual_ref} and {seq_ref}.\n Returns : Nothing if they don't match. If they do return {seq_ref}->accession_number()\n Args    : None.\n\n\n#'\nsub _common_accession_number {\n   my $self = shift;\n   return if ($self->{seq_ref} || $self->{qual_ref});\n   my $acc = $self->{seq_ref}->accession_number();\n   # if (!$acc) { print(\"the seqref has no acc.\\n\"); }\n   return if (!$acc);\n   # if ($acc eq $self->{qual_ref}->accession_number()) { print(\"$acc matches \".$self->{qual_ref}->accession_number().\"\\n\"); }\n   return $acc if ($acc eq $self->{qual_ref}->accession_number());\n   # should this become a warning?\n   # print(\"accession numbers $acc and $self->{qual_ref}->accession_number() do not match. Bummer.\\n\");\n}\n\n=head2 _common_primary_id()\n\n Title   : _common_primary_id()\n Usage   : $common_primard_id = $self->_common_primary_id();\n Function: Compare the primary_id of {qual_ref} and {seq_ref}.\n Returns : Nothing if they don't match. If they do return {seq_ref}->primary_id()\n Args    : None.\n\n\n#'\nsub _common_primary_id {\n   my $self = shift;\n   return if ($self->{seq_ref} || $self->{qual_ref});\n   my $pid = $self->{seq_ref}->primary_id();\n   return if (!$pid);\n   return $pid if ($pid eq $self->{qual_ref}->primary_id());\n   # should this become a warning?\n   # print(\"primary_ids $pid and $self->{qual_ref}->primary_id() do not match. Bummer.\\n\");\n}\n\n=head2 _common_desc()\n\n Title   : _common_desc()\n Usage   : $common_desc = $self->_common_desc();\n Function: Compare the desc of {qual_ref} and {seq_ref}.\n Returns : Nothing if they don't match. If they do return {seq_ref}->desc()\n Args    : None.\n\n\n#'\nsub _common_desc {\n   my $self = shift;\n   return if ($self->{seq_ref} || $self->{qual_ref});\n   my $des = $self->{seq_ref}->desc();\n   return if (!$des);\n   return $des if ($des eq $self->{qual_ref}->desc());\n   # should this become a warning?\n   # print(\"descriptions $des and $self->{qual_ref}->desc() do not match. Bummer.\\n\");\n}\n\n=head2 set_common_descriptors()\n\n Title   : set_common_descriptors()\n Usage   : $self->set_common_descriptors();\n Function: Compare the descriptors (id,accession_number,display_id,\n           primary_id, desc) for the PrimarySeq and PrimaryQual objects\n           within the SeqWithQuality object. If they match, make that\n           descriptor the descriptor for the SeqWithQuality object.\n Returns : Nothing.\n Args    : None.\n\n\nsub set_common_descriptors {\n   my $self = shift;\n   return if ($self->{seq_ref} || $self->{qual_ref});\n   &_common_id();\n   &_common_display_id();\n   &_common_accession_number();\n   &_common_primary_id();\n   &_common_desc();\n}\n\n=head2 alphabet()\n\n Title   : alphabet();\n Usage   : $molecule_type = $obj->alphabet();\n Function: Get the molecule type from the PrimarySeq object.\n Returns : What what PrimarySeq says the type of the sequence is.\n Args    : None.\n\n\nsub alphabet {\n   my $self = shift;\n   return $self->{seq_ref}->alphabet();\n}\n\n=head2 display_id()\n\n Title   : display_id()\n Usage   : $id_string = $obj->display_id();\n Function: Returns the display id, aka the common name of the Quality object.\n           The semantics of this is that it is the most likely string to be\n           used as an identifier of the quality sequence, and likely to have\n           \"human\" readability.  The id is equivalent to the ID field of the\n           GenBank/EMBL databanks and the id field of the Swissprot/sptrembl\n           database. In fasta format, the >(\\S+) is presumed to be the id,\n           though some people overload the id to embed other information.\n           Bioperl does not use any embedded information in the ID field,\n           and people are encouraged to use other mechanisms (accession\n           field for example, or extending the sequence object) to solve\n           this. Notice that $seq->id() maps to this function, mainly for\n           legacy/convience issues.\n           This method sets the display_id for the SeqWithQuality object.\n Returns : A string\n Args    : If a scalar is provided, it is set as the new display_id for\n           the SeqWithQuality object.\n Status  : Virtual\n\n\nsub display_id {\n   my ($obj,$value) = @_;\n   if( defined $value) {\n      $obj->{'display_id'} = $value;\n    }\n    return $obj->{'display_id'};\n\n}\n\n=head2 accession_number()\n\n Title   : accession_number()\n Usage   : $unique_biological_key = $obj->accession_number();\n Function: Returns the unique biological id for a sequence, commonly\n           called the accession_number. For sequences from established\n           databases, the implementors should try to use the correct\n           accession number. Notice that primary_id() provides the unique id\n           for the implemetation, allowing multiple objects to have the same\n           accession number in a particular implementation. For sequences\n           with no accession number, this method should return \"unknown\".\n           This method sets the accession_number for the SeqWithQuality\n           object. \n Returns : A string (the value of accession_number)\n Args    : If a scalar is provided, it is set as the new accession_number\n           for the SeqWithQuality object.\n Status  : Virtual\n\n\nsub accession_number {\n    my( $obj, $acc ) = @_;\n\n    if (defined $acc) {\n        $obj->{'accession_number'} = $acc;\n    } else {\n        $acc = $obj->{'accession_number'};\n        $acc = 'unknown' unless defined $acc;\n    }\n    return $acc;\n}\n\n=head2 primary_id()\n\n Title   : primary_id()\n Usage   : $unique_implementation_key = $obj->primary_id();\n Function: Returns the unique id for this object in this implementation.\n           This allows implementations to manage their own object ids in a\n           way the implementaiton can control clients can expect one id to\n           map to one object. For sequences with no accession number, this\n           method should return a stringified memory location.\n           This method sets the primary_id for the SeqWithQuality object.\n Returns : A string. (the value of primary_id)\n Args    : If a scalar is provided, it is set as the new primary_id for\n           the SeqWithQuality object.\n\n\nsub primary_id {\n   my ($obj,$value) = @_;\n   if ($value) {\n      $obj->{'primary_id'} = $value;\n    }\n   return $obj->{'primary_id'};\n\n}\n\n=head2 desc()\n\n Title   : desc()\n Usage   : $qual->desc($newval); _or_ \n           $description = $qual->desc();\n Function: Get/set description text for this SeqWithQuality object.\n Returns : A string. (the value of desc)\n Args    : If a scalar is provided, it is set as the new desc for the\n           SeqWithQuality object.\n\n\nsub desc {\n   # a mechanism to set the disc for the SeqWithQuality object.\n   # probably will be used most often by set_common_features()\n   my ($obj,$value) = @_;\n   if( defined $value) {\n      $obj->{'desc'} = $value;\n   }\n   return $obj->{'desc'};\n}\n\n=head2 id()\n\n Title   : id()\n Usage   : $id = $qual->id();\n Function: Return the ID of the quality. This should normally be (and\n           actually is in the implementation provided here) just a synonym\n           for display_id().\n Returns : A string. (the value of id)\n Args    : If a scalar is provided, it is set as the new id for the\n           SeqWithQuality object.\n\n\nsub id {\n   my ($self,$value) = @_;\n   if (!$self) { $self->throw(\"no value for self in $value\"); }\n   if( defined $value ) {\n      return $self->display_id($value);\n   }\n   return $self->display_id();\n}\n\n=head2 seq\n\n Title   : seq()\n Usage   : $string    = $obj->seq(); _or_ $obj->seq(\"atctatcatca\");\n Function: Returns the sequence that is contained in the imbedded in the\n           PrimarySeq object within the SeqWithQuality object\n Returns : A scalar (the seq() value for the imbedded PrimarySeq object.)\n Args    : If a scalar is provided, the SeqWithQuality object will\n           attempt to set that as the sequence for the imbedded PrimarySeq\n           object. Otherwise, the value of seq() for the PrimarySeq object\n           is returned.\n Notes   : This is probably not a good idea because you then should call\n           length() to make sure that the sequence and quality are of the\n           same length. Even then, how can you make sure that this sequence\n           belongs with that quality? I provided this to give you rope to\n           hang yourself with. Tie it to a strong device and use a good\n           knot.\n\n\nsub seq {\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{seq_ref}->seq($value);\n      $self->length();\n   }\n   return $self->{seq_ref}->seq();\n}\n\n=head2 qual()\n\n Title   : qual()\n Usage   : @quality_values  = @{$obj->qual()}; _or_\n           $obj->qual(\"10 10 20 40 50\");\n Function: Returns the quality as imbedded in the PrimaryQual object\n           within the SeqWithQuality object.\n Returns : A reference to an array containing the quality values in the \n           PrimaryQual object.\n Args    : If a scalar is provided, the SeqWithQuality object will\n           attempt to set that as the quality for the imbedded PrimaryQual\n           object. Otherwise, the value of qual() for the PrimaryQual\n           object is returned.\n Notes   : This is probably not a good idea because you then should call\n           length() to make sure that the sequence and quality are of the\n           same length. Even then, how can you make sure that this sequence\n           belongs with that quality? I provided this to give you a strong\n           board with which to flagellate yourself. \n\n\nsub qual {\n   my ($self,$value) = @_;\n\n   if( defined $value) {\n      $self->{qual_ref}->qual($value);\n      # update the lengths\n      $self->length();\n   }\n   return $self->{qual_ref}->qual();\n}\n\n\n\n=head2 trace_indices()\n\n Title   : trace_indices()\n Usage   : @trace_indice_values  = @{$obj->trace_indices()}; _or_\n           $obj->trace_indices(\"10 10 20 40 50\");\n Function: Returns the trace_indices as imbedded in the Primaryqual object\n           within the SeqWithQualiity object.\n Returns : A reference to an array containing the trace_indice values in the \n           PrimaryQual object.\n Args    : If a scalar is provided, the SeqWithuQuality object will\n           attempt to set that as the trace_indices for the imbedded PrimaryQual\n           object. Otherwise, the value of trace_indices() for the PrimaryQual\n           object is returned.\n Notes   : This is probably not a good idea because you then should call\n           length() to make sure that the sequence and trace_indices are of the\n           same length. Even then, how can you make sure that this sequence\n           belongs with that trace_indicex? I provided this to give you a strong\n           board with which to flagellate yourself. \n\n\nsub trace_indices {\n   my ($self,$value) = @_;\n\n   if( defined $value) {\n      $self->{qual_ref}->trace_indices($value);\n      # update the lengths\n      $self->length();\n   }\n   return $self->{qual_ref}->trace_indices();\n}\n\n\n\n\n=head2 length()\n\n Title   : length()\n Usage   : $length = $seqWqual->length();\n Function: Get the length of the SeqWithQuality sequence/quality.\n Returns : Returns the length of the sequence and quality if they are\n           both the same. Returns \"DIFFERENT\" if they differ.\n Args    : None.\n\n\nsub length {\n   my $self = shift;\n   if (!$self->{seq_ref}) {\n      unless ($self->{supress_warnings} == 1) {\n         $self->warn(\"Can't find {seq_ref} here in length().\");\n      }\n      return;\n   }\n   if (!$self->{qual_ref}) {\n      unless ($self->{supress_warnings} == 1) {\n         $self->warn(\"Can't find {qual_ref} here in length().\");\n      }\n      return;\n   }\n   my $seql = $self->{seq_ref}->length();\n\n   if ($seql != $self->{qual_ref}->length()) {\n      unless ($self->{supress_warnings} == 1) {\n         $self->warn(\"Sequence length (\".$seql.\") is different from quality \".\n           \"length (\".$self->{qual_ref}->length().\") in the SeqWithQuality \".\n           \"object. This can only lead to problems later.\");\n      }\n      $self->{'length'} = \"DIFFERENT\";\n   } else {\n      $self->{'length'} = $seql;\n   }\n   return $self->{'length'};\n}\n\n\n=head2 qual_obj\n\n Title   : qual_obj($different_obj)\n Usage   : $qualobj = $seqWqual->qual_obj(); _or_\n           $qualobj = $seqWqual->qual_obj($ref_to_primaryqual_obj);\n Function: Get the PrimaryQual object that is imbedded in the\n           SeqWithQuality object or if a reference to a PrimaryQual object\n           is provided, set this as the PrimaryQual object imbedded in the\n           SeqWithQuality object.\n Returns : A reference to a Bio::Seq::SeqWithQuality object.\n\n\nsub qual_obj {\n   my ($self,$value) = @_;\n   if (defined($value)) {\n      if (ref($value) eq \"Bio::Seq::PrimaryQual\") {\n         $self->{qual_ref} = $value;\n         $self->debug(\"You successfully changed the PrimaryQual object within \".\n           \"a SeqWithQuality object. ID's for the SeqWithQuality object may \".\n           \"now not be what you expect. Use something like \".\n           \"set_common_descriptors() to fix them if you care,\");\n      } else {\n         $self->debug(\"You tried to change the PrimaryQual object within a \".\n           \"SeqWithQuality object but you passed a reference to an object that\".\n           \" was not a Bio::Seq::PrimaryQual object. Thus your change failed. \".\n           \"Sorry.\\n\");\t    \n      }\n   }\n   return $self->{qual_ref};\n}\n\n\n=head2 seq_obj\n\n Title   : seq_obj()\n Usage   : $seqobj = $seqWqual->qual_obj(); _or_\n           $seqobj = $seqWqual->seq_obj($ref_to_primary_seq_obj);\n Function: Get the PrimarySeq object that is imbedded in the\n           SeqWithQuality object or if a reference to a PrimarySeq object is\n           provided, set this as the PrimarySeq object imbedded in the\n           SeqWithQuality object.\n Returns : A reference to a Bio::PrimarySeq object.\n\n\nsub seq_obj {\n   my ($self,$value) = @_;\n   if( defined $value) {\n      if (ref($value) eq \"Bio::PrimarySeq\") {\n         $self->debug(\"You successfully changed the PrimarySeq object within a\".\n           \" SeqWithQuality object. ID's for the SeqWithQuality object may now\".\n           \" not be what you expect. Use something like \".\n           \"set_common_descriptors() to fix them if you care,\");\n      } else {\n         $self->debug(\"You tried to change the PrimarySeq object within a \".\n           \"SeqWithQuality object but you passed a reference to an object that\".\n           \" was not a Bio::PrimarySeq object. Thus your change failed. Sorry.\\n\");\n      }\n   }\n   return $self->{seq_ref};\n}\n\n=head2 _set_descriptors\n\n Title   : _set_descriptors()\n Usage   : $seqWqual->_qual_obj($qual,$seq,$id,$acc,$pid,$desc,$given_id,\n           $alphabet);\n Function: Set the descriptors for the SeqWithQuality object. Try to\n           match the descriptors in the PrimarySeq object and in the\n           PrimaryQual object if descriptors were not provided with\n           construction.\n Returns : Nothing.\n Args    : $qual,$seq,$id,$acc,$pid,$desc,$given_id,$alphabet as found\n           in the new() method.\n Notes   : Really only intended to be called by the new() method. If\n           you want to invoke a similar function try set_common_descriptors().\n\n\n\nsub _set_descriptors {\n   my ($self,$qual,$seq,$id,$acc,$pid,$desc,$given_id,$alphabet) = @_;\n   my ($c_id,$c_acc,$c_pid,$c_desc);\n   if (!$self->display_id()) {\n      if ($c_id = $self->_common_id() ) { $self->display_id($c_id); }\n      else {\n         if ($self->{seq_ref}) {\n            # print(\"Using seq_ref to set id to \".$self->{seq_ref}->display_id().\"\\n\");\n            # ::dumpValue($self->{seq_ref});\n            $self->display_id($self->{seq_ref}->id());\n         } elsif ($self->{qual_ref}) {\n            $self->display_id($self->{qual_ref}->id());\n         }\n      }\n   }\n   if ($acc) { $self->accession_number($acc); }\n   elsif ($c_acc = $self->_common_accession_number() ) { $self->accession_number($c_acc); }\n   if ($pid) { $self->primary_id($pid); }\n   elsif ($c_pid = $self->_common_primary_id() ) { $self->primary_id($c_pid); }\n   if ($desc) { $self->desc($desc); }\n   elsif ($c_desc = $self->_common_desc() ) { $self->desc($c_desc); }\n}\n\n=head2 subseq($start,$end)\n\n Title   : subseq($start,$end)\n Usage   : $subsequence = $obj->subseq($start,$end);\n Function: Returns the subseq from start to end, where the first base\n           is 1 and the number is inclusive, ie 1-2 are the first two\n           bases of the sequence.\n Returns : A string.\n Args    : Two positions.\n\n\nsub subseq {\n    my ($self,@args) = @_;\n    # does a single value work?\n    return $self->{seq_ref}->subseq(@args);\n}\n\n=head2 baseat($position)\n\n Title   : baseat($position)\n Usage   : $base_at_position_6 = $obj->baseat(\"6\");\n Function: Returns a single base at the given position, where the first\n           base is 1 and the number is inclusive, ie 1-2 are the first two\n           bases of the sequence.\n Returns : A scalar.\n Args    : A position.\n\n\nsub baseat {\n    my ($self,$val) = @_;\n    return $self->{seq_ref}->subseq($val,$val);\n}\n\n=head2 subqual($start,$end)\n\n Title   : subqual($start,$end)\n Usage   : @qualities = @{$obj->subqual(10,20);\n Function: returns the quality values from $start to $end, where the\n           first value is 1 and the number is inclusive, ie 1-2 are the\n           first two bases of the sequence. Start cannot be larger than\n           end but can be equal.\n Returns : A reference to an array.\n Args    : a start position and an end position\n\n\nsub subqual {\n    my ($self,@args) = @_;\n    return $self->{qual_ref}->subqual(@args);\n}\n\n=head2 qualat($position)\n\n Title   : qualat($position)\n Usage   : $quality = $obj->qualat(10);\n Function: Return the quality value at the given location, where the\n           first value is 1 and the number is inclusive, ie 1-2 are the\n           first two bases of the sequence. Start cannot be larger than\n           end but can be equal.\n Returns : A scalar.\n Args    : A position.","parameters":[{"label":"$self"},{"label":"$val"}]},"containerName":"main::","definition":"sub","line":832,"children":[{"kind":13,"line":833,"containerName":"qualat","name":"$self","definition":"my","localvar":"my"},{"containerName":"qualat","name":"$val","kind":13,"line":833},{"line":834,"kind":13,"containerName":"qualat","name":"$self"},{"kind":12,"line":834,"name":"qualat","containerName":"qualat"},{"line":834,"kind":13,"containerName":"qualat","name":"$val"}],"kind":12},{"name":"qual_ref","kind":12,"line":834},{"range":{"end":{"line":853,"character":9999},"start":{"line":850,"character":0}},"name":"sub_trace_index","line":850,"children":[{"kind":13,"line":851,"containerName":"sub_trace_index","name":"$self","definition":"my","localvar":"my"},{"name":"@args","containerName":"sub_trace_index","kind":13,"line":851},{"name":"$self","containerName":"sub_trace_index","line":852,"kind":13},{"containerName":"sub_trace_index","name":"sub_trace_index","line":852,"kind":12},{"kind":13,"line":852,"containerName":"sub_trace_index","name":"@args"}],"kind":12,"detail":"($self,@args)","signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: SeqWithQuality.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Seq::QualI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chad Matsalla <bioinformatics@dieselwurks.com\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::SeqWithQuality - Bioperl object packaging a sequence with its quality.\nDeprecated class, use Bio::Seq::Quality instead!\n\n=head1 SYNOPSIS\n\n    use Bio::PrimarySeq;\n    use Bio::Seq::PrimaryQual;\n    use Bio::Seq::SeqWithQuality;\n\n    # make from memory\n    my $qual = Bio::Seq::SeqWithQuality->new\n    ( -qual => '10 20 30 40 50 50 20 10',\n      -seq => 'ATCGATCG',\n      -id  => 'human_id',\n      -accession_number => 'AL000012',\n    );\n\n    # make from objects\n    # first, make a PrimarySeq object\n    my $seqobj = Bio::PrimarySeq->new\n    ( -seq => 'atcgatcg',\n      -id  => 'GeneFragment-12',\n      -accession_number => 'X78121',\n      -alphabet => 'dna'\n    );\n\n    # now make a PrimaryQual object\n    my $qualobj = Bio::Seq::PrimaryQual->new\n    ( -qual => '10 20 30 40 50 50 20 10',\n      -id  => 'GeneFragment-12',\n      -accession_number => 'X78121',\n      -alphabet => 'dna'\n    );\n\n    # now make the SeqWithQuality object\n    my $swqobj = Bio::Seq::SeqWithQuality->new\n    ( -seq  => $seqobj,\n      -qual => $qualobj\n    );\n    # done!\n\n    $swqobj->id(); # the id of the SeqWithQuality object\n    # may not match the the id of the sequence or\n    # of the quality (check the pod, luke)\n    $swqobj->seq(); # the sequence of the SeqWithQuality object\n    $swqobj->qual(); # the quality of the SeqWithQuality object\n\n    # to get out parts of the sequence.\n\n    print \"Sequence \", $seqobj->id(), \" with accession \",\n    $seqobj->accession, \" and desc \", $seqobj->desc, \"\\n\";\n\n    $string2 = $seqobj->subseq(1,40);\n\n=head1 DESCRIPTION\n\nThis object stores base quality values together with the sequence string.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nEmail bioinformatics@dieselwurks.com\n\n=head1 CONTRIBUTORS \n\nJason Stajich, jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\npackage Bio::Seq::SeqWithQuality;\n\n\nuse strict;\nuse Bio::PrimarySeq;\nuse Bio::Seq::PrimaryQual;\n\nuse base qw(Bio::Root::Root Bio::PrimarySeqI Bio::Seq::QualI);\n\n=head2 new()\n\n Title   : new()\n Usage   : $qual = Bio::Seq::SeqWithQuality ->new\n             ( -qual => '10 20 30 40 50 50 20 10',\n               -seq => 'ATCGATCG',\n               -id  => 'human_id',\n               -accession_number => 'AL000012',\n               -trace_indices    => '0 5 10 15 20 25 30 35'\n             );\n Function: Returns a new Bio::Seq::SeqWithQual object from basic\n           constructors.\n Returns : a new Bio::Seq::PrimaryQual object\n Args    : -qual can be a quality string (see Bio::Seq::PrimaryQual for more\n            information on this) or a reference to a Bio::Seq::PrimaryQual\n            object.\n           -seq can be a sequence string (see Bio::PrimarySeq for more\n            information on this) or a reference to a Bio::PrimaryQual object.\n           -seq, -id, -accession_number, -primary_id, -desc, -id behave like\n            this:\n             1. if they are provided on construction of the\n                 Bio::Seq::SeqWithQuality they will be set as the descriptors for\n                 the object unless changed by one of the following mechanisms:\n              a) $obj->set_common_descriptors() is used and both the -seq and\n                 the -qual object have the same descriptors. These common\n                 descriptors will then become the descriptors for the\n                 Bio::Seq::SeqWithQual object.\n              b) the descriptors are manually set using the seq(), id(),\n                 desc(), or accession_number(), primary_id(),\n             2. if no descriptors are provided, the new() constructor will see\n                if the descriptor used in the PrimarySeq and in the\n                PrimaryQual objects match. If they do, they will become\n                the descriptors for the SeqWithQuality object.\n             To eliminate ambiguity, I strongly suggest you set the\n             descriptors manually on construction of the object. Really.\n           -trace_indices : a space_delimited list of trace indices\n            (where would the peaks be drawn if this list of qualities\n            was to be plotted?)\n\n\nsub new {\n   my ($class, @args) = @_;\n   my $self = $class->SUPER::new(@args);\n   # default: turn OFF the warnings\n   $self->{supress_warnings} = 1;\n   my($qual,$seq,$id,$acc,$pid,$desc,$given_id,$alphabet,$trace_indices) =\n   $self->_rearrange([qw( QUAL SEQ DISPLAY_ID ACCESSION_NUMBER PRIMARY_ID DESC\n     ID ALPHABET TRACE_INDICES )], @args);\n   # Deal with the ID\n   if ( defined $id && defined $given_id ) {\n      if( $id ne $given_id ) {\n         $self->throw(\"Provided both id and display_id constructor functions. [$id] [$given_id]\");\n      }\n   }\n   if( defined $given_id ) {\n      $self->display_id($given_id);\n      $id = $given_id;\n   }\n   # Import sequence first\n   if (!$seq) {\n      my $id;\n      unless ($self->{supress_warnings} == 1) {\n         $self->warn(\"You did not provide sequence information during the \".\n           \"construction of a Bio::Seq::SeqWithQuality object. Sequence \".\n           \"components for this object will be empty.\");\n      }\n      if (!$alphabet) {\n         $self->throw(\"If you want me to create a PrimarySeq object for your \".\n           \"empty sequence <boggle> you must specify a -alphabet to satisfy \".\n           \"the constructor requirements for a Bio::PrimarySeq object with no \".\n           \"sequence. Read the POD for it, luke.\");\n      }\n      $self->{seq_ref} = Bio::PrimarySeq->new( -seq              =>  \"\",\n                                               -accession_number =>  $acc,\n                                               -primary_id       =>  $pid,\n                                               -desc             =>  $desc,\n                                               -display_id       =>  $id,\n                                               -alphabet         =>  $alphabet );\n   } elsif ($seq->isa('Bio::PrimarySeqI') || $seq->isa('Bio::SeqI')) {\n      $self->{seq_ref} = $seq;\n   } elsif (ref($seq)) {\n      $self->throw(\"You passed a seq argument into a SeqWithQUality object and\".\n        \" it was a reference ($seq) which did not inherit from Bio::SeqI or \".\n        \"Bio::PrimarySeqI. I don't know what to do with this!\");\n   } else {\n      my $seqobj = Bio::PrimarySeq->new( -seq              => $seq,\n                                         -accession_number => $acc,\n                                         -primary_id       => $pid,\n                                         -desc             => $desc,\n                                         -display_id       => $id   );\n      $self->{seq_ref} = $seqobj;\n   }\n   # Then import the quality scores\n   if (!defined($qual)) {\n      $self->{qual_ref} = Bio::Seq::PrimaryQual->new( -qual             => \"\",\n                                                      -accession_number => $acc,\n                                                      -primary_id       => $pid,\n                                                      -desc             => $desc,\n                                                      -display_id       => $id, );\n   } elsif (ref($qual) eq \"Bio::Seq::PrimaryQual\") {\n      $self->{qual_ref} = $qual;\n   } else {\n      my $qualobj = Bio::Seq::PrimaryQual->new( -qual             => $qual,\n                                                -accession_number => $acc,\n                                                -primary_id       => $pid,\n                                                -desc             => $desc,\n                                                -display_id       => $id,\n                                                -trace_indices    => $trace_indices );\n      $self->{qual_ref} = $qualobj;\n   }\n   # Now try to set the descriptors for this object\n   $self->_set_descriptors($qual,$seq,$id,$acc,$pid,$desc,$given_id,$alphabet);\n   $self->length();\n   $self->deprecated(\"deprecated class - use Bio::Seq::Quality instead\");\n\n   return $self;\n}\n\n=head2 _common_id()\n\n Title   : _common_id()\n Usage   : $common_id = $self->_common_id();\n Function: Compare the display_id of {qual_ref} and {seq_ref}.\n Returns : Nothing if they don't match. If they do return {seq_ref}->display_id()\n Args    : None.\n\n\n#'\nsub _common_id {\n   my $self = shift;\n   return if (!$self->{seq_ref} || !$self->{qual_ref});\n   my $sid = $self->{seq_ref}->display_id();\n   return if (!$sid);\n   return if (!$self->{qual_ref}->display_id());\n   return $sid if ($sid eq $self->{qual_ref}->display_id());\n   # should this become a warning?\n   # print(\"ids $sid and $self->{qual_ref}->display_id() do not match. Bummer.\\n\");\n}\n\n=head2 _common_display_id()\n\n Title   : _common_id()\n Usage   : $common_id = $self->_common_display_id();\n Function: Compare the display_id of {qual_ref} and {seq_ref}.\n Returns : Nothing if they don't match. If they do return {seq_ref}->display_id()\n Args    : None.\n\n\n#'\nsub _common_display_id {\n   my $self = shift;\n   $self->common_id();\n}\n\n=head2 _common_accession_number()\n\n Title   : _common_accession_number()\n Usage   : $common_id = $self->_common_accession_number();\n Function: Compare the accession_number() of {qual_ref} and {seq_ref}.\n Returns : Nothing if they don't match. If they do return {seq_ref}->accession_number()\n Args    : None.\n\n\n#'\nsub _common_accession_number {\n   my $self = shift;\n   return if ($self->{seq_ref} || $self->{qual_ref});\n   my $acc = $self->{seq_ref}->accession_number();\n   # if (!$acc) { print(\"the seqref has no acc.\\n\"); }\n   return if (!$acc);\n   # if ($acc eq $self->{qual_ref}->accession_number()) { print(\"$acc matches \".$self->{qual_ref}->accession_number().\"\\n\"); }\n   return $acc if ($acc eq $self->{qual_ref}->accession_number());\n   # should this become a warning?\n   # print(\"accession numbers $acc and $self->{qual_ref}->accession_number() do not match. Bummer.\\n\");\n}\n\n=head2 _common_primary_id()\n\n Title   : _common_primary_id()\n Usage   : $common_primard_id = $self->_common_primary_id();\n Function: Compare the primary_id of {qual_ref} and {seq_ref}.\n Returns : Nothing if they don't match. If they do return {seq_ref}->primary_id()\n Args    : None.\n\n\n#'\nsub _common_primary_id {\n   my $self = shift;\n   return if ($self->{seq_ref} || $self->{qual_ref});\n   my $pid = $self->{seq_ref}->primary_id();\n   return if (!$pid);\n   return $pid if ($pid eq $self->{qual_ref}->primary_id());\n   # should this become a warning?\n   # print(\"primary_ids $pid and $self->{qual_ref}->primary_id() do not match. Bummer.\\n\");\n}\n\n=head2 _common_desc()\n\n Title   : _common_desc()\n Usage   : $common_desc = $self->_common_desc();\n Function: Compare the desc of {qual_ref} and {seq_ref}.\n Returns : Nothing if they don't match. If they do return {seq_ref}->desc()\n Args    : None.\n\n\n#'\nsub _common_desc {\n   my $self = shift;\n   return if ($self->{seq_ref} || $self->{qual_ref});\n   my $des = $self->{seq_ref}->desc();\n   return if (!$des);\n   return $des if ($des eq $self->{qual_ref}->desc());\n   # should this become a warning?\n   # print(\"descriptions $des and $self->{qual_ref}->desc() do not match. Bummer.\\n\");\n}\n\n=head2 set_common_descriptors()\n\n Title   : set_common_descriptors()\n Usage   : $self->set_common_descriptors();\n Function: Compare the descriptors (id,accession_number,display_id,\n           primary_id, desc) for the PrimarySeq and PrimaryQual objects\n           within the SeqWithQuality object. If they match, make that\n           descriptor the descriptor for the SeqWithQuality object.\n Returns : Nothing.\n Args    : None.\n\n\nsub set_common_descriptors {\n   my $self = shift;\n   return if ($self->{seq_ref} || $self->{qual_ref});\n   &_common_id();\n   &_common_display_id();\n   &_common_accession_number();\n   &_common_primary_id();\n   &_common_desc();\n}\n\n=head2 alphabet()\n\n Title   : alphabet();\n Usage   : $molecule_type = $obj->alphabet();\n Function: Get the molecule type from the PrimarySeq object.\n Returns : What what PrimarySeq says the type of the sequence is.\n Args    : None.\n\n\nsub alphabet {\n   my $self = shift;\n   return $self->{seq_ref}->alphabet();\n}\n\n=head2 display_id()\n\n Title   : display_id()\n Usage   : $id_string = $obj->display_id();\n Function: Returns the display id, aka the common name of the Quality object.\n           The semantics of this is that it is the most likely string to be\n           used as an identifier of the quality sequence, and likely to have\n           \"human\" readability.  The id is equivalent to the ID field of the\n           GenBank/EMBL databanks and the id field of the Swissprot/sptrembl\n           database. In fasta format, the >(\\S+) is presumed to be the id,\n           though some people overload the id to embed other information.\n           Bioperl does not use any embedded information in the ID field,\n           and people are encouraged to use other mechanisms (accession\n           field for example, or extending the sequence object) to solve\n           this. Notice that $seq->id() maps to this function, mainly for\n           legacy/convience issues.\n           This method sets the display_id for the SeqWithQuality object.\n Returns : A string\n Args    : If a scalar is provided, it is set as the new display_id for\n           the SeqWithQuality object.\n Status  : Virtual\n\n\nsub display_id {\n   my ($obj,$value) = @_;\n   if( defined $value) {\n      $obj->{'display_id'} = $value;\n    }\n    return $obj->{'display_id'};\n\n}\n\n=head2 accession_number()\n\n Title   : accession_number()\n Usage   : $unique_biological_key = $obj->accession_number();\n Function: Returns the unique biological id for a sequence, commonly\n           called the accession_number. For sequences from established\n           databases, the implementors should try to use the correct\n           accession number. Notice that primary_id() provides the unique id\n           for the implemetation, allowing multiple objects to have the same\n           accession number in a particular implementation. For sequences\n           with no accession number, this method should return \"unknown\".\n           This method sets the accession_number for the SeqWithQuality\n           object. \n Returns : A string (the value of accession_number)\n Args    : If a scalar is provided, it is set as the new accession_number\n           for the SeqWithQuality object.\n Status  : Virtual\n\n\nsub accession_number {\n    my( $obj, $acc ) = @_;\n\n    if (defined $acc) {\n        $obj->{'accession_number'} = $acc;\n    } else {\n        $acc = $obj->{'accession_number'};\n        $acc = 'unknown' unless defined $acc;\n    }\n    return $acc;\n}\n\n=head2 primary_id()\n\n Title   : primary_id()\n Usage   : $unique_implementation_key = $obj->primary_id();\n Function: Returns the unique id for this object in this implementation.\n           This allows implementations to manage their own object ids in a\n           way the implementaiton can control clients can expect one id to\n           map to one object. For sequences with no accession number, this\n           method should return a stringified memory location.\n           This method sets the primary_id for the SeqWithQuality object.\n Returns : A string. (the value of primary_id)\n Args    : If a scalar is provided, it is set as the new primary_id for\n           the SeqWithQuality object.\n\n\nsub primary_id {\n   my ($obj,$value) = @_;\n   if ($value) {\n      $obj->{'primary_id'} = $value;\n    }\n   return $obj->{'primary_id'};\n\n}\n\n=head2 desc()\n\n Title   : desc()\n Usage   : $qual->desc($newval); _or_ \n           $description = $qual->desc();\n Function: Get/set description text for this SeqWithQuality object.\n Returns : A string. (the value of desc)\n Args    : If a scalar is provided, it is set as the new desc for the\n           SeqWithQuality object.\n\n\nsub desc {\n   # a mechanism to set the disc for the SeqWithQuality object.\n   # probably will be used most often by set_common_features()\n   my ($obj,$value) = @_;\n   if( defined $value) {\n      $obj->{'desc'} = $value;\n   }\n   return $obj->{'desc'};\n}\n\n=head2 id()\n\n Title   : id()\n Usage   : $id = $qual->id();\n Function: Return the ID of the quality. This should normally be (and\n           actually is in the implementation provided here) just a synonym\n           for display_id().\n Returns : A string. (the value of id)\n Args    : If a scalar is provided, it is set as the new id for the\n           SeqWithQuality object.\n\n\nsub id {\n   my ($self,$value) = @_;\n   if (!$self) { $self->throw(\"no value for self in $value\"); }\n   if( defined $value ) {\n      return $self->display_id($value);\n   }\n   return $self->display_id();\n}\n\n=head2 seq\n\n Title   : seq()\n Usage   : $string    = $obj->seq(); _or_ $obj->seq(\"atctatcatca\");\n Function: Returns the sequence that is contained in the imbedded in the\n           PrimarySeq object within the SeqWithQuality object\n Returns : A scalar (the seq() value for the imbedded PrimarySeq object.)\n Args    : If a scalar is provided, the SeqWithQuality object will\n           attempt to set that as the sequence for the imbedded PrimarySeq\n           object. Otherwise, the value of seq() for the PrimarySeq object\n           is returned.\n Notes   : This is probably not a good idea because you then should call\n           length() to make sure that the sequence and quality are of the\n           same length. Even then, how can you make sure that this sequence\n           belongs with that quality? I provided this to give you rope to\n           hang yourself with. Tie it to a strong device and use a good\n           knot.\n\n\nsub seq {\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{seq_ref}->seq($value);\n      $self->length();\n   }\n   return $self->{seq_ref}->seq();\n}\n\n=head2 qual()\n\n Title   : qual()\n Usage   : @quality_values  = @{$obj->qual()}; _or_\n           $obj->qual(\"10 10 20 40 50\");\n Function: Returns the quality as imbedded in the PrimaryQual object\n           within the SeqWithQuality object.\n Returns : A reference to an array containing the quality values in the \n           PrimaryQual object.\n Args    : If a scalar is provided, the SeqWithQuality object will\n           attempt to set that as the quality for the imbedded PrimaryQual\n           object. Otherwise, the value of qual() for the PrimaryQual\n           object is returned.\n Notes   : This is probably not a good idea because you then should call\n           length() to make sure that the sequence and quality are of the\n           same length. Even then, how can you make sure that this sequence\n           belongs with that quality? I provided this to give you a strong\n           board with which to flagellate yourself. \n\n\nsub qual {\n   my ($self,$value) = @_;\n\n   if( defined $value) {\n      $self->{qual_ref}->qual($value);\n      # update the lengths\n      $self->length();\n   }\n   return $self->{qual_ref}->qual();\n}\n\n\n\n=head2 trace_indices()\n\n Title   : trace_indices()\n Usage   : @trace_indice_values  = @{$obj->trace_indices()}; _or_\n           $obj->trace_indices(\"10 10 20 40 50\");\n Function: Returns the trace_indices as imbedded in the Primaryqual object\n           within the SeqWithQualiity object.\n Returns : A reference to an array containing the trace_indice values in the \n           PrimaryQual object.\n Args    : If a scalar is provided, the SeqWithuQuality object will\n           attempt to set that as the trace_indices for the imbedded PrimaryQual\n           object. Otherwise, the value of trace_indices() for the PrimaryQual\n           object is returned.\n Notes   : This is probably not a good idea because you then should call\n           length() to make sure that the sequence and trace_indices are of the\n           same length. Even then, how can you make sure that this sequence\n           belongs with that trace_indicex? I provided this to give you a strong\n           board with which to flagellate yourself. \n\n\nsub trace_indices {\n   my ($self,$value) = @_;\n\n   if( defined $value) {\n      $self->{qual_ref}->trace_indices($value);\n      # update the lengths\n      $self->length();\n   }\n   return $self->{qual_ref}->trace_indices();\n}\n\n\n\n\n=head2 length()\n\n Title   : length()\n Usage   : $length = $seqWqual->length();\n Function: Get the length of the SeqWithQuality sequence/quality.\n Returns : Returns the length of the sequence and quality if they are\n           both the same. Returns \"DIFFERENT\" if they differ.\n Args    : None.\n\n\nsub length {\n   my $self = shift;\n   if (!$self->{seq_ref}) {\n      unless ($self->{supress_warnings} == 1) {\n         $self->warn(\"Can't find {seq_ref} here in length().\");\n      }\n      return;\n   }\n   if (!$self->{qual_ref}) {\n      unless ($self->{supress_warnings} == 1) {\n         $self->warn(\"Can't find {qual_ref} here in length().\");\n      }\n      return;\n   }\n   my $seql = $self->{seq_ref}->length();\n\n   if ($seql != $self->{qual_ref}->length()) {\n      unless ($self->{supress_warnings} == 1) {\n         $self->warn(\"Sequence length (\".$seql.\") is different from quality \".\n           \"length (\".$self->{qual_ref}->length().\") in the SeqWithQuality \".\n           \"object. This can only lead to problems later.\");\n      }\n      $self->{'length'} = \"DIFFERENT\";\n   } else {\n      $self->{'length'} = $seql;\n   }\n   return $self->{'length'};\n}\n\n\n=head2 qual_obj\n\n Title   : qual_obj($different_obj)\n Usage   : $qualobj = $seqWqual->qual_obj(); _or_\n           $qualobj = $seqWqual->qual_obj($ref_to_primaryqual_obj);\n Function: Get the PrimaryQual object that is imbedded in the\n           SeqWithQuality object or if a reference to a PrimaryQual object\n           is provided, set this as the PrimaryQual object imbedded in the\n           SeqWithQuality object.\n Returns : A reference to a Bio::Seq::SeqWithQuality object.\n\n\nsub qual_obj {\n   my ($self,$value) = @_;\n   if (defined($value)) {\n      if (ref($value) eq \"Bio::Seq::PrimaryQual\") {\n         $self->{qual_ref} = $value;\n         $self->debug(\"You successfully changed the PrimaryQual object within \".\n           \"a SeqWithQuality object. ID's for the SeqWithQuality object may \".\n           \"now not be what you expect. Use something like \".\n           \"set_common_descriptors() to fix them if you care,\");\n      } else {\n         $self->debug(\"You tried to change the PrimaryQual object within a \".\n           \"SeqWithQuality object but you passed a reference to an object that\".\n           \" was not a Bio::Seq::PrimaryQual object. Thus your change failed. \".\n           \"Sorry.\\n\");\t    \n      }\n   }\n   return $self->{qual_ref};\n}\n\n\n=head2 seq_obj\n\n Title   : seq_obj()\n Usage   : $seqobj = $seqWqual->qual_obj(); _or_\n           $seqobj = $seqWqual->seq_obj($ref_to_primary_seq_obj);\n Function: Get the PrimarySeq object that is imbedded in the\n           SeqWithQuality object or if a reference to a PrimarySeq object is\n           provided, set this as the PrimarySeq object imbedded in the\n           SeqWithQuality object.\n Returns : A reference to a Bio::PrimarySeq object.\n\n\nsub seq_obj {\n   my ($self,$value) = @_;\n   if( defined $value) {\n      if (ref($value) eq \"Bio::PrimarySeq\") {\n         $self->debug(\"You successfully changed the PrimarySeq object within a\".\n           \" SeqWithQuality object. ID's for the SeqWithQuality object may now\".\n           \" not be what you expect. Use something like \".\n           \"set_common_descriptors() to fix them if you care,\");\n      } else {\n         $self->debug(\"You tried to change the PrimarySeq object within a \".\n           \"SeqWithQuality object but you passed a reference to an object that\".\n           \" was not a Bio::PrimarySeq object. Thus your change failed. Sorry.\\n\");\n      }\n   }\n   return $self->{seq_ref};\n}\n\n=head2 _set_descriptors\n\n Title   : _set_descriptors()\n Usage   : $seqWqual->_qual_obj($qual,$seq,$id,$acc,$pid,$desc,$given_id,\n           $alphabet);\n Function: Set the descriptors for the SeqWithQuality object. Try to\n           match the descriptors in the PrimarySeq object and in the\n           PrimaryQual object if descriptors were not provided with\n           construction.\n Returns : Nothing.\n Args    : $qual,$seq,$id,$acc,$pid,$desc,$given_id,$alphabet as found\n           in the new() method.\n Notes   : Really only intended to be called by the new() method. If\n           you want to invoke a similar function try set_common_descriptors().\n\n\n\nsub _set_descriptors {\n   my ($self,$qual,$seq,$id,$acc,$pid,$desc,$given_id,$alphabet) = @_;\n   my ($c_id,$c_acc,$c_pid,$c_desc);\n   if (!$self->display_id()) {\n      if ($c_id = $self->_common_id() ) { $self->display_id($c_id); }\n      else {\n         if ($self->{seq_ref}) {\n            # print(\"Using seq_ref to set id to \".$self->{seq_ref}->display_id().\"\\n\");\n            # ::dumpValue($self->{seq_ref});\n            $self->display_id($self->{seq_ref}->id());\n         } elsif ($self->{qual_ref}) {\n            $self->display_id($self->{qual_ref}->id());\n         }\n      }\n   }\n   if ($acc) { $self->accession_number($acc); }\n   elsif ($c_acc = $self->_common_accession_number() ) { $self->accession_number($c_acc); }\n   if ($pid) { $self->primary_id($pid); }\n   elsif ($c_pid = $self->_common_primary_id() ) { $self->primary_id($c_pid); }\n   if ($desc) { $self->desc($desc); }\n   elsif ($c_desc = $self->_common_desc() ) { $self->desc($c_desc); }\n}\n\n=head2 subseq($start,$end)\n\n Title   : subseq($start,$end)\n Usage   : $subsequence = $obj->subseq($start,$end);\n Function: Returns the subseq from start to end, where the first base\n           is 1 and the number is inclusive, ie 1-2 are the first two\n           bases of the sequence.\n Returns : A string.\n Args    : Two positions.\n\n\nsub subseq {\n    my ($self,@args) = @_;\n    # does a single value work?\n    return $self->{seq_ref}->subseq(@args);\n}\n\n=head2 baseat($position)\n\n Title   : baseat($position)\n Usage   : $base_at_position_6 = $obj->baseat(\"6\");\n Function: Returns a single base at the given position, where the first\n           base is 1 and the number is inclusive, ie 1-2 are the first two\n           bases of the sequence.\n Returns : A scalar.\n Args    : A position.\n\n\nsub baseat {\n    my ($self,$val) = @_;\n    return $self->{seq_ref}->subseq($val,$val);\n}\n\n=head2 subqual($start,$end)\n\n Title   : subqual($start,$end)\n Usage   : @qualities = @{$obj->subqual(10,20);\n Function: returns the quality values from $start to $end, where the\n           first value is 1 and the number is inclusive, ie 1-2 are the\n           first two bases of the sequence. Start cannot be larger than\n           end but can be equal.\n Returns : A reference to an array.\n Args    : a start position and an end position\n\n\nsub subqual {\n    my ($self,@args) = @_;\n    return $self->{qual_ref}->subqual(@args);\n}\n\n=head2 qualat($position)\n\n Title   : qualat($position)\n Usage   : $quality = $obj->qualat(10);\n Function: Return the quality value at the given location, where the\n           first value is 1 and the number is inclusive, ie 1-2 are the\n           first two bases of the sequence. Start cannot be larger than\n           end but can be equal.\n Returns : A scalar.\n Args    : A position.\n\n\nsub qualat {\n    my ($self,$val) = @_;\n    return $self->{qual_ref}->qualat($val);\n}\n\n=head2 sub_trace_index($start,$end)\n\n Title   : sub_trace_index($start,$end)\n Usage   : @trace_indices = @{$obj->sub_trace_index(10,20);\n Function: returns the trace index values from $start to $end, where the\n           first value is 1 and the number is inclusive, ie 1-2 are the\n           first two bases of the sequence. Start cannot be larger than\n           end but can be e_trace_index.\n Returns : A reference to an array.\n Args    : a start position and an end position","label":"sub_trace_index($self,@args)"},"containerName":"main::","definition":"sub"},{"kind":12,"line":852,"name":"qual_ref"},{"name":"trace_index_at","range":{"start":{"character":0,"line":868},"end":{"line":871,"character":9999}},"kind":12,"line":868,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"trace_index_at","line":869,"kind":13},{"kind":13,"line":869,"name":"$val","containerName":"trace_index_at"},{"line":870,"kind":13,"name":"$self","containerName":"trace_index_at"},{"containerName":"trace_index_at","name":"trace_index_at","line":870,"kind":12},{"line":870,"kind":13,"name":"$val","containerName":"trace_index_at"}],"containerName":"main::","definition":"sub","detail":"($self,$val)","signature":{"documentation":"1;\n# $Id: SeqWithQuality.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Seq::QualI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chad Matsalla <bioinformatics@dieselwurks.com\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::SeqWithQuality - Bioperl object packaging a sequence with its quality.\nDeprecated class, use Bio::Seq::Quality instead!\n\n=head1 SYNOPSIS\n\n    use Bio::PrimarySeq;\n    use Bio::Seq::PrimaryQual;\n    use Bio::Seq::SeqWithQuality;\n\n    # make from memory\n    my $qual = Bio::Seq::SeqWithQuality->new\n    ( -qual => '10 20 30 40 50 50 20 10',\n      -seq => 'ATCGATCG',\n      -id  => 'human_id',\n      -accession_number => 'AL000012',\n    );\n\n    # make from objects\n    # first, make a PrimarySeq object\n    my $seqobj = Bio::PrimarySeq->new\n    ( -seq => 'atcgatcg',\n      -id  => 'GeneFragment-12',\n      -accession_number => 'X78121',\n      -alphabet => 'dna'\n    );\n\n    # now make a PrimaryQual object\n    my $qualobj = Bio::Seq::PrimaryQual->new\n    ( -qual => '10 20 30 40 50 50 20 10',\n      -id  => 'GeneFragment-12',\n      -accession_number => 'X78121',\n      -alphabet => 'dna'\n    );\n\n    # now make the SeqWithQuality object\n    my $swqobj = Bio::Seq::SeqWithQuality->new\n    ( -seq  => $seqobj,\n      -qual => $qualobj\n    );\n    # done!\n\n    $swqobj->id(); # the id of the SeqWithQuality object\n    # may not match the the id of the sequence or\n    # of the quality (check the pod, luke)\n    $swqobj->seq(); # the sequence of the SeqWithQuality object\n    $swqobj->qual(); # the quality of the SeqWithQuality object\n\n    # to get out parts of the sequence.\n\n    print \"Sequence \", $seqobj->id(), \" with accession \",\n    $seqobj->accession, \" and desc \", $seqobj->desc, \"\\n\";\n\n    $string2 = $seqobj->subseq(1,40);\n\n=head1 DESCRIPTION\n\nThis object stores base quality values together with the sequence string.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nEmail bioinformatics@dieselwurks.com\n\n=head1 CONTRIBUTORS \n\nJason Stajich, jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\npackage Bio::Seq::SeqWithQuality;\n\n\nuse strict;\nuse Bio::PrimarySeq;\nuse Bio::Seq::PrimaryQual;\n\nuse base qw(Bio::Root::Root Bio::PrimarySeqI Bio::Seq::QualI);\n\n=head2 new()\n\n Title   : new()\n Usage   : $qual = Bio::Seq::SeqWithQuality ->new\n             ( -qual => '10 20 30 40 50 50 20 10',\n               -seq => 'ATCGATCG',\n               -id  => 'human_id',\n               -accession_number => 'AL000012',\n               -trace_indices    => '0 5 10 15 20 25 30 35'\n             );\n Function: Returns a new Bio::Seq::SeqWithQual object from basic\n           constructors.\n Returns : a new Bio::Seq::PrimaryQual object\n Args    : -qual can be a quality string (see Bio::Seq::PrimaryQual for more\n            information on this) or a reference to a Bio::Seq::PrimaryQual\n            object.\n           -seq can be a sequence string (see Bio::PrimarySeq for more\n            information on this) or a reference to a Bio::PrimaryQual object.\n           -seq, -id, -accession_number, -primary_id, -desc, -id behave like\n            this:\n             1. if they are provided on construction of the\n                 Bio::Seq::SeqWithQuality they will be set as the descriptors for\n                 the object unless changed by one of the following mechanisms:\n              a) $obj->set_common_descriptors() is used and both the -seq and\n                 the -qual object have the same descriptors. These common\n                 descriptors will then become the descriptors for the\n                 Bio::Seq::SeqWithQual object.\n              b) the descriptors are manually set using the seq(), id(),\n                 desc(), or accession_number(), primary_id(),\n             2. if no descriptors are provided, the new() constructor will see\n                if the descriptor used in the PrimarySeq and in the\n                PrimaryQual objects match. If they do, they will become\n                the descriptors for the SeqWithQuality object.\n             To eliminate ambiguity, I strongly suggest you set the\n             descriptors manually on construction of the object. Really.\n           -trace_indices : a space_delimited list of trace indices\n            (where would the peaks be drawn if this list of qualities\n            was to be plotted?)\n\n\nsub new {\n   my ($class, @args) = @_;\n   my $self = $class->SUPER::new(@args);\n   # default: turn OFF the warnings\n   $self->{supress_warnings} = 1;\n   my($qual,$seq,$id,$acc,$pid,$desc,$given_id,$alphabet,$trace_indices) =\n   $self->_rearrange([qw( QUAL SEQ DISPLAY_ID ACCESSION_NUMBER PRIMARY_ID DESC\n     ID ALPHABET TRACE_INDICES )], @args);\n   # Deal with the ID\n   if ( defined $id && defined $given_id ) {\n      if( $id ne $given_id ) {\n         $self->throw(\"Provided both id and display_id constructor functions. [$id] [$given_id]\");\n      }\n   }\n   if( defined $given_id ) {\n      $self->display_id($given_id);\n      $id = $given_id;\n   }\n   # Import sequence first\n   if (!$seq) {\n      my $id;\n      unless ($self->{supress_warnings} == 1) {\n         $self->warn(\"You did not provide sequence information during the \".\n           \"construction of a Bio::Seq::SeqWithQuality object. Sequence \".\n           \"components for this object will be empty.\");\n      }\n      if (!$alphabet) {\n         $self->throw(\"If you want me to create a PrimarySeq object for your \".\n           \"empty sequence <boggle> you must specify a -alphabet to satisfy \".\n           \"the constructor requirements for a Bio::PrimarySeq object with no \".\n           \"sequence. Read the POD for it, luke.\");\n      }\n      $self->{seq_ref} = Bio::PrimarySeq->new( -seq              =>  \"\",\n                                               -accession_number =>  $acc,\n                                               -primary_id       =>  $pid,\n                                               -desc             =>  $desc,\n                                               -display_id       =>  $id,\n                                               -alphabet         =>  $alphabet );\n   } elsif ($seq->isa('Bio::PrimarySeqI') || $seq->isa('Bio::SeqI')) {\n      $self->{seq_ref} = $seq;\n   } elsif (ref($seq)) {\n      $self->throw(\"You passed a seq argument into a SeqWithQUality object and\".\n        \" it was a reference ($seq) which did not inherit from Bio::SeqI or \".\n        \"Bio::PrimarySeqI. I don't know what to do with this!\");\n   } else {\n      my $seqobj = Bio::PrimarySeq->new( -seq              => $seq,\n                                         -accession_number => $acc,\n                                         -primary_id       => $pid,\n                                         -desc             => $desc,\n                                         -display_id       => $id   );\n      $self->{seq_ref} = $seqobj;\n   }\n   # Then import the quality scores\n   if (!defined($qual)) {\n      $self->{qual_ref} = Bio::Seq::PrimaryQual->new( -qual             => \"\",\n                                                      -accession_number => $acc,\n                                                      -primary_id       => $pid,\n                                                      -desc             => $desc,\n                                                      -display_id       => $id, );\n   } elsif (ref($qual) eq \"Bio::Seq::PrimaryQual\") {\n      $self->{qual_ref} = $qual;\n   } else {\n      my $qualobj = Bio::Seq::PrimaryQual->new( -qual             => $qual,\n                                                -accession_number => $acc,\n                                                -primary_id       => $pid,\n                                                -desc             => $desc,\n                                                -display_id       => $id,\n                                                -trace_indices    => $trace_indices );\n      $self->{qual_ref} = $qualobj;\n   }\n   # Now try to set the descriptors for this object\n   $self->_set_descriptors($qual,$seq,$id,$acc,$pid,$desc,$given_id,$alphabet);\n   $self->length();\n   $self->deprecated(\"deprecated class - use Bio::Seq::Quality instead\");\n\n   return $self;\n}\n\n=head2 _common_id()\n\n Title   : _common_id()\n Usage   : $common_id = $self->_common_id();\n Function: Compare the display_id of {qual_ref} and {seq_ref}.\n Returns : Nothing if they don't match. If they do return {seq_ref}->display_id()\n Args    : None.\n\n\n#'\nsub _common_id {\n   my $self = shift;\n   return if (!$self->{seq_ref} || !$self->{qual_ref});\n   my $sid = $self->{seq_ref}->display_id();\n   return if (!$sid);\n   return if (!$self->{qual_ref}->display_id());\n   return $sid if ($sid eq $self->{qual_ref}->display_id());\n   # should this become a warning?\n   # print(\"ids $sid and $self->{qual_ref}->display_id() do not match. Bummer.\\n\");\n}\n\n=head2 _common_display_id()\n\n Title   : _common_id()\n Usage   : $common_id = $self->_common_display_id();\n Function: Compare the display_id of {qual_ref} and {seq_ref}.\n Returns : Nothing if they don't match. If they do return {seq_ref}->display_id()\n Args    : None.\n\n\n#'\nsub _common_display_id {\n   my $self = shift;\n   $self->common_id();\n}\n\n=head2 _common_accession_number()\n\n Title   : _common_accession_number()\n Usage   : $common_id = $self->_common_accession_number();\n Function: Compare the accession_number() of {qual_ref} and {seq_ref}.\n Returns : Nothing if they don't match. If they do return {seq_ref}->accession_number()\n Args    : None.\n\n\n#'\nsub _common_accession_number {\n   my $self = shift;\n   return if ($self->{seq_ref} || $self->{qual_ref});\n   my $acc = $self->{seq_ref}->accession_number();\n   # if (!$acc) { print(\"the seqref has no acc.\\n\"); }\n   return if (!$acc);\n   # if ($acc eq $self->{qual_ref}->accession_number()) { print(\"$acc matches \".$self->{qual_ref}->accession_number().\"\\n\"); }\n   return $acc if ($acc eq $self->{qual_ref}->accession_number());\n   # should this become a warning?\n   # print(\"accession numbers $acc and $self->{qual_ref}->accession_number() do not match. Bummer.\\n\");\n}\n\n=head2 _common_primary_id()\n\n Title   : _common_primary_id()\n Usage   : $common_primard_id = $self->_common_primary_id();\n Function: Compare the primary_id of {qual_ref} and {seq_ref}.\n Returns : Nothing if they don't match. If they do return {seq_ref}->primary_id()\n Args    : None.\n\n\n#'\nsub _common_primary_id {\n   my $self = shift;\n   return if ($self->{seq_ref} || $self->{qual_ref});\n   my $pid = $self->{seq_ref}->primary_id();\n   return if (!$pid);\n   return $pid if ($pid eq $self->{qual_ref}->primary_id());\n   # should this become a warning?\n   # print(\"primary_ids $pid and $self->{qual_ref}->primary_id() do not match. Bummer.\\n\");\n}\n\n=head2 _common_desc()\n\n Title   : _common_desc()\n Usage   : $common_desc = $self->_common_desc();\n Function: Compare the desc of {qual_ref} and {seq_ref}.\n Returns : Nothing if they don't match. If they do return {seq_ref}->desc()\n Args    : None.\n\n\n#'\nsub _common_desc {\n   my $self = shift;\n   return if ($self->{seq_ref} || $self->{qual_ref});\n   my $des = $self->{seq_ref}->desc();\n   return if (!$des);\n   return $des if ($des eq $self->{qual_ref}->desc());\n   # should this become a warning?\n   # print(\"descriptions $des and $self->{qual_ref}->desc() do not match. Bummer.\\n\");\n}\n\n=head2 set_common_descriptors()\n\n Title   : set_common_descriptors()\n Usage   : $self->set_common_descriptors();\n Function: Compare the descriptors (id,accession_number,display_id,\n           primary_id, desc) for the PrimarySeq and PrimaryQual objects\n           within the SeqWithQuality object. If they match, make that\n           descriptor the descriptor for the SeqWithQuality object.\n Returns : Nothing.\n Args    : None.\n\n\nsub set_common_descriptors {\n   my $self = shift;\n   return if ($self->{seq_ref} || $self->{qual_ref});\n   &_common_id();\n   &_common_display_id();\n   &_common_accession_number();\n   &_common_primary_id();\n   &_common_desc();\n}\n\n=head2 alphabet()\n\n Title   : alphabet();\n Usage   : $molecule_type = $obj->alphabet();\n Function: Get the molecule type from the PrimarySeq object.\n Returns : What what PrimarySeq says the type of the sequence is.\n Args    : None.\n\n\nsub alphabet {\n   my $self = shift;\n   return $self->{seq_ref}->alphabet();\n}\n\n=head2 display_id()\n\n Title   : display_id()\n Usage   : $id_string = $obj->display_id();\n Function: Returns the display id, aka the common name of the Quality object.\n           The semantics of this is that it is the most likely string to be\n           used as an identifier of the quality sequence, and likely to have\n           \"human\" readability.  The id is equivalent to the ID field of the\n           GenBank/EMBL databanks and the id field of the Swissprot/sptrembl\n           database. In fasta format, the >(\\S+) is presumed to be the id,\n           though some people overload the id to embed other information.\n           Bioperl does not use any embedded information in the ID field,\n           and people are encouraged to use other mechanisms (accession\n           field for example, or extending the sequence object) to solve\n           this. Notice that $seq->id() maps to this function, mainly for\n           legacy/convience issues.\n           This method sets the display_id for the SeqWithQuality object.\n Returns : A string\n Args    : If a scalar is provided, it is set as the new display_id for\n           the SeqWithQuality object.\n Status  : Virtual\n\n\nsub display_id {\n   my ($obj,$value) = @_;\n   if( defined $value) {\n      $obj->{'display_id'} = $value;\n    }\n    return $obj->{'display_id'};\n\n}\n\n=head2 accession_number()\n\n Title   : accession_number()\n Usage   : $unique_biological_key = $obj->accession_number();\n Function: Returns the unique biological id for a sequence, commonly\n           called the accession_number. For sequences from established\n           databases, the implementors should try to use the correct\n           accession number. Notice that primary_id() provides the unique id\n           for the implemetation, allowing multiple objects to have the same\n           accession number in a particular implementation. For sequences\n           with no accession number, this method should return \"unknown\".\n           This method sets the accession_number for the SeqWithQuality\n           object. \n Returns : A string (the value of accession_number)\n Args    : If a scalar is provided, it is set as the new accession_number\n           for the SeqWithQuality object.\n Status  : Virtual\n\n\nsub accession_number {\n    my( $obj, $acc ) = @_;\n\n    if (defined $acc) {\n        $obj->{'accession_number'} = $acc;\n    } else {\n        $acc = $obj->{'accession_number'};\n        $acc = 'unknown' unless defined $acc;\n    }\n    return $acc;\n}\n\n=head2 primary_id()\n\n Title   : primary_id()\n Usage   : $unique_implementation_key = $obj->primary_id();\n Function: Returns the unique id for this object in this implementation.\n           This allows implementations to manage their own object ids in a\n           way the implementaiton can control clients can expect one id to\n           map to one object. For sequences with no accession number, this\n           method should return a stringified memory location.\n           This method sets the primary_id for the SeqWithQuality object.\n Returns : A string. (the value of primary_id)\n Args    : If a scalar is provided, it is set as the new primary_id for\n           the SeqWithQuality object.\n\n\nsub primary_id {\n   my ($obj,$value) = @_;\n   if ($value) {\n      $obj->{'primary_id'} = $value;\n    }\n   return $obj->{'primary_id'};\n\n}\n\n=head2 desc()\n\n Title   : desc()\n Usage   : $qual->desc($newval); _or_ \n           $description = $qual->desc();\n Function: Get/set description text for this SeqWithQuality object.\n Returns : A string. (the value of desc)\n Args    : If a scalar is provided, it is set as the new desc for the\n           SeqWithQuality object.\n\n\nsub desc {\n   # a mechanism to set the disc for the SeqWithQuality object.\n   # probably will be used most often by set_common_features()\n   my ($obj,$value) = @_;\n   if( defined $value) {\n      $obj->{'desc'} = $value;\n   }\n   return $obj->{'desc'};\n}\n\n=head2 id()\n\n Title   : id()\n Usage   : $id = $qual->id();\n Function: Return the ID of the quality. This should normally be (and\n           actually is in the implementation provided here) just a synonym\n           for display_id().\n Returns : A string. (the value of id)\n Args    : If a scalar is provided, it is set as the new id for the\n           SeqWithQuality object.\n\n\nsub id {\n   my ($self,$value) = @_;\n   if (!$self) { $self->throw(\"no value for self in $value\"); }\n   if( defined $value ) {\n      return $self->display_id($value);\n   }\n   return $self->display_id();\n}\n\n=head2 seq\n\n Title   : seq()\n Usage   : $string    = $obj->seq(); _or_ $obj->seq(\"atctatcatca\");\n Function: Returns the sequence that is contained in the imbedded in the\n           PrimarySeq object within the SeqWithQuality object\n Returns : A scalar (the seq() value for the imbedded PrimarySeq object.)\n Args    : If a scalar is provided, the SeqWithQuality object will\n           attempt to set that as the sequence for the imbedded PrimarySeq\n           object. Otherwise, the value of seq() for the PrimarySeq object\n           is returned.\n Notes   : This is probably not a good idea because you then should call\n           length() to make sure that the sequence and quality are of the\n           same length. Even then, how can you make sure that this sequence\n           belongs with that quality? I provided this to give you rope to\n           hang yourself with. Tie it to a strong device and use a good\n           knot.\n\n\nsub seq {\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{seq_ref}->seq($value);\n      $self->length();\n   }\n   return $self->{seq_ref}->seq();\n}\n\n=head2 qual()\n\n Title   : qual()\n Usage   : @quality_values  = @{$obj->qual()}; _or_\n           $obj->qual(\"10 10 20 40 50\");\n Function: Returns the quality as imbedded in the PrimaryQual object\n           within the SeqWithQuality object.\n Returns : A reference to an array containing the quality values in the \n           PrimaryQual object.\n Args    : If a scalar is provided, the SeqWithQuality object will\n           attempt to set that as the quality for the imbedded PrimaryQual\n           object. Otherwise, the value of qual() for the PrimaryQual\n           object is returned.\n Notes   : This is probably not a good idea because you then should call\n           length() to make sure that the sequence and quality are of the\n           same length. Even then, how can you make sure that this sequence\n           belongs with that quality? I provided this to give you a strong\n           board with which to flagellate yourself. \n\n\nsub qual {\n   my ($self,$value) = @_;\n\n   if( defined $value) {\n      $self->{qual_ref}->qual($value);\n      # update the lengths\n      $self->length();\n   }\n   return $self->{qual_ref}->qual();\n}\n\n\n\n=head2 trace_indices()\n\n Title   : trace_indices()\n Usage   : @trace_indice_values  = @{$obj->trace_indices()}; _or_\n           $obj->trace_indices(\"10 10 20 40 50\");\n Function: Returns the trace_indices as imbedded in the Primaryqual object\n           within the SeqWithQualiity object.\n Returns : A reference to an array containing the trace_indice values in the \n           PrimaryQual object.\n Args    : If a scalar is provided, the SeqWithuQuality object will\n           attempt to set that as the trace_indices for the imbedded PrimaryQual\n           object. Otherwise, the value of trace_indices() for the PrimaryQual\n           object is returned.\n Notes   : This is probably not a good idea because you then should call\n           length() to make sure that the sequence and trace_indices are of the\n           same length. Even then, how can you make sure that this sequence\n           belongs with that trace_indicex? I provided this to give you a strong\n           board with which to flagellate yourself. \n\n\nsub trace_indices {\n   my ($self,$value) = @_;\n\n   if( defined $value) {\n      $self->{qual_ref}->trace_indices($value);\n      # update the lengths\n      $self->length();\n   }\n   return $self->{qual_ref}->trace_indices();\n}\n\n\n\n\n=head2 length()\n\n Title   : length()\n Usage   : $length = $seqWqual->length();\n Function: Get the length of the SeqWithQuality sequence/quality.\n Returns : Returns the length of the sequence and quality if they are\n           both the same. Returns \"DIFFERENT\" if they differ.\n Args    : None.\n\n\nsub length {\n   my $self = shift;\n   if (!$self->{seq_ref}) {\n      unless ($self->{supress_warnings} == 1) {\n         $self->warn(\"Can't find {seq_ref} here in length().\");\n      }\n      return;\n   }\n   if (!$self->{qual_ref}) {\n      unless ($self->{supress_warnings} == 1) {\n         $self->warn(\"Can't find {qual_ref} here in length().\");\n      }\n      return;\n   }\n   my $seql = $self->{seq_ref}->length();\n\n   if ($seql != $self->{qual_ref}->length()) {\n      unless ($self->{supress_warnings} == 1) {\n         $self->warn(\"Sequence length (\".$seql.\") is different from quality \".\n           \"length (\".$self->{qual_ref}->length().\") in the SeqWithQuality \".\n           \"object. This can only lead to problems later.\");\n      }\n      $self->{'length'} = \"DIFFERENT\";\n   } else {\n      $self->{'length'} = $seql;\n   }\n   return $self->{'length'};\n}\n\n\n=head2 qual_obj\n\n Title   : qual_obj($different_obj)\n Usage   : $qualobj = $seqWqual->qual_obj(); _or_\n           $qualobj = $seqWqual->qual_obj($ref_to_primaryqual_obj);\n Function: Get the PrimaryQual object that is imbedded in the\n           SeqWithQuality object or if a reference to a PrimaryQual object\n           is provided, set this as the PrimaryQual object imbedded in the\n           SeqWithQuality object.\n Returns : A reference to a Bio::Seq::SeqWithQuality object.\n\n\nsub qual_obj {\n   my ($self,$value) = @_;\n   if (defined($value)) {\n      if (ref($value) eq \"Bio::Seq::PrimaryQual\") {\n         $self->{qual_ref} = $value;\n         $self->debug(\"You successfully changed the PrimaryQual object within \".\n           \"a SeqWithQuality object. ID's for the SeqWithQuality object may \".\n           \"now not be what you expect. Use something like \".\n           \"set_common_descriptors() to fix them if you care,\");\n      } else {\n         $self->debug(\"You tried to change the PrimaryQual object within a \".\n           \"SeqWithQuality object but you passed a reference to an object that\".\n           \" was not a Bio::Seq::PrimaryQual object. Thus your change failed. \".\n           \"Sorry.\\n\");\t    \n      }\n   }\n   return $self->{qual_ref};\n}\n\n\n=head2 seq_obj\n\n Title   : seq_obj()\n Usage   : $seqobj = $seqWqual->qual_obj(); _or_\n           $seqobj = $seqWqual->seq_obj($ref_to_primary_seq_obj);\n Function: Get the PrimarySeq object that is imbedded in the\n           SeqWithQuality object or if a reference to a PrimarySeq object is\n           provided, set this as the PrimarySeq object imbedded in the\n           SeqWithQuality object.\n Returns : A reference to a Bio::PrimarySeq object.\n\n\nsub seq_obj {\n   my ($self,$value) = @_;\n   if( defined $value) {\n      if (ref($value) eq \"Bio::PrimarySeq\") {\n         $self->debug(\"You successfully changed the PrimarySeq object within a\".\n           \" SeqWithQuality object. ID's for the SeqWithQuality object may now\".\n           \" not be what you expect. Use something like \".\n           \"set_common_descriptors() to fix them if you care,\");\n      } else {\n         $self->debug(\"You tried to change the PrimarySeq object within a \".\n           \"SeqWithQuality object but you passed a reference to an object that\".\n           \" was not a Bio::PrimarySeq object. Thus your change failed. Sorry.\\n\");\n      }\n   }\n   return $self->{seq_ref};\n}\n\n=head2 _set_descriptors\n\n Title   : _set_descriptors()\n Usage   : $seqWqual->_qual_obj($qual,$seq,$id,$acc,$pid,$desc,$given_id,\n           $alphabet);\n Function: Set the descriptors for the SeqWithQuality object. Try to\n           match the descriptors in the PrimarySeq object and in the\n           PrimaryQual object if descriptors were not provided with\n           construction.\n Returns : Nothing.\n Args    : $qual,$seq,$id,$acc,$pid,$desc,$given_id,$alphabet as found\n           in the new() method.\n Notes   : Really only intended to be called by the new() method. If\n           you want to invoke a similar function try set_common_descriptors().\n\n\n\nsub _set_descriptors {\n   my ($self,$qual,$seq,$id,$acc,$pid,$desc,$given_id,$alphabet) = @_;\n   my ($c_id,$c_acc,$c_pid,$c_desc);\n   if (!$self->display_id()) {\n      if ($c_id = $self->_common_id() ) { $self->display_id($c_id); }\n      else {\n         if ($self->{seq_ref}) {\n            # print(\"Using seq_ref to set id to \".$self->{seq_ref}->display_id().\"\\n\");\n            # ::dumpValue($self->{seq_ref});\n            $self->display_id($self->{seq_ref}->id());\n         } elsif ($self->{qual_ref}) {\n            $self->display_id($self->{qual_ref}->id());\n         }\n      }\n   }\n   if ($acc) { $self->accession_number($acc); }\n   elsif ($c_acc = $self->_common_accession_number() ) { $self->accession_number($c_acc); }\n   if ($pid) { $self->primary_id($pid); }\n   elsif ($c_pid = $self->_common_primary_id() ) { $self->primary_id($c_pid); }\n   if ($desc) { $self->desc($desc); }\n   elsif ($c_desc = $self->_common_desc() ) { $self->desc($c_desc); }\n}\n\n=head2 subseq($start,$end)\n\n Title   : subseq($start,$end)\n Usage   : $subsequence = $obj->subseq($start,$end);\n Function: Returns the subseq from start to end, where the first base\n           is 1 and the number is inclusive, ie 1-2 are the first two\n           bases of the sequence.\n Returns : A string.\n Args    : Two positions.\n\n\nsub subseq {\n    my ($self,@args) = @_;\n    # does a single value work?\n    return $self->{seq_ref}->subseq(@args);\n}\n\n=head2 baseat($position)\n\n Title   : baseat($position)\n Usage   : $base_at_position_6 = $obj->baseat(\"6\");\n Function: Returns a single base at the given position, where the first\n           base is 1 and the number is inclusive, ie 1-2 are the first two\n           bases of the sequence.\n Returns : A scalar.\n Args    : A position.\n\n\nsub baseat {\n    my ($self,$val) = @_;\n    return $self->{seq_ref}->subseq($val,$val);\n}\n\n=head2 subqual($start,$end)\n\n Title   : subqual($start,$end)\n Usage   : @qualities = @{$obj->subqual(10,20);\n Function: returns the quality values from $start to $end, where the\n           first value is 1 and the number is inclusive, ie 1-2 are the\n           first two bases of the sequence. Start cannot be larger than\n           end but can be equal.\n Returns : A reference to an array.\n Args    : a start position and an end position\n\n\nsub subqual {\n    my ($self,@args) = @_;\n    return $self->{qual_ref}->subqual(@args);\n}\n\n=head2 qualat($position)\n\n Title   : qualat($position)\n Usage   : $quality = $obj->qualat(10);\n Function: Return the quality value at the given location, where the\n           first value is 1 and the number is inclusive, ie 1-2 are the\n           first two bases of the sequence. Start cannot be larger than\n           end but can be equal.\n Returns : A scalar.\n Args    : A position.\n\n\nsub qualat {\n    my ($self,$val) = @_;\n    return $self->{qual_ref}->qualat($val);\n}\n\n=head2 sub_trace_index($start,$end)\n\n Title   : sub_trace_index($start,$end)\n Usage   : @trace_indices = @{$obj->sub_trace_index(10,20);\n Function: returns the trace index values from $start to $end, where the\n           first value is 1 and the number is inclusive, ie 1-2 are the\n           first two bases of the sequence. Start cannot be larger than\n           end but can be e_trace_index.\n Returns : A reference to an array.\n Args    : a start position and an end position\n\n\nsub sub_trace_index {\n    my ($self,@args) = @_;\n    return $self->{qual_ref}->sub_trace_index(@args);\n}\n\n=head2 trace_index_at($position)\n\n Title   : trace_index_at($position)\n Usage   : $trace_index = $obj->trace_index_at(10);\n Function: Return the trace_index value at the given location, where the\n           first value is 1 and the number is inclusive, ie 1-2 are the\n           first two bases of the sequence. Start cannot be larger than\n           end but can be etrace_index_.\n Returns : A scalar.\n Args    : A position.","parameters":[{"label":"$self"},{"label":"$val"}],"label":"trace_index_at($self,$val)"}},{"kind":12,"line":870,"name":"qual_ref"},{"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"to_string","line":894,"kind":13},{"containerName":"to_string","name":"$out","kind":13,"line":894},{"containerName":"to_string","name":"$result","line":894,"kind":13},{"kind":13,"line":895,"containerName":"to_string","name":"$out"},{"line":895,"kind":13,"containerName":"to_string","name":"$self"},{"line":895,"kind":12,"containerName":"to_string","name":"qual"}],"line":893,"kind":12,"range":{"end":{"character":9999,"line":895},"start":{"line":893,"character":0}},"definition":"sub","name":"to_string","containerName":"main::"},{"line":897,"kind":13,"name":"$result","containerName":null},{"name":"$self","containerName":null,"kind":13,"line":897},{"name":"%result","containerName":null,"kind":13,"line":898},{"name":"$result","containerName":null,"line":898,"kind":13},{"line":899,"kind":13,"containerName":null,"name":"$out"},{"kind":13,"line":901,"name":"$out","containerName":null}],"version":5}