{"vars":[{"name":"base","containerName":"","kind":2,"line":85},{"name":"new","range":{"start":{"line":98,"character":0},"end":{"character":9999,"line":107}},"definition":"sub","containerName":"main::","signature":{"label":"new($class,@args)","documentation":"1;\n# $Id: SeqFactory.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Seq::SeqFactory\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::SeqFactory - Instantiates a new Bio::PrimarySeqI (or derived class) through a factory\n\n=head1 SYNOPSIS\n\n    use Bio::Seq::SeqFactory;\n    my $factory = Bio::Seq::SeqFactory->new();\n    my $seq = $factory->create(-seq => 'WYRAVLC',\n\t\t\t       -id  => 'name');\n\n    # If you want the factory to create Bio::Seq objects instead\n    # of the default Bio::PrimarySeq objects, use the -type parameter:\n\n    my $factory = Bio::Seq::SeqFactory->new(-type => 'Bio::Seq');\n\n\n=head1 DESCRIPTION\n\nThis object will build L<Bio::PrimarySeqI> and L<Bio::SeqI> objects\ngenerically.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Seq::SeqFactory;\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Factory::SequenceFactoryI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Seq::SeqFactory->new();\n Function: Builds a new Bio::Seq::SeqFactory object \n Returns : Bio::Seq::SeqFactory\n Args    : -type => string, name of a PrimarySeqI derived class\n                    This is optional. Default=Bio::PrimarySeq.","parameters":[{"label":"$class"},{"label":"@args"}]},"detail":"($class,@args)","kind":12,"children":[{"kind":13,"line":99,"containerName":"new","definition":"my","name":"$class","localvar":"my"},{"name":"@args","containerName":"new","kind":13,"line":99},{"kind":13,"line":100,"name":"$self","definition":"my","containerName":"new","localvar":"my"},{"line":100,"kind":13,"name":"$class","containerName":"new"},{"kind":13,"line":100,"containerName":"new","name":"@args"},{"localvar":"my","name":"$type","definition":"my","containerName":"new","line":101,"kind":13},{"line":101,"kind":13,"name":"$self","containerName":"new"},{"kind":12,"line":101,"name":"_rearrange","containerName":"new"},{"containerName":"new","name":"@args","line":101,"kind":13},{"name":"$type","containerName":"new","line":102,"kind":13},{"name":"$type","containerName":"new","kind":13,"line":103},{"name":"$self","containerName":"new","line":105,"kind":13},{"containerName":"new","name":"type","kind":12,"line":105},{"name":"$type","containerName":"new","line":105,"kind":13},{"line":106,"kind":13,"name":"$self","containerName":"new"}],"line":98},{"containerName":"new","name":"SUPER","kind":12,"line":100},{"name":"create","range":{"end":{"line":129,"character":9999},"start":{"character":0,"line":126}},"kind":12,"line":126,"children":[{"localvar":"my","containerName":"create","name":"$self","definition":"my","line":127,"kind":13},{"line":127,"kind":13,"containerName":"create","name":"@args"},{"name":"$self","containerName":"create","line":128,"kind":13},{"line":128,"kind":12,"containerName":"create","name":"type"},{"containerName":"create","name":"new","line":128,"kind":12},{"name":"$self","containerName":"create","line":128,"kind":13},{"kind":12,"line":128,"containerName":"create","name":"verbose"},{"line":128,"kind":13,"containerName":"create","name":"@args"}],"containerName":"main::","definition":"sub","detail":"($self,@args)","signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: SeqFactory.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Seq::SeqFactory\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::SeqFactory - Instantiates a new Bio::PrimarySeqI (or derived class) through a factory\n\n=head1 SYNOPSIS\n\n    use Bio::Seq::SeqFactory;\n    my $factory = Bio::Seq::SeqFactory->new();\n    my $seq = $factory->create(-seq => 'WYRAVLC',\n\t\t\t       -id  => 'name');\n\n    # If you want the factory to create Bio::Seq objects instead\n    # of the default Bio::PrimarySeq objects, use the -type parameter:\n\n    my $factory = Bio::Seq::SeqFactory->new(-type => 'Bio::Seq');\n\n\n=head1 DESCRIPTION\n\nThis object will build L<Bio::PrimarySeqI> and L<Bio::SeqI> objects\ngenerically.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Seq::SeqFactory;\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Factory::SequenceFactoryI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Seq::SeqFactory->new();\n Function: Builds a new Bio::Seq::SeqFactory object \n Returns : Bio::Seq::SeqFactory\n Args    : -type => string, name of a PrimarySeqI derived class\n                    This is optional. Default=Bio::PrimarySeq.\n\n\nsub new {\n  my($class,@args) = @_;\n  my $self = $class->SUPER::new(@args);\n  my ($type) = $self->_rearrange([qw(TYPE)], @args);\n  if( ! defined $type ) { \n      $type = 'Bio::PrimarySeq';\n  }\n  $self->type($type);\n  return $self;\n}\n\n\n=head2 create\n\n Title   : create\n Usage   : my $seq = $seqbuilder->create(-seq => 'CAGT', -id => 'name');\n Function: Instantiates new Bio::SeqI (or one of its child classes)\n           This object allows us to genericize the instantiation of sequence\n           objects.\n Returns : Bio::PrimarySeq object (default)\n           The return type is configurable using new(-type =>\"...\").\n Args    : initialization parameters specific to the type of sequence\n           object we want.  Typically \n           -seq        => $str,\n           -display_id => $name","label":"create($self,@args)"}},{"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: SeqFactory.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Seq::SeqFactory\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::SeqFactory - Instantiates a new Bio::PrimarySeqI (or derived class) through a factory\n\n=head1 SYNOPSIS\n\n    use Bio::Seq::SeqFactory;\n    my $factory = Bio::Seq::SeqFactory->new();\n    my $seq = $factory->create(-seq => 'WYRAVLC',\n\t\t\t       -id  => 'name');\n\n    # If you want the factory to create Bio::Seq objects instead\n    # of the default Bio::PrimarySeq objects, use the -type parameter:\n\n    my $factory = Bio::Seq::SeqFactory->new(-type => 'Bio::Seq');\n\n\n=head1 DESCRIPTION\n\nThis object will build L<Bio::PrimarySeqI> and L<Bio::SeqI> objects\ngenerically.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Seq::SeqFactory;\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Factory::SequenceFactoryI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Seq::SeqFactory->new();\n Function: Builds a new Bio::Seq::SeqFactory object \n Returns : Bio::Seq::SeqFactory\n Args    : -type => string, name of a PrimarySeqI derived class\n                    This is optional. Default=Bio::PrimarySeq.\n\n\nsub new {\n  my($class,@args) = @_;\n  my $self = $class->SUPER::new(@args);\n  my ($type) = $self->_rearrange([qw(TYPE)], @args);\n  if( ! defined $type ) { \n      $type = 'Bio::PrimarySeq';\n  }\n  $self->type($type);\n  return $self;\n}\n\n\n=head2 create\n\n Title   : create\n Usage   : my $seq = $seqbuilder->create(-seq => 'CAGT', -id => 'name');\n Function: Instantiates new Bio::SeqI (or one of its child classes)\n           This object allows us to genericize the instantiation of sequence\n           objects.\n Returns : Bio::PrimarySeq object (default)\n           The return type is configurable using new(-type =>\"...\").\n Args    : initialization parameters specific to the type of sequence\n           object we want.  Typically \n           -seq        => $str,\n           -display_id => $name\n\n\nsub create {\n   my ($self,@args) = @_;\n   return $self->type->new(-verbose => $self->verbose, @args);\n}\n\n=head2 type\n\n Title   : type\n Usage   : $obj->type($newval)\n Function: \n Returns : value of type\n Args    : newvalue (optional)","label":"type($self,$value)"},"detail":"($self,$value)","kind":12,"children":[{"line":143,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"type"},{"containerName":"type","name":"$value","line":143,"kind":13},{"containerName":"type","name":"$value","kind":13,"line":144},{"name":"$self","containerName":"type","kind":13,"line":146},{"line":146,"kind":12,"name":"throw","containerName":"type"},{"localvar":"my","containerName":"type","name":"$a","definition":"my","line":148,"kind":13},{"containerName":"type","name":"$value","kind":13,"line":148},{"line":149,"kind":13,"name":"$a","containerName":"type"},{"containerName":"type","name":"isa","kind":12,"line":149},{"line":150,"kind":13,"name":"$a","containerName":"type"},{"containerName":"type","name":"isa","line":150,"kind":12},{"line":151,"kind":13,"containerName":"type","name":"$self"},{"line":151,"kind":12,"containerName":"type","name":"throw"},{"containerName":"type","name":"$self","kind":13,"line":153},{"name":"$value","containerName":"type","line":153,"kind":13},{"name":"$self","containerName":"type","line":155,"kind":13}],"line":142,"name":"type","range":{"end":{"line":156,"character":9999},"start":{"line":142,"character":0}}}],"version":5}