{"version":5,"vars":[{"name":"vars","containerName":"","line":159,"kind":2},{"kind":2,"line":161,"name":"base","containerName":""},{"name":"@RES","containerName":null,"line":164,"kind":13},{"containerName":null,"name":"$attr","definition":"my","localvar":"my","kind":13,"line":165},{"line":165,"kind":13,"name":"@RES","containerName":null},{"line":165,"kind":13,"name":"%OK_FIELD","containerName":null},{"containerName":null,"name":"$attr","kind":13,"line":165},{"containerName":null,"name":"$ID","line":168,"kind":13},{"name":"AUTOLOAD","definition":"sub","containerName":"main::","range":{"end":{"line":177,"character":9999},"start":{"character":0,"line":170}},"kind":12,"children":[{"containerName":"AUTOLOAD","name":"$self","definition":"my","localvar":"my","kind":13,"line":171},{"kind":13,"line":172,"containerName":"AUTOLOAD","definition":"my","name":"$attr","localvar":"my"},{"containerName":"AUTOLOAD","name":"$AUTOLOAD","kind":13,"line":172},{"name":"$attr","containerName":"AUTOLOAD","line":173,"kind":13},{"kind":13,"line":174,"name":"$self","containerName":"AUTOLOAD"},{"name":"throw","containerName":"AUTOLOAD","line":174,"kind":12},{"kind":13,"line":174,"containerName":"AUTOLOAD","name":"$OK_FIELD"},{"kind":13,"line":174,"containerName":"AUTOLOAD","name":"$attr"},{"kind":13,"line":175,"name":"$self","containerName":"AUTOLOAD"},{"name":"$attr","containerName":"AUTOLOAD","line":175,"kind":13},{"kind":13,"line":176,"containerName":"AUTOLOAD","name":"$self"},{"containerName":"AUTOLOAD","name":"$attr","line":176,"kind":13}],"line":170},{"name":"new","range":{"end":{"character":9999,"line":228},"start":{"line":199,"character":0}},"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$class"},{"label":"%args"}],"documentation":"1;\n# $Id: PrimedSeq.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# This is the original copyright statement. I have relied on Chad's module\n# extensively for this module.\n#\n# Copyright (c) 1997-2001 bioperl, Chad Matsalla. All Rights Reserved.\n#           This module is free software; you can redistribute it and/or\n#           modify it under the same terms as Perl itself. \n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n#\n# But I have modified lots of it, so I guess I should add:\n#\n# Copyright (c) 2003 bioperl, Rob Edwards. All Rights Reserved.\n#           This module is free software; you can redistribute it and/or\n#           modify it under the same terms as Perl itself. \n#\n# Copyright Rob Edwards\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n\n=head1 NAME\n\nBio::Seq::PrimedSeq - A representation of a sequence and two primers \nflanking a target region\n\n=head1 SYNOPSIS\n\n  # The easiest way to use this is probably either, (i), get the\n  # output from Bio::Tools::Run::Primer3, Bio::Tools::Primer3, or \n  # Bio::Tools::PCRSimulation:\n\n      # For example, start with a fasta file\n      use Bio::SeqIO;\n      use Bio::Tools::Run::Primer3;\n\n      my $file = shift || die \"need a file to read\";\n      my $seqin = Bio::SeqIO->new(-file => $file);\n      my $seq = $seqin->next_seq;\n\n      # use primer3 to design some primers\n      my $primer3run = Bio::Tools::Run::Primer3->new(-seq => $seq);\n      $primer3run -> run; # run it with the default parameters\n\n      # create a file to write the results to\n      my $seqout = Bio::SeqIO->new(-file => \">primed_sequence.gbk\", \n                                   -format => 'genbank');\n\n      # now just get all the results and write them out.\n      while (my $results = $primer3run->next_primer) {\n         $seqout->write_seq($results->annotated_seq);\n      }\n\n  # Or, (ii), to create a genbank file for a sequence and its cognate\n  # primers:\n\n     use Bio::SeqIO;\n     use Bio::Seq::PrimedSeq;\n\n     # have a sequence file ($file) with the template, and two primers\n     # that match it, in fasta format\n\n     my $file = shift || die \"$0 <file>\";\n     my $seqin = Bio::SeqIO->new(-file => $file);\n\n     # read three sequences\n     my ($template, $leftprimer, $rightprimer) =\n           ($seqin->next_seq, $seqin->next_seq, $seqin->next_seq);\n     # set up the primed sequence object\n     my $primedseq = Bio::Seq::PrimedSeq->new(-seq => $template, \n                                              -left_primer => $leftprimer,\n                                              -right_primer => $rightprimer);\n     # open a file for output\n     my $seqout = Bio::SeqIO->new(-file => \">primed_sequence.gbk\",\n                                  -format => 'genbank');\n     # print the sequence out\n     $seqout->write_seq($primedseq->annotated_sequence);\n\n  # This should output a genbank file with the two primers labeled.\n\n=head1 DESCRIPTION\n\nThis module is a slightly glorified capsule containing a primed sequence. \nIt was created to address the fact that a primer is more than a seqfeature \nand there need to be ways to represent the primer-sequence complex and \nthe behaviors and attributes that are associated with the complex.\n\nThe primers are represented as Bio::SeqFeature::Primer objects, and should\nbe instantiated first.\n\nA simple way to create a PrimedSeq object is as follows:\n\n  my $primedseq = Bio::Seq::PrimedSeq->new(\n          -seq          => $seq,  # Bio::Seq object,\n          -left_primer  => $left, # Bio::SeqFeature::Primer object,\n          -right_primer => $right # Bio::SeqFeature::Primer object,\n  );\n\nFrom the PrimedSeq object you should be able to retrieve\ninformation about melting temperatures and what not on each of the primers \nand the amplicon.\n\nThis is based on the PrimedSeq.pm module started by Chad Matsalla, with \nadditions/improvements by Rob Edwards.\n\n=head1 FEEDBACK\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nRob Edwards, redwards@utmem.edu\n\nBased on a module written by Chad Matsalla, bioinformatics1@dieselwurks.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Seq::PrimedSeq;\n\nuse strict;\nuse Bio::SeqFeature::Primer;\n\nuse vars qw ($AUTOLOAD @RES %OK_FIELD $ID);\n\nuse base qw(Bio::Root::Root Bio::SeqFeature::Generic);\n\nBEGIN {\n @RES = qw(); # nothing here yet, not sure what we want!\n foreach my $attr (@RES) {$OK_FIELD{$attr}++}\n}\n\n$ID = 'Bio::Tools::Analysis::Nucleotide::PrimedSeq';\n\nsub AUTOLOAD {\n my $self = shift;\n my $attr = $AUTOLOAD;\n $attr =~ s/.*:://;\n $self->throw(\"Unallowed parameter: $attr !\") unless $OK_FIELD{$attr};\n $self->{$attr} = shift if @_;\n return $self->{$attr};\n}\n\n\n=head2 new\n\n Title   : new()\n Usage   : $primed_sequence = Bio::SeqFeature::Primer->new( \n                                     -seq => $sequence,\n                                     -left_primer => $left_primer,\n                                     -right_primer => $right_primer);\n Function: A constructor for an object representing a primed sequence \n Returns : A Bio::Seq::PrimedSeq object\n Args    :  -seq => a Bio::Seq object (required)\n            -left_primer => a Bio::SeqFeature::Primer object (required)\n            -right_primer => a Bio::SeqFeature::Primer object (required)\n\n           Many other parameters can be included including all of the output\n           parameters from the primer3 program. At the moment most of these\n           parameters will not do anything.","label":"new($class,%args)"},"detail":"($class,%args)","kind":12,"children":[{"line":205,"kind":13,"localvar":"my","containerName":"new","name":"$class","definition":"my"},{"containerName":"new","name":"%args","line":205,"kind":13},{"kind":13,"line":206,"containerName":"new","name":"$self","definition":"my","localvar":"my"},{"line":206,"kind":13,"name":"$class","containerName":"new"},{"name":"%args","containerName":"new","line":206,"kind":13},{"definition":"my","name":"$key","containerName":"new","localvar":"my","kind":13,"line":210},{"containerName":"new","name":"%args","kind":13,"line":210},{"name":"$key","containerName":"new","line":211,"kind":13},{"name":"$self","containerName":"new","kind":13,"line":212},{"containerName":"new","name":"$args","line":212,"kind":13},{"kind":13,"line":212,"containerName":"new","name":"$key"},{"kind":13,"line":215,"name":"$okey","definition":"my","containerName":"new","localvar":"my"},{"containerName":"new","name":"$okey","kind":13,"line":216},{"containerName":"new","name":"$key","line":216,"kind":13},{"containerName":"new","name":"$okey","line":217,"kind":13},{"kind":13,"line":217,"containerName":"new","name":"$okey"},{"name":"$args","containerName":"new","kind":13,"line":218},{"containerName":"new","name":"$key","kind":13,"line":218},{"line":218,"kind":13,"name":"$args","containerName":"new"},{"containerName":"new","name":"$key","kind":13,"line":218},{"kind":12,"line":218,"name":"isa","containerName":"new"},{"name":"$self","containerName":"new","line":221,"kind":13},{"name":"$okey","containerName":"new","line":221,"kind":13},{"containerName":"new","name":"new","line":221,"kind":12},{"kind":13,"line":221,"containerName":"new","name":"$args"},{"kind":13,"line":221,"name":"$key","containerName":"new"},{"kind":13,"line":222,"containerName":"new","name":"$self"},{"name":"$okey","containerName":"new","line":222,"kind":13},{"kind":13,"line":226,"containerName":"new","name":"$self"},{"containerName":"new","name":"$okey","line":226,"kind":13},{"line":226,"kind":13,"name":"$args","containerName":"new"},{"containerName":"new","name":"$key","kind":13,"line":226},{"line":227,"kind":13,"containerName":"new","name":"$self"},{"line":227,"kind":13,"name":"$okey","containerName":"new"}],"line":199},{"kind":12,"line":206,"name":"SUPER","containerName":"new"},{"name":"target_sequence","kind":12,"line":212},{"containerName":"SeqFeature::Primer","name":"Bio","line":221,"kind":12},{"kind":13,"line":231,"name":"%self","containerName":null},{"kind":12,"line":231,"name":"target_sequence"},{"name":"%self","containerName":null,"kind":13,"line":231},{"name":"left_primer","kind":12,"line":231},{"line":232,"kind":13,"name":"%self","containerName":null},{"line":232,"kind":12,"name":"right_primer"},{"containerName":null,"name":"$self","line":233,"kind":13},{"line":233,"kind":12,"name":"throw","containerName":"main::"},{"containerName":null,"name":"%self","line":236,"kind":13},{"kind":12,"line":236,"name":"target_sequence"},{"containerName":null,"name":"%self","line":237,"kind":13},{"name":"target_sequence","line":237,"kind":12},{"name":"isa","containerName":"main::","line":237,"kind":12},{"kind":13,"line":238,"containerName":null,"name":"$self"},{"line":238,"kind":12,"containerName":"main::","name":"throw"},{"kind":13,"line":240,"name":"%self","containerName":null},{"line":240,"kind":12,"name":"left_primer"},{"containerName":null,"name":"%self","kind":13,"line":241},{"kind":12,"line":241,"name":"left_primer"},{"containerName":"main::","name":"isa","line":241,"kind":12},{"kind":13,"line":242,"containerName":null,"name":"%self"},{"name":"right_primer","kind":12,"line":242},{"line":243,"kind":13,"name":"%self","containerName":null},{"line":243,"kind":12,"name":"right_primer"},{"name":"isa","containerName":"main::","line":243,"kind":12},{"containerName":null,"name":"$self","line":244,"kind":13},{"containerName":"main::","name":"throw","kind":12,"line":244},{"name":"$self","containerName":null,"line":248,"kind":13},{"line":248,"kind":12,"name":"_place_seqs","containerName":"main::"},{"line":249,"kind":13,"containerName":null,"name":"$self"},{"line":275,"children":[{"definition":"my","name":"$self","containerName":"get_primer","localvar":"my","kind":13,"line":276},{"line":276,"kind":13,"name":"$arg","containerName":"get_primer"},{"name":"$arg","containerName":"get_primer","line":277,"kind":13},{"kind":13,"line":278,"containerName":"get_primer","name":"$self"},{"kind":13,"line":278,"name":"$self","containerName":"get_primer"},{"name":"$arg","containerName":"get_primer","kind":13,"line":279},{"containerName":"get_primer","name":"$arg","kind":13,"line":279},{"line":282,"kind":13,"containerName":"get_primer","name":"$self"},{"kind":13,"line":284,"name":"$arg","containerName":"get_primer"},{"name":"$arg","containerName":"get_primer","kind":13,"line":284},{"containerName":"get_primer","name":"$self","kind":13,"line":284},{"line":285,"kind":13,"containerName":"get_primer","name":"$arg"},{"kind":13,"line":285,"name":"$arg","containerName":"get_primer"},{"line":285,"kind":13,"containerName":"get_primer","name":"$self"},{"containerName":"get_primer","name":"$self","kind":13,"line":285}],"kind":12,"detail":"()","signature":{"label":"get_primer()","parameters":[],"documentation":"1;\n# $Id: PrimedSeq.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# This is the original copyright statement. I have relied on Chad's module\n# extensively for this module.\n#\n# Copyright (c) 1997-2001 bioperl, Chad Matsalla. All Rights Reserved.\n#           This module is free software; you can redistribute it and/or\n#           modify it under the same terms as Perl itself. \n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n#\n# But I have modified lots of it, so I guess I should add:\n#\n# Copyright (c) 2003 bioperl, Rob Edwards. All Rights Reserved.\n#           This module is free software; you can redistribute it and/or\n#           modify it under the same terms as Perl itself. \n#\n# Copyright Rob Edwards\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n\n=head1 NAME\n\nBio::Seq::PrimedSeq - A representation of a sequence and two primers \nflanking a target region\n\n=head1 SYNOPSIS\n\n  # The easiest way to use this is probably either, (i), get the\n  # output from Bio::Tools::Run::Primer3, Bio::Tools::Primer3, or \n  # Bio::Tools::PCRSimulation:\n\n      # For example, start with a fasta file\n      use Bio::SeqIO;\n      use Bio::Tools::Run::Primer3;\n\n      my $file = shift || die \"need a file to read\";\n      my $seqin = Bio::SeqIO->new(-file => $file);\n      my $seq = $seqin->next_seq;\n\n      # use primer3 to design some primers\n      my $primer3run = Bio::Tools::Run::Primer3->new(-seq => $seq);\n      $primer3run -> run; # run it with the default parameters\n\n      # create a file to write the results to\n      my $seqout = Bio::SeqIO->new(-file => \">primed_sequence.gbk\", \n                                   -format => 'genbank');\n\n      # now just get all the results and write them out.\n      while (my $results = $primer3run->next_primer) {\n         $seqout->write_seq($results->annotated_seq);\n      }\n\n  # Or, (ii), to create a genbank file for a sequence and its cognate\n  # primers:\n\n     use Bio::SeqIO;\n     use Bio::Seq::PrimedSeq;\n\n     # have a sequence file ($file) with the template, and two primers\n     # that match it, in fasta format\n\n     my $file = shift || die \"$0 <file>\";\n     my $seqin = Bio::SeqIO->new(-file => $file);\n\n     # read three sequences\n     my ($template, $leftprimer, $rightprimer) =\n           ($seqin->next_seq, $seqin->next_seq, $seqin->next_seq);\n     # set up the primed sequence object\n     my $primedseq = Bio::Seq::PrimedSeq->new(-seq => $template, \n                                              -left_primer => $leftprimer,\n                                              -right_primer => $rightprimer);\n     # open a file for output\n     my $seqout = Bio::SeqIO->new(-file => \">primed_sequence.gbk\",\n                                  -format => 'genbank');\n     # print the sequence out\n     $seqout->write_seq($primedseq->annotated_sequence);\n\n  # This should output a genbank file with the two primers labeled.\n\n=head1 DESCRIPTION\n\nThis module is a slightly glorified capsule containing a primed sequence. \nIt was created to address the fact that a primer is more than a seqfeature \nand there need to be ways to represent the primer-sequence complex and \nthe behaviors and attributes that are associated with the complex.\n\nThe primers are represented as Bio::SeqFeature::Primer objects, and should\nbe instantiated first.\n\nA simple way to create a PrimedSeq object is as follows:\n\n  my $primedseq = Bio::Seq::PrimedSeq->new(\n          -seq          => $seq,  # Bio::Seq object,\n          -left_primer  => $left, # Bio::SeqFeature::Primer object,\n          -right_primer => $right # Bio::SeqFeature::Primer object,\n  );\n\nFrom the PrimedSeq object you should be able to retrieve\ninformation about melting temperatures and what not on each of the primers \nand the amplicon.\n\nThis is based on the PrimedSeq.pm module started by Chad Matsalla, with \nadditions/improvements by Rob Edwards.\n\n=head1 FEEDBACK\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nRob Edwards, redwards@utmem.edu\n\nBased on a module written by Chad Matsalla, bioinformatics1@dieselwurks.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Seq::PrimedSeq;\n\nuse strict;\nuse Bio::SeqFeature::Primer;\n\nuse vars qw ($AUTOLOAD @RES %OK_FIELD $ID);\n\nuse base qw(Bio::Root::Root Bio::SeqFeature::Generic);\n\nBEGIN {\n @RES = qw(); # nothing here yet, not sure what we want!\n foreach my $attr (@RES) {$OK_FIELD{$attr}++}\n}\n\n$ID = 'Bio::Tools::Analysis::Nucleotide::PrimedSeq';\n\nsub AUTOLOAD {\n my $self = shift;\n my $attr = $AUTOLOAD;\n $attr =~ s/.*:://;\n $self->throw(\"Unallowed parameter: $attr !\") unless $OK_FIELD{$attr};\n $self->{$attr} = shift if @_;\n return $self->{$attr};\n}\n\n\n=head2 new\n\n Title   : new()\n Usage   : $primed_sequence = Bio::SeqFeature::Primer->new( \n                                     -seq => $sequence,\n                                     -left_primer => $left_primer,\n                                     -right_primer => $right_primer);\n Function: A constructor for an object representing a primed sequence \n Returns : A Bio::Seq::PrimedSeq object\n Args    :  -seq => a Bio::Seq object (required)\n            -left_primer => a Bio::SeqFeature::Primer object (required)\n            -right_primer => a Bio::SeqFeature::Primer object (required)\n\n           Many other parameters can be included including all of the output\n           parameters from the primer3 program. At the moment most of these\n           parameters will not do anything.\n\n\nsub new {\n\n\t# note, I have cleaned up a lot of the script that Chad had written here,\n\t# and I have removed the part where he removed the - before the tags.\n\t# Very confusing.\n\n\tmy($class,%args) = @_;\n\tmy $self = $class->SUPER::new(%args);\n   # these are the absolute minimum components required to make\n   # a primedseq\n\n\tforeach my $key (keys %args) {\n\t\tif ($key =~  /^-seq/i) {\n\t\t\t$self->{target_sequence} = $args{$key};\n\t\t\tnext;\n\t\t} else {\n\t\t\tmy $okey;\n\t\t\t($okey = $key) =~ s/^-//;\n\t\t\tif (($okey eq \"left_primer\" || $okey eq \"right_primer\") && \n\t\t\t\t ref($args{$key}) && $args{$key}->isa('Bio::SeqI') ) {\n\t\t\t\t# We have been given a Bio::Seq object, \n\t\t\t\t# make it a Bio::SeqFeature::Primer object\n\t\t\t\t$self->{$okey} = Bio::SeqFeature::Primer->new(-seq => $args{$key});\n\t\t\t\tpush @{$self->{'arguments'}},$okey;\n\t\t\t\tnext;\n\t\t\t}\n\n\t\t\t$self->{$okey} = $args{$key};\n\t\t\tpush @{$self->{'arguments'}},$okey;\n\t\t}\n\t}\n\t# and now the insurance - make sure that things are ok\n\tif (!$self->{target_sequence} || !$self->{left_primer} || \n\t\t !$self->{right_primer} ) {\n\t\t$self->throw(\"You must provide a -seq, -left_primer, and -right_primer to create this object.\");\n\t}\n  \n\tif (! ref($self->{target_sequence}) ||\n\t\t ! $self->{target_sequence}->isa('Bio::SeqI') ) {\n\t\t$self->throw(\"The target_sequence must be a Bio::Seq to create this object.\");\n }\n\tif (! ref($self->{left_primer}) ||\n\t\t ! $self->{left_primer}->isa(\"Bio::SeqFeature::Primer\") || \n\t\t ! ref($self->{right_primer}) ||\n\t\t ! $self->{right_primer}->isa(\"Bio::SeqFeature::Primer\")) {\n\t\t$self->throw(\"You must provide a left_primer and right_primer, both as Bio::SeqFeature::Primer to create this object.\");\n\t}\n \n\t# now we have the sequences, lets find out where they are\n\t$self->_place_seqs();\n\treturn $self;\n}\n\n\n=head2 get_primer\n\n Title   : get_primer();\n Usage   : $primer = $primedseq->get_primer(l, left, left_primer, \n           -left_primer) to return the left primer or \n\t        $primer = $primedseq->get_primer(r, right, right_primer, \n           -right_primer) to return the right primer or\n\t        $primer = $primedseq->get_primer(b, both, both_primers, \n           -both_primers)\n           to return the left primer, right primer array\n Function: A getter for the left primer in thie PrimedSeq object.\n Returns : A Bio::SeqFeature::Primer object\n Args    : Either of (l, left, left_primer, -left_primer) to get left \n           primer.\n           Either of (r, right, right_primer, -right_primer) to get \n           right primer\n\t        Either of (b, both, both_primers, -both_primers) to get \n           both primers. \n           Note that this is plural. [default]"},"containerName":"main::","definition":"sub","range":{"start":{"line":275,"character":0},"end":{"line":286,"character":9999}},"name":"get_primer"},{"kind":12,"children":[{"line":304,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"annotated_sequence"},{"name":"$self","containerName":"annotated_sequence","kind":13,"line":305},{"containerName":"annotated_sequence","name":"$self","kind":13,"line":305}],"line":303,"definition":"sub","name":"annotated_sequence","containerName":"main::","range":{"start":{"line":303,"character":0},"end":{"character":9999,"line":307}}},{"kind":12,"line":305,"name":"annotated_sequence"},{"kind":12,"line":305,"name":"annotated_sequence"},{"kind":12,"children":[{"localvar":"my","containerName":"amplicon","definition":"my","name":"$self","line":321,"kind":13},{"containerName":"amplicon","name":"@args","line":321,"kind":13},{"localvar":"my","containerName":"amplicon","definition":"my","name":"$id","line":322,"kind":13},{"kind":13,"line":322,"containerName":"amplicon","name":"$self"},{"line":323,"kind":13,"name":"$id","containerName":"amplicon"},{"containerName":"amplicon","name":"$id","kind":13,"line":323},{"line":325,"kind":13,"containerName":"amplicon","name":"$id"},{"name":"$id","containerName":"amplicon","kind":13,"line":325},{"localvar":"my","containerName":"amplicon","definition":"my","name":"$seqobj","line":327,"kind":13},{"kind":12,"line":327,"containerName":"amplicon","name":"new"},{"name":"$id","containerName":"amplicon","kind":13,"line":327},{"line":327,"kind":13,"containerName":"amplicon","name":"$self"},{"name":"$seqobj","containerName":"amplicon","kind":13,"line":328}],"line":320,"definition":"sub","containerName":"main::","signature":{"label":"amplicon($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: PrimedSeq.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# This is the original copyright statement. I have relied on Chad's module\n# extensively for this module.\n#\n# Copyright (c) 1997-2001 bioperl, Chad Matsalla. All Rights Reserved.\n#           This module is free software; you can redistribute it and/or\n#           modify it under the same terms as Perl itself. \n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n#\n# But I have modified lots of it, so I guess I should add:\n#\n# Copyright (c) 2003 bioperl, Rob Edwards. All Rights Reserved.\n#           This module is free software; you can redistribute it and/or\n#           modify it under the same terms as Perl itself. \n#\n# Copyright Rob Edwards\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n\n=head1 NAME\n\nBio::Seq::PrimedSeq - A representation of a sequence and two primers \nflanking a target region\n\n=head1 SYNOPSIS\n\n  # The easiest way to use this is probably either, (i), get the\n  # output from Bio::Tools::Run::Primer3, Bio::Tools::Primer3, or \n  # Bio::Tools::PCRSimulation:\n\n      # For example, start with a fasta file\n      use Bio::SeqIO;\n      use Bio::Tools::Run::Primer3;\n\n      my $file = shift || die \"need a file to read\";\n      my $seqin = Bio::SeqIO->new(-file => $file);\n      my $seq = $seqin->next_seq;\n\n      # use primer3 to design some primers\n      my $primer3run = Bio::Tools::Run::Primer3->new(-seq => $seq);\n      $primer3run -> run; # run it with the default parameters\n\n      # create a file to write the results to\n      my $seqout = Bio::SeqIO->new(-file => \">primed_sequence.gbk\", \n                                   -format => 'genbank');\n\n      # now just get all the results and write them out.\n      while (my $results = $primer3run->next_primer) {\n         $seqout->write_seq($results->annotated_seq);\n      }\n\n  # Or, (ii), to create a genbank file for a sequence and its cognate\n  # primers:\n\n     use Bio::SeqIO;\n     use Bio::Seq::PrimedSeq;\n\n     # have a sequence file ($file) with the template, and two primers\n     # that match it, in fasta format\n\n     my $file = shift || die \"$0 <file>\";\n     my $seqin = Bio::SeqIO->new(-file => $file);\n\n     # read three sequences\n     my ($template, $leftprimer, $rightprimer) =\n           ($seqin->next_seq, $seqin->next_seq, $seqin->next_seq);\n     # set up the primed sequence object\n     my $primedseq = Bio::Seq::PrimedSeq->new(-seq => $template, \n                                              -left_primer => $leftprimer,\n                                              -right_primer => $rightprimer);\n     # open a file for output\n     my $seqout = Bio::SeqIO->new(-file => \">primed_sequence.gbk\",\n                                  -format => 'genbank');\n     # print the sequence out\n     $seqout->write_seq($primedseq->annotated_sequence);\n\n  # This should output a genbank file with the two primers labeled.\n\n=head1 DESCRIPTION\n\nThis module is a slightly glorified capsule containing a primed sequence. \nIt was created to address the fact that a primer is more than a seqfeature \nand there need to be ways to represent the primer-sequence complex and \nthe behaviors and attributes that are associated with the complex.\n\nThe primers are represented as Bio::SeqFeature::Primer objects, and should\nbe instantiated first.\n\nA simple way to create a PrimedSeq object is as follows:\n\n  my $primedseq = Bio::Seq::PrimedSeq->new(\n          -seq          => $seq,  # Bio::Seq object,\n          -left_primer  => $left, # Bio::SeqFeature::Primer object,\n          -right_primer => $right # Bio::SeqFeature::Primer object,\n  );\n\nFrom the PrimedSeq object you should be able to retrieve\ninformation about melting temperatures and what not on each of the primers \nand the amplicon.\n\nThis is based on the PrimedSeq.pm module started by Chad Matsalla, with \nadditions/improvements by Rob Edwards.\n\n=head1 FEEDBACK\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nRob Edwards, redwards@utmem.edu\n\nBased on a module written by Chad Matsalla, bioinformatics1@dieselwurks.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Seq::PrimedSeq;\n\nuse strict;\nuse Bio::SeqFeature::Primer;\n\nuse vars qw ($AUTOLOAD @RES %OK_FIELD $ID);\n\nuse base qw(Bio::Root::Root Bio::SeqFeature::Generic);\n\nBEGIN {\n @RES = qw(); # nothing here yet, not sure what we want!\n foreach my $attr (@RES) {$OK_FIELD{$attr}++}\n}\n\n$ID = 'Bio::Tools::Analysis::Nucleotide::PrimedSeq';\n\nsub AUTOLOAD {\n my $self = shift;\n my $attr = $AUTOLOAD;\n $attr =~ s/.*:://;\n $self->throw(\"Unallowed parameter: $attr !\") unless $OK_FIELD{$attr};\n $self->{$attr} = shift if @_;\n return $self->{$attr};\n}\n\n\n=head2 new\n\n Title   : new()\n Usage   : $primed_sequence = Bio::SeqFeature::Primer->new( \n                                     -seq => $sequence,\n                                     -left_primer => $left_primer,\n                                     -right_primer => $right_primer);\n Function: A constructor for an object representing a primed sequence \n Returns : A Bio::Seq::PrimedSeq object\n Args    :  -seq => a Bio::Seq object (required)\n            -left_primer => a Bio::SeqFeature::Primer object (required)\n            -right_primer => a Bio::SeqFeature::Primer object (required)\n\n           Many other parameters can be included including all of the output\n           parameters from the primer3 program. At the moment most of these\n           parameters will not do anything.\n\n\nsub new {\n\n\t# note, I have cleaned up a lot of the script that Chad had written here,\n\t# and I have removed the part where he removed the - before the tags.\n\t# Very confusing.\n\n\tmy($class,%args) = @_;\n\tmy $self = $class->SUPER::new(%args);\n   # these are the absolute minimum components required to make\n   # a primedseq\n\n\tforeach my $key (keys %args) {\n\t\tif ($key =~  /^-seq/i) {\n\t\t\t$self->{target_sequence} = $args{$key};\n\t\t\tnext;\n\t\t} else {\n\t\t\tmy $okey;\n\t\t\t($okey = $key) =~ s/^-//;\n\t\t\tif (($okey eq \"left_primer\" || $okey eq \"right_primer\") && \n\t\t\t\t ref($args{$key}) && $args{$key}->isa('Bio::SeqI') ) {\n\t\t\t\t# We have been given a Bio::Seq object, \n\t\t\t\t# make it a Bio::SeqFeature::Primer object\n\t\t\t\t$self->{$okey} = Bio::SeqFeature::Primer->new(-seq => $args{$key});\n\t\t\t\tpush @{$self->{'arguments'}},$okey;\n\t\t\t\tnext;\n\t\t\t}\n\n\t\t\t$self->{$okey} = $args{$key};\n\t\t\tpush @{$self->{'arguments'}},$okey;\n\t\t}\n\t}\n\t# and now the insurance - make sure that things are ok\n\tif (!$self->{target_sequence} || !$self->{left_primer} || \n\t\t !$self->{right_primer} ) {\n\t\t$self->throw(\"You must provide a -seq, -left_primer, and -right_primer to create this object.\");\n\t}\n  \n\tif (! ref($self->{target_sequence}) ||\n\t\t ! $self->{target_sequence}->isa('Bio::SeqI') ) {\n\t\t$self->throw(\"The target_sequence must be a Bio::Seq to create this object.\");\n }\n\tif (! ref($self->{left_primer}) ||\n\t\t ! $self->{left_primer}->isa(\"Bio::SeqFeature::Primer\") || \n\t\t ! ref($self->{right_primer}) ||\n\t\t ! $self->{right_primer}->isa(\"Bio::SeqFeature::Primer\")) {\n\t\t$self->throw(\"You must provide a left_primer and right_primer, both as Bio::SeqFeature::Primer to create this object.\");\n\t}\n \n\t# now we have the sequences, lets find out where they are\n\t$self->_place_seqs();\n\treturn $self;\n}\n\n\n=head2 get_primer\n\n Title   : get_primer();\n Usage   : $primer = $primedseq->get_primer(l, left, left_primer, \n           -left_primer) to return the left primer or \n\t        $primer = $primedseq->get_primer(r, right, right_primer, \n           -right_primer) to return the right primer or\n\t        $primer = $primedseq->get_primer(b, both, both_primers, \n           -both_primers)\n           to return the left primer, right primer array\n Function: A getter for the left primer in thie PrimedSeq object.\n Returns : A Bio::SeqFeature::Primer object\n Args    : Either of (l, left, left_primer, -left_primer) to get left \n           primer.\n           Either of (r, right, right_primer, -right_primer) to get \n           right primer\n\t        Either of (b, both, both_primers, -both_primers) to get \n           both primers. \n           Note that this is plural. [default]\n\n\nsub get_primer() {\n my ($self, $arg) = @_;\n if (! defined $arg ) {\n  return ($self->{'left_primer'}, $self->{'right_primer'});\n } elsif( $arg =~ /^l/ || $arg =~ /^-l/) { \n  # what a cheat, I couldn't be bothered to write all those or statements!\n  # Hah, now you can write leprechaun to get the left primer.\n  return $self->{'left_primer'}\n }\n elsif ($arg =~ /^r/ || $arg =~ /^-r/) {return $self->{'right_primer'}}\n elsif ($arg =~ /^b/ || $arg =~ /^-b/) {return ($self->{'left_primer'}, $self->{'right_primer'})}\n}\n\n\n\n=head2 annotated_sequence\n\n Title   : annotated_sequence\n Usage   : $annotated_sequence_object = $primedseq->annotated_sequence()\n Function: Get an annotated sequence object containg the left and right \n           primers\n Returns : An annotated sequence object or 0 if not defined.\n Args    : \n Note    : Use this method to return a sequence object that you can write\n           out (e.g. in GenBank format). See the example above.\n\n\nsub annotated_sequence {\n  my $self = shift;\n  if (exists $self->{annotated_sequence}) {return $self->{annotated_sequence}}\n  else {return 0}\n}\n\n=head2 amplicon\n\n Title   : amplicon\n Usage   : my $amplicon = $primedseq->amplicon()\n Function: Retrieve the amplicon as a sequence object\n Returns : A seq object. To get the sequence use $amplicon->seq\n Args    : None\n Note    : "},"detail":"($self,@args)","name":"amplicon","range":{"start":{"line":320,"character":0},"end":{"line":329,"character":9999}}},{"name":"Bio","containerName":"Seq","line":327,"kind":12},{"name":"seq","kind":12,"line":327},{"line":343,"children":[{"line":344,"kind":13,"localvar":"my","containerName":"seq","name":"$self","definition":"my"},{"name":"$self","containerName":"seq","kind":13,"line":345}],"kind":12,"range":{"start":{"character":0,"line":343},"end":{"character":9999,"line":346}},"containerName":"main::","name":"seq","definition":"sub"},{"name":"target_sequence","kind":12,"line":345},{"range":{"start":{"character":0,"line":360},"end":{"line":428,"character":9999}},"containerName":"main::","definition":"sub","name":"_place_seqs","line":360,"children":[{"kind":13,"line":361,"containerName":"_place_seqs","definition":"my","name":"$self","localvar":"my"},{"kind":13,"line":364,"name":"$target_sequence","definition":"my","containerName":"_place_seqs","localvar":"my"},{"kind":13,"line":364,"containerName":"_place_seqs","name":"$self"},{"containerName":"_place_seqs","name":"seq","line":364,"kind":12},{"localvar":"my","name":"$left_seq","definition":"my","containerName":"_place_seqs","line":367,"kind":13},{"line":367,"kind":13,"containerName":"_place_seqs","name":"$self"},{"name":"seq","containerName":"_place_seqs","kind":12,"line":367},{"containerName":"_place_seqs","name":"seq","kind":12,"line":367},{"localvar":"my","definition":"my","name":"$rprc","containerName":"_place_seqs","line":369,"kind":13},{"containerName":"_place_seqs","name":"$self","kind":13,"line":369},{"name":"seq","containerName":"_place_seqs","kind":12,"line":369},{"kind":12,"line":369,"name":"revcom","containerName":"_place_seqs"},{"kind":13,"line":371,"containerName":"_place_seqs","definition":"my","name":"$right_seq","localvar":"my"},{"line":371,"kind":13,"name":"$rprc","containerName":"_place_seqs"},{"containerName":"_place_seqs","name":"seq","line":371,"kind":12},{"name":"$target_sequence","containerName":"_place_seqs","kind":13,"line":374},{"line":374,"kind":13,"containerName":"_place_seqs","name":"$target_sequence"},{"containerName":"_place_seqs","name":"$left_seq","kind":13,"line":375},{"line":375,"kind":13,"containerName":"_place_seqs","name":"$left_seq"},{"containerName":"_place_seqs","name":"$right_seq","kind":13,"line":376},{"containerName":"_place_seqs","name":"$right_seq","line":376,"kind":13},{"containerName":"_place_seqs","name":"$target_sequence","line":378,"kind":13},{"containerName":"_place_seqs","name":"$target_sequence","line":379,"kind":13},{"containerName":"_place_seqs","name":"$self","kind":13,"line":379},{"kind":12,"line":379,"containerName":"_place_seqs","name":"throw"},{"containerName":"_place_seqs","name":"$target_sequence","line":380,"kind":13},{"name":"$self","containerName":"_place_seqs","kind":13,"line":380},{"line":380,"kind":12,"name":"throw","containerName":"_place_seqs"},{"containerName":"_place_seqs","name":"$before","definition":"my","localvar":"my","kind":13,"line":383},{"kind":13,"line":383,"name":"$middle","containerName":"_place_seqs"},{"line":383,"kind":13,"containerName":"_place_seqs","name":"$after"},{"line":388,"kind":13,"localvar":"my","definition":"my","name":"$left_location","containerName":"_place_seqs"},{"kind":13,"line":388,"name":"$before","containerName":"_place_seqs"},{"containerName":"_place_seqs","name":"$left_seq","kind":13,"line":388},{"kind":13,"line":389,"definition":"my","name":"$right_location","containerName":"_place_seqs","localvar":"my"},{"kind":13,"line":389,"containerName":"_place_seqs","name":"$target_sequence"},{"line":389,"kind":13,"name":"$after","containerName":"_place_seqs"},{"containerName":"_place_seqs","name":"$right_seq","kind":13,"line":389},{"localvar":"my","name":"$amplicon_size","definition":"my","containerName":"_place_seqs","line":390,"kind":13},{"kind":13,"line":390,"name":"$left_seq","containerName":"_place_seqs"},{"name":"$middle","containerName":"_place_seqs","kind":13,"line":390},{"line":390,"kind":13,"name":"$right_seq","containerName":"_place_seqs"},{"name":"$self","containerName":"_place_seqs","line":392,"kind":13},{"line":395,"kind":13,"name":"$self","containerName":"_place_seqs"},{"name":"$left_location","containerName":"_place_seqs","line":395,"kind":13},{"line":396,"kind":13,"containerName":"_place_seqs","name":"$self"},{"kind":12,"line":396,"containerName":"_place_seqs","name":"warn"},{"line":396,"kind":13,"name":"$self","containerName":"_place_seqs"},{"name":"$self","containerName":"_place_seqs","kind":13,"line":400},{"kind":13,"line":400,"name":"$left_location","containerName":"_place_seqs"},{"name":"$self","containerName":"_place_seqs","kind":13,"line":403},{"containerName":"_place_seqs","name":"$self","kind":13,"line":406},{"name":"$right_location","containerName":"_place_seqs","line":406,"kind":13},{"kind":13,"line":407,"name":"$self","containerName":"_place_seqs"},{"containerName":"_place_seqs","name":"warn","line":407,"kind":12},{"kind":13,"line":407,"containerName":"_place_seqs","name":"$self"},{"line":411,"kind":13,"containerName":"_place_seqs","name":"$self"},{"name":"$right_location","containerName":"_place_seqs","line":411,"kind":13},{"kind":13,"line":414,"containerName":"_place_seqs","name":"$self"},{"line":417,"kind":13,"containerName":"_place_seqs","name":"$self"},{"name":"$amplicon_size","containerName":"_place_seqs","kind":13,"line":417},{"containerName":"_place_seqs","name":"$self","kind":13,"line":418},{"kind":12,"line":418,"containerName":"_place_seqs","name":"warn"},{"name":"$self","containerName":"_place_seqs","line":418,"kind":13},{"kind":13,"line":422,"containerName":"_place_seqs","name":"$self"},{"line":422,"kind":13,"name":"$amplicon_size","containerName":"_place_seqs"},{"containerName":"_place_seqs","name":"$self","line":425,"kind":13},{"containerName":"_place_seqs","name":"$left_seq","kind":13,"line":425},{"name":"$middle","containerName":"_place_seqs","line":425,"kind":13},{"line":425,"kind":13,"containerName":"_place_seqs","name":"$right_seq"},{"name":"$self","containerName":"_place_seqs","kind":13,"line":427},{"containerName":"_place_seqs","name":"_set_seqfeature","line":427,"kind":12}],"kind":12},{"range":{"start":{"line":446,"character":0},"end":{"character":9999,"line":475}},"containerName":"main::","name":"_set_seqfeature","definition":"sub","line":446,"children":[{"containerName":"_set_seqfeature","definition":"my","name":"$self","localvar":"my","kind":13,"line":447},{"name":"$self","containerName":"_set_seqfeature","line":448,"kind":13},{"line":449,"kind":13,"name":"$self","containerName":"_set_seqfeature"},{"kind":13,"line":450,"name":"$self","containerName":"_set_seqfeature"},{"kind":12,"line":450,"containerName":"_set_seqfeature","name":"warn"},{"containerName":"_set_seqfeature","definition":"my","name":"$start","localvar":"my","kind":13,"line":453},{"name":"$length","containerName":"_set_seqfeature","line":453,"kind":13},{"line":453,"kind":13,"containerName":"_set_seqfeature","name":"$self"},{"localvar":"my","definition":"my","name":"$tm","containerName":"_set_seqfeature","line":454,"kind":13},{"containerName":"_set_seqfeature","name":"$self","kind":13,"line":454},{"line":454,"kind":13,"containerName":"_set_seqfeature","name":"$self"},{"line":454,"kind":12,"containerName":"_set_seqfeature","name":"Tm"},{"kind":13,"line":456,"containerName":"_set_seqfeature","definition":"my","name":"$seqfeatureL","localvar":"my"},{"name":"new","containerName":"_set_seqfeature","kind":12,"line":456},{"kind":13,"line":457,"containerName":"_set_seqfeature","name":"$start"},{"name":"$start","containerName":"_set_seqfeature","kind":13,"line":457},{"kind":13,"line":457,"name":"$length","containerName":"_set_seqfeature"},{"name":"$tm","containerName":"_set_seqfeature","kind":13,"line":459},{"kind":13,"line":462,"containerName":"_set_seqfeature","name":"$start"},{"kind":13,"line":462,"name":"$length","containerName":"_set_seqfeature"},{"containerName":"_set_seqfeature","name":"$self","line":462,"kind":13},{"kind":13,"line":463,"name":"$tm","containerName":"_set_seqfeature"},{"line":463,"kind":13,"containerName":"_set_seqfeature","name":"$self"},{"kind":13,"line":463,"containerName":"_set_seqfeature","name":"$self"},{"line":463,"kind":12,"containerName":"_set_seqfeature","name":"Tm"},{"line":465,"kind":13,"localvar":"my","containerName":"_set_seqfeature","definition":"my","name":"$seqfeatureR"},{"kind":12,"line":465,"containerName":"_set_seqfeature","name":"new"},{"line":466,"kind":13,"name":"$start","containerName":"_set_seqfeature"},{"kind":13,"line":466,"containerName":"_set_seqfeature","name":"$length"},{"containerName":"_set_seqfeature","name":"$start","kind":13,"line":466},{"kind":13,"line":468,"containerName":"_set_seqfeature","name":"$tm"},{"containerName":"_set_seqfeature","name":"$self","kind":13,"line":472},{"line":472,"kind":13,"name":"$self","containerName":"_set_seqfeature"},{"kind":13,"line":473,"containerName":"_set_seqfeature","name":"$self"},{"name":"add_SeqFeature","containerName":"_set_seqfeature","kind":12,"line":473},{"name":"$seqfeatureL","containerName":"_set_seqfeature","kind":13,"line":473},{"line":474,"kind":13,"containerName":"_set_seqfeature","name":"$self"},{"name":"add_SeqFeature","containerName":"_set_seqfeature","line":474,"kind":12},{"name":"$seqfeatureR","containerName":"_set_seqfeature","line":474,"kind":13}],"kind":12},{"line":456,"kind":12,"name":"Bio","containerName":"SeqFeature::Generic"},{"name":"new","line":459,"kind":12},{"kind":12,"line":459,"name":"author"},{"line":459,"kind":12,"name":"Tm"},{"line":465,"kind":12,"name":"Bio","containerName":"SeqFeature::Generic"},{"line":468,"kind":12,"name":"new"},{"name":"author","kind":12,"line":468},{"line":468,"kind":12,"name":"Tm"},{"line":472,"kind":12,"name":"annotated_sequence"},{"kind":12,"line":472,"name":"target_sequence"},{"name":"annotated_sequence","kind":12,"line":473},{"name":"annotated_sequence","line":474,"kind":12}]}