{"vars":[{"name":"base","containerName":"","line":158,"kind":2},{"range":{"start":{"line":225,"character":0},"end":{"character":9999,"line":237}},"name":"new","children":[{"localvar":"my","definition":"my","name":"$self","containerName":"new","line":227,"kind":13},{"line":227,"kind":13,"name":"@args","containerName":"new"},{"containerName":"new","name":"$self","line":228,"kind":13},{"containerName":"new","name":"$self","line":228,"kind":13},{"name":"@args","containerName":"new","line":228,"kind":13},{"localvar":"my","name":"$enc","definition":"my","containerName":"new","line":229,"kind":13},{"name":"$self","containerName":"new","kind":13,"line":229},{"name":"_rearrange","containerName":"new","kind":12,"line":229},{"name":"@args","containerName":"new","kind":13,"line":229},{"kind":13,"line":231,"name":"$enc","containerName":"new"},{"containerName":"new","name":"$self","line":232,"kind":13},{"name":"encoding","containerName":"new","kind":12,"line":232},{"containerName":"new","name":"$enc","kind":13,"line":232},{"line":234,"kind":13,"name":"$self","containerName":"new"},{"line":234,"kind":12,"containerName":"new","name":"_recheck_encoding"},{"containerName":"new","name":"$self","line":236,"kind":13}],"line":225,"kind":12,"signature":{"label":"new($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: EncodedSeq.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Seq::EncodedSeq\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Aaron Mackey\n#\n# Copyright Aaron Mackey\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::EncodedSeq - subtype of L<Bio::LocatableSeq|Bio::LocatableSeq> to store DNA that encodes a protein\n\n=head1 SYNOPSIS\n\n  $obj = Bio::Seq::EncodedSeq->new(-seq => $dna,\n                                  -encoding => \"CCCCCCCIIIIICCCCC\",\n                                  -start => 1,\n                                  -strand => 1,\n                                  -length => 17);\n\n  # splice out (and possibly revcomp) the coding sequence\n  $cds = obj->cds;\n\n  # obtain the protein translation of the sequence\n  $prot = $obj->translate;\n\n  # other access/inspection routines as with Bio::LocatableSeq and\n  # Bio::SeqI; note that coordinates are relative only to the DNA\n  # sequence, not it's implicit encoded protein sequence.\n\n=head1 DESCRIPTION\n\nBio::Seq::EncodedSeq is a L<Bio::LocatableSeq|Bio::LocatableSeq>\nobject that holds a DNA sequence as well as information about the\ncoding potential of that DNA sequence.  It is meant to be useful in an\nalignment context, where the DNA may contain frameshifts, gaps and/or\nintrons, or in describing the transcript of a gene.  An EncodedSeq\nprovides the ability to access the \"spliced\" coding sequence, meaning\nthat all introns and gaps are removed, and any frameshifts are\nadjusted to provide a \"clean\" CDS.\n\nIn order to make simultaneous use of either the DNA or the implicit\nencoded protein sequence coordinates, please see\nL<Bio::Coordinate::EncodingPair>.\n\n=head1 ENCODING\n\nWe use the term \"encoding\" here to refer to the series of symbols that\nwe use to identify which residues of a DNA sequence are protein-coding\n(i.e. part of a codon), intronic, part of a 5' or 3', frameshift\n\"mutations\", etc.  From this information, a Bio::Seq::EncodedSeq is\nable to \"figure out\" its translational CDS.  There are two sets of\ncoding characters, one termed \"implicit\" and one termed \"explicit\".\n\nThe \"implicit\" encoding is a bit simpler than the \"explicit\" encoding:\n'C' is used for any nucleotide that's part of a codon, 'U' for any\nUTR, etc.  The full list is shown below:\n\n Code  Meaning\n ----  -------\n  C    coding\n  I    intronic\n  U    untranslated\n  G    gapped (for use in alignments)\n  F    a \"forward\", +1 frameshift\n  B    a \"backward\", -1 frameshift\n\nThe \"explicit\" encoding is just an expansion of the \"implicit\"\nencoding, to denote phase:\n\n Code  Meaning\n ----  -------\n  C    coding, 1st codon position\n  D    coding, 2nd codon position\n  E    coding, 3rd codon position\n\n  I    intronic, phase 0 (relative to intron begin)\n  J    intronic, phase 1\n  K    intronic, phase 2\n\n  U    untranslated 3'UTR\n  V    untranslated 5'UTR\n\n  G    gapped (for use in alignments)\n  F    a \"forward\", +1 frameshift\n  B    a \"backward\", -1 frameshift\n\nNote that the explicit coding is meant to provide easy access to\nposition/phase specific nucleotides:\n\n  $obj = Bio::Seq::EncodedSeq->new(-seq => \"ACAATCAGACTACG...\",\n                                   -encoding => \"CCCCCCIII...\"\n                                  );\n\n  # fetch arrays of nucleotides at each codon position:\n  my @pos1 = $obj->dnaseq(encoding => 'C', explicit => 1);\n  my @pos2 = $obj->dnaseq(encoding => 'D');\n  my @pos3 = $obj->dnaseq(encoding => 'E');\n\n  # fetch arrays of \"3-1\" codon dinucleotides, useful for genomic\n  # signature analyses without compounding influences of codon bias:\n  my @pairs = $obj->dnaseq(encoding => 'EC');\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Aaron Mackey\n\nEmail amackey@virginia.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Seq::EncodedSeq;\n\nuse strict;\n\n\nuse base qw(Bio::LocatableSeq);\n\n=head2 new\n\n Title   : new\n Usage   : $obj = Bio::Seq::EncodedSeq->new(-seq      => \"AGTACGTGTCATG\",\n                                            -encoding => \"CCCCCCFCCCCCC\",\n                                            -id       => \"myseq\",\n                                            -start    => 1,\n                                            -end      => 13,\n                                            -strand   => 1\n                                      );\n Function: creates a new Bio::Seq::EncodedSeq object from a supplied DNA\n           sequence\n Returns : a new Bio::Seq::EncodedSeq object\n\n Args    : seq      - primary nucleotide sequence used to encode the\n                      protein; note that any positions involved in a\n                      gap ('G') or backward frameshift ('B') should\n                      have one or more gap characters; if the encoding\n                      specifies G or B, but no (or not enough) gap\n                      characters exist, *they'll be added*; similary,\n                      if there are gap characters without a\n                      corresponding G or B encoding, G's will be\n                      inserted into the encoding.  This allows some\n                      flexibility in specifying your sequence and\n                      coding without having to calculate a lot of the\n                      encoding for yourself.\n\n           encoding - a string of characters (see Encoding Table)\n                      describing backwards frameshifts implied by the\n                      encoding but not present in the sequence will be\n                      added (as '-'s) to the sequence.  If not\n                      supplied, it will be assumed that all positions\n                      are coding (C).  Encoding may include either\n                      implicit phase encoding characters (i.e. \"CCC\")\n                      and/or explicit encoding characters (i.e. \"CDE\").\n                      Additionally, prefixed numbers may be used to\n                      denote repetition (i.e. \"27C3I28C\").\n\n                      Alternatively, encoding may be a hashref\n                      datastructure, with encoding characters as keys\n                      and Bio::LocationI objects (or arrayrefs of\n                      Bio::LocationI objects) as values, e.g.:\n\n                      { C => [ Bio::Location::Simple->new(1,9),\n                               Bio::Location::Simple->new(11,13) ],\n                        F => Bio::Location::Simple->new(10,10),\n                      } # same as \"CCCCCCCCCFCCC\"\n\n                      Note that if the location ranges overlap, the\n                      behavior of the encoding will be undefined\n                      (well, it will be defined, but only according to\n                      the order in which the hash keys are read, which\n                      is basically undefined ... just don't do that).\n\n           id, start, end, strand - as with Bio::LocatableSeq; note\n                      that the coordinates are relative to the\n                      encoding DNA sequence, not the implicit protein\n                      sequence.  If strand is reversed, then the\n                      encoding is assumed to be relative to the\n                      reverse strand as well.\n\n'"},"detail":"($self,@args)","definition":"sub","containerName":"main::"},{"line":228,"kind":12,"containerName":"new","name":"SUPER"},{"name":"encoding","range":{"start":{"character":0,"line":269},"end":{"line":381,"character":9999}},"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: EncodedSeq.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Seq::EncodedSeq\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Aaron Mackey\n#\n# Copyright Aaron Mackey\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::EncodedSeq - subtype of L<Bio::LocatableSeq|Bio::LocatableSeq> to store DNA that encodes a protein\n\n=head1 SYNOPSIS\n\n  $obj = Bio::Seq::EncodedSeq->new(-seq => $dna,\n                                  -encoding => \"CCCCCCCIIIIICCCCC\",\n                                  -start => 1,\n                                  -strand => 1,\n                                  -length => 17);\n\n  # splice out (and possibly revcomp) the coding sequence\n  $cds = obj->cds;\n\n  # obtain the protein translation of the sequence\n  $prot = $obj->translate;\n\n  # other access/inspection routines as with Bio::LocatableSeq and\n  # Bio::SeqI; note that coordinates are relative only to the DNA\n  # sequence, not it's implicit encoded protein sequence.\n\n=head1 DESCRIPTION\n\nBio::Seq::EncodedSeq is a L<Bio::LocatableSeq|Bio::LocatableSeq>\nobject that holds a DNA sequence as well as information about the\ncoding potential of that DNA sequence.  It is meant to be useful in an\nalignment context, where the DNA may contain frameshifts, gaps and/or\nintrons, or in describing the transcript of a gene.  An EncodedSeq\nprovides the ability to access the \"spliced\" coding sequence, meaning\nthat all introns and gaps are removed, and any frameshifts are\nadjusted to provide a \"clean\" CDS.\n\nIn order to make simultaneous use of either the DNA or the implicit\nencoded protein sequence coordinates, please see\nL<Bio::Coordinate::EncodingPair>.\n\n=head1 ENCODING\n\nWe use the term \"encoding\" here to refer to the series of symbols that\nwe use to identify which residues of a DNA sequence are protein-coding\n(i.e. part of a codon), intronic, part of a 5' or 3', frameshift\n\"mutations\", etc.  From this information, a Bio::Seq::EncodedSeq is\nable to \"figure out\" its translational CDS.  There are two sets of\ncoding characters, one termed \"implicit\" and one termed \"explicit\".\n\nThe \"implicit\" encoding is a bit simpler than the \"explicit\" encoding:\n'C' is used for any nucleotide that's part of a codon, 'U' for any\nUTR, etc.  The full list is shown below:\n\n Code  Meaning\n ----  -------\n  C    coding\n  I    intronic\n  U    untranslated\n  G    gapped (for use in alignments)\n  F    a \"forward\", +1 frameshift\n  B    a \"backward\", -1 frameshift\n\nThe \"explicit\" encoding is just an expansion of the \"implicit\"\nencoding, to denote phase:\n\n Code  Meaning\n ----  -------\n  C    coding, 1st codon position\n  D    coding, 2nd codon position\n  E    coding, 3rd codon position\n\n  I    intronic, phase 0 (relative to intron begin)\n  J    intronic, phase 1\n  K    intronic, phase 2\n\n  U    untranslated 3'UTR\n  V    untranslated 5'UTR\n\n  G    gapped (for use in alignments)\n  F    a \"forward\", +1 frameshift\n  B    a \"backward\", -1 frameshift\n\nNote that the explicit coding is meant to provide easy access to\nposition/phase specific nucleotides:\n\n  $obj = Bio::Seq::EncodedSeq->new(-seq => \"ACAATCAGACTACG...\",\n                                   -encoding => \"CCCCCCIII...\"\n                                  );\n\n  # fetch arrays of nucleotides at each codon position:\n  my @pos1 = $obj->dnaseq(encoding => 'C', explicit => 1);\n  my @pos2 = $obj->dnaseq(encoding => 'D');\n  my @pos3 = $obj->dnaseq(encoding => 'E');\n\n  # fetch arrays of \"3-1\" codon dinucleotides, useful for genomic\n  # signature analyses without compounding influences of codon bias:\n  my @pairs = $obj->dnaseq(encoding => 'EC');\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Aaron Mackey\n\nEmail amackey@virginia.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Seq::EncodedSeq;\n\nuse strict;\n\n\nuse base qw(Bio::LocatableSeq);\n\n=head2 new\n\n Title   : new\n Usage   : $obj = Bio::Seq::EncodedSeq->new(-seq      => \"AGTACGTGTCATG\",\n                                            -encoding => \"CCCCCCFCCCCCC\",\n                                            -id       => \"myseq\",\n                                            -start    => 1,\n                                            -end      => 13,\n                                            -strand   => 1\n                                      );\n Function: creates a new Bio::Seq::EncodedSeq object from a supplied DNA\n           sequence\n Returns : a new Bio::Seq::EncodedSeq object\n\n Args    : seq      - primary nucleotide sequence used to encode the\n                      protein; note that any positions involved in a\n                      gap ('G') or backward frameshift ('B') should\n                      have one or more gap characters; if the encoding\n                      specifies G or B, but no (or not enough) gap\n                      characters exist, *they'll be added*; similary,\n                      if there are gap characters without a\n                      corresponding G or B encoding, G's will be\n                      inserted into the encoding.  This allows some\n                      flexibility in specifying your sequence and\n                      coding without having to calculate a lot of the\n                      encoding for yourself.\n\n           encoding - a string of characters (see Encoding Table)\n                      describing backwards frameshifts implied by the\n                      encoding but not present in the sequence will be\n                      added (as '-'s) to the sequence.  If not\n                      supplied, it will be assumed that all positions\n                      are coding (C).  Encoding may include either\n                      implicit phase encoding characters (i.e. \"CCC\")\n                      and/or explicit encoding characters (i.e. \"CDE\").\n                      Additionally, prefixed numbers may be used to\n                      denote repetition (i.e. \"27C3I28C\").\n\n                      Alternatively, encoding may be a hashref\n                      datastructure, with encoding characters as keys\n                      and Bio::LocationI objects (or arrayrefs of\n                      Bio::LocationI objects) as values, e.g.:\n\n                      { C => [ Bio::Location::Simple->new(1,9),\n                               Bio::Location::Simple->new(11,13) ],\n                        F => Bio::Location::Simple->new(10,10),\n                      } # same as \"CCCCCCCCCFCCC\"\n\n                      Note that if the location ranges overlap, the\n                      behavior of the encoding will be undefined\n                      (well, it will be defined, but only according to\n                      the order in which the hash keys are read, which\n                      is basically undefined ... just don't do that).\n\n           id, start, end, strand - as with Bio::LocatableSeq; note\n                      that the coordinates are relative to the\n                      encoding DNA sequence, not the implicit protein\n                      sequence.  If strand is reversed, then the\n                      encoding is assumed to be relative to the\n                      reverse strand as well.\n\n\n#'\n\nsub new {\n\n    my ($self, @args) = @_;\n    $self = $self->SUPER::new(@args, -alphabet => 'dna');\n    my ($enc) = $self->_rearrange([qw(ENCODING)], @args);\n    # set the real encoding:\n    if ($enc) {\n\t$self->encoding($enc);\n    } else {\n\t$self->_recheck_encoding;\n    }\n    return $self;\n}\n\n=head2 encoding\n\n Title   : encoding\n Usage   : $obj->encoding(\"CCCCCC\");\n           $obj->encoding( -encoding => { I => $location } );\n           $enc = $obj->encoding(-explicit => 1);\n           $enc = $obj->encoding(\"CCCCCC\", -explicit => 1);\n           $enc = $obj->encoding(-location => $location,\n                                 -explicit => 1,\n                                 -absolute => 1 );\n Function: get/set the objects encoding, either globally or by location(s).\n Returns : the (possibly new) encoding string.\n Args    : encoding - see the encoding argument to the new() function.\n\n           explicit - whether or not to return explicit phase\n                      information in the coding (i.e. \"CCC\" becomes\n                      \"CDE\", \"III\" becomes \"IJK\", etc); defaults to 0.\n\n           location - optional; location to get/set the encoding.\n                      Defaults to the entire sequence.\n\n           absolute - whether or not the locational elements (either\n                      in the encoding hashref or the location\n                      argument) are relative to the absolute start/end\n                      of the Bio::LocatableSeq, or to the internal,\n                      relative coordinate system (beginning at 1);\n                      defaults to 0 (i.e. relative)","label":"encoding($self,@args)"},"detail":"($self,@args)","kind":12,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"encoding","line":271,"kind":13},{"line":271,"kind":13,"containerName":"encoding","name":"@args"},{"containerName":"encoding","name":"$enc","definition":"my","localvar":"my","kind":13,"line":272},{"line":272,"kind":13,"containerName":"encoding","name":"$loc"},{"name":"$exp","containerName":"encoding","kind":13,"line":272},{"kind":13,"line":272,"name":"$abs","containerName":"encoding"},{"kind":13,"line":272,"containerName":"encoding","name":"$self"},{"name":"_rearrange","containerName":"encoding","line":272,"kind":12},{"kind":13,"line":272,"containerName":"encoding","name":"@args"},{"containerName":"encoding","name":"$enc","line":274,"kind":13},{"kind":13,"line":276,"containerName":"encoding","name":"$enc"},{"line":277,"kind":13,"containerName":"encoding","name":"$self"},{"line":277,"kind":12,"containerName":"encoding","name":"throw"},{"definition":"my","name":"$char","containerName":"encoding","localvar":"my","kind":13,"line":280},{"containerName":"encoding","name":"$locs","kind":13,"line":280},{"name":"$enc","containerName":"encoding","kind":13,"line":280},{"kind":13,"line":281,"containerName":"encoding","name":"$locs"},{"name":"$locs","containerName":"encoding","line":282,"kind":13},{"line":284,"kind":13,"name":"$self","containerName":"encoding"},{"containerName":"encoding","name":"throw","line":284,"kind":12},{"kind":13,"line":287,"name":"$enc","containerName":"encoding"},{"line":288,"kind":13,"name":"$enc","containerName":"encoding"},{"kind":13,"line":288,"name":"$enc","containerName":"encoding"},{"containerName":"encoding","name":"$exp","line":289,"kind":13},{"line":289,"kind":13,"containerName":"encoding","name":"$exp"},{"name":"$enc","containerName":"encoding","kind":13,"line":289},{"containerName":"encoding","name":"$enc","line":291,"kind":13},{"line":292,"kind":13,"localvar":"my","containerName":"encoding","name":"$numenc","definition":"my"},{"name":"$enc","containerName":"encoding","kind":13,"line":292},{"line":293,"kind":13,"containerName":"encoding","name":"$enc"},{"line":294,"kind":13,"containerName":"encoding","name":"$numenc"},{"kind":13,"line":295,"containerName":"encoding","name":"$num","definition":"my","localvar":"my"},{"line":295,"kind":13,"name":"$char","containerName":"encoding"},{"line":296,"kind":13,"name":"$num","containerName":"encoding"},{"line":296,"kind":13,"name":"$num","containerName":"encoding"},{"containerName":"encoding","name":"$enc","line":297,"kind":13},{"kind":13,"line":297,"containerName":"encoding","name":"$char"},{"kind":13,"line":297,"containerName":"encoding","name":"$num"},{"containerName":"encoding","name":"$exp","kind":13,"line":301},{"containerName":"encoding","name":"$exp","kind":13,"line":301},{"kind":13,"line":301,"containerName":"encoding","name":"$enc"},{"line":302,"kind":13,"containerName":"encoding","name":"$self"},{"line":302,"kind":12,"name":"throw","containerName":"encoding"},{"line":303,"kind":13,"name":"$enc","containerName":"encoding"},{"line":304,"kind":13,"name":"$self","containerName":"encoding"},{"line":304,"kind":12,"name":"throw","containerName":"encoding"},{"line":307,"kind":13,"containerName":"encoding","name":"$loc"},{"localvar":"my","containerName":"encoding","definition":"my","name":"$ct","line":310,"kind":13},{"line":310,"kind":13,"name":"$enc","containerName":"encoding"},{"line":311,"kind":13,"name":"$ct","containerName":"encoding"},{"containerName":"encoding","name":"$enc","kind":13,"line":311},{"line":311,"kind":13,"name":"$ct","containerName":"encoding"},{"kind":13,"line":312,"name":"$self","containerName":"encoding"},{"kind":12,"line":312,"containerName":"encoding","name":"throw"},{"kind":13,"line":313,"containerName":"encoding","name":"$loc"},{"line":313,"kind":12,"name":"location_type","containerName":"encoding"},{"name":"$loc","containerName":"encoding","kind":13,"line":313},{"containerName":"encoding","name":"length","kind":12,"line":313},{"kind":13,"line":313,"name":"$ct","containerName":"encoding"},{"line":315,"kind":13,"localvar":"my","name":"$start","definition":"my","containerName":"encoding"},{"name":"$loc","containerName":"encoding","line":315,"kind":13},{"containerName":"encoding","name":"start","line":315,"kind":12},{"containerName":"encoding","name":"$end","definition":"my","localvar":"my","kind":13,"line":316},{"line":316,"kind":13,"containerName":"encoding","name":"$loc"},{"line":316,"kind":12,"name":"end","containerName":"encoding"},{"line":319,"kind":13,"containerName":"encoding","name":"$start"},{"kind":13,"line":319,"name":"$self","containerName":"encoding"},{"line":319,"kind":12,"name":"start","containerName":"encoding"},{"line":320,"kind":13,"localvar":"my","containerName":"encoding","name":"$diff","definition":"my"},{"kind":13,"line":320,"name":"$self","containerName":"encoding"},{"containerName":"encoding","name":"start","kind":12,"line":320},{"containerName":"encoding","name":"$start","kind":13,"line":320},{"line":321,"kind":13,"name":"$start","containerName":"encoding"},{"containerName":"encoding","name":"$self","kind":13,"line":321},{"line":321,"kind":12,"containerName":"encoding","name":"start"},{"line":322,"kind":13,"containerName":"encoding","name":"$enc"},{"line":322,"kind":13,"containerName":"encoding","name":"$enc"},{"name":"$diff","containerName":"encoding","line":322,"kind":13},{"line":324,"kind":13,"name":"$end","containerName":"encoding"},{"kind":13,"line":324,"name":"$self","containerName":"encoding"},{"name":"end","containerName":"encoding","kind":12,"line":324},{"localvar":"my","definition":"my","name":"$diff","containerName":"encoding","line":325,"kind":13},{"name":"$end","containerName":"encoding","kind":13,"line":325},{"line":325,"kind":13,"containerName":"encoding","name":"$self"},{"kind":12,"line":325,"containerName":"encoding","name":"end"},{"name":"$end","containerName":"encoding","line":326,"kind":13},{"kind":13,"line":326,"name":"$self","containerName":"encoding"},{"name":"end","containerName":"encoding","line":326,"kind":12},{"line":327,"kind":13,"containerName":"encoding","name":"$enc"},{"kind":13,"line":327,"name":"$enc","containerName":"encoding"},{"kind":13,"line":327,"containerName":"encoding","name":"$diff"},{"localvar":"my","containerName":"encoding","name":"$currenc","definition":"my","line":330,"kind":13},{"kind":13,"line":330,"containerName":"encoding","name":"$self"},{"name":"$currseq","definition":"my","containerName":"encoding","localvar":"my","kind":13,"line":331},{"line":331,"kind":13,"containerName":"encoding","name":"$self"},{"line":331,"kind":12,"name":"seq","containerName":"encoding"},{"localvar":"my","containerName":"encoding","definition":"my","name":"$spanstart","line":333,"kind":13},{"containerName":"encoding","name":"$spanend","kind":13,"line":333},{"containerName":"encoding","name":"$self","line":333,"kind":13},{"name":"column_from_residue_number","containerName":"encoding","kind":12,"line":333},{"containerName":"encoding","name":"$start","line":333,"kind":13},{"name":"$self","containerName":"encoding","line":334,"kind":13},{"containerName":"encoding","name":"column_from_residue_number","kind":12,"line":334},{"line":334,"kind":13,"name":"$end","containerName":"encoding"},{"kind":13,"line":336,"name":"$currseq","containerName":"encoding"},{"kind":13,"line":338,"name":"$spanstart","containerName":"encoding"},{"name":"$spanend","containerName":"encoding","line":338,"kind":13},{"name":"$spanend","containerName":"encoding","kind":13,"line":338},{"containerName":"encoding","name":"$spanstart","line":338,"kind":13},{"kind":13,"line":338,"name":"$self","containerName":"encoding"},{"name":"strand","containerName":"encoding","kind":12,"line":338},{"localvar":"my","name":"$before","definition":"my","containerName":"encoding","line":339,"kind":13},{"line":339,"kind":13,"name":"$in","containerName":"encoding"},{"kind":13,"line":339,"containerName":"encoding","name":"$after"},{"name":"$currseq","containerName":"encoding","kind":13,"line":339},{"name":"$in","containerName":"encoding","line":343,"kind":13},{"containerName":"encoding","name":"$in","line":344,"kind":13},{"name":"$currseq","containerName":"encoding","kind":13,"line":345},{"name":"$before","containerName":"encoding","line":345,"kind":13},{"containerName":"encoding","name":"$in","line":345,"kind":13},{"kind":13,"line":345,"name":"$after","containerName":"encoding"},{"line":347,"kind":13,"containerName":"encoding","name":"$self"},{"kind":12,"line":347,"name":"seq","containerName":"encoding"},{"name":"$currseq","containerName":"encoding","kind":13,"line":347},{"containerName":"encoding","name":"$self","kind":13,"line":347},{"kind":12,"line":347,"name":"alphabet","containerName":"encoding"},{"kind":13,"line":350,"name":"$currenc","containerName":"encoding"},{"name":"$currenc","containerName":"encoding","kind":13,"line":350},{"kind":13,"line":350,"name":"$self","containerName":"encoding"},{"kind":12,"line":350,"name":"strand","containerName":"encoding"},{"line":351,"kind":13,"containerName":"encoding","name":"$currenc"},{"name":"$spanstart","containerName":"encoding","kind":13,"line":351},{"kind":13,"line":351,"name":"$spanend","containerName":"encoding"},{"name":"$spanstart","containerName":"encoding","line":351,"kind":13},{"name":"$loc","containerName":"encoding","kind":13,"line":351},{"name":"location_type","containerName":"encoding","line":351,"kind":12},{"name":"$self","containerName":"encoding","kind":13,"line":352},{"kind":12,"line":352,"name":"strand","containerName":"encoding"},{"containerName":"encoding","name":"$enc","kind":13,"line":352},{"containerName":"encoding","name":"$enc","line":352,"kind":13},{"kind":13,"line":353,"name":"$currenc","containerName":"encoding"},{"name":"$currenc","containerName":"encoding","kind":13,"line":353},{"kind":13,"line":353,"containerName":"encoding","name":"$self"},{"name":"strand","containerName":"encoding","kind":12,"line":353},{"name":"$self","containerName":"encoding","kind":13,"line":355},{"kind":13,"line":355,"name":"$currenc","containerName":"encoding"},{"line":356,"kind":13,"name":"$self","containerName":"encoding"},{"name":"_recheck_encoding","containerName":"encoding","kind":12,"line":356},{"kind":13,"line":358,"name":"$currenc","containerName":"encoding"},{"line":358,"kind":13,"name":"$self","containerName":"encoding"},{"line":359,"kind":13,"containerName":"encoding","name":"$currenc"},{"kind":13,"line":359,"name":"$currenc","containerName":"encoding"},{"kind":13,"line":359,"containerName":"encoding","name":"$self"},{"name":"strand","containerName":"encoding","line":359,"kind":12},{"name":"$enc","containerName":"encoding","line":360,"kind":13},{"containerName":"encoding","name":"$currenc","line":360,"kind":13},{"line":360,"kind":13,"name":"$spanstart","containerName":"encoding"},{"kind":13,"line":360,"containerName":"encoding","name":"$enc"},{"containerName":"encoding","name":"$enc","kind":13,"line":361},{"line":361,"kind":13,"name":"$enc","containerName":"encoding"},{"kind":13,"line":361,"containerName":"encoding","name":"$self"},{"name":"strand","containerName":"encoding","kind":12,"line":361},{"kind":13,"line":363,"name":"$exp","containerName":"encoding"},{"line":363,"kind":13,"containerName":"encoding","name":"$enc"},{"kind":13,"line":363,"name":"$self","containerName":"encoding"},{"name":"_convert2implicit","containerName":"encoding","kind":12,"line":363},{"name":"$enc","containerName":"encoding","kind":13,"line":363},{"line":369,"kind":13,"localvar":"my","containerName":"encoding","definition":"my","name":"$dna"},{"name":"$self","containerName":"encoding","kind":13,"line":369},{"line":369,"kind":12,"name":"seq","containerName":"encoding"},{"kind":13,"line":370,"name":"$dna","containerName":"encoding"},{"kind":13,"line":371,"name":"$self","containerName":"encoding"},{"kind":12,"line":371,"containerName":"encoding","name":"seq"},{"containerName":"encoding","name":"$dna","line":371,"kind":13},{"name":"$self","containerName":"encoding","kind":13,"line":372},{"line":372,"kind":13,"name":"$enc","containerName":"encoding"},{"containerName":"encoding","name":"$self","kind":13,"line":375},{"containerName":"encoding","name":"throw","line":375,"kind":12},{"containerName":"encoding","name":"$self","kind":13,"line":378},{"containerName":"encoding","name":"_recheck_encoding","kind":12,"line":378},{"name":"$exp","containerName":"encoding","line":380,"kind":13},{"kind":13,"line":380,"containerName":"encoding","name":"$self"},{"kind":13,"line":380,"name":"$self","containerName":"encoding"},{"line":380,"kind":12,"containerName":"encoding","name":"_convert2implicit"},{"containerName":"encoding","name":"$self","kind":13,"line":380}],"line":269},{"kind":12,"line":282,"containerName":"isa","name":"UNIVERSAL"},{"kind":12,"line":330,"name":"_encoding"},{"kind":12,"line":355,"name":"_encoding"},{"kind":12,"line":358,"name":"_encoding"},{"name":"_encoding","kind":12,"line":372},{"line":380,"kind":12,"name":"_encoding"},{"name":"_encoding","kind":12,"line":380},{"kind":12,"children":[{"kind":13,"line":385,"name":"$self","definition":"my","containerName":"_convert2implicit","localvar":"my"},{"containerName":"_convert2implicit","name":"$enc","kind":13,"line":385},{"containerName":"_convert2implicit","name":"$enc","kind":13,"line":387},{"line":388,"kind":13,"containerName":"_convert2implicit","name":"$enc"},{"kind":13,"line":389,"containerName":"_convert2implicit","name":"$enc"},{"containerName":"_convert2implicit","name":"$enc","kind":13,"line":391}],"line":383,"definition":"sub","containerName":"main::","signature":{"documentation":"","parameters":[{"label":"$self"},{"label":"$enc"}],"label":"_convert2implicit($self,$enc)"},"detail":"($self,$enc)","name":"_convert2implicit","range":{"end":{"line":392,"character":9999},"start":{"character":0,"line":383}}},{"range":{"start":{"line":394,"character":0},"end":{"line":469,"character":9999}},"name":"_recheck_encoding","definition":"sub","containerName":"main::","children":[{"kind":13,"line":396,"definition":"my","name":"$self","containerName":"_recheck_encoding","localvar":"my"},{"kind":13,"line":398,"definition":"my","name":"@enc","containerName":"_recheck_encoding","localvar":"my"},{"containerName":"_recheck_encoding","name":"$self","kind":13,"line":398},{"kind":13,"line":400,"containerName":"_recheck_encoding","definition":"my","name":"@nt","localvar":"my"},{"name":"$self","containerName":"_recheck_encoding","line":400,"kind":13},{"containerName":"_recheck_encoding","name":"@nt","line":401,"kind":13},{"name":"@nt","containerName":"_recheck_encoding","kind":13,"line":401},{"line":401,"kind":13,"containerName":"_recheck_encoding","name":"$self"},{"name":"strand","containerName":"_recheck_encoding","line":401,"kind":12},{"kind":13,"line":401,"containerName":"_recheck_encoding","name":"$self"},{"containerName":"_recheck_encoding","name":"strand","kind":12,"line":401},{"containerName":"_recheck_encoding","name":"@enc","line":404,"kind":13},{"kind":13,"line":405,"name":"@nt","containerName":"_recheck_encoding"},{"kind":13,"line":405,"name":"@enc","containerName":"_recheck_encoding"},{"line":409,"kind":13,"localvar":"my","name":"$i","definition":"my","containerName":"_recheck_encoding"},{"line":410,"kind":13,"containerName":"_recheck_encoding","name":"$i"},{"kind":13,"line":410,"containerName":"_recheck_encoding","name":"$i"},{"name":"@nt","containerName":"_recheck_encoding","line":410,"kind":13},{"kind":13,"line":410,"containerName":"_recheck_encoding","name":"$i"},{"kind":13,"line":410,"containerName":"_recheck_encoding","name":"@enc"},{"kind":13,"line":410,"name":"$i","containerName":"_recheck_encoding"},{"kind":13,"line":411,"containerName":"_recheck_encoding","name":"$nt"},{"containerName":"_recheck_encoding","name":"$i","kind":13,"line":411},{"line":411,"kind":13,"name":"$enc","containerName":"_recheck_encoding"},{"containerName":"_recheck_encoding","name":"$i","kind":13,"line":411},{"kind":13,"line":412,"name":"@enc","containerName":"_recheck_encoding"},{"kind":13,"line":412,"name":"$i","containerName":"_recheck_encoding"},{"containerName":"_recheck_encoding","name":"$nt","kind":13,"line":413},{"name":"$i","containerName":"_recheck_encoding","line":413,"kind":13},{"kind":13,"line":413,"containerName":"_recheck_encoding","name":"$enc"},{"line":413,"kind":13,"containerName":"_recheck_encoding","name":"$i"},{"containerName":"_recheck_encoding","name":"@nt","line":414,"kind":13},{"containerName":"_recheck_encoding","name":"$i","kind":13,"line":414},{"name":"$i","containerName":"_recheck_encoding","line":417,"kind":13},{"name":"@enc","containerName":"_recheck_encoding","line":417,"kind":13},{"line":419,"kind":13,"name":"$i","containerName":"_recheck_encoding"},{"line":419,"kind":13,"name":"@enc","containerName":"_recheck_encoding"},{"name":"$i","containerName":"_recheck_encoding","kind":13,"line":419},{"containerName":"_recheck_encoding","name":"$enc","line":420,"kind":13},{"name":"$i","containerName":"_recheck_encoding","line":420,"kind":13},{"name":"@nt","containerName":"_recheck_encoding","line":421,"kind":13},{"containerName":"_recheck_encoding","name":"$self","line":423,"kind":13},{"kind":12,"line":423,"containerName":"_recheck_encoding","name":"throw"},{"name":"@enc","containerName":"_recheck_encoding","kind":13,"line":423},{"kind":13,"line":423,"name":"$i","containerName":"_recheck_encoding"},{"containerName":"_recheck_encoding","name":"$i","line":426,"kind":13},{"kind":13,"line":426,"name":"@nt","containerName":"_recheck_encoding"},{"containerName":"_recheck_encoding","name":"$i","line":427,"kind":13},{"containerName":"_recheck_encoding","name":"@nt","line":427,"kind":13},{"line":427,"kind":13,"containerName":"_recheck_encoding","name":"$i"},{"kind":13,"line":428,"name":"$nt","containerName":"_recheck_encoding"},{"containerName":"_recheck_encoding","name":"$i","line":428,"kind":13},{"line":429,"kind":13,"containerName":"_recheck_encoding","name":"@enc"},{"kind":13,"line":431,"name":"@enc","containerName":"_recheck_encoding"},{"localvar":"my","containerName":"_recheck_encoding","definition":"my","name":"@cde_array","line":436,"kind":13},{"localvar":"my","containerName":"_recheck_encoding","name":"@ijk_array","definition":"my","line":437,"kind":13},{"line":439,"kind":13,"localvar":"my","containerName":"_recheck_encoding","name":"$Cct","definition":"my"},{"kind":13,"line":439,"name":"$Ict","containerName":"_recheck_encoding"},{"name":"$Uct","containerName":"_recheck_encoding","line":439,"kind":13},{"line":439,"kind":13,"name":"$Vct","containerName":"_recheck_encoding"},{"kind":13,"line":439,"name":"$Vwarned","containerName":"_recheck_encoding"},{"kind":13,"line":440,"containerName":"_recheck_encoding","name":"$i"},{"containerName":"_recheck_encoding","name":"$i","kind":13,"line":440},{"containerName":"_recheck_encoding","name":"@enc","kind":13,"line":440},{"name":"$i","containerName":"_recheck_encoding","line":440,"kind":13},{"line":441,"kind":13,"containerName":"_recheck_encoding","name":"$enc"},{"kind":13,"line":441,"name":"$i","containerName":"_recheck_encoding"},{"localvar":"my","definition":"my","name":"$temp_index","containerName":"_recheck_encoding","line":442,"kind":13},{"line":442,"kind":13,"name":"$Cct","containerName":"_recheck_encoding"},{"line":442,"kind":13,"containerName":"_recheck_encoding","name":"%3"},{"kind":13,"line":443,"name":"$enc","containerName":"_recheck_encoding"},{"line":443,"kind":13,"name":"$i","containerName":"_recheck_encoding"},{"line":443,"kind":13,"containerName":"_recheck_encoding","name":"$cde_array"},{"containerName":"_recheck_encoding","name":"$temp_index","kind":13,"line":443},{"kind":13,"line":444,"name":"$Cct","containerName":"_recheck_encoding"},{"containerName":"_recheck_encoding","name":"$Ict","line":444,"kind":13},{"containerName":"_recheck_encoding","name":"$Uct","kind":13,"line":444},{"kind":13,"line":445,"containerName":"_recheck_encoding","name":"$self"},{"name":"warn","containerName":"_recheck_encoding","kind":12,"line":445},{"line":446,"kind":13,"name":"$Vct","containerName":"_recheck_encoding"},{"kind":13,"line":446,"name":"$Vwarned","containerName":"_recheck_encoding"},{"line":447,"kind":13,"name":"$enc","containerName":"_recheck_encoding"},{"name":"$i","containerName":"_recheck_encoding","line":447,"kind":13},{"name":"$enc","containerName":"_recheck_encoding","line":448,"kind":13},{"containerName":"_recheck_encoding","name":"$i","kind":13,"line":448},{"name":"$ijk_array","containerName":"_recheck_encoding","line":448,"kind":13},{"line":448,"kind":13,"name":"$Ict","containerName":"_recheck_encoding"},{"kind":13,"line":449,"name":"$Ict","containerName":"_recheck_encoding"},{"line":449,"kind":13,"containerName":"_recheck_encoding","name":"$Uct"},{"containerName":"_recheck_encoding","name":"$self","kind":13,"line":450},{"containerName":"_recheck_encoding","name":"warn","kind":12,"line":450},{"kind":13,"line":451,"name":"$Vct","containerName":"_recheck_encoding"},{"line":451,"kind":13,"containerName":"_recheck_encoding","name":"$Vwarned"},{"name":"$enc","containerName":"_recheck_encoding","kind":13,"line":452},{"line":452,"kind":13,"name":"$i","containerName":"_recheck_encoding"},{"line":453,"kind":13,"containerName":"_recheck_encoding","name":"$Uct"},{"kind":13,"line":454,"containerName":"_recheck_encoding","name":"$enc"},{"containerName":"_recheck_encoding","name":"$i","kind":13,"line":454},{"kind":13,"line":455,"name":"$Vct","containerName":"_recheck_encoding"},{"name":"$enc","containerName":"_recheck_encoding","line":457,"kind":13},{"kind":13,"line":457,"name":"$i","containerName":"_recheck_encoding"},{"kind":13,"line":458,"containerName":"_recheck_encoding","name":"$Cct"},{"line":458,"kind":13,"containerName":"_recheck_encoding","name":"$Ict"},{"name":"$enc","containerName":"_recheck_encoding","line":459,"kind":13},{"line":459,"kind":13,"name":"$i","containerName":"_recheck_encoding"},{"containerName":"_recheck_encoding","name":"@nt","line":464,"kind":13},{"containerName":"_recheck_encoding","name":"@nt","line":464,"kind":13},{"containerName":"_recheck_encoding","name":"$self","kind":13,"line":464},{"kind":12,"line":464,"name":"strand","containerName":"_recheck_encoding"},{"containerName":"_recheck_encoding","name":"$self","line":464,"kind":13},{"line":464,"kind":12,"name":"strand","containerName":"_recheck_encoding"},{"containerName":"_recheck_encoding","name":"$self","line":466,"kind":13},{"kind":13,"line":466,"name":"@nt","containerName":"_recheck_encoding"},{"kind":13,"line":468,"containerName":"_recheck_encoding","name":"$self"},{"kind":13,"line":468,"name":"@enc","containerName":"_recheck_encoding"}],"line":394,"kind":12},{"kind":12,"line":398,"name":"_encoding"},{"name":"SUPER","containerName":"seq","kind":12,"line":400},{"line":423,"kind":12,"name":"enc"},{"name":"_encoding","kind":12,"line":468},{"range":{"end":{"line":526,"character":9999},"start":{"line":486,"character":0}},"name":"cds","signature":{"label":"cds($self,@args)","documentation":"1;\n# $Id: EncodedSeq.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Seq::EncodedSeq\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Aaron Mackey\n#\n# Copyright Aaron Mackey\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::EncodedSeq - subtype of L<Bio::LocatableSeq|Bio::LocatableSeq> to store DNA that encodes a protein\n\n=head1 SYNOPSIS\n\n  $obj = Bio::Seq::EncodedSeq->new(-seq => $dna,\n                                  -encoding => \"CCCCCCCIIIIICCCCC\",\n                                  -start => 1,\n                                  -strand => 1,\n                                  -length => 17);\n\n  # splice out (and possibly revcomp) the coding sequence\n  $cds = obj->cds;\n\n  # obtain the protein translation of the sequence\n  $prot = $obj->translate;\n\n  # other access/inspection routines as with Bio::LocatableSeq and\n  # Bio::SeqI; note that coordinates are relative only to the DNA\n  # sequence, not it's implicit encoded protein sequence.\n\n=head1 DESCRIPTION\n\nBio::Seq::EncodedSeq is a L<Bio::LocatableSeq|Bio::LocatableSeq>\nobject that holds a DNA sequence as well as information about the\ncoding potential of that DNA sequence.  It is meant to be useful in an\nalignment context, where the DNA may contain frameshifts, gaps and/or\nintrons, or in describing the transcript of a gene.  An EncodedSeq\nprovides the ability to access the \"spliced\" coding sequence, meaning\nthat all introns and gaps are removed, and any frameshifts are\nadjusted to provide a \"clean\" CDS.\n\nIn order to make simultaneous use of either the DNA or the implicit\nencoded protein sequence coordinates, please see\nL<Bio::Coordinate::EncodingPair>.\n\n=head1 ENCODING\n\nWe use the term \"encoding\" here to refer to the series of symbols that\nwe use to identify which residues of a DNA sequence are protein-coding\n(i.e. part of a codon), intronic, part of a 5' or 3', frameshift\n\"mutations\", etc.  From this information, a Bio::Seq::EncodedSeq is\nable to \"figure out\" its translational CDS.  There are two sets of\ncoding characters, one termed \"implicit\" and one termed \"explicit\".\n\nThe \"implicit\" encoding is a bit simpler than the \"explicit\" encoding:\n'C' is used for any nucleotide that's part of a codon, 'U' for any\nUTR, etc.  The full list is shown below:\n\n Code  Meaning\n ----  -------\n  C    coding\n  I    intronic\n  U    untranslated\n  G    gapped (for use in alignments)\n  F    a \"forward\", +1 frameshift\n  B    a \"backward\", -1 frameshift\n\nThe \"explicit\" encoding is just an expansion of the \"implicit\"\nencoding, to denote phase:\n\n Code  Meaning\n ----  -------\n  C    coding, 1st codon position\n  D    coding, 2nd codon position\n  E    coding, 3rd codon position\n\n  I    intronic, phase 0 (relative to intron begin)\n  J    intronic, phase 1\n  K    intronic, phase 2\n\n  U    untranslated 3'UTR\n  V    untranslated 5'UTR\n\n  G    gapped (for use in alignments)\n  F    a \"forward\", +1 frameshift\n  B    a \"backward\", -1 frameshift\n\nNote that the explicit coding is meant to provide easy access to\nposition/phase specific nucleotides:\n\n  $obj = Bio::Seq::EncodedSeq->new(-seq => \"ACAATCAGACTACG...\",\n                                   -encoding => \"CCCCCCIII...\"\n                                  );\n\n  # fetch arrays of nucleotides at each codon position:\n  my @pos1 = $obj->dnaseq(encoding => 'C', explicit => 1);\n  my @pos2 = $obj->dnaseq(encoding => 'D');\n  my @pos3 = $obj->dnaseq(encoding => 'E');\n\n  # fetch arrays of \"3-1\" codon dinucleotides, useful for genomic\n  # signature analyses without compounding influences of codon bias:\n  my @pairs = $obj->dnaseq(encoding => 'EC');\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Aaron Mackey\n\nEmail amackey@virginia.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Seq::EncodedSeq;\n\nuse strict;\n\n\nuse base qw(Bio::LocatableSeq);\n\n=head2 new\n\n Title   : new\n Usage   : $obj = Bio::Seq::EncodedSeq->new(-seq      => \"AGTACGTGTCATG\",\n                                            -encoding => \"CCCCCCFCCCCCC\",\n                                            -id       => \"myseq\",\n                                            -start    => 1,\n                                            -end      => 13,\n                                            -strand   => 1\n                                      );\n Function: creates a new Bio::Seq::EncodedSeq object from a supplied DNA\n           sequence\n Returns : a new Bio::Seq::EncodedSeq object\n\n Args    : seq      - primary nucleotide sequence used to encode the\n                      protein; note that any positions involved in a\n                      gap ('G') or backward frameshift ('B') should\n                      have one or more gap characters; if the encoding\n                      specifies G or B, but no (or not enough) gap\n                      characters exist, *they'll be added*; similary,\n                      if there are gap characters without a\n                      corresponding G or B encoding, G's will be\n                      inserted into the encoding.  This allows some\n                      flexibility in specifying your sequence and\n                      coding without having to calculate a lot of the\n                      encoding for yourself.\n\n           encoding - a string of characters (see Encoding Table)\n                      describing backwards frameshifts implied by the\n                      encoding but not present in the sequence will be\n                      added (as '-'s) to the sequence.  If not\n                      supplied, it will be assumed that all positions\n                      are coding (C).  Encoding may include either\n                      implicit phase encoding characters (i.e. \"CCC\")\n                      and/or explicit encoding characters (i.e. \"CDE\").\n                      Additionally, prefixed numbers may be used to\n                      denote repetition (i.e. \"27C3I28C\").\n\n                      Alternatively, encoding may be a hashref\n                      datastructure, with encoding characters as keys\n                      and Bio::LocationI objects (or arrayrefs of\n                      Bio::LocationI objects) as values, e.g.:\n\n                      { C => [ Bio::Location::Simple->new(1,9),\n                               Bio::Location::Simple->new(11,13) ],\n                        F => Bio::Location::Simple->new(10,10),\n                      } # same as \"CCCCCCCCCFCCC\"\n\n                      Note that if the location ranges overlap, the\n                      behavior of the encoding will be undefined\n                      (well, it will be defined, but only according to\n                      the order in which the hash keys are read, which\n                      is basically undefined ... just don't do that).\n\n           id, start, end, strand - as with Bio::LocatableSeq; note\n                      that the coordinates are relative to the\n                      encoding DNA sequence, not the implicit protein\n                      sequence.  If strand is reversed, then the\n                      encoding is assumed to be relative to the\n                      reverse strand as well.\n\n\n#'\n\nsub new {\n\n    my ($self, @args) = @_;\n    $self = $self->SUPER::new(@args, -alphabet => 'dna');\n    my ($enc) = $self->_rearrange([qw(ENCODING)], @args);\n    # set the real encoding:\n    if ($enc) {\n\t$self->encoding($enc);\n    } else {\n\t$self->_recheck_encoding;\n    }\n    return $self;\n}\n\n=head2 encoding\n\n Title   : encoding\n Usage   : $obj->encoding(\"CCCCCC\");\n           $obj->encoding( -encoding => { I => $location } );\n           $enc = $obj->encoding(-explicit => 1);\n           $enc = $obj->encoding(\"CCCCCC\", -explicit => 1);\n           $enc = $obj->encoding(-location => $location,\n                                 -explicit => 1,\n                                 -absolute => 1 );\n Function: get/set the objects encoding, either globally or by location(s).\n Returns : the (possibly new) encoding string.\n Args    : encoding - see the encoding argument to the new() function.\n\n           explicit - whether or not to return explicit phase\n                      information in the coding (i.e. \"CCC\" becomes\n                      \"CDE\", \"III\" becomes \"IJK\", etc); defaults to 0.\n\n           location - optional; location to get/set the encoding.\n                      Defaults to the entire sequence.\n\n           absolute - whether or not the locational elements (either\n                      in the encoding hashref or the location\n                      argument) are relative to the absolute start/end\n                      of the Bio::LocatableSeq, or to the internal,\n                      relative coordinate system (beginning at 1);\n                      defaults to 0 (i.e. relative)\n\n\nsub encoding {\n\n    my ($self, @args) = @_;\n    my ($enc, $loc, $exp, $abs) = $self->_rearrange([qw(ENCODING LOCATION EXPLICIT ABSOLUTE)], @args);\n\n    if (!$enc) {\n\t# do nothing; _recheck_encoding will fix for us, if necessary\n    } elsif (ref $enc eq 'HASH') {\n\t$self->throw( -class => 'Bio::Root::NotImplemented',\n\t\t      -text  => \"Hashref functionality not yet implemented;\\nplease email me if you really need this.\");\n\t#TODO: finish all this\n\twhile (my ($char, $locs) = each %$enc) {\n\t    if (ref $locs eq 'ARRAY') {\n\t    } elsif (UNIVERSAL::isa($locs, \"Bio::LocationI\")) {\n\t    } else {\n\t\t$self->throw(\"Only a scalar or a ref to a hash; not a ref to a @{{lc ref $enc}}\");\n\t    }\n\t}\n    } elsif (! ref $enc) {\n\t$enc = uc $enc;\n\t$exp = 1 if (!defined $exp && $enc =~ m/[DEJKV]/o);\n\n\tif ($enc =~ m/\\d/o) { # numerically \"enhanced\" encoding\n\t    my $numenc = $enc;\n\t    $enc = '';\n\t    while ($numenc =~ m/\\G(\\d*)([CDEIJKUVGFB])/g) {\n\t\tmy ($num, $char) = ($1, $2);\n\t\t$num = 1 unless $num;\n\t\t$enc .= $char x $num;\n\t    }\n\t}\n\n\tif (defined $exp && $exp == 0 && $enc =~ m/([^CIUGFB])/) {\n\t    $self->throw(\"Unrecognized character '$1' in implicit encoding\");\n\t} elsif ($enc =~ m/[^CDEIJKUVGFB]/) {\n\t    $self->throw(\"Unrecognized character '$1' in explicit encoding\");\n\t}\n\n\tif ($loc) { # a global location, over which to apply the specified encoding.\n\n\t    # balk if too many non-gap characters present in encoding:\n\t    my ($ct) = $enc =~ tr/GB/GB/;\n\t    $ct = length($enc) - $ct;\n\t    $self->throw(\"Location length doesn't match number of coding chars in encoding!\")\n\t\tif ($loc->location_type eq 'EXACT' &&  $loc->length != $ct);\n\n\t    my $start = $loc->start;\n\t    my $end = $loc->end;\n\n\t    # strip any encoding that hangs off the ends of the sequence:\n\t    if ($start < $self->start) {\n\t\tmy $diff = $self->start - $start;\n\t\t$start = $self->start;\n\t\t$enc = substr($enc, $diff);\n\t    }\n\t    if ($end > $self->end) {\n\t\tmy $diff = $end - $self->end;\n\t\t$end = $self->end;\n\t\t$enc = substr($enc, -$diff);\n\t    }\n\n\t    my $currenc = $self->{_encoding};\n\t    my $currseq = $self->seq;\n\n\t    my ($spanstart, $spanend) = ($self->column_from_residue_number($start),\n\t\t\t\t\t $self->column_from_residue_number($end) );\n\n\t    if ($currseq) {\n\t\t# strip any gaps in sequence spanned by this location:\n\t\t($spanstart, $spanend) = ($spanend, $spanstart) if $self->strand < 0;\n\t\tmy ($before, $in, $after) = $currseq =~ m/(.{@{[ $spanstart - ($loc->location_type eq 'IN-BETWEEN' ? 0 : 1) ]}})\n                                                          (.{@{[ $spanend - $spanstart + ($loc->location_type eq 'IN-BETWEEN' ? -1 : 1) ]}})\n                                                          (.*)\n                                                         /x;\n                $in ||= '';\n\t\t$in =~ s/[\\.\\-]+//g;\n\t\t$currseq = ($before||'') . $in. ($after||'');\n\t\t# change seq without changing the alphabet\n\t\t$self->seq($currseq,$self->alphabet());\n\t    }\n\n\t    $currenc = reverse $currenc if $self->strand < 0;\n\t    substr($currenc, $spanstart, $spanend - $spanstart + ($loc->location_type eq 'IN-BETWEEN' ? -1 : 1),\n\t\t   $self->strand >= 0 ? $enc : reverse $enc);\n\t    $currenc = reverse $currenc if $self->strand < 0;\n\n\t    $self->{_encoding} = $currenc;\n\t    $self->_recheck_encoding;\n\n\t    $currenc = $self->{_encoding};\n\t    $currenc = reverse $currenc if $self->strand < 0;\n\t    $enc = substr($currenc, $spanstart, length $enc);\n\t    $enc = reverse $enc if $self->strand < 0;\n\n\t    return $exp ? $enc: $self->_convert2implicit($enc);\n\n\t} else {\n\t    # presume a global redefinition; strip any current gap\n\t    # characters in the sequence so they don't corrupt the\n\t    # encoding\n\t    my $dna = $self->seq;\n\t    $dna =~ s/[\\.\\-]//g;\n\t    $self->seq($dna, 'dna');\n\t    $self->{_encoding} = $enc;\n\t}\n    } else {\n\t$self->throw(\"Only a scalar or a ref to a hash; not a ref to a @{{lc ref $enc}}\");\n    }\n\n    $self->_recheck_encoding();\n\n    return $exp ? $self->{_encoding} : $self->_convert2implicit($self->{_encoding});\n}\n\nsub _convert2implicit {\n\n    my ($self, $enc) = @_;\n\n    $enc =~ s/[DE]/C/g;\n    $enc =~ s/[JK]/I/g;\n    $enc =~ s/V/U/g;\n\n    return $enc;\n}\n\nsub _recheck_encoding {\n\n    my $self = shift;\n\n    my @enc = split //, ($self->{_encoding} || '');\n\n    my @nt = split(//, $self->SUPER::seq);\n    @nt = reverse @nt if $self->strand && $self->strand < 0;\n\n    # make sure an encoding exists!\n    @enc = ('C') x scalar grep { !/[\\.\\-]/o } @nt\n\tunless @enc;\n\n    # check for gaps to be truly present in the sequence\n    # and vice versa\n    my $i;\n    for ($i = 0 ; $i < @nt && $i < @enc ; $i++) {\n\tif ($nt[$i] =~ /[\\.\\-]/o && $enc[$i] !~ m/[GB]/o) {\n\t    splice(@enc, $i, 0, 'G');\n\t} elsif ($nt[$i] !~ /[\\.\\-]/o && $enc[$i] =~ m/[GB]/o) {\n\t    splice(@nt, $i, 0, '-');\n\t}\n    }\n    if ($i < @enc) {\n\t# extra encoding; presumably all gaps?\n\tfor (  ; $i < @enc ; $i++) {\n\t    if ($enc[$i] =~ m/[GB]/o) {\n\t\tpush @nt, '-';\n\t    } else {\n\t\t$self->throw(\"Extraneous encoding info: \" . join('', @enc[$i..$#enc]));\n\t    }\n\t}\n    } elsif ($i < @nt) {\n\tfor (  ; $i < @nt ; $i++) {\n\t    if ($nt[$i] =~ m/[\\.\\-]/o) {\n\t\tpush @enc, 'G';\n\t    } else {\n\t\tpush @enc, 'C';\n\t    }\n\t}\n    }\n\n    my @cde_array = qw(C D E);\n    my @ijk_array = qw(I J K);\n    # convert any leftover implicit coding into explicit coding\n    my ($Cct, $Ict, $Uct, $Vct, $Vwarned) = (0, 0, 0, 0);\n    for ($i = 0 ; $i < @enc ; $i++) {\n\tif ($enc[$i] =~ m/[CDE]/o) {\n\t    my  $temp_index = $Cct %3;\n\t    $enc[$i] = $cde_array[$temp_index];\n\t    $Cct++; $Ict = 0; $Uct = 1;\n\t    $self->warn(\"3' untranslated encoding (V) seen prior to other coding symbols\")\n\t\tif ($Vct && !$Vwarned++);\n\t} elsif ($enc[$i] =~ m/[IJK]/o) {\n\t    $enc[$i] = $ijk_array[$Ict % 3];\n\t    $Ict++; $Uct = 1;\n\t    $self->warn(\"3' untranslated encoding (V) seen before other coding symbols\")\n\t\tif ($Vct && !$Vwarned++);\n\t} elsif ($enc[$i] =~ m/[UV]/o) {\n\t    if ($Uct == 1) {\n\t\t$enc[$i] = 'V';\n\t\t$Vct = 1;\n\t    }\n\t} elsif ($enc[$i] eq 'B') {\n\t    $Cct++; $Ict++\n\t} elsif ($enc[$i] eq 'G') {\n\t    # gap; leave alone\n\t}\n    }\n\n    @nt = reverse @nt if $self->strand && $self->strand < 0;\n\n    $self->{'seq'} = join('', @nt);\n    # $self->seq(join('', @nt), 'dna');\n    $self->{_encoding} = join '', @enc;\n}\n\n=head2 cds\n\n Title   : cds\n Usage   : $cds = $obj->cds(-nogaps => 1);\n Function: obtain the \"spliced\" DNA sequence, by removing any\n           nucleotides that participate in an UTR, forward frameshift\n           or intron, and replacing any unknown nucleotide implied by\n           a backward frameshift or gap with N's.\n Returns : a Bio::Seq::EncodedSeq object, with an encoding consisting only\n           of \"CCCC..\".\n Args    : nogaps - strip any gap characters (resulting from 'G' or 'B'\n           encodings), rather than replacing them with N's.","parameters":[{"label":"$self"},{"label":"@args"}]},"detail":"($self,@args)","definition":"sub","containerName":"main::","children":[{"localvar":"my","definition":"my","name":"$self","containerName":"cds","line":488,"kind":13},{"line":488,"kind":13,"containerName":"cds","name":"@args"},{"localvar":"my","definition":"my","name":"$nogaps","containerName":"cds","line":490,"kind":13},{"line":490,"kind":13,"containerName":"cds","name":"$loc"},{"name":"$self","containerName":"cds","line":490,"kind":13},{"name":"_rearrange","containerName":"cds","line":490,"kind":12},{"line":490,"kind":13,"containerName":"cds","name":"@args"},{"kind":13,"line":491,"containerName":"cds","name":"$nogaps"},{"kind":13,"line":491,"containerName":"cds","name":"$nogaps"},{"kind":13,"line":493,"containerName":"cds","name":"@nt","definition":"my","localvar":"my"},{"name":"$self","containerName":"cds","kind":13,"line":493},{"name":"strand","containerName":"cds","line":493,"kind":12},{"line":493,"kind":13,"containerName":"cds","name":"$self"},{"line":493,"kind":12,"containerName":"cds","name":"revcom"},{"containerName":"cds","name":"seq","kind":12,"line":493},{"line":493,"kind":13,"containerName":"cds","name":"$self"},{"kind":12,"line":493,"containerName":"cds","name":"seq"},{"definition":"my","name":"@enc","containerName":"cds","localvar":"my","kind":13,"line":494},{"name":"$self","containerName":"cds","line":494,"kind":13},{"line":494,"kind":12,"containerName":"cds","name":"_convert2implicit"},{"line":494,"kind":13,"containerName":"cds","name":"$self"},{"localvar":"my","containerName":"cds","name":"$start","definition":"my","line":496,"kind":13},{"name":"$end","containerName":"cds","kind":13,"line":496},{"line":496,"kind":13,"containerName":"cds","name":"@nt"},{"kind":13,"line":498,"name":"$loc","containerName":"cds"},{"line":499,"kind":13,"name":"$start","containerName":"cds"},{"containerName":"cds","name":"$loc","kind":13,"line":499},{"name":"start","containerName":"cds","line":499,"kind":12},{"kind":13,"line":500,"name":"$start","containerName":"cds"},{"line":500,"kind":13,"containerName":"cds","name":"$loc"},{"containerName":"cds","name":"location_type","kind":12,"line":500},{"line":501,"kind":13,"name":"$start","containerName":"cds"},{"containerName":"cds","name":"$self","line":501,"kind":13},{"name":"column_from_residue_number","containerName":"cds","kind":12,"line":501},{"containerName":"cds","name":"$start","kind":13,"line":501},{"line":502,"kind":13,"containerName":"cds","name":"$start"},{"kind":13,"line":504,"name":"$end","containerName":"cds"},{"line":504,"kind":13,"name":"$loc","containerName":"cds"},{"line":504,"kind":12,"name":"end","containerName":"cds"},{"line":505,"kind":13,"containerName":"cds","name":"$end"},{"line":505,"kind":13,"name":"$self","containerName":"cds"},{"kind":12,"line":505,"name":"column_from_residue_number","containerName":"cds"},{"line":505,"kind":13,"containerName":"cds","name":"$end"},{"kind":13,"line":507,"name":"$start","containerName":"cds"},{"name":"$end","containerName":"cds","kind":13,"line":507},{"name":"$end","containerName":"cds","kind":13,"line":507},{"line":507,"kind":13,"containerName":"cds","name":"$start"},{"name":"$self","containerName":"cds","line":507,"kind":13},{"name":"strand","containerName":"cds","line":507,"kind":12},{"containerName":"cds","name":"$start","kind":13,"line":508},{"kind":13,"line":511,"definition":"my","name":"$i","containerName":"cds","localvar":"my"},{"containerName":"cds","name":"$start","line":511,"kind":13},{"kind":13,"line":511,"containerName":"cds","name":"$i"},{"containerName":"cds","name":"$end","line":511,"kind":13},{"containerName":"cds","name":"$i","line":511,"kind":13},{"containerName":"cds","name":"$enc","kind":13,"line":512},{"containerName":"cds","name":"$i","kind":13,"line":512},{"kind":13,"line":512,"name":"$enc","containerName":"cds"},{"kind":13,"line":512,"containerName":"cds","name":"$i"},{"containerName":"cds","name":"$enc","line":512,"kind":13},{"name":"$i","containerName":"cds","line":512,"kind":13},{"containerName":"cds","name":"$nt","kind":13,"line":514},{"kind":13,"line":514,"containerName":"cds","name":"$i"},{"containerName":"cds","name":"$enc","line":515,"kind":13},{"kind":13,"line":515,"containerName":"cds","name":"$i"},{"containerName":"cds","name":"$enc","line":515,"kind":13},{"line":515,"kind":13,"containerName":"cds","name":"$i"},{"kind":13,"line":517,"name":"$nt","containerName":"cds"},{"containerName":"cds","name":"$i","line":517,"kind":13},{"name":"$nogaps","containerName":"cds","line":517,"kind":13},{"name":"$self","containerName":"cds","line":521,"kind":13},{"name":"can_call_new","containerName":"cds","line":521,"kind":12},{"kind":13,"line":521,"containerName":"cds","name":"$self"},{"kind":12,"line":522,"name":"new","containerName":"cds"},{"containerName":"cds","name":"@nt","kind":13,"line":522},{"line":522,"kind":13,"containerName":"cds","name":"$start"},{"containerName":"cds","name":"$end","line":522,"kind":13},{"containerName":"cds","name":"$self","kind":13,"line":523},{"kind":12,"line":523,"containerName":"cds","name":"start"},{"name":"$self","containerName":"cds","kind":13,"line":524},{"kind":12,"line":524,"containerName":"cds","name":"end"}],"line":486,"kind":12},{"kind":12,"line":494,"name":"_encoding"},{"line":522,"kind":12,"name":"defined"},{"children":[{"kind":12,"line":539,"containerName":"translate","name":"cds"}],"line":539,"kind":12,"range":{"start":{"character":0,"line":539},"end":{"line":539,"character":9999}},"name":"translate","definition":"sub","containerName":"main::"},{"line":539,"kind":12,"name":"SUPER","containerName":"translate"},{"kind":12,"line":555,"children":[{"line":555,"kind":12,"name":"cds","containerName":"protseq"},{"containerName":"protseq","name":"seq","kind":12,"line":555}],"containerName":"main::","definition":"sub","name":"protseq","range":{"start":{"character":0,"line":555},"end":{"line":555,"character":9999}}},{"containerName":"translate","name":"SUPER","line":555,"kind":12},{"kind":12,"children":[{"line":584,"kind":13,"localvar":"my","containerName":"dnaseq","name":"$self","definition":"my"},{"kind":13,"line":584,"containerName":"dnaseq","name":"@args"},{"kind":13,"line":585,"name":"$seq","definition":"my","containerName":"dnaseq","localvar":"my"},{"name":"$enc","containerName":"dnaseq","line":585,"kind":13},{"containerName":"dnaseq","name":"$loc","line":585,"kind":13},{"kind":13,"line":585,"name":"$self","containerName":"dnaseq"},{"kind":12,"line":585,"containerName":"dnaseq","name":"_rearrange"},{"name":"@args","containerName":"dnaseq","line":585,"kind":13},{"name":"$self","containerName":"dnaseq","kind":13,"line":588}],"line":582,"definition":"sub","containerName":"main::","signature":{"documentation":"1;\n# $Id: EncodedSeq.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Seq::EncodedSeq\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Aaron Mackey\n#\n# Copyright Aaron Mackey\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::EncodedSeq - subtype of L<Bio::LocatableSeq|Bio::LocatableSeq> to store DNA that encodes a protein\n\n=head1 SYNOPSIS\n\n  $obj = Bio::Seq::EncodedSeq->new(-seq => $dna,\n                                  -encoding => \"CCCCCCCIIIIICCCCC\",\n                                  -start => 1,\n                                  -strand => 1,\n                                  -length => 17);\n\n  # splice out (and possibly revcomp) the coding sequence\n  $cds = obj->cds;\n\n  # obtain the protein translation of the sequence\n  $prot = $obj->translate;\n\n  # other access/inspection routines as with Bio::LocatableSeq and\n  # Bio::SeqI; note that coordinates are relative only to the DNA\n  # sequence, not it's implicit encoded protein sequence.\n\n=head1 DESCRIPTION\n\nBio::Seq::EncodedSeq is a L<Bio::LocatableSeq|Bio::LocatableSeq>\nobject that holds a DNA sequence as well as information about the\ncoding potential of that DNA sequence.  It is meant to be useful in an\nalignment context, where the DNA may contain frameshifts, gaps and/or\nintrons, or in describing the transcript of a gene.  An EncodedSeq\nprovides the ability to access the \"spliced\" coding sequence, meaning\nthat all introns and gaps are removed, and any frameshifts are\nadjusted to provide a \"clean\" CDS.\n\nIn order to make simultaneous use of either the DNA or the implicit\nencoded protein sequence coordinates, please see\nL<Bio::Coordinate::EncodingPair>.\n\n=head1 ENCODING\n\nWe use the term \"encoding\" here to refer to the series of symbols that\nwe use to identify which residues of a DNA sequence are protein-coding\n(i.e. part of a codon), intronic, part of a 5' or 3', frameshift\n\"mutations\", etc.  From this information, a Bio::Seq::EncodedSeq is\nable to \"figure out\" its translational CDS.  There are two sets of\ncoding characters, one termed \"implicit\" and one termed \"explicit\".\n\nThe \"implicit\" encoding is a bit simpler than the \"explicit\" encoding:\n'C' is used for any nucleotide that's part of a codon, 'U' for any\nUTR, etc.  The full list is shown below:\n\n Code  Meaning\n ----  -------\n  C    coding\n  I    intronic\n  U    untranslated\n  G    gapped (for use in alignments)\n  F    a \"forward\", +1 frameshift\n  B    a \"backward\", -1 frameshift\n\nThe \"explicit\" encoding is just an expansion of the \"implicit\"\nencoding, to denote phase:\n\n Code  Meaning\n ----  -------\n  C    coding, 1st codon position\n  D    coding, 2nd codon position\n  E    coding, 3rd codon position\n\n  I    intronic, phase 0 (relative to intron begin)\n  J    intronic, phase 1\n  K    intronic, phase 2\n\n  U    untranslated 3'UTR\n  V    untranslated 5'UTR\n\n  G    gapped (for use in alignments)\n  F    a \"forward\", +1 frameshift\n  B    a \"backward\", -1 frameshift\n\nNote that the explicit coding is meant to provide easy access to\nposition/phase specific nucleotides:\n\n  $obj = Bio::Seq::EncodedSeq->new(-seq => \"ACAATCAGACTACG...\",\n                                   -encoding => \"CCCCCCIII...\"\n                                  );\n\n  # fetch arrays of nucleotides at each codon position:\n  my @pos1 = $obj->dnaseq(encoding => 'C', explicit => 1);\n  my @pos2 = $obj->dnaseq(encoding => 'D');\n  my @pos3 = $obj->dnaseq(encoding => 'E');\n\n  # fetch arrays of \"3-1\" codon dinucleotides, useful for genomic\n  # signature analyses without compounding influences of codon bias:\n  my @pairs = $obj->dnaseq(encoding => 'EC');\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Aaron Mackey\n\nEmail amackey@virginia.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Seq::EncodedSeq;\n\nuse strict;\n\n\nuse base qw(Bio::LocatableSeq);\n\n=head2 new\n\n Title   : new\n Usage   : $obj = Bio::Seq::EncodedSeq->new(-seq      => \"AGTACGTGTCATG\",\n                                            -encoding => \"CCCCCCFCCCCCC\",\n                                            -id       => \"myseq\",\n                                            -start    => 1,\n                                            -end      => 13,\n                                            -strand   => 1\n                                      );\n Function: creates a new Bio::Seq::EncodedSeq object from a supplied DNA\n           sequence\n Returns : a new Bio::Seq::EncodedSeq object\n\n Args    : seq      - primary nucleotide sequence used to encode the\n                      protein; note that any positions involved in a\n                      gap ('G') or backward frameshift ('B') should\n                      have one or more gap characters; if the encoding\n                      specifies G or B, but no (or not enough) gap\n                      characters exist, *they'll be added*; similary,\n                      if there are gap characters without a\n                      corresponding G or B encoding, G's will be\n                      inserted into the encoding.  This allows some\n                      flexibility in specifying your sequence and\n                      coding without having to calculate a lot of the\n                      encoding for yourself.\n\n           encoding - a string of characters (see Encoding Table)\n                      describing backwards frameshifts implied by the\n                      encoding but not present in the sequence will be\n                      added (as '-'s) to the sequence.  If not\n                      supplied, it will be assumed that all positions\n                      are coding (C).  Encoding may include either\n                      implicit phase encoding characters (i.e. \"CCC\")\n                      and/or explicit encoding characters (i.e. \"CDE\").\n                      Additionally, prefixed numbers may be used to\n                      denote repetition (i.e. \"27C3I28C\").\n\n                      Alternatively, encoding may be a hashref\n                      datastructure, with encoding characters as keys\n                      and Bio::LocationI objects (or arrayrefs of\n                      Bio::LocationI objects) as values, e.g.:\n\n                      { C => [ Bio::Location::Simple->new(1,9),\n                               Bio::Location::Simple->new(11,13) ],\n                        F => Bio::Location::Simple->new(10,10),\n                      } # same as \"CCCCCCCCCFCCC\"\n\n                      Note that if the location ranges overlap, the\n                      behavior of the encoding will be undefined\n                      (well, it will be defined, but only according to\n                      the order in which the hash keys are read, which\n                      is basically undefined ... just don't do that).\n\n           id, start, end, strand - as with Bio::LocatableSeq; note\n                      that the coordinates are relative to the\n                      encoding DNA sequence, not the implicit protein\n                      sequence.  If strand is reversed, then the\n                      encoding is assumed to be relative to the\n                      reverse strand as well.\n\n\n#'\n\nsub new {\n\n    my ($self, @args) = @_;\n    $self = $self->SUPER::new(@args, -alphabet => 'dna');\n    my ($enc) = $self->_rearrange([qw(ENCODING)], @args);\n    # set the real encoding:\n    if ($enc) {\n\t$self->encoding($enc);\n    } else {\n\t$self->_recheck_encoding;\n    }\n    return $self;\n}\n\n=head2 encoding\n\n Title   : encoding\n Usage   : $obj->encoding(\"CCCCCC\");\n           $obj->encoding( -encoding => { I => $location } );\n           $enc = $obj->encoding(-explicit => 1);\n           $enc = $obj->encoding(\"CCCCCC\", -explicit => 1);\n           $enc = $obj->encoding(-location => $location,\n                                 -explicit => 1,\n                                 -absolute => 1 );\n Function: get/set the objects encoding, either globally or by location(s).\n Returns : the (possibly new) encoding string.\n Args    : encoding - see the encoding argument to the new() function.\n\n           explicit - whether or not to return explicit phase\n                      information in the coding (i.e. \"CCC\" becomes\n                      \"CDE\", \"III\" becomes \"IJK\", etc); defaults to 0.\n\n           location - optional; location to get/set the encoding.\n                      Defaults to the entire sequence.\n\n           absolute - whether or not the locational elements (either\n                      in the encoding hashref or the location\n                      argument) are relative to the absolute start/end\n                      of the Bio::LocatableSeq, or to the internal,\n                      relative coordinate system (beginning at 1);\n                      defaults to 0 (i.e. relative)\n\n\nsub encoding {\n\n    my ($self, @args) = @_;\n    my ($enc, $loc, $exp, $abs) = $self->_rearrange([qw(ENCODING LOCATION EXPLICIT ABSOLUTE)], @args);\n\n    if (!$enc) {\n\t# do nothing; _recheck_encoding will fix for us, if necessary\n    } elsif (ref $enc eq 'HASH') {\n\t$self->throw( -class => 'Bio::Root::NotImplemented',\n\t\t      -text  => \"Hashref functionality not yet implemented;\\nplease email me if you really need this.\");\n\t#TODO: finish all this\n\twhile (my ($char, $locs) = each %$enc) {\n\t    if (ref $locs eq 'ARRAY') {\n\t    } elsif (UNIVERSAL::isa($locs, \"Bio::LocationI\")) {\n\t    } else {\n\t\t$self->throw(\"Only a scalar or a ref to a hash; not a ref to a @{{lc ref $enc}}\");\n\t    }\n\t}\n    } elsif (! ref $enc) {\n\t$enc = uc $enc;\n\t$exp = 1 if (!defined $exp && $enc =~ m/[DEJKV]/o);\n\n\tif ($enc =~ m/\\d/o) { # numerically \"enhanced\" encoding\n\t    my $numenc = $enc;\n\t    $enc = '';\n\t    while ($numenc =~ m/\\G(\\d*)([CDEIJKUVGFB])/g) {\n\t\tmy ($num, $char) = ($1, $2);\n\t\t$num = 1 unless $num;\n\t\t$enc .= $char x $num;\n\t    }\n\t}\n\n\tif (defined $exp && $exp == 0 && $enc =~ m/([^CIUGFB])/) {\n\t    $self->throw(\"Unrecognized character '$1' in implicit encoding\");\n\t} elsif ($enc =~ m/[^CDEIJKUVGFB]/) {\n\t    $self->throw(\"Unrecognized character '$1' in explicit encoding\");\n\t}\n\n\tif ($loc) { # a global location, over which to apply the specified encoding.\n\n\t    # balk if too many non-gap characters present in encoding:\n\t    my ($ct) = $enc =~ tr/GB/GB/;\n\t    $ct = length($enc) - $ct;\n\t    $self->throw(\"Location length doesn't match number of coding chars in encoding!\")\n\t\tif ($loc->location_type eq 'EXACT' &&  $loc->length != $ct);\n\n\t    my $start = $loc->start;\n\t    my $end = $loc->end;\n\n\t    # strip any encoding that hangs off the ends of the sequence:\n\t    if ($start < $self->start) {\n\t\tmy $diff = $self->start - $start;\n\t\t$start = $self->start;\n\t\t$enc = substr($enc, $diff);\n\t    }\n\t    if ($end > $self->end) {\n\t\tmy $diff = $end - $self->end;\n\t\t$end = $self->end;\n\t\t$enc = substr($enc, -$diff);\n\t    }\n\n\t    my $currenc = $self->{_encoding};\n\t    my $currseq = $self->seq;\n\n\t    my ($spanstart, $spanend) = ($self->column_from_residue_number($start),\n\t\t\t\t\t $self->column_from_residue_number($end) );\n\n\t    if ($currseq) {\n\t\t# strip any gaps in sequence spanned by this location:\n\t\t($spanstart, $spanend) = ($spanend, $spanstart) if $self->strand < 0;\n\t\tmy ($before, $in, $after) = $currseq =~ m/(.{@{[ $spanstart - ($loc->location_type eq 'IN-BETWEEN' ? 0 : 1) ]}})\n                                                          (.{@{[ $spanend - $spanstart + ($loc->location_type eq 'IN-BETWEEN' ? -1 : 1) ]}})\n                                                          (.*)\n                                                         /x;\n                $in ||= '';\n\t\t$in =~ s/[\\.\\-]+//g;\n\t\t$currseq = ($before||'') . $in. ($after||'');\n\t\t# change seq without changing the alphabet\n\t\t$self->seq($currseq,$self->alphabet());\n\t    }\n\n\t    $currenc = reverse $currenc if $self->strand < 0;\n\t    substr($currenc, $spanstart, $spanend - $spanstart + ($loc->location_type eq 'IN-BETWEEN' ? -1 : 1),\n\t\t   $self->strand >= 0 ? $enc : reverse $enc);\n\t    $currenc = reverse $currenc if $self->strand < 0;\n\n\t    $self->{_encoding} = $currenc;\n\t    $self->_recheck_encoding;\n\n\t    $currenc = $self->{_encoding};\n\t    $currenc = reverse $currenc if $self->strand < 0;\n\t    $enc = substr($currenc, $spanstart, length $enc);\n\t    $enc = reverse $enc if $self->strand < 0;\n\n\t    return $exp ? $enc: $self->_convert2implicit($enc);\n\n\t} else {\n\t    # presume a global redefinition; strip any current gap\n\t    # characters in the sequence so they don't corrupt the\n\t    # encoding\n\t    my $dna = $self->seq;\n\t    $dna =~ s/[\\.\\-]//g;\n\t    $self->seq($dna, 'dna');\n\t    $self->{_encoding} = $enc;\n\t}\n    } else {\n\t$self->throw(\"Only a scalar or a ref to a hash; not a ref to a @{{lc ref $enc}}\");\n    }\n\n    $self->_recheck_encoding();\n\n    return $exp ? $self->{_encoding} : $self->_convert2implicit($self->{_encoding});\n}\n\nsub _convert2implicit {\n\n    my ($self, $enc) = @_;\n\n    $enc =~ s/[DE]/C/g;\n    $enc =~ s/[JK]/I/g;\n    $enc =~ s/V/U/g;\n\n    return $enc;\n}\n\nsub _recheck_encoding {\n\n    my $self = shift;\n\n    my @enc = split //, ($self->{_encoding} || '');\n\n    my @nt = split(//, $self->SUPER::seq);\n    @nt = reverse @nt if $self->strand && $self->strand < 0;\n\n    # make sure an encoding exists!\n    @enc = ('C') x scalar grep { !/[\\.\\-]/o } @nt\n\tunless @enc;\n\n    # check for gaps to be truly present in the sequence\n    # and vice versa\n    my $i;\n    for ($i = 0 ; $i < @nt && $i < @enc ; $i++) {\n\tif ($nt[$i] =~ /[\\.\\-]/o && $enc[$i] !~ m/[GB]/o) {\n\t    splice(@enc, $i, 0, 'G');\n\t} elsif ($nt[$i] !~ /[\\.\\-]/o && $enc[$i] =~ m/[GB]/o) {\n\t    splice(@nt, $i, 0, '-');\n\t}\n    }\n    if ($i < @enc) {\n\t# extra encoding; presumably all gaps?\n\tfor (  ; $i < @enc ; $i++) {\n\t    if ($enc[$i] =~ m/[GB]/o) {\n\t\tpush @nt, '-';\n\t    } else {\n\t\t$self->throw(\"Extraneous encoding info: \" . join('', @enc[$i..$#enc]));\n\t    }\n\t}\n    } elsif ($i < @nt) {\n\tfor (  ; $i < @nt ; $i++) {\n\t    if ($nt[$i] =~ m/[\\.\\-]/o) {\n\t\tpush @enc, 'G';\n\t    } else {\n\t\tpush @enc, 'C';\n\t    }\n\t}\n    }\n\n    my @cde_array = qw(C D E);\n    my @ijk_array = qw(I J K);\n    # convert any leftover implicit coding into explicit coding\n    my ($Cct, $Ict, $Uct, $Vct, $Vwarned) = (0, 0, 0, 0);\n    for ($i = 0 ; $i < @enc ; $i++) {\n\tif ($enc[$i] =~ m/[CDE]/o) {\n\t    my  $temp_index = $Cct %3;\n\t    $enc[$i] = $cde_array[$temp_index];\n\t    $Cct++; $Ict = 0; $Uct = 1;\n\t    $self->warn(\"3' untranslated encoding (V) seen prior to other coding symbols\")\n\t\tif ($Vct && !$Vwarned++);\n\t} elsif ($enc[$i] =~ m/[IJK]/o) {\n\t    $enc[$i] = $ijk_array[$Ict % 3];\n\t    $Ict++; $Uct = 1;\n\t    $self->warn(\"3' untranslated encoding (V) seen before other coding symbols\")\n\t\tif ($Vct && !$Vwarned++);\n\t} elsif ($enc[$i] =~ m/[UV]/o) {\n\t    if ($Uct == 1) {\n\t\t$enc[$i] = 'V';\n\t\t$Vct = 1;\n\t    }\n\t} elsif ($enc[$i] eq 'B') {\n\t    $Cct++; $Ict++\n\t} elsif ($enc[$i] eq 'G') {\n\t    # gap; leave alone\n\t}\n    }\n\n    @nt = reverse @nt if $self->strand && $self->strand < 0;\n\n    $self->{'seq'} = join('', @nt);\n    # $self->seq(join('', @nt), 'dna');\n    $self->{_encoding} = join '', @enc;\n}\n\n=head2 cds\n\n Title   : cds\n Usage   : $cds = $obj->cds(-nogaps => 1);\n Function: obtain the \"spliced\" DNA sequence, by removing any\n           nucleotides that participate in an UTR, forward frameshift\n           or intron, and replacing any unknown nucleotide implied by\n           a backward frameshift or gap with N's.\n Returns : a Bio::Seq::EncodedSeq object, with an encoding consisting only\n           of \"CCCC..\".\n Args    : nogaps - strip any gap characters (resulting from 'G' or 'B'\n           encodings), rather than replacing them with N's.\n\n\nsub cds {\n\n    my ($self, @args) = @_;\n\n    my ($nogaps, $loc) = $self->_rearrange([qw(NOGAPS LOCATION)], @args);\n    $nogaps = 0 unless defined $nogaps;\n\n    my @nt = split //, $self->strand < 0 ? $self->revcom->seq : $self->seq;\n    my @enc = split //, $self->_convert2implicit($self->{_encoding});\n\n    my ($start, $end) = (0, scalar @nt);\n\n    if ($loc) {\n\t$start = $loc->start;\n\t$start++ if $loc->location_type eq 'IN-BETWEEN';\n\t$start = $self->column_from_residue_number($start);\n\t$start--;\n\n\t$end = $loc->end;\n\t$end = $self->column_from_residue_number($end);\n\n\t($start, $end) = ($end, $start) if $self->strand < 0;\n\t$start--;\n    }\n\n    for (my $i = $start ; $i < $end ; $i++) {\n\tif ($enc[$i] eq 'I' || $enc[$i] eq 'U' || $enc[$i] eq 'F') {\n\t    # remove introns, untranslated and forward frameshift nucleotides\n\t    $nt[$i] = undef;\n\t} elsif ($enc[$i] eq 'G' || $enc[$i] eq 'B') {\n\t    # replace gaps and backward frameshifts with N's, unless asked not to.\n\t    $nt[$i] = $nogaps ? undef : 'N';\n\t}\n    }\n\n    return ($self->can_call_new ? ref($self) : __PACKAGE__)->new\n\t(-seq => join('', grep { defined } @nt[$start..--$end]),\n\t -start => $self->start,\n\t -end => $self->end,\n\t -strand => 1, -alphabet => 'dna');\n}\n\n=head2 translate\n\n Title   : translate\n Usage   : $prot = $obj->translate(@args);\n Function: obtain the protein sequence encoded by the underlying DNA\n           sequence; same as $obj->cds()->translate(@args).\n Returns : a Bio::PrimarySeq object.\n Args    : same as the translate() function of Bio::PrimarySeqI\n\n\nsub translate { shift->cds(-nogaps => 1, @_)->SUPER::translate(@_) };\n\n=head2 protseq\n\n Title   : seq\n Usage   : $protseq = $obj->protseq();\n Function: obtain the raw protein sequence encoded by the underlying\n           DNA sequence; This is the same as calling\n           $obj->translate()->seq();\n Returns : a string of single-letter amino acid codes\n Args :    same as the seq() function of Bio::PrimarySeq; note that this\n           function may not be used to set the protein sequence; see\n           the dnaseq() function for that.\n\n\nsub protseq { shift->cds(-nogaps => 1, @_)->SUPER::translate(@_)->seq };\n\n=head2 dnaseq\n\n Title   : dnaseq\n Usage   : $dnaseq = $obj->dnaseq();\n           $obj->dnaseq(\"ACGTGTCGT\", \"CCCCCCCCC\");\n           $obj->dnaseq(-seq      => \"ATG\",\n                        -encoding => \"CCC\",\n                        -location => $loc );\n           @introns = $obj->$dnaseq(-encoding => 'I')\n Function: get/set the underlying DNA sequence; will overwrite any\n           current DNA and/or encoding information present.\n Returns : a string of single-letter nucleotide codes, including any\n           gaps implied by the encoding.\n Args    : seq      - the DNA sequence to be used as a replacement\n           encoding - the encoding of the DNA sequence (see the new()\n                      constructor); defaults to all 'C' if setting a\n                      new DNA sequence.  If no new DNA sequence is\n                      being provided, then the encoding is used as a\n                      \"filter\" for which to return fragments of\n                      non-overlapping DNA that match the encoding.\n           location - optional, the location of the DNA sequence to\n                      get/set; defaults to the entire sequence.","parameters":[{"label":"$self"},{"label":"@args"}],"label":"dnaseq($self,@args)"},"detail":"($self,@args)","name":"dnaseq","range":{"start":{"character":0,"line":582},"end":{"character":9999,"line":589}}},{"line":592,"children":[{"line":594,"kind":13,"localvar":"my","containerName":"trunc","name":"$self","definition":"my"},{"containerName":"trunc","name":"$start","kind":13,"line":594},{"name":"$end","containerName":"trunc","kind":13,"line":594},{"containerName":"trunc","definition":"my","name":"$new","localvar":"my","kind":13,"line":595},{"line":595,"kind":13,"containerName":"trunc","name":"$self"},{"kind":13,"line":595,"containerName":"trunc","name":"$start"},{"kind":13,"line":595,"name":"$end","containerName":"trunc"},{"containerName":"trunc","name":"$start","kind":13,"line":596},{"line":597,"kind":13,"localvar":"my","definition":"my","name":"$enc","containerName":"trunc"},{"name":"$self","containerName":"trunc","kind":13,"line":597},{"containerName":"trunc","name":"$enc","line":598,"kind":13},{"containerName":"trunc","name":"$enc","kind":13,"line":598},{"name":"$self","containerName":"trunc","kind":13,"line":598},{"kind":12,"line":598,"name":"strand","containerName":"trunc"},{"kind":13,"line":599,"containerName":"trunc","name":"$enc"},{"name":"$enc","containerName":"trunc","kind":13,"line":599},{"containerName":"trunc","name":"$start","line":599,"kind":13},{"kind":13,"line":599,"name":"$end","containerName":"trunc"},{"kind":13,"line":599,"name":"$start","containerName":"trunc"},{"containerName":"trunc","name":"$enc","kind":13,"line":600},{"containerName":"trunc","name":"$enc","kind":13,"line":600},{"containerName":"trunc","name":"$self","kind":13,"line":600},{"line":600,"kind":12,"containerName":"trunc","name":"strand"},{"containerName":"trunc","name":"$new","kind":13,"line":601},{"kind":12,"line":601,"name":"encoding","containerName":"trunc"},{"containerName":"trunc","name":"$enc","line":601,"kind":13},{"line":602,"kind":13,"containerName":"trunc","name":"$new"}],"kind":12,"detail":"($self,$start,$end)","signature":{"label":"trunc($self,$start,$end)","parameters":[{"label":"$self"},{"label":"$start"},{"label":"$end"}],"documentation":" need to overload this so that we truncate both the seq and the encoding!"},"containerName":"main::","definition":"sub","range":{"start":{"character":0,"line":592},"end":{"line":603,"character":9999}},"name":"trunc"},{"containerName":"trunc","name":"SUPER","line":595,"kind":12},{"kind":12,"line":597,"name":"_encoding"}],"version":5}