{"version":5,"vars":[{"name":"vars","containerName":"","line":88,"kind":2},{"line":91,"kind":2,"containerName":"","name":"base"},{"name":"%MODEMAP","containerName":null,"kind":13,"line":96},{"containerName":null,"name":"%MAPPING","kind":13,"line":102},{"range":{"start":{"character":0,"line":152},"end":{"character":9999,"line":180}},"name":"_initialize","children":[{"localvar":"my","definition":"my","name":"$self","containerName":"_initialize","line":153,"kind":13},{"name":"@args","containerName":"_initialize","kind":13,"line":153},{"name":"$self","containerName":"_initialize","kind":13,"line":154},{"name":"@args","containerName":"_initialize","kind":13,"line":154},{"localvar":"my","name":"$handler","definition":"my","containerName":"_initialize","line":155,"kind":13},{"line":155,"kind":13,"name":"$self","containerName":"_initialize"},{"kind":12,"line":155,"containerName":"_initialize","name":"_eventHandler"},{"kind":13,"line":156,"containerName":"_initialize","name":"$handler"},{"kind":12,"line":156,"name":"register_factory","containerName":"_initialize"},{"line":158,"kind":12,"name":"new","containerName":"_initialize"},{"containerName":"_initialize","name":"$handler","kind":13,"line":164},{"kind":12,"line":164,"name":"register_factory","containerName":"_initialize"},{"name":"new","containerName":"_initialize","kind":12,"line":166},{"name":"$handler","containerName":"_initialize","line":172,"kind":13},{"name":"register_factory","containerName":"_initialize","line":172,"kind":12},{"containerName":"_initialize","name":"new","line":174,"kind":12},{"containerName":"_initialize","name":"$self","kind":13,"line":179}],"line":152,"kind":12,"signature":{"label":"_initialize($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: hmmer.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::hmmer\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::hmmer - A parser for HMMER output (hmmpfam, hmmsearch)\n\n=head1 SYNOPSIS\n\n    # do not use this class directly it is available through Bio::SearchIO\n    use Bio::SearchIO;\n    my $in = Bio::SearchIO->new(-format => 'hmmer',\n                               -file   => 't/data/L77119.hmmer');\n    while( my $result = $in->next_result ) {\n        # this is a Bio::Search::Result::HMMERResult object\n        print $result->query_name(), \" for HMM \", $result->hmm_name(), \"\\n\";\n        while( my $hit = $result->next_hit ) {\n            print $hit->name(), \"\\n\";\n            while( my $hsp = $hit->next_hsp ) {\n                print \"length is \", $hsp->length(), \"\\n\";\n            }\n        }\n    }\n\n=head1 DESCRIPTION\n\nThis object implements a parser for HMMER output.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::hmmer;\n\nuse strict;\n\nuse Bio::Factory::ObjectFactory;\n\nuse vars qw(%MAPPING %MODEMAP\n);\n\nuse base qw(Bio::SearchIO);\n\nBEGIN {\n\n    # mapping of HMMER items to Bioperl hash keys\n    %MODEMAP = (\n        'HMMER_Output' => 'result',\n        'Hit'          => 'hit',\n        'Hsp'          => 'hsp'\n    );\n\n    %MAPPING = (\n        'Hsp_bit-score'   => 'HSP-bits',\n        'Hsp_score'       => 'HSP-score',\n        'Hsp_evalue'      => 'HSP-evalue',\n        'Hsp_query-from'  => 'HSP-query_start',\n        'Hsp_query-to'    => 'HSP-query_end',\n        'Hsp_hit-from'    => 'HSP-hit_start',\n        'Hsp_hit-to'      => 'HSP-hit_end',\n        'Hsp_positive'    => 'HSP-conserved',\n        'Hsp_identity'    => 'HSP-identical',\n        'Hsp_gaps'        => 'HSP-hsp_gaps',\n        'Hsp_hitgaps'     => 'HSP-hit_gaps',\n        'Hsp_querygaps'   => 'HSP-query_gaps',\n        'Hsp_qseq'        => 'HSP-query_seq',\n        'Hsp_hseq'        => 'HSP-hit_seq',\n        'Hsp_midline'     => 'HSP-homology_seq',\n        'Hsp_align-len'   => 'HSP-hsp_length',\n        'Hsp_query-frame' => 'HSP-query_frame',\n        'Hsp_hit-frame'   => 'HSP-hit_frame',\n\n        'Hit_id'        => 'HIT-name',\n        'Hit_len'       => 'HIT-length',\n        'Hit_accession' => 'HIT-accession',\n        'Hit_desc'      => 'HIT-description',\n        'Hit_signif'    => 'HIT-significance',\n        'Hit_score'     => 'HIT-score',\n\n        'HMMER_program'   => 'RESULT-algorithm_name',\n        'HMMER_version'   => 'RESULT-algorithm_version',\n        'HMMER_query-def' => 'RESULT-query_name',\n        'HMMER_query-len' => 'RESULT-query_length',\n        'HMMER_query-acc' => 'RESULT-query_accession',\n        'HMMER_querydesc' => 'RESULT-query_description',\n        'HMMER_hmm'       => 'RESULT-hmm_name',\n        'HMMER_seqfile'   => 'RESULT-sequence_file',\n        'HMMER_db'        => 'RESULT-database_name',\n    );\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::hmmer->new();\n Function: Builds a new Bio::SearchIO::hmmer object \n Returns : Bio::SearchIO::hmmer\n Args    : -fh/-file => HMMER filename\n           -format   => 'hmmer'"},"detail":"($self,@args)","definition":"sub","containerName":"main::"},{"line":154,"kind":12,"name":"SUPER","containerName":"_initialize"},{"containerName":"Factory::ObjectFactory","name":"Bio","line":158,"kind":12},{"containerName":"Factory::ObjectFactory","name":"Bio","line":166,"kind":12},{"kind":12,"line":174,"name":"Bio","containerName":"Factory::ObjectFactory"},{"name":"next_result","range":{"end":{"line":485,"character":9999},"start":{"character":0,"line":192}},"definition":"sub","containerName":"main::","signature":{"label":"next_result($self)","documentation":"1;\n# $Id: hmmer.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::hmmer\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::hmmer - A parser for HMMER output (hmmpfam, hmmsearch)\n\n=head1 SYNOPSIS\n\n    # do not use this class directly it is available through Bio::SearchIO\n    use Bio::SearchIO;\n    my $in = Bio::SearchIO->new(-format => 'hmmer',\n                               -file   => 't/data/L77119.hmmer');\n    while( my $result = $in->next_result ) {\n        # this is a Bio::Search::Result::HMMERResult object\n        print $result->query_name(), \" for HMM \", $result->hmm_name(), \"\\n\";\n        while( my $hit = $result->next_hit ) {\n            print $hit->name(), \"\\n\";\n            while( my $hsp = $hit->next_hsp ) {\n                print \"length is \", $hsp->length(), \"\\n\";\n            }\n        }\n    }\n\n=head1 DESCRIPTION\n\nThis object implements a parser for HMMER output.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::hmmer;\n\nuse strict;\n\nuse Bio::Factory::ObjectFactory;\n\nuse vars qw(%MAPPING %MODEMAP\n);\n\nuse base qw(Bio::SearchIO);\n\nBEGIN {\n\n    # mapping of HMMER items to Bioperl hash keys\n    %MODEMAP = (\n        'HMMER_Output' => 'result',\n        'Hit'          => 'hit',\n        'Hsp'          => 'hsp'\n    );\n\n    %MAPPING = (\n        'Hsp_bit-score'   => 'HSP-bits',\n        'Hsp_score'       => 'HSP-score',\n        'Hsp_evalue'      => 'HSP-evalue',\n        'Hsp_query-from'  => 'HSP-query_start',\n        'Hsp_query-to'    => 'HSP-query_end',\n        'Hsp_hit-from'    => 'HSP-hit_start',\n        'Hsp_hit-to'      => 'HSP-hit_end',\n        'Hsp_positive'    => 'HSP-conserved',\n        'Hsp_identity'    => 'HSP-identical',\n        'Hsp_gaps'        => 'HSP-hsp_gaps',\n        'Hsp_hitgaps'     => 'HSP-hit_gaps',\n        'Hsp_querygaps'   => 'HSP-query_gaps',\n        'Hsp_qseq'        => 'HSP-query_seq',\n        'Hsp_hseq'        => 'HSP-hit_seq',\n        'Hsp_midline'     => 'HSP-homology_seq',\n        'Hsp_align-len'   => 'HSP-hsp_length',\n        'Hsp_query-frame' => 'HSP-query_frame',\n        'Hsp_hit-frame'   => 'HSP-hit_frame',\n\n        'Hit_id'        => 'HIT-name',\n        'Hit_len'       => 'HIT-length',\n        'Hit_accession' => 'HIT-accession',\n        'Hit_desc'      => 'HIT-description',\n        'Hit_signif'    => 'HIT-significance',\n        'Hit_score'     => 'HIT-score',\n\n        'HMMER_program'   => 'RESULT-algorithm_name',\n        'HMMER_version'   => 'RESULT-algorithm_version',\n        'HMMER_query-def' => 'RESULT-query_name',\n        'HMMER_query-len' => 'RESULT-query_length',\n        'HMMER_query-acc' => 'RESULT-query_accession',\n        'HMMER_querydesc' => 'RESULT-query_description',\n        'HMMER_hmm'       => 'RESULT-hmm_name',\n        'HMMER_seqfile'   => 'RESULT-sequence_file',\n        'HMMER_db'        => 'RESULT-database_name',\n    );\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::hmmer->new();\n Function: Builds a new Bio::SearchIO::hmmer object \n Returns : Bio::SearchIO::hmmer\n Args    : -fh/-file => HMMER filename\n           -format   => 'hmmer'\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n    my $handler = $self->_eventHandler;\n    $handler->register_factory(\n        'result',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Result::HMMERResult',\n            -interface => 'Bio::Search::Result::ResultI'\n        )\n    );\n\n    $handler->register_factory(\n        'hit',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Hit::HMMERHit',\n            -interface => 'Bio::Search::Hit::HitI'\n        )\n    );\n\n    $handler->register_factory(\n        'hsp',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::HSP::HMMERHSP',\n            -interface => 'Bio::Search::HSP::HSPI'\n        )\n    );\n    $self->{'_hmmidline'} = 'HMMER 2.2g (August 2001)';\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none","parameters":[{"label":"$self"}]},"detail":"($self)","kind":12,"children":[{"line":193,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"next_result"},{"line":194,"kind":13,"localvar":"my","containerName":"next_result","definition":"my","name":"$seentop"},{"line":195,"kind":13,"localvar":"my","containerName":"next_result","name":"$reporttype","definition":"my"},{"localvar":"my","containerName":"next_result","definition":"my","name":"$last","line":196,"kind":13},{"name":"@hitinfo","containerName":"next_result","line":196,"kind":13},{"line":196,"kind":13,"containerName":"next_result","name":"@hspinfo"},{"name":"%hspinfo","containerName":"next_result","kind":13,"line":196},{"containerName":"next_result","name":"%hitinfo","line":196,"kind":13},{"line":200,"kind":13,"localvar":"my","definition":"my","name":"$verbose","containerName":"next_result"},{"containerName":"next_result","name":"$self","line":200,"kind":13},{"name":"verbose","containerName":"next_result","kind":12,"line":200},{"line":201,"kind":13,"name":"$self","containerName":"next_result"},{"line":201,"kind":12,"containerName":"next_result","name":"start_document"},{"line":203,"kind":13,"name":"$self","containerName":"next_result"},{"containerName":"next_result","name":"_readline","kind":12,"line":203},{"kind":13,"line":204,"name":"$lineorig","definition":"my","containerName":"next_result","localvar":"my"},{"line":207,"kind":13,"localvar":"my","containerName":"next_result","name":"$prog","definition":"my"},{"line":207,"kind":13,"containerName":"next_result","name":"$version"},{"line":208,"kind":13,"name":"$seentop","containerName":"next_result"},{"kind":13,"line":209,"name":"$self","containerName":"next_result"},{"line":209,"kind":12,"containerName":"next_result","name":"_pushback"},{"name":"$self","containerName":"next_result","kind":13,"line":210},{"kind":12,"line":210,"containerName":"next_result","name":"end_element"},{"name":"$self","containerName":"next_result","kind":13,"line":211},{"line":211,"kind":12,"name":"end_document","containerName":"next_result"},{"kind":13,"line":213,"name":"$self","containerName":"next_result"},{"containerName":"next_result","name":"$self","kind":13,"line":214},{"containerName":"next_result","name":"start_element","line":214,"kind":12},{"line":215,"kind":13,"containerName":"next_result","name":"$self"},{"name":"$seentop","containerName":"next_result","kind":13,"line":216},{"containerName":"next_result","name":"$last","line":217,"kind":13},{"containerName":"next_result","name":"$reporttype","kind":13,"line":218},{"containerName":"next_result","name":"$last","kind":13,"line":218},{"line":219,"kind":13,"name":"$self","containerName":"next_result"},{"name":"element","containerName":"next_result","kind":12,"line":219},{"name":"$reporttype","containerName":"next_result","line":222,"kind":13},{"line":226,"kind":13,"name":"$self","containerName":"next_result"},{"kind":12,"line":226,"containerName":"next_result","name":"element"},{"line":230,"kind":13,"name":"$version","containerName":"next_result"},{"kind":13,"line":234,"containerName":"next_result","name":"$self"},{"containerName":"next_result","name":"$lineorig","line":234,"kind":13},{"containerName":"next_result","name":"$self","kind":13,"line":235},{"name":"element","containerName":"next_result","line":235,"kind":12},{"kind":13,"line":243,"containerName":"next_result","name":"$self"},{"name":"$lineorig","containerName":"next_result","kind":13,"line":243},{"containerName":"next_result","name":"$self","line":245,"kind":13},{"name":"element","containerName":"next_result","kind":12,"line":245},{"kind":13,"line":252,"name":"$self","containerName":"next_result"},{"containerName":"next_result","name":"element","kind":12,"line":252},{"name":"$seentop","containerName":"next_result","kind":13,"line":260},{"line":263,"kind":13,"name":"$self","containerName":"next_result"},{"containerName":"next_result","name":"_pushback","kind":12,"line":263},{"line":263,"kind":13,"name":"$self","containerName":"next_result"},{"line":264,"kind":13,"name":"$self","containerName":"next_result"},{"name":"_pushback","containerName":"next_result","kind":12,"line":264},{"containerName":"next_result","name":"$self","kind":13,"line":264},{"name":"$self","containerName":"next_result","kind":13,"line":265},{"kind":12,"line":265,"name":"_pushback","containerName":"next_result"},{"line":265,"kind":13,"containerName":"next_result","name":"$self"},{"name":"$self","containerName":"next_result","kind":13,"line":266},{"line":266,"kind":12,"name":"_pushback","containerName":"next_result"},{"line":266,"kind":13,"name":"$lineorig","containerName":"next_result"},{"kind":13,"line":270,"containerName":"next_result","name":"$self"},{"name":"element","containerName":"next_result","kind":12,"line":270},{"kind":13,"line":279,"containerName":"next_result","name":"$self"},{"name":"element","containerName":"next_result","line":279,"kind":12},{"containerName":"next_result","name":"$self","kind":13,"line":288},{"line":288,"kind":12,"containerName":"next_result","name":"element"},{"kind":13,"line":295,"name":"$self","containerName":"next_result"},{"line":296,"kind":13,"name":"$self","containerName":"next_result"},{"name":"$self","containerName":"next_result","kind":13,"line":301},{"kind":12,"line":301,"containerName":"next_result","name":"_readline"},{"containerName":"next_result","name":"@line","definition":"my","localvar":"my","kind":13,"line":304},{"line":305,"kind":13,"localvar":"my","containerName":"next_result","name":"$name","definition":"my"},{"name":"$n","containerName":"next_result","kind":13,"line":305},{"kind":13,"line":305,"name":"$evalue","containerName":"next_result"},{"kind":13,"line":305,"containerName":"next_result","name":"$score"},{"containerName":"next_result","name":"@line","line":306,"kind":13},{"kind":13,"line":306,"containerName":"next_result","name":"@line"},{"kind":13,"line":306,"name":"@line","containerName":"next_result"},{"line":306,"kind":13,"containerName":"next_result","name":"@line"},{"line":307,"kind":13,"localvar":"my","containerName":"next_result","definition":"my","name":"$desc"},{"line":307,"kind":13,"name":"@line","containerName":"next_result"},{"name":"@hitinfo","containerName":"next_result","line":308,"kind":13},{"name":"$name","containerName":"next_result","kind":13,"line":308},{"containerName":"next_result","name":"$desc","kind":13,"line":308},{"kind":13,"line":308,"name":"$evalue","containerName":"next_result"},{"line":308,"kind":13,"name":"$score","containerName":"next_result"},{"name":"$hitinfo","containerName":"next_result","line":309,"kind":13},{"line":309,"kind":13,"name":"$name","containerName":"next_result"},{"name":"@hspinfo","containerName":"next_result","line":313,"kind":13},{"line":315,"kind":13,"containerName":"next_result","name":"$self"},{"containerName":"next_result","name":"_readline","line":315,"kind":12},{"name":"$self","containerName":"next_result","line":318,"kind":13},{"line":318,"kind":12,"containerName":"next_result","name":"_pushback"},{"localvar":"my","definition":"my","name":"$n","containerName":"next_result","line":325,"kind":13},{"kind":13,"line":325,"containerName":"next_result","name":"$domainnum"},{"name":"$domainct","containerName":"next_result","line":325,"kind":13},{"line":325,"kind":13,"name":"@vals","containerName":"next_result"},{"line":340,"kind":13,"localvar":"my","name":"$info","definition":"my","containerName":"next_result"},{"name":"$hitinfo","containerName":"next_result","kind":13,"line":340},{"kind":13,"line":340,"name":"$hitinfo","containerName":"next_result"},{"line":340,"kind":13,"containerName":"next_result","name":"$n"},{"containerName":"next_result","name":"$info","kind":13,"line":341},{"kind":13,"line":342,"containerName":"next_result","name":"$self"},{"containerName":"next_result","name":"warn","kind":12,"line":342},{"kind":13,"line":347,"name":"@hspinfo","containerName":"next_result"},{"line":347,"kind":13,"containerName":"next_result","name":"$n"},{"line":347,"kind":13,"name":"@vals","containerName":"next_result"},{"localvar":"my","name":"$prelength","definition":"my","containerName":"next_result","line":352,"kind":13},{"kind":13,"line":352,"name":"$lastdomain","containerName":"next_result"},{"line":352,"kind":13,"containerName":"next_result","name":"$count"},{"line":352,"kind":13,"name":"$width","containerName":"next_result"},{"name":"$count","containerName":"next_result","line":353,"kind":13},{"localvar":"my","definition":"my","name":"%domaincounter","containerName":"next_result","line":354,"kind":13},{"localvar":"my","containerName":"next_result","definition":"my","name":"$second_tier","line":355,"kind":13},{"containerName":"next_result","name":"$self","line":356,"kind":13},{"name":"_readline","containerName":"next_result","line":356,"kind":12},{"name":"$self","containerName":"next_result","kind":13,"line":360},{"name":"in_element","containerName":"next_result","line":360,"kind":12},{"line":361,"kind":13,"containerName":"next_result","name":"$self"},{"name":"end_element","containerName":"next_result","line":361,"kind":12},{"containerName":"next_result","name":"$self","kind":13,"line":363},{"containerName":"next_result","name":"within_element","kind":12,"line":363},{"name":"$self","containerName":"next_result","kind":13,"line":364},{"line":364,"kind":12,"containerName":"next_result","name":"end_element"},{"kind":13,"line":375,"containerName":"next_result","name":"$name","definition":"my","localvar":"my"},{"line":375,"kind":13,"containerName":"next_result","name":"$domainct"},{"line":375,"kind":13,"containerName":"next_result","name":"$domaintotal"},{"line":375,"kind":13,"name":"$from","containerName":"next_result"},{"name":"$to","containerName":"next_result","kind":13,"line":375},{"kind":13,"line":377,"containerName":"next_result","name":"$domaincounter"},{"line":377,"kind":13,"containerName":"next_result","name":"$name"},{"line":378,"kind":13,"containerName":"next_result","name":"$self"},{"name":"within_element","containerName":"next_result","line":378,"kind":12},{"line":379,"kind":13,"containerName":"next_result","name":"$self"},{"line":379,"kind":12,"containerName":"next_result","name":"within_element"},{"containerName":"next_result","name":"$self","line":380,"kind":13},{"line":380,"kind":12,"name":"end_element","containerName":"next_result"},{"line":382,"kind":13,"containerName":"next_result","name":"$self"},{"containerName":"next_result","name":"end_element","line":382,"kind":12},{"name":"$self","containerName":"next_result","kind":13,"line":385},{"containerName":"next_result","name":"start_element","line":385,"kind":12},{"kind":13,"line":386,"containerName":"next_result","definition":"my","name":"$info","localvar":"my"},{"containerName":"next_result","name":"$hitinfo","line":388,"kind":13},{"name":"$hitinfo","containerName":"next_result","kind":13,"line":388},{"kind":13,"line":388,"containerName":"next_result","name":"$name"},{"containerName":"next_result","name":"$self","line":388,"kind":13},{"line":388,"kind":12,"containerName":"next_result","name":"throw"},{"name":"$info","containerName":"next_result","kind":13,"line":393},{"name":"$name","containerName":"next_result","line":393,"kind":13},{"containerName":"next_result","name":"$self","line":394,"kind":13},{"line":394,"kind":12,"containerName":"next_result","name":"throw"},{"line":396,"kind":13,"containerName":"next_result","name":"$info"},{"name":"$self","containerName":"next_result","kind":13,"line":399},{"name":"element","containerName":"next_result","kind":12,"line":399},{"name":"$info","containerName":"next_result","kind":13,"line":402},{"name":"$self","containerName":"next_result","line":405,"kind":13},{"name":"element","containerName":"next_result","kind":12,"line":405},{"containerName":"next_result","name":"$info","kind":13,"line":408},{"line":411,"kind":13,"name":"$self","containerName":"next_result"},{"containerName":"next_result","name":"element","kind":12,"line":411},{"line":414,"kind":13,"containerName":"next_result","name":"$info"},{"name":"$self","containerName":"next_result","kind":13,"line":417},{"containerName":"next_result","name":"element","line":417,"kind":12},{"containerName":"next_result","name":"$info","line":420,"kind":13},{"line":424,"kind":13,"name":"$self","containerName":"next_result"},{"kind":12,"line":424,"name":"start_element","containerName":"next_result"},{"name":"$self","containerName":"next_result","kind":13,"line":425},{"containerName":"next_result","name":"element","kind":12,"line":425},{"kind":13,"line":431,"containerName":"next_result","name":"$self"},{"containerName":"next_result","name":"element","line":431,"kind":12},{"kind":13,"line":437,"name":"$HSPinfo","definition":"my","containerName":"next_result","localvar":"my"},{"kind":13,"line":437,"containerName":"next_result","name":"@hspinfo"},{"localvar":"my","definition":"my","name":"$id","containerName":"next_result","line":438,"kind":13},{"kind":13,"line":438,"name":"$HSPinfo","containerName":"next_result"},{"kind":13,"line":440,"containerName":"next_result","name":"$id"},{"containerName":"next_result","name":"$name","line":440,"kind":13},{"name":"$self","containerName":"next_result","kind":13,"line":441},{"containerName":"next_result","name":"throw","kind":12,"line":441},{"line":445,"kind":13,"name":"$domaincounter","containerName":"next_result"},{"name":"$name","containerName":"next_result","kind":13,"line":445},{"containerName":"next_result","name":"$domaintotal","kind":13,"line":445},{"name":"$hitinfo","containerName":"next_result","kind":13,"line":446},{"kind":13,"line":446,"containerName":"next_result","name":"$hitinfo"},{"kind":13,"line":446,"name":"$name","containerName":"next_result"},{"line":448,"kind":13,"containerName":"next_result","name":"$self"},{"line":448,"kind":12,"name":"element","containerName":"next_result"},{"kind":13,"line":452,"containerName":"next_result","name":"$HSPinfo"},{"containerName":"next_result","name":"$self","line":454,"kind":13},{"kind":12,"line":454,"name":"element","containerName":"next_result"},{"line":458,"kind":13,"containerName":"next_result","name":"$HSPinfo"},{"kind":13,"line":460,"containerName":"next_result","name":"$self"},{"kind":12,"line":460,"containerName":"next_result","name":"element"},{"line":464,"kind":13,"name":"$HSPinfo","containerName":"next_result"},{"containerName":"next_result","name":"$self","line":466,"kind":13},{"kind":12,"line":466,"containerName":"next_result","name":"element"},{"kind":13,"line":470,"containerName":"next_result","name":"$HSPinfo"},{"name":"$self","containerName":"next_result","kind":13,"line":472},{"name":"element","containerName":"next_result","kind":12,"line":472},{"containerName":"next_result","name":"$HSPinfo","kind":13,"line":476},{"kind":13,"line":478,"name":"$self","containerName":"next_result"},{"containerName":"next_result","name":"element","kind":12,"line":478},{"kind":13,"line":482,"containerName":"next_result","name":"$HSPinfo"},{"name":"$lastdomain","containerName":"next_result","line":484,"kind":13},{"kind":13,"line":484,"containerName":"next_result","name":"$name"}],"line":192},{"kind":12,"line":309,"name":"hitinfo"},{"kind":13,"line":493,"name":"$prelength","containerName":null},{"kind":12,"line":493,"name":"CORE","containerName":"length"},{"name":"$width","containerName":null,"line":494,"kind":13},{"localvar":"my","name":"$data","definition":"my","containerName":null,"line":497,"kind":13},{"line":498,"kind":13,"containerName":null,"name":"%data"},{"kind":13,"line":500,"containerName":null,"name":"$width"},{"name":"CORE","containerName":"length","kind":12,"line":500},{"kind":13,"line":500,"containerName":null,"name":"$data"},{"containerName":null,"name":"$self","kind":13,"line":503},{"kind":12,"line":503,"containerName":"main::","name":"element"},{"containerName":null,"name":"$data","line":507,"kind":13},{"line":509,"kind":13,"containerName":null,"name":"$count"},{"line":510,"kind":13,"name":"%second_tier","containerName":null},{"name":"$self","containerName":null,"kind":13,"line":513},{"name":"element","containerName":"main::","kind":12,"line":513},{"line":519,"kind":13,"containerName":null,"name":"$width"},{"containerName":"length","name":"CORE","line":519,"kind":12},{"containerName":null,"name":"$count","line":520,"kind":13},{"line":522,"kind":13,"containerName":null,"name":"$count"},{"containerName":"length","name":"CORE","line":523,"kind":12},{"name":"%count","containerName":null,"kind":13,"line":528},{"line":529,"kind":13,"name":"$prelength","containerName":null},{"name":"$second_tier","containerName":null,"kind":13,"line":529},{"kind":13,"line":530,"containerName":null,"name":"%prelength"},{"containerName":null,"name":"$self","line":535,"kind":13},{"line":535,"kind":12,"name":"element","containerName":"main::"},{"containerName":null,"name":"$prelength","kind":13,"line":538},{"name":"%count","containerName":null,"line":542,"kind":13},{"name":"%prelength","containerName":null,"kind":13,"line":543},{"containerName":null,"name":"$self","kind":13,"line":544},{"name":"warn","containerName":"main::","line":544,"kind":12},{"kind":13,"line":546,"containerName":null,"name":"%width"},{"kind":13,"line":547,"name":"$self","containerName":null},{"kind":12,"line":547,"containerName":"main::","name":"element"},{"name":"$prelength","containerName":null,"line":551,"kind":13},{"containerName":null,"name":"%width","line":551,"kind":13},{"name":"$self","containerName":null,"kind":13,"line":556},{"containerName":"main::","name":"element","kind":12,"line":556},{"line":559,"kind":13,"containerName":null,"name":"$prelength"},{"kind":13,"line":564,"name":"%count","containerName":null},{"name":"$self","containerName":null,"kind":13,"line":566},{"line":566,"kind":12,"containerName":"main::","name":"element"},{"kind":13,"line":574,"name":"$self","containerName":null},{"name":"warn","containerName":"main::","kind":12,"line":574},{"line":577,"kind":13,"name":"$count","containerName":null},{"name":"%count","containerName":null,"line":577,"kind":13},{"kind":13,"line":582,"containerName":null,"name":"$HSPinfo","definition":"my","localvar":"my"},{"containerName":null,"name":"@hspinfo","kind":13,"line":582},{"localvar":"my","name":"$id","definition":"my","containerName":null,"line":583,"kind":13},{"containerName":null,"name":"$HSPinfo","kind":13,"line":583},{"localvar":"my","containerName":null,"name":"@info","definition":"my","line":584,"kind":13},{"kind":13,"line":584,"containerName":null,"name":"@hitinfo"},{"kind":13,"line":584,"containerName":null,"name":"%hitinfo"},{"name":"$id","containerName":null,"line":584,"kind":13},{"containerName":null,"name":"$info","kind":13,"line":585},{"containerName":null,"name":"$self","line":586,"kind":13},{"kind":12,"line":586,"name":"start_element","containerName":"main::"},{"name":"$self","containerName":null,"line":587,"kind":13},{"line":587,"kind":12,"containerName":"main::","name":"element"},{"kind":13,"line":590,"name":"$info","containerName":null},{"line":593,"kind":13,"name":"$self","containerName":null},{"name":"element","containerName":"main::","line":593,"kind":12},{"containerName":null,"name":"$info","kind":13,"line":596},{"line":599,"kind":13,"containerName":null,"name":"$self"},{"line":599,"kind":12,"containerName":"main::","name":"element"},{"line":602,"kind":13,"name":"$info","containerName":null},{"name":"$self","containerName":null,"line":605,"kind":13},{"name":"element","containerName":"main::","kind":12,"line":605},{"name":"$info","containerName":null,"kind":13,"line":608},{"line":611,"kind":13,"containerName":null,"name":"$self"},{"line":611,"kind":12,"containerName":"main::","name":"start_element"},{"containerName":null,"name":"$self","kind":13,"line":612},{"line":612,"kind":12,"name":"element","containerName":"main::"},{"kind":13,"line":616,"containerName":null,"name":"$HSPinfo"},{"line":618,"kind":13,"containerName":null,"name":"$self"},{"name":"element","containerName":"main::","line":618,"kind":12},{"kind":13,"line":622,"name":"$HSPinfo","containerName":null},{"line":624,"kind":13,"containerName":null,"name":"$self"},{"containerName":"main::","name":"element","line":624,"kind":12},{"name":"$HSPinfo","containerName":null,"line":628,"kind":13},{"name":"$self","containerName":null,"kind":13,"line":630},{"line":630,"kind":12,"containerName":"main::","name":"element"},{"name":"$HSPinfo","containerName":null,"line":634,"kind":13},{"name":"$self","containerName":null,"kind":13,"line":636},{"containerName":"main::","name":"element","kind":12,"line":636},{"containerName":null,"name":"$HSPinfo","kind":13,"line":640},{"containerName":null,"name":"$self","line":642,"kind":13},{"line":642,"kind":12,"containerName":"main::","name":"element"},{"line":646,"kind":13,"containerName":null,"name":"$HSPinfo"},{"kind":13,"line":648,"containerName":null,"name":"$self"},{"kind":12,"line":648,"name":"element","containerName":"main::"},{"kind":13,"line":654,"name":"$self","containerName":null},{"kind":12,"line":654,"name":"element","containerName":"main::"},{"line":660,"kind":13,"containerName":null,"name":"$self"},{"line":660,"kind":12,"containerName":"main::","name":"element"},{"line":666,"kind":13,"name":"$self","containerName":null},{"kind":12,"line":666,"containerName":"main::","name":"end_element"},{"kind":13,"line":667,"name":"$self","containerName":null},{"line":667,"kind":12,"name":"end_element","containerName":"main::"},{"line":669,"kind":13,"containerName":null,"name":"@hitinfo"},{"containerName":null,"name":"%hitinfo","kind":13,"line":670},{"line":674,"kind":13,"containerName":null,"name":"%self"},{"name":"%self","containerName":null,"line":675,"kind":13},{"containerName":null,"name":"$self","kind":13,"line":679},{"name":"_readline","containerName":"main::","kind":12,"line":679},{"line":683,"kind":13,"localvar":"my","definition":"my","name":"@line","containerName":null},{"containerName":null,"name":"$model","definition":"my","localvar":"my","kind":13,"line":684},{"containerName":null,"name":"$n","line":684,"kind":13},{"line":684,"kind":13,"name":"$evalue","containerName":null},{"kind":13,"line":684,"name":"$score","containerName":null},{"line":685,"kind":13,"containerName":null,"name":"@line"},{"kind":13,"line":685,"containerName":null,"name":"@line"},{"name":"@line","containerName":null,"kind":13,"line":685},{"name":"@line","containerName":null,"kind":13,"line":685},{"containerName":null,"name":"$desc","definition":"my","localvar":"my","kind":13,"line":686},{"kind":13,"line":686,"name":"@line","containerName":null},{"containerName":null,"name":"@hitinfo","line":687,"kind":13},{"kind":13,"line":687,"containerName":null,"name":"$model"},{"kind":13,"line":687,"containerName":null,"name":"$desc"},{"name":"$score","containerName":null,"kind":13,"line":687},{"containerName":null,"name":"$evalue","line":687,"kind":13},{"containerName":null,"name":"$n","kind":13,"line":687},{"containerName":null,"name":"%hitinfo","line":688,"kind":13},{"containerName":null,"name":"$model","line":688,"kind":13},{"name":"hitinfo","kind":12,"line":688},{"kind":13,"line":692,"name":"@hspinfo","containerName":null},{"line":693,"kind":13,"containerName":null,"name":"$self"},{"line":693,"kind":12,"name":"_readline","containerName":"main::"},{"kind":13,"line":696,"name":"$self","containerName":null},{"name":"_pushback","containerName":"main::","kind":12,"line":696},{"localvar":"my","name":"$n","definition":"my","containerName":null,"line":702,"kind":13},{"name":"$domainnum","containerName":null,"line":702,"kind":13},{"kind":13,"line":702,"name":"$domainct","containerName":null},{"name":"@vals","containerName":null,"line":702,"kind":13},{"line":714,"kind":13,"localvar":"my","definition":"my","name":"$hindex","containerName":null},{"name":"%hitinfo","containerName":null,"kind":13,"line":714},{"containerName":null,"name":"$n","kind":13,"line":714},{"name":"%hindex","containerName":null,"line":715,"kind":13},{"line":716,"kind":13,"name":"@hitinfo","containerName":null},{"line":717,"kind":13,"containerName":null,"name":"$n"},{"name":"@vals","containerName":null,"line":717,"kind":13},{"name":"@vals","containerName":null,"kind":13,"line":717},{"name":"$domainct","containerName":null,"kind":13,"line":717},{"line":718,"kind":13,"containerName":null,"name":"%hitinfo"},{"kind":13,"line":718,"name":"$n","containerName":null},{"name":"hitinfo","line":718,"kind":12},{"name":"$hindex","containerName":null,"line":719,"kind":13},{"name":"hitinfo","kind":12,"line":719},{"kind":13,"line":721,"definition":"my","name":"$info","containerName":null,"localvar":"my"},{"name":"@hitinfo","containerName":null,"kind":13,"line":721},{"kind":13,"line":721,"name":"$hindex","containerName":null},{"containerName":null,"name":"%info","kind":13,"line":722},{"line":723,"kind":13,"containerName":null,"name":"$self"},{"containerName":"main::","name":"warn","kind":12,"line":723},{"containerName":null,"name":"@hspinfo","kind":13,"line":728},{"kind":13,"line":728,"name":"$n","containerName":null},{"line":728,"kind":13,"name":"@vals","containerName":null},{"line":733,"kind":13,"localvar":"my","definition":"my","name":"$prelength","containerName":null},{"line":733,"kind":13,"name":"$lastdomain","containerName":null},{"kind":13,"line":733,"name":"$count","containerName":null},{"kind":13,"line":733,"containerName":null,"name":"$width"},{"name":"$count","containerName":null,"line":734,"kind":13},{"kind":13,"line":735,"containerName":null,"definition":"my","name":"$second_tier","localvar":"my"},{"containerName":null,"name":"$self","kind":13,"line":736},{"kind":12,"line":736,"name":"_readline","containerName":"main::"},{"containerName":null,"name":"$count","kind":13,"line":740},{"name":"%count","containerName":null,"kind":13,"line":744},{"kind":13,"line":746,"name":"$self","containerName":null},{"kind":12,"line":746,"containerName":"main::","name":"in_element"},{"kind":13,"line":747,"containerName":null,"name":"$self"},{"kind":12,"line":747,"containerName":"main::","name":"end_element"},{"containerName":null,"name":"$self","kind":13,"line":749},{"containerName":"main::","name":"in_element","line":749,"kind":12},{"name":"$self","containerName":null,"kind":13,"line":750},{"containerName":"main::","name":"end_element","line":750,"kind":12},{"name":"$self","containerName":null,"kind":13,"line":752},{"containerName":"main::","name":"_pushback","line":752,"kind":12},{"localvar":"my","definition":"my","name":"$name","containerName":null,"line":757,"kind":13},{"containerName":null,"name":"$from","kind":13,"line":757},{"name":"$to","containerName":null,"line":757,"kind":13},{"kind":13,"line":759,"name":"$self","containerName":null},{"kind":12,"line":759,"name":"within_element","containerName":"main::"},{"containerName":null,"name":"$self","kind":13,"line":760},{"name":"in_element","containerName":"main::","kind":12,"line":760},{"containerName":null,"name":"$self","line":761,"kind":13},{"line":761,"kind":12,"containerName":"main::","name":"end_element"},{"containerName":null,"name":"$self","line":763,"kind":13},{"line":763,"kind":12,"name":"end_element","containerName":"main::"},{"line":765,"kind":13,"localvar":"my","definition":"my","name":"@info","containerName":null},{"line":765,"kind":13,"name":"@hitinfo","containerName":null},{"containerName":null,"name":"%hitinfo","kind":13,"line":765},{"containerName":null,"name":"$name","line":765,"kind":13},{"containerName":null,"name":"$info","kind":13,"line":767},{"name":"@info","containerName":null,"kind":13,"line":767},{"containerName":null,"name":"%name","line":767,"kind":13},{"line":769,"kind":13,"containerName":null,"name":"$self"},{"name":"warn","containerName":"main::","line":769,"kind":12},{"containerName":null,"name":"@info","line":771,"kind":13},{"containerName":null,"name":"@info","kind":13,"line":774},{"containerName":null,"name":"$name","line":775,"kind":13},{"kind":13,"line":778,"containerName":null,"name":"@hitinfo"},{"line":778,"kind":13,"name":"$info","containerName":null},{"line":779,"kind":13,"containerName":null,"name":"%hitinfo"},{"kind":13,"line":779,"name":"$name","containerName":null},{"name":"hitinfo","kind":12,"line":779},{"name":"$self","containerName":null,"line":781,"kind":13},{"kind":12,"line":781,"name":"start_element","containerName":"main::"},{"name":"$self","containerName":null,"line":783,"kind":13},{"line":783,"kind":12,"containerName":"main::","name":"element"},{"kind":13,"line":786,"containerName":null,"name":"$info"},{"line":789,"kind":13,"containerName":null,"name":"$self"},{"name":"element","containerName":"main::","kind":12,"line":789},{"containerName":null,"name":"$info","line":792,"kind":13},{"kind":13,"line":795,"name":"$self","containerName":null},{"line":795,"kind":12,"name":"element","containerName":"main::"},{"kind":13,"line":798,"name":"$info","containerName":null},{"containerName":null,"name":"$self","line":801,"kind":13},{"kind":12,"line":801,"name":"element","containerName":"main::"},{"name":"$info","containerName":null,"line":804,"kind":13},{"kind":13,"line":808,"containerName":null,"name":"$self"},{"name":"start_element","containerName":"main::","line":808,"kind":12},{"kind":13,"line":809,"name":"$self","containerName":null},{"line":809,"kind":12,"name":"element","containerName":"main::"},{"kind":13,"line":815,"containerName":null,"name":"$self"},{"line":815,"kind":12,"name":"element","containerName":"main::"},{"localvar":"my","containerName":null,"definition":"my","name":"$HSPinfo","line":821,"kind":13},{"name":"@hspinfo","containerName":null,"kind":13,"line":821},{"line":822,"kind":13,"localvar":"my","containerName":null,"definition":"my","name":"$id"},{"line":822,"kind":13,"name":"$HSPinfo","containerName":null},{"kind":13,"line":824,"name":"$id","containerName":null},{"kind":13,"line":824,"containerName":null,"name":"%name"},{"kind":13,"line":825,"name":"$self","containerName":null},{"line":825,"kind":12,"containerName":"main::","name":"throw"},{"containerName":null,"name":"$self","kind":13,"line":829},{"kind":12,"line":829,"name":"element","containerName":"main::"},{"line":833,"kind":13,"name":"$HSPinfo","containerName":null},{"containerName":null,"name":"$self","kind":13,"line":835},{"line":835,"kind":12,"name":"element","containerName":"main::"},{"name":"$HSPinfo","containerName":null,"kind":13,"line":839},{"containerName":null,"name":"$self","line":841,"kind":13},{"name":"element","containerName":"main::","line":841,"kind":12},{"containerName":null,"name":"$HSPinfo","kind":13,"line":845},{"kind":13,"line":847,"containerName":null,"name":"$self"},{"containerName":"main::","name":"element","line":847,"kind":12},{"name":"$HSPinfo","containerName":null,"kind":13,"line":851},{"name":"$self","containerName":null,"line":853,"kind":13},{"containerName":"main::","name":"element","line":853,"kind":12},{"line":857,"kind":13,"containerName":null,"name":"$HSPinfo"},{"name":"$self","containerName":null,"kind":13,"line":859},{"line":859,"kind":12,"containerName":"main::","name":"element"},{"line":863,"kind":13,"name":"$HSPinfo","containerName":null},{"containerName":null,"name":"$lastdomain","line":865,"kind":13},{"containerName":null,"name":"%name","kind":13,"line":865},{"name":"$prelength","containerName":null,"line":871,"kind":13},{"line":871,"kind":12,"name":"CORE","containerName":"length"},{"containerName":null,"name":"$width","kind":13,"line":872},{"localvar":"my","containerName":null,"definition":"my","name":"$data","line":875,"kind":13},{"line":876,"kind":13,"containerName":null,"name":"%data"},{"name":"$width","containerName":null,"line":878,"kind":13},{"containerName":"length","name":"CORE","line":878,"kind":12},{"name":"$data","containerName":null,"kind":13,"line":878},{"line":881,"kind":13,"name":"$self","containerName":null},{"name":"element","containerName":"main::","line":881,"kind":12},{"containerName":null,"name":"$data","line":885,"kind":13},{"kind":13,"line":887,"containerName":null,"name":"$count"},{"line":888,"kind":13,"name":"%second_tier","containerName":null},{"kind":13,"line":894,"containerName":null,"name":"$prelength"},{"line":894,"kind":13,"containerName":null,"name":"$second_tier"},{"containerName":null,"name":"$self","kind":13,"line":895},{"kind":12,"line":895,"name":"element","containerName":"main::"},{"line":901,"kind":13,"name":"$width","containerName":null},{"name":"CORE","containerName":"length","line":901,"kind":12},{"containerName":null,"name":"$count","line":902,"kind":13},{"name":"CORE","containerName":"length","line":904,"kind":12},{"containerName":null,"name":"%count","kind":13,"line":905},{"kind":13,"line":910,"containerName":null,"name":"%count"},{"containerName":null,"name":"$prelength","kind":13,"line":911},{"containerName":null,"name":"$second_tier","kind":13,"line":911},{"name":"%prelength","containerName":null,"line":912,"kind":13},{"containerName":null,"name":"$self","line":917,"kind":13},{"kind":12,"line":917,"containerName":"main::","name":"element"},{"line":920,"kind":13,"name":"$prelength","containerName":null},{"containerName":null,"name":"%count","kind":13,"line":924},{"kind":13,"line":925,"name":"%prelength","containerName":null},{"line":926,"kind":13,"name":"$self","containerName":null},{"name":"warn","containerName":"main::","line":926,"kind":12},{"kind":13,"line":928,"name":"%width","containerName":null},{"name":"$self","containerName":null,"kind":13,"line":929},{"kind":12,"line":929,"containerName":"main::","name":"element"},{"name":"$prelength","containerName":null,"line":933,"kind":13},{"name":"%width","containerName":null,"line":933,"kind":13},{"name":"$self","containerName":null,"line":938,"kind":13},{"name":"element","containerName":"main::","kind":12,"line":938},{"containerName":null,"name":"$prelength","kind":13,"line":941},{"line":946,"kind":13,"name":"%count","containerName":null},{"containerName":null,"name":"$self","line":950,"kind":13},{"line":950,"kind":12,"containerName":"main::","name":"element"},{"line":958,"kind":13,"containerName":null,"name":"$self"},{"containerName":"main::","name":"throw","line":958,"kind":12},{"line":962,"kind":13,"containerName":null,"name":"$count"},{"kind":13,"line":962,"name":"%count","containerName":null},{"line":968,"kind":13,"localvar":"my","name":"$HSPinfo","definition":"my","containerName":null},{"name":"@hspinfo","containerName":null,"kind":13,"line":968},{"containerName":null,"definition":"my","name":"$id","localvar":"my","kind":13,"line":969},{"kind":13,"line":969,"containerName":null,"name":"$HSPinfo"},{"line":970,"kind":13,"localvar":"my","containerName":null,"name":"@info","definition":"my"},{"name":"@hitinfo","containerName":null,"line":970,"kind":13},{"containerName":null,"name":"%hitinfo","kind":13,"line":970},{"name":"$id","containerName":null,"line":970,"kind":13},{"kind":13,"line":971,"name":"$info","containerName":null},{"containerName":null,"name":"$self","kind":13,"line":972},{"containerName":"main::","name":"start_element","kind":12,"line":972},{"kind":13,"line":973,"name":"$self","containerName":null},{"name":"element","containerName":"main::","kind":12,"line":973},{"containerName":null,"name":"$info","kind":13,"line":976},{"kind":13,"line":979,"containerName":null,"name":"$self"},{"line":979,"kind":12,"containerName":"main::","name":"element"},{"containerName":null,"name":"$info","line":982,"kind":13},{"kind":13,"line":985,"name":"$self","containerName":null},{"containerName":"main::","name":"element","kind":12,"line":985},{"containerName":null,"name":"$info","line":988,"kind":13},{"line":991,"kind":13,"name":"$self","containerName":null},{"name":"element","containerName":"main::","line":991,"kind":12},{"containerName":null,"name":"$info","line":994,"kind":13},{"name":"$self","containerName":null,"kind":13,"line":997},{"line":997,"kind":12,"name":"start_element","containerName":"main::"},{"kind":13,"line":998,"containerName":null,"name":"$self"},{"kind":12,"line":998,"containerName":"main::","name":"element"},{"line":1002,"kind":13,"containerName":null,"name":"$HSPinfo"},{"name":"$self","containerName":null,"line":1004,"kind":13},{"containerName":"main::","name":"element","line":1004,"kind":12},{"kind":13,"line":1008,"name":"$HSPinfo","containerName":null},{"line":1010,"kind":13,"name":"$self","containerName":null},{"kind":12,"line":1010,"name":"element","containerName":"main::"},{"name":"$HSPinfo","containerName":null,"kind":13,"line":1014},{"line":1016,"kind":13,"name":"$self","containerName":null},{"name":"element","containerName":"main::","line":1016,"kind":12},{"containerName":null,"name":"$HSPinfo","line":1020,"kind":13},{"name":"$self","containerName":null,"kind":13,"line":1022},{"kind":12,"line":1022,"name":"element","containerName":"main::"},{"name":"$HSPinfo","containerName":null,"kind":13,"line":1026},{"kind":13,"line":1028,"name":"$self","containerName":null},{"kind":12,"line":1028,"name":"element","containerName":"main::"},{"kind":13,"line":1032,"containerName":null,"name":"$HSPinfo"},{"kind":13,"line":1034,"name":"$self","containerName":null},{"line":1034,"kind":12,"name":"element","containerName":"main::"},{"kind":13,"line":1040,"containerName":null,"name":"$self"},{"containerName":"main::","name":"element","line":1040,"kind":12},{"name":"$self","containerName":null,"line":1046,"kind":13},{"containerName":"main::","name":"element","line":1046,"kind":12},{"kind":13,"line":1052,"name":"$self","containerName":null},{"containerName":"main::","name":"end_element","kind":12,"line":1052},{"containerName":null,"name":"$self","kind":13,"line":1053},{"line":1053,"kind":12,"name":"end_element","containerName":"main::"},{"kind":13,"line":1055,"containerName":null,"name":"@hitinfo"},{"name":"%hitinfo","containerName":null,"line":1056,"kind":13},{"containerName":null,"name":"$last","line":1064,"kind":13},{"kind":13,"line":1066,"containerName":null,"name":"$self"},{"containerName":"main::","name":"end_element","kind":12,"line":1066},{"containerName":null,"name":"$seentop","line":1066,"kind":13},{"name":"$self","containerName":null,"line":1067,"kind":13},{"line":1067,"kind":12,"name":"end_document","containerName":"main::"},{"line":1081,"children":[{"line":1082,"kind":13,"localvar":"my","containerName":"start_element","name":"$self","definition":"my"},{"containerName":"start_element","name":"$data","line":1082,"kind":13},{"line":1085,"kind":13,"localvar":"my","containerName":"start_element","name":"$nm","definition":"my"},{"kind":13,"line":1085,"name":"$data","containerName":"start_element"},{"kind":13,"line":1086,"definition":"my","name":"$type","containerName":"start_element","localvar":"my"},{"line":1086,"kind":13,"containerName":"start_element","name":"$MODEMAP"},{"kind":13,"line":1086,"name":"$nm","containerName":"start_element"},{"kind":13,"line":1087,"containerName":"start_element","name":"$type"},{"containerName":"start_element","name":"$self","kind":13,"line":1088},{"kind":12,"line":1088,"containerName":"start_element","name":"_eventHandler"},{"line":1088,"kind":12,"name":"will_handle","containerName":"start_element"},{"name":"$type","containerName":"start_element","kind":13,"line":1088},{"containerName":"start_element","name":"$func","definition":"my","localvar":"my","kind":13,"line":1089},{"containerName":"start_element","name":"$type","kind":13,"line":1089},{"kind":13,"line":1090,"name":"$self","containerName":"start_element"},{"containerName":"start_element","name":"_eventHandler","line":1090,"kind":12},{"kind":13,"line":1090,"name":"$func","containerName":"start_element"},{"containerName":"start_element","name":"$data","line":1090,"kind":13},{"line":1092,"kind":13,"containerName":"start_element","name":"$self"},{"kind":13,"line":1092,"name":"$type","containerName":"start_element"}],"kind":12,"detail":"($self,$data)","signature":{"label":"start_element($self,$data)","documentation":"1;\n# $Id: hmmer.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::hmmer\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::hmmer - A parser for HMMER output (hmmpfam, hmmsearch)\n\n=head1 SYNOPSIS\n\n    # do not use this class directly it is available through Bio::SearchIO\n    use Bio::SearchIO;\n    my $in = Bio::SearchIO->new(-format => 'hmmer',\n                               -file   => 't/data/L77119.hmmer');\n    while( my $result = $in->next_result ) {\n        # this is a Bio::Search::Result::HMMERResult object\n        print $result->query_name(), \" for HMM \", $result->hmm_name(), \"\\n\";\n        while( my $hit = $result->next_hit ) {\n            print $hit->name(), \"\\n\";\n            while( my $hsp = $hit->next_hsp ) {\n                print \"length is \", $hsp->length(), \"\\n\";\n            }\n        }\n    }\n\n=head1 DESCRIPTION\n\nThis object implements a parser for HMMER output.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::hmmer;\n\nuse strict;\n\nuse Bio::Factory::ObjectFactory;\n\nuse vars qw(%MAPPING %MODEMAP\n);\n\nuse base qw(Bio::SearchIO);\n\nBEGIN {\n\n    # mapping of HMMER items to Bioperl hash keys\n    %MODEMAP = (\n        'HMMER_Output' => 'result',\n        'Hit'          => 'hit',\n        'Hsp'          => 'hsp'\n    );\n\n    %MAPPING = (\n        'Hsp_bit-score'   => 'HSP-bits',\n        'Hsp_score'       => 'HSP-score',\n        'Hsp_evalue'      => 'HSP-evalue',\n        'Hsp_query-from'  => 'HSP-query_start',\n        'Hsp_query-to'    => 'HSP-query_end',\n        'Hsp_hit-from'    => 'HSP-hit_start',\n        'Hsp_hit-to'      => 'HSP-hit_end',\n        'Hsp_positive'    => 'HSP-conserved',\n        'Hsp_identity'    => 'HSP-identical',\n        'Hsp_gaps'        => 'HSP-hsp_gaps',\n        'Hsp_hitgaps'     => 'HSP-hit_gaps',\n        'Hsp_querygaps'   => 'HSP-query_gaps',\n        'Hsp_qseq'        => 'HSP-query_seq',\n        'Hsp_hseq'        => 'HSP-hit_seq',\n        'Hsp_midline'     => 'HSP-homology_seq',\n        'Hsp_align-len'   => 'HSP-hsp_length',\n        'Hsp_query-frame' => 'HSP-query_frame',\n        'Hsp_hit-frame'   => 'HSP-hit_frame',\n\n        'Hit_id'        => 'HIT-name',\n        'Hit_len'       => 'HIT-length',\n        'Hit_accession' => 'HIT-accession',\n        'Hit_desc'      => 'HIT-description',\n        'Hit_signif'    => 'HIT-significance',\n        'Hit_score'     => 'HIT-score',\n\n        'HMMER_program'   => 'RESULT-algorithm_name',\n        'HMMER_version'   => 'RESULT-algorithm_version',\n        'HMMER_query-def' => 'RESULT-query_name',\n        'HMMER_query-len' => 'RESULT-query_length',\n        'HMMER_query-acc' => 'RESULT-query_accession',\n        'HMMER_querydesc' => 'RESULT-query_description',\n        'HMMER_hmm'       => 'RESULT-hmm_name',\n        'HMMER_seqfile'   => 'RESULT-sequence_file',\n        'HMMER_db'        => 'RESULT-database_name',\n    );\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::hmmer->new();\n Function: Builds a new Bio::SearchIO::hmmer object \n Returns : Bio::SearchIO::hmmer\n Args    : -fh/-file => HMMER filename\n           -format   => 'hmmer'\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n    my $handler = $self->_eventHandler;\n    $handler->register_factory(\n        'result',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Result::HMMERResult',\n            -interface => 'Bio::Search::Result::ResultI'\n        )\n    );\n\n    $handler->register_factory(\n        'hit',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Hit::HMMERHit',\n            -interface => 'Bio::Search::Hit::HitI'\n        )\n    );\n\n    $handler->register_factory(\n        'hsp',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::HSP::HMMERHSP',\n            -interface => 'Bio::Search::HSP::HSPI'\n        )\n    );\n    $self->{'_hmmidline'} = 'HMMER 2.2g (August 2001)';\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    my $seentop = 0;\n    my $reporttype;\n    my ( $last, @hitinfo, @hspinfo, %hspinfo, %hitinfo );\n    local $/ = \"\\n\";\n    local $_;\n\n    my $verbose = $self->verbose;    # cache for speed?\n    $self->start_document();\n    local ($_);\n    while ( defined( $_ = $self->_readline ) ) {\n        my $lineorig = $_;\n        chomp;\n        if (/^HMMER\\s+(\\S+)\\s+\\((.+)\\)/o) {\n            my ( $prog, $version ) = split;\n            if ($seentop) {\n                $self->_pushback($_);\n                $self->end_element( { 'Name' => 'HMMER_Output' } );\n                return $self->end_document();\n            }\n            $self->{'_hmmidline'} = $_;\n            $self->start_element( { 'Name' => 'HMMER_Output' } );\n            $self->{'_result_count'}++;\n            $seentop = 1;\n            if ( defined $last ) {\n                ($reporttype) = split( /\\s+/, $last );\n                $self->element(\n                    {\n                        'Name' => 'HMMER_program',\n                        'Data' => uc($reporttype)\n                    }\n                );\n            }\n            $self->element(\n                {\n                    'Name' => 'HMMER_version',\n                    'Data' => $version\n                }\n            );\n        }\n        elsif (s/^HMM file:\\s+//o) {\n            $self->{'_hmmfileline'} = $lineorig;\n            $self->element(\n                {\n                    'Name' => 'HMMER_hmm',\n                    'Data' => $_\n                }\n            );\n        }\n        elsif (s/^Sequence\\s+(file|database):\\s+//o) {\n            $self->{'_hmmseqline'} = $lineorig;\n            if ( $1 eq 'database' ) {\n                $self->element(\n                    {\n                        'Name' => 'HMMER_db',\n                        'Data' => $_\n                    }\n                );\n            }\n            $self->element(\n                {\n                    'Name' => 'HMMER_seqfile',\n                    'Data' => $_\n                }\n            );\n        }\n        elsif (s/^Query(\\s+(sequence|HMM))?(?:\\s+\\d+)?:\\s+//o) {\n            if ( !$seentop ) {\n\n                # we're in a multi-query report\n                $self->_pushback( $self->{'_hmmidline'} );\n                $self->_pushback( $self->{'_hmmfileline'} );\n                $self->_pushback( $self->{'_hmmseqline'} );\n                $self->_pushback($lineorig);\n                next;\n            }\n            s/\\s+$//;\n            $self->element(\n                {\n                    'Name' => 'HMMER_query-def',\n                    'Data' => $_\n                }\n            );\n        }\n        elsif (s/^Accession:\\s+//o) {\n            s/\\s+$//;\n            $self->element(\n                {\n                    'Name' => 'HMMER_query-acc',\n                    'Data' => $_\n                }\n            );\n        }\n        elsif (s/^Description:\\s+//o) {\n            s/\\s+$//;\n            $self->element(\n                {\n                    'Name' => 'HMMER_querydesc',\n                    'Data' => $_\n                }\n            );\n        }\n        elsif ( defined $self->{'_reporttype'}\n            && $self->{'_reporttype'} eq 'HMMSEARCH' )\n        {\n\n            # PROCESS HMMSEARCH RESULTS HERE\n            if (/^Scores for complete sequences/o) {\n                while ( defined( $_ = $self->_readline ) ) {\n                    last if (/^\\s+$/);\n                    next if ( /^Sequence\\s+Description/o || /^\\-\\-\\-/o );\n                    my @line = split;\n                    my ( $name, $n, $evalue, $score ) =\n                      ( shift @line, pop @line, pop @line, pop @line );\n                    my $desc = join( ' ', @line );\n                    push @hitinfo, [ $name, $desc, $evalue, $score ];\n                    $hitinfo{$name} = $#hitinfo;\n                }\n            }\n            elsif (/^Parsed for domains:/o) {\n                @hspinfo = ();\n\n                while ( defined( $_ = $self->_readline ) ) {\n                    last if (/^\\s+$/);\n                    if (m!^//!) {\n                        $self->_pushback($_);\n                        last;\n                    }\n                    next if ( /^(Model|Sequence)\\s+Domain/ || /^\\-\\-\\-/ );\n\n                    chomp;\n                    if (\n                        my ( $n, $domainnum, $domainct, @vals ) = (\n                            m!^(\\S+)\\s+      # host name\n\t\t\t(\\d+)/(\\d+)\\s+   # num/num (ie 1 of 2) \n\t\t\t(\\d+)\\s+(\\d+).+? # sequence start and end\n\t\t\t(\\d+)\\s+(\\d+)\\s+ # hmm start and end\n\t\t\t\\S+\\s+           # []\n\t\t\t(\\S+)\\s+         # score\n\t\t\t(\\S+)            # evalue\n\t\t\t\\s*$!ox\n                        )\n                      )\n                    {\n\n                        # array lookup so that we can get rid of things\n                        # when they've been processed\n                        my $info = $hitinfo[ $hitinfo{$n} ];\n                        if ( !defined $info ) {\n                            $self->warn(\n\"Incomplete Sequence information, can't find $n hitinfo says $hitinfo{$n}\"\n                            );\n                            next;\n                        }\n                        push @hspinfo, [ $n, @vals ];\n                    }\n                }\n            }\n            elsif (/^Alignments of top/o) {\n                my ( $prelength, $lastdomain, $count, $width );\n                $count = 0;\n                my %domaincounter;\n                my $second_tier = 0;\n                while ( defined( $_ = $self->_readline ) ) {\n                    next if ( /^Align/o\n                        || /^\\s+RF\\s+[x\\s]+$/o );\n                    if ( /^Histogram/o || m!^//!o ) {\n                        if ( $self->in_element('hsp') ) {\n                            $self->end_element( { 'Name' => 'Hsp' } );\n                        }\n                        if ( $self->within_element('hit') ) {\n                            $self->end_element( { 'Name' => 'Hit' } );\n                        }\n                        last;\n                    }\n                    chomp;\n\n                    if (\n                        m/^\\s*(.+):\\s+domain\\s+(\\d+)\\s+of\\s+(\\d+)\\,\\s+\n                        from\\s+(\\d+)\\s+to\\s+(\\d+)/x\n                      )\n                    {\n                        my ( $name, $domainct, $domaintotal, $from, $to ) =\n                          ( $1, $2, $3, $4, $5 );\n                        $domaincounter{$name}++;\n                        if ( $self->within_element('hit') ) {\n                            if ( $self->within_element('hsp') ) {\n                                $self->end_element( { 'Name' => 'Hsp' } );\n                            }\n                            $self->end_element( { 'Name' => 'Hit' } );\n                        }\n\n                        $self->start_element( { 'Name' => 'Hit' } );\n                        my $info = [\n                            @{\n                                $hitinfo[ $hitinfo{$name} ] || $self->throw(\n\"Could not find hit info for $name: Insure that your database contains only unique sequence names\"\n                                )\n                              }\n                        ];\n                        if ( $info->[0] ne $name ) {\n                            $self->throw(\n\"Somehow the Model table order does not match the order in the domains (got \"\n                                  . $info->[0]\n                                  . \", expected $name)\" );\n                        }\n                        $self->element(\n                            {\n                                'Name' => 'Hit_id',\n                                'Data' => shift @{$info}\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hit_desc',\n                                'Data' => shift @{$info}\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hit_signif',\n                                'Data' => shift @{$info}\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hit_score',\n                                'Data' => shift @{$info}\n                            }\n                        );\n\n                        $self->start_element( { 'Name' => 'Hsp' } );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_identity',\n                                'Data' => 0\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_positive',\n                                'Data' => 0\n                            }\n                        );\n                        my $HSPinfo = shift @hspinfo;\n                        my $id      = shift @$HSPinfo;\n\n                        if ( $id ne $name ) {\n                            $self->throw(\n\"Somehow the domain list details do not match the table (got $id, expected $name)\"\n                            );\n                        }\n                        if ( $domaincounter{$name} == $domaintotal ) {\n                            $hitinfo[ $hitinfo{$name} ] = undef;\n                        }\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_hit-from',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_hit-to',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_query-from',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_query-to',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_score',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_evalue',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $lastdomain = $name;\n                    }\n                    else {\n\n                        # Might want to change this so that it\n                        # accumulates all the of the alignment lines into\n                        # three array slots and then tests for the\n                        # end of the line\n                        if (/^(\\s+\\*\\-\\>)(\\S+)/o) {    # start of domain\n                            $prelength = CORE::length($1);\n                            $width     = 0;\n\n                            # deal with fact that start en stop is on same line\n                            my $data = $2;\n                            if ($data =~ s/\\<\\-?\\*?\\s*$//)\n                            {\n                                $width = CORE::length($data);\n                            }\n \n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_qseq',\n                                    'Data' => $data\n                                }\n                            );\n                            $count       = 0;\n                            $second_tier = 0;\n                        }\n                        elsif (/^(\\s+)(\\S+)\\<\\-\\*\\s*$/o) {    #end of domain\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_qseq',\n                                    'Data' => $2\n                                }\n                            );\n                            $width = CORE::length($2);\n                            $count = 0;\n                        }\n                        elsif (( $count != 1 && /^\\s+$/o )\n                            || CORE::length($_) == 0\n                            || /^\\s+\\-?\\*\\s*$/ )\n                        {\n                            next;\n                        }\n                        elsif ( $count == 0 ) {\n                            $prelength -= 3 unless ( $second_tier++ );\n                            unless ( defined $prelength ) {\n\n                                # $self->warn(\"prelength not set\");\n                                next;\n                            }\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_qseq',\n                                    'Data' => substr( $_, $prelength )\n                                }\n                            );\n                        }\n                        elsif ( $count == 1 ) {\n                            if ( !defined $prelength ) {\n                                $self->warn(\"prelength not set\");\n                            }\n                            if ($width) {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_midline',\n                                        'Data' =>\n                                          substr( $_, $prelength, $width )\n                                    }\n                                );\n                            }\n                            else {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_midline',\n                                        'Data' => substr( $_, $prelength )\n                                    }\n                                );\n                            }\n                        }\n                        elsif ( $count == 2 ) {\n                            if (/^\\s+(\\S+)\\s+(\\d+|\\-)\\s+(\\S*)\\s+(\\d+|\\-)/o) {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_hseq',\n                                        'Data' => $3\n                                    }\n                                );\n                            }\n                            else {\n                                $self->warn(\"unrecognized line: $_\\n\");\n                            }\n                        }\n                        $count = 0 if $count++ >= 2;\n                    }\n                }\n            }\n            elsif ( /^Histogram/o || m!^//!o ) {\n                while ( my $HSPinfo = shift @hspinfo ) {\n                    my $id   = shift @$HSPinfo;\n                    my $info = [ @{ $hitinfo[ $hitinfo{$id} ] } ];\n                    next unless defined $info;\n                    $self->start_element( { 'Name' => 'Hit' } );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_id',\n                            'Data' => shift @{$info}\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_desc',\n                            'Data' => shift @{$info}\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_signif',\n                            'Data' => shift @{$info}\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_score',\n                            'Data' => shift @{$info}\n                        }\n                    );\n                    $self->start_element( { 'Name' => 'Hsp' } );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_query-from',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_query-to',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_hit-from',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_hit-to',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_score',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_evalue',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_identity',\n                            'Data' => 0\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_positive',\n                            'Data' => 0\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_positive',\n                            'Data' => 0\n                        }\n                    );\n                    $self->end_element( { 'Name' => 'Hsp' } );\n                    $self->end_element( { 'Name' => 'Hit' } );\n                }\n                @hitinfo = ();\n                %hitinfo = ();\n                last;\n            }\n        }\n        elsif ( defined $self->{'_reporttype'}\n            && $self->{'_reporttype'} eq 'HMMPFAM' )\n        {\n            # process HMMPFAM results here\n            if (/^Scores for sequence family/o) {\n                while ( defined( $_ = $self->_readline ) ) {\n                    last if (/^\\s+$/);\n                    next if ( /^Model\\s+Description/o || /^\\-\\-\\-/o );\n                    chomp;\n                    my @line = split;\n                    my ( $model, $n, $evalue, $score ) =\n                      ( shift @line, pop @line, pop @line, pop @line );\n                    my $desc = join( ' ', @line );\n                    push @hitinfo, [ $model, $desc, $score, $evalue, $n ];\n                    $hitinfo{$model} = $#hitinfo;\n                }\n            }\n            elsif (/^Parsed for domains:/o) {\n                @hspinfo = ();\n                while ( defined( $_ = $self->_readline ) ) {\n                    last if (/^\\s+$/);\n                    if (m!^//!) {\n                        $self->_pushback($_);\n                        last;\n                    }\n                    next if ( /^Model\\s+Domain/o || /^\\-\\-\\-/o );\n                    chomp;\n                    if (\n                        my ( $n, $domainnum, $domainct, @vals ) = (\n                            m!^(\\S+)\\s+         # domain name\n                            (\\d+)/(\\d+)\\s+      # domain num out of num\n                            (\\d+)\\s+(\\d+).+?    # seq start, end\n                            (\\d+)\\s+(\\d+)\\s+    # hmm start, end\n                            \\S+\\s+              # []\n                            (\\S+)\\s+            # score       \n                            (\\S+)               # evalue\n                            \\s*$!ox\n                        )\n                      )\n                    {\n                        my $hindex = $hitinfo{$n};\n                        if ( !defined $hindex ) {\n                            push @hitinfo,\n                              [ $n, '', $vals[5], $vals[6], $domainct ];\n                            $hitinfo{$n} = $#hitinfo;\n                            $hindex = $#hitinfo;\n                        }\n                        my $info = $hitinfo[$hindex];\n                        if ( !defined $info ) {\n                            $self->warn(\n\"incomplete Domain information, can't find $n hitinfo says $hitinfo{$n}\"\n                            );\n                            next;\n                        }\n                        push @hspinfo, [ $n, @vals ];\n                    }\n                }\n            }\n            elsif (/^Alignments of top/o) {\n                my ( $prelength, $lastdomain, $count, $width );\n                $count = 0;\n                my $second_tier = 0;\n                while ( defined( $_ = $self->_readline ) ) {\n                    next\n                      if (\n                        /^Align/o\n                        || ( $count != 1\n                            && /^\\s+RF\\s+[x\\s]+$/o )\n                      );\n                    # fix for bug 2632\n                    next if ($_ =~ m/^\\s+CS\\s+/o && $count == 0);\n                    if ( /^Histogram/o || m!^//!o || /^Query sequence/o ) {\n                        if ( $self->in_element('hsp') ) {\n                            $self->end_element( { 'Name' => 'Hsp' } );\n                        }\n                        if ( $self->in_element('hit') ) {\n                            $self->end_element( { 'Name' => 'Hit' } );\n                        }\n                        $self->_pushback($_);\n                        last;\n                    }\n                    chomp;\n                    if (m/(\\S+):.*from\\s+(\\d+)\\s+to\\s+(\\d+)/o) {\n                        my ( $name, $from, $to ) = ( $1, $2, $3 );\n\n                        if ( $self->within_element('hit') ) {\n                            if ( $self->in_element('hsp') ) {\n                                $self->end_element( { 'Name' => 'Hsp' } );\n                            }\n                            $self->end_element( { 'Name' => 'Hit' } );\n                        }\n                        my $info = [ @{ $hitinfo[ $hitinfo{$name} ] } ];\n                        if ( !defined $info\n                            || $info->[0] ne $name )\n                        {\n                            $self->warn(\n\"Somehow the Model table order does not match the order in the domains (got \"\n                                  . $info->[0]\n                                  . \", expected $name). We're back loading this from the alignment information instead\"\n                            );\n                            $info = [\n                                $name, '',\n                                /score\\s+([^,\\s]+),\\s+E\\s+=\\s+(\\S+)/ox\n                            ];\n                            push @hitinfo, $info;\n                            $hitinfo{$name} = $#hitinfo;\n                        }\n                        $self->start_element( { 'Name' => 'Hit' } );\n\n                        $self->element(\n                            {\n                                'Name' => 'Hit_id',\n                                'Data' => shift @{$info}\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hit_desc',\n                                'Data' => shift @{$info}\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hit_score',\n                                'Data' => shift @{$info}\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hit_signif',\n                                'Data' => shift @{$info}\n                            }\n                        );\n\n                        $self->start_element( { 'Name' => 'Hsp' } );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_identity',\n                                'Data' => 0\n                            }\n                        );                     \n                        $self->element(\n                            {\n                                'Name' => 'Hsp_positive',\n                                'Data' => 0\n                            }\n                        );\n                        my $HSPinfo = shift @hspinfo;\n                        my $id      = shift @$HSPinfo;\n\n                        if ( $id ne $name ) {\n                            $self->throw(\n\"Somehow the domain list details do not match the table (got $id, expected $name)\"\n                            );\n                        }\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_query-from',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_query-to',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_hit-from',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_hit-to',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_score',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_evalue',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $lastdomain = $name;\n                    }\n                    else {\n                        if (/^(\\s+\\*\\-\\>)(\\S+)/o) {\n\n                            # start of domain\n                            $prelength = CORE::length($1);\n                            $width     = 0;\n\n                            # deal with fact that start en stop is on same line\n                            my $data = $2;\n                            if ($data =~ s/\\<\\-?\\*?\\s*$//)\n                            {\n                              $width = CORE::length($data);\n                            }\n \n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_hseq',\n                                    'Data' => $data\n                                }\n                            );\n                            $count       = 0;\n                            $second_tier = 0;\n\n                        }\n                        elsif (/^(\\s+)(\\S+)\\<\\-?\\*?\\s*$/o) {\n\n                            #end of domain\n                            $prelength -= 3 unless ( $second_tier++ );\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_hseq',\n                                    'Data' => $2\n                                }\n                            );\n                            $width = CORE::length($2);\n                            $count = 0;\n                        }\n                        elsif (CORE::length($_) == 0\n                            || ( $count != 1 && /^\\s+$/o )\n                            || /^\\s+\\-?\\*\\s*$/ )\n                        {\n                            next;\n                        }\n                        elsif ( $count == 0 ) {\n                            $prelength -= 3 unless ( $second_tier++ );\n                            unless ( defined $prelength ) {\n\n                                # $self->warn(\"prelength not set\");\n                                next;\n                            }\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_hseq',\n                                    'Data' => substr( $_, $prelength )\n                                }\n                            );\n                        }\n                        elsif ( $count == 1 ) {\n                            if ( !defined $prelength ) {\n                                $self->warn(\"prelength not set\");\n                            }\n                            if ($width) {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_midline',\n                                        'Data' =>\n                                          substr( $_, $prelength, $width )\n                                    }\n                                );\n                            }\n                            else {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_midline',\n                                        'Data' => substr( $_, $prelength )\n                                    }\n                                );\n                            }\n                        }\n                        elsif ( $count == 2 ) {\n                            if (   /^\\s+(\\S+)\\s+(\\d+)\\s+(\\S+)\\s+(\\d+)/o\n                                || /^\\s+(\\S+)\\s+(\\-)\\s+(\\S*)\\s+(\\-)/o )\n                            {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_qseq',\n                                        'Data' => $3\n                                    }\n                                );\n                            }\n                            else {\n                                $self->throw(\n                                    \"unrecognized line ($count): $_\\n\");\n                            }\n                        }\n                        $count = 0 if $count++ >= 2;\n                    }\n                }\n            }\n            elsif ( /^Histogram/o || m!^//!o ) {\n\n                while ( my $HSPinfo = shift @hspinfo ) {\n                    my $id   = shift @$HSPinfo;\n                    my $info = [ @{ $hitinfo[ $hitinfo{$id} ] } ];\n                    next unless defined $info;\n                    $self->start_element( { 'Name' => 'Hit' } );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_id',\n                            'Data' => shift @{$info}\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_desc',\n                            'Data' => shift @{$info}\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_signif',\n                            'Data' => shift @{$info}\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_score',\n                            'Data' => shift @{$info}\n                        }\n                    );\n                    $self->start_element( { 'Name' => 'Hsp' } );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_query-from',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );                    \n                    $self->element(\n                        {\n                            'Name' => 'Hsp_query-to',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_hit-from',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_hit-to',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_score',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_evalue',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_identity',\n                            'Data' => 0\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_positive',\n                            'Data' => 0\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_positive',\n                            'Data' => 0\n                        }\n                    );\n                    $self->end_element( { 'Name' => 'Hsp' } );\n                    $self->end_element( { 'Name' => 'Hit' } );\n                }\n                @hitinfo = ();\n                %hitinfo = ();\n                last;\n            }\n            # uncomment to see missed lines with verbose on\n            #else {\n            #    $self->debug($_);\n            #}\n        }\n        $last = $_;\n    }\n    $self->end_element( { 'Name' => 'HMMER_Output' } ) unless !$seentop;\n    return $self->end_document();\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'","parameters":[{"label":"$self"},{"label":"$data"}]},"containerName":"main::","definition":"sub","range":{"end":{"character":9999,"line":1093},"start":{"line":1081,"character":0}},"name":"start_element"},{"kind":13,"line":1095,"name":"$type","containerName":null},{"containerName":null,"name":"%type","kind":13,"line":1095},{"kind":13,"line":1097,"name":"%self","containerName":null},{"name":"%self","containerName":null,"line":1098,"kind":13},{"line":1113,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"end_element","line":1114,"kind":13},{"line":1114,"kind":13,"name":"$data","containerName":"end_element"},{"line":1115,"kind":13,"localvar":"my","containerName":"end_element","name":"$nm","definition":"my"},{"kind":13,"line":1115,"name":"$data","containerName":"end_element"},{"localvar":"my","definition":"my","name":"$type","containerName":"end_element","line":1116,"kind":13},{"line":1116,"kind":13,"containerName":"end_element","name":"$MODEMAP"},{"kind":13,"line":1116,"containerName":"end_element","name":"$nm"},{"line":1117,"kind":13,"localvar":"my","containerName":"end_element","definition":"my","name":"$rc"},{"line":1119,"kind":13,"name":"$nm","containerName":"end_element"},{"name":"$self","containerName":"end_element","kind":13,"line":1120},{"kind":13,"line":1121,"name":"$self","containerName":"end_element"},{"line":1127,"kind":13,"name":"$nm","containerName":"end_element"},{"definition":"my","name":"$data","containerName":"end_element","localvar":"my","kind":13,"line":1129},{"line":1129,"kind":13,"name":"$self","containerName":"end_element"},{"containerName":"end_element","name":"$data","kind":13,"line":1130},{"name":"$data","containerName":"end_element","kind":13,"line":1132},{"kind":13,"line":1134,"containerName":"end_element","name":"$self"},{"line":1134,"kind":12,"name":"element","containerName":"end_element"},{"kind":13,"line":1138,"name":"$data","containerName":"end_element"},{"containerName":"end_element","name":"$self","kind":13,"line":1141},{"line":1143,"kind":13,"containerName":"end_element","name":"$type"},{"kind":13,"line":1144,"containerName":"end_element","name":"$self"},{"containerName":"end_element","name":"_eventHandler","kind":12,"line":1144},{"containerName":"end_element","name":"will_handle","kind":12,"line":1144},{"name":"$type","containerName":"end_element","line":1144,"kind":13},{"line":1145,"kind":13,"localvar":"my","definition":"my","name":"$func","containerName":"end_element"},{"name":"$type","containerName":"end_element","kind":13,"line":1145},{"containerName":"end_element","name":"$rc","kind":13,"line":1146},{"kind":13,"line":1146,"containerName":"end_element","name":"$self"},{"name":"_eventHandler","containerName":"end_element","kind":12,"line":1146},{"containerName":"end_element","name":"$func","kind":13,"line":1146},{"line":1146,"kind":13,"name":"$self","containerName":"end_element"},{"name":"$self","containerName":"end_element","line":1147,"kind":13},{"kind":13,"line":1149,"containerName":"end_element","definition":"my","name":"$lastelem","localvar":"my"},{"name":"$self","containerName":"end_element","kind":13,"line":1149}],"kind":12,"detail":"($self,$data)","signature":{"documentation":"1;\n# $Id: hmmer.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::hmmer\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::hmmer - A parser for HMMER output (hmmpfam, hmmsearch)\n\n=head1 SYNOPSIS\n\n    # do not use this class directly it is available through Bio::SearchIO\n    use Bio::SearchIO;\n    my $in = Bio::SearchIO->new(-format => 'hmmer',\n                               -file   => 't/data/L77119.hmmer');\n    while( my $result = $in->next_result ) {\n        # this is a Bio::Search::Result::HMMERResult object\n        print $result->query_name(), \" for HMM \", $result->hmm_name(), \"\\n\";\n        while( my $hit = $result->next_hit ) {\n            print $hit->name(), \"\\n\";\n            while( my $hsp = $hit->next_hsp ) {\n                print \"length is \", $hsp->length(), \"\\n\";\n            }\n        }\n    }\n\n=head1 DESCRIPTION\n\nThis object implements a parser for HMMER output.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::hmmer;\n\nuse strict;\n\nuse Bio::Factory::ObjectFactory;\n\nuse vars qw(%MAPPING %MODEMAP\n);\n\nuse base qw(Bio::SearchIO);\n\nBEGIN {\n\n    # mapping of HMMER items to Bioperl hash keys\n    %MODEMAP = (\n        'HMMER_Output' => 'result',\n        'Hit'          => 'hit',\n        'Hsp'          => 'hsp'\n    );\n\n    %MAPPING = (\n        'Hsp_bit-score'   => 'HSP-bits',\n        'Hsp_score'       => 'HSP-score',\n        'Hsp_evalue'      => 'HSP-evalue',\n        'Hsp_query-from'  => 'HSP-query_start',\n        'Hsp_query-to'    => 'HSP-query_end',\n        'Hsp_hit-from'    => 'HSP-hit_start',\n        'Hsp_hit-to'      => 'HSP-hit_end',\n        'Hsp_positive'    => 'HSP-conserved',\n        'Hsp_identity'    => 'HSP-identical',\n        'Hsp_gaps'        => 'HSP-hsp_gaps',\n        'Hsp_hitgaps'     => 'HSP-hit_gaps',\n        'Hsp_querygaps'   => 'HSP-query_gaps',\n        'Hsp_qseq'        => 'HSP-query_seq',\n        'Hsp_hseq'        => 'HSP-hit_seq',\n        'Hsp_midline'     => 'HSP-homology_seq',\n        'Hsp_align-len'   => 'HSP-hsp_length',\n        'Hsp_query-frame' => 'HSP-query_frame',\n        'Hsp_hit-frame'   => 'HSP-hit_frame',\n\n        'Hit_id'        => 'HIT-name',\n        'Hit_len'       => 'HIT-length',\n        'Hit_accession' => 'HIT-accession',\n        'Hit_desc'      => 'HIT-description',\n        'Hit_signif'    => 'HIT-significance',\n        'Hit_score'     => 'HIT-score',\n\n        'HMMER_program'   => 'RESULT-algorithm_name',\n        'HMMER_version'   => 'RESULT-algorithm_version',\n        'HMMER_query-def' => 'RESULT-query_name',\n        'HMMER_query-len' => 'RESULT-query_length',\n        'HMMER_query-acc' => 'RESULT-query_accession',\n        'HMMER_querydesc' => 'RESULT-query_description',\n        'HMMER_hmm'       => 'RESULT-hmm_name',\n        'HMMER_seqfile'   => 'RESULT-sequence_file',\n        'HMMER_db'        => 'RESULT-database_name',\n    );\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::hmmer->new();\n Function: Builds a new Bio::SearchIO::hmmer object \n Returns : Bio::SearchIO::hmmer\n Args    : -fh/-file => HMMER filename\n           -format   => 'hmmer'\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n    my $handler = $self->_eventHandler;\n    $handler->register_factory(\n        'result',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Result::HMMERResult',\n            -interface => 'Bio::Search::Result::ResultI'\n        )\n    );\n\n    $handler->register_factory(\n        'hit',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Hit::HMMERHit',\n            -interface => 'Bio::Search::Hit::HitI'\n        )\n    );\n\n    $handler->register_factory(\n        'hsp',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::HSP::HMMERHSP',\n            -interface => 'Bio::Search::HSP::HSPI'\n        )\n    );\n    $self->{'_hmmidline'} = 'HMMER 2.2g (August 2001)';\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    my $seentop = 0;\n    my $reporttype;\n    my ( $last, @hitinfo, @hspinfo, %hspinfo, %hitinfo );\n    local $/ = \"\\n\";\n    local $_;\n\n    my $verbose = $self->verbose;    # cache for speed?\n    $self->start_document();\n    local ($_);\n    while ( defined( $_ = $self->_readline ) ) {\n        my $lineorig = $_;\n        chomp;\n        if (/^HMMER\\s+(\\S+)\\s+\\((.+)\\)/o) {\n            my ( $prog, $version ) = split;\n            if ($seentop) {\n                $self->_pushback($_);\n                $self->end_element( { 'Name' => 'HMMER_Output' } );\n                return $self->end_document();\n            }\n            $self->{'_hmmidline'} = $_;\n            $self->start_element( { 'Name' => 'HMMER_Output' } );\n            $self->{'_result_count'}++;\n            $seentop = 1;\n            if ( defined $last ) {\n                ($reporttype) = split( /\\s+/, $last );\n                $self->element(\n                    {\n                        'Name' => 'HMMER_program',\n                        'Data' => uc($reporttype)\n                    }\n                );\n            }\n            $self->element(\n                {\n                    'Name' => 'HMMER_version',\n                    'Data' => $version\n                }\n            );\n        }\n        elsif (s/^HMM file:\\s+//o) {\n            $self->{'_hmmfileline'} = $lineorig;\n            $self->element(\n                {\n                    'Name' => 'HMMER_hmm',\n                    'Data' => $_\n                }\n            );\n        }\n        elsif (s/^Sequence\\s+(file|database):\\s+//o) {\n            $self->{'_hmmseqline'} = $lineorig;\n            if ( $1 eq 'database' ) {\n                $self->element(\n                    {\n                        'Name' => 'HMMER_db',\n                        'Data' => $_\n                    }\n                );\n            }\n            $self->element(\n                {\n                    'Name' => 'HMMER_seqfile',\n                    'Data' => $_\n                }\n            );\n        }\n        elsif (s/^Query(\\s+(sequence|HMM))?(?:\\s+\\d+)?:\\s+//o) {\n            if ( !$seentop ) {\n\n                # we're in a multi-query report\n                $self->_pushback( $self->{'_hmmidline'} );\n                $self->_pushback( $self->{'_hmmfileline'} );\n                $self->_pushback( $self->{'_hmmseqline'} );\n                $self->_pushback($lineorig);\n                next;\n            }\n            s/\\s+$//;\n            $self->element(\n                {\n                    'Name' => 'HMMER_query-def',\n                    'Data' => $_\n                }\n            );\n        }\n        elsif (s/^Accession:\\s+//o) {\n            s/\\s+$//;\n            $self->element(\n                {\n                    'Name' => 'HMMER_query-acc',\n                    'Data' => $_\n                }\n            );\n        }\n        elsif (s/^Description:\\s+//o) {\n            s/\\s+$//;\n            $self->element(\n                {\n                    'Name' => 'HMMER_querydesc',\n                    'Data' => $_\n                }\n            );\n        }\n        elsif ( defined $self->{'_reporttype'}\n            && $self->{'_reporttype'} eq 'HMMSEARCH' )\n        {\n\n            # PROCESS HMMSEARCH RESULTS HERE\n            if (/^Scores for complete sequences/o) {\n                while ( defined( $_ = $self->_readline ) ) {\n                    last if (/^\\s+$/);\n                    next if ( /^Sequence\\s+Description/o || /^\\-\\-\\-/o );\n                    my @line = split;\n                    my ( $name, $n, $evalue, $score ) =\n                      ( shift @line, pop @line, pop @line, pop @line );\n                    my $desc = join( ' ', @line );\n                    push @hitinfo, [ $name, $desc, $evalue, $score ];\n                    $hitinfo{$name} = $#hitinfo;\n                }\n            }\n            elsif (/^Parsed for domains:/o) {\n                @hspinfo = ();\n\n                while ( defined( $_ = $self->_readline ) ) {\n                    last if (/^\\s+$/);\n                    if (m!^//!) {\n                        $self->_pushback($_);\n                        last;\n                    }\n                    next if ( /^(Model|Sequence)\\s+Domain/ || /^\\-\\-\\-/ );\n\n                    chomp;\n                    if (\n                        my ( $n, $domainnum, $domainct, @vals ) = (\n                            m!^(\\S+)\\s+      # host name\n\t\t\t(\\d+)/(\\d+)\\s+   # num/num (ie 1 of 2) \n\t\t\t(\\d+)\\s+(\\d+).+? # sequence start and end\n\t\t\t(\\d+)\\s+(\\d+)\\s+ # hmm start and end\n\t\t\t\\S+\\s+           # []\n\t\t\t(\\S+)\\s+         # score\n\t\t\t(\\S+)            # evalue\n\t\t\t\\s*$!ox\n                        )\n                      )\n                    {\n\n                        # array lookup so that we can get rid of things\n                        # when they've been processed\n                        my $info = $hitinfo[ $hitinfo{$n} ];\n                        if ( !defined $info ) {\n                            $self->warn(\n\"Incomplete Sequence information, can't find $n hitinfo says $hitinfo{$n}\"\n                            );\n                            next;\n                        }\n                        push @hspinfo, [ $n, @vals ];\n                    }\n                }\n            }\n            elsif (/^Alignments of top/o) {\n                my ( $prelength, $lastdomain, $count, $width );\n                $count = 0;\n                my %domaincounter;\n                my $second_tier = 0;\n                while ( defined( $_ = $self->_readline ) ) {\n                    next if ( /^Align/o\n                        || /^\\s+RF\\s+[x\\s]+$/o );\n                    if ( /^Histogram/o || m!^//!o ) {\n                        if ( $self->in_element('hsp') ) {\n                            $self->end_element( { 'Name' => 'Hsp' } );\n                        }\n                        if ( $self->within_element('hit') ) {\n                            $self->end_element( { 'Name' => 'Hit' } );\n                        }\n                        last;\n                    }\n                    chomp;\n\n                    if (\n                        m/^\\s*(.+):\\s+domain\\s+(\\d+)\\s+of\\s+(\\d+)\\,\\s+\n                        from\\s+(\\d+)\\s+to\\s+(\\d+)/x\n                      )\n                    {\n                        my ( $name, $domainct, $domaintotal, $from, $to ) =\n                          ( $1, $2, $3, $4, $5 );\n                        $domaincounter{$name}++;\n                        if ( $self->within_element('hit') ) {\n                            if ( $self->within_element('hsp') ) {\n                                $self->end_element( { 'Name' => 'Hsp' } );\n                            }\n                            $self->end_element( { 'Name' => 'Hit' } );\n                        }\n\n                        $self->start_element( { 'Name' => 'Hit' } );\n                        my $info = [\n                            @{\n                                $hitinfo[ $hitinfo{$name} ] || $self->throw(\n\"Could not find hit info for $name: Insure that your database contains only unique sequence names\"\n                                )\n                              }\n                        ];\n                        if ( $info->[0] ne $name ) {\n                            $self->throw(\n\"Somehow the Model table order does not match the order in the domains (got \"\n                                  . $info->[0]\n                                  . \", expected $name)\" );\n                        }\n                        $self->element(\n                            {\n                                'Name' => 'Hit_id',\n                                'Data' => shift @{$info}\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hit_desc',\n                                'Data' => shift @{$info}\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hit_signif',\n                                'Data' => shift @{$info}\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hit_score',\n                                'Data' => shift @{$info}\n                            }\n                        );\n\n                        $self->start_element( { 'Name' => 'Hsp' } );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_identity',\n                                'Data' => 0\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_positive',\n                                'Data' => 0\n                            }\n                        );\n                        my $HSPinfo = shift @hspinfo;\n                        my $id      = shift @$HSPinfo;\n\n                        if ( $id ne $name ) {\n                            $self->throw(\n\"Somehow the domain list details do not match the table (got $id, expected $name)\"\n                            );\n                        }\n                        if ( $domaincounter{$name} == $domaintotal ) {\n                            $hitinfo[ $hitinfo{$name} ] = undef;\n                        }\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_hit-from',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_hit-to',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_query-from',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_query-to',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_score',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_evalue',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $lastdomain = $name;\n                    }\n                    else {\n\n                        # Might want to change this so that it\n                        # accumulates all the of the alignment lines into\n                        # three array slots and then tests for the\n                        # end of the line\n                        if (/^(\\s+\\*\\-\\>)(\\S+)/o) {    # start of domain\n                            $prelength = CORE::length($1);\n                            $width     = 0;\n\n                            # deal with fact that start en stop is on same line\n                            my $data = $2;\n                            if ($data =~ s/\\<\\-?\\*?\\s*$//)\n                            {\n                                $width = CORE::length($data);\n                            }\n \n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_qseq',\n                                    'Data' => $data\n                                }\n                            );\n                            $count       = 0;\n                            $second_tier = 0;\n                        }\n                        elsif (/^(\\s+)(\\S+)\\<\\-\\*\\s*$/o) {    #end of domain\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_qseq',\n                                    'Data' => $2\n                                }\n                            );\n                            $width = CORE::length($2);\n                            $count = 0;\n                        }\n                        elsif (( $count != 1 && /^\\s+$/o )\n                            || CORE::length($_) == 0\n                            || /^\\s+\\-?\\*\\s*$/ )\n                        {\n                            next;\n                        }\n                        elsif ( $count == 0 ) {\n                            $prelength -= 3 unless ( $second_tier++ );\n                            unless ( defined $prelength ) {\n\n                                # $self->warn(\"prelength not set\");\n                                next;\n                            }\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_qseq',\n                                    'Data' => substr( $_, $prelength )\n                                }\n                            );\n                        }\n                        elsif ( $count == 1 ) {\n                            if ( !defined $prelength ) {\n                                $self->warn(\"prelength not set\");\n                            }\n                            if ($width) {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_midline',\n                                        'Data' =>\n                                          substr( $_, $prelength, $width )\n                                    }\n                                );\n                            }\n                            else {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_midline',\n                                        'Data' => substr( $_, $prelength )\n                                    }\n                                );\n                            }\n                        }\n                        elsif ( $count == 2 ) {\n                            if (/^\\s+(\\S+)\\s+(\\d+|\\-)\\s+(\\S*)\\s+(\\d+|\\-)/o) {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_hseq',\n                                        'Data' => $3\n                                    }\n                                );\n                            }\n                            else {\n                                $self->warn(\"unrecognized line: $_\\n\");\n                            }\n                        }\n                        $count = 0 if $count++ >= 2;\n                    }\n                }\n            }\n            elsif ( /^Histogram/o || m!^//!o ) {\n                while ( my $HSPinfo = shift @hspinfo ) {\n                    my $id   = shift @$HSPinfo;\n                    my $info = [ @{ $hitinfo[ $hitinfo{$id} ] } ];\n                    next unless defined $info;\n                    $self->start_element( { 'Name' => 'Hit' } );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_id',\n                            'Data' => shift @{$info}\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_desc',\n                            'Data' => shift @{$info}\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_signif',\n                            'Data' => shift @{$info}\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_score',\n                            'Data' => shift @{$info}\n                        }\n                    );\n                    $self->start_element( { 'Name' => 'Hsp' } );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_query-from',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_query-to',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_hit-from',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_hit-to',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_score',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_evalue',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_identity',\n                            'Data' => 0\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_positive',\n                            'Data' => 0\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_positive',\n                            'Data' => 0\n                        }\n                    );\n                    $self->end_element( { 'Name' => 'Hsp' } );\n                    $self->end_element( { 'Name' => 'Hit' } );\n                }\n                @hitinfo = ();\n                %hitinfo = ();\n                last;\n            }\n        }\n        elsif ( defined $self->{'_reporttype'}\n            && $self->{'_reporttype'} eq 'HMMPFAM' )\n        {\n            # process HMMPFAM results here\n            if (/^Scores for sequence family/o) {\n                while ( defined( $_ = $self->_readline ) ) {\n                    last if (/^\\s+$/);\n                    next if ( /^Model\\s+Description/o || /^\\-\\-\\-/o );\n                    chomp;\n                    my @line = split;\n                    my ( $model, $n, $evalue, $score ) =\n                      ( shift @line, pop @line, pop @line, pop @line );\n                    my $desc = join( ' ', @line );\n                    push @hitinfo, [ $model, $desc, $score, $evalue, $n ];\n                    $hitinfo{$model} = $#hitinfo;\n                }\n            }\n            elsif (/^Parsed for domains:/o) {\n                @hspinfo = ();\n                while ( defined( $_ = $self->_readline ) ) {\n                    last if (/^\\s+$/);\n                    if (m!^//!) {\n                        $self->_pushback($_);\n                        last;\n                    }\n                    next if ( /^Model\\s+Domain/o || /^\\-\\-\\-/o );\n                    chomp;\n                    if (\n                        my ( $n, $domainnum, $domainct, @vals ) = (\n                            m!^(\\S+)\\s+         # domain name\n                            (\\d+)/(\\d+)\\s+      # domain num out of num\n                            (\\d+)\\s+(\\d+).+?    # seq start, end\n                            (\\d+)\\s+(\\d+)\\s+    # hmm start, end\n                            \\S+\\s+              # []\n                            (\\S+)\\s+            # score       \n                            (\\S+)               # evalue\n                            \\s*$!ox\n                        )\n                      )\n                    {\n                        my $hindex = $hitinfo{$n};\n                        if ( !defined $hindex ) {\n                            push @hitinfo,\n                              [ $n, '', $vals[5], $vals[6], $domainct ];\n                            $hitinfo{$n} = $#hitinfo;\n                            $hindex = $#hitinfo;\n                        }\n                        my $info = $hitinfo[$hindex];\n                        if ( !defined $info ) {\n                            $self->warn(\n\"incomplete Domain information, can't find $n hitinfo says $hitinfo{$n}\"\n                            );\n                            next;\n                        }\n                        push @hspinfo, [ $n, @vals ];\n                    }\n                }\n            }\n            elsif (/^Alignments of top/o) {\n                my ( $prelength, $lastdomain, $count, $width );\n                $count = 0;\n                my $second_tier = 0;\n                while ( defined( $_ = $self->_readline ) ) {\n                    next\n                      if (\n                        /^Align/o\n                        || ( $count != 1\n                            && /^\\s+RF\\s+[x\\s]+$/o )\n                      );\n                    # fix for bug 2632\n                    next if ($_ =~ m/^\\s+CS\\s+/o && $count == 0);\n                    if ( /^Histogram/o || m!^//!o || /^Query sequence/o ) {\n                        if ( $self->in_element('hsp') ) {\n                            $self->end_element( { 'Name' => 'Hsp' } );\n                        }\n                        if ( $self->in_element('hit') ) {\n                            $self->end_element( { 'Name' => 'Hit' } );\n                        }\n                        $self->_pushback($_);\n                        last;\n                    }\n                    chomp;\n                    if (m/(\\S+):.*from\\s+(\\d+)\\s+to\\s+(\\d+)/o) {\n                        my ( $name, $from, $to ) = ( $1, $2, $3 );\n\n                        if ( $self->within_element('hit') ) {\n                            if ( $self->in_element('hsp') ) {\n                                $self->end_element( { 'Name' => 'Hsp' } );\n                            }\n                            $self->end_element( { 'Name' => 'Hit' } );\n                        }\n                        my $info = [ @{ $hitinfo[ $hitinfo{$name} ] } ];\n                        if ( !defined $info\n                            || $info->[0] ne $name )\n                        {\n                            $self->warn(\n\"Somehow the Model table order does not match the order in the domains (got \"\n                                  . $info->[0]\n                                  . \", expected $name). We're back loading this from the alignment information instead\"\n                            );\n                            $info = [\n                                $name, '',\n                                /score\\s+([^,\\s]+),\\s+E\\s+=\\s+(\\S+)/ox\n                            ];\n                            push @hitinfo, $info;\n                            $hitinfo{$name} = $#hitinfo;\n                        }\n                        $self->start_element( { 'Name' => 'Hit' } );\n\n                        $self->element(\n                            {\n                                'Name' => 'Hit_id',\n                                'Data' => shift @{$info}\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hit_desc',\n                                'Data' => shift @{$info}\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hit_score',\n                                'Data' => shift @{$info}\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hit_signif',\n                                'Data' => shift @{$info}\n                            }\n                        );\n\n                        $self->start_element( { 'Name' => 'Hsp' } );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_identity',\n                                'Data' => 0\n                            }\n                        );                     \n                        $self->element(\n                            {\n                                'Name' => 'Hsp_positive',\n                                'Data' => 0\n                            }\n                        );\n                        my $HSPinfo = shift @hspinfo;\n                        my $id      = shift @$HSPinfo;\n\n                        if ( $id ne $name ) {\n                            $self->throw(\n\"Somehow the domain list details do not match the table (got $id, expected $name)\"\n                            );\n                        }\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_query-from',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_query-to',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_hit-from',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_hit-to',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_score',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_evalue',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $lastdomain = $name;\n                    }\n                    else {\n                        if (/^(\\s+\\*\\-\\>)(\\S+)/o) {\n\n                            # start of domain\n                            $prelength = CORE::length($1);\n                            $width     = 0;\n\n                            # deal with fact that start en stop is on same line\n                            my $data = $2;\n                            if ($data =~ s/\\<\\-?\\*?\\s*$//)\n                            {\n                              $width = CORE::length($data);\n                            }\n \n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_hseq',\n                                    'Data' => $data\n                                }\n                            );\n                            $count       = 0;\n                            $second_tier = 0;\n\n                        }\n                        elsif (/^(\\s+)(\\S+)\\<\\-?\\*?\\s*$/o) {\n\n                            #end of domain\n                            $prelength -= 3 unless ( $second_tier++ );\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_hseq',\n                                    'Data' => $2\n                                }\n                            );\n                            $width = CORE::length($2);\n                            $count = 0;\n                        }\n                        elsif (CORE::length($_) == 0\n                            || ( $count != 1 && /^\\s+$/o )\n                            || /^\\s+\\-?\\*\\s*$/ )\n                        {\n                            next;\n                        }\n                        elsif ( $count == 0 ) {\n                            $prelength -= 3 unless ( $second_tier++ );\n                            unless ( defined $prelength ) {\n\n                                # $self->warn(\"prelength not set\");\n                                next;\n                            }\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_hseq',\n                                    'Data' => substr( $_, $prelength )\n                                }\n                            );\n                        }\n                        elsif ( $count == 1 ) {\n                            if ( !defined $prelength ) {\n                                $self->warn(\"prelength not set\");\n                            }\n                            if ($width) {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_midline',\n                                        'Data' =>\n                                          substr( $_, $prelength, $width )\n                                    }\n                                );\n                            }\n                            else {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_midline',\n                                        'Data' => substr( $_, $prelength )\n                                    }\n                                );\n                            }\n                        }\n                        elsif ( $count == 2 ) {\n                            if (   /^\\s+(\\S+)\\s+(\\d+)\\s+(\\S+)\\s+(\\d+)/o\n                                || /^\\s+(\\S+)\\s+(\\-)\\s+(\\S*)\\s+(\\-)/o )\n                            {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_qseq',\n                                        'Data' => $3\n                                    }\n                                );\n                            }\n                            else {\n                                $self->throw(\n                                    \"unrecognized line ($count): $_\\n\");\n                            }\n                        }\n                        $count = 0 if $count++ >= 2;\n                    }\n                }\n            }\n            elsif ( /^Histogram/o || m!^//!o ) {\n\n                while ( my $HSPinfo = shift @hspinfo ) {\n                    my $id   = shift @$HSPinfo;\n                    my $info = [ @{ $hitinfo[ $hitinfo{$id} ] } ];\n                    next unless defined $info;\n                    $self->start_element( { 'Name' => 'Hit' } );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_id',\n                            'Data' => shift @{$info}\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_desc',\n                            'Data' => shift @{$info}\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_signif',\n                            'Data' => shift @{$info}\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_score',\n                            'Data' => shift @{$info}\n                        }\n                    );\n                    $self->start_element( { 'Name' => 'Hsp' } );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_query-from',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );                    \n                    $self->element(\n                        {\n                            'Name' => 'Hsp_query-to',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_hit-from',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_hit-to',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_score',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_evalue',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_identity',\n                            'Data' => 0\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_positive',\n                            'Data' => 0\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_positive',\n                            'Data' => 0\n                        }\n                    );\n                    $self->end_element( { 'Name' => 'Hsp' } );\n                    $self->end_element( { 'Name' => 'Hit' } );\n                }\n                @hitinfo = ();\n                %hitinfo = ();\n                last;\n            }\n            # uncomment to see missed lines with verbose on\n            #else {\n            #    $self->debug($_);\n            #}\n        }\n        $last = $_;\n    }\n    $self->end_element( { 'Name' => 'HMMER_Output' } ) unless !$seentop;\n    return $self->end_document();\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element {\n    my ( $self, $data ) = @_;\n\n    # we currently don't care about attributes\n    my $nm   = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    if ($type) {\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = sprintf( \"start_%s\", lc $type );\n            $self->_eventHandler->$func( $data->{'Attributes'} );\n        }\n        unshift @{ $self->{'_elements'} }, $type;\n    }\n    if ( defined $type\n        && $type eq 'result' )\n    {\n        $self->{'_values'} = {};\n        $self->{'_result'} = undef;\n    }\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'","parameters":[{"label":"$self"},{"label":"$data"}],"label":"end_element($self,$data)"},"containerName":"main::","definition":"sub","range":{"start":{"line":1113,"character":0},"end":{"character":9999,"line":1150}},"name":"end_element"},{"containerName":null,"name":"%MAPPING","kind":13,"line":1151},{"containerName":null,"name":"%nm","line":1151,"kind":13},{"kind":13,"line":1152,"name":"%MAPPING","containerName":null},{"name":"%nm","containerName":null,"kind":13,"line":1152},{"localvar":"my","containerName":null,"definition":"my","name":"$key","line":1153,"kind":13},{"name":"%MAPPING","containerName":null,"line":1153,"kind":13},{"containerName":null,"name":"@nm","kind":13,"line":1153},{"containerName":null,"name":"%self","line":1154,"kind":13},{"line":1154,"kind":13,"containerName":null,"name":"%key"},{"containerName":null,"name":"%MAPPING","kind":13,"line":1154},{"name":"%nm","containerName":null,"kind":13,"line":1154},{"kind":13,"line":1154,"containerName":null,"name":"$key"},{"line":1155,"kind":13,"name":"%self","containerName":null},{"name":"%self","containerName":null,"line":1158,"kind":13},{"containerName":null,"name":"%MAPPING","line":1158,"kind":13},{"line":1158,"kind":13,"name":"$nm","containerName":null},{"kind":13,"line":1158,"name":"%self","containerName":null},{"line":1162,"kind":13,"name":"$self","containerName":null},{"containerName":"main::","name":"debug","line":1162,"kind":12},{"containerName":null,"name":"%self","line":1164,"kind":13},{"line":1166,"kind":13,"containerName":null,"name":"%self"},{"kind":13,"line":1166,"containerName":null,"name":"$rc"},{"containerName":null,"name":"$type","kind":13,"line":1166},{"line":1166,"kind":13,"name":"$type","containerName":null},{"kind":13,"line":1167,"containerName":null,"name":"$rc"},{"range":{"start":{"line":1181,"character":0},"end":{"character":9999,"line":1186}},"name":"element","signature":{"parameters":[{"label":"$self"},{"label":"$data"}],"documentation":"1;\n# $Id: hmmer.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::hmmer\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::hmmer - A parser for HMMER output (hmmpfam, hmmsearch)\n\n=head1 SYNOPSIS\n\n    # do not use this class directly it is available through Bio::SearchIO\n    use Bio::SearchIO;\n    my $in = Bio::SearchIO->new(-format => 'hmmer',\n                               -file   => 't/data/L77119.hmmer');\n    while( my $result = $in->next_result ) {\n        # this is a Bio::Search::Result::HMMERResult object\n        print $result->query_name(), \" for HMM \", $result->hmm_name(), \"\\n\";\n        while( my $hit = $result->next_hit ) {\n            print $hit->name(), \"\\n\";\n            while( my $hsp = $hit->next_hsp ) {\n                print \"length is \", $hsp->length(), \"\\n\";\n            }\n        }\n    }\n\n=head1 DESCRIPTION\n\nThis object implements a parser for HMMER output.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::hmmer;\n\nuse strict;\n\nuse Bio::Factory::ObjectFactory;\n\nuse vars qw(%MAPPING %MODEMAP\n);\n\nuse base qw(Bio::SearchIO);\n\nBEGIN {\n\n    # mapping of HMMER items to Bioperl hash keys\n    %MODEMAP = (\n        'HMMER_Output' => 'result',\n        'Hit'          => 'hit',\n        'Hsp'          => 'hsp'\n    );\n\n    %MAPPING = (\n        'Hsp_bit-score'   => 'HSP-bits',\n        'Hsp_score'       => 'HSP-score',\n        'Hsp_evalue'      => 'HSP-evalue',\n        'Hsp_query-from'  => 'HSP-query_start',\n        'Hsp_query-to'    => 'HSP-query_end',\n        'Hsp_hit-from'    => 'HSP-hit_start',\n        'Hsp_hit-to'      => 'HSP-hit_end',\n        'Hsp_positive'    => 'HSP-conserved',\n        'Hsp_identity'    => 'HSP-identical',\n        'Hsp_gaps'        => 'HSP-hsp_gaps',\n        'Hsp_hitgaps'     => 'HSP-hit_gaps',\n        'Hsp_querygaps'   => 'HSP-query_gaps',\n        'Hsp_qseq'        => 'HSP-query_seq',\n        'Hsp_hseq'        => 'HSP-hit_seq',\n        'Hsp_midline'     => 'HSP-homology_seq',\n        'Hsp_align-len'   => 'HSP-hsp_length',\n        'Hsp_query-frame' => 'HSP-query_frame',\n        'Hsp_hit-frame'   => 'HSP-hit_frame',\n\n        'Hit_id'        => 'HIT-name',\n        'Hit_len'       => 'HIT-length',\n        'Hit_accession' => 'HIT-accession',\n        'Hit_desc'      => 'HIT-description',\n        'Hit_signif'    => 'HIT-significance',\n        'Hit_score'     => 'HIT-score',\n\n        'HMMER_program'   => 'RESULT-algorithm_name',\n        'HMMER_version'   => 'RESULT-algorithm_version',\n        'HMMER_query-def' => 'RESULT-query_name',\n        'HMMER_query-len' => 'RESULT-query_length',\n        'HMMER_query-acc' => 'RESULT-query_accession',\n        'HMMER_querydesc' => 'RESULT-query_description',\n        'HMMER_hmm'       => 'RESULT-hmm_name',\n        'HMMER_seqfile'   => 'RESULT-sequence_file',\n        'HMMER_db'        => 'RESULT-database_name',\n    );\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::hmmer->new();\n Function: Builds a new Bio::SearchIO::hmmer object \n Returns : Bio::SearchIO::hmmer\n Args    : -fh/-file => HMMER filename\n           -format   => 'hmmer'\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n    my $handler = $self->_eventHandler;\n    $handler->register_factory(\n        'result',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Result::HMMERResult',\n            -interface => 'Bio::Search::Result::ResultI'\n        )\n    );\n\n    $handler->register_factory(\n        'hit',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Hit::HMMERHit',\n            -interface => 'Bio::Search::Hit::HitI'\n        )\n    );\n\n    $handler->register_factory(\n        'hsp',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::HSP::HMMERHSP',\n            -interface => 'Bio::Search::HSP::HSPI'\n        )\n    );\n    $self->{'_hmmidline'} = 'HMMER 2.2g (August 2001)';\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    my $seentop = 0;\n    my $reporttype;\n    my ( $last, @hitinfo, @hspinfo, %hspinfo, %hitinfo );\n    local $/ = \"\\n\";\n    local $_;\n\n    my $verbose = $self->verbose;    # cache for speed?\n    $self->start_document();\n    local ($_);\n    while ( defined( $_ = $self->_readline ) ) {\n        my $lineorig = $_;\n        chomp;\n        if (/^HMMER\\s+(\\S+)\\s+\\((.+)\\)/o) {\n            my ( $prog, $version ) = split;\n            if ($seentop) {\n                $self->_pushback($_);\n                $self->end_element( { 'Name' => 'HMMER_Output' } );\n                return $self->end_document();\n            }\n            $self->{'_hmmidline'} = $_;\n            $self->start_element( { 'Name' => 'HMMER_Output' } );\n            $self->{'_result_count'}++;\n            $seentop = 1;\n            if ( defined $last ) {\n                ($reporttype) = split( /\\s+/, $last );\n                $self->element(\n                    {\n                        'Name' => 'HMMER_program',\n                        'Data' => uc($reporttype)\n                    }\n                );\n            }\n            $self->element(\n                {\n                    'Name' => 'HMMER_version',\n                    'Data' => $version\n                }\n            );\n        }\n        elsif (s/^HMM file:\\s+//o) {\n            $self->{'_hmmfileline'} = $lineorig;\n            $self->element(\n                {\n                    'Name' => 'HMMER_hmm',\n                    'Data' => $_\n                }\n            );\n        }\n        elsif (s/^Sequence\\s+(file|database):\\s+//o) {\n            $self->{'_hmmseqline'} = $lineorig;\n            if ( $1 eq 'database' ) {\n                $self->element(\n                    {\n                        'Name' => 'HMMER_db',\n                        'Data' => $_\n                    }\n                );\n            }\n            $self->element(\n                {\n                    'Name' => 'HMMER_seqfile',\n                    'Data' => $_\n                }\n            );\n        }\n        elsif (s/^Query(\\s+(sequence|HMM))?(?:\\s+\\d+)?:\\s+//o) {\n            if ( !$seentop ) {\n\n                # we're in a multi-query report\n                $self->_pushback( $self->{'_hmmidline'} );\n                $self->_pushback( $self->{'_hmmfileline'} );\n                $self->_pushback( $self->{'_hmmseqline'} );\n                $self->_pushback($lineorig);\n                next;\n            }\n            s/\\s+$//;\n            $self->element(\n                {\n                    'Name' => 'HMMER_query-def',\n                    'Data' => $_\n                }\n            );\n        }\n        elsif (s/^Accession:\\s+//o) {\n            s/\\s+$//;\n            $self->element(\n                {\n                    'Name' => 'HMMER_query-acc',\n                    'Data' => $_\n                }\n            );\n        }\n        elsif (s/^Description:\\s+//o) {\n            s/\\s+$//;\n            $self->element(\n                {\n                    'Name' => 'HMMER_querydesc',\n                    'Data' => $_\n                }\n            );\n        }\n        elsif ( defined $self->{'_reporttype'}\n            && $self->{'_reporttype'} eq 'HMMSEARCH' )\n        {\n\n            # PROCESS HMMSEARCH RESULTS HERE\n            if (/^Scores for complete sequences/o) {\n                while ( defined( $_ = $self->_readline ) ) {\n                    last if (/^\\s+$/);\n                    next if ( /^Sequence\\s+Description/o || /^\\-\\-\\-/o );\n                    my @line = split;\n                    my ( $name, $n, $evalue, $score ) =\n                      ( shift @line, pop @line, pop @line, pop @line );\n                    my $desc = join( ' ', @line );\n                    push @hitinfo, [ $name, $desc, $evalue, $score ];\n                    $hitinfo{$name} = $#hitinfo;\n                }\n            }\n            elsif (/^Parsed for domains:/o) {\n                @hspinfo = ();\n\n                while ( defined( $_ = $self->_readline ) ) {\n                    last if (/^\\s+$/);\n                    if (m!^//!) {\n                        $self->_pushback($_);\n                        last;\n                    }\n                    next if ( /^(Model|Sequence)\\s+Domain/ || /^\\-\\-\\-/ );\n\n                    chomp;\n                    if (\n                        my ( $n, $domainnum, $domainct, @vals ) = (\n                            m!^(\\S+)\\s+      # host name\n\t\t\t(\\d+)/(\\d+)\\s+   # num/num (ie 1 of 2) \n\t\t\t(\\d+)\\s+(\\d+).+? # sequence start and end\n\t\t\t(\\d+)\\s+(\\d+)\\s+ # hmm start and end\n\t\t\t\\S+\\s+           # []\n\t\t\t(\\S+)\\s+         # score\n\t\t\t(\\S+)            # evalue\n\t\t\t\\s*$!ox\n                        )\n                      )\n                    {\n\n                        # array lookup so that we can get rid of things\n                        # when they've been processed\n                        my $info = $hitinfo[ $hitinfo{$n} ];\n                        if ( !defined $info ) {\n                            $self->warn(\n\"Incomplete Sequence information, can't find $n hitinfo says $hitinfo{$n}\"\n                            );\n                            next;\n                        }\n                        push @hspinfo, [ $n, @vals ];\n                    }\n                }\n            }\n            elsif (/^Alignments of top/o) {\n                my ( $prelength, $lastdomain, $count, $width );\n                $count = 0;\n                my %domaincounter;\n                my $second_tier = 0;\n                while ( defined( $_ = $self->_readline ) ) {\n                    next if ( /^Align/o\n                        || /^\\s+RF\\s+[x\\s]+$/o );\n                    if ( /^Histogram/o || m!^//!o ) {\n                        if ( $self->in_element('hsp') ) {\n                            $self->end_element( { 'Name' => 'Hsp' } );\n                        }\n                        if ( $self->within_element('hit') ) {\n                            $self->end_element( { 'Name' => 'Hit' } );\n                        }\n                        last;\n                    }\n                    chomp;\n\n                    if (\n                        m/^\\s*(.+):\\s+domain\\s+(\\d+)\\s+of\\s+(\\d+)\\,\\s+\n                        from\\s+(\\d+)\\s+to\\s+(\\d+)/x\n                      )\n                    {\n                        my ( $name, $domainct, $domaintotal, $from, $to ) =\n                          ( $1, $2, $3, $4, $5 );\n                        $domaincounter{$name}++;\n                        if ( $self->within_element('hit') ) {\n                            if ( $self->within_element('hsp') ) {\n                                $self->end_element( { 'Name' => 'Hsp' } );\n                            }\n                            $self->end_element( { 'Name' => 'Hit' } );\n                        }\n\n                        $self->start_element( { 'Name' => 'Hit' } );\n                        my $info = [\n                            @{\n                                $hitinfo[ $hitinfo{$name} ] || $self->throw(\n\"Could not find hit info for $name: Insure that your database contains only unique sequence names\"\n                                )\n                              }\n                        ];\n                        if ( $info->[0] ne $name ) {\n                            $self->throw(\n\"Somehow the Model table order does not match the order in the domains (got \"\n                                  . $info->[0]\n                                  . \", expected $name)\" );\n                        }\n                        $self->element(\n                            {\n                                'Name' => 'Hit_id',\n                                'Data' => shift @{$info}\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hit_desc',\n                                'Data' => shift @{$info}\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hit_signif',\n                                'Data' => shift @{$info}\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hit_score',\n                                'Data' => shift @{$info}\n                            }\n                        );\n\n                        $self->start_element( { 'Name' => 'Hsp' } );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_identity',\n                                'Data' => 0\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_positive',\n                                'Data' => 0\n                            }\n                        );\n                        my $HSPinfo = shift @hspinfo;\n                        my $id      = shift @$HSPinfo;\n\n                        if ( $id ne $name ) {\n                            $self->throw(\n\"Somehow the domain list details do not match the table (got $id, expected $name)\"\n                            );\n                        }\n                        if ( $domaincounter{$name} == $domaintotal ) {\n                            $hitinfo[ $hitinfo{$name} ] = undef;\n                        }\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_hit-from',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_hit-to',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_query-from',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_query-to',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_score',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_evalue',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $lastdomain = $name;\n                    }\n                    else {\n\n                        # Might want to change this so that it\n                        # accumulates all the of the alignment lines into\n                        # three array slots and then tests for the\n                        # end of the line\n                        if (/^(\\s+\\*\\-\\>)(\\S+)/o) {    # start of domain\n                            $prelength = CORE::length($1);\n                            $width     = 0;\n\n                            # deal with fact that start en stop is on same line\n                            my $data = $2;\n                            if ($data =~ s/\\<\\-?\\*?\\s*$//)\n                            {\n                                $width = CORE::length($data);\n                            }\n \n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_qseq',\n                                    'Data' => $data\n                                }\n                            );\n                            $count       = 0;\n                            $second_tier = 0;\n                        }\n                        elsif (/^(\\s+)(\\S+)\\<\\-\\*\\s*$/o) {    #end of domain\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_qseq',\n                                    'Data' => $2\n                                }\n                            );\n                            $width = CORE::length($2);\n                            $count = 0;\n                        }\n                        elsif (( $count != 1 && /^\\s+$/o )\n                            || CORE::length($_) == 0\n                            || /^\\s+\\-?\\*\\s*$/ )\n                        {\n                            next;\n                        }\n                        elsif ( $count == 0 ) {\n                            $prelength -= 3 unless ( $second_tier++ );\n                            unless ( defined $prelength ) {\n\n                                # $self->warn(\"prelength not set\");\n                                next;\n                            }\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_qseq',\n                                    'Data' => substr( $_, $prelength )\n                                }\n                            );\n                        }\n                        elsif ( $count == 1 ) {\n                            if ( !defined $prelength ) {\n                                $self->warn(\"prelength not set\");\n                            }\n                            if ($width) {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_midline',\n                                        'Data' =>\n                                          substr( $_, $prelength, $width )\n                                    }\n                                );\n                            }\n                            else {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_midline',\n                                        'Data' => substr( $_, $prelength )\n                                    }\n                                );\n                            }\n                        }\n                        elsif ( $count == 2 ) {\n                            if (/^\\s+(\\S+)\\s+(\\d+|\\-)\\s+(\\S*)\\s+(\\d+|\\-)/o) {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_hseq',\n                                        'Data' => $3\n                                    }\n                                );\n                            }\n                            else {\n                                $self->warn(\"unrecognized line: $_\\n\");\n                            }\n                        }\n                        $count = 0 if $count++ >= 2;\n                    }\n                }\n            }\n            elsif ( /^Histogram/o || m!^//!o ) {\n                while ( my $HSPinfo = shift @hspinfo ) {\n                    my $id   = shift @$HSPinfo;\n                    my $info = [ @{ $hitinfo[ $hitinfo{$id} ] } ];\n                    next unless defined $info;\n                    $self->start_element( { 'Name' => 'Hit' } );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_id',\n                            'Data' => shift @{$info}\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_desc',\n                            'Data' => shift @{$info}\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_signif',\n                            'Data' => shift @{$info}\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_score',\n                            'Data' => shift @{$info}\n                        }\n                    );\n                    $self->start_element( { 'Name' => 'Hsp' } );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_query-from',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_query-to',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_hit-from',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_hit-to',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_score',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_evalue',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_identity',\n                            'Data' => 0\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_positive',\n                            'Data' => 0\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_positive',\n                            'Data' => 0\n                        }\n                    );\n                    $self->end_element( { 'Name' => 'Hsp' } );\n                    $self->end_element( { 'Name' => 'Hit' } );\n                }\n                @hitinfo = ();\n                %hitinfo = ();\n                last;\n            }\n        }\n        elsif ( defined $self->{'_reporttype'}\n            && $self->{'_reporttype'} eq 'HMMPFAM' )\n        {\n            # process HMMPFAM results here\n            if (/^Scores for sequence family/o) {\n                while ( defined( $_ = $self->_readline ) ) {\n                    last if (/^\\s+$/);\n                    next if ( /^Model\\s+Description/o || /^\\-\\-\\-/o );\n                    chomp;\n                    my @line = split;\n                    my ( $model, $n, $evalue, $score ) =\n                      ( shift @line, pop @line, pop @line, pop @line );\n                    my $desc = join( ' ', @line );\n                    push @hitinfo, [ $model, $desc, $score, $evalue, $n ];\n                    $hitinfo{$model} = $#hitinfo;\n                }\n            }\n            elsif (/^Parsed for domains:/o) {\n                @hspinfo = ();\n                while ( defined( $_ = $self->_readline ) ) {\n                    last if (/^\\s+$/);\n                    if (m!^//!) {\n                        $self->_pushback($_);\n                        last;\n                    }\n                    next if ( /^Model\\s+Domain/o || /^\\-\\-\\-/o );\n                    chomp;\n                    if (\n                        my ( $n, $domainnum, $domainct, @vals ) = (\n                            m!^(\\S+)\\s+         # domain name\n                            (\\d+)/(\\d+)\\s+      # domain num out of num\n                            (\\d+)\\s+(\\d+).+?    # seq start, end\n                            (\\d+)\\s+(\\d+)\\s+    # hmm start, end\n                            \\S+\\s+              # []\n                            (\\S+)\\s+            # score       \n                            (\\S+)               # evalue\n                            \\s*$!ox\n                        )\n                      )\n                    {\n                        my $hindex = $hitinfo{$n};\n                        if ( !defined $hindex ) {\n                            push @hitinfo,\n                              [ $n, '', $vals[5], $vals[6], $domainct ];\n                            $hitinfo{$n} = $#hitinfo;\n                            $hindex = $#hitinfo;\n                        }\n                        my $info = $hitinfo[$hindex];\n                        if ( !defined $info ) {\n                            $self->warn(\n\"incomplete Domain information, can't find $n hitinfo says $hitinfo{$n}\"\n                            );\n                            next;\n                        }\n                        push @hspinfo, [ $n, @vals ];\n                    }\n                }\n            }\n            elsif (/^Alignments of top/o) {\n                my ( $prelength, $lastdomain, $count, $width );\n                $count = 0;\n                my $second_tier = 0;\n                while ( defined( $_ = $self->_readline ) ) {\n                    next\n                      if (\n                        /^Align/o\n                        || ( $count != 1\n                            && /^\\s+RF\\s+[x\\s]+$/o )\n                      );\n                    # fix for bug 2632\n                    next if ($_ =~ m/^\\s+CS\\s+/o && $count == 0);\n                    if ( /^Histogram/o || m!^//!o || /^Query sequence/o ) {\n                        if ( $self->in_element('hsp') ) {\n                            $self->end_element( { 'Name' => 'Hsp' } );\n                        }\n                        if ( $self->in_element('hit') ) {\n                            $self->end_element( { 'Name' => 'Hit' } );\n                        }\n                        $self->_pushback($_);\n                        last;\n                    }\n                    chomp;\n                    if (m/(\\S+):.*from\\s+(\\d+)\\s+to\\s+(\\d+)/o) {\n                        my ( $name, $from, $to ) = ( $1, $2, $3 );\n\n                        if ( $self->within_element('hit') ) {\n                            if ( $self->in_element('hsp') ) {\n                                $self->end_element( { 'Name' => 'Hsp' } );\n                            }\n                            $self->end_element( { 'Name' => 'Hit' } );\n                        }\n                        my $info = [ @{ $hitinfo[ $hitinfo{$name} ] } ];\n                        if ( !defined $info\n                            || $info->[0] ne $name )\n                        {\n                            $self->warn(\n\"Somehow the Model table order does not match the order in the domains (got \"\n                                  . $info->[0]\n                                  . \", expected $name). We're back loading this from the alignment information instead\"\n                            );\n                            $info = [\n                                $name, '',\n                                /score\\s+([^,\\s]+),\\s+E\\s+=\\s+(\\S+)/ox\n                            ];\n                            push @hitinfo, $info;\n                            $hitinfo{$name} = $#hitinfo;\n                        }\n                        $self->start_element( { 'Name' => 'Hit' } );\n\n                        $self->element(\n                            {\n                                'Name' => 'Hit_id',\n                                'Data' => shift @{$info}\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hit_desc',\n                                'Data' => shift @{$info}\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hit_score',\n                                'Data' => shift @{$info}\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hit_signif',\n                                'Data' => shift @{$info}\n                            }\n                        );\n\n                        $self->start_element( { 'Name' => 'Hsp' } );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_identity',\n                                'Data' => 0\n                            }\n                        );                     \n                        $self->element(\n                            {\n                                'Name' => 'Hsp_positive',\n                                'Data' => 0\n                            }\n                        );\n                        my $HSPinfo = shift @hspinfo;\n                        my $id      = shift @$HSPinfo;\n\n                        if ( $id ne $name ) {\n                            $self->throw(\n\"Somehow the domain list details do not match the table (got $id, expected $name)\"\n                            );\n                        }\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_query-from',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_query-to',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_hit-from',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_hit-to',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_score',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_evalue',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $lastdomain = $name;\n                    }\n                    else {\n                        if (/^(\\s+\\*\\-\\>)(\\S+)/o) {\n\n                            # start of domain\n                            $prelength = CORE::length($1);\n                            $width     = 0;\n\n                            # deal with fact that start en stop is on same line\n                            my $data = $2;\n                            if ($data =~ s/\\<\\-?\\*?\\s*$//)\n                            {\n                              $width = CORE::length($data);\n                            }\n \n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_hseq',\n                                    'Data' => $data\n                                }\n                            );\n                            $count       = 0;\n                            $second_tier = 0;\n\n                        }\n                        elsif (/^(\\s+)(\\S+)\\<\\-?\\*?\\s*$/o) {\n\n                            #end of domain\n                            $prelength -= 3 unless ( $second_tier++ );\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_hseq',\n                                    'Data' => $2\n                                }\n                            );\n                            $width = CORE::length($2);\n                            $count = 0;\n                        }\n                        elsif (CORE::length($_) == 0\n                            || ( $count != 1 && /^\\s+$/o )\n                            || /^\\s+\\-?\\*\\s*$/ )\n                        {\n                            next;\n                        }\n                        elsif ( $count == 0 ) {\n                            $prelength -= 3 unless ( $second_tier++ );\n                            unless ( defined $prelength ) {\n\n                                # $self->warn(\"prelength not set\");\n                                next;\n                            }\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_hseq',\n                                    'Data' => substr( $_, $prelength )\n                                }\n                            );\n                        }\n                        elsif ( $count == 1 ) {\n                            if ( !defined $prelength ) {\n                                $self->warn(\"prelength not set\");\n                            }\n                            if ($width) {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_midline',\n                                        'Data' =>\n                                          substr( $_, $prelength, $width )\n                                    }\n                                );\n                            }\n                            else {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_midline',\n                                        'Data' => substr( $_, $prelength )\n                                    }\n                                );\n                            }\n                        }\n                        elsif ( $count == 2 ) {\n                            if (   /^\\s+(\\S+)\\s+(\\d+)\\s+(\\S+)\\s+(\\d+)/o\n                                || /^\\s+(\\S+)\\s+(\\-)\\s+(\\S*)\\s+(\\-)/o )\n                            {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_qseq',\n                                        'Data' => $3\n                                    }\n                                );\n                            }\n                            else {\n                                $self->throw(\n                                    \"unrecognized line ($count): $_\\n\");\n                            }\n                        }\n                        $count = 0 if $count++ >= 2;\n                    }\n                }\n            }\n            elsif ( /^Histogram/o || m!^//!o ) {\n\n                while ( my $HSPinfo = shift @hspinfo ) {\n                    my $id   = shift @$HSPinfo;\n                    my $info = [ @{ $hitinfo[ $hitinfo{$id} ] } ];\n                    next unless defined $info;\n                    $self->start_element( { 'Name' => 'Hit' } );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_id',\n                            'Data' => shift @{$info}\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_desc',\n                            'Data' => shift @{$info}\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_signif',\n                            'Data' => shift @{$info}\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_score',\n                            'Data' => shift @{$info}\n                        }\n                    );\n                    $self->start_element( { 'Name' => 'Hsp' } );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_query-from',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );                    \n                    $self->element(\n                        {\n                            'Name' => 'Hsp_query-to',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_hit-from',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_hit-to',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_score',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_evalue',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_identity',\n                            'Data' => 0\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_positive',\n                            'Data' => 0\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_positive',\n                            'Data' => 0\n                        }\n                    );\n                    $self->end_element( { 'Name' => 'Hsp' } );\n                    $self->end_element( { 'Name' => 'Hit' } );\n                }\n                @hitinfo = ();\n                %hitinfo = ();\n                last;\n            }\n            # uncomment to see missed lines with verbose on\n            #else {\n            #    $self->debug($_);\n            #}\n        }\n        $last = $_;\n    }\n    $self->end_element( { 'Name' => 'HMMER_Output' } ) unless !$seentop;\n    return $self->end_document();\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element {\n    my ( $self, $data ) = @_;\n\n    # we currently don't care about attributes\n    my $nm   = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    if ($type) {\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = sprintf( \"start_%s\", lc $type );\n            $self->_eventHandler->$func( $data->{'Attributes'} );\n        }\n        unshift @{ $self->{'_elements'} }, $type;\n    }\n    if ( defined $type\n        && $type eq 'result' )\n    {\n        $self->{'_values'} = {};\n        $self->{'_result'} = undef;\n    }\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ( $self, $data ) = @_;\n    my $nm   = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    my $rc;\n\n    if ( $nm eq 'HMMER_program' ) {\n        if ( $self->{'_last_data'} =~ /(HMM\\S+)/i ) {\n            $self->{'_reporttype'} = uc $1;\n        }\n    }\n\n    # Hsp are sort of weird, in that they end when another\n    # object begins so have to detect this in end_element for now\n    if ( $nm eq 'Hsp' ) {\n        foreach (qw(Hsp_qseq Hsp_midline Hsp_hseq)) {\n            my $data = $self->{'_last_hspdata'}->{$_};\n            if ($data && $_ eq 'Hsp_hseq') {\n                # replace hmm '.' gap symbol by '-'\n                $data =~ s/\\./-/g;\n            }\n            $self->element(\n                {\n                    'Name' => $_,\n                    'Data' => $data\n                }\n            );\n        }\n        $self->{'_last_hspdata'} = {};\n    }\n    if ($type) {\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = sprintf( \"end_%s\", lc $type );\n            $rc = $self->_eventHandler->$func( $self->{'_reporttype'},\n                $self->{'_values'} );\n        }\n        my $lastelem = shift @{ $self->{'_elements'} };\n    }\n    elsif ( $MAPPING{$nm} ) {\n        if ( ref( $MAPPING{$nm} ) =~ /hash/i ) {\n            my $key = ( keys %{ $MAPPING{$nm} } )[0];\n            $self->{'_values'}->{$key}->{ $MAPPING{$nm}->{$key} } =\n              $self->{'_last_data'};\n        }\n        else {\n            $self->{'_values'}->{ $MAPPING{$nm} } = $self->{'_last_data'};\n        }\n    }\n    else {\n        $self->debug(\"unknown nm $nm, ignoring\\n\");\n    }\n    $self->{'_last_data'} = '';    # remove read data if we are at\n                                   # end of an element\n    $self->{'_result'} = $rc if ( defined $type && $type eq 'result' );\n    return $rc;\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'","label":"element($self,$data)"},"detail":"($self,$data)","definition":"sub","containerName":"main::","children":[{"localvar":"my","containerName":"element","definition":"my","name":"$self","line":1182,"kind":13},{"line":1182,"kind":13,"containerName":"element","name":"$data"},{"kind":13,"line":1183,"containerName":"element","name":"$self"},{"line":1183,"kind":12,"name":"start_element","containerName":"element"},{"kind":13,"line":1183,"containerName":"element","name":"$data"},{"kind":13,"line":1184,"containerName":"element","name":"$self"},{"kind":12,"line":1184,"name":"characters","containerName":"element"},{"kind":13,"line":1184,"containerName":"element","name":"$data"},{"kind":13,"line":1185,"name":"$self","containerName":"element"},{"name":"end_element","containerName":"element","line":1185,"kind":12},{"line":1185,"kind":13,"name":"$data","containerName":"element"}],"line":1181,"kind":12},{"name":"characters","range":{"start":{"character":0,"line":1199},"end":{"character":9999,"line":1211}},"kind":12,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"characters","line":1200,"kind":13},{"line":1200,"kind":13,"name":"$data","containerName":"characters"},{"containerName":"characters","name":"$self","line":1202,"kind":13},{"name":"in_element","containerName":"characters","kind":12,"line":1202},{"kind":13,"line":1203,"containerName":"characters","name":"$data"},{"kind":13,"line":1204,"name":"$data","containerName":"characters"},{"kind":13,"line":1206,"name":"$self","containerName":"characters"},{"kind":13,"line":1206,"containerName":"characters","name":"$data"},{"line":1206,"kind":13,"containerName":"characters","name":"$data"},{"containerName":"characters","name":"$data","line":1208,"kind":13},{"line":1208,"kind":13,"containerName":"characters","name":"$data"},{"containerName":"characters","name":"$self","kind":13,"line":1210},{"kind":13,"line":1210,"containerName":"characters","name":"$data"}],"line":1199,"definition":"sub","containerName":"main::","signature":{"label":"characters($self,$data)","parameters":[{"label":"$self"},{"label":"$data"}],"documentation":"1;\n# $Id: hmmer.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::hmmer\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::hmmer - A parser for HMMER output (hmmpfam, hmmsearch)\n\n=head1 SYNOPSIS\n\n    # do not use this class directly it is available through Bio::SearchIO\n    use Bio::SearchIO;\n    my $in = Bio::SearchIO->new(-format => 'hmmer',\n                               -file   => 't/data/L77119.hmmer');\n    while( my $result = $in->next_result ) {\n        # this is a Bio::Search::Result::HMMERResult object\n        print $result->query_name(), \" for HMM \", $result->hmm_name(), \"\\n\";\n        while( my $hit = $result->next_hit ) {\n            print $hit->name(), \"\\n\";\n            while( my $hsp = $hit->next_hsp ) {\n                print \"length is \", $hsp->length(), \"\\n\";\n            }\n        }\n    }\n\n=head1 DESCRIPTION\n\nThis object implements a parser for HMMER output.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::hmmer;\n\nuse strict;\n\nuse Bio::Factory::ObjectFactory;\n\nuse vars qw(%MAPPING %MODEMAP\n);\n\nuse base qw(Bio::SearchIO);\n\nBEGIN {\n\n    # mapping of HMMER items to Bioperl hash keys\n    %MODEMAP = (\n        'HMMER_Output' => 'result',\n        'Hit'          => 'hit',\n        'Hsp'          => 'hsp'\n    );\n\n    %MAPPING = (\n        'Hsp_bit-score'   => 'HSP-bits',\n        'Hsp_score'       => 'HSP-score',\n        'Hsp_evalue'      => 'HSP-evalue',\n        'Hsp_query-from'  => 'HSP-query_start',\n        'Hsp_query-to'    => 'HSP-query_end',\n        'Hsp_hit-from'    => 'HSP-hit_start',\n        'Hsp_hit-to'      => 'HSP-hit_end',\n        'Hsp_positive'    => 'HSP-conserved',\n        'Hsp_identity'    => 'HSP-identical',\n        'Hsp_gaps'        => 'HSP-hsp_gaps',\n        'Hsp_hitgaps'     => 'HSP-hit_gaps',\n        'Hsp_querygaps'   => 'HSP-query_gaps',\n        'Hsp_qseq'        => 'HSP-query_seq',\n        'Hsp_hseq'        => 'HSP-hit_seq',\n        'Hsp_midline'     => 'HSP-homology_seq',\n        'Hsp_align-len'   => 'HSP-hsp_length',\n        'Hsp_query-frame' => 'HSP-query_frame',\n        'Hsp_hit-frame'   => 'HSP-hit_frame',\n\n        'Hit_id'        => 'HIT-name',\n        'Hit_len'       => 'HIT-length',\n        'Hit_accession' => 'HIT-accession',\n        'Hit_desc'      => 'HIT-description',\n        'Hit_signif'    => 'HIT-significance',\n        'Hit_score'     => 'HIT-score',\n\n        'HMMER_program'   => 'RESULT-algorithm_name',\n        'HMMER_version'   => 'RESULT-algorithm_version',\n        'HMMER_query-def' => 'RESULT-query_name',\n        'HMMER_query-len' => 'RESULT-query_length',\n        'HMMER_query-acc' => 'RESULT-query_accession',\n        'HMMER_querydesc' => 'RESULT-query_description',\n        'HMMER_hmm'       => 'RESULT-hmm_name',\n        'HMMER_seqfile'   => 'RESULT-sequence_file',\n        'HMMER_db'        => 'RESULT-database_name',\n    );\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::hmmer->new();\n Function: Builds a new Bio::SearchIO::hmmer object \n Returns : Bio::SearchIO::hmmer\n Args    : -fh/-file => HMMER filename\n           -format   => 'hmmer'\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n    my $handler = $self->_eventHandler;\n    $handler->register_factory(\n        'result',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Result::HMMERResult',\n            -interface => 'Bio::Search::Result::ResultI'\n        )\n    );\n\n    $handler->register_factory(\n        'hit',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Hit::HMMERHit',\n            -interface => 'Bio::Search::Hit::HitI'\n        )\n    );\n\n    $handler->register_factory(\n        'hsp',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::HSP::HMMERHSP',\n            -interface => 'Bio::Search::HSP::HSPI'\n        )\n    );\n    $self->{'_hmmidline'} = 'HMMER 2.2g (August 2001)';\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    my $seentop = 0;\n    my $reporttype;\n    my ( $last, @hitinfo, @hspinfo, %hspinfo, %hitinfo );\n    local $/ = \"\\n\";\n    local $_;\n\n    my $verbose = $self->verbose;    # cache for speed?\n    $self->start_document();\n    local ($_);\n    while ( defined( $_ = $self->_readline ) ) {\n        my $lineorig = $_;\n        chomp;\n        if (/^HMMER\\s+(\\S+)\\s+\\((.+)\\)/o) {\n            my ( $prog, $version ) = split;\n            if ($seentop) {\n                $self->_pushback($_);\n                $self->end_element( { 'Name' => 'HMMER_Output' } );\n                return $self->end_document();\n            }\n            $self->{'_hmmidline'} = $_;\n            $self->start_element( { 'Name' => 'HMMER_Output' } );\n            $self->{'_result_count'}++;\n            $seentop = 1;\n            if ( defined $last ) {\n                ($reporttype) = split( /\\s+/, $last );\n                $self->element(\n                    {\n                        'Name' => 'HMMER_program',\n                        'Data' => uc($reporttype)\n                    }\n                );\n            }\n            $self->element(\n                {\n                    'Name' => 'HMMER_version',\n                    'Data' => $version\n                }\n            );\n        }\n        elsif (s/^HMM file:\\s+//o) {\n            $self->{'_hmmfileline'} = $lineorig;\n            $self->element(\n                {\n                    'Name' => 'HMMER_hmm',\n                    'Data' => $_\n                }\n            );\n        }\n        elsif (s/^Sequence\\s+(file|database):\\s+//o) {\n            $self->{'_hmmseqline'} = $lineorig;\n            if ( $1 eq 'database' ) {\n                $self->element(\n                    {\n                        'Name' => 'HMMER_db',\n                        'Data' => $_\n                    }\n                );\n            }\n            $self->element(\n                {\n                    'Name' => 'HMMER_seqfile',\n                    'Data' => $_\n                }\n            );\n        }\n        elsif (s/^Query(\\s+(sequence|HMM))?(?:\\s+\\d+)?:\\s+//o) {\n            if ( !$seentop ) {\n\n                # we're in a multi-query report\n                $self->_pushback( $self->{'_hmmidline'} );\n                $self->_pushback( $self->{'_hmmfileline'} );\n                $self->_pushback( $self->{'_hmmseqline'} );\n                $self->_pushback($lineorig);\n                next;\n            }\n            s/\\s+$//;\n            $self->element(\n                {\n                    'Name' => 'HMMER_query-def',\n                    'Data' => $_\n                }\n            );\n        }\n        elsif (s/^Accession:\\s+//o) {\n            s/\\s+$//;\n            $self->element(\n                {\n                    'Name' => 'HMMER_query-acc',\n                    'Data' => $_\n                }\n            );\n        }\n        elsif (s/^Description:\\s+//o) {\n            s/\\s+$//;\n            $self->element(\n                {\n                    'Name' => 'HMMER_querydesc',\n                    'Data' => $_\n                }\n            );\n        }\n        elsif ( defined $self->{'_reporttype'}\n            && $self->{'_reporttype'} eq 'HMMSEARCH' )\n        {\n\n            # PROCESS HMMSEARCH RESULTS HERE\n            if (/^Scores for complete sequences/o) {\n                while ( defined( $_ = $self->_readline ) ) {\n                    last if (/^\\s+$/);\n                    next if ( /^Sequence\\s+Description/o || /^\\-\\-\\-/o );\n                    my @line = split;\n                    my ( $name, $n, $evalue, $score ) =\n                      ( shift @line, pop @line, pop @line, pop @line );\n                    my $desc = join( ' ', @line );\n                    push @hitinfo, [ $name, $desc, $evalue, $score ];\n                    $hitinfo{$name} = $#hitinfo;\n                }\n            }\n            elsif (/^Parsed for domains:/o) {\n                @hspinfo = ();\n\n                while ( defined( $_ = $self->_readline ) ) {\n                    last if (/^\\s+$/);\n                    if (m!^//!) {\n                        $self->_pushback($_);\n                        last;\n                    }\n                    next if ( /^(Model|Sequence)\\s+Domain/ || /^\\-\\-\\-/ );\n\n                    chomp;\n                    if (\n                        my ( $n, $domainnum, $domainct, @vals ) = (\n                            m!^(\\S+)\\s+      # host name\n\t\t\t(\\d+)/(\\d+)\\s+   # num/num (ie 1 of 2) \n\t\t\t(\\d+)\\s+(\\d+).+? # sequence start and end\n\t\t\t(\\d+)\\s+(\\d+)\\s+ # hmm start and end\n\t\t\t\\S+\\s+           # []\n\t\t\t(\\S+)\\s+         # score\n\t\t\t(\\S+)            # evalue\n\t\t\t\\s*$!ox\n                        )\n                      )\n                    {\n\n                        # array lookup so that we can get rid of things\n                        # when they've been processed\n                        my $info = $hitinfo[ $hitinfo{$n} ];\n                        if ( !defined $info ) {\n                            $self->warn(\n\"Incomplete Sequence information, can't find $n hitinfo says $hitinfo{$n}\"\n                            );\n                            next;\n                        }\n                        push @hspinfo, [ $n, @vals ];\n                    }\n                }\n            }\n            elsif (/^Alignments of top/o) {\n                my ( $prelength, $lastdomain, $count, $width );\n                $count = 0;\n                my %domaincounter;\n                my $second_tier = 0;\n                while ( defined( $_ = $self->_readline ) ) {\n                    next if ( /^Align/o\n                        || /^\\s+RF\\s+[x\\s]+$/o );\n                    if ( /^Histogram/o || m!^//!o ) {\n                        if ( $self->in_element('hsp') ) {\n                            $self->end_element( { 'Name' => 'Hsp' } );\n                        }\n                        if ( $self->within_element('hit') ) {\n                            $self->end_element( { 'Name' => 'Hit' } );\n                        }\n                        last;\n                    }\n                    chomp;\n\n                    if (\n                        m/^\\s*(.+):\\s+domain\\s+(\\d+)\\s+of\\s+(\\d+)\\,\\s+\n                        from\\s+(\\d+)\\s+to\\s+(\\d+)/x\n                      )\n                    {\n                        my ( $name, $domainct, $domaintotal, $from, $to ) =\n                          ( $1, $2, $3, $4, $5 );\n                        $domaincounter{$name}++;\n                        if ( $self->within_element('hit') ) {\n                            if ( $self->within_element('hsp') ) {\n                                $self->end_element( { 'Name' => 'Hsp' } );\n                            }\n                            $self->end_element( { 'Name' => 'Hit' } );\n                        }\n\n                        $self->start_element( { 'Name' => 'Hit' } );\n                        my $info = [\n                            @{\n                                $hitinfo[ $hitinfo{$name} ] || $self->throw(\n\"Could not find hit info for $name: Insure that your database contains only unique sequence names\"\n                                )\n                              }\n                        ];\n                        if ( $info->[0] ne $name ) {\n                            $self->throw(\n\"Somehow the Model table order does not match the order in the domains (got \"\n                                  . $info->[0]\n                                  . \", expected $name)\" );\n                        }\n                        $self->element(\n                            {\n                                'Name' => 'Hit_id',\n                                'Data' => shift @{$info}\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hit_desc',\n                                'Data' => shift @{$info}\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hit_signif',\n                                'Data' => shift @{$info}\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hit_score',\n                                'Data' => shift @{$info}\n                            }\n                        );\n\n                        $self->start_element( { 'Name' => 'Hsp' } );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_identity',\n                                'Data' => 0\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_positive',\n                                'Data' => 0\n                            }\n                        );\n                        my $HSPinfo = shift @hspinfo;\n                        my $id      = shift @$HSPinfo;\n\n                        if ( $id ne $name ) {\n                            $self->throw(\n\"Somehow the domain list details do not match the table (got $id, expected $name)\"\n                            );\n                        }\n                        if ( $domaincounter{$name} == $domaintotal ) {\n                            $hitinfo[ $hitinfo{$name} ] = undef;\n                        }\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_hit-from',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_hit-to',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_query-from',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_query-to',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_score',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_evalue',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $lastdomain = $name;\n                    }\n                    else {\n\n                        # Might want to change this so that it\n                        # accumulates all the of the alignment lines into\n                        # three array slots and then tests for the\n                        # end of the line\n                        if (/^(\\s+\\*\\-\\>)(\\S+)/o) {    # start of domain\n                            $prelength = CORE::length($1);\n                            $width     = 0;\n\n                            # deal with fact that start en stop is on same line\n                            my $data = $2;\n                            if ($data =~ s/\\<\\-?\\*?\\s*$//)\n                            {\n                                $width = CORE::length($data);\n                            }\n \n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_qseq',\n                                    'Data' => $data\n                                }\n                            );\n                            $count       = 0;\n                            $second_tier = 0;\n                        }\n                        elsif (/^(\\s+)(\\S+)\\<\\-\\*\\s*$/o) {    #end of domain\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_qseq',\n                                    'Data' => $2\n                                }\n                            );\n                            $width = CORE::length($2);\n                            $count = 0;\n                        }\n                        elsif (( $count != 1 && /^\\s+$/o )\n                            || CORE::length($_) == 0\n                            || /^\\s+\\-?\\*\\s*$/ )\n                        {\n                            next;\n                        }\n                        elsif ( $count == 0 ) {\n                            $prelength -= 3 unless ( $second_tier++ );\n                            unless ( defined $prelength ) {\n\n                                # $self->warn(\"prelength not set\");\n                                next;\n                            }\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_qseq',\n                                    'Data' => substr( $_, $prelength )\n                                }\n                            );\n                        }\n                        elsif ( $count == 1 ) {\n                            if ( !defined $prelength ) {\n                                $self->warn(\"prelength not set\");\n                            }\n                            if ($width) {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_midline',\n                                        'Data' =>\n                                          substr( $_, $prelength, $width )\n                                    }\n                                );\n                            }\n                            else {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_midline',\n                                        'Data' => substr( $_, $prelength )\n                                    }\n                                );\n                            }\n                        }\n                        elsif ( $count == 2 ) {\n                            if (/^\\s+(\\S+)\\s+(\\d+|\\-)\\s+(\\S*)\\s+(\\d+|\\-)/o) {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_hseq',\n                                        'Data' => $3\n                                    }\n                                );\n                            }\n                            else {\n                                $self->warn(\"unrecognized line: $_\\n\");\n                            }\n                        }\n                        $count = 0 if $count++ >= 2;\n                    }\n                }\n            }\n            elsif ( /^Histogram/o || m!^//!o ) {\n                while ( my $HSPinfo = shift @hspinfo ) {\n                    my $id   = shift @$HSPinfo;\n                    my $info = [ @{ $hitinfo[ $hitinfo{$id} ] } ];\n                    next unless defined $info;\n                    $self->start_element( { 'Name' => 'Hit' } );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_id',\n                            'Data' => shift @{$info}\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_desc',\n                            'Data' => shift @{$info}\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_signif',\n                            'Data' => shift @{$info}\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_score',\n                            'Data' => shift @{$info}\n                        }\n                    );\n                    $self->start_element( { 'Name' => 'Hsp' } );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_query-from',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_query-to',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_hit-from',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_hit-to',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_score',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_evalue',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_identity',\n                            'Data' => 0\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_positive',\n                            'Data' => 0\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_positive',\n                            'Data' => 0\n                        }\n                    );\n                    $self->end_element( { 'Name' => 'Hsp' } );\n                    $self->end_element( { 'Name' => 'Hit' } );\n                }\n                @hitinfo = ();\n                %hitinfo = ();\n                last;\n            }\n        }\n        elsif ( defined $self->{'_reporttype'}\n            && $self->{'_reporttype'} eq 'HMMPFAM' )\n        {\n            # process HMMPFAM results here\n            if (/^Scores for sequence family/o) {\n                while ( defined( $_ = $self->_readline ) ) {\n                    last if (/^\\s+$/);\n                    next if ( /^Model\\s+Description/o || /^\\-\\-\\-/o );\n                    chomp;\n                    my @line = split;\n                    my ( $model, $n, $evalue, $score ) =\n                      ( shift @line, pop @line, pop @line, pop @line );\n                    my $desc = join( ' ', @line );\n                    push @hitinfo, [ $model, $desc, $score, $evalue, $n ];\n                    $hitinfo{$model} = $#hitinfo;\n                }\n            }\n            elsif (/^Parsed for domains:/o) {\n                @hspinfo = ();\n                while ( defined( $_ = $self->_readline ) ) {\n                    last if (/^\\s+$/);\n                    if (m!^//!) {\n                        $self->_pushback($_);\n                        last;\n                    }\n                    next if ( /^Model\\s+Domain/o || /^\\-\\-\\-/o );\n                    chomp;\n                    if (\n                        my ( $n, $domainnum, $domainct, @vals ) = (\n                            m!^(\\S+)\\s+         # domain name\n                            (\\d+)/(\\d+)\\s+      # domain num out of num\n                            (\\d+)\\s+(\\d+).+?    # seq start, end\n                            (\\d+)\\s+(\\d+)\\s+    # hmm start, end\n                            \\S+\\s+              # []\n                            (\\S+)\\s+            # score       \n                            (\\S+)               # evalue\n                            \\s*$!ox\n                        )\n                      )\n                    {\n                        my $hindex = $hitinfo{$n};\n                        if ( !defined $hindex ) {\n                            push @hitinfo,\n                              [ $n, '', $vals[5], $vals[6], $domainct ];\n                            $hitinfo{$n} = $#hitinfo;\n                            $hindex = $#hitinfo;\n                        }\n                        my $info = $hitinfo[$hindex];\n                        if ( !defined $info ) {\n                            $self->warn(\n\"incomplete Domain information, can't find $n hitinfo says $hitinfo{$n}\"\n                            );\n                            next;\n                        }\n                        push @hspinfo, [ $n, @vals ];\n                    }\n                }\n            }\n            elsif (/^Alignments of top/o) {\n                my ( $prelength, $lastdomain, $count, $width );\n                $count = 0;\n                my $second_tier = 0;\n                while ( defined( $_ = $self->_readline ) ) {\n                    next\n                      if (\n                        /^Align/o\n                        || ( $count != 1\n                            && /^\\s+RF\\s+[x\\s]+$/o )\n                      );\n                    # fix for bug 2632\n                    next if ($_ =~ m/^\\s+CS\\s+/o && $count == 0);\n                    if ( /^Histogram/o || m!^//!o || /^Query sequence/o ) {\n                        if ( $self->in_element('hsp') ) {\n                            $self->end_element( { 'Name' => 'Hsp' } );\n                        }\n                        if ( $self->in_element('hit') ) {\n                            $self->end_element( { 'Name' => 'Hit' } );\n                        }\n                        $self->_pushback($_);\n                        last;\n                    }\n                    chomp;\n                    if (m/(\\S+):.*from\\s+(\\d+)\\s+to\\s+(\\d+)/o) {\n                        my ( $name, $from, $to ) = ( $1, $2, $3 );\n\n                        if ( $self->within_element('hit') ) {\n                            if ( $self->in_element('hsp') ) {\n                                $self->end_element( { 'Name' => 'Hsp' } );\n                            }\n                            $self->end_element( { 'Name' => 'Hit' } );\n                        }\n                        my $info = [ @{ $hitinfo[ $hitinfo{$name} ] } ];\n                        if ( !defined $info\n                            || $info->[0] ne $name )\n                        {\n                            $self->warn(\n\"Somehow the Model table order does not match the order in the domains (got \"\n                                  . $info->[0]\n                                  . \", expected $name). We're back loading this from the alignment information instead\"\n                            );\n                            $info = [\n                                $name, '',\n                                /score\\s+([^,\\s]+),\\s+E\\s+=\\s+(\\S+)/ox\n                            ];\n                            push @hitinfo, $info;\n                            $hitinfo{$name} = $#hitinfo;\n                        }\n                        $self->start_element( { 'Name' => 'Hit' } );\n\n                        $self->element(\n                            {\n                                'Name' => 'Hit_id',\n                                'Data' => shift @{$info}\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hit_desc',\n                                'Data' => shift @{$info}\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hit_score',\n                                'Data' => shift @{$info}\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hit_signif',\n                                'Data' => shift @{$info}\n                            }\n                        );\n\n                        $self->start_element( { 'Name' => 'Hsp' } );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_identity',\n                                'Data' => 0\n                            }\n                        );                     \n                        $self->element(\n                            {\n                                'Name' => 'Hsp_positive',\n                                'Data' => 0\n                            }\n                        );\n                        my $HSPinfo = shift @hspinfo;\n                        my $id      = shift @$HSPinfo;\n\n                        if ( $id ne $name ) {\n                            $self->throw(\n\"Somehow the domain list details do not match the table (got $id, expected $name)\"\n                            );\n                        }\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_query-from',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_query-to',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_hit-from',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_hit-to',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_score',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_evalue',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $lastdomain = $name;\n                    }\n                    else {\n                        if (/^(\\s+\\*\\-\\>)(\\S+)/o) {\n\n                            # start of domain\n                            $prelength = CORE::length($1);\n                            $width     = 0;\n\n                            # deal with fact that start en stop is on same line\n                            my $data = $2;\n                            if ($data =~ s/\\<\\-?\\*?\\s*$//)\n                            {\n                              $width = CORE::length($data);\n                            }\n \n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_hseq',\n                                    'Data' => $data\n                                }\n                            );\n                            $count       = 0;\n                            $second_tier = 0;\n\n                        }\n                        elsif (/^(\\s+)(\\S+)\\<\\-?\\*?\\s*$/o) {\n\n                            #end of domain\n                            $prelength -= 3 unless ( $second_tier++ );\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_hseq',\n                                    'Data' => $2\n                                }\n                            );\n                            $width = CORE::length($2);\n                            $count = 0;\n                        }\n                        elsif (CORE::length($_) == 0\n                            || ( $count != 1 && /^\\s+$/o )\n                            || /^\\s+\\-?\\*\\s*$/ )\n                        {\n                            next;\n                        }\n                        elsif ( $count == 0 ) {\n                            $prelength -= 3 unless ( $second_tier++ );\n                            unless ( defined $prelength ) {\n\n                                # $self->warn(\"prelength not set\");\n                                next;\n                            }\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_hseq',\n                                    'Data' => substr( $_, $prelength )\n                                }\n                            );\n                        }\n                        elsif ( $count == 1 ) {\n                            if ( !defined $prelength ) {\n                                $self->warn(\"prelength not set\");\n                            }\n                            if ($width) {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_midline',\n                                        'Data' =>\n                                          substr( $_, $prelength, $width )\n                                    }\n                                );\n                            }\n                            else {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_midline',\n                                        'Data' => substr( $_, $prelength )\n                                    }\n                                );\n                            }\n                        }\n                        elsif ( $count == 2 ) {\n                            if (   /^\\s+(\\S+)\\s+(\\d+)\\s+(\\S+)\\s+(\\d+)/o\n                                || /^\\s+(\\S+)\\s+(\\-)\\s+(\\S*)\\s+(\\-)/o )\n                            {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_qseq',\n                                        'Data' => $3\n                                    }\n                                );\n                            }\n                            else {\n                                $self->throw(\n                                    \"unrecognized line ($count): $_\\n\");\n                            }\n                        }\n                        $count = 0 if $count++ >= 2;\n                    }\n                }\n            }\n            elsif ( /^Histogram/o || m!^//!o ) {\n\n                while ( my $HSPinfo = shift @hspinfo ) {\n                    my $id   = shift @$HSPinfo;\n                    my $info = [ @{ $hitinfo[ $hitinfo{$id} ] } ];\n                    next unless defined $info;\n                    $self->start_element( { 'Name' => 'Hit' } );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_id',\n                            'Data' => shift @{$info}\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_desc',\n                            'Data' => shift @{$info}\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_signif',\n                            'Data' => shift @{$info}\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_score',\n                            'Data' => shift @{$info}\n                        }\n                    );\n                    $self->start_element( { 'Name' => 'Hsp' } );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_query-from',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );                    \n                    $self->element(\n                        {\n                            'Name' => 'Hsp_query-to',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_hit-from',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_hit-to',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_score',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_evalue',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_identity',\n                            'Data' => 0\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_positive',\n                            'Data' => 0\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_positive',\n                            'Data' => 0\n                        }\n                    );\n                    $self->end_element( { 'Name' => 'Hsp' } );\n                    $self->end_element( { 'Name' => 'Hit' } );\n                }\n                @hitinfo = ();\n                %hitinfo = ();\n                last;\n            }\n            # uncomment to see missed lines with verbose on\n            #else {\n            #    $self->debug($_);\n            #}\n        }\n        $last = $_;\n    }\n    $self->end_element( { 'Name' => 'HMMER_Output' } ) unless !$seentop;\n    return $self->end_document();\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element {\n    my ( $self, $data ) = @_;\n\n    # we currently don't care about attributes\n    my $nm   = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    if ($type) {\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = sprintf( \"start_%s\", lc $type );\n            $self->_eventHandler->$func( $data->{'Attributes'} );\n        }\n        unshift @{ $self->{'_elements'} }, $type;\n    }\n    if ( defined $type\n        && $type eq 'result' )\n    {\n        $self->{'_values'} = {};\n        $self->{'_result'} = undef;\n    }\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ( $self, $data ) = @_;\n    my $nm   = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    my $rc;\n\n    if ( $nm eq 'HMMER_program' ) {\n        if ( $self->{'_last_data'} =~ /(HMM\\S+)/i ) {\n            $self->{'_reporttype'} = uc $1;\n        }\n    }\n\n    # Hsp are sort of weird, in that they end when another\n    # object begins so have to detect this in end_element for now\n    if ( $nm eq 'Hsp' ) {\n        foreach (qw(Hsp_qseq Hsp_midline Hsp_hseq)) {\n            my $data = $self->{'_last_hspdata'}->{$_};\n            if ($data && $_ eq 'Hsp_hseq') {\n                # replace hmm '.' gap symbol by '-'\n                $data =~ s/\\./-/g;\n            }\n            $self->element(\n                {\n                    'Name' => $_,\n                    'Data' => $data\n                }\n            );\n        }\n        $self->{'_last_hspdata'} = {};\n    }\n    if ($type) {\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = sprintf( \"end_%s\", lc $type );\n            $rc = $self->_eventHandler->$func( $self->{'_reporttype'},\n                $self->{'_values'} );\n        }\n        my $lastelem = shift @{ $self->{'_elements'} };\n    }\n    elsif ( $MAPPING{$nm} ) {\n        if ( ref( $MAPPING{$nm} ) =~ /hash/i ) {\n            my $key = ( keys %{ $MAPPING{$nm} } )[0];\n            $self->{'_values'}->{$key}->{ $MAPPING{$nm}->{$key} } =\n              $self->{'_last_data'};\n        }\n        else {\n            $self->{'_values'}->{ $MAPPING{$nm} } = $self->{'_last_data'};\n        }\n    }\n    else {\n        $self->debug(\"unknown nm $nm, ignoring\\n\");\n    }\n    $self->{'_last_data'} = '';    # remove read data if we are at\n                                   # end of an element\n    $self->{'_result'} = $rc if ( defined $type && $type eq 'result' );\n    return $rc;\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element {\n    my ( $self, $data ) = @_;\n    $self->start_element($data);\n    $self->characters($data);\n    $self->end_element($data);\n}\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string"},"detail":"($self,$data)"},{"name":"within_element","range":{"end":{"line":1231,"character":9999},"start":{"line":1226,"character":0}},"definition":"sub","containerName":"main::","signature":{"label":"within_element($self,$name)","parameters":[{"label":"$self"},{"label":"$name"}],"documentation":"1;\n# $Id: hmmer.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::hmmer\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::hmmer - A parser for HMMER output (hmmpfam, hmmsearch)\n\n=head1 SYNOPSIS\n\n    # do not use this class directly it is available through Bio::SearchIO\n    use Bio::SearchIO;\n    my $in = Bio::SearchIO->new(-format => 'hmmer',\n                               -file   => 't/data/L77119.hmmer');\n    while( my $result = $in->next_result ) {\n        # this is a Bio::Search::Result::HMMERResult object\n        print $result->query_name(), \" for HMM \", $result->hmm_name(), \"\\n\";\n        while( my $hit = $result->next_hit ) {\n            print $hit->name(), \"\\n\";\n            while( my $hsp = $hit->next_hsp ) {\n                print \"length is \", $hsp->length(), \"\\n\";\n            }\n        }\n    }\n\n=head1 DESCRIPTION\n\nThis object implements a parser for HMMER output.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::hmmer;\n\nuse strict;\n\nuse Bio::Factory::ObjectFactory;\n\nuse vars qw(%MAPPING %MODEMAP\n);\n\nuse base qw(Bio::SearchIO);\n\nBEGIN {\n\n    # mapping of HMMER items to Bioperl hash keys\n    %MODEMAP = (\n        'HMMER_Output' => 'result',\n        'Hit'          => 'hit',\n        'Hsp'          => 'hsp'\n    );\n\n    %MAPPING = (\n        'Hsp_bit-score'   => 'HSP-bits',\n        'Hsp_score'       => 'HSP-score',\n        'Hsp_evalue'      => 'HSP-evalue',\n        'Hsp_query-from'  => 'HSP-query_start',\n        'Hsp_query-to'    => 'HSP-query_end',\n        'Hsp_hit-from'    => 'HSP-hit_start',\n        'Hsp_hit-to'      => 'HSP-hit_end',\n        'Hsp_positive'    => 'HSP-conserved',\n        'Hsp_identity'    => 'HSP-identical',\n        'Hsp_gaps'        => 'HSP-hsp_gaps',\n        'Hsp_hitgaps'     => 'HSP-hit_gaps',\n        'Hsp_querygaps'   => 'HSP-query_gaps',\n        'Hsp_qseq'        => 'HSP-query_seq',\n        'Hsp_hseq'        => 'HSP-hit_seq',\n        'Hsp_midline'     => 'HSP-homology_seq',\n        'Hsp_align-len'   => 'HSP-hsp_length',\n        'Hsp_query-frame' => 'HSP-query_frame',\n        'Hsp_hit-frame'   => 'HSP-hit_frame',\n\n        'Hit_id'        => 'HIT-name',\n        'Hit_len'       => 'HIT-length',\n        'Hit_accession' => 'HIT-accession',\n        'Hit_desc'      => 'HIT-description',\n        'Hit_signif'    => 'HIT-significance',\n        'Hit_score'     => 'HIT-score',\n\n        'HMMER_program'   => 'RESULT-algorithm_name',\n        'HMMER_version'   => 'RESULT-algorithm_version',\n        'HMMER_query-def' => 'RESULT-query_name',\n        'HMMER_query-len' => 'RESULT-query_length',\n        'HMMER_query-acc' => 'RESULT-query_accession',\n        'HMMER_querydesc' => 'RESULT-query_description',\n        'HMMER_hmm'       => 'RESULT-hmm_name',\n        'HMMER_seqfile'   => 'RESULT-sequence_file',\n        'HMMER_db'        => 'RESULT-database_name',\n    );\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::hmmer->new();\n Function: Builds a new Bio::SearchIO::hmmer object \n Returns : Bio::SearchIO::hmmer\n Args    : -fh/-file => HMMER filename\n           -format   => 'hmmer'\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n    my $handler = $self->_eventHandler;\n    $handler->register_factory(\n        'result',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Result::HMMERResult',\n            -interface => 'Bio::Search::Result::ResultI'\n        )\n    );\n\n    $handler->register_factory(\n        'hit',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Hit::HMMERHit',\n            -interface => 'Bio::Search::Hit::HitI'\n        )\n    );\n\n    $handler->register_factory(\n        'hsp',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::HSP::HMMERHSP',\n            -interface => 'Bio::Search::HSP::HSPI'\n        )\n    );\n    $self->{'_hmmidline'} = 'HMMER 2.2g (August 2001)';\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    my $seentop = 0;\n    my $reporttype;\n    my ( $last, @hitinfo, @hspinfo, %hspinfo, %hitinfo );\n    local $/ = \"\\n\";\n    local $_;\n\n    my $verbose = $self->verbose;    # cache for speed?\n    $self->start_document();\n    local ($_);\n    while ( defined( $_ = $self->_readline ) ) {\n        my $lineorig = $_;\n        chomp;\n        if (/^HMMER\\s+(\\S+)\\s+\\((.+)\\)/o) {\n            my ( $prog, $version ) = split;\n            if ($seentop) {\n                $self->_pushback($_);\n                $self->end_element( { 'Name' => 'HMMER_Output' } );\n                return $self->end_document();\n            }\n            $self->{'_hmmidline'} = $_;\n            $self->start_element( { 'Name' => 'HMMER_Output' } );\n            $self->{'_result_count'}++;\n            $seentop = 1;\n            if ( defined $last ) {\n                ($reporttype) = split( /\\s+/, $last );\n                $self->element(\n                    {\n                        'Name' => 'HMMER_program',\n                        'Data' => uc($reporttype)\n                    }\n                );\n            }\n            $self->element(\n                {\n                    'Name' => 'HMMER_version',\n                    'Data' => $version\n                }\n            );\n        }\n        elsif (s/^HMM file:\\s+//o) {\n            $self->{'_hmmfileline'} = $lineorig;\n            $self->element(\n                {\n                    'Name' => 'HMMER_hmm',\n                    'Data' => $_\n                }\n            );\n        }\n        elsif (s/^Sequence\\s+(file|database):\\s+//o) {\n            $self->{'_hmmseqline'} = $lineorig;\n            if ( $1 eq 'database' ) {\n                $self->element(\n                    {\n                        'Name' => 'HMMER_db',\n                        'Data' => $_\n                    }\n                );\n            }\n            $self->element(\n                {\n                    'Name' => 'HMMER_seqfile',\n                    'Data' => $_\n                }\n            );\n        }\n        elsif (s/^Query(\\s+(sequence|HMM))?(?:\\s+\\d+)?:\\s+//o) {\n            if ( !$seentop ) {\n\n                # we're in a multi-query report\n                $self->_pushback( $self->{'_hmmidline'} );\n                $self->_pushback( $self->{'_hmmfileline'} );\n                $self->_pushback( $self->{'_hmmseqline'} );\n                $self->_pushback($lineorig);\n                next;\n            }\n            s/\\s+$//;\n            $self->element(\n                {\n                    'Name' => 'HMMER_query-def',\n                    'Data' => $_\n                }\n            );\n        }\n        elsif (s/^Accession:\\s+//o) {\n            s/\\s+$//;\n            $self->element(\n                {\n                    'Name' => 'HMMER_query-acc',\n                    'Data' => $_\n                }\n            );\n        }\n        elsif (s/^Description:\\s+//o) {\n            s/\\s+$//;\n            $self->element(\n                {\n                    'Name' => 'HMMER_querydesc',\n                    'Data' => $_\n                }\n            );\n        }\n        elsif ( defined $self->{'_reporttype'}\n            && $self->{'_reporttype'} eq 'HMMSEARCH' )\n        {\n\n            # PROCESS HMMSEARCH RESULTS HERE\n            if (/^Scores for complete sequences/o) {\n                while ( defined( $_ = $self->_readline ) ) {\n                    last if (/^\\s+$/);\n                    next if ( /^Sequence\\s+Description/o || /^\\-\\-\\-/o );\n                    my @line = split;\n                    my ( $name, $n, $evalue, $score ) =\n                      ( shift @line, pop @line, pop @line, pop @line );\n                    my $desc = join( ' ', @line );\n                    push @hitinfo, [ $name, $desc, $evalue, $score ];\n                    $hitinfo{$name} = $#hitinfo;\n                }\n            }\n            elsif (/^Parsed for domains:/o) {\n                @hspinfo = ();\n\n                while ( defined( $_ = $self->_readline ) ) {\n                    last if (/^\\s+$/);\n                    if (m!^//!) {\n                        $self->_pushback($_);\n                        last;\n                    }\n                    next if ( /^(Model|Sequence)\\s+Domain/ || /^\\-\\-\\-/ );\n\n                    chomp;\n                    if (\n                        my ( $n, $domainnum, $domainct, @vals ) = (\n                            m!^(\\S+)\\s+      # host name\n\t\t\t(\\d+)/(\\d+)\\s+   # num/num (ie 1 of 2) \n\t\t\t(\\d+)\\s+(\\d+).+? # sequence start and end\n\t\t\t(\\d+)\\s+(\\d+)\\s+ # hmm start and end\n\t\t\t\\S+\\s+           # []\n\t\t\t(\\S+)\\s+         # score\n\t\t\t(\\S+)            # evalue\n\t\t\t\\s*$!ox\n                        )\n                      )\n                    {\n\n                        # array lookup so that we can get rid of things\n                        # when they've been processed\n                        my $info = $hitinfo[ $hitinfo{$n} ];\n                        if ( !defined $info ) {\n                            $self->warn(\n\"Incomplete Sequence information, can't find $n hitinfo says $hitinfo{$n}\"\n                            );\n                            next;\n                        }\n                        push @hspinfo, [ $n, @vals ];\n                    }\n                }\n            }\n            elsif (/^Alignments of top/o) {\n                my ( $prelength, $lastdomain, $count, $width );\n                $count = 0;\n                my %domaincounter;\n                my $second_tier = 0;\n                while ( defined( $_ = $self->_readline ) ) {\n                    next if ( /^Align/o\n                        || /^\\s+RF\\s+[x\\s]+$/o );\n                    if ( /^Histogram/o || m!^//!o ) {\n                        if ( $self->in_element('hsp') ) {\n                            $self->end_element( { 'Name' => 'Hsp' } );\n                        }\n                        if ( $self->within_element('hit') ) {\n                            $self->end_element( { 'Name' => 'Hit' } );\n                        }\n                        last;\n                    }\n                    chomp;\n\n                    if (\n                        m/^\\s*(.+):\\s+domain\\s+(\\d+)\\s+of\\s+(\\d+)\\,\\s+\n                        from\\s+(\\d+)\\s+to\\s+(\\d+)/x\n                      )\n                    {\n                        my ( $name, $domainct, $domaintotal, $from, $to ) =\n                          ( $1, $2, $3, $4, $5 );\n                        $domaincounter{$name}++;\n                        if ( $self->within_element('hit') ) {\n                            if ( $self->within_element('hsp') ) {\n                                $self->end_element( { 'Name' => 'Hsp' } );\n                            }\n                            $self->end_element( { 'Name' => 'Hit' } );\n                        }\n\n                        $self->start_element( { 'Name' => 'Hit' } );\n                        my $info = [\n                            @{\n                                $hitinfo[ $hitinfo{$name} ] || $self->throw(\n\"Could not find hit info for $name: Insure that your database contains only unique sequence names\"\n                                )\n                              }\n                        ];\n                        if ( $info->[0] ne $name ) {\n                            $self->throw(\n\"Somehow the Model table order does not match the order in the domains (got \"\n                                  . $info->[0]\n                                  . \", expected $name)\" );\n                        }\n                        $self->element(\n                            {\n                                'Name' => 'Hit_id',\n                                'Data' => shift @{$info}\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hit_desc',\n                                'Data' => shift @{$info}\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hit_signif',\n                                'Data' => shift @{$info}\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hit_score',\n                                'Data' => shift @{$info}\n                            }\n                        );\n\n                        $self->start_element( { 'Name' => 'Hsp' } );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_identity',\n                                'Data' => 0\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_positive',\n                                'Data' => 0\n                            }\n                        );\n                        my $HSPinfo = shift @hspinfo;\n                        my $id      = shift @$HSPinfo;\n\n                        if ( $id ne $name ) {\n                            $self->throw(\n\"Somehow the domain list details do not match the table (got $id, expected $name)\"\n                            );\n                        }\n                        if ( $domaincounter{$name} == $domaintotal ) {\n                            $hitinfo[ $hitinfo{$name} ] = undef;\n                        }\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_hit-from',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_hit-to',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_query-from',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_query-to',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_score',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_evalue',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $lastdomain = $name;\n                    }\n                    else {\n\n                        # Might want to change this so that it\n                        # accumulates all the of the alignment lines into\n                        # three array slots and then tests for the\n                        # end of the line\n                        if (/^(\\s+\\*\\-\\>)(\\S+)/o) {    # start of domain\n                            $prelength = CORE::length($1);\n                            $width     = 0;\n\n                            # deal with fact that start en stop is on same line\n                            my $data = $2;\n                            if ($data =~ s/\\<\\-?\\*?\\s*$//)\n                            {\n                                $width = CORE::length($data);\n                            }\n \n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_qseq',\n                                    'Data' => $data\n                                }\n                            );\n                            $count       = 0;\n                            $second_tier = 0;\n                        }\n                        elsif (/^(\\s+)(\\S+)\\<\\-\\*\\s*$/o) {    #end of domain\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_qseq',\n                                    'Data' => $2\n                                }\n                            );\n                            $width = CORE::length($2);\n                            $count = 0;\n                        }\n                        elsif (( $count != 1 && /^\\s+$/o )\n                            || CORE::length($_) == 0\n                            || /^\\s+\\-?\\*\\s*$/ )\n                        {\n                            next;\n                        }\n                        elsif ( $count == 0 ) {\n                            $prelength -= 3 unless ( $second_tier++ );\n                            unless ( defined $prelength ) {\n\n                                # $self->warn(\"prelength not set\");\n                                next;\n                            }\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_qseq',\n                                    'Data' => substr( $_, $prelength )\n                                }\n                            );\n                        }\n                        elsif ( $count == 1 ) {\n                            if ( !defined $prelength ) {\n                                $self->warn(\"prelength not set\");\n                            }\n                            if ($width) {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_midline',\n                                        'Data' =>\n                                          substr( $_, $prelength, $width )\n                                    }\n                                );\n                            }\n                            else {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_midline',\n                                        'Data' => substr( $_, $prelength )\n                                    }\n                                );\n                            }\n                        }\n                        elsif ( $count == 2 ) {\n                            if (/^\\s+(\\S+)\\s+(\\d+|\\-)\\s+(\\S*)\\s+(\\d+|\\-)/o) {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_hseq',\n                                        'Data' => $3\n                                    }\n                                );\n                            }\n                            else {\n                                $self->warn(\"unrecognized line: $_\\n\");\n                            }\n                        }\n                        $count = 0 if $count++ >= 2;\n                    }\n                }\n            }\n            elsif ( /^Histogram/o || m!^//!o ) {\n                while ( my $HSPinfo = shift @hspinfo ) {\n                    my $id   = shift @$HSPinfo;\n                    my $info = [ @{ $hitinfo[ $hitinfo{$id} ] } ];\n                    next unless defined $info;\n                    $self->start_element( { 'Name' => 'Hit' } );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_id',\n                            'Data' => shift @{$info}\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_desc',\n                            'Data' => shift @{$info}\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_signif',\n                            'Data' => shift @{$info}\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_score',\n                            'Data' => shift @{$info}\n                        }\n                    );\n                    $self->start_element( { 'Name' => 'Hsp' } );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_query-from',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_query-to',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_hit-from',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_hit-to',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_score',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_evalue',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_identity',\n                            'Data' => 0\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_positive',\n                            'Data' => 0\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_positive',\n                            'Data' => 0\n                        }\n                    );\n                    $self->end_element( { 'Name' => 'Hsp' } );\n                    $self->end_element( { 'Name' => 'Hit' } );\n                }\n                @hitinfo = ();\n                %hitinfo = ();\n                last;\n            }\n        }\n        elsif ( defined $self->{'_reporttype'}\n            && $self->{'_reporttype'} eq 'HMMPFAM' )\n        {\n            # process HMMPFAM results here\n            if (/^Scores for sequence family/o) {\n                while ( defined( $_ = $self->_readline ) ) {\n                    last if (/^\\s+$/);\n                    next if ( /^Model\\s+Description/o || /^\\-\\-\\-/o );\n                    chomp;\n                    my @line = split;\n                    my ( $model, $n, $evalue, $score ) =\n                      ( shift @line, pop @line, pop @line, pop @line );\n                    my $desc = join( ' ', @line );\n                    push @hitinfo, [ $model, $desc, $score, $evalue, $n ];\n                    $hitinfo{$model} = $#hitinfo;\n                }\n            }\n            elsif (/^Parsed for domains:/o) {\n                @hspinfo = ();\n                while ( defined( $_ = $self->_readline ) ) {\n                    last if (/^\\s+$/);\n                    if (m!^//!) {\n                        $self->_pushback($_);\n                        last;\n                    }\n                    next if ( /^Model\\s+Domain/o || /^\\-\\-\\-/o );\n                    chomp;\n                    if (\n                        my ( $n, $domainnum, $domainct, @vals ) = (\n                            m!^(\\S+)\\s+         # domain name\n                            (\\d+)/(\\d+)\\s+      # domain num out of num\n                            (\\d+)\\s+(\\d+).+?    # seq start, end\n                            (\\d+)\\s+(\\d+)\\s+    # hmm start, end\n                            \\S+\\s+              # []\n                            (\\S+)\\s+            # score       \n                            (\\S+)               # evalue\n                            \\s*$!ox\n                        )\n                      )\n                    {\n                        my $hindex = $hitinfo{$n};\n                        if ( !defined $hindex ) {\n                            push @hitinfo,\n                              [ $n, '', $vals[5], $vals[6], $domainct ];\n                            $hitinfo{$n} = $#hitinfo;\n                            $hindex = $#hitinfo;\n                        }\n                        my $info = $hitinfo[$hindex];\n                        if ( !defined $info ) {\n                            $self->warn(\n\"incomplete Domain information, can't find $n hitinfo says $hitinfo{$n}\"\n                            );\n                            next;\n                        }\n                        push @hspinfo, [ $n, @vals ];\n                    }\n                }\n            }\n            elsif (/^Alignments of top/o) {\n                my ( $prelength, $lastdomain, $count, $width );\n                $count = 0;\n                my $second_tier = 0;\n                while ( defined( $_ = $self->_readline ) ) {\n                    next\n                      if (\n                        /^Align/o\n                        || ( $count != 1\n                            && /^\\s+RF\\s+[x\\s]+$/o )\n                      );\n                    # fix for bug 2632\n                    next if ($_ =~ m/^\\s+CS\\s+/o && $count == 0);\n                    if ( /^Histogram/o || m!^//!o || /^Query sequence/o ) {\n                        if ( $self->in_element('hsp') ) {\n                            $self->end_element( { 'Name' => 'Hsp' } );\n                        }\n                        if ( $self->in_element('hit') ) {\n                            $self->end_element( { 'Name' => 'Hit' } );\n                        }\n                        $self->_pushback($_);\n                        last;\n                    }\n                    chomp;\n                    if (m/(\\S+):.*from\\s+(\\d+)\\s+to\\s+(\\d+)/o) {\n                        my ( $name, $from, $to ) = ( $1, $2, $3 );\n\n                        if ( $self->within_element('hit') ) {\n                            if ( $self->in_element('hsp') ) {\n                                $self->end_element( { 'Name' => 'Hsp' } );\n                            }\n                            $self->end_element( { 'Name' => 'Hit' } );\n                        }\n                        my $info = [ @{ $hitinfo[ $hitinfo{$name} ] } ];\n                        if ( !defined $info\n                            || $info->[0] ne $name )\n                        {\n                            $self->warn(\n\"Somehow the Model table order does not match the order in the domains (got \"\n                                  . $info->[0]\n                                  . \", expected $name). We're back loading this from the alignment information instead\"\n                            );\n                            $info = [\n                                $name, '',\n                                /score\\s+([^,\\s]+),\\s+E\\s+=\\s+(\\S+)/ox\n                            ];\n                            push @hitinfo, $info;\n                            $hitinfo{$name} = $#hitinfo;\n                        }\n                        $self->start_element( { 'Name' => 'Hit' } );\n\n                        $self->element(\n                            {\n                                'Name' => 'Hit_id',\n                                'Data' => shift @{$info}\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hit_desc',\n                                'Data' => shift @{$info}\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hit_score',\n                                'Data' => shift @{$info}\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hit_signif',\n                                'Data' => shift @{$info}\n                            }\n                        );\n\n                        $self->start_element( { 'Name' => 'Hsp' } );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_identity',\n                                'Data' => 0\n                            }\n                        );                     \n                        $self->element(\n                            {\n                                'Name' => 'Hsp_positive',\n                                'Data' => 0\n                            }\n                        );\n                        my $HSPinfo = shift @hspinfo;\n                        my $id      = shift @$HSPinfo;\n\n                        if ( $id ne $name ) {\n                            $self->throw(\n\"Somehow the domain list details do not match the table (got $id, expected $name)\"\n                            );\n                        }\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_query-from',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_query-to',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_hit-from',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_hit-to',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_score',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_evalue',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $lastdomain = $name;\n                    }\n                    else {\n                        if (/^(\\s+\\*\\-\\>)(\\S+)/o) {\n\n                            # start of domain\n                            $prelength = CORE::length($1);\n                            $width     = 0;\n\n                            # deal with fact that start en stop is on same line\n                            my $data = $2;\n                            if ($data =~ s/\\<\\-?\\*?\\s*$//)\n                            {\n                              $width = CORE::length($data);\n                            }\n \n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_hseq',\n                                    'Data' => $data\n                                }\n                            );\n                            $count       = 0;\n                            $second_tier = 0;\n\n                        }\n                        elsif (/^(\\s+)(\\S+)\\<\\-?\\*?\\s*$/o) {\n\n                            #end of domain\n                            $prelength -= 3 unless ( $second_tier++ );\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_hseq',\n                                    'Data' => $2\n                                }\n                            );\n                            $width = CORE::length($2);\n                            $count = 0;\n                        }\n                        elsif (CORE::length($_) == 0\n                            || ( $count != 1 && /^\\s+$/o )\n                            || /^\\s+\\-?\\*\\s*$/ )\n                        {\n                            next;\n                        }\n                        elsif ( $count == 0 ) {\n                            $prelength -= 3 unless ( $second_tier++ );\n                            unless ( defined $prelength ) {\n\n                                # $self->warn(\"prelength not set\");\n                                next;\n                            }\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_hseq',\n                                    'Data' => substr( $_, $prelength )\n                                }\n                            );\n                        }\n                        elsif ( $count == 1 ) {\n                            if ( !defined $prelength ) {\n                                $self->warn(\"prelength not set\");\n                            }\n                            if ($width) {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_midline',\n                                        'Data' =>\n                                          substr( $_, $prelength, $width )\n                                    }\n                                );\n                            }\n                            else {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_midline',\n                                        'Data' => substr( $_, $prelength )\n                                    }\n                                );\n                            }\n                        }\n                        elsif ( $count == 2 ) {\n                            if (   /^\\s+(\\S+)\\s+(\\d+)\\s+(\\S+)\\s+(\\d+)/o\n                                || /^\\s+(\\S+)\\s+(\\-)\\s+(\\S*)\\s+(\\-)/o )\n                            {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_qseq',\n                                        'Data' => $3\n                                    }\n                                );\n                            }\n                            else {\n                                $self->throw(\n                                    \"unrecognized line ($count): $_\\n\");\n                            }\n                        }\n                        $count = 0 if $count++ >= 2;\n                    }\n                }\n            }\n            elsif ( /^Histogram/o || m!^//!o ) {\n\n                while ( my $HSPinfo = shift @hspinfo ) {\n                    my $id   = shift @$HSPinfo;\n                    my $info = [ @{ $hitinfo[ $hitinfo{$id} ] } ];\n                    next unless defined $info;\n                    $self->start_element( { 'Name' => 'Hit' } );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_id',\n                            'Data' => shift @{$info}\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_desc',\n                            'Data' => shift @{$info}\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_signif',\n                            'Data' => shift @{$info}\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_score',\n                            'Data' => shift @{$info}\n                        }\n                    );\n                    $self->start_element( { 'Name' => 'Hsp' } );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_query-from',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );                    \n                    $self->element(\n                        {\n                            'Name' => 'Hsp_query-to',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_hit-from',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_hit-to',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_score',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_evalue',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_identity',\n                            'Data' => 0\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_positive',\n                            'Data' => 0\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_positive',\n                            'Data' => 0\n                        }\n                    );\n                    $self->end_element( { 'Name' => 'Hsp' } );\n                    $self->end_element( { 'Name' => 'Hit' } );\n                }\n                @hitinfo = ();\n                %hitinfo = ();\n                last;\n            }\n            # uncomment to see missed lines with verbose on\n            #else {\n            #    $self->debug($_);\n            #}\n        }\n        $last = $_;\n    }\n    $self->end_element( { 'Name' => 'HMMER_Output' } ) unless !$seentop;\n    return $self->end_document();\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element {\n    my ( $self, $data ) = @_;\n\n    # we currently don't care about attributes\n    my $nm   = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    if ($type) {\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = sprintf( \"start_%s\", lc $type );\n            $self->_eventHandler->$func( $data->{'Attributes'} );\n        }\n        unshift @{ $self->{'_elements'} }, $type;\n    }\n    if ( defined $type\n        && $type eq 'result' )\n    {\n        $self->{'_values'} = {};\n        $self->{'_result'} = undef;\n    }\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ( $self, $data ) = @_;\n    my $nm   = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    my $rc;\n\n    if ( $nm eq 'HMMER_program' ) {\n        if ( $self->{'_last_data'} =~ /(HMM\\S+)/i ) {\n            $self->{'_reporttype'} = uc $1;\n        }\n    }\n\n    # Hsp are sort of weird, in that they end when another\n    # object begins so have to detect this in end_element for now\n    if ( $nm eq 'Hsp' ) {\n        foreach (qw(Hsp_qseq Hsp_midline Hsp_hseq)) {\n            my $data = $self->{'_last_hspdata'}->{$_};\n            if ($data && $_ eq 'Hsp_hseq') {\n                # replace hmm '.' gap symbol by '-'\n                $data =~ s/\\./-/g;\n            }\n            $self->element(\n                {\n                    'Name' => $_,\n                    'Data' => $data\n                }\n            );\n        }\n        $self->{'_last_hspdata'} = {};\n    }\n    if ($type) {\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = sprintf( \"end_%s\", lc $type );\n            $rc = $self->_eventHandler->$func( $self->{'_reporttype'},\n                $self->{'_values'} );\n        }\n        my $lastelem = shift @{ $self->{'_elements'} };\n    }\n    elsif ( $MAPPING{$nm} ) {\n        if ( ref( $MAPPING{$nm} ) =~ /hash/i ) {\n            my $key = ( keys %{ $MAPPING{$nm} } )[0];\n            $self->{'_values'}->{$key}->{ $MAPPING{$nm}->{$key} } =\n              $self->{'_last_data'};\n        }\n        else {\n            $self->{'_values'}->{ $MAPPING{$nm} } = $self->{'_last_data'};\n        }\n    }\n    else {\n        $self->debug(\"unknown nm $nm, ignoring\\n\");\n    }\n    $self->{'_last_data'} = '';    # remove read data if we are at\n                                   # end of an element\n    $self->{'_result'} = $rc if ( defined $type && $type eq 'result' );\n    return $rc;\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element {\n    my ( $self, $data ) = @_;\n    $self->start_element($data);\n    $self->characters($data);\n    $self->end_element($data);\n}\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string\n\n\n\nsub characters {\n    my ( $self, $data ) = @_;\n\n    if (   $self->in_element('hsp')\n        && $data->{'Name'} =~ /Hsp\\_(qseq|hseq|midline)/o\n        && defined $data->{'Data'} )\n    {\n        $self->{'_last_hspdata'}->{ $data->{'Name'} } .= $data->{'Data'};\n    }\n    return unless ( defined $data->{'Data'} && $data->{'Data'} !~ /^\\s+$/o );\n\n    $self->{'_last_data'} = $data->{'Data'};\n}\n\n=head2 within_element\n\n Title   : within_element\n Usage   : if( $eventgenerator->within_element($element) ) {}\n Function: Test if we are within a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name "},"detail":"($self,$name)","kind":12,"children":[{"line":1227,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"within_element"},{"name":"$name","containerName":"within_element","kind":13,"line":1227},{"containerName":"within_element","name":"$name","kind":13,"line":1230},{"kind":13,"line":1230,"name":"$self","containerName":"within_element"},{"name":"$self","containerName":"within_element","kind":13,"line":1231}],"line":1226},{"containerName":null,"name":"%self","kind":13,"line":1232},{"containerName":null,"name":"$name","kind":13,"line":1233},{"line":1251,"children":[{"line":1252,"kind":13,"localvar":"my","containerName":"in_element","definition":"my","name":"$self"},{"containerName":"in_element","name":"$name","line":1252,"kind":13},{"kind":13,"line":1253,"containerName":"in_element","name":"$self"},{"line":1254,"kind":13,"name":"$self","containerName":"in_element"},{"containerName":"in_element","name":"$name","kind":13,"line":1254}],"kind":12,"detail":"($self,$name)","signature":{"label":"in_element($self,$name)","parameters":[{"label":"$self"},{"label":"$name"}],"documentation":"1;\n# $Id: hmmer.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::hmmer\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::hmmer - A parser for HMMER output (hmmpfam, hmmsearch)\n\n=head1 SYNOPSIS\n\n    # do not use this class directly it is available through Bio::SearchIO\n    use Bio::SearchIO;\n    my $in = Bio::SearchIO->new(-format => 'hmmer',\n                               -file   => 't/data/L77119.hmmer');\n    while( my $result = $in->next_result ) {\n        # this is a Bio::Search::Result::HMMERResult object\n        print $result->query_name(), \" for HMM \", $result->hmm_name(), \"\\n\";\n        while( my $hit = $result->next_hit ) {\n            print $hit->name(), \"\\n\";\n            while( my $hsp = $hit->next_hsp ) {\n                print \"length is \", $hsp->length(), \"\\n\";\n            }\n        }\n    }\n\n=head1 DESCRIPTION\n\nThis object implements a parser for HMMER output.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::hmmer;\n\nuse strict;\n\nuse Bio::Factory::ObjectFactory;\n\nuse vars qw(%MAPPING %MODEMAP\n);\n\nuse base qw(Bio::SearchIO);\n\nBEGIN {\n\n    # mapping of HMMER items to Bioperl hash keys\n    %MODEMAP = (\n        'HMMER_Output' => 'result',\n        'Hit'          => 'hit',\n        'Hsp'          => 'hsp'\n    );\n\n    %MAPPING = (\n        'Hsp_bit-score'   => 'HSP-bits',\n        'Hsp_score'       => 'HSP-score',\n        'Hsp_evalue'      => 'HSP-evalue',\n        'Hsp_query-from'  => 'HSP-query_start',\n        'Hsp_query-to'    => 'HSP-query_end',\n        'Hsp_hit-from'    => 'HSP-hit_start',\n        'Hsp_hit-to'      => 'HSP-hit_end',\n        'Hsp_positive'    => 'HSP-conserved',\n        'Hsp_identity'    => 'HSP-identical',\n        'Hsp_gaps'        => 'HSP-hsp_gaps',\n        'Hsp_hitgaps'     => 'HSP-hit_gaps',\n        'Hsp_querygaps'   => 'HSP-query_gaps',\n        'Hsp_qseq'        => 'HSP-query_seq',\n        'Hsp_hseq'        => 'HSP-hit_seq',\n        'Hsp_midline'     => 'HSP-homology_seq',\n        'Hsp_align-len'   => 'HSP-hsp_length',\n        'Hsp_query-frame' => 'HSP-query_frame',\n        'Hsp_hit-frame'   => 'HSP-hit_frame',\n\n        'Hit_id'        => 'HIT-name',\n        'Hit_len'       => 'HIT-length',\n        'Hit_accession' => 'HIT-accession',\n        'Hit_desc'      => 'HIT-description',\n        'Hit_signif'    => 'HIT-significance',\n        'Hit_score'     => 'HIT-score',\n\n        'HMMER_program'   => 'RESULT-algorithm_name',\n        'HMMER_version'   => 'RESULT-algorithm_version',\n        'HMMER_query-def' => 'RESULT-query_name',\n        'HMMER_query-len' => 'RESULT-query_length',\n        'HMMER_query-acc' => 'RESULT-query_accession',\n        'HMMER_querydesc' => 'RESULT-query_description',\n        'HMMER_hmm'       => 'RESULT-hmm_name',\n        'HMMER_seqfile'   => 'RESULT-sequence_file',\n        'HMMER_db'        => 'RESULT-database_name',\n    );\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::hmmer->new();\n Function: Builds a new Bio::SearchIO::hmmer object \n Returns : Bio::SearchIO::hmmer\n Args    : -fh/-file => HMMER filename\n           -format   => 'hmmer'\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n    my $handler = $self->_eventHandler;\n    $handler->register_factory(\n        'result',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Result::HMMERResult',\n            -interface => 'Bio::Search::Result::ResultI'\n        )\n    );\n\n    $handler->register_factory(\n        'hit',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Hit::HMMERHit',\n            -interface => 'Bio::Search::Hit::HitI'\n        )\n    );\n\n    $handler->register_factory(\n        'hsp',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::HSP::HMMERHSP',\n            -interface => 'Bio::Search::HSP::HSPI'\n        )\n    );\n    $self->{'_hmmidline'} = 'HMMER 2.2g (August 2001)';\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    my $seentop = 0;\n    my $reporttype;\n    my ( $last, @hitinfo, @hspinfo, %hspinfo, %hitinfo );\n    local $/ = \"\\n\";\n    local $_;\n\n    my $verbose = $self->verbose;    # cache for speed?\n    $self->start_document();\n    local ($_);\n    while ( defined( $_ = $self->_readline ) ) {\n        my $lineorig = $_;\n        chomp;\n        if (/^HMMER\\s+(\\S+)\\s+\\((.+)\\)/o) {\n            my ( $prog, $version ) = split;\n            if ($seentop) {\n                $self->_pushback($_);\n                $self->end_element( { 'Name' => 'HMMER_Output' } );\n                return $self->end_document();\n            }\n            $self->{'_hmmidline'} = $_;\n            $self->start_element( { 'Name' => 'HMMER_Output' } );\n            $self->{'_result_count'}++;\n            $seentop = 1;\n            if ( defined $last ) {\n                ($reporttype) = split( /\\s+/, $last );\n                $self->element(\n                    {\n                        'Name' => 'HMMER_program',\n                        'Data' => uc($reporttype)\n                    }\n                );\n            }\n            $self->element(\n                {\n                    'Name' => 'HMMER_version',\n                    'Data' => $version\n                }\n            );\n        }\n        elsif (s/^HMM file:\\s+//o) {\n            $self->{'_hmmfileline'} = $lineorig;\n            $self->element(\n                {\n                    'Name' => 'HMMER_hmm',\n                    'Data' => $_\n                }\n            );\n        }\n        elsif (s/^Sequence\\s+(file|database):\\s+//o) {\n            $self->{'_hmmseqline'} = $lineorig;\n            if ( $1 eq 'database' ) {\n                $self->element(\n                    {\n                        'Name' => 'HMMER_db',\n                        'Data' => $_\n                    }\n                );\n            }\n            $self->element(\n                {\n                    'Name' => 'HMMER_seqfile',\n                    'Data' => $_\n                }\n            );\n        }\n        elsif (s/^Query(\\s+(sequence|HMM))?(?:\\s+\\d+)?:\\s+//o) {\n            if ( !$seentop ) {\n\n                # we're in a multi-query report\n                $self->_pushback( $self->{'_hmmidline'} );\n                $self->_pushback( $self->{'_hmmfileline'} );\n                $self->_pushback( $self->{'_hmmseqline'} );\n                $self->_pushback($lineorig);\n                next;\n            }\n            s/\\s+$//;\n            $self->element(\n                {\n                    'Name' => 'HMMER_query-def',\n                    'Data' => $_\n                }\n            );\n        }\n        elsif (s/^Accession:\\s+//o) {\n            s/\\s+$//;\n            $self->element(\n                {\n                    'Name' => 'HMMER_query-acc',\n                    'Data' => $_\n                }\n            );\n        }\n        elsif (s/^Description:\\s+//o) {\n            s/\\s+$//;\n            $self->element(\n                {\n                    'Name' => 'HMMER_querydesc',\n                    'Data' => $_\n                }\n            );\n        }\n        elsif ( defined $self->{'_reporttype'}\n            && $self->{'_reporttype'} eq 'HMMSEARCH' )\n        {\n\n            # PROCESS HMMSEARCH RESULTS HERE\n            if (/^Scores for complete sequences/o) {\n                while ( defined( $_ = $self->_readline ) ) {\n                    last if (/^\\s+$/);\n                    next if ( /^Sequence\\s+Description/o || /^\\-\\-\\-/o );\n                    my @line = split;\n                    my ( $name, $n, $evalue, $score ) =\n                      ( shift @line, pop @line, pop @line, pop @line );\n                    my $desc = join( ' ', @line );\n                    push @hitinfo, [ $name, $desc, $evalue, $score ];\n                    $hitinfo{$name} = $#hitinfo;\n                }\n            }\n            elsif (/^Parsed for domains:/o) {\n                @hspinfo = ();\n\n                while ( defined( $_ = $self->_readline ) ) {\n                    last if (/^\\s+$/);\n                    if (m!^//!) {\n                        $self->_pushback($_);\n                        last;\n                    }\n                    next if ( /^(Model|Sequence)\\s+Domain/ || /^\\-\\-\\-/ );\n\n                    chomp;\n                    if (\n                        my ( $n, $domainnum, $domainct, @vals ) = (\n                            m!^(\\S+)\\s+      # host name\n\t\t\t(\\d+)/(\\d+)\\s+   # num/num (ie 1 of 2) \n\t\t\t(\\d+)\\s+(\\d+).+? # sequence start and end\n\t\t\t(\\d+)\\s+(\\d+)\\s+ # hmm start and end\n\t\t\t\\S+\\s+           # []\n\t\t\t(\\S+)\\s+         # score\n\t\t\t(\\S+)            # evalue\n\t\t\t\\s*$!ox\n                        )\n                      )\n                    {\n\n                        # array lookup so that we can get rid of things\n                        # when they've been processed\n                        my $info = $hitinfo[ $hitinfo{$n} ];\n                        if ( !defined $info ) {\n                            $self->warn(\n\"Incomplete Sequence information, can't find $n hitinfo says $hitinfo{$n}\"\n                            );\n                            next;\n                        }\n                        push @hspinfo, [ $n, @vals ];\n                    }\n                }\n            }\n            elsif (/^Alignments of top/o) {\n                my ( $prelength, $lastdomain, $count, $width );\n                $count = 0;\n                my %domaincounter;\n                my $second_tier = 0;\n                while ( defined( $_ = $self->_readline ) ) {\n                    next if ( /^Align/o\n                        || /^\\s+RF\\s+[x\\s]+$/o );\n                    if ( /^Histogram/o || m!^//!o ) {\n                        if ( $self->in_element('hsp') ) {\n                            $self->end_element( { 'Name' => 'Hsp' } );\n                        }\n                        if ( $self->within_element('hit') ) {\n                            $self->end_element( { 'Name' => 'Hit' } );\n                        }\n                        last;\n                    }\n                    chomp;\n\n                    if (\n                        m/^\\s*(.+):\\s+domain\\s+(\\d+)\\s+of\\s+(\\d+)\\,\\s+\n                        from\\s+(\\d+)\\s+to\\s+(\\d+)/x\n                      )\n                    {\n                        my ( $name, $domainct, $domaintotal, $from, $to ) =\n                          ( $1, $2, $3, $4, $5 );\n                        $domaincounter{$name}++;\n                        if ( $self->within_element('hit') ) {\n                            if ( $self->within_element('hsp') ) {\n                                $self->end_element( { 'Name' => 'Hsp' } );\n                            }\n                            $self->end_element( { 'Name' => 'Hit' } );\n                        }\n\n                        $self->start_element( { 'Name' => 'Hit' } );\n                        my $info = [\n                            @{\n                                $hitinfo[ $hitinfo{$name} ] || $self->throw(\n\"Could not find hit info for $name: Insure that your database contains only unique sequence names\"\n                                )\n                              }\n                        ];\n                        if ( $info->[0] ne $name ) {\n                            $self->throw(\n\"Somehow the Model table order does not match the order in the domains (got \"\n                                  . $info->[0]\n                                  . \", expected $name)\" );\n                        }\n                        $self->element(\n                            {\n                                'Name' => 'Hit_id',\n                                'Data' => shift @{$info}\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hit_desc',\n                                'Data' => shift @{$info}\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hit_signif',\n                                'Data' => shift @{$info}\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hit_score',\n                                'Data' => shift @{$info}\n                            }\n                        );\n\n                        $self->start_element( { 'Name' => 'Hsp' } );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_identity',\n                                'Data' => 0\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_positive',\n                                'Data' => 0\n                            }\n                        );\n                        my $HSPinfo = shift @hspinfo;\n                        my $id      = shift @$HSPinfo;\n\n                        if ( $id ne $name ) {\n                            $self->throw(\n\"Somehow the domain list details do not match the table (got $id, expected $name)\"\n                            );\n                        }\n                        if ( $domaincounter{$name} == $domaintotal ) {\n                            $hitinfo[ $hitinfo{$name} ] = undef;\n                        }\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_hit-from',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_hit-to',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_query-from',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_query-to',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_score',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_evalue',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $lastdomain = $name;\n                    }\n                    else {\n\n                        # Might want to change this so that it\n                        # accumulates all the of the alignment lines into\n                        # three array slots and then tests for the\n                        # end of the line\n                        if (/^(\\s+\\*\\-\\>)(\\S+)/o) {    # start of domain\n                            $prelength = CORE::length($1);\n                            $width     = 0;\n\n                            # deal with fact that start en stop is on same line\n                            my $data = $2;\n                            if ($data =~ s/\\<\\-?\\*?\\s*$//)\n                            {\n                                $width = CORE::length($data);\n                            }\n \n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_qseq',\n                                    'Data' => $data\n                                }\n                            );\n                            $count       = 0;\n                            $second_tier = 0;\n                        }\n                        elsif (/^(\\s+)(\\S+)\\<\\-\\*\\s*$/o) {    #end of domain\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_qseq',\n                                    'Data' => $2\n                                }\n                            );\n                            $width = CORE::length($2);\n                            $count = 0;\n                        }\n                        elsif (( $count != 1 && /^\\s+$/o )\n                            || CORE::length($_) == 0\n                            || /^\\s+\\-?\\*\\s*$/ )\n                        {\n                            next;\n                        }\n                        elsif ( $count == 0 ) {\n                            $prelength -= 3 unless ( $second_tier++ );\n                            unless ( defined $prelength ) {\n\n                                # $self->warn(\"prelength not set\");\n                                next;\n                            }\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_qseq',\n                                    'Data' => substr( $_, $prelength )\n                                }\n                            );\n                        }\n                        elsif ( $count == 1 ) {\n                            if ( !defined $prelength ) {\n                                $self->warn(\"prelength not set\");\n                            }\n                            if ($width) {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_midline',\n                                        'Data' =>\n                                          substr( $_, $prelength, $width )\n                                    }\n                                );\n                            }\n                            else {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_midline',\n                                        'Data' => substr( $_, $prelength )\n                                    }\n                                );\n                            }\n                        }\n                        elsif ( $count == 2 ) {\n                            if (/^\\s+(\\S+)\\s+(\\d+|\\-)\\s+(\\S*)\\s+(\\d+|\\-)/o) {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_hseq',\n                                        'Data' => $3\n                                    }\n                                );\n                            }\n                            else {\n                                $self->warn(\"unrecognized line: $_\\n\");\n                            }\n                        }\n                        $count = 0 if $count++ >= 2;\n                    }\n                }\n            }\n            elsif ( /^Histogram/o || m!^//!o ) {\n                while ( my $HSPinfo = shift @hspinfo ) {\n                    my $id   = shift @$HSPinfo;\n                    my $info = [ @{ $hitinfo[ $hitinfo{$id} ] } ];\n                    next unless defined $info;\n                    $self->start_element( { 'Name' => 'Hit' } );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_id',\n                            'Data' => shift @{$info}\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_desc',\n                            'Data' => shift @{$info}\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_signif',\n                            'Data' => shift @{$info}\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_score',\n                            'Data' => shift @{$info}\n                        }\n                    );\n                    $self->start_element( { 'Name' => 'Hsp' } );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_query-from',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_query-to',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_hit-from',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_hit-to',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_score',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_evalue',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_identity',\n                            'Data' => 0\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_positive',\n                            'Data' => 0\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_positive',\n                            'Data' => 0\n                        }\n                    );\n                    $self->end_element( { 'Name' => 'Hsp' } );\n                    $self->end_element( { 'Name' => 'Hit' } );\n                }\n                @hitinfo = ();\n                %hitinfo = ();\n                last;\n            }\n        }\n        elsif ( defined $self->{'_reporttype'}\n            && $self->{'_reporttype'} eq 'HMMPFAM' )\n        {\n            # process HMMPFAM results here\n            if (/^Scores for sequence family/o) {\n                while ( defined( $_ = $self->_readline ) ) {\n                    last if (/^\\s+$/);\n                    next if ( /^Model\\s+Description/o || /^\\-\\-\\-/o );\n                    chomp;\n                    my @line = split;\n                    my ( $model, $n, $evalue, $score ) =\n                      ( shift @line, pop @line, pop @line, pop @line );\n                    my $desc = join( ' ', @line );\n                    push @hitinfo, [ $model, $desc, $score, $evalue, $n ];\n                    $hitinfo{$model} = $#hitinfo;\n                }\n            }\n            elsif (/^Parsed for domains:/o) {\n                @hspinfo = ();\n                while ( defined( $_ = $self->_readline ) ) {\n                    last if (/^\\s+$/);\n                    if (m!^//!) {\n                        $self->_pushback($_);\n                        last;\n                    }\n                    next if ( /^Model\\s+Domain/o || /^\\-\\-\\-/o );\n                    chomp;\n                    if (\n                        my ( $n, $domainnum, $domainct, @vals ) = (\n                            m!^(\\S+)\\s+         # domain name\n                            (\\d+)/(\\d+)\\s+      # domain num out of num\n                            (\\d+)\\s+(\\d+).+?    # seq start, end\n                            (\\d+)\\s+(\\d+)\\s+    # hmm start, end\n                            \\S+\\s+              # []\n                            (\\S+)\\s+            # score       \n                            (\\S+)               # evalue\n                            \\s*$!ox\n                        )\n                      )\n                    {\n                        my $hindex = $hitinfo{$n};\n                        if ( !defined $hindex ) {\n                            push @hitinfo,\n                              [ $n, '', $vals[5], $vals[6], $domainct ];\n                            $hitinfo{$n} = $#hitinfo;\n                            $hindex = $#hitinfo;\n                        }\n                        my $info = $hitinfo[$hindex];\n                        if ( !defined $info ) {\n                            $self->warn(\n\"incomplete Domain information, can't find $n hitinfo says $hitinfo{$n}\"\n                            );\n                            next;\n                        }\n                        push @hspinfo, [ $n, @vals ];\n                    }\n                }\n            }\n            elsif (/^Alignments of top/o) {\n                my ( $prelength, $lastdomain, $count, $width );\n                $count = 0;\n                my $second_tier = 0;\n                while ( defined( $_ = $self->_readline ) ) {\n                    next\n                      if (\n                        /^Align/o\n                        || ( $count != 1\n                            && /^\\s+RF\\s+[x\\s]+$/o )\n                      );\n                    # fix for bug 2632\n                    next if ($_ =~ m/^\\s+CS\\s+/o && $count == 0);\n                    if ( /^Histogram/o || m!^//!o || /^Query sequence/o ) {\n                        if ( $self->in_element('hsp') ) {\n                            $self->end_element( { 'Name' => 'Hsp' } );\n                        }\n                        if ( $self->in_element('hit') ) {\n                            $self->end_element( { 'Name' => 'Hit' } );\n                        }\n                        $self->_pushback($_);\n                        last;\n                    }\n                    chomp;\n                    if (m/(\\S+):.*from\\s+(\\d+)\\s+to\\s+(\\d+)/o) {\n                        my ( $name, $from, $to ) = ( $1, $2, $3 );\n\n                        if ( $self->within_element('hit') ) {\n                            if ( $self->in_element('hsp') ) {\n                                $self->end_element( { 'Name' => 'Hsp' } );\n                            }\n                            $self->end_element( { 'Name' => 'Hit' } );\n                        }\n                        my $info = [ @{ $hitinfo[ $hitinfo{$name} ] } ];\n                        if ( !defined $info\n                            || $info->[0] ne $name )\n                        {\n                            $self->warn(\n\"Somehow the Model table order does not match the order in the domains (got \"\n                                  . $info->[0]\n                                  . \", expected $name). We're back loading this from the alignment information instead\"\n                            );\n                            $info = [\n                                $name, '',\n                                /score\\s+([^,\\s]+),\\s+E\\s+=\\s+(\\S+)/ox\n                            ];\n                            push @hitinfo, $info;\n                            $hitinfo{$name} = $#hitinfo;\n                        }\n                        $self->start_element( { 'Name' => 'Hit' } );\n\n                        $self->element(\n                            {\n                                'Name' => 'Hit_id',\n                                'Data' => shift @{$info}\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hit_desc',\n                                'Data' => shift @{$info}\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hit_score',\n                                'Data' => shift @{$info}\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hit_signif',\n                                'Data' => shift @{$info}\n                            }\n                        );\n\n                        $self->start_element( { 'Name' => 'Hsp' } );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_identity',\n                                'Data' => 0\n                            }\n                        );                     \n                        $self->element(\n                            {\n                                'Name' => 'Hsp_positive',\n                                'Data' => 0\n                            }\n                        );\n                        my $HSPinfo = shift @hspinfo;\n                        my $id      = shift @$HSPinfo;\n\n                        if ( $id ne $name ) {\n                            $self->throw(\n\"Somehow the domain list details do not match the table (got $id, expected $name)\"\n                            );\n                        }\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_query-from',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_query-to',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_hit-from',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_hit-to',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_score',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_evalue',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $lastdomain = $name;\n                    }\n                    else {\n                        if (/^(\\s+\\*\\-\\>)(\\S+)/o) {\n\n                            # start of domain\n                            $prelength = CORE::length($1);\n                            $width     = 0;\n\n                            # deal with fact that start en stop is on same line\n                            my $data = $2;\n                            if ($data =~ s/\\<\\-?\\*?\\s*$//)\n                            {\n                              $width = CORE::length($data);\n                            }\n \n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_hseq',\n                                    'Data' => $data\n                                }\n                            );\n                            $count       = 0;\n                            $second_tier = 0;\n\n                        }\n                        elsif (/^(\\s+)(\\S+)\\<\\-?\\*?\\s*$/o) {\n\n                            #end of domain\n                            $prelength -= 3 unless ( $second_tier++ );\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_hseq',\n                                    'Data' => $2\n                                }\n                            );\n                            $width = CORE::length($2);\n                            $count = 0;\n                        }\n                        elsif (CORE::length($_) == 0\n                            || ( $count != 1 && /^\\s+$/o )\n                            || /^\\s+\\-?\\*\\s*$/ )\n                        {\n                            next;\n                        }\n                        elsif ( $count == 0 ) {\n                            $prelength -= 3 unless ( $second_tier++ );\n                            unless ( defined $prelength ) {\n\n                                # $self->warn(\"prelength not set\");\n                                next;\n                            }\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_hseq',\n                                    'Data' => substr( $_, $prelength )\n                                }\n                            );\n                        }\n                        elsif ( $count == 1 ) {\n                            if ( !defined $prelength ) {\n                                $self->warn(\"prelength not set\");\n                            }\n                            if ($width) {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_midline',\n                                        'Data' =>\n                                          substr( $_, $prelength, $width )\n                                    }\n                                );\n                            }\n                            else {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_midline',\n                                        'Data' => substr( $_, $prelength )\n                                    }\n                                );\n                            }\n                        }\n                        elsif ( $count == 2 ) {\n                            if (   /^\\s+(\\S+)\\s+(\\d+)\\s+(\\S+)\\s+(\\d+)/o\n                                || /^\\s+(\\S+)\\s+(\\-)\\s+(\\S*)\\s+(\\-)/o )\n                            {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_qseq',\n                                        'Data' => $3\n                                    }\n                                );\n                            }\n                            else {\n                                $self->throw(\n                                    \"unrecognized line ($count): $_\\n\");\n                            }\n                        }\n                        $count = 0 if $count++ >= 2;\n                    }\n                }\n            }\n            elsif ( /^Histogram/o || m!^//!o ) {\n\n                while ( my $HSPinfo = shift @hspinfo ) {\n                    my $id   = shift @$HSPinfo;\n                    my $info = [ @{ $hitinfo[ $hitinfo{$id} ] } ];\n                    next unless defined $info;\n                    $self->start_element( { 'Name' => 'Hit' } );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_id',\n                            'Data' => shift @{$info}\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_desc',\n                            'Data' => shift @{$info}\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_signif',\n                            'Data' => shift @{$info}\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_score',\n                            'Data' => shift @{$info}\n                        }\n                    );\n                    $self->start_element( { 'Name' => 'Hsp' } );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_query-from',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );                    \n                    $self->element(\n                        {\n                            'Name' => 'Hsp_query-to',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_hit-from',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_hit-to',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_score',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_evalue',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_identity',\n                            'Data' => 0\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_positive',\n                            'Data' => 0\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_positive',\n                            'Data' => 0\n                        }\n                    );\n                    $self->end_element( { 'Name' => 'Hsp' } );\n                    $self->end_element( { 'Name' => 'Hit' } );\n                }\n                @hitinfo = ();\n                %hitinfo = ();\n                last;\n            }\n            # uncomment to see missed lines with verbose on\n            #else {\n            #    $self->debug($_);\n            #}\n        }\n        $last = $_;\n    }\n    $self->end_element( { 'Name' => 'HMMER_Output' } ) unless !$seentop;\n    return $self->end_document();\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element {\n    my ( $self, $data ) = @_;\n\n    # we currently don't care about attributes\n    my $nm   = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    if ($type) {\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = sprintf( \"start_%s\", lc $type );\n            $self->_eventHandler->$func( $data->{'Attributes'} );\n        }\n        unshift @{ $self->{'_elements'} }, $type;\n    }\n    if ( defined $type\n        && $type eq 'result' )\n    {\n        $self->{'_values'} = {};\n        $self->{'_result'} = undef;\n    }\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ( $self, $data ) = @_;\n    my $nm   = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    my $rc;\n\n    if ( $nm eq 'HMMER_program' ) {\n        if ( $self->{'_last_data'} =~ /(HMM\\S+)/i ) {\n            $self->{'_reporttype'} = uc $1;\n        }\n    }\n\n    # Hsp are sort of weird, in that they end when another\n    # object begins so have to detect this in end_element for now\n    if ( $nm eq 'Hsp' ) {\n        foreach (qw(Hsp_qseq Hsp_midline Hsp_hseq)) {\n            my $data = $self->{'_last_hspdata'}->{$_};\n            if ($data && $_ eq 'Hsp_hseq') {\n                # replace hmm '.' gap symbol by '-'\n                $data =~ s/\\./-/g;\n            }\n            $self->element(\n                {\n                    'Name' => $_,\n                    'Data' => $data\n                }\n            );\n        }\n        $self->{'_last_hspdata'} = {};\n    }\n    if ($type) {\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = sprintf( \"end_%s\", lc $type );\n            $rc = $self->_eventHandler->$func( $self->{'_reporttype'},\n                $self->{'_values'} );\n        }\n        my $lastelem = shift @{ $self->{'_elements'} };\n    }\n    elsif ( $MAPPING{$nm} ) {\n        if ( ref( $MAPPING{$nm} ) =~ /hash/i ) {\n            my $key = ( keys %{ $MAPPING{$nm} } )[0];\n            $self->{'_values'}->{$key}->{ $MAPPING{$nm}->{$key} } =\n              $self->{'_last_data'};\n        }\n        else {\n            $self->{'_values'}->{ $MAPPING{$nm} } = $self->{'_last_data'};\n        }\n    }\n    else {\n        $self->debug(\"unknown nm $nm, ignoring\\n\");\n    }\n    $self->{'_last_data'} = '';    # remove read data if we are at\n                                   # end of an element\n    $self->{'_result'} = $rc if ( defined $type && $type eq 'result' );\n    return $rc;\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element {\n    my ( $self, $data ) = @_;\n    $self->start_element($data);\n    $self->characters($data);\n    $self->end_element($data);\n}\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string\n\n\n\nsub characters {\n    my ( $self, $data ) = @_;\n\n    if (   $self->in_element('hsp')\n        && $data->{'Name'} =~ /Hsp\\_(qseq|hseq|midline)/o\n        && defined $data->{'Data'} )\n    {\n        $self->{'_last_hspdata'}->{ $data->{'Name'} } .= $data->{'Data'};\n    }\n    return unless ( defined $data->{'Data'} && $data->{'Data'} !~ /^\\s+$/o );\n\n    $self->{'_last_data'} = $data->{'Data'};\n}\n\n=head2 within_element\n\n Title   : within_element\n Usage   : if( $eventgenerator->within_element($element) ) {}\n Function: Test if we are within a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name \n\n\n\nsub within_element {\n    my ( $self, $name ) = @_;\n    return 0\n      if ( !defined $name\n        || !defined $self->{'_elements'}\n        || scalar @{ $self->{'_elements'} } == 0 );\n    foreach ( @{ $self->{'_elements'} } ) {\n        return 1 if ( $_ eq $name );\n    }\n    return 0;\n}\n\n=head2 in_element\n\n Title   : in_element\n Usage   : if( $eventgenerator->in_element($element) ) {}\n Function: Test if we are in a particular element\n           This is different than 'within' because 'in' only \n           tests its immediete parent.\n Returns : boolean\n Args    : string element name "},"containerName":"main::","definition":"sub","range":{"end":{"line":1255,"character":9999},"start":{"character":0,"line":1251}},"name":"in_element"},{"kind":12,"children":[{"definition":"my","name":"$self","containerName":"start_document","localvar":"my","kind":13,"line":1269},{"line":1270,"kind":13,"name":"$self","containerName":"start_document"},{"name":"$self","containerName":"start_document","kind":13,"line":1271},{"name":"$self","containerName":"start_document","kind":13,"line":1272},{"line":1273,"kind":13,"containerName":"start_document","name":"$self"}],"line":1268,"definition":"sub","containerName":"main::","signature":{"label":"start_document($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: hmmer.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::hmmer\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::hmmer - A parser for HMMER output (hmmpfam, hmmsearch)\n\n=head1 SYNOPSIS\n\n    # do not use this class directly it is available through Bio::SearchIO\n    use Bio::SearchIO;\n    my $in = Bio::SearchIO->new(-format => 'hmmer',\n                               -file   => 't/data/L77119.hmmer');\n    while( my $result = $in->next_result ) {\n        # this is a Bio::Search::Result::HMMERResult object\n        print $result->query_name(), \" for HMM \", $result->hmm_name(), \"\\n\";\n        while( my $hit = $result->next_hit ) {\n            print $hit->name(), \"\\n\";\n            while( my $hsp = $hit->next_hsp ) {\n                print \"length is \", $hsp->length(), \"\\n\";\n            }\n        }\n    }\n\n=head1 DESCRIPTION\n\nThis object implements a parser for HMMER output.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::hmmer;\n\nuse strict;\n\nuse Bio::Factory::ObjectFactory;\n\nuse vars qw(%MAPPING %MODEMAP\n);\n\nuse base qw(Bio::SearchIO);\n\nBEGIN {\n\n    # mapping of HMMER items to Bioperl hash keys\n    %MODEMAP = (\n        'HMMER_Output' => 'result',\n        'Hit'          => 'hit',\n        'Hsp'          => 'hsp'\n    );\n\n    %MAPPING = (\n        'Hsp_bit-score'   => 'HSP-bits',\n        'Hsp_score'       => 'HSP-score',\n        'Hsp_evalue'      => 'HSP-evalue',\n        'Hsp_query-from'  => 'HSP-query_start',\n        'Hsp_query-to'    => 'HSP-query_end',\n        'Hsp_hit-from'    => 'HSP-hit_start',\n        'Hsp_hit-to'      => 'HSP-hit_end',\n        'Hsp_positive'    => 'HSP-conserved',\n        'Hsp_identity'    => 'HSP-identical',\n        'Hsp_gaps'        => 'HSP-hsp_gaps',\n        'Hsp_hitgaps'     => 'HSP-hit_gaps',\n        'Hsp_querygaps'   => 'HSP-query_gaps',\n        'Hsp_qseq'        => 'HSP-query_seq',\n        'Hsp_hseq'        => 'HSP-hit_seq',\n        'Hsp_midline'     => 'HSP-homology_seq',\n        'Hsp_align-len'   => 'HSP-hsp_length',\n        'Hsp_query-frame' => 'HSP-query_frame',\n        'Hsp_hit-frame'   => 'HSP-hit_frame',\n\n        'Hit_id'        => 'HIT-name',\n        'Hit_len'       => 'HIT-length',\n        'Hit_accession' => 'HIT-accession',\n        'Hit_desc'      => 'HIT-description',\n        'Hit_signif'    => 'HIT-significance',\n        'Hit_score'     => 'HIT-score',\n\n        'HMMER_program'   => 'RESULT-algorithm_name',\n        'HMMER_version'   => 'RESULT-algorithm_version',\n        'HMMER_query-def' => 'RESULT-query_name',\n        'HMMER_query-len' => 'RESULT-query_length',\n        'HMMER_query-acc' => 'RESULT-query_accession',\n        'HMMER_querydesc' => 'RESULT-query_description',\n        'HMMER_hmm'       => 'RESULT-hmm_name',\n        'HMMER_seqfile'   => 'RESULT-sequence_file',\n        'HMMER_db'        => 'RESULT-database_name',\n    );\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::hmmer->new();\n Function: Builds a new Bio::SearchIO::hmmer object \n Returns : Bio::SearchIO::hmmer\n Args    : -fh/-file => HMMER filename\n           -format   => 'hmmer'\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n    my $handler = $self->_eventHandler;\n    $handler->register_factory(\n        'result',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Result::HMMERResult',\n            -interface => 'Bio::Search::Result::ResultI'\n        )\n    );\n\n    $handler->register_factory(\n        'hit',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Hit::HMMERHit',\n            -interface => 'Bio::Search::Hit::HitI'\n        )\n    );\n\n    $handler->register_factory(\n        'hsp',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::HSP::HMMERHSP',\n            -interface => 'Bio::Search::HSP::HSPI'\n        )\n    );\n    $self->{'_hmmidline'} = 'HMMER 2.2g (August 2001)';\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    my $seentop = 0;\n    my $reporttype;\n    my ( $last, @hitinfo, @hspinfo, %hspinfo, %hitinfo );\n    local $/ = \"\\n\";\n    local $_;\n\n    my $verbose = $self->verbose;    # cache for speed?\n    $self->start_document();\n    local ($_);\n    while ( defined( $_ = $self->_readline ) ) {\n        my $lineorig = $_;\n        chomp;\n        if (/^HMMER\\s+(\\S+)\\s+\\((.+)\\)/o) {\n            my ( $prog, $version ) = split;\n            if ($seentop) {\n                $self->_pushback($_);\n                $self->end_element( { 'Name' => 'HMMER_Output' } );\n                return $self->end_document();\n            }\n            $self->{'_hmmidline'} = $_;\n            $self->start_element( { 'Name' => 'HMMER_Output' } );\n            $self->{'_result_count'}++;\n            $seentop = 1;\n            if ( defined $last ) {\n                ($reporttype) = split( /\\s+/, $last );\n                $self->element(\n                    {\n                        'Name' => 'HMMER_program',\n                        'Data' => uc($reporttype)\n                    }\n                );\n            }\n            $self->element(\n                {\n                    'Name' => 'HMMER_version',\n                    'Data' => $version\n                }\n            );\n        }\n        elsif (s/^HMM file:\\s+//o) {\n            $self->{'_hmmfileline'} = $lineorig;\n            $self->element(\n                {\n                    'Name' => 'HMMER_hmm',\n                    'Data' => $_\n                }\n            );\n        }\n        elsif (s/^Sequence\\s+(file|database):\\s+//o) {\n            $self->{'_hmmseqline'} = $lineorig;\n            if ( $1 eq 'database' ) {\n                $self->element(\n                    {\n                        'Name' => 'HMMER_db',\n                        'Data' => $_\n                    }\n                );\n            }\n            $self->element(\n                {\n                    'Name' => 'HMMER_seqfile',\n                    'Data' => $_\n                }\n            );\n        }\n        elsif (s/^Query(\\s+(sequence|HMM))?(?:\\s+\\d+)?:\\s+//o) {\n            if ( !$seentop ) {\n\n                # we're in a multi-query report\n                $self->_pushback( $self->{'_hmmidline'} );\n                $self->_pushback( $self->{'_hmmfileline'} );\n                $self->_pushback( $self->{'_hmmseqline'} );\n                $self->_pushback($lineorig);\n                next;\n            }\n            s/\\s+$//;\n            $self->element(\n                {\n                    'Name' => 'HMMER_query-def',\n                    'Data' => $_\n                }\n            );\n        }\n        elsif (s/^Accession:\\s+//o) {\n            s/\\s+$//;\n            $self->element(\n                {\n                    'Name' => 'HMMER_query-acc',\n                    'Data' => $_\n                }\n            );\n        }\n        elsif (s/^Description:\\s+//o) {\n            s/\\s+$//;\n            $self->element(\n                {\n                    'Name' => 'HMMER_querydesc',\n                    'Data' => $_\n                }\n            );\n        }\n        elsif ( defined $self->{'_reporttype'}\n            && $self->{'_reporttype'} eq 'HMMSEARCH' )\n        {\n\n            # PROCESS HMMSEARCH RESULTS HERE\n            if (/^Scores for complete sequences/o) {\n                while ( defined( $_ = $self->_readline ) ) {\n                    last if (/^\\s+$/);\n                    next if ( /^Sequence\\s+Description/o || /^\\-\\-\\-/o );\n                    my @line = split;\n                    my ( $name, $n, $evalue, $score ) =\n                      ( shift @line, pop @line, pop @line, pop @line );\n                    my $desc = join( ' ', @line );\n                    push @hitinfo, [ $name, $desc, $evalue, $score ];\n                    $hitinfo{$name} = $#hitinfo;\n                }\n            }\n            elsif (/^Parsed for domains:/o) {\n                @hspinfo = ();\n\n                while ( defined( $_ = $self->_readline ) ) {\n                    last if (/^\\s+$/);\n                    if (m!^//!) {\n                        $self->_pushback($_);\n                        last;\n                    }\n                    next if ( /^(Model|Sequence)\\s+Domain/ || /^\\-\\-\\-/ );\n\n                    chomp;\n                    if (\n                        my ( $n, $domainnum, $domainct, @vals ) = (\n                            m!^(\\S+)\\s+      # host name\n\t\t\t(\\d+)/(\\d+)\\s+   # num/num (ie 1 of 2) \n\t\t\t(\\d+)\\s+(\\d+).+? # sequence start and end\n\t\t\t(\\d+)\\s+(\\d+)\\s+ # hmm start and end\n\t\t\t\\S+\\s+           # []\n\t\t\t(\\S+)\\s+         # score\n\t\t\t(\\S+)            # evalue\n\t\t\t\\s*$!ox\n                        )\n                      )\n                    {\n\n                        # array lookup so that we can get rid of things\n                        # when they've been processed\n                        my $info = $hitinfo[ $hitinfo{$n} ];\n                        if ( !defined $info ) {\n                            $self->warn(\n\"Incomplete Sequence information, can't find $n hitinfo says $hitinfo{$n}\"\n                            );\n                            next;\n                        }\n                        push @hspinfo, [ $n, @vals ];\n                    }\n                }\n            }\n            elsif (/^Alignments of top/o) {\n                my ( $prelength, $lastdomain, $count, $width );\n                $count = 0;\n                my %domaincounter;\n                my $second_tier = 0;\n                while ( defined( $_ = $self->_readline ) ) {\n                    next if ( /^Align/o\n                        || /^\\s+RF\\s+[x\\s]+$/o );\n                    if ( /^Histogram/o || m!^//!o ) {\n                        if ( $self->in_element('hsp') ) {\n                            $self->end_element( { 'Name' => 'Hsp' } );\n                        }\n                        if ( $self->within_element('hit') ) {\n                            $self->end_element( { 'Name' => 'Hit' } );\n                        }\n                        last;\n                    }\n                    chomp;\n\n                    if (\n                        m/^\\s*(.+):\\s+domain\\s+(\\d+)\\s+of\\s+(\\d+)\\,\\s+\n                        from\\s+(\\d+)\\s+to\\s+(\\d+)/x\n                      )\n                    {\n                        my ( $name, $domainct, $domaintotal, $from, $to ) =\n                          ( $1, $2, $3, $4, $5 );\n                        $domaincounter{$name}++;\n                        if ( $self->within_element('hit') ) {\n                            if ( $self->within_element('hsp') ) {\n                                $self->end_element( { 'Name' => 'Hsp' } );\n                            }\n                            $self->end_element( { 'Name' => 'Hit' } );\n                        }\n\n                        $self->start_element( { 'Name' => 'Hit' } );\n                        my $info = [\n                            @{\n                                $hitinfo[ $hitinfo{$name} ] || $self->throw(\n\"Could not find hit info for $name: Insure that your database contains only unique sequence names\"\n                                )\n                              }\n                        ];\n                        if ( $info->[0] ne $name ) {\n                            $self->throw(\n\"Somehow the Model table order does not match the order in the domains (got \"\n                                  . $info->[0]\n                                  . \", expected $name)\" );\n                        }\n                        $self->element(\n                            {\n                                'Name' => 'Hit_id',\n                                'Data' => shift @{$info}\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hit_desc',\n                                'Data' => shift @{$info}\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hit_signif',\n                                'Data' => shift @{$info}\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hit_score',\n                                'Data' => shift @{$info}\n                            }\n                        );\n\n                        $self->start_element( { 'Name' => 'Hsp' } );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_identity',\n                                'Data' => 0\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_positive',\n                                'Data' => 0\n                            }\n                        );\n                        my $HSPinfo = shift @hspinfo;\n                        my $id      = shift @$HSPinfo;\n\n                        if ( $id ne $name ) {\n                            $self->throw(\n\"Somehow the domain list details do not match the table (got $id, expected $name)\"\n                            );\n                        }\n                        if ( $domaincounter{$name} == $domaintotal ) {\n                            $hitinfo[ $hitinfo{$name} ] = undef;\n                        }\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_hit-from',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_hit-to',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_query-from',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_query-to',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_score',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_evalue',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $lastdomain = $name;\n                    }\n                    else {\n\n                        # Might want to change this so that it\n                        # accumulates all the of the alignment lines into\n                        # three array slots and then tests for the\n                        # end of the line\n                        if (/^(\\s+\\*\\-\\>)(\\S+)/o) {    # start of domain\n                            $prelength = CORE::length($1);\n                            $width     = 0;\n\n                            # deal with fact that start en stop is on same line\n                            my $data = $2;\n                            if ($data =~ s/\\<\\-?\\*?\\s*$//)\n                            {\n                                $width = CORE::length($data);\n                            }\n \n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_qseq',\n                                    'Data' => $data\n                                }\n                            );\n                            $count       = 0;\n                            $second_tier = 0;\n                        }\n                        elsif (/^(\\s+)(\\S+)\\<\\-\\*\\s*$/o) {    #end of domain\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_qseq',\n                                    'Data' => $2\n                                }\n                            );\n                            $width = CORE::length($2);\n                            $count = 0;\n                        }\n                        elsif (( $count != 1 && /^\\s+$/o )\n                            || CORE::length($_) == 0\n                            || /^\\s+\\-?\\*\\s*$/ )\n                        {\n                            next;\n                        }\n                        elsif ( $count == 0 ) {\n                            $prelength -= 3 unless ( $second_tier++ );\n                            unless ( defined $prelength ) {\n\n                                # $self->warn(\"prelength not set\");\n                                next;\n                            }\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_qseq',\n                                    'Data' => substr( $_, $prelength )\n                                }\n                            );\n                        }\n                        elsif ( $count == 1 ) {\n                            if ( !defined $prelength ) {\n                                $self->warn(\"prelength not set\");\n                            }\n                            if ($width) {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_midline',\n                                        'Data' =>\n                                          substr( $_, $prelength, $width )\n                                    }\n                                );\n                            }\n                            else {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_midline',\n                                        'Data' => substr( $_, $prelength )\n                                    }\n                                );\n                            }\n                        }\n                        elsif ( $count == 2 ) {\n                            if (/^\\s+(\\S+)\\s+(\\d+|\\-)\\s+(\\S*)\\s+(\\d+|\\-)/o) {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_hseq',\n                                        'Data' => $3\n                                    }\n                                );\n                            }\n                            else {\n                                $self->warn(\"unrecognized line: $_\\n\");\n                            }\n                        }\n                        $count = 0 if $count++ >= 2;\n                    }\n                }\n            }\n            elsif ( /^Histogram/o || m!^//!o ) {\n                while ( my $HSPinfo = shift @hspinfo ) {\n                    my $id   = shift @$HSPinfo;\n                    my $info = [ @{ $hitinfo[ $hitinfo{$id} ] } ];\n                    next unless defined $info;\n                    $self->start_element( { 'Name' => 'Hit' } );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_id',\n                            'Data' => shift @{$info}\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_desc',\n                            'Data' => shift @{$info}\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_signif',\n                            'Data' => shift @{$info}\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_score',\n                            'Data' => shift @{$info}\n                        }\n                    );\n                    $self->start_element( { 'Name' => 'Hsp' } );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_query-from',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_query-to',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_hit-from',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_hit-to',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_score',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_evalue',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_identity',\n                            'Data' => 0\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_positive',\n                            'Data' => 0\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_positive',\n                            'Data' => 0\n                        }\n                    );\n                    $self->end_element( { 'Name' => 'Hsp' } );\n                    $self->end_element( { 'Name' => 'Hit' } );\n                }\n                @hitinfo = ();\n                %hitinfo = ();\n                last;\n            }\n        }\n        elsif ( defined $self->{'_reporttype'}\n            && $self->{'_reporttype'} eq 'HMMPFAM' )\n        {\n            # process HMMPFAM results here\n            if (/^Scores for sequence family/o) {\n                while ( defined( $_ = $self->_readline ) ) {\n                    last if (/^\\s+$/);\n                    next if ( /^Model\\s+Description/o || /^\\-\\-\\-/o );\n                    chomp;\n                    my @line = split;\n                    my ( $model, $n, $evalue, $score ) =\n                      ( shift @line, pop @line, pop @line, pop @line );\n                    my $desc = join( ' ', @line );\n                    push @hitinfo, [ $model, $desc, $score, $evalue, $n ];\n                    $hitinfo{$model} = $#hitinfo;\n                }\n            }\n            elsif (/^Parsed for domains:/o) {\n                @hspinfo = ();\n                while ( defined( $_ = $self->_readline ) ) {\n                    last if (/^\\s+$/);\n                    if (m!^//!) {\n                        $self->_pushback($_);\n                        last;\n                    }\n                    next if ( /^Model\\s+Domain/o || /^\\-\\-\\-/o );\n                    chomp;\n                    if (\n                        my ( $n, $domainnum, $domainct, @vals ) = (\n                            m!^(\\S+)\\s+         # domain name\n                            (\\d+)/(\\d+)\\s+      # domain num out of num\n                            (\\d+)\\s+(\\d+).+?    # seq start, end\n                            (\\d+)\\s+(\\d+)\\s+    # hmm start, end\n                            \\S+\\s+              # []\n                            (\\S+)\\s+            # score       \n                            (\\S+)               # evalue\n                            \\s*$!ox\n                        )\n                      )\n                    {\n                        my $hindex = $hitinfo{$n};\n                        if ( !defined $hindex ) {\n                            push @hitinfo,\n                              [ $n, '', $vals[5], $vals[6], $domainct ];\n                            $hitinfo{$n} = $#hitinfo;\n                            $hindex = $#hitinfo;\n                        }\n                        my $info = $hitinfo[$hindex];\n                        if ( !defined $info ) {\n                            $self->warn(\n\"incomplete Domain information, can't find $n hitinfo says $hitinfo{$n}\"\n                            );\n                            next;\n                        }\n                        push @hspinfo, [ $n, @vals ];\n                    }\n                }\n            }\n            elsif (/^Alignments of top/o) {\n                my ( $prelength, $lastdomain, $count, $width );\n                $count = 0;\n                my $second_tier = 0;\n                while ( defined( $_ = $self->_readline ) ) {\n                    next\n                      if (\n                        /^Align/o\n                        || ( $count != 1\n                            && /^\\s+RF\\s+[x\\s]+$/o )\n                      );\n                    # fix for bug 2632\n                    next if ($_ =~ m/^\\s+CS\\s+/o && $count == 0);\n                    if ( /^Histogram/o || m!^//!o || /^Query sequence/o ) {\n                        if ( $self->in_element('hsp') ) {\n                            $self->end_element( { 'Name' => 'Hsp' } );\n                        }\n                        if ( $self->in_element('hit') ) {\n                            $self->end_element( { 'Name' => 'Hit' } );\n                        }\n                        $self->_pushback($_);\n                        last;\n                    }\n                    chomp;\n                    if (m/(\\S+):.*from\\s+(\\d+)\\s+to\\s+(\\d+)/o) {\n                        my ( $name, $from, $to ) = ( $1, $2, $3 );\n\n                        if ( $self->within_element('hit') ) {\n                            if ( $self->in_element('hsp') ) {\n                                $self->end_element( { 'Name' => 'Hsp' } );\n                            }\n                            $self->end_element( { 'Name' => 'Hit' } );\n                        }\n                        my $info = [ @{ $hitinfo[ $hitinfo{$name} ] } ];\n                        if ( !defined $info\n                            || $info->[0] ne $name )\n                        {\n                            $self->warn(\n\"Somehow the Model table order does not match the order in the domains (got \"\n                                  . $info->[0]\n                                  . \", expected $name). We're back loading this from the alignment information instead\"\n                            );\n                            $info = [\n                                $name, '',\n                                /score\\s+([^,\\s]+),\\s+E\\s+=\\s+(\\S+)/ox\n                            ];\n                            push @hitinfo, $info;\n                            $hitinfo{$name} = $#hitinfo;\n                        }\n                        $self->start_element( { 'Name' => 'Hit' } );\n\n                        $self->element(\n                            {\n                                'Name' => 'Hit_id',\n                                'Data' => shift @{$info}\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hit_desc',\n                                'Data' => shift @{$info}\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hit_score',\n                                'Data' => shift @{$info}\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hit_signif',\n                                'Data' => shift @{$info}\n                            }\n                        );\n\n                        $self->start_element( { 'Name' => 'Hsp' } );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_identity',\n                                'Data' => 0\n                            }\n                        );                     \n                        $self->element(\n                            {\n                                'Name' => 'Hsp_positive',\n                                'Data' => 0\n                            }\n                        );\n                        my $HSPinfo = shift @hspinfo;\n                        my $id      = shift @$HSPinfo;\n\n                        if ( $id ne $name ) {\n                            $self->throw(\n\"Somehow the domain list details do not match the table (got $id, expected $name)\"\n                            );\n                        }\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_query-from',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_query-to',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_hit-from',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_hit-to',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_score',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_evalue',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $lastdomain = $name;\n                    }\n                    else {\n                        if (/^(\\s+\\*\\-\\>)(\\S+)/o) {\n\n                            # start of domain\n                            $prelength = CORE::length($1);\n                            $width     = 0;\n\n                            # deal with fact that start en stop is on same line\n                            my $data = $2;\n                            if ($data =~ s/\\<\\-?\\*?\\s*$//)\n                            {\n                              $width = CORE::length($data);\n                            }\n \n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_hseq',\n                                    'Data' => $data\n                                }\n                            );\n                            $count       = 0;\n                            $second_tier = 0;\n\n                        }\n                        elsif (/^(\\s+)(\\S+)\\<\\-?\\*?\\s*$/o) {\n\n                            #end of domain\n                            $prelength -= 3 unless ( $second_tier++ );\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_hseq',\n                                    'Data' => $2\n                                }\n                            );\n                            $width = CORE::length($2);\n                            $count = 0;\n                        }\n                        elsif (CORE::length($_) == 0\n                            || ( $count != 1 && /^\\s+$/o )\n                            || /^\\s+\\-?\\*\\s*$/ )\n                        {\n                            next;\n                        }\n                        elsif ( $count == 0 ) {\n                            $prelength -= 3 unless ( $second_tier++ );\n                            unless ( defined $prelength ) {\n\n                                # $self->warn(\"prelength not set\");\n                                next;\n                            }\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_hseq',\n                                    'Data' => substr( $_, $prelength )\n                                }\n                            );\n                        }\n                        elsif ( $count == 1 ) {\n                            if ( !defined $prelength ) {\n                                $self->warn(\"prelength not set\");\n                            }\n                            if ($width) {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_midline',\n                                        'Data' =>\n                                          substr( $_, $prelength, $width )\n                                    }\n                                );\n                            }\n                            else {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_midline',\n                                        'Data' => substr( $_, $prelength )\n                                    }\n                                );\n                            }\n                        }\n                        elsif ( $count == 2 ) {\n                            if (   /^\\s+(\\S+)\\s+(\\d+)\\s+(\\S+)\\s+(\\d+)/o\n                                || /^\\s+(\\S+)\\s+(\\-)\\s+(\\S*)\\s+(\\-)/o )\n                            {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_qseq',\n                                        'Data' => $3\n                                    }\n                                );\n                            }\n                            else {\n                                $self->throw(\n                                    \"unrecognized line ($count): $_\\n\");\n                            }\n                        }\n                        $count = 0 if $count++ >= 2;\n                    }\n                }\n            }\n            elsif ( /^Histogram/o || m!^//!o ) {\n\n                while ( my $HSPinfo = shift @hspinfo ) {\n                    my $id   = shift @$HSPinfo;\n                    my $info = [ @{ $hitinfo[ $hitinfo{$id} ] } ];\n                    next unless defined $info;\n                    $self->start_element( { 'Name' => 'Hit' } );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_id',\n                            'Data' => shift @{$info}\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_desc',\n                            'Data' => shift @{$info}\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_signif',\n                            'Data' => shift @{$info}\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_score',\n                            'Data' => shift @{$info}\n                        }\n                    );\n                    $self->start_element( { 'Name' => 'Hsp' } );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_query-from',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );                    \n                    $self->element(\n                        {\n                            'Name' => 'Hsp_query-to',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_hit-from',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_hit-to',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_score',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_evalue',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_identity',\n                            'Data' => 0\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_positive',\n                            'Data' => 0\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_positive',\n                            'Data' => 0\n                        }\n                    );\n                    $self->end_element( { 'Name' => 'Hsp' } );\n                    $self->end_element( { 'Name' => 'Hit' } );\n                }\n                @hitinfo = ();\n                %hitinfo = ();\n                last;\n            }\n            # uncomment to see missed lines with verbose on\n            #else {\n            #    $self->debug($_);\n            #}\n        }\n        $last = $_;\n    }\n    $self->end_element( { 'Name' => 'HMMER_Output' } ) unless !$seentop;\n    return $self->end_document();\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element {\n    my ( $self, $data ) = @_;\n\n    # we currently don't care about attributes\n    my $nm   = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    if ($type) {\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = sprintf( \"start_%s\", lc $type );\n            $self->_eventHandler->$func( $data->{'Attributes'} );\n        }\n        unshift @{ $self->{'_elements'} }, $type;\n    }\n    if ( defined $type\n        && $type eq 'result' )\n    {\n        $self->{'_values'} = {};\n        $self->{'_result'} = undef;\n    }\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ( $self, $data ) = @_;\n    my $nm   = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    my $rc;\n\n    if ( $nm eq 'HMMER_program' ) {\n        if ( $self->{'_last_data'} =~ /(HMM\\S+)/i ) {\n            $self->{'_reporttype'} = uc $1;\n        }\n    }\n\n    # Hsp are sort of weird, in that they end when another\n    # object begins so have to detect this in end_element for now\n    if ( $nm eq 'Hsp' ) {\n        foreach (qw(Hsp_qseq Hsp_midline Hsp_hseq)) {\n            my $data = $self->{'_last_hspdata'}->{$_};\n            if ($data && $_ eq 'Hsp_hseq') {\n                # replace hmm '.' gap symbol by '-'\n                $data =~ s/\\./-/g;\n            }\n            $self->element(\n                {\n                    'Name' => $_,\n                    'Data' => $data\n                }\n            );\n        }\n        $self->{'_last_hspdata'} = {};\n    }\n    if ($type) {\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = sprintf( \"end_%s\", lc $type );\n            $rc = $self->_eventHandler->$func( $self->{'_reporttype'},\n                $self->{'_values'} );\n        }\n        my $lastelem = shift @{ $self->{'_elements'} };\n    }\n    elsif ( $MAPPING{$nm} ) {\n        if ( ref( $MAPPING{$nm} ) =~ /hash/i ) {\n            my $key = ( keys %{ $MAPPING{$nm} } )[0];\n            $self->{'_values'}->{$key}->{ $MAPPING{$nm}->{$key} } =\n              $self->{'_last_data'};\n        }\n        else {\n            $self->{'_values'}->{ $MAPPING{$nm} } = $self->{'_last_data'};\n        }\n    }\n    else {\n        $self->debug(\"unknown nm $nm, ignoring\\n\");\n    }\n    $self->{'_last_data'} = '';    # remove read data if we are at\n                                   # end of an element\n    $self->{'_result'} = $rc if ( defined $type && $type eq 'result' );\n    return $rc;\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element {\n    my ( $self, $data ) = @_;\n    $self->start_element($data);\n    $self->characters($data);\n    $self->end_element($data);\n}\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string\n\n\n\nsub characters {\n    my ( $self, $data ) = @_;\n\n    if (   $self->in_element('hsp')\n        && $data->{'Name'} =~ /Hsp\\_(qseq|hseq|midline)/o\n        && defined $data->{'Data'} )\n    {\n        $self->{'_last_hspdata'}->{ $data->{'Name'} } .= $data->{'Data'};\n    }\n    return unless ( defined $data->{'Data'} && $data->{'Data'} !~ /^\\s+$/o );\n\n    $self->{'_last_data'} = $data->{'Data'};\n}\n\n=head2 within_element\n\n Title   : within_element\n Usage   : if( $eventgenerator->within_element($element) ) {}\n Function: Test if we are within a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name \n\n\n\nsub within_element {\n    my ( $self, $name ) = @_;\n    return 0\n      if ( !defined $name\n        || !defined $self->{'_elements'}\n        || scalar @{ $self->{'_elements'} } == 0 );\n    foreach ( @{ $self->{'_elements'} } ) {\n        return 1 if ( $_ eq $name );\n    }\n    return 0;\n}\n\n=head2 in_element\n\n Title   : in_element\n Usage   : if( $eventgenerator->in_element($element) ) {}\n Function: Test if we are in a particular element\n           This is different than 'within' because 'in' only \n           tests its immediete parent.\n Returns : boolean\n Args    : string element name \n\n\n\nsub in_element {\n    my ( $self, $name ) = @_;\n    return 0 if !defined $self->{'_elements'}->[0];\n    return ( $self->{'_elements'}->[0] eq $name );\n}\n\n=head2 start_document\n\n Title   : start_document\n Usage   : $eventgenerator->start_document\n Function: Handle a start document event\n Returns : none\n Args    : none"},"detail":"($self)","name":"start_document","range":{"start":{"character":0,"line":1268},"end":{"line":1274,"character":9999}}},{"kind":12,"line":1287,"children":[{"kind":13,"line":1288,"definition":"my","name":"$self","containerName":"end_document","localvar":"my"},{"line":1289,"kind":13,"name":"$self","containerName":"end_document"}],"containerName":"main::","definition":"sub","detail":"($self)","signature":{"documentation":"1;\n# $Id: hmmer.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::hmmer\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::hmmer - A parser for HMMER output (hmmpfam, hmmsearch)\n\n=head1 SYNOPSIS\n\n    # do not use this class directly it is available through Bio::SearchIO\n    use Bio::SearchIO;\n    my $in = Bio::SearchIO->new(-format => 'hmmer',\n                               -file   => 't/data/L77119.hmmer');\n    while( my $result = $in->next_result ) {\n        # this is a Bio::Search::Result::HMMERResult object\n        print $result->query_name(), \" for HMM \", $result->hmm_name(), \"\\n\";\n        while( my $hit = $result->next_hit ) {\n            print $hit->name(), \"\\n\";\n            while( my $hsp = $hit->next_hsp ) {\n                print \"length is \", $hsp->length(), \"\\n\";\n            }\n        }\n    }\n\n=head1 DESCRIPTION\n\nThis object implements a parser for HMMER output.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::hmmer;\n\nuse strict;\n\nuse Bio::Factory::ObjectFactory;\n\nuse vars qw(%MAPPING %MODEMAP\n);\n\nuse base qw(Bio::SearchIO);\n\nBEGIN {\n\n    # mapping of HMMER items to Bioperl hash keys\n    %MODEMAP = (\n        'HMMER_Output' => 'result',\n        'Hit'          => 'hit',\n        'Hsp'          => 'hsp'\n    );\n\n    %MAPPING = (\n        'Hsp_bit-score'   => 'HSP-bits',\n        'Hsp_score'       => 'HSP-score',\n        'Hsp_evalue'      => 'HSP-evalue',\n        'Hsp_query-from'  => 'HSP-query_start',\n        'Hsp_query-to'    => 'HSP-query_end',\n        'Hsp_hit-from'    => 'HSP-hit_start',\n        'Hsp_hit-to'      => 'HSP-hit_end',\n        'Hsp_positive'    => 'HSP-conserved',\n        'Hsp_identity'    => 'HSP-identical',\n        'Hsp_gaps'        => 'HSP-hsp_gaps',\n        'Hsp_hitgaps'     => 'HSP-hit_gaps',\n        'Hsp_querygaps'   => 'HSP-query_gaps',\n        'Hsp_qseq'        => 'HSP-query_seq',\n        'Hsp_hseq'        => 'HSP-hit_seq',\n        'Hsp_midline'     => 'HSP-homology_seq',\n        'Hsp_align-len'   => 'HSP-hsp_length',\n        'Hsp_query-frame' => 'HSP-query_frame',\n        'Hsp_hit-frame'   => 'HSP-hit_frame',\n\n        'Hit_id'        => 'HIT-name',\n        'Hit_len'       => 'HIT-length',\n        'Hit_accession' => 'HIT-accession',\n        'Hit_desc'      => 'HIT-description',\n        'Hit_signif'    => 'HIT-significance',\n        'Hit_score'     => 'HIT-score',\n\n        'HMMER_program'   => 'RESULT-algorithm_name',\n        'HMMER_version'   => 'RESULT-algorithm_version',\n        'HMMER_query-def' => 'RESULT-query_name',\n        'HMMER_query-len' => 'RESULT-query_length',\n        'HMMER_query-acc' => 'RESULT-query_accession',\n        'HMMER_querydesc' => 'RESULT-query_description',\n        'HMMER_hmm'       => 'RESULT-hmm_name',\n        'HMMER_seqfile'   => 'RESULT-sequence_file',\n        'HMMER_db'        => 'RESULT-database_name',\n    );\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::hmmer->new();\n Function: Builds a new Bio::SearchIO::hmmer object \n Returns : Bio::SearchIO::hmmer\n Args    : -fh/-file => HMMER filename\n           -format   => 'hmmer'\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n    my $handler = $self->_eventHandler;\n    $handler->register_factory(\n        'result',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Result::HMMERResult',\n            -interface => 'Bio::Search::Result::ResultI'\n        )\n    );\n\n    $handler->register_factory(\n        'hit',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Hit::HMMERHit',\n            -interface => 'Bio::Search::Hit::HitI'\n        )\n    );\n\n    $handler->register_factory(\n        'hsp',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::HSP::HMMERHSP',\n            -interface => 'Bio::Search::HSP::HSPI'\n        )\n    );\n    $self->{'_hmmidline'} = 'HMMER 2.2g (August 2001)';\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    my $seentop = 0;\n    my $reporttype;\n    my ( $last, @hitinfo, @hspinfo, %hspinfo, %hitinfo );\n    local $/ = \"\\n\";\n    local $_;\n\n    my $verbose = $self->verbose;    # cache for speed?\n    $self->start_document();\n    local ($_);\n    while ( defined( $_ = $self->_readline ) ) {\n        my $lineorig = $_;\n        chomp;\n        if (/^HMMER\\s+(\\S+)\\s+\\((.+)\\)/o) {\n            my ( $prog, $version ) = split;\n            if ($seentop) {\n                $self->_pushback($_);\n                $self->end_element( { 'Name' => 'HMMER_Output' } );\n                return $self->end_document();\n            }\n            $self->{'_hmmidline'} = $_;\n            $self->start_element( { 'Name' => 'HMMER_Output' } );\n            $self->{'_result_count'}++;\n            $seentop = 1;\n            if ( defined $last ) {\n                ($reporttype) = split( /\\s+/, $last );\n                $self->element(\n                    {\n                        'Name' => 'HMMER_program',\n                        'Data' => uc($reporttype)\n                    }\n                );\n            }\n            $self->element(\n                {\n                    'Name' => 'HMMER_version',\n                    'Data' => $version\n                }\n            );\n        }\n        elsif (s/^HMM file:\\s+//o) {\n            $self->{'_hmmfileline'} = $lineorig;\n            $self->element(\n                {\n                    'Name' => 'HMMER_hmm',\n                    'Data' => $_\n                }\n            );\n        }\n        elsif (s/^Sequence\\s+(file|database):\\s+//o) {\n            $self->{'_hmmseqline'} = $lineorig;\n            if ( $1 eq 'database' ) {\n                $self->element(\n                    {\n                        'Name' => 'HMMER_db',\n                        'Data' => $_\n                    }\n                );\n            }\n            $self->element(\n                {\n                    'Name' => 'HMMER_seqfile',\n                    'Data' => $_\n                }\n            );\n        }\n        elsif (s/^Query(\\s+(sequence|HMM))?(?:\\s+\\d+)?:\\s+//o) {\n            if ( !$seentop ) {\n\n                # we're in a multi-query report\n                $self->_pushback( $self->{'_hmmidline'} );\n                $self->_pushback( $self->{'_hmmfileline'} );\n                $self->_pushback( $self->{'_hmmseqline'} );\n                $self->_pushback($lineorig);\n                next;\n            }\n            s/\\s+$//;\n            $self->element(\n                {\n                    'Name' => 'HMMER_query-def',\n                    'Data' => $_\n                }\n            );\n        }\n        elsif (s/^Accession:\\s+//o) {\n            s/\\s+$//;\n            $self->element(\n                {\n                    'Name' => 'HMMER_query-acc',\n                    'Data' => $_\n                }\n            );\n        }\n        elsif (s/^Description:\\s+//o) {\n            s/\\s+$//;\n            $self->element(\n                {\n                    'Name' => 'HMMER_querydesc',\n                    'Data' => $_\n                }\n            );\n        }\n        elsif ( defined $self->{'_reporttype'}\n            && $self->{'_reporttype'} eq 'HMMSEARCH' )\n        {\n\n            # PROCESS HMMSEARCH RESULTS HERE\n            if (/^Scores for complete sequences/o) {\n                while ( defined( $_ = $self->_readline ) ) {\n                    last if (/^\\s+$/);\n                    next if ( /^Sequence\\s+Description/o || /^\\-\\-\\-/o );\n                    my @line = split;\n                    my ( $name, $n, $evalue, $score ) =\n                      ( shift @line, pop @line, pop @line, pop @line );\n                    my $desc = join( ' ', @line );\n                    push @hitinfo, [ $name, $desc, $evalue, $score ];\n                    $hitinfo{$name} = $#hitinfo;\n                }\n            }\n            elsif (/^Parsed for domains:/o) {\n                @hspinfo = ();\n\n                while ( defined( $_ = $self->_readline ) ) {\n                    last if (/^\\s+$/);\n                    if (m!^//!) {\n                        $self->_pushback($_);\n                        last;\n                    }\n                    next if ( /^(Model|Sequence)\\s+Domain/ || /^\\-\\-\\-/ );\n\n                    chomp;\n                    if (\n                        my ( $n, $domainnum, $domainct, @vals ) = (\n                            m!^(\\S+)\\s+      # host name\n\t\t\t(\\d+)/(\\d+)\\s+   # num/num (ie 1 of 2) \n\t\t\t(\\d+)\\s+(\\d+).+? # sequence start and end\n\t\t\t(\\d+)\\s+(\\d+)\\s+ # hmm start and end\n\t\t\t\\S+\\s+           # []\n\t\t\t(\\S+)\\s+         # score\n\t\t\t(\\S+)            # evalue\n\t\t\t\\s*$!ox\n                        )\n                      )\n                    {\n\n                        # array lookup so that we can get rid of things\n                        # when they've been processed\n                        my $info = $hitinfo[ $hitinfo{$n} ];\n                        if ( !defined $info ) {\n                            $self->warn(\n\"Incomplete Sequence information, can't find $n hitinfo says $hitinfo{$n}\"\n                            );\n                            next;\n                        }\n                        push @hspinfo, [ $n, @vals ];\n                    }\n                }\n            }\n            elsif (/^Alignments of top/o) {\n                my ( $prelength, $lastdomain, $count, $width );\n                $count = 0;\n                my %domaincounter;\n                my $second_tier = 0;\n                while ( defined( $_ = $self->_readline ) ) {\n                    next if ( /^Align/o\n                        || /^\\s+RF\\s+[x\\s]+$/o );\n                    if ( /^Histogram/o || m!^//!o ) {\n                        if ( $self->in_element('hsp') ) {\n                            $self->end_element( { 'Name' => 'Hsp' } );\n                        }\n                        if ( $self->within_element('hit') ) {\n                            $self->end_element( { 'Name' => 'Hit' } );\n                        }\n                        last;\n                    }\n                    chomp;\n\n                    if (\n                        m/^\\s*(.+):\\s+domain\\s+(\\d+)\\s+of\\s+(\\d+)\\,\\s+\n                        from\\s+(\\d+)\\s+to\\s+(\\d+)/x\n                      )\n                    {\n                        my ( $name, $domainct, $domaintotal, $from, $to ) =\n                          ( $1, $2, $3, $4, $5 );\n                        $domaincounter{$name}++;\n                        if ( $self->within_element('hit') ) {\n                            if ( $self->within_element('hsp') ) {\n                                $self->end_element( { 'Name' => 'Hsp' } );\n                            }\n                            $self->end_element( { 'Name' => 'Hit' } );\n                        }\n\n                        $self->start_element( { 'Name' => 'Hit' } );\n                        my $info = [\n                            @{\n                                $hitinfo[ $hitinfo{$name} ] || $self->throw(\n\"Could not find hit info for $name: Insure that your database contains only unique sequence names\"\n                                )\n                              }\n                        ];\n                        if ( $info->[0] ne $name ) {\n                            $self->throw(\n\"Somehow the Model table order does not match the order in the domains (got \"\n                                  . $info->[0]\n                                  . \", expected $name)\" );\n                        }\n                        $self->element(\n                            {\n                                'Name' => 'Hit_id',\n                                'Data' => shift @{$info}\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hit_desc',\n                                'Data' => shift @{$info}\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hit_signif',\n                                'Data' => shift @{$info}\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hit_score',\n                                'Data' => shift @{$info}\n                            }\n                        );\n\n                        $self->start_element( { 'Name' => 'Hsp' } );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_identity',\n                                'Data' => 0\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_positive',\n                                'Data' => 0\n                            }\n                        );\n                        my $HSPinfo = shift @hspinfo;\n                        my $id      = shift @$HSPinfo;\n\n                        if ( $id ne $name ) {\n                            $self->throw(\n\"Somehow the domain list details do not match the table (got $id, expected $name)\"\n                            );\n                        }\n                        if ( $domaincounter{$name} == $domaintotal ) {\n                            $hitinfo[ $hitinfo{$name} ] = undef;\n                        }\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_hit-from',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_hit-to',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_query-from',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_query-to',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_score',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_evalue',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $lastdomain = $name;\n                    }\n                    else {\n\n                        # Might want to change this so that it\n                        # accumulates all the of the alignment lines into\n                        # three array slots and then tests for the\n                        # end of the line\n                        if (/^(\\s+\\*\\-\\>)(\\S+)/o) {    # start of domain\n                            $prelength = CORE::length($1);\n                            $width     = 0;\n\n                            # deal with fact that start en stop is on same line\n                            my $data = $2;\n                            if ($data =~ s/\\<\\-?\\*?\\s*$//)\n                            {\n                                $width = CORE::length($data);\n                            }\n \n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_qseq',\n                                    'Data' => $data\n                                }\n                            );\n                            $count       = 0;\n                            $second_tier = 0;\n                        }\n                        elsif (/^(\\s+)(\\S+)\\<\\-\\*\\s*$/o) {    #end of domain\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_qseq',\n                                    'Data' => $2\n                                }\n                            );\n                            $width = CORE::length($2);\n                            $count = 0;\n                        }\n                        elsif (( $count != 1 && /^\\s+$/o )\n                            || CORE::length($_) == 0\n                            || /^\\s+\\-?\\*\\s*$/ )\n                        {\n                            next;\n                        }\n                        elsif ( $count == 0 ) {\n                            $prelength -= 3 unless ( $second_tier++ );\n                            unless ( defined $prelength ) {\n\n                                # $self->warn(\"prelength not set\");\n                                next;\n                            }\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_qseq',\n                                    'Data' => substr( $_, $prelength )\n                                }\n                            );\n                        }\n                        elsif ( $count == 1 ) {\n                            if ( !defined $prelength ) {\n                                $self->warn(\"prelength not set\");\n                            }\n                            if ($width) {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_midline',\n                                        'Data' =>\n                                          substr( $_, $prelength, $width )\n                                    }\n                                );\n                            }\n                            else {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_midline',\n                                        'Data' => substr( $_, $prelength )\n                                    }\n                                );\n                            }\n                        }\n                        elsif ( $count == 2 ) {\n                            if (/^\\s+(\\S+)\\s+(\\d+|\\-)\\s+(\\S*)\\s+(\\d+|\\-)/o) {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_hseq',\n                                        'Data' => $3\n                                    }\n                                );\n                            }\n                            else {\n                                $self->warn(\"unrecognized line: $_\\n\");\n                            }\n                        }\n                        $count = 0 if $count++ >= 2;\n                    }\n                }\n            }\n            elsif ( /^Histogram/o || m!^//!o ) {\n                while ( my $HSPinfo = shift @hspinfo ) {\n                    my $id   = shift @$HSPinfo;\n                    my $info = [ @{ $hitinfo[ $hitinfo{$id} ] } ];\n                    next unless defined $info;\n                    $self->start_element( { 'Name' => 'Hit' } );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_id',\n                            'Data' => shift @{$info}\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_desc',\n                            'Data' => shift @{$info}\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_signif',\n                            'Data' => shift @{$info}\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_score',\n                            'Data' => shift @{$info}\n                        }\n                    );\n                    $self->start_element( { 'Name' => 'Hsp' } );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_query-from',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_query-to',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_hit-from',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_hit-to',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_score',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_evalue',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_identity',\n                            'Data' => 0\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_positive',\n                            'Data' => 0\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_positive',\n                            'Data' => 0\n                        }\n                    );\n                    $self->end_element( { 'Name' => 'Hsp' } );\n                    $self->end_element( { 'Name' => 'Hit' } );\n                }\n                @hitinfo = ();\n                %hitinfo = ();\n                last;\n            }\n        }\n        elsif ( defined $self->{'_reporttype'}\n            && $self->{'_reporttype'} eq 'HMMPFAM' )\n        {\n            # process HMMPFAM results here\n            if (/^Scores for sequence family/o) {\n                while ( defined( $_ = $self->_readline ) ) {\n                    last if (/^\\s+$/);\n                    next if ( /^Model\\s+Description/o || /^\\-\\-\\-/o );\n                    chomp;\n                    my @line = split;\n                    my ( $model, $n, $evalue, $score ) =\n                      ( shift @line, pop @line, pop @line, pop @line );\n                    my $desc = join( ' ', @line );\n                    push @hitinfo, [ $model, $desc, $score, $evalue, $n ];\n                    $hitinfo{$model} = $#hitinfo;\n                }\n            }\n            elsif (/^Parsed for domains:/o) {\n                @hspinfo = ();\n                while ( defined( $_ = $self->_readline ) ) {\n                    last if (/^\\s+$/);\n                    if (m!^//!) {\n                        $self->_pushback($_);\n                        last;\n                    }\n                    next if ( /^Model\\s+Domain/o || /^\\-\\-\\-/o );\n                    chomp;\n                    if (\n                        my ( $n, $domainnum, $domainct, @vals ) = (\n                            m!^(\\S+)\\s+         # domain name\n                            (\\d+)/(\\d+)\\s+      # domain num out of num\n                            (\\d+)\\s+(\\d+).+?    # seq start, end\n                            (\\d+)\\s+(\\d+)\\s+    # hmm start, end\n                            \\S+\\s+              # []\n                            (\\S+)\\s+            # score       \n                            (\\S+)               # evalue\n                            \\s*$!ox\n                        )\n                      )\n                    {\n                        my $hindex = $hitinfo{$n};\n                        if ( !defined $hindex ) {\n                            push @hitinfo,\n                              [ $n, '', $vals[5], $vals[6], $domainct ];\n                            $hitinfo{$n} = $#hitinfo;\n                            $hindex = $#hitinfo;\n                        }\n                        my $info = $hitinfo[$hindex];\n                        if ( !defined $info ) {\n                            $self->warn(\n\"incomplete Domain information, can't find $n hitinfo says $hitinfo{$n}\"\n                            );\n                            next;\n                        }\n                        push @hspinfo, [ $n, @vals ];\n                    }\n                }\n            }\n            elsif (/^Alignments of top/o) {\n                my ( $prelength, $lastdomain, $count, $width );\n                $count = 0;\n                my $second_tier = 0;\n                while ( defined( $_ = $self->_readline ) ) {\n                    next\n                      if (\n                        /^Align/o\n                        || ( $count != 1\n                            && /^\\s+RF\\s+[x\\s]+$/o )\n                      );\n                    # fix for bug 2632\n                    next if ($_ =~ m/^\\s+CS\\s+/o && $count == 0);\n                    if ( /^Histogram/o || m!^//!o || /^Query sequence/o ) {\n                        if ( $self->in_element('hsp') ) {\n                            $self->end_element( { 'Name' => 'Hsp' } );\n                        }\n                        if ( $self->in_element('hit') ) {\n                            $self->end_element( { 'Name' => 'Hit' } );\n                        }\n                        $self->_pushback($_);\n                        last;\n                    }\n                    chomp;\n                    if (m/(\\S+):.*from\\s+(\\d+)\\s+to\\s+(\\d+)/o) {\n                        my ( $name, $from, $to ) = ( $1, $2, $3 );\n\n                        if ( $self->within_element('hit') ) {\n                            if ( $self->in_element('hsp') ) {\n                                $self->end_element( { 'Name' => 'Hsp' } );\n                            }\n                            $self->end_element( { 'Name' => 'Hit' } );\n                        }\n                        my $info = [ @{ $hitinfo[ $hitinfo{$name} ] } ];\n                        if ( !defined $info\n                            || $info->[0] ne $name )\n                        {\n                            $self->warn(\n\"Somehow the Model table order does not match the order in the domains (got \"\n                                  . $info->[0]\n                                  . \", expected $name). We're back loading this from the alignment information instead\"\n                            );\n                            $info = [\n                                $name, '',\n                                /score\\s+([^,\\s]+),\\s+E\\s+=\\s+(\\S+)/ox\n                            ];\n                            push @hitinfo, $info;\n                            $hitinfo{$name} = $#hitinfo;\n                        }\n                        $self->start_element( { 'Name' => 'Hit' } );\n\n                        $self->element(\n                            {\n                                'Name' => 'Hit_id',\n                                'Data' => shift @{$info}\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hit_desc',\n                                'Data' => shift @{$info}\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hit_score',\n                                'Data' => shift @{$info}\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hit_signif',\n                                'Data' => shift @{$info}\n                            }\n                        );\n\n                        $self->start_element( { 'Name' => 'Hsp' } );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_identity',\n                                'Data' => 0\n                            }\n                        );                     \n                        $self->element(\n                            {\n                                'Name' => 'Hsp_positive',\n                                'Data' => 0\n                            }\n                        );\n                        my $HSPinfo = shift @hspinfo;\n                        my $id      = shift @$HSPinfo;\n\n                        if ( $id ne $name ) {\n                            $self->throw(\n\"Somehow the domain list details do not match the table (got $id, expected $name)\"\n                            );\n                        }\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_query-from',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_query-to',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_hit-from',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_hit-to',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_score',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_evalue',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $lastdomain = $name;\n                    }\n                    else {\n                        if (/^(\\s+\\*\\-\\>)(\\S+)/o) {\n\n                            # start of domain\n                            $prelength = CORE::length($1);\n                            $width     = 0;\n\n                            # deal with fact that start en stop is on same line\n                            my $data = $2;\n                            if ($data =~ s/\\<\\-?\\*?\\s*$//)\n                            {\n                              $width = CORE::length($data);\n                            }\n \n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_hseq',\n                                    'Data' => $data\n                                }\n                            );\n                            $count       = 0;\n                            $second_tier = 0;\n\n                        }\n                        elsif (/^(\\s+)(\\S+)\\<\\-?\\*?\\s*$/o) {\n\n                            #end of domain\n                            $prelength -= 3 unless ( $second_tier++ );\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_hseq',\n                                    'Data' => $2\n                                }\n                            );\n                            $width = CORE::length($2);\n                            $count = 0;\n                        }\n                        elsif (CORE::length($_) == 0\n                            || ( $count != 1 && /^\\s+$/o )\n                            || /^\\s+\\-?\\*\\s*$/ )\n                        {\n                            next;\n                        }\n                        elsif ( $count == 0 ) {\n                            $prelength -= 3 unless ( $second_tier++ );\n                            unless ( defined $prelength ) {\n\n                                # $self->warn(\"prelength not set\");\n                                next;\n                            }\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_hseq',\n                                    'Data' => substr( $_, $prelength )\n                                }\n                            );\n                        }\n                        elsif ( $count == 1 ) {\n                            if ( !defined $prelength ) {\n                                $self->warn(\"prelength not set\");\n                            }\n                            if ($width) {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_midline',\n                                        'Data' =>\n                                          substr( $_, $prelength, $width )\n                                    }\n                                );\n                            }\n                            else {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_midline',\n                                        'Data' => substr( $_, $prelength )\n                                    }\n                                );\n                            }\n                        }\n                        elsif ( $count == 2 ) {\n                            if (   /^\\s+(\\S+)\\s+(\\d+)\\s+(\\S+)\\s+(\\d+)/o\n                                || /^\\s+(\\S+)\\s+(\\-)\\s+(\\S*)\\s+(\\-)/o )\n                            {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_qseq',\n                                        'Data' => $3\n                                    }\n                                );\n                            }\n                            else {\n                                $self->throw(\n                                    \"unrecognized line ($count): $_\\n\");\n                            }\n                        }\n                        $count = 0 if $count++ >= 2;\n                    }\n                }\n            }\n            elsif ( /^Histogram/o || m!^//!o ) {\n\n                while ( my $HSPinfo = shift @hspinfo ) {\n                    my $id   = shift @$HSPinfo;\n                    my $info = [ @{ $hitinfo[ $hitinfo{$id} ] } ];\n                    next unless defined $info;\n                    $self->start_element( { 'Name' => 'Hit' } );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_id',\n                            'Data' => shift @{$info}\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_desc',\n                            'Data' => shift @{$info}\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_signif',\n                            'Data' => shift @{$info}\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_score',\n                            'Data' => shift @{$info}\n                        }\n                    );\n                    $self->start_element( { 'Name' => 'Hsp' } );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_query-from',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );                    \n                    $self->element(\n                        {\n                            'Name' => 'Hsp_query-to',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_hit-from',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_hit-to',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_score',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_evalue',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_identity',\n                            'Data' => 0\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_positive',\n                            'Data' => 0\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_positive',\n                            'Data' => 0\n                        }\n                    );\n                    $self->end_element( { 'Name' => 'Hsp' } );\n                    $self->end_element( { 'Name' => 'Hit' } );\n                }\n                @hitinfo = ();\n                %hitinfo = ();\n                last;\n            }\n            # uncomment to see missed lines with verbose on\n            #else {\n            #    $self->debug($_);\n            #}\n        }\n        $last = $_;\n    }\n    $self->end_element( { 'Name' => 'HMMER_Output' } ) unless !$seentop;\n    return $self->end_document();\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element {\n    my ( $self, $data ) = @_;\n\n    # we currently don't care about attributes\n    my $nm   = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    if ($type) {\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = sprintf( \"start_%s\", lc $type );\n            $self->_eventHandler->$func( $data->{'Attributes'} );\n        }\n        unshift @{ $self->{'_elements'} }, $type;\n    }\n    if ( defined $type\n        && $type eq 'result' )\n    {\n        $self->{'_values'} = {};\n        $self->{'_result'} = undef;\n    }\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ( $self, $data ) = @_;\n    my $nm   = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    my $rc;\n\n    if ( $nm eq 'HMMER_program' ) {\n        if ( $self->{'_last_data'} =~ /(HMM\\S+)/i ) {\n            $self->{'_reporttype'} = uc $1;\n        }\n    }\n\n    # Hsp are sort of weird, in that they end when another\n    # object begins so have to detect this in end_element for now\n    if ( $nm eq 'Hsp' ) {\n        foreach (qw(Hsp_qseq Hsp_midline Hsp_hseq)) {\n            my $data = $self->{'_last_hspdata'}->{$_};\n            if ($data && $_ eq 'Hsp_hseq') {\n                # replace hmm '.' gap symbol by '-'\n                $data =~ s/\\./-/g;\n            }\n            $self->element(\n                {\n                    'Name' => $_,\n                    'Data' => $data\n                }\n            );\n        }\n        $self->{'_last_hspdata'} = {};\n    }\n    if ($type) {\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = sprintf( \"end_%s\", lc $type );\n            $rc = $self->_eventHandler->$func( $self->{'_reporttype'},\n                $self->{'_values'} );\n        }\n        my $lastelem = shift @{ $self->{'_elements'} };\n    }\n    elsif ( $MAPPING{$nm} ) {\n        if ( ref( $MAPPING{$nm} ) =~ /hash/i ) {\n            my $key = ( keys %{ $MAPPING{$nm} } )[0];\n            $self->{'_values'}->{$key}->{ $MAPPING{$nm}->{$key} } =\n              $self->{'_last_data'};\n        }\n        else {\n            $self->{'_values'}->{ $MAPPING{$nm} } = $self->{'_last_data'};\n        }\n    }\n    else {\n        $self->debug(\"unknown nm $nm, ignoring\\n\");\n    }\n    $self->{'_last_data'} = '';    # remove read data if we are at\n                                   # end of an element\n    $self->{'_result'} = $rc if ( defined $type && $type eq 'result' );\n    return $rc;\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element {\n    my ( $self, $data ) = @_;\n    $self->start_element($data);\n    $self->characters($data);\n    $self->end_element($data);\n}\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string\n\n\n\nsub characters {\n    my ( $self, $data ) = @_;\n\n    if (   $self->in_element('hsp')\n        && $data->{'Name'} =~ /Hsp\\_(qseq|hseq|midline)/o\n        && defined $data->{'Data'} )\n    {\n        $self->{'_last_hspdata'}->{ $data->{'Name'} } .= $data->{'Data'};\n    }\n    return unless ( defined $data->{'Data'} && $data->{'Data'} !~ /^\\s+$/o );\n\n    $self->{'_last_data'} = $data->{'Data'};\n}\n\n=head2 within_element\n\n Title   : within_element\n Usage   : if( $eventgenerator->within_element($element) ) {}\n Function: Test if we are within a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name \n\n\n\nsub within_element {\n    my ( $self, $name ) = @_;\n    return 0\n      if ( !defined $name\n        || !defined $self->{'_elements'}\n        || scalar @{ $self->{'_elements'} } == 0 );\n    foreach ( @{ $self->{'_elements'} } ) {\n        return 1 if ( $_ eq $name );\n    }\n    return 0;\n}\n\n=head2 in_element\n\n Title   : in_element\n Usage   : if( $eventgenerator->in_element($element) ) {}\n Function: Test if we are in a particular element\n           This is different than 'within' because 'in' only \n           tests its immediete parent.\n Returns : boolean\n Args    : string element name \n\n\n\nsub in_element {\n    my ( $self, $name ) = @_;\n    return 0 if !defined $self->{'_elements'}->[0];\n    return ( $self->{'_elements'}->[0] eq $name );\n}\n\n=head2 start_document\n\n Title   : start_document\n Usage   : $eventgenerator->start_document\n Function: Handle a start document event\n Returns : none\n Args    : none\n\n\n\nsub start_document {\n    my ($self) = @_;\n    $self->{'_lasttype'} = '';\n    $self->{'_values'}   = {};\n    $self->{'_result'}   = undef;\n    $self->{'_elements'} = [];\n}\n\n=head2 end_document\n\n Title   : end_document\n Usage   : $eventgenerator->end_document\n Function: Handles an end document event\n Returns : Bio::Search::Result::ResultI object\n Args    : none","parameters":[{"label":"$self"}],"label":"end_document($self)"},"name":"end_document","range":{"end":{"character":9999,"line":1290},"start":{"character":0,"line":1287}}},{"definition":"sub","name":"result_count","containerName":"main::","range":{"end":{"character":9999,"line":1306},"start":{"line":1303,"character":0}},"kind":12,"children":[{"kind":13,"line":1304,"containerName":"result_count","definition":"my","name":"$self","localvar":"my"},{"name":"$self","containerName":"result_count","line":1305,"kind":13}],"line":1303}]}