{"vars":[{"line":84,"kind":2,"containerName":"","name":"vars"},{"containerName":null,"name":"$IDLENGTH","kind":13,"line":97},{"line":97,"kind":2,"name":"ObjectFactory","containerName":"strict::Bio::Factory"},{"line":100,"kind":13,"name":"%MODEMAP","containerName":null},{"name":"%MAPPING","containerName":null,"kind":13,"line":109},{"containerName":"","name":"base","kind":2,"line":166},{"definition":"sub","containerName":"main::","signature":{"label":"_initialize($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: fasta.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::fasta\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::fasta - A SearchIO parser for FASTA results\n\n=head1 SYNOPSIS\n\n  # Do not use this object directly, use it through the SearchIO system\n   use Bio::SearchIO;\n   my $searchio = Bio::SearchIO->new(-format => 'fasta',\n                    -file   => 'report.FASTA');\n   while( my $result = $searchio->next_result ) {\n    # ... do what you would normally doi with Bio::SearchIO.\n   }\n\n=head1 DESCRIPTION\n\nThis object contains the event based parsing code for FASTA format\nreports.  It creates L<Bio::Search::HSP::FastaHSP> objects instead of\nL<Bio::Search::HSP::GenericHSP> for the HSP objects. \n\nThis module will parse -m 9 -d 0 output as well as default m 1 output\nfrom FASTA as well as SSEARCH.\n\nAlso see the SearchIO HOWTO:\nL<http://bioperl.open-bio.org/wiki/HOWTO:SearchIO>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich, Aaron Mackey\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::fasta;\nuse vars qw(%MODEMAP %MAPPING $IDLENGTH);\nuse strict;\n\n# Object preamble - inherits from Bio::Root::RootI\n\nuse Bio::Factory::ObjectFactory;\n\nBEGIN {\n\n    # Set IDLENGTH to a new value if you have\n    # compile FASTA with a different ID length\n    # (actually newest FASTA allows the setting of this\n    #  via -C parameter, default is 6)\n    $IDLENGTH = 6;\n\n    # mapping of NCBI Blast terms to Bioperl hash keys\n    %MODEMAP = (\n        'FastaOutput' => 'result',\n        'Hit'         => 'hit',\n        'Hsp'         => 'hsp'\n    );\n\n    # This should really be done more intelligently, like with\n    # XSLT\n\n    %MAPPING = (\n        'Hsp_bit-score'   => 'HSP-bits',\n        'Hsp_score'       => 'HSP-score',\n        'Hsp_sw-score'    => 'HSP-swscore',\n        'Hsp_evalue'      => 'HSP-evalue',\n        'Hsp_query-from'  => 'HSP-query_start',\n        'Hsp_query-to'    => 'HSP-query_end',\n        'Hsp_hit-from'    => 'HSP-hit_start',\n        'Hsp_hit-to'      => 'HSP-hit_end',\n        'Hsp_positive'    => 'HSP-conserved',\n        'Hsp_identity'    => 'HSP-identical',\n        'Hsp_gaps'        => 'HSP-hsp_gaps',\n        'Hsp_hitgaps'     => 'HSP-hit_gaps',\n        'Hsp_querygaps'   => 'HSP-query_gaps',\n        'Hsp_qseq'        => 'HSP-query_seq',\n        'Hsp_hseq'        => 'HSP-hit_seq',\n        'Hsp_midline'     => 'HSP-homology_seq',\n        'Hsp_align-len'   => 'HSP-hsp_length',\n        'Hsp_query-frame' => 'HSP-query_frame',\n        'Hsp_hit-frame'   => 'HSP-hit_frame',\n\n        'Hit_id'        => 'HIT-name',\n        'Hit_len'       => 'HIT-length',\n        'Hit_accession' => 'HIT-accession',\n        'Hit_def'       => 'HIT-description',\n        'Hit_signif'    => 'HIT-significance',\n        'Hit_score'     => 'HIT-score',\n\n        'FastaOutput_program'   => 'RESULT-algorithm_name',\n        'FastaOutput_version'   => 'RESULT-algorithm_version',\n        'FastaOutput_query-def' => 'RESULT-query_name',\n        'FastaOutput_querydesc' => 'RESULT-query_description',\n        'FastaOutput_query-len' => 'RESULT-query_length',\n        'FastaOutput_db'        => 'RESULT-database_name',\n        'FastaOutput_db-len'    => 'RESULT-database_entries',\n        'FastaOutput_db-let'    => 'RESULT-database_letters',\n\n        'Parameters_matrix'      => { 'RESULT-parameters' => 'matrix' },\n        'Parameters_expect'      => { 'RESULT-parameters' => 'expect' },\n        'Parameters_include'     => { 'RESULT-parameters' => 'include' },\n        'Parameters_sc-match'    => { 'RESULT-parameters' => 'match' },\n        'Parameters_sc-mismatch' => { 'RESULT-parameters' => 'mismatch' },\n        'Parameters_gap-open'    => { 'RESULT-parameters' => 'gapopen' },\n        'Parameters_gap-ext'     => { 'RESULT-parameters' => 'gapext' },\n        'Parameters_word-size'   => { 'RESULT-parameters' => 'wordsize' },\n        'Parameters_ktup'        => { 'RESULT-parameters' => 'ktup' },\n        'Parameters_filter'      => { 'RESULT-parameters' => 'filter' },\n        'Statistics_db-num'      => { 'RESULT-statistics' => 'dbentries' },\n        'Statistics_db-len'      => { 'RESULT-statistics' => 'dbletters' },\n        'Statistics_hsp-len'     => { 'RESULT-statistics' => 'hsplength' },\n        'Statistics_eff-space'   => { 'RESULT-statistics' => 'effectivespace' },\n        'Statistics_kappa'       => { 'RESULT-statistics' => 'kappa' },\n        'Statistics_lambda'      => { 'RESULT-statistics' => 'lambda' },\n        'Statistics_entropy'     => { 'RESULT-statistics' => 'entropy' },\n    );\n}\n\nuse base qw(Bio::SearchIO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::fasta->new();\n Function: Builds a new Bio::SearchIO::fasta object \n Returns : Bio::SearchIO::fasta\n Args    : -idlength - set ID length to something other \n                       than the default (7), this is only\n                       necessary if you have compiled FASTA\n                       with a new default id length to display\n                       in the HSP alignment blocks"},"detail":"($self,@args)","kind":12,"children":[{"definition":"my","name":"$self","containerName":"_initialize","localvar":"my","kind":13,"line":183},{"name":"@args","containerName":"_initialize","line":183,"kind":13},{"containerName":"_initialize","name":"$self","kind":13,"line":184},{"name":"@args","containerName":"_initialize","line":184,"kind":13},{"containerName":"_initialize","name":"@args","kind":13,"line":185},{"definition":"my","name":"$idlength","containerName":"_initialize","localvar":"my","kind":13,"line":186},{"name":"$self","containerName":"_initialize","kind":13,"line":186},{"line":186,"kind":12,"name":"_rearrange","containerName":"_initialize"},{"name":"@args","containerName":"_initialize","kind":13,"line":186},{"name":"$self","containerName":"_initialize","kind":13,"line":187},{"name":"idlength","containerName":"_initialize","line":187,"kind":12},{"containerName":"_initialize","name":"$idlength","line":187,"kind":13},{"name":"$IDLENGTH","containerName":"_initialize","line":187,"kind":13},{"containerName":"_initialize","name":"$self","kind":13,"line":188},{"name":"_eventHandler","containerName":"_initialize","kind":12,"line":188},{"kind":12,"line":188,"name":"register_factory","containerName":"_initialize"},{"kind":12,"line":190,"name":"new","containerName":"_initialize"}],"line":182,"name":"_initialize","range":{"end":{"character":9999,"line":196},"start":{"line":182,"character":0}}},{"kind":12,"line":184,"containerName":"_initialize","name":"SUPER"},{"line":190,"kind":12,"name":"Bio","containerName":"Factory::ObjectFactory"},{"range":{"end":{"character":9999,"line":1352},"start":{"character":0,"line":208}},"name":"next_result","children":[{"line":209,"kind":13,"localvar":"my","containerName":"next_result","name":"$self","definition":"my"},{"line":213,"kind":13,"localvar":"my","definition":"my","name":"$data","containerName":"next_result"},{"line":214,"kind":13,"localvar":"my","containerName":"next_result","definition":"my","name":"$seentop"},{"kind":13,"line":215,"definition":"my","name":"$current_hsp","containerName":"next_result","localvar":"my"},{"name":"$self","containerName":"next_result","kind":13,"line":216},{"name":"start_document","containerName":"next_result","kind":12,"line":216},{"kind":13,"line":217,"name":"@hit_signifs","definition":"my","containerName":"next_result","localvar":"my"},{"kind":13,"line":218,"containerName":"next_result","name":"$self"},{"containerName":"next_result","name":"_readline","line":218,"kind":12},{"kind":13,"line":219,"name":"$self","containerName":"next_result"},{"kind":12,"line":219,"name":"in_element","containerName":"next_result"},{"name":"$self","containerName":"next_result","kind":13,"line":225},{"containerName":"next_result","name":"_readline","kind":12,"line":225},{"kind":13,"line":230,"containerName":"next_result","name":"$seentop"},{"line":231,"kind":13,"containerName":"next_result","name":"$self"},{"line":231,"kind":12,"containerName":"next_result","name":"_pushback"},{"containerName":"next_result","name":"$self","line":232,"kind":13},{"kind":12,"line":232,"containerName":"next_result","name":"end_element"},{"line":233,"kind":13,"containerName":"next_result","name":"$self"},{"line":233,"kind":12,"containerName":"next_result","name":"end_document"},{"name":"$self","containerName":"next_result","kind":13,"line":235},{"name":"$self","containerName":"next_result","line":236,"kind":13},{"containerName":"next_result","name":"start_element","line":236,"kind":12},{"line":237,"kind":13,"name":"$self","containerName":"next_result"},{"line":238,"kind":13,"containerName":"next_result","name":"$seentop"},{"containerName":"next_result","name":"$self","line":240,"kind":13},{"name":"element","containerName":"next_result","line":240,"kind":12},{"kind":13,"line":243,"name":"$self","containerName":"next_result"},{"containerName":"next_result","name":"$self","kind":13,"line":246},{"name":"_readline","containerName":"next_result","kind":12,"line":246},{"kind":13,"line":247,"containerName":"next_result","name":"$version","definition":"my","localvar":"my"},{"name":"$version","containerName":"next_result","line":248,"kind":13},{"line":248,"kind":13,"name":"$version","containerName":"next_result"},{"name":"$self","containerName":"next_result","line":249,"kind":13},{"name":"$version","containerName":"next_result","line":249,"kind":13},{"line":250,"kind":13,"containerName":"next_result","name":"$self"},{"line":250,"kind":12,"containerName":"next_result","name":"element"},{"line":254,"kind":13,"name":"$version","containerName":"next_result"},{"kind":13,"line":257,"containerName":"next_result","name":"$last","definition":"my","localvar":"my"},{"containerName":"next_result","name":"$leadin","kind":13,"line":257},{"line":257,"kind":13,"containerName":"next_result","name":"$type"},{"name":"$querylen","containerName":"next_result","kind":13,"line":257},{"kind":13,"line":257,"containerName":"next_result","name":"$querytype"},{"name":"$querydef","containerName":"next_result","line":257,"kind":13},{"kind":13,"line":259,"name":"$self","containerName":"next_result"},{"kind":12,"line":259,"name":"_readline","containerName":"next_result"},{"name":"$leadin","containerName":"next_result","line":269,"kind":13},{"line":269,"kind":13,"containerName":"next_result","name":"$querydef"},{"containerName":"next_result","name":"$leadin","kind":13,"line":270},{"name":"$querydef","containerName":"next_result","line":271,"kind":13},{"containerName":"next_result","name":"$querydef","kind":13,"line":274},{"kind":13,"line":274,"name":"$querylen","containerName":"next_result"},{"containerName":"next_result","name":"$querytype","line":274,"kind":13},{"name":"$last","containerName":"next_result","line":280,"kind":13},{"line":281,"kind":13,"containerName":"next_result","name":"$querylen"},{"line":281,"kind":13,"containerName":"next_result","name":"$querytype"},{"line":282,"kind":13,"name":"$querydef","containerName":"next_result"},{"line":288,"kind":13,"containerName":"next_result","name":"$last"},{"name":"$querydef","containerName":"next_result","kind":13,"line":289},{"kind":13,"line":289,"containerName":"next_result","name":"$querylen"},{"kind":13,"line":289,"containerName":"next_result","name":"$querytype"},{"containerName":"next_result","name":"$last","kind":13,"line":293},{"line":295,"kind":13,"containerName":"next_result","name":"$self"},{"kind":13,"line":296,"containerName":"next_result","name":"$self"},{"name":"$querytype","containerName":"next_result","line":298,"kind":13},{"name":"$self","containerName":"next_result","line":299,"kind":13},{"kind":13,"line":301,"containerName":"next_result","name":"$querytype"},{"name":"$self","containerName":"next_result","line":302,"kind":13},{"localvar":"my","definition":"my","name":"$name","containerName":"next_result","line":305,"kind":13},{"kind":13,"line":305,"containerName":"next_result","name":"$descr"},{"name":"$querydef","containerName":"next_result","kind":13,"line":305},{"kind":13,"line":306,"containerName":"next_result","name":"$self"},{"containerName":"next_result","name":"element","kind":12,"line":306},{"line":310,"kind":13,"containerName":"next_result","name":"$name"},{"name":"$self","containerName":"next_result","kind":13,"line":312},{"kind":12,"line":312,"containerName":"next_result","name":"element"},{"name":"$descr","containerName":"next_result","kind":13,"line":316},{"kind":13,"line":318,"name":"$querylen","containerName":"next_result"},{"name":"$self","containerName":"next_result","line":319,"kind":13},{"containerName":"next_result","name":"element","kind":12,"line":319},{"kind":13,"line":323,"containerName":"next_result","name":"$querylen"},{"line":327,"kind":13,"name":"$self","containerName":"next_result"},{"kind":12,"line":327,"name":"warn","containerName":"next_result"},{"name":"$last","containerName":"next_result","kind":13,"line":330},{"name":"$last","containerName":"next_result","line":331,"kind":13},{"containerName":"next_result","name":"$last","kind":13,"line":332},{"containerName":"next_result","name":"$self","line":338,"kind":13},{"containerName":"next_result","name":"_readline","kind":12,"line":338},{"name":"$self","containerName":"next_result","kind":13,"line":342},{"line":342,"kind":12,"containerName":"next_result","name":"element"},{"kind":13,"line":352,"name":"$self","containerName":"next_result"},{"kind":12,"line":352,"name":"_readline","containerName":"next_result"},{"name":"$self","containerName":"next_result","line":358,"kind":13},{"kind":12,"line":358,"containerName":"next_result","name":"element"},{"containerName":"next_result","name":"$self","line":364,"kind":13},{"name":"element","containerName":"next_result","line":364,"kind":12},{"name":"$self","containerName":"next_result","kind":13,"line":370},{"line":370,"kind":12,"containerName":"next_result","name":"element"},{"line":376,"kind":13,"containerName":"next_result","name":"$self"},{"name":"element","containerName":"next_result","kind":12,"line":376},{"name":"$self","containerName":"next_result","kind":13,"line":384},{"line":384,"kind":12,"containerName":"next_result","name":"element"},{"kind":13,"line":392,"containerName":"next_result","name":"$self"},{"kind":12,"line":392,"name":"element","containerName":"next_result"},{"kind":13,"line":400,"name":"$self","containerName":"next_result"},{"line":400,"kind":12,"containerName":"next_result","name":"element"},{"line":406,"kind":13,"containerName":"next_result","name":"$self"},{"kind":12,"line":406,"name":"element","containerName":"next_result"},{"kind":13,"line":412,"name":"$self","containerName":"next_result"},{"line":414,"kind":13,"name":"$self","containerName":"next_result"},{"containerName":"next_result","name":"element","kind":12,"line":414},{"kind":13,"line":417,"containerName":"next_result","name":"$self"},{"containerName":"next_result","definition":"my","name":"$rel","localvar":"my","kind":13,"line":422},{"line":423,"kind":13,"localvar":"my","containerName":"next_result","name":"@labels","definition":"my"},{"kind":13,"line":424,"containerName":"next_result","name":"@labels"},{"containerName":"next_result","name":"$self","kind":13,"line":427},{"line":427,"kind":12,"containerName":"next_result","name":"element"},{"containerName":"next_result","name":"@labels","kind":13,"line":434},{"name":"$rel","containerName":"next_result","kind":13,"line":434},{"containerName":"next_result","name":"$self","line":436,"kind":13},{"name":"_readline","containerName":"next_result","line":436,"kind":12},{"localvar":"my","definition":"my","name":"@line","containerName":"next_result","line":439,"kind":13},{"kind":13,"line":441,"name":"$line","containerName":"next_result"},{"kind":13,"line":441,"containerName":"next_result","name":"$labels"},{"name":"@labels","containerName":"next_result","kind":13,"line":444},{"localvar":"my","containerName":"next_result","name":"%data","definition":"my","line":447,"kind":13},{"containerName":"next_result","name":"@data","line":448,"kind":13},{"kind":13,"line":448,"containerName":"next_result","name":"@labels"},{"name":"@line","containerName":"next_result","line":448,"kind":13},{"name":"@line","containerName":"next_result","line":448,"kind":13},{"line":448,"kind":13,"containerName":"next_result","name":"@labels"},{"kind":13,"line":449,"containerName":"next_result","name":"$line"},{"definition":"my","name":"$fr","containerName":"next_result","localvar":"my","kind":13,"line":450},{"kind":13,"line":451,"containerName":"next_result","name":"$data"},{"name":"$fr","containerName":"next_result","line":452,"kind":13},{"name":"$fr","containerName":"next_result","kind":13,"line":453},{"kind":13,"line":454,"name":"$fr","containerName":"next_result"},{"line":456,"kind":13,"name":"@line","containerName":"next_result"},{"line":459,"kind":13,"containerName":"next_result","name":"$data"},{"containerName":"next_result","name":"$line","kind":13,"line":462},{"containerName":"next_result","name":"$data","line":463,"kind":13},{"line":464,"kind":13,"name":"@line","containerName":"next_result"},{"name":"$line","containerName":"next_result","line":465,"kind":13},{"line":466,"kind":13,"containerName":"next_result","name":"@line"},{"line":470,"kind":13,"containerName":"next_result","name":"$data"},{"containerName":"next_result","name":"$id","definition":"my","localvar":"my","kind":13,"line":476},{"name":"$desc","containerName":"next_result","kind":13,"line":476},{"kind":13,"line":477,"definition":"my","name":"@pieces","containerName":"next_result","localvar":"my"},{"line":477,"kind":13,"containerName":"next_result","name":"$id"},{"containerName":"next_result","definition":"my","name":"$acc","localvar":"my","kind":13,"line":478},{"kind":13,"line":478,"name":"@pieces","containerName":"next_result"},{"kind":13,"line":479,"name":"$acc","containerName":"next_result"},{"name":"@data","containerName":"next_result","kind":13,"line":481},{"containerName":"next_result","name":"$id","line":481,"kind":13},{"kind":13,"line":481,"name":"$desc","containerName":"next_result"},{"line":481,"kind":13,"name":"$acc","containerName":"next_result"},{"name":"@hit_signifs","containerName":"next_result","line":483,"kind":13},{"name":"%data","containerName":"next_result","kind":13,"line":483},{"name":"$self","containerName":"next_result","kind":13,"line":491},{"line":491,"kind":12,"name":"element","containerName":"next_result"},{"containerName":"next_result","name":"$self","kind":13,"line":497},{"kind":12,"line":497,"name":"element","containerName":"next_result"},{"kind":13,"line":503,"containerName":"next_result","name":"$self"},{"containerName":"next_result","name":"element","kind":12,"line":503},{"containerName":"next_result","name":"$self","kind":13,"line":509},{"line":510,"kind":13,"containerName":"next_result","name":"$self"},{"kind":13,"line":512,"containerName":"next_result","name":"$self"},{"line":512,"kind":12,"name":"element","containerName":"next_result"},{"name":"$self","containerName":"next_result","kind":13,"line":515},{"kind":13,"line":520,"containerName":"next_result","name":"$self"},{"kind":13,"line":521,"name":"$self","containerName":"next_result"},{"containerName":"next_result","name":"$self","line":526,"kind":13},{"kind":12,"line":526,"name":"element","containerName":"next_result"},{"name":"$self","containerName":"next_result","line":532,"kind":13},{"kind":12,"line":532,"name":"element","containerName":"next_result"},{"kind":13,"line":538,"name":"$self","containerName":"next_result"},{"name":"element","containerName":"next_result","line":538,"kind":12},{"containerName":"next_result","name":"$self","kind":13,"line":549},{"name":"element","containerName":"next_result","line":549,"kind":12},{"line":555,"kind":13,"name":"$self","containerName":"next_result"},{"line":555,"kind":12,"name":"element","containerName":"next_result"},{"line":561,"kind":13,"name":"$self","containerName":"next_result"},{"kind":12,"line":561,"containerName":"next_result","name":"element"},{"definition":"my","name":"$hit_id","containerName":"next_result","localvar":"my","kind":13,"line":569},{"kind":13,"line":569,"containerName":"next_result","name":"$len"},{"line":569,"kind":13,"name":"$alphabet","containerName":"next_result"},{"name":"$len","containerName":"next_result","line":570,"kind":13},{"containerName":"next_result","name":"$alphabet","line":570,"kind":13},{"name":"$self","containerName":"next_result","line":572,"kind":13},{"name":"_readline","containerName":"next_result","kind":12,"line":572},{"kind":13,"line":574,"containerName":"next_result","name":"$len"},{"containerName":"next_result","name":"$alphabet","line":574,"kind":13},{"name":"$hit_id","containerName":"next_result","kind":13,"line":575},{"name":"$self","containerName":"next_result","kind":13,"line":579},{"kind":12,"line":579,"name":"throw","containerName":"next_result"},{"line":583,"kind":13,"name":"$self","containerName":"next_result"},{"name":"in_element","containerName":"next_result","line":583,"kind":12},{"kind":13,"line":584,"containerName":"next_result","name":"$self"},{"name":"end_element","containerName":"next_result","line":584,"kind":12},{"containerName":"next_result","name":"$self","line":586,"kind":13},{"line":586,"kind":12,"name":"in_element","containerName":"next_result"},{"kind":13,"line":587,"name":"$self","containerName":"next_result"},{"line":587,"kind":12,"containerName":"next_result","name":"end_element"},{"name":"$self","containerName":"next_result","line":590,"kind":13},{"kind":12,"line":590,"containerName":"next_result","name":"start_element"},{"kind":13,"line":591,"name":"$self","containerName":"next_result"},{"name":"element","containerName":"next_result","line":591,"kind":12},{"name":"$len","containerName":"next_result","kind":13,"line":595},{"kind":13,"line":597,"name":"$id","definition":"my","containerName":"next_result","localvar":"my"},{"line":597,"kind":13,"name":"$desc","containerName":"next_result"},{"kind":13,"line":597,"containerName":"next_result","name":"$hit_id"},{"name":"$self","containerName":"next_result","kind":13,"line":598},{"line":598,"kind":12,"name":"element","containerName":"next_result"},{"name":"$id","containerName":"next_result","kind":13,"line":602},{"line":606,"kind":13,"localvar":"my","name":"@pieces","definition":"my","containerName":"next_result"},{"kind":13,"line":606,"containerName":"next_result","name":"$id"},{"line":607,"kind":13,"localvar":"my","definition":"my","name":"$acc","containerName":"next_result"},{"line":607,"kind":13,"name":"@pieces","containerName":"next_result"},{"containerName":"next_result","name":"$acc","kind":13,"line":608},{"name":"$self","containerName":"next_result","line":609,"kind":13},{"containerName":"next_result","name":"element","line":609,"kind":12},{"kind":13,"line":613,"name":"$acc","containerName":"next_result"},{"line":615,"kind":13,"containerName":"next_result","name":"$self"},{"containerName":"next_result","name":"element","kind":12,"line":615},{"kind":13,"line":619,"containerName":"next_result","name":"$desc"},{"containerName":"next_result","name":"$self","kind":13,"line":622},{"name":"_readline","containerName":"next_result","kind":12,"line":622},{"kind":13,"line":623,"containerName":"next_result","definition":"my","name":"$score","localvar":"my"},{"name":"$bits","containerName":"next_result","kind":13,"line":623},{"kind":13,"line":623,"name":"$e","containerName":"next_result"},{"name":"$bits","containerName":"next_result","kind":13,"line":626},{"kind":13,"line":626,"name":"$score","containerName":"next_result"},{"name":"$bits","containerName":"next_result","kind":13,"line":626},{"kind":13,"line":628,"containerName":"next_result","name":"$v","definition":"my","localvar":"my"},{"containerName":"next_result","name":"@hit_signifs","line":628,"kind":13},{"line":629,"kind":13,"containerName":"next_result","name":"$v"},{"name":"$v","containerName":"next_result","line":630,"kind":13},{"name":"$e","containerName":"next_result","kind":13,"line":630},{"containerName":"next_result","name":"$bits","line":630,"kind":13},{"kind":13,"line":630,"name":"$score","containerName":"next_result"},{"containerName":"next_result","name":"$self","line":632,"kind":13},{"line":632,"kind":12,"containerName":"next_result","name":"element"},{"containerName":"next_result","name":"$v","line":635,"kind":13},{"line":635,"kind":13,"containerName":"next_result","name":"$v"},{"containerName":"next_result","name":"$e","kind":13,"line":636},{"containerName":"next_result","name":"$self","line":638,"kind":13},{"name":"element","containerName":"next_result","line":638,"kind":12},{"containerName":"next_result","name":"$v","kind":13,"line":641},{"line":641,"kind":13,"containerName":"next_result","name":"$v"},{"line":642,"kind":13,"name":"$bits","containerName":"next_result"},{"line":644,"kind":13,"name":"$self","containerName":"next_result"},{"name":"start_element","containerName":"next_result","kind":12,"line":644},{"name":"$self","containerName":"next_result","kind":13,"line":646},{"line":646,"kind":12,"name":"element","containerName":"next_result"},{"containerName":"next_result","name":"$v","line":649,"kind":13},{"kind":13,"line":649,"name":"$v","containerName":"next_result"},{"line":650,"kind":13,"containerName":"next_result","name":"$score"},{"kind":13,"line":652,"name":"$self","containerName":"next_result"},{"line":652,"kind":12,"containerName":"next_result","name":"element"},{"containerName":"next_result","name":"$v","kind":13,"line":655},{"kind":13,"line":655,"containerName":"next_result","name":"$v"},{"containerName":"next_result","name":"$e","kind":13,"line":656},{"kind":13,"line":658,"containerName":"next_result","name":"$self"},{"containerName":"next_result","name":"element","kind":12,"line":658},{"line":661,"kind":13,"name":"$v","containerName":"next_result"},{"line":661,"kind":13,"name":"$v","containerName":"next_result"},{"line":662,"kind":13,"name":"$bits","containerName":"next_result"},{"name":"$self","containerName":"next_result","kind":13,"line":664},{"kind":12,"line":664,"name":"_readline","containerName":"next_result"},{"name":"$self","containerName":"next_result","kind":13,"line":667},{"line":667,"kind":12,"containerName":"next_result","name":"element"},{"definition":"my","name":"$identper","containerName":"next_result","localvar":"my","kind":13,"line":682},{"name":"$gapper","containerName":"next_result","line":682,"kind":13},{"kind":13,"line":682,"containerName":"next_result","name":"$len"},{"containerName":"next_result","name":"$querystart","kind":13,"line":682},{"name":"$queryend","containerName":"next_result","line":682,"kind":13},{"line":683,"kind":13,"containerName":"next_result","name":"$hitstart"},{"kind":13,"line":683,"name":"$hitend","containerName":"next_result"},{"kind":13,"line":685,"definition":"my","name":"$ident","containerName":"next_result","localvar":"my"},{"containerName":"next_result","name":"$identper","line":685,"kind":13},{"line":685,"kind":13,"name":"$len","containerName":"next_result"},{"containerName":"next_result","name":"$positive","definition":"my","localvar":"my","kind":13,"line":686},{"name":"$gapper","containerName":"next_result","line":686,"kind":13},{"kind":13,"line":686,"name":"$len","containerName":"next_result"},{"line":688,"kind":13,"name":"$self","containerName":"next_result"},{"name":"element","containerName":"next_result","kind":12,"line":688},{"name":"$ident","containerName":"next_result","line":692,"kind":13},{"kind":13,"line":694,"name":"$self","containerName":"next_result"},{"line":694,"kind":12,"name":"element","containerName":"next_result"},{"kind":13,"line":698,"containerName":"next_result","name":"$positive"},{"containerName":"next_result","name":"$self","line":700,"kind":13},{"line":700,"kind":12,"name":"element","containerName":"next_result"},{"name":"$len","containerName":"next_result","line":704,"kind":13},{"line":707,"kind":13,"containerName":"next_result","name":"$self"},{"containerName":"next_result","name":"element","line":707,"kind":12},{"containerName":"next_result","name":"$querystart","line":711,"kind":13},{"kind":13,"line":713,"containerName":"next_result","name":"$self"},{"name":"element","containerName":"next_result","kind":12,"line":713},{"kind":13,"line":717,"name":"$queryend","containerName":"next_result"},{"line":719,"kind":13,"containerName":"next_result","name":"$self"},{"line":719,"kind":12,"containerName":"next_result","name":"element"},{"kind":13,"line":723,"containerName":"next_result","name":"$hitstart"},{"name":"$self","containerName":"next_result","kind":13,"line":725},{"containerName":"next_result","name":"element","kind":12,"line":725},{"containerName":"next_result","name":"$hitend","kind":13,"line":729},{"kind":13,"line":734,"containerName":"next_result","name":"$v"},{"name":"$self","containerName":"next_result","line":735,"kind":13},{"name":"element","containerName":"next_result","kind":12,"line":735},{"kind":13,"line":736,"name":"$v","containerName":"next_result"},{"line":737,"kind":13,"name":"$v","containerName":"next_result"},{"kind":13,"line":738,"containerName":"next_result","name":"$self"},{"line":738,"kind":12,"name":"element","containerName":"next_result"},{"kind":13,"line":739,"containerName":"next_result","name":"$v"},{"kind":13,"line":740,"containerName":"next_result","name":"$v"},{"name":"$self","containerName":"next_result","line":742,"kind":13},{"kind":13,"line":743,"name":"$v","containerName":"next_result"},{"containerName":"next_result","name":"$v","line":746,"kind":13},{"line":746,"kind":13,"name":"$v","containerName":"next_result"},{"name":"$self","containerName":"next_result","line":747,"kind":13},{"name":"element","containerName":"next_result","line":747,"kind":12},{"line":756,"kind":13,"name":"$self","containerName":"next_result"},{"name":"element","containerName":"next_result","kind":12,"line":756},{"name":"$v","containerName":"next_result","kind":13,"line":764},{"kind":13,"line":764,"name":"$v","containerName":"next_result"},{"name":"$self","containerName":"next_result","kind":13,"line":765},{"line":765,"kind":12,"name":"element","containerName":"next_result"},{"kind":13,"line":774,"name":"$self","containerName":"next_result"},{"kind":12,"line":774,"containerName":"next_result","name":"element"},{"containerName":"next_result","name":"$self","line":784,"kind":13},{"containerName":"next_result","name":"element","kind":12,"line":784},{"line":787,"kind":13,"containerName":"next_result","name":"$v"},{"containerName":"next_result","name":"$self","line":790,"kind":13},{"kind":12,"line":790,"name":"element","containerName":"next_result"},{"line":795,"kind":13,"containerName":"next_result","name":"$self"},{"kind":12,"line":795,"name":"element","containerName":"next_result"},{"line":797,"kind":13,"name":"$self","containerName":"next_result"},{"kind":12,"line":797,"name":"element","containerName":"next_result"},{"containerName":"next_result","name":"$v","kind":13,"line":798},{"kind":13,"line":803,"containerName":"next_result","name":"$self"},{"kind":12,"line":803,"name":"warn","containerName":"next_result"},{"name":"$self","containerName":"next_result","kind":13,"line":807},{"kind":12,"line":807,"containerName":"next_result","name":"in_element"},{"line":808,"kind":13,"name":"$self","containerName":"next_result"},{"containerName":"next_result","name":"end_element","kind":12,"line":808},{"containerName":"next_result","name":"$self","kind":13,"line":810},{"kind":12,"line":810,"name":"in_element","containerName":"next_result"},{"line":811,"kind":13,"containerName":"next_result","name":"$self"},{"containerName":"next_result","name":"end_element","kind":12,"line":811},{"line":819,"kind":13,"containerName":"next_result","name":"$self"},{"line":819,"kind":12,"containerName":"next_result","name":"_readline"},{"kind":13,"line":826,"containerName":"next_result","name":"$self"},{"line":826,"kind":12,"containerName":"next_result","name":"_pushback"},{"containerName":"next_result","name":"@hit_signifs","line":830,"kind":13},{"line":833,"kind":13,"localvar":"my","containerName":"next_result","definition":"my","name":"$h"},{"kind":13,"line":833,"containerName":"next_result","name":"@hit_signifs"},{"kind":13,"line":840,"name":"$self","containerName":"next_result"},{"kind":12,"line":840,"name":"start_element","containerName":"next_result"},{"line":841,"kind":13,"name":"$self","containerName":"next_result"},{"name":"element","containerName":"next_result","kind":12,"line":841},{"kind":13,"line":844,"containerName":"next_result","name":"$h"},{"line":846,"kind":13,"containerName":"next_result","name":"$h"},{"kind":13,"line":847,"name":"$self","containerName":"next_result"},{"name":"element","containerName":"next_result","line":847,"kind":12},{"line":850,"kind":13,"containerName":"next_result","name":"$h"},{"name":"$h","containerName":"next_result","line":852,"kind":13},{"containerName":"next_result","name":"$self","line":853,"kind":13},{"containerName":"next_result","name":"element","line":853,"kind":12},{"name":"$h","containerName":"next_result","kind":13,"line":856},{"kind":13,"line":858,"containerName":"next_result","name":"$h"},{"line":859,"kind":13,"name":"$self","containerName":"next_result"},{"line":859,"kind":12,"name":"element","containerName":"next_result"},{"name":"$h","containerName":"next_result","line":862,"kind":13},{"kind":13,"line":864,"name":"$h","containerName":"next_result"},{"line":865,"kind":13,"name":"$self","containerName":"next_result"},{"kind":12,"line":865,"name":"element","containerName":"next_result"},{"containerName":"next_result","name":"$h","kind":13,"line":868},{"containerName":"next_result","name":"$h","line":870,"kind":13},{"kind":13,"line":871,"containerName":"next_result","name":"$self"},{"containerName":"next_result","name":"element","line":871,"kind":12},{"line":874,"kind":13,"name":"$h","containerName":"next_result"},{"containerName":"next_result","name":"$h","line":876,"kind":13},{"containerName":"next_result","name":"$self","kind":13,"line":878},{"containerName":"next_result","name":"start_element","line":878,"kind":12},{"line":879,"kind":13,"containerName":"next_result","name":"$self"},{"name":"element","containerName":"next_result","kind":12,"line":879},{"name":"$h","containerName":"next_result","kind":13,"line":880},{"name":"$h","containerName":"next_result","line":881,"kind":13},{"line":882,"kind":13,"name":"$self","containerName":"next_result"},{"kind":12,"line":882,"containerName":"next_result","name":"element"},{"containerName":"next_result","name":"$h","line":883,"kind":13},{"kind":13,"line":884,"name":"$h","containerName":"next_result"},{"containerName":"next_result","name":"$self","line":885,"kind":13},{"name":"element","containerName":"next_result","line":885,"kind":12},{"line":886,"kind":13,"containerName":"next_result","name":"$h"},{"kind":13,"line":887,"containerName":"next_result","name":"$h"},{"containerName":"next_result","name":"$self","kind":13,"line":888},{"containerName":"next_result","name":"element","kind":12,"line":888},{"name":"$h","containerName":"next_result","line":889,"kind":13},{"line":890,"kind":13,"name":"$h","containerName":"next_result"},{"line":891,"kind":13,"containerName":"next_result","name":"$self"},{"line":891,"kind":12,"name":"element","containerName":"next_result"},{"line":892,"kind":13,"name":"$h","containerName":"next_result"},{"name":"$h","containerName":"next_result","kind":13,"line":893},{"name":"$self","containerName":"next_result","kind":13,"line":894},{"line":894,"kind":12,"name":"element","containerName":"next_result"},{"name":"$h","containerName":"next_result","kind":13,"line":898},{"line":898,"kind":13,"name":"$h","containerName":"next_result"},{"containerName":"next_result","name":"$h","line":900,"kind":13},{"line":900,"kind":13,"name":"$h","containerName":"next_result"},{"line":902,"kind":13,"containerName":"next_result","name":"$h"},{"kind":13,"line":903,"containerName":"next_result","name":"$self"},{"kind":12,"line":903,"name":"element","containerName":"next_result"},{"name":"$h","containerName":"next_result","kind":13,"line":907},{"name":"$h","containerName":"next_result","line":907,"kind":13},{"line":909,"kind":13,"containerName":"next_result","name":"$h"},{"name":"$h","containerName":"next_result","line":909,"kind":13},{"containerName":"next_result","name":"$self","kind":13,"line":912},{"line":912,"kind":12,"name":"element","containerName":"next_result"},{"kind":13,"line":916,"containerName":"next_result","name":"$h"},{"name":"$h","containerName":"next_result","line":916,"kind":13},{"kind":13,"line":918,"name":"$h","containerName":"next_result"},{"kind":13,"line":918,"containerName":"next_result","name":"$h"},{"containerName":"next_result","name":"$self","line":920,"kind":13},{"name":"element","containerName":"next_result","line":920,"kind":12},{"containerName":"next_result","name":"$h","line":921,"kind":13},{"kind":13,"line":922,"containerName":"next_result","name":"$h"},{"containerName":"next_result","name":"$self","kind":13,"line":923},{"line":923,"kind":12,"containerName":"next_result","name":"element"},{"containerName":"next_result","name":"$h","kind":13,"line":924},{"line":925,"kind":13,"name":"$h","containerName":"next_result"},{"kind":13,"line":926,"name":"$self","containerName":"next_result"},{"name":"element","containerName":"next_result","line":926,"kind":12},{"containerName":"next_result","name":"$h","line":927,"kind":13},{"line":928,"kind":13,"name":"$h","containerName":"next_result"},{"line":929,"kind":13,"name":"$self","containerName":"next_result"},{"containerName":"next_result","name":"element","kind":12,"line":929},{"name":"$h","containerName":"next_result","kind":13,"line":930},{"name":"$h","containerName":"next_result","line":931,"kind":13},{"line":932,"kind":13,"containerName":"next_result","name":"$self"},{"kind":12,"line":932,"name":"element","containerName":"next_result"},{"line":933,"kind":13,"containerName":"next_result","name":"$h"},{"line":934,"kind":13,"name":"$h","containerName":"next_result"},{"name":"$self","containerName":"next_result","kind":13,"line":936},{"line":936,"kind":12,"containerName":"next_result","name":"element"},{"name":"$h","containerName":"next_result","kind":13,"line":937},{"kind":13,"line":938,"containerName":"next_result","name":"$h"},{"line":939,"kind":13,"name":"$self","containerName":"next_result"},{"kind":12,"line":939,"containerName":"next_result","name":"element"},{"kind":13,"line":940,"containerName":"next_result","name":"$h"},{"kind":13,"line":941,"name":"$h","containerName":"next_result"},{"kind":13,"line":943,"containerName":"next_result","name":"$self"},{"line":944,"kind":13,"containerName":"next_result","name":"$h"},{"kind":13,"line":947,"name":"$h","containerName":"next_result"},{"name":"$h","containerName":"next_result","line":947,"kind":13},{"name":"$self","containerName":"next_result","kind":13,"line":948},{"containerName":"next_result","name":"element","line":948,"kind":12},{"name":"$self","containerName":"next_result","line":957,"kind":13},{"containerName":"next_result","name":"element","line":957,"kind":12},{"name":"$h","containerName":"next_result","line":965,"kind":13},{"name":"$h","containerName":"next_result","line":965,"kind":13},{"kind":13,"line":966,"name":"$self","containerName":"next_result"},{"line":966,"kind":12,"name":"element","containerName":"next_result"},{"line":975,"kind":13,"containerName":"next_result","name":"$self"},{"line":975,"kind":12,"name":"element","containerName":"next_result"},{"line":985,"kind":13,"name":"$self","containerName":"next_result"},{"kind":12,"line":985,"name":"element","containerName":"next_result"},{"line":988,"kind":13,"containerName":"next_result","name":"$h"},{"kind":13,"line":991,"name":"$self","containerName":"next_result"},{"containerName":"next_result","name":"element","kind":12,"line":991},{"kind":13,"line":996,"name":"$self","containerName":"next_result"},{"name":"element","containerName":"next_result","line":996,"kind":12},{"name":"$self","containerName":"next_result","kind":13,"line":998},{"kind":12,"line":998,"containerName":"next_result","name":"element"},{"name":"$h","containerName":"next_result","line":1001,"kind":13},{"line":1006,"kind":13,"name":"$self","containerName":"next_result"},{"kind":12,"line":1006,"containerName":"next_result","name":"end_element"},{"name":"$self","containerName":"next_result","kind":13,"line":1007},{"line":1007,"kind":12,"containerName":"next_result","name":"end_element"},{"name":"$self","containerName":"next_result","kind":13,"line":1010},{"kind":12,"line":1010,"containerName":"next_result","name":"end_element"},{"line":1011,"kind":13,"containerName":"next_result","name":"$self"},{"kind":12,"line":1011,"name":"end_document","containerName":"next_result"},{"kind":13,"line":1014,"name":"$self","containerName":"next_result"},{"name":"within_element","containerName":"next_result","line":1014,"kind":12},{"containerName":"next_result","name":"$self","kind":13,"line":1015},{"kind":12,"line":1015,"name":"in_element","containerName":"next_result"},{"line":1016,"kind":13,"name":"$self","containerName":"next_result"},{"line":1016,"kind":12,"name":"end_element","containerName":"next_result"},{"line":1018,"kind":13,"name":"$self","containerName":"next_result"},{"kind":12,"line":1018,"containerName":"next_result","name":"in_element"},{"containerName":"next_result","name":"$self","kind":13,"line":1019},{"kind":12,"line":1019,"name":"end_element","containerName":"next_result"},{"containerName":"next_result","name":"@hit_signifs","line":1022,"kind":13},{"containerName":"next_result","name":"$h","definition":"my","localvar":"my","kind":13,"line":1025},{"kind":13,"line":1025,"containerName":"next_result","name":"@hit_signifs"},{"line":1026,"kind":13,"containerName":"next_result","name":"$self"},{"kind":12,"line":1026,"containerName":"next_result","name":"start_element"},{"containerName":"next_result","name":"$self","line":1027,"kind":13},{"containerName":"next_result","name":"element","kind":12,"line":1027},{"name":"$h","containerName":"next_result","line":1030,"kind":13},{"kind":13,"line":1032,"containerName":"next_result","name":"$h"},{"name":"$self","containerName":"next_result","kind":13,"line":1033},{"containerName":"next_result","name":"element","kind":12,"line":1033},{"containerName":"next_result","name":"$h","line":1036,"kind":13},{"name":"$h","containerName":"next_result","kind":13,"line":1038},{"name":"$self","containerName":"next_result","line":1039,"kind":13},{"name":"element","containerName":"next_result","line":1039,"kind":12},{"line":1042,"kind":13,"name":"$h","containerName":"next_result"},{"line":1044,"kind":13,"name":"$h","containerName":"next_result"},{"name":"$self","containerName":"next_result","line":1045,"kind":13},{"name":"element","containerName":"next_result","kind":12,"line":1045},{"name":"$h","containerName":"next_result","kind":13,"line":1048},{"name":"$h","containerName":"next_result","line":1050,"kind":13},{"name":"$self","containerName":"next_result","line":1051,"kind":13},{"containerName":"next_result","name":"element","kind":12,"line":1051},{"containerName":"next_result","name":"$h","line":1054,"kind":13},{"name":"$h","containerName":"next_result","kind":13,"line":1056},{"containerName":"next_result","name":"$self","line":1057,"kind":13},{"line":1057,"kind":12,"containerName":"next_result","name":"element"},{"containerName":"next_result","name":"$h","kind":13,"line":1060},{"containerName":"next_result","name":"$h","kind":13,"line":1062},{"kind":13,"line":1064,"containerName":"next_result","name":"$self"},{"name":"start_element","containerName":"next_result","kind":12,"line":1064},{"containerName":"next_result","name":"$self","kind":13,"line":1065},{"line":1065,"kind":12,"containerName":"next_result","name":"element"},{"kind":13,"line":1066,"name":"$h","containerName":"next_result"},{"containerName":"next_result","name":"$h","line":1067,"kind":13},{"name":"$self","containerName":"next_result","kind":13,"line":1068},{"containerName":"next_result","name":"element","kind":12,"line":1068},{"line":1069,"kind":13,"containerName":"next_result","name":"$h"},{"containerName":"next_result","name":"$h","line":1070,"kind":13},{"kind":13,"line":1071,"name":"$self","containerName":"next_result"},{"line":1071,"kind":12,"name":"element","containerName":"next_result"},{"containerName":"next_result","name":"$h","kind":13,"line":1072},{"containerName":"next_result","name":"$h","line":1073,"kind":13},{"line":1074,"kind":13,"name":"$self","containerName":"next_result"},{"kind":12,"line":1074,"name":"element","containerName":"next_result"},{"line":1075,"kind":13,"name":"$h","containerName":"next_result"},{"kind":13,"line":1076,"containerName":"next_result","name":"$h"},{"line":1077,"kind":13,"containerName":"next_result","name":"$self"},{"kind":12,"line":1077,"containerName":"next_result","name":"element"},{"kind":13,"line":1078,"name":"$h","containerName":"next_result"},{"containerName":"next_result","name":"$h","kind":13,"line":1079},{"kind":13,"line":1080,"containerName":"next_result","name":"$self"},{"containerName":"next_result","name":"element","kind":12,"line":1080},{"name":"$h","containerName":"next_result","kind":13,"line":1084},{"line":1084,"kind":13,"name":"$h","containerName":"next_result"},{"line":1086,"kind":13,"name":"$h","containerName":"next_result"},{"kind":13,"line":1086,"containerName":"next_result","name":"$h"},{"name":"$h","containerName":"next_result","kind":13,"line":1088},{"kind":13,"line":1089,"name":"$self","containerName":"next_result"},{"kind":12,"line":1089,"name":"element","containerName":"next_result"},{"kind":13,"line":1093,"name":"$h","containerName":"next_result"},{"name":"$h","containerName":"next_result","line":1093,"kind":13},{"line":1095,"kind":13,"name":"$h","containerName":"next_result"},{"kind":13,"line":1095,"name":"$h","containerName":"next_result"},{"containerName":"next_result","name":"$self","line":1098,"kind":13},{"containerName":"next_result","name":"element","kind":12,"line":1098},{"kind":13,"line":1102,"containerName":"next_result","name":"$h"},{"line":1102,"kind":13,"name":"$h","containerName":"next_result"},{"containerName":"next_result","name":"$h","kind":13,"line":1104},{"name":"$h","containerName":"next_result","line":1104,"kind":13},{"kind":13,"line":1106,"name":"$self","containerName":"next_result"},{"kind":12,"line":1106,"containerName":"next_result","name":"element"},{"line":1107,"kind":13,"name":"$h","containerName":"next_result"},{"containerName":"next_result","name":"$h","line":1108,"kind":13},{"containerName":"next_result","name":"$self","kind":13,"line":1109},{"containerName":"next_result","name":"element","line":1109,"kind":12},{"name":"$h","containerName":"next_result","line":1110,"kind":13},{"line":1111,"kind":13,"containerName":"next_result","name":"$h"},{"line":1112,"kind":13,"name":"$self","containerName":"next_result"},{"name":"element","containerName":"next_result","line":1112,"kind":12},{"containerName":"next_result","name":"$h","kind":13,"line":1113},{"kind":13,"line":1114,"name":"$h","containerName":"next_result"},{"line":1115,"kind":13,"containerName":"next_result","name":"$self"},{"name":"element","containerName":"next_result","kind":12,"line":1115},{"kind":13,"line":1116,"name":"$h","containerName":"next_result"},{"line":1117,"kind":13,"name":"$h","containerName":"next_result"},{"name":"$self","containerName":"next_result","line":1118,"kind":13},{"kind":12,"line":1118,"name":"element","containerName":"next_result"},{"line":1119,"kind":13,"name":"$h","containerName":"next_result"},{"line":1120,"kind":13,"name":"$h","containerName":"next_result"},{"containerName":"next_result","name":"$self","line":1122,"kind":13},{"containerName":"next_result","name":"element","line":1122,"kind":12},{"line":1125,"kind":13,"name":"$h","containerName":"next_result"},{"kind":13,"line":1127,"name":"$h","containerName":"next_result"},{"name":"$self","containerName":"next_result","line":1128,"kind":13},{"kind":12,"line":1128,"containerName":"next_result","name":"element"},{"containerName":"next_result","name":"$h","line":1129,"kind":13},{"containerName":"next_result","name":"$h","kind":13,"line":1130},{"name":"$self","containerName":"next_result","line":1132,"kind":13},{"kind":13,"line":1133,"name":"$h","containerName":"next_result"},{"name":"$h","containerName":"next_result","line":1136,"kind":13},{"containerName":"next_result","name":"$h","kind":13,"line":1136},{"name":"$self","containerName":"next_result","kind":13,"line":1137},{"containerName":"next_result","name":"element","line":1137,"kind":12},{"containerName":"next_result","name":"$self","kind":13,"line":1145},{"name":"element","containerName":"next_result","line":1145,"kind":12},{"containerName":"next_result","name":"$h","line":1152,"kind":13},{"containerName":"next_result","name":"$h","line":1152,"kind":13},{"name":"$self","containerName":"next_result","kind":13,"line":1153},{"name":"element","containerName":"next_result","line":1153,"kind":12},{"name":"$self","containerName":"next_result","kind":13,"line":1161},{"containerName":"next_result","name":"element","kind":12,"line":1161},{"containerName":"next_result","name":"$self","line":1170,"kind":13},{"kind":12,"line":1170,"name":"element","containerName":"next_result"},{"containerName":"next_result","name":"$h","kind":13,"line":1173},{"name":"$self","containerName":"next_result","kind":13,"line":1176},{"line":1176,"kind":12,"name":"element","containerName":"next_result"},{"name":"$self","containerName":"next_result","kind":13,"line":1182},{"kind":12,"line":1182,"containerName":"next_result","name":"element"},{"name":"$self","containerName":"next_result","line":1184,"kind":13},{"line":1184,"kind":12,"containerName":"next_result","name":"element"},{"name":"$h","containerName":"next_result","kind":13,"line":1187},{"containerName":"next_result","name":"$self","line":1192,"kind":13},{"line":1192,"kind":12,"name":"end_element","containerName":"next_result"},{"containerName":"next_result","name":"$self","kind":13,"line":1193},{"kind":12,"line":1193,"containerName":"next_result","name":"end_element"},{"kind":13,"line":1196,"name":"$self","containerName":"next_result"},{"containerName":"next_result","name":"end_element","kind":12,"line":1196},{"kind":13,"line":1197,"containerName":"next_result","name":"$self"},{"containerName":"next_result","name":"_pushback","line":1197,"kind":12},{"name":"$self","containerName":"next_result","line":1198,"kind":13},{"name":"end_document","containerName":"next_result","line":1198,"kind":12},{"kind":13,"line":1201,"name":"$self","containerName":"next_result"},{"kind":12,"line":1201,"containerName":"next_result","name":"start_element"},{"line":1202,"kind":13,"name":"$self","containerName":"next_result"},{"name":"$seentop","containerName":"next_result","kind":13,"line":1203},{"kind":13,"line":1204,"containerName":"next_result","name":"$self"},{"name":"element","containerName":"next_result","line":1204,"kind":12},{"containerName":"next_result","name":"$self","kind":13,"line":1207},{"kind":13,"line":1210,"name":"$self","containerName":"next_result"},{"line":1210,"kind":12,"name":"element","containerName":"next_result"},{"containerName":"next_result","name":"$self","line":1213,"kind":13},{"localvar":"my","containerName":"next_result","name":"$type","definition":"my","line":1217,"kind":13},{"name":"$querylen","containerName":"next_result","kind":13,"line":1217},{"kind":13,"line":1217,"name":"$querytype","containerName":"next_result"},{"line":1217,"kind":13,"containerName":"next_result","name":"$querydef"},{"kind":13,"line":1220,"containerName":"next_result","name":"$querydef"},{"line":1221,"kind":13,"name":"$querydef","containerName":"next_result"},{"name":"$querydef","containerName":"next_result","kind":13,"line":1223},{"name":"$querylen","containerName":"next_result","line":1223,"kind":13},{"line":1223,"kind":13,"name":"$querytype","containerName":"next_result"},{"kind":13,"line":1227,"name":"$self","containerName":"next_result"},{"line":1228,"kind":13,"name":"$self","containerName":"next_result"},{"kind":13,"line":1230,"name":"$querytype","containerName":"next_result"},{"line":1231,"kind":13,"name":"$self","containerName":"next_result"},{"containerName":"next_result","name":"$querytype","line":1233,"kind":13},{"line":1234,"kind":13,"containerName":"next_result","name":"$self"},{"localvar":"my","containerName":"next_result","name":"$name","definition":"my","line":1237,"kind":13},{"containerName":"next_result","name":"$descr","line":1237,"kind":13},{"containerName":"next_result","name":"$querydef","line":1238,"kind":13},{"line":1239,"kind":13,"containerName":"next_result","name":"$self"},{"kind":12,"line":1239,"containerName":"next_result","name":"element"},{"line":1243,"kind":13,"containerName":"next_result","name":"$name"},{"kind":13,"line":1245,"containerName":"next_result","name":"$self"},{"containerName":"next_result","name":"element","line":1245,"kind":12},{"kind":13,"line":1249,"name":"$descr","containerName":"next_result"},{"name":"$querylen","containerName":"next_result","kind":13,"line":1251},{"kind":13,"line":1252,"containerName":"next_result","name":"$self"},{"kind":12,"line":1252,"name":"element","containerName":"next_result"},{"name":"$querylen","containerName":"next_result","line":1256,"kind":13},{"name":"$self","containerName":"next_result","kind":13,"line":1260},{"name":"warn","containerName":"next_result","line":1260,"kind":12},{"containerName":"next_result","name":"$self","kind":13,"line":1262},{"kind":12,"line":1262,"name":"_readline","containerName":"next_result"},{"kind":13,"line":1265,"name":"$self","containerName":"next_result"},{"kind":12,"line":1265,"name":"element","containerName":"next_result"},{"name":"$self","containerName":"next_result","kind":13,"line":1275},{"line":1275,"kind":12,"name":"in_element","containerName":"next_result"},{"kind":13,"line":1276,"containerName":"next_result","name":"@data","definition":"my","localvar":"my"},{"kind":13,"line":1277,"name":"$count","definition":"my","containerName":"next_result","localvar":"my"},{"localvar":"my","definition":"my","name":"$len","containerName":"next_result","line":1278,"kind":13},{"line":1278,"kind":13,"containerName":"next_result","name":"$self"},{"kind":12,"line":1278,"containerName":"next_result","name":"idlength"},{"containerName":"next_result","name":"$seq1_id","definition":"my","localvar":"my","kind":13,"line":1279},{"line":1284,"kind":13,"containerName":"next_result","name":"$self"},{"containerName":"next_result","name":"_pushback","kind":12,"line":1284},{"line":1288,"kind":13,"name":"$self","containerName":"next_result"},{"containerName":"next_result","name":"end_element","line":1288,"kind":12},{"containerName":"next_result","name":"$self","line":1292,"kind":13},{"kind":12,"line":1292,"name":"_pushback","containerName":"next_result"},{"name":"$self","containerName":"next_result","line":1296,"kind":13},{"kind":12,"line":1296,"name":"_pushback","containerName":"next_result"},{"kind":13,"line":1299,"containerName":"next_result","name":"$count"},{"line":1301,"kind":13,"name":"$self","containerName":"next_result"},{"line":1301,"kind":12,"containerName":"next_result","name":"_pushback"},{"name":"$count","containerName":"next_result","line":1302,"kind":13},{"containerName":"next_result","name":"$count","kind":13,"line":1309},{"name":"$self","containerName":"next_result","line":1312,"kind":13},{"line":1312,"kind":12,"containerName":"next_result","name":"_pushback"},{"name":"$count","containerName":"next_result","line":1313,"kind":13},{"line":1316,"kind":13,"name":"$count","containerName":"next_result"},{"kind":13,"line":1316,"containerName":"next_result","name":"$count"},{"kind":13,"line":1318,"name":"$len","containerName":"next_result"},{"line":1318,"kind":13,"containerName":"next_result","name":"$len"},{"containerName":"next_result","name":"$data","line":1320,"kind":13},{"line":1320,"kind":13,"name":"$count","containerName":"next_result"},{"kind":13,"line":1320,"name":"$len","containerName":"next_result"},{"line":1323,"kind":13,"name":"$count","containerName":"next_result"},{"kind":13,"line":1324,"name":"$self","containerName":"next_result"},{"containerName":"next_result","name":"_pushback","line":1324,"kind":12},{"kind":13,"line":1327,"containerName":"next_result","name":"$count"},{"line":1332,"kind":13,"containerName":"next_result","name":"$self"},{"name":"throw","containerName":"next_result","line":1332,"kind":12},{"containerName":"next_result","name":"$count","line":1336,"kind":13},{"name":"$self","containerName":"next_result","line":1338,"kind":13},{"name":"warn","containerName":"next_result","kind":12,"line":1338},{"kind":13,"line":1338,"containerName":"next_result","name":"$self"},{"line":1338,"kind":12,"containerName":"next_result","name":"verbose"},{"containerName":"next_result","name":"$data","kind":13,"line":1343},{"line":1343,"kind":13,"name":"$data","containerName":"next_result"},{"name":"$count","containerName":"next_result","line":1344,"kind":13},{"kind":13,"line":1349,"name":"$len","containerName":"next_result"},{"kind":13,"line":1350,"name":"$data","containerName":"next_result"},{"kind":13,"line":1350,"name":"$count","containerName":"next_result"},{"kind":13,"line":1350,"containerName":"next_result","name":"$len"}],"line":208,"kind":12,"signature":{"documentation":"1;\n# $Id: fasta.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::fasta\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::fasta - A SearchIO parser for FASTA results\n\n=head1 SYNOPSIS\n\n  # Do not use this object directly, use it through the SearchIO system\n   use Bio::SearchIO;\n   my $searchio = Bio::SearchIO->new(-format => 'fasta',\n                    -file   => 'report.FASTA');\n   while( my $result = $searchio->next_result ) {\n    # ... do what you would normally doi with Bio::SearchIO.\n   }\n\n=head1 DESCRIPTION\n\nThis object contains the event based parsing code for FASTA format\nreports.  It creates L<Bio::Search::HSP::FastaHSP> objects instead of\nL<Bio::Search::HSP::GenericHSP> for the HSP objects. \n\nThis module will parse -m 9 -d 0 output as well as default m 1 output\nfrom FASTA as well as SSEARCH.\n\nAlso see the SearchIO HOWTO:\nL<http://bioperl.open-bio.org/wiki/HOWTO:SearchIO>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich, Aaron Mackey\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::fasta;\nuse vars qw(%MODEMAP %MAPPING $IDLENGTH);\nuse strict;\n\n# Object preamble - inherits from Bio::Root::RootI\n\nuse Bio::Factory::ObjectFactory;\n\nBEGIN {\n\n    # Set IDLENGTH to a new value if you have\n    # compile FASTA with a different ID length\n    # (actually newest FASTA allows the setting of this\n    #  via -C parameter, default is 6)\n    $IDLENGTH = 6;\n\n    # mapping of NCBI Blast terms to Bioperl hash keys\n    %MODEMAP = (\n        'FastaOutput' => 'result',\n        'Hit'         => 'hit',\n        'Hsp'         => 'hsp'\n    );\n\n    # This should really be done more intelligently, like with\n    # XSLT\n\n    %MAPPING = (\n        'Hsp_bit-score'   => 'HSP-bits',\n        'Hsp_score'       => 'HSP-score',\n        'Hsp_sw-score'    => 'HSP-swscore',\n        'Hsp_evalue'      => 'HSP-evalue',\n        'Hsp_query-from'  => 'HSP-query_start',\n        'Hsp_query-to'    => 'HSP-query_end',\n        'Hsp_hit-from'    => 'HSP-hit_start',\n        'Hsp_hit-to'      => 'HSP-hit_end',\n        'Hsp_positive'    => 'HSP-conserved',\n        'Hsp_identity'    => 'HSP-identical',\n        'Hsp_gaps'        => 'HSP-hsp_gaps',\n        'Hsp_hitgaps'     => 'HSP-hit_gaps',\n        'Hsp_querygaps'   => 'HSP-query_gaps',\n        'Hsp_qseq'        => 'HSP-query_seq',\n        'Hsp_hseq'        => 'HSP-hit_seq',\n        'Hsp_midline'     => 'HSP-homology_seq',\n        'Hsp_align-len'   => 'HSP-hsp_length',\n        'Hsp_query-frame' => 'HSP-query_frame',\n        'Hsp_hit-frame'   => 'HSP-hit_frame',\n\n        'Hit_id'        => 'HIT-name',\n        'Hit_len'       => 'HIT-length',\n        'Hit_accession' => 'HIT-accession',\n        'Hit_def'       => 'HIT-description',\n        'Hit_signif'    => 'HIT-significance',\n        'Hit_score'     => 'HIT-score',\n\n        'FastaOutput_program'   => 'RESULT-algorithm_name',\n        'FastaOutput_version'   => 'RESULT-algorithm_version',\n        'FastaOutput_query-def' => 'RESULT-query_name',\n        'FastaOutput_querydesc' => 'RESULT-query_description',\n        'FastaOutput_query-len' => 'RESULT-query_length',\n        'FastaOutput_db'        => 'RESULT-database_name',\n        'FastaOutput_db-len'    => 'RESULT-database_entries',\n        'FastaOutput_db-let'    => 'RESULT-database_letters',\n\n        'Parameters_matrix'      => { 'RESULT-parameters' => 'matrix' },\n        'Parameters_expect'      => { 'RESULT-parameters' => 'expect' },\n        'Parameters_include'     => { 'RESULT-parameters' => 'include' },\n        'Parameters_sc-match'    => { 'RESULT-parameters' => 'match' },\n        'Parameters_sc-mismatch' => { 'RESULT-parameters' => 'mismatch' },\n        'Parameters_gap-open'    => { 'RESULT-parameters' => 'gapopen' },\n        'Parameters_gap-ext'     => { 'RESULT-parameters' => 'gapext' },\n        'Parameters_word-size'   => { 'RESULT-parameters' => 'wordsize' },\n        'Parameters_ktup'        => { 'RESULT-parameters' => 'ktup' },\n        'Parameters_filter'      => { 'RESULT-parameters' => 'filter' },\n        'Statistics_db-num'      => { 'RESULT-statistics' => 'dbentries' },\n        'Statistics_db-len'      => { 'RESULT-statistics' => 'dbletters' },\n        'Statistics_hsp-len'     => { 'RESULT-statistics' => 'hsplength' },\n        'Statistics_eff-space'   => { 'RESULT-statistics' => 'effectivespace' },\n        'Statistics_kappa'       => { 'RESULT-statistics' => 'kappa' },\n        'Statistics_lambda'      => { 'RESULT-statistics' => 'lambda' },\n        'Statistics_entropy'     => { 'RESULT-statistics' => 'entropy' },\n    );\n}\n\nuse base qw(Bio::SearchIO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::fasta->new();\n Function: Builds a new Bio::SearchIO::fasta object \n Returns : Bio::SearchIO::fasta\n Args    : -idlength - set ID length to something other \n                       than the default (7), this is only\n                       necessary if you have compiled FASTA\n                       with a new default id length to display\n                       in the HSP alignment blocks\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n    return unless @args;\n    my ($idlength) = $self->_rearrange( [qw(IDLENGTH)], @args );\n    $self->idlength( $idlength || $IDLENGTH );\n    $self->_eventHandler->register_factory(\n        'hsp',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::HSP::FastaHSP',\n            -interface => 'Bio::Search::HSP::HSPI'\n        )\n    );\n    return 1;\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none","parameters":[{"label":"$self"}],"label":"next_result($self)"},"detail":"($self)","definition":"sub","containerName":"main::"},{"name":"labels","kind":12,"line":434},{"name":"lframe","line":451,"kind":12},{"kind":12,"line":459,"name":"lframe"},{"name":"hit_len","kind":12,"line":463},{"name":"hit_len","line":470,"kind":12},{"kind":12,"line":571,"name":"WRAPPED"},{"name":"WRAPPED","line":576,"kind":12},{"line":635,"kind":12,"name":"evalue"},{"name":"bits","line":641,"kind":12},{"line":655,"kind":12,"name":"evalue"},{"line":661,"kind":12,"name":"bits"},{"line":736,"kind":12,"name":"qgaps"},{"name":"qgaps","line":737,"kind":12},{"name":"lgaps","kind":12,"line":739},{"name":"lgaps","kind":12,"line":740},{"name":"ax0","kind":12,"line":746},{"name":"an0","line":746,"kind":12},{"name":"ax1","kind":12,"line":764},{"name":"an1","line":764,"kind":12},{"name":"lframe","line":787,"kind":12},{"name":"lframe","kind":12,"line":798},{"line":844,"kind":12,"name":"hit_len"},{"line":846,"kind":12,"name":"hit_len"},{"name":"id","line":850,"kind":12},{"kind":12,"line":852,"name":"id"},{"name":"acc","kind":12,"line":856},{"kind":12,"line":858,"name":"acc"},{"name":"desc","kind":12,"line":862},{"kind":12,"line":864,"name":"desc"},{"name":"evalue","kind":12,"line":868},{"name":"evalue","kind":12,"line":870},{"line":874,"kind":12,"name":"bits"},{"name":"bits","line":876,"kind":12},{"kind":12,"line":883,"name":"evalue"},{"kind":12,"line":884,"name":"evalue"},{"name":"bits","kind":12,"line":886},{"name":"bits","kind":12,"line":887},{"line":889,"kind":12,"name":"sw"},{"line":890,"kind":12,"name":"sw"},{"line":898,"kind":12,"name":"alen"},{"kind":12,"line":900,"name":"alen"},{"line":907,"kind":12,"name":"alen"},{"name":"alen","line":909,"kind":12},{"name":"alen","line":916,"kind":12},{"name":"alen","kind":12,"line":918},{"name":"alen","line":921,"kind":12},{"name":"alen","kind":12,"line":922},{"name":"an0","line":924,"kind":12},{"kind":12,"line":925,"name":"an0"},{"kind":12,"line":927,"name":"ax0"},{"name":"ax0","kind":12,"line":928},{"kind":12,"line":930,"name":"an1"},{"name":"an1","kind":12,"line":931},{"name":"ax1","kind":12,"line":933},{"name":"ax1","kind":12,"line":934},{"name":"qgaps","kind":12,"line":937},{"line":938,"kind":12,"name":"qgaps"},{"name":"lgaps","line":940,"kind":12},{"name":"lgaps","line":941,"kind":12},{"line":947,"kind":12,"name":"ax0"},{"line":947,"kind":12,"name":"an0"},{"line":965,"kind":12,"name":"ax1"},{"name":"an1","line":965,"kind":12},{"line":988,"kind":12,"name":"lframe"},{"name":"lframe","kind":12,"line":1001},{"kind":12,"line":1030,"name":"hit_len"},{"kind":12,"line":1032,"name":"hit_len"},{"name":"id","kind":12,"line":1036},{"name":"id","kind":12,"line":1038},{"name":"acc","kind":12,"line":1042},{"line":1044,"kind":12,"name":"acc"},{"name":"desc","line":1048,"kind":12},{"kind":12,"line":1050,"name":"desc"},{"kind":12,"line":1054,"name":"evalue"},{"name":"evalue","line":1056,"kind":12},{"name":"bits","kind":12,"line":1060},{"line":1062,"kind":12,"name":"bits"},{"name":"evalue","line":1069,"kind":12},{"name":"evalue","line":1070,"kind":12},{"line":1072,"kind":12,"name":"bits"},{"name":"bits","kind":12,"line":1073},{"name":"sw","kind":12,"line":1075},{"kind":12,"line":1076,"name":"sw"},{"line":1084,"kind":12,"name":"alen"},{"name":"alen","line":1086,"kind":12},{"kind":12,"line":1093,"name":"alen"},{"kind":12,"line":1095,"name":"alen"},{"kind":12,"line":1102,"name":"alen"},{"name":"alen","kind":12,"line":1104},{"kind":12,"line":1107,"name":"alen"},{"name":"alen","kind":12,"line":1108},{"name":"an0","kind":12,"line":1110},{"name":"an0","kind":12,"line":1111},{"name":"ax0","line":1113,"kind":12},{"name":"ax0","line":1114,"kind":12},{"line":1116,"kind":12,"name":"an1"},{"name":"an1","line":1117,"kind":12},{"name":"ax1","kind":12,"line":1119},{"name":"ax1","kind":12,"line":1120},{"kind":12,"line":1125,"name":"qgaps"},{"name":"qgaps","kind":12,"line":1127},{"kind":12,"line":1129,"name":"lgaps"},{"line":1130,"kind":12,"name":"lgaps"},{"name":"ax0","line":1136,"kind":12},{"line":1136,"kind":12,"name":"an0"},{"name":"ax1","line":1152,"kind":12},{"kind":12,"line":1152,"name":"an1"},{"name":"lframe","line":1173,"kind":12},{"line":1187,"kind":12,"name":"lframe"},{"line":1288,"kind":12,"name":"Name"},{"line":1318,"kind":12,"name":"CORE","containerName":"length"},{"name":"CORE","containerName":"length","kind":12,"line":1318},{"kind":13,"line":1354,"name":"$count","containerName":null},{"containerName":null,"name":"$self","kind":13,"line":1355},{"line":1355,"kind":12,"containerName":"main::","name":"_readline"},{"containerName":null,"name":"@data","line":1357,"kind":13},{"containerName":null,"name":"@data","line":1357,"kind":13},{"line":1358,"kind":13,"containerName":null,"name":"$self"},{"kind":12,"line":1358,"name":"characters","containerName":"main::"},{"name":"@data","containerName":null,"kind":13,"line":1361},{"name":"$self","containerName":null,"line":1364,"kind":13},{"kind":12,"line":1364,"containerName":"main::","name":"characters"},{"containerName":null,"name":"@data","kind":13,"line":1367},{"containerName":null,"name":"$self","line":1370,"kind":13},{"line":1370,"kind":12,"name":"characters","containerName":"main::"},{"name":"@data","containerName":null,"line":1373,"kind":13},{"containerName":null,"name":"%seentop","line":1379,"kind":13},{"name":"$self","containerName":null,"line":1380,"kind":13},{"line":1380,"kind":12,"containerName":"main::","name":"debug"},{"containerName":null,"name":"$self","kind":13,"line":1386},{"containerName":"main::","name":"in_element","line":1386,"kind":12},{"line":1387,"kind":13,"containerName":null,"name":"$self"},{"name":"in_element","containerName":"main::","line":1387,"kind":12},{"kind":13,"line":1388,"containerName":null,"name":"$self"},{"line":1388,"kind":12,"name":"end_element","containerName":"main::"},{"kind":13,"line":1390,"name":"$self","containerName":null},{"name":"in_element","containerName":"main::","line":1390,"kind":12},{"containerName":null,"name":"$self","kind":13,"line":1391},{"name":"end_element","containerName":"main::","kind":12,"line":1391},{"kind":13,"line":1393,"containerName":null,"name":"$self"},{"containerName":"main::","name":"end_element","kind":12,"line":1393},{"containerName":null,"name":"$self","kind":13,"line":1395},{"containerName":"main::","name":"end_document","kind":12,"line":1395},{"range":{"start":{"line":1409,"character":0},"end":{"character":9999,"line":1421}},"name":"start_element","line":1409,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"start_element","line":1410,"kind":13},{"containerName":"start_element","name":"$data","line":1410,"kind":13},{"localvar":"my","definition":"my","name":"$nm","containerName":"start_element","line":1413,"kind":13},{"containerName":"start_element","name":"$data","line":1413,"kind":13},{"kind":13,"line":1414,"definition":"my","name":"$type","containerName":"start_element","localvar":"my"},{"kind":13,"line":1414,"name":"$MODEMAP","containerName":"start_element"},{"line":1414,"kind":13,"containerName":"start_element","name":"$nm"},{"line":1415,"kind":13,"containerName":"start_element","name":"$self"},{"name":"_mode","containerName":"start_element","kind":12,"line":1415},{"containerName":"start_element","name":"$type","kind":13,"line":1415},{"kind":13,"line":1416,"containerName":"start_element","definition":"my","name":"$handler","localvar":"my"},{"kind":13,"line":1416,"name":"$self","containerName":"start_element"},{"line":1416,"kind":12,"containerName":"start_element","name":"_will_handle"},{"line":1416,"kind":13,"containerName":"start_element","name":"$type"},{"kind":13,"line":1417,"name":"$func","definition":"my","containerName":"start_element","localvar":"my"},{"containerName":"start_element","name":"$type","line":1417,"kind":13},{"name":"$handler","containerName":"start_element","line":1418,"kind":13},{"kind":13,"line":1418,"containerName":"start_element","name":"$func"},{"containerName":"start_element","name":"$data","kind":13,"line":1418},{"kind":13,"line":1420,"containerName":"start_element","name":"$self"},{"kind":13,"line":1420,"containerName":"start_element","name":"$type"}],"kind":12,"detail":"($self,$data)","signature":{"documentation":"1;\n# $Id: fasta.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::fasta\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::fasta - A SearchIO parser for FASTA results\n\n=head1 SYNOPSIS\n\n  # Do not use this object directly, use it through the SearchIO system\n   use Bio::SearchIO;\n   my $searchio = Bio::SearchIO->new(-format => 'fasta',\n                    -file   => 'report.FASTA');\n   while( my $result = $searchio->next_result ) {\n    # ... do what you would normally doi with Bio::SearchIO.\n   }\n\n=head1 DESCRIPTION\n\nThis object contains the event based parsing code for FASTA format\nreports.  It creates L<Bio::Search::HSP::FastaHSP> objects instead of\nL<Bio::Search::HSP::GenericHSP> for the HSP objects. \n\nThis module will parse -m 9 -d 0 output as well as default m 1 output\nfrom FASTA as well as SSEARCH.\n\nAlso see the SearchIO HOWTO:\nL<http://bioperl.open-bio.org/wiki/HOWTO:SearchIO>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich, Aaron Mackey\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::fasta;\nuse vars qw(%MODEMAP %MAPPING $IDLENGTH);\nuse strict;\n\n# Object preamble - inherits from Bio::Root::RootI\n\nuse Bio::Factory::ObjectFactory;\n\nBEGIN {\n\n    # Set IDLENGTH to a new value if you have\n    # compile FASTA with a different ID length\n    # (actually newest FASTA allows the setting of this\n    #  via -C parameter, default is 6)\n    $IDLENGTH = 6;\n\n    # mapping of NCBI Blast terms to Bioperl hash keys\n    %MODEMAP = (\n        'FastaOutput' => 'result',\n        'Hit'         => 'hit',\n        'Hsp'         => 'hsp'\n    );\n\n    # This should really be done more intelligently, like with\n    # XSLT\n\n    %MAPPING = (\n        'Hsp_bit-score'   => 'HSP-bits',\n        'Hsp_score'       => 'HSP-score',\n        'Hsp_sw-score'    => 'HSP-swscore',\n        'Hsp_evalue'      => 'HSP-evalue',\n        'Hsp_query-from'  => 'HSP-query_start',\n        'Hsp_query-to'    => 'HSP-query_end',\n        'Hsp_hit-from'    => 'HSP-hit_start',\n        'Hsp_hit-to'      => 'HSP-hit_end',\n        'Hsp_positive'    => 'HSP-conserved',\n        'Hsp_identity'    => 'HSP-identical',\n        'Hsp_gaps'        => 'HSP-hsp_gaps',\n        'Hsp_hitgaps'     => 'HSP-hit_gaps',\n        'Hsp_querygaps'   => 'HSP-query_gaps',\n        'Hsp_qseq'        => 'HSP-query_seq',\n        'Hsp_hseq'        => 'HSP-hit_seq',\n        'Hsp_midline'     => 'HSP-homology_seq',\n        'Hsp_align-len'   => 'HSP-hsp_length',\n        'Hsp_query-frame' => 'HSP-query_frame',\n        'Hsp_hit-frame'   => 'HSP-hit_frame',\n\n        'Hit_id'        => 'HIT-name',\n        'Hit_len'       => 'HIT-length',\n        'Hit_accession' => 'HIT-accession',\n        'Hit_def'       => 'HIT-description',\n        'Hit_signif'    => 'HIT-significance',\n        'Hit_score'     => 'HIT-score',\n\n        'FastaOutput_program'   => 'RESULT-algorithm_name',\n        'FastaOutput_version'   => 'RESULT-algorithm_version',\n        'FastaOutput_query-def' => 'RESULT-query_name',\n        'FastaOutput_querydesc' => 'RESULT-query_description',\n        'FastaOutput_query-len' => 'RESULT-query_length',\n        'FastaOutput_db'        => 'RESULT-database_name',\n        'FastaOutput_db-len'    => 'RESULT-database_entries',\n        'FastaOutput_db-let'    => 'RESULT-database_letters',\n\n        'Parameters_matrix'      => { 'RESULT-parameters' => 'matrix' },\n        'Parameters_expect'      => { 'RESULT-parameters' => 'expect' },\n        'Parameters_include'     => { 'RESULT-parameters' => 'include' },\n        'Parameters_sc-match'    => { 'RESULT-parameters' => 'match' },\n        'Parameters_sc-mismatch' => { 'RESULT-parameters' => 'mismatch' },\n        'Parameters_gap-open'    => { 'RESULT-parameters' => 'gapopen' },\n        'Parameters_gap-ext'     => { 'RESULT-parameters' => 'gapext' },\n        'Parameters_word-size'   => { 'RESULT-parameters' => 'wordsize' },\n        'Parameters_ktup'        => { 'RESULT-parameters' => 'ktup' },\n        'Parameters_filter'      => { 'RESULT-parameters' => 'filter' },\n        'Statistics_db-num'      => { 'RESULT-statistics' => 'dbentries' },\n        'Statistics_db-len'      => { 'RESULT-statistics' => 'dbletters' },\n        'Statistics_hsp-len'     => { 'RESULT-statistics' => 'hsplength' },\n        'Statistics_eff-space'   => { 'RESULT-statistics' => 'effectivespace' },\n        'Statistics_kappa'       => { 'RESULT-statistics' => 'kappa' },\n        'Statistics_lambda'      => { 'RESULT-statistics' => 'lambda' },\n        'Statistics_entropy'     => { 'RESULT-statistics' => 'entropy' },\n    );\n}\n\nuse base qw(Bio::SearchIO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::fasta->new();\n Function: Builds a new Bio::SearchIO::fasta object \n Returns : Bio::SearchIO::fasta\n Args    : -idlength - set ID length to something other \n                       than the default (7), this is only\n                       necessary if you have compiled FASTA\n                       with a new default id length to display\n                       in the HSP alignment blocks\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n    return unless @args;\n    my ($idlength) = $self->_rearrange( [qw(IDLENGTH)], @args );\n    $self->idlength( $idlength || $IDLENGTH );\n    $self->_eventHandler->register_factory(\n        'hsp',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::HSP::FastaHSP',\n            -interface => 'Bio::Search::HSP::HSPI'\n        )\n    );\n    return 1;\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    local $/ = \"\\n\";\n    local $_;\n\n    my $data    = '';\n    my $seentop = 0;\n    my $current_hsp;\n    $self->start_document();\n    my @hit_signifs;\n    while ( defined( $_ = $self->_readline ) ) {\n        next if ( !$self->in_element('hsp')\n            && /^\\s+$/ );    # skip empty lines\n        if (\n               m/(\\S+)\\s+searches\\s+a\\s+(protein\\s+or\\s+DNA\\s+)?sequence/oxi\n            || /(\\S+)\\s+compares\\s+a/\n            || (   m/^\\#\\s+/\n                && ( $_ = $self->_readline )\n                && /(\\S+)\\s+searches\\s+a\\s+(protein\\s+or\\s+DNA\\s+)?sequence/oxi\n                || /(\\S+)\\s+compares\\s+a/ )\n          )\n        {\n            if ($seentop) {\n                $self->_pushback($_);\n                $self->end_element( { 'Name' => 'FastaOutput' } );\n                return $self->end_document();\n            }\n            $self->{'_reporttype'} = $1;\n            $self->start_element( { 'Name' => 'FastaOutput' } );\n            $self->{'_result_count'}++;\n            $seentop = 1;\n            #$self->debug( \"reporttype is \" . $self->{'_reporttype'} . \"\\n\" );\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_program',\n                    'Data' => $self->{'_reporttype'}\n                }\n            );\n            $_ = $self->_readline();\n            my ($version) = (/version\\s+(\\S+)/);\n            $version = '' unless defined $version;\n            $self->{'_version'} = $version;\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_version',\n                    'Data' => $version\n                }\n            );\n\n            my ( $last, $leadin, $type, $querylen, $querytype, $querydef );\n\n            while ( defined( $_ = $self->_readline() ) ) {\n                if (\n                    /^ (\n                       (?:\\s+>) |             # fa33 lead-in\n                       (?:\\s*\\d+\\s*>>>)       # fa34 mlib lead-in\n                      )\n                      (.*)\n                   /x\n                  )\n                {\n                    ( $leadin, $querydef ) = ( $1, $2 );\n                    if ( $leadin =~ m/>>>/ ) {\n                        if ( $querydef =~\n                            /^(.*?)\\s+(?:\\-\\s+)?(\\d+)\\s+(aa|nt).*$/o )\n                        {\n                            ( $querydef, $querylen, $querytype ) =\n                              ( $1, $2, $3 );\n                            last;\n                        }\n                    }\n                    else {\n                        if ( $last =~ /(\\S+)[:,]\\s*(\\d+)\\s+(aa|nt)/ ) {\n                            ( $querylen, $querytype ) = ( $2, $3 );\n                            $querydef ||= $1;\n                            last;\n                        }\n                    }\n                }\n                elsif (m/^\\s*vs\\s+\\S+/o) {\n                    if ( $last =~ /(\\S+)[,:]\\s+(\\d+)\\s+(aa|nt)/o ) {\n                        ( $querydef, $querylen, $querytype ) = ( $1, $2, $3 );\n                        last;\n                    }\n                }\n                $last = $_;\n            }\n            if (   $self->{'_reporttype'}\n                && $self->{'_reporttype'} eq 'FASTA' )\n            {\n                if ( $querytype eq 'nt' ) {\n                    $self->{'_reporttype'} = 'FASTN';\n                }\n                elsif ( $querytype eq 'aa' ) {\n                    $self->{'_reporttype'} = 'FASTP';\n                }\n            }\n            my ( $name, $descr ) = $querydef =~ m/^(\\S+)\\s*(.*?)\\s*$/o;\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_query-def',\n                    'Data' => $name\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_querydesc',\n                    'Data' => $descr\n                }\n            );\n            if ($querylen) {\n                $self->element(\n                    {\n                        'Name' => 'FastaOutput_query-len',\n                        'Data' => $querylen\n                    }\n                );\n            }\n            else {\n                $self->warn(\"unable to find and set query length\");\n            }\n            if (\n                   $last =~ /^\\s*vs\\s+(\\S+)/\n                || ( $last =~ /^searching\\s+(\\S+)\\s+library/ )\n                || ( $last =~ /^Library:\\s+(\\S+)\\s+/ )\n                || (\n                    defined $_\n                    && (   /^\\s*vs\\s+(\\S+)/\n                        || /^Library:\\s+(\\S+)\\s+/ )\n                )\n                || ( defined( $_ = $self->_readline() )\n                    && ( /^\\s*vs\\s+(\\S+)/ || /^Library:\\s+(\\S+)/ ) )\n              )\n            {\n                $self->element(\n                    {\n                        'Name' => 'FastaOutput_db',\n                        'Data' => $1\n                    }\n                );\n            }\n            elsif (m/^\\s+opt(?:\\s+E\\(\\))?$/o) {\n\n           # histogram ... read over it more rapidly than the larger outer loop:\n                while ( defined( $_ = $self->_readline ) ) {\n                    last if m/^>\\d+/;\n                }\n            }\n        }\n        elsif (/(\\d+)\\s+residues\\s+in\\s+(\\d+)\\s+(?:library\\s+)?sequences/) {\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_db-let',\n                    'Data' => $1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_db-len',\n                    'Data' => $2\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Statistics_db-len',\n                    'Data' => $1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Statistics_db-num',\n                    'Data' => $2\n                }\n            );\n        }\n        elsif (/Lambda=\\s*(\\S+)/) {\n            $self->element(\n                {\n                    'Name' => 'Statistics_lambda',\n                    'Data' => $1\n                }\n            );\n        }\n        elsif (/K=\\s*(\\S+)/) {\n            $self->element(\n                {\n                    'Name' => 'Statistics_kappa',\n                    'Data' => $1\n                }\n            );\n        }\n        elsif (/^\\s*(Smith-Waterman).+(\\S+)\\s*matrix [^\\]]*?(xS)?\\]/) {\n            $self->element(\n                {\n                    'Name' => 'Parameters_matrix',\n                    'Data' => $2\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_filter',\n                    'Data' => defined $3 ? 1 : 0,\n                }\n            );\n            $self->{'_reporttype'} = $1;\n\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_program',\n                    'Data' => $self->{'_reporttype'}\n                }\n            );\n        }\n        elsif (/The best( related| unrelated)? scores are:/) {\n            my $rel    = $1;\n            my @labels = split;\n            @labels = map {\n                if ( $_ =~ m/^E\\((\\d+)\\)$/o )\n                {\n                    $self->element(\n                        { 'Name' => 'Statistics_eff-space', 'Data' => $1 } );\n                    \"evalue\";\n                }\n                else {\n                    $_;\n                }\n            } @labels[ $rel ? 5 : 4 .. $#labels ];\n\n            while ( defined( $_ = $self->_readline() )\n                && !/^\\s+$/ )\n            {\n                my @line = split;\n\n                if ( $line[-1] =~ m/\\=/o && $labels[-1] eq 'fs' ) {\n\n                    # unlabelled alignment hit;\n                    push @labels, \"aln_code\";\n                }\n\n                my %data;\n                @data{@labels} = splice( @line, @line - @labels );\n                if ( $line[-1] =~ m/\\[([1-6rf])\\]/o ) {\n                    my $fr = $1;\n                    $data{lframe} = (\n                        $fr =~ /\\d/o\n                        ? ( $fr <= 3 ? \"+$fr\" : \"-@{[$fr-3]}\" )\n                        : ( $fr eq 'f' ? '+1' : '-1' )\n                    );\n                    pop @line;\n                }\n                else {\n                    $data{lframe} = '0';\n                }\n\n                if ( $line[-1] =~ m/^\\(?(\\d+)\\)$/ ) {\n                    $data{hit_len} = $1;\n                    pop @line;\n                    if ( $line[-1] =~ m/^\\($/ ) {\n                        pop @line;\n                    }\n                }\n                else {\n                    $data{hit_len} = 0;\n                }\n\n                # rebuild the first part of the line, preserving spaces:\n                ($_) = m/^(\\S+(?:\\s+\\S+){$#line})/;\n\n                my ( $id, $desc ) = split( /\\s+/, $_, 2 );\n                my @pieces = split( /\\|/, $id );\n                my $acc = pop @pieces;\n                $acc =~ s/\\.\\d+$//;\n\n                @data{qw(id desc acc)} = ( $id, $desc, $acc );\n\n                push @hit_signifs, \\%data;\n            }\n        }\n        elsif (\n/^\\s*([T]?FAST[XYAF]).+,\\s*(\\S+)\\s*matrix[^\\]]+?(xS)?\\]\\s*ktup:\\s*(\\d+)/\n          )\n        {\n\n            $self->element(\n                {\n                    'Name' => 'Parameters_matrix',\n                    'Data' => $2\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_filter',\n                    'Data' => defined $3 ? 1 : 0,\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_ktup',\n                    'Data' => $4\n                }\n            );\n            $self->{'_reporttype'} = $1\n              if ( $self->{'_reporttype'} !~ /FAST[PN]/i );\n\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_program',\n                    'Data' => $self->{'_reporttype'}\n                }\n            );\n        }\n        elsif (/^Algorithm:\\s+(\\S+)\\s+\\(([^)]+)\\)\\s+(\\S+)/) {\n            $self->{'_reporttype'} = $1\n              if ( $self->{'_reporttype'} !~ /FAST[PN]/i );\n        }\n        elsif (\n            /^Parameters:\\s+(\\S+)\\s*matrix\\s*(?:\\(([^(]+?)\\))?\\s*ktup:\\s*(\\d+)/)\n        {    # FASTA 35.04\n            $self->element(\n                {\n                    'Name' => 'Parameters_matrix',\n                    'Data' => $1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_filter',\n                    'Data' => defined $2 ? $2 : 0,\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_ktup',\n                    'Data' => $3\n                }\n            );\n        }\n        elsif (\n/(?:gap\\-pen|open\\/ext):\\s+([\\-\\+]?\\d+)\\s*\\/\\s*([\\-\\+]?\\d+).+width:\\s+(\\d+)/\n          )\n        {\n            $self->element(\n                {\n                    'Name' => 'Parameters_gap-open',\n                    'Data' => $1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_gap-ext',\n                    'Data' => $2\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_word-size',\n                    'Data' => $3\n                }\n            );\n        }\n        elsif (/^>>(?!>)(.+?)\\s+(?:\\((\\d+)\\s*(aa|nt)\\))?$/) {\n            my ($hit_id, $len, $alphabet) = ($1, $2, $3);\n            if (!$len || !$alphabet) {\n                WRAPPED:\n                while (defined($_ = $self->_readline)) {\n                    if (/(.*?)\\s+\\((\\d+)\\s*(aa|nt)\\)/) {\n                        ($len, $alphabet) = ($2, $3);\n                        $hit_id .= $1 ? \" \".$1 : '';\n                        last WRAPPED;\n                    }\n                    if (/^>>(?!>)/) { # too far, throw\n                        $self->throw(\"Couldn't find length, bailing\");\n                    }\n                }\n            }\n            if ( $self->in_element('hsp') ) {\n                $self->end_element( { 'Name' => 'Hsp' } );\n            }\n            if ( $self->in_element('hit') ) {\n                $self->end_element( { 'Name' => 'Hit' } );\n            }\n\n            $self->start_element( { 'Name' => 'Hit' } );\n            $self->element(\n                {\n                    'Name' => 'Hit_len',\n                    'Data' => $len\n                }\n            );\n            my ( $id, $desc ) = split( /\\s+/, $hit_id, 2 );\n            $self->element(\n                {\n                    'Name' => 'Hit_id',\n                    'Data' => $id\n                }\n            );\n\n            #$self->debug(\"Hit ID is $id\\n\");\n            my @pieces = split( /\\|/, $id );\n            my $acc = pop @pieces;\n            $acc =~ s/\\.\\d+$//;\n            $self->element(\n                {\n                    'Name' => 'Hit_accession',\n                    'Data' => $acc\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hit_def',\n                    'Data' => $desc\n                }\n            );\n\n            $_ = $self->_readline();\n            my ( $score, $bits, $e ) = /Z-score: \\s* (\\S+) \\s*\n                               (?: bits: \\s* (\\S+) \\s+ )?\n                               (?: E|expect ) \\s* \\(\\) :? \\s*(\\S+)/ox;\n            $bits = $score unless defined $bits;\n\n            my $v = shift @hit_signifs;\n            if ( defined $v ) {\n                @{$v}{qw(evalue bits z-sc)} = ( $e, $bits, $score );\n            }\n            $self->element(\n                {\n                    'Name' => 'Hit_signif',\n                    'Data' => $v ? $v->{evalue} : $e\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hit_score',\n                    'Data' => $v ? $v->{bits} : $bits\n                }\n            );\n            $self->start_element( { 'Name' => 'Hsp' } );\n\n            $self->element(\n                {\n                    'Name' => 'Hsp_score',\n                    'Data' => $v ? $v->{'z-sc'} : $score\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_evalue',\n                    'Data' => $v ? $v->{evalue} : $e\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_bit-score',\n                    'Data' => $v ? $v->{bits} : $bits\n                }\n            );\n            $_ = $self->_readline();\n\n            if (s/Smith-Waterman score:\\s*(\\d+)\\;?//) {\n                $self->element(\n                    {\n                        'Name' => 'Hsp_sw-score',\n                        'Data' => $1\n                    }\n                );\n            }\n            if (\n                / (\\d*\\.?\\d+)\\% \\s* identity\n                 (?:\\s* \\(\\s*(\\S+)\\% \\s* (?:ungapped|similar) \\) )?\n                 \\s* in \\s* (\\d+) \\s+ (?:aa|nt) \\s+ overlap \\s*\n                 \\( (\\d+) \\- (\\d+) : (\\d+) \\- (\\d+) \\)\n               /x\n              )\n            {\n                my ( $identper, $gapper, $len, $querystart, $queryend,\n                    $hitstart, $hitend )\n                  = ( $1, $2, $3, $4, $5, $6, $7 );\n                my $ident = sprintf( \"%.0f\", ( $identper / 100 ) * $len );\n                my $positive = sprintf( \"%.0f\", ( $gapper / 100 ) * $len );\n\n                $self->element(\n                    {\n                        'Name' => 'Hsp_identity',\n                        'Data' => $ident\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'Hsp_positive',\n                        'Data' => $positive\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'Hsp_align-len',\n                        'Data' => $len\n                    }\n                );\n\n                $self->element(\n                    {\n                        'Name' => 'Hsp_query-from',\n                        'Data' => $querystart\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'Hsp_query-to',\n                        'Data' => $queryend\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'Hsp_hit-from',\n                        'Data' => $hitstart\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'Hsp_hit-to',\n                        'Data' => $hitend\n                    }\n                );\n\n            }\n\n            if ($v) {\n                $self->element(\n                    { 'Name' => 'Hsp_querygaps', 'Data' => $v->{qgaps} } )\n                  if exists $v->{qgaps};\n                $self->element(\n                    { 'Name' => 'Hsp_hitgaps', 'Data' => $v->{lgaps} } )\n                  if exists $v->{lgaps};\n\n                if ( $self->{'_reporttype'} =~ m/^FAST[NXY]$/o ) {\n                    if ( 8 == scalar grep { exists $v->{$_} }\n                        qw(an0 ax0 pn0 px0 an1 ax1 pn1 px1) )\n                    {\n                        if ( $v->{ax0} < $v->{an0} ) {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_query-frame',\n                                    'Data' =>\n                                      \"-@{[(($v->{px0} - $v->{ax0}) % 3) + 1]}\"\n                                }\n                            );\n                        }\n                        else {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_query-frame',\n                                    'Data' =>\n                                      \"+@{[(($v->{an0} - $v->{pn0}) % 3) + 1]}\"\n                                }\n                            );\n                        }\n                        if ( $v->{ax1} < $v->{an1} ) {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_hit-frame',\n                                    'Data' =>\n                                      \"-@{[(($v->{px1} - $v->{ax1}) % 3) + 1]}\"\n                                }\n                            );\n                        }\n                        else {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_hit-frame',\n                                    'Data' =>\n                                      \"+@{[(($v->{an1} - $v->{pn1}) % 3) + 1]}\"\n                                }\n                            );\n                        }\n                    }\n                    else {\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_query-frame',\n                                'Data' => $v->{lframe}\n                            }\n                        );\n                        $self->element(\n                            { 'Name' => 'Hsp_hit-frame', 'Data' => 0 } );\n                    }\n                }\n                else {\n                    $self->element(\n                        { 'Name' => 'Hsp_query-frame', 'Data' => 0 } );\n                    $self->element(\n                        { 'Name' => 'Hsp_hit-frame', 'Data' => $v->{lframe} } );\n                }\n\n            }\n            else {\n                $self->warn(\"unable to parse FASTA score line: $_\");\n            }\n        }\n        elsif (/\\d+\\s*residues\\s*in\\s*\\d+\\s*query\\s*sequences/) {\n            if ( $self->in_element('hsp') ) {\n                $self->end_element( { 'Name' => 'Hsp' } );\n            }\n            if ( $self->in_element('hit') ) {\n                $self->end_element( { 'Name' => 'Hit' } );\n            }\n\n           #       $_ = $self->_readline();\n           #       my ( $liblen,$libsize) = /(\\d+)\\s+residues\\s*in(\\d+)\\s*library/;\n           # fast forward to the end of the file as there is\n           # nothing else left to do with this file and want to be sure and\n           # reset it\n            while ( defined( $_ = $self->_readline() ) ) {\n                last if (/^Function used was/);\n                if (\n                    /(\\S+)\\s+searches\\s+a\\s+(protein\\s+or\\s+DNA\\s+)?\n           sequence/oxi || /(\\S+)\\s+compares\\s+a/oi\n                  )\n                {\n                    $self->_pushback($_);\n                }\n            }\n\n            if (@hit_signifs) {\n\n                # process remaining best hits\n                for my $h (@hit_signifs) {\n\n                    # Hsp_score Hsp_evalue Hsp_bit-score\n                    # Hsp_sw-score Hsp_gaps Hsp_identity Hsp_positive\n                    # Hsp_align-len Hsp_query-from Hsp_query-to\n                    # Hsp_hit-from Hsp_hit-to Hsp_qseq Hsp_midline\n\n                    $self->start_element( { 'Name' => 'Hit' } );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_len',\n                            'Data' => $h->{hit_len}\n                        }\n                    ) if exists $h->{hit_len};\n                    $self->element(\n                        {\n                            'Name' => 'Hit_id',\n                            'Data' => $h->{id}\n                        }\n                    ) if exists $h->{id};\n                    $self->element(\n                        {\n                            'Name' => 'Hit_accession',\n                            'Data' => $h->{acc}\n                        }\n                    ) if exists $h->{acc};\n                    $self->element(\n                        {\n                            'Name' => 'Hit_def',\n                            'Data' => $h->{desc}\n                        }\n                    ) if exists $h->{desc};\n                    $self->element(\n                        {\n                            'Name' => 'Hit_signif',\n                            'Data' => $h->{evalue}\n                        }\n                    ) if exists $h->{evalue};\n                    $self->element(\n                        {\n                            'Name' => 'Hit_score',\n                            'Data' => $h->{bits}\n                        }\n                    ) if exists $h->{bits};\n\n                    $self->start_element( { 'Name' => 'Hsp' } );\n                    $self->element(\n                        { 'Name' => 'Hsp_score', 'Data' => $h->{'z-sc'} } )\n                      if exists $h->{'z-sc'};\n                    $self->element(\n                        { 'Name' => 'Hsp_evalue', 'Data' => $h->{evalue} } )\n                      if exists $h->{evalue};\n                    $self->element(\n                        { 'Name' => 'Hsp_bit-score', 'Data' => $h->{bits} } )\n                      if exists $h->{bits};\n                    $self->element(\n                        { 'Name' => 'Hsp_sw-score', 'Data' => $h->{sw} } )\n                      if exists $h->{sw};\n                    $self->element(\n                        { 'Name' => 'Hsp_gaps', 'Data' => $h->{'%_gid'} } )\n                      if exists $h->{'%_gid'};\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_identity',\n                            'Data' =>\n                              sprintf( \"%.0f\", $h->{'%_id'} * $h->{alen} )\n                        }\n                    ) if ( exists $h->{'%_id'} && exists $h->{alen} );\n\n                    if ( exists $h->{'%_gid'} ) {\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_positive',\n                                'Data' =>\n                                  sprintf( \"%.0f\", $h->{'%_gid'} * $h->{alen} )\n                            }\n                        ) if exists $h->{'%_gid'} && exists $h->{alen};\n                    }\n                    else {\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_positive',\n                                'Data' =>\n                                  sprintf( \"%.0f\", $h->{'%_id'} * $h->{alen} )\n                            }\n                        ) if ( exists $h->{'%_id'} && exists $h->{alen} );\n                    }\n                    $self->element(\n                        { 'Name' => 'Hsp_align-len', 'Data' => $h->{alen} } )\n                      if exists $h->{alen};\n                    $self->element(\n                        { 'Name' => 'Hsp_query-from', 'Data' => $h->{an0} } )\n                      if exists $h->{an0};\n                    $self->element(\n                        { 'Name' => 'Hsp_query-to', 'Data' => $h->{ax0} } )\n                      if exists $h->{ax0};\n                    $self->element(\n                        { 'Name' => 'Hsp_hit-from', 'Data' => $h->{an1} } )\n                      if exists $h->{an1};\n                    $self->element(\n                        { 'Name' => 'Hsp_hit-to', 'Data' => $h->{ax1} } )\n                      if exists $h->{ax1};\n\n                    $self->element(\n                        { 'Name' => 'Hsp_querygaps', 'Data' => $h->{qgaps} } )\n                      if exists $h->{qgaps};\n                    $self->element(\n                        { 'Name' => 'Hsp_hitgaps', 'Data' => $h->{lgaps} } )\n                      if exists $h->{lgaps};\n\n                    if ( $self->{'_reporttype'} =~ m/^FAST[NXY]$/o ) {\n                        if ( 8 == scalar grep { exists $h->{$_} }\n                            qw(an0 ax0 pn0 px0 an1 ax1 pn1 px1) )\n                        {\n                            if ( $h->{ax0} < $h->{an0} ) {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_query-frame',\n                                        'Data' =>\n\"-@{[(($h->{px0} - $h->{ax0}) % 3) + 1]}\"\n                                    }\n                                );\n                            }\n                            else {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_query-frame',\n                                        'Data' =>\n\"+@{[(($h->{an0} - $h->{pn0}) % 3) + 1]}\"\n                                    }\n                                );\n                            }\n                            if ( $h->{ax1} < $h->{an1} ) {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_hit-frame',\n                                        'Data' =>\n\"-@{[(($h->{px1} - $h->{ax1}) % 3) + 1]}\"\n                                    }\n                                );\n                            }\n                            else {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_hit-frame',\n                                        'Data' =>\n\"+@{[(($h->{an1} - $h->{pn1}) % 3) + 1]}\"\n                                    }\n                                );\n                            }\n                        }\n                        else {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_query-frame',\n                                    'Data' => $h->{lframe}\n                                }\n                            );\n                            $self->element(\n                                { 'Name' => 'Hsp_hit-frame', 'Data' => 0 } );\n                        }\n                    }\n                    else {\n                        $self->element(\n                            { 'Name' => 'Hsp_query-frame', 'Data' => 0 } );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_hit-frame',\n                                'Data' => $h->{lframe}\n                            }\n                        );\n                    }\n\n                    $self->end_element( { 'Name' => 'Hsp' } );\n                    $self->end_element( { 'Name' => 'Hit' } );\n                }\n            }\n            $self->end_element( { 'Name' => 'FastaOutput' } );\n            return $self->end_document();\n        }\n        elsif (/^\\s*\\d+\\s*>>>/) {\n            if ( $self->within_element('FastaOutput') ) {\n                if ( $self->in_element('hsp') ) {\n                    $self->end_element( { 'Name' => 'Hsp' } );\n                }\n                if ( $self->in_element('hit') ) {\n                    $self->end_element( { 'Name' => 'Hit' } );\n                }\n\n                if (@hit_signifs) {\n\n                    # process remaining best hits\n                    for my $h (@hit_signifs) {\n                        $self->start_element( { 'Name' => 'Hit' } );\n                        $self->element(\n                            {\n                                'Name' => 'Hit_len',\n                                'Data' => $h->{hit_len}\n                            }\n                        ) if exists $h->{hit_len};\n                        $self->element(\n                            {\n                                'Name' => 'Hit_id',\n                                'Data' => $h->{id}\n                            }\n                        ) if exists $h->{id};\n                        $self->element(\n                            {\n                                'Name' => 'Hit_accession',\n                                'Data' => $h->{acc}\n                            }\n                        ) if exists $h->{acc};\n                        $self->element(\n                            {\n                                'Name' => 'Hit_def',\n                                'Data' => $h->{desc}\n                            }\n                        ) if exists $h->{desc};\n                        $self->element(\n                            {\n                                'Name' => 'Hit_signif',\n                                'Data' => $h->{evalue}\n                            }\n                        ) if exists $h->{evalue};\n                        $self->element(\n                            {\n                                'Name' => 'Hit_score',\n                                'Data' => $h->{bits}\n                            }\n                        ) if exists $h->{bits};\n\n                        $self->start_element( { 'Name' => 'Hsp' } );\n                        $self->element(\n                            { 'Name' => 'Hsp_score', 'Data' => $h->{'z-sc'} } )\n                          if exists $h->{'z-sc'};\n                        $self->element(\n                            { 'Name' => 'Hsp_evalue', 'Data' => $h->{evalue} } )\n                          if exists $h->{evalue};\n                        $self->element(\n                            { 'Name' => 'Hsp_bit-score', 'Data' => $h->{bits} }\n                        ) if exists $h->{bits};\n                        $self->element(\n                            { 'Name' => 'Hsp_sw-score', 'Data' => $h->{sw} } )\n                          if exists $h->{sw};\n                        $self->element(\n                            { 'Name' => 'Hsp_gaps', 'Data' => $h->{'%_gid'} } )\n                          if exists $h->{'%_gid'};\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_identity',\n                                'Data' =>\n                                  sprintf( \"%.0f\", $h->{'%_id'} * $h->{alen} )\n                            }\n                        ) if ( exists $h->{'%_id'} && exists $h->{alen} );\n\n                        if ( exists $h->{'%_gid'} ) {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_positive',\n                                    'Data' => sprintf( \"%.0f\",\n                                        $h->{'%_gid'} * $h->{alen} )\n                                }\n                            ) if exists $h->{'%_gid'} && exists $h->{alen};\n                        }\n                        else {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_positive',\n                                    'Data' => sprintf( \"%.0f\",\n                                        $h->{'%_id'} * $h->{alen} )\n                                }\n                            ) if ( exists $h->{'%_id'} && exists $h->{alen} );\n                        }\n                        $self->element(\n                            { 'Name' => 'Hsp_align-len', 'Data' => $h->{alen} }\n                        ) if exists $h->{alen};\n                        $self->element(\n                            { 'Name' => 'Hsp_query-from', 'Data' => $h->{an0} }\n                        ) if exists $h->{an0};\n                        $self->element(\n                            { 'Name' => 'Hsp_query-to', 'Data' => $h->{ax0} } )\n                          if exists $h->{ax0};\n                        $self->element(\n                            { 'Name' => 'Hsp_hit-from', 'Data' => $h->{an1} } )\n                          if exists $h->{an1};\n                        $self->element(\n                            { 'Name' => 'Hsp_hit-to', 'Data' => $h->{ax1} } )\n                          if exists $h->{ax1};\n\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_querygaps',\n                                'Data' => $h->{qgaps}\n                            }\n                        ) if exists $h->{qgaps};\n                        $self->element(\n                            { 'Name' => 'Hsp_hitgaps', 'Data' => $h->{lgaps} } )\n                          if exists $h->{lgaps};\n\n                        if ( $self->{'_reporttype'} =~ m/^FAST[NXY]$/o ) {\n                            if ( 8 == scalar grep { exists $h->{$_} }\n                                qw(an0 ax0 pn0 px0 an1 ax1 pn1 px1) )\n                            {\n                                if ( $h->{ax0} < $h->{an0} ) {\n                                    $self->element(\n                                        {\n                                            'Name' => 'Hsp_query-frame',\n                                            'Data' => \"-@{[(($h->{px0} - $h->{ax0}) % 3) + 1]}\"\n                                        }\n                                    );\n                                }\n                                else {\n                                    $self->element(\n                                        {\n                                            'Name' => 'Hsp_query-frame',\n                                            'Data' => \"+@{[(($h->{an0} - $h->{pn0}) % 3) + 1]}\"\n                                        }\n                                    );\n                                }\n                                if ( $h->{ax1} < $h->{an1} ) {\n                                    $self->element(\n                                        {\n                                            'Name' => 'Hsp_hit-frame',\n                                            'Data' => \"-@{[(($h->{px1} - $h->{ax1}) % 3) + 1]}\"\n                                        }\n                                    );\n                                }\n                                else {\n                                    $self->element(\n                                        {\n                                            'Name' => 'Hsp_hit-frame',\n                                            'Data' => \"+@{[(($h->{an1} - $h->{pn1}) % 3) + 1]}\"\n                                        }\n                                    );\n                                }\n                            }\n                            else {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_query-frame',\n                                        'Data' => $h->{lframe}\n                                    }\n                                );\n                                $self->element(\n                                    { 'Name' => 'Hsp_hit-frame', 'Data' => 0 }\n                                );\n                            }\n                        }\n                        else {\n                            $self->element(\n                                { 'Name' => 'Hsp_query-frame', 'Data' => 0 } );\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_hit-frame',\n                                    'Data' => $h->{lframe}\n                                }\n                            );\n                        }\n\n                        $self->end_element( { 'Name' => 'Hsp' } );\n                        $self->end_element( { 'Name' => 'Hit' } );\n                    }\n                }\n                $self->end_element( { 'Name' => 'FastaOutput' } );\n                $self->_pushback($_);\n                return $self->end_document();\n            }\n            else {\n                $self->start_element( { 'Name' => 'FastaOutput' } );\n                $self->{'_result_count'}++;\n                $seentop = 1;\n                $self->element(\n                    {\n                        'Name' => 'FastaOutput_program',\n                        'Data' => $self->{'_reporttype'}\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'FastaOutput_version',\n                        'Data' => $self->{'_version'}\n                    }\n                );\n\n                my ( $type, $querylen, $querytype, $querydef );\n\n                if (/^\\s*\\d+\\s*>>>(.*)/) {\n                    $querydef = $1;\n                    if ( $querydef =~ /^(.*?)\\s+(?:\\-\\s+)?(\\d+)\\s+(aa|nt).*$/o )\n                    {\n                        ( $querydef, $querylen, $querytype ) = ( $1, $2, $3 );\n                    }\n                }\n\n                if (   $self->{'_reporttype'}\n                    && $self->{'_reporttype'} eq 'FASTA' )\n                {\n                    if ( $querytype eq 'nt' ) {\n                        $self->{'_reporttype'} = 'FASTN';\n                    }\n                    elsif ( $querytype eq 'aa' ) {\n                        $self->{'_reporttype'} = 'FASTP';\n                    }\n                }\n                my ( $name, $descr ) =\n                  ( $querydef =~ m/^(\\S+)(?:\\s+(.*))?\\s*$/o );\n                $self->element(\n                    {\n                        'Name' => 'FastaOutput_query-def',\n                        'Data' => $name\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'FastaOutput_querydesc',\n                        'Data' => $descr\n                    }\n                );\n                if ($querylen) {\n                    $self->element(\n                        {\n                            'Name' => 'FastaOutput_query-len',\n                            'Data' => $querylen\n                        }\n                    );\n                }\n                else {\n                    $self->warn(\"unable to find and set query length\");\n                }\n                if ( defined( $_ = $self->_readline() )\n                    && ( /^\\s*vs\\s+(\\S+)/ || /^Library:\\s+(\\S+)/ ) )\n                {\n                    $self->element(\n                        {\n                            'Name' => 'FastaOutput_db',\n                            'Data' => $1\n                        }\n                    );\n                }\n\n            }\n        }\n        elsif ( $self->in_element('hsp') ) {\n            my @data  = ( [], [], [] );\n            my $count = 0;\n            my $len   = $self->idlength + 1;\n            my ($seq1_id);\n            while ( defined($_) ) {\n                chomp;\n                #$self->debug(\"$count $_\\n\");\n                if (/residues in \\d+\\s+query\\s+sequences/o) {\n                    $self->_pushback($_);\n                    last;\n                }\n                elsif (/^>>>\\*\\*\\*/o) {\n                    $self->end_element( { Name => \"Hsp\" } );\n                    last;\n                }\n                elsif (/^>>/o) {\n                    $self->_pushback($_);\n                    last;\n                }\n                elsif (/^\\s*\\d+\\s*>>>/o) {\n                    $self->_pushback($_);\n                    last;\n                }\n                if ( $count == 0 ) {\n                    if (/^(\\S+)\\s+/) {\n                        $self->_pushback($_);\n                        $count = 2;\n                    }\n                    elsif ( /^\\s+\\d+/ || /^\\s+$/ ) {\n\n                        # do nothing, this is really a 0 line\n                    }\n                    elsif ( length($_) == 0 ) {\n                        $count = -1;\n                    }\n                    else {\n                        $self->_pushback($_);\n                        $count = 0;\n                    }\n                }\n                elsif ( $count == 1 || $count == 3 ) {\n                    if (/^(\\S+)\\s+/) {\n                        $len = CORE::length($1) if $len < CORE::length($1);\n                        s/\\s+$//;    # trim trailing spaces,we don't want them\n                        push @{ $data[ $count - 1 ] }, substr( $_, $len );\n                    }\n                    elsif (/^\\s+(\\d+)/) {\n                        $count = -1;\n                        $self->_pushback($_);\n                    }\n                    elsif ( /^\\s+$/ || length($_) == 0 ) {\n                        $count = 5;\n\n                        # going to skip these\n                    }\n                    else {\n                        $self->throw(\n                            \"Unrecognized alignment line ($count) '$_'\");\n                    }\n                }\n                elsif ( $count == 2 ) {\n                    if (/^\\s+\\d+\\s+/) {\n                        $self->warn(\"$_\\n\") if $self->verbose > 0;\n\n                        # we are on a Subject part of the alignment\n                        # but we THOUGHT we were on the Query\n                        # move that last line to the proper place\n                        push @{ $data[2] }, pop @{ $data[0] };\n                        $count = 4;\n                    }\n                    else {\n\n                        # toss the first IDLENGTH characters of the line\n                        if ( length($_) >= $len ) {\n                            push @{ $data[ $count - 1 ] }, substr( $_, $len );\n                        }\n                    }\n                }\n                last if ( $count++ >= 5 );\n                $_ = $self->_readline();\n            }\n            if ( @{ $data[0] } || @{ $data[2] } ) {\n                $self->characters(\n                    {\n                        'Name' => 'Hsp_qseq',\n                        'Data' => join( '', @{ $data[0] } )\n                    }\n                );\n                $self->characters(\n                    {\n                        'Name' => 'Hsp_midline',\n                        'Data' => join( '', @{ $data[1] } )\n                    }\n                );\n                $self->characters(\n                    {\n                        'Name' => 'Hsp_hseq',\n                        'Data' => join( '', @{ $data[2] } )\n                    }\n                );\n            }\n        }\n        else {\n            if ( !$seentop ) {\n                $self->debug($_);\n                #$self->warn(\"unrecognized FASTA Family report file!\");\n                #return;\n            }\n        }\n    }\n    if ( $self->in_element('result') ) {\n        if ( $self->in_element('hsp') ) {\n            $self->end_element( { 'Name' => 'Hsp' } );\n        }\n        if ( $self->in_element('hit') ) {\n            $self->end_element( { 'Name' => 'Hit' } );\n        }\n        $self->end_element( { 'Name' => 'FastaOutput' } );\n    }\n    return $self->end_document();\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'","parameters":[{"label":"$self"},{"label":"$data"}],"label":"start_element($self,$data)"},"containerName":"main::","definition":"sub"},{"line":1422,"kind":13,"name":"%nm","containerName":null},{"line":1423,"kind":13,"name":"%self","containerName":null},{"containerName":null,"name":"%self","kind":13,"line":1424},{"containerName":null,"name":"%self","line":1425,"kind":13},{"detail":"($self,$data)","signature":{"documentation":"1;\n# $Id: fasta.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::fasta\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::fasta - A SearchIO parser for FASTA results\n\n=head1 SYNOPSIS\n\n  # Do not use this object directly, use it through the SearchIO system\n   use Bio::SearchIO;\n   my $searchio = Bio::SearchIO->new(-format => 'fasta',\n                    -file   => 'report.FASTA');\n   while( my $result = $searchio->next_result ) {\n    # ... do what you would normally doi with Bio::SearchIO.\n   }\n\n=head1 DESCRIPTION\n\nThis object contains the event based parsing code for FASTA format\nreports.  It creates L<Bio::Search::HSP::FastaHSP> objects instead of\nL<Bio::Search::HSP::GenericHSP> for the HSP objects. \n\nThis module will parse -m 9 -d 0 output as well as default m 1 output\nfrom FASTA as well as SSEARCH.\n\nAlso see the SearchIO HOWTO:\nL<http://bioperl.open-bio.org/wiki/HOWTO:SearchIO>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich, Aaron Mackey\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::fasta;\nuse vars qw(%MODEMAP %MAPPING $IDLENGTH);\nuse strict;\n\n# Object preamble - inherits from Bio::Root::RootI\n\nuse Bio::Factory::ObjectFactory;\n\nBEGIN {\n\n    # Set IDLENGTH to a new value if you have\n    # compile FASTA with a different ID length\n    # (actually newest FASTA allows the setting of this\n    #  via -C parameter, default is 6)\n    $IDLENGTH = 6;\n\n    # mapping of NCBI Blast terms to Bioperl hash keys\n    %MODEMAP = (\n        'FastaOutput' => 'result',\n        'Hit'         => 'hit',\n        'Hsp'         => 'hsp'\n    );\n\n    # This should really be done more intelligently, like with\n    # XSLT\n\n    %MAPPING = (\n        'Hsp_bit-score'   => 'HSP-bits',\n        'Hsp_score'       => 'HSP-score',\n        'Hsp_sw-score'    => 'HSP-swscore',\n        'Hsp_evalue'      => 'HSP-evalue',\n        'Hsp_query-from'  => 'HSP-query_start',\n        'Hsp_query-to'    => 'HSP-query_end',\n        'Hsp_hit-from'    => 'HSP-hit_start',\n        'Hsp_hit-to'      => 'HSP-hit_end',\n        'Hsp_positive'    => 'HSP-conserved',\n        'Hsp_identity'    => 'HSP-identical',\n        'Hsp_gaps'        => 'HSP-hsp_gaps',\n        'Hsp_hitgaps'     => 'HSP-hit_gaps',\n        'Hsp_querygaps'   => 'HSP-query_gaps',\n        'Hsp_qseq'        => 'HSP-query_seq',\n        'Hsp_hseq'        => 'HSP-hit_seq',\n        'Hsp_midline'     => 'HSP-homology_seq',\n        'Hsp_align-len'   => 'HSP-hsp_length',\n        'Hsp_query-frame' => 'HSP-query_frame',\n        'Hsp_hit-frame'   => 'HSP-hit_frame',\n\n        'Hit_id'        => 'HIT-name',\n        'Hit_len'       => 'HIT-length',\n        'Hit_accession' => 'HIT-accession',\n        'Hit_def'       => 'HIT-description',\n        'Hit_signif'    => 'HIT-significance',\n        'Hit_score'     => 'HIT-score',\n\n        'FastaOutput_program'   => 'RESULT-algorithm_name',\n        'FastaOutput_version'   => 'RESULT-algorithm_version',\n        'FastaOutput_query-def' => 'RESULT-query_name',\n        'FastaOutput_querydesc' => 'RESULT-query_description',\n        'FastaOutput_query-len' => 'RESULT-query_length',\n        'FastaOutput_db'        => 'RESULT-database_name',\n        'FastaOutput_db-len'    => 'RESULT-database_entries',\n        'FastaOutput_db-let'    => 'RESULT-database_letters',\n\n        'Parameters_matrix'      => { 'RESULT-parameters' => 'matrix' },\n        'Parameters_expect'      => { 'RESULT-parameters' => 'expect' },\n        'Parameters_include'     => { 'RESULT-parameters' => 'include' },\n        'Parameters_sc-match'    => { 'RESULT-parameters' => 'match' },\n        'Parameters_sc-mismatch' => { 'RESULT-parameters' => 'mismatch' },\n        'Parameters_gap-open'    => { 'RESULT-parameters' => 'gapopen' },\n        'Parameters_gap-ext'     => { 'RESULT-parameters' => 'gapext' },\n        'Parameters_word-size'   => { 'RESULT-parameters' => 'wordsize' },\n        'Parameters_ktup'        => { 'RESULT-parameters' => 'ktup' },\n        'Parameters_filter'      => { 'RESULT-parameters' => 'filter' },\n        'Statistics_db-num'      => { 'RESULT-statistics' => 'dbentries' },\n        'Statistics_db-len'      => { 'RESULT-statistics' => 'dbletters' },\n        'Statistics_hsp-len'     => { 'RESULT-statistics' => 'hsplength' },\n        'Statistics_eff-space'   => { 'RESULT-statistics' => 'effectivespace' },\n        'Statistics_kappa'       => { 'RESULT-statistics' => 'kappa' },\n        'Statistics_lambda'      => { 'RESULT-statistics' => 'lambda' },\n        'Statistics_entropy'     => { 'RESULT-statistics' => 'entropy' },\n    );\n}\n\nuse base qw(Bio::SearchIO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::fasta->new();\n Function: Builds a new Bio::SearchIO::fasta object \n Returns : Bio::SearchIO::fasta\n Args    : -idlength - set ID length to something other \n                       than the default (7), this is only\n                       necessary if you have compiled FASTA\n                       with a new default id length to display\n                       in the HSP alignment blocks\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n    return unless @args;\n    my ($idlength) = $self->_rearrange( [qw(IDLENGTH)], @args );\n    $self->idlength( $idlength || $IDLENGTH );\n    $self->_eventHandler->register_factory(\n        'hsp',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::HSP::FastaHSP',\n            -interface => 'Bio::Search::HSP::HSPI'\n        )\n    );\n    return 1;\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    local $/ = \"\\n\";\n    local $_;\n\n    my $data    = '';\n    my $seentop = 0;\n    my $current_hsp;\n    $self->start_document();\n    my @hit_signifs;\n    while ( defined( $_ = $self->_readline ) ) {\n        next if ( !$self->in_element('hsp')\n            && /^\\s+$/ );    # skip empty lines\n        if (\n               m/(\\S+)\\s+searches\\s+a\\s+(protein\\s+or\\s+DNA\\s+)?sequence/oxi\n            || /(\\S+)\\s+compares\\s+a/\n            || (   m/^\\#\\s+/\n                && ( $_ = $self->_readline )\n                && /(\\S+)\\s+searches\\s+a\\s+(protein\\s+or\\s+DNA\\s+)?sequence/oxi\n                || /(\\S+)\\s+compares\\s+a/ )\n          )\n        {\n            if ($seentop) {\n                $self->_pushback($_);\n                $self->end_element( { 'Name' => 'FastaOutput' } );\n                return $self->end_document();\n            }\n            $self->{'_reporttype'} = $1;\n            $self->start_element( { 'Name' => 'FastaOutput' } );\n            $self->{'_result_count'}++;\n            $seentop = 1;\n            #$self->debug( \"reporttype is \" . $self->{'_reporttype'} . \"\\n\" );\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_program',\n                    'Data' => $self->{'_reporttype'}\n                }\n            );\n            $_ = $self->_readline();\n            my ($version) = (/version\\s+(\\S+)/);\n            $version = '' unless defined $version;\n            $self->{'_version'} = $version;\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_version',\n                    'Data' => $version\n                }\n            );\n\n            my ( $last, $leadin, $type, $querylen, $querytype, $querydef );\n\n            while ( defined( $_ = $self->_readline() ) ) {\n                if (\n                    /^ (\n                       (?:\\s+>) |             # fa33 lead-in\n                       (?:\\s*\\d+\\s*>>>)       # fa34 mlib lead-in\n                      )\n                      (.*)\n                   /x\n                  )\n                {\n                    ( $leadin, $querydef ) = ( $1, $2 );\n                    if ( $leadin =~ m/>>>/ ) {\n                        if ( $querydef =~\n                            /^(.*?)\\s+(?:\\-\\s+)?(\\d+)\\s+(aa|nt).*$/o )\n                        {\n                            ( $querydef, $querylen, $querytype ) =\n                              ( $1, $2, $3 );\n                            last;\n                        }\n                    }\n                    else {\n                        if ( $last =~ /(\\S+)[:,]\\s*(\\d+)\\s+(aa|nt)/ ) {\n                            ( $querylen, $querytype ) = ( $2, $3 );\n                            $querydef ||= $1;\n                            last;\n                        }\n                    }\n                }\n                elsif (m/^\\s*vs\\s+\\S+/o) {\n                    if ( $last =~ /(\\S+)[,:]\\s+(\\d+)\\s+(aa|nt)/o ) {\n                        ( $querydef, $querylen, $querytype ) = ( $1, $2, $3 );\n                        last;\n                    }\n                }\n                $last = $_;\n            }\n            if (   $self->{'_reporttype'}\n                && $self->{'_reporttype'} eq 'FASTA' )\n            {\n                if ( $querytype eq 'nt' ) {\n                    $self->{'_reporttype'} = 'FASTN';\n                }\n                elsif ( $querytype eq 'aa' ) {\n                    $self->{'_reporttype'} = 'FASTP';\n                }\n            }\n            my ( $name, $descr ) = $querydef =~ m/^(\\S+)\\s*(.*?)\\s*$/o;\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_query-def',\n                    'Data' => $name\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_querydesc',\n                    'Data' => $descr\n                }\n            );\n            if ($querylen) {\n                $self->element(\n                    {\n                        'Name' => 'FastaOutput_query-len',\n                        'Data' => $querylen\n                    }\n                );\n            }\n            else {\n                $self->warn(\"unable to find and set query length\");\n            }\n            if (\n                   $last =~ /^\\s*vs\\s+(\\S+)/\n                || ( $last =~ /^searching\\s+(\\S+)\\s+library/ )\n                || ( $last =~ /^Library:\\s+(\\S+)\\s+/ )\n                || (\n                    defined $_\n                    && (   /^\\s*vs\\s+(\\S+)/\n                        || /^Library:\\s+(\\S+)\\s+/ )\n                )\n                || ( defined( $_ = $self->_readline() )\n                    && ( /^\\s*vs\\s+(\\S+)/ || /^Library:\\s+(\\S+)/ ) )\n              )\n            {\n                $self->element(\n                    {\n                        'Name' => 'FastaOutput_db',\n                        'Data' => $1\n                    }\n                );\n            }\n            elsif (m/^\\s+opt(?:\\s+E\\(\\))?$/o) {\n\n           # histogram ... read over it more rapidly than the larger outer loop:\n                while ( defined( $_ = $self->_readline ) ) {\n                    last if m/^>\\d+/;\n                }\n            }\n        }\n        elsif (/(\\d+)\\s+residues\\s+in\\s+(\\d+)\\s+(?:library\\s+)?sequences/) {\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_db-let',\n                    'Data' => $1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_db-len',\n                    'Data' => $2\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Statistics_db-len',\n                    'Data' => $1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Statistics_db-num',\n                    'Data' => $2\n                }\n            );\n        }\n        elsif (/Lambda=\\s*(\\S+)/) {\n            $self->element(\n                {\n                    'Name' => 'Statistics_lambda',\n                    'Data' => $1\n                }\n            );\n        }\n        elsif (/K=\\s*(\\S+)/) {\n            $self->element(\n                {\n                    'Name' => 'Statistics_kappa',\n                    'Data' => $1\n                }\n            );\n        }\n        elsif (/^\\s*(Smith-Waterman).+(\\S+)\\s*matrix [^\\]]*?(xS)?\\]/) {\n            $self->element(\n                {\n                    'Name' => 'Parameters_matrix',\n                    'Data' => $2\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_filter',\n                    'Data' => defined $3 ? 1 : 0,\n                }\n            );\n            $self->{'_reporttype'} = $1;\n\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_program',\n                    'Data' => $self->{'_reporttype'}\n                }\n            );\n        }\n        elsif (/The best( related| unrelated)? scores are:/) {\n            my $rel    = $1;\n            my @labels = split;\n            @labels = map {\n                if ( $_ =~ m/^E\\((\\d+)\\)$/o )\n                {\n                    $self->element(\n                        { 'Name' => 'Statistics_eff-space', 'Data' => $1 } );\n                    \"evalue\";\n                }\n                else {\n                    $_;\n                }\n            } @labels[ $rel ? 5 : 4 .. $#labels ];\n\n            while ( defined( $_ = $self->_readline() )\n                && !/^\\s+$/ )\n            {\n                my @line = split;\n\n                if ( $line[-1] =~ m/\\=/o && $labels[-1] eq 'fs' ) {\n\n                    # unlabelled alignment hit;\n                    push @labels, \"aln_code\";\n                }\n\n                my %data;\n                @data{@labels} = splice( @line, @line - @labels );\n                if ( $line[-1] =~ m/\\[([1-6rf])\\]/o ) {\n                    my $fr = $1;\n                    $data{lframe} = (\n                        $fr =~ /\\d/o\n                        ? ( $fr <= 3 ? \"+$fr\" : \"-@{[$fr-3]}\" )\n                        : ( $fr eq 'f' ? '+1' : '-1' )\n                    );\n                    pop @line;\n                }\n                else {\n                    $data{lframe} = '0';\n                }\n\n                if ( $line[-1] =~ m/^\\(?(\\d+)\\)$/ ) {\n                    $data{hit_len} = $1;\n                    pop @line;\n                    if ( $line[-1] =~ m/^\\($/ ) {\n                        pop @line;\n                    }\n                }\n                else {\n                    $data{hit_len} = 0;\n                }\n\n                # rebuild the first part of the line, preserving spaces:\n                ($_) = m/^(\\S+(?:\\s+\\S+){$#line})/;\n\n                my ( $id, $desc ) = split( /\\s+/, $_, 2 );\n                my @pieces = split( /\\|/, $id );\n                my $acc = pop @pieces;\n                $acc =~ s/\\.\\d+$//;\n\n                @data{qw(id desc acc)} = ( $id, $desc, $acc );\n\n                push @hit_signifs, \\%data;\n            }\n        }\n        elsif (\n/^\\s*([T]?FAST[XYAF]).+,\\s*(\\S+)\\s*matrix[^\\]]+?(xS)?\\]\\s*ktup:\\s*(\\d+)/\n          )\n        {\n\n            $self->element(\n                {\n                    'Name' => 'Parameters_matrix',\n                    'Data' => $2\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_filter',\n                    'Data' => defined $3 ? 1 : 0,\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_ktup',\n                    'Data' => $4\n                }\n            );\n            $self->{'_reporttype'} = $1\n              if ( $self->{'_reporttype'} !~ /FAST[PN]/i );\n\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_program',\n                    'Data' => $self->{'_reporttype'}\n                }\n            );\n        }\n        elsif (/^Algorithm:\\s+(\\S+)\\s+\\(([^)]+)\\)\\s+(\\S+)/) {\n            $self->{'_reporttype'} = $1\n              if ( $self->{'_reporttype'} !~ /FAST[PN]/i );\n        }\n        elsif (\n            /^Parameters:\\s+(\\S+)\\s*matrix\\s*(?:\\(([^(]+?)\\))?\\s*ktup:\\s*(\\d+)/)\n        {    # FASTA 35.04\n            $self->element(\n                {\n                    'Name' => 'Parameters_matrix',\n                    'Data' => $1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_filter',\n                    'Data' => defined $2 ? $2 : 0,\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_ktup',\n                    'Data' => $3\n                }\n            );\n        }\n        elsif (\n/(?:gap\\-pen|open\\/ext):\\s+([\\-\\+]?\\d+)\\s*\\/\\s*([\\-\\+]?\\d+).+width:\\s+(\\d+)/\n          )\n        {\n            $self->element(\n                {\n                    'Name' => 'Parameters_gap-open',\n                    'Data' => $1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_gap-ext',\n                    'Data' => $2\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_word-size',\n                    'Data' => $3\n                }\n            );\n        }\n        elsif (/^>>(?!>)(.+?)\\s+(?:\\((\\d+)\\s*(aa|nt)\\))?$/) {\n            my ($hit_id, $len, $alphabet) = ($1, $2, $3);\n            if (!$len || !$alphabet) {\n                WRAPPED:\n                while (defined($_ = $self->_readline)) {\n                    if (/(.*?)\\s+\\((\\d+)\\s*(aa|nt)\\)/) {\n                        ($len, $alphabet) = ($2, $3);\n                        $hit_id .= $1 ? \" \".$1 : '';\n                        last WRAPPED;\n                    }\n                    if (/^>>(?!>)/) { # too far, throw\n                        $self->throw(\"Couldn't find length, bailing\");\n                    }\n                }\n            }\n            if ( $self->in_element('hsp') ) {\n                $self->end_element( { 'Name' => 'Hsp' } );\n            }\n            if ( $self->in_element('hit') ) {\n                $self->end_element( { 'Name' => 'Hit' } );\n            }\n\n            $self->start_element( { 'Name' => 'Hit' } );\n            $self->element(\n                {\n                    'Name' => 'Hit_len',\n                    'Data' => $len\n                }\n            );\n            my ( $id, $desc ) = split( /\\s+/, $hit_id, 2 );\n            $self->element(\n                {\n                    'Name' => 'Hit_id',\n                    'Data' => $id\n                }\n            );\n\n            #$self->debug(\"Hit ID is $id\\n\");\n            my @pieces = split( /\\|/, $id );\n            my $acc = pop @pieces;\n            $acc =~ s/\\.\\d+$//;\n            $self->element(\n                {\n                    'Name' => 'Hit_accession',\n                    'Data' => $acc\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hit_def',\n                    'Data' => $desc\n                }\n            );\n\n            $_ = $self->_readline();\n            my ( $score, $bits, $e ) = /Z-score: \\s* (\\S+) \\s*\n                               (?: bits: \\s* (\\S+) \\s+ )?\n                               (?: E|expect ) \\s* \\(\\) :? \\s*(\\S+)/ox;\n            $bits = $score unless defined $bits;\n\n            my $v = shift @hit_signifs;\n            if ( defined $v ) {\n                @{$v}{qw(evalue bits z-sc)} = ( $e, $bits, $score );\n            }\n            $self->element(\n                {\n                    'Name' => 'Hit_signif',\n                    'Data' => $v ? $v->{evalue} : $e\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hit_score',\n                    'Data' => $v ? $v->{bits} : $bits\n                }\n            );\n            $self->start_element( { 'Name' => 'Hsp' } );\n\n            $self->element(\n                {\n                    'Name' => 'Hsp_score',\n                    'Data' => $v ? $v->{'z-sc'} : $score\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_evalue',\n                    'Data' => $v ? $v->{evalue} : $e\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_bit-score',\n                    'Data' => $v ? $v->{bits} : $bits\n                }\n            );\n            $_ = $self->_readline();\n\n            if (s/Smith-Waterman score:\\s*(\\d+)\\;?//) {\n                $self->element(\n                    {\n                        'Name' => 'Hsp_sw-score',\n                        'Data' => $1\n                    }\n                );\n            }\n            if (\n                / (\\d*\\.?\\d+)\\% \\s* identity\n                 (?:\\s* \\(\\s*(\\S+)\\% \\s* (?:ungapped|similar) \\) )?\n                 \\s* in \\s* (\\d+) \\s+ (?:aa|nt) \\s+ overlap \\s*\n                 \\( (\\d+) \\- (\\d+) : (\\d+) \\- (\\d+) \\)\n               /x\n              )\n            {\n                my ( $identper, $gapper, $len, $querystart, $queryend,\n                    $hitstart, $hitend )\n                  = ( $1, $2, $3, $4, $5, $6, $7 );\n                my $ident = sprintf( \"%.0f\", ( $identper / 100 ) * $len );\n                my $positive = sprintf( \"%.0f\", ( $gapper / 100 ) * $len );\n\n                $self->element(\n                    {\n                        'Name' => 'Hsp_identity',\n                        'Data' => $ident\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'Hsp_positive',\n                        'Data' => $positive\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'Hsp_align-len',\n                        'Data' => $len\n                    }\n                );\n\n                $self->element(\n                    {\n                        'Name' => 'Hsp_query-from',\n                        'Data' => $querystart\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'Hsp_query-to',\n                        'Data' => $queryend\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'Hsp_hit-from',\n                        'Data' => $hitstart\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'Hsp_hit-to',\n                        'Data' => $hitend\n                    }\n                );\n\n            }\n\n            if ($v) {\n                $self->element(\n                    { 'Name' => 'Hsp_querygaps', 'Data' => $v->{qgaps} } )\n                  if exists $v->{qgaps};\n                $self->element(\n                    { 'Name' => 'Hsp_hitgaps', 'Data' => $v->{lgaps} } )\n                  if exists $v->{lgaps};\n\n                if ( $self->{'_reporttype'} =~ m/^FAST[NXY]$/o ) {\n                    if ( 8 == scalar grep { exists $v->{$_} }\n                        qw(an0 ax0 pn0 px0 an1 ax1 pn1 px1) )\n                    {\n                        if ( $v->{ax0} < $v->{an0} ) {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_query-frame',\n                                    'Data' =>\n                                      \"-@{[(($v->{px0} - $v->{ax0}) % 3) + 1]}\"\n                                }\n                            );\n                        }\n                        else {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_query-frame',\n                                    'Data' =>\n                                      \"+@{[(($v->{an0} - $v->{pn0}) % 3) + 1]}\"\n                                }\n                            );\n                        }\n                        if ( $v->{ax1} < $v->{an1} ) {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_hit-frame',\n                                    'Data' =>\n                                      \"-@{[(($v->{px1} - $v->{ax1}) % 3) + 1]}\"\n                                }\n                            );\n                        }\n                        else {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_hit-frame',\n                                    'Data' =>\n                                      \"+@{[(($v->{an1} - $v->{pn1}) % 3) + 1]}\"\n                                }\n                            );\n                        }\n                    }\n                    else {\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_query-frame',\n                                'Data' => $v->{lframe}\n                            }\n                        );\n                        $self->element(\n                            { 'Name' => 'Hsp_hit-frame', 'Data' => 0 } );\n                    }\n                }\n                else {\n                    $self->element(\n                        { 'Name' => 'Hsp_query-frame', 'Data' => 0 } );\n                    $self->element(\n                        { 'Name' => 'Hsp_hit-frame', 'Data' => $v->{lframe} } );\n                }\n\n            }\n            else {\n                $self->warn(\"unable to parse FASTA score line: $_\");\n            }\n        }\n        elsif (/\\d+\\s*residues\\s*in\\s*\\d+\\s*query\\s*sequences/) {\n            if ( $self->in_element('hsp') ) {\n                $self->end_element( { 'Name' => 'Hsp' } );\n            }\n            if ( $self->in_element('hit') ) {\n                $self->end_element( { 'Name' => 'Hit' } );\n            }\n\n           #       $_ = $self->_readline();\n           #       my ( $liblen,$libsize) = /(\\d+)\\s+residues\\s*in(\\d+)\\s*library/;\n           # fast forward to the end of the file as there is\n           # nothing else left to do with this file and want to be sure and\n           # reset it\n            while ( defined( $_ = $self->_readline() ) ) {\n                last if (/^Function used was/);\n                if (\n                    /(\\S+)\\s+searches\\s+a\\s+(protein\\s+or\\s+DNA\\s+)?\n           sequence/oxi || /(\\S+)\\s+compares\\s+a/oi\n                  )\n                {\n                    $self->_pushback($_);\n                }\n            }\n\n            if (@hit_signifs) {\n\n                # process remaining best hits\n                for my $h (@hit_signifs) {\n\n                    # Hsp_score Hsp_evalue Hsp_bit-score\n                    # Hsp_sw-score Hsp_gaps Hsp_identity Hsp_positive\n                    # Hsp_align-len Hsp_query-from Hsp_query-to\n                    # Hsp_hit-from Hsp_hit-to Hsp_qseq Hsp_midline\n\n                    $self->start_element( { 'Name' => 'Hit' } );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_len',\n                            'Data' => $h->{hit_len}\n                        }\n                    ) if exists $h->{hit_len};\n                    $self->element(\n                        {\n                            'Name' => 'Hit_id',\n                            'Data' => $h->{id}\n                        }\n                    ) if exists $h->{id};\n                    $self->element(\n                        {\n                            'Name' => 'Hit_accession',\n                            'Data' => $h->{acc}\n                        }\n                    ) if exists $h->{acc};\n                    $self->element(\n                        {\n                            'Name' => 'Hit_def',\n                            'Data' => $h->{desc}\n                        }\n                    ) if exists $h->{desc};\n                    $self->element(\n                        {\n                            'Name' => 'Hit_signif',\n                            'Data' => $h->{evalue}\n                        }\n                    ) if exists $h->{evalue};\n                    $self->element(\n                        {\n                            'Name' => 'Hit_score',\n                            'Data' => $h->{bits}\n                        }\n                    ) if exists $h->{bits};\n\n                    $self->start_element( { 'Name' => 'Hsp' } );\n                    $self->element(\n                        { 'Name' => 'Hsp_score', 'Data' => $h->{'z-sc'} } )\n                      if exists $h->{'z-sc'};\n                    $self->element(\n                        { 'Name' => 'Hsp_evalue', 'Data' => $h->{evalue} } )\n                      if exists $h->{evalue};\n                    $self->element(\n                        { 'Name' => 'Hsp_bit-score', 'Data' => $h->{bits} } )\n                      if exists $h->{bits};\n                    $self->element(\n                        { 'Name' => 'Hsp_sw-score', 'Data' => $h->{sw} } )\n                      if exists $h->{sw};\n                    $self->element(\n                        { 'Name' => 'Hsp_gaps', 'Data' => $h->{'%_gid'} } )\n                      if exists $h->{'%_gid'};\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_identity',\n                            'Data' =>\n                              sprintf( \"%.0f\", $h->{'%_id'} * $h->{alen} )\n                        }\n                    ) if ( exists $h->{'%_id'} && exists $h->{alen} );\n\n                    if ( exists $h->{'%_gid'} ) {\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_positive',\n                                'Data' =>\n                                  sprintf( \"%.0f\", $h->{'%_gid'} * $h->{alen} )\n                            }\n                        ) if exists $h->{'%_gid'} && exists $h->{alen};\n                    }\n                    else {\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_positive',\n                                'Data' =>\n                                  sprintf( \"%.0f\", $h->{'%_id'} * $h->{alen} )\n                            }\n                        ) if ( exists $h->{'%_id'} && exists $h->{alen} );\n                    }\n                    $self->element(\n                        { 'Name' => 'Hsp_align-len', 'Data' => $h->{alen} } )\n                      if exists $h->{alen};\n                    $self->element(\n                        { 'Name' => 'Hsp_query-from', 'Data' => $h->{an0} } )\n                      if exists $h->{an0};\n                    $self->element(\n                        { 'Name' => 'Hsp_query-to', 'Data' => $h->{ax0} } )\n                      if exists $h->{ax0};\n                    $self->element(\n                        { 'Name' => 'Hsp_hit-from', 'Data' => $h->{an1} } )\n                      if exists $h->{an1};\n                    $self->element(\n                        { 'Name' => 'Hsp_hit-to', 'Data' => $h->{ax1} } )\n                      if exists $h->{ax1};\n\n                    $self->element(\n                        { 'Name' => 'Hsp_querygaps', 'Data' => $h->{qgaps} } )\n                      if exists $h->{qgaps};\n                    $self->element(\n                        { 'Name' => 'Hsp_hitgaps', 'Data' => $h->{lgaps} } )\n                      if exists $h->{lgaps};\n\n                    if ( $self->{'_reporttype'} =~ m/^FAST[NXY]$/o ) {\n                        if ( 8 == scalar grep { exists $h->{$_} }\n                            qw(an0 ax0 pn0 px0 an1 ax1 pn1 px1) )\n                        {\n                            if ( $h->{ax0} < $h->{an0} ) {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_query-frame',\n                                        'Data' =>\n\"-@{[(($h->{px0} - $h->{ax0}) % 3) + 1]}\"\n                                    }\n                                );\n                            }\n                            else {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_query-frame',\n                                        'Data' =>\n\"+@{[(($h->{an0} - $h->{pn0}) % 3) + 1]}\"\n                                    }\n                                );\n                            }\n                            if ( $h->{ax1} < $h->{an1} ) {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_hit-frame',\n                                        'Data' =>\n\"-@{[(($h->{px1} - $h->{ax1}) % 3) + 1]}\"\n                                    }\n                                );\n                            }\n                            else {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_hit-frame',\n                                        'Data' =>\n\"+@{[(($h->{an1} - $h->{pn1}) % 3) + 1]}\"\n                                    }\n                                );\n                            }\n                        }\n                        else {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_query-frame',\n                                    'Data' => $h->{lframe}\n                                }\n                            );\n                            $self->element(\n                                { 'Name' => 'Hsp_hit-frame', 'Data' => 0 } );\n                        }\n                    }\n                    else {\n                        $self->element(\n                            { 'Name' => 'Hsp_query-frame', 'Data' => 0 } );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_hit-frame',\n                                'Data' => $h->{lframe}\n                            }\n                        );\n                    }\n\n                    $self->end_element( { 'Name' => 'Hsp' } );\n                    $self->end_element( { 'Name' => 'Hit' } );\n                }\n            }\n            $self->end_element( { 'Name' => 'FastaOutput' } );\n            return $self->end_document();\n        }\n        elsif (/^\\s*\\d+\\s*>>>/) {\n            if ( $self->within_element('FastaOutput') ) {\n                if ( $self->in_element('hsp') ) {\n                    $self->end_element( { 'Name' => 'Hsp' } );\n                }\n                if ( $self->in_element('hit') ) {\n                    $self->end_element( { 'Name' => 'Hit' } );\n                }\n\n                if (@hit_signifs) {\n\n                    # process remaining best hits\n                    for my $h (@hit_signifs) {\n                        $self->start_element( { 'Name' => 'Hit' } );\n                        $self->element(\n                            {\n                                'Name' => 'Hit_len',\n                                'Data' => $h->{hit_len}\n                            }\n                        ) if exists $h->{hit_len};\n                        $self->element(\n                            {\n                                'Name' => 'Hit_id',\n                                'Data' => $h->{id}\n                            }\n                        ) if exists $h->{id};\n                        $self->element(\n                            {\n                                'Name' => 'Hit_accession',\n                                'Data' => $h->{acc}\n                            }\n                        ) if exists $h->{acc};\n                        $self->element(\n                            {\n                                'Name' => 'Hit_def',\n                                'Data' => $h->{desc}\n                            }\n                        ) if exists $h->{desc};\n                        $self->element(\n                            {\n                                'Name' => 'Hit_signif',\n                                'Data' => $h->{evalue}\n                            }\n                        ) if exists $h->{evalue};\n                        $self->element(\n                            {\n                                'Name' => 'Hit_score',\n                                'Data' => $h->{bits}\n                            }\n                        ) if exists $h->{bits};\n\n                        $self->start_element( { 'Name' => 'Hsp' } );\n                        $self->element(\n                            { 'Name' => 'Hsp_score', 'Data' => $h->{'z-sc'} } )\n                          if exists $h->{'z-sc'};\n                        $self->element(\n                            { 'Name' => 'Hsp_evalue', 'Data' => $h->{evalue} } )\n                          if exists $h->{evalue};\n                        $self->element(\n                            { 'Name' => 'Hsp_bit-score', 'Data' => $h->{bits} }\n                        ) if exists $h->{bits};\n                        $self->element(\n                            { 'Name' => 'Hsp_sw-score', 'Data' => $h->{sw} } )\n                          if exists $h->{sw};\n                        $self->element(\n                            { 'Name' => 'Hsp_gaps', 'Data' => $h->{'%_gid'} } )\n                          if exists $h->{'%_gid'};\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_identity',\n                                'Data' =>\n                                  sprintf( \"%.0f\", $h->{'%_id'} * $h->{alen} )\n                            }\n                        ) if ( exists $h->{'%_id'} && exists $h->{alen} );\n\n                        if ( exists $h->{'%_gid'} ) {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_positive',\n                                    'Data' => sprintf( \"%.0f\",\n                                        $h->{'%_gid'} * $h->{alen} )\n                                }\n                            ) if exists $h->{'%_gid'} && exists $h->{alen};\n                        }\n                        else {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_positive',\n                                    'Data' => sprintf( \"%.0f\",\n                                        $h->{'%_id'} * $h->{alen} )\n                                }\n                            ) if ( exists $h->{'%_id'} && exists $h->{alen} );\n                        }\n                        $self->element(\n                            { 'Name' => 'Hsp_align-len', 'Data' => $h->{alen} }\n                        ) if exists $h->{alen};\n                        $self->element(\n                            { 'Name' => 'Hsp_query-from', 'Data' => $h->{an0} }\n                        ) if exists $h->{an0};\n                        $self->element(\n                            { 'Name' => 'Hsp_query-to', 'Data' => $h->{ax0} } )\n                          if exists $h->{ax0};\n                        $self->element(\n                            { 'Name' => 'Hsp_hit-from', 'Data' => $h->{an1} } )\n                          if exists $h->{an1};\n                        $self->element(\n                            { 'Name' => 'Hsp_hit-to', 'Data' => $h->{ax1} } )\n                          if exists $h->{ax1};\n\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_querygaps',\n                                'Data' => $h->{qgaps}\n                            }\n                        ) if exists $h->{qgaps};\n                        $self->element(\n                            { 'Name' => 'Hsp_hitgaps', 'Data' => $h->{lgaps} } )\n                          if exists $h->{lgaps};\n\n                        if ( $self->{'_reporttype'} =~ m/^FAST[NXY]$/o ) {\n                            if ( 8 == scalar grep { exists $h->{$_} }\n                                qw(an0 ax0 pn0 px0 an1 ax1 pn1 px1) )\n                            {\n                                if ( $h->{ax0} < $h->{an0} ) {\n                                    $self->element(\n                                        {\n                                            'Name' => 'Hsp_query-frame',\n                                            'Data' => \"-@{[(($h->{px0} - $h->{ax0}) % 3) + 1]}\"\n                                        }\n                                    );\n                                }\n                                else {\n                                    $self->element(\n                                        {\n                                            'Name' => 'Hsp_query-frame',\n                                            'Data' => \"+@{[(($h->{an0} - $h->{pn0}) % 3) + 1]}\"\n                                        }\n                                    );\n                                }\n                                if ( $h->{ax1} < $h->{an1} ) {\n                                    $self->element(\n                                        {\n                                            'Name' => 'Hsp_hit-frame',\n                                            'Data' => \"-@{[(($h->{px1} - $h->{ax1}) % 3) + 1]}\"\n                                        }\n                                    );\n                                }\n                                else {\n                                    $self->element(\n                                        {\n                                            'Name' => 'Hsp_hit-frame',\n                                            'Data' => \"+@{[(($h->{an1} - $h->{pn1}) % 3) + 1]}\"\n                                        }\n                                    );\n                                }\n                            }\n                            else {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_query-frame',\n                                        'Data' => $h->{lframe}\n                                    }\n                                );\n                                $self->element(\n                                    { 'Name' => 'Hsp_hit-frame', 'Data' => 0 }\n                                );\n                            }\n                        }\n                        else {\n                            $self->element(\n                                { 'Name' => 'Hsp_query-frame', 'Data' => 0 } );\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_hit-frame',\n                                    'Data' => $h->{lframe}\n                                }\n                            );\n                        }\n\n                        $self->end_element( { 'Name' => 'Hsp' } );\n                        $self->end_element( { 'Name' => 'Hit' } );\n                    }\n                }\n                $self->end_element( { 'Name' => 'FastaOutput' } );\n                $self->_pushback($_);\n                return $self->end_document();\n            }\n            else {\n                $self->start_element( { 'Name' => 'FastaOutput' } );\n                $self->{'_result_count'}++;\n                $seentop = 1;\n                $self->element(\n                    {\n                        'Name' => 'FastaOutput_program',\n                        'Data' => $self->{'_reporttype'}\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'FastaOutput_version',\n                        'Data' => $self->{'_version'}\n                    }\n                );\n\n                my ( $type, $querylen, $querytype, $querydef );\n\n                if (/^\\s*\\d+\\s*>>>(.*)/) {\n                    $querydef = $1;\n                    if ( $querydef =~ /^(.*?)\\s+(?:\\-\\s+)?(\\d+)\\s+(aa|nt).*$/o )\n                    {\n                        ( $querydef, $querylen, $querytype ) = ( $1, $2, $3 );\n                    }\n                }\n\n                if (   $self->{'_reporttype'}\n                    && $self->{'_reporttype'} eq 'FASTA' )\n                {\n                    if ( $querytype eq 'nt' ) {\n                        $self->{'_reporttype'} = 'FASTN';\n                    }\n                    elsif ( $querytype eq 'aa' ) {\n                        $self->{'_reporttype'} = 'FASTP';\n                    }\n                }\n                my ( $name, $descr ) =\n                  ( $querydef =~ m/^(\\S+)(?:\\s+(.*))?\\s*$/o );\n                $self->element(\n                    {\n                        'Name' => 'FastaOutput_query-def',\n                        'Data' => $name\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'FastaOutput_querydesc',\n                        'Data' => $descr\n                    }\n                );\n                if ($querylen) {\n                    $self->element(\n                        {\n                            'Name' => 'FastaOutput_query-len',\n                            'Data' => $querylen\n                        }\n                    );\n                }\n                else {\n                    $self->warn(\"unable to find and set query length\");\n                }\n                if ( defined( $_ = $self->_readline() )\n                    && ( /^\\s*vs\\s+(\\S+)/ || /^Library:\\s+(\\S+)/ ) )\n                {\n                    $self->element(\n                        {\n                            'Name' => 'FastaOutput_db',\n                            'Data' => $1\n                        }\n                    );\n                }\n\n            }\n        }\n        elsif ( $self->in_element('hsp') ) {\n            my @data  = ( [], [], [] );\n            my $count = 0;\n            my $len   = $self->idlength + 1;\n            my ($seq1_id);\n            while ( defined($_) ) {\n                chomp;\n                #$self->debug(\"$count $_\\n\");\n                if (/residues in \\d+\\s+query\\s+sequences/o) {\n                    $self->_pushback($_);\n                    last;\n                }\n                elsif (/^>>>\\*\\*\\*/o) {\n                    $self->end_element( { Name => \"Hsp\" } );\n                    last;\n                }\n                elsif (/^>>/o) {\n                    $self->_pushback($_);\n                    last;\n                }\n                elsif (/^\\s*\\d+\\s*>>>/o) {\n                    $self->_pushback($_);\n                    last;\n                }\n                if ( $count == 0 ) {\n                    if (/^(\\S+)\\s+/) {\n                        $self->_pushback($_);\n                        $count = 2;\n                    }\n                    elsif ( /^\\s+\\d+/ || /^\\s+$/ ) {\n\n                        # do nothing, this is really a 0 line\n                    }\n                    elsif ( length($_) == 0 ) {\n                        $count = -1;\n                    }\n                    else {\n                        $self->_pushback($_);\n                        $count = 0;\n                    }\n                }\n                elsif ( $count == 1 || $count == 3 ) {\n                    if (/^(\\S+)\\s+/) {\n                        $len = CORE::length($1) if $len < CORE::length($1);\n                        s/\\s+$//;    # trim trailing spaces,we don't want them\n                        push @{ $data[ $count - 1 ] }, substr( $_, $len );\n                    }\n                    elsif (/^\\s+(\\d+)/) {\n                        $count = -1;\n                        $self->_pushback($_);\n                    }\n                    elsif ( /^\\s+$/ || length($_) == 0 ) {\n                        $count = 5;\n\n                        # going to skip these\n                    }\n                    else {\n                        $self->throw(\n                            \"Unrecognized alignment line ($count) '$_'\");\n                    }\n                }\n                elsif ( $count == 2 ) {\n                    if (/^\\s+\\d+\\s+/) {\n                        $self->warn(\"$_\\n\") if $self->verbose > 0;\n\n                        # we are on a Subject part of the alignment\n                        # but we THOUGHT we were on the Query\n                        # move that last line to the proper place\n                        push @{ $data[2] }, pop @{ $data[0] };\n                        $count = 4;\n                    }\n                    else {\n\n                        # toss the first IDLENGTH characters of the line\n                        if ( length($_) >= $len ) {\n                            push @{ $data[ $count - 1 ] }, substr( $_, $len );\n                        }\n                    }\n                }\n                last if ( $count++ >= 5 );\n                $_ = $self->_readline();\n            }\n            if ( @{ $data[0] } || @{ $data[2] } ) {\n                $self->characters(\n                    {\n                        'Name' => 'Hsp_qseq',\n                        'Data' => join( '', @{ $data[0] } )\n                    }\n                );\n                $self->characters(\n                    {\n                        'Name' => 'Hsp_midline',\n                        'Data' => join( '', @{ $data[1] } )\n                    }\n                );\n                $self->characters(\n                    {\n                        'Name' => 'Hsp_hseq',\n                        'Data' => join( '', @{ $data[2] } )\n                    }\n                );\n            }\n        }\n        else {\n            if ( !$seentop ) {\n                $self->debug($_);\n                #$self->warn(\"unrecognized FASTA Family report file!\");\n                #return;\n            }\n        }\n    }\n    if ( $self->in_element('result') ) {\n        if ( $self->in_element('hsp') ) {\n            $self->end_element( { 'Name' => 'Hsp' } );\n        }\n        if ( $self->in_element('hit') ) {\n            $self->end_element( { 'Name' => 'Hit' } );\n        }\n        $self->end_element( { 'Name' => 'FastaOutput' } );\n    }\n    return $self->end_document();\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element {\n    my ( $self, $data ) = @_;\n\n    # we currently don't care about attributes\n    my $nm = $data->{'Name'};\n    if ( my $type = $MODEMAP{$nm} ) {\n        $self->_mode($type);\n        if ( my $handler = $self->_will_handle($type) ) {\n            my $func = sprintf( \"start_%s\", lc $type );\n            $handler->$func( $data->{'Attributes'} );\n        }\n        unshift @{ $self->{'_elements'} }, $type;\n    }\n    if ( $nm eq 'FastaOutput' ) {\n        $self->{'_values'} = {};\n        $self->{'_result'} = undef;\n        $self->{'_mode'}   = '';\n    }\n\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'","parameters":[{"label":"$self"},{"label":"$data"}],"label":"end_element($self,$data)"},"containerName":"main::","definition":"sub","line":1441,"children":[{"containerName":"end_element","definition":"my","name":"$self","localvar":"my","kind":13,"line":1442},{"line":1442,"kind":13,"containerName":"end_element","name":"$data"},{"line":1443,"kind":13,"localvar":"my","name":"$nm","definition":"my","containerName":"end_element"},{"name":"$data","containerName":"end_element","kind":13,"line":1443},{"line":1444,"kind":13,"localvar":"my","containerName":"end_element","name":"$rc","definition":"my"},{"name":"$nm","containerName":"end_element","line":1448,"kind":13},{"name":"$self","containerName":"end_element","line":1450,"kind":13},{"name":"element","containerName":"end_element","kind":12,"line":1450},{"line":1453,"kind":13,"name":"$self","containerName":"end_element"},{"line":1457,"kind":13,"containerName":"end_element","name":"$self"},{"line":1460,"kind":13,"localvar":"my","name":"$type","definition":"my","containerName":"end_element"},{"kind":13,"line":1460,"containerName":"end_element","name":"$MODEMAP"},{"kind":13,"line":1460,"name":"$nm","containerName":"end_element"},{"localvar":"my","containerName":"end_element","definition":"my","name":"$handler","line":1461,"kind":13},{"kind":13,"line":1461,"name":"$self","containerName":"end_element"},{"line":1461,"kind":12,"name":"_will_handle","containerName":"end_element"},{"containerName":"end_element","name":"$type","kind":13,"line":1461},{"line":1462,"kind":13,"localvar":"my","name":"$func","definition":"my","containerName":"end_element"},{"containerName":"end_element","name":"$type","kind":13,"line":1462},{"line":1463,"kind":13,"name":"$rc","containerName":"end_element"},{"kind":13,"line":1463,"containerName":"end_element","name":"$handler"},{"name":"$func","containerName":"end_element","line":1463,"kind":13},{"containerName":"end_element","name":"$self","line":1463,"kind":13},{"line":1463,"kind":13,"containerName":"end_element","name":"$self"},{"name":"$self","containerName":"end_element","line":1465,"kind":13}],"kind":12,"range":{"start":{"character":0,"line":1441},"end":{"character":9999,"line":1467}},"name":"end_element"},{"kind":13,"line":1468,"containerName":null,"name":"%MAPPING"},{"line":1468,"kind":13,"name":"%nm","containerName":null},{"line":1469,"kind":13,"name":"%MAPPING","containerName":null},{"name":"%nm","containerName":null,"line":1469,"kind":13},{"name":"$key","definition":"my","containerName":null,"localvar":"my","kind":13,"line":1470},{"kind":13,"line":1470,"containerName":null,"name":"%MAPPING"},{"line":1470,"kind":13,"containerName":null,"name":"@nm"},{"containerName":null,"name":"%self","line":1471,"kind":13},{"name":"%key","containerName":null,"line":1471,"kind":13},{"kind":13,"line":1471,"name":"%MAPPING","containerName":null},{"line":1471,"kind":13,"containerName":null,"name":"%nm"},{"name":"$key","containerName":null,"kind":13,"line":1471},{"containerName":null,"name":"%self","kind":13,"line":1472},{"containerName":null,"name":"%self","kind":13,"line":1475},{"kind":13,"line":1475,"name":"%MAPPING","containerName":null},{"line":1475,"kind":13,"name":"$nm","containerName":null},{"containerName":null,"name":"%self","kind":13,"line":1475},{"kind":13,"line":1479,"containerName":null,"name":"$self"},{"kind":12,"line":1479,"containerName":"main::","name":"warn"},{"containerName":null,"name":"%self","kind":13,"line":1481},{"kind":13,"line":1483,"containerName":null,"name":"%self"},{"containerName":null,"name":"$rc","kind":13,"line":1483},{"kind":13,"line":1483,"name":"$nm","containerName":null},{"containerName":null,"name":"$rc","kind":13,"line":1484},{"signature":{"label":"element($self,$data)","documentation":"1;\n# $Id: fasta.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::fasta\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::fasta - A SearchIO parser for FASTA results\n\n=head1 SYNOPSIS\n\n  # Do not use this object directly, use it through the SearchIO system\n   use Bio::SearchIO;\n   my $searchio = Bio::SearchIO->new(-format => 'fasta',\n                    -file   => 'report.FASTA');\n   while( my $result = $searchio->next_result ) {\n    # ... do what you would normally doi with Bio::SearchIO.\n   }\n\n=head1 DESCRIPTION\n\nThis object contains the event based parsing code for FASTA format\nreports.  It creates L<Bio::Search::HSP::FastaHSP> objects instead of\nL<Bio::Search::HSP::GenericHSP> for the HSP objects. \n\nThis module will parse -m 9 -d 0 output as well as default m 1 output\nfrom FASTA as well as SSEARCH.\n\nAlso see the SearchIO HOWTO:\nL<http://bioperl.open-bio.org/wiki/HOWTO:SearchIO>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich, Aaron Mackey\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::fasta;\nuse vars qw(%MODEMAP %MAPPING $IDLENGTH);\nuse strict;\n\n# Object preamble - inherits from Bio::Root::RootI\n\nuse Bio::Factory::ObjectFactory;\n\nBEGIN {\n\n    # Set IDLENGTH to a new value if you have\n    # compile FASTA with a different ID length\n    # (actually newest FASTA allows the setting of this\n    #  via -C parameter, default is 6)\n    $IDLENGTH = 6;\n\n    # mapping of NCBI Blast terms to Bioperl hash keys\n    %MODEMAP = (\n        'FastaOutput' => 'result',\n        'Hit'         => 'hit',\n        'Hsp'         => 'hsp'\n    );\n\n    # This should really be done more intelligently, like with\n    # XSLT\n\n    %MAPPING = (\n        'Hsp_bit-score'   => 'HSP-bits',\n        'Hsp_score'       => 'HSP-score',\n        'Hsp_sw-score'    => 'HSP-swscore',\n        'Hsp_evalue'      => 'HSP-evalue',\n        'Hsp_query-from'  => 'HSP-query_start',\n        'Hsp_query-to'    => 'HSP-query_end',\n        'Hsp_hit-from'    => 'HSP-hit_start',\n        'Hsp_hit-to'      => 'HSP-hit_end',\n        'Hsp_positive'    => 'HSP-conserved',\n        'Hsp_identity'    => 'HSP-identical',\n        'Hsp_gaps'        => 'HSP-hsp_gaps',\n        'Hsp_hitgaps'     => 'HSP-hit_gaps',\n        'Hsp_querygaps'   => 'HSP-query_gaps',\n        'Hsp_qseq'        => 'HSP-query_seq',\n        'Hsp_hseq'        => 'HSP-hit_seq',\n        'Hsp_midline'     => 'HSP-homology_seq',\n        'Hsp_align-len'   => 'HSP-hsp_length',\n        'Hsp_query-frame' => 'HSP-query_frame',\n        'Hsp_hit-frame'   => 'HSP-hit_frame',\n\n        'Hit_id'        => 'HIT-name',\n        'Hit_len'       => 'HIT-length',\n        'Hit_accession' => 'HIT-accession',\n        'Hit_def'       => 'HIT-description',\n        'Hit_signif'    => 'HIT-significance',\n        'Hit_score'     => 'HIT-score',\n\n        'FastaOutput_program'   => 'RESULT-algorithm_name',\n        'FastaOutput_version'   => 'RESULT-algorithm_version',\n        'FastaOutput_query-def' => 'RESULT-query_name',\n        'FastaOutput_querydesc' => 'RESULT-query_description',\n        'FastaOutput_query-len' => 'RESULT-query_length',\n        'FastaOutput_db'        => 'RESULT-database_name',\n        'FastaOutput_db-len'    => 'RESULT-database_entries',\n        'FastaOutput_db-let'    => 'RESULT-database_letters',\n\n        'Parameters_matrix'      => { 'RESULT-parameters' => 'matrix' },\n        'Parameters_expect'      => { 'RESULT-parameters' => 'expect' },\n        'Parameters_include'     => { 'RESULT-parameters' => 'include' },\n        'Parameters_sc-match'    => { 'RESULT-parameters' => 'match' },\n        'Parameters_sc-mismatch' => { 'RESULT-parameters' => 'mismatch' },\n        'Parameters_gap-open'    => { 'RESULT-parameters' => 'gapopen' },\n        'Parameters_gap-ext'     => { 'RESULT-parameters' => 'gapext' },\n        'Parameters_word-size'   => { 'RESULT-parameters' => 'wordsize' },\n        'Parameters_ktup'        => { 'RESULT-parameters' => 'ktup' },\n        'Parameters_filter'      => { 'RESULT-parameters' => 'filter' },\n        'Statistics_db-num'      => { 'RESULT-statistics' => 'dbentries' },\n        'Statistics_db-len'      => { 'RESULT-statistics' => 'dbletters' },\n        'Statistics_hsp-len'     => { 'RESULT-statistics' => 'hsplength' },\n        'Statistics_eff-space'   => { 'RESULT-statistics' => 'effectivespace' },\n        'Statistics_kappa'       => { 'RESULT-statistics' => 'kappa' },\n        'Statistics_lambda'      => { 'RESULT-statistics' => 'lambda' },\n        'Statistics_entropy'     => { 'RESULT-statistics' => 'entropy' },\n    );\n}\n\nuse base qw(Bio::SearchIO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::fasta->new();\n Function: Builds a new Bio::SearchIO::fasta object \n Returns : Bio::SearchIO::fasta\n Args    : -idlength - set ID length to something other \n                       than the default (7), this is only\n                       necessary if you have compiled FASTA\n                       with a new default id length to display\n                       in the HSP alignment blocks\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n    return unless @args;\n    my ($idlength) = $self->_rearrange( [qw(IDLENGTH)], @args );\n    $self->idlength( $idlength || $IDLENGTH );\n    $self->_eventHandler->register_factory(\n        'hsp',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::HSP::FastaHSP',\n            -interface => 'Bio::Search::HSP::HSPI'\n        )\n    );\n    return 1;\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    local $/ = \"\\n\";\n    local $_;\n\n    my $data    = '';\n    my $seentop = 0;\n    my $current_hsp;\n    $self->start_document();\n    my @hit_signifs;\n    while ( defined( $_ = $self->_readline ) ) {\n        next if ( !$self->in_element('hsp')\n            && /^\\s+$/ );    # skip empty lines\n        if (\n               m/(\\S+)\\s+searches\\s+a\\s+(protein\\s+or\\s+DNA\\s+)?sequence/oxi\n            || /(\\S+)\\s+compares\\s+a/\n            || (   m/^\\#\\s+/\n                && ( $_ = $self->_readline )\n                && /(\\S+)\\s+searches\\s+a\\s+(protein\\s+or\\s+DNA\\s+)?sequence/oxi\n                || /(\\S+)\\s+compares\\s+a/ )\n          )\n        {\n            if ($seentop) {\n                $self->_pushback($_);\n                $self->end_element( { 'Name' => 'FastaOutput' } );\n                return $self->end_document();\n            }\n            $self->{'_reporttype'} = $1;\n            $self->start_element( { 'Name' => 'FastaOutput' } );\n            $self->{'_result_count'}++;\n            $seentop = 1;\n            #$self->debug( \"reporttype is \" . $self->{'_reporttype'} . \"\\n\" );\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_program',\n                    'Data' => $self->{'_reporttype'}\n                }\n            );\n            $_ = $self->_readline();\n            my ($version) = (/version\\s+(\\S+)/);\n            $version = '' unless defined $version;\n            $self->{'_version'} = $version;\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_version',\n                    'Data' => $version\n                }\n            );\n\n            my ( $last, $leadin, $type, $querylen, $querytype, $querydef );\n\n            while ( defined( $_ = $self->_readline() ) ) {\n                if (\n                    /^ (\n                       (?:\\s+>) |             # fa33 lead-in\n                       (?:\\s*\\d+\\s*>>>)       # fa34 mlib lead-in\n                      )\n                      (.*)\n                   /x\n                  )\n                {\n                    ( $leadin, $querydef ) = ( $1, $2 );\n                    if ( $leadin =~ m/>>>/ ) {\n                        if ( $querydef =~\n                            /^(.*?)\\s+(?:\\-\\s+)?(\\d+)\\s+(aa|nt).*$/o )\n                        {\n                            ( $querydef, $querylen, $querytype ) =\n                              ( $1, $2, $3 );\n                            last;\n                        }\n                    }\n                    else {\n                        if ( $last =~ /(\\S+)[:,]\\s*(\\d+)\\s+(aa|nt)/ ) {\n                            ( $querylen, $querytype ) = ( $2, $3 );\n                            $querydef ||= $1;\n                            last;\n                        }\n                    }\n                }\n                elsif (m/^\\s*vs\\s+\\S+/o) {\n                    if ( $last =~ /(\\S+)[,:]\\s+(\\d+)\\s+(aa|nt)/o ) {\n                        ( $querydef, $querylen, $querytype ) = ( $1, $2, $3 );\n                        last;\n                    }\n                }\n                $last = $_;\n            }\n            if (   $self->{'_reporttype'}\n                && $self->{'_reporttype'} eq 'FASTA' )\n            {\n                if ( $querytype eq 'nt' ) {\n                    $self->{'_reporttype'} = 'FASTN';\n                }\n                elsif ( $querytype eq 'aa' ) {\n                    $self->{'_reporttype'} = 'FASTP';\n                }\n            }\n            my ( $name, $descr ) = $querydef =~ m/^(\\S+)\\s*(.*?)\\s*$/o;\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_query-def',\n                    'Data' => $name\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_querydesc',\n                    'Data' => $descr\n                }\n            );\n            if ($querylen) {\n                $self->element(\n                    {\n                        'Name' => 'FastaOutput_query-len',\n                        'Data' => $querylen\n                    }\n                );\n            }\n            else {\n                $self->warn(\"unable to find and set query length\");\n            }\n            if (\n                   $last =~ /^\\s*vs\\s+(\\S+)/\n                || ( $last =~ /^searching\\s+(\\S+)\\s+library/ )\n                || ( $last =~ /^Library:\\s+(\\S+)\\s+/ )\n                || (\n                    defined $_\n                    && (   /^\\s*vs\\s+(\\S+)/\n                        || /^Library:\\s+(\\S+)\\s+/ )\n                )\n                || ( defined( $_ = $self->_readline() )\n                    && ( /^\\s*vs\\s+(\\S+)/ || /^Library:\\s+(\\S+)/ ) )\n              )\n            {\n                $self->element(\n                    {\n                        'Name' => 'FastaOutput_db',\n                        'Data' => $1\n                    }\n                );\n            }\n            elsif (m/^\\s+opt(?:\\s+E\\(\\))?$/o) {\n\n           # histogram ... read over it more rapidly than the larger outer loop:\n                while ( defined( $_ = $self->_readline ) ) {\n                    last if m/^>\\d+/;\n                }\n            }\n        }\n        elsif (/(\\d+)\\s+residues\\s+in\\s+(\\d+)\\s+(?:library\\s+)?sequences/) {\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_db-let',\n                    'Data' => $1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_db-len',\n                    'Data' => $2\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Statistics_db-len',\n                    'Data' => $1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Statistics_db-num',\n                    'Data' => $2\n                }\n            );\n        }\n        elsif (/Lambda=\\s*(\\S+)/) {\n            $self->element(\n                {\n                    'Name' => 'Statistics_lambda',\n                    'Data' => $1\n                }\n            );\n        }\n        elsif (/K=\\s*(\\S+)/) {\n            $self->element(\n                {\n                    'Name' => 'Statistics_kappa',\n                    'Data' => $1\n                }\n            );\n        }\n        elsif (/^\\s*(Smith-Waterman).+(\\S+)\\s*matrix [^\\]]*?(xS)?\\]/) {\n            $self->element(\n                {\n                    'Name' => 'Parameters_matrix',\n                    'Data' => $2\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_filter',\n                    'Data' => defined $3 ? 1 : 0,\n                }\n            );\n            $self->{'_reporttype'} = $1;\n\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_program',\n                    'Data' => $self->{'_reporttype'}\n                }\n            );\n        }\n        elsif (/The best( related| unrelated)? scores are:/) {\n            my $rel    = $1;\n            my @labels = split;\n            @labels = map {\n                if ( $_ =~ m/^E\\((\\d+)\\)$/o )\n                {\n                    $self->element(\n                        { 'Name' => 'Statistics_eff-space', 'Data' => $1 } );\n                    \"evalue\";\n                }\n                else {\n                    $_;\n                }\n            } @labels[ $rel ? 5 : 4 .. $#labels ];\n\n            while ( defined( $_ = $self->_readline() )\n                && !/^\\s+$/ )\n            {\n                my @line = split;\n\n                if ( $line[-1] =~ m/\\=/o && $labels[-1] eq 'fs' ) {\n\n                    # unlabelled alignment hit;\n                    push @labels, \"aln_code\";\n                }\n\n                my %data;\n                @data{@labels} = splice( @line, @line - @labels );\n                if ( $line[-1] =~ m/\\[([1-6rf])\\]/o ) {\n                    my $fr = $1;\n                    $data{lframe} = (\n                        $fr =~ /\\d/o\n                        ? ( $fr <= 3 ? \"+$fr\" : \"-@{[$fr-3]}\" )\n                        : ( $fr eq 'f' ? '+1' : '-1' )\n                    );\n                    pop @line;\n                }\n                else {\n                    $data{lframe} = '0';\n                }\n\n                if ( $line[-1] =~ m/^\\(?(\\d+)\\)$/ ) {\n                    $data{hit_len} = $1;\n                    pop @line;\n                    if ( $line[-1] =~ m/^\\($/ ) {\n                        pop @line;\n                    }\n                }\n                else {\n                    $data{hit_len} = 0;\n                }\n\n                # rebuild the first part of the line, preserving spaces:\n                ($_) = m/^(\\S+(?:\\s+\\S+){$#line})/;\n\n                my ( $id, $desc ) = split( /\\s+/, $_, 2 );\n                my @pieces = split( /\\|/, $id );\n                my $acc = pop @pieces;\n                $acc =~ s/\\.\\d+$//;\n\n                @data{qw(id desc acc)} = ( $id, $desc, $acc );\n\n                push @hit_signifs, \\%data;\n            }\n        }\n        elsif (\n/^\\s*([T]?FAST[XYAF]).+,\\s*(\\S+)\\s*matrix[^\\]]+?(xS)?\\]\\s*ktup:\\s*(\\d+)/\n          )\n        {\n\n            $self->element(\n                {\n                    'Name' => 'Parameters_matrix',\n                    'Data' => $2\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_filter',\n                    'Data' => defined $3 ? 1 : 0,\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_ktup',\n                    'Data' => $4\n                }\n            );\n            $self->{'_reporttype'} = $1\n              if ( $self->{'_reporttype'} !~ /FAST[PN]/i );\n\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_program',\n                    'Data' => $self->{'_reporttype'}\n                }\n            );\n        }\n        elsif (/^Algorithm:\\s+(\\S+)\\s+\\(([^)]+)\\)\\s+(\\S+)/) {\n            $self->{'_reporttype'} = $1\n              if ( $self->{'_reporttype'} !~ /FAST[PN]/i );\n        }\n        elsif (\n            /^Parameters:\\s+(\\S+)\\s*matrix\\s*(?:\\(([^(]+?)\\))?\\s*ktup:\\s*(\\d+)/)\n        {    # FASTA 35.04\n            $self->element(\n                {\n                    'Name' => 'Parameters_matrix',\n                    'Data' => $1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_filter',\n                    'Data' => defined $2 ? $2 : 0,\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_ktup',\n                    'Data' => $3\n                }\n            );\n        }\n        elsif (\n/(?:gap\\-pen|open\\/ext):\\s+([\\-\\+]?\\d+)\\s*\\/\\s*([\\-\\+]?\\d+).+width:\\s+(\\d+)/\n          )\n        {\n            $self->element(\n                {\n                    'Name' => 'Parameters_gap-open',\n                    'Data' => $1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_gap-ext',\n                    'Data' => $2\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_word-size',\n                    'Data' => $3\n                }\n            );\n        }\n        elsif (/^>>(?!>)(.+?)\\s+(?:\\((\\d+)\\s*(aa|nt)\\))?$/) {\n            my ($hit_id, $len, $alphabet) = ($1, $2, $3);\n            if (!$len || !$alphabet) {\n                WRAPPED:\n                while (defined($_ = $self->_readline)) {\n                    if (/(.*?)\\s+\\((\\d+)\\s*(aa|nt)\\)/) {\n                        ($len, $alphabet) = ($2, $3);\n                        $hit_id .= $1 ? \" \".$1 : '';\n                        last WRAPPED;\n                    }\n                    if (/^>>(?!>)/) { # too far, throw\n                        $self->throw(\"Couldn't find length, bailing\");\n                    }\n                }\n            }\n            if ( $self->in_element('hsp') ) {\n                $self->end_element( { 'Name' => 'Hsp' } );\n            }\n            if ( $self->in_element('hit') ) {\n                $self->end_element( { 'Name' => 'Hit' } );\n            }\n\n            $self->start_element( { 'Name' => 'Hit' } );\n            $self->element(\n                {\n                    'Name' => 'Hit_len',\n                    'Data' => $len\n                }\n            );\n            my ( $id, $desc ) = split( /\\s+/, $hit_id, 2 );\n            $self->element(\n                {\n                    'Name' => 'Hit_id',\n                    'Data' => $id\n                }\n            );\n\n            #$self->debug(\"Hit ID is $id\\n\");\n            my @pieces = split( /\\|/, $id );\n            my $acc = pop @pieces;\n            $acc =~ s/\\.\\d+$//;\n            $self->element(\n                {\n                    'Name' => 'Hit_accession',\n                    'Data' => $acc\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hit_def',\n                    'Data' => $desc\n                }\n            );\n\n            $_ = $self->_readline();\n            my ( $score, $bits, $e ) = /Z-score: \\s* (\\S+) \\s*\n                               (?: bits: \\s* (\\S+) \\s+ )?\n                               (?: E|expect ) \\s* \\(\\) :? \\s*(\\S+)/ox;\n            $bits = $score unless defined $bits;\n\n            my $v = shift @hit_signifs;\n            if ( defined $v ) {\n                @{$v}{qw(evalue bits z-sc)} = ( $e, $bits, $score );\n            }\n            $self->element(\n                {\n                    'Name' => 'Hit_signif',\n                    'Data' => $v ? $v->{evalue} : $e\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hit_score',\n                    'Data' => $v ? $v->{bits} : $bits\n                }\n            );\n            $self->start_element( { 'Name' => 'Hsp' } );\n\n            $self->element(\n                {\n                    'Name' => 'Hsp_score',\n                    'Data' => $v ? $v->{'z-sc'} : $score\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_evalue',\n                    'Data' => $v ? $v->{evalue} : $e\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_bit-score',\n                    'Data' => $v ? $v->{bits} : $bits\n                }\n            );\n            $_ = $self->_readline();\n\n            if (s/Smith-Waterman score:\\s*(\\d+)\\;?//) {\n                $self->element(\n                    {\n                        'Name' => 'Hsp_sw-score',\n                        'Data' => $1\n                    }\n                );\n            }\n            if (\n                / (\\d*\\.?\\d+)\\% \\s* identity\n                 (?:\\s* \\(\\s*(\\S+)\\% \\s* (?:ungapped|similar) \\) )?\n                 \\s* in \\s* (\\d+) \\s+ (?:aa|nt) \\s+ overlap \\s*\n                 \\( (\\d+) \\- (\\d+) : (\\d+) \\- (\\d+) \\)\n               /x\n              )\n            {\n                my ( $identper, $gapper, $len, $querystart, $queryend,\n                    $hitstart, $hitend )\n                  = ( $1, $2, $3, $4, $5, $6, $7 );\n                my $ident = sprintf( \"%.0f\", ( $identper / 100 ) * $len );\n                my $positive = sprintf( \"%.0f\", ( $gapper / 100 ) * $len );\n\n                $self->element(\n                    {\n                        'Name' => 'Hsp_identity',\n                        'Data' => $ident\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'Hsp_positive',\n                        'Data' => $positive\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'Hsp_align-len',\n                        'Data' => $len\n                    }\n                );\n\n                $self->element(\n                    {\n                        'Name' => 'Hsp_query-from',\n                        'Data' => $querystart\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'Hsp_query-to',\n                        'Data' => $queryend\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'Hsp_hit-from',\n                        'Data' => $hitstart\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'Hsp_hit-to',\n                        'Data' => $hitend\n                    }\n                );\n\n            }\n\n            if ($v) {\n                $self->element(\n                    { 'Name' => 'Hsp_querygaps', 'Data' => $v->{qgaps} } )\n                  if exists $v->{qgaps};\n                $self->element(\n                    { 'Name' => 'Hsp_hitgaps', 'Data' => $v->{lgaps} } )\n                  if exists $v->{lgaps};\n\n                if ( $self->{'_reporttype'} =~ m/^FAST[NXY]$/o ) {\n                    if ( 8 == scalar grep { exists $v->{$_} }\n                        qw(an0 ax0 pn0 px0 an1 ax1 pn1 px1) )\n                    {\n                        if ( $v->{ax0} < $v->{an0} ) {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_query-frame',\n                                    'Data' =>\n                                      \"-@{[(($v->{px0} - $v->{ax0}) % 3) + 1]}\"\n                                }\n                            );\n                        }\n                        else {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_query-frame',\n                                    'Data' =>\n                                      \"+@{[(($v->{an0} - $v->{pn0}) % 3) + 1]}\"\n                                }\n                            );\n                        }\n                        if ( $v->{ax1} < $v->{an1} ) {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_hit-frame',\n                                    'Data' =>\n                                      \"-@{[(($v->{px1} - $v->{ax1}) % 3) + 1]}\"\n                                }\n                            );\n                        }\n                        else {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_hit-frame',\n                                    'Data' =>\n                                      \"+@{[(($v->{an1} - $v->{pn1}) % 3) + 1]}\"\n                                }\n                            );\n                        }\n                    }\n                    else {\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_query-frame',\n                                'Data' => $v->{lframe}\n                            }\n                        );\n                        $self->element(\n                            { 'Name' => 'Hsp_hit-frame', 'Data' => 0 } );\n                    }\n                }\n                else {\n                    $self->element(\n                        { 'Name' => 'Hsp_query-frame', 'Data' => 0 } );\n                    $self->element(\n                        { 'Name' => 'Hsp_hit-frame', 'Data' => $v->{lframe} } );\n                }\n\n            }\n            else {\n                $self->warn(\"unable to parse FASTA score line: $_\");\n            }\n        }\n        elsif (/\\d+\\s*residues\\s*in\\s*\\d+\\s*query\\s*sequences/) {\n            if ( $self->in_element('hsp') ) {\n                $self->end_element( { 'Name' => 'Hsp' } );\n            }\n            if ( $self->in_element('hit') ) {\n                $self->end_element( { 'Name' => 'Hit' } );\n            }\n\n           #       $_ = $self->_readline();\n           #       my ( $liblen,$libsize) = /(\\d+)\\s+residues\\s*in(\\d+)\\s*library/;\n           # fast forward to the end of the file as there is\n           # nothing else left to do with this file and want to be sure and\n           # reset it\n            while ( defined( $_ = $self->_readline() ) ) {\n                last if (/^Function used was/);\n                if (\n                    /(\\S+)\\s+searches\\s+a\\s+(protein\\s+or\\s+DNA\\s+)?\n           sequence/oxi || /(\\S+)\\s+compares\\s+a/oi\n                  )\n                {\n                    $self->_pushback($_);\n                }\n            }\n\n            if (@hit_signifs) {\n\n                # process remaining best hits\n                for my $h (@hit_signifs) {\n\n                    # Hsp_score Hsp_evalue Hsp_bit-score\n                    # Hsp_sw-score Hsp_gaps Hsp_identity Hsp_positive\n                    # Hsp_align-len Hsp_query-from Hsp_query-to\n                    # Hsp_hit-from Hsp_hit-to Hsp_qseq Hsp_midline\n\n                    $self->start_element( { 'Name' => 'Hit' } );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_len',\n                            'Data' => $h->{hit_len}\n                        }\n                    ) if exists $h->{hit_len};\n                    $self->element(\n                        {\n                            'Name' => 'Hit_id',\n                            'Data' => $h->{id}\n                        }\n                    ) if exists $h->{id};\n                    $self->element(\n                        {\n                            'Name' => 'Hit_accession',\n                            'Data' => $h->{acc}\n                        }\n                    ) if exists $h->{acc};\n                    $self->element(\n                        {\n                            'Name' => 'Hit_def',\n                            'Data' => $h->{desc}\n                        }\n                    ) if exists $h->{desc};\n                    $self->element(\n                        {\n                            'Name' => 'Hit_signif',\n                            'Data' => $h->{evalue}\n                        }\n                    ) if exists $h->{evalue};\n                    $self->element(\n                        {\n                            'Name' => 'Hit_score',\n                            'Data' => $h->{bits}\n                        }\n                    ) if exists $h->{bits};\n\n                    $self->start_element( { 'Name' => 'Hsp' } );\n                    $self->element(\n                        { 'Name' => 'Hsp_score', 'Data' => $h->{'z-sc'} } )\n                      if exists $h->{'z-sc'};\n                    $self->element(\n                        { 'Name' => 'Hsp_evalue', 'Data' => $h->{evalue} } )\n                      if exists $h->{evalue};\n                    $self->element(\n                        { 'Name' => 'Hsp_bit-score', 'Data' => $h->{bits} } )\n                      if exists $h->{bits};\n                    $self->element(\n                        { 'Name' => 'Hsp_sw-score', 'Data' => $h->{sw} } )\n                      if exists $h->{sw};\n                    $self->element(\n                        { 'Name' => 'Hsp_gaps', 'Data' => $h->{'%_gid'} } )\n                      if exists $h->{'%_gid'};\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_identity',\n                            'Data' =>\n                              sprintf( \"%.0f\", $h->{'%_id'} * $h->{alen} )\n                        }\n                    ) if ( exists $h->{'%_id'} && exists $h->{alen} );\n\n                    if ( exists $h->{'%_gid'} ) {\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_positive',\n                                'Data' =>\n                                  sprintf( \"%.0f\", $h->{'%_gid'} * $h->{alen} )\n                            }\n                        ) if exists $h->{'%_gid'} && exists $h->{alen};\n                    }\n                    else {\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_positive',\n                                'Data' =>\n                                  sprintf( \"%.0f\", $h->{'%_id'} * $h->{alen} )\n                            }\n                        ) if ( exists $h->{'%_id'} && exists $h->{alen} );\n                    }\n                    $self->element(\n                        { 'Name' => 'Hsp_align-len', 'Data' => $h->{alen} } )\n                      if exists $h->{alen};\n                    $self->element(\n                        { 'Name' => 'Hsp_query-from', 'Data' => $h->{an0} } )\n                      if exists $h->{an0};\n                    $self->element(\n                        { 'Name' => 'Hsp_query-to', 'Data' => $h->{ax0} } )\n                      if exists $h->{ax0};\n                    $self->element(\n                        { 'Name' => 'Hsp_hit-from', 'Data' => $h->{an1} } )\n                      if exists $h->{an1};\n                    $self->element(\n                        { 'Name' => 'Hsp_hit-to', 'Data' => $h->{ax1} } )\n                      if exists $h->{ax1};\n\n                    $self->element(\n                        { 'Name' => 'Hsp_querygaps', 'Data' => $h->{qgaps} } )\n                      if exists $h->{qgaps};\n                    $self->element(\n                        { 'Name' => 'Hsp_hitgaps', 'Data' => $h->{lgaps} } )\n                      if exists $h->{lgaps};\n\n                    if ( $self->{'_reporttype'} =~ m/^FAST[NXY]$/o ) {\n                        if ( 8 == scalar grep { exists $h->{$_} }\n                            qw(an0 ax0 pn0 px0 an1 ax1 pn1 px1) )\n                        {\n                            if ( $h->{ax0} < $h->{an0} ) {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_query-frame',\n                                        'Data' =>\n\"-@{[(($h->{px0} - $h->{ax0}) % 3) + 1]}\"\n                                    }\n                                );\n                            }\n                            else {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_query-frame',\n                                        'Data' =>\n\"+@{[(($h->{an0} - $h->{pn0}) % 3) + 1]}\"\n                                    }\n                                );\n                            }\n                            if ( $h->{ax1} < $h->{an1} ) {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_hit-frame',\n                                        'Data' =>\n\"-@{[(($h->{px1} - $h->{ax1}) % 3) + 1]}\"\n                                    }\n                                );\n                            }\n                            else {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_hit-frame',\n                                        'Data' =>\n\"+@{[(($h->{an1} - $h->{pn1}) % 3) + 1]}\"\n                                    }\n                                );\n                            }\n                        }\n                        else {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_query-frame',\n                                    'Data' => $h->{lframe}\n                                }\n                            );\n                            $self->element(\n                                { 'Name' => 'Hsp_hit-frame', 'Data' => 0 } );\n                        }\n                    }\n                    else {\n                        $self->element(\n                            { 'Name' => 'Hsp_query-frame', 'Data' => 0 } );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_hit-frame',\n                                'Data' => $h->{lframe}\n                            }\n                        );\n                    }\n\n                    $self->end_element( { 'Name' => 'Hsp' } );\n                    $self->end_element( { 'Name' => 'Hit' } );\n                }\n            }\n            $self->end_element( { 'Name' => 'FastaOutput' } );\n            return $self->end_document();\n        }\n        elsif (/^\\s*\\d+\\s*>>>/) {\n            if ( $self->within_element('FastaOutput') ) {\n                if ( $self->in_element('hsp') ) {\n                    $self->end_element( { 'Name' => 'Hsp' } );\n                }\n                if ( $self->in_element('hit') ) {\n                    $self->end_element( { 'Name' => 'Hit' } );\n                }\n\n                if (@hit_signifs) {\n\n                    # process remaining best hits\n                    for my $h (@hit_signifs) {\n                        $self->start_element( { 'Name' => 'Hit' } );\n                        $self->element(\n                            {\n                                'Name' => 'Hit_len',\n                                'Data' => $h->{hit_len}\n                            }\n                        ) if exists $h->{hit_len};\n                        $self->element(\n                            {\n                                'Name' => 'Hit_id',\n                                'Data' => $h->{id}\n                            }\n                        ) if exists $h->{id};\n                        $self->element(\n                            {\n                                'Name' => 'Hit_accession',\n                                'Data' => $h->{acc}\n                            }\n                        ) if exists $h->{acc};\n                        $self->element(\n                            {\n                                'Name' => 'Hit_def',\n                                'Data' => $h->{desc}\n                            }\n                        ) if exists $h->{desc};\n                        $self->element(\n                            {\n                                'Name' => 'Hit_signif',\n                                'Data' => $h->{evalue}\n                            }\n                        ) if exists $h->{evalue};\n                        $self->element(\n                            {\n                                'Name' => 'Hit_score',\n                                'Data' => $h->{bits}\n                            }\n                        ) if exists $h->{bits};\n\n                        $self->start_element( { 'Name' => 'Hsp' } );\n                        $self->element(\n                            { 'Name' => 'Hsp_score', 'Data' => $h->{'z-sc'} } )\n                          if exists $h->{'z-sc'};\n                        $self->element(\n                            { 'Name' => 'Hsp_evalue', 'Data' => $h->{evalue} } )\n                          if exists $h->{evalue};\n                        $self->element(\n                            { 'Name' => 'Hsp_bit-score', 'Data' => $h->{bits} }\n                        ) if exists $h->{bits};\n                        $self->element(\n                            { 'Name' => 'Hsp_sw-score', 'Data' => $h->{sw} } )\n                          if exists $h->{sw};\n                        $self->element(\n                            { 'Name' => 'Hsp_gaps', 'Data' => $h->{'%_gid'} } )\n                          if exists $h->{'%_gid'};\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_identity',\n                                'Data' =>\n                                  sprintf( \"%.0f\", $h->{'%_id'} * $h->{alen} )\n                            }\n                        ) if ( exists $h->{'%_id'} && exists $h->{alen} );\n\n                        if ( exists $h->{'%_gid'} ) {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_positive',\n                                    'Data' => sprintf( \"%.0f\",\n                                        $h->{'%_gid'} * $h->{alen} )\n                                }\n                            ) if exists $h->{'%_gid'} && exists $h->{alen};\n                        }\n                        else {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_positive',\n                                    'Data' => sprintf( \"%.0f\",\n                                        $h->{'%_id'} * $h->{alen} )\n                                }\n                            ) if ( exists $h->{'%_id'} && exists $h->{alen} );\n                        }\n                        $self->element(\n                            { 'Name' => 'Hsp_align-len', 'Data' => $h->{alen} }\n                        ) if exists $h->{alen};\n                        $self->element(\n                            { 'Name' => 'Hsp_query-from', 'Data' => $h->{an0} }\n                        ) if exists $h->{an0};\n                        $self->element(\n                            { 'Name' => 'Hsp_query-to', 'Data' => $h->{ax0} } )\n                          if exists $h->{ax0};\n                        $self->element(\n                            { 'Name' => 'Hsp_hit-from', 'Data' => $h->{an1} } )\n                          if exists $h->{an1};\n                        $self->element(\n                            { 'Name' => 'Hsp_hit-to', 'Data' => $h->{ax1} } )\n                          if exists $h->{ax1};\n\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_querygaps',\n                                'Data' => $h->{qgaps}\n                            }\n                        ) if exists $h->{qgaps};\n                        $self->element(\n                            { 'Name' => 'Hsp_hitgaps', 'Data' => $h->{lgaps} } )\n                          if exists $h->{lgaps};\n\n                        if ( $self->{'_reporttype'} =~ m/^FAST[NXY]$/o ) {\n                            if ( 8 == scalar grep { exists $h->{$_} }\n                                qw(an0 ax0 pn0 px0 an1 ax1 pn1 px1) )\n                            {\n                                if ( $h->{ax0} < $h->{an0} ) {\n                                    $self->element(\n                                        {\n                                            'Name' => 'Hsp_query-frame',\n                                            'Data' => \"-@{[(($h->{px0} - $h->{ax0}) % 3) + 1]}\"\n                                        }\n                                    );\n                                }\n                                else {\n                                    $self->element(\n                                        {\n                                            'Name' => 'Hsp_query-frame',\n                                            'Data' => \"+@{[(($h->{an0} - $h->{pn0}) % 3) + 1]}\"\n                                        }\n                                    );\n                                }\n                                if ( $h->{ax1} < $h->{an1} ) {\n                                    $self->element(\n                                        {\n                                            'Name' => 'Hsp_hit-frame',\n                                            'Data' => \"-@{[(($h->{px1} - $h->{ax1}) % 3) + 1]}\"\n                                        }\n                                    );\n                                }\n                                else {\n                                    $self->element(\n                                        {\n                                            'Name' => 'Hsp_hit-frame',\n                                            'Data' => \"+@{[(($h->{an1} - $h->{pn1}) % 3) + 1]}\"\n                                        }\n                                    );\n                                }\n                            }\n                            else {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_query-frame',\n                                        'Data' => $h->{lframe}\n                                    }\n                                );\n                                $self->element(\n                                    { 'Name' => 'Hsp_hit-frame', 'Data' => 0 }\n                                );\n                            }\n                        }\n                        else {\n                            $self->element(\n                                { 'Name' => 'Hsp_query-frame', 'Data' => 0 } );\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_hit-frame',\n                                    'Data' => $h->{lframe}\n                                }\n                            );\n                        }\n\n                        $self->end_element( { 'Name' => 'Hsp' } );\n                        $self->end_element( { 'Name' => 'Hit' } );\n                    }\n                }\n                $self->end_element( { 'Name' => 'FastaOutput' } );\n                $self->_pushback($_);\n                return $self->end_document();\n            }\n            else {\n                $self->start_element( { 'Name' => 'FastaOutput' } );\n                $self->{'_result_count'}++;\n                $seentop = 1;\n                $self->element(\n                    {\n                        'Name' => 'FastaOutput_program',\n                        'Data' => $self->{'_reporttype'}\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'FastaOutput_version',\n                        'Data' => $self->{'_version'}\n                    }\n                );\n\n                my ( $type, $querylen, $querytype, $querydef );\n\n                if (/^\\s*\\d+\\s*>>>(.*)/) {\n                    $querydef = $1;\n                    if ( $querydef =~ /^(.*?)\\s+(?:\\-\\s+)?(\\d+)\\s+(aa|nt).*$/o )\n                    {\n                        ( $querydef, $querylen, $querytype ) = ( $1, $2, $3 );\n                    }\n                }\n\n                if (   $self->{'_reporttype'}\n                    && $self->{'_reporttype'} eq 'FASTA' )\n                {\n                    if ( $querytype eq 'nt' ) {\n                        $self->{'_reporttype'} = 'FASTN';\n                    }\n                    elsif ( $querytype eq 'aa' ) {\n                        $self->{'_reporttype'} = 'FASTP';\n                    }\n                }\n                my ( $name, $descr ) =\n                  ( $querydef =~ m/^(\\S+)(?:\\s+(.*))?\\s*$/o );\n                $self->element(\n                    {\n                        'Name' => 'FastaOutput_query-def',\n                        'Data' => $name\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'FastaOutput_querydesc',\n                        'Data' => $descr\n                    }\n                );\n                if ($querylen) {\n                    $self->element(\n                        {\n                            'Name' => 'FastaOutput_query-len',\n                            'Data' => $querylen\n                        }\n                    );\n                }\n                else {\n                    $self->warn(\"unable to find and set query length\");\n                }\n                if ( defined( $_ = $self->_readline() )\n                    && ( /^\\s*vs\\s+(\\S+)/ || /^Library:\\s+(\\S+)/ ) )\n                {\n                    $self->element(\n                        {\n                            'Name' => 'FastaOutput_db',\n                            'Data' => $1\n                        }\n                    );\n                }\n\n            }\n        }\n        elsif ( $self->in_element('hsp') ) {\n            my @data  = ( [], [], [] );\n            my $count = 0;\n            my $len   = $self->idlength + 1;\n            my ($seq1_id);\n            while ( defined($_) ) {\n                chomp;\n                #$self->debug(\"$count $_\\n\");\n                if (/residues in \\d+\\s+query\\s+sequences/o) {\n                    $self->_pushback($_);\n                    last;\n                }\n                elsif (/^>>>\\*\\*\\*/o) {\n                    $self->end_element( { Name => \"Hsp\" } );\n                    last;\n                }\n                elsif (/^>>/o) {\n                    $self->_pushback($_);\n                    last;\n                }\n                elsif (/^\\s*\\d+\\s*>>>/o) {\n                    $self->_pushback($_);\n                    last;\n                }\n                if ( $count == 0 ) {\n                    if (/^(\\S+)\\s+/) {\n                        $self->_pushback($_);\n                        $count = 2;\n                    }\n                    elsif ( /^\\s+\\d+/ || /^\\s+$/ ) {\n\n                        # do nothing, this is really a 0 line\n                    }\n                    elsif ( length($_) == 0 ) {\n                        $count = -1;\n                    }\n                    else {\n                        $self->_pushback($_);\n                        $count = 0;\n                    }\n                }\n                elsif ( $count == 1 || $count == 3 ) {\n                    if (/^(\\S+)\\s+/) {\n                        $len = CORE::length($1) if $len < CORE::length($1);\n                        s/\\s+$//;    # trim trailing spaces,we don't want them\n                        push @{ $data[ $count - 1 ] }, substr( $_, $len );\n                    }\n                    elsif (/^\\s+(\\d+)/) {\n                        $count = -1;\n                        $self->_pushback($_);\n                    }\n                    elsif ( /^\\s+$/ || length($_) == 0 ) {\n                        $count = 5;\n\n                        # going to skip these\n                    }\n                    else {\n                        $self->throw(\n                            \"Unrecognized alignment line ($count) '$_'\");\n                    }\n                }\n                elsif ( $count == 2 ) {\n                    if (/^\\s+\\d+\\s+/) {\n                        $self->warn(\"$_\\n\") if $self->verbose > 0;\n\n                        # we are on a Subject part of the alignment\n                        # but we THOUGHT we were on the Query\n                        # move that last line to the proper place\n                        push @{ $data[2] }, pop @{ $data[0] };\n                        $count = 4;\n                    }\n                    else {\n\n                        # toss the first IDLENGTH characters of the line\n                        if ( length($_) >= $len ) {\n                            push @{ $data[ $count - 1 ] }, substr( $_, $len );\n                        }\n                    }\n                }\n                last if ( $count++ >= 5 );\n                $_ = $self->_readline();\n            }\n            if ( @{ $data[0] } || @{ $data[2] } ) {\n                $self->characters(\n                    {\n                        'Name' => 'Hsp_qseq',\n                        'Data' => join( '', @{ $data[0] } )\n                    }\n                );\n                $self->characters(\n                    {\n                        'Name' => 'Hsp_midline',\n                        'Data' => join( '', @{ $data[1] } )\n                    }\n                );\n                $self->characters(\n                    {\n                        'Name' => 'Hsp_hseq',\n                        'Data' => join( '', @{ $data[2] } )\n                    }\n                );\n            }\n        }\n        else {\n            if ( !$seentop ) {\n                $self->debug($_);\n                #$self->warn(\"unrecognized FASTA Family report file!\");\n                #return;\n            }\n        }\n    }\n    if ( $self->in_element('result') ) {\n        if ( $self->in_element('hsp') ) {\n            $self->end_element( { 'Name' => 'Hsp' } );\n        }\n        if ( $self->in_element('hit') ) {\n            $self->end_element( { 'Name' => 'Hit' } );\n        }\n        $self->end_element( { 'Name' => 'FastaOutput' } );\n    }\n    return $self->end_document();\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element {\n    my ( $self, $data ) = @_;\n\n    # we currently don't care about attributes\n    my $nm = $data->{'Name'};\n    if ( my $type = $MODEMAP{$nm} ) {\n        $self->_mode($type);\n        if ( my $handler = $self->_will_handle($type) ) {\n            my $func = sprintf( \"start_%s\", lc $type );\n            $handler->$func( $data->{'Attributes'} );\n        }\n        unshift @{ $self->{'_elements'} }, $type;\n    }\n    if ( $nm eq 'FastaOutput' ) {\n        $self->{'_values'} = {};\n        $self->{'_result'} = undef;\n        $self->{'_mode'}   = '';\n    }\n\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ( $self, $data ) = @_;\n    my $nm = $data->{'Name'};\n    my $rc;\n\n    # Hsp are sort of weird, in that they end when another\n    # object begins so have to detect this in end_element for now\n    if ( $nm eq 'Hsp' ) {\n        foreach (qw(Hsp_qseq Hsp_midline Hsp_hseq)) {\n            $self->element(\n                {\n                    'Name' => $_,\n                    'Data' => $self->{'_last_hspdata'}->{$_}\n                }\n            );\n        }\n        $self->{'_last_hspdata'} = {};\n    }\n\n    if ( my $type = $MODEMAP{$nm} ) {\n        if ( my $handler = $self->_will_handle($type) ) {\n            my $func = sprintf( \"end_%s\", lc $type );\n            $rc = $handler->$func( $self->{'_reporttype'}, $self->{'_values'} );\n        }\n        shift @{ $self->{'_elements'} };\n\n    }\n    elsif ( $MAPPING{$nm} ) {\n        if ( ref( $MAPPING{$nm} ) =~ /hash/i ) {\n            my $key = ( keys %{ $MAPPING{$nm} } )[0];\n            $self->{'_values'}->{$key}->{ $MAPPING{$nm}->{$key} } =\n              $self->{'_last_data'};\n        }\n        else {\n            $self->{'_values'}->{ $MAPPING{$nm} } = $self->{'_last_data'};\n        }\n    }\n    else {\n        $self->warn(\"unknown nm $nm, ignoring\\n\");\n    }\n    $self->{'_last_data'} = '';    # remove read data if we are at\n                                   # end of an element\n    $self->{'_result'} = $rc if ( $nm eq 'FastaOutput' );\n    return $rc;\n\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'","parameters":[{"label":"$self"},{"label":"$data"}]},"detail":"($self,$data)","definition":"sub","containerName":"main::","children":[{"line":1500,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"element"},{"line":1500,"kind":13,"name":"$data","containerName":"element"},{"line":1501,"kind":13,"containerName":"element","name":"$self"},{"line":1501,"kind":12,"name":"start_element","containerName":"element"},{"line":1501,"kind":13,"containerName":"element","name":"$data"},{"line":1502,"kind":13,"containerName":"element","name":"$self"},{"name":"characters","containerName":"element","kind":12,"line":1502},{"containerName":"element","name":"$data","line":1502,"kind":13},{"containerName":"element","name":"$self","line":1503,"kind":13},{"line":1503,"kind":12,"containerName":"element","name":"end_element"},{"kind":13,"line":1503,"name":"$data","containerName":"element"}],"line":1499,"kind":12,"range":{"end":{"character":9999,"line":1504},"start":{"line":1499,"character":0}},"name":"element"},{"kind":12,"line":1517,"children":[{"line":1518,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"characters"},{"containerName":"characters","name":"$data","kind":13,"line":1518},{"kind":13,"line":1520,"containerName":"characters","name":"$data"},{"kind":13,"line":1521,"containerName":"characters","name":"$data"},{"kind":13,"line":1522,"name":"$data","containerName":"characters"},{"kind":13,"line":1525,"name":"$self","containerName":"characters"},{"containerName":"characters","name":"in_element","line":1525,"kind":12},{"line":1526,"kind":13,"name":"$data","containerName":"characters"},{"name":"$self","containerName":"characters","kind":13,"line":1529},{"kind":13,"line":1529,"name":"$data","containerName":"characters"},{"line":1529,"kind":13,"containerName":"characters","name":"$data"},{"containerName":"characters","name":"$self","line":1532,"kind":13},{"line":1532,"kind":13,"name":"$data","containerName":"characters"}],"containerName":"main::","definition":"sub","detail":"($self,$data)","signature":{"parameters":[{"label":"$self"},{"label":"$data"}],"documentation":"1;\n# $Id: fasta.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::fasta\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::fasta - A SearchIO parser for FASTA results\n\n=head1 SYNOPSIS\n\n  # Do not use this object directly, use it through the SearchIO system\n   use Bio::SearchIO;\n   my $searchio = Bio::SearchIO->new(-format => 'fasta',\n                    -file   => 'report.FASTA');\n   while( my $result = $searchio->next_result ) {\n    # ... do what you would normally doi with Bio::SearchIO.\n   }\n\n=head1 DESCRIPTION\n\nThis object contains the event based parsing code for FASTA format\nreports.  It creates L<Bio::Search::HSP::FastaHSP> objects instead of\nL<Bio::Search::HSP::GenericHSP> for the HSP objects. \n\nThis module will parse -m 9 -d 0 output as well as default m 1 output\nfrom FASTA as well as SSEARCH.\n\nAlso see the SearchIO HOWTO:\nL<http://bioperl.open-bio.org/wiki/HOWTO:SearchIO>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich, Aaron Mackey\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::fasta;\nuse vars qw(%MODEMAP %MAPPING $IDLENGTH);\nuse strict;\n\n# Object preamble - inherits from Bio::Root::RootI\n\nuse Bio::Factory::ObjectFactory;\n\nBEGIN {\n\n    # Set IDLENGTH to a new value if you have\n    # compile FASTA with a different ID length\n    # (actually newest FASTA allows the setting of this\n    #  via -C parameter, default is 6)\n    $IDLENGTH = 6;\n\n    # mapping of NCBI Blast terms to Bioperl hash keys\n    %MODEMAP = (\n        'FastaOutput' => 'result',\n        'Hit'         => 'hit',\n        'Hsp'         => 'hsp'\n    );\n\n    # This should really be done more intelligently, like with\n    # XSLT\n\n    %MAPPING = (\n        'Hsp_bit-score'   => 'HSP-bits',\n        'Hsp_score'       => 'HSP-score',\n        'Hsp_sw-score'    => 'HSP-swscore',\n        'Hsp_evalue'      => 'HSP-evalue',\n        'Hsp_query-from'  => 'HSP-query_start',\n        'Hsp_query-to'    => 'HSP-query_end',\n        'Hsp_hit-from'    => 'HSP-hit_start',\n        'Hsp_hit-to'      => 'HSP-hit_end',\n        'Hsp_positive'    => 'HSP-conserved',\n        'Hsp_identity'    => 'HSP-identical',\n        'Hsp_gaps'        => 'HSP-hsp_gaps',\n        'Hsp_hitgaps'     => 'HSP-hit_gaps',\n        'Hsp_querygaps'   => 'HSP-query_gaps',\n        'Hsp_qseq'        => 'HSP-query_seq',\n        'Hsp_hseq'        => 'HSP-hit_seq',\n        'Hsp_midline'     => 'HSP-homology_seq',\n        'Hsp_align-len'   => 'HSP-hsp_length',\n        'Hsp_query-frame' => 'HSP-query_frame',\n        'Hsp_hit-frame'   => 'HSP-hit_frame',\n\n        'Hit_id'        => 'HIT-name',\n        'Hit_len'       => 'HIT-length',\n        'Hit_accession' => 'HIT-accession',\n        'Hit_def'       => 'HIT-description',\n        'Hit_signif'    => 'HIT-significance',\n        'Hit_score'     => 'HIT-score',\n\n        'FastaOutput_program'   => 'RESULT-algorithm_name',\n        'FastaOutput_version'   => 'RESULT-algorithm_version',\n        'FastaOutput_query-def' => 'RESULT-query_name',\n        'FastaOutput_querydesc' => 'RESULT-query_description',\n        'FastaOutput_query-len' => 'RESULT-query_length',\n        'FastaOutput_db'        => 'RESULT-database_name',\n        'FastaOutput_db-len'    => 'RESULT-database_entries',\n        'FastaOutput_db-let'    => 'RESULT-database_letters',\n\n        'Parameters_matrix'      => { 'RESULT-parameters' => 'matrix' },\n        'Parameters_expect'      => { 'RESULT-parameters' => 'expect' },\n        'Parameters_include'     => { 'RESULT-parameters' => 'include' },\n        'Parameters_sc-match'    => { 'RESULT-parameters' => 'match' },\n        'Parameters_sc-mismatch' => { 'RESULT-parameters' => 'mismatch' },\n        'Parameters_gap-open'    => { 'RESULT-parameters' => 'gapopen' },\n        'Parameters_gap-ext'     => { 'RESULT-parameters' => 'gapext' },\n        'Parameters_word-size'   => { 'RESULT-parameters' => 'wordsize' },\n        'Parameters_ktup'        => { 'RESULT-parameters' => 'ktup' },\n        'Parameters_filter'      => { 'RESULT-parameters' => 'filter' },\n        'Statistics_db-num'      => { 'RESULT-statistics' => 'dbentries' },\n        'Statistics_db-len'      => { 'RESULT-statistics' => 'dbletters' },\n        'Statistics_hsp-len'     => { 'RESULT-statistics' => 'hsplength' },\n        'Statistics_eff-space'   => { 'RESULT-statistics' => 'effectivespace' },\n        'Statistics_kappa'       => { 'RESULT-statistics' => 'kappa' },\n        'Statistics_lambda'      => { 'RESULT-statistics' => 'lambda' },\n        'Statistics_entropy'     => { 'RESULT-statistics' => 'entropy' },\n    );\n}\n\nuse base qw(Bio::SearchIO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::fasta->new();\n Function: Builds a new Bio::SearchIO::fasta object \n Returns : Bio::SearchIO::fasta\n Args    : -idlength - set ID length to something other \n                       than the default (7), this is only\n                       necessary if you have compiled FASTA\n                       with a new default id length to display\n                       in the HSP alignment blocks\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n    return unless @args;\n    my ($idlength) = $self->_rearrange( [qw(IDLENGTH)], @args );\n    $self->idlength( $idlength || $IDLENGTH );\n    $self->_eventHandler->register_factory(\n        'hsp',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::HSP::FastaHSP',\n            -interface => 'Bio::Search::HSP::HSPI'\n        )\n    );\n    return 1;\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    local $/ = \"\\n\";\n    local $_;\n\n    my $data    = '';\n    my $seentop = 0;\n    my $current_hsp;\n    $self->start_document();\n    my @hit_signifs;\n    while ( defined( $_ = $self->_readline ) ) {\n        next if ( !$self->in_element('hsp')\n            && /^\\s+$/ );    # skip empty lines\n        if (\n               m/(\\S+)\\s+searches\\s+a\\s+(protein\\s+or\\s+DNA\\s+)?sequence/oxi\n            || /(\\S+)\\s+compares\\s+a/\n            || (   m/^\\#\\s+/\n                && ( $_ = $self->_readline )\n                && /(\\S+)\\s+searches\\s+a\\s+(protein\\s+or\\s+DNA\\s+)?sequence/oxi\n                || /(\\S+)\\s+compares\\s+a/ )\n          )\n        {\n            if ($seentop) {\n                $self->_pushback($_);\n                $self->end_element( { 'Name' => 'FastaOutput' } );\n                return $self->end_document();\n            }\n            $self->{'_reporttype'} = $1;\n            $self->start_element( { 'Name' => 'FastaOutput' } );\n            $self->{'_result_count'}++;\n            $seentop = 1;\n            #$self->debug( \"reporttype is \" . $self->{'_reporttype'} . \"\\n\" );\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_program',\n                    'Data' => $self->{'_reporttype'}\n                }\n            );\n            $_ = $self->_readline();\n            my ($version) = (/version\\s+(\\S+)/);\n            $version = '' unless defined $version;\n            $self->{'_version'} = $version;\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_version',\n                    'Data' => $version\n                }\n            );\n\n            my ( $last, $leadin, $type, $querylen, $querytype, $querydef );\n\n            while ( defined( $_ = $self->_readline() ) ) {\n                if (\n                    /^ (\n                       (?:\\s+>) |             # fa33 lead-in\n                       (?:\\s*\\d+\\s*>>>)       # fa34 mlib lead-in\n                      )\n                      (.*)\n                   /x\n                  )\n                {\n                    ( $leadin, $querydef ) = ( $1, $2 );\n                    if ( $leadin =~ m/>>>/ ) {\n                        if ( $querydef =~\n                            /^(.*?)\\s+(?:\\-\\s+)?(\\d+)\\s+(aa|nt).*$/o )\n                        {\n                            ( $querydef, $querylen, $querytype ) =\n                              ( $1, $2, $3 );\n                            last;\n                        }\n                    }\n                    else {\n                        if ( $last =~ /(\\S+)[:,]\\s*(\\d+)\\s+(aa|nt)/ ) {\n                            ( $querylen, $querytype ) = ( $2, $3 );\n                            $querydef ||= $1;\n                            last;\n                        }\n                    }\n                }\n                elsif (m/^\\s*vs\\s+\\S+/o) {\n                    if ( $last =~ /(\\S+)[,:]\\s+(\\d+)\\s+(aa|nt)/o ) {\n                        ( $querydef, $querylen, $querytype ) = ( $1, $2, $3 );\n                        last;\n                    }\n                }\n                $last = $_;\n            }\n            if (   $self->{'_reporttype'}\n                && $self->{'_reporttype'} eq 'FASTA' )\n            {\n                if ( $querytype eq 'nt' ) {\n                    $self->{'_reporttype'} = 'FASTN';\n                }\n                elsif ( $querytype eq 'aa' ) {\n                    $self->{'_reporttype'} = 'FASTP';\n                }\n            }\n            my ( $name, $descr ) = $querydef =~ m/^(\\S+)\\s*(.*?)\\s*$/o;\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_query-def',\n                    'Data' => $name\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_querydesc',\n                    'Data' => $descr\n                }\n            );\n            if ($querylen) {\n                $self->element(\n                    {\n                        'Name' => 'FastaOutput_query-len',\n                        'Data' => $querylen\n                    }\n                );\n            }\n            else {\n                $self->warn(\"unable to find and set query length\");\n            }\n            if (\n                   $last =~ /^\\s*vs\\s+(\\S+)/\n                || ( $last =~ /^searching\\s+(\\S+)\\s+library/ )\n                || ( $last =~ /^Library:\\s+(\\S+)\\s+/ )\n                || (\n                    defined $_\n                    && (   /^\\s*vs\\s+(\\S+)/\n                        || /^Library:\\s+(\\S+)\\s+/ )\n                )\n                || ( defined( $_ = $self->_readline() )\n                    && ( /^\\s*vs\\s+(\\S+)/ || /^Library:\\s+(\\S+)/ ) )\n              )\n            {\n                $self->element(\n                    {\n                        'Name' => 'FastaOutput_db',\n                        'Data' => $1\n                    }\n                );\n            }\n            elsif (m/^\\s+opt(?:\\s+E\\(\\))?$/o) {\n\n           # histogram ... read over it more rapidly than the larger outer loop:\n                while ( defined( $_ = $self->_readline ) ) {\n                    last if m/^>\\d+/;\n                }\n            }\n        }\n        elsif (/(\\d+)\\s+residues\\s+in\\s+(\\d+)\\s+(?:library\\s+)?sequences/) {\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_db-let',\n                    'Data' => $1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_db-len',\n                    'Data' => $2\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Statistics_db-len',\n                    'Data' => $1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Statistics_db-num',\n                    'Data' => $2\n                }\n            );\n        }\n        elsif (/Lambda=\\s*(\\S+)/) {\n            $self->element(\n                {\n                    'Name' => 'Statistics_lambda',\n                    'Data' => $1\n                }\n            );\n        }\n        elsif (/K=\\s*(\\S+)/) {\n            $self->element(\n                {\n                    'Name' => 'Statistics_kappa',\n                    'Data' => $1\n                }\n            );\n        }\n        elsif (/^\\s*(Smith-Waterman).+(\\S+)\\s*matrix [^\\]]*?(xS)?\\]/) {\n            $self->element(\n                {\n                    'Name' => 'Parameters_matrix',\n                    'Data' => $2\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_filter',\n                    'Data' => defined $3 ? 1 : 0,\n                }\n            );\n            $self->{'_reporttype'} = $1;\n\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_program',\n                    'Data' => $self->{'_reporttype'}\n                }\n            );\n        }\n        elsif (/The best( related| unrelated)? scores are:/) {\n            my $rel    = $1;\n            my @labels = split;\n            @labels = map {\n                if ( $_ =~ m/^E\\((\\d+)\\)$/o )\n                {\n                    $self->element(\n                        { 'Name' => 'Statistics_eff-space', 'Data' => $1 } );\n                    \"evalue\";\n                }\n                else {\n                    $_;\n                }\n            } @labels[ $rel ? 5 : 4 .. $#labels ];\n\n            while ( defined( $_ = $self->_readline() )\n                && !/^\\s+$/ )\n            {\n                my @line = split;\n\n                if ( $line[-1] =~ m/\\=/o && $labels[-1] eq 'fs' ) {\n\n                    # unlabelled alignment hit;\n                    push @labels, \"aln_code\";\n                }\n\n                my %data;\n                @data{@labels} = splice( @line, @line - @labels );\n                if ( $line[-1] =~ m/\\[([1-6rf])\\]/o ) {\n                    my $fr = $1;\n                    $data{lframe} = (\n                        $fr =~ /\\d/o\n                        ? ( $fr <= 3 ? \"+$fr\" : \"-@{[$fr-3]}\" )\n                        : ( $fr eq 'f' ? '+1' : '-1' )\n                    );\n                    pop @line;\n                }\n                else {\n                    $data{lframe} = '0';\n                }\n\n                if ( $line[-1] =~ m/^\\(?(\\d+)\\)$/ ) {\n                    $data{hit_len} = $1;\n                    pop @line;\n                    if ( $line[-1] =~ m/^\\($/ ) {\n                        pop @line;\n                    }\n                }\n                else {\n                    $data{hit_len} = 0;\n                }\n\n                # rebuild the first part of the line, preserving spaces:\n                ($_) = m/^(\\S+(?:\\s+\\S+){$#line})/;\n\n                my ( $id, $desc ) = split( /\\s+/, $_, 2 );\n                my @pieces = split( /\\|/, $id );\n                my $acc = pop @pieces;\n                $acc =~ s/\\.\\d+$//;\n\n                @data{qw(id desc acc)} = ( $id, $desc, $acc );\n\n                push @hit_signifs, \\%data;\n            }\n        }\n        elsif (\n/^\\s*([T]?FAST[XYAF]).+,\\s*(\\S+)\\s*matrix[^\\]]+?(xS)?\\]\\s*ktup:\\s*(\\d+)/\n          )\n        {\n\n            $self->element(\n                {\n                    'Name' => 'Parameters_matrix',\n                    'Data' => $2\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_filter',\n                    'Data' => defined $3 ? 1 : 0,\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_ktup',\n                    'Data' => $4\n                }\n            );\n            $self->{'_reporttype'} = $1\n              if ( $self->{'_reporttype'} !~ /FAST[PN]/i );\n\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_program',\n                    'Data' => $self->{'_reporttype'}\n                }\n            );\n        }\n        elsif (/^Algorithm:\\s+(\\S+)\\s+\\(([^)]+)\\)\\s+(\\S+)/) {\n            $self->{'_reporttype'} = $1\n              if ( $self->{'_reporttype'} !~ /FAST[PN]/i );\n        }\n        elsif (\n            /^Parameters:\\s+(\\S+)\\s*matrix\\s*(?:\\(([^(]+?)\\))?\\s*ktup:\\s*(\\d+)/)\n        {    # FASTA 35.04\n            $self->element(\n                {\n                    'Name' => 'Parameters_matrix',\n                    'Data' => $1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_filter',\n                    'Data' => defined $2 ? $2 : 0,\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_ktup',\n                    'Data' => $3\n                }\n            );\n        }\n        elsif (\n/(?:gap\\-pen|open\\/ext):\\s+([\\-\\+]?\\d+)\\s*\\/\\s*([\\-\\+]?\\d+).+width:\\s+(\\d+)/\n          )\n        {\n            $self->element(\n                {\n                    'Name' => 'Parameters_gap-open',\n                    'Data' => $1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_gap-ext',\n                    'Data' => $2\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_word-size',\n                    'Data' => $3\n                }\n            );\n        }\n        elsif (/^>>(?!>)(.+?)\\s+(?:\\((\\d+)\\s*(aa|nt)\\))?$/) {\n            my ($hit_id, $len, $alphabet) = ($1, $2, $3);\n            if (!$len || !$alphabet) {\n                WRAPPED:\n                while (defined($_ = $self->_readline)) {\n                    if (/(.*?)\\s+\\((\\d+)\\s*(aa|nt)\\)/) {\n                        ($len, $alphabet) = ($2, $3);\n                        $hit_id .= $1 ? \" \".$1 : '';\n                        last WRAPPED;\n                    }\n                    if (/^>>(?!>)/) { # too far, throw\n                        $self->throw(\"Couldn't find length, bailing\");\n                    }\n                }\n            }\n            if ( $self->in_element('hsp') ) {\n                $self->end_element( { 'Name' => 'Hsp' } );\n            }\n            if ( $self->in_element('hit') ) {\n                $self->end_element( { 'Name' => 'Hit' } );\n            }\n\n            $self->start_element( { 'Name' => 'Hit' } );\n            $self->element(\n                {\n                    'Name' => 'Hit_len',\n                    'Data' => $len\n                }\n            );\n            my ( $id, $desc ) = split( /\\s+/, $hit_id, 2 );\n            $self->element(\n                {\n                    'Name' => 'Hit_id',\n                    'Data' => $id\n                }\n            );\n\n            #$self->debug(\"Hit ID is $id\\n\");\n            my @pieces = split( /\\|/, $id );\n            my $acc = pop @pieces;\n            $acc =~ s/\\.\\d+$//;\n            $self->element(\n                {\n                    'Name' => 'Hit_accession',\n                    'Data' => $acc\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hit_def',\n                    'Data' => $desc\n                }\n            );\n\n            $_ = $self->_readline();\n            my ( $score, $bits, $e ) = /Z-score: \\s* (\\S+) \\s*\n                               (?: bits: \\s* (\\S+) \\s+ )?\n                               (?: E|expect ) \\s* \\(\\) :? \\s*(\\S+)/ox;\n            $bits = $score unless defined $bits;\n\n            my $v = shift @hit_signifs;\n            if ( defined $v ) {\n                @{$v}{qw(evalue bits z-sc)} = ( $e, $bits, $score );\n            }\n            $self->element(\n                {\n                    'Name' => 'Hit_signif',\n                    'Data' => $v ? $v->{evalue} : $e\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hit_score',\n                    'Data' => $v ? $v->{bits} : $bits\n                }\n            );\n            $self->start_element( { 'Name' => 'Hsp' } );\n\n            $self->element(\n                {\n                    'Name' => 'Hsp_score',\n                    'Data' => $v ? $v->{'z-sc'} : $score\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_evalue',\n                    'Data' => $v ? $v->{evalue} : $e\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_bit-score',\n                    'Data' => $v ? $v->{bits} : $bits\n                }\n            );\n            $_ = $self->_readline();\n\n            if (s/Smith-Waterman score:\\s*(\\d+)\\;?//) {\n                $self->element(\n                    {\n                        'Name' => 'Hsp_sw-score',\n                        'Data' => $1\n                    }\n                );\n            }\n            if (\n                / (\\d*\\.?\\d+)\\% \\s* identity\n                 (?:\\s* \\(\\s*(\\S+)\\% \\s* (?:ungapped|similar) \\) )?\n                 \\s* in \\s* (\\d+) \\s+ (?:aa|nt) \\s+ overlap \\s*\n                 \\( (\\d+) \\- (\\d+) : (\\d+) \\- (\\d+) \\)\n               /x\n              )\n            {\n                my ( $identper, $gapper, $len, $querystart, $queryend,\n                    $hitstart, $hitend )\n                  = ( $1, $2, $3, $4, $5, $6, $7 );\n                my $ident = sprintf( \"%.0f\", ( $identper / 100 ) * $len );\n                my $positive = sprintf( \"%.0f\", ( $gapper / 100 ) * $len );\n\n                $self->element(\n                    {\n                        'Name' => 'Hsp_identity',\n                        'Data' => $ident\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'Hsp_positive',\n                        'Data' => $positive\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'Hsp_align-len',\n                        'Data' => $len\n                    }\n                );\n\n                $self->element(\n                    {\n                        'Name' => 'Hsp_query-from',\n                        'Data' => $querystart\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'Hsp_query-to',\n                        'Data' => $queryend\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'Hsp_hit-from',\n                        'Data' => $hitstart\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'Hsp_hit-to',\n                        'Data' => $hitend\n                    }\n                );\n\n            }\n\n            if ($v) {\n                $self->element(\n                    { 'Name' => 'Hsp_querygaps', 'Data' => $v->{qgaps} } )\n                  if exists $v->{qgaps};\n                $self->element(\n                    { 'Name' => 'Hsp_hitgaps', 'Data' => $v->{lgaps} } )\n                  if exists $v->{lgaps};\n\n                if ( $self->{'_reporttype'} =~ m/^FAST[NXY]$/o ) {\n                    if ( 8 == scalar grep { exists $v->{$_} }\n                        qw(an0 ax0 pn0 px0 an1 ax1 pn1 px1) )\n                    {\n                        if ( $v->{ax0} < $v->{an0} ) {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_query-frame',\n                                    'Data' =>\n                                      \"-@{[(($v->{px0} - $v->{ax0}) % 3) + 1]}\"\n                                }\n                            );\n                        }\n                        else {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_query-frame',\n                                    'Data' =>\n                                      \"+@{[(($v->{an0} - $v->{pn0}) % 3) + 1]}\"\n                                }\n                            );\n                        }\n                        if ( $v->{ax1} < $v->{an1} ) {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_hit-frame',\n                                    'Data' =>\n                                      \"-@{[(($v->{px1} - $v->{ax1}) % 3) + 1]}\"\n                                }\n                            );\n                        }\n                        else {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_hit-frame',\n                                    'Data' =>\n                                      \"+@{[(($v->{an1} - $v->{pn1}) % 3) + 1]}\"\n                                }\n                            );\n                        }\n                    }\n                    else {\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_query-frame',\n                                'Data' => $v->{lframe}\n                            }\n                        );\n                        $self->element(\n                            { 'Name' => 'Hsp_hit-frame', 'Data' => 0 } );\n                    }\n                }\n                else {\n                    $self->element(\n                        { 'Name' => 'Hsp_query-frame', 'Data' => 0 } );\n                    $self->element(\n                        { 'Name' => 'Hsp_hit-frame', 'Data' => $v->{lframe} } );\n                }\n\n            }\n            else {\n                $self->warn(\"unable to parse FASTA score line: $_\");\n            }\n        }\n        elsif (/\\d+\\s*residues\\s*in\\s*\\d+\\s*query\\s*sequences/) {\n            if ( $self->in_element('hsp') ) {\n                $self->end_element( { 'Name' => 'Hsp' } );\n            }\n            if ( $self->in_element('hit') ) {\n                $self->end_element( { 'Name' => 'Hit' } );\n            }\n\n           #       $_ = $self->_readline();\n           #       my ( $liblen,$libsize) = /(\\d+)\\s+residues\\s*in(\\d+)\\s*library/;\n           # fast forward to the end of the file as there is\n           # nothing else left to do with this file and want to be sure and\n           # reset it\n            while ( defined( $_ = $self->_readline() ) ) {\n                last if (/^Function used was/);\n                if (\n                    /(\\S+)\\s+searches\\s+a\\s+(protein\\s+or\\s+DNA\\s+)?\n           sequence/oxi || /(\\S+)\\s+compares\\s+a/oi\n                  )\n                {\n                    $self->_pushback($_);\n                }\n            }\n\n            if (@hit_signifs) {\n\n                # process remaining best hits\n                for my $h (@hit_signifs) {\n\n                    # Hsp_score Hsp_evalue Hsp_bit-score\n                    # Hsp_sw-score Hsp_gaps Hsp_identity Hsp_positive\n                    # Hsp_align-len Hsp_query-from Hsp_query-to\n                    # Hsp_hit-from Hsp_hit-to Hsp_qseq Hsp_midline\n\n                    $self->start_element( { 'Name' => 'Hit' } );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_len',\n                            'Data' => $h->{hit_len}\n                        }\n                    ) if exists $h->{hit_len};\n                    $self->element(\n                        {\n                            'Name' => 'Hit_id',\n                            'Data' => $h->{id}\n                        }\n                    ) if exists $h->{id};\n                    $self->element(\n                        {\n                            'Name' => 'Hit_accession',\n                            'Data' => $h->{acc}\n                        }\n                    ) if exists $h->{acc};\n                    $self->element(\n                        {\n                            'Name' => 'Hit_def',\n                            'Data' => $h->{desc}\n                        }\n                    ) if exists $h->{desc};\n                    $self->element(\n                        {\n                            'Name' => 'Hit_signif',\n                            'Data' => $h->{evalue}\n                        }\n                    ) if exists $h->{evalue};\n                    $self->element(\n                        {\n                            'Name' => 'Hit_score',\n                            'Data' => $h->{bits}\n                        }\n                    ) if exists $h->{bits};\n\n                    $self->start_element( { 'Name' => 'Hsp' } );\n                    $self->element(\n                        { 'Name' => 'Hsp_score', 'Data' => $h->{'z-sc'} } )\n                      if exists $h->{'z-sc'};\n                    $self->element(\n                        { 'Name' => 'Hsp_evalue', 'Data' => $h->{evalue} } )\n                      if exists $h->{evalue};\n                    $self->element(\n                        { 'Name' => 'Hsp_bit-score', 'Data' => $h->{bits} } )\n                      if exists $h->{bits};\n                    $self->element(\n                        { 'Name' => 'Hsp_sw-score', 'Data' => $h->{sw} } )\n                      if exists $h->{sw};\n                    $self->element(\n                        { 'Name' => 'Hsp_gaps', 'Data' => $h->{'%_gid'} } )\n                      if exists $h->{'%_gid'};\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_identity',\n                            'Data' =>\n                              sprintf( \"%.0f\", $h->{'%_id'} * $h->{alen} )\n                        }\n                    ) if ( exists $h->{'%_id'} && exists $h->{alen} );\n\n                    if ( exists $h->{'%_gid'} ) {\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_positive',\n                                'Data' =>\n                                  sprintf( \"%.0f\", $h->{'%_gid'} * $h->{alen} )\n                            }\n                        ) if exists $h->{'%_gid'} && exists $h->{alen};\n                    }\n                    else {\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_positive',\n                                'Data' =>\n                                  sprintf( \"%.0f\", $h->{'%_id'} * $h->{alen} )\n                            }\n                        ) if ( exists $h->{'%_id'} && exists $h->{alen} );\n                    }\n                    $self->element(\n                        { 'Name' => 'Hsp_align-len', 'Data' => $h->{alen} } )\n                      if exists $h->{alen};\n                    $self->element(\n                        { 'Name' => 'Hsp_query-from', 'Data' => $h->{an0} } )\n                      if exists $h->{an0};\n                    $self->element(\n                        { 'Name' => 'Hsp_query-to', 'Data' => $h->{ax0} } )\n                      if exists $h->{ax0};\n                    $self->element(\n                        { 'Name' => 'Hsp_hit-from', 'Data' => $h->{an1} } )\n                      if exists $h->{an1};\n                    $self->element(\n                        { 'Name' => 'Hsp_hit-to', 'Data' => $h->{ax1} } )\n                      if exists $h->{ax1};\n\n                    $self->element(\n                        { 'Name' => 'Hsp_querygaps', 'Data' => $h->{qgaps} } )\n                      if exists $h->{qgaps};\n                    $self->element(\n                        { 'Name' => 'Hsp_hitgaps', 'Data' => $h->{lgaps} } )\n                      if exists $h->{lgaps};\n\n                    if ( $self->{'_reporttype'} =~ m/^FAST[NXY]$/o ) {\n                        if ( 8 == scalar grep { exists $h->{$_} }\n                            qw(an0 ax0 pn0 px0 an1 ax1 pn1 px1) )\n                        {\n                            if ( $h->{ax0} < $h->{an0} ) {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_query-frame',\n                                        'Data' =>\n\"-@{[(($h->{px0} - $h->{ax0}) % 3) + 1]}\"\n                                    }\n                                );\n                            }\n                            else {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_query-frame',\n                                        'Data' =>\n\"+@{[(($h->{an0} - $h->{pn0}) % 3) + 1]}\"\n                                    }\n                                );\n                            }\n                            if ( $h->{ax1} < $h->{an1} ) {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_hit-frame',\n                                        'Data' =>\n\"-@{[(($h->{px1} - $h->{ax1}) % 3) + 1]}\"\n                                    }\n                                );\n                            }\n                            else {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_hit-frame',\n                                        'Data' =>\n\"+@{[(($h->{an1} - $h->{pn1}) % 3) + 1]}\"\n                                    }\n                                );\n                            }\n                        }\n                        else {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_query-frame',\n                                    'Data' => $h->{lframe}\n                                }\n                            );\n                            $self->element(\n                                { 'Name' => 'Hsp_hit-frame', 'Data' => 0 } );\n                        }\n                    }\n                    else {\n                        $self->element(\n                            { 'Name' => 'Hsp_query-frame', 'Data' => 0 } );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_hit-frame',\n                                'Data' => $h->{lframe}\n                            }\n                        );\n                    }\n\n                    $self->end_element( { 'Name' => 'Hsp' } );\n                    $self->end_element( { 'Name' => 'Hit' } );\n                }\n            }\n            $self->end_element( { 'Name' => 'FastaOutput' } );\n            return $self->end_document();\n        }\n        elsif (/^\\s*\\d+\\s*>>>/) {\n            if ( $self->within_element('FastaOutput') ) {\n                if ( $self->in_element('hsp') ) {\n                    $self->end_element( { 'Name' => 'Hsp' } );\n                }\n                if ( $self->in_element('hit') ) {\n                    $self->end_element( { 'Name' => 'Hit' } );\n                }\n\n                if (@hit_signifs) {\n\n                    # process remaining best hits\n                    for my $h (@hit_signifs) {\n                        $self->start_element( { 'Name' => 'Hit' } );\n                        $self->element(\n                            {\n                                'Name' => 'Hit_len',\n                                'Data' => $h->{hit_len}\n                            }\n                        ) if exists $h->{hit_len};\n                        $self->element(\n                            {\n                                'Name' => 'Hit_id',\n                                'Data' => $h->{id}\n                            }\n                        ) if exists $h->{id};\n                        $self->element(\n                            {\n                                'Name' => 'Hit_accession',\n                                'Data' => $h->{acc}\n                            }\n                        ) if exists $h->{acc};\n                        $self->element(\n                            {\n                                'Name' => 'Hit_def',\n                                'Data' => $h->{desc}\n                            }\n                        ) if exists $h->{desc};\n                        $self->element(\n                            {\n                                'Name' => 'Hit_signif',\n                                'Data' => $h->{evalue}\n                            }\n                        ) if exists $h->{evalue};\n                        $self->element(\n                            {\n                                'Name' => 'Hit_score',\n                                'Data' => $h->{bits}\n                            }\n                        ) if exists $h->{bits};\n\n                        $self->start_element( { 'Name' => 'Hsp' } );\n                        $self->element(\n                            { 'Name' => 'Hsp_score', 'Data' => $h->{'z-sc'} } )\n                          if exists $h->{'z-sc'};\n                        $self->element(\n                            { 'Name' => 'Hsp_evalue', 'Data' => $h->{evalue} } )\n                          if exists $h->{evalue};\n                        $self->element(\n                            { 'Name' => 'Hsp_bit-score', 'Data' => $h->{bits} }\n                        ) if exists $h->{bits};\n                        $self->element(\n                            { 'Name' => 'Hsp_sw-score', 'Data' => $h->{sw} } )\n                          if exists $h->{sw};\n                        $self->element(\n                            { 'Name' => 'Hsp_gaps', 'Data' => $h->{'%_gid'} } )\n                          if exists $h->{'%_gid'};\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_identity',\n                                'Data' =>\n                                  sprintf( \"%.0f\", $h->{'%_id'} * $h->{alen} )\n                            }\n                        ) if ( exists $h->{'%_id'} && exists $h->{alen} );\n\n                        if ( exists $h->{'%_gid'} ) {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_positive',\n                                    'Data' => sprintf( \"%.0f\",\n                                        $h->{'%_gid'} * $h->{alen} )\n                                }\n                            ) if exists $h->{'%_gid'} && exists $h->{alen};\n                        }\n                        else {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_positive',\n                                    'Data' => sprintf( \"%.0f\",\n                                        $h->{'%_id'} * $h->{alen} )\n                                }\n                            ) if ( exists $h->{'%_id'} && exists $h->{alen} );\n                        }\n                        $self->element(\n                            { 'Name' => 'Hsp_align-len', 'Data' => $h->{alen} }\n                        ) if exists $h->{alen};\n                        $self->element(\n                            { 'Name' => 'Hsp_query-from', 'Data' => $h->{an0} }\n                        ) if exists $h->{an0};\n                        $self->element(\n                            { 'Name' => 'Hsp_query-to', 'Data' => $h->{ax0} } )\n                          if exists $h->{ax0};\n                        $self->element(\n                            { 'Name' => 'Hsp_hit-from', 'Data' => $h->{an1} } )\n                          if exists $h->{an1};\n                        $self->element(\n                            { 'Name' => 'Hsp_hit-to', 'Data' => $h->{ax1} } )\n                          if exists $h->{ax1};\n\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_querygaps',\n                                'Data' => $h->{qgaps}\n                            }\n                        ) if exists $h->{qgaps};\n                        $self->element(\n                            { 'Name' => 'Hsp_hitgaps', 'Data' => $h->{lgaps} } )\n                          if exists $h->{lgaps};\n\n                        if ( $self->{'_reporttype'} =~ m/^FAST[NXY]$/o ) {\n                            if ( 8 == scalar grep { exists $h->{$_} }\n                                qw(an0 ax0 pn0 px0 an1 ax1 pn1 px1) )\n                            {\n                                if ( $h->{ax0} < $h->{an0} ) {\n                                    $self->element(\n                                        {\n                                            'Name' => 'Hsp_query-frame',\n                                            'Data' => \"-@{[(($h->{px0} - $h->{ax0}) % 3) + 1]}\"\n                                        }\n                                    );\n                                }\n                                else {\n                                    $self->element(\n                                        {\n                                            'Name' => 'Hsp_query-frame',\n                                            'Data' => \"+@{[(($h->{an0} - $h->{pn0}) % 3) + 1]}\"\n                                        }\n                                    );\n                                }\n                                if ( $h->{ax1} < $h->{an1} ) {\n                                    $self->element(\n                                        {\n                                            'Name' => 'Hsp_hit-frame',\n                                            'Data' => \"-@{[(($h->{px1} - $h->{ax1}) % 3) + 1]}\"\n                                        }\n                                    );\n                                }\n                                else {\n                                    $self->element(\n                                        {\n                                            'Name' => 'Hsp_hit-frame',\n                                            'Data' => \"+@{[(($h->{an1} - $h->{pn1}) % 3) + 1]}\"\n                                        }\n                                    );\n                                }\n                            }\n                            else {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_query-frame',\n                                        'Data' => $h->{lframe}\n                                    }\n                                );\n                                $self->element(\n                                    { 'Name' => 'Hsp_hit-frame', 'Data' => 0 }\n                                );\n                            }\n                        }\n                        else {\n                            $self->element(\n                                { 'Name' => 'Hsp_query-frame', 'Data' => 0 } );\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_hit-frame',\n                                    'Data' => $h->{lframe}\n                                }\n                            );\n                        }\n\n                        $self->end_element( { 'Name' => 'Hsp' } );\n                        $self->end_element( { 'Name' => 'Hit' } );\n                    }\n                }\n                $self->end_element( { 'Name' => 'FastaOutput' } );\n                $self->_pushback($_);\n                return $self->end_document();\n            }\n            else {\n                $self->start_element( { 'Name' => 'FastaOutput' } );\n                $self->{'_result_count'}++;\n                $seentop = 1;\n                $self->element(\n                    {\n                        'Name' => 'FastaOutput_program',\n                        'Data' => $self->{'_reporttype'}\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'FastaOutput_version',\n                        'Data' => $self->{'_version'}\n                    }\n                );\n\n                my ( $type, $querylen, $querytype, $querydef );\n\n                if (/^\\s*\\d+\\s*>>>(.*)/) {\n                    $querydef = $1;\n                    if ( $querydef =~ /^(.*?)\\s+(?:\\-\\s+)?(\\d+)\\s+(aa|nt).*$/o )\n                    {\n                        ( $querydef, $querylen, $querytype ) = ( $1, $2, $3 );\n                    }\n                }\n\n                if (   $self->{'_reporttype'}\n                    && $self->{'_reporttype'} eq 'FASTA' )\n                {\n                    if ( $querytype eq 'nt' ) {\n                        $self->{'_reporttype'} = 'FASTN';\n                    }\n                    elsif ( $querytype eq 'aa' ) {\n                        $self->{'_reporttype'} = 'FASTP';\n                    }\n                }\n                my ( $name, $descr ) =\n                  ( $querydef =~ m/^(\\S+)(?:\\s+(.*))?\\s*$/o );\n                $self->element(\n                    {\n                        'Name' => 'FastaOutput_query-def',\n                        'Data' => $name\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'FastaOutput_querydesc',\n                        'Data' => $descr\n                    }\n                );\n                if ($querylen) {\n                    $self->element(\n                        {\n                            'Name' => 'FastaOutput_query-len',\n                            'Data' => $querylen\n                        }\n                    );\n                }\n                else {\n                    $self->warn(\"unable to find and set query length\");\n                }\n                if ( defined( $_ = $self->_readline() )\n                    && ( /^\\s*vs\\s+(\\S+)/ || /^Library:\\s+(\\S+)/ ) )\n                {\n                    $self->element(\n                        {\n                            'Name' => 'FastaOutput_db',\n                            'Data' => $1\n                        }\n                    );\n                }\n\n            }\n        }\n        elsif ( $self->in_element('hsp') ) {\n            my @data  = ( [], [], [] );\n            my $count = 0;\n            my $len   = $self->idlength + 1;\n            my ($seq1_id);\n            while ( defined($_) ) {\n                chomp;\n                #$self->debug(\"$count $_\\n\");\n                if (/residues in \\d+\\s+query\\s+sequences/o) {\n                    $self->_pushback($_);\n                    last;\n                }\n                elsif (/^>>>\\*\\*\\*/o) {\n                    $self->end_element( { Name => \"Hsp\" } );\n                    last;\n                }\n                elsif (/^>>/o) {\n                    $self->_pushback($_);\n                    last;\n                }\n                elsif (/^\\s*\\d+\\s*>>>/o) {\n                    $self->_pushback($_);\n                    last;\n                }\n                if ( $count == 0 ) {\n                    if (/^(\\S+)\\s+/) {\n                        $self->_pushback($_);\n                        $count = 2;\n                    }\n                    elsif ( /^\\s+\\d+/ || /^\\s+$/ ) {\n\n                        # do nothing, this is really a 0 line\n                    }\n                    elsif ( length($_) == 0 ) {\n                        $count = -1;\n                    }\n                    else {\n                        $self->_pushback($_);\n                        $count = 0;\n                    }\n                }\n                elsif ( $count == 1 || $count == 3 ) {\n                    if (/^(\\S+)\\s+/) {\n                        $len = CORE::length($1) if $len < CORE::length($1);\n                        s/\\s+$//;    # trim trailing spaces,we don't want them\n                        push @{ $data[ $count - 1 ] }, substr( $_, $len );\n                    }\n                    elsif (/^\\s+(\\d+)/) {\n                        $count = -1;\n                        $self->_pushback($_);\n                    }\n                    elsif ( /^\\s+$/ || length($_) == 0 ) {\n                        $count = 5;\n\n                        # going to skip these\n                    }\n                    else {\n                        $self->throw(\n                            \"Unrecognized alignment line ($count) '$_'\");\n                    }\n                }\n                elsif ( $count == 2 ) {\n                    if (/^\\s+\\d+\\s+/) {\n                        $self->warn(\"$_\\n\") if $self->verbose > 0;\n\n                        # we are on a Subject part of the alignment\n                        # but we THOUGHT we were on the Query\n                        # move that last line to the proper place\n                        push @{ $data[2] }, pop @{ $data[0] };\n                        $count = 4;\n                    }\n                    else {\n\n                        # toss the first IDLENGTH characters of the line\n                        if ( length($_) >= $len ) {\n                            push @{ $data[ $count - 1 ] }, substr( $_, $len );\n                        }\n                    }\n                }\n                last if ( $count++ >= 5 );\n                $_ = $self->_readline();\n            }\n            if ( @{ $data[0] } || @{ $data[2] } ) {\n                $self->characters(\n                    {\n                        'Name' => 'Hsp_qseq',\n                        'Data' => join( '', @{ $data[0] } )\n                    }\n                );\n                $self->characters(\n                    {\n                        'Name' => 'Hsp_midline',\n                        'Data' => join( '', @{ $data[1] } )\n                    }\n                );\n                $self->characters(\n                    {\n                        'Name' => 'Hsp_hseq',\n                        'Data' => join( '', @{ $data[2] } )\n                    }\n                );\n            }\n        }\n        else {\n            if ( !$seentop ) {\n                $self->debug($_);\n                #$self->warn(\"unrecognized FASTA Family report file!\");\n                #return;\n            }\n        }\n    }\n    if ( $self->in_element('result') ) {\n        if ( $self->in_element('hsp') ) {\n            $self->end_element( { 'Name' => 'Hsp' } );\n        }\n        if ( $self->in_element('hit') ) {\n            $self->end_element( { 'Name' => 'Hit' } );\n        }\n        $self->end_element( { 'Name' => 'FastaOutput' } );\n    }\n    return $self->end_document();\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element {\n    my ( $self, $data ) = @_;\n\n    # we currently don't care about attributes\n    my $nm = $data->{'Name'};\n    if ( my $type = $MODEMAP{$nm} ) {\n        $self->_mode($type);\n        if ( my $handler = $self->_will_handle($type) ) {\n            my $func = sprintf( \"start_%s\", lc $type );\n            $handler->$func( $data->{'Attributes'} );\n        }\n        unshift @{ $self->{'_elements'} }, $type;\n    }\n    if ( $nm eq 'FastaOutput' ) {\n        $self->{'_values'} = {};\n        $self->{'_result'} = undef;\n        $self->{'_mode'}   = '';\n    }\n\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ( $self, $data ) = @_;\n    my $nm = $data->{'Name'};\n    my $rc;\n\n    # Hsp are sort of weird, in that they end when another\n    # object begins so have to detect this in end_element for now\n    if ( $nm eq 'Hsp' ) {\n        foreach (qw(Hsp_qseq Hsp_midline Hsp_hseq)) {\n            $self->element(\n                {\n                    'Name' => $_,\n                    'Data' => $self->{'_last_hspdata'}->{$_}\n                }\n            );\n        }\n        $self->{'_last_hspdata'} = {};\n    }\n\n    if ( my $type = $MODEMAP{$nm} ) {\n        if ( my $handler = $self->_will_handle($type) ) {\n            my $func = sprintf( \"end_%s\", lc $type );\n            $rc = $handler->$func( $self->{'_reporttype'}, $self->{'_values'} );\n        }\n        shift @{ $self->{'_elements'} };\n\n    }\n    elsif ( $MAPPING{$nm} ) {\n        if ( ref( $MAPPING{$nm} ) =~ /hash/i ) {\n            my $key = ( keys %{ $MAPPING{$nm} } )[0];\n            $self->{'_values'}->{$key}->{ $MAPPING{$nm}->{$key} } =\n              $self->{'_last_data'};\n        }\n        else {\n            $self->{'_values'}->{ $MAPPING{$nm} } = $self->{'_last_data'};\n        }\n    }\n    else {\n        $self->warn(\"unknown nm $nm, ignoring\\n\");\n    }\n    $self->{'_last_data'} = '';    # remove read data if we are at\n                                   # end of an element\n    $self->{'_result'} = $rc if ( $nm eq 'FastaOutput' );\n    return $rc;\n\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element {\n    my ( $self, $data ) = @_;\n    $self->start_element($data);\n    $self->characters($data);\n    $self->end_element($data);\n}\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string","label":"characters($self,$data)"},"name":"characters","range":{"start":{"line":1517,"character":0},"end":{"line":1533,"character":9999}}},{"kind":12,"children":[{"kind":13,"line":1548,"containerName":"_mode","definition":"my","name":"$self","localvar":"my"},{"name":"$value","containerName":"_mode","kind":13,"line":1548},{"name":"$value","containerName":"_mode","line":1549,"kind":13},{"containerName":"_mode","name":"$self","line":1550,"kind":13},{"containerName":"_mode","name":"$value","line":1550,"kind":13},{"kind":13,"line":1552,"containerName":"_mode","name":"$self"}],"line":1547,"definition":"sub","containerName":"main::","signature":{"documentation":"1;\n# $Id: fasta.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::fasta\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::fasta - A SearchIO parser for FASTA results\n\n=head1 SYNOPSIS\n\n  # Do not use this object directly, use it through the SearchIO system\n   use Bio::SearchIO;\n   my $searchio = Bio::SearchIO->new(-format => 'fasta',\n                    -file   => 'report.FASTA');\n   while( my $result = $searchio->next_result ) {\n    # ... do what you would normally doi with Bio::SearchIO.\n   }\n\n=head1 DESCRIPTION\n\nThis object contains the event based parsing code for FASTA format\nreports.  It creates L<Bio::Search::HSP::FastaHSP> objects instead of\nL<Bio::Search::HSP::GenericHSP> for the HSP objects. \n\nThis module will parse -m 9 -d 0 output as well as default m 1 output\nfrom FASTA as well as SSEARCH.\n\nAlso see the SearchIO HOWTO:\nL<http://bioperl.open-bio.org/wiki/HOWTO:SearchIO>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich, Aaron Mackey\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::fasta;\nuse vars qw(%MODEMAP %MAPPING $IDLENGTH);\nuse strict;\n\n# Object preamble - inherits from Bio::Root::RootI\n\nuse Bio::Factory::ObjectFactory;\n\nBEGIN {\n\n    # Set IDLENGTH to a new value if you have\n    # compile FASTA with a different ID length\n    # (actually newest FASTA allows the setting of this\n    #  via -C parameter, default is 6)\n    $IDLENGTH = 6;\n\n    # mapping of NCBI Blast terms to Bioperl hash keys\n    %MODEMAP = (\n        'FastaOutput' => 'result',\n        'Hit'         => 'hit',\n        'Hsp'         => 'hsp'\n    );\n\n    # This should really be done more intelligently, like with\n    # XSLT\n\n    %MAPPING = (\n        'Hsp_bit-score'   => 'HSP-bits',\n        'Hsp_score'       => 'HSP-score',\n        'Hsp_sw-score'    => 'HSP-swscore',\n        'Hsp_evalue'      => 'HSP-evalue',\n        'Hsp_query-from'  => 'HSP-query_start',\n        'Hsp_query-to'    => 'HSP-query_end',\n        'Hsp_hit-from'    => 'HSP-hit_start',\n        'Hsp_hit-to'      => 'HSP-hit_end',\n        'Hsp_positive'    => 'HSP-conserved',\n        'Hsp_identity'    => 'HSP-identical',\n        'Hsp_gaps'        => 'HSP-hsp_gaps',\n        'Hsp_hitgaps'     => 'HSP-hit_gaps',\n        'Hsp_querygaps'   => 'HSP-query_gaps',\n        'Hsp_qseq'        => 'HSP-query_seq',\n        'Hsp_hseq'        => 'HSP-hit_seq',\n        'Hsp_midline'     => 'HSP-homology_seq',\n        'Hsp_align-len'   => 'HSP-hsp_length',\n        'Hsp_query-frame' => 'HSP-query_frame',\n        'Hsp_hit-frame'   => 'HSP-hit_frame',\n\n        'Hit_id'        => 'HIT-name',\n        'Hit_len'       => 'HIT-length',\n        'Hit_accession' => 'HIT-accession',\n        'Hit_def'       => 'HIT-description',\n        'Hit_signif'    => 'HIT-significance',\n        'Hit_score'     => 'HIT-score',\n\n        'FastaOutput_program'   => 'RESULT-algorithm_name',\n        'FastaOutput_version'   => 'RESULT-algorithm_version',\n        'FastaOutput_query-def' => 'RESULT-query_name',\n        'FastaOutput_querydesc' => 'RESULT-query_description',\n        'FastaOutput_query-len' => 'RESULT-query_length',\n        'FastaOutput_db'        => 'RESULT-database_name',\n        'FastaOutput_db-len'    => 'RESULT-database_entries',\n        'FastaOutput_db-let'    => 'RESULT-database_letters',\n\n        'Parameters_matrix'      => { 'RESULT-parameters' => 'matrix' },\n        'Parameters_expect'      => { 'RESULT-parameters' => 'expect' },\n        'Parameters_include'     => { 'RESULT-parameters' => 'include' },\n        'Parameters_sc-match'    => { 'RESULT-parameters' => 'match' },\n        'Parameters_sc-mismatch' => { 'RESULT-parameters' => 'mismatch' },\n        'Parameters_gap-open'    => { 'RESULT-parameters' => 'gapopen' },\n        'Parameters_gap-ext'     => { 'RESULT-parameters' => 'gapext' },\n        'Parameters_word-size'   => { 'RESULT-parameters' => 'wordsize' },\n        'Parameters_ktup'        => { 'RESULT-parameters' => 'ktup' },\n        'Parameters_filter'      => { 'RESULT-parameters' => 'filter' },\n        'Statistics_db-num'      => { 'RESULT-statistics' => 'dbentries' },\n        'Statistics_db-len'      => { 'RESULT-statistics' => 'dbletters' },\n        'Statistics_hsp-len'     => { 'RESULT-statistics' => 'hsplength' },\n        'Statistics_eff-space'   => { 'RESULT-statistics' => 'effectivespace' },\n        'Statistics_kappa'       => { 'RESULT-statistics' => 'kappa' },\n        'Statistics_lambda'      => { 'RESULT-statistics' => 'lambda' },\n        'Statistics_entropy'     => { 'RESULT-statistics' => 'entropy' },\n    );\n}\n\nuse base qw(Bio::SearchIO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::fasta->new();\n Function: Builds a new Bio::SearchIO::fasta object \n Returns : Bio::SearchIO::fasta\n Args    : -idlength - set ID length to something other \n                       than the default (7), this is only\n                       necessary if you have compiled FASTA\n                       with a new default id length to display\n                       in the HSP alignment blocks\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n    return unless @args;\n    my ($idlength) = $self->_rearrange( [qw(IDLENGTH)], @args );\n    $self->idlength( $idlength || $IDLENGTH );\n    $self->_eventHandler->register_factory(\n        'hsp',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::HSP::FastaHSP',\n            -interface => 'Bio::Search::HSP::HSPI'\n        )\n    );\n    return 1;\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    local $/ = \"\\n\";\n    local $_;\n\n    my $data    = '';\n    my $seentop = 0;\n    my $current_hsp;\n    $self->start_document();\n    my @hit_signifs;\n    while ( defined( $_ = $self->_readline ) ) {\n        next if ( !$self->in_element('hsp')\n            && /^\\s+$/ );    # skip empty lines\n        if (\n               m/(\\S+)\\s+searches\\s+a\\s+(protein\\s+or\\s+DNA\\s+)?sequence/oxi\n            || /(\\S+)\\s+compares\\s+a/\n            || (   m/^\\#\\s+/\n                && ( $_ = $self->_readline )\n                && /(\\S+)\\s+searches\\s+a\\s+(protein\\s+or\\s+DNA\\s+)?sequence/oxi\n                || /(\\S+)\\s+compares\\s+a/ )\n          )\n        {\n            if ($seentop) {\n                $self->_pushback($_);\n                $self->end_element( { 'Name' => 'FastaOutput' } );\n                return $self->end_document();\n            }\n            $self->{'_reporttype'} = $1;\n            $self->start_element( { 'Name' => 'FastaOutput' } );\n            $self->{'_result_count'}++;\n            $seentop = 1;\n            #$self->debug( \"reporttype is \" . $self->{'_reporttype'} . \"\\n\" );\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_program',\n                    'Data' => $self->{'_reporttype'}\n                }\n            );\n            $_ = $self->_readline();\n            my ($version) = (/version\\s+(\\S+)/);\n            $version = '' unless defined $version;\n            $self->{'_version'} = $version;\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_version',\n                    'Data' => $version\n                }\n            );\n\n            my ( $last, $leadin, $type, $querylen, $querytype, $querydef );\n\n            while ( defined( $_ = $self->_readline() ) ) {\n                if (\n                    /^ (\n                       (?:\\s+>) |             # fa33 lead-in\n                       (?:\\s*\\d+\\s*>>>)       # fa34 mlib lead-in\n                      )\n                      (.*)\n                   /x\n                  )\n                {\n                    ( $leadin, $querydef ) = ( $1, $2 );\n                    if ( $leadin =~ m/>>>/ ) {\n                        if ( $querydef =~\n                            /^(.*?)\\s+(?:\\-\\s+)?(\\d+)\\s+(aa|nt).*$/o )\n                        {\n                            ( $querydef, $querylen, $querytype ) =\n                              ( $1, $2, $3 );\n                            last;\n                        }\n                    }\n                    else {\n                        if ( $last =~ /(\\S+)[:,]\\s*(\\d+)\\s+(aa|nt)/ ) {\n                            ( $querylen, $querytype ) = ( $2, $3 );\n                            $querydef ||= $1;\n                            last;\n                        }\n                    }\n                }\n                elsif (m/^\\s*vs\\s+\\S+/o) {\n                    if ( $last =~ /(\\S+)[,:]\\s+(\\d+)\\s+(aa|nt)/o ) {\n                        ( $querydef, $querylen, $querytype ) = ( $1, $2, $3 );\n                        last;\n                    }\n                }\n                $last = $_;\n            }\n            if (   $self->{'_reporttype'}\n                && $self->{'_reporttype'} eq 'FASTA' )\n            {\n                if ( $querytype eq 'nt' ) {\n                    $self->{'_reporttype'} = 'FASTN';\n                }\n                elsif ( $querytype eq 'aa' ) {\n                    $self->{'_reporttype'} = 'FASTP';\n                }\n            }\n            my ( $name, $descr ) = $querydef =~ m/^(\\S+)\\s*(.*?)\\s*$/o;\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_query-def',\n                    'Data' => $name\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_querydesc',\n                    'Data' => $descr\n                }\n            );\n            if ($querylen) {\n                $self->element(\n                    {\n                        'Name' => 'FastaOutput_query-len',\n                        'Data' => $querylen\n                    }\n                );\n            }\n            else {\n                $self->warn(\"unable to find and set query length\");\n            }\n            if (\n                   $last =~ /^\\s*vs\\s+(\\S+)/\n                || ( $last =~ /^searching\\s+(\\S+)\\s+library/ )\n                || ( $last =~ /^Library:\\s+(\\S+)\\s+/ )\n                || (\n                    defined $_\n                    && (   /^\\s*vs\\s+(\\S+)/\n                        || /^Library:\\s+(\\S+)\\s+/ )\n                )\n                || ( defined( $_ = $self->_readline() )\n                    && ( /^\\s*vs\\s+(\\S+)/ || /^Library:\\s+(\\S+)/ ) )\n              )\n            {\n                $self->element(\n                    {\n                        'Name' => 'FastaOutput_db',\n                        'Data' => $1\n                    }\n                );\n            }\n            elsif (m/^\\s+opt(?:\\s+E\\(\\))?$/o) {\n\n           # histogram ... read over it more rapidly than the larger outer loop:\n                while ( defined( $_ = $self->_readline ) ) {\n                    last if m/^>\\d+/;\n                }\n            }\n        }\n        elsif (/(\\d+)\\s+residues\\s+in\\s+(\\d+)\\s+(?:library\\s+)?sequences/) {\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_db-let',\n                    'Data' => $1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_db-len',\n                    'Data' => $2\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Statistics_db-len',\n                    'Data' => $1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Statistics_db-num',\n                    'Data' => $2\n                }\n            );\n        }\n        elsif (/Lambda=\\s*(\\S+)/) {\n            $self->element(\n                {\n                    'Name' => 'Statistics_lambda',\n                    'Data' => $1\n                }\n            );\n        }\n        elsif (/K=\\s*(\\S+)/) {\n            $self->element(\n                {\n                    'Name' => 'Statistics_kappa',\n                    'Data' => $1\n                }\n            );\n        }\n        elsif (/^\\s*(Smith-Waterman).+(\\S+)\\s*matrix [^\\]]*?(xS)?\\]/) {\n            $self->element(\n                {\n                    'Name' => 'Parameters_matrix',\n                    'Data' => $2\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_filter',\n                    'Data' => defined $3 ? 1 : 0,\n                }\n            );\n            $self->{'_reporttype'} = $1;\n\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_program',\n                    'Data' => $self->{'_reporttype'}\n                }\n            );\n        }\n        elsif (/The best( related| unrelated)? scores are:/) {\n            my $rel    = $1;\n            my @labels = split;\n            @labels = map {\n                if ( $_ =~ m/^E\\((\\d+)\\)$/o )\n                {\n                    $self->element(\n                        { 'Name' => 'Statistics_eff-space', 'Data' => $1 } );\n                    \"evalue\";\n                }\n                else {\n                    $_;\n                }\n            } @labels[ $rel ? 5 : 4 .. $#labels ];\n\n            while ( defined( $_ = $self->_readline() )\n                && !/^\\s+$/ )\n            {\n                my @line = split;\n\n                if ( $line[-1] =~ m/\\=/o && $labels[-1] eq 'fs' ) {\n\n                    # unlabelled alignment hit;\n                    push @labels, \"aln_code\";\n                }\n\n                my %data;\n                @data{@labels} = splice( @line, @line - @labels );\n                if ( $line[-1] =~ m/\\[([1-6rf])\\]/o ) {\n                    my $fr = $1;\n                    $data{lframe} = (\n                        $fr =~ /\\d/o\n                        ? ( $fr <= 3 ? \"+$fr\" : \"-@{[$fr-3]}\" )\n                        : ( $fr eq 'f' ? '+1' : '-1' )\n                    );\n                    pop @line;\n                }\n                else {\n                    $data{lframe} = '0';\n                }\n\n                if ( $line[-1] =~ m/^\\(?(\\d+)\\)$/ ) {\n                    $data{hit_len} = $1;\n                    pop @line;\n                    if ( $line[-1] =~ m/^\\($/ ) {\n                        pop @line;\n                    }\n                }\n                else {\n                    $data{hit_len} = 0;\n                }\n\n                # rebuild the first part of the line, preserving spaces:\n                ($_) = m/^(\\S+(?:\\s+\\S+){$#line})/;\n\n                my ( $id, $desc ) = split( /\\s+/, $_, 2 );\n                my @pieces = split( /\\|/, $id );\n                my $acc = pop @pieces;\n                $acc =~ s/\\.\\d+$//;\n\n                @data{qw(id desc acc)} = ( $id, $desc, $acc );\n\n                push @hit_signifs, \\%data;\n            }\n        }\n        elsif (\n/^\\s*([T]?FAST[XYAF]).+,\\s*(\\S+)\\s*matrix[^\\]]+?(xS)?\\]\\s*ktup:\\s*(\\d+)/\n          )\n        {\n\n            $self->element(\n                {\n                    'Name' => 'Parameters_matrix',\n                    'Data' => $2\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_filter',\n                    'Data' => defined $3 ? 1 : 0,\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_ktup',\n                    'Data' => $4\n                }\n            );\n            $self->{'_reporttype'} = $1\n              if ( $self->{'_reporttype'} !~ /FAST[PN]/i );\n\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_program',\n                    'Data' => $self->{'_reporttype'}\n                }\n            );\n        }\n        elsif (/^Algorithm:\\s+(\\S+)\\s+\\(([^)]+)\\)\\s+(\\S+)/) {\n            $self->{'_reporttype'} = $1\n              if ( $self->{'_reporttype'} !~ /FAST[PN]/i );\n        }\n        elsif (\n            /^Parameters:\\s+(\\S+)\\s*matrix\\s*(?:\\(([^(]+?)\\))?\\s*ktup:\\s*(\\d+)/)\n        {    # FASTA 35.04\n            $self->element(\n                {\n                    'Name' => 'Parameters_matrix',\n                    'Data' => $1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_filter',\n                    'Data' => defined $2 ? $2 : 0,\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_ktup',\n                    'Data' => $3\n                }\n            );\n        }\n        elsif (\n/(?:gap\\-pen|open\\/ext):\\s+([\\-\\+]?\\d+)\\s*\\/\\s*([\\-\\+]?\\d+).+width:\\s+(\\d+)/\n          )\n        {\n            $self->element(\n                {\n                    'Name' => 'Parameters_gap-open',\n                    'Data' => $1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_gap-ext',\n                    'Data' => $2\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_word-size',\n                    'Data' => $3\n                }\n            );\n        }\n        elsif (/^>>(?!>)(.+?)\\s+(?:\\((\\d+)\\s*(aa|nt)\\))?$/) {\n            my ($hit_id, $len, $alphabet) = ($1, $2, $3);\n            if (!$len || !$alphabet) {\n                WRAPPED:\n                while (defined($_ = $self->_readline)) {\n                    if (/(.*?)\\s+\\((\\d+)\\s*(aa|nt)\\)/) {\n                        ($len, $alphabet) = ($2, $3);\n                        $hit_id .= $1 ? \" \".$1 : '';\n                        last WRAPPED;\n                    }\n                    if (/^>>(?!>)/) { # too far, throw\n                        $self->throw(\"Couldn't find length, bailing\");\n                    }\n                }\n            }\n            if ( $self->in_element('hsp') ) {\n                $self->end_element( { 'Name' => 'Hsp' } );\n            }\n            if ( $self->in_element('hit') ) {\n                $self->end_element( { 'Name' => 'Hit' } );\n            }\n\n            $self->start_element( { 'Name' => 'Hit' } );\n            $self->element(\n                {\n                    'Name' => 'Hit_len',\n                    'Data' => $len\n                }\n            );\n            my ( $id, $desc ) = split( /\\s+/, $hit_id, 2 );\n            $self->element(\n                {\n                    'Name' => 'Hit_id',\n                    'Data' => $id\n                }\n            );\n\n            #$self->debug(\"Hit ID is $id\\n\");\n            my @pieces = split( /\\|/, $id );\n            my $acc = pop @pieces;\n            $acc =~ s/\\.\\d+$//;\n            $self->element(\n                {\n                    'Name' => 'Hit_accession',\n                    'Data' => $acc\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hit_def',\n                    'Data' => $desc\n                }\n            );\n\n            $_ = $self->_readline();\n            my ( $score, $bits, $e ) = /Z-score: \\s* (\\S+) \\s*\n                               (?: bits: \\s* (\\S+) \\s+ )?\n                               (?: E|expect ) \\s* \\(\\) :? \\s*(\\S+)/ox;\n            $bits = $score unless defined $bits;\n\n            my $v = shift @hit_signifs;\n            if ( defined $v ) {\n                @{$v}{qw(evalue bits z-sc)} = ( $e, $bits, $score );\n            }\n            $self->element(\n                {\n                    'Name' => 'Hit_signif',\n                    'Data' => $v ? $v->{evalue} : $e\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hit_score',\n                    'Data' => $v ? $v->{bits} : $bits\n                }\n            );\n            $self->start_element( { 'Name' => 'Hsp' } );\n\n            $self->element(\n                {\n                    'Name' => 'Hsp_score',\n                    'Data' => $v ? $v->{'z-sc'} : $score\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_evalue',\n                    'Data' => $v ? $v->{evalue} : $e\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_bit-score',\n                    'Data' => $v ? $v->{bits} : $bits\n                }\n            );\n            $_ = $self->_readline();\n\n            if (s/Smith-Waterman score:\\s*(\\d+)\\;?//) {\n                $self->element(\n                    {\n                        'Name' => 'Hsp_sw-score',\n                        'Data' => $1\n                    }\n                );\n            }\n            if (\n                / (\\d*\\.?\\d+)\\% \\s* identity\n                 (?:\\s* \\(\\s*(\\S+)\\% \\s* (?:ungapped|similar) \\) )?\n                 \\s* in \\s* (\\d+) \\s+ (?:aa|nt) \\s+ overlap \\s*\n                 \\( (\\d+) \\- (\\d+) : (\\d+) \\- (\\d+) \\)\n               /x\n              )\n            {\n                my ( $identper, $gapper, $len, $querystart, $queryend,\n                    $hitstart, $hitend )\n                  = ( $1, $2, $3, $4, $5, $6, $7 );\n                my $ident = sprintf( \"%.0f\", ( $identper / 100 ) * $len );\n                my $positive = sprintf( \"%.0f\", ( $gapper / 100 ) * $len );\n\n                $self->element(\n                    {\n                        'Name' => 'Hsp_identity',\n                        'Data' => $ident\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'Hsp_positive',\n                        'Data' => $positive\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'Hsp_align-len',\n                        'Data' => $len\n                    }\n                );\n\n                $self->element(\n                    {\n                        'Name' => 'Hsp_query-from',\n                        'Data' => $querystart\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'Hsp_query-to',\n                        'Data' => $queryend\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'Hsp_hit-from',\n                        'Data' => $hitstart\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'Hsp_hit-to',\n                        'Data' => $hitend\n                    }\n                );\n\n            }\n\n            if ($v) {\n                $self->element(\n                    { 'Name' => 'Hsp_querygaps', 'Data' => $v->{qgaps} } )\n                  if exists $v->{qgaps};\n                $self->element(\n                    { 'Name' => 'Hsp_hitgaps', 'Data' => $v->{lgaps} } )\n                  if exists $v->{lgaps};\n\n                if ( $self->{'_reporttype'} =~ m/^FAST[NXY]$/o ) {\n                    if ( 8 == scalar grep { exists $v->{$_} }\n                        qw(an0 ax0 pn0 px0 an1 ax1 pn1 px1) )\n                    {\n                        if ( $v->{ax0} < $v->{an0} ) {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_query-frame',\n                                    'Data' =>\n                                      \"-@{[(($v->{px0} - $v->{ax0}) % 3) + 1]}\"\n                                }\n                            );\n                        }\n                        else {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_query-frame',\n                                    'Data' =>\n                                      \"+@{[(($v->{an0} - $v->{pn0}) % 3) + 1]}\"\n                                }\n                            );\n                        }\n                        if ( $v->{ax1} < $v->{an1} ) {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_hit-frame',\n                                    'Data' =>\n                                      \"-@{[(($v->{px1} - $v->{ax1}) % 3) + 1]}\"\n                                }\n                            );\n                        }\n                        else {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_hit-frame',\n                                    'Data' =>\n                                      \"+@{[(($v->{an1} - $v->{pn1}) % 3) + 1]}\"\n                                }\n                            );\n                        }\n                    }\n                    else {\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_query-frame',\n                                'Data' => $v->{lframe}\n                            }\n                        );\n                        $self->element(\n                            { 'Name' => 'Hsp_hit-frame', 'Data' => 0 } );\n                    }\n                }\n                else {\n                    $self->element(\n                        { 'Name' => 'Hsp_query-frame', 'Data' => 0 } );\n                    $self->element(\n                        { 'Name' => 'Hsp_hit-frame', 'Data' => $v->{lframe} } );\n                }\n\n            }\n            else {\n                $self->warn(\"unable to parse FASTA score line: $_\");\n            }\n        }\n        elsif (/\\d+\\s*residues\\s*in\\s*\\d+\\s*query\\s*sequences/) {\n            if ( $self->in_element('hsp') ) {\n                $self->end_element( { 'Name' => 'Hsp' } );\n            }\n            if ( $self->in_element('hit') ) {\n                $self->end_element( { 'Name' => 'Hit' } );\n            }\n\n           #       $_ = $self->_readline();\n           #       my ( $liblen,$libsize) = /(\\d+)\\s+residues\\s*in(\\d+)\\s*library/;\n           # fast forward to the end of the file as there is\n           # nothing else left to do with this file and want to be sure and\n           # reset it\n            while ( defined( $_ = $self->_readline() ) ) {\n                last if (/^Function used was/);\n                if (\n                    /(\\S+)\\s+searches\\s+a\\s+(protein\\s+or\\s+DNA\\s+)?\n           sequence/oxi || /(\\S+)\\s+compares\\s+a/oi\n                  )\n                {\n                    $self->_pushback($_);\n                }\n            }\n\n            if (@hit_signifs) {\n\n                # process remaining best hits\n                for my $h (@hit_signifs) {\n\n                    # Hsp_score Hsp_evalue Hsp_bit-score\n                    # Hsp_sw-score Hsp_gaps Hsp_identity Hsp_positive\n                    # Hsp_align-len Hsp_query-from Hsp_query-to\n                    # Hsp_hit-from Hsp_hit-to Hsp_qseq Hsp_midline\n\n                    $self->start_element( { 'Name' => 'Hit' } );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_len',\n                            'Data' => $h->{hit_len}\n                        }\n                    ) if exists $h->{hit_len};\n                    $self->element(\n                        {\n                            'Name' => 'Hit_id',\n                            'Data' => $h->{id}\n                        }\n                    ) if exists $h->{id};\n                    $self->element(\n                        {\n                            'Name' => 'Hit_accession',\n                            'Data' => $h->{acc}\n                        }\n                    ) if exists $h->{acc};\n                    $self->element(\n                        {\n                            'Name' => 'Hit_def',\n                            'Data' => $h->{desc}\n                        }\n                    ) if exists $h->{desc};\n                    $self->element(\n                        {\n                            'Name' => 'Hit_signif',\n                            'Data' => $h->{evalue}\n                        }\n                    ) if exists $h->{evalue};\n                    $self->element(\n                        {\n                            'Name' => 'Hit_score',\n                            'Data' => $h->{bits}\n                        }\n                    ) if exists $h->{bits};\n\n                    $self->start_element( { 'Name' => 'Hsp' } );\n                    $self->element(\n                        { 'Name' => 'Hsp_score', 'Data' => $h->{'z-sc'} } )\n                      if exists $h->{'z-sc'};\n                    $self->element(\n                        { 'Name' => 'Hsp_evalue', 'Data' => $h->{evalue} } )\n                      if exists $h->{evalue};\n                    $self->element(\n                        { 'Name' => 'Hsp_bit-score', 'Data' => $h->{bits} } )\n                      if exists $h->{bits};\n                    $self->element(\n                        { 'Name' => 'Hsp_sw-score', 'Data' => $h->{sw} } )\n                      if exists $h->{sw};\n                    $self->element(\n                        { 'Name' => 'Hsp_gaps', 'Data' => $h->{'%_gid'} } )\n                      if exists $h->{'%_gid'};\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_identity',\n                            'Data' =>\n                              sprintf( \"%.0f\", $h->{'%_id'} * $h->{alen} )\n                        }\n                    ) if ( exists $h->{'%_id'} && exists $h->{alen} );\n\n                    if ( exists $h->{'%_gid'} ) {\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_positive',\n                                'Data' =>\n                                  sprintf( \"%.0f\", $h->{'%_gid'} * $h->{alen} )\n                            }\n                        ) if exists $h->{'%_gid'} && exists $h->{alen};\n                    }\n                    else {\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_positive',\n                                'Data' =>\n                                  sprintf( \"%.0f\", $h->{'%_id'} * $h->{alen} )\n                            }\n                        ) if ( exists $h->{'%_id'} && exists $h->{alen} );\n                    }\n                    $self->element(\n                        { 'Name' => 'Hsp_align-len', 'Data' => $h->{alen} } )\n                      if exists $h->{alen};\n                    $self->element(\n                        { 'Name' => 'Hsp_query-from', 'Data' => $h->{an0} } )\n                      if exists $h->{an0};\n                    $self->element(\n                        { 'Name' => 'Hsp_query-to', 'Data' => $h->{ax0} } )\n                      if exists $h->{ax0};\n                    $self->element(\n                        { 'Name' => 'Hsp_hit-from', 'Data' => $h->{an1} } )\n                      if exists $h->{an1};\n                    $self->element(\n                        { 'Name' => 'Hsp_hit-to', 'Data' => $h->{ax1} } )\n                      if exists $h->{ax1};\n\n                    $self->element(\n                        { 'Name' => 'Hsp_querygaps', 'Data' => $h->{qgaps} } )\n                      if exists $h->{qgaps};\n                    $self->element(\n                        { 'Name' => 'Hsp_hitgaps', 'Data' => $h->{lgaps} } )\n                      if exists $h->{lgaps};\n\n                    if ( $self->{'_reporttype'} =~ m/^FAST[NXY]$/o ) {\n                        if ( 8 == scalar grep { exists $h->{$_} }\n                            qw(an0 ax0 pn0 px0 an1 ax1 pn1 px1) )\n                        {\n                            if ( $h->{ax0} < $h->{an0} ) {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_query-frame',\n                                        'Data' =>\n\"-@{[(($h->{px0} - $h->{ax0}) % 3) + 1]}\"\n                                    }\n                                );\n                            }\n                            else {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_query-frame',\n                                        'Data' =>\n\"+@{[(($h->{an0} - $h->{pn0}) % 3) + 1]}\"\n                                    }\n                                );\n                            }\n                            if ( $h->{ax1} < $h->{an1} ) {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_hit-frame',\n                                        'Data' =>\n\"-@{[(($h->{px1} - $h->{ax1}) % 3) + 1]}\"\n                                    }\n                                );\n                            }\n                            else {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_hit-frame',\n                                        'Data' =>\n\"+@{[(($h->{an1} - $h->{pn1}) % 3) + 1]}\"\n                                    }\n                                );\n                            }\n                        }\n                        else {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_query-frame',\n                                    'Data' => $h->{lframe}\n                                }\n                            );\n                            $self->element(\n                                { 'Name' => 'Hsp_hit-frame', 'Data' => 0 } );\n                        }\n                    }\n                    else {\n                        $self->element(\n                            { 'Name' => 'Hsp_query-frame', 'Data' => 0 } );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_hit-frame',\n                                'Data' => $h->{lframe}\n                            }\n                        );\n                    }\n\n                    $self->end_element( { 'Name' => 'Hsp' } );\n                    $self->end_element( { 'Name' => 'Hit' } );\n                }\n            }\n            $self->end_element( { 'Name' => 'FastaOutput' } );\n            return $self->end_document();\n        }\n        elsif (/^\\s*\\d+\\s*>>>/) {\n            if ( $self->within_element('FastaOutput') ) {\n                if ( $self->in_element('hsp') ) {\n                    $self->end_element( { 'Name' => 'Hsp' } );\n                }\n                if ( $self->in_element('hit') ) {\n                    $self->end_element( { 'Name' => 'Hit' } );\n                }\n\n                if (@hit_signifs) {\n\n                    # process remaining best hits\n                    for my $h (@hit_signifs) {\n                        $self->start_element( { 'Name' => 'Hit' } );\n                        $self->element(\n                            {\n                                'Name' => 'Hit_len',\n                                'Data' => $h->{hit_len}\n                            }\n                        ) if exists $h->{hit_len};\n                        $self->element(\n                            {\n                                'Name' => 'Hit_id',\n                                'Data' => $h->{id}\n                            }\n                        ) if exists $h->{id};\n                        $self->element(\n                            {\n                                'Name' => 'Hit_accession',\n                                'Data' => $h->{acc}\n                            }\n                        ) if exists $h->{acc};\n                        $self->element(\n                            {\n                                'Name' => 'Hit_def',\n                                'Data' => $h->{desc}\n                            }\n                        ) if exists $h->{desc};\n                        $self->element(\n                            {\n                                'Name' => 'Hit_signif',\n                                'Data' => $h->{evalue}\n                            }\n                        ) if exists $h->{evalue};\n                        $self->element(\n                            {\n                                'Name' => 'Hit_score',\n                                'Data' => $h->{bits}\n                            }\n                        ) if exists $h->{bits};\n\n                        $self->start_element( { 'Name' => 'Hsp' } );\n                        $self->element(\n                            { 'Name' => 'Hsp_score', 'Data' => $h->{'z-sc'} } )\n                          if exists $h->{'z-sc'};\n                        $self->element(\n                            { 'Name' => 'Hsp_evalue', 'Data' => $h->{evalue} } )\n                          if exists $h->{evalue};\n                        $self->element(\n                            { 'Name' => 'Hsp_bit-score', 'Data' => $h->{bits} }\n                        ) if exists $h->{bits};\n                        $self->element(\n                            { 'Name' => 'Hsp_sw-score', 'Data' => $h->{sw} } )\n                          if exists $h->{sw};\n                        $self->element(\n                            { 'Name' => 'Hsp_gaps', 'Data' => $h->{'%_gid'} } )\n                          if exists $h->{'%_gid'};\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_identity',\n                                'Data' =>\n                                  sprintf( \"%.0f\", $h->{'%_id'} * $h->{alen} )\n                            }\n                        ) if ( exists $h->{'%_id'} && exists $h->{alen} );\n\n                        if ( exists $h->{'%_gid'} ) {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_positive',\n                                    'Data' => sprintf( \"%.0f\",\n                                        $h->{'%_gid'} * $h->{alen} )\n                                }\n                            ) if exists $h->{'%_gid'} && exists $h->{alen};\n                        }\n                        else {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_positive',\n                                    'Data' => sprintf( \"%.0f\",\n                                        $h->{'%_id'} * $h->{alen} )\n                                }\n                            ) if ( exists $h->{'%_id'} && exists $h->{alen} );\n                        }\n                        $self->element(\n                            { 'Name' => 'Hsp_align-len', 'Data' => $h->{alen} }\n                        ) if exists $h->{alen};\n                        $self->element(\n                            { 'Name' => 'Hsp_query-from', 'Data' => $h->{an0} }\n                        ) if exists $h->{an0};\n                        $self->element(\n                            { 'Name' => 'Hsp_query-to', 'Data' => $h->{ax0} } )\n                          if exists $h->{ax0};\n                        $self->element(\n                            { 'Name' => 'Hsp_hit-from', 'Data' => $h->{an1} } )\n                          if exists $h->{an1};\n                        $self->element(\n                            { 'Name' => 'Hsp_hit-to', 'Data' => $h->{ax1} } )\n                          if exists $h->{ax1};\n\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_querygaps',\n                                'Data' => $h->{qgaps}\n                            }\n                        ) if exists $h->{qgaps};\n                        $self->element(\n                            { 'Name' => 'Hsp_hitgaps', 'Data' => $h->{lgaps} } )\n                          if exists $h->{lgaps};\n\n                        if ( $self->{'_reporttype'} =~ m/^FAST[NXY]$/o ) {\n                            if ( 8 == scalar grep { exists $h->{$_} }\n                                qw(an0 ax0 pn0 px0 an1 ax1 pn1 px1) )\n                            {\n                                if ( $h->{ax0} < $h->{an0} ) {\n                                    $self->element(\n                                        {\n                                            'Name' => 'Hsp_query-frame',\n                                            'Data' => \"-@{[(($h->{px0} - $h->{ax0}) % 3) + 1]}\"\n                                        }\n                                    );\n                                }\n                                else {\n                                    $self->element(\n                                        {\n                                            'Name' => 'Hsp_query-frame',\n                                            'Data' => \"+@{[(($h->{an0} - $h->{pn0}) % 3) + 1]}\"\n                                        }\n                                    );\n                                }\n                                if ( $h->{ax1} < $h->{an1} ) {\n                                    $self->element(\n                                        {\n                                            'Name' => 'Hsp_hit-frame',\n                                            'Data' => \"-@{[(($h->{px1} - $h->{ax1}) % 3) + 1]}\"\n                                        }\n                                    );\n                                }\n                                else {\n                                    $self->element(\n                                        {\n                                            'Name' => 'Hsp_hit-frame',\n                                            'Data' => \"+@{[(($h->{an1} - $h->{pn1}) % 3) + 1]}\"\n                                        }\n                                    );\n                                }\n                            }\n                            else {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_query-frame',\n                                        'Data' => $h->{lframe}\n                                    }\n                                );\n                                $self->element(\n                                    { 'Name' => 'Hsp_hit-frame', 'Data' => 0 }\n                                );\n                            }\n                        }\n                        else {\n                            $self->element(\n                                { 'Name' => 'Hsp_query-frame', 'Data' => 0 } );\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_hit-frame',\n                                    'Data' => $h->{lframe}\n                                }\n                            );\n                        }\n\n                        $self->end_element( { 'Name' => 'Hsp' } );\n                        $self->end_element( { 'Name' => 'Hit' } );\n                    }\n                }\n                $self->end_element( { 'Name' => 'FastaOutput' } );\n                $self->_pushback($_);\n                return $self->end_document();\n            }\n            else {\n                $self->start_element( { 'Name' => 'FastaOutput' } );\n                $self->{'_result_count'}++;\n                $seentop = 1;\n                $self->element(\n                    {\n                        'Name' => 'FastaOutput_program',\n                        'Data' => $self->{'_reporttype'}\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'FastaOutput_version',\n                        'Data' => $self->{'_version'}\n                    }\n                );\n\n                my ( $type, $querylen, $querytype, $querydef );\n\n                if (/^\\s*\\d+\\s*>>>(.*)/) {\n                    $querydef = $1;\n                    if ( $querydef =~ /^(.*?)\\s+(?:\\-\\s+)?(\\d+)\\s+(aa|nt).*$/o )\n                    {\n                        ( $querydef, $querylen, $querytype ) = ( $1, $2, $3 );\n                    }\n                }\n\n                if (   $self->{'_reporttype'}\n                    && $self->{'_reporttype'} eq 'FASTA' )\n                {\n                    if ( $querytype eq 'nt' ) {\n                        $self->{'_reporttype'} = 'FASTN';\n                    }\n                    elsif ( $querytype eq 'aa' ) {\n                        $self->{'_reporttype'} = 'FASTP';\n                    }\n                }\n                my ( $name, $descr ) =\n                  ( $querydef =~ m/^(\\S+)(?:\\s+(.*))?\\s*$/o );\n                $self->element(\n                    {\n                        'Name' => 'FastaOutput_query-def',\n                        'Data' => $name\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'FastaOutput_querydesc',\n                        'Data' => $descr\n                    }\n                );\n                if ($querylen) {\n                    $self->element(\n                        {\n                            'Name' => 'FastaOutput_query-len',\n                            'Data' => $querylen\n                        }\n                    );\n                }\n                else {\n                    $self->warn(\"unable to find and set query length\");\n                }\n                if ( defined( $_ = $self->_readline() )\n                    && ( /^\\s*vs\\s+(\\S+)/ || /^Library:\\s+(\\S+)/ ) )\n                {\n                    $self->element(\n                        {\n                            'Name' => 'FastaOutput_db',\n                            'Data' => $1\n                        }\n                    );\n                }\n\n            }\n        }\n        elsif ( $self->in_element('hsp') ) {\n            my @data  = ( [], [], [] );\n            my $count = 0;\n            my $len   = $self->idlength + 1;\n            my ($seq1_id);\n            while ( defined($_) ) {\n                chomp;\n                #$self->debug(\"$count $_\\n\");\n                if (/residues in \\d+\\s+query\\s+sequences/o) {\n                    $self->_pushback($_);\n                    last;\n                }\n                elsif (/^>>>\\*\\*\\*/o) {\n                    $self->end_element( { Name => \"Hsp\" } );\n                    last;\n                }\n                elsif (/^>>/o) {\n                    $self->_pushback($_);\n                    last;\n                }\n                elsif (/^\\s*\\d+\\s*>>>/o) {\n                    $self->_pushback($_);\n                    last;\n                }\n                if ( $count == 0 ) {\n                    if (/^(\\S+)\\s+/) {\n                        $self->_pushback($_);\n                        $count = 2;\n                    }\n                    elsif ( /^\\s+\\d+/ || /^\\s+$/ ) {\n\n                        # do nothing, this is really a 0 line\n                    }\n                    elsif ( length($_) == 0 ) {\n                        $count = -1;\n                    }\n                    else {\n                        $self->_pushback($_);\n                        $count = 0;\n                    }\n                }\n                elsif ( $count == 1 || $count == 3 ) {\n                    if (/^(\\S+)\\s+/) {\n                        $len = CORE::length($1) if $len < CORE::length($1);\n                        s/\\s+$//;    # trim trailing spaces,we don't want them\n                        push @{ $data[ $count - 1 ] }, substr( $_, $len );\n                    }\n                    elsif (/^\\s+(\\d+)/) {\n                        $count = -1;\n                        $self->_pushback($_);\n                    }\n                    elsif ( /^\\s+$/ || length($_) == 0 ) {\n                        $count = 5;\n\n                        # going to skip these\n                    }\n                    else {\n                        $self->throw(\n                            \"Unrecognized alignment line ($count) '$_'\");\n                    }\n                }\n                elsif ( $count == 2 ) {\n                    if (/^\\s+\\d+\\s+/) {\n                        $self->warn(\"$_\\n\") if $self->verbose > 0;\n\n                        # we are on a Subject part of the alignment\n                        # but we THOUGHT we were on the Query\n                        # move that last line to the proper place\n                        push @{ $data[2] }, pop @{ $data[0] };\n                        $count = 4;\n                    }\n                    else {\n\n                        # toss the first IDLENGTH characters of the line\n                        if ( length($_) >= $len ) {\n                            push @{ $data[ $count - 1 ] }, substr( $_, $len );\n                        }\n                    }\n                }\n                last if ( $count++ >= 5 );\n                $_ = $self->_readline();\n            }\n            if ( @{ $data[0] } || @{ $data[2] } ) {\n                $self->characters(\n                    {\n                        'Name' => 'Hsp_qseq',\n                        'Data' => join( '', @{ $data[0] } )\n                    }\n                );\n                $self->characters(\n                    {\n                        'Name' => 'Hsp_midline',\n                        'Data' => join( '', @{ $data[1] } )\n                    }\n                );\n                $self->characters(\n                    {\n                        'Name' => 'Hsp_hseq',\n                        'Data' => join( '', @{ $data[2] } )\n                    }\n                );\n            }\n        }\n        else {\n            if ( !$seentop ) {\n                $self->debug($_);\n                #$self->warn(\"unrecognized FASTA Family report file!\");\n                #return;\n            }\n        }\n    }\n    if ( $self->in_element('result') ) {\n        if ( $self->in_element('hsp') ) {\n            $self->end_element( { 'Name' => 'Hsp' } );\n        }\n        if ( $self->in_element('hit') ) {\n            $self->end_element( { 'Name' => 'Hit' } );\n        }\n        $self->end_element( { 'Name' => 'FastaOutput' } );\n    }\n    return $self->end_document();\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element {\n    my ( $self, $data ) = @_;\n\n    # we currently don't care about attributes\n    my $nm = $data->{'Name'};\n    if ( my $type = $MODEMAP{$nm} ) {\n        $self->_mode($type);\n        if ( my $handler = $self->_will_handle($type) ) {\n            my $func = sprintf( \"start_%s\", lc $type );\n            $handler->$func( $data->{'Attributes'} );\n        }\n        unshift @{ $self->{'_elements'} }, $type;\n    }\n    if ( $nm eq 'FastaOutput' ) {\n        $self->{'_values'} = {};\n        $self->{'_result'} = undef;\n        $self->{'_mode'}   = '';\n    }\n\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ( $self, $data ) = @_;\n    my $nm = $data->{'Name'};\n    my $rc;\n\n    # Hsp are sort of weird, in that they end when another\n    # object begins so have to detect this in end_element for now\n    if ( $nm eq 'Hsp' ) {\n        foreach (qw(Hsp_qseq Hsp_midline Hsp_hseq)) {\n            $self->element(\n                {\n                    'Name' => $_,\n                    'Data' => $self->{'_last_hspdata'}->{$_}\n                }\n            );\n        }\n        $self->{'_last_hspdata'} = {};\n    }\n\n    if ( my $type = $MODEMAP{$nm} ) {\n        if ( my $handler = $self->_will_handle($type) ) {\n            my $func = sprintf( \"end_%s\", lc $type );\n            $rc = $handler->$func( $self->{'_reporttype'}, $self->{'_values'} );\n        }\n        shift @{ $self->{'_elements'} };\n\n    }\n    elsif ( $MAPPING{$nm} ) {\n        if ( ref( $MAPPING{$nm} ) =~ /hash/i ) {\n            my $key = ( keys %{ $MAPPING{$nm} } )[0];\n            $self->{'_values'}->{$key}->{ $MAPPING{$nm}->{$key} } =\n              $self->{'_last_data'};\n        }\n        else {\n            $self->{'_values'}->{ $MAPPING{$nm} } = $self->{'_last_data'};\n        }\n    }\n    else {\n        $self->warn(\"unknown nm $nm, ignoring\\n\");\n    }\n    $self->{'_last_data'} = '';    # remove read data if we are at\n                                   # end of an element\n    $self->{'_result'} = $rc if ( $nm eq 'FastaOutput' );\n    return $rc;\n\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element {\n    my ( $self, $data ) = @_;\n    $self->start_element($data);\n    $self->characters($data);\n    $self->end_element($data);\n}\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string\n\n\n\nsub characters {\n    my ( $self, $data ) = @_;\n\n    return unless ( defined $data->{'Data'} );\n    if ( $data->{'Data'} =~ /^\\s+$/ ) {\n        return unless $data->{'Name'} =~ /Hsp\\_(midline|qseq|hseq)/;\n    }\n\n    if (   $self->in_element('hsp')\n        && $data->{'Name'} =~ /Hsp\\_(qseq|hseq|midline)/ )\n    {\n\n        $self->{'_last_hspdata'}->{ $data->{'Name'} } .= $data->{'Data'};\n    }\n\n    $self->{'_last_data'} = $data->{'Data'};\n}\n\n=head2 _mode\n\n Title   : _mode\n Usage   : $obj->_mode($newval)\n Function: \n Example : \n Returns : value of _mode\n Args    : newvalue (optional)","parameters":[{"label":"$self"},{"label":"$value"}],"label":"_mode($self,$value)"},"detail":"($self,$value)","name":"_mode","range":{"end":{"character":9999,"line":1553},"start":{"character":0,"line":1547}}},{"line":1568,"children":[{"kind":13,"line":1569,"name":"$self","definition":"my","containerName":"within_element","localvar":"my"},{"kind":13,"line":1569,"containerName":"within_element","name":"$name"},{"kind":13,"line":1571,"containerName":"within_element","name":"$name"},{"kind":13,"line":1571,"containerName":"within_element","name":"$self"},{"containerName":"within_element","name":"$self","line":1572,"kind":13}],"kind":12,"detail":"($self,$name)","signature":{"parameters":[{"label":"$self"},{"label":"$name"}],"documentation":"1;\n# $Id: fasta.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::fasta\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::fasta - A SearchIO parser for FASTA results\n\n=head1 SYNOPSIS\n\n  # Do not use this object directly, use it through the SearchIO system\n   use Bio::SearchIO;\n   my $searchio = Bio::SearchIO->new(-format => 'fasta',\n                    -file   => 'report.FASTA');\n   while( my $result = $searchio->next_result ) {\n    # ... do what you would normally doi with Bio::SearchIO.\n   }\n\n=head1 DESCRIPTION\n\nThis object contains the event based parsing code for FASTA format\nreports.  It creates L<Bio::Search::HSP::FastaHSP> objects instead of\nL<Bio::Search::HSP::GenericHSP> for the HSP objects. \n\nThis module will parse -m 9 -d 0 output as well as default m 1 output\nfrom FASTA as well as SSEARCH.\n\nAlso see the SearchIO HOWTO:\nL<http://bioperl.open-bio.org/wiki/HOWTO:SearchIO>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich, Aaron Mackey\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::fasta;\nuse vars qw(%MODEMAP %MAPPING $IDLENGTH);\nuse strict;\n\n# Object preamble - inherits from Bio::Root::RootI\n\nuse Bio::Factory::ObjectFactory;\n\nBEGIN {\n\n    # Set IDLENGTH to a new value if you have\n    # compile FASTA with a different ID length\n    # (actually newest FASTA allows the setting of this\n    #  via -C parameter, default is 6)\n    $IDLENGTH = 6;\n\n    # mapping of NCBI Blast terms to Bioperl hash keys\n    %MODEMAP = (\n        'FastaOutput' => 'result',\n        'Hit'         => 'hit',\n        'Hsp'         => 'hsp'\n    );\n\n    # This should really be done more intelligently, like with\n    # XSLT\n\n    %MAPPING = (\n        'Hsp_bit-score'   => 'HSP-bits',\n        'Hsp_score'       => 'HSP-score',\n        'Hsp_sw-score'    => 'HSP-swscore',\n        'Hsp_evalue'      => 'HSP-evalue',\n        'Hsp_query-from'  => 'HSP-query_start',\n        'Hsp_query-to'    => 'HSP-query_end',\n        'Hsp_hit-from'    => 'HSP-hit_start',\n        'Hsp_hit-to'      => 'HSP-hit_end',\n        'Hsp_positive'    => 'HSP-conserved',\n        'Hsp_identity'    => 'HSP-identical',\n        'Hsp_gaps'        => 'HSP-hsp_gaps',\n        'Hsp_hitgaps'     => 'HSP-hit_gaps',\n        'Hsp_querygaps'   => 'HSP-query_gaps',\n        'Hsp_qseq'        => 'HSP-query_seq',\n        'Hsp_hseq'        => 'HSP-hit_seq',\n        'Hsp_midline'     => 'HSP-homology_seq',\n        'Hsp_align-len'   => 'HSP-hsp_length',\n        'Hsp_query-frame' => 'HSP-query_frame',\n        'Hsp_hit-frame'   => 'HSP-hit_frame',\n\n        'Hit_id'        => 'HIT-name',\n        'Hit_len'       => 'HIT-length',\n        'Hit_accession' => 'HIT-accession',\n        'Hit_def'       => 'HIT-description',\n        'Hit_signif'    => 'HIT-significance',\n        'Hit_score'     => 'HIT-score',\n\n        'FastaOutput_program'   => 'RESULT-algorithm_name',\n        'FastaOutput_version'   => 'RESULT-algorithm_version',\n        'FastaOutput_query-def' => 'RESULT-query_name',\n        'FastaOutput_querydesc' => 'RESULT-query_description',\n        'FastaOutput_query-len' => 'RESULT-query_length',\n        'FastaOutput_db'        => 'RESULT-database_name',\n        'FastaOutput_db-len'    => 'RESULT-database_entries',\n        'FastaOutput_db-let'    => 'RESULT-database_letters',\n\n        'Parameters_matrix'      => { 'RESULT-parameters' => 'matrix' },\n        'Parameters_expect'      => { 'RESULT-parameters' => 'expect' },\n        'Parameters_include'     => { 'RESULT-parameters' => 'include' },\n        'Parameters_sc-match'    => { 'RESULT-parameters' => 'match' },\n        'Parameters_sc-mismatch' => { 'RESULT-parameters' => 'mismatch' },\n        'Parameters_gap-open'    => { 'RESULT-parameters' => 'gapopen' },\n        'Parameters_gap-ext'     => { 'RESULT-parameters' => 'gapext' },\n        'Parameters_word-size'   => { 'RESULT-parameters' => 'wordsize' },\n        'Parameters_ktup'        => { 'RESULT-parameters' => 'ktup' },\n        'Parameters_filter'      => { 'RESULT-parameters' => 'filter' },\n        'Statistics_db-num'      => { 'RESULT-statistics' => 'dbentries' },\n        'Statistics_db-len'      => { 'RESULT-statistics' => 'dbletters' },\n        'Statistics_hsp-len'     => { 'RESULT-statistics' => 'hsplength' },\n        'Statistics_eff-space'   => { 'RESULT-statistics' => 'effectivespace' },\n        'Statistics_kappa'       => { 'RESULT-statistics' => 'kappa' },\n        'Statistics_lambda'      => { 'RESULT-statistics' => 'lambda' },\n        'Statistics_entropy'     => { 'RESULT-statistics' => 'entropy' },\n    );\n}\n\nuse base qw(Bio::SearchIO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::fasta->new();\n Function: Builds a new Bio::SearchIO::fasta object \n Returns : Bio::SearchIO::fasta\n Args    : -idlength - set ID length to something other \n                       than the default (7), this is only\n                       necessary if you have compiled FASTA\n                       with a new default id length to display\n                       in the HSP alignment blocks\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n    return unless @args;\n    my ($idlength) = $self->_rearrange( [qw(IDLENGTH)], @args );\n    $self->idlength( $idlength || $IDLENGTH );\n    $self->_eventHandler->register_factory(\n        'hsp',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::HSP::FastaHSP',\n            -interface => 'Bio::Search::HSP::HSPI'\n        )\n    );\n    return 1;\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    local $/ = \"\\n\";\n    local $_;\n\n    my $data    = '';\n    my $seentop = 0;\n    my $current_hsp;\n    $self->start_document();\n    my @hit_signifs;\n    while ( defined( $_ = $self->_readline ) ) {\n        next if ( !$self->in_element('hsp')\n            && /^\\s+$/ );    # skip empty lines\n        if (\n               m/(\\S+)\\s+searches\\s+a\\s+(protein\\s+or\\s+DNA\\s+)?sequence/oxi\n            || /(\\S+)\\s+compares\\s+a/\n            || (   m/^\\#\\s+/\n                && ( $_ = $self->_readline )\n                && /(\\S+)\\s+searches\\s+a\\s+(protein\\s+or\\s+DNA\\s+)?sequence/oxi\n                || /(\\S+)\\s+compares\\s+a/ )\n          )\n        {\n            if ($seentop) {\n                $self->_pushback($_);\n                $self->end_element( { 'Name' => 'FastaOutput' } );\n                return $self->end_document();\n            }\n            $self->{'_reporttype'} = $1;\n            $self->start_element( { 'Name' => 'FastaOutput' } );\n            $self->{'_result_count'}++;\n            $seentop = 1;\n            #$self->debug( \"reporttype is \" . $self->{'_reporttype'} . \"\\n\" );\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_program',\n                    'Data' => $self->{'_reporttype'}\n                }\n            );\n            $_ = $self->_readline();\n            my ($version) = (/version\\s+(\\S+)/);\n            $version = '' unless defined $version;\n            $self->{'_version'} = $version;\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_version',\n                    'Data' => $version\n                }\n            );\n\n            my ( $last, $leadin, $type, $querylen, $querytype, $querydef );\n\n            while ( defined( $_ = $self->_readline() ) ) {\n                if (\n                    /^ (\n                       (?:\\s+>) |             # fa33 lead-in\n                       (?:\\s*\\d+\\s*>>>)       # fa34 mlib lead-in\n                      )\n                      (.*)\n                   /x\n                  )\n                {\n                    ( $leadin, $querydef ) = ( $1, $2 );\n                    if ( $leadin =~ m/>>>/ ) {\n                        if ( $querydef =~\n                            /^(.*?)\\s+(?:\\-\\s+)?(\\d+)\\s+(aa|nt).*$/o )\n                        {\n                            ( $querydef, $querylen, $querytype ) =\n                              ( $1, $2, $3 );\n                            last;\n                        }\n                    }\n                    else {\n                        if ( $last =~ /(\\S+)[:,]\\s*(\\d+)\\s+(aa|nt)/ ) {\n                            ( $querylen, $querytype ) = ( $2, $3 );\n                            $querydef ||= $1;\n                            last;\n                        }\n                    }\n                }\n                elsif (m/^\\s*vs\\s+\\S+/o) {\n                    if ( $last =~ /(\\S+)[,:]\\s+(\\d+)\\s+(aa|nt)/o ) {\n                        ( $querydef, $querylen, $querytype ) = ( $1, $2, $3 );\n                        last;\n                    }\n                }\n                $last = $_;\n            }\n            if (   $self->{'_reporttype'}\n                && $self->{'_reporttype'} eq 'FASTA' )\n            {\n                if ( $querytype eq 'nt' ) {\n                    $self->{'_reporttype'} = 'FASTN';\n                }\n                elsif ( $querytype eq 'aa' ) {\n                    $self->{'_reporttype'} = 'FASTP';\n                }\n            }\n            my ( $name, $descr ) = $querydef =~ m/^(\\S+)\\s*(.*?)\\s*$/o;\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_query-def',\n                    'Data' => $name\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_querydesc',\n                    'Data' => $descr\n                }\n            );\n            if ($querylen) {\n                $self->element(\n                    {\n                        'Name' => 'FastaOutput_query-len',\n                        'Data' => $querylen\n                    }\n                );\n            }\n            else {\n                $self->warn(\"unable to find and set query length\");\n            }\n            if (\n                   $last =~ /^\\s*vs\\s+(\\S+)/\n                || ( $last =~ /^searching\\s+(\\S+)\\s+library/ )\n                || ( $last =~ /^Library:\\s+(\\S+)\\s+/ )\n                || (\n                    defined $_\n                    && (   /^\\s*vs\\s+(\\S+)/\n                        || /^Library:\\s+(\\S+)\\s+/ )\n                )\n                || ( defined( $_ = $self->_readline() )\n                    && ( /^\\s*vs\\s+(\\S+)/ || /^Library:\\s+(\\S+)/ ) )\n              )\n            {\n                $self->element(\n                    {\n                        'Name' => 'FastaOutput_db',\n                        'Data' => $1\n                    }\n                );\n            }\n            elsif (m/^\\s+opt(?:\\s+E\\(\\))?$/o) {\n\n           # histogram ... read over it more rapidly than the larger outer loop:\n                while ( defined( $_ = $self->_readline ) ) {\n                    last if m/^>\\d+/;\n                }\n            }\n        }\n        elsif (/(\\d+)\\s+residues\\s+in\\s+(\\d+)\\s+(?:library\\s+)?sequences/) {\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_db-let',\n                    'Data' => $1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_db-len',\n                    'Data' => $2\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Statistics_db-len',\n                    'Data' => $1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Statistics_db-num',\n                    'Data' => $2\n                }\n            );\n        }\n        elsif (/Lambda=\\s*(\\S+)/) {\n            $self->element(\n                {\n                    'Name' => 'Statistics_lambda',\n                    'Data' => $1\n                }\n            );\n        }\n        elsif (/K=\\s*(\\S+)/) {\n            $self->element(\n                {\n                    'Name' => 'Statistics_kappa',\n                    'Data' => $1\n                }\n            );\n        }\n        elsif (/^\\s*(Smith-Waterman).+(\\S+)\\s*matrix [^\\]]*?(xS)?\\]/) {\n            $self->element(\n                {\n                    'Name' => 'Parameters_matrix',\n                    'Data' => $2\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_filter',\n                    'Data' => defined $3 ? 1 : 0,\n                }\n            );\n            $self->{'_reporttype'} = $1;\n\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_program',\n                    'Data' => $self->{'_reporttype'}\n                }\n            );\n        }\n        elsif (/The best( related| unrelated)? scores are:/) {\n            my $rel    = $1;\n            my @labels = split;\n            @labels = map {\n                if ( $_ =~ m/^E\\((\\d+)\\)$/o )\n                {\n                    $self->element(\n                        { 'Name' => 'Statistics_eff-space', 'Data' => $1 } );\n                    \"evalue\";\n                }\n                else {\n                    $_;\n                }\n            } @labels[ $rel ? 5 : 4 .. $#labels ];\n\n            while ( defined( $_ = $self->_readline() )\n                && !/^\\s+$/ )\n            {\n                my @line = split;\n\n                if ( $line[-1] =~ m/\\=/o && $labels[-1] eq 'fs' ) {\n\n                    # unlabelled alignment hit;\n                    push @labels, \"aln_code\";\n                }\n\n                my %data;\n                @data{@labels} = splice( @line, @line - @labels );\n                if ( $line[-1] =~ m/\\[([1-6rf])\\]/o ) {\n                    my $fr = $1;\n                    $data{lframe} = (\n                        $fr =~ /\\d/o\n                        ? ( $fr <= 3 ? \"+$fr\" : \"-@{[$fr-3]}\" )\n                        : ( $fr eq 'f' ? '+1' : '-1' )\n                    );\n                    pop @line;\n                }\n                else {\n                    $data{lframe} = '0';\n                }\n\n                if ( $line[-1] =~ m/^\\(?(\\d+)\\)$/ ) {\n                    $data{hit_len} = $1;\n                    pop @line;\n                    if ( $line[-1] =~ m/^\\($/ ) {\n                        pop @line;\n                    }\n                }\n                else {\n                    $data{hit_len} = 0;\n                }\n\n                # rebuild the first part of the line, preserving spaces:\n                ($_) = m/^(\\S+(?:\\s+\\S+){$#line})/;\n\n                my ( $id, $desc ) = split( /\\s+/, $_, 2 );\n                my @pieces = split( /\\|/, $id );\n                my $acc = pop @pieces;\n                $acc =~ s/\\.\\d+$//;\n\n                @data{qw(id desc acc)} = ( $id, $desc, $acc );\n\n                push @hit_signifs, \\%data;\n            }\n        }\n        elsif (\n/^\\s*([T]?FAST[XYAF]).+,\\s*(\\S+)\\s*matrix[^\\]]+?(xS)?\\]\\s*ktup:\\s*(\\d+)/\n          )\n        {\n\n            $self->element(\n                {\n                    'Name' => 'Parameters_matrix',\n                    'Data' => $2\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_filter',\n                    'Data' => defined $3 ? 1 : 0,\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_ktup',\n                    'Data' => $4\n                }\n            );\n            $self->{'_reporttype'} = $1\n              if ( $self->{'_reporttype'} !~ /FAST[PN]/i );\n\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_program',\n                    'Data' => $self->{'_reporttype'}\n                }\n            );\n        }\n        elsif (/^Algorithm:\\s+(\\S+)\\s+\\(([^)]+)\\)\\s+(\\S+)/) {\n            $self->{'_reporttype'} = $1\n              if ( $self->{'_reporttype'} !~ /FAST[PN]/i );\n        }\n        elsif (\n            /^Parameters:\\s+(\\S+)\\s*matrix\\s*(?:\\(([^(]+?)\\))?\\s*ktup:\\s*(\\d+)/)\n        {    # FASTA 35.04\n            $self->element(\n                {\n                    'Name' => 'Parameters_matrix',\n                    'Data' => $1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_filter',\n                    'Data' => defined $2 ? $2 : 0,\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_ktup',\n                    'Data' => $3\n                }\n            );\n        }\n        elsif (\n/(?:gap\\-pen|open\\/ext):\\s+([\\-\\+]?\\d+)\\s*\\/\\s*([\\-\\+]?\\d+).+width:\\s+(\\d+)/\n          )\n        {\n            $self->element(\n                {\n                    'Name' => 'Parameters_gap-open',\n                    'Data' => $1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_gap-ext',\n                    'Data' => $2\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_word-size',\n                    'Data' => $3\n                }\n            );\n        }\n        elsif (/^>>(?!>)(.+?)\\s+(?:\\((\\d+)\\s*(aa|nt)\\))?$/) {\n            my ($hit_id, $len, $alphabet) = ($1, $2, $3);\n            if (!$len || !$alphabet) {\n                WRAPPED:\n                while (defined($_ = $self->_readline)) {\n                    if (/(.*?)\\s+\\((\\d+)\\s*(aa|nt)\\)/) {\n                        ($len, $alphabet) = ($2, $3);\n                        $hit_id .= $1 ? \" \".$1 : '';\n                        last WRAPPED;\n                    }\n                    if (/^>>(?!>)/) { # too far, throw\n                        $self->throw(\"Couldn't find length, bailing\");\n                    }\n                }\n            }\n            if ( $self->in_element('hsp') ) {\n                $self->end_element( { 'Name' => 'Hsp' } );\n            }\n            if ( $self->in_element('hit') ) {\n                $self->end_element( { 'Name' => 'Hit' } );\n            }\n\n            $self->start_element( { 'Name' => 'Hit' } );\n            $self->element(\n                {\n                    'Name' => 'Hit_len',\n                    'Data' => $len\n                }\n            );\n            my ( $id, $desc ) = split( /\\s+/, $hit_id, 2 );\n            $self->element(\n                {\n                    'Name' => 'Hit_id',\n                    'Data' => $id\n                }\n            );\n\n            #$self->debug(\"Hit ID is $id\\n\");\n            my @pieces = split( /\\|/, $id );\n            my $acc = pop @pieces;\n            $acc =~ s/\\.\\d+$//;\n            $self->element(\n                {\n                    'Name' => 'Hit_accession',\n                    'Data' => $acc\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hit_def',\n                    'Data' => $desc\n                }\n            );\n\n            $_ = $self->_readline();\n            my ( $score, $bits, $e ) = /Z-score: \\s* (\\S+) \\s*\n                               (?: bits: \\s* (\\S+) \\s+ )?\n                               (?: E|expect ) \\s* \\(\\) :? \\s*(\\S+)/ox;\n            $bits = $score unless defined $bits;\n\n            my $v = shift @hit_signifs;\n            if ( defined $v ) {\n                @{$v}{qw(evalue bits z-sc)} = ( $e, $bits, $score );\n            }\n            $self->element(\n                {\n                    'Name' => 'Hit_signif',\n                    'Data' => $v ? $v->{evalue} : $e\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hit_score',\n                    'Data' => $v ? $v->{bits} : $bits\n                }\n            );\n            $self->start_element( { 'Name' => 'Hsp' } );\n\n            $self->element(\n                {\n                    'Name' => 'Hsp_score',\n                    'Data' => $v ? $v->{'z-sc'} : $score\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_evalue',\n                    'Data' => $v ? $v->{evalue} : $e\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_bit-score',\n                    'Data' => $v ? $v->{bits} : $bits\n                }\n            );\n            $_ = $self->_readline();\n\n            if (s/Smith-Waterman score:\\s*(\\d+)\\;?//) {\n                $self->element(\n                    {\n                        'Name' => 'Hsp_sw-score',\n                        'Data' => $1\n                    }\n                );\n            }\n            if (\n                / (\\d*\\.?\\d+)\\% \\s* identity\n                 (?:\\s* \\(\\s*(\\S+)\\% \\s* (?:ungapped|similar) \\) )?\n                 \\s* in \\s* (\\d+) \\s+ (?:aa|nt) \\s+ overlap \\s*\n                 \\( (\\d+) \\- (\\d+) : (\\d+) \\- (\\d+) \\)\n               /x\n              )\n            {\n                my ( $identper, $gapper, $len, $querystart, $queryend,\n                    $hitstart, $hitend )\n                  = ( $1, $2, $3, $4, $5, $6, $7 );\n                my $ident = sprintf( \"%.0f\", ( $identper / 100 ) * $len );\n                my $positive = sprintf( \"%.0f\", ( $gapper / 100 ) * $len );\n\n                $self->element(\n                    {\n                        'Name' => 'Hsp_identity',\n                        'Data' => $ident\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'Hsp_positive',\n                        'Data' => $positive\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'Hsp_align-len',\n                        'Data' => $len\n                    }\n                );\n\n                $self->element(\n                    {\n                        'Name' => 'Hsp_query-from',\n                        'Data' => $querystart\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'Hsp_query-to',\n                        'Data' => $queryend\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'Hsp_hit-from',\n                        'Data' => $hitstart\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'Hsp_hit-to',\n                        'Data' => $hitend\n                    }\n                );\n\n            }\n\n            if ($v) {\n                $self->element(\n                    { 'Name' => 'Hsp_querygaps', 'Data' => $v->{qgaps} } )\n                  if exists $v->{qgaps};\n                $self->element(\n                    { 'Name' => 'Hsp_hitgaps', 'Data' => $v->{lgaps} } )\n                  if exists $v->{lgaps};\n\n                if ( $self->{'_reporttype'} =~ m/^FAST[NXY]$/o ) {\n                    if ( 8 == scalar grep { exists $v->{$_} }\n                        qw(an0 ax0 pn0 px0 an1 ax1 pn1 px1) )\n                    {\n                        if ( $v->{ax0} < $v->{an0} ) {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_query-frame',\n                                    'Data' =>\n                                      \"-@{[(($v->{px0} - $v->{ax0}) % 3) + 1]}\"\n                                }\n                            );\n                        }\n                        else {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_query-frame',\n                                    'Data' =>\n                                      \"+@{[(($v->{an0} - $v->{pn0}) % 3) + 1]}\"\n                                }\n                            );\n                        }\n                        if ( $v->{ax1} < $v->{an1} ) {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_hit-frame',\n                                    'Data' =>\n                                      \"-@{[(($v->{px1} - $v->{ax1}) % 3) + 1]}\"\n                                }\n                            );\n                        }\n                        else {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_hit-frame',\n                                    'Data' =>\n                                      \"+@{[(($v->{an1} - $v->{pn1}) % 3) + 1]}\"\n                                }\n                            );\n                        }\n                    }\n                    else {\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_query-frame',\n                                'Data' => $v->{lframe}\n                            }\n                        );\n                        $self->element(\n                            { 'Name' => 'Hsp_hit-frame', 'Data' => 0 } );\n                    }\n                }\n                else {\n                    $self->element(\n                        { 'Name' => 'Hsp_query-frame', 'Data' => 0 } );\n                    $self->element(\n                        { 'Name' => 'Hsp_hit-frame', 'Data' => $v->{lframe} } );\n                }\n\n            }\n            else {\n                $self->warn(\"unable to parse FASTA score line: $_\");\n            }\n        }\n        elsif (/\\d+\\s*residues\\s*in\\s*\\d+\\s*query\\s*sequences/) {\n            if ( $self->in_element('hsp') ) {\n                $self->end_element( { 'Name' => 'Hsp' } );\n            }\n            if ( $self->in_element('hit') ) {\n                $self->end_element( { 'Name' => 'Hit' } );\n            }\n\n           #       $_ = $self->_readline();\n           #       my ( $liblen,$libsize) = /(\\d+)\\s+residues\\s*in(\\d+)\\s*library/;\n           # fast forward to the end of the file as there is\n           # nothing else left to do with this file and want to be sure and\n           # reset it\n            while ( defined( $_ = $self->_readline() ) ) {\n                last if (/^Function used was/);\n                if (\n                    /(\\S+)\\s+searches\\s+a\\s+(protein\\s+or\\s+DNA\\s+)?\n           sequence/oxi || /(\\S+)\\s+compares\\s+a/oi\n                  )\n                {\n                    $self->_pushback($_);\n                }\n            }\n\n            if (@hit_signifs) {\n\n                # process remaining best hits\n                for my $h (@hit_signifs) {\n\n                    # Hsp_score Hsp_evalue Hsp_bit-score\n                    # Hsp_sw-score Hsp_gaps Hsp_identity Hsp_positive\n                    # Hsp_align-len Hsp_query-from Hsp_query-to\n                    # Hsp_hit-from Hsp_hit-to Hsp_qseq Hsp_midline\n\n                    $self->start_element( { 'Name' => 'Hit' } );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_len',\n                            'Data' => $h->{hit_len}\n                        }\n                    ) if exists $h->{hit_len};\n                    $self->element(\n                        {\n                            'Name' => 'Hit_id',\n                            'Data' => $h->{id}\n                        }\n                    ) if exists $h->{id};\n                    $self->element(\n                        {\n                            'Name' => 'Hit_accession',\n                            'Data' => $h->{acc}\n                        }\n                    ) if exists $h->{acc};\n                    $self->element(\n                        {\n                            'Name' => 'Hit_def',\n                            'Data' => $h->{desc}\n                        }\n                    ) if exists $h->{desc};\n                    $self->element(\n                        {\n                            'Name' => 'Hit_signif',\n                            'Data' => $h->{evalue}\n                        }\n                    ) if exists $h->{evalue};\n                    $self->element(\n                        {\n                            'Name' => 'Hit_score',\n                            'Data' => $h->{bits}\n                        }\n                    ) if exists $h->{bits};\n\n                    $self->start_element( { 'Name' => 'Hsp' } );\n                    $self->element(\n                        { 'Name' => 'Hsp_score', 'Data' => $h->{'z-sc'} } )\n                      if exists $h->{'z-sc'};\n                    $self->element(\n                        { 'Name' => 'Hsp_evalue', 'Data' => $h->{evalue} } )\n                      if exists $h->{evalue};\n                    $self->element(\n                        { 'Name' => 'Hsp_bit-score', 'Data' => $h->{bits} } )\n                      if exists $h->{bits};\n                    $self->element(\n                        { 'Name' => 'Hsp_sw-score', 'Data' => $h->{sw} } )\n                      if exists $h->{sw};\n                    $self->element(\n                        { 'Name' => 'Hsp_gaps', 'Data' => $h->{'%_gid'} } )\n                      if exists $h->{'%_gid'};\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_identity',\n                            'Data' =>\n                              sprintf( \"%.0f\", $h->{'%_id'} * $h->{alen} )\n                        }\n                    ) if ( exists $h->{'%_id'} && exists $h->{alen} );\n\n                    if ( exists $h->{'%_gid'} ) {\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_positive',\n                                'Data' =>\n                                  sprintf( \"%.0f\", $h->{'%_gid'} * $h->{alen} )\n                            }\n                        ) if exists $h->{'%_gid'} && exists $h->{alen};\n                    }\n                    else {\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_positive',\n                                'Data' =>\n                                  sprintf( \"%.0f\", $h->{'%_id'} * $h->{alen} )\n                            }\n                        ) if ( exists $h->{'%_id'} && exists $h->{alen} );\n                    }\n                    $self->element(\n                        { 'Name' => 'Hsp_align-len', 'Data' => $h->{alen} } )\n                      if exists $h->{alen};\n                    $self->element(\n                        { 'Name' => 'Hsp_query-from', 'Data' => $h->{an0} } )\n                      if exists $h->{an0};\n                    $self->element(\n                        { 'Name' => 'Hsp_query-to', 'Data' => $h->{ax0} } )\n                      if exists $h->{ax0};\n                    $self->element(\n                        { 'Name' => 'Hsp_hit-from', 'Data' => $h->{an1} } )\n                      if exists $h->{an1};\n                    $self->element(\n                        { 'Name' => 'Hsp_hit-to', 'Data' => $h->{ax1} } )\n                      if exists $h->{ax1};\n\n                    $self->element(\n                        { 'Name' => 'Hsp_querygaps', 'Data' => $h->{qgaps} } )\n                      if exists $h->{qgaps};\n                    $self->element(\n                        { 'Name' => 'Hsp_hitgaps', 'Data' => $h->{lgaps} } )\n                      if exists $h->{lgaps};\n\n                    if ( $self->{'_reporttype'} =~ m/^FAST[NXY]$/o ) {\n                        if ( 8 == scalar grep { exists $h->{$_} }\n                            qw(an0 ax0 pn0 px0 an1 ax1 pn1 px1) )\n                        {\n                            if ( $h->{ax0} < $h->{an0} ) {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_query-frame',\n                                        'Data' =>\n\"-@{[(($h->{px0} - $h->{ax0}) % 3) + 1]}\"\n                                    }\n                                );\n                            }\n                            else {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_query-frame',\n                                        'Data' =>\n\"+@{[(($h->{an0} - $h->{pn0}) % 3) + 1]}\"\n                                    }\n                                );\n                            }\n                            if ( $h->{ax1} < $h->{an1} ) {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_hit-frame',\n                                        'Data' =>\n\"-@{[(($h->{px1} - $h->{ax1}) % 3) + 1]}\"\n                                    }\n                                );\n                            }\n                            else {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_hit-frame',\n                                        'Data' =>\n\"+@{[(($h->{an1} - $h->{pn1}) % 3) + 1]}\"\n                                    }\n                                );\n                            }\n                        }\n                        else {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_query-frame',\n                                    'Data' => $h->{lframe}\n                                }\n                            );\n                            $self->element(\n                                { 'Name' => 'Hsp_hit-frame', 'Data' => 0 } );\n                        }\n                    }\n                    else {\n                        $self->element(\n                            { 'Name' => 'Hsp_query-frame', 'Data' => 0 } );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_hit-frame',\n                                'Data' => $h->{lframe}\n                            }\n                        );\n                    }\n\n                    $self->end_element( { 'Name' => 'Hsp' } );\n                    $self->end_element( { 'Name' => 'Hit' } );\n                }\n            }\n            $self->end_element( { 'Name' => 'FastaOutput' } );\n            return $self->end_document();\n        }\n        elsif (/^\\s*\\d+\\s*>>>/) {\n            if ( $self->within_element('FastaOutput') ) {\n                if ( $self->in_element('hsp') ) {\n                    $self->end_element( { 'Name' => 'Hsp' } );\n                }\n                if ( $self->in_element('hit') ) {\n                    $self->end_element( { 'Name' => 'Hit' } );\n                }\n\n                if (@hit_signifs) {\n\n                    # process remaining best hits\n                    for my $h (@hit_signifs) {\n                        $self->start_element( { 'Name' => 'Hit' } );\n                        $self->element(\n                            {\n                                'Name' => 'Hit_len',\n                                'Data' => $h->{hit_len}\n                            }\n                        ) if exists $h->{hit_len};\n                        $self->element(\n                            {\n                                'Name' => 'Hit_id',\n                                'Data' => $h->{id}\n                            }\n                        ) if exists $h->{id};\n                        $self->element(\n                            {\n                                'Name' => 'Hit_accession',\n                                'Data' => $h->{acc}\n                            }\n                        ) if exists $h->{acc};\n                        $self->element(\n                            {\n                                'Name' => 'Hit_def',\n                                'Data' => $h->{desc}\n                            }\n                        ) if exists $h->{desc};\n                        $self->element(\n                            {\n                                'Name' => 'Hit_signif',\n                                'Data' => $h->{evalue}\n                            }\n                        ) if exists $h->{evalue};\n                        $self->element(\n                            {\n                                'Name' => 'Hit_score',\n                                'Data' => $h->{bits}\n                            }\n                        ) if exists $h->{bits};\n\n                        $self->start_element( { 'Name' => 'Hsp' } );\n                        $self->element(\n                            { 'Name' => 'Hsp_score', 'Data' => $h->{'z-sc'} } )\n                          if exists $h->{'z-sc'};\n                        $self->element(\n                            { 'Name' => 'Hsp_evalue', 'Data' => $h->{evalue} } )\n                          if exists $h->{evalue};\n                        $self->element(\n                            { 'Name' => 'Hsp_bit-score', 'Data' => $h->{bits} }\n                        ) if exists $h->{bits};\n                        $self->element(\n                            { 'Name' => 'Hsp_sw-score', 'Data' => $h->{sw} } )\n                          if exists $h->{sw};\n                        $self->element(\n                            { 'Name' => 'Hsp_gaps', 'Data' => $h->{'%_gid'} } )\n                          if exists $h->{'%_gid'};\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_identity',\n                                'Data' =>\n                                  sprintf( \"%.0f\", $h->{'%_id'} * $h->{alen} )\n                            }\n                        ) if ( exists $h->{'%_id'} && exists $h->{alen} );\n\n                        if ( exists $h->{'%_gid'} ) {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_positive',\n                                    'Data' => sprintf( \"%.0f\",\n                                        $h->{'%_gid'} * $h->{alen} )\n                                }\n                            ) if exists $h->{'%_gid'} && exists $h->{alen};\n                        }\n                        else {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_positive',\n                                    'Data' => sprintf( \"%.0f\",\n                                        $h->{'%_id'} * $h->{alen} )\n                                }\n                            ) if ( exists $h->{'%_id'} && exists $h->{alen} );\n                        }\n                        $self->element(\n                            { 'Name' => 'Hsp_align-len', 'Data' => $h->{alen} }\n                        ) if exists $h->{alen};\n                        $self->element(\n                            { 'Name' => 'Hsp_query-from', 'Data' => $h->{an0} }\n                        ) if exists $h->{an0};\n                        $self->element(\n                            { 'Name' => 'Hsp_query-to', 'Data' => $h->{ax0} } )\n                          if exists $h->{ax0};\n                        $self->element(\n                            { 'Name' => 'Hsp_hit-from', 'Data' => $h->{an1} } )\n                          if exists $h->{an1};\n                        $self->element(\n                            { 'Name' => 'Hsp_hit-to', 'Data' => $h->{ax1} } )\n                          if exists $h->{ax1};\n\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_querygaps',\n                                'Data' => $h->{qgaps}\n                            }\n                        ) if exists $h->{qgaps};\n                        $self->element(\n                            { 'Name' => 'Hsp_hitgaps', 'Data' => $h->{lgaps} } )\n                          if exists $h->{lgaps};\n\n                        if ( $self->{'_reporttype'} =~ m/^FAST[NXY]$/o ) {\n                            if ( 8 == scalar grep { exists $h->{$_} }\n                                qw(an0 ax0 pn0 px0 an1 ax1 pn1 px1) )\n                            {\n                                if ( $h->{ax0} < $h->{an0} ) {\n                                    $self->element(\n                                        {\n                                            'Name' => 'Hsp_query-frame',\n                                            'Data' => \"-@{[(($h->{px0} - $h->{ax0}) % 3) + 1]}\"\n                                        }\n                                    );\n                                }\n                                else {\n                                    $self->element(\n                                        {\n                                            'Name' => 'Hsp_query-frame',\n                                            'Data' => \"+@{[(($h->{an0} - $h->{pn0}) % 3) + 1]}\"\n                                        }\n                                    );\n                                }\n                                if ( $h->{ax1} < $h->{an1} ) {\n                                    $self->element(\n                                        {\n                                            'Name' => 'Hsp_hit-frame',\n                                            'Data' => \"-@{[(($h->{px1} - $h->{ax1}) % 3) + 1]}\"\n                                        }\n                                    );\n                                }\n                                else {\n                                    $self->element(\n                                        {\n                                            'Name' => 'Hsp_hit-frame',\n                                            'Data' => \"+@{[(($h->{an1} - $h->{pn1}) % 3) + 1]}\"\n                                        }\n                                    );\n                                }\n                            }\n                            else {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_query-frame',\n                                        'Data' => $h->{lframe}\n                                    }\n                                );\n                                $self->element(\n                                    { 'Name' => 'Hsp_hit-frame', 'Data' => 0 }\n                                );\n                            }\n                        }\n                        else {\n                            $self->element(\n                                { 'Name' => 'Hsp_query-frame', 'Data' => 0 } );\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_hit-frame',\n                                    'Data' => $h->{lframe}\n                                }\n                            );\n                        }\n\n                        $self->end_element( { 'Name' => 'Hsp' } );\n                        $self->end_element( { 'Name' => 'Hit' } );\n                    }\n                }\n                $self->end_element( { 'Name' => 'FastaOutput' } );\n                $self->_pushback($_);\n                return $self->end_document();\n            }\n            else {\n                $self->start_element( { 'Name' => 'FastaOutput' } );\n                $self->{'_result_count'}++;\n                $seentop = 1;\n                $self->element(\n                    {\n                        'Name' => 'FastaOutput_program',\n                        'Data' => $self->{'_reporttype'}\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'FastaOutput_version',\n                        'Data' => $self->{'_version'}\n                    }\n                );\n\n                my ( $type, $querylen, $querytype, $querydef );\n\n                if (/^\\s*\\d+\\s*>>>(.*)/) {\n                    $querydef = $1;\n                    if ( $querydef =~ /^(.*?)\\s+(?:\\-\\s+)?(\\d+)\\s+(aa|nt).*$/o )\n                    {\n                        ( $querydef, $querylen, $querytype ) = ( $1, $2, $3 );\n                    }\n                }\n\n                if (   $self->{'_reporttype'}\n                    && $self->{'_reporttype'} eq 'FASTA' )\n                {\n                    if ( $querytype eq 'nt' ) {\n                        $self->{'_reporttype'} = 'FASTN';\n                    }\n                    elsif ( $querytype eq 'aa' ) {\n                        $self->{'_reporttype'} = 'FASTP';\n                    }\n                }\n                my ( $name, $descr ) =\n                  ( $querydef =~ m/^(\\S+)(?:\\s+(.*))?\\s*$/o );\n                $self->element(\n                    {\n                        'Name' => 'FastaOutput_query-def',\n                        'Data' => $name\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'FastaOutput_querydesc',\n                        'Data' => $descr\n                    }\n                );\n                if ($querylen) {\n                    $self->element(\n                        {\n                            'Name' => 'FastaOutput_query-len',\n                            'Data' => $querylen\n                        }\n                    );\n                }\n                else {\n                    $self->warn(\"unable to find and set query length\");\n                }\n                if ( defined( $_ = $self->_readline() )\n                    && ( /^\\s*vs\\s+(\\S+)/ || /^Library:\\s+(\\S+)/ ) )\n                {\n                    $self->element(\n                        {\n                            'Name' => 'FastaOutput_db',\n                            'Data' => $1\n                        }\n                    );\n                }\n\n            }\n        }\n        elsif ( $self->in_element('hsp') ) {\n            my @data  = ( [], [], [] );\n            my $count = 0;\n            my $len   = $self->idlength + 1;\n            my ($seq1_id);\n            while ( defined($_) ) {\n                chomp;\n                #$self->debug(\"$count $_\\n\");\n                if (/residues in \\d+\\s+query\\s+sequences/o) {\n                    $self->_pushback($_);\n                    last;\n                }\n                elsif (/^>>>\\*\\*\\*/o) {\n                    $self->end_element( { Name => \"Hsp\" } );\n                    last;\n                }\n                elsif (/^>>/o) {\n                    $self->_pushback($_);\n                    last;\n                }\n                elsif (/^\\s*\\d+\\s*>>>/o) {\n                    $self->_pushback($_);\n                    last;\n                }\n                if ( $count == 0 ) {\n                    if (/^(\\S+)\\s+/) {\n                        $self->_pushback($_);\n                        $count = 2;\n                    }\n                    elsif ( /^\\s+\\d+/ || /^\\s+$/ ) {\n\n                        # do nothing, this is really a 0 line\n                    }\n                    elsif ( length($_) == 0 ) {\n                        $count = -1;\n                    }\n                    else {\n                        $self->_pushback($_);\n                        $count = 0;\n                    }\n                }\n                elsif ( $count == 1 || $count == 3 ) {\n                    if (/^(\\S+)\\s+/) {\n                        $len = CORE::length($1) if $len < CORE::length($1);\n                        s/\\s+$//;    # trim trailing spaces,we don't want them\n                        push @{ $data[ $count - 1 ] }, substr( $_, $len );\n                    }\n                    elsif (/^\\s+(\\d+)/) {\n                        $count = -1;\n                        $self->_pushback($_);\n                    }\n                    elsif ( /^\\s+$/ || length($_) == 0 ) {\n                        $count = 5;\n\n                        # going to skip these\n                    }\n                    else {\n                        $self->throw(\n                            \"Unrecognized alignment line ($count) '$_'\");\n                    }\n                }\n                elsif ( $count == 2 ) {\n                    if (/^\\s+\\d+\\s+/) {\n                        $self->warn(\"$_\\n\") if $self->verbose > 0;\n\n                        # we are on a Subject part of the alignment\n                        # but we THOUGHT we were on the Query\n                        # move that last line to the proper place\n                        push @{ $data[2] }, pop @{ $data[0] };\n                        $count = 4;\n                    }\n                    else {\n\n                        # toss the first IDLENGTH characters of the line\n                        if ( length($_) >= $len ) {\n                            push @{ $data[ $count - 1 ] }, substr( $_, $len );\n                        }\n                    }\n                }\n                last if ( $count++ >= 5 );\n                $_ = $self->_readline();\n            }\n            if ( @{ $data[0] } || @{ $data[2] } ) {\n                $self->characters(\n                    {\n                        'Name' => 'Hsp_qseq',\n                        'Data' => join( '', @{ $data[0] } )\n                    }\n                );\n                $self->characters(\n                    {\n                        'Name' => 'Hsp_midline',\n                        'Data' => join( '', @{ $data[1] } )\n                    }\n                );\n                $self->characters(\n                    {\n                        'Name' => 'Hsp_hseq',\n                        'Data' => join( '', @{ $data[2] } )\n                    }\n                );\n            }\n        }\n        else {\n            if ( !$seentop ) {\n                $self->debug($_);\n                #$self->warn(\"unrecognized FASTA Family report file!\");\n                #return;\n            }\n        }\n    }\n    if ( $self->in_element('result') ) {\n        if ( $self->in_element('hsp') ) {\n            $self->end_element( { 'Name' => 'Hsp' } );\n        }\n        if ( $self->in_element('hit') ) {\n            $self->end_element( { 'Name' => 'Hit' } );\n        }\n        $self->end_element( { 'Name' => 'FastaOutput' } );\n    }\n    return $self->end_document();\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element {\n    my ( $self, $data ) = @_;\n\n    # we currently don't care about attributes\n    my $nm = $data->{'Name'};\n    if ( my $type = $MODEMAP{$nm} ) {\n        $self->_mode($type);\n        if ( my $handler = $self->_will_handle($type) ) {\n            my $func = sprintf( \"start_%s\", lc $type );\n            $handler->$func( $data->{'Attributes'} );\n        }\n        unshift @{ $self->{'_elements'} }, $type;\n    }\n    if ( $nm eq 'FastaOutput' ) {\n        $self->{'_values'} = {};\n        $self->{'_result'} = undef;\n        $self->{'_mode'}   = '';\n    }\n\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ( $self, $data ) = @_;\n    my $nm = $data->{'Name'};\n    my $rc;\n\n    # Hsp are sort of weird, in that they end when another\n    # object begins so have to detect this in end_element for now\n    if ( $nm eq 'Hsp' ) {\n        foreach (qw(Hsp_qseq Hsp_midline Hsp_hseq)) {\n            $self->element(\n                {\n                    'Name' => $_,\n                    'Data' => $self->{'_last_hspdata'}->{$_}\n                }\n            );\n        }\n        $self->{'_last_hspdata'} = {};\n    }\n\n    if ( my $type = $MODEMAP{$nm} ) {\n        if ( my $handler = $self->_will_handle($type) ) {\n            my $func = sprintf( \"end_%s\", lc $type );\n            $rc = $handler->$func( $self->{'_reporttype'}, $self->{'_values'} );\n        }\n        shift @{ $self->{'_elements'} };\n\n    }\n    elsif ( $MAPPING{$nm} ) {\n        if ( ref( $MAPPING{$nm} ) =~ /hash/i ) {\n            my $key = ( keys %{ $MAPPING{$nm} } )[0];\n            $self->{'_values'}->{$key}->{ $MAPPING{$nm}->{$key} } =\n              $self->{'_last_data'};\n        }\n        else {\n            $self->{'_values'}->{ $MAPPING{$nm} } = $self->{'_last_data'};\n        }\n    }\n    else {\n        $self->warn(\"unknown nm $nm, ignoring\\n\");\n    }\n    $self->{'_last_data'} = '';    # remove read data if we are at\n                                   # end of an element\n    $self->{'_result'} = $rc if ( $nm eq 'FastaOutput' );\n    return $rc;\n\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element {\n    my ( $self, $data ) = @_;\n    $self->start_element($data);\n    $self->characters($data);\n    $self->end_element($data);\n}\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string\n\n\n\nsub characters {\n    my ( $self, $data ) = @_;\n\n    return unless ( defined $data->{'Data'} );\n    if ( $data->{'Data'} =~ /^\\s+$/ ) {\n        return unless $data->{'Name'} =~ /Hsp\\_(midline|qseq|hseq)/;\n    }\n\n    if (   $self->in_element('hsp')\n        && $data->{'Name'} =~ /Hsp\\_(qseq|hseq|midline)/ )\n    {\n\n        $self->{'_last_hspdata'}->{ $data->{'Name'} } .= $data->{'Data'};\n    }\n\n    $self->{'_last_data'} = $data->{'Data'};\n}\n\n=head2 _mode\n\n Title   : _mode\n Usage   : $obj->_mode($newval)\n Function: \n Example : \n Returns : value of _mode\n Args    : newvalue (optional)\n\n\n\nsub _mode {\n    my ( $self, $value ) = @_;\n    if ( defined $value ) {\n        $self->{'_mode'} = $value;\n    }\n    return $self->{'_mode'};\n}\n\n=head2 within_element\n\n Title   : within_element\n Usage   : if( $eventgenerator->within_element($element) ) {}\n Function: Test if we are within a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name ","label":"within_element($self,$name)"},"containerName":"main::","definition":"sub","range":{"end":{"line":1572,"character":9999},"start":{"character":0,"line":1568}},"name":"within_element"},{"line":1573,"kind":13,"name":"%self","containerName":null},{"line":1574,"kind":13,"name":"$name","containerName":null},{"kind":13,"line":1574,"containerName":null,"name":"%MODEMAP"},{"name":"%name","containerName":null,"kind":13,"line":1574},{"line":1594,"children":[{"kind":13,"line":1595,"name":"$self","definition":"my","containerName":"in_element","localvar":"my"},{"containerName":"in_element","name":"$name","kind":13,"line":1595},{"name":"$self","containerName":"in_element","line":1596,"kind":13},{"line":1598,"kind":13,"name":"$self","containerName":"in_element"},{"containerName":"in_element","name":"$name","kind":13,"line":1599},{"name":"$MODEMAP","containerName":"in_element","line":1599,"kind":13},{"name":"$name","containerName":"in_element","line":1599,"kind":13},{"containerName":"in_element","name":"$self","line":1600,"kind":13},{"kind":13,"line":1600,"name":"$MODEMAP","containerName":"in_element"},{"kind":13,"line":1600,"name":"$name","containerName":"in_element"}],"kind":12,"detail":"($self,$name)","signature":{"label":"in_element($self,$name)","documentation":"1;\n# $Id: fasta.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::fasta\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::fasta - A SearchIO parser for FASTA results\n\n=head1 SYNOPSIS\n\n  # Do not use this object directly, use it through the SearchIO system\n   use Bio::SearchIO;\n   my $searchio = Bio::SearchIO->new(-format => 'fasta',\n                    -file   => 'report.FASTA');\n   while( my $result = $searchio->next_result ) {\n    # ... do what you would normally doi with Bio::SearchIO.\n   }\n\n=head1 DESCRIPTION\n\nThis object contains the event based parsing code for FASTA format\nreports.  It creates L<Bio::Search::HSP::FastaHSP> objects instead of\nL<Bio::Search::HSP::GenericHSP> for the HSP objects. \n\nThis module will parse -m 9 -d 0 output as well as default m 1 output\nfrom FASTA as well as SSEARCH.\n\nAlso see the SearchIO HOWTO:\nL<http://bioperl.open-bio.org/wiki/HOWTO:SearchIO>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich, Aaron Mackey\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::fasta;\nuse vars qw(%MODEMAP %MAPPING $IDLENGTH);\nuse strict;\n\n# Object preamble - inherits from Bio::Root::RootI\n\nuse Bio::Factory::ObjectFactory;\n\nBEGIN {\n\n    # Set IDLENGTH to a new value if you have\n    # compile FASTA with a different ID length\n    # (actually newest FASTA allows the setting of this\n    #  via -C parameter, default is 6)\n    $IDLENGTH = 6;\n\n    # mapping of NCBI Blast terms to Bioperl hash keys\n    %MODEMAP = (\n        'FastaOutput' => 'result',\n        'Hit'         => 'hit',\n        'Hsp'         => 'hsp'\n    );\n\n    # This should really be done more intelligently, like with\n    # XSLT\n\n    %MAPPING = (\n        'Hsp_bit-score'   => 'HSP-bits',\n        'Hsp_score'       => 'HSP-score',\n        'Hsp_sw-score'    => 'HSP-swscore',\n        'Hsp_evalue'      => 'HSP-evalue',\n        'Hsp_query-from'  => 'HSP-query_start',\n        'Hsp_query-to'    => 'HSP-query_end',\n        'Hsp_hit-from'    => 'HSP-hit_start',\n        'Hsp_hit-to'      => 'HSP-hit_end',\n        'Hsp_positive'    => 'HSP-conserved',\n        'Hsp_identity'    => 'HSP-identical',\n        'Hsp_gaps'        => 'HSP-hsp_gaps',\n        'Hsp_hitgaps'     => 'HSP-hit_gaps',\n        'Hsp_querygaps'   => 'HSP-query_gaps',\n        'Hsp_qseq'        => 'HSP-query_seq',\n        'Hsp_hseq'        => 'HSP-hit_seq',\n        'Hsp_midline'     => 'HSP-homology_seq',\n        'Hsp_align-len'   => 'HSP-hsp_length',\n        'Hsp_query-frame' => 'HSP-query_frame',\n        'Hsp_hit-frame'   => 'HSP-hit_frame',\n\n        'Hit_id'        => 'HIT-name',\n        'Hit_len'       => 'HIT-length',\n        'Hit_accession' => 'HIT-accession',\n        'Hit_def'       => 'HIT-description',\n        'Hit_signif'    => 'HIT-significance',\n        'Hit_score'     => 'HIT-score',\n\n        'FastaOutput_program'   => 'RESULT-algorithm_name',\n        'FastaOutput_version'   => 'RESULT-algorithm_version',\n        'FastaOutput_query-def' => 'RESULT-query_name',\n        'FastaOutput_querydesc' => 'RESULT-query_description',\n        'FastaOutput_query-len' => 'RESULT-query_length',\n        'FastaOutput_db'        => 'RESULT-database_name',\n        'FastaOutput_db-len'    => 'RESULT-database_entries',\n        'FastaOutput_db-let'    => 'RESULT-database_letters',\n\n        'Parameters_matrix'      => { 'RESULT-parameters' => 'matrix' },\n        'Parameters_expect'      => { 'RESULT-parameters' => 'expect' },\n        'Parameters_include'     => { 'RESULT-parameters' => 'include' },\n        'Parameters_sc-match'    => { 'RESULT-parameters' => 'match' },\n        'Parameters_sc-mismatch' => { 'RESULT-parameters' => 'mismatch' },\n        'Parameters_gap-open'    => { 'RESULT-parameters' => 'gapopen' },\n        'Parameters_gap-ext'     => { 'RESULT-parameters' => 'gapext' },\n        'Parameters_word-size'   => { 'RESULT-parameters' => 'wordsize' },\n        'Parameters_ktup'        => { 'RESULT-parameters' => 'ktup' },\n        'Parameters_filter'      => { 'RESULT-parameters' => 'filter' },\n        'Statistics_db-num'      => { 'RESULT-statistics' => 'dbentries' },\n        'Statistics_db-len'      => { 'RESULT-statistics' => 'dbletters' },\n        'Statistics_hsp-len'     => { 'RESULT-statistics' => 'hsplength' },\n        'Statistics_eff-space'   => { 'RESULT-statistics' => 'effectivespace' },\n        'Statistics_kappa'       => { 'RESULT-statistics' => 'kappa' },\n        'Statistics_lambda'      => { 'RESULT-statistics' => 'lambda' },\n        'Statistics_entropy'     => { 'RESULT-statistics' => 'entropy' },\n    );\n}\n\nuse base qw(Bio::SearchIO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::fasta->new();\n Function: Builds a new Bio::SearchIO::fasta object \n Returns : Bio::SearchIO::fasta\n Args    : -idlength - set ID length to something other \n                       than the default (7), this is only\n                       necessary if you have compiled FASTA\n                       with a new default id length to display\n                       in the HSP alignment blocks\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n    return unless @args;\n    my ($idlength) = $self->_rearrange( [qw(IDLENGTH)], @args );\n    $self->idlength( $idlength || $IDLENGTH );\n    $self->_eventHandler->register_factory(\n        'hsp',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::HSP::FastaHSP',\n            -interface => 'Bio::Search::HSP::HSPI'\n        )\n    );\n    return 1;\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    local $/ = \"\\n\";\n    local $_;\n\n    my $data    = '';\n    my $seentop = 0;\n    my $current_hsp;\n    $self->start_document();\n    my @hit_signifs;\n    while ( defined( $_ = $self->_readline ) ) {\n        next if ( !$self->in_element('hsp')\n            && /^\\s+$/ );    # skip empty lines\n        if (\n               m/(\\S+)\\s+searches\\s+a\\s+(protein\\s+or\\s+DNA\\s+)?sequence/oxi\n            || /(\\S+)\\s+compares\\s+a/\n            || (   m/^\\#\\s+/\n                && ( $_ = $self->_readline )\n                && /(\\S+)\\s+searches\\s+a\\s+(protein\\s+or\\s+DNA\\s+)?sequence/oxi\n                || /(\\S+)\\s+compares\\s+a/ )\n          )\n        {\n            if ($seentop) {\n                $self->_pushback($_);\n                $self->end_element( { 'Name' => 'FastaOutput' } );\n                return $self->end_document();\n            }\n            $self->{'_reporttype'} = $1;\n            $self->start_element( { 'Name' => 'FastaOutput' } );\n            $self->{'_result_count'}++;\n            $seentop = 1;\n            #$self->debug( \"reporttype is \" . $self->{'_reporttype'} . \"\\n\" );\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_program',\n                    'Data' => $self->{'_reporttype'}\n                }\n            );\n            $_ = $self->_readline();\n            my ($version) = (/version\\s+(\\S+)/);\n            $version = '' unless defined $version;\n            $self->{'_version'} = $version;\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_version',\n                    'Data' => $version\n                }\n            );\n\n            my ( $last, $leadin, $type, $querylen, $querytype, $querydef );\n\n            while ( defined( $_ = $self->_readline() ) ) {\n                if (\n                    /^ (\n                       (?:\\s+>) |             # fa33 lead-in\n                       (?:\\s*\\d+\\s*>>>)       # fa34 mlib lead-in\n                      )\n                      (.*)\n                   /x\n                  )\n                {\n                    ( $leadin, $querydef ) = ( $1, $2 );\n                    if ( $leadin =~ m/>>>/ ) {\n                        if ( $querydef =~\n                            /^(.*?)\\s+(?:\\-\\s+)?(\\d+)\\s+(aa|nt).*$/o )\n                        {\n                            ( $querydef, $querylen, $querytype ) =\n                              ( $1, $2, $3 );\n                            last;\n                        }\n                    }\n                    else {\n                        if ( $last =~ /(\\S+)[:,]\\s*(\\d+)\\s+(aa|nt)/ ) {\n                            ( $querylen, $querytype ) = ( $2, $3 );\n                            $querydef ||= $1;\n                            last;\n                        }\n                    }\n                }\n                elsif (m/^\\s*vs\\s+\\S+/o) {\n                    if ( $last =~ /(\\S+)[,:]\\s+(\\d+)\\s+(aa|nt)/o ) {\n                        ( $querydef, $querylen, $querytype ) = ( $1, $2, $3 );\n                        last;\n                    }\n                }\n                $last = $_;\n            }\n            if (   $self->{'_reporttype'}\n                && $self->{'_reporttype'} eq 'FASTA' )\n            {\n                if ( $querytype eq 'nt' ) {\n                    $self->{'_reporttype'} = 'FASTN';\n                }\n                elsif ( $querytype eq 'aa' ) {\n                    $self->{'_reporttype'} = 'FASTP';\n                }\n            }\n            my ( $name, $descr ) = $querydef =~ m/^(\\S+)\\s*(.*?)\\s*$/o;\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_query-def',\n                    'Data' => $name\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_querydesc',\n                    'Data' => $descr\n                }\n            );\n            if ($querylen) {\n                $self->element(\n                    {\n                        'Name' => 'FastaOutput_query-len',\n                        'Data' => $querylen\n                    }\n                );\n            }\n            else {\n                $self->warn(\"unable to find and set query length\");\n            }\n            if (\n                   $last =~ /^\\s*vs\\s+(\\S+)/\n                || ( $last =~ /^searching\\s+(\\S+)\\s+library/ )\n                || ( $last =~ /^Library:\\s+(\\S+)\\s+/ )\n                || (\n                    defined $_\n                    && (   /^\\s*vs\\s+(\\S+)/\n                        || /^Library:\\s+(\\S+)\\s+/ )\n                )\n                || ( defined( $_ = $self->_readline() )\n                    && ( /^\\s*vs\\s+(\\S+)/ || /^Library:\\s+(\\S+)/ ) )\n              )\n            {\n                $self->element(\n                    {\n                        'Name' => 'FastaOutput_db',\n                        'Data' => $1\n                    }\n                );\n            }\n            elsif (m/^\\s+opt(?:\\s+E\\(\\))?$/o) {\n\n           # histogram ... read over it more rapidly than the larger outer loop:\n                while ( defined( $_ = $self->_readline ) ) {\n                    last if m/^>\\d+/;\n                }\n            }\n        }\n        elsif (/(\\d+)\\s+residues\\s+in\\s+(\\d+)\\s+(?:library\\s+)?sequences/) {\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_db-let',\n                    'Data' => $1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_db-len',\n                    'Data' => $2\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Statistics_db-len',\n                    'Data' => $1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Statistics_db-num',\n                    'Data' => $2\n                }\n            );\n        }\n        elsif (/Lambda=\\s*(\\S+)/) {\n            $self->element(\n                {\n                    'Name' => 'Statistics_lambda',\n                    'Data' => $1\n                }\n            );\n        }\n        elsif (/K=\\s*(\\S+)/) {\n            $self->element(\n                {\n                    'Name' => 'Statistics_kappa',\n                    'Data' => $1\n                }\n            );\n        }\n        elsif (/^\\s*(Smith-Waterman).+(\\S+)\\s*matrix [^\\]]*?(xS)?\\]/) {\n            $self->element(\n                {\n                    'Name' => 'Parameters_matrix',\n                    'Data' => $2\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_filter',\n                    'Data' => defined $3 ? 1 : 0,\n                }\n            );\n            $self->{'_reporttype'} = $1;\n\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_program',\n                    'Data' => $self->{'_reporttype'}\n                }\n            );\n        }\n        elsif (/The best( related| unrelated)? scores are:/) {\n            my $rel    = $1;\n            my @labels = split;\n            @labels = map {\n                if ( $_ =~ m/^E\\((\\d+)\\)$/o )\n                {\n                    $self->element(\n                        { 'Name' => 'Statistics_eff-space', 'Data' => $1 } );\n                    \"evalue\";\n                }\n                else {\n                    $_;\n                }\n            } @labels[ $rel ? 5 : 4 .. $#labels ];\n\n            while ( defined( $_ = $self->_readline() )\n                && !/^\\s+$/ )\n            {\n                my @line = split;\n\n                if ( $line[-1] =~ m/\\=/o && $labels[-1] eq 'fs' ) {\n\n                    # unlabelled alignment hit;\n                    push @labels, \"aln_code\";\n                }\n\n                my %data;\n                @data{@labels} = splice( @line, @line - @labels );\n                if ( $line[-1] =~ m/\\[([1-6rf])\\]/o ) {\n                    my $fr = $1;\n                    $data{lframe} = (\n                        $fr =~ /\\d/o\n                        ? ( $fr <= 3 ? \"+$fr\" : \"-@{[$fr-3]}\" )\n                        : ( $fr eq 'f' ? '+1' : '-1' )\n                    );\n                    pop @line;\n                }\n                else {\n                    $data{lframe} = '0';\n                }\n\n                if ( $line[-1] =~ m/^\\(?(\\d+)\\)$/ ) {\n                    $data{hit_len} = $1;\n                    pop @line;\n                    if ( $line[-1] =~ m/^\\($/ ) {\n                        pop @line;\n                    }\n                }\n                else {\n                    $data{hit_len} = 0;\n                }\n\n                # rebuild the first part of the line, preserving spaces:\n                ($_) = m/^(\\S+(?:\\s+\\S+){$#line})/;\n\n                my ( $id, $desc ) = split( /\\s+/, $_, 2 );\n                my @pieces = split( /\\|/, $id );\n                my $acc = pop @pieces;\n                $acc =~ s/\\.\\d+$//;\n\n                @data{qw(id desc acc)} = ( $id, $desc, $acc );\n\n                push @hit_signifs, \\%data;\n            }\n        }\n        elsif (\n/^\\s*([T]?FAST[XYAF]).+,\\s*(\\S+)\\s*matrix[^\\]]+?(xS)?\\]\\s*ktup:\\s*(\\d+)/\n          )\n        {\n\n            $self->element(\n                {\n                    'Name' => 'Parameters_matrix',\n                    'Data' => $2\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_filter',\n                    'Data' => defined $3 ? 1 : 0,\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_ktup',\n                    'Data' => $4\n                }\n            );\n            $self->{'_reporttype'} = $1\n              if ( $self->{'_reporttype'} !~ /FAST[PN]/i );\n\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_program',\n                    'Data' => $self->{'_reporttype'}\n                }\n            );\n        }\n        elsif (/^Algorithm:\\s+(\\S+)\\s+\\(([^)]+)\\)\\s+(\\S+)/) {\n            $self->{'_reporttype'} = $1\n              if ( $self->{'_reporttype'} !~ /FAST[PN]/i );\n        }\n        elsif (\n            /^Parameters:\\s+(\\S+)\\s*matrix\\s*(?:\\(([^(]+?)\\))?\\s*ktup:\\s*(\\d+)/)\n        {    # FASTA 35.04\n            $self->element(\n                {\n                    'Name' => 'Parameters_matrix',\n                    'Data' => $1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_filter',\n                    'Data' => defined $2 ? $2 : 0,\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_ktup',\n                    'Data' => $3\n                }\n            );\n        }\n        elsif (\n/(?:gap\\-pen|open\\/ext):\\s+([\\-\\+]?\\d+)\\s*\\/\\s*([\\-\\+]?\\d+).+width:\\s+(\\d+)/\n          )\n        {\n            $self->element(\n                {\n                    'Name' => 'Parameters_gap-open',\n                    'Data' => $1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_gap-ext',\n                    'Data' => $2\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_word-size',\n                    'Data' => $3\n                }\n            );\n        }\n        elsif (/^>>(?!>)(.+?)\\s+(?:\\((\\d+)\\s*(aa|nt)\\))?$/) {\n            my ($hit_id, $len, $alphabet) = ($1, $2, $3);\n            if (!$len || !$alphabet) {\n                WRAPPED:\n                while (defined($_ = $self->_readline)) {\n                    if (/(.*?)\\s+\\((\\d+)\\s*(aa|nt)\\)/) {\n                        ($len, $alphabet) = ($2, $3);\n                        $hit_id .= $1 ? \" \".$1 : '';\n                        last WRAPPED;\n                    }\n                    if (/^>>(?!>)/) { # too far, throw\n                        $self->throw(\"Couldn't find length, bailing\");\n                    }\n                }\n            }\n            if ( $self->in_element('hsp') ) {\n                $self->end_element( { 'Name' => 'Hsp' } );\n            }\n            if ( $self->in_element('hit') ) {\n                $self->end_element( { 'Name' => 'Hit' } );\n            }\n\n            $self->start_element( { 'Name' => 'Hit' } );\n            $self->element(\n                {\n                    'Name' => 'Hit_len',\n                    'Data' => $len\n                }\n            );\n            my ( $id, $desc ) = split( /\\s+/, $hit_id, 2 );\n            $self->element(\n                {\n                    'Name' => 'Hit_id',\n                    'Data' => $id\n                }\n            );\n\n            #$self->debug(\"Hit ID is $id\\n\");\n            my @pieces = split( /\\|/, $id );\n            my $acc = pop @pieces;\n            $acc =~ s/\\.\\d+$//;\n            $self->element(\n                {\n                    'Name' => 'Hit_accession',\n                    'Data' => $acc\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hit_def',\n                    'Data' => $desc\n                }\n            );\n\n            $_ = $self->_readline();\n            my ( $score, $bits, $e ) = /Z-score: \\s* (\\S+) \\s*\n                               (?: bits: \\s* (\\S+) \\s+ )?\n                               (?: E|expect ) \\s* \\(\\) :? \\s*(\\S+)/ox;\n            $bits = $score unless defined $bits;\n\n            my $v = shift @hit_signifs;\n            if ( defined $v ) {\n                @{$v}{qw(evalue bits z-sc)} = ( $e, $bits, $score );\n            }\n            $self->element(\n                {\n                    'Name' => 'Hit_signif',\n                    'Data' => $v ? $v->{evalue} : $e\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hit_score',\n                    'Data' => $v ? $v->{bits} : $bits\n                }\n            );\n            $self->start_element( { 'Name' => 'Hsp' } );\n\n            $self->element(\n                {\n                    'Name' => 'Hsp_score',\n                    'Data' => $v ? $v->{'z-sc'} : $score\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_evalue',\n                    'Data' => $v ? $v->{evalue} : $e\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_bit-score',\n                    'Data' => $v ? $v->{bits} : $bits\n                }\n            );\n            $_ = $self->_readline();\n\n            if (s/Smith-Waterman score:\\s*(\\d+)\\;?//) {\n                $self->element(\n                    {\n                        'Name' => 'Hsp_sw-score',\n                        'Data' => $1\n                    }\n                );\n            }\n            if (\n                / (\\d*\\.?\\d+)\\% \\s* identity\n                 (?:\\s* \\(\\s*(\\S+)\\% \\s* (?:ungapped|similar) \\) )?\n                 \\s* in \\s* (\\d+) \\s+ (?:aa|nt) \\s+ overlap \\s*\n                 \\( (\\d+) \\- (\\d+) : (\\d+) \\- (\\d+) \\)\n               /x\n              )\n            {\n                my ( $identper, $gapper, $len, $querystart, $queryend,\n                    $hitstart, $hitend )\n                  = ( $1, $2, $3, $4, $5, $6, $7 );\n                my $ident = sprintf( \"%.0f\", ( $identper / 100 ) * $len );\n                my $positive = sprintf( \"%.0f\", ( $gapper / 100 ) * $len );\n\n                $self->element(\n                    {\n                        'Name' => 'Hsp_identity',\n                        'Data' => $ident\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'Hsp_positive',\n                        'Data' => $positive\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'Hsp_align-len',\n                        'Data' => $len\n                    }\n                );\n\n                $self->element(\n                    {\n                        'Name' => 'Hsp_query-from',\n                        'Data' => $querystart\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'Hsp_query-to',\n                        'Data' => $queryend\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'Hsp_hit-from',\n                        'Data' => $hitstart\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'Hsp_hit-to',\n                        'Data' => $hitend\n                    }\n                );\n\n            }\n\n            if ($v) {\n                $self->element(\n                    { 'Name' => 'Hsp_querygaps', 'Data' => $v->{qgaps} } )\n                  if exists $v->{qgaps};\n                $self->element(\n                    { 'Name' => 'Hsp_hitgaps', 'Data' => $v->{lgaps} } )\n                  if exists $v->{lgaps};\n\n                if ( $self->{'_reporttype'} =~ m/^FAST[NXY]$/o ) {\n                    if ( 8 == scalar grep { exists $v->{$_} }\n                        qw(an0 ax0 pn0 px0 an1 ax1 pn1 px1) )\n                    {\n                        if ( $v->{ax0} < $v->{an0} ) {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_query-frame',\n                                    'Data' =>\n                                      \"-@{[(($v->{px0} - $v->{ax0}) % 3) + 1]}\"\n                                }\n                            );\n                        }\n                        else {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_query-frame',\n                                    'Data' =>\n                                      \"+@{[(($v->{an0} - $v->{pn0}) % 3) + 1]}\"\n                                }\n                            );\n                        }\n                        if ( $v->{ax1} < $v->{an1} ) {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_hit-frame',\n                                    'Data' =>\n                                      \"-@{[(($v->{px1} - $v->{ax1}) % 3) + 1]}\"\n                                }\n                            );\n                        }\n                        else {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_hit-frame',\n                                    'Data' =>\n                                      \"+@{[(($v->{an1} - $v->{pn1}) % 3) + 1]}\"\n                                }\n                            );\n                        }\n                    }\n                    else {\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_query-frame',\n                                'Data' => $v->{lframe}\n                            }\n                        );\n                        $self->element(\n                            { 'Name' => 'Hsp_hit-frame', 'Data' => 0 } );\n                    }\n                }\n                else {\n                    $self->element(\n                        { 'Name' => 'Hsp_query-frame', 'Data' => 0 } );\n                    $self->element(\n                        { 'Name' => 'Hsp_hit-frame', 'Data' => $v->{lframe} } );\n                }\n\n            }\n            else {\n                $self->warn(\"unable to parse FASTA score line: $_\");\n            }\n        }\n        elsif (/\\d+\\s*residues\\s*in\\s*\\d+\\s*query\\s*sequences/) {\n            if ( $self->in_element('hsp') ) {\n                $self->end_element( { 'Name' => 'Hsp' } );\n            }\n            if ( $self->in_element('hit') ) {\n                $self->end_element( { 'Name' => 'Hit' } );\n            }\n\n           #       $_ = $self->_readline();\n           #       my ( $liblen,$libsize) = /(\\d+)\\s+residues\\s*in(\\d+)\\s*library/;\n           # fast forward to the end of the file as there is\n           # nothing else left to do with this file and want to be sure and\n           # reset it\n            while ( defined( $_ = $self->_readline() ) ) {\n                last if (/^Function used was/);\n                if (\n                    /(\\S+)\\s+searches\\s+a\\s+(protein\\s+or\\s+DNA\\s+)?\n           sequence/oxi || /(\\S+)\\s+compares\\s+a/oi\n                  )\n                {\n                    $self->_pushback($_);\n                }\n            }\n\n            if (@hit_signifs) {\n\n                # process remaining best hits\n                for my $h (@hit_signifs) {\n\n                    # Hsp_score Hsp_evalue Hsp_bit-score\n                    # Hsp_sw-score Hsp_gaps Hsp_identity Hsp_positive\n                    # Hsp_align-len Hsp_query-from Hsp_query-to\n                    # Hsp_hit-from Hsp_hit-to Hsp_qseq Hsp_midline\n\n                    $self->start_element( { 'Name' => 'Hit' } );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_len',\n                            'Data' => $h->{hit_len}\n                        }\n                    ) if exists $h->{hit_len};\n                    $self->element(\n                        {\n                            'Name' => 'Hit_id',\n                            'Data' => $h->{id}\n                        }\n                    ) if exists $h->{id};\n                    $self->element(\n                        {\n                            'Name' => 'Hit_accession',\n                            'Data' => $h->{acc}\n                        }\n                    ) if exists $h->{acc};\n                    $self->element(\n                        {\n                            'Name' => 'Hit_def',\n                            'Data' => $h->{desc}\n                        }\n                    ) if exists $h->{desc};\n                    $self->element(\n                        {\n                            'Name' => 'Hit_signif',\n                            'Data' => $h->{evalue}\n                        }\n                    ) if exists $h->{evalue};\n                    $self->element(\n                        {\n                            'Name' => 'Hit_score',\n                            'Data' => $h->{bits}\n                        }\n                    ) if exists $h->{bits};\n\n                    $self->start_element( { 'Name' => 'Hsp' } );\n                    $self->element(\n                        { 'Name' => 'Hsp_score', 'Data' => $h->{'z-sc'} } )\n                      if exists $h->{'z-sc'};\n                    $self->element(\n                        { 'Name' => 'Hsp_evalue', 'Data' => $h->{evalue} } )\n                      if exists $h->{evalue};\n                    $self->element(\n                        { 'Name' => 'Hsp_bit-score', 'Data' => $h->{bits} } )\n                      if exists $h->{bits};\n                    $self->element(\n                        { 'Name' => 'Hsp_sw-score', 'Data' => $h->{sw} } )\n                      if exists $h->{sw};\n                    $self->element(\n                        { 'Name' => 'Hsp_gaps', 'Data' => $h->{'%_gid'} } )\n                      if exists $h->{'%_gid'};\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_identity',\n                            'Data' =>\n                              sprintf( \"%.0f\", $h->{'%_id'} * $h->{alen} )\n                        }\n                    ) if ( exists $h->{'%_id'} && exists $h->{alen} );\n\n                    if ( exists $h->{'%_gid'} ) {\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_positive',\n                                'Data' =>\n                                  sprintf( \"%.0f\", $h->{'%_gid'} * $h->{alen} )\n                            }\n                        ) if exists $h->{'%_gid'} && exists $h->{alen};\n                    }\n                    else {\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_positive',\n                                'Data' =>\n                                  sprintf( \"%.0f\", $h->{'%_id'} * $h->{alen} )\n                            }\n                        ) if ( exists $h->{'%_id'} && exists $h->{alen} );\n                    }\n                    $self->element(\n                        { 'Name' => 'Hsp_align-len', 'Data' => $h->{alen} } )\n                      if exists $h->{alen};\n                    $self->element(\n                        { 'Name' => 'Hsp_query-from', 'Data' => $h->{an0} } )\n                      if exists $h->{an0};\n                    $self->element(\n                        { 'Name' => 'Hsp_query-to', 'Data' => $h->{ax0} } )\n                      if exists $h->{ax0};\n                    $self->element(\n                        { 'Name' => 'Hsp_hit-from', 'Data' => $h->{an1} } )\n                      if exists $h->{an1};\n                    $self->element(\n                        { 'Name' => 'Hsp_hit-to', 'Data' => $h->{ax1} } )\n                      if exists $h->{ax1};\n\n                    $self->element(\n                        { 'Name' => 'Hsp_querygaps', 'Data' => $h->{qgaps} } )\n                      if exists $h->{qgaps};\n                    $self->element(\n                        { 'Name' => 'Hsp_hitgaps', 'Data' => $h->{lgaps} } )\n                      if exists $h->{lgaps};\n\n                    if ( $self->{'_reporttype'} =~ m/^FAST[NXY]$/o ) {\n                        if ( 8 == scalar grep { exists $h->{$_} }\n                            qw(an0 ax0 pn0 px0 an1 ax1 pn1 px1) )\n                        {\n                            if ( $h->{ax0} < $h->{an0} ) {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_query-frame',\n                                        'Data' =>\n\"-@{[(($h->{px0} - $h->{ax0}) % 3) + 1]}\"\n                                    }\n                                );\n                            }\n                            else {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_query-frame',\n                                        'Data' =>\n\"+@{[(($h->{an0} - $h->{pn0}) % 3) + 1]}\"\n                                    }\n                                );\n                            }\n                            if ( $h->{ax1} < $h->{an1} ) {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_hit-frame',\n                                        'Data' =>\n\"-@{[(($h->{px1} - $h->{ax1}) % 3) + 1]}\"\n                                    }\n                                );\n                            }\n                            else {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_hit-frame',\n                                        'Data' =>\n\"+@{[(($h->{an1} - $h->{pn1}) % 3) + 1]}\"\n                                    }\n                                );\n                            }\n                        }\n                        else {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_query-frame',\n                                    'Data' => $h->{lframe}\n                                }\n                            );\n                            $self->element(\n                                { 'Name' => 'Hsp_hit-frame', 'Data' => 0 } );\n                        }\n                    }\n                    else {\n                        $self->element(\n                            { 'Name' => 'Hsp_query-frame', 'Data' => 0 } );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_hit-frame',\n                                'Data' => $h->{lframe}\n                            }\n                        );\n                    }\n\n                    $self->end_element( { 'Name' => 'Hsp' } );\n                    $self->end_element( { 'Name' => 'Hit' } );\n                }\n            }\n            $self->end_element( { 'Name' => 'FastaOutput' } );\n            return $self->end_document();\n        }\n        elsif (/^\\s*\\d+\\s*>>>/) {\n            if ( $self->within_element('FastaOutput') ) {\n                if ( $self->in_element('hsp') ) {\n                    $self->end_element( { 'Name' => 'Hsp' } );\n                }\n                if ( $self->in_element('hit') ) {\n                    $self->end_element( { 'Name' => 'Hit' } );\n                }\n\n                if (@hit_signifs) {\n\n                    # process remaining best hits\n                    for my $h (@hit_signifs) {\n                        $self->start_element( { 'Name' => 'Hit' } );\n                        $self->element(\n                            {\n                                'Name' => 'Hit_len',\n                                'Data' => $h->{hit_len}\n                            }\n                        ) if exists $h->{hit_len};\n                        $self->element(\n                            {\n                                'Name' => 'Hit_id',\n                                'Data' => $h->{id}\n                            }\n                        ) if exists $h->{id};\n                        $self->element(\n                            {\n                                'Name' => 'Hit_accession',\n                                'Data' => $h->{acc}\n                            }\n                        ) if exists $h->{acc};\n                        $self->element(\n                            {\n                                'Name' => 'Hit_def',\n                                'Data' => $h->{desc}\n                            }\n                        ) if exists $h->{desc};\n                        $self->element(\n                            {\n                                'Name' => 'Hit_signif',\n                                'Data' => $h->{evalue}\n                            }\n                        ) if exists $h->{evalue};\n                        $self->element(\n                            {\n                                'Name' => 'Hit_score',\n                                'Data' => $h->{bits}\n                            }\n                        ) if exists $h->{bits};\n\n                        $self->start_element( { 'Name' => 'Hsp' } );\n                        $self->element(\n                            { 'Name' => 'Hsp_score', 'Data' => $h->{'z-sc'} } )\n                          if exists $h->{'z-sc'};\n                        $self->element(\n                            { 'Name' => 'Hsp_evalue', 'Data' => $h->{evalue} } )\n                          if exists $h->{evalue};\n                        $self->element(\n                            { 'Name' => 'Hsp_bit-score', 'Data' => $h->{bits} }\n                        ) if exists $h->{bits};\n                        $self->element(\n                            { 'Name' => 'Hsp_sw-score', 'Data' => $h->{sw} } )\n                          if exists $h->{sw};\n                        $self->element(\n                            { 'Name' => 'Hsp_gaps', 'Data' => $h->{'%_gid'} } )\n                          if exists $h->{'%_gid'};\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_identity',\n                                'Data' =>\n                                  sprintf( \"%.0f\", $h->{'%_id'} * $h->{alen} )\n                            }\n                        ) if ( exists $h->{'%_id'} && exists $h->{alen} );\n\n                        if ( exists $h->{'%_gid'} ) {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_positive',\n                                    'Data' => sprintf( \"%.0f\",\n                                        $h->{'%_gid'} * $h->{alen} )\n                                }\n                            ) if exists $h->{'%_gid'} && exists $h->{alen};\n                        }\n                        else {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_positive',\n                                    'Data' => sprintf( \"%.0f\",\n                                        $h->{'%_id'} * $h->{alen} )\n                                }\n                            ) if ( exists $h->{'%_id'} && exists $h->{alen} );\n                        }\n                        $self->element(\n                            { 'Name' => 'Hsp_align-len', 'Data' => $h->{alen} }\n                        ) if exists $h->{alen};\n                        $self->element(\n                            { 'Name' => 'Hsp_query-from', 'Data' => $h->{an0} }\n                        ) if exists $h->{an0};\n                        $self->element(\n                            { 'Name' => 'Hsp_query-to', 'Data' => $h->{ax0} } )\n                          if exists $h->{ax0};\n                        $self->element(\n                            { 'Name' => 'Hsp_hit-from', 'Data' => $h->{an1} } )\n                          if exists $h->{an1};\n                        $self->element(\n                            { 'Name' => 'Hsp_hit-to', 'Data' => $h->{ax1} } )\n                          if exists $h->{ax1};\n\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_querygaps',\n                                'Data' => $h->{qgaps}\n                            }\n                        ) if exists $h->{qgaps};\n                        $self->element(\n                            { 'Name' => 'Hsp_hitgaps', 'Data' => $h->{lgaps} } )\n                          if exists $h->{lgaps};\n\n                        if ( $self->{'_reporttype'} =~ m/^FAST[NXY]$/o ) {\n                            if ( 8 == scalar grep { exists $h->{$_} }\n                                qw(an0 ax0 pn0 px0 an1 ax1 pn1 px1) )\n                            {\n                                if ( $h->{ax0} < $h->{an0} ) {\n                                    $self->element(\n                                        {\n                                            'Name' => 'Hsp_query-frame',\n                                            'Data' => \"-@{[(($h->{px0} - $h->{ax0}) % 3) + 1]}\"\n                                        }\n                                    );\n                                }\n                                else {\n                                    $self->element(\n                                        {\n                                            'Name' => 'Hsp_query-frame',\n                                            'Data' => \"+@{[(($h->{an0} - $h->{pn0}) % 3) + 1]}\"\n                                        }\n                                    );\n                                }\n                                if ( $h->{ax1} < $h->{an1} ) {\n                                    $self->element(\n                                        {\n                                            'Name' => 'Hsp_hit-frame',\n                                            'Data' => \"-@{[(($h->{px1} - $h->{ax1}) % 3) + 1]}\"\n                                        }\n                                    );\n                                }\n                                else {\n                                    $self->element(\n                                        {\n                                            'Name' => 'Hsp_hit-frame',\n                                            'Data' => \"+@{[(($h->{an1} - $h->{pn1}) % 3) + 1]}\"\n                                        }\n                                    );\n                                }\n                            }\n                            else {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_query-frame',\n                                        'Data' => $h->{lframe}\n                                    }\n                                );\n                                $self->element(\n                                    { 'Name' => 'Hsp_hit-frame', 'Data' => 0 }\n                                );\n                            }\n                        }\n                        else {\n                            $self->element(\n                                { 'Name' => 'Hsp_query-frame', 'Data' => 0 } );\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_hit-frame',\n                                    'Data' => $h->{lframe}\n                                }\n                            );\n                        }\n\n                        $self->end_element( { 'Name' => 'Hsp' } );\n                        $self->end_element( { 'Name' => 'Hit' } );\n                    }\n                }\n                $self->end_element( { 'Name' => 'FastaOutput' } );\n                $self->_pushback($_);\n                return $self->end_document();\n            }\n            else {\n                $self->start_element( { 'Name' => 'FastaOutput' } );\n                $self->{'_result_count'}++;\n                $seentop = 1;\n                $self->element(\n                    {\n                        'Name' => 'FastaOutput_program',\n                        'Data' => $self->{'_reporttype'}\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'FastaOutput_version',\n                        'Data' => $self->{'_version'}\n                    }\n                );\n\n                my ( $type, $querylen, $querytype, $querydef );\n\n                if (/^\\s*\\d+\\s*>>>(.*)/) {\n                    $querydef = $1;\n                    if ( $querydef =~ /^(.*?)\\s+(?:\\-\\s+)?(\\d+)\\s+(aa|nt).*$/o )\n                    {\n                        ( $querydef, $querylen, $querytype ) = ( $1, $2, $3 );\n                    }\n                }\n\n                if (   $self->{'_reporttype'}\n                    && $self->{'_reporttype'} eq 'FASTA' )\n                {\n                    if ( $querytype eq 'nt' ) {\n                        $self->{'_reporttype'} = 'FASTN';\n                    }\n                    elsif ( $querytype eq 'aa' ) {\n                        $self->{'_reporttype'} = 'FASTP';\n                    }\n                }\n                my ( $name, $descr ) =\n                  ( $querydef =~ m/^(\\S+)(?:\\s+(.*))?\\s*$/o );\n                $self->element(\n                    {\n                        'Name' => 'FastaOutput_query-def',\n                        'Data' => $name\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'FastaOutput_querydesc',\n                        'Data' => $descr\n                    }\n                );\n                if ($querylen) {\n                    $self->element(\n                        {\n                            'Name' => 'FastaOutput_query-len',\n                            'Data' => $querylen\n                        }\n                    );\n                }\n                else {\n                    $self->warn(\"unable to find and set query length\");\n                }\n                if ( defined( $_ = $self->_readline() )\n                    && ( /^\\s*vs\\s+(\\S+)/ || /^Library:\\s+(\\S+)/ ) )\n                {\n                    $self->element(\n                        {\n                            'Name' => 'FastaOutput_db',\n                            'Data' => $1\n                        }\n                    );\n                }\n\n            }\n        }\n        elsif ( $self->in_element('hsp') ) {\n            my @data  = ( [], [], [] );\n            my $count = 0;\n            my $len   = $self->idlength + 1;\n            my ($seq1_id);\n            while ( defined($_) ) {\n                chomp;\n                #$self->debug(\"$count $_\\n\");\n                if (/residues in \\d+\\s+query\\s+sequences/o) {\n                    $self->_pushback($_);\n                    last;\n                }\n                elsif (/^>>>\\*\\*\\*/o) {\n                    $self->end_element( { Name => \"Hsp\" } );\n                    last;\n                }\n                elsif (/^>>/o) {\n                    $self->_pushback($_);\n                    last;\n                }\n                elsif (/^\\s*\\d+\\s*>>>/o) {\n                    $self->_pushback($_);\n                    last;\n                }\n                if ( $count == 0 ) {\n                    if (/^(\\S+)\\s+/) {\n                        $self->_pushback($_);\n                        $count = 2;\n                    }\n                    elsif ( /^\\s+\\d+/ || /^\\s+$/ ) {\n\n                        # do nothing, this is really a 0 line\n                    }\n                    elsif ( length($_) == 0 ) {\n                        $count = -1;\n                    }\n                    else {\n                        $self->_pushback($_);\n                        $count = 0;\n                    }\n                }\n                elsif ( $count == 1 || $count == 3 ) {\n                    if (/^(\\S+)\\s+/) {\n                        $len = CORE::length($1) if $len < CORE::length($1);\n                        s/\\s+$//;    # trim trailing spaces,we don't want them\n                        push @{ $data[ $count - 1 ] }, substr( $_, $len );\n                    }\n                    elsif (/^\\s+(\\d+)/) {\n                        $count = -1;\n                        $self->_pushback($_);\n                    }\n                    elsif ( /^\\s+$/ || length($_) == 0 ) {\n                        $count = 5;\n\n                        # going to skip these\n                    }\n                    else {\n                        $self->throw(\n                            \"Unrecognized alignment line ($count) '$_'\");\n                    }\n                }\n                elsif ( $count == 2 ) {\n                    if (/^\\s+\\d+\\s+/) {\n                        $self->warn(\"$_\\n\") if $self->verbose > 0;\n\n                        # we are on a Subject part of the alignment\n                        # but we THOUGHT we were on the Query\n                        # move that last line to the proper place\n                        push @{ $data[2] }, pop @{ $data[0] };\n                        $count = 4;\n                    }\n                    else {\n\n                        # toss the first IDLENGTH characters of the line\n                        if ( length($_) >= $len ) {\n                            push @{ $data[ $count - 1 ] }, substr( $_, $len );\n                        }\n                    }\n                }\n                last if ( $count++ >= 5 );\n                $_ = $self->_readline();\n            }\n            if ( @{ $data[0] } || @{ $data[2] } ) {\n                $self->characters(\n                    {\n                        'Name' => 'Hsp_qseq',\n                        'Data' => join( '', @{ $data[0] } )\n                    }\n                );\n                $self->characters(\n                    {\n                        'Name' => 'Hsp_midline',\n                        'Data' => join( '', @{ $data[1] } )\n                    }\n                );\n                $self->characters(\n                    {\n                        'Name' => 'Hsp_hseq',\n                        'Data' => join( '', @{ $data[2] } )\n                    }\n                );\n            }\n        }\n        else {\n            if ( !$seentop ) {\n                $self->debug($_);\n                #$self->warn(\"unrecognized FASTA Family report file!\");\n                #return;\n            }\n        }\n    }\n    if ( $self->in_element('result') ) {\n        if ( $self->in_element('hsp') ) {\n            $self->end_element( { 'Name' => 'Hsp' } );\n        }\n        if ( $self->in_element('hit') ) {\n            $self->end_element( { 'Name' => 'Hit' } );\n        }\n        $self->end_element( { 'Name' => 'FastaOutput' } );\n    }\n    return $self->end_document();\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element {\n    my ( $self, $data ) = @_;\n\n    # we currently don't care about attributes\n    my $nm = $data->{'Name'};\n    if ( my $type = $MODEMAP{$nm} ) {\n        $self->_mode($type);\n        if ( my $handler = $self->_will_handle($type) ) {\n            my $func = sprintf( \"start_%s\", lc $type );\n            $handler->$func( $data->{'Attributes'} );\n        }\n        unshift @{ $self->{'_elements'} }, $type;\n    }\n    if ( $nm eq 'FastaOutput' ) {\n        $self->{'_values'} = {};\n        $self->{'_result'} = undef;\n        $self->{'_mode'}   = '';\n    }\n\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ( $self, $data ) = @_;\n    my $nm = $data->{'Name'};\n    my $rc;\n\n    # Hsp are sort of weird, in that they end when another\n    # object begins so have to detect this in end_element for now\n    if ( $nm eq 'Hsp' ) {\n        foreach (qw(Hsp_qseq Hsp_midline Hsp_hseq)) {\n            $self->element(\n                {\n                    'Name' => $_,\n                    'Data' => $self->{'_last_hspdata'}->{$_}\n                }\n            );\n        }\n        $self->{'_last_hspdata'} = {};\n    }\n\n    if ( my $type = $MODEMAP{$nm} ) {\n        if ( my $handler = $self->_will_handle($type) ) {\n            my $func = sprintf( \"end_%s\", lc $type );\n            $rc = $handler->$func( $self->{'_reporttype'}, $self->{'_values'} );\n        }\n        shift @{ $self->{'_elements'} };\n\n    }\n    elsif ( $MAPPING{$nm} ) {\n        if ( ref( $MAPPING{$nm} ) =~ /hash/i ) {\n            my $key = ( keys %{ $MAPPING{$nm} } )[0];\n            $self->{'_values'}->{$key}->{ $MAPPING{$nm}->{$key} } =\n              $self->{'_last_data'};\n        }\n        else {\n            $self->{'_values'}->{ $MAPPING{$nm} } = $self->{'_last_data'};\n        }\n    }\n    else {\n        $self->warn(\"unknown nm $nm, ignoring\\n\");\n    }\n    $self->{'_last_data'} = '';    # remove read data if we are at\n                                   # end of an element\n    $self->{'_result'} = $rc if ( $nm eq 'FastaOutput' );\n    return $rc;\n\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element {\n    my ( $self, $data ) = @_;\n    $self->start_element($data);\n    $self->characters($data);\n    $self->end_element($data);\n}\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string\n\n\n\nsub characters {\n    my ( $self, $data ) = @_;\n\n    return unless ( defined $data->{'Data'} );\n    if ( $data->{'Data'} =~ /^\\s+$/ ) {\n        return unless $data->{'Name'} =~ /Hsp\\_(midline|qseq|hseq)/;\n    }\n\n    if (   $self->in_element('hsp')\n        && $data->{'Name'} =~ /Hsp\\_(qseq|hseq|midline)/ )\n    {\n\n        $self->{'_last_hspdata'}->{ $data->{'Name'} } .= $data->{'Data'};\n    }\n\n    $self->{'_last_data'} = $data->{'Data'};\n}\n\n=head2 _mode\n\n Title   : _mode\n Usage   : $obj->_mode($newval)\n Function: \n Example : \n Returns : value of _mode\n Args    : newvalue (optional)\n\n\n\nsub _mode {\n    my ( $self, $value ) = @_;\n    if ( defined $value ) {\n        $self->{'_mode'} = $value;\n    }\n    return $self->{'_mode'};\n}\n\n=head2 within_element\n\n Title   : within_element\n Usage   : if( $eventgenerator->within_element($element) ) {}\n Function: Test if we are within a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name \n\n\n\nsub within_element {\n    my ( $self, $name ) = @_;\n    return 0\n      if (!defined $name && !defined $self->{'_elements'}\n        || scalar @{ $self->{'_elements'} } == 0 );\n    foreach ( @{ $self->{'_elements'} } ) {\n        if ( $_ eq $name || $_ eq $MODEMAP{$name} ) {\n            return 1;\n        }\n    }\n    return 0;\n}\n\n=head2 in_element\n\n Title   : in_element\n Usage   : if( $eventgenerator->in_element($element) ) {}\n Function: Test if we are in a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name ","parameters":[{"label":"$self"},{"label":"$name"}]},"containerName":"main::","definition":"sub","range":{"start":{"character":0,"line":1594},"end":{"character":9999,"line":1602}},"name":"in_element"},{"name":"start_document","range":{"start":{"line":1615,"character":0},"end":{"line":1622,"character":9999}},"containerName":"main::","definition":"sub","detail":"($self)","signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: fasta.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::fasta\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::fasta - A SearchIO parser for FASTA results\n\n=head1 SYNOPSIS\n\n  # Do not use this object directly, use it through the SearchIO system\n   use Bio::SearchIO;\n   my $searchio = Bio::SearchIO->new(-format => 'fasta',\n                    -file   => 'report.FASTA');\n   while( my $result = $searchio->next_result ) {\n    # ... do what you would normally doi with Bio::SearchIO.\n   }\n\n=head1 DESCRIPTION\n\nThis object contains the event based parsing code for FASTA format\nreports.  It creates L<Bio::Search::HSP::FastaHSP> objects instead of\nL<Bio::Search::HSP::GenericHSP> for the HSP objects. \n\nThis module will parse -m 9 -d 0 output as well as default m 1 output\nfrom FASTA as well as SSEARCH.\n\nAlso see the SearchIO HOWTO:\nL<http://bioperl.open-bio.org/wiki/HOWTO:SearchIO>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich, Aaron Mackey\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::fasta;\nuse vars qw(%MODEMAP %MAPPING $IDLENGTH);\nuse strict;\n\n# Object preamble - inherits from Bio::Root::RootI\n\nuse Bio::Factory::ObjectFactory;\n\nBEGIN {\n\n    # Set IDLENGTH to a new value if you have\n    # compile FASTA with a different ID length\n    # (actually newest FASTA allows the setting of this\n    #  via -C parameter, default is 6)\n    $IDLENGTH = 6;\n\n    # mapping of NCBI Blast terms to Bioperl hash keys\n    %MODEMAP = (\n        'FastaOutput' => 'result',\n        'Hit'         => 'hit',\n        'Hsp'         => 'hsp'\n    );\n\n    # This should really be done more intelligently, like with\n    # XSLT\n\n    %MAPPING = (\n        'Hsp_bit-score'   => 'HSP-bits',\n        'Hsp_score'       => 'HSP-score',\n        'Hsp_sw-score'    => 'HSP-swscore',\n        'Hsp_evalue'      => 'HSP-evalue',\n        'Hsp_query-from'  => 'HSP-query_start',\n        'Hsp_query-to'    => 'HSP-query_end',\n        'Hsp_hit-from'    => 'HSP-hit_start',\n        'Hsp_hit-to'      => 'HSP-hit_end',\n        'Hsp_positive'    => 'HSP-conserved',\n        'Hsp_identity'    => 'HSP-identical',\n        'Hsp_gaps'        => 'HSP-hsp_gaps',\n        'Hsp_hitgaps'     => 'HSP-hit_gaps',\n        'Hsp_querygaps'   => 'HSP-query_gaps',\n        'Hsp_qseq'        => 'HSP-query_seq',\n        'Hsp_hseq'        => 'HSP-hit_seq',\n        'Hsp_midline'     => 'HSP-homology_seq',\n        'Hsp_align-len'   => 'HSP-hsp_length',\n        'Hsp_query-frame' => 'HSP-query_frame',\n        'Hsp_hit-frame'   => 'HSP-hit_frame',\n\n        'Hit_id'        => 'HIT-name',\n        'Hit_len'       => 'HIT-length',\n        'Hit_accession' => 'HIT-accession',\n        'Hit_def'       => 'HIT-description',\n        'Hit_signif'    => 'HIT-significance',\n        'Hit_score'     => 'HIT-score',\n\n        'FastaOutput_program'   => 'RESULT-algorithm_name',\n        'FastaOutput_version'   => 'RESULT-algorithm_version',\n        'FastaOutput_query-def' => 'RESULT-query_name',\n        'FastaOutput_querydesc' => 'RESULT-query_description',\n        'FastaOutput_query-len' => 'RESULT-query_length',\n        'FastaOutput_db'        => 'RESULT-database_name',\n        'FastaOutput_db-len'    => 'RESULT-database_entries',\n        'FastaOutput_db-let'    => 'RESULT-database_letters',\n\n        'Parameters_matrix'      => { 'RESULT-parameters' => 'matrix' },\n        'Parameters_expect'      => { 'RESULT-parameters' => 'expect' },\n        'Parameters_include'     => { 'RESULT-parameters' => 'include' },\n        'Parameters_sc-match'    => { 'RESULT-parameters' => 'match' },\n        'Parameters_sc-mismatch' => { 'RESULT-parameters' => 'mismatch' },\n        'Parameters_gap-open'    => { 'RESULT-parameters' => 'gapopen' },\n        'Parameters_gap-ext'     => { 'RESULT-parameters' => 'gapext' },\n        'Parameters_word-size'   => { 'RESULT-parameters' => 'wordsize' },\n        'Parameters_ktup'        => { 'RESULT-parameters' => 'ktup' },\n        'Parameters_filter'      => { 'RESULT-parameters' => 'filter' },\n        'Statistics_db-num'      => { 'RESULT-statistics' => 'dbentries' },\n        'Statistics_db-len'      => { 'RESULT-statistics' => 'dbletters' },\n        'Statistics_hsp-len'     => { 'RESULT-statistics' => 'hsplength' },\n        'Statistics_eff-space'   => { 'RESULT-statistics' => 'effectivespace' },\n        'Statistics_kappa'       => { 'RESULT-statistics' => 'kappa' },\n        'Statistics_lambda'      => { 'RESULT-statistics' => 'lambda' },\n        'Statistics_entropy'     => { 'RESULT-statistics' => 'entropy' },\n    );\n}\n\nuse base qw(Bio::SearchIO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::fasta->new();\n Function: Builds a new Bio::SearchIO::fasta object \n Returns : Bio::SearchIO::fasta\n Args    : -idlength - set ID length to something other \n                       than the default (7), this is only\n                       necessary if you have compiled FASTA\n                       with a new default id length to display\n                       in the HSP alignment blocks\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n    return unless @args;\n    my ($idlength) = $self->_rearrange( [qw(IDLENGTH)], @args );\n    $self->idlength( $idlength || $IDLENGTH );\n    $self->_eventHandler->register_factory(\n        'hsp',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::HSP::FastaHSP',\n            -interface => 'Bio::Search::HSP::HSPI'\n        )\n    );\n    return 1;\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    local $/ = \"\\n\";\n    local $_;\n\n    my $data    = '';\n    my $seentop = 0;\n    my $current_hsp;\n    $self->start_document();\n    my @hit_signifs;\n    while ( defined( $_ = $self->_readline ) ) {\n        next if ( !$self->in_element('hsp')\n            && /^\\s+$/ );    # skip empty lines\n        if (\n               m/(\\S+)\\s+searches\\s+a\\s+(protein\\s+or\\s+DNA\\s+)?sequence/oxi\n            || /(\\S+)\\s+compares\\s+a/\n            || (   m/^\\#\\s+/\n                && ( $_ = $self->_readline )\n                && /(\\S+)\\s+searches\\s+a\\s+(protein\\s+or\\s+DNA\\s+)?sequence/oxi\n                || /(\\S+)\\s+compares\\s+a/ )\n          )\n        {\n            if ($seentop) {\n                $self->_pushback($_);\n                $self->end_element( { 'Name' => 'FastaOutput' } );\n                return $self->end_document();\n            }\n            $self->{'_reporttype'} = $1;\n            $self->start_element( { 'Name' => 'FastaOutput' } );\n            $self->{'_result_count'}++;\n            $seentop = 1;\n            #$self->debug( \"reporttype is \" . $self->{'_reporttype'} . \"\\n\" );\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_program',\n                    'Data' => $self->{'_reporttype'}\n                }\n            );\n            $_ = $self->_readline();\n            my ($version) = (/version\\s+(\\S+)/);\n            $version = '' unless defined $version;\n            $self->{'_version'} = $version;\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_version',\n                    'Data' => $version\n                }\n            );\n\n            my ( $last, $leadin, $type, $querylen, $querytype, $querydef );\n\n            while ( defined( $_ = $self->_readline() ) ) {\n                if (\n                    /^ (\n                       (?:\\s+>) |             # fa33 lead-in\n                       (?:\\s*\\d+\\s*>>>)       # fa34 mlib lead-in\n                      )\n                      (.*)\n                   /x\n                  )\n                {\n                    ( $leadin, $querydef ) = ( $1, $2 );\n                    if ( $leadin =~ m/>>>/ ) {\n                        if ( $querydef =~\n                            /^(.*?)\\s+(?:\\-\\s+)?(\\d+)\\s+(aa|nt).*$/o )\n                        {\n                            ( $querydef, $querylen, $querytype ) =\n                              ( $1, $2, $3 );\n                            last;\n                        }\n                    }\n                    else {\n                        if ( $last =~ /(\\S+)[:,]\\s*(\\d+)\\s+(aa|nt)/ ) {\n                            ( $querylen, $querytype ) = ( $2, $3 );\n                            $querydef ||= $1;\n                            last;\n                        }\n                    }\n                }\n                elsif (m/^\\s*vs\\s+\\S+/o) {\n                    if ( $last =~ /(\\S+)[,:]\\s+(\\d+)\\s+(aa|nt)/o ) {\n                        ( $querydef, $querylen, $querytype ) = ( $1, $2, $3 );\n                        last;\n                    }\n                }\n                $last = $_;\n            }\n            if (   $self->{'_reporttype'}\n                && $self->{'_reporttype'} eq 'FASTA' )\n            {\n                if ( $querytype eq 'nt' ) {\n                    $self->{'_reporttype'} = 'FASTN';\n                }\n                elsif ( $querytype eq 'aa' ) {\n                    $self->{'_reporttype'} = 'FASTP';\n                }\n            }\n            my ( $name, $descr ) = $querydef =~ m/^(\\S+)\\s*(.*?)\\s*$/o;\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_query-def',\n                    'Data' => $name\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_querydesc',\n                    'Data' => $descr\n                }\n            );\n            if ($querylen) {\n                $self->element(\n                    {\n                        'Name' => 'FastaOutput_query-len',\n                        'Data' => $querylen\n                    }\n                );\n            }\n            else {\n                $self->warn(\"unable to find and set query length\");\n            }\n            if (\n                   $last =~ /^\\s*vs\\s+(\\S+)/\n                || ( $last =~ /^searching\\s+(\\S+)\\s+library/ )\n                || ( $last =~ /^Library:\\s+(\\S+)\\s+/ )\n                || (\n                    defined $_\n                    && (   /^\\s*vs\\s+(\\S+)/\n                        || /^Library:\\s+(\\S+)\\s+/ )\n                )\n                || ( defined( $_ = $self->_readline() )\n                    && ( /^\\s*vs\\s+(\\S+)/ || /^Library:\\s+(\\S+)/ ) )\n              )\n            {\n                $self->element(\n                    {\n                        'Name' => 'FastaOutput_db',\n                        'Data' => $1\n                    }\n                );\n            }\n            elsif (m/^\\s+opt(?:\\s+E\\(\\))?$/o) {\n\n           # histogram ... read over it more rapidly than the larger outer loop:\n                while ( defined( $_ = $self->_readline ) ) {\n                    last if m/^>\\d+/;\n                }\n            }\n        }\n        elsif (/(\\d+)\\s+residues\\s+in\\s+(\\d+)\\s+(?:library\\s+)?sequences/) {\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_db-let',\n                    'Data' => $1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_db-len',\n                    'Data' => $2\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Statistics_db-len',\n                    'Data' => $1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Statistics_db-num',\n                    'Data' => $2\n                }\n            );\n        }\n        elsif (/Lambda=\\s*(\\S+)/) {\n            $self->element(\n                {\n                    'Name' => 'Statistics_lambda',\n                    'Data' => $1\n                }\n            );\n        }\n        elsif (/K=\\s*(\\S+)/) {\n            $self->element(\n                {\n                    'Name' => 'Statistics_kappa',\n                    'Data' => $1\n                }\n            );\n        }\n        elsif (/^\\s*(Smith-Waterman).+(\\S+)\\s*matrix [^\\]]*?(xS)?\\]/) {\n            $self->element(\n                {\n                    'Name' => 'Parameters_matrix',\n                    'Data' => $2\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_filter',\n                    'Data' => defined $3 ? 1 : 0,\n                }\n            );\n            $self->{'_reporttype'} = $1;\n\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_program',\n                    'Data' => $self->{'_reporttype'}\n                }\n            );\n        }\n        elsif (/The best( related| unrelated)? scores are:/) {\n            my $rel    = $1;\n            my @labels = split;\n            @labels = map {\n                if ( $_ =~ m/^E\\((\\d+)\\)$/o )\n                {\n                    $self->element(\n                        { 'Name' => 'Statistics_eff-space', 'Data' => $1 } );\n                    \"evalue\";\n                }\n                else {\n                    $_;\n                }\n            } @labels[ $rel ? 5 : 4 .. $#labels ];\n\n            while ( defined( $_ = $self->_readline() )\n                && !/^\\s+$/ )\n            {\n                my @line = split;\n\n                if ( $line[-1] =~ m/\\=/o && $labels[-1] eq 'fs' ) {\n\n                    # unlabelled alignment hit;\n                    push @labels, \"aln_code\";\n                }\n\n                my %data;\n                @data{@labels} = splice( @line, @line - @labels );\n                if ( $line[-1] =~ m/\\[([1-6rf])\\]/o ) {\n                    my $fr = $1;\n                    $data{lframe} = (\n                        $fr =~ /\\d/o\n                        ? ( $fr <= 3 ? \"+$fr\" : \"-@{[$fr-3]}\" )\n                        : ( $fr eq 'f' ? '+1' : '-1' )\n                    );\n                    pop @line;\n                }\n                else {\n                    $data{lframe} = '0';\n                }\n\n                if ( $line[-1] =~ m/^\\(?(\\d+)\\)$/ ) {\n                    $data{hit_len} = $1;\n                    pop @line;\n                    if ( $line[-1] =~ m/^\\($/ ) {\n                        pop @line;\n                    }\n                }\n                else {\n                    $data{hit_len} = 0;\n                }\n\n                # rebuild the first part of the line, preserving spaces:\n                ($_) = m/^(\\S+(?:\\s+\\S+){$#line})/;\n\n                my ( $id, $desc ) = split( /\\s+/, $_, 2 );\n                my @pieces = split( /\\|/, $id );\n                my $acc = pop @pieces;\n                $acc =~ s/\\.\\d+$//;\n\n                @data{qw(id desc acc)} = ( $id, $desc, $acc );\n\n                push @hit_signifs, \\%data;\n            }\n        }\n        elsif (\n/^\\s*([T]?FAST[XYAF]).+,\\s*(\\S+)\\s*matrix[^\\]]+?(xS)?\\]\\s*ktup:\\s*(\\d+)/\n          )\n        {\n\n            $self->element(\n                {\n                    'Name' => 'Parameters_matrix',\n                    'Data' => $2\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_filter',\n                    'Data' => defined $3 ? 1 : 0,\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_ktup',\n                    'Data' => $4\n                }\n            );\n            $self->{'_reporttype'} = $1\n              if ( $self->{'_reporttype'} !~ /FAST[PN]/i );\n\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_program',\n                    'Data' => $self->{'_reporttype'}\n                }\n            );\n        }\n        elsif (/^Algorithm:\\s+(\\S+)\\s+\\(([^)]+)\\)\\s+(\\S+)/) {\n            $self->{'_reporttype'} = $1\n              if ( $self->{'_reporttype'} !~ /FAST[PN]/i );\n        }\n        elsif (\n            /^Parameters:\\s+(\\S+)\\s*matrix\\s*(?:\\(([^(]+?)\\))?\\s*ktup:\\s*(\\d+)/)\n        {    # FASTA 35.04\n            $self->element(\n                {\n                    'Name' => 'Parameters_matrix',\n                    'Data' => $1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_filter',\n                    'Data' => defined $2 ? $2 : 0,\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_ktup',\n                    'Data' => $3\n                }\n            );\n        }\n        elsif (\n/(?:gap\\-pen|open\\/ext):\\s+([\\-\\+]?\\d+)\\s*\\/\\s*([\\-\\+]?\\d+).+width:\\s+(\\d+)/\n          )\n        {\n            $self->element(\n                {\n                    'Name' => 'Parameters_gap-open',\n                    'Data' => $1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_gap-ext',\n                    'Data' => $2\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_word-size',\n                    'Data' => $3\n                }\n            );\n        }\n        elsif (/^>>(?!>)(.+?)\\s+(?:\\((\\d+)\\s*(aa|nt)\\))?$/) {\n            my ($hit_id, $len, $alphabet) = ($1, $2, $3);\n            if (!$len || !$alphabet) {\n                WRAPPED:\n                while (defined($_ = $self->_readline)) {\n                    if (/(.*?)\\s+\\((\\d+)\\s*(aa|nt)\\)/) {\n                        ($len, $alphabet) = ($2, $3);\n                        $hit_id .= $1 ? \" \".$1 : '';\n                        last WRAPPED;\n                    }\n                    if (/^>>(?!>)/) { # too far, throw\n                        $self->throw(\"Couldn't find length, bailing\");\n                    }\n                }\n            }\n            if ( $self->in_element('hsp') ) {\n                $self->end_element( { 'Name' => 'Hsp' } );\n            }\n            if ( $self->in_element('hit') ) {\n                $self->end_element( { 'Name' => 'Hit' } );\n            }\n\n            $self->start_element( { 'Name' => 'Hit' } );\n            $self->element(\n                {\n                    'Name' => 'Hit_len',\n                    'Data' => $len\n                }\n            );\n            my ( $id, $desc ) = split( /\\s+/, $hit_id, 2 );\n            $self->element(\n                {\n                    'Name' => 'Hit_id',\n                    'Data' => $id\n                }\n            );\n\n            #$self->debug(\"Hit ID is $id\\n\");\n            my @pieces = split( /\\|/, $id );\n            my $acc = pop @pieces;\n            $acc =~ s/\\.\\d+$//;\n            $self->element(\n                {\n                    'Name' => 'Hit_accession',\n                    'Data' => $acc\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hit_def',\n                    'Data' => $desc\n                }\n            );\n\n            $_ = $self->_readline();\n            my ( $score, $bits, $e ) = /Z-score: \\s* (\\S+) \\s*\n                               (?: bits: \\s* (\\S+) \\s+ )?\n                               (?: E|expect ) \\s* \\(\\) :? \\s*(\\S+)/ox;\n            $bits = $score unless defined $bits;\n\n            my $v = shift @hit_signifs;\n            if ( defined $v ) {\n                @{$v}{qw(evalue bits z-sc)} = ( $e, $bits, $score );\n            }\n            $self->element(\n                {\n                    'Name' => 'Hit_signif',\n                    'Data' => $v ? $v->{evalue} : $e\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hit_score',\n                    'Data' => $v ? $v->{bits} : $bits\n                }\n            );\n            $self->start_element( { 'Name' => 'Hsp' } );\n\n            $self->element(\n                {\n                    'Name' => 'Hsp_score',\n                    'Data' => $v ? $v->{'z-sc'} : $score\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_evalue',\n                    'Data' => $v ? $v->{evalue} : $e\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_bit-score',\n                    'Data' => $v ? $v->{bits} : $bits\n                }\n            );\n            $_ = $self->_readline();\n\n            if (s/Smith-Waterman score:\\s*(\\d+)\\;?//) {\n                $self->element(\n                    {\n                        'Name' => 'Hsp_sw-score',\n                        'Data' => $1\n                    }\n                );\n            }\n            if (\n                / (\\d*\\.?\\d+)\\% \\s* identity\n                 (?:\\s* \\(\\s*(\\S+)\\% \\s* (?:ungapped|similar) \\) )?\n                 \\s* in \\s* (\\d+) \\s+ (?:aa|nt) \\s+ overlap \\s*\n                 \\( (\\d+) \\- (\\d+) : (\\d+) \\- (\\d+) \\)\n               /x\n              )\n            {\n                my ( $identper, $gapper, $len, $querystart, $queryend,\n                    $hitstart, $hitend )\n                  = ( $1, $2, $3, $4, $5, $6, $7 );\n                my $ident = sprintf( \"%.0f\", ( $identper / 100 ) * $len );\n                my $positive = sprintf( \"%.0f\", ( $gapper / 100 ) * $len );\n\n                $self->element(\n                    {\n                        'Name' => 'Hsp_identity',\n                        'Data' => $ident\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'Hsp_positive',\n                        'Data' => $positive\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'Hsp_align-len',\n                        'Data' => $len\n                    }\n                );\n\n                $self->element(\n                    {\n                        'Name' => 'Hsp_query-from',\n                        'Data' => $querystart\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'Hsp_query-to',\n                        'Data' => $queryend\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'Hsp_hit-from',\n                        'Data' => $hitstart\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'Hsp_hit-to',\n                        'Data' => $hitend\n                    }\n                );\n\n            }\n\n            if ($v) {\n                $self->element(\n                    { 'Name' => 'Hsp_querygaps', 'Data' => $v->{qgaps} } )\n                  if exists $v->{qgaps};\n                $self->element(\n                    { 'Name' => 'Hsp_hitgaps', 'Data' => $v->{lgaps} } )\n                  if exists $v->{lgaps};\n\n                if ( $self->{'_reporttype'} =~ m/^FAST[NXY]$/o ) {\n                    if ( 8 == scalar grep { exists $v->{$_} }\n                        qw(an0 ax0 pn0 px0 an1 ax1 pn1 px1) )\n                    {\n                        if ( $v->{ax0} < $v->{an0} ) {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_query-frame',\n                                    'Data' =>\n                                      \"-@{[(($v->{px0} - $v->{ax0}) % 3) + 1]}\"\n                                }\n                            );\n                        }\n                        else {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_query-frame',\n                                    'Data' =>\n                                      \"+@{[(($v->{an0} - $v->{pn0}) % 3) + 1]}\"\n                                }\n                            );\n                        }\n                        if ( $v->{ax1} < $v->{an1} ) {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_hit-frame',\n                                    'Data' =>\n                                      \"-@{[(($v->{px1} - $v->{ax1}) % 3) + 1]}\"\n                                }\n                            );\n                        }\n                        else {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_hit-frame',\n                                    'Data' =>\n                                      \"+@{[(($v->{an1} - $v->{pn1}) % 3) + 1]}\"\n                                }\n                            );\n                        }\n                    }\n                    else {\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_query-frame',\n                                'Data' => $v->{lframe}\n                            }\n                        );\n                        $self->element(\n                            { 'Name' => 'Hsp_hit-frame', 'Data' => 0 } );\n                    }\n                }\n                else {\n                    $self->element(\n                        { 'Name' => 'Hsp_query-frame', 'Data' => 0 } );\n                    $self->element(\n                        { 'Name' => 'Hsp_hit-frame', 'Data' => $v->{lframe} } );\n                }\n\n            }\n            else {\n                $self->warn(\"unable to parse FASTA score line: $_\");\n            }\n        }\n        elsif (/\\d+\\s*residues\\s*in\\s*\\d+\\s*query\\s*sequences/) {\n            if ( $self->in_element('hsp') ) {\n                $self->end_element( { 'Name' => 'Hsp' } );\n            }\n            if ( $self->in_element('hit') ) {\n                $self->end_element( { 'Name' => 'Hit' } );\n            }\n\n           #       $_ = $self->_readline();\n           #       my ( $liblen,$libsize) = /(\\d+)\\s+residues\\s*in(\\d+)\\s*library/;\n           # fast forward to the end of the file as there is\n           # nothing else left to do with this file and want to be sure and\n           # reset it\n            while ( defined( $_ = $self->_readline() ) ) {\n                last if (/^Function used was/);\n                if (\n                    /(\\S+)\\s+searches\\s+a\\s+(protein\\s+or\\s+DNA\\s+)?\n           sequence/oxi || /(\\S+)\\s+compares\\s+a/oi\n                  )\n                {\n                    $self->_pushback($_);\n                }\n            }\n\n            if (@hit_signifs) {\n\n                # process remaining best hits\n                for my $h (@hit_signifs) {\n\n                    # Hsp_score Hsp_evalue Hsp_bit-score\n                    # Hsp_sw-score Hsp_gaps Hsp_identity Hsp_positive\n                    # Hsp_align-len Hsp_query-from Hsp_query-to\n                    # Hsp_hit-from Hsp_hit-to Hsp_qseq Hsp_midline\n\n                    $self->start_element( { 'Name' => 'Hit' } );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_len',\n                            'Data' => $h->{hit_len}\n                        }\n                    ) if exists $h->{hit_len};\n                    $self->element(\n                        {\n                            'Name' => 'Hit_id',\n                            'Data' => $h->{id}\n                        }\n                    ) if exists $h->{id};\n                    $self->element(\n                        {\n                            'Name' => 'Hit_accession',\n                            'Data' => $h->{acc}\n                        }\n                    ) if exists $h->{acc};\n                    $self->element(\n                        {\n                            'Name' => 'Hit_def',\n                            'Data' => $h->{desc}\n                        }\n                    ) if exists $h->{desc};\n                    $self->element(\n                        {\n                            'Name' => 'Hit_signif',\n                            'Data' => $h->{evalue}\n                        }\n                    ) if exists $h->{evalue};\n                    $self->element(\n                        {\n                            'Name' => 'Hit_score',\n                            'Data' => $h->{bits}\n                        }\n                    ) if exists $h->{bits};\n\n                    $self->start_element( { 'Name' => 'Hsp' } );\n                    $self->element(\n                        { 'Name' => 'Hsp_score', 'Data' => $h->{'z-sc'} } )\n                      if exists $h->{'z-sc'};\n                    $self->element(\n                        { 'Name' => 'Hsp_evalue', 'Data' => $h->{evalue} } )\n                      if exists $h->{evalue};\n                    $self->element(\n                        { 'Name' => 'Hsp_bit-score', 'Data' => $h->{bits} } )\n                      if exists $h->{bits};\n                    $self->element(\n                        { 'Name' => 'Hsp_sw-score', 'Data' => $h->{sw} } )\n                      if exists $h->{sw};\n                    $self->element(\n                        { 'Name' => 'Hsp_gaps', 'Data' => $h->{'%_gid'} } )\n                      if exists $h->{'%_gid'};\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_identity',\n                            'Data' =>\n                              sprintf( \"%.0f\", $h->{'%_id'} * $h->{alen} )\n                        }\n                    ) if ( exists $h->{'%_id'} && exists $h->{alen} );\n\n                    if ( exists $h->{'%_gid'} ) {\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_positive',\n                                'Data' =>\n                                  sprintf( \"%.0f\", $h->{'%_gid'} * $h->{alen} )\n                            }\n                        ) if exists $h->{'%_gid'} && exists $h->{alen};\n                    }\n                    else {\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_positive',\n                                'Data' =>\n                                  sprintf( \"%.0f\", $h->{'%_id'} * $h->{alen} )\n                            }\n                        ) if ( exists $h->{'%_id'} && exists $h->{alen} );\n                    }\n                    $self->element(\n                        { 'Name' => 'Hsp_align-len', 'Data' => $h->{alen} } )\n                      if exists $h->{alen};\n                    $self->element(\n                        { 'Name' => 'Hsp_query-from', 'Data' => $h->{an0} } )\n                      if exists $h->{an0};\n                    $self->element(\n                        { 'Name' => 'Hsp_query-to', 'Data' => $h->{ax0} } )\n                      if exists $h->{ax0};\n                    $self->element(\n                        { 'Name' => 'Hsp_hit-from', 'Data' => $h->{an1} } )\n                      if exists $h->{an1};\n                    $self->element(\n                        { 'Name' => 'Hsp_hit-to', 'Data' => $h->{ax1} } )\n                      if exists $h->{ax1};\n\n                    $self->element(\n                        { 'Name' => 'Hsp_querygaps', 'Data' => $h->{qgaps} } )\n                      if exists $h->{qgaps};\n                    $self->element(\n                        { 'Name' => 'Hsp_hitgaps', 'Data' => $h->{lgaps} } )\n                      if exists $h->{lgaps};\n\n                    if ( $self->{'_reporttype'} =~ m/^FAST[NXY]$/o ) {\n                        if ( 8 == scalar grep { exists $h->{$_} }\n                            qw(an0 ax0 pn0 px0 an1 ax1 pn1 px1) )\n                        {\n                            if ( $h->{ax0} < $h->{an0} ) {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_query-frame',\n                                        'Data' =>\n\"-@{[(($h->{px0} - $h->{ax0}) % 3) + 1]}\"\n                                    }\n                                );\n                            }\n                            else {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_query-frame',\n                                        'Data' =>\n\"+@{[(($h->{an0} - $h->{pn0}) % 3) + 1]}\"\n                                    }\n                                );\n                            }\n                            if ( $h->{ax1} < $h->{an1} ) {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_hit-frame',\n                                        'Data' =>\n\"-@{[(($h->{px1} - $h->{ax1}) % 3) + 1]}\"\n                                    }\n                                );\n                            }\n                            else {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_hit-frame',\n                                        'Data' =>\n\"+@{[(($h->{an1} - $h->{pn1}) % 3) + 1]}\"\n                                    }\n                                );\n                            }\n                        }\n                        else {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_query-frame',\n                                    'Data' => $h->{lframe}\n                                }\n                            );\n                            $self->element(\n                                { 'Name' => 'Hsp_hit-frame', 'Data' => 0 } );\n                        }\n                    }\n                    else {\n                        $self->element(\n                            { 'Name' => 'Hsp_query-frame', 'Data' => 0 } );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_hit-frame',\n                                'Data' => $h->{lframe}\n                            }\n                        );\n                    }\n\n                    $self->end_element( { 'Name' => 'Hsp' } );\n                    $self->end_element( { 'Name' => 'Hit' } );\n                }\n            }\n            $self->end_element( { 'Name' => 'FastaOutput' } );\n            return $self->end_document();\n        }\n        elsif (/^\\s*\\d+\\s*>>>/) {\n            if ( $self->within_element('FastaOutput') ) {\n                if ( $self->in_element('hsp') ) {\n                    $self->end_element( { 'Name' => 'Hsp' } );\n                }\n                if ( $self->in_element('hit') ) {\n                    $self->end_element( { 'Name' => 'Hit' } );\n                }\n\n                if (@hit_signifs) {\n\n                    # process remaining best hits\n                    for my $h (@hit_signifs) {\n                        $self->start_element( { 'Name' => 'Hit' } );\n                        $self->element(\n                            {\n                                'Name' => 'Hit_len',\n                                'Data' => $h->{hit_len}\n                            }\n                        ) if exists $h->{hit_len};\n                        $self->element(\n                            {\n                                'Name' => 'Hit_id',\n                                'Data' => $h->{id}\n                            }\n                        ) if exists $h->{id};\n                        $self->element(\n                            {\n                                'Name' => 'Hit_accession',\n                                'Data' => $h->{acc}\n                            }\n                        ) if exists $h->{acc};\n                        $self->element(\n                            {\n                                'Name' => 'Hit_def',\n                                'Data' => $h->{desc}\n                            }\n                        ) if exists $h->{desc};\n                        $self->element(\n                            {\n                                'Name' => 'Hit_signif',\n                                'Data' => $h->{evalue}\n                            }\n                        ) if exists $h->{evalue};\n                        $self->element(\n                            {\n                                'Name' => 'Hit_score',\n                                'Data' => $h->{bits}\n                            }\n                        ) if exists $h->{bits};\n\n                        $self->start_element( { 'Name' => 'Hsp' } );\n                        $self->element(\n                            { 'Name' => 'Hsp_score', 'Data' => $h->{'z-sc'} } )\n                          if exists $h->{'z-sc'};\n                        $self->element(\n                            { 'Name' => 'Hsp_evalue', 'Data' => $h->{evalue} } )\n                          if exists $h->{evalue};\n                        $self->element(\n                            { 'Name' => 'Hsp_bit-score', 'Data' => $h->{bits} }\n                        ) if exists $h->{bits};\n                        $self->element(\n                            { 'Name' => 'Hsp_sw-score', 'Data' => $h->{sw} } )\n                          if exists $h->{sw};\n                        $self->element(\n                            { 'Name' => 'Hsp_gaps', 'Data' => $h->{'%_gid'} } )\n                          if exists $h->{'%_gid'};\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_identity',\n                                'Data' =>\n                                  sprintf( \"%.0f\", $h->{'%_id'} * $h->{alen} )\n                            }\n                        ) if ( exists $h->{'%_id'} && exists $h->{alen} );\n\n                        if ( exists $h->{'%_gid'} ) {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_positive',\n                                    'Data' => sprintf( \"%.0f\",\n                                        $h->{'%_gid'} * $h->{alen} )\n                                }\n                            ) if exists $h->{'%_gid'} && exists $h->{alen};\n                        }\n                        else {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_positive',\n                                    'Data' => sprintf( \"%.0f\",\n                                        $h->{'%_id'} * $h->{alen} )\n                                }\n                            ) if ( exists $h->{'%_id'} && exists $h->{alen} );\n                        }\n                        $self->element(\n                            { 'Name' => 'Hsp_align-len', 'Data' => $h->{alen} }\n                        ) if exists $h->{alen};\n                        $self->element(\n                            { 'Name' => 'Hsp_query-from', 'Data' => $h->{an0} }\n                        ) if exists $h->{an0};\n                        $self->element(\n                            { 'Name' => 'Hsp_query-to', 'Data' => $h->{ax0} } )\n                          if exists $h->{ax0};\n                        $self->element(\n                            { 'Name' => 'Hsp_hit-from', 'Data' => $h->{an1} } )\n                          if exists $h->{an1};\n                        $self->element(\n                            { 'Name' => 'Hsp_hit-to', 'Data' => $h->{ax1} } )\n                          if exists $h->{ax1};\n\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_querygaps',\n                                'Data' => $h->{qgaps}\n                            }\n                        ) if exists $h->{qgaps};\n                        $self->element(\n                            { 'Name' => 'Hsp_hitgaps', 'Data' => $h->{lgaps} } )\n                          if exists $h->{lgaps};\n\n                        if ( $self->{'_reporttype'} =~ m/^FAST[NXY]$/o ) {\n                            if ( 8 == scalar grep { exists $h->{$_} }\n                                qw(an0 ax0 pn0 px0 an1 ax1 pn1 px1) )\n                            {\n                                if ( $h->{ax0} < $h->{an0} ) {\n                                    $self->element(\n                                        {\n                                            'Name' => 'Hsp_query-frame',\n                                            'Data' => \"-@{[(($h->{px0} - $h->{ax0}) % 3) + 1]}\"\n                                        }\n                                    );\n                                }\n                                else {\n                                    $self->element(\n                                        {\n                                            'Name' => 'Hsp_query-frame',\n                                            'Data' => \"+@{[(($h->{an0} - $h->{pn0}) % 3) + 1]}\"\n                                        }\n                                    );\n                                }\n                                if ( $h->{ax1} < $h->{an1} ) {\n                                    $self->element(\n                                        {\n                                            'Name' => 'Hsp_hit-frame',\n                                            'Data' => \"-@{[(($h->{px1} - $h->{ax1}) % 3) + 1]}\"\n                                        }\n                                    );\n                                }\n                                else {\n                                    $self->element(\n                                        {\n                                            'Name' => 'Hsp_hit-frame',\n                                            'Data' => \"+@{[(($h->{an1} - $h->{pn1}) % 3) + 1]}\"\n                                        }\n                                    );\n                                }\n                            }\n                            else {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_query-frame',\n                                        'Data' => $h->{lframe}\n                                    }\n                                );\n                                $self->element(\n                                    { 'Name' => 'Hsp_hit-frame', 'Data' => 0 }\n                                );\n                            }\n                        }\n                        else {\n                            $self->element(\n                                { 'Name' => 'Hsp_query-frame', 'Data' => 0 } );\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_hit-frame',\n                                    'Data' => $h->{lframe}\n                                }\n                            );\n                        }\n\n                        $self->end_element( { 'Name' => 'Hsp' } );\n                        $self->end_element( { 'Name' => 'Hit' } );\n                    }\n                }\n                $self->end_element( { 'Name' => 'FastaOutput' } );\n                $self->_pushback($_);\n                return $self->end_document();\n            }\n            else {\n                $self->start_element( { 'Name' => 'FastaOutput' } );\n                $self->{'_result_count'}++;\n                $seentop = 1;\n                $self->element(\n                    {\n                        'Name' => 'FastaOutput_program',\n                        'Data' => $self->{'_reporttype'}\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'FastaOutput_version',\n                        'Data' => $self->{'_version'}\n                    }\n                );\n\n                my ( $type, $querylen, $querytype, $querydef );\n\n                if (/^\\s*\\d+\\s*>>>(.*)/) {\n                    $querydef = $1;\n                    if ( $querydef =~ /^(.*?)\\s+(?:\\-\\s+)?(\\d+)\\s+(aa|nt).*$/o )\n                    {\n                        ( $querydef, $querylen, $querytype ) = ( $1, $2, $3 );\n                    }\n                }\n\n                if (   $self->{'_reporttype'}\n                    && $self->{'_reporttype'} eq 'FASTA' )\n                {\n                    if ( $querytype eq 'nt' ) {\n                        $self->{'_reporttype'} = 'FASTN';\n                    }\n                    elsif ( $querytype eq 'aa' ) {\n                        $self->{'_reporttype'} = 'FASTP';\n                    }\n                }\n                my ( $name, $descr ) =\n                  ( $querydef =~ m/^(\\S+)(?:\\s+(.*))?\\s*$/o );\n                $self->element(\n                    {\n                        'Name' => 'FastaOutput_query-def',\n                        'Data' => $name\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'FastaOutput_querydesc',\n                        'Data' => $descr\n                    }\n                );\n                if ($querylen) {\n                    $self->element(\n                        {\n                            'Name' => 'FastaOutput_query-len',\n                            'Data' => $querylen\n                        }\n                    );\n                }\n                else {\n                    $self->warn(\"unable to find and set query length\");\n                }\n                if ( defined( $_ = $self->_readline() )\n                    && ( /^\\s*vs\\s+(\\S+)/ || /^Library:\\s+(\\S+)/ ) )\n                {\n                    $self->element(\n                        {\n                            'Name' => 'FastaOutput_db',\n                            'Data' => $1\n                        }\n                    );\n                }\n\n            }\n        }\n        elsif ( $self->in_element('hsp') ) {\n            my @data  = ( [], [], [] );\n            my $count = 0;\n            my $len   = $self->idlength + 1;\n            my ($seq1_id);\n            while ( defined($_) ) {\n                chomp;\n                #$self->debug(\"$count $_\\n\");\n                if (/residues in \\d+\\s+query\\s+sequences/o) {\n                    $self->_pushback($_);\n                    last;\n                }\n                elsif (/^>>>\\*\\*\\*/o) {\n                    $self->end_element( { Name => \"Hsp\" } );\n                    last;\n                }\n                elsif (/^>>/o) {\n                    $self->_pushback($_);\n                    last;\n                }\n                elsif (/^\\s*\\d+\\s*>>>/o) {\n                    $self->_pushback($_);\n                    last;\n                }\n                if ( $count == 0 ) {\n                    if (/^(\\S+)\\s+/) {\n                        $self->_pushback($_);\n                        $count = 2;\n                    }\n                    elsif ( /^\\s+\\d+/ || /^\\s+$/ ) {\n\n                        # do nothing, this is really a 0 line\n                    }\n                    elsif ( length($_) == 0 ) {\n                        $count = -1;\n                    }\n                    else {\n                        $self->_pushback($_);\n                        $count = 0;\n                    }\n                }\n                elsif ( $count == 1 || $count == 3 ) {\n                    if (/^(\\S+)\\s+/) {\n                        $len = CORE::length($1) if $len < CORE::length($1);\n                        s/\\s+$//;    # trim trailing spaces,we don't want them\n                        push @{ $data[ $count - 1 ] }, substr( $_, $len );\n                    }\n                    elsif (/^\\s+(\\d+)/) {\n                        $count = -1;\n                        $self->_pushback($_);\n                    }\n                    elsif ( /^\\s+$/ || length($_) == 0 ) {\n                        $count = 5;\n\n                        # going to skip these\n                    }\n                    else {\n                        $self->throw(\n                            \"Unrecognized alignment line ($count) '$_'\");\n                    }\n                }\n                elsif ( $count == 2 ) {\n                    if (/^\\s+\\d+\\s+/) {\n                        $self->warn(\"$_\\n\") if $self->verbose > 0;\n\n                        # we are on a Subject part of the alignment\n                        # but we THOUGHT we were on the Query\n                        # move that last line to the proper place\n                        push @{ $data[2] }, pop @{ $data[0] };\n                        $count = 4;\n                    }\n                    else {\n\n                        # toss the first IDLENGTH characters of the line\n                        if ( length($_) >= $len ) {\n                            push @{ $data[ $count - 1 ] }, substr( $_, $len );\n                        }\n                    }\n                }\n                last if ( $count++ >= 5 );\n                $_ = $self->_readline();\n            }\n            if ( @{ $data[0] } || @{ $data[2] } ) {\n                $self->characters(\n                    {\n                        'Name' => 'Hsp_qseq',\n                        'Data' => join( '', @{ $data[0] } )\n                    }\n                );\n                $self->characters(\n                    {\n                        'Name' => 'Hsp_midline',\n                        'Data' => join( '', @{ $data[1] } )\n                    }\n                );\n                $self->characters(\n                    {\n                        'Name' => 'Hsp_hseq',\n                        'Data' => join( '', @{ $data[2] } )\n                    }\n                );\n            }\n        }\n        else {\n            if ( !$seentop ) {\n                $self->debug($_);\n                #$self->warn(\"unrecognized FASTA Family report file!\");\n                #return;\n            }\n        }\n    }\n    if ( $self->in_element('result') ) {\n        if ( $self->in_element('hsp') ) {\n            $self->end_element( { 'Name' => 'Hsp' } );\n        }\n        if ( $self->in_element('hit') ) {\n            $self->end_element( { 'Name' => 'Hit' } );\n        }\n        $self->end_element( { 'Name' => 'FastaOutput' } );\n    }\n    return $self->end_document();\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element {\n    my ( $self, $data ) = @_;\n\n    # we currently don't care about attributes\n    my $nm = $data->{'Name'};\n    if ( my $type = $MODEMAP{$nm} ) {\n        $self->_mode($type);\n        if ( my $handler = $self->_will_handle($type) ) {\n            my $func = sprintf( \"start_%s\", lc $type );\n            $handler->$func( $data->{'Attributes'} );\n        }\n        unshift @{ $self->{'_elements'} }, $type;\n    }\n    if ( $nm eq 'FastaOutput' ) {\n        $self->{'_values'} = {};\n        $self->{'_result'} = undef;\n        $self->{'_mode'}   = '';\n    }\n\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ( $self, $data ) = @_;\n    my $nm = $data->{'Name'};\n    my $rc;\n\n    # Hsp are sort of weird, in that they end when another\n    # object begins so have to detect this in end_element for now\n    if ( $nm eq 'Hsp' ) {\n        foreach (qw(Hsp_qseq Hsp_midline Hsp_hseq)) {\n            $self->element(\n                {\n                    'Name' => $_,\n                    'Data' => $self->{'_last_hspdata'}->{$_}\n                }\n            );\n        }\n        $self->{'_last_hspdata'} = {};\n    }\n\n    if ( my $type = $MODEMAP{$nm} ) {\n        if ( my $handler = $self->_will_handle($type) ) {\n            my $func = sprintf( \"end_%s\", lc $type );\n            $rc = $handler->$func( $self->{'_reporttype'}, $self->{'_values'} );\n        }\n        shift @{ $self->{'_elements'} };\n\n    }\n    elsif ( $MAPPING{$nm} ) {\n        if ( ref( $MAPPING{$nm} ) =~ /hash/i ) {\n            my $key = ( keys %{ $MAPPING{$nm} } )[0];\n            $self->{'_values'}->{$key}->{ $MAPPING{$nm}->{$key} } =\n              $self->{'_last_data'};\n        }\n        else {\n            $self->{'_values'}->{ $MAPPING{$nm} } = $self->{'_last_data'};\n        }\n    }\n    else {\n        $self->warn(\"unknown nm $nm, ignoring\\n\");\n    }\n    $self->{'_last_data'} = '';    # remove read data if we are at\n                                   # end of an element\n    $self->{'_result'} = $rc if ( $nm eq 'FastaOutput' );\n    return $rc;\n\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element {\n    my ( $self, $data ) = @_;\n    $self->start_element($data);\n    $self->characters($data);\n    $self->end_element($data);\n}\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string\n\n\n\nsub characters {\n    my ( $self, $data ) = @_;\n\n    return unless ( defined $data->{'Data'} );\n    if ( $data->{'Data'} =~ /^\\s+$/ ) {\n        return unless $data->{'Name'} =~ /Hsp\\_(midline|qseq|hseq)/;\n    }\n\n    if (   $self->in_element('hsp')\n        && $data->{'Name'} =~ /Hsp\\_(qseq|hseq|midline)/ )\n    {\n\n        $self->{'_last_hspdata'}->{ $data->{'Name'} } .= $data->{'Data'};\n    }\n\n    $self->{'_last_data'} = $data->{'Data'};\n}\n\n=head2 _mode\n\n Title   : _mode\n Usage   : $obj->_mode($newval)\n Function: \n Example : \n Returns : value of _mode\n Args    : newvalue (optional)\n\n\n\nsub _mode {\n    my ( $self, $value ) = @_;\n    if ( defined $value ) {\n        $self->{'_mode'} = $value;\n    }\n    return $self->{'_mode'};\n}\n\n=head2 within_element\n\n Title   : within_element\n Usage   : if( $eventgenerator->within_element($element) ) {}\n Function: Test if we are within a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name \n\n\n\nsub within_element {\n    my ( $self, $name ) = @_;\n    return 0\n      if (!defined $name && !defined $self->{'_elements'}\n        || scalar @{ $self->{'_elements'} } == 0 );\n    foreach ( @{ $self->{'_elements'} } ) {\n        if ( $_ eq $name || $_ eq $MODEMAP{$name} ) {\n            return 1;\n        }\n    }\n    return 0;\n}\n\n=head2 in_element\n\n Title   : in_element\n Usage   : if( $eventgenerator->in_element($element) ) {}\n Function: Test if we are in a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name \n\n\n\nsub in_element {\n    my ( $self, $name ) = @_;\n    return 0 if !defined $self->{'_elements'}->[0];\n    return (\n        $self->{'_elements'}->[0] eq $name\n          || ( exists $MODEMAP{$name}\n            && $self->{'_elements'}->[0] eq $MODEMAP{$name} )\n    );\n}\n\n=head2 start_document\n\n Title   : start_document\n Usage   : $eventgenerator->start_document\n Function: Handles a start document event\n Returns : none\n Args    : none","label":"start_document($self)"},"kind":12,"line":1615,"children":[{"line":1616,"kind":13,"localvar":"my","containerName":"start_document","name":"$self","definition":"my"},{"containerName":"start_document","name":"$self","line":1617,"kind":13},{"containerName":"start_document","name":"$self","kind":13,"line":1618},{"containerName":"start_document","name":"$self","line":1619,"kind":13},{"kind":13,"line":1620,"containerName":"start_document","name":"$self"},{"kind":13,"line":1621,"containerName":"start_document","name":"$self"}]},{"range":{"end":{"line":1638,"character":9999},"start":{"character":0,"line":1635}},"name":"end_document","children":[{"kind":13,"line":1636,"containerName":"end_document","name":"$self","definition":"my","localvar":"my"},{"name":"@args","containerName":"end_document","line":1636,"kind":13},{"containerName":"end_document","name":"$self","line":1637,"kind":13}],"line":1635,"kind":12,"signature":{"documentation":"1;\n# $Id: fasta.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::fasta\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::fasta - A SearchIO parser for FASTA results\n\n=head1 SYNOPSIS\n\n  # Do not use this object directly, use it through the SearchIO system\n   use Bio::SearchIO;\n   my $searchio = Bio::SearchIO->new(-format => 'fasta',\n                    -file   => 'report.FASTA');\n   while( my $result = $searchio->next_result ) {\n    # ... do what you would normally doi with Bio::SearchIO.\n   }\n\n=head1 DESCRIPTION\n\nThis object contains the event based parsing code for FASTA format\nreports.  It creates L<Bio::Search::HSP::FastaHSP> objects instead of\nL<Bio::Search::HSP::GenericHSP> for the HSP objects. \n\nThis module will parse -m 9 -d 0 output as well as default m 1 output\nfrom FASTA as well as SSEARCH.\n\nAlso see the SearchIO HOWTO:\nL<http://bioperl.open-bio.org/wiki/HOWTO:SearchIO>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich, Aaron Mackey\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::fasta;\nuse vars qw(%MODEMAP %MAPPING $IDLENGTH);\nuse strict;\n\n# Object preamble - inherits from Bio::Root::RootI\n\nuse Bio::Factory::ObjectFactory;\n\nBEGIN {\n\n    # Set IDLENGTH to a new value if you have\n    # compile FASTA with a different ID length\n    # (actually newest FASTA allows the setting of this\n    #  via -C parameter, default is 6)\n    $IDLENGTH = 6;\n\n    # mapping of NCBI Blast terms to Bioperl hash keys\n    %MODEMAP = (\n        'FastaOutput' => 'result',\n        'Hit'         => 'hit',\n        'Hsp'         => 'hsp'\n    );\n\n    # This should really be done more intelligently, like with\n    # XSLT\n\n    %MAPPING = (\n        'Hsp_bit-score'   => 'HSP-bits',\n        'Hsp_score'       => 'HSP-score',\n        'Hsp_sw-score'    => 'HSP-swscore',\n        'Hsp_evalue'      => 'HSP-evalue',\n        'Hsp_query-from'  => 'HSP-query_start',\n        'Hsp_query-to'    => 'HSP-query_end',\n        'Hsp_hit-from'    => 'HSP-hit_start',\n        'Hsp_hit-to'      => 'HSP-hit_end',\n        'Hsp_positive'    => 'HSP-conserved',\n        'Hsp_identity'    => 'HSP-identical',\n        'Hsp_gaps'        => 'HSP-hsp_gaps',\n        'Hsp_hitgaps'     => 'HSP-hit_gaps',\n        'Hsp_querygaps'   => 'HSP-query_gaps',\n        'Hsp_qseq'        => 'HSP-query_seq',\n        'Hsp_hseq'        => 'HSP-hit_seq',\n        'Hsp_midline'     => 'HSP-homology_seq',\n        'Hsp_align-len'   => 'HSP-hsp_length',\n        'Hsp_query-frame' => 'HSP-query_frame',\n        'Hsp_hit-frame'   => 'HSP-hit_frame',\n\n        'Hit_id'        => 'HIT-name',\n        'Hit_len'       => 'HIT-length',\n        'Hit_accession' => 'HIT-accession',\n        'Hit_def'       => 'HIT-description',\n        'Hit_signif'    => 'HIT-significance',\n        'Hit_score'     => 'HIT-score',\n\n        'FastaOutput_program'   => 'RESULT-algorithm_name',\n        'FastaOutput_version'   => 'RESULT-algorithm_version',\n        'FastaOutput_query-def' => 'RESULT-query_name',\n        'FastaOutput_querydesc' => 'RESULT-query_description',\n        'FastaOutput_query-len' => 'RESULT-query_length',\n        'FastaOutput_db'        => 'RESULT-database_name',\n        'FastaOutput_db-len'    => 'RESULT-database_entries',\n        'FastaOutput_db-let'    => 'RESULT-database_letters',\n\n        'Parameters_matrix'      => { 'RESULT-parameters' => 'matrix' },\n        'Parameters_expect'      => { 'RESULT-parameters' => 'expect' },\n        'Parameters_include'     => { 'RESULT-parameters' => 'include' },\n        'Parameters_sc-match'    => { 'RESULT-parameters' => 'match' },\n        'Parameters_sc-mismatch' => { 'RESULT-parameters' => 'mismatch' },\n        'Parameters_gap-open'    => { 'RESULT-parameters' => 'gapopen' },\n        'Parameters_gap-ext'     => { 'RESULT-parameters' => 'gapext' },\n        'Parameters_word-size'   => { 'RESULT-parameters' => 'wordsize' },\n        'Parameters_ktup'        => { 'RESULT-parameters' => 'ktup' },\n        'Parameters_filter'      => { 'RESULT-parameters' => 'filter' },\n        'Statistics_db-num'      => { 'RESULT-statistics' => 'dbentries' },\n        'Statistics_db-len'      => { 'RESULT-statistics' => 'dbletters' },\n        'Statistics_hsp-len'     => { 'RESULT-statistics' => 'hsplength' },\n        'Statistics_eff-space'   => { 'RESULT-statistics' => 'effectivespace' },\n        'Statistics_kappa'       => { 'RESULT-statistics' => 'kappa' },\n        'Statistics_lambda'      => { 'RESULT-statistics' => 'lambda' },\n        'Statistics_entropy'     => { 'RESULT-statistics' => 'entropy' },\n    );\n}\n\nuse base qw(Bio::SearchIO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::fasta->new();\n Function: Builds a new Bio::SearchIO::fasta object \n Returns : Bio::SearchIO::fasta\n Args    : -idlength - set ID length to something other \n                       than the default (7), this is only\n                       necessary if you have compiled FASTA\n                       with a new default id length to display\n                       in the HSP alignment blocks\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n    return unless @args;\n    my ($idlength) = $self->_rearrange( [qw(IDLENGTH)], @args );\n    $self->idlength( $idlength || $IDLENGTH );\n    $self->_eventHandler->register_factory(\n        'hsp',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::HSP::FastaHSP',\n            -interface => 'Bio::Search::HSP::HSPI'\n        )\n    );\n    return 1;\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    local $/ = \"\\n\";\n    local $_;\n\n    my $data    = '';\n    my $seentop = 0;\n    my $current_hsp;\n    $self->start_document();\n    my @hit_signifs;\n    while ( defined( $_ = $self->_readline ) ) {\n        next if ( !$self->in_element('hsp')\n            && /^\\s+$/ );    # skip empty lines\n        if (\n               m/(\\S+)\\s+searches\\s+a\\s+(protein\\s+or\\s+DNA\\s+)?sequence/oxi\n            || /(\\S+)\\s+compares\\s+a/\n            || (   m/^\\#\\s+/\n                && ( $_ = $self->_readline )\n                && /(\\S+)\\s+searches\\s+a\\s+(protein\\s+or\\s+DNA\\s+)?sequence/oxi\n                || /(\\S+)\\s+compares\\s+a/ )\n          )\n        {\n            if ($seentop) {\n                $self->_pushback($_);\n                $self->end_element( { 'Name' => 'FastaOutput' } );\n                return $self->end_document();\n            }\n            $self->{'_reporttype'} = $1;\n            $self->start_element( { 'Name' => 'FastaOutput' } );\n            $self->{'_result_count'}++;\n            $seentop = 1;\n            #$self->debug( \"reporttype is \" . $self->{'_reporttype'} . \"\\n\" );\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_program',\n                    'Data' => $self->{'_reporttype'}\n                }\n            );\n            $_ = $self->_readline();\n            my ($version) = (/version\\s+(\\S+)/);\n            $version = '' unless defined $version;\n            $self->{'_version'} = $version;\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_version',\n                    'Data' => $version\n                }\n            );\n\n            my ( $last, $leadin, $type, $querylen, $querytype, $querydef );\n\n            while ( defined( $_ = $self->_readline() ) ) {\n                if (\n                    /^ (\n                       (?:\\s+>) |             # fa33 lead-in\n                       (?:\\s*\\d+\\s*>>>)       # fa34 mlib lead-in\n                      )\n                      (.*)\n                   /x\n                  )\n                {\n                    ( $leadin, $querydef ) = ( $1, $2 );\n                    if ( $leadin =~ m/>>>/ ) {\n                        if ( $querydef =~\n                            /^(.*?)\\s+(?:\\-\\s+)?(\\d+)\\s+(aa|nt).*$/o )\n                        {\n                            ( $querydef, $querylen, $querytype ) =\n                              ( $1, $2, $3 );\n                            last;\n                        }\n                    }\n                    else {\n                        if ( $last =~ /(\\S+)[:,]\\s*(\\d+)\\s+(aa|nt)/ ) {\n                            ( $querylen, $querytype ) = ( $2, $3 );\n                            $querydef ||= $1;\n                            last;\n                        }\n                    }\n                }\n                elsif (m/^\\s*vs\\s+\\S+/o) {\n                    if ( $last =~ /(\\S+)[,:]\\s+(\\d+)\\s+(aa|nt)/o ) {\n                        ( $querydef, $querylen, $querytype ) = ( $1, $2, $3 );\n                        last;\n                    }\n                }\n                $last = $_;\n            }\n            if (   $self->{'_reporttype'}\n                && $self->{'_reporttype'} eq 'FASTA' )\n            {\n                if ( $querytype eq 'nt' ) {\n                    $self->{'_reporttype'} = 'FASTN';\n                }\n                elsif ( $querytype eq 'aa' ) {\n                    $self->{'_reporttype'} = 'FASTP';\n                }\n            }\n            my ( $name, $descr ) = $querydef =~ m/^(\\S+)\\s*(.*?)\\s*$/o;\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_query-def',\n                    'Data' => $name\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_querydesc',\n                    'Data' => $descr\n                }\n            );\n            if ($querylen) {\n                $self->element(\n                    {\n                        'Name' => 'FastaOutput_query-len',\n                        'Data' => $querylen\n                    }\n                );\n            }\n            else {\n                $self->warn(\"unable to find and set query length\");\n            }\n            if (\n                   $last =~ /^\\s*vs\\s+(\\S+)/\n                || ( $last =~ /^searching\\s+(\\S+)\\s+library/ )\n                || ( $last =~ /^Library:\\s+(\\S+)\\s+/ )\n                || (\n                    defined $_\n                    && (   /^\\s*vs\\s+(\\S+)/\n                        || /^Library:\\s+(\\S+)\\s+/ )\n                )\n                || ( defined( $_ = $self->_readline() )\n                    && ( /^\\s*vs\\s+(\\S+)/ || /^Library:\\s+(\\S+)/ ) )\n              )\n            {\n                $self->element(\n                    {\n                        'Name' => 'FastaOutput_db',\n                        'Data' => $1\n                    }\n                );\n            }\n            elsif (m/^\\s+opt(?:\\s+E\\(\\))?$/o) {\n\n           # histogram ... read over it more rapidly than the larger outer loop:\n                while ( defined( $_ = $self->_readline ) ) {\n                    last if m/^>\\d+/;\n                }\n            }\n        }\n        elsif (/(\\d+)\\s+residues\\s+in\\s+(\\d+)\\s+(?:library\\s+)?sequences/) {\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_db-let',\n                    'Data' => $1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_db-len',\n                    'Data' => $2\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Statistics_db-len',\n                    'Data' => $1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Statistics_db-num',\n                    'Data' => $2\n                }\n            );\n        }\n        elsif (/Lambda=\\s*(\\S+)/) {\n            $self->element(\n                {\n                    'Name' => 'Statistics_lambda',\n                    'Data' => $1\n                }\n            );\n        }\n        elsif (/K=\\s*(\\S+)/) {\n            $self->element(\n                {\n                    'Name' => 'Statistics_kappa',\n                    'Data' => $1\n                }\n            );\n        }\n        elsif (/^\\s*(Smith-Waterman).+(\\S+)\\s*matrix [^\\]]*?(xS)?\\]/) {\n            $self->element(\n                {\n                    'Name' => 'Parameters_matrix',\n                    'Data' => $2\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_filter',\n                    'Data' => defined $3 ? 1 : 0,\n                }\n            );\n            $self->{'_reporttype'} = $1;\n\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_program',\n                    'Data' => $self->{'_reporttype'}\n                }\n            );\n        }\n        elsif (/The best( related| unrelated)? scores are:/) {\n            my $rel    = $1;\n            my @labels = split;\n            @labels = map {\n                if ( $_ =~ m/^E\\((\\d+)\\)$/o )\n                {\n                    $self->element(\n                        { 'Name' => 'Statistics_eff-space', 'Data' => $1 } );\n                    \"evalue\";\n                }\n                else {\n                    $_;\n                }\n            } @labels[ $rel ? 5 : 4 .. $#labels ];\n\n            while ( defined( $_ = $self->_readline() )\n                && !/^\\s+$/ )\n            {\n                my @line = split;\n\n                if ( $line[-1] =~ m/\\=/o && $labels[-1] eq 'fs' ) {\n\n                    # unlabelled alignment hit;\n                    push @labels, \"aln_code\";\n                }\n\n                my %data;\n                @data{@labels} = splice( @line, @line - @labels );\n                if ( $line[-1] =~ m/\\[([1-6rf])\\]/o ) {\n                    my $fr = $1;\n                    $data{lframe} = (\n                        $fr =~ /\\d/o\n                        ? ( $fr <= 3 ? \"+$fr\" : \"-@{[$fr-3]}\" )\n                        : ( $fr eq 'f' ? '+1' : '-1' )\n                    );\n                    pop @line;\n                }\n                else {\n                    $data{lframe} = '0';\n                }\n\n                if ( $line[-1] =~ m/^\\(?(\\d+)\\)$/ ) {\n                    $data{hit_len} = $1;\n                    pop @line;\n                    if ( $line[-1] =~ m/^\\($/ ) {\n                        pop @line;\n                    }\n                }\n                else {\n                    $data{hit_len} = 0;\n                }\n\n                # rebuild the first part of the line, preserving spaces:\n                ($_) = m/^(\\S+(?:\\s+\\S+){$#line})/;\n\n                my ( $id, $desc ) = split( /\\s+/, $_, 2 );\n                my @pieces = split( /\\|/, $id );\n                my $acc = pop @pieces;\n                $acc =~ s/\\.\\d+$//;\n\n                @data{qw(id desc acc)} = ( $id, $desc, $acc );\n\n                push @hit_signifs, \\%data;\n            }\n        }\n        elsif (\n/^\\s*([T]?FAST[XYAF]).+,\\s*(\\S+)\\s*matrix[^\\]]+?(xS)?\\]\\s*ktup:\\s*(\\d+)/\n          )\n        {\n\n            $self->element(\n                {\n                    'Name' => 'Parameters_matrix',\n                    'Data' => $2\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_filter',\n                    'Data' => defined $3 ? 1 : 0,\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_ktup',\n                    'Data' => $4\n                }\n            );\n            $self->{'_reporttype'} = $1\n              if ( $self->{'_reporttype'} !~ /FAST[PN]/i );\n\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_program',\n                    'Data' => $self->{'_reporttype'}\n                }\n            );\n        }\n        elsif (/^Algorithm:\\s+(\\S+)\\s+\\(([^)]+)\\)\\s+(\\S+)/) {\n            $self->{'_reporttype'} = $1\n              if ( $self->{'_reporttype'} !~ /FAST[PN]/i );\n        }\n        elsif (\n            /^Parameters:\\s+(\\S+)\\s*matrix\\s*(?:\\(([^(]+?)\\))?\\s*ktup:\\s*(\\d+)/)\n        {    # FASTA 35.04\n            $self->element(\n                {\n                    'Name' => 'Parameters_matrix',\n                    'Data' => $1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_filter',\n                    'Data' => defined $2 ? $2 : 0,\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_ktup',\n                    'Data' => $3\n                }\n            );\n        }\n        elsif (\n/(?:gap\\-pen|open\\/ext):\\s+([\\-\\+]?\\d+)\\s*\\/\\s*([\\-\\+]?\\d+).+width:\\s+(\\d+)/\n          )\n        {\n            $self->element(\n                {\n                    'Name' => 'Parameters_gap-open',\n                    'Data' => $1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_gap-ext',\n                    'Data' => $2\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_word-size',\n                    'Data' => $3\n                }\n            );\n        }\n        elsif (/^>>(?!>)(.+?)\\s+(?:\\((\\d+)\\s*(aa|nt)\\))?$/) {\n            my ($hit_id, $len, $alphabet) = ($1, $2, $3);\n            if (!$len || !$alphabet) {\n                WRAPPED:\n                while (defined($_ = $self->_readline)) {\n                    if (/(.*?)\\s+\\((\\d+)\\s*(aa|nt)\\)/) {\n                        ($len, $alphabet) = ($2, $3);\n                        $hit_id .= $1 ? \" \".$1 : '';\n                        last WRAPPED;\n                    }\n                    if (/^>>(?!>)/) { # too far, throw\n                        $self->throw(\"Couldn't find length, bailing\");\n                    }\n                }\n            }\n            if ( $self->in_element('hsp') ) {\n                $self->end_element( { 'Name' => 'Hsp' } );\n            }\n            if ( $self->in_element('hit') ) {\n                $self->end_element( { 'Name' => 'Hit' } );\n            }\n\n            $self->start_element( { 'Name' => 'Hit' } );\n            $self->element(\n                {\n                    'Name' => 'Hit_len',\n                    'Data' => $len\n                }\n            );\n            my ( $id, $desc ) = split( /\\s+/, $hit_id, 2 );\n            $self->element(\n                {\n                    'Name' => 'Hit_id',\n                    'Data' => $id\n                }\n            );\n\n            #$self->debug(\"Hit ID is $id\\n\");\n            my @pieces = split( /\\|/, $id );\n            my $acc = pop @pieces;\n            $acc =~ s/\\.\\d+$//;\n            $self->element(\n                {\n                    'Name' => 'Hit_accession',\n                    'Data' => $acc\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hit_def',\n                    'Data' => $desc\n                }\n            );\n\n            $_ = $self->_readline();\n            my ( $score, $bits, $e ) = /Z-score: \\s* (\\S+) \\s*\n                               (?: bits: \\s* (\\S+) \\s+ )?\n                               (?: E|expect ) \\s* \\(\\) :? \\s*(\\S+)/ox;\n            $bits = $score unless defined $bits;\n\n            my $v = shift @hit_signifs;\n            if ( defined $v ) {\n                @{$v}{qw(evalue bits z-sc)} = ( $e, $bits, $score );\n            }\n            $self->element(\n                {\n                    'Name' => 'Hit_signif',\n                    'Data' => $v ? $v->{evalue} : $e\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hit_score',\n                    'Data' => $v ? $v->{bits} : $bits\n                }\n            );\n            $self->start_element( { 'Name' => 'Hsp' } );\n\n            $self->element(\n                {\n                    'Name' => 'Hsp_score',\n                    'Data' => $v ? $v->{'z-sc'} : $score\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_evalue',\n                    'Data' => $v ? $v->{evalue} : $e\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_bit-score',\n                    'Data' => $v ? $v->{bits} : $bits\n                }\n            );\n            $_ = $self->_readline();\n\n            if (s/Smith-Waterman score:\\s*(\\d+)\\;?//) {\n                $self->element(\n                    {\n                        'Name' => 'Hsp_sw-score',\n                        'Data' => $1\n                    }\n                );\n            }\n            if (\n                / (\\d*\\.?\\d+)\\% \\s* identity\n                 (?:\\s* \\(\\s*(\\S+)\\% \\s* (?:ungapped|similar) \\) )?\n                 \\s* in \\s* (\\d+) \\s+ (?:aa|nt) \\s+ overlap \\s*\n                 \\( (\\d+) \\- (\\d+) : (\\d+) \\- (\\d+) \\)\n               /x\n              )\n            {\n                my ( $identper, $gapper, $len, $querystart, $queryend,\n                    $hitstart, $hitend )\n                  = ( $1, $2, $3, $4, $5, $6, $7 );\n                my $ident = sprintf( \"%.0f\", ( $identper / 100 ) * $len );\n                my $positive = sprintf( \"%.0f\", ( $gapper / 100 ) * $len );\n\n                $self->element(\n                    {\n                        'Name' => 'Hsp_identity',\n                        'Data' => $ident\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'Hsp_positive',\n                        'Data' => $positive\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'Hsp_align-len',\n                        'Data' => $len\n                    }\n                );\n\n                $self->element(\n                    {\n                        'Name' => 'Hsp_query-from',\n                        'Data' => $querystart\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'Hsp_query-to',\n                        'Data' => $queryend\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'Hsp_hit-from',\n                        'Data' => $hitstart\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'Hsp_hit-to',\n                        'Data' => $hitend\n                    }\n                );\n\n            }\n\n            if ($v) {\n                $self->element(\n                    { 'Name' => 'Hsp_querygaps', 'Data' => $v->{qgaps} } )\n                  if exists $v->{qgaps};\n                $self->element(\n                    { 'Name' => 'Hsp_hitgaps', 'Data' => $v->{lgaps} } )\n                  if exists $v->{lgaps};\n\n                if ( $self->{'_reporttype'} =~ m/^FAST[NXY]$/o ) {\n                    if ( 8 == scalar grep { exists $v->{$_} }\n                        qw(an0 ax0 pn0 px0 an1 ax1 pn1 px1) )\n                    {\n                        if ( $v->{ax0} < $v->{an0} ) {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_query-frame',\n                                    'Data' =>\n                                      \"-@{[(($v->{px0} - $v->{ax0}) % 3) + 1]}\"\n                                }\n                            );\n                        }\n                        else {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_query-frame',\n                                    'Data' =>\n                                      \"+@{[(($v->{an0} - $v->{pn0}) % 3) + 1]}\"\n                                }\n                            );\n                        }\n                        if ( $v->{ax1} < $v->{an1} ) {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_hit-frame',\n                                    'Data' =>\n                                      \"-@{[(($v->{px1} - $v->{ax1}) % 3) + 1]}\"\n                                }\n                            );\n                        }\n                        else {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_hit-frame',\n                                    'Data' =>\n                                      \"+@{[(($v->{an1} - $v->{pn1}) % 3) + 1]}\"\n                                }\n                            );\n                        }\n                    }\n                    else {\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_query-frame',\n                                'Data' => $v->{lframe}\n                            }\n                        );\n                        $self->element(\n                            { 'Name' => 'Hsp_hit-frame', 'Data' => 0 } );\n                    }\n                }\n                else {\n                    $self->element(\n                        { 'Name' => 'Hsp_query-frame', 'Data' => 0 } );\n                    $self->element(\n                        { 'Name' => 'Hsp_hit-frame', 'Data' => $v->{lframe} } );\n                }\n\n            }\n            else {\n                $self->warn(\"unable to parse FASTA score line: $_\");\n            }\n        }\n        elsif (/\\d+\\s*residues\\s*in\\s*\\d+\\s*query\\s*sequences/) {\n            if ( $self->in_element('hsp') ) {\n                $self->end_element( { 'Name' => 'Hsp' } );\n            }\n            if ( $self->in_element('hit') ) {\n                $self->end_element( { 'Name' => 'Hit' } );\n            }\n\n           #       $_ = $self->_readline();\n           #       my ( $liblen,$libsize) = /(\\d+)\\s+residues\\s*in(\\d+)\\s*library/;\n           # fast forward to the end of the file as there is\n           # nothing else left to do with this file and want to be sure and\n           # reset it\n            while ( defined( $_ = $self->_readline() ) ) {\n                last if (/^Function used was/);\n                if (\n                    /(\\S+)\\s+searches\\s+a\\s+(protein\\s+or\\s+DNA\\s+)?\n           sequence/oxi || /(\\S+)\\s+compares\\s+a/oi\n                  )\n                {\n                    $self->_pushback($_);\n                }\n            }\n\n            if (@hit_signifs) {\n\n                # process remaining best hits\n                for my $h (@hit_signifs) {\n\n                    # Hsp_score Hsp_evalue Hsp_bit-score\n                    # Hsp_sw-score Hsp_gaps Hsp_identity Hsp_positive\n                    # Hsp_align-len Hsp_query-from Hsp_query-to\n                    # Hsp_hit-from Hsp_hit-to Hsp_qseq Hsp_midline\n\n                    $self->start_element( { 'Name' => 'Hit' } );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_len',\n                            'Data' => $h->{hit_len}\n                        }\n                    ) if exists $h->{hit_len};\n                    $self->element(\n                        {\n                            'Name' => 'Hit_id',\n                            'Data' => $h->{id}\n                        }\n                    ) if exists $h->{id};\n                    $self->element(\n                        {\n                            'Name' => 'Hit_accession',\n                            'Data' => $h->{acc}\n                        }\n                    ) if exists $h->{acc};\n                    $self->element(\n                        {\n                            'Name' => 'Hit_def',\n                            'Data' => $h->{desc}\n                        }\n                    ) if exists $h->{desc};\n                    $self->element(\n                        {\n                            'Name' => 'Hit_signif',\n                            'Data' => $h->{evalue}\n                        }\n                    ) if exists $h->{evalue};\n                    $self->element(\n                        {\n                            'Name' => 'Hit_score',\n                            'Data' => $h->{bits}\n                        }\n                    ) if exists $h->{bits};\n\n                    $self->start_element( { 'Name' => 'Hsp' } );\n                    $self->element(\n                        { 'Name' => 'Hsp_score', 'Data' => $h->{'z-sc'} } )\n                      if exists $h->{'z-sc'};\n                    $self->element(\n                        { 'Name' => 'Hsp_evalue', 'Data' => $h->{evalue} } )\n                      if exists $h->{evalue};\n                    $self->element(\n                        { 'Name' => 'Hsp_bit-score', 'Data' => $h->{bits} } )\n                      if exists $h->{bits};\n                    $self->element(\n                        { 'Name' => 'Hsp_sw-score', 'Data' => $h->{sw} } )\n                      if exists $h->{sw};\n                    $self->element(\n                        { 'Name' => 'Hsp_gaps', 'Data' => $h->{'%_gid'} } )\n                      if exists $h->{'%_gid'};\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_identity',\n                            'Data' =>\n                              sprintf( \"%.0f\", $h->{'%_id'} * $h->{alen} )\n                        }\n                    ) if ( exists $h->{'%_id'} && exists $h->{alen} );\n\n                    if ( exists $h->{'%_gid'} ) {\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_positive',\n                                'Data' =>\n                                  sprintf( \"%.0f\", $h->{'%_gid'} * $h->{alen} )\n                            }\n                        ) if exists $h->{'%_gid'} && exists $h->{alen};\n                    }\n                    else {\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_positive',\n                                'Data' =>\n                                  sprintf( \"%.0f\", $h->{'%_id'} * $h->{alen} )\n                            }\n                        ) if ( exists $h->{'%_id'} && exists $h->{alen} );\n                    }\n                    $self->element(\n                        { 'Name' => 'Hsp_align-len', 'Data' => $h->{alen} } )\n                      if exists $h->{alen};\n                    $self->element(\n                        { 'Name' => 'Hsp_query-from', 'Data' => $h->{an0} } )\n                      if exists $h->{an0};\n                    $self->element(\n                        { 'Name' => 'Hsp_query-to', 'Data' => $h->{ax0} } )\n                      if exists $h->{ax0};\n                    $self->element(\n                        { 'Name' => 'Hsp_hit-from', 'Data' => $h->{an1} } )\n                      if exists $h->{an1};\n                    $self->element(\n                        { 'Name' => 'Hsp_hit-to', 'Data' => $h->{ax1} } )\n                      if exists $h->{ax1};\n\n                    $self->element(\n                        { 'Name' => 'Hsp_querygaps', 'Data' => $h->{qgaps} } )\n                      if exists $h->{qgaps};\n                    $self->element(\n                        { 'Name' => 'Hsp_hitgaps', 'Data' => $h->{lgaps} } )\n                      if exists $h->{lgaps};\n\n                    if ( $self->{'_reporttype'} =~ m/^FAST[NXY]$/o ) {\n                        if ( 8 == scalar grep { exists $h->{$_} }\n                            qw(an0 ax0 pn0 px0 an1 ax1 pn1 px1) )\n                        {\n                            if ( $h->{ax0} < $h->{an0} ) {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_query-frame',\n                                        'Data' =>\n\"-@{[(($h->{px0} - $h->{ax0}) % 3) + 1]}\"\n                                    }\n                                );\n                            }\n                            else {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_query-frame',\n                                        'Data' =>\n\"+@{[(($h->{an0} - $h->{pn0}) % 3) + 1]}\"\n                                    }\n                                );\n                            }\n                            if ( $h->{ax1} < $h->{an1} ) {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_hit-frame',\n                                        'Data' =>\n\"-@{[(($h->{px1} - $h->{ax1}) % 3) + 1]}\"\n                                    }\n                                );\n                            }\n                            else {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_hit-frame',\n                                        'Data' =>\n\"+@{[(($h->{an1} - $h->{pn1}) % 3) + 1]}\"\n                                    }\n                                );\n                            }\n                        }\n                        else {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_query-frame',\n                                    'Data' => $h->{lframe}\n                                }\n                            );\n                            $self->element(\n                                { 'Name' => 'Hsp_hit-frame', 'Data' => 0 } );\n                        }\n                    }\n                    else {\n                        $self->element(\n                            { 'Name' => 'Hsp_query-frame', 'Data' => 0 } );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_hit-frame',\n                                'Data' => $h->{lframe}\n                            }\n                        );\n                    }\n\n                    $self->end_element( { 'Name' => 'Hsp' } );\n                    $self->end_element( { 'Name' => 'Hit' } );\n                }\n            }\n            $self->end_element( { 'Name' => 'FastaOutput' } );\n            return $self->end_document();\n        }\n        elsif (/^\\s*\\d+\\s*>>>/) {\n            if ( $self->within_element('FastaOutput') ) {\n                if ( $self->in_element('hsp') ) {\n                    $self->end_element( { 'Name' => 'Hsp' } );\n                }\n                if ( $self->in_element('hit') ) {\n                    $self->end_element( { 'Name' => 'Hit' } );\n                }\n\n                if (@hit_signifs) {\n\n                    # process remaining best hits\n                    for my $h (@hit_signifs) {\n                        $self->start_element( { 'Name' => 'Hit' } );\n                        $self->element(\n                            {\n                                'Name' => 'Hit_len',\n                                'Data' => $h->{hit_len}\n                            }\n                        ) if exists $h->{hit_len};\n                        $self->element(\n                            {\n                                'Name' => 'Hit_id',\n                                'Data' => $h->{id}\n                            }\n                        ) if exists $h->{id};\n                        $self->element(\n                            {\n                                'Name' => 'Hit_accession',\n                                'Data' => $h->{acc}\n                            }\n                        ) if exists $h->{acc};\n                        $self->element(\n                            {\n                                'Name' => 'Hit_def',\n                                'Data' => $h->{desc}\n                            }\n                        ) if exists $h->{desc};\n                        $self->element(\n                            {\n                                'Name' => 'Hit_signif',\n                                'Data' => $h->{evalue}\n                            }\n                        ) if exists $h->{evalue};\n                        $self->element(\n                            {\n                                'Name' => 'Hit_score',\n                                'Data' => $h->{bits}\n                            }\n                        ) if exists $h->{bits};\n\n                        $self->start_element( { 'Name' => 'Hsp' } );\n                        $self->element(\n                            { 'Name' => 'Hsp_score', 'Data' => $h->{'z-sc'} } )\n                          if exists $h->{'z-sc'};\n                        $self->element(\n                            { 'Name' => 'Hsp_evalue', 'Data' => $h->{evalue} } )\n                          if exists $h->{evalue};\n                        $self->element(\n                            { 'Name' => 'Hsp_bit-score', 'Data' => $h->{bits} }\n                        ) if exists $h->{bits};\n                        $self->element(\n                            { 'Name' => 'Hsp_sw-score', 'Data' => $h->{sw} } )\n                          if exists $h->{sw};\n                        $self->element(\n                            { 'Name' => 'Hsp_gaps', 'Data' => $h->{'%_gid'} } )\n                          if exists $h->{'%_gid'};\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_identity',\n                                'Data' =>\n                                  sprintf( \"%.0f\", $h->{'%_id'} * $h->{alen} )\n                            }\n                        ) if ( exists $h->{'%_id'} && exists $h->{alen} );\n\n                        if ( exists $h->{'%_gid'} ) {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_positive',\n                                    'Data' => sprintf( \"%.0f\",\n                                        $h->{'%_gid'} * $h->{alen} )\n                                }\n                            ) if exists $h->{'%_gid'} && exists $h->{alen};\n                        }\n                        else {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_positive',\n                                    'Data' => sprintf( \"%.0f\",\n                                        $h->{'%_id'} * $h->{alen} )\n                                }\n                            ) if ( exists $h->{'%_id'} && exists $h->{alen} );\n                        }\n                        $self->element(\n                            { 'Name' => 'Hsp_align-len', 'Data' => $h->{alen} }\n                        ) if exists $h->{alen};\n                        $self->element(\n                            { 'Name' => 'Hsp_query-from', 'Data' => $h->{an0} }\n                        ) if exists $h->{an0};\n                        $self->element(\n                            { 'Name' => 'Hsp_query-to', 'Data' => $h->{ax0} } )\n                          if exists $h->{ax0};\n                        $self->element(\n                            { 'Name' => 'Hsp_hit-from', 'Data' => $h->{an1} } )\n                          if exists $h->{an1};\n                        $self->element(\n                            { 'Name' => 'Hsp_hit-to', 'Data' => $h->{ax1} } )\n                          if exists $h->{ax1};\n\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_querygaps',\n                                'Data' => $h->{qgaps}\n                            }\n                        ) if exists $h->{qgaps};\n                        $self->element(\n                            { 'Name' => 'Hsp_hitgaps', 'Data' => $h->{lgaps} } )\n                          if exists $h->{lgaps};\n\n                        if ( $self->{'_reporttype'} =~ m/^FAST[NXY]$/o ) {\n                            if ( 8 == scalar grep { exists $h->{$_} }\n                                qw(an0 ax0 pn0 px0 an1 ax1 pn1 px1) )\n                            {\n                                if ( $h->{ax0} < $h->{an0} ) {\n                                    $self->element(\n                                        {\n                                            'Name' => 'Hsp_query-frame',\n                                            'Data' => \"-@{[(($h->{px0} - $h->{ax0}) % 3) + 1]}\"\n                                        }\n                                    );\n                                }\n                                else {\n                                    $self->element(\n                                        {\n                                            'Name' => 'Hsp_query-frame',\n                                            'Data' => \"+@{[(($h->{an0} - $h->{pn0}) % 3) + 1]}\"\n                                        }\n                                    );\n                                }\n                                if ( $h->{ax1} < $h->{an1} ) {\n                                    $self->element(\n                                        {\n                                            'Name' => 'Hsp_hit-frame',\n                                            'Data' => \"-@{[(($h->{px1} - $h->{ax1}) % 3) + 1]}\"\n                                        }\n                                    );\n                                }\n                                else {\n                                    $self->element(\n                                        {\n                                            'Name' => 'Hsp_hit-frame',\n                                            'Data' => \"+@{[(($h->{an1} - $h->{pn1}) % 3) + 1]}\"\n                                        }\n                                    );\n                                }\n                            }\n                            else {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_query-frame',\n                                        'Data' => $h->{lframe}\n                                    }\n                                );\n                                $self->element(\n                                    { 'Name' => 'Hsp_hit-frame', 'Data' => 0 }\n                                );\n                            }\n                        }\n                        else {\n                            $self->element(\n                                { 'Name' => 'Hsp_query-frame', 'Data' => 0 } );\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_hit-frame',\n                                    'Data' => $h->{lframe}\n                                }\n                            );\n                        }\n\n                        $self->end_element( { 'Name' => 'Hsp' } );\n                        $self->end_element( { 'Name' => 'Hit' } );\n                    }\n                }\n                $self->end_element( { 'Name' => 'FastaOutput' } );\n                $self->_pushback($_);\n                return $self->end_document();\n            }\n            else {\n                $self->start_element( { 'Name' => 'FastaOutput' } );\n                $self->{'_result_count'}++;\n                $seentop = 1;\n                $self->element(\n                    {\n                        'Name' => 'FastaOutput_program',\n                        'Data' => $self->{'_reporttype'}\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'FastaOutput_version',\n                        'Data' => $self->{'_version'}\n                    }\n                );\n\n                my ( $type, $querylen, $querytype, $querydef );\n\n                if (/^\\s*\\d+\\s*>>>(.*)/) {\n                    $querydef = $1;\n                    if ( $querydef =~ /^(.*?)\\s+(?:\\-\\s+)?(\\d+)\\s+(aa|nt).*$/o )\n                    {\n                        ( $querydef, $querylen, $querytype ) = ( $1, $2, $3 );\n                    }\n                }\n\n                if (   $self->{'_reporttype'}\n                    && $self->{'_reporttype'} eq 'FASTA' )\n                {\n                    if ( $querytype eq 'nt' ) {\n                        $self->{'_reporttype'} = 'FASTN';\n                    }\n                    elsif ( $querytype eq 'aa' ) {\n                        $self->{'_reporttype'} = 'FASTP';\n                    }\n                }\n                my ( $name, $descr ) =\n                  ( $querydef =~ m/^(\\S+)(?:\\s+(.*))?\\s*$/o );\n                $self->element(\n                    {\n                        'Name' => 'FastaOutput_query-def',\n                        'Data' => $name\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'FastaOutput_querydesc',\n                        'Data' => $descr\n                    }\n                );\n                if ($querylen) {\n                    $self->element(\n                        {\n                            'Name' => 'FastaOutput_query-len',\n                            'Data' => $querylen\n                        }\n                    );\n                }\n                else {\n                    $self->warn(\"unable to find and set query length\");\n                }\n                if ( defined( $_ = $self->_readline() )\n                    && ( /^\\s*vs\\s+(\\S+)/ || /^Library:\\s+(\\S+)/ ) )\n                {\n                    $self->element(\n                        {\n                            'Name' => 'FastaOutput_db',\n                            'Data' => $1\n                        }\n                    );\n                }\n\n            }\n        }\n        elsif ( $self->in_element('hsp') ) {\n            my @data  = ( [], [], [] );\n            my $count = 0;\n            my $len   = $self->idlength + 1;\n            my ($seq1_id);\n            while ( defined($_) ) {\n                chomp;\n                #$self->debug(\"$count $_\\n\");\n                if (/residues in \\d+\\s+query\\s+sequences/o) {\n                    $self->_pushback($_);\n                    last;\n                }\n                elsif (/^>>>\\*\\*\\*/o) {\n                    $self->end_element( { Name => \"Hsp\" } );\n                    last;\n                }\n                elsif (/^>>/o) {\n                    $self->_pushback($_);\n                    last;\n                }\n                elsif (/^\\s*\\d+\\s*>>>/o) {\n                    $self->_pushback($_);\n                    last;\n                }\n                if ( $count == 0 ) {\n                    if (/^(\\S+)\\s+/) {\n                        $self->_pushback($_);\n                        $count = 2;\n                    }\n                    elsif ( /^\\s+\\d+/ || /^\\s+$/ ) {\n\n                        # do nothing, this is really a 0 line\n                    }\n                    elsif ( length($_) == 0 ) {\n                        $count = -1;\n                    }\n                    else {\n                        $self->_pushback($_);\n                        $count = 0;\n                    }\n                }\n                elsif ( $count == 1 || $count == 3 ) {\n                    if (/^(\\S+)\\s+/) {\n                        $len = CORE::length($1) if $len < CORE::length($1);\n                        s/\\s+$//;    # trim trailing spaces,we don't want them\n                        push @{ $data[ $count - 1 ] }, substr( $_, $len );\n                    }\n                    elsif (/^\\s+(\\d+)/) {\n                        $count = -1;\n                        $self->_pushback($_);\n                    }\n                    elsif ( /^\\s+$/ || length($_) == 0 ) {\n                        $count = 5;\n\n                        # going to skip these\n                    }\n                    else {\n                        $self->throw(\n                            \"Unrecognized alignment line ($count) '$_'\");\n                    }\n                }\n                elsif ( $count == 2 ) {\n                    if (/^\\s+\\d+\\s+/) {\n                        $self->warn(\"$_\\n\") if $self->verbose > 0;\n\n                        # we are on a Subject part of the alignment\n                        # but we THOUGHT we were on the Query\n                        # move that last line to the proper place\n                        push @{ $data[2] }, pop @{ $data[0] };\n                        $count = 4;\n                    }\n                    else {\n\n                        # toss the first IDLENGTH characters of the line\n                        if ( length($_) >= $len ) {\n                            push @{ $data[ $count - 1 ] }, substr( $_, $len );\n                        }\n                    }\n                }\n                last if ( $count++ >= 5 );\n                $_ = $self->_readline();\n            }\n            if ( @{ $data[0] } || @{ $data[2] } ) {\n                $self->characters(\n                    {\n                        'Name' => 'Hsp_qseq',\n                        'Data' => join( '', @{ $data[0] } )\n                    }\n                );\n                $self->characters(\n                    {\n                        'Name' => 'Hsp_midline',\n                        'Data' => join( '', @{ $data[1] } )\n                    }\n                );\n                $self->characters(\n                    {\n                        'Name' => 'Hsp_hseq',\n                        'Data' => join( '', @{ $data[2] } )\n                    }\n                );\n            }\n        }\n        else {\n            if ( !$seentop ) {\n                $self->debug($_);\n                #$self->warn(\"unrecognized FASTA Family report file!\");\n                #return;\n            }\n        }\n    }\n    if ( $self->in_element('result') ) {\n        if ( $self->in_element('hsp') ) {\n            $self->end_element( { 'Name' => 'Hsp' } );\n        }\n        if ( $self->in_element('hit') ) {\n            $self->end_element( { 'Name' => 'Hit' } );\n        }\n        $self->end_element( { 'Name' => 'FastaOutput' } );\n    }\n    return $self->end_document();\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element {\n    my ( $self, $data ) = @_;\n\n    # we currently don't care about attributes\n    my $nm = $data->{'Name'};\n    if ( my $type = $MODEMAP{$nm} ) {\n        $self->_mode($type);\n        if ( my $handler = $self->_will_handle($type) ) {\n            my $func = sprintf( \"start_%s\", lc $type );\n            $handler->$func( $data->{'Attributes'} );\n        }\n        unshift @{ $self->{'_elements'} }, $type;\n    }\n    if ( $nm eq 'FastaOutput' ) {\n        $self->{'_values'} = {};\n        $self->{'_result'} = undef;\n        $self->{'_mode'}   = '';\n    }\n\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ( $self, $data ) = @_;\n    my $nm = $data->{'Name'};\n    my $rc;\n\n    # Hsp are sort of weird, in that they end when another\n    # object begins so have to detect this in end_element for now\n    if ( $nm eq 'Hsp' ) {\n        foreach (qw(Hsp_qseq Hsp_midline Hsp_hseq)) {\n            $self->element(\n                {\n                    'Name' => $_,\n                    'Data' => $self->{'_last_hspdata'}->{$_}\n                }\n            );\n        }\n        $self->{'_last_hspdata'} = {};\n    }\n\n    if ( my $type = $MODEMAP{$nm} ) {\n        if ( my $handler = $self->_will_handle($type) ) {\n            my $func = sprintf( \"end_%s\", lc $type );\n            $rc = $handler->$func( $self->{'_reporttype'}, $self->{'_values'} );\n        }\n        shift @{ $self->{'_elements'} };\n\n    }\n    elsif ( $MAPPING{$nm} ) {\n        if ( ref( $MAPPING{$nm} ) =~ /hash/i ) {\n            my $key = ( keys %{ $MAPPING{$nm} } )[0];\n            $self->{'_values'}->{$key}->{ $MAPPING{$nm}->{$key} } =\n              $self->{'_last_data'};\n        }\n        else {\n            $self->{'_values'}->{ $MAPPING{$nm} } = $self->{'_last_data'};\n        }\n    }\n    else {\n        $self->warn(\"unknown nm $nm, ignoring\\n\");\n    }\n    $self->{'_last_data'} = '';    # remove read data if we are at\n                                   # end of an element\n    $self->{'_result'} = $rc if ( $nm eq 'FastaOutput' );\n    return $rc;\n\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element {\n    my ( $self, $data ) = @_;\n    $self->start_element($data);\n    $self->characters($data);\n    $self->end_element($data);\n}\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string\n\n\n\nsub characters {\n    my ( $self, $data ) = @_;\n\n    return unless ( defined $data->{'Data'} );\n    if ( $data->{'Data'} =~ /^\\s+$/ ) {\n        return unless $data->{'Name'} =~ /Hsp\\_(midline|qseq|hseq)/;\n    }\n\n    if (   $self->in_element('hsp')\n        && $data->{'Name'} =~ /Hsp\\_(qseq|hseq|midline)/ )\n    {\n\n        $self->{'_last_hspdata'}->{ $data->{'Name'} } .= $data->{'Data'};\n    }\n\n    $self->{'_last_data'} = $data->{'Data'};\n}\n\n=head2 _mode\n\n Title   : _mode\n Usage   : $obj->_mode($newval)\n Function: \n Example : \n Returns : value of _mode\n Args    : newvalue (optional)\n\n\n\nsub _mode {\n    my ( $self, $value ) = @_;\n    if ( defined $value ) {\n        $self->{'_mode'} = $value;\n    }\n    return $self->{'_mode'};\n}\n\n=head2 within_element\n\n Title   : within_element\n Usage   : if( $eventgenerator->within_element($element) ) {}\n Function: Test if we are within a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name \n\n\n\nsub within_element {\n    my ( $self, $name ) = @_;\n    return 0\n      if (!defined $name && !defined $self->{'_elements'}\n        || scalar @{ $self->{'_elements'} } == 0 );\n    foreach ( @{ $self->{'_elements'} } ) {\n        if ( $_ eq $name || $_ eq $MODEMAP{$name} ) {\n            return 1;\n        }\n    }\n    return 0;\n}\n\n=head2 in_element\n\n Title   : in_element\n Usage   : if( $eventgenerator->in_element($element) ) {}\n Function: Test if we are in a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name \n\n\n\nsub in_element {\n    my ( $self, $name ) = @_;\n    return 0 if !defined $self->{'_elements'}->[0];\n    return (\n        $self->{'_elements'}->[0] eq $name\n          || ( exists $MODEMAP{$name}\n            && $self->{'_elements'}->[0] eq $MODEMAP{$name} )\n    );\n}\n\n=head2 start_document\n\n Title   : start_document\n Usage   : $eventgenerator->start_document\n Function: Handles a start document event\n Returns : none\n Args    : none\n\n\n\nsub start_document {\n    my ($self) = @_;\n    $self->{'_lasttype'} = '';\n    $self->{'_values'}   = {};\n    $self->{'_result'}   = undef;\n    $self->{'_mode'}     = '';\n    $self->{'_elements'} = [];\n}\n\n=head2 end_document\n\n Title   : end_document\n Usage   : $eventgenerator->end_document\n Function: Handles an end document event\n Returns : Bio::Search::Result::ResultI object\n Args    : none","parameters":[{"label":"$self"},{"label":"@args"}],"label":"end_document($self,@args)"},"detail":"($self,@args)","definition":"sub","containerName":"main::"},{"signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: fasta.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::fasta\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::fasta - A SearchIO parser for FASTA results\n\n=head1 SYNOPSIS\n\n  # Do not use this object directly, use it through the SearchIO system\n   use Bio::SearchIO;\n   my $searchio = Bio::SearchIO->new(-format => 'fasta',\n                    -file   => 'report.FASTA');\n   while( my $result = $searchio->next_result ) {\n    # ... do what you would normally doi with Bio::SearchIO.\n   }\n\n=head1 DESCRIPTION\n\nThis object contains the event based parsing code for FASTA format\nreports.  It creates L<Bio::Search::HSP::FastaHSP> objects instead of\nL<Bio::Search::HSP::GenericHSP> for the HSP objects. \n\nThis module will parse -m 9 -d 0 output as well as default m 1 output\nfrom FASTA as well as SSEARCH.\n\nAlso see the SearchIO HOWTO:\nL<http://bioperl.open-bio.org/wiki/HOWTO:SearchIO>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich, Aaron Mackey\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::fasta;\nuse vars qw(%MODEMAP %MAPPING $IDLENGTH);\nuse strict;\n\n# Object preamble - inherits from Bio::Root::RootI\n\nuse Bio::Factory::ObjectFactory;\n\nBEGIN {\n\n    # Set IDLENGTH to a new value if you have\n    # compile FASTA with a different ID length\n    # (actually newest FASTA allows the setting of this\n    #  via -C parameter, default is 6)\n    $IDLENGTH = 6;\n\n    # mapping of NCBI Blast terms to Bioperl hash keys\n    %MODEMAP = (\n        'FastaOutput' => 'result',\n        'Hit'         => 'hit',\n        'Hsp'         => 'hsp'\n    );\n\n    # This should really be done more intelligently, like with\n    # XSLT\n\n    %MAPPING = (\n        'Hsp_bit-score'   => 'HSP-bits',\n        'Hsp_score'       => 'HSP-score',\n        'Hsp_sw-score'    => 'HSP-swscore',\n        'Hsp_evalue'      => 'HSP-evalue',\n        'Hsp_query-from'  => 'HSP-query_start',\n        'Hsp_query-to'    => 'HSP-query_end',\n        'Hsp_hit-from'    => 'HSP-hit_start',\n        'Hsp_hit-to'      => 'HSP-hit_end',\n        'Hsp_positive'    => 'HSP-conserved',\n        'Hsp_identity'    => 'HSP-identical',\n        'Hsp_gaps'        => 'HSP-hsp_gaps',\n        'Hsp_hitgaps'     => 'HSP-hit_gaps',\n        'Hsp_querygaps'   => 'HSP-query_gaps',\n        'Hsp_qseq'        => 'HSP-query_seq',\n        'Hsp_hseq'        => 'HSP-hit_seq',\n        'Hsp_midline'     => 'HSP-homology_seq',\n        'Hsp_align-len'   => 'HSP-hsp_length',\n        'Hsp_query-frame' => 'HSP-query_frame',\n        'Hsp_hit-frame'   => 'HSP-hit_frame',\n\n        'Hit_id'        => 'HIT-name',\n        'Hit_len'       => 'HIT-length',\n        'Hit_accession' => 'HIT-accession',\n        'Hit_def'       => 'HIT-description',\n        'Hit_signif'    => 'HIT-significance',\n        'Hit_score'     => 'HIT-score',\n\n        'FastaOutput_program'   => 'RESULT-algorithm_name',\n        'FastaOutput_version'   => 'RESULT-algorithm_version',\n        'FastaOutput_query-def' => 'RESULT-query_name',\n        'FastaOutput_querydesc' => 'RESULT-query_description',\n        'FastaOutput_query-len' => 'RESULT-query_length',\n        'FastaOutput_db'        => 'RESULT-database_name',\n        'FastaOutput_db-len'    => 'RESULT-database_entries',\n        'FastaOutput_db-let'    => 'RESULT-database_letters',\n\n        'Parameters_matrix'      => { 'RESULT-parameters' => 'matrix' },\n        'Parameters_expect'      => { 'RESULT-parameters' => 'expect' },\n        'Parameters_include'     => { 'RESULT-parameters' => 'include' },\n        'Parameters_sc-match'    => { 'RESULT-parameters' => 'match' },\n        'Parameters_sc-mismatch' => { 'RESULT-parameters' => 'mismatch' },\n        'Parameters_gap-open'    => { 'RESULT-parameters' => 'gapopen' },\n        'Parameters_gap-ext'     => { 'RESULT-parameters' => 'gapext' },\n        'Parameters_word-size'   => { 'RESULT-parameters' => 'wordsize' },\n        'Parameters_ktup'        => { 'RESULT-parameters' => 'ktup' },\n        'Parameters_filter'      => { 'RESULT-parameters' => 'filter' },\n        'Statistics_db-num'      => { 'RESULT-statistics' => 'dbentries' },\n        'Statistics_db-len'      => { 'RESULT-statistics' => 'dbletters' },\n        'Statistics_hsp-len'     => { 'RESULT-statistics' => 'hsplength' },\n        'Statistics_eff-space'   => { 'RESULT-statistics' => 'effectivespace' },\n        'Statistics_kappa'       => { 'RESULT-statistics' => 'kappa' },\n        'Statistics_lambda'      => { 'RESULT-statistics' => 'lambda' },\n        'Statistics_entropy'     => { 'RESULT-statistics' => 'entropy' },\n    );\n}\n\nuse base qw(Bio::SearchIO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::fasta->new();\n Function: Builds a new Bio::SearchIO::fasta object \n Returns : Bio::SearchIO::fasta\n Args    : -idlength - set ID length to something other \n                       than the default (7), this is only\n                       necessary if you have compiled FASTA\n                       with a new default id length to display\n                       in the HSP alignment blocks\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n    return unless @args;\n    my ($idlength) = $self->_rearrange( [qw(IDLENGTH)], @args );\n    $self->idlength( $idlength || $IDLENGTH );\n    $self->_eventHandler->register_factory(\n        'hsp',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::HSP::FastaHSP',\n            -interface => 'Bio::Search::HSP::HSPI'\n        )\n    );\n    return 1;\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    local $/ = \"\\n\";\n    local $_;\n\n    my $data    = '';\n    my $seentop = 0;\n    my $current_hsp;\n    $self->start_document();\n    my @hit_signifs;\n    while ( defined( $_ = $self->_readline ) ) {\n        next if ( !$self->in_element('hsp')\n            && /^\\s+$/ );    # skip empty lines\n        if (\n               m/(\\S+)\\s+searches\\s+a\\s+(protein\\s+or\\s+DNA\\s+)?sequence/oxi\n            || /(\\S+)\\s+compares\\s+a/\n            || (   m/^\\#\\s+/\n                && ( $_ = $self->_readline )\n                && /(\\S+)\\s+searches\\s+a\\s+(protein\\s+or\\s+DNA\\s+)?sequence/oxi\n                || /(\\S+)\\s+compares\\s+a/ )\n          )\n        {\n            if ($seentop) {\n                $self->_pushback($_);\n                $self->end_element( { 'Name' => 'FastaOutput' } );\n                return $self->end_document();\n            }\n            $self->{'_reporttype'} = $1;\n            $self->start_element( { 'Name' => 'FastaOutput' } );\n            $self->{'_result_count'}++;\n            $seentop = 1;\n            #$self->debug( \"reporttype is \" . $self->{'_reporttype'} . \"\\n\" );\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_program',\n                    'Data' => $self->{'_reporttype'}\n                }\n            );\n            $_ = $self->_readline();\n            my ($version) = (/version\\s+(\\S+)/);\n            $version = '' unless defined $version;\n            $self->{'_version'} = $version;\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_version',\n                    'Data' => $version\n                }\n            );\n\n            my ( $last, $leadin, $type, $querylen, $querytype, $querydef );\n\n            while ( defined( $_ = $self->_readline() ) ) {\n                if (\n                    /^ (\n                       (?:\\s+>) |             # fa33 lead-in\n                       (?:\\s*\\d+\\s*>>>)       # fa34 mlib lead-in\n                      )\n                      (.*)\n                   /x\n                  )\n                {\n                    ( $leadin, $querydef ) = ( $1, $2 );\n                    if ( $leadin =~ m/>>>/ ) {\n                        if ( $querydef =~\n                            /^(.*?)\\s+(?:\\-\\s+)?(\\d+)\\s+(aa|nt).*$/o )\n                        {\n                            ( $querydef, $querylen, $querytype ) =\n                              ( $1, $2, $3 );\n                            last;\n                        }\n                    }\n                    else {\n                        if ( $last =~ /(\\S+)[:,]\\s*(\\d+)\\s+(aa|nt)/ ) {\n                            ( $querylen, $querytype ) = ( $2, $3 );\n                            $querydef ||= $1;\n                            last;\n                        }\n                    }\n                }\n                elsif (m/^\\s*vs\\s+\\S+/o) {\n                    if ( $last =~ /(\\S+)[,:]\\s+(\\d+)\\s+(aa|nt)/o ) {\n                        ( $querydef, $querylen, $querytype ) = ( $1, $2, $3 );\n                        last;\n                    }\n                }\n                $last = $_;\n            }\n            if (   $self->{'_reporttype'}\n                && $self->{'_reporttype'} eq 'FASTA' )\n            {\n                if ( $querytype eq 'nt' ) {\n                    $self->{'_reporttype'} = 'FASTN';\n                }\n                elsif ( $querytype eq 'aa' ) {\n                    $self->{'_reporttype'} = 'FASTP';\n                }\n            }\n            my ( $name, $descr ) = $querydef =~ m/^(\\S+)\\s*(.*?)\\s*$/o;\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_query-def',\n                    'Data' => $name\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_querydesc',\n                    'Data' => $descr\n                }\n            );\n            if ($querylen) {\n                $self->element(\n                    {\n                        'Name' => 'FastaOutput_query-len',\n                        'Data' => $querylen\n                    }\n                );\n            }\n            else {\n                $self->warn(\"unable to find and set query length\");\n            }\n            if (\n                   $last =~ /^\\s*vs\\s+(\\S+)/\n                || ( $last =~ /^searching\\s+(\\S+)\\s+library/ )\n                || ( $last =~ /^Library:\\s+(\\S+)\\s+/ )\n                || (\n                    defined $_\n                    && (   /^\\s*vs\\s+(\\S+)/\n                        || /^Library:\\s+(\\S+)\\s+/ )\n                )\n                || ( defined( $_ = $self->_readline() )\n                    && ( /^\\s*vs\\s+(\\S+)/ || /^Library:\\s+(\\S+)/ ) )\n              )\n            {\n                $self->element(\n                    {\n                        'Name' => 'FastaOutput_db',\n                        'Data' => $1\n                    }\n                );\n            }\n            elsif (m/^\\s+opt(?:\\s+E\\(\\))?$/o) {\n\n           # histogram ... read over it more rapidly than the larger outer loop:\n                while ( defined( $_ = $self->_readline ) ) {\n                    last if m/^>\\d+/;\n                }\n            }\n        }\n        elsif (/(\\d+)\\s+residues\\s+in\\s+(\\d+)\\s+(?:library\\s+)?sequences/) {\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_db-let',\n                    'Data' => $1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_db-len',\n                    'Data' => $2\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Statistics_db-len',\n                    'Data' => $1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Statistics_db-num',\n                    'Data' => $2\n                }\n            );\n        }\n        elsif (/Lambda=\\s*(\\S+)/) {\n            $self->element(\n                {\n                    'Name' => 'Statistics_lambda',\n                    'Data' => $1\n                }\n            );\n        }\n        elsif (/K=\\s*(\\S+)/) {\n            $self->element(\n                {\n                    'Name' => 'Statistics_kappa',\n                    'Data' => $1\n                }\n            );\n        }\n        elsif (/^\\s*(Smith-Waterman).+(\\S+)\\s*matrix [^\\]]*?(xS)?\\]/) {\n            $self->element(\n                {\n                    'Name' => 'Parameters_matrix',\n                    'Data' => $2\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_filter',\n                    'Data' => defined $3 ? 1 : 0,\n                }\n            );\n            $self->{'_reporttype'} = $1;\n\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_program',\n                    'Data' => $self->{'_reporttype'}\n                }\n            );\n        }\n        elsif (/The best( related| unrelated)? scores are:/) {\n            my $rel    = $1;\n            my @labels = split;\n            @labels = map {\n                if ( $_ =~ m/^E\\((\\d+)\\)$/o )\n                {\n                    $self->element(\n                        { 'Name' => 'Statistics_eff-space', 'Data' => $1 } );\n                    \"evalue\";\n                }\n                else {\n                    $_;\n                }\n            } @labels[ $rel ? 5 : 4 .. $#labels ];\n\n            while ( defined( $_ = $self->_readline() )\n                && !/^\\s+$/ )\n            {\n                my @line = split;\n\n                if ( $line[-1] =~ m/\\=/o && $labels[-1] eq 'fs' ) {\n\n                    # unlabelled alignment hit;\n                    push @labels, \"aln_code\";\n                }\n\n                my %data;\n                @data{@labels} = splice( @line, @line - @labels );\n                if ( $line[-1] =~ m/\\[([1-6rf])\\]/o ) {\n                    my $fr = $1;\n                    $data{lframe} = (\n                        $fr =~ /\\d/o\n                        ? ( $fr <= 3 ? \"+$fr\" : \"-@{[$fr-3]}\" )\n                        : ( $fr eq 'f' ? '+1' : '-1' )\n                    );\n                    pop @line;\n                }\n                else {\n                    $data{lframe} = '0';\n                }\n\n                if ( $line[-1] =~ m/^\\(?(\\d+)\\)$/ ) {\n                    $data{hit_len} = $1;\n                    pop @line;\n                    if ( $line[-1] =~ m/^\\($/ ) {\n                        pop @line;\n                    }\n                }\n                else {\n                    $data{hit_len} = 0;\n                }\n\n                # rebuild the first part of the line, preserving spaces:\n                ($_) = m/^(\\S+(?:\\s+\\S+){$#line})/;\n\n                my ( $id, $desc ) = split( /\\s+/, $_, 2 );\n                my @pieces = split( /\\|/, $id );\n                my $acc = pop @pieces;\n                $acc =~ s/\\.\\d+$//;\n\n                @data{qw(id desc acc)} = ( $id, $desc, $acc );\n\n                push @hit_signifs, \\%data;\n            }\n        }\n        elsif (\n/^\\s*([T]?FAST[XYAF]).+,\\s*(\\S+)\\s*matrix[^\\]]+?(xS)?\\]\\s*ktup:\\s*(\\d+)/\n          )\n        {\n\n            $self->element(\n                {\n                    'Name' => 'Parameters_matrix',\n                    'Data' => $2\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_filter',\n                    'Data' => defined $3 ? 1 : 0,\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_ktup',\n                    'Data' => $4\n                }\n            );\n            $self->{'_reporttype'} = $1\n              if ( $self->{'_reporttype'} !~ /FAST[PN]/i );\n\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_program',\n                    'Data' => $self->{'_reporttype'}\n                }\n            );\n        }\n        elsif (/^Algorithm:\\s+(\\S+)\\s+\\(([^)]+)\\)\\s+(\\S+)/) {\n            $self->{'_reporttype'} = $1\n              if ( $self->{'_reporttype'} !~ /FAST[PN]/i );\n        }\n        elsif (\n            /^Parameters:\\s+(\\S+)\\s*matrix\\s*(?:\\(([^(]+?)\\))?\\s*ktup:\\s*(\\d+)/)\n        {    # FASTA 35.04\n            $self->element(\n                {\n                    'Name' => 'Parameters_matrix',\n                    'Data' => $1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_filter',\n                    'Data' => defined $2 ? $2 : 0,\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_ktup',\n                    'Data' => $3\n                }\n            );\n        }\n        elsif (\n/(?:gap\\-pen|open\\/ext):\\s+([\\-\\+]?\\d+)\\s*\\/\\s*([\\-\\+]?\\d+).+width:\\s+(\\d+)/\n          )\n        {\n            $self->element(\n                {\n                    'Name' => 'Parameters_gap-open',\n                    'Data' => $1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_gap-ext',\n                    'Data' => $2\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_word-size',\n                    'Data' => $3\n                }\n            );\n        }\n        elsif (/^>>(?!>)(.+?)\\s+(?:\\((\\d+)\\s*(aa|nt)\\))?$/) {\n            my ($hit_id, $len, $alphabet) = ($1, $2, $3);\n            if (!$len || !$alphabet) {\n                WRAPPED:\n                while (defined($_ = $self->_readline)) {\n                    if (/(.*?)\\s+\\((\\d+)\\s*(aa|nt)\\)/) {\n                        ($len, $alphabet) = ($2, $3);\n                        $hit_id .= $1 ? \" \".$1 : '';\n                        last WRAPPED;\n                    }\n                    if (/^>>(?!>)/) { # too far, throw\n                        $self->throw(\"Couldn't find length, bailing\");\n                    }\n                }\n            }\n            if ( $self->in_element('hsp') ) {\n                $self->end_element( { 'Name' => 'Hsp' } );\n            }\n            if ( $self->in_element('hit') ) {\n                $self->end_element( { 'Name' => 'Hit' } );\n            }\n\n            $self->start_element( { 'Name' => 'Hit' } );\n            $self->element(\n                {\n                    'Name' => 'Hit_len',\n                    'Data' => $len\n                }\n            );\n            my ( $id, $desc ) = split( /\\s+/, $hit_id, 2 );\n            $self->element(\n                {\n                    'Name' => 'Hit_id',\n                    'Data' => $id\n                }\n            );\n\n            #$self->debug(\"Hit ID is $id\\n\");\n            my @pieces = split( /\\|/, $id );\n            my $acc = pop @pieces;\n            $acc =~ s/\\.\\d+$//;\n            $self->element(\n                {\n                    'Name' => 'Hit_accession',\n                    'Data' => $acc\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hit_def',\n                    'Data' => $desc\n                }\n            );\n\n            $_ = $self->_readline();\n            my ( $score, $bits, $e ) = /Z-score: \\s* (\\S+) \\s*\n                               (?: bits: \\s* (\\S+) \\s+ )?\n                               (?: E|expect ) \\s* \\(\\) :? \\s*(\\S+)/ox;\n            $bits = $score unless defined $bits;\n\n            my $v = shift @hit_signifs;\n            if ( defined $v ) {\n                @{$v}{qw(evalue bits z-sc)} = ( $e, $bits, $score );\n            }\n            $self->element(\n                {\n                    'Name' => 'Hit_signif',\n                    'Data' => $v ? $v->{evalue} : $e\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hit_score',\n                    'Data' => $v ? $v->{bits} : $bits\n                }\n            );\n            $self->start_element( { 'Name' => 'Hsp' } );\n\n            $self->element(\n                {\n                    'Name' => 'Hsp_score',\n                    'Data' => $v ? $v->{'z-sc'} : $score\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_evalue',\n                    'Data' => $v ? $v->{evalue} : $e\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_bit-score',\n                    'Data' => $v ? $v->{bits} : $bits\n                }\n            );\n            $_ = $self->_readline();\n\n            if (s/Smith-Waterman score:\\s*(\\d+)\\;?//) {\n                $self->element(\n                    {\n                        'Name' => 'Hsp_sw-score',\n                        'Data' => $1\n                    }\n                );\n            }\n            if (\n                / (\\d*\\.?\\d+)\\% \\s* identity\n                 (?:\\s* \\(\\s*(\\S+)\\% \\s* (?:ungapped|similar) \\) )?\n                 \\s* in \\s* (\\d+) \\s+ (?:aa|nt) \\s+ overlap \\s*\n                 \\( (\\d+) \\- (\\d+) : (\\d+) \\- (\\d+) \\)\n               /x\n              )\n            {\n                my ( $identper, $gapper, $len, $querystart, $queryend,\n                    $hitstart, $hitend )\n                  = ( $1, $2, $3, $4, $5, $6, $7 );\n                my $ident = sprintf( \"%.0f\", ( $identper / 100 ) * $len );\n                my $positive = sprintf( \"%.0f\", ( $gapper / 100 ) * $len );\n\n                $self->element(\n                    {\n                        'Name' => 'Hsp_identity',\n                        'Data' => $ident\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'Hsp_positive',\n                        'Data' => $positive\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'Hsp_align-len',\n                        'Data' => $len\n                    }\n                );\n\n                $self->element(\n                    {\n                        'Name' => 'Hsp_query-from',\n                        'Data' => $querystart\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'Hsp_query-to',\n                        'Data' => $queryend\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'Hsp_hit-from',\n                        'Data' => $hitstart\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'Hsp_hit-to',\n                        'Data' => $hitend\n                    }\n                );\n\n            }\n\n            if ($v) {\n                $self->element(\n                    { 'Name' => 'Hsp_querygaps', 'Data' => $v->{qgaps} } )\n                  if exists $v->{qgaps};\n                $self->element(\n                    { 'Name' => 'Hsp_hitgaps', 'Data' => $v->{lgaps} } )\n                  if exists $v->{lgaps};\n\n                if ( $self->{'_reporttype'} =~ m/^FAST[NXY]$/o ) {\n                    if ( 8 == scalar grep { exists $v->{$_} }\n                        qw(an0 ax0 pn0 px0 an1 ax1 pn1 px1) )\n                    {\n                        if ( $v->{ax0} < $v->{an0} ) {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_query-frame',\n                                    'Data' =>\n                                      \"-@{[(($v->{px0} - $v->{ax0}) % 3) + 1]}\"\n                                }\n                            );\n                        }\n                        else {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_query-frame',\n                                    'Data' =>\n                                      \"+@{[(($v->{an0} - $v->{pn0}) % 3) + 1]}\"\n                                }\n                            );\n                        }\n                        if ( $v->{ax1} < $v->{an1} ) {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_hit-frame',\n                                    'Data' =>\n                                      \"-@{[(($v->{px1} - $v->{ax1}) % 3) + 1]}\"\n                                }\n                            );\n                        }\n                        else {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_hit-frame',\n                                    'Data' =>\n                                      \"+@{[(($v->{an1} - $v->{pn1}) % 3) + 1]}\"\n                                }\n                            );\n                        }\n                    }\n                    else {\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_query-frame',\n                                'Data' => $v->{lframe}\n                            }\n                        );\n                        $self->element(\n                            { 'Name' => 'Hsp_hit-frame', 'Data' => 0 } );\n                    }\n                }\n                else {\n                    $self->element(\n                        { 'Name' => 'Hsp_query-frame', 'Data' => 0 } );\n                    $self->element(\n                        { 'Name' => 'Hsp_hit-frame', 'Data' => $v->{lframe} } );\n                }\n\n            }\n            else {\n                $self->warn(\"unable to parse FASTA score line: $_\");\n            }\n        }\n        elsif (/\\d+\\s*residues\\s*in\\s*\\d+\\s*query\\s*sequences/) {\n            if ( $self->in_element('hsp') ) {\n                $self->end_element( { 'Name' => 'Hsp' } );\n            }\n            if ( $self->in_element('hit') ) {\n                $self->end_element( { 'Name' => 'Hit' } );\n            }\n\n           #       $_ = $self->_readline();\n           #       my ( $liblen,$libsize) = /(\\d+)\\s+residues\\s*in(\\d+)\\s*library/;\n           # fast forward to the end of the file as there is\n           # nothing else left to do with this file and want to be sure and\n           # reset it\n            while ( defined( $_ = $self->_readline() ) ) {\n                last if (/^Function used was/);\n                if (\n                    /(\\S+)\\s+searches\\s+a\\s+(protein\\s+or\\s+DNA\\s+)?\n           sequence/oxi || /(\\S+)\\s+compares\\s+a/oi\n                  )\n                {\n                    $self->_pushback($_);\n                }\n            }\n\n            if (@hit_signifs) {\n\n                # process remaining best hits\n                for my $h (@hit_signifs) {\n\n                    # Hsp_score Hsp_evalue Hsp_bit-score\n                    # Hsp_sw-score Hsp_gaps Hsp_identity Hsp_positive\n                    # Hsp_align-len Hsp_query-from Hsp_query-to\n                    # Hsp_hit-from Hsp_hit-to Hsp_qseq Hsp_midline\n\n                    $self->start_element( { 'Name' => 'Hit' } );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_len',\n                            'Data' => $h->{hit_len}\n                        }\n                    ) if exists $h->{hit_len};\n                    $self->element(\n                        {\n                            'Name' => 'Hit_id',\n                            'Data' => $h->{id}\n                        }\n                    ) if exists $h->{id};\n                    $self->element(\n                        {\n                            'Name' => 'Hit_accession',\n                            'Data' => $h->{acc}\n                        }\n                    ) if exists $h->{acc};\n                    $self->element(\n                        {\n                            'Name' => 'Hit_def',\n                            'Data' => $h->{desc}\n                        }\n                    ) if exists $h->{desc};\n                    $self->element(\n                        {\n                            'Name' => 'Hit_signif',\n                            'Data' => $h->{evalue}\n                        }\n                    ) if exists $h->{evalue};\n                    $self->element(\n                        {\n                            'Name' => 'Hit_score',\n                            'Data' => $h->{bits}\n                        }\n                    ) if exists $h->{bits};\n\n                    $self->start_element( { 'Name' => 'Hsp' } );\n                    $self->element(\n                        { 'Name' => 'Hsp_score', 'Data' => $h->{'z-sc'} } )\n                      if exists $h->{'z-sc'};\n                    $self->element(\n                        { 'Name' => 'Hsp_evalue', 'Data' => $h->{evalue} } )\n                      if exists $h->{evalue};\n                    $self->element(\n                        { 'Name' => 'Hsp_bit-score', 'Data' => $h->{bits} } )\n                      if exists $h->{bits};\n                    $self->element(\n                        { 'Name' => 'Hsp_sw-score', 'Data' => $h->{sw} } )\n                      if exists $h->{sw};\n                    $self->element(\n                        { 'Name' => 'Hsp_gaps', 'Data' => $h->{'%_gid'} } )\n                      if exists $h->{'%_gid'};\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_identity',\n                            'Data' =>\n                              sprintf( \"%.0f\", $h->{'%_id'} * $h->{alen} )\n                        }\n                    ) if ( exists $h->{'%_id'} && exists $h->{alen} );\n\n                    if ( exists $h->{'%_gid'} ) {\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_positive',\n                                'Data' =>\n                                  sprintf( \"%.0f\", $h->{'%_gid'} * $h->{alen} )\n                            }\n                        ) if exists $h->{'%_gid'} && exists $h->{alen};\n                    }\n                    else {\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_positive',\n                                'Data' =>\n                                  sprintf( \"%.0f\", $h->{'%_id'} * $h->{alen} )\n                            }\n                        ) if ( exists $h->{'%_id'} && exists $h->{alen} );\n                    }\n                    $self->element(\n                        { 'Name' => 'Hsp_align-len', 'Data' => $h->{alen} } )\n                      if exists $h->{alen};\n                    $self->element(\n                        { 'Name' => 'Hsp_query-from', 'Data' => $h->{an0} } )\n                      if exists $h->{an0};\n                    $self->element(\n                        { 'Name' => 'Hsp_query-to', 'Data' => $h->{ax0} } )\n                      if exists $h->{ax0};\n                    $self->element(\n                        { 'Name' => 'Hsp_hit-from', 'Data' => $h->{an1} } )\n                      if exists $h->{an1};\n                    $self->element(\n                        { 'Name' => 'Hsp_hit-to', 'Data' => $h->{ax1} } )\n                      if exists $h->{ax1};\n\n                    $self->element(\n                        { 'Name' => 'Hsp_querygaps', 'Data' => $h->{qgaps} } )\n                      if exists $h->{qgaps};\n                    $self->element(\n                        { 'Name' => 'Hsp_hitgaps', 'Data' => $h->{lgaps} } )\n                      if exists $h->{lgaps};\n\n                    if ( $self->{'_reporttype'} =~ m/^FAST[NXY]$/o ) {\n                        if ( 8 == scalar grep { exists $h->{$_} }\n                            qw(an0 ax0 pn0 px0 an1 ax1 pn1 px1) )\n                        {\n                            if ( $h->{ax0} < $h->{an0} ) {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_query-frame',\n                                        'Data' =>\n\"-@{[(($h->{px0} - $h->{ax0}) % 3) + 1]}\"\n                                    }\n                                );\n                            }\n                            else {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_query-frame',\n                                        'Data' =>\n\"+@{[(($h->{an0} - $h->{pn0}) % 3) + 1]}\"\n                                    }\n                                );\n                            }\n                            if ( $h->{ax1} < $h->{an1} ) {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_hit-frame',\n                                        'Data' =>\n\"-@{[(($h->{px1} - $h->{ax1}) % 3) + 1]}\"\n                                    }\n                                );\n                            }\n                            else {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_hit-frame',\n                                        'Data' =>\n\"+@{[(($h->{an1} - $h->{pn1}) % 3) + 1]}\"\n                                    }\n                                );\n                            }\n                        }\n                        else {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_query-frame',\n                                    'Data' => $h->{lframe}\n                                }\n                            );\n                            $self->element(\n                                { 'Name' => 'Hsp_hit-frame', 'Data' => 0 } );\n                        }\n                    }\n                    else {\n                        $self->element(\n                            { 'Name' => 'Hsp_query-frame', 'Data' => 0 } );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_hit-frame',\n                                'Data' => $h->{lframe}\n                            }\n                        );\n                    }\n\n                    $self->end_element( { 'Name' => 'Hsp' } );\n                    $self->end_element( { 'Name' => 'Hit' } );\n                }\n            }\n            $self->end_element( { 'Name' => 'FastaOutput' } );\n            return $self->end_document();\n        }\n        elsif (/^\\s*\\d+\\s*>>>/) {\n            if ( $self->within_element('FastaOutput') ) {\n                if ( $self->in_element('hsp') ) {\n                    $self->end_element( { 'Name' => 'Hsp' } );\n                }\n                if ( $self->in_element('hit') ) {\n                    $self->end_element( { 'Name' => 'Hit' } );\n                }\n\n                if (@hit_signifs) {\n\n                    # process remaining best hits\n                    for my $h (@hit_signifs) {\n                        $self->start_element( { 'Name' => 'Hit' } );\n                        $self->element(\n                            {\n                                'Name' => 'Hit_len',\n                                'Data' => $h->{hit_len}\n                            }\n                        ) if exists $h->{hit_len};\n                        $self->element(\n                            {\n                                'Name' => 'Hit_id',\n                                'Data' => $h->{id}\n                            }\n                        ) if exists $h->{id};\n                        $self->element(\n                            {\n                                'Name' => 'Hit_accession',\n                                'Data' => $h->{acc}\n                            }\n                        ) if exists $h->{acc};\n                        $self->element(\n                            {\n                                'Name' => 'Hit_def',\n                                'Data' => $h->{desc}\n                            }\n                        ) if exists $h->{desc};\n                        $self->element(\n                            {\n                                'Name' => 'Hit_signif',\n                                'Data' => $h->{evalue}\n                            }\n                        ) if exists $h->{evalue};\n                        $self->element(\n                            {\n                                'Name' => 'Hit_score',\n                                'Data' => $h->{bits}\n                            }\n                        ) if exists $h->{bits};\n\n                        $self->start_element( { 'Name' => 'Hsp' } );\n                        $self->element(\n                            { 'Name' => 'Hsp_score', 'Data' => $h->{'z-sc'} } )\n                          if exists $h->{'z-sc'};\n                        $self->element(\n                            { 'Name' => 'Hsp_evalue', 'Data' => $h->{evalue} } )\n                          if exists $h->{evalue};\n                        $self->element(\n                            { 'Name' => 'Hsp_bit-score', 'Data' => $h->{bits} }\n                        ) if exists $h->{bits};\n                        $self->element(\n                            { 'Name' => 'Hsp_sw-score', 'Data' => $h->{sw} } )\n                          if exists $h->{sw};\n                        $self->element(\n                            { 'Name' => 'Hsp_gaps', 'Data' => $h->{'%_gid'} } )\n                          if exists $h->{'%_gid'};\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_identity',\n                                'Data' =>\n                                  sprintf( \"%.0f\", $h->{'%_id'} * $h->{alen} )\n                            }\n                        ) if ( exists $h->{'%_id'} && exists $h->{alen} );\n\n                        if ( exists $h->{'%_gid'} ) {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_positive',\n                                    'Data' => sprintf( \"%.0f\",\n                                        $h->{'%_gid'} * $h->{alen} )\n                                }\n                            ) if exists $h->{'%_gid'} && exists $h->{alen};\n                        }\n                        else {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_positive',\n                                    'Data' => sprintf( \"%.0f\",\n                                        $h->{'%_id'} * $h->{alen} )\n                                }\n                            ) if ( exists $h->{'%_id'} && exists $h->{alen} );\n                        }\n                        $self->element(\n                            { 'Name' => 'Hsp_align-len', 'Data' => $h->{alen} }\n                        ) if exists $h->{alen};\n                        $self->element(\n                            { 'Name' => 'Hsp_query-from', 'Data' => $h->{an0} }\n                        ) if exists $h->{an0};\n                        $self->element(\n                            { 'Name' => 'Hsp_query-to', 'Data' => $h->{ax0} } )\n                          if exists $h->{ax0};\n                        $self->element(\n                            { 'Name' => 'Hsp_hit-from', 'Data' => $h->{an1} } )\n                          if exists $h->{an1};\n                        $self->element(\n                            { 'Name' => 'Hsp_hit-to', 'Data' => $h->{ax1} } )\n                          if exists $h->{ax1};\n\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_querygaps',\n                                'Data' => $h->{qgaps}\n                            }\n                        ) if exists $h->{qgaps};\n                        $self->element(\n                            { 'Name' => 'Hsp_hitgaps', 'Data' => $h->{lgaps} } )\n                          if exists $h->{lgaps};\n\n                        if ( $self->{'_reporttype'} =~ m/^FAST[NXY]$/o ) {\n                            if ( 8 == scalar grep { exists $h->{$_} }\n                                qw(an0 ax0 pn0 px0 an1 ax1 pn1 px1) )\n                            {\n                                if ( $h->{ax0} < $h->{an0} ) {\n                                    $self->element(\n                                        {\n                                            'Name' => 'Hsp_query-frame',\n                                            'Data' => \"-@{[(($h->{px0} - $h->{ax0}) % 3) + 1]}\"\n                                        }\n                                    );\n                                }\n                                else {\n                                    $self->element(\n                                        {\n                                            'Name' => 'Hsp_query-frame',\n                                            'Data' => \"+@{[(($h->{an0} - $h->{pn0}) % 3) + 1]}\"\n                                        }\n                                    );\n                                }\n                                if ( $h->{ax1} < $h->{an1} ) {\n                                    $self->element(\n                                        {\n                                            'Name' => 'Hsp_hit-frame',\n                                            'Data' => \"-@{[(($h->{px1} - $h->{ax1}) % 3) + 1]}\"\n                                        }\n                                    );\n                                }\n                                else {\n                                    $self->element(\n                                        {\n                                            'Name' => 'Hsp_hit-frame',\n                                            'Data' => \"+@{[(($h->{an1} - $h->{pn1}) % 3) + 1]}\"\n                                        }\n                                    );\n                                }\n                            }\n                            else {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_query-frame',\n                                        'Data' => $h->{lframe}\n                                    }\n                                );\n                                $self->element(\n                                    { 'Name' => 'Hsp_hit-frame', 'Data' => 0 }\n                                );\n                            }\n                        }\n                        else {\n                            $self->element(\n                                { 'Name' => 'Hsp_query-frame', 'Data' => 0 } );\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_hit-frame',\n                                    'Data' => $h->{lframe}\n                                }\n                            );\n                        }\n\n                        $self->end_element( { 'Name' => 'Hsp' } );\n                        $self->end_element( { 'Name' => 'Hit' } );\n                    }\n                }\n                $self->end_element( { 'Name' => 'FastaOutput' } );\n                $self->_pushback($_);\n                return $self->end_document();\n            }\n            else {\n                $self->start_element( { 'Name' => 'FastaOutput' } );\n                $self->{'_result_count'}++;\n                $seentop = 1;\n                $self->element(\n                    {\n                        'Name' => 'FastaOutput_program',\n                        'Data' => $self->{'_reporttype'}\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'FastaOutput_version',\n                        'Data' => $self->{'_version'}\n                    }\n                );\n\n                my ( $type, $querylen, $querytype, $querydef );\n\n                if (/^\\s*\\d+\\s*>>>(.*)/) {\n                    $querydef = $1;\n                    if ( $querydef =~ /^(.*?)\\s+(?:\\-\\s+)?(\\d+)\\s+(aa|nt).*$/o )\n                    {\n                        ( $querydef, $querylen, $querytype ) = ( $1, $2, $3 );\n                    }\n                }\n\n                if (   $self->{'_reporttype'}\n                    && $self->{'_reporttype'} eq 'FASTA' )\n                {\n                    if ( $querytype eq 'nt' ) {\n                        $self->{'_reporttype'} = 'FASTN';\n                    }\n                    elsif ( $querytype eq 'aa' ) {\n                        $self->{'_reporttype'} = 'FASTP';\n                    }\n                }\n                my ( $name, $descr ) =\n                  ( $querydef =~ m/^(\\S+)(?:\\s+(.*))?\\s*$/o );\n                $self->element(\n                    {\n                        'Name' => 'FastaOutput_query-def',\n                        'Data' => $name\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'FastaOutput_querydesc',\n                        'Data' => $descr\n                    }\n                );\n                if ($querylen) {\n                    $self->element(\n                        {\n                            'Name' => 'FastaOutput_query-len',\n                            'Data' => $querylen\n                        }\n                    );\n                }\n                else {\n                    $self->warn(\"unable to find and set query length\");\n                }\n                if ( defined( $_ = $self->_readline() )\n                    && ( /^\\s*vs\\s+(\\S+)/ || /^Library:\\s+(\\S+)/ ) )\n                {\n                    $self->element(\n                        {\n                            'Name' => 'FastaOutput_db',\n                            'Data' => $1\n                        }\n                    );\n                }\n\n            }\n        }\n        elsif ( $self->in_element('hsp') ) {\n            my @data  = ( [], [], [] );\n            my $count = 0;\n            my $len   = $self->idlength + 1;\n            my ($seq1_id);\n            while ( defined($_) ) {\n                chomp;\n                #$self->debug(\"$count $_\\n\");\n                if (/residues in \\d+\\s+query\\s+sequences/o) {\n                    $self->_pushback($_);\n                    last;\n                }\n                elsif (/^>>>\\*\\*\\*/o) {\n                    $self->end_element( { Name => \"Hsp\" } );\n                    last;\n                }\n                elsif (/^>>/o) {\n                    $self->_pushback($_);\n                    last;\n                }\n                elsif (/^\\s*\\d+\\s*>>>/o) {\n                    $self->_pushback($_);\n                    last;\n                }\n                if ( $count == 0 ) {\n                    if (/^(\\S+)\\s+/) {\n                        $self->_pushback($_);\n                        $count = 2;\n                    }\n                    elsif ( /^\\s+\\d+/ || /^\\s+$/ ) {\n\n                        # do nothing, this is really a 0 line\n                    }\n                    elsif ( length($_) == 0 ) {\n                        $count = -1;\n                    }\n                    else {\n                        $self->_pushback($_);\n                        $count = 0;\n                    }\n                }\n                elsif ( $count == 1 || $count == 3 ) {\n                    if (/^(\\S+)\\s+/) {\n                        $len = CORE::length($1) if $len < CORE::length($1);\n                        s/\\s+$//;    # trim trailing spaces,we don't want them\n                        push @{ $data[ $count - 1 ] }, substr( $_, $len );\n                    }\n                    elsif (/^\\s+(\\d+)/) {\n                        $count = -1;\n                        $self->_pushback($_);\n                    }\n                    elsif ( /^\\s+$/ || length($_) == 0 ) {\n                        $count = 5;\n\n                        # going to skip these\n                    }\n                    else {\n                        $self->throw(\n                            \"Unrecognized alignment line ($count) '$_'\");\n                    }\n                }\n                elsif ( $count == 2 ) {\n                    if (/^\\s+\\d+\\s+/) {\n                        $self->warn(\"$_\\n\") if $self->verbose > 0;\n\n                        # we are on a Subject part of the alignment\n                        # but we THOUGHT we were on the Query\n                        # move that last line to the proper place\n                        push @{ $data[2] }, pop @{ $data[0] };\n                        $count = 4;\n                    }\n                    else {\n\n                        # toss the first IDLENGTH characters of the line\n                        if ( length($_) >= $len ) {\n                            push @{ $data[ $count - 1 ] }, substr( $_, $len );\n                        }\n                    }\n                }\n                last if ( $count++ >= 5 );\n                $_ = $self->_readline();\n            }\n            if ( @{ $data[0] } || @{ $data[2] } ) {\n                $self->characters(\n                    {\n                        'Name' => 'Hsp_qseq',\n                        'Data' => join( '', @{ $data[0] } )\n                    }\n                );\n                $self->characters(\n                    {\n                        'Name' => 'Hsp_midline',\n                        'Data' => join( '', @{ $data[1] } )\n                    }\n                );\n                $self->characters(\n                    {\n                        'Name' => 'Hsp_hseq',\n                        'Data' => join( '', @{ $data[2] } )\n                    }\n                );\n            }\n        }\n        else {\n            if ( !$seentop ) {\n                $self->debug($_);\n                #$self->warn(\"unrecognized FASTA Family report file!\");\n                #return;\n            }\n        }\n    }\n    if ( $self->in_element('result') ) {\n        if ( $self->in_element('hsp') ) {\n            $self->end_element( { 'Name' => 'Hsp' } );\n        }\n        if ( $self->in_element('hit') ) {\n            $self->end_element( { 'Name' => 'Hit' } );\n        }\n        $self->end_element( { 'Name' => 'FastaOutput' } );\n    }\n    return $self->end_document();\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element {\n    my ( $self, $data ) = @_;\n\n    # we currently don't care about attributes\n    my $nm = $data->{'Name'};\n    if ( my $type = $MODEMAP{$nm} ) {\n        $self->_mode($type);\n        if ( my $handler = $self->_will_handle($type) ) {\n            my $func = sprintf( \"start_%s\", lc $type );\n            $handler->$func( $data->{'Attributes'} );\n        }\n        unshift @{ $self->{'_elements'} }, $type;\n    }\n    if ( $nm eq 'FastaOutput' ) {\n        $self->{'_values'} = {};\n        $self->{'_result'} = undef;\n        $self->{'_mode'}   = '';\n    }\n\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ( $self, $data ) = @_;\n    my $nm = $data->{'Name'};\n    my $rc;\n\n    # Hsp are sort of weird, in that they end when another\n    # object begins so have to detect this in end_element for now\n    if ( $nm eq 'Hsp' ) {\n        foreach (qw(Hsp_qseq Hsp_midline Hsp_hseq)) {\n            $self->element(\n                {\n                    'Name' => $_,\n                    'Data' => $self->{'_last_hspdata'}->{$_}\n                }\n            );\n        }\n        $self->{'_last_hspdata'} = {};\n    }\n\n    if ( my $type = $MODEMAP{$nm} ) {\n        if ( my $handler = $self->_will_handle($type) ) {\n            my $func = sprintf( \"end_%s\", lc $type );\n            $rc = $handler->$func( $self->{'_reporttype'}, $self->{'_values'} );\n        }\n        shift @{ $self->{'_elements'} };\n\n    }\n    elsif ( $MAPPING{$nm} ) {\n        if ( ref( $MAPPING{$nm} ) =~ /hash/i ) {\n            my $key = ( keys %{ $MAPPING{$nm} } )[0];\n            $self->{'_values'}->{$key}->{ $MAPPING{$nm}->{$key} } =\n              $self->{'_last_data'};\n        }\n        else {\n            $self->{'_values'}->{ $MAPPING{$nm} } = $self->{'_last_data'};\n        }\n    }\n    else {\n        $self->warn(\"unknown nm $nm, ignoring\\n\");\n    }\n    $self->{'_last_data'} = '';    # remove read data if we are at\n                                   # end of an element\n    $self->{'_result'} = $rc if ( $nm eq 'FastaOutput' );\n    return $rc;\n\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element {\n    my ( $self, $data ) = @_;\n    $self->start_element($data);\n    $self->characters($data);\n    $self->end_element($data);\n}\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string\n\n\n\nsub characters {\n    my ( $self, $data ) = @_;\n\n    return unless ( defined $data->{'Data'} );\n    if ( $data->{'Data'} =~ /^\\s+$/ ) {\n        return unless $data->{'Name'} =~ /Hsp\\_(midline|qseq|hseq)/;\n    }\n\n    if (   $self->in_element('hsp')\n        && $data->{'Name'} =~ /Hsp\\_(qseq|hseq|midline)/ )\n    {\n\n        $self->{'_last_hspdata'}->{ $data->{'Name'} } .= $data->{'Data'};\n    }\n\n    $self->{'_last_data'} = $data->{'Data'};\n}\n\n=head2 _mode\n\n Title   : _mode\n Usage   : $obj->_mode($newval)\n Function: \n Example : \n Returns : value of _mode\n Args    : newvalue (optional)\n\n\n\nsub _mode {\n    my ( $self, $value ) = @_;\n    if ( defined $value ) {\n        $self->{'_mode'} = $value;\n    }\n    return $self->{'_mode'};\n}\n\n=head2 within_element\n\n Title   : within_element\n Usage   : if( $eventgenerator->within_element($element) ) {}\n Function: Test if we are within a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name \n\n\n\nsub within_element {\n    my ( $self, $name ) = @_;\n    return 0\n      if (!defined $name && !defined $self->{'_elements'}\n        || scalar @{ $self->{'_elements'} } == 0 );\n    foreach ( @{ $self->{'_elements'} } ) {\n        if ( $_ eq $name || $_ eq $MODEMAP{$name} ) {\n            return 1;\n        }\n    }\n    return 0;\n}\n\n=head2 in_element\n\n Title   : in_element\n Usage   : if( $eventgenerator->in_element($element) ) {}\n Function: Test if we are in a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name \n\n\n\nsub in_element {\n    my ( $self, $name ) = @_;\n    return 0 if !defined $self->{'_elements'}->[0];\n    return (\n        $self->{'_elements'}->[0] eq $name\n          || ( exists $MODEMAP{$name}\n            && $self->{'_elements'}->[0] eq $MODEMAP{$name} )\n    );\n}\n\n=head2 start_document\n\n Title   : start_document\n Usage   : $eventgenerator->start_document\n Function: Handles a start document event\n Returns : none\n Args    : none\n\n\n\nsub start_document {\n    my ($self) = @_;\n    $self->{'_lasttype'} = '';\n    $self->{'_values'}   = {};\n    $self->{'_result'}   = undef;\n    $self->{'_mode'}     = '';\n    $self->{'_elements'} = [];\n}\n\n=head2 end_document\n\n Title   : end_document\n Usage   : $eventgenerator->end_document\n Function: Handles an end document event\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\n\nsub end_document {\n    my ( $self, @args ) = @_;\n    return $self->{'_result'};\n}\n\n=head2 idlength\n\n Title   : idlength\n Usage   : $obj->idlength($newval)\n Function: Internal storage of the length of the ID desc\n           in the HSP alignment blocks.  Defaults to\n           $IDLENGTH class variable value\n Returns : value of idlength\n Args    : newvalue (optional)","label":"idlength($self,$value)"},"detail":"($self,$value)","definition":"sub","containerName":"main::","children":[{"definition":"my","name":"$self","containerName":"idlength","localvar":"my","kind":13,"line":1654},{"line":1654,"kind":13,"name":"$value","containerName":"idlength"},{"name":"$value","containerName":"idlength","line":1655,"kind":13},{"kind":13,"line":1656,"name":"$self","containerName":"idlength"},{"containerName":"idlength","name":"$value","kind":13,"line":1656},{"line":1658,"kind":13,"name":"$self","containerName":"idlength"},{"line":1658,"kind":13,"containerName":"idlength","name":"$IDLENGTH"}],"line":1653,"kind":12,"range":{"start":{"line":1653,"character":0},"end":{"character":9999,"line":1659}},"name":"idlength"},{"containerName":"main::","definition":"sub","name":"result_count","range":{"start":{"character":0,"line":1671},"end":{"character":9999,"line":1674}},"kind":12,"line":1671,"children":[{"kind":13,"line":1672,"containerName":"result_count","definition":"my","name":"$self","localvar":"my"},{"kind":13,"line":1673,"containerName":"result_count","name":"$self"}]},{"range":{"start":{"line":1676,"character":0},"end":{"line":1686,"character":9999}},"name":"attach_EventHandler","detail":"($self,$handler)","signature":{"label":"attach_EventHandler($self,$handler)","parameters":[{"label":"$self"},{"label":"$handler"}],"documentation":""},"containerName":"main::","definition":"sub","line":1676,"children":[{"line":1677,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"attach_EventHandler"},{"name":"$handler","containerName":"attach_EventHandler","line":1677,"kind":13},{"containerName":"attach_EventHandler","name":"$self","kind":13,"line":1679},{"kind":13,"line":1679,"name":"$handler","containerName":"attach_EventHandler"},{"line":1684,"kind":13,"containerName":"attach_EventHandler","name":"$self"},{"containerName":"attach_EventHandler","name":"$handler","kind":13,"line":1684}],"kind":12},{"containerName":"attach_EventHandler","name":"SUPER","kind":12,"line":1679},{"name":"_will_handle","range":{"start":{"character":0,"line":1726},"end":{"character":9999,"line":1736}},"kind":12,"line":1726,"children":[{"localvar":"my","containerName":"_will_handle","name":"$self","definition":"my","line":1727,"kind":13},{"containerName":"_will_handle","name":"$type","line":1727,"kind":13},{"definition":"my","name":"$handler","containerName":"_will_handle","localvar":"my","kind":13,"line":1728},{"kind":13,"line":1728,"containerName":"_will_handle","name":"$self"},{"kind":13,"line":1729,"definition":"my","name":"$will_handle","containerName":"_will_handle","localvar":"my"},{"containerName":"_will_handle","name":"$self","kind":13,"line":1730},{"line":1730,"kind":13,"name":"$type","containerName":"_will_handle"},{"line":1731,"kind":13,"containerName":"_will_handle","name":"$self"},{"name":"$type","containerName":"_will_handle","kind":13,"line":1731},{"name":"$self","containerName":"_will_handle","kind":13,"line":1732},{"kind":13,"line":1732,"name":"$type","containerName":"_will_handle"},{"containerName":"_will_handle","name":"$handler","kind":13,"line":1733},{"name":"will_handle","containerName":"_will_handle","kind":12,"line":1733},{"line":1733,"kind":13,"name":"$type","containerName":"_will_handle"},{"name":"$will_handle","containerName":"_will_handle","line":1735,"kind":13},{"name":"$handler","containerName":"_will_handle","line":1735,"kind":13}],"containerName":"main::","definition":"sub","detail":"($self,$type)","signature":{"parameters":[{"label":"$self"},{"label":"$type"}],"documentation":"1;\n# $Id: fasta.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::fasta\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::fasta - A SearchIO parser for FASTA results\n\n=head1 SYNOPSIS\n\n  # Do not use this object directly, use it through the SearchIO system\n   use Bio::SearchIO;\n   my $searchio = Bio::SearchIO->new(-format => 'fasta',\n                    -file   => 'report.FASTA');\n   while( my $result = $searchio->next_result ) {\n    # ... do what you would normally doi with Bio::SearchIO.\n   }\n\n=head1 DESCRIPTION\n\nThis object contains the event based parsing code for FASTA format\nreports.  It creates L<Bio::Search::HSP::FastaHSP> objects instead of\nL<Bio::Search::HSP::GenericHSP> for the HSP objects. \n\nThis module will parse -m 9 -d 0 output as well as default m 1 output\nfrom FASTA as well as SSEARCH.\n\nAlso see the SearchIO HOWTO:\nL<http://bioperl.open-bio.org/wiki/HOWTO:SearchIO>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich, Aaron Mackey\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::fasta;\nuse vars qw(%MODEMAP %MAPPING $IDLENGTH);\nuse strict;\n\n# Object preamble - inherits from Bio::Root::RootI\n\nuse Bio::Factory::ObjectFactory;\n\nBEGIN {\n\n    # Set IDLENGTH to a new value if you have\n    # compile FASTA with a different ID length\n    # (actually newest FASTA allows the setting of this\n    #  via -C parameter, default is 6)\n    $IDLENGTH = 6;\n\n    # mapping of NCBI Blast terms to Bioperl hash keys\n    %MODEMAP = (\n        'FastaOutput' => 'result',\n        'Hit'         => 'hit',\n        'Hsp'         => 'hsp'\n    );\n\n    # This should really be done more intelligently, like with\n    # XSLT\n\n    %MAPPING = (\n        'Hsp_bit-score'   => 'HSP-bits',\n        'Hsp_score'       => 'HSP-score',\n        'Hsp_sw-score'    => 'HSP-swscore',\n        'Hsp_evalue'      => 'HSP-evalue',\n        'Hsp_query-from'  => 'HSP-query_start',\n        'Hsp_query-to'    => 'HSP-query_end',\n        'Hsp_hit-from'    => 'HSP-hit_start',\n        'Hsp_hit-to'      => 'HSP-hit_end',\n        'Hsp_positive'    => 'HSP-conserved',\n        'Hsp_identity'    => 'HSP-identical',\n        'Hsp_gaps'        => 'HSP-hsp_gaps',\n        'Hsp_hitgaps'     => 'HSP-hit_gaps',\n        'Hsp_querygaps'   => 'HSP-query_gaps',\n        'Hsp_qseq'        => 'HSP-query_seq',\n        'Hsp_hseq'        => 'HSP-hit_seq',\n        'Hsp_midline'     => 'HSP-homology_seq',\n        'Hsp_align-len'   => 'HSP-hsp_length',\n        'Hsp_query-frame' => 'HSP-query_frame',\n        'Hsp_hit-frame'   => 'HSP-hit_frame',\n\n        'Hit_id'        => 'HIT-name',\n        'Hit_len'       => 'HIT-length',\n        'Hit_accession' => 'HIT-accession',\n        'Hit_def'       => 'HIT-description',\n        'Hit_signif'    => 'HIT-significance',\n        'Hit_score'     => 'HIT-score',\n\n        'FastaOutput_program'   => 'RESULT-algorithm_name',\n        'FastaOutput_version'   => 'RESULT-algorithm_version',\n        'FastaOutput_query-def' => 'RESULT-query_name',\n        'FastaOutput_querydesc' => 'RESULT-query_description',\n        'FastaOutput_query-len' => 'RESULT-query_length',\n        'FastaOutput_db'        => 'RESULT-database_name',\n        'FastaOutput_db-len'    => 'RESULT-database_entries',\n        'FastaOutput_db-let'    => 'RESULT-database_letters',\n\n        'Parameters_matrix'      => { 'RESULT-parameters' => 'matrix' },\n        'Parameters_expect'      => { 'RESULT-parameters' => 'expect' },\n        'Parameters_include'     => { 'RESULT-parameters' => 'include' },\n        'Parameters_sc-match'    => { 'RESULT-parameters' => 'match' },\n        'Parameters_sc-mismatch' => { 'RESULT-parameters' => 'mismatch' },\n        'Parameters_gap-open'    => { 'RESULT-parameters' => 'gapopen' },\n        'Parameters_gap-ext'     => { 'RESULT-parameters' => 'gapext' },\n        'Parameters_word-size'   => { 'RESULT-parameters' => 'wordsize' },\n        'Parameters_ktup'        => { 'RESULT-parameters' => 'ktup' },\n        'Parameters_filter'      => { 'RESULT-parameters' => 'filter' },\n        'Statistics_db-num'      => { 'RESULT-statistics' => 'dbentries' },\n        'Statistics_db-len'      => { 'RESULT-statistics' => 'dbletters' },\n        'Statistics_hsp-len'     => { 'RESULT-statistics' => 'hsplength' },\n        'Statistics_eff-space'   => { 'RESULT-statistics' => 'effectivespace' },\n        'Statistics_kappa'       => { 'RESULT-statistics' => 'kappa' },\n        'Statistics_lambda'      => { 'RESULT-statistics' => 'lambda' },\n        'Statistics_entropy'     => { 'RESULT-statistics' => 'entropy' },\n    );\n}\n\nuse base qw(Bio::SearchIO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::fasta->new();\n Function: Builds a new Bio::SearchIO::fasta object \n Returns : Bio::SearchIO::fasta\n Args    : -idlength - set ID length to something other \n                       than the default (7), this is only\n                       necessary if you have compiled FASTA\n                       with a new default id length to display\n                       in the HSP alignment blocks\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n    return unless @args;\n    my ($idlength) = $self->_rearrange( [qw(IDLENGTH)], @args );\n    $self->idlength( $idlength || $IDLENGTH );\n    $self->_eventHandler->register_factory(\n        'hsp',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::HSP::FastaHSP',\n            -interface => 'Bio::Search::HSP::HSPI'\n        )\n    );\n    return 1;\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    local $/ = \"\\n\";\n    local $_;\n\n    my $data    = '';\n    my $seentop = 0;\n    my $current_hsp;\n    $self->start_document();\n    my @hit_signifs;\n    while ( defined( $_ = $self->_readline ) ) {\n        next if ( !$self->in_element('hsp')\n            && /^\\s+$/ );    # skip empty lines\n        if (\n               m/(\\S+)\\s+searches\\s+a\\s+(protein\\s+or\\s+DNA\\s+)?sequence/oxi\n            || /(\\S+)\\s+compares\\s+a/\n            || (   m/^\\#\\s+/\n                && ( $_ = $self->_readline )\n                && /(\\S+)\\s+searches\\s+a\\s+(protein\\s+or\\s+DNA\\s+)?sequence/oxi\n                || /(\\S+)\\s+compares\\s+a/ )\n          )\n        {\n            if ($seentop) {\n                $self->_pushback($_);\n                $self->end_element( { 'Name' => 'FastaOutput' } );\n                return $self->end_document();\n            }\n            $self->{'_reporttype'} = $1;\n            $self->start_element( { 'Name' => 'FastaOutput' } );\n            $self->{'_result_count'}++;\n            $seentop = 1;\n            #$self->debug( \"reporttype is \" . $self->{'_reporttype'} . \"\\n\" );\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_program',\n                    'Data' => $self->{'_reporttype'}\n                }\n            );\n            $_ = $self->_readline();\n            my ($version) = (/version\\s+(\\S+)/);\n            $version = '' unless defined $version;\n            $self->{'_version'} = $version;\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_version',\n                    'Data' => $version\n                }\n            );\n\n            my ( $last, $leadin, $type, $querylen, $querytype, $querydef );\n\n            while ( defined( $_ = $self->_readline() ) ) {\n                if (\n                    /^ (\n                       (?:\\s+>) |             # fa33 lead-in\n                       (?:\\s*\\d+\\s*>>>)       # fa34 mlib lead-in\n                      )\n                      (.*)\n                   /x\n                  )\n                {\n                    ( $leadin, $querydef ) = ( $1, $2 );\n                    if ( $leadin =~ m/>>>/ ) {\n                        if ( $querydef =~\n                            /^(.*?)\\s+(?:\\-\\s+)?(\\d+)\\s+(aa|nt).*$/o )\n                        {\n                            ( $querydef, $querylen, $querytype ) =\n                              ( $1, $2, $3 );\n                            last;\n                        }\n                    }\n                    else {\n                        if ( $last =~ /(\\S+)[:,]\\s*(\\d+)\\s+(aa|nt)/ ) {\n                            ( $querylen, $querytype ) = ( $2, $3 );\n                            $querydef ||= $1;\n                            last;\n                        }\n                    }\n                }\n                elsif (m/^\\s*vs\\s+\\S+/o) {\n                    if ( $last =~ /(\\S+)[,:]\\s+(\\d+)\\s+(aa|nt)/o ) {\n                        ( $querydef, $querylen, $querytype ) = ( $1, $2, $3 );\n                        last;\n                    }\n                }\n                $last = $_;\n            }\n            if (   $self->{'_reporttype'}\n                && $self->{'_reporttype'} eq 'FASTA' )\n            {\n                if ( $querytype eq 'nt' ) {\n                    $self->{'_reporttype'} = 'FASTN';\n                }\n                elsif ( $querytype eq 'aa' ) {\n                    $self->{'_reporttype'} = 'FASTP';\n                }\n            }\n            my ( $name, $descr ) = $querydef =~ m/^(\\S+)\\s*(.*?)\\s*$/o;\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_query-def',\n                    'Data' => $name\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_querydesc',\n                    'Data' => $descr\n                }\n            );\n            if ($querylen) {\n                $self->element(\n                    {\n                        'Name' => 'FastaOutput_query-len',\n                        'Data' => $querylen\n                    }\n                );\n            }\n            else {\n                $self->warn(\"unable to find and set query length\");\n            }\n            if (\n                   $last =~ /^\\s*vs\\s+(\\S+)/\n                || ( $last =~ /^searching\\s+(\\S+)\\s+library/ )\n                || ( $last =~ /^Library:\\s+(\\S+)\\s+/ )\n                || (\n                    defined $_\n                    && (   /^\\s*vs\\s+(\\S+)/\n                        || /^Library:\\s+(\\S+)\\s+/ )\n                )\n                || ( defined( $_ = $self->_readline() )\n                    && ( /^\\s*vs\\s+(\\S+)/ || /^Library:\\s+(\\S+)/ ) )\n              )\n            {\n                $self->element(\n                    {\n                        'Name' => 'FastaOutput_db',\n                        'Data' => $1\n                    }\n                );\n            }\n            elsif (m/^\\s+opt(?:\\s+E\\(\\))?$/o) {\n\n           # histogram ... read over it more rapidly than the larger outer loop:\n                while ( defined( $_ = $self->_readline ) ) {\n                    last if m/^>\\d+/;\n                }\n            }\n        }\n        elsif (/(\\d+)\\s+residues\\s+in\\s+(\\d+)\\s+(?:library\\s+)?sequences/) {\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_db-let',\n                    'Data' => $1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_db-len',\n                    'Data' => $2\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Statistics_db-len',\n                    'Data' => $1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Statistics_db-num',\n                    'Data' => $2\n                }\n            );\n        }\n        elsif (/Lambda=\\s*(\\S+)/) {\n            $self->element(\n                {\n                    'Name' => 'Statistics_lambda',\n                    'Data' => $1\n                }\n            );\n        }\n        elsif (/K=\\s*(\\S+)/) {\n            $self->element(\n                {\n                    'Name' => 'Statistics_kappa',\n                    'Data' => $1\n                }\n            );\n        }\n        elsif (/^\\s*(Smith-Waterman).+(\\S+)\\s*matrix [^\\]]*?(xS)?\\]/) {\n            $self->element(\n                {\n                    'Name' => 'Parameters_matrix',\n                    'Data' => $2\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_filter',\n                    'Data' => defined $3 ? 1 : 0,\n                }\n            );\n            $self->{'_reporttype'} = $1;\n\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_program',\n                    'Data' => $self->{'_reporttype'}\n                }\n            );\n        }\n        elsif (/The best( related| unrelated)? scores are:/) {\n            my $rel    = $1;\n            my @labels = split;\n            @labels = map {\n                if ( $_ =~ m/^E\\((\\d+)\\)$/o )\n                {\n                    $self->element(\n                        { 'Name' => 'Statistics_eff-space', 'Data' => $1 } );\n                    \"evalue\";\n                }\n                else {\n                    $_;\n                }\n            } @labels[ $rel ? 5 : 4 .. $#labels ];\n\n            while ( defined( $_ = $self->_readline() )\n                && !/^\\s+$/ )\n            {\n                my @line = split;\n\n                if ( $line[-1] =~ m/\\=/o && $labels[-1] eq 'fs' ) {\n\n                    # unlabelled alignment hit;\n                    push @labels, \"aln_code\";\n                }\n\n                my %data;\n                @data{@labels} = splice( @line, @line - @labels );\n                if ( $line[-1] =~ m/\\[([1-6rf])\\]/o ) {\n                    my $fr = $1;\n                    $data{lframe} = (\n                        $fr =~ /\\d/o\n                        ? ( $fr <= 3 ? \"+$fr\" : \"-@{[$fr-3]}\" )\n                        : ( $fr eq 'f' ? '+1' : '-1' )\n                    );\n                    pop @line;\n                }\n                else {\n                    $data{lframe} = '0';\n                }\n\n                if ( $line[-1] =~ m/^\\(?(\\d+)\\)$/ ) {\n                    $data{hit_len} = $1;\n                    pop @line;\n                    if ( $line[-1] =~ m/^\\($/ ) {\n                        pop @line;\n                    }\n                }\n                else {\n                    $data{hit_len} = 0;\n                }\n\n                # rebuild the first part of the line, preserving spaces:\n                ($_) = m/^(\\S+(?:\\s+\\S+){$#line})/;\n\n                my ( $id, $desc ) = split( /\\s+/, $_, 2 );\n                my @pieces = split( /\\|/, $id );\n                my $acc = pop @pieces;\n                $acc =~ s/\\.\\d+$//;\n\n                @data{qw(id desc acc)} = ( $id, $desc, $acc );\n\n                push @hit_signifs, \\%data;\n            }\n        }\n        elsif (\n/^\\s*([T]?FAST[XYAF]).+,\\s*(\\S+)\\s*matrix[^\\]]+?(xS)?\\]\\s*ktup:\\s*(\\d+)/\n          )\n        {\n\n            $self->element(\n                {\n                    'Name' => 'Parameters_matrix',\n                    'Data' => $2\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_filter',\n                    'Data' => defined $3 ? 1 : 0,\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_ktup',\n                    'Data' => $4\n                }\n            );\n            $self->{'_reporttype'} = $1\n              if ( $self->{'_reporttype'} !~ /FAST[PN]/i );\n\n            $self->element(\n                {\n                    'Name' => 'FastaOutput_program',\n                    'Data' => $self->{'_reporttype'}\n                }\n            );\n        }\n        elsif (/^Algorithm:\\s+(\\S+)\\s+\\(([^)]+)\\)\\s+(\\S+)/) {\n            $self->{'_reporttype'} = $1\n              if ( $self->{'_reporttype'} !~ /FAST[PN]/i );\n        }\n        elsif (\n            /^Parameters:\\s+(\\S+)\\s*matrix\\s*(?:\\(([^(]+?)\\))?\\s*ktup:\\s*(\\d+)/)\n        {    # FASTA 35.04\n            $self->element(\n                {\n                    'Name' => 'Parameters_matrix',\n                    'Data' => $1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_filter',\n                    'Data' => defined $2 ? $2 : 0,\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_ktup',\n                    'Data' => $3\n                }\n            );\n        }\n        elsif (\n/(?:gap\\-pen|open\\/ext):\\s+([\\-\\+]?\\d+)\\s*\\/\\s*([\\-\\+]?\\d+).+width:\\s+(\\d+)/\n          )\n        {\n            $self->element(\n                {\n                    'Name' => 'Parameters_gap-open',\n                    'Data' => $1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_gap-ext',\n                    'Data' => $2\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Parameters_word-size',\n                    'Data' => $3\n                }\n            );\n        }\n        elsif (/^>>(?!>)(.+?)\\s+(?:\\((\\d+)\\s*(aa|nt)\\))?$/) {\n            my ($hit_id, $len, $alphabet) = ($1, $2, $3);\n            if (!$len || !$alphabet) {\n                WRAPPED:\n                while (defined($_ = $self->_readline)) {\n                    if (/(.*?)\\s+\\((\\d+)\\s*(aa|nt)\\)/) {\n                        ($len, $alphabet) = ($2, $3);\n                        $hit_id .= $1 ? \" \".$1 : '';\n                        last WRAPPED;\n                    }\n                    if (/^>>(?!>)/) { # too far, throw\n                        $self->throw(\"Couldn't find length, bailing\");\n                    }\n                }\n            }\n            if ( $self->in_element('hsp') ) {\n                $self->end_element( { 'Name' => 'Hsp' } );\n            }\n            if ( $self->in_element('hit') ) {\n                $self->end_element( { 'Name' => 'Hit' } );\n            }\n\n            $self->start_element( { 'Name' => 'Hit' } );\n            $self->element(\n                {\n                    'Name' => 'Hit_len',\n                    'Data' => $len\n                }\n            );\n            my ( $id, $desc ) = split( /\\s+/, $hit_id, 2 );\n            $self->element(\n                {\n                    'Name' => 'Hit_id',\n                    'Data' => $id\n                }\n            );\n\n            #$self->debug(\"Hit ID is $id\\n\");\n            my @pieces = split( /\\|/, $id );\n            my $acc = pop @pieces;\n            $acc =~ s/\\.\\d+$//;\n            $self->element(\n                {\n                    'Name' => 'Hit_accession',\n                    'Data' => $acc\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hit_def',\n                    'Data' => $desc\n                }\n            );\n\n            $_ = $self->_readline();\n            my ( $score, $bits, $e ) = /Z-score: \\s* (\\S+) \\s*\n                               (?: bits: \\s* (\\S+) \\s+ )?\n                               (?: E|expect ) \\s* \\(\\) :? \\s*(\\S+)/ox;\n            $bits = $score unless defined $bits;\n\n            my $v = shift @hit_signifs;\n            if ( defined $v ) {\n                @{$v}{qw(evalue bits z-sc)} = ( $e, $bits, $score );\n            }\n            $self->element(\n                {\n                    'Name' => 'Hit_signif',\n                    'Data' => $v ? $v->{evalue} : $e\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hit_score',\n                    'Data' => $v ? $v->{bits} : $bits\n                }\n            );\n            $self->start_element( { 'Name' => 'Hsp' } );\n\n            $self->element(\n                {\n                    'Name' => 'Hsp_score',\n                    'Data' => $v ? $v->{'z-sc'} : $score\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_evalue',\n                    'Data' => $v ? $v->{evalue} : $e\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_bit-score',\n                    'Data' => $v ? $v->{bits} : $bits\n                }\n            );\n            $_ = $self->_readline();\n\n            if (s/Smith-Waterman score:\\s*(\\d+)\\;?//) {\n                $self->element(\n                    {\n                        'Name' => 'Hsp_sw-score',\n                        'Data' => $1\n                    }\n                );\n            }\n            if (\n                / (\\d*\\.?\\d+)\\% \\s* identity\n                 (?:\\s* \\(\\s*(\\S+)\\% \\s* (?:ungapped|similar) \\) )?\n                 \\s* in \\s* (\\d+) \\s+ (?:aa|nt) \\s+ overlap \\s*\n                 \\( (\\d+) \\- (\\d+) : (\\d+) \\- (\\d+) \\)\n               /x\n              )\n            {\n                my ( $identper, $gapper, $len, $querystart, $queryend,\n                    $hitstart, $hitend )\n                  = ( $1, $2, $3, $4, $5, $6, $7 );\n                my $ident = sprintf( \"%.0f\", ( $identper / 100 ) * $len );\n                my $positive = sprintf( \"%.0f\", ( $gapper / 100 ) * $len );\n\n                $self->element(\n                    {\n                        'Name' => 'Hsp_identity',\n                        'Data' => $ident\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'Hsp_positive',\n                        'Data' => $positive\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'Hsp_align-len',\n                        'Data' => $len\n                    }\n                );\n\n                $self->element(\n                    {\n                        'Name' => 'Hsp_query-from',\n                        'Data' => $querystart\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'Hsp_query-to',\n                        'Data' => $queryend\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'Hsp_hit-from',\n                        'Data' => $hitstart\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'Hsp_hit-to',\n                        'Data' => $hitend\n                    }\n                );\n\n            }\n\n            if ($v) {\n                $self->element(\n                    { 'Name' => 'Hsp_querygaps', 'Data' => $v->{qgaps} } )\n                  if exists $v->{qgaps};\n                $self->element(\n                    { 'Name' => 'Hsp_hitgaps', 'Data' => $v->{lgaps} } )\n                  if exists $v->{lgaps};\n\n                if ( $self->{'_reporttype'} =~ m/^FAST[NXY]$/o ) {\n                    if ( 8 == scalar grep { exists $v->{$_} }\n                        qw(an0 ax0 pn0 px0 an1 ax1 pn1 px1) )\n                    {\n                        if ( $v->{ax0} < $v->{an0} ) {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_query-frame',\n                                    'Data' =>\n                                      \"-@{[(($v->{px0} - $v->{ax0}) % 3) + 1]}\"\n                                }\n                            );\n                        }\n                        else {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_query-frame',\n                                    'Data' =>\n                                      \"+@{[(($v->{an0} - $v->{pn0}) % 3) + 1]}\"\n                                }\n                            );\n                        }\n                        if ( $v->{ax1} < $v->{an1} ) {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_hit-frame',\n                                    'Data' =>\n                                      \"-@{[(($v->{px1} - $v->{ax1}) % 3) + 1]}\"\n                                }\n                            );\n                        }\n                        else {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_hit-frame',\n                                    'Data' =>\n                                      \"+@{[(($v->{an1} - $v->{pn1}) % 3) + 1]}\"\n                                }\n                            );\n                        }\n                    }\n                    else {\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_query-frame',\n                                'Data' => $v->{lframe}\n                            }\n                        );\n                        $self->element(\n                            { 'Name' => 'Hsp_hit-frame', 'Data' => 0 } );\n                    }\n                }\n                else {\n                    $self->element(\n                        { 'Name' => 'Hsp_query-frame', 'Data' => 0 } );\n                    $self->element(\n                        { 'Name' => 'Hsp_hit-frame', 'Data' => $v->{lframe} } );\n                }\n\n            }\n            else {\n                $self->warn(\"unable to parse FASTA score line: $_\");\n            }\n        }\n        elsif (/\\d+\\s*residues\\s*in\\s*\\d+\\s*query\\s*sequences/) {\n            if ( $self->in_element('hsp') ) {\n                $self->end_element( { 'Name' => 'Hsp' } );\n            }\n            if ( $self->in_element('hit') ) {\n                $self->end_element( { 'Name' => 'Hit' } );\n            }\n\n           #       $_ = $self->_readline();\n           #       my ( $liblen,$libsize) = /(\\d+)\\s+residues\\s*in(\\d+)\\s*library/;\n           # fast forward to the end of the file as there is\n           # nothing else left to do with this file and want to be sure and\n           # reset it\n            while ( defined( $_ = $self->_readline() ) ) {\n                last if (/^Function used was/);\n                if (\n                    /(\\S+)\\s+searches\\s+a\\s+(protein\\s+or\\s+DNA\\s+)?\n           sequence/oxi || /(\\S+)\\s+compares\\s+a/oi\n                  )\n                {\n                    $self->_pushback($_);\n                }\n            }\n\n            if (@hit_signifs) {\n\n                # process remaining best hits\n                for my $h (@hit_signifs) {\n\n                    # Hsp_score Hsp_evalue Hsp_bit-score\n                    # Hsp_sw-score Hsp_gaps Hsp_identity Hsp_positive\n                    # Hsp_align-len Hsp_query-from Hsp_query-to\n                    # Hsp_hit-from Hsp_hit-to Hsp_qseq Hsp_midline\n\n                    $self->start_element( { 'Name' => 'Hit' } );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_len',\n                            'Data' => $h->{hit_len}\n                        }\n                    ) if exists $h->{hit_len};\n                    $self->element(\n                        {\n                            'Name' => 'Hit_id',\n                            'Data' => $h->{id}\n                        }\n                    ) if exists $h->{id};\n                    $self->element(\n                        {\n                            'Name' => 'Hit_accession',\n                            'Data' => $h->{acc}\n                        }\n                    ) if exists $h->{acc};\n                    $self->element(\n                        {\n                            'Name' => 'Hit_def',\n                            'Data' => $h->{desc}\n                        }\n                    ) if exists $h->{desc};\n                    $self->element(\n                        {\n                            'Name' => 'Hit_signif',\n                            'Data' => $h->{evalue}\n                        }\n                    ) if exists $h->{evalue};\n                    $self->element(\n                        {\n                            'Name' => 'Hit_score',\n                            'Data' => $h->{bits}\n                        }\n                    ) if exists $h->{bits};\n\n                    $self->start_element( { 'Name' => 'Hsp' } );\n                    $self->element(\n                        { 'Name' => 'Hsp_score', 'Data' => $h->{'z-sc'} } )\n                      if exists $h->{'z-sc'};\n                    $self->element(\n                        { 'Name' => 'Hsp_evalue', 'Data' => $h->{evalue} } )\n                      if exists $h->{evalue};\n                    $self->element(\n                        { 'Name' => 'Hsp_bit-score', 'Data' => $h->{bits} } )\n                      if exists $h->{bits};\n                    $self->element(\n                        { 'Name' => 'Hsp_sw-score', 'Data' => $h->{sw} } )\n                      if exists $h->{sw};\n                    $self->element(\n                        { 'Name' => 'Hsp_gaps', 'Data' => $h->{'%_gid'} } )\n                      if exists $h->{'%_gid'};\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_identity',\n                            'Data' =>\n                              sprintf( \"%.0f\", $h->{'%_id'} * $h->{alen} )\n                        }\n                    ) if ( exists $h->{'%_id'} && exists $h->{alen} );\n\n                    if ( exists $h->{'%_gid'} ) {\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_positive',\n                                'Data' =>\n                                  sprintf( \"%.0f\", $h->{'%_gid'} * $h->{alen} )\n                            }\n                        ) if exists $h->{'%_gid'} && exists $h->{alen};\n                    }\n                    else {\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_positive',\n                                'Data' =>\n                                  sprintf( \"%.0f\", $h->{'%_id'} * $h->{alen} )\n                            }\n                        ) if ( exists $h->{'%_id'} && exists $h->{alen} );\n                    }\n                    $self->element(\n                        { 'Name' => 'Hsp_align-len', 'Data' => $h->{alen} } )\n                      if exists $h->{alen};\n                    $self->element(\n                        { 'Name' => 'Hsp_query-from', 'Data' => $h->{an0} } )\n                      if exists $h->{an0};\n                    $self->element(\n                        { 'Name' => 'Hsp_query-to', 'Data' => $h->{ax0} } )\n                      if exists $h->{ax0};\n                    $self->element(\n                        { 'Name' => 'Hsp_hit-from', 'Data' => $h->{an1} } )\n                      if exists $h->{an1};\n                    $self->element(\n                        { 'Name' => 'Hsp_hit-to', 'Data' => $h->{ax1} } )\n                      if exists $h->{ax1};\n\n                    $self->element(\n                        { 'Name' => 'Hsp_querygaps', 'Data' => $h->{qgaps} } )\n                      if exists $h->{qgaps};\n                    $self->element(\n                        { 'Name' => 'Hsp_hitgaps', 'Data' => $h->{lgaps} } )\n                      if exists $h->{lgaps};\n\n                    if ( $self->{'_reporttype'} =~ m/^FAST[NXY]$/o ) {\n                        if ( 8 == scalar grep { exists $h->{$_} }\n                            qw(an0 ax0 pn0 px0 an1 ax1 pn1 px1) )\n                        {\n                            if ( $h->{ax0} < $h->{an0} ) {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_query-frame',\n                                        'Data' =>\n\"-@{[(($h->{px0} - $h->{ax0}) % 3) + 1]}\"\n                                    }\n                                );\n                            }\n                            else {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_query-frame',\n                                        'Data' =>\n\"+@{[(($h->{an0} - $h->{pn0}) % 3) + 1]}\"\n                                    }\n                                );\n                            }\n                            if ( $h->{ax1} < $h->{an1} ) {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_hit-frame',\n                                        'Data' =>\n\"-@{[(($h->{px1} - $h->{ax1}) % 3) + 1]}\"\n                                    }\n                                );\n                            }\n                            else {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_hit-frame',\n                                        'Data' =>\n\"+@{[(($h->{an1} - $h->{pn1}) % 3) + 1]}\"\n                                    }\n                                );\n                            }\n                        }\n                        else {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_query-frame',\n                                    'Data' => $h->{lframe}\n                                }\n                            );\n                            $self->element(\n                                { 'Name' => 'Hsp_hit-frame', 'Data' => 0 } );\n                        }\n                    }\n                    else {\n                        $self->element(\n                            { 'Name' => 'Hsp_query-frame', 'Data' => 0 } );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_hit-frame',\n                                'Data' => $h->{lframe}\n                            }\n                        );\n                    }\n\n                    $self->end_element( { 'Name' => 'Hsp' } );\n                    $self->end_element( { 'Name' => 'Hit' } );\n                }\n            }\n            $self->end_element( { 'Name' => 'FastaOutput' } );\n            return $self->end_document();\n        }\n        elsif (/^\\s*\\d+\\s*>>>/) {\n            if ( $self->within_element('FastaOutput') ) {\n                if ( $self->in_element('hsp') ) {\n                    $self->end_element( { 'Name' => 'Hsp' } );\n                }\n                if ( $self->in_element('hit') ) {\n                    $self->end_element( { 'Name' => 'Hit' } );\n                }\n\n                if (@hit_signifs) {\n\n                    # process remaining best hits\n                    for my $h (@hit_signifs) {\n                        $self->start_element( { 'Name' => 'Hit' } );\n                        $self->element(\n                            {\n                                'Name' => 'Hit_len',\n                                'Data' => $h->{hit_len}\n                            }\n                        ) if exists $h->{hit_len};\n                        $self->element(\n                            {\n                                'Name' => 'Hit_id',\n                                'Data' => $h->{id}\n                            }\n                        ) if exists $h->{id};\n                        $self->element(\n                            {\n                                'Name' => 'Hit_accession',\n                                'Data' => $h->{acc}\n                            }\n                        ) if exists $h->{acc};\n                        $self->element(\n                            {\n                                'Name' => 'Hit_def',\n                                'Data' => $h->{desc}\n                            }\n                        ) if exists $h->{desc};\n                        $self->element(\n                            {\n                                'Name' => 'Hit_signif',\n                                'Data' => $h->{evalue}\n                            }\n                        ) if exists $h->{evalue};\n                        $self->element(\n                            {\n                                'Name' => 'Hit_score',\n                                'Data' => $h->{bits}\n                            }\n                        ) if exists $h->{bits};\n\n                        $self->start_element( { 'Name' => 'Hsp' } );\n                        $self->element(\n                            { 'Name' => 'Hsp_score', 'Data' => $h->{'z-sc'} } )\n                          if exists $h->{'z-sc'};\n                        $self->element(\n                            { 'Name' => 'Hsp_evalue', 'Data' => $h->{evalue} } )\n                          if exists $h->{evalue};\n                        $self->element(\n                            { 'Name' => 'Hsp_bit-score', 'Data' => $h->{bits} }\n                        ) if exists $h->{bits};\n                        $self->element(\n                            { 'Name' => 'Hsp_sw-score', 'Data' => $h->{sw} } )\n                          if exists $h->{sw};\n                        $self->element(\n                            { 'Name' => 'Hsp_gaps', 'Data' => $h->{'%_gid'} } )\n                          if exists $h->{'%_gid'};\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_identity',\n                                'Data' =>\n                                  sprintf( \"%.0f\", $h->{'%_id'} * $h->{alen} )\n                            }\n                        ) if ( exists $h->{'%_id'} && exists $h->{alen} );\n\n                        if ( exists $h->{'%_gid'} ) {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_positive',\n                                    'Data' => sprintf( \"%.0f\",\n                                        $h->{'%_gid'} * $h->{alen} )\n                                }\n                            ) if exists $h->{'%_gid'} && exists $h->{alen};\n                        }\n                        else {\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_positive',\n                                    'Data' => sprintf( \"%.0f\",\n                                        $h->{'%_id'} * $h->{alen} )\n                                }\n                            ) if ( exists $h->{'%_id'} && exists $h->{alen} );\n                        }\n                        $self->element(\n                            { 'Name' => 'Hsp_align-len', 'Data' => $h->{alen} }\n                        ) if exists $h->{alen};\n                        $self->element(\n                            { 'Name' => 'Hsp_query-from', 'Data' => $h->{an0} }\n                        ) if exists $h->{an0};\n                        $self->element(\n                            { 'Name' => 'Hsp_query-to', 'Data' => $h->{ax0} } )\n                          if exists $h->{ax0};\n                        $self->element(\n                            { 'Name' => 'Hsp_hit-from', 'Data' => $h->{an1} } )\n                          if exists $h->{an1};\n                        $self->element(\n                            { 'Name' => 'Hsp_hit-to', 'Data' => $h->{ax1} } )\n                          if exists $h->{ax1};\n\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_querygaps',\n                                'Data' => $h->{qgaps}\n                            }\n                        ) if exists $h->{qgaps};\n                        $self->element(\n                            { 'Name' => 'Hsp_hitgaps', 'Data' => $h->{lgaps} } )\n                          if exists $h->{lgaps};\n\n                        if ( $self->{'_reporttype'} =~ m/^FAST[NXY]$/o ) {\n                            if ( 8 == scalar grep { exists $h->{$_} }\n                                qw(an0 ax0 pn0 px0 an1 ax1 pn1 px1) )\n                            {\n                                if ( $h->{ax0} < $h->{an0} ) {\n                                    $self->element(\n                                        {\n                                            'Name' => 'Hsp_query-frame',\n                                            'Data' => \"-@{[(($h->{px0} - $h->{ax0}) % 3) + 1]}\"\n                                        }\n                                    );\n                                }\n                                else {\n                                    $self->element(\n                                        {\n                                            'Name' => 'Hsp_query-frame',\n                                            'Data' => \"+@{[(($h->{an0} - $h->{pn0}) % 3) + 1]}\"\n                                        }\n                                    );\n                                }\n                                if ( $h->{ax1} < $h->{an1} ) {\n                                    $self->element(\n                                        {\n                                            'Name' => 'Hsp_hit-frame',\n                                            'Data' => \"-@{[(($h->{px1} - $h->{ax1}) % 3) + 1]}\"\n                                        }\n                                    );\n                                }\n                                else {\n                                    $self->element(\n                                        {\n                                            'Name' => 'Hsp_hit-frame',\n                                            'Data' => \"+@{[(($h->{an1} - $h->{pn1}) % 3) + 1]}\"\n                                        }\n                                    );\n                                }\n                            }\n                            else {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_query-frame',\n                                        'Data' => $h->{lframe}\n                                    }\n                                );\n                                $self->element(\n                                    { 'Name' => 'Hsp_hit-frame', 'Data' => 0 }\n                                );\n                            }\n                        }\n                        else {\n                            $self->element(\n                                { 'Name' => 'Hsp_query-frame', 'Data' => 0 } );\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_hit-frame',\n                                    'Data' => $h->{lframe}\n                                }\n                            );\n                        }\n\n                        $self->end_element( { 'Name' => 'Hsp' } );\n                        $self->end_element( { 'Name' => 'Hit' } );\n                    }\n                }\n                $self->end_element( { 'Name' => 'FastaOutput' } );\n                $self->_pushback($_);\n                return $self->end_document();\n            }\n            else {\n                $self->start_element( { 'Name' => 'FastaOutput' } );\n                $self->{'_result_count'}++;\n                $seentop = 1;\n                $self->element(\n                    {\n                        'Name' => 'FastaOutput_program',\n                        'Data' => $self->{'_reporttype'}\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'FastaOutput_version',\n                        'Data' => $self->{'_version'}\n                    }\n                );\n\n                my ( $type, $querylen, $querytype, $querydef );\n\n                if (/^\\s*\\d+\\s*>>>(.*)/) {\n                    $querydef = $1;\n                    if ( $querydef =~ /^(.*?)\\s+(?:\\-\\s+)?(\\d+)\\s+(aa|nt).*$/o )\n                    {\n                        ( $querydef, $querylen, $querytype ) = ( $1, $2, $3 );\n                    }\n                }\n\n                if (   $self->{'_reporttype'}\n                    && $self->{'_reporttype'} eq 'FASTA' )\n                {\n                    if ( $querytype eq 'nt' ) {\n                        $self->{'_reporttype'} = 'FASTN';\n                    }\n                    elsif ( $querytype eq 'aa' ) {\n                        $self->{'_reporttype'} = 'FASTP';\n                    }\n                }\n                my ( $name, $descr ) =\n                  ( $querydef =~ m/^(\\S+)(?:\\s+(.*))?\\s*$/o );\n                $self->element(\n                    {\n                        'Name' => 'FastaOutput_query-def',\n                        'Data' => $name\n                    }\n                );\n                $self->element(\n                    {\n                        'Name' => 'FastaOutput_querydesc',\n                        'Data' => $descr\n                    }\n                );\n                if ($querylen) {\n                    $self->element(\n                        {\n                            'Name' => 'FastaOutput_query-len',\n                            'Data' => $querylen\n                        }\n                    );\n                }\n                else {\n                    $self->warn(\"unable to find and set query length\");\n                }\n                if ( defined( $_ = $self->_readline() )\n                    && ( /^\\s*vs\\s+(\\S+)/ || /^Library:\\s+(\\S+)/ ) )\n                {\n                    $self->element(\n                        {\n                            'Name' => 'FastaOutput_db',\n                            'Data' => $1\n                        }\n                    );\n                }\n\n            }\n        }\n        elsif ( $self->in_element('hsp') ) {\n            my @data  = ( [], [], [] );\n            my $count = 0;\n            my $len   = $self->idlength + 1;\n            my ($seq1_id);\n            while ( defined($_) ) {\n                chomp;\n                #$self->debug(\"$count $_\\n\");\n                if (/residues in \\d+\\s+query\\s+sequences/o) {\n                    $self->_pushback($_);\n                    last;\n                }\n                elsif (/^>>>\\*\\*\\*/o) {\n                    $self->end_element( { Name => \"Hsp\" } );\n                    last;\n                }\n                elsif (/^>>/o) {\n                    $self->_pushback($_);\n                    last;\n                }\n                elsif (/^\\s*\\d+\\s*>>>/o) {\n                    $self->_pushback($_);\n                    last;\n                }\n                if ( $count == 0 ) {\n                    if (/^(\\S+)\\s+/) {\n                        $self->_pushback($_);\n                        $count = 2;\n                    }\n                    elsif ( /^\\s+\\d+/ || /^\\s+$/ ) {\n\n                        # do nothing, this is really a 0 line\n                    }\n                    elsif ( length($_) == 0 ) {\n                        $count = -1;\n                    }\n                    else {\n                        $self->_pushback($_);\n                        $count = 0;\n                    }\n                }\n                elsif ( $count == 1 || $count == 3 ) {\n                    if (/^(\\S+)\\s+/) {\n                        $len = CORE::length($1) if $len < CORE::length($1);\n                        s/\\s+$//;    # trim trailing spaces,we don't want them\n                        push @{ $data[ $count - 1 ] }, substr( $_, $len );\n                    }\n                    elsif (/^\\s+(\\d+)/) {\n                        $count = -1;\n                        $self->_pushback($_);\n                    }\n                    elsif ( /^\\s+$/ || length($_) == 0 ) {\n                        $count = 5;\n\n                        # going to skip these\n                    }\n                    else {\n                        $self->throw(\n                            \"Unrecognized alignment line ($count) '$_'\");\n                    }\n                }\n                elsif ( $count == 2 ) {\n                    if (/^\\s+\\d+\\s+/) {\n                        $self->warn(\"$_\\n\") if $self->verbose > 0;\n\n                        # we are on a Subject part of the alignment\n                        # but we THOUGHT we were on the Query\n                        # move that last line to the proper place\n                        push @{ $data[2] }, pop @{ $data[0] };\n                        $count = 4;\n                    }\n                    else {\n\n                        # toss the first IDLENGTH characters of the line\n                        if ( length($_) >= $len ) {\n                            push @{ $data[ $count - 1 ] }, substr( $_, $len );\n                        }\n                    }\n                }\n                last if ( $count++ >= 5 );\n                $_ = $self->_readline();\n            }\n            if ( @{ $data[0] } || @{ $data[2] } ) {\n                $self->characters(\n                    {\n                        'Name' => 'Hsp_qseq',\n                        'Data' => join( '', @{ $data[0] } )\n                    }\n                );\n                $self->characters(\n                    {\n                        'Name' => 'Hsp_midline',\n                        'Data' => join( '', @{ $data[1] } )\n                    }\n                );\n                $self->characters(\n                    {\n                        'Name' => 'Hsp_hseq',\n                        'Data' => join( '', @{ $data[2] } )\n                    }\n                );\n            }\n        }\n        else {\n            if ( !$seentop ) {\n                $self->debug($_);\n                #$self->warn(\"unrecognized FASTA Family report file!\");\n                #return;\n            }\n        }\n    }\n    if ( $self->in_element('result') ) {\n        if ( $self->in_element('hsp') ) {\n            $self->end_element( { 'Name' => 'Hsp' } );\n        }\n        if ( $self->in_element('hit') ) {\n            $self->end_element( { 'Name' => 'Hit' } );\n        }\n        $self->end_element( { 'Name' => 'FastaOutput' } );\n    }\n    return $self->end_document();\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element {\n    my ( $self, $data ) = @_;\n\n    # we currently don't care about attributes\n    my $nm = $data->{'Name'};\n    if ( my $type = $MODEMAP{$nm} ) {\n        $self->_mode($type);\n        if ( my $handler = $self->_will_handle($type) ) {\n            my $func = sprintf( \"start_%s\", lc $type );\n            $handler->$func( $data->{'Attributes'} );\n        }\n        unshift @{ $self->{'_elements'} }, $type;\n    }\n    if ( $nm eq 'FastaOutput' ) {\n        $self->{'_values'} = {};\n        $self->{'_result'} = undef;\n        $self->{'_mode'}   = '';\n    }\n\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ( $self, $data ) = @_;\n    my $nm = $data->{'Name'};\n    my $rc;\n\n    # Hsp are sort of weird, in that they end when another\n    # object begins so have to detect this in end_element for now\n    if ( $nm eq 'Hsp' ) {\n        foreach (qw(Hsp_qseq Hsp_midline Hsp_hseq)) {\n            $self->element(\n                {\n                    'Name' => $_,\n                    'Data' => $self->{'_last_hspdata'}->{$_}\n                }\n            );\n        }\n        $self->{'_last_hspdata'} = {};\n    }\n\n    if ( my $type = $MODEMAP{$nm} ) {\n        if ( my $handler = $self->_will_handle($type) ) {\n            my $func = sprintf( \"end_%s\", lc $type );\n            $rc = $handler->$func( $self->{'_reporttype'}, $self->{'_values'} );\n        }\n        shift @{ $self->{'_elements'} };\n\n    }\n    elsif ( $MAPPING{$nm} ) {\n        if ( ref( $MAPPING{$nm} ) =~ /hash/i ) {\n            my $key = ( keys %{ $MAPPING{$nm} } )[0];\n            $self->{'_values'}->{$key}->{ $MAPPING{$nm}->{$key} } =\n              $self->{'_last_data'};\n        }\n        else {\n            $self->{'_values'}->{ $MAPPING{$nm} } = $self->{'_last_data'};\n        }\n    }\n    else {\n        $self->warn(\"unknown nm $nm, ignoring\\n\");\n    }\n    $self->{'_last_data'} = '';    # remove read data if we are at\n                                   # end of an element\n    $self->{'_result'} = $rc if ( $nm eq 'FastaOutput' );\n    return $rc;\n\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element {\n    my ( $self, $data ) = @_;\n    $self->start_element($data);\n    $self->characters($data);\n    $self->end_element($data);\n}\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string\n\n\n\nsub characters {\n    my ( $self, $data ) = @_;\n\n    return unless ( defined $data->{'Data'} );\n    if ( $data->{'Data'} =~ /^\\s+$/ ) {\n        return unless $data->{'Name'} =~ /Hsp\\_(midline|qseq|hseq)/;\n    }\n\n    if (   $self->in_element('hsp')\n        && $data->{'Name'} =~ /Hsp\\_(qseq|hseq|midline)/ )\n    {\n\n        $self->{'_last_hspdata'}->{ $data->{'Name'} } .= $data->{'Data'};\n    }\n\n    $self->{'_last_data'} = $data->{'Data'};\n}\n\n=head2 _mode\n\n Title   : _mode\n Usage   : $obj->_mode($newval)\n Function: \n Example : \n Returns : value of _mode\n Args    : newvalue (optional)\n\n\n\nsub _mode {\n    my ( $self, $value ) = @_;\n    if ( defined $value ) {\n        $self->{'_mode'} = $value;\n    }\n    return $self->{'_mode'};\n}\n\n=head2 within_element\n\n Title   : within_element\n Usage   : if( $eventgenerator->within_element($element) ) {}\n Function: Test if we are within a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name \n\n\n\nsub within_element {\n    my ( $self, $name ) = @_;\n    return 0\n      if (!defined $name && !defined $self->{'_elements'}\n        || scalar @{ $self->{'_elements'} } == 0 );\n    foreach ( @{ $self->{'_elements'} } ) {\n        if ( $_ eq $name || $_ eq $MODEMAP{$name} ) {\n            return 1;\n        }\n    }\n    return 0;\n}\n\n=head2 in_element\n\n Title   : in_element\n Usage   : if( $eventgenerator->in_element($element) ) {}\n Function: Test if we are in a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name \n\n\n\nsub in_element {\n    my ( $self, $name ) = @_;\n    return 0 if !defined $self->{'_elements'}->[0];\n    return (\n        $self->{'_elements'}->[0] eq $name\n          || ( exists $MODEMAP{$name}\n            && $self->{'_elements'}->[0] eq $MODEMAP{$name} )\n    );\n}\n\n=head2 start_document\n\n Title   : start_document\n Usage   : $eventgenerator->start_document\n Function: Handles a start document event\n Returns : none\n Args    : none\n\n\n\nsub start_document {\n    my ($self) = @_;\n    $self->{'_lasttype'} = '';\n    $self->{'_values'}   = {};\n    $self->{'_result'}   = undef;\n    $self->{'_mode'}     = '';\n    $self->{'_elements'} = [];\n}\n\n=head2 end_document\n\n Title   : end_document\n Usage   : $eventgenerator->end_document\n Function: Handles an end document event\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\n\nsub end_document {\n    my ( $self, @args ) = @_;\n    return $self->{'_result'};\n}\n\n=head2 idlength\n\n Title   : idlength\n Usage   : $obj->idlength($newval)\n Function: Internal storage of the length of the ID desc\n           in the HSP alignment blocks.  Defaults to\n           $IDLENGTH class variable value\n Returns : value of idlength\n Args    : newvalue (optional)\n\n\n\nsub idlength {\n    my ( $self, $value ) = @_;\n    if ( defined $value ) {\n        $self->{'_idlength'} = $value;\n    }\n    return $self->{'_idlength'} || $IDLENGTH;\n}\n\n=head2 result_count\n\n Title   : result_count\n Usage   : my $count = $searchio->result_count\n Function: Returns the number of results we have processed\n Returns : integer\n Args    : none\n\n\nsub result_count {\n    my $self = shift;\n    return $self->{'_result_count'};\n}\n\nsub attach_EventHandler {\n    my ( $self, $handler ) = @_;\n\n    $self->SUPER::attach_EventHandler($handler);\n\n    # Optimization: caching the EventHandler since it is used a lot\n    # during the parse.\n\n    $self->{'_handler_cache'} = $handler;\n    return;\n}\n\n=head2 _will_handle\n\n Title   : _will_handle\n Usage   : Private method. For internal use only.\n              if( $self->_will_handle($type) ) { ... }\n Function: Provides an optimized way to check whether or not an element of a \n           given type is to be handled.\n Returns : Reference to EventHandler object if the element type is to be handled.\n           undef if the element type is not to be handled.\n Args    : string containing type of element.\n\nOptimizations:\n\n=over 2\n\n* 1\n\nUsing the cached pointer to the EventHandler to minimize repeated\nlookups.\n\n* 2\n\nCaching the will_handle status for each type that is encountered so\nthat it only need be checked by calling\nhandler-E<gt>will_handle($type) once.\n\n\nThis does not lead to a major savings by itself (only 5-10%).  In\ncombination with other optimizations, or for large parse jobs, the\nsavings good be significant.\n\nTo test against the unoptimized version, remove the parentheses from\naround the third term in the ternary \" ? : \" operator and add two\ncalls to $self-E<gt>_eventHandler().","label":"_will_handle($self,$type)"}}],"version":5}