{"vars":[{"kind":2,"line":75,"name":"base","containerName":""},{"line":77,"kind":13,"localvar":"my","containerName":null,"definition":"my","name":"%MODEMAP"},{"kind":13,"line":83,"name":"%MAPPING","definition":"my","containerName":null,"localvar":"my"},{"kind":13,"line":138,"containerName":null,"name":"$MINSCORE","definition":"my","localvar":"my"},{"name":"$DEFAULT_VERSION","definition":"my","containerName":null,"localvar":"my","kind":13,"line":139},{"kind":13,"line":140,"containerName":null,"name":"$DEFAULT_ALGORITHM","definition":"my","localvar":"my"},{"name":"_initialize","range":{"start":{"line":157,"character":0},"end":{"line":194,"character":9999}},"definition":"sub","containerName":"main::","signature":{"label":"_initialize($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: erpin.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::erpin\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields <cjfields-at-uiuc-dot-edu>\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::erpin - SearchIO-based ERPIN parser\n\n=head1 SYNOPSIS\n\n  # do not call this module directly. Use Bio::SearchIO.\n\n=head1 DESCRIPTION\n\nThis is an experimental SearchIO-based parser for output from\nthe erpin program.  It currently parses erpin output for ERPIN\nversions 4.2.5 and above; older versions may work but will not be supported.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Fields\n\nEmail cjfields-at-uiuc-dot-edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::erpin;\nuse strict;\n\nuse Data::Dumper;\nuse base qw(Bio::SearchIO);\n\nmy %MODEMAP = (\n\t    'Result'             => 'result',\n\t    'Hit'                => 'hit',\n\t    'Hsp'                => 'hsp'\n\t    );\n\nmy %MAPPING = ( \n        'Hsp_bit-score'   => 'HSP-bits',\n        'Hsp_score'       => 'HSP-score',\n        'Hsp_evalue'      => 'HSP-evalue', # no evalues yet\n        'Hsp_query-from'  => 'HSP-query_start',\n        'Hsp_query-to'    => 'HSP-query_end',\n        'Hsp_hit-from'    => 'HSP-hit_start', #\n        'Hsp_hit-to'      => 'HSP-hit_end', #\n        'Hsp_gaps'        => 'HSP-hsp_gaps', \n        'Hsp_hitgaps'     => 'HSP-hit_gaps',\n        'Hsp_querygaps'   => 'HSP-query_gaps',\n        'Hsp_qseq'        => 'HSP-query_seq',\n        'Hsp_hseq'        => 'HSP-hit_seq',\n        'Hsp_midline'     => 'HSP-homology_seq',\n        'Hsp_structure'   => 'HSP-meta',\n        'Hsp_align-len'   => 'HSP-hsp_length',\n        'Hsp_stranded'    => 'HSP-stranded',\n        \n        # not supported yet\n        'Hsp_positive'    => 'HSP-conserved',\n        'Hsp_identity'    => 'HSP-identical',\n\n        'Hit_id'        => 'HIT-name',\n        'Hit_len'       => 'HIT-length',\n        'Hit_gi'        => 'HIT-ncbi_gi',\n        'Hit_accession' => 'HIT-accession',\n        'Hit_def'       => 'HIT-description',\n        'Hit_signif'    => 'HIT-significance', # none yet\n        'Hit_score'     => 'HIT-score', # best HSP bit score\n        'Hit_bits'      => 'HIT-bits', # best HSP bit score\n \n        'ERPIN_program'  => 'RESULT-algorithm_name', # get/set \n        'ERPIN_version'  => 'RESULT-algorithm_version', # get/set \n        'ERPIN_query-def'=> 'RESULT-query_name', # get/set \n        'ERPIN_query-len'=> 'RESULT-query_length', \n        'ERPIN_query-acc'=> 'RESULT-query_accession', # get/set \n        'ERPIN_querydesc'=> 'RESULT-query_description', # get/set\n        'ERPIN_db'       => 'RESULT-database_name',  # get/set \n        'ERPIN_db-len'   => 'RESULT-database_entries', # none yet\n        'ERPIN_db-let'   => 'RESULT-database_letters', # none yet\n        \n        'Parameters_cutoff'      => { 'RESULT-parameters' => 'cutoff' },\n        'Parameters_expect'      => { 'RESULT-parameters' => 'expect' },\n        \n        'Parameters_include'     => { 'RESULT-parameters' => 'include' },\n        'Parameters_sc-match'    => { 'RESULT-parameters' => 'match' },\n        'Parameters_sc-mismatch' => { 'RESULT-parameters' => 'mismatch' },\n        'Parameters_gap-open'    => { 'RESULT-parameters' => 'gapopen' },\n        'Parameters_gap-extend'  => { 'RESULT-parameters' => 'gapext' },\n        'Parameters_filter'      => { 'RESULT-parameters' => 'filter' },\n        'Parameters_allowgaps'   => { 'RESULT-parameters' => 'allowgaps' },\n        'Parameters_full_dbpath' => { 'RESULT-parameters' => 'full_dbpath' },        \n        'Statistics_db-let'      => { 'RESULT-statistics' => 'dbletters' },\n\t     );\n\nmy $MINSCORE = 0;\nmy $DEFAULT_VERSION = '4.2.5';\nmy $DEFAULT_ALGORITHM = 'erpin';\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::infernal->new();\n Function: Builds a new Bio::SearchIO::infernal object \n Returns : Bio::SearchIO::infernal\n Args    : -fh/-file     => cmsearch (infernal) filename\n           -format       => 'erpin'\n           -algorithm    => algorithm (default 'Infernal')\n           -query_acc    => query accession, eg. Rfam accession (default undef)\n           -hsp_minscore => minimum HSP score cutoff\n           -version      => ERPIN version (not reported in output)"},"detail":"($self,@args)","kind":12,"children":[{"kind":13,"line":158,"definition":"my","name":"$self","containerName":"_initialize","localvar":"my"},{"name":"@args","containerName":"_initialize","kind":13,"line":158},{"name":"$self","containerName":"_initialize","line":159,"kind":13},{"kind":13,"line":159,"name":"@args","containerName":"_initialize"},{"containerName":"_initialize","name":"$cutoff","definition":"my","localvar":"my","kind":13,"line":160},{"line":160,"kind":13,"containerName":"_initialize","name":"$accession"},{"containerName":"_initialize","name":"$version","kind":13,"line":160},{"line":161,"kind":13,"name":"$self","containerName":"_initialize"},{"containerName":"_initialize","name":"_rearrange","kind":12,"line":161},{"name":"@args","containerName":"_initialize","line":161,"kind":13},{"localvar":"my","definition":"my","name":"$handler","containerName":"_initialize","line":162,"kind":13},{"name":"$self","containerName":"_initialize","line":162,"kind":13},{"name":"_eventHandler","containerName":"_initialize","line":162,"kind":12},{"kind":13,"line":163,"name":"$handler","containerName":"_initialize"},{"name":"register_factory","containerName":"_initialize","kind":12,"line":163},{"kind":12,"line":165,"name":"new","containerName":"_initialize"},{"containerName":"_initialize","name":"$self","kind":13,"line":168},{"line":168,"kind":12,"name":"verbose","containerName":"_initialize"},{"containerName":"_initialize","name":"$handler","kind":13,"line":172},{"line":172,"kind":12,"name":"register_factory","containerName":"_initialize"},{"containerName":"_initialize","name":"new","kind":12,"line":174},{"containerName":"_initialize","name":"$self","line":177,"kind":13},{"name":"verbose","containerName":"_initialize","line":177,"kind":12},{"containerName":"_initialize","name":"$handler","kind":13,"line":181},{"kind":12,"line":181,"name":"register_factory","containerName":"_initialize"},{"line":183,"kind":12,"name":"new","containerName":"_initialize"},{"line":186,"kind":13,"name":"$self","containerName":"_initialize"},{"kind":12,"line":186,"containerName":"_initialize","name":"verbose"},{"containerName":"_initialize","name":"$accession","kind":13,"line":189},{"containerName":"_initialize","name":"$self","kind":13,"line":189},{"containerName":"_initialize","name":"query_accession","line":189,"kind":12},{"name":"$accession","containerName":"_initialize","line":189,"kind":13},{"containerName":"_initialize","name":"$cutoff","kind":13,"line":190},{"name":"$MINSCORE","containerName":"_initialize","line":190,"kind":13},{"kind":13,"line":191,"name":"$self","containerName":"_initialize"},{"line":191,"kind":12,"containerName":"_initialize","name":"hsp_minscore"},{"name":"$cutoff","containerName":"_initialize","line":191,"kind":13},{"kind":13,"line":192,"containerName":"_initialize","name":"$version"},{"line":192,"kind":13,"name":"$DEFAULT_VERSION","containerName":"_initialize"},{"name":"$self","containerName":"_initialize","line":193,"kind":13},{"kind":12,"line":193,"containerName":"_initialize","name":"algorithm_version"},{"line":193,"kind":13,"name":"$version","containerName":"_initialize"}],"line":157},{"containerName":"_initialize","name":"SUPER","kind":12,"line":159},{"kind":12,"line":165,"name":"Bio","containerName":"Factory::ObjectFactory"},{"name":"Bio","containerName":"Factory::ObjectFactory","line":174,"kind":12},{"name":"Bio","containerName":"Factory::ObjectFactory","line":183,"kind":12},{"line":206,"children":[{"definition":"my","name":"$self","containerName":"next_result","localvar":"my","kind":13,"line":207},{"line":208,"kind":13,"localvar":"my","containerName":"next_result","name":"$seentop","definition":"my"},{"kind":13,"line":211,"containerName":"next_result","definition":"my","name":"$accession","localvar":"my"},{"containerName":"next_result","name":"$self","line":211,"kind":13},{"kind":12,"line":211,"name":"query_accession","containerName":"next_result"},{"line":212,"kind":13,"localvar":"my","definition":"my","name":"$minscore","containerName":"next_result"},{"name":"$self","containerName":"next_result","kind":13,"line":212},{"line":212,"kind":12,"name":"hsp_minscore","containerName":"next_result"},{"name":"$version","definition":"my","containerName":"next_result","localvar":"my","kind":13,"line":213},{"kind":13,"line":213,"containerName":"next_result","name":"$self"},{"line":213,"kind":12,"containerName":"next_result","name":"algorithm_version"},{"localvar":"my","definition":"my","name":"$verbose","containerName":"next_result","line":214,"kind":13},{"name":"$self","containerName":"next_result","kind":13,"line":214},{"name":"verbose","containerName":"next_result","kind":12,"line":214},{"name":"$self","containerName":"next_result","line":215,"kind":13},{"kind":12,"line":215,"name":"start_document","containerName":"next_result"},{"localvar":"my","containerName":"next_result","definition":"my","name":"$lasthit","line":216,"kind":13},{"containerName":"next_result","name":"$lastscore","kind":13,"line":216},{"kind":13,"line":216,"containerName":"next_result","name":"$lastlen"},{"containerName":"next_result","name":"$lasteval","kind":13,"line":216},{"localvar":"my","containerName":"next_result","definition":"my","name":"$line","line":219,"kind":13},{"name":"$self","containerName":"next_result","kind":13,"line":219},{"containerName":"next_result","name":"_readline","line":219,"kind":12},{"kind":13,"line":220,"containerName":"next_result","name":"$line"},{"line":221,"kind":13,"name":"$line","containerName":"next_result"},{"containerName":"next_result","name":"$seentop","line":222,"kind":13},{"kind":13,"line":223,"name":"$self","containerName":"next_result"},{"line":223,"kind":12,"name":"_pushback","containerName":"next_result"},{"name":"$line","containerName":"next_result","kind":13,"line":223},{"line":226,"kind":13,"containerName":"next_result","name":"$self"},{"containerName":"next_result","name":"start_element","kind":12,"line":226},{"kind":13,"line":227,"name":"$self","containerName":"next_result"},{"name":"element_hash","containerName":"next_result","line":227,"kind":12},{"line":230,"kind":13,"containerName":"next_result","name":"$version"},{"containerName":"next_result","name":"$accession","kind":13,"line":231},{"line":233,"kind":13,"containerName":"next_result","name":"$seentop"},{"name":"$line","containerName":"next_result","kind":13,"line":236},{"name":"$self","containerName":"next_result","line":236,"kind":13},{"name":"_readline","containerName":"next_result","kind":12,"line":236},{"kind":13,"line":237,"name":"$line","containerName":"next_result"},{"containerName":"next_result","name":"$line","kind":13,"line":238},{"containerName":"next_result","name":"$line","line":239,"kind":13},{"line":240,"kind":13,"containerName":"next_result","name":"$self"},{"name":"_pushback","containerName":"next_result","line":240,"kind":12},{"containerName":"next_result","name":"$line","kind":13,"line":240},{"line":243,"kind":13,"name":"$line","containerName":"next_result"},{"line":244,"kind":13,"containerName":"next_result","name":"$self"},{"line":244,"kind":12,"containerName":"next_result","name":"element"},{"kind":13,"line":248,"containerName":"next_result","name":"$line"},{"containerName":"next_result","name":"$self","line":249,"kind":13},{"kind":12,"line":249,"containerName":"next_result","name":"element"},{"kind":13,"line":253,"containerName":"next_result","name":"$line"},{"name":"$self","containerName":"next_result","line":254,"kind":13},{"line":254,"kind":12,"name":"element","containerName":"next_result"},{"containerName":"next_result","name":"$line","kind":13,"line":258},{"containerName":"next_result","name":"$self","line":259,"kind":13},{"name":"element_hash","containerName":"next_result","kind":12,"line":259},{"kind":13,"line":263,"containerName":"next_result","name":"$line"},{"kind":13,"line":264,"containerName":"next_result","name":"$self"},{"kind":12,"line":264,"containerName":"next_result","name":"element"},{"containerName":"next_result","name":"$line","kind":13,"line":268},{"name":"$self","containerName":"next_result","line":269,"kind":13},{"kind":12,"line":269,"name":"element","containerName":"next_result"},{"name":"$line","containerName":"next_result","line":275,"kind":13},{"localvar":"my","containerName":"next_result","definition":"my","name":"$id","line":276,"kind":13},{"name":"$desc","containerName":"next_result","kind":13,"line":276},{"name":"$desc","containerName":"next_result","kind":13,"line":277},{"line":280,"kind":13,"containerName":"next_result","name":"$lasthit"},{"kind":13,"line":280,"containerName":"next_result","name":"$id"},{"line":280,"kind":13,"containerName":"next_result","name":"$lasthit"},{"containerName":"next_result","name":"$self","line":281,"kind":13},{"containerName":"next_result","name":"within_element","line":281,"kind":12},{"line":282,"kind":13,"name":"$self","containerName":"next_result"},{"line":282,"kind":12,"name":"element_hash","containerName":"next_result"},{"name":"$lasteval","containerName":"next_result","line":283,"kind":13},{"name":"$lastscore","containerName":"next_result","line":284,"kind":13},{"line":286,"kind":13,"containerName":"next_result","name":"$lastscore"},{"containerName":"next_result","name":"$self","kind":13,"line":287},{"line":287,"kind":12,"containerName":"next_result","name":"end_element"},{"line":289,"kind":13,"containerName":"next_result","name":"$self"},{"line":289,"kind":12,"name":"start_element","containerName":"next_result"},{"localvar":"my","definition":"my","name":"$gi","containerName":"next_result","line":290,"kind":13},{"name":"$acc","containerName":"next_result","kind":13,"line":290},{"kind":13,"line":290,"containerName":"next_result","name":"$ver"},{"line":290,"kind":13,"name":"$self","containerName":"next_result"},{"kind":12,"line":290,"containerName":"next_result","name":"_get_seq_identifiers"},{"line":290,"kind":13,"name":"$id","containerName":"next_result"},{"line":292,"kind":13,"containerName":"next_result","name":"$self"},{"kind":12,"line":292,"containerName":"next_result","name":"element_hash"},{"containerName":"next_result","name":"$id","kind":13,"line":293},{"containerName":"next_result","name":"$gi","kind":13,"line":294},{"containerName":"next_result","name":"$ver","kind":13,"line":295},{"containerName":"next_result","name":"$acc","line":296,"kind":13},{"kind":13,"line":296,"containerName":"next_result","name":"$acc"},{"line":296,"kind":13,"name":"$id","containerName":"next_result"},{"containerName":"next_result","name":"$desc","kind":13,"line":298},{"containerName":"next_result","name":"$lasthit","line":300,"kind":13},{"kind":13,"line":300,"name":"$id","containerName":"next_result"},{"name":"$line","containerName":"next_result","line":301,"kind":13},{"containerName":"next_result","name":"$line","kind":13,"line":301},{"localvar":"my","definition":"my","name":"$str","containerName":"next_result","line":302,"kind":13},{"containerName":"next_result","name":"$hn","kind":13,"line":302},{"name":"$pos","containerName":"next_result","line":302,"kind":13},{"line":302,"kind":13,"containerName":"next_result","name":"$score"},{"line":302,"kind":13,"containerName":"next_result","name":"$eval"},{"containerName":"next_result","name":"$line","line":302,"kind":13},{"containerName":"next_result","name":"$minscore","line":303,"kind":13},{"containerName":"next_result","name":"$score","kind":13,"line":303},{"kind":13,"line":304,"containerName":"next_result","name":"$self"},{"name":"start_element","containerName":"next_result","line":304,"kind":12},{"line":306,"kind":13,"localvar":"my","definition":"my","name":"$start","containerName":"next_result"},{"containerName":"next_result","name":"$end","kind":13,"line":306},{"kind":13,"line":306,"containerName":"next_result","name":"$pos"},{"containerName":"next_result","name":"$start","line":307,"kind":13},{"containerName":"next_result","name":"$end","kind":13,"line":307},{"kind":13,"line":307,"containerName":"next_result","name":"$end"},{"containerName":"next_result","name":"$start","line":307,"kind":13},{"containerName":"next_result","name":"$str","kind":13,"line":307},{"kind":13,"line":308,"containerName":"next_result","name":"$line"},{"containerName":"next_result","name":"$self","kind":13,"line":308},{"kind":12,"line":308,"name":"_readline","containerName":"next_result"},{"containerName":"next_result","name":"$line","line":309,"kind":13},{"containerName":"next_result","name":"$self","kind":13,"line":310},{"containerName":"next_result","name":"element_hash","line":310,"kind":12},{"name":"$start","containerName":"next_result","kind":13,"line":312},{"name":"$end","containerName":"next_result","line":313,"kind":13},{"line":314,"kind":13,"name":"$score","containerName":"next_result"},{"containerName":"next_result","name":"$score","line":315,"kind":13},{"kind":13,"line":316,"name":"$eval","containerName":"next_result"},{"name":"$line","containerName":"next_result","line":318,"kind":13},{"line":319,"kind":13,"name":"$line","containerName":"next_result"},{"kind":13,"line":321,"containerName":"next_result","name":"$line"},{"name":"$self","containerName":"next_result","line":322,"kind":13},{"kind":12,"line":322,"containerName":"next_result","name":"end_element"},{"containerName":"next_result","name":"$lastscore","line":323,"kind":13},{"kind":13,"line":323,"name":"$score","containerName":"next_result"},{"kind":13,"line":323,"name":"$lastscore","containerName":"next_result"},{"line":323,"kind":13,"name":"$lastscore","containerName":"next_result"},{"kind":13,"line":323,"containerName":"next_result","name":"$score"},{"line":324,"kind":13,"name":"$lasteval","containerName":"next_result"},{"kind":13,"line":324,"containerName":"next_result","name":"$eval"},{"line":324,"kind":13,"name":"$lasteval","containerName":"next_result"},{"kind":13,"line":324,"containerName":"next_result","name":"$lasteval"},{"kind":13,"line":324,"containerName":"next_result","name":"$eval"},{"line":330,"kind":13,"name":"$seentop","containerName":"next_result"},{"line":331,"kind":13,"containerName":"next_result","name":"$self"},{"line":331,"kind":12,"containerName":"next_result","name":"within_element"},{"kind":13,"line":332,"name":"$self","containerName":"next_result"},{"containerName":"next_result","name":"element_hash","kind":12,"line":332},{"line":333,"kind":13,"containerName":"next_result","name":"$lasteval"},{"kind":13,"line":334,"name":"$lastscore","containerName":"next_result"},{"line":336,"kind":13,"containerName":"next_result","name":"$lastscore"},{"containerName":"next_result","name":"$self","kind":13,"line":337},{"name":"end_element","containerName":"next_result","line":337,"kind":12},{"containerName":"next_result","name":"$self","line":339,"kind":13},{"kind":12,"line":339,"name":"end_element","containerName":"next_result"},{"line":341,"kind":13,"name":"$self","containerName":"next_result"},{"line":341,"kind":12,"name":"end_document","containerName":"next_result"}],"kind":12,"detail":"($self)","signature":{"documentation":"1;\n# $Id: erpin.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::erpin\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields <cjfields-at-uiuc-dot-edu>\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::erpin - SearchIO-based ERPIN parser\n\n=head1 SYNOPSIS\n\n  # do not call this module directly. Use Bio::SearchIO.\n\n=head1 DESCRIPTION\n\nThis is an experimental SearchIO-based parser for output from\nthe erpin program.  It currently parses erpin output for ERPIN\nversions 4.2.5 and above; older versions may work but will not be supported.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Fields\n\nEmail cjfields-at-uiuc-dot-edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::erpin;\nuse strict;\n\nuse Data::Dumper;\nuse base qw(Bio::SearchIO);\n\nmy %MODEMAP = (\n\t    'Result'             => 'result',\n\t    'Hit'                => 'hit',\n\t    'Hsp'                => 'hsp'\n\t    );\n\nmy %MAPPING = ( \n        'Hsp_bit-score'   => 'HSP-bits',\n        'Hsp_score'       => 'HSP-score',\n        'Hsp_evalue'      => 'HSP-evalue', # no evalues yet\n        'Hsp_query-from'  => 'HSP-query_start',\n        'Hsp_query-to'    => 'HSP-query_end',\n        'Hsp_hit-from'    => 'HSP-hit_start', #\n        'Hsp_hit-to'      => 'HSP-hit_end', #\n        'Hsp_gaps'        => 'HSP-hsp_gaps', \n        'Hsp_hitgaps'     => 'HSP-hit_gaps',\n        'Hsp_querygaps'   => 'HSP-query_gaps',\n        'Hsp_qseq'        => 'HSP-query_seq',\n        'Hsp_hseq'        => 'HSP-hit_seq',\n        'Hsp_midline'     => 'HSP-homology_seq',\n        'Hsp_structure'   => 'HSP-meta',\n        'Hsp_align-len'   => 'HSP-hsp_length',\n        'Hsp_stranded'    => 'HSP-stranded',\n        \n        # not supported yet\n        'Hsp_positive'    => 'HSP-conserved',\n        'Hsp_identity'    => 'HSP-identical',\n\n        'Hit_id'        => 'HIT-name',\n        'Hit_len'       => 'HIT-length',\n        'Hit_gi'        => 'HIT-ncbi_gi',\n        'Hit_accession' => 'HIT-accession',\n        'Hit_def'       => 'HIT-description',\n        'Hit_signif'    => 'HIT-significance', # none yet\n        'Hit_score'     => 'HIT-score', # best HSP bit score\n        'Hit_bits'      => 'HIT-bits', # best HSP bit score\n \n        'ERPIN_program'  => 'RESULT-algorithm_name', # get/set \n        'ERPIN_version'  => 'RESULT-algorithm_version', # get/set \n        'ERPIN_query-def'=> 'RESULT-query_name', # get/set \n        'ERPIN_query-len'=> 'RESULT-query_length', \n        'ERPIN_query-acc'=> 'RESULT-query_accession', # get/set \n        'ERPIN_querydesc'=> 'RESULT-query_description', # get/set\n        'ERPIN_db'       => 'RESULT-database_name',  # get/set \n        'ERPIN_db-len'   => 'RESULT-database_entries', # none yet\n        'ERPIN_db-let'   => 'RESULT-database_letters', # none yet\n        \n        'Parameters_cutoff'      => { 'RESULT-parameters' => 'cutoff' },\n        'Parameters_expect'      => { 'RESULT-parameters' => 'expect' },\n        \n        'Parameters_include'     => { 'RESULT-parameters' => 'include' },\n        'Parameters_sc-match'    => { 'RESULT-parameters' => 'match' },\n        'Parameters_sc-mismatch' => { 'RESULT-parameters' => 'mismatch' },\n        'Parameters_gap-open'    => { 'RESULT-parameters' => 'gapopen' },\n        'Parameters_gap-extend'  => { 'RESULT-parameters' => 'gapext' },\n        'Parameters_filter'      => { 'RESULT-parameters' => 'filter' },\n        'Parameters_allowgaps'   => { 'RESULT-parameters' => 'allowgaps' },\n        'Parameters_full_dbpath' => { 'RESULT-parameters' => 'full_dbpath' },        \n        'Statistics_db-let'      => { 'RESULT-statistics' => 'dbletters' },\n\t     );\n\nmy $MINSCORE = 0;\nmy $DEFAULT_VERSION = '4.2.5';\nmy $DEFAULT_ALGORITHM = 'erpin';\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::infernal->new();\n Function: Builds a new Bio::SearchIO::infernal object \n Returns : Bio::SearchIO::infernal\n Args    : -fh/-file     => cmsearch (infernal) filename\n           -format       => 'erpin'\n           -algorithm    => algorithm (default 'Infernal')\n           -query_acc    => query accession, eg. Rfam accession (default undef)\n           -hsp_minscore => minimum HSP score cutoff\n           -version      => ERPIN version (not reported in output)\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n    my ($cutoff, $accession, $version) =\n       $self->_rearrange([qw(HSP_MINSCORE QUERY_ACC VERSION)],@args);\n    my $handler = $self->_eventHandler;\n    $handler->register_factory(\n        'result',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Result::GenericResult',\n            -interface => 'Bio::Search::Result::ResultI',\n            -verbose   => $self->verbose()\n        )\n    );\n\n    $handler->register_factory(\n        'hit',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Hit::ModelHit',\n            -interface => 'Bio::Search::Hit::HitI',\n            -verbose   => $self->verbose()\n        )\n    );\n\n    $handler->register_factory(\n        'hsp',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::HSP::ModelHSP',\n            -interface => 'Bio::Search::HSP::HSPI',\n            -verbose   => $self->verbose()\n        )\n    );\n    $accession && $self->query_accession($accession);\n    $cutoff ||= $MINSCORE;\n    $self->hsp_minscore($cutoff);\n    $version ||= $DEFAULT_VERSION;\n    $self->algorithm_version($version);\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none","parameters":[{"label":"$self"}],"label":"next_result($self)"},"containerName":"main::","definition":"sub","range":{"end":{"character":9999,"line":342},"start":{"line":206,"character":0}},"name":"next_result"},{"kind":12,"line":218,"name":"PARSER"},{"name":"PARSER","kind":12,"line":224},{"name":"HEADER","kind":12,"line":235},{"line":241,"kind":12,"name":"HEADER"},{"kind":12,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"start_element","line":355,"kind":13},{"line":355,"kind":13,"containerName":"start_element","name":"$data"},{"kind":13,"line":358,"name":"$nm","definition":"my","containerName":"start_element","localvar":"my"},{"containerName":"start_element","name":"$data","line":358,"kind":13},{"line":359,"kind":13,"localvar":"my","definition":"my","name":"$type","containerName":"start_element"},{"containerName":"start_element","name":"$MODEMAP","line":359,"kind":13},{"name":"$nm","containerName":"start_element","line":359,"kind":13},{"name":"$type","containerName":"start_element","kind":13,"line":360},{"line":361,"kind":13,"name":"$self","containerName":"start_element"},{"containerName":"start_element","name":"_eventHandler","kind":12,"line":361},{"line":361,"kind":12,"containerName":"start_element","name":"will_handle"},{"name":"$type","containerName":"start_element","kind":13,"line":361},{"line":362,"kind":13,"localvar":"my","containerName":"start_element","definition":"my","name":"$func"},{"line":362,"kind":13,"name":"$type","containerName":"start_element"},{"name":"$self","containerName":"start_element","line":363,"kind":13},{"kind":12,"line":363,"name":"_eventHandler","containerName":"start_element"},{"line":363,"kind":13,"name":"$func","containerName":"start_element"},{"name":"$data","containerName":"start_element","line":363,"kind":13},{"containerName":"start_element","name":"$self","line":365,"kind":13},{"kind":13,"line":365,"containerName":"start_element","name":"$type"}],"line":354,"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"$data"}],"documentation":"1;\n# $Id: erpin.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::erpin\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields <cjfields-at-uiuc-dot-edu>\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::erpin - SearchIO-based ERPIN parser\n\n=head1 SYNOPSIS\n\n  # do not call this module directly. Use Bio::SearchIO.\n\n=head1 DESCRIPTION\n\nThis is an experimental SearchIO-based parser for output from\nthe erpin program.  It currently parses erpin output for ERPIN\nversions 4.2.5 and above; older versions may work but will not be supported.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Fields\n\nEmail cjfields-at-uiuc-dot-edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::erpin;\nuse strict;\n\nuse Data::Dumper;\nuse base qw(Bio::SearchIO);\n\nmy %MODEMAP = (\n\t    'Result'             => 'result',\n\t    'Hit'                => 'hit',\n\t    'Hsp'                => 'hsp'\n\t    );\n\nmy %MAPPING = ( \n        'Hsp_bit-score'   => 'HSP-bits',\n        'Hsp_score'       => 'HSP-score',\n        'Hsp_evalue'      => 'HSP-evalue', # no evalues yet\n        'Hsp_query-from'  => 'HSP-query_start',\n        'Hsp_query-to'    => 'HSP-query_end',\n        'Hsp_hit-from'    => 'HSP-hit_start', #\n        'Hsp_hit-to'      => 'HSP-hit_end', #\n        'Hsp_gaps'        => 'HSP-hsp_gaps', \n        'Hsp_hitgaps'     => 'HSP-hit_gaps',\n        'Hsp_querygaps'   => 'HSP-query_gaps',\n        'Hsp_qseq'        => 'HSP-query_seq',\n        'Hsp_hseq'        => 'HSP-hit_seq',\n        'Hsp_midline'     => 'HSP-homology_seq',\n        'Hsp_structure'   => 'HSP-meta',\n        'Hsp_align-len'   => 'HSP-hsp_length',\n        'Hsp_stranded'    => 'HSP-stranded',\n        \n        # not supported yet\n        'Hsp_positive'    => 'HSP-conserved',\n        'Hsp_identity'    => 'HSP-identical',\n\n        'Hit_id'        => 'HIT-name',\n        'Hit_len'       => 'HIT-length',\n        'Hit_gi'        => 'HIT-ncbi_gi',\n        'Hit_accession' => 'HIT-accession',\n        'Hit_def'       => 'HIT-description',\n        'Hit_signif'    => 'HIT-significance', # none yet\n        'Hit_score'     => 'HIT-score', # best HSP bit score\n        'Hit_bits'      => 'HIT-bits', # best HSP bit score\n \n        'ERPIN_program'  => 'RESULT-algorithm_name', # get/set \n        'ERPIN_version'  => 'RESULT-algorithm_version', # get/set \n        'ERPIN_query-def'=> 'RESULT-query_name', # get/set \n        'ERPIN_query-len'=> 'RESULT-query_length', \n        'ERPIN_query-acc'=> 'RESULT-query_accession', # get/set \n        'ERPIN_querydesc'=> 'RESULT-query_description', # get/set\n        'ERPIN_db'       => 'RESULT-database_name',  # get/set \n        'ERPIN_db-len'   => 'RESULT-database_entries', # none yet\n        'ERPIN_db-let'   => 'RESULT-database_letters', # none yet\n        \n        'Parameters_cutoff'      => { 'RESULT-parameters' => 'cutoff' },\n        'Parameters_expect'      => { 'RESULT-parameters' => 'expect' },\n        \n        'Parameters_include'     => { 'RESULT-parameters' => 'include' },\n        'Parameters_sc-match'    => { 'RESULT-parameters' => 'match' },\n        'Parameters_sc-mismatch' => { 'RESULT-parameters' => 'mismatch' },\n        'Parameters_gap-open'    => { 'RESULT-parameters' => 'gapopen' },\n        'Parameters_gap-extend'  => { 'RESULT-parameters' => 'gapext' },\n        'Parameters_filter'      => { 'RESULT-parameters' => 'filter' },\n        'Parameters_allowgaps'   => { 'RESULT-parameters' => 'allowgaps' },\n        'Parameters_full_dbpath' => { 'RESULT-parameters' => 'full_dbpath' },        \n        'Statistics_db-let'      => { 'RESULT-statistics' => 'dbletters' },\n\t     );\n\nmy $MINSCORE = 0;\nmy $DEFAULT_VERSION = '4.2.5';\nmy $DEFAULT_ALGORITHM = 'erpin';\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::infernal->new();\n Function: Builds a new Bio::SearchIO::infernal object \n Returns : Bio::SearchIO::infernal\n Args    : -fh/-file     => cmsearch (infernal) filename\n           -format       => 'erpin'\n           -algorithm    => algorithm (default 'Infernal')\n           -query_acc    => query accession, eg. Rfam accession (default undef)\n           -hsp_minscore => minimum HSP score cutoff\n           -version      => ERPIN version (not reported in output)\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n    my ($cutoff, $accession, $version) =\n       $self->_rearrange([qw(HSP_MINSCORE QUERY_ACC VERSION)],@args);\n    my $handler = $self->_eventHandler;\n    $handler->register_factory(\n        'result',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Result::GenericResult',\n            -interface => 'Bio::Search::Result::ResultI',\n            -verbose   => $self->verbose()\n        )\n    );\n\n    $handler->register_factory(\n        'hit',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Hit::ModelHit',\n            -interface => 'Bio::Search::Hit::HitI',\n            -verbose   => $self->verbose()\n        )\n    );\n\n    $handler->register_factory(\n        'hsp',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::HSP::ModelHSP',\n            -interface => 'Bio::Search::HSP::HSPI',\n            -verbose   => $self->verbose()\n        )\n    );\n    $accession && $self->query_accession($accession);\n    $cutoff ||= $MINSCORE;\n    $self->hsp_minscore($cutoff);\n    $version ||= $DEFAULT_VERSION;\n    $self->algorithm_version($version);\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    my $seentop = 0;\n    local $/ = \"\\n\";\n    local $_;\n    my $accession = $self->query_accession;\n    my $minscore = $self->hsp_minscore;\n    my $version = $self->algorithm_version;\n    my $verbose = $self->verbose;    # cache for speed?\n    $self->start_document();\n    my ($lasthit, $lastscore, $lastlen, $lasteval);\n    #my $hitline;\n    PARSER:\n    while ( defined( my $line = $self->_readline ) ) {\n        next if $line =~ m{^\\s*$};\n        if ($line =~ m{^Training\\sset:\\s+\"(.*)\"}xmso) {\n            if ($seentop) {\n                $self->_pushback($line);\n                last PARSER;\n            }\n            $self->start_element({'Name' => 'Result'});\n            $self->element_hash( {\n                'ERPIN_query-def'   => $1,\n                'ERPIN_program'     =>'erpin',\n                'ERPIN_version'     => $version,\n                'ERPIN_query-acc'   => $accession,\n                });\n            $seentop = 1;\n            # parse rest of header here\n            HEADER:\n            while (defined ($line = $self->_readline) ) {\n                next if $line =~ m{^\\s*$};\n                if (index($line, '>') == 0 ||\n                    index($line, '-------- at level 1 --------') == 0) {\n                    $self->_pushback($line);\n                    last HEADER;\n                }\n                if ($line =~ m{^\\s+(\\d+\\ssequences\\sof\\slength\\s\\d+)}xmso) {\n                    $self->element(\n                        {'Name' => 'ERPIN_querydesc',\n                         'Data' => $1}\n                       );\n                } elsif ($line =~ m{^Cutoff:\\s+(\\S+)}xmso) {\n                    $self->element(\n                        {'Name' => 'Parameters_cutoff',\n                         'Data' => $1}\n                                  );\n                } elsif ($line =~ m{^Database:\\s+\"(.*)\"}xmso) {\n                    $self->element(\n                        {'Name' => 'ERPIN_db',\n                         'Data' => $1}\n                       );\n                } elsif ($line =~ m{^\\s+(\\d+)\\snucleotides\\sto\\sbe\\sprocessed\\sin\\s(\\d+)\\ssequences}xmso) {\n                    $self->element_hash(\n                        {'ERPIN_db-len' => $2,\n                         'ERPIN_db-let' => $1}\n                       );\n                } elsif ($line =~ m{^E-value\\sat\\scutoff\\s\\S+\\sfor\\s\\S+\\sdouble\\sstrand\\sdata:\\s+(\\S+)}xmso) {\n                    $self->element(\n                                   {'Name' => 'Parameters_expect',\n                                    'Data' => $1}\n                                  );\n                } elsif ($line =~ m{^\\s+(ATGC\\sratios:\\s+(?:\\S+\\s+\\S+\\s+\\S+\\s+\\S+))}) {\n                    $self->element(\n                                   {'Name' => 'Statistics_db-let',\n                                    'Data' => $1}\n                                  );\n                }\n            }\n        } elsif ($line =~ m{^>(\\S+)\\s+(.*)}xmso ) {\n            my ($id, $desc) = ($1, $2);\n            chomp $desc;\n            # desc line is repeated for each strand, so must check\n            # prior to starting a new hit\n            if (!$lasthit || $id ne $lasthit) {\n                if ($self->within_element('hit') ) {\n                    $self->element_hash({\n                        'Hit_signif' => $lasteval,\n                        'Hit_score'  => $lastscore,\n                        'Hit_bits'   => $lastscore\n                        });\n                    $self->end_element({'Name' => 'Hit'});\n                }                \n                $self->start_element({'Name' => 'Hit'});\n                my ($gi, $acc, $ver) = $self->_get_seq_identifiers($id);\n            \n                $self->element_hash({\n                    'Hit_id'        => $id,\n                    'Hit_gi'        => $gi,\n                    'Hit_accession' => $ver ? \"$acc.$ver\" :\n                                        $acc ? $acc : $id,\n                    'Hit_def'       => $desc\n                    });\n            }\n            $lasthit = $id;\n        } elsif ( (index($line, 'FW') == 0) || (index($line, 'RC') == 0)) {\n            my ($str, $hn, $pos, $score, $eval) = split ' ', $line;\n            if ($minscore < $score) {\n                $self->start_element({'Name' => 'Hsp'});\n                \n                my ($start, $end) = split m{\\.\\.}, $pos, 2;\n                ($start, $end) = ($end, $start) if ($str eq 'RC');\n                $line = $self->_readline;\n                chomp $line;\n                $self->element_hash({\n                    'Hsp_stranded'     => 'HIT',\n                    'Hsp_hit-from'     => $start,\n                    'Hsp_hit-to'       => $end,\n                    'Hsp_score'        => $score,\n                    'Hsp_bit-score'    => $score,\n                    'Hsp_evalue'       => $eval,\n                    'Hsp_query-from'   => 1,\n                    'Hsp_query-to'     => length($line),\n                    'Hsp_align-len'    => length($line),\n                    'Hsp_hseq'         =>$line\n                    });\n                $self->end_element({'Name' => 'Hsp'});\n                $lastscore = $score if (!$lastscore || $lastscore < $score);\n                $lasteval = $eval if (!$lasteval || $lasteval > $eval);\n            }\n        } else {\n            #$self->debug(\"Dropped data: $line\");\n        }\n    }\n    if ($seentop) {\n        if ($self->within_element('hit')) {\n            $self->element_hash({\n                    'Hit_signif'    => $lasteval,\n                    'Hit_score'     => $lastscore,\n                    'Hit_bits'      => $lastscore\n                    });\n            $self->end_element({'Name' => 'Hit'}); \n        }\n        $self->end_element({'Name' => 'Result'});\n    }\n    return $self->end_document();\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'","label":"start_element($self,$data)"},"detail":"($self,$data)","name":"start_element","range":{"start":{"character":0,"line":354},"end":{"line":366,"character":9999}}},{"line":368,"kind":13,"containerName":null,"name":"$type"},{"kind":13,"line":368,"containerName":null,"name":"%type"},{"containerName":null,"name":"%self","kind":13,"line":370},{"line":371,"kind":13,"containerName":null,"name":"%self"},{"name":"end_element","range":{"start":{"character":0,"line":386},"end":{"line":399,"character":9999}},"kind":12,"line":386,"children":[{"localvar":"my","containerName":"end_element","definition":"my","name":"$self","line":387,"kind":13},{"line":387,"kind":13,"name":"$data","containerName":"end_element"},{"name":"$nm","definition":"my","containerName":"end_element","localvar":"my","kind":13,"line":388},{"kind":13,"line":388,"containerName":"end_element","name":"$data"},{"localvar":"my","containerName":"end_element","definition":"my","name":"$type","line":389,"kind":13},{"containerName":"end_element","name":"$MODEMAP","kind":13,"line":389},{"name":"$nm","containerName":"end_element","line":389,"kind":13},{"localvar":"my","containerName":"end_element","definition":"my","name":"$rc","line":390,"kind":13},{"containerName":"end_element","name":"$type","line":392,"kind":13},{"name":"$self","containerName":"end_element","line":393,"kind":13},{"name":"_eventHandler","containerName":"end_element","line":393,"kind":12},{"line":393,"kind":12,"name":"will_handle","containerName":"end_element"},{"containerName":"end_element","name":"$type","line":393,"kind":13},{"line":394,"kind":13,"localvar":"my","name":"$func","definition":"my","containerName":"end_element"},{"name":"$type","containerName":"end_element","kind":13,"line":394},{"kind":13,"line":395,"containerName":"end_element","name":"$rc"},{"kind":13,"line":395,"containerName":"end_element","name":"$self"},{"kind":12,"line":395,"containerName":"end_element","name":"_eventHandler"},{"containerName":"end_element","name":"$func","line":395,"kind":13},{"name":"$self","containerName":"end_element","kind":13,"line":395},{"line":396,"kind":13,"name":"$self","containerName":"end_element"},{"localvar":"my","containerName":"end_element","name":"$lastelem","definition":"my","line":398,"kind":13},{"kind":13,"line":398,"containerName":"end_element","name":"$self"}],"containerName":"main::","definition":"sub","detail":"($self,$data)","signature":{"parameters":[{"label":"$self"},{"label":"$data"}],"documentation":"1;\n# $Id: erpin.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::erpin\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields <cjfields-at-uiuc-dot-edu>\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::erpin - SearchIO-based ERPIN parser\n\n=head1 SYNOPSIS\n\n  # do not call this module directly. Use Bio::SearchIO.\n\n=head1 DESCRIPTION\n\nThis is an experimental SearchIO-based parser for output from\nthe erpin program.  It currently parses erpin output for ERPIN\nversions 4.2.5 and above; older versions may work but will not be supported.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Fields\n\nEmail cjfields-at-uiuc-dot-edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::erpin;\nuse strict;\n\nuse Data::Dumper;\nuse base qw(Bio::SearchIO);\n\nmy %MODEMAP = (\n\t    'Result'             => 'result',\n\t    'Hit'                => 'hit',\n\t    'Hsp'                => 'hsp'\n\t    );\n\nmy %MAPPING = ( \n        'Hsp_bit-score'   => 'HSP-bits',\n        'Hsp_score'       => 'HSP-score',\n        'Hsp_evalue'      => 'HSP-evalue', # no evalues yet\n        'Hsp_query-from'  => 'HSP-query_start',\n        'Hsp_query-to'    => 'HSP-query_end',\n        'Hsp_hit-from'    => 'HSP-hit_start', #\n        'Hsp_hit-to'      => 'HSP-hit_end', #\n        'Hsp_gaps'        => 'HSP-hsp_gaps', \n        'Hsp_hitgaps'     => 'HSP-hit_gaps',\n        'Hsp_querygaps'   => 'HSP-query_gaps',\n        'Hsp_qseq'        => 'HSP-query_seq',\n        'Hsp_hseq'        => 'HSP-hit_seq',\n        'Hsp_midline'     => 'HSP-homology_seq',\n        'Hsp_structure'   => 'HSP-meta',\n        'Hsp_align-len'   => 'HSP-hsp_length',\n        'Hsp_stranded'    => 'HSP-stranded',\n        \n        # not supported yet\n        'Hsp_positive'    => 'HSP-conserved',\n        'Hsp_identity'    => 'HSP-identical',\n\n        'Hit_id'        => 'HIT-name',\n        'Hit_len'       => 'HIT-length',\n        'Hit_gi'        => 'HIT-ncbi_gi',\n        'Hit_accession' => 'HIT-accession',\n        'Hit_def'       => 'HIT-description',\n        'Hit_signif'    => 'HIT-significance', # none yet\n        'Hit_score'     => 'HIT-score', # best HSP bit score\n        'Hit_bits'      => 'HIT-bits', # best HSP bit score\n \n        'ERPIN_program'  => 'RESULT-algorithm_name', # get/set \n        'ERPIN_version'  => 'RESULT-algorithm_version', # get/set \n        'ERPIN_query-def'=> 'RESULT-query_name', # get/set \n        'ERPIN_query-len'=> 'RESULT-query_length', \n        'ERPIN_query-acc'=> 'RESULT-query_accession', # get/set \n        'ERPIN_querydesc'=> 'RESULT-query_description', # get/set\n        'ERPIN_db'       => 'RESULT-database_name',  # get/set \n        'ERPIN_db-len'   => 'RESULT-database_entries', # none yet\n        'ERPIN_db-let'   => 'RESULT-database_letters', # none yet\n        \n        'Parameters_cutoff'      => { 'RESULT-parameters' => 'cutoff' },\n        'Parameters_expect'      => { 'RESULT-parameters' => 'expect' },\n        \n        'Parameters_include'     => { 'RESULT-parameters' => 'include' },\n        'Parameters_sc-match'    => { 'RESULT-parameters' => 'match' },\n        'Parameters_sc-mismatch' => { 'RESULT-parameters' => 'mismatch' },\n        'Parameters_gap-open'    => { 'RESULT-parameters' => 'gapopen' },\n        'Parameters_gap-extend'  => { 'RESULT-parameters' => 'gapext' },\n        'Parameters_filter'      => { 'RESULT-parameters' => 'filter' },\n        'Parameters_allowgaps'   => { 'RESULT-parameters' => 'allowgaps' },\n        'Parameters_full_dbpath' => { 'RESULT-parameters' => 'full_dbpath' },        \n        'Statistics_db-let'      => { 'RESULT-statistics' => 'dbletters' },\n\t     );\n\nmy $MINSCORE = 0;\nmy $DEFAULT_VERSION = '4.2.5';\nmy $DEFAULT_ALGORITHM = 'erpin';\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::infernal->new();\n Function: Builds a new Bio::SearchIO::infernal object \n Returns : Bio::SearchIO::infernal\n Args    : -fh/-file     => cmsearch (infernal) filename\n           -format       => 'erpin'\n           -algorithm    => algorithm (default 'Infernal')\n           -query_acc    => query accession, eg. Rfam accession (default undef)\n           -hsp_minscore => minimum HSP score cutoff\n           -version      => ERPIN version (not reported in output)\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n    my ($cutoff, $accession, $version) =\n       $self->_rearrange([qw(HSP_MINSCORE QUERY_ACC VERSION)],@args);\n    my $handler = $self->_eventHandler;\n    $handler->register_factory(\n        'result',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Result::GenericResult',\n            -interface => 'Bio::Search::Result::ResultI',\n            -verbose   => $self->verbose()\n        )\n    );\n\n    $handler->register_factory(\n        'hit',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Hit::ModelHit',\n            -interface => 'Bio::Search::Hit::HitI',\n            -verbose   => $self->verbose()\n        )\n    );\n\n    $handler->register_factory(\n        'hsp',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::HSP::ModelHSP',\n            -interface => 'Bio::Search::HSP::HSPI',\n            -verbose   => $self->verbose()\n        )\n    );\n    $accession && $self->query_accession($accession);\n    $cutoff ||= $MINSCORE;\n    $self->hsp_minscore($cutoff);\n    $version ||= $DEFAULT_VERSION;\n    $self->algorithm_version($version);\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    my $seentop = 0;\n    local $/ = \"\\n\";\n    local $_;\n    my $accession = $self->query_accession;\n    my $minscore = $self->hsp_minscore;\n    my $version = $self->algorithm_version;\n    my $verbose = $self->verbose;    # cache for speed?\n    $self->start_document();\n    my ($lasthit, $lastscore, $lastlen, $lasteval);\n    #my $hitline;\n    PARSER:\n    while ( defined( my $line = $self->_readline ) ) {\n        next if $line =~ m{^\\s*$};\n        if ($line =~ m{^Training\\sset:\\s+\"(.*)\"}xmso) {\n            if ($seentop) {\n                $self->_pushback($line);\n                last PARSER;\n            }\n            $self->start_element({'Name' => 'Result'});\n            $self->element_hash( {\n                'ERPIN_query-def'   => $1,\n                'ERPIN_program'     =>'erpin',\n                'ERPIN_version'     => $version,\n                'ERPIN_query-acc'   => $accession,\n                });\n            $seentop = 1;\n            # parse rest of header here\n            HEADER:\n            while (defined ($line = $self->_readline) ) {\n                next if $line =~ m{^\\s*$};\n                if (index($line, '>') == 0 ||\n                    index($line, '-------- at level 1 --------') == 0) {\n                    $self->_pushback($line);\n                    last HEADER;\n                }\n                if ($line =~ m{^\\s+(\\d+\\ssequences\\sof\\slength\\s\\d+)}xmso) {\n                    $self->element(\n                        {'Name' => 'ERPIN_querydesc',\n                         'Data' => $1}\n                       );\n                } elsif ($line =~ m{^Cutoff:\\s+(\\S+)}xmso) {\n                    $self->element(\n                        {'Name' => 'Parameters_cutoff',\n                         'Data' => $1}\n                                  );\n                } elsif ($line =~ m{^Database:\\s+\"(.*)\"}xmso) {\n                    $self->element(\n                        {'Name' => 'ERPIN_db',\n                         'Data' => $1}\n                       );\n                } elsif ($line =~ m{^\\s+(\\d+)\\snucleotides\\sto\\sbe\\sprocessed\\sin\\s(\\d+)\\ssequences}xmso) {\n                    $self->element_hash(\n                        {'ERPIN_db-len' => $2,\n                         'ERPIN_db-let' => $1}\n                       );\n                } elsif ($line =~ m{^E-value\\sat\\scutoff\\s\\S+\\sfor\\s\\S+\\sdouble\\sstrand\\sdata:\\s+(\\S+)}xmso) {\n                    $self->element(\n                                   {'Name' => 'Parameters_expect',\n                                    'Data' => $1}\n                                  );\n                } elsif ($line =~ m{^\\s+(ATGC\\sratios:\\s+(?:\\S+\\s+\\S+\\s+\\S+\\s+\\S+))}) {\n                    $self->element(\n                                   {'Name' => 'Statistics_db-let',\n                                    'Data' => $1}\n                                  );\n                }\n            }\n        } elsif ($line =~ m{^>(\\S+)\\s+(.*)}xmso ) {\n            my ($id, $desc) = ($1, $2);\n            chomp $desc;\n            # desc line is repeated for each strand, so must check\n            # prior to starting a new hit\n            if (!$lasthit || $id ne $lasthit) {\n                if ($self->within_element('hit') ) {\n                    $self->element_hash({\n                        'Hit_signif' => $lasteval,\n                        'Hit_score'  => $lastscore,\n                        'Hit_bits'   => $lastscore\n                        });\n                    $self->end_element({'Name' => 'Hit'});\n                }                \n                $self->start_element({'Name' => 'Hit'});\n                my ($gi, $acc, $ver) = $self->_get_seq_identifiers($id);\n            \n                $self->element_hash({\n                    'Hit_id'        => $id,\n                    'Hit_gi'        => $gi,\n                    'Hit_accession' => $ver ? \"$acc.$ver\" :\n                                        $acc ? $acc : $id,\n                    'Hit_def'       => $desc\n                    });\n            }\n            $lasthit = $id;\n        } elsif ( (index($line, 'FW') == 0) || (index($line, 'RC') == 0)) {\n            my ($str, $hn, $pos, $score, $eval) = split ' ', $line;\n            if ($minscore < $score) {\n                $self->start_element({'Name' => 'Hsp'});\n                \n                my ($start, $end) = split m{\\.\\.}, $pos, 2;\n                ($start, $end) = ($end, $start) if ($str eq 'RC');\n                $line = $self->_readline;\n                chomp $line;\n                $self->element_hash({\n                    'Hsp_stranded'     => 'HIT',\n                    'Hsp_hit-from'     => $start,\n                    'Hsp_hit-to'       => $end,\n                    'Hsp_score'        => $score,\n                    'Hsp_bit-score'    => $score,\n                    'Hsp_evalue'       => $eval,\n                    'Hsp_query-from'   => 1,\n                    'Hsp_query-to'     => length($line),\n                    'Hsp_align-len'    => length($line),\n                    'Hsp_hseq'         =>$line\n                    });\n                $self->end_element({'Name' => 'Hsp'});\n                $lastscore = $score if (!$lastscore || $lastscore < $score);\n                $lasteval = $eval if (!$lasteval || $lasteval > $eval);\n            }\n        } else {\n            #$self->debug(\"Dropped data: $line\");\n        }\n    }\n    if ($seentop) {\n        if ($self->within_element('hit')) {\n            $self->element_hash({\n                    'Hit_signif'    => $lasteval,\n                    'Hit_score'     => $lastscore,\n                    'Hit_bits'      => $lastscore\n                    });\n            $self->end_element({'Name' => 'Hit'}); \n        }\n        $self->end_element({'Name' => 'Result'});\n    }\n    return $self->end_document();\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\nsub start_element {\n    my ( $self, $data ) = @_;\n\n    # we currently don't care about attributes\n    my $nm   = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    if ($type) {\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = sprintf( \"start_%s\", lc $type );\n            $self->_eventHandler->$func( $data->{'Attributes'} );\n        }\n        unshift @{ $self->{'_elements'} }, $type;\n    }\n    if ( defined $type\n        && $type eq 'result' )\n    {\n        $self->{'_values'} = {};\n        $self->{'_result'} = undef;\n    }\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys, 'Data' and 'Name'","label":"end_element($self,$data)"}},{"name":"%MAPPING","containerName":null,"line":400,"kind":13},{"name":"%nm","containerName":null,"kind":13,"line":400},{"line":401,"kind":13,"containerName":null,"name":"%MAPPING"},{"line":401,"kind":13,"containerName":null,"name":"%nm"},{"localvar":"my","containerName":null,"name":"$key","definition":"my","line":402,"kind":13},{"containerName":null,"name":"%MAPPING","kind":13,"line":402},{"kind":13,"line":402,"containerName":null,"name":"@nm"},{"kind":13,"line":403,"name":"%self","containerName":null},{"containerName":null,"name":"%key","line":403,"kind":13},{"kind":13,"line":403,"name":"%MAPPING","containerName":null},{"kind":13,"line":403,"containerName":null,"name":"%nm"},{"containerName":null,"name":"$key","kind":13,"line":403},{"kind":13,"line":404,"name":"%self","containerName":null},{"line":407,"kind":13,"containerName":null,"name":"%self"},{"name":"%MAPPING","containerName":null,"kind":13,"line":407},{"name":"$nm","containerName":null,"line":407,"kind":13},{"name":"%self","containerName":null,"kind":13,"line":407},{"kind":13,"line":411,"name":"$self","containerName":null},{"containerName":"main::","name":"debug","line":411,"kind":12},{"line":413,"kind":13,"containerName":null,"name":"%self"},{"name":"%self","containerName":null,"line":415,"kind":13},{"kind":13,"line":415,"name":"$rc","containerName":null},{"kind":13,"line":415,"containerName":null,"name":"$type"},{"containerName":null,"name":"$type","line":415,"kind":13},{"kind":13,"line":416,"containerName":null,"name":"$rc"},{"definition":"sub","containerName":"main::","signature":{"label":"element($self,$data)","documentation":"1;\n# $Id: erpin.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::erpin\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields <cjfields-at-uiuc-dot-edu>\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::erpin - SearchIO-based ERPIN parser\n\n=head1 SYNOPSIS\n\n  # do not call this module directly. Use Bio::SearchIO.\n\n=head1 DESCRIPTION\n\nThis is an experimental SearchIO-based parser for output from\nthe erpin program.  It currently parses erpin output for ERPIN\nversions 4.2.5 and above; older versions may work but will not be supported.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Fields\n\nEmail cjfields-at-uiuc-dot-edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::erpin;\nuse strict;\n\nuse Data::Dumper;\nuse base qw(Bio::SearchIO);\n\nmy %MODEMAP = (\n\t    'Result'             => 'result',\n\t    'Hit'                => 'hit',\n\t    'Hsp'                => 'hsp'\n\t    );\n\nmy %MAPPING = ( \n        'Hsp_bit-score'   => 'HSP-bits',\n        'Hsp_score'       => 'HSP-score',\n        'Hsp_evalue'      => 'HSP-evalue', # no evalues yet\n        'Hsp_query-from'  => 'HSP-query_start',\n        'Hsp_query-to'    => 'HSP-query_end',\n        'Hsp_hit-from'    => 'HSP-hit_start', #\n        'Hsp_hit-to'      => 'HSP-hit_end', #\n        'Hsp_gaps'        => 'HSP-hsp_gaps', \n        'Hsp_hitgaps'     => 'HSP-hit_gaps',\n        'Hsp_querygaps'   => 'HSP-query_gaps',\n        'Hsp_qseq'        => 'HSP-query_seq',\n        'Hsp_hseq'        => 'HSP-hit_seq',\n        'Hsp_midline'     => 'HSP-homology_seq',\n        'Hsp_structure'   => 'HSP-meta',\n        'Hsp_align-len'   => 'HSP-hsp_length',\n        'Hsp_stranded'    => 'HSP-stranded',\n        \n        # not supported yet\n        'Hsp_positive'    => 'HSP-conserved',\n        'Hsp_identity'    => 'HSP-identical',\n\n        'Hit_id'        => 'HIT-name',\n        'Hit_len'       => 'HIT-length',\n        'Hit_gi'        => 'HIT-ncbi_gi',\n        'Hit_accession' => 'HIT-accession',\n        'Hit_def'       => 'HIT-description',\n        'Hit_signif'    => 'HIT-significance', # none yet\n        'Hit_score'     => 'HIT-score', # best HSP bit score\n        'Hit_bits'      => 'HIT-bits', # best HSP bit score\n \n        'ERPIN_program'  => 'RESULT-algorithm_name', # get/set \n        'ERPIN_version'  => 'RESULT-algorithm_version', # get/set \n        'ERPIN_query-def'=> 'RESULT-query_name', # get/set \n        'ERPIN_query-len'=> 'RESULT-query_length', \n        'ERPIN_query-acc'=> 'RESULT-query_accession', # get/set \n        'ERPIN_querydesc'=> 'RESULT-query_description', # get/set\n        'ERPIN_db'       => 'RESULT-database_name',  # get/set \n        'ERPIN_db-len'   => 'RESULT-database_entries', # none yet\n        'ERPIN_db-let'   => 'RESULT-database_letters', # none yet\n        \n        'Parameters_cutoff'      => { 'RESULT-parameters' => 'cutoff' },\n        'Parameters_expect'      => { 'RESULT-parameters' => 'expect' },\n        \n        'Parameters_include'     => { 'RESULT-parameters' => 'include' },\n        'Parameters_sc-match'    => { 'RESULT-parameters' => 'match' },\n        'Parameters_sc-mismatch' => { 'RESULT-parameters' => 'mismatch' },\n        'Parameters_gap-open'    => { 'RESULT-parameters' => 'gapopen' },\n        'Parameters_gap-extend'  => { 'RESULT-parameters' => 'gapext' },\n        'Parameters_filter'      => { 'RESULT-parameters' => 'filter' },\n        'Parameters_allowgaps'   => { 'RESULT-parameters' => 'allowgaps' },\n        'Parameters_full_dbpath' => { 'RESULT-parameters' => 'full_dbpath' },        \n        'Statistics_db-let'      => { 'RESULT-statistics' => 'dbletters' },\n\t     );\n\nmy $MINSCORE = 0;\nmy $DEFAULT_VERSION = '4.2.5';\nmy $DEFAULT_ALGORITHM = 'erpin';\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::infernal->new();\n Function: Builds a new Bio::SearchIO::infernal object \n Returns : Bio::SearchIO::infernal\n Args    : -fh/-file     => cmsearch (infernal) filename\n           -format       => 'erpin'\n           -algorithm    => algorithm (default 'Infernal')\n           -query_acc    => query accession, eg. Rfam accession (default undef)\n           -hsp_minscore => minimum HSP score cutoff\n           -version      => ERPIN version (not reported in output)\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n    my ($cutoff, $accession, $version) =\n       $self->_rearrange([qw(HSP_MINSCORE QUERY_ACC VERSION)],@args);\n    my $handler = $self->_eventHandler;\n    $handler->register_factory(\n        'result',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Result::GenericResult',\n            -interface => 'Bio::Search::Result::ResultI',\n            -verbose   => $self->verbose()\n        )\n    );\n\n    $handler->register_factory(\n        'hit',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Hit::ModelHit',\n            -interface => 'Bio::Search::Hit::HitI',\n            -verbose   => $self->verbose()\n        )\n    );\n\n    $handler->register_factory(\n        'hsp',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::HSP::ModelHSP',\n            -interface => 'Bio::Search::HSP::HSPI',\n            -verbose   => $self->verbose()\n        )\n    );\n    $accession && $self->query_accession($accession);\n    $cutoff ||= $MINSCORE;\n    $self->hsp_minscore($cutoff);\n    $version ||= $DEFAULT_VERSION;\n    $self->algorithm_version($version);\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    my $seentop = 0;\n    local $/ = \"\\n\";\n    local $_;\n    my $accession = $self->query_accession;\n    my $minscore = $self->hsp_minscore;\n    my $version = $self->algorithm_version;\n    my $verbose = $self->verbose;    # cache for speed?\n    $self->start_document();\n    my ($lasthit, $lastscore, $lastlen, $lasteval);\n    #my $hitline;\n    PARSER:\n    while ( defined( my $line = $self->_readline ) ) {\n        next if $line =~ m{^\\s*$};\n        if ($line =~ m{^Training\\sset:\\s+\"(.*)\"}xmso) {\n            if ($seentop) {\n                $self->_pushback($line);\n                last PARSER;\n            }\n            $self->start_element({'Name' => 'Result'});\n            $self->element_hash( {\n                'ERPIN_query-def'   => $1,\n                'ERPIN_program'     =>'erpin',\n                'ERPIN_version'     => $version,\n                'ERPIN_query-acc'   => $accession,\n                });\n            $seentop = 1;\n            # parse rest of header here\n            HEADER:\n            while (defined ($line = $self->_readline) ) {\n                next if $line =~ m{^\\s*$};\n                if (index($line, '>') == 0 ||\n                    index($line, '-------- at level 1 --------') == 0) {\n                    $self->_pushback($line);\n                    last HEADER;\n                }\n                if ($line =~ m{^\\s+(\\d+\\ssequences\\sof\\slength\\s\\d+)}xmso) {\n                    $self->element(\n                        {'Name' => 'ERPIN_querydesc',\n                         'Data' => $1}\n                       );\n                } elsif ($line =~ m{^Cutoff:\\s+(\\S+)}xmso) {\n                    $self->element(\n                        {'Name' => 'Parameters_cutoff',\n                         'Data' => $1}\n                                  );\n                } elsif ($line =~ m{^Database:\\s+\"(.*)\"}xmso) {\n                    $self->element(\n                        {'Name' => 'ERPIN_db',\n                         'Data' => $1}\n                       );\n                } elsif ($line =~ m{^\\s+(\\d+)\\snucleotides\\sto\\sbe\\sprocessed\\sin\\s(\\d+)\\ssequences}xmso) {\n                    $self->element_hash(\n                        {'ERPIN_db-len' => $2,\n                         'ERPIN_db-let' => $1}\n                       );\n                } elsif ($line =~ m{^E-value\\sat\\scutoff\\s\\S+\\sfor\\s\\S+\\sdouble\\sstrand\\sdata:\\s+(\\S+)}xmso) {\n                    $self->element(\n                                   {'Name' => 'Parameters_expect',\n                                    'Data' => $1}\n                                  );\n                } elsif ($line =~ m{^\\s+(ATGC\\sratios:\\s+(?:\\S+\\s+\\S+\\s+\\S+\\s+\\S+))}) {\n                    $self->element(\n                                   {'Name' => 'Statistics_db-let',\n                                    'Data' => $1}\n                                  );\n                }\n            }\n        } elsif ($line =~ m{^>(\\S+)\\s+(.*)}xmso ) {\n            my ($id, $desc) = ($1, $2);\n            chomp $desc;\n            # desc line is repeated for each strand, so must check\n            # prior to starting a new hit\n            if (!$lasthit || $id ne $lasthit) {\n                if ($self->within_element('hit') ) {\n                    $self->element_hash({\n                        'Hit_signif' => $lasteval,\n                        'Hit_score'  => $lastscore,\n                        'Hit_bits'   => $lastscore\n                        });\n                    $self->end_element({'Name' => 'Hit'});\n                }                \n                $self->start_element({'Name' => 'Hit'});\n                my ($gi, $acc, $ver) = $self->_get_seq_identifiers($id);\n            \n                $self->element_hash({\n                    'Hit_id'        => $id,\n                    'Hit_gi'        => $gi,\n                    'Hit_accession' => $ver ? \"$acc.$ver\" :\n                                        $acc ? $acc : $id,\n                    'Hit_def'       => $desc\n                    });\n            }\n            $lasthit = $id;\n        } elsif ( (index($line, 'FW') == 0) || (index($line, 'RC') == 0)) {\n            my ($str, $hn, $pos, $score, $eval) = split ' ', $line;\n            if ($minscore < $score) {\n                $self->start_element({'Name' => 'Hsp'});\n                \n                my ($start, $end) = split m{\\.\\.}, $pos, 2;\n                ($start, $end) = ($end, $start) if ($str eq 'RC');\n                $line = $self->_readline;\n                chomp $line;\n                $self->element_hash({\n                    'Hsp_stranded'     => 'HIT',\n                    'Hsp_hit-from'     => $start,\n                    'Hsp_hit-to'       => $end,\n                    'Hsp_score'        => $score,\n                    'Hsp_bit-score'    => $score,\n                    'Hsp_evalue'       => $eval,\n                    'Hsp_query-from'   => 1,\n                    'Hsp_query-to'     => length($line),\n                    'Hsp_align-len'    => length($line),\n                    'Hsp_hseq'         =>$line\n                    });\n                $self->end_element({'Name' => 'Hsp'});\n                $lastscore = $score if (!$lastscore || $lastscore < $score);\n                $lasteval = $eval if (!$lasteval || $lasteval > $eval);\n            }\n        } else {\n            #$self->debug(\"Dropped data: $line\");\n        }\n    }\n    if ($seentop) {\n        if ($self->within_element('hit')) {\n            $self->element_hash({\n                    'Hit_signif'    => $lasteval,\n                    'Hit_score'     => $lastscore,\n                    'Hit_bits'      => $lastscore\n                    });\n            $self->end_element({'Name' => 'Hit'}); \n        }\n        $self->end_element({'Name' => 'Result'});\n    }\n    return $self->end_document();\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\nsub start_element {\n    my ( $self, $data ) = @_;\n\n    # we currently don't care about attributes\n    my $nm   = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    if ($type) {\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = sprintf( \"start_%s\", lc $type );\n            $self->_eventHandler->$func( $data->{'Attributes'} );\n        }\n        unshift @{ $self->{'_elements'} }, $type;\n    }\n    if ( defined $type\n        && $type eq 'result' )\n    {\n        $self->{'_values'} = {};\n        $self->{'_result'} = undef;\n    }\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys, 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ( $self, $data ) = @_;\n    my $nm   = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    my $rc;\n\n    if ($type) {\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = sprintf( \"end_%s\", lc $type );\n            $rc = $self->_eventHandler->$func( $self->{'_reporttype'},\n                $self->{'_values'} );\n        }\n        my $lastelem = shift @{ $self->{'_elements'} };\n    }\n    elsif ( $MAPPING{$nm} ) {\n        if ( ref( $MAPPING{$nm} ) =~ /hash/i ) {\n            my $key = ( keys %{ $MAPPING{$nm} } )[0];\n            $self->{'_values'}->{$key}->{ $MAPPING{$nm}->{$key} } =\n              $self->{'_last_data'};\n        }\n        else {\n            $self->{'_values'}->{ $MAPPING{$nm} } = $self->{'_last_data'};\n        }\n    }\n    else {\n        $self->debug(\"unknown nm $nm, ignoring\\n\");\n    }\n    $self->{'_last_data'} = '';    # remove read data if we are at\n                                   # end of an element\n    $self->{'_result'} = $rc if ( defined $type && $type eq 'result' );\n    return $rc;\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convenience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'","parameters":[{"label":"$self"},{"label":"$data"}]},"detail":"($self,$data)","kind":12,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"element","line":431,"kind":13},{"containerName":"element","name":"$data","kind":13,"line":431},{"name":"$self","containerName":"element","line":433,"kind":13},{"name":"characters","containerName":"element","kind":12,"line":433},{"name":"$data","containerName":"element","kind":13,"line":433},{"line":434,"kind":13,"name":"$self","containerName":"element"},{"kind":12,"line":434,"containerName":"element","name":"end_element"},{"line":434,"kind":13,"name":"$data","containerName":"element"}],"line":430,"name":"element","range":{"start":{"line":430,"character":0},"end":{"character":9999,"line":435}}},{"name":"element_hash","range":{"end":{"line":453,"character":9999},"start":{"character":0,"line":450}},"definition":"sub","containerName":"main::","signature":{"label":"element_hash($self,$data)","documentation":"1;\n# $Id: erpin.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::erpin\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields <cjfields-at-uiuc-dot-edu>\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::erpin - SearchIO-based ERPIN parser\n\n=head1 SYNOPSIS\n\n  # do not call this module directly. Use Bio::SearchIO.\n\n=head1 DESCRIPTION\n\nThis is an experimental SearchIO-based parser for output from\nthe erpin program.  It currently parses erpin output for ERPIN\nversions 4.2.5 and above; older versions may work but will not be supported.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Fields\n\nEmail cjfields-at-uiuc-dot-edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::erpin;\nuse strict;\n\nuse Data::Dumper;\nuse base qw(Bio::SearchIO);\n\nmy %MODEMAP = (\n\t    'Result'             => 'result',\n\t    'Hit'                => 'hit',\n\t    'Hsp'                => 'hsp'\n\t    );\n\nmy %MAPPING = ( \n        'Hsp_bit-score'   => 'HSP-bits',\n        'Hsp_score'       => 'HSP-score',\n        'Hsp_evalue'      => 'HSP-evalue', # no evalues yet\n        'Hsp_query-from'  => 'HSP-query_start',\n        'Hsp_query-to'    => 'HSP-query_end',\n        'Hsp_hit-from'    => 'HSP-hit_start', #\n        'Hsp_hit-to'      => 'HSP-hit_end', #\n        'Hsp_gaps'        => 'HSP-hsp_gaps', \n        'Hsp_hitgaps'     => 'HSP-hit_gaps',\n        'Hsp_querygaps'   => 'HSP-query_gaps',\n        'Hsp_qseq'        => 'HSP-query_seq',\n        'Hsp_hseq'        => 'HSP-hit_seq',\n        'Hsp_midline'     => 'HSP-homology_seq',\n        'Hsp_structure'   => 'HSP-meta',\n        'Hsp_align-len'   => 'HSP-hsp_length',\n        'Hsp_stranded'    => 'HSP-stranded',\n        \n        # not supported yet\n        'Hsp_positive'    => 'HSP-conserved',\n        'Hsp_identity'    => 'HSP-identical',\n\n        'Hit_id'        => 'HIT-name',\n        'Hit_len'       => 'HIT-length',\n        'Hit_gi'        => 'HIT-ncbi_gi',\n        'Hit_accession' => 'HIT-accession',\n        'Hit_def'       => 'HIT-description',\n        'Hit_signif'    => 'HIT-significance', # none yet\n        'Hit_score'     => 'HIT-score', # best HSP bit score\n        'Hit_bits'      => 'HIT-bits', # best HSP bit score\n \n        'ERPIN_program'  => 'RESULT-algorithm_name', # get/set \n        'ERPIN_version'  => 'RESULT-algorithm_version', # get/set \n        'ERPIN_query-def'=> 'RESULT-query_name', # get/set \n        'ERPIN_query-len'=> 'RESULT-query_length', \n        'ERPIN_query-acc'=> 'RESULT-query_accession', # get/set \n        'ERPIN_querydesc'=> 'RESULT-query_description', # get/set\n        'ERPIN_db'       => 'RESULT-database_name',  # get/set \n        'ERPIN_db-len'   => 'RESULT-database_entries', # none yet\n        'ERPIN_db-let'   => 'RESULT-database_letters', # none yet\n        \n        'Parameters_cutoff'      => { 'RESULT-parameters' => 'cutoff' },\n        'Parameters_expect'      => { 'RESULT-parameters' => 'expect' },\n        \n        'Parameters_include'     => { 'RESULT-parameters' => 'include' },\n        'Parameters_sc-match'    => { 'RESULT-parameters' => 'match' },\n        'Parameters_sc-mismatch' => { 'RESULT-parameters' => 'mismatch' },\n        'Parameters_gap-open'    => { 'RESULT-parameters' => 'gapopen' },\n        'Parameters_gap-extend'  => { 'RESULT-parameters' => 'gapext' },\n        'Parameters_filter'      => { 'RESULT-parameters' => 'filter' },\n        'Parameters_allowgaps'   => { 'RESULT-parameters' => 'allowgaps' },\n        'Parameters_full_dbpath' => { 'RESULT-parameters' => 'full_dbpath' },        \n        'Statistics_db-let'      => { 'RESULT-statistics' => 'dbletters' },\n\t     );\n\nmy $MINSCORE = 0;\nmy $DEFAULT_VERSION = '4.2.5';\nmy $DEFAULT_ALGORITHM = 'erpin';\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::infernal->new();\n Function: Builds a new Bio::SearchIO::infernal object \n Returns : Bio::SearchIO::infernal\n Args    : -fh/-file     => cmsearch (infernal) filename\n           -format       => 'erpin'\n           -algorithm    => algorithm (default 'Infernal')\n           -query_acc    => query accession, eg. Rfam accession (default undef)\n           -hsp_minscore => minimum HSP score cutoff\n           -version      => ERPIN version (not reported in output)\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n    my ($cutoff, $accession, $version) =\n       $self->_rearrange([qw(HSP_MINSCORE QUERY_ACC VERSION)],@args);\n    my $handler = $self->_eventHandler;\n    $handler->register_factory(\n        'result',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Result::GenericResult',\n            -interface => 'Bio::Search::Result::ResultI',\n            -verbose   => $self->verbose()\n        )\n    );\n\n    $handler->register_factory(\n        'hit',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Hit::ModelHit',\n            -interface => 'Bio::Search::Hit::HitI',\n            -verbose   => $self->verbose()\n        )\n    );\n\n    $handler->register_factory(\n        'hsp',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::HSP::ModelHSP',\n            -interface => 'Bio::Search::HSP::HSPI',\n            -verbose   => $self->verbose()\n        )\n    );\n    $accession && $self->query_accession($accession);\n    $cutoff ||= $MINSCORE;\n    $self->hsp_minscore($cutoff);\n    $version ||= $DEFAULT_VERSION;\n    $self->algorithm_version($version);\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    my $seentop = 0;\n    local $/ = \"\\n\";\n    local $_;\n    my $accession = $self->query_accession;\n    my $minscore = $self->hsp_minscore;\n    my $version = $self->algorithm_version;\n    my $verbose = $self->verbose;    # cache for speed?\n    $self->start_document();\n    my ($lasthit, $lastscore, $lastlen, $lasteval);\n    #my $hitline;\n    PARSER:\n    while ( defined( my $line = $self->_readline ) ) {\n        next if $line =~ m{^\\s*$};\n        if ($line =~ m{^Training\\sset:\\s+\"(.*)\"}xmso) {\n            if ($seentop) {\n                $self->_pushback($line);\n                last PARSER;\n            }\n            $self->start_element({'Name' => 'Result'});\n            $self->element_hash( {\n                'ERPIN_query-def'   => $1,\n                'ERPIN_program'     =>'erpin',\n                'ERPIN_version'     => $version,\n                'ERPIN_query-acc'   => $accession,\n                });\n            $seentop = 1;\n            # parse rest of header here\n            HEADER:\n            while (defined ($line = $self->_readline) ) {\n                next if $line =~ m{^\\s*$};\n                if (index($line, '>') == 0 ||\n                    index($line, '-------- at level 1 --------') == 0) {\n                    $self->_pushback($line);\n                    last HEADER;\n                }\n                if ($line =~ m{^\\s+(\\d+\\ssequences\\sof\\slength\\s\\d+)}xmso) {\n                    $self->element(\n                        {'Name' => 'ERPIN_querydesc',\n                         'Data' => $1}\n                       );\n                } elsif ($line =~ m{^Cutoff:\\s+(\\S+)}xmso) {\n                    $self->element(\n                        {'Name' => 'Parameters_cutoff',\n                         'Data' => $1}\n                                  );\n                } elsif ($line =~ m{^Database:\\s+\"(.*)\"}xmso) {\n                    $self->element(\n                        {'Name' => 'ERPIN_db',\n                         'Data' => $1}\n                       );\n                } elsif ($line =~ m{^\\s+(\\d+)\\snucleotides\\sto\\sbe\\sprocessed\\sin\\s(\\d+)\\ssequences}xmso) {\n                    $self->element_hash(\n                        {'ERPIN_db-len' => $2,\n                         'ERPIN_db-let' => $1}\n                       );\n                } elsif ($line =~ m{^E-value\\sat\\scutoff\\s\\S+\\sfor\\s\\S+\\sdouble\\sstrand\\sdata:\\s+(\\S+)}xmso) {\n                    $self->element(\n                                   {'Name' => 'Parameters_expect',\n                                    'Data' => $1}\n                                  );\n                } elsif ($line =~ m{^\\s+(ATGC\\sratios:\\s+(?:\\S+\\s+\\S+\\s+\\S+\\s+\\S+))}) {\n                    $self->element(\n                                   {'Name' => 'Statistics_db-let',\n                                    'Data' => $1}\n                                  );\n                }\n            }\n        } elsif ($line =~ m{^>(\\S+)\\s+(.*)}xmso ) {\n            my ($id, $desc) = ($1, $2);\n            chomp $desc;\n            # desc line is repeated for each strand, so must check\n            # prior to starting a new hit\n            if (!$lasthit || $id ne $lasthit) {\n                if ($self->within_element('hit') ) {\n                    $self->element_hash({\n                        'Hit_signif' => $lasteval,\n                        'Hit_score'  => $lastscore,\n                        'Hit_bits'   => $lastscore\n                        });\n                    $self->end_element({'Name' => 'Hit'});\n                }                \n                $self->start_element({'Name' => 'Hit'});\n                my ($gi, $acc, $ver) = $self->_get_seq_identifiers($id);\n            \n                $self->element_hash({\n                    'Hit_id'        => $id,\n                    'Hit_gi'        => $gi,\n                    'Hit_accession' => $ver ? \"$acc.$ver\" :\n                                        $acc ? $acc : $id,\n                    'Hit_def'       => $desc\n                    });\n            }\n            $lasthit = $id;\n        } elsif ( (index($line, 'FW') == 0) || (index($line, 'RC') == 0)) {\n            my ($str, $hn, $pos, $score, $eval) = split ' ', $line;\n            if ($minscore < $score) {\n                $self->start_element({'Name' => 'Hsp'});\n                \n                my ($start, $end) = split m{\\.\\.}, $pos, 2;\n                ($start, $end) = ($end, $start) if ($str eq 'RC');\n                $line = $self->_readline;\n                chomp $line;\n                $self->element_hash({\n                    'Hsp_stranded'     => 'HIT',\n                    'Hsp_hit-from'     => $start,\n                    'Hsp_hit-to'       => $end,\n                    'Hsp_score'        => $score,\n                    'Hsp_bit-score'    => $score,\n                    'Hsp_evalue'       => $eval,\n                    'Hsp_query-from'   => 1,\n                    'Hsp_query-to'     => length($line),\n                    'Hsp_align-len'    => length($line),\n                    'Hsp_hseq'         =>$line\n                    });\n                $self->end_element({'Name' => 'Hsp'});\n                $lastscore = $score if (!$lastscore || $lastscore < $score);\n                $lasteval = $eval if (!$lasteval || $lasteval > $eval);\n            }\n        } else {\n            #$self->debug(\"Dropped data: $line\");\n        }\n    }\n    if ($seentop) {\n        if ($self->within_element('hit')) {\n            $self->element_hash({\n                    'Hit_signif'    => $lasteval,\n                    'Hit_score'     => $lastscore,\n                    'Hit_bits'      => $lastscore\n                    });\n            $self->end_element({'Name' => 'Hit'}); \n        }\n        $self->end_element({'Name' => 'Result'});\n    }\n    return $self->end_document();\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\nsub start_element {\n    my ( $self, $data ) = @_;\n\n    # we currently don't care about attributes\n    my $nm   = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    if ($type) {\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = sprintf( \"start_%s\", lc $type );\n            $self->_eventHandler->$func( $data->{'Attributes'} );\n        }\n        unshift @{ $self->{'_elements'} }, $type;\n    }\n    if ( defined $type\n        && $type eq 'result' )\n    {\n        $self->{'_values'} = {};\n        $self->{'_result'} = undef;\n    }\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys, 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ( $self, $data ) = @_;\n    my $nm   = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    my $rc;\n\n    if ($type) {\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = sprintf( \"end_%s\", lc $type );\n            $rc = $self->_eventHandler->$func( $self->{'_reporttype'},\n                $self->{'_values'} );\n        }\n        my $lastelem = shift @{ $self->{'_elements'} };\n    }\n    elsif ( $MAPPING{$nm} ) {\n        if ( ref( $MAPPING{$nm} ) =~ /hash/i ) {\n            my $key = ( keys %{ $MAPPING{$nm} } )[0];\n            $self->{'_values'}->{$key}->{ $MAPPING{$nm}->{$key} } =\n              $self->{'_last_data'};\n        }\n        else {\n            $self->{'_values'}->{ $MAPPING{$nm} } = $self->{'_last_data'};\n        }\n    }\n    else {\n        $self->debug(\"unknown nm $nm, ignoring\\n\");\n    }\n    $self->{'_last_data'} = '';    # remove read data if we are at\n                                   # end of an element\n    $self->{'_result'} = $rc if ( defined $type && $type eq 'result' );\n    return $rc;\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convenience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element {\n    my ( $self, $data ) = @_;\n    # simple data calls (%MAPPING) do not need start_element\n    $self->characters($data);\n    $self->end_element($data);\n}\n\n=head2 element_hash\n\n Title   : element\n Usage   : $eventhandler->element_hash({'Hsp_hit-from' => $start,\n                                        'Hsp_hit-to'   => $end,\n                                        'Hsp_score'    => $lastscore});\n Function: Convenience method that takes multiple simple data elements and\n           maps to appropriate parameters\n Returns : none\n Args    : Hash ref with the mapped key (in %MAPPING) and value","parameters":[{"label":"$self"},{"label":"$data"}]},"detail":"($self,$data)","kind":12,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"element_hash","line":451,"kind":13},{"kind":13,"line":451,"name":"$data","containerName":"element_hash"},{"kind":13,"line":452,"name":"$self","containerName":"element_hash"},{"name":"throw","containerName":"element_hash","line":452,"kind":12},{"kind":13,"line":452,"containerName":"element_hash","name":"$data"},{"kind":13,"line":452,"containerName":"element_hash","name":"$data"},{"definition":"my","name":"$nm","containerName":"element_hash","localvar":"my","kind":13,"line":453},{"line":453,"kind":13,"name":"$data","containerName":"element_hash"}],"line":450},{"name":"%data","containerName":null,"line":454,"kind":13},{"containerName":null,"name":"$nm","kind":13,"line":454},{"name":"%data","containerName":null,"line":454,"kind":13},{"containerName":null,"name":"$nm","line":454,"kind":13},{"line":455,"kind":13,"containerName":null,"name":"%MAPPING"},{"line":455,"kind":13,"containerName":null,"name":"%nm"},{"kind":13,"line":456,"containerName":null,"name":"%MAPPING"},{"kind":13,"line":456,"name":"%nm","containerName":null},{"kind":13,"line":457,"containerName":null,"name":"$key","definition":"my","localvar":"my"},{"containerName":null,"name":"%MAPPING","line":457,"kind":13},{"line":457,"kind":13,"containerName":null,"name":"@nm"},{"line":458,"kind":13,"name":"%self","containerName":null},{"line":458,"kind":13,"containerName":null,"name":"%key"},{"name":"%MAPPING","containerName":null,"line":458,"kind":13},{"containerName":null,"name":"%nm","line":458,"kind":13},{"line":458,"kind":13,"containerName":null,"name":"$key"},{"name":"%data","containerName":null,"kind":13,"line":459},{"line":459,"kind":13,"containerName":null,"name":"%nm"},{"name":"%self","containerName":null,"kind":13,"line":462},{"line":462,"kind":13,"containerName":null,"name":"%MAPPING"},{"name":"$nm","containerName":null,"kind":13,"line":462},{"line":462,"kind":13,"containerName":null,"name":"%data"},{"name":"$nm","containerName":null,"line":462,"kind":13},{"range":{"end":{"character":9999,"line":483},"start":{"character":0,"line":479}},"name":"characters","detail":"($self,$data)","signature":{"label":"characters($self,$data)","parameters":[{"label":"$self"},{"label":"$data"}],"documentation":"1;\n# $Id: erpin.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::erpin\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields <cjfields-at-uiuc-dot-edu>\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::erpin - SearchIO-based ERPIN parser\n\n=head1 SYNOPSIS\n\n  # do not call this module directly. Use Bio::SearchIO.\n\n=head1 DESCRIPTION\n\nThis is an experimental SearchIO-based parser for output from\nthe erpin program.  It currently parses erpin output for ERPIN\nversions 4.2.5 and above; older versions may work but will not be supported.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Fields\n\nEmail cjfields-at-uiuc-dot-edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::erpin;\nuse strict;\n\nuse Data::Dumper;\nuse base qw(Bio::SearchIO);\n\nmy %MODEMAP = (\n\t    'Result'             => 'result',\n\t    'Hit'                => 'hit',\n\t    'Hsp'                => 'hsp'\n\t    );\n\nmy %MAPPING = ( \n        'Hsp_bit-score'   => 'HSP-bits',\n        'Hsp_score'       => 'HSP-score',\n        'Hsp_evalue'      => 'HSP-evalue', # no evalues yet\n        'Hsp_query-from'  => 'HSP-query_start',\n        'Hsp_query-to'    => 'HSP-query_end',\n        'Hsp_hit-from'    => 'HSP-hit_start', #\n        'Hsp_hit-to'      => 'HSP-hit_end', #\n        'Hsp_gaps'        => 'HSP-hsp_gaps', \n        'Hsp_hitgaps'     => 'HSP-hit_gaps',\n        'Hsp_querygaps'   => 'HSP-query_gaps',\n        'Hsp_qseq'        => 'HSP-query_seq',\n        'Hsp_hseq'        => 'HSP-hit_seq',\n        'Hsp_midline'     => 'HSP-homology_seq',\n        'Hsp_structure'   => 'HSP-meta',\n        'Hsp_align-len'   => 'HSP-hsp_length',\n        'Hsp_stranded'    => 'HSP-stranded',\n        \n        # not supported yet\n        'Hsp_positive'    => 'HSP-conserved',\n        'Hsp_identity'    => 'HSP-identical',\n\n        'Hit_id'        => 'HIT-name',\n        'Hit_len'       => 'HIT-length',\n        'Hit_gi'        => 'HIT-ncbi_gi',\n        'Hit_accession' => 'HIT-accession',\n        'Hit_def'       => 'HIT-description',\n        'Hit_signif'    => 'HIT-significance', # none yet\n        'Hit_score'     => 'HIT-score', # best HSP bit score\n        'Hit_bits'      => 'HIT-bits', # best HSP bit score\n \n        'ERPIN_program'  => 'RESULT-algorithm_name', # get/set \n        'ERPIN_version'  => 'RESULT-algorithm_version', # get/set \n        'ERPIN_query-def'=> 'RESULT-query_name', # get/set \n        'ERPIN_query-len'=> 'RESULT-query_length', \n        'ERPIN_query-acc'=> 'RESULT-query_accession', # get/set \n        'ERPIN_querydesc'=> 'RESULT-query_description', # get/set\n        'ERPIN_db'       => 'RESULT-database_name',  # get/set \n        'ERPIN_db-len'   => 'RESULT-database_entries', # none yet\n        'ERPIN_db-let'   => 'RESULT-database_letters', # none yet\n        \n        'Parameters_cutoff'      => { 'RESULT-parameters' => 'cutoff' },\n        'Parameters_expect'      => { 'RESULT-parameters' => 'expect' },\n        \n        'Parameters_include'     => { 'RESULT-parameters' => 'include' },\n        'Parameters_sc-match'    => { 'RESULT-parameters' => 'match' },\n        'Parameters_sc-mismatch' => { 'RESULT-parameters' => 'mismatch' },\n        'Parameters_gap-open'    => { 'RESULT-parameters' => 'gapopen' },\n        'Parameters_gap-extend'  => { 'RESULT-parameters' => 'gapext' },\n        'Parameters_filter'      => { 'RESULT-parameters' => 'filter' },\n        'Parameters_allowgaps'   => { 'RESULT-parameters' => 'allowgaps' },\n        'Parameters_full_dbpath' => { 'RESULT-parameters' => 'full_dbpath' },        \n        'Statistics_db-let'      => { 'RESULT-statistics' => 'dbletters' },\n\t     );\n\nmy $MINSCORE = 0;\nmy $DEFAULT_VERSION = '4.2.5';\nmy $DEFAULT_ALGORITHM = 'erpin';\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::infernal->new();\n Function: Builds a new Bio::SearchIO::infernal object \n Returns : Bio::SearchIO::infernal\n Args    : -fh/-file     => cmsearch (infernal) filename\n           -format       => 'erpin'\n           -algorithm    => algorithm (default 'Infernal')\n           -query_acc    => query accession, eg. Rfam accession (default undef)\n           -hsp_minscore => minimum HSP score cutoff\n           -version      => ERPIN version (not reported in output)\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n    my ($cutoff, $accession, $version) =\n       $self->_rearrange([qw(HSP_MINSCORE QUERY_ACC VERSION)],@args);\n    my $handler = $self->_eventHandler;\n    $handler->register_factory(\n        'result',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Result::GenericResult',\n            -interface => 'Bio::Search::Result::ResultI',\n            -verbose   => $self->verbose()\n        )\n    );\n\n    $handler->register_factory(\n        'hit',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Hit::ModelHit',\n            -interface => 'Bio::Search::Hit::HitI',\n            -verbose   => $self->verbose()\n        )\n    );\n\n    $handler->register_factory(\n        'hsp',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::HSP::ModelHSP',\n            -interface => 'Bio::Search::HSP::HSPI',\n            -verbose   => $self->verbose()\n        )\n    );\n    $accession && $self->query_accession($accession);\n    $cutoff ||= $MINSCORE;\n    $self->hsp_minscore($cutoff);\n    $version ||= $DEFAULT_VERSION;\n    $self->algorithm_version($version);\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    my $seentop = 0;\n    local $/ = \"\\n\";\n    local $_;\n    my $accession = $self->query_accession;\n    my $minscore = $self->hsp_minscore;\n    my $version = $self->algorithm_version;\n    my $verbose = $self->verbose;    # cache for speed?\n    $self->start_document();\n    my ($lasthit, $lastscore, $lastlen, $lasteval);\n    #my $hitline;\n    PARSER:\n    while ( defined( my $line = $self->_readline ) ) {\n        next if $line =~ m{^\\s*$};\n        if ($line =~ m{^Training\\sset:\\s+\"(.*)\"}xmso) {\n            if ($seentop) {\n                $self->_pushback($line);\n                last PARSER;\n            }\n            $self->start_element({'Name' => 'Result'});\n            $self->element_hash( {\n                'ERPIN_query-def'   => $1,\n                'ERPIN_program'     =>'erpin',\n                'ERPIN_version'     => $version,\n                'ERPIN_query-acc'   => $accession,\n                });\n            $seentop = 1;\n            # parse rest of header here\n            HEADER:\n            while (defined ($line = $self->_readline) ) {\n                next if $line =~ m{^\\s*$};\n                if (index($line, '>') == 0 ||\n                    index($line, '-------- at level 1 --------') == 0) {\n                    $self->_pushback($line);\n                    last HEADER;\n                }\n                if ($line =~ m{^\\s+(\\d+\\ssequences\\sof\\slength\\s\\d+)}xmso) {\n                    $self->element(\n                        {'Name' => 'ERPIN_querydesc',\n                         'Data' => $1}\n                       );\n                } elsif ($line =~ m{^Cutoff:\\s+(\\S+)}xmso) {\n                    $self->element(\n                        {'Name' => 'Parameters_cutoff',\n                         'Data' => $1}\n                                  );\n                } elsif ($line =~ m{^Database:\\s+\"(.*)\"}xmso) {\n                    $self->element(\n                        {'Name' => 'ERPIN_db',\n                         'Data' => $1}\n                       );\n                } elsif ($line =~ m{^\\s+(\\d+)\\snucleotides\\sto\\sbe\\sprocessed\\sin\\s(\\d+)\\ssequences}xmso) {\n                    $self->element_hash(\n                        {'ERPIN_db-len' => $2,\n                         'ERPIN_db-let' => $1}\n                       );\n                } elsif ($line =~ m{^E-value\\sat\\scutoff\\s\\S+\\sfor\\s\\S+\\sdouble\\sstrand\\sdata:\\s+(\\S+)}xmso) {\n                    $self->element(\n                                   {'Name' => 'Parameters_expect',\n                                    'Data' => $1}\n                                  );\n                } elsif ($line =~ m{^\\s+(ATGC\\sratios:\\s+(?:\\S+\\s+\\S+\\s+\\S+\\s+\\S+))}) {\n                    $self->element(\n                                   {'Name' => 'Statistics_db-let',\n                                    'Data' => $1}\n                                  );\n                }\n            }\n        } elsif ($line =~ m{^>(\\S+)\\s+(.*)}xmso ) {\n            my ($id, $desc) = ($1, $2);\n            chomp $desc;\n            # desc line is repeated for each strand, so must check\n            # prior to starting a new hit\n            if (!$lasthit || $id ne $lasthit) {\n                if ($self->within_element('hit') ) {\n                    $self->element_hash({\n                        'Hit_signif' => $lasteval,\n                        'Hit_score'  => $lastscore,\n                        'Hit_bits'   => $lastscore\n                        });\n                    $self->end_element({'Name' => 'Hit'});\n                }                \n                $self->start_element({'Name' => 'Hit'});\n                my ($gi, $acc, $ver) = $self->_get_seq_identifiers($id);\n            \n                $self->element_hash({\n                    'Hit_id'        => $id,\n                    'Hit_gi'        => $gi,\n                    'Hit_accession' => $ver ? \"$acc.$ver\" :\n                                        $acc ? $acc : $id,\n                    'Hit_def'       => $desc\n                    });\n            }\n            $lasthit = $id;\n        } elsif ( (index($line, 'FW') == 0) || (index($line, 'RC') == 0)) {\n            my ($str, $hn, $pos, $score, $eval) = split ' ', $line;\n            if ($minscore < $score) {\n                $self->start_element({'Name' => 'Hsp'});\n                \n                my ($start, $end) = split m{\\.\\.}, $pos, 2;\n                ($start, $end) = ($end, $start) if ($str eq 'RC');\n                $line = $self->_readline;\n                chomp $line;\n                $self->element_hash({\n                    'Hsp_stranded'     => 'HIT',\n                    'Hsp_hit-from'     => $start,\n                    'Hsp_hit-to'       => $end,\n                    'Hsp_score'        => $score,\n                    'Hsp_bit-score'    => $score,\n                    'Hsp_evalue'       => $eval,\n                    'Hsp_query-from'   => 1,\n                    'Hsp_query-to'     => length($line),\n                    'Hsp_align-len'    => length($line),\n                    'Hsp_hseq'         =>$line\n                    });\n                $self->end_element({'Name' => 'Hsp'});\n                $lastscore = $score if (!$lastscore || $lastscore < $score);\n                $lasteval = $eval if (!$lasteval || $lasteval > $eval);\n            }\n        } else {\n            #$self->debug(\"Dropped data: $line\");\n        }\n    }\n    if ($seentop) {\n        if ($self->within_element('hit')) {\n            $self->element_hash({\n                    'Hit_signif'    => $lasteval,\n                    'Hit_score'     => $lastscore,\n                    'Hit_bits'      => $lastscore\n                    });\n            $self->end_element({'Name' => 'Hit'}); \n        }\n        $self->end_element({'Name' => 'Result'});\n    }\n    return $self->end_document();\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\nsub start_element {\n    my ( $self, $data ) = @_;\n\n    # we currently don't care about attributes\n    my $nm   = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    if ($type) {\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = sprintf( \"start_%s\", lc $type );\n            $self->_eventHandler->$func( $data->{'Attributes'} );\n        }\n        unshift @{ $self->{'_elements'} }, $type;\n    }\n    if ( defined $type\n        && $type eq 'result' )\n    {\n        $self->{'_values'} = {};\n        $self->{'_result'} = undef;\n    }\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys, 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ( $self, $data ) = @_;\n    my $nm   = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    my $rc;\n\n    if ($type) {\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = sprintf( \"end_%s\", lc $type );\n            $rc = $self->_eventHandler->$func( $self->{'_reporttype'},\n                $self->{'_values'} );\n        }\n        my $lastelem = shift @{ $self->{'_elements'} };\n    }\n    elsif ( $MAPPING{$nm} ) {\n        if ( ref( $MAPPING{$nm} ) =~ /hash/i ) {\n            my $key = ( keys %{ $MAPPING{$nm} } )[0];\n            $self->{'_values'}->{$key}->{ $MAPPING{$nm}->{$key} } =\n              $self->{'_last_data'};\n        }\n        else {\n            $self->{'_values'}->{ $MAPPING{$nm} } = $self->{'_last_data'};\n        }\n    }\n    else {\n        $self->debug(\"unknown nm $nm, ignoring\\n\");\n    }\n    $self->{'_last_data'} = '';    # remove read data if we are at\n                                   # end of an element\n    $self->{'_result'} = $rc if ( defined $type && $type eq 'result' );\n    return $rc;\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convenience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element {\n    my ( $self, $data ) = @_;\n    # simple data calls (%MAPPING) do not need start_element\n    $self->characters($data);\n    $self->end_element($data);\n}\n\n=head2 element_hash\n\n Title   : element\n Usage   : $eventhandler->element_hash({'Hsp_hit-from' => $start,\n                                        'Hsp_hit-to'   => $end,\n                                        'Hsp_score'    => $lastscore});\n Function: Convenience method that takes multiple simple data elements and\n           maps to appropriate parameters\n Returns : none\n Args    : Hash ref with the mapped key (in %MAPPING) and value\n\n\nsub element_hash {\n    my ($self, $data) = @_;\n    $self->throw(\"Must provide data hash ref\") if !$data || !ref($data);\n    for my $nm (sort keys %{$data}) {\n        next if $data->{$nm} && $data->{$nm} =~ m{^\\s*$}o;\n        if ( $MAPPING{$nm} ) {\n            if ( ref( $MAPPING{$nm} ) =~ /hash/i ) {\n                my $key = ( keys %{ $MAPPING{$nm} } )[0];\n                $self->{'_values'}->{$key}->{ $MAPPING{$nm}->{$key} } =\n                  $data->{$nm};\n            }\n            else {\n                $self->{'_values'}->{ $MAPPING{$nm} } = $data->{$nm};\n            }\n        }\n    }\n}\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string"},"containerName":"main::","definition":"sub","line":479,"children":[{"kind":13,"line":480,"containerName":"characters","definition":"my","name":"$self","localvar":"my"},{"kind":13,"line":480,"name":"$data","containerName":"characters"},{"containerName":"characters","name":"$data","line":481,"kind":13},{"kind":13,"line":481,"name":"$data","containerName":"characters"},{"line":482,"kind":13,"name":"$self","containerName":"characters"},{"kind":13,"line":482,"name":"$data","containerName":"characters"}],"kind":12},{"detail":"($self,$name)","signature":{"parameters":[{"label":"$self"},{"label":"$name"}],"documentation":"1;\n# $Id: erpin.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::erpin\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields <cjfields-at-uiuc-dot-edu>\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::erpin - SearchIO-based ERPIN parser\n\n=head1 SYNOPSIS\n\n  # do not call this module directly. Use Bio::SearchIO.\n\n=head1 DESCRIPTION\n\nThis is an experimental SearchIO-based parser for output from\nthe erpin program.  It currently parses erpin output for ERPIN\nversions 4.2.5 and above; older versions may work but will not be supported.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Fields\n\nEmail cjfields-at-uiuc-dot-edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::erpin;\nuse strict;\n\nuse Data::Dumper;\nuse base qw(Bio::SearchIO);\n\nmy %MODEMAP = (\n\t    'Result'             => 'result',\n\t    'Hit'                => 'hit',\n\t    'Hsp'                => 'hsp'\n\t    );\n\nmy %MAPPING = ( \n        'Hsp_bit-score'   => 'HSP-bits',\n        'Hsp_score'       => 'HSP-score',\n        'Hsp_evalue'      => 'HSP-evalue', # no evalues yet\n        'Hsp_query-from'  => 'HSP-query_start',\n        'Hsp_query-to'    => 'HSP-query_end',\n        'Hsp_hit-from'    => 'HSP-hit_start', #\n        'Hsp_hit-to'      => 'HSP-hit_end', #\n        'Hsp_gaps'        => 'HSP-hsp_gaps', \n        'Hsp_hitgaps'     => 'HSP-hit_gaps',\n        'Hsp_querygaps'   => 'HSP-query_gaps',\n        'Hsp_qseq'        => 'HSP-query_seq',\n        'Hsp_hseq'        => 'HSP-hit_seq',\n        'Hsp_midline'     => 'HSP-homology_seq',\n        'Hsp_structure'   => 'HSP-meta',\n        'Hsp_align-len'   => 'HSP-hsp_length',\n        'Hsp_stranded'    => 'HSP-stranded',\n        \n        # not supported yet\n        'Hsp_positive'    => 'HSP-conserved',\n        'Hsp_identity'    => 'HSP-identical',\n\n        'Hit_id'        => 'HIT-name',\n        'Hit_len'       => 'HIT-length',\n        'Hit_gi'        => 'HIT-ncbi_gi',\n        'Hit_accession' => 'HIT-accession',\n        'Hit_def'       => 'HIT-description',\n        'Hit_signif'    => 'HIT-significance', # none yet\n        'Hit_score'     => 'HIT-score', # best HSP bit score\n        'Hit_bits'      => 'HIT-bits', # best HSP bit score\n \n        'ERPIN_program'  => 'RESULT-algorithm_name', # get/set \n        'ERPIN_version'  => 'RESULT-algorithm_version', # get/set \n        'ERPIN_query-def'=> 'RESULT-query_name', # get/set \n        'ERPIN_query-len'=> 'RESULT-query_length', \n        'ERPIN_query-acc'=> 'RESULT-query_accession', # get/set \n        'ERPIN_querydesc'=> 'RESULT-query_description', # get/set\n        'ERPIN_db'       => 'RESULT-database_name',  # get/set \n        'ERPIN_db-len'   => 'RESULT-database_entries', # none yet\n        'ERPIN_db-let'   => 'RESULT-database_letters', # none yet\n        \n        'Parameters_cutoff'      => { 'RESULT-parameters' => 'cutoff' },\n        'Parameters_expect'      => { 'RESULT-parameters' => 'expect' },\n        \n        'Parameters_include'     => { 'RESULT-parameters' => 'include' },\n        'Parameters_sc-match'    => { 'RESULT-parameters' => 'match' },\n        'Parameters_sc-mismatch' => { 'RESULT-parameters' => 'mismatch' },\n        'Parameters_gap-open'    => { 'RESULT-parameters' => 'gapopen' },\n        'Parameters_gap-extend'  => { 'RESULT-parameters' => 'gapext' },\n        'Parameters_filter'      => { 'RESULT-parameters' => 'filter' },\n        'Parameters_allowgaps'   => { 'RESULT-parameters' => 'allowgaps' },\n        'Parameters_full_dbpath' => { 'RESULT-parameters' => 'full_dbpath' },        \n        'Statistics_db-let'      => { 'RESULT-statistics' => 'dbletters' },\n\t     );\n\nmy $MINSCORE = 0;\nmy $DEFAULT_VERSION = '4.2.5';\nmy $DEFAULT_ALGORITHM = 'erpin';\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::infernal->new();\n Function: Builds a new Bio::SearchIO::infernal object \n Returns : Bio::SearchIO::infernal\n Args    : -fh/-file     => cmsearch (infernal) filename\n           -format       => 'erpin'\n           -algorithm    => algorithm (default 'Infernal')\n           -query_acc    => query accession, eg. Rfam accession (default undef)\n           -hsp_minscore => minimum HSP score cutoff\n           -version      => ERPIN version (not reported in output)\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n    my ($cutoff, $accession, $version) =\n       $self->_rearrange([qw(HSP_MINSCORE QUERY_ACC VERSION)],@args);\n    my $handler = $self->_eventHandler;\n    $handler->register_factory(\n        'result',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Result::GenericResult',\n            -interface => 'Bio::Search::Result::ResultI',\n            -verbose   => $self->verbose()\n        )\n    );\n\n    $handler->register_factory(\n        'hit',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Hit::ModelHit',\n            -interface => 'Bio::Search::Hit::HitI',\n            -verbose   => $self->verbose()\n        )\n    );\n\n    $handler->register_factory(\n        'hsp',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::HSP::ModelHSP',\n            -interface => 'Bio::Search::HSP::HSPI',\n            -verbose   => $self->verbose()\n        )\n    );\n    $accession && $self->query_accession($accession);\n    $cutoff ||= $MINSCORE;\n    $self->hsp_minscore($cutoff);\n    $version ||= $DEFAULT_VERSION;\n    $self->algorithm_version($version);\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    my $seentop = 0;\n    local $/ = \"\\n\";\n    local $_;\n    my $accession = $self->query_accession;\n    my $minscore = $self->hsp_minscore;\n    my $version = $self->algorithm_version;\n    my $verbose = $self->verbose;    # cache for speed?\n    $self->start_document();\n    my ($lasthit, $lastscore, $lastlen, $lasteval);\n    #my $hitline;\n    PARSER:\n    while ( defined( my $line = $self->_readline ) ) {\n        next if $line =~ m{^\\s*$};\n        if ($line =~ m{^Training\\sset:\\s+\"(.*)\"}xmso) {\n            if ($seentop) {\n                $self->_pushback($line);\n                last PARSER;\n            }\n            $self->start_element({'Name' => 'Result'});\n            $self->element_hash( {\n                'ERPIN_query-def'   => $1,\n                'ERPIN_program'     =>'erpin',\n                'ERPIN_version'     => $version,\n                'ERPIN_query-acc'   => $accession,\n                });\n            $seentop = 1;\n            # parse rest of header here\n            HEADER:\n            while (defined ($line = $self->_readline) ) {\n                next if $line =~ m{^\\s*$};\n                if (index($line, '>') == 0 ||\n                    index($line, '-------- at level 1 --------') == 0) {\n                    $self->_pushback($line);\n                    last HEADER;\n                }\n                if ($line =~ m{^\\s+(\\d+\\ssequences\\sof\\slength\\s\\d+)}xmso) {\n                    $self->element(\n                        {'Name' => 'ERPIN_querydesc',\n                         'Data' => $1}\n                       );\n                } elsif ($line =~ m{^Cutoff:\\s+(\\S+)}xmso) {\n                    $self->element(\n                        {'Name' => 'Parameters_cutoff',\n                         'Data' => $1}\n                                  );\n                } elsif ($line =~ m{^Database:\\s+\"(.*)\"}xmso) {\n                    $self->element(\n                        {'Name' => 'ERPIN_db',\n                         'Data' => $1}\n                       );\n                } elsif ($line =~ m{^\\s+(\\d+)\\snucleotides\\sto\\sbe\\sprocessed\\sin\\s(\\d+)\\ssequences}xmso) {\n                    $self->element_hash(\n                        {'ERPIN_db-len' => $2,\n                         'ERPIN_db-let' => $1}\n                       );\n                } elsif ($line =~ m{^E-value\\sat\\scutoff\\s\\S+\\sfor\\s\\S+\\sdouble\\sstrand\\sdata:\\s+(\\S+)}xmso) {\n                    $self->element(\n                                   {'Name' => 'Parameters_expect',\n                                    'Data' => $1}\n                                  );\n                } elsif ($line =~ m{^\\s+(ATGC\\sratios:\\s+(?:\\S+\\s+\\S+\\s+\\S+\\s+\\S+))}) {\n                    $self->element(\n                                   {'Name' => 'Statistics_db-let',\n                                    'Data' => $1}\n                                  );\n                }\n            }\n        } elsif ($line =~ m{^>(\\S+)\\s+(.*)}xmso ) {\n            my ($id, $desc) = ($1, $2);\n            chomp $desc;\n            # desc line is repeated for each strand, so must check\n            # prior to starting a new hit\n            if (!$lasthit || $id ne $lasthit) {\n                if ($self->within_element('hit') ) {\n                    $self->element_hash({\n                        'Hit_signif' => $lasteval,\n                        'Hit_score'  => $lastscore,\n                        'Hit_bits'   => $lastscore\n                        });\n                    $self->end_element({'Name' => 'Hit'});\n                }                \n                $self->start_element({'Name' => 'Hit'});\n                my ($gi, $acc, $ver) = $self->_get_seq_identifiers($id);\n            \n                $self->element_hash({\n                    'Hit_id'        => $id,\n                    'Hit_gi'        => $gi,\n                    'Hit_accession' => $ver ? \"$acc.$ver\" :\n                                        $acc ? $acc : $id,\n                    'Hit_def'       => $desc\n                    });\n            }\n            $lasthit = $id;\n        } elsif ( (index($line, 'FW') == 0) || (index($line, 'RC') == 0)) {\n            my ($str, $hn, $pos, $score, $eval) = split ' ', $line;\n            if ($minscore < $score) {\n                $self->start_element({'Name' => 'Hsp'});\n                \n                my ($start, $end) = split m{\\.\\.}, $pos, 2;\n                ($start, $end) = ($end, $start) if ($str eq 'RC');\n                $line = $self->_readline;\n                chomp $line;\n                $self->element_hash({\n                    'Hsp_stranded'     => 'HIT',\n                    'Hsp_hit-from'     => $start,\n                    'Hsp_hit-to'       => $end,\n                    'Hsp_score'        => $score,\n                    'Hsp_bit-score'    => $score,\n                    'Hsp_evalue'       => $eval,\n                    'Hsp_query-from'   => 1,\n                    'Hsp_query-to'     => length($line),\n                    'Hsp_align-len'    => length($line),\n                    'Hsp_hseq'         =>$line\n                    });\n                $self->end_element({'Name' => 'Hsp'});\n                $lastscore = $score if (!$lastscore || $lastscore < $score);\n                $lasteval = $eval if (!$lasteval || $lasteval > $eval);\n            }\n        } else {\n            #$self->debug(\"Dropped data: $line\");\n        }\n    }\n    if ($seentop) {\n        if ($self->within_element('hit')) {\n            $self->element_hash({\n                    'Hit_signif'    => $lasteval,\n                    'Hit_score'     => $lastscore,\n                    'Hit_bits'      => $lastscore\n                    });\n            $self->end_element({'Name' => 'Hit'}); \n        }\n        $self->end_element({'Name' => 'Result'});\n    }\n    return $self->end_document();\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\nsub start_element {\n    my ( $self, $data ) = @_;\n\n    # we currently don't care about attributes\n    my $nm   = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    if ($type) {\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = sprintf( \"start_%s\", lc $type );\n            $self->_eventHandler->$func( $data->{'Attributes'} );\n        }\n        unshift @{ $self->{'_elements'} }, $type;\n    }\n    if ( defined $type\n        && $type eq 'result' )\n    {\n        $self->{'_values'} = {};\n        $self->{'_result'} = undef;\n    }\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys, 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ( $self, $data ) = @_;\n    my $nm   = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    my $rc;\n\n    if ($type) {\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = sprintf( \"end_%s\", lc $type );\n            $rc = $self->_eventHandler->$func( $self->{'_reporttype'},\n                $self->{'_values'} );\n        }\n        my $lastelem = shift @{ $self->{'_elements'} };\n    }\n    elsif ( $MAPPING{$nm} ) {\n        if ( ref( $MAPPING{$nm} ) =~ /hash/i ) {\n            my $key = ( keys %{ $MAPPING{$nm} } )[0];\n            $self->{'_values'}->{$key}->{ $MAPPING{$nm}->{$key} } =\n              $self->{'_last_data'};\n        }\n        else {\n            $self->{'_values'}->{ $MAPPING{$nm} } = $self->{'_last_data'};\n        }\n    }\n    else {\n        $self->debug(\"unknown nm $nm, ignoring\\n\");\n    }\n    $self->{'_last_data'} = '';    # remove read data if we are at\n                                   # end of an element\n    $self->{'_result'} = $rc if ( defined $type && $type eq 'result' );\n    return $rc;\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convenience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element {\n    my ( $self, $data ) = @_;\n    # simple data calls (%MAPPING) do not need start_element\n    $self->characters($data);\n    $self->end_element($data);\n}\n\n=head2 element_hash\n\n Title   : element\n Usage   : $eventhandler->element_hash({'Hsp_hit-from' => $start,\n                                        'Hsp_hit-to'   => $end,\n                                        'Hsp_score'    => $lastscore});\n Function: Convenience method that takes multiple simple data elements and\n           maps to appropriate parameters\n Returns : none\n Args    : Hash ref with the mapped key (in %MAPPING) and value\n\n\nsub element_hash {\n    my ($self, $data) = @_;\n    $self->throw(\"Must provide data hash ref\") if !$data || !ref($data);\n    for my $nm (sort keys %{$data}) {\n        next if $data->{$nm} && $data->{$nm} =~ m{^\\s*$}o;\n        if ( $MAPPING{$nm} ) {\n            if ( ref( $MAPPING{$nm} ) =~ /hash/i ) {\n                my $key = ( keys %{ $MAPPING{$nm} } )[0];\n                $self->{'_values'}->{$key}->{ $MAPPING{$nm}->{$key} } =\n                  $data->{$nm};\n            }\n            else {\n                $self->{'_values'}->{ $MAPPING{$nm} } = $data->{$nm};\n            }\n        }\n    }\n}\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string\n\n\n\nsub characters {\n    my ( $self, $data ) = @_;\n    return unless ( defined $data->{'Data'} && $data->{'Data'} !~ /^\\s+$/o );\n    $self->{'_last_data'} = $data->{'Data'};\n}\n\n=head2 within_element\n\n Title   : within_element\n Usage   : if( $eventgenerator->within_element($element) ) {}\n Function: Test if we are within a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name ","label":"within_element($self,$name)"},"containerName":"main::","definition":"sub","line":497,"children":[{"kind":13,"line":498,"containerName":"within_element","definition":"my","name":"$self","localvar":"my"},{"containerName":"within_element","name":"$name","line":498,"kind":13},{"name":"$name","containerName":"within_element","kind":13,"line":501},{"line":501,"kind":13,"containerName":"within_element","name":"$self"},{"line":502,"kind":13,"name":"$self","containerName":"within_element"}],"kind":12,"range":{"end":{"character":9999,"line":502},"start":{"line":497,"character":0}},"name":"within_element"},{"name":"%self","containerName":null,"kind":13,"line":503},{"kind":13,"line":504,"name":"$name","containerName":null},{"range":{"start":{"character":0,"line":521},"end":{"line":525,"character":9999}},"name":"in_element","signature":{"label":"in_element($self,$name)","documentation":"1;\n# $Id: erpin.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::erpin\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields <cjfields-at-uiuc-dot-edu>\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::erpin - SearchIO-based ERPIN parser\n\n=head1 SYNOPSIS\n\n  # do not call this module directly. Use Bio::SearchIO.\n\n=head1 DESCRIPTION\n\nThis is an experimental SearchIO-based parser for output from\nthe erpin program.  It currently parses erpin output for ERPIN\nversions 4.2.5 and above; older versions may work but will not be supported.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Fields\n\nEmail cjfields-at-uiuc-dot-edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::erpin;\nuse strict;\n\nuse Data::Dumper;\nuse base qw(Bio::SearchIO);\n\nmy %MODEMAP = (\n\t    'Result'             => 'result',\n\t    'Hit'                => 'hit',\n\t    'Hsp'                => 'hsp'\n\t    );\n\nmy %MAPPING = ( \n        'Hsp_bit-score'   => 'HSP-bits',\n        'Hsp_score'       => 'HSP-score',\n        'Hsp_evalue'      => 'HSP-evalue', # no evalues yet\n        'Hsp_query-from'  => 'HSP-query_start',\n        'Hsp_query-to'    => 'HSP-query_end',\n        'Hsp_hit-from'    => 'HSP-hit_start', #\n        'Hsp_hit-to'      => 'HSP-hit_end', #\n        'Hsp_gaps'        => 'HSP-hsp_gaps', \n        'Hsp_hitgaps'     => 'HSP-hit_gaps',\n        'Hsp_querygaps'   => 'HSP-query_gaps',\n        'Hsp_qseq'        => 'HSP-query_seq',\n        'Hsp_hseq'        => 'HSP-hit_seq',\n        'Hsp_midline'     => 'HSP-homology_seq',\n        'Hsp_structure'   => 'HSP-meta',\n        'Hsp_align-len'   => 'HSP-hsp_length',\n        'Hsp_stranded'    => 'HSP-stranded',\n        \n        # not supported yet\n        'Hsp_positive'    => 'HSP-conserved',\n        'Hsp_identity'    => 'HSP-identical',\n\n        'Hit_id'        => 'HIT-name',\n        'Hit_len'       => 'HIT-length',\n        'Hit_gi'        => 'HIT-ncbi_gi',\n        'Hit_accession' => 'HIT-accession',\n        'Hit_def'       => 'HIT-description',\n        'Hit_signif'    => 'HIT-significance', # none yet\n        'Hit_score'     => 'HIT-score', # best HSP bit score\n        'Hit_bits'      => 'HIT-bits', # best HSP bit score\n \n        'ERPIN_program'  => 'RESULT-algorithm_name', # get/set \n        'ERPIN_version'  => 'RESULT-algorithm_version', # get/set \n        'ERPIN_query-def'=> 'RESULT-query_name', # get/set \n        'ERPIN_query-len'=> 'RESULT-query_length', \n        'ERPIN_query-acc'=> 'RESULT-query_accession', # get/set \n        'ERPIN_querydesc'=> 'RESULT-query_description', # get/set\n        'ERPIN_db'       => 'RESULT-database_name',  # get/set \n        'ERPIN_db-len'   => 'RESULT-database_entries', # none yet\n        'ERPIN_db-let'   => 'RESULT-database_letters', # none yet\n        \n        'Parameters_cutoff'      => { 'RESULT-parameters' => 'cutoff' },\n        'Parameters_expect'      => { 'RESULT-parameters' => 'expect' },\n        \n        'Parameters_include'     => { 'RESULT-parameters' => 'include' },\n        'Parameters_sc-match'    => { 'RESULT-parameters' => 'match' },\n        'Parameters_sc-mismatch' => { 'RESULT-parameters' => 'mismatch' },\n        'Parameters_gap-open'    => { 'RESULT-parameters' => 'gapopen' },\n        'Parameters_gap-extend'  => { 'RESULT-parameters' => 'gapext' },\n        'Parameters_filter'      => { 'RESULT-parameters' => 'filter' },\n        'Parameters_allowgaps'   => { 'RESULT-parameters' => 'allowgaps' },\n        'Parameters_full_dbpath' => { 'RESULT-parameters' => 'full_dbpath' },        \n        'Statistics_db-let'      => { 'RESULT-statistics' => 'dbletters' },\n\t     );\n\nmy $MINSCORE = 0;\nmy $DEFAULT_VERSION = '4.2.5';\nmy $DEFAULT_ALGORITHM = 'erpin';\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::infernal->new();\n Function: Builds a new Bio::SearchIO::infernal object \n Returns : Bio::SearchIO::infernal\n Args    : -fh/-file     => cmsearch (infernal) filename\n           -format       => 'erpin'\n           -algorithm    => algorithm (default 'Infernal')\n           -query_acc    => query accession, eg. Rfam accession (default undef)\n           -hsp_minscore => minimum HSP score cutoff\n           -version      => ERPIN version (not reported in output)\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n    my ($cutoff, $accession, $version) =\n       $self->_rearrange([qw(HSP_MINSCORE QUERY_ACC VERSION)],@args);\n    my $handler = $self->_eventHandler;\n    $handler->register_factory(\n        'result',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Result::GenericResult',\n            -interface => 'Bio::Search::Result::ResultI',\n            -verbose   => $self->verbose()\n        )\n    );\n\n    $handler->register_factory(\n        'hit',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Hit::ModelHit',\n            -interface => 'Bio::Search::Hit::HitI',\n            -verbose   => $self->verbose()\n        )\n    );\n\n    $handler->register_factory(\n        'hsp',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::HSP::ModelHSP',\n            -interface => 'Bio::Search::HSP::HSPI',\n            -verbose   => $self->verbose()\n        )\n    );\n    $accession && $self->query_accession($accession);\n    $cutoff ||= $MINSCORE;\n    $self->hsp_minscore($cutoff);\n    $version ||= $DEFAULT_VERSION;\n    $self->algorithm_version($version);\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    my $seentop = 0;\n    local $/ = \"\\n\";\n    local $_;\n    my $accession = $self->query_accession;\n    my $minscore = $self->hsp_minscore;\n    my $version = $self->algorithm_version;\n    my $verbose = $self->verbose;    # cache for speed?\n    $self->start_document();\n    my ($lasthit, $lastscore, $lastlen, $lasteval);\n    #my $hitline;\n    PARSER:\n    while ( defined( my $line = $self->_readline ) ) {\n        next if $line =~ m{^\\s*$};\n        if ($line =~ m{^Training\\sset:\\s+\"(.*)\"}xmso) {\n            if ($seentop) {\n                $self->_pushback($line);\n                last PARSER;\n            }\n            $self->start_element({'Name' => 'Result'});\n            $self->element_hash( {\n                'ERPIN_query-def'   => $1,\n                'ERPIN_program'     =>'erpin',\n                'ERPIN_version'     => $version,\n                'ERPIN_query-acc'   => $accession,\n                });\n            $seentop = 1;\n            # parse rest of header here\n            HEADER:\n            while (defined ($line = $self->_readline) ) {\n                next if $line =~ m{^\\s*$};\n                if (index($line, '>') == 0 ||\n                    index($line, '-------- at level 1 --------') == 0) {\n                    $self->_pushback($line);\n                    last HEADER;\n                }\n                if ($line =~ m{^\\s+(\\d+\\ssequences\\sof\\slength\\s\\d+)}xmso) {\n                    $self->element(\n                        {'Name' => 'ERPIN_querydesc',\n                         'Data' => $1}\n                       );\n                } elsif ($line =~ m{^Cutoff:\\s+(\\S+)}xmso) {\n                    $self->element(\n                        {'Name' => 'Parameters_cutoff',\n                         'Data' => $1}\n                                  );\n                } elsif ($line =~ m{^Database:\\s+\"(.*)\"}xmso) {\n                    $self->element(\n                        {'Name' => 'ERPIN_db',\n                         'Data' => $1}\n                       );\n                } elsif ($line =~ m{^\\s+(\\d+)\\snucleotides\\sto\\sbe\\sprocessed\\sin\\s(\\d+)\\ssequences}xmso) {\n                    $self->element_hash(\n                        {'ERPIN_db-len' => $2,\n                         'ERPIN_db-let' => $1}\n                       );\n                } elsif ($line =~ m{^E-value\\sat\\scutoff\\s\\S+\\sfor\\s\\S+\\sdouble\\sstrand\\sdata:\\s+(\\S+)}xmso) {\n                    $self->element(\n                                   {'Name' => 'Parameters_expect',\n                                    'Data' => $1}\n                                  );\n                } elsif ($line =~ m{^\\s+(ATGC\\sratios:\\s+(?:\\S+\\s+\\S+\\s+\\S+\\s+\\S+))}) {\n                    $self->element(\n                                   {'Name' => 'Statistics_db-let',\n                                    'Data' => $1}\n                                  );\n                }\n            }\n        } elsif ($line =~ m{^>(\\S+)\\s+(.*)}xmso ) {\n            my ($id, $desc) = ($1, $2);\n            chomp $desc;\n            # desc line is repeated for each strand, so must check\n            # prior to starting a new hit\n            if (!$lasthit || $id ne $lasthit) {\n                if ($self->within_element('hit') ) {\n                    $self->element_hash({\n                        'Hit_signif' => $lasteval,\n                        'Hit_score'  => $lastscore,\n                        'Hit_bits'   => $lastscore\n                        });\n                    $self->end_element({'Name' => 'Hit'});\n                }                \n                $self->start_element({'Name' => 'Hit'});\n                my ($gi, $acc, $ver) = $self->_get_seq_identifiers($id);\n            \n                $self->element_hash({\n                    'Hit_id'        => $id,\n                    'Hit_gi'        => $gi,\n                    'Hit_accession' => $ver ? \"$acc.$ver\" :\n                                        $acc ? $acc : $id,\n                    'Hit_def'       => $desc\n                    });\n            }\n            $lasthit = $id;\n        } elsif ( (index($line, 'FW') == 0) || (index($line, 'RC') == 0)) {\n            my ($str, $hn, $pos, $score, $eval) = split ' ', $line;\n            if ($minscore < $score) {\n                $self->start_element({'Name' => 'Hsp'});\n                \n                my ($start, $end) = split m{\\.\\.}, $pos, 2;\n                ($start, $end) = ($end, $start) if ($str eq 'RC');\n                $line = $self->_readline;\n                chomp $line;\n                $self->element_hash({\n                    'Hsp_stranded'     => 'HIT',\n                    'Hsp_hit-from'     => $start,\n                    'Hsp_hit-to'       => $end,\n                    'Hsp_score'        => $score,\n                    'Hsp_bit-score'    => $score,\n                    'Hsp_evalue'       => $eval,\n                    'Hsp_query-from'   => 1,\n                    'Hsp_query-to'     => length($line),\n                    'Hsp_align-len'    => length($line),\n                    'Hsp_hseq'         =>$line\n                    });\n                $self->end_element({'Name' => 'Hsp'});\n                $lastscore = $score if (!$lastscore || $lastscore < $score);\n                $lasteval = $eval if (!$lasteval || $lasteval > $eval);\n            }\n        } else {\n            #$self->debug(\"Dropped data: $line\");\n        }\n    }\n    if ($seentop) {\n        if ($self->within_element('hit')) {\n            $self->element_hash({\n                    'Hit_signif'    => $lasteval,\n                    'Hit_score'     => $lastscore,\n                    'Hit_bits'      => $lastscore\n                    });\n            $self->end_element({'Name' => 'Hit'}); \n        }\n        $self->end_element({'Name' => 'Result'});\n    }\n    return $self->end_document();\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\nsub start_element {\n    my ( $self, $data ) = @_;\n\n    # we currently don't care about attributes\n    my $nm   = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    if ($type) {\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = sprintf( \"start_%s\", lc $type );\n            $self->_eventHandler->$func( $data->{'Attributes'} );\n        }\n        unshift @{ $self->{'_elements'} }, $type;\n    }\n    if ( defined $type\n        && $type eq 'result' )\n    {\n        $self->{'_values'} = {};\n        $self->{'_result'} = undef;\n    }\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys, 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ( $self, $data ) = @_;\n    my $nm   = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    my $rc;\n\n    if ($type) {\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = sprintf( \"end_%s\", lc $type );\n            $rc = $self->_eventHandler->$func( $self->{'_reporttype'},\n                $self->{'_values'} );\n        }\n        my $lastelem = shift @{ $self->{'_elements'} };\n    }\n    elsif ( $MAPPING{$nm} ) {\n        if ( ref( $MAPPING{$nm} ) =~ /hash/i ) {\n            my $key = ( keys %{ $MAPPING{$nm} } )[0];\n            $self->{'_values'}->{$key}->{ $MAPPING{$nm}->{$key} } =\n              $self->{'_last_data'};\n        }\n        else {\n            $self->{'_values'}->{ $MAPPING{$nm} } = $self->{'_last_data'};\n        }\n    }\n    else {\n        $self->debug(\"unknown nm $nm, ignoring\\n\");\n    }\n    $self->{'_last_data'} = '';    # remove read data if we are at\n                                   # end of an element\n    $self->{'_result'} = $rc if ( defined $type && $type eq 'result' );\n    return $rc;\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convenience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element {\n    my ( $self, $data ) = @_;\n    # simple data calls (%MAPPING) do not need start_element\n    $self->characters($data);\n    $self->end_element($data);\n}\n\n=head2 element_hash\n\n Title   : element\n Usage   : $eventhandler->element_hash({'Hsp_hit-from' => $start,\n                                        'Hsp_hit-to'   => $end,\n                                        'Hsp_score'    => $lastscore});\n Function: Convenience method that takes multiple simple data elements and\n           maps to appropriate parameters\n Returns : none\n Args    : Hash ref with the mapped key (in %MAPPING) and value\n\n\nsub element_hash {\n    my ($self, $data) = @_;\n    $self->throw(\"Must provide data hash ref\") if !$data || !ref($data);\n    for my $nm (sort keys %{$data}) {\n        next if $data->{$nm} && $data->{$nm} =~ m{^\\s*$}o;\n        if ( $MAPPING{$nm} ) {\n            if ( ref( $MAPPING{$nm} ) =~ /hash/i ) {\n                my $key = ( keys %{ $MAPPING{$nm} } )[0];\n                $self->{'_values'}->{$key}->{ $MAPPING{$nm}->{$key} } =\n                  $data->{$nm};\n            }\n            else {\n                $self->{'_values'}->{ $MAPPING{$nm} } = $data->{$nm};\n            }\n        }\n    }\n}\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string\n\n\n\nsub characters {\n    my ( $self, $data ) = @_;\n    return unless ( defined $data->{'Data'} && $data->{'Data'} !~ /^\\s+$/o );\n    $self->{'_last_data'} = $data->{'Data'};\n}\n\n=head2 within_element\n\n Title   : within_element\n Usage   : if( $eventgenerator->within_element($element) ) {}\n Function: Test if we are within a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name \n\n\nsub within_element {\n    my ( $self, $name ) = @_;\n    return 0\n      if ( !defined $name\n        || !defined $self->{'_elements'}\n        || scalar @{ $self->{'_elements'} } == 0 );\n    foreach ( @{ $self->{'_elements'} } ) {\n        return 1 if ( $_ eq $name );\n    }\n    return 0;\n}\n\n=head2 in_element\n\n Title   : in_element\n Usage   : if( $eventgenerator->in_element($element) ) {}\n Function: Test if we are in a particular element\n           This is different than 'within' because 'in' only \n           tests its immediate parent.\n Returns : boolean\n Args    : string element name ","parameters":[{"label":"$self"},{"label":"$name"}]},"detail":"($self,$name)","definition":"sub","containerName":"main::","children":[{"localvar":"my","containerName":"in_element","name":"$self","definition":"my","line":522,"kind":13},{"kind":13,"line":522,"containerName":"in_element","name":"$name"},{"containerName":"in_element","name":"$self","line":523,"kind":13},{"kind":13,"line":524,"containerName":"in_element","name":"$self"},{"containerName":"in_element","name":"$name","line":524,"kind":13}],"line":521,"kind":12},{"signature":{"documentation":"1;\n# $Id: erpin.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::erpin\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields <cjfields-at-uiuc-dot-edu>\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::erpin - SearchIO-based ERPIN parser\n\n=head1 SYNOPSIS\n\n  # do not call this module directly. Use Bio::SearchIO.\n\n=head1 DESCRIPTION\n\nThis is an experimental SearchIO-based parser for output from\nthe erpin program.  It currently parses erpin output for ERPIN\nversions 4.2.5 and above; older versions may work but will not be supported.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Fields\n\nEmail cjfields-at-uiuc-dot-edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::erpin;\nuse strict;\n\nuse Data::Dumper;\nuse base qw(Bio::SearchIO);\n\nmy %MODEMAP = (\n\t    'Result'             => 'result',\n\t    'Hit'                => 'hit',\n\t    'Hsp'                => 'hsp'\n\t    );\n\nmy %MAPPING = ( \n        'Hsp_bit-score'   => 'HSP-bits',\n        'Hsp_score'       => 'HSP-score',\n        'Hsp_evalue'      => 'HSP-evalue', # no evalues yet\n        'Hsp_query-from'  => 'HSP-query_start',\n        'Hsp_query-to'    => 'HSP-query_end',\n        'Hsp_hit-from'    => 'HSP-hit_start', #\n        'Hsp_hit-to'      => 'HSP-hit_end', #\n        'Hsp_gaps'        => 'HSP-hsp_gaps', \n        'Hsp_hitgaps'     => 'HSP-hit_gaps',\n        'Hsp_querygaps'   => 'HSP-query_gaps',\n        'Hsp_qseq'        => 'HSP-query_seq',\n        'Hsp_hseq'        => 'HSP-hit_seq',\n        'Hsp_midline'     => 'HSP-homology_seq',\n        'Hsp_structure'   => 'HSP-meta',\n        'Hsp_align-len'   => 'HSP-hsp_length',\n        'Hsp_stranded'    => 'HSP-stranded',\n        \n        # not supported yet\n        'Hsp_positive'    => 'HSP-conserved',\n        'Hsp_identity'    => 'HSP-identical',\n\n        'Hit_id'        => 'HIT-name',\n        'Hit_len'       => 'HIT-length',\n        'Hit_gi'        => 'HIT-ncbi_gi',\n        'Hit_accession' => 'HIT-accession',\n        'Hit_def'       => 'HIT-description',\n        'Hit_signif'    => 'HIT-significance', # none yet\n        'Hit_score'     => 'HIT-score', # best HSP bit score\n        'Hit_bits'      => 'HIT-bits', # best HSP bit score\n \n        'ERPIN_program'  => 'RESULT-algorithm_name', # get/set \n        'ERPIN_version'  => 'RESULT-algorithm_version', # get/set \n        'ERPIN_query-def'=> 'RESULT-query_name', # get/set \n        'ERPIN_query-len'=> 'RESULT-query_length', \n        'ERPIN_query-acc'=> 'RESULT-query_accession', # get/set \n        'ERPIN_querydesc'=> 'RESULT-query_description', # get/set\n        'ERPIN_db'       => 'RESULT-database_name',  # get/set \n        'ERPIN_db-len'   => 'RESULT-database_entries', # none yet\n        'ERPIN_db-let'   => 'RESULT-database_letters', # none yet\n        \n        'Parameters_cutoff'      => { 'RESULT-parameters' => 'cutoff' },\n        'Parameters_expect'      => { 'RESULT-parameters' => 'expect' },\n        \n        'Parameters_include'     => { 'RESULT-parameters' => 'include' },\n        'Parameters_sc-match'    => { 'RESULT-parameters' => 'match' },\n        'Parameters_sc-mismatch' => { 'RESULT-parameters' => 'mismatch' },\n        'Parameters_gap-open'    => { 'RESULT-parameters' => 'gapopen' },\n        'Parameters_gap-extend'  => { 'RESULT-parameters' => 'gapext' },\n        'Parameters_filter'      => { 'RESULT-parameters' => 'filter' },\n        'Parameters_allowgaps'   => { 'RESULT-parameters' => 'allowgaps' },\n        'Parameters_full_dbpath' => { 'RESULT-parameters' => 'full_dbpath' },        \n        'Statistics_db-let'      => { 'RESULT-statistics' => 'dbletters' },\n\t     );\n\nmy $MINSCORE = 0;\nmy $DEFAULT_VERSION = '4.2.5';\nmy $DEFAULT_ALGORITHM = 'erpin';\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::infernal->new();\n Function: Builds a new Bio::SearchIO::infernal object \n Returns : Bio::SearchIO::infernal\n Args    : -fh/-file     => cmsearch (infernal) filename\n           -format       => 'erpin'\n           -algorithm    => algorithm (default 'Infernal')\n           -query_acc    => query accession, eg. Rfam accession (default undef)\n           -hsp_minscore => minimum HSP score cutoff\n           -version      => ERPIN version (not reported in output)\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n    my ($cutoff, $accession, $version) =\n       $self->_rearrange([qw(HSP_MINSCORE QUERY_ACC VERSION)],@args);\n    my $handler = $self->_eventHandler;\n    $handler->register_factory(\n        'result',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Result::GenericResult',\n            -interface => 'Bio::Search::Result::ResultI',\n            -verbose   => $self->verbose()\n        )\n    );\n\n    $handler->register_factory(\n        'hit',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Hit::ModelHit',\n            -interface => 'Bio::Search::Hit::HitI',\n            -verbose   => $self->verbose()\n        )\n    );\n\n    $handler->register_factory(\n        'hsp',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::HSP::ModelHSP',\n            -interface => 'Bio::Search::HSP::HSPI',\n            -verbose   => $self->verbose()\n        )\n    );\n    $accession && $self->query_accession($accession);\n    $cutoff ||= $MINSCORE;\n    $self->hsp_minscore($cutoff);\n    $version ||= $DEFAULT_VERSION;\n    $self->algorithm_version($version);\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    my $seentop = 0;\n    local $/ = \"\\n\";\n    local $_;\n    my $accession = $self->query_accession;\n    my $minscore = $self->hsp_minscore;\n    my $version = $self->algorithm_version;\n    my $verbose = $self->verbose;    # cache for speed?\n    $self->start_document();\n    my ($lasthit, $lastscore, $lastlen, $lasteval);\n    #my $hitline;\n    PARSER:\n    while ( defined( my $line = $self->_readline ) ) {\n        next if $line =~ m{^\\s*$};\n        if ($line =~ m{^Training\\sset:\\s+\"(.*)\"}xmso) {\n            if ($seentop) {\n                $self->_pushback($line);\n                last PARSER;\n            }\n            $self->start_element({'Name' => 'Result'});\n            $self->element_hash( {\n                'ERPIN_query-def'   => $1,\n                'ERPIN_program'     =>'erpin',\n                'ERPIN_version'     => $version,\n                'ERPIN_query-acc'   => $accession,\n                });\n            $seentop = 1;\n            # parse rest of header here\n            HEADER:\n            while (defined ($line = $self->_readline) ) {\n                next if $line =~ m{^\\s*$};\n                if (index($line, '>') == 0 ||\n                    index($line, '-------- at level 1 --------') == 0) {\n                    $self->_pushback($line);\n                    last HEADER;\n                }\n                if ($line =~ m{^\\s+(\\d+\\ssequences\\sof\\slength\\s\\d+)}xmso) {\n                    $self->element(\n                        {'Name' => 'ERPIN_querydesc',\n                         'Data' => $1}\n                       );\n                } elsif ($line =~ m{^Cutoff:\\s+(\\S+)}xmso) {\n                    $self->element(\n                        {'Name' => 'Parameters_cutoff',\n                         'Data' => $1}\n                                  );\n                } elsif ($line =~ m{^Database:\\s+\"(.*)\"}xmso) {\n                    $self->element(\n                        {'Name' => 'ERPIN_db',\n                         'Data' => $1}\n                       );\n                } elsif ($line =~ m{^\\s+(\\d+)\\snucleotides\\sto\\sbe\\sprocessed\\sin\\s(\\d+)\\ssequences}xmso) {\n                    $self->element_hash(\n                        {'ERPIN_db-len' => $2,\n                         'ERPIN_db-let' => $1}\n                       );\n                } elsif ($line =~ m{^E-value\\sat\\scutoff\\s\\S+\\sfor\\s\\S+\\sdouble\\sstrand\\sdata:\\s+(\\S+)}xmso) {\n                    $self->element(\n                                   {'Name' => 'Parameters_expect',\n                                    'Data' => $1}\n                                  );\n                } elsif ($line =~ m{^\\s+(ATGC\\sratios:\\s+(?:\\S+\\s+\\S+\\s+\\S+\\s+\\S+))}) {\n                    $self->element(\n                                   {'Name' => 'Statistics_db-let',\n                                    'Data' => $1}\n                                  );\n                }\n            }\n        } elsif ($line =~ m{^>(\\S+)\\s+(.*)}xmso ) {\n            my ($id, $desc) = ($1, $2);\n            chomp $desc;\n            # desc line is repeated for each strand, so must check\n            # prior to starting a new hit\n            if (!$lasthit || $id ne $lasthit) {\n                if ($self->within_element('hit') ) {\n                    $self->element_hash({\n                        'Hit_signif' => $lasteval,\n                        'Hit_score'  => $lastscore,\n                        'Hit_bits'   => $lastscore\n                        });\n                    $self->end_element({'Name' => 'Hit'});\n                }                \n                $self->start_element({'Name' => 'Hit'});\n                my ($gi, $acc, $ver) = $self->_get_seq_identifiers($id);\n            \n                $self->element_hash({\n                    'Hit_id'        => $id,\n                    'Hit_gi'        => $gi,\n                    'Hit_accession' => $ver ? \"$acc.$ver\" :\n                                        $acc ? $acc : $id,\n                    'Hit_def'       => $desc\n                    });\n            }\n            $lasthit = $id;\n        } elsif ( (index($line, 'FW') == 0) || (index($line, 'RC') == 0)) {\n            my ($str, $hn, $pos, $score, $eval) = split ' ', $line;\n            if ($minscore < $score) {\n                $self->start_element({'Name' => 'Hsp'});\n                \n                my ($start, $end) = split m{\\.\\.}, $pos, 2;\n                ($start, $end) = ($end, $start) if ($str eq 'RC');\n                $line = $self->_readline;\n                chomp $line;\n                $self->element_hash({\n                    'Hsp_stranded'     => 'HIT',\n                    'Hsp_hit-from'     => $start,\n                    'Hsp_hit-to'       => $end,\n                    'Hsp_score'        => $score,\n                    'Hsp_bit-score'    => $score,\n                    'Hsp_evalue'       => $eval,\n                    'Hsp_query-from'   => 1,\n                    'Hsp_query-to'     => length($line),\n                    'Hsp_align-len'    => length($line),\n                    'Hsp_hseq'         =>$line\n                    });\n                $self->end_element({'Name' => 'Hsp'});\n                $lastscore = $score if (!$lastscore || $lastscore < $score);\n                $lasteval = $eval if (!$lasteval || $lasteval > $eval);\n            }\n        } else {\n            #$self->debug(\"Dropped data: $line\");\n        }\n    }\n    if ($seentop) {\n        if ($self->within_element('hit')) {\n            $self->element_hash({\n                    'Hit_signif'    => $lasteval,\n                    'Hit_score'     => $lastscore,\n                    'Hit_bits'      => $lastscore\n                    });\n            $self->end_element({'Name' => 'Hit'}); \n        }\n        $self->end_element({'Name' => 'Result'});\n    }\n    return $self->end_document();\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\nsub start_element {\n    my ( $self, $data ) = @_;\n\n    # we currently don't care about attributes\n    my $nm   = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    if ($type) {\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = sprintf( \"start_%s\", lc $type );\n            $self->_eventHandler->$func( $data->{'Attributes'} );\n        }\n        unshift @{ $self->{'_elements'} }, $type;\n    }\n    if ( defined $type\n        && $type eq 'result' )\n    {\n        $self->{'_values'} = {};\n        $self->{'_result'} = undef;\n    }\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys, 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ( $self, $data ) = @_;\n    my $nm   = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    my $rc;\n\n    if ($type) {\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = sprintf( \"end_%s\", lc $type );\n            $rc = $self->_eventHandler->$func( $self->{'_reporttype'},\n                $self->{'_values'} );\n        }\n        my $lastelem = shift @{ $self->{'_elements'} };\n    }\n    elsif ( $MAPPING{$nm} ) {\n        if ( ref( $MAPPING{$nm} ) =~ /hash/i ) {\n            my $key = ( keys %{ $MAPPING{$nm} } )[0];\n            $self->{'_values'}->{$key}->{ $MAPPING{$nm}->{$key} } =\n              $self->{'_last_data'};\n        }\n        else {\n            $self->{'_values'}->{ $MAPPING{$nm} } = $self->{'_last_data'};\n        }\n    }\n    else {\n        $self->debug(\"unknown nm $nm, ignoring\\n\");\n    }\n    $self->{'_last_data'} = '';    # remove read data if we are at\n                                   # end of an element\n    $self->{'_result'} = $rc if ( defined $type && $type eq 'result' );\n    return $rc;\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convenience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element {\n    my ( $self, $data ) = @_;\n    # simple data calls (%MAPPING) do not need start_element\n    $self->characters($data);\n    $self->end_element($data);\n}\n\n=head2 element_hash\n\n Title   : element\n Usage   : $eventhandler->element_hash({'Hsp_hit-from' => $start,\n                                        'Hsp_hit-to'   => $end,\n                                        'Hsp_score'    => $lastscore});\n Function: Convenience method that takes multiple simple data elements and\n           maps to appropriate parameters\n Returns : none\n Args    : Hash ref with the mapped key (in %MAPPING) and value\n\n\nsub element_hash {\n    my ($self, $data) = @_;\n    $self->throw(\"Must provide data hash ref\") if !$data || !ref($data);\n    for my $nm (sort keys %{$data}) {\n        next if $data->{$nm} && $data->{$nm} =~ m{^\\s*$}o;\n        if ( $MAPPING{$nm} ) {\n            if ( ref( $MAPPING{$nm} ) =~ /hash/i ) {\n                my $key = ( keys %{ $MAPPING{$nm} } )[0];\n                $self->{'_values'}->{$key}->{ $MAPPING{$nm}->{$key} } =\n                  $data->{$nm};\n            }\n            else {\n                $self->{'_values'}->{ $MAPPING{$nm} } = $data->{$nm};\n            }\n        }\n    }\n}\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string\n\n\n\nsub characters {\n    my ( $self, $data ) = @_;\n    return unless ( defined $data->{'Data'} && $data->{'Data'} !~ /^\\s+$/o );\n    $self->{'_last_data'} = $data->{'Data'};\n}\n\n=head2 within_element\n\n Title   : within_element\n Usage   : if( $eventgenerator->within_element($element) ) {}\n Function: Test if we are within a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name \n\n\nsub within_element {\n    my ( $self, $name ) = @_;\n    return 0\n      if ( !defined $name\n        || !defined $self->{'_elements'}\n        || scalar @{ $self->{'_elements'} } == 0 );\n    foreach ( @{ $self->{'_elements'} } ) {\n        return 1 if ( $_ eq $name );\n    }\n    return 0;\n}\n\n=head2 in_element\n\n Title   : in_element\n Usage   : if( $eventgenerator->in_element($element) ) {}\n Function: Test if we are in a particular element\n           This is different than 'within' because 'in' only \n           tests its immediate parent.\n Returns : boolean\n Args    : string element name \n\n\nsub in_element {\n    my ( $self, $name ) = @_;\n    return 0 if !defined $self->{'_elements'}->[0];\n    return ( $self->{'_elements'}->[0] eq $name );\n}\n\n=head2 start_document\n\n Title   : start_document\n Usage   : $eventgenerator->start_document\n Function: Handle a start document event\n Returns : none\n Args    : none","parameters":[{"label":"$self"}],"label":"start_document($self)"},"detail":"($self)","definition":"sub","containerName":"main::","children":[{"localvar":"my","containerName":"start_document","name":"$self","definition":"my","line":538,"kind":13},{"line":539,"kind":13,"containerName":"start_document","name":"$self"},{"name":"$self","containerName":"start_document","kind":13,"line":540},{"containerName":"start_document","name":"$self","kind":13,"line":541},{"line":542,"kind":13,"containerName":"start_document","name":"$self"}],"line":537,"kind":12,"range":{"end":{"line":543,"character":9999},"start":{"character":0,"line":537}},"name":"start_document"},{"name":"end_document","range":{"end":{"character":9999,"line":558},"start":{"character":0,"line":555}},"kind":12,"children":[{"kind":13,"line":556,"containerName":"end_document","name":"$self","definition":"my","localvar":"my"},{"name":"$self","containerName":"end_document","line":557,"kind":13}],"line":555,"definition":"sub","containerName":"main::","signature":{"documentation":"1;\n# $Id: erpin.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::erpin\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields <cjfields-at-uiuc-dot-edu>\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::erpin - SearchIO-based ERPIN parser\n\n=head1 SYNOPSIS\n\n  # do not call this module directly. Use Bio::SearchIO.\n\n=head1 DESCRIPTION\n\nThis is an experimental SearchIO-based parser for output from\nthe erpin program.  It currently parses erpin output for ERPIN\nversions 4.2.5 and above; older versions may work but will not be supported.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Fields\n\nEmail cjfields-at-uiuc-dot-edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::erpin;\nuse strict;\n\nuse Data::Dumper;\nuse base qw(Bio::SearchIO);\n\nmy %MODEMAP = (\n\t    'Result'             => 'result',\n\t    'Hit'                => 'hit',\n\t    'Hsp'                => 'hsp'\n\t    );\n\nmy %MAPPING = ( \n        'Hsp_bit-score'   => 'HSP-bits',\n        'Hsp_score'       => 'HSP-score',\n        'Hsp_evalue'      => 'HSP-evalue', # no evalues yet\n        'Hsp_query-from'  => 'HSP-query_start',\n        'Hsp_query-to'    => 'HSP-query_end',\n        'Hsp_hit-from'    => 'HSP-hit_start', #\n        'Hsp_hit-to'      => 'HSP-hit_end', #\n        'Hsp_gaps'        => 'HSP-hsp_gaps', \n        'Hsp_hitgaps'     => 'HSP-hit_gaps',\n        'Hsp_querygaps'   => 'HSP-query_gaps',\n        'Hsp_qseq'        => 'HSP-query_seq',\n        'Hsp_hseq'        => 'HSP-hit_seq',\n        'Hsp_midline'     => 'HSP-homology_seq',\n        'Hsp_structure'   => 'HSP-meta',\n        'Hsp_align-len'   => 'HSP-hsp_length',\n        'Hsp_stranded'    => 'HSP-stranded',\n        \n        # not supported yet\n        'Hsp_positive'    => 'HSP-conserved',\n        'Hsp_identity'    => 'HSP-identical',\n\n        'Hit_id'        => 'HIT-name',\n        'Hit_len'       => 'HIT-length',\n        'Hit_gi'        => 'HIT-ncbi_gi',\n        'Hit_accession' => 'HIT-accession',\n        'Hit_def'       => 'HIT-description',\n        'Hit_signif'    => 'HIT-significance', # none yet\n        'Hit_score'     => 'HIT-score', # best HSP bit score\n        'Hit_bits'      => 'HIT-bits', # best HSP bit score\n \n        'ERPIN_program'  => 'RESULT-algorithm_name', # get/set \n        'ERPIN_version'  => 'RESULT-algorithm_version', # get/set \n        'ERPIN_query-def'=> 'RESULT-query_name', # get/set \n        'ERPIN_query-len'=> 'RESULT-query_length', \n        'ERPIN_query-acc'=> 'RESULT-query_accession', # get/set \n        'ERPIN_querydesc'=> 'RESULT-query_description', # get/set\n        'ERPIN_db'       => 'RESULT-database_name',  # get/set \n        'ERPIN_db-len'   => 'RESULT-database_entries', # none yet\n        'ERPIN_db-let'   => 'RESULT-database_letters', # none yet\n        \n        'Parameters_cutoff'      => { 'RESULT-parameters' => 'cutoff' },\n        'Parameters_expect'      => { 'RESULT-parameters' => 'expect' },\n        \n        'Parameters_include'     => { 'RESULT-parameters' => 'include' },\n        'Parameters_sc-match'    => { 'RESULT-parameters' => 'match' },\n        'Parameters_sc-mismatch' => { 'RESULT-parameters' => 'mismatch' },\n        'Parameters_gap-open'    => { 'RESULT-parameters' => 'gapopen' },\n        'Parameters_gap-extend'  => { 'RESULT-parameters' => 'gapext' },\n        'Parameters_filter'      => { 'RESULT-parameters' => 'filter' },\n        'Parameters_allowgaps'   => { 'RESULT-parameters' => 'allowgaps' },\n        'Parameters_full_dbpath' => { 'RESULT-parameters' => 'full_dbpath' },        \n        'Statistics_db-let'      => { 'RESULT-statistics' => 'dbletters' },\n\t     );\n\nmy $MINSCORE = 0;\nmy $DEFAULT_VERSION = '4.2.5';\nmy $DEFAULT_ALGORITHM = 'erpin';\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::infernal->new();\n Function: Builds a new Bio::SearchIO::infernal object \n Returns : Bio::SearchIO::infernal\n Args    : -fh/-file     => cmsearch (infernal) filename\n           -format       => 'erpin'\n           -algorithm    => algorithm (default 'Infernal')\n           -query_acc    => query accession, eg. Rfam accession (default undef)\n           -hsp_minscore => minimum HSP score cutoff\n           -version      => ERPIN version (not reported in output)\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n    my ($cutoff, $accession, $version) =\n       $self->_rearrange([qw(HSP_MINSCORE QUERY_ACC VERSION)],@args);\n    my $handler = $self->_eventHandler;\n    $handler->register_factory(\n        'result',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Result::GenericResult',\n            -interface => 'Bio::Search::Result::ResultI',\n            -verbose   => $self->verbose()\n        )\n    );\n\n    $handler->register_factory(\n        'hit',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Hit::ModelHit',\n            -interface => 'Bio::Search::Hit::HitI',\n            -verbose   => $self->verbose()\n        )\n    );\n\n    $handler->register_factory(\n        'hsp',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::HSP::ModelHSP',\n            -interface => 'Bio::Search::HSP::HSPI',\n            -verbose   => $self->verbose()\n        )\n    );\n    $accession && $self->query_accession($accession);\n    $cutoff ||= $MINSCORE;\n    $self->hsp_minscore($cutoff);\n    $version ||= $DEFAULT_VERSION;\n    $self->algorithm_version($version);\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    my $seentop = 0;\n    local $/ = \"\\n\";\n    local $_;\n    my $accession = $self->query_accession;\n    my $minscore = $self->hsp_minscore;\n    my $version = $self->algorithm_version;\n    my $verbose = $self->verbose;    # cache for speed?\n    $self->start_document();\n    my ($lasthit, $lastscore, $lastlen, $lasteval);\n    #my $hitline;\n    PARSER:\n    while ( defined( my $line = $self->_readline ) ) {\n        next if $line =~ m{^\\s*$};\n        if ($line =~ m{^Training\\sset:\\s+\"(.*)\"}xmso) {\n            if ($seentop) {\n                $self->_pushback($line);\n                last PARSER;\n            }\n            $self->start_element({'Name' => 'Result'});\n            $self->element_hash( {\n                'ERPIN_query-def'   => $1,\n                'ERPIN_program'     =>'erpin',\n                'ERPIN_version'     => $version,\n                'ERPIN_query-acc'   => $accession,\n                });\n            $seentop = 1;\n            # parse rest of header here\n            HEADER:\n            while (defined ($line = $self->_readline) ) {\n                next if $line =~ m{^\\s*$};\n                if (index($line, '>') == 0 ||\n                    index($line, '-------- at level 1 --------') == 0) {\n                    $self->_pushback($line);\n                    last HEADER;\n                }\n                if ($line =~ m{^\\s+(\\d+\\ssequences\\sof\\slength\\s\\d+)}xmso) {\n                    $self->element(\n                        {'Name' => 'ERPIN_querydesc',\n                         'Data' => $1}\n                       );\n                } elsif ($line =~ m{^Cutoff:\\s+(\\S+)}xmso) {\n                    $self->element(\n                        {'Name' => 'Parameters_cutoff',\n                         'Data' => $1}\n                                  );\n                } elsif ($line =~ m{^Database:\\s+\"(.*)\"}xmso) {\n                    $self->element(\n                        {'Name' => 'ERPIN_db',\n                         'Data' => $1}\n                       );\n                } elsif ($line =~ m{^\\s+(\\d+)\\snucleotides\\sto\\sbe\\sprocessed\\sin\\s(\\d+)\\ssequences}xmso) {\n                    $self->element_hash(\n                        {'ERPIN_db-len' => $2,\n                         'ERPIN_db-let' => $1}\n                       );\n                } elsif ($line =~ m{^E-value\\sat\\scutoff\\s\\S+\\sfor\\s\\S+\\sdouble\\sstrand\\sdata:\\s+(\\S+)}xmso) {\n                    $self->element(\n                                   {'Name' => 'Parameters_expect',\n                                    'Data' => $1}\n                                  );\n                } elsif ($line =~ m{^\\s+(ATGC\\sratios:\\s+(?:\\S+\\s+\\S+\\s+\\S+\\s+\\S+))}) {\n                    $self->element(\n                                   {'Name' => 'Statistics_db-let',\n                                    'Data' => $1}\n                                  );\n                }\n            }\n        } elsif ($line =~ m{^>(\\S+)\\s+(.*)}xmso ) {\n            my ($id, $desc) = ($1, $2);\n            chomp $desc;\n            # desc line is repeated for each strand, so must check\n            # prior to starting a new hit\n            if (!$lasthit || $id ne $lasthit) {\n                if ($self->within_element('hit') ) {\n                    $self->element_hash({\n                        'Hit_signif' => $lasteval,\n                        'Hit_score'  => $lastscore,\n                        'Hit_bits'   => $lastscore\n                        });\n                    $self->end_element({'Name' => 'Hit'});\n                }                \n                $self->start_element({'Name' => 'Hit'});\n                my ($gi, $acc, $ver) = $self->_get_seq_identifiers($id);\n            \n                $self->element_hash({\n                    'Hit_id'        => $id,\n                    'Hit_gi'        => $gi,\n                    'Hit_accession' => $ver ? \"$acc.$ver\" :\n                                        $acc ? $acc : $id,\n                    'Hit_def'       => $desc\n                    });\n            }\n            $lasthit = $id;\n        } elsif ( (index($line, 'FW') == 0) || (index($line, 'RC') == 0)) {\n            my ($str, $hn, $pos, $score, $eval) = split ' ', $line;\n            if ($minscore < $score) {\n                $self->start_element({'Name' => 'Hsp'});\n                \n                my ($start, $end) = split m{\\.\\.}, $pos, 2;\n                ($start, $end) = ($end, $start) if ($str eq 'RC');\n                $line = $self->_readline;\n                chomp $line;\n                $self->element_hash({\n                    'Hsp_stranded'     => 'HIT',\n                    'Hsp_hit-from'     => $start,\n                    'Hsp_hit-to'       => $end,\n                    'Hsp_score'        => $score,\n                    'Hsp_bit-score'    => $score,\n                    'Hsp_evalue'       => $eval,\n                    'Hsp_query-from'   => 1,\n                    'Hsp_query-to'     => length($line),\n                    'Hsp_align-len'    => length($line),\n                    'Hsp_hseq'         =>$line\n                    });\n                $self->end_element({'Name' => 'Hsp'});\n                $lastscore = $score if (!$lastscore || $lastscore < $score);\n                $lasteval = $eval if (!$lasteval || $lasteval > $eval);\n            }\n        } else {\n            #$self->debug(\"Dropped data: $line\");\n        }\n    }\n    if ($seentop) {\n        if ($self->within_element('hit')) {\n            $self->element_hash({\n                    'Hit_signif'    => $lasteval,\n                    'Hit_score'     => $lastscore,\n                    'Hit_bits'      => $lastscore\n                    });\n            $self->end_element({'Name' => 'Hit'}); \n        }\n        $self->end_element({'Name' => 'Result'});\n    }\n    return $self->end_document();\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\nsub start_element {\n    my ( $self, $data ) = @_;\n\n    # we currently don't care about attributes\n    my $nm   = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    if ($type) {\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = sprintf( \"start_%s\", lc $type );\n            $self->_eventHandler->$func( $data->{'Attributes'} );\n        }\n        unshift @{ $self->{'_elements'} }, $type;\n    }\n    if ( defined $type\n        && $type eq 'result' )\n    {\n        $self->{'_values'} = {};\n        $self->{'_result'} = undef;\n    }\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys, 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ( $self, $data ) = @_;\n    my $nm   = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    my $rc;\n\n    if ($type) {\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = sprintf( \"end_%s\", lc $type );\n            $rc = $self->_eventHandler->$func( $self->{'_reporttype'},\n                $self->{'_values'} );\n        }\n        my $lastelem = shift @{ $self->{'_elements'} };\n    }\n    elsif ( $MAPPING{$nm} ) {\n        if ( ref( $MAPPING{$nm} ) =~ /hash/i ) {\n            my $key = ( keys %{ $MAPPING{$nm} } )[0];\n            $self->{'_values'}->{$key}->{ $MAPPING{$nm}->{$key} } =\n              $self->{'_last_data'};\n        }\n        else {\n            $self->{'_values'}->{ $MAPPING{$nm} } = $self->{'_last_data'};\n        }\n    }\n    else {\n        $self->debug(\"unknown nm $nm, ignoring\\n\");\n    }\n    $self->{'_last_data'} = '';    # remove read data if we are at\n                                   # end of an element\n    $self->{'_result'} = $rc if ( defined $type && $type eq 'result' );\n    return $rc;\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convenience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element {\n    my ( $self, $data ) = @_;\n    # simple data calls (%MAPPING) do not need start_element\n    $self->characters($data);\n    $self->end_element($data);\n}\n\n=head2 element_hash\n\n Title   : element\n Usage   : $eventhandler->element_hash({'Hsp_hit-from' => $start,\n                                        'Hsp_hit-to'   => $end,\n                                        'Hsp_score'    => $lastscore});\n Function: Convenience method that takes multiple simple data elements and\n           maps to appropriate parameters\n Returns : none\n Args    : Hash ref with the mapped key (in %MAPPING) and value\n\n\nsub element_hash {\n    my ($self, $data) = @_;\n    $self->throw(\"Must provide data hash ref\") if !$data || !ref($data);\n    for my $nm (sort keys %{$data}) {\n        next if $data->{$nm} && $data->{$nm} =~ m{^\\s*$}o;\n        if ( $MAPPING{$nm} ) {\n            if ( ref( $MAPPING{$nm} ) =~ /hash/i ) {\n                my $key = ( keys %{ $MAPPING{$nm} } )[0];\n                $self->{'_values'}->{$key}->{ $MAPPING{$nm}->{$key} } =\n                  $data->{$nm};\n            }\n            else {\n                $self->{'_values'}->{ $MAPPING{$nm} } = $data->{$nm};\n            }\n        }\n    }\n}\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string\n\n\n\nsub characters {\n    my ( $self, $data ) = @_;\n    return unless ( defined $data->{'Data'} && $data->{'Data'} !~ /^\\s+$/o );\n    $self->{'_last_data'} = $data->{'Data'};\n}\n\n=head2 within_element\n\n Title   : within_element\n Usage   : if( $eventgenerator->within_element($element) ) {}\n Function: Test if we are within a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name \n\n\nsub within_element {\n    my ( $self, $name ) = @_;\n    return 0\n      if ( !defined $name\n        || !defined $self->{'_elements'}\n        || scalar @{ $self->{'_elements'} } == 0 );\n    foreach ( @{ $self->{'_elements'} } ) {\n        return 1 if ( $_ eq $name );\n    }\n    return 0;\n}\n\n=head2 in_element\n\n Title   : in_element\n Usage   : if( $eventgenerator->in_element($element) ) {}\n Function: Test if we are in a particular element\n           This is different than 'within' because 'in' only \n           tests its immediate parent.\n Returns : boolean\n Args    : string element name \n\n\nsub in_element {\n    my ( $self, $name ) = @_;\n    return 0 if !defined $self->{'_elements'}->[0];\n    return ( $self->{'_elements'}->[0] eq $name );\n}\n\n=head2 start_document\n\n Title   : start_document\n Usage   : $eventgenerator->start_document\n Function: Handle a start document event\n Returns : none\n Args    : none\n\n\nsub start_document {\n    my ($self) = @_;\n    $self->{'_lasttype'} = '';\n    $self->{'_values'}   = {};\n    $self->{'_result'}   = undef;\n    $self->{'_elements'} = [];\n}\n\n=head2 end_document\n\n Title   : end_document\n Usage   : $eventgenerator->end_document\n Function: Handles an end document event\n Returns : Bio::Search::Result::ResultI object\n Args    : none","parameters":[{"label":"$self"}],"label":"end_document($self)"},"detail":"($self)"},{"kind":12,"line":570,"children":[{"line":571,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"result_count"},{"name":"$self","containerName":"result_count","kind":13,"line":572}],"containerName":"main::","name":"result_count","definition":"sub","range":{"end":{"character":9999,"line":573},"start":{"character":0,"line":570}}},{"children":[{"name":"$self","definition":"my","containerName":"query_accession","localvar":"my","kind":13,"line":587},{"name":"$self","containerName":"query_accession","kind":13,"line":588},{"containerName":"query_accession","name":"$self","kind":13,"line":589}],"line":586,"kind":12,"range":{"start":{"character":0,"line":586},"end":{"character":9999,"line":590}},"definition":"sub","name":"query_accession","containerName":"main::"},{"range":{"start":{"line":602,"character":0},"end":{"character":9999,"line":606}},"containerName":"main::","definition":"sub","name":"hsp_minscore","line":602,"children":[{"line":603,"kind":13,"localvar":"my","containerName":"hsp_minscore","definition":"my","name":"$self"},{"containerName":"hsp_minscore","name":"$self","kind":13,"line":604},{"containerName":"hsp_minscore","name":"$self","kind":13,"line":605}],"kind":12},{"containerName":"main::","name":"algorithm_version","definition":"sub","range":{"end":{"line":622,"character":9999},"start":{"line":618,"character":0}},"kind":12,"line":618,"children":[{"kind":13,"line":619,"containerName":"algorithm_version","definition":"my","name":"$self","localvar":"my"},{"name":"$self","containerName":"algorithm_version","line":620,"kind":13},{"line":621,"kind":13,"containerName":"algorithm_version","name":"$self"}]}],"version":5}