{"vars":[{"line":121,"kind":2,"name":"base","containerName":""},{"containerName":"main::","name":"$DEBUG","definition":"our","line":128,"kind":13},{"containerName":null,"name":"%VALID_TYPE","definition":"my","localvar":"my","kind":13,"line":130},{"containerName":"Bio::Root::Root::XML::SAX::IO::File::Bio::SearchIO::XML::BlastHandler::Bio::SearchIO","name":"IteratedSearchResultEventBuilder","kind":2,"line":130},{"detail":"($self,@args)","signature":{"label":"_initialize($self,@args)","documentation":"1;\n# $Id: blastxml.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::blastxml\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::blastxml - A SearchIO implementation of NCBI Blast XML parsing. \n\n=head1 SYNOPSIS\n\n    use Bio::SearchIO;\n    my $searchin = Bio::SearchIO->new(-format => 'blastxml',\n\t\t\t\t     -file   => 't/data/plague_yeast.bls.xml');\n    while( my $result = $searchin->next_result ) {\n    }\n\n    # one can also request that the parser NOT keep the XML data in memory\n    # by using the tempfile initialization flag.\n    my $searchin = Bio::SearchIO->new(-tempfile => 1,\n\t\t\t\t     -format => 'blastxml',\n\t\t\t\t     -file   => 't/data/plague_yeast.bls.xml');\n    while( my $result = $searchin->next_result ) {\n    }\n\n=head1 DESCRIPTION\n\nThis object implements a NCBI Blast XML parser.  It requires XML::SAX; it is\nalso recommended (for faster parsing) that XML::SAX::ExpatXS or XML::LibXML\nbe installed.  Either 'XML::SAX::ExpatXS' or 'XML::LibXML::SAX::Parser' should\nbe set as the default parser in ParserDetails.ini.  This file is located in the\nSAX subdirectory of XML in your local perl library (normally in the 'site'\ndirectory).\n\nCurrently, XML::SAX::Expat will not work and will not be supported.\n\nThere is one additional initialization flag from the SearchIO defaults-\nthat is the -tempfile flag.  If specified as true, then the parser\nwill write out each report to a temporary filehandle rather than\nholding the entire report as a string in memory.  The reason this is\ndone in the first place is NCBI reports have an uncessary E<lt>?xml\nversion=\"1.0\"?E<gt> at the beginning of each report and RPS-BLAST reports\nhave an additional unecessary RPS-BLAST tag at the top of each report.\nSo we currently have implemented the work around by preparsing the\nfile (yes it makes the process slower, but it works).\n\n=head1 DEPENDENCIES\n\nIn addition to parts of the Bio:: hierarchy, this module uses:\n\n XML::SAX\n\nIt is also recommended that XML::SAX::ExpatXS be installed and made the default\nXML::SAX parser using , along with the Expat library () for faster parsing.\nXML::SAX::Expat is not recommended; XML::SAX::ExpatXS is considered the current\nreplacement for XML::SAX:Expat and is actively being considered to replace\nXML::SAX::Expat. XML::SAX::Expat will work, but only if you have local copies of\nthe NCBI BLAST DTDs. This is due to issues with NCBI's BLAST XML format. The\nDTDs and the web address to obtain them are:\n\n  NCBI_BlastOutput.dtd\t    \n  NCBI_BlastOutput.mod.dtd\n\n  http://www.ncbi.nlm.nih.gov/data_specs/dtd/\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::blastxml;\nuse strict;\n# Object preamble - inherits from Bio::Root::Root\n\nuse base qw(Bio::SearchIO);\nuse Bio::Root::Root;\nuse XML::SAX;\nuse IO::File;\nuse Bio::SearchIO::XML::BlastHandler;\nuse Bio::SearchIO::IteratedSearchResultEventBuilder;\n\nour $DEBUG;\n\nmy %VALID_TYPE = (\n    'BLAST'      => 'Bio::SearchIO::XML::BlastHandler',\n    'PSIBLAST'   => 'Bio::SearchIO::XML::PsiBlastHandler',\n    'PSI-BLAST'  => 'Bio::SearchIO::XML::PsiBlastHandler'\n    );\n\n# mapping of NCBI Blast terms to Bioperl hash keys\n\n=head2 new\n\n Title   : new\n Usage   : my $searchio = Bio::SearchIO->new(-format => 'blastxml',\n\t\t\t\t\t    -file   => 'filename',\n\t\t\t\t\t    -tempfile => 1);\n Function: Initializes the object - this is chained through new in SearchIO\n Returns : Bio::SearchIO::blastxml object\n Args    : One additional argument from the format and file/fh parameters.\n           -tempfile    => boolean.  Defaults to false.  Write out XML data\n                           to a temporary filehandle to send to PerlSAX parser.\n\n\n=head2 _initialize\n\n Title   : _initialize\n Usage   : private\n Function: Initializes the object - this is chained through new in SearchIO","parameters":[{"label":"$self"},{"label":"@args"}]},"containerName":"main::","definition":"sub","line":160,"children":[{"localvar":"my","containerName":"_initialize","name":"$self","definition":"my","line":161,"kind":13},{"kind":13,"line":161,"name":"@args","containerName":"_initialize"},{"name":"$self","containerName":"_initialize","line":162,"kind":13},{"name":"@args","containerName":"_initialize","kind":13,"line":162},{"localvar":"my","name":"$usetempfile","definition":"my","containerName":"_initialize","line":163,"kind":13},{"containerName":"_initialize","name":"$blasttype","kind":13,"line":163},{"kind":13,"line":163,"containerName":"_initialize","name":"$xmlcompact"},{"kind":13,"line":163,"name":"$self","containerName":"_initialize"},{"kind":12,"line":163,"containerName":"_initialize","name":"_rearrange"},{"line":167,"kind":13,"name":"@args","containerName":"_initialize"},{"containerName":"_initialize","name":"$blasttype","kind":13,"line":168},{"name":"$self","containerName":"_initialize","kind":13,"line":169},{"line":169,"kind":13,"containerName":"_initialize","name":"$xmlcompact"},{"kind":13,"line":170,"containerName":"_initialize","name":"$self"},{"name":"blasttype","containerName":"_initialize","kind":12,"line":170},{"line":170,"kind":13,"containerName":"_initialize","name":"$blasttype"},{"containerName":"_initialize","name":"$usetempfile","line":171,"kind":13},{"line":171,"kind":13,"name":"$self","containerName":"_initialize"},{"kind":12,"line":171,"containerName":"_initialize","name":"use_tempfile"},{"containerName":"_initialize","name":"$usetempfile","line":171,"kind":13},{"kind":13,"line":172,"name":"$self","containerName":"_initialize"},{"kind":13,"line":174,"containerName":"_initialize","name":"$DEBUG"},{"kind":13,"line":175,"name":"$DEBUG","containerName":"_initialize"},{"kind":13,"line":175,"containerName":"_initialize","name":"$DEBUG"},{"kind":13,"line":175,"name":"$self","containerName":"_initialize"},{"name":"verbose","containerName":"_initialize","kind":12,"line":175}],"kind":12,"range":{"end":{"line":176,"character":9999},"start":{"character":0,"line":160}},"name":"_initialize"},{"kind":12,"line":162,"name":"SUPER","containerName":"_initialize"},{"kind":12,"line":169,"name":"_xml_compact"},{"name":"_result_count","kind":12,"line":172},{"line":174,"kind":12,"name":"Time","containerName":"HiRes"},{"name":"next_result","range":{"start":{"line":188,"character":0},"end":{"line":255,"character":9999}},"containerName":"main::","definition":"sub","detail":"($self)","signature":{"parameters":[{"label":"$self"}],"documentation":"","label":"next_result($self)"},"kind":12,"line":188,"children":[{"kind":13,"line":189,"name":"$self","definition":"my","containerName":"next_result","localvar":"my"},{"localvar":"my","name":"$result","definition":"my","containerName":"next_result","line":191,"kind":13},{"containerName":"next_result","definition":"my","name":"$tfh","localvar":"my","kind":13,"line":193},{"containerName":"next_result","name":"$self","kind":13,"line":198},{"name":"$self","containerName":"next_result","kind":13,"line":199},{"name":"debug","containerName":"next_result","line":199,"kind":12},{"line":200,"kind":13,"localvar":"my","definition":"my","name":"$tfh2","containerName":"next_result"},{"line":200,"kind":13,"name":"$filename","containerName":"next_result"},{"line":200,"kind":12,"name":"new_tmpfile","containerName":"next_result"},{"kind":13,"line":200,"name":"$self","containerName":"next_result"},{"kind":12,"line":200,"containerName":"next_result","name":"throw"},{"name":"$tfh2","containerName":"next_result","line":201,"kind":13},{"containerName":"next_result","name":"autoflush","line":201,"kind":12},{"definition":"my","name":"$fh","containerName":"next_result","localvar":"my","kind":13,"line":202},{"name":"$self","containerName":"next_result","kind":13,"line":202},{"kind":12,"line":202,"containerName":"next_result","name":"_fh"},{"localvar":"my","containerName":"next_result","name":"$line","definition":"my","line":203,"kind":13},{"name":"$fh","containerName":"next_result","line":203,"kind":13},{"containerName":"next_result","name":"$line","line":204,"kind":13},{"name":"$tfh2","containerName":"next_result","line":205,"kind":13},{"containerName":"next_result","name":"$line","kind":13,"line":205},{"kind":13,"line":207,"name":"$tfh2","containerName":"next_result"},{"name":"$fh","containerName":"next_result","kind":13,"line":208},{"kind":13,"line":210,"name":"$self","containerName":"next_result"},{"line":210,"kind":12,"containerName":"next_result","name":"_fh"},{"name":"$tfh2","containerName":"next_result","kind":13,"line":210},{"name":"$self","containerName":"next_result","kind":13,"line":213},{"line":213,"kind":12,"containerName":"next_result","name":"use_tempfile"},{"containerName":"next_result","name":"$tfh","line":214,"kind":13},{"containerName":"next_result","name":"new_tmpfile","kind":12,"line":214},{"name":"$self","containerName":"next_result","line":214,"kind":13},{"kind":12,"line":214,"containerName":"next_result","name":"throw"},{"kind":13,"line":215,"name":"$tfh","containerName":"next_result"},{"kind":12,"line":215,"name":"autoflush","containerName":"next_result"},{"definition":"my","name":"$okaytoprocess","containerName":"next_result","localvar":"my","kind":13,"line":218},{"kind":13,"line":218,"name":"$self","containerName":"next_result"},{"containerName":"next_result","name":"blasttype","kind":12,"line":218},{"kind":13,"line":218,"name":"$self","containerName":"next_result"},{"containerName":"next_result","name":"_chunk_psiblast","kind":12,"line":218},{"containerName":"next_result","name":"$tfh","line":218,"kind":13},{"line":219,"kind":13,"containerName":"next_result","name":"$self"},{"kind":12,"line":219,"name":"_chunk_normalblast","containerName":"next_result"},{"kind":13,"line":219,"name":"$tfh","containerName":"next_result"},{"kind":13,"line":221,"containerName":"next_result","name":"$okaytoprocess"},{"localvar":"my","containerName":"next_result","definition":"my","name":"%parser_args","line":223,"kind":13},{"name":"$tfh","containerName":"next_result","kind":13,"line":224},{"containerName":"next_result","name":"$tfh","line":225,"kind":13},{"line":226,"kind":13,"name":"%parser_args","containerName":"next_result"},{"name":"$tfh","containerName":"next_result","kind":13,"line":226},{"name":"%parser_args","containerName":"next_result","line":228,"kind":13},{"containerName":"next_result","name":"$self","line":228,"kind":13},{"localvar":"my","definition":"my","name":"$starttime","containerName":"next_result","line":231,"kind":13},{"name":"$DEBUG","containerName":"next_result","kind":13,"line":232},{"kind":13,"line":232,"name":"$starttime","containerName":"next_result"},{"line":235,"kind":13,"name":"$result","containerName":"next_result"},{"containerName":"next_result","name":"$self","kind":13,"line":235},{"kind":12,"line":235,"containerName":"next_result","name":"parse"},{"kind":13,"line":235,"containerName":"next_result","name":"%parser_args"},{"kind":13,"line":239,"containerName":"next_result","name":"$self"},{"containerName":"next_result","name":"warn","line":239,"kind":12},{"line":240,"kind":13,"containerName":"next_result","name":"$result"},{"name":"$DEBUG","containerName":"next_result","line":242,"kind":13},{"containerName":"next_result","name":"$self","kind":13,"line":243},{"containerName":"next_result","name":"debug","kind":12,"line":243},{"containerName":"next_result","name":"$starttime","kind":13,"line":243},{"line":247,"kind":13,"name":"$result","containerName":"next_result"},{"containerName":"next_result","name":"$self","kind":13,"line":250},{"line":251,"kind":13,"containerName":"next_result","name":"$result"}]},{"line":198,"kind":12,"name":"_xml_compact"},{"line":200,"kind":12,"containerName":"File","name":"IO"},{"name":"IO","containerName":"File","line":214,"kind":12},{"line":232,"kind":12,"containerName":"HiRes::gettimeofday","name":"Time"},{"name":"Time","containerName":"HiRes::tv_interval","line":243,"kind":12},{"line":250,"kind":12,"name":"_result_count"},{"range":{"end":{"line":273,"character":9999},"start":{"line":270,"character":0}},"containerName":"main::","name":"result_count","definition":"sub","line":270,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"result_count","line":271,"kind":13},{"name":"$self","containerName":"result_count","line":272,"kind":13}],"kind":12},{"name":"_result_count","line":272,"kind":12},{"name":"use_tempfile","range":{"start":{"line":286,"character":0},"end":{"character":9999,"line":292}},"containerName":"main::","definition":"sub","detail":"($self,$value)","signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"","label":"use_tempfile($self,$value)"},"kind":12,"line":286,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"use_tempfile","line":287,"kind":13},{"line":287,"kind":13,"containerName":"use_tempfile","name":"$value"},{"name":"$value","containerName":"use_tempfile","line":288,"kind":13},{"name":"$self","containerName":"use_tempfile","kind":13,"line":289},{"containerName":"use_tempfile","name":"$value","kind":13,"line":289},{"name":"$self","containerName":"use_tempfile","line":291,"kind":13}]},{"children":[{"containerName":"blasttype","name":"$self","definition":"my","localvar":"my","kind":13,"line":308},{"containerName":"blasttype","name":"$value","line":308,"kind":13},{"kind":13,"line":309,"name":"$value","containerName":"blasttype"},{"line":310,"kind":13,"name":"$self","containerName":"blasttype"},{"containerName":"blasttype","name":"throw","line":310,"kind":12},{"line":310,"kind":13,"name":"$VALID_TYPE","containerName":"blasttype"},{"containerName":"blasttype","name":"$value","line":310,"kind":13},{"definition":"my","name":"$ok","containerName":"blasttype","localvar":"my","kind":13,"line":311},{"kind":13,"line":313,"name":"$ok","containerName":"blasttype"},{"line":313,"kind":13,"containerName":"blasttype","name":"$self"},{"name":"_load_module","containerName":"blasttype","line":313,"kind":12},{"name":"$VALID_TYPE","containerName":"blasttype","line":313,"kind":13},{"containerName":"blasttype","name":"$value","kind":13,"line":313},{"line":321,"kind":13,"containerName":"blasttype","name":"$ok"},{"definition":"my","name":"$xmlhandler","containerName":"blasttype","localvar":"my","kind":13,"line":324},{"name":"$VALID_TYPE","containerName":"blasttype","kind":13,"line":324},{"kind":13,"line":324,"name":"$value","containerName":"blasttype"},{"name":"new","containerName":"blasttype","line":324,"kind":12},{"kind":13,"line":324,"containerName":"blasttype","name":"$self"},{"containerName":"blasttype","name":"verbose","kind":12,"line":324},{"kind":13,"line":327,"containerName":"blasttype","name":"$value"},{"line":328,"kind":13,"localvar":"my","definition":"my","name":"$handler","containerName":"blasttype"},{"kind":12,"line":328,"name":"new","containerName":"blasttype"},{"line":329,"kind":13,"containerName":"blasttype","name":"$self"},{"line":329,"kind":13,"name":"$handler","containerName":"blasttype"},{"line":331,"kind":13,"name":"$xmlhandler","containerName":"blasttype"},{"kind":12,"line":331,"containerName":"blasttype","name":"eventHandler"},{"line":331,"kind":13,"name":"$self","containerName":"blasttype"},{"line":331,"kind":12,"name":"_eventHandler","containerName":"blasttype"},{"containerName":"blasttype","definition":"my","name":"$parserfactory","localvar":"my","kind":13,"line":334},{"name":"parser","containerName":"blasttype","line":334,"kind":12},{"kind":13,"line":335,"name":"$xmlhandler","containerName":"blasttype"},{"name":"$self","containerName":"blasttype","kind":13,"line":336},{"kind":13,"line":336,"name":"$parserfactory","containerName":"blasttype"},{"kind":13,"line":337,"name":"$self","containerName":"blasttype"},{"containerName":"blasttype","name":"saxparser","line":337,"kind":12},{"containerName":"blasttype","name":"$parserfactory","kind":13,"line":337},{"name":"$self","containerName":"blasttype","line":339,"kind":13},{"line":339,"kind":13,"name":"$value","containerName":"blasttype"},{"containerName":"blasttype","name":"$self","line":341,"kind":13}],"line":307,"kind":12,"signature":{"documentation":"","parameters":[{"label":"$self"},{"label":"$value"}],"label":"blasttype($self,$value)"},"detail":"($self,$value)","definition":"sub","containerName":"main::","range":{"start":{"line":307,"character":0},"end":{"line":342,"character":9999}},"name":"blasttype"},{"line":328,"kind":12,"containerName":"SearchIO::IteratedSearchResultEventBuilder","name":"Bio"},{"name":"XML","containerName":"SAX::ParserFactory","line":334,"kind":12},{"kind":12,"line":335,"name":"Handler"},{"range":{"end":{"character":9999,"line":347},"start":{"line":344,"character":0}},"name":"saxparser","definition":"sub","containerName":"main::","children":[{"line":345,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"saxparser"},{"kind":13,"line":346,"name":"$self","containerName":"saxparser"}],"line":344,"kind":12},{"name":"_chunk_normalblast","range":{"end":{"character":9999,"line":404},"start":{"line":349,"character":0}},"containerName":"main::","definition":"sub","detail":"($self,$tfh)","signature":{"label":"_chunk_normalblast($self,$tfh)","documentation":"","parameters":[{"label":"$self"},{"label":"$tfh"}]},"kind":12,"line":349,"children":[{"localvar":"my","containerName":"_chunk_normalblast","name":"$self","definition":"my","line":350,"kind":13},{"line":350,"kind":13,"containerName":"_chunk_normalblast","name":"$tfh"},{"containerName":"_chunk_normalblast","name":"$self","line":354,"kind":13},{"line":356,"kind":13,"localvar":"my","definition":"my","name":"$sawxmlheader","containerName":"_chunk_normalblast"},{"line":356,"kind":13,"name":"$okaytoprocess","containerName":"_chunk_normalblast"},{"name":"$mode","definition":"my","containerName":"_chunk_normalblast","localvar":"my","kind":13,"line":358},{"kind":13,"line":360,"containerName":"_chunk_normalblast","name":"$tail","definition":"my","localvar":"my"},{"line":366,"kind":13,"localvar":"my","containerName":"_chunk_normalblast","definition":"my","name":"$fh"},{"name":"$self","containerName":"_chunk_normalblast","kind":13,"line":366},{"kind":12,"line":366,"containerName":"_chunk_normalblast","name":"_fh"},{"localvar":"my","containerName":"_chunk_normalblast","name":"$line","definition":"my","line":369,"kind":13},{"kind":13,"line":369,"containerName":"_chunk_normalblast","name":"$fh"},{"containerName":"_chunk_normalblast","name":"$line","kind":13,"line":370},{"name":"$line","containerName":"_chunk_normalblast","kind":13,"line":370},{"name":"$line","containerName":"_chunk_normalblast","line":371,"kind":13},{"line":372,"kind":13,"containerName":"_chunk_normalblast","name":"$self"},{"line":374,"kind":13,"name":"$line","containerName":"_chunk_normalblast"},{"line":375,"kind":13,"name":"$self","containerName":"_chunk_normalblast"},{"kind":13,"line":375,"name":"$self","containerName":"_chunk_normalblast"},{"line":376,"kind":13,"containerName":"_chunk_normalblast","name":"$sawxmlheader"},{"kind":13,"line":377,"containerName":"_chunk_normalblast","name":"$mode"},{"name":"$line","containerName":"_chunk_normalblast","kind":13,"line":378},{"kind":13,"line":379,"containerName":"_chunk_normalblast","name":"$sawxmlheader"},{"kind":13,"line":380,"name":"$tfh","containerName":"_chunk_normalblast"},{"name":"$tfh","containerName":"_chunk_normalblast","kind":13,"line":381},{"kind":13,"line":381,"name":"$self","containerName":"_chunk_normalblast"},{"kind":13,"line":383,"containerName":"_chunk_normalblast","name":"$self"},{"line":383,"kind":13,"containerName":"_chunk_normalblast","name":"$self"},{"kind":13,"line":386,"containerName":"_chunk_normalblast","name":"$mode"},{"name":"$line","containerName":"_chunk_normalblast","line":387,"kind":13},{"kind":13,"line":388,"name":"$tfh","containerName":"_chunk_normalblast"},{"containerName":"_chunk_normalblast","name":"$tfh","line":389,"kind":13},{"kind":13,"line":389,"containerName":"_chunk_normalblast","name":"$line"},{"kind":13,"line":389,"name":"$tail","containerName":"_chunk_normalblast"},{"name":"$self","containerName":"_chunk_normalblast","kind":13,"line":391},{"containerName":"_chunk_normalblast","name":"$line","line":391,"kind":13},{"name":"$tail","containerName":"_chunk_normalblast","kind":13,"line":391},{"name":"$okaytoprocess","containerName":"_chunk_normalblast","line":393,"kind":13},{"line":396,"kind":13,"containerName":"_chunk_normalblast","name":"$tfh"},{"containerName":"_chunk_normalblast","name":"$tfh","kind":13,"line":397},{"containerName":"_chunk_normalblast","name":"$line","kind":13,"line":397},{"line":399,"kind":13,"name":"$self","containerName":"_chunk_normalblast"},{"name":"$line","containerName":"_chunk_normalblast","line":399,"kind":13},{"kind":13,"line":401,"containerName":"_chunk_normalblast","name":"$self"},{"kind":13,"line":401,"containerName":"_chunk_normalblast","name":"$line"},{"name":"$mode","containerName":"_chunk_normalblast","kind":13,"line":401},{"kind":13,"line":403,"containerName":"_chunk_normalblast","name":"$okaytoprocess"}]},{"name":"_chunk_psiblast","range":{"end":{"character":9999,"line":433},"start":{"line":406,"character":0}},"containerName":"main::","definition":"sub","detail":"($self,$tfh)","signature":{"label":"_chunk_psiblast($self,$tfh)","parameters":[{"label":"$self"},{"label":"$tfh"}],"documentation":""},"kind":12,"line":406,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"_chunk_psiblast","line":407,"kind":13},{"name":"$tfh","containerName":"_chunk_psiblast","line":407,"kind":13},{"line":411,"kind":13,"containerName":"_chunk_psiblast","name":"$self"},{"containerName":"_chunk_psiblast","definition":"my","name":"$sawxmlheader","localvar":"my","kind":13,"line":413},{"line":413,"kind":13,"containerName":"_chunk_psiblast","name":"$okaytoprocess"},{"kind":13,"line":416,"definition":"my","name":"$fh","containerName":"_chunk_psiblast","localvar":"my"},{"line":416,"kind":13,"name":"$self","containerName":"_chunk_psiblast"},{"line":416,"kind":12,"name":"_fh","containerName":"_chunk_psiblast"},{"localvar":"my","definition":"my","name":"$line","containerName":"_chunk_psiblast","line":419,"kind":13},{"name":"$fh","containerName":"_chunk_psiblast","line":419,"kind":13},{"name":"$tfh","containerName":"_chunk_psiblast","line":420,"kind":13},{"kind":13,"line":421,"containerName":"_chunk_psiblast","name":"$tfh"},{"kind":13,"line":421,"containerName":"_chunk_psiblast","name":"$line"},{"kind":13,"line":423,"containerName":"_chunk_psiblast","name":"$self"},{"line":423,"kind":13,"name":"$line","containerName":"_chunk_psiblast"},{"line":426,"kind":13,"name":"$line","containerName":"_chunk_psiblast"},{"line":427,"kind":13,"containerName":"_chunk_psiblast","name":"$okaytoprocess"},{"line":432,"kind":13,"name":"$okaytoprocess","containerName":"_chunk_psiblast"}]}],"version":5}