{"vars":[{"kind":2,"line":90,"containerName":"","name":"base"},{"kind":12,"line":112,"children":[{"line":113,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"_initialize"},{"kind":13,"line":113,"containerName":"_initialize","name":"@args"},{"line":117,"kind":13,"localvar":"my","containerName":"_initialize","name":"$writer","definition":"my"},{"name":"$file","containerName":"_initialize","kind":13,"line":117},{"containerName":"_initialize","name":"$fh","line":117,"kind":13},{"line":117,"kind":13,"containerName":"_initialize","name":"$piped_behaviour"},{"containerName":"_initialize","name":"$evalue","line":117,"kind":13},{"line":117,"kind":13,"name":"$score","containerName":"_initialize"},{"kind":13,"line":118,"name":"$self","containerName":"_initialize"},{"line":118,"kind":12,"name":"_rearrange","containerName":"_initialize"},{"line":122,"kind":13,"containerName":"_initialize","name":"@args"},{"containerName":"_initialize","name":"$self","kind":13,"line":123},{"line":123,"kind":12,"name":"writer","containerName":"_initialize"},{"containerName":"_initialize","name":"$writer","line":123,"kind":13},{"containerName":"_initialize","name":"$writer","kind":13,"line":123},{"name":"$self","containerName":"_initialize","line":125,"kind":13},{"line":125,"kind":12,"name":"_fields","containerName":"_initialize"},{"containerName":"_initialize","name":"$self","kind":13,"line":136},{"containerName":"_initialize","name":"_fields","kind":12,"line":136},{"containerName":"_initialize","name":"$evalue","kind":13,"line":136},{"name":"$evalue","containerName":"_initialize","kind":13,"line":136},{"containerName":"_initialize","name":"$self","kind":13,"line":137},{"line":137,"kind":12,"containerName":"_initialize","name":"_fields"},{"line":137,"kind":13,"name":"$score","containerName":"_initialize"},{"line":137,"kind":13,"name":"$score","containerName":"_initialize"},{"containerName":"_initialize","name":"$self","kind":13,"line":139},{"kind":12,"line":139,"name":"_dependencies","containerName":"_initialize"},{"kind":13,"line":145,"containerName":"_initialize","name":"$self"},{"line":145,"kind":12,"name":"chunk","containerName":"_initialize"},{"line":145,"kind":13,"name":"$file","containerName":"_initialize"},{"name":"$fh","containerName":"_initialize","kind":13,"line":145},{"kind":13,"line":145,"containerName":"_initialize","name":"$self"},{"containerName":"_initialize","name":"throw","line":145,"kind":12},{"name":"$piped_behaviour","containerName":"_initialize","line":146,"kind":13}],"containerName":"main::","definition":"sub","detail":"($self,@args)","signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: blast_pull.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::blast_pull\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::blast_pull - A parser for BLAST output\n\n=head1 SYNOPSIS\n\n    # do not use this class directly it is available through Bio::SearchIO\n    use Bio::SearchIO;\n    my $in = Bio::SearchIO->new(-format => 'blast_pull',\n                               -file   => 't/data/new_blastn.txt');\n    while (my $result = $in->next_result) {\n        # this is a Bio::Search::Result::BlastPullResult object\n        print \"Results for \", $result->query_name(), \"\\n\";\n        while (my $hit = $result->next_hit) {\n            print $hit->name(), \"\\n\";\n            while (my $hsp = $hit->next_hsp) {\n                print \"length is \", $hsp->length(), \"\\n\";\n            }\n        }\n    }\n\n=head1 DESCRIPTION\n\nThis object implements a pull-parser for BLAST output. It is fast since it\nonly does work on request (hence 'pull').\n\nCurrently only NCBI BLASTN and BLASTP are supported.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::blast_pull;\n\nuse strict;\nuse Bio::Search::Result::BlastPullResult;\n\nuse base qw(Bio::SearchIO Bio::PullParserI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::blast_pull->new();\n Function: Builds a new Bio::SearchIO::blast_pull object \n Returns : Bio::SearchIO::blast_pull\n Args    : -fh/-file => BLAST output filename\n           -format   => 'blast_pull'\n           -evalue   => float or scientific notation number to be used\n                        as an evalue cutoff for hits\n           -score    => integer or scientific notation number to be used\n                        as a score value cutoff for hits\n           -piped_behaviour => 'temp_file'|'memory'|'sequential_read'\n\n           -piped_behaviour defines what the parser should do if the input is\n            an unseekable filehandle (eg. piped input), see\n            Bio::PullParserI::chunk for details. Default is 'memory'.","label":"_initialize($self,@args)"},"name":"_initialize","range":{"end":{"character":9999,"line":147},"start":{"character":0,"line":112}}},{"name":"header","line":125,"kind":12},{"name":"algorithm","kind":12,"line":126},{"name":"algorithm_version","line":127,"kind":12},{"kind":12,"line":128,"name":"algorithm_reference"},{"name":"database_name","kind":12,"line":129},{"name":"database_letters","line":130,"kind":12},{"kind":12,"line":131,"name":"database_entries"},{"name":"next_result","line":132,"kind":12},{"kind":12,"line":133,"name":"evalue_cutoff"},{"name":"score_cutoff","line":134,"kind":12},{"name":"evalue_cutoff","line":136,"kind":12},{"name":"score_cutoff","line":137,"kind":12},{"name":"algorithm","line":139,"kind":12},{"name":"algorithm_version","kind":12,"line":140},{"kind":12,"line":141,"name":"database_name"},{"kind":12,"line":142,"name":"database_letters"},{"name":"database_entries","line":143,"kind":12},{"kind":12,"line":149,"children":[{"containerName":"_discover_header","name":"$self","definition":"my","localvar":"my","kind":13,"line":150},{"containerName":"_discover_header","name":"$self","kind":13,"line":151},{"name":"_chunk_seek","containerName":"_discover_header","line":151,"kind":12},{"line":152,"kind":13,"localvar":"my","containerName":"_discover_header","name":"$header","definition":"my"},{"kind":13,"line":152,"containerName":"_discover_header","name":"$self"},{"kind":12,"line":152,"name":"_get_chunk_by_end","containerName":"_discover_header"},{"line":153,"kind":13,"name":"$self","containerName":"_discover_header"},{"kind":13,"line":153,"name":"$self","containerName":"_discover_header"},{"containerName":"_discover_header","name":"_chunk_tell","kind":12,"line":153},{"kind":13,"line":156,"name":"$header","containerName":"_discover_header"},{"containerName":"_discover_header","name":"$self","line":157,"kind":13},{"line":157,"kind":12,"name":"_fields","containerName":"_discover_header"},{"line":158,"kind":13,"containerName":"_discover_header","name":"$self"},{"containerName":"_discover_header","name":"_fields","line":158,"kind":12},{"line":160,"kind":13,"localvar":"my","definition":"my","name":"$database","containerName":"_discover_header"},{"kind":13,"line":160,"containerName":"_discover_header","name":"$header"},{"kind":13,"line":162,"name":"$database","containerName":"_discover_header"},{"line":164,"kind":13,"localvar":"my","definition":"my","name":"$header2","containerName":"_discover_header"},{"line":164,"kind":13,"containerName":"_discover_header","name":"$self"},{"line":164,"kind":12,"name":"_get_chunk_by_end","containerName":"_discover_header"},{"line":165,"kind":13,"name":"$database","containerName":"_discover_header"},{"line":165,"kind":13,"name":"$header2","containerName":"_discover_header"},{"containerName":"_discover_header","name":"$database","line":168,"kind":13},{"kind":13,"line":169,"containerName":"_discover_header","name":"$entries","definition":"my","localvar":"my"},{"containerName":"_discover_header","definition":"my","name":"$letters","localvar":"my","kind":13,"line":170},{"kind":13,"line":171,"containerName":"_discover_header","name":"$database"},{"containerName":"_discover_header","name":"$entries","line":172,"kind":13},{"name":"$letters","containerName":"_discover_header","kind":13,"line":173},{"containerName":"_discover_header","name":"$self","kind":13,"line":174},{"line":174,"kind":12,"containerName":"_discover_header","name":"_fields"},{"containerName":"_discover_header","name":"$database","kind":13,"line":174},{"containerName":"_discover_header","name":"$self","kind":13,"line":175},{"kind":12,"line":175,"containerName":"_discover_header","name":"_fields"},{"line":175,"kind":13,"containerName":"_discover_header","name":"$entries"},{"kind":13,"line":176,"name":"$self","containerName":"_discover_header"},{"containerName":"_discover_header","name":"_fields","line":176,"kind":12},{"name":"$letters","containerName":"_discover_header","kind":13,"line":176},{"containerName":"_discover_header","name":"$self","kind":13,"line":178},{"line":178,"kind":12,"containerName":"_discover_header","name":"_fields"}],"containerName":"main::","name":"_discover_header","definition":"sub","range":{"end":{"line":179,"character":9999},"start":{"character":0,"line":149}}},{"line":153,"kind":12,"name":"_after_header"},{"line":157,"kind":12,"name":"algorithm"},{"name":"algorithm_version","line":158,"kind":12},{"line":174,"kind":12,"name":"database_name"},{"kind":12,"line":175,"name":"database_entries"},{"name":"database_letters","kind":12,"line":176},{"name":"header","kind":12,"line":178},{"definition":"sub","name":"_discover_next_result","containerName":"main::","range":{"start":{"character":0,"line":181},"end":{"character":9999,"line":215}},"kind":12,"children":[{"line":182,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"_discover_next_result"},{"name":"$self","containerName":"_discover_next_result","kind":13,"line":183},{"containerName":"_discover_next_result","name":"$type","definition":"my","localvar":"my","kind":13,"line":184},{"line":184,"kind":13,"name":"$self","containerName":"_discover_next_result"},{"line":184,"kind":12,"name":"get_field","containerName":"_discover_next_result"},{"name":"$type","containerName":"_discover_next_result","kind":13,"line":186},{"containerName":"_discover_next_result","name":"$type","line":186,"kind":13},{"name":"$self","containerName":"_discover_next_result","kind":13,"line":187},{"name":"_sequential","containerName":"_discover_next_result","kind":12,"line":187},{"containerName":"_discover_next_result","name":"$self","kind":13,"line":188},{"containerName":"_discover_next_result","name":"_chunk_seek","kind":12,"line":188},{"line":188,"kind":13,"containerName":"_discover_next_result","name":"$self"},{"line":188,"kind":13,"name":"$self","containerName":"_discover_next_result"},{"kind":13,"line":190,"definition":"my","name":"$start","containerName":"_discover_next_result","localvar":"my"},{"line":190,"kind":13,"containerName":"_discover_next_result","name":"$end"},{"kind":13,"line":190,"name":"$self","containerName":"_discover_next_result"},{"kind":12,"line":190,"name":"_find_chunk_by_end","containerName":"_discover_next_result"},{"containerName":"_discover_next_result","name":"$start","line":191,"kind":13},{"name":"$end","containerName":"_discover_next_result","kind":13,"line":191},{"name":"$end","containerName":"_discover_next_result","line":193,"kind":13},{"containerName":"_discover_next_result","name":"$start","line":194,"kind":13},{"line":194,"kind":13,"name":"$self","containerName":"_discover_next_result"},{"name":"$self","containerName":"_discover_next_result","kind":13,"line":194},{"name":"$end","containerName":"_discover_next_result","line":195,"kind":13},{"line":198,"kind":13,"containerName":"_discover_next_result","name":"$self"},{"name":"_fields","containerName":"_discover_next_result","kind":12,"line":198},{"kind":12,"line":198,"name":"new","containerName":"_discover_next_result"},{"kind":13,"line":198,"name":"$self","containerName":"_discover_next_result"},{"line":198,"kind":12,"containerName":"_discover_next_result","name":"chunk"},{"line":198,"kind":13,"containerName":"_discover_next_result","name":"$start"},{"containerName":"_discover_next_result","name":"$end","kind":13,"line":198},{"line":199,"kind":13,"name":"$self","containerName":"_discover_next_result"},{"kind":13,"line":201,"name":"$self","containerName":"_discover_next_result"},{"line":201,"kind":13,"name":"$end","containerName":"_discover_next_result"},{"name":"$self","containerName":"_discover_next_result","line":205,"kind":13},{"kind":12,"line":205,"name":"throw","containerName":"_discover_next_result"},{"kind":13,"line":206,"definition":"my","name":"$chunk","containerName":"_discover_next_result","localvar":"my"},{"kind":13,"line":206,"name":"$self","containerName":"_discover_next_result"},{"line":206,"kind":12,"containerName":"_discover_next_result","name":"_get_chunk_by_end"},{"kind":13,"line":207,"name":"$chunk","containerName":"_discover_next_result"},{"name":"$self","containerName":"_discover_next_result","line":208,"kind":13},{"line":208,"kind":12,"containerName":"_discover_next_result","name":"_fields"},{"kind":12,"line":208,"containerName":"_discover_next_result","name":"new"},{"containerName":"_discover_next_result","name":"$chunk","kind":13,"line":208},{"name":"$self","containerName":"_discover_next_result","line":209,"kind":13},{"kind":13,"line":213,"containerName":"_discover_next_result","name":"$self"},{"containerName":"_discover_next_result","name":"throw","line":213,"kind":12}],"line":181},{"kind":12,"line":183,"name":"_after_results"},{"name":"_end_of_previous_result","kind":12,"line":188},{"line":188,"kind":12,"name":"_after_header"},{"name":"_end_of_previous_result","line":194,"kind":12},{"name":"_after_header","kind":12,"line":194},{"line":198,"kind":12,"name":"next_result"},{"name":"Bio","containerName":"Search::Result::BlastPullResult","line":198,"kind":12},{"name":"_end_of_previous_result","line":201,"kind":12},{"name":"next_result","kind":12,"line":208},{"name":"Bio","containerName":"Search::Result::BlastPullResult","kind":12,"line":208},{"kind":12,"line":227,"children":[{"localvar":"my","containerName":"next_result","definition":"my","name":"$self","line":228,"kind":13},{"definition":"my","name":"$result","containerName":"next_result","localvar":"my","kind":13,"line":229},{"containerName":"next_result","name":"$self","line":229,"kind":13},{"containerName":"next_result","name":"get_field","line":229,"kind":12},{"line":231,"kind":13,"containerName":"next_result","name":"$self"},{"containerName":"next_result","name":"_fields","kind":12,"line":231},{"containerName":"next_result","name":"$self","kind":13,"line":233},{"kind":13,"line":234,"name":"$result","containerName":"next_result"}],"containerName":"main::","definition":"sub","name":"next_result","range":{"end":{"character":9999,"line":235},"start":{"line":227,"character":0}}},{"name":"next_result","line":231,"kind":12},{"children":[{"line":248,"kind":13,"localvar":"my","containerName":"result_count","definition":"my","name":"$self"},{"kind":13,"line":249,"containerName":"result_count","name":"$self"}],"line":247,"kind":12,"range":{"start":{"character":0,"line":247},"end":{"character":9999,"line":250}},"definition":"sub","name":"result_count","containerName":"main::"},{"range":{"start":{"character":0,"line":269},"end":{"line":272,"character":9999}},"containerName":"main::","definition":"sub","name":"rewind","line":269,"children":[{"name":"$self","definition":"my","containerName":"rewind","localvar":"my","kind":13,"line":270},{"containerName":"rewind","name":"$self","kind":13,"line":271}],"kind":12},{"line":271,"kind":12,"name":"_end_of_previous_result"}],"version":5}