{"version":5,"vars":[{"containerName":"","name":"vars","line":146,"kind":2},{"containerName":"","name":"base","kind":2,"line":155},{"name":"%MODEMAP","containerName":null,"line":161,"kind":13},{"kind":2,"line":161,"name":"Dumper","containerName":"Data"},{"name":"%MAPPING","containerName":null,"line":171,"kind":13},{"containerName":null,"name":"%frame","definition":"my","localvar":"my","kind":13,"line":270},{"line":271,"kind":13,"localvar":"my","name":"%strand","definition":"my","containerName":null},{"line":272,"kind":13,"localvar":"my","name":"%ind","definition":"my","containerName":null},{"containerName":null,"name":"%MAPPING","line":277,"kind":13},{"containerName":null,"name":"%val","definition":"my","localvar":"my","kind":13,"line":280},{"line":281,"kind":13,"localvar":"my","definition":"my","name":"%type","containerName":null},{"line":282,"kind":13,"localvar":"my","name":"$key","definition":"my","containerName":null},{"kind":13,"line":283,"definition":"my","name":"%val","containerName":null,"localvar":"my"},{"line":286,"kind":13,"name":"%MAPPING","containerName":null},{"name":"$key","containerName":null,"kind":13,"line":286},{"kind":13,"line":286,"containerName":null,"name":"$val"},{"definition":"my","name":"%stats","containerName":null,"localvar":"my","kind":13,"line":293},{"kind":13,"line":304,"containerName":null,"definition":"my","name":"$key","localvar":"my"},{"containerName":null,"definition":"my","name":"%val","localvar":"my","kind":13,"line":305},{"name":"$stats","containerName":null,"line":305,"kind":13},{"line":306,"kind":13,"containerName":null,"name":"%MAPPING"},{"name":"$key","containerName":null,"kind":13,"line":306},{"name":"$val","containerName":null,"kind":13,"line":306},{"line":310,"kind":13,"localvar":"my","containerName":null,"definition":"my","name":"%param"},{"localvar":"my","definition":"my","name":"$key","containerName":null,"line":318,"kind":13},{"localvar":"my","name":"%val","definition":"my","containerName":null,"line":319,"kind":13},{"name":"$param","containerName":null,"kind":13,"line":319},{"containerName":null,"name":"%MAPPING","kind":13,"line":320},{"containerName":null,"name":"$key","kind":13,"line":320},{"line":320,"kind":13,"containerName":null,"name":"$val"},{"containerName":null,"name":"$DEFAULT_BLAST_WRITER_CLASS","kind":13,"line":323},{"containerName":null,"name":"$MAX_HSP_OVERLAP","line":324,"kind":13},{"line":325,"kind":13,"containerName":null,"name":"$DEFAULTREPORTTYPE"},{"signature":{"label":"_initialize($self,@args)","documentation":"(Sesame Street aficionados note: This answer was NOT given by Mr. Noodle ;-P)\n# $Id: blast.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::blast\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n# 20030409 - sac\n#          PSI-BLAST full parsing support. Rollout of new\n#          model which will remove Steve's old psiblast driver\n# 20030424 - jason\n#          Megablast parsing fix as reported by Neil Saunders\n# 20030427 - jason\n#          Support bl2seq parsing\n# 20031124 - jason\n#          Parse more blast statistics, lambda, entropy, etc\n#          from WU-BLAST in frame-specific manner\n# 20060216 - cjf - fixed blast parsing for BLAST v2.2.13 output\n# 20071104 - dmessina - added support for WUBLAST -echofilter\n# 20071121 - cjf - fixed several bugs (bugs 2391, 2399, 2409)\n\n=head1 NAME\n\nBio::SearchIO::blast - Event generator for event based parsing of\nblast reports\n\n=head1 SYNOPSIS\n\n   # Do not use this object directly - it is used as part of the\n   # Bio::SearchIO system.\n\n    use Bio::SearchIO;\n    my $searchio = Bio::SearchIO->new(-format => 'blast',\n                                     -file   => 't/data/ecolitst.bls');\n    while( my $result = $searchio->next_result ) {\n        while( my $hit = $result->next_hit ) {\n            while( my $hsp = $hit->next_hsp ) {\n                # ...\n            }\n        }\n    }\n\n=head1 DESCRIPTION\n\nThis object encapsulated the necessary methods for generating events\nsuitable for building Bio::Search objects from a BLAST report file.\nRead the L<Bio::SearchIO> for more information about how to use this.\n\nThis driver can parse:\n\n=over 4\n\n* * \n\nNCBI produced plain text BLAST reports from blastall, this also\nincludes PSIBLAST, PSITBLASTN, RPSBLAST, and bl2seq reports.  NCBI XML\nBLAST output is parsed with the blastxml SearchIO driver\n\n* *\n\nWU-BLAST all reports\n\n* *\n\nJim Kent's BLAST-like output from his programs (BLASTZ, BLAT)\n\n* *\n\nBLAST-like output from Paracel BTK output\n\n\n=head2 bl2seq parsing\n\nSince I cannot differentiate between BLASTX and TBLASTN since bl2seq\ndoesn't report the algorithm used - I assume it is BLASTX by default -\nyou can supply the program type with -report_type in the SearchIO\nconstructor i.e.\n\n  my $parser = Bio::SearchIO->new(-format => 'blast',\n                                 -file => 'bl2seq.tblastn.report',\n                                 -report_type => 'tblastn');\n\nThis only really affects where the frame and strand information are\nput - they will always be on the $hsp-E<gt>query instead of on the\n$hsp-E<gt>hit part of the feature pair for blastx and tblastn bl2seq\nproduced reports.  Hope that's clear...\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail Jason Stajich jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nSteve Chervitz sac-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...'\n\npackage Bio::SearchIO::blast;\n\nuse Bio::SearchIO::IteratedSearchResultEventBuilder;\nuse strict;\nuse vars qw(%MAPPING %MODEMAP\n  $DEFAULT_BLAST_WRITER_CLASS\n  $MAX_HSP_OVERLAP\n  $DEFAULT_SIGNIF\n  $DEFAULT_SCORE\n  $DEFAULTREPORTTYPE\n);\n\n\nuse base qw(Bio::SearchIO);\nuse Data::Dumper;\n\nBEGIN {\n\n    # mapping of NCBI Blast terms to Bioperl hash keys\n    %MODEMAP = (\n        'BlastOutput' => 'result',\n        'Iteration'   => 'iteration',\n        'Hit'         => 'hit',\n        'Hsp'         => 'hsp'\n    );\n\n    # This should really be done more intelligently, like with\n    # XSLT\n\n    %MAPPING = (\n        'Hsp_bit-score'   => 'HSP-bits',\n        'Hsp_score'       => 'HSP-score',\n        'Hsp_evalue'      => 'HSP-evalue',\n        'Hsp_n',          => 'HSP-n',\n        'Hsp_pvalue'      => 'HSP-pvalue',\n        'Hsp_query-from'  => 'HSP-query_start',\n        'Hsp_query-to'    => 'HSP-query_end',\n        'Hsp_hit-from'    => 'HSP-hit_start',\n        'Hsp_hit-to'      => 'HSP-hit_end',\n        'Hsp_positive'    => 'HSP-conserved',\n        'Hsp_identity'    => 'HSP-identical',\n        'Hsp_gaps'        => 'HSP-hsp_gaps',\n        'Hsp_hitgaps'     => 'HSP-hit_gaps',\n        'Hsp_querygaps'   => 'HSP-query_gaps',\n        'Hsp_qseq'        => 'HSP-query_seq',\n        'Hsp_hseq'        => 'HSP-hit_seq',\n        'Hsp_midline'     => 'HSP-homology_seq',\n        'Hsp_align-len'   => 'HSP-hsp_length',\n        'Hsp_query-frame' => 'HSP-query_frame',\n        'Hsp_hit-frame'   => 'HSP-hit_frame',\n        'Hsp_links'       => 'HSP-links',\n        'Hsp_group'       => 'HSP-hsp_group',\n        'Hsp_features'    => 'HSP-hit_features',\n\n        'Hit_id'        => 'HIT-name',\n        'Hit_len'       => 'HIT-length',\n        'Hit_accession' => 'HIT-accession',\n        'Hit_def'       => 'HIT-description',\n        'Hit_signif'    => 'HIT-significance',\n        # For NCBI blast, the description line contains bits.\n        # For WU-blast, the  description line contains score.\n        'Hit_score' => 'HIT-score',\n        'Hit_bits'  => 'HIT-bits',\n\n        'Iteration_iter-num'  => 'ITERATION-number',\n        'Iteration_converged' => 'ITERATION-converged',\n\n        'BlastOutput_program'             => 'RESULT-algorithm_name',\n        'BlastOutput_version'             => 'RESULT-algorithm_version',\n        'BlastOutput_query-def'           => 'RESULT-query_name',\n        'BlastOutput_query-len'           => 'RESULT-query_length',\n        'BlastOutput_query-acc'           => 'RESULT-query_accession',\n        'BlastOutput_query-gi'            => 'RESULT-query_gi',\n        'BlastOutput_querydesc'           => 'RESULT-query_description',\n        'BlastOutput_db'                  => 'RESULT-database_name',\n        'BlastOutput_db-len'              => 'RESULT-database_entries',\n        'BlastOutput_db-let'              => 'RESULT-database_letters',\n        'BlastOutput_inclusion-threshold' => 'RESULT-inclusion_threshold',\n\n        'Parameters_matrix'      => { 'RESULT-parameters' => 'matrix' },\n        'Parameters_expect'      => { 'RESULT-parameters' => 'expect' },\n        'Parameters_include'     => { 'RESULT-parameters' => 'include' },\n        'Parameters_sc-match'    => { 'RESULT-parameters' => 'match' },\n        'Parameters_sc-mismatch' => { 'RESULT-parameters' => 'mismatch' },\n        'Parameters_gap-open'    => { 'RESULT-parameters' => 'gapopen' },\n        'Parameters_gap-extend'  => { 'RESULT-parameters' => 'gapext' },\n        'Parameters_filter'      => { 'RESULT-parameters' => 'filter' },\n        'Parameters_allowgaps'   => { 'RESULT-parameters' => 'allowgaps' },\n        'Parameters_full_dbpath' => { 'RESULT-parameters' => 'full_dbpath' },\n        'Statistics_db-len'      => { 'RESULT-statistics' => 'dbentries' },\n        'Statistics_db-let'      => { 'RESULT-statistics' => 'dbletters' },\n        'Statistics_hsp-len'     =>\n          { 'RESULT-statistics' => 'effective_hsplength' },\n        'Statistics_query-len' => { 'RESULT-statistics' => 'querylength' },\n        'Statistics_eff-space' => { 'RESULT-statistics' => 'effectivespace' },\n        'Statistics_eff-spaceused' =>\n          { 'RESULT-statistics' => 'effectivespaceused' },\n        'Statistics_eff-dblen' =>\n          { 'RESULT-statistics' => 'effectivedblength' },\n        'Statistics_kappa'         => { 'RESULT-statistics' => 'kappa' },\n        'Statistics_lambda'        => { 'RESULT-statistics' => 'lambda' },\n        'Statistics_entropy'       => { 'RESULT-statistics' => 'entropy' },\n        'Statistics_gapped_kappa'  => { 'RESULT-statistics' => 'kappa_gapped' },\n        'Statistics_gapped_lambda' =>\n          { 'RESULT-statistics' => 'lambda_gapped' },\n        'Statistics_gapped_entropy' =>\n          { 'RESULT-statistics' => 'entropy_gapped' },\n\n        'Statistics_framewindow' =>\n          { 'RESULT-statistics' => 'frameshiftwindow' },\n        'Statistics_decay' => { 'RESULT-statistics' => 'decayconst' },\n\n        'Statistics_hit_to_db' => { 'RESULT-statistics' => 'Hits_to_DB' },\n        'Statistics_num_suc_extensions' =>\n          { 'RESULT-statistics' => 'num_successful_extensions' },\n\n        # WU-BLAST stats\n        'Statistics_DFA_states' => { 'RESULT-statistics' => 'num_dfa_states' },\n        'Statistics_DFA_size'   => { 'RESULT-statistics' => 'dfa_size' },\n        'Statistics_noprocessors' =>\n          { 'RESULT-statistics' => 'no_of_processors' },\n        'Statistics_neighbortime' =>\n          { 'RESULT-statistics' => 'neighborhood_generate_time' },\n        'Statistics_starttime' => { 'RESULT-statistics' => 'start_time' },\n        'Statistics_endtime'   => { 'RESULT-statistics' => 'end_time' },\n    );\n\n    # add WU-BLAST Frame-Based Statistics\n    for my $frame ( 0 .. 3 ) {\n        for my $strand ( '+', '-' ) {\n            for my $ind (\n                qw(length efflength E S W T X X_gapped E2\n                E2_gapped S2)\n              )\n            {\n                $MAPPING{\"Statistics_frame$strand$frame\\_$ind\"} =\n                  { 'RESULT-statistics' => \"Frame$strand$frame\\_$ind\" };\n            }\n            for my $val (qw(lambda kappa entropy )) {\n                for my $type (qw(used computed gapped)) {\n                    my $key = \"Statistics_frame$strand$frame\\_$val\\_$type\";\n                    my $val =\n                      { 'RESULT-statistics' =>\n                          \"Frame$strand$frame\\_$val\\_$type\" };\n                    $MAPPING{$key} = $val;\n                }\n            }\n        }\n    }\n\n    # add Statistics\n    for my $stats (\n        qw(T A X1 X2 X3 S1 S2 X1_bits X2_bits X3_bits\n        S1_bits S2_bits  num_extensions\n        num_successful_extensions\n        seqs_better_than_cutoff\n        posted_date\n        search_cputime total_cputime\n        search_actualtime total_actualtime\n        no_of_processors ctxfactor)\n      )\n    {\n        my $key = \"Statistics_$stats\";\n        my $val = { 'RESULT-statistics' => $stats };\n        $MAPPING{$key} = $val;\n    }\n\n    # add WU-BLAST Parameters\n    for my $param (\n        qw(span span1 span2 links warnings notes hspsepsmax\n        hspsepqmax topcomboN topcomboE postsw cpus wordmask\n        filter sort_by_pvalue sort_by_count sort_by_highscore\n        sort_by_totalscore sort_by_subjectlength noseqs gi qtype\n        qres V B Z Y M N)\n      )\n    {\n        my $key = \"Parameters_$param\";\n        my $val = { 'RESULT-parameters' => $param };\n        $MAPPING{$key} = $val;\n    }\n\n    $DEFAULT_BLAST_WRITER_CLASS = 'Bio::Search::Writer::HitTableWriter';\n    $MAX_HSP_OVERLAP   = 2;           # Used when tiling multiple HSPs.\n    $DEFAULTREPORTTYPE = 'BLASTP';    # for bl2seq\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::blast->new(%args);\n Function: Builds a new Bio::SearchIO::blast object \n Returns : Bio::SearchIO::blast\n Args    : Key-value pairs:\n           -fh/-file => filehandle/filename to BLAST file\n           -format   => 'blast'\n           -report_type => 'blastx', 'tblastn', etc -- only for bl2seq\n                           reports when you want to distinguish between\n                           tblastn and blastx reports (this only controls\n                           where the frame information is put - on the query\n                           or subject object.\n           -inclusion_threshold => e-value threshold for inclusion in the\n                                   PSI-BLAST score matrix model (blastpgp)\n           -signif      => float or scientific notation number to be used\n                           as a P- or Expect value cutoff\n           -score       => integer or scientific notation number to be used\n                           as a blast score value cutoff\n           -bits        => integer or scientific notation number to be used\n                           as a bit score value cutoff\n           -hit_filter  => reference to a function to be used for\n                           filtering hits based on arbitrary criteria.\n                           All hits of each BLAST report must satisfy \n                           this criteria to be retained. \n                           If a hit fails this test, it is ignored.\n                           This function should take a\n                           Bio::Search::Hit::BlastHit.pm object as its first\n                           argument and return true\n                           if the hit should be retained.\n                           Sample filter function:\n                              -hit_filter => sub { $hit = shift;\n                                                   $hit->gaps == 0; },\n                           (Note: -filt_func is synonymous with -hit_filter)\n           -overlap     => integer. The amount of overlap to permit between\n                           adjacent HSPs when tiling HSPs. A reasonable value is 2.\n                           Default = $Bio::SearchIO::blast::MAX_HSP_OVERLAP.\n\n            The following criteria are not yet supported:\n            (these are probably best applied within this module rather than in the \n             event handler since they would permit the parser to take some shortcuts.)\n\n           -check_all_hits => boolean. Check all hits for significance against\n                              significance criteria.  Default = false.\n                              If false, stops processing hits after the first\n                              non-significant hit or the first hit that fails\n                              the hit_filter call. This speeds parsing,\n                              taking advantage of the fact that the hits\n                              are processed in the order they appear in the report.\n           -min_query_len => integer to be used as a minimum for query sequence length.\n                             Reports with query sequences below this length will\n                             not be processed. Default = no minimum length.\n           -best        => boolean. Only process the best hit of each report;\n                           default = false.","parameters":[{"label":"$self"},{"label":"@args"}]},"detail":"($self,@args)","definition":"sub","containerName":"main::","children":[{"name":"$self","definition":"my","containerName":"_initialize","localvar":"my","kind":13,"line":387},{"containerName":"_initialize","name":"@args","line":387,"kind":13},{"kind":13,"line":388,"name":"$self","containerName":"_initialize"},{"containerName":"_initialize","name":"@args","kind":13,"line":388},{"localvar":"my","name":"$handler","definition":"my","containerName":"_initialize","line":395,"kind":13},{"name":"new","containerName":"_initialize","kind":12,"line":395},{"containerName":"_initialize","name":"@args","kind":13,"line":395},{"kind":13,"line":396,"containerName":"_initialize","name":"$self"},{"kind":12,"line":396,"containerName":"_initialize","name":"attach_EventHandler"},{"line":396,"kind":13,"name":"$handler","containerName":"_initialize"},{"containerName":"_initialize","name":"$min_qlen","definition":"my","localvar":"my","kind":13,"line":405},{"containerName":"_initialize","name":"$check_all","line":405,"kind":13},{"name":"$overlap","containerName":"_initialize","line":405,"kind":13},{"kind":13,"line":405,"containerName":"_initialize","name":"$best"},{"kind":13,"line":405,"containerName":"_initialize","name":"$rpttype"},{"line":405,"kind":13,"containerName":"_initialize","name":"$self"},{"containerName":"_initialize","name":"_rearrange","line":405,"kind":12},{"name":"@args","containerName":"_initialize","kind":13,"line":412},{"containerName":"_initialize","name":"$min_qlen","line":414,"kind":13},{"kind":13,"line":414,"containerName":"_initialize","name":"$self"},{"name":"min_query_length","containerName":"_initialize","line":414,"kind":12},{"containerName":"_initialize","name":"$min_qlen","line":414,"kind":13},{"line":415,"kind":13,"containerName":"_initialize","name":"$best"},{"line":415,"kind":13,"name":"$self","containerName":"_initialize"},{"name":"best_hit_only","containerName":"_initialize","kind":12,"line":415},{"name":"$best","containerName":"_initialize","kind":13,"line":415},{"containerName":"_initialize","name":"$check_all","line":416,"kind":13},{"name":"$self","containerName":"_initialize","line":416,"kind":13},{"name":"check_all_hits","containerName":"_initialize","kind":12,"line":416},{"kind":13,"line":416,"containerName":"_initialize","name":"$check_all"},{"containerName":"_initialize","name":"$rpttype","kind":13,"line":417},{"line":417,"kind":13,"name":"$self","containerName":"_initialize"},{"containerName":"_initialize","name":"$rpttype","line":417,"kind":13}],"line":386,"kind":12,"range":{"start":{"line":386,"character":0},"end":{"line":418,"character":9999}},"name":"_initialize"},{"containerName":"_initialize","name":"SUPER","kind":12,"line":388},{"kind":12,"line":395,"containerName":"SearchIO::IteratedSearchResultEventBuilder","name":"Bio"},{"name":"attach_EventHandler","range":{"start":{"character":0,"line":420},"end":{"character":9999,"line":430}},"kind":12,"line":420,"children":[{"line":421,"kind":13,"localvar":"my","containerName":"attach_EventHandler","definition":"my","name":"$self"},{"name":"$handler","containerName":"attach_EventHandler","line":421,"kind":13},{"containerName":"attach_EventHandler","name":"$self","line":423,"kind":13},{"name":"$handler","containerName":"attach_EventHandler","kind":13,"line":423},{"kind":13,"line":428,"containerName":"attach_EventHandler","name":"$self"},{"kind":13,"line":428,"containerName":"attach_EventHandler","name":"$handler"}],"containerName":"main::","definition":"sub","detail":"($self,$handler)","signature":{"documentation":"","parameters":[{"label":"$self"},{"label":"$handler"}],"label":"attach_EventHandler($self,$handler)"}},{"name":"SUPER","containerName":"attach_EventHandler","line":423,"kind":12},{"name":"next_result","range":{"start":{"line":442,"character":0},"end":{"line":1855,"character":9999}},"kind":12,"line":442,"children":[{"containerName":"next_result","definition":"my","name":"$self","localvar":"my","kind":13,"line":443},{"localvar":"my","containerName":"next_result","name":"$v","definition":"my","line":444,"kind":13},{"kind":13,"line":444,"containerName":"next_result","name":"$self"},{"line":444,"kind":12,"containerName":"next_result","name":"verbose"},{"line":445,"kind":13,"localvar":"my","definition":"my","name":"$data","containerName":"next_result"},{"definition":"my","name":"$flavor","containerName":"next_result","localvar":"my","kind":13,"line":446},{"kind":13,"line":447,"containerName":"next_result","name":"$self"},{"line":448,"kind":13,"name":"$self","containerName":"next_result"},{"line":449,"kind":13,"localvar":"my","definition":"my","name":"$reporttype","containerName":"next_result"},{"kind":13,"line":449,"containerName":"next_result","name":"$seenquery"},{"kind":13,"line":449,"name":"$reportline","containerName":"next_result"},{"kind":13,"line":450,"containerName":"next_result","definition":"my","name":"$seeniteration","localvar":"my"},{"containerName":"next_result","name":"$found_again","kind":13,"line":450},{"containerName":"next_result","definition":"my","name":"$incl_threshold","localvar":"my","kind":13,"line":451},{"containerName":"next_result","name":"$self","line":451,"kind":13},{"line":451,"kind":12,"containerName":"next_result","name":"inclusion_threshold"},{"name":"$bl2seq_fix","definition":"my","containerName":"next_result","localvar":"my","kind":13,"line":452},{"kind":13,"line":453,"name":"$self","containerName":"next_result"},{"kind":12,"line":453,"containerName":"next_result","name":"start_document"},{"line":454,"kind":13,"localvar":"my","containerName":"next_result","definition":"my","name":"@hit_signifs"},{"kind":13,"line":455,"containerName":"next_result","name":"$gapped_stats","definition":"my","localvar":"my"},{"kind":13,"line":459,"containerName":"next_result","name":"$self"},{"containerName":"next_result","name":"_readline","line":459,"kind":12},{"line":469,"kind":13,"containerName":"next_result","name":"$reporttype"},{"localvar":"my","containerName":"next_result","definition":"my","name":"$reportversion","line":469,"kind":13},{"name":"$reportversion","containerName":"next_result","kind":13,"line":471},{"kind":13,"line":471,"containerName":"next_result","name":"$reportversion"},{"containerName":"next_result","name":"$self","kind":13,"line":472},{"kind":13,"line":474,"containerName":"next_result","name":"$self"},{"line":474,"kind":12,"name":"debug","containerName":"next_result"},{"kind":13,"line":475,"containerName":"next_result","name":"$self"},{"kind":13,"line":477,"name":"$self","containerName":"next_result"},{"line":477,"kind":12,"name":"_pushback","containerName":"next_result"},{"line":480,"kind":13,"name":"$self","containerName":"next_result"},{"name":"_start_blastoutput","containerName":"next_result","line":480,"kind":12},{"kind":13,"line":481,"containerName":"next_result","name":"$reporttype"},{"containerName":"next_result","name":"$reporttype","line":482,"kind":13},{"containerName":"next_result","name":"$reportline","kind":13,"line":484},{"line":485,"kind":13,"name":"$self","containerName":"next_result"},{"name":"element","containerName":"next_result","kind":12,"line":485},{"kind":13,"line":489,"containerName":"next_result","name":"$reporttype"},{"line":492,"kind":13,"containerName":"next_result","name":"$self"},{"kind":12,"line":492,"containerName":"next_result","name":"element"},{"containerName":"next_result","name":"$reportversion","line":496,"kind":13},{"line":498,"kind":13,"containerName":"next_result","name":"$self"},{"kind":12,"line":498,"containerName":"next_result","name":"element"},{"line":502,"kind":13,"containerName":"next_result","name":"$incl_threshold"},{"line":508,"kind":13,"containerName":"next_result","name":"$self"},{"containerName":"next_result","name":"debug","kind":12,"line":508},{"name":"$self","containerName":"next_result","line":510,"kind":13},{"containerName":"next_result","name":"in_element","kind":12,"line":510},{"line":511,"kind":13,"containerName":"next_result","name":"$self"},{"name":"end_element","containerName":"next_result","kind":12,"line":511},{"containerName":"next_result","name":"$self","line":512,"kind":13},{"line":512,"kind":12,"name":"in_element","containerName":"next_result"},{"name":"$self","containerName":"next_result","kind":13,"line":513},{"kind":12,"line":513,"name":"end_element","containerName":"next_result"},{"line":514,"kind":13,"name":"$seeniteration","containerName":"next_result"},{"name":"$self","containerName":"next_result","kind":13,"line":515},{"containerName":"next_result","name":"within_element","line":515,"kind":12},{"kind":13,"line":516,"name":"$self","containerName":"next_result"},{"kind":12,"line":516,"name":"end_element","containerName":"next_result"},{"name":"$self","containerName":"next_result","line":517,"kind":13},{"containerName":"next_result","name":"start_element","kind":12,"line":517},{"kind":13,"line":520,"containerName":"next_result","name":"$self"},{"line":520,"kind":12,"containerName":"next_result","name":"start_element"},{"line":522,"kind":13,"name":"$seeniteration","containerName":"next_result"},{"line":525,"kind":13,"localvar":"my","name":"$q","definition":"my","containerName":"next_result"},{"kind":13,"line":526,"containerName":"next_result","name":"$self"},{"containerName":"next_result","name":"debug","line":526,"kind":12},{"kind":13,"line":527,"containerName":"next_result","name":"$size","definition":"my","localvar":"my"},{"containerName":"next_result","name":"$seenquery","kind":13,"line":528},{"name":"$self","containerName":"next_result","line":529,"kind":13},{"kind":12,"line":529,"containerName":"next_result","name":"_pushback"},{"containerName":"next_result","name":"$reportline","kind":13,"line":529},{"line":529,"kind":13,"name":"$reportline","containerName":"next_result"},{"containerName":"next_result","name":"$self","kind":13,"line":530},{"line":530,"kind":12,"name":"_pushback","containerName":"next_result"},{"containerName":"next_result","name":"$reporttype","kind":13,"line":534},{"name":"$self","containerName":"next_result","line":535,"kind":13},{"containerName":"next_result","name":"_start_blastoutput","line":535,"kind":12},{"line":536,"kind":13,"containerName":"next_result","name":"$seeniteration"},{"kind":13,"line":537,"name":"$self","containerName":"next_result"},{"containerName":"next_result","name":"in_element","line":537,"kind":12},{"containerName":"next_result","name":"$self","kind":13,"line":538},{"line":538,"kind":12,"containerName":"next_result","name":"end_element"},{"kind":13,"line":539,"containerName":"next_result","name":"$self"},{"name":"start_element","containerName":"next_result","kind":12,"line":539},{"line":542,"kind":13,"containerName":"next_result","name":"$self"},{"containerName":"next_result","name":"start_element","line":542,"kind":12},{"line":544,"kind":13,"containerName":"next_result","name":"$seeniteration"},{"name":"$seenquery","containerName":"next_result","kind":13,"line":547},{"containerName":"next_result","name":"$q","kind":13,"line":547},{"name":"$self","containerName":"next_result","line":548,"kind":13},{"line":548,"kind":12,"containerName":"next_result","name":"_readline"},{"name":"$self","containerName":"next_result","line":551,"kind":13},{"line":551,"kind":12,"name":"_pushback","containerName":"next_result"},{"kind":13,"line":557,"containerName":"next_result","name":"$size"},{"kind":13,"line":558,"name":"$size","containerName":"next_result"},{"kind":13,"line":563,"name":"$q","containerName":"next_result"},{"name":"$q","containerName":"next_result","line":563,"kind":13},{"name":"$q","containerName":"next_result","kind":13,"line":564},{"kind":13,"line":565,"name":"$q","containerName":"next_result"},{"name":"$self","containerName":"next_result","kind":13,"line":568},{"name":"_readline","containerName":"next_result","kind":12,"line":568},{"line":570,"kind":13,"containerName":"next_result","name":"$q"},{"kind":13,"line":571,"definition":"my","name":"$nm","containerName":"next_result","localvar":"my"},{"containerName":"next_result","name":"$desc","kind":13,"line":571},{"containerName":"next_result","name":"$q","kind":13,"line":571},{"containerName":"next_result","name":"$self","line":572,"kind":13},{"line":572,"kind":12,"name":"element","containerName":"next_result"},{"line":576,"kind":13,"containerName":"next_result","name":"$nm"},{"name":"$nm","containerName":"next_result","line":577,"kind":13},{"line":578,"kind":13,"name":"$self","containerName":"next_result"},{"kind":12,"line":578,"name":"element","containerName":"next_result"},{"kind":13,"line":582,"name":"$size","containerName":"next_result"},{"containerName":"next_result","name":"$desc","line":584,"kind":13},{"containerName":"next_result","name":"$desc","line":584,"kind":13},{"containerName":"next_result","name":"$self","line":585,"kind":13},{"kind":12,"line":585,"containerName":"next_result","name":"element"},{"line":589,"kind":13,"containerName":"next_result","name":"$desc"},{"containerName":"next_result","name":"$gi","definition":"my","localvar":"my","kind":13,"line":591},{"kind":13,"line":591,"name":"$acc","containerName":"next_result"},{"containerName":"next_result","name":"$version","line":591,"kind":13},{"kind":13,"line":591,"containerName":"next_result","name":"$self"},{"containerName":"next_result","name":"_get_seq_identifiers","line":591,"kind":12},{"kind":13,"line":591,"containerName":"next_result","name":"$nm"},{"kind":13,"line":592,"containerName":"next_result","name":"$version"},{"containerName":"next_result","name":"$version","line":592,"kind":13},{"line":592,"kind":13,"name":"$version","containerName":"next_result"},{"kind":13,"line":593,"containerName":"next_result","name":"$self"},{"name":"element","containerName":"next_result","line":593,"kind":12},{"name":"$acc","containerName":"next_result","kind":13,"line":598},{"name":"$self","containerName":"next_result","kind":13,"line":604},{"containerName":"next_result","name":"debug","kind":12,"line":604},{"containerName":"next_result","name":"$self","kind":13,"line":605},{"kind":12,"line":605,"name":"_readline","containerName":"next_result"},{"kind":13,"line":607,"containerName":"next_result","name":"$self"},{"line":607,"kind":12,"name":"_pushback","containerName":"next_result"},{"name":"$self","containerName":"next_result","line":610,"kind":13},{"name":"debug","containerName":"next_result","line":610,"kind":12},{"name":"$flavor","containerName":"next_result","line":611,"kind":13},{"line":621,"kind":13,"containerName":"next_result","name":"$self"},{"line":621,"kind":12,"containerName":"next_result","name":"in_element"},{"line":622,"kind":13,"containerName":"next_result","name":"$self"},{"line":622,"kind":12,"name":"start_element","containerName":"next_result"},{"containerName":"next_result","name":"$self","line":626,"kind":13},{"kind":12,"line":626,"name":"element","containerName":"next_result"},{"line":629,"kind":13,"name":"$self","containerName":"next_result"},{"kind":13,"line":631,"containerName":"next_result","name":"$self"},{"kind":13,"line":632,"name":"$self","containerName":"next_result"},{"name":"element","containerName":"next_result","line":632,"kind":12},{"containerName":"next_result","name":"$self","line":635,"kind":13},{"containerName":"next_result","name":"$self","line":637,"kind":13},{"kind":13,"line":638,"containerName":"next_result","name":"$self"},{"containerName":"next_result","name":"element","line":638,"kind":12},{"kind":13,"line":641,"name":"$self","containerName":"next_result"},{"name":"$self","containerName":"next_result","line":643,"kind":13},{"localvar":"my","definition":"my","name":"$h_regex","containerName":"next_result","line":647,"kind":13},{"line":648,"kind":13,"localvar":"my","definition":"my","name":"$seen_block","containerName":"next_result"},{"containerName":"next_result","definition":"my","name":"$descline","localvar":"my","kind":13,"line":650},{"kind":13,"line":650,"name":"$self","containerName":"next_result"},{"line":650,"kind":12,"containerName":"next_result","name":"_readline"},{"name":"$descline","containerName":"next_result","line":651,"kind":13},{"containerName":"next_result","name":"$seen_block","kind":13,"line":652},{"kind":13,"line":656,"name":"$seen_block","containerName":"next_result"},{"line":658,"kind":13,"containerName":"next_result","name":"$descline"},{"line":659,"kind":13,"localvar":"my","definition":"my","name":"$id","containerName":"next_result"},{"line":659,"kind":13,"containerName":"next_result","name":"$nextline"},{"name":"$self","containerName":"next_result","kind":13,"line":659},{"kind":12,"line":659,"name":"_readline","containerName":"next_result"},{"line":660,"kind":13,"containerName":"next_result","name":"$nextline"},{"containerName":"next_result","name":"$descline","line":661,"kind":13},{"kind":13,"line":664,"name":"$descline","containerName":"next_result"},{"line":670,"kind":13,"localvar":"my","containerName":"next_result","name":"$score","definition":"my"},{"name":"$evalue","containerName":"next_result","line":670,"kind":13},{"containerName":"next_result","name":"$evalue","kind":13,"line":673},{"line":676,"kind":13,"localvar":"my","definition":"my","name":"@line","containerName":"next_result"},{"kind":13,"line":676,"containerName":"next_result","name":"$descline"},{"kind":13,"line":679,"containerName":"next_result","name":"@line"},{"name":"@line","containerName":"next_result","kind":13,"line":679},{"containerName":"next_result","name":"@line","line":683,"kind":13},{"containerName":"next_result","name":"@hit_signifs","kind":13,"line":687},{"containerName":"next_result","name":"$evalue","kind":13,"line":687},{"kind":13,"line":687,"name":"$score","containerName":"next_result"},{"kind":13,"line":687,"containerName":"next_result","name":"@line"},{"line":687,"kind":13,"containerName":"next_result","name":"@line"},{"name":"$descline","containerName":"next_result","line":688,"kind":13},{"line":689,"kind":13,"containerName":"next_result","name":"$self"},{"line":689,"kind":12,"containerName":"next_result","name":"element"},{"kind":13,"line":696,"containerName":"next_result","name":"$self"},{"name":"_pushback","containerName":"next_result","line":696,"kind":12},{"line":696,"kind":13,"name":"$descline","containerName":"next_result"},{"name":"$self","containerName":"next_result","line":705,"kind":13},{"name":"debug","containerName":"next_result","kind":12,"line":705},{"name":"$self","containerName":"next_result","line":706,"kind":13},{"line":706,"kind":12,"name":"_readline","containerName":"next_result"},{"name":"$flavor","containerName":"next_result","kind":13,"line":707},{"kind":13,"line":709,"containerName":"next_result","name":"$self"},{"name":"in_element","containerName":"next_result","line":709,"kind":12},{"containerName":"next_result","name":"$self","kind":13,"line":710},{"line":710,"kind":12,"name":"start_element","containerName":"next_result"},{"containerName":"next_result","name":"$self","kind":13,"line":713},{"line":713,"kind":12,"name":"_readline","containerName":"next_result"},{"kind":13,"line":716,"definition":"my","name":"@line","containerName":"next_result","localvar":"my"},{"kind":13,"line":717,"containerName":"next_result","name":"@line"},{"line":721,"kind":13,"name":"@hit_signifs","containerName":"next_result"},{"line":722,"kind":13,"name":"@line","containerName":"next_result"},{"name":"@line","containerName":"next_result","kind":13,"line":722},{"line":722,"kind":13,"containerName":"next_result","name":"@line"},{"name":"@line","containerName":"next_result","line":722,"kind":13},{"kind":13,"line":728,"name":"$self","containerName":"next_result"},{"name":"debug","containerName":"next_result","kind":12,"line":728},{"kind":13,"line":729,"definition":"my","name":"$db","containerName":"next_result","localvar":"my"},{"containerName":"next_result","name":"$self","line":730,"kind":13},{"containerName":"next_result","name":"_readline","line":730,"kind":12},{"localvar":"my","name":"$s","definition":"my","containerName":"next_result","line":737,"kind":13},{"name":"$l","containerName":"next_result","kind":13,"line":737},{"containerName":"next_result","name":"$s","kind":13,"line":738},{"name":"$l","containerName":"next_result","kind":13,"line":739},{"kind":13,"line":740,"containerName":"next_result","name":"$self"},{"kind":12,"line":740,"containerName":"next_result","name":"element"},{"name":"$s","containerName":"next_result","line":744,"kind":13},{"kind":13,"line":746,"name":"$self","containerName":"next_result"},{"kind":12,"line":746,"containerName":"next_result","name":"element"},{"kind":13,"line":750,"containerName":"next_result","name":"$l"},{"name":"$self","containerName":"next_result","line":753,"kind":13},{"name":"$db","containerName":"next_result","line":753,"kind":13},{"line":754,"kind":13,"containerName":"next_result","name":"$self"},{"kind":13,"line":754,"containerName":"next_result","name":"$s"},{"containerName":"next_result","name":"$self","line":755,"kind":13},{"kind":13,"line":755,"containerName":"next_result","name":"$l"},{"kind":13,"line":760,"containerName":"next_result","name":"$db"},{"name":"$self","containerName":"next_result","line":763,"kind":13},{"name":"element","containerName":"next_result","kind":12,"line":763},{"kind":13,"line":767,"name":"$db","containerName":"next_result"},{"line":773,"kind":13,"localvar":"my","definition":"my","name":"$featline","containerName":"next_result"},{"kind":13,"line":774,"name":"$self","containerName":"next_result"},{"name":"_readline","containerName":"next_result","kind":12,"line":774},{"kind":13,"line":777,"name":"$featline","containerName":"next_result"},{"name":"$self","containerName":"next_result","kind":13,"line":778},{"kind":12,"line":778,"containerName":"next_result","name":"_readline"},{"kind":13,"line":780,"name":"$self","containerName":"next_result"},{"containerName":"next_result","name":"_pushback","kind":12,"line":780},{"containerName":"next_result","name":"$featline","line":781,"kind":13},{"name":"$featline","containerName":"next_result","kind":13,"line":782},{"containerName":"next_result","name":"$self","line":783,"kind":13},{"name":"$featline","containerName":"next_result","line":783,"kind":13},{"kind":13,"line":790,"containerName":"next_result","name":"$self"},{"name":"debug","containerName":"next_result","line":790,"kind":12},{"containerName":"next_result","name":"$self","kind":13,"line":791},{"line":791,"kind":12,"containerName":"next_result","name":"in_element"},{"name":"$self","containerName":"next_result","kind":13,"line":792},{"kind":12,"line":792,"containerName":"next_result","name":"end_element"},{"containerName":"next_result","name":"$self","line":793,"kind":13},{"name":"in_element","containerName":"next_result","kind":12,"line":793},{"name":"$self","containerName":"next_result","kind":13,"line":794},{"containerName":"next_result","name":"end_element","line":794,"kind":12},{"line":798,"kind":13,"name":"$self","containerName":"next_result"},{"kind":12,"line":798,"name":"within_element","containerName":"next_result"},{"name":"$self","containerName":"next_result","kind":13,"line":799},{"name":"_start_blastoutput","containerName":"next_result","kind":12,"line":799},{"kind":13,"line":800,"name":"$self","containerName":"next_result"},{"line":800,"kind":12,"containerName":"next_result","name":"start_element"},{"line":802,"kind":13,"name":"$self","containerName":"next_result"},{"kind":12,"line":802,"containerName":"next_result","name":"within_element"},{"containerName":"next_result","name":"$self","line":803,"kind":13},{"kind":12,"line":803,"name":"start_element","containerName":"next_result"},{"containerName":"next_result","name":"$self","line":805,"kind":13},{"line":805,"kind":12,"name":"start_element","containerName":"next_result"},{"kind":13,"line":806,"containerName":"next_result","definition":"my","name":"$id","localvar":"my"},{"localvar":"my","definition":"my","name":"$restofline","containerName":"next_result","line":807,"kind":13},{"line":809,"kind":13,"containerName":"next_result","name":"$self"},{"kind":12,"line":809,"containerName":"next_result","name":"debug"},{"line":810,"kind":13,"name":"$self","containerName":"next_result"},{"name":"element","containerName":"next_result","kind":12,"line":810},{"name":"$id","containerName":"next_result","line":814,"kind":13},{"kind":13,"line":816,"containerName":"next_result","name":"$gi","definition":"my","localvar":"my"},{"containerName":"next_result","name":"$acc","line":816,"kind":13},{"kind":13,"line":816,"name":"$version","containerName":"next_result"},{"name":"$self","containerName":"next_result","line":816,"kind":13},{"kind":12,"line":816,"name":"_get_seq_identifiers","containerName":"next_result"},{"kind":13,"line":816,"containerName":"next_result","name":"$id"},{"line":817,"kind":13,"containerName":"next_result","name":"$self"},{"containerName":"next_result","name":"element","line":817,"kind":12},{"containerName":"next_result","name":"$acc","line":821,"kind":13},{"line":830,"kind":13,"localvar":"my","definition":"my","name":"$v","containerName":"next_result"},{"kind":13,"line":830,"containerName":"next_result","name":"@hit_signifs"},{"kind":13,"line":831,"definition":"my","name":"$tableid","containerName":"next_result","localvar":"my"},{"containerName":"next_result","name":"$v","line":831,"kind":13},{"containerName":"next_result","name":"$tableid","line":832,"kind":13},{"kind":13,"line":833,"containerName":"next_result","name":"$self"},{"kind":12,"line":833,"name":"debug","containerName":"next_result"},{"name":"$self","containerName":"next_result","kind":13,"line":839},{"containerName":"next_result","name":"_readline","kind":12,"line":839},{"localvar":"my","containerName":"next_result","definition":"my","name":"$l","line":843,"kind":13},{"name":"$l","containerName":"next_result","line":844,"kind":13},{"containerName":"next_result","name":"$self","line":845,"kind":13},{"kind":12,"line":845,"name":"element","containerName":"next_result"},{"line":849,"kind":13,"containerName":"next_result","name":"$l"},{"containerName":"next_result","name":"$restofline","kind":13,"line":855},{"line":858,"kind":13,"containerName":"next_result","name":"$restofline"},{"name":"$self","containerName":"next_result","line":859,"kind":13},{"line":859,"kind":12,"containerName":"next_result","name":"element"},{"kind":13,"line":863,"containerName":"next_result","name":"$restofline"},{"containerName":"next_result","name":"$self","kind":13,"line":870},{"kind":12,"line":870,"name":"in_element","containerName":"next_result"},{"name":"$self","containerName":"next_result","line":870,"kind":13},{"line":870,"kind":12,"name":"in_element","containerName":"next_result"},{"line":878,"kind":13,"containerName":"next_result","name":"$self"},{"kind":12,"line":878,"containerName":"next_result","name":"in_element"},{"line":879,"kind":13,"containerName":"next_result","name":"$self"},{"line":879,"kind":12,"name":"end_element","containerName":"next_result"},{"containerName":"next_result","name":"$self","line":880,"kind":13},{"kind":12,"line":880,"containerName":"next_result","name":"start_element"},{"name":"$self","containerName":"next_result","line":882,"kind":13},{"containerName":"next_result","name":"debug","kind":12,"line":882},{"line":885,"kind":13,"localvar":"my","containerName":"next_result","name":"$bits","definition":"my"},{"name":"$score","containerName":"next_result","line":885,"kind":13},{"line":885,"kind":13,"name":"$evalue","containerName":"next_result"},{"containerName":"next_result","name":"$evalue","kind":13,"line":886},{"name":"$self","containerName":"next_result","kind":13,"line":887},{"line":887,"kind":12,"name":"element","containerName":"next_result"},{"line":891,"kind":13,"name":"$score","containerName":"next_result"},{"line":893,"kind":13,"name":"$self","containerName":"next_result"},{"containerName":"next_result","name":"element","kind":12,"line":893},{"kind":13,"line":897,"name":"$bits","containerName":"next_result"},{"kind":13,"line":899,"name":"$self","containerName":"next_result"},{"containerName":"next_result","name":"element","kind":12,"line":899},{"line":903,"kind":13,"name":"$evalue","containerName":"next_result"},{"name":"$self","containerName":"next_result","line":907,"kind":13},{"containerName":"next_result","name":"in_element","kind":12,"line":907},{"containerName":"next_result","name":"$self","line":907,"kind":13},{"name":"in_element","containerName":"next_result","kind":12,"line":907},{"kind":13,"line":915,"name":"$self","containerName":"next_result"},{"name":"in_element","containerName":"next_result","line":915,"kind":12},{"containerName":"next_result","name":"$self","kind":13,"line":916},{"line":916,"kind":12,"containerName":"next_result","name":"end_element"},{"containerName":"next_result","name":"$self","kind":13,"line":917},{"containerName":"next_result","name":"start_element","kind":12,"line":917},{"containerName":"next_result","name":"$self","kind":13,"line":919},{"line":919,"kind":12,"name":"debug","containerName":"next_result"},{"localvar":"my","definition":"my","name":"$score","containerName":"next_result","line":922,"kind":13},{"kind":13,"line":922,"containerName":"next_result","name":"$evalue"},{"name":"$pvalue","containerName":"next_result","kind":13,"line":922},{"containerName":"next_result","name":"$evalue","kind":13,"line":923},{"name":"$evalue","containerName":"next_result","line":923,"kind":13},{"line":924,"kind":13,"containerName":"next_result","name":"$pvalue"},{"containerName":"next_result","name":"$pvalue","kind":13,"line":924},{"kind":13,"line":926,"containerName":"next_result","name":"$self"},{"line":926,"kind":12,"name":"element","containerName":"next_result"},{"line":930,"kind":13,"containerName":"next_result","name":"$score"},{"kind":13,"line":932,"name":"$self","containerName":"next_result"},{"line":932,"kind":12,"containerName":"next_result","name":"element"},{"containerName":"next_result","name":"$evalue","kind":13,"line":936},{"containerName":"next_result","name":"$self","line":938,"kind":13},{"containerName":"next_result","name":"element","line":938,"kind":12},{"name":"$pvalue","containerName":"next_result","line":942,"kind":13},{"kind":13,"line":946,"containerName":"next_result","name":"$self"},{"containerName":"next_result","name":"in_element","kind":12,"line":946},{"kind":13,"line":946,"name":"$self","containerName":"next_result"},{"name":"in_element","containerName":"next_result","line":946,"kind":12},{"line":957,"kind":13,"containerName":"next_result","name":"$self"},{"name":"in_element","containerName":"next_result","line":957,"kind":12},{"containerName":"next_result","name":"$self","kind":13,"line":958},{"containerName":"next_result","name":"end_element","line":958,"kind":12},{"name":"$self","containerName":"next_result","line":959,"kind":13},{"name":"start_element","containerName":"next_result","kind":12,"line":959},{"line":962,"kind":13,"localvar":"my","containerName":"next_result","definition":"my","name":"$score"},{"line":962,"kind":13,"containerName":"next_result","name":"$bits"},{"containerName":"next_result","name":"$evalue","line":962,"kind":13},{"line":962,"kind":13,"name":"$pvalue","containerName":"next_result"},{"containerName":"next_result","name":"$group","kind":13,"line":962},{"line":964,"kind":13,"name":"$evalue","containerName":"next_result"},{"containerName":"next_result","name":"$pvalue","line":965,"kind":13},{"containerName":"next_result","name":"$self","kind":13,"line":967},{"containerName":"next_result","name":"element","line":967,"kind":12},{"line":971,"kind":13,"name":"$score","containerName":"next_result"},{"containerName":"next_result","name":"$self","line":973,"kind":13},{"line":973,"kind":12,"name":"element","containerName":"next_result"},{"containerName":"next_result","name":"$bits","line":977,"kind":13},{"name":"$self","containerName":"next_result","line":979,"kind":13},{"containerName":"next_result","name":"element","line":979,"kind":12},{"name":"$evalue","containerName":"next_result","line":983,"kind":13},{"containerName":"next_result","name":"$self","line":985,"kind":13},{"line":985,"kind":12,"containerName":"next_result","name":"element"},{"line":989,"kind":13,"name":"$pvalue","containerName":"next_result"},{"containerName":"next_result","name":"$group","line":992,"kind":13},{"containerName":"next_result","name":"$self","line":993,"kind":13},{"containerName":"next_result","name":"element","line":993,"kind":12},{"containerName":"next_result","name":"$group","line":997,"kind":13},{"containerName":"next_result","name":"$self","kind":13,"line":1003},{"name":"in_element","containerName":"next_result","line":1003,"kind":12},{"name":"$self","containerName":"next_result","kind":13,"line":1003},{"line":1003,"kind":12,"name":"in_element","containerName":"next_result"},{"name":"$self","containerName":"next_result","kind":13,"line":1011},{"line":1011,"kind":12,"name":"in_element","containerName":"next_result"},{"name":"$self","containerName":"next_result","kind":13,"line":1012},{"name":"end_element","containerName":"next_result","line":1012,"kind":12},{"localvar":"my","containerName":"next_result","definition":"my","name":"$bits","line":1015,"kind":13},{"kind":13,"line":1015,"containerName":"next_result","name":"$score"},{"line":1015,"kind":13,"name":"$n","containerName":"next_result"},{"containerName":"next_result","name":"$evalue","line":1015,"kind":13},{"name":"$evalue","containerName":"next_result","kind":13,"line":1016},{"name":"$self","containerName":"next_result","kind":13,"line":1017},{"name":"start_element","containerName":"next_result","line":1017,"kind":12},{"containerName":"next_result","name":"$self","line":1018,"kind":13},{"containerName":"next_result","name":"element","line":1018,"kind":12},{"kind":13,"line":1022,"name":"$score","containerName":"next_result"},{"containerName":"next_result","name":"$self","kind":13,"line":1024},{"kind":12,"line":1024,"containerName":"next_result","name":"element"},{"name":"$bits","containerName":"next_result","kind":13,"line":1028},{"containerName":"next_result","name":"$self","line":1030,"kind":13},{"line":1030,"kind":12,"containerName":"next_result","name":"element"},{"name":"$evalue","containerName":"next_result","kind":13,"line":1034},{"name":"$self","containerName":"next_result","line":1036,"kind":13},{"line":1036,"kind":12,"containerName":"next_result","name":"element"},{"line":1040,"kind":13,"name":"$n","containerName":"next_result"},{"line":1041,"kind":13,"name":"$n","containerName":"next_result"},{"kind":13,"line":1042,"containerName":"next_result","name":"$score"},{"line":1042,"kind":13,"name":"$score","containerName":"next_result"},{"name":"$self","containerName":"next_result","line":1044,"kind":13},{"containerName":"next_result","name":"debug","line":1044,"kind":12},{"name":"$self","containerName":"next_result","kind":13,"line":1047},{"kind":12,"line":1047,"containerName":"next_result","name":"in_element"},{"kind":13,"line":1054,"containerName":"next_result","name":"$self"},{"kind":12,"line":1054,"name":"element","containerName":"next_result"},{"kind":13,"line":1060,"name":"$self","containerName":"next_result"},{"containerName":"next_result","name":"element","kind":12,"line":1060},{"kind":13,"line":1067,"containerName":"next_result","name":"$self"},{"kind":12,"line":1067,"name":"element","containerName":"next_result"},{"kind":13,"line":1075,"containerName":"next_result","name":"$self"},{"kind":12,"line":1075,"name":"element","containerName":"next_result"},{"name":"$self","containerName":"next_result","line":1083,"kind":13},{"line":1083,"kind":12,"name":"element","containerName":"next_result"},{"containerName":"next_result","name":"$self","line":1091,"kind":13},{"containerName":"next_result","name":"$self","kind":13,"line":1092},{"name":"$self","containerName":"next_result","kind":13,"line":1097},{"kind":12,"line":1097,"name":"_pushback","containerName":"next_result"},{"kind":13,"line":1100,"containerName":"next_result","name":"$self"},{"name":"in_element","containerName":"next_result","kind":12,"line":1100},{"line":1105,"kind":13,"name":"$reporttype","containerName":"next_result"},{"name":"$self","containerName":"next_result","kind":13,"line":1106},{"name":"$reporttype","containerName":"next_result","kind":13,"line":1106},{"line":1107,"kind":13,"name":"$bl2seq_fix","containerName":"next_result"},{"line":1112,"kind":13,"containerName":"next_result","name":"$self"},{"name":"in_element","containerName":"next_result","line":1112,"kind":12},{"containerName":"next_result","name":"$self","line":1115,"kind":13},{"name":"element","containerName":"next_result","kind":12,"line":1115},{"name":"$self","containerName":"next_result","line":1122,"kind":13},{"containerName":"next_result","name":"in_element","line":1122,"kind":12},{"line":1127,"kind":13,"name":"$reporttype","containerName":"next_result"},{"kind":13,"line":1128,"containerName":"next_result","name":"$bl2seq_fix"},{"kind":13,"line":1129,"name":"$reporttype","containerName":"next_result"},{"line":1131,"kind":13,"containerName":"next_result","name":"$reporttype"},{"name":"$self","containerName":"next_result","kind":13,"line":1135},{"containerName":"next_result","name":"$reporttype","line":1135,"kind":13},{"localvar":"my","definition":"my","name":"$queryframe","containerName":"next_result","line":1138,"kind":13},{"containerName":"next_result","name":"$hitframe","kind":13,"line":1138},{"name":"$reporttype","containerName":"next_result","line":1139,"kind":13},{"kind":13,"line":1140,"containerName":"next_result","name":"$queryframe"},{"containerName":"next_result","name":"$hitframe","line":1140,"kind":13},{"containerName":"next_result","name":"$hitframe","kind":13,"line":1141},{"name":"$reporttype","containerName":"next_result","line":1143,"kind":13},{"kind":13,"line":1143,"containerName":"next_result","name":"$reporttype"},{"containerName":"next_result","name":"$hitframe","line":1144,"kind":13},{"line":1144,"kind":13,"name":"$queryframe","containerName":"next_result"},{"containerName":"next_result","name":"$reporttype","line":1146,"kind":13},{"line":1146,"kind":13,"containerName":"next_result","name":"$reporttype"},{"containerName":"next_result","name":"$queryframe","line":1147,"kind":13},{"line":1147,"kind":13,"name":"$hitframe","containerName":"next_result"},{"name":"$reporttype","containerName":"next_result","line":1150,"kind":13},{"kind":13,"line":1151,"name":"$self","containerName":"next_result"},{"kind":12,"line":1151,"containerName":"next_result","name":"element"},{"line":1159,"kind":13,"name":"$self","containerName":"next_result"},{"line":1159,"kind":12,"name":"element","containerName":"next_result"},{"line":1163,"kind":13,"containerName":"next_result","name":"$queryframe"},{"containerName":"next_result","name":"$self","line":1166,"kind":13},{"line":1166,"kind":12,"containerName":"next_result","name":"element"},{"kind":13,"line":1170,"containerName":"next_result","name":"$hitframe"},{"kind":13,"line":1178,"name":"$self","containerName":"next_result"},{"containerName":"next_result","name":"in_element","line":1178,"kind":12},{"line":1183,"kind":13,"containerName":"next_result","name":"$self"},{"name":"debug","containerName":"next_result","kind":12,"line":1183},{"containerName":"next_result","name":"$self","line":1185,"kind":13},{"line":1185,"kind":12,"name":"in_element","containerName":"next_result"},{"name":"$self","containerName":"next_result","kind":13,"line":1186},{"name":"end_element","containerName":"next_result","kind":12,"line":1186},{"containerName":"next_result","name":"$self","kind":13,"line":1187},{"containerName":"next_result","name":"in_element","kind":12,"line":1187},{"containerName":"next_result","name":"$self","kind":13,"line":1188},{"line":1188,"kind":12,"containerName":"next_result","name":"end_element"},{"line":1192,"kind":13,"name":"$self","containerName":"next_result"},{"name":"_cleanup_hits","containerName":"next_result","kind":12,"line":1192},{"containerName":"next_result","name":"@hit_signifs","kind":13,"line":1192},{"containerName":"next_result","name":"@hit_signifs","kind":13,"line":1192},{"name":"$self","containerName":"next_result","kind":13,"line":1193},{"line":1193,"kind":12,"name":"within_element","containerName":"next_result"},{"kind":13,"line":1194,"containerName":"next_result","name":"$self"},{"line":1194,"kind":12,"containerName":"next_result","name":"end_element"},{"line":1197,"kind":13,"localvar":"my","containerName":"next_result","definition":"my","name":"$blast"},{"containerName":"next_result","name":"$blast","kind":13,"line":1199},{"localvar":"my","containerName":"next_result","name":"$last","definition":"my","line":1202,"kind":13},{"line":1205,"kind":13,"containerName":"next_result","name":"$self"},{"containerName":"next_result","name":"element","line":1205,"kind":12},{"line":1211,"kind":13,"name":"$self","containerName":"next_result"},{"kind":12,"line":1211,"containerName":"next_result","name":"_readline"},{"kind":13,"line":1218,"name":"$self","containerName":"next_result"},{"containerName":"next_result","name":"_pushback","line":1218,"kind":12},{"name":"$self","containerName":"next_result","kind":13,"line":1224},{"name":"_pushback","containerName":"next_result","line":1224,"kind":12},{"kind":13,"line":1224,"containerName":"next_result","name":"$reportline"},{"containerName":"next_result","name":"$reportline","line":1224,"kind":13},{"name":"$self","containerName":"next_result","line":1225,"kind":13},{"kind":12,"line":1225,"name":"_pushback","containerName":"next_result"},{"kind":13,"line":1234,"containerName":"next_result","definition":"my","name":"$c","localvar":"my"},{"kind":13,"line":1235,"name":"$c","containerName":"next_result"},{"containerName":"next_result","name":"$self","kind":13,"line":1236},{"name":"element","containerName":"next_result","line":1236,"kind":12},{"line":1240,"kind":13,"containerName":"next_result","name":"$c"},{"containerName":"next_result","name":"$s","definition":"my","localvar":"my","kind":13,"line":1244},{"containerName":"next_result","name":"$s","kind":13,"line":1245},{"kind":13,"line":1246,"name":"$self","containerName":"next_result"},{"kind":12,"line":1246,"name":"element","containerName":"next_result"},{"kind":13,"line":1250,"containerName":"next_result","name":"$s"},{"kind":13,"line":1253,"containerName":"next_result","name":"$blast"},{"line":1256,"kind":13,"containerName":"next_result","name":"$blast"},{"kind":13,"line":1260,"name":"$self","containerName":"next_result"},{"name":"element","containerName":"next_result","line":1260,"kind":12},{"containerName":"next_result","name":"$self","line":1268,"kind":13},{"name":"element","containerName":"next_result","line":1268,"kind":12},{"kind":13,"line":1276,"name":"$self","containerName":"next_result"},{"kind":12,"line":1276,"name":"element","containerName":"next_result"},{"name":"$self","containerName":"next_result","kind":13,"line":1287},{"line":1287,"kind":12,"containerName":"next_result","name":"element"},{"containerName":"next_result","name":"$self","kind":13,"line":1295},{"containerName":"next_result","name":"element","kind":12,"line":1295},{"kind":13,"line":1302,"name":"$last","containerName":"next_result"},{"localvar":"my","name":"$firstgapinfo","definition":"my","containerName":"next_result","line":1303,"kind":13},{"containerName":"next_result","definition":"my","name":"$frame","localvar":"my","kind":13,"line":1304},{"containerName":"next_result","name":"$firstgapinfo","line":1309,"kind":13},{"kind":13,"line":1311,"name":"$firstgapinfo","containerName":"next_result"},{"kind":13,"line":1313,"name":"$self","containerName":"next_result"},{"name":"element","containerName":"next_result","line":1313,"kind":12},{"name":"$self","containerName":"next_result","kind":13,"line":1319},{"name":"element","containerName":"next_result","kind":12,"line":1319},{"line":1325,"kind":13,"localvar":"my","name":"@fields","definition":"my","containerName":"next_result"},{"definition":"my","name":"$type","containerName":"next_result","localvar":"my","kind":13,"line":1327},{"containerName":"next_result","name":"$type","line":1333,"kind":13},{"name":"@fields","containerName":"next_result","kind":13,"line":1334},{"name":"$self","containerName":"next_result","kind":13,"line":1338},{"line":1338,"kind":12,"containerName":"next_result","name":"element"},{"kind":13,"line":1343,"name":"@fields","containerName":"next_result"},{"line":1348,"kind":13,"localvar":"my","name":"$frameo","definition":"my","containerName":"next_result"},{"name":"$matid","containerName":"next_result","kind":13,"line":1348},{"kind":13,"line":1348,"containerName":"next_result","name":"$matrix"},{"kind":13,"line":1348,"containerName":"next_result","name":"@fields"},{"name":"$frame","containerName":"next_result","kind":13,"line":1350},{"containerName":"next_result","name":"$self","kind":13,"line":1354},{"kind":12,"line":1354,"containerName":"next_result","name":"element"},{"name":"$matrix","containerName":"next_result","kind":13,"line":1358},{"containerName":"next_result","name":"$self","kind":13,"line":1360},{"kind":12,"line":1360,"name":"element","containerName":"next_result"},{"name":"$fields","containerName":"next_result","line":1363,"kind":13},{"containerName":"next_result","name":"$self","kind":13,"line":1366},{"line":1366,"kind":12,"containerName":"next_result","name":"element"},{"containerName":"next_result","name":"$fields","kind":13,"line":1369},{"containerName":"next_result","name":"$self","kind":13,"line":1372},{"kind":12,"line":1372,"containerName":"next_result","name":"element"},{"kind":13,"line":1375,"containerName":"next_result","name":"$fields"},{"name":"$frame","containerName":"next_result","kind":13,"line":1379},{"name":"$frameo","containerName":"next_result","line":1379,"kind":13},{"localvar":"my","containerName":"next_result","definition":"my","name":"$ii","line":1380,"kind":13},{"localvar":"my","name":"$type","definition":"my","containerName":"next_result","line":1381,"kind":13},{"name":"$f","definition":"my","containerName":"next_result","localvar":"my","kind":13,"line":1390},{"containerName":"next_result","name":"$fields","kind":13,"line":1390},{"containerName":"next_result","name":"$ii","line":1390,"kind":13},{"line":1391,"kind":13,"name":"$f","containerName":"next_result"},{"name":"$f","containerName":"next_result","line":1392,"kind":13},{"name":"$f","containerName":"next_result","line":1393,"kind":13},{"line":1393,"kind":13,"name":"$fields","containerName":"next_result"},{"name":"$ii","containerName":"next_result","line":1393,"kind":13},{"containerName":"next_result","name":"$ii","line":1395,"kind":13},{"kind":13,"line":1396,"name":"$self","containerName":"next_result"},{"line":1396,"kind":12,"name":"element","containerName":"next_result"},{"line":1401,"kind":13,"containerName":"next_result","name":"$f"},{"containerName":"next_result","name":"$self","kind":13,"line":1408},{"name":"_readline","containerName":"next_result","kind":12,"line":1408},{"containerName":"next_result","name":"$last","kind":13,"line":1410},{"kind":13,"line":1412,"name":"$last","containerName":"next_result"},{"localvar":"my","containerName":"next_result","name":"$frame","definition":"my","line":1413,"kind":13},{"line":1417,"kind":13,"localvar":"my","containerName":"next_result","name":"@fields","definition":"my"},{"containerName":"next_result","name":"@fields","kind":13,"line":1418},{"containerName":"next_result","definition":"my","name":"$type","localvar":"my","kind":13,"line":1419},{"line":1420,"kind":13,"containerName":"next_result","name":"@fields"},{"containerName":"next_result","name":"$self","kind":13,"line":1421},{"name":"element","containerName":"next_result","line":1421,"kind":12},{"name":"@fields","containerName":"next_result","kind":13,"line":1426},{"line":1432,"kind":13,"localvar":"my","name":"$type","definition":"my","containerName":"next_result"},{"name":"$self","containerName":"next_result","kind":13,"line":1438},{"line":1438,"kind":12,"containerName":"next_result","name":"element"},{"kind":13,"line":1443,"containerName":"next_result","name":"@fields"},{"kind":13,"line":1447,"containerName":"next_result","name":"$self"},{"containerName":"next_result","name":"_readline","kind":12,"line":1447},{"name":"$last","containerName":"next_result","line":1449,"kind":13},{"line":1453,"kind":13,"containerName":"next_result","name":"$self"},{"name":"element","containerName":"next_result","line":1453,"kind":12},{"kind":13,"line":1461,"name":"$self","containerName":"next_result"},{"name":"element","containerName":"next_result","line":1461,"kind":12},{"line":1474,"kind":13,"name":"$self","containerName":"next_result"},{"kind":12,"line":1474,"name":"element","containerName":"next_result"},{"line":1482,"kind":13,"name":"$self","containerName":"next_result"},{"line":1482,"kind":12,"containerName":"next_result","name":"element"},{"localvar":"my","containerName":"next_result","name":"$cputype","definition":"my","line":1495,"kind":13},{"containerName":"next_result","name":"$self","kind":13,"line":1496},{"kind":12,"line":1496,"containerName":"next_result","name":"element"},{"name":"$self","containerName":"next_result","kind":13,"line":1502},{"containerName":"next_result","name":"element","kind":12,"line":1502},{"kind":13,"line":1510,"name":"$junk","definition":"my","containerName":"next_result","localvar":"my"},{"containerName":"next_result","name":"$start","line":1510,"kind":13},{"containerName":"next_result","name":"$stime","line":1510,"kind":13},{"line":1510,"kind":13,"containerName":"next_result","name":"$end"},{"name":"$etime","containerName":"next_result","kind":13,"line":1510},{"line":1512,"kind":13,"name":"$stime","containerName":"next_result"},{"name":"$self","containerName":"next_result","line":1513,"kind":13},{"line":1513,"kind":12,"name":"element","containerName":"next_result"},{"kind":13,"line":1517,"containerName":"next_result","name":"$stime"},{"kind":13,"line":1519,"containerName":"next_result","name":"$etime"},{"containerName":"next_result","name":"$self","line":1520,"kind":13},{"line":1520,"kind":12,"name":"element","containerName":"next_result"},{"kind":13,"line":1524,"name":"$etime","containerName":"next_result"},{"name":"$self","containerName":"next_result","line":1528,"kind":13},{"line":1528,"kind":12,"name":"element","containerName":"next_result"},{"containerName":"next_result","definition":"my","name":"$d","localvar":"my","kind":13,"line":1537},{"containerName":"next_result","name":"$d","kind":13,"line":1538},{"containerName":"next_result","name":"$self","kind":13,"line":1539},{"name":"element","containerName":"next_result","line":1539,"kind":12},{"containerName":"next_result","name":"$d","line":1543,"kind":13},{"kind":13,"line":1547,"name":"$blast","containerName":"next_result"},{"name":"$self","containerName":"next_result","line":1550,"kind":13},{"containerName":"next_result","name":"element","line":1550,"kind":12},{"kind":13,"line":1558,"containerName":"next_result","name":"$gapped_stats"},{"containerName":"next_result","name":"$self","line":1561,"kind":13},{"containerName":"next_result","name":"_readline","line":1561,"kind":12},{"kind":13,"line":1563,"name":"$lambda","definition":"my","containerName":"next_result","localvar":"my"},{"line":1563,"kind":13,"name":"$kappa","containerName":"next_result"},{"containerName":"next_result","name":"$entropy","line":1563,"kind":13},{"kind":13,"line":1564,"containerName":"next_result","name":"$gapped_stats"},{"line":1565,"kind":13,"name":"$self","containerName":"next_result"},{"name":"element","containerName":"next_result","line":1565,"kind":12},{"name":"$lambda","containerName":"next_result","kind":13,"line":1569},{"containerName":"next_result","name":"$self","line":1571,"kind":13},{"line":1571,"kind":12,"containerName":"next_result","name":"element"},{"line":1575,"kind":13,"containerName":"next_result","name":"$kappa"},{"kind":13,"line":1577,"containerName":"next_result","name":"$self"},{"line":1577,"kind":12,"containerName":"next_result","name":"element"},{"kind":13,"line":1581,"containerName":"next_result","name":"$entropy"},{"kind":13,"line":1585,"name":"$self","containerName":"next_result"},{"kind":12,"line":1585,"name":"element","containerName":"next_result"},{"name":"$lambda","containerName":"next_result","line":1589,"kind":13},{"containerName":"next_result","name":"$self","line":1591,"kind":13},{"name":"element","containerName":"next_result","line":1591,"kind":12},{"line":1595,"kind":13,"containerName":"next_result","name":"$kappa"},{"name":"$self","containerName":"next_result","kind":13,"line":1597},{"name":"element","containerName":"next_result","kind":12,"line":1597},{"kind":13,"line":1601,"containerName":"next_result","name":"$entropy"},{"containerName":"next_result","name":"$self","kind":13,"line":1606},{"name":"element","containerName":"next_result","kind":12,"line":1606},{"kind":13,"line":1614,"name":"$self","containerName":"next_result"},{"kind":12,"line":1614,"name":"element","containerName":"next_result"},{"containerName":"next_result","name":"$self","kind":13,"line":1626},{"name":"element","containerName":"next_result","kind":12,"line":1626},{"kind":13,"line":1632,"name":"$self","containerName":"next_result"},{"kind":12,"line":1632,"containerName":"next_result","name":"element"},{"name":"$self","containerName":"next_result","kind":13,"line":1640},{"name":"element","containerName":"next_result","line":1640,"kind":12},{"kind":13,"line":1648,"definition":"my","name":"$c","containerName":"next_result","localvar":"my"},{"name":"$c","containerName":"next_result","line":1649,"kind":13},{"line":1650,"kind":13,"name":"$self","containerName":"next_result"},{"kind":12,"line":1650,"containerName":"next_result","name":"element"},{"kind":13,"line":1654,"containerName":"next_result","name":"$c"},{"line":1658,"kind":13,"localvar":"my","containerName":"next_result","definition":"my","name":"$c"},{"line":1659,"kind":13,"containerName":"next_result","name":"$c"},{"line":1660,"kind":13,"name":"$self","containerName":"next_result"},{"name":"element","containerName":"next_result","line":1660,"kind":12},{"line":1664,"kind":13,"containerName":"next_result","name":"$c"},{"containerName":"next_result","name":"$v","definition":"my","localvar":"my","kind":13,"line":1671},{"containerName":"next_result","name":"$v","line":1672,"kind":13},{"line":1673,"kind":13,"containerName":"next_result","name":"$self"},{"name":"element","containerName":"next_result","kind":12,"line":1673},{"kind":13,"line":1677,"name":"$v","containerName":"next_result"},{"line":1680,"kind":13,"containerName":"next_result","name":"$self"},{"name":"element","containerName":"next_result","line":1680,"kind":12},{"containerName":"next_result","name":"$self","kind":13,"line":1693},{"kind":12,"line":1693,"name":"element","containerName":"next_result"},{"line":1699,"kind":13,"containerName":"next_result","name":"$self"},{"line":1699,"kind":12,"containerName":"next_result","name":"element"},{"containerName":"next_result","name":"$self","kind":13,"line":1707},{"containerName":"next_result","name":"element","kind":12,"line":1707},{"name":"$self","containerName":"next_result","kind":13,"line":1715},{"name":"element","containerName":"next_result","kind":12,"line":1715},{"line":1727,"kind":13,"name":"$self","containerName":"next_result"},{"kind":12,"line":1727,"name":"element","containerName":"next_result"},{"kind":13,"line":1739,"containerName":"next_result","name":"$self"},{"kind":12,"line":1739,"containerName":"next_result","name":"element"},{"name":"$self","containerName":"next_result","kind":13,"line":1745},{"kind":12,"line":1745,"containerName":"next_result","name":"element"},{"kind":13,"line":1753,"containerName":"next_result","name":"$d","definition":"my","localvar":"my"},{"kind":13,"line":1754,"containerName":"next_result","name":"$d"},{"kind":13,"line":1755,"name":"$self","containerName":"next_result"},{"line":1755,"kind":12,"containerName":"next_result","name":"element"},{"kind":13,"line":1759,"name":"$d","containerName":"next_result"},{"containerName":"next_result","name":"$last","kind":13,"line":1766},{"line":1768,"kind":13,"name":"$self","containerName":"next_result"},{"name":"in_element","containerName":"next_result","kind":12,"line":1768},{"line":1769,"kind":13,"name":"$self","containerName":"next_result"},{"kind":12,"line":1769,"name":"debug","containerName":"next_result"},{"name":"$self","containerName":"next_result","kind":13,"line":1772},{"kind":13,"line":1772,"name":"$DEFAULTREPORTTYPE","containerName":"next_result"},{"localvar":"my","name":"%data","definition":"my","containerName":"next_result","line":1773,"kind":13},{"name":"$len","definition":"my","containerName":"next_result","localvar":"my","kind":13,"line":1778},{"localvar":"my","definition":"my","name":"$i","containerName":"next_result","line":1779,"kind":13},{"kind":13,"line":1779,"name":"$i","containerName":"next_result"},{"line":1779,"kind":13,"containerName":"next_result","name":"$i"},{"name":"$i","containerName":"next_result","kind":13,"line":1781},{"line":1784,"kind":13,"name":"$self","containerName":"next_result"},{"containerName":"next_result","name":"_pushback","kind":12,"line":1784},{"line":1785,"kind":13,"name":"$self","containerName":"next_result"},{"name":"end_element","containerName":"next_result","line":1785,"kind":12},{"definition":"my","name":"$full","containerName":"next_result","localvar":"my","kind":13,"line":1790},{"name":"$type","containerName":"next_result","kind":13,"line":1790},{"line":1790,"kind":13,"containerName":"next_result","name":"$start"},{"containerName":"next_result","name":"$str","kind":13,"line":1790},{"name":"$end","containerName":"next_result","kind":13,"line":1790},{"line":1793,"kind":13,"containerName":"next_result","name":"$str"},{"kind":13,"line":1794,"containerName":"next_result","name":"$i"},{"line":1794,"kind":13,"name":"$type","containerName":"next_result"},{"line":1797,"kind":13,"containerName":"next_result","name":"$data"},{"name":"$type","containerName":"next_result","kind":13,"line":1797},{"name":"$str","containerName":"next_result","line":1797,"kind":13},{"line":1799,"kind":13,"containerName":"next_result","name":"$len"},{"kind":13,"line":1799,"containerName":"next_result","name":"$full"},{"name":"$self","containerName":"next_result","line":1800,"kind":13},{"line":1801,"kind":13,"containerName":"next_result","name":"$start"},{"kind":13,"line":1801,"name":"$self","containerName":"next_result"},{"containerName":"next_result","name":"$self","kind":13,"line":1802},{"kind":13,"line":1802,"name":"$end","containerName":"next_result"},{"line":1804,"kind":13,"name":"$self","containerName":"next_result"},{"kind":12,"line":1804,"containerName":"next_result","name":"throw"},{"name":"$len","containerName":"next_result","line":1805,"kind":13},{"kind":13,"line":1806,"name":"$data","containerName":"next_result"},{"kind":13,"line":1806,"containerName":"next_result","name":"$len"},{"containerName":"next_result","name":"$self","line":1808,"kind":13},{"line":1808,"kind":12,"containerName":"next_result","name":"_readline"},{"kind":13,"line":1810,"containerName":"next_result","name":"$self"},{"kind":12,"line":1810,"name":"characters","containerName":"next_result"},{"name":"$data","containerName":"next_result","kind":13,"line":1813},{"kind":13,"line":1816,"name":"$self","containerName":"next_result"},{"name":"characters","containerName":"next_result","kind":12,"line":1816},{"containerName":"next_result","name":"$data","line":1819,"kind":13},{"line":1822,"kind":13,"containerName":"next_result","name":"$self"},{"line":1822,"kind":12,"containerName":"next_result","name":"characters"},{"name":"$data","containerName":"next_result","line":1825,"kind":13},{"containerName":"next_result","name":"$self","kind":13,"line":1834},{"containerName":"next_result","name":"debug","line":1834,"kind":12},{"containerName":"next_result","name":"$self","line":1835,"kind":13},{"line":1836,"kind":13,"containerName":"next_result","name":"$self"},{"containerName":"next_result","name":"within_element","line":1836,"kind":12},{"name":"$self","containerName":"next_result","line":1837,"kind":13},{"line":1837,"kind":12,"name":"end_element","containerName":"next_result"},{"name":"$self","containerName":"next_result","line":1838,"kind":13},{"containerName":"next_result","name":"within_element","line":1838,"kind":12},{"name":"$self","containerName":"next_result","line":1839,"kind":13},{"name":"end_element","containerName":"next_result","line":1839,"kind":12},{"kind":13,"line":1841,"containerName":"next_result","name":"$self"},{"kind":12,"line":1841,"name":"_cleanup_hits","containerName":"next_result"},{"containerName":"next_result","name":"@hit_signifs","kind":13,"line":1841},{"name":"@hit_signifs","containerName":"next_result","kind":13,"line":1841},{"line":1842,"kind":13,"name":"$self","containerName":"next_result"},{"line":1842,"kind":12,"name":"within_element","containerName":"next_result"},{"containerName":"next_result","name":"$self","kind":13,"line":1843},{"containerName":"next_result","name":"end_element","line":1843,"kind":12},{"name":"$bl2seq_fix","containerName":"next_result","line":1844,"kind":13},{"containerName":"next_result","name":"$self","line":1845,"kind":13},{"containerName":"next_result","name":"element","line":1845,"kind":12},{"name":"$reporttype","containerName":"next_result","kind":13,"line":1849},{"containerName":"next_result","name":"$self","line":1852,"kind":13},{"name":"end_element","containerName":"next_result","kind":12,"line":1852},{"line":1854,"kind":13,"containerName":"next_result","name":"$self"},{"kind":12,"line":1854,"name":"end_document","containerName":"next_result"}],"containerName":"main::","definition":"sub","detail":"($self)","signature":{"label":"next_result($self)","parameters":[{"label":"$self"}],"documentation":"(Sesame Street aficionados note: This answer was NOT given by Mr. Noodle ;-P)\n# $Id: blast.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::blast\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n# 20030409 - sac\n#          PSI-BLAST full parsing support. Rollout of new\n#          model which will remove Steve's old psiblast driver\n# 20030424 - jason\n#          Megablast parsing fix as reported by Neil Saunders\n# 20030427 - jason\n#          Support bl2seq parsing\n# 20031124 - jason\n#          Parse more blast statistics, lambda, entropy, etc\n#          from WU-BLAST in frame-specific manner\n# 20060216 - cjf - fixed blast parsing for BLAST v2.2.13 output\n# 20071104 - dmessina - added support for WUBLAST -echofilter\n# 20071121 - cjf - fixed several bugs (bugs 2391, 2399, 2409)\n\n=head1 NAME\n\nBio::SearchIO::blast - Event generator for event based parsing of\nblast reports\n\n=head1 SYNOPSIS\n\n   # Do not use this object directly - it is used as part of the\n   # Bio::SearchIO system.\n\n    use Bio::SearchIO;\n    my $searchio = Bio::SearchIO->new(-format => 'blast',\n                                     -file   => 't/data/ecolitst.bls');\n    while( my $result = $searchio->next_result ) {\n        while( my $hit = $result->next_hit ) {\n            while( my $hsp = $hit->next_hsp ) {\n                # ...\n            }\n        }\n    }\n\n=head1 DESCRIPTION\n\nThis object encapsulated the necessary methods for generating events\nsuitable for building Bio::Search objects from a BLAST report file.\nRead the L<Bio::SearchIO> for more information about how to use this.\n\nThis driver can parse:\n\n=over 4\n\n* * \n\nNCBI produced plain text BLAST reports from blastall, this also\nincludes PSIBLAST, PSITBLASTN, RPSBLAST, and bl2seq reports.  NCBI XML\nBLAST output is parsed with the blastxml SearchIO driver\n\n* *\n\nWU-BLAST all reports\n\n* *\n\nJim Kent's BLAST-like output from his programs (BLASTZ, BLAT)\n\n* *\n\nBLAST-like output from Paracel BTK output\n\n\n=head2 bl2seq parsing\n\nSince I cannot differentiate between BLASTX and TBLASTN since bl2seq\ndoesn't report the algorithm used - I assume it is BLASTX by default -\nyou can supply the program type with -report_type in the SearchIO\nconstructor i.e.\n\n  my $parser = Bio::SearchIO->new(-format => 'blast',\n                                 -file => 'bl2seq.tblastn.report',\n                                 -report_type => 'tblastn');\n\nThis only really affects where the frame and strand information are\nput - they will always be on the $hsp-E<gt>query instead of on the\n$hsp-E<gt>hit part of the feature pair for blastx and tblastn bl2seq\nproduced reports.  Hope that's clear...\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail Jason Stajich jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nSteve Chervitz sac-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...'\n\npackage Bio::SearchIO::blast;\n\nuse Bio::SearchIO::IteratedSearchResultEventBuilder;\nuse strict;\nuse vars qw(%MAPPING %MODEMAP\n  $DEFAULT_BLAST_WRITER_CLASS\n  $MAX_HSP_OVERLAP\n  $DEFAULT_SIGNIF\n  $DEFAULT_SCORE\n  $DEFAULTREPORTTYPE\n);\n\n\nuse base qw(Bio::SearchIO);\nuse Data::Dumper;\n\nBEGIN {\n\n    # mapping of NCBI Blast terms to Bioperl hash keys\n    %MODEMAP = (\n        'BlastOutput' => 'result',\n        'Iteration'   => 'iteration',\n        'Hit'         => 'hit',\n        'Hsp'         => 'hsp'\n    );\n\n    # This should really be done more intelligently, like with\n    # XSLT\n\n    %MAPPING = (\n        'Hsp_bit-score'   => 'HSP-bits',\n        'Hsp_score'       => 'HSP-score',\n        'Hsp_evalue'      => 'HSP-evalue',\n        'Hsp_n',          => 'HSP-n',\n        'Hsp_pvalue'      => 'HSP-pvalue',\n        'Hsp_query-from'  => 'HSP-query_start',\n        'Hsp_query-to'    => 'HSP-query_end',\n        'Hsp_hit-from'    => 'HSP-hit_start',\n        'Hsp_hit-to'      => 'HSP-hit_end',\n        'Hsp_positive'    => 'HSP-conserved',\n        'Hsp_identity'    => 'HSP-identical',\n        'Hsp_gaps'        => 'HSP-hsp_gaps',\n        'Hsp_hitgaps'     => 'HSP-hit_gaps',\n        'Hsp_querygaps'   => 'HSP-query_gaps',\n        'Hsp_qseq'        => 'HSP-query_seq',\n        'Hsp_hseq'        => 'HSP-hit_seq',\n        'Hsp_midline'     => 'HSP-homology_seq',\n        'Hsp_align-len'   => 'HSP-hsp_length',\n        'Hsp_query-frame' => 'HSP-query_frame',\n        'Hsp_hit-frame'   => 'HSP-hit_frame',\n        'Hsp_links'       => 'HSP-links',\n        'Hsp_group'       => 'HSP-hsp_group',\n        'Hsp_features'    => 'HSP-hit_features',\n\n        'Hit_id'        => 'HIT-name',\n        'Hit_len'       => 'HIT-length',\n        'Hit_accession' => 'HIT-accession',\n        'Hit_def'       => 'HIT-description',\n        'Hit_signif'    => 'HIT-significance',\n        # For NCBI blast, the description line contains bits.\n        # For WU-blast, the  description line contains score.\n        'Hit_score' => 'HIT-score',\n        'Hit_bits'  => 'HIT-bits',\n\n        'Iteration_iter-num'  => 'ITERATION-number',\n        'Iteration_converged' => 'ITERATION-converged',\n\n        'BlastOutput_program'             => 'RESULT-algorithm_name',\n        'BlastOutput_version'             => 'RESULT-algorithm_version',\n        'BlastOutput_query-def'           => 'RESULT-query_name',\n        'BlastOutput_query-len'           => 'RESULT-query_length',\n        'BlastOutput_query-acc'           => 'RESULT-query_accession',\n        'BlastOutput_query-gi'            => 'RESULT-query_gi',\n        'BlastOutput_querydesc'           => 'RESULT-query_description',\n        'BlastOutput_db'                  => 'RESULT-database_name',\n        'BlastOutput_db-len'              => 'RESULT-database_entries',\n        'BlastOutput_db-let'              => 'RESULT-database_letters',\n        'BlastOutput_inclusion-threshold' => 'RESULT-inclusion_threshold',\n\n        'Parameters_matrix'      => { 'RESULT-parameters' => 'matrix' },\n        'Parameters_expect'      => { 'RESULT-parameters' => 'expect' },\n        'Parameters_include'     => { 'RESULT-parameters' => 'include' },\n        'Parameters_sc-match'    => { 'RESULT-parameters' => 'match' },\n        'Parameters_sc-mismatch' => { 'RESULT-parameters' => 'mismatch' },\n        'Parameters_gap-open'    => { 'RESULT-parameters' => 'gapopen' },\n        'Parameters_gap-extend'  => { 'RESULT-parameters' => 'gapext' },\n        'Parameters_filter'      => { 'RESULT-parameters' => 'filter' },\n        'Parameters_allowgaps'   => { 'RESULT-parameters' => 'allowgaps' },\n        'Parameters_full_dbpath' => { 'RESULT-parameters' => 'full_dbpath' },\n        'Statistics_db-len'      => { 'RESULT-statistics' => 'dbentries' },\n        'Statistics_db-let'      => { 'RESULT-statistics' => 'dbletters' },\n        'Statistics_hsp-len'     =>\n          { 'RESULT-statistics' => 'effective_hsplength' },\n        'Statistics_query-len' => { 'RESULT-statistics' => 'querylength' },\n        'Statistics_eff-space' => { 'RESULT-statistics' => 'effectivespace' },\n        'Statistics_eff-spaceused' =>\n          { 'RESULT-statistics' => 'effectivespaceused' },\n        'Statistics_eff-dblen' =>\n          { 'RESULT-statistics' => 'effectivedblength' },\n        'Statistics_kappa'         => { 'RESULT-statistics' => 'kappa' },\n        'Statistics_lambda'        => { 'RESULT-statistics' => 'lambda' },\n        'Statistics_entropy'       => { 'RESULT-statistics' => 'entropy' },\n        'Statistics_gapped_kappa'  => { 'RESULT-statistics' => 'kappa_gapped' },\n        'Statistics_gapped_lambda' =>\n          { 'RESULT-statistics' => 'lambda_gapped' },\n        'Statistics_gapped_entropy' =>\n          { 'RESULT-statistics' => 'entropy_gapped' },\n\n        'Statistics_framewindow' =>\n          { 'RESULT-statistics' => 'frameshiftwindow' },\n        'Statistics_decay' => { 'RESULT-statistics' => 'decayconst' },\n\n        'Statistics_hit_to_db' => { 'RESULT-statistics' => 'Hits_to_DB' },\n        'Statistics_num_suc_extensions' =>\n          { 'RESULT-statistics' => 'num_successful_extensions' },\n\n        # WU-BLAST stats\n        'Statistics_DFA_states' => { 'RESULT-statistics' => 'num_dfa_states' },\n        'Statistics_DFA_size'   => { 'RESULT-statistics' => 'dfa_size' },\n        'Statistics_noprocessors' =>\n          { 'RESULT-statistics' => 'no_of_processors' },\n        'Statistics_neighbortime' =>\n          { 'RESULT-statistics' => 'neighborhood_generate_time' },\n        'Statistics_starttime' => { 'RESULT-statistics' => 'start_time' },\n        'Statistics_endtime'   => { 'RESULT-statistics' => 'end_time' },\n    );\n\n    # add WU-BLAST Frame-Based Statistics\n    for my $frame ( 0 .. 3 ) {\n        for my $strand ( '+', '-' ) {\n            for my $ind (\n                qw(length efflength E S W T X X_gapped E2\n                E2_gapped S2)\n              )\n            {\n                $MAPPING{\"Statistics_frame$strand$frame\\_$ind\"} =\n                  { 'RESULT-statistics' => \"Frame$strand$frame\\_$ind\" };\n            }\n            for my $val (qw(lambda kappa entropy )) {\n                for my $type (qw(used computed gapped)) {\n                    my $key = \"Statistics_frame$strand$frame\\_$val\\_$type\";\n                    my $val =\n                      { 'RESULT-statistics' =>\n                          \"Frame$strand$frame\\_$val\\_$type\" };\n                    $MAPPING{$key} = $val;\n                }\n            }\n        }\n    }\n\n    # add Statistics\n    for my $stats (\n        qw(T A X1 X2 X3 S1 S2 X1_bits X2_bits X3_bits\n        S1_bits S2_bits  num_extensions\n        num_successful_extensions\n        seqs_better_than_cutoff\n        posted_date\n        search_cputime total_cputime\n        search_actualtime total_actualtime\n        no_of_processors ctxfactor)\n      )\n    {\n        my $key = \"Statistics_$stats\";\n        my $val = { 'RESULT-statistics' => $stats };\n        $MAPPING{$key} = $val;\n    }\n\n    # add WU-BLAST Parameters\n    for my $param (\n        qw(span span1 span2 links warnings notes hspsepsmax\n        hspsepqmax topcomboN topcomboE postsw cpus wordmask\n        filter sort_by_pvalue sort_by_count sort_by_highscore\n        sort_by_totalscore sort_by_subjectlength noseqs gi qtype\n        qres V B Z Y M N)\n      )\n    {\n        my $key = \"Parameters_$param\";\n        my $val = { 'RESULT-parameters' => $param };\n        $MAPPING{$key} = $val;\n    }\n\n    $DEFAULT_BLAST_WRITER_CLASS = 'Bio::Search::Writer::HitTableWriter';\n    $MAX_HSP_OVERLAP   = 2;           # Used when tiling multiple HSPs.\n    $DEFAULTREPORTTYPE = 'BLASTP';    # for bl2seq\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::blast->new(%args);\n Function: Builds a new Bio::SearchIO::blast object \n Returns : Bio::SearchIO::blast\n Args    : Key-value pairs:\n           -fh/-file => filehandle/filename to BLAST file\n           -format   => 'blast'\n           -report_type => 'blastx', 'tblastn', etc -- only for bl2seq\n                           reports when you want to distinguish between\n                           tblastn and blastx reports (this only controls\n                           where the frame information is put - on the query\n                           or subject object.\n           -inclusion_threshold => e-value threshold for inclusion in the\n                                   PSI-BLAST score matrix model (blastpgp)\n           -signif      => float or scientific notation number to be used\n                           as a P- or Expect value cutoff\n           -score       => integer or scientific notation number to be used\n                           as a blast score value cutoff\n           -bits        => integer or scientific notation number to be used\n                           as a bit score value cutoff\n           -hit_filter  => reference to a function to be used for\n                           filtering hits based on arbitrary criteria.\n                           All hits of each BLAST report must satisfy \n                           this criteria to be retained. \n                           If a hit fails this test, it is ignored.\n                           This function should take a\n                           Bio::Search::Hit::BlastHit.pm object as its first\n                           argument and return true\n                           if the hit should be retained.\n                           Sample filter function:\n                              -hit_filter => sub { $hit = shift;\n                                                   $hit->gaps == 0; },\n                           (Note: -filt_func is synonymous with -hit_filter)\n           -overlap     => integer. The amount of overlap to permit between\n                           adjacent HSPs when tiling HSPs. A reasonable value is 2.\n                           Default = $Bio::SearchIO::blast::MAX_HSP_OVERLAP.\n\n            The following criteria are not yet supported:\n            (these are probably best applied within this module rather than in the \n             event handler since they would permit the parser to take some shortcuts.)\n\n           -check_all_hits => boolean. Check all hits for significance against\n                              significance criteria.  Default = false.\n                              If false, stops processing hits after the first\n                              non-significant hit or the first hit that fails\n                              the hit_filter call. This speeds parsing,\n                              taking advantage of the fact that the hits\n                              are processed in the order they appear in the report.\n           -min_query_len => integer to be used as a minimum for query sequence length.\n                             Reports with query sequences below this length will\n                             not be processed. Default = no minimum length.\n           -best        => boolean. Only process the best hit of each report;\n                           default = false.\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n\n    # Blast reports require a specialized version of the SREB due to the\n    # possibility of iterations (PSI-BLAST). Forwarding all arguments to it. An\n    # issue here is that we want to set new default object factories if none are\n    # supplied.\n\n    my $handler = Bio::SearchIO::IteratedSearchResultEventBuilder->new(@args);\n    $self->attach_EventHandler($handler);\n    \n    # 2006-04-26 move this to the attach_handler function in this module so we\n    # can really reset the handler \n    # Optimization: caching\n    # the EventHandler since it is used a lot during the parse.\n    \n    # $self->{'_handler_cache'} = $handler;\n\n    my ( $min_qlen, $check_all, $overlap, $best, $rpttype ) = $self->_rearrange(\n        [\n            qw(MIN_LENGTH CHECK_ALL_HITS\n              OVERLAP BEST\n              REPORT_TYPE)\n        ],\n        @args\n    );\n\n    defined $min_qlen  && $self->min_query_length($min_qlen);\n    defined $best      && $self->best_hit_only($best);\n    defined $check_all && $self->check_all_hits($check_all);\n    defined $rpttype   && ( $self->{'_reporttype'} = $rpttype );\n}\n\nsub attach_EventHandler {\n    my ($self,$handler) = @_;\n\n    $self->SUPER::attach_EventHandler($handler);    \n\n    # Optimization: caching the EventHandler since it is used a lot\n    # during the parse.\n\n    $self->{'_handler_cache'} = $handler;\n    return;\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none"}},{"line":458,"kind":12,"name":"PARSER"},{"name":"PARSER","kind":12,"line":478},{"line":531,"kind":12,"name":"PARSER"},{"name":"DESCLINE","line":649,"kind":12},{"line":652,"kind":12,"name":"DESCLINE"},{"kind":12,"line":653,"name":"DESCLINE"},{"name":"DESCLINE","line":697,"kind":12},{"line":829,"kind":12,"name":"HITTABLE"},{"name":"HITTABLE","kind":12,"line":834},{"name":"HITTABLE","kind":12,"line":836},{"kind":12,"line":1226,"name":"PARSER"},{"containerName":"main::","definition":"sub","name":"_start_blastoutput","range":{"end":{"character":9999,"line":1864},"start":{"line":1858,"character":0}},"kind":12,"line":1858,"children":[{"definition":"my","name":"$self","containerName":"_start_blastoutput","localvar":"my","kind":13,"line":1859},{"kind":13,"line":1860,"containerName":"_start_blastoutput","name":"$self"},{"containerName":"_start_blastoutput","name":"start_element","kind":12,"line":1860},{"line":1861,"kind":13,"containerName":"_start_blastoutput","name":"$self"},{"containerName":"_start_blastoutput","name":"$self","line":1862,"kind":13},{"containerName":"_start_blastoutput","name":"$self","kind":13,"line":1863}]},{"name":"_will_handle","range":{"start":{"character":0,"line":1904},"end":{"line":1914,"character":9999}},"kind":12,"line":1904,"children":[{"containerName":"_will_handle","definition":"my","name":"$self","localvar":"my","kind":13,"line":1905},{"kind":13,"line":1905,"containerName":"_will_handle","name":"$type"},{"line":1906,"kind":13,"localvar":"my","definition":"my","name":"$handler","containerName":"_will_handle"},{"name":"$self","containerName":"_will_handle","line":1906,"kind":13},{"kind":13,"line":1907,"definition":"my","name":"$will_handle","containerName":"_will_handle","localvar":"my"},{"containerName":"_will_handle","name":"$self","line":1908,"kind":13},{"kind":13,"line":1908,"containerName":"_will_handle","name":"$type"},{"containerName":"_will_handle","name":"$self","line":1909,"kind":13},{"line":1909,"kind":13,"containerName":"_will_handle","name":"$type"},{"containerName":"_will_handle","name":"$self","kind":13,"line":1910},{"kind":13,"line":1910,"containerName":"_will_handle","name":"$type"},{"line":1911,"kind":13,"name":"$handler","containerName":"_will_handle"},{"line":1911,"kind":12,"containerName":"_will_handle","name":"will_handle"},{"kind":13,"line":1911,"name":"$type","containerName":"_will_handle"},{"line":1913,"kind":13,"containerName":"_will_handle","name":"$will_handle"},{"containerName":"_will_handle","name":"$handler","kind":13,"line":1913}],"containerName":"main::","definition":"sub","detail":"($self,$type)","signature":{"label":"_will_handle($self,$type)","documentation":"(Sesame Street aficionados note: This answer was NOT given by Mr. Noodle ;-P)\n# $Id: blast.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::blast\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n# 20030409 - sac\n#          PSI-BLAST full parsing support. Rollout of new\n#          model which will remove Steve's old psiblast driver\n# 20030424 - jason\n#          Megablast parsing fix as reported by Neil Saunders\n# 20030427 - jason\n#          Support bl2seq parsing\n# 20031124 - jason\n#          Parse more blast statistics, lambda, entropy, etc\n#          from WU-BLAST in frame-specific manner\n# 20060216 - cjf - fixed blast parsing for BLAST v2.2.13 output\n# 20071104 - dmessina - added support for WUBLAST -echofilter\n# 20071121 - cjf - fixed several bugs (bugs 2391, 2399, 2409)\n\n=head1 NAME\n\nBio::SearchIO::blast - Event generator for event based parsing of\nblast reports\n\n=head1 SYNOPSIS\n\n   # Do not use this object directly - it is used as part of the\n   # Bio::SearchIO system.\n\n    use Bio::SearchIO;\n    my $searchio = Bio::SearchIO->new(-format => 'blast',\n                                     -file   => 't/data/ecolitst.bls');\n    while( my $result = $searchio->next_result ) {\n        while( my $hit = $result->next_hit ) {\n            while( my $hsp = $hit->next_hsp ) {\n                # ...\n            }\n        }\n    }\n\n=head1 DESCRIPTION\n\nThis object encapsulated the necessary methods for generating events\nsuitable for building Bio::Search objects from a BLAST report file.\nRead the L<Bio::SearchIO> for more information about how to use this.\n\nThis driver can parse:\n\n=over 4\n\n* * \n\nNCBI produced plain text BLAST reports from blastall, this also\nincludes PSIBLAST, PSITBLASTN, RPSBLAST, and bl2seq reports.  NCBI XML\nBLAST output is parsed with the blastxml SearchIO driver\n\n* *\n\nWU-BLAST all reports\n\n* *\n\nJim Kent's BLAST-like output from his programs (BLASTZ, BLAT)\n\n* *\n\nBLAST-like output from Paracel BTK output\n\n\n=head2 bl2seq parsing\n\nSince I cannot differentiate between BLASTX and TBLASTN since bl2seq\ndoesn't report the algorithm used - I assume it is BLASTX by default -\nyou can supply the program type with -report_type in the SearchIO\nconstructor i.e.\n\n  my $parser = Bio::SearchIO->new(-format => 'blast',\n                                 -file => 'bl2seq.tblastn.report',\n                                 -report_type => 'tblastn');\n\nThis only really affects where the frame and strand information are\nput - they will always be on the $hsp-E<gt>query instead of on the\n$hsp-E<gt>hit part of the feature pair for blastx and tblastn bl2seq\nproduced reports.  Hope that's clear...\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail Jason Stajich jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nSteve Chervitz sac-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...'\n\npackage Bio::SearchIO::blast;\n\nuse Bio::SearchIO::IteratedSearchResultEventBuilder;\nuse strict;\nuse vars qw(%MAPPING %MODEMAP\n  $DEFAULT_BLAST_WRITER_CLASS\n  $MAX_HSP_OVERLAP\n  $DEFAULT_SIGNIF\n  $DEFAULT_SCORE\n  $DEFAULTREPORTTYPE\n);\n\n\nuse base qw(Bio::SearchIO);\nuse Data::Dumper;\n\nBEGIN {\n\n    # mapping of NCBI Blast terms to Bioperl hash keys\n    %MODEMAP = (\n        'BlastOutput' => 'result',\n        'Iteration'   => 'iteration',\n        'Hit'         => 'hit',\n        'Hsp'         => 'hsp'\n    );\n\n    # This should really be done more intelligently, like with\n    # XSLT\n\n    %MAPPING = (\n        'Hsp_bit-score'   => 'HSP-bits',\n        'Hsp_score'       => 'HSP-score',\n        'Hsp_evalue'      => 'HSP-evalue',\n        'Hsp_n',          => 'HSP-n',\n        'Hsp_pvalue'      => 'HSP-pvalue',\n        'Hsp_query-from'  => 'HSP-query_start',\n        'Hsp_query-to'    => 'HSP-query_end',\n        'Hsp_hit-from'    => 'HSP-hit_start',\n        'Hsp_hit-to'      => 'HSP-hit_end',\n        'Hsp_positive'    => 'HSP-conserved',\n        'Hsp_identity'    => 'HSP-identical',\n        'Hsp_gaps'        => 'HSP-hsp_gaps',\n        'Hsp_hitgaps'     => 'HSP-hit_gaps',\n        'Hsp_querygaps'   => 'HSP-query_gaps',\n        'Hsp_qseq'        => 'HSP-query_seq',\n        'Hsp_hseq'        => 'HSP-hit_seq',\n        'Hsp_midline'     => 'HSP-homology_seq',\n        'Hsp_align-len'   => 'HSP-hsp_length',\n        'Hsp_query-frame' => 'HSP-query_frame',\n        'Hsp_hit-frame'   => 'HSP-hit_frame',\n        'Hsp_links'       => 'HSP-links',\n        'Hsp_group'       => 'HSP-hsp_group',\n        'Hsp_features'    => 'HSP-hit_features',\n\n        'Hit_id'        => 'HIT-name',\n        'Hit_len'       => 'HIT-length',\n        'Hit_accession' => 'HIT-accession',\n        'Hit_def'       => 'HIT-description',\n        'Hit_signif'    => 'HIT-significance',\n        # For NCBI blast, the description line contains bits.\n        # For WU-blast, the  description line contains score.\n        'Hit_score' => 'HIT-score',\n        'Hit_bits'  => 'HIT-bits',\n\n        'Iteration_iter-num'  => 'ITERATION-number',\n        'Iteration_converged' => 'ITERATION-converged',\n\n        'BlastOutput_program'             => 'RESULT-algorithm_name',\n        'BlastOutput_version'             => 'RESULT-algorithm_version',\n        'BlastOutput_query-def'           => 'RESULT-query_name',\n        'BlastOutput_query-len'           => 'RESULT-query_length',\n        'BlastOutput_query-acc'           => 'RESULT-query_accession',\n        'BlastOutput_query-gi'            => 'RESULT-query_gi',\n        'BlastOutput_querydesc'           => 'RESULT-query_description',\n        'BlastOutput_db'                  => 'RESULT-database_name',\n        'BlastOutput_db-len'              => 'RESULT-database_entries',\n        'BlastOutput_db-let'              => 'RESULT-database_letters',\n        'BlastOutput_inclusion-threshold' => 'RESULT-inclusion_threshold',\n\n        'Parameters_matrix'      => { 'RESULT-parameters' => 'matrix' },\n        'Parameters_expect'      => { 'RESULT-parameters' => 'expect' },\n        'Parameters_include'     => { 'RESULT-parameters' => 'include' },\n        'Parameters_sc-match'    => { 'RESULT-parameters' => 'match' },\n        'Parameters_sc-mismatch' => { 'RESULT-parameters' => 'mismatch' },\n        'Parameters_gap-open'    => { 'RESULT-parameters' => 'gapopen' },\n        'Parameters_gap-extend'  => { 'RESULT-parameters' => 'gapext' },\n        'Parameters_filter'      => { 'RESULT-parameters' => 'filter' },\n        'Parameters_allowgaps'   => { 'RESULT-parameters' => 'allowgaps' },\n        'Parameters_full_dbpath' => { 'RESULT-parameters' => 'full_dbpath' },\n        'Statistics_db-len'      => { 'RESULT-statistics' => 'dbentries' },\n        'Statistics_db-let'      => { 'RESULT-statistics' => 'dbletters' },\n        'Statistics_hsp-len'     =>\n          { 'RESULT-statistics' => 'effective_hsplength' },\n        'Statistics_query-len' => { 'RESULT-statistics' => 'querylength' },\n        'Statistics_eff-space' => { 'RESULT-statistics' => 'effectivespace' },\n        'Statistics_eff-spaceused' =>\n          { 'RESULT-statistics' => 'effectivespaceused' },\n        'Statistics_eff-dblen' =>\n          { 'RESULT-statistics' => 'effectivedblength' },\n        'Statistics_kappa'         => { 'RESULT-statistics' => 'kappa' },\n        'Statistics_lambda'        => { 'RESULT-statistics' => 'lambda' },\n        'Statistics_entropy'       => { 'RESULT-statistics' => 'entropy' },\n        'Statistics_gapped_kappa'  => { 'RESULT-statistics' => 'kappa_gapped' },\n        'Statistics_gapped_lambda' =>\n          { 'RESULT-statistics' => 'lambda_gapped' },\n        'Statistics_gapped_entropy' =>\n          { 'RESULT-statistics' => 'entropy_gapped' },\n\n        'Statistics_framewindow' =>\n          { 'RESULT-statistics' => 'frameshiftwindow' },\n        'Statistics_decay' => { 'RESULT-statistics' => 'decayconst' },\n\n        'Statistics_hit_to_db' => { 'RESULT-statistics' => 'Hits_to_DB' },\n        'Statistics_num_suc_extensions' =>\n          { 'RESULT-statistics' => 'num_successful_extensions' },\n\n        # WU-BLAST stats\n        'Statistics_DFA_states' => { 'RESULT-statistics' => 'num_dfa_states' },\n        'Statistics_DFA_size'   => { 'RESULT-statistics' => 'dfa_size' },\n        'Statistics_noprocessors' =>\n          { 'RESULT-statistics' => 'no_of_processors' },\n        'Statistics_neighbortime' =>\n          { 'RESULT-statistics' => 'neighborhood_generate_time' },\n        'Statistics_starttime' => { 'RESULT-statistics' => 'start_time' },\n        'Statistics_endtime'   => { 'RESULT-statistics' => 'end_time' },\n    );\n\n    # add WU-BLAST Frame-Based Statistics\n    for my $frame ( 0 .. 3 ) {\n        for my $strand ( '+', '-' ) {\n            for my $ind (\n                qw(length efflength E S W T X X_gapped E2\n                E2_gapped S2)\n              )\n            {\n                $MAPPING{\"Statistics_frame$strand$frame\\_$ind\"} =\n                  { 'RESULT-statistics' => \"Frame$strand$frame\\_$ind\" };\n            }\n            for my $val (qw(lambda kappa entropy )) {\n                for my $type (qw(used computed gapped)) {\n                    my $key = \"Statistics_frame$strand$frame\\_$val\\_$type\";\n                    my $val =\n                      { 'RESULT-statistics' =>\n                          \"Frame$strand$frame\\_$val\\_$type\" };\n                    $MAPPING{$key} = $val;\n                }\n            }\n        }\n    }\n\n    # add Statistics\n    for my $stats (\n        qw(T A X1 X2 X3 S1 S2 X1_bits X2_bits X3_bits\n        S1_bits S2_bits  num_extensions\n        num_successful_extensions\n        seqs_better_than_cutoff\n        posted_date\n        search_cputime total_cputime\n        search_actualtime total_actualtime\n        no_of_processors ctxfactor)\n      )\n    {\n        my $key = \"Statistics_$stats\";\n        my $val = { 'RESULT-statistics' => $stats };\n        $MAPPING{$key} = $val;\n    }\n\n    # add WU-BLAST Parameters\n    for my $param (\n        qw(span span1 span2 links warnings notes hspsepsmax\n        hspsepqmax topcomboN topcomboE postsw cpus wordmask\n        filter sort_by_pvalue sort_by_count sort_by_highscore\n        sort_by_totalscore sort_by_subjectlength noseqs gi qtype\n        qres V B Z Y M N)\n      )\n    {\n        my $key = \"Parameters_$param\";\n        my $val = { 'RESULT-parameters' => $param };\n        $MAPPING{$key} = $val;\n    }\n\n    $DEFAULT_BLAST_WRITER_CLASS = 'Bio::Search::Writer::HitTableWriter';\n    $MAX_HSP_OVERLAP   = 2;           # Used when tiling multiple HSPs.\n    $DEFAULTREPORTTYPE = 'BLASTP';    # for bl2seq\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::blast->new(%args);\n Function: Builds a new Bio::SearchIO::blast object \n Returns : Bio::SearchIO::blast\n Args    : Key-value pairs:\n           -fh/-file => filehandle/filename to BLAST file\n           -format   => 'blast'\n           -report_type => 'blastx', 'tblastn', etc -- only for bl2seq\n                           reports when you want to distinguish between\n                           tblastn and blastx reports (this only controls\n                           where the frame information is put - on the query\n                           or subject object.\n           -inclusion_threshold => e-value threshold for inclusion in the\n                                   PSI-BLAST score matrix model (blastpgp)\n           -signif      => float or scientific notation number to be used\n                           as a P- or Expect value cutoff\n           -score       => integer or scientific notation number to be used\n                           as a blast score value cutoff\n           -bits        => integer or scientific notation number to be used\n                           as a bit score value cutoff\n           -hit_filter  => reference to a function to be used for\n                           filtering hits based on arbitrary criteria.\n                           All hits of each BLAST report must satisfy \n                           this criteria to be retained. \n                           If a hit fails this test, it is ignored.\n                           This function should take a\n                           Bio::Search::Hit::BlastHit.pm object as its first\n                           argument and return true\n                           if the hit should be retained.\n                           Sample filter function:\n                              -hit_filter => sub { $hit = shift;\n                                                   $hit->gaps == 0; },\n                           (Note: -filt_func is synonymous with -hit_filter)\n           -overlap     => integer. The amount of overlap to permit between\n                           adjacent HSPs when tiling HSPs. A reasonable value is 2.\n                           Default = $Bio::SearchIO::blast::MAX_HSP_OVERLAP.\n\n            The following criteria are not yet supported:\n            (these are probably best applied within this module rather than in the \n             event handler since they would permit the parser to take some shortcuts.)\n\n           -check_all_hits => boolean. Check all hits for significance against\n                              significance criteria.  Default = false.\n                              If false, stops processing hits after the first\n                              non-significant hit or the first hit that fails\n                              the hit_filter call. This speeds parsing,\n                              taking advantage of the fact that the hits\n                              are processed in the order they appear in the report.\n           -min_query_len => integer to be used as a minimum for query sequence length.\n                             Reports with query sequences below this length will\n                             not be processed. Default = no minimum length.\n           -best        => boolean. Only process the best hit of each report;\n                           default = false.\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n\n    # Blast reports require a specialized version of the SREB due to the\n    # possibility of iterations (PSI-BLAST). Forwarding all arguments to it. An\n    # issue here is that we want to set new default object factories if none are\n    # supplied.\n\n    my $handler = Bio::SearchIO::IteratedSearchResultEventBuilder->new(@args);\n    $self->attach_EventHandler($handler);\n    \n    # 2006-04-26 move this to the attach_handler function in this module so we\n    # can really reset the handler \n    # Optimization: caching\n    # the EventHandler since it is used a lot during the parse.\n    \n    # $self->{'_handler_cache'} = $handler;\n\n    my ( $min_qlen, $check_all, $overlap, $best, $rpttype ) = $self->_rearrange(\n        [\n            qw(MIN_LENGTH CHECK_ALL_HITS\n              OVERLAP BEST\n              REPORT_TYPE)\n        ],\n        @args\n    );\n\n    defined $min_qlen  && $self->min_query_length($min_qlen);\n    defined $best      && $self->best_hit_only($best);\n    defined $check_all && $self->check_all_hits($check_all);\n    defined $rpttype   && ( $self->{'_reporttype'} = $rpttype );\n}\n\nsub attach_EventHandler {\n    my ($self,$handler) = @_;\n\n    $self->SUPER::attach_EventHandler($handler);    \n\n    # Optimization: caching the EventHandler since it is used a lot\n    # during the parse.\n\n    $self->{'_handler_cache'} = $handler;\n    return;\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    my $v      = $self->verbose;\n    my $data   = '';\n    my $flavor = '';\n    $self->{'_seentop'} = 0;     # start next report at top\n    $self->{'_seentop'} = 0;\n    my ( $reporttype, $seenquery, $reportline );  \n    my ( $seeniteration, $found_again );\n    my $incl_threshold = $self->inclusion_threshold;\n    my $bl2seq_fix;\n    $self->start_document();  # let the fun begin...\n    my (@hit_signifs);\n    my $gapped_stats = 0;    # for switching between gapped/ungapped\n                             # lambda, K, H\n    local $_ = \"\\n\";   #consistency\n    PARSER:\n    while ( defined( $_ = $self->_readline ) ) {\n        next if (/^\\s+$/);       # skip empty lines\n        next if (/CPU time:/);\n        next if (/^>\\s*$/);\n        if (\n               /^((?:\\S+?)?BLAST[NPX]?)\\s+(.+)$/i  # NCBI BLAST, PSIBLAST\n                                                   # RPSBLAST, MEGABLAST\n            || /^(P?GENEWISE|HFRAME|SWN|TSWN)\\s+(.+)/i    #Paracel BTK\n          )\n        {\n            ($reporttype, my $reportversion) = ($1, $2);\n            # need to keep track of whether this is WU-BLAST\n            if ($reportversion && $reportversion =~ m{WashU$}) {\n                $self->{'_wublast'}++;\n            }\n            $self->debug(\"blast.pm: Start of new report: $reporttype, $reportversion\\n\");\n            if ( $self->{'_seentop'} ) { \n                # This handles multi-result input streams\n                $self->_pushback($_);\n                last PARSER;\n            }\n            $self->_start_blastoutput;\n            if ($reporttype =~ /RPS-BLAST/) {\n                $reporttype .= '(BLASTP)'; # default RPS-BLAST type\n            }\n            $reportline = $_;   # to fix the fact that RPS-BLAST output is wrong\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_program',\n                    'Data' => $reporttype\n                }\n            );\n\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_version',\n                    'Data' => $reportversion\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_inclusion-threshold',\n                    'Data' => $incl_threshold\n                }\n            );\n        }\n        # added Windows workaround for bug 1985\n        elsif (/^(Searching|Results from round)/) { \n            next unless $1 =~ /Results from round/; \n            $self->debug(\"blast.pm: Possible psi blast iterations found...\\n\");\n            \n            $self->in_element('hsp')\n              && $self->end_element( { 'Name' => 'Hsp' } );\n            $self->in_element('hit')\n              && $self->end_element( { 'Name' => 'Hit' } );\n            if ( defined $seeniteration ) {\n                $self->within_element('iteration')\n                  && $self->end_element( { 'Name' => 'Iteration' } );\n                $self->start_element( { 'Name' => 'Iteration' } );\n            }\n            else {\n                $self->start_element( { 'Name' => 'Iteration' } );\n            }\n            $seeniteration = 1;\n        }\n        elsif (/^Query=\\s*(.*)$/) {\n            my $q    = $1;\n            $self->debug(\"blast.pm: Query= found...$_\\n\");\n            my $size = 0;\n            if ( defined $seenquery ) {\n                $self->_pushback($reportline) if $reportline;\n                $self->_pushback($_);\n                last PARSER;\n            }\n            else {\n                if ( !defined $reporttype ) {\n                    $self->_start_blastoutput;\n                    if ( defined $seeniteration ) {\n                        $self->in_element('iteration')\n                          && $self->end_element( { 'Name' => 'Iteration' } );\n                        $self->start_element( { 'Name' => 'Iteration' } );\n                    }\n                    else {\n                        $self->start_element( { 'Name' => 'Iteration' } );\n                    }\n                    $seeniteration = 1;\n                }\n            }\n            $seenquery = $q;\n            $_ = $self->_readline;\n            while ( defined($_) ) {\n                if (/^Database:/) {\n                    $self->_pushback($_);\n                    last;\n                }\n                # below line fixes length issue with BLAST v2.2.13; still works \n                # with BLAST v2.2.12\n                if ( /\\((\\-?[\\d,]+)\\s+letters.*\\)/ || /^Length=(\\-?[\\d,]+)/ ) {\n                    $size = $1;\n                    $size =~ s/,//g;\n                    last;\n                }\n                else {\n                    # bug 2391\n                    $q .= ($q =~ /\\w$/ && $_ =~ /^\\w/) ? \" $_\" : $_;\n                    $q =~ s/\\s+/ /g; # this catches the newline as well\n                    $q =~ s/^ | $//g;\n                }\n\n                $_ = $self->_readline;\n            }\n            chomp($q);\n            my ( $nm, $desc ) = split( /\\s+/, $q, 2 );\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_query-def',\n                    'Data' => $nm\n                }\n            ) if $nm;\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_query-len',\n                    'Data' => $size\n                }\n            );\n            defined $desc && $desc =~ s/\\s+$//;\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_querydesc',\n                    'Data' => $desc\n                }\n            );\n            my ( $gi, $acc, $version ) = $self->_get_seq_identifiers($nm);\n            $version = defined($version) && length($version) ? \".$version\" : \"\";\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_query-acc',\n                    'Data' => \"$acc$version\"\n                }\n            ) if $acc;\n        }\n\t\t# added check for WU-BLAST -echofilter option (bug 2388)\n\t\telsif (/^>Unfiltered[+-]1$/) {\n        \t# skip all of the lines of unfiltered sequence\n\t\t\twhile($_ !~ /^Database:/) {\n\t\t\t\t$self->debug(\"Bypassing features line: $_\");\n        \t\t$_ = $self->_readline;\n        \t}\n\t\t\t$self->_pushback($_);\n\t\t}\n        elsif (/Sequences producing significant alignments:/) {\n            $self->debug(\"blast.pm: Processing NCBI-BLAST descriptions\\n\");\n            $flavor = 'ncbi';\n            \n            # PSI-BLAST parsing needs to be fixed to specifically look\n            # for old vs new per iteration, as sorting based on duplication\n            # leads to bugs, see bug 1986\n            \n            # The next line is not necessarily whitespace in psiblast reports.\n            # Also note that we must look for the end of this section by testing\n            # for a line with a leading >. Blank lines occur with this section\n            # for psiblast.\n            if ( !$self->in_element('iteration') ) {\n                $self->start_element( { 'Name' => 'Iteration' } );\n            }\n            # these elements are dropped with some multiquery reports; add\n            # back here\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_db-len',\n                    'Data' => $self->{'_blsdb_length'}\n                } \n            ) if $self->{'_blsdb_length'};\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_db-let',\n                    'Data' => $self->{'_blsdb_letters'}\n                }\n            ) if $self->{'_blsdb_letters'};\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_db',\n                    'Data' => $self->{'_blsdb'}\n                }\n            ) if $self->{'_blsdb_letters'};\n            \n            # changed 8/28/2008 to exit hit table if blank line is found after an\n            # appropriate line\n            my $h_regex;\n            my $seen_block;\n          DESCLINE:\n            while ( defined( my $descline = $self->_readline() ) ) {\n                if ($descline =~ m{^\\s*$}) {\n                    last DESCLINE if $seen_block;\n                    next DESCLINE;\n                }\n                # any text match is part of block...\n                $seen_block++;\n                # GCG multiline oddness...\n                if ($descline =~ /^(\\S+)\\s+Begin:\\s\\d+\\s+End:\\s+\\d+/xms) {\n                    my ($id, $nextline) = ($1, $self->_readline);\n                    $nextline =~ s{^!}{};\n                    $descline = \"$id $nextline\";\n                }\n                # NCBI style hit table (no N)\n                if ($descline =~ /(?<!cor)          # negative lookahead\n                    (\\d*\\.?(?:[\\+\\-eE]+)?\\d+)       # number (float or scientific notation)\n                    \\s+                             # space\n                    (\\d*\\.?(?:[\\+\\-eE]+)?\\d+)       # number (float or scientific notation)\n                    \\s*$/xms) {\n                    \n                    my ( $score, $evalue ) = ($1, $2);\n                    \n                    # Some data clean-up so e-value will appear numeric to perl\n                    $evalue =~ s/^e/1e/i;\n\n                    # This to handle no-HSP case\n                    my @line = split ' ',$descline;\n                    \n                    # we want to throw away the score, evalue\n                    pop @line, pop @line;\n\n                    # and N if it is present (of course they are not\n                    # really in that order, but it doesn't matter\n                    if ($3) { pop @line }\n\n                    # add the last 2 entries s.t. we can reconstruct\n                    # a minimal Hit object at the end of the day\n                    push @hit_signifs, [ $evalue, $score, shift @line, join( ' ', @line ) ];\n                } elsif ($descline =~ /^CONVERGED/i) {\n                    $self->element(\n                        {\n                            'Name' => 'Iteration_converged',\n                            'Data' => 1\n                        }\n                    );\n                } else {\n                    $self->_pushback($descline); # Catch leading > (end of section)\n                    last DESCLINE;\n                }\n            }\n        }\n        elsif (/Sequences producing High-scoring Segment Pairs:/) {\n\n     # This block is for WU-BLAST, so we don't have to check for psi-blast stuff\n     # skip the next line\n            $self->debug(\"blast.pm: Processing WU-BLAST descriptions\\n\");\n            $_      = $self->_readline();\n            $flavor = 'wu';\n\n            if ( !$self->in_element('iteration') ) {\n                $self->start_element( { 'Name' => 'Iteration' } );\n            }\n\n            while ( defined( $_ = $self->_readline() )\n                && !/^\\s+$/ )\n            {\n                my @line = split;\n                pop @line;    # throw away first number which is for 'N'col\n\n                # add the last 2 entries to array s.t. we can reconstruct\n                # a minimal Hit object at the end of the day\n                push @hit_signifs,\n                  [ pop @line, pop @line, shift @line, join( ' ', @line ) ];\n            }\n            \n        }\n        elsif (/^Database:\\s*(.+)$/) {\n\n            $self->debug(\"blast.pm: Database: $1\\n\");\n            my $db = $1;\n            while ( defined( $_ = $self->_readline ) ) {\n                if (\n                    /^\\s+(\\-?[\\d\\,]+|\\S+)\\s+sequences\\;\n                   \\s+(\\-?[\\d,]+|\\S+)\\s+ # Deal with NCBI 2.2.8 OSX problems\n                   total\\s+letters/ox\n                  )\n                {\n                    my ( $s, $l ) = ( $1, $2 );\n                    $s =~ s/,//g;\n                    $l =~ s/,//g;\n                    $self->element(\n                        {\n                            'Name' => 'BlastOutput_db-len',\n                            'Data' => $s\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'BlastOutput_db-let',\n                            'Data' => $l\n                        }\n                    );\n                    # cache for next round in cases with multiple queries\n                    $self->{'_blsdb'} = $db;\n                    $self->{'_blsdb_length'} = $s;\n                    $self->{'_blsdb_letters'} = $l;                    \n                    last;\n                }\n                else {\n                    chomp;\n                    $db .= $_;\n                }\n            }\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_db',\n                    'Data' => $db\n                }\n            );\n        }\n        # bypasses this NCBI blast 2.2.13 extra output for now...\n\t\t# Features in/flanking this part of subject sequence:\n        elsif (/^\\sFeatures\\s\\w+\\sthis\\spart/xmso) {\n            my $featline;\n            $_ = $self->_readline;\n\t\t\twhile($_ !~ /^\\s*$/) {\n                chomp;\n                $featline .= $_;\n        \t\t$_ = $self->_readline;\n        \t}\n\t\t\t$self->_pushback($_);\n            $featline =~ s{(?:^\\s+|\\s+^)}{}g;\n            $featline =~ s{\\n}{;}g;\n            $self->{'_last_hspdata'}->{'Hsp_features'} = $featline;\n        }\n        \n        # move inside of a hit\n        elsif (/^>\\s*(\\S+)\\s*(.*)?/) {\n            chomp;\n\n            $self->debug(\"blast.pm: Hit: $1\\n\");\n            $self->in_element('hsp')\n              && $self->end_element( { 'Name' => 'Hsp' } );\n            $self->in_element('hit')\n              && $self->end_element( { 'Name' => 'Hit' } );\n\n            # special case when bl2seq reports don't have a leading\n            # Query=\n            if ( !$self->within_element('result') ) {\n                $self->_start_blastoutput;\n                $self->start_element( { 'Name' => 'Iteration' } );\n            }\n            elsif ( !$self->within_element('iteration') ) {\n                $self->start_element( { 'Name' => 'Iteration' } );\n            }\n            $self->start_element( { 'Name' => 'Hit' } );\n            my $id         = $1;\n            my $restofline = $2;\n\n            $self->debug(\"Starting a hit: $1 $2\\n\");\n            $self->element(\n                {\n                    'Name' => 'Hit_id',\n                    'Data' => $id\n                }\n            );\n            my ($gi, $acc, $version ) = $self->_get_seq_identifiers($id);\n            $self->element(\n                {\n                    'Name' => 'Hit_accession',\n                    'Data' => $acc\n                }\n            );\n            # add hit significance (from the hit table)\n            # this is where Bug 1986 went awry\n            \n            # Changed for Bug2409; hit->significance and hit->score/bits derived\n            # from HSPs, not hit table unless necessary\n            \n            HITTABLE:\n            while (my $v = shift @hit_signifs) {        \n                my $tableid = $v->[2];\n                if ($tableid !~ m{\\Q$id\\E}) {\n                    $self->debug(\"Hit table ID $tableid doesn't match current hit id $id, checking next hit table entry...\\n\");\n                    next HITTABLE;\n                } else {\n                    last HITTABLE;\n                }\n            }\n            while ( defined( $_ = $self->_readline() ) ) {\n                next if (/^\\s+$/);\n                chomp;\n                if (/Length\\s*=\\s*([\\d,]+)/) {\n                    my $l = $1;\n                    $l =~ s/\\,//g;\n                    $self->element(\n                        {\n                            'Name' => 'Hit_len',\n                            'Data' => $l\n                        }\n                    );\n                    last;\n                }\n                else {\n                    s/^\\s(?!\\s)/\\x01/; #new line to concatenate desc lines with <soh>\n                    $restofline .= $_;\n                }\n            }\n            $restofline =~ s/\\s+/ /g;\n            $self->element(\n                {\n                    'Name' => 'Hit_def',\n                    'Data' => $restofline\n                }\n            );\n        }\n        elsif (/\\s+(Plus|Minus) Strand HSPs:/i) {\n            next;\n        }\n        elsif (\n            ( $self->in_element('hit') || $self->in_element('hsp') )\n            &&    # paracel genewise BTK\n            m/Score\\s*=\\s*(\\S+)\\s*bits\\s* # Bit score\n                (?:\\((\\d+)\\))?,                 # Raw score\n\t\t\\s+Log\\-Length\\sScore\\s*=\\s*(\\d+) # Log-Length score\n                /ox\n          )\n        {\n            $self->in_element('hsp')\n              && $self->end_element( { 'Name' => 'Hsp' } );\n            $self->start_element( { 'Name' => 'Hsp' } );\n\n            $self->debug( \"Got paracel genewise HSP score=$1\\n\");\n\n            # Some data clean-up so e-value will appear numeric to perl\n            my ( $bits, $score, $evalue ) = ( $1, $2, $3 );\n            $evalue =~ s/^e/1e/i;\n            $self->element(\n                {\n                    'Name' => 'Hsp_score',\n                    'Data' => $score\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_bit-score',\n                    'Data' => $bits\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_evalue',\n                    'Data' => $evalue\n                }\n            );\n        }\n        elsif (\n            ( $self->in_element('hit') || $self->in_element('hsp') )\n            &&    # paracel hframe BTK\n            m/Score\\s*=\\s*([^,\\s]+),     # Raw score\n\t\t\\s*Expect\\s*=\\s*([^,\\s]+),  # E-value\n                \\s*P(?:\\(\\S+\\))?\\s*=\\s*([^,\\s]+) # P-value\n                /ox\n          )\n        {\n            $self->in_element('hsp')\n              && $self->end_element( { 'Name' => 'Hsp' } );\n            $self->start_element( { 'Name' => 'Hsp' } );\n\n            $self->debug( \"Got paracel hframe HSP score=$1\\n\");\n\n            # Some data clean-up so e-value will appear numeric to perl\n            my ( $score, $evalue, $pvalue ) = ( $1, $2, $3 );\n            $evalue = \"1$evalue\" if $evalue =~ /^e/;\n            $pvalue = \"1$pvalue\" if $pvalue =~ /^e/;\n\n            $self->element(\n                {\n                    'Name' => 'Hsp_score',\n                    'Data' => $score\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_evalue',\n                    'Data' => $evalue\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_pvalue',\n                    'Data' => $pvalue\n                }\n            );\n        }\n        elsif (\n            ( $self->in_element('hit') || $self->in_element('hsp') )\n            &&    # wublast\n            m/Score\\s*=\\s*(\\S+)\\s*         # Bit score\n                \\(([\\d\\.]+)\\s*bits\\),         # Raw score\n                \\s*Expect\\s*=\\s*([^,\\s]+),    # E-value\n                \\s*(?:Sum)?\\s*                # SUM\n                P(?:\\(\\d+\\))?\\s*=\\s*([^,\\s]+) # P-value\n                (?:\\s*,\\s+Group\\s*\\=\\s*(\\d+))?    # HSP Group\n                /ox\n          )\n        {         # wu-blast HSP parse\n            $self->in_element('hsp')\n              && $self->end_element( { 'Name' => 'Hsp' } );\n            $self->start_element( { 'Name' => 'Hsp' } );\n\n            # Some data clean-up so e-value will appear numeric to perl\n            my ( $score, $bits, $evalue, $pvalue, $group ) =\n              ( $1, $2, $3, $4, $5 );\n            $evalue =~ s/^e/1e/i;\n            $pvalue =~ s/^e/1e/i;\n\n            $self->element(\n                {\n                    'Name' => 'Hsp_score',\n                    'Data' => $score\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_bit-score',\n                    'Data' => $bits\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_evalue',\n                    'Data' => $evalue\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_pvalue',\n                    'Data' => $pvalue\n                }\n            );\n\n            if ( defined $group ) {\n                $self->element(\n                    {\n                        'Name' => 'Hsp_group',\n                        'Data' => $group\n                    }\n                );\n            }\n\n        }\n        elsif (\n            ( $self->in_element('hit') || $self->in_element('hsp') )\n            &&    # ncbi blast, works with 2.2.17\n            m/Score\\s*=\\s*(\\S+)\\s*bits\\s* # Bit score\n                (?:\\((\\d+)\\))?,            # Missing for BLAT pseudo-BLAST fmt \n                \\s*Expect(?:\\((\\d+\\+?)\\))?\\s*=\\s*([^,\\s]+) # E-value\n                /ox\n          )\n        {         # parse NCBI blast HSP\n            $self->in_element('hsp')\n              && $self->end_element( { 'Name' => 'Hsp' } );\n\n            # Some data clean-up so e-value will appear numeric to perl\n            my ( $bits, $score, $n, $evalue ) = ( $1, $2, $3, $4 );\n            $evalue =~ s/^e/1e/i;\n            $self->start_element( { 'Name' => 'Hsp' } );\n            $self->element(\n                {\n                    'Name' => 'Hsp_score',\n                    'Data' => $score\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_bit-score',\n                    'Data' => $bits\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_evalue',\n                    'Data' => $evalue\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_n',\n                    'Data' => $n\n                }\n            ) if defined $n;\n            $score = '' unless defined $score;    # deal with BLAT which\n                                                  # has no score only bits\n            $self->debug(\"Got NCBI HSP score=$score, evalue $evalue\\n\");\n        }\n        elsif (\n            $self->in_element('hsp')\n            && m/Identities\\s*=\\s*(\\d+)\\s*\\/\\s*(\\d+)\\s*[\\d\\%\\(\\)]+\\s*\n                (?:,\\s*Positives\\s*=\\s*(\\d+)\\/(\\d+)\\s*[\\d\\%\\(\\)]+\\s*)? # pos only valid for Protein alignments\n                (?:\\,\\s*Gaps\\s*=\\s*(\\d+)\\/(\\d+))? # Gaps\n                /oxi\n          )\n        {\n            $self->element(\n                {\n                    'Name' => 'Hsp_identity',\n                    'Data' => $1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_align-len',\n                    'Data' => $2\n                }\n            );\n            if ( defined $3 ) {\n                $self->element(\n                    {\n                        'Name' => 'Hsp_positive',\n                        'Data' => $3\n                    }\n                );\n            }\n            else {\n                $self->element(\n                    {\n                        'Name' => 'Hsp_positive',\n                        'Data' => $1\n                    }\n                );\n            }\n            if ( defined $6 ) {\n                $self->element(\n                    {\n                        'Name' => 'Hsp_gaps',\n                        'Data' => $5\n                    }\n                );\n            }\n\n            $self->{'_Query'} = { 'begin' => 0, 'end' => 0 };\n            $self->{'_Sbjct'} = { 'begin' => 0, 'end' => 0 };\n\n            if (/(Frame\\s*=\\s*.+)$/) {\n\n                # handle wu-blast Frame listing on same line\n                $self->_pushback($1);\n            }\n        }\n        elsif ( $self->in_element('hsp')\n            && /Strand\\s*=\\s*(Plus|Minus)\\s*\\/\\s*(Plus|Minus)/i )\n        {\n\n            # consume this event ( we infer strand from start/end)\n            unless ($reporttype) {\n                $self->{'_reporttype'} = $reporttype = 'BLASTN';\n                $bl2seq_fix = 1;    # special case to resubmit the algorithm\n                                    # reporttype\n            }\n            next;\n        }\n        elsif ( $self->in_element('hsp')\n            && /Links\\s*=\\s*(\\S+)/ox )\n        {\n            $self->element(\n                {\n                    'Name' => 'Hsp_links',\n                    'Data' => $1\n                }\n            );\n        }\n        elsif ( $self->in_element('hsp')\n            && /Frame\\s*=\\s*([\\+\\-][1-3])\\s*(\\/\\s*([\\+\\-][1-3]))?/ )\n        {\n\n            # this is for bl2seq only\n            unless ( defined $reporttype ) {\n                $bl2seq_fix = 1;\n                if ( $1 && $2 ) { $reporttype = 'TBLASTX' }\n                else {\n                    $reporttype = 'BLASTX';\n\n    # we can't distinguish between BLASTX and TBLASTN straight from the report }\n                }\n                $self->{'_reporttype'} = $reporttype;\n            }\n\n            my ( $queryframe, $hitframe );\n            if ( $reporttype eq 'TBLASTX' ) {\n                ( $queryframe, $hitframe ) = ( $1, $2 );\n                $hitframe =~ s/\\/\\s*//g;\n            }\n            elsif ( $reporttype eq 'TBLASTN' || $reporttype eq 'PSITBLASTN') {\n                ( $hitframe, $queryframe ) = ( $1, 0 );\n            }\n            elsif ( $reporttype eq 'BLASTX' || $reporttype eq 'RPS-BLAST(BLASTP)') {\n                ( $queryframe, $hitframe ) = ( $1, 0 );\n                # though NCBI doesn't report it, this is a special BLASTX-like\n                # RPS-BLAST; should be handled differently\n                if ($reporttype eq 'RPS-BLAST(BLASTP)') {\n                    $self->element(\n                        {\n                            'Name' => 'BlastOutput_program',\n                            'Data' => 'RPS-BLAST(BLASTX)'\n                        }\n                    );\n                }\n            }\n            $self->element(\n                {\n                    'Name' => 'Hsp_query-frame',\n                    'Data' => $queryframe\n                }\n            );\n\n            $self->element(\n                {\n                    'Name' => 'Hsp_hit-frame',\n                    'Data' => $hitframe\n                }\n            );\n        }\n        elsif (/^Parameters:/\n            || /^\\s+Database:\\s+?/\n            || /^\\s+Subset/\n            || /^\\s*Lambda/\n            || /^\\s*Histogram/\n            || ( $self->in_element('hsp') && /WARNING|NOTE/ ) )\n        {\n\n            # Note: Lambda check was necessary to parse\n            # t/data/ecoli_domains.rpsblast AND to parse bl2seq\n            $self->debug(\"blast.pm: found parameters section \\n\");\n\n            $self->in_element('hsp')\n              && $self->end_element( { 'Name' => 'Hsp' } );\n            $self->in_element('hit')\n              && $self->end_element( { 'Name' => 'Hit' } );\n\n            # This is for the case when we specify -b 0 (or B=0 for WU-BLAST)\n            # and still want to construct minimal Hit objects\n            $self->_cleanup_hits(\\@hit_signifs) if scalar(@hit_signifs);\n            $self->within_element('iteration')\n              && $self->end_element( { 'Name' => 'Iteration' } );\n\n            next if /^\\s+Subset/;\n            my $blast = (/^(\\s+Database\\:)|(\\s*Lambda)/) ? 'ncbi' : 'wublast';\n            if (/^\\s*Histogram/) {\n                $blast = 'btk';\n            }\n\n            my $last = '';\n\n            # default is that gaps are allowed\n            $self->element(\n                {\n                    'Name' => 'Parameters_allowgaps',\n                    'Data' => 'yes'\n                }\n            );\n            while ( defined( $_ = $self->_readline ) ) {\n                if (\n                    /^((?:\\S+)?BLAST[NPX]?)\\s+(.+)$/i  # NCBI BLAST, PSIBLAST\n                                                      # RPSBLAST, MEGABLAST\n                    || /^(P?GENEWISE|HFRAME|SWN|TSWN)\\s+(.+)/i    #Paracel BTK\n                  )\n                {\n                    $self->_pushback($_);\n\n                    # let's handle this in the loop\n                    last;\n                }\n                elsif (/^Query=/) {\n                    $self->_pushback($reportline) if $reportline;\n                    $self->_pushback($_);\n                    last PARSER;\n                }\n\n                # here is where difference between wublast and ncbiblast\n                # is better handled by different logic\n                if (   /Number of Sequences:\\s+([\\d\\,]+)/i\n                    || /of sequences in database:\\s+(\\-?[\\d,]+)/i )\n                {\n                    my $c = $1;\n                    $c =~ s/\\,//g;\n                    $self->element(\n                        {\n                            'Name' => 'Statistics_db-len',\n                            'Data' => $c\n                        }\n                    );\n                }\n                elsif (/letters in database:\\s+(\\-?[\\d,]+)/i) {\n                    my $s = $1;\n                    $s =~ s/,//g;\n                    $self->element(\n                        {\n                            'Name' => 'Statistics_db-let',\n                            'Data' => $s\n                        }\n                    );\n                }\n                elsif ( $blast eq 'btk' ) {\n                    next;\n                }\n                elsif ( $blast eq 'wublast' ) {\n\n                    #\t\t   warn($_);\n                    if (/E=(\\S+)/) {\n                        $self->element(\n                            {\n                                'Name' => 'Parameters_expect',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (/nogaps/) {\n                        $self->element(\n                            {\n                                'Name' => 'Parameters_allowgaps',\n                                'Data' => 'no'\n                            }\n                        );\n                    }\n                    elsif (/ctxfactor=(\\S+)/) {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_ctxfactor',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (\n/(postsw|links|span[12]?|warnings|notes|gi|noseqs|qres|qype)/\n                      )\n                    {\n                        $self->element(\n                            {\n                                'Name' => \"Parameters_$1\",\n                                'Data' => 'yes'\n                            }\n                        );\n                    }\n                    elsif (/(\\S+)=(\\S+)/) {\n                        $self->element(\n                            {\n                                'Name' => \"Parameters_$1\",\n                                'Data' => $2\n                            }\n                        );\n                    }\n                    elsif ( $last =~ /(Frame|Strand)\\s+MatID\\s+Matrix name/i ) {\n                        my $firstgapinfo = 1;\n                        my $frame        = undef;\n                        while ( defined($_) && !/^\\s+$/ ) {\n                            s/^\\s+//;\n                            s/\\s+$//;\n                            if ( $firstgapinfo\n                                && s/Q=(\\d+),R=(\\d+)\\s+//x )\n                            {\n                                $firstgapinfo = 0;\n\n                                $self->element(\n                                    {\n                                        'Name' => 'Parameters_gap-open',\n                                        'Data' => $1\n                                    }\n                                );\n                                $self->element(\n                                    {\n                                        'Name' => 'Parameters_gap-extend',\n                                        'Data' => $2\n                                    }\n                                );\n                                my @fields = split;\n\n                                for my $type (\n                                    qw(lambda_gapped\n                                    kappa_gapped\n                                    entropy_gapped)\n                                  )\n                                {\n                                    next if $type eq 'n/a';\n                                    if ( !@fields ) {\n                                        warn \"fields is empty for $type\\n\";\n                                        next;\n                                    }\n                                    $self->element(\n                                        {\n                                            'Name' =>\n                                              \"Statistics_frame$frame\\_$type\",\n                                            'Data' => shift @fields\n                                        }\n                                    );\n                                }\n                            }\n                            else {\n                                my ( $frameo, $matid, $matrix, @fields ) =\n                                  split;\n                                if ( !defined $frame ) {\n\n                                    # keep some sort of default feature I guess\n                                    # even though this is sort of wrong\n                                    $self->element(\n                                        {\n                                            'Name' => 'Parameters_matrix',\n                                            'Data' => $matrix\n                                        }\n                                    );\n                                    $self->element(\n                                        {\n                                            'Name' => 'Statistics_lambda',\n                                            'Data' => $fields[0]\n                                        }\n                                    );\n                                    $self->element(\n                                        {\n                                            'Name' => 'Statistics_kappa',\n                                            'Data' => $fields[1]\n                                        }\n                                    );\n                                    $self->element(\n                                        {\n                                            'Name' => 'Statistics_entropy',\n                                            'Data' => $fields[2]\n                                        }\n                                    );\n                                }\n                                $frame = $frameo;\n                                my $ii = 0;\n                                for my $type (\n                                    qw(lambda_used\n                                    kappa_used\n                                    entropy_used\n                                    lambda_computed\n                                    kappa_computed\n                                    entropy_computed)\n                                  )\n                                {\n                                    my $f = $fields[$ii];\n                                    next unless defined $f;    # deal with n/a\n                                    if ( $f eq 'same' ) {\n                                        $f = $fields[ $ii - 3 ];\n                                    }\n                                    $ii++;\n                                    $self->element(\n                                        {\n                                            'Name' =>\n                                              \"Statistics_frame$frame\\_$type\",\n                                            'Data' => $f\n                                        }\n                                    );\n\n                                }\n                            }\n\n                            # get the next line\n                            $_ = $self->_readline;\n                        }\n                        $last = $_;\n                    }\n                    elsif ( $last =~ /(Frame|Strand)\\s+MatID\\s+Length/i ) {\n                        my $frame = undef;\n                        while ( defined($_) && !/^\\s+/ ) {\n                            s/^\\s+//;\n                            s/\\s+$//;\n                            my @fields = split;\n                            if ( @fields <= 3 ) {\n                                for my $type (qw(X_gapped E2_gapped S2)) {\n                                    last unless @fields;\n                                    $self->element(\n                                        {\n                                            'Name' =>\n                                              \"Statistics_frame$frame\\_$type\",\n                                            'Data' => shift @fields\n                                        }\n                                    );\n                                }\n                            }\n                            else {\n\n                                for my $type (\n                                    qw(length\n                                    efflength\n                                    E S W T X E2 S2)\n                                  )\n                                {\n                                    $self->element(\n                                        {\n                                            'Name' =>\n                                              \"Statistics_frame$frame\\_$type\",\n                                            'Data' => shift @fields\n                                        }\n                                    );\n                                }\n                            }\n                            $_ = $self->_readline;\n                        }\n                        $last = $_;\n                    }\n                    elsif (/(\\S+\\s+\\S+)\\s+DFA:\\s+(\\S+)\\s+\\((.+)\\)/) {\n                        if ( $1 eq 'states in' ) {\n                            $self->element(\n                                {\n                                    'Name' => 'Statistics_DFA_states',\n                                    'Data' => \"$2 $3\"\n                                }\n                            );\n                        }\n                        elsif ( $1 eq 'size of' ) {\n                            $self->element(\n                                {\n                                    'Name' => 'Statistics_DFA_size',\n                                    'Data' => \"$2 $3\"\n                                }\n                            );\n                        }\n                    }\n                    elsif (\n                        m/^\\s+Time to generate neighborhood:\\s+\n\t\t\t    (\\S+\\s+\\S+\\s+\\S+)/x\n                      )\n                    {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_neighbortime',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (/processors\\s+used:\\s+(\\d+)/) {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_noprocessors',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (\n                        m/^\\s+(\\S+)\\s+cpu\\s+time:\\s+# cputype\n\t\t\t    (\\S+\\s+\\S+\\s+\\S+)           # cputime\n\t\t\t    \\s+Elapsed:\\s+(\\S+)/x\n                      )\n                    {\n                        my $cputype = lc($1);\n                        $self->element(\n                            {\n                                'Name' => \"Statistics_$cputype\\_cputime\",\n                                'Data' => $2\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => \"Statistics_$cputype\\_actualtime\",\n                                'Data' => $3\n                            }\n                        );\n                    }\n                    elsif (/^\\s+Start:/) {\n                        my ( $junk, $start, $stime, $end, $etime ) =\n                          split( /\\s+(Start|End)\\:\\s+/, $_ );\n                        chomp($stime);\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_starttime',\n                                'Data' => $stime\n                            }\n                        );\n                        chomp($etime);\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_endtime',\n                                'Data' => $etime\n                            }\n                        );\n                    }\n                    elsif (/^\\s+Database:\\s+(.+)$/) {\n                        $self->element(\n                            {\n                                'Name' => 'Parameters_full_dbpath',\n                                'Data' => $1\n                            }\n                        );\n\n                    }\n                    elsif (/^\\s+Posted:\\s+(.+)/) {\n                        my $d = $1;\n                        chomp($d);\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_posted_date',\n                                'Data' => $d\n                            }\n                        );\n                    }\n                }\n                elsif ( $blast eq 'ncbi' ) {\n\n                    if (m/^Matrix:\\s+(.+)\\s*$/oxi) {\n                        $self->element(\n                            {\n                                'Name' => 'Parameters_matrix',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (/^Gapped/) {\n                        $gapped_stats = 1;\n                    }\n                    elsif (/^Lambda/) {\n                        $_ = $self->_readline;\n                        s/^\\s+//;\n                        my ( $lambda, $kappa, $entropy ) = split;\n                        if ($gapped_stats) {\n                            $self->element(\n                                {\n                                    'Name' => \"Statistics_gapped_lambda\",\n                                    'Data' => $lambda\n                                }\n                            );\n                            $self->element(\n                                {\n                                    'Name' => \"Statistics_gapped_kappa\",\n                                    'Data' => $kappa\n                                }\n                            );\n                            $self->element(\n                                {\n                                    'Name' => \"Statistics_gapped_entropy\",\n                                    'Data' => $entropy\n                                }\n                            );\n                        }\n                        else {\n                            $self->element(\n                                {\n                                    'Name' => \"Statistics_lambda\",\n                                    'Data' => $lambda\n                                }\n                            );\n                            $self->element(\n                                {\n                                    'Name' => \"Statistics_kappa\",\n                                    'Data' => $kappa\n                                }\n                            );\n                            $self->element(\n                                {\n                                    'Name' => \"Statistics_entropy\",\n                                    'Data' => $entropy\n                                }\n                            );\n                        }\n                    }\n                    elsif (m/effective\\s+search\\s+space\\s+used:\\s+(\\d+)/ox) {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_eff-spaceused',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (m/effective\\s+search\\s+space:\\s+(\\d+)/ox) {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_eff-space',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (\n                        m/Gap\\s+Penalties:\\s+Existence:\\s+(\\d+)\\,\n\t\t\t    \\s+Extension:\\s+(\\d+)/ox\n                      )\n                    {\n                        $self->element(\n                            {\n                                'Name' => 'Parameters_gap-open',\n                                'Data' => $1\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Parameters_gap-extend',\n                                'Data' => $2\n                            }\n                        );\n                    }\n                    elsif (/effective\\s+HSP\\s+length:\\s+(\\d+)/) {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_hsp-len',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (/effective\\s+length\\s+of\\s+query:\\s+([\\d\\,]+)/) {\n                        my $c = $1;\n                        $c =~ s/\\,//g;\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_query-len',\n                                'Data' => $c\n                            }\n                        );\n                    }\n                    elsif (/effective\\s+length\\s+of\\s+database:\\s+([\\d\\,]+)/) {\n                        my $c = $1;\n                        $c =~ s/\\,//g;\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_eff-dblen',\n                                'Data' => $c\n                            }\n                        );\n                    }\n                    elsif (\n/^(T|A|X1|X2|X3|S1|S2):\\s+(\\d+(\\.\\d+)?)\\s+(?:\\(\\s*(\\d+\\.\\d+) bits\\))?/\n                      )\n                    {\n                        my $v = $2;\n                        chomp($v);\n                        $self->element(\n                            {\n                                'Name' => \"Statistics_$1\",\n                                'Data' => $v\n                            }\n                        );\n                        if ( defined $4 ) {\n                            $self->element(\n                                {\n                                    'Name' => \"Statistics_$1_bits\",\n                                    'Data' => $4\n                                }\n                            );\n                        }\n                    }\n                    elsif (\n                        m/frameshift\\s+window\\,\n\t\t\t    \\s+decay\\s+const:\\s+(\\d+)\\,\\s+([\\.\\d]+)/x\n                      )\n                    {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_framewindow',\n                                'Data' => $1\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_decay',\n                                'Data' => $2\n                            }\n                        );\n                    }\n                    elsif (m/^Number\\s+of\\s+Hits\\s+to\\s+DB:\\s+(\\S+)/ox) {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_hit_to_db',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (m/^Number\\s+of\\s+extensions:\\s+(\\S+)/ox) {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_num_extensions',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (\n                        m/^Number\\s+of\\s+successful\\s+extensions:\\s+\n\t\t\t    (\\S+)/ox\n                      )\n                    {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_num_suc_extensions',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (\n                        m/^Number\\s+of\\s+sequences\\s+better\\s+than\\s+\n\t\t\t    (\\S+):\\s+(\\d+)/ox\n                      )\n                    {\n                        $self->element(\n                            {\n                                'Name' => 'Parameters_expect',\n                                'Data' => $1\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_seqs_better_than_cutoff',\n                                'Data' => $2\n                            }\n                        );\n                    }\n                    elsif (/^\\s+Posted\\s+date:\\s+(.+)/) {\n                        my $d = $1;\n                        chomp($d);\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_posted_date',\n                                'Data' => $d\n                            }\n                        );\n                    }\n                    elsif ( !/^\\s+$/ ) {\n                        #$self->debug( \"unmatched stat $_\");\n                    }\n                }\n                $last = $_;\n            }\n        } elsif ( $self->in_element('hsp') ) {\n            $self->debug(\"blast.pm: Processing HSP\\n\");\n            # let's read 3 lines at a time;\n            # bl2seq hackiness... Not sure I like\n            $self->{'_reporttype'} ||= $DEFAULTREPORTTYPE;\n            my %data = (\n                'Query' => '',\n                'Mid'   => '',\n                'Hit'   => ''\n            );\n            my $len;\n            for ( my $i = 0 ; defined($_) && $i < 3 ; $i++ ) {\n                # $self->debug(\"$i: $_\") if $v;\n                if ( ( $i == 0 && /^\\s+$/) || \n\t\t     /^\\s*(?:Lambda|Minus|Plus|Score)/i )\n                {\n                    $self->_pushback($_) if defined $_;\n                    $self->end_element( { 'Name' => 'Hsp' } );\n                    last;\n                }\n                chomp;\n                if (/^((Query|Sbjct):?\\s+(\\-?\\d+)\\s*)(\\S+)\\s+(\\-?\\d+)/) {\n                    my ( $full, $type, $start, $str, $end ) =\n                      ( $1, $2, $3, $4, $5 );\n\n                    if ( $str eq '-' ) {\n                        $i = 3 if $type eq 'Sbjct';\n                    }\n                    else {\n                        $data{$type} = $str;\n                    }\n                    $len = length($full);\n                    $self->{\"\\_$type\"}->{'begin'} = $start\n                      unless $self->{\"_$type\"}->{'begin'};\n                    $self->{\"\\_$type\"}->{'end'} = $end;\n                } else {\n                    $self->throw(\"no data for midline $_\")\n                      unless ( defined $_ && defined $len );\n                    $data{'Mid'} = substr( $_, $len );\n                }\n                $_ = $self->_readline();\n            }\n            $self->characters(\n                {\n                    'Name' => 'Hsp_qseq',\n                    'Data' => $data{'Query'}\n                }\n            );\n            $self->characters(\n                {\n                    'Name' => 'Hsp_hseq',\n                    'Data' => $data{'Sbjct'}\n                }\n            );\n            $self->characters(\n                {\n                    'Name' => 'Hsp_midline',\n                    'Data' => $data{'Mid'}\n                }\n            );\n        }\n        else {\n            #$self->debug(\"blast.pm: unrecognized line $_\");\n        }\n    }\n\n    $self->debug(\"blast.pm: End of BlastOutput\\n\");\n    if ( $self->{'_seentop'} ) {\n        $self->within_element('hsp')\n          && $self->end_element( { 'Name' => 'Hsp' } );\n        $self->within_element('hit')\n          && $self->end_element( { 'Name' => 'Hit' } );\n        # cleanup extra hits\n        $self->_cleanup_hits(\\@hit_signifs) if scalar(@hit_signifs);\n        $self->within_element('iteration')\n          && $self->end_element( { 'Name' => 'Iteration' } );\n        if ($bl2seq_fix) {\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_program',\n                    'Data' => $reporttype\n                }\n            );\n        }\n        $self->end_element( { 'Name' => 'BlastOutput' } );\n    }\n    return $self->end_document();\n}\n\n# Private method for internal use only.\nsub _start_blastoutput {\n    my $self = shift;\n    $self->start_element( { 'Name' => 'BlastOutput' } );\n    $self->{'_seentop'} = 1;\n    $self->{'_result_count'}++;\n    $self->{'_handler_rc'} = undef;\n}\n\n=head2 _will_handle\n\n Title   : _will_handle\n Usage   : Private method. For internal use only.\n              if( $self->_will_handle($type) ) { ... }\n Function: Provides an optimized way to check whether or not an element of a \n           given type is to be handled.\n Returns : Reference to EventHandler object if the element type is to be handled.\n           undef if the element type is not to be handled.\n Args    : string containing type of element.\n\nOptimizations:\n\n=over 2\n\n* 1\n\nUsing the cached pointer to the EventHandler to minimize repeated\nlookups.\n\n* 2\n\nCaching the will_handle status for each type that is encountered so\nthat it only need be checked by calling\nhandler-E<gt>will_handle($type) once.\n\n\nThis does not lead to a major savings by itself (only 5-10%).  In\ncombination with other optimizations, or for large parse jobs, the\nsavings good be significant.\n\nTo test against the unoptimized version, remove the parentheses from\naround the third term in the ternary \" ? : \" operator and add two\ncalls to $self-E<gt>_eventHandler().","parameters":[{"label":"$self"},{"label":"$type"}]}},{"name":"start_element","range":{"end":{"character":9999,"line":1959},"start":{"character":0,"line":1926}},"kind":12,"children":[{"kind":13,"line":1927,"definition":"my","name":"$self","containerName":"start_element","localvar":"my"},{"containerName":"start_element","name":"$data","line":1927,"kind":13},{"localvar":"my","containerName":"start_element","name":"$nm","definition":"my","line":1930,"kind":13},{"kind":13,"line":1930,"name":"$data","containerName":"start_element"},{"kind":13,"line":1931,"definition":"my","name":"$type","containerName":"start_element","localvar":"my"},{"line":1931,"kind":13,"containerName":"start_element","name":"$MODEMAP"},{"containerName":"start_element","name":"$nm","kind":13,"line":1931},{"containerName":"start_element","name":"$type","kind":13,"line":1932},{"localvar":"my","definition":"my","name":"$handler","containerName":"start_element","line":1933,"kind":13},{"name":"$self","containerName":"start_element","line":1933,"kind":13},{"kind":12,"line":1933,"name":"_will_handle","containerName":"start_element"},{"containerName":"start_element","name":"$type","kind":13,"line":1933},{"name":"$handler","containerName":"start_element","line":1934,"kind":13},{"kind":13,"line":1935,"containerName":"start_element","definition":"my","name":"$func","localvar":"my"},{"kind":13,"line":1935,"name":"$type","containerName":"start_element"},{"kind":13,"line":1936,"name":"$self","containerName":"start_element"},{"containerName":"start_element","name":"$handler","line":1936,"kind":13},{"line":1936,"kind":13,"containerName":"start_element","name":"$func"},{"name":"$data","containerName":"start_element","line":1936,"kind":13},{"kind":13,"line":1944,"containerName":"start_element","name":"$self"},{"kind":13,"line":1944,"name":"$type","containerName":"start_element"},{"name":"$type","containerName":"start_element","line":1945,"kind":13},{"name":"$self","containerName":"start_element","kind":13,"line":1946},{"name":"$self","containerName":"start_element","line":1947,"kind":13},{"line":1950,"kind":13,"name":"$self","containerName":"start_element"},{"localvar":"my","name":"$k","definition":"my","containerName":"start_element","line":1951,"kind":13},{"name":"$self","containerName":"start_element","line":1953,"kind":13},{"containerName":"start_element","name":"$self","kind":13,"line":1956},{"name":"$k","containerName":"start_element","line":1956,"kind":13}],"line":1926,"definition":"sub","containerName":"main::","signature":{"label":"start_element($self,$data)","documentation":"(Sesame Street aficionados note: This answer was NOT given by Mr. Noodle ;-P)\n# $Id: blast.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::blast\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n# 20030409 - sac\n#          PSI-BLAST full parsing support. Rollout of new\n#          model which will remove Steve's old psiblast driver\n# 20030424 - jason\n#          Megablast parsing fix as reported by Neil Saunders\n# 20030427 - jason\n#          Support bl2seq parsing\n# 20031124 - jason\n#          Parse more blast statistics, lambda, entropy, etc\n#          from WU-BLAST in frame-specific manner\n# 20060216 - cjf - fixed blast parsing for BLAST v2.2.13 output\n# 20071104 - dmessina - added support for WUBLAST -echofilter\n# 20071121 - cjf - fixed several bugs (bugs 2391, 2399, 2409)\n\n=head1 NAME\n\nBio::SearchIO::blast - Event generator for event based parsing of\nblast reports\n\n=head1 SYNOPSIS\n\n   # Do not use this object directly - it is used as part of the\n   # Bio::SearchIO system.\n\n    use Bio::SearchIO;\n    my $searchio = Bio::SearchIO->new(-format => 'blast',\n                                     -file   => 't/data/ecolitst.bls');\n    while( my $result = $searchio->next_result ) {\n        while( my $hit = $result->next_hit ) {\n            while( my $hsp = $hit->next_hsp ) {\n                # ...\n            }\n        }\n    }\n\n=head1 DESCRIPTION\n\nThis object encapsulated the necessary methods for generating events\nsuitable for building Bio::Search objects from a BLAST report file.\nRead the L<Bio::SearchIO> for more information about how to use this.\n\nThis driver can parse:\n\n=over 4\n\n* * \n\nNCBI produced plain text BLAST reports from blastall, this also\nincludes PSIBLAST, PSITBLASTN, RPSBLAST, and bl2seq reports.  NCBI XML\nBLAST output is parsed with the blastxml SearchIO driver\n\n* *\n\nWU-BLAST all reports\n\n* *\n\nJim Kent's BLAST-like output from his programs (BLASTZ, BLAT)\n\n* *\n\nBLAST-like output from Paracel BTK output\n\n\n=head2 bl2seq parsing\n\nSince I cannot differentiate between BLASTX and TBLASTN since bl2seq\ndoesn't report the algorithm used - I assume it is BLASTX by default -\nyou can supply the program type with -report_type in the SearchIO\nconstructor i.e.\n\n  my $parser = Bio::SearchIO->new(-format => 'blast',\n                                 -file => 'bl2seq.tblastn.report',\n                                 -report_type => 'tblastn');\n\nThis only really affects where the frame and strand information are\nput - they will always be on the $hsp-E<gt>query instead of on the\n$hsp-E<gt>hit part of the feature pair for blastx and tblastn bl2seq\nproduced reports.  Hope that's clear...\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail Jason Stajich jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nSteve Chervitz sac-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...'\n\npackage Bio::SearchIO::blast;\n\nuse Bio::SearchIO::IteratedSearchResultEventBuilder;\nuse strict;\nuse vars qw(%MAPPING %MODEMAP\n  $DEFAULT_BLAST_WRITER_CLASS\n  $MAX_HSP_OVERLAP\n  $DEFAULT_SIGNIF\n  $DEFAULT_SCORE\n  $DEFAULTREPORTTYPE\n);\n\n\nuse base qw(Bio::SearchIO);\nuse Data::Dumper;\n\nBEGIN {\n\n    # mapping of NCBI Blast terms to Bioperl hash keys\n    %MODEMAP = (\n        'BlastOutput' => 'result',\n        'Iteration'   => 'iteration',\n        'Hit'         => 'hit',\n        'Hsp'         => 'hsp'\n    );\n\n    # This should really be done more intelligently, like with\n    # XSLT\n\n    %MAPPING = (\n        'Hsp_bit-score'   => 'HSP-bits',\n        'Hsp_score'       => 'HSP-score',\n        'Hsp_evalue'      => 'HSP-evalue',\n        'Hsp_n',          => 'HSP-n',\n        'Hsp_pvalue'      => 'HSP-pvalue',\n        'Hsp_query-from'  => 'HSP-query_start',\n        'Hsp_query-to'    => 'HSP-query_end',\n        'Hsp_hit-from'    => 'HSP-hit_start',\n        'Hsp_hit-to'      => 'HSP-hit_end',\n        'Hsp_positive'    => 'HSP-conserved',\n        'Hsp_identity'    => 'HSP-identical',\n        'Hsp_gaps'        => 'HSP-hsp_gaps',\n        'Hsp_hitgaps'     => 'HSP-hit_gaps',\n        'Hsp_querygaps'   => 'HSP-query_gaps',\n        'Hsp_qseq'        => 'HSP-query_seq',\n        'Hsp_hseq'        => 'HSP-hit_seq',\n        'Hsp_midline'     => 'HSP-homology_seq',\n        'Hsp_align-len'   => 'HSP-hsp_length',\n        'Hsp_query-frame' => 'HSP-query_frame',\n        'Hsp_hit-frame'   => 'HSP-hit_frame',\n        'Hsp_links'       => 'HSP-links',\n        'Hsp_group'       => 'HSP-hsp_group',\n        'Hsp_features'    => 'HSP-hit_features',\n\n        'Hit_id'        => 'HIT-name',\n        'Hit_len'       => 'HIT-length',\n        'Hit_accession' => 'HIT-accession',\n        'Hit_def'       => 'HIT-description',\n        'Hit_signif'    => 'HIT-significance',\n        # For NCBI blast, the description line contains bits.\n        # For WU-blast, the  description line contains score.\n        'Hit_score' => 'HIT-score',\n        'Hit_bits'  => 'HIT-bits',\n\n        'Iteration_iter-num'  => 'ITERATION-number',\n        'Iteration_converged' => 'ITERATION-converged',\n\n        'BlastOutput_program'             => 'RESULT-algorithm_name',\n        'BlastOutput_version'             => 'RESULT-algorithm_version',\n        'BlastOutput_query-def'           => 'RESULT-query_name',\n        'BlastOutput_query-len'           => 'RESULT-query_length',\n        'BlastOutput_query-acc'           => 'RESULT-query_accession',\n        'BlastOutput_query-gi'            => 'RESULT-query_gi',\n        'BlastOutput_querydesc'           => 'RESULT-query_description',\n        'BlastOutput_db'                  => 'RESULT-database_name',\n        'BlastOutput_db-len'              => 'RESULT-database_entries',\n        'BlastOutput_db-let'              => 'RESULT-database_letters',\n        'BlastOutput_inclusion-threshold' => 'RESULT-inclusion_threshold',\n\n        'Parameters_matrix'      => { 'RESULT-parameters' => 'matrix' },\n        'Parameters_expect'      => { 'RESULT-parameters' => 'expect' },\n        'Parameters_include'     => { 'RESULT-parameters' => 'include' },\n        'Parameters_sc-match'    => { 'RESULT-parameters' => 'match' },\n        'Parameters_sc-mismatch' => { 'RESULT-parameters' => 'mismatch' },\n        'Parameters_gap-open'    => { 'RESULT-parameters' => 'gapopen' },\n        'Parameters_gap-extend'  => { 'RESULT-parameters' => 'gapext' },\n        'Parameters_filter'      => { 'RESULT-parameters' => 'filter' },\n        'Parameters_allowgaps'   => { 'RESULT-parameters' => 'allowgaps' },\n        'Parameters_full_dbpath' => { 'RESULT-parameters' => 'full_dbpath' },\n        'Statistics_db-len'      => { 'RESULT-statistics' => 'dbentries' },\n        'Statistics_db-let'      => { 'RESULT-statistics' => 'dbletters' },\n        'Statistics_hsp-len'     =>\n          { 'RESULT-statistics' => 'effective_hsplength' },\n        'Statistics_query-len' => { 'RESULT-statistics' => 'querylength' },\n        'Statistics_eff-space' => { 'RESULT-statistics' => 'effectivespace' },\n        'Statistics_eff-spaceused' =>\n          { 'RESULT-statistics' => 'effectivespaceused' },\n        'Statistics_eff-dblen' =>\n          { 'RESULT-statistics' => 'effectivedblength' },\n        'Statistics_kappa'         => { 'RESULT-statistics' => 'kappa' },\n        'Statistics_lambda'        => { 'RESULT-statistics' => 'lambda' },\n        'Statistics_entropy'       => { 'RESULT-statistics' => 'entropy' },\n        'Statistics_gapped_kappa'  => { 'RESULT-statistics' => 'kappa_gapped' },\n        'Statistics_gapped_lambda' =>\n          { 'RESULT-statistics' => 'lambda_gapped' },\n        'Statistics_gapped_entropy' =>\n          { 'RESULT-statistics' => 'entropy_gapped' },\n\n        'Statistics_framewindow' =>\n          { 'RESULT-statistics' => 'frameshiftwindow' },\n        'Statistics_decay' => { 'RESULT-statistics' => 'decayconst' },\n\n        'Statistics_hit_to_db' => { 'RESULT-statistics' => 'Hits_to_DB' },\n        'Statistics_num_suc_extensions' =>\n          { 'RESULT-statistics' => 'num_successful_extensions' },\n\n        # WU-BLAST stats\n        'Statistics_DFA_states' => { 'RESULT-statistics' => 'num_dfa_states' },\n        'Statistics_DFA_size'   => { 'RESULT-statistics' => 'dfa_size' },\n        'Statistics_noprocessors' =>\n          { 'RESULT-statistics' => 'no_of_processors' },\n        'Statistics_neighbortime' =>\n          { 'RESULT-statistics' => 'neighborhood_generate_time' },\n        'Statistics_starttime' => { 'RESULT-statistics' => 'start_time' },\n        'Statistics_endtime'   => { 'RESULT-statistics' => 'end_time' },\n    );\n\n    # add WU-BLAST Frame-Based Statistics\n    for my $frame ( 0 .. 3 ) {\n        for my $strand ( '+', '-' ) {\n            for my $ind (\n                qw(length efflength E S W T X X_gapped E2\n                E2_gapped S2)\n              )\n            {\n                $MAPPING{\"Statistics_frame$strand$frame\\_$ind\"} =\n                  { 'RESULT-statistics' => \"Frame$strand$frame\\_$ind\" };\n            }\n            for my $val (qw(lambda kappa entropy )) {\n                for my $type (qw(used computed gapped)) {\n                    my $key = \"Statistics_frame$strand$frame\\_$val\\_$type\";\n                    my $val =\n                      { 'RESULT-statistics' =>\n                          \"Frame$strand$frame\\_$val\\_$type\" };\n                    $MAPPING{$key} = $val;\n                }\n            }\n        }\n    }\n\n    # add Statistics\n    for my $stats (\n        qw(T A X1 X2 X3 S1 S2 X1_bits X2_bits X3_bits\n        S1_bits S2_bits  num_extensions\n        num_successful_extensions\n        seqs_better_than_cutoff\n        posted_date\n        search_cputime total_cputime\n        search_actualtime total_actualtime\n        no_of_processors ctxfactor)\n      )\n    {\n        my $key = \"Statistics_$stats\";\n        my $val = { 'RESULT-statistics' => $stats };\n        $MAPPING{$key} = $val;\n    }\n\n    # add WU-BLAST Parameters\n    for my $param (\n        qw(span span1 span2 links warnings notes hspsepsmax\n        hspsepqmax topcomboN topcomboE postsw cpus wordmask\n        filter sort_by_pvalue sort_by_count sort_by_highscore\n        sort_by_totalscore sort_by_subjectlength noseqs gi qtype\n        qres V B Z Y M N)\n      )\n    {\n        my $key = \"Parameters_$param\";\n        my $val = { 'RESULT-parameters' => $param };\n        $MAPPING{$key} = $val;\n    }\n\n    $DEFAULT_BLAST_WRITER_CLASS = 'Bio::Search::Writer::HitTableWriter';\n    $MAX_HSP_OVERLAP   = 2;           # Used when tiling multiple HSPs.\n    $DEFAULTREPORTTYPE = 'BLASTP';    # for bl2seq\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::blast->new(%args);\n Function: Builds a new Bio::SearchIO::blast object \n Returns : Bio::SearchIO::blast\n Args    : Key-value pairs:\n           -fh/-file => filehandle/filename to BLAST file\n           -format   => 'blast'\n           -report_type => 'blastx', 'tblastn', etc -- only for bl2seq\n                           reports when you want to distinguish between\n                           tblastn and blastx reports (this only controls\n                           where the frame information is put - on the query\n                           or subject object.\n           -inclusion_threshold => e-value threshold for inclusion in the\n                                   PSI-BLAST score matrix model (blastpgp)\n           -signif      => float or scientific notation number to be used\n                           as a P- or Expect value cutoff\n           -score       => integer or scientific notation number to be used\n                           as a blast score value cutoff\n           -bits        => integer or scientific notation number to be used\n                           as a bit score value cutoff\n           -hit_filter  => reference to a function to be used for\n                           filtering hits based on arbitrary criteria.\n                           All hits of each BLAST report must satisfy \n                           this criteria to be retained. \n                           If a hit fails this test, it is ignored.\n                           This function should take a\n                           Bio::Search::Hit::BlastHit.pm object as its first\n                           argument and return true\n                           if the hit should be retained.\n                           Sample filter function:\n                              -hit_filter => sub { $hit = shift;\n                                                   $hit->gaps == 0; },\n                           (Note: -filt_func is synonymous with -hit_filter)\n           -overlap     => integer. The amount of overlap to permit between\n                           adjacent HSPs when tiling HSPs. A reasonable value is 2.\n                           Default = $Bio::SearchIO::blast::MAX_HSP_OVERLAP.\n\n            The following criteria are not yet supported:\n            (these are probably best applied within this module rather than in the \n             event handler since they would permit the parser to take some shortcuts.)\n\n           -check_all_hits => boolean. Check all hits for significance against\n                              significance criteria.  Default = false.\n                              If false, stops processing hits after the first\n                              non-significant hit or the first hit that fails\n                              the hit_filter call. This speeds parsing,\n                              taking advantage of the fact that the hits\n                              are processed in the order they appear in the report.\n           -min_query_len => integer to be used as a minimum for query sequence length.\n                             Reports with query sequences below this length will\n                             not be processed. Default = no minimum length.\n           -best        => boolean. Only process the best hit of each report;\n                           default = false.\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n\n    # Blast reports require a specialized version of the SREB due to the\n    # possibility of iterations (PSI-BLAST). Forwarding all arguments to it. An\n    # issue here is that we want to set new default object factories if none are\n    # supplied.\n\n    my $handler = Bio::SearchIO::IteratedSearchResultEventBuilder->new(@args);\n    $self->attach_EventHandler($handler);\n    \n    # 2006-04-26 move this to the attach_handler function in this module so we\n    # can really reset the handler \n    # Optimization: caching\n    # the EventHandler since it is used a lot during the parse.\n    \n    # $self->{'_handler_cache'} = $handler;\n\n    my ( $min_qlen, $check_all, $overlap, $best, $rpttype ) = $self->_rearrange(\n        [\n            qw(MIN_LENGTH CHECK_ALL_HITS\n              OVERLAP BEST\n              REPORT_TYPE)\n        ],\n        @args\n    );\n\n    defined $min_qlen  && $self->min_query_length($min_qlen);\n    defined $best      && $self->best_hit_only($best);\n    defined $check_all && $self->check_all_hits($check_all);\n    defined $rpttype   && ( $self->{'_reporttype'} = $rpttype );\n}\n\nsub attach_EventHandler {\n    my ($self,$handler) = @_;\n\n    $self->SUPER::attach_EventHandler($handler);    \n\n    # Optimization: caching the EventHandler since it is used a lot\n    # during the parse.\n\n    $self->{'_handler_cache'} = $handler;\n    return;\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    my $v      = $self->verbose;\n    my $data   = '';\n    my $flavor = '';\n    $self->{'_seentop'} = 0;     # start next report at top\n    $self->{'_seentop'} = 0;\n    my ( $reporttype, $seenquery, $reportline );  \n    my ( $seeniteration, $found_again );\n    my $incl_threshold = $self->inclusion_threshold;\n    my $bl2seq_fix;\n    $self->start_document();  # let the fun begin...\n    my (@hit_signifs);\n    my $gapped_stats = 0;    # for switching between gapped/ungapped\n                             # lambda, K, H\n    local $_ = \"\\n\";   #consistency\n    PARSER:\n    while ( defined( $_ = $self->_readline ) ) {\n        next if (/^\\s+$/);       # skip empty lines\n        next if (/CPU time:/);\n        next if (/^>\\s*$/);\n        if (\n               /^((?:\\S+?)?BLAST[NPX]?)\\s+(.+)$/i  # NCBI BLAST, PSIBLAST\n                                                   # RPSBLAST, MEGABLAST\n            || /^(P?GENEWISE|HFRAME|SWN|TSWN)\\s+(.+)/i    #Paracel BTK\n          )\n        {\n            ($reporttype, my $reportversion) = ($1, $2);\n            # need to keep track of whether this is WU-BLAST\n            if ($reportversion && $reportversion =~ m{WashU$}) {\n                $self->{'_wublast'}++;\n            }\n            $self->debug(\"blast.pm: Start of new report: $reporttype, $reportversion\\n\");\n            if ( $self->{'_seentop'} ) { \n                # This handles multi-result input streams\n                $self->_pushback($_);\n                last PARSER;\n            }\n            $self->_start_blastoutput;\n            if ($reporttype =~ /RPS-BLAST/) {\n                $reporttype .= '(BLASTP)'; # default RPS-BLAST type\n            }\n            $reportline = $_;   # to fix the fact that RPS-BLAST output is wrong\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_program',\n                    'Data' => $reporttype\n                }\n            );\n\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_version',\n                    'Data' => $reportversion\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_inclusion-threshold',\n                    'Data' => $incl_threshold\n                }\n            );\n        }\n        # added Windows workaround for bug 1985\n        elsif (/^(Searching|Results from round)/) { \n            next unless $1 =~ /Results from round/; \n            $self->debug(\"blast.pm: Possible psi blast iterations found...\\n\");\n            \n            $self->in_element('hsp')\n              && $self->end_element( { 'Name' => 'Hsp' } );\n            $self->in_element('hit')\n              && $self->end_element( { 'Name' => 'Hit' } );\n            if ( defined $seeniteration ) {\n                $self->within_element('iteration')\n                  && $self->end_element( { 'Name' => 'Iteration' } );\n                $self->start_element( { 'Name' => 'Iteration' } );\n            }\n            else {\n                $self->start_element( { 'Name' => 'Iteration' } );\n            }\n            $seeniteration = 1;\n        }\n        elsif (/^Query=\\s*(.*)$/) {\n            my $q    = $1;\n            $self->debug(\"blast.pm: Query= found...$_\\n\");\n            my $size = 0;\n            if ( defined $seenquery ) {\n                $self->_pushback($reportline) if $reportline;\n                $self->_pushback($_);\n                last PARSER;\n            }\n            else {\n                if ( !defined $reporttype ) {\n                    $self->_start_blastoutput;\n                    if ( defined $seeniteration ) {\n                        $self->in_element('iteration')\n                          && $self->end_element( { 'Name' => 'Iteration' } );\n                        $self->start_element( { 'Name' => 'Iteration' } );\n                    }\n                    else {\n                        $self->start_element( { 'Name' => 'Iteration' } );\n                    }\n                    $seeniteration = 1;\n                }\n            }\n            $seenquery = $q;\n            $_ = $self->_readline;\n            while ( defined($_) ) {\n                if (/^Database:/) {\n                    $self->_pushback($_);\n                    last;\n                }\n                # below line fixes length issue with BLAST v2.2.13; still works \n                # with BLAST v2.2.12\n                if ( /\\((\\-?[\\d,]+)\\s+letters.*\\)/ || /^Length=(\\-?[\\d,]+)/ ) {\n                    $size = $1;\n                    $size =~ s/,//g;\n                    last;\n                }\n                else {\n                    # bug 2391\n                    $q .= ($q =~ /\\w$/ && $_ =~ /^\\w/) ? \" $_\" : $_;\n                    $q =~ s/\\s+/ /g; # this catches the newline as well\n                    $q =~ s/^ | $//g;\n                }\n\n                $_ = $self->_readline;\n            }\n            chomp($q);\n            my ( $nm, $desc ) = split( /\\s+/, $q, 2 );\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_query-def',\n                    'Data' => $nm\n                }\n            ) if $nm;\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_query-len',\n                    'Data' => $size\n                }\n            );\n            defined $desc && $desc =~ s/\\s+$//;\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_querydesc',\n                    'Data' => $desc\n                }\n            );\n            my ( $gi, $acc, $version ) = $self->_get_seq_identifiers($nm);\n            $version = defined($version) && length($version) ? \".$version\" : \"\";\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_query-acc',\n                    'Data' => \"$acc$version\"\n                }\n            ) if $acc;\n        }\n\t\t# added check for WU-BLAST -echofilter option (bug 2388)\n\t\telsif (/^>Unfiltered[+-]1$/) {\n        \t# skip all of the lines of unfiltered sequence\n\t\t\twhile($_ !~ /^Database:/) {\n\t\t\t\t$self->debug(\"Bypassing features line: $_\");\n        \t\t$_ = $self->_readline;\n        \t}\n\t\t\t$self->_pushback($_);\n\t\t}\n        elsif (/Sequences producing significant alignments:/) {\n            $self->debug(\"blast.pm: Processing NCBI-BLAST descriptions\\n\");\n            $flavor = 'ncbi';\n            \n            # PSI-BLAST parsing needs to be fixed to specifically look\n            # for old vs new per iteration, as sorting based on duplication\n            # leads to bugs, see bug 1986\n            \n            # The next line is not necessarily whitespace in psiblast reports.\n            # Also note that we must look for the end of this section by testing\n            # for a line with a leading >. Blank lines occur with this section\n            # for psiblast.\n            if ( !$self->in_element('iteration') ) {\n                $self->start_element( { 'Name' => 'Iteration' } );\n            }\n            # these elements are dropped with some multiquery reports; add\n            # back here\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_db-len',\n                    'Data' => $self->{'_blsdb_length'}\n                } \n            ) if $self->{'_blsdb_length'};\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_db-let',\n                    'Data' => $self->{'_blsdb_letters'}\n                }\n            ) if $self->{'_blsdb_letters'};\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_db',\n                    'Data' => $self->{'_blsdb'}\n                }\n            ) if $self->{'_blsdb_letters'};\n            \n            # changed 8/28/2008 to exit hit table if blank line is found after an\n            # appropriate line\n            my $h_regex;\n            my $seen_block;\n          DESCLINE:\n            while ( defined( my $descline = $self->_readline() ) ) {\n                if ($descline =~ m{^\\s*$}) {\n                    last DESCLINE if $seen_block;\n                    next DESCLINE;\n                }\n                # any text match is part of block...\n                $seen_block++;\n                # GCG multiline oddness...\n                if ($descline =~ /^(\\S+)\\s+Begin:\\s\\d+\\s+End:\\s+\\d+/xms) {\n                    my ($id, $nextline) = ($1, $self->_readline);\n                    $nextline =~ s{^!}{};\n                    $descline = \"$id $nextline\";\n                }\n                # NCBI style hit table (no N)\n                if ($descline =~ /(?<!cor)          # negative lookahead\n                    (\\d*\\.?(?:[\\+\\-eE]+)?\\d+)       # number (float or scientific notation)\n                    \\s+                             # space\n                    (\\d*\\.?(?:[\\+\\-eE]+)?\\d+)       # number (float or scientific notation)\n                    \\s*$/xms) {\n                    \n                    my ( $score, $evalue ) = ($1, $2);\n                    \n                    # Some data clean-up so e-value will appear numeric to perl\n                    $evalue =~ s/^e/1e/i;\n\n                    # This to handle no-HSP case\n                    my @line = split ' ',$descline;\n                    \n                    # we want to throw away the score, evalue\n                    pop @line, pop @line;\n\n                    # and N if it is present (of course they are not\n                    # really in that order, but it doesn't matter\n                    if ($3) { pop @line }\n\n                    # add the last 2 entries s.t. we can reconstruct\n                    # a minimal Hit object at the end of the day\n                    push @hit_signifs, [ $evalue, $score, shift @line, join( ' ', @line ) ];\n                } elsif ($descline =~ /^CONVERGED/i) {\n                    $self->element(\n                        {\n                            'Name' => 'Iteration_converged',\n                            'Data' => 1\n                        }\n                    );\n                } else {\n                    $self->_pushback($descline); # Catch leading > (end of section)\n                    last DESCLINE;\n                }\n            }\n        }\n        elsif (/Sequences producing High-scoring Segment Pairs:/) {\n\n     # This block is for WU-BLAST, so we don't have to check for psi-blast stuff\n     # skip the next line\n            $self->debug(\"blast.pm: Processing WU-BLAST descriptions\\n\");\n            $_      = $self->_readline();\n            $flavor = 'wu';\n\n            if ( !$self->in_element('iteration') ) {\n                $self->start_element( { 'Name' => 'Iteration' } );\n            }\n\n            while ( defined( $_ = $self->_readline() )\n                && !/^\\s+$/ )\n            {\n                my @line = split;\n                pop @line;    # throw away first number which is for 'N'col\n\n                # add the last 2 entries to array s.t. we can reconstruct\n                # a minimal Hit object at the end of the day\n                push @hit_signifs,\n                  [ pop @line, pop @line, shift @line, join( ' ', @line ) ];\n            }\n            \n        }\n        elsif (/^Database:\\s*(.+)$/) {\n\n            $self->debug(\"blast.pm: Database: $1\\n\");\n            my $db = $1;\n            while ( defined( $_ = $self->_readline ) ) {\n                if (\n                    /^\\s+(\\-?[\\d\\,]+|\\S+)\\s+sequences\\;\n                   \\s+(\\-?[\\d,]+|\\S+)\\s+ # Deal with NCBI 2.2.8 OSX problems\n                   total\\s+letters/ox\n                  )\n                {\n                    my ( $s, $l ) = ( $1, $2 );\n                    $s =~ s/,//g;\n                    $l =~ s/,//g;\n                    $self->element(\n                        {\n                            'Name' => 'BlastOutput_db-len',\n                            'Data' => $s\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'BlastOutput_db-let',\n                            'Data' => $l\n                        }\n                    );\n                    # cache for next round in cases with multiple queries\n                    $self->{'_blsdb'} = $db;\n                    $self->{'_blsdb_length'} = $s;\n                    $self->{'_blsdb_letters'} = $l;                    \n                    last;\n                }\n                else {\n                    chomp;\n                    $db .= $_;\n                }\n            }\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_db',\n                    'Data' => $db\n                }\n            );\n        }\n        # bypasses this NCBI blast 2.2.13 extra output for now...\n\t\t# Features in/flanking this part of subject sequence:\n        elsif (/^\\sFeatures\\s\\w+\\sthis\\spart/xmso) {\n            my $featline;\n            $_ = $self->_readline;\n\t\t\twhile($_ !~ /^\\s*$/) {\n                chomp;\n                $featline .= $_;\n        \t\t$_ = $self->_readline;\n        \t}\n\t\t\t$self->_pushback($_);\n            $featline =~ s{(?:^\\s+|\\s+^)}{}g;\n            $featline =~ s{\\n}{;}g;\n            $self->{'_last_hspdata'}->{'Hsp_features'} = $featline;\n        }\n        \n        # move inside of a hit\n        elsif (/^>\\s*(\\S+)\\s*(.*)?/) {\n            chomp;\n\n            $self->debug(\"blast.pm: Hit: $1\\n\");\n            $self->in_element('hsp')\n              && $self->end_element( { 'Name' => 'Hsp' } );\n            $self->in_element('hit')\n              && $self->end_element( { 'Name' => 'Hit' } );\n\n            # special case when bl2seq reports don't have a leading\n            # Query=\n            if ( !$self->within_element('result') ) {\n                $self->_start_blastoutput;\n                $self->start_element( { 'Name' => 'Iteration' } );\n            }\n            elsif ( !$self->within_element('iteration') ) {\n                $self->start_element( { 'Name' => 'Iteration' } );\n            }\n            $self->start_element( { 'Name' => 'Hit' } );\n            my $id         = $1;\n            my $restofline = $2;\n\n            $self->debug(\"Starting a hit: $1 $2\\n\");\n            $self->element(\n                {\n                    'Name' => 'Hit_id',\n                    'Data' => $id\n                }\n            );\n            my ($gi, $acc, $version ) = $self->_get_seq_identifiers($id);\n            $self->element(\n                {\n                    'Name' => 'Hit_accession',\n                    'Data' => $acc\n                }\n            );\n            # add hit significance (from the hit table)\n            # this is where Bug 1986 went awry\n            \n            # Changed for Bug2409; hit->significance and hit->score/bits derived\n            # from HSPs, not hit table unless necessary\n            \n            HITTABLE:\n            while (my $v = shift @hit_signifs) {        \n                my $tableid = $v->[2];\n                if ($tableid !~ m{\\Q$id\\E}) {\n                    $self->debug(\"Hit table ID $tableid doesn't match current hit id $id, checking next hit table entry...\\n\");\n                    next HITTABLE;\n                } else {\n                    last HITTABLE;\n                }\n            }\n            while ( defined( $_ = $self->_readline() ) ) {\n                next if (/^\\s+$/);\n                chomp;\n                if (/Length\\s*=\\s*([\\d,]+)/) {\n                    my $l = $1;\n                    $l =~ s/\\,//g;\n                    $self->element(\n                        {\n                            'Name' => 'Hit_len',\n                            'Data' => $l\n                        }\n                    );\n                    last;\n                }\n                else {\n                    s/^\\s(?!\\s)/\\x01/; #new line to concatenate desc lines with <soh>\n                    $restofline .= $_;\n                }\n            }\n            $restofline =~ s/\\s+/ /g;\n            $self->element(\n                {\n                    'Name' => 'Hit_def',\n                    'Data' => $restofline\n                }\n            );\n        }\n        elsif (/\\s+(Plus|Minus) Strand HSPs:/i) {\n            next;\n        }\n        elsif (\n            ( $self->in_element('hit') || $self->in_element('hsp') )\n            &&    # paracel genewise BTK\n            m/Score\\s*=\\s*(\\S+)\\s*bits\\s* # Bit score\n                (?:\\((\\d+)\\))?,                 # Raw score\n\t\t\\s+Log\\-Length\\sScore\\s*=\\s*(\\d+) # Log-Length score\n                /ox\n          )\n        {\n            $self->in_element('hsp')\n              && $self->end_element( { 'Name' => 'Hsp' } );\n            $self->start_element( { 'Name' => 'Hsp' } );\n\n            $self->debug( \"Got paracel genewise HSP score=$1\\n\");\n\n            # Some data clean-up so e-value will appear numeric to perl\n            my ( $bits, $score, $evalue ) = ( $1, $2, $3 );\n            $evalue =~ s/^e/1e/i;\n            $self->element(\n                {\n                    'Name' => 'Hsp_score',\n                    'Data' => $score\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_bit-score',\n                    'Data' => $bits\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_evalue',\n                    'Data' => $evalue\n                }\n            );\n        }\n        elsif (\n            ( $self->in_element('hit') || $self->in_element('hsp') )\n            &&    # paracel hframe BTK\n            m/Score\\s*=\\s*([^,\\s]+),     # Raw score\n\t\t\\s*Expect\\s*=\\s*([^,\\s]+),  # E-value\n                \\s*P(?:\\(\\S+\\))?\\s*=\\s*([^,\\s]+) # P-value\n                /ox\n          )\n        {\n            $self->in_element('hsp')\n              && $self->end_element( { 'Name' => 'Hsp' } );\n            $self->start_element( { 'Name' => 'Hsp' } );\n\n            $self->debug( \"Got paracel hframe HSP score=$1\\n\");\n\n            # Some data clean-up so e-value will appear numeric to perl\n            my ( $score, $evalue, $pvalue ) = ( $1, $2, $3 );\n            $evalue = \"1$evalue\" if $evalue =~ /^e/;\n            $pvalue = \"1$pvalue\" if $pvalue =~ /^e/;\n\n            $self->element(\n                {\n                    'Name' => 'Hsp_score',\n                    'Data' => $score\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_evalue',\n                    'Data' => $evalue\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_pvalue',\n                    'Data' => $pvalue\n                }\n            );\n        }\n        elsif (\n            ( $self->in_element('hit') || $self->in_element('hsp') )\n            &&    # wublast\n            m/Score\\s*=\\s*(\\S+)\\s*         # Bit score\n                \\(([\\d\\.]+)\\s*bits\\),         # Raw score\n                \\s*Expect\\s*=\\s*([^,\\s]+),    # E-value\n                \\s*(?:Sum)?\\s*                # SUM\n                P(?:\\(\\d+\\))?\\s*=\\s*([^,\\s]+) # P-value\n                (?:\\s*,\\s+Group\\s*\\=\\s*(\\d+))?    # HSP Group\n                /ox\n          )\n        {         # wu-blast HSP parse\n            $self->in_element('hsp')\n              && $self->end_element( { 'Name' => 'Hsp' } );\n            $self->start_element( { 'Name' => 'Hsp' } );\n\n            # Some data clean-up so e-value will appear numeric to perl\n            my ( $score, $bits, $evalue, $pvalue, $group ) =\n              ( $1, $2, $3, $4, $5 );\n            $evalue =~ s/^e/1e/i;\n            $pvalue =~ s/^e/1e/i;\n\n            $self->element(\n                {\n                    'Name' => 'Hsp_score',\n                    'Data' => $score\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_bit-score',\n                    'Data' => $bits\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_evalue',\n                    'Data' => $evalue\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_pvalue',\n                    'Data' => $pvalue\n                }\n            );\n\n            if ( defined $group ) {\n                $self->element(\n                    {\n                        'Name' => 'Hsp_group',\n                        'Data' => $group\n                    }\n                );\n            }\n\n        }\n        elsif (\n            ( $self->in_element('hit') || $self->in_element('hsp') )\n            &&    # ncbi blast, works with 2.2.17\n            m/Score\\s*=\\s*(\\S+)\\s*bits\\s* # Bit score\n                (?:\\((\\d+)\\))?,            # Missing for BLAT pseudo-BLAST fmt \n                \\s*Expect(?:\\((\\d+\\+?)\\))?\\s*=\\s*([^,\\s]+) # E-value\n                /ox\n          )\n        {         # parse NCBI blast HSP\n            $self->in_element('hsp')\n              && $self->end_element( { 'Name' => 'Hsp' } );\n\n            # Some data clean-up so e-value will appear numeric to perl\n            my ( $bits, $score, $n, $evalue ) = ( $1, $2, $3, $4 );\n            $evalue =~ s/^e/1e/i;\n            $self->start_element( { 'Name' => 'Hsp' } );\n            $self->element(\n                {\n                    'Name' => 'Hsp_score',\n                    'Data' => $score\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_bit-score',\n                    'Data' => $bits\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_evalue',\n                    'Data' => $evalue\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_n',\n                    'Data' => $n\n                }\n            ) if defined $n;\n            $score = '' unless defined $score;    # deal with BLAT which\n                                                  # has no score only bits\n            $self->debug(\"Got NCBI HSP score=$score, evalue $evalue\\n\");\n        }\n        elsif (\n            $self->in_element('hsp')\n            && m/Identities\\s*=\\s*(\\d+)\\s*\\/\\s*(\\d+)\\s*[\\d\\%\\(\\)]+\\s*\n                (?:,\\s*Positives\\s*=\\s*(\\d+)\\/(\\d+)\\s*[\\d\\%\\(\\)]+\\s*)? # pos only valid for Protein alignments\n                (?:\\,\\s*Gaps\\s*=\\s*(\\d+)\\/(\\d+))? # Gaps\n                /oxi\n          )\n        {\n            $self->element(\n                {\n                    'Name' => 'Hsp_identity',\n                    'Data' => $1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_align-len',\n                    'Data' => $2\n                }\n            );\n            if ( defined $3 ) {\n                $self->element(\n                    {\n                        'Name' => 'Hsp_positive',\n                        'Data' => $3\n                    }\n                );\n            }\n            else {\n                $self->element(\n                    {\n                        'Name' => 'Hsp_positive',\n                        'Data' => $1\n                    }\n                );\n            }\n            if ( defined $6 ) {\n                $self->element(\n                    {\n                        'Name' => 'Hsp_gaps',\n                        'Data' => $5\n                    }\n                );\n            }\n\n            $self->{'_Query'} = { 'begin' => 0, 'end' => 0 };\n            $self->{'_Sbjct'} = { 'begin' => 0, 'end' => 0 };\n\n            if (/(Frame\\s*=\\s*.+)$/) {\n\n                # handle wu-blast Frame listing on same line\n                $self->_pushback($1);\n            }\n        }\n        elsif ( $self->in_element('hsp')\n            && /Strand\\s*=\\s*(Plus|Minus)\\s*\\/\\s*(Plus|Minus)/i )\n        {\n\n            # consume this event ( we infer strand from start/end)\n            unless ($reporttype) {\n                $self->{'_reporttype'} = $reporttype = 'BLASTN';\n                $bl2seq_fix = 1;    # special case to resubmit the algorithm\n                                    # reporttype\n            }\n            next;\n        }\n        elsif ( $self->in_element('hsp')\n            && /Links\\s*=\\s*(\\S+)/ox )\n        {\n            $self->element(\n                {\n                    'Name' => 'Hsp_links',\n                    'Data' => $1\n                }\n            );\n        }\n        elsif ( $self->in_element('hsp')\n            && /Frame\\s*=\\s*([\\+\\-][1-3])\\s*(\\/\\s*([\\+\\-][1-3]))?/ )\n        {\n\n            # this is for bl2seq only\n            unless ( defined $reporttype ) {\n                $bl2seq_fix = 1;\n                if ( $1 && $2 ) { $reporttype = 'TBLASTX' }\n                else {\n                    $reporttype = 'BLASTX';\n\n    # we can't distinguish between BLASTX and TBLASTN straight from the report }\n                }\n                $self->{'_reporttype'} = $reporttype;\n            }\n\n            my ( $queryframe, $hitframe );\n            if ( $reporttype eq 'TBLASTX' ) {\n                ( $queryframe, $hitframe ) = ( $1, $2 );\n                $hitframe =~ s/\\/\\s*//g;\n            }\n            elsif ( $reporttype eq 'TBLASTN' || $reporttype eq 'PSITBLASTN') {\n                ( $hitframe, $queryframe ) = ( $1, 0 );\n            }\n            elsif ( $reporttype eq 'BLASTX' || $reporttype eq 'RPS-BLAST(BLASTP)') {\n                ( $queryframe, $hitframe ) = ( $1, 0 );\n                # though NCBI doesn't report it, this is a special BLASTX-like\n                # RPS-BLAST; should be handled differently\n                if ($reporttype eq 'RPS-BLAST(BLASTP)') {\n                    $self->element(\n                        {\n                            'Name' => 'BlastOutput_program',\n                            'Data' => 'RPS-BLAST(BLASTX)'\n                        }\n                    );\n                }\n            }\n            $self->element(\n                {\n                    'Name' => 'Hsp_query-frame',\n                    'Data' => $queryframe\n                }\n            );\n\n            $self->element(\n                {\n                    'Name' => 'Hsp_hit-frame',\n                    'Data' => $hitframe\n                }\n            );\n        }\n        elsif (/^Parameters:/\n            || /^\\s+Database:\\s+?/\n            || /^\\s+Subset/\n            || /^\\s*Lambda/\n            || /^\\s*Histogram/\n            || ( $self->in_element('hsp') && /WARNING|NOTE/ ) )\n        {\n\n            # Note: Lambda check was necessary to parse\n            # t/data/ecoli_domains.rpsblast AND to parse bl2seq\n            $self->debug(\"blast.pm: found parameters section \\n\");\n\n            $self->in_element('hsp')\n              && $self->end_element( { 'Name' => 'Hsp' } );\n            $self->in_element('hit')\n              && $self->end_element( { 'Name' => 'Hit' } );\n\n            # This is for the case when we specify -b 0 (or B=0 for WU-BLAST)\n            # and still want to construct minimal Hit objects\n            $self->_cleanup_hits(\\@hit_signifs) if scalar(@hit_signifs);\n            $self->within_element('iteration')\n              && $self->end_element( { 'Name' => 'Iteration' } );\n\n            next if /^\\s+Subset/;\n            my $blast = (/^(\\s+Database\\:)|(\\s*Lambda)/) ? 'ncbi' : 'wublast';\n            if (/^\\s*Histogram/) {\n                $blast = 'btk';\n            }\n\n            my $last = '';\n\n            # default is that gaps are allowed\n            $self->element(\n                {\n                    'Name' => 'Parameters_allowgaps',\n                    'Data' => 'yes'\n                }\n            );\n            while ( defined( $_ = $self->_readline ) ) {\n                if (\n                    /^((?:\\S+)?BLAST[NPX]?)\\s+(.+)$/i  # NCBI BLAST, PSIBLAST\n                                                      # RPSBLAST, MEGABLAST\n                    || /^(P?GENEWISE|HFRAME|SWN|TSWN)\\s+(.+)/i    #Paracel BTK\n                  )\n                {\n                    $self->_pushback($_);\n\n                    # let's handle this in the loop\n                    last;\n                }\n                elsif (/^Query=/) {\n                    $self->_pushback($reportline) if $reportline;\n                    $self->_pushback($_);\n                    last PARSER;\n                }\n\n                # here is where difference between wublast and ncbiblast\n                # is better handled by different logic\n                if (   /Number of Sequences:\\s+([\\d\\,]+)/i\n                    || /of sequences in database:\\s+(\\-?[\\d,]+)/i )\n                {\n                    my $c = $1;\n                    $c =~ s/\\,//g;\n                    $self->element(\n                        {\n                            'Name' => 'Statistics_db-len',\n                            'Data' => $c\n                        }\n                    );\n                }\n                elsif (/letters in database:\\s+(\\-?[\\d,]+)/i) {\n                    my $s = $1;\n                    $s =~ s/,//g;\n                    $self->element(\n                        {\n                            'Name' => 'Statistics_db-let',\n                            'Data' => $s\n                        }\n                    );\n                }\n                elsif ( $blast eq 'btk' ) {\n                    next;\n                }\n                elsif ( $blast eq 'wublast' ) {\n\n                    #\t\t   warn($_);\n                    if (/E=(\\S+)/) {\n                        $self->element(\n                            {\n                                'Name' => 'Parameters_expect',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (/nogaps/) {\n                        $self->element(\n                            {\n                                'Name' => 'Parameters_allowgaps',\n                                'Data' => 'no'\n                            }\n                        );\n                    }\n                    elsif (/ctxfactor=(\\S+)/) {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_ctxfactor',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (\n/(postsw|links|span[12]?|warnings|notes|gi|noseqs|qres|qype)/\n                      )\n                    {\n                        $self->element(\n                            {\n                                'Name' => \"Parameters_$1\",\n                                'Data' => 'yes'\n                            }\n                        );\n                    }\n                    elsif (/(\\S+)=(\\S+)/) {\n                        $self->element(\n                            {\n                                'Name' => \"Parameters_$1\",\n                                'Data' => $2\n                            }\n                        );\n                    }\n                    elsif ( $last =~ /(Frame|Strand)\\s+MatID\\s+Matrix name/i ) {\n                        my $firstgapinfo = 1;\n                        my $frame        = undef;\n                        while ( defined($_) && !/^\\s+$/ ) {\n                            s/^\\s+//;\n                            s/\\s+$//;\n                            if ( $firstgapinfo\n                                && s/Q=(\\d+),R=(\\d+)\\s+//x )\n                            {\n                                $firstgapinfo = 0;\n\n                                $self->element(\n                                    {\n                                        'Name' => 'Parameters_gap-open',\n                                        'Data' => $1\n                                    }\n                                );\n                                $self->element(\n                                    {\n                                        'Name' => 'Parameters_gap-extend',\n                                        'Data' => $2\n                                    }\n                                );\n                                my @fields = split;\n\n                                for my $type (\n                                    qw(lambda_gapped\n                                    kappa_gapped\n                                    entropy_gapped)\n                                  )\n                                {\n                                    next if $type eq 'n/a';\n                                    if ( !@fields ) {\n                                        warn \"fields is empty for $type\\n\";\n                                        next;\n                                    }\n                                    $self->element(\n                                        {\n                                            'Name' =>\n                                              \"Statistics_frame$frame\\_$type\",\n                                            'Data' => shift @fields\n                                        }\n                                    );\n                                }\n                            }\n                            else {\n                                my ( $frameo, $matid, $matrix, @fields ) =\n                                  split;\n                                if ( !defined $frame ) {\n\n                                    # keep some sort of default feature I guess\n                                    # even though this is sort of wrong\n                                    $self->element(\n                                        {\n                                            'Name' => 'Parameters_matrix',\n                                            'Data' => $matrix\n                                        }\n                                    );\n                                    $self->element(\n                                        {\n                                            'Name' => 'Statistics_lambda',\n                                            'Data' => $fields[0]\n                                        }\n                                    );\n                                    $self->element(\n                                        {\n                                            'Name' => 'Statistics_kappa',\n                                            'Data' => $fields[1]\n                                        }\n                                    );\n                                    $self->element(\n                                        {\n                                            'Name' => 'Statistics_entropy',\n                                            'Data' => $fields[2]\n                                        }\n                                    );\n                                }\n                                $frame = $frameo;\n                                my $ii = 0;\n                                for my $type (\n                                    qw(lambda_used\n                                    kappa_used\n                                    entropy_used\n                                    lambda_computed\n                                    kappa_computed\n                                    entropy_computed)\n                                  )\n                                {\n                                    my $f = $fields[$ii];\n                                    next unless defined $f;    # deal with n/a\n                                    if ( $f eq 'same' ) {\n                                        $f = $fields[ $ii - 3 ];\n                                    }\n                                    $ii++;\n                                    $self->element(\n                                        {\n                                            'Name' =>\n                                              \"Statistics_frame$frame\\_$type\",\n                                            'Data' => $f\n                                        }\n                                    );\n\n                                }\n                            }\n\n                            # get the next line\n                            $_ = $self->_readline;\n                        }\n                        $last = $_;\n                    }\n                    elsif ( $last =~ /(Frame|Strand)\\s+MatID\\s+Length/i ) {\n                        my $frame = undef;\n                        while ( defined($_) && !/^\\s+/ ) {\n                            s/^\\s+//;\n                            s/\\s+$//;\n                            my @fields = split;\n                            if ( @fields <= 3 ) {\n                                for my $type (qw(X_gapped E2_gapped S2)) {\n                                    last unless @fields;\n                                    $self->element(\n                                        {\n                                            'Name' =>\n                                              \"Statistics_frame$frame\\_$type\",\n                                            'Data' => shift @fields\n                                        }\n                                    );\n                                }\n                            }\n                            else {\n\n                                for my $type (\n                                    qw(length\n                                    efflength\n                                    E S W T X E2 S2)\n                                  )\n                                {\n                                    $self->element(\n                                        {\n                                            'Name' =>\n                                              \"Statistics_frame$frame\\_$type\",\n                                            'Data' => shift @fields\n                                        }\n                                    );\n                                }\n                            }\n                            $_ = $self->_readline;\n                        }\n                        $last = $_;\n                    }\n                    elsif (/(\\S+\\s+\\S+)\\s+DFA:\\s+(\\S+)\\s+\\((.+)\\)/) {\n                        if ( $1 eq 'states in' ) {\n                            $self->element(\n                                {\n                                    'Name' => 'Statistics_DFA_states',\n                                    'Data' => \"$2 $3\"\n                                }\n                            );\n                        }\n                        elsif ( $1 eq 'size of' ) {\n                            $self->element(\n                                {\n                                    'Name' => 'Statistics_DFA_size',\n                                    'Data' => \"$2 $3\"\n                                }\n                            );\n                        }\n                    }\n                    elsif (\n                        m/^\\s+Time to generate neighborhood:\\s+\n\t\t\t    (\\S+\\s+\\S+\\s+\\S+)/x\n                      )\n                    {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_neighbortime',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (/processors\\s+used:\\s+(\\d+)/) {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_noprocessors',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (\n                        m/^\\s+(\\S+)\\s+cpu\\s+time:\\s+# cputype\n\t\t\t    (\\S+\\s+\\S+\\s+\\S+)           # cputime\n\t\t\t    \\s+Elapsed:\\s+(\\S+)/x\n                      )\n                    {\n                        my $cputype = lc($1);\n                        $self->element(\n                            {\n                                'Name' => \"Statistics_$cputype\\_cputime\",\n                                'Data' => $2\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => \"Statistics_$cputype\\_actualtime\",\n                                'Data' => $3\n                            }\n                        );\n                    }\n                    elsif (/^\\s+Start:/) {\n                        my ( $junk, $start, $stime, $end, $etime ) =\n                          split( /\\s+(Start|End)\\:\\s+/, $_ );\n                        chomp($stime);\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_starttime',\n                                'Data' => $stime\n                            }\n                        );\n                        chomp($etime);\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_endtime',\n                                'Data' => $etime\n                            }\n                        );\n                    }\n                    elsif (/^\\s+Database:\\s+(.+)$/) {\n                        $self->element(\n                            {\n                                'Name' => 'Parameters_full_dbpath',\n                                'Data' => $1\n                            }\n                        );\n\n                    }\n                    elsif (/^\\s+Posted:\\s+(.+)/) {\n                        my $d = $1;\n                        chomp($d);\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_posted_date',\n                                'Data' => $d\n                            }\n                        );\n                    }\n                }\n                elsif ( $blast eq 'ncbi' ) {\n\n                    if (m/^Matrix:\\s+(.+)\\s*$/oxi) {\n                        $self->element(\n                            {\n                                'Name' => 'Parameters_matrix',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (/^Gapped/) {\n                        $gapped_stats = 1;\n                    }\n                    elsif (/^Lambda/) {\n                        $_ = $self->_readline;\n                        s/^\\s+//;\n                        my ( $lambda, $kappa, $entropy ) = split;\n                        if ($gapped_stats) {\n                            $self->element(\n                                {\n                                    'Name' => \"Statistics_gapped_lambda\",\n                                    'Data' => $lambda\n                                }\n                            );\n                            $self->element(\n                                {\n                                    'Name' => \"Statistics_gapped_kappa\",\n                                    'Data' => $kappa\n                                }\n                            );\n                            $self->element(\n                                {\n                                    'Name' => \"Statistics_gapped_entropy\",\n                                    'Data' => $entropy\n                                }\n                            );\n                        }\n                        else {\n                            $self->element(\n                                {\n                                    'Name' => \"Statistics_lambda\",\n                                    'Data' => $lambda\n                                }\n                            );\n                            $self->element(\n                                {\n                                    'Name' => \"Statistics_kappa\",\n                                    'Data' => $kappa\n                                }\n                            );\n                            $self->element(\n                                {\n                                    'Name' => \"Statistics_entropy\",\n                                    'Data' => $entropy\n                                }\n                            );\n                        }\n                    }\n                    elsif (m/effective\\s+search\\s+space\\s+used:\\s+(\\d+)/ox) {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_eff-spaceused',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (m/effective\\s+search\\s+space:\\s+(\\d+)/ox) {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_eff-space',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (\n                        m/Gap\\s+Penalties:\\s+Existence:\\s+(\\d+)\\,\n\t\t\t    \\s+Extension:\\s+(\\d+)/ox\n                      )\n                    {\n                        $self->element(\n                            {\n                                'Name' => 'Parameters_gap-open',\n                                'Data' => $1\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Parameters_gap-extend',\n                                'Data' => $2\n                            }\n                        );\n                    }\n                    elsif (/effective\\s+HSP\\s+length:\\s+(\\d+)/) {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_hsp-len',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (/effective\\s+length\\s+of\\s+query:\\s+([\\d\\,]+)/) {\n                        my $c = $1;\n                        $c =~ s/\\,//g;\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_query-len',\n                                'Data' => $c\n                            }\n                        );\n                    }\n                    elsif (/effective\\s+length\\s+of\\s+database:\\s+([\\d\\,]+)/) {\n                        my $c = $1;\n                        $c =~ s/\\,//g;\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_eff-dblen',\n                                'Data' => $c\n                            }\n                        );\n                    }\n                    elsif (\n/^(T|A|X1|X2|X3|S1|S2):\\s+(\\d+(\\.\\d+)?)\\s+(?:\\(\\s*(\\d+\\.\\d+) bits\\))?/\n                      )\n                    {\n                        my $v = $2;\n                        chomp($v);\n                        $self->element(\n                            {\n                                'Name' => \"Statistics_$1\",\n                                'Data' => $v\n                            }\n                        );\n                        if ( defined $4 ) {\n                            $self->element(\n                                {\n                                    'Name' => \"Statistics_$1_bits\",\n                                    'Data' => $4\n                                }\n                            );\n                        }\n                    }\n                    elsif (\n                        m/frameshift\\s+window\\,\n\t\t\t    \\s+decay\\s+const:\\s+(\\d+)\\,\\s+([\\.\\d]+)/x\n                      )\n                    {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_framewindow',\n                                'Data' => $1\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_decay',\n                                'Data' => $2\n                            }\n                        );\n                    }\n                    elsif (m/^Number\\s+of\\s+Hits\\s+to\\s+DB:\\s+(\\S+)/ox) {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_hit_to_db',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (m/^Number\\s+of\\s+extensions:\\s+(\\S+)/ox) {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_num_extensions',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (\n                        m/^Number\\s+of\\s+successful\\s+extensions:\\s+\n\t\t\t    (\\S+)/ox\n                      )\n                    {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_num_suc_extensions',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (\n                        m/^Number\\s+of\\s+sequences\\s+better\\s+than\\s+\n\t\t\t    (\\S+):\\s+(\\d+)/ox\n                      )\n                    {\n                        $self->element(\n                            {\n                                'Name' => 'Parameters_expect',\n                                'Data' => $1\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_seqs_better_than_cutoff',\n                                'Data' => $2\n                            }\n                        );\n                    }\n                    elsif (/^\\s+Posted\\s+date:\\s+(.+)/) {\n                        my $d = $1;\n                        chomp($d);\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_posted_date',\n                                'Data' => $d\n                            }\n                        );\n                    }\n                    elsif ( !/^\\s+$/ ) {\n                        #$self->debug( \"unmatched stat $_\");\n                    }\n                }\n                $last = $_;\n            }\n        } elsif ( $self->in_element('hsp') ) {\n            $self->debug(\"blast.pm: Processing HSP\\n\");\n            # let's read 3 lines at a time;\n            # bl2seq hackiness... Not sure I like\n            $self->{'_reporttype'} ||= $DEFAULTREPORTTYPE;\n            my %data = (\n                'Query' => '',\n                'Mid'   => '',\n                'Hit'   => ''\n            );\n            my $len;\n            for ( my $i = 0 ; defined($_) && $i < 3 ; $i++ ) {\n                # $self->debug(\"$i: $_\") if $v;\n                if ( ( $i == 0 && /^\\s+$/) || \n\t\t     /^\\s*(?:Lambda|Minus|Plus|Score)/i )\n                {\n                    $self->_pushback($_) if defined $_;\n                    $self->end_element( { 'Name' => 'Hsp' } );\n                    last;\n                }\n                chomp;\n                if (/^((Query|Sbjct):?\\s+(\\-?\\d+)\\s*)(\\S+)\\s+(\\-?\\d+)/) {\n                    my ( $full, $type, $start, $str, $end ) =\n                      ( $1, $2, $3, $4, $5 );\n\n                    if ( $str eq '-' ) {\n                        $i = 3 if $type eq 'Sbjct';\n                    }\n                    else {\n                        $data{$type} = $str;\n                    }\n                    $len = length($full);\n                    $self->{\"\\_$type\"}->{'begin'} = $start\n                      unless $self->{\"_$type\"}->{'begin'};\n                    $self->{\"\\_$type\"}->{'end'} = $end;\n                } else {\n                    $self->throw(\"no data for midline $_\")\n                      unless ( defined $_ && defined $len );\n                    $data{'Mid'} = substr( $_, $len );\n                }\n                $_ = $self->_readline();\n            }\n            $self->characters(\n                {\n                    'Name' => 'Hsp_qseq',\n                    'Data' => $data{'Query'}\n                }\n            );\n            $self->characters(\n                {\n                    'Name' => 'Hsp_hseq',\n                    'Data' => $data{'Sbjct'}\n                }\n            );\n            $self->characters(\n                {\n                    'Name' => 'Hsp_midline',\n                    'Data' => $data{'Mid'}\n                }\n            );\n        }\n        else {\n            #$self->debug(\"blast.pm: unrecognized line $_\");\n        }\n    }\n\n    $self->debug(\"blast.pm: End of BlastOutput\\n\");\n    if ( $self->{'_seentop'} ) {\n        $self->within_element('hsp')\n          && $self->end_element( { 'Name' => 'Hsp' } );\n        $self->within_element('hit')\n          && $self->end_element( { 'Name' => 'Hit' } );\n        # cleanup extra hits\n        $self->_cleanup_hits(\\@hit_signifs) if scalar(@hit_signifs);\n        $self->within_element('iteration')\n          && $self->end_element( { 'Name' => 'Iteration' } );\n        if ($bl2seq_fix) {\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_program',\n                    'Data' => $reporttype\n                }\n            );\n        }\n        $self->end_element( { 'Name' => 'BlastOutput' } );\n    }\n    return $self->end_document();\n}\n\n# Private method for internal use only.\nsub _start_blastoutput {\n    my $self = shift;\n    $self->start_element( { 'Name' => 'BlastOutput' } );\n    $self->{'_seentop'} = 1;\n    $self->{'_result_count'}++;\n    $self->{'_handler_rc'} = undef;\n}\n\n=head2 _will_handle\n\n Title   : _will_handle\n Usage   : Private method. For internal use only.\n              if( $self->_will_handle($type) ) { ... }\n Function: Provides an optimized way to check whether or not an element of a \n           given type is to be handled.\n Returns : Reference to EventHandler object if the element type is to be handled.\n           undef if the element type is not to be handled.\n Args    : string containing type of element.\n\nOptimizations:\n\n=over 2\n\n* 1\n\nUsing the cached pointer to the EventHandler to minimize repeated\nlookups.\n\n* 2\n\nCaching the will_handle status for each type that is encountered so\nthat it only need be checked by calling\nhandler-E<gt>will_handle($type) once.\n\n\nThis does not lead to a major savings by itself (only 5-10%).  In\ncombination with other optimizations, or for large parse jobs, the\nsavings good be significant.\n\nTo test against the unoptimized version, remove the parentheses from\naround the third term in the ternary \" ? : \" operator and add two\ncalls to $self-E<gt>_eventHandler().\n\n\nsub _will_handle {\n    my ( $self, $type ) = @_;\n    my $handler     = $self->{'_handler_cache'};\n    my $will_handle =\n      defined( $self->{'_will_handle_cache'}->{$type} )\n      ? $self->{'_will_handle_cache'}->{$type}\n      : ( $self->{'_will_handle_cache'}->{$type} =\n          $handler->will_handle($type) );\n\n    return $will_handle ? $handler : undef;\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'","parameters":[{"label":"$self"},{"label":"$data"}]},"detail":"($self,$data)"},{"line":1974,"children":[{"line":1975,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"end_element"},{"name":"$data","containerName":"end_element","line":1975,"kind":13},{"localvar":"my","definition":"my","name":"$nm","containerName":"end_element","line":1977,"kind":13},{"line":1977,"kind":13,"containerName":"end_element","name":"$data"},{"localvar":"my","name":"$type","definition":"my","containerName":"end_element","line":1978,"kind":13},{"kind":13,"line":1979,"containerName":"end_element","definition":"my","name":"$rc","localvar":"my"},{"containerName":"end_element","name":"$nm","line":1980,"kind":13},{"kind":13,"line":1981,"containerName":"end_element","name":"$self"},{"name":"$self","containerName":"end_element","line":1982,"kind":13},{"line":1984,"kind":13,"containerName":"end_element","name":"$self"},{"kind":13,"line":1984,"name":"$DEFAULTREPORTTYPE","containerName":"end_element"},{"line":1989,"kind":13,"containerName":"end_element","name":"$nm"},{"containerName":"end_element","name":"$self","line":1991,"kind":13},{"name":"element","containerName":"end_element","kind":12,"line":1991},{"containerName":"end_element","name":"$self","kind":13,"line":1994},{"name":"$self","containerName":"end_element","kind":13,"line":1996},{"kind":13,"line":1998,"name":"$self","containerName":"end_element"},{"line":1999,"kind":13,"containerName":"end_element","name":"$self"},{"line":1999,"kind":12,"name":"element","containerName":"end_element"},{"kind":13,"line":2002,"name":"$self","containerName":"end_element"},{"kind":13,"line":2005,"containerName":"end_element","name":"$self"},{"containerName":"end_element","name":"element","kind":12,"line":2005},{"kind":13,"line":2008,"name":"$self","containerName":"end_element"},{"line":2012,"kind":13,"containerName":"end_element","name":"$self"},{"kind":12,"line":2012,"name":"element","containerName":"end_element"},{"kind":13,"line":2015,"name":"$self","containerName":"end_element"},{"line":2018,"kind":13,"name":"$self","containerName":"end_element"},{"name":"element","containerName":"end_element","kind":12,"line":2018},{"line":2021,"kind":13,"containerName":"end_element","name":"$self"},{"line":2028,"kind":13,"containerName":"end_element","name":"$type"},{"line":2028,"kind":13,"name":"$MODEMAP","containerName":"end_element"},{"name":"$nm","containerName":"end_element","line":2028,"kind":13},{"line":2029,"kind":13,"localvar":"my","containerName":"end_element","name":"$handler","definition":"my"},{"name":"$self","containerName":"end_element","line":2029,"kind":13},{"containerName":"end_element","name":"_will_handle","line":2029,"kind":12},{"name":"$type","containerName":"end_element","line":2029,"kind":13},{"line":2030,"kind":13,"containerName":"end_element","name":"$handler"},{"localvar":"my","containerName":"end_element","name":"$func","definition":"my","line":2031,"kind":13},{"containerName":"end_element","name":"$type","line":2031,"kind":13},{"name":"$rc","containerName":"end_element","line":2032,"kind":13},{"line":2032,"kind":13,"name":"$handler","containerName":"end_element"},{"kind":13,"line":2032,"name":"$func","containerName":"end_element"},{"name":"$self","containerName":"end_element","line":2032,"kind":13},{"name":"$self","containerName":"end_element","line":2032,"kind":13},{"line":2034,"kind":13,"name":"$self","containerName":"end_element"}],"kind":12,"detail":"($self,$data)","signature":{"parameters":[{"label":"$self"},{"label":"$data"}],"documentation":"(Sesame Street aficionados note: This answer was NOT given by Mr. Noodle ;-P)\n# $Id: blast.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::blast\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n# 20030409 - sac\n#          PSI-BLAST full parsing support. Rollout of new\n#          model which will remove Steve's old psiblast driver\n# 20030424 - jason\n#          Megablast parsing fix as reported by Neil Saunders\n# 20030427 - jason\n#          Support bl2seq parsing\n# 20031124 - jason\n#          Parse more blast statistics, lambda, entropy, etc\n#          from WU-BLAST in frame-specific manner\n# 20060216 - cjf - fixed blast parsing for BLAST v2.2.13 output\n# 20071104 - dmessina - added support for WUBLAST -echofilter\n# 20071121 - cjf - fixed several bugs (bugs 2391, 2399, 2409)\n\n=head1 NAME\n\nBio::SearchIO::blast - Event generator for event based parsing of\nblast reports\n\n=head1 SYNOPSIS\n\n   # Do not use this object directly - it is used as part of the\n   # Bio::SearchIO system.\n\n    use Bio::SearchIO;\n    my $searchio = Bio::SearchIO->new(-format => 'blast',\n                                     -file   => 't/data/ecolitst.bls');\n    while( my $result = $searchio->next_result ) {\n        while( my $hit = $result->next_hit ) {\n            while( my $hsp = $hit->next_hsp ) {\n                # ...\n            }\n        }\n    }\n\n=head1 DESCRIPTION\n\nThis object encapsulated the necessary methods for generating events\nsuitable for building Bio::Search objects from a BLAST report file.\nRead the L<Bio::SearchIO> for more information about how to use this.\n\nThis driver can parse:\n\n=over 4\n\n* * \n\nNCBI produced plain text BLAST reports from blastall, this also\nincludes PSIBLAST, PSITBLASTN, RPSBLAST, and bl2seq reports.  NCBI XML\nBLAST output is parsed with the blastxml SearchIO driver\n\n* *\n\nWU-BLAST all reports\n\n* *\n\nJim Kent's BLAST-like output from his programs (BLASTZ, BLAT)\n\n* *\n\nBLAST-like output from Paracel BTK output\n\n\n=head2 bl2seq parsing\n\nSince I cannot differentiate between BLASTX and TBLASTN since bl2seq\ndoesn't report the algorithm used - I assume it is BLASTX by default -\nyou can supply the program type with -report_type in the SearchIO\nconstructor i.e.\n\n  my $parser = Bio::SearchIO->new(-format => 'blast',\n                                 -file => 'bl2seq.tblastn.report',\n                                 -report_type => 'tblastn');\n\nThis only really affects where the frame and strand information are\nput - they will always be on the $hsp-E<gt>query instead of on the\n$hsp-E<gt>hit part of the feature pair for blastx and tblastn bl2seq\nproduced reports.  Hope that's clear...\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail Jason Stajich jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nSteve Chervitz sac-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...'\n\npackage Bio::SearchIO::blast;\n\nuse Bio::SearchIO::IteratedSearchResultEventBuilder;\nuse strict;\nuse vars qw(%MAPPING %MODEMAP\n  $DEFAULT_BLAST_WRITER_CLASS\n  $MAX_HSP_OVERLAP\n  $DEFAULT_SIGNIF\n  $DEFAULT_SCORE\n  $DEFAULTREPORTTYPE\n);\n\n\nuse base qw(Bio::SearchIO);\nuse Data::Dumper;\n\nBEGIN {\n\n    # mapping of NCBI Blast terms to Bioperl hash keys\n    %MODEMAP = (\n        'BlastOutput' => 'result',\n        'Iteration'   => 'iteration',\n        'Hit'         => 'hit',\n        'Hsp'         => 'hsp'\n    );\n\n    # This should really be done more intelligently, like with\n    # XSLT\n\n    %MAPPING = (\n        'Hsp_bit-score'   => 'HSP-bits',\n        'Hsp_score'       => 'HSP-score',\n        'Hsp_evalue'      => 'HSP-evalue',\n        'Hsp_n',          => 'HSP-n',\n        'Hsp_pvalue'      => 'HSP-pvalue',\n        'Hsp_query-from'  => 'HSP-query_start',\n        'Hsp_query-to'    => 'HSP-query_end',\n        'Hsp_hit-from'    => 'HSP-hit_start',\n        'Hsp_hit-to'      => 'HSP-hit_end',\n        'Hsp_positive'    => 'HSP-conserved',\n        'Hsp_identity'    => 'HSP-identical',\n        'Hsp_gaps'        => 'HSP-hsp_gaps',\n        'Hsp_hitgaps'     => 'HSP-hit_gaps',\n        'Hsp_querygaps'   => 'HSP-query_gaps',\n        'Hsp_qseq'        => 'HSP-query_seq',\n        'Hsp_hseq'        => 'HSP-hit_seq',\n        'Hsp_midline'     => 'HSP-homology_seq',\n        'Hsp_align-len'   => 'HSP-hsp_length',\n        'Hsp_query-frame' => 'HSP-query_frame',\n        'Hsp_hit-frame'   => 'HSP-hit_frame',\n        'Hsp_links'       => 'HSP-links',\n        'Hsp_group'       => 'HSP-hsp_group',\n        'Hsp_features'    => 'HSP-hit_features',\n\n        'Hit_id'        => 'HIT-name',\n        'Hit_len'       => 'HIT-length',\n        'Hit_accession' => 'HIT-accession',\n        'Hit_def'       => 'HIT-description',\n        'Hit_signif'    => 'HIT-significance',\n        # For NCBI blast, the description line contains bits.\n        # For WU-blast, the  description line contains score.\n        'Hit_score' => 'HIT-score',\n        'Hit_bits'  => 'HIT-bits',\n\n        'Iteration_iter-num'  => 'ITERATION-number',\n        'Iteration_converged' => 'ITERATION-converged',\n\n        'BlastOutput_program'             => 'RESULT-algorithm_name',\n        'BlastOutput_version'             => 'RESULT-algorithm_version',\n        'BlastOutput_query-def'           => 'RESULT-query_name',\n        'BlastOutput_query-len'           => 'RESULT-query_length',\n        'BlastOutput_query-acc'           => 'RESULT-query_accession',\n        'BlastOutput_query-gi'            => 'RESULT-query_gi',\n        'BlastOutput_querydesc'           => 'RESULT-query_description',\n        'BlastOutput_db'                  => 'RESULT-database_name',\n        'BlastOutput_db-len'              => 'RESULT-database_entries',\n        'BlastOutput_db-let'              => 'RESULT-database_letters',\n        'BlastOutput_inclusion-threshold' => 'RESULT-inclusion_threshold',\n\n        'Parameters_matrix'      => { 'RESULT-parameters' => 'matrix' },\n        'Parameters_expect'      => { 'RESULT-parameters' => 'expect' },\n        'Parameters_include'     => { 'RESULT-parameters' => 'include' },\n        'Parameters_sc-match'    => { 'RESULT-parameters' => 'match' },\n        'Parameters_sc-mismatch' => { 'RESULT-parameters' => 'mismatch' },\n        'Parameters_gap-open'    => { 'RESULT-parameters' => 'gapopen' },\n        'Parameters_gap-extend'  => { 'RESULT-parameters' => 'gapext' },\n        'Parameters_filter'      => { 'RESULT-parameters' => 'filter' },\n        'Parameters_allowgaps'   => { 'RESULT-parameters' => 'allowgaps' },\n        'Parameters_full_dbpath' => { 'RESULT-parameters' => 'full_dbpath' },\n        'Statistics_db-len'      => { 'RESULT-statistics' => 'dbentries' },\n        'Statistics_db-let'      => { 'RESULT-statistics' => 'dbletters' },\n        'Statistics_hsp-len'     =>\n          { 'RESULT-statistics' => 'effective_hsplength' },\n        'Statistics_query-len' => { 'RESULT-statistics' => 'querylength' },\n        'Statistics_eff-space' => { 'RESULT-statistics' => 'effectivespace' },\n        'Statistics_eff-spaceused' =>\n          { 'RESULT-statistics' => 'effectivespaceused' },\n        'Statistics_eff-dblen' =>\n          { 'RESULT-statistics' => 'effectivedblength' },\n        'Statistics_kappa'         => { 'RESULT-statistics' => 'kappa' },\n        'Statistics_lambda'        => { 'RESULT-statistics' => 'lambda' },\n        'Statistics_entropy'       => { 'RESULT-statistics' => 'entropy' },\n        'Statistics_gapped_kappa'  => { 'RESULT-statistics' => 'kappa_gapped' },\n        'Statistics_gapped_lambda' =>\n          { 'RESULT-statistics' => 'lambda_gapped' },\n        'Statistics_gapped_entropy' =>\n          { 'RESULT-statistics' => 'entropy_gapped' },\n\n        'Statistics_framewindow' =>\n          { 'RESULT-statistics' => 'frameshiftwindow' },\n        'Statistics_decay' => { 'RESULT-statistics' => 'decayconst' },\n\n        'Statistics_hit_to_db' => { 'RESULT-statistics' => 'Hits_to_DB' },\n        'Statistics_num_suc_extensions' =>\n          { 'RESULT-statistics' => 'num_successful_extensions' },\n\n        # WU-BLAST stats\n        'Statistics_DFA_states' => { 'RESULT-statistics' => 'num_dfa_states' },\n        'Statistics_DFA_size'   => { 'RESULT-statistics' => 'dfa_size' },\n        'Statistics_noprocessors' =>\n          { 'RESULT-statistics' => 'no_of_processors' },\n        'Statistics_neighbortime' =>\n          { 'RESULT-statistics' => 'neighborhood_generate_time' },\n        'Statistics_starttime' => { 'RESULT-statistics' => 'start_time' },\n        'Statistics_endtime'   => { 'RESULT-statistics' => 'end_time' },\n    );\n\n    # add WU-BLAST Frame-Based Statistics\n    for my $frame ( 0 .. 3 ) {\n        for my $strand ( '+', '-' ) {\n            for my $ind (\n                qw(length efflength E S W T X X_gapped E2\n                E2_gapped S2)\n              )\n            {\n                $MAPPING{\"Statistics_frame$strand$frame\\_$ind\"} =\n                  { 'RESULT-statistics' => \"Frame$strand$frame\\_$ind\" };\n            }\n            for my $val (qw(lambda kappa entropy )) {\n                for my $type (qw(used computed gapped)) {\n                    my $key = \"Statistics_frame$strand$frame\\_$val\\_$type\";\n                    my $val =\n                      { 'RESULT-statistics' =>\n                          \"Frame$strand$frame\\_$val\\_$type\" };\n                    $MAPPING{$key} = $val;\n                }\n            }\n        }\n    }\n\n    # add Statistics\n    for my $stats (\n        qw(T A X1 X2 X3 S1 S2 X1_bits X2_bits X3_bits\n        S1_bits S2_bits  num_extensions\n        num_successful_extensions\n        seqs_better_than_cutoff\n        posted_date\n        search_cputime total_cputime\n        search_actualtime total_actualtime\n        no_of_processors ctxfactor)\n      )\n    {\n        my $key = \"Statistics_$stats\";\n        my $val = { 'RESULT-statistics' => $stats };\n        $MAPPING{$key} = $val;\n    }\n\n    # add WU-BLAST Parameters\n    for my $param (\n        qw(span span1 span2 links warnings notes hspsepsmax\n        hspsepqmax topcomboN topcomboE postsw cpus wordmask\n        filter sort_by_pvalue sort_by_count sort_by_highscore\n        sort_by_totalscore sort_by_subjectlength noseqs gi qtype\n        qres V B Z Y M N)\n      )\n    {\n        my $key = \"Parameters_$param\";\n        my $val = { 'RESULT-parameters' => $param };\n        $MAPPING{$key} = $val;\n    }\n\n    $DEFAULT_BLAST_WRITER_CLASS = 'Bio::Search::Writer::HitTableWriter';\n    $MAX_HSP_OVERLAP   = 2;           # Used when tiling multiple HSPs.\n    $DEFAULTREPORTTYPE = 'BLASTP';    # for bl2seq\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::blast->new(%args);\n Function: Builds a new Bio::SearchIO::blast object \n Returns : Bio::SearchIO::blast\n Args    : Key-value pairs:\n           -fh/-file => filehandle/filename to BLAST file\n           -format   => 'blast'\n           -report_type => 'blastx', 'tblastn', etc -- only for bl2seq\n                           reports when you want to distinguish between\n                           tblastn and blastx reports (this only controls\n                           where the frame information is put - on the query\n                           or subject object.\n           -inclusion_threshold => e-value threshold for inclusion in the\n                                   PSI-BLAST score matrix model (blastpgp)\n           -signif      => float or scientific notation number to be used\n                           as a P- or Expect value cutoff\n           -score       => integer or scientific notation number to be used\n                           as a blast score value cutoff\n           -bits        => integer or scientific notation number to be used\n                           as a bit score value cutoff\n           -hit_filter  => reference to a function to be used for\n                           filtering hits based on arbitrary criteria.\n                           All hits of each BLAST report must satisfy \n                           this criteria to be retained. \n                           If a hit fails this test, it is ignored.\n                           This function should take a\n                           Bio::Search::Hit::BlastHit.pm object as its first\n                           argument and return true\n                           if the hit should be retained.\n                           Sample filter function:\n                              -hit_filter => sub { $hit = shift;\n                                                   $hit->gaps == 0; },\n                           (Note: -filt_func is synonymous with -hit_filter)\n           -overlap     => integer. The amount of overlap to permit between\n                           adjacent HSPs when tiling HSPs. A reasonable value is 2.\n                           Default = $Bio::SearchIO::blast::MAX_HSP_OVERLAP.\n\n            The following criteria are not yet supported:\n            (these are probably best applied within this module rather than in the \n             event handler since they would permit the parser to take some shortcuts.)\n\n           -check_all_hits => boolean. Check all hits for significance against\n                              significance criteria.  Default = false.\n                              If false, stops processing hits after the first\n                              non-significant hit or the first hit that fails\n                              the hit_filter call. This speeds parsing,\n                              taking advantage of the fact that the hits\n                              are processed in the order they appear in the report.\n           -min_query_len => integer to be used as a minimum for query sequence length.\n                             Reports with query sequences below this length will\n                             not be processed. Default = no minimum length.\n           -best        => boolean. Only process the best hit of each report;\n                           default = false.\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n\n    # Blast reports require a specialized version of the SREB due to the\n    # possibility of iterations (PSI-BLAST). Forwarding all arguments to it. An\n    # issue here is that we want to set new default object factories if none are\n    # supplied.\n\n    my $handler = Bio::SearchIO::IteratedSearchResultEventBuilder->new(@args);\n    $self->attach_EventHandler($handler);\n    \n    # 2006-04-26 move this to the attach_handler function in this module so we\n    # can really reset the handler \n    # Optimization: caching\n    # the EventHandler since it is used a lot during the parse.\n    \n    # $self->{'_handler_cache'} = $handler;\n\n    my ( $min_qlen, $check_all, $overlap, $best, $rpttype ) = $self->_rearrange(\n        [\n            qw(MIN_LENGTH CHECK_ALL_HITS\n              OVERLAP BEST\n              REPORT_TYPE)\n        ],\n        @args\n    );\n\n    defined $min_qlen  && $self->min_query_length($min_qlen);\n    defined $best      && $self->best_hit_only($best);\n    defined $check_all && $self->check_all_hits($check_all);\n    defined $rpttype   && ( $self->{'_reporttype'} = $rpttype );\n}\n\nsub attach_EventHandler {\n    my ($self,$handler) = @_;\n\n    $self->SUPER::attach_EventHandler($handler);    \n\n    # Optimization: caching the EventHandler since it is used a lot\n    # during the parse.\n\n    $self->{'_handler_cache'} = $handler;\n    return;\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    my $v      = $self->verbose;\n    my $data   = '';\n    my $flavor = '';\n    $self->{'_seentop'} = 0;     # start next report at top\n    $self->{'_seentop'} = 0;\n    my ( $reporttype, $seenquery, $reportline );  \n    my ( $seeniteration, $found_again );\n    my $incl_threshold = $self->inclusion_threshold;\n    my $bl2seq_fix;\n    $self->start_document();  # let the fun begin...\n    my (@hit_signifs);\n    my $gapped_stats = 0;    # for switching between gapped/ungapped\n                             # lambda, K, H\n    local $_ = \"\\n\";   #consistency\n    PARSER:\n    while ( defined( $_ = $self->_readline ) ) {\n        next if (/^\\s+$/);       # skip empty lines\n        next if (/CPU time:/);\n        next if (/^>\\s*$/);\n        if (\n               /^((?:\\S+?)?BLAST[NPX]?)\\s+(.+)$/i  # NCBI BLAST, PSIBLAST\n                                                   # RPSBLAST, MEGABLAST\n            || /^(P?GENEWISE|HFRAME|SWN|TSWN)\\s+(.+)/i    #Paracel BTK\n          )\n        {\n            ($reporttype, my $reportversion) = ($1, $2);\n            # need to keep track of whether this is WU-BLAST\n            if ($reportversion && $reportversion =~ m{WashU$}) {\n                $self->{'_wublast'}++;\n            }\n            $self->debug(\"blast.pm: Start of new report: $reporttype, $reportversion\\n\");\n            if ( $self->{'_seentop'} ) { \n                # This handles multi-result input streams\n                $self->_pushback($_);\n                last PARSER;\n            }\n            $self->_start_blastoutput;\n            if ($reporttype =~ /RPS-BLAST/) {\n                $reporttype .= '(BLASTP)'; # default RPS-BLAST type\n            }\n            $reportline = $_;   # to fix the fact that RPS-BLAST output is wrong\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_program',\n                    'Data' => $reporttype\n                }\n            );\n\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_version',\n                    'Data' => $reportversion\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_inclusion-threshold',\n                    'Data' => $incl_threshold\n                }\n            );\n        }\n        # added Windows workaround for bug 1985\n        elsif (/^(Searching|Results from round)/) { \n            next unless $1 =~ /Results from round/; \n            $self->debug(\"blast.pm: Possible psi blast iterations found...\\n\");\n            \n            $self->in_element('hsp')\n              && $self->end_element( { 'Name' => 'Hsp' } );\n            $self->in_element('hit')\n              && $self->end_element( { 'Name' => 'Hit' } );\n            if ( defined $seeniteration ) {\n                $self->within_element('iteration')\n                  && $self->end_element( { 'Name' => 'Iteration' } );\n                $self->start_element( { 'Name' => 'Iteration' } );\n            }\n            else {\n                $self->start_element( { 'Name' => 'Iteration' } );\n            }\n            $seeniteration = 1;\n        }\n        elsif (/^Query=\\s*(.*)$/) {\n            my $q    = $1;\n            $self->debug(\"blast.pm: Query= found...$_\\n\");\n            my $size = 0;\n            if ( defined $seenquery ) {\n                $self->_pushback($reportline) if $reportline;\n                $self->_pushback($_);\n                last PARSER;\n            }\n            else {\n                if ( !defined $reporttype ) {\n                    $self->_start_blastoutput;\n                    if ( defined $seeniteration ) {\n                        $self->in_element('iteration')\n                          && $self->end_element( { 'Name' => 'Iteration' } );\n                        $self->start_element( { 'Name' => 'Iteration' } );\n                    }\n                    else {\n                        $self->start_element( { 'Name' => 'Iteration' } );\n                    }\n                    $seeniteration = 1;\n                }\n            }\n            $seenquery = $q;\n            $_ = $self->_readline;\n            while ( defined($_) ) {\n                if (/^Database:/) {\n                    $self->_pushback($_);\n                    last;\n                }\n                # below line fixes length issue with BLAST v2.2.13; still works \n                # with BLAST v2.2.12\n                if ( /\\((\\-?[\\d,]+)\\s+letters.*\\)/ || /^Length=(\\-?[\\d,]+)/ ) {\n                    $size = $1;\n                    $size =~ s/,//g;\n                    last;\n                }\n                else {\n                    # bug 2391\n                    $q .= ($q =~ /\\w$/ && $_ =~ /^\\w/) ? \" $_\" : $_;\n                    $q =~ s/\\s+/ /g; # this catches the newline as well\n                    $q =~ s/^ | $//g;\n                }\n\n                $_ = $self->_readline;\n            }\n            chomp($q);\n            my ( $nm, $desc ) = split( /\\s+/, $q, 2 );\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_query-def',\n                    'Data' => $nm\n                }\n            ) if $nm;\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_query-len',\n                    'Data' => $size\n                }\n            );\n            defined $desc && $desc =~ s/\\s+$//;\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_querydesc',\n                    'Data' => $desc\n                }\n            );\n            my ( $gi, $acc, $version ) = $self->_get_seq_identifiers($nm);\n            $version = defined($version) && length($version) ? \".$version\" : \"\";\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_query-acc',\n                    'Data' => \"$acc$version\"\n                }\n            ) if $acc;\n        }\n\t\t# added check for WU-BLAST -echofilter option (bug 2388)\n\t\telsif (/^>Unfiltered[+-]1$/) {\n        \t# skip all of the lines of unfiltered sequence\n\t\t\twhile($_ !~ /^Database:/) {\n\t\t\t\t$self->debug(\"Bypassing features line: $_\");\n        \t\t$_ = $self->_readline;\n        \t}\n\t\t\t$self->_pushback($_);\n\t\t}\n        elsif (/Sequences producing significant alignments:/) {\n            $self->debug(\"blast.pm: Processing NCBI-BLAST descriptions\\n\");\n            $flavor = 'ncbi';\n            \n            # PSI-BLAST parsing needs to be fixed to specifically look\n            # for old vs new per iteration, as sorting based on duplication\n            # leads to bugs, see bug 1986\n            \n            # The next line is not necessarily whitespace in psiblast reports.\n            # Also note that we must look for the end of this section by testing\n            # for a line with a leading >. Blank lines occur with this section\n            # for psiblast.\n            if ( !$self->in_element('iteration') ) {\n                $self->start_element( { 'Name' => 'Iteration' } );\n            }\n            # these elements are dropped with some multiquery reports; add\n            # back here\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_db-len',\n                    'Data' => $self->{'_blsdb_length'}\n                } \n            ) if $self->{'_blsdb_length'};\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_db-let',\n                    'Data' => $self->{'_blsdb_letters'}\n                }\n            ) if $self->{'_blsdb_letters'};\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_db',\n                    'Data' => $self->{'_blsdb'}\n                }\n            ) if $self->{'_blsdb_letters'};\n            \n            # changed 8/28/2008 to exit hit table if blank line is found after an\n            # appropriate line\n            my $h_regex;\n            my $seen_block;\n          DESCLINE:\n            while ( defined( my $descline = $self->_readline() ) ) {\n                if ($descline =~ m{^\\s*$}) {\n                    last DESCLINE if $seen_block;\n                    next DESCLINE;\n                }\n                # any text match is part of block...\n                $seen_block++;\n                # GCG multiline oddness...\n                if ($descline =~ /^(\\S+)\\s+Begin:\\s\\d+\\s+End:\\s+\\d+/xms) {\n                    my ($id, $nextline) = ($1, $self->_readline);\n                    $nextline =~ s{^!}{};\n                    $descline = \"$id $nextline\";\n                }\n                # NCBI style hit table (no N)\n                if ($descline =~ /(?<!cor)          # negative lookahead\n                    (\\d*\\.?(?:[\\+\\-eE]+)?\\d+)       # number (float or scientific notation)\n                    \\s+                             # space\n                    (\\d*\\.?(?:[\\+\\-eE]+)?\\d+)       # number (float or scientific notation)\n                    \\s*$/xms) {\n                    \n                    my ( $score, $evalue ) = ($1, $2);\n                    \n                    # Some data clean-up so e-value will appear numeric to perl\n                    $evalue =~ s/^e/1e/i;\n\n                    # This to handle no-HSP case\n                    my @line = split ' ',$descline;\n                    \n                    # we want to throw away the score, evalue\n                    pop @line, pop @line;\n\n                    # and N if it is present (of course they are not\n                    # really in that order, but it doesn't matter\n                    if ($3) { pop @line }\n\n                    # add the last 2 entries s.t. we can reconstruct\n                    # a minimal Hit object at the end of the day\n                    push @hit_signifs, [ $evalue, $score, shift @line, join( ' ', @line ) ];\n                } elsif ($descline =~ /^CONVERGED/i) {\n                    $self->element(\n                        {\n                            'Name' => 'Iteration_converged',\n                            'Data' => 1\n                        }\n                    );\n                } else {\n                    $self->_pushback($descline); # Catch leading > (end of section)\n                    last DESCLINE;\n                }\n            }\n        }\n        elsif (/Sequences producing High-scoring Segment Pairs:/) {\n\n     # This block is for WU-BLAST, so we don't have to check for psi-blast stuff\n     # skip the next line\n            $self->debug(\"blast.pm: Processing WU-BLAST descriptions\\n\");\n            $_      = $self->_readline();\n            $flavor = 'wu';\n\n            if ( !$self->in_element('iteration') ) {\n                $self->start_element( { 'Name' => 'Iteration' } );\n            }\n\n            while ( defined( $_ = $self->_readline() )\n                && !/^\\s+$/ )\n            {\n                my @line = split;\n                pop @line;    # throw away first number which is for 'N'col\n\n                # add the last 2 entries to array s.t. we can reconstruct\n                # a minimal Hit object at the end of the day\n                push @hit_signifs,\n                  [ pop @line, pop @line, shift @line, join( ' ', @line ) ];\n            }\n            \n        }\n        elsif (/^Database:\\s*(.+)$/) {\n\n            $self->debug(\"blast.pm: Database: $1\\n\");\n            my $db = $1;\n            while ( defined( $_ = $self->_readline ) ) {\n                if (\n                    /^\\s+(\\-?[\\d\\,]+|\\S+)\\s+sequences\\;\n                   \\s+(\\-?[\\d,]+|\\S+)\\s+ # Deal with NCBI 2.2.8 OSX problems\n                   total\\s+letters/ox\n                  )\n                {\n                    my ( $s, $l ) = ( $1, $2 );\n                    $s =~ s/,//g;\n                    $l =~ s/,//g;\n                    $self->element(\n                        {\n                            'Name' => 'BlastOutput_db-len',\n                            'Data' => $s\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'BlastOutput_db-let',\n                            'Data' => $l\n                        }\n                    );\n                    # cache for next round in cases with multiple queries\n                    $self->{'_blsdb'} = $db;\n                    $self->{'_blsdb_length'} = $s;\n                    $self->{'_blsdb_letters'} = $l;                    \n                    last;\n                }\n                else {\n                    chomp;\n                    $db .= $_;\n                }\n            }\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_db',\n                    'Data' => $db\n                }\n            );\n        }\n        # bypasses this NCBI blast 2.2.13 extra output for now...\n\t\t# Features in/flanking this part of subject sequence:\n        elsif (/^\\sFeatures\\s\\w+\\sthis\\spart/xmso) {\n            my $featline;\n            $_ = $self->_readline;\n\t\t\twhile($_ !~ /^\\s*$/) {\n                chomp;\n                $featline .= $_;\n        \t\t$_ = $self->_readline;\n        \t}\n\t\t\t$self->_pushback($_);\n            $featline =~ s{(?:^\\s+|\\s+^)}{}g;\n            $featline =~ s{\\n}{;}g;\n            $self->{'_last_hspdata'}->{'Hsp_features'} = $featline;\n        }\n        \n        # move inside of a hit\n        elsif (/^>\\s*(\\S+)\\s*(.*)?/) {\n            chomp;\n\n            $self->debug(\"blast.pm: Hit: $1\\n\");\n            $self->in_element('hsp')\n              && $self->end_element( { 'Name' => 'Hsp' } );\n            $self->in_element('hit')\n              && $self->end_element( { 'Name' => 'Hit' } );\n\n            # special case when bl2seq reports don't have a leading\n            # Query=\n            if ( !$self->within_element('result') ) {\n                $self->_start_blastoutput;\n                $self->start_element( { 'Name' => 'Iteration' } );\n            }\n            elsif ( !$self->within_element('iteration') ) {\n                $self->start_element( { 'Name' => 'Iteration' } );\n            }\n            $self->start_element( { 'Name' => 'Hit' } );\n            my $id         = $1;\n            my $restofline = $2;\n\n            $self->debug(\"Starting a hit: $1 $2\\n\");\n            $self->element(\n                {\n                    'Name' => 'Hit_id',\n                    'Data' => $id\n                }\n            );\n            my ($gi, $acc, $version ) = $self->_get_seq_identifiers($id);\n            $self->element(\n                {\n                    'Name' => 'Hit_accession',\n                    'Data' => $acc\n                }\n            );\n            # add hit significance (from the hit table)\n            # this is where Bug 1986 went awry\n            \n            # Changed for Bug2409; hit->significance and hit->score/bits derived\n            # from HSPs, not hit table unless necessary\n            \n            HITTABLE:\n            while (my $v = shift @hit_signifs) {        \n                my $tableid = $v->[2];\n                if ($tableid !~ m{\\Q$id\\E}) {\n                    $self->debug(\"Hit table ID $tableid doesn't match current hit id $id, checking next hit table entry...\\n\");\n                    next HITTABLE;\n                } else {\n                    last HITTABLE;\n                }\n            }\n            while ( defined( $_ = $self->_readline() ) ) {\n                next if (/^\\s+$/);\n                chomp;\n                if (/Length\\s*=\\s*([\\d,]+)/) {\n                    my $l = $1;\n                    $l =~ s/\\,//g;\n                    $self->element(\n                        {\n                            'Name' => 'Hit_len',\n                            'Data' => $l\n                        }\n                    );\n                    last;\n                }\n                else {\n                    s/^\\s(?!\\s)/\\x01/; #new line to concatenate desc lines with <soh>\n                    $restofline .= $_;\n                }\n            }\n            $restofline =~ s/\\s+/ /g;\n            $self->element(\n                {\n                    'Name' => 'Hit_def',\n                    'Data' => $restofline\n                }\n            );\n        }\n        elsif (/\\s+(Plus|Minus) Strand HSPs:/i) {\n            next;\n        }\n        elsif (\n            ( $self->in_element('hit') || $self->in_element('hsp') )\n            &&    # paracel genewise BTK\n            m/Score\\s*=\\s*(\\S+)\\s*bits\\s* # Bit score\n                (?:\\((\\d+)\\))?,                 # Raw score\n\t\t\\s+Log\\-Length\\sScore\\s*=\\s*(\\d+) # Log-Length score\n                /ox\n          )\n        {\n            $self->in_element('hsp')\n              && $self->end_element( { 'Name' => 'Hsp' } );\n            $self->start_element( { 'Name' => 'Hsp' } );\n\n            $self->debug( \"Got paracel genewise HSP score=$1\\n\");\n\n            # Some data clean-up so e-value will appear numeric to perl\n            my ( $bits, $score, $evalue ) = ( $1, $2, $3 );\n            $evalue =~ s/^e/1e/i;\n            $self->element(\n                {\n                    'Name' => 'Hsp_score',\n                    'Data' => $score\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_bit-score',\n                    'Data' => $bits\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_evalue',\n                    'Data' => $evalue\n                }\n            );\n        }\n        elsif (\n            ( $self->in_element('hit') || $self->in_element('hsp') )\n            &&    # paracel hframe BTK\n            m/Score\\s*=\\s*([^,\\s]+),     # Raw score\n\t\t\\s*Expect\\s*=\\s*([^,\\s]+),  # E-value\n                \\s*P(?:\\(\\S+\\))?\\s*=\\s*([^,\\s]+) # P-value\n                /ox\n          )\n        {\n            $self->in_element('hsp')\n              && $self->end_element( { 'Name' => 'Hsp' } );\n            $self->start_element( { 'Name' => 'Hsp' } );\n\n            $self->debug( \"Got paracel hframe HSP score=$1\\n\");\n\n            # Some data clean-up so e-value will appear numeric to perl\n            my ( $score, $evalue, $pvalue ) = ( $1, $2, $3 );\n            $evalue = \"1$evalue\" if $evalue =~ /^e/;\n            $pvalue = \"1$pvalue\" if $pvalue =~ /^e/;\n\n            $self->element(\n                {\n                    'Name' => 'Hsp_score',\n                    'Data' => $score\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_evalue',\n                    'Data' => $evalue\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_pvalue',\n                    'Data' => $pvalue\n                }\n            );\n        }\n        elsif (\n            ( $self->in_element('hit') || $self->in_element('hsp') )\n            &&    # wublast\n            m/Score\\s*=\\s*(\\S+)\\s*         # Bit score\n                \\(([\\d\\.]+)\\s*bits\\),         # Raw score\n                \\s*Expect\\s*=\\s*([^,\\s]+),    # E-value\n                \\s*(?:Sum)?\\s*                # SUM\n                P(?:\\(\\d+\\))?\\s*=\\s*([^,\\s]+) # P-value\n                (?:\\s*,\\s+Group\\s*\\=\\s*(\\d+))?    # HSP Group\n                /ox\n          )\n        {         # wu-blast HSP parse\n            $self->in_element('hsp')\n              && $self->end_element( { 'Name' => 'Hsp' } );\n            $self->start_element( { 'Name' => 'Hsp' } );\n\n            # Some data clean-up so e-value will appear numeric to perl\n            my ( $score, $bits, $evalue, $pvalue, $group ) =\n              ( $1, $2, $3, $4, $5 );\n            $evalue =~ s/^e/1e/i;\n            $pvalue =~ s/^e/1e/i;\n\n            $self->element(\n                {\n                    'Name' => 'Hsp_score',\n                    'Data' => $score\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_bit-score',\n                    'Data' => $bits\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_evalue',\n                    'Data' => $evalue\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_pvalue',\n                    'Data' => $pvalue\n                }\n            );\n\n            if ( defined $group ) {\n                $self->element(\n                    {\n                        'Name' => 'Hsp_group',\n                        'Data' => $group\n                    }\n                );\n            }\n\n        }\n        elsif (\n            ( $self->in_element('hit') || $self->in_element('hsp') )\n            &&    # ncbi blast, works with 2.2.17\n            m/Score\\s*=\\s*(\\S+)\\s*bits\\s* # Bit score\n                (?:\\((\\d+)\\))?,            # Missing for BLAT pseudo-BLAST fmt \n                \\s*Expect(?:\\((\\d+\\+?)\\))?\\s*=\\s*([^,\\s]+) # E-value\n                /ox\n          )\n        {         # parse NCBI blast HSP\n            $self->in_element('hsp')\n              && $self->end_element( { 'Name' => 'Hsp' } );\n\n            # Some data clean-up so e-value will appear numeric to perl\n            my ( $bits, $score, $n, $evalue ) = ( $1, $2, $3, $4 );\n            $evalue =~ s/^e/1e/i;\n            $self->start_element( { 'Name' => 'Hsp' } );\n            $self->element(\n                {\n                    'Name' => 'Hsp_score',\n                    'Data' => $score\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_bit-score',\n                    'Data' => $bits\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_evalue',\n                    'Data' => $evalue\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_n',\n                    'Data' => $n\n                }\n            ) if defined $n;\n            $score = '' unless defined $score;    # deal with BLAT which\n                                                  # has no score only bits\n            $self->debug(\"Got NCBI HSP score=$score, evalue $evalue\\n\");\n        }\n        elsif (\n            $self->in_element('hsp')\n            && m/Identities\\s*=\\s*(\\d+)\\s*\\/\\s*(\\d+)\\s*[\\d\\%\\(\\)]+\\s*\n                (?:,\\s*Positives\\s*=\\s*(\\d+)\\/(\\d+)\\s*[\\d\\%\\(\\)]+\\s*)? # pos only valid for Protein alignments\n                (?:\\,\\s*Gaps\\s*=\\s*(\\d+)\\/(\\d+))? # Gaps\n                /oxi\n          )\n        {\n            $self->element(\n                {\n                    'Name' => 'Hsp_identity',\n                    'Data' => $1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_align-len',\n                    'Data' => $2\n                }\n            );\n            if ( defined $3 ) {\n                $self->element(\n                    {\n                        'Name' => 'Hsp_positive',\n                        'Data' => $3\n                    }\n                );\n            }\n            else {\n                $self->element(\n                    {\n                        'Name' => 'Hsp_positive',\n                        'Data' => $1\n                    }\n                );\n            }\n            if ( defined $6 ) {\n                $self->element(\n                    {\n                        'Name' => 'Hsp_gaps',\n                        'Data' => $5\n                    }\n                );\n            }\n\n            $self->{'_Query'} = { 'begin' => 0, 'end' => 0 };\n            $self->{'_Sbjct'} = { 'begin' => 0, 'end' => 0 };\n\n            if (/(Frame\\s*=\\s*.+)$/) {\n\n                # handle wu-blast Frame listing on same line\n                $self->_pushback($1);\n            }\n        }\n        elsif ( $self->in_element('hsp')\n            && /Strand\\s*=\\s*(Plus|Minus)\\s*\\/\\s*(Plus|Minus)/i )\n        {\n\n            # consume this event ( we infer strand from start/end)\n            unless ($reporttype) {\n                $self->{'_reporttype'} = $reporttype = 'BLASTN';\n                $bl2seq_fix = 1;    # special case to resubmit the algorithm\n                                    # reporttype\n            }\n            next;\n        }\n        elsif ( $self->in_element('hsp')\n            && /Links\\s*=\\s*(\\S+)/ox )\n        {\n            $self->element(\n                {\n                    'Name' => 'Hsp_links',\n                    'Data' => $1\n                }\n            );\n        }\n        elsif ( $self->in_element('hsp')\n            && /Frame\\s*=\\s*([\\+\\-][1-3])\\s*(\\/\\s*([\\+\\-][1-3]))?/ )\n        {\n\n            # this is for bl2seq only\n            unless ( defined $reporttype ) {\n                $bl2seq_fix = 1;\n                if ( $1 && $2 ) { $reporttype = 'TBLASTX' }\n                else {\n                    $reporttype = 'BLASTX';\n\n    # we can't distinguish between BLASTX and TBLASTN straight from the report }\n                }\n                $self->{'_reporttype'} = $reporttype;\n            }\n\n            my ( $queryframe, $hitframe );\n            if ( $reporttype eq 'TBLASTX' ) {\n                ( $queryframe, $hitframe ) = ( $1, $2 );\n                $hitframe =~ s/\\/\\s*//g;\n            }\n            elsif ( $reporttype eq 'TBLASTN' || $reporttype eq 'PSITBLASTN') {\n                ( $hitframe, $queryframe ) = ( $1, 0 );\n            }\n            elsif ( $reporttype eq 'BLASTX' || $reporttype eq 'RPS-BLAST(BLASTP)') {\n                ( $queryframe, $hitframe ) = ( $1, 0 );\n                # though NCBI doesn't report it, this is a special BLASTX-like\n                # RPS-BLAST; should be handled differently\n                if ($reporttype eq 'RPS-BLAST(BLASTP)') {\n                    $self->element(\n                        {\n                            'Name' => 'BlastOutput_program',\n                            'Data' => 'RPS-BLAST(BLASTX)'\n                        }\n                    );\n                }\n            }\n            $self->element(\n                {\n                    'Name' => 'Hsp_query-frame',\n                    'Data' => $queryframe\n                }\n            );\n\n            $self->element(\n                {\n                    'Name' => 'Hsp_hit-frame',\n                    'Data' => $hitframe\n                }\n            );\n        }\n        elsif (/^Parameters:/\n            || /^\\s+Database:\\s+?/\n            || /^\\s+Subset/\n            || /^\\s*Lambda/\n            || /^\\s*Histogram/\n            || ( $self->in_element('hsp') && /WARNING|NOTE/ ) )\n        {\n\n            # Note: Lambda check was necessary to parse\n            # t/data/ecoli_domains.rpsblast AND to parse bl2seq\n            $self->debug(\"blast.pm: found parameters section \\n\");\n\n            $self->in_element('hsp')\n              && $self->end_element( { 'Name' => 'Hsp' } );\n            $self->in_element('hit')\n              && $self->end_element( { 'Name' => 'Hit' } );\n\n            # This is for the case when we specify -b 0 (or B=0 for WU-BLAST)\n            # and still want to construct minimal Hit objects\n            $self->_cleanup_hits(\\@hit_signifs) if scalar(@hit_signifs);\n            $self->within_element('iteration')\n              && $self->end_element( { 'Name' => 'Iteration' } );\n\n            next if /^\\s+Subset/;\n            my $blast = (/^(\\s+Database\\:)|(\\s*Lambda)/) ? 'ncbi' : 'wublast';\n            if (/^\\s*Histogram/) {\n                $blast = 'btk';\n            }\n\n            my $last = '';\n\n            # default is that gaps are allowed\n            $self->element(\n                {\n                    'Name' => 'Parameters_allowgaps',\n                    'Data' => 'yes'\n                }\n            );\n            while ( defined( $_ = $self->_readline ) ) {\n                if (\n                    /^((?:\\S+)?BLAST[NPX]?)\\s+(.+)$/i  # NCBI BLAST, PSIBLAST\n                                                      # RPSBLAST, MEGABLAST\n                    || /^(P?GENEWISE|HFRAME|SWN|TSWN)\\s+(.+)/i    #Paracel BTK\n                  )\n                {\n                    $self->_pushback($_);\n\n                    # let's handle this in the loop\n                    last;\n                }\n                elsif (/^Query=/) {\n                    $self->_pushback($reportline) if $reportline;\n                    $self->_pushback($_);\n                    last PARSER;\n                }\n\n                # here is where difference between wublast and ncbiblast\n                # is better handled by different logic\n                if (   /Number of Sequences:\\s+([\\d\\,]+)/i\n                    || /of sequences in database:\\s+(\\-?[\\d,]+)/i )\n                {\n                    my $c = $1;\n                    $c =~ s/\\,//g;\n                    $self->element(\n                        {\n                            'Name' => 'Statistics_db-len',\n                            'Data' => $c\n                        }\n                    );\n                }\n                elsif (/letters in database:\\s+(\\-?[\\d,]+)/i) {\n                    my $s = $1;\n                    $s =~ s/,//g;\n                    $self->element(\n                        {\n                            'Name' => 'Statistics_db-let',\n                            'Data' => $s\n                        }\n                    );\n                }\n                elsif ( $blast eq 'btk' ) {\n                    next;\n                }\n                elsif ( $blast eq 'wublast' ) {\n\n                    #\t\t   warn($_);\n                    if (/E=(\\S+)/) {\n                        $self->element(\n                            {\n                                'Name' => 'Parameters_expect',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (/nogaps/) {\n                        $self->element(\n                            {\n                                'Name' => 'Parameters_allowgaps',\n                                'Data' => 'no'\n                            }\n                        );\n                    }\n                    elsif (/ctxfactor=(\\S+)/) {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_ctxfactor',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (\n/(postsw|links|span[12]?|warnings|notes|gi|noseqs|qres|qype)/\n                      )\n                    {\n                        $self->element(\n                            {\n                                'Name' => \"Parameters_$1\",\n                                'Data' => 'yes'\n                            }\n                        );\n                    }\n                    elsif (/(\\S+)=(\\S+)/) {\n                        $self->element(\n                            {\n                                'Name' => \"Parameters_$1\",\n                                'Data' => $2\n                            }\n                        );\n                    }\n                    elsif ( $last =~ /(Frame|Strand)\\s+MatID\\s+Matrix name/i ) {\n                        my $firstgapinfo = 1;\n                        my $frame        = undef;\n                        while ( defined($_) && !/^\\s+$/ ) {\n                            s/^\\s+//;\n                            s/\\s+$//;\n                            if ( $firstgapinfo\n                                && s/Q=(\\d+),R=(\\d+)\\s+//x )\n                            {\n                                $firstgapinfo = 0;\n\n                                $self->element(\n                                    {\n                                        'Name' => 'Parameters_gap-open',\n                                        'Data' => $1\n                                    }\n                                );\n                                $self->element(\n                                    {\n                                        'Name' => 'Parameters_gap-extend',\n                                        'Data' => $2\n                                    }\n                                );\n                                my @fields = split;\n\n                                for my $type (\n                                    qw(lambda_gapped\n                                    kappa_gapped\n                                    entropy_gapped)\n                                  )\n                                {\n                                    next if $type eq 'n/a';\n                                    if ( !@fields ) {\n                                        warn \"fields is empty for $type\\n\";\n                                        next;\n                                    }\n                                    $self->element(\n                                        {\n                                            'Name' =>\n                                              \"Statistics_frame$frame\\_$type\",\n                                            'Data' => shift @fields\n                                        }\n                                    );\n                                }\n                            }\n                            else {\n                                my ( $frameo, $matid, $matrix, @fields ) =\n                                  split;\n                                if ( !defined $frame ) {\n\n                                    # keep some sort of default feature I guess\n                                    # even though this is sort of wrong\n                                    $self->element(\n                                        {\n                                            'Name' => 'Parameters_matrix',\n                                            'Data' => $matrix\n                                        }\n                                    );\n                                    $self->element(\n                                        {\n                                            'Name' => 'Statistics_lambda',\n                                            'Data' => $fields[0]\n                                        }\n                                    );\n                                    $self->element(\n                                        {\n                                            'Name' => 'Statistics_kappa',\n                                            'Data' => $fields[1]\n                                        }\n                                    );\n                                    $self->element(\n                                        {\n                                            'Name' => 'Statistics_entropy',\n                                            'Data' => $fields[2]\n                                        }\n                                    );\n                                }\n                                $frame = $frameo;\n                                my $ii = 0;\n                                for my $type (\n                                    qw(lambda_used\n                                    kappa_used\n                                    entropy_used\n                                    lambda_computed\n                                    kappa_computed\n                                    entropy_computed)\n                                  )\n                                {\n                                    my $f = $fields[$ii];\n                                    next unless defined $f;    # deal with n/a\n                                    if ( $f eq 'same' ) {\n                                        $f = $fields[ $ii - 3 ];\n                                    }\n                                    $ii++;\n                                    $self->element(\n                                        {\n                                            'Name' =>\n                                              \"Statistics_frame$frame\\_$type\",\n                                            'Data' => $f\n                                        }\n                                    );\n\n                                }\n                            }\n\n                            # get the next line\n                            $_ = $self->_readline;\n                        }\n                        $last = $_;\n                    }\n                    elsif ( $last =~ /(Frame|Strand)\\s+MatID\\s+Length/i ) {\n                        my $frame = undef;\n                        while ( defined($_) && !/^\\s+/ ) {\n                            s/^\\s+//;\n                            s/\\s+$//;\n                            my @fields = split;\n                            if ( @fields <= 3 ) {\n                                for my $type (qw(X_gapped E2_gapped S2)) {\n                                    last unless @fields;\n                                    $self->element(\n                                        {\n                                            'Name' =>\n                                              \"Statistics_frame$frame\\_$type\",\n                                            'Data' => shift @fields\n                                        }\n                                    );\n                                }\n                            }\n                            else {\n\n                                for my $type (\n                                    qw(length\n                                    efflength\n                                    E S W T X E2 S2)\n                                  )\n                                {\n                                    $self->element(\n                                        {\n                                            'Name' =>\n                                              \"Statistics_frame$frame\\_$type\",\n                                            'Data' => shift @fields\n                                        }\n                                    );\n                                }\n                            }\n                            $_ = $self->_readline;\n                        }\n                        $last = $_;\n                    }\n                    elsif (/(\\S+\\s+\\S+)\\s+DFA:\\s+(\\S+)\\s+\\((.+)\\)/) {\n                        if ( $1 eq 'states in' ) {\n                            $self->element(\n                                {\n                                    'Name' => 'Statistics_DFA_states',\n                                    'Data' => \"$2 $3\"\n                                }\n                            );\n                        }\n                        elsif ( $1 eq 'size of' ) {\n                            $self->element(\n                                {\n                                    'Name' => 'Statistics_DFA_size',\n                                    'Data' => \"$2 $3\"\n                                }\n                            );\n                        }\n                    }\n                    elsif (\n                        m/^\\s+Time to generate neighborhood:\\s+\n\t\t\t    (\\S+\\s+\\S+\\s+\\S+)/x\n                      )\n                    {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_neighbortime',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (/processors\\s+used:\\s+(\\d+)/) {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_noprocessors',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (\n                        m/^\\s+(\\S+)\\s+cpu\\s+time:\\s+# cputype\n\t\t\t    (\\S+\\s+\\S+\\s+\\S+)           # cputime\n\t\t\t    \\s+Elapsed:\\s+(\\S+)/x\n                      )\n                    {\n                        my $cputype = lc($1);\n                        $self->element(\n                            {\n                                'Name' => \"Statistics_$cputype\\_cputime\",\n                                'Data' => $2\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => \"Statistics_$cputype\\_actualtime\",\n                                'Data' => $3\n                            }\n                        );\n                    }\n                    elsif (/^\\s+Start:/) {\n                        my ( $junk, $start, $stime, $end, $etime ) =\n                          split( /\\s+(Start|End)\\:\\s+/, $_ );\n                        chomp($stime);\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_starttime',\n                                'Data' => $stime\n                            }\n                        );\n                        chomp($etime);\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_endtime',\n                                'Data' => $etime\n                            }\n                        );\n                    }\n                    elsif (/^\\s+Database:\\s+(.+)$/) {\n                        $self->element(\n                            {\n                                'Name' => 'Parameters_full_dbpath',\n                                'Data' => $1\n                            }\n                        );\n\n                    }\n                    elsif (/^\\s+Posted:\\s+(.+)/) {\n                        my $d = $1;\n                        chomp($d);\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_posted_date',\n                                'Data' => $d\n                            }\n                        );\n                    }\n                }\n                elsif ( $blast eq 'ncbi' ) {\n\n                    if (m/^Matrix:\\s+(.+)\\s*$/oxi) {\n                        $self->element(\n                            {\n                                'Name' => 'Parameters_matrix',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (/^Gapped/) {\n                        $gapped_stats = 1;\n                    }\n                    elsif (/^Lambda/) {\n                        $_ = $self->_readline;\n                        s/^\\s+//;\n                        my ( $lambda, $kappa, $entropy ) = split;\n                        if ($gapped_stats) {\n                            $self->element(\n                                {\n                                    'Name' => \"Statistics_gapped_lambda\",\n                                    'Data' => $lambda\n                                }\n                            );\n                            $self->element(\n                                {\n                                    'Name' => \"Statistics_gapped_kappa\",\n                                    'Data' => $kappa\n                                }\n                            );\n                            $self->element(\n                                {\n                                    'Name' => \"Statistics_gapped_entropy\",\n                                    'Data' => $entropy\n                                }\n                            );\n                        }\n                        else {\n                            $self->element(\n                                {\n                                    'Name' => \"Statistics_lambda\",\n                                    'Data' => $lambda\n                                }\n                            );\n                            $self->element(\n                                {\n                                    'Name' => \"Statistics_kappa\",\n                                    'Data' => $kappa\n                                }\n                            );\n                            $self->element(\n                                {\n                                    'Name' => \"Statistics_entropy\",\n                                    'Data' => $entropy\n                                }\n                            );\n                        }\n                    }\n                    elsif (m/effective\\s+search\\s+space\\s+used:\\s+(\\d+)/ox) {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_eff-spaceused',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (m/effective\\s+search\\s+space:\\s+(\\d+)/ox) {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_eff-space',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (\n                        m/Gap\\s+Penalties:\\s+Existence:\\s+(\\d+)\\,\n\t\t\t    \\s+Extension:\\s+(\\d+)/ox\n                      )\n                    {\n                        $self->element(\n                            {\n                                'Name' => 'Parameters_gap-open',\n                                'Data' => $1\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Parameters_gap-extend',\n                                'Data' => $2\n                            }\n                        );\n                    }\n                    elsif (/effective\\s+HSP\\s+length:\\s+(\\d+)/) {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_hsp-len',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (/effective\\s+length\\s+of\\s+query:\\s+([\\d\\,]+)/) {\n                        my $c = $1;\n                        $c =~ s/\\,//g;\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_query-len',\n                                'Data' => $c\n                            }\n                        );\n                    }\n                    elsif (/effective\\s+length\\s+of\\s+database:\\s+([\\d\\,]+)/) {\n                        my $c = $1;\n                        $c =~ s/\\,//g;\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_eff-dblen',\n                                'Data' => $c\n                            }\n                        );\n                    }\n                    elsif (\n/^(T|A|X1|X2|X3|S1|S2):\\s+(\\d+(\\.\\d+)?)\\s+(?:\\(\\s*(\\d+\\.\\d+) bits\\))?/\n                      )\n                    {\n                        my $v = $2;\n                        chomp($v);\n                        $self->element(\n                            {\n                                'Name' => \"Statistics_$1\",\n                                'Data' => $v\n                            }\n                        );\n                        if ( defined $4 ) {\n                            $self->element(\n                                {\n                                    'Name' => \"Statistics_$1_bits\",\n                                    'Data' => $4\n                                }\n                            );\n                        }\n                    }\n                    elsif (\n                        m/frameshift\\s+window\\,\n\t\t\t    \\s+decay\\s+const:\\s+(\\d+)\\,\\s+([\\.\\d]+)/x\n                      )\n                    {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_framewindow',\n                                'Data' => $1\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_decay',\n                                'Data' => $2\n                            }\n                        );\n                    }\n                    elsif (m/^Number\\s+of\\s+Hits\\s+to\\s+DB:\\s+(\\S+)/ox) {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_hit_to_db',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (m/^Number\\s+of\\s+extensions:\\s+(\\S+)/ox) {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_num_extensions',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (\n                        m/^Number\\s+of\\s+successful\\s+extensions:\\s+\n\t\t\t    (\\S+)/ox\n                      )\n                    {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_num_suc_extensions',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (\n                        m/^Number\\s+of\\s+sequences\\s+better\\s+than\\s+\n\t\t\t    (\\S+):\\s+(\\d+)/ox\n                      )\n                    {\n                        $self->element(\n                            {\n                                'Name' => 'Parameters_expect',\n                                'Data' => $1\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_seqs_better_than_cutoff',\n                                'Data' => $2\n                            }\n                        );\n                    }\n                    elsif (/^\\s+Posted\\s+date:\\s+(.+)/) {\n                        my $d = $1;\n                        chomp($d);\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_posted_date',\n                                'Data' => $d\n                            }\n                        );\n                    }\n                    elsif ( !/^\\s+$/ ) {\n                        #$self->debug( \"unmatched stat $_\");\n                    }\n                }\n                $last = $_;\n            }\n        } elsif ( $self->in_element('hsp') ) {\n            $self->debug(\"blast.pm: Processing HSP\\n\");\n            # let's read 3 lines at a time;\n            # bl2seq hackiness... Not sure I like\n            $self->{'_reporttype'} ||= $DEFAULTREPORTTYPE;\n            my %data = (\n                'Query' => '',\n                'Mid'   => '',\n                'Hit'   => ''\n            );\n            my $len;\n            for ( my $i = 0 ; defined($_) && $i < 3 ; $i++ ) {\n                # $self->debug(\"$i: $_\") if $v;\n                if ( ( $i == 0 && /^\\s+$/) || \n\t\t     /^\\s*(?:Lambda|Minus|Plus|Score)/i )\n                {\n                    $self->_pushback($_) if defined $_;\n                    $self->end_element( { 'Name' => 'Hsp' } );\n                    last;\n                }\n                chomp;\n                if (/^((Query|Sbjct):?\\s+(\\-?\\d+)\\s*)(\\S+)\\s+(\\-?\\d+)/) {\n                    my ( $full, $type, $start, $str, $end ) =\n                      ( $1, $2, $3, $4, $5 );\n\n                    if ( $str eq '-' ) {\n                        $i = 3 if $type eq 'Sbjct';\n                    }\n                    else {\n                        $data{$type} = $str;\n                    }\n                    $len = length($full);\n                    $self->{\"\\_$type\"}->{'begin'} = $start\n                      unless $self->{\"_$type\"}->{'begin'};\n                    $self->{\"\\_$type\"}->{'end'} = $end;\n                } else {\n                    $self->throw(\"no data for midline $_\")\n                      unless ( defined $_ && defined $len );\n                    $data{'Mid'} = substr( $_, $len );\n                }\n                $_ = $self->_readline();\n            }\n            $self->characters(\n                {\n                    'Name' => 'Hsp_qseq',\n                    'Data' => $data{'Query'}\n                }\n            );\n            $self->characters(\n                {\n                    'Name' => 'Hsp_hseq',\n                    'Data' => $data{'Sbjct'}\n                }\n            );\n            $self->characters(\n                {\n                    'Name' => 'Hsp_midline',\n                    'Data' => $data{'Mid'}\n                }\n            );\n        }\n        else {\n            #$self->debug(\"blast.pm: unrecognized line $_\");\n        }\n    }\n\n    $self->debug(\"blast.pm: End of BlastOutput\\n\");\n    if ( $self->{'_seentop'} ) {\n        $self->within_element('hsp')\n          && $self->end_element( { 'Name' => 'Hsp' } );\n        $self->within_element('hit')\n          && $self->end_element( { 'Name' => 'Hit' } );\n        # cleanup extra hits\n        $self->_cleanup_hits(\\@hit_signifs) if scalar(@hit_signifs);\n        $self->within_element('iteration')\n          && $self->end_element( { 'Name' => 'Iteration' } );\n        if ($bl2seq_fix) {\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_program',\n                    'Data' => $reporttype\n                }\n            );\n        }\n        $self->end_element( { 'Name' => 'BlastOutput' } );\n    }\n    return $self->end_document();\n}\n\n# Private method for internal use only.\nsub _start_blastoutput {\n    my $self = shift;\n    $self->start_element( { 'Name' => 'BlastOutput' } );\n    $self->{'_seentop'} = 1;\n    $self->{'_result_count'}++;\n    $self->{'_handler_rc'} = undef;\n}\n\n=head2 _will_handle\n\n Title   : _will_handle\n Usage   : Private method. For internal use only.\n              if( $self->_will_handle($type) ) { ... }\n Function: Provides an optimized way to check whether or not an element of a \n           given type is to be handled.\n Returns : Reference to EventHandler object if the element type is to be handled.\n           undef if the element type is not to be handled.\n Args    : string containing type of element.\n\nOptimizations:\n\n=over 2\n\n* 1\n\nUsing the cached pointer to the EventHandler to minimize repeated\nlookups.\n\n* 2\n\nCaching the will_handle status for each type that is encountered so\nthat it only need be checked by calling\nhandler-E<gt>will_handle($type) once.\n\n\nThis does not lead to a major savings by itself (only 5-10%).  In\ncombination with other optimizations, or for large parse jobs, the\nsavings good be significant.\n\nTo test against the unoptimized version, remove the parentheses from\naround the third term in the ternary \" ? : \" operator and add two\ncalls to $self-E<gt>_eventHandler().\n\n\nsub _will_handle {\n    my ( $self, $type ) = @_;\n    my $handler     = $self->{'_handler_cache'};\n    my $will_handle =\n      defined( $self->{'_will_handle_cache'}->{$type} )\n      ? $self->{'_will_handle_cache'}->{$type}\n      : ( $self->{'_will_handle_cache'}->{$type} =\n          $handler->will_handle($type) );\n\n    return $will_handle ? $handler : undef;\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\nsub start_element {\n    my ( $self, $data ) = @_;\n\n    # we currently don't care about attributes\n    my $nm   = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    if ($type) {\n        my $handler = $self->_will_handle($type);\n        if ($handler) {\n            my $func = sprintf( \"start_%s\", lc $type );\n            $self->{'_handler_rc'} = $handler->$func( $data->{'Attributes'} );\n        }\n        #else {\n            #$self->debug( # changed 4/29/2006 to play nice with other event handlers\n            #    \"Bio::SearchIO::InternalParserError \".\n            #    \"\\nCan't handle elements of type \\'$type.\\'\"\n            #);\n        #}\n        unshift @{ $self->{'_elements'} }, $type;\n        if ( $type eq 'result' ) {\n            $self->{'_values'} = {};\n            $self->{'_result'} = undef;\n        } else {\n            # cleanup some things\n            if ( defined $self->{'_values'} ) {\n                foreach my $k (\n                    grep { /^\\U$type\\-/ }\n                    keys %{ $self->{'_values'} }\n                  )\n                {\n                    delete $self->{'_values'}->{$k};\n                }\n            }\n        }\n    }\n}\n\n=head2 end_element\n\n Title   : end_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : hashref with an element's worth of data\n Args    : hashref with at least 2 keys 'Data' and 'Name'","label":"end_element($self,$data)"},"containerName":"main::","definition":"sub","range":{"start":{"character":0,"line":1974},"end":{"line":2036,"character":9999}},"name":"end_element"},{"containerName":null,"name":"%MAPPING","line":2037,"kind":13},{"name":"%nm","containerName":null,"kind":13,"line":2037},{"line":2038,"kind":13,"containerName":null,"name":"%MAPPING"},{"line":2038,"kind":13,"name":"%nm","containerName":null},{"containerName":null,"definition":"my","name":"$key","localvar":"my","kind":13,"line":2042},{"containerName":null,"name":"%MAPPING","kind":13,"line":2042},{"name":"@nm","containerName":null,"line":2042,"kind":13},{"kind":13,"line":2043,"name":"%self","containerName":null},{"kind":13,"line":2043,"containerName":null,"name":"%key"},{"line":2043,"kind":13,"containerName":null,"name":"%MAPPING"},{"containerName":null,"name":"%nm","line":2043,"kind":13},{"name":"$key","containerName":null,"line":2043,"kind":13},{"containerName":null,"name":"%self","kind":13,"line":2044},{"name":"%self","containerName":null,"line":2047,"kind":13},{"kind":13,"line":2047,"containerName":null,"name":"%MAPPING"},{"kind":13,"line":2047,"name":"$nm","containerName":null},{"kind":13,"line":2047,"containerName":null,"name":"%self"},{"name":"%self","containerName":null,"kind":13,"line":2053},{"containerName":null,"name":"%self","line":2055,"kind":13},{"kind":13,"line":2055,"containerName":null,"name":"$rc"},{"kind":13,"line":2055,"name":"$type","containerName":null},{"line":2055,"kind":13,"name":"$type","containerName":null},{"kind":13,"line":2056,"containerName":null,"name":"$rc"},{"signature":{"parameters":[{"label":"$self"},{"label":"$data"}],"documentation":"(Sesame Street aficionados note: This answer was NOT given by Mr. Noodle ;-P)\n# $Id: blast.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::blast\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n# 20030409 - sac\n#          PSI-BLAST full parsing support. Rollout of new\n#          model which will remove Steve's old psiblast driver\n# 20030424 - jason\n#          Megablast parsing fix as reported by Neil Saunders\n# 20030427 - jason\n#          Support bl2seq parsing\n# 20031124 - jason\n#          Parse more blast statistics, lambda, entropy, etc\n#          from WU-BLAST in frame-specific manner\n# 20060216 - cjf - fixed blast parsing for BLAST v2.2.13 output\n# 20071104 - dmessina - added support for WUBLAST -echofilter\n# 20071121 - cjf - fixed several bugs (bugs 2391, 2399, 2409)\n\n=head1 NAME\n\nBio::SearchIO::blast - Event generator for event based parsing of\nblast reports\n\n=head1 SYNOPSIS\n\n   # Do not use this object directly - it is used as part of the\n   # Bio::SearchIO system.\n\n    use Bio::SearchIO;\n    my $searchio = Bio::SearchIO->new(-format => 'blast',\n                                     -file   => 't/data/ecolitst.bls');\n    while( my $result = $searchio->next_result ) {\n        while( my $hit = $result->next_hit ) {\n            while( my $hsp = $hit->next_hsp ) {\n                # ...\n            }\n        }\n    }\n\n=head1 DESCRIPTION\n\nThis object encapsulated the necessary methods for generating events\nsuitable for building Bio::Search objects from a BLAST report file.\nRead the L<Bio::SearchIO> for more information about how to use this.\n\nThis driver can parse:\n\n=over 4\n\n* * \n\nNCBI produced plain text BLAST reports from blastall, this also\nincludes PSIBLAST, PSITBLASTN, RPSBLAST, and bl2seq reports.  NCBI XML\nBLAST output is parsed with the blastxml SearchIO driver\n\n* *\n\nWU-BLAST all reports\n\n* *\n\nJim Kent's BLAST-like output from his programs (BLASTZ, BLAT)\n\n* *\n\nBLAST-like output from Paracel BTK output\n\n\n=head2 bl2seq parsing\n\nSince I cannot differentiate between BLASTX and TBLASTN since bl2seq\ndoesn't report the algorithm used - I assume it is BLASTX by default -\nyou can supply the program type with -report_type in the SearchIO\nconstructor i.e.\n\n  my $parser = Bio::SearchIO->new(-format => 'blast',\n                                 -file => 'bl2seq.tblastn.report',\n                                 -report_type => 'tblastn');\n\nThis only really affects where the frame and strand information are\nput - they will always be on the $hsp-E<gt>query instead of on the\n$hsp-E<gt>hit part of the feature pair for blastx and tblastn bl2seq\nproduced reports.  Hope that's clear...\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail Jason Stajich jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nSteve Chervitz sac-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...'\n\npackage Bio::SearchIO::blast;\n\nuse Bio::SearchIO::IteratedSearchResultEventBuilder;\nuse strict;\nuse vars qw(%MAPPING %MODEMAP\n  $DEFAULT_BLAST_WRITER_CLASS\n  $MAX_HSP_OVERLAP\n  $DEFAULT_SIGNIF\n  $DEFAULT_SCORE\n  $DEFAULTREPORTTYPE\n);\n\n\nuse base qw(Bio::SearchIO);\nuse Data::Dumper;\n\nBEGIN {\n\n    # mapping of NCBI Blast terms to Bioperl hash keys\n    %MODEMAP = (\n        'BlastOutput' => 'result',\n        'Iteration'   => 'iteration',\n        'Hit'         => 'hit',\n        'Hsp'         => 'hsp'\n    );\n\n    # This should really be done more intelligently, like with\n    # XSLT\n\n    %MAPPING = (\n        'Hsp_bit-score'   => 'HSP-bits',\n        'Hsp_score'       => 'HSP-score',\n        'Hsp_evalue'      => 'HSP-evalue',\n        'Hsp_n',          => 'HSP-n',\n        'Hsp_pvalue'      => 'HSP-pvalue',\n        'Hsp_query-from'  => 'HSP-query_start',\n        'Hsp_query-to'    => 'HSP-query_end',\n        'Hsp_hit-from'    => 'HSP-hit_start',\n        'Hsp_hit-to'      => 'HSP-hit_end',\n        'Hsp_positive'    => 'HSP-conserved',\n        'Hsp_identity'    => 'HSP-identical',\n        'Hsp_gaps'        => 'HSP-hsp_gaps',\n        'Hsp_hitgaps'     => 'HSP-hit_gaps',\n        'Hsp_querygaps'   => 'HSP-query_gaps',\n        'Hsp_qseq'        => 'HSP-query_seq',\n        'Hsp_hseq'        => 'HSP-hit_seq',\n        'Hsp_midline'     => 'HSP-homology_seq',\n        'Hsp_align-len'   => 'HSP-hsp_length',\n        'Hsp_query-frame' => 'HSP-query_frame',\n        'Hsp_hit-frame'   => 'HSP-hit_frame',\n        'Hsp_links'       => 'HSP-links',\n        'Hsp_group'       => 'HSP-hsp_group',\n        'Hsp_features'    => 'HSP-hit_features',\n\n        'Hit_id'        => 'HIT-name',\n        'Hit_len'       => 'HIT-length',\n        'Hit_accession' => 'HIT-accession',\n        'Hit_def'       => 'HIT-description',\n        'Hit_signif'    => 'HIT-significance',\n        # For NCBI blast, the description line contains bits.\n        # For WU-blast, the  description line contains score.\n        'Hit_score' => 'HIT-score',\n        'Hit_bits'  => 'HIT-bits',\n\n        'Iteration_iter-num'  => 'ITERATION-number',\n        'Iteration_converged' => 'ITERATION-converged',\n\n        'BlastOutput_program'             => 'RESULT-algorithm_name',\n        'BlastOutput_version'             => 'RESULT-algorithm_version',\n        'BlastOutput_query-def'           => 'RESULT-query_name',\n        'BlastOutput_query-len'           => 'RESULT-query_length',\n        'BlastOutput_query-acc'           => 'RESULT-query_accession',\n        'BlastOutput_query-gi'            => 'RESULT-query_gi',\n        'BlastOutput_querydesc'           => 'RESULT-query_description',\n        'BlastOutput_db'                  => 'RESULT-database_name',\n        'BlastOutput_db-len'              => 'RESULT-database_entries',\n        'BlastOutput_db-let'              => 'RESULT-database_letters',\n        'BlastOutput_inclusion-threshold' => 'RESULT-inclusion_threshold',\n\n        'Parameters_matrix'      => { 'RESULT-parameters' => 'matrix' },\n        'Parameters_expect'      => { 'RESULT-parameters' => 'expect' },\n        'Parameters_include'     => { 'RESULT-parameters' => 'include' },\n        'Parameters_sc-match'    => { 'RESULT-parameters' => 'match' },\n        'Parameters_sc-mismatch' => { 'RESULT-parameters' => 'mismatch' },\n        'Parameters_gap-open'    => { 'RESULT-parameters' => 'gapopen' },\n        'Parameters_gap-extend'  => { 'RESULT-parameters' => 'gapext' },\n        'Parameters_filter'      => { 'RESULT-parameters' => 'filter' },\n        'Parameters_allowgaps'   => { 'RESULT-parameters' => 'allowgaps' },\n        'Parameters_full_dbpath' => { 'RESULT-parameters' => 'full_dbpath' },\n        'Statistics_db-len'      => { 'RESULT-statistics' => 'dbentries' },\n        'Statistics_db-let'      => { 'RESULT-statistics' => 'dbletters' },\n        'Statistics_hsp-len'     =>\n          { 'RESULT-statistics' => 'effective_hsplength' },\n        'Statistics_query-len' => { 'RESULT-statistics' => 'querylength' },\n        'Statistics_eff-space' => { 'RESULT-statistics' => 'effectivespace' },\n        'Statistics_eff-spaceused' =>\n          { 'RESULT-statistics' => 'effectivespaceused' },\n        'Statistics_eff-dblen' =>\n          { 'RESULT-statistics' => 'effectivedblength' },\n        'Statistics_kappa'         => { 'RESULT-statistics' => 'kappa' },\n        'Statistics_lambda'        => { 'RESULT-statistics' => 'lambda' },\n        'Statistics_entropy'       => { 'RESULT-statistics' => 'entropy' },\n        'Statistics_gapped_kappa'  => { 'RESULT-statistics' => 'kappa_gapped' },\n        'Statistics_gapped_lambda' =>\n          { 'RESULT-statistics' => 'lambda_gapped' },\n        'Statistics_gapped_entropy' =>\n          { 'RESULT-statistics' => 'entropy_gapped' },\n\n        'Statistics_framewindow' =>\n          { 'RESULT-statistics' => 'frameshiftwindow' },\n        'Statistics_decay' => { 'RESULT-statistics' => 'decayconst' },\n\n        'Statistics_hit_to_db' => { 'RESULT-statistics' => 'Hits_to_DB' },\n        'Statistics_num_suc_extensions' =>\n          { 'RESULT-statistics' => 'num_successful_extensions' },\n\n        # WU-BLAST stats\n        'Statistics_DFA_states' => { 'RESULT-statistics' => 'num_dfa_states' },\n        'Statistics_DFA_size'   => { 'RESULT-statistics' => 'dfa_size' },\n        'Statistics_noprocessors' =>\n          { 'RESULT-statistics' => 'no_of_processors' },\n        'Statistics_neighbortime' =>\n          { 'RESULT-statistics' => 'neighborhood_generate_time' },\n        'Statistics_starttime' => { 'RESULT-statistics' => 'start_time' },\n        'Statistics_endtime'   => { 'RESULT-statistics' => 'end_time' },\n    );\n\n    # add WU-BLAST Frame-Based Statistics\n    for my $frame ( 0 .. 3 ) {\n        for my $strand ( '+', '-' ) {\n            for my $ind (\n                qw(length efflength E S W T X X_gapped E2\n                E2_gapped S2)\n              )\n            {\n                $MAPPING{\"Statistics_frame$strand$frame\\_$ind\"} =\n                  { 'RESULT-statistics' => \"Frame$strand$frame\\_$ind\" };\n            }\n            for my $val (qw(lambda kappa entropy )) {\n                for my $type (qw(used computed gapped)) {\n                    my $key = \"Statistics_frame$strand$frame\\_$val\\_$type\";\n                    my $val =\n                      { 'RESULT-statistics' =>\n                          \"Frame$strand$frame\\_$val\\_$type\" };\n                    $MAPPING{$key} = $val;\n                }\n            }\n        }\n    }\n\n    # add Statistics\n    for my $stats (\n        qw(T A X1 X2 X3 S1 S2 X1_bits X2_bits X3_bits\n        S1_bits S2_bits  num_extensions\n        num_successful_extensions\n        seqs_better_than_cutoff\n        posted_date\n        search_cputime total_cputime\n        search_actualtime total_actualtime\n        no_of_processors ctxfactor)\n      )\n    {\n        my $key = \"Statistics_$stats\";\n        my $val = { 'RESULT-statistics' => $stats };\n        $MAPPING{$key} = $val;\n    }\n\n    # add WU-BLAST Parameters\n    for my $param (\n        qw(span span1 span2 links warnings notes hspsepsmax\n        hspsepqmax topcomboN topcomboE postsw cpus wordmask\n        filter sort_by_pvalue sort_by_count sort_by_highscore\n        sort_by_totalscore sort_by_subjectlength noseqs gi qtype\n        qres V B Z Y M N)\n      )\n    {\n        my $key = \"Parameters_$param\";\n        my $val = { 'RESULT-parameters' => $param };\n        $MAPPING{$key} = $val;\n    }\n\n    $DEFAULT_BLAST_WRITER_CLASS = 'Bio::Search::Writer::HitTableWriter';\n    $MAX_HSP_OVERLAP   = 2;           # Used when tiling multiple HSPs.\n    $DEFAULTREPORTTYPE = 'BLASTP';    # for bl2seq\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::blast->new(%args);\n Function: Builds a new Bio::SearchIO::blast object \n Returns : Bio::SearchIO::blast\n Args    : Key-value pairs:\n           -fh/-file => filehandle/filename to BLAST file\n           -format   => 'blast'\n           -report_type => 'blastx', 'tblastn', etc -- only for bl2seq\n                           reports when you want to distinguish between\n                           tblastn and blastx reports (this only controls\n                           where the frame information is put - on the query\n                           or subject object.\n           -inclusion_threshold => e-value threshold for inclusion in the\n                                   PSI-BLAST score matrix model (blastpgp)\n           -signif      => float or scientific notation number to be used\n                           as a P- or Expect value cutoff\n           -score       => integer or scientific notation number to be used\n                           as a blast score value cutoff\n           -bits        => integer or scientific notation number to be used\n                           as a bit score value cutoff\n           -hit_filter  => reference to a function to be used for\n                           filtering hits based on arbitrary criteria.\n                           All hits of each BLAST report must satisfy \n                           this criteria to be retained. \n                           If a hit fails this test, it is ignored.\n                           This function should take a\n                           Bio::Search::Hit::BlastHit.pm object as its first\n                           argument and return true\n                           if the hit should be retained.\n                           Sample filter function:\n                              -hit_filter => sub { $hit = shift;\n                                                   $hit->gaps == 0; },\n                           (Note: -filt_func is synonymous with -hit_filter)\n           -overlap     => integer. The amount of overlap to permit between\n                           adjacent HSPs when tiling HSPs. A reasonable value is 2.\n                           Default = $Bio::SearchIO::blast::MAX_HSP_OVERLAP.\n\n            The following criteria are not yet supported:\n            (these are probably best applied within this module rather than in the \n             event handler since they would permit the parser to take some shortcuts.)\n\n           -check_all_hits => boolean. Check all hits for significance against\n                              significance criteria.  Default = false.\n                              If false, stops processing hits after the first\n                              non-significant hit or the first hit that fails\n                              the hit_filter call. This speeds parsing,\n                              taking advantage of the fact that the hits\n                              are processed in the order they appear in the report.\n           -min_query_len => integer to be used as a minimum for query sequence length.\n                             Reports with query sequences below this length will\n                             not be processed. Default = no minimum length.\n           -best        => boolean. Only process the best hit of each report;\n                           default = false.\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n\n    # Blast reports require a specialized version of the SREB due to the\n    # possibility of iterations (PSI-BLAST). Forwarding all arguments to it. An\n    # issue here is that we want to set new default object factories if none are\n    # supplied.\n\n    my $handler = Bio::SearchIO::IteratedSearchResultEventBuilder->new(@args);\n    $self->attach_EventHandler($handler);\n    \n    # 2006-04-26 move this to the attach_handler function in this module so we\n    # can really reset the handler \n    # Optimization: caching\n    # the EventHandler since it is used a lot during the parse.\n    \n    # $self->{'_handler_cache'} = $handler;\n\n    my ( $min_qlen, $check_all, $overlap, $best, $rpttype ) = $self->_rearrange(\n        [\n            qw(MIN_LENGTH CHECK_ALL_HITS\n              OVERLAP BEST\n              REPORT_TYPE)\n        ],\n        @args\n    );\n\n    defined $min_qlen  && $self->min_query_length($min_qlen);\n    defined $best      && $self->best_hit_only($best);\n    defined $check_all && $self->check_all_hits($check_all);\n    defined $rpttype   && ( $self->{'_reporttype'} = $rpttype );\n}\n\nsub attach_EventHandler {\n    my ($self,$handler) = @_;\n\n    $self->SUPER::attach_EventHandler($handler);    \n\n    # Optimization: caching the EventHandler since it is used a lot\n    # during the parse.\n\n    $self->{'_handler_cache'} = $handler;\n    return;\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    my $v      = $self->verbose;\n    my $data   = '';\n    my $flavor = '';\n    $self->{'_seentop'} = 0;     # start next report at top\n    $self->{'_seentop'} = 0;\n    my ( $reporttype, $seenquery, $reportline );  \n    my ( $seeniteration, $found_again );\n    my $incl_threshold = $self->inclusion_threshold;\n    my $bl2seq_fix;\n    $self->start_document();  # let the fun begin...\n    my (@hit_signifs);\n    my $gapped_stats = 0;    # for switching between gapped/ungapped\n                             # lambda, K, H\n    local $_ = \"\\n\";   #consistency\n    PARSER:\n    while ( defined( $_ = $self->_readline ) ) {\n        next if (/^\\s+$/);       # skip empty lines\n        next if (/CPU time:/);\n        next if (/^>\\s*$/);\n        if (\n               /^((?:\\S+?)?BLAST[NPX]?)\\s+(.+)$/i  # NCBI BLAST, PSIBLAST\n                                                   # RPSBLAST, MEGABLAST\n            || /^(P?GENEWISE|HFRAME|SWN|TSWN)\\s+(.+)/i    #Paracel BTK\n          )\n        {\n            ($reporttype, my $reportversion) = ($1, $2);\n            # need to keep track of whether this is WU-BLAST\n            if ($reportversion && $reportversion =~ m{WashU$}) {\n                $self->{'_wublast'}++;\n            }\n            $self->debug(\"blast.pm: Start of new report: $reporttype, $reportversion\\n\");\n            if ( $self->{'_seentop'} ) { \n                # This handles multi-result input streams\n                $self->_pushback($_);\n                last PARSER;\n            }\n            $self->_start_blastoutput;\n            if ($reporttype =~ /RPS-BLAST/) {\n                $reporttype .= '(BLASTP)'; # default RPS-BLAST type\n            }\n            $reportline = $_;   # to fix the fact that RPS-BLAST output is wrong\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_program',\n                    'Data' => $reporttype\n                }\n            );\n\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_version',\n                    'Data' => $reportversion\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_inclusion-threshold',\n                    'Data' => $incl_threshold\n                }\n            );\n        }\n        # added Windows workaround for bug 1985\n        elsif (/^(Searching|Results from round)/) { \n            next unless $1 =~ /Results from round/; \n            $self->debug(\"blast.pm: Possible psi blast iterations found...\\n\");\n            \n            $self->in_element('hsp')\n              && $self->end_element( { 'Name' => 'Hsp' } );\n            $self->in_element('hit')\n              && $self->end_element( { 'Name' => 'Hit' } );\n            if ( defined $seeniteration ) {\n                $self->within_element('iteration')\n                  && $self->end_element( { 'Name' => 'Iteration' } );\n                $self->start_element( { 'Name' => 'Iteration' } );\n            }\n            else {\n                $self->start_element( { 'Name' => 'Iteration' } );\n            }\n            $seeniteration = 1;\n        }\n        elsif (/^Query=\\s*(.*)$/) {\n            my $q    = $1;\n            $self->debug(\"blast.pm: Query= found...$_\\n\");\n            my $size = 0;\n            if ( defined $seenquery ) {\n                $self->_pushback($reportline) if $reportline;\n                $self->_pushback($_);\n                last PARSER;\n            }\n            else {\n                if ( !defined $reporttype ) {\n                    $self->_start_blastoutput;\n                    if ( defined $seeniteration ) {\n                        $self->in_element('iteration')\n                          && $self->end_element( { 'Name' => 'Iteration' } );\n                        $self->start_element( { 'Name' => 'Iteration' } );\n                    }\n                    else {\n                        $self->start_element( { 'Name' => 'Iteration' } );\n                    }\n                    $seeniteration = 1;\n                }\n            }\n            $seenquery = $q;\n            $_ = $self->_readline;\n            while ( defined($_) ) {\n                if (/^Database:/) {\n                    $self->_pushback($_);\n                    last;\n                }\n                # below line fixes length issue with BLAST v2.2.13; still works \n                # with BLAST v2.2.12\n                if ( /\\((\\-?[\\d,]+)\\s+letters.*\\)/ || /^Length=(\\-?[\\d,]+)/ ) {\n                    $size = $1;\n                    $size =~ s/,//g;\n                    last;\n                }\n                else {\n                    # bug 2391\n                    $q .= ($q =~ /\\w$/ && $_ =~ /^\\w/) ? \" $_\" : $_;\n                    $q =~ s/\\s+/ /g; # this catches the newline as well\n                    $q =~ s/^ | $//g;\n                }\n\n                $_ = $self->_readline;\n            }\n            chomp($q);\n            my ( $nm, $desc ) = split( /\\s+/, $q, 2 );\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_query-def',\n                    'Data' => $nm\n                }\n            ) if $nm;\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_query-len',\n                    'Data' => $size\n                }\n            );\n            defined $desc && $desc =~ s/\\s+$//;\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_querydesc',\n                    'Data' => $desc\n                }\n            );\n            my ( $gi, $acc, $version ) = $self->_get_seq_identifiers($nm);\n            $version = defined($version) && length($version) ? \".$version\" : \"\";\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_query-acc',\n                    'Data' => \"$acc$version\"\n                }\n            ) if $acc;\n        }\n\t\t# added check for WU-BLAST -echofilter option (bug 2388)\n\t\telsif (/^>Unfiltered[+-]1$/) {\n        \t# skip all of the lines of unfiltered sequence\n\t\t\twhile($_ !~ /^Database:/) {\n\t\t\t\t$self->debug(\"Bypassing features line: $_\");\n        \t\t$_ = $self->_readline;\n        \t}\n\t\t\t$self->_pushback($_);\n\t\t}\n        elsif (/Sequences producing significant alignments:/) {\n            $self->debug(\"blast.pm: Processing NCBI-BLAST descriptions\\n\");\n            $flavor = 'ncbi';\n            \n            # PSI-BLAST parsing needs to be fixed to specifically look\n            # for old vs new per iteration, as sorting based on duplication\n            # leads to bugs, see bug 1986\n            \n            # The next line is not necessarily whitespace in psiblast reports.\n            # Also note that we must look for the end of this section by testing\n            # for a line with a leading >. Blank lines occur with this section\n            # for psiblast.\n            if ( !$self->in_element('iteration') ) {\n                $self->start_element( { 'Name' => 'Iteration' } );\n            }\n            # these elements are dropped with some multiquery reports; add\n            # back here\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_db-len',\n                    'Data' => $self->{'_blsdb_length'}\n                } \n            ) if $self->{'_blsdb_length'};\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_db-let',\n                    'Data' => $self->{'_blsdb_letters'}\n                }\n            ) if $self->{'_blsdb_letters'};\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_db',\n                    'Data' => $self->{'_blsdb'}\n                }\n            ) if $self->{'_blsdb_letters'};\n            \n            # changed 8/28/2008 to exit hit table if blank line is found after an\n            # appropriate line\n            my $h_regex;\n            my $seen_block;\n          DESCLINE:\n            while ( defined( my $descline = $self->_readline() ) ) {\n                if ($descline =~ m{^\\s*$}) {\n                    last DESCLINE if $seen_block;\n                    next DESCLINE;\n                }\n                # any text match is part of block...\n                $seen_block++;\n                # GCG multiline oddness...\n                if ($descline =~ /^(\\S+)\\s+Begin:\\s\\d+\\s+End:\\s+\\d+/xms) {\n                    my ($id, $nextline) = ($1, $self->_readline);\n                    $nextline =~ s{^!}{};\n                    $descline = \"$id $nextline\";\n                }\n                # NCBI style hit table (no N)\n                if ($descline =~ /(?<!cor)          # negative lookahead\n                    (\\d*\\.?(?:[\\+\\-eE]+)?\\d+)       # number (float or scientific notation)\n                    \\s+                             # space\n                    (\\d*\\.?(?:[\\+\\-eE]+)?\\d+)       # number (float or scientific notation)\n                    \\s*$/xms) {\n                    \n                    my ( $score, $evalue ) = ($1, $2);\n                    \n                    # Some data clean-up so e-value will appear numeric to perl\n                    $evalue =~ s/^e/1e/i;\n\n                    # This to handle no-HSP case\n                    my @line = split ' ',$descline;\n                    \n                    # we want to throw away the score, evalue\n                    pop @line, pop @line;\n\n                    # and N if it is present (of course they are not\n                    # really in that order, but it doesn't matter\n                    if ($3) { pop @line }\n\n                    # add the last 2 entries s.t. we can reconstruct\n                    # a minimal Hit object at the end of the day\n                    push @hit_signifs, [ $evalue, $score, shift @line, join( ' ', @line ) ];\n                } elsif ($descline =~ /^CONVERGED/i) {\n                    $self->element(\n                        {\n                            'Name' => 'Iteration_converged',\n                            'Data' => 1\n                        }\n                    );\n                } else {\n                    $self->_pushback($descline); # Catch leading > (end of section)\n                    last DESCLINE;\n                }\n            }\n        }\n        elsif (/Sequences producing High-scoring Segment Pairs:/) {\n\n     # This block is for WU-BLAST, so we don't have to check for psi-blast stuff\n     # skip the next line\n            $self->debug(\"blast.pm: Processing WU-BLAST descriptions\\n\");\n            $_      = $self->_readline();\n            $flavor = 'wu';\n\n            if ( !$self->in_element('iteration') ) {\n                $self->start_element( { 'Name' => 'Iteration' } );\n            }\n\n            while ( defined( $_ = $self->_readline() )\n                && !/^\\s+$/ )\n            {\n                my @line = split;\n                pop @line;    # throw away first number which is for 'N'col\n\n                # add the last 2 entries to array s.t. we can reconstruct\n                # a minimal Hit object at the end of the day\n                push @hit_signifs,\n                  [ pop @line, pop @line, shift @line, join( ' ', @line ) ];\n            }\n            \n        }\n        elsif (/^Database:\\s*(.+)$/) {\n\n            $self->debug(\"blast.pm: Database: $1\\n\");\n            my $db = $1;\n            while ( defined( $_ = $self->_readline ) ) {\n                if (\n                    /^\\s+(\\-?[\\d\\,]+|\\S+)\\s+sequences\\;\n                   \\s+(\\-?[\\d,]+|\\S+)\\s+ # Deal with NCBI 2.2.8 OSX problems\n                   total\\s+letters/ox\n                  )\n                {\n                    my ( $s, $l ) = ( $1, $2 );\n                    $s =~ s/,//g;\n                    $l =~ s/,//g;\n                    $self->element(\n                        {\n                            'Name' => 'BlastOutput_db-len',\n                            'Data' => $s\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'BlastOutput_db-let',\n                            'Data' => $l\n                        }\n                    );\n                    # cache for next round in cases with multiple queries\n                    $self->{'_blsdb'} = $db;\n                    $self->{'_blsdb_length'} = $s;\n                    $self->{'_blsdb_letters'} = $l;                    \n                    last;\n                }\n                else {\n                    chomp;\n                    $db .= $_;\n                }\n            }\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_db',\n                    'Data' => $db\n                }\n            );\n        }\n        # bypasses this NCBI blast 2.2.13 extra output for now...\n\t\t# Features in/flanking this part of subject sequence:\n        elsif (/^\\sFeatures\\s\\w+\\sthis\\spart/xmso) {\n            my $featline;\n            $_ = $self->_readline;\n\t\t\twhile($_ !~ /^\\s*$/) {\n                chomp;\n                $featline .= $_;\n        \t\t$_ = $self->_readline;\n        \t}\n\t\t\t$self->_pushback($_);\n            $featline =~ s{(?:^\\s+|\\s+^)}{}g;\n            $featline =~ s{\\n}{;}g;\n            $self->{'_last_hspdata'}->{'Hsp_features'} = $featline;\n        }\n        \n        # move inside of a hit\n        elsif (/^>\\s*(\\S+)\\s*(.*)?/) {\n            chomp;\n\n            $self->debug(\"blast.pm: Hit: $1\\n\");\n            $self->in_element('hsp')\n              && $self->end_element( { 'Name' => 'Hsp' } );\n            $self->in_element('hit')\n              && $self->end_element( { 'Name' => 'Hit' } );\n\n            # special case when bl2seq reports don't have a leading\n            # Query=\n            if ( !$self->within_element('result') ) {\n                $self->_start_blastoutput;\n                $self->start_element( { 'Name' => 'Iteration' } );\n            }\n            elsif ( !$self->within_element('iteration') ) {\n                $self->start_element( { 'Name' => 'Iteration' } );\n            }\n            $self->start_element( { 'Name' => 'Hit' } );\n            my $id         = $1;\n            my $restofline = $2;\n\n            $self->debug(\"Starting a hit: $1 $2\\n\");\n            $self->element(\n                {\n                    'Name' => 'Hit_id',\n                    'Data' => $id\n                }\n            );\n            my ($gi, $acc, $version ) = $self->_get_seq_identifiers($id);\n            $self->element(\n                {\n                    'Name' => 'Hit_accession',\n                    'Data' => $acc\n                }\n            );\n            # add hit significance (from the hit table)\n            # this is where Bug 1986 went awry\n            \n            # Changed for Bug2409; hit->significance and hit->score/bits derived\n            # from HSPs, not hit table unless necessary\n            \n            HITTABLE:\n            while (my $v = shift @hit_signifs) {        \n                my $tableid = $v->[2];\n                if ($tableid !~ m{\\Q$id\\E}) {\n                    $self->debug(\"Hit table ID $tableid doesn't match current hit id $id, checking next hit table entry...\\n\");\n                    next HITTABLE;\n                } else {\n                    last HITTABLE;\n                }\n            }\n            while ( defined( $_ = $self->_readline() ) ) {\n                next if (/^\\s+$/);\n                chomp;\n                if (/Length\\s*=\\s*([\\d,]+)/) {\n                    my $l = $1;\n                    $l =~ s/\\,//g;\n                    $self->element(\n                        {\n                            'Name' => 'Hit_len',\n                            'Data' => $l\n                        }\n                    );\n                    last;\n                }\n                else {\n                    s/^\\s(?!\\s)/\\x01/; #new line to concatenate desc lines with <soh>\n                    $restofline .= $_;\n                }\n            }\n            $restofline =~ s/\\s+/ /g;\n            $self->element(\n                {\n                    'Name' => 'Hit_def',\n                    'Data' => $restofline\n                }\n            );\n        }\n        elsif (/\\s+(Plus|Minus) Strand HSPs:/i) {\n            next;\n        }\n        elsif (\n            ( $self->in_element('hit') || $self->in_element('hsp') )\n            &&    # paracel genewise BTK\n            m/Score\\s*=\\s*(\\S+)\\s*bits\\s* # Bit score\n                (?:\\((\\d+)\\))?,                 # Raw score\n\t\t\\s+Log\\-Length\\sScore\\s*=\\s*(\\d+) # Log-Length score\n                /ox\n          )\n        {\n            $self->in_element('hsp')\n              && $self->end_element( { 'Name' => 'Hsp' } );\n            $self->start_element( { 'Name' => 'Hsp' } );\n\n            $self->debug( \"Got paracel genewise HSP score=$1\\n\");\n\n            # Some data clean-up so e-value will appear numeric to perl\n            my ( $bits, $score, $evalue ) = ( $1, $2, $3 );\n            $evalue =~ s/^e/1e/i;\n            $self->element(\n                {\n                    'Name' => 'Hsp_score',\n                    'Data' => $score\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_bit-score',\n                    'Data' => $bits\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_evalue',\n                    'Data' => $evalue\n                }\n            );\n        }\n        elsif (\n            ( $self->in_element('hit') || $self->in_element('hsp') )\n            &&    # paracel hframe BTK\n            m/Score\\s*=\\s*([^,\\s]+),     # Raw score\n\t\t\\s*Expect\\s*=\\s*([^,\\s]+),  # E-value\n                \\s*P(?:\\(\\S+\\))?\\s*=\\s*([^,\\s]+) # P-value\n                /ox\n          )\n        {\n            $self->in_element('hsp')\n              && $self->end_element( { 'Name' => 'Hsp' } );\n            $self->start_element( { 'Name' => 'Hsp' } );\n\n            $self->debug( \"Got paracel hframe HSP score=$1\\n\");\n\n            # Some data clean-up so e-value will appear numeric to perl\n            my ( $score, $evalue, $pvalue ) = ( $1, $2, $3 );\n            $evalue = \"1$evalue\" if $evalue =~ /^e/;\n            $pvalue = \"1$pvalue\" if $pvalue =~ /^e/;\n\n            $self->element(\n                {\n                    'Name' => 'Hsp_score',\n                    'Data' => $score\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_evalue',\n                    'Data' => $evalue\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_pvalue',\n                    'Data' => $pvalue\n                }\n            );\n        }\n        elsif (\n            ( $self->in_element('hit') || $self->in_element('hsp') )\n            &&    # wublast\n            m/Score\\s*=\\s*(\\S+)\\s*         # Bit score\n                \\(([\\d\\.]+)\\s*bits\\),         # Raw score\n                \\s*Expect\\s*=\\s*([^,\\s]+),    # E-value\n                \\s*(?:Sum)?\\s*                # SUM\n                P(?:\\(\\d+\\))?\\s*=\\s*([^,\\s]+) # P-value\n                (?:\\s*,\\s+Group\\s*\\=\\s*(\\d+))?    # HSP Group\n                /ox\n          )\n        {         # wu-blast HSP parse\n            $self->in_element('hsp')\n              && $self->end_element( { 'Name' => 'Hsp' } );\n            $self->start_element( { 'Name' => 'Hsp' } );\n\n            # Some data clean-up so e-value will appear numeric to perl\n            my ( $score, $bits, $evalue, $pvalue, $group ) =\n              ( $1, $2, $3, $4, $5 );\n            $evalue =~ s/^e/1e/i;\n            $pvalue =~ s/^e/1e/i;\n\n            $self->element(\n                {\n                    'Name' => 'Hsp_score',\n                    'Data' => $score\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_bit-score',\n                    'Data' => $bits\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_evalue',\n                    'Data' => $evalue\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_pvalue',\n                    'Data' => $pvalue\n                }\n            );\n\n            if ( defined $group ) {\n                $self->element(\n                    {\n                        'Name' => 'Hsp_group',\n                        'Data' => $group\n                    }\n                );\n            }\n\n        }\n        elsif (\n            ( $self->in_element('hit') || $self->in_element('hsp') )\n            &&    # ncbi blast, works with 2.2.17\n            m/Score\\s*=\\s*(\\S+)\\s*bits\\s* # Bit score\n                (?:\\((\\d+)\\))?,            # Missing for BLAT pseudo-BLAST fmt \n                \\s*Expect(?:\\((\\d+\\+?)\\))?\\s*=\\s*([^,\\s]+) # E-value\n                /ox\n          )\n        {         # parse NCBI blast HSP\n            $self->in_element('hsp')\n              && $self->end_element( { 'Name' => 'Hsp' } );\n\n            # Some data clean-up so e-value will appear numeric to perl\n            my ( $bits, $score, $n, $evalue ) = ( $1, $2, $3, $4 );\n            $evalue =~ s/^e/1e/i;\n            $self->start_element( { 'Name' => 'Hsp' } );\n            $self->element(\n                {\n                    'Name' => 'Hsp_score',\n                    'Data' => $score\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_bit-score',\n                    'Data' => $bits\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_evalue',\n                    'Data' => $evalue\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_n',\n                    'Data' => $n\n                }\n            ) if defined $n;\n            $score = '' unless defined $score;    # deal with BLAT which\n                                                  # has no score only bits\n            $self->debug(\"Got NCBI HSP score=$score, evalue $evalue\\n\");\n        }\n        elsif (\n            $self->in_element('hsp')\n            && m/Identities\\s*=\\s*(\\d+)\\s*\\/\\s*(\\d+)\\s*[\\d\\%\\(\\)]+\\s*\n                (?:,\\s*Positives\\s*=\\s*(\\d+)\\/(\\d+)\\s*[\\d\\%\\(\\)]+\\s*)? # pos only valid for Protein alignments\n                (?:\\,\\s*Gaps\\s*=\\s*(\\d+)\\/(\\d+))? # Gaps\n                /oxi\n          )\n        {\n            $self->element(\n                {\n                    'Name' => 'Hsp_identity',\n                    'Data' => $1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_align-len',\n                    'Data' => $2\n                }\n            );\n            if ( defined $3 ) {\n                $self->element(\n                    {\n                        'Name' => 'Hsp_positive',\n                        'Data' => $3\n                    }\n                );\n            }\n            else {\n                $self->element(\n                    {\n                        'Name' => 'Hsp_positive',\n                        'Data' => $1\n                    }\n                );\n            }\n            if ( defined $6 ) {\n                $self->element(\n                    {\n                        'Name' => 'Hsp_gaps',\n                        'Data' => $5\n                    }\n                );\n            }\n\n            $self->{'_Query'} = { 'begin' => 0, 'end' => 0 };\n            $self->{'_Sbjct'} = { 'begin' => 0, 'end' => 0 };\n\n            if (/(Frame\\s*=\\s*.+)$/) {\n\n                # handle wu-blast Frame listing on same line\n                $self->_pushback($1);\n            }\n        }\n        elsif ( $self->in_element('hsp')\n            && /Strand\\s*=\\s*(Plus|Minus)\\s*\\/\\s*(Plus|Minus)/i )\n        {\n\n            # consume this event ( we infer strand from start/end)\n            unless ($reporttype) {\n                $self->{'_reporttype'} = $reporttype = 'BLASTN';\n                $bl2seq_fix = 1;    # special case to resubmit the algorithm\n                                    # reporttype\n            }\n            next;\n        }\n        elsif ( $self->in_element('hsp')\n            && /Links\\s*=\\s*(\\S+)/ox )\n        {\n            $self->element(\n                {\n                    'Name' => 'Hsp_links',\n                    'Data' => $1\n                }\n            );\n        }\n        elsif ( $self->in_element('hsp')\n            && /Frame\\s*=\\s*([\\+\\-][1-3])\\s*(\\/\\s*([\\+\\-][1-3]))?/ )\n        {\n\n            # this is for bl2seq only\n            unless ( defined $reporttype ) {\n                $bl2seq_fix = 1;\n                if ( $1 && $2 ) { $reporttype = 'TBLASTX' }\n                else {\n                    $reporttype = 'BLASTX';\n\n    # we can't distinguish between BLASTX and TBLASTN straight from the report }\n                }\n                $self->{'_reporttype'} = $reporttype;\n            }\n\n            my ( $queryframe, $hitframe );\n            if ( $reporttype eq 'TBLASTX' ) {\n                ( $queryframe, $hitframe ) = ( $1, $2 );\n                $hitframe =~ s/\\/\\s*//g;\n            }\n            elsif ( $reporttype eq 'TBLASTN' || $reporttype eq 'PSITBLASTN') {\n                ( $hitframe, $queryframe ) = ( $1, 0 );\n            }\n            elsif ( $reporttype eq 'BLASTX' || $reporttype eq 'RPS-BLAST(BLASTP)') {\n                ( $queryframe, $hitframe ) = ( $1, 0 );\n                # though NCBI doesn't report it, this is a special BLASTX-like\n                # RPS-BLAST; should be handled differently\n                if ($reporttype eq 'RPS-BLAST(BLASTP)') {\n                    $self->element(\n                        {\n                            'Name' => 'BlastOutput_program',\n                            'Data' => 'RPS-BLAST(BLASTX)'\n                        }\n                    );\n                }\n            }\n            $self->element(\n                {\n                    'Name' => 'Hsp_query-frame',\n                    'Data' => $queryframe\n                }\n            );\n\n            $self->element(\n                {\n                    'Name' => 'Hsp_hit-frame',\n                    'Data' => $hitframe\n                }\n            );\n        }\n        elsif (/^Parameters:/\n            || /^\\s+Database:\\s+?/\n            || /^\\s+Subset/\n            || /^\\s*Lambda/\n            || /^\\s*Histogram/\n            || ( $self->in_element('hsp') && /WARNING|NOTE/ ) )\n        {\n\n            # Note: Lambda check was necessary to parse\n            # t/data/ecoli_domains.rpsblast AND to parse bl2seq\n            $self->debug(\"blast.pm: found parameters section \\n\");\n\n            $self->in_element('hsp')\n              && $self->end_element( { 'Name' => 'Hsp' } );\n            $self->in_element('hit')\n              && $self->end_element( { 'Name' => 'Hit' } );\n\n            # This is for the case when we specify -b 0 (or B=0 for WU-BLAST)\n            # and still want to construct minimal Hit objects\n            $self->_cleanup_hits(\\@hit_signifs) if scalar(@hit_signifs);\n            $self->within_element('iteration')\n              && $self->end_element( { 'Name' => 'Iteration' } );\n\n            next if /^\\s+Subset/;\n            my $blast = (/^(\\s+Database\\:)|(\\s*Lambda)/) ? 'ncbi' : 'wublast';\n            if (/^\\s*Histogram/) {\n                $blast = 'btk';\n            }\n\n            my $last = '';\n\n            # default is that gaps are allowed\n            $self->element(\n                {\n                    'Name' => 'Parameters_allowgaps',\n                    'Data' => 'yes'\n                }\n            );\n            while ( defined( $_ = $self->_readline ) ) {\n                if (\n                    /^((?:\\S+)?BLAST[NPX]?)\\s+(.+)$/i  # NCBI BLAST, PSIBLAST\n                                                      # RPSBLAST, MEGABLAST\n                    || /^(P?GENEWISE|HFRAME|SWN|TSWN)\\s+(.+)/i    #Paracel BTK\n                  )\n                {\n                    $self->_pushback($_);\n\n                    # let's handle this in the loop\n                    last;\n                }\n                elsif (/^Query=/) {\n                    $self->_pushback($reportline) if $reportline;\n                    $self->_pushback($_);\n                    last PARSER;\n                }\n\n                # here is where difference between wublast and ncbiblast\n                # is better handled by different logic\n                if (   /Number of Sequences:\\s+([\\d\\,]+)/i\n                    || /of sequences in database:\\s+(\\-?[\\d,]+)/i )\n                {\n                    my $c = $1;\n                    $c =~ s/\\,//g;\n                    $self->element(\n                        {\n                            'Name' => 'Statistics_db-len',\n                            'Data' => $c\n                        }\n                    );\n                }\n                elsif (/letters in database:\\s+(\\-?[\\d,]+)/i) {\n                    my $s = $1;\n                    $s =~ s/,//g;\n                    $self->element(\n                        {\n                            'Name' => 'Statistics_db-let',\n                            'Data' => $s\n                        }\n                    );\n                }\n                elsif ( $blast eq 'btk' ) {\n                    next;\n                }\n                elsif ( $blast eq 'wublast' ) {\n\n                    #\t\t   warn($_);\n                    if (/E=(\\S+)/) {\n                        $self->element(\n                            {\n                                'Name' => 'Parameters_expect',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (/nogaps/) {\n                        $self->element(\n                            {\n                                'Name' => 'Parameters_allowgaps',\n                                'Data' => 'no'\n                            }\n                        );\n                    }\n                    elsif (/ctxfactor=(\\S+)/) {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_ctxfactor',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (\n/(postsw|links|span[12]?|warnings|notes|gi|noseqs|qres|qype)/\n                      )\n                    {\n                        $self->element(\n                            {\n                                'Name' => \"Parameters_$1\",\n                                'Data' => 'yes'\n                            }\n                        );\n                    }\n                    elsif (/(\\S+)=(\\S+)/) {\n                        $self->element(\n                            {\n                                'Name' => \"Parameters_$1\",\n                                'Data' => $2\n                            }\n                        );\n                    }\n                    elsif ( $last =~ /(Frame|Strand)\\s+MatID\\s+Matrix name/i ) {\n                        my $firstgapinfo = 1;\n                        my $frame        = undef;\n                        while ( defined($_) && !/^\\s+$/ ) {\n                            s/^\\s+//;\n                            s/\\s+$//;\n                            if ( $firstgapinfo\n                                && s/Q=(\\d+),R=(\\d+)\\s+//x )\n                            {\n                                $firstgapinfo = 0;\n\n                                $self->element(\n                                    {\n                                        'Name' => 'Parameters_gap-open',\n                                        'Data' => $1\n                                    }\n                                );\n                                $self->element(\n                                    {\n                                        'Name' => 'Parameters_gap-extend',\n                                        'Data' => $2\n                                    }\n                                );\n                                my @fields = split;\n\n                                for my $type (\n                                    qw(lambda_gapped\n                                    kappa_gapped\n                                    entropy_gapped)\n                                  )\n                                {\n                                    next if $type eq 'n/a';\n                                    if ( !@fields ) {\n                                        warn \"fields is empty for $type\\n\";\n                                        next;\n                                    }\n                                    $self->element(\n                                        {\n                                            'Name' =>\n                                              \"Statistics_frame$frame\\_$type\",\n                                            'Data' => shift @fields\n                                        }\n                                    );\n                                }\n                            }\n                            else {\n                                my ( $frameo, $matid, $matrix, @fields ) =\n                                  split;\n                                if ( !defined $frame ) {\n\n                                    # keep some sort of default feature I guess\n                                    # even though this is sort of wrong\n                                    $self->element(\n                                        {\n                                            'Name' => 'Parameters_matrix',\n                                            'Data' => $matrix\n                                        }\n                                    );\n                                    $self->element(\n                                        {\n                                            'Name' => 'Statistics_lambda',\n                                            'Data' => $fields[0]\n                                        }\n                                    );\n                                    $self->element(\n                                        {\n                                            'Name' => 'Statistics_kappa',\n                                            'Data' => $fields[1]\n                                        }\n                                    );\n                                    $self->element(\n                                        {\n                                            'Name' => 'Statistics_entropy',\n                                            'Data' => $fields[2]\n                                        }\n                                    );\n                                }\n                                $frame = $frameo;\n                                my $ii = 0;\n                                for my $type (\n                                    qw(lambda_used\n                                    kappa_used\n                                    entropy_used\n                                    lambda_computed\n                                    kappa_computed\n                                    entropy_computed)\n                                  )\n                                {\n                                    my $f = $fields[$ii];\n                                    next unless defined $f;    # deal with n/a\n                                    if ( $f eq 'same' ) {\n                                        $f = $fields[ $ii - 3 ];\n                                    }\n                                    $ii++;\n                                    $self->element(\n                                        {\n                                            'Name' =>\n                                              \"Statistics_frame$frame\\_$type\",\n                                            'Data' => $f\n                                        }\n                                    );\n\n                                }\n                            }\n\n                            # get the next line\n                            $_ = $self->_readline;\n                        }\n                        $last = $_;\n                    }\n                    elsif ( $last =~ /(Frame|Strand)\\s+MatID\\s+Length/i ) {\n                        my $frame = undef;\n                        while ( defined($_) && !/^\\s+/ ) {\n                            s/^\\s+//;\n                            s/\\s+$//;\n                            my @fields = split;\n                            if ( @fields <= 3 ) {\n                                for my $type (qw(X_gapped E2_gapped S2)) {\n                                    last unless @fields;\n                                    $self->element(\n                                        {\n                                            'Name' =>\n                                              \"Statistics_frame$frame\\_$type\",\n                                            'Data' => shift @fields\n                                        }\n                                    );\n                                }\n                            }\n                            else {\n\n                                for my $type (\n                                    qw(length\n                                    efflength\n                                    E S W T X E2 S2)\n                                  )\n                                {\n                                    $self->element(\n                                        {\n                                            'Name' =>\n                                              \"Statistics_frame$frame\\_$type\",\n                                            'Data' => shift @fields\n                                        }\n                                    );\n                                }\n                            }\n                            $_ = $self->_readline;\n                        }\n                        $last = $_;\n                    }\n                    elsif (/(\\S+\\s+\\S+)\\s+DFA:\\s+(\\S+)\\s+\\((.+)\\)/) {\n                        if ( $1 eq 'states in' ) {\n                            $self->element(\n                                {\n                                    'Name' => 'Statistics_DFA_states',\n                                    'Data' => \"$2 $3\"\n                                }\n                            );\n                        }\n                        elsif ( $1 eq 'size of' ) {\n                            $self->element(\n                                {\n                                    'Name' => 'Statistics_DFA_size',\n                                    'Data' => \"$2 $3\"\n                                }\n                            );\n                        }\n                    }\n                    elsif (\n                        m/^\\s+Time to generate neighborhood:\\s+\n\t\t\t    (\\S+\\s+\\S+\\s+\\S+)/x\n                      )\n                    {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_neighbortime',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (/processors\\s+used:\\s+(\\d+)/) {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_noprocessors',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (\n                        m/^\\s+(\\S+)\\s+cpu\\s+time:\\s+# cputype\n\t\t\t    (\\S+\\s+\\S+\\s+\\S+)           # cputime\n\t\t\t    \\s+Elapsed:\\s+(\\S+)/x\n                      )\n                    {\n                        my $cputype = lc($1);\n                        $self->element(\n                            {\n                                'Name' => \"Statistics_$cputype\\_cputime\",\n                                'Data' => $2\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => \"Statistics_$cputype\\_actualtime\",\n                                'Data' => $3\n                            }\n                        );\n                    }\n                    elsif (/^\\s+Start:/) {\n                        my ( $junk, $start, $stime, $end, $etime ) =\n                          split( /\\s+(Start|End)\\:\\s+/, $_ );\n                        chomp($stime);\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_starttime',\n                                'Data' => $stime\n                            }\n                        );\n                        chomp($etime);\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_endtime',\n                                'Data' => $etime\n                            }\n                        );\n                    }\n                    elsif (/^\\s+Database:\\s+(.+)$/) {\n                        $self->element(\n                            {\n                                'Name' => 'Parameters_full_dbpath',\n                                'Data' => $1\n                            }\n                        );\n\n                    }\n                    elsif (/^\\s+Posted:\\s+(.+)/) {\n                        my $d = $1;\n                        chomp($d);\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_posted_date',\n                                'Data' => $d\n                            }\n                        );\n                    }\n                }\n                elsif ( $blast eq 'ncbi' ) {\n\n                    if (m/^Matrix:\\s+(.+)\\s*$/oxi) {\n                        $self->element(\n                            {\n                                'Name' => 'Parameters_matrix',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (/^Gapped/) {\n                        $gapped_stats = 1;\n                    }\n                    elsif (/^Lambda/) {\n                        $_ = $self->_readline;\n                        s/^\\s+//;\n                        my ( $lambda, $kappa, $entropy ) = split;\n                        if ($gapped_stats) {\n                            $self->element(\n                                {\n                                    'Name' => \"Statistics_gapped_lambda\",\n                                    'Data' => $lambda\n                                }\n                            );\n                            $self->element(\n                                {\n                                    'Name' => \"Statistics_gapped_kappa\",\n                                    'Data' => $kappa\n                                }\n                            );\n                            $self->element(\n                                {\n                                    'Name' => \"Statistics_gapped_entropy\",\n                                    'Data' => $entropy\n                                }\n                            );\n                        }\n                        else {\n                            $self->element(\n                                {\n                                    'Name' => \"Statistics_lambda\",\n                                    'Data' => $lambda\n                                }\n                            );\n                            $self->element(\n                                {\n                                    'Name' => \"Statistics_kappa\",\n                                    'Data' => $kappa\n                                }\n                            );\n                            $self->element(\n                                {\n                                    'Name' => \"Statistics_entropy\",\n                                    'Data' => $entropy\n                                }\n                            );\n                        }\n                    }\n                    elsif (m/effective\\s+search\\s+space\\s+used:\\s+(\\d+)/ox) {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_eff-spaceused',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (m/effective\\s+search\\s+space:\\s+(\\d+)/ox) {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_eff-space',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (\n                        m/Gap\\s+Penalties:\\s+Existence:\\s+(\\d+)\\,\n\t\t\t    \\s+Extension:\\s+(\\d+)/ox\n                      )\n                    {\n                        $self->element(\n                            {\n                                'Name' => 'Parameters_gap-open',\n                                'Data' => $1\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Parameters_gap-extend',\n                                'Data' => $2\n                            }\n                        );\n                    }\n                    elsif (/effective\\s+HSP\\s+length:\\s+(\\d+)/) {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_hsp-len',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (/effective\\s+length\\s+of\\s+query:\\s+([\\d\\,]+)/) {\n                        my $c = $1;\n                        $c =~ s/\\,//g;\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_query-len',\n                                'Data' => $c\n                            }\n                        );\n                    }\n                    elsif (/effective\\s+length\\s+of\\s+database:\\s+([\\d\\,]+)/) {\n                        my $c = $1;\n                        $c =~ s/\\,//g;\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_eff-dblen',\n                                'Data' => $c\n                            }\n                        );\n                    }\n                    elsif (\n/^(T|A|X1|X2|X3|S1|S2):\\s+(\\d+(\\.\\d+)?)\\s+(?:\\(\\s*(\\d+\\.\\d+) bits\\))?/\n                      )\n                    {\n                        my $v = $2;\n                        chomp($v);\n                        $self->element(\n                            {\n                                'Name' => \"Statistics_$1\",\n                                'Data' => $v\n                            }\n                        );\n                        if ( defined $4 ) {\n                            $self->element(\n                                {\n                                    'Name' => \"Statistics_$1_bits\",\n                                    'Data' => $4\n                                }\n                            );\n                        }\n                    }\n                    elsif (\n                        m/frameshift\\s+window\\,\n\t\t\t    \\s+decay\\s+const:\\s+(\\d+)\\,\\s+([\\.\\d]+)/x\n                      )\n                    {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_framewindow',\n                                'Data' => $1\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_decay',\n                                'Data' => $2\n                            }\n                        );\n                    }\n                    elsif (m/^Number\\s+of\\s+Hits\\s+to\\s+DB:\\s+(\\S+)/ox) {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_hit_to_db',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (m/^Number\\s+of\\s+extensions:\\s+(\\S+)/ox) {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_num_extensions',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (\n                        m/^Number\\s+of\\s+successful\\s+extensions:\\s+\n\t\t\t    (\\S+)/ox\n                      )\n                    {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_num_suc_extensions',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (\n                        m/^Number\\s+of\\s+sequences\\s+better\\s+than\\s+\n\t\t\t    (\\S+):\\s+(\\d+)/ox\n                      )\n                    {\n                        $self->element(\n                            {\n                                'Name' => 'Parameters_expect',\n                                'Data' => $1\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_seqs_better_than_cutoff',\n                                'Data' => $2\n                            }\n                        );\n                    }\n                    elsif (/^\\s+Posted\\s+date:\\s+(.+)/) {\n                        my $d = $1;\n                        chomp($d);\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_posted_date',\n                                'Data' => $d\n                            }\n                        );\n                    }\n                    elsif ( !/^\\s+$/ ) {\n                        #$self->debug( \"unmatched stat $_\");\n                    }\n                }\n                $last = $_;\n            }\n        } elsif ( $self->in_element('hsp') ) {\n            $self->debug(\"blast.pm: Processing HSP\\n\");\n            # let's read 3 lines at a time;\n            # bl2seq hackiness... Not sure I like\n            $self->{'_reporttype'} ||= $DEFAULTREPORTTYPE;\n            my %data = (\n                'Query' => '',\n                'Mid'   => '',\n                'Hit'   => ''\n            );\n            my $len;\n            for ( my $i = 0 ; defined($_) && $i < 3 ; $i++ ) {\n                # $self->debug(\"$i: $_\") if $v;\n                if ( ( $i == 0 && /^\\s+$/) || \n\t\t     /^\\s*(?:Lambda|Minus|Plus|Score)/i )\n                {\n                    $self->_pushback($_) if defined $_;\n                    $self->end_element( { 'Name' => 'Hsp' } );\n                    last;\n                }\n                chomp;\n                if (/^((Query|Sbjct):?\\s+(\\-?\\d+)\\s*)(\\S+)\\s+(\\-?\\d+)/) {\n                    my ( $full, $type, $start, $str, $end ) =\n                      ( $1, $2, $3, $4, $5 );\n\n                    if ( $str eq '-' ) {\n                        $i = 3 if $type eq 'Sbjct';\n                    }\n                    else {\n                        $data{$type} = $str;\n                    }\n                    $len = length($full);\n                    $self->{\"\\_$type\"}->{'begin'} = $start\n                      unless $self->{\"_$type\"}->{'begin'};\n                    $self->{\"\\_$type\"}->{'end'} = $end;\n                } else {\n                    $self->throw(\"no data for midline $_\")\n                      unless ( defined $_ && defined $len );\n                    $data{'Mid'} = substr( $_, $len );\n                }\n                $_ = $self->_readline();\n            }\n            $self->characters(\n                {\n                    'Name' => 'Hsp_qseq',\n                    'Data' => $data{'Query'}\n                }\n            );\n            $self->characters(\n                {\n                    'Name' => 'Hsp_hseq',\n                    'Data' => $data{'Sbjct'}\n                }\n            );\n            $self->characters(\n                {\n                    'Name' => 'Hsp_midline',\n                    'Data' => $data{'Mid'}\n                }\n            );\n        }\n        else {\n            #$self->debug(\"blast.pm: unrecognized line $_\");\n        }\n    }\n\n    $self->debug(\"blast.pm: End of BlastOutput\\n\");\n    if ( $self->{'_seentop'} ) {\n        $self->within_element('hsp')\n          && $self->end_element( { 'Name' => 'Hsp' } );\n        $self->within_element('hit')\n          && $self->end_element( { 'Name' => 'Hit' } );\n        # cleanup extra hits\n        $self->_cleanup_hits(\\@hit_signifs) if scalar(@hit_signifs);\n        $self->within_element('iteration')\n          && $self->end_element( { 'Name' => 'Iteration' } );\n        if ($bl2seq_fix) {\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_program',\n                    'Data' => $reporttype\n                }\n            );\n        }\n        $self->end_element( { 'Name' => 'BlastOutput' } );\n    }\n    return $self->end_document();\n}\n\n# Private method for internal use only.\nsub _start_blastoutput {\n    my $self = shift;\n    $self->start_element( { 'Name' => 'BlastOutput' } );\n    $self->{'_seentop'} = 1;\n    $self->{'_result_count'}++;\n    $self->{'_handler_rc'} = undef;\n}\n\n=head2 _will_handle\n\n Title   : _will_handle\n Usage   : Private method. For internal use only.\n              if( $self->_will_handle($type) ) { ... }\n Function: Provides an optimized way to check whether or not an element of a \n           given type is to be handled.\n Returns : Reference to EventHandler object if the element type is to be handled.\n           undef if the element type is not to be handled.\n Args    : string containing type of element.\n\nOptimizations:\n\n=over 2\n\n* 1\n\nUsing the cached pointer to the EventHandler to minimize repeated\nlookups.\n\n* 2\n\nCaching the will_handle status for each type that is encountered so\nthat it only need be checked by calling\nhandler-E<gt>will_handle($type) once.\n\n\nThis does not lead to a major savings by itself (only 5-10%).  In\ncombination with other optimizations, or for large parse jobs, the\nsavings good be significant.\n\nTo test against the unoptimized version, remove the parentheses from\naround the third term in the ternary \" ? : \" operator and add two\ncalls to $self-E<gt>_eventHandler().\n\n\nsub _will_handle {\n    my ( $self, $type ) = @_;\n    my $handler     = $self->{'_handler_cache'};\n    my $will_handle =\n      defined( $self->{'_will_handle_cache'}->{$type} )\n      ? $self->{'_will_handle_cache'}->{$type}\n      : ( $self->{'_will_handle_cache'}->{$type} =\n          $handler->will_handle($type) );\n\n    return $will_handle ? $handler : undef;\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\nsub start_element {\n    my ( $self, $data ) = @_;\n\n    # we currently don't care about attributes\n    my $nm   = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    if ($type) {\n        my $handler = $self->_will_handle($type);\n        if ($handler) {\n            my $func = sprintf( \"start_%s\", lc $type );\n            $self->{'_handler_rc'} = $handler->$func( $data->{'Attributes'} );\n        }\n        #else {\n            #$self->debug( # changed 4/29/2006 to play nice with other event handlers\n            #    \"Bio::SearchIO::InternalParserError \".\n            #    \"\\nCan't handle elements of type \\'$type.\\'\"\n            #);\n        #}\n        unshift @{ $self->{'_elements'} }, $type;\n        if ( $type eq 'result' ) {\n            $self->{'_values'} = {};\n            $self->{'_result'} = undef;\n        } else {\n            # cleanup some things\n            if ( defined $self->{'_values'} ) {\n                foreach my $k (\n                    grep { /^\\U$type\\-/ }\n                    keys %{ $self->{'_values'} }\n                  )\n                {\n                    delete $self->{'_values'}->{$k};\n                }\n            }\n        }\n    }\n}\n\n=head2 end_element\n\n Title   : end_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : hashref with an element's worth of data\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ( $self, $data ) = @_;\n    \n    my $nm   = $data->{'Name'};\n    my $type;\n    my $rc;\n    if ( $nm eq 'BlastOutput_program' ) {\n        if ( $self->{'_last_data'} =~ /(t?blast[npx])/i ) {\n            $self->{'_reporttype'} = uc $1;\n        }\n        $self->{'_reporttype'} ||= $DEFAULTREPORTTYPE;\n    }\n\n    # Hsps are sort of weird, in that they end when another\n    # object begins so have to detect this in end_element for now\n    if ( $nm eq 'Hsp' ) {\n        foreach (qw(Hsp_qseq Hsp_midline Hsp_hseq Hsp_features)) {\n            $self->element(\n                {\n                    'Name' => $_,\n                    'Data' => $self->{'_last_hspdata'}->{$_}\n                }\n            ) if defined $self->{'_last_hspdata'}->{$_};\n        }\n        $self->{'_last_hspdata'} = {};\n        $self->element(\n            {\n                'Name' => 'Hsp_query-from',\n                'Data' => $self->{'_Query'}->{'begin'}\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_query-to',\n                'Data' => $self->{'_Query'}->{'end'}\n            }\n        );\n\n        $self->element(\n            {\n                'Name' => 'Hsp_hit-from',\n                'Data' => $self->{'_Sbjct'}->{'begin'}\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_hit-to',\n                'Data' => $self->{'_Sbjct'}->{'end'}\n            }\n        );\n\n        #    } elsif( $nm eq 'Iteration' ) {\n        # Nothing special needs to be done here.\n    }\n    if ( $type = $MODEMAP{$nm} ) {\n        my $handler = $self->_will_handle($type);\n        if ($handler) {\n            my $func = sprintf( \"end_%s\", lc $type );\n            $rc = $handler->$func( $self->{'_reporttype'}, $self->{'_values'} );\n        }\n        shift @{ $self->{'_elements'} };\n\n    }\n    elsif ( $MAPPING{$nm} ) {\n        if ( ref( $MAPPING{$nm} ) =~ /hash/i ) {\n\n            # this is where we shove in the data from the\n            # hashref info about params or statistics\n            my $key = ( keys %{ $MAPPING{$nm} } )[0];\n            $self->{'_values'}->{$key}->{ $MAPPING{$nm}->{$key} } =\n              $self->{'_last_data'};\n        }\n        else {\n            $self->{'_values'}->{ $MAPPING{$nm} } = $self->{'_last_data'};\n        }\n    }\n    else {\n        #$self->debug(\"blast.pm: unknown nm $nm, ignoring\\n\");\n    }\n    $self->{'_last_data'} = '';    # remove read data if we are at\n                                   # end of an element\n    $self->{'_result'} = $rc if ( defined $type && $type eq 'result' );\n    return $rc;\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convenience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'","label":"element($self,$data)"},"detail":"($self,$data)","definition":"sub","containerName":"main::","children":[{"name":"$self","definition":"my","containerName":"element","localvar":"my","kind":13,"line":2071},{"line":2071,"kind":13,"containerName":"element","name":"$data"},{"kind":13,"line":2075,"containerName":"element","name":"$self"},{"line":2075,"kind":12,"containerName":"element","name":"characters"},{"name":"$data","containerName":"element","line":2075,"kind":13},{"name":"$self","containerName":"element","kind":13,"line":2076},{"containerName":"element","name":"end_element","kind":12,"line":2076},{"containerName":"element","name":"$data","line":2076,"kind":13}],"line":2070,"kind":12,"range":{"end":{"line":2077,"character":9999},"start":{"line":2070,"character":0}},"name":"element"},{"signature":{"documentation":"(Sesame Street aficionados note: This answer was NOT given by Mr. Noodle ;-P)\n# $Id: blast.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::blast\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n# 20030409 - sac\n#          PSI-BLAST full parsing support. Rollout of new\n#          model which will remove Steve's old psiblast driver\n# 20030424 - jason\n#          Megablast parsing fix as reported by Neil Saunders\n# 20030427 - jason\n#          Support bl2seq parsing\n# 20031124 - jason\n#          Parse more blast statistics, lambda, entropy, etc\n#          from WU-BLAST in frame-specific manner\n# 20060216 - cjf - fixed blast parsing for BLAST v2.2.13 output\n# 20071104 - dmessina - added support for WUBLAST -echofilter\n# 20071121 - cjf - fixed several bugs (bugs 2391, 2399, 2409)\n\n=head1 NAME\n\nBio::SearchIO::blast - Event generator for event based parsing of\nblast reports\n\n=head1 SYNOPSIS\n\n   # Do not use this object directly - it is used as part of the\n   # Bio::SearchIO system.\n\n    use Bio::SearchIO;\n    my $searchio = Bio::SearchIO->new(-format => 'blast',\n                                     -file   => 't/data/ecolitst.bls');\n    while( my $result = $searchio->next_result ) {\n        while( my $hit = $result->next_hit ) {\n            while( my $hsp = $hit->next_hsp ) {\n                # ...\n            }\n        }\n    }\n\n=head1 DESCRIPTION\n\nThis object encapsulated the necessary methods for generating events\nsuitable for building Bio::Search objects from a BLAST report file.\nRead the L<Bio::SearchIO> for more information about how to use this.\n\nThis driver can parse:\n\n=over 4\n\n* * \n\nNCBI produced plain text BLAST reports from blastall, this also\nincludes PSIBLAST, PSITBLASTN, RPSBLAST, and bl2seq reports.  NCBI XML\nBLAST output is parsed with the blastxml SearchIO driver\n\n* *\n\nWU-BLAST all reports\n\n* *\n\nJim Kent's BLAST-like output from his programs (BLASTZ, BLAT)\n\n* *\n\nBLAST-like output from Paracel BTK output\n\n\n=head2 bl2seq parsing\n\nSince I cannot differentiate between BLASTX and TBLASTN since bl2seq\ndoesn't report the algorithm used - I assume it is BLASTX by default -\nyou can supply the program type with -report_type in the SearchIO\nconstructor i.e.\n\n  my $parser = Bio::SearchIO->new(-format => 'blast',\n                                 -file => 'bl2seq.tblastn.report',\n                                 -report_type => 'tblastn');\n\nThis only really affects where the frame and strand information are\nput - they will always be on the $hsp-E<gt>query instead of on the\n$hsp-E<gt>hit part of the feature pair for blastx and tblastn bl2seq\nproduced reports.  Hope that's clear...\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail Jason Stajich jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nSteve Chervitz sac-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...'\n\npackage Bio::SearchIO::blast;\n\nuse Bio::SearchIO::IteratedSearchResultEventBuilder;\nuse strict;\nuse vars qw(%MAPPING %MODEMAP\n  $DEFAULT_BLAST_WRITER_CLASS\n  $MAX_HSP_OVERLAP\n  $DEFAULT_SIGNIF\n  $DEFAULT_SCORE\n  $DEFAULTREPORTTYPE\n);\n\n\nuse base qw(Bio::SearchIO);\nuse Data::Dumper;\n\nBEGIN {\n\n    # mapping of NCBI Blast terms to Bioperl hash keys\n    %MODEMAP = (\n        'BlastOutput' => 'result',\n        'Iteration'   => 'iteration',\n        'Hit'         => 'hit',\n        'Hsp'         => 'hsp'\n    );\n\n    # This should really be done more intelligently, like with\n    # XSLT\n\n    %MAPPING = (\n        'Hsp_bit-score'   => 'HSP-bits',\n        'Hsp_score'       => 'HSP-score',\n        'Hsp_evalue'      => 'HSP-evalue',\n        'Hsp_n',          => 'HSP-n',\n        'Hsp_pvalue'      => 'HSP-pvalue',\n        'Hsp_query-from'  => 'HSP-query_start',\n        'Hsp_query-to'    => 'HSP-query_end',\n        'Hsp_hit-from'    => 'HSP-hit_start',\n        'Hsp_hit-to'      => 'HSP-hit_end',\n        'Hsp_positive'    => 'HSP-conserved',\n        'Hsp_identity'    => 'HSP-identical',\n        'Hsp_gaps'        => 'HSP-hsp_gaps',\n        'Hsp_hitgaps'     => 'HSP-hit_gaps',\n        'Hsp_querygaps'   => 'HSP-query_gaps',\n        'Hsp_qseq'        => 'HSP-query_seq',\n        'Hsp_hseq'        => 'HSP-hit_seq',\n        'Hsp_midline'     => 'HSP-homology_seq',\n        'Hsp_align-len'   => 'HSP-hsp_length',\n        'Hsp_query-frame' => 'HSP-query_frame',\n        'Hsp_hit-frame'   => 'HSP-hit_frame',\n        'Hsp_links'       => 'HSP-links',\n        'Hsp_group'       => 'HSP-hsp_group',\n        'Hsp_features'    => 'HSP-hit_features',\n\n        'Hit_id'        => 'HIT-name',\n        'Hit_len'       => 'HIT-length',\n        'Hit_accession' => 'HIT-accession',\n        'Hit_def'       => 'HIT-description',\n        'Hit_signif'    => 'HIT-significance',\n        # For NCBI blast, the description line contains bits.\n        # For WU-blast, the  description line contains score.\n        'Hit_score' => 'HIT-score',\n        'Hit_bits'  => 'HIT-bits',\n\n        'Iteration_iter-num'  => 'ITERATION-number',\n        'Iteration_converged' => 'ITERATION-converged',\n\n        'BlastOutput_program'             => 'RESULT-algorithm_name',\n        'BlastOutput_version'             => 'RESULT-algorithm_version',\n        'BlastOutput_query-def'           => 'RESULT-query_name',\n        'BlastOutput_query-len'           => 'RESULT-query_length',\n        'BlastOutput_query-acc'           => 'RESULT-query_accession',\n        'BlastOutput_query-gi'            => 'RESULT-query_gi',\n        'BlastOutput_querydesc'           => 'RESULT-query_description',\n        'BlastOutput_db'                  => 'RESULT-database_name',\n        'BlastOutput_db-len'              => 'RESULT-database_entries',\n        'BlastOutput_db-let'              => 'RESULT-database_letters',\n        'BlastOutput_inclusion-threshold' => 'RESULT-inclusion_threshold',\n\n        'Parameters_matrix'      => { 'RESULT-parameters' => 'matrix' },\n        'Parameters_expect'      => { 'RESULT-parameters' => 'expect' },\n        'Parameters_include'     => { 'RESULT-parameters' => 'include' },\n        'Parameters_sc-match'    => { 'RESULT-parameters' => 'match' },\n        'Parameters_sc-mismatch' => { 'RESULT-parameters' => 'mismatch' },\n        'Parameters_gap-open'    => { 'RESULT-parameters' => 'gapopen' },\n        'Parameters_gap-extend'  => { 'RESULT-parameters' => 'gapext' },\n        'Parameters_filter'      => { 'RESULT-parameters' => 'filter' },\n        'Parameters_allowgaps'   => { 'RESULT-parameters' => 'allowgaps' },\n        'Parameters_full_dbpath' => { 'RESULT-parameters' => 'full_dbpath' },\n        'Statistics_db-len'      => { 'RESULT-statistics' => 'dbentries' },\n        'Statistics_db-let'      => { 'RESULT-statistics' => 'dbletters' },\n        'Statistics_hsp-len'     =>\n          { 'RESULT-statistics' => 'effective_hsplength' },\n        'Statistics_query-len' => { 'RESULT-statistics' => 'querylength' },\n        'Statistics_eff-space' => { 'RESULT-statistics' => 'effectivespace' },\n        'Statistics_eff-spaceused' =>\n          { 'RESULT-statistics' => 'effectivespaceused' },\n        'Statistics_eff-dblen' =>\n          { 'RESULT-statistics' => 'effectivedblength' },\n        'Statistics_kappa'         => { 'RESULT-statistics' => 'kappa' },\n        'Statistics_lambda'        => { 'RESULT-statistics' => 'lambda' },\n        'Statistics_entropy'       => { 'RESULT-statistics' => 'entropy' },\n        'Statistics_gapped_kappa'  => { 'RESULT-statistics' => 'kappa_gapped' },\n        'Statistics_gapped_lambda' =>\n          { 'RESULT-statistics' => 'lambda_gapped' },\n        'Statistics_gapped_entropy' =>\n          { 'RESULT-statistics' => 'entropy_gapped' },\n\n        'Statistics_framewindow' =>\n          { 'RESULT-statistics' => 'frameshiftwindow' },\n        'Statistics_decay' => { 'RESULT-statistics' => 'decayconst' },\n\n        'Statistics_hit_to_db' => { 'RESULT-statistics' => 'Hits_to_DB' },\n        'Statistics_num_suc_extensions' =>\n          { 'RESULT-statistics' => 'num_successful_extensions' },\n\n        # WU-BLAST stats\n        'Statistics_DFA_states' => { 'RESULT-statistics' => 'num_dfa_states' },\n        'Statistics_DFA_size'   => { 'RESULT-statistics' => 'dfa_size' },\n        'Statistics_noprocessors' =>\n          { 'RESULT-statistics' => 'no_of_processors' },\n        'Statistics_neighbortime' =>\n          { 'RESULT-statistics' => 'neighborhood_generate_time' },\n        'Statistics_starttime' => { 'RESULT-statistics' => 'start_time' },\n        'Statistics_endtime'   => { 'RESULT-statistics' => 'end_time' },\n    );\n\n    # add WU-BLAST Frame-Based Statistics\n    for my $frame ( 0 .. 3 ) {\n        for my $strand ( '+', '-' ) {\n            for my $ind (\n                qw(length efflength E S W T X X_gapped E2\n                E2_gapped S2)\n              )\n            {\n                $MAPPING{\"Statistics_frame$strand$frame\\_$ind\"} =\n                  { 'RESULT-statistics' => \"Frame$strand$frame\\_$ind\" };\n            }\n            for my $val (qw(lambda kappa entropy )) {\n                for my $type (qw(used computed gapped)) {\n                    my $key = \"Statistics_frame$strand$frame\\_$val\\_$type\";\n                    my $val =\n                      { 'RESULT-statistics' =>\n                          \"Frame$strand$frame\\_$val\\_$type\" };\n                    $MAPPING{$key} = $val;\n                }\n            }\n        }\n    }\n\n    # add Statistics\n    for my $stats (\n        qw(T A X1 X2 X3 S1 S2 X1_bits X2_bits X3_bits\n        S1_bits S2_bits  num_extensions\n        num_successful_extensions\n        seqs_better_than_cutoff\n        posted_date\n        search_cputime total_cputime\n        search_actualtime total_actualtime\n        no_of_processors ctxfactor)\n      )\n    {\n        my $key = \"Statistics_$stats\";\n        my $val = { 'RESULT-statistics' => $stats };\n        $MAPPING{$key} = $val;\n    }\n\n    # add WU-BLAST Parameters\n    for my $param (\n        qw(span span1 span2 links warnings notes hspsepsmax\n        hspsepqmax topcomboN topcomboE postsw cpus wordmask\n        filter sort_by_pvalue sort_by_count sort_by_highscore\n        sort_by_totalscore sort_by_subjectlength noseqs gi qtype\n        qres V B Z Y M N)\n      )\n    {\n        my $key = \"Parameters_$param\";\n        my $val = { 'RESULT-parameters' => $param };\n        $MAPPING{$key} = $val;\n    }\n\n    $DEFAULT_BLAST_WRITER_CLASS = 'Bio::Search::Writer::HitTableWriter';\n    $MAX_HSP_OVERLAP   = 2;           # Used when tiling multiple HSPs.\n    $DEFAULTREPORTTYPE = 'BLASTP';    # for bl2seq\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::blast->new(%args);\n Function: Builds a new Bio::SearchIO::blast object \n Returns : Bio::SearchIO::blast\n Args    : Key-value pairs:\n           -fh/-file => filehandle/filename to BLAST file\n           -format   => 'blast'\n           -report_type => 'blastx', 'tblastn', etc -- only for bl2seq\n                           reports when you want to distinguish between\n                           tblastn and blastx reports (this only controls\n                           where the frame information is put - on the query\n                           or subject object.\n           -inclusion_threshold => e-value threshold for inclusion in the\n                                   PSI-BLAST score matrix model (blastpgp)\n           -signif      => float or scientific notation number to be used\n                           as a P- or Expect value cutoff\n           -score       => integer or scientific notation number to be used\n                           as a blast score value cutoff\n           -bits        => integer or scientific notation number to be used\n                           as a bit score value cutoff\n           -hit_filter  => reference to a function to be used for\n                           filtering hits based on arbitrary criteria.\n                           All hits of each BLAST report must satisfy \n                           this criteria to be retained. \n                           If a hit fails this test, it is ignored.\n                           This function should take a\n                           Bio::Search::Hit::BlastHit.pm object as its first\n                           argument and return true\n                           if the hit should be retained.\n                           Sample filter function:\n                              -hit_filter => sub { $hit = shift;\n                                                   $hit->gaps == 0; },\n                           (Note: -filt_func is synonymous with -hit_filter)\n           -overlap     => integer. The amount of overlap to permit between\n                           adjacent HSPs when tiling HSPs. A reasonable value is 2.\n                           Default = $Bio::SearchIO::blast::MAX_HSP_OVERLAP.\n\n            The following criteria are not yet supported:\n            (these are probably best applied within this module rather than in the \n             event handler since they would permit the parser to take some shortcuts.)\n\n           -check_all_hits => boolean. Check all hits for significance against\n                              significance criteria.  Default = false.\n                              If false, stops processing hits after the first\n                              non-significant hit or the first hit that fails\n                              the hit_filter call. This speeds parsing,\n                              taking advantage of the fact that the hits\n                              are processed in the order they appear in the report.\n           -min_query_len => integer to be used as a minimum for query sequence length.\n                             Reports with query sequences below this length will\n                             not be processed. Default = no minimum length.\n           -best        => boolean. Only process the best hit of each report;\n                           default = false.\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n\n    # Blast reports require a specialized version of the SREB due to the\n    # possibility of iterations (PSI-BLAST). Forwarding all arguments to it. An\n    # issue here is that we want to set new default object factories if none are\n    # supplied.\n\n    my $handler = Bio::SearchIO::IteratedSearchResultEventBuilder->new(@args);\n    $self->attach_EventHandler($handler);\n    \n    # 2006-04-26 move this to the attach_handler function in this module so we\n    # can really reset the handler \n    # Optimization: caching\n    # the EventHandler since it is used a lot during the parse.\n    \n    # $self->{'_handler_cache'} = $handler;\n\n    my ( $min_qlen, $check_all, $overlap, $best, $rpttype ) = $self->_rearrange(\n        [\n            qw(MIN_LENGTH CHECK_ALL_HITS\n              OVERLAP BEST\n              REPORT_TYPE)\n        ],\n        @args\n    );\n\n    defined $min_qlen  && $self->min_query_length($min_qlen);\n    defined $best      && $self->best_hit_only($best);\n    defined $check_all && $self->check_all_hits($check_all);\n    defined $rpttype   && ( $self->{'_reporttype'} = $rpttype );\n}\n\nsub attach_EventHandler {\n    my ($self,$handler) = @_;\n\n    $self->SUPER::attach_EventHandler($handler);    \n\n    # Optimization: caching the EventHandler since it is used a lot\n    # during the parse.\n\n    $self->{'_handler_cache'} = $handler;\n    return;\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    my $v      = $self->verbose;\n    my $data   = '';\n    my $flavor = '';\n    $self->{'_seentop'} = 0;     # start next report at top\n    $self->{'_seentop'} = 0;\n    my ( $reporttype, $seenquery, $reportline );  \n    my ( $seeniteration, $found_again );\n    my $incl_threshold = $self->inclusion_threshold;\n    my $bl2seq_fix;\n    $self->start_document();  # let the fun begin...\n    my (@hit_signifs);\n    my $gapped_stats = 0;    # for switching between gapped/ungapped\n                             # lambda, K, H\n    local $_ = \"\\n\";   #consistency\n    PARSER:\n    while ( defined( $_ = $self->_readline ) ) {\n        next if (/^\\s+$/);       # skip empty lines\n        next if (/CPU time:/);\n        next if (/^>\\s*$/);\n        if (\n               /^((?:\\S+?)?BLAST[NPX]?)\\s+(.+)$/i  # NCBI BLAST, PSIBLAST\n                                                   # RPSBLAST, MEGABLAST\n            || /^(P?GENEWISE|HFRAME|SWN|TSWN)\\s+(.+)/i    #Paracel BTK\n          )\n        {\n            ($reporttype, my $reportversion) = ($1, $2);\n            # need to keep track of whether this is WU-BLAST\n            if ($reportversion && $reportversion =~ m{WashU$}) {\n                $self->{'_wublast'}++;\n            }\n            $self->debug(\"blast.pm: Start of new report: $reporttype, $reportversion\\n\");\n            if ( $self->{'_seentop'} ) { \n                # This handles multi-result input streams\n                $self->_pushback($_);\n                last PARSER;\n            }\n            $self->_start_blastoutput;\n            if ($reporttype =~ /RPS-BLAST/) {\n                $reporttype .= '(BLASTP)'; # default RPS-BLAST type\n            }\n            $reportline = $_;   # to fix the fact that RPS-BLAST output is wrong\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_program',\n                    'Data' => $reporttype\n                }\n            );\n\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_version',\n                    'Data' => $reportversion\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_inclusion-threshold',\n                    'Data' => $incl_threshold\n                }\n            );\n        }\n        # added Windows workaround for bug 1985\n        elsif (/^(Searching|Results from round)/) { \n            next unless $1 =~ /Results from round/; \n            $self->debug(\"blast.pm: Possible psi blast iterations found...\\n\");\n            \n            $self->in_element('hsp')\n              && $self->end_element( { 'Name' => 'Hsp' } );\n            $self->in_element('hit')\n              && $self->end_element( { 'Name' => 'Hit' } );\n            if ( defined $seeniteration ) {\n                $self->within_element('iteration')\n                  && $self->end_element( { 'Name' => 'Iteration' } );\n                $self->start_element( { 'Name' => 'Iteration' } );\n            }\n            else {\n                $self->start_element( { 'Name' => 'Iteration' } );\n            }\n            $seeniteration = 1;\n        }\n        elsif (/^Query=\\s*(.*)$/) {\n            my $q    = $1;\n            $self->debug(\"blast.pm: Query= found...$_\\n\");\n            my $size = 0;\n            if ( defined $seenquery ) {\n                $self->_pushback($reportline) if $reportline;\n                $self->_pushback($_);\n                last PARSER;\n            }\n            else {\n                if ( !defined $reporttype ) {\n                    $self->_start_blastoutput;\n                    if ( defined $seeniteration ) {\n                        $self->in_element('iteration')\n                          && $self->end_element( { 'Name' => 'Iteration' } );\n                        $self->start_element( { 'Name' => 'Iteration' } );\n                    }\n                    else {\n                        $self->start_element( { 'Name' => 'Iteration' } );\n                    }\n                    $seeniteration = 1;\n                }\n            }\n            $seenquery = $q;\n            $_ = $self->_readline;\n            while ( defined($_) ) {\n                if (/^Database:/) {\n                    $self->_pushback($_);\n                    last;\n                }\n                # below line fixes length issue with BLAST v2.2.13; still works \n                # with BLAST v2.2.12\n                if ( /\\((\\-?[\\d,]+)\\s+letters.*\\)/ || /^Length=(\\-?[\\d,]+)/ ) {\n                    $size = $1;\n                    $size =~ s/,//g;\n                    last;\n                }\n                else {\n                    # bug 2391\n                    $q .= ($q =~ /\\w$/ && $_ =~ /^\\w/) ? \" $_\" : $_;\n                    $q =~ s/\\s+/ /g; # this catches the newline as well\n                    $q =~ s/^ | $//g;\n                }\n\n                $_ = $self->_readline;\n            }\n            chomp($q);\n            my ( $nm, $desc ) = split( /\\s+/, $q, 2 );\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_query-def',\n                    'Data' => $nm\n                }\n            ) if $nm;\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_query-len',\n                    'Data' => $size\n                }\n            );\n            defined $desc && $desc =~ s/\\s+$//;\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_querydesc',\n                    'Data' => $desc\n                }\n            );\n            my ( $gi, $acc, $version ) = $self->_get_seq_identifiers($nm);\n            $version = defined($version) && length($version) ? \".$version\" : \"\";\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_query-acc',\n                    'Data' => \"$acc$version\"\n                }\n            ) if $acc;\n        }\n\t\t# added check for WU-BLAST -echofilter option (bug 2388)\n\t\telsif (/^>Unfiltered[+-]1$/) {\n        \t# skip all of the lines of unfiltered sequence\n\t\t\twhile($_ !~ /^Database:/) {\n\t\t\t\t$self->debug(\"Bypassing features line: $_\");\n        \t\t$_ = $self->_readline;\n        \t}\n\t\t\t$self->_pushback($_);\n\t\t}\n        elsif (/Sequences producing significant alignments:/) {\n            $self->debug(\"blast.pm: Processing NCBI-BLAST descriptions\\n\");\n            $flavor = 'ncbi';\n            \n            # PSI-BLAST parsing needs to be fixed to specifically look\n            # for old vs new per iteration, as sorting based on duplication\n            # leads to bugs, see bug 1986\n            \n            # The next line is not necessarily whitespace in psiblast reports.\n            # Also note that we must look for the end of this section by testing\n            # for a line with a leading >. Blank lines occur with this section\n            # for psiblast.\n            if ( !$self->in_element('iteration') ) {\n                $self->start_element( { 'Name' => 'Iteration' } );\n            }\n            # these elements are dropped with some multiquery reports; add\n            # back here\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_db-len',\n                    'Data' => $self->{'_blsdb_length'}\n                } \n            ) if $self->{'_blsdb_length'};\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_db-let',\n                    'Data' => $self->{'_blsdb_letters'}\n                }\n            ) if $self->{'_blsdb_letters'};\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_db',\n                    'Data' => $self->{'_blsdb'}\n                }\n            ) if $self->{'_blsdb_letters'};\n            \n            # changed 8/28/2008 to exit hit table if blank line is found after an\n            # appropriate line\n            my $h_regex;\n            my $seen_block;\n          DESCLINE:\n            while ( defined( my $descline = $self->_readline() ) ) {\n                if ($descline =~ m{^\\s*$}) {\n                    last DESCLINE if $seen_block;\n                    next DESCLINE;\n                }\n                # any text match is part of block...\n                $seen_block++;\n                # GCG multiline oddness...\n                if ($descline =~ /^(\\S+)\\s+Begin:\\s\\d+\\s+End:\\s+\\d+/xms) {\n                    my ($id, $nextline) = ($1, $self->_readline);\n                    $nextline =~ s{^!}{};\n                    $descline = \"$id $nextline\";\n                }\n                # NCBI style hit table (no N)\n                if ($descline =~ /(?<!cor)          # negative lookahead\n                    (\\d*\\.?(?:[\\+\\-eE]+)?\\d+)       # number (float or scientific notation)\n                    \\s+                             # space\n                    (\\d*\\.?(?:[\\+\\-eE]+)?\\d+)       # number (float or scientific notation)\n                    \\s*$/xms) {\n                    \n                    my ( $score, $evalue ) = ($1, $2);\n                    \n                    # Some data clean-up so e-value will appear numeric to perl\n                    $evalue =~ s/^e/1e/i;\n\n                    # This to handle no-HSP case\n                    my @line = split ' ',$descline;\n                    \n                    # we want to throw away the score, evalue\n                    pop @line, pop @line;\n\n                    # and N if it is present (of course they are not\n                    # really in that order, but it doesn't matter\n                    if ($3) { pop @line }\n\n                    # add the last 2 entries s.t. we can reconstruct\n                    # a minimal Hit object at the end of the day\n                    push @hit_signifs, [ $evalue, $score, shift @line, join( ' ', @line ) ];\n                } elsif ($descline =~ /^CONVERGED/i) {\n                    $self->element(\n                        {\n                            'Name' => 'Iteration_converged',\n                            'Data' => 1\n                        }\n                    );\n                } else {\n                    $self->_pushback($descline); # Catch leading > (end of section)\n                    last DESCLINE;\n                }\n            }\n        }\n        elsif (/Sequences producing High-scoring Segment Pairs:/) {\n\n     # This block is for WU-BLAST, so we don't have to check for psi-blast stuff\n     # skip the next line\n            $self->debug(\"blast.pm: Processing WU-BLAST descriptions\\n\");\n            $_      = $self->_readline();\n            $flavor = 'wu';\n\n            if ( !$self->in_element('iteration') ) {\n                $self->start_element( { 'Name' => 'Iteration' } );\n            }\n\n            while ( defined( $_ = $self->_readline() )\n                && !/^\\s+$/ )\n            {\n                my @line = split;\n                pop @line;    # throw away first number which is for 'N'col\n\n                # add the last 2 entries to array s.t. we can reconstruct\n                # a minimal Hit object at the end of the day\n                push @hit_signifs,\n                  [ pop @line, pop @line, shift @line, join( ' ', @line ) ];\n            }\n            \n        }\n        elsif (/^Database:\\s*(.+)$/) {\n\n            $self->debug(\"blast.pm: Database: $1\\n\");\n            my $db = $1;\n            while ( defined( $_ = $self->_readline ) ) {\n                if (\n                    /^\\s+(\\-?[\\d\\,]+|\\S+)\\s+sequences\\;\n                   \\s+(\\-?[\\d,]+|\\S+)\\s+ # Deal with NCBI 2.2.8 OSX problems\n                   total\\s+letters/ox\n                  )\n                {\n                    my ( $s, $l ) = ( $1, $2 );\n                    $s =~ s/,//g;\n                    $l =~ s/,//g;\n                    $self->element(\n                        {\n                            'Name' => 'BlastOutput_db-len',\n                            'Data' => $s\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'BlastOutput_db-let',\n                            'Data' => $l\n                        }\n                    );\n                    # cache for next round in cases with multiple queries\n                    $self->{'_blsdb'} = $db;\n                    $self->{'_blsdb_length'} = $s;\n                    $self->{'_blsdb_letters'} = $l;                    \n                    last;\n                }\n                else {\n                    chomp;\n                    $db .= $_;\n                }\n            }\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_db',\n                    'Data' => $db\n                }\n            );\n        }\n        # bypasses this NCBI blast 2.2.13 extra output for now...\n\t\t# Features in/flanking this part of subject sequence:\n        elsif (/^\\sFeatures\\s\\w+\\sthis\\spart/xmso) {\n            my $featline;\n            $_ = $self->_readline;\n\t\t\twhile($_ !~ /^\\s*$/) {\n                chomp;\n                $featline .= $_;\n        \t\t$_ = $self->_readline;\n        \t}\n\t\t\t$self->_pushback($_);\n            $featline =~ s{(?:^\\s+|\\s+^)}{}g;\n            $featline =~ s{\\n}{;}g;\n            $self->{'_last_hspdata'}->{'Hsp_features'} = $featline;\n        }\n        \n        # move inside of a hit\n        elsif (/^>\\s*(\\S+)\\s*(.*)?/) {\n            chomp;\n\n            $self->debug(\"blast.pm: Hit: $1\\n\");\n            $self->in_element('hsp')\n              && $self->end_element( { 'Name' => 'Hsp' } );\n            $self->in_element('hit')\n              && $self->end_element( { 'Name' => 'Hit' } );\n\n            # special case when bl2seq reports don't have a leading\n            # Query=\n            if ( !$self->within_element('result') ) {\n                $self->_start_blastoutput;\n                $self->start_element( { 'Name' => 'Iteration' } );\n            }\n            elsif ( !$self->within_element('iteration') ) {\n                $self->start_element( { 'Name' => 'Iteration' } );\n            }\n            $self->start_element( { 'Name' => 'Hit' } );\n            my $id         = $1;\n            my $restofline = $2;\n\n            $self->debug(\"Starting a hit: $1 $2\\n\");\n            $self->element(\n                {\n                    'Name' => 'Hit_id',\n                    'Data' => $id\n                }\n            );\n            my ($gi, $acc, $version ) = $self->_get_seq_identifiers($id);\n            $self->element(\n                {\n                    'Name' => 'Hit_accession',\n                    'Data' => $acc\n                }\n            );\n            # add hit significance (from the hit table)\n            # this is where Bug 1986 went awry\n            \n            # Changed for Bug2409; hit->significance and hit->score/bits derived\n            # from HSPs, not hit table unless necessary\n            \n            HITTABLE:\n            while (my $v = shift @hit_signifs) {        \n                my $tableid = $v->[2];\n                if ($tableid !~ m{\\Q$id\\E}) {\n                    $self->debug(\"Hit table ID $tableid doesn't match current hit id $id, checking next hit table entry...\\n\");\n                    next HITTABLE;\n                } else {\n                    last HITTABLE;\n                }\n            }\n            while ( defined( $_ = $self->_readline() ) ) {\n                next if (/^\\s+$/);\n                chomp;\n                if (/Length\\s*=\\s*([\\d,]+)/) {\n                    my $l = $1;\n                    $l =~ s/\\,//g;\n                    $self->element(\n                        {\n                            'Name' => 'Hit_len',\n                            'Data' => $l\n                        }\n                    );\n                    last;\n                }\n                else {\n                    s/^\\s(?!\\s)/\\x01/; #new line to concatenate desc lines with <soh>\n                    $restofline .= $_;\n                }\n            }\n            $restofline =~ s/\\s+/ /g;\n            $self->element(\n                {\n                    'Name' => 'Hit_def',\n                    'Data' => $restofline\n                }\n            );\n        }\n        elsif (/\\s+(Plus|Minus) Strand HSPs:/i) {\n            next;\n        }\n        elsif (\n            ( $self->in_element('hit') || $self->in_element('hsp') )\n            &&    # paracel genewise BTK\n            m/Score\\s*=\\s*(\\S+)\\s*bits\\s* # Bit score\n                (?:\\((\\d+)\\))?,                 # Raw score\n\t\t\\s+Log\\-Length\\sScore\\s*=\\s*(\\d+) # Log-Length score\n                /ox\n          )\n        {\n            $self->in_element('hsp')\n              && $self->end_element( { 'Name' => 'Hsp' } );\n            $self->start_element( { 'Name' => 'Hsp' } );\n\n            $self->debug( \"Got paracel genewise HSP score=$1\\n\");\n\n            # Some data clean-up so e-value will appear numeric to perl\n            my ( $bits, $score, $evalue ) = ( $1, $2, $3 );\n            $evalue =~ s/^e/1e/i;\n            $self->element(\n                {\n                    'Name' => 'Hsp_score',\n                    'Data' => $score\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_bit-score',\n                    'Data' => $bits\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_evalue',\n                    'Data' => $evalue\n                }\n            );\n        }\n        elsif (\n            ( $self->in_element('hit') || $self->in_element('hsp') )\n            &&    # paracel hframe BTK\n            m/Score\\s*=\\s*([^,\\s]+),     # Raw score\n\t\t\\s*Expect\\s*=\\s*([^,\\s]+),  # E-value\n                \\s*P(?:\\(\\S+\\))?\\s*=\\s*([^,\\s]+) # P-value\n                /ox\n          )\n        {\n            $self->in_element('hsp')\n              && $self->end_element( { 'Name' => 'Hsp' } );\n            $self->start_element( { 'Name' => 'Hsp' } );\n\n            $self->debug( \"Got paracel hframe HSP score=$1\\n\");\n\n            # Some data clean-up so e-value will appear numeric to perl\n            my ( $score, $evalue, $pvalue ) = ( $1, $2, $3 );\n            $evalue = \"1$evalue\" if $evalue =~ /^e/;\n            $pvalue = \"1$pvalue\" if $pvalue =~ /^e/;\n\n            $self->element(\n                {\n                    'Name' => 'Hsp_score',\n                    'Data' => $score\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_evalue',\n                    'Data' => $evalue\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_pvalue',\n                    'Data' => $pvalue\n                }\n            );\n        }\n        elsif (\n            ( $self->in_element('hit') || $self->in_element('hsp') )\n            &&    # wublast\n            m/Score\\s*=\\s*(\\S+)\\s*         # Bit score\n                \\(([\\d\\.]+)\\s*bits\\),         # Raw score\n                \\s*Expect\\s*=\\s*([^,\\s]+),    # E-value\n                \\s*(?:Sum)?\\s*                # SUM\n                P(?:\\(\\d+\\))?\\s*=\\s*([^,\\s]+) # P-value\n                (?:\\s*,\\s+Group\\s*\\=\\s*(\\d+))?    # HSP Group\n                /ox\n          )\n        {         # wu-blast HSP parse\n            $self->in_element('hsp')\n              && $self->end_element( { 'Name' => 'Hsp' } );\n            $self->start_element( { 'Name' => 'Hsp' } );\n\n            # Some data clean-up so e-value will appear numeric to perl\n            my ( $score, $bits, $evalue, $pvalue, $group ) =\n              ( $1, $2, $3, $4, $5 );\n            $evalue =~ s/^e/1e/i;\n            $pvalue =~ s/^e/1e/i;\n\n            $self->element(\n                {\n                    'Name' => 'Hsp_score',\n                    'Data' => $score\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_bit-score',\n                    'Data' => $bits\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_evalue',\n                    'Data' => $evalue\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_pvalue',\n                    'Data' => $pvalue\n                }\n            );\n\n            if ( defined $group ) {\n                $self->element(\n                    {\n                        'Name' => 'Hsp_group',\n                        'Data' => $group\n                    }\n                );\n            }\n\n        }\n        elsif (\n            ( $self->in_element('hit') || $self->in_element('hsp') )\n            &&    # ncbi blast, works with 2.2.17\n            m/Score\\s*=\\s*(\\S+)\\s*bits\\s* # Bit score\n                (?:\\((\\d+)\\))?,            # Missing for BLAT pseudo-BLAST fmt \n                \\s*Expect(?:\\((\\d+\\+?)\\))?\\s*=\\s*([^,\\s]+) # E-value\n                /ox\n          )\n        {         # parse NCBI blast HSP\n            $self->in_element('hsp')\n              && $self->end_element( { 'Name' => 'Hsp' } );\n\n            # Some data clean-up so e-value will appear numeric to perl\n            my ( $bits, $score, $n, $evalue ) = ( $1, $2, $3, $4 );\n            $evalue =~ s/^e/1e/i;\n            $self->start_element( { 'Name' => 'Hsp' } );\n            $self->element(\n                {\n                    'Name' => 'Hsp_score',\n                    'Data' => $score\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_bit-score',\n                    'Data' => $bits\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_evalue',\n                    'Data' => $evalue\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_n',\n                    'Data' => $n\n                }\n            ) if defined $n;\n            $score = '' unless defined $score;    # deal with BLAT which\n                                                  # has no score only bits\n            $self->debug(\"Got NCBI HSP score=$score, evalue $evalue\\n\");\n        }\n        elsif (\n            $self->in_element('hsp')\n            && m/Identities\\s*=\\s*(\\d+)\\s*\\/\\s*(\\d+)\\s*[\\d\\%\\(\\)]+\\s*\n                (?:,\\s*Positives\\s*=\\s*(\\d+)\\/(\\d+)\\s*[\\d\\%\\(\\)]+\\s*)? # pos only valid for Protein alignments\n                (?:\\,\\s*Gaps\\s*=\\s*(\\d+)\\/(\\d+))? # Gaps\n                /oxi\n          )\n        {\n            $self->element(\n                {\n                    'Name' => 'Hsp_identity',\n                    'Data' => $1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_align-len',\n                    'Data' => $2\n                }\n            );\n            if ( defined $3 ) {\n                $self->element(\n                    {\n                        'Name' => 'Hsp_positive',\n                        'Data' => $3\n                    }\n                );\n            }\n            else {\n                $self->element(\n                    {\n                        'Name' => 'Hsp_positive',\n                        'Data' => $1\n                    }\n                );\n            }\n            if ( defined $6 ) {\n                $self->element(\n                    {\n                        'Name' => 'Hsp_gaps',\n                        'Data' => $5\n                    }\n                );\n            }\n\n            $self->{'_Query'} = { 'begin' => 0, 'end' => 0 };\n            $self->{'_Sbjct'} = { 'begin' => 0, 'end' => 0 };\n\n            if (/(Frame\\s*=\\s*.+)$/) {\n\n                # handle wu-blast Frame listing on same line\n                $self->_pushback($1);\n            }\n        }\n        elsif ( $self->in_element('hsp')\n            && /Strand\\s*=\\s*(Plus|Minus)\\s*\\/\\s*(Plus|Minus)/i )\n        {\n\n            # consume this event ( we infer strand from start/end)\n            unless ($reporttype) {\n                $self->{'_reporttype'} = $reporttype = 'BLASTN';\n                $bl2seq_fix = 1;    # special case to resubmit the algorithm\n                                    # reporttype\n            }\n            next;\n        }\n        elsif ( $self->in_element('hsp')\n            && /Links\\s*=\\s*(\\S+)/ox )\n        {\n            $self->element(\n                {\n                    'Name' => 'Hsp_links',\n                    'Data' => $1\n                }\n            );\n        }\n        elsif ( $self->in_element('hsp')\n            && /Frame\\s*=\\s*([\\+\\-][1-3])\\s*(\\/\\s*([\\+\\-][1-3]))?/ )\n        {\n\n            # this is for bl2seq only\n            unless ( defined $reporttype ) {\n                $bl2seq_fix = 1;\n                if ( $1 && $2 ) { $reporttype = 'TBLASTX' }\n                else {\n                    $reporttype = 'BLASTX';\n\n    # we can't distinguish between BLASTX and TBLASTN straight from the report }\n                }\n                $self->{'_reporttype'} = $reporttype;\n            }\n\n            my ( $queryframe, $hitframe );\n            if ( $reporttype eq 'TBLASTX' ) {\n                ( $queryframe, $hitframe ) = ( $1, $2 );\n                $hitframe =~ s/\\/\\s*//g;\n            }\n            elsif ( $reporttype eq 'TBLASTN' || $reporttype eq 'PSITBLASTN') {\n                ( $hitframe, $queryframe ) = ( $1, 0 );\n            }\n            elsif ( $reporttype eq 'BLASTX' || $reporttype eq 'RPS-BLAST(BLASTP)') {\n                ( $queryframe, $hitframe ) = ( $1, 0 );\n                # though NCBI doesn't report it, this is a special BLASTX-like\n                # RPS-BLAST; should be handled differently\n                if ($reporttype eq 'RPS-BLAST(BLASTP)') {\n                    $self->element(\n                        {\n                            'Name' => 'BlastOutput_program',\n                            'Data' => 'RPS-BLAST(BLASTX)'\n                        }\n                    );\n                }\n            }\n            $self->element(\n                {\n                    'Name' => 'Hsp_query-frame',\n                    'Data' => $queryframe\n                }\n            );\n\n            $self->element(\n                {\n                    'Name' => 'Hsp_hit-frame',\n                    'Data' => $hitframe\n                }\n            );\n        }\n        elsif (/^Parameters:/\n            || /^\\s+Database:\\s+?/\n            || /^\\s+Subset/\n            || /^\\s*Lambda/\n            || /^\\s*Histogram/\n            || ( $self->in_element('hsp') && /WARNING|NOTE/ ) )\n        {\n\n            # Note: Lambda check was necessary to parse\n            # t/data/ecoli_domains.rpsblast AND to parse bl2seq\n            $self->debug(\"blast.pm: found parameters section \\n\");\n\n            $self->in_element('hsp')\n              && $self->end_element( { 'Name' => 'Hsp' } );\n            $self->in_element('hit')\n              && $self->end_element( { 'Name' => 'Hit' } );\n\n            # This is for the case when we specify -b 0 (or B=0 for WU-BLAST)\n            # and still want to construct minimal Hit objects\n            $self->_cleanup_hits(\\@hit_signifs) if scalar(@hit_signifs);\n            $self->within_element('iteration')\n              && $self->end_element( { 'Name' => 'Iteration' } );\n\n            next if /^\\s+Subset/;\n            my $blast = (/^(\\s+Database\\:)|(\\s*Lambda)/) ? 'ncbi' : 'wublast';\n            if (/^\\s*Histogram/) {\n                $blast = 'btk';\n            }\n\n            my $last = '';\n\n            # default is that gaps are allowed\n            $self->element(\n                {\n                    'Name' => 'Parameters_allowgaps',\n                    'Data' => 'yes'\n                }\n            );\n            while ( defined( $_ = $self->_readline ) ) {\n                if (\n                    /^((?:\\S+)?BLAST[NPX]?)\\s+(.+)$/i  # NCBI BLAST, PSIBLAST\n                                                      # RPSBLAST, MEGABLAST\n                    || /^(P?GENEWISE|HFRAME|SWN|TSWN)\\s+(.+)/i    #Paracel BTK\n                  )\n                {\n                    $self->_pushback($_);\n\n                    # let's handle this in the loop\n                    last;\n                }\n                elsif (/^Query=/) {\n                    $self->_pushback($reportline) if $reportline;\n                    $self->_pushback($_);\n                    last PARSER;\n                }\n\n                # here is where difference between wublast and ncbiblast\n                # is better handled by different logic\n                if (   /Number of Sequences:\\s+([\\d\\,]+)/i\n                    || /of sequences in database:\\s+(\\-?[\\d,]+)/i )\n                {\n                    my $c = $1;\n                    $c =~ s/\\,//g;\n                    $self->element(\n                        {\n                            'Name' => 'Statistics_db-len',\n                            'Data' => $c\n                        }\n                    );\n                }\n                elsif (/letters in database:\\s+(\\-?[\\d,]+)/i) {\n                    my $s = $1;\n                    $s =~ s/,//g;\n                    $self->element(\n                        {\n                            'Name' => 'Statistics_db-let',\n                            'Data' => $s\n                        }\n                    );\n                }\n                elsif ( $blast eq 'btk' ) {\n                    next;\n                }\n                elsif ( $blast eq 'wublast' ) {\n\n                    #\t\t   warn($_);\n                    if (/E=(\\S+)/) {\n                        $self->element(\n                            {\n                                'Name' => 'Parameters_expect',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (/nogaps/) {\n                        $self->element(\n                            {\n                                'Name' => 'Parameters_allowgaps',\n                                'Data' => 'no'\n                            }\n                        );\n                    }\n                    elsif (/ctxfactor=(\\S+)/) {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_ctxfactor',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (\n/(postsw|links|span[12]?|warnings|notes|gi|noseqs|qres|qype)/\n                      )\n                    {\n                        $self->element(\n                            {\n                                'Name' => \"Parameters_$1\",\n                                'Data' => 'yes'\n                            }\n                        );\n                    }\n                    elsif (/(\\S+)=(\\S+)/) {\n                        $self->element(\n                            {\n                                'Name' => \"Parameters_$1\",\n                                'Data' => $2\n                            }\n                        );\n                    }\n                    elsif ( $last =~ /(Frame|Strand)\\s+MatID\\s+Matrix name/i ) {\n                        my $firstgapinfo = 1;\n                        my $frame        = undef;\n                        while ( defined($_) && !/^\\s+$/ ) {\n                            s/^\\s+//;\n                            s/\\s+$//;\n                            if ( $firstgapinfo\n                                && s/Q=(\\d+),R=(\\d+)\\s+//x )\n                            {\n                                $firstgapinfo = 0;\n\n                                $self->element(\n                                    {\n                                        'Name' => 'Parameters_gap-open',\n                                        'Data' => $1\n                                    }\n                                );\n                                $self->element(\n                                    {\n                                        'Name' => 'Parameters_gap-extend',\n                                        'Data' => $2\n                                    }\n                                );\n                                my @fields = split;\n\n                                for my $type (\n                                    qw(lambda_gapped\n                                    kappa_gapped\n                                    entropy_gapped)\n                                  )\n                                {\n                                    next if $type eq 'n/a';\n                                    if ( !@fields ) {\n                                        warn \"fields is empty for $type\\n\";\n                                        next;\n                                    }\n                                    $self->element(\n                                        {\n                                            'Name' =>\n                                              \"Statistics_frame$frame\\_$type\",\n                                            'Data' => shift @fields\n                                        }\n                                    );\n                                }\n                            }\n                            else {\n                                my ( $frameo, $matid, $matrix, @fields ) =\n                                  split;\n                                if ( !defined $frame ) {\n\n                                    # keep some sort of default feature I guess\n                                    # even though this is sort of wrong\n                                    $self->element(\n                                        {\n                                            'Name' => 'Parameters_matrix',\n                                            'Data' => $matrix\n                                        }\n                                    );\n                                    $self->element(\n                                        {\n                                            'Name' => 'Statistics_lambda',\n                                            'Data' => $fields[0]\n                                        }\n                                    );\n                                    $self->element(\n                                        {\n                                            'Name' => 'Statistics_kappa',\n                                            'Data' => $fields[1]\n                                        }\n                                    );\n                                    $self->element(\n                                        {\n                                            'Name' => 'Statistics_entropy',\n                                            'Data' => $fields[2]\n                                        }\n                                    );\n                                }\n                                $frame = $frameo;\n                                my $ii = 0;\n                                for my $type (\n                                    qw(lambda_used\n                                    kappa_used\n                                    entropy_used\n                                    lambda_computed\n                                    kappa_computed\n                                    entropy_computed)\n                                  )\n                                {\n                                    my $f = $fields[$ii];\n                                    next unless defined $f;    # deal with n/a\n                                    if ( $f eq 'same' ) {\n                                        $f = $fields[ $ii - 3 ];\n                                    }\n                                    $ii++;\n                                    $self->element(\n                                        {\n                                            'Name' =>\n                                              \"Statistics_frame$frame\\_$type\",\n                                            'Data' => $f\n                                        }\n                                    );\n\n                                }\n                            }\n\n                            # get the next line\n                            $_ = $self->_readline;\n                        }\n                        $last = $_;\n                    }\n                    elsif ( $last =~ /(Frame|Strand)\\s+MatID\\s+Length/i ) {\n                        my $frame = undef;\n                        while ( defined($_) && !/^\\s+/ ) {\n                            s/^\\s+//;\n                            s/\\s+$//;\n                            my @fields = split;\n                            if ( @fields <= 3 ) {\n                                for my $type (qw(X_gapped E2_gapped S2)) {\n                                    last unless @fields;\n                                    $self->element(\n                                        {\n                                            'Name' =>\n                                              \"Statistics_frame$frame\\_$type\",\n                                            'Data' => shift @fields\n                                        }\n                                    );\n                                }\n                            }\n                            else {\n\n                                for my $type (\n                                    qw(length\n                                    efflength\n                                    E S W T X E2 S2)\n                                  )\n                                {\n                                    $self->element(\n                                        {\n                                            'Name' =>\n                                              \"Statistics_frame$frame\\_$type\",\n                                            'Data' => shift @fields\n                                        }\n                                    );\n                                }\n                            }\n                            $_ = $self->_readline;\n                        }\n                        $last = $_;\n                    }\n                    elsif (/(\\S+\\s+\\S+)\\s+DFA:\\s+(\\S+)\\s+\\((.+)\\)/) {\n                        if ( $1 eq 'states in' ) {\n                            $self->element(\n                                {\n                                    'Name' => 'Statistics_DFA_states',\n                                    'Data' => \"$2 $3\"\n                                }\n                            );\n                        }\n                        elsif ( $1 eq 'size of' ) {\n                            $self->element(\n                                {\n                                    'Name' => 'Statistics_DFA_size',\n                                    'Data' => \"$2 $3\"\n                                }\n                            );\n                        }\n                    }\n                    elsif (\n                        m/^\\s+Time to generate neighborhood:\\s+\n\t\t\t    (\\S+\\s+\\S+\\s+\\S+)/x\n                      )\n                    {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_neighbortime',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (/processors\\s+used:\\s+(\\d+)/) {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_noprocessors',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (\n                        m/^\\s+(\\S+)\\s+cpu\\s+time:\\s+# cputype\n\t\t\t    (\\S+\\s+\\S+\\s+\\S+)           # cputime\n\t\t\t    \\s+Elapsed:\\s+(\\S+)/x\n                      )\n                    {\n                        my $cputype = lc($1);\n                        $self->element(\n                            {\n                                'Name' => \"Statistics_$cputype\\_cputime\",\n                                'Data' => $2\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => \"Statistics_$cputype\\_actualtime\",\n                                'Data' => $3\n                            }\n                        );\n                    }\n                    elsif (/^\\s+Start:/) {\n                        my ( $junk, $start, $stime, $end, $etime ) =\n                          split( /\\s+(Start|End)\\:\\s+/, $_ );\n                        chomp($stime);\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_starttime',\n                                'Data' => $stime\n                            }\n                        );\n                        chomp($etime);\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_endtime',\n                                'Data' => $etime\n                            }\n                        );\n                    }\n                    elsif (/^\\s+Database:\\s+(.+)$/) {\n                        $self->element(\n                            {\n                                'Name' => 'Parameters_full_dbpath',\n                                'Data' => $1\n                            }\n                        );\n\n                    }\n                    elsif (/^\\s+Posted:\\s+(.+)/) {\n                        my $d = $1;\n                        chomp($d);\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_posted_date',\n                                'Data' => $d\n                            }\n                        );\n                    }\n                }\n                elsif ( $blast eq 'ncbi' ) {\n\n                    if (m/^Matrix:\\s+(.+)\\s*$/oxi) {\n                        $self->element(\n                            {\n                                'Name' => 'Parameters_matrix',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (/^Gapped/) {\n                        $gapped_stats = 1;\n                    }\n                    elsif (/^Lambda/) {\n                        $_ = $self->_readline;\n                        s/^\\s+//;\n                        my ( $lambda, $kappa, $entropy ) = split;\n                        if ($gapped_stats) {\n                            $self->element(\n                                {\n                                    'Name' => \"Statistics_gapped_lambda\",\n                                    'Data' => $lambda\n                                }\n                            );\n                            $self->element(\n                                {\n                                    'Name' => \"Statistics_gapped_kappa\",\n                                    'Data' => $kappa\n                                }\n                            );\n                            $self->element(\n                                {\n                                    'Name' => \"Statistics_gapped_entropy\",\n                                    'Data' => $entropy\n                                }\n                            );\n                        }\n                        else {\n                            $self->element(\n                                {\n                                    'Name' => \"Statistics_lambda\",\n                                    'Data' => $lambda\n                                }\n                            );\n                            $self->element(\n                                {\n                                    'Name' => \"Statistics_kappa\",\n                                    'Data' => $kappa\n                                }\n                            );\n                            $self->element(\n                                {\n                                    'Name' => \"Statistics_entropy\",\n                                    'Data' => $entropy\n                                }\n                            );\n                        }\n                    }\n                    elsif (m/effective\\s+search\\s+space\\s+used:\\s+(\\d+)/ox) {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_eff-spaceused',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (m/effective\\s+search\\s+space:\\s+(\\d+)/ox) {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_eff-space',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (\n                        m/Gap\\s+Penalties:\\s+Existence:\\s+(\\d+)\\,\n\t\t\t    \\s+Extension:\\s+(\\d+)/ox\n                      )\n                    {\n                        $self->element(\n                            {\n                                'Name' => 'Parameters_gap-open',\n                                'Data' => $1\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Parameters_gap-extend',\n                                'Data' => $2\n                            }\n                        );\n                    }\n                    elsif (/effective\\s+HSP\\s+length:\\s+(\\d+)/) {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_hsp-len',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (/effective\\s+length\\s+of\\s+query:\\s+([\\d\\,]+)/) {\n                        my $c = $1;\n                        $c =~ s/\\,//g;\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_query-len',\n                                'Data' => $c\n                            }\n                        );\n                    }\n                    elsif (/effective\\s+length\\s+of\\s+database:\\s+([\\d\\,]+)/) {\n                        my $c = $1;\n                        $c =~ s/\\,//g;\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_eff-dblen',\n                                'Data' => $c\n                            }\n                        );\n                    }\n                    elsif (\n/^(T|A|X1|X2|X3|S1|S2):\\s+(\\d+(\\.\\d+)?)\\s+(?:\\(\\s*(\\d+\\.\\d+) bits\\))?/\n                      )\n                    {\n                        my $v = $2;\n                        chomp($v);\n                        $self->element(\n                            {\n                                'Name' => \"Statistics_$1\",\n                                'Data' => $v\n                            }\n                        );\n                        if ( defined $4 ) {\n                            $self->element(\n                                {\n                                    'Name' => \"Statistics_$1_bits\",\n                                    'Data' => $4\n                                }\n                            );\n                        }\n                    }\n                    elsif (\n                        m/frameshift\\s+window\\,\n\t\t\t    \\s+decay\\s+const:\\s+(\\d+)\\,\\s+([\\.\\d]+)/x\n                      )\n                    {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_framewindow',\n                                'Data' => $1\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_decay',\n                                'Data' => $2\n                            }\n                        );\n                    }\n                    elsif (m/^Number\\s+of\\s+Hits\\s+to\\s+DB:\\s+(\\S+)/ox) {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_hit_to_db',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (m/^Number\\s+of\\s+extensions:\\s+(\\S+)/ox) {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_num_extensions',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (\n                        m/^Number\\s+of\\s+successful\\s+extensions:\\s+\n\t\t\t    (\\S+)/ox\n                      )\n                    {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_num_suc_extensions',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (\n                        m/^Number\\s+of\\s+sequences\\s+better\\s+than\\s+\n\t\t\t    (\\S+):\\s+(\\d+)/ox\n                      )\n                    {\n                        $self->element(\n                            {\n                                'Name' => 'Parameters_expect',\n                                'Data' => $1\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_seqs_better_than_cutoff',\n                                'Data' => $2\n                            }\n                        );\n                    }\n                    elsif (/^\\s+Posted\\s+date:\\s+(.+)/) {\n                        my $d = $1;\n                        chomp($d);\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_posted_date',\n                                'Data' => $d\n                            }\n                        );\n                    }\n                    elsif ( !/^\\s+$/ ) {\n                        #$self->debug( \"unmatched stat $_\");\n                    }\n                }\n                $last = $_;\n            }\n        } elsif ( $self->in_element('hsp') ) {\n            $self->debug(\"blast.pm: Processing HSP\\n\");\n            # let's read 3 lines at a time;\n            # bl2seq hackiness... Not sure I like\n            $self->{'_reporttype'} ||= $DEFAULTREPORTTYPE;\n            my %data = (\n                'Query' => '',\n                'Mid'   => '',\n                'Hit'   => ''\n            );\n            my $len;\n            for ( my $i = 0 ; defined($_) && $i < 3 ; $i++ ) {\n                # $self->debug(\"$i: $_\") if $v;\n                if ( ( $i == 0 && /^\\s+$/) || \n\t\t     /^\\s*(?:Lambda|Minus|Plus|Score)/i )\n                {\n                    $self->_pushback($_) if defined $_;\n                    $self->end_element( { 'Name' => 'Hsp' } );\n                    last;\n                }\n                chomp;\n                if (/^((Query|Sbjct):?\\s+(\\-?\\d+)\\s*)(\\S+)\\s+(\\-?\\d+)/) {\n                    my ( $full, $type, $start, $str, $end ) =\n                      ( $1, $2, $3, $4, $5 );\n\n                    if ( $str eq '-' ) {\n                        $i = 3 if $type eq 'Sbjct';\n                    }\n                    else {\n                        $data{$type} = $str;\n                    }\n                    $len = length($full);\n                    $self->{\"\\_$type\"}->{'begin'} = $start\n                      unless $self->{\"_$type\"}->{'begin'};\n                    $self->{\"\\_$type\"}->{'end'} = $end;\n                } else {\n                    $self->throw(\"no data for midline $_\")\n                      unless ( defined $_ && defined $len );\n                    $data{'Mid'} = substr( $_, $len );\n                }\n                $_ = $self->_readline();\n            }\n            $self->characters(\n                {\n                    'Name' => 'Hsp_qseq',\n                    'Data' => $data{'Query'}\n                }\n            );\n            $self->characters(\n                {\n                    'Name' => 'Hsp_hseq',\n                    'Data' => $data{'Sbjct'}\n                }\n            );\n            $self->characters(\n                {\n                    'Name' => 'Hsp_midline',\n                    'Data' => $data{'Mid'}\n                }\n            );\n        }\n        else {\n            #$self->debug(\"blast.pm: unrecognized line $_\");\n        }\n    }\n\n    $self->debug(\"blast.pm: End of BlastOutput\\n\");\n    if ( $self->{'_seentop'} ) {\n        $self->within_element('hsp')\n          && $self->end_element( { 'Name' => 'Hsp' } );\n        $self->within_element('hit')\n          && $self->end_element( { 'Name' => 'Hit' } );\n        # cleanup extra hits\n        $self->_cleanup_hits(\\@hit_signifs) if scalar(@hit_signifs);\n        $self->within_element('iteration')\n          && $self->end_element( { 'Name' => 'Iteration' } );\n        if ($bl2seq_fix) {\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_program',\n                    'Data' => $reporttype\n                }\n            );\n        }\n        $self->end_element( { 'Name' => 'BlastOutput' } );\n    }\n    return $self->end_document();\n}\n\n# Private method for internal use only.\nsub _start_blastoutput {\n    my $self = shift;\n    $self->start_element( { 'Name' => 'BlastOutput' } );\n    $self->{'_seentop'} = 1;\n    $self->{'_result_count'}++;\n    $self->{'_handler_rc'} = undef;\n}\n\n=head2 _will_handle\n\n Title   : _will_handle\n Usage   : Private method. For internal use only.\n              if( $self->_will_handle($type) ) { ... }\n Function: Provides an optimized way to check whether or not an element of a \n           given type is to be handled.\n Returns : Reference to EventHandler object if the element type is to be handled.\n           undef if the element type is not to be handled.\n Args    : string containing type of element.\n\nOptimizations:\n\n=over 2\n\n* 1\n\nUsing the cached pointer to the EventHandler to minimize repeated\nlookups.\n\n* 2\n\nCaching the will_handle status for each type that is encountered so\nthat it only need be checked by calling\nhandler-E<gt>will_handle($type) once.\n\n\nThis does not lead to a major savings by itself (only 5-10%).  In\ncombination with other optimizations, or for large parse jobs, the\nsavings good be significant.\n\nTo test against the unoptimized version, remove the parentheses from\naround the third term in the ternary \" ? : \" operator and add two\ncalls to $self-E<gt>_eventHandler().\n\n\nsub _will_handle {\n    my ( $self, $type ) = @_;\n    my $handler     = $self->{'_handler_cache'};\n    my $will_handle =\n      defined( $self->{'_will_handle_cache'}->{$type} )\n      ? $self->{'_will_handle_cache'}->{$type}\n      : ( $self->{'_will_handle_cache'}->{$type} =\n          $handler->will_handle($type) );\n\n    return $will_handle ? $handler : undef;\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\nsub start_element {\n    my ( $self, $data ) = @_;\n\n    # we currently don't care about attributes\n    my $nm   = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    if ($type) {\n        my $handler = $self->_will_handle($type);\n        if ($handler) {\n            my $func = sprintf( \"start_%s\", lc $type );\n            $self->{'_handler_rc'} = $handler->$func( $data->{'Attributes'} );\n        }\n        #else {\n            #$self->debug( # changed 4/29/2006 to play nice with other event handlers\n            #    \"Bio::SearchIO::InternalParserError \".\n            #    \"\\nCan't handle elements of type \\'$type.\\'\"\n            #);\n        #}\n        unshift @{ $self->{'_elements'} }, $type;\n        if ( $type eq 'result' ) {\n            $self->{'_values'} = {};\n            $self->{'_result'} = undef;\n        } else {\n            # cleanup some things\n            if ( defined $self->{'_values'} ) {\n                foreach my $k (\n                    grep { /^\\U$type\\-/ }\n                    keys %{ $self->{'_values'} }\n                  )\n                {\n                    delete $self->{'_values'}->{$k};\n                }\n            }\n        }\n    }\n}\n\n=head2 end_element\n\n Title   : end_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : hashref with an element's worth of data\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ( $self, $data ) = @_;\n    \n    my $nm   = $data->{'Name'};\n    my $type;\n    my $rc;\n    if ( $nm eq 'BlastOutput_program' ) {\n        if ( $self->{'_last_data'} =~ /(t?blast[npx])/i ) {\n            $self->{'_reporttype'} = uc $1;\n        }\n        $self->{'_reporttype'} ||= $DEFAULTREPORTTYPE;\n    }\n\n    # Hsps are sort of weird, in that they end when another\n    # object begins so have to detect this in end_element for now\n    if ( $nm eq 'Hsp' ) {\n        foreach (qw(Hsp_qseq Hsp_midline Hsp_hseq Hsp_features)) {\n            $self->element(\n                {\n                    'Name' => $_,\n                    'Data' => $self->{'_last_hspdata'}->{$_}\n                }\n            ) if defined $self->{'_last_hspdata'}->{$_};\n        }\n        $self->{'_last_hspdata'} = {};\n        $self->element(\n            {\n                'Name' => 'Hsp_query-from',\n                'Data' => $self->{'_Query'}->{'begin'}\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_query-to',\n                'Data' => $self->{'_Query'}->{'end'}\n            }\n        );\n\n        $self->element(\n            {\n                'Name' => 'Hsp_hit-from',\n                'Data' => $self->{'_Sbjct'}->{'begin'}\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_hit-to',\n                'Data' => $self->{'_Sbjct'}->{'end'}\n            }\n        );\n\n        #    } elsif( $nm eq 'Iteration' ) {\n        # Nothing special needs to be done here.\n    }\n    if ( $type = $MODEMAP{$nm} ) {\n        my $handler = $self->_will_handle($type);\n        if ($handler) {\n            my $func = sprintf( \"end_%s\", lc $type );\n            $rc = $handler->$func( $self->{'_reporttype'}, $self->{'_values'} );\n        }\n        shift @{ $self->{'_elements'} };\n\n    }\n    elsif ( $MAPPING{$nm} ) {\n        if ( ref( $MAPPING{$nm} ) =~ /hash/i ) {\n\n            # this is where we shove in the data from the\n            # hashref info about params or statistics\n            my $key = ( keys %{ $MAPPING{$nm} } )[0];\n            $self->{'_values'}->{$key}->{ $MAPPING{$nm}->{$key} } =\n              $self->{'_last_data'};\n        }\n        else {\n            $self->{'_values'}->{ $MAPPING{$nm} } = $self->{'_last_data'};\n        }\n    }\n    else {\n        #$self->debug(\"blast.pm: unknown nm $nm, ignoring\\n\");\n    }\n    $self->{'_last_data'} = '';    # remove read data if we are at\n                                   # end of an element\n    $self->{'_result'} = $rc if ( defined $type && $type eq 'result' );\n    return $rc;\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convenience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element {\n    my ( $self, $data ) = @_;\n    # Note that start element isn't needed for character data\n    # Not too SAX-y, though\n    #$self->start_element($data);\n    $self->characters($data);\n    $self->end_element($data);\n}\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string","parameters":[{"label":"$self"},{"label":"$data"}],"label":"characters($self,$data)"},"detail":"($self,$data)","definition":"sub","containerName":"main::","children":[{"containerName":"characters","name":"$self","definition":"my","localvar":"my","kind":13,"line":2091},{"name":"$data","containerName":"characters","kind":13,"line":2091},{"kind":13,"line":2092,"containerName":"characters","name":"$self"},{"line":2092,"kind":12,"name":"in_element","containerName":"characters"},{"name":"$data","containerName":"characters","line":2093,"kind":13},{"containerName":"characters","name":"$self","kind":13,"line":2095},{"name":"$data","containerName":"characters","line":2095,"kind":13},{"line":2095,"kind":13,"containerName":"characters","name":"$data"},{"name":"$data","containerName":"characters","kind":13,"line":2096},{"kind":13,"line":2098,"name":"$data","containerName":"characters"},{"line":2098,"kind":13,"name":"$data","containerName":"characters"},{"line":2099,"kind":13,"containerName":"characters","name":"$self"},{"line":2099,"kind":13,"name":"$data","containerName":"characters"}],"line":2090,"kind":12,"range":{"start":{"character":0,"line":2090},"end":{"line":2100,"character":9999}},"name":"characters"},{"children":[{"localvar":"my","containerName":"within_element","name":"$self","definition":"my","line":2117,"kind":13},{"containerName":"within_element","name":"$name","kind":13,"line":2117},{"line":2119,"kind":13,"name":"$name","containerName":"within_element"},{"line":2119,"kind":13,"containerName":"within_element","name":"$self"},{"kind":13,"line":2120,"name":"$self","containerName":"within_element"}],"line":2116,"kind":12,"signature":{"parameters":[{"label":"$self"},{"label":"$name"}],"documentation":"(Sesame Street aficionados note: This answer was NOT given by Mr. Noodle ;-P)\n# $Id: blast.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::blast\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n# 20030409 - sac\n#          PSI-BLAST full parsing support. Rollout of new\n#          model which will remove Steve's old psiblast driver\n# 20030424 - jason\n#          Megablast parsing fix as reported by Neil Saunders\n# 20030427 - jason\n#          Support bl2seq parsing\n# 20031124 - jason\n#          Parse more blast statistics, lambda, entropy, etc\n#          from WU-BLAST in frame-specific manner\n# 20060216 - cjf - fixed blast parsing for BLAST v2.2.13 output\n# 20071104 - dmessina - added support for WUBLAST -echofilter\n# 20071121 - cjf - fixed several bugs (bugs 2391, 2399, 2409)\n\n=head1 NAME\n\nBio::SearchIO::blast - Event generator for event based parsing of\nblast reports\n\n=head1 SYNOPSIS\n\n   # Do not use this object directly - it is used as part of the\n   # Bio::SearchIO system.\n\n    use Bio::SearchIO;\n    my $searchio = Bio::SearchIO->new(-format => 'blast',\n                                     -file   => 't/data/ecolitst.bls');\n    while( my $result = $searchio->next_result ) {\n        while( my $hit = $result->next_hit ) {\n            while( my $hsp = $hit->next_hsp ) {\n                # ...\n            }\n        }\n    }\n\n=head1 DESCRIPTION\n\nThis object encapsulated the necessary methods for generating events\nsuitable for building Bio::Search objects from a BLAST report file.\nRead the L<Bio::SearchIO> for more information about how to use this.\n\nThis driver can parse:\n\n=over 4\n\n* * \n\nNCBI produced plain text BLAST reports from blastall, this also\nincludes PSIBLAST, PSITBLASTN, RPSBLAST, and bl2seq reports.  NCBI XML\nBLAST output is parsed with the blastxml SearchIO driver\n\n* *\n\nWU-BLAST all reports\n\n* *\n\nJim Kent's BLAST-like output from his programs (BLASTZ, BLAT)\n\n* *\n\nBLAST-like output from Paracel BTK output\n\n\n=head2 bl2seq parsing\n\nSince I cannot differentiate between BLASTX and TBLASTN since bl2seq\ndoesn't report the algorithm used - I assume it is BLASTX by default -\nyou can supply the program type with -report_type in the SearchIO\nconstructor i.e.\n\n  my $parser = Bio::SearchIO->new(-format => 'blast',\n                                 -file => 'bl2seq.tblastn.report',\n                                 -report_type => 'tblastn');\n\nThis only really affects where the frame and strand information are\nput - they will always be on the $hsp-E<gt>query instead of on the\n$hsp-E<gt>hit part of the feature pair for blastx and tblastn bl2seq\nproduced reports.  Hope that's clear...\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail Jason Stajich jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nSteve Chervitz sac-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...'\n\npackage Bio::SearchIO::blast;\n\nuse Bio::SearchIO::IteratedSearchResultEventBuilder;\nuse strict;\nuse vars qw(%MAPPING %MODEMAP\n  $DEFAULT_BLAST_WRITER_CLASS\n  $MAX_HSP_OVERLAP\n  $DEFAULT_SIGNIF\n  $DEFAULT_SCORE\n  $DEFAULTREPORTTYPE\n);\n\n\nuse base qw(Bio::SearchIO);\nuse Data::Dumper;\n\nBEGIN {\n\n    # mapping of NCBI Blast terms to Bioperl hash keys\n    %MODEMAP = (\n        'BlastOutput' => 'result',\n        'Iteration'   => 'iteration',\n        'Hit'         => 'hit',\n        'Hsp'         => 'hsp'\n    );\n\n    # This should really be done more intelligently, like with\n    # XSLT\n\n    %MAPPING = (\n        'Hsp_bit-score'   => 'HSP-bits',\n        'Hsp_score'       => 'HSP-score',\n        'Hsp_evalue'      => 'HSP-evalue',\n        'Hsp_n',          => 'HSP-n',\n        'Hsp_pvalue'      => 'HSP-pvalue',\n        'Hsp_query-from'  => 'HSP-query_start',\n        'Hsp_query-to'    => 'HSP-query_end',\n        'Hsp_hit-from'    => 'HSP-hit_start',\n        'Hsp_hit-to'      => 'HSP-hit_end',\n        'Hsp_positive'    => 'HSP-conserved',\n        'Hsp_identity'    => 'HSP-identical',\n        'Hsp_gaps'        => 'HSP-hsp_gaps',\n        'Hsp_hitgaps'     => 'HSP-hit_gaps',\n        'Hsp_querygaps'   => 'HSP-query_gaps',\n        'Hsp_qseq'        => 'HSP-query_seq',\n        'Hsp_hseq'        => 'HSP-hit_seq',\n        'Hsp_midline'     => 'HSP-homology_seq',\n        'Hsp_align-len'   => 'HSP-hsp_length',\n        'Hsp_query-frame' => 'HSP-query_frame',\n        'Hsp_hit-frame'   => 'HSP-hit_frame',\n        'Hsp_links'       => 'HSP-links',\n        'Hsp_group'       => 'HSP-hsp_group',\n        'Hsp_features'    => 'HSP-hit_features',\n\n        'Hit_id'        => 'HIT-name',\n        'Hit_len'       => 'HIT-length',\n        'Hit_accession' => 'HIT-accession',\n        'Hit_def'       => 'HIT-description',\n        'Hit_signif'    => 'HIT-significance',\n        # For NCBI blast, the description line contains bits.\n        # For WU-blast, the  description line contains score.\n        'Hit_score' => 'HIT-score',\n        'Hit_bits'  => 'HIT-bits',\n\n        'Iteration_iter-num'  => 'ITERATION-number',\n        'Iteration_converged' => 'ITERATION-converged',\n\n        'BlastOutput_program'             => 'RESULT-algorithm_name',\n        'BlastOutput_version'             => 'RESULT-algorithm_version',\n        'BlastOutput_query-def'           => 'RESULT-query_name',\n        'BlastOutput_query-len'           => 'RESULT-query_length',\n        'BlastOutput_query-acc'           => 'RESULT-query_accession',\n        'BlastOutput_query-gi'            => 'RESULT-query_gi',\n        'BlastOutput_querydesc'           => 'RESULT-query_description',\n        'BlastOutput_db'                  => 'RESULT-database_name',\n        'BlastOutput_db-len'              => 'RESULT-database_entries',\n        'BlastOutput_db-let'              => 'RESULT-database_letters',\n        'BlastOutput_inclusion-threshold' => 'RESULT-inclusion_threshold',\n\n        'Parameters_matrix'      => { 'RESULT-parameters' => 'matrix' },\n        'Parameters_expect'      => { 'RESULT-parameters' => 'expect' },\n        'Parameters_include'     => { 'RESULT-parameters' => 'include' },\n        'Parameters_sc-match'    => { 'RESULT-parameters' => 'match' },\n        'Parameters_sc-mismatch' => { 'RESULT-parameters' => 'mismatch' },\n        'Parameters_gap-open'    => { 'RESULT-parameters' => 'gapopen' },\n        'Parameters_gap-extend'  => { 'RESULT-parameters' => 'gapext' },\n        'Parameters_filter'      => { 'RESULT-parameters' => 'filter' },\n        'Parameters_allowgaps'   => { 'RESULT-parameters' => 'allowgaps' },\n        'Parameters_full_dbpath' => { 'RESULT-parameters' => 'full_dbpath' },\n        'Statistics_db-len'      => { 'RESULT-statistics' => 'dbentries' },\n        'Statistics_db-let'      => { 'RESULT-statistics' => 'dbletters' },\n        'Statistics_hsp-len'     =>\n          { 'RESULT-statistics' => 'effective_hsplength' },\n        'Statistics_query-len' => { 'RESULT-statistics' => 'querylength' },\n        'Statistics_eff-space' => { 'RESULT-statistics' => 'effectivespace' },\n        'Statistics_eff-spaceused' =>\n          { 'RESULT-statistics' => 'effectivespaceused' },\n        'Statistics_eff-dblen' =>\n          { 'RESULT-statistics' => 'effectivedblength' },\n        'Statistics_kappa'         => { 'RESULT-statistics' => 'kappa' },\n        'Statistics_lambda'        => { 'RESULT-statistics' => 'lambda' },\n        'Statistics_entropy'       => { 'RESULT-statistics' => 'entropy' },\n        'Statistics_gapped_kappa'  => { 'RESULT-statistics' => 'kappa_gapped' },\n        'Statistics_gapped_lambda' =>\n          { 'RESULT-statistics' => 'lambda_gapped' },\n        'Statistics_gapped_entropy' =>\n          { 'RESULT-statistics' => 'entropy_gapped' },\n\n        'Statistics_framewindow' =>\n          { 'RESULT-statistics' => 'frameshiftwindow' },\n        'Statistics_decay' => { 'RESULT-statistics' => 'decayconst' },\n\n        'Statistics_hit_to_db' => { 'RESULT-statistics' => 'Hits_to_DB' },\n        'Statistics_num_suc_extensions' =>\n          { 'RESULT-statistics' => 'num_successful_extensions' },\n\n        # WU-BLAST stats\n        'Statistics_DFA_states' => { 'RESULT-statistics' => 'num_dfa_states' },\n        'Statistics_DFA_size'   => { 'RESULT-statistics' => 'dfa_size' },\n        'Statistics_noprocessors' =>\n          { 'RESULT-statistics' => 'no_of_processors' },\n        'Statistics_neighbortime' =>\n          { 'RESULT-statistics' => 'neighborhood_generate_time' },\n        'Statistics_starttime' => { 'RESULT-statistics' => 'start_time' },\n        'Statistics_endtime'   => { 'RESULT-statistics' => 'end_time' },\n    );\n\n    # add WU-BLAST Frame-Based Statistics\n    for my $frame ( 0 .. 3 ) {\n        for my $strand ( '+', '-' ) {\n            for my $ind (\n                qw(length efflength E S W T X X_gapped E2\n                E2_gapped S2)\n              )\n            {\n                $MAPPING{\"Statistics_frame$strand$frame\\_$ind\"} =\n                  { 'RESULT-statistics' => \"Frame$strand$frame\\_$ind\" };\n            }\n            for my $val (qw(lambda kappa entropy )) {\n                for my $type (qw(used computed gapped)) {\n                    my $key = \"Statistics_frame$strand$frame\\_$val\\_$type\";\n                    my $val =\n                      { 'RESULT-statistics' =>\n                          \"Frame$strand$frame\\_$val\\_$type\" };\n                    $MAPPING{$key} = $val;\n                }\n            }\n        }\n    }\n\n    # add Statistics\n    for my $stats (\n        qw(T A X1 X2 X3 S1 S2 X1_bits X2_bits X3_bits\n        S1_bits S2_bits  num_extensions\n        num_successful_extensions\n        seqs_better_than_cutoff\n        posted_date\n        search_cputime total_cputime\n        search_actualtime total_actualtime\n        no_of_processors ctxfactor)\n      )\n    {\n        my $key = \"Statistics_$stats\";\n        my $val = { 'RESULT-statistics' => $stats };\n        $MAPPING{$key} = $val;\n    }\n\n    # add WU-BLAST Parameters\n    for my $param (\n        qw(span span1 span2 links warnings notes hspsepsmax\n        hspsepqmax topcomboN topcomboE postsw cpus wordmask\n        filter sort_by_pvalue sort_by_count sort_by_highscore\n        sort_by_totalscore sort_by_subjectlength noseqs gi qtype\n        qres V B Z Y M N)\n      )\n    {\n        my $key = \"Parameters_$param\";\n        my $val = { 'RESULT-parameters' => $param };\n        $MAPPING{$key} = $val;\n    }\n\n    $DEFAULT_BLAST_WRITER_CLASS = 'Bio::Search::Writer::HitTableWriter';\n    $MAX_HSP_OVERLAP   = 2;           # Used when tiling multiple HSPs.\n    $DEFAULTREPORTTYPE = 'BLASTP';    # for bl2seq\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::blast->new(%args);\n Function: Builds a new Bio::SearchIO::blast object \n Returns : Bio::SearchIO::blast\n Args    : Key-value pairs:\n           -fh/-file => filehandle/filename to BLAST file\n           -format   => 'blast'\n           -report_type => 'blastx', 'tblastn', etc -- only for bl2seq\n                           reports when you want to distinguish between\n                           tblastn and blastx reports (this only controls\n                           where the frame information is put - on the query\n                           or subject object.\n           -inclusion_threshold => e-value threshold for inclusion in the\n                                   PSI-BLAST score matrix model (blastpgp)\n           -signif      => float or scientific notation number to be used\n                           as a P- or Expect value cutoff\n           -score       => integer or scientific notation number to be used\n                           as a blast score value cutoff\n           -bits        => integer or scientific notation number to be used\n                           as a bit score value cutoff\n           -hit_filter  => reference to a function to be used for\n                           filtering hits based on arbitrary criteria.\n                           All hits of each BLAST report must satisfy \n                           this criteria to be retained. \n                           If a hit fails this test, it is ignored.\n                           This function should take a\n                           Bio::Search::Hit::BlastHit.pm object as its first\n                           argument and return true\n                           if the hit should be retained.\n                           Sample filter function:\n                              -hit_filter => sub { $hit = shift;\n                                                   $hit->gaps == 0; },\n                           (Note: -filt_func is synonymous with -hit_filter)\n           -overlap     => integer. The amount of overlap to permit between\n                           adjacent HSPs when tiling HSPs. A reasonable value is 2.\n                           Default = $Bio::SearchIO::blast::MAX_HSP_OVERLAP.\n\n            The following criteria are not yet supported:\n            (these are probably best applied within this module rather than in the \n             event handler since they would permit the parser to take some shortcuts.)\n\n           -check_all_hits => boolean. Check all hits for significance against\n                              significance criteria.  Default = false.\n                              If false, stops processing hits after the first\n                              non-significant hit or the first hit that fails\n                              the hit_filter call. This speeds parsing,\n                              taking advantage of the fact that the hits\n                              are processed in the order they appear in the report.\n           -min_query_len => integer to be used as a minimum for query sequence length.\n                             Reports with query sequences below this length will\n                             not be processed. Default = no minimum length.\n           -best        => boolean. Only process the best hit of each report;\n                           default = false.\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n\n    # Blast reports require a specialized version of the SREB due to the\n    # possibility of iterations (PSI-BLAST). Forwarding all arguments to it. An\n    # issue here is that we want to set new default object factories if none are\n    # supplied.\n\n    my $handler = Bio::SearchIO::IteratedSearchResultEventBuilder->new(@args);\n    $self->attach_EventHandler($handler);\n    \n    # 2006-04-26 move this to the attach_handler function in this module so we\n    # can really reset the handler \n    # Optimization: caching\n    # the EventHandler since it is used a lot during the parse.\n    \n    # $self->{'_handler_cache'} = $handler;\n\n    my ( $min_qlen, $check_all, $overlap, $best, $rpttype ) = $self->_rearrange(\n        [\n            qw(MIN_LENGTH CHECK_ALL_HITS\n              OVERLAP BEST\n              REPORT_TYPE)\n        ],\n        @args\n    );\n\n    defined $min_qlen  && $self->min_query_length($min_qlen);\n    defined $best      && $self->best_hit_only($best);\n    defined $check_all && $self->check_all_hits($check_all);\n    defined $rpttype   && ( $self->{'_reporttype'} = $rpttype );\n}\n\nsub attach_EventHandler {\n    my ($self,$handler) = @_;\n\n    $self->SUPER::attach_EventHandler($handler);    \n\n    # Optimization: caching the EventHandler since it is used a lot\n    # during the parse.\n\n    $self->{'_handler_cache'} = $handler;\n    return;\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    my $v      = $self->verbose;\n    my $data   = '';\n    my $flavor = '';\n    $self->{'_seentop'} = 0;     # start next report at top\n    $self->{'_seentop'} = 0;\n    my ( $reporttype, $seenquery, $reportline );  \n    my ( $seeniteration, $found_again );\n    my $incl_threshold = $self->inclusion_threshold;\n    my $bl2seq_fix;\n    $self->start_document();  # let the fun begin...\n    my (@hit_signifs);\n    my $gapped_stats = 0;    # for switching between gapped/ungapped\n                             # lambda, K, H\n    local $_ = \"\\n\";   #consistency\n    PARSER:\n    while ( defined( $_ = $self->_readline ) ) {\n        next if (/^\\s+$/);       # skip empty lines\n        next if (/CPU time:/);\n        next if (/^>\\s*$/);\n        if (\n               /^((?:\\S+?)?BLAST[NPX]?)\\s+(.+)$/i  # NCBI BLAST, PSIBLAST\n                                                   # RPSBLAST, MEGABLAST\n            || /^(P?GENEWISE|HFRAME|SWN|TSWN)\\s+(.+)/i    #Paracel BTK\n          )\n        {\n            ($reporttype, my $reportversion) = ($1, $2);\n            # need to keep track of whether this is WU-BLAST\n            if ($reportversion && $reportversion =~ m{WashU$}) {\n                $self->{'_wublast'}++;\n            }\n            $self->debug(\"blast.pm: Start of new report: $reporttype, $reportversion\\n\");\n            if ( $self->{'_seentop'} ) { \n                # This handles multi-result input streams\n                $self->_pushback($_);\n                last PARSER;\n            }\n            $self->_start_blastoutput;\n            if ($reporttype =~ /RPS-BLAST/) {\n                $reporttype .= '(BLASTP)'; # default RPS-BLAST type\n            }\n            $reportline = $_;   # to fix the fact that RPS-BLAST output is wrong\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_program',\n                    'Data' => $reporttype\n                }\n            );\n\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_version',\n                    'Data' => $reportversion\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_inclusion-threshold',\n                    'Data' => $incl_threshold\n                }\n            );\n        }\n        # added Windows workaround for bug 1985\n        elsif (/^(Searching|Results from round)/) { \n            next unless $1 =~ /Results from round/; \n            $self->debug(\"blast.pm: Possible psi blast iterations found...\\n\");\n            \n            $self->in_element('hsp')\n              && $self->end_element( { 'Name' => 'Hsp' } );\n            $self->in_element('hit')\n              && $self->end_element( { 'Name' => 'Hit' } );\n            if ( defined $seeniteration ) {\n                $self->within_element('iteration')\n                  && $self->end_element( { 'Name' => 'Iteration' } );\n                $self->start_element( { 'Name' => 'Iteration' } );\n            }\n            else {\n                $self->start_element( { 'Name' => 'Iteration' } );\n            }\n            $seeniteration = 1;\n        }\n        elsif (/^Query=\\s*(.*)$/) {\n            my $q    = $1;\n            $self->debug(\"blast.pm: Query= found...$_\\n\");\n            my $size = 0;\n            if ( defined $seenquery ) {\n                $self->_pushback($reportline) if $reportline;\n                $self->_pushback($_);\n                last PARSER;\n            }\n            else {\n                if ( !defined $reporttype ) {\n                    $self->_start_blastoutput;\n                    if ( defined $seeniteration ) {\n                        $self->in_element('iteration')\n                          && $self->end_element( { 'Name' => 'Iteration' } );\n                        $self->start_element( { 'Name' => 'Iteration' } );\n                    }\n                    else {\n                        $self->start_element( { 'Name' => 'Iteration' } );\n                    }\n                    $seeniteration = 1;\n                }\n            }\n            $seenquery = $q;\n            $_ = $self->_readline;\n            while ( defined($_) ) {\n                if (/^Database:/) {\n                    $self->_pushback($_);\n                    last;\n                }\n                # below line fixes length issue with BLAST v2.2.13; still works \n                # with BLAST v2.2.12\n                if ( /\\((\\-?[\\d,]+)\\s+letters.*\\)/ || /^Length=(\\-?[\\d,]+)/ ) {\n                    $size = $1;\n                    $size =~ s/,//g;\n                    last;\n                }\n                else {\n                    # bug 2391\n                    $q .= ($q =~ /\\w$/ && $_ =~ /^\\w/) ? \" $_\" : $_;\n                    $q =~ s/\\s+/ /g; # this catches the newline as well\n                    $q =~ s/^ | $//g;\n                }\n\n                $_ = $self->_readline;\n            }\n            chomp($q);\n            my ( $nm, $desc ) = split( /\\s+/, $q, 2 );\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_query-def',\n                    'Data' => $nm\n                }\n            ) if $nm;\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_query-len',\n                    'Data' => $size\n                }\n            );\n            defined $desc && $desc =~ s/\\s+$//;\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_querydesc',\n                    'Data' => $desc\n                }\n            );\n            my ( $gi, $acc, $version ) = $self->_get_seq_identifiers($nm);\n            $version = defined($version) && length($version) ? \".$version\" : \"\";\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_query-acc',\n                    'Data' => \"$acc$version\"\n                }\n            ) if $acc;\n        }\n\t\t# added check for WU-BLAST -echofilter option (bug 2388)\n\t\telsif (/^>Unfiltered[+-]1$/) {\n        \t# skip all of the lines of unfiltered sequence\n\t\t\twhile($_ !~ /^Database:/) {\n\t\t\t\t$self->debug(\"Bypassing features line: $_\");\n        \t\t$_ = $self->_readline;\n        \t}\n\t\t\t$self->_pushback($_);\n\t\t}\n        elsif (/Sequences producing significant alignments:/) {\n            $self->debug(\"blast.pm: Processing NCBI-BLAST descriptions\\n\");\n            $flavor = 'ncbi';\n            \n            # PSI-BLAST parsing needs to be fixed to specifically look\n            # for old vs new per iteration, as sorting based on duplication\n            # leads to bugs, see bug 1986\n            \n            # The next line is not necessarily whitespace in psiblast reports.\n            # Also note that we must look for the end of this section by testing\n            # for a line with a leading >. Blank lines occur with this section\n            # for psiblast.\n            if ( !$self->in_element('iteration') ) {\n                $self->start_element( { 'Name' => 'Iteration' } );\n            }\n            # these elements are dropped with some multiquery reports; add\n            # back here\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_db-len',\n                    'Data' => $self->{'_blsdb_length'}\n                } \n            ) if $self->{'_blsdb_length'};\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_db-let',\n                    'Data' => $self->{'_blsdb_letters'}\n                }\n            ) if $self->{'_blsdb_letters'};\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_db',\n                    'Data' => $self->{'_blsdb'}\n                }\n            ) if $self->{'_blsdb_letters'};\n            \n            # changed 8/28/2008 to exit hit table if blank line is found after an\n            # appropriate line\n            my $h_regex;\n            my $seen_block;\n          DESCLINE:\n            while ( defined( my $descline = $self->_readline() ) ) {\n                if ($descline =~ m{^\\s*$}) {\n                    last DESCLINE if $seen_block;\n                    next DESCLINE;\n                }\n                # any text match is part of block...\n                $seen_block++;\n                # GCG multiline oddness...\n                if ($descline =~ /^(\\S+)\\s+Begin:\\s\\d+\\s+End:\\s+\\d+/xms) {\n                    my ($id, $nextline) = ($1, $self->_readline);\n                    $nextline =~ s{^!}{};\n                    $descline = \"$id $nextline\";\n                }\n                # NCBI style hit table (no N)\n                if ($descline =~ /(?<!cor)          # negative lookahead\n                    (\\d*\\.?(?:[\\+\\-eE]+)?\\d+)       # number (float or scientific notation)\n                    \\s+                             # space\n                    (\\d*\\.?(?:[\\+\\-eE]+)?\\d+)       # number (float or scientific notation)\n                    \\s*$/xms) {\n                    \n                    my ( $score, $evalue ) = ($1, $2);\n                    \n                    # Some data clean-up so e-value will appear numeric to perl\n                    $evalue =~ s/^e/1e/i;\n\n                    # This to handle no-HSP case\n                    my @line = split ' ',$descline;\n                    \n                    # we want to throw away the score, evalue\n                    pop @line, pop @line;\n\n                    # and N if it is present (of course they are not\n                    # really in that order, but it doesn't matter\n                    if ($3) { pop @line }\n\n                    # add the last 2 entries s.t. we can reconstruct\n                    # a minimal Hit object at the end of the day\n                    push @hit_signifs, [ $evalue, $score, shift @line, join( ' ', @line ) ];\n                } elsif ($descline =~ /^CONVERGED/i) {\n                    $self->element(\n                        {\n                            'Name' => 'Iteration_converged',\n                            'Data' => 1\n                        }\n                    );\n                } else {\n                    $self->_pushback($descline); # Catch leading > (end of section)\n                    last DESCLINE;\n                }\n            }\n        }\n        elsif (/Sequences producing High-scoring Segment Pairs:/) {\n\n     # This block is for WU-BLAST, so we don't have to check for psi-blast stuff\n     # skip the next line\n            $self->debug(\"blast.pm: Processing WU-BLAST descriptions\\n\");\n            $_      = $self->_readline();\n            $flavor = 'wu';\n\n            if ( !$self->in_element('iteration') ) {\n                $self->start_element( { 'Name' => 'Iteration' } );\n            }\n\n            while ( defined( $_ = $self->_readline() )\n                && !/^\\s+$/ )\n            {\n                my @line = split;\n                pop @line;    # throw away first number which is for 'N'col\n\n                # add the last 2 entries to array s.t. we can reconstruct\n                # a minimal Hit object at the end of the day\n                push @hit_signifs,\n                  [ pop @line, pop @line, shift @line, join( ' ', @line ) ];\n            }\n            \n        }\n        elsif (/^Database:\\s*(.+)$/) {\n\n            $self->debug(\"blast.pm: Database: $1\\n\");\n            my $db = $1;\n            while ( defined( $_ = $self->_readline ) ) {\n                if (\n                    /^\\s+(\\-?[\\d\\,]+|\\S+)\\s+sequences\\;\n                   \\s+(\\-?[\\d,]+|\\S+)\\s+ # Deal with NCBI 2.2.8 OSX problems\n                   total\\s+letters/ox\n                  )\n                {\n                    my ( $s, $l ) = ( $1, $2 );\n                    $s =~ s/,//g;\n                    $l =~ s/,//g;\n                    $self->element(\n                        {\n                            'Name' => 'BlastOutput_db-len',\n                            'Data' => $s\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'BlastOutput_db-let',\n                            'Data' => $l\n                        }\n                    );\n                    # cache for next round in cases with multiple queries\n                    $self->{'_blsdb'} = $db;\n                    $self->{'_blsdb_length'} = $s;\n                    $self->{'_blsdb_letters'} = $l;                    \n                    last;\n                }\n                else {\n                    chomp;\n                    $db .= $_;\n                }\n            }\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_db',\n                    'Data' => $db\n                }\n            );\n        }\n        # bypasses this NCBI blast 2.2.13 extra output for now...\n\t\t# Features in/flanking this part of subject sequence:\n        elsif (/^\\sFeatures\\s\\w+\\sthis\\spart/xmso) {\n            my $featline;\n            $_ = $self->_readline;\n\t\t\twhile($_ !~ /^\\s*$/) {\n                chomp;\n                $featline .= $_;\n        \t\t$_ = $self->_readline;\n        \t}\n\t\t\t$self->_pushback($_);\n            $featline =~ s{(?:^\\s+|\\s+^)}{}g;\n            $featline =~ s{\\n}{;}g;\n            $self->{'_last_hspdata'}->{'Hsp_features'} = $featline;\n        }\n        \n        # move inside of a hit\n        elsif (/^>\\s*(\\S+)\\s*(.*)?/) {\n            chomp;\n\n            $self->debug(\"blast.pm: Hit: $1\\n\");\n            $self->in_element('hsp')\n              && $self->end_element( { 'Name' => 'Hsp' } );\n            $self->in_element('hit')\n              && $self->end_element( { 'Name' => 'Hit' } );\n\n            # special case when bl2seq reports don't have a leading\n            # Query=\n            if ( !$self->within_element('result') ) {\n                $self->_start_blastoutput;\n                $self->start_element( { 'Name' => 'Iteration' } );\n            }\n            elsif ( !$self->within_element('iteration') ) {\n                $self->start_element( { 'Name' => 'Iteration' } );\n            }\n            $self->start_element( { 'Name' => 'Hit' } );\n            my $id         = $1;\n            my $restofline = $2;\n\n            $self->debug(\"Starting a hit: $1 $2\\n\");\n            $self->element(\n                {\n                    'Name' => 'Hit_id',\n                    'Data' => $id\n                }\n            );\n            my ($gi, $acc, $version ) = $self->_get_seq_identifiers($id);\n            $self->element(\n                {\n                    'Name' => 'Hit_accession',\n                    'Data' => $acc\n                }\n            );\n            # add hit significance (from the hit table)\n            # this is where Bug 1986 went awry\n            \n            # Changed for Bug2409; hit->significance and hit->score/bits derived\n            # from HSPs, not hit table unless necessary\n            \n            HITTABLE:\n            while (my $v = shift @hit_signifs) {        \n                my $tableid = $v->[2];\n                if ($tableid !~ m{\\Q$id\\E}) {\n                    $self->debug(\"Hit table ID $tableid doesn't match current hit id $id, checking next hit table entry...\\n\");\n                    next HITTABLE;\n                } else {\n                    last HITTABLE;\n                }\n            }\n            while ( defined( $_ = $self->_readline() ) ) {\n                next if (/^\\s+$/);\n                chomp;\n                if (/Length\\s*=\\s*([\\d,]+)/) {\n                    my $l = $1;\n                    $l =~ s/\\,//g;\n                    $self->element(\n                        {\n                            'Name' => 'Hit_len',\n                            'Data' => $l\n                        }\n                    );\n                    last;\n                }\n                else {\n                    s/^\\s(?!\\s)/\\x01/; #new line to concatenate desc lines with <soh>\n                    $restofline .= $_;\n                }\n            }\n            $restofline =~ s/\\s+/ /g;\n            $self->element(\n                {\n                    'Name' => 'Hit_def',\n                    'Data' => $restofline\n                }\n            );\n        }\n        elsif (/\\s+(Plus|Minus) Strand HSPs:/i) {\n            next;\n        }\n        elsif (\n            ( $self->in_element('hit') || $self->in_element('hsp') )\n            &&    # paracel genewise BTK\n            m/Score\\s*=\\s*(\\S+)\\s*bits\\s* # Bit score\n                (?:\\((\\d+)\\))?,                 # Raw score\n\t\t\\s+Log\\-Length\\sScore\\s*=\\s*(\\d+) # Log-Length score\n                /ox\n          )\n        {\n            $self->in_element('hsp')\n              && $self->end_element( { 'Name' => 'Hsp' } );\n            $self->start_element( { 'Name' => 'Hsp' } );\n\n            $self->debug( \"Got paracel genewise HSP score=$1\\n\");\n\n            # Some data clean-up so e-value will appear numeric to perl\n            my ( $bits, $score, $evalue ) = ( $1, $2, $3 );\n            $evalue =~ s/^e/1e/i;\n            $self->element(\n                {\n                    'Name' => 'Hsp_score',\n                    'Data' => $score\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_bit-score',\n                    'Data' => $bits\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_evalue',\n                    'Data' => $evalue\n                }\n            );\n        }\n        elsif (\n            ( $self->in_element('hit') || $self->in_element('hsp') )\n            &&    # paracel hframe BTK\n            m/Score\\s*=\\s*([^,\\s]+),     # Raw score\n\t\t\\s*Expect\\s*=\\s*([^,\\s]+),  # E-value\n                \\s*P(?:\\(\\S+\\))?\\s*=\\s*([^,\\s]+) # P-value\n                /ox\n          )\n        {\n            $self->in_element('hsp')\n              && $self->end_element( { 'Name' => 'Hsp' } );\n            $self->start_element( { 'Name' => 'Hsp' } );\n\n            $self->debug( \"Got paracel hframe HSP score=$1\\n\");\n\n            # Some data clean-up so e-value will appear numeric to perl\n            my ( $score, $evalue, $pvalue ) = ( $1, $2, $3 );\n            $evalue = \"1$evalue\" if $evalue =~ /^e/;\n            $pvalue = \"1$pvalue\" if $pvalue =~ /^e/;\n\n            $self->element(\n                {\n                    'Name' => 'Hsp_score',\n                    'Data' => $score\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_evalue',\n                    'Data' => $evalue\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_pvalue',\n                    'Data' => $pvalue\n                }\n            );\n        }\n        elsif (\n            ( $self->in_element('hit') || $self->in_element('hsp') )\n            &&    # wublast\n            m/Score\\s*=\\s*(\\S+)\\s*         # Bit score\n                \\(([\\d\\.]+)\\s*bits\\),         # Raw score\n                \\s*Expect\\s*=\\s*([^,\\s]+),    # E-value\n                \\s*(?:Sum)?\\s*                # SUM\n                P(?:\\(\\d+\\))?\\s*=\\s*([^,\\s]+) # P-value\n                (?:\\s*,\\s+Group\\s*\\=\\s*(\\d+))?    # HSP Group\n                /ox\n          )\n        {         # wu-blast HSP parse\n            $self->in_element('hsp')\n              && $self->end_element( { 'Name' => 'Hsp' } );\n            $self->start_element( { 'Name' => 'Hsp' } );\n\n            # Some data clean-up so e-value will appear numeric to perl\n            my ( $score, $bits, $evalue, $pvalue, $group ) =\n              ( $1, $2, $3, $4, $5 );\n            $evalue =~ s/^e/1e/i;\n            $pvalue =~ s/^e/1e/i;\n\n            $self->element(\n                {\n                    'Name' => 'Hsp_score',\n                    'Data' => $score\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_bit-score',\n                    'Data' => $bits\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_evalue',\n                    'Data' => $evalue\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_pvalue',\n                    'Data' => $pvalue\n                }\n            );\n\n            if ( defined $group ) {\n                $self->element(\n                    {\n                        'Name' => 'Hsp_group',\n                        'Data' => $group\n                    }\n                );\n            }\n\n        }\n        elsif (\n            ( $self->in_element('hit') || $self->in_element('hsp') )\n            &&    # ncbi blast, works with 2.2.17\n            m/Score\\s*=\\s*(\\S+)\\s*bits\\s* # Bit score\n                (?:\\((\\d+)\\))?,            # Missing for BLAT pseudo-BLAST fmt \n                \\s*Expect(?:\\((\\d+\\+?)\\))?\\s*=\\s*([^,\\s]+) # E-value\n                /ox\n          )\n        {         # parse NCBI blast HSP\n            $self->in_element('hsp')\n              && $self->end_element( { 'Name' => 'Hsp' } );\n\n            # Some data clean-up so e-value will appear numeric to perl\n            my ( $bits, $score, $n, $evalue ) = ( $1, $2, $3, $4 );\n            $evalue =~ s/^e/1e/i;\n            $self->start_element( { 'Name' => 'Hsp' } );\n            $self->element(\n                {\n                    'Name' => 'Hsp_score',\n                    'Data' => $score\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_bit-score',\n                    'Data' => $bits\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_evalue',\n                    'Data' => $evalue\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_n',\n                    'Data' => $n\n                }\n            ) if defined $n;\n            $score = '' unless defined $score;    # deal with BLAT which\n                                                  # has no score only bits\n            $self->debug(\"Got NCBI HSP score=$score, evalue $evalue\\n\");\n        }\n        elsif (\n            $self->in_element('hsp')\n            && m/Identities\\s*=\\s*(\\d+)\\s*\\/\\s*(\\d+)\\s*[\\d\\%\\(\\)]+\\s*\n                (?:,\\s*Positives\\s*=\\s*(\\d+)\\/(\\d+)\\s*[\\d\\%\\(\\)]+\\s*)? # pos only valid for Protein alignments\n                (?:\\,\\s*Gaps\\s*=\\s*(\\d+)\\/(\\d+))? # Gaps\n                /oxi\n          )\n        {\n            $self->element(\n                {\n                    'Name' => 'Hsp_identity',\n                    'Data' => $1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_align-len',\n                    'Data' => $2\n                }\n            );\n            if ( defined $3 ) {\n                $self->element(\n                    {\n                        'Name' => 'Hsp_positive',\n                        'Data' => $3\n                    }\n                );\n            }\n            else {\n                $self->element(\n                    {\n                        'Name' => 'Hsp_positive',\n                        'Data' => $1\n                    }\n                );\n            }\n            if ( defined $6 ) {\n                $self->element(\n                    {\n                        'Name' => 'Hsp_gaps',\n                        'Data' => $5\n                    }\n                );\n            }\n\n            $self->{'_Query'} = { 'begin' => 0, 'end' => 0 };\n            $self->{'_Sbjct'} = { 'begin' => 0, 'end' => 0 };\n\n            if (/(Frame\\s*=\\s*.+)$/) {\n\n                # handle wu-blast Frame listing on same line\n                $self->_pushback($1);\n            }\n        }\n        elsif ( $self->in_element('hsp')\n            && /Strand\\s*=\\s*(Plus|Minus)\\s*\\/\\s*(Plus|Minus)/i )\n        {\n\n            # consume this event ( we infer strand from start/end)\n            unless ($reporttype) {\n                $self->{'_reporttype'} = $reporttype = 'BLASTN';\n                $bl2seq_fix = 1;    # special case to resubmit the algorithm\n                                    # reporttype\n            }\n            next;\n        }\n        elsif ( $self->in_element('hsp')\n            && /Links\\s*=\\s*(\\S+)/ox )\n        {\n            $self->element(\n                {\n                    'Name' => 'Hsp_links',\n                    'Data' => $1\n                }\n            );\n        }\n        elsif ( $self->in_element('hsp')\n            && /Frame\\s*=\\s*([\\+\\-][1-3])\\s*(\\/\\s*([\\+\\-][1-3]))?/ )\n        {\n\n            # this is for bl2seq only\n            unless ( defined $reporttype ) {\n                $bl2seq_fix = 1;\n                if ( $1 && $2 ) { $reporttype = 'TBLASTX' }\n                else {\n                    $reporttype = 'BLASTX';\n\n    # we can't distinguish between BLASTX and TBLASTN straight from the report }\n                }\n                $self->{'_reporttype'} = $reporttype;\n            }\n\n            my ( $queryframe, $hitframe );\n            if ( $reporttype eq 'TBLASTX' ) {\n                ( $queryframe, $hitframe ) = ( $1, $2 );\n                $hitframe =~ s/\\/\\s*//g;\n            }\n            elsif ( $reporttype eq 'TBLASTN' || $reporttype eq 'PSITBLASTN') {\n                ( $hitframe, $queryframe ) = ( $1, 0 );\n            }\n            elsif ( $reporttype eq 'BLASTX' || $reporttype eq 'RPS-BLAST(BLASTP)') {\n                ( $queryframe, $hitframe ) = ( $1, 0 );\n                # though NCBI doesn't report it, this is a special BLASTX-like\n                # RPS-BLAST; should be handled differently\n                if ($reporttype eq 'RPS-BLAST(BLASTP)') {\n                    $self->element(\n                        {\n                            'Name' => 'BlastOutput_program',\n                            'Data' => 'RPS-BLAST(BLASTX)'\n                        }\n                    );\n                }\n            }\n            $self->element(\n                {\n                    'Name' => 'Hsp_query-frame',\n                    'Data' => $queryframe\n                }\n            );\n\n            $self->element(\n                {\n                    'Name' => 'Hsp_hit-frame',\n                    'Data' => $hitframe\n                }\n            );\n        }\n        elsif (/^Parameters:/\n            || /^\\s+Database:\\s+?/\n            || /^\\s+Subset/\n            || /^\\s*Lambda/\n            || /^\\s*Histogram/\n            || ( $self->in_element('hsp') && /WARNING|NOTE/ ) )\n        {\n\n            # Note: Lambda check was necessary to parse\n            # t/data/ecoli_domains.rpsblast AND to parse bl2seq\n            $self->debug(\"blast.pm: found parameters section \\n\");\n\n            $self->in_element('hsp')\n              && $self->end_element( { 'Name' => 'Hsp' } );\n            $self->in_element('hit')\n              && $self->end_element( { 'Name' => 'Hit' } );\n\n            # This is for the case when we specify -b 0 (or B=0 for WU-BLAST)\n            # and still want to construct minimal Hit objects\n            $self->_cleanup_hits(\\@hit_signifs) if scalar(@hit_signifs);\n            $self->within_element('iteration')\n              && $self->end_element( { 'Name' => 'Iteration' } );\n\n            next if /^\\s+Subset/;\n            my $blast = (/^(\\s+Database\\:)|(\\s*Lambda)/) ? 'ncbi' : 'wublast';\n            if (/^\\s*Histogram/) {\n                $blast = 'btk';\n            }\n\n            my $last = '';\n\n            # default is that gaps are allowed\n            $self->element(\n                {\n                    'Name' => 'Parameters_allowgaps',\n                    'Data' => 'yes'\n                }\n            );\n            while ( defined( $_ = $self->_readline ) ) {\n                if (\n                    /^((?:\\S+)?BLAST[NPX]?)\\s+(.+)$/i  # NCBI BLAST, PSIBLAST\n                                                      # RPSBLAST, MEGABLAST\n                    || /^(P?GENEWISE|HFRAME|SWN|TSWN)\\s+(.+)/i    #Paracel BTK\n                  )\n                {\n                    $self->_pushback($_);\n\n                    # let's handle this in the loop\n                    last;\n                }\n                elsif (/^Query=/) {\n                    $self->_pushback($reportline) if $reportline;\n                    $self->_pushback($_);\n                    last PARSER;\n                }\n\n                # here is where difference between wublast and ncbiblast\n                # is better handled by different logic\n                if (   /Number of Sequences:\\s+([\\d\\,]+)/i\n                    || /of sequences in database:\\s+(\\-?[\\d,]+)/i )\n                {\n                    my $c = $1;\n                    $c =~ s/\\,//g;\n                    $self->element(\n                        {\n                            'Name' => 'Statistics_db-len',\n                            'Data' => $c\n                        }\n                    );\n                }\n                elsif (/letters in database:\\s+(\\-?[\\d,]+)/i) {\n                    my $s = $1;\n                    $s =~ s/,//g;\n                    $self->element(\n                        {\n                            'Name' => 'Statistics_db-let',\n                            'Data' => $s\n                        }\n                    );\n                }\n                elsif ( $blast eq 'btk' ) {\n                    next;\n                }\n                elsif ( $blast eq 'wublast' ) {\n\n                    #\t\t   warn($_);\n                    if (/E=(\\S+)/) {\n                        $self->element(\n                            {\n                                'Name' => 'Parameters_expect',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (/nogaps/) {\n                        $self->element(\n                            {\n                                'Name' => 'Parameters_allowgaps',\n                                'Data' => 'no'\n                            }\n                        );\n                    }\n                    elsif (/ctxfactor=(\\S+)/) {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_ctxfactor',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (\n/(postsw|links|span[12]?|warnings|notes|gi|noseqs|qres|qype)/\n                      )\n                    {\n                        $self->element(\n                            {\n                                'Name' => \"Parameters_$1\",\n                                'Data' => 'yes'\n                            }\n                        );\n                    }\n                    elsif (/(\\S+)=(\\S+)/) {\n                        $self->element(\n                            {\n                                'Name' => \"Parameters_$1\",\n                                'Data' => $2\n                            }\n                        );\n                    }\n                    elsif ( $last =~ /(Frame|Strand)\\s+MatID\\s+Matrix name/i ) {\n                        my $firstgapinfo = 1;\n                        my $frame        = undef;\n                        while ( defined($_) && !/^\\s+$/ ) {\n                            s/^\\s+//;\n                            s/\\s+$//;\n                            if ( $firstgapinfo\n                                && s/Q=(\\d+),R=(\\d+)\\s+//x )\n                            {\n                                $firstgapinfo = 0;\n\n                                $self->element(\n                                    {\n                                        'Name' => 'Parameters_gap-open',\n                                        'Data' => $1\n                                    }\n                                );\n                                $self->element(\n                                    {\n                                        'Name' => 'Parameters_gap-extend',\n                                        'Data' => $2\n                                    }\n                                );\n                                my @fields = split;\n\n                                for my $type (\n                                    qw(lambda_gapped\n                                    kappa_gapped\n                                    entropy_gapped)\n                                  )\n                                {\n                                    next if $type eq 'n/a';\n                                    if ( !@fields ) {\n                                        warn \"fields is empty for $type\\n\";\n                                        next;\n                                    }\n                                    $self->element(\n                                        {\n                                            'Name' =>\n                                              \"Statistics_frame$frame\\_$type\",\n                                            'Data' => shift @fields\n                                        }\n                                    );\n                                }\n                            }\n                            else {\n                                my ( $frameo, $matid, $matrix, @fields ) =\n                                  split;\n                                if ( !defined $frame ) {\n\n                                    # keep some sort of default feature I guess\n                                    # even though this is sort of wrong\n                                    $self->element(\n                                        {\n                                            'Name' => 'Parameters_matrix',\n                                            'Data' => $matrix\n                                        }\n                                    );\n                                    $self->element(\n                                        {\n                                            'Name' => 'Statistics_lambda',\n                                            'Data' => $fields[0]\n                                        }\n                                    );\n                                    $self->element(\n                                        {\n                                            'Name' => 'Statistics_kappa',\n                                            'Data' => $fields[1]\n                                        }\n                                    );\n                                    $self->element(\n                                        {\n                                            'Name' => 'Statistics_entropy',\n                                            'Data' => $fields[2]\n                                        }\n                                    );\n                                }\n                                $frame = $frameo;\n                                my $ii = 0;\n                                for my $type (\n                                    qw(lambda_used\n                                    kappa_used\n                                    entropy_used\n                                    lambda_computed\n                                    kappa_computed\n                                    entropy_computed)\n                                  )\n                                {\n                                    my $f = $fields[$ii];\n                                    next unless defined $f;    # deal with n/a\n                                    if ( $f eq 'same' ) {\n                                        $f = $fields[ $ii - 3 ];\n                                    }\n                                    $ii++;\n                                    $self->element(\n                                        {\n                                            'Name' =>\n                                              \"Statistics_frame$frame\\_$type\",\n                                            'Data' => $f\n                                        }\n                                    );\n\n                                }\n                            }\n\n                            # get the next line\n                            $_ = $self->_readline;\n                        }\n                        $last = $_;\n                    }\n                    elsif ( $last =~ /(Frame|Strand)\\s+MatID\\s+Length/i ) {\n                        my $frame = undef;\n                        while ( defined($_) && !/^\\s+/ ) {\n                            s/^\\s+//;\n                            s/\\s+$//;\n                            my @fields = split;\n                            if ( @fields <= 3 ) {\n                                for my $type (qw(X_gapped E2_gapped S2)) {\n                                    last unless @fields;\n                                    $self->element(\n                                        {\n                                            'Name' =>\n                                              \"Statistics_frame$frame\\_$type\",\n                                            'Data' => shift @fields\n                                        }\n                                    );\n                                }\n                            }\n                            else {\n\n                                for my $type (\n                                    qw(length\n                                    efflength\n                                    E S W T X E2 S2)\n                                  )\n                                {\n                                    $self->element(\n                                        {\n                                            'Name' =>\n                                              \"Statistics_frame$frame\\_$type\",\n                                            'Data' => shift @fields\n                                        }\n                                    );\n                                }\n                            }\n                            $_ = $self->_readline;\n                        }\n                        $last = $_;\n                    }\n                    elsif (/(\\S+\\s+\\S+)\\s+DFA:\\s+(\\S+)\\s+\\((.+)\\)/) {\n                        if ( $1 eq 'states in' ) {\n                            $self->element(\n                                {\n                                    'Name' => 'Statistics_DFA_states',\n                                    'Data' => \"$2 $3\"\n                                }\n                            );\n                        }\n                        elsif ( $1 eq 'size of' ) {\n                            $self->element(\n                                {\n                                    'Name' => 'Statistics_DFA_size',\n                                    'Data' => \"$2 $3\"\n                                }\n                            );\n                        }\n                    }\n                    elsif (\n                        m/^\\s+Time to generate neighborhood:\\s+\n\t\t\t    (\\S+\\s+\\S+\\s+\\S+)/x\n                      )\n                    {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_neighbortime',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (/processors\\s+used:\\s+(\\d+)/) {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_noprocessors',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (\n                        m/^\\s+(\\S+)\\s+cpu\\s+time:\\s+# cputype\n\t\t\t    (\\S+\\s+\\S+\\s+\\S+)           # cputime\n\t\t\t    \\s+Elapsed:\\s+(\\S+)/x\n                      )\n                    {\n                        my $cputype = lc($1);\n                        $self->element(\n                            {\n                                'Name' => \"Statistics_$cputype\\_cputime\",\n                                'Data' => $2\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => \"Statistics_$cputype\\_actualtime\",\n                                'Data' => $3\n                            }\n                        );\n                    }\n                    elsif (/^\\s+Start:/) {\n                        my ( $junk, $start, $stime, $end, $etime ) =\n                          split( /\\s+(Start|End)\\:\\s+/, $_ );\n                        chomp($stime);\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_starttime',\n                                'Data' => $stime\n                            }\n                        );\n                        chomp($etime);\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_endtime',\n                                'Data' => $etime\n                            }\n                        );\n                    }\n                    elsif (/^\\s+Database:\\s+(.+)$/) {\n                        $self->element(\n                            {\n                                'Name' => 'Parameters_full_dbpath',\n                                'Data' => $1\n                            }\n                        );\n\n                    }\n                    elsif (/^\\s+Posted:\\s+(.+)/) {\n                        my $d = $1;\n                        chomp($d);\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_posted_date',\n                                'Data' => $d\n                            }\n                        );\n                    }\n                }\n                elsif ( $blast eq 'ncbi' ) {\n\n                    if (m/^Matrix:\\s+(.+)\\s*$/oxi) {\n                        $self->element(\n                            {\n                                'Name' => 'Parameters_matrix',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (/^Gapped/) {\n                        $gapped_stats = 1;\n                    }\n                    elsif (/^Lambda/) {\n                        $_ = $self->_readline;\n                        s/^\\s+//;\n                        my ( $lambda, $kappa, $entropy ) = split;\n                        if ($gapped_stats) {\n                            $self->element(\n                                {\n                                    'Name' => \"Statistics_gapped_lambda\",\n                                    'Data' => $lambda\n                                }\n                            );\n                            $self->element(\n                                {\n                                    'Name' => \"Statistics_gapped_kappa\",\n                                    'Data' => $kappa\n                                }\n                            );\n                            $self->element(\n                                {\n                                    'Name' => \"Statistics_gapped_entropy\",\n                                    'Data' => $entropy\n                                }\n                            );\n                        }\n                        else {\n                            $self->element(\n                                {\n                                    'Name' => \"Statistics_lambda\",\n                                    'Data' => $lambda\n                                }\n                            );\n                            $self->element(\n                                {\n                                    'Name' => \"Statistics_kappa\",\n                                    'Data' => $kappa\n                                }\n                            );\n                            $self->element(\n                                {\n                                    'Name' => \"Statistics_entropy\",\n                                    'Data' => $entropy\n                                }\n                            );\n                        }\n                    }\n                    elsif (m/effective\\s+search\\s+space\\s+used:\\s+(\\d+)/ox) {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_eff-spaceused',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (m/effective\\s+search\\s+space:\\s+(\\d+)/ox) {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_eff-space',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (\n                        m/Gap\\s+Penalties:\\s+Existence:\\s+(\\d+)\\,\n\t\t\t    \\s+Extension:\\s+(\\d+)/ox\n                      )\n                    {\n                        $self->element(\n                            {\n                                'Name' => 'Parameters_gap-open',\n                                'Data' => $1\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Parameters_gap-extend',\n                                'Data' => $2\n                            }\n                        );\n                    }\n                    elsif (/effective\\s+HSP\\s+length:\\s+(\\d+)/) {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_hsp-len',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (/effective\\s+length\\s+of\\s+query:\\s+([\\d\\,]+)/) {\n                        my $c = $1;\n                        $c =~ s/\\,//g;\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_query-len',\n                                'Data' => $c\n                            }\n                        );\n                    }\n                    elsif (/effective\\s+length\\s+of\\s+database:\\s+([\\d\\,]+)/) {\n                        my $c = $1;\n                        $c =~ s/\\,//g;\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_eff-dblen',\n                                'Data' => $c\n                            }\n                        );\n                    }\n                    elsif (\n/^(T|A|X1|X2|X3|S1|S2):\\s+(\\d+(\\.\\d+)?)\\s+(?:\\(\\s*(\\d+\\.\\d+) bits\\))?/\n                      )\n                    {\n                        my $v = $2;\n                        chomp($v);\n                        $self->element(\n                            {\n                                'Name' => \"Statistics_$1\",\n                                'Data' => $v\n                            }\n                        );\n                        if ( defined $4 ) {\n                            $self->element(\n                                {\n                                    'Name' => \"Statistics_$1_bits\",\n                                    'Data' => $4\n                                }\n                            );\n                        }\n                    }\n                    elsif (\n                        m/frameshift\\s+window\\,\n\t\t\t    \\s+decay\\s+const:\\s+(\\d+)\\,\\s+([\\.\\d]+)/x\n                      )\n                    {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_framewindow',\n                                'Data' => $1\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_decay',\n                                'Data' => $2\n                            }\n                        );\n                    }\n                    elsif (m/^Number\\s+of\\s+Hits\\s+to\\s+DB:\\s+(\\S+)/ox) {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_hit_to_db',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (m/^Number\\s+of\\s+extensions:\\s+(\\S+)/ox) {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_num_extensions',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (\n                        m/^Number\\s+of\\s+successful\\s+extensions:\\s+\n\t\t\t    (\\S+)/ox\n                      )\n                    {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_num_suc_extensions',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (\n                        m/^Number\\s+of\\s+sequences\\s+better\\s+than\\s+\n\t\t\t    (\\S+):\\s+(\\d+)/ox\n                      )\n                    {\n                        $self->element(\n                            {\n                                'Name' => 'Parameters_expect',\n                                'Data' => $1\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_seqs_better_than_cutoff',\n                                'Data' => $2\n                            }\n                        );\n                    }\n                    elsif (/^\\s+Posted\\s+date:\\s+(.+)/) {\n                        my $d = $1;\n                        chomp($d);\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_posted_date',\n                                'Data' => $d\n                            }\n                        );\n                    }\n                    elsif ( !/^\\s+$/ ) {\n                        #$self->debug( \"unmatched stat $_\");\n                    }\n                }\n                $last = $_;\n            }\n        } elsif ( $self->in_element('hsp') ) {\n            $self->debug(\"blast.pm: Processing HSP\\n\");\n            # let's read 3 lines at a time;\n            # bl2seq hackiness... Not sure I like\n            $self->{'_reporttype'} ||= $DEFAULTREPORTTYPE;\n            my %data = (\n                'Query' => '',\n                'Mid'   => '',\n                'Hit'   => ''\n            );\n            my $len;\n            for ( my $i = 0 ; defined($_) && $i < 3 ; $i++ ) {\n                # $self->debug(\"$i: $_\") if $v;\n                if ( ( $i == 0 && /^\\s+$/) || \n\t\t     /^\\s*(?:Lambda|Minus|Plus|Score)/i )\n                {\n                    $self->_pushback($_) if defined $_;\n                    $self->end_element( { 'Name' => 'Hsp' } );\n                    last;\n                }\n                chomp;\n                if (/^((Query|Sbjct):?\\s+(\\-?\\d+)\\s*)(\\S+)\\s+(\\-?\\d+)/) {\n                    my ( $full, $type, $start, $str, $end ) =\n                      ( $1, $2, $3, $4, $5 );\n\n                    if ( $str eq '-' ) {\n                        $i = 3 if $type eq 'Sbjct';\n                    }\n                    else {\n                        $data{$type} = $str;\n                    }\n                    $len = length($full);\n                    $self->{\"\\_$type\"}->{'begin'} = $start\n                      unless $self->{\"_$type\"}->{'begin'};\n                    $self->{\"\\_$type\"}->{'end'} = $end;\n                } else {\n                    $self->throw(\"no data for midline $_\")\n                      unless ( defined $_ && defined $len );\n                    $data{'Mid'} = substr( $_, $len );\n                }\n                $_ = $self->_readline();\n            }\n            $self->characters(\n                {\n                    'Name' => 'Hsp_qseq',\n                    'Data' => $data{'Query'}\n                }\n            );\n            $self->characters(\n                {\n                    'Name' => 'Hsp_hseq',\n                    'Data' => $data{'Sbjct'}\n                }\n            );\n            $self->characters(\n                {\n                    'Name' => 'Hsp_midline',\n                    'Data' => $data{'Mid'}\n                }\n            );\n        }\n        else {\n            #$self->debug(\"blast.pm: unrecognized line $_\");\n        }\n    }\n\n    $self->debug(\"blast.pm: End of BlastOutput\\n\");\n    if ( $self->{'_seentop'} ) {\n        $self->within_element('hsp')\n          && $self->end_element( { 'Name' => 'Hsp' } );\n        $self->within_element('hit')\n          && $self->end_element( { 'Name' => 'Hit' } );\n        # cleanup extra hits\n        $self->_cleanup_hits(\\@hit_signifs) if scalar(@hit_signifs);\n        $self->within_element('iteration')\n          && $self->end_element( { 'Name' => 'Iteration' } );\n        if ($bl2seq_fix) {\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_program',\n                    'Data' => $reporttype\n                }\n            );\n        }\n        $self->end_element( { 'Name' => 'BlastOutput' } );\n    }\n    return $self->end_document();\n}\n\n# Private method for internal use only.\nsub _start_blastoutput {\n    my $self = shift;\n    $self->start_element( { 'Name' => 'BlastOutput' } );\n    $self->{'_seentop'} = 1;\n    $self->{'_result_count'}++;\n    $self->{'_handler_rc'} = undef;\n}\n\n=head2 _will_handle\n\n Title   : _will_handle\n Usage   : Private method. For internal use only.\n              if( $self->_will_handle($type) ) { ... }\n Function: Provides an optimized way to check whether or not an element of a \n           given type is to be handled.\n Returns : Reference to EventHandler object if the element type is to be handled.\n           undef if the element type is not to be handled.\n Args    : string containing type of element.\n\nOptimizations:\n\n=over 2\n\n* 1\n\nUsing the cached pointer to the EventHandler to minimize repeated\nlookups.\n\n* 2\n\nCaching the will_handle status for each type that is encountered so\nthat it only need be checked by calling\nhandler-E<gt>will_handle($type) once.\n\n\nThis does not lead to a major savings by itself (only 5-10%).  In\ncombination with other optimizations, or for large parse jobs, the\nsavings good be significant.\n\nTo test against the unoptimized version, remove the parentheses from\naround the third term in the ternary \" ? : \" operator and add two\ncalls to $self-E<gt>_eventHandler().\n\n\nsub _will_handle {\n    my ( $self, $type ) = @_;\n    my $handler     = $self->{'_handler_cache'};\n    my $will_handle =\n      defined( $self->{'_will_handle_cache'}->{$type} )\n      ? $self->{'_will_handle_cache'}->{$type}\n      : ( $self->{'_will_handle_cache'}->{$type} =\n          $handler->will_handle($type) );\n\n    return $will_handle ? $handler : undef;\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\nsub start_element {\n    my ( $self, $data ) = @_;\n\n    # we currently don't care about attributes\n    my $nm   = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    if ($type) {\n        my $handler = $self->_will_handle($type);\n        if ($handler) {\n            my $func = sprintf( \"start_%s\", lc $type );\n            $self->{'_handler_rc'} = $handler->$func( $data->{'Attributes'} );\n        }\n        #else {\n            #$self->debug( # changed 4/29/2006 to play nice with other event handlers\n            #    \"Bio::SearchIO::InternalParserError \".\n            #    \"\\nCan't handle elements of type \\'$type.\\'\"\n            #);\n        #}\n        unshift @{ $self->{'_elements'} }, $type;\n        if ( $type eq 'result' ) {\n            $self->{'_values'} = {};\n            $self->{'_result'} = undef;\n        } else {\n            # cleanup some things\n            if ( defined $self->{'_values'} ) {\n                foreach my $k (\n                    grep { /^\\U$type\\-/ }\n                    keys %{ $self->{'_values'} }\n                  )\n                {\n                    delete $self->{'_values'}->{$k};\n                }\n            }\n        }\n    }\n}\n\n=head2 end_element\n\n Title   : end_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : hashref with an element's worth of data\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ( $self, $data ) = @_;\n    \n    my $nm   = $data->{'Name'};\n    my $type;\n    my $rc;\n    if ( $nm eq 'BlastOutput_program' ) {\n        if ( $self->{'_last_data'} =~ /(t?blast[npx])/i ) {\n            $self->{'_reporttype'} = uc $1;\n        }\n        $self->{'_reporttype'} ||= $DEFAULTREPORTTYPE;\n    }\n\n    # Hsps are sort of weird, in that they end when another\n    # object begins so have to detect this in end_element for now\n    if ( $nm eq 'Hsp' ) {\n        foreach (qw(Hsp_qseq Hsp_midline Hsp_hseq Hsp_features)) {\n            $self->element(\n                {\n                    'Name' => $_,\n                    'Data' => $self->{'_last_hspdata'}->{$_}\n                }\n            ) if defined $self->{'_last_hspdata'}->{$_};\n        }\n        $self->{'_last_hspdata'} = {};\n        $self->element(\n            {\n                'Name' => 'Hsp_query-from',\n                'Data' => $self->{'_Query'}->{'begin'}\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_query-to',\n                'Data' => $self->{'_Query'}->{'end'}\n            }\n        );\n\n        $self->element(\n            {\n                'Name' => 'Hsp_hit-from',\n                'Data' => $self->{'_Sbjct'}->{'begin'}\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_hit-to',\n                'Data' => $self->{'_Sbjct'}->{'end'}\n            }\n        );\n\n        #    } elsif( $nm eq 'Iteration' ) {\n        # Nothing special needs to be done here.\n    }\n    if ( $type = $MODEMAP{$nm} ) {\n        my $handler = $self->_will_handle($type);\n        if ($handler) {\n            my $func = sprintf( \"end_%s\", lc $type );\n            $rc = $handler->$func( $self->{'_reporttype'}, $self->{'_values'} );\n        }\n        shift @{ $self->{'_elements'} };\n\n    }\n    elsif ( $MAPPING{$nm} ) {\n        if ( ref( $MAPPING{$nm} ) =~ /hash/i ) {\n\n            # this is where we shove in the data from the\n            # hashref info about params or statistics\n            my $key = ( keys %{ $MAPPING{$nm} } )[0];\n            $self->{'_values'}->{$key}->{ $MAPPING{$nm}->{$key} } =\n              $self->{'_last_data'};\n        }\n        else {\n            $self->{'_values'}->{ $MAPPING{$nm} } = $self->{'_last_data'};\n        }\n    }\n    else {\n        #$self->debug(\"blast.pm: unknown nm $nm, ignoring\\n\");\n    }\n    $self->{'_last_data'} = '';    # remove read data if we are at\n                                   # end of an element\n    $self->{'_result'} = $rc if ( defined $type && $type eq 'result' );\n    return $rc;\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convenience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element {\n    my ( $self, $data ) = @_;\n    # Note that start element isn't needed for character data\n    # Not too SAX-y, though\n    #$self->start_element($data);\n    $self->characters($data);\n    $self->end_element($data);\n}\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string\n\n\n\nsub characters {\n    my ( $self, $data ) = @_;\n    if (   $self->in_element('hsp')\n        && $data->{'Name'} =~ /^Hsp\\_(qseq|hseq|midline)$/ )\n    {\n        $self->{'_last_hspdata'}->{ $data->{'Name'} } .= $data->{'Data'}\n          if defined $data->{'Data'};\n    }\n    return unless ( defined $data->{'Data'} && $data->{'Data'} !~ /^\\s+$/ );\n    $self->{'_last_data'} = $data->{'Data'};\n}\n\n=head2 within_element\n\n Title   : within_element\n Usage   : if( $eventgenerator->within_element($element) ) {}\n Function: Test if we are within a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name \n\nSee Also: L<in_element>","label":"within_element($self,$name)"},"detail":"($self,$name)","definition":"sub","containerName":"main::","range":{"start":{"character":0,"line":2116},"end":{"character":9999,"line":2120}},"name":"within_element"},{"line":2121,"kind":13,"containerName":null,"name":"%self"},{"line":2122,"kind":13,"containerName":null,"name":"%name"},{"definition":"sub","containerName":"main::","signature":{"documentation":"(Sesame Street aficionados note: This answer was NOT given by Mr. Noodle ;-P)\n# $Id: blast.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::blast\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n# 20030409 - sac\n#          PSI-BLAST full parsing support. Rollout of new\n#          model which will remove Steve's old psiblast driver\n# 20030424 - jason\n#          Megablast parsing fix as reported by Neil Saunders\n# 20030427 - jason\n#          Support bl2seq parsing\n# 20031124 - jason\n#          Parse more blast statistics, lambda, entropy, etc\n#          from WU-BLAST in frame-specific manner\n# 20060216 - cjf - fixed blast parsing for BLAST v2.2.13 output\n# 20071104 - dmessina - added support for WUBLAST -echofilter\n# 20071121 - cjf - fixed several bugs (bugs 2391, 2399, 2409)\n\n=head1 NAME\n\nBio::SearchIO::blast - Event generator for event based parsing of\nblast reports\n\n=head1 SYNOPSIS\n\n   # Do not use this object directly - it is used as part of the\n   # Bio::SearchIO system.\n\n    use Bio::SearchIO;\n    my $searchio = Bio::SearchIO->new(-format => 'blast',\n                                     -file   => 't/data/ecolitst.bls');\n    while( my $result = $searchio->next_result ) {\n        while( my $hit = $result->next_hit ) {\n            while( my $hsp = $hit->next_hsp ) {\n                # ...\n            }\n        }\n    }\n\n=head1 DESCRIPTION\n\nThis object encapsulated the necessary methods for generating events\nsuitable for building Bio::Search objects from a BLAST report file.\nRead the L<Bio::SearchIO> for more information about how to use this.\n\nThis driver can parse:\n\n=over 4\n\n* * \n\nNCBI produced plain text BLAST reports from blastall, this also\nincludes PSIBLAST, PSITBLASTN, RPSBLAST, and bl2seq reports.  NCBI XML\nBLAST output is parsed with the blastxml SearchIO driver\n\n* *\n\nWU-BLAST all reports\n\n* *\n\nJim Kent's BLAST-like output from his programs (BLASTZ, BLAT)\n\n* *\n\nBLAST-like output from Paracel BTK output\n\n\n=head2 bl2seq parsing\n\nSince I cannot differentiate between BLASTX and TBLASTN since bl2seq\ndoesn't report the algorithm used - I assume it is BLASTX by default -\nyou can supply the program type with -report_type in the SearchIO\nconstructor i.e.\n\n  my $parser = Bio::SearchIO->new(-format => 'blast',\n                                 -file => 'bl2seq.tblastn.report',\n                                 -report_type => 'tblastn');\n\nThis only really affects where the frame and strand information are\nput - they will always be on the $hsp-E<gt>query instead of on the\n$hsp-E<gt>hit part of the feature pair for blastx and tblastn bl2seq\nproduced reports.  Hope that's clear...\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail Jason Stajich jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nSteve Chervitz sac-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...'\n\npackage Bio::SearchIO::blast;\n\nuse Bio::SearchIO::IteratedSearchResultEventBuilder;\nuse strict;\nuse vars qw(%MAPPING %MODEMAP\n  $DEFAULT_BLAST_WRITER_CLASS\n  $MAX_HSP_OVERLAP\n  $DEFAULT_SIGNIF\n  $DEFAULT_SCORE\n  $DEFAULTREPORTTYPE\n);\n\n\nuse base qw(Bio::SearchIO);\nuse Data::Dumper;\n\nBEGIN {\n\n    # mapping of NCBI Blast terms to Bioperl hash keys\n    %MODEMAP = (\n        'BlastOutput' => 'result',\n        'Iteration'   => 'iteration',\n        'Hit'         => 'hit',\n        'Hsp'         => 'hsp'\n    );\n\n    # This should really be done more intelligently, like with\n    # XSLT\n\n    %MAPPING = (\n        'Hsp_bit-score'   => 'HSP-bits',\n        'Hsp_score'       => 'HSP-score',\n        'Hsp_evalue'      => 'HSP-evalue',\n        'Hsp_n',          => 'HSP-n',\n        'Hsp_pvalue'      => 'HSP-pvalue',\n        'Hsp_query-from'  => 'HSP-query_start',\n        'Hsp_query-to'    => 'HSP-query_end',\n        'Hsp_hit-from'    => 'HSP-hit_start',\n        'Hsp_hit-to'      => 'HSP-hit_end',\n        'Hsp_positive'    => 'HSP-conserved',\n        'Hsp_identity'    => 'HSP-identical',\n        'Hsp_gaps'        => 'HSP-hsp_gaps',\n        'Hsp_hitgaps'     => 'HSP-hit_gaps',\n        'Hsp_querygaps'   => 'HSP-query_gaps',\n        'Hsp_qseq'        => 'HSP-query_seq',\n        'Hsp_hseq'        => 'HSP-hit_seq',\n        'Hsp_midline'     => 'HSP-homology_seq',\n        'Hsp_align-len'   => 'HSP-hsp_length',\n        'Hsp_query-frame' => 'HSP-query_frame',\n        'Hsp_hit-frame'   => 'HSP-hit_frame',\n        'Hsp_links'       => 'HSP-links',\n        'Hsp_group'       => 'HSP-hsp_group',\n        'Hsp_features'    => 'HSP-hit_features',\n\n        'Hit_id'        => 'HIT-name',\n        'Hit_len'       => 'HIT-length',\n        'Hit_accession' => 'HIT-accession',\n        'Hit_def'       => 'HIT-description',\n        'Hit_signif'    => 'HIT-significance',\n        # For NCBI blast, the description line contains bits.\n        # For WU-blast, the  description line contains score.\n        'Hit_score' => 'HIT-score',\n        'Hit_bits'  => 'HIT-bits',\n\n        'Iteration_iter-num'  => 'ITERATION-number',\n        'Iteration_converged' => 'ITERATION-converged',\n\n        'BlastOutput_program'             => 'RESULT-algorithm_name',\n        'BlastOutput_version'             => 'RESULT-algorithm_version',\n        'BlastOutput_query-def'           => 'RESULT-query_name',\n        'BlastOutput_query-len'           => 'RESULT-query_length',\n        'BlastOutput_query-acc'           => 'RESULT-query_accession',\n        'BlastOutput_query-gi'            => 'RESULT-query_gi',\n        'BlastOutput_querydesc'           => 'RESULT-query_description',\n        'BlastOutput_db'                  => 'RESULT-database_name',\n        'BlastOutput_db-len'              => 'RESULT-database_entries',\n        'BlastOutput_db-let'              => 'RESULT-database_letters',\n        'BlastOutput_inclusion-threshold' => 'RESULT-inclusion_threshold',\n\n        'Parameters_matrix'      => { 'RESULT-parameters' => 'matrix' },\n        'Parameters_expect'      => { 'RESULT-parameters' => 'expect' },\n        'Parameters_include'     => { 'RESULT-parameters' => 'include' },\n        'Parameters_sc-match'    => { 'RESULT-parameters' => 'match' },\n        'Parameters_sc-mismatch' => { 'RESULT-parameters' => 'mismatch' },\n        'Parameters_gap-open'    => { 'RESULT-parameters' => 'gapopen' },\n        'Parameters_gap-extend'  => { 'RESULT-parameters' => 'gapext' },\n        'Parameters_filter'      => { 'RESULT-parameters' => 'filter' },\n        'Parameters_allowgaps'   => { 'RESULT-parameters' => 'allowgaps' },\n        'Parameters_full_dbpath' => { 'RESULT-parameters' => 'full_dbpath' },\n        'Statistics_db-len'      => { 'RESULT-statistics' => 'dbentries' },\n        'Statistics_db-let'      => { 'RESULT-statistics' => 'dbletters' },\n        'Statistics_hsp-len'     =>\n          { 'RESULT-statistics' => 'effective_hsplength' },\n        'Statistics_query-len' => { 'RESULT-statistics' => 'querylength' },\n        'Statistics_eff-space' => { 'RESULT-statistics' => 'effectivespace' },\n        'Statistics_eff-spaceused' =>\n          { 'RESULT-statistics' => 'effectivespaceused' },\n        'Statistics_eff-dblen' =>\n          { 'RESULT-statistics' => 'effectivedblength' },\n        'Statistics_kappa'         => { 'RESULT-statistics' => 'kappa' },\n        'Statistics_lambda'        => { 'RESULT-statistics' => 'lambda' },\n        'Statistics_entropy'       => { 'RESULT-statistics' => 'entropy' },\n        'Statistics_gapped_kappa'  => { 'RESULT-statistics' => 'kappa_gapped' },\n        'Statistics_gapped_lambda' =>\n          { 'RESULT-statistics' => 'lambda_gapped' },\n        'Statistics_gapped_entropy' =>\n          { 'RESULT-statistics' => 'entropy_gapped' },\n\n        'Statistics_framewindow' =>\n          { 'RESULT-statistics' => 'frameshiftwindow' },\n        'Statistics_decay' => { 'RESULT-statistics' => 'decayconst' },\n\n        'Statistics_hit_to_db' => { 'RESULT-statistics' => 'Hits_to_DB' },\n        'Statistics_num_suc_extensions' =>\n          { 'RESULT-statistics' => 'num_successful_extensions' },\n\n        # WU-BLAST stats\n        'Statistics_DFA_states' => { 'RESULT-statistics' => 'num_dfa_states' },\n        'Statistics_DFA_size'   => { 'RESULT-statistics' => 'dfa_size' },\n        'Statistics_noprocessors' =>\n          { 'RESULT-statistics' => 'no_of_processors' },\n        'Statistics_neighbortime' =>\n          { 'RESULT-statistics' => 'neighborhood_generate_time' },\n        'Statistics_starttime' => { 'RESULT-statistics' => 'start_time' },\n        'Statistics_endtime'   => { 'RESULT-statistics' => 'end_time' },\n    );\n\n    # add WU-BLAST Frame-Based Statistics\n    for my $frame ( 0 .. 3 ) {\n        for my $strand ( '+', '-' ) {\n            for my $ind (\n                qw(length efflength E S W T X X_gapped E2\n                E2_gapped S2)\n              )\n            {\n                $MAPPING{\"Statistics_frame$strand$frame\\_$ind\"} =\n                  { 'RESULT-statistics' => \"Frame$strand$frame\\_$ind\" };\n            }\n            for my $val (qw(lambda kappa entropy )) {\n                for my $type (qw(used computed gapped)) {\n                    my $key = \"Statistics_frame$strand$frame\\_$val\\_$type\";\n                    my $val =\n                      { 'RESULT-statistics' =>\n                          \"Frame$strand$frame\\_$val\\_$type\" };\n                    $MAPPING{$key} = $val;\n                }\n            }\n        }\n    }\n\n    # add Statistics\n    for my $stats (\n        qw(T A X1 X2 X3 S1 S2 X1_bits X2_bits X3_bits\n        S1_bits S2_bits  num_extensions\n        num_successful_extensions\n        seqs_better_than_cutoff\n        posted_date\n        search_cputime total_cputime\n        search_actualtime total_actualtime\n        no_of_processors ctxfactor)\n      )\n    {\n        my $key = \"Statistics_$stats\";\n        my $val = { 'RESULT-statistics' => $stats };\n        $MAPPING{$key} = $val;\n    }\n\n    # add WU-BLAST Parameters\n    for my $param (\n        qw(span span1 span2 links warnings notes hspsepsmax\n        hspsepqmax topcomboN topcomboE postsw cpus wordmask\n        filter sort_by_pvalue sort_by_count sort_by_highscore\n        sort_by_totalscore sort_by_subjectlength noseqs gi qtype\n        qres V B Z Y M N)\n      )\n    {\n        my $key = \"Parameters_$param\";\n        my $val = { 'RESULT-parameters' => $param };\n        $MAPPING{$key} = $val;\n    }\n\n    $DEFAULT_BLAST_WRITER_CLASS = 'Bio::Search::Writer::HitTableWriter';\n    $MAX_HSP_OVERLAP   = 2;           # Used when tiling multiple HSPs.\n    $DEFAULTREPORTTYPE = 'BLASTP';    # for bl2seq\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::blast->new(%args);\n Function: Builds a new Bio::SearchIO::blast object \n Returns : Bio::SearchIO::blast\n Args    : Key-value pairs:\n           -fh/-file => filehandle/filename to BLAST file\n           -format   => 'blast'\n           -report_type => 'blastx', 'tblastn', etc -- only for bl2seq\n                           reports when you want to distinguish between\n                           tblastn and blastx reports (this only controls\n                           where the frame information is put - on the query\n                           or subject object.\n           -inclusion_threshold => e-value threshold for inclusion in the\n                                   PSI-BLAST score matrix model (blastpgp)\n           -signif      => float or scientific notation number to be used\n                           as a P- or Expect value cutoff\n           -score       => integer or scientific notation number to be used\n                           as a blast score value cutoff\n           -bits        => integer or scientific notation number to be used\n                           as a bit score value cutoff\n           -hit_filter  => reference to a function to be used for\n                           filtering hits based on arbitrary criteria.\n                           All hits of each BLAST report must satisfy \n                           this criteria to be retained. \n                           If a hit fails this test, it is ignored.\n                           This function should take a\n                           Bio::Search::Hit::BlastHit.pm object as its first\n                           argument and return true\n                           if the hit should be retained.\n                           Sample filter function:\n                              -hit_filter => sub { $hit = shift;\n                                                   $hit->gaps == 0; },\n                           (Note: -filt_func is synonymous with -hit_filter)\n           -overlap     => integer. The amount of overlap to permit between\n                           adjacent HSPs when tiling HSPs. A reasonable value is 2.\n                           Default = $Bio::SearchIO::blast::MAX_HSP_OVERLAP.\n\n            The following criteria are not yet supported:\n            (these are probably best applied within this module rather than in the \n             event handler since they would permit the parser to take some shortcuts.)\n\n           -check_all_hits => boolean. Check all hits for significance against\n                              significance criteria.  Default = false.\n                              If false, stops processing hits after the first\n                              non-significant hit or the first hit that fails\n                              the hit_filter call. This speeds parsing,\n                              taking advantage of the fact that the hits\n                              are processed in the order they appear in the report.\n           -min_query_len => integer to be used as a minimum for query sequence length.\n                             Reports with query sequences below this length will\n                             not be processed. Default = no minimum length.\n           -best        => boolean. Only process the best hit of each report;\n                           default = false.\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n\n    # Blast reports require a specialized version of the SREB due to the\n    # possibility of iterations (PSI-BLAST). Forwarding all arguments to it. An\n    # issue here is that we want to set new default object factories if none are\n    # supplied.\n\n    my $handler = Bio::SearchIO::IteratedSearchResultEventBuilder->new(@args);\n    $self->attach_EventHandler($handler);\n    \n    # 2006-04-26 move this to the attach_handler function in this module so we\n    # can really reset the handler \n    # Optimization: caching\n    # the EventHandler since it is used a lot during the parse.\n    \n    # $self->{'_handler_cache'} = $handler;\n\n    my ( $min_qlen, $check_all, $overlap, $best, $rpttype ) = $self->_rearrange(\n        [\n            qw(MIN_LENGTH CHECK_ALL_HITS\n              OVERLAP BEST\n              REPORT_TYPE)\n        ],\n        @args\n    );\n\n    defined $min_qlen  && $self->min_query_length($min_qlen);\n    defined $best      && $self->best_hit_only($best);\n    defined $check_all && $self->check_all_hits($check_all);\n    defined $rpttype   && ( $self->{'_reporttype'} = $rpttype );\n}\n\nsub attach_EventHandler {\n    my ($self,$handler) = @_;\n\n    $self->SUPER::attach_EventHandler($handler);    \n\n    # Optimization: caching the EventHandler since it is used a lot\n    # during the parse.\n\n    $self->{'_handler_cache'} = $handler;\n    return;\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    my $v      = $self->verbose;\n    my $data   = '';\n    my $flavor = '';\n    $self->{'_seentop'} = 0;     # start next report at top\n    $self->{'_seentop'} = 0;\n    my ( $reporttype, $seenquery, $reportline );  \n    my ( $seeniteration, $found_again );\n    my $incl_threshold = $self->inclusion_threshold;\n    my $bl2seq_fix;\n    $self->start_document();  # let the fun begin...\n    my (@hit_signifs);\n    my $gapped_stats = 0;    # for switching between gapped/ungapped\n                             # lambda, K, H\n    local $_ = \"\\n\";   #consistency\n    PARSER:\n    while ( defined( $_ = $self->_readline ) ) {\n        next if (/^\\s+$/);       # skip empty lines\n        next if (/CPU time:/);\n        next if (/^>\\s*$/);\n        if (\n               /^((?:\\S+?)?BLAST[NPX]?)\\s+(.+)$/i  # NCBI BLAST, PSIBLAST\n                                                   # RPSBLAST, MEGABLAST\n            || /^(P?GENEWISE|HFRAME|SWN|TSWN)\\s+(.+)/i    #Paracel BTK\n          )\n        {\n            ($reporttype, my $reportversion) = ($1, $2);\n            # need to keep track of whether this is WU-BLAST\n            if ($reportversion && $reportversion =~ m{WashU$}) {\n                $self->{'_wublast'}++;\n            }\n            $self->debug(\"blast.pm: Start of new report: $reporttype, $reportversion\\n\");\n            if ( $self->{'_seentop'} ) { \n                # This handles multi-result input streams\n                $self->_pushback($_);\n                last PARSER;\n            }\n            $self->_start_blastoutput;\n            if ($reporttype =~ /RPS-BLAST/) {\n                $reporttype .= '(BLASTP)'; # default RPS-BLAST type\n            }\n            $reportline = $_;   # to fix the fact that RPS-BLAST output is wrong\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_program',\n                    'Data' => $reporttype\n                }\n            );\n\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_version',\n                    'Data' => $reportversion\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_inclusion-threshold',\n                    'Data' => $incl_threshold\n                }\n            );\n        }\n        # added Windows workaround for bug 1985\n        elsif (/^(Searching|Results from round)/) { \n            next unless $1 =~ /Results from round/; \n            $self->debug(\"blast.pm: Possible psi blast iterations found...\\n\");\n            \n            $self->in_element('hsp')\n              && $self->end_element( { 'Name' => 'Hsp' } );\n            $self->in_element('hit')\n              && $self->end_element( { 'Name' => 'Hit' } );\n            if ( defined $seeniteration ) {\n                $self->within_element('iteration')\n                  && $self->end_element( { 'Name' => 'Iteration' } );\n                $self->start_element( { 'Name' => 'Iteration' } );\n            }\n            else {\n                $self->start_element( { 'Name' => 'Iteration' } );\n            }\n            $seeniteration = 1;\n        }\n        elsif (/^Query=\\s*(.*)$/) {\n            my $q    = $1;\n            $self->debug(\"blast.pm: Query= found...$_\\n\");\n            my $size = 0;\n            if ( defined $seenquery ) {\n                $self->_pushback($reportline) if $reportline;\n                $self->_pushback($_);\n                last PARSER;\n            }\n            else {\n                if ( !defined $reporttype ) {\n                    $self->_start_blastoutput;\n                    if ( defined $seeniteration ) {\n                        $self->in_element('iteration')\n                          && $self->end_element( { 'Name' => 'Iteration' } );\n                        $self->start_element( { 'Name' => 'Iteration' } );\n                    }\n                    else {\n                        $self->start_element( { 'Name' => 'Iteration' } );\n                    }\n                    $seeniteration = 1;\n                }\n            }\n            $seenquery = $q;\n            $_ = $self->_readline;\n            while ( defined($_) ) {\n                if (/^Database:/) {\n                    $self->_pushback($_);\n                    last;\n                }\n                # below line fixes length issue with BLAST v2.2.13; still works \n                # with BLAST v2.2.12\n                if ( /\\((\\-?[\\d,]+)\\s+letters.*\\)/ || /^Length=(\\-?[\\d,]+)/ ) {\n                    $size = $1;\n                    $size =~ s/,//g;\n                    last;\n                }\n                else {\n                    # bug 2391\n                    $q .= ($q =~ /\\w$/ && $_ =~ /^\\w/) ? \" $_\" : $_;\n                    $q =~ s/\\s+/ /g; # this catches the newline as well\n                    $q =~ s/^ | $//g;\n                }\n\n                $_ = $self->_readline;\n            }\n            chomp($q);\n            my ( $nm, $desc ) = split( /\\s+/, $q, 2 );\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_query-def',\n                    'Data' => $nm\n                }\n            ) if $nm;\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_query-len',\n                    'Data' => $size\n                }\n            );\n            defined $desc && $desc =~ s/\\s+$//;\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_querydesc',\n                    'Data' => $desc\n                }\n            );\n            my ( $gi, $acc, $version ) = $self->_get_seq_identifiers($nm);\n            $version = defined($version) && length($version) ? \".$version\" : \"\";\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_query-acc',\n                    'Data' => \"$acc$version\"\n                }\n            ) if $acc;\n        }\n\t\t# added check for WU-BLAST -echofilter option (bug 2388)\n\t\telsif (/^>Unfiltered[+-]1$/) {\n        \t# skip all of the lines of unfiltered sequence\n\t\t\twhile($_ !~ /^Database:/) {\n\t\t\t\t$self->debug(\"Bypassing features line: $_\");\n        \t\t$_ = $self->_readline;\n        \t}\n\t\t\t$self->_pushback($_);\n\t\t}\n        elsif (/Sequences producing significant alignments:/) {\n            $self->debug(\"blast.pm: Processing NCBI-BLAST descriptions\\n\");\n            $flavor = 'ncbi';\n            \n            # PSI-BLAST parsing needs to be fixed to specifically look\n            # for old vs new per iteration, as sorting based on duplication\n            # leads to bugs, see bug 1986\n            \n            # The next line is not necessarily whitespace in psiblast reports.\n            # Also note that we must look for the end of this section by testing\n            # for a line with a leading >. Blank lines occur with this section\n            # for psiblast.\n            if ( !$self->in_element('iteration') ) {\n                $self->start_element( { 'Name' => 'Iteration' } );\n            }\n            # these elements are dropped with some multiquery reports; add\n            # back here\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_db-len',\n                    'Data' => $self->{'_blsdb_length'}\n                } \n            ) if $self->{'_blsdb_length'};\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_db-let',\n                    'Data' => $self->{'_blsdb_letters'}\n                }\n            ) if $self->{'_blsdb_letters'};\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_db',\n                    'Data' => $self->{'_blsdb'}\n                }\n            ) if $self->{'_blsdb_letters'};\n            \n            # changed 8/28/2008 to exit hit table if blank line is found after an\n            # appropriate line\n            my $h_regex;\n            my $seen_block;\n          DESCLINE:\n            while ( defined( my $descline = $self->_readline() ) ) {\n                if ($descline =~ m{^\\s*$}) {\n                    last DESCLINE if $seen_block;\n                    next DESCLINE;\n                }\n                # any text match is part of block...\n                $seen_block++;\n                # GCG multiline oddness...\n                if ($descline =~ /^(\\S+)\\s+Begin:\\s\\d+\\s+End:\\s+\\d+/xms) {\n                    my ($id, $nextline) = ($1, $self->_readline);\n                    $nextline =~ s{^!}{};\n                    $descline = \"$id $nextline\";\n                }\n                # NCBI style hit table (no N)\n                if ($descline =~ /(?<!cor)          # negative lookahead\n                    (\\d*\\.?(?:[\\+\\-eE]+)?\\d+)       # number (float or scientific notation)\n                    \\s+                             # space\n                    (\\d*\\.?(?:[\\+\\-eE]+)?\\d+)       # number (float or scientific notation)\n                    \\s*$/xms) {\n                    \n                    my ( $score, $evalue ) = ($1, $2);\n                    \n                    # Some data clean-up so e-value will appear numeric to perl\n                    $evalue =~ s/^e/1e/i;\n\n                    # This to handle no-HSP case\n                    my @line = split ' ',$descline;\n                    \n                    # we want to throw away the score, evalue\n                    pop @line, pop @line;\n\n                    # and N if it is present (of course they are not\n                    # really in that order, but it doesn't matter\n                    if ($3) { pop @line }\n\n                    # add the last 2 entries s.t. we can reconstruct\n                    # a minimal Hit object at the end of the day\n                    push @hit_signifs, [ $evalue, $score, shift @line, join( ' ', @line ) ];\n                } elsif ($descline =~ /^CONVERGED/i) {\n                    $self->element(\n                        {\n                            'Name' => 'Iteration_converged',\n                            'Data' => 1\n                        }\n                    );\n                } else {\n                    $self->_pushback($descline); # Catch leading > (end of section)\n                    last DESCLINE;\n                }\n            }\n        }\n        elsif (/Sequences producing High-scoring Segment Pairs:/) {\n\n     # This block is for WU-BLAST, so we don't have to check for psi-blast stuff\n     # skip the next line\n            $self->debug(\"blast.pm: Processing WU-BLAST descriptions\\n\");\n            $_      = $self->_readline();\n            $flavor = 'wu';\n\n            if ( !$self->in_element('iteration') ) {\n                $self->start_element( { 'Name' => 'Iteration' } );\n            }\n\n            while ( defined( $_ = $self->_readline() )\n                && !/^\\s+$/ )\n            {\n                my @line = split;\n                pop @line;    # throw away first number which is for 'N'col\n\n                # add the last 2 entries to array s.t. we can reconstruct\n                # a minimal Hit object at the end of the day\n                push @hit_signifs,\n                  [ pop @line, pop @line, shift @line, join( ' ', @line ) ];\n            }\n            \n        }\n        elsif (/^Database:\\s*(.+)$/) {\n\n            $self->debug(\"blast.pm: Database: $1\\n\");\n            my $db = $1;\n            while ( defined( $_ = $self->_readline ) ) {\n                if (\n                    /^\\s+(\\-?[\\d\\,]+|\\S+)\\s+sequences\\;\n                   \\s+(\\-?[\\d,]+|\\S+)\\s+ # Deal with NCBI 2.2.8 OSX problems\n                   total\\s+letters/ox\n                  )\n                {\n                    my ( $s, $l ) = ( $1, $2 );\n                    $s =~ s/,//g;\n                    $l =~ s/,//g;\n                    $self->element(\n                        {\n                            'Name' => 'BlastOutput_db-len',\n                            'Data' => $s\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'BlastOutput_db-let',\n                            'Data' => $l\n                        }\n                    );\n                    # cache for next round in cases with multiple queries\n                    $self->{'_blsdb'} = $db;\n                    $self->{'_blsdb_length'} = $s;\n                    $self->{'_blsdb_letters'} = $l;                    \n                    last;\n                }\n                else {\n                    chomp;\n                    $db .= $_;\n                }\n            }\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_db',\n                    'Data' => $db\n                }\n            );\n        }\n        # bypasses this NCBI blast 2.2.13 extra output for now...\n\t\t# Features in/flanking this part of subject sequence:\n        elsif (/^\\sFeatures\\s\\w+\\sthis\\spart/xmso) {\n            my $featline;\n            $_ = $self->_readline;\n\t\t\twhile($_ !~ /^\\s*$/) {\n                chomp;\n                $featline .= $_;\n        \t\t$_ = $self->_readline;\n        \t}\n\t\t\t$self->_pushback($_);\n            $featline =~ s{(?:^\\s+|\\s+^)}{}g;\n            $featline =~ s{\\n}{;}g;\n            $self->{'_last_hspdata'}->{'Hsp_features'} = $featline;\n        }\n        \n        # move inside of a hit\n        elsif (/^>\\s*(\\S+)\\s*(.*)?/) {\n            chomp;\n\n            $self->debug(\"blast.pm: Hit: $1\\n\");\n            $self->in_element('hsp')\n              && $self->end_element( { 'Name' => 'Hsp' } );\n            $self->in_element('hit')\n              && $self->end_element( { 'Name' => 'Hit' } );\n\n            # special case when bl2seq reports don't have a leading\n            # Query=\n            if ( !$self->within_element('result') ) {\n                $self->_start_blastoutput;\n                $self->start_element( { 'Name' => 'Iteration' } );\n            }\n            elsif ( !$self->within_element('iteration') ) {\n                $self->start_element( { 'Name' => 'Iteration' } );\n            }\n            $self->start_element( { 'Name' => 'Hit' } );\n            my $id         = $1;\n            my $restofline = $2;\n\n            $self->debug(\"Starting a hit: $1 $2\\n\");\n            $self->element(\n                {\n                    'Name' => 'Hit_id',\n                    'Data' => $id\n                }\n            );\n            my ($gi, $acc, $version ) = $self->_get_seq_identifiers($id);\n            $self->element(\n                {\n                    'Name' => 'Hit_accession',\n                    'Data' => $acc\n                }\n            );\n            # add hit significance (from the hit table)\n            # this is where Bug 1986 went awry\n            \n            # Changed for Bug2409; hit->significance and hit->score/bits derived\n            # from HSPs, not hit table unless necessary\n            \n            HITTABLE:\n            while (my $v = shift @hit_signifs) {        \n                my $tableid = $v->[2];\n                if ($tableid !~ m{\\Q$id\\E}) {\n                    $self->debug(\"Hit table ID $tableid doesn't match current hit id $id, checking next hit table entry...\\n\");\n                    next HITTABLE;\n                } else {\n                    last HITTABLE;\n                }\n            }\n            while ( defined( $_ = $self->_readline() ) ) {\n                next if (/^\\s+$/);\n                chomp;\n                if (/Length\\s*=\\s*([\\d,]+)/) {\n                    my $l = $1;\n                    $l =~ s/\\,//g;\n                    $self->element(\n                        {\n                            'Name' => 'Hit_len',\n                            'Data' => $l\n                        }\n                    );\n                    last;\n                }\n                else {\n                    s/^\\s(?!\\s)/\\x01/; #new line to concatenate desc lines with <soh>\n                    $restofline .= $_;\n                }\n            }\n            $restofline =~ s/\\s+/ /g;\n            $self->element(\n                {\n                    'Name' => 'Hit_def',\n                    'Data' => $restofline\n                }\n            );\n        }\n        elsif (/\\s+(Plus|Minus) Strand HSPs:/i) {\n            next;\n        }\n        elsif (\n            ( $self->in_element('hit') || $self->in_element('hsp') )\n            &&    # paracel genewise BTK\n            m/Score\\s*=\\s*(\\S+)\\s*bits\\s* # Bit score\n                (?:\\((\\d+)\\))?,                 # Raw score\n\t\t\\s+Log\\-Length\\sScore\\s*=\\s*(\\d+) # Log-Length score\n                /ox\n          )\n        {\n            $self->in_element('hsp')\n              && $self->end_element( { 'Name' => 'Hsp' } );\n            $self->start_element( { 'Name' => 'Hsp' } );\n\n            $self->debug( \"Got paracel genewise HSP score=$1\\n\");\n\n            # Some data clean-up so e-value will appear numeric to perl\n            my ( $bits, $score, $evalue ) = ( $1, $2, $3 );\n            $evalue =~ s/^e/1e/i;\n            $self->element(\n                {\n                    'Name' => 'Hsp_score',\n                    'Data' => $score\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_bit-score',\n                    'Data' => $bits\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_evalue',\n                    'Data' => $evalue\n                }\n            );\n        }\n        elsif (\n            ( $self->in_element('hit') || $self->in_element('hsp') )\n            &&    # paracel hframe BTK\n            m/Score\\s*=\\s*([^,\\s]+),     # Raw score\n\t\t\\s*Expect\\s*=\\s*([^,\\s]+),  # E-value\n                \\s*P(?:\\(\\S+\\))?\\s*=\\s*([^,\\s]+) # P-value\n                /ox\n          )\n        {\n            $self->in_element('hsp')\n              && $self->end_element( { 'Name' => 'Hsp' } );\n            $self->start_element( { 'Name' => 'Hsp' } );\n\n            $self->debug( \"Got paracel hframe HSP score=$1\\n\");\n\n            # Some data clean-up so e-value will appear numeric to perl\n            my ( $score, $evalue, $pvalue ) = ( $1, $2, $3 );\n            $evalue = \"1$evalue\" if $evalue =~ /^e/;\n            $pvalue = \"1$pvalue\" if $pvalue =~ /^e/;\n\n            $self->element(\n                {\n                    'Name' => 'Hsp_score',\n                    'Data' => $score\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_evalue',\n                    'Data' => $evalue\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_pvalue',\n                    'Data' => $pvalue\n                }\n            );\n        }\n        elsif (\n            ( $self->in_element('hit') || $self->in_element('hsp') )\n            &&    # wublast\n            m/Score\\s*=\\s*(\\S+)\\s*         # Bit score\n                \\(([\\d\\.]+)\\s*bits\\),         # Raw score\n                \\s*Expect\\s*=\\s*([^,\\s]+),    # E-value\n                \\s*(?:Sum)?\\s*                # SUM\n                P(?:\\(\\d+\\))?\\s*=\\s*([^,\\s]+) # P-value\n                (?:\\s*,\\s+Group\\s*\\=\\s*(\\d+))?    # HSP Group\n                /ox\n          )\n        {         # wu-blast HSP parse\n            $self->in_element('hsp')\n              && $self->end_element( { 'Name' => 'Hsp' } );\n            $self->start_element( { 'Name' => 'Hsp' } );\n\n            # Some data clean-up so e-value will appear numeric to perl\n            my ( $score, $bits, $evalue, $pvalue, $group ) =\n              ( $1, $2, $3, $4, $5 );\n            $evalue =~ s/^e/1e/i;\n            $pvalue =~ s/^e/1e/i;\n\n            $self->element(\n                {\n                    'Name' => 'Hsp_score',\n                    'Data' => $score\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_bit-score',\n                    'Data' => $bits\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_evalue',\n                    'Data' => $evalue\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_pvalue',\n                    'Data' => $pvalue\n                }\n            );\n\n            if ( defined $group ) {\n                $self->element(\n                    {\n                        'Name' => 'Hsp_group',\n                        'Data' => $group\n                    }\n                );\n            }\n\n        }\n        elsif (\n            ( $self->in_element('hit') || $self->in_element('hsp') )\n            &&    # ncbi blast, works with 2.2.17\n            m/Score\\s*=\\s*(\\S+)\\s*bits\\s* # Bit score\n                (?:\\((\\d+)\\))?,            # Missing for BLAT pseudo-BLAST fmt \n                \\s*Expect(?:\\((\\d+\\+?)\\))?\\s*=\\s*([^,\\s]+) # E-value\n                /ox\n          )\n        {         # parse NCBI blast HSP\n            $self->in_element('hsp')\n              && $self->end_element( { 'Name' => 'Hsp' } );\n\n            # Some data clean-up so e-value will appear numeric to perl\n            my ( $bits, $score, $n, $evalue ) = ( $1, $2, $3, $4 );\n            $evalue =~ s/^e/1e/i;\n            $self->start_element( { 'Name' => 'Hsp' } );\n            $self->element(\n                {\n                    'Name' => 'Hsp_score',\n                    'Data' => $score\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_bit-score',\n                    'Data' => $bits\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_evalue',\n                    'Data' => $evalue\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_n',\n                    'Data' => $n\n                }\n            ) if defined $n;\n            $score = '' unless defined $score;    # deal with BLAT which\n                                                  # has no score only bits\n            $self->debug(\"Got NCBI HSP score=$score, evalue $evalue\\n\");\n        }\n        elsif (\n            $self->in_element('hsp')\n            && m/Identities\\s*=\\s*(\\d+)\\s*\\/\\s*(\\d+)\\s*[\\d\\%\\(\\)]+\\s*\n                (?:,\\s*Positives\\s*=\\s*(\\d+)\\/(\\d+)\\s*[\\d\\%\\(\\)]+\\s*)? # pos only valid for Protein alignments\n                (?:\\,\\s*Gaps\\s*=\\s*(\\d+)\\/(\\d+))? # Gaps\n                /oxi\n          )\n        {\n            $self->element(\n                {\n                    'Name' => 'Hsp_identity',\n                    'Data' => $1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_align-len',\n                    'Data' => $2\n                }\n            );\n            if ( defined $3 ) {\n                $self->element(\n                    {\n                        'Name' => 'Hsp_positive',\n                        'Data' => $3\n                    }\n                );\n            }\n            else {\n                $self->element(\n                    {\n                        'Name' => 'Hsp_positive',\n                        'Data' => $1\n                    }\n                );\n            }\n            if ( defined $6 ) {\n                $self->element(\n                    {\n                        'Name' => 'Hsp_gaps',\n                        'Data' => $5\n                    }\n                );\n            }\n\n            $self->{'_Query'} = { 'begin' => 0, 'end' => 0 };\n            $self->{'_Sbjct'} = { 'begin' => 0, 'end' => 0 };\n\n            if (/(Frame\\s*=\\s*.+)$/) {\n\n                # handle wu-blast Frame listing on same line\n                $self->_pushback($1);\n            }\n        }\n        elsif ( $self->in_element('hsp')\n            && /Strand\\s*=\\s*(Plus|Minus)\\s*\\/\\s*(Plus|Minus)/i )\n        {\n\n            # consume this event ( we infer strand from start/end)\n            unless ($reporttype) {\n                $self->{'_reporttype'} = $reporttype = 'BLASTN';\n                $bl2seq_fix = 1;    # special case to resubmit the algorithm\n                                    # reporttype\n            }\n            next;\n        }\n        elsif ( $self->in_element('hsp')\n            && /Links\\s*=\\s*(\\S+)/ox )\n        {\n            $self->element(\n                {\n                    'Name' => 'Hsp_links',\n                    'Data' => $1\n                }\n            );\n        }\n        elsif ( $self->in_element('hsp')\n            && /Frame\\s*=\\s*([\\+\\-][1-3])\\s*(\\/\\s*([\\+\\-][1-3]))?/ )\n        {\n\n            # this is for bl2seq only\n            unless ( defined $reporttype ) {\n                $bl2seq_fix = 1;\n                if ( $1 && $2 ) { $reporttype = 'TBLASTX' }\n                else {\n                    $reporttype = 'BLASTX';\n\n    # we can't distinguish between BLASTX and TBLASTN straight from the report }\n                }\n                $self->{'_reporttype'} = $reporttype;\n            }\n\n            my ( $queryframe, $hitframe );\n            if ( $reporttype eq 'TBLASTX' ) {\n                ( $queryframe, $hitframe ) = ( $1, $2 );\n                $hitframe =~ s/\\/\\s*//g;\n            }\n            elsif ( $reporttype eq 'TBLASTN' || $reporttype eq 'PSITBLASTN') {\n                ( $hitframe, $queryframe ) = ( $1, 0 );\n            }\n            elsif ( $reporttype eq 'BLASTX' || $reporttype eq 'RPS-BLAST(BLASTP)') {\n                ( $queryframe, $hitframe ) = ( $1, 0 );\n                # though NCBI doesn't report it, this is a special BLASTX-like\n                # RPS-BLAST; should be handled differently\n                if ($reporttype eq 'RPS-BLAST(BLASTP)') {\n                    $self->element(\n                        {\n                            'Name' => 'BlastOutput_program',\n                            'Data' => 'RPS-BLAST(BLASTX)'\n                        }\n                    );\n                }\n            }\n            $self->element(\n                {\n                    'Name' => 'Hsp_query-frame',\n                    'Data' => $queryframe\n                }\n            );\n\n            $self->element(\n                {\n                    'Name' => 'Hsp_hit-frame',\n                    'Data' => $hitframe\n                }\n            );\n        }\n        elsif (/^Parameters:/\n            || /^\\s+Database:\\s+?/\n            || /^\\s+Subset/\n            || /^\\s*Lambda/\n            || /^\\s*Histogram/\n            || ( $self->in_element('hsp') && /WARNING|NOTE/ ) )\n        {\n\n            # Note: Lambda check was necessary to parse\n            # t/data/ecoli_domains.rpsblast AND to parse bl2seq\n            $self->debug(\"blast.pm: found parameters section \\n\");\n\n            $self->in_element('hsp')\n              && $self->end_element( { 'Name' => 'Hsp' } );\n            $self->in_element('hit')\n              && $self->end_element( { 'Name' => 'Hit' } );\n\n            # This is for the case when we specify -b 0 (or B=0 for WU-BLAST)\n            # and still want to construct minimal Hit objects\n            $self->_cleanup_hits(\\@hit_signifs) if scalar(@hit_signifs);\n            $self->within_element('iteration')\n              && $self->end_element( { 'Name' => 'Iteration' } );\n\n            next if /^\\s+Subset/;\n            my $blast = (/^(\\s+Database\\:)|(\\s*Lambda)/) ? 'ncbi' : 'wublast';\n            if (/^\\s*Histogram/) {\n                $blast = 'btk';\n            }\n\n            my $last = '';\n\n            # default is that gaps are allowed\n            $self->element(\n                {\n                    'Name' => 'Parameters_allowgaps',\n                    'Data' => 'yes'\n                }\n            );\n            while ( defined( $_ = $self->_readline ) ) {\n                if (\n                    /^((?:\\S+)?BLAST[NPX]?)\\s+(.+)$/i  # NCBI BLAST, PSIBLAST\n                                                      # RPSBLAST, MEGABLAST\n                    || /^(P?GENEWISE|HFRAME|SWN|TSWN)\\s+(.+)/i    #Paracel BTK\n                  )\n                {\n                    $self->_pushback($_);\n\n                    # let's handle this in the loop\n                    last;\n                }\n                elsif (/^Query=/) {\n                    $self->_pushback($reportline) if $reportline;\n                    $self->_pushback($_);\n                    last PARSER;\n                }\n\n                # here is where difference between wublast and ncbiblast\n                # is better handled by different logic\n                if (   /Number of Sequences:\\s+([\\d\\,]+)/i\n                    || /of sequences in database:\\s+(\\-?[\\d,]+)/i )\n                {\n                    my $c = $1;\n                    $c =~ s/\\,//g;\n                    $self->element(\n                        {\n                            'Name' => 'Statistics_db-len',\n                            'Data' => $c\n                        }\n                    );\n                }\n                elsif (/letters in database:\\s+(\\-?[\\d,]+)/i) {\n                    my $s = $1;\n                    $s =~ s/,//g;\n                    $self->element(\n                        {\n                            'Name' => 'Statistics_db-let',\n                            'Data' => $s\n                        }\n                    );\n                }\n                elsif ( $blast eq 'btk' ) {\n                    next;\n                }\n                elsif ( $blast eq 'wublast' ) {\n\n                    #\t\t   warn($_);\n                    if (/E=(\\S+)/) {\n                        $self->element(\n                            {\n                                'Name' => 'Parameters_expect',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (/nogaps/) {\n                        $self->element(\n                            {\n                                'Name' => 'Parameters_allowgaps',\n                                'Data' => 'no'\n                            }\n                        );\n                    }\n                    elsif (/ctxfactor=(\\S+)/) {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_ctxfactor',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (\n/(postsw|links|span[12]?|warnings|notes|gi|noseqs|qres|qype)/\n                      )\n                    {\n                        $self->element(\n                            {\n                                'Name' => \"Parameters_$1\",\n                                'Data' => 'yes'\n                            }\n                        );\n                    }\n                    elsif (/(\\S+)=(\\S+)/) {\n                        $self->element(\n                            {\n                                'Name' => \"Parameters_$1\",\n                                'Data' => $2\n                            }\n                        );\n                    }\n                    elsif ( $last =~ /(Frame|Strand)\\s+MatID\\s+Matrix name/i ) {\n                        my $firstgapinfo = 1;\n                        my $frame        = undef;\n                        while ( defined($_) && !/^\\s+$/ ) {\n                            s/^\\s+//;\n                            s/\\s+$//;\n                            if ( $firstgapinfo\n                                && s/Q=(\\d+),R=(\\d+)\\s+//x )\n                            {\n                                $firstgapinfo = 0;\n\n                                $self->element(\n                                    {\n                                        'Name' => 'Parameters_gap-open',\n                                        'Data' => $1\n                                    }\n                                );\n                                $self->element(\n                                    {\n                                        'Name' => 'Parameters_gap-extend',\n                                        'Data' => $2\n                                    }\n                                );\n                                my @fields = split;\n\n                                for my $type (\n                                    qw(lambda_gapped\n                                    kappa_gapped\n                                    entropy_gapped)\n                                  )\n                                {\n                                    next if $type eq 'n/a';\n                                    if ( !@fields ) {\n                                        warn \"fields is empty for $type\\n\";\n                                        next;\n                                    }\n                                    $self->element(\n                                        {\n                                            'Name' =>\n                                              \"Statistics_frame$frame\\_$type\",\n                                            'Data' => shift @fields\n                                        }\n                                    );\n                                }\n                            }\n                            else {\n                                my ( $frameo, $matid, $matrix, @fields ) =\n                                  split;\n                                if ( !defined $frame ) {\n\n                                    # keep some sort of default feature I guess\n                                    # even though this is sort of wrong\n                                    $self->element(\n                                        {\n                                            'Name' => 'Parameters_matrix',\n                                            'Data' => $matrix\n                                        }\n                                    );\n                                    $self->element(\n                                        {\n                                            'Name' => 'Statistics_lambda',\n                                            'Data' => $fields[0]\n                                        }\n                                    );\n                                    $self->element(\n                                        {\n                                            'Name' => 'Statistics_kappa',\n                                            'Data' => $fields[1]\n                                        }\n                                    );\n                                    $self->element(\n                                        {\n                                            'Name' => 'Statistics_entropy',\n                                            'Data' => $fields[2]\n                                        }\n                                    );\n                                }\n                                $frame = $frameo;\n                                my $ii = 0;\n                                for my $type (\n                                    qw(lambda_used\n                                    kappa_used\n                                    entropy_used\n                                    lambda_computed\n                                    kappa_computed\n                                    entropy_computed)\n                                  )\n                                {\n                                    my $f = $fields[$ii];\n                                    next unless defined $f;    # deal with n/a\n                                    if ( $f eq 'same' ) {\n                                        $f = $fields[ $ii - 3 ];\n                                    }\n                                    $ii++;\n                                    $self->element(\n                                        {\n                                            'Name' =>\n                                              \"Statistics_frame$frame\\_$type\",\n                                            'Data' => $f\n                                        }\n                                    );\n\n                                }\n                            }\n\n                            # get the next line\n                            $_ = $self->_readline;\n                        }\n                        $last = $_;\n                    }\n                    elsif ( $last =~ /(Frame|Strand)\\s+MatID\\s+Length/i ) {\n                        my $frame = undef;\n                        while ( defined($_) && !/^\\s+/ ) {\n                            s/^\\s+//;\n                            s/\\s+$//;\n                            my @fields = split;\n                            if ( @fields <= 3 ) {\n                                for my $type (qw(X_gapped E2_gapped S2)) {\n                                    last unless @fields;\n                                    $self->element(\n                                        {\n                                            'Name' =>\n                                              \"Statistics_frame$frame\\_$type\",\n                                            'Data' => shift @fields\n                                        }\n                                    );\n                                }\n                            }\n                            else {\n\n                                for my $type (\n                                    qw(length\n                                    efflength\n                                    E S W T X E2 S2)\n                                  )\n                                {\n                                    $self->element(\n                                        {\n                                            'Name' =>\n                                              \"Statistics_frame$frame\\_$type\",\n                                            'Data' => shift @fields\n                                        }\n                                    );\n                                }\n                            }\n                            $_ = $self->_readline;\n                        }\n                        $last = $_;\n                    }\n                    elsif (/(\\S+\\s+\\S+)\\s+DFA:\\s+(\\S+)\\s+\\((.+)\\)/) {\n                        if ( $1 eq 'states in' ) {\n                            $self->element(\n                                {\n                                    'Name' => 'Statistics_DFA_states',\n                                    'Data' => \"$2 $3\"\n                                }\n                            );\n                        }\n                        elsif ( $1 eq 'size of' ) {\n                            $self->element(\n                                {\n                                    'Name' => 'Statistics_DFA_size',\n                                    'Data' => \"$2 $3\"\n                                }\n                            );\n                        }\n                    }\n                    elsif (\n                        m/^\\s+Time to generate neighborhood:\\s+\n\t\t\t    (\\S+\\s+\\S+\\s+\\S+)/x\n                      )\n                    {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_neighbortime',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (/processors\\s+used:\\s+(\\d+)/) {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_noprocessors',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (\n                        m/^\\s+(\\S+)\\s+cpu\\s+time:\\s+# cputype\n\t\t\t    (\\S+\\s+\\S+\\s+\\S+)           # cputime\n\t\t\t    \\s+Elapsed:\\s+(\\S+)/x\n                      )\n                    {\n                        my $cputype = lc($1);\n                        $self->element(\n                            {\n                                'Name' => \"Statistics_$cputype\\_cputime\",\n                                'Data' => $2\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => \"Statistics_$cputype\\_actualtime\",\n                                'Data' => $3\n                            }\n                        );\n                    }\n                    elsif (/^\\s+Start:/) {\n                        my ( $junk, $start, $stime, $end, $etime ) =\n                          split( /\\s+(Start|End)\\:\\s+/, $_ );\n                        chomp($stime);\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_starttime',\n                                'Data' => $stime\n                            }\n                        );\n                        chomp($etime);\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_endtime',\n                                'Data' => $etime\n                            }\n                        );\n                    }\n                    elsif (/^\\s+Database:\\s+(.+)$/) {\n                        $self->element(\n                            {\n                                'Name' => 'Parameters_full_dbpath',\n                                'Data' => $1\n                            }\n                        );\n\n                    }\n                    elsif (/^\\s+Posted:\\s+(.+)/) {\n                        my $d = $1;\n                        chomp($d);\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_posted_date',\n                                'Data' => $d\n                            }\n                        );\n                    }\n                }\n                elsif ( $blast eq 'ncbi' ) {\n\n                    if (m/^Matrix:\\s+(.+)\\s*$/oxi) {\n                        $self->element(\n                            {\n                                'Name' => 'Parameters_matrix',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (/^Gapped/) {\n                        $gapped_stats = 1;\n                    }\n                    elsif (/^Lambda/) {\n                        $_ = $self->_readline;\n                        s/^\\s+//;\n                        my ( $lambda, $kappa, $entropy ) = split;\n                        if ($gapped_stats) {\n                            $self->element(\n                                {\n                                    'Name' => \"Statistics_gapped_lambda\",\n                                    'Data' => $lambda\n                                }\n                            );\n                            $self->element(\n                                {\n                                    'Name' => \"Statistics_gapped_kappa\",\n                                    'Data' => $kappa\n                                }\n                            );\n                            $self->element(\n                                {\n                                    'Name' => \"Statistics_gapped_entropy\",\n                                    'Data' => $entropy\n                                }\n                            );\n                        }\n                        else {\n                            $self->element(\n                                {\n                                    'Name' => \"Statistics_lambda\",\n                                    'Data' => $lambda\n                                }\n                            );\n                            $self->element(\n                                {\n                                    'Name' => \"Statistics_kappa\",\n                                    'Data' => $kappa\n                                }\n                            );\n                            $self->element(\n                                {\n                                    'Name' => \"Statistics_entropy\",\n                                    'Data' => $entropy\n                                }\n                            );\n                        }\n                    }\n                    elsif (m/effective\\s+search\\s+space\\s+used:\\s+(\\d+)/ox) {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_eff-spaceused',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (m/effective\\s+search\\s+space:\\s+(\\d+)/ox) {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_eff-space',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (\n                        m/Gap\\s+Penalties:\\s+Existence:\\s+(\\d+)\\,\n\t\t\t    \\s+Extension:\\s+(\\d+)/ox\n                      )\n                    {\n                        $self->element(\n                            {\n                                'Name' => 'Parameters_gap-open',\n                                'Data' => $1\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Parameters_gap-extend',\n                                'Data' => $2\n                            }\n                        );\n                    }\n                    elsif (/effective\\s+HSP\\s+length:\\s+(\\d+)/) {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_hsp-len',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (/effective\\s+length\\s+of\\s+query:\\s+([\\d\\,]+)/) {\n                        my $c = $1;\n                        $c =~ s/\\,//g;\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_query-len',\n                                'Data' => $c\n                            }\n                        );\n                    }\n                    elsif (/effective\\s+length\\s+of\\s+database:\\s+([\\d\\,]+)/) {\n                        my $c = $1;\n                        $c =~ s/\\,//g;\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_eff-dblen',\n                                'Data' => $c\n                            }\n                        );\n                    }\n                    elsif (\n/^(T|A|X1|X2|X3|S1|S2):\\s+(\\d+(\\.\\d+)?)\\s+(?:\\(\\s*(\\d+\\.\\d+) bits\\))?/\n                      )\n                    {\n                        my $v = $2;\n                        chomp($v);\n                        $self->element(\n                            {\n                                'Name' => \"Statistics_$1\",\n                                'Data' => $v\n                            }\n                        );\n                        if ( defined $4 ) {\n                            $self->element(\n                                {\n                                    'Name' => \"Statistics_$1_bits\",\n                                    'Data' => $4\n                                }\n                            );\n                        }\n                    }\n                    elsif (\n                        m/frameshift\\s+window\\,\n\t\t\t    \\s+decay\\s+const:\\s+(\\d+)\\,\\s+([\\.\\d]+)/x\n                      )\n                    {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_framewindow',\n                                'Data' => $1\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_decay',\n                                'Data' => $2\n                            }\n                        );\n                    }\n                    elsif (m/^Number\\s+of\\s+Hits\\s+to\\s+DB:\\s+(\\S+)/ox) {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_hit_to_db',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (m/^Number\\s+of\\s+extensions:\\s+(\\S+)/ox) {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_num_extensions',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (\n                        m/^Number\\s+of\\s+successful\\s+extensions:\\s+\n\t\t\t    (\\S+)/ox\n                      )\n                    {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_num_suc_extensions',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (\n                        m/^Number\\s+of\\s+sequences\\s+better\\s+than\\s+\n\t\t\t    (\\S+):\\s+(\\d+)/ox\n                      )\n                    {\n                        $self->element(\n                            {\n                                'Name' => 'Parameters_expect',\n                                'Data' => $1\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_seqs_better_than_cutoff',\n                                'Data' => $2\n                            }\n                        );\n                    }\n                    elsif (/^\\s+Posted\\s+date:\\s+(.+)/) {\n                        my $d = $1;\n                        chomp($d);\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_posted_date',\n                                'Data' => $d\n                            }\n                        );\n                    }\n                    elsif ( !/^\\s+$/ ) {\n                        #$self->debug( \"unmatched stat $_\");\n                    }\n                }\n                $last = $_;\n            }\n        } elsif ( $self->in_element('hsp') ) {\n            $self->debug(\"blast.pm: Processing HSP\\n\");\n            # let's read 3 lines at a time;\n            # bl2seq hackiness... Not sure I like\n            $self->{'_reporttype'} ||= $DEFAULTREPORTTYPE;\n            my %data = (\n                'Query' => '',\n                'Mid'   => '',\n                'Hit'   => ''\n            );\n            my $len;\n            for ( my $i = 0 ; defined($_) && $i < 3 ; $i++ ) {\n                # $self->debug(\"$i: $_\") if $v;\n                if ( ( $i == 0 && /^\\s+$/) || \n\t\t     /^\\s*(?:Lambda|Minus|Plus|Score)/i )\n                {\n                    $self->_pushback($_) if defined $_;\n                    $self->end_element( { 'Name' => 'Hsp' } );\n                    last;\n                }\n                chomp;\n                if (/^((Query|Sbjct):?\\s+(\\-?\\d+)\\s*)(\\S+)\\s+(\\-?\\d+)/) {\n                    my ( $full, $type, $start, $str, $end ) =\n                      ( $1, $2, $3, $4, $5 );\n\n                    if ( $str eq '-' ) {\n                        $i = 3 if $type eq 'Sbjct';\n                    }\n                    else {\n                        $data{$type} = $str;\n                    }\n                    $len = length($full);\n                    $self->{\"\\_$type\"}->{'begin'} = $start\n                      unless $self->{\"_$type\"}->{'begin'};\n                    $self->{\"\\_$type\"}->{'end'} = $end;\n                } else {\n                    $self->throw(\"no data for midline $_\")\n                      unless ( defined $_ && defined $len );\n                    $data{'Mid'} = substr( $_, $len );\n                }\n                $_ = $self->_readline();\n            }\n            $self->characters(\n                {\n                    'Name' => 'Hsp_qseq',\n                    'Data' => $data{'Query'}\n                }\n            );\n            $self->characters(\n                {\n                    'Name' => 'Hsp_hseq',\n                    'Data' => $data{'Sbjct'}\n                }\n            );\n            $self->characters(\n                {\n                    'Name' => 'Hsp_midline',\n                    'Data' => $data{'Mid'}\n                }\n            );\n        }\n        else {\n            #$self->debug(\"blast.pm: unrecognized line $_\");\n        }\n    }\n\n    $self->debug(\"blast.pm: End of BlastOutput\\n\");\n    if ( $self->{'_seentop'} ) {\n        $self->within_element('hsp')\n          && $self->end_element( { 'Name' => 'Hsp' } );\n        $self->within_element('hit')\n          && $self->end_element( { 'Name' => 'Hit' } );\n        # cleanup extra hits\n        $self->_cleanup_hits(\\@hit_signifs) if scalar(@hit_signifs);\n        $self->within_element('iteration')\n          && $self->end_element( { 'Name' => 'Iteration' } );\n        if ($bl2seq_fix) {\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_program',\n                    'Data' => $reporttype\n                }\n            );\n        }\n        $self->end_element( { 'Name' => 'BlastOutput' } );\n    }\n    return $self->end_document();\n}\n\n# Private method for internal use only.\nsub _start_blastoutput {\n    my $self = shift;\n    $self->start_element( { 'Name' => 'BlastOutput' } );\n    $self->{'_seentop'} = 1;\n    $self->{'_result_count'}++;\n    $self->{'_handler_rc'} = undef;\n}\n\n=head2 _will_handle\n\n Title   : _will_handle\n Usage   : Private method. For internal use only.\n              if( $self->_will_handle($type) ) { ... }\n Function: Provides an optimized way to check whether or not an element of a \n           given type is to be handled.\n Returns : Reference to EventHandler object if the element type is to be handled.\n           undef if the element type is not to be handled.\n Args    : string containing type of element.\n\nOptimizations:\n\n=over 2\n\n* 1\n\nUsing the cached pointer to the EventHandler to minimize repeated\nlookups.\n\n* 2\n\nCaching the will_handle status for each type that is encountered so\nthat it only need be checked by calling\nhandler-E<gt>will_handle($type) once.\n\n\nThis does not lead to a major savings by itself (only 5-10%).  In\ncombination with other optimizations, or for large parse jobs, the\nsavings good be significant.\n\nTo test against the unoptimized version, remove the parentheses from\naround the third term in the ternary \" ? : \" operator and add two\ncalls to $self-E<gt>_eventHandler().\n\n\nsub _will_handle {\n    my ( $self, $type ) = @_;\n    my $handler     = $self->{'_handler_cache'};\n    my $will_handle =\n      defined( $self->{'_will_handle_cache'}->{$type} )\n      ? $self->{'_will_handle_cache'}->{$type}\n      : ( $self->{'_will_handle_cache'}->{$type} =\n          $handler->will_handle($type) );\n\n    return $will_handle ? $handler : undef;\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\nsub start_element {\n    my ( $self, $data ) = @_;\n\n    # we currently don't care about attributes\n    my $nm   = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    if ($type) {\n        my $handler = $self->_will_handle($type);\n        if ($handler) {\n            my $func = sprintf( \"start_%s\", lc $type );\n            $self->{'_handler_rc'} = $handler->$func( $data->{'Attributes'} );\n        }\n        #else {\n            #$self->debug( # changed 4/29/2006 to play nice with other event handlers\n            #    \"Bio::SearchIO::InternalParserError \".\n            #    \"\\nCan't handle elements of type \\'$type.\\'\"\n            #);\n        #}\n        unshift @{ $self->{'_elements'} }, $type;\n        if ( $type eq 'result' ) {\n            $self->{'_values'} = {};\n            $self->{'_result'} = undef;\n        } else {\n            # cleanup some things\n            if ( defined $self->{'_values'} ) {\n                foreach my $k (\n                    grep { /^\\U$type\\-/ }\n                    keys %{ $self->{'_values'} }\n                  )\n                {\n                    delete $self->{'_values'}->{$k};\n                }\n            }\n        }\n    }\n}\n\n=head2 end_element\n\n Title   : end_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : hashref with an element's worth of data\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ( $self, $data ) = @_;\n    \n    my $nm   = $data->{'Name'};\n    my $type;\n    my $rc;\n    if ( $nm eq 'BlastOutput_program' ) {\n        if ( $self->{'_last_data'} =~ /(t?blast[npx])/i ) {\n            $self->{'_reporttype'} = uc $1;\n        }\n        $self->{'_reporttype'} ||= $DEFAULTREPORTTYPE;\n    }\n\n    # Hsps are sort of weird, in that they end when another\n    # object begins so have to detect this in end_element for now\n    if ( $nm eq 'Hsp' ) {\n        foreach (qw(Hsp_qseq Hsp_midline Hsp_hseq Hsp_features)) {\n            $self->element(\n                {\n                    'Name' => $_,\n                    'Data' => $self->{'_last_hspdata'}->{$_}\n                }\n            ) if defined $self->{'_last_hspdata'}->{$_};\n        }\n        $self->{'_last_hspdata'} = {};\n        $self->element(\n            {\n                'Name' => 'Hsp_query-from',\n                'Data' => $self->{'_Query'}->{'begin'}\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_query-to',\n                'Data' => $self->{'_Query'}->{'end'}\n            }\n        );\n\n        $self->element(\n            {\n                'Name' => 'Hsp_hit-from',\n                'Data' => $self->{'_Sbjct'}->{'begin'}\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_hit-to',\n                'Data' => $self->{'_Sbjct'}->{'end'}\n            }\n        );\n\n        #    } elsif( $nm eq 'Iteration' ) {\n        # Nothing special needs to be done here.\n    }\n    if ( $type = $MODEMAP{$nm} ) {\n        my $handler = $self->_will_handle($type);\n        if ($handler) {\n            my $func = sprintf( \"end_%s\", lc $type );\n            $rc = $handler->$func( $self->{'_reporttype'}, $self->{'_values'} );\n        }\n        shift @{ $self->{'_elements'} };\n\n    }\n    elsif ( $MAPPING{$nm} ) {\n        if ( ref( $MAPPING{$nm} ) =~ /hash/i ) {\n\n            # this is where we shove in the data from the\n            # hashref info about params or statistics\n            my $key = ( keys %{ $MAPPING{$nm} } )[0];\n            $self->{'_values'}->{$key}->{ $MAPPING{$nm}->{$key} } =\n              $self->{'_last_data'};\n        }\n        else {\n            $self->{'_values'}->{ $MAPPING{$nm} } = $self->{'_last_data'};\n        }\n    }\n    else {\n        #$self->debug(\"blast.pm: unknown nm $nm, ignoring\\n\");\n    }\n    $self->{'_last_data'} = '';    # remove read data if we are at\n                                   # end of an element\n    $self->{'_result'} = $rc if ( defined $type && $type eq 'result' );\n    return $rc;\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convenience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element {\n    my ( $self, $data ) = @_;\n    # Note that start element isn't needed for character data\n    # Not too SAX-y, though\n    #$self->start_element($data);\n    $self->characters($data);\n    $self->end_element($data);\n}\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string\n\n\n\nsub characters {\n    my ( $self, $data ) = @_;\n    if (   $self->in_element('hsp')\n        && $data->{'Name'} =~ /^Hsp\\_(qseq|hseq|midline)$/ )\n    {\n        $self->{'_last_hspdata'}->{ $data->{'Name'} } .= $data->{'Data'}\n          if defined $data->{'Data'};\n    }\n    return unless ( defined $data->{'Data'} && $data->{'Data'} !~ /^\\s+$/ );\n    $self->{'_last_data'} = $data->{'Data'};\n}\n\n=head2 within_element\n\n Title   : within_element\n Usage   : if( $eventgenerator->within_element($element) ) {}\n Function: Test if we are within a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name \n\nSee Also: L<in_element>\n\n\nsub within_element {\n    my ( $self, $name ) = @_;\n    return 0\n      if ( !defined $name && !defined $self->{'_elements'}\n        || scalar @{ $self->{'_elements'} } == 0 );\n    foreach ( @{ $self->{'_elements'} } ) {\n        if ( $_ eq $name ) {\n            return 1;\n        }\n    }\n    return 0;\n}\n\n=head2 in_element\n\n Title   : in_element\n Usage   : if( $eventgenerator->in_element($element) ) {}\n Function: Test if we are in a particular element\n           This is different than 'within_element' because within\n           can be tested for a whole block.\n Returns : boolean\n Args    : string element name \n\nSee Also: L<within_element>","parameters":[{"label":"$self"},{"label":"$name"}],"label":"in_element($self,$name)"},"detail":"($self,$name)","kind":12,"children":[{"definition":"my","name":"$self","containerName":"in_element","localvar":"my","kind":13,"line":2144},{"containerName":"in_element","name":"$name","line":2144,"kind":13},{"kind":13,"line":2145,"name":"$self","containerName":"in_element"},{"kind":13,"line":2146,"name":"$self","containerName":"in_element"},{"containerName":"in_element","name":"$name","kind":13,"line":2146}],"line":2143,"name":"in_element","range":{"end":{"character":9999,"line":2147},"start":{"character":0,"line":2143}}},{"signature":{"label":"start_document($self)","parameters":[{"label":"$self"}],"documentation":"(Sesame Street aficionados note: This answer was NOT given by Mr. Noodle ;-P)\n# $Id: blast.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::blast\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n# 20030409 - sac\n#          PSI-BLAST full parsing support. Rollout of new\n#          model which will remove Steve's old psiblast driver\n# 20030424 - jason\n#          Megablast parsing fix as reported by Neil Saunders\n# 20030427 - jason\n#          Support bl2seq parsing\n# 20031124 - jason\n#          Parse more blast statistics, lambda, entropy, etc\n#          from WU-BLAST in frame-specific manner\n# 20060216 - cjf - fixed blast parsing for BLAST v2.2.13 output\n# 20071104 - dmessina - added support for WUBLAST -echofilter\n# 20071121 - cjf - fixed several bugs (bugs 2391, 2399, 2409)\n\n=head1 NAME\n\nBio::SearchIO::blast - Event generator for event based parsing of\nblast reports\n\n=head1 SYNOPSIS\n\n   # Do not use this object directly - it is used as part of the\n   # Bio::SearchIO system.\n\n    use Bio::SearchIO;\n    my $searchio = Bio::SearchIO->new(-format => 'blast',\n                                     -file   => 't/data/ecolitst.bls');\n    while( my $result = $searchio->next_result ) {\n        while( my $hit = $result->next_hit ) {\n            while( my $hsp = $hit->next_hsp ) {\n                # ...\n            }\n        }\n    }\n\n=head1 DESCRIPTION\n\nThis object encapsulated the necessary methods for generating events\nsuitable for building Bio::Search objects from a BLAST report file.\nRead the L<Bio::SearchIO> for more information about how to use this.\n\nThis driver can parse:\n\n=over 4\n\n* * \n\nNCBI produced plain text BLAST reports from blastall, this also\nincludes PSIBLAST, PSITBLASTN, RPSBLAST, and bl2seq reports.  NCBI XML\nBLAST output is parsed with the blastxml SearchIO driver\n\n* *\n\nWU-BLAST all reports\n\n* *\n\nJim Kent's BLAST-like output from his programs (BLASTZ, BLAT)\n\n* *\n\nBLAST-like output from Paracel BTK output\n\n\n=head2 bl2seq parsing\n\nSince I cannot differentiate between BLASTX and TBLASTN since bl2seq\ndoesn't report the algorithm used - I assume it is BLASTX by default -\nyou can supply the program type with -report_type in the SearchIO\nconstructor i.e.\n\n  my $parser = Bio::SearchIO->new(-format => 'blast',\n                                 -file => 'bl2seq.tblastn.report',\n                                 -report_type => 'tblastn');\n\nThis only really affects where the frame and strand information are\nput - they will always be on the $hsp-E<gt>query instead of on the\n$hsp-E<gt>hit part of the feature pair for blastx and tblastn bl2seq\nproduced reports.  Hope that's clear...\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail Jason Stajich jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nSteve Chervitz sac-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...'\n\npackage Bio::SearchIO::blast;\n\nuse Bio::SearchIO::IteratedSearchResultEventBuilder;\nuse strict;\nuse vars qw(%MAPPING %MODEMAP\n  $DEFAULT_BLAST_WRITER_CLASS\n  $MAX_HSP_OVERLAP\n  $DEFAULT_SIGNIF\n  $DEFAULT_SCORE\n  $DEFAULTREPORTTYPE\n);\n\n\nuse base qw(Bio::SearchIO);\nuse Data::Dumper;\n\nBEGIN {\n\n    # mapping of NCBI Blast terms to Bioperl hash keys\n    %MODEMAP = (\n        'BlastOutput' => 'result',\n        'Iteration'   => 'iteration',\n        'Hit'         => 'hit',\n        'Hsp'         => 'hsp'\n    );\n\n    # This should really be done more intelligently, like with\n    # XSLT\n\n    %MAPPING = (\n        'Hsp_bit-score'   => 'HSP-bits',\n        'Hsp_score'       => 'HSP-score',\n        'Hsp_evalue'      => 'HSP-evalue',\n        'Hsp_n',          => 'HSP-n',\n        'Hsp_pvalue'      => 'HSP-pvalue',\n        'Hsp_query-from'  => 'HSP-query_start',\n        'Hsp_query-to'    => 'HSP-query_end',\n        'Hsp_hit-from'    => 'HSP-hit_start',\n        'Hsp_hit-to'      => 'HSP-hit_end',\n        'Hsp_positive'    => 'HSP-conserved',\n        'Hsp_identity'    => 'HSP-identical',\n        'Hsp_gaps'        => 'HSP-hsp_gaps',\n        'Hsp_hitgaps'     => 'HSP-hit_gaps',\n        'Hsp_querygaps'   => 'HSP-query_gaps',\n        'Hsp_qseq'        => 'HSP-query_seq',\n        'Hsp_hseq'        => 'HSP-hit_seq',\n        'Hsp_midline'     => 'HSP-homology_seq',\n        'Hsp_align-len'   => 'HSP-hsp_length',\n        'Hsp_query-frame' => 'HSP-query_frame',\n        'Hsp_hit-frame'   => 'HSP-hit_frame',\n        'Hsp_links'       => 'HSP-links',\n        'Hsp_group'       => 'HSP-hsp_group',\n        'Hsp_features'    => 'HSP-hit_features',\n\n        'Hit_id'        => 'HIT-name',\n        'Hit_len'       => 'HIT-length',\n        'Hit_accession' => 'HIT-accession',\n        'Hit_def'       => 'HIT-description',\n        'Hit_signif'    => 'HIT-significance',\n        # For NCBI blast, the description line contains bits.\n        # For WU-blast, the  description line contains score.\n        'Hit_score' => 'HIT-score',\n        'Hit_bits'  => 'HIT-bits',\n\n        'Iteration_iter-num'  => 'ITERATION-number',\n        'Iteration_converged' => 'ITERATION-converged',\n\n        'BlastOutput_program'             => 'RESULT-algorithm_name',\n        'BlastOutput_version'             => 'RESULT-algorithm_version',\n        'BlastOutput_query-def'           => 'RESULT-query_name',\n        'BlastOutput_query-len'           => 'RESULT-query_length',\n        'BlastOutput_query-acc'           => 'RESULT-query_accession',\n        'BlastOutput_query-gi'            => 'RESULT-query_gi',\n        'BlastOutput_querydesc'           => 'RESULT-query_description',\n        'BlastOutput_db'                  => 'RESULT-database_name',\n        'BlastOutput_db-len'              => 'RESULT-database_entries',\n        'BlastOutput_db-let'              => 'RESULT-database_letters',\n        'BlastOutput_inclusion-threshold' => 'RESULT-inclusion_threshold',\n\n        'Parameters_matrix'      => { 'RESULT-parameters' => 'matrix' },\n        'Parameters_expect'      => { 'RESULT-parameters' => 'expect' },\n        'Parameters_include'     => { 'RESULT-parameters' => 'include' },\n        'Parameters_sc-match'    => { 'RESULT-parameters' => 'match' },\n        'Parameters_sc-mismatch' => { 'RESULT-parameters' => 'mismatch' },\n        'Parameters_gap-open'    => { 'RESULT-parameters' => 'gapopen' },\n        'Parameters_gap-extend'  => { 'RESULT-parameters' => 'gapext' },\n        'Parameters_filter'      => { 'RESULT-parameters' => 'filter' },\n        'Parameters_allowgaps'   => { 'RESULT-parameters' => 'allowgaps' },\n        'Parameters_full_dbpath' => { 'RESULT-parameters' => 'full_dbpath' },\n        'Statistics_db-len'      => { 'RESULT-statistics' => 'dbentries' },\n        'Statistics_db-let'      => { 'RESULT-statistics' => 'dbletters' },\n        'Statistics_hsp-len'     =>\n          { 'RESULT-statistics' => 'effective_hsplength' },\n        'Statistics_query-len' => { 'RESULT-statistics' => 'querylength' },\n        'Statistics_eff-space' => { 'RESULT-statistics' => 'effectivespace' },\n        'Statistics_eff-spaceused' =>\n          { 'RESULT-statistics' => 'effectivespaceused' },\n        'Statistics_eff-dblen' =>\n          { 'RESULT-statistics' => 'effectivedblength' },\n        'Statistics_kappa'         => { 'RESULT-statistics' => 'kappa' },\n        'Statistics_lambda'        => { 'RESULT-statistics' => 'lambda' },\n        'Statistics_entropy'       => { 'RESULT-statistics' => 'entropy' },\n        'Statistics_gapped_kappa'  => { 'RESULT-statistics' => 'kappa_gapped' },\n        'Statistics_gapped_lambda' =>\n          { 'RESULT-statistics' => 'lambda_gapped' },\n        'Statistics_gapped_entropy' =>\n          { 'RESULT-statistics' => 'entropy_gapped' },\n\n        'Statistics_framewindow' =>\n          { 'RESULT-statistics' => 'frameshiftwindow' },\n        'Statistics_decay' => { 'RESULT-statistics' => 'decayconst' },\n\n        'Statistics_hit_to_db' => { 'RESULT-statistics' => 'Hits_to_DB' },\n        'Statistics_num_suc_extensions' =>\n          { 'RESULT-statistics' => 'num_successful_extensions' },\n\n        # WU-BLAST stats\n        'Statistics_DFA_states' => { 'RESULT-statistics' => 'num_dfa_states' },\n        'Statistics_DFA_size'   => { 'RESULT-statistics' => 'dfa_size' },\n        'Statistics_noprocessors' =>\n          { 'RESULT-statistics' => 'no_of_processors' },\n        'Statistics_neighbortime' =>\n          { 'RESULT-statistics' => 'neighborhood_generate_time' },\n        'Statistics_starttime' => { 'RESULT-statistics' => 'start_time' },\n        'Statistics_endtime'   => { 'RESULT-statistics' => 'end_time' },\n    );\n\n    # add WU-BLAST Frame-Based Statistics\n    for my $frame ( 0 .. 3 ) {\n        for my $strand ( '+', '-' ) {\n            for my $ind (\n                qw(length efflength E S W T X X_gapped E2\n                E2_gapped S2)\n              )\n            {\n                $MAPPING{\"Statistics_frame$strand$frame\\_$ind\"} =\n                  { 'RESULT-statistics' => \"Frame$strand$frame\\_$ind\" };\n            }\n            for my $val (qw(lambda kappa entropy )) {\n                for my $type (qw(used computed gapped)) {\n                    my $key = \"Statistics_frame$strand$frame\\_$val\\_$type\";\n                    my $val =\n                      { 'RESULT-statistics' =>\n                          \"Frame$strand$frame\\_$val\\_$type\" };\n                    $MAPPING{$key} = $val;\n                }\n            }\n        }\n    }\n\n    # add Statistics\n    for my $stats (\n        qw(T A X1 X2 X3 S1 S2 X1_bits X2_bits X3_bits\n        S1_bits S2_bits  num_extensions\n        num_successful_extensions\n        seqs_better_than_cutoff\n        posted_date\n        search_cputime total_cputime\n        search_actualtime total_actualtime\n        no_of_processors ctxfactor)\n      )\n    {\n        my $key = \"Statistics_$stats\";\n        my $val = { 'RESULT-statistics' => $stats };\n        $MAPPING{$key} = $val;\n    }\n\n    # add WU-BLAST Parameters\n    for my $param (\n        qw(span span1 span2 links warnings notes hspsepsmax\n        hspsepqmax topcomboN topcomboE postsw cpus wordmask\n        filter sort_by_pvalue sort_by_count sort_by_highscore\n        sort_by_totalscore sort_by_subjectlength noseqs gi qtype\n        qres V B Z Y M N)\n      )\n    {\n        my $key = \"Parameters_$param\";\n        my $val = { 'RESULT-parameters' => $param };\n        $MAPPING{$key} = $val;\n    }\n\n    $DEFAULT_BLAST_WRITER_CLASS = 'Bio::Search::Writer::HitTableWriter';\n    $MAX_HSP_OVERLAP   = 2;           # Used when tiling multiple HSPs.\n    $DEFAULTREPORTTYPE = 'BLASTP';    # for bl2seq\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::blast->new(%args);\n Function: Builds a new Bio::SearchIO::blast object \n Returns : Bio::SearchIO::blast\n Args    : Key-value pairs:\n           -fh/-file => filehandle/filename to BLAST file\n           -format   => 'blast'\n           -report_type => 'blastx', 'tblastn', etc -- only for bl2seq\n                           reports when you want to distinguish between\n                           tblastn and blastx reports (this only controls\n                           where the frame information is put - on the query\n                           or subject object.\n           -inclusion_threshold => e-value threshold for inclusion in the\n                                   PSI-BLAST score matrix model (blastpgp)\n           -signif      => float or scientific notation number to be used\n                           as a P- or Expect value cutoff\n           -score       => integer or scientific notation number to be used\n                           as a blast score value cutoff\n           -bits        => integer or scientific notation number to be used\n                           as a bit score value cutoff\n           -hit_filter  => reference to a function to be used for\n                           filtering hits based on arbitrary criteria.\n                           All hits of each BLAST report must satisfy \n                           this criteria to be retained. \n                           If a hit fails this test, it is ignored.\n                           This function should take a\n                           Bio::Search::Hit::BlastHit.pm object as its first\n                           argument and return true\n                           if the hit should be retained.\n                           Sample filter function:\n                              -hit_filter => sub { $hit = shift;\n                                                   $hit->gaps == 0; },\n                           (Note: -filt_func is synonymous with -hit_filter)\n           -overlap     => integer. The amount of overlap to permit between\n                           adjacent HSPs when tiling HSPs. A reasonable value is 2.\n                           Default = $Bio::SearchIO::blast::MAX_HSP_OVERLAP.\n\n            The following criteria are not yet supported:\n            (these are probably best applied within this module rather than in the \n             event handler since they would permit the parser to take some shortcuts.)\n\n           -check_all_hits => boolean. Check all hits for significance against\n                              significance criteria.  Default = false.\n                              If false, stops processing hits after the first\n                              non-significant hit or the first hit that fails\n                              the hit_filter call. This speeds parsing,\n                              taking advantage of the fact that the hits\n                              are processed in the order they appear in the report.\n           -min_query_len => integer to be used as a minimum for query sequence length.\n                             Reports with query sequences below this length will\n                             not be processed. Default = no minimum length.\n           -best        => boolean. Only process the best hit of each report;\n                           default = false.\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n\n    # Blast reports require a specialized version of the SREB due to the\n    # possibility of iterations (PSI-BLAST). Forwarding all arguments to it. An\n    # issue here is that we want to set new default object factories if none are\n    # supplied.\n\n    my $handler = Bio::SearchIO::IteratedSearchResultEventBuilder->new(@args);\n    $self->attach_EventHandler($handler);\n    \n    # 2006-04-26 move this to the attach_handler function in this module so we\n    # can really reset the handler \n    # Optimization: caching\n    # the EventHandler since it is used a lot during the parse.\n    \n    # $self->{'_handler_cache'} = $handler;\n\n    my ( $min_qlen, $check_all, $overlap, $best, $rpttype ) = $self->_rearrange(\n        [\n            qw(MIN_LENGTH CHECK_ALL_HITS\n              OVERLAP BEST\n              REPORT_TYPE)\n        ],\n        @args\n    );\n\n    defined $min_qlen  && $self->min_query_length($min_qlen);\n    defined $best      && $self->best_hit_only($best);\n    defined $check_all && $self->check_all_hits($check_all);\n    defined $rpttype   && ( $self->{'_reporttype'} = $rpttype );\n}\n\nsub attach_EventHandler {\n    my ($self,$handler) = @_;\n\n    $self->SUPER::attach_EventHandler($handler);    \n\n    # Optimization: caching the EventHandler since it is used a lot\n    # during the parse.\n\n    $self->{'_handler_cache'} = $handler;\n    return;\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    my $v      = $self->verbose;\n    my $data   = '';\n    my $flavor = '';\n    $self->{'_seentop'} = 0;     # start next report at top\n    $self->{'_seentop'} = 0;\n    my ( $reporttype, $seenquery, $reportline );  \n    my ( $seeniteration, $found_again );\n    my $incl_threshold = $self->inclusion_threshold;\n    my $bl2seq_fix;\n    $self->start_document();  # let the fun begin...\n    my (@hit_signifs);\n    my $gapped_stats = 0;    # for switching between gapped/ungapped\n                             # lambda, K, H\n    local $_ = \"\\n\";   #consistency\n    PARSER:\n    while ( defined( $_ = $self->_readline ) ) {\n        next if (/^\\s+$/);       # skip empty lines\n        next if (/CPU time:/);\n        next if (/^>\\s*$/);\n        if (\n               /^((?:\\S+?)?BLAST[NPX]?)\\s+(.+)$/i  # NCBI BLAST, PSIBLAST\n                                                   # RPSBLAST, MEGABLAST\n            || /^(P?GENEWISE|HFRAME|SWN|TSWN)\\s+(.+)/i    #Paracel BTK\n          )\n        {\n            ($reporttype, my $reportversion) = ($1, $2);\n            # need to keep track of whether this is WU-BLAST\n            if ($reportversion && $reportversion =~ m{WashU$}) {\n                $self->{'_wublast'}++;\n            }\n            $self->debug(\"blast.pm: Start of new report: $reporttype, $reportversion\\n\");\n            if ( $self->{'_seentop'} ) { \n                # This handles multi-result input streams\n                $self->_pushback($_);\n                last PARSER;\n            }\n            $self->_start_blastoutput;\n            if ($reporttype =~ /RPS-BLAST/) {\n                $reporttype .= '(BLASTP)'; # default RPS-BLAST type\n            }\n            $reportline = $_;   # to fix the fact that RPS-BLAST output is wrong\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_program',\n                    'Data' => $reporttype\n                }\n            );\n\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_version',\n                    'Data' => $reportversion\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_inclusion-threshold',\n                    'Data' => $incl_threshold\n                }\n            );\n        }\n        # added Windows workaround for bug 1985\n        elsif (/^(Searching|Results from round)/) { \n            next unless $1 =~ /Results from round/; \n            $self->debug(\"blast.pm: Possible psi blast iterations found...\\n\");\n            \n            $self->in_element('hsp')\n              && $self->end_element( { 'Name' => 'Hsp' } );\n            $self->in_element('hit')\n              && $self->end_element( { 'Name' => 'Hit' } );\n            if ( defined $seeniteration ) {\n                $self->within_element('iteration')\n                  && $self->end_element( { 'Name' => 'Iteration' } );\n                $self->start_element( { 'Name' => 'Iteration' } );\n            }\n            else {\n                $self->start_element( { 'Name' => 'Iteration' } );\n            }\n            $seeniteration = 1;\n        }\n        elsif (/^Query=\\s*(.*)$/) {\n            my $q    = $1;\n            $self->debug(\"blast.pm: Query= found...$_\\n\");\n            my $size = 0;\n            if ( defined $seenquery ) {\n                $self->_pushback($reportline) if $reportline;\n                $self->_pushback($_);\n                last PARSER;\n            }\n            else {\n                if ( !defined $reporttype ) {\n                    $self->_start_blastoutput;\n                    if ( defined $seeniteration ) {\n                        $self->in_element('iteration')\n                          && $self->end_element( { 'Name' => 'Iteration' } );\n                        $self->start_element( { 'Name' => 'Iteration' } );\n                    }\n                    else {\n                        $self->start_element( { 'Name' => 'Iteration' } );\n                    }\n                    $seeniteration = 1;\n                }\n            }\n            $seenquery = $q;\n            $_ = $self->_readline;\n            while ( defined($_) ) {\n                if (/^Database:/) {\n                    $self->_pushback($_);\n                    last;\n                }\n                # below line fixes length issue with BLAST v2.2.13; still works \n                # with BLAST v2.2.12\n                if ( /\\((\\-?[\\d,]+)\\s+letters.*\\)/ || /^Length=(\\-?[\\d,]+)/ ) {\n                    $size = $1;\n                    $size =~ s/,//g;\n                    last;\n                }\n                else {\n                    # bug 2391\n                    $q .= ($q =~ /\\w$/ && $_ =~ /^\\w/) ? \" $_\" : $_;\n                    $q =~ s/\\s+/ /g; # this catches the newline as well\n                    $q =~ s/^ | $//g;\n                }\n\n                $_ = $self->_readline;\n            }\n            chomp($q);\n            my ( $nm, $desc ) = split( /\\s+/, $q, 2 );\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_query-def',\n                    'Data' => $nm\n                }\n            ) if $nm;\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_query-len',\n                    'Data' => $size\n                }\n            );\n            defined $desc && $desc =~ s/\\s+$//;\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_querydesc',\n                    'Data' => $desc\n                }\n            );\n            my ( $gi, $acc, $version ) = $self->_get_seq_identifiers($nm);\n            $version = defined($version) && length($version) ? \".$version\" : \"\";\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_query-acc',\n                    'Data' => \"$acc$version\"\n                }\n            ) if $acc;\n        }\n\t\t# added check for WU-BLAST -echofilter option (bug 2388)\n\t\telsif (/^>Unfiltered[+-]1$/) {\n        \t# skip all of the lines of unfiltered sequence\n\t\t\twhile($_ !~ /^Database:/) {\n\t\t\t\t$self->debug(\"Bypassing features line: $_\");\n        \t\t$_ = $self->_readline;\n        \t}\n\t\t\t$self->_pushback($_);\n\t\t}\n        elsif (/Sequences producing significant alignments:/) {\n            $self->debug(\"blast.pm: Processing NCBI-BLAST descriptions\\n\");\n            $flavor = 'ncbi';\n            \n            # PSI-BLAST parsing needs to be fixed to specifically look\n            # for old vs new per iteration, as sorting based on duplication\n            # leads to bugs, see bug 1986\n            \n            # The next line is not necessarily whitespace in psiblast reports.\n            # Also note that we must look for the end of this section by testing\n            # for a line with a leading >. Blank lines occur with this section\n            # for psiblast.\n            if ( !$self->in_element('iteration') ) {\n                $self->start_element( { 'Name' => 'Iteration' } );\n            }\n            # these elements are dropped with some multiquery reports; add\n            # back here\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_db-len',\n                    'Data' => $self->{'_blsdb_length'}\n                } \n            ) if $self->{'_blsdb_length'};\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_db-let',\n                    'Data' => $self->{'_blsdb_letters'}\n                }\n            ) if $self->{'_blsdb_letters'};\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_db',\n                    'Data' => $self->{'_blsdb'}\n                }\n            ) if $self->{'_blsdb_letters'};\n            \n            # changed 8/28/2008 to exit hit table if blank line is found after an\n            # appropriate line\n            my $h_regex;\n            my $seen_block;\n          DESCLINE:\n            while ( defined( my $descline = $self->_readline() ) ) {\n                if ($descline =~ m{^\\s*$}) {\n                    last DESCLINE if $seen_block;\n                    next DESCLINE;\n                }\n                # any text match is part of block...\n                $seen_block++;\n                # GCG multiline oddness...\n                if ($descline =~ /^(\\S+)\\s+Begin:\\s\\d+\\s+End:\\s+\\d+/xms) {\n                    my ($id, $nextline) = ($1, $self->_readline);\n                    $nextline =~ s{^!}{};\n                    $descline = \"$id $nextline\";\n                }\n                # NCBI style hit table (no N)\n                if ($descline =~ /(?<!cor)          # negative lookahead\n                    (\\d*\\.?(?:[\\+\\-eE]+)?\\d+)       # number (float or scientific notation)\n                    \\s+                             # space\n                    (\\d*\\.?(?:[\\+\\-eE]+)?\\d+)       # number (float or scientific notation)\n                    \\s*$/xms) {\n                    \n                    my ( $score, $evalue ) = ($1, $2);\n                    \n                    # Some data clean-up so e-value will appear numeric to perl\n                    $evalue =~ s/^e/1e/i;\n\n                    # This to handle no-HSP case\n                    my @line = split ' ',$descline;\n                    \n                    # we want to throw away the score, evalue\n                    pop @line, pop @line;\n\n                    # and N if it is present (of course they are not\n                    # really in that order, but it doesn't matter\n                    if ($3) { pop @line }\n\n                    # add the last 2 entries s.t. we can reconstruct\n                    # a minimal Hit object at the end of the day\n                    push @hit_signifs, [ $evalue, $score, shift @line, join( ' ', @line ) ];\n                } elsif ($descline =~ /^CONVERGED/i) {\n                    $self->element(\n                        {\n                            'Name' => 'Iteration_converged',\n                            'Data' => 1\n                        }\n                    );\n                } else {\n                    $self->_pushback($descline); # Catch leading > (end of section)\n                    last DESCLINE;\n                }\n            }\n        }\n        elsif (/Sequences producing High-scoring Segment Pairs:/) {\n\n     # This block is for WU-BLAST, so we don't have to check for psi-blast stuff\n     # skip the next line\n            $self->debug(\"blast.pm: Processing WU-BLAST descriptions\\n\");\n            $_      = $self->_readline();\n            $flavor = 'wu';\n\n            if ( !$self->in_element('iteration') ) {\n                $self->start_element( { 'Name' => 'Iteration' } );\n            }\n\n            while ( defined( $_ = $self->_readline() )\n                && !/^\\s+$/ )\n            {\n                my @line = split;\n                pop @line;    # throw away first number which is for 'N'col\n\n                # add the last 2 entries to array s.t. we can reconstruct\n                # a minimal Hit object at the end of the day\n                push @hit_signifs,\n                  [ pop @line, pop @line, shift @line, join( ' ', @line ) ];\n            }\n            \n        }\n        elsif (/^Database:\\s*(.+)$/) {\n\n            $self->debug(\"blast.pm: Database: $1\\n\");\n            my $db = $1;\n            while ( defined( $_ = $self->_readline ) ) {\n                if (\n                    /^\\s+(\\-?[\\d\\,]+|\\S+)\\s+sequences\\;\n                   \\s+(\\-?[\\d,]+|\\S+)\\s+ # Deal with NCBI 2.2.8 OSX problems\n                   total\\s+letters/ox\n                  )\n                {\n                    my ( $s, $l ) = ( $1, $2 );\n                    $s =~ s/,//g;\n                    $l =~ s/,//g;\n                    $self->element(\n                        {\n                            'Name' => 'BlastOutput_db-len',\n                            'Data' => $s\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'BlastOutput_db-let',\n                            'Data' => $l\n                        }\n                    );\n                    # cache for next round in cases with multiple queries\n                    $self->{'_blsdb'} = $db;\n                    $self->{'_blsdb_length'} = $s;\n                    $self->{'_blsdb_letters'} = $l;                    \n                    last;\n                }\n                else {\n                    chomp;\n                    $db .= $_;\n                }\n            }\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_db',\n                    'Data' => $db\n                }\n            );\n        }\n        # bypasses this NCBI blast 2.2.13 extra output for now...\n\t\t# Features in/flanking this part of subject sequence:\n        elsif (/^\\sFeatures\\s\\w+\\sthis\\spart/xmso) {\n            my $featline;\n            $_ = $self->_readline;\n\t\t\twhile($_ !~ /^\\s*$/) {\n                chomp;\n                $featline .= $_;\n        \t\t$_ = $self->_readline;\n        \t}\n\t\t\t$self->_pushback($_);\n            $featline =~ s{(?:^\\s+|\\s+^)}{}g;\n            $featline =~ s{\\n}{;}g;\n            $self->{'_last_hspdata'}->{'Hsp_features'} = $featline;\n        }\n        \n        # move inside of a hit\n        elsif (/^>\\s*(\\S+)\\s*(.*)?/) {\n            chomp;\n\n            $self->debug(\"blast.pm: Hit: $1\\n\");\n            $self->in_element('hsp')\n              && $self->end_element( { 'Name' => 'Hsp' } );\n            $self->in_element('hit')\n              && $self->end_element( { 'Name' => 'Hit' } );\n\n            # special case when bl2seq reports don't have a leading\n            # Query=\n            if ( !$self->within_element('result') ) {\n                $self->_start_blastoutput;\n                $self->start_element( { 'Name' => 'Iteration' } );\n            }\n            elsif ( !$self->within_element('iteration') ) {\n                $self->start_element( { 'Name' => 'Iteration' } );\n            }\n            $self->start_element( { 'Name' => 'Hit' } );\n            my $id         = $1;\n            my $restofline = $2;\n\n            $self->debug(\"Starting a hit: $1 $2\\n\");\n            $self->element(\n                {\n                    'Name' => 'Hit_id',\n                    'Data' => $id\n                }\n            );\n            my ($gi, $acc, $version ) = $self->_get_seq_identifiers($id);\n            $self->element(\n                {\n                    'Name' => 'Hit_accession',\n                    'Data' => $acc\n                }\n            );\n            # add hit significance (from the hit table)\n            # this is where Bug 1986 went awry\n            \n            # Changed for Bug2409; hit->significance and hit->score/bits derived\n            # from HSPs, not hit table unless necessary\n            \n            HITTABLE:\n            while (my $v = shift @hit_signifs) {        \n                my $tableid = $v->[2];\n                if ($tableid !~ m{\\Q$id\\E}) {\n                    $self->debug(\"Hit table ID $tableid doesn't match current hit id $id, checking next hit table entry...\\n\");\n                    next HITTABLE;\n                } else {\n                    last HITTABLE;\n                }\n            }\n            while ( defined( $_ = $self->_readline() ) ) {\n                next if (/^\\s+$/);\n                chomp;\n                if (/Length\\s*=\\s*([\\d,]+)/) {\n                    my $l = $1;\n                    $l =~ s/\\,//g;\n                    $self->element(\n                        {\n                            'Name' => 'Hit_len',\n                            'Data' => $l\n                        }\n                    );\n                    last;\n                }\n                else {\n                    s/^\\s(?!\\s)/\\x01/; #new line to concatenate desc lines with <soh>\n                    $restofline .= $_;\n                }\n            }\n            $restofline =~ s/\\s+/ /g;\n            $self->element(\n                {\n                    'Name' => 'Hit_def',\n                    'Data' => $restofline\n                }\n            );\n        }\n        elsif (/\\s+(Plus|Minus) Strand HSPs:/i) {\n            next;\n        }\n        elsif (\n            ( $self->in_element('hit') || $self->in_element('hsp') )\n            &&    # paracel genewise BTK\n            m/Score\\s*=\\s*(\\S+)\\s*bits\\s* # Bit score\n                (?:\\((\\d+)\\))?,                 # Raw score\n\t\t\\s+Log\\-Length\\sScore\\s*=\\s*(\\d+) # Log-Length score\n                /ox\n          )\n        {\n            $self->in_element('hsp')\n              && $self->end_element( { 'Name' => 'Hsp' } );\n            $self->start_element( { 'Name' => 'Hsp' } );\n\n            $self->debug( \"Got paracel genewise HSP score=$1\\n\");\n\n            # Some data clean-up so e-value will appear numeric to perl\n            my ( $bits, $score, $evalue ) = ( $1, $2, $3 );\n            $evalue =~ s/^e/1e/i;\n            $self->element(\n                {\n                    'Name' => 'Hsp_score',\n                    'Data' => $score\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_bit-score',\n                    'Data' => $bits\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_evalue',\n                    'Data' => $evalue\n                }\n            );\n        }\n        elsif (\n            ( $self->in_element('hit') || $self->in_element('hsp') )\n            &&    # paracel hframe BTK\n            m/Score\\s*=\\s*([^,\\s]+),     # Raw score\n\t\t\\s*Expect\\s*=\\s*([^,\\s]+),  # E-value\n                \\s*P(?:\\(\\S+\\))?\\s*=\\s*([^,\\s]+) # P-value\n                /ox\n          )\n        {\n            $self->in_element('hsp')\n              && $self->end_element( { 'Name' => 'Hsp' } );\n            $self->start_element( { 'Name' => 'Hsp' } );\n\n            $self->debug( \"Got paracel hframe HSP score=$1\\n\");\n\n            # Some data clean-up so e-value will appear numeric to perl\n            my ( $score, $evalue, $pvalue ) = ( $1, $2, $3 );\n            $evalue = \"1$evalue\" if $evalue =~ /^e/;\n            $pvalue = \"1$pvalue\" if $pvalue =~ /^e/;\n\n            $self->element(\n                {\n                    'Name' => 'Hsp_score',\n                    'Data' => $score\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_evalue',\n                    'Data' => $evalue\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_pvalue',\n                    'Data' => $pvalue\n                }\n            );\n        }\n        elsif (\n            ( $self->in_element('hit') || $self->in_element('hsp') )\n            &&    # wublast\n            m/Score\\s*=\\s*(\\S+)\\s*         # Bit score\n                \\(([\\d\\.]+)\\s*bits\\),         # Raw score\n                \\s*Expect\\s*=\\s*([^,\\s]+),    # E-value\n                \\s*(?:Sum)?\\s*                # SUM\n                P(?:\\(\\d+\\))?\\s*=\\s*([^,\\s]+) # P-value\n                (?:\\s*,\\s+Group\\s*\\=\\s*(\\d+))?    # HSP Group\n                /ox\n          )\n        {         # wu-blast HSP parse\n            $self->in_element('hsp')\n              && $self->end_element( { 'Name' => 'Hsp' } );\n            $self->start_element( { 'Name' => 'Hsp' } );\n\n            # Some data clean-up so e-value will appear numeric to perl\n            my ( $score, $bits, $evalue, $pvalue, $group ) =\n              ( $1, $2, $3, $4, $5 );\n            $evalue =~ s/^e/1e/i;\n            $pvalue =~ s/^e/1e/i;\n\n            $self->element(\n                {\n                    'Name' => 'Hsp_score',\n                    'Data' => $score\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_bit-score',\n                    'Data' => $bits\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_evalue',\n                    'Data' => $evalue\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_pvalue',\n                    'Data' => $pvalue\n                }\n            );\n\n            if ( defined $group ) {\n                $self->element(\n                    {\n                        'Name' => 'Hsp_group',\n                        'Data' => $group\n                    }\n                );\n            }\n\n        }\n        elsif (\n            ( $self->in_element('hit') || $self->in_element('hsp') )\n            &&    # ncbi blast, works with 2.2.17\n            m/Score\\s*=\\s*(\\S+)\\s*bits\\s* # Bit score\n                (?:\\((\\d+)\\))?,            # Missing for BLAT pseudo-BLAST fmt \n                \\s*Expect(?:\\((\\d+\\+?)\\))?\\s*=\\s*([^,\\s]+) # E-value\n                /ox\n          )\n        {         # parse NCBI blast HSP\n            $self->in_element('hsp')\n              && $self->end_element( { 'Name' => 'Hsp' } );\n\n            # Some data clean-up so e-value will appear numeric to perl\n            my ( $bits, $score, $n, $evalue ) = ( $1, $2, $3, $4 );\n            $evalue =~ s/^e/1e/i;\n            $self->start_element( { 'Name' => 'Hsp' } );\n            $self->element(\n                {\n                    'Name' => 'Hsp_score',\n                    'Data' => $score\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_bit-score',\n                    'Data' => $bits\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_evalue',\n                    'Data' => $evalue\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_n',\n                    'Data' => $n\n                }\n            ) if defined $n;\n            $score = '' unless defined $score;    # deal with BLAT which\n                                                  # has no score only bits\n            $self->debug(\"Got NCBI HSP score=$score, evalue $evalue\\n\");\n        }\n        elsif (\n            $self->in_element('hsp')\n            && m/Identities\\s*=\\s*(\\d+)\\s*\\/\\s*(\\d+)\\s*[\\d\\%\\(\\)]+\\s*\n                (?:,\\s*Positives\\s*=\\s*(\\d+)\\/(\\d+)\\s*[\\d\\%\\(\\)]+\\s*)? # pos only valid for Protein alignments\n                (?:\\,\\s*Gaps\\s*=\\s*(\\d+)\\/(\\d+))? # Gaps\n                /oxi\n          )\n        {\n            $self->element(\n                {\n                    'Name' => 'Hsp_identity',\n                    'Data' => $1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_align-len',\n                    'Data' => $2\n                }\n            );\n            if ( defined $3 ) {\n                $self->element(\n                    {\n                        'Name' => 'Hsp_positive',\n                        'Data' => $3\n                    }\n                );\n            }\n            else {\n                $self->element(\n                    {\n                        'Name' => 'Hsp_positive',\n                        'Data' => $1\n                    }\n                );\n            }\n            if ( defined $6 ) {\n                $self->element(\n                    {\n                        'Name' => 'Hsp_gaps',\n                        'Data' => $5\n                    }\n                );\n            }\n\n            $self->{'_Query'} = { 'begin' => 0, 'end' => 0 };\n            $self->{'_Sbjct'} = { 'begin' => 0, 'end' => 0 };\n\n            if (/(Frame\\s*=\\s*.+)$/) {\n\n                # handle wu-blast Frame listing on same line\n                $self->_pushback($1);\n            }\n        }\n        elsif ( $self->in_element('hsp')\n            && /Strand\\s*=\\s*(Plus|Minus)\\s*\\/\\s*(Plus|Minus)/i )\n        {\n\n            # consume this event ( we infer strand from start/end)\n            unless ($reporttype) {\n                $self->{'_reporttype'} = $reporttype = 'BLASTN';\n                $bl2seq_fix = 1;    # special case to resubmit the algorithm\n                                    # reporttype\n            }\n            next;\n        }\n        elsif ( $self->in_element('hsp')\n            && /Links\\s*=\\s*(\\S+)/ox )\n        {\n            $self->element(\n                {\n                    'Name' => 'Hsp_links',\n                    'Data' => $1\n                }\n            );\n        }\n        elsif ( $self->in_element('hsp')\n            && /Frame\\s*=\\s*([\\+\\-][1-3])\\s*(\\/\\s*([\\+\\-][1-3]))?/ )\n        {\n\n            # this is for bl2seq only\n            unless ( defined $reporttype ) {\n                $bl2seq_fix = 1;\n                if ( $1 && $2 ) { $reporttype = 'TBLASTX' }\n                else {\n                    $reporttype = 'BLASTX';\n\n    # we can't distinguish between BLASTX and TBLASTN straight from the report }\n                }\n                $self->{'_reporttype'} = $reporttype;\n            }\n\n            my ( $queryframe, $hitframe );\n            if ( $reporttype eq 'TBLASTX' ) {\n                ( $queryframe, $hitframe ) = ( $1, $2 );\n                $hitframe =~ s/\\/\\s*//g;\n            }\n            elsif ( $reporttype eq 'TBLASTN' || $reporttype eq 'PSITBLASTN') {\n                ( $hitframe, $queryframe ) = ( $1, 0 );\n            }\n            elsif ( $reporttype eq 'BLASTX' || $reporttype eq 'RPS-BLAST(BLASTP)') {\n                ( $queryframe, $hitframe ) = ( $1, 0 );\n                # though NCBI doesn't report it, this is a special BLASTX-like\n                # RPS-BLAST; should be handled differently\n                if ($reporttype eq 'RPS-BLAST(BLASTP)') {\n                    $self->element(\n                        {\n                            'Name' => 'BlastOutput_program',\n                            'Data' => 'RPS-BLAST(BLASTX)'\n                        }\n                    );\n                }\n            }\n            $self->element(\n                {\n                    'Name' => 'Hsp_query-frame',\n                    'Data' => $queryframe\n                }\n            );\n\n            $self->element(\n                {\n                    'Name' => 'Hsp_hit-frame',\n                    'Data' => $hitframe\n                }\n            );\n        }\n        elsif (/^Parameters:/\n            || /^\\s+Database:\\s+?/\n            || /^\\s+Subset/\n            || /^\\s*Lambda/\n            || /^\\s*Histogram/\n            || ( $self->in_element('hsp') && /WARNING|NOTE/ ) )\n        {\n\n            # Note: Lambda check was necessary to parse\n            # t/data/ecoli_domains.rpsblast AND to parse bl2seq\n            $self->debug(\"blast.pm: found parameters section \\n\");\n\n            $self->in_element('hsp')\n              && $self->end_element( { 'Name' => 'Hsp' } );\n            $self->in_element('hit')\n              && $self->end_element( { 'Name' => 'Hit' } );\n\n            # This is for the case when we specify -b 0 (or B=0 for WU-BLAST)\n            # and still want to construct minimal Hit objects\n            $self->_cleanup_hits(\\@hit_signifs) if scalar(@hit_signifs);\n            $self->within_element('iteration')\n              && $self->end_element( { 'Name' => 'Iteration' } );\n\n            next if /^\\s+Subset/;\n            my $blast = (/^(\\s+Database\\:)|(\\s*Lambda)/) ? 'ncbi' : 'wublast';\n            if (/^\\s*Histogram/) {\n                $blast = 'btk';\n            }\n\n            my $last = '';\n\n            # default is that gaps are allowed\n            $self->element(\n                {\n                    'Name' => 'Parameters_allowgaps',\n                    'Data' => 'yes'\n                }\n            );\n            while ( defined( $_ = $self->_readline ) ) {\n                if (\n                    /^((?:\\S+)?BLAST[NPX]?)\\s+(.+)$/i  # NCBI BLAST, PSIBLAST\n                                                      # RPSBLAST, MEGABLAST\n                    || /^(P?GENEWISE|HFRAME|SWN|TSWN)\\s+(.+)/i    #Paracel BTK\n                  )\n                {\n                    $self->_pushback($_);\n\n                    # let's handle this in the loop\n                    last;\n                }\n                elsif (/^Query=/) {\n                    $self->_pushback($reportline) if $reportline;\n                    $self->_pushback($_);\n                    last PARSER;\n                }\n\n                # here is where difference between wublast and ncbiblast\n                # is better handled by different logic\n                if (   /Number of Sequences:\\s+([\\d\\,]+)/i\n                    || /of sequences in database:\\s+(\\-?[\\d,]+)/i )\n                {\n                    my $c = $1;\n                    $c =~ s/\\,//g;\n                    $self->element(\n                        {\n                            'Name' => 'Statistics_db-len',\n                            'Data' => $c\n                        }\n                    );\n                }\n                elsif (/letters in database:\\s+(\\-?[\\d,]+)/i) {\n                    my $s = $1;\n                    $s =~ s/,//g;\n                    $self->element(\n                        {\n                            'Name' => 'Statistics_db-let',\n                            'Data' => $s\n                        }\n                    );\n                }\n                elsif ( $blast eq 'btk' ) {\n                    next;\n                }\n                elsif ( $blast eq 'wublast' ) {\n\n                    #\t\t   warn($_);\n                    if (/E=(\\S+)/) {\n                        $self->element(\n                            {\n                                'Name' => 'Parameters_expect',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (/nogaps/) {\n                        $self->element(\n                            {\n                                'Name' => 'Parameters_allowgaps',\n                                'Data' => 'no'\n                            }\n                        );\n                    }\n                    elsif (/ctxfactor=(\\S+)/) {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_ctxfactor',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (\n/(postsw|links|span[12]?|warnings|notes|gi|noseqs|qres|qype)/\n                      )\n                    {\n                        $self->element(\n                            {\n                                'Name' => \"Parameters_$1\",\n                                'Data' => 'yes'\n                            }\n                        );\n                    }\n                    elsif (/(\\S+)=(\\S+)/) {\n                        $self->element(\n                            {\n                                'Name' => \"Parameters_$1\",\n                                'Data' => $2\n                            }\n                        );\n                    }\n                    elsif ( $last =~ /(Frame|Strand)\\s+MatID\\s+Matrix name/i ) {\n                        my $firstgapinfo = 1;\n                        my $frame        = undef;\n                        while ( defined($_) && !/^\\s+$/ ) {\n                            s/^\\s+//;\n                            s/\\s+$//;\n                            if ( $firstgapinfo\n                                && s/Q=(\\d+),R=(\\d+)\\s+//x )\n                            {\n                                $firstgapinfo = 0;\n\n                                $self->element(\n                                    {\n                                        'Name' => 'Parameters_gap-open',\n                                        'Data' => $1\n                                    }\n                                );\n                                $self->element(\n                                    {\n                                        'Name' => 'Parameters_gap-extend',\n                                        'Data' => $2\n                                    }\n                                );\n                                my @fields = split;\n\n                                for my $type (\n                                    qw(lambda_gapped\n                                    kappa_gapped\n                                    entropy_gapped)\n                                  )\n                                {\n                                    next if $type eq 'n/a';\n                                    if ( !@fields ) {\n                                        warn \"fields is empty for $type\\n\";\n                                        next;\n                                    }\n                                    $self->element(\n                                        {\n                                            'Name' =>\n                                              \"Statistics_frame$frame\\_$type\",\n                                            'Data' => shift @fields\n                                        }\n                                    );\n                                }\n                            }\n                            else {\n                                my ( $frameo, $matid, $matrix, @fields ) =\n                                  split;\n                                if ( !defined $frame ) {\n\n                                    # keep some sort of default feature I guess\n                                    # even though this is sort of wrong\n                                    $self->element(\n                                        {\n                                            'Name' => 'Parameters_matrix',\n                                            'Data' => $matrix\n                                        }\n                                    );\n                                    $self->element(\n                                        {\n                                            'Name' => 'Statistics_lambda',\n                                            'Data' => $fields[0]\n                                        }\n                                    );\n                                    $self->element(\n                                        {\n                                            'Name' => 'Statistics_kappa',\n                                            'Data' => $fields[1]\n                                        }\n                                    );\n                                    $self->element(\n                                        {\n                                            'Name' => 'Statistics_entropy',\n                                            'Data' => $fields[2]\n                                        }\n                                    );\n                                }\n                                $frame = $frameo;\n                                my $ii = 0;\n                                for my $type (\n                                    qw(lambda_used\n                                    kappa_used\n                                    entropy_used\n                                    lambda_computed\n                                    kappa_computed\n                                    entropy_computed)\n                                  )\n                                {\n                                    my $f = $fields[$ii];\n                                    next unless defined $f;    # deal with n/a\n                                    if ( $f eq 'same' ) {\n                                        $f = $fields[ $ii - 3 ];\n                                    }\n                                    $ii++;\n                                    $self->element(\n                                        {\n                                            'Name' =>\n                                              \"Statistics_frame$frame\\_$type\",\n                                            'Data' => $f\n                                        }\n                                    );\n\n                                }\n                            }\n\n                            # get the next line\n                            $_ = $self->_readline;\n                        }\n                        $last = $_;\n                    }\n                    elsif ( $last =~ /(Frame|Strand)\\s+MatID\\s+Length/i ) {\n                        my $frame = undef;\n                        while ( defined($_) && !/^\\s+/ ) {\n                            s/^\\s+//;\n                            s/\\s+$//;\n                            my @fields = split;\n                            if ( @fields <= 3 ) {\n                                for my $type (qw(X_gapped E2_gapped S2)) {\n                                    last unless @fields;\n                                    $self->element(\n                                        {\n                                            'Name' =>\n                                              \"Statistics_frame$frame\\_$type\",\n                                            'Data' => shift @fields\n                                        }\n                                    );\n                                }\n                            }\n                            else {\n\n                                for my $type (\n                                    qw(length\n                                    efflength\n                                    E S W T X E2 S2)\n                                  )\n                                {\n                                    $self->element(\n                                        {\n                                            'Name' =>\n                                              \"Statistics_frame$frame\\_$type\",\n                                            'Data' => shift @fields\n                                        }\n                                    );\n                                }\n                            }\n                            $_ = $self->_readline;\n                        }\n                        $last = $_;\n                    }\n                    elsif (/(\\S+\\s+\\S+)\\s+DFA:\\s+(\\S+)\\s+\\((.+)\\)/) {\n                        if ( $1 eq 'states in' ) {\n                            $self->element(\n                                {\n                                    'Name' => 'Statistics_DFA_states',\n                                    'Data' => \"$2 $3\"\n                                }\n                            );\n                        }\n                        elsif ( $1 eq 'size of' ) {\n                            $self->element(\n                                {\n                                    'Name' => 'Statistics_DFA_size',\n                                    'Data' => \"$2 $3\"\n                                }\n                            );\n                        }\n                    }\n                    elsif (\n                        m/^\\s+Time to generate neighborhood:\\s+\n\t\t\t    (\\S+\\s+\\S+\\s+\\S+)/x\n                      )\n                    {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_neighbortime',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (/processors\\s+used:\\s+(\\d+)/) {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_noprocessors',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (\n                        m/^\\s+(\\S+)\\s+cpu\\s+time:\\s+# cputype\n\t\t\t    (\\S+\\s+\\S+\\s+\\S+)           # cputime\n\t\t\t    \\s+Elapsed:\\s+(\\S+)/x\n                      )\n                    {\n                        my $cputype = lc($1);\n                        $self->element(\n                            {\n                                'Name' => \"Statistics_$cputype\\_cputime\",\n                                'Data' => $2\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => \"Statistics_$cputype\\_actualtime\",\n                                'Data' => $3\n                            }\n                        );\n                    }\n                    elsif (/^\\s+Start:/) {\n                        my ( $junk, $start, $stime, $end, $etime ) =\n                          split( /\\s+(Start|End)\\:\\s+/, $_ );\n                        chomp($stime);\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_starttime',\n                                'Data' => $stime\n                            }\n                        );\n                        chomp($etime);\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_endtime',\n                                'Data' => $etime\n                            }\n                        );\n                    }\n                    elsif (/^\\s+Database:\\s+(.+)$/) {\n                        $self->element(\n                            {\n                                'Name' => 'Parameters_full_dbpath',\n                                'Data' => $1\n                            }\n                        );\n\n                    }\n                    elsif (/^\\s+Posted:\\s+(.+)/) {\n                        my $d = $1;\n                        chomp($d);\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_posted_date',\n                                'Data' => $d\n                            }\n                        );\n                    }\n                }\n                elsif ( $blast eq 'ncbi' ) {\n\n                    if (m/^Matrix:\\s+(.+)\\s*$/oxi) {\n                        $self->element(\n                            {\n                                'Name' => 'Parameters_matrix',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (/^Gapped/) {\n                        $gapped_stats = 1;\n                    }\n                    elsif (/^Lambda/) {\n                        $_ = $self->_readline;\n                        s/^\\s+//;\n                        my ( $lambda, $kappa, $entropy ) = split;\n                        if ($gapped_stats) {\n                            $self->element(\n                                {\n                                    'Name' => \"Statistics_gapped_lambda\",\n                                    'Data' => $lambda\n                                }\n                            );\n                            $self->element(\n                                {\n                                    'Name' => \"Statistics_gapped_kappa\",\n                                    'Data' => $kappa\n                                }\n                            );\n                            $self->element(\n                                {\n                                    'Name' => \"Statistics_gapped_entropy\",\n                                    'Data' => $entropy\n                                }\n                            );\n                        }\n                        else {\n                            $self->element(\n                                {\n                                    'Name' => \"Statistics_lambda\",\n                                    'Data' => $lambda\n                                }\n                            );\n                            $self->element(\n                                {\n                                    'Name' => \"Statistics_kappa\",\n                                    'Data' => $kappa\n                                }\n                            );\n                            $self->element(\n                                {\n                                    'Name' => \"Statistics_entropy\",\n                                    'Data' => $entropy\n                                }\n                            );\n                        }\n                    }\n                    elsif (m/effective\\s+search\\s+space\\s+used:\\s+(\\d+)/ox) {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_eff-spaceused',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (m/effective\\s+search\\s+space:\\s+(\\d+)/ox) {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_eff-space',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (\n                        m/Gap\\s+Penalties:\\s+Existence:\\s+(\\d+)\\,\n\t\t\t    \\s+Extension:\\s+(\\d+)/ox\n                      )\n                    {\n                        $self->element(\n                            {\n                                'Name' => 'Parameters_gap-open',\n                                'Data' => $1\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Parameters_gap-extend',\n                                'Data' => $2\n                            }\n                        );\n                    }\n                    elsif (/effective\\s+HSP\\s+length:\\s+(\\d+)/) {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_hsp-len',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (/effective\\s+length\\s+of\\s+query:\\s+([\\d\\,]+)/) {\n                        my $c = $1;\n                        $c =~ s/\\,//g;\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_query-len',\n                                'Data' => $c\n                            }\n                        );\n                    }\n                    elsif (/effective\\s+length\\s+of\\s+database:\\s+([\\d\\,]+)/) {\n                        my $c = $1;\n                        $c =~ s/\\,//g;\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_eff-dblen',\n                                'Data' => $c\n                            }\n                        );\n                    }\n                    elsif (\n/^(T|A|X1|X2|X3|S1|S2):\\s+(\\d+(\\.\\d+)?)\\s+(?:\\(\\s*(\\d+\\.\\d+) bits\\))?/\n                      )\n                    {\n                        my $v = $2;\n                        chomp($v);\n                        $self->element(\n                            {\n                                'Name' => \"Statistics_$1\",\n                                'Data' => $v\n                            }\n                        );\n                        if ( defined $4 ) {\n                            $self->element(\n                                {\n                                    'Name' => \"Statistics_$1_bits\",\n                                    'Data' => $4\n                                }\n                            );\n                        }\n                    }\n                    elsif (\n                        m/frameshift\\s+window\\,\n\t\t\t    \\s+decay\\s+const:\\s+(\\d+)\\,\\s+([\\.\\d]+)/x\n                      )\n                    {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_framewindow',\n                                'Data' => $1\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_decay',\n                                'Data' => $2\n                            }\n                        );\n                    }\n                    elsif (m/^Number\\s+of\\s+Hits\\s+to\\s+DB:\\s+(\\S+)/ox) {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_hit_to_db',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (m/^Number\\s+of\\s+extensions:\\s+(\\S+)/ox) {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_num_extensions',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (\n                        m/^Number\\s+of\\s+successful\\s+extensions:\\s+\n\t\t\t    (\\S+)/ox\n                      )\n                    {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_num_suc_extensions',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (\n                        m/^Number\\s+of\\s+sequences\\s+better\\s+than\\s+\n\t\t\t    (\\S+):\\s+(\\d+)/ox\n                      )\n                    {\n                        $self->element(\n                            {\n                                'Name' => 'Parameters_expect',\n                                'Data' => $1\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_seqs_better_than_cutoff',\n                                'Data' => $2\n                            }\n                        );\n                    }\n                    elsif (/^\\s+Posted\\s+date:\\s+(.+)/) {\n                        my $d = $1;\n                        chomp($d);\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_posted_date',\n                                'Data' => $d\n                            }\n                        );\n                    }\n                    elsif ( !/^\\s+$/ ) {\n                        #$self->debug( \"unmatched stat $_\");\n                    }\n                }\n                $last = $_;\n            }\n        } elsif ( $self->in_element('hsp') ) {\n            $self->debug(\"blast.pm: Processing HSP\\n\");\n            # let's read 3 lines at a time;\n            # bl2seq hackiness... Not sure I like\n            $self->{'_reporttype'} ||= $DEFAULTREPORTTYPE;\n            my %data = (\n                'Query' => '',\n                'Mid'   => '',\n                'Hit'   => ''\n            );\n            my $len;\n            for ( my $i = 0 ; defined($_) && $i < 3 ; $i++ ) {\n                # $self->debug(\"$i: $_\") if $v;\n                if ( ( $i == 0 && /^\\s+$/) || \n\t\t     /^\\s*(?:Lambda|Minus|Plus|Score)/i )\n                {\n                    $self->_pushback($_) if defined $_;\n                    $self->end_element( { 'Name' => 'Hsp' } );\n                    last;\n                }\n                chomp;\n                if (/^((Query|Sbjct):?\\s+(\\-?\\d+)\\s*)(\\S+)\\s+(\\-?\\d+)/) {\n                    my ( $full, $type, $start, $str, $end ) =\n                      ( $1, $2, $3, $4, $5 );\n\n                    if ( $str eq '-' ) {\n                        $i = 3 if $type eq 'Sbjct';\n                    }\n                    else {\n                        $data{$type} = $str;\n                    }\n                    $len = length($full);\n                    $self->{\"\\_$type\"}->{'begin'} = $start\n                      unless $self->{\"_$type\"}->{'begin'};\n                    $self->{\"\\_$type\"}->{'end'} = $end;\n                } else {\n                    $self->throw(\"no data for midline $_\")\n                      unless ( defined $_ && defined $len );\n                    $data{'Mid'} = substr( $_, $len );\n                }\n                $_ = $self->_readline();\n            }\n            $self->characters(\n                {\n                    'Name' => 'Hsp_qseq',\n                    'Data' => $data{'Query'}\n                }\n            );\n            $self->characters(\n                {\n                    'Name' => 'Hsp_hseq',\n                    'Data' => $data{'Sbjct'}\n                }\n            );\n            $self->characters(\n                {\n                    'Name' => 'Hsp_midline',\n                    'Data' => $data{'Mid'}\n                }\n            );\n        }\n        else {\n            #$self->debug(\"blast.pm: unrecognized line $_\");\n        }\n    }\n\n    $self->debug(\"blast.pm: End of BlastOutput\\n\");\n    if ( $self->{'_seentop'} ) {\n        $self->within_element('hsp')\n          && $self->end_element( { 'Name' => 'Hsp' } );\n        $self->within_element('hit')\n          && $self->end_element( { 'Name' => 'Hit' } );\n        # cleanup extra hits\n        $self->_cleanup_hits(\\@hit_signifs) if scalar(@hit_signifs);\n        $self->within_element('iteration')\n          && $self->end_element( { 'Name' => 'Iteration' } );\n        if ($bl2seq_fix) {\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_program',\n                    'Data' => $reporttype\n                }\n            );\n        }\n        $self->end_element( { 'Name' => 'BlastOutput' } );\n    }\n    return $self->end_document();\n}\n\n# Private method for internal use only.\nsub _start_blastoutput {\n    my $self = shift;\n    $self->start_element( { 'Name' => 'BlastOutput' } );\n    $self->{'_seentop'} = 1;\n    $self->{'_result_count'}++;\n    $self->{'_handler_rc'} = undef;\n}\n\n=head2 _will_handle\n\n Title   : _will_handle\n Usage   : Private method. For internal use only.\n              if( $self->_will_handle($type) ) { ... }\n Function: Provides an optimized way to check whether or not an element of a \n           given type is to be handled.\n Returns : Reference to EventHandler object if the element type is to be handled.\n           undef if the element type is not to be handled.\n Args    : string containing type of element.\n\nOptimizations:\n\n=over 2\n\n* 1\n\nUsing the cached pointer to the EventHandler to minimize repeated\nlookups.\n\n* 2\n\nCaching the will_handle status for each type that is encountered so\nthat it only need be checked by calling\nhandler-E<gt>will_handle($type) once.\n\n\nThis does not lead to a major savings by itself (only 5-10%).  In\ncombination with other optimizations, or for large parse jobs, the\nsavings good be significant.\n\nTo test against the unoptimized version, remove the parentheses from\naround the third term in the ternary \" ? : \" operator and add two\ncalls to $self-E<gt>_eventHandler().\n\n\nsub _will_handle {\n    my ( $self, $type ) = @_;\n    my $handler     = $self->{'_handler_cache'};\n    my $will_handle =\n      defined( $self->{'_will_handle_cache'}->{$type} )\n      ? $self->{'_will_handle_cache'}->{$type}\n      : ( $self->{'_will_handle_cache'}->{$type} =\n          $handler->will_handle($type) );\n\n    return $will_handle ? $handler : undef;\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\nsub start_element {\n    my ( $self, $data ) = @_;\n\n    # we currently don't care about attributes\n    my $nm   = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    if ($type) {\n        my $handler = $self->_will_handle($type);\n        if ($handler) {\n            my $func = sprintf( \"start_%s\", lc $type );\n            $self->{'_handler_rc'} = $handler->$func( $data->{'Attributes'} );\n        }\n        #else {\n            #$self->debug( # changed 4/29/2006 to play nice with other event handlers\n            #    \"Bio::SearchIO::InternalParserError \".\n            #    \"\\nCan't handle elements of type \\'$type.\\'\"\n            #);\n        #}\n        unshift @{ $self->{'_elements'} }, $type;\n        if ( $type eq 'result' ) {\n            $self->{'_values'} = {};\n            $self->{'_result'} = undef;\n        } else {\n            # cleanup some things\n            if ( defined $self->{'_values'} ) {\n                foreach my $k (\n                    grep { /^\\U$type\\-/ }\n                    keys %{ $self->{'_values'} }\n                  )\n                {\n                    delete $self->{'_values'}->{$k};\n                }\n            }\n        }\n    }\n}\n\n=head2 end_element\n\n Title   : end_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : hashref with an element's worth of data\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ( $self, $data ) = @_;\n    \n    my $nm   = $data->{'Name'};\n    my $type;\n    my $rc;\n    if ( $nm eq 'BlastOutput_program' ) {\n        if ( $self->{'_last_data'} =~ /(t?blast[npx])/i ) {\n            $self->{'_reporttype'} = uc $1;\n        }\n        $self->{'_reporttype'} ||= $DEFAULTREPORTTYPE;\n    }\n\n    # Hsps are sort of weird, in that they end when another\n    # object begins so have to detect this in end_element for now\n    if ( $nm eq 'Hsp' ) {\n        foreach (qw(Hsp_qseq Hsp_midline Hsp_hseq Hsp_features)) {\n            $self->element(\n                {\n                    'Name' => $_,\n                    'Data' => $self->{'_last_hspdata'}->{$_}\n                }\n            ) if defined $self->{'_last_hspdata'}->{$_};\n        }\n        $self->{'_last_hspdata'} = {};\n        $self->element(\n            {\n                'Name' => 'Hsp_query-from',\n                'Data' => $self->{'_Query'}->{'begin'}\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_query-to',\n                'Data' => $self->{'_Query'}->{'end'}\n            }\n        );\n\n        $self->element(\n            {\n                'Name' => 'Hsp_hit-from',\n                'Data' => $self->{'_Sbjct'}->{'begin'}\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_hit-to',\n                'Data' => $self->{'_Sbjct'}->{'end'}\n            }\n        );\n\n        #    } elsif( $nm eq 'Iteration' ) {\n        # Nothing special needs to be done here.\n    }\n    if ( $type = $MODEMAP{$nm} ) {\n        my $handler = $self->_will_handle($type);\n        if ($handler) {\n            my $func = sprintf( \"end_%s\", lc $type );\n            $rc = $handler->$func( $self->{'_reporttype'}, $self->{'_values'} );\n        }\n        shift @{ $self->{'_elements'} };\n\n    }\n    elsif ( $MAPPING{$nm} ) {\n        if ( ref( $MAPPING{$nm} ) =~ /hash/i ) {\n\n            # this is where we shove in the data from the\n            # hashref info about params or statistics\n            my $key = ( keys %{ $MAPPING{$nm} } )[0];\n            $self->{'_values'}->{$key}->{ $MAPPING{$nm}->{$key} } =\n              $self->{'_last_data'};\n        }\n        else {\n            $self->{'_values'}->{ $MAPPING{$nm} } = $self->{'_last_data'};\n        }\n    }\n    else {\n        #$self->debug(\"blast.pm: unknown nm $nm, ignoring\\n\");\n    }\n    $self->{'_last_data'} = '';    # remove read data if we are at\n                                   # end of an element\n    $self->{'_result'} = $rc if ( defined $type && $type eq 'result' );\n    return $rc;\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convenience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element {\n    my ( $self, $data ) = @_;\n    # Note that start element isn't needed for character data\n    # Not too SAX-y, though\n    #$self->start_element($data);\n    $self->characters($data);\n    $self->end_element($data);\n}\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string\n\n\n\nsub characters {\n    my ( $self, $data ) = @_;\n    if (   $self->in_element('hsp')\n        && $data->{'Name'} =~ /^Hsp\\_(qseq|hseq|midline)$/ )\n    {\n        $self->{'_last_hspdata'}->{ $data->{'Name'} } .= $data->{'Data'}\n          if defined $data->{'Data'};\n    }\n    return unless ( defined $data->{'Data'} && $data->{'Data'} !~ /^\\s+$/ );\n    $self->{'_last_data'} = $data->{'Data'};\n}\n\n=head2 within_element\n\n Title   : within_element\n Usage   : if( $eventgenerator->within_element($element) ) {}\n Function: Test if we are within a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name \n\nSee Also: L<in_element>\n\n\nsub within_element {\n    my ( $self, $name ) = @_;\n    return 0\n      if ( !defined $name && !defined $self->{'_elements'}\n        || scalar @{ $self->{'_elements'} } == 0 );\n    foreach ( @{ $self->{'_elements'} } ) {\n        if ( $_ eq $name ) {\n            return 1;\n        }\n    }\n    return 0;\n}\n\n=head2 in_element\n\n Title   : in_element\n Usage   : if( $eventgenerator->in_element($element) ) {}\n Function: Test if we are in a particular element\n           This is different than 'within_element' because within\n           can be tested for a whole block.\n Returns : boolean\n Args    : string element name \n\nSee Also: L<within_element>\n\n\nsub in_element {\n    my ( $self, $name ) = @_;\n    return 0 if !defined $self->{'_elements'}->[0];\n    return ( $self->{'_elements'}->[0] eq $name );\n}\n\n=head2 start_document\n\n Title   : start_document\n Usage   : $eventgenerator->start_document\n Function: Handle a start document event\n Returns : none\n Args    : none"},"detail":"($self)","definition":"sub","containerName":"main::","children":[{"line":2161,"kind":13,"localvar":"my","containerName":"start_document","definition":"my","name":"$self"},{"name":"$self","containerName":"start_document","line":2162,"kind":13},{"kind":13,"line":2163,"containerName":"start_document","name":"$self"},{"name":"$self","containerName":"start_document","line":2164,"kind":13},{"name":"$self","containerName":"start_document","kind":13,"line":2165}],"line":2160,"kind":12,"range":{"start":{"line":2160,"character":0},"end":{"line":2166,"character":9999}},"name":"start_document"},{"name":"end_document","range":{"start":{"line":2179,"character":0},"end":{"line":2184,"character":9999}},"definition":"sub","containerName":"main::","signature":{"label":"end_document($self,@args)","documentation":"(Sesame Street aficionados note: This answer was NOT given by Mr. Noodle ;-P)\n# $Id: blast.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::blast\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n# 20030409 - sac\n#          PSI-BLAST full parsing support. Rollout of new\n#          model which will remove Steve's old psiblast driver\n# 20030424 - jason\n#          Megablast parsing fix as reported by Neil Saunders\n# 20030427 - jason\n#          Support bl2seq parsing\n# 20031124 - jason\n#          Parse more blast statistics, lambda, entropy, etc\n#          from WU-BLAST in frame-specific manner\n# 20060216 - cjf - fixed blast parsing for BLAST v2.2.13 output\n# 20071104 - dmessina - added support for WUBLAST -echofilter\n# 20071121 - cjf - fixed several bugs (bugs 2391, 2399, 2409)\n\n=head1 NAME\n\nBio::SearchIO::blast - Event generator for event based parsing of\nblast reports\n\n=head1 SYNOPSIS\n\n   # Do not use this object directly - it is used as part of the\n   # Bio::SearchIO system.\n\n    use Bio::SearchIO;\n    my $searchio = Bio::SearchIO->new(-format => 'blast',\n                                     -file   => 't/data/ecolitst.bls');\n    while( my $result = $searchio->next_result ) {\n        while( my $hit = $result->next_hit ) {\n            while( my $hsp = $hit->next_hsp ) {\n                # ...\n            }\n        }\n    }\n\n=head1 DESCRIPTION\n\nThis object encapsulated the necessary methods for generating events\nsuitable for building Bio::Search objects from a BLAST report file.\nRead the L<Bio::SearchIO> for more information about how to use this.\n\nThis driver can parse:\n\n=over 4\n\n* * \n\nNCBI produced plain text BLAST reports from blastall, this also\nincludes PSIBLAST, PSITBLASTN, RPSBLAST, and bl2seq reports.  NCBI XML\nBLAST output is parsed with the blastxml SearchIO driver\n\n* *\n\nWU-BLAST all reports\n\n* *\n\nJim Kent's BLAST-like output from his programs (BLASTZ, BLAT)\n\n* *\n\nBLAST-like output from Paracel BTK output\n\n\n=head2 bl2seq parsing\n\nSince I cannot differentiate between BLASTX and TBLASTN since bl2seq\ndoesn't report the algorithm used - I assume it is BLASTX by default -\nyou can supply the program type with -report_type in the SearchIO\nconstructor i.e.\n\n  my $parser = Bio::SearchIO->new(-format => 'blast',\n                                 -file => 'bl2seq.tblastn.report',\n                                 -report_type => 'tblastn');\n\nThis only really affects where the frame and strand information are\nput - they will always be on the $hsp-E<gt>query instead of on the\n$hsp-E<gt>hit part of the feature pair for blastx and tblastn bl2seq\nproduced reports.  Hope that's clear...\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail Jason Stajich jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nSteve Chervitz sac-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...'\n\npackage Bio::SearchIO::blast;\n\nuse Bio::SearchIO::IteratedSearchResultEventBuilder;\nuse strict;\nuse vars qw(%MAPPING %MODEMAP\n  $DEFAULT_BLAST_WRITER_CLASS\n  $MAX_HSP_OVERLAP\n  $DEFAULT_SIGNIF\n  $DEFAULT_SCORE\n  $DEFAULTREPORTTYPE\n);\n\n\nuse base qw(Bio::SearchIO);\nuse Data::Dumper;\n\nBEGIN {\n\n    # mapping of NCBI Blast terms to Bioperl hash keys\n    %MODEMAP = (\n        'BlastOutput' => 'result',\n        'Iteration'   => 'iteration',\n        'Hit'         => 'hit',\n        'Hsp'         => 'hsp'\n    );\n\n    # This should really be done more intelligently, like with\n    # XSLT\n\n    %MAPPING = (\n        'Hsp_bit-score'   => 'HSP-bits',\n        'Hsp_score'       => 'HSP-score',\n        'Hsp_evalue'      => 'HSP-evalue',\n        'Hsp_n',          => 'HSP-n',\n        'Hsp_pvalue'      => 'HSP-pvalue',\n        'Hsp_query-from'  => 'HSP-query_start',\n        'Hsp_query-to'    => 'HSP-query_end',\n        'Hsp_hit-from'    => 'HSP-hit_start',\n        'Hsp_hit-to'      => 'HSP-hit_end',\n        'Hsp_positive'    => 'HSP-conserved',\n        'Hsp_identity'    => 'HSP-identical',\n        'Hsp_gaps'        => 'HSP-hsp_gaps',\n        'Hsp_hitgaps'     => 'HSP-hit_gaps',\n        'Hsp_querygaps'   => 'HSP-query_gaps',\n        'Hsp_qseq'        => 'HSP-query_seq',\n        'Hsp_hseq'        => 'HSP-hit_seq',\n        'Hsp_midline'     => 'HSP-homology_seq',\n        'Hsp_align-len'   => 'HSP-hsp_length',\n        'Hsp_query-frame' => 'HSP-query_frame',\n        'Hsp_hit-frame'   => 'HSP-hit_frame',\n        'Hsp_links'       => 'HSP-links',\n        'Hsp_group'       => 'HSP-hsp_group',\n        'Hsp_features'    => 'HSP-hit_features',\n\n        'Hit_id'        => 'HIT-name',\n        'Hit_len'       => 'HIT-length',\n        'Hit_accession' => 'HIT-accession',\n        'Hit_def'       => 'HIT-description',\n        'Hit_signif'    => 'HIT-significance',\n        # For NCBI blast, the description line contains bits.\n        # For WU-blast, the  description line contains score.\n        'Hit_score' => 'HIT-score',\n        'Hit_bits'  => 'HIT-bits',\n\n        'Iteration_iter-num'  => 'ITERATION-number',\n        'Iteration_converged' => 'ITERATION-converged',\n\n        'BlastOutput_program'             => 'RESULT-algorithm_name',\n        'BlastOutput_version'             => 'RESULT-algorithm_version',\n        'BlastOutput_query-def'           => 'RESULT-query_name',\n        'BlastOutput_query-len'           => 'RESULT-query_length',\n        'BlastOutput_query-acc'           => 'RESULT-query_accession',\n        'BlastOutput_query-gi'            => 'RESULT-query_gi',\n        'BlastOutput_querydesc'           => 'RESULT-query_description',\n        'BlastOutput_db'                  => 'RESULT-database_name',\n        'BlastOutput_db-len'              => 'RESULT-database_entries',\n        'BlastOutput_db-let'              => 'RESULT-database_letters',\n        'BlastOutput_inclusion-threshold' => 'RESULT-inclusion_threshold',\n\n        'Parameters_matrix'      => { 'RESULT-parameters' => 'matrix' },\n        'Parameters_expect'      => { 'RESULT-parameters' => 'expect' },\n        'Parameters_include'     => { 'RESULT-parameters' => 'include' },\n        'Parameters_sc-match'    => { 'RESULT-parameters' => 'match' },\n        'Parameters_sc-mismatch' => { 'RESULT-parameters' => 'mismatch' },\n        'Parameters_gap-open'    => { 'RESULT-parameters' => 'gapopen' },\n        'Parameters_gap-extend'  => { 'RESULT-parameters' => 'gapext' },\n        'Parameters_filter'      => { 'RESULT-parameters' => 'filter' },\n        'Parameters_allowgaps'   => { 'RESULT-parameters' => 'allowgaps' },\n        'Parameters_full_dbpath' => { 'RESULT-parameters' => 'full_dbpath' },\n        'Statistics_db-len'      => { 'RESULT-statistics' => 'dbentries' },\n        'Statistics_db-let'      => { 'RESULT-statistics' => 'dbletters' },\n        'Statistics_hsp-len'     =>\n          { 'RESULT-statistics' => 'effective_hsplength' },\n        'Statistics_query-len' => { 'RESULT-statistics' => 'querylength' },\n        'Statistics_eff-space' => { 'RESULT-statistics' => 'effectivespace' },\n        'Statistics_eff-spaceused' =>\n          { 'RESULT-statistics' => 'effectivespaceused' },\n        'Statistics_eff-dblen' =>\n          { 'RESULT-statistics' => 'effectivedblength' },\n        'Statistics_kappa'         => { 'RESULT-statistics' => 'kappa' },\n        'Statistics_lambda'        => { 'RESULT-statistics' => 'lambda' },\n        'Statistics_entropy'       => { 'RESULT-statistics' => 'entropy' },\n        'Statistics_gapped_kappa'  => { 'RESULT-statistics' => 'kappa_gapped' },\n        'Statistics_gapped_lambda' =>\n          { 'RESULT-statistics' => 'lambda_gapped' },\n        'Statistics_gapped_entropy' =>\n          { 'RESULT-statistics' => 'entropy_gapped' },\n\n        'Statistics_framewindow' =>\n          { 'RESULT-statistics' => 'frameshiftwindow' },\n        'Statistics_decay' => { 'RESULT-statistics' => 'decayconst' },\n\n        'Statistics_hit_to_db' => { 'RESULT-statistics' => 'Hits_to_DB' },\n        'Statistics_num_suc_extensions' =>\n          { 'RESULT-statistics' => 'num_successful_extensions' },\n\n        # WU-BLAST stats\n        'Statistics_DFA_states' => { 'RESULT-statistics' => 'num_dfa_states' },\n        'Statistics_DFA_size'   => { 'RESULT-statistics' => 'dfa_size' },\n        'Statistics_noprocessors' =>\n          { 'RESULT-statistics' => 'no_of_processors' },\n        'Statistics_neighbortime' =>\n          { 'RESULT-statistics' => 'neighborhood_generate_time' },\n        'Statistics_starttime' => { 'RESULT-statistics' => 'start_time' },\n        'Statistics_endtime'   => { 'RESULT-statistics' => 'end_time' },\n    );\n\n    # add WU-BLAST Frame-Based Statistics\n    for my $frame ( 0 .. 3 ) {\n        for my $strand ( '+', '-' ) {\n            for my $ind (\n                qw(length efflength E S W T X X_gapped E2\n                E2_gapped S2)\n              )\n            {\n                $MAPPING{\"Statistics_frame$strand$frame\\_$ind\"} =\n                  { 'RESULT-statistics' => \"Frame$strand$frame\\_$ind\" };\n            }\n            for my $val (qw(lambda kappa entropy )) {\n                for my $type (qw(used computed gapped)) {\n                    my $key = \"Statistics_frame$strand$frame\\_$val\\_$type\";\n                    my $val =\n                      { 'RESULT-statistics' =>\n                          \"Frame$strand$frame\\_$val\\_$type\" };\n                    $MAPPING{$key} = $val;\n                }\n            }\n        }\n    }\n\n    # add Statistics\n    for my $stats (\n        qw(T A X1 X2 X3 S1 S2 X1_bits X2_bits X3_bits\n        S1_bits S2_bits  num_extensions\n        num_successful_extensions\n        seqs_better_than_cutoff\n        posted_date\n        search_cputime total_cputime\n        search_actualtime total_actualtime\n        no_of_processors ctxfactor)\n      )\n    {\n        my $key = \"Statistics_$stats\";\n        my $val = { 'RESULT-statistics' => $stats };\n        $MAPPING{$key} = $val;\n    }\n\n    # add WU-BLAST Parameters\n    for my $param (\n        qw(span span1 span2 links warnings notes hspsepsmax\n        hspsepqmax topcomboN topcomboE postsw cpus wordmask\n        filter sort_by_pvalue sort_by_count sort_by_highscore\n        sort_by_totalscore sort_by_subjectlength noseqs gi qtype\n        qres V B Z Y M N)\n      )\n    {\n        my $key = \"Parameters_$param\";\n        my $val = { 'RESULT-parameters' => $param };\n        $MAPPING{$key} = $val;\n    }\n\n    $DEFAULT_BLAST_WRITER_CLASS = 'Bio::Search::Writer::HitTableWriter';\n    $MAX_HSP_OVERLAP   = 2;           # Used when tiling multiple HSPs.\n    $DEFAULTREPORTTYPE = 'BLASTP';    # for bl2seq\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::blast->new(%args);\n Function: Builds a new Bio::SearchIO::blast object \n Returns : Bio::SearchIO::blast\n Args    : Key-value pairs:\n           -fh/-file => filehandle/filename to BLAST file\n           -format   => 'blast'\n           -report_type => 'blastx', 'tblastn', etc -- only for bl2seq\n                           reports when you want to distinguish between\n                           tblastn and blastx reports (this only controls\n                           where the frame information is put - on the query\n                           or subject object.\n           -inclusion_threshold => e-value threshold for inclusion in the\n                                   PSI-BLAST score matrix model (blastpgp)\n           -signif      => float or scientific notation number to be used\n                           as a P- or Expect value cutoff\n           -score       => integer or scientific notation number to be used\n                           as a blast score value cutoff\n           -bits        => integer or scientific notation number to be used\n                           as a bit score value cutoff\n           -hit_filter  => reference to a function to be used for\n                           filtering hits based on arbitrary criteria.\n                           All hits of each BLAST report must satisfy \n                           this criteria to be retained. \n                           If a hit fails this test, it is ignored.\n                           This function should take a\n                           Bio::Search::Hit::BlastHit.pm object as its first\n                           argument and return true\n                           if the hit should be retained.\n                           Sample filter function:\n                              -hit_filter => sub { $hit = shift;\n                                                   $hit->gaps == 0; },\n                           (Note: -filt_func is synonymous with -hit_filter)\n           -overlap     => integer. The amount of overlap to permit between\n                           adjacent HSPs when tiling HSPs. A reasonable value is 2.\n                           Default = $Bio::SearchIO::blast::MAX_HSP_OVERLAP.\n\n            The following criteria are not yet supported:\n            (these are probably best applied within this module rather than in the \n             event handler since they would permit the parser to take some shortcuts.)\n\n           -check_all_hits => boolean. Check all hits for significance against\n                              significance criteria.  Default = false.\n                              If false, stops processing hits after the first\n                              non-significant hit or the first hit that fails\n                              the hit_filter call. This speeds parsing,\n                              taking advantage of the fact that the hits\n                              are processed in the order they appear in the report.\n           -min_query_len => integer to be used as a minimum for query sequence length.\n                             Reports with query sequences below this length will\n                             not be processed. Default = no minimum length.\n           -best        => boolean. Only process the best hit of each report;\n                           default = false.\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n\n    # Blast reports require a specialized version of the SREB due to the\n    # possibility of iterations (PSI-BLAST). Forwarding all arguments to it. An\n    # issue here is that we want to set new default object factories if none are\n    # supplied.\n\n    my $handler = Bio::SearchIO::IteratedSearchResultEventBuilder->new(@args);\n    $self->attach_EventHandler($handler);\n    \n    # 2006-04-26 move this to the attach_handler function in this module so we\n    # can really reset the handler \n    # Optimization: caching\n    # the EventHandler since it is used a lot during the parse.\n    \n    # $self->{'_handler_cache'} = $handler;\n\n    my ( $min_qlen, $check_all, $overlap, $best, $rpttype ) = $self->_rearrange(\n        [\n            qw(MIN_LENGTH CHECK_ALL_HITS\n              OVERLAP BEST\n              REPORT_TYPE)\n        ],\n        @args\n    );\n\n    defined $min_qlen  && $self->min_query_length($min_qlen);\n    defined $best      && $self->best_hit_only($best);\n    defined $check_all && $self->check_all_hits($check_all);\n    defined $rpttype   && ( $self->{'_reporttype'} = $rpttype );\n}\n\nsub attach_EventHandler {\n    my ($self,$handler) = @_;\n\n    $self->SUPER::attach_EventHandler($handler);    \n\n    # Optimization: caching the EventHandler since it is used a lot\n    # during the parse.\n\n    $self->{'_handler_cache'} = $handler;\n    return;\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    my $v      = $self->verbose;\n    my $data   = '';\n    my $flavor = '';\n    $self->{'_seentop'} = 0;     # start next report at top\n    $self->{'_seentop'} = 0;\n    my ( $reporttype, $seenquery, $reportline );  \n    my ( $seeniteration, $found_again );\n    my $incl_threshold = $self->inclusion_threshold;\n    my $bl2seq_fix;\n    $self->start_document();  # let the fun begin...\n    my (@hit_signifs);\n    my $gapped_stats = 0;    # for switching between gapped/ungapped\n                             # lambda, K, H\n    local $_ = \"\\n\";   #consistency\n    PARSER:\n    while ( defined( $_ = $self->_readline ) ) {\n        next if (/^\\s+$/);       # skip empty lines\n        next if (/CPU time:/);\n        next if (/^>\\s*$/);\n        if (\n               /^((?:\\S+?)?BLAST[NPX]?)\\s+(.+)$/i  # NCBI BLAST, PSIBLAST\n                                                   # RPSBLAST, MEGABLAST\n            || /^(P?GENEWISE|HFRAME|SWN|TSWN)\\s+(.+)/i    #Paracel BTK\n          )\n        {\n            ($reporttype, my $reportversion) = ($1, $2);\n            # need to keep track of whether this is WU-BLAST\n            if ($reportversion && $reportversion =~ m{WashU$}) {\n                $self->{'_wublast'}++;\n            }\n            $self->debug(\"blast.pm: Start of new report: $reporttype, $reportversion\\n\");\n            if ( $self->{'_seentop'} ) { \n                # This handles multi-result input streams\n                $self->_pushback($_);\n                last PARSER;\n            }\n            $self->_start_blastoutput;\n            if ($reporttype =~ /RPS-BLAST/) {\n                $reporttype .= '(BLASTP)'; # default RPS-BLAST type\n            }\n            $reportline = $_;   # to fix the fact that RPS-BLAST output is wrong\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_program',\n                    'Data' => $reporttype\n                }\n            );\n\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_version',\n                    'Data' => $reportversion\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_inclusion-threshold',\n                    'Data' => $incl_threshold\n                }\n            );\n        }\n        # added Windows workaround for bug 1985\n        elsif (/^(Searching|Results from round)/) { \n            next unless $1 =~ /Results from round/; \n            $self->debug(\"blast.pm: Possible psi blast iterations found...\\n\");\n            \n            $self->in_element('hsp')\n              && $self->end_element( { 'Name' => 'Hsp' } );\n            $self->in_element('hit')\n              && $self->end_element( { 'Name' => 'Hit' } );\n            if ( defined $seeniteration ) {\n                $self->within_element('iteration')\n                  && $self->end_element( { 'Name' => 'Iteration' } );\n                $self->start_element( { 'Name' => 'Iteration' } );\n            }\n            else {\n                $self->start_element( { 'Name' => 'Iteration' } );\n            }\n            $seeniteration = 1;\n        }\n        elsif (/^Query=\\s*(.*)$/) {\n            my $q    = $1;\n            $self->debug(\"blast.pm: Query= found...$_\\n\");\n            my $size = 0;\n            if ( defined $seenquery ) {\n                $self->_pushback($reportline) if $reportline;\n                $self->_pushback($_);\n                last PARSER;\n            }\n            else {\n                if ( !defined $reporttype ) {\n                    $self->_start_blastoutput;\n                    if ( defined $seeniteration ) {\n                        $self->in_element('iteration')\n                          && $self->end_element( { 'Name' => 'Iteration' } );\n                        $self->start_element( { 'Name' => 'Iteration' } );\n                    }\n                    else {\n                        $self->start_element( { 'Name' => 'Iteration' } );\n                    }\n                    $seeniteration = 1;\n                }\n            }\n            $seenquery = $q;\n            $_ = $self->_readline;\n            while ( defined($_) ) {\n                if (/^Database:/) {\n                    $self->_pushback($_);\n                    last;\n                }\n                # below line fixes length issue with BLAST v2.2.13; still works \n                # with BLAST v2.2.12\n                if ( /\\((\\-?[\\d,]+)\\s+letters.*\\)/ || /^Length=(\\-?[\\d,]+)/ ) {\n                    $size = $1;\n                    $size =~ s/,//g;\n                    last;\n                }\n                else {\n                    # bug 2391\n                    $q .= ($q =~ /\\w$/ && $_ =~ /^\\w/) ? \" $_\" : $_;\n                    $q =~ s/\\s+/ /g; # this catches the newline as well\n                    $q =~ s/^ | $//g;\n                }\n\n                $_ = $self->_readline;\n            }\n            chomp($q);\n            my ( $nm, $desc ) = split( /\\s+/, $q, 2 );\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_query-def',\n                    'Data' => $nm\n                }\n            ) if $nm;\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_query-len',\n                    'Data' => $size\n                }\n            );\n            defined $desc && $desc =~ s/\\s+$//;\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_querydesc',\n                    'Data' => $desc\n                }\n            );\n            my ( $gi, $acc, $version ) = $self->_get_seq_identifiers($nm);\n            $version = defined($version) && length($version) ? \".$version\" : \"\";\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_query-acc',\n                    'Data' => \"$acc$version\"\n                }\n            ) if $acc;\n        }\n\t\t# added check for WU-BLAST -echofilter option (bug 2388)\n\t\telsif (/^>Unfiltered[+-]1$/) {\n        \t# skip all of the lines of unfiltered sequence\n\t\t\twhile($_ !~ /^Database:/) {\n\t\t\t\t$self->debug(\"Bypassing features line: $_\");\n        \t\t$_ = $self->_readline;\n        \t}\n\t\t\t$self->_pushback($_);\n\t\t}\n        elsif (/Sequences producing significant alignments:/) {\n            $self->debug(\"blast.pm: Processing NCBI-BLAST descriptions\\n\");\n            $flavor = 'ncbi';\n            \n            # PSI-BLAST parsing needs to be fixed to specifically look\n            # for old vs new per iteration, as sorting based on duplication\n            # leads to bugs, see bug 1986\n            \n            # The next line is not necessarily whitespace in psiblast reports.\n            # Also note that we must look for the end of this section by testing\n            # for a line with a leading >. Blank lines occur with this section\n            # for psiblast.\n            if ( !$self->in_element('iteration') ) {\n                $self->start_element( { 'Name' => 'Iteration' } );\n            }\n            # these elements are dropped with some multiquery reports; add\n            # back here\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_db-len',\n                    'Data' => $self->{'_blsdb_length'}\n                } \n            ) if $self->{'_blsdb_length'};\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_db-let',\n                    'Data' => $self->{'_blsdb_letters'}\n                }\n            ) if $self->{'_blsdb_letters'};\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_db',\n                    'Data' => $self->{'_blsdb'}\n                }\n            ) if $self->{'_blsdb_letters'};\n            \n            # changed 8/28/2008 to exit hit table if blank line is found after an\n            # appropriate line\n            my $h_regex;\n            my $seen_block;\n          DESCLINE:\n            while ( defined( my $descline = $self->_readline() ) ) {\n                if ($descline =~ m{^\\s*$}) {\n                    last DESCLINE if $seen_block;\n                    next DESCLINE;\n                }\n                # any text match is part of block...\n                $seen_block++;\n                # GCG multiline oddness...\n                if ($descline =~ /^(\\S+)\\s+Begin:\\s\\d+\\s+End:\\s+\\d+/xms) {\n                    my ($id, $nextline) = ($1, $self->_readline);\n                    $nextline =~ s{^!}{};\n                    $descline = \"$id $nextline\";\n                }\n                # NCBI style hit table (no N)\n                if ($descline =~ /(?<!cor)          # negative lookahead\n                    (\\d*\\.?(?:[\\+\\-eE]+)?\\d+)       # number (float or scientific notation)\n                    \\s+                             # space\n                    (\\d*\\.?(?:[\\+\\-eE]+)?\\d+)       # number (float or scientific notation)\n                    \\s*$/xms) {\n                    \n                    my ( $score, $evalue ) = ($1, $2);\n                    \n                    # Some data clean-up so e-value will appear numeric to perl\n                    $evalue =~ s/^e/1e/i;\n\n                    # This to handle no-HSP case\n                    my @line = split ' ',$descline;\n                    \n                    # we want to throw away the score, evalue\n                    pop @line, pop @line;\n\n                    # and N if it is present (of course they are not\n                    # really in that order, but it doesn't matter\n                    if ($3) { pop @line }\n\n                    # add the last 2 entries s.t. we can reconstruct\n                    # a minimal Hit object at the end of the day\n                    push @hit_signifs, [ $evalue, $score, shift @line, join( ' ', @line ) ];\n                } elsif ($descline =~ /^CONVERGED/i) {\n                    $self->element(\n                        {\n                            'Name' => 'Iteration_converged',\n                            'Data' => 1\n                        }\n                    );\n                } else {\n                    $self->_pushback($descline); # Catch leading > (end of section)\n                    last DESCLINE;\n                }\n            }\n        }\n        elsif (/Sequences producing High-scoring Segment Pairs:/) {\n\n     # This block is for WU-BLAST, so we don't have to check for psi-blast stuff\n     # skip the next line\n            $self->debug(\"blast.pm: Processing WU-BLAST descriptions\\n\");\n            $_      = $self->_readline();\n            $flavor = 'wu';\n\n            if ( !$self->in_element('iteration') ) {\n                $self->start_element( { 'Name' => 'Iteration' } );\n            }\n\n            while ( defined( $_ = $self->_readline() )\n                && !/^\\s+$/ )\n            {\n                my @line = split;\n                pop @line;    # throw away first number which is for 'N'col\n\n                # add the last 2 entries to array s.t. we can reconstruct\n                # a minimal Hit object at the end of the day\n                push @hit_signifs,\n                  [ pop @line, pop @line, shift @line, join( ' ', @line ) ];\n            }\n            \n        }\n        elsif (/^Database:\\s*(.+)$/) {\n\n            $self->debug(\"blast.pm: Database: $1\\n\");\n            my $db = $1;\n            while ( defined( $_ = $self->_readline ) ) {\n                if (\n                    /^\\s+(\\-?[\\d\\,]+|\\S+)\\s+sequences\\;\n                   \\s+(\\-?[\\d,]+|\\S+)\\s+ # Deal with NCBI 2.2.8 OSX problems\n                   total\\s+letters/ox\n                  )\n                {\n                    my ( $s, $l ) = ( $1, $2 );\n                    $s =~ s/,//g;\n                    $l =~ s/,//g;\n                    $self->element(\n                        {\n                            'Name' => 'BlastOutput_db-len',\n                            'Data' => $s\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'BlastOutput_db-let',\n                            'Data' => $l\n                        }\n                    );\n                    # cache for next round in cases with multiple queries\n                    $self->{'_blsdb'} = $db;\n                    $self->{'_blsdb_length'} = $s;\n                    $self->{'_blsdb_letters'} = $l;                    \n                    last;\n                }\n                else {\n                    chomp;\n                    $db .= $_;\n                }\n            }\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_db',\n                    'Data' => $db\n                }\n            );\n        }\n        # bypasses this NCBI blast 2.2.13 extra output for now...\n\t\t# Features in/flanking this part of subject sequence:\n        elsif (/^\\sFeatures\\s\\w+\\sthis\\spart/xmso) {\n            my $featline;\n            $_ = $self->_readline;\n\t\t\twhile($_ !~ /^\\s*$/) {\n                chomp;\n                $featline .= $_;\n        \t\t$_ = $self->_readline;\n        \t}\n\t\t\t$self->_pushback($_);\n            $featline =~ s{(?:^\\s+|\\s+^)}{}g;\n            $featline =~ s{\\n}{;}g;\n            $self->{'_last_hspdata'}->{'Hsp_features'} = $featline;\n        }\n        \n        # move inside of a hit\n        elsif (/^>\\s*(\\S+)\\s*(.*)?/) {\n            chomp;\n\n            $self->debug(\"blast.pm: Hit: $1\\n\");\n            $self->in_element('hsp')\n              && $self->end_element( { 'Name' => 'Hsp' } );\n            $self->in_element('hit')\n              && $self->end_element( { 'Name' => 'Hit' } );\n\n            # special case when bl2seq reports don't have a leading\n            # Query=\n            if ( !$self->within_element('result') ) {\n                $self->_start_blastoutput;\n                $self->start_element( { 'Name' => 'Iteration' } );\n            }\n            elsif ( !$self->within_element('iteration') ) {\n                $self->start_element( { 'Name' => 'Iteration' } );\n            }\n            $self->start_element( { 'Name' => 'Hit' } );\n            my $id         = $1;\n            my $restofline = $2;\n\n            $self->debug(\"Starting a hit: $1 $2\\n\");\n            $self->element(\n                {\n                    'Name' => 'Hit_id',\n                    'Data' => $id\n                }\n            );\n            my ($gi, $acc, $version ) = $self->_get_seq_identifiers($id);\n            $self->element(\n                {\n                    'Name' => 'Hit_accession',\n                    'Data' => $acc\n                }\n            );\n            # add hit significance (from the hit table)\n            # this is where Bug 1986 went awry\n            \n            # Changed for Bug2409; hit->significance and hit->score/bits derived\n            # from HSPs, not hit table unless necessary\n            \n            HITTABLE:\n            while (my $v = shift @hit_signifs) {        \n                my $tableid = $v->[2];\n                if ($tableid !~ m{\\Q$id\\E}) {\n                    $self->debug(\"Hit table ID $tableid doesn't match current hit id $id, checking next hit table entry...\\n\");\n                    next HITTABLE;\n                } else {\n                    last HITTABLE;\n                }\n            }\n            while ( defined( $_ = $self->_readline() ) ) {\n                next if (/^\\s+$/);\n                chomp;\n                if (/Length\\s*=\\s*([\\d,]+)/) {\n                    my $l = $1;\n                    $l =~ s/\\,//g;\n                    $self->element(\n                        {\n                            'Name' => 'Hit_len',\n                            'Data' => $l\n                        }\n                    );\n                    last;\n                }\n                else {\n                    s/^\\s(?!\\s)/\\x01/; #new line to concatenate desc lines with <soh>\n                    $restofline .= $_;\n                }\n            }\n            $restofline =~ s/\\s+/ /g;\n            $self->element(\n                {\n                    'Name' => 'Hit_def',\n                    'Data' => $restofline\n                }\n            );\n        }\n        elsif (/\\s+(Plus|Minus) Strand HSPs:/i) {\n            next;\n        }\n        elsif (\n            ( $self->in_element('hit') || $self->in_element('hsp') )\n            &&    # paracel genewise BTK\n            m/Score\\s*=\\s*(\\S+)\\s*bits\\s* # Bit score\n                (?:\\((\\d+)\\))?,                 # Raw score\n\t\t\\s+Log\\-Length\\sScore\\s*=\\s*(\\d+) # Log-Length score\n                /ox\n          )\n        {\n            $self->in_element('hsp')\n              && $self->end_element( { 'Name' => 'Hsp' } );\n            $self->start_element( { 'Name' => 'Hsp' } );\n\n            $self->debug( \"Got paracel genewise HSP score=$1\\n\");\n\n            # Some data clean-up so e-value will appear numeric to perl\n            my ( $bits, $score, $evalue ) = ( $1, $2, $3 );\n            $evalue =~ s/^e/1e/i;\n            $self->element(\n                {\n                    'Name' => 'Hsp_score',\n                    'Data' => $score\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_bit-score',\n                    'Data' => $bits\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_evalue',\n                    'Data' => $evalue\n                }\n            );\n        }\n        elsif (\n            ( $self->in_element('hit') || $self->in_element('hsp') )\n            &&    # paracel hframe BTK\n            m/Score\\s*=\\s*([^,\\s]+),     # Raw score\n\t\t\\s*Expect\\s*=\\s*([^,\\s]+),  # E-value\n                \\s*P(?:\\(\\S+\\))?\\s*=\\s*([^,\\s]+) # P-value\n                /ox\n          )\n        {\n            $self->in_element('hsp')\n              && $self->end_element( { 'Name' => 'Hsp' } );\n            $self->start_element( { 'Name' => 'Hsp' } );\n\n            $self->debug( \"Got paracel hframe HSP score=$1\\n\");\n\n            # Some data clean-up so e-value will appear numeric to perl\n            my ( $score, $evalue, $pvalue ) = ( $1, $2, $3 );\n            $evalue = \"1$evalue\" if $evalue =~ /^e/;\n            $pvalue = \"1$pvalue\" if $pvalue =~ /^e/;\n\n            $self->element(\n                {\n                    'Name' => 'Hsp_score',\n                    'Data' => $score\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_evalue',\n                    'Data' => $evalue\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_pvalue',\n                    'Data' => $pvalue\n                }\n            );\n        }\n        elsif (\n            ( $self->in_element('hit') || $self->in_element('hsp') )\n            &&    # wublast\n            m/Score\\s*=\\s*(\\S+)\\s*         # Bit score\n                \\(([\\d\\.]+)\\s*bits\\),         # Raw score\n                \\s*Expect\\s*=\\s*([^,\\s]+),    # E-value\n                \\s*(?:Sum)?\\s*                # SUM\n                P(?:\\(\\d+\\))?\\s*=\\s*([^,\\s]+) # P-value\n                (?:\\s*,\\s+Group\\s*\\=\\s*(\\d+))?    # HSP Group\n                /ox\n          )\n        {         # wu-blast HSP parse\n            $self->in_element('hsp')\n              && $self->end_element( { 'Name' => 'Hsp' } );\n            $self->start_element( { 'Name' => 'Hsp' } );\n\n            # Some data clean-up so e-value will appear numeric to perl\n            my ( $score, $bits, $evalue, $pvalue, $group ) =\n              ( $1, $2, $3, $4, $5 );\n            $evalue =~ s/^e/1e/i;\n            $pvalue =~ s/^e/1e/i;\n\n            $self->element(\n                {\n                    'Name' => 'Hsp_score',\n                    'Data' => $score\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_bit-score',\n                    'Data' => $bits\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_evalue',\n                    'Data' => $evalue\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_pvalue',\n                    'Data' => $pvalue\n                }\n            );\n\n            if ( defined $group ) {\n                $self->element(\n                    {\n                        'Name' => 'Hsp_group',\n                        'Data' => $group\n                    }\n                );\n            }\n\n        }\n        elsif (\n            ( $self->in_element('hit') || $self->in_element('hsp') )\n            &&    # ncbi blast, works with 2.2.17\n            m/Score\\s*=\\s*(\\S+)\\s*bits\\s* # Bit score\n                (?:\\((\\d+)\\))?,            # Missing for BLAT pseudo-BLAST fmt \n                \\s*Expect(?:\\((\\d+\\+?)\\))?\\s*=\\s*([^,\\s]+) # E-value\n                /ox\n          )\n        {         # parse NCBI blast HSP\n            $self->in_element('hsp')\n              && $self->end_element( { 'Name' => 'Hsp' } );\n\n            # Some data clean-up so e-value will appear numeric to perl\n            my ( $bits, $score, $n, $evalue ) = ( $1, $2, $3, $4 );\n            $evalue =~ s/^e/1e/i;\n            $self->start_element( { 'Name' => 'Hsp' } );\n            $self->element(\n                {\n                    'Name' => 'Hsp_score',\n                    'Data' => $score\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_bit-score',\n                    'Data' => $bits\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_evalue',\n                    'Data' => $evalue\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_n',\n                    'Data' => $n\n                }\n            ) if defined $n;\n            $score = '' unless defined $score;    # deal with BLAT which\n                                                  # has no score only bits\n            $self->debug(\"Got NCBI HSP score=$score, evalue $evalue\\n\");\n        }\n        elsif (\n            $self->in_element('hsp')\n            && m/Identities\\s*=\\s*(\\d+)\\s*\\/\\s*(\\d+)\\s*[\\d\\%\\(\\)]+\\s*\n                (?:,\\s*Positives\\s*=\\s*(\\d+)\\/(\\d+)\\s*[\\d\\%\\(\\)]+\\s*)? # pos only valid for Protein alignments\n                (?:\\,\\s*Gaps\\s*=\\s*(\\d+)\\/(\\d+))? # Gaps\n                /oxi\n          )\n        {\n            $self->element(\n                {\n                    'Name' => 'Hsp_identity',\n                    'Data' => $1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_align-len',\n                    'Data' => $2\n                }\n            );\n            if ( defined $3 ) {\n                $self->element(\n                    {\n                        'Name' => 'Hsp_positive',\n                        'Data' => $3\n                    }\n                );\n            }\n            else {\n                $self->element(\n                    {\n                        'Name' => 'Hsp_positive',\n                        'Data' => $1\n                    }\n                );\n            }\n            if ( defined $6 ) {\n                $self->element(\n                    {\n                        'Name' => 'Hsp_gaps',\n                        'Data' => $5\n                    }\n                );\n            }\n\n            $self->{'_Query'} = { 'begin' => 0, 'end' => 0 };\n            $self->{'_Sbjct'} = { 'begin' => 0, 'end' => 0 };\n\n            if (/(Frame\\s*=\\s*.+)$/) {\n\n                # handle wu-blast Frame listing on same line\n                $self->_pushback($1);\n            }\n        }\n        elsif ( $self->in_element('hsp')\n            && /Strand\\s*=\\s*(Plus|Minus)\\s*\\/\\s*(Plus|Minus)/i )\n        {\n\n            # consume this event ( we infer strand from start/end)\n            unless ($reporttype) {\n                $self->{'_reporttype'} = $reporttype = 'BLASTN';\n                $bl2seq_fix = 1;    # special case to resubmit the algorithm\n                                    # reporttype\n            }\n            next;\n        }\n        elsif ( $self->in_element('hsp')\n            && /Links\\s*=\\s*(\\S+)/ox )\n        {\n            $self->element(\n                {\n                    'Name' => 'Hsp_links',\n                    'Data' => $1\n                }\n            );\n        }\n        elsif ( $self->in_element('hsp')\n            && /Frame\\s*=\\s*([\\+\\-][1-3])\\s*(\\/\\s*([\\+\\-][1-3]))?/ )\n        {\n\n            # this is for bl2seq only\n            unless ( defined $reporttype ) {\n                $bl2seq_fix = 1;\n                if ( $1 && $2 ) { $reporttype = 'TBLASTX' }\n                else {\n                    $reporttype = 'BLASTX';\n\n    # we can't distinguish between BLASTX and TBLASTN straight from the report }\n                }\n                $self->{'_reporttype'} = $reporttype;\n            }\n\n            my ( $queryframe, $hitframe );\n            if ( $reporttype eq 'TBLASTX' ) {\n                ( $queryframe, $hitframe ) = ( $1, $2 );\n                $hitframe =~ s/\\/\\s*//g;\n            }\n            elsif ( $reporttype eq 'TBLASTN' || $reporttype eq 'PSITBLASTN') {\n                ( $hitframe, $queryframe ) = ( $1, 0 );\n            }\n            elsif ( $reporttype eq 'BLASTX' || $reporttype eq 'RPS-BLAST(BLASTP)') {\n                ( $queryframe, $hitframe ) = ( $1, 0 );\n                # though NCBI doesn't report it, this is a special BLASTX-like\n                # RPS-BLAST; should be handled differently\n                if ($reporttype eq 'RPS-BLAST(BLASTP)') {\n                    $self->element(\n                        {\n                            'Name' => 'BlastOutput_program',\n                            'Data' => 'RPS-BLAST(BLASTX)'\n                        }\n                    );\n                }\n            }\n            $self->element(\n                {\n                    'Name' => 'Hsp_query-frame',\n                    'Data' => $queryframe\n                }\n            );\n\n            $self->element(\n                {\n                    'Name' => 'Hsp_hit-frame',\n                    'Data' => $hitframe\n                }\n            );\n        }\n        elsif (/^Parameters:/\n            || /^\\s+Database:\\s+?/\n            || /^\\s+Subset/\n            || /^\\s*Lambda/\n            || /^\\s*Histogram/\n            || ( $self->in_element('hsp') && /WARNING|NOTE/ ) )\n        {\n\n            # Note: Lambda check was necessary to parse\n            # t/data/ecoli_domains.rpsblast AND to parse bl2seq\n            $self->debug(\"blast.pm: found parameters section \\n\");\n\n            $self->in_element('hsp')\n              && $self->end_element( { 'Name' => 'Hsp' } );\n            $self->in_element('hit')\n              && $self->end_element( { 'Name' => 'Hit' } );\n\n            # This is for the case when we specify -b 0 (or B=0 for WU-BLAST)\n            # and still want to construct minimal Hit objects\n            $self->_cleanup_hits(\\@hit_signifs) if scalar(@hit_signifs);\n            $self->within_element('iteration')\n              && $self->end_element( { 'Name' => 'Iteration' } );\n\n            next if /^\\s+Subset/;\n            my $blast = (/^(\\s+Database\\:)|(\\s*Lambda)/) ? 'ncbi' : 'wublast';\n            if (/^\\s*Histogram/) {\n                $blast = 'btk';\n            }\n\n            my $last = '';\n\n            # default is that gaps are allowed\n            $self->element(\n                {\n                    'Name' => 'Parameters_allowgaps',\n                    'Data' => 'yes'\n                }\n            );\n            while ( defined( $_ = $self->_readline ) ) {\n                if (\n                    /^((?:\\S+)?BLAST[NPX]?)\\s+(.+)$/i  # NCBI BLAST, PSIBLAST\n                                                      # RPSBLAST, MEGABLAST\n                    || /^(P?GENEWISE|HFRAME|SWN|TSWN)\\s+(.+)/i    #Paracel BTK\n                  )\n                {\n                    $self->_pushback($_);\n\n                    # let's handle this in the loop\n                    last;\n                }\n                elsif (/^Query=/) {\n                    $self->_pushback($reportline) if $reportline;\n                    $self->_pushback($_);\n                    last PARSER;\n                }\n\n                # here is where difference between wublast and ncbiblast\n                # is better handled by different logic\n                if (   /Number of Sequences:\\s+([\\d\\,]+)/i\n                    || /of sequences in database:\\s+(\\-?[\\d,]+)/i )\n                {\n                    my $c = $1;\n                    $c =~ s/\\,//g;\n                    $self->element(\n                        {\n                            'Name' => 'Statistics_db-len',\n                            'Data' => $c\n                        }\n                    );\n                }\n                elsif (/letters in database:\\s+(\\-?[\\d,]+)/i) {\n                    my $s = $1;\n                    $s =~ s/,//g;\n                    $self->element(\n                        {\n                            'Name' => 'Statistics_db-let',\n                            'Data' => $s\n                        }\n                    );\n                }\n                elsif ( $blast eq 'btk' ) {\n                    next;\n                }\n                elsif ( $blast eq 'wublast' ) {\n\n                    #\t\t   warn($_);\n                    if (/E=(\\S+)/) {\n                        $self->element(\n                            {\n                                'Name' => 'Parameters_expect',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (/nogaps/) {\n                        $self->element(\n                            {\n                                'Name' => 'Parameters_allowgaps',\n                                'Data' => 'no'\n                            }\n                        );\n                    }\n                    elsif (/ctxfactor=(\\S+)/) {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_ctxfactor',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (\n/(postsw|links|span[12]?|warnings|notes|gi|noseqs|qres|qype)/\n                      )\n                    {\n                        $self->element(\n                            {\n                                'Name' => \"Parameters_$1\",\n                                'Data' => 'yes'\n                            }\n                        );\n                    }\n                    elsif (/(\\S+)=(\\S+)/) {\n                        $self->element(\n                            {\n                                'Name' => \"Parameters_$1\",\n                                'Data' => $2\n                            }\n                        );\n                    }\n                    elsif ( $last =~ /(Frame|Strand)\\s+MatID\\s+Matrix name/i ) {\n                        my $firstgapinfo = 1;\n                        my $frame        = undef;\n                        while ( defined($_) && !/^\\s+$/ ) {\n                            s/^\\s+//;\n                            s/\\s+$//;\n                            if ( $firstgapinfo\n                                && s/Q=(\\d+),R=(\\d+)\\s+//x )\n                            {\n                                $firstgapinfo = 0;\n\n                                $self->element(\n                                    {\n                                        'Name' => 'Parameters_gap-open',\n                                        'Data' => $1\n                                    }\n                                );\n                                $self->element(\n                                    {\n                                        'Name' => 'Parameters_gap-extend',\n                                        'Data' => $2\n                                    }\n                                );\n                                my @fields = split;\n\n                                for my $type (\n                                    qw(lambda_gapped\n                                    kappa_gapped\n                                    entropy_gapped)\n                                  )\n                                {\n                                    next if $type eq 'n/a';\n                                    if ( !@fields ) {\n                                        warn \"fields is empty for $type\\n\";\n                                        next;\n                                    }\n                                    $self->element(\n                                        {\n                                            'Name' =>\n                                              \"Statistics_frame$frame\\_$type\",\n                                            'Data' => shift @fields\n                                        }\n                                    );\n                                }\n                            }\n                            else {\n                                my ( $frameo, $matid, $matrix, @fields ) =\n                                  split;\n                                if ( !defined $frame ) {\n\n                                    # keep some sort of default feature I guess\n                                    # even though this is sort of wrong\n                                    $self->element(\n                                        {\n                                            'Name' => 'Parameters_matrix',\n                                            'Data' => $matrix\n                                        }\n                                    );\n                                    $self->element(\n                                        {\n                                            'Name' => 'Statistics_lambda',\n                                            'Data' => $fields[0]\n                                        }\n                                    );\n                                    $self->element(\n                                        {\n                                            'Name' => 'Statistics_kappa',\n                                            'Data' => $fields[1]\n                                        }\n                                    );\n                                    $self->element(\n                                        {\n                                            'Name' => 'Statistics_entropy',\n                                            'Data' => $fields[2]\n                                        }\n                                    );\n                                }\n                                $frame = $frameo;\n                                my $ii = 0;\n                                for my $type (\n                                    qw(lambda_used\n                                    kappa_used\n                                    entropy_used\n                                    lambda_computed\n                                    kappa_computed\n                                    entropy_computed)\n                                  )\n                                {\n                                    my $f = $fields[$ii];\n                                    next unless defined $f;    # deal with n/a\n                                    if ( $f eq 'same' ) {\n                                        $f = $fields[ $ii - 3 ];\n                                    }\n                                    $ii++;\n                                    $self->element(\n                                        {\n                                            'Name' =>\n                                              \"Statistics_frame$frame\\_$type\",\n                                            'Data' => $f\n                                        }\n                                    );\n\n                                }\n                            }\n\n                            # get the next line\n                            $_ = $self->_readline;\n                        }\n                        $last = $_;\n                    }\n                    elsif ( $last =~ /(Frame|Strand)\\s+MatID\\s+Length/i ) {\n                        my $frame = undef;\n                        while ( defined($_) && !/^\\s+/ ) {\n                            s/^\\s+//;\n                            s/\\s+$//;\n                            my @fields = split;\n                            if ( @fields <= 3 ) {\n                                for my $type (qw(X_gapped E2_gapped S2)) {\n                                    last unless @fields;\n                                    $self->element(\n                                        {\n                                            'Name' =>\n                                              \"Statistics_frame$frame\\_$type\",\n                                            'Data' => shift @fields\n                                        }\n                                    );\n                                }\n                            }\n                            else {\n\n                                for my $type (\n                                    qw(length\n                                    efflength\n                                    E S W T X E2 S2)\n                                  )\n                                {\n                                    $self->element(\n                                        {\n                                            'Name' =>\n                                              \"Statistics_frame$frame\\_$type\",\n                                            'Data' => shift @fields\n                                        }\n                                    );\n                                }\n                            }\n                            $_ = $self->_readline;\n                        }\n                        $last = $_;\n                    }\n                    elsif (/(\\S+\\s+\\S+)\\s+DFA:\\s+(\\S+)\\s+\\((.+)\\)/) {\n                        if ( $1 eq 'states in' ) {\n                            $self->element(\n                                {\n                                    'Name' => 'Statistics_DFA_states',\n                                    'Data' => \"$2 $3\"\n                                }\n                            );\n                        }\n                        elsif ( $1 eq 'size of' ) {\n                            $self->element(\n                                {\n                                    'Name' => 'Statistics_DFA_size',\n                                    'Data' => \"$2 $3\"\n                                }\n                            );\n                        }\n                    }\n                    elsif (\n                        m/^\\s+Time to generate neighborhood:\\s+\n\t\t\t    (\\S+\\s+\\S+\\s+\\S+)/x\n                      )\n                    {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_neighbortime',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (/processors\\s+used:\\s+(\\d+)/) {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_noprocessors',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (\n                        m/^\\s+(\\S+)\\s+cpu\\s+time:\\s+# cputype\n\t\t\t    (\\S+\\s+\\S+\\s+\\S+)           # cputime\n\t\t\t    \\s+Elapsed:\\s+(\\S+)/x\n                      )\n                    {\n                        my $cputype = lc($1);\n                        $self->element(\n                            {\n                                'Name' => \"Statistics_$cputype\\_cputime\",\n                                'Data' => $2\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => \"Statistics_$cputype\\_actualtime\",\n                                'Data' => $3\n                            }\n                        );\n                    }\n                    elsif (/^\\s+Start:/) {\n                        my ( $junk, $start, $stime, $end, $etime ) =\n                          split( /\\s+(Start|End)\\:\\s+/, $_ );\n                        chomp($stime);\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_starttime',\n                                'Data' => $stime\n                            }\n                        );\n                        chomp($etime);\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_endtime',\n                                'Data' => $etime\n                            }\n                        );\n                    }\n                    elsif (/^\\s+Database:\\s+(.+)$/) {\n                        $self->element(\n                            {\n                                'Name' => 'Parameters_full_dbpath',\n                                'Data' => $1\n                            }\n                        );\n\n                    }\n                    elsif (/^\\s+Posted:\\s+(.+)/) {\n                        my $d = $1;\n                        chomp($d);\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_posted_date',\n                                'Data' => $d\n                            }\n                        );\n                    }\n                }\n                elsif ( $blast eq 'ncbi' ) {\n\n                    if (m/^Matrix:\\s+(.+)\\s*$/oxi) {\n                        $self->element(\n                            {\n                                'Name' => 'Parameters_matrix',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (/^Gapped/) {\n                        $gapped_stats = 1;\n                    }\n                    elsif (/^Lambda/) {\n                        $_ = $self->_readline;\n                        s/^\\s+//;\n                        my ( $lambda, $kappa, $entropy ) = split;\n                        if ($gapped_stats) {\n                            $self->element(\n                                {\n                                    'Name' => \"Statistics_gapped_lambda\",\n                                    'Data' => $lambda\n                                }\n                            );\n                            $self->element(\n                                {\n                                    'Name' => \"Statistics_gapped_kappa\",\n                                    'Data' => $kappa\n                                }\n                            );\n                            $self->element(\n                                {\n                                    'Name' => \"Statistics_gapped_entropy\",\n                                    'Data' => $entropy\n                                }\n                            );\n                        }\n                        else {\n                            $self->element(\n                                {\n                                    'Name' => \"Statistics_lambda\",\n                                    'Data' => $lambda\n                                }\n                            );\n                            $self->element(\n                                {\n                                    'Name' => \"Statistics_kappa\",\n                                    'Data' => $kappa\n                                }\n                            );\n                            $self->element(\n                                {\n                                    'Name' => \"Statistics_entropy\",\n                                    'Data' => $entropy\n                                }\n                            );\n                        }\n                    }\n                    elsif (m/effective\\s+search\\s+space\\s+used:\\s+(\\d+)/ox) {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_eff-spaceused',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (m/effective\\s+search\\s+space:\\s+(\\d+)/ox) {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_eff-space',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (\n                        m/Gap\\s+Penalties:\\s+Existence:\\s+(\\d+)\\,\n\t\t\t    \\s+Extension:\\s+(\\d+)/ox\n                      )\n                    {\n                        $self->element(\n                            {\n                                'Name' => 'Parameters_gap-open',\n                                'Data' => $1\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Parameters_gap-extend',\n                                'Data' => $2\n                            }\n                        );\n                    }\n                    elsif (/effective\\s+HSP\\s+length:\\s+(\\d+)/) {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_hsp-len',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (/effective\\s+length\\s+of\\s+query:\\s+([\\d\\,]+)/) {\n                        my $c = $1;\n                        $c =~ s/\\,//g;\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_query-len',\n                                'Data' => $c\n                            }\n                        );\n                    }\n                    elsif (/effective\\s+length\\s+of\\s+database:\\s+([\\d\\,]+)/) {\n                        my $c = $1;\n                        $c =~ s/\\,//g;\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_eff-dblen',\n                                'Data' => $c\n                            }\n                        );\n                    }\n                    elsif (\n/^(T|A|X1|X2|X3|S1|S2):\\s+(\\d+(\\.\\d+)?)\\s+(?:\\(\\s*(\\d+\\.\\d+) bits\\))?/\n                      )\n                    {\n                        my $v = $2;\n                        chomp($v);\n                        $self->element(\n                            {\n                                'Name' => \"Statistics_$1\",\n                                'Data' => $v\n                            }\n                        );\n                        if ( defined $4 ) {\n                            $self->element(\n                                {\n                                    'Name' => \"Statistics_$1_bits\",\n                                    'Data' => $4\n                                }\n                            );\n                        }\n                    }\n                    elsif (\n                        m/frameshift\\s+window\\,\n\t\t\t    \\s+decay\\s+const:\\s+(\\d+)\\,\\s+([\\.\\d]+)/x\n                      )\n                    {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_framewindow',\n                                'Data' => $1\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_decay',\n                                'Data' => $2\n                            }\n                        );\n                    }\n                    elsif (m/^Number\\s+of\\s+Hits\\s+to\\s+DB:\\s+(\\S+)/ox) {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_hit_to_db',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (m/^Number\\s+of\\s+extensions:\\s+(\\S+)/ox) {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_num_extensions',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (\n                        m/^Number\\s+of\\s+successful\\s+extensions:\\s+\n\t\t\t    (\\S+)/ox\n                      )\n                    {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_num_suc_extensions',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (\n                        m/^Number\\s+of\\s+sequences\\s+better\\s+than\\s+\n\t\t\t    (\\S+):\\s+(\\d+)/ox\n                      )\n                    {\n                        $self->element(\n                            {\n                                'Name' => 'Parameters_expect',\n                                'Data' => $1\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_seqs_better_than_cutoff',\n                                'Data' => $2\n                            }\n                        );\n                    }\n                    elsif (/^\\s+Posted\\s+date:\\s+(.+)/) {\n                        my $d = $1;\n                        chomp($d);\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_posted_date',\n                                'Data' => $d\n                            }\n                        );\n                    }\n                    elsif ( !/^\\s+$/ ) {\n                        #$self->debug( \"unmatched stat $_\");\n                    }\n                }\n                $last = $_;\n            }\n        } elsif ( $self->in_element('hsp') ) {\n            $self->debug(\"blast.pm: Processing HSP\\n\");\n            # let's read 3 lines at a time;\n            # bl2seq hackiness... Not sure I like\n            $self->{'_reporttype'} ||= $DEFAULTREPORTTYPE;\n            my %data = (\n                'Query' => '',\n                'Mid'   => '',\n                'Hit'   => ''\n            );\n            my $len;\n            for ( my $i = 0 ; defined($_) && $i < 3 ; $i++ ) {\n                # $self->debug(\"$i: $_\") if $v;\n                if ( ( $i == 0 && /^\\s+$/) || \n\t\t     /^\\s*(?:Lambda|Minus|Plus|Score)/i )\n                {\n                    $self->_pushback($_) if defined $_;\n                    $self->end_element( { 'Name' => 'Hsp' } );\n                    last;\n                }\n                chomp;\n                if (/^((Query|Sbjct):?\\s+(\\-?\\d+)\\s*)(\\S+)\\s+(\\-?\\d+)/) {\n                    my ( $full, $type, $start, $str, $end ) =\n                      ( $1, $2, $3, $4, $5 );\n\n                    if ( $str eq '-' ) {\n                        $i = 3 if $type eq 'Sbjct';\n                    }\n                    else {\n                        $data{$type} = $str;\n                    }\n                    $len = length($full);\n                    $self->{\"\\_$type\"}->{'begin'} = $start\n                      unless $self->{\"_$type\"}->{'begin'};\n                    $self->{\"\\_$type\"}->{'end'} = $end;\n                } else {\n                    $self->throw(\"no data for midline $_\")\n                      unless ( defined $_ && defined $len );\n                    $data{'Mid'} = substr( $_, $len );\n                }\n                $_ = $self->_readline();\n            }\n            $self->characters(\n                {\n                    'Name' => 'Hsp_qseq',\n                    'Data' => $data{'Query'}\n                }\n            );\n            $self->characters(\n                {\n                    'Name' => 'Hsp_hseq',\n                    'Data' => $data{'Sbjct'}\n                }\n            );\n            $self->characters(\n                {\n                    'Name' => 'Hsp_midline',\n                    'Data' => $data{'Mid'}\n                }\n            );\n        }\n        else {\n            #$self->debug(\"blast.pm: unrecognized line $_\");\n        }\n    }\n\n    $self->debug(\"blast.pm: End of BlastOutput\\n\");\n    if ( $self->{'_seentop'} ) {\n        $self->within_element('hsp')\n          && $self->end_element( { 'Name' => 'Hsp' } );\n        $self->within_element('hit')\n          && $self->end_element( { 'Name' => 'Hit' } );\n        # cleanup extra hits\n        $self->_cleanup_hits(\\@hit_signifs) if scalar(@hit_signifs);\n        $self->within_element('iteration')\n          && $self->end_element( { 'Name' => 'Iteration' } );\n        if ($bl2seq_fix) {\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_program',\n                    'Data' => $reporttype\n                }\n            );\n        }\n        $self->end_element( { 'Name' => 'BlastOutput' } );\n    }\n    return $self->end_document();\n}\n\n# Private method for internal use only.\nsub _start_blastoutput {\n    my $self = shift;\n    $self->start_element( { 'Name' => 'BlastOutput' } );\n    $self->{'_seentop'} = 1;\n    $self->{'_result_count'}++;\n    $self->{'_handler_rc'} = undef;\n}\n\n=head2 _will_handle\n\n Title   : _will_handle\n Usage   : Private method. For internal use only.\n              if( $self->_will_handle($type) ) { ... }\n Function: Provides an optimized way to check whether or not an element of a \n           given type is to be handled.\n Returns : Reference to EventHandler object if the element type is to be handled.\n           undef if the element type is not to be handled.\n Args    : string containing type of element.\n\nOptimizations:\n\n=over 2\n\n* 1\n\nUsing the cached pointer to the EventHandler to minimize repeated\nlookups.\n\n* 2\n\nCaching the will_handle status for each type that is encountered so\nthat it only need be checked by calling\nhandler-E<gt>will_handle($type) once.\n\n\nThis does not lead to a major savings by itself (only 5-10%).  In\ncombination with other optimizations, or for large parse jobs, the\nsavings good be significant.\n\nTo test against the unoptimized version, remove the parentheses from\naround the third term in the ternary \" ? : \" operator and add two\ncalls to $self-E<gt>_eventHandler().\n\n\nsub _will_handle {\n    my ( $self, $type ) = @_;\n    my $handler     = $self->{'_handler_cache'};\n    my $will_handle =\n      defined( $self->{'_will_handle_cache'}->{$type} )\n      ? $self->{'_will_handle_cache'}->{$type}\n      : ( $self->{'_will_handle_cache'}->{$type} =\n          $handler->will_handle($type) );\n\n    return $will_handle ? $handler : undef;\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\nsub start_element {\n    my ( $self, $data ) = @_;\n\n    # we currently don't care about attributes\n    my $nm   = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    if ($type) {\n        my $handler = $self->_will_handle($type);\n        if ($handler) {\n            my $func = sprintf( \"start_%s\", lc $type );\n            $self->{'_handler_rc'} = $handler->$func( $data->{'Attributes'} );\n        }\n        #else {\n            #$self->debug( # changed 4/29/2006 to play nice with other event handlers\n            #    \"Bio::SearchIO::InternalParserError \".\n            #    \"\\nCan't handle elements of type \\'$type.\\'\"\n            #);\n        #}\n        unshift @{ $self->{'_elements'} }, $type;\n        if ( $type eq 'result' ) {\n            $self->{'_values'} = {};\n            $self->{'_result'} = undef;\n        } else {\n            # cleanup some things\n            if ( defined $self->{'_values'} ) {\n                foreach my $k (\n                    grep { /^\\U$type\\-/ }\n                    keys %{ $self->{'_values'} }\n                  )\n                {\n                    delete $self->{'_values'}->{$k};\n                }\n            }\n        }\n    }\n}\n\n=head2 end_element\n\n Title   : end_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : hashref with an element's worth of data\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ( $self, $data ) = @_;\n    \n    my $nm   = $data->{'Name'};\n    my $type;\n    my $rc;\n    if ( $nm eq 'BlastOutput_program' ) {\n        if ( $self->{'_last_data'} =~ /(t?blast[npx])/i ) {\n            $self->{'_reporttype'} = uc $1;\n        }\n        $self->{'_reporttype'} ||= $DEFAULTREPORTTYPE;\n    }\n\n    # Hsps are sort of weird, in that they end when another\n    # object begins so have to detect this in end_element for now\n    if ( $nm eq 'Hsp' ) {\n        foreach (qw(Hsp_qseq Hsp_midline Hsp_hseq Hsp_features)) {\n            $self->element(\n                {\n                    'Name' => $_,\n                    'Data' => $self->{'_last_hspdata'}->{$_}\n                }\n            ) if defined $self->{'_last_hspdata'}->{$_};\n        }\n        $self->{'_last_hspdata'} = {};\n        $self->element(\n            {\n                'Name' => 'Hsp_query-from',\n                'Data' => $self->{'_Query'}->{'begin'}\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_query-to',\n                'Data' => $self->{'_Query'}->{'end'}\n            }\n        );\n\n        $self->element(\n            {\n                'Name' => 'Hsp_hit-from',\n                'Data' => $self->{'_Sbjct'}->{'begin'}\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_hit-to',\n                'Data' => $self->{'_Sbjct'}->{'end'}\n            }\n        );\n\n        #    } elsif( $nm eq 'Iteration' ) {\n        # Nothing special needs to be done here.\n    }\n    if ( $type = $MODEMAP{$nm} ) {\n        my $handler = $self->_will_handle($type);\n        if ($handler) {\n            my $func = sprintf( \"end_%s\", lc $type );\n            $rc = $handler->$func( $self->{'_reporttype'}, $self->{'_values'} );\n        }\n        shift @{ $self->{'_elements'} };\n\n    }\n    elsif ( $MAPPING{$nm} ) {\n        if ( ref( $MAPPING{$nm} ) =~ /hash/i ) {\n\n            # this is where we shove in the data from the\n            # hashref info about params or statistics\n            my $key = ( keys %{ $MAPPING{$nm} } )[0];\n            $self->{'_values'}->{$key}->{ $MAPPING{$nm}->{$key} } =\n              $self->{'_last_data'};\n        }\n        else {\n            $self->{'_values'}->{ $MAPPING{$nm} } = $self->{'_last_data'};\n        }\n    }\n    else {\n        #$self->debug(\"blast.pm: unknown nm $nm, ignoring\\n\");\n    }\n    $self->{'_last_data'} = '';    # remove read data if we are at\n                                   # end of an element\n    $self->{'_result'} = $rc if ( defined $type && $type eq 'result' );\n    return $rc;\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convenience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element {\n    my ( $self, $data ) = @_;\n    # Note that start element isn't needed for character data\n    # Not too SAX-y, though\n    #$self->start_element($data);\n    $self->characters($data);\n    $self->end_element($data);\n}\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string\n\n\n\nsub characters {\n    my ( $self, $data ) = @_;\n    if (   $self->in_element('hsp')\n        && $data->{'Name'} =~ /^Hsp\\_(qseq|hseq|midline)$/ )\n    {\n        $self->{'_last_hspdata'}->{ $data->{'Name'} } .= $data->{'Data'}\n          if defined $data->{'Data'};\n    }\n    return unless ( defined $data->{'Data'} && $data->{'Data'} !~ /^\\s+$/ );\n    $self->{'_last_data'} = $data->{'Data'};\n}\n\n=head2 within_element\n\n Title   : within_element\n Usage   : if( $eventgenerator->within_element($element) ) {}\n Function: Test if we are within a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name \n\nSee Also: L<in_element>\n\n\nsub within_element {\n    my ( $self, $name ) = @_;\n    return 0\n      if ( !defined $name && !defined $self->{'_elements'}\n        || scalar @{ $self->{'_elements'} } == 0 );\n    foreach ( @{ $self->{'_elements'} } ) {\n        if ( $_ eq $name ) {\n            return 1;\n        }\n    }\n    return 0;\n}\n\n=head2 in_element\n\n Title   : in_element\n Usage   : if( $eventgenerator->in_element($element) ) {}\n Function: Test if we are in a particular element\n           This is different than 'within_element' because within\n           can be tested for a whole block.\n Returns : boolean\n Args    : string element name \n\nSee Also: L<within_element>\n\n\nsub in_element {\n    my ( $self, $name ) = @_;\n    return 0 if !defined $self->{'_elements'}->[0];\n    return ( $self->{'_elements'}->[0] eq $name );\n}\n\n=head2 start_document\n\n Title   : start_document\n Usage   : $eventgenerator->start_document\n Function: Handle a start document event\n Returns : none\n Args    : none\n\n\n\nsub start_document {\n    my ($self) = @_;\n    $self->{'_lasttype'} = '';\n    $self->{'_values'}   = {};\n    $self->{'_result'}   = undef;\n    $self->{'_elements'} = [];\n}\n\n=head2 end_document\n\n Title   : end_document\n Usage   : $eventgenerator->end_document\n Function: Handles an end document event\n Returns : Bio::Search::Result::ResultI object\n Args    : none","parameters":[{"label":"$self"},{"label":"@args"}]},"detail":"($self,@args)","kind":12,"children":[{"kind":13,"line":2180,"definition":"my","name":"$self","containerName":"end_document","localvar":"my"},{"kind":13,"line":2180,"name":"@args","containerName":"end_document"},{"name":"$self","containerName":"end_document","kind":13,"line":2183}],"line":2179},{"name":"write_result","range":{"start":{"character":0,"line":2186},"end":{"character":9999,"line":2194}},"kind":12,"children":[{"line":2187,"kind":13,"localvar":"my","containerName":"write_result","name":"$self","definition":"my"},{"line":2187,"kind":13,"name":"$blast","containerName":"write_result"},{"name":"@args","containerName":"write_result","kind":13,"line":2187},{"line":2189,"kind":13,"containerName":"write_result","name":"$self"},{"name":"writer","containerName":"write_result","kind":12,"line":2189},{"name":"$self","containerName":"write_result","kind":13,"line":2190},{"kind":12,"line":2190,"containerName":"write_result","name":"warn"},{"kind":13,"line":2191,"containerName":"write_result","name":"$self"},{"containerName":"write_result","name":"writer","line":2191,"kind":12},{"containerName":"write_result","name":"$DEFAULT_BLAST_WRITER_CLASS","kind":13,"line":2191},{"line":2191,"kind":12,"containerName":"write_result","name":"new"},{"line":2193,"kind":13,"containerName":"write_result","name":"$self"},{"line":2193,"kind":13,"name":"$blast","containerName":"write_result"},{"kind":13,"line":2193,"containerName":"write_result","name":"@args"}],"line":2186,"definition":"sub","containerName":"main::","signature":{"label":"write_result($self,$blast,@args)","parameters":[{"label":"$self"},{"label":"$blast"},{"label":"@args"}],"documentation":""},"detail":"($self,$blast,@args)"},{"line":2193,"kind":12,"containerName":"write_result","name":"SUPER"},{"kind":12,"line":2196,"children":[{"line":2197,"kind":13,"localvar":"my","containerName":"result_count","definition":"my","name":"$self"},{"line":2198,"kind":13,"containerName":"result_count","name":"$self"}],"containerName":"main::","name":"result_count","definition":"sub","range":{"end":{"character":9999,"line":2199},"start":{"line":2196,"character":0}}},{"kind":12,"children":[{"line":2201,"kind":12,"name":"result_count","containerName":"report_count"}],"line":2201,"name":"report_count","definition":"sub","containerName":"main::","range":{"start":{"character":0,"line":2201},"end":{"character":9999,"line":2201}}},{"line":2218,"children":[{"containerName":"inclusion_threshold","name":"_eventHandler","kind":12,"line":2219},{"line":2219,"kind":12,"containerName":"inclusion_threshold","name":"inclusion_threshold"}],"kind":12,"range":{"start":{"line":2218,"character":0},"end":{"line":2220,"character":9999}},"containerName":"main::","definition":"sub","name":"inclusion_threshold"},{"kind":12,"children":[{"containerName":"max_significance","name":"max_significance","kind":12,"line":2236}],"line":2236,"definition":"sub","name":"max_significance","containerName":"main::","range":{"start":{"character":0,"line":2236},"end":{"line":2236,"character":9999}}},{"definition":"sub","name":"signif","containerName":"main::","range":{"start":{"line":2244,"character":0},"end":{"character":9999,"line":2244}},"kind":12,"children":[{"name":"max_significance","containerName":"signif","kind":12,"line":2244}],"line":2244},{"definition":"sub","name":"min_score","containerName":"main::","range":{"end":{"line":2259,"character":9999},"start":{"line":2259,"character":0}},"kind":12,"children":[{"containerName":"min_score","name":"max_significance","line":2259,"kind":12}],"line":2259},{"kind":12,"children":[{"kind":13,"line":2273,"definition":"my","name":"$self","containerName":"min_query_length","localvar":"my"},{"containerName":"min_query_length","name":"$min_qlen","definition":"my","localvar":"my","kind":13,"line":2275},{"kind":13,"line":2276,"containerName":"min_query_length","name":"$min_qlen"},{"line":2276,"kind":13,"containerName":"min_query_length","name":"$min_qlen"},{"kind":13,"line":2277,"containerName":"min_query_length","name":"$self"},{"containerName":"min_query_length","name":"throw","kind":12,"line":2277},{"name":"$min_qlen","containerName":"min_query_length","line":2282,"kind":13},{"kind":13,"line":2284,"name":"$self","containerName":"min_query_length"},{"containerName":"min_query_length","name":"$self","line":2285,"kind":13},{"name":"$min_qlen","containerName":"min_query_length","line":2285,"kind":13},{"line":2288,"kind":13,"name":"$self","containerName":"min_query_length"}],"line":2272,"name":"min_query_length","definition":"sub","containerName":"main::","range":{"end":{"line":2289,"character":9999},"start":{"character":0,"line":2272}}},{"definition":"sub","name":"best_hit_only","containerName":"main::","range":{"end":{"line":2306,"character":9999},"start":{"line":2302,"character":0}},"kind":12,"children":[{"kind":13,"line":2303,"name":"$self","definition":"my","containerName":"best_hit_only","localvar":"my"},{"line":2304,"kind":13,"name":"$self","containerName":"best_hit_only"},{"line":2305,"kind":13,"containerName":"best_hit_only","name":"$self"}],"line":2302},{"range":{"end":{"line":2325,"character":9999},"start":{"line":2321,"character":0}},"containerName":"main::","name":"check_all_hits","definition":"sub","line":2321,"children":[{"localvar":"my","containerName":"check_all_hits","name":"$self","definition":"my","line":2322,"kind":13},{"kind":13,"line":2323,"name":"$self","containerName":"check_all_hits"},{"kind":13,"line":2324,"containerName":"check_all_hits","name":"$self"}],"kind":12},{"range":{"end":{"character":9999,"line":2382},"start":{"line":2380,"character":0}},"name":"_cleanup_hits","children":[{"definition":"my","name":"$self","containerName":"_cleanup_hits","localvar":"my","kind":13,"line":2381},{"line":2381,"kind":13,"name":"$hits","containerName":"_cleanup_hits"},{"kind":13,"line":2382,"definition":"my","name":"$v","containerName":"_cleanup_hits","localvar":"my"},{"line":2382,"kind":13,"containerName":"_cleanup_hits","name":"$hits"}],"line":2380,"kind":12,"signature":{"documentation":" commented out, using common base class util method\n=head2 _get_accession_version\n\n Title   : _get_accession_version\n Usage   : my ($acc,$ver) = &_get_accession_version($id)\n Function:Private function to get an accession,version pair\n           for an ID (if it is in NCBI format)\n Returns : 2-pule of accession, version\n Args    : ID string to process\n\n\n=cut\n\nsub _get_accession_version {\n    my $id = shift;\n\n    # handle case when this is accidently called as a class method\n    if ( ref($id) && $id->isa('Bio::SearchIO') ) {\n        $id = shift;\n    }\n    return unless defined $id;\n    my ( $acc, $version );\n    if ( $id =~ /(gb|emb|dbj|sp|pdb|bbs|ref|lcl)\\|(.*)\\|(.*)/ ) {\n        ( $acc, $version ) = split /\\./, $2;\n    }\n    elsif ( $id =~ /(pir|prf|pat|gnl)\\|(.*)\\|(.*)/ ) {\n        ( $acc, $version ) = split /\\./, $3;\n    }\n    else {\n\n        #punt, not matching the db's at ftp://ftp.ncbi.nih.gov/blast/db/README\n        #Database Name                     Identifier Syntax\n        #GenBank                           gb|accession|locus\n        #EMBL Data Library                 emb|accession|locus\n        #DDBJ, DNA Database of Japan       dbj|accession|locus\n        #NBRF PIR                          pir||entry\n        #Protein Research Foundation       prf||name\n        #SWISS-PROT                        sp|accession|entry name\n        #Brookhaven Protein Data Bank      pdb|entry|chain\n        #Patents                           pat|country|number\n        #GenInfo Backbone Id               bbs|number\n        #General database identifier           gnl|database|identifier\n        #NCBI Reference Sequence           ref|accession|locus\n        #Local Sequence identifier         lcl|identifier\n        $acc = $id;\n    }\n    return ( $acc, $version );\n}\n general private method used to make minimal hits from leftover\n data in the hit table","parameters":[{"label":"$self"},{"label":"$hits"}],"label":"_cleanup_hits($self,$hits)"},"detail":"($self,$hits)","definition":"sub","containerName":"main::"},{"name":"$v","containerName":null,"line":2383,"kind":13},{"containerName":null,"name":"$self","line":2384,"kind":13},{"name":"start_element","containerName":"main::","kind":12,"line":2384},{"localvar":"my","containerName":null,"name":"$id","definition":"my","line":2385,"kind":13},{"line":2385,"kind":13,"name":"@v","containerName":null},{"localvar":"my","containerName":null,"definition":"my","name":"$desc","line":2386,"kind":13},{"containerName":null,"name":"@v","kind":13,"line":2386},{"containerName":null,"name":"$self","kind":13,"line":2387},{"line":2387,"kind":12,"containerName":"main::","name":"element"},{"containerName":null,"name":"$id","kind":13,"line":2391},{"localvar":"my","containerName":null,"name":"$gi","definition":"my","line":2393,"kind":13},{"line":2393,"kind":13,"name":"$acc","containerName":null},{"kind":13,"line":2393,"name":"$version","containerName":null},{"line":2393,"kind":13,"containerName":null,"name":"$self"},{"name":"_get_seq_identifiers","containerName":"main::","line":2393,"kind":12},{"containerName":null,"name":"$id","kind":13,"line":2393},{"name":"$self","containerName":null,"line":2394,"kind":13},{"containerName":"main::","name":"element","line":2394,"kind":12},{"name":"$acc","containerName":null,"kind":13,"line":2398},{"kind":13,"line":2400,"name":"%v","containerName":null},{"containerName":null,"name":"$self","kind":13,"line":2401},{"containerName":"main::","name":"element","line":2401,"kind":12},{"kind":13,"line":2404,"name":"@v","containerName":null},{"name":"%self","containerName":null,"line":2407,"kind":13},{"containerName":null,"name":"$self","kind":13,"line":2408},{"containerName":"main::","name":"element","kind":12,"line":2408},{"name":"@v","containerName":null,"line":2411,"kind":13},{"line":2415,"kind":13,"containerName":null,"name":"$self"},{"name":"element","containerName":"main::","line":2415,"kind":12},{"kind":13,"line":2418,"name":"@v","containerName":null},{"containerName":null,"name":"$self","kind":13,"line":2424},{"line":2424,"kind":12,"name":"element","containerName":"main::"},{"containerName":null,"name":"$desc","line":2428,"kind":13},{"name":"$self","containerName":null,"line":2430,"kind":13},{"containerName":"main::","name":"end_element","line":2430,"kind":12}]}