{"vars":[{"containerName":"","name":"vars","kind":2,"line":108},{"kind":13,"line":114,"containerName":null,"name":"$Revision"},{"kind":13,"line":115,"containerName":null,"name":"$DATE"},{"kind":13,"line":116,"name":"%RemoteURLDefault","containerName":null},{"containerName":null,"name":"$MaxDescLen","kind":13,"line":120},{"containerName":null,"name":"$AlignmentLineWidth","kind":13,"line":121},{"name":"base","containerName":"","kind":2,"line":125},{"name":"new","range":{"end":{"line":164,"character":9999},"start":{"line":144,"character":0}},"kind":12,"line":144,"children":[{"definition":"my","name":"$class","containerName":"new","localvar":"my","kind":13,"line":145},{"line":145,"kind":13,"name":"@args","containerName":"new"},{"definition":"my","name":"$self","containerName":"new","localvar":"my","kind":13,"line":147},{"name":"$class","containerName":"new","line":147,"kind":13},{"containerName":"new","name":"@args","kind":13,"line":147},{"kind":13,"line":148,"containerName":"new","name":"$p","definition":"my","localvar":"my"},{"name":"$n","containerName":"new","line":148,"kind":13},{"containerName":"new","name":"$filters","kind":13,"line":148},{"line":149,"kind":13,"containerName":"new","name":"$nowublastlinks"},{"line":149,"kind":13,"containerName":"new","name":"$self"},{"containerName":"new","name":"_rearrange","line":149,"kind":12},{"kind":13,"line":152,"name":"@args","containerName":"new"},{"kind":13,"line":153,"containerName":"new","name":"$self"},{"kind":12,"line":153,"name":"remote_database_url","containerName":"new"},{"line":153,"kind":13,"containerName":"new","name":"$p"},{"kind":13,"line":153,"name":"$RemoteURLDefault","containerName":"new"},{"line":154,"kind":13,"containerName":"new","name":"$self"},{"name":"remote_database_url","containerName":"new","line":154,"kind":12},{"kind":13,"line":154,"name":"$n","containerName":"new"},{"line":154,"kind":13,"name":"$RemoteURLDefault","containerName":"new"},{"kind":13,"line":155,"name":"$self","containerName":"new"},{"name":"no_wublastlinks","containerName":"new","line":155,"kind":12},{"line":155,"kind":13,"containerName":"new","name":"$nowublastlinks"},{"containerName":"new","name":"$filters","kind":13,"line":156},{"name":"$filters","containerName":"new","line":157,"kind":13},{"containerName":"new","name":"$self","line":158,"kind":13},{"line":158,"kind":12,"name":"warn","containerName":"new"},{"kind":13,"line":160,"definition":"my","name":"$type","containerName":"new","localvar":"my"},{"kind":13,"line":160,"name":"$code","containerName":"new"},{"line":160,"kind":13,"containerName":"new","name":"$filters"},{"line":161,"kind":13,"containerName":"new","name":"$self"},{"containerName":"new","name":"filter","line":161,"kind":12},{"name":"$type","containerName":"new","line":161,"kind":13},{"name":"$code","containerName":"new","kind":13,"line":161}],"containerName":"main::","definition":"sub","detail":"($class,@args)","signature":{"label":"new($class,@args)","parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: HTMLResultWriter.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::Writer::HTMLResultWriter\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# Changes 2003-07-31 (jason)\n# Gary has cleaned up the code a lot to produce better looking HTML\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::Writer::HTMLResultWriter - write a Bio::Search::ResultI in HTML\n\n=head1 SYNOPSIS\n\n  use Bio::SearchIO;\n  use Bio::SearchIO::Writer::HTMLResultWriter;\n\n  my $in = Bio::SearchIO->new(-format => 'blast',\n\t\t\t     -file   => shift @ARGV);\n\n  my $writer = Bio::SearchIO::Writer::HTMLResultWriter->new();\n  my $out = Bio::SearchIO->new(-writer => $writer);\n  $out->write_result($in->next_result);\n\n\n  # to filter your output\n  my $MinLength = 100; # need a variable with scope outside the method\n  sub hsp_filter { \n      my $hsp = shift;\n      return 1 if $hsp->length('total') > $MinLength;\n  }\n  sub result_filter { \n      my $result = shift;\n      return $hsp->num_hits > 0;\n  }\n\n  my $writer = Bio::SearchIO::Writer::HTMLResultWriter->new\n                     (-filters => { 'HSP' => \\&hsp_filter} );\n  my $out = Bio::SearchIO->new(-writer => $writer);\n  $out->write_result($in->next_result);\n\n  # can also set the filter via the writer object\n  $writer->filter('RESULT', \\&result_filter);\n\n=head1 DESCRIPTION\n\nThis object implements the SearchWriterI interface which will produce\na set of HTML for a specific L<Bio::Search::Report::ReportI> interface.\n\nSee L<Bio::SearchIO::SearchWriterI> for more info on the filter method.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nGary Williams G.Williams@hgmp.mrc.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\npackage Bio::SearchIO::Writer::HTMLResultWriter;\nuse strict;\nuse vars qw(%RemoteURLDefault\n            $MaxDescLen $DATE $AlignmentLineWidth $Revision);\n\n# Object preamble - inherits from Bio::Root::RootI\n\nBEGIN {\n    $Revision = '$Id: HTMLResultWriter.pm 16123 2009-09-17 12:57:27Z cjfields $';\n    $DATE = localtime(time);\n    %RemoteURLDefault = ( \n      'PROTEIN' => 'http://www.ncbi.nlm.nih.gov/entrez/query.fcgi?db=protein&cmd=search&term=%s',\t\t\t  \n      'NUCLEOTIDE' => 'http://www.ncbi.nlm.nih.gov/entrez/query.fcgi?db=nucleotide&cmd=search&term=%s'\n    );\n    $MaxDescLen = 60;\n    $AlignmentLineWidth = 60;\n}\n\n\nuse base qw(Bio::Root::Root Bio::SearchIO::SearchWriterI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::Writer::HTMLResultWriter->new();\n Function: Builds a new Bio::SearchIO::Writer::HTMLResultWriter object \n Returns : Bio::SearchIO::Writer::HTMLResultWriter\n Args    : -filters => hashref with any or all of the keys (HSP HIT RESULT)\n           which have values pointing to a subroutine reference\n           which will expect to get a \n           -nucleotide_url => URL sprintf string base for the nt sequences\n           -protein_url => URL sprintf string base for the aa sequences\n           -no_wublastlinks => boolean. Do not display WU-BLAST lines \n                               even if they are parsed out.\n                               Links = (1) "}},{"kind":12,"line":147,"name":"SUPER","containerName":"new"},{"kind":13,"line":166,"containerName":null,"name":"$self"},{"definition":"sub","containerName":"main::","signature":{"label":"remote_database_url($self,$type,$value)","documentation":"1;\n# $Id: HTMLResultWriter.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::Writer::HTMLResultWriter\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# Changes 2003-07-31 (jason)\n# Gary has cleaned up the code a lot to produce better looking HTML\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::Writer::HTMLResultWriter - write a Bio::Search::ResultI in HTML\n\n=head1 SYNOPSIS\n\n  use Bio::SearchIO;\n  use Bio::SearchIO::Writer::HTMLResultWriter;\n\n  my $in = Bio::SearchIO->new(-format => 'blast',\n\t\t\t     -file   => shift @ARGV);\n\n  my $writer = Bio::SearchIO::Writer::HTMLResultWriter->new();\n  my $out = Bio::SearchIO->new(-writer => $writer);\n  $out->write_result($in->next_result);\n\n\n  # to filter your output\n  my $MinLength = 100; # need a variable with scope outside the method\n  sub hsp_filter { \n      my $hsp = shift;\n      return 1 if $hsp->length('total') > $MinLength;\n  }\n  sub result_filter { \n      my $result = shift;\n      return $hsp->num_hits > 0;\n  }\n\n  my $writer = Bio::SearchIO::Writer::HTMLResultWriter->new\n                     (-filters => { 'HSP' => \\&hsp_filter} );\n  my $out = Bio::SearchIO->new(-writer => $writer);\n  $out->write_result($in->next_result);\n\n  # can also set the filter via the writer object\n  $writer->filter('RESULT', \\&result_filter);\n\n=head1 DESCRIPTION\n\nThis object implements the SearchWriterI interface which will produce\na set of HTML for a specific L<Bio::Search::Report::ReportI> interface.\n\nSee L<Bio::SearchIO::SearchWriterI> for more info on the filter method.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nGary Williams G.Williams@hgmp.mrc.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\npackage Bio::SearchIO::Writer::HTMLResultWriter;\nuse strict;\nuse vars qw(%RemoteURLDefault\n            $MaxDescLen $DATE $AlignmentLineWidth $Revision);\n\n# Object preamble - inherits from Bio::Root::RootI\n\nBEGIN {\n    $Revision = '$Id: HTMLResultWriter.pm 16123 2009-09-17 12:57:27Z cjfields $';\n    $DATE = localtime(time);\n    %RemoteURLDefault = ( \n      'PROTEIN' => 'http://www.ncbi.nlm.nih.gov/entrez/query.fcgi?db=protein&cmd=search&term=%s',\t\t\t  \n      'NUCLEOTIDE' => 'http://www.ncbi.nlm.nih.gov/entrez/query.fcgi?db=nucleotide&cmd=search&term=%s'\n    );\n    $MaxDescLen = 60;\n    $AlignmentLineWidth = 60;\n}\n\n\nuse base qw(Bio::Root::Root Bio::SearchIO::SearchWriterI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::Writer::HTMLResultWriter->new();\n Function: Builds a new Bio::SearchIO::Writer::HTMLResultWriter object \n Returns : Bio::SearchIO::Writer::HTMLResultWriter\n Args    : -filters => hashref with any or all of the keys (HSP HIT RESULT)\n           which have values pointing to a subroutine reference\n           which will expect to get a \n           -nucleotide_url => URL sprintf string base for the nt sequences\n           -protein_url => URL sprintf string base for the aa sequences\n           -no_wublastlinks => boolean. Do not display WU-BLAST lines \n                               even if they are parsed out.\n                               Links = (1) \n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($p,$n,$filters,\n      $nowublastlinks) = $self->_rearrange([qw(PROTEIN_URL \n\t\t\t\t\t       NUCLEOTIDE_URL \n\t\t\t\t\t       FILTERS\n\t\t\t\t\t       NO_WUBLASTLINKS)],@args);\n  $self->remote_database_url('p',$p || $RemoteURLDefault{'PROTEIN'});\n  $self->remote_database_url('n',$n || $RemoteURLDefault{'NUCLEOTIDE'});\n  $self->no_wublastlinks(! $nowublastlinks);\n  if( defined $filters ) {\n      if( !ref($filters) =~ /HASH/i ) { \n\t  $self->warn(\"Did not provide a hashref for the FILTERS option, ignoring.\");\n      } else { \n\t  while( my ($type,$code) = each %{$filters} ) {\n\t      $self->filter($type,$code);\n\t  }\n      }\n  }\n\n  return $self;\n}\n\n=head2 remote_database_url\n\n Title   : remote_database_url\n Usage   : $obj->remote_database_url($type,$newval)\n Function: This should return or set a string that contains a %s which can be\n           filled in with sprintf.\n Returns : value of remote_database_url\n Args    : $type - 'PROTEIN' or 'P' for protein URLS\n                   'NUCLEOTIDE' or 'N' for nucleotide URLS\n           $value - new value to set [optional]","parameters":[{"label":"$self"},{"label":"$type"},{"label":"$value"}]},"detail":"($self,$type,$value)","kind":12,"children":[{"line":184,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"remote_database_url"},{"name":"$type","containerName":"remote_database_url","kind":13,"line":184},{"name":"$value","containerName":"remote_database_url","line":184,"kind":13},{"kind":13,"line":185,"name":"$type","containerName":"remote_database_url"},{"kind":13,"line":185,"name":"$type","containerName":"remote_database_url"},{"name":"$self","containerName":"remote_database_url","line":186,"kind":13},{"kind":12,"line":186,"containerName":"remote_database_url","name":"warn"},{"line":189,"kind":13,"name":"$type","containerName":"remote_database_url"},{"containerName":"remote_database_url","name":"$value","line":190,"kind":13},{"containerName":"remote_database_url","name":"$self","kind":13,"line":191},{"containerName":"remote_database_url","name":"$type","kind":13,"line":191},{"containerName":"remote_database_url","name":"$value","kind":13,"line":191},{"kind":13,"line":193,"containerName":"remote_database_url","name":"$self"},{"name":"$type","containerName":"remote_database_url","line":193,"kind":13}],"line":183,"name":"remote_database_url","range":{"end":{"character":9999,"line":194},"start":{"character":0,"line":183}}},{"signature":{"documentation":"1;\n# $Id: HTMLResultWriter.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::Writer::HTMLResultWriter\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# Changes 2003-07-31 (jason)\n# Gary has cleaned up the code a lot to produce better looking HTML\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::Writer::HTMLResultWriter - write a Bio::Search::ResultI in HTML\n\n=head1 SYNOPSIS\n\n  use Bio::SearchIO;\n  use Bio::SearchIO::Writer::HTMLResultWriter;\n\n  my $in = Bio::SearchIO->new(-format => 'blast',\n\t\t\t     -file   => shift @ARGV);\n\n  my $writer = Bio::SearchIO::Writer::HTMLResultWriter->new();\n  my $out = Bio::SearchIO->new(-writer => $writer);\n  $out->write_result($in->next_result);\n\n\n  # to filter your output\n  my $MinLength = 100; # need a variable with scope outside the method\n  sub hsp_filter { \n      my $hsp = shift;\n      return 1 if $hsp->length('total') > $MinLength;\n  }\n  sub result_filter { \n      my $result = shift;\n      return $hsp->num_hits > 0;\n  }\n\n  my $writer = Bio::SearchIO::Writer::HTMLResultWriter->new\n                     (-filters => { 'HSP' => \\&hsp_filter} );\n  my $out = Bio::SearchIO->new(-writer => $writer);\n  $out->write_result($in->next_result);\n\n  # can also set the filter via the writer object\n  $writer->filter('RESULT', \\&result_filter);\n\n=head1 DESCRIPTION\n\nThis object implements the SearchWriterI interface which will produce\na set of HTML for a specific L<Bio::Search::Report::ReportI> interface.\n\nSee L<Bio::SearchIO::SearchWriterI> for more info on the filter method.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nGary Williams G.Williams@hgmp.mrc.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\npackage Bio::SearchIO::Writer::HTMLResultWriter;\nuse strict;\nuse vars qw(%RemoteURLDefault\n            $MaxDescLen $DATE $AlignmentLineWidth $Revision);\n\n# Object preamble - inherits from Bio::Root::RootI\n\nBEGIN {\n    $Revision = '$Id: HTMLResultWriter.pm 16123 2009-09-17 12:57:27Z cjfields $';\n    $DATE = localtime(time);\n    %RemoteURLDefault = ( \n      'PROTEIN' => 'http://www.ncbi.nlm.nih.gov/entrez/query.fcgi?db=protein&cmd=search&term=%s',\t\t\t  \n      'NUCLEOTIDE' => 'http://www.ncbi.nlm.nih.gov/entrez/query.fcgi?db=nucleotide&cmd=search&term=%s'\n    );\n    $MaxDescLen = 60;\n    $AlignmentLineWidth = 60;\n}\n\n\nuse base qw(Bio::Root::Root Bio::SearchIO::SearchWriterI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::Writer::HTMLResultWriter->new();\n Function: Builds a new Bio::SearchIO::Writer::HTMLResultWriter object \n Returns : Bio::SearchIO::Writer::HTMLResultWriter\n Args    : -filters => hashref with any or all of the keys (HSP HIT RESULT)\n           which have values pointing to a subroutine reference\n           which will expect to get a \n           -nucleotide_url => URL sprintf string base for the nt sequences\n           -protein_url => URL sprintf string base for the aa sequences\n           -no_wublastlinks => boolean. Do not display WU-BLAST lines \n                               even if they are parsed out.\n                               Links = (1) \n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($p,$n,$filters,\n      $nowublastlinks) = $self->_rearrange([qw(PROTEIN_URL \n\t\t\t\t\t       NUCLEOTIDE_URL \n\t\t\t\t\t       FILTERS\n\t\t\t\t\t       NO_WUBLASTLINKS)],@args);\n  $self->remote_database_url('p',$p || $RemoteURLDefault{'PROTEIN'});\n  $self->remote_database_url('n',$n || $RemoteURLDefault{'NUCLEOTIDE'});\n  $self->no_wublastlinks(! $nowublastlinks);\n  if( defined $filters ) {\n      if( !ref($filters) =~ /HASH/i ) { \n\t  $self->warn(\"Did not provide a hashref for the FILTERS option, ignoring.\");\n      } else { \n\t  while( my ($type,$code) = each %{$filters} ) {\n\t      $self->filter($type,$code);\n\t  }\n      }\n  }\n\n  return $self;\n}\n\n=head2 remote_database_url\n\n Title   : remote_database_url\n Usage   : $obj->remote_database_url($type,$newval)\n Function: This should return or set a string that contains a %s which can be\n           filled in with sprintf.\n Returns : value of remote_database_url\n Args    : $type - 'PROTEIN' or 'P' for protein URLS\n                   'NUCLEOTIDE' or 'N' for nucleotide URLS\n           $value - new value to set [optional]\n\n\n\nsub remote_database_url{\n   my ($self,$type,$value) = @_;\n   if( ! defined $type || $type !~ /^(P|N)/i ) { \n       $self->warn(\"Must provide a type (PROTEIN or NUCLEOTIDE)\");\n       return '';\n   }\n   $type = uc $1;\n   if( defined $value) {\n      $self->{'remote_database_url'}->{$type} = $value;\n    }\n   return $self->{'remote_database_url'}->{$type};\n}\n\n=head2 to_string\n\n Purpose   : Produces data for each Search::Result::ResultI in a string.\n           : This is an abstract method. For some useful implementations,\n           : see ResultTableWriter.pm, HitTableWriter.pm, \n           : and HSPTableWriter.pm.\n Usage     : print $writer->to_string( $result_obj, @args );\n Argument  : $result_obj = A Bio::Search::Result::ResultI object\n           : @args = any additional arguments used by your implementation.\n Returns   : String containing data for each search Result or any of its\n           : sub-objects (Hits and HSPs).\n Throws    : n/a","parameters":[{"label":"$self"},{"label":"$result"},{"label":"$num"}],"label":"to_string($self,$result,$num)"},"detail":"($self,$result,$num)","definition":"sub","containerName":"main::","children":[{"line":212,"kind":13,"localvar":"my","containerName":"to_string","name":"$self","definition":"my"},{"containerName":"to_string","name":"$result","line":212,"kind":13},{"containerName":"to_string","name":"$num","kind":13,"line":212},{"kind":13,"line":213,"name":"$num","containerName":"to_string"},{"containerName":"to_string","name":"$result","kind":13,"line":214},{"localvar":"my","name":"$links","definition":"my","containerName":"to_string","line":215,"kind":13},{"line":215,"kind":13,"containerName":"to_string","name":"$self"},{"kind":12,"line":215,"containerName":"to_string","name":"no_wublastlinks"},{"containerName":"to_string","definition":"my","name":"$resultfilter","localvar":"my","kind":13,"line":216},{"name":"$hitfilter","containerName":"to_string","kind":13,"line":216},{"name":"$hspfilter","containerName":"to_string","kind":13,"line":216},{"line":216,"kind":13,"name":"$self","containerName":"to_string"},{"name":"filter","containerName":"to_string","kind":12,"line":216},{"containerName":"to_string","name":"$self","line":217,"kind":13},{"containerName":"to_string","name":"filter","kind":12,"line":217},{"containerName":"to_string","name":"$self","line":218,"kind":13},{"line":218,"kind":12,"name":"filter","containerName":"to_string"},{"kind":13,"line":219,"name":"$resultfilter","containerName":"to_string"},{"line":219,"kind":13,"containerName":"to_string","name":"$resultfilter"}],"line":211,"kind":12,"range":{"end":{"line":219,"character":9999},"start":{"character":0,"line":211}},"name":"to_string"},{"line":219,"kind":13,"name":"$result","containerName":null},{"line":221,"kind":13,"localvar":"my","containerName":null,"definition":"my","name":"$qtype"},{"name":"$dbtype","containerName":null,"kind":13,"line":221},{"line":221,"kind":13,"containerName":null,"name":"$dbseqtype"},{"containerName":null,"name":"$type","kind":13,"line":221},{"line":222,"kind":13,"localvar":"my","containerName":null,"definition":"my","name":"$alg"},{"name":"$result","containerName":null,"line":222,"kind":13},{"containerName":"main::","name":"algorithm","line":222,"kind":12},{"name":"%alg","containerName":null,"line":224,"kind":13},{"line":225,"kind":13,"name":"$qtype","containerName":null},{"name":"$dbtype","containerName":null,"kind":13,"line":225},{"containerName":null,"name":"$dbseqtype","kind":13,"line":226},{"line":226,"kind":13,"containerName":null,"name":"$type"},{"containerName":null,"name":"%alg","kind":13,"line":227},{"name":"$qtype","containerName":null,"line":228,"kind":13},{"containerName":null,"name":"$dbtype","kind":13,"line":229},{"name":"$type","containerName":null,"line":230,"kind":13},{"containerName":null,"name":"$dbseqtype","kind":13,"line":231},{"line":232,"kind":13,"containerName":null,"name":"$alg"},{"containerName":null,"name":"%alg","kind":13,"line":233},{"line":234,"kind":13,"name":"$qtype","containerName":null},{"containerName":null,"name":"$dbtype","kind":13,"line":234},{"name":"$type","containerName":null,"kind":13,"line":235},{"line":235,"kind":13,"name":"$dbseqtype","containerName":null},{"kind":13,"line":236,"containerName":null,"name":"$alg"},{"name":"%alg","containerName":null,"kind":13,"line":237},{"line":238,"kind":13,"containerName":null,"name":"$qtype"},{"containerName":null,"name":"$dbtype","line":238,"kind":13},{"name":"$type","containerName":null,"kind":13,"line":239},{"containerName":null,"name":"$dbseqtype","kind":13,"line":239},{"name":"%alg","containerName":null,"kind":13,"line":240},{"kind":13,"line":241,"containerName":null,"name":"$qtype"},{"kind":13,"line":242,"name":"$dbtype","containerName":null},{"containerName":null,"name":"$dbseqtype","line":243,"kind":13},{"name":"%type","containerName":null,"kind":13,"line":243},{"containerName":null,"name":"$self","line":245,"kind":13},{"line":245,"kind":12,"name":"warn","containerName":"main::"},{"kind":13,"line":245,"name":"$result","containerName":null},{"line":245,"kind":12,"containerName":"main::","name":"algorithm"},{"kind":13,"line":249,"containerName":null,"definition":"my","name":"%baselens","localvar":"my"},{"kind":13,"line":249,"name":"$dbtype","containerName":null},{"kind":13,"line":250,"name":"$qtype","containerName":null},{"localvar":"my","containerName":null,"definition":"my","name":"$str","line":252,"kind":13},{"name":"%num","containerName":null,"line":253,"kind":13},{"line":254,"kind":13,"name":"$str","containerName":null},{"name":"$self","containerName":null,"line":254,"kind":13},{"containerName":"main::","name":"start_report","line":254,"kind":12},{"kind":13,"line":254,"containerName":null,"name":"$result"},{"kind":13,"line":257,"containerName":null,"name":"$str"},{"line":257,"kind":13,"containerName":null,"name":"$self"},{"kind":12,"line":257,"name":"title","containerName":"main::"},{"line":257,"kind":13,"containerName":null,"name":"$result"},{"containerName":null,"name":"$str","kind":13,"line":259},{"line":259,"kind":13,"name":"$result","containerName":null},{"containerName":"main::","name":"algorithm_reference","line":259,"kind":12},{"name":"$self","containerName":null,"line":259,"kind":13},{"name":"algorithm_reference","containerName":"main::","kind":12,"line":259},{"name":"$result","containerName":null,"kind":13,"line":259},{"containerName":null,"name":"$str","line":260,"kind":13},{"line":260,"kind":13,"containerName":null,"name":"$self"},{"containerName":"main::","name":"introduction","line":260,"kind":12},{"kind":13,"line":260,"containerName":null,"name":"$result"},{"line":262,"kind":13,"name":"$str","containerName":null},{"line":266,"kind":13,"localvar":"my","definition":"my","name":"$hspstr","containerName":null},{"kind":13,"line":267,"name":"$result","containerName":null},{"containerName":"main::","name":"can","kind":12,"line":267},{"line":268,"kind":13,"containerName":null,"name":"$result"},{"kind":12,"line":268,"containerName":"main::","name":"rewind"},{"localvar":"my","containerName":null,"definition":"my","name":"$hit","line":271,"kind":13},{"kind":13,"line":271,"name":"$result","containerName":null},{"containerName":"main::","name":"next_hit","line":271,"kind":12},{"kind":13,"line":272,"containerName":null,"name":"$hitfilter"},{"name":"$hitfilter","containerName":null,"line":272,"kind":13},{"line":272,"kind":13,"name":"$hit","containerName":null},{"localvar":"my","definition":"my","name":"$nm","containerName":null,"line":273,"kind":13},{"kind":13,"line":273,"name":"$hit","containerName":null},{"containerName":"main::","name":"name","line":273,"kind":12},{"containerName":null,"name":"$self","line":275,"kind":13},{"kind":12,"line":275,"containerName":"main::","name":"debug"},{"kind":13,"line":275,"containerName":null,"name":"$hit"},{"line":275,"kind":12,"name":"description","containerName":"main::"},{"name":"$nm","containerName":null,"kind":13,"line":276},{"kind":13,"line":277,"containerName":null,"definition":"my","name":"$gi","localvar":"my"},{"line":277,"kind":13,"name":"$acc","containerName":null},{"name":"$self","containerName":null,"line":277,"kind":13},{"line":277,"kind":12,"name":"id_parser","containerName":"main::"},{"containerName":null,"name":"$nm","kind":13,"line":277},{"name":"$p","definition":"my","containerName":null,"localvar":"my","kind":13,"line":278},{"line":279,"kind":13,"localvar":"my","definition":"my","name":"$descsub","containerName":null},{"containerName":null,"name":"$hit","line":280,"kind":13},{"line":280,"kind":12,"name":"description","containerName":"main::"},{"line":280,"kind":13,"containerName":null,"name":"%MaxDescLen"},{"kind":13,"line":281,"name":"$descsub","containerName":null},{"containerName":null,"name":"$p","kind":13,"line":281},{"line":282,"kind":13,"name":"$hit","containerName":null},{"name":"description","containerName":"main::","line":282,"kind":12},{"kind":13,"line":282,"containerName":null,"name":"%MaxDescLen"},{"kind":13,"line":284,"name":"$descsub","containerName":null},{"line":284,"kind":13,"containerName":null,"name":"$p"},{"kind":13,"line":284,"name":"$hit","containerName":null},{"name":"description","containerName":"main::","kind":12,"line":284},{"localvar":"my","containerName":null,"definition":"my","name":"$url_desc","line":287,"kind":13},{"name":"$self","containerName":null,"line":287,"kind":13},{"kind":12,"line":287,"name":"hit_link_desc","containerName":"main::"},{"line":287,"kind":13,"name":"$self","containerName":null},{"name":"$hit","containerName":null,"kind":13,"line":287},{"containerName":null,"name":"$result","kind":13,"line":287},{"localvar":"my","definition":"my","name":"$url_align","containerName":null,"line":288,"kind":13},{"containerName":null,"name":"$self","kind":13,"line":288},{"kind":12,"line":288,"name":"hit_link_align","containerName":"main::"},{"name":"$self","containerName":null,"kind":13,"line":288},{"line":288,"kind":13,"name":"$hit","containerName":null},{"line":288,"kind":13,"containerName":null,"name":"$result"},{"kind":13,"line":290,"definition":"my","name":"@hsps","containerName":null,"localvar":"my"},{"name":"$hit","containerName":null,"line":290,"kind":13},{"line":290,"kind":12,"name":"hsps","containerName":"main::"},{"containerName":null,"name":"@hsps","line":292,"kind":13},{"line":294,"kind":13,"name":"$str","containerName":null},{"kind":13,"line":295,"containerName":null,"name":"$url_desc"},{"kind":13,"line":295,"containerName":null,"name":"$descsub"},{"containerName":null,"name":"$hit","kind":13,"line":296},{"line":296,"kind":12,"containerName":"main::","name":"bits"},{"line":296,"kind":13,"name":"$hit","containerName":null},{"name":"bits","containerName":"main::","line":296,"kind":12},{"name":"@hsps","containerName":null,"kind":13,"line":297},{"line":297,"kind":13,"name":"@hsps","containerName":null},{"kind":12,"line":297,"name":"bits","containerName":"main::"},{"containerName":null,"name":"$hit","line":298,"kind":13},{"kind":12,"line":298,"name":"significance","containerName":"main::"},{"line":298,"kind":13,"containerName":null,"name":"$hit"},{"name":"significance","containerName":"main::","line":298,"kind":12},{"name":"@hsps","containerName":null,"line":299,"kind":13},{"line":299,"kind":13,"containerName":null,"name":"@hsps"},{"line":299,"kind":12,"containerName":"main::","name":"evalue"},{"kind":13,"line":305,"name":"$str","containerName":null},{"kind":13,"line":306,"containerName":null,"name":"$url_desc"},{"line":306,"kind":13,"name":"$descsub","containerName":null},{"containerName":null,"name":"$hit","line":307,"kind":13},{"kind":12,"line":307,"containerName":"main::","name":"bits"},{"kind":13,"line":307,"containerName":null,"name":"$hit"},{"kind":12,"line":307,"name":"bits","containerName":"main::"},{"kind":13,"line":308,"name":"@hsps","containerName":null},{"line":308,"kind":13,"name":"@hsps","containerName":null},{"line":308,"kind":12,"containerName":"main::","name":"bits"},{"kind":13,"line":309,"name":"$acc","containerName":null},{"kind":13,"line":310,"containerName":null,"name":"$hit"},{"line":310,"kind":12,"name":"significance","containerName":"main::"},{"name":"$hit","containerName":null,"line":310,"kind":13},{"line":310,"kind":12,"name":"significance","containerName":"main::"},{"kind":13,"line":311,"name":"@hsps","containerName":null},{"containerName":null,"name":"@hsps","kind":13,"line":311},{"name":"evalue","containerName":"main::","kind":12,"line":311},{"kind":13,"line":313,"containerName":null,"name":"$dline","definition":"my","localvar":"my"},{"kind":13,"line":313,"containerName":null,"name":"$self"},{"containerName":"main::","name":"hit_desc_line","kind":12,"line":313},{"name":"$self","containerName":null,"kind":13,"line":313},{"kind":13,"line":313,"name":"$hit","containerName":null},{"name":"$result","containerName":null,"kind":13,"line":313},{"containerName":null,"name":"$hspstr","kind":13,"line":314},{"kind":13,"line":315,"name":"$url_align","containerName":null},{"name":"$dline","containerName":null,"line":316,"kind":13},{"name":"_numwithcommas","line":316,"kind":12},{"line":316,"kind":13,"name":"$hit","containerName":null},{"kind":12,"line":316,"name":"length","containerName":"main::"},{"kind":13,"line":317,"containerName":null,"definition":"my","name":"$ct","localvar":"my"},{"containerName":null,"name":"$hsp","definition":"my","localvar":"my","kind":13,"line":318},{"containerName":null,"name":"@hsps","line":318,"kind":13},{"containerName":null,"name":"$hspfilter","kind":13,"line":319},{"containerName":null,"name":"$hspfilter","line":319,"kind":13},{"line":319,"kind":13,"containerName":null,"name":"$hsp"},{"kind":13,"line":320,"name":"$hspstr","containerName":null},{"line":321,"kind":13,"containerName":null,"name":"$hsp"},{"kind":12,"line":321,"containerName":"main::","name":"bits"},{"containerName":null,"name":"$hsp","kind":13,"line":321},{"containerName":"main::","name":"score","kind":12,"line":321},{"line":322,"kind":13,"containerName":null,"name":"$hsp"},{"kind":12,"line":322,"name":"score","containerName":"main::"},{"containerName":null,"name":"$hsp","line":322,"kind":13},{"line":322,"kind":12,"containerName":"main::","name":"bits"},{"kind":13,"line":323,"name":"$hsp","containerName":null},{"containerName":"main::","name":"evalue","kind":12,"line":323},{"kind":13,"line":324,"name":"$hsp","containerName":null},{"kind":12,"line":324,"containerName":"main::","name":"pvalue"},{"line":325,"kind":13,"containerName":null,"name":"$hspstr"},{"name":"$hsp","containerName":null,"line":325,"kind":13},{"kind":12,"line":325,"name":"pvalue","containerName":"main::"},{"line":327,"kind":13,"containerName":null,"name":"$hspstr"},{"name":"$hspstr","containerName":null,"line":328,"kind":13},{"name":"$hsp","containerName":null,"line":329,"kind":13},{"name":"frac_identical","containerName":"main::","kind":12,"line":329},{"kind":13,"line":330,"containerName":null,"name":"$hsp"},{"kind":12,"line":330,"containerName":"main::","name":"length"},{"name":"$hsp","containerName":null,"kind":13,"line":331},{"line":331,"kind":12,"name":"length","containerName":"main::"},{"containerName":null,"name":"$hsp","kind":13,"line":332},{"line":332,"kind":12,"containerName":"main::","name":"frac_identical"},{"containerName":null,"name":"%type","line":334,"kind":13},{"line":335,"kind":13,"name":"$hspstr","containerName":null},{"containerName":null,"name":"$hsp","line":336,"kind":13},{"line":336,"kind":12,"containerName":"main::","name":"frac_conserved"},{"containerName":null,"name":"$hsp","line":337,"kind":13},{"line":337,"kind":12,"name":"length","containerName":"main::"},{"line":338,"kind":13,"containerName":null,"name":"$hsp"},{"line":338,"kind":12,"containerName":"main::","name":"length"},{"line":339,"kind":13,"containerName":null,"name":"$hsp"},{"kind":12,"line":339,"name":"frac_conserved","containerName":"main::"},{"name":"$hsp","containerName":null,"kind":13,"line":341},{"name":"gaps","containerName":"main::","kind":12,"line":341},{"kind":13,"line":342,"name":"$hspstr","containerName":null},{"name":"$hsp","containerName":null,"line":343,"kind":13},{"line":343,"kind":12,"name":"gaps","containerName":"main::"},{"name":"$hsp","containerName":null,"line":344,"kind":13},{"containerName":"main::","name":"length","kind":12,"line":344},{"containerName":null,"name":"$hsp","kind":13,"line":345},{"name":"gaps","containerName":"main::","line":345,"kind":12},{"kind":13,"line":346,"name":"$hsp","containerName":null},{"name":"length","containerName":"main::","kind":12,"line":346},{"localvar":"my","name":"$hframe","definition":"my","containerName":null,"line":349,"kind":13},{"kind":13,"line":349,"name":"$qframe","containerName":null},{"name":"$hsp","containerName":null,"line":349,"kind":13},{"kind":12,"line":349,"name":"hit","containerName":"main::"},{"name":"frame","containerName":"main::","kind":12,"line":349},{"containerName":null,"name":"$hsp","line":349,"kind":13},{"kind":12,"line":349,"containerName":"main::","name":"query"},{"containerName":"main::","name":"frame","line":349,"kind":12},{"line":350,"kind":13,"localvar":"my","containerName":null,"name":"$hstrand","definition":"my"},{"kind":13,"line":350,"name":"$qstrand","containerName":null},{"name":"$hsp","containerName":null,"line":350,"kind":13},{"kind":12,"line":350,"containerName":"main::","name":"hit"},{"line":350,"kind":12,"name":"strand","containerName":"main::"},{"containerName":null,"name":"$hsp","kind":13,"line":350},{"line":350,"kind":12,"containerName":"main::","name":"query"},{"name":"strand","containerName":"main::","line":350,"kind":12},{"kind":13,"line":354,"name":"$hstrand","containerName":null},{"kind":13,"line":354,"containerName":null,"name":"%qstrand"},{"kind":13,"line":355,"name":"$hspstr","containerName":null},{"line":356,"kind":13,"localvar":"my","definition":"my","name":"$signq","containerName":null},{"containerName":null,"name":"$signh","line":356,"kind":13},{"name":"%hstrand","containerName":null,"line":357,"kind":13},{"kind":13,"line":358,"containerName":null,"name":"%hframe"},{"name":"$signh","containerName":null,"line":362,"kind":13},{"line":362,"kind":13,"name":"$hstrand","containerName":null},{"containerName":null,"name":"%qstrand","line":364,"kind":13},{"name":"%qframe","containerName":null,"kind":13,"line":365},{"kind":13,"line":368,"name":"$signq","containerName":null},{"name":"$qstrand","containerName":null,"line":368,"kind":13},{"containerName":null,"name":"$hframe","kind":13,"line":373},{"containerName":null,"name":"%qframe","kind":13,"line":373},{"kind":13,"line":374,"name":"$hspstr","containerName":null},{"kind":13,"line":374,"containerName":null,"name":"$hframe"},{"line":375,"kind":13,"name":"$qframe","containerName":null},{"containerName":null,"name":"%hframe","line":375,"kind":13},{"kind":13,"line":376,"name":"$hspstr","containerName":null},{"containerName":null,"name":"%qframe","kind":13,"line":376},{"name":"$hspstr","containerName":null,"kind":13,"line":378},{"name":"$signq","containerName":null,"kind":13,"line":379},{"line":379,"kind":13,"name":"$qframe","containerName":null},{"containerName":null,"name":"$signh","line":380,"kind":13},{"name":"$hframe","containerName":null,"line":380,"kind":13},{"line":383,"kind":13,"name":"$links","containerName":null},{"line":384,"kind":13,"containerName":null,"name":"$hsp"},{"kind":12,"line":384,"containerName":"main::","name":"can"},{"kind":13,"line":384,"containerName":null,"definition":"my","name":"$lnks","localvar":"my"},{"kind":13,"line":384,"containerName":null,"name":"$hsp"},{"name":"links","containerName":"main::","kind":12,"line":384},{"kind":13,"line":385,"name":"$hspstr","containerName":null},{"line":385,"kind":13,"name":"$lnks","containerName":null},{"containerName":null,"name":"$hspstr","kind":13,"line":388},{"containerName":null,"name":"@hspvals","definition":"my","localvar":"my","kind":13,"line":390},{"kind":13,"line":391,"containerName":null,"name":"$hsp"},{"name":"query_string","containerName":"main::","line":391,"kind":12},{"containerName":null,"name":"$qstrand","kind":13,"line":392},{"kind":13,"line":393,"name":"$hsp","containerName":null},{"name":"query","containerName":"main::","kind":12,"line":393},{"kind":12,"line":393,"name":"start","containerName":"main::"},{"name":"$hsp","containerName":null,"line":394,"kind":13},{"containerName":"main::","name":"query","kind":12,"line":394},{"name":"end","containerName":"main::","kind":12,"line":394},{"line":395,"kind":13,"name":"$qstrand","containerName":null},{"kind":13,"line":396,"containerName":null,"name":"$hsp"},{"name":"query","containerName":"main::","line":396,"kind":12},{"name":"end","containerName":"main::","kind":12,"line":396},{"kind":13,"line":397,"name":"$hsp","containerName":null},{"name":"query","containerName":"main::","kind":12,"line":397},{"name":"start","containerName":"main::","line":397,"kind":12},{"name":"%qstrand","containerName":null,"line":399,"kind":13},{"line":401,"kind":12,"name":"x6"},{"containerName":null,"name":"$hsp","kind":13,"line":402},{"containerName":"main::","name":"homology_string","kind":12,"line":402},{"name":"$hsp","containerName":null,"kind":13,"line":409},{"line":409,"kind":12,"name":"hit_string","containerName":"main::"},{"kind":13,"line":410,"containerName":null,"name":"$hstrand"},{"kind":13,"line":411,"name":"$hsp","containerName":null},{"line":411,"kind":12,"name":"hit","containerName":"main::"},{"name":"start","containerName":"main::","line":411,"kind":12},{"name":"$hsp","containerName":null,"kind":13,"line":412},{"name":"hit","containerName":"main::","kind":12,"line":412},{"name":"end","containerName":"main::","line":412,"kind":12},{"name":"$hstrand","containerName":null,"line":413,"kind":13},{"kind":13,"line":414,"containerName":null,"name":"$hsp"},{"containerName":"main::","name":"hit","line":414,"kind":12},{"line":414,"kind":12,"containerName":"main::","name":"end"},{"line":415,"kind":13,"name":"$hsp","containerName":null},{"name":"hit","containerName":"main::","kind":12,"line":415},{"name":"start","containerName":"main::","line":415,"kind":12},{"name":"$hstrand","containerName":null,"line":417,"kind":13},{"kind":13,"line":426,"definition":"my","name":"%numwidth","containerName":null,"localvar":"my"},{"line":426,"kind":13,"containerName":null,"name":"$b"},{"kind":13,"line":426,"containerName":null,"name":"$a"},{"kind":13,"line":426,"containerName":null,"name":"@hspvals"},{"containerName":null,"name":"@hspvals","kind":13,"line":427},{"kind":13,"line":428,"name":"@hspvals","containerName":null},{"containerName":null,"name":"@hspvals","line":429,"kind":13},{"definition":"my","name":"$count","containerName":null,"localvar":"my","kind":13,"line":430},{"name":"$count","containerName":null,"kind":13,"line":431},{"line":431,"kind":13,"name":"$hsp","containerName":null},{"name":"length","containerName":"main::","line":431,"kind":12},{"line":432,"kind":13,"localvar":"my","containerName":null,"name":"$v","definition":"my"},{"name":"@hspvals","containerName":null,"line":432,"kind":13},{"line":433,"kind":13,"localvar":"my","name":"$piece","definition":"my","containerName":null},{"kind":13,"line":433,"name":"%v","containerName":null},{"name":"%v","containerName":null,"line":433,"kind":13},{"containerName":null,"name":"$count","kind":13,"line":433},{"kind":13,"line":434,"name":"$AlignmentLineWidth","containerName":null},{"kind":13,"line":435,"definition":"my","name":"$cp","containerName":null,"localvar":"my"},{"kind":13,"line":435,"name":"$piece","containerName":null},{"kind":13,"line":436,"containerName":null,"definition":"my","name":"$plen","localvar":"my"},{"containerName":null,"name":"$cp","kind":13,"line":436},{"localvar":"my","containerName":null,"name":"$start","definition":"my","line":437,"kind":13},{"containerName":null,"name":"$end","line":437,"kind":13},{"name":"%v","containerName":null,"kind":13,"line":438},{"name":"$start","containerName":null,"line":439,"kind":13},{"kind":13,"line":439,"containerName":null,"name":"%v"},{"localvar":"my","definition":"my","name":"$d","containerName":null,"line":442,"kind":13},{"name":"%v","containerName":null,"line":442,"kind":13},{"kind":13,"line":442,"name":"$AlignmentLineWidth","containerName":null},{"kind":13,"line":442,"containerName":null,"name":"$plen"},{"containerName":null,"name":"%baselens","kind":13,"line":443},{"line":443,"kind":13,"containerName":null,"name":"%v"},{"line":444,"kind":13,"containerName":null,"name":"$piece"},{"name":"%AlignmentLineWidth","containerName":null,"line":444,"kind":13},{"name":"$d","containerName":null,"line":445,"kind":13},{"containerName":null,"name":"$piece","kind":13,"line":445},{"containerName":null,"name":"$plen","kind":13,"line":445},{"line":445,"kind":13,"containerName":null,"name":"%v"},{"containerName":null,"name":"%baselens","kind":13,"line":446},{"name":"%v","containerName":null,"kind":13,"line":446},{"name":"$end","containerName":null,"line":448,"kind":13},{"containerName":null,"name":"%v","kind":13,"line":448},{"line":448,"kind":13,"containerName":null,"name":"$d"},{"kind":13,"line":448,"name":"%v","containerName":null},{"name":"%v","containerName":null,"line":449,"kind":13},{"kind":13,"line":449,"containerName":null,"name":"$d"},{"kind":13,"line":451,"name":"$hspstr","containerName":null},{"name":"$numwidth","containerName":null,"line":451,"kind":13},{"name":"%v","containerName":null,"line":452,"kind":13},{"name":"$start","containerName":null,"line":453,"kind":13},{"kind":13,"line":454,"name":"$piece","containerName":null},{"name":"$end","containerName":null,"kind":13,"line":456},{"kind":13,"line":458,"containerName":null,"name":"$count"},{"line":458,"kind":13,"name":"$AlignmentLineWidth","containerName":null},{"name":"$hspstr","containerName":null,"kind":13,"line":459},{"name":"$hspstr","containerName":null,"line":461,"kind":13},{"line":467,"kind":13,"containerName":null,"name":"$str"},{"kind":13,"line":467,"name":"$hspstr","containerName":null},{"kind":13,"line":468,"containerName":null,"name":"$pav","definition":"my","localvar":"my"},{"line":468,"kind":13,"name":"$sav","containerName":null},{"name":"$result","containerName":null,"kind":13,"line":468},{"containerName":"main::","name":"available_parameters","line":468,"kind":12},{"name":"$result","containerName":null,"kind":13,"line":468},{"name":"available_statistics","containerName":"main::","kind":12,"line":468},{"containerName":null,"name":"$pav","line":469,"kind":13},{"line":469,"kind":13,"name":"%sav","containerName":null},{"line":471,"kind":13,"containerName":null,"name":"$str"},{"containerName":null,"name":"%pav","line":472,"kind":13},{"kind":13,"line":473,"containerName":null,"name":"$str"},{"localvar":"my","definition":"my","name":"$param","containerName":null,"line":474,"kind":13},{"containerName":null,"name":"$result","line":474,"kind":13},{"kind":12,"line":474,"containerName":"main::","name":"available_parameters"},{"line":475,"kind":13,"name":"$str","containerName":null},{"kind":13,"line":475,"name":"$result","containerName":null},{"containerName":"main::","name":"get_parameter","kind":12,"line":475},{"name":"$param","containerName":null,"line":475,"kind":13},{"kind":13,"line":477,"containerName":null,"name":"$str"},{"name":"%sav","containerName":null,"line":480,"kind":13},{"line":481,"kind":13,"name":"$str","containerName":null},{"containerName":null,"name":"$stat","definition":"my","localvar":"my","kind":13,"line":482},{"containerName":null,"name":"$result","line":482,"kind":13},{"kind":12,"line":482,"containerName":"main::","name":"available_statistics"},{"name":"$str","containerName":null,"line":483,"kind":13},{"line":483,"kind":13,"name":"$result","containerName":null},{"name":"get_statistic","containerName":"main::","line":483,"kind":12},{"name":"$stat","containerName":null,"kind":13,"line":483},{"line":485,"kind":13,"name":"$str","containerName":null},{"kind":13,"line":488,"name":"$str","containerName":null},{"name":"$self","containerName":null,"line":488,"kind":13},{"line":488,"kind":12,"containerName":"main::","name":"footer"},{"line":489,"kind":13,"containerName":null,"name":"$str"},{"kind":12,"line":508,"children":[{"line":509,"kind":13,"localvar":"my","containerName":"hit_link_desc","name":"$self","definition":"my"},{"name":"$code","containerName":"hit_link_desc","kind":13,"line":509},{"kind":13,"line":510,"name":"$code","containerName":"hit_link_desc"},{"containerName":"hit_link_desc","name":"$self","kind":13,"line":511},{"containerName":"hit_link_desc","name":"$code","kind":13,"line":511},{"kind":13,"line":513,"name":"$self","containerName":"hit_link_desc"}],"containerName":"main::","definition":"sub","detail":"($self,$code)","signature":{"label":"hit_link_desc($self,$code)","parameters":[{"label":"$self"},{"label":"$code"}],"documentation":"1;\n# $Id: HTMLResultWriter.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::Writer::HTMLResultWriter\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# Changes 2003-07-31 (jason)\n# Gary has cleaned up the code a lot to produce better looking HTML\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::Writer::HTMLResultWriter - write a Bio::Search::ResultI in HTML\n\n=head1 SYNOPSIS\n\n  use Bio::SearchIO;\n  use Bio::SearchIO::Writer::HTMLResultWriter;\n\n  my $in = Bio::SearchIO->new(-format => 'blast',\n\t\t\t     -file   => shift @ARGV);\n\n  my $writer = Bio::SearchIO::Writer::HTMLResultWriter->new();\n  my $out = Bio::SearchIO->new(-writer => $writer);\n  $out->write_result($in->next_result);\n\n\n  # to filter your output\n  my $MinLength = 100; # need a variable with scope outside the method\n  sub hsp_filter { \n      my $hsp = shift;\n      return 1 if $hsp->length('total') > $MinLength;\n  }\n  sub result_filter { \n      my $result = shift;\n      return $hsp->num_hits > 0;\n  }\n\n  my $writer = Bio::SearchIO::Writer::HTMLResultWriter->new\n                     (-filters => { 'HSP' => \\&hsp_filter} );\n  my $out = Bio::SearchIO->new(-writer => $writer);\n  $out->write_result($in->next_result);\n\n  # can also set the filter via the writer object\n  $writer->filter('RESULT', \\&result_filter);\n\n=head1 DESCRIPTION\n\nThis object implements the SearchWriterI interface which will produce\na set of HTML for a specific L<Bio::Search::Report::ReportI> interface.\n\nSee L<Bio::SearchIO::SearchWriterI> for more info on the filter method.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nGary Williams G.Williams@hgmp.mrc.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\npackage Bio::SearchIO::Writer::HTMLResultWriter;\nuse strict;\nuse vars qw(%RemoteURLDefault\n            $MaxDescLen $DATE $AlignmentLineWidth $Revision);\n\n# Object preamble - inherits from Bio::Root::RootI\n\nBEGIN {\n    $Revision = '$Id: HTMLResultWriter.pm 16123 2009-09-17 12:57:27Z cjfields $';\n    $DATE = localtime(time);\n    %RemoteURLDefault = ( \n      'PROTEIN' => 'http://www.ncbi.nlm.nih.gov/entrez/query.fcgi?db=protein&cmd=search&term=%s',\t\t\t  \n      'NUCLEOTIDE' => 'http://www.ncbi.nlm.nih.gov/entrez/query.fcgi?db=nucleotide&cmd=search&term=%s'\n    );\n    $MaxDescLen = 60;\n    $AlignmentLineWidth = 60;\n}\n\n\nuse base qw(Bio::Root::Root Bio::SearchIO::SearchWriterI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::Writer::HTMLResultWriter->new();\n Function: Builds a new Bio::SearchIO::Writer::HTMLResultWriter object \n Returns : Bio::SearchIO::Writer::HTMLResultWriter\n Args    : -filters => hashref with any or all of the keys (HSP HIT RESULT)\n           which have values pointing to a subroutine reference\n           which will expect to get a \n           -nucleotide_url => URL sprintf string base for the nt sequences\n           -protein_url => URL sprintf string base for the aa sequences\n           -no_wublastlinks => boolean. Do not display WU-BLAST lines \n                               even if they are parsed out.\n                               Links = (1) \n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($p,$n,$filters,\n      $nowublastlinks) = $self->_rearrange([qw(PROTEIN_URL \n\t\t\t\t\t       NUCLEOTIDE_URL \n\t\t\t\t\t       FILTERS\n\t\t\t\t\t       NO_WUBLASTLINKS)],@args);\n  $self->remote_database_url('p',$p || $RemoteURLDefault{'PROTEIN'});\n  $self->remote_database_url('n',$n || $RemoteURLDefault{'NUCLEOTIDE'});\n  $self->no_wublastlinks(! $nowublastlinks);\n  if( defined $filters ) {\n      if( !ref($filters) =~ /HASH/i ) { \n\t  $self->warn(\"Did not provide a hashref for the FILTERS option, ignoring.\");\n      } else { \n\t  while( my ($type,$code) = each %{$filters} ) {\n\t      $self->filter($type,$code);\n\t  }\n      }\n  }\n\n  return $self;\n}\n\n=head2 remote_database_url\n\n Title   : remote_database_url\n Usage   : $obj->remote_database_url($type,$newval)\n Function: This should return or set a string that contains a %s which can be\n           filled in with sprintf.\n Returns : value of remote_database_url\n Args    : $type - 'PROTEIN' or 'P' for protein URLS\n                   'NUCLEOTIDE' or 'N' for nucleotide URLS\n           $value - new value to set [optional]\n\n\n\nsub remote_database_url{\n   my ($self,$type,$value) = @_;\n   if( ! defined $type || $type !~ /^(P|N)/i ) { \n       $self->warn(\"Must provide a type (PROTEIN or NUCLEOTIDE)\");\n       return '';\n   }\n   $type = uc $1;\n   if( defined $value) {\n      $self->{'remote_database_url'}->{$type} = $value;\n    }\n   return $self->{'remote_database_url'}->{$type};\n}\n\n=head2 to_string\n\n Purpose   : Produces data for each Search::Result::ResultI in a string.\n           : This is an abstract method. For some useful implementations,\n           : see ResultTableWriter.pm, HitTableWriter.pm, \n           : and HSPTableWriter.pm.\n Usage     : print $writer->to_string( $result_obj, @args );\n Argument  : $result_obj = A Bio::Search::Result::ResultI object\n           : @args = any additional arguments used by your implementation.\n Returns   : String containing data for each search Result or any of its\n           : sub-objects (Hits and HSPs).\n Throws    : n/a\n\n\nsub to_string {\n    my ($self,$result,$num) = @_; \n    $num ||= 0;\n    return unless defined $result;\n    my $links = $self->no_wublastlinks;\n    my ($resultfilter,$hitfilter, $hspfilter) = ( $self->filter('RESULT'),\n\t\t\t\t\t\t  $self->filter('HIT'),\n\t\t\t\t\t\t  $self->filter('HSP') );\n    return '' if( defined $resultfilter && ! &{$resultfilter}($result) );    \n\n    my ($qtype,$dbtype,$dbseqtype,$type);\n    my $alg = $result->algorithm;\n    # This is actually wrong for the FASTAs I think\n    if(  $alg =~ /T(FAST|BLAST)([XY])/i ) {\n\t$qtype      = $dbtype = 'translated';\n\t$dbseqtype = $type       = 'PROTEIN';\n    } elsif( $alg =~ /T(FAST|BLAST)N/i ) {\n\t$qtype      = '';\n\t$dbtype     = 'translated';\n\t$type       = 'PROTEIN';\n\t$dbseqtype  = 'NUCLEOTIDE';\n    } elsif( $alg =~ /(FAST|BLAST)N/i || \n\t     $alg =~ /(WABA|EXONERATE)/i ) {\n\t$qtype      = $dbtype = '';\n\t$type = $dbseqtype  = 'NUCLEOTIDE';\n    } elsif( $alg =~ /(FAST|BLAST)P/  || \n\t     $alg =~ /SSEARCH|HMM(PFAM|SEARCH)/i ) {\n\t$qtype      = $dbtype = '';\n\t$type = $dbseqtype  = 'PROTEIN';\n    } elsif( $alg =~ /(FAST|BLAST)[XY]/i ) {\n\t$qtype      = 'translated';\n        $dbtype     = 'PROTEIN';\n\t$dbseqtype  = $type      = 'PROTEIN';\n    } else { \n\t$self->warn(\"algorithm was \", $result->algorithm, \" couldn't match\\n\");\n    }\n    \n    \n    my %baselens = ( 'Sbjct:'   => ( $dbtype eq 'translated' )  ? 3 : 1,\n\t\t     'Query:'   => ( $qtype  eq 'translated' )  ? 3 : 1);\n\n    my $str;\n    if( $num <= 1 ) { \n\t$str = &{$self->start_report}($result);\n    }\n\n    $str .= &{$self->title}($result);\n\n    $str .= $result->algorithm_reference || $self->algorithm_reference($result);\n    $str .= &{$self->introduction}($result);\n\n    $str .= \"<table border=0>\n            <tr><th>Sequences producing significant alignments:</th>\n            <th>Score<br>(bits)</th><th>E<br>value</th></tr>\";\n\n    my $hspstr = '<p><p>';\n    if( $result->can('rewind')) {\n        $result->rewind(); # support stream based parsing routines\n    }\n\n    while( my $hit = $result->next_hit ) {\n\tnext if( $hitfilter && ! &{$hitfilter}($hit) );\n\tmy $nm = $hit->name();\n\t\n\t$self->debug( \"no $nm for name (\".$hit->description(). \"\\n\") \n\t    unless $nm;\n\tmy ($gi,$acc) = &{$self->id_parser}($nm);\n\tmy $p = \"%-$MaxDescLen\". \"s\";\n\tmy $descsub;\n\tif( length($hit->description) > ($MaxDescLen - 3) ) {\n\t    $descsub = sprintf($p,\n\t\tsubstr($hit->description,0,$MaxDescLen-3) . \"...\");\n\t} else { \n\t    $descsub = sprintf($p,$hit->description);\n\t}\n\n\tmy $url_desc  = &{$self->hit_link_desc()}($self,$hit, $result);\n\tmy $url_align = &{$self->hit_link_align()}($self,$hit, $result);\n\n\tmy @hsps = $hit->hsps;\n\t\n\tif( ! @hsps ) {\n\t    # no HSPs so no link \n\t    $str .= sprintf('<tr><td>%s %s</td><td>%s</td><td>%.2g</td></tr>'.\"\\n\",\n\t\t\t    $url_desc, $descsub, \n\t\t\t    ($hit->bits ? $hit->bits : \n\t\t\t     (defined $hsps[0] ? $hsps[0]->bits : ' ')),\n\t\t\t    ( $hit->significance ? $hit->significance :\n\t\t\t      (defined $hsps[0] ? $hsps[0]->evalue : ' ')) \n\t\t\t    );\n\t} else { \n\t    # failover to first HSP if the data does not contain a \n\t    # bitscore/significance value for the Hit (NCBI XML data for one)\n\n\t    $str .= sprintf('<tr><td>%s %s</td><td>%s</td><td><a href=\"#%s\">%.2g</a></td></tr>'.\"\\n\",\n\t\t\t    $url_desc, $descsub, \n\t\t\t    ($hit->bits ? $hit->bits : \n\t\t\t     (defined $hsps[0] ? $hsps[0]->bits : ' ')),\n\t\t\t    $acc,\n\t\t\t    ( $hit->significance ? $hit->significance :\n\t\t\t      (defined $hsps[0] ? $hsps[0]->evalue : ' ')) \n\t\t\t    );\n        my $dline = &{$self->hit_desc_line}($self, $hit, $result);\n\t    $hspstr .= \"<a name=\\\"$acc\\\">\\n\".\n\t\tsprintf(\"><b>%s</b> %s</br><dd>Length = %s</dd><p>\\n\\n\", $url_align, \n\t\t\t$dline , &_numwithcommas($hit->length));\n\t    my $ct = 0;\n\t    foreach my $hsp (@hsps ) {\n\t\tnext if( $hspfilter && ! &{$hspfilter}($hsp) );\n\t\t$hspstr .= sprintf(\" Score = %s bits (%s), Expect = %s\",\n\t\t\t\t   $hsp->bits || $hsp->score, \n\t\t\t\t   $hsp->score || $hsp->bits, \n\t\t\t\t   $hsp->evalue || '');\n\t\tif( defined $hsp->pvalue ) {\n\t\t    $hspstr .= \", P = \".$hsp->pvalue;\n\t\t}\n\t\t$hspstr .= \"<br>\\n\";\n\t\t$hspstr .= sprintf(\" Identities = %d/%d (%d%%)\",\n\t\t\t\t   ( $hsp->frac_identical('total') * \n\t\t\t\t     $hsp->length('total')),\n\t\t\t\t   $hsp->length('total'),\n\t\t\t\t   $hsp->frac_identical('total') * 100);\n\n\t\tif( $type eq 'PROTEIN' ) {\n\t\t    $hspstr .= sprintf(\", Positives = %d/%d (%d%%)\",\n\t\t\t\t       ( $hsp->frac_conserved('total') * \n\t\t\t\t\t $hsp->length('total')),\n\t\t\t\t       $hsp->length('total'),\n\t\t\t\t       $hsp->frac_conserved('total') * 100);\n\t\t}\n\t\tif( $hsp->gaps ) {\n\t\t    $hspstr .= sprintf(\", Gaps = %d/%d (%d%%)\",\n\t\t\t\t       $hsp->gaps('total'),\n\t\t\t\t       $hsp->length('total'),\n\t\t\t\t       (100 * $hsp->gaps('total') / \n\t\t\t\t\t$hsp->length('total')));\n\t\t}\n\n\t\tmy ($hframe,$qframe)   = ( $hsp->hit->frame, $hsp->query->frame);\n\t\tmy ($hstrand,$qstrand) = ($hsp->hit->strand,$hsp->query->strand);\n\t\t# so TBLASTX will have Query/Hit frames\n\t\t#    BLASTX  will have Query frame\n\t\t#    TBLASTN will have Hit frame\n\t\tif( $hstrand || $qstrand ) {\n\t\t    $hspstr .= \", Frame = \";\n\t\t    my ($signq, $signh);\n\t\t    unless( $hstrand ) {\n\t\t\t$hframe = undef;\n\t\t\t# if strand is null or 0 then it is protein\n\t\t\t# and this no frame\n\t\t    } else { \n\t\t\t$signh = $hstrand < 0 ? '-' : '+';\n\t\t    }\n\t\t    unless( $qstrand  ) {\n\t\t\t$qframe = undef;\n\t\t\t# if strand is null or 0 then it is protein\n\t\t    } else { \n\t\t\t$signq =$qstrand < 0 ? '-' : '+';\n\t\t    }\n\t\t    # remember bioperl stores frames as 0,1,2 (GFF way)\n\t\t    # BLAST reports reports as 1,2,3 so\n\t\t    # we have to add 1 to the frame values\n\t\t    if( defined $hframe && ! defined $qframe) {  \n\t\t\t$hspstr .= \"$signh\".($hframe+1);\n\t\t    } elsif( defined $qframe && ! defined $hframe) {  \n\t\t\t$hspstr .= \"$signq\".($qframe+1);\n\t\t    } else { \n\t\t\t$hspstr .= sprintf(\" %s%d / %s%d\",\n\t\t\t\t\t   $signq,$qframe+1,\n\t\t\t\t\t   $signh, $hframe+1);\n\t\t    }\n\t\t}\n\t\tif($links && \n\t\t   $hsp->can('links') && defined(my $lnks = $hsp->links) ) {\n\t\t    $hspstr .= sprintf(\"<br>\\nLinks = %s\\n\",$lnks);\n\t\t}\n\n\t\t$hspstr .= \"</a><p>\\n<pre>\";\n\n\t\tmy @hspvals = ( {'name' => 'Query:',\n\t\t\t\t 'seq'  => $hsp->query_string,\n\t\t\t\t 'start' => ($qstrand >= 0 ? \n\t\t\t\t\t     $hsp->query->start : \n\t\t\t\t\t     $hsp->query->end),\n\t\t\t\t\t     'end'   => ($qstrand >= 0 ? \n\t\t\t\t\t\t\t $hsp->query->end : \n\t\t\t\t\t\t\t $hsp->query->start),\n\t\t\t\t\t\t\t 'index' => 0,\n\t\t\t\t\t\t\t 'direction' => $qstrand || 1\n\t\t\t\t\t\t     },\n\t\t\t\t{ 'name' => ' 'x6,\n\t\t\t\t  'seq'  => $hsp->homology_string,\n\t\t\t\t  'start' => undef,\n\t\t\t\t  'end'   => undef,\n\t\t\t\t  'index' => 0,\n\t\t\t\t  'direction' => 1\n\t\t\t\t  },\n\t\t\t\t{ 'name'  => 'Sbjct:',\n\t\t\t\t  'seq'   => $hsp->hit_string,\n\t\t\t\t  'start' => ($hstrand >= 0 ? \n\t\t\t\t\t      $hsp->hit->start : \n\t\t\t\t\t      $hsp->hit->end),\n\t\t\t\t\t      'end'   => ($hstrand >= 0 ? \n\t\t\t\t\t\t\t  $hsp->hit->end : \n\t\t\t\t\t\t\t  $hsp->hit->start),\n\t\t\t\t\t\t\t  'index' => 0, \n\t\t\t\t\t\t\t  'direction' => $hstrand || 1\n\t\t\t\t\t\t      }\n\t\t\t\t);\t    \n\n\n\t\t# let's set the expected length (in chars) of the starting number\n\t\t# in an alignment block so we can have things line up\n\t\t# Just going to try and set to the largest\n\n\t\tmy ($numwidth) = sort { $b <=> $a }(length($hspvals[0]->{'start'}),\n\t\t\t\t\t\t    length($hspvals[0]->{'end'}),\n\t\t\t\t\t\t    length($hspvals[2]->{'start'}),\n\t\t\t\t\t\t    length($hspvals[2]->{'end'}));\n\t\tmy $count = 0;\n\t\twhile ( $count < $hsp->length('total') ) {\n\t\t    foreach my $v ( @hspvals ) {\n\t\t\tmy $piece = substr($v->{'seq'}, $v->{'index'} + $count,\n\t\t\t\t\t   $AlignmentLineWidth);\n\t\t\tmy $cp = $piece;\n\t\t\tmy $plen = scalar ( $cp =~ tr/\\-//);\n\t\t\tmy ($start,$end) = ('','');\n\t\t\tif( defined $v->{'start'} ) { \n\t\t\t    $start = $v->{'start'};\n\t\t\t    # since strand can be + or - use the direction\n\t\t\t    # to signify which whether to add or substract from end\n\t\t\t    my $d = $v->{'direction'} * ( $AlignmentLineWidth - $plen )*\n\t\t\t\t$baselens{$v->{'name'}};\n\t\t\t    if( length($piece) < $AlignmentLineWidth ) {\n\t\t\t\t$d = (length($piece) - $plen) * $v->{'direction'} * \n\t\t\t\t    $baselens{$v->{'name'}};\n\t\t\t    }\n\t\t\t    $end   = $v->{'start'} + $d - $v->{'direction'};\n\t\t\t    $v->{'start'} += $d;\n\t\t\t}\n\t\t\t$hspstr .= sprintf(\"%s %-\".$numwidth.\"s %s %s\\n\",\n\t\t\t\t\t   $v->{'name'},\n\t\t\t\t\t   $start,\n\t\t\t\t\t   $piece,\n\t\t\t\t\t   $end\n\t\t\t\t\t   );\n\t\t    }\n\t\t    $count += $AlignmentLineWidth;\n\t\t    $hspstr .= \"\\n\\n\";\n\t\t}\n\t\t$hspstr .= \"</pre>\\n\";\n\t    }\n\t}\n#\t$hspstr .= \"</pre>\\n\";\n    }\n\n    $str .= \"</table><p>\\n\".$hspstr;\n    my ($pav, $sav) = ($result->available_parameters, $result->available_statistics);\n    if ($pav || $sav) {\n        # make table of search statistics and end the web page\n        $str .= \"<p><p><hr><h2>Search Parameters</h2>\";\n        if ($pav) {\n        $str .= \"<table border=1><tr><th>Parameter</th><th>Value</th>\\n\";\n        foreach my $param ( sort $result->available_parameters ) {\n            $str .= \"<tr><td>$param</td><td>\". $result->get_parameter($param) .\"</td></tr>\\n\";\n        }\n        $str .= \"</table>\";\n        }\n        \n        if ($sav) {\n        $str .= \"<p><h2>Search Statistics</h2><table border=1><tr><th>Statistic</th><th>Value</th></tr>\\n\";\n        foreach my $stat ( sort $result->available_statistics ) {\n            $str .= \"<tr><td>$stat</td><td>\". $result->get_statistic($stat). \"</td>\\n\";\n        }\n        $str .=  \"</tr></table>\";\n        }\n    }\n    $str .= $self->footer() . \"<P>\\n\";\n    return $str;\n}\n\n=head2 hit_link_desc\n\n Title   : hit_link_desc\n Usage   : $self->hit_link_desc(\\&link_function);\n Function: Get/Set the function which provides an HTML \n           link(s) for the given hit to be used\n           within the description section at the top of the BLAST report.\n           This allows a person reading the report within\n           a web browser to go to one or more database entries for\n           the given hit from the description section.\n Returns : Function reference\n Args    : Function reference\n See Also: L<default_hit_link_desc()>"},"name":"hit_link_desc","range":{"end":{"character":9999,"line":514},"start":{"line":508,"character":0}}},{"name":"default_hit_link_desc","line":513,"kind":12},{"kind":12,"line":539,"children":[{"line":540,"kind":13,"localvar":"my","containerName":"default_hit_link_desc","definition":"my","name":"$self"},{"kind":13,"line":540,"name":"$hit","containerName":"default_hit_link_desc"},{"name":"$result","containerName":"default_hit_link_desc","kind":13,"line":540},{"line":541,"kind":13,"localvar":"my","containerName":"default_hit_link_desc","name":"$type","definition":"my"},{"kind":13,"line":541,"name":"$result","containerName":"default_hit_link_desc"},{"kind":12,"line":541,"name":"algorithm","containerName":"default_hit_link_desc"},{"kind":13,"line":542,"definition":"my","name":"$gi","containerName":"default_hit_link_desc","localvar":"my"},{"kind":13,"line":542,"name":"$acc","containerName":"default_hit_link_desc"},{"kind":13,"line":542,"name":"$self","containerName":"default_hit_link_desc"},{"containerName":"default_hit_link_desc","name":"id_parser","line":542,"kind":12}],"containerName":"main::","definition":"sub","detail":"($self,$hit,$result)","signature":{"documentation":"1;\n# $Id: HTMLResultWriter.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::Writer::HTMLResultWriter\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# Changes 2003-07-31 (jason)\n# Gary has cleaned up the code a lot to produce better looking HTML\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::Writer::HTMLResultWriter - write a Bio::Search::ResultI in HTML\n\n=head1 SYNOPSIS\n\n  use Bio::SearchIO;\n  use Bio::SearchIO::Writer::HTMLResultWriter;\n\n  my $in = Bio::SearchIO->new(-format => 'blast',\n\t\t\t     -file   => shift @ARGV);\n\n  my $writer = Bio::SearchIO::Writer::HTMLResultWriter->new();\n  my $out = Bio::SearchIO->new(-writer => $writer);\n  $out->write_result($in->next_result);\n\n\n  # to filter your output\n  my $MinLength = 100; # need a variable with scope outside the method\n  sub hsp_filter { \n      my $hsp = shift;\n      return 1 if $hsp->length('total') > $MinLength;\n  }\n  sub result_filter { \n      my $result = shift;\n      return $hsp->num_hits > 0;\n  }\n\n  my $writer = Bio::SearchIO::Writer::HTMLResultWriter->new\n                     (-filters => { 'HSP' => \\&hsp_filter} );\n  my $out = Bio::SearchIO->new(-writer => $writer);\n  $out->write_result($in->next_result);\n\n  # can also set the filter via the writer object\n  $writer->filter('RESULT', \\&result_filter);\n\n=head1 DESCRIPTION\n\nThis object implements the SearchWriterI interface which will produce\na set of HTML for a specific L<Bio::Search::Report::ReportI> interface.\n\nSee L<Bio::SearchIO::SearchWriterI> for more info on the filter method.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nGary Williams G.Williams@hgmp.mrc.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\npackage Bio::SearchIO::Writer::HTMLResultWriter;\nuse strict;\nuse vars qw(%RemoteURLDefault\n            $MaxDescLen $DATE $AlignmentLineWidth $Revision);\n\n# Object preamble - inherits from Bio::Root::RootI\n\nBEGIN {\n    $Revision = '$Id: HTMLResultWriter.pm 16123 2009-09-17 12:57:27Z cjfields $';\n    $DATE = localtime(time);\n    %RemoteURLDefault = ( \n      'PROTEIN' => 'http://www.ncbi.nlm.nih.gov/entrez/query.fcgi?db=protein&cmd=search&term=%s',\t\t\t  \n      'NUCLEOTIDE' => 'http://www.ncbi.nlm.nih.gov/entrez/query.fcgi?db=nucleotide&cmd=search&term=%s'\n    );\n    $MaxDescLen = 60;\n    $AlignmentLineWidth = 60;\n}\n\n\nuse base qw(Bio::Root::Root Bio::SearchIO::SearchWriterI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::Writer::HTMLResultWriter->new();\n Function: Builds a new Bio::SearchIO::Writer::HTMLResultWriter object \n Returns : Bio::SearchIO::Writer::HTMLResultWriter\n Args    : -filters => hashref with any or all of the keys (HSP HIT RESULT)\n           which have values pointing to a subroutine reference\n           which will expect to get a \n           -nucleotide_url => URL sprintf string base for the nt sequences\n           -protein_url => URL sprintf string base for the aa sequences\n           -no_wublastlinks => boolean. Do not display WU-BLAST lines \n                               even if they are parsed out.\n                               Links = (1) \n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($p,$n,$filters,\n      $nowublastlinks) = $self->_rearrange([qw(PROTEIN_URL \n\t\t\t\t\t       NUCLEOTIDE_URL \n\t\t\t\t\t       FILTERS\n\t\t\t\t\t       NO_WUBLASTLINKS)],@args);\n  $self->remote_database_url('p',$p || $RemoteURLDefault{'PROTEIN'});\n  $self->remote_database_url('n',$n || $RemoteURLDefault{'NUCLEOTIDE'});\n  $self->no_wublastlinks(! $nowublastlinks);\n  if( defined $filters ) {\n      if( !ref($filters) =~ /HASH/i ) { \n\t  $self->warn(\"Did not provide a hashref for the FILTERS option, ignoring.\");\n      } else { \n\t  while( my ($type,$code) = each %{$filters} ) {\n\t      $self->filter($type,$code);\n\t  }\n      }\n  }\n\n  return $self;\n}\n\n=head2 remote_database_url\n\n Title   : remote_database_url\n Usage   : $obj->remote_database_url($type,$newval)\n Function: This should return or set a string that contains a %s which can be\n           filled in with sprintf.\n Returns : value of remote_database_url\n Args    : $type - 'PROTEIN' or 'P' for protein URLS\n                   'NUCLEOTIDE' or 'N' for nucleotide URLS\n           $value - new value to set [optional]\n\n\n\nsub remote_database_url{\n   my ($self,$type,$value) = @_;\n   if( ! defined $type || $type !~ /^(P|N)/i ) { \n       $self->warn(\"Must provide a type (PROTEIN or NUCLEOTIDE)\");\n       return '';\n   }\n   $type = uc $1;\n   if( defined $value) {\n      $self->{'remote_database_url'}->{$type} = $value;\n    }\n   return $self->{'remote_database_url'}->{$type};\n}\n\n=head2 to_string\n\n Purpose   : Produces data for each Search::Result::ResultI in a string.\n           : This is an abstract method. For some useful implementations,\n           : see ResultTableWriter.pm, HitTableWriter.pm, \n           : and HSPTableWriter.pm.\n Usage     : print $writer->to_string( $result_obj, @args );\n Argument  : $result_obj = A Bio::Search::Result::ResultI object\n           : @args = any additional arguments used by your implementation.\n Returns   : String containing data for each search Result or any of its\n           : sub-objects (Hits and HSPs).\n Throws    : n/a\n\n\nsub to_string {\n    my ($self,$result,$num) = @_; \n    $num ||= 0;\n    return unless defined $result;\n    my $links = $self->no_wublastlinks;\n    my ($resultfilter,$hitfilter, $hspfilter) = ( $self->filter('RESULT'),\n\t\t\t\t\t\t  $self->filter('HIT'),\n\t\t\t\t\t\t  $self->filter('HSP') );\n    return '' if( defined $resultfilter && ! &{$resultfilter}($result) );    \n\n    my ($qtype,$dbtype,$dbseqtype,$type);\n    my $alg = $result->algorithm;\n    # This is actually wrong for the FASTAs I think\n    if(  $alg =~ /T(FAST|BLAST)([XY])/i ) {\n\t$qtype      = $dbtype = 'translated';\n\t$dbseqtype = $type       = 'PROTEIN';\n    } elsif( $alg =~ /T(FAST|BLAST)N/i ) {\n\t$qtype      = '';\n\t$dbtype     = 'translated';\n\t$type       = 'PROTEIN';\n\t$dbseqtype  = 'NUCLEOTIDE';\n    } elsif( $alg =~ /(FAST|BLAST)N/i || \n\t     $alg =~ /(WABA|EXONERATE)/i ) {\n\t$qtype      = $dbtype = '';\n\t$type = $dbseqtype  = 'NUCLEOTIDE';\n    } elsif( $alg =~ /(FAST|BLAST)P/  || \n\t     $alg =~ /SSEARCH|HMM(PFAM|SEARCH)/i ) {\n\t$qtype      = $dbtype = '';\n\t$type = $dbseqtype  = 'PROTEIN';\n    } elsif( $alg =~ /(FAST|BLAST)[XY]/i ) {\n\t$qtype      = 'translated';\n        $dbtype     = 'PROTEIN';\n\t$dbseqtype  = $type      = 'PROTEIN';\n    } else { \n\t$self->warn(\"algorithm was \", $result->algorithm, \" couldn't match\\n\");\n    }\n    \n    \n    my %baselens = ( 'Sbjct:'   => ( $dbtype eq 'translated' )  ? 3 : 1,\n\t\t     'Query:'   => ( $qtype  eq 'translated' )  ? 3 : 1);\n\n    my $str;\n    if( $num <= 1 ) { \n\t$str = &{$self->start_report}($result);\n    }\n\n    $str .= &{$self->title}($result);\n\n    $str .= $result->algorithm_reference || $self->algorithm_reference($result);\n    $str .= &{$self->introduction}($result);\n\n    $str .= \"<table border=0>\n            <tr><th>Sequences producing significant alignments:</th>\n            <th>Score<br>(bits)</th><th>E<br>value</th></tr>\";\n\n    my $hspstr = '<p><p>';\n    if( $result->can('rewind')) {\n        $result->rewind(); # support stream based parsing routines\n    }\n\n    while( my $hit = $result->next_hit ) {\n\tnext if( $hitfilter && ! &{$hitfilter}($hit) );\n\tmy $nm = $hit->name();\n\t\n\t$self->debug( \"no $nm for name (\".$hit->description(). \"\\n\") \n\t    unless $nm;\n\tmy ($gi,$acc) = &{$self->id_parser}($nm);\n\tmy $p = \"%-$MaxDescLen\". \"s\";\n\tmy $descsub;\n\tif( length($hit->description) > ($MaxDescLen - 3) ) {\n\t    $descsub = sprintf($p,\n\t\tsubstr($hit->description,0,$MaxDescLen-3) . \"...\");\n\t} else { \n\t    $descsub = sprintf($p,$hit->description);\n\t}\n\n\tmy $url_desc  = &{$self->hit_link_desc()}($self,$hit, $result);\n\tmy $url_align = &{$self->hit_link_align()}($self,$hit, $result);\n\n\tmy @hsps = $hit->hsps;\n\t\n\tif( ! @hsps ) {\n\t    # no HSPs so no link \n\t    $str .= sprintf('<tr><td>%s %s</td><td>%s</td><td>%.2g</td></tr>'.\"\\n\",\n\t\t\t    $url_desc, $descsub, \n\t\t\t    ($hit->bits ? $hit->bits : \n\t\t\t     (defined $hsps[0] ? $hsps[0]->bits : ' ')),\n\t\t\t    ( $hit->significance ? $hit->significance :\n\t\t\t      (defined $hsps[0] ? $hsps[0]->evalue : ' ')) \n\t\t\t    );\n\t} else { \n\t    # failover to first HSP if the data does not contain a \n\t    # bitscore/significance value for the Hit (NCBI XML data for one)\n\n\t    $str .= sprintf('<tr><td>%s %s</td><td>%s</td><td><a href=\"#%s\">%.2g</a></td></tr>'.\"\\n\",\n\t\t\t    $url_desc, $descsub, \n\t\t\t    ($hit->bits ? $hit->bits : \n\t\t\t     (defined $hsps[0] ? $hsps[0]->bits : ' ')),\n\t\t\t    $acc,\n\t\t\t    ( $hit->significance ? $hit->significance :\n\t\t\t      (defined $hsps[0] ? $hsps[0]->evalue : ' ')) \n\t\t\t    );\n        my $dline = &{$self->hit_desc_line}($self, $hit, $result);\n\t    $hspstr .= \"<a name=\\\"$acc\\\">\\n\".\n\t\tsprintf(\"><b>%s</b> %s</br><dd>Length = %s</dd><p>\\n\\n\", $url_align, \n\t\t\t$dline , &_numwithcommas($hit->length));\n\t    my $ct = 0;\n\t    foreach my $hsp (@hsps ) {\n\t\tnext if( $hspfilter && ! &{$hspfilter}($hsp) );\n\t\t$hspstr .= sprintf(\" Score = %s bits (%s), Expect = %s\",\n\t\t\t\t   $hsp->bits || $hsp->score, \n\t\t\t\t   $hsp->score || $hsp->bits, \n\t\t\t\t   $hsp->evalue || '');\n\t\tif( defined $hsp->pvalue ) {\n\t\t    $hspstr .= \", P = \".$hsp->pvalue;\n\t\t}\n\t\t$hspstr .= \"<br>\\n\";\n\t\t$hspstr .= sprintf(\" Identities = %d/%d (%d%%)\",\n\t\t\t\t   ( $hsp->frac_identical('total') * \n\t\t\t\t     $hsp->length('total')),\n\t\t\t\t   $hsp->length('total'),\n\t\t\t\t   $hsp->frac_identical('total') * 100);\n\n\t\tif( $type eq 'PROTEIN' ) {\n\t\t    $hspstr .= sprintf(\", Positives = %d/%d (%d%%)\",\n\t\t\t\t       ( $hsp->frac_conserved('total') * \n\t\t\t\t\t $hsp->length('total')),\n\t\t\t\t       $hsp->length('total'),\n\t\t\t\t       $hsp->frac_conserved('total') * 100);\n\t\t}\n\t\tif( $hsp->gaps ) {\n\t\t    $hspstr .= sprintf(\", Gaps = %d/%d (%d%%)\",\n\t\t\t\t       $hsp->gaps('total'),\n\t\t\t\t       $hsp->length('total'),\n\t\t\t\t       (100 * $hsp->gaps('total') / \n\t\t\t\t\t$hsp->length('total')));\n\t\t}\n\n\t\tmy ($hframe,$qframe)   = ( $hsp->hit->frame, $hsp->query->frame);\n\t\tmy ($hstrand,$qstrand) = ($hsp->hit->strand,$hsp->query->strand);\n\t\t# so TBLASTX will have Query/Hit frames\n\t\t#    BLASTX  will have Query frame\n\t\t#    TBLASTN will have Hit frame\n\t\tif( $hstrand || $qstrand ) {\n\t\t    $hspstr .= \", Frame = \";\n\t\t    my ($signq, $signh);\n\t\t    unless( $hstrand ) {\n\t\t\t$hframe = undef;\n\t\t\t# if strand is null or 0 then it is protein\n\t\t\t# and this no frame\n\t\t    } else { \n\t\t\t$signh = $hstrand < 0 ? '-' : '+';\n\t\t    }\n\t\t    unless( $qstrand  ) {\n\t\t\t$qframe = undef;\n\t\t\t# if strand is null or 0 then it is protein\n\t\t    } else { \n\t\t\t$signq =$qstrand < 0 ? '-' : '+';\n\t\t    }\n\t\t    # remember bioperl stores frames as 0,1,2 (GFF way)\n\t\t    # BLAST reports reports as 1,2,3 so\n\t\t    # we have to add 1 to the frame values\n\t\t    if( defined $hframe && ! defined $qframe) {  \n\t\t\t$hspstr .= \"$signh\".($hframe+1);\n\t\t    } elsif( defined $qframe && ! defined $hframe) {  \n\t\t\t$hspstr .= \"$signq\".($qframe+1);\n\t\t    } else { \n\t\t\t$hspstr .= sprintf(\" %s%d / %s%d\",\n\t\t\t\t\t   $signq,$qframe+1,\n\t\t\t\t\t   $signh, $hframe+1);\n\t\t    }\n\t\t}\n\t\tif($links && \n\t\t   $hsp->can('links') && defined(my $lnks = $hsp->links) ) {\n\t\t    $hspstr .= sprintf(\"<br>\\nLinks = %s\\n\",$lnks);\n\t\t}\n\n\t\t$hspstr .= \"</a><p>\\n<pre>\";\n\n\t\tmy @hspvals = ( {'name' => 'Query:',\n\t\t\t\t 'seq'  => $hsp->query_string,\n\t\t\t\t 'start' => ($qstrand >= 0 ? \n\t\t\t\t\t     $hsp->query->start : \n\t\t\t\t\t     $hsp->query->end),\n\t\t\t\t\t     'end'   => ($qstrand >= 0 ? \n\t\t\t\t\t\t\t $hsp->query->end : \n\t\t\t\t\t\t\t $hsp->query->start),\n\t\t\t\t\t\t\t 'index' => 0,\n\t\t\t\t\t\t\t 'direction' => $qstrand || 1\n\t\t\t\t\t\t     },\n\t\t\t\t{ 'name' => ' 'x6,\n\t\t\t\t  'seq'  => $hsp->homology_string,\n\t\t\t\t  'start' => undef,\n\t\t\t\t  'end'   => undef,\n\t\t\t\t  'index' => 0,\n\t\t\t\t  'direction' => 1\n\t\t\t\t  },\n\t\t\t\t{ 'name'  => 'Sbjct:',\n\t\t\t\t  'seq'   => $hsp->hit_string,\n\t\t\t\t  'start' => ($hstrand >= 0 ? \n\t\t\t\t\t      $hsp->hit->start : \n\t\t\t\t\t      $hsp->hit->end),\n\t\t\t\t\t      'end'   => ($hstrand >= 0 ? \n\t\t\t\t\t\t\t  $hsp->hit->end : \n\t\t\t\t\t\t\t  $hsp->hit->start),\n\t\t\t\t\t\t\t  'index' => 0, \n\t\t\t\t\t\t\t  'direction' => $hstrand || 1\n\t\t\t\t\t\t      }\n\t\t\t\t);\t    \n\n\n\t\t# let's set the expected length (in chars) of the starting number\n\t\t# in an alignment block so we can have things line up\n\t\t# Just going to try and set to the largest\n\n\t\tmy ($numwidth) = sort { $b <=> $a }(length($hspvals[0]->{'start'}),\n\t\t\t\t\t\t    length($hspvals[0]->{'end'}),\n\t\t\t\t\t\t    length($hspvals[2]->{'start'}),\n\t\t\t\t\t\t    length($hspvals[2]->{'end'}));\n\t\tmy $count = 0;\n\t\twhile ( $count < $hsp->length('total') ) {\n\t\t    foreach my $v ( @hspvals ) {\n\t\t\tmy $piece = substr($v->{'seq'}, $v->{'index'} + $count,\n\t\t\t\t\t   $AlignmentLineWidth);\n\t\t\tmy $cp = $piece;\n\t\t\tmy $plen = scalar ( $cp =~ tr/\\-//);\n\t\t\tmy ($start,$end) = ('','');\n\t\t\tif( defined $v->{'start'} ) { \n\t\t\t    $start = $v->{'start'};\n\t\t\t    # since strand can be + or - use the direction\n\t\t\t    # to signify which whether to add or substract from end\n\t\t\t    my $d = $v->{'direction'} * ( $AlignmentLineWidth - $plen )*\n\t\t\t\t$baselens{$v->{'name'}};\n\t\t\t    if( length($piece) < $AlignmentLineWidth ) {\n\t\t\t\t$d = (length($piece) - $plen) * $v->{'direction'} * \n\t\t\t\t    $baselens{$v->{'name'}};\n\t\t\t    }\n\t\t\t    $end   = $v->{'start'} + $d - $v->{'direction'};\n\t\t\t    $v->{'start'} += $d;\n\t\t\t}\n\t\t\t$hspstr .= sprintf(\"%s %-\".$numwidth.\"s %s %s\\n\",\n\t\t\t\t\t   $v->{'name'},\n\t\t\t\t\t   $start,\n\t\t\t\t\t   $piece,\n\t\t\t\t\t   $end\n\t\t\t\t\t   );\n\t\t    }\n\t\t    $count += $AlignmentLineWidth;\n\t\t    $hspstr .= \"\\n\\n\";\n\t\t}\n\t\t$hspstr .= \"</pre>\\n\";\n\t    }\n\t}\n#\t$hspstr .= \"</pre>\\n\";\n    }\n\n    $str .= \"</table><p>\\n\".$hspstr;\n    my ($pav, $sav) = ($result->available_parameters, $result->available_statistics);\n    if ($pav || $sav) {\n        # make table of search statistics and end the web page\n        $str .= \"<p><p><hr><h2>Search Parameters</h2>\";\n        if ($pav) {\n        $str .= \"<table border=1><tr><th>Parameter</th><th>Value</th>\\n\";\n        foreach my $param ( sort $result->available_parameters ) {\n            $str .= \"<tr><td>$param</td><td>\". $result->get_parameter($param) .\"</td></tr>\\n\";\n        }\n        $str .= \"</table>\";\n        }\n        \n        if ($sav) {\n        $str .= \"<p><h2>Search Statistics</h2><table border=1><tr><th>Statistic</th><th>Value</th></tr>\\n\";\n        foreach my $stat ( sort $result->available_statistics ) {\n            $str .= \"<tr><td>$stat</td><td>\". $result->get_statistic($stat). \"</td>\\n\";\n        }\n        $str .=  \"</tr></table>\";\n        }\n    }\n    $str .= $self->footer() . \"<P>\\n\";\n    return $str;\n}\n\n=head2 hit_link_desc\n\n Title   : hit_link_desc\n Usage   : $self->hit_link_desc(\\&link_function);\n Function: Get/Set the function which provides an HTML \n           link(s) for the given hit to be used\n           within the description section at the top of the BLAST report.\n           This allows a person reading the report within\n           a web browser to go to one or more database entries for\n           the given hit from the description section.\n Returns : Function reference\n Args    : Function reference\n See Also: L<default_hit_link_desc()>\n\n\nsub hit_link_desc{\n    my( $self, $code ) = @_; \n    if ($code) {\n        $self->{'_hit_link_desc'} = $code;\n    }\n    return $self->{'_hit_link_desc'} || \\&default_hit_link_desc;\n}\n\n=head2 default_hit_link_desc\n\n Title   : default_hit_link_desc\n Usage   : $self->default_hit_link_desc($hit, $result)\n Function: Provides an HTML link(s) for the given hit to be used\n           within the description section at the top of the BLAST report.\n           This allows a person reading the report within\n           a web browser to go to one or more database entries for\n           the given hit from the description section.\n Returns : string containing HTML markup \"<a href...\")\n\n           The default implementation returns an HTML link to the\n           URL supplied by the remote_database_url() method\n           and using the identifier supplied by the id_parser() method.\n           It will use the NCBI GI if present, and the accession if not.\n\n Args    : First argument is a Bio::Search::Hit::HitI\n           Second argument is a Bio::Search::Result::ResultI\n\nSee Also: L<hit_link_align>, L<remote_database>, L<id_parser>","parameters":[{"label":"$self"},{"label":"$hit"},{"label":"$result"}],"label":"default_hit_link_desc($self,$hit,$result)"},"name":"default_hit_link_desc","range":{"end":{"character":9999,"line":542},"start":{"line":539,"character":0}}},{"name":"$hit","containerName":null,"kind":13,"line":542},{"kind":12,"line":542,"containerName":"main::","name":"name"},{"localvar":"my","name":"$url","definition":"my","containerName":null,"line":544,"kind":13},{"name":"$self","containerName":null,"kind":13,"line":544},{"kind":12,"line":544,"containerName":"main::","name":"remote_database_url"},{"name":"$type","containerName":null,"kind":13,"line":544},{"kind":13,"line":546,"containerName":null,"name":"$self"},{"containerName":"main::","name":"remote_database_url","line":546,"kind":12},{"name":"$type","containerName":null,"line":546,"kind":13},{"name":"$gi","containerName":null,"line":546,"kind":13},{"containerName":null,"name":"$acc","line":546,"kind":13},{"line":547,"kind":13,"containerName":null,"name":"$hit"},{"name":"name","containerName":"main::","line":547,"kind":12},{"containerName":null,"name":"$hit","line":547,"kind":13},{"containerName":"main::","name":"name","kind":12,"line":547},{"line":549,"kind":13,"name":"$url","containerName":null},{"name":"hit_link_align","range":{"end":{"character":9999,"line":580},"start":{"line":574,"character":0}},"kind":12,"children":[{"kind":13,"line":575,"definition":"my","name":"$self","containerName":"hit_link_align","localvar":"my"},{"containerName":"hit_link_align","name":"$code","kind":13,"line":575},{"kind":13,"line":576,"containerName":"hit_link_align","name":"$code"},{"line":577,"kind":13,"containerName":"hit_link_align","name":"$self"},{"name":"$code","containerName":"hit_link_align","line":577,"kind":13},{"kind":13,"line":579,"containerName":"hit_link_align","name":"$self"}],"line":574,"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"$code"}],"documentation":"1;\n# $Id: HTMLResultWriter.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::Writer::HTMLResultWriter\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# Changes 2003-07-31 (jason)\n# Gary has cleaned up the code a lot to produce better looking HTML\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::Writer::HTMLResultWriter - write a Bio::Search::ResultI in HTML\n\n=head1 SYNOPSIS\n\n  use Bio::SearchIO;\n  use Bio::SearchIO::Writer::HTMLResultWriter;\n\n  my $in = Bio::SearchIO->new(-format => 'blast',\n\t\t\t     -file   => shift @ARGV);\n\n  my $writer = Bio::SearchIO::Writer::HTMLResultWriter->new();\n  my $out = Bio::SearchIO->new(-writer => $writer);\n  $out->write_result($in->next_result);\n\n\n  # to filter your output\n  my $MinLength = 100; # need a variable with scope outside the method\n  sub hsp_filter { \n      my $hsp = shift;\n      return 1 if $hsp->length('total') > $MinLength;\n  }\n  sub result_filter { \n      my $result = shift;\n      return $hsp->num_hits > 0;\n  }\n\n  my $writer = Bio::SearchIO::Writer::HTMLResultWriter->new\n                     (-filters => { 'HSP' => \\&hsp_filter} );\n  my $out = Bio::SearchIO->new(-writer => $writer);\n  $out->write_result($in->next_result);\n\n  # can also set the filter via the writer object\n  $writer->filter('RESULT', \\&result_filter);\n\n=head1 DESCRIPTION\n\nThis object implements the SearchWriterI interface which will produce\na set of HTML for a specific L<Bio::Search::Report::ReportI> interface.\n\nSee L<Bio::SearchIO::SearchWriterI> for more info on the filter method.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nGary Williams G.Williams@hgmp.mrc.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\npackage Bio::SearchIO::Writer::HTMLResultWriter;\nuse strict;\nuse vars qw(%RemoteURLDefault\n            $MaxDescLen $DATE $AlignmentLineWidth $Revision);\n\n# Object preamble - inherits from Bio::Root::RootI\n\nBEGIN {\n    $Revision = '$Id: HTMLResultWriter.pm 16123 2009-09-17 12:57:27Z cjfields $';\n    $DATE = localtime(time);\n    %RemoteURLDefault = ( \n      'PROTEIN' => 'http://www.ncbi.nlm.nih.gov/entrez/query.fcgi?db=protein&cmd=search&term=%s',\t\t\t  \n      'NUCLEOTIDE' => 'http://www.ncbi.nlm.nih.gov/entrez/query.fcgi?db=nucleotide&cmd=search&term=%s'\n    );\n    $MaxDescLen = 60;\n    $AlignmentLineWidth = 60;\n}\n\n\nuse base qw(Bio::Root::Root Bio::SearchIO::SearchWriterI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::Writer::HTMLResultWriter->new();\n Function: Builds a new Bio::SearchIO::Writer::HTMLResultWriter object \n Returns : Bio::SearchIO::Writer::HTMLResultWriter\n Args    : -filters => hashref with any or all of the keys (HSP HIT RESULT)\n           which have values pointing to a subroutine reference\n           which will expect to get a \n           -nucleotide_url => URL sprintf string base for the nt sequences\n           -protein_url => URL sprintf string base for the aa sequences\n           -no_wublastlinks => boolean. Do not display WU-BLAST lines \n                               even if they are parsed out.\n                               Links = (1) \n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($p,$n,$filters,\n      $nowublastlinks) = $self->_rearrange([qw(PROTEIN_URL \n\t\t\t\t\t       NUCLEOTIDE_URL \n\t\t\t\t\t       FILTERS\n\t\t\t\t\t       NO_WUBLASTLINKS)],@args);\n  $self->remote_database_url('p',$p || $RemoteURLDefault{'PROTEIN'});\n  $self->remote_database_url('n',$n || $RemoteURLDefault{'NUCLEOTIDE'});\n  $self->no_wublastlinks(! $nowublastlinks);\n  if( defined $filters ) {\n      if( !ref($filters) =~ /HASH/i ) { \n\t  $self->warn(\"Did not provide a hashref for the FILTERS option, ignoring.\");\n      } else { \n\t  while( my ($type,$code) = each %{$filters} ) {\n\t      $self->filter($type,$code);\n\t  }\n      }\n  }\n\n  return $self;\n}\n\n=head2 remote_database_url\n\n Title   : remote_database_url\n Usage   : $obj->remote_database_url($type,$newval)\n Function: This should return or set a string that contains a %s which can be\n           filled in with sprintf.\n Returns : value of remote_database_url\n Args    : $type - 'PROTEIN' or 'P' for protein URLS\n                   'NUCLEOTIDE' or 'N' for nucleotide URLS\n           $value - new value to set [optional]\n\n\n\nsub remote_database_url{\n   my ($self,$type,$value) = @_;\n   if( ! defined $type || $type !~ /^(P|N)/i ) { \n       $self->warn(\"Must provide a type (PROTEIN or NUCLEOTIDE)\");\n       return '';\n   }\n   $type = uc $1;\n   if( defined $value) {\n      $self->{'remote_database_url'}->{$type} = $value;\n    }\n   return $self->{'remote_database_url'}->{$type};\n}\n\n=head2 to_string\n\n Purpose   : Produces data for each Search::Result::ResultI in a string.\n           : This is an abstract method. For some useful implementations,\n           : see ResultTableWriter.pm, HitTableWriter.pm, \n           : and HSPTableWriter.pm.\n Usage     : print $writer->to_string( $result_obj, @args );\n Argument  : $result_obj = A Bio::Search::Result::ResultI object\n           : @args = any additional arguments used by your implementation.\n Returns   : String containing data for each search Result or any of its\n           : sub-objects (Hits and HSPs).\n Throws    : n/a\n\n\nsub to_string {\n    my ($self,$result,$num) = @_; \n    $num ||= 0;\n    return unless defined $result;\n    my $links = $self->no_wublastlinks;\n    my ($resultfilter,$hitfilter, $hspfilter) = ( $self->filter('RESULT'),\n\t\t\t\t\t\t  $self->filter('HIT'),\n\t\t\t\t\t\t  $self->filter('HSP') );\n    return '' if( defined $resultfilter && ! &{$resultfilter}($result) );    \n\n    my ($qtype,$dbtype,$dbseqtype,$type);\n    my $alg = $result->algorithm;\n    # This is actually wrong for the FASTAs I think\n    if(  $alg =~ /T(FAST|BLAST)([XY])/i ) {\n\t$qtype      = $dbtype = 'translated';\n\t$dbseqtype = $type       = 'PROTEIN';\n    } elsif( $alg =~ /T(FAST|BLAST)N/i ) {\n\t$qtype      = '';\n\t$dbtype     = 'translated';\n\t$type       = 'PROTEIN';\n\t$dbseqtype  = 'NUCLEOTIDE';\n    } elsif( $alg =~ /(FAST|BLAST)N/i || \n\t     $alg =~ /(WABA|EXONERATE)/i ) {\n\t$qtype      = $dbtype = '';\n\t$type = $dbseqtype  = 'NUCLEOTIDE';\n    } elsif( $alg =~ /(FAST|BLAST)P/  || \n\t     $alg =~ /SSEARCH|HMM(PFAM|SEARCH)/i ) {\n\t$qtype      = $dbtype = '';\n\t$type = $dbseqtype  = 'PROTEIN';\n    } elsif( $alg =~ /(FAST|BLAST)[XY]/i ) {\n\t$qtype      = 'translated';\n        $dbtype     = 'PROTEIN';\n\t$dbseqtype  = $type      = 'PROTEIN';\n    } else { \n\t$self->warn(\"algorithm was \", $result->algorithm, \" couldn't match\\n\");\n    }\n    \n    \n    my %baselens = ( 'Sbjct:'   => ( $dbtype eq 'translated' )  ? 3 : 1,\n\t\t     'Query:'   => ( $qtype  eq 'translated' )  ? 3 : 1);\n\n    my $str;\n    if( $num <= 1 ) { \n\t$str = &{$self->start_report}($result);\n    }\n\n    $str .= &{$self->title}($result);\n\n    $str .= $result->algorithm_reference || $self->algorithm_reference($result);\n    $str .= &{$self->introduction}($result);\n\n    $str .= \"<table border=0>\n            <tr><th>Sequences producing significant alignments:</th>\n            <th>Score<br>(bits)</th><th>E<br>value</th></tr>\";\n\n    my $hspstr = '<p><p>';\n    if( $result->can('rewind')) {\n        $result->rewind(); # support stream based parsing routines\n    }\n\n    while( my $hit = $result->next_hit ) {\n\tnext if( $hitfilter && ! &{$hitfilter}($hit) );\n\tmy $nm = $hit->name();\n\t\n\t$self->debug( \"no $nm for name (\".$hit->description(). \"\\n\") \n\t    unless $nm;\n\tmy ($gi,$acc) = &{$self->id_parser}($nm);\n\tmy $p = \"%-$MaxDescLen\". \"s\";\n\tmy $descsub;\n\tif( length($hit->description) > ($MaxDescLen - 3) ) {\n\t    $descsub = sprintf($p,\n\t\tsubstr($hit->description,0,$MaxDescLen-3) . \"...\");\n\t} else { \n\t    $descsub = sprintf($p,$hit->description);\n\t}\n\n\tmy $url_desc  = &{$self->hit_link_desc()}($self,$hit, $result);\n\tmy $url_align = &{$self->hit_link_align()}($self,$hit, $result);\n\n\tmy @hsps = $hit->hsps;\n\t\n\tif( ! @hsps ) {\n\t    # no HSPs so no link \n\t    $str .= sprintf('<tr><td>%s %s</td><td>%s</td><td>%.2g</td></tr>'.\"\\n\",\n\t\t\t    $url_desc, $descsub, \n\t\t\t    ($hit->bits ? $hit->bits : \n\t\t\t     (defined $hsps[0] ? $hsps[0]->bits : ' ')),\n\t\t\t    ( $hit->significance ? $hit->significance :\n\t\t\t      (defined $hsps[0] ? $hsps[0]->evalue : ' ')) \n\t\t\t    );\n\t} else { \n\t    # failover to first HSP if the data does not contain a \n\t    # bitscore/significance value for the Hit (NCBI XML data for one)\n\n\t    $str .= sprintf('<tr><td>%s %s</td><td>%s</td><td><a href=\"#%s\">%.2g</a></td></tr>'.\"\\n\",\n\t\t\t    $url_desc, $descsub, \n\t\t\t    ($hit->bits ? $hit->bits : \n\t\t\t     (defined $hsps[0] ? $hsps[0]->bits : ' ')),\n\t\t\t    $acc,\n\t\t\t    ( $hit->significance ? $hit->significance :\n\t\t\t      (defined $hsps[0] ? $hsps[0]->evalue : ' ')) \n\t\t\t    );\n        my $dline = &{$self->hit_desc_line}($self, $hit, $result);\n\t    $hspstr .= \"<a name=\\\"$acc\\\">\\n\".\n\t\tsprintf(\"><b>%s</b> %s</br><dd>Length = %s</dd><p>\\n\\n\", $url_align, \n\t\t\t$dline , &_numwithcommas($hit->length));\n\t    my $ct = 0;\n\t    foreach my $hsp (@hsps ) {\n\t\tnext if( $hspfilter && ! &{$hspfilter}($hsp) );\n\t\t$hspstr .= sprintf(\" Score = %s bits (%s), Expect = %s\",\n\t\t\t\t   $hsp->bits || $hsp->score, \n\t\t\t\t   $hsp->score || $hsp->bits, \n\t\t\t\t   $hsp->evalue || '');\n\t\tif( defined $hsp->pvalue ) {\n\t\t    $hspstr .= \", P = \".$hsp->pvalue;\n\t\t}\n\t\t$hspstr .= \"<br>\\n\";\n\t\t$hspstr .= sprintf(\" Identities = %d/%d (%d%%)\",\n\t\t\t\t   ( $hsp->frac_identical('total') * \n\t\t\t\t     $hsp->length('total')),\n\t\t\t\t   $hsp->length('total'),\n\t\t\t\t   $hsp->frac_identical('total') * 100);\n\n\t\tif( $type eq 'PROTEIN' ) {\n\t\t    $hspstr .= sprintf(\", Positives = %d/%d (%d%%)\",\n\t\t\t\t       ( $hsp->frac_conserved('total') * \n\t\t\t\t\t $hsp->length('total')),\n\t\t\t\t       $hsp->length('total'),\n\t\t\t\t       $hsp->frac_conserved('total') * 100);\n\t\t}\n\t\tif( $hsp->gaps ) {\n\t\t    $hspstr .= sprintf(\", Gaps = %d/%d (%d%%)\",\n\t\t\t\t       $hsp->gaps('total'),\n\t\t\t\t       $hsp->length('total'),\n\t\t\t\t       (100 * $hsp->gaps('total') / \n\t\t\t\t\t$hsp->length('total')));\n\t\t}\n\n\t\tmy ($hframe,$qframe)   = ( $hsp->hit->frame, $hsp->query->frame);\n\t\tmy ($hstrand,$qstrand) = ($hsp->hit->strand,$hsp->query->strand);\n\t\t# so TBLASTX will have Query/Hit frames\n\t\t#    BLASTX  will have Query frame\n\t\t#    TBLASTN will have Hit frame\n\t\tif( $hstrand || $qstrand ) {\n\t\t    $hspstr .= \", Frame = \";\n\t\t    my ($signq, $signh);\n\t\t    unless( $hstrand ) {\n\t\t\t$hframe = undef;\n\t\t\t# if strand is null or 0 then it is protein\n\t\t\t# and this no frame\n\t\t    } else { \n\t\t\t$signh = $hstrand < 0 ? '-' : '+';\n\t\t    }\n\t\t    unless( $qstrand  ) {\n\t\t\t$qframe = undef;\n\t\t\t# if strand is null or 0 then it is protein\n\t\t    } else { \n\t\t\t$signq =$qstrand < 0 ? '-' : '+';\n\t\t    }\n\t\t    # remember bioperl stores frames as 0,1,2 (GFF way)\n\t\t    # BLAST reports reports as 1,2,3 so\n\t\t    # we have to add 1 to the frame values\n\t\t    if( defined $hframe && ! defined $qframe) {  \n\t\t\t$hspstr .= \"$signh\".($hframe+1);\n\t\t    } elsif( defined $qframe && ! defined $hframe) {  \n\t\t\t$hspstr .= \"$signq\".($qframe+1);\n\t\t    } else { \n\t\t\t$hspstr .= sprintf(\" %s%d / %s%d\",\n\t\t\t\t\t   $signq,$qframe+1,\n\t\t\t\t\t   $signh, $hframe+1);\n\t\t    }\n\t\t}\n\t\tif($links && \n\t\t   $hsp->can('links') && defined(my $lnks = $hsp->links) ) {\n\t\t    $hspstr .= sprintf(\"<br>\\nLinks = %s\\n\",$lnks);\n\t\t}\n\n\t\t$hspstr .= \"</a><p>\\n<pre>\";\n\n\t\tmy @hspvals = ( {'name' => 'Query:',\n\t\t\t\t 'seq'  => $hsp->query_string,\n\t\t\t\t 'start' => ($qstrand >= 0 ? \n\t\t\t\t\t     $hsp->query->start : \n\t\t\t\t\t     $hsp->query->end),\n\t\t\t\t\t     'end'   => ($qstrand >= 0 ? \n\t\t\t\t\t\t\t $hsp->query->end : \n\t\t\t\t\t\t\t $hsp->query->start),\n\t\t\t\t\t\t\t 'index' => 0,\n\t\t\t\t\t\t\t 'direction' => $qstrand || 1\n\t\t\t\t\t\t     },\n\t\t\t\t{ 'name' => ' 'x6,\n\t\t\t\t  'seq'  => $hsp->homology_string,\n\t\t\t\t  'start' => undef,\n\t\t\t\t  'end'   => undef,\n\t\t\t\t  'index' => 0,\n\t\t\t\t  'direction' => 1\n\t\t\t\t  },\n\t\t\t\t{ 'name'  => 'Sbjct:',\n\t\t\t\t  'seq'   => $hsp->hit_string,\n\t\t\t\t  'start' => ($hstrand >= 0 ? \n\t\t\t\t\t      $hsp->hit->start : \n\t\t\t\t\t      $hsp->hit->end),\n\t\t\t\t\t      'end'   => ($hstrand >= 0 ? \n\t\t\t\t\t\t\t  $hsp->hit->end : \n\t\t\t\t\t\t\t  $hsp->hit->start),\n\t\t\t\t\t\t\t  'index' => 0, \n\t\t\t\t\t\t\t  'direction' => $hstrand || 1\n\t\t\t\t\t\t      }\n\t\t\t\t);\t    \n\n\n\t\t# let's set the expected length (in chars) of the starting number\n\t\t# in an alignment block so we can have things line up\n\t\t# Just going to try and set to the largest\n\n\t\tmy ($numwidth) = sort { $b <=> $a }(length($hspvals[0]->{'start'}),\n\t\t\t\t\t\t    length($hspvals[0]->{'end'}),\n\t\t\t\t\t\t    length($hspvals[2]->{'start'}),\n\t\t\t\t\t\t    length($hspvals[2]->{'end'}));\n\t\tmy $count = 0;\n\t\twhile ( $count < $hsp->length('total') ) {\n\t\t    foreach my $v ( @hspvals ) {\n\t\t\tmy $piece = substr($v->{'seq'}, $v->{'index'} + $count,\n\t\t\t\t\t   $AlignmentLineWidth);\n\t\t\tmy $cp = $piece;\n\t\t\tmy $plen = scalar ( $cp =~ tr/\\-//);\n\t\t\tmy ($start,$end) = ('','');\n\t\t\tif( defined $v->{'start'} ) { \n\t\t\t    $start = $v->{'start'};\n\t\t\t    # since strand can be + or - use the direction\n\t\t\t    # to signify which whether to add or substract from end\n\t\t\t    my $d = $v->{'direction'} * ( $AlignmentLineWidth - $plen )*\n\t\t\t\t$baselens{$v->{'name'}};\n\t\t\t    if( length($piece) < $AlignmentLineWidth ) {\n\t\t\t\t$d = (length($piece) - $plen) * $v->{'direction'} * \n\t\t\t\t    $baselens{$v->{'name'}};\n\t\t\t    }\n\t\t\t    $end   = $v->{'start'} + $d - $v->{'direction'};\n\t\t\t    $v->{'start'} += $d;\n\t\t\t}\n\t\t\t$hspstr .= sprintf(\"%s %-\".$numwidth.\"s %s %s\\n\",\n\t\t\t\t\t   $v->{'name'},\n\t\t\t\t\t   $start,\n\t\t\t\t\t   $piece,\n\t\t\t\t\t   $end\n\t\t\t\t\t   );\n\t\t    }\n\t\t    $count += $AlignmentLineWidth;\n\t\t    $hspstr .= \"\\n\\n\";\n\t\t}\n\t\t$hspstr .= \"</pre>\\n\";\n\t    }\n\t}\n#\t$hspstr .= \"</pre>\\n\";\n    }\n\n    $str .= \"</table><p>\\n\".$hspstr;\n    my ($pav, $sav) = ($result->available_parameters, $result->available_statistics);\n    if ($pav || $sav) {\n        # make table of search statistics and end the web page\n        $str .= \"<p><p><hr><h2>Search Parameters</h2>\";\n        if ($pav) {\n        $str .= \"<table border=1><tr><th>Parameter</th><th>Value</th>\\n\";\n        foreach my $param ( sort $result->available_parameters ) {\n            $str .= \"<tr><td>$param</td><td>\". $result->get_parameter($param) .\"</td></tr>\\n\";\n        }\n        $str .= \"</table>\";\n        }\n        \n        if ($sav) {\n        $str .= \"<p><h2>Search Statistics</h2><table border=1><tr><th>Statistic</th><th>Value</th></tr>\\n\";\n        foreach my $stat ( sort $result->available_statistics ) {\n            $str .= \"<tr><td>$stat</td><td>\". $result->get_statistic($stat). \"</td>\\n\";\n        }\n        $str .=  \"</tr></table>\";\n        }\n    }\n    $str .= $self->footer() . \"<P>\\n\";\n    return $str;\n}\n\n=head2 hit_link_desc\n\n Title   : hit_link_desc\n Usage   : $self->hit_link_desc(\\&link_function);\n Function: Get/Set the function which provides an HTML \n           link(s) for the given hit to be used\n           within the description section at the top of the BLAST report.\n           This allows a person reading the report within\n           a web browser to go to one or more database entries for\n           the given hit from the description section.\n Returns : Function reference\n Args    : Function reference\n See Also: L<default_hit_link_desc()>\n\n\nsub hit_link_desc{\n    my( $self, $code ) = @_; \n    if ($code) {\n        $self->{'_hit_link_desc'} = $code;\n    }\n    return $self->{'_hit_link_desc'} || \\&default_hit_link_desc;\n}\n\n=head2 default_hit_link_desc\n\n Title   : default_hit_link_desc\n Usage   : $self->default_hit_link_desc($hit, $result)\n Function: Provides an HTML link(s) for the given hit to be used\n           within the description section at the top of the BLAST report.\n           This allows a person reading the report within\n           a web browser to go to one or more database entries for\n           the given hit from the description section.\n Returns : string containing HTML markup \"<a href...\")\n\n           The default implementation returns an HTML link to the\n           URL supplied by the remote_database_url() method\n           and using the identifier supplied by the id_parser() method.\n           It will use the NCBI GI if present, and the accession if not.\n\n Args    : First argument is a Bio::Search::Hit::HitI\n           Second argument is a Bio::Search::Result::ResultI\n\nSee Also: L<hit_link_align>, L<remote_database>, L<id_parser>\n\n\nsub default_hit_link_desc {\n    my($self, $hit, $result) = @_;\n    my $type = ( $result->algorithm =~ /(P|X|Y)$/i ) ? 'PROTEIN' : 'NUCLEOTIDE';\n    my ($gi,$acc) = &{$self->id_parser}($hit->name);\n\n    my $url = length($self->remote_database_url($type)) > 0 ? \n              sprintf('<a href=\"%s\">%s</a>',\n                      sprintf($self->remote_database_url($type),$gi || $acc), \n                      $hit->name()) :  $hit->name();\n\n    return $url;\n}\n\n\n=head2 hit_link_align\n\n Title   : hit_link_align\n Usage   : $self->hit_link_align(\\&link_function);\n Function: Get/Set the function which provides an HTML link(s) \n           for the given hit to be used\n           within the HSP alignment section of the BLAST report.\n           This allows a person reading the report within\n           a web browser to go to one or more database entries for\n           the given hit from the alignment section.\n Returns : string containing HTML markup \"<a href...\")\n\n           The default implementation delegates to hit_link_desc().\n\n Args    : First argument is a Bio::Search::Hit::HitI\n           Second argument is a Bio::Search::Result::ResultI\n\nSee Also: L<hit_link_desc>, L<remote_database>, L<id_parser>","label":"hit_link_align($self,$code)"},"detail":"($self,$code)"},{"name":"hit_desc_line","range":{"start":{"character":0,"line":595},"end":{"character":9999,"line":601}},"kind":12,"line":595,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"hit_desc_line","line":596,"kind":13},{"line":596,"kind":13,"name":"$code","containerName":"hit_desc_line"},{"kind":13,"line":597,"containerName":"hit_desc_line","name":"$code"},{"kind":13,"line":598,"containerName":"hit_desc_line","name":"$self"},{"containerName":"hit_desc_line","name":"$code","line":598,"kind":13},{"line":600,"kind":13,"containerName":"hit_desc_line","name":"$self"}],"containerName":"main::","definition":"sub","detail":"($self,$code)","signature":{"label":"hit_desc_line($self,$code)","documentation":"1;\n# $Id: HTMLResultWriter.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::Writer::HTMLResultWriter\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# Changes 2003-07-31 (jason)\n# Gary has cleaned up the code a lot to produce better looking HTML\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::Writer::HTMLResultWriter - write a Bio::Search::ResultI in HTML\n\n=head1 SYNOPSIS\n\n  use Bio::SearchIO;\n  use Bio::SearchIO::Writer::HTMLResultWriter;\n\n  my $in = Bio::SearchIO->new(-format => 'blast',\n\t\t\t     -file   => shift @ARGV);\n\n  my $writer = Bio::SearchIO::Writer::HTMLResultWriter->new();\n  my $out = Bio::SearchIO->new(-writer => $writer);\n  $out->write_result($in->next_result);\n\n\n  # to filter your output\n  my $MinLength = 100; # need a variable with scope outside the method\n  sub hsp_filter { \n      my $hsp = shift;\n      return 1 if $hsp->length('total') > $MinLength;\n  }\n  sub result_filter { \n      my $result = shift;\n      return $hsp->num_hits > 0;\n  }\n\n  my $writer = Bio::SearchIO::Writer::HTMLResultWriter->new\n                     (-filters => { 'HSP' => \\&hsp_filter} );\n  my $out = Bio::SearchIO->new(-writer => $writer);\n  $out->write_result($in->next_result);\n\n  # can also set the filter via the writer object\n  $writer->filter('RESULT', \\&result_filter);\n\n=head1 DESCRIPTION\n\nThis object implements the SearchWriterI interface which will produce\na set of HTML for a specific L<Bio::Search::Report::ReportI> interface.\n\nSee L<Bio::SearchIO::SearchWriterI> for more info on the filter method.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nGary Williams G.Williams@hgmp.mrc.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\npackage Bio::SearchIO::Writer::HTMLResultWriter;\nuse strict;\nuse vars qw(%RemoteURLDefault\n            $MaxDescLen $DATE $AlignmentLineWidth $Revision);\n\n# Object preamble - inherits from Bio::Root::RootI\n\nBEGIN {\n    $Revision = '$Id: HTMLResultWriter.pm 16123 2009-09-17 12:57:27Z cjfields $';\n    $DATE = localtime(time);\n    %RemoteURLDefault = ( \n      'PROTEIN' => 'http://www.ncbi.nlm.nih.gov/entrez/query.fcgi?db=protein&cmd=search&term=%s',\t\t\t  \n      'NUCLEOTIDE' => 'http://www.ncbi.nlm.nih.gov/entrez/query.fcgi?db=nucleotide&cmd=search&term=%s'\n    );\n    $MaxDescLen = 60;\n    $AlignmentLineWidth = 60;\n}\n\n\nuse base qw(Bio::Root::Root Bio::SearchIO::SearchWriterI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::Writer::HTMLResultWriter->new();\n Function: Builds a new Bio::SearchIO::Writer::HTMLResultWriter object \n Returns : Bio::SearchIO::Writer::HTMLResultWriter\n Args    : -filters => hashref with any or all of the keys (HSP HIT RESULT)\n           which have values pointing to a subroutine reference\n           which will expect to get a \n           -nucleotide_url => URL sprintf string base for the nt sequences\n           -protein_url => URL sprintf string base for the aa sequences\n           -no_wublastlinks => boolean. Do not display WU-BLAST lines \n                               even if they are parsed out.\n                               Links = (1) \n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($p,$n,$filters,\n      $nowublastlinks) = $self->_rearrange([qw(PROTEIN_URL \n\t\t\t\t\t       NUCLEOTIDE_URL \n\t\t\t\t\t       FILTERS\n\t\t\t\t\t       NO_WUBLASTLINKS)],@args);\n  $self->remote_database_url('p',$p || $RemoteURLDefault{'PROTEIN'});\n  $self->remote_database_url('n',$n || $RemoteURLDefault{'NUCLEOTIDE'});\n  $self->no_wublastlinks(! $nowublastlinks);\n  if( defined $filters ) {\n      if( !ref($filters) =~ /HASH/i ) { \n\t  $self->warn(\"Did not provide a hashref for the FILTERS option, ignoring.\");\n      } else { \n\t  while( my ($type,$code) = each %{$filters} ) {\n\t      $self->filter($type,$code);\n\t  }\n      }\n  }\n\n  return $self;\n}\n\n=head2 remote_database_url\n\n Title   : remote_database_url\n Usage   : $obj->remote_database_url($type,$newval)\n Function: This should return or set a string that contains a %s which can be\n           filled in with sprintf.\n Returns : value of remote_database_url\n Args    : $type - 'PROTEIN' or 'P' for protein URLS\n                   'NUCLEOTIDE' or 'N' for nucleotide URLS\n           $value - new value to set [optional]\n\n\n\nsub remote_database_url{\n   my ($self,$type,$value) = @_;\n   if( ! defined $type || $type !~ /^(P|N)/i ) { \n       $self->warn(\"Must provide a type (PROTEIN or NUCLEOTIDE)\");\n       return '';\n   }\n   $type = uc $1;\n   if( defined $value) {\n      $self->{'remote_database_url'}->{$type} = $value;\n    }\n   return $self->{'remote_database_url'}->{$type};\n}\n\n=head2 to_string\n\n Purpose   : Produces data for each Search::Result::ResultI in a string.\n           : This is an abstract method. For some useful implementations,\n           : see ResultTableWriter.pm, HitTableWriter.pm, \n           : and HSPTableWriter.pm.\n Usage     : print $writer->to_string( $result_obj, @args );\n Argument  : $result_obj = A Bio::Search::Result::ResultI object\n           : @args = any additional arguments used by your implementation.\n Returns   : String containing data for each search Result or any of its\n           : sub-objects (Hits and HSPs).\n Throws    : n/a\n\n\nsub to_string {\n    my ($self,$result,$num) = @_; \n    $num ||= 0;\n    return unless defined $result;\n    my $links = $self->no_wublastlinks;\n    my ($resultfilter,$hitfilter, $hspfilter) = ( $self->filter('RESULT'),\n\t\t\t\t\t\t  $self->filter('HIT'),\n\t\t\t\t\t\t  $self->filter('HSP') );\n    return '' if( defined $resultfilter && ! &{$resultfilter}($result) );    \n\n    my ($qtype,$dbtype,$dbseqtype,$type);\n    my $alg = $result->algorithm;\n    # This is actually wrong for the FASTAs I think\n    if(  $alg =~ /T(FAST|BLAST)([XY])/i ) {\n\t$qtype      = $dbtype = 'translated';\n\t$dbseqtype = $type       = 'PROTEIN';\n    } elsif( $alg =~ /T(FAST|BLAST)N/i ) {\n\t$qtype      = '';\n\t$dbtype     = 'translated';\n\t$type       = 'PROTEIN';\n\t$dbseqtype  = 'NUCLEOTIDE';\n    } elsif( $alg =~ /(FAST|BLAST)N/i || \n\t     $alg =~ /(WABA|EXONERATE)/i ) {\n\t$qtype      = $dbtype = '';\n\t$type = $dbseqtype  = 'NUCLEOTIDE';\n    } elsif( $alg =~ /(FAST|BLAST)P/  || \n\t     $alg =~ /SSEARCH|HMM(PFAM|SEARCH)/i ) {\n\t$qtype      = $dbtype = '';\n\t$type = $dbseqtype  = 'PROTEIN';\n    } elsif( $alg =~ /(FAST|BLAST)[XY]/i ) {\n\t$qtype      = 'translated';\n        $dbtype     = 'PROTEIN';\n\t$dbseqtype  = $type      = 'PROTEIN';\n    } else { \n\t$self->warn(\"algorithm was \", $result->algorithm, \" couldn't match\\n\");\n    }\n    \n    \n    my %baselens = ( 'Sbjct:'   => ( $dbtype eq 'translated' )  ? 3 : 1,\n\t\t     'Query:'   => ( $qtype  eq 'translated' )  ? 3 : 1);\n\n    my $str;\n    if( $num <= 1 ) { \n\t$str = &{$self->start_report}($result);\n    }\n\n    $str .= &{$self->title}($result);\n\n    $str .= $result->algorithm_reference || $self->algorithm_reference($result);\n    $str .= &{$self->introduction}($result);\n\n    $str .= \"<table border=0>\n            <tr><th>Sequences producing significant alignments:</th>\n            <th>Score<br>(bits)</th><th>E<br>value</th></tr>\";\n\n    my $hspstr = '<p><p>';\n    if( $result->can('rewind')) {\n        $result->rewind(); # support stream based parsing routines\n    }\n\n    while( my $hit = $result->next_hit ) {\n\tnext if( $hitfilter && ! &{$hitfilter}($hit) );\n\tmy $nm = $hit->name();\n\t\n\t$self->debug( \"no $nm for name (\".$hit->description(). \"\\n\") \n\t    unless $nm;\n\tmy ($gi,$acc) = &{$self->id_parser}($nm);\n\tmy $p = \"%-$MaxDescLen\". \"s\";\n\tmy $descsub;\n\tif( length($hit->description) > ($MaxDescLen - 3) ) {\n\t    $descsub = sprintf($p,\n\t\tsubstr($hit->description,0,$MaxDescLen-3) . \"...\");\n\t} else { \n\t    $descsub = sprintf($p,$hit->description);\n\t}\n\n\tmy $url_desc  = &{$self->hit_link_desc()}($self,$hit, $result);\n\tmy $url_align = &{$self->hit_link_align()}($self,$hit, $result);\n\n\tmy @hsps = $hit->hsps;\n\t\n\tif( ! @hsps ) {\n\t    # no HSPs so no link \n\t    $str .= sprintf('<tr><td>%s %s</td><td>%s</td><td>%.2g</td></tr>'.\"\\n\",\n\t\t\t    $url_desc, $descsub, \n\t\t\t    ($hit->bits ? $hit->bits : \n\t\t\t     (defined $hsps[0] ? $hsps[0]->bits : ' ')),\n\t\t\t    ( $hit->significance ? $hit->significance :\n\t\t\t      (defined $hsps[0] ? $hsps[0]->evalue : ' ')) \n\t\t\t    );\n\t} else { \n\t    # failover to first HSP if the data does not contain a \n\t    # bitscore/significance value for the Hit (NCBI XML data for one)\n\n\t    $str .= sprintf('<tr><td>%s %s</td><td>%s</td><td><a href=\"#%s\">%.2g</a></td></tr>'.\"\\n\",\n\t\t\t    $url_desc, $descsub, \n\t\t\t    ($hit->bits ? $hit->bits : \n\t\t\t     (defined $hsps[0] ? $hsps[0]->bits : ' ')),\n\t\t\t    $acc,\n\t\t\t    ( $hit->significance ? $hit->significance :\n\t\t\t      (defined $hsps[0] ? $hsps[0]->evalue : ' ')) \n\t\t\t    );\n        my $dline = &{$self->hit_desc_line}($self, $hit, $result);\n\t    $hspstr .= \"<a name=\\\"$acc\\\">\\n\".\n\t\tsprintf(\"><b>%s</b> %s</br><dd>Length = %s</dd><p>\\n\\n\", $url_align, \n\t\t\t$dline , &_numwithcommas($hit->length));\n\t    my $ct = 0;\n\t    foreach my $hsp (@hsps ) {\n\t\tnext if( $hspfilter && ! &{$hspfilter}($hsp) );\n\t\t$hspstr .= sprintf(\" Score = %s bits (%s), Expect = %s\",\n\t\t\t\t   $hsp->bits || $hsp->score, \n\t\t\t\t   $hsp->score || $hsp->bits, \n\t\t\t\t   $hsp->evalue || '');\n\t\tif( defined $hsp->pvalue ) {\n\t\t    $hspstr .= \", P = \".$hsp->pvalue;\n\t\t}\n\t\t$hspstr .= \"<br>\\n\";\n\t\t$hspstr .= sprintf(\" Identities = %d/%d (%d%%)\",\n\t\t\t\t   ( $hsp->frac_identical('total') * \n\t\t\t\t     $hsp->length('total')),\n\t\t\t\t   $hsp->length('total'),\n\t\t\t\t   $hsp->frac_identical('total') * 100);\n\n\t\tif( $type eq 'PROTEIN' ) {\n\t\t    $hspstr .= sprintf(\", Positives = %d/%d (%d%%)\",\n\t\t\t\t       ( $hsp->frac_conserved('total') * \n\t\t\t\t\t $hsp->length('total')),\n\t\t\t\t       $hsp->length('total'),\n\t\t\t\t       $hsp->frac_conserved('total') * 100);\n\t\t}\n\t\tif( $hsp->gaps ) {\n\t\t    $hspstr .= sprintf(\", Gaps = %d/%d (%d%%)\",\n\t\t\t\t       $hsp->gaps('total'),\n\t\t\t\t       $hsp->length('total'),\n\t\t\t\t       (100 * $hsp->gaps('total') / \n\t\t\t\t\t$hsp->length('total')));\n\t\t}\n\n\t\tmy ($hframe,$qframe)   = ( $hsp->hit->frame, $hsp->query->frame);\n\t\tmy ($hstrand,$qstrand) = ($hsp->hit->strand,$hsp->query->strand);\n\t\t# so TBLASTX will have Query/Hit frames\n\t\t#    BLASTX  will have Query frame\n\t\t#    TBLASTN will have Hit frame\n\t\tif( $hstrand || $qstrand ) {\n\t\t    $hspstr .= \", Frame = \";\n\t\t    my ($signq, $signh);\n\t\t    unless( $hstrand ) {\n\t\t\t$hframe = undef;\n\t\t\t# if strand is null or 0 then it is protein\n\t\t\t# and this no frame\n\t\t    } else { \n\t\t\t$signh = $hstrand < 0 ? '-' : '+';\n\t\t    }\n\t\t    unless( $qstrand  ) {\n\t\t\t$qframe = undef;\n\t\t\t# if strand is null or 0 then it is protein\n\t\t    } else { \n\t\t\t$signq =$qstrand < 0 ? '-' : '+';\n\t\t    }\n\t\t    # remember bioperl stores frames as 0,1,2 (GFF way)\n\t\t    # BLAST reports reports as 1,2,3 so\n\t\t    # we have to add 1 to the frame values\n\t\t    if( defined $hframe && ! defined $qframe) {  \n\t\t\t$hspstr .= \"$signh\".($hframe+1);\n\t\t    } elsif( defined $qframe && ! defined $hframe) {  \n\t\t\t$hspstr .= \"$signq\".($qframe+1);\n\t\t    } else { \n\t\t\t$hspstr .= sprintf(\" %s%d / %s%d\",\n\t\t\t\t\t   $signq,$qframe+1,\n\t\t\t\t\t   $signh, $hframe+1);\n\t\t    }\n\t\t}\n\t\tif($links && \n\t\t   $hsp->can('links') && defined(my $lnks = $hsp->links) ) {\n\t\t    $hspstr .= sprintf(\"<br>\\nLinks = %s\\n\",$lnks);\n\t\t}\n\n\t\t$hspstr .= \"</a><p>\\n<pre>\";\n\n\t\tmy @hspvals = ( {'name' => 'Query:',\n\t\t\t\t 'seq'  => $hsp->query_string,\n\t\t\t\t 'start' => ($qstrand >= 0 ? \n\t\t\t\t\t     $hsp->query->start : \n\t\t\t\t\t     $hsp->query->end),\n\t\t\t\t\t     'end'   => ($qstrand >= 0 ? \n\t\t\t\t\t\t\t $hsp->query->end : \n\t\t\t\t\t\t\t $hsp->query->start),\n\t\t\t\t\t\t\t 'index' => 0,\n\t\t\t\t\t\t\t 'direction' => $qstrand || 1\n\t\t\t\t\t\t     },\n\t\t\t\t{ 'name' => ' 'x6,\n\t\t\t\t  'seq'  => $hsp->homology_string,\n\t\t\t\t  'start' => undef,\n\t\t\t\t  'end'   => undef,\n\t\t\t\t  'index' => 0,\n\t\t\t\t  'direction' => 1\n\t\t\t\t  },\n\t\t\t\t{ 'name'  => 'Sbjct:',\n\t\t\t\t  'seq'   => $hsp->hit_string,\n\t\t\t\t  'start' => ($hstrand >= 0 ? \n\t\t\t\t\t      $hsp->hit->start : \n\t\t\t\t\t      $hsp->hit->end),\n\t\t\t\t\t      'end'   => ($hstrand >= 0 ? \n\t\t\t\t\t\t\t  $hsp->hit->end : \n\t\t\t\t\t\t\t  $hsp->hit->start),\n\t\t\t\t\t\t\t  'index' => 0, \n\t\t\t\t\t\t\t  'direction' => $hstrand || 1\n\t\t\t\t\t\t      }\n\t\t\t\t);\t    \n\n\n\t\t# let's set the expected length (in chars) of the starting number\n\t\t# in an alignment block so we can have things line up\n\t\t# Just going to try and set to the largest\n\n\t\tmy ($numwidth) = sort { $b <=> $a }(length($hspvals[0]->{'start'}),\n\t\t\t\t\t\t    length($hspvals[0]->{'end'}),\n\t\t\t\t\t\t    length($hspvals[2]->{'start'}),\n\t\t\t\t\t\t    length($hspvals[2]->{'end'}));\n\t\tmy $count = 0;\n\t\twhile ( $count < $hsp->length('total') ) {\n\t\t    foreach my $v ( @hspvals ) {\n\t\t\tmy $piece = substr($v->{'seq'}, $v->{'index'} + $count,\n\t\t\t\t\t   $AlignmentLineWidth);\n\t\t\tmy $cp = $piece;\n\t\t\tmy $plen = scalar ( $cp =~ tr/\\-//);\n\t\t\tmy ($start,$end) = ('','');\n\t\t\tif( defined $v->{'start'} ) { \n\t\t\t    $start = $v->{'start'};\n\t\t\t    # since strand can be + or - use the direction\n\t\t\t    # to signify which whether to add or substract from end\n\t\t\t    my $d = $v->{'direction'} * ( $AlignmentLineWidth - $plen )*\n\t\t\t\t$baselens{$v->{'name'}};\n\t\t\t    if( length($piece) < $AlignmentLineWidth ) {\n\t\t\t\t$d = (length($piece) - $plen) * $v->{'direction'} * \n\t\t\t\t    $baselens{$v->{'name'}};\n\t\t\t    }\n\t\t\t    $end   = $v->{'start'} + $d - $v->{'direction'};\n\t\t\t    $v->{'start'} += $d;\n\t\t\t}\n\t\t\t$hspstr .= sprintf(\"%s %-\".$numwidth.\"s %s %s\\n\",\n\t\t\t\t\t   $v->{'name'},\n\t\t\t\t\t   $start,\n\t\t\t\t\t   $piece,\n\t\t\t\t\t   $end\n\t\t\t\t\t   );\n\t\t    }\n\t\t    $count += $AlignmentLineWidth;\n\t\t    $hspstr .= \"\\n\\n\";\n\t\t}\n\t\t$hspstr .= \"</pre>\\n\";\n\t    }\n\t}\n#\t$hspstr .= \"</pre>\\n\";\n    }\n\n    $str .= \"</table><p>\\n\".$hspstr;\n    my ($pav, $sav) = ($result->available_parameters, $result->available_statistics);\n    if ($pav || $sav) {\n        # make table of search statistics and end the web page\n        $str .= \"<p><p><hr><h2>Search Parameters</h2>\";\n        if ($pav) {\n        $str .= \"<table border=1><tr><th>Parameter</th><th>Value</th>\\n\";\n        foreach my $param ( sort $result->available_parameters ) {\n            $str .= \"<tr><td>$param</td><td>\". $result->get_parameter($param) .\"</td></tr>\\n\";\n        }\n        $str .= \"</table>\";\n        }\n        \n        if ($sav) {\n        $str .= \"<p><h2>Search Statistics</h2><table border=1><tr><th>Statistic</th><th>Value</th></tr>\\n\";\n        foreach my $stat ( sort $result->available_statistics ) {\n            $str .= \"<tr><td>$stat</td><td>\". $result->get_statistic($stat). \"</td>\\n\";\n        }\n        $str .=  \"</tr></table>\";\n        }\n    }\n    $str .= $self->footer() . \"<P>\\n\";\n    return $str;\n}\n\n=head2 hit_link_desc\n\n Title   : hit_link_desc\n Usage   : $self->hit_link_desc(\\&link_function);\n Function: Get/Set the function which provides an HTML \n           link(s) for the given hit to be used\n           within the description section at the top of the BLAST report.\n           This allows a person reading the report within\n           a web browser to go to one or more database entries for\n           the given hit from the description section.\n Returns : Function reference\n Args    : Function reference\n See Also: L<default_hit_link_desc()>\n\n\nsub hit_link_desc{\n    my( $self, $code ) = @_; \n    if ($code) {\n        $self->{'_hit_link_desc'} = $code;\n    }\n    return $self->{'_hit_link_desc'} || \\&default_hit_link_desc;\n}\n\n=head2 default_hit_link_desc\n\n Title   : default_hit_link_desc\n Usage   : $self->default_hit_link_desc($hit, $result)\n Function: Provides an HTML link(s) for the given hit to be used\n           within the description section at the top of the BLAST report.\n           This allows a person reading the report within\n           a web browser to go to one or more database entries for\n           the given hit from the description section.\n Returns : string containing HTML markup \"<a href...\")\n\n           The default implementation returns an HTML link to the\n           URL supplied by the remote_database_url() method\n           and using the identifier supplied by the id_parser() method.\n           It will use the NCBI GI if present, and the accession if not.\n\n Args    : First argument is a Bio::Search::Hit::HitI\n           Second argument is a Bio::Search::Result::ResultI\n\nSee Also: L<hit_link_align>, L<remote_database>, L<id_parser>\n\n\nsub default_hit_link_desc {\n    my($self, $hit, $result) = @_;\n    my $type = ( $result->algorithm =~ /(P|X|Y)$/i ) ? 'PROTEIN' : 'NUCLEOTIDE';\n    my ($gi,$acc) = &{$self->id_parser}($hit->name);\n\n    my $url = length($self->remote_database_url($type)) > 0 ? \n              sprintf('<a href=\"%s\">%s</a>',\n                      sprintf($self->remote_database_url($type),$gi || $acc), \n                      $hit->name()) :  $hit->name();\n\n    return $url;\n}\n\n\n=head2 hit_link_align\n\n Title   : hit_link_align\n Usage   : $self->hit_link_align(\\&link_function);\n Function: Get/Set the function which provides an HTML link(s) \n           for the given hit to be used\n           within the HSP alignment section of the BLAST report.\n           This allows a person reading the report within\n           a web browser to go to one or more database entries for\n           the given hit from the alignment section.\n Returns : string containing HTML markup \"<a href...\")\n\n           The default implementation delegates to hit_link_desc().\n\n Args    : First argument is a Bio::Search::Hit::HitI\n           Second argument is a Bio::Search::Result::ResultI\n\nSee Also: L<hit_link_desc>, L<remote_database>, L<id_parser>\n\n\nsub hit_link_align {\n    my ($self,$code) = @_;\n    if ($code) {\n        $self->{'_hit_link_align'} = $code;\n    }\n    return $self->{'_hit_link_align'} || \\&default_hit_link_desc;\n}\n\n=head2 hit_desc_line\n\n Title   : hit_desc_line\n Usage   : $self->hit_desc_line(\\&link_function);\n Function: Get/Set the function which provides HTML for the description\n           information from a hit. This allows one to parse\n           the rest of the description and split up lines, add links, etc.\n Returns : Function reference\n Args    : Function reference\n See Also: L<default_hit_link_desc()>","parameters":[{"label":"$self"},{"label":"$code"}]}},{"name":"default_hit_desc_line","line":600,"kind":12},{"range":{"start":{"line":625,"character":0},"end":{"character":9999,"line":653}},"name":"default_hit_desc_line","line":625,"children":[{"line":626,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"default_hit_desc_line"},{"line":626,"kind":13,"name":"$hit","containerName":"default_hit_desc_line"},{"name":"$result","containerName":"default_hit_desc_line","kind":13,"line":626},{"localvar":"my","definition":"my","name":"$type","containerName":"default_hit_desc_line","line":627,"kind":13},{"line":627,"kind":13,"name":"$result","containerName":"default_hit_desc_line"},{"containerName":"default_hit_desc_line","name":"algorithm","kind":12,"line":627},{"line":628,"kind":13,"localvar":"my","definition":"my","name":"@descs","containerName":"default_hit_desc_line"},{"line":628,"kind":13,"name":"$hit","containerName":"default_hit_desc_line"},{"containerName":"default_hit_desc_line","name":"description","line":628,"kind":12},{"kind":13,"line":630,"containerName":"default_hit_desc_line","definition":"my","name":"$descline","localvar":"my"},{"containerName":"default_hit_desc_line","name":"$sec","definition":"my","localvar":"my","kind":13,"line":632},{"line":632,"kind":13,"containerName":"default_hit_desc_line","name":"@descs"},{"line":633,"kind":13,"localvar":"my","name":"$url","definition":"my","containerName":"default_hit_desc_line"},{"line":634,"kind":13,"containerName":"default_hit_desc_line","name":"$sec"},{"name":"$name","definition":"my","containerName":"default_hit_desc_line","localvar":"my","kind":13,"line":637},{"kind":13,"line":637,"name":"$gi","containerName":"default_hit_desc_line"},{"line":637,"kind":13,"name":"$db","containerName":"default_hit_desc_line"},{"containerName":"default_hit_desc_line","name":"$acc","line":637,"kind":13},{"line":639,"kind":13,"containerName":"default_hit_desc_line","name":"$acc"},{"line":640,"kind":13,"containerName":"default_hit_desc_line","name":"$acc"},{"name":"$url","containerName":"default_hit_desc_line","line":641,"kind":13},{"containerName":"default_hit_desc_line","name":"$self","kind":13,"line":642},{"name":"remote_database_url","containerName":"default_hit_desc_line","kind":12,"line":642},{"containerName":"default_hit_desc_line","name":"$type","kind":13,"line":642},{"containerName":"default_hit_desc_line","name":"$self","line":644,"kind":13},{"line":644,"kind":12,"containerName":"default_hit_desc_line","name":"remote_database_url"},{"line":644,"kind":13,"containerName":"default_hit_desc_line","name":"$type"},{"line":645,"kind":13,"name":"$gi","containerName":"default_hit_desc_line"},{"line":645,"kind":13,"containerName":"default_hit_desc_line","name":"$acc"},{"containerName":"default_hit_desc_line","name":"$db","kind":13,"line":645},{"containerName":"default_hit_desc_line","name":"$name","kind":13,"line":646},{"line":646,"kind":13,"containerName":"default_hit_desc_line","name":"$sec"},{"name":"$sec","containerName":"default_hit_desc_line","line":646,"kind":13},{"containerName":"default_hit_desc_line","name":"$url","line":648,"kind":13},{"line":648,"kind":13,"name":"$sec","containerName":"default_hit_desc_line"},{"containerName":"default_hit_desc_line","name":"$descline","line":650,"kind":13},{"containerName":"default_hit_desc_line","name":"$descline","kind":13,"line":652}],"kind":12,"detail":"($self,$hit,$result)","signature":{"documentation":"1;\n# $Id: HTMLResultWriter.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::Writer::HTMLResultWriter\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# Changes 2003-07-31 (jason)\n# Gary has cleaned up the code a lot to produce better looking HTML\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::Writer::HTMLResultWriter - write a Bio::Search::ResultI in HTML\n\n=head1 SYNOPSIS\n\n  use Bio::SearchIO;\n  use Bio::SearchIO::Writer::HTMLResultWriter;\n\n  my $in = Bio::SearchIO->new(-format => 'blast',\n\t\t\t     -file   => shift @ARGV);\n\n  my $writer = Bio::SearchIO::Writer::HTMLResultWriter->new();\n  my $out = Bio::SearchIO->new(-writer => $writer);\n  $out->write_result($in->next_result);\n\n\n  # to filter your output\n  my $MinLength = 100; # need a variable with scope outside the method\n  sub hsp_filter { \n      my $hsp = shift;\n      return 1 if $hsp->length('total') > $MinLength;\n  }\n  sub result_filter { \n      my $result = shift;\n      return $hsp->num_hits > 0;\n  }\n\n  my $writer = Bio::SearchIO::Writer::HTMLResultWriter->new\n                     (-filters => { 'HSP' => \\&hsp_filter} );\n  my $out = Bio::SearchIO->new(-writer => $writer);\n  $out->write_result($in->next_result);\n\n  # can also set the filter via the writer object\n  $writer->filter('RESULT', \\&result_filter);\n\n=head1 DESCRIPTION\n\nThis object implements the SearchWriterI interface which will produce\na set of HTML for a specific L<Bio::Search::Report::ReportI> interface.\n\nSee L<Bio::SearchIO::SearchWriterI> for more info on the filter method.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nGary Williams G.Williams@hgmp.mrc.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\npackage Bio::SearchIO::Writer::HTMLResultWriter;\nuse strict;\nuse vars qw(%RemoteURLDefault\n            $MaxDescLen $DATE $AlignmentLineWidth $Revision);\n\n# Object preamble - inherits from Bio::Root::RootI\n\nBEGIN {\n    $Revision = '$Id: HTMLResultWriter.pm 16123 2009-09-17 12:57:27Z cjfields $';\n    $DATE = localtime(time);\n    %RemoteURLDefault = ( \n      'PROTEIN' => 'http://www.ncbi.nlm.nih.gov/entrez/query.fcgi?db=protein&cmd=search&term=%s',\t\t\t  \n      'NUCLEOTIDE' => 'http://www.ncbi.nlm.nih.gov/entrez/query.fcgi?db=nucleotide&cmd=search&term=%s'\n    );\n    $MaxDescLen = 60;\n    $AlignmentLineWidth = 60;\n}\n\n\nuse base qw(Bio::Root::Root Bio::SearchIO::SearchWriterI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::Writer::HTMLResultWriter->new();\n Function: Builds a new Bio::SearchIO::Writer::HTMLResultWriter object \n Returns : Bio::SearchIO::Writer::HTMLResultWriter\n Args    : -filters => hashref with any or all of the keys (HSP HIT RESULT)\n           which have values pointing to a subroutine reference\n           which will expect to get a \n           -nucleotide_url => URL sprintf string base for the nt sequences\n           -protein_url => URL sprintf string base for the aa sequences\n           -no_wublastlinks => boolean. Do not display WU-BLAST lines \n                               even if they are parsed out.\n                               Links = (1) \n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($p,$n,$filters,\n      $nowublastlinks) = $self->_rearrange([qw(PROTEIN_URL \n\t\t\t\t\t       NUCLEOTIDE_URL \n\t\t\t\t\t       FILTERS\n\t\t\t\t\t       NO_WUBLASTLINKS)],@args);\n  $self->remote_database_url('p',$p || $RemoteURLDefault{'PROTEIN'});\n  $self->remote_database_url('n',$n || $RemoteURLDefault{'NUCLEOTIDE'});\n  $self->no_wublastlinks(! $nowublastlinks);\n  if( defined $filters ) {\n      if( !ref($filters) =~ /HASH/i ) { \n\t  $self->warn(\"Did not provide a hashref for the FILTERS option, ignoring.\");\n      } else { \n\t  while( my ($type,$code) = each %{$filters} ) {\n\t      $self->filter($type,$code);\n\t  }\n      }\n  }\n\n  return $self;\n}\n\n=head2 remote_database_url\n\n Title   : remote_database_url\n Usage   : $obj->remote_database_url($type,$newval)\n Function: This should return or set a string that contains a %s which can be\n           filled in with sprintf.\n Returns : value of remote_database_url\n Args    : $type - 'PROTEIN' or 'P' for protein URLS\n                   'NUCLEOTIDE' or 'N' for nucleotide URLS\n           $value - new value to set [optional]\n\n\n\nsub remote_database_url{\n   my ($self,$type,$value) = @_;\n   if( ! defined $type || $type !~ /^(P|N)/i ) { \n       $self->warn(\"Must provide a type (PROTEIN or NUCLEOTIDE)\");\n       return '';\n   }\n   $type = uc $1;\n   if( defined $value) {\n      $self->{'remote_database_url'}->{$type} = $value;\n    }\n   return $self->{'remote_database_url'}->{$type};\n}\n\n=head2 to_string\n\n Purpose   : Produces data for each Search::Result::ResultI in a string.\n           : This is an abstract method. For some useful implementations,\n           : see ResultTableWriter.pm, HitTableWriter.pm, \n           : and HSPTableWriter.pm.\n Usage     : print $writer->to_string( $result_obj, @args );\n Argument  : $result_obj = A Bio::Search::Result::ResultI object\n           : @args = any additional arguments used by your implementation.\n Returns   : String containing data for each search Result or any of its\n           : sub-objects (Hits and HSPs).\n Throws    : n/a\n\n\nsub to_string {\n    my ($self,$result,$num) = @_; \n    $num ||= 0;\n    return unless defined $result;\n    my $links = $self->no_wublastlinks;\n    my ($resultfilter,$hitfilter, $hspfilter) = ( $self->filter('RESULT'),\n\t\t\t\t\t\t  $self->filter('HIT'),\n\t\t\t\t\t\t  $self->filter('HSP') );\n    return '' if( defined $resultfilter && ! &{$resultfilter}($result) );    \n\n    my ($qtype,$dbtype,$dbseqtype,$type);\n    my $alg = $result->algorithm;\n    # This is actually wrong for the FASTAs I think\n    if(  $alg =~ /T(FAST|BLAST)([XY])/i ) {\n\t$qtype      = $dbtype = 'translated';\n\t$dbseqtype = $type       = 'PROTEIN';\n    } elsif( $alg =~ /T(FAST|BLAST)N/i ) {\n\t$qtype      = '';\n\t$dbtype     = 'translated';\n\t$type       = 'PROTEIN';\n\t$dbseqtype  = 'NUCLEOTIDE';\n    } elsif( $alg =~ /(FAST|BLAST)N/i || \n\t     $alg =~ /(WABA|EXONERATE)/i ) {\n\t$qtype      = $dbtype = '';\n\t$type = $dbseqtype  = 'NUCLEOTIDE';\n    } elsif( $alg =~ /(FAST|BLAST)P/  || \n\t     $alg =~ /SSEARCH|HMM(PFAM|SEARCH)/i ) {\n\t$qtype      = $dbtype = '';\n\t$type = $dbseqtype  = 'PROTEIN';\n    } elsif( $alg =~ /(FAST|BLAST)[XY]/i ) {\n\t$qtype      = 'translated';\n        $dbtype     = 'PROTEIN';\n\t$dbseqtype  = $type      = 'PROTEIN';\n    } else { \n\t$self->warn(\"algorithm was \", $result->algorithm, \" couldn't match\\n\");\n    }\n    \n    \n    my %baselens = ( 'Sbjct:'   => ( $dbtype eq 'translated' )  ? 3 : 1,\n\t\t     'Query:'   => ( $qtype  eq 'translated' )  ? 3 : 1);\n\n    my $str;\n    if( $num <= 1 ) { \n\t$str = &{$self->start_report}($result);\n    }\n\n    $str .= &{$self->title}($result);\n\n    $str .= $result->algorithm_reference || $self->algorithm_reference($result);\n    $str .= &{$self->introduction}($result);\n\n    $str .= \"<table border=0>\n            <tr><th>Sequences producing significant alignments:</th>\n            <th>Score<br>(bits)</th><th>E<br>value</th></tr>\";\n\n    my $hspstr = '<p><p>';\n    if( $result->can('rewind')) {\n        $result->rewind(); # support stream based parsing routines\n    }\n\n    while( my $hit = $result->next_hit ) {\n\tnext if( $hitfilter && ! &{$hitfilter}($hit) );\n\tmy $nm = $hit->name();\n\t\n\t$self->debug( \"no $nm for name (\".$hit->description(). \"\\n\") \n\t    unless $nm;\n\tmy ($gi,$acc) = &{$self->id_parser}($nm);\n\tmy $p = \"%-$MaxDescLen\". \"s\";\n\tmy $descsub;\n\tif( length($hit->description) > ($MaxDescLen - 3) ) {\n\t    $descsub = sprintf($p,\n\t\tsubstr($hit->description,0,$MaxDescLen-3) . \"...\");\n\t} else { \n\t    $descsub = sprintf($p,$hit->description);\n\t}\n\n\tmy $url_desc  = &{$self->hit_link_desc()}($self,$hit, $result);\n\tmy $url_align = &{$self->hit_link_align()}($self,$hit, $result);\n\n\tmy @hsps = $hit->hsps;\n\t\n\tif( ! @hsps ) {\n\t    # no HSPs so no link \n\t    $str .= sprintf('<tr><td>%s %s</td><td>%s</td><td>%.2g</td></tr>'.\"\\n\",\n\t\t\t    $url_desc, $descsub, \n\t\t\t    ($hit->bits ? $hit->bits : \n\t\t\t     (defined $hsps[0] ? $hsps[0]->bits : ' ')),\n\t\t\t    ( $hit->significance ? $hit->significance :\n\t\t\t      (defined $hsps[0] ? $hsps[0]->evalue : ' ')) \n\t\t\t    );\n\t} else { \n\t    # failover to first HSP if the data does not contain a \n\t    # bitscore/significance value for the Hit (NCBI XML data for one)\n\n\t    $str .= sprintf('<tr><td>%s %s</td><td>%s</td><td><a href=\"#%s\">%.2g</a></td></tr>'.\"\\n\",\n\t\t\t    $url_desc, $descsub, \n\t\t\t    ($hit->bits ? $hit->bits : \n\t\t\t     (defined $hsps[0] ? $hsps[0]->bits : ' ')),\n\t\t\t    $acc,\n\t\t\t    ( $hit->significance ? $hit->significance :\n\t\t\t      (defined $hsps[0] ? $hsps[0]->evalue : ' ')) \n\t\t\t    );\n        my $dline = &{$self->hit_desc_line}($self, $hit, $result);\n\t    $hspstr .= \"<a name=\\\"$acc\\\">\\n\".\n\t\tsprintf(\"><b>%s</b> %s</br><dd>Length = %s</dd><p>\\n\\n\", $url_align, \n\t\t\t$dline , &_numwithcommas($hit->length));\n\t    my $ct = 0;\n\t    foreach my $hsp (@hsps ) {\n\t\tnext if( $hspfilter && ! &{$hspfilter}($hsp) );\n\t\t$hspstr .= sprintf(\" Score = %s bits (%s), Expect = %s\",\n\t\t\t\t   $hsp->bits || $hsp->score, \n\t\t\t\t   $hsp->score || $hsp->bits, \n\t\t\t\t   $hsp->evalue || '');\n\t\tif( defined $hsp->pvalue ) {\n\t\t    $hspstr .= \", P = \".$hsp->pvalue;\n\t\t}\n\t\t$hspstr .= \"<br>\\n\";\n\t\t$hspstr .= sprintf(\" Identities = %d/%d (%d%%)\",\n\t\t\t\t   ( $hsp->frac_identical('total') * \n\t\t\t\t     $hsp->length('total')),\n\t\t\t\t   $hsp->length('total'),\n\t\t\t\t   $hsp->frac_identical('total') * 100);\n\n\t\tif( $type eq 'PROTEIN' ) {\n\t\t    $hspstr .= sprintf(\", Positives = %d/%d (%d%%)\",\n\t\t\t\t       ( $hsp->frac_conserved('total') * \n\t\t\t\t\t $hsp->length('total')),\n\t\t\t\t       $hsp->length('total'),\n\t\t\t\t       $hsp->frac_conserved('total') * 100);\n\t\t}\n\t\tif( $hsp->gaps ) {\n\t\t    $hspstr .= sprintf(\", Gaps = %d/%d (%d%%)\",\n\t\t\t\t       $hsp->gaps('total'),\n\t\t\t\t       $hsp->length('total'),\n\t\t\t\t       (100 * $hsp->gaps('total') / \n\t\t\t\t\t$hsp->length('total')));\n\t\t}\n\n\t\tmy ($hframe,$qframe)   = ( $hsp->hit->frame, $hsp->query->frame);\n\t\tmy ($hstrand,$qstrand) = ($hsp->hit->strand,$hsp->query->strand);\n\t\t# so TBLASTX will have Query/Hit frames\n\t\t#    BLASTX  will have Query frame\n\t\t#    TBLASTN will have Hit frame\n\t\tif( $hstrand || $qstrand ) {\n\t\t    $hspstr .= \", Frame = \";\n\t\t    my ($signq, $signh);\n\t\t    unless( $hstrand ) {\n\t\t\t$hframe = undef;\n\t\t\t# if strand is null or 0 then it is protein\n\t\t\t# and this no frame\n\t\t    } else { \n\t\t\t$signh = $hstrand < 0 ? '-' : '+';\n\t\t    }\n\t\t    unless( $qstrand  ) {\n\t\t\t$qframe = undef;\n\t\t\t# if strand is null or 0 then it is protein\n\t\t    } else { \n\t\t\t$signq =$qstrand < 0 ? '-' : '+';\n\t\t    }\n\t\t    # remember bioperl stores frames as 0,1,2 (GFF way)\n\t\t    # BLAST reports reports as 1,2,3 so\n\t\t    # we have to add 1 to the frame values\n\t\t    if( defined $hframe && ! defined $qframe) {  \n\t\t\t$hspstr .= \"$signh\".($hframe+1);\n\t\t    } elsif( defined $qframe && ! defined $hframe) {  \n\t\t\t$hspstr .= \"$signq\".($qframe+1);\n\t\t    } else { \n\t\t\t$hspstr .= sprintf(\" %s%d / %s%d\",\n\t\t\t\t\t   $signq,$qframe+1,\n\t\t\t\t\t   $signh, $hframe+1);\n\t\t    }\n\t\t}\n\t\tif($links && \n\t\t   $hsp->can('links') && defined(my $lnks = $hsp->links) ) {\n\t\t    $hspstr .= sprintf(\"<br>\\nLinks = %s\\n\",$lnks);\n\t\t}\n\n\t\t$hspstr .= \"</a><p>\\n<pre>\";\n\n\t\tmy @hspvals = ( {'name' => 'Query:',\n\t\t\t\t 'seq'  => $hsp->query_string,\n\t\t\t\t 'start' => ($qstrand >= 0 ? \n\t\t\t\t\t     $hsp->query->start : \n\t\t\t\t\t     $hsp->query->end),\n\t\t\t\t\t     'end'   => ($qstrand >= 0 ? \n\t\t\t\t\t\t\t $hsp->query->end : \n\t\t\t\t\t\t\t $hsp->query->start),\n\t\t\t\t\t\t\t 'index' => 0,\n\t\t\t\t\t\t\t 'direction' => $qstrand || 1\n\t\t\t\t\t\t     },\n\t\t\t\t{ 'name' => ' 'x6,\n\t\t\t\t  'seq'  => $hsp->homology_string,\n\t\t\t\t  'start' => undef,\n\t\t\t\t  'end'   => undef,\n\t\t\t\t  'index' => 0,\n\t\t\t\t  'direction' => 1\n\t\t\t\t  },\n\t\t\t\t{ 'name'  => 'Sbjct:',\n\t\t\t\t  'seq'   => $hsp->hit_string,\n\t\t\t\t  'start' => ($hstrand >= 0 ? \n\t\t\t\t\t      $hsp->hit->start : \n\t\t\t\t\t      $hsp->hit->end),\n\t\t\t\t\t      'end'   => ($hstrand >= 0 ? \n\t\t\t\t\t\t\t  $hsp->hit->end : \n\t\t\t\t\t\t\t  $hsp->hit->start),\n\t\t\t\t\t\t\t  'index' => 0, \n\t\t\t\t\t\t\t  'direction' => $hstrand || 1\n\t\t\t\t\t\t      }\n\t\t\t\t);\t    \n\n\n\t\t# let's set the expected length (in chars) of the starting number\n\t\t# in an alignment block so we can have things line up\n\t\t# Just going to try and set to the largest\n\n\t\tmy ($numwidth) = sort { $b <=> $a }(length($hspvals[0]->{'start'}),\n\t\t\t\t\t\t    length($hspvals[0]->{'end'}),\n\t\t\t\t\t\t    length($hspvals[2]->{'start'}),\n\t\t\t\t\t\t    length($hspvals[2]->{'end'}));\n\t\tmy $count = 0;\n\t\twhile ( $count < $hsp->length('total') ) {\n\t\t    foreach my $v ( @hspvals ) {\n\t\t\tmy $piece = substr($v->{'seq'}, $v->{'index'} + $count,\n\t\t\t\t\t   $AlignmentLineWidth);\n\t\t\tmy $cp = $piece;\n\t\t\tmy $plen = scalar ( $cp =~ tr/\\-//);\n\t\t\tmy ($start,$end) = ('','');\n\t\t\tif( defined $v->{'start'} ) { \n\t\t\t    $start = $v->{'start'};\n\t\t\t    # since strand can be + or - use the direction\n\t\t\t    # to signify which whether to add or substract from end\n\t\t\t    my $d = $v->{'direction'} * ( $AlignmentLineWidth - $plen )*\n\t\t\t\t$baselens{$v->{'name'}};\n\t\t\t    if( length($piece) < $AlignmentLineWidth ) {\n\t\t\t\t$d = (length($piece) - $plen) * $v->{'direction'} * \n\t\t\t\t    $baselens{$v->{'name'}};\n\t\t\t    }\n\t\t\t    $end   = $v->{'start'} + $d - $v->{'direction'};\n\t\t\t    $v->{'start'} += $d;\n\t\t\t}\n\t\t\t$hspstr .= sprintf(\"%s %-\".$numwidth.\"s %s %s\\n\",\n\t\t\t\t\t   $v->{'name'},\n\t\t\t\t\t   $start,\n\t\t\t\t\t   $piece,\n\t\t\t\t\t   $end\n\t\t\t\t\t   );\n\t\t    }\n\t\t    $count += $AlignmentLineWidth;\n\t\t    $hspstr .= \"\\n\\n\";\n\t\t}\n\t\t$hspstr .= \"</pre>\\n\";\n\t    }\n\t}\n#\t$hspstr .= \"</pre>\\n\";\n    }\n\n    $str .= \"</table><p>\\n\".$hspstr;\n    my ($pav, $sav) = ($result->available_parameters, $result->available_statistics);\n    if ($pav || $sav) {\n        # make table of search statistics and end the web page\n        $str .= \"<p><p><hr><h2>Search Parameters</h2>\";\n        if ($pav) {\n        $str .= \"<table border=1><tr><th>Parameter</th><th>Value</th>\\n\";\n        foreach my $param ( sort $result->available_parameters ) {\n            $str .= \"<tr><td>$param</td><td>\". $result->get_parameter($param) .\"</td></tr>\\n\";\n        }\n        $str .= \"</table>\";\n        }\n        \n        if ($sav) {\n        $str .= \"<p><h2>Search Statistics</h2><table border=1><tr><th>Statistic</th><th>Value</th></tr>\\n\";\n        foreach my $stat ( sort $result->available_statistics ) {\n            $str .= \"<tr><td>$stat</td><td>\". $result->get_statistic($stat). \"</td>\\n\";\n        }\n        $str .=  \"</tr></table>\";\n        }\n    }\n    $str .= $self->footer() . \"<P>\\n\";\n    return $str;\n}\n\n=head2 hit_link_desc\n\n Title   : hit_link_desc\n Usage   : $self->hit_link_desc(\\&link_function);\n Function: Get/Set the function which provides an HTML \n           link(s) for the given hit to be used\n           within the description section at the top of the BLAST report.\n           This allows a person reading the report within\n           a web browser to go to one or more database entries for\n           the given hit from the description section.\n Returns : Function reference\n Args    : Function reference\n See Also: L<default_hit_link_desc()>\n\n\nsub hit_link_desc{\n    my( $self, $code ) = @_; \n    if ($code) {\n        $self->{'_hit_link_desc'} = $code;\n    }\n    return $self->{'_hit_link_desc'} || \\&default_hit_link_desc;\n}\n\n=head2 default_hit_link_desc\n\n Title   : default_hit_link_desc\n Usage   : $self->default_hit_link_desc($hit, $result)\n Function: Provides an HTML link(s) for the given hit to be used\n           within the description section at the top of the BLAST report.\n           This allows a person reading the report within\n           a web browser to go to one or more database entries for\n           the given hit from the description section.\n Returns : string containing HTML markup \"<a href...\")\n\n           The default implementation returns an HTML link to the\n           URL supplied by the remote_database_url() method\n           and using the identifier supplied by the id_parser() method.\n           It will use the NCBI GI if present, and the accession if not.\n\n Args    : First argument is a Bio::Search::Hit::HitI\n           Second argument is a Bio::Search::Result::ResultI\n\nSee Also: L<hit_link_align>, L<remote_database>, L<id_parser>\n\n\nsub default_hit_link_desc {\n    my($self, $hit, $result) = @_;\n    my $type = ( $result->algorithm =~ /(P|X|Y)$/i ) ? 'PROTEIN' : 'NUCLEOTIDE';\n    my ($gi,$acc) = &{$self->id_parser}($hit->name);\n\n    my $url = length($self->remote_database_url($type)) > 0 ? \n              sprintf('<a href=\"%s\">%s</a>',\n                      sprintf($self->remote_database_url($type),$gi || $acc), \n                      $hit->name()) :  $hit->name();\n\n    return $url;\n}\n\n\n=head2 hit_link_align\n\n Title   : hit_link_align\n Usage   : $self->hit_link_align(\\&link_function);\n Function: Get/Set the function which provides an HTML link(s) \n           for the given hit to be used\n           within the HSP alignment section of the BLAST report.\n           This allows a person reading the report within\n           a web browser to go to one or more database entries for\n           the given hit from the alignment section.\n Returns : string containing HTML markup \"<a href...\")\n\n           The default implementation delegates to hit_link_desc().\n\n Args    : First argument is a Bio::Search::Hit::HitI\n           Second argument is a Bio::Search::Result::ResultI\n\nSee Also: L<hit_link_desc>, L<remote_database>, L<id_parser>\n\n\nsub hit_link_align {\n    my ($self,$code) = @_;\n    if ($code) {\n        $self->{'_hit_link_align'} = $code;\n    }\n    return $self->{'_hit_link_align'} || \\&default_hit_link_desc;\n}\n\n=head2 hit_desc_line\n\n Title   : hit_desc_line\n Usage   : $self->hit_desc_line(\\&link_function);\n Function: Get/Set the function which provides HTML for the description\n           information from a hit. This allows one to parse\n           the rest of the description and split up lines, add links, etc.\n Returns : Function reference\n Args    : Function reference\n See Also: L<default_hit_link_desc()>\n\n\nsub hit_desc_line{\n    my( $self, $code ) = @_; \n    if ($code) {\n        $self->{'_hit_desc_line'} = $code;\n    }\n    return $self->{'_hit_desc_line'} || \\&default_hit_desc_line;\n}\n\n=head2 default_hit_desc_line\n\n Title   : default_hit_desc_line\n Usage   : $self->default_hit_desc_line($hit, $result)\n Function: Parses the description line information, splits based on the\n           hidden \\x01 between independent descriptions, checks the lines for\n           possible web links, and adds HTML link(s) for the given hit to be\n           used.\n\n Returns : string containing HTML markup \"<a href...\")\n           The default implementation returns an HTML link to the\n           URL supplied by the remote_database_url() method\n           and using the identifier supplied by the id_parser() method.\n           It will use the NCBI GI if present, and the accession if not.\n\n Args    : First argument is a Bio::Search::Hit::HitI\n           Second argument is a Bio::Search::Result::ResultI\n\nSee Also: L<hit_link_align>, L<remote_database>, L<id_parser>","parameters":[{"label":"$self"},{"label":"$hit"},{"label":"$result"}],"label":"default_hit_desc_line($self,$hit,$result)"},"containerName":"main::","definition":"sub"},{"detail":"($self,$code)","signature":{"label":"start_report($self,$code)","parameters":[{"label":"$self"},{"label":"$code"}],"documentation":"1;\n# $Id: HTMLResultWriter.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::Writer::HTMLResultWriter\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# Changes 2003-07-31 (jason)\n# Gary has cleaned up the code a lot to produce better looking HTML\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::Writer::HTMLResultWriter - write a Bio::Search::ResultI in HTML\n\n=head1 SYNOPSIS\n\n  use Bio::SearchIO;\n  use Bio::SearchIO::Writer::HTMLResultWriter;\n\n  my $in = Bio::SearchIO->new(-format => 'blast',\n\t\t\t     -file   => shift @ARGV);\n\n  my $writer = Bio::SearchIO::Writer::HTMLResultWriter->new();\n  my $out = Bio::SearchIO->new(-writer => $writer);\n  $out->write_result($in->next_result);\n\n\n  # to filter your output\n  my $MinLength = 100; # need a variable with scope outside the method\n  sub hsp_filter { \n      my $hsp = shift;\n      return 1 if $hsp->length('total') > $MinLength;\n  }\n  sub result_filter { \n      my $result = shift;\n      return $hsp->num_hits > 0;\n  }\n\n  my $writer = Bio::SearchIO::Writer::HTMLResultWriter->new\n                     (-filters => { 'HSP' => \\&hsp_filter} );\n  my $out = Bio::SearchIO->new(-writer => $writer);\n  $out->write_result($in->next_result);\n\n  # can also set the filter via the writer object\n  $writer->filter('RESULT', \\&result_filter);\n\n=head1 DESCRIPTION\n\nThis object implements the SearchWriterI interface which will produce\na set of HTML for a specific L<Bio::Search::Report::ReportI> interface.\n\nSee L<Bio::SearchIO::SearchWriterI> for more info on the filter method.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nGary Williams G.Williams@hgmp.mrc.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\npackage Bio::SearchIO::Writer::HTMLResultWriter;\nuse strict;\nuse vars qw(%RemoteURLDefault\n            $MaxDescLen $DATE $AlignmentLineWidth $Revision);\n\n# Object preamble - inherits from Bio::Root::RootI\n\nBEGIN {\n    $Revision = '$Id: HTMLResultWriter.pm 16123 2009-09-17 12:57:27Z cjfields $';\n    $DATE = localtime(time);\n    %RemoteURLDefault = ( \n      'PROTEIN' => 'http://www.ncbi.nlm.nih.gov/entrez/query.fcgi?db=protein&cmd=search&term=%s',\t\t\t  \n      'NUCLEOTIDE' => 'http://www.ncbi.nlm.nih.gov/entrez/query.fcgi?db=nucleotide&cmd=search&term=%s'\n    );\n    $MaxDescLen = 60;\n    $AlignmentLineWidth = 60;\n}\n\n\nuse base qw(Bio::Root::Root Bio::SearchIO::SearchWriterI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::Writer::HTMLResultWriter->new();\n Function: Builds a new Bio::SearchIO::Writer::HTMLResultWriter object \n Returns : Bio::SearchIO::Writer::HTMLResultWriter\n Args    : -filters => hashref with any or all of the keys (HSP HIT RESULT)\n           which have values pointing to a subroutine reference\n           which will expect to get a \n           -nucleotide_url => URL sprintf string base for the nt sequences\n           -protein_url => URL sprintf string base for the aa sequences\n           -no_wublastlinks => boolean. Do not display WU-BLAST lines \n                               even if they are parsed out.\n                               Links = (1) \n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($p,$n,$filters,\n      $nowublastlinks) = $self->_rearrange([qw(PROTEIN_URL \n\t\t\t\t\t       NUCLEOTIDE_URL \n\t\t\t\t\t       FILTERS\n\t\t\t\t\t       NO_WUBLASTLINKS)],@args);\n  $self->remote_database_url('p',$p || $RemoteURLDefault{'PROTEIN'});\n  $self->remote_database_url('n',$n || $RemoteURLDefault{'NUCLEOTIDE'});\n  $self->no_wublastlinks(! $nowublastlinks);\n  if( defined $filters ) {\n      if( !ref($filters) =~ /HASH/i ) { \n\t  $self->warn(\"Did not provide a hashref for the FILTERS option, ignoring.\");\n      } else { \n\t  while( my ($type,$code) = each %{$filters} ) {\n\t      $self->filter($type,$code);\n\t  }\n      }\n  }\n\n  return $self;\n}\n\n=head2 remote_database_url\n\n Title   : remote_database_url\n Usage   : $obj->remote_database_url($type,$newval)\n Function: This should return or set a string that contains a %s which can be\n           filled in with sprintf.\n Returns : value of remote_database_url\n Args    : $type - 'PROTEIN' or 'P' for protein URLS\n                   'NUCLEOTIDE' or 'N' for nucleotide URLS\n           $value - new value to set [optional]\n\n\n\nsub remote_database_url{\n   my ($self,$type,$value) = @_;\n   if( ! defined $type || $type !~ /^(P|N)/i ) { \n       $self->warn(\"Must provide a type (PROTEIN or NUCLEOTIDE)\");\n       return '';\n   }\n   $type = uc $1;\n   if( defined $value) {\n      $self->{'remote_database_url'}->{$type} = $value;\n    }\n   return $self->{'remote_database_url'}->{$type};\n}\n\n=head2 to_string\n\n Purpose   : Produces data for each Search::Result::ResultI in a string.\n           : This is an abstract method. For some useful implementations,\n           : see ResultTableWriter.pm, HitTableWriter.pm, \n           : and HSPTableWriter.pm.\n Usage     : print $writer->to_string( $result_obj, @args );\n Argument  : $result_obj = A Bio::Search::Result::ResultI object\n           : @args = any additional arguments used by your implementation.\n Returns   : String containing data for each search Result or any of its\n           : sub-objects (Hits and HSPs).\n Throws    : n/a\n\n\nsub to_string {\n    my ($self,$result,$num) = @_; \n    $num ||= 0;\n    return unless defined $result;\n    my $links = $self->no_wublastlinks;\n    my ($resultfilter,$hitfilter, $hspfilter) = ( $self->filter('RESULT'),\n\t\t\t\t\t\t  $self->filter('HIT'),\n\t\t\t\t\t\t  $self->filter('HSP') );\n    return '' if( defined $resultfilter && ! &{$resultfilter}($result) );    \n\n    my ($qtype,$dbtype,$dbseqtype,$type);\n    my $alg = $result->algorithm;\n    # This is actually wrong for the FASTAs I think\n    if(  $alg =~ /T(FAST|BLAST)([XY])/i ) {\n\t$qtype      = $dbtype = 'translated';\n\t$dbseqtype = $type       = 'PROTEIN';\n    } elsif( $alg =~ /T(FAST|BLAST)N/i ) {\n\t$qtype      = '';\n\t$dbtype     = 'translated';\n\t$type       = 'PROTEIN';\n\t$dbseqtype  = 'NUCLEOTIDE';\n    } elsif( $alg =~ /(FAST|BLAST)N/i || \n\t     $alg =~ /(WABA|EXONERATE)/i ) {\n\t$qtype      = $dbtype = '';\n\t$type = $dbseqtype  = 'NUCLEOTIDE';\n    } elsif( $alg =~ /(FAST|BLAST)P/  || \n\t     $alg =~ /SSEARCH|HMM(PFAM|SEARCH)/i ) {\n\t$qtype      = $dbtype = '';\n\t$type = $dbseqtype  = 'PROTEIN';\n    } elsif( $alg =~ /(FAST|BLAST)[XY]/i ) {\n\t$qtype      = 'translated';\n        $dbtype     = 'PROTEIN';\n\t$dbseqtype  = $type      = 'PROTEIN';\n    } else { \n\t$self->warn(\"algorithm was \", $result->algorithm, \" couldn't match\\n\");\n    }\n    \n    \n    my %baselens = ( 'Sbjct:'   => ( $dbtype eq 'translated' )  ? 3 : 1,\n\t\t     'Query:'   => ( $qtype  eq 'translated' )  ? 3 : 1);\n\n    my $str;\n    if( $num <= 1 ) { \n\t$str = &{$self->start_report}($result);\n    }\n\n    $str .= &{$self->title}($result);\n\n    $str .= $result->algorithm_reference || $self->algorithm_reference($result);\n    $str .= &{$self->introduction}($result);\n\n    $str .= \"<table border=0>\n            <tr><th>Sequences producing significant alignments:</th>\n            <th>Score<br>(bits)</th><th>E<br>value</th></tr>\";\n\n    my $hspstr = '<p><p>';\n    if( $result->can('rewind')) {\n        $result->rewind(); # support stream based parsing routines\n    }\n\n    while( my $hit = $result->next_hit ) {\n\tnext if( $hitfilter && ! &{$hitfilter}($hit) );\n\tmy $nm = $hit->name();\n\t\n\t$self->debug( \"no $nm for name (\".$hit->description(). \"\\n\") \n\t    unless $nm;\n\tmy ($gi,$acc) = &{$self->id_parser}($nm);\n\tmy $p = \"%-$MaxDescLen\". \"s\";\n\tmy $descsub;\n\tif( length($hit->description) > ($MaxDescLen - 3) ) {\n\t    $descsub = sprintf($p,\n\t\tsubstr($hit->description,0,$MaxDescLen-3) . \"...\");\n\t} else { \n\t    $descsub = sprintf($p,$hit->description);\n\t}\n\n\tmy $url_desc  = &{$self->hit_link_desc()}($self,$hit, $result);\n\tmy $url_align = &{$self->hit_link_align()}($self,$hit, $result);\n\n\tmy @hsps = $hit->hsps;\n\t\n\tif( ! @hsps ) {\n\t    # no HSPs so no link \n\t    $str .= sprintf('<tr><td>%s %s</td><td>%s</td><td>%.2g</td></tr>'.\"\\n\",\n\t\t\t    $url_desc, $descsub, \n\t\t\t    ($hit->bits ? $hit->bits : \n\t\t\t     (defined $hsps[0] ? $hsps[0]->bits : ' ')),\n\t\t\t    ( $hit->significance ? $hit->significance :\n\t\t\t      (defined $hsps[0] ? $hsps[0]->evalue : ' ')) \n\t\t\t    );\n\t} else { \n\t    # failover to first HSP if the data does not contain a \n\t    # bitscore/significance value for the Hit (NCBI XML data for one)\n\n\t    $str .= sprintf('<tr><td>%s %s</td><td>%s</td><td><a href=\"#%s\">%.2g</a></td></tr>'.\"\\n\",\n\t\t\t    $url_desc, $descsub, \n\t\t\t    ($hit->bits ? $hit->bits : \n\t\t\t     (defined $hsps[0] ? $hsps[0]->bits : ' ')),\n\t\t\t    $acc,\n\t\t\t    ( $hit->significance ? $hit->significance :\n\t\t\t      (defined $hsps[0] ? $hsps[0]->evalue : ' ')) \n\t\t\t    );\n        my $dline = &{$self->hit_desc_line}($self, $hit, $result);\n\t    $hspstr .= \"<a name=\\\"$acc\\\">\\n\".\n\t\tsprintf(\"><b>%s</b> %s</br><dd>Length = %s</dd><p>\\n\\n\", $url_align, \n\t\t\t$dline , &_numwithcommas($hit->length));\n\t    my $ct = 0;\n\t    foreach my $hsp (@hsps ) {\n\t\tnext if( $hspfilter && ! &{$hspfilter}($hsp) );\n\t\t$hspstr .= sprintf(\" Score = %s bits (%s), Expect = %s\",\n\t\t\t\t   $hsp->bits || $hsp->score, \n\t\t\t\t   $hsp->score || $hsp->bits, \n\t\t\t\t   $hsp->evalue || '');\n\t\tif( defined $hsp->pvalue ) {\n\t\t    $hspstr .= \", P = \".$hsp->pvalue;\n\t\t}\n\t\t$hspstr .= \"<br>\\n\";\n\t\t$hspstr .= sprintf(\" Identities = %d/%d (%d%%)\",\n\t\t\t\t   ( $hsp->frac_identical('total') * \n\t\t\t\t     $hsp->length('total')),\n\t\t\t\t   $hsp->length('total'),\n\t\t\t\t   $hsp->frac_identical('total') * 100);\n\n\t\tif( $type eq 'PROTEIN' ) {\n\t\t    $hspstr .= sprintf(\", Positives = %d/%d (%d%%)\",\n\t\t\t\t       ( $hsp->frac_conserved('total') * \n\t\t\t\t\t $hsp->length('total')),\n\t\t\t\t       $hsp->length('total'),\n\t\t\t\t       $hsp->frac_conserved('total') * 100);\n\t\t}\n\t\tif( $hsp->gaps ) {\n\t\t    $hspstr .= sprintf(\", Gaps = %d/%d (%d%%)\",\n\t\t\t\t       $hsp->gaps('total'),\n\t\t\t\t       $hsp->length('total'),\n\t\t\t\t       (100 * $hsp->gaps('total') / \n\t\t\t\t\t$hsp->length('total')));\n\t\t}\n\n\t\tmy ($hframe,$qframe)   = ( $hsp->hit->frame, $hsp->query->frame);\n\t\tmy ($hstrand,$qstrand) = ($hsp->hit->strand,$hsp->query->strand);\n\t\t# so TBLASTX will have Query/Hit frames\n\t\t#    BLASTX  will have Query frame\n\t\t#    TBLASTN will have Hit frame\n\t\tif( $hstrand || $qstrand ) {\n\t\t    $hspstr .= \", Frame = \";\n\t\t    my ($signq, $signh);\n\t\t    unless( $hstrand ) {\n\t\t\t$hframe = undef;\n\t\t\t# if strand is null or 0 then it is protein\n\t\t\t# and this no frame\n\t\t    } else { \n\t\t\t$signh = $hstrand < 0 ? '-' : '+';\n\t\t    }\n\t\t    unless( $qstrand  ) {\n\t\t\t$qframe = undef;\n\t\t\t# if strand is null or 0 then it is protein\n\t\t    } else { \n\t\t\t$signq =$qstrand < 0 ? '-' : '+';\n\t\t    }\n\t\t    # remember bioperl stores frames as 0,1,2 (GFF way)\n\t\t    # BLAST reports reports as 1,2,3 so\n\t\t    # we have to add 1 to the frame values\n\t\t    if( defined $hframe && ! defined $qframe) {  \n\t\t\t$hspstr .= \"$signh\".($hframe+1);\n\t\t    } elsif( defined $qframe && ! defined $hframe) {  \n\t\t\t$hspstr .= \"$signq\".($qframe+1);\n\t\t    } else { \n\t\t\t$hspstr .= sprintf(\" %s%d / %s%d\",\n\t\t\t\t\t   $signq,$qframe+1,\n\t\t\t\t\t   $signh, $hframe+1);\n\t\t    }\n\t\t}\n\t\tif($links && \n\t\t   $hsp->can('links') && defined(my $lnks = $hsp->links) ) {\n\t\t    $hspstr .= sprintf(\"<br>\\nLinks = %s\\n\",$lnks);\n\t\t}\n\n\t\t$hspstr .= \"</a><p>\\n<pre>\";\n\n\t\tmy @hspvals = ( {'name' => 'Query:',\n\t\t\t\t 'seq'  => $hsp->query_string,\n\t\t\t\t 'start' => ($qstrand >= 0 ? \n\t\t\t\t\t     $hsp->query->start : \n\t\t\t\t\t     $hsp->query->end),\n\t\t\t\t\t     'end'   => ($qstrand >= 0 ? \n\t\t\t\t\t\t\t $hsp->query->end : \n\t\t\t\t\t\t\t $hsp->query->start),\n\t\t\t\t\t\t\t 'index' => 0,\n\t\t\t\t\t\t\t 'direction' => $qstrand || 1\n\t\t\t\t\t\t     },\n\t\t\t\t{ 'name' => ' 'x6,\n\t\t\t\t  'seq'  => $hsp->homology_string,\n\t\t\t\t  'start' => undef,\n\t\t\t\t  'end'   => undef,\n\t\t\t\t  'index' => 0,\n\t\t\t\t  'direction' => 1\n\t\t\t\t  },\n\t\t\t\t{ 'name'  => 'Sbjct:',\n\t\t\t\t  'seq'   => $hsp->hit_string,\n\t\t\t\t  'start' => ($hstrand >= 0 ? \n\t\t\t\t\t      $hsp->hit->start : \n\t\t\t\t\t      $hsp->hit->end),\n\t\t\t\t\t      'end'   => ($hstrand >= 0 ? \n\t\t\t\t\t\t\t  $hsp->hit->end : \n\t\t\t\t\t\t\t  $hsp->hit->start),\n\t\t\t\t\t\t\t  'index' => 0, \n\t\t\t\t\t\t\t  'direction' => $hstrand || 1\n\t\t\t\t\t\t      }\n\t\t\t\t);\t    \n\n\n\t\t# let's set the expected length (in chars) of the starting number\n\t\t# in an alignment block so we can have things line up\n\t\t# Just going to try and set to the largest\n\n\t\tmy ($numwidth) = sort { $b <=> $a }(length($hspvals[0]->{'start'}),\n\t\t\t\t\t\t    length($hspvals[0]->{'end'}),\n\t\t\t\t\t\t    length($hspvals[2]->{'start'}),\n\t\t\t\t\t\t    length($hspvals[2]->{'end'}));\n\t\tmy $count = 0;\n\t\twhile ( $count < $hsp->length('total') ) {\n\t\t    foreach my $v ( @hspvals ) {\n\t\t\tmy $piece = substr($v->{'seq'}, $v->{'index'} + $count,\n\t\t\t\t\t   $AlignmentLineWidth);\n\t\t\tmy $cp = $piece;\n\t\t\tmy $plen = scalar ( $cp =~ tr/\\-//);\n\t\t\tmy ($start,$end) = ('','');\n\t\t\tif( defined $v->{'start'} ) { \n\t\t\t    $start = $v->{'start'};\n\t\t\t    # since strand can be + or - use the direction\n\t\t\t    # to signify which whether to add or substract from end\n\t\t\t    my $d = $v->{'direction'} * ( $AlignmentLineWidth - $plen )*\n\t\t\t\t$baselens{$v->{'name'}};\n\t\t\t    if( length($piece) < $AlignmentLineWidth ) {\n\t\t\t\t$d = (length($piece) - $plen) * $v->{'direction'} * \n\t\t\t\t    $baselens{$v->{'name'}};\n\t\t\t    }\n\t\t\t    $end   = $v->{'start'} + $d - $v->{'direction'};\n\t\t\t    $v->{'start'} += $d;\n\t\t\t}\n\t\t\t$hspstr .= sprintf(\"%s %-\".$numwidth.\"s %s %s\\n\",\n\t\t\t\t\t   $v->{'name'},\n\t\t\t\t\t   $start,\n\t\t\t\t\t   $piece,\n\t\t\t\t\t   $end\n\t\t\t\t\t   );\n\t\t    }\n\t\t    $count += $AlignmentLineWidth;\n\t\t    $hspstr .= \"\\n\\n\";\n\t\t}\n\t\t$hspstr .= \"</pre>\\n\";\n\t    }\n\t}\n#\t$hspstr .= \"</pre>\\n\";\n    }\n\n    $str .= \"</table><p>\\n\".$hspstr;\n    my ($pav, $sav) = ($result->available_parameters, $result->available_statistics);\n    if ($pav || $sav) {\n        # make table of search statistics and end the web page\n        $str .= \"<p><p><hr><h2>Search Parameters</h2>\";\n        if ($pav) {\n        $str .= \"<table border=1><tr><th>Parameter</th><th>Value</th>\\n\";\n        foreach my $param ( sort $result->available_parameters ) {\n            $str .= \"<tr><td>$param</td><td>\". $result->get_parameter($param) .\"</td></tr>\\n\";\n        }\n        $str .= \"</table>\";\n        }\n        \n        if ($sav) {\n        $str .= \"<p><h2>Search Statistics</h2><table border=1><tr><th>Statistic</th><th>Value</th></tr>\\n\";\n        foreach my $stat ( sort $result->available_statistics ) {\n            $str .= \"<tr><td>$stat</td><td>\". $result->get_statistic($stat). \"</td>\\n\";\n        }\n        $str .=  \"</tr></table>\";\n        }\n    }\n    $str .= $self->footer() . \"<P>\\n\";\n    return $str;\n}\n\n=head2 hit_link_desc\n\n Title   : hit_link_desc\n Usage   : $self->hit_link_desc(\\&link_function);\n Function: Get/Set the function which provides an HTML \n           link(s) for the given hit to be used\n           within the description section at the top of the BLAST report.\n           This allows a person reading the report within\n           a web browser to go to one or more database entries for\n           the given hit from the description section.\n Returns : Function reference\n Args    : Function reference\n See Also: L<default_hit_link_desc()>\n\n\nsub hit_link_desc{\n    my( $self, $code ) = @_; \n    if ($code) {\n        $self->{'_hit_link_desc'} = $code;\n    }\n    return $self->{'_hit_link_desc'} || \\&default_hit_link_desc;\n}\n\n=head2 default_hit_link_desc\n\n Title   : default_hit_link_desc\n Usage   : $self->default_hit_link_desc($hit, $result)\n Function: Provides an HTML link(s) for the given hit to be used\n           within the description section at the top of the BLAST report.\n           This allows a person reading the report within\n           a web browser to go to one or more database entries for\n           the given hit from the description section.\n Returns : string containing HTML markup \"<a href...\")\n\n           The default implementation returns an HTML link to the\n           URL supplied by the remote_database_url() method\n           and using the identifier supplied by the id_parser() method.\n           It will use the NCBI GI if present, and the accession if not.\n\n Args    : First argument is a Bio::Search::Hit::HitI\n           Second argument is a Bio::Search::Result::ResultI\n\nSee Also: L<hit_link_align>, L<remote_database>, L<id_parser>\n\n\nsub default_hit_link_desc {\n    my($self, $hit, $result) = @_;\n    my $type = ( $result->algorithm =~ /(P|X|Y)$/i ) ? 'PROTEIN' : 'NUCLEOTIDE';\n    my ($gi,$acc) = &{$self->id_parser}($hit->name);\n\n    my $url = length($self->remote_database_url($type)) > 0 ? \n              sprintf('<a href=\"%s\">%s</a>',\n                      sprintf($self->remote_database_url($type),$gi || $acc), \n                      $hit->name()) :  $hit->name();\n\n    return $url;\n}\n\n\n=head2 hit_link_align\n\n Title   : hit_link_align\n Usage   : $self->hit_link_align(\\&link_function);\n Function: Get/Set the function which provides an HTML link(s) \n           for the given hit to be used\n           within the HSP alignment section of the BLAST report.\n           This allows a person reading the report within\n           a web browser to go to one or more database entries for\n           the given hit from the alignment section.\n Returns : string containing HTML markup \"<a href...\")\n\n           The default implementation delegates to hit_link_desc().\n\n Args    : First argument is a Bio::Search::Hit::HitI\n           Second argument is a Bio::Search::Result::ResultI\n\nSee Also: L<hit_link_desc>, L<remote_database>, L<id_parser>\n\n\nsub hit_link_align {\n    my ($self,$code) = @_;\n    if ($code) {\n        $self->{'_hit_link_align'} = $code;\n    }\n    return $self->{'_hit_link_align'} || \\&default_hit_link_desc;\n}\n\n=head2 hit_desc_line\n\n Title   : hit_desc_line\n Usage   : $self->hit_desc_line(\\&link_function);\n Function: Get/Set the function which provides HTML for the description\n           information from a hit. This allows one to parse\n           the rest of the description and split up lines, add links, etc.\n Returns : Function reference\n Args    : Function reference\n See Also: L<default_hit_link_desc()>\n\n\nsub hit_desc_line{\n    my( $self, $code ) = @_; \n    if ($code) {\n        $self->{'_hit_desc_line'} = $code;\n    }\n    return $self->{'_hit_desc_line'} || \\&default_hit_desc_line;\n}\n\n=head2 default_hit_desc_line\n\n Title   : default_hit_desc_line\n Usage   : $self->default_hit_desc_line($hit, $result)\n Function: Parses the description line information, splits based on the\n           hidden \\x01 between independent descriptions, checks the lines for\n           possible web links, and adds HTML link(s) for the given hit to be\n           used.\n\n Returns : string containing HTML markup \"<a href...\")\n           The default implementation returns an HTML link to the\n           URL supplied by the remote_database_url() method\n           and using the identifier supplied by the id_parser() method.\n           It will use the NCBI GI if present, and the accession if not.\n\n Args    : First argument is a Bio::Search::Hit::HitI\n           Second argument is a Bio::Search::Result::ResultI\n\nSee Also: L<hit_link_align>, L<remote_database>, L<id_parser>\n\n\nsub default_hit_desc_line {\n    my($self, $hit, $result) = @_;\n    my $type = ( $result->algorithm =~ /(P|X|Y)$/i ) ? 'PROTEIN' : 'NUCLEOTIDE';\n    my @descs = split /\\x01/, $hit->description;\n    #my $descline = join(\"</br>\",@descs).\"</br>\";\n    my $descline = '';\n    #return $descline;\n    for my $sec (@descs) {\n        my $url = '';\n        if ($sec =~ s/((?:gi\\|(\\d+)\\|)?        # optional GI\n                     (\\w+)\\|([A-Z\\d\\.\\_]+) # main \n                     (\\|[A-Z\\d\\_]+)?) # optional secondary ID//xms) {\n            my ($name, $gi, $db, $acc) = ($1, $2, $3, $4);\n            #$acc ||= ($rest) ? $rest : $gi;\n            $acc =~ s/^\\s+(\\S+)/$1/;\n            $acc =~ s/(\\S+)\\s+$/$1/;\n            $url =\n            length($self->remote_database_url($type)) > 0 ? \n              sprintf('<a href=\"%s\">%s</a> %s',\n                      sprintf($self->remote_database_url($type),\n                      $gi || $acc || $db), \n                      $name, $sec) :  $sec;\n        } else {\n            $url = $sec;\n        }\n        $descline .= \"$url</br>\\n\";\n    }\n    return $descline;\n}\n\n=head2 start_report\n\n  Title   : start_report\n  Usage   : $index->start_report( CODE )\n  Function: Stores or returns the code to\n            write the start of the <HTML> block, the <TITLE> block\n            and the start of the <BODY> block of HTML.   Useful\n            for (for instance) specifying alternative\n            HTML if you are embedding the output in\n            an HTML page which you have already started.\n            (For example a routine returning a null string).\n            Returns \\&default_start_report (see below) if not\n            set. \n  Example : $index->start_report( \\&my_start_report )\n  Returns : ref to CODE if called without arguments\n  Args    : CODE"},"containerName":"main::","definition":"sub","line":674,"children":[{"definition":"my","name":"$self","containerName":"start_report","localvar":"my","kind":13,"line":675},{"line":675,"kind":13,"name":"$code","containerName":"start_report"},{"line":676,"kind":13,"name":"$code","containerName":"start_report"},{"containerName":"start_report","name":"$self","kind":13,"line":677},{"name":"$code","containerName":"start_report","line":677,"kind":13},{"containerName":"start_report","name":"$self","kind":13,"line":679}],"kind":12,"range":{"start":{"line":674,"character":0},"end":{"line":680,"character":9999}},"name":"start_report"},{"kind":12,"line":679,"name":"default_start_report"},{"range":{"start":{"character":0,"line":692},"end":{"line":705,"character":9999}},"name":"default_start_report","line":692,"children":[{"containerName":"default_start_report","definition":"my","name":"$result","localvar":"my","kind":13,"line":693},{"containerName":"default_start_report","name":"$result","kind":13,"line":703},{"kind":12,"line":703,"containerName":"default_start_report","name":"algorithm"},{"kind":13,"line":703,"containerName":"default_start_report","name":"$Revision"}],"kind":12,"detail":"($result)","signature":{"label":"default_start_report($result)","parameters":[{"label":"$result"}],"documentation":"1;\n# $Id: HTMLResultWriter.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::Writer::HTMLResultWriter\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# Changes 2003-07-31 (jason)\n# Gary has cleaned up the code a lot to produce better looking HTML\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::Writer::HTMLResultWriter - write a Bio::Search::ResultI in HTML\n\n=head1 SYNOPSIS\n\n  use Bio::SearchIO;\n  use Bio::SearchIO::Writer::HTMLResultWriter;\n\n  my $in = Bio::SearchIO->new(-format => 'blast',\n\t\t\t     -file   => shift @ARGV);\n\n  my $writer = Bio::SearchIO::Writer::HTMLResultWriter->new();\n  my $out = Bio::SearchIO->new(-writer => $writer);\n  $out->write_result($in->next_result);\n\n\n  # to filter your output\n  my $MinLength = 100; # need a variable with scope outside the method\n  sub hsp_filter { \n      my $hsp = shift;\n      return 1 if $hsp->length('total') > $MinLength;\n  }\n  sub result_filter { \n      my $result = shift;\n      return $hsp->num_hits > 0;\n  }\n\n  my $writer = Bio::SearchIO::Writer::HTMLResultWriter->new\n                     (-filters => { 'HSP' => \\&hsp_filter} );\n  my $out = Bio::SearchIO->new(-writer => $writer);\n  $out->write_result($in->next_result);\n\n  # can also set the filter via the writer object\n  $writer->filter('RESULT', \\&result_filter);\n\n=head1 DESCRIPTION\n\nThis object implements the SearchWriterI interface which will produce\na set of HTML for a specific L<Bio::Search::Report::ReportI> interface.\n\nSee L<Bio::SearchIO::SearchWriterI> for more info on the filter method.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nGary Williams G.Williams@hgmp.mrc.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\npackage Bio::SearchIO::Writer::HTMLResultWriter;\nuse strict;\nuse vars qw(%RemoteURLDefault\n            $MaxDescLen $DATE $AlignmentLineWidth $Revision);\n\n# Object preamble - inherits from Bio::Root::RootI\n\nBEGIN {\n    $Revision = '$Id: HTMLResultWriter.pm 16123 2009-09-17 12:57:27Z cjfields $';\n    $DATE = localtime(time);\n    %RemoteURLDefault = ( \n      'PROTEIN' => 'http://www.ncbi.nlm.nih.gov/entrez/query.fcgi?db=protein&cmd=search&term=%s',\t\t\t  \n      'NUCLEOTIDE' => 'http://www.ncbi.nlm.nih.gov/entrez/query.fcgi?db=nucleotide&cmd=search&term=%s'\n    );\n    $MaxDescLen = 60;\n    $AlignmentLineWidth = 60;\n}\n\n\nuse base qw(Bio::Root::Root Bio::SearchIO::SearchWriterI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::Writer::HTMLResultWriter->new();\n Function: Builds a new Bio::SearchIO::Writer::HTMLResultWriter object \n Returns : Bio::SearchIO::Writer::HTMLResultWriter\n Args    : -filters => hashref with any or all of the keys (HSP HIT RESULT)\n           which have values pointing to a subroutine reference\n           which will expect to get a \n           -nucleotide_url => URL sprintf string base for the nt sequences\n           -protein_url => URL sprintf string base for the aa sequences\n           -no_wublastlinks => boolean. Do not display WU-BLAST lines \n                               even if they are parsed out.\n                               Links = (1) \n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($p,$n,$filters,\n      $nowublastlinks) = $self->_rearrange([qw(PROTEIN_URL \n\t\t\t\t\t       NUCLEOTIDE_URL \n\t\t\t\t\t       FILTERS\n\t\t\t\t\t       NO_WUBLASTLINKS)],@args);\n  $self->remote_database_url('p',$p || $RemoteURLDefault{'PROTEIN'});\n  $self->remote_database_url('n',$n || $RemoteURLDefault{'NUCLEOTIDE'});\n  $self->no_wublastlinks(! $nowublastlinks);\n  if( defined $filters ) {\n      if( !ref($filters) =~ /HASH/i ) { \n\t  $self->warn(\"Did not provide a hashref for the FILTERS option, ignoring.\");\n      } else { \n\t  while( my ($type,$code) = each %{$filters} ) {\n\t      $self->filter($type,$code);\n\t  }\n      }\n  }\n\n  return $self;\n}\n\n=head2 remote_database_url\n\n Title   : remote_database_url\n Usage   : $obj->remote_database_url($type,$newval)\n Function: This should return or set a string that contains a %s which can be\n           filled in with sprintf.\n Returns : value of remote_database_url\n Args    : $type - 'PROTEIN' or 'P' for protein URLS\n                   'NUCLEOTIDE' or 'N' for nucleotide URLS\n           $value - new value to set [optional]\n\n\n\nsub remote_database_url{\n   my ($self,$type,$value) = @_;\n   if( ! defined $type || $type !~ /^(P|N)/i ) { \n       $self->warn(\"Must provide a type (PROTEIN or NUCLEOTIDE)\");\n       return '';\n   }\n   $type = uc $1;\n   if( defined $value) {\n      $self->{'remote_database_url'}->{$type} = $value;\n    }\n   return $self->{'remote_database_url'}->{$type};\n}\n\n=head2 to_string\n\n Purpose   : Produces data for each Search::Result::ResultI in a string.\n           : This is an abstract method. For some useful implementations,\n           : see ResultTableWriter.pm, HitTableWriter.pm, \n           : and HSPTableWriter.pm.\n Usage     : print $writer->to_string( $result_obj, @args );\n Argument  : $result_obj = A Bio::Search::Result::ResultI object\n           : @args = any additional arguments used by your implementation.\n Returns   : String containing data for each search Result or any of its\n           : sub-objects (Hits and HSPs).\n Throws    : n/a\n\n\nsub to_string {\n    my ($self,$result,$num) = @_; \n    $num ||= 0;\n    return unless defined $result;\n    my $links = $self->no_wublastlinks;\n    my ($resultfilter,$hitfilter, $hspfilter) = ( $self->filter('RESULT'),\n\t\t\t\t\t\t  $self->filter('HIT'),\n\t\t\t\t\t\t  $self->filter('HSP') );\n    return '' if( defined $resultfilter && ! &{$resultfilter}($result) );    \n\n    my ($qtype,$dbtype,$dbseqtype,$type);\n    my $alg = $result->algorithm;\n    # This is actually wrong for the FASTAs I think\n    if(  $alg =~ /T(FAST|BLAST)([XY])/i ) {\n\t$qtype      = $dbtype = 'translated';\n\t$dbseqtype = $type       = 'PROTEIN';\n    } elsif( $alg =~ /T(FAST|BLAST)N/i ) {\n\t$qtype      = '';\n\t$dbtype     = 'translated';\n\t$type       = 'PROTEIN';\n\t$dbseqtype  = 'NUCLEOTIDE';\n    } elsif( $alg =~ /(FAST|BLAST)N/i || \n\t     $alg =~ /(WABA|EXONERATE)/i ) {\n\t$qtype      = $dbtype = '';\n\t$type = $dbseqtype  = 'NUCLEOTIDE';\n    } elsif( $alg =~ /(FAST|BLAST)P/  || \n\t     $alg =~ /SSEARCH|HMM(PFAM|SEARCH)/i ) {\n\t$qtype      = $dbtype = '';\n\t$type = $dbseqtype  = 'PROTEIN';\n    } elsif( $alg =~ /(FAST|BLAST)[XY]/i ) {\n\t$qtype      = 'translated';\n        $dbtype     = 'PROTEIN';\n\t$dbseqtype  = $type      = 'PROTEIN';\n    } else { \n\t$self->warn(\"algorithm was \", $result->algorithm, \" couldn't match\\n\");\n    }\n    \n    \n    my %baselens = ( 'Sbjct:'   => ( $dbtype eq 'translated' )  ? 3 : 1,\n\t\t     'Query:'   => ( $qtype  eq 'translated' )  ? 3 : 1);\n\n    my $str;\n    if( $num <= 1 ) { \n\t$str = &{$self->start_report}($result);\n    }\n\n    $str .= &{$self->title}($result);\n\n    $str .= $result->algorithm_reference || $self->algorithm_reference($result);\n    $str .= &{$self->introduction}($result);\n\n    $str .= \"<table border=0>\n            <tr><th>Sequences producing significant alignments:</th>\n            <th>Score<br>(bits)</th><th>E<br>value</th></tr>\";\n\n    my $hspstr = '<p><p>';\n    if( $result->can('rewind')) {\n        $result->rewind(); # support stream based parsing routines\n    }\n\n    while( my $hit = $result->next_hit ) {\n\tnext if( $hitfilter && ! &{$hitfilter}($hit) );\n\tmy $nm = $hit->name();\n\t\n\t$self->debug( \"no $nm for name (\".$hit->description(). \"\\n\") \n\t    unless $nm;\n\tmy ($gi,$acc) = &{$self->id_parser}($nm);\n\tmy $p = \"%-$MaxDescLen\". \"s\";\n\tmy $descsub;\n\tif( length($hit->description) > ($MaxDescLen - 3) ) {\n\t    $descsub = sprintf($p,\n\t\tsubstr($hit->description,0,$MaxDescLen-3) . \"...\");\n\t} else { \n\t    $descsub = sprintf($p,$hit->description);\n\t}\n\n\tmy $url_desc  = &{$self->hit_link_desc()}($self,$hit, $result);\n\tmy $url_align = &{$self->hit_link_align()}($self,$hit, $result);\n\n\tmy @hsps = $hit->hsps;\n\t\n\tif( ! @hsps ) {\n\t    # no HSPs so no link \n\t    $str .= sprintf('<tr><td>%s %s</td><td>%s</td><td>%.2g</td></tr>'.\"\\n\",\n\t\t\t    $url_desc, $descsub, \n\t\t\t    ($hit->bits ? $hit->bits : \n\t\t\t     (defined $hsps[0] ? $hsps[0]->bits : ' ')),\n\t\t\t    ( $hit->significance ? $hit->significance :\n\t\t\t      (defined $hsps[0] ? $hsps[0]->evalue : ' ')) \n\t\t\t    );\n\t} else { \n\t    # failover to first HSP if the data does not contain a \n\t    # bitscore/significance value for the Hit (NCBI XML data for one)\n\n\t    $str .= sprintf('<tr><td>%s %s</td><td>%s</td><td><a href=\"#%s\">%.2g</a></td></tr>'.\"\\n\",\n\t\t\t    $url_desc, $descsub, \n\t\t\t    ($hit->bits ? $hit->bits : \n\t\t\t     (defined $hsps[0] ? $hsps[0]->bits : ' ')),\n\t\t\t    $acc,\n\t\t\t    ( $hit->significance ? $hit->significance :\n\t\t\t      (defined $hsps[0] ? $hsps[0]->evalue : ' ')) \n\t\t\t    );\n        my $dline = &{$self->hit_desc_line}($self, $hit, $result);\n\t    $hspstr .= \"<a name=\\\"$acc\\\">\\n\".\n\t\tsprintf(\"><b>%s</b> %s</br><dd>Length = %s</dd><p>\\n\\n\", $url_align, \n\t\t\t$dline , &_numwithcommas($hit->length));\n\t    my $ct = 0;\n\t    foreach my $hsp (@hsps ) {\n\t\tnext if( $hspfilter && ! &{$hspfilter}($hsp) );\n\t\t$hspstr .= sprintf(\" Score = %s bits (%s), Expect = %s\",\n\t\t\t\t   $hsp->bits || $hsp->score, \n\t\t\t\t   $hsp->score || $hsp->bits, \n\t\t\t\t   $hsp->evalue || '');\n\t\tif( defined $hsp->pvalue ) {\n\t\t    $hspstr .= \", P = \".$hsp->pvalue;\n\t\t}\n\t\t$hspstr .= \"<br>\\n\";\n\t\t$hspstr .= sprintf(\" Identities = %d/%d (%d%%)\",\n\t\t\t\t   ( $hsp->frac_identical('total') * \n\t\t\t\t     $hsp->length('total')),\n\t\t\t\t   $hsp->length('total'),\n\t\t\t\t   $hsp->frac_identical('total') * 100);\n\n\t\tif( $type eq 'PROTEIN' ) {\n\t\t    $hspstr .= sprintf(\", Positives = %d/%d (%d%%)\",\n\t\t\t\t       ( $hsp->frac_conserved('total') * \n\t\t\t\t\t $hsp->length('total')),\n\t\t\t\t       $hsp->length('total'),\n\t\t\t\t       $hsp->frac_conserved('total') * 100);\n\t\t}\n\t\tif( $hsp->gaps ) {\n\t\t    $hspstr .= sprintf(\", Gaps = %d/%d (%d%%)\",\n\t\t\t\t       $hsp->gaps('total'),\n\t\t\t\t       $hsp->length('total'),\n\t\t\t\t       (100 * $hsp->gaps('total') / \n\t\t\t\t\t$hsp->length('total')));\n\t\t}\n\n\t\tmy ($hframe,$qframe)   = ( $hsp->hit->frame, $hsp->query->frame);\n\t\tmy ($hstrand,$qstrand) = ($hsp->hit->strand,$hsp->query->strand);\n\t\t# so TBLASTX will have Query/Hit frames\n\t\t#    BLASTX  will have Query frame\n\t\t#    TBLASTN will have Hit frame\n\t\tif( $hstrand || $qstrand ) {\n\t\t    $hspstr .= \", Frame = \";\n\t\t    my ($signq, $signh);\n\t\t    unless( $hstrand ) {\n\t\t\t$hframe = undef;\n\t\t\t# if strand is null or 0 then it is protein\n\t\t\t# and this no frame\n\t\t    } else { \n\t\t\t$signh = $hstrand < 0 ? '-' : '+';\n\t\t    }\n\t\t    unless( $qstrand  ) {\n\t\t\t$qframe = undef;\n\t\t\t# if strand is null or 0 then it is protein\n\t\t    } else { \n\t\t\t$signq =$qstrand < 0 ? '-' : '+';\n\t\t    }\n\t\t    # remember bioperl stores frames as 0,1,2 (GFF way)\n\t\t    # BLAST reports reports as 1,2,3 so\n\t\t    # we have to add 1 to the frame values\n\t\t    if( defined $hframe && ! defined $qframe) {  \n\t\t\t$hspstr .= \"$signh\".($hframe+1);\n\t\t    } elsif( defined $qframe && ! defined $hframe) {  \n\t\t\t$hspstr .= \"$signq\".($qframe+1);\n\t\t    } else { \n\t\t\t$hspstr .= sprintf(\" %s%d / %s%d\",\n\t\t\t\t\t   $signq,$qframe+1,\n\t\t\t\t\t   $signh, $hframe+1);\n\t\t    }\n\t\t}\n\t\tif($links && \n\t\t   $hsp->can('links') && defined(my $lnks = $hsp->links) ) {\n\t\t    $hspstr .= sprintf(\"<br>\\nLinks = %s\\n\",$lnks);\n\t\t}\n\n\t\t$hspstr .= \"</a><p>\\n<pre>\";\n\n\t\tmy @hspvals = ( {'name' => 'Query:',\n\t\t\t\t 'seq'  => $hsp->query_string,\n\t\t\t\t 'start' => ($qstrand >= 0 ? \n\t\t\t\t\t     $hsp->query->start : \n\t\t\t\t\t     $hsp->query->end),\n\t\t\t\t\t     'end'   => ($qstrand >= 0 ? \n\t\t\t\t\t\t\t $hsp->query->end : \n\t\t\t\t\t\t\t $hsp->query->start),\n\t\t\t\t\t\t\t 'index' => 0,\n\t\t\t\t\t\t\t 'direction' => $qstrand || 1\n\t\t\t\t\t\t     },\n\t\t\t\t{ 'name' => ' 'x6,\n\t\t\t\t  'seq'  => $hsp->homology_string,\n\t\t\t\t  'start' => undef,\n\t\t\t\t  'end'   => undef,\n\t\t\t\t  'index' => 0,\n\t\t\t\t  'direction' => 1\n\t\t\t\t  },\n\t\t\t\t{ 'name'  => 'Sbjct:',\n\t\t\t\t  'seq'   => $hsp->hit_string,\n\t\t\t\t  'start' => ($hstrand >= 0 ? \n\t\t\t\t\t      $hsp->hit->start : \n\t\t\t\t\t      $hsp->hit->end),\n\t\t\t\t\t      'end'   => ($hstrand >= 0 ? \n\t\t\t\t\t\t\t  $hsp->hit->end : \n\t\t\t\t\t\t\t  $hsp->hit->start),\n\t\t\t\t\t\t\t  'index' => 0, \n\t\t\t\t\t\t\t  'direction' => $hstrand || 1\n\t\t\t\t\t\t      }\n\t\t\t\t);\t    \n\n\n\t\t# let's set the expected length (in chars) of the starting number\n\t\t# in an alignment block so we can have things line up\n\t\t# Just going to try and set to the largest\n\n\t\tmy ($numwidth) = sort { $b <=> $a }(length($hspvals[0]->{'start'}),\n\t\t\t\t\t\t    length($hspvals[0]->{'end'}),\n\t\t\t\t\t\t    length($hspvals[2]->{'start'}),\n\t\t\t\t\t\t    length($hspvals[2]->{'end'}));\n\t\tmy $count = 0;\n\t\twhile ( $count < $hsp->length('total') ) {\n\t\t    foreach my $v ( @hspvals ) {\n\t\t\tmy $piece = substr($v->{'seq'}, $v->{'index'} + $count,\n\t\t\t\t\t   $AlignmentLineWidth);\n\t\t\tmy $cp = $piece;\n\t\t\tmy $plen = scalar ( $cp =~ tr/\\-//);\n\t\t\tmy ($start,$end) = ('','');\n\t\t\tif( defined $v->{'start'} ) { \n\t\t\t    $start = $v->{'start'};\n\t\t\t    # since strand can be + or - use the direction\n\t\t\t    # to signify which whether to add or substract from end\n\t\t\t    my $d = $v->{'direction'} * ( $AlignmentLineWidth - $plen )*\n\t\t\t\t$baselens{$v->{'name'}};\n\t\t\t    if( length($piece) < $AlignmentLineWidth ) {\n\t\t\t\t$d = (length($piece) - $plen) * $v->{'direction'} * \n\t\t\t\t    $baselens{$v->{'name'}};\n\t\t\t    }\n\t\t\t    $end   = $v->{'start'} + $d - $v->{'direction'};\n\t\t\t    $v->{'start'} += $d;\n\t\t\t}\n\t\t\t$hspstr .= sprintf(\"%s %-\".$numwidth.\"s %s %s\\n\",\n\t\t\t\t\t   $v->{'name'},\n\t\t\t\t\t   $start,\n\t\t\t\t\t   $piece,\n\t\t\t\t\t   $end\n\t\t\t\t\t   );\n\t\t    }\n\t\t    $count += $AlignmentLineWidth;\n\t\t    $hspstr .= \"\\n\\n\";\n\t\t}\n\t\t$hspstr .= \"</pre>\\n\";\n\t    }\n\t}\n#\t$hspstr .= \"</pre>\\n\";\n    }\n\n    $str .= \"</table><p>\\n\".$hspstr;\n    my ($pav, $sav) = ($result->available_parameters, $result->available_statistics);\n    if ($pav || $sav) {\n        # make table of search statistics and end the web page\n        $str .= \"<p><p><hr><h2>Search Parameters</h2>\";\n        if ($pav) {\n        $str .= \"<table border=1><tr><th>Parameter</th><th>Value</th>\\n\";\n        foreach my $param ( sort $result->available_parameters ) {\n            $str .= \"<tr><td>$param</td><td>\". $result->get_parameter($param) .\"</td></tr>\\n\";\n        }\n        $str .= \"</table>\";\n        }\n        \n        if ($sav) {\n        $str .= \"<p><h2>Search Statistics</h2><table border=1><tr><th>Statistic</th><th>Value</th></tr>\\n\";\n        foreach my $stat ( sort $result->available_statistics ) {\n            $str .= \"<tr><td>$stat</td><td>\". $result->get_statistic($stat). \"</td>\\n\";\n        }\n        $str .=  \"</tr></table>\";\n        }\n    }\n    $str .= $self->footer() . \"<P>\\n\";\n    return $str;\n}\n\n=head2 hit_link_desc\n\n Title   : hit_link_desc\n Usage   : $self->hit_link_desc(\\&link_function);\n Function: Get/Set the function which provides an HTML \n           link(s) for the given hit to be used\n           within the description section at the top of the BLAST report.\n           This allows a person reading the report within\n           a web browser to go to one or more database entries for\n           the given hit from the description section.\n Returns : Function reference\n Args    : Function reference\n See Also: L<default_hit_link_desc()>\n\n\nsub hit_link_desc{\n    my( $self, $code ) = @_; \n    if ($code) {\n        $self->{'_hit_link_desc'} = $code;\n    }\n    return $self->{'_hit_link_desc'} || \\&default_hit_link_desc;\n}\n\n=head2 default_hit_link_desc\n\n Title   : default_hit_link_desc\n Usage   : $self->default_hit_link_desc($hit, $result)\n Function: Provides an HTML link(s) for the given hit to be used\n           within the description section at the top of the BLAST report.\n           This allows a person reading the report within\n           a web browser to go to one or more database entries for\n           the given hit from the description section.\n Returns : string containing HTML markup \"<a href...\")\n\n           The default implementation returns an HTML link to the\n           URL supplied by the remote_database_url() method\n           and using the identifier supplied by the id_parser() method.\n           It will use the NCBI GI if present, and the accession if not.\n\n Args    : First argument is a Bio::Search::Hit::HitI\n           Second argument is a Bio::Search::Result::ResultI\n\nSee Also: L<hit_link_align>, L<remote_database>, L<id_parser>\n\n\nsub default_hit_link_desc {\n    my($self, $hit, $result) = @_;\n    my $type = ( $result->algorithm =~ /(P|X|Y)$/i ) ? 'PROTEIN' : 'NUCLEOTIDE';\n    my ($gi,$acc) = &{$self->id_parser}($hit->name);\n\n    my $url = length($self->remote_database_url($type)) > 0 ? \n              sprintf('<a href=\"%s\">%s</a>',\n                      sprintf($self->remote_database_url($type),$gi || $acc), \n                      $hit->name()) :  $hit->name();\n\n    return $url;\n}\n\n\n=head2 hit_link_align\n\n Title   : hit_link_align\n Usage   : $self->hit_link_align(\\&link_function);\n Function: Get/Set the function which provides an HTML link(s) \n           for the given hit to be used\n           within the HSP alignment section of the BLAST report.\n           This allows a person reading the report within\n           a web browser to go to one or more database entries for\n           the given hit from the alignment section.\n Returns : string containing HTML markup \"<a href...\")\n\n           The default implementation delegates to hit_link_desc().\n\n Args    : First argument is a Bio::Search::Hit::HitI\n           Second argument is a Bio::Search::Result::ResultI\n\nSee Also: L<hit_link_desc>, L<remote_database>, L<id_parser>\n\n\nsub hit_link_align {\n    my ($self,$code) = @_;\n    if ($code) {\n        $self->{'_hit_link_align'} = $code;\n    }\n    return $self->{'_hit_link_align'} || \\&default_hit_link_desc;\n}\n\n=head2 hit_desc_line\n\n Title   : hit_desc_line\n Usage   : $self->hit_desc_line(\\&link_function);\n Function: Get/Set the function which provides HTML for the description\n           information from a hit. This allows one to parse\n           the rest of the description and split up lines, add links, etc.\n Returns : Function reference\n Args    : Function reference\n See Also: L<default_hit_link_desc()>\n\n\nsub hit_desc_line{\n    my( $self, $code ) = @_; \n    if ($code) {\n        $self->{'_hit_desc_line'} = $code;\n    }\n    return $self->{'_hit_desc_line'} || \\&default_hit_desc_line;\n}\n\n=head2 default_hit_desc_line\n\n Title   : default_hit_desc_line\n Usage   : $self->default_hit_desc_line($hit, $result)\n Function: Parses the description line information, splits based on the\n           hidden \\x01 between independent descriptions, checks the lines for\n           possible web links, and adds HTML link(s) for the given hit to be\n           used.\n\n Returns : string containing HTML markup \"<a href...\")\n           The default implementation returns an HTML link to the\n           URL supplied by the remote_database_url() method\n           and using the identifier supplied by the id_parser() method.\n           It will use the NCBI GI if present, and the accession if not.\n\n Args    : First argument is a Bio::Search::Hit::HitI\n           Second argument is a Bio::Search::Result::ResultI\n\nSee Also: L<hit_link_align>, L<remote_database>, L<id_parser>\n\n\nsub default_hit_desc_line {\n    my($self, $hit, $result) = @_;\n    my $type = ( $result->algorithm =~ /(P|X|Y)$/i ) ? 'PROTEIN' : 'NUCLEOTIDE';\n    my @descs = split /\\x01/, $hit->description;\n    #my $descline = join(\"</br>\",@descs).\"</br>\";\n    my $descline = '';\n    #return $descline;\n    for my $sec (@descs) {\n        my $url = '';\n        if ($sec =~ s/((?:gi\\|(\\d+)\\|)?        # optional GI\n                     (\\w+)\\|([A-Z\\d\\.\\_]+) # main \n                     (\\|[A-Z\\d\\_]+)?) # optional secondary ID//xms) {\n            my ($name, $gi, $db, $acc) = ($1, $2, $3, $4);\n            #$acc ||= ($rest) ? $rest : $gi;\n            $acc =~ s/^\\s+(\\S+)/$1/;\n            $acc =~ s/(\\S+)\\s+$/$1/;\n            $url =\n            length($self->remote_database_url($type)) > 0 ? \n              sprintf('<a href=\"%s\">%s</a> %s',\n                      sprintf($self->remote_database_url($type),\n                      $gi || $acc || $db), \n                      $name, $sec) :  $sec;\n        } else {\n            $url = $sec;\n        }\n        $descline .= \"$url</br>\\n\";\n    }\n    return $descline;\n}\n\n=head2 start_report\n\n  Title   : start_report\n  Usage   : $index->start_report( CODE )\n  Function: Stores or returns the code to\n            write the start of the <HTML> block, the <TITLE> block\n            and the start of the <BODY> block of HTML.   Useful\n            for (for instance) specifying alternative\n            HTML if you are embedding the output in\n            an HTML page which you have already started.\n            (For example a routine returning a null string).\n            Returns \\&default_start_report (see below) if not\n            set. \n  Example : $index->start_report( \\&my_start_report )\n  Returns : ref to CODE if called without arguments\n  Args    : CODE\n\n\nsub start_report {\n    my( $self, $code ) = @_; \n    if ($code) {\n        $self->{'_start_report'} = $code;\n    }\n    return $self->{'_start_report'} || \\&default_start_report;\n}\n\n=head2 default_start_report\n\n Title   : default_start_report\n Usage   : $self->default_start_report($result)\n Function: The default method to call when starting a report.\n Returns : sting\n Args    : First argument is a Bio::Search::Result::ResultI"},"containerName":"main::","definition":"sub"},{"definition":"sub","containerName":"main::","signature":{"label":"title($self,$code)","parameters":[{"label":"$self"},{"label":"$code"}],"documentation":"1;\n# $Id: HTMLResultWriter.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::Writer::HTMLResultWriter\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# Changes 2003-07-31 (jason)\n# Gary has cleaned up the code a lot to produce better looking HTML\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::Writer::HTMLResultWriter - write a Bio::Search::ResultI in HTML\n\n=head1 SYNOPSIS\n\n  use Bio::SearchIO;\n  use Bio::SearchIO::Writer::HTMLResultWriter;\n\n  my $in = Bio::SearchIO->new(-format => 'blast',\n\t\t\t     -file   => shift @ARGV);\n\n  my $writer = Bio::SearchIO::Writer::HTMLResultWriter->new();\n  my $out = Bio::SearchIO->new(-writer => $writer);\n  $out->write_result($in->next_result);\n\n\n  # to filter your output\n  my $MinLength = 100; # need a variable with scope outside the method\n  sub hsp_filter { \n      my $hsp = shift;\n      return 1 if $hsp->length('total') > $MinLength;\n  }\n  sub result_filter { \n      my $result = shift;\n      return $hsp->num_hits > 0;\n  }\n\n  my $writer = Bio::SearchIO::Writer::HTMLResultWriter->new\n                     (-filters => { 'HSP' => \\&hsp_filter} );\n  my $out = Bio::SearchIO->new(-writer => $writer);\n  $out->write_result($in->next_result);\n\n  # can also set the filter via the writer object\n  $writer->filter('RESULT', \\&result_filter);\n\n=head1 DESCRIPTION\n\nThis object implements the SearchWriterI interface which will produce\na set of HTML for a specific L<Bio::Search::Report::ReportI> interface.\n\nSee L<Bio::SearchIO::SearchWriterI> for more info on the filter method.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nGary Williams G.Williams@hgmp.mrc.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\npackage Bio::SearchIO::Writer::HTMLResultWriter;\nuse strict;\nuse vars qw(%RemoteURLDefault\n            $MaxDescLen $DATE $AlignmentLineWidth $Revision);\n\n# Object preamble - inherits from Bio::Root::RootI\n\nBEGIN {\n    $Revision = '$Id: HTMLResultWriter.pm 16123 2009-09-17 12:57:27Z cjfields $';\n    $DATE = localtime(time);\n    %RemoteURLDefault = ( \n      'PROTEIN' => 'http://www.ncbi.nlm.nih.gov/entrez/query.fcgi?db=protein&cmd=search&term=%s',\t\t\t  \n      'NUCLEOTIDE' => 'http://www.ncbi.nlm.nih.gov/entrez/query.fcgi?db=nucleotide&cmd=search&term=%s'\n    );\n    $MaxDescLen = 60;\n    $AlignmentLineWidth = 60;\n}\n\n\nuse base qw(Bio::Root::Root Bio::SearchIO::SearchWriterI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::Writer::HTMLResultWriter->new();\n Function: Builds a new Bio::SearchIO::Writer::HTMLResultWriter object \n Returns : Bio::SearchIO::Writer::HTMLResultWriter\n Args    : -filters => hashref with any or all of the keys (HSP HIT RESULT)\n           which have values pointing to a subroutine reference\n           which will expect to get a \n           -nucleotide_url => URL sprintf string base for the nt sequences\n           -protein_url => URL sprintf string base for the aa sequences\n           -no_wublastlinks => boolean. Do not display WU-BLAST lines \n                               even if they are parsed out.\n                               Links = (1) \n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($p,$n,$filters,\n      $nowublastlinks) = $self->_rearrange([qw(PROTEIN_URL \n\t\t\t\t\t       NUCLEOTIDE_URL \n\t\t\t\t\t       FILTERS\n\t\t\t\t\t       NO_WUBLASTLINKS)],@args);\n  $self->remote_database_url('p',$p || $RemoteURLDefault{'PROTEIN'});\n  $self->remote_database_url('n',$n || $RemoteURLDefault{'NUCLEOTIDE'});\n  $self->no_wublastlinks(! $nowublastlinks);\n  if( defined $filters ) {\n      if( !ref($filters) =~ /HASH/i ) { \n\t  $self->warn(\"Did not provide a hashref for the FILTERS option, ignoring.\");\n      } else { \n\t  while( my ($type,$code) = each %{$filters} ) {\n\t      $self->filter($type,$code);\n\t  }\n      }\n  }\n\n  return $self;\n}\n\n=head2 remote_database_url\n\n Title   : remote_database_url\n Usage   : $obj->remote_database_url($type,$newval)\n Function: This should return or set a string that contains a %s which can be\n           filled in with sprintf.\n Returns : value of remote_database_url\n Args    : $type - 'PROTEIN' or 'P' for protein URLS\n                   'NUCLEOTIDE' or 'N' for nucleotide URLS\n           $value - new value to set [optional]\n\n\n\nsub remote_database_url{\n   my ($self,$type,$value) = @_;\n   if( ! defined $type || $type !~ /^(P|N)/i ) { \n       $self->warn(\"Must provide a type (PROTEIN or NUCLEOTIDE)\");\n       return '';\n   }\n   $type = uc $1;\n   if( defined $value) {\n      $self->{'remote_database_url'}->{$type} = $value;\n    }\n   return $self->{'remote_database_url'}->{$type};\n}\n\n=head2 to_string\n\n Purpose   : Produces data for each Search::Result::ResultI in a string.\n           : This is an abstract method. For some useful implementations,\n           : see ResultTableWriter.pm, HitTableWriter.pm, \n           : and HSPTableWriter.pm.\n Usage     : print $writer->to_string( $result_obj, @args );\n Argument  : $result_obj = A Bio::Search::Result::ResultI object\n           : @args = any additional arguments used by your implementation.\n Returns   : String containing data for each search Result or any of its\n           : sub-objects (Hits and HSPs).\n Throws    : n/a\n\n\nsub to_string {\n    my ($self,$result,$num) = @_; \n    $num ||= 0;\n    return unless defined $result;\n    my $links = $self->no_wublastlinks;\n    my ($resultfilter,$hitfilter, $hspfilter) = ( $self->filter('RESULT'),\n\t\t\t\t\t\t  $self->filter('HIT'),\n\t\t\t\t\t\t  $self->filter('HSP') );\n    return '' if( defined $resultfilter && ! &{$resultfilter}($result) );    \n\n    my ($qtype,$dbtype,$dbseqtype,$type);\n    my $alg = $result->algorithm;\n    # This is actually wrong for the FASTAs I think\n    if(  $alg =~ /T(FAST|BLAST)([XY])/i ) {\n\t$qtype      = $dbtype = 'translated';\n\t$dbseqtype = $type       = 'PROTEIN';\n    } elsif( $alg =~ /T(FAST|BLAST)N/i ) {\n\t$qtype      = '';\n\t$dbtype     = 'translated';\n\t$type       = 'PROTEIN';\n\t$dbseqtype  = 'NUCLEOTIDE';\n    } elsif( $alg =~ /(FAST|BLAST)N/i || \n\t     $alg =~ /(WABA|EXONERATE)/i ) {\n\t$qtype      = $dbtype = '';\n\t$type = $dbseqtype  = 'NUCLEOTIDE';\n    } elsif( $alg =~ /(FAST|BLAST)P/  || \n\t     $alg =~ /SSEARCH|HMM(PFAM|SEARCH)/i ) {\n\t$qtype      = $dbtype = '';\n\t$type = $dbseqtype  = 'PROTEIN';\n    } elsif( $alg =~ /(FAST|BLAST)[XY]/i ) {\n\t$qtype      = 'translated';\n        $dbtype     = 'PROTEIN';\n\t$dbseqtype  = $type      = 'PROTEIN';\n    } else { \n\t$self->warn(\"algorithm was \", $result->algorithm, \" couldn't match\\n\");\n    }\n    \n    \n    my %baselens = ( 'Sbjct:'   => ( $dbtype eq 'translated' )  ? 3 : 1,\n\t\t     'Query:'   => ( $qtype  eq 'translated' )  ? 3 : 1);\n\n    my $str;\n    if( $num <= 1 ) { \n\t$str = &{$self->start_report}($result);\n    }\n\n    $str .= &{$self->title}($result);\n\n    $str .= $result->algorithm_reference || $self->algorithm_reference($result);\n    $str .= &{$self->introduction}($result);\n\n    $str .= \"<table border=0>\n            <tr><th>Sequences producing significant alignments:</th>\n            <th>Score<br>(bits)</th><th>E<br>value</th></tr>\";\n\n    my $hspstr = '<p><p>';\n    if( $result->can('rewind')) {\n        $result->rewind(); # support stream based parsing routines\n    }\n\n    while( my $hit = $result->next_hit ) {\n\tnext if( $hitfilter && ! &{$hitfilter}($hit) );\n\tmy $nm = $hit->name();\n\t\n\t$self->debug( \"no $nm for name (\".$hit->description(). \"\\n\") \n\t    unless $nm;\n\tmy ($gi,$acc) = &{$self->id_parser}($nm);\n\tmy $p = \"%-$MaxDescLen\". \"s\";\n\tmy $descsub;\n\tif( length($hit->description) > ($MaxDescLen - 3) ) {\n\t    $descsub = sprintf($p,\n\t\tsubstr($hit->description,0,$MaxDescLen-3) . \"...\");\n\t} else { \n\t    $descsub = sprintf($p,$hit->description);\n\t}\n\n\tmy $url_desc  = &{$self->hit_link_desc()}($self,$hit, $result);\n\tmy $url_align = &{$self->hit_link_align()}($self,$hit, $result);\n\n\tmy @hsps = $hit->hsps;\n\t\n\tif( ! @hsps ) {\n\t    # no HSPs so no link \n\t    $str .= sprintf('<tr><td>%s %s</td><td>%s</td><td>%.2g</td></tr>'.\"\\n\",\n\t\t\t    $url_desc, $descsub, \n\t\t\t    ($hit->bits ? $hit->bits : \n\t\t\t     (defined $hsps[0] ? $hsps[0]->bits : ' ')),\n\t\t\t    ( $hit->significance ? $hit->significance :\n\t\t\t      (defined $hsps[0] ? $hsps[0]->evalue : ' ')) \n\t\t\t    );\n\t} else { \n\t    # failover to first HSP if the data does not contain a \n\t    # bitscore/significance value for the Hit (NCBI XML data for one)\n\n\t    $str .= sprintf('<tr><td>%s %s</td><td>%s</td><td><a href=\"#%s\">%.2g</a></td></tr>'.\"\\n\",\n\t\t\t    $url_desc, $descsub, \n\t\t\t    ($hit->bits ? $hit->bits : \n\t\t\t     (defined $hsps[0] ? $hsps[0]->bits : ' ')),\n\t\t\t    $acc,\n\t\t\t    ( $hit->significance ? $hit->significance :\n\t\t\t      (defined $hsps[0] ? $hsps[0]->evalue : ' ')) \n\t\t\t    );\n        my $dline = &{$self->hit_desc_line}($self, $hit, $result);\n\t    $hspstr .= \"<a name=\\\"$acc\\\">\\n\".\n\t\tsprintf(\"><b>%s</b> %s</br><dd>Length = %s</dd><p>\\n\\n\", $url_align, \n\t\t\t$dline , &_numwithcommas($hit->length));\n\t    my $ct = 0;\n\t    foreach my $hsp (@hsps ) {\n\t\tnext if( $hspfilter && ! &{$hspfilter}($hsp) );\n\t\t$hspstr .= sprintf(\" Score = %s bits (%s), Expect = %s\",\n\t\t\t\t   $hsp->bits || $hsp->score, \n\t\t\t\t   $hsp->score || $hsp->bits, \n\t\t\t\t   $hsp->evalue || '');\n\t\tif( defined $hsp->pvalue ) {\n\t\t    $hspstr .= \", P = \".$hsp->pvalue;\n\t\t}\n\t\t$hspstr .= \"<br>\\n\";\n\t\t$hspstr .= sprintf(\" Identities = %d/%d (%d%%)\",\n\t\t\t\t   ( $hsp->frac_identical('total') * \n\t\t\t\t     $hsp->length('total')),\n\t\t\t\t   $hsp->length('total'),\n\t\t\t\t   $hsp->frac_identical('total') * 100);\n\n\t\tif( $type eq 'PROTEIN' ) {\n\t\t    $hspstr .= sprintf(\", Positives = %d/%d (%d%%)\",\n\t\t\t\t       ( $hsp->frac_conserved('total') * \n\t\t\t\t\t $hsp->length('total')),\n\t\t\t\t       $hsp->length('total'),\n\t\t\t\t       $hsp->frac_conserved('total') * 100);\n\t\t}\n\t\tif( $hsp->gaps ) {\n\t\t    $hspstr .= sprintf(\", Gaps = %d/%d (%d%%)\",\n\t\t\t\t       $hsp->gaps('total'),\n\t\t\t\t       $hsp->length('total'),\n\t\t\t\t       (100 * $hsp->gaps('total') / \n\t\t\t\t\t$hsp->length('total')));\n\t\t}\n\n\t\tmy ($hframe,$qframe)   = ( $hsp->hit->frame, $hsp->query->frame);\n\t\tmy ($hstrand,$qstrand) = ($hsp->hit->strand,$hsp->query->strand);\n\t\t# so TBLASTX will have Query/Hit frames\n\t\t#    BLASTX  will have Query frame\n\t\t#    TBLASTN will have Hit frame\n\t\tif( $hstrand || $qstrand ) {\n\t\t    $hspstr .= \", Frame = \";\n\t\t    my ($signq, $signh);\n\t\t    unless( $hstrand ) {\n\t\t\t$hframe = undef;\n\t\t\t# if strand is null or 0 then it is protein\n\t\t\t# and this no frame\n\t\t    } else { \n\t\t\t$signh = $hstrand < 0 ? '-' : '+';\n\t\t    }\n\t\t    unless( $qstrand  ) {\n\t\t\t$qframe = undef;\n\t\t\t# if strand is null or 0 then it is protein\n\t\t    } else { \n\t\t\t$signq =$qstrand < 0 ? '-' : '+';\n\t\t    }\n\t\t    # remember bioperl stores frames as 0,1,2 (GFF way)\n\t\t    # BLAST reports reports as 1,2,3 so\n\t\t    # we have to add 1 to the frame values\n\t\t    if( defined $hframe && ! defined $qframe) {  \n\t\t\t$hspstr .= \"$signh\".($hframe+1);\n\t\t    } elsif( defined $qframe && ! defined $hframe) {  \n\t\t\t$hspstr .= \"$signq\".($qframe+1);\n\t\t    } else { \n\t\t\t$hspstr .= sprintf(\" %s%d / %s%d\",\n\t\t\t\t\t   $signq,$qframe+1,\n\t\t\t\t\t   $signh, $hframe+1);\n\t\t    }\n\t\t}\n\t\tif($links && \n\t\t   $hsp->can('links') && defined(my $lnks = $hsp->links) ) {\n\t\t    $hspstr .= sprintf(\"<br>\\nLinks = %s\\n\",$lnks);\n\t\t}\n\n\t\t$hspstr .= \"</a><p>\\n<pre>\";\n\n\t\tmy @hspvals = ( {'name' => 'Query:',\n\t\t\t\t 'seq'  => $hsp->query_string,\n\t\t\t\t 'start' => ($qstrand >= 0 ? \n\t\t\t\t\t     $hsp->query->start : \n\t\t\t\t\t     $hsp->query->end),\n\t\t\t\t\t     'end'   => ($qstrand >= 0 ? \n\t\t\t\t\t\t\t $hsp->query->end : \n\t\t\t\t\t\t\t $hsp->query->start),\n\t\t\t\t\t\t\t 'index' => 0,\n\t\t\t\t\t\t\t 'direction' => $qstrand || 1\n\t\t\t\t\t\t     },\n\t\t\t\t{ 'name' => ' 'x6,\n\t\t\t\t  'seq'  => $hsp->homology_string,\n\t\t\t\t  'start' => undef,\n\t\t\t\t  'end'   => undef,\n\t\t\t\t  'index' => 0,\n\t\t\t\t  'direction' => 1\n\t\t\t\t  },\n\t\t\t\t{ 'name'  => 'Sbjct:',\n\t\t\t\t  'seq'   => $hsp->hit_string,\n\t\t\t\t  'start' => ($hstrand >= 0 ? \n\t\t\t\t\t      $hsp->hit->start : \n\t\t\t\t\t      $hsp->hit->end),\n\t\t\t\t\t      'end'   => ($hstrand >= 0 ? \n\t\t\t\t\t\t\t  $hsp->hit->end : \n\t\t\t\t\t\t\t  $hsp->hit->start),\n\t\t\t\t\t\t\t  'index' => 0, \n\t\t\t\t\t\t\t  'direction' => $hstrand || 1\n\t\t\t\t\t\t      }\n\t\t\t\t);\t    \n\n\n\t\t# let's set the expected length (in chars) of the starting number\n\t\t# in an alignment block so we can have things line up\n\t\t# Just going to try and set to the largest\n\n\t\tmy ($numwidth) = sort { $b <=> $a }(length($hspvals[0]->{'start'}),\n\t\t\t\t\t\t    length($hspvals[0]->{'end'}),\n\t\t\t\t\t\t    length($hspvals[2]->{'start'}),\n\t\t\t\t\t\t    length($hspvals[2]->{'end'}));\n\t\tmy $count = 0;\n\t\twhile ( $count < $hsp->length('total') ) {\n\t\t    foreach my $v ( @hspvals ) {\n\t\t\tmy $piece = substr($v->{'seq'}, $v->{'index'} + $count,\n\t\t\t\t\t   $AlignmentLineWidth);\n\t\t\tmy $cp = $piece;\n\t\t\tmy $plen = scalar ( $cp =~ tr/\\-//);\n\t\t\tmy ($start,$end) = ('','');\n\t\t\tif( defined $v->{'start'} ) { \n\t\t\t    $start = $v->{'start'};\n\t\t\t    # since strand can be + or - use the direction\n\t\t\t    # to signify which whether to add or substract from end\n\t\t\t    my $d = $v->{'direction'} * ( $AlignmentLineWidth - $plen )*\n\t\t\t\t$baselens{$v->{'name'}};\n\t\t\t    if( length($piece) < $AlignmentLineWidth ) {\n\t\t\t\t$d = (length($piece) - $plen) * $v->{'direction'} * \n\t\t\t\t    $baselens{$v->{'name'}};\n\t\t\t    }\n\t\t\t    $end   = $v->{'start'} + $d - $v->{'direction'};\n\t\t\t    $v->{'start'} += $d;\n\t\t\t}\n\t\t\t$hspstr .= sprintf(\"%s %-\".$numwidth.\"s %s %s\\n\",\n\t\t\t\t\t   $v->{'name'},\n\t\t\t\t\t   $start,\n\t\t\t\t\t   $piece,\n\t\t\t\t\t   $end\n\t\t\t\t\t   );\n\t\t    }\n\t\t    $count += $AlignmentLineWidth;\n\t\t    $hspstr .= \"\\n\\n\";\n\t\t}\n\t\t$hspstr .= \"</pre>\\n\";\n\t    }\n\t}\n#\t$hspstr .= \"</pre>\\n\";\n    }\n\n    $str .= \"</table><p>\\n\".$hspstr;\n    my ($pav, $sav) = ($result->available_parameters, $result->available_statistics);\n    if ($pav || $sav) {\n        # make table of search statistics and end the web page\n        $str .= \"<p><p><hr><h2>Search Parameters</h2>\";\n        if ($pav) {\n        $str .= \"<table border=1><tr><th>Parameter</th><th>Value</th>\\n\";\n        foreach my $param ( sort $result->available_parameters ) {\n            $str .= \"<tr><td>$param</td><td>\". $result->get_parameter($param) .\"</td></tr>\\n\";\n        }\n        $str .= \"</table>\";\n        }\n        \n        if ($sav) {\n        $str .= \"<p><h2>Search Statistics</h2><table border=1><tr><th>Statistic</th><th>Value</th></tr>\\n\";\n        foreach my $stat ( sort $result->available_statistics ) {\n            $str .= \"<tr><td>$stat</td><td>\". $result->get_statistic($stat). \"</td>\\n\";\n        }\n        $str .=  \"</tr></table>\";\n        }\n    }\n    $str .= $self->footer() . \"<P>\\n\";\n    return $str;\n}\n\n=head2 hit_link_desc\n\n Title   : hit_link_desc\n Usage   : $self->hit_link_desc(\\&link_function);\n Function: Get/Set the function which provides an HTML \n           link(s) for the given hit to be used\n           within the description section at the top of the BLAST report.\n           This allows a person reading the report within\n           a web browser to go to one or more database entries for\n           the given hit from the description section.\n Returns : Function reference\n Args    : Function reference\n See Also: L<default_hit_link_desc()>\n\n\nsub hit_link_desc{\n    my( $self, $code ) = @_; \n    if ($code) {\n        $self->{'_hit_link_desc'} = $code;\n    }\n    return $self->{'_hit_link_desc'} || \\&default_hit_link_desc;\n}\n\n=head2 default_hit_link_desc\n\n Title   : default_hit_link_desc\n Usage   : $self->default_hit_link_desc($hit, $result)\n Function: Provides an HTML link(s) for the given hit to be used\n           within the description section at the top of the BLAST report.\n           This allows a person reading the report within\n           a web browser to go to one or more database entries for\n           the given hit from the description section.\n Returns : string containing HTML markup \"<a href...\")\n\n           The default implementation returns an HTML link to the\n           URL supplied by the remote_database_url() method\n           and using the identifier supplied by the id_parser() method.\n           It will use the NCBI GI if present, and the accession if not.\n\n Args    : First argument is a Bio::Search::Hit::HitI\n           Second argument is a Bio::Search::Result::ResultI\n\nSee Also: L<hit_link_align>, L<remote_database>, L<id_parser>\n\n\nsub default_hit_link_desc {\n    my($self, $hit, $result) = @_;\n    my $type = ( $result->algorithm =~ /(P|X|Y)$/i ) ? 'PROTEIN' : 'NUCLEOTIDE';\n    my ($gi,$acc) = &{$self->id_parser}($hit->name);\n\n    my $url = length($self->remote_database_url($type)) > 0 ? \n              sprintf('<a href=\"%s\">%s</a>',\n                      sprintf($self->remote_database_url($type),$gi || $acc), \n                      $hit->name()) :  $hit->name();\n\n    return $url;\n}\n\n\n=head2 hit_link_align\n\n Title   : hit_link_align\n Usage   : $self->hit_link_align(\\&link_function);\n Function: Get/Set the function which provides an HTML link(s) \n           for the given hit to be used\n           within the HSP alignment section of the BLAST report.\n           This allows a person reading the report within\n           a web browser to go to one or more database entries for\n           the given hit from the alignment section.\n Returns : string containing HTML markup \"<a href...\")\n\n           The default implementation delegates to hit_link_desc().\n\n Args    : First argument is a Bio::Search::Hit::HitI\n           Second argument is a Bio::Search::Result::ResultI\n\nSee Also: L<hit_link_desc>, L<remote_database>, L<id_parser>\n\n\nsub hit_link_align {\n    my ($self,$code) = @_;\n    if ($code) {\n        $self->{'_hit_link_align'} = $code;\n    }\n    return $self->{'_hit_link_align'} || \\&default_hit_link_desc;\n}\n\n=head2 hit_desc_line\n\n Title   : hit_desc_line\n Usage   : $self->hit_desc_line(\\&link_function);\n Function: Get/Set the function which provides HTML for the description\n           information from a hit. This allows one to parse\n           the rest of the description and split up lines, add links, etc.\n Returns : Function reference\n Args    : Function reference\n See Also: L<default_hit_link_desc()>\n\n\nsub hit_desc_line{\n    my( $self, $code ) = @_; \n    if ($code) {\n        $self->{'_hit_desc_line'} = $code;\n    }\n    return $self->{'_hit_desc_line'} || \\&default_hit_desc_line;\n}\n\n=head2 default_hit_desc_line\n\n Title   : default_hit_desc_line\n Usage   : $self->default_hit_desc_line($hit, $result)\n Function: Parses the description line information, splits based on the\n           hidden \\x01 between independent descriptions, checks the lines for\n           possible web links, and adds HTML link(s) for the given hit to be\n           used.\n\n Returns : string containing HTML markup \"<a href...\")\n           The default implementation returns an HTML link to the\n           URL supplied by the remote_database_url() method\n           and using the identifier supplied by the id_parser() method.\n           It will use the NCBI GI if present, and the accession if not.\n\n Args    : First argument is a Bio::Search::Hit::HitI\n           Second argument is a Bio::Search::Result::ResultI\n\nSee Also: L<hit_link_align>, L<remote_database>, L<id_parser>\n\n\nsub default_hit_desc_line {\n    my($self, $hit, $result) = @_;\n    my $type = ( $result->algorithm =~ /(P|X|Y)$/i ) ? 'PROTEIN' : 'NUCLEOTIDE';\n    my @descs = split /\\x01/, $hit->description;\n    #my $descline = join(\"</br>\",@descs).\"</br>\";\n    my $descline = '';\n    #return $descline;\n    for my $sec (@descs) {\n        my $url = '';\n        if ($sec =~ s/((?:gi\\|(\\d+)\\|)?        # optional GI\n                     (\\w+)\\|([A-Z\\d\\.\\_]+) # main \n                     (\\|[A-Z\\d\\_]+)?) # optional secondary ID//xms) {\n            my ($name, $gi, $db, $acc) = ($1, $2, $3, $4);\n            #$acc ||= ($rest) ? $rest : $gi;\n            $acc =~ s/^\\s+(\\S+)/$1/;\n            $acc =~ s/(\\S+)\\s+$/$1/;\n            $url =\n            length($self->remote_database_url($type)) > 0 ? \n              sprintf('<a href=\"%s\">%s</a> %s',\n                      sprintf($self->remote_database_url($type),\n                      $gi || $acc || $db), \n                      $name, $sec) :  $sec;\n        } else {\n            $url = $sec;\n        }\n        $descline .= \"$url</br>\\n\";\n    }\n    return $descline;\n}\n\n=head2 start_report\n\n  Title   : start_report\n  Usage   : $index->start_report( CODE )\n  Function: Stores or returns the code to\n            write the start of the <HTML> block, the <TITLE> block\n            and the start of the <BODY> block of HTML.   Useful\n            for (for instance) specifying alternative\n            HTML if you are embedding the output in\n            an HTML page which you have already started.\n            (For example a routine returning a null string).\n            Returns \\&default_start_report (see below) if not\n            set. \n  Example : $index->start_report( \\&my_start_report )\n  Returns : ref to CODE if called without arguments\n  Args    : CODE\n\n\nsub start_report {\n    my( $self, $code ) = @_; \n    if ($code) {\n        $self->{'_start_report'} = $code;\n    }\n    return $self->{'_start_report'} || \\&default_start_report;\n}\n\n=head2 default_start_report\n\n Title   : default_start_report\n Usage   : $self->default_start_report($result)\n Function: The default method to call when starting a report.\n Returns : sting\n Args    : First argument is a Bio::Search::Result::ResultI\n\n\nsub default_start_report {\n    my ($result) = @_;\n    return sprintf(\n    qq{<HTML>\n      <HEAD> <CENTER><TITLE>Bioperl Reformatted HTML of %s output with Bioperl Bio::SearchIO system</TITLE></CENTER></HEAD>\n      <!------------------------------------------------------------------->\n      <!-- Generated by Bio::SearchIO::Writer::HTMLResultWriter          -->\n      <!-- %s -->\n      <!-- http://bioperl.org                                            -->\n      <!------------------------------------------------------------------->\n      <BODY BGCOLOR=\"WHITE\">\n    },$result->algorithm,$Revision);\n    \n}\n\n=head2 title\n\n Title   : title\n Usage   : $self->title($CODE)\n\n  Function: Stores or returns the code to provide HTML for the given\n            BLAST report that will appear at the top of the BLAST report\n            HTML output.  Useful for (for instance) specifying\n            alternative routines to write your own titles.\n            Returns \\&default_title (see below) if not\n            set. \n  Example : $index->title( \\&my_title )\n  Returns : ref to CODE if called without arguments\n  Args    : CODE"},"detail":"($self,$code)","kind":12,"children":[{"line":725,"kind":13,"localvar":"my","containerName":"title","name":"$self","definition":"my"},{"containerName":"title","name":"$code","line":725,"kind":13},{"line":726,"kind":13,"containerName":"title","name":"$code"},{"name":"$self","containerName":"title","kind":13,"line":727},{"containerName":"title","name":"$code","kind":13,"line":727},{"kind":13,"line":729,"containerName":"title","name":"$self"}],"line":724,"name":"title","range":{"start":{"line":724,"character":0},"end":{"line":730,"character":9999}}},{"name":"default_title","line":729,"kind":12},{"name":"default_title","range":{"start":{"line":747,"character":0},"end":{"character":9999,"line":754}},"definition":"sub","containerName":"main::","signature":{"label":"default_title($result)","documentation":"1;\n# $Id: HTMLResultWriter.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::Writer::HTMLResultWriter\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# Changes 2003-07-31 (jason)\n# Gary has cleaned up the code a lot to produce better looking HTML\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::Writer::HTMLResultWriter - write a Bio::Search::ResultI in HTML\n\n=head1 SYNOPSIS\n\n  use Bio::SearchIO;\n  use Bio::SearchIO::Writer::HTMLResultWriter;\n\n  my $in = Bio::SearchIO->new(-format => 'blast',\n\t\t\t     -file   => shift @ARGV);\n\n  my $writer = Bio::SearchIO::Writer::HTMLResultWriter->new();\n  my $out = Bio::SearchIO->new(-writer => $writer);\n  $out->write_result($in->next_result);\n\n\n  # to filter your output\n  my $MinLength = 100; # need a variable with scope outside the method\n  sub hsp_filter { \n      my $hsp = shift;\n      return 1 if $hsp->length('total') > $MinLength;\n  }\n  sub result_filter { \n      my $result = shift;\n      return $hsp->num_hits > 0;\n  }\n\n  my $writer = Bio::SearchIO::Writer::HTMLResultWriter->new\n                     (-filters => { 'HSP' => \\&hsp_filter} );\n  my $out = Bio::SearchIO->new(-writer => $writer);\n  $out->write_result($in->next_result);\n\n  # can also set the filter via the writer object\n  $writer->filter('RESULT', \\&result_filter);\n\n=head1 DESCRIPTION\n\nThis object implements the SearchWriterI interface which will produce\na set of HTML for a specific L<Bio::Search::Report::ReportI> interface.\n\nSee L<Bio::SearchIO::SearchWriterI> for more info on the filter method.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nGary Williams G.Williams@hgmp.mrc.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\npackage Bio::SearchIO::Writer::HTMLResultWriter;\nuse strict;\nuse vars qw(%RemoteURLDefault\n            $MaxDescLen $DATE $AlignmentLineWidth $Revision);\n\n# Object preamble - inherits from Bio::Root::RootI\n\nBEGIN {\n    $Revision = '$Id: HTMLResultWriter.pm 16123 2009-09-17 12:57:27Z cjfields $';\n    $DATE = localtime(time);\n    %RemoteURLDefault = ( \n      'PROTEIN' => 'http://www.ncbi.nlm.nih.gov/entrez/query.fcgi?db=protein&cmd=search&term=%s',\t\t\t  \n      'NUCLEOTIDE' => 'http://www.ncbi.nlm.nih.gov/entrez/query.fcgi?db=nucleotide&cmd=search&term=%s'\n    );\n    $MaxDescLen = 60;\n    $AlignmentLineWidth = 60;\n}\n\n\nuse base qw(Bio::Root::Root Bio::SearchIO::SearchWriterI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::Writer::HTMLResultWriter->new();\n Function: Builds a new Bio::SearchIO::Writer::HTMLResultWriter object \n Returns : Bio::SearchIO::Writer::HTMLResultWriter\n Args    : -filters => hashref with any or all of the keys (HSP HIT RESULT)\n           which have values pointing to a subroutine reference\n           which will expect to get a \n           -nucleotide_url => URL sprintf string base for the nt sequences\n           -protein_url => URL sprintf string base for the aa sequences\n           -no_wublastlinks => boolean. Do not display WU-BLAST lines \n                               even if they are parsed out.\n                               Links = (1) \n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($p,$n,$filters,\n      $nowublastlinks) = $self->_rearrange([qw(PROTEIN_URL \n\t\t\t\t\t       NUCLEOTIDE_URL \n\t\t\t\t\t       FILTERS\n\t\t\t\t\t       NO_WUBLASTLINKS)],@args);\n  $self->remote_database_url('p',$p || $RemoteURLDefault{'PROTEIN'});\n  $self->remote_database_url('n',$n || $RemoteURLDefault{'NUCLEOTIDE'});\n  $self->no_wublastlinks(! $nowublastlinks);\n  if( defined $filters ) {\n      if( !ref($filters) =~ /HASH/i ) { \n\t  $self->warn(\"Did not provide a hashref for the FILTERS option, ignoring.\");\n      } else { \n\t  while( my ($type,$code) = each %{$filters} ) {\n\t      $self->filter($type,$code);\n\t  }\n      }\n  }\n\n  return $self;\n}\n\n=head2 remote_database_url\n\n Title   : remote_database_url\n Usage   : $obj->remote_database_url($type,$newval)\n Function: This should return or set a string that contains a %s which can be\n           filled in with sprintf.\n Returns : value of remote_database_url\n Args    : $type - 'PROTEIN' or 'P' for protein URLS\n                   'NUCLEOTIDE' or 'N' for nucleotide URLS\n           $value - new value to set [optional]\n\n\n\nsub remote_database_url{\n   my ($self,$type,$value) = @_;\n   if( ! defined $type || $type !~ /^(P|N)/i ) { \n       $self->warn(\"Must provide a type (PROTEIN or NUCLEOTIDE)\");\n       return '';\n   }\n   $type = uc $1;\n   if( defined $value) {\n      $self->{'remote_database_url'}->{$type} = $value;\n    }\n   return $self->{'remote_database_url'}->{$type};\n}\n\n=head2 to_string\n\n Purpose   : Produces data for each Search::Result::ResultI in a string.\n           : This is an abstract method. For some useful implementations,\n           : see ResultTableWriter.pm, HitTableWriter.pm, \n           : and HSPTableWriter.pm.\n Usage     : print $writer->to_string( $result_obj, @args );\n Argument  : $result_obj = A Bio::Search::Result::ResultI object\n           : @args = any additional arguments used by your implementation.\n Returns   : String containing data for each search Result or any of its\n           : sub-objects (Hits and HSPs).\n Throws    : n/a\n\n\nsub to_string {\n    my ($self,$result,$num) = @_; \n    $num ||= 0;\n    return unless defined $result;\n    my $links = $self->no_wublastlinks;\n    my ($resultfilter,$hitfilter, $hspfilter) = ( $self->filter('RESULT'),\n\t\t\t\t\t\t  $self->filter('HIT'),\n\t\t\t\t\t\t  $self->filter('HSP') );\n    return '' if( defined $resultfilter && ! &{$resultfilter}($result) );    \n\n    my ($qtype,$dbtype,$dbseqtype,$type);\n    my $alg = $result->algorithm;\n    # This is actually wrong for the FASTAs I think\n    if(  $alg =~ /T(FAST|BLAST)([XY])/i ) {\n\t$qtype      = $dbtype = 'translated';\n\t$dbseqtype = $type       = 'PROTEIN';\n    } elsif( $alg =~ /T(FAST|BLAST)N/i ) {\n\t$qtype      = '';\n\t$dbtype     = 'translated';\n\t$type       = 'PROTEIN';\n\t$dbseqtype  = 'NUCLEOTIDE';\n    } elsif( $alg =~ /(FAST|BLAST)N/i || \n\t     $alg =~ /(WABA|EXONERATE)/i ) {\n\t$qtype      = $dbtype = '';\n\t$type = $dbseqtype  = 'NUCLEOTIDE';\n    } elsif( $alg =~ /(FAST|BLAST)P/  || \n\t     $alg =~ /SSEARCH|HMM(PFAM|SEARCH)/i ) {\n\t$qtype      = $dbtype = '';\n\t$type = $dbseqtype  = 'PROTEIN';\n    } elsif( $alg =~ /(FAST|BLAST)[XY]/i ) {\n\t$qtype      = 'translated';\n        $dbtype     = 'PROTEIN';\n\t$dbseqtype  = $type      = 'PROTEIN';\n    } else { \n\t$self->warn(\"algorithm was \", $result->algorithm, \" couldn't match\\n\");\n    }\n    \n    \n    my %baselens = ( 'Sbjct:'   => ( $dbtype eq 'translated' )  ? 3 : 1,\n\t\t     'Query:'   => ( $qtype  eq 'translated' )  ? 3 : 1);\n\n    my $str;\n    if( $num <= 1 ) { \n\t$str = &{$self->start_report}($result);\n    }\n\n    $str .= &{$self->title}($result);\n\n    $str .= $result->algorithm_reference || $self->algorithm_reference($result);\n    $str .= &{$self->introduction}($result);\n\n    $str .= \"<table border=0>\n            <tr><th>Sequences producing significant alignments:</th>\n            <th>Score<br>(bits)</th><th>E<br>value</th></tr>\";\n\n    my $hspstr = '<p><p>';\n    if( $result->can('rewind')) {\n        $result->rewind(); # support stream based parsing routines\n    }\n\n    while( my $hit = $result->next_hit ) {\n\tnext if( $hitfilter && ! &{$hitfilter}($hit) );\n\tmy $nm = $hit->name();\n\t\n\t$self->debug( \"no $nm for name (\".$hit->description(). \"\\n\") \n\t    unless $nm;\n\tmy ($gi,$acc) = &{$self->id_parser}($nm);\n\tmy $p = \"%-$MaxDescLen\". \"s\";\n\tmy $descsub;\n\tif( length($hit->description) > ($MaxDescLen - 3) ) {\n\t    $descsub = sprintf($p,\n\t\tsubstr($hit->description,0,$MaxDescLen-3) . \"...\");\n\t} else { \n\t    $descsub = sprintf($p,$hit->description);\n\t}\n\n\tmy $url_desc  = &{$self->hit_link_desc()}($self,$hit, $result);\n\tmy $url_align = &{$self->hit_link_align()}($self,$hit, $result);\n\n\tmy @hsps = $hit->hsps;\n\t\n\tif( ! @hsps ) {\n\t    # no HSPs so no link \n\t    $str .= sprintf('<tr><td>%s %s</td><td>%s</td><td>%.2g</td></tr>'.\"\\n\",\n\t\t\t    $url_desc, $descsub, \n\t\t\t    ($hit->bits ? $hit->bits : \n\t\t\t     (defined $hsps[0] ? $hsps[0]->bits : ' ')),\n\t\t\t    ( $hit->significance ? $hit->significance :\n\t\t\t      (defined $hsps[0] ? $hsps[0]->evalue : ' ')) \n\t\t\t    );\n\t} else { \n\t    # failover to first HSP if the data does not contain a \n\t    # bitscore/significance value for the Hit (NCBI XML data for one)\n\n\t    $str .= sprintf('<tr><td>%s %s</td><td>%s</td><td><a href=\"#%s\">%.2g</a></td></tr>'.\"\\n\",\n\t\t\t    $url_desc, $descsub, \n\t\t\t    ($hit->bits ? $hit->bits : \n\t\t\t     (defined $hsps[0] ? $hsps[0]->bits : ' ')),\n\t\t\t    $acc,\n\t\t\t    ( $hit->significance ? $hit->significance :\n\t\t\t      (defined $hsps[0] ? $hsps[0]->evalue : ' ')) \n\t\t\t    );\n        my $dline = &{$self->hit_desc_line}($self, $hit, $result);\n\t    $hspstr .= \"<a name=\\\"$acc\\\">\\n\".\n\t\tsprintf(\"><b>%s</b> %s</br><dd>Length = %s</dd><p>\\n\\n\", $url_align, \n\t\t\t$dline , &_numwithcommas($hit->length));\n\t    my $ct = 0;\n\t    foreach my $hsp (@hsps ) {\n\t\tnext if( $hspfilter && ! &{$hspfilter}($hsp) );\n\t\t$hspstr .= sprintf(\" Score = %s bits (%s), Expect = %s\",\n\t\t\t\t   $hsp->bits || $hsp->score, \n\t\t\t\t   $hsp->score || $hsp->bits, \n\t\t\t\t   $hsp->evalue || '');\n\t\tif( defined $hsp->pvalue ) {\n\t\t    $hspstr .= \", P = \".$hsp->pvalue;\n\t\t}\n\t\t$hspstr .= \"<br>\\n\";\n\t\t$hspstr .= sprintf(\" Identities = %d/%d (%d%%)\",\n\t\t\t\t   ( $hsp->frac_identical('total') * \n\t\t\t\t     $hsp->length('total')),\n\t\t\t\t   $hsp->length('total'),\n\t\t\t\t   $hsp->frac_identical('total') * 100);\n\n\t\tif( $type eq 'PROTEIN' ) {\n\t\t    $hspstr .= sprintf(\", Positives = %d/%d (%d%%)\",\n\t\t\t\t       ( $hsp->frac_conserved('total') * \n\t\t\t\t\t $hsp->length('total')),\n\t\t\t\t       $hsp->length('total'),\n\t\t\t\t       $hsp->frac_conserved('total') * 100);\n\t\t}\n\t\tif( $hsp->gaps ) {\n\t\t    $hspstr .= sprintf(\", Gaps = %d/%d (%d%%)\",\n\t\t\t\t       $hsp->gaps('total'),\n\t\t\t\t       $hsp->length('total'),\n\t\t\t\t       (100 * $hsp->gaps('total') / \n\t\t\t\t\t$hsp->length('total')));\n\t\t}\n\n\t\tmy ($hframe,$qframe)   = ( $hsp->hit->frame, $hsp->query->frame);\n\t\tmy ($hstrand,$qstrand) = ($hsp->hit->strand,$hsp->query->strand);\n\t\t# so TBLASTX will have Query/Hit frames\n\t\t#    BLASTX  will have Query frame\n\t\t#    TBLASTN will have Hit frame\n\t\tif( $hstrand || $qstrand ) {\n\t\t    $hspstr .= \", Frame = \";\n\t\t    my ($signq, $signh);\n\t\t    unless( $hstrand ) {\n\t\t\t$hframe = undef;\n\t\t\t# if strand is null or 0 then it is protein\n\t\t\t# and this no frame\n\t\t    } else { \n\t\t\t$signh = $hstrand < 0 ? '-' : '+';\n\t\t    }\n\t\t    unless( $qstrand  ) {\n\t\t\t$qframe = undef;\n\t\t\t# if strand is null or 0 then it is protein\n\t\t    } else { \n\t\t\t$signq =$qstrand < 0 ? '-' : '+';\n\t\t    }\n\t\t    # remember bioperl stores frames as 0,1,2 (GFF way)\n\t\t    # BLAST reports reports as 1,2,3 so\n\t\t    # we have to add 1 to the frame values\n\t\t    if( defined $hframe && ! defined $qframe) {  \n\t\t\t$hspstr .= \"$signh\".($hframe+1);\n\t\t    } elsif( defined $qframe && ! defined $hframe) {  \n\t\t\t$hspstr .= \"$signq\".($qframe+1);\n\t\t    } else { \n\t\t\t$hspstr .= sprintf(\" %s%d / %s%d\",\n\t\t\t\t\t   $signq,$qframe+1,\n\t\t\t\t\t   $signh, $hframe+1);\n\t\t    }\n\t\t}\n\t\tif($links && \n\t\t   $hsp->can('links') && defined(my $lnks = $hsp->links) ) {\n\t\t    $hspstr .= sprintf(\"<br>\\nLinks = %s\\n\",$lnks);\n\t\t}\n\n\t\t$hspstr .= \"</a><p>\\n<pre>\";\n\n\t\tmy @hspvals = ( {'name' => 'Query:',\n\t\t\t\t 'seq'  => $hsp->query_string,\n\t\t\t\t 'start' => ($qstrand >= 0 ? \n\t\t\t\t\t     $hsp->query->start : \n\t\t\t\t\t     $hsp->query->end),\n\t\t\t\t\t     'end'   => ($qstrand >= 0 ? \n\t\t\t\t\t\t\t $hsp->query->end : \n\t\t\t\t\t\t\t $hsp->query->start),\n\t\t\t\t\t\t\t 'index' => 0,\n\t\t\t\t\t\t\t 'direction' => $qstrand || 1\n\t\t\t\t\t\t     },\n\t\t\t\t{ 'name' => ' 'x6,\n\t\t\t\t  'seq'  => $hsp->homology_string,\n\t\t\t\t  'start' => undef,\n\t\t\t\t  'end'   => undef,\n\t\t\t\t  'index' => 0,\n\t\t\t\t  'direction' => 1\n\t\t\t\t  },\n\t\t\t\t{ 'name'  => 'Sbjct:',\n\t\t\t\t  'seq'   => $hsp->hit_string,\n\t\t\t\t  'start' => ($hstrand >= 0 ? \n\t\t\t\t\t      $hsp->hit->start : \n\t\t\t\t\t      $hsp->hit->end),\n\t\t\t\t\t      'end'   => ($hstrand >= 0 ? \n\t\t\t\t\t\t\t  $hsp->hit->end : \n\t\t\t\t\t\t\t  $hsp->hit->start),\n\t\t\t\t\t\t\t  'index' => 0, \n\t\t\t\t\t\t\t  'direction' => $hstrand || 1\n\t\t\t\t\t\t      }\n\t\t\t\t);\t    \n\n\n\t\t# let's set the expected length (in chars) of the starting number\n\t\t# in an alignment block so we can have things line up\n\t\t# Just going to try and set to the largest\n\n\t\tmy ($numwidth) = sort { $b <=> $a }(length($hspvals[0]->{'start'}),\n\t\t\t\t\t\t    length($hspvals[0]->{'end'}),\n\t\t\t\t\t\t    length($hspvals[2]->{'start'}),\n\t\t\t\t\t\t    length($hspvals[2]->{'end'}));\n\t\tmy $count = 0;\n\t\twhile ( $count < $hsp->length('total') ) {\n\t\t    foreach my $v ( @hspvals ) {\n\t\t\tmy $piece = substr($v->{'seq'}, $v->{'index'} + $count,\n\t\t\t\t\t   $AlignmentLineWidth);\n\t\t\tmy $cp = $piece;\n\t\t\tmy $plen = scalar ( $cp =~ tr/\\-//);\n\t\t\tmy ($start,$end) = ('','');\n\t\t\tif( defined $v->{'start'} ) { \n\t\t\t    $start = $v->{'start'};\n\t\t\t    # since strand can be + or - use the direction\n\t\t\t    # to signify which whether to add or substract from end\n\t\t\t    my $d = $v->{'direction'} * ( $AlignmentLineWidth - $plen )*\n\t\t\t\t$baselens{$v->{'name'}};\n\t\t\t    if( length($piece) < $AlignmentLineWidth ) {\n\t\t\t\t$d = (length($piece) - $plen) * $v->{'direction'} * \n\t\t\t\t    $baselens{$v->{'name'}};\n\t\t\t    }\n\t\t\t    $end   = $v->{'start'} + $d - $v->{'direction'};\n\t\t\t    $v->{'start'} += $d;\n\t\t\t}\n\t\t\t$hspstr .= sprintf(\"%s %-\".$numwidth.\"s %s %s\\n\",\n\t\t\t\t\t   $v->{'name'},\n\t\t\t\t\t   $start,\n\t\t\t\t\t   $piece,\n\t\t\t\t\t   $end\n\t\t\t\t\t   );\n\t\t    }\n\t\t    $count += $AlignmentLineWidth;\n\t\t    $hspstr .= \"\\n\\n\";\n\t\t}\n\t\t$hspstr .= \"</pre>\\n\";\n\t    }\n\t}\n#\t$hspstr .= \"</pre>\\n\";\n    }\n\n    $str .= \"</table><p>\\n\".$hspstr;\n    my ($pav, $sav) = ($result->available_parameters, $result->available_statistics);\n    if ($pav || $sav) {\n        # make table of search statistics and end the web page\n        $str .= \"<p><p><hr><h2>Search Parameters</h2>\";\n        if ($pav) {\n        $str .= \"<table border=1><tr><th>Parameter</th><th>Value</th>\\n\";\n        foreach my $param ( sort $result->available_parameters ) {\n            $str .= \"<tr><td>$param</td><td>\". $result->get_parameter($param) .\"</td></tr>\\n\";\n        }\n        $str .= \"</table>\";\n        }\n        \n        if ($sav) {\n        $str .= \"<p><h2>Search Statistics</h2><table border=1><tr><th>Statistic</th><th>Value</th></tr>\\n\";\n        foreach my $stat ( sort $result->available_statistics ) {\n            $str .= \"<tr><td>$stat</td><td>\". $result->get_statistic($stat). \"</td>\\n\";\n        }\n        $str .=  \"</tr></table>\";\n        }\n    }\n    $str .= $self->footer() . \"<P>\\n\";\n    return $str;\n}\n\n=head2 hit_link_desc\n\n Title   : hit_link_desc\n Usage   : $self->hit_link_desc(\\&link_function);\n Function: Get/Set the function which provides an HTML \n           link(s) for the given hit to be used\n           within the description section at the top of the BLAST report.\n           This allows a person reading the report within\n           a web browser to go to one or more database entries for\n           the given hit from the description section.\n Returns : Function reference\n Args    : Function reference\n See Also: L<default_hit_link_desc()>\n\n\nsub hit_link_desc{\n    my( $self, $code ) = @_; \n    if ($code) {\n        $self->{'_hit_link_desc'} = $code;\n    }\n    return $self->{'_hit_link_desc'} || \\&default_hit_link_desc;\n}\n\n=head2 default_hit_link_desc\n\n Title   : default_hit_link_desc\n Usage   : $self->default_hit_link_desc($hit, $result)\n Function: Provides an HTML link(s) for the given hit to be used\n           within the description section at the top of the BLAST report.\n           This allows a person reading the report within\n           a web browser to go to one or more database entries for\n           the given hit from the description section.\n Returns : string containing HTML markup \"<a href...\")\n\n           The default implementation returns an HTML link to the\n           URL supplied by the remote_database_url() method\n           and using the identifier supplied by the id_parser() method.\n           It will use the NCBI GI if present, and the accession if not.\n\n Args    : First argument is a Bio::Search::Hit::HitI\n           Second argument is a Bio::Search::Result::ResultI\n\nSee Also: L<hit_link_align>, L<remote_database>, L<id_parser>\n\n\nsub default_hit_link_desc {\n    my($self, $hit, $result) = @_;\n    my $type = ( $result->algorithm =~ /(P|X|Y)$/i ) ? 'PROTEIN' : 'NUCLEOTIDE';\n    my ($gi,$acc) = &{$self->id_parser}($hit->name);\n\n    my $url = length($self->remote_database_url($type)) > 0 ? \n              sprintf('<a href=\"%s\">%s</a>',\n                      sprintf($self->remote_database_url($type),$gi || $acc), \n                      $hit->name()) :  $hit->name();\n\n    return $url;\n}\n\n\n=head2 hit_link_align\n\n Title   : hit_link_align\n Usage   : $self->hit_link_align(\\&link_function);\n Function: Get/Set the function which provides an HTML link(s) \n           for the given hit to be used\n           within the HSP alignment section of the BLAST report.\n           This allows a person reading the report within\n           a web browser to go to one or more database entries for\n           the given hit from the alignment section.\n Returns : string containing HTML markup \"<a href...\")\n\n           The default implementation delegates to hit_link_desc().\n\n Args    : First argument is a Bio::Search::Hit::HitI\n           Second argument is a Bio::Search::Result::ResultI\n\nSee Also: L<hit_link_desc>, L<remote_database>, L<id_parser>\n\n\nsub hit_link_align {\n    my ($self,$code) = @_;\n    if ($code) {\n        $self->{'_hit_link_align'} = $code;\n    }\n    return $self->{'_hit_link_align'} || \\&default_hit_link_desc;\n}\n\n=head2 hit_desc_line\n\n Title   : hit_desc_line\n Usage   : $self->hit_desc_line(\\&link_function);\n Function: Get/Set the function which provides HTML for the description\n           information from a hit. This allows one to parse\n           the rest of the description and split up lines, add links, etc.\n Returns : Function reference\n Args    : Function reference\n See Also: L<default_hit_link_desc()>\n\n\nsub hit_desc_line{\n    my( $self, $code ) = @_; \n    if ($code) {\n        $self->{'_hit_desc_line'} = $code;\n    }\n    return $self->{'_hit_desc_line'} || \\&default_hit_desc_line;\n}\n\n=head2 default_hit_desc_line\n\n Title   : default_hit_desc_line\n Usage   : $self->default_hit_desc_line($hit, $result)\n Function: Parses the description line information, splits based on the\n           hidden \\x01 between independent descriptions, checks the lines for\n           possible web links, and adds HTML link(s) for the given hit to be\n           used.\n\n Returns : string containing HTML markup \"<a href...\")\n           The default implementation returns an HTML link to the\n           URL supplied by the remote_database_url() method\n           and using the identifier supplied by the id_parser() method.\n           It will use the NCBI GI if present, and the accession if not.\n\n Args    : First argument is a Bio::Search::Hit::HitI\n           Second argument is a Bio::Search::Result::ResultI\n\nSee Also: L<hit_link_align>, L<remote_database>, L<id_parser>\n\n\nsub default_hit_desc_line {\n    my($self, $hit, $result) = @_;\n    my $type = ( $result->algorithm =~ /(P|X|Y)$/i ) ? 'PROTEIN' : 'NUCLEOTIDE';\n    my @descs = split /\\x01/, $hit->description;\n    #my $descline = join(\"</br>\",@descs).\"</br>\";\n    my $descline = '';\n    #return $descline;\n    for my $sec (@descs) {\n        my $url = '';\n        if ($sec =~ s/((?:gi\\|(\\d+)\\|)?        # optional GI\n                     (\\w+)\\|([A-Z\\d\\.\\_]+) # main \n                     (\\|[A-Z\\d\\_]+)?) # optional secondary ID//xms) {\n            my ($name, $gi, $db, $acc) = ($1, $2, $3, $4);\n            #$acc ||= ($rest) ? $rest : $gi;\n            $acc =~ s/^\\s+(\\S+)/$1/;\n            $acc =~ s/(\\S+)\\s+$/$1/;\n            $url =\n            length($self->remote_database_url($type)) > 0 ? \n              sprintf('<a href=\"%s\">%s</a> %s',\n                      sprintf($self->remote_database_url($type),\n                      $gi || $acc || $db), \n                      $name, $sec) :  $sec;\n        } else {\n            $url = $sec;\n        }\n        $descline .= \"$url</br>\\n\";\n    }\n    return $descline;\n}\n\n=head2 start_report\n\n  Title   : start_report\n  Usage   : $index->start_report( CODE )\n  Function: Stores or returns the code to\n            write the start of the <HTML> block, the <TITLE> block\n            and the start of the <BODY> block of HTML.   Useful\n            for (for instance) specifying alternative\n            HTML if you are embedding the output in\n            an HTML page which you have already started.\n            (For example a routine returning a null string).\n            Returns \\&default_start_report (see below) if not\n            set. \n  Example : $index->start_report( \\&my_start_report )\n  Returns : ref to CODE if called without arguments\n  Args    : CODE\n\n\nsub start_report {\n    my( $self, $code ) = @_; \n    if ($code) {\n        $self->{'_start_report'} = $code;\n    }\n    return $self->{'_start_report'} || \\&default_start_report;\n}\n\n=head2 default_start_report\n\n Title   : default_start_report\n Usage   : $self->default_start_report($result)\n Function: The default method to call when starting a report.\n Returns : sting\n Args    : First argument is a Bio::Search::Result::ResultI\n\n\nsub default_start_report {\n    my ($result) = @_;\n    return sprintf(\n    qq{<HTML>\n      <HEAD> <CENTER><TITLE>Bioperl Reformatted HTML of %s output with Bioperl Bio::SearchIO system</TITLE></CENTER></HEAD>\n      <!------------------------------------------------------------------->\n      <!-- Generated by Bio::SearchIO::Writer::HTMLResultWriter          -->\n      <!-- %s -->\n      <!-- http://bioperl.org                                            -->\n      <!------------------------------------------------------------------->\n      <BODY BGCOLOR=\"WHITE\">\n    },$result->algorithm,$Revision);\n    \n}\n\n=head2 title\n\n Title   : title\n Usage   : $self->title($CODE)\n\n  Function: Stores or returns the code to provide HTML for the given\n            BLAST report that will appear at the top of the BLAST report\n            HTML output.  Useful for (for instance) specifying\n            alternative routines to write your own titles.\n            Returns \\&default_title (see below) if not\n            set. \n  Example : $index->title( \\&my_title )\n  Returns : ref to CODE if called without arguments\n  Args    : CODE\n\n\nsub title {\n    my( $self, $code ) = @_; \n    if ($code) {\n        $self->{'_title'} = $code;\n    }\n    return $self->{'_title'} || \\&default_title;\n}\n\n=head2 default_title\n\n Title   : default_title\n Usage   : $self->default_title($result)\n Function: Provides HTML for the given BLAST report that will appear\n           at the top of the BLAST report HTML output.\n Returns : string containing HTML markup\n           The default implementation returns <CENTER> <H1> HTML\n           containing text such as:\n           \"Bioperl Reformatted HTML of BLASTP Search Report\n                     for gi|1786183|gb|AAC73113.1|\"\n Args    : First argument is a Bio::Search::Result::ResultI","parameters":[{"label":"$result"}]},"detail":"($result)","kind":12,"children":[{"line":748,"kind":13,"localvar":"my","containerName":"default_title","name":"$result","definition":"my"},{"kind":13,"line":752,"containerName":"default_title","name":"$result"},{"name":"algorithm","containerName":"default_title","line":752,"kind":12},{"containerName":"default_title","name":"$result","kind":13,"line":753},{"kind":12,"line":753,"name":"query_name","containerName":"default_title"}],"line":747},{"kind":12,"children":[{"line":776,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"introduction"},{"name":"$code","containerName":"introduction","line":776,"kind":13},{"name":"$code","containerName":"introduction","line":777,"kind":13},{"name":"$self","containerName":"introduction","kind":13,"line":778},{"containerName":"introduction","name":"$code","kind":13,"line":778},{"name":"$self","containerName":"introduction","line":780,"kind":13}],"line":775,"definition":"sub","containerName":"main::","signature":{"documentation":"1;\n# $Id: HTMLResultWriter.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::Writer::HTMLResultWriter\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# Changes 2003-07-31 (jason)\n# Gary has cleaned up the code a lot to produce better looking HTML\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::Writer::HTMLResultWriter - write a Bio::Search::ResultI in HTML\n\n=head1 SYNOPSIS\n\n  use Bio::SearchIO;\n  use Bio::SearchIO::Writer::HTMLResultWriter;\n\n  my $in = Bio::SearchIO->new(-format => 'blast',\n\t\t\t     -file   => shift @ARGV);\n\n  my $writer = Bio::SearchIO::Writer::HTMLResultWriter->new();\n  my $out = Bio::SearchIO->new(-writer => $writer);\n  $out->write_result($in->next_result);\n\n\n  # to filter your output\n  my $MinLength = 100; # need a variable with scope outside the method\n  sub hsp_filter { \n      my $hsp = shift;\n      return 1 if $hsp->length('total') > $MinLength;\n  }\n  sub result_filter { \n      my $result = shift;\n      return $hsp->num_hits > 0;\n  }\n\n  my $writer = Bio::SearchIO::Writer::HTMLResultWriter->new\n                     (-filters => { 'HSP' => \\&hsp_filter} );\n  my $out = Bio::SearchIO->new(-writer => $writer);\n  $out->write_result($in->next_result);\n\n  # can also set the filter via the writer object\n  $writer->filter('RESULT', \\&result_filter);\n\n=head1 DESCRIPTION\n\nThis object implements the SearchWriterI interface which will produce\na set of HTML for a specific L<Bio::Search::Report::ReportI> interface.\n\nSee L<Bio::SearchIO::SearchWriterI> for more info on the filter method.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nGary Williams G.Williams@hgmp.mrc.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\npackage Bio::SearchIO::Writer::HTMLResultWriter;\nuse strict;\nuse vars qw(%RemoteURLDefault\n            $MaxDescLen $DATE $AlignmentLineWidth $Revision);\n\n# Object preamble - inherits from Bio::Root::RootI\n\nBEGIN {\n    $Revision = '$Id: HTMLResultWriter.pm 16123 2009-09-17 12:57:27Z cjfields $';\n    $DATE = localtime(time);\n    %RemoteURLDefault = ( \n      'PROTEIN' => 'http://www.ncbi.nlm.nih.gov/entrez/query.fcgi?db=protein&cmd=search&term=%s',\t\t\t  \n      'NUCLEOTIDE' => 'http://www.ncbi.nlm.nih.gov/entrez/query.fcgi?db=nucleotide&cmd=search&term=%s'\n    );\n    $MaxDescLen = 60;\n    $AlignmentLineWidth = 60;\n}\n\n\nuse base qw(Bio::Root::Root Bio::SearchIO::SearchWriterI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::Writer::HTMLResultWriter->new();\n Function: Builds a new Bio::SearchIO::Writer::HTMLResultWriter object \n Returns : Bio::SearchIO::Writer::HTMLResultWriter\n Args    : -filters => hashref with any or all of the keys (HSP HIT RESULT)\n           which have values pointing to a subroutine reference\n           which will expect to get a \n           -nucleotide_url => URL sprintf string base for the nt sequences\n           -protein_url => URL sprintf string base for the aa sequences\n           -no_wublastlinks => boolean. Do not display WU-BLAST lines \n                               even if they are parsed out.\n                               Links = (1) \n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($p,$n,$filters,\n      $nowublastlinks) = $self->_rearrange([qw(PROTEIN_URL \n\t\t\t\t\t       NUCLEOTIDE_URL \n\t\t\t\t\t       FILTERS\n\t\t\t\t\t       NO_WUBLASTLINKS)],@args);\n  $self->remote_database_url('p',$p || $RemoteURLDefault{'PROTEIN'});\n  $self->remote_database_url('n',$n || $RemoteURLDefault{'NUCLEOTIDE'});\n  $self->no_wublastlinks(! $nowublastlinks);\n  if( defined $filters ) {\n      if( !ref($filters) =~ /HASH/i ) { \n\t  $self->warn(\"Did not provide a hashref for the FILTERS option, ignoring.\");\n      } else { \n\t  while( my ($type,$code) = each %{$filters} ) {\n\t      $self->filter($type,$code);\n\t  }\n      }\n  }\n\n  return $self;\n}\n\n=head2 remote_database_url\n\n Title   : remote_database_url\n Usage   : $obj->remote_database_url($type,$newval)\n Function: This should return or set a string that contains a %s which can be\n           filled in with sprintf.\n Returns : value of remote_database_url\n Args    : $type - 'PROTEIN' or 'P' for protein URLS\n                   'NUCLEOTIDE' or 'N' for nucleotide URLS\n           $value - new value to set [optional]\n\n\n\nsub remote_database_url{\n   my ($self,$type,$value) = @_;\n   if( ! defined $type || $type !~ /^(P|N)/i ) { \n       $self->warn(\"Must provide a type (PROTEIN or NUCLEOTIDE)\");\n       return '';\n   }\n   $type = uc $1;\n   if( defined $value) {\n      $self->{'remote_database_url'}->{$type} = $value;\n    }\n   return $self->{'remote_database_url'}->{$type};\n}\n\n=head2 to_string\n\n Purpose   : Produces data for each Search::Result::ResultI in a string.\n           : This is an abstract method. For some useful implementations,\n           : see ResultTableWriter.pm, HitTableWriter.pm, \n           : and HSPTableWriter.pm.\n Usage     : print $writer->to_string( $result_obj, @args );\n Argument  : $result_obj = A Bio::Search::Result::ResultI object\n           : @args = any additional arguments used by your implementation.\n Returns   : String containing data for each search Result or any of its\n           : sub-objects (Hits and HSPs).\n Throws    : n/a\n\n\nsub to_string {\n    my ($self,$result,$num) = @_; \n    $num ||= 0;\n    return unless defined $result;\n    my $links = $self->no_wublastlinks;\n    my ($resultfilter,$hitfilter, $hspfilter) = ( $self->filter('RESULT'),\n\t\t\t\t\t\t  $self->filter('HIT'),\n\t\t\t\t\t\t  $self->filter('HSP') );\n    return '' if( defined $resultfilter && ! &{$resultfilter}($result) );    \n\n    my ($qtype,$dbtype,$dbseqtype,$type);\n    my $alg = $result->algorithm;\n    # This is actually wrong for the FASTAs I think\n    if(  $alg =~ /T(FAST|BLAST)([XY])/i ) {\n\t$qtype      = $dbtype = 'translated';\n\t$dbseqtype = $type       = 'PROTEIN';\n    } elsif( $alg =~ /T(FAST|BLAST)N/i ) {\n\t$qtype      = '';\n\t$dbtype     = 'translated';\n\t$type       = 'PROTEIN';\n\t$dbseqtype  = 'NUCLEOTIDE';\n    } elsif( $alg =~ /(FAST|BLAST)N/i || \n\t     $alg =~ /(WABA|EXONERATE)/i ) {\n\t$qtype      = $dbtype = '';\n\t$type = $dbseqtype  = 'NUCLEOTIDE';\n    } elsif( $alg =~ /(FAST|BLAST)P/  || \n\t     $alg =~ /SSEARCH|HMM(PFAM|SEARCH)/i ) {\n\t$qtype      = $dbtype = '';\n\t$type = $dbseqtype  = 'PROTEIN';\n    } elsif( $alg =~ /(FAST|BLAST)[XY]/i ) {\n\t$qtype      = 'translated';\n        $dbtype     = 'PROTEIN';\n\t$dbseqtype  = $type      = 'PROTEIN';\n    } else { \n\t$self->warn(\"algorithm was \", $result->algorithm, \" couldn't match\\n\");\n    }\n    \n    \n    my %baselens = ( 'Sbjct:'   => ( $dbtype eq 'translated' )  ? 3 : 1,\n\t\t     'Query:'   => ( $qtype  eq 'translated' )  ? 3 : 1);\n\n    my $str;\n    if( $num <= 1 ) { \n\t$str = &{$self->start_report}($result);\n    }\n\n    $str .= &{$self->title}($result);\n\n    $str .= $result->algorithm_reference || $self->algorithm_reference($result);\n    $str .= &{$self->introduction}($result);\n\n    $str .= \"<table border=0>\n            <tr><th>Sequences producing significant alignments:</th>\n            <th>Score<br>(bits)</th><th>E<br>value</th></tr>\";\n\n    my $hspstr = '<p><p>';\n    if( $result->can('rewind')) {\n        $result->rewind(); # support stream based parsing routines\n    }\n\n    while( my $hit = $result->next_hit ) {\n\tnext if( $hitfilter && ! &{$hitfilter}($hit) );\n\tmy $nm = $hit->name();\n\t\n\t$self->debug( \"no $nm for name (\".$hit->description(). \"\\n\") \n\t    unless $nm;\n\tmy ($gi,$acc) = &{$self->id_parser}($nm);\n\tmy $p = \"%-$MaxDescLen\". \"s\";\n\tmy $descsub;\n\tif( length($hit->description) > ($MaxDescLen - 3) ) {\n\t    $descsub = sprintf($p,\n\t\tsubstr($hit->description,0,$MaxDescLen-3) . \"...\");\n\t} else { \n\t    $descsub = sprintf($p,$hit->description);\n\t}\n\n\tmy $url_desc  = &{$self->hit_link_desc()}($self,$hit, $result);\n\tmy $url_align = &{$self->hit_link_align()}($self,$hit, $result);\n\n\tmy @hsps = $hit->hsps;\n\t\n\tif( ! @hsps ) {\n\t    # no HSPs so no link \n\t    $str .= sprintf('<tr><td>%s %s</td><td>%s</td><td>%.2g</td></tr>'.\"\\n\",\n\t\t\t    $url_desc, $descsub, \n\t\t\t    ($hit->bits ? $hit->bits : \n\t\t\t     (defined $hsps[0] ? $hsps[0]->bits : ' ')),\n\t\t\t    ( $hit->significance ? $hit->significance :\n\t\t\t      (defined $hsps[0] ? $hsps[0]->evalue : ' ')) \n\t\t\t    );\n\t} else { \n\t    # failover to first HSP if the data does not contain a \n\t    # bitscore/significance value for the Hit (NCBI XML data for one)\n\n\t    $str .= sprintf('<tr><td>%s %s</td><td>%s</td><td><a href=\"#%s\">%.2g</a></td></tr>'.\"\\n\",\n\t\t\t    $url_desc, $descsub, \n\t\t\t    ($hit->bits ? $hit->bits : \n\t\t\t     (defined $hsps[0] ? $hsps[0]->bits : ' ')),\n\t\t\t    $acc,\n\t\t\t    ( $hit->significance ? $hit->significance :\n\t\t\t      (defined $hsps[0] ? $hsps[0]->evalue : ' ')) \n\t\t\t    );\n        my $dline = &{$self->hit_desc_line}($self, $hit, $result);\n\t    $hspstr .= \"<a name=\\\"$acc\\\">\\n\".\n\t\tsprintf(\"><b>%s</b> %s</br><dd>Length = %s</dd><p>\\n\\n\", $url_align, \n\t\t\t$dline , &_numwithcommas($hit->length));\n\t    my $ct = 0;\n\t    foreach my $hsp (@hsps ) {\n\t\tnext if( $hspfilter && ! &{$hspfilter}($hsp) );\n\t\t$hspstr .= sprintf(\" Score = %s bits (%s), Expect = %s\",\n\t\t\t\t   $hsp->bits || $hsp->score, \n\t\t\t\t   $hsp->score || $hsp->bits, \n\t\t\t\t   $hsp->evalue || '');\n\t\tif( defined $hsp->pvalue ) {\n\t\t    $hspstr .= \", P = \".$hsp->pvalue;\n\t\t}\n\t\t$hspstr .= \"<br>\\n\";\n\t\t$hspstr .= sprintf(\" Identities = %d/%d (%d%%)\",\n\t\t\t\t   ( $hsp->frac_identical('total') * \n\t\t\t\t     $hsp->length('total')),\n\t\t\t\t   $hsp->length('total'),\n\t\t\t\t   $hsp->frac_identical('total') * 100);\n\n\t\tif( $type eq 'PROTEIN' ) {\n\t\t    $hspstr .= sprintf(\", Positives = %d/%d (%d%%)\",\n\t\t\t\t       ( $hsp->frac_conserved('total') * \n\t\t\t\t\t $hsp->length('total')),\n\t\t\t\t       $hsp->length('total'),\n\t\t\t\t       $hsp->frac_conserved('total') * 100);\n\t\t}\n\t\tif( $hsp->gaps ) {\n\t\t    $hspstr .= sprintf(\", Gaps = %d/%d (%d%%)\",\n\t\t\t\t       $hsp->gaps('total'),\n\t\t\t\t       $hsp->length('total'),\n\t\t\t\t       (100 * $hsp->gaps('total') / \n\t\t\t\t\t$hsp->length('total')));\n\t\t}\n\n\t\tmy ($hframe,$qframe)   = ( $hsp->hit->frame, $hsp->query->frame);\n\t\tmy ($hstrand,$qstrand) = ($hsp->hit->strand,$hsp->query->strand);\n\t\t# so TBLASTX will have Query/Hit frames\n\t\t#    BLASTX  will have Query frame\n\t\t#    TBLASTN will have Hit frame\n\t\tif( $hstrand || $qstrand ) {\n\t\t    $hspstr .= \", Frame = \";\n\t\t    my ($signq, $signh);\n\t\t    unless( $hstrand ) {\n\t\t\t$hframe = undef;\n\t\t\t# if strand is null or 0 then it is protein\n\t\t\t# and this no frame\n\t\t    } else { \n\t\t\t$signh = $hstrand < 0 ? '-' : '+';\n\t\t    }\n\t\t    unless( $qstrand  ) {\n\t\t\t$qframe = undef;\n\t\t\t# if strand is null or 0 then it is protein\n\t\t    } else { \n\t\t\t$signq =$qstrand < 0 ? '-' : '+';\n\t\t    }\n\t\t    # remember bioperl stores frames as 0,1,2 (GFF way)\n\t\t    # BLAST reports reports as 1,2,3 so\n\t\t    # we have to add 1 to the frame values\n\t\t    if( defined $hframe && ! defined $qframe) {  \n\t\t\t$hspstr .= \"$signh\".($hframe+1);\n\t\t    } elsif( defined $qframe && ! defined $hframe) {  \n\t\t\t$hspstr .= \"$signq\".($qframe+1);\n\t\t    } else { \n\t\t\t$hspstr .= sprintf(\" %s%d / %s%d\",\n\t\t\t\t\t   $signq,$qframe+1,\n\t\t\t\t\t   $signh, $hframe+1);\n\t\t    }\n\t\t}\n\t\tif($links && \n\t\t   $hsp->can('links') && defined(my $lnks = $hsp->links) ) {\n\t\t    $hspstr .= sprintf(\"<br>\\nLinks = %s\\n\",$lnks);\n\t\t}\n\n\t\t$hspstr .= \"</a><p>\\n<pre>\";\n\n\t\tmy @hspvals = ( {'name' => 'Query:',\n\t\t\t\t 'seq'  => $hsp->query_string,\n\t\t\t\t 'start' => ($qstrand >= 0 ? \n\t\t\t\t\t     $hsp->query->start : \n\t\t\t\t\t     $hsp->query->end),\n\t\t\t\t\t     'end'   => ($qstrand >= 0 ? \n\t\t\t\t\t\t\t $hsp->query->end : \n\t\t\t\t\t\t\t $hsp->query->start),\n\t\t\t\t\t\t\t 'index' => 0,\n\t\t\t\t\t\t\t 'direction' => $qstrand || 1\n\t\t\t\t\t\t     },\n\t\t\t\t{ 'name' => ' 'x6,\n\t\t\t\t  'seq'  => $hsp->homology_string,\n\t\t\t\t  'start' => undef,\n\t\t\t\t  'end'   => undef,\n\t\t\t\t  'index' => 0,\n\t\t\t\t  'direction' => 1\n\t\t\t\t  },\n\t\t\t\t{ 'name'  => 'Sbjct:',\n\t\t\t\t  'seq'   => $hsp->hit_string,\n\t\t\t\t  'start' => ($hstrand >= 0 ? \n\t\t\t\t\t      $hsp->hit->start : \n\t\t\t\t\t      $hsp->hit->end),\n\t\t\t\t\t      'end'   => ($hstrand >= 0 ? \n\t\t\t\t\t\t\t  $hsp->hit->end : \n\t\t\t\t\t\t\t  $hsp->hit->start),\n\t\t\t\t\t\t\t  'index' => 0, \n\t\t\t\t\t\t\t  'direction' => $hstrand || 1\n\t\t\t\t\t\t      }\n\t\t\t\t);\t    \n\n\n\t\t# let's set the expected length (in chars) of the starting number\n\t\t# in an alignment block so we can have things line up\n\t\t# Just going to try and set to the largest\n\n\t\tmy ($numwidth) = sort { $b <=> $a }(length($hspvals[0]->{'start'}),\n\t\t\t\t\t\t    length($hspvals[0]->{'end'}),\n\t\t\t\t\t\t    length($hspvals[2]->{'start'}),\n\t\t\t\t\t\t    length($hspvals[2]->{'end'}));\n\t\tmy $count = 0;\n\t\twhile ( $count < $hsp->length('total') ) {\n\t\t    foreach my $v ( @hspvals ) {\n\t\t\tmy $piece = substr($v->{'seq'}, $v->{'index'} + $count,\n\t\t\t\t\t   $AlignmentLineWidth);\n\t\t\tmy $cp = $piece;\n\t\t\tmy $plen = scalar ( $cp =~ tr/\\-//);\n\t\t\tmy ($start,$end) = ('','');\n\t\t\tif( defined $v->{'start'} ) { \n\t\t\t    $start = $v->{'start'};\n\t\t\t    # since strand can be + or - use the direction\n\t\t\t    # to signify which whether to add or substract from end\n\t\t\t    my $d = $v->{'direction'} * ( $AlignmentLineWidth - $plen )*\n\t\t\t\t$baselens{$v->{'name'}};\n\t\t\t    if( length($piece) < $AlignmentLineWidth ) {\n\t\t\t\t$d = (length($piece) - $plen) * $v->{'direction'} * \n\t\t\t\t    $baselens{$v->{'name'}};\n\t\t\t    }\n\t\t\t    $end   = $v->{'start'} + $d - $v->{'direction'};\n\t\t\t    $v->{'start'} += $d;\n\t\t\t}\n\t\t\t$hspstr .= sprintf(\"%s %-\".$numwidth.\"s %s %s\\n\",\n\t\t\t\t\t   $v->{'name'},\n\t\t\t\t\t   $start,\n\t\t\t\t\t   $piece,\n\t\t\t\t\t   $end\n\t\t\t\t\t   );\n\t\t    }\n\t\t    $count += $AlignmentLineWidth;\n\t\t    $hspstr .= \"\\n\\n\";\n\t\t}\n\t\t$hspstr .= \"</pre>\\n\";\n\t    }\n\t}\n#\t$hspstr .= \"</pre>\\n\";\n    }\n\n    $str .= \"</table><p>\\n\".$hspstr;\n    my ($pav, $sav) = ($result->available_parameters, $result->available_statistics);\n    if ($pav || $sav) {\n        # make table of search statistics and end the web page\n        $str .= \"<p><p><hr><h2>Search Parameters</h2>\";\n        if ($pav) {\n        $str .= \"<table border=1><tr><th>Parameter</th><th>Value</th>\\n\";\n        foreach my $param ( sort $result->available_parameters ) {\n            $str .= \"<tr><td>$param</td><td>\". $result->get_parameter($param) .\"</td></tr>\\n\";\n        }\n        $str .= \"</table>\";\n        }\n        \n        if ($sav) {\n        $str .= \"<p><h2>Search Statistics</h2><table border=1><tr><th>Statistic</th><th>Value</th></tr>\\n\";\n        foreach my $stat ( sort $result->available_statistics ) {\n            $str .= \"<tr><td>$stat</td><td>\". $result->get_statistic($stat). \"</td>\\n\";\n        }\n        $str .=  \"</tr></table>\";\n        }\n    }\n    $str .= $self->footer() . \"<P>\\n\";\n    return $str;\n}\n\n=head2 hit_link_desc\n\n Title   : hit_link_desc\n Usage   : $self->hit_link_desc(\\&link_function);\n Function: Get/Set the function which provides an HTML \n           link(s) for the given hit to be used\n           within the description section at the top of the BLAST report.\n           This allows a person reading the report within\n           a web browser to go to one or more database entries for\n           the given hit from the description section.\n Returns : Function reference\n Args    : Function reference\n See Also: L<default_hit_link_desc()>\n\n\nsub hit_link_desc{\n    my( $self, $code ) = @_; \n    if ($code) {\n        $self->{'_hit_link_desc'} = $code;\n    }\n    return $self->{'_hit_link_desc'} || \\&default_hit_link_desc;\n}\n\n=head2 default_hit_link_desc\n\n Title   : default_hit_link_desc\n Usage   : $self->default_hit_link_desc($hit, $result)\n Function: Provides an HTML link(s) for the given hit to be used\n           within the description section at the top of the BLAST report.\n           This allows a person reading the report within\n           a web browser to go to one or more database entries for\n           the given hit from the description section.\n Returns : string containing HTML markup \"<a href...\")\n\n           The default implementation returns an HTML link to the\n           URL supplied by the remote_database_url() method\n           and using the identifier supplied by the id_parser() method.\n           It will use the NCBI GI if present, and the accession if not.\n\n Args    : First argument is a Bio::Search::Hit::HitI\n           Second argument is a Bio::Search::Result::ResultI\n\nSee Also: L<hit_link_align>, L<remote_database>, L<id_parser>\n\n\nsub default_hit_link_desc {\n    my($self, $hit, $result) = @_;\n    my $type = ( $result->algorithm =~ /(P|X|Y)$/i ) ? 'PROTEIN' : 'NUCLEOTIDE';\n    my ($gi,$acc) = &{$self->id_parser}($hit->name);\n\n    my $url = length($self->remote_database_url($type)) > 0 ? \n              sprintf('<a href=\"%s\">%s</a>',\n                      sprintf($self->remote_database_url($type),$gi || $acc), \n                      $hit->name()) :  $hit->name();\n\n    return $url;\n}\n\n\n=head2 hit_link_align\n\n Title   : hit_link_align\n Usage   : $self->hit_link_align(\\&link_function);\n Function: Get/Set the function which provides an HTML link(s) \n           for the given hit to be used\n           within the HSP alignment section of the BLAST report.\n           This allows a person reading the report within\n           a web browser to go to one or more database entries for\n           the given hit from the alignment section.\n Returns : string containing HTML markup \"<a href...\")\n\n           The default implementation delegates to hit_link_desc().\n\n Args    : First argument is a Bio::Search::Hit::HitI\n           Second argument is a Bio::Search::Result::ResultI\n\nSee Also: L<hit_link_desc>, L<remote_database>, L<id_parser>\n\n\nsub hit_link_align {\n    my ($self,$code) = @_;\n    if ($code) {\n        $self->{'_hit_link_align'} = $code;\n    }\n    return $self->{'_hit_link_align'} || \\&default_hit_link_desc;\n}\n\n=head2 hit_desc_line\n\n Title   : hit_desc_line\n Usage   : $self->hit_desc_line(\\&link_function);\n Function: Get/Set the function which provides HTML for the description\n           information from a hit. This allows one to parse\n           the rest of the description and split up lines, add links, etc.\n Returns : Function reference\n Args    : Function reference\n See Also: L<default_hit_link_desc()>\n\n\nsub hit_desc_line{\n    my( $self, $code ) = @_; \n    if ($code) {\n        $self->{'_hit_desc_line'} = $code;\n    }\n    return $self->{'_hit_desc_line'} || \\&default_hit_desc_line;\n}\n\n=head2 default_hit_desc_line\n\n Title   : default_hit_desc_line\n Usage   : $self->default_hit_desc_line($hit, $result)\n Function: Parses the description line information, splits based on the\n           hidden \\x01 between independent descriptions, checks the lines for\n           possible web links, and adds HTML link(s) for the given hit to be\n           used.\n\n Returns : string containing HTML markup \"<a href...\")\n           The default implementation returns an HTML link to the\n           URL supplied by the remote_database_url() method\n           and using the identifier supplied by the id_parser() method.\n           It will use the NCBI GI if present, and the accession if not.\n\n Args    : First argument is a Bio::Search::Hit::HitI\n           Second argument is a Bio::Search::Result::ResultI\n\nSee Also: L<hit_link_align>, L<remote_database>, L<id_parser>\n\n\nsub default_hit_desc_line {\n    my($self, $hit, $result) = @_;\n    my $type = ( $result->algorithm =~ /(P|X|Y)$/i ) ? 'PROTEIN' : 'NUCLEOTIDE';\n    my @descs = split /\\x01/, $hit->description;\n    #my $descline = join(\"</br>\",@descs).\"</br>\";\n    my $descline = '';\n    #return $descline;\n    for my $sec (@descs) {\n        my $url = '';\n        if ($sec =~ s/((?:gi\\|(\\d+)\\|)?        # optional GI\n                     (\\w+)\\|([A-Z\\d\\.\\_]+) # main \n                     (\\|[A-Z\\d\\_]+)?) # optional secondary ID//xms) {\n            my ($name, $gi, $db, $acc) = ($1, $2, $3, $4);\n            #$acc ||= ($rest) ? $rest : $gi;\n            $acc =~ s/^\\s+(\\S+)/$1/;\n            $acc =~ s/(\\S+)\\s+$/$1/;\n            $url =\n            length($self->remote_database_url($type)) > 0 ? \n              sprintf('<a href=\"%s\">%s</a> %s',\n                      sprintf($self->remote_database_url($type),\n                      $gi || $acc || $db), \n                      $name, $sec) :  $sec;\n        } else {\n            $url = $sec;\n        }\n        $descline .= \"$url</br>\\n\";\n    }\n    return $descline;\n}\n\n=head2 start_report\n\n  Title   : start_report\n  Usage   : $index->start_report( CODE )\n  Function: Stores or returns the code to\n            write the start of the <HTML> block, the <TITLE> block\n            and the start of the <BODY> block of HTML.   Useful\n            for (for instance) specifying alternative\n            HTML if you are embedding the output in\n            an HTML page which you have already started.\n            (For example a routine returning a null string).\n            Returns \\&default_start_report (see below) if not\n            set. \n  Example : $index->start_report( \\&my_start_report )\n  Returns : ref to CODE if called without arguments\n  Args    : CODE\n\n\nsub start_report {\n    my( $self, $code ) = @_; \n    if ($code) {\n        $self->{'_start_report'} = $code;\n    }\n    return $self->{'_start_report'} || \\&default_start_report;\n}\n\n=head2 default_start_report\n\n Title   : default_start_report\n Usage   : $self->default_start_report($result)\n Function: The default method to call when starting a report.\n Returns : sting\n Args    : First argument is a Bio::Search::Result::ResultI\n\n\nsub default_start_report {\n    my ($result) = @_;\n    return sprintf(\n    qq{<HTML>\n      <HEAD> <CENTER><TITLE>Bioperl Reformatted HTML of %s output with Bioperl Bio::SearchIO system</TITLE></CENTER></HEAD>\n      <!------------------------------------------------------------------->\n      <!-- Generated by Bio::SearchIO::Writer::HTMLResultWriter          -->\n      <!-- %s -->\n      <!-- http://bioperl.org                                            -->\n      <!------------------------------------------------------------------->\n      <BODY BGCOLOR=\"WHITE\">\n    },$result->algorithm,$Revision);\n    \n}\n\n=head2 title\n\n Title   : title\n Usage   : $self->title($CODE)\n\n  Function: Stores or returns the code to provide HTML for the given\n            BLAST report that will appear at the top of the BLAST report\n            HTML output.  Useful for (for instance) specifying\n            alternative routines to write your own titles.\n            Returns \\&default_title (see below) if not\n            set. \n  Example : $index->title( \\&my_title )\n  Returns : ref to CODE if called without arguments\n  Args    : CODE\n\n\nsub title {\n    my( $self, $code ) = @_; \n    if ($code) {\n        $self->{'_title'} = $code;\n    }\n    return $self->{'_title'} || \\&default_title;\n}\n\n=head2 default_title\n\n Title   : default_title\n Usage   : $self->default_title($result)\n Function: Provides HTML for the given BLAST report that will appear\n           at the top of the BLAST report HTML output.\n Returns : string containing HTML markup\n           The default implementation returns <CENTER> <H1> HTML\n           containing text such as:\n           \"Bioperl Reformatted HTML of BLASTP Search Report\n                     for gi|1786183|gb|AAC73113.1|\"\n Args    : First argument is a Bio::Search::Result::ResultI\n\n\nsub default_title {\n    my ($result) = @_;\n\n    return sprintf(\n        qq{<CENTER><H1><a href=\"http://bioperl.org\">Bioperl</a> Reformatted HTML of %s Search Report<br> for %s</H1></CENTER>},\n\t\t    $result->algorithm,\n\t\t    $result->query_name());\n}\n\n\n=head2 introduction\n\n Title   : introduction\n Usage   : $self->introduction($CODE)\n\n  Function: Stores or returns the code to provide HTML for the given\n            BLAST report detailing the query and the\n            database information.\n            Useful for (for instance) specifying\n            routines returning alternative introductions.\n            Returns \\&default_introduction (see below) if not\n            set. \n  Example : $index->introduction( \\&my_introduction )\n  Returns : ref to CODE if called without arguments\n  Args    : CODE","parameters":[{"label":"$self"},{"label":"$code"}],"label":"introduction($self,$code)"},"detail":"($self,$code)","name":"introduction","range":{"start":{"character":0,"line":775},"end":{"character":9999,"line":781}}},{"name":"default_introduction","line":780,"kind":12},{"kind":12,"line":795,"children":[{"line":796,"kind":13,"localvar":"my","name":"$result","definition":"my","containerName":"default_introduction"},{"kind":13,"line":806,"name":"$result","containerName":"default_introduction"},{"line":806,"kind":12,"containerName":"default_introduction","name":"query_name"},{"containerName":"default_introduction","name":"$result","kind":13,"line":807},{"line":807,"kind":12,"name":"query_description","containerName":"default_introduction"},{"kind":13,"line":808,"name":"$result","containerName":"default_introduction"},{"name":"query_length","containerName":"default_introduction","kind":12,"line":808},{"kind":13,"line":809,"name":"$result","containerName":"default_introduction"},{"name":"database_name","containerName":"default_introduction","kind":12,"line":809},{"name":"$result","containerName":"default_introduction","kind":13,"line":810},{"line":810,"kind":12,"name":"database_entries","containerName":"default_introduction"},{"kind":13,"line":811,"name":"$result","containerName":"default_introduction"},{"kind":12,"line":811,"containerName":"default_introduction","name":"database_letters"}],"containerName":"main::","definition":"sub","detail":"($result)","signature":{"label":"default_introduction($result)","parameters":[{"label":"$result"}],"documentation":"1;\n# $Id: HTMLResultWriter.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::Writer::HTMLResultWriter\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# Changes 2003-07-31 (jason)\n# Gary has cleaned up the code a lot to produce better looking HTML\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::Writer::HTMLResultWriter - write a Bio::Search::ResultI in HTML\n\n=head1 SYNOPSIS\n\n  use Bio::SearchIO;\n  use Bio::SearchIO::Writer::HTMLResultWriter;\n\n  my $in = Bio::SearchIO->new(-format => 'blast',\n\t\t\t     -file   => shift @ARGV);\n\n  my $writer = Bio::SearchIO::Writer::HTMLResultWriter->new();\n  my $out = Bio::SearchIO->new(-writer => $writer);\n  $out->write_result($in->next_result);\n\n\n  # to filter your output\n  my $MinLength = 100; # need a variable with scope outside the method\n  sub hsp_filter { \n      my $hsp = shift;\n      return 1 if $hsp->length('total') > $MinLength;\n  }\n  sub result_filter { \n      my $result = shift;\n      return $hsp->num_hits > 0;\n  }\n\n  my $writer = Bio::SearchIO::Writer::HTMLResultWriter->new\n                     (-filters => { 'HSP' => \\&hsp_filter} );\n  my $out = Bio::SearchIO->new(-writer => $writer);\n  $out->write_result($in->next_result);\n\n  # can also set the filter via the writer object\n  $writer->filter('RESULT', \\&result_filter);\n\n=head1 DESCRIPTION\n\nThis object implements the SearchWriterI interface which will produce\na set of HTML for a specific L<Bio::Search::Report::ReportI> interface.\n\nSee L<Bio::SearchIO::SearchWriterI> for more info on the filter method.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nGary Williams G.Williams@hgmp.mrc.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\npackage Bio::SearchIO::Writer::HTMLResultWriter;\nuse strict;\nuse vars qw(%RemoteURLDefault\n            $MaxDescLen $DATE $AlignmentLineWidth $Revision);\n\n# Object preamble - inherits from Bio::Root::RootI\n\nBEGIN {\n    $Revision = '$Id: HTMLResultWriter.pm 16123 2009-09-17 12:57:27Z cjfields $';\n    $DATE = localtime(time);\n    %RemoteURLDefault = ( \n      'PROTEIN' => 'http://www.ncbi.nlm.nih.gov/entrez/query.fcgi?db=protein&cmd=search&term=%s',\t\t\t  \n      'NUCLEOTIDE' => 'http://www.ncbi.nlm.nih.gov/entrez/query.fcgi?db=nucleotide&cmd=search&term=%s'\n    );\n    $MaxDescLen = 60;\n    $AlignmentLineWidth = 60;\n}\n\n\nuse base qw(Bio::Root::Root Bio::SearchIO::SearchWriterI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::Writer::HTMLResultWriter->new();\n Function: Builds a new Bio::SearchIO::Writer::HTMLResultWriter object \n Returns : Bio::SearchIO::Writer::HTMLResultWriter\n Args    : -filters => hashref with any or all of the keys (HSP HIT RESULT)\n           which have values pointing to a subroutine reference\n           which will expect to get a \n           -nucleotide_url => URL sprintf string base for the nt sequences\n           -protein_url => URL sprintf string base for the aa sequences\n           -no_wublastlinks => boolean. Do not display WU-BLAST lines \n                               even if they are parsed out.\n                               Links = (1) \n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($p,$n,$filters,\n      $nowublastlinks) = $self->_rearrange([qw(PROTEIN_URL \n\t\t\t\t\t       NUCLEOTIDE_URL \n\t\t\t\t\t       FILTERS\n\t\t\t\t\t       NO_WUBLASTLINKS)],@args);\n  $self->remote_database_url('p',$p || $RemoteURLDefault{'PROTEIN'});\n  $self->remote_database_url('n',$n || $RemoteURLDefault{'NUCLEOTIDE'});\n  $self->no_wublastlinks(! $nowublastlinks);\n  if( defined $filters ) {\n      if( !ref($filters) =~ /HASH/i ) { \n\t  $self->warn(\"Did not provide a hashref for the FILTERS option, ignoring.\");\n      } else { \n\t  while( my ($type,$code) = each %{$filters} ) {\n\t      $self->filter($type,$code);\n\t  }\n      }\n  }\n\n  return $self;\n}\n\n=head2 remote_database_url\n\n Title   : remote_database_url\n Usage   : $obj->remote_database_url($type,$newval)\n Function: This should return or set a string that contains a %s which can be\n           filled in with sprintf.\n Returns : value of remote_database_url\n Args    : $type - 'PROTEIN' or 'P' for protein URLS\n                   'NUCLEOTIDE' or 'N' for nucleotide URLS\n           $value - new value to set [optional]\n\n\n\nsub remote_database_url{\n   my ($self,$type,$value) = @_;\n   if( ! defined $type || $type !~ /^(P|N)/i ) { \n       $self->warn(\"Must provide a type (PROTEIN or NUCLEOTIDE)\");\n       return '';\n   }\n   $type = uc $1;\n   if( defined $value) {\n      $self->{'remote_database_url'}->{$type} = $value;\n    }\n   return $self->{'remote_database_url'}->{$type};\n}\n\n=head2 to_string\n\n Purpose   : Produces data for each Search::Result::ResultI in a string.\n           : This is an abstract method. For some useful implementations,\n           : see ResultTableWriter.pm, HitTableWriter.pm, \n           : and HSPTableWriter.pm.\n Usage     : print $writer->to_string( $result_obj, @args );\n Argument  : $result_obj = A Bio::Search::Result::ResultI object\n           : @args = any additional arguments used by your implementation.\n Returns   : String containing data for each search Result or any of its\n           : sub-objects (Hits and HSPs).\n Throws    : n/a\n\n\nsub to_string {\n    my ($self,$result,$num) = @_; \n    $num ||= 0;\n    return unless defined $result;\n    my $links = $self->no_wublastlinks;\n    my ($resultfilter,$hitfilter, $hspfilter) = ( $self->filter('RESULT'),\n\t\t\t\t\t\t  $self->filter('HIT'),\n\t\t\t\t\t\t  $self->filter('HSP') );\n    return '' if( defined $resultfilter && ! &{$resultfilter}($result) );    \n\n    my ($qtype,$dbtype,$dbseqtype,$type);\n    my $alg = $result->algorithm;\n    # This is actually wrong for the FASTAs I think\n    if(  $alg =~ /T(FAST|BLAST)([XY])/i ) {\n\t$qtype      = $dbtype = 'translated';\n\t$dbseqtype = $type       = 'PROTEIN';\n    } elsif( $alg =~ /T(FAST|BLAST)N/i ) {\n\t$qtype      = '';\n\t$dbtype     = 'translated';\n\t$type       = 'PROTEIN';\n\t$dbseqtype  = 'NUCLEOTIDE';\n    } elsif( $alg =~ /(FAST|BLAST)N/i || \n\t     $alg =~ /(WABA|EXONERATE)/i ) {\n\t$qtype      = $dbtype = '';\n\t$type = $dbseqtype  = 'NUCLEOTIDE';\n    } elsif( $alg =~ /(FAST|BLAST)P/  || \n\t     $alg =~ /SSEARCH|HMM(PFAM|SEARCH)/i ) {\n\t$qtype      = $dbtype = '';\n\t$type = $dbseqtype  = 'PROTEIN';\n    } elsif( $alg =~ /(FAST|BLAST)[XY]/i ) {\n\t$qtype      = 'translated';\n        $dbtype     = 'PROTEIN';\n\t$dbseqtype  = $type      = 'PROTEIN';\n    } else { \n\t$self->warn(\"algorithm was \", $result->algorithm, \" couldn't match\\n\");\n    }\n    \n    \n    my %baselens = ( 'Sbjct:'   => ( $dbtype eq 'translated' )  ? 3 : 1,\n\t\t     'Query:'   => ( $qtype  eq 'translated' )  ? 3 : 1);\n\n    my $str;\n    if( $num <= 1 ) { \n\t$str = &{$self->start_report}($result);\n    }\n\n    $str .= &{$self->title}($result);\n\n    $str .= $result->algorithm_reference || $self->algorithm_reference($result);\n    $str .= &{$self->introduction}($result);\n\n    $str .= \"<table border=0>\n            <tr><th>Sequences producing significant alignments:</th>\n            <th>Score<br>(bits)</th><th>E<br>value</th></tr>\";\n\n    my $hspstr = '<p><p>';\n    if( $result->can('rewind')) {\n        $result->rewind(); # support stream based parsing routines\n    }\n\n    while( my $hit = $result->next_hit ) {\n\tnext if( $hitfilter && ! &{$hitfilter}($hit) );\n\tmy $nm = $hit->name();\n\t\n\t$self->debug( \"no $nm for name (\".$hit->description(). \"\\n\") \n\t    unless $nm;\n\tmy ($gi,$acc) = &{$self->id_parser}($nm);\n\tmy $p = \"%-$MaxDescLen\". \"s\";\n\tmy $descsub;\n\tif( length($hit->description) > ($MaxDescLen - 3) ) {\n\t    $descsub = sprintf($p,\n\t\tsubstr($hit->description,0,$MaxDescLen-3) . \"...\");\n\t} else { \n\t    $descsub = sprintf($p,$hit->description);\n\t}\n\n\tmy $url_desc  = &{$self->hit_link_desc()}($self,$hit, $result);\n\tmy $url_align = &{$self->hit_link_align()}($self,$hit, $result);\n\n\tmy @hsps = $hit->hsps;\n\t\n\tif( ! @hsps ) {\n\t    # no HSPs so no link \n\t    $str .= sprintf('<tr><td>%s %s</td><td>%s</td><td>%.2g</td></tr>'.\"\\n\",\n\t\t\t    $url_desc, $descsub, \n\t\t\t    ($hit->bits ? $hit->bits : \n\t\t\t     (defined $hsps[0] ? $hsps[0]->bits : ' ')),\n\t\t\t    ( $hit->significance ? $hit->significance :\n\t\t\t      (defined $hsps[0] ? $hsps[0]->evalue : ' ')) \n\t\t\t    );\n\t} else { \n\t    # failover to first HSP if the data does not contain a \n\t    # bitscore/significance value for the Hit (NCBI XML data for one)\n\n\t    $str .= sprintf('<tr><td>%s %s</td><td>%s</td><td><a href=\"#%s\">%.2g</a></td></tr>'.\"\\n\",\n\t\t\t    $url_desc, $descsub, \n\t\t\t    ($hit->bits ? $hit->bits : \n\t\t\t     (defined $hsps[0] ? $hsps[0]->bits : ' ')),\n\t\t\t    $acc,\n\t\t\t    ( $hit->significance ? $hit->significance :\n\t\t\t      (defined $hsps[0] ? $hsps[0]->evalue : ' ')) \n\t\t\t    );\n        my $dline = &{$self->hit_desc_line}($self, $hit, $result);\n\t    $hspstr .= \"<a name=\\\"$acc\\\">\\n\".\n\t\tsprintf(\"><b>%s</b> %s</br><dd>Length = %s</dd><p>\\n\\n\", $url_align, \n\t\t\t$dline , &_numwithcommas($hit->length));\n\t    my $ct = 0;\n\t    foreach my $hsp (@hsps ) {\n\t\tnext if( $hspfilter && ! &{$hspfilter}($hsp) );\n\t\t$hspstr .= sprintf(\" Score = %s bits (%s), Expect = %s\",\n\t\t\t\t   $hsp->bits || $hsp->score, \n\t\t\t\t   $hsp->score || $hsp->bits, \n\t\t\t\t   $hsp->evalue || '');\n\t\tif( defined $hsp->pvalue ) {\n\t\t    $hspstr .= \", P = \".$hsp->pvalue;\n\t\t}\n\t\t$hspstr .= \"<br>\\n\";\n\t\t$hspstr .= sprintf(\" Identities = %d/%d (%d%%)\",\n\t\t\t\t   ( $hsp->frac_identical('total') * \n\t\t\t\t     $hsp->length('total')),\n\t\t\t\t   $hsp->length('total'),\n\t\t\t\t   $hsp->frac_identical('total') * 100);\n\n\t\tif( $type eq 'PROTEIN' ) {\n\t\t    $hspstr .= sprintf(\", Positives = %d/%d (%d%%)\",\n\t\t\t\t       ( $hsp->frac_conserved('total') * \n\t\t\t\t\t $hsp->length('total')),\n\t\t\t\t       $hsp->length('total'),\n\t\t\t\t       $hsp->frac_conserved('total') * 100);\n\t\t}\n\t\tif( $hsp->gaps ) {\n\t\t    $hspstr .= sprintf(\", Gaps = %d/%d (%d%%)\",\n\t\t\t\t       $hsp->gaps('total'),\n\t\t\t\t       $hsp->length('total'),\n\t\t\t\t       (100 * $hsp->gaps('total') / \n\t\t\t\t\t$hsp->length('total')));\n\t\t}\n\n\t\tmy ($hframe,$qframe)   = ( $hsp->hit->frame, $hsp->query->frame);\n\t\tmy ($hstrand,$qstrand) = ($hsp->hit->strand,$hsp->query->strand);\n\t\t# so TBLASTX will have Query/Hit frames\n\t\t#    BLASTX  will have Query frame\n\t\t#    TBLASTN will have Hit frame\n\t\tif( $hstrand || $qstrand ) {\n\t\t    $hspstr .= \", Frame = \";\n\t\t    my ($signq, $signh);\n\t\t    unless( $hstrand ) {\n\t\t\t$hframe = undef;\n\t\t\t# if strand is null or 0 then it is protein\n\t\t\t# and this no frame\n\t\t    } else { \n\t\t\t$signh = $hstrand < 0 ? '-' : '+';\n\t\t    }\n\t\t    unless( $qstrand  ) {\n\t\t\t$qframe = undef;\n\t\t\t# if strand is null or 0 then it is protein\n\t\t    } else { \n\t\t\t$signq =$qstrand < 0 ? '-' : '+';\n\t\t    }\n\t\t    # remember bioperl stores frames as 0,1,2 (GFF way)\n\t\t    # BLAST reports reports as 1,2,3 so\n\t\t    # we have to add 1 to the frame values\n\t\t    if( defined $hframe && ! defined $qframe) {  \n\t\t\t$hspstr .= \"$signh\".($hframe+1);\n\t\t    } elsif( defined $qframe && ! defined $hframe) {  \n\t\t\t$hspstr .= \"$signq\".($qframe+1);\n\t\t    } else { \n\t\t\t$hspstr .= sprintf(\" %s%d / %s%d\",\n\t\t\t\t\t   $signq,$qframe+1,\n\t\t\t\t\t   $signh, $hframe+1);\n\t\t    }\n\t\t}\n\t\tif($links && \n\t\t   $hsp->can('links') && defined(my $lnks = $hsp->links) ) {\n\t\t    $hspstr .= sprintf(\"<br>\\nLinks = %s\\n\",$lnks);\n\t\t}\n\n\t\t$hspstr .= \"</a><p>\\n<pre>\";\n\n\t\tmy @hspvals = ( {'name' => 'Query:',\n\t\t\t\t 'seq'  => $hsp->query_string,\n\t\t\t\t 'start' => ($qstrand >= 0 ? \n\t\t\t\t\t     $hsp->query->start : \n\t\t\t\t\t     $hsp->query->end),\n\t\t\t\t\t     'end'   => ($qstrand >= 0 ? \n\t\t\t\t\t\t\t $hsp->query->end : \n\t\t\t\t\t\t\t $hsp->query->start),\n\t\t\t\t\t\t\t 'index' => 0,\n\t\t\t\t\t\t\t 'direction' => $qstrand || 1\n\t\t\t\t\t\t     },\n\t\t\t\t{ 'name' => ' 'x6,\n\t\t\t\t  'seq'  => $hsp->homology_string,\n\t\t\t\t  'start' => undef,\n\t\t\t\t  'end'   => undef,\n\t\t\t\t  'index' => 0,\n\t\t\t\t  'direction' => 1\n\t\t\t\t  },\n\t\t\t\t{ 'name'  => 'Sbjct:',\n\t\t\t\t  'seq'   => $hsp->hit_string,\n\t\t\t\t  'start' => ($hstrand >= 0 ? \n\t\t\t\t\t      $hsp->hit->start : \n\t\t\t\t\t      $hsp->hit->end),\n\t\t\t\t\t      'end'   => ($hstrand >= 0 ? \n\t\t\t\t\t\t\t  $hsp->hit->end : \n\t\t\t\t\t\t\t  $hsp->hit->start),\n\t\t\t\t\t\t\t  'index' => 0, \n\t\t\t\t\t\t\t  'direction' => $hstrand || 1\n\t\t\t\t\t\t      }\n\t\t\t\t);\t    \n\n\n\t\t# let's set the expected length (in chars) of the starting number\n\t\t# in an alignment block so we can have things line up\n\t\t# Just going to try and set to the largest\n\n\t\tmy ($numwidth) = sort { $b <=> $a }(length($hspvals[0]->{'start'}),\n\t\t\t\t\t\t    length($hspvals[0]->{'end'}),\n\t\t\t\t\t\t    length($hspvals[2]->{'start'}),\n\t\t\t\t\t\t    length($hspvals[2]->{'end'}));\n\t\tmy $count = 0;\n\t\twhile ( $count < $hsp->length('total') ) {\n\t\t    foreach my $v ( @hspvals ) {\n\t\t\tmy $piece = substr($v->{'seq'}, $v->{'index'} + $count,\n\t\t\t\t\t   $AlignmentLineWidth);\n\t\t\tmy $cp = $piece;\n\t\t\tmy $plen = scalar ( $cp =~ tr/\\-//);\n\t\t\tmy ($start,$end) = ('','');\n\t\t\tif( defined $v->{'start'} ) { \n\t\t\t    $start = $v->{'start'};\n\t\t\t    # since strand can be + or - use the direction\n\t\t\t    # to signify which whether to add or substract from end\n\t\t\t    my $d = $v->{'direction'} * ( $AlignmentLineWidth - $plen )*\n\t\t\t\t$baselens{$v->{'name'}};\n\t\t\t    if( length($piece) < $AlignmentLineWidth ) {\n\t\t\t\t$d = (length($piece) - $plen) * $v->{'direction'} * \n\t\t\t\t    $baselens{$v->{'name'}};\n\t\t\t    }\n\t\t\t    $end   = $v->{'start'} + $d - $v->{'direction'};\n\t\t\t    $v->{'start'} += $d;\n\t\t\t}\n\t\t\t$hspstr .= sprintf(\"%s %-\".$numwidth.\"s %s %s\\n\",\n\t\t\t\t\t   $v->{'name'},\n\t\t\t\t\t   $start,\n\t\t\t\t\t   $piece,\n\t\t\t\t\t   $end\n\t\t\t\t\t   );\n\t\t    }\n\t\t    $count += $AlignmentLineWidth;\n\t\t    $hspstr .= \"\\n\\n\";\n\t\t}\n\t\t$hspstr .= \"</pre>\\n\";\n\t    }\n\t}\n#\t$hspstr .= \"</pre>\\n\";\n    }\n\n    $str .= \"</table><p>\\n\".$hspstr;\n    my ($pav, $sav) = ($result->available_parameters, $result->available_statistics);\n    if ($pav || $sav) {\n        # make table of search statistics and end the web page\n        $str .= \"<p><p><hr><h2>Search Parameters</h2>\";\n        if ($pav) {\n        $str .= \"<table border=1><tr><th>Parameter</th><th>Value</th>\\n\";\n        foreach my $param ( sort $result->available_parameters ) {\n            $str .= \"<tr><td>$param</td><td>\". $result->get_parameter($param) .\"</td></tr>\\n\";\n        }\n        $str .= \"</table>\";\n        }\n        \n        if ($sav) {\n        $str .= \"<p><h2>Search Statistics</h2><table border=1><tr><th>Statistic</th><th>Value</th></tr>\\n\";\n        foreach my $stat ( sort $result->available_statistics ) {\n            $str .= \"<tr><td>$stat</td><td>\". $result->get_statistic($stat). \"</td>\\n\";\n        }\n        $str .=  \"</tr></table>\";\n        }\n    }\n    $str .= $self->footer() . \"<P>\\n\";\n    return $str;\n}\n\n=head2 hit_link_desc\n\n Title   : hit_link_desc\n Usage   : $self->hit_link_desc(\\&link_function);\n Function: Get/Set the function which provides an HTML \n           link(s) for the given hit to be used\n           within the description section at the top of the BLAST report.\n           This allows a person reading the report within\n           a web browser to go to one or more database entries for\n           the given hit from the description section.\n Returns : Function reference\n Args    : Function reference\n See Also: L<default_hit_link_desc()>\n\n\nsub hit_link_desc{\n    my( $self, $code ) = @_; \n    if ($code) {\n        $self->{'_hit_link_desc'} = $code;\n    }\n    return $self->{'_hit_link_desc'} || \\&default_hit_link_desc;\n}\n\n=head2 default_hit_link_desc\n\n Title   : default_hit_link_desc\n Usage   : $self->default_hit_link_desc($hit, $result)\n Function: Provides an HTML link(s) for the given hit to be used\n           within the description section at the top of the BLAST report.\n           This allows a person reading the report within\n           a web browser to go to one or more database entries for\n           the given hit from the description section.\n Returns : string containing HTML markup \"<a href...\")\n\n           The default implementation returns an HTML link to the\n           URL supplied by the remote_database_url() method\n           and using the identifier supplied by the id_parser() method.\n           It will use the NCBI GI if present, and the accession if not.\n\n Args    : First argument is a Bio::Search::Hit::HitI\n           Second argument is a Bio::Search::Result::ResultI\n\nSee Also: L<hit_link_align>, L<remote_database>, L<id_parser>\n\n\nsub default_hit_link_desc {\n    my($self, $hit, $result) = @_;\n    my $type = ( $result->algorithm =~ /(P|X|Y)$/i ) ? 'PROTEIN' : 'NUCLEOTIDE';\n    my ($gi,$acc) = &{$self->id_parser}($hit->name);\n\n    my $url = length($self->remote_database_url($type)) > 0 ? \n              sprintf('<a href=\"%s\">%s</a>',\n                      sprintf($self->remote_database_url($type),$gi || $acc), \n                      $hit->name()) :  $hit->name();\n\n    return $url;\n}\n\n\n=head2 hit_link_align\n\n Title   : hit_link_align\n Usage   : $self->hit_link_align(\\&link_function);\n Function: Get/Set the function which provides an HTML link(s) \n           for the given hit to be used\n           within the HSP alignment section of the BLAST report.\n           This allows a person reading the report within\n           a web browser to go to one or more database entries for\n           the given hit from the alignment section.\n Returns : string containing HTML markup \"<a href...\")\n\n           The default implementation delegates to hit_link_desc().\n\n Args    : First argument is a Bio::Search::Hit::HitI\n           Second argument is a Bio::Search::Result::ResultI\n\nSee Also: L<hit_link_desc>, L<remote_database>, L<id_parser>\n\n\nsub hit_link_align {\n    my ($self,$code) = @_;\n    if ($code) {\n        $self->{'_hit_link_align'} = $code;\n    }\n    return $self->{'_hit_link_align'} || \\&default_hit_link_desc;\n}\n\n=head2 hit_desc_line\n\n Title   : hit_desc_line\n Usage   : $self->hit_desc_line(\\&link_function);\n Function: Get/Set the function which provides HTML for the description\n           information from a hit. This allows one to parse\n           the rest of the description and split up lines, add links, etc.\n Returns : Function reference\n Args    : Function reference\n See Also: L<default_hit_link_desc()>\n\n\nsub hit_desc_line{\n    my( $self, $code ) = @_; \n    if ($code) {\n        $self->{'_hit_desc_line'} = $code;\n    }\n    return $self->{'_hit_desc_line'} || \\&default_hit_desc_line;\n}\n\n=head2 default_hit_desc_line\n\n Title   : default_hit_desc_line\n Usage   : $self->default_hit_desc_line($hit, $result)\n Function: Parses the description line information, splits based on the\n           hidden \\x01 between independent descriptions, checks the lines for\n           possible web links, and adds HTML link(s) for the given hit to be\n           used.\n\n Returns : string containing HTML markup \"<a href...\")\n           The default implementation returns an HTML link to the\n           URL supplied by the remote_database_url() method\n           and using the identifier supplied by the id_parser() method.\n           It will use the NCBI GI if present, and the accession if not.\n\n Args    : First argument is a Bio::Search::Hit::HitI\n           Second argument is a Bio::Search::Result::ResultI\n\nSee Also: L<hit_link_align>, L<remote_database>, L<id_parser>\n\n\nsub default_hit_desc_line {\n    my($self, $hit, $result) = @_;\n    my $type = ( $result->algorithm =~ /(P|X|Y)$/i ) ? 'PROTEIN' : 'NUCLEOTIDE';\n    my @descs = split /\\x01/, $hit->description;\n    #my $descline = join(\"</br>\",@descs).\"</br>\";\n    my $descline = '';\n    #return $descline;\n    for my $sec (@descs) {\n        my $url = '';\n        if ($sec =~ s/((?:gi\\|(\\d+)\\|)?        # optional GI\n                     (\\w+)\\|([A-Z\\d\\.\\_]+) # main \n                     (\\|[A-Z\\d\\_]+)?) # optional secondary ID//xms) {\n            my ($name, $gi, $db, $acc) = ($1, $2, $3, $4);\n            #$acc ||= ($rest) ? $rest : $gi;\n            $acc =~ s/^\\s+(\\S+)/$1/;\n            $acc =~ s/(\\S+)\\s+$/$1/;\n            $url =\n            length($self->remote_database_url($type)) > 0 ? \n              sprintf('<a href=\"%s\">%s</a> %s',\n                      sprintf($self->remote_database_url($type),\n                      $gi || $acc || $db), \n                      $name, $sec) :  $sec;\n        } else {\n            $url = $sec;\n        }\n        $descline .= \"$url</br>\\n\";\n    }\n    return $descline;\n}\n\n=head2 start_report\n\n  Title   : start_report\n  Usage   : $index->start_report( CODE )\n  Function: Stores or returns the code to\n            write the start of the <HTML> block, the <TITLE> block\n            and the start of the <BODY> block of HTML.   Useful\n            for (for instance) specifying alternative\n            HTML if you are embedding the output in\n            an HTML page which you have already started.\n            (For example a routine returning a null string).\n            Returns \\&default_start_report (see below) if not\n            set. \n  Example : $index->start_report( \\&my_start_report )\n  Returns : ref to CODE if called without arguments\n  Args    : CODE\n\n\nsub start_report {\n    my( $self, $code ) = @_; \n    if ($code) {\n        $self->{'_start_report'} = $code;\n    }\n    return $self->{'_start_report'} || \\&default_start_report;\n}\n\n=head2 default_start_report\n\n Title   : default_start_report\n Usage   : $self->default_start_report($result)\n Function: The default method to call when starting a report.\n Returns : sting\n Args    : First argument is a Bio::Search::Result::ResultI\n\n\nsub default_start_report {\n    my ($result) = @_;\n    return sprintf(\n    qq{<HTML>\n      <HEAD> <CENTER><TITLE>Bioperl Reformatted HTML of %s output with Bioperl Bio::SearchIO system</TITLE></CENTER></HEAD>\n      <!------------------------------------------------------------------->\n      <!-- Generated by Bio::SearchIO::Writer::HTMLResultWriter          -->\n      <!-- %s -->\n      <!-- http://bioperl.org                                            -->\n      <!------------------------------------------------------------------->\n      <BODY BGCOLOR=\"WHITE\">\n    },$result->algorithm,$Revision);\n    \n}\n\n=head2 title\n\n Title   : title\n Usage   : $self->title($CODE)\n\n  Function: Stores or returns the code to provide HTML for the given\n            BLAST report that will appear at the top of the BLAST report\n            HTML output.  Useful for (for instance) specifying\n            alternative routines to write your own titles.\n            Returns \\&default_title (see below) if not\n            set. \n  Example : $index->title( \\&my_title )\n  Returns : ref to CODE if called without arguments\n  Args    : CODE\n\n\nsub title {\n    my( $self, $code ) = @_; \n    if ($code) {\n        $self->{'_title'} = $code;\n    }\n    return $self->{'_title'} || \\&default_title;\n}\n\n=head2 default_title\n\n Title   : default_title\n Usage   : $self->default_title($result)\n Function: Provides HTML for the given BLAST report that will appear\n           at the top of the BLAST report HTML output.\n Returns : string containing HTML markup\n           The default implementation returns <CENTER> <H1> HTML\n           containing text such as:\n           \"Bioperl Reformatted HTML of BLASTP Search Report\n                     for gi|1786183|gb|AAC73113.1|\"\n Args    : First argument is a Bio::Search::Result::ResultI\n\n\nsub default_title {\n    my ($result) = @_;\n\n    return sprintf(\n        qq{<CENTER><H1><a href=\"http://bioperl.org\">Bioperl</a> Reformatted HTML of %s Search Report<br> for %s</H1></CENTER>},\n\t\t    $result->algorithm,\n\t\t    $result->query_name());\n}\n\n\n=head2 introduction\n\n Title   : introduction\n Usage   : $self->introduction($CODE)\n\n  Function: Stores or returns the code to provide HTML for the given\n            BLAST report detailing the query and the\n            database information.\n            Useful for (for instance) specifying\n            routines returning alternative introductions.\n            Returns \\&default_introduction (see below) if not\n            set. \n  Example : $index->introduction( \\&my_introduction )\n  Returns : ref to CODE if called without arguments\n  Args    : CODE\n\n\nsub introduction {\n    my( $self, $code ) = @_; \n    if ($code) {\n        $self->{'_introduction'} = $code;\n    }\n    return $self->{'_introduction'} || \\&default_introduction;\n}\n\n=head2 default_introduction\n\n Title   : default_introduction\n Usage   : $self->default_introduction($result)\n Function: Outputs HTML to provide the query\n           and the database information\n Returns : string containing HTML\n Args    : First argument is a Bio::Search::Result::ResultI\n           Second argument is string holding literature citation"},"name":"default_introduction","range":{"start":{"character":0,"line":795},"end":{"line":813,"character":9999}}},{"line":808,"kind":12,"name":"_numwithcommas"},{"kind":12,"line":810,"name":"_numwithcommas"},{"kind":12,"line":811,"name":"_numwithcommas"},{"definition":"sub","name":"end_report","containerName":"main::","range":{"start":{"line":828,"character":0},"end":{"line":830,"character":9999}},"kind":12,"children":[],"line":828},{"containerName":"main::","definition":"sub","detail":"($self,$code)","signature":{"documentation":"","parameters":[{"label":"$self"},{"label":"$code"}],"label":"id_parser($self,$code)"},"kind":12,"line":854,"children":[{"kind":13,"line":855,"definition":"my","name":"$self","containerName":"id_parser","localvar":"my"},{"line":855,"kind":13,"containerName":"id_parser","name":"$code"},{"name":"$code","containerName":"id_parser","line":857,"kind":13},{"kind":13,"line":858,"name":"$self","containerName":"id_parser"},{"name":"$code","containerName":"id_parser","line":858,"kind":13},{"name":"$self","containerName":"id_parser","line":860,"kind":13}],"name":"id_parser","range":{"start":{"line":854,"character":0},"end":{"character":9999,"line":861}}},{"line":860,"kind":12,"name":"default_id_parser"},{"kind":12,"children":[{"definition":"my","name":"$string","containerName":"default_id_parser","localvar":"my","kind":13,"line":882},{"line":883,"kind":13,"localvar":"my","containerName":"default_id_parser","definition":"my","name":"$gi"},{"kind":13,"line":883,"containerName":"default_id_parser","name":"$acc"},{"kind":13,"line":884,"containerName":"default_id_parser","name":"$string"},{"line":885,"kind":13,"name":"$gi","containerName":"default_id_parser"},{"kind":13,"line":885,"name":"$acc","containerName":"default_id_parser"},{"line":887,"kind":13,"name":"$string","containerName":"default_id_parser"},{"containerName":"default_id_parser","name":"$acc","line":888,"kind":13},{"line":890,"kind":13,"name":"$acc","containerName":"default_id_parser"},{"containerName":"default_id_parser","name":"$string","kind":13,"line":890},{"containerName":"default_id_parser","name":"$acc","line":891,"kind":13},{"name":"$acc","containerName":"default_id_parser","kind":13,"line":892},{"kind":13,"line":894,"name":"$gi","containerName":"default_id_parser"},{"name":"$acc","containerName":"default_id_parser","kind":13,"line":894}],"line":881,"definition":"sub","containerName":"main::","signature":{"label":"default_id_parser($string)","documentation":"","parameters":[{"label":"$string"}]},"detail":"($string)","name":"default_id_parser","range":{"start":{"line":881,"character":0},"end":{"line":895,"character":9999}}},{"children":[{"name":"$a","containerName":"MIN","line":897,"kind":13},{"containerName":"MIN","name":"$b","line":897,"kind":13},{"line":897,"kind":13,"containerName":"MIN","name":"$a"},{"containerName":"MIN","name":"$b","line":897,"kind":13}],"line":897,"kind":12,"range":{"start":{"character":0,"line":897},"end":{"character":9999,"line":897}},"definition":"sub","name":"MIN","containerName":"main::"},{"definition":"sub","name":"MAX","containerName":"main::","range":{"start":{"character":0,"line":898},"end":{"line":898,"character":9999}},"kind":12,"children":[{"line":898,"kind":13,"name":"$a","containerName":"MAX"},{"line":898,"kind":13,"name":"$b","containerName":"MAX"},{"containerName":"MAX","name":"$b","line":898,"kind":13},{"line":898,"kind":13,"containerName":"MAX","name":"$a"}],"line":898},{"children":[{"line":901,"kind":13,"localvar":"my","containerName":"footer","name":"$self","definition":"my"},{"line":902,"kind":13,"name":"$self","containerName":"footer"}],"line":900,"kind":12,"signature":{"label":"footer($self)","documentation":"","parameters":[{"label":"$self"}]},"detail":"($self)","definition":"sub","containerName":"main::","range":{"start":{"character":0,"line":900},"end":{"line":904,"character":9999}},"name":"footer"},{"children":[{"name":"$self","definition":"my","containerName":"algorithm_reference","localvar":"my","kind":13,"line":919},{"name":"$result","containerName":"algorithm_reference","kind":13,"line":919},{"name":"$result","containerName":"algorithm_reference","kind":13,"line":920},{"name":"$result","containerName":"algorithm_reference","line":920,"kind":13},{"containerName":"algorithm_reference","name":"$result","line":921,"kind":13},{"line":921,"kind":12,"containerName":"algorithm_reference","name":"isa"},{"line":922,"kind":13,"name":"$result","containerName":"algorithm_reference"},{"line":922,"kind":12,"name":"algorithm","containerName":"algorithm_reference"},{"localvar":"my","name":"$res","definition":"my","containerName":"algorithm_reference","line":923,"kind":13},{"kind":13,"line":923,"name":"$result","containerName":"algorithm_reference"},{"name":"algorithm","containerName":"algorithm_reference","kind":12,"line":923},{"name":"$result","containerName":"algorithm_reference","kind":13,"line":923},{"line":923,"kind":12,"containerName":"algorithm_reference","name":"algorithm_version"},{"name":"$result","containerName":"algorithm_reference","line":924,"kind":13},{"name":"algorithm_version","containerName":"algorithm_reference","line":924,"kind":12},{"kind":13,"line":925,"name":"$res","containerName":"algorithm_reference"},{"kind":13,"line":930,"containerName":"algorithm_reference","name":"$res"},{"name":"$result","containerName":"algorithm_reference","line":937,"kind":13},{"containerName":"algorithm_reference","name":"algorithm","line":937,"kind":12},{"containerName":"algorithm_reference","name":"$result","kind":13,"line":938},{"kind":12,"line":938,"name":"algorithm","containerName":"algorithm_reference"},{"name":"$result","containerName":"algorithm_reference","line":938,"kind":13},{"name":"algorithm_version","containerName":"algorithm_reference","line":938,"kind":12}],"line":918,"kind":12,"signature":{"label":"algorithm_reference($self,$result)","parameters":[{"label":"$self"},{"label":"$result"}],"documentation":""},"detail":"($self,$result)","definition":"sub","containerName":"main::","range":{"start":{"line":918,"character":0},"end":{"character":9999,"line":943}},"name":"algorithm_reference"},{"kind":12,"line":946,"children":[{"line":947,"kind":13,"localvar":"my","containerName":"_numwithcommas","name":"$num","definition":"my"},{"name":"$num","containerName":"_numwithcommas","kind":13,"line":948},{"containerName":"_numwithcommas","name":"$num","kind":13,"line":949}],"containerName":"main::","definition":"sub","name":"_numwithcommas","range":{"end":{"line":950,"character":9999},"start":{"line":946,"character":0}}},{"line":982,"children":[{"name":"$self","definition":"my","containerName":"no_wublastlinks","localvar":"my","kind":13,"line":983},{"containerName":"no_wublastlinks","name":"$self","kind":13,"line":985},{"name":"$self","containerName":"no_wublastlinks","kind":13,"line":986}],"kind":12,"range":{"end":{"line":987,"character":9999},"start":{"character":0,"line":982}},"containerName":"main::","name":"no_wublastlinks","definition":"sub"}],"version":5}