{"vars":[{"containerName":"","name":"base","line":84,"kind":2},{"name":"new","range":{"end":{"line":103,"character":9999},"start":{"line":98,"character":0}},"definition":"sub","containerName":"main::","signature":{"label":"new($class,@args)","parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: BSMLResultWriter.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::Writer::BSMLResultWriter\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::Writer::BSMLResultWriter - BSML output writer\n\n=head1 SYNOPSIS\n\n  use Bio::SearchIO;\n  my $in = Bio::SearchIO->new(-file   => 'result.blast',\n                             -format => 'blast');\n  my $out = Bio::SearchIO->new(-output_format  => 'BSMLResultWriter',\n                              -file           => \">result.bsml\");\n  while( my $r = $in->next_result ) {\n    $out->write_result($r);\n  }\n\n=head1 DESCRIPTION\n\nThis is a writer to produce BSML for a search result.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::Writer::BSMLResultWriter;\nuse strict;\n\nuse XML::Writer;\nuse IO::String;\n\nuse base qw(Bio::Root::Root Bio::SearchIO::SearchWriterI);\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::Writer::BSMLResultWriter->new();\n Function: Builds a new Bio::SearchIO::Writer::BSMLResultWriter object \n Returns : an instance of Bio::SearchIO::Writer::BSMLResultWriter\n Args    :"},"detail":"($class,@args)","kind":12,"children":[{"line":99,"kind":13,"localvar":"my","name":"$class","definition":"my","containerName":"new"},{"name":"@args","containerName":"new","line":99,"kind":13},{"localvar":"my","name":"$self","definition":"my","containerName":"new","line":101,"kind":13},{"kind":13,"line":101,"containerName":"new","name":"$class"},{"kind":13,"line":101,"containerName":"new","name":"@args"},{"line":102,"kind":13,"name":"$self","containerName":"new"}],"line":98},{"kind":12,"line":101,"containerName":"new","name":"SUPER"},{"name":"to_string","range":{"end":{"character":9999,"line":352},"start":{"character":0,"line":123}},"kind":12,"line":123,"children":[{"line":124,"kind":13,"localvar":"my","containerName":"to_string","definition":"my","name":"$self"},{"kind":13,"line":124,"name":"$result","containerName":"to_string"},{"name":"$num","containerName":"to_string","line":124,"kind":13},{"line":125,"kind":13,"localvar":"my","name":"$str","definition":"my","containerName":"to_string"},{"line":126,"kind":13,"localvar":"my","containerName":"to_string","definition":"my","name":"$writer"},{"kind":13,"line":126,"name":"$str","containerName":"to_string"},{"line":129,"kind":13,"name":"$writer","containerName":"to_string"},{"containerName":"to_string","name":"xmlDecl","kind":12,"line":129},{"name":"$writer","containerName":"to_string","kind":13,"line":130},{"kind":12,"line":130,"name":"doctype","containerName":"to_string"},{"line":132,"kind":13,"containerName":"to_string","name":"$writer"},{"line":132,"kind":12,"name":"startTag","containerName":"to_string"},{"line":133,"kind":13,"containerName":"to_string","name":"$writer"},{"kind":12,"line":133,"containerName":"to_string","name":"startTag"},{"containerName":"to_string","name":"$writer","line":134,"kind":13},{"kind":12,"line":134,"name":"startTag","containerName":"to_string"},{"definition":"my","name":"$reporttype","containerName":"to_string","localvar":"my","kind":13,"line":135},{"kind":13,"line":135,"containerName":"to_string","name":"$result"},{"name":"algorithm","containerName":"to_string","kind":12,"line":135},{"kind":13,"line":136,"name":"$qmoltype","definition":"my","containerName":"to_string","localvar":"my"},{"kind":13,"line":136,"name":"$hmoltype","containerName":"to_string"},{"kind":13,"line":137,"containerName":"to_string","name":"$hit","definition":"my","localvar":"my"},{"line":137,"kind":13,"containerName":"to_string","name":"$result"},{"containerName":"to_string","name":"next_hit","line":137,"kind":12},{"localvar":"my","name":"$hsp","definition":"my","containerName":"to_string","line":138,"kind":13},{"line":138,"kind":13,"name":"$hit","containerName":"to_string"},{"name":"next_hsp","containerName":"to_string","kind":12,"line":138},{"containerName":"to_string","name":"$hsp","line":139,"kind":13},{"name":"query","containerName":"to_string","kind":12,"line":139},{"name":"strand","containerName":"to_string","line":139,"kind":12},{"line":139,"kind":13,"name":"$qmoltype","containerName":"to_string"},{"containerName":"to_string","name":"$qmoltype","kind":13,"line":140},{"name":"$hsp","containerName":"to_string","kind":13,"line":142},{"containerName":"to_string","name":"hit","kind":12,"line":142},{"kind":12,"line":142,"containerName":"to_string","name":"strand"},{"kind":13,"line":142,"name":"$hmoltype","containerName":"to_string"},{"kind":13,"line":143,"containerName":"to_string","name":"$hmoltype"},{"containerName":"to_string","name":"$writer","line":145,"kind":13},{"kind":12,"line":145,"containerName":"to_string","name":"startTag"},{"name":"$result","containerName":"to_string","line":146,"kind":13},{"name":"query_length","containerName":"to_string","kind":12,"line":146},{"containerName":"to_string","name":"$result","line":147,"kind":13},{"containerName":"to_string","name":"query_name","kind":12,"line":147},{"kind":13,"line":147,"name":"$result","containerName":"to_string"},{"kind":12,"line":147,"containerName":"to_string","name":"query_description"},{"line":148,"kind":13,"name":"$qmoltype","containerName":"to_string"},{"kind":13,"line":150,"containerName":"to_string","name":"$result"},{"kind":12,"line":151,"containerName":"to_string","name":"query_name"},{"line":154,"kind":13,"containerName":"to_string","name":"$writer"},{"kind":12,"line":154,"name":"startTag","containerName":"to_string"},{"name":"$writer","containerName":"to_string","line":155,"kind":13},{"containerName":"to_string","name":"startTag","kind":12,"line":155},{"kind":13,"line":157,"containerName":"to_string","name":"$reporttype"},{"kind":13,"line":158,"containerName":"to_string","definition":"my","name":"$hitnum","localvar":"my"},{"line":158,"kind":13,"name":"$hspnum","containerName":"to_string"},{"definition":"my","name":"$hit","containerName":"to_string","localvar":"my","kind":13,"line":159},{"name":"$result","containerName":"to_string","line":159,"kind":13},{"kind":12,"line":159,"containerName":"to_string","name":"hits"},{"kind":13,"line":160,"containerName":"to_string","name":"$hspnum"},{"localvar":"my","definition":"my","name":"$hsp","containerName":"to_string","line":161,"kind":13},{"containerName":"to_string","name":"$hit","kind":13,"line":161},{"kind":12,"line":161,"name":"hsps","containerName":"to_string"},{"line":162,"kind":13,"containerName":"to_string","name":"$writer"},{"kind":12,"line":162,"name":"startTag","containerName":"to_string"},{"name":"$reporttype","containerName":"to_string","line":163,"kind":13},{"name":"$hit","containerName":"to_string","line":165,"kind":13},{"kind":12,"line":165,"containerName":"to_string","name":"name"},{"containerName":"to_string","name":"$hit","line":165,"kind":13},{"containerName":"to_string","name":"description","line":165,"kind":12},{"name":"$writer","containerName":"to_string","line":168,"kind":13},{"kind":12,"line":168,"name":"emptyTag","containerName":"to_string"},{"containerName":"to_string","name":"$hsp","line":169,"kind":13},{"line":169,"kind":12,"containerName":"to_string","name":"query"},{"kind":12,"line":169,"name":"start","containerName":"to_string"},{"line":170,"kind":13,"name":"$hsp","containerName":"to_string"},{"name":"query","containerName":"to_string","kind":12,"line":170},{"line":170,"kind":12,"name":"end","containerName":"to_string"},{"line":171,"kind":13,"containerName":"to_string","name":"$writer"},{"kind":12,"line":171,"name":"emptyTag","containerName":"to_string"},{"line":173,"kind":13,"name":"$hsp","containerName":"to_string"},{"line":173,"kind":12,"name":"score","containerName":"to_string"},{"line":176,"kind":13,"name":"$writer","containerName":"to_string"},{"containerName":"to_string","name":"emptyTag","line":176,"kind":12},{"kind":13,"line":178,"name":"$hsp","containerName":"to_string"},{"name":"hit","containerName":"to_string","kind":12,"line":178},{"kind":12,"line":178,"containerName":"to_string","name":"start"},{"line":180,"kind":13,"name":"$writer","containerName":"to_string"},{"containerName":"to_string","name":"emptyTag","kind":12,"line":180},{"line":182,"kind":13,"name":"$hsp","containerName":"to_string"},{"kind":12,"line":182,"name":"hit","containerName":"to_string"},{"kind":12,"line":182,"name":"end","containerName":"to_string"},{"name":"$writer","containerName":"to_string","kind":13,"line":184},{"line":184,"kind":12,"name":"emptyTag","containerName":"to_string"},{"line":186,"kind":13,"name":"$hitnum","containerName":"to_string"},{"name":"$hspnum","containerName":"to_string","kind":13,"line":186},{"name":"$hsp","containerName":"to_string","line":189,"kind":13},{"kind":12,"line":189,"containerName":"to_string","name":"hit"},{"kind":12,"line":189,"name":"strand","containerName":"to_string"},{"name":"$writer","containerName":"to_string","line":190,"kind":13},{"containerName":"to_string","name":"emptyTag","kind":12,"line":190},{"name":"$hspnum","containerName":"to_string","line":195,"kind":13},{"containerName":"to_string","name":"$writer","kind":13,"line":196},{"line":196,"kind":12,"containerName":"to_string","name":"endTag"},{"line":198,"kind":13,"containerName":"to_string","name":"$hitnum"},{"name":"$writer","containerName":"to_string","kind":13,"line":200},{"name":"endTag","containerName":"to_string","line":200,"kind":12},{"line":201,"kind":13,"name":"$writer","containerName":"to_string"},{"kind":12,"line":201,"containerName":"to_string","name":"endTag"},{"kind":13,"line":202,"name":"$writer","containerName":"to_string"},{"line":202,"kind":12,"containerName":"to_string","name":"endTag"},{"line":203,"kind":13,"name":"$writer","containerName":"to_string"},{"line":203,"kind":12,"name":"endTag","containerName":"to_string"},{"kind":13,"line":205,"containerName":"to_string","name":"$writer"},{"kind":12,"line":205,"name":"startTag","containerName":"to_string"},{"line":206,"kind":13,"name":"$writer","containerName":"to_string"},{"containerName":"to_string","name":"startTag","line":206,"kind":12},{"line":207,"kind":13,"name":"$reporttype","containerName":"to_string"},{"line":208,"kind":13,"name":"$result","containerName":"to_string"},{"containerName":"to_string","name":"query_length","kind":12,"line":208},{"kind":13,"line":209,"name":"$hitnum","containerName":"to_string"},{"line":209,"kind":13,"containerName":"to_string","name":"$hspnum"},{"line":210,"kind":13,"localvar":"my","definition":"my","name":"$hit","containerName":"to_string"},{"name":"$result","containerName":"to_string","line":210,"kind":13},{"containerName":"to_string","name":"hits","kind":12,"line":210},{"kind":13,"line":211,"name":"$hspnum","containerName":"to_string"},{"containerName":"to_string","definition":"my","name":"$hsp","localvar":"my","kind":13,"line":212},{"kind":13,"line":212,"containerName":"to_string","name":"$hit"},{"line":212,"kind":12,"name":"hsps","containerName":"to_string"},{"containerName":"to_string","name":"$writer","kind":13,"line":213},{"containerName":"to_string","name":"startTag","line":213,"kind":12},{"name":"$hitnum","containerName":"to_string","kind":13,"line":214},{"kind":13,"line":214,"name":"$hspnum","containerName":"to_string"},{"name":"$result","containerName":"to_string","kind":13,"line":215},{"name":"algorithm","containerName":"to_string","kind":12,"line":215},{"containerName":"to_string","name":"$result","kind":13,"line":217},{"containerName":"to_string","name":"query_name","line":217,"kind":12},{"line":219,"kind":13,"containerName":"to_string","name":"$result"},{"containerName":"to_string","name":"database_name","line":219,"kind":12},{"name":"$hit","containerName":"to_string","line":220,"kind":13},{"line":220,"kind":12,"containerName":"to_string","name":"name"},{"line":221,"kind":13,"name":"$hit","containerName":"to_string"},{"name":"name","containerName":"to_string","kind":12,"line":221},{"containerName":"to_string","name":"$result","line":222,"kind":13},{"line":222,"kind":12,"name":"query_name","containerName":"to_string"},{"line":223,"kind":13,"name":"$result","containerName":"to_string"},{"kind":12,"line":223,"name":"query_name","containerName":"to_string"},{"containerName":"to_string","name":"$result","line":224,"kind":13},{"containerName":"to_string","name":"query_name","kind":12,"line":224},{"name":"$result","containerName":"to_string","kind":13,"line":225},{"line":225,"kind":12,"name":"query_description","containerName":"to_string"},{"name":"$hit","containerName":"to_string","line":226,"kind":13},{"kind":12,"line":226,"name":"name","containerName":"to_string"},{"kind":13,"line":227,"name":"$hit","containerName":"to_string"},{"containerName":"to_string","name":"description","line":227,"kind":12},{"containerName":"to_string","name":"$hsp","kind":13,"line":228},{"name":"score","containerName":"to_string","kind":12,"line":228},{"kind":13,"line":229,"containerName":"to_string","name":"$hsp"},{"containerName":"to_string","name":"query","kind":12,"line":229},{"name":"start","containerName":"to_string","kind":12,"line":229},{"line":230,"kind":13,"name":"$hsp","containerName":"to_string"},{"kind":12,"line":230,"containerName":"to_string","name":"query"},{"containerName":"to_string","name":"end","kind":12,"line":230},{"kind":13,"line":231,"containerName":"to_string","name":"$hsp"},{"containerName":"to_string","name":"hit","kind":12,"line":231},{"line":231,"kind":12,"name":"start","containerName":"to_string"},{"line":232,"kind":13,"name":"$hsp","containerName":"to_string"},{"kind":12,"line":232,"containerName":"to_string","name":"hit"},{"containerName":"to_string","name":"end","line":232,"kind":12},{"name":"$hit","containerName":"to_string","line":233,"kind":13},{"line":233,"kind":12,"name":"length","containerName":"to_string"},{"kind":13,"line":234,"containerName":"to_string","name":"$result"},{"kind":12,"line":234,"name":"query_length","containerName":"to_string"},{"kind":13,"line":236,"containerName":"to_string","name":"$writer"},{"containerName":"to_string","name":"emptyTag","kind":12,"line":236},{"name":"$hitnum","containerName":"to_string","line":238,"kind":13},{"kind":13,"line":239,"name":"$writer","containerName":"to_string"},{"line":239,"kind":12,"name":"emptyTag","containerName":"to_string"},{"line":241,"kind":13,"name":"$hit","containerName":"to_string"},{"line":241,"kind":12,"containerName":"to_string","name":"name"},{"line":242,"kind":13,"containerName":"to_string","name":"$writer"},{"containerName":"to_string","name":"emptyTag","line":242,"kind":12},{"name":"$hspnum","containerName":"to_string","kind":13,"line":244},{"line":245,"kind":13,"name":"$writer","containerName":"to_string"},{"line":245,"kind":12,"name":"emptyTag","containerName":"to_string"},{"name":"$hsp","containerName":"to_string","line":247,"kind":13},{"name":"bits","containerName":"to_string","line":247,"kind":12},{"line":248,"kind":13,"containerName":"to_string","name":"$writer"},{"containerName":"to_string","name":"emptyTag","kind":12,"line":248},{"name":"$hsp","containerName":"to_string","line":250,"kind":13},{"kind":12,"line":250,"containerName":"to_string","name":"evalue"},{"kind":13,"line":251,"containerName":"to_string","name":"$writer"},{"name":"emptyTag","containerName":"to_string","kind":12,"line":251},{"containerName":"to_string","name":"$writer","line":254,"kind":13},{"containerName":"to_string","name":"emptyTag","line":254,"kind":12},{"kind":13,"line":257,"containerName":"to_string","name":"$writer"},{"line":257,"kind":12,"containerName":"to_string","name":"emptyTag"},{"name":"$hsp","containerName":"to_string","line":259,"kind":13},{"containerName":"to_string","name":"query","line":259,"kind":12},{"kind":12,"line":259,"containerName":"to_string","name":"frame"},{"containerName":"to_string","name":"$writer","line":260,"kind":13},{"line":260,"kind":12,"name":"emptyTag","containerName":"to_string"},{"containerName":"to_string","name":"$hsp","line":262,"kind":13},{"containerName":"to_string","name":"hit","kind":12,"line":262},{"containerName":"to_string","name":"frame","line":262,"kind":12},{"containerName":"to_string","name":"$hsp","kind":13,"line":262},{"containerName":"to_string","name":"hit","line":262,"kind":12},{"line":262,"kind":12,"name":"strand","containerName":"to_string"},{"kind":13,"line":263,"name":"$writer","containerName":"to_string"},{"containerName":"to_string","name":"emptyTag","line":263,"kind":12},{"line":265,"kind":13,"name":"$hsp","containerName":"to_string"},{"name":"percent_identity","containerName":"to_string","kind":12,"line":265},{"containerName":"to_string","name":"$writer","kind":13,"line":266},{"kind":12,"line":266,"containerName":"to_string","name":"emptyTag"},{"containerName":"to_string","name":"$hsp","line":268,"kind":13},{"kind":12,"line":268,"name":"frac_conserved","containerName":"to_string"},{"containerName":"to_string","name":"$cons","definition":"my","localvar":"my","kind":13,"line":269},{"line":269,"kind":13,"containerName":"to_string","name":"$hsp"},{"line":269,"kind":12,"containerName":"to_string","name":"frac_conserved"},{"name":"$hsp","containerName":"to_string","kind":13,"line":269},{"kind":12,"line":269,"containerName":"to_string","name":"length"},{"containerName":"to_string","name":"$ident","definition":"my","localvar":"my","kind":13,"line":270},{"kind":13,"line":270,"name":"$hsp","containerName":"to_string"},{"kind":12,"line":270,"name":"frac_identical","containerName":"to_string"},{"name":"$hsp","containerName":"to_string","kind":13,"line":270},{"containerName":"to_string","name":"length","line":270,"kind":12},{"name":"$writer","containerName":"to_string","kind":13,"line":272},{"line":272,"kind":12,"containerName":"to_string","name":"emptyTag"},{"line":274,"kind":13,"containerName":"to_string","name":"$ident"},{"name":"$writer","containerName":"to_string","line":275,"kind":13},{"containerName":"to_string","name":"emptyTag","line":275,"kind":12},{"kind":13,"line":277,"name":"$cons","containerName":"to_string"},{"kind":13,"line":278,"containerName":"to_string","name":"$writer"},{"name":"emptyTag","containerName":"to_string","line":278,"kind":12},{"kind":13,"line":280,"name":"$hsp","containerName":"to_string"},{"name":"gaps","containerName":"to_string","kind":12,"line":280},{"kind":13,"line":281,"containerName":"to_string","name":"$writer"},{"name":"emptyTag","containerName":"to_string","line":281,"kind":12},{"containerName":"to_string","name":"$hsp","kind":13,"line":283},{"name":"length","containerName":"to_string","line":283,"kind":12},{"line":284,"kind":13,"name":"$writer","containerName":"to_string"},{"name":"emptyTag","containerName":"to_string","kind":12,"line":284},{"kind":13,"line":287,"name":"$writer","containerName":"to_string"},{"kind":12,"line":287,"name":"emptyTag","containerName":"to_string"},{"line":289,"kind":13,"name":"$hit","containerName":"to_string"},{"line":289,"kind":12,"containerName":"to_string","name":"length"},{"line":290,"kind":13,"localvar":"my","definition":"my","name":"@extrafields","containerName":"to_string"},{"kind":13,"line":292,"containerName":"to_string","name":"$writer"},{"kind":12,"line":292,"containerName":"to_string","name":"emptyTag"},{"kind":13,"line":293,"containerName":"to_string","name":"$hsp"},{"line":293,"kind":12,"name":"hit","containerName":"to_string"},{"name":"length","containerName":"to_string","kind":12,"line":293},{"containerName":"to_string","name":"$hsp","kind":13,"line":294},{"containerName":"to_string","name":"hsp_length","line":294,"kind":12},{"kind":13,"line":295,"name":"$hsp","containerName":"to_string"},{"line":295,"kind":12,"containerName":"to_string","name":"hit"},{"kind":12,"line":295,"containerName":"to_string","name":"length"},{"line":296,"kind":13,"containerName":"to_string","name":"$hsp"},{"line":296,"kind":12,"containerName":"to_string","name":"hit"},{"line":296,"kind":12,"name":"strand","containerName":"to_string"},{"kind":13,"line":297,"containerName":"to_string","name":"$hsp"},{"containerName":"to_string","name":"query","kind":12,"line":297},{"containerName":"to_string","name":"strand","kind":12,"line":297},{"name":"$hsp","containerName":"to_string","line":298,"kind":13},{"kind":12,"line":298,"name":"query_string","containerName":"to_string"},{"kind":13,"line":299,"containerName":"to_string","name":"$hsp"},{"name":"hit_string","containerName":"to_string","line":299,"kind":12},{"line":300,"kind":13,"name":"$hsp","containerName":"to_string"},{"containerName":"to_string","name":"homology_string","line":300,"kind":12},{"containerName":"to_string","name":"$hspnum","kind":13,"line":302},{"line":303,"kind":13,"containerName":"to_string","name":"$writer"},{"name":"endTag","containerName":"to_string","kind":12,"line":303},{"line":305,"kind":13,"name":"$hitnum","containerName":"to_string"},{"line":307,"kind":13,"name":"$writer","containerName":"to_string"},{"kind":12,"line":307,"containerName":"to_string","name":"endTag"},{"name":"$writer","containerName":"to_string","line":308,"kind":13},{"kind":12,"line":308,"containerName":"to_string","name":"endTag"},{"kind":13,"line":310,"name":"$writer","containerName":"to_string"},{"line":310,"kind":12,"name":"startTag","containerName":"to_string"},{"line":311,"kind":13,"containerName":"to_string","name":"$writer"},{"name":"startTag","containerName":"to_string","line":311,"kind":12},{"kind":13,"line":312,"name":"$writer","containerName":"to_string"},{"kind":12,"line":312,"containerName":"to_string","name":"startTag"},{"name":"$writer","containerName":"to_string","kind":13,"line":313},{"containerName":"to_string","name":"emptyTag","line":313,"kind":12},{"name":"$reporttype","containerName":"to_string","kind":13,"line":315},{"name":"$writer","containerName":"to_string","line":316,"kind":13},{"name":"emptyTag","containerName":"to_string","line":316,"kind":12},{"name":"$reporttype","containerName":"to_string","line":318,"kind":13},{"kind":13,"line":319,"containerName":"to_string","name":"$result"},{"name":"algorithm_version","containerName":"to_string","kind":12,"line":319},{"containerName":"to_string","name":"$writer","line":320,"kind":13},{"name":"emptyTag","containerName":"to_string","kind":12,"line":320},{"name":"$result","containerName":"to_string","line":322,"kind":13},{"name":"algorithm_reference","containerName":"to_string","line":322,"kind":12},{"containerName":"to_string","name":"$writer","kind":13,"line":323},{"name":"emptyTag","containerName":"to_string","kind":12,"line":323},{"line":325,"kind":13,"name":"$result","containerName":"to_string"},{"line":325,"kind":12,"containerName":"to_string","name":"database_name"},{"containerName":"to_string","name":"$writer","line":326,"kind":13},{"name":"emptyTag","containerName":"to_string","kind":12,"line":326},{"kind":13,"line":328,"name":"$result","containerName":"to_string"},{"kind":12,"line":328,"name":"database_entries","containerName":"to_string"},{"kind":13,"line":329,"name":"$writer","containerName":"to_string"},{"line":329,"kind":12,"containerName":"to_string","name":"emptyTag"},{"kind":13,"line":331,"name":"$result","containerName":"to_string"},{"name":"database_letters","containerName":"to_string","kind":12,"line":331},{"localvar":"my","containerName":"to_string","name":"$attr","definition":"my","line":335,"kind":13},{"name":"$result","containerName":"to_string","kind":13,"line":335},{"containerName":"to_string","name":"available_parameters","kind":12,"line":335},{"kind":13,"line":336,"containerName":"to_string","name":"$writer"},{"containerName":"to_string","name":"emptyTag","line":336,"kind":12},{"kind":13,"line":337,"containerName":"to_string","name":"$attr"},{"kind":13,"line":338,"name":"$result","containerName":"to_string"},{"line":338,"kind":12,"containerName":"to_string","name":"get_parameter"},{"name":"$attr","containerName":"to_string","line":338,"kind":13},{"line":340,"kind":13,"localvar":"my","containerName":"to_string","definition":"my","name":"$attr"},{"containerName":"to_string","name":"$result","kind":13,"line":340},{"name":"available_statistics","containerName":"to_string","line":340,"kind":12},{"line":341,"kind":13,"name":"$writer","containerName":"to_string"},{"line":341,"kind":12,"name":"emptyTag","containerName":"to_string"},{"kind":13,"line":342,"name":"$attr","containerName":"to_string"},{"name":"$result","containerName":"to_string","line":343,"kind":13},{"name":"get_statistic","containerName":"to_string","kind":12,"line":343},{"containerName":"to_string","name":"$attr","line":343,"kind":13},{"name":"$writer","containerName":"to_string","line":345,"kind":13},{"line":345,"kind":12,"name":"endTag","containerName":"to_string"},{"containerName":"to_string","name":"$writer","line":346,"kind":13},{"line":346,"kind":12,"containerName":"to_string","name":"endTag"},{"kind":13,"line":347,"name":"$writer","containerName":"to_string"},{"kind":12,"line":347,"name":"endTag","containerName":"to_string"},{"line":349,"kind":13,"name":"$writer","containerName":"to_string"},{"kind":12,"line":349,"containerName":"to_string","name":"endTag"},{"containerName":"to_string","name":"$writer","line":350,"kind":13},{"line":350,"kind":12,"containerName":"to_string","name":"endTag"},{"name":"$writer","containerName":"to_string","line":351,"kind":13},{"name":"end","containerName":"to_string","kind":12,"line":351},{"name":"$str","containerName":"to_string","line":352,"kind":13},{"kind":12,"line":352,"containerName":"to_string","name":"string_ref"}],"containerName":"main::","definition":"sub","detail":"($self,$result,$num)","signature":{"label":"to_string($self,$result,$num)","parameters":[{"label":"$self"},{"label":"$result"},{"label":"$num"}],"documentation":"1;\n# $Id: BSMLResultWriter.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::Writer::BSMLResultWriter\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::Writer::BSMLResultWriter - BSML output writer\n\n=head1 SYNOPSIS\n\n  use Bio::SearchIO;\n  my $in = Bio::SearchIO->new(-file   => 'result.blast',\n                             -format => 'blast');\n  my $out = Bio::SearchIO->new(-output_format  => 'BSMLResultWriter',\n                              -file           => \">result.bsml\");\n  while( my $r = $in->next_result ) {\n    $out->write_result($r);\n  }\n\n=head1 DESCRIPTION\n\nThis is a writer to produce BSML for a search result.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::Writer::BSMLResultWriter;\nuse strict;\n\nuse XML::Writer;\nuse IO::String;\n\nuse base qw(Bio::Root::Root Bio::SearchIO::SearchWriterI);\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::Writer::BSMLResultWriter->new();\n Function: Builds a new Bio::SearchIO::Writer::BSMLResultWriter object \n Returns : an instance of Bio::SearchIO::Writer::BSMLResultWriter\n Args    :\n\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  return $self;\n}\n\n=head2 to_string\n\n Purpose   : Produces data for each Search::Result::ResultI in a string.\n           : This is an abstract method. For some useful implementations,\n           : see ResultTableWriter.pm, HitTableWriter.pm, \n           : and HSPTableWriter.pm.\n Usage     : print $writer->to_string( $result_obj, @args );\n Argument  : $result_obj = A Bio::Search::Result::ResultI object\n           : @args = any additional arguments used by your implementation.\n Returns   : String containing data for each search Result or any of its\n           : sub-objects (Hits and HSPs).\n Throws    : n/a\n\n this implementation is largely adapted from the Incogen XSLT stylesheet\n to convert NCBI BLAST XML to BSML"}},{"containerName":"String","name":"IO","line":125,"kind":12},{"line":126,"kind":12,"name":"XML","containerName":"Writer"},{"line":126,"kind":12,"name":"OUTPUT"},{"name":"DATA_INDENT","line":127,"kind":12},{"name":"DATA_MODE","line":128,"kind":12}],"version":5}