{"vars":[{"name":"@Bio","containerName":null,"kind":13,"line":121},{"kind":2,"line":121,"containerName":"strict::Bio::SearchIO::SearchResultEventBuilder::SearchIO::InternalParserError","name":"ISA"},{"line":125,"kind":2,"containerName":"","name":"base"},{"name":"new","range":{"end":{"line":191,"character":9999},"start":{"line":150,"character":0}},"definition":"sub","containerName":"main::","signature":{"documentation":"__END__\n# $Id: SearchIO.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO - Driver for parsing Sequence Database Searches \n(BLAST, FASTA, ...)\n\n=head1 SYNOPSIS\n\n   use Bio::SearchIO;\n   # format can be 'fasta', 'blast', 'exonerate', ...\n   my $searchio = Bio::SearchIO->new( -format => 'blastxml',\n                                     -file   => 'blastout.xml' );\n   while ( my $result = $searchio->next_result() ) {\n       while( my $hit = $result->next_hit ) {\n        # process the Bio::Search::Hit::HitI object\n           while( my $hsp = $hit->next_hsp ) { \n            # process the Bio::Search::HSP::HSPI object\n           }\n       }\n   }\n\n\n=head1 DESCRIPTION\n\nThis is a driver for instantiating a parser for report files from\nsequence database searches. This object serves as a wrapper for the\nformat parsers in Bio::SearchIO::* - you should not need to ever\nuse those format parsers directly. (For people used to the SeqIO\nsystem it, we are deliberately using the same pattern).\n\nOnce you get a SearchIO object, calling next_result() gives you back\na L<Bio::Search::Result::ResultI> compliant object, which is an object that\nrepresents one Blast/Fasta/HMMER whatever report.\n\nA list of module names and formats is below:\n\n  blast      BLAST (WUBLAST, NCBIBLAST,bl2seq)   \n  fasta      FASTA -m9 and -m0\n  blasttable BLAST -m9 or -m8 output (both NCBI and WUBLAST tabular)\n  megablast  MEGABLAST\n  psl        UCSC PSL format\n  waba       WABA output\n  axt        AXT format\n  sim4       Sim4\n  hmmer      HMMER hmmpfam and hmmsearch\n  exonerate  Exonerate CIGAR and VULGAR format\n  blastxml   NCBI BLAST XML\n  wise       Genewise -genesf format\n\nAlso see the SearchIO HOWTO:\nhttp://bioperl.open-bio.org/wiki/HOWTO:SearchIO\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich & Steve Chervitz\n\nEmail jason-at-bioperl.org\nEmail sac-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::IO\n\nuse Bio::SearchIO::SearchResultEventBuilder;\n\n# Special exception class for exceptions during parsing.\n# End users should not ever see these.\n# For an example of usage, see blast.pm.\n@Bio::SearchIO::InternalParserError::ISA = qw(Bio::Root::Exception);\n\nuse Symbol;\n\nuse base qw(Bio::Root::IO Bio::Event::EventGeneratorI Bio::AnalysisParserI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO->new();\n Function: Builds a new Bio::SearchIO object \n Returns : Bio::SearchIO initialized with the correct format\n Args    : -file           => $filename\n           -format         => format\n           -fh             => filehandle to attach to\n           -result_factory => Object implementing Bio::Factory::ObjectFactoryI\n           -hit_factory    => Object implementing Bio::Factory::ObjectFactoryI\n           -hsp_factory    => Object implementing Bio::Factory::ObjectFactoryI\n           -writer         => Object implementing Bio::SearchIO::SearchWriterI\n           -output_format  => output format, which will dynamically load writer\n\nSee L<Bio::Factory::ObjectFactoryI>, L<Bio::SearchIO::SearchWriterI>\n\nAny factory objects in the arguments are passed along to the\nSearchResultEventBuilder object which holds these factories and sets\ndefault ones if none are supplied as arguments.","parameters":[{"label":"$caller"},{"label":"@args"}],"label":"new($caller,@args)"},"detail":"($caller,@args)","kind":12,"children":[{"name":"$caller","definition":"my","containerName":"new","localvar":"my","kind":13,"line":151},{"line":151,"kind":13,"name":"@args","containerName":"new"},{"definition":"my","name":"$class","containerName":"new","localvar":"my","kind":13,"line":152},{"kind":13,"line":152,"name":"$caller","containerName":"new"},{"line":152,"kind":13,"containerName":"new","name":"$caller"},{"kind":13,"line":156,"containerName":"new","name":"$class"},{"line":157,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"new"},{"name":"$class","containerName":"new","kind":13,"line":157},{"name":"@args","containerName":"new","line":157,"kind":13},{"name":"$self","containerName":"new","kind":13,"line":158},{"name":"_initialize","containerName":"new","line":158,"kind":12},{"kind":13,"line":158,"name":"@args","containerName":"new"},{"line":159,"kind":13,"containerName":"new","name":"$self"},{"line":161,"kind":13,"localvar":"my","name":"%param","definition":"my","containerName":"new"},{"kind":13,"line":161,"containerName":"new","name":"@args"},{"kind":13,"line":162,"name":"@param","containerName":"new"},{"name":"%param","containerName":"new","kind":13,"line":162},{"kind":13,"line":162,"name":"%param","containerName":"new"},{"kind":13,"line":163,"definition":"my","name":"$format","containerName":"new","localvar":"my"},{"kind":13,"line":163,"name":"$param","containerName":"new"},{"name":"$class","containerName":"new","kind":13,"line":164},{"name":"_guess_format","containerName":"new","line":164,"kind":12},{"containerName":"new","name":"$param","line":164,"kind":13},{"containerName":"new","name":"$ARGV","kind":13,"line":164},{"localvar":"my","definition":"my","name":"$output_format","containerName":"new","line":166,"kind":13},{"name":"$param","containerName":"new","kind":13,"line":166},{"containerName":"new","name":"$writer","definition":"my","localvar":"my","kind":13,"line":167},{"name":"$output_format","containerName":"new","line":169,"kind":13},{"kind":13,"line":170,"containerName":"new","name":"$param"},{"kind":13,"line":171,"definition":"my","name":"$dummy","containerName":"new","localvar":"my"},{"name":"new","containerName":"new","line":171,"kind":12},{"kind":13,"line":172,"containerName":"new","name":"$dummy"},{"containerName":"new","name":"throw","kind":12,"line":172},{"kind":13,"line":175,"name":"$output_format","containerName":"new"},{"containerName":"new","name":"$output_format","line":176,"kind":13},{"kind":13,"line":178,"containerName":"new","definition":"my","name":"$output_module","localvar":"my"},{"line":178,"kind":13,"name":"$output_format","containerName":"new"},{"containerName":"new","name":"$class","line":179,"kind":13},{"containerName":"new","name":"_load_module","line":179,"kind":12},{"name":"$output_module","containerName":"new","kind":13,"line":179},{"name":"$writer","containerName":"new","kind":13,"line":180},{"name":"$output_module","containerName":"new","line":180,"kind":13},{"name":"new","containerName":"new","line":180,"kind":12},{"containerName":"new","name":"@args","line":180,"kind":13},{"name":"@args","containerName":"new","kind":13,"line":181},{"kind":13,"line":181,"containerName":"new","name":"$writer"},{"containerName":"new","name":"$format","line":186,"kind":13},{"containerName":"new","name":"$class","kind":13,"line":188},{"line":188,"kind":12,"containerName":"new","name":"_load_format_module"},{"line":188,"kind":13,"name":"$format","containerName":"new"},{"kind":12,"line":189,"name":"new","containerName":"new"},{"line":189,"kind":13,"containerName":"new","name":"@args"}],"line":150},{"name":"SUPER","containerName":"new","line":157,"kind":12},{"line":171,"kind":12,"containerName":"Root::Root","name":"Bio"},{"kind":12,"children":[{"containerName":"newFh","definition":"my","name":"$class","localvar":"my","kind":13,"line":209},{"line":210,"kind":13,"localvar":"my","containerName":"newFh","name":"$self","definition":"my"},{"kind":13,"line":210,"name":"$class","containerName":"newFh"},{"containerName":"newFh","name":"new","line":210,"kind":12},{"containerName":"newFh","name":"$self","line":211,"kind":13},{"containerName":"newFh","name":"fh","kind":12,"line":211}],"line":208,"name":"newFh","definition":"sub","containerName":"main::","range":{"end":{"line":212,"character":9999},"start":{"line":208,"character":0}}},{"name":"fh","definition":"sub","containerName":"main::","range":{"start":{"line":228,"character":0},"end":{"character":9999,"line":234}},"kind":12,"children":[{"kind":13,"line":229,"containerName":"fh","definition":"my","name":"$self","localvar":"my"},{"line":230,"kind":13,"localvar":"my","definition":"my","name":"$class","containerName":"fh"},{"kind":13,"line":230,"containerName":"fh","name":"$self"},{"name":"$self","containerName":"fh","kind":13,"line":230},{"kind":13,"line":231,"name":"$s","definition":"my","containerName":"fh","localvar":"my"},{"kind":13,"line":232,"name":"$class","containerName":"fh"},{"line":232,"kind":13,"containerName":"fh","name":"$self"},{"name":"$s","containerName":"fh","kind":13,"line":233}],"line":228},{"name":"Symbol","containerName":"gensym","line":232,"kind":12},{"children":[{"containerName":"attach_EventHandler","definition":"my","name":"$self","localvar":"my","kind":13,"line":249},{"kind":13,"line":249,"name":"$handler","containerName":"attach_EventHandler"},{"name":"$handler","containerName":"attach_EventHandler","line":250,"kind":13},{"containerName":"attach_EventHandler","name":"$handler","line":251,"kind":13},{"kind":12,"line":251,"containerName":"attach_EventHandler","name":"isa"},{"name":"$self","containerName":"attach_EventHandler","line":252,"kind":13},{"name":"warn","containerName":"attach_EventHandler","line":252,"kind":12},{"line":252,"kind":13,"name":"$handler","containerName":"attach_EventHandler"},{"containerName":"attach_EventHandler","name":"$self","kind":13,"line":254},{"containerName":"attach_EventHandler","name":"$handler","kind":13,"line":254}],"line":248,"kind":12,"signature":{"documentation":"__END__\n# $Id: SearchIO.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO - Driver for parsing Sequence Database Searches \n(BLAST, FASTA, ...)\n\n=head1 SYNOPSIS\n\n   use Bio::SearchIO;\n   # format can be 'fasta', 'blast', 'exonerate', ...\n   my $searchio = Bio::SearchIO->new( -format => 'blastxml',\n                                     -file   => 'blastout.xml' );\n   while ( my $result = $searchio->next_result() ) {\n       while( my $hit = $result->next_hit ) {\n        # process the Bio::Search::Hit::HitI object\n           while( my $hsp = $hit->next_hsp ) { \n            # process the Bio::Search::HSP::HSPI object\n           }\n       }\n   }\n\n\n=head1 DESCRIPTION\n\nThis is a driver for instantiating a parser for report files from\nsequence database searches. This object serves as a wrapper for the\nformat parsers in Bio::SearchIO::* - you should not need to ever\nuse those format parsers directly. (For people used to the SeqIO\nsystem it, we are deliberately using the same pattern).\n\nOnce you get a SearchIO object, calling next_result() gives you back\na L<Bio::Search::Result::ResultI> compliant object, which is an object that\nrepresents one Blast/Fasta/HMMER whatever report.\n\nA list of module names and formats is below:\n\n  blast      BLAST (WUBLAST, NCBIBLAST,bl2seq)   \n  fasta      FASTA -m9 and -m0\n  blasttable BLAST -m9 or -m8 output (both NCBI and WUBLAST tabular)\n  megablast  MEGABLAST\n  psl        UCSC PSL format\n  waba       WABA output\n  axt        AXT format\n  sim4       Sim4\n  hmmer      HMMER hmmpfam and hmmsearch\n  exonerate  Exonerate CIGAR and VULGAR format\n  blastxml   NCBI BLAST XML\n  wise       Genewise -genesf format\n\nAlso see the SearchIO HOWTO:\nhttp://bioperl.open-bio.org/wiki/HOWTO:SearchIO\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich & Steve Chervitz\n\nEmail jason-at-bioperl.org\nEmail sac-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::IO\n\nuse Bio::SearchIO::SearchResultEventBuilder;\n\n# Special exception class for exceptions during parsing.\n# End users should not ever see these.\n# For an example of usage, see blast.pm.\n@Bio::SearchIO::InternalParserError::ISA = qw(Bio::Root::Exception);\n\nuse Symbol;\n\nuse base qw(Bio::Root::IO Bio::Event::EventGeneratorI Bio::AnalysisParserI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO->new();\n Function: Builds a new Bio::SearchIO object \n Returns : Bio::SearchIO initialized with the correct format\n Args    : -file           => $filename\n           -format         => format\n           -fh             => filehandle to attach to\n           -result_factory => Object implementing Bio::Factory::ObjectFactoryI\n           -hit_factory    => Object implementing Bio::Factory::ObjectFactoryI\n           -hsp_factory    => Object implementing Bio::Factory::ObjectFactoryI\n           -writer         => Object implementing Bio::SearchIO::SearchWriterI\n           -output_format  => output format, which will dynamically load writer\n\nSee L<Bio::Factory::ObjectFactoryI>, L<Bio::SearchIO::SearchWriterI>\n\nAny factory objects in the arguments are passed along to the\nSearchResultEventBuilder object which holds these factories and sets\ndefault ones if none are supplied as arguments.\n\n\nsub new {\n  my($caller,@args) = @_;\n  my $class = ref($caller) || $caller;\n    \n  # or do we want to call SUPER on an object if $caller is an\n  # object?\n  if( $class =~ /Bio::SearchIO::(\\S+)/ ) {\n    my ($self) = $class->SUPER::new(@args);        \n    $self->_initialize(@args);\n    return $self;\n  } else { \n    my %param = @args;\n    @param{ map { lc $_ } keys %param } = values %param; # lowercase keys\n    my $format = $param{'-format'} ||\n      $class->_guess_format( $param{'-file'} || $ARGV[0] ) || 'blast';\n\n    my $output_format = $param{'-output_format'};\n    my $writer = undef;\n\n    if( defined $output_format ) {\n        if( defined $param{'-writer'} ) {\n            my $dummy = Bio::Root::Root->new();\n            $dummy->throw(\"Both writer and output format specified - not good\");\n        }\n\n        if( $output_format =~ /^blast$/i ) {\n            $output_format = 'TextResultWriter';\n        }\n        my $output_module = \"Bio::SearchIO::Writer::\".$output_format;\n        $class->_load_module($output_module);\n        $writer = $output_module->new(@args);\n        push(@args,\"-writer\",$writer);\n    }\n\n\n    # normalize capitalization to lower case\n    $format = \"\\L$format\";\n    \n    return unless( $class->_load_format_module($format) );\n    return \"Bio::SearchIO::${format}\"->new(@args);\n  }\n}\n\n=head2 newFh\n\n Title   : newFh\n Usage   : $fh = Bio::SearchIO->newFh(-file=>$filename,\n                                      -format=>'Format')\n Function: does a new() followed by an fh()\n Example : $fh = Bio::SearchIO->newFh(-file=>$filename,\n                                      -format=>'Format')\n           $result = <$fh>;   # read a ResultI object\n           print $fh $result; # write a ResultI object\n Returns : filehandle tied to the Bio::SearchIO::Fh class\n Args    :\n\n\nsub newFh {\n  my $class = shift;\n  return unless my $self = $class->new(@_);\n  return $self->fh;\n}\n\n=head2 fh\n\n Title   : fh\n Usage   : $obj->fh\n Function:\n Example : $fh = $obj->fh;      # make a tied filehandle\n           $result = <$fh>;     # read a ResultI object\n           print $fh $result;   # write a ResultI object\n Returns : filehandle tied to the Bio::SearchIO::Fh class\n Args    :\n\n\n\nsub fh {\n  my $self = shift;\n  my $class = ref($self) || $self;\n  my $s = Symbol::gensym;\n  tie $$s,$class,$self;\n  return $s;\n}\n\n=head2 attach_EventHandler\n\n Title   : attach_EventHandler\n Usage   : $parser->attatch_EventHandler($handler)\n Function: Adds an event handler to listen for events\n Returns : none\n Args    : Bio::SearchIO::EventHandlerI\n\nSee L<Bio::SearchIO::EventHandlerI>","parameters":[{"label":"$self"},{"label":"$handler"}],"label":"attach_EventHandler($self,$handler)"},"detail":"($self,$handler)","definition":"sub","containerName":"main::","range":{"end":{"line":256,"character":9999},"start":{"line":248,"character":0}},"name":"attach_EventHandler"},{"name":"_eventHandler","range":{"end":{"character":9999,"line":273},"start":{"line":270,"character":0}},"kind":12,"line":270,"children":[{"name":"$self","definition":"my","containerName":"_eventHandler","localvar":"my","kind":13,"line":271},{"name":"$self","containerName":"_eventHandler","kind":13,"line":272}],"containerName":"main::","definition":"sub","detail":"($self)","signature":{"label":"_eventHandler($self)","documentation":"__END__\n# $Id: SearchIO.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO - Driver for parsing Sequence Database Searches \n(BLAST, FASTA, ...)\n\n=head1 SYNOPSIS\n\n   use Bio::SearchIO;\n   # format can be 'fasta', 'blast', 'exonerate', ...\n   my $searchio = Bio::SearchIO->new( -format => 'blastxml',\n                                     -file   => 'blastout.xml' );\n   while ( my $result = $searchio->next_result() ) {\n       while( my $hit = $result->next_hit ) {\n        # process the Bio::Search::Hit::HitI object\n           while( my $hsp = $hit->next_hsp ) { \n            # process the Bio::Search::HSP::HSPI object\n           }\n       }\n   }\n\n\n=head1 DESCRIPTION\n\nThis is a driver for instantiating a parser for report files from\nsequence database searches. This object serves as a wrapper for the\nformat parsers in Bio::SearchIO::* - you should not need to ever\nuse those format parsers directly. (For people used to the SeqIO\nsystem it, we are deliberately using the same pattern).\n\nOnce you get a SearchIO object, calling next_result() gives you back\na L<Bio::Search::Result::ResultI> compliant object, which is an object that\nrepresents one Blast/Fasta/HMMER whatever report.\n\nA list of module names and formats is below:\n\n  blast      BLAST (WUBLAST, NCBIBLAST,bl2seq)   \n  fasta      FASTA -m9 and -m0\n  blasttable BLAST -m9 or -m8 output (both NCBI and WUBLAST tabular)\n  megablast  MEGABLAST\n  psl        UCSC PSL format\n  waba       WABA output\n  axt        AXT format\n  sim4       Sim4\n  hmmer      HMMER hmmpfam and hmmsearch\n  exonerate  Exonerate CIGAR and VULGAR format\n  blastxml   NCBI BLAST XML\n  wise       Genewise -genesf format\n\nAlso see the SearchIO HOWTO:\nhttp://bioperl.open-bio.org/wiki/HOWTO:SearchIO\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich & Steve Chervitz\n\nEmail jason-at-bioperl.org\nEmail sac-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::IO\n\nuse Bio::SearchIO::SearchResultEventBuilder;\n\n# Special exception class for exceptions during parsing.\n# End users should not ever see these.\n# For an example of usage, see blast.pm.\n@Bio::SearchIO::InternalParserError::ISA = qw(Bio::Root::Exception);\n\nuse Symbol;\n\nuse base qw(Bio::Root::IO Bio::Event::EventGeneratorI Bio::AnalysisParserI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO->new();\n Function: Builds a new Bio::SearchIO object \n Returns : Bio::SearchIO initialized with the correct format\n Args    : -file           => $filename\n           -format         => format\n           -fh             => filehandle to attach to\n           -result_factory => Object implementing Bio::Factory::ObjectFactoryI\n           -hit_factory    => Object implementing Bio::Factory::ObjectFactoryI\n           -hsp_factory    => Object implementing Bio::Factory::ObjectFactoryI\n           -writer         => Object implementing Bio::SearchIO::SearchWriterI\n           -output_format  => output format, which will dynamically load writer\n\nSee L<Bio::Factory::ObjectFactoryI>, L<Bio::SearchIO::SearchWriterI>\n\nAny factory objects in the arguments are passed along to the\nSearchResultEventBuilder object which holds these factories and sets\ndefault ones if none are supplied as arguments.\n\n\nsub new {\n  my($caller,@args) = @_;\n  my $class = ref($caller) || $caller;\n    \n  # or do we want to call SUPER on an object if $caller is an\n  # object?\n  if( $class =~ /Bio::SearchIO::(\\S+)/ ) {\n    my ($self) = $class->SUPER::new(@args);        \n    $self->_initialize(@args);\n    return $self;\n  } else { \n    my %param = @args;\n    @param{ map { lc $_ } keys %param } = values %param; # lowercase keys\n    my $format = $param{'-format'} ||\n      $class->_guess_format( $param{'-file'} || $ARGV[0] ) || 'blast';\n\n    my $output_format = $param{'-output_format'};\n    my $writer = undef;\n\n    if( defined $output_format ) {\n        if( defined $param{'-writer'} ) {\n            my $dummy = Bio::Root::Root->new();\n            $dummy->throw(\"Both writer and output format specified - not good\");\n        }\n\n        if( $output_format =~ /^blast$/i ) {\n            $output_format = 'TextResultWriter';\n        }\n        my $output_module = \"Bio::SearchIO::Writer::\".$output_format;\n        $class->_load_module($output_module);\n        $writer = $output_module->new(@args);\n        push(@args,\"-writer\",$writer);\n    }\n\n\n    # normalize capitalization to lower case\n    $format = \"\\L$format\";\n    \n    return unless( $class->_load_format_module($format) );\n    return \"Bio::SearchIO::${format}\"->new(@args);\n  }\n}\n\n=head2 newFh\n\n Title   : newFh\n Usage   : $fh = Bio::SearchIO->newFh(-file=>$filename,\n                                      -format=>'Format')\n Function: does a new() followed by an fh()\n Example : $fh = Bio::SearchIO->newFh(-file=>$filename,\n                                      -format=>'Format')\n           $result = <$fh>;   # read a ResultI object\n           print $fh $result; # write a ResultI object\n Returns : filehandle tied to the Bio::SearchIO::Fh class\n Args    :\n\n\nsub newFh {\n  my $class = shift;\n  return unless my $self = $class->new(@_);\n  return $self->fh;\n}\n\n=head2 fh\n\n Title   : fh\n Usage   : $obj->fh\n Function:\n Example : $fh = $obj->fh;      # make a tied filehandle\n           $result = <$fh>;     # read a ResultI object\n           print $fh $result;   # write a ResultI object\n Returns : filehandle tied to the Bio::SearchIO::Fh class\n Args    :\n\n\n\nsub fh {\n  my $self = shift;\n  my $class = ref($self) || $self;\n  my $s = Symbol::gensym;\n  tie $$s,$class,$self;\n  return $s;\n}\n\n=head2 attach_EventHandler\n\n Title   : attach_EventHandler\n Usage   : $parser->attatch_EventHandler($handler)\n Function: Adds an event handler to listen for events\n Returns : none\n Args    : Bio::SearchIO::EventHandlerI\n\nSee L<Bio::SearchIO::EventHandlerI>\n\n\nsub attach_EventHandler{\n    my ($self,$handler) = @_;\n    return if( ! $handler );\n    if( ! $handler->isa('Bio::SearchIO::EventHandlerI') ) {\n        $self->warn(\"Ignoring request to attatch handler \".ref($handler). ' because it is not a Bio::SearchIO::EventHandlerI');\n    }\n    $self->{'_handler'} = $handler;\n    return;\n}\n\n=head2 _eventHandler\n\n Title   : _eventHandler\n Usage   : private\n Function: Get the EventHandler\n Returns : Bio::SearchIO::EventHandlerI\n Args    : none\n\nSee L<Bio::SearchIO::EventHandlerI>","parameters":[{"label":"$self"}]}},{"signature":{"label":"_initialize($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":""},"detail":"($self,@args)","definition":"sub","containerName":"main::","children":[{"containerName":"_initialize","definition":"my","name":"$self","localvar":"my","kind":13,"line":276},{"containerName":"_initialize","name":"@args","kind":13,"line":276},{"line":277,"kind":13,"name":"$self","containerName":"_initialize"},{"line":282,"kind":13,"name":"$self","containerName":"_initialize"},{"containerName":"_initialize","name":"_initialize_io","line":282,"kind":12},{"name":"@args","containerName":"_initialize","line":282,"kind":13},{"containerName":"_initialize","name":"$self","kind":13,"line":283},{"line":283,"kind":12,"name":"attach_EventHandler","containerName":"_initialize"},{"containerName":"_initialize","name":"new","line":283,"kind":12},{"containerName":"_initialize","name":"@args","kind":13,"line":283},{"line":284,"kind":13,"name":"$self","containerName":"_initialize"},{"line":285,"kind":13,"name":"$self","containerName":"_initialize"},{"localvar":"my","name":"$writer","definition":"my","containerName":"_initialize","line":286,"kind":13},{"line":286,"kind":13,"name":"$self","containerName":"_initialize"},{"kind":12,"line":286,"containerName":"_initialize","name":"_rearrange"},{"line":286,"kind":13,"name":"@args","containerName":"_initialize"},{"line":288,"kind":13,"name":"$self","containerName":"_initialize"},{"name":"writer","containerName":"_initialize","kind":12,"line":288},{"line":288,"kind":13,"containerName":"_initialize","name":"$writer"},{"name":"$writer","containerName":"_initialize","line":288,"kind":13}],"line":275,"kind":12,"range":{"start":{"line":275,"character":0},"end":{"character":9999,"line":289}},"name":"_initialize"},{"containerName":"SearchIO::SearchResultEventBuilder","name":"Bio","line":283,"kind":12},{"kind":12,"line":285,"name":"_notfirsttime"},{"range":{"end":{"line":317,"character":9999},"start":{"character":0,"line":314}},"name":"next_result","line":314,"children":[{"name":"$self","definition":"my","containerName":"next_result","localvar":"my","kind":13,"line":315},{"containerName":"next_result","name":"$self","line":316,"kind":13},{"kind":12,"line":316,"name":"throw_not_implemented","containerName":"next_result"}],"kind":12,"detail":"($self)","signature":{"parameters":[{"label":"$self"}],"documentation":"__END__\n# $Id: SearchIO.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO - Driver for parsing Sequence Database Searches \n(BLAST, FASTA, ...)\n\n=head1 SYNOPSIS\n\n   use Bio::SearchIO;\n   # format can be 'fasta', 'blast', 'exonerate', ...\n   my $searchio = Bio::SearchIO->new( -format => 'blastxml',\n                                     -file   => 'blastout.xml' );\n   while ( my $result = $searchio->next_result() ) {\n       while( my $hit = $result->next_hit ) {\n        # process the Bio::Search::Hit::HitI object\n           while( my $hsp = $hit->next_hsp ) { \n            # process the Bio::Search::HSP::HSPI object\n           }\n       }\n   }\n\n\n=head1 DESCRIPTION\n\nThis is a driver for instantiating a parser for report files from\nsequence database searches. This object serves as a wrapper for the\nformat parsers in Bio::SearchIO::* - you should not need to ever\nuse those format parsers directly. (For people used to the SeqIO\nsystem it, we are deliberately using the same pattern).\n\nOnce you get a SearchIO object, calling next_result() gives you back\na L<Bio::Search::Result::ResultI> compliant object, which is an object that\nrepresents one Blast/Fasta/HMMER whatever report.\n\nA list of module names and formats is below:\n\n  blast      BLAST (WUBLAST, NCBIBLAST,bl2seq)   \n  fasta      FASTA -m9 and -m0\n  blasttable BLAST -m9 or -m8 output (both NCBI and WUBLAST tabular)\n  megablast  MEGABLAST\n  psl        UCSC PSL format\n  waba       WABA output\n  axt        AXT format\n  sim4       Sim4\n  hmmer      HMMER hmmpfam and hmmsearch\n  exonerate  Exonerate CIGAR and VULGAR format\n  blastxml   NCBI BLAST XML\n  wise       Genewise -genesf format\n\nAlso see the SearchIO HOWTO:\nhttp://bioperl.open-bio.org/wiki/HOWTO:SearchIO\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich & Steve Chervitz\n\nEmail jason-at-bioperl.org\nEmail sac-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::IO\n\nuse Bio::SearchIO::SearchResultEventBuilder;\n\n# Special exception class for exceptions during parsing.\n# End users should not ever see these.\n# For an example of usage, see blast.pm.\n@Bio::SearchIO::InternalParserError::ISA = qw(Bio::Root::Exception);\n\nuse Symbol;\n\nuse base qw(Bio::Root::IO Bio::Event::EventGeneratorI Bio::AnalysisParserI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO->new();\n Function: Builds a new Bio::SearchIO object \n Returns : Bio::SearchIO initialized with the correct format\n Args    : -file           => $filename\n           -format         => format\n           -fh             => filehandle to attach to\n           -result_factory => Object implementing Bio::Factory::ObjectFactoryI\n           -hit_factory    => Object implementing Bio::Factory::ObjectFactoryI\n           -hsp_factory    => Object implementing Bio::Factory::ObjectFactoryI\n           -writer         => Object implementing Bio::SearchIO::SearchWriterI\n           -output_format  => output format, which will dynamically load writer\n\nSee L<Bio::Factory::ObjectFactoryI>, L<Bio::SearchIO::SearchWriterI>\n\nAny factory objects in the arguments are passed along to the\nSearchResultEventBuilder object which holds these factories and sets\ndefault ones if none are supplied as arguments.\n\n\nsub new {\n  my($caller,@args) = @_;\n  my $class = ref($caller) || $caller;\n    \n  # or do we want to call SUPER on an object if $caller is an\n  # object?\n  if( $class =~ /Bio::SearchIO::(\\S+)/ ) {\n    my ($self) = $class->SUPER::new(@args);        \n    $self->_initialize(@args);\n    return $self;\n  } else { \n    my %param = @args;\n    @param{ map { lc $_ } keys %param } = values %param; # lowercase keys\n    my $format = $param{'-format'} ||\n      $class->_guess_format( $param{'-file'} || $ARGV[0] ) || 'blast';\n\n    my $output_format = $param{'-output_format'};\n    my $writer = undef;\n\n    if( defined $output_format ) {\n        if( defined $param{'-writer'} ) {\n            my $dummy = Bio::Root::Root->new();\n            $dummy->throw(\"Both writer and output format specified - not good\");\n        }\n\n        if( $output_format =~ /^blast$/i ) {\n            $output_format = 'TextResultWriter';\n        }\n        my $output_module = \"Bio::SearchIO::Writer::\".$output_format;\n        $class->_load_module($output_module);\n        $writer = $output_module->new(@args);\n        push(@args,\"-writer\",$writer);\n    }\n\n\n    # normalize capitalization to lower case\n    $format = \"\\L$format\";\n    \n    return unless( $class->_load_format_module($format) );\n    return \"Bio::SearchIO::${format}\"->new(@args);\n  }\n}\n\n=head2 newFh\n\n Title   : newFh\n Usage   : $fh = Bio::SearchIO->newFh(-file=>$filename,\n                                      -format=>'Format')\n Function: does a new() followed by an fh()\n Example : $fh = Bio::SearchIO->newFh(-file=>$filename,\n                                      -format=>'Format')\n           $result = <$fh>;   # read a ResultI object\n           print $fh $result; # write a ResultI object\n Returns : filehandle tied to the Bio::SearchIO::Fh class\n Args    :\n\n\nsub newFh {\n  my $class = shift;\n  return unless my $self = $class->new(@_);\n  return $self->fh;\n}\n\n=head2 fh\n\n Title   : fh\n Usage   : $obj->fh\n Function:\n Example : $fh = $obj->fh;      # make a tied filehandle\n           $result = <$fh>;     # read a ResultI object\n           print $fh $result;   # write a ResultI object\n Returns : filehandle tied to the Bio::SearchIO::Fh class\n Args    :\n\n\n\nsub fh {\n  my $self = shift;\n  my $class = ref($self) || $self;\n  my $s = Symbol::gensym;\n  tie $$s,$class,$self;\n  return $s;\n}\n\n=head2 attach_EventHandler\n\n Title   : attach_EventHandler\n Usage   : $parser->attatch_EventHandler($handler)\n Function: Adds an event handler to listen for events\n Returns : none\n Args    : Bio::SearchIO::EventHandlerI\n\nSee L<Bio::SearchIO::EventHandlerI>\n\n\nsub attach_EventHandler{\n    my ($self,$handler) = @_;\n    return if( ! $handler );\n    if( ! $handler->isa('Bio::SearchIO::EventHandlerI') ) {\n        $self->warn(\"Ignoring request to attatch handler \".ref($handler). ' because it is not a Bio::SearchIO::EventHandlerI');\n    }\n    $self->{'_handler'} = $handler;\n    return;\n}\n\n=head2 _eventHandler\n\n Title   : _eventHandler\n Usage   : private\n Function: Get the EventHandler\n Returns : Bio::SearchIO::EventHandlerI\n Args    : none\n\nSee L<Bio::SearchIO::EventHandlerI>\n\n\nsub _eventHandler{\n   my ($self) = @_;\n   return $self->{'_handler'};\n}\n\nsub _initialize {\n    my($self, @args) = @_;\n    $self->{'_handler'} = undef;\n    # not really necessary unless we put more in RootI\n    #$self->SUPER::_initialize(@args);\n\n    # initialize the IO part\n    $self->_initialize_io(@args);\n    $self->attach_EventHandler(Bio::SearchIO::SearchResultEventBuilder->new(@args));\n    $self->{'_reporttype'} = '';\n    $self->{_notfirsttime} = 0;\n    my ( $writer ) = $self->_rearrange([qw(WRITER)], @args);\n\n    $self->writer( $writer ) if $writer;\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : $result = stream->next_result\n Function: Reads the next ResultI object from the stream and returns it.\n\n           Certain driver modules may encounter entries in the stream that\n           are either misformatted or that use syntax not yet understood\n           by the driver. If such an incident is recoverable, e.g., by\n           dismissing a feature of a feature table or some other non-mandatory\n           part of an entry, the driver will issue a warning. In the case\n           of a non-recoverable situation an exception will be thrown.\n           Do not assume that you can resume parsing the same stream after\n           catching the exception. Note that you can always turn recoverable\n           errors into exceptions by calling $stream->verbose(2) (see\n           Bio::Root::RootI POD page).\n Returns : A Bio::Search::Result::ResultI object\n Args    : n/a\n\nSee L<Bio::Root::RootI>","label":"next_result($self)"},"containerName":"main::","definition":"sub"},{"detail":"($self,$result,@args)","signature":{"parameters":[{"label":"$self"},{"label":"$result"},{"label":"@args"}],"documentation":"__END__\n# $Id: SearchIO.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO - Driver for parsing Sequence Database Searches \n(BLAST, FASTA, ...)\n\n=head1 SYNOPSIS\n\n   use Bio::SearchIO;\n   # format can be 'fasta', 'blast', 'exonerate', ...\n   my $searchio = Bio::SearchIO->new( -format => 'blastxml',\n                                     -file   => 'blastout.xml' );\n   while ( my $result = $searchio->next_result() ) {\n       while( my $hit = $result->next_hit ) {\n        # process the Bio::Search::Hit::HitI object\n           while( my $hsp = $hit->next_hsp ) { \n            # process the Bio::Search::HSP::HSPI object\n           }\n       }\n   }\n\n\n=head1 DESCRIPTION\n\nThis is a driver for instantiating a parser for report files from\nsequence database searches. This object serves as a wrapper for the\nformat parsers in Bio::SearchIO::* - you should not need to ever\nuse those format parsers directly. (For people used to the SeqIO\nsystem it, we are deliberately using the same pattern).\n\nOnce you get a SearchIO object, calling next_result() gives you back\na L<Bio::Search::Result::ResultI> compliant object, which is an object that\nrepresents one Blast/Fasta/HMMER whatever report.\n\nA list of module names and formats is below:\n\n  blast      BLAST (WUBLAST, NCBIBLAST,bl2seq)   \n  fasta      FASTA -m9 and -m0\n  blasttable BLAST -m9 or -m8 output (both NCBI and WUBLAST tabular)\n  megablast  MEGABLAST\n  psl        UCSC PSL format\n  waba       WABA output\n  axt        AXT format\n  sim4       Sim4\n  hmmer      HMMER hmmpfam and hmmsearch\n  exonerate  Exonerate CIGAR and VULGAR format\n  blastxml   NCBI BLAST XML\n  wise       Genewise -genesf format\n\nAlso see the SearchIO HOWTO:\nhttp://bioperl.open-bio.org/wiki/HOWTO:SearchIO\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich & Steve Chervitz\n\nEmail jason-at-bioperl.org\nEmail sac-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::IO\n\nuse Bio::SearchIO::SearchResultEventBuilder;\n\n# Special exception class for exceptions during parsing.\n# End users should not ever see these.\n# For an example of usage, see blast.pm.\n@Bio::SearchIO::InternalParserError::ISA = qw(Bio::Root::Exception);\n\nuse Symbol;\n\nuse base qw(Bio::Root::IO Bio::Event::EventGeneratorI Bio::AnalysisParserI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO->new();\n Function: Builds a new Bio::SearchIO object \n Returns : Bio::SearchIO initialized with the correct format\n Args    : -file           => $filename\n           -format         => format\n           -fh             => filehandle to attach to\n           -result_factory => Object implementing Bio::Factory::ObjectFactoryI\n           -hit_factory    => Object implementing Bio::Factory::ObjectFactoryI\n           -hsp_factory    => Object implementing Bio::Factory::ObjectFactoryI\n           -writer         => Object implementing Bio::SearchIO::SearchWriterI\n           -output_format  => output format, which will dynamically load writer\n\nSee L<Bio::Factory::ObjectFactoryI>, L<Bio::SearchIO::SearchWriterI>\n\nAny factory objects in the arguments are passed along to the\nSearchResultEventBuilder object which holds these factories and sets\ndefault ones if none are supplied as arguments.\n\n\nsub new {\n  my($caller,@args) = @_;\n  my $class = ref($caller) || $caller;\n    \n  # or do we want to call SUPER on an object if $caller is an\n  # object?\n  if( $class =~ /Bio::SearchIO::(\\S+)/ ) {\n    my ($self) = $class->SUPER::new(@args);        \n    $self->_initialize(@args);\n    return $self;\n  } else { \n    my %param = @args;\n    @param{ map { lc $_ } keys %param } = values %param; # lowercase keys\n    my $format = $param{'-format'} ||\n      $class->_guess_format( $param{'-file'} || $ARGV[0] ) || 'blast';\n\n    my $output_format = $param{'-output_format'};\n    my $writer = undef;\n\n    if( defined $output_format ) {\n        if( defined $param{'-writer'} ) {\n            my $dummy = Bio::Root::Root->new();\n            $dummy->throw(\"Both writer and output format specified - not good\");\n        }\n\n        if( $output_format =~ /^blast$/i ) {\n            $output_format = 'TextResultWriter';\n        }\n        my $output_module = \"Bio::SearchIO::Writer::\".$output_format;\n        $class->_load_module($output_module);\n        $writer = $output_module->new(@args);\n        push(@args,\"-writer\",$writer);\n    }\n\n\n    # normalize capitalization to lower case\n    $format = \"\\L$format\";\n    \n    return unless( $class->_load_format_module($format) );\n    return \"Bio::SearchIO::${format}\"->new(@args);\n  }\n}\n\n=head2 newFh\n\n Title   : newFh\n Usage   : $fh = Bio::SearchIO->newFh(-file=>$filename,\n                                      -format=>'Format')\n Function: does a new() followed by an fh()\n Example : $fh = Bio::SearchIO->newFh(-file=>$filename,\n                                      -format=>'Format')\n           $result = <$fh>;   # read a ResultI object\n           print $fh $result; # write a ResultI object\n Returns : filehandle tied to the Bio::SearchIO::Fh class\n Args    :\n\n\nsub newFh {\n  my $class = shift;\n  return unless my $self = $class->new(@_);\n  return $self->fh;\n}\n\n=head2 fh\n\n Title   : fh\n Usage   : $obj->fh\n Function:\n Example : $fh = $obj->fh;      # make a tied filehandle\n           $result = <$fh>;     # read a ResultI object\n           print $fh $result;   # write a ResultI object\n Returns : filehandle tied to the Bio::SearchIO::Fh class\n Args    :\n\n\n\nsub fh {\n  my $self = shift;\n  my $class = ref($self) || $self;\n  my $s = Symbol::gensym;\n  tie $$s,$class,$self;\n  return $s;\n}\n\n=head2 attach_EventHandler\n\n Title   : attach_EventHandler\n Usage   : $parser->attatch_EventHandler($handler)\n Function: Adds an event handler to listen for events\n Returns : none\n Args    : Bio::SearchIO::EventHandlerI\n\nSee L<Bio::SearchIO::EventHandlerI>\n\n\nsub attach_EventHandler{\n    my ($self,$handler) = @_;\n    return if( ! $handler );\n    if( ! $handler->isa('Bio::SearchIO::EventHandlerI') ) {\n        $self->warn(\"Ignoring request to attatch handler \".ref($handler). ' because it is not a Bio::SearchIO::EventHandlerI');\n    }\n    $self->{'_handler'} = $handler;\n    return;\n}\n\n=head2 _eventHandler\n\n Title   : _eventHandler\n Usage   : private\n Function: Get the EventHandler\n Returns : Bio::SearchIO::EventHandlerI\n Args    : none\n\nSee L<Bio::SearchIO::EventHandlerI>\n\n\nsub _eventHandler{\n   my ($self) = @_;\n   return $self->{'_handler'};\n}\n\nsub _initialize {\n    my($self, @args) = @_;\n    $self->{'_handler'} = undef;\n    # not really necessary unless we put more in RootI\n    #$self->SUPER::_initialize(@args);\n\n    # initialize the IO part\n    $self->_initialize_io(@args);\n    $self->attach_EventHandler(Bio::SearchIO::SearchResultEventBuilder->new(@args));\n    $self->{'_reporttype'} = '';\n    $self->{_notfirsttime} = 0;\n    my ( $writer ) = $self->_rearrange([qw(WRITER)], @args);\n\n    $self->writer( $writer ) if $writer;\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : $result = stream->next_result\n Function: Reads the next ResultI object from the stream and returns it.\n\n           Certain driver modules may encounter entries in the stream that\n           are either misformatted or that use syntax not yet understood\n           by the driver. If such an incident is recoverable, e.g., by\n           dismissing a feature of a feature table or some other non-mandatory\n           part of an entry, the driver will issue a warning. In the case\n           of a non-recoverable situation an exception will be thrown.\n           Do not assume that you can resume parsing the same stream after\n           catching the exception. Note that you can always turn recoverable\n           errors into exceptions by calling $stream->verbose(2) (see\n           Bio::Root::RootI POD page).\n Returns : A Bio::Search::Result::ResultI object\n Args    : n/a\n\nSee L<Bio::Root::RootI>\n\n\nsub next_result {\n   my ($self) = @_;\n   $self->throw_not_implemented;\n}\n\n=head2 write_result\n\n Title   : write_result\n Usage   : $stream->write_result($result_result, @other_args)\n Function: Writes data from the $result_result object into the stream.\n         : Delegates to the to_string() method of the associated \n         : WriterI object.\n Returns : 1 for success and 0 for error\n Args    : Bio::Search:Result::ResultI object,\n         : plus any other arguments for the Writer\n Throws  : Bio::Root::Exception if a Writer has not been set.\n\nSee L<Bio::Root::Exception>","label":"write_result($self,$result,@args)"},"containerName":"main::","definition":"sub","line":335,"children":[{"kind":13,"line":336,"containerName":"write_result","name":"$self","definition":"my","localvar":"my"},{"name":"$result","containerName":"write_result","kind":13,"line":336},{"containerName":"write_result","name":"@args","kind":13,"line":336},{"name":"$self","containerName":"write_result","line":338,"kind":13},{"kind":13,"line":339,"name":"$self","containerName":"write_result"},{"containerName":"write_result","name":"throw","line":339,"kind":12},{"line":341,"kind":13,"containerName":"write_result","name":"@args"},{"kind":13,"line":341,"name":"$self","containerName":"write_result"},{"kind":13,"line":341,"containerName":"write_result","name":"@args"},{"line":343,"kind":13,"localvar":"my","containerName":"write_result","name":"$str","definition":"my"},{"containerName":"write_result","name":"$self","line":343,"kind":13},{"containerName":"write_result","name":"writer","line":343,"kind":12},{"name":"to_string","containerName":"write_result","kind":12,"line":343},{"containerName":"write_result","name":"$result","line":343,"kind":13},{"line":343,"kind":13,"name":"@args","containerName":"write_result"},{"containerName":"write_result","name":"$self","line":344,"kind":13},{"containerName":"write_result","name":"$self","line":345,"kind":13},{"line":345,"kind":12,"containerName":"write_result","name":"_print"},{"containerName":"write_result","name":"$str","kind":13,"line":345},{"line":347,"kind":13,"containerName":"write_result","name":"$self"},{"line":347,"kind":12,"name":"flush","containerName":"write_result"},{"kind":13,"line":347,"name":"$self","containerName":"write_result"},{"line":347,"kind":12,"containerName":"write_result","name":"_flush_on_write"},{"name":"$self","containerName":"write_result","kind":13,"line":347},{"line":347,"kind":12,"name":"_fh","containerName":"write_result"}],"kind":12,"range":{"end":{"line":349,"character":9999},"start":{"character":0,"line":335}},"name":"write_result"},{"children":[{"definition":"my","name":"$self","containerName":"write_report","localvar":"my","kind":13,"line":369},{"kind":13,"line":369,"containerName":"write_report","name":"$result"},{"kind":13,"line":369,"containerName":"write_report","name":"@args"},{"containerName":"write_report","name":"$self","kind":13,"line":371},{"line":372,"kind":13,"name":"$self","containerName":"write_report"},{"kind":12,"line":372,"name":"throw","containerName":"write_report"},{"kind":13,"line":374,"name":"@args","containerName":"write_report"},{"name":"$self","containerName":"write_report","line":374,"kind":13},{"kind":13,"line":374,"name":"@args","containerName":"write_report"},{"line":376,"kind":13,"localvar":"my","containerName":"write_report","name":"$str","definition":"my"},{"line":376,"kind":13,"containerName":"write_report","name":"$self"},{"kind":12,"line":376,"containerName":"write_report","name":"writer"},{"line":376,"kind":12,"containerName":"write_report","name":"to_string"},{"kind":13,"line":376,"containerName":"write_report","name":"$result"},{"kind":13,"line":376,"name":"@args","containerName":"write_report"},{"kind":13,"line":377,"name":"$self","containerName":"write_report"},{"name":"$self","containerName":"write_report","line":378,"kind":13},{"name":"_print","containerName":"write_report","line":378,"kind":12},{"line":378,"kind":13,"name":"$str","containerName":"write_report"},{"kind":13,"line":380,"containerName":"write_report","name":"$self"},{"kind":12,"line":380,"containerName":"write_report","name":"flush"},{"line":380,"kind":13,"containerName":"write_report","name":"$self"},{"containerName":"write_report","name":"_flush_on_write","kind":12,"line":380},{"kind":13,"line":380,"name":"$self","containerName":"write_report"},{"line":380,"kind":12,"containerName":"write_report","name":"_fh"}],"line":368,"kind":12,"signature":{"parameters":[{"label":"$self"},{"label":"$result"},{"label":"@args"}],"documentation":"__END__\n# $Id: SearchIO.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO - Driver for parsing Sequence Database Searches \n(BLAST, FASTA, ...)\n\n=head1 SYNOPSIS\n\n   use Bio::SearchIO;\n   # format can be 'fasta', 'blast', 'exonerate', ...\n   my $searchio = Bio::SearchIO->new( -format => 'blastxml',\n                                     -file   => 'blastout.xml' );\n   while ( my $result = $searchio->next_result() ) {\n       while( my $hit = $result->next_hit ) {\n        # process the Bio::Search::Hit::HitI object\n           while( my $hsp = $hit->next_hsp ) { \n            # process the Bio::Search::HSP::HSPI object\n           }\n       }\n   }\n\n\n=head1 DESCRIPTION\n\nThis is a driver for instantiating a parser for report files from\nsequence database searches. This object serves as a wrapper for the\nformat parsers in Bio::SearchIO::* - you should not need to ever\nuse those format parsers directly. (For people used to the SeqIO\nsystem it, we are deliberately using the same pattern).\n\nOnce you get a SearchIO object, calling next_result() gives you back\na L<Bio::Search::Result::ResultI> compliant object, which is an object that\nrepresents one Blast/Fasta/HMMER whatever report.\n\nA list of module names and formats is below:\n\n  blast      BLAST (WUBLAST, NCBIBLAST,bl2seq)   \n  fasta      FASTA -m9 and -m0\n  blasttable BLAST -m9 or -m8 output (both NCBI and WUBLAST tabular)\n  megablast  MEGABLAST\n  psl        UCSC PSL format\n  waba       WABA output\n  axt        AXT format\n  sim4       Sim4\n  hmmer      HMMER hmmpfam and hmmsearch\n  exonerate  Exonerate CIGAR and VULGAR format\n  blastxml   NCBI BLAST XML\n  wise       Genewise -genesf format\n\nAlso see the SearchIO HOWTO:\nhttp://bioperl.open-bio.org/wiki/HOWTO:SearchIO\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich & Steve Chervitz\n\nEmail jason-at-bioperl.org\nEmail sac-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::IO\n\nuse Bio::SearchIO::SearchResultEventBuilder;\n\n# Special exception class for exceptions during parsing.\n# End users should not ever see these.\n# For an example of usage, see blast.pm.\n@Bio::SearchIO::InternalParserError::ISA = qw(Bio::Root::Exception);\n\nuse Symbol;\n\nuse base qw(Bio::Root::IO Bio::Event::EventGeneratorI Bio::AnalysisParserI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO->new();\n Function: Builds a new Bio::SearchIO object \n Returns : Bio::SearchIO initialized with the correct format\n Args    : -file           => $filename\n           -format         => format\n           -fh             => filehandle to attach to\n           -result_factory => Object implementing Bio::Factory::ObjectFactoryI\n           -hit_factory    => Object implementing Bio::Factory::ObjectFactoryI\n           -hsp_factory    => Object implementing Bio::Factory::ObjectFactoryI\n           -writer         => Object implementing Bio::SearchIO::SearchWriterI\n           -output_format  => output format, which will dynamically load writer\n\nSee L<Bio::Factory::ObjectFactoryI>, L<Bio::SearchIO::SearchWriterI>\n\nAny factory objects in the arguments are passed along to the\nSearchResultEventBuilder object which holds these factories and sets\ndefault ones if none are supplied as arguments.\n\n\nsub new {\n  my($caller,@args) = @_;\n  my $class = ref($caller) || $caller;\n    \n  # or do we want to call SUPER on an object if $caller is an\n  # object?\n  if( $class =~ /Bio::SearchIO::(\\S+)/ ) {\n    my ($self) = $class->SUPER::new(@args);        \n    $self->_initialize(@args);\n    return $self;\n  } else { \n    my %param = @args;\n    @param{ map { lc $_ } keys %param } = values %param; # lowercase keys\n    my $format = $param{'-format'} ||\n      $class->_guess_format( $param{'-file'} || $ARGV[0] ) || 'blast';\n\n    my $output_format = $param{'-output_format'};\n    my $writer = undef;\n\n    if( defined $output_format ) {\n        if( defined $param{'-writer'} ) {\n            my $dummy = Bio::Root::Root->new();\n            $dummy->throw(\"Both writer and output format specified - not good\");\n        }\n\n        if( $output_format =~ /^blast$/i ) {\n            $output_format = 'TextResultWriter';\n        }\n        my $output_module = \"Bio::SearchIO::Writer::\".$output_format;\n        $class->_load_module($output_module);\n        $writer = $output_module->new(@args);\n        push(@args,\"-writer\",$writer);\n    }\n\n\n    # normalize capitalization to lower case\n    $format = \"\\L$format\";\n    \n    return unless( $class->_load_format_module($format) );\n    return \"Bio::SearchIO::${format}\"->new(@args);\n  }\n}\n\n=head2 newFh\n\n Title   : newFh\n Usage   : $fh = Bio::SearchIO->newFh(-file=>$filename,\n                                      -format=>'Format')\n Function: does a new() followed by an fh()\n Example : $fh = Bio::SearchIO->newFh(-file=>$filename,\n                                      -format=>'Format')\n           $result = <$fh>;   # read a ResultI object\n           print $fh $result; # write a ResultI object\n Returns : filehandle tied to the Bio::SearchIO::Fh class\n Args    :\n\n\nsub newFh {\n  my $class = shift;\n  return unless my $self = $class->new(@_);\n  return $self->fh;\n}\n\n=head2 fh\n\n Title   : fh\n Usage   : $obj->fh\n Function:\n Example : $fh = $obj->fh;      # make a tied filehandle\n           $result = <$fh>;     # read a ResultI object\n           print $fh $result;   # write a ResultI object\n Returns : filehandle tied to the Bio::SearchIO::Fh class\n Args    :\n\n\n\nsub fh {\n  my $self = shift;\n  my $class = ref($self) || $self;\n  my $s = Symbol::gensym;\n  tie $$s,$class,$self;\n  return $s;\n}\n\n=head2 attach_EventHandler\n\n Title   : attach_EventHandler\n Usage   : $parser->attatch_EventHandler($handler)\n Function: Adds an event handler to listen for events\n Returns : none\n Args    : Bio::SearchIO::EventHandlerI\n\nSee L<Bio::SearchIO::EventHandlerI>\n\n\nsub attach_EventHandler{\n    my ($self,$handler) = @_;\n    return if( ! $handler );\n    if( ! $handler->isa('Bio::SearchIO::EventHandlerI') ) {\n        $self->warn(\"Ignoring request to attatch handler \".ref($handler). ' because it is not a Bio::SearchIO::EventHandlerI');\n    }\n    $self->{'_handler'} = $handler;\n    return;\n}\n\n=head2 _eventHandler\n\n Title   : _eventHandler\n Usage   : private\n Function: Get the EventHandler\n Returns : Bio::SearchIO::EventHandlerI\n Args    : none\n\nSee L<Bio::SearchIO::EventHandlerI>\n\n\nsub _eventHandler{\n   my ($self) = @_;\n   return $self->{'_handler'};\n}\n\nsub _initialize {\n    my($self, @args) = @_;\n    $self->{'_handler'} = undef;\n    # not really necessary unless we put more in RootI\n    #$self->SUPER::_initialize(@args);\n\n    # initialize the IO part\n    $self->_initialize_io(@args);\n    $self->attach_EventHandler(Bio::SearchIO::SearchResultEventBuilder->new(@args));\n    $self->{'_reporttype'} = '';\n    $self->{_notfirsttime} = 0;\n    my ( $writer ) = $self->_rearrange([qw(WRITER)], @args);\n\n    $self->writer( $writer ) if $writer;\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : $result = stream->next_result\n Function: Reads the next ResultI object from the stream and returns it.\n\n           Certain driver modules may encounter entries in the stream that\n           are either misformatted or that use syntax not yet understood\n           by the driver. If such an incident is recoverable, e.g., by\n           dismissing a feature of a feature table or some other non-mandatory\n           part of an entry, the driver will issue a warning. In the case\n           of a non-recoverable situation an exception will be thrown.\n           Do not assume that you can resume parsing the same stream after\n           catching the exception. Note that you can always turn recoverable\n           errors into exceptions by calling $stream->verbose(2) (see\n           Bio::Root::RootI POD page).\n Returns : A Bio::Search::Result::ResultI object\n Args    : n/a\n\nSee L<Bio::Root::RootI>\n\n\nsub next_result {\n   my ($self) = @_;\n   $self->throw_not_implemented;\n}\n\n=head2 write_result\n\n Title   : write_result\n Usage   : $stream->write_result($result_result, @other_args)\n Function: Writes data from the $result_result object into the stream.\n         : Delegates to the to_string() method of the associated \n         : WriterI object.\n Returns : 1 for success and 0 for error\n Args    : Bio::Search:Result::ResultI object,\n         : plus any other arguments for the Writer\n Throws  : Bio::Root::Exception if a Writer has not been set.\n\nSee L<Bio::Root::Exception>\n\n\nsub write_result {\n   my ($self, $result, @args) = @_;\n\n   if( not ref($self->{'_result_writer'}) ) {\n       $self->throw(\"ResultWriter not defined.\");\n   }\n   @args = $self->{'_notfirsttime'} unless( @args );\n\n   my $str = $self->writer->to_string( $result, @args);\n   $self->{'_notfirsttime'} = 1;\n   $self->_print( \"$str\" ) if defined $str;\n   \n   $self->flush if $self->_flush_on_write && defined $self->_fh;\n   return 1;\n}\n\n=head2 write_report\n\n Title   : write_report\n Usage   : $stream->write_report(SearchIO stream, @other_args)\n Function: Writes data directly from the SearchIO stream object into the\n         : writer.  This is mainly useful if one has multiple ResultI objects\n         : in a SearchIO stream and you don't want to reiterate header/footer\n         : between each call.\n Returns : 1 for success and 0 for error\n Args    : Bio::SearchIO stream object,\n         : plus any other arguments for the Writer\n Throws  : Bio::Root::Exception if a Writer has not been set.\n\nSee L<Bio::Root::Exception>","label":"write_report($self,$result,@args)"},"detail":"($self,$result,@args)","definition":"sub","containerName":"main::","range":{"end":{"character":9999,"line":382},"start":{"line":368,"character":0}},"name":"write_report"},{"containerName":"main::","definition":"sub","detail":"($self,$writer)","signature":{"documentation":"__END__\n# $Id: SearchIO.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO - Driver for parsing Sequence Database Searches \n(BLAST, FASTA, ...)\n\n=head1 SYNOPSIS\n\n   use Bio::SearchIO;\n   # format can be 'fasta', 'blast', 'exonerate', ...\n   my $searchio = Bio::SearchIO->new( -format => 'blastxml',\n                                     -file   => 'blastout.xml' );\n   while ( my $result = $searchio->next_result() ) {\n       while( my $hit = $result->next_hit ) {\n        # process the Bio::Search::Hit::HitI object\n           while( my $hsp = $hit->next_hsp ) { \n            # process the Bio::Search::HSP::HSPI object\n           }\n       }\n   }\n\n\n=head1 DESCRIPTION\n\nThis is a driver for instantiating a parser for report files from\nsequence database searches. This object serves as a wrapper for the\nformat parsers in Bio::SearchIO::* - you should not need to ever\nuse those format parsers directly. (For people used to the SeqIO\nsystem it, we are deliberately using the same pattern).\n\nOnce you get a SearchIO object, calling next_result() gives you back\na L<Bio::Search::Result::ResultI> compliant object, which is an object that\nrepresents one Blast/Fasta/HMMER whatever report.\n\nA list of module names and formats is below:\n\n  blast      BLAST (WUBLAST, NCBIBLAST,bl2seq)   \n  fasta      FASTA -m9 and -m0\n  blasttable BLAST -m9 or -m8 output (both NCBI and WUBLAST tabular)\n  megablast  MEGABLAST\n  psl        UCSC PSL format\n  waba       WABA output\n  axt        AXT format\n  sim4       Sim4\n  hmmer      HMMER hmmpfam and hmmsearch\n  exonerate  Exonerate CIGAR and VULGAR format\n  blastxml   NCBI BLAST XML\n  wise       Genewise -genesf format\n\nAlso see the SearchIO HOWTO:\nhttp://bioperl.open-bio.org/wiki/HOWTO:SearchIO\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich & Steve Chervitz\n\nEmail jason-at-bioperl.org\nEmail sac-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::IO\n\nuse Bio::SearchIO::SearchResultEventBuilder;\n\n# Special exception class for exceptions during parsing.\n# End users should not ever see these.\n# For an example of usage, see blast.pm.\n@Bio::SearchIO::InternalParserError::ISA = qw(Bio::Root::Exception);\n\nuse Symbol;\n\nuse base qw(Bio::Root::IO Bio::Event::EventGeneratorI Bio::AnalysisParserI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO->new();\n Function: Builds a new Bio::SearchIO object \n Returns : Bio::SearchIO initialized with the correct format\n Args    : -file           => $filename\n           -format         => format\n           -fh             => filehandle to attach to\n           -result_factory => Object implementing Bio::Factory::ObjectFactoryI\n           -hit_factory    => Object implementing Bio::Factory::ObjectFactoryI\n           -hsp_factory    => Object implementing Bio::Factory::ObjectFactoryI\n           -writer         => Object implementing Bio::SearchIO::SearchWriterI\n           -output_format  => output format, which will dynamically load writer\n\nSee L<Bio::Factory::ObjectFactoryI>, L<Bio::SearchIO::SearchWriterI>\n\nAny factory objects in the arguments are passed along to the\nSearchResultEventBuilder object which holds these factories and sets\ndefault ones if none are supplied as arguments.\n\n\nsub new {\n  my($caller,@args) = @_;\n  my $class = ref($caller) || $caller;\n    \n  # or do we want to call SUPER on an object if $caller is an\n  # object?\n  if( $class =~ /Bio::SearchIO::(\\S+)/ ) {\n    my ($self) = $class->SUPER::new(@args);        \n    $self->_initialize(@args);\n    return $self;\n  } else { \n    my %param = @args;\n    @param{ map { lc $_ } keys %param } = values %param; # lowercase keys\n    my $format = $param{'-format'} ||\n      $class->_guess_format( $param{'-file'} || $ARGV[0] ) || 'blast';\n\n    my $output_format = $param{'-output_format'};\n    my $writer = undef;\n\n    if( defined $output_format ) {\n        if( defined $param{'-writer'} ) {\n            my $dummy = Bio::Root::Root->new();\n            $dummy->throw(\"Both writer and output format specified - not good\");\n        }\n\n        if( $output_format =~ /^blast$/i ) {\n            $output_format = 'TextResultWriter';\n        }\n        my $output_module = \"Bio::SearchIO::Writer::\".$output_format;\n        $class->_load_module($output_module);\n        $writer = $output_module->new(@args);\n        push(@args,\"-writer\",$writer);\n    }\n\n\n    # normalize capitalization to lower case\n    $format = \"\\L$format\";\n    \n    return unless( $class->_load_format_module($format) );\n    return \"Bio::SearchIO::${format}\"->new(@args);\n  }\n}\n\n=head2 newFh\n\n Title   : newFh\n Usage   : $fh = Bio::SearchIO->newFh(-file=>$filename,\n                                      -format=>'Format')\n Function: does a new() followed by an fh()\n Example : $fh = Bio::SearchIO->newFh(-file=>$filename,\n                                      -format=>'Format')\n           $result = <$fh>;   # read a ResultI object\n           print $fh $result; # write a ResultI object\n Returns : filehandle tied to the Bio::SearchIO::Fh class\n Args    :\n\n\nsub newFh {\n  my $class = shift;\n  return unless my $self = $class->new(@_);\n  return $self->fh;\n}\n\n=head2 fh\n\n Title   : fh\n Usage   : $obj->fh\n Function:\n Example : $fh = $obj->fh;      # make a tied filehandle\n           $result = <$fh>;     # read a ResultI object\n           print $fh $result;   # write a ResultI object\n Returns : filehandle tied to the Bio::SearchIO::Fh class\n Args    :\n\n\n\nsub fh {\n  my $self = shift;\n  my $class = ref($self) || $self;\n  my $s = Symbol::gensym;\n  tie $$s,$class,$self;\n  return $s;\n}\n\n=head2 attach_EventHandler\n\n Title   : attach_EventHandler\n Usage   : $parser->attatch_EventHandler($handler)\n Function: Adds an event handler to listen for events\n Returns : none\n Args    : Bio::SearchIO::EventHandlerI\n\nSee L<Bio::SearchIO::EventHandlerI>\n\n\nsub attach_EventHandler{\n    my ($self,$handler) = @_;\n    return if( ! $handler );\n    if( ! $handler->isa('Bio::SearchIO::EventHandlerI') ) {\n        $self->warn(\"Ignoring request to attatch handler \".ref($handler). ' because it is not a Bio::SearchIO::EventHandlerI');\n    }\n    $self->{'_handler'} = $handler;\n    return;\n}\n\n=head2 _eventHandler\n\n Title   : _eventHandler\n Usage   : private\n Function: Get the EventHandler\n Returns : Bio::SearchIO::EventHandlerI\n Args    : none\n\nSee L<Bio::SearchIO::EventHandlerI>\n\n\nsub _eventHandler{\n   my ($self) = @_;\n   return $self->{'_handler'};\n}\n\nsub _initialize {\n    my($self, @args) = @_;\n    $self->{'_handler'} = undef;\n    # not really necessary unless we put more in RootI\n    #$self->SUPER::_initialize(@args);\n\n    # initialize the IO part\n    $self->_initialize_io(@args);\n    $self->attach_EventHandler(Bio::SearchIO::SearchResultEventBuilder->new(@args));\n    $self->{'_reporttype'} = '';\n    $self->{_notfirsttime} = 0;\n    my ( $writer ) = $self->_rearrange([qw(WRITER)], @args);\n\n    $self->writer( $writer ) if $writer;\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : $result = stream->next_result\n Function: Reads the next ResultI object from the stream and returns it.\n\n           Certain driver modules may encounter entries in the stream that\n           are either misformatted or that use syntax not yet understood\n           by the driver. If such an incident is recoverable, e.g., by\n           dismissing a feature of a feature table or some other non-mandatory\n           part of an entry, the driver will issue a warning. In the case\n           of a non-recoverable situation an exception will be thrown.\n           Do not assume that you can resume parsing the same stream after\n           catching the exception. Note that you can always turn recoverable\n           errors into exceptions by calling $stream->verbose(2) (see\n           Bio::Root::RootI POD page).\n Returns : A Bio::Search::Result::ResultI object\n Args    : n/a\n\nSee L<Bio::Root::RootI>\n\n\nsub next_result {\n   my ($self) = @_;\n   $self->throw_not_implemented;\n}\n\n=head2 write_result\n\n Title   : write_result\n Usage   : $stream->write_result($result_result, @other_args)\n Function: Writes data from the $result_result object into the stream.\n         : Delegates to the to_string() method of the associated \n         : WriterI object.\n Returns : 1 for success and 0 for error\n Args    : Bio::Search:Result::ResultI object,\n         : plus any other arguments for the Writer\n Throws  : Bio::Root::Exception if a Writer has not been set.\n\nSee L<Bio::Root::Exception>\n\n\nsub write_result {\n   my ($self, $result, @args) = @_;\n\n   if( not ref($self->{'_result_writer'}) ) {\n       $self->throw(\"ResultWriter not defined.\");\n   }\n   @args = $self->{'_notfirsttime'} unless( @args );\n\n   my $str = $self->writer->to_string( $result, @args);\n   $self->{'_notfirsttime'} = 1;\n   $self->_print( \"$str\" ) if defined $str;\n   \n   $self->flush if $self->_flush_on_write && defined $self->_fh;\n   return 1;\n}\n\n=head2 write_report\n\n Title   : write_report\n Usage   : $stream->write_report(SearchIO stream, @other_args)\n Function: Writes data directly from the SearchIO stream object into the\n         : writer.  This is mainly useful if one has multiple ResultI objects\n         : in a SearchIO stream and you don't want to reiterate header/footer\n         : between each call.\n Returns : 1 for success and 0 for error\n Args    : Bio::SearchIO stream object,\n         : plus any other arguments for the Writer\n Throws  : Bio::Root::Exception if a Writer has not been set.\n\nSee L<Bio::Root::Exception>\n\n\nsub write_report {\n   my ($self, $result, @args) = @_;\n\n   if( not ref($self->{'_result_writer'}) ) {\n       $self->throw(\"ResultWriter not defined.\");\n   }\n   @args = $self->{'_notfirsttime'} unless( @args );\n\n   my $str = $self->writer->to_string( $result, @args);\n   $self->{'_notfirsttime'} = 1;\n   $self->_print( \"$str\" ) if defined $str;\n   \n   $self->flush if $self->_flush_on_write && defined $self->_fh;\n   return 1;\n}\n\n\n=head2 writer\n\n Title   : writer\n Usage   : $writer = $stream->writer;\n Function: Sets/Gets a SearchWriterI object to be used for this searchIO.\n Returns : 1 for success and 0 for error\n Args    : Bio::SearchIO::SearchWriterI object (when setting)\n Throws  : Bio::Root::Exception if a non-Bio::SearchIO::SearchWriterI object\n           is passed in.","parameters":[{"label":"$self"},{"label":"$writer"}],"label":"writer($self,$writer)"},"kind":12,"line":397,"children":[{"definition":"my","name":"$self","containerName":"writer","localvar":"my","kind":13,"line":398},{"kind":13,"line":398,"containerName":"writer","name":"$writer"},{"line":399,"kind":13,"containerName":"writer","name":"$writer"},{"kind":13,"line":399,"name":"$writer","containerName":"writer"},{"containerName":"writer","name":"isa","line":399,"kind":12},{"kind":13,"line":400,"name":"$self","containerName":"writer"},{"kind":13,"line":400,"name":"$writer","containerName":"writer"},{"kind":13,"line":402,"containerName":"writer","name":"$writer"},{"kind":13,"line":403,"containerName":"writer","name":"$self"},{"containerName":"writer","name":"throw","kind":12,"line":403},{"name":"$self","containerName":"writer","line":405,"kind":13}],"name":"writer","range":{"start":{"line":397,"character":0},"end":{"line":406,"character":9999}}},{"range":{"start":{"line":422,"character":0},"end":{"line":425,"character":9999}},"definition":"sub","name":"result_count","containerName":"main::","children":[{"line":423,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"result_count"},{"kind":13,"line":424,"containerName":"result_count","name":"$self"},{"name":"throw_not_implemented","containerName":"result_count","line":424,"kind":12}],"line":422,"kind":12},{"name":"_load_format_module","range":{"start":{"line":439,"character":0},"end":{"character":9999,"line":457}},"kind":12,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"_load_format_module","line":440,"kind":13},{"line":440,"kind":13,"containerName":"_load_format_module","name":"$format"},{"kind":13,"line":441,"definition":"my","name":"$module","containerName":"_load_format_module","localvar":"my"},{"name":"$format","containerName":"_load_format_module","kind":13,"line":441},{"localvar":"my","name":"$ok","definition":"my","containerName":"_load_format_module","line":442,"kind":13},{"line":445,"kind":13,"name":"$ok","containerName":"_load_format_module"},{"line":445,"kind":13,"name":"$self","containerName":"_load_format_module"},{"containerName":"_load_format_module","name":"_load_module","kind":12,"line":445},{"containerName":"_load_format_module","name":"$module","line":445,"kind":13},{"kind":13,"line":456,"containerName":"_load_format_module","name":"$ok"}],"line":439,"definition":"sub","containerName":"main::","signature":{"label":"_load_format_module($self,$format)","documentation":"__END__\n# $Id: SearchIO.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO - Driver for parsing Sequence Database Searches \n(BLAST, FASTA, ...)\n\n=head1 SYNOPSIS\n\n   use Bio::SearchIO;\n   # format can be 'fasta', 'blast', 'exonerate', ...\n   my $searchio = Bio::SearchIO->new( -format => 'blastxml',\n                                     -file   => 'blastout.xml' );\n   while ( my $result = $searchio->next_result() ) {\n       while( my $hit = $result->next_hit ) {\n        # process the Bio::Search::Hit::HitI object\n           while( my $hsp = $hit->next_hsp ) { \n            # process the Bio::Search::HSP::HSPI object\n           }\n       }\n   }\n\n\n=head1 DESCRIPTION\n\nThis is a driver for instantiating a parser for report files from\nsequence database searches. This object serves as a wrapper for the\nformat parsers in Bio::SearchIO::* - you should not need to ever\nuse those format parsers directly. (For people used to the SeqIO\nsystem it, we are deliberately using the same pattern).\n\nOnce you get a SearchIO object, calling next_result() gives you back\na L<Bio::Search::Result::ResultI> compliant object, which is an object that\nrepresents one Blast/Fasta/HMMER whatever report.\n\nA list of module names and formats is below:\n\n  blast      BLAST (WUBLAST, NCBIBLAST,bl2seq)   \n  fasta      FASTA -m9 and -m0\n  blasttable BLAST -m9 or -m8 output (both NCBI and WUBLAST tabular)\n  megablast  MEGABLAST\n  psl        UCSC PSL format\n  waba       WABA output\n  axt        AXT format\n  sim4       Sim4\n  hmmer      HMMER hmmpfam and hmmsearch\n  exonerate  Exonerate CIGAR and VULGAR format\n  blastxml   NCBI BLAST XML\n  wise       Genewise -genesf format\n\nAlso see the SearchIO HOWTO:\nhttp://bioperl.open-bio.org/wiki/HOWTO:SearchIO\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich & Steve Chervitz\n\nEmail jason-at-bioperl.org\nEmail sac-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::IO\n\nuse Bio::SearchIO::SearchResultEventBuilder;\n\n# Special exception class for exceptions during parsing.\n# End users should not ever see these.\n# For an example of usage, see blast.pm.\n@Bio::SearchIO::InternalParserError::ISA = qw(Bio::Root::Exception);\n\nuse Symbol;\n\nuse base qw(Bio::Root::IO Bio::Event::EventGeneratorI Bio::AnalysisParserI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO->new();\n Function: Builds a new Bio::SearchIO object \n Returns : Bio::SearchIO initialized with the correct format\n Args    : -file           => $filename\n           -format         => format\n           -fh             => filehandle to attach to\n           -result_factory => Object implementing Bio::Factory::ObjectFactoryI\n           -hit_factory    => Object implementing Bio::Factory::ObjectFactoryI\n           -hsp_factory    => Object implementing Bio::Factory::ObjectFactoryI\n           -writer         => Object implementing Bio::SearchIO::SearchWriterI\n           -output_format  => output format, which will dynamically load writer\n\nSee L<Bio::Factory::ObjectFactoryI>, L<Bio::SearchIO::SearchWriterI>\n\nAny factory objects in the arguments are passed along to the\nSearchResultEventBuilder object which holds these factories and sets\ndefault ones if none are supplied as arguments.\n\n\nsub new {\n  my($caller,@args) = @_;\n  my $class = ref($caller) || $caller;\n    \n  # or do we want to call SUPER on an object if $caller is an\n  # object?\n  if( $class =~ /Bio::SearchIO::(\\S+)/ ) {\n    my ($self) = $class->SUPER::new(@args);        \n    $self->_initialize(@args);\n    return $self;\n  } else { \n    my %param = @args;\n    @param{ map { lc $_ } keys %param } = values %param; # lowercase keys\n    my $format = $param{'-format'} ||\n      $class->_guess_format( $param{'-file'} || $ARGV[0] ) || 'blast';\n\n    my $output_format = $param{'-output_format'};\n    my $writer = undef;\n\n    if( defined $output_format ) {\n        if( defined $param{'-writer'} ) {\n            my $dummy = Bio::Root::Root->new();\n            $dummy->throw(\"Both writer and output format specified - not good\");\n        }\n\n        if( $output_format =~ /^blast$/i ) {\n            $output_format = 'TextResultWriter';\n        }\n        my $output_module = \"Bio::SearchIO::Writer::\".$output_format;\n        $class->_load_module($output_module);\n        $writer = $output_module->new(@args);\n        push(@args,\"-writer\",$writer);\n    }\n\n\n    # normalize capitalization to lower case\n    $format = \"\\L$format\";\n    \n    return unless( $class->_load_format_module($format) );\n    return \"Bio::SearchIO::${format}\"->new(@args);\n  }\n}\n\n=head2 newFh\n\n Title   : newFh\n Usage   : $fh = Bio::SearchIO->newFh(-file=>$filename,\n                                      -format=>'Format')\n Function: does a new() followed by an fh()\n Example : $fh = Bio::SearchIO->newFh(-file=>$filename,\n                                      -format=>'Format')\n           $result = <$fh>;   # read a ResultI object\n           print $fh $result; # write a ResultI object\n Returns : filehandle tied to the Bio::SearchIO::Fh class\n Args    :\n\n\nsub newFh {\n  my $class = shift;\n  return unless my $self = $class->new(@_);\n  return $self->fh;\n}\n\n=head2 fh\n\n Title   : fh\n Usage   : $obj->fh\n Function:\n Example : $fh = $obj->fh;      # make a tied filehandle\n           $result = <$fh>;     # read a ResultI object\n           print $fh $result;   # write a ResultI object\n Returns : filehandle tied to the Bio::SearchIO::Fh class\n Args    :\n\n\n\nsub fh {\n  my $self = shift;\n  my $class = ref($self) || $self;\n  my $s = Symbol::gensym;\n  tie $$s,$class,$self;\n  return $s;\n}\n\n=head2 attach_EventHandler\n\n Title   : attach_EventHandler\n Usage   : $parser->attatch_EventHandler($handler)\n Function: Adds an event handler to listen for events\n Returns : none\n Args    : Bio::SearchIO::EventHandlerI\n\nSee L<Bio::SearchIO::EventHandlerI>\n\n\nsub attach_EventHandler{\n    my ($self,$handler) = @_;\n    return if( ! $handler );\n    if( ! $handler->isa('Bio::SearchIO::EventHandlerI') ) {\n        $self->warn(\"Ignoring request to attatch handler \".ref($handler). ' because it is not a Bio::SearchIO::EventHandlerI');\n    }\n    $self->{'_handler'} = $handler;\n    return;\n}\n\n=head2 _eventHandler\n\n Title   : _eventHandler\n Usage   : private\n Function: Get the EventHandler\n Returns : Bio::SearchIO::EventHandlerI\n Args    : none\n\nSee L<Bio::SearchIO::EventHandlerI>\n\n\nsub _eventHandler{\n   my ($self) = @_;\n   return $self->{'_handler'};\n}\n\nsub _initialize {\n    my($self, @args) = @_;\n    $self->{'_handler'} = undef;\n    # not really necessary unless we put more in RootI\n    #$self->SUPER::_initialize(@args);\n\n    # initialize the IO part\n    $self->_initialize_io(@args);\n    $self->attach_EventHandler(Bio::SearchIO::SearchResultEventBuilder->new(@args));\n    $self->{'_reporttype'} = '';\n    $self->{_notfirsttime} = 0;\n    my ( $writer ) = $self->_rearrange([qw(WRITER)], @args);\n\n    $self->writer( $writer ) if $writer;\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : $result = stream->next_result\n Function: Reads the next ResultI object from the stream and returns it.\n\n           Certain driver modules may encounter entries in the stream that\n           are either misformatted or that use syntax not yet understood\n           by the driver. If such an incident is recoverable, e.g., by\n           dismissing a feature of a feature table or some other non-mandatory\n           part of an entry, the driver will issue a warning. In the case\n           of a non-recoverable situation an exception will be thrown.\n           Do not assume that you can resume parsing the same stream after\n           catching the exception. Note that you can always turn recoverable\n           errors into exceptions by calling $stream->verbose(2) (see\n           Bio::Root::RootI POD page).\n Returns : A Bio::Search::Result::ResultI object\n Args    : n/a\n\nSee L<Bio::Root::RootI>\n\n\nsub next_result {\n   my ($self) = @_;\n   $self->throw_not_implemented;\n}\n\n=head2 write_result\n\n Title   : write_result\n Usage   : $stream->write_result($result_result, @other_args)\n Function: Writes data from the $result_result object into the stream.\n         : Delegates to the to_string() method of the associated \n         : WriterI object.\n Returns : 1 for success and 0 for error\n Args    : Bio::Search:Result::ResultI object,\n         : plus any other arguments for the Writer\n Throws  : Bio::Root::Exception if a Writer has not been set.\n\nSee L<Bio::Root::Exception>\n\n\nsub write_result {\n   my ($self, $result, @args) = @_;\n\n   if( not ref($self->{'_result_writer'}) ) {\n       $self->throw(\"ResultWriter not defined.\");\n   }\n   @args = $self->{'_notfirsttime'} unless( @args );\n\n   my $str = $self->writer->to_string( $result, @args);\n   $self->{'_notfirsttime'} = 1;\n   $self->_print( \"$str\" ) if defined $str;\n   \n   $self->flush if $self->_flush_on_write && defined $self->_fh;\n   return 1;\n}\n\n=head2 write_report\n\n Title   : write_report\n Usage   : $stream->write_report(SearchIO stream, @other_args)\n Function: Writes data directly from the SearchIO stream object into the\n         : writer.  This is mainly useful if one has multiple ResultI objects\n         : in a SearchIO stream and you don't want to reiterate header/footer\n         : between each call.\n Returns : 1 for success and 0 for error\n Args    : Bio::SearchIO stream object,\n         : plus any other arguments for the Writer\n Throws  : Bio::Root::Exception if a Writer has not been set.\n\nSee L<Bio::Root::Exception>\n\n\nsub write_report {\n   my ($self, $result, @args) = @_;\n\n   if( not ref($self->{'_result_writer'}) ) {\n       $self->throw(\"ResultWriter not defined.\");\n   }\n   @args = $self->{'_notfirsttime'} unless( @args );\n\n   my $str = $self->writer->to_string( $result, @args);\n   $self->{'_notfirsttime'} = 1;\n   $self->_print( \"$str\" ) if defined $str;\n   \n   $self->flush if $self->_flush_on_write && defined $self->_fh;\n   return 1;\n}\n\n\n=head2 writer\n\n Title   : writer\n Usage   : $writer = $stream->writer;\n Function: Sets/Gets a SearchWriterI object to be used for this searchIO.\n Returns : 1 for success and 0 for error\n Args    : Bio::SearchIO::SearchWriterI object (when setting)\n Throws  : Bio::Root::Exception if a non-Bio::SearchIO::SearchWriterI object\n           is passed in.\n\n\nsub writer {\n    my ($self, $writer) = @_;\n    if( ref($writer) and $writer->isa( 'Bio::SearchIO::SearchWriterI' )) {\n        $self->{'_result_writer'} = $writer;\n    }\n    elsif( defined $writer ) {\n        $self->throw(\"Can't set ResultWriter. Not a Bio::SearchIO::SearchWriterI: $writer\");\n    }\n    return $self->{'_result_writer'};\n}\n\n\n=head2 result_count\n\n Title   : result_count\n Usage   : $num = $stream->result_count;\n Function: Gets the number of Blast results that have been successfully parsed\n           at the point of the method call.  This is not the total # of results\n           in the file.\n Returns : integer\n Args    : none\n Throws  : none\n\n\nsub result_count {\n    my $self = shift;\n    $self->throw_not_implemented;\n}\n\n\n=head2 _load_format_module\n\n Title   : _load_format_module\n Usage   : *INTERNAL SearchIO stuff*\n Function: Loads up (like use) a module at run time on demand\n Example : \n Returns : \n Args    : ","parameters":[{"label":"$self"},{"label":"$format"}]},"detail":"($self,$format)"},{"range":{"start":{"character":0,"line":471},"end":{"character":9999,"line":505}},"name":"_get_seq_identifiers","detail":"($self,$id)","signature":{"label":"_get_seq_identifiers($self,$id)","documentation":"__END__\n# $Id: SearchIO.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO - Driver for parsing Sequence Database Searches \n(BLAST, FASTA, ...)\n\n=head1 SYNOPSIS\n\n   use Bio::SearchIO;\n   # format can be 'fasta', 'blast', 'exonerate', ...\n   my $searchio = Bio::SearchIO->new( -format => 'blastxml',\n                                     -file   => 'blastout.xml' );\n   while ( my $result = $searchio->next_result() ) {\n       while( my $hit = $result->next_hit ) {\n        # process the Bio::Search::Hit::HitI object\n           while( my $hsp = $hit->next_hsp ) { \n            # process the Bio::Search::HSP::HSPI object\n           }\n       }\n   }\n\n\n=head1 DESCRIPTION\n\nThis is a driver for instantiating a parser for report files from\nsequence database searches. This object serves as a wrapper for the\nformat parsers in Bio::SearchIO::* - you should not need to ever\nuse those format parsers directly. (For people used to the SeqIO\nsystem it, we are deliberately using the same pattern).\n\nOnce you get a SearchIO object, calling next_result() gives you back\na L<Bio::Search::Result::ResultI> compliant object, which is an object that\nrepresents one Blast/Fasta/HMMER whatever report.\n\nA list of module names and formats is below:\n\n  blast      BLAST (WUBLAST, NCBIBLAST,bl2seq)   \n  fasta      FASTA -m9 and -m0\n  blasttable BLAST -m9 or -m8 output (both NCBI and WUBLAST tabular)\n  megablast  MEGABLAST\n  psl        UCSC PSL format\n  waba       WABA output\n  axt        AXT format\n  sim4       Sim4\n  hmmer      HMMER hmmpfam and hmmsearch\n  exonerate  Exonerate CIGAR and VULGAR format\n  blastxml   NCBI BLAST XML\n  wise       Genewise -genesf format\n\nAlso see the SearchIO HOWTO:\nhttp://bioperl.open-bio.org/wiki/HOWTO:SearchIO\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich & Steve Chervitz\n\nEmail jason-at-bioperl.org\nEmail sac-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::IO\n\nuse Bio::SearchIO::SearchResultEventBuilder;\n\n# Special exception class for exceptions during parsing.\n# End users should not ever see these.\n# For an example of usage, see blast.pm.\n@Bio::SearchIO::InternalParserError::ISA = qw(Bio::Root::Exception);\n\nuse Symbol;\n\nuse base qw(Bio::Root::IO Bio::Event::EventGeneratorI Bio::AnalysisParserI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO->new();\n Function: Builds a new Bio::SearchIO object \n Returns : Bio::SearchIO initialized with the correct format\n Args    : -file           => $filename\n           -format         => format\n           -fh             => filehandle to attach to\n           -result_factory => Object implementing Bio::Factory::ObjectFactoryI\n           -hit_factory    => Object implementing Bio::Factory::ObjectFactoryI\n           -hsp_factory    => Object implementing Bio::Factory::ObjectFactoryI\n           -writer         => Object implementing Bio::SearchIO::SearchWriterI\n           -output_format  => output format, which will dynamically load writer\n\nSee L<Bio::Factory::ObjectFactoryI>, L<Bio::SearchIO::SearchWriterI>\n\nAny factory objects in the arguments are passed along to the\nSearchResultEventBuilder object which holds these factories and sets\ndefault ones if none are supplied as arguments.\n\n\nsub new {\n  my($caller,@args) = @_;\n  my $class = ref($caller) || $caller;\n    \n  # or do we want to call SUPER on an object if $caller is an\n  # object?\n  if( $class =~ /Bio::SearchIO::(\\S+)/ ) {\n    my ($self) = $class->SUPER::new(@args);        \n    $self->_initialize(@args);\n    return $self;\n  } else { \n    my %param = @args;\n    @param{ map { lc $_ } keys %param } = values %param; # lowercase keys\n    my $format = $param{'-format'} ||\n      $class->_guess_format( $param{'-file'} || $ARGV[0] ) || 'blast';\n\n    my $output_format = $param{'-output_format'};\n    my $writer = undef;\n\n    if( defined $output_format ) {\n        if( defined $param{'-writer'} ) {\n            my $dummy = Bio::Root::Root->new();\n            $dummy->throw(\"Both writer and output format specified - not good\");\n        }\n\n        if( $output_format =~ /^blast$/i ) {\n            $output_format = 'TextResultWriter';\n        }\n        my $output_module = \"Bio::SearchIO::Writer::\".$output_format;\n        $class->_load_module($output_module);\n        $writer = $output_module->new(@args);\n        push(@args,\"-writer\",$writer);\n    }\n\n\n    # normalize capitalization to lower case\n    $format = \"\\L$format\";\n    \n    return unless( $class->_load_format_module($format) );\n    return \"Bio::SearchIO::${format}\"->new(@args);\n  }\n}\n\n=head2 newFh\n\n Title   : newFh\n Usage   : $fh = Bio::SearchIO->newFh(-file=>$filename,\n                                      -format=>'Format')\n Function: does a new() followed by an fh()\n Example : $fh = Bio::SearchIO->newFh(-file=>$filename,\n                                      -format=>'Format')\n           $result = <$fh>;   # read a ResultI object\n           print $fh $result; # write a ResultI object\n Returns : filehandle tied to the Bio::SearchIO::Fh class\n Args    :\n\n\nsub newFh {\n  my $class = shift;\n  return unless my $self = $class->new(@_);\n  return $self->fh;\n}\n\n=head2 fh\n\n Title   : fh\n Usage   : $obj->fh\n Function:\n Example : $fh = $obj->fh;      # make a tied filehandle\n           $result = <$fh>;     # read a ResultI object\n           print $fh $result;   # write a ResultI object\n Returns : filehandle tied to the Bio::SearchIO::Fh class\n Args    :\n\n\n\nsub fh {\n  my $self = shift;\n  my $class = ref($self) || $self;\n  my $s = Symbol::gensym;\n  tie $$s,$class,$self;\n  return $s;\n}\n\n=head2 attach_EventHandler\n\n Title   : attach_EventHandler\n Usage   : $parser->attatch_EventHandler($handler)\n Function: Adds an event handler to listen for events\n Returns : none\n Args    : Bio::SearchIO::EventHandlerI\n\nSee L<Bio::SearchIO::EventHandlerI>\n\n\nsub attach_EventHandler{\n    my ($self,$handler) = @_;\n    return if( ! $handler );\n    if( ! $handler->isa('Bio::SearchIO::EventHandlerI') ) {\n        $self->warn(\"Ignoring request to attatch handler \".ref($handler). ' because it is not a Bio::SearchIO::EventHandlerI');\n    }\n    $self->{'_handler'} = $handler;\n    return;\n}\n\n=head2 _eventHandler\n\n Title   : _eventHandler\n Usage   : private\n Function: Get the EventHandler\n Returns : Bio::SearchIO::EventHandlerI\n Args    : none\n\nSee L<Bio::SearchIO::EventHandlerI>\n\n\nsub _eventHandler{\n   my ($self) = @_;\n   return $self->{'_handler'};\n}\n\nsub _initialize {\n    my($self, @args) = @_;\n    $self->{'_handler'} = undef;\n    # not really necessary unless we put more in RootI\n    #$self->SUPER::_initialize(@args);\n\n    # initialize the IO part\n    $self->_initialize_io(@args);\n    $self->attach_EventHandler(Bio::SearchIO::SearchResultEventBuilder->new(@args));\n    $self->{'_reporttype'} = '';\n    $self->{_notfirsttime} = 0;\n    my ( $writer ) = $self->_rearrange([qw(WRITER)], @args);\n\n    $self->writer( $writer ) if $writer;\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : $result = stream->next_result\n Function: Reads the next ResultI object from the stream and returns it.\n\n           Certain driver modules may encounter entries in the stream that\n           are either misformatted or that use syntax not yet understood\n           by the driver. If such an incident is recoverable, e.g., by\n           dismissing a feature of a feature table or some other non-mandatory\n           part of an entry, the driver will issue a warning. In the case\n           of a non-recoverable situation an exception will be thrown.\n           Do not assume that you can resume parsing the same stream after\n           catching the exception. Note that you can always turn recoverable\n           errors into exceptions by calling $stream->verbose(2) (see\n           Bio::Root::RootI POD page).\n Returns : A Bio::Search::Result::ResultI object\n Args    : n/a\n\nSee L<Bio::Root::RootI>\n\n\nsub next_result {\n   my ($self) = @_;\n   $self->throw_not_implemented;\n}\n\n=head2 write_result\n\n Title   : write_result\n Usage   : $stream->write_result($result_result, @other_args)\n Function: Writes data from the $result_result object into the stream.\n         : Delegates to the to_string() method of the associated \n         : WriterI object.\n Returns : 1 for success and 0 for error\n Args    : Bio::Search:Result::ResultI object,\n         : plus any other arguments for the Writer\n Throws  : Bio::Root::Exception if a Writer has not been set.\n\nSee L<Bio::Root::Exception>\n\n\nsub write_result {\n   my ($self, $result, @args) = @_;\n\n   if( not ref($self->{'_result_writer'}) ) {\n       $self->throw(\"ResultWriter not defined.\");\n   }\n   @args = $self->{'_notfirsttime'} unless( @args );\n\n   my $str = $self->writer->to_string( $result, @args);\n   $self->{'_notfirsttime'} = 1;\n   $self->_print( \"$str\" ) if defined $str;\n   \n   $self->flush if $self->_flush_on_write && defined $self->_fh;\n   return 1;\n}\n\n=head2 write_report\n\n Title   : write_report\n Usage   : $stream->write_report(SearchIO stream, @other_args)\n Function: Writes data directly from the SearchIO stream object into the\n         : writer.  This is mainly useful if one has multiple ResultI objects\n         : in a SearchIO stream and you don't want to reiterate header/footer\n         : between each call.\n Returns : 1 for success and 0 for error\n Args    : Bio::SearchIO stream object,\n         : plus any other arguments for the Writer\n Throws  : Bio::Root::Exception if a Writer has not been set.\n\nSee L<Bio::Root::Exception>\n\n\nsub write_report {\n   my ($self, $result, @args) = @_;\n\n   if( not ref($self->{'_result_writer'}) ) {\n       $self->throw(\"ResultWriter not defined.\");\n   }\n   @args = $self->{'_notfirsttime'} unless( @args );\n\n   my $str = $self->writer->to_string( $result, @args);\n   $self->{'_notfirsttime'} = 1;\n   $self->_print( \"$str\" ) if defined $str;\n   \n   $self->flush if $self->_flush_on_write && defined $self->_fh;\n   return 1;\n}\n\n\n=head2 writer\n\n Title   : writer\n Usage   : $writer = $stream->writer;\n Function: Sets/Gets a SearchWriterI object to be used for this searchIO.\n Returns : 1 for success and 0 for error\n Args    : Bio::SearchIO::SearchWriterI object (when setting)\n Throws  : Bio::Root::Exception if a non-Bio::SearchIO::SearchWriterI object\n           is passed in.\n\n\nsub writer {\n    my ($self, $writer) = @_;\n    if( ref($writer) and $writer->isa( 'Bio::SearchIO::SearchWriterI' )) {\n        $self->{'_result_writer'} = $writer;\n    }\n    elsif( defined $writer ) {\n        $self->throw(\"Can't set ResultWriter. Not a Bio::SearchIO::SearchWriterI: $writer\");\n    }\n    return $self->{'_result_writer'};\n}\n\n\n=head2 result_count\n\n Title   : result_count\n Usage   : $num = $stream->result_count;\n Function: Gets the number of Blast results that have been successfully parsed\n           at the point of the method call.  This is not the total # of results\n           in the file.\n Returns : integer\n Args    : none\n Throws  : none\n\n\nsub result_count {\n    my $self = shift;\n    $self->throw_not_implemented;\n}\n\n\n=head2 _load_format_module\n\n Title   : _load_format_module\n Usage   : *INTERNAL SearchIO stuff*\n Function: Loads up (like use) a module at run time on demand\n Example : \n Returns : \n Args    : \n\n\nsub _load_format_module {\n  my ($self,$format) = @_;\n  my $module = \"Bio::SearchIO::\" . $format;\n  my $ok;\n  \n  eval {\n      $ok = $self->_load_module($module);\n  };\n  if ( $@ ) {\n      print STDERR <<END;\n$self: $format cannot be found\nException $@\nFor more information about the SearchIO system please see the SearchIO docs.\nThis includes ways of checking for formats at compile time, not run time\nEND\n  ;\n  }\n  return $ok;\n}\n\n=head2 _get_seq_identifiers\n\n Title   : _get_seq_identifiers\n Usage   : my ($gi, $acc,$ver) = &_get_seq_identifiers($id)\n Function: Private function to get the gi, accession, version data\n           for an ID (if it is in NCBI format)\n Returns : 3-pule of gi, accession, version\n Args    : ID string to process (NCBI format)","parameters":[{"label":"$self"},{"label":"$id"}]},"containerName":"main::","definition":"sub","line":471,"children":[{"containerName":"_get_seq_identifiers","name":"$self","definition":"my","localvar":"my","kind":13,"line":472},{"kind":13,"line":472,"name":"$id","containerName":"_get_seq_identifiers"},{"containerName":"_get_seq_identifiers","name":"$id","line":474,"kind":13},{"kind":13,"line":475,"definition":"my","name":"$gi","containerName":"_get_seq_identifiers","localvar":"my"},{"line":475,"kind":13,"name":"$acc","containerName":"_get_seq_identifiers"},{"line":475,"kind":13,"containerName":"_get_seq_identifiers","name":"$version"},{"name":"$id","containerName":"_get_seq_identifiers","line":476,"kind":13},{"containerName":"_get_seq_identifiers","name":"$gi","line":477,"kind":13},{"containerName":"_get_seq_identifiers","name":"$id","kind":13,"line":479},{"line":480,"kind":13,"name":"$acc","containerName":"_get_seq_identifiers"},{"kind":13,"line":480,"name":"$version","containerName":"_get_seq_identifiers"},{"containerName":"_get_seq_identifiers","name":"$id","kind":13,"line":482},{"containerName":"_get_seq_identifiers","name":"$acc","kind":13,"line":483},{"line":483,"kind":13,"containerName":"_get_seq_identifiers","name":"$version"},{"containerName":"_get_seq_identifiers","name":"$acc","kind":13,"line":502},{"containerName":"_get_seq_identifiers","name":"$id","kind":13,"line":502},{"name":"$gi","containerName":"_get_seq_identifiers","kind":13,"line":504},{"containerName":"_get_seq_identifiers","name":"$acc","kind":13,"line":504},{"line":504,"kind":13,"containerName":"_get_seq_identifiers","name":"$version"}],"kind":12},{"containerName":"main::","definition":"sub","name":"_guess_format","range":{"start":{"line":518,"character":0},"end":{"line":530,"character":9999}},"kind":12,"line":518,"children":[{"localvar":"my","containerName":"_guess_format","definition":"my","name":"$class","line":519,"kind":13}]},{"children":[{"kind":13,"line":533,"containerName":"close","name":"$self","definition":"my","localvar":"my"},{"kind":13,"line":535,"name":"$self","containerName":"close"},{"kind":12,"line":535,"name":"writer","containerName":"close"},{"line":536,"kind":13,"containerName":"close","name":"$self"},{"line":536,"kind":12,"containerName":"close","name":"_print"},{"name":"$self","containerName":"close","line":536,"kind":13},{"kind":12,"line":536,"containerName":"close","name":"writer"},{"name":"end_report","containerName":"close","kind":12,"line":536},{"kind":13,"line":537,"containerName":"close","name":"$self"},{"line":539,"kind":13,"name":"$self","containerName":"close"}],"line":532,"kind":12,"range":{"start":{"character":0,"line":532},"end":{"character":9999,"line":540}},"name":"close","definition":"sub","containerName":"main::"},{"containerName":"close","name":"SUPER","kind":12,"line":539},{"containerName":"main::","name":"DESTROY","definition":"sub","range":{"end":{"line":546,"character":9999},"start":{"line":542,"character":0}},"kind":12,"line":542,"children":[{"line":543,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"DESTROY"},{"containerName":"DESTROY","name":"$self","line":544,"kind":13},{"line":544,"kind":12,"containerName":"DESTROY","name":"close"},{"name":"$self","containerName":"DESTROY","line":544,"kind":13},{"name":"_fh","containerName":"DESTROY","kind":12,"line":544},{"line":545,"kind":13,"name":"$self","containerName":"DESTROY"}]},{"children":[{"name":"$class","definition":"my","containerName":"TIEHANDLE","localvar":"my","kind":13,"line":549},{"line":550,"kind":13,"containerName":"TIEHANDLE","name":"$class"}],"line":548,"kind":12,"range":{"end":{"character":9999,"line":551},"start":{"character":0,"line":548}},"name":"TIEHANDLE","definition":"sub","containerName":"main::"},{"name":"SUPER","containerName":"DESTROY","kind":12,"line":549},{"name":"processor","line":550,"kind":12},{"kind":12,"line":553,"children":[{"name":"$self","definition":"my","containerName":"READLINE","localvar":"my","kind":13,"line":554},{"containerName":"READLINE","name":"$self","line":555,"kind":13},{"containerName":"READLINE","name":"next_result","line":555,"kind":12},{"localvar":"my","definition":"my","name":"@list","containerName":"READLINE","line":556,"kind":13},{"line":556,"kind":13,"containerName":"READLINE","name":"$obj"},{"kind":13,"line":557,"name":"@list","containerName":"READLINE"},{"kind":13,"line":557,"containerName":"READLINE","name":"$obj"},{"kind":13,"line":557,"name":"$obj","containerName":"READLINE"},{"name":"$self","containerName":"READLINE","kind":13,"line":557},{"kind":12,"line":557,"containerName":"READLINE","name":"next_result"},{"name":"@list","containerName":"READLINE","kind":13,"line":558}],"containerName":"main::","definition":"sub","name":"READLINE","range":{"end":{"character":9999,"line":559},"start":{"line":553,"character":0}}},{"kind":12,"children":[{"line":562,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"PRINT"},{"name":"$self","containerName":"PRINT","line":563,"kind":13},{"line":563,"kind":12,"name":"write_result","containerName":"PRINT"}],"line":561,"name":"PRINT","definition":"sub","containerName":"main::","range":{"end":{"character":9999,"line":564},"start":{"character":0,"line":561}}}],"version":5}