{"vars":[{"kind":2,"line":121,"containerName":"","name":"base"},{"detail":"($self,@args)","signature":{"documentation":"1;\n# $Id: PullHitI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Search::Hit::PullHitI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Hit::PullHitI - Bio::Search::Hit::HitI interface for pull parsers.\n\n=head1 SYNOPSIS\n\n\t# This is an interface and cannot be instantiated\n\n    # typically one gets HitI objects from a SearchIO stream via a ResultI\n    use Bio::SearchIO;\n    my $parser = Bio::SearchIO->new(-format => 'hmmer_pull',\n                                   -file => 't/data/hmmpfam.out');\n\n    my $result = $parser->next_result;\n    my $hit    = $result->next_hit;\n\n    $hit_name = $hit->name();\n\n    $desc = $hit->description();\n\n    $len = $hit->length\n\n    $alg = $hit->algorithm();\n\n    $score = $hit->raw_score();\n\n    $significance = $hit->significance();\n\n    $rank = $hit->rank(); # the Nth hit for a specific query\n\n    while( $hsp = $obj->next_hsp()) { ... } # process in iterator fashion\n\n    for my $hsp ( $obj->hsps()()) { ... } # process in list fashion\n\n=head1 DESCRIPTION\n\nThis object handles the hit data from a database sequence search.\n\nPullHitI is for fast implementations that only do parsing work on the hit\ndata when you actually request information by calling one of the HitI\nmethods.\n\nMany methods of HitI are implemented in a way suitable for inheriting classes\nthat use Bio::PullParserI. It only really makes sense for PullHit modules to be\ncreated by (and have as a -parent) PullResult modules.\n\nIn addition to the usual -chunk and -parent, -hit_data is all you should supply\nwhen making a PullHit object. This will store that data and make it accessible\nvia _raw_hit_data, which you can access in your subclass. It would be best to\nsimply provide the data as the input -chunk instead, if the raw data is large\nenough.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 COPYRIGHT\n\nCopyright (c) 2006 Sendu Bala. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::Hit::PullHitI;\n\nuse Bio::Search::SearchUtils;\n\nuse strict;\n\nuse base qw(Bio::PullParserI Bio::Search::Hit::HitI);\n\n=head2 _setup\n\n Title   : _setup\n Usage   : $self->_setup(@args)\n Function: Implementers should call this to setup common fields and deal with\n           common arguments to new().\n Returns : n/a\n Args    : @args received in new().","parameters":[{"label":"$self"},{"label":"@args"}],"label":"_setup($self,@args)"},"containerName":"main::","definition":"sub","line":134,"children":[{"containerName":"_setup","name":"$self","definition":"my","localvar":"my","kind":13,"line":135},{"name":"@args","containerName":"_setup","line":135,"kind":13},{"name":"$self","containerName":"_setup","kind":13,"line":138},{"name":"_fields","containerName":"_setup","kind":12,"line":138},{"kind":13,"line":149,"containerName":"_setup","name":"$parent","definition":"my","localvar":"my"},{"kind":13,"line":149,"name":"$chunk","containerName":"_setup"},{"line":149,"kind":13,"containerName":"_setup","name":"$hit_data"},{"containerName":"_setup","name":"$self","kind":13,"line":149},{"containerName":"_setup","name":"_rearrange","line":149,"kind":12},{"name":"@args","containerName":"_setup","line":151,"kind":13},{"line":152,"kind":13,"containerName":"_setup","name":"$self"},{"containerName":"_setup","name":"throw","kind":12,"line":152},{"name":"$parent","containerName":"_setup","kind":13,"line":152},{"line":152,"kind":13,"containerName":"_setup","name":"$chunk"},{"name":"$self","containerName":"_setup","line":154,"kind":13},{"kind":12,"line":154,"name":"parent","containerName":"_setup"},{"line":154,"kind":13,"name":"$parent","containerName":"_setup"},{"line":154,"kind":13,"name":"$parent","containerName":"_setup"},{"containerName":"_setup","name":"$chunk","line":156,"kind":13},{"kind":13,"line":157,"name":"$io","definition":"my","containerName":"_setup","localvar":"my"},{"line":157,"kind":13,"containerName":"_setup","name":"$start"},{"kind":13,"line":157,"containerName":"_setup","name":"$end"},{"name":"$chunk","containerName":"_setup","kind":13,"line":158},{"kind":13,"line":159,"containerName":"_setup","name":"$io"},{"line":159,"kind":13,"name":"$start","containerName":"_setup"},{"kind":13,"line":159,"containerName":"_setup","name":"$end"},{"kind":13,"line":159,"containerName":"_setup","name":"$chunk"},{"line":162,"kind":13,"containerName":"_setup","name":"$io"},{"name":"$chunk","containerName":"_setup","line":162,"kind":13},{"name":"$self","containerName":"_setup","kind":13,"line":164},{"containerName":"_setup","name":"chunk","kind":12,"line":164},{"containerName":"_setup","name":"$io","line":164,"kind":13},{"kind":13,"line":164,"name":"$start","containerName":"_setup"},{"name":"$end","containerName":"_setup","line":164,"kind":13}],"kind":12,"range":{"start":{"line":134,"character":0},"end":{"character":9999,"line":165}},"name":"_setup"},{"name":"next_hsp","line":138,"kind":12},{"kind":12,"line":139,"name":"num_hsps"},{"name":"hsps","line":140,"kind":12},{"line":141,"kind":12,"name":"hit_start"},{"kind":12,"line":142,"name":"query_start"},{"name":"hit_end","kind":12,"line":143},{"name":"query_end","line":144,"kind":12},{"kind":12,"line":145,"name":"length"},{"kind":12,"line":146,"name":"name"},{"name":"accession","kind":12,"line":147},{"kind":13,"line":167,"containerName":null,"name":"$self"},{"kind":12,"line":167,"name":"_raw_hit_data","containerName":"main::"},{"name":"$hit_data","containerName":null,"kind":13,"line":167},{"containerName":null,"name":"$hit_data","line":167,"kind":13},{"kind":12,"line":170,"children":[{"kind":13,"line":171,"containerName":"_raw_hit_data","definition":"my","name":"$self","localvar":"my"},{"name":"$self","containerName":"_raw_hit_data","line":173,"kind":13},{"name":"$self","containerName":"_raw_hit_data","kind":13,"line":175}],"containerName":"main::","definition":"sub","name":"_raw_hit_data","range":{"end":{"character":9999,"line":176},"start":{"line":170,"character":0}}},{"kind":12,"line":173,"name":"_raw_hit_data"},{"name":"_raw_hit_data","line":175,"kind":12},{"children":[{"line":197,"kind":12,"containerName":"name","name":"get_field"}],"line":196,"kind":12,"range":{"end":{"character":9999,"line":198},"start":{"character":0,"line":196}},"definition":"sub","name":"name","containerName":"main::"},{"containerName":"main::","name":"description","definition":"sub","range":{"end":{"character":9999,"line":212},"start":{"character":0,"line":210}},"kind":12,"line":210,"children":[{"containerName":"description","name":"get_field","kind":12,"line":211}]},{"range":{"end":{"character":9999,"line":226},"start":{"line":224,"character":0}},"name":"accession","definition":"sub","containerName":"main::","children":[{"kind":12,"line":225,"name":"get_field","containerName":"accession"}],"line":224,"kind":12},{"containerName":"main::","definition":"sub","name":"locus","range":{"start":{"character":0,"line":238},"end":{"character":9999,"line":240}},"kind":12,"line":238,"children":[{"name":"get_field","containerName":"locus","line":239,"kind":12}]},{"children":[{"line":253,"kind":12,"containerName":"length","name":"get_field"}],"line":252,"kind":12,"range":{"start":{"line":252,"character":0},"end":{"line":254,"character":9999}},"definition":"sub","name":"length","containerName":"main::"},{"containerName":"main::","name":"algorithm","definition":"sub","range":{"start":{"character":0,"line":270},"end":{"line":272,"character":9999}},"kind":12,"line":270,"children":[{"containerName":"algorithm","name":"get_field","line":271,"kind":12}]},{"line":286,"children":[{"name":"get_field","containerName":"raw_score","kind":12,"line":287}],"kind":12,"range":{"end":{"line":288,"character":9999},"start":{"line":286,"character":0}},"containerName":"main::","name":"raw_score","definition":"sub"},{"range":{"start":{"line":296,"character":0},"end":{"character":9999,"line":298}},"containerName":"main::","name":"score","definition":"sub","line":296,"children":[{"line":297,"kind":12,"name":"get_field","containerName":"score"}],"kind":12},{"children":[{"containerName":"significance","name":"get_field","kind":12,"line":314}],"line":313,"kind":12,"range":{"start":{"line":313,"character":0},"end":{"line":315,"character":9999}},"definition":"sub","name":"significance","containerName":"main::"},{"range":{"start":{"line":330,"character":0},"end":{"line":332,"character":9999}},"containerName":"main::","name":"bits","definition":"sub","line":330,"children":[{"kind":12,"line":331,"name":"get_field","containerName":"bits"}],"kind":12},{"kind":12,"children":[{"kind":12,"line":346,"containerName":"next_hsp","name":"get_field"}],"line":345,"name":"next_hsp","definition":"sub","containerName":"main::","range":{"end":{"line":347,"character":9999},"start":{"character":0,"line":345}}},{"children":[{"line":367,"kind":12,"name":"get_field","containerName":"hsps"}],"line":366,"kind":12,"range":{"start":{"line":366,"character":0},"end":{"character":9999,"line":368}},"definition":"sub","name":"hsps","containerName":"main::"},{"containerName":"main::","definition":"sub","name":"num_hsps","range":{"end":{"line":385,"character":9999},"start":{"line":383,"character":0}},"kind":12,"line":383,"children":[{"kind":12,"line":384,"name":"get_field","containerName":"num_hsps"}]},{"range":{"end":{"line":447,"character":9999},"start":{"line":421,"character":0}},"name":"seq_inds","detail":"($self,$seqType,$class,$collapse)","signature":{"parameters":[{"label":"$self"},{"label":"$seqType"},{"label":"$class"},{"label":"$collapse"}],"documentation":"1;\n# $Id: PullHitI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Search::Hit::PullHitI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Hit::PullHitI - Bio::Search::Hit::HitI interface for pull parsers.\n\n=head1 SYNOPSIS\n\n\t# This is an interface and cannot be instantiated\n\n    # typically one gets HitI objects from a SearchIO stream via a ResultI\n    use Bio::SearchIO;\n    my $parser = Bio::SearchIO->new(-format => 'hmmer_pull',\n                                   -file => 't/data/hmmpfam.out');\n\n    my $result = $parser->next_result;\n    my $hit    = $result->next_hit;\n\n    $hit_name = $hit->name();\n\n    $desc = $hit->description();\n\n    $len = $hit->length\n\n    $alg = $hit->algorithm();\n\n    $score = $hit->raw_score();\n\n    $significance = $hit->significance();\n\n    $rank = $hit->rank(); # the Nth hit for a specific query\n\n    while( $hsp = $obj->next_hsp()) { ... } # process in iterator fashion\n\n    for my $hsp ( $obj->hsps()()) { ... } # process in list fashion\n\n=head1 DESCRIPTION\n\nThis object handles the hit data from a database sequence search.\n\nPullHitI is for fast implementations that only do parsing work on the hit\ndata when you actually request information by calling one of the HitI\nmethods.\n\nMany methods of HitI are implemented in a way suitable for inheriting classes\nthat use Bio::PullParserI. It only really makes sense for PullHit modules to be\ncreated by (and have as a -parent) PullResult modules.\n\nIn addition to the usual -chunk and -parent, -hit_data is all you should supply\nwhen making a PullHit object. This will store that data and make it accessible\nvia _raw_hit_data, which you can access in your subclass. It would be best to\nsimply provide the data as the input -chunk instead, if the raw data is large\nenough.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 COPYRIGHT\n\nCopyright (c) 2006 Sendu Bala. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::Hit::PullHitI;\n\nuse Bio::Search::SearchUtils;\n\nuse strict;\n\nuse base qw(Bio::PullParserI Bio::Search::Hit::HitI);\n\n=head2 _setup\n\n Title   : _setup\n Usage   : $self->_setup(@args)\n Function: Implementers should call this to setup common fields and deal with\n           common arguments to new().\n Returns : n/a\n Args    : @args received in new().\n\n\nsub _setup {\n    my ($self, @args) = @_;\n    \n    # fields most subclasses probably will want\n    $self->_fields( { ( next_hsp => undef,\n                        num_hsps => undef,\n                        hsps => undef,\n                        hit_start => undef,\n                        query_start => undef,\n                        hit_end => undef,\n                        query_end => undef,\n                        length => undef,\n\t\t\t\t\t\tname => undef ,\n\t\t\t\t\t\taccession => undef ) } );\n    \n    my ($parent, $chunk, $hit_data) = $self->_rearrange([qw(PARENT\n                                                            CHUNK\n                                                            HIT_DATA)], @args);\n    $self->throw(\"Need -parent or -chunk to be defined\") unless $parent || $chunk;\n    \n\t$self->parent($parent) if $parent;\n    \n    if ($chunk) {\n        my ($io, $start, $end) = (undef, 0, undef);\n        if (ref($chunk) eq 'ARRAY') {\n            ($io, $start, $end) = @{$chunk};\n        }\n        else {\n            $io = $chunk;\n        }\n        $self->chunk($io, -start => $start, -end => $end);\n    }\n    \n    $self->_raw_hit_data($hit_data) if $hit_data;\n}\n\nsub _raw_hit_data {\n\tmy $self = shift;\n\tif (@_) {\n\t\t$self->{_raw_hit_data} = shift;\n\t}\n\treturn $self->{_raw_hit_data};\n}\n\n#\n# Some of these methods are written explitely to avoid HitI throwing not\n# implemented; if it didn't do that then PullParserI AUTOLOAD would have\n# cought them.\n#\n\n=head2 name\n\n Title   : name\n Usage   : $hit_name = $hit->name();\n Function: returns the name of the Hit sequence\n Returns : a scalar string\n Args    : none\n\nThe B<name> of a hit is unique within a Result or within an Iteration.\n\n\nsub name {\n    return shift->get_field('name');\n}\n\n=head2 description\n\n Title   : description\n Usage   : $desc = $hit->description();\n Function: Retrieve the description for the hit\n Returns : a scalar string\n Args    : none\n\n\nsub description {\n    return shift->get_field('description');\n}\n\n=head2 accession\n\n Title   : accession\n Usage   : $acc = $hit->accession();\n Function: Retrieve the accession (if available) for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub accession {\n    return shift->get_field('accession');\n}\n\n=head2 locus\n\n Title   : locus\n Usage   : $acc = $hit->locus();\n Function: Retrieve the locus(if available) for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub locus {\n    return shift->get_field('locus');\n}\n\n=head2 length\n\n Title   : length\n Usage   : my $len = $hit->length\n Function: Returns the length of the hit \n Returns : integer\n Args    : none\n\n\nsub length {\n   return shift->get_field('length');\n}\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : $alg = $hit->algorithm();\n Function: Gets the algorithm specification that was used to obtain the hit\n           For BLAST, the algorithm denotes what type of sequence was aligned \n           against what (BLASTN: dna-dna, BLASTP prt-prt, BLASTX translated \n           dna-prt, TBLASTN prt-translated dna, TBLASTX translated \n           dna-translated dna).\n Returns : a scalar string \n Args    : none\n\n\nsub algorithm {\n    return shift->get_field('algorithm');\n}\n\n=head2 raw_score\n\n Title   : raw_score\n Usage   : $score = $hit->raw_score();\n Function: Gets the \"raw score\" generated by the algorithm.  What\n           this score is exactly will vary from algorithm to algorithm,\n           returning undef if unavailable.\n Returns : a scalar value\n Args    : none\n\n\nsub raw_score {\n    return shift->get_field('score');\n}\n\n=head2 score\n\nEquivalent to L<raw_score()|raw_score>\n\n\nsub score {\n    return shift->get_field('score');\n}\n\n=head2 significance\n\n Title   : significance\n Usage   : $significance = $hit->significance();\n Function: Used to obtain the E or P value of a hit, i.e. the probability that\n           this particular hit was obtained purely by random chance.  If\n           information is not available (nor calculatable from other\n           information sources), return undef.\n Returns : a scalar value or undef if unavailable\n Args    : none\n\n\nsub significance {\n    return shift->get_field('significance');\n}\n\n=head2 bits\n\n Usage     : $hit_object->bits();\n Purpose   : Gets the bit score of the best HSP for the current hit.\n Example   : $bits = $hit_object->bits();\n Returns   : Integer or double for FASTA reports\n Argument  : n/a\n Comments  : For BLAST1, the non-bit score is listed in the summary line.\n\nSee Also   : L<score()|score>\n\n\nsub bits {\n    return shift->get_field('bits');\n}\n\n=head2 next_hsp\n\n Title    : next_hsp\n Usage    : while( $hsp = $obj->next_hsp()) { ... }\n Function : Returns the next available High Scoring Pair\n Example  : \n Returns  : L<Bio::Search::HSP::HSPI> object or null if finished\n Args     : none\n\n\nsub next_hsp {\n    return shift->get_field('next_hsp');\n}\n\n=head2 hsps\n\n Usage     : $hit_object->hsps();\n Purpose   : Get a list containing all HSP objects.\n           : Get the numbers of HSPs for the current hit.\n Example   : @hsps = $hit_object->hsps();\n           : $num  = $hit_object->hsps();  # alternatively, use num_hsps()\n Returns   : Array context : list of L<Bio::Search::HSP::BlastHSP> objects.\n           : Scalar context: integer (number of HSPs).\n           :                 (Equivalent to num_hsps()).\n Argument  : n/a. Relies on wantarray\n Throws    : Exception if the HSPs have not been collected.\n\nSee Also   : L<hsp()|hsp>, L<num_hsps()|num_hsps>\n\n\nsub hsps {\n    return shift->get_field('hsps');\n}\n\n=head2 num_hsps\n\n Usage     : $hit_object->num_hsps();\n Purpose   : Get the number of HSPs for the present Blast hit.\n Example   : $nhsps = $hit_object->num_hsps();\n Returns   : Integer\n Argument  : n/a\n Throws    : Exception if the HSPs have not been collected.\n\nSee Also   : L<hsps()|hsps>\n\n\nsub num_hsps {\n    return shift->get_field('num_hsps');\n}\n\n#\n# HitI/ GenericHit methods that are unrelated to simply parsing information\n# directly out of a file, but need more complex calculation; mostly not\n# implemented here.\n#\n\n=head2 seq_inds\n\n Usage     : $hit->seq_inds( seq_type, class, collapse );\n Purpose   : Get a list of residue positions (indices) across all HSPs\n           : for identical or conserved residues in the query or sbjct sequence.\n Example   : @s_ind = $hit->seq_inds('query', 'identical');\n           : @h_ind = $hit->seq_inds('hit', 'conserved');\n           : @h_ind = $hit->seq_inds('hit', 'conserved', 1);\n Returns   : Array of integers \n           : May include ranges if collapse is non-zero.\n Argument  : [0] seq_type  = 'query' or 'hit' or 'sbjct'  (default = 'query')\n           :                 ('sbjct' is synonymous with 'hit')\n           : [1] class = 'identical' or 'conserved' or 'nomatch' or 'gap'\n\t\t   :         (default = 'identical')\n           :         (can be shortened to 'id' or 'cons')\n\t\t   :         Note that 'conserved' includes identical unless you use\n\t\t   :         'conserved-not-identical'\n           : [2] collapse = boolean, if non-zero, consecutive positions are\n           :             merged using a range notation, e.g.,\n           :             \"1 2 3 4 5 7 9 10 11\" collapses to \"1-5 7 9-11\". This\n           :             is useful for  consolidating long lists. Default = no\n           :             collapse.\n Throws    : n/a.\n\nSee Also   : L<Bio::Search::HSP::HSPI::seq_inds()|Bio::Search::HSP::HSPI>","label":"seq_inds($self,$seqType,$class,$collapse)"},"containerName":"main::","definition":"sub","line":421,"children":[{"line":422,"kind":13,"localvar":"my","containerName":"seq_inds","definition":"my","name":"$self"},{"kind":13,"line":422,"containerName":"seq_inds","name":"$seqType"},{"containerName":"seq_inds","name":"$class","kind":13,"line":422},{"line":422,"kind":13,"containerName":"seq_inds","name":"$collapse"},{"line":424,"kind":13,"containerName":"seq_inds","name":"$seqType"},{"containerName":"seq_inds","name":"$class","line":425,"kind":13},{"containerName":"seq_inds","name":"$collapse","kind":13,"line":426},{"name":"$seqType","containerName":"seq_inds","kind":13,"line":428},{"line":428,"kind":13,"name":"$seqType","containerName":"seq_inds"},{"line":430,"kind":13,"localvar":"my","definition":"my","name":"$storage_name","containerName":"seq_inds"},{"kind":13,"line":430,"containerName":"seq_inds","name":"$seqType"},{"line":430,"kind":13,"name":"$class","containerName":"seq_inds"},{"name":"$self","containerName":"seq_inds","line":431,"kind":13},{"line":431,"kind":13,"name":"$storage_name","containerName":"seq_inds"},{"containerName":"seq_inds","definition":"my","name":"@inds","localvar":"my","kind":13,"line":432},{"kind":13,"line":433,"containerName":"seq_inds","definition":"my","name":"$hsp","localvar":"my"},{"kind":13,"line":433,"containerName":"seq_inds","name":"$self"},{"containerName":"seq_inds","name":"hsps","kind":12,"line":433},{"containerName":"seq_inds","name":"@inds","kind":13,"line":435},{"line":435,"kind":13,"containerName":"seq_inds","name":"$hsp"},{"kind":12,"line":435,"containerName":"seq_inds","name":"seq_inds"},{"kind":13,"line":435,"containerName":"seq_inds","name":"$seqType"},{"containerName":"seq_inds","name":"$class","line":435,"kind":13},{"containerName":"seq_inds","name":"@inds","line":439,"kind":13},{"containerName":"seq_inds","name":"$class","line":439,"kind":13},{"kind":13,"line":440,"definition":"my","name":"%tmp","containerName":"seq_inds","localvar":"my"},{"kind":13,"line":440,"name":"@inds","containerName":"seq_inds"},{"kind":13,"line":441,"containerName":"seq_inds","name":"@inds"},{"containerName":"seq_inds","name":"$a","kind":13,"line":441},{"containerName":"seq_inds","name":"$b","kind":13,"line":441},{"kind":13,"line":441,"containerName":"seq_inds","name":"%tmp"},{"line":444,"kind":13,"containerName":"seq_inds","name":"$self"},{"containerName":"seq_inds","name":"$storage_name","line":444,"kind":13},{"line":444,"kind":13,"name":"@inds","containerName":"seq_inds"},{"containerName":"seq_inds","name":"@inds","definition":"my","localvar":"my","kind":13,"line":447},{"name":"$self","containerName":"seq_inds","line":447,"kind":13},{"line":447,"kind":13,"containerName":"seq_inds","name":"$storage_name"}],"kind":12},{"name":"$collapse","containerName":null,"kind":13,"line":448},{"kind":12,"line":448,"containerName":"Search::SearchUtils::collapse_nums","name":"Bio"},{"line":448,"kind":13,"name":"@inds","containerName":null},{"name":"@inds","containerName":null,"kind":13,"line":448},{"kind":12,"line":461,"children":[{"kind":12,"line":462,"name":"throw_not_implemented","containerName":"rewind"}],"containerName":"main::","name":"rewind","definition":"sub","range":{"end":{"character":9999,"line":463},"start":{"line":461,"character":0}}},{"containerName":"main::","definition":"sub","name":"overlap","range":{"end":{"line":484,"character":9999},"start":{"line":480,"character":0}},"kind":12,"line":480,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"overlap","line":481,"kind":13},{"kind":13,"line":482,"containerName":"overlap","name":"$self"},{"line":483,"kind":13,"name":"$self","containerName":"overlap"}]},{"name":"_overlap","line":482,"kind":12},{"line":483,"kind":12,"name":"_overlap"},{"name":"n","definition":"sub","containerName":"main::","range":{"start":{"line":508,"character":0},"end":{"line":510,"character":9999}},"kind":12,"children":[{"name":"get_field","containerName":"n","kind":12,"line":509}],"line":508},{"kind":12,"line":540,"children":[{"line":541,"kind":12,"containerName":"p","name":"throw_not_implemented"}],"containerName":"main::","definition":"sub","name":"p","range":{"end":{"line":542,"character":9999},"start":{"character":0,"line":540}}},{"children":[{"line":563,"kind":12,"containerName":"hsp","name":"throw_not_implemented"}],"line":562,"kind":12,"range":{"end":{"character":9999,"line":564},"start":{"line":562,"character":0}},"name":"hsp","definition":"sub","containerName":"main::"},{"line":588,"children":[{"line":589,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"logical_length"},{"containerName":"logical_length","name":"$type","kind":13,"line":589},{"line":590,"kind":13,"name":"$type","containerName":"logical_length"},{"kind":13,"line":591,"name":"$type","containerName":"logical_length"},{"containerName":"logical_length","name":"$type","kind":13,"line":591},{"line":592,"kind":13,"name":"$type","containerName":"logical_length"},{"name":"$type","containerName":"logical_length","kind":13,"line":592},{"containerName":"logical_length","name":"$type","kind":13,"line":593},{"kind":13,"line":594,"containerName":"logical_length","name":"$self"},{"name":"get_field","containerName":"logical_length","kind":12,"line":594},{"containerName":"logical_length","name":"$type","kind":13,"line":596},{"line":597,"kind":13,"name":"$self","containerName":"logical_length"},{"line":597,"kind":12,"containerName":"logical_length","name":"get_field"}],"kind":12,"detail":"($self,$type)","signature":{"parameters":[{"label":"$self"},{"label":"$type"}],"documentation":"1;\n# $Id: PullHitI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Search::Hit::PullHitI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Hit::PullHitI - Bio::Search::Hit::HitI interface for pull parsers.\n\n=head1 SYNOPSIS\n\n\t# This is an interface and cannot be instantiated\n\n    # typically one gets HitI objects from a SearchIO stream via a ResultI\n    use Bio::SearchIO;\n    my $parser = Bio::SearchIO->new(-format => 'hmmer_pull',\n                                   -file => 't/data/hmmpfam.out');\n\n    my $result = $parser->next_result;\n    my $hit    = $result->next_hit;\n\n    $hit_name = $hit->name();\n\n    $desc = $hit->description();\n\n    $len = $hit->length\n\n    $alg = $hit->algorithm();\n\n    $score = $hit->raw_score();\n\n    $significance = $hit->significance();\n\n    $rank = $hit->rank(); # the Nth hit for a specific query\n\n    while( $hsp = $obj->next_hsp()) { ... } # process in iterator fashion\n\n    for my $hsp ( $obj->hsps()()) { ... } # process in list fashion\n\n=head1 DESCRIPTION\n\nThis object handles the hit data from a database sequence search.\n\nPullHitI is for fast implementations that only do parsing work on the hit\ndata when you actually request information by calling one of the HitI\nmethods.\n\nMany methods of HitI are implemented in a way suitable for inheriting classes\nthat use Bio::PullParserI. It only really makes sense for PullHit modules to be\ncreated by (and have as a -parent) PullResult modules.\n\nIn addition to the usual -chunk and -parent, -hit_data is all you should supply\nwhen making a PullHit object. This will store that data and make it accessible\nvia _raw_hit_data, which you can access in your subclass. It would be best to\nsimply provide the data as the input -chunk instead, if the raw data is large\nenough.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 COPYRIGHT\n\nCopyright (c) 2006 Sendu Bala. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::Hit::PullHitI;\n\nuse Bio::Search::SearchUtils;\n\nuse strict;\n\nuse base qw(Bio::PullParserI Bio::Search::Hit::HitI);\n\n=head2 _setup\n\n Title   : _setup\n Usage   : $self->_setup(@args)\n Function: Implementers should call this to setup common fields and deal with\n           common arguments to new().\n Returns : n/a\n Args    : @args received in new().\n\n\nsub _setup {\n    my ($self, @args) = @_;\n    \n    # fields most subclasses probably will want\n    $self->_fields( { ( next_hsp => undef,\n                        num_hsps => undef,\n                        hsps => undef,\n                        hit_start => undef,\n                        query_start => undef,\n                        hit_end => undef,\n                        query_end => undef,\n                        length => undef,\n\t\t\t\t\t\tname => undef ,\n\t\t\t\t\t\taccession => undef ) } );\n    \n    my ($parent, $chunk, $hit_data) = $self->_rearrange([qw(PARENT\n                                                            CHUNK\n                                                            HIT_DATA)], @args);\n    $self->throw(\"Need -parent or -chunk to be defined\") unless $parent || $chunk;\n    \n\t$self->parent($parent) if $parent;\n    \n    if ($chunk) {\n        my ($io, $start, $end) = (undef, 0, undef);\n        if (ref($chunk) eq 'ARRAY') {\n            ($io, $start, $end) = @{$chunk};\n        }\n        else {\n            $io = $chunk;\n        }\n        $self->chunk($io, -start => $start, -end => $end);\n    }\n    \n    $self->_raw_hit_data($hit_data) if $hit_data;\n}\n\nsub _raw_hit_data {\n\tmy $self = shift;\n\tif (@_) {\n\t\t$self->{_raw_hit_data} = shift;\n\t}\n\treturn $self->{_raw_hit_data};\n}\n\n#\n# Some of these methods are written explitely to avoid HitI throwing not\n# implemented; if it didn't do that then PullParserI AUTOLOAD would have\n# cought them.\n#\n\n=head2 name\n\n Title   : name\n Usage   : $hit_name = $hit->name();\n Function: returns the name of the Hit sequence\n Returns : a scalar string\n Args    : none\n\nThe B<name> of a hit is unique within a Result or within an Iteration.\n\n\nsub name {\n    return shift->get_field('name');\n}\n\n=head2 description\n\n Title   : description\n Usage   : $desc = $hit->description();\n Function: Retrieve the description for the hit\n Returns : a scalar string\n Args    : none\n\n\nsub description {\n    return shift->get_field('description');\n}\n\n=head2 accession\n\n Title   : accession\n Usage   : $acc = $hit->accession();\n Function: Retrieve the accession (if available) for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub accession {\n    return shift->get_field('accession');\n}\n\n=head2 locus\n\n Title   : locus\n Usage   : $acc = $hit->locus();\n Function: Retrieve the locus(if available) for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub locus {\n    return shift->get_field('locus');\n}\n\n=head2 length\n\n Title   : length\n Usage   : my $len = $hit->length\n Function: Returns the length of the hit \n Returns : integer\n Args    : none\n\n\nsub length {\n   return shift->get_field('length');\n}\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : $alg = $hit->algorithm();\n Function: Gets the algorithm specification that was used to obtain the hit\n           For BLAST, the algorithm denotes what type of sequence was aligned \n           against what (BLASTN: dna-dna, BLASTP prt-prt, BLASTX translated \n           dna-prt, TBLASTN prt-translated dna, TBLASTX translated \n           dna-translated dna).\n Returns : a scalar string \n Args    : none\n\n\nsub algorithm {\n    return shift->get_field('algorithm');\n}\n\n=head2 raw_score\n\n Title   : raw_score\n Usage   : $score = $hit->raw_score();\n Function: Gets the \"raw score\" generated by the algorithm.  What\n           this score is exactly will vary from algorithm to algorithm,\n           returning undef if unavailable.\n Returns : a scalar value\n Args    : none\n\n\nsub raw_score {\n    return shift->get_field('score');\n}\n\n=head2 score\n\nEquivalent to L<raw_score()|raw_score>\n\n\nsub score {\n    return shift->get_field('score');\n}\n\n=head2 significance\n\n Title   : significance\n Usage   : $significance = $hit->significance();\n Function: Used to obtain the E or P value of a hit, i.e. the probability that\n           this particular hit was obtained purely by random chance.  If\n           information is not available (nor calculatable from other\n           information sources), return undef.\n Returns : a scalar value or undef if unavailable\n Args    : none\n\n\nsub significance {\n    return shift->get_field('significance');\n}\n\n=head2 bits\n\n Usage     : $hit_object->bits();\n Purpose   : Gets the bit score of the best HSP for the current hit.\n Example   : $bits = $hit_object->bits();\n Returns   : Integer or double for FASTA reports\n Argument  : n/a\n Comments  : For BLAST1, the non-bit score is listed in the summary line.\n\nSee Also   : L<score()|score>\n\n\nsub bits {\n    return shift->get_field('bits');\n}\n\n=head2 next_hsp\n\n Title    : next_hsp\n Usage    : while( $hsp = $obj->next_hsp()) { ... }\n Function : Returns the next available High Scoring Pair\n Example  : \n Returns  : L<Bio::Search::HSP::HSPI> object or null if finished\n Args     : none\n\n\nsub next_hsp {\n    return shift->get_field('next_hsp');\n}\n\n=head2 hsps\n\n Usage     : $hit_object->hsps();\n Purpose   : Get a list containing all HSP objects.\n           : Get the numbers of HSPs for the current hit.\n Example   : @hsps = $hit_object->hsps();\n           : $num  = $hit_object->hsps();  # alternatively, use num_hsps()\n Returns   : Array context : list of L<Bio::Search::HSP::BlastHSP> objects.\n           : Scalar context: integer (number of HSPs).\n           :                 (Equivalent to num_hsps()).\n Argument  : n/a. Relies on wantarray\n Throws    : Exception if the HSPs have not been collected.\n\nSee Also   : L<hsp()|hsp>, L<num_hsps()|num_hsps>\n\n\nsub hsps {\n    return shift->get_field('hsps');\n}\n\n=head2 num_hsps\n\n Usage     : $hit_object->num_hsps();\n Purpose   : Get the number of HSPs for the present Blast hit.\n Example   : $nhsps = $hit_object->num_hsps();\n Returns   : Integer\n Argument  : n/a\n Throws    : Exception if the HSPs have not been collected.\n\nSee Also   : L<hsps()|hsps>\n\n\nsub num_hsps {\n    return shift->get_field('num_hsps');\n}\n\n#\n# HitI/ GenericHit methods that are unrelated to simply parsing information\n# directly out of a file, but need more complex calculation; mostly not\n# implemented here.\n#\n\n=head2 seq_inds\n\n Usage     : $hit->seq_inds( seq_type, class, collapse );\n Purpose   : Get a list of residue positions (indices) across all HSPs\n           : for identical or conserved residues in the query or sbjct sequence.\n Example   : @s_ind = $hit->seq_inds('query', 'identical');\n           : @h_ind = $hit->seq_inds('hit', 'conserved');\n           : @h_ind = $hit->seq_inds('hit', 'conserved', 1);\n Returns   : Array of integers \n           : May include ranges if collapse is non-zero.\n Argument  : [0] seq_type  = 'query' or 'hit' or 'sbjct'  (default = 'query')\n           :                 ('sbjct' is synonymous with 'hit')\n           : [1] class = 'identical' or 'conserved' or 'nomatch' or 'gap'\n\t\t   :         (default = 'identical')\n           :         (can be shortened to 'id' or 'cons')\n\t\t   :         Note that 'conserved' includes identical unless you use\n\t\t   :         'conserved-not-identical'\n           : [2] collapse = boolean, if non-zero, consecutive positions are\n           :             merged using a range notation, e.g.,\n           :             \"1 2 3 4 5 7 9 10 11\" collapses to \"1-5 7 9-11\". This\n           :             is useful for  consolidating long lists. Default = no\n           :             collapse.\n Throws    : n/a.\n\nSee Also   : L<Bio::Search::HSP::HSPI::seq_inds()|Bio::Search::HSP::HSPI>\n\n\nsub seq_inds {\n    my ($self, $seqType, $class, $collapse) = @_;\n    \n    $seqType  ||= 'query';\n    $class ||= 'identical';\n    $collapse ||= 0;\n    \n    $seqType = 'hit' if $seqType eq 'sbjct';\n    \n\tmy $storage_name = '_seq_inds_'.$seqType.'_'.$class;\n\tunless (defined $self->{$storage_name}) {\n\t\tmy @inds;    \n\t\tforeach my $hsp ($self->hsps) {\n\t\t\t# This will merge data for all HSPs together.\n\t\t\tpush @inds, $hsp->seq_inds($seqType, $class);\n\t\t}\n\t\t\n\t\t# Need to remove duplicates and sort the merged positions, unless gaps.\n\t\tif (@inds && $class ne 'gap') {\n\t\t\tmy %tmp = map { $_, 1 } @inds;\n\t\t\t@inds = sort {$a <=> $b} keys %tmp;\n\t\t}\n\t\t\n\t\t$self->{$storage_name} = \\@inds;\n\t}\n\t\n\tmy @inds = @{$self->{$storage_name}};\n    $collapse ? &Bio::Search::SearchUtils::collapse_nums(@inds) : @inds;\n}\n\n=head2 rewind\n\n Title   : rewind\n Usage   : $hit->rewind;\n Function: Allow one to reset the HSP iterator to the beginning if possible\n Returns : none\n Args    : none\n\n\nsub rewind {\n    shift->throw_not_implemented();\n}\n\n=head2 overlap\n\n Usage     : $hit_object->overlap( [integer] );\n Purpose   : Gets/Sets the allowable amount overlap between different HSP\n             sequences.\n Example   : $hit_object->overlap(5);\n           : $overlap = $hit_object->overlap;\n Returns   : Integer.\n Argument  : integer.\n Throws    : n/a\n Status    : Deprecated\n Comments  : This value isn't used for anything\n\n\nsub overlap {\n    my $self = shift;\n    if (@_) { $self->{_overlap} = shift }\n    return $self->{_overlap} || 0;\n}\n\n=head2 n\n\n Usage     : $hit_object->n();\n Purpose   : Gets the N number for the current Blast hit.\n           : This is the number of HSPs in the set which was ascribed\n           : the lowest P-value (listed on the description line).\n           : This number is not the same as the total number of HSPs.\n           : To get the total number of HSPs, use num_hsps().\n Example   : $n = $hit_object->n();\n Returns   : Integer\n Argument  : n/a\n Throws    : Exception if HSPs have not been set (BLAST2 reports).\n Comments  : Note that the N parameter is not reported in gapped BLAST2.\n           : Calling n() on such reports will result in a call to num_hsps().\n           : The num_hsps() method will count the actual number of\n           : HSPs in the alignment listing, which may exceed N in\n           : some cases.\n\nSee Also   : L<num_hsps()|num_hsps>\n\n\nsub n {\n    return shift->get_field('num_hsps');\n}\n\n=head2 p\n\n Usage     : $hit_object->p( [format] );\n Purpose   : Get the P-value for the best HSP of the given BLAST hit.\n           : (Note that P-values are not provided with NCBI Blast2 reports).\n Example   : $p =  $sbjct->p;\n           : $p =  $sbjct->p('exp');  # get exponent only.\n           : ($num, $exp) =  $sbjct->p('parts'); # split sci notation into parts\n Returns   : Float or scientific notation number (the raw P-value, DEFAULT).\n           : Integer if format == 'exp' (the magnitude of the base 10 exponent).\n           : 2-element list (float, int) if format == 'parts' and P-value\n           :                is in scientific notation (See Comments).\n Argument  : format: string of 'raw' | 'exp' | 'parts'\n           :    'raw' returns value given in report. Default. (1.2e-34)\n           :    'exp' returns exponent value only (34)\n           :    'parts' returns the decimal and exponent as a \n           :            2-element list (1.2, -34) (See Comments).\n Throws    : Warns if no P-value is defined. Uses expect instead.\n Comments  : Using the 'parts' argument is not recommended since it will not\n           : work as expected if the P-value is not in scientific notation.\n           : That is, floats are not converted into sci notation before\n           : splitting into parts.\n\nSee Also   : L<expect()|expect>, L<signif()|signif>,\n             L<Bio::Search::BlastUtils::get_exponent()|Bio::Search::BlastUtils>\n\n\nsub p {\n    shift->throw_not_implemented;\n}\n\n=head2 hsp\n\n Usage     : $hit_object->hsp( [string] );\n Purpose   : Get a single HSPI object for the present HitI object.\n Example   : $hspObj  = $hit_object->hsp;  # same as 'best'\n           : $hspObj  = $hit_object->hsp('best');\n           : $hspObj  = $hit_object->hsp('worst');\n Returns   : Object reference for a L<Bio::Search::HSP::HSPI> object.\n Argument  : String (or no argument).\n           :   No argument (default) = highest scoring HSP (same as 'best').\n           :   'best'  = highest scoring HSP.\n           :   'worst' = lowest scoring HSP.\n Throws    : Exception if an unrecognized argument is used.\n\nSee Also   : L<hsps()|hsps>, L<num_hsps>()\n\n\nsub hsp {\n    shift->throw_not_implemented;\n}\n\n=head2 logical_length\n\n Usage     : $hit_object->logical_length( [seq_type] );\n           : (mostly intended for internal use).\n Purpose   : Get the logical length of the hit sequence.\n           : If the Blast is a TBLASTN or TBLASTX, the returned length \n           : is the length of the would-be amino acid sequence (length/3).\n           : For all other BLAST flavors, this function is the same as length().\n Example   : $len    = $hit_object->logical_length();\n Returns   : Integer \n Argument  : seq_type = 'query' or 'hit' or 'sbjct' (default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  : This is important for functions like frac_aligned_query()\n           : which need to operate in amino acid coordinate space when dealing\n           : with [T]BLAST[NX] type reports.\n\nSee Also   : L<length()|length>, L<frac_aligned_query()|frac_aligned_query>,\n             L<frac_aligned_hit()|frac_aligned_hit>","label":"logical_length($self,$type)"},"containerName":"main::","definition":"sub","range":{"end":{"character":9999,"line":599},"start":{"line":588,"character":0}},"name":"logical_length"},{"children":[{"kind":12,"line":613,"containerName":"rank","name":"get_field"}],"line":612,"kind":12,"range":{"end":{"character":9999,"line":614},"start":{"line":612,"character":0}},"definition":"sub","name":"rank","containerName":"main::"},{"range":{"start":{"character":0,"line":628},"end":{"character":9999,"line":660}},"containerName":"main::","definition":"sub","name":"each_accession_number","line":628,"children":[{"line":629,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"each_accession_number"},{"localvar":"my","containerName":"each_accession_number","name":"$accession","definition":"my","line":630,"kind":13},{"name":"$self","containerName":"each_accession_number","kind":13,"line":630},{"kind":12,"line":630,"containerName":"each_accession_number","name":"get_field"},{"line":630,"kind":13,"containerName":"each_accession_number","name":"$self"},{"line":630,"kind":12,"name":"has_field","containerName":"each_accession_number"},{"containerName":"each_accession_number","definition":"my","name":"$desc","localvar":"my","kind":13,"line":631},{"kind":13,"line":631,"name":"$self","containerName":"each_accession_number"},{"line":631,"kind":12,"name":"get_field","containerName":"each_accession_number"},{"containerName":"each_accession_number","name":"$self","kind":13,"line":631},{"kind":12,"line":631,"containerName":"each_accession_number","name":"has_field"},{"name":"$accession","containerName":"each_accession_number","line":632,"kind":13},{"containerName":"each_accession_number","name":"$desc","kind":13,"line":632},{"localvar":"my","name":"@accnums","definition":"my","containerName":"each_accession_number","line":634,"kind":13},{"name":"@accnums","containerName":"each_accession_number","line":635,"kind":13},{"kind":13,"line":635,"containerName":"each_accession_number","name":"$accession"},{"containerName":"each_accession_number","name":"$accession","kind":13,"line":635},{"kind":13,"line":637,"name":"$desc","containerName":"each_accession_number"},{"name":"$desc","containerName":"each_accession_number","line":638,"kind":13},{"localvar":"my","definition":"my","name":"$id","containerName":"each_accession_number","line":639,"kind":13},{"containerName":"each_accession_number","definition":"my","name":"$acc","localvar":"my","kind":13,"line":640},{"name":"$id","containerName":"each_accession_number","line":641,"kind":13},{"kind":13,"line":642,"name":"$acc","containerName":"each_accession_number"},{"containerName":"each_accession_number","name":"$id","line":644,"kind":13},{"line":645,"kind":13,"name":"$acc","containerName":"each_accession_number"},{"kind":13,"line":647,"containerName":"each_accession_number","name":"$id"},{"line":648,"kind":13,"name":"$acc","containerName":"each_accession_number"},{"line":648,"kind":13,"name":"$id","containerName":"each_accession_number"},{"name":"$id","containerName":"each_accession_number","line":650,"kind":13},{"kind":13,"line":651,"containerName":"each_accession_number","name":"$acc"},{"line":654,"kind":13,"name":"$acc","containerName":"each_accession_number"},{"containerName":"each_accession_number","name":"$id","line":654,"kind":13},{"name":"@accnums","containerName":"each_accession_number","line":656,"kind":13},{"kind":13,"line":656,"containerName":"each_accession_number","name":"$acc"},{"containerName":"each_accession_number","name":"@accnums","line":659,"kind":13}],"kind":12},{"line":677,"children":[{"kind":13,"line":678,"containerName":"tiled_hsps","name":"$self","definition":"my","localvar":"my"},{"line":679,"kind":13,"containerName":"tiled_hsps","name":"$self"},{"line":680,"kind":13,"containerName":"tiled_hsps","name":"$self"}],"kind":12,"range":{"start":{"line":677,"character":0},"end":{"line":681,"character":9999}},"containerName":"main::","definition":"sub","name":"tiled_hsps"},{"name":"_hsps_are_tiled","kind":12,"line":679},{"kind":12,"line":680,"name":"_hsps_are_tiled"},{"children":[{"line":724,"kind":12,"name":"throw_not_implemented","containerName":"strand"}],"line":723,"kind":12,"range":{"start":{"line":723,"character":0},"end":{"line":725,"character":9999}},"name":"strand","definition":"sub","containerName":"main::"},{"containerName":"main::","definition":"sub","name":"frame","range":{"start":{"character":0,"line":745},"end":{"character":9999,"line":747}},"kind":12,"line":745,"children":[{"kind":12,"line":746,"name":"throw_not_implemented","containerName":"frame"}]},{"kind":12,"children":[{"containerName":"length_aln","definition":"my","name":"$self","localvar":"my","kind":13,"line":772},{"kind":13,"line":772,"containerName":"length_aln","name":"$seqType"},{"name":"$seqType","containerName":"length_aln","line":773,"kind":13},{"name":"$seqType","containerName":"length_aln","line":774,"kind":13},{"kind":13,"line":774,"name":"$seqType","containerName":"length_aln"},{"containerName":"length_aln","name":"%non_gaps","definition":"my","localvar":"my","kind":13,"line":776},{"name":"$self","containerName":"length_aln","line":776,"kind":13},{"name":"seq_inds","containerName":"length_aln","kind":12,"line":776},{"name":"$seqType","containerName":"length_aln","line":776,"kind":13},{"containerName":"length_aln","name":"$self","kind":13,"line":777},{"line":777,"kind":12,"name":"seq_inds","containerName":"length_aln"},{"name":"$seqType","containerName":"length_aln","line":777,"kind":13},{"containerName":"length_aln","name":"%non_gaps","kind":13,"line":778}],"line":771,"definition":"sub","containerName":"main::","signature":{"label":"length_aln($self,$seqType)","parameters":[{"label":"$self"},{"label":"$seqType"}],"documentation":"1;\n# $Id: PullHitI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Search::Hit::PullHitI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Hit::PullHitI - Bio::Search::Hit::HitI interface for pull parsers.\n\n=head1 SYNOPSIS\n\n\t# This is an interface and cannot be instantiated\n\n    # typically one gets HitI objects from a SearchIO stream via a ResultI\n    use Bio::SearchIO;\n    my $parser = Bio::SearchIO->new(-format => 'hmmer_pull',\n                                   -file => 't/data/hmmpfam.out');\n\n    my $result = $parser->next_result;\n    my $hit    = $result->next_hit;\n\n    $hit_name = $hit->name();\n\n    $desc = $hit->description();\n\n    $len = $hit->length\n\n    $alg = $hit->algorithm();\n\n    $score = $hit->raw_score();\n\n    $significance = $hit->significance();\n\n    $rank = $hit->rank(); # the Nth hit for a specific query\n\n    while( $hsp = $obj->next_hsp()) { ... } # process in iterator fashion\n\n    for my $hsp ( $obj->hsps()()) { ... } # process in list fashion\n\n=head1 DESCRIPTION\n\nThis object handles the hit data from a database sequence search.\n\nPullHitI is for fast implementations that only do parsing work on the hit\ndata when you actually request information by calling one of the HitI\nmethods.\n\nMany methods of HitI are implemented in a way suitable for inheriting classes\nthat use Bio::PullParserI. It only really makes sense for PullHit modules to be\ncreated by (and have as a -parent) PullResult modules.\n\nIn addition to the usual -chunk and -parent, -hit_data is all you should supply\nwhen making a PullHit object. This will store that data and make it accessible\nvia _raw_hit_data, which you can access in your subclass. It would be best to\nsimply provide the data as the input -chunk instead, if the raw data is large\nenough.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 COPYRIGHT\n\nCopyright (c) 2006 Sendu Bala. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::Hit::PullHitI;\n\nuse Bio::Search::SearchUtils;\n\nuse strict;\n\nuse base qw(Bio::PullParserI Bio::Search::Hit::HitI);\n\n=head2 _setup\n\n Title   : _setup\n Usage   : $self->_setup(@args)\n Function: Implementers should call this to setup common fields and deal with\n           common arguments to new().\n Returns : n/a\n Args    : @args received in new().\n\n\nsub _setup {\n    my ($self, @args) = @_;\n    \n    # fields most subclasses probably will want\n    $self->_fields( { ( next_hsp => undef,\n                        num_hsps => undef,\n                        hsps => undef,\n                        hit_start => undef,\n                        query_start => undef,\n                        hit_end => undef,\n                        query_end => undef,\n                        length => undef,\n\t\t\t\t\t\tname => undef ,\n\t\t\t\t\t\taccession => undef ) } );\n    \n    my ($parent, $chunk, $hit_data) = $self->_rearrange([qw(PARENT\n                                                            CHUNK\n                                                            HIT_DATA)], @args);\n    $self->throw(\"Need -parent or -chunk to be defined\") unless $parent || $chunk;\n    \n\t$self->parent($parent) if $parent;\n    \n    if ($chunk) {\n        my ($io, $start, $end) = (undef, 0, undef);\n        if (ref($chunk) eq 'ARRAY') {\n            ($io, $start, $end) = @{$chunk};\n        }\n        else {\n            $io = $chunk;\n        }\n        $self->chunk($io, -start => $start, -end => $end);\n    }\n    \n    $self->_raw_hit_data($hit_data) if $hit_data;\n}\n\nsub _raw_hit_data {\n\tmy $self = shift;\n\tif (@_) {\n\t\t$self->{_raw_hit_data} = shift;\n\t}\n\treturn $self->{_raw_hit_data};\n}\n\n#\n# Some of these methods are written explitely to avoid HitI throwing not\n# implemented; if it didn't do that then PullParserI AUTOLOAD would have\n# cought them.\n#\n\n=head2 name\n\n Title   : name\n Usage   : $hit_name = $hit->name();\n Function: returns the name of the Hit sequence\n Returns : a scalar string\n Args    : none\n\nThe B<name> of a hit is unique within a Result or within an Iteration.\n\n\nsub name {\n    return shift->get_field('name');\n}\n\n=head2 description\n\n Title   : description\n Usage   : $desc = $hit->description();\n Function: Retrieve the description for the hit\n Returns : a scalar string\n Args    : none\n\n\nsub description {\n    return shift->get_field('description');\n}\n\n=head2 accession\n\n Title   : accession\n Usage   : $acc = $hit->accession();\n Function: Retrieve the accession (if available) for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub accession {\n    return shift->get_field('accession');\n}\n\n=head2 locus\n\n Title   : locus\n Usage   : $acc = $hit->locus();\n Function: Retrieve the locus(if available) for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub locus {\n    return shift->get_field('locus');\n}\n\n=head2 length\n\n Title   : length\n Usage   : my $len = $hit->length\n Function: Returns the length of the hit \n Returns : integer\n Args    : none\n\n\nsub length {\n   return shift->get_field('length');\n}\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : $alg = $hit->algorithm();\n Function: Gets the algorithm specification that was used to obtain the hit\n           For BLAST, the algorithm denotes what type of sequence was aligned \n           against what (BLASTN: dna-dna, BLASTP prt-prt, BLASTX translated \n           dna-prt, TBLASTN prt-translated dna, TBLASTX translated \n           dna-translated dna).\n Returns : a scalar string \n Args    : none\n\n\nsub algorithm {\n    return shift->get_field('algorithm');\n}\n\n=head2 raw_score\n\n Title   : raw_score\n Usage   : $score = $hit->raw_score();\n Function: Gets the \"raw score\" generated by the algorithm.  What\n           this score is exactly will vary from algorithm to algorithm,\n           returning undef if unavailable.\n Returns : a scalar value\n Args    : none\n\n\nsub raw_score {\n    return shift->get_field('score');\n}\n\n=head2 score\n\nEquivalent to L<raw_score()|raw_score>\n\n\nsub score {\n    return shift->get_field('score');\n}\n\n=head2 significance\n\n Title   : significance\n Usage   : $significance = $hit->significance();\n Function: Used to obtain the E or P value of a hit, i.e. the probability that\n           this particular hit was obtained purely by random chance.  If\n           information is not available (nor calculatable from other\n           information sources), return undef.\n Returns : a scalar value or undef if unavailable\n Args    : none\n\n\nsub significance {\n    return shift->get_field('significance');\n}\n\n=head2 bits\n\n Usage     : $hit_object->bits();\n Purpose   : Gets the bit score of the best HSP for the current hit.\n Example   : $bits = $hit_object->bits();\n Returns   : Integer or double for FASTA reports\n Argument  : n/a\n Comments  : For BLAST1, the non-bit score is listed in the summary line.\n\nSee Also   : L<score()|score>\n\n\nsub bits {\n    return shift->get_field('bits');\n}\n\n=head2 next_hsp\n\n Title    : next_hsp\n Usage    : while( $hsp = $obj->next_hsp()) { ... }\n Function : Returns the next available High Scoring Pair\n Example  : \n Returns  : L<Bio::Search::HSP::HSPI> object or null if finished\n Args     : none\n\n\nsub next_hsp {\n    return shift->get_field('next_hsp');\n}\n\n=head2 hsps\n\n Usage     : $hit_object->hsps();\n Purpose   : Get a list containing all HSP objects.\n           : Get the numbers of HSPs for the current hit.\n Example   : @hsps = $hit_object->hsps();\n           : $num  = $hit_object->hsps();  # alternatively, use num_hsps()\n Returns   : Array context : list of L<Bio::Search::HSP::BlastHSP> objects.\n           : Scalar context: integer (number of HSPs).\n           :                 (Equivalent to num_hsps()).\n Argument  : n/a. Relies on wantarray\n Throws    : Exception if the HSPs have not been collected.\n\nSee Also   : L<hsp()|hsp>, L<num_hsps()|num_hsps>\n\n\nsub hsps {\n    return shift->get_field('hsps');\n}\n\n=head2 num_hsps\n\n Usage     : $hit_object->num_hsps();\n Purpose   : Get the number of HSPs for the present Blast hit.\n Example   : $nhsps = $hit_object->num_hsps();\n Returns   : Integer\n Argument  : n/a\n Throws    : Exception if the HSPs have not been collected.\n\nSee Also   : L<hsps()|hsps>\n\n\nsub num_hsps {\n    return shift->get_field('num_hsps');\n}\n\n#\n# HitI/ GenericHit methods that are unrelated to simply parsing information\n# directly out of a file, but need more complex calculation; mostly not\n# implemented here.\n#\n\n=head2 seq_inds\n\n Usage     : $hit->seq_inds( seq_type, class, collapse );\n Purpose   : Get a list of residue positions (indices) across all HSPs\n           : for identical or conserved residues in the query or sbjct sequence.\n Example   : @s_ind = $hit->seq_inds('query', 'identical');\n           : @h_ind = $hit->seq_inds('hit', 'conserved');\n           : @h_ind = $hit->seq_inds('hit', 'conserved', 1);\n Returns   : Array of integers \n           : May include ranges if collapse is non-zero.\n Argument  : [0] seq_type  = 'query' or 'hit' or 'sbjct'  (default = 'query')\n           :                 ('sbjct' is synonymous with 'hit')\n           : [1] class = 'identical' or 'conserved' or 'nomatch' or 'gap'\n\t\t   :         (default = 'identical')\n           :         (can be shortened to 'id' or 'cons')\n\t\t   :         Note that 'conserved' includes identical unless you use\n\t\t   :         'conserved-not-identical'\n           : [2] collapse = boolean, if non-zero, consecutive positions are\n           :             merged using a range notation, e.g.,\n           :             \"1 2 3 4 5 7 9 10 11\" collapses to \"1-5 7 9-11\". This\n           :             is useful for  consolidating long lists. Default = no\n           :             collapse.\n Throws    : n/a.\n\nSee Also   : L<Bio::Search::HSP::HSPI::seq_inds()|Bio::Search::HSP::HSPI>\n\n\nsub seq_inds {\n    my ($self, $seqType, $class, $collapse) = @_;\n    \n    $seqType  ||= 'query';\n    $class ||= 'identical';\n    $collapse ||= 0;\n    \n    $seqType = 'hit' if $seqType eq 'sbjct';\n    \n\tmy $storage_name = '_seq_inds_'.$seqType.'_'.$class;\n\tunless (defined $self->{$storage_name}) {\n\t\tmy @inds;    \n\t\tforeach my $hsp ($self->hsps) {\n\t\t\t# This will merge data for all HSPs together.\n\t\t\tpush @inds, $hsp->seq_inds($seqType, $class);\n\t\t}\n\t\t\n\t\t# Need to remove duplicates and sort the merged positions, unless gaps.\n\t\tif (@inds && $class ne 'gap') {\n\t\t\tmy %tmp = map { $_, 1 } @inds;\n\t\t\t@inds = sort {$a <=> $b} keys %tmp;\n\t\t}\n\t\t\n\t\t$self->{$storage_name} = \\@inds;\n\t}\n\t\n\tmy @inds = @{$self->{$storage_name}};\n    $collapse ? &Bio::Search::SearchUtils::collapse_nums(@inds) : @inds;\n}\n\n=head2 rewind\n\n Title   : rewind\n Usage   : $hit->rewind;\n Function: Allow one to reset the HSP iterator to the beginning if possible\n Returns : none\n Args    : none\n\n\nsub rewind {\n    shift->throw_not_implemented();\n}\n\n=head2 overlap\n\n Usage     : $hit_object->overlap( [integer] );\n Purpose   : Gets/Sets the allowable amount overlap between different HSP\n             sequences.\n Example   : $hit_object->overlap(5);\n           : $overlap = $hit_object->overlap;\n Returns   : Integer.\n Argument  : integer.\n Throws    : n/a\n Status    : Deprecated\n Comments  : This value isn't used for anything\n\n\nsub overlap {\n    my $self = shift;\n    if (@_) { $self->{_overlap} = shift }\n    return $self->{_overlap} || 0;\n}\n\n=head2 n\n\n Usage     : $hit_object->n();\n Purpose   : Gets the N number for the current Blast hit.\n           : This is the number of HSPs in the set which was ascribed\n           : the lowest P-value (listed on the description line).\n           : This number is not the same as the total number of HSPs.\n           : To get the total number of HSPs, use num_hsps().\n Example   : $n = $hit_object->n();\n Returns   : Integer\n Argument  : n/a\n Throws    : Exception if HSPs have not been set (BLAST2 reports).\n Comments  : Note that the N parameter is not reported in gapped BLAST2.\n           : Calling n() on such reports will result in a call to num_hsps().\n           : The num_hsps() method will count the actual number of\n           : HSPs in the alignment listing, which may exceed N in\n           : some cases.\n\nSee Also   : L<num_hsps()|num_hsps>\n\n\nsub n {\n    return shift->get_field('num_hsps');\n}\n\n=head2 p\n\n Usage     : $hit_object->p( [format] );\n Purpose   : Get the P-value for the best HSP of the given BLAST hit.\n           : (Note that P-values are not provided with NCBI Blast2 reports).\n Example   : $p =  $sbjct->p;\n           : $p =  $sbjct->p('exp');  # get exponent only.\n           : ($num, $exp) =  $sbjct->p('parts'); # split sci notation into parts\n Returns   : Float or scientific notation number (the raw P-value, DEFAULT).\n           : Integer if format == 'exp' (the magnitude of the base 10 exponent).\n           : 2-element list (float, int) if format == 'parts' and P-value\n           :                is in scientific notation (See Comments).\n Argument  : format: string of 'raw' | 'exp' | 'parts'\n           :    'raw' returns value given in report. Default. (1.2e-34)\n           :    'exp' returns exponent value only (34)\n           :    'parts' returns the decimal and exponent as a \n           :            2-element list (1.2, -34) (See Comments).\n Throws    : Warns if no P-value is defined. Uses expect instead.\n Comments  : Using the 'parts' argument is not recommended since it will not\n           : work as expected if the P-value is not in scientific notation.\n           : That is, floats are not converted into sci notation before\n           : splitting into parts.\n\nSee Also   : L<expect()|expect>, L<signif()|signif>,\n             L<Bio::Search::BlastUtils::get_exponent()|Bio::Search::BlastUtils>\n\n\nsub p {\n    shift->throw_not_implemented;\n}\n\n=head2 hsp\n\n Usage     : $hit_object->hsp( [string] );\n Purpose   : Get a single HSPI object for the present HitI object.\n Example   : $hspObj  = $hit_object->hsp;  # same as 'best'\n           : $hspObj  = $hit_object->hsp('best');\n           : $hspObj  = $hit_object->hsp('worst');\n Returns   : Object reference for a L<Bio::Search::HSP::HSPI> object.\n Argument  : String (or no argument).\n           :   No argument (default) = highest scoring HSP (same as 'best').\n           :   'best'  = highest scoring HSP.\n           :   'worst' = lowest scoring HSP.\n Throws    : Exception if an unrecognized argument is used.\n\nSee Also   : L<hsps()|hsps>, L<num_hsps>()\n\n\nsub hsp {\n    shift->throw_not_implemented;\n}\n\n=head2 logical_length\n\n Usage     : $hit_object->logical_length( [seq_type] );\n           : (mostly intended for internal use).\n Purpose   : Get the logical length of the hit sequence.\n           : If the Blast is a TBLASTN or TBLASTX, the returned length \n           : is the length of the would-be amino acid sequence (length/3).\n           : For all other BLAST flavors, this function is the same as length().\n Example   : $len    = $hit_object->logical_length();\n Returns   : Integer \n Argument  : seq_type = 'query' or 'hit' or 'sbjct' (default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  : This is important for functions like frac_aligned_query()\n           : which need to operate in amino acid coordinate space when dealing\n           : with [T]BLAST[NX] type reports.\n\nSee Also   : L<length()|length>, L<frac_aligned_query()|frac_aligned_query>,\n             L<frac_aligned_hit()|frac_aligned_hit>\n\n\nsub logical_length {\n    my ($self, $type) = @_;\n    $type ||= 'query';\n    $type = lc($type);\n\t$type = 'hit' if $type eq 'sbjct';\n    if ($type eq 'query') {\n        return $self->get_field('query_length');\n    }\n    elsif ($type eq 'hit') {\n        return $self->get_field('length');\n    }\n}\n\n=head2 rank\n\n Title   : rank\n Usage   : $obj->rank($newval)\n Function: Get/Set the rank of this Hit in the Query search list\n           i.e. this is the Nth hit for a specific query\n Returns : value of rank\n Args    : newvalue (optional)\n\n\nsub rank {\n    return shift->get_field('rank');\n}\n\n=head2 each_accession_number\n\n Title   : each_accession_number\n Usage   : $obj->each_accession_number\n Function: Get each accession number listed in the description of the hit.\n           If there are no alternatives, then only the primary accession will \n           be given (if there is one).\n Returns : list of all accession numbers in the description\n Args    : none\n\n\nsub each_accession_number {\n    my $self = shift;\n    my $accession = $self->get_field('accession') if $self->has_field('accession');\n    my $desc = $self->get_field('description') if $self->has_field('description');\n    return unless $accession || $desc;\n    \n    my @accnums;\n    push (@accnums, $accession) if $accession;\n    \n    if (defined $desc) { \n        while ($desc =~ /(\\b\\S+\\|\\S*\\|\\S*\\s?)/g) {\n            my $id = $1;\n            my $acc;\n            if ($id =~ /(?:gb|emb|dbj|sp|pdb|bbs|ref|tp[gde])\\|(.*)\\|(?:.*)/) {\n                ($acc) = split /\\./, $1; \n            }\n            elsif ($id =~ /(?:pir|prf|pat|gnl)\\|(?:.*)\\|(.*)/) {\n                ($acc) = split /\\./, $1;  \n            }\n            elsif ($id =~ /(?:gim|gi|bbm|bbs|lcl)\\|(?:\\d*)/) {\n                $acc = $id;\n            }\n            elsif ($id =~ /(?:oth)\\|(.*)\\|(?:.*)\\|(?:.*)/ ) { # discontinued...\n                $acc = $1;\n            }\n            else {\n                $acc = $id;\n            }\n            push(@accnums, $acc);\n        }\n    }\n    return @accnums;\n}\n\n=head2 tiled_hsps\n\n Usage     : $hit_object->tiled_hsps( [integer] );\n Purpose   : Gets/Sets an indicator for whether or not the HSPs in this Hit \n           : have been tiled.\n Example   : $hit_object->tiled_hsps(1);\n           : if( $hit_object->tiled_hsps ) { # do something }\n Returns   : Boolean (1 or 0) \n Argument  : integer (optional)\n Throws    : n/a\n Status    : Deprecated\n Notes     : This value is not used for anything\n\n\nsub tiled_hsps {\n    my $self = shift;\n    if (@_) { $self->{_hsps_are_tiled} = shift }\n    return $self->{_hsps_are_tiled} || 0;\n}\n\n=head2 strand\n\n Usage     : $sbjct->strand( [seq_type] );\n Purpose   : Gets the strand(s) for the query, sbjct, or both sequences\n           : in the best HSP of the BlastHit object after HSP tiling.\n           : Only valid for BLASTN, TBLASTX, BLASTX-query, TBLASTN-hit.\n Example   : $qstrand = $sbjct->strand('query');\n           : $sstrand = $sbjct->strand('hit');\n           : ($qstrand, $sstrand) = $sbjct->strand();\n Returns   : scalar context: integer '1', '-1', or '0'\n           : array context without args: list of two strings (queryStrand, sbjctStrand)\n           : Array context can be \"induced\" by providing an argument of 'list' or 'array'.\n Argument  : In scalar context: seq_type = 'query' or 'hit' or 'sbjct' (default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n           : If you don't want the tiled data, iterate through each HSP\n           : calling strand() on each (use hsps() to get all HSPs).\n           :\n           : Formerly (prior to 10/21/02), this method would return the\n           : string \"-1/1\" for hits with HSPs on both strands.\n           : However, now that strand and frame is properly being accounted\n           : for during HSP tiling, it makes more sense for strand()\n           : to return the strand data for the best HSP after tiling.\n           :\n           : If you really want to know about hits on opposite strands,\n           : you should be iterating through the HSPs using methods on the\n           : HSP objects.\n           :\n           : A possible use case where knowing whether a hit has HSPs \n           : on both strands would be when filtering via SearchIO for hits with \n           : this property. However, in this case it would be better to have a\n           : dedicated method such as $hit->hsps_on_both_strands(). Similarly\n           : for frame. This could be provided if there is interest.\n\nSee Also   : L<Bio::Search::HSP::HSPI::strand>()\n\n\nsub strand {\n    shift->throw_not_implemented;\n}\n\n=head2 frame\n\n Usage     : $hit_object->frame();\n Purpose   : Gets the reading frame for the best HSP after HSP tiling.\n           : This is only valid for BLASTX and TBLASTN/X type reports.\n Example   : $frame = $hit_object->frame();\n Returns   : Integer (-2 .. +2)\n Argument  : n/a\n Throws    : Exception if HSPs have not been set.\n Comments  : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n           : If you don't want the tiled data, iterate through each HSP\n           : calling frame() on each (use hsps() to get all HSPs).\n\nSee Also   : L<hsps()|hsps>\n\n\nsub frame {\n    shift->throw_not_implemented;\n}\n\n=head2 length_aln\n\n Usage     : $hit_object->length_aln( [seq_type] );\n Purpose   : Get the total length of the aligned region for query or sbjct seq.\n           : This number will include all HSPs, and excludes gaps.\n Example   : $len    = $hit_object->length_aln(); # default = query\n           : $lenAln = $hit_object->length_aln('query');\n Returns   : Integer \n Argument  : seq_Type = 'query' or 'hit' or 'sbjct' (Default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : Exception if the argument is not recognized.\n Comments  : This method will report the logical length of the alignment,\n           : meaning that for TBLAST[NX] reports, the length is reported\n           : using amino acid coordinate space (i.e., nucleotides / 3).\n\nSee Also   : L<length()|length>, L<frac_aligned_query()|frac_aligned_query>,\n             L<frac_aligned_hit()|frac_aligned_hit>, L<gaps()|gaps>,\n             L<Bio::Search::SearchUtils::tile_hsps()|Bio::Search::SearchUtils>,\n             L<Bio::Search::HSP::BlastHSP::length()|Bio::Search::HSP::BlastHSP>"},"detail":"($self,$seqType)","name":"length_aln","range":{"start":{"line":771,"character":0},"end":{"character":9999,"line":779}}},{"children":[{"definition":"my","name":"$self","containerName":"gaps","localvar":"my","kind":13,"line":810},{"containerName":"gaps","name":"$seqType","line":810,"kind":13},{"kind":13,"line":812,"name":"$seqType","containerName":"gaps"},{"name":"$seqType","containerName":"gaps","kind":13,"line":813},{"name":"$seqType","containerName":"gaps","line":813,"kind":13},{"containerName":"gaps","name":"$seqType","line":815,"kind":13},{"kind":13,"line":816,"containerName":"gaps","name":"$self"},{"containerName":"gaps","name":"seq_inds","line":816,"kind":12},{"name":"$self","containerName":"gaps","kind":13,"line":816},{"line":816,"kind":12,"name":"seq_inds","containerName":"gaps"},{"name":"$seqType","containerName":"gaps","line":818,"kind":13},{"line":819,"kind":13,"containerName":"gaps","name":"$self"},{"line":819,"kind":12,"name":"seq_inds","containerName":"gaps"},{"name":"$self","containerName":"gaps","line":819,"kind":13},{"name":"seq_inds","containerName":"gaps","line":819,"kind":12},{"kind":13,"line":822,"containerName":"gaps","name":"$self"},{"kind":12,"line":822,"name":"seq_inds","containerName":"gaps"},{"name":"$seqType","containerName":"gaps","line":822,"kind":13}],"line":809,"kind":12,"signature":{"label":"gaps($self,$seqType)","documentation":"1;\n# $Id: PullHitI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Search::Hit::PullHitI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Hit::PullHitI - Bio::Search::Hit::HitI interface for pull parsers.\n\n=head1 SYNOPSIS\n\n\t# This is an interface and cannot be instantiated\n\n    # typically one gets HitI objects from a SearchIO stream via a ResultI\n    use Bio::SearchIO;\n    my $parser = Bio::SearchIO->new(-format => 'hmmer_pull',\n                                   -file => 't/data/hmmpfam.out');\n\n    my $result = $parser->next_result;\n    my $hit    = $result->next_hit;\n\n    $hit_name = $hit->name();\n\n    $desc = $hit->description();\n\n    $len = $hit->length\n\n    $alg = $hit->algorithm();\n\n    $score = $hit->raw_score();\n\n    $significance = $hit->significance();\n\n    $rank = $hit->rank(); # the Nth hit for a specific query\n\n    while( $hsp = $obj->next_hsp()) { ... } # process in iterator fashion\n\n    for my $hsp ( $obj->hsps()()) { ... } # process in list fashion\n\n=head1 DESCRIPTION\n\nThis object handles the hit data from a database sequence search.\n\nPullHitI is for fast implementations that only do parsing work on the hit\ndata when you actually request information by calling one of the HitI\nmethods.\n\nMany methods of HitI are implemented in a way suitable for inheriting classes\nthat use Bio::PullParserI. It only really makes sense for PullHit modules to be\ncreated by (and have as a -parent) PullResult modules.\n\nIn addition to the usual -chunk and -parent, -hit_data is all you should supply\nwhen making a PullHit object. This will store that data and make it accessible\nvia _raw_hit_data, which you can access in your subclass. It would be best to\nsimply provide the data as the input -chunk instead, if the raw data is large\nenough.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 COPYRIGHT\n\nCopyright (c) 2006 Sendu Bala. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::Hit::PullHitI;\n\nuse Bio::Search::SearchUtils;\n\nuse strict;\n\nuse base qw(Bio::PullParserI Bio::Search::Hit::HitI);\n\n=head2 _setup\n\n Title   : _setup\n Usage   : $self->_setup(@args)\n Function: Implementers should call this to setup common fields and deal with\n           common arguments to new().\n Returns : n/a\n Args    : @args received in new().\n\n\nsub _setup {\n    my ($self, @args) = @_;\n    \n    # fields most subclasses probably will want\n    $self->_fields( { ( next_hsp => undef,\n                        num_hsps => undef,\n                        hsps => undef,\n                        hit_start => undef,\n                        query_start => undef,\n                        hit_end => undef,\n                        query_end => undef,\n                        length => undef,\n\t\t\t\t\t\tname => undef ,\n\t\t\t\t\t\taccession => undef ) } );\n    \n    my ($parent, $chunk, $hit_data) = $self->_rearrange([qw(PARENT\n                                                            CHUNK\n                                                            HIT_DATA)], @args);\n    $self->throw(\"Need -parent or -chunk to be defined\") unless $parent || $chunk;\n    \n\t$self->parent($parent) if $parent;\n    \n    if ($chunk) {\n        my ($io, $start, $end) = (undef, 0, undef);\n        if (ref($chunk) eq 'ARRAY') {\n            ($io, $start, $end) = @{$chunk};\n        }\n        else {\n            $io = $chunk;\n        }\n        $self->chunk($io, -start => $start, -end => $end);\n    }\n    \n    $self->_raw_hit_data($hit_data) if $hit_data;\n}\n\nsub _raw_hit_data {\n\tmy $self = shift;\n\tif (@_) {\n\t\t$self->{_raw_hit_data} = shift;\n\t}\n\treturn $self->{_raw_hit_data};\n}\n\n#\n# Some of these methods are written explitely to avoid HitI throwing not\n# implemented; if it didn't do that then PullParserI AUTOLOAD would have\n# cought them.\n#\n\n=head2 name\n\n Title   : name\n Usage   : $hit_name = $hit->name();\n Function: returns the name of the Hit sequence\n Returns : a scalar string\n Args    : none\n\nThe B<name> of a hit is unique within a Result or within an Iteration.\n\n\nsub name {\n    return shift->get_field('name');\n}\n\n=head2 description\n\n Title   : description\n Usage   : $desc = $hit->description();\n Function: Retrieve the description for the hit\n Returns : a scalar string\n Args    : none\n\n\nsub description {\n    return shift->get_field('description');\n}\n\n=head2 accession\n\n Title   : accession\n Usage   : $acc = $hit->accession();\n Function: Retrieve the accession (if available) for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub accession {\n    return shift->get_field('accession');\n}\n\n=head2 locus\n\n Title   : locus\n Usage   : $acc = $hit->locus();\n Function: Retrieve the locus(if available) for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub locus {\n    return shift->get_field('locus');\n}\n\n=head2 length\n\n Title   : length\n Usage   : my $len = $hit->length\n Function: Returns the length of the hit \n Returns : integer\n Args    : none\n\n\nsub length {\n   return shift->get_field('length');\n}\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : $alg = $hit->algorithm();\n Function: Gets the algorithm specification that was used to obtain the hit\n           For BLAST, the algorithm denotes what type of sequence was aligned \n           against what (BLASTN: dna-dna, BLASTP prt-prt, BLASTX translated \n           dna-prt, TBLASTN prt-translated dna, TBLASTX translated \n           dna-translated dna).\n Returns : a scalar string \n Args    : none\n\n\nsub algorithm {\n    return shift->get_field('algorithm');\n}\n\n=head2 raw_score\n\n Title   : raw_score\n Usage   : $score = $hit->raw_score();\n Function: Gets the \"raw score\" generated by the algorithm.  What\n           this score is exactly will vary from algorithm to algorithm,\n           returning undef if unavailable.\n Returns : a scalar value\n Args    : none\n\n\nsub raw_score {\n    return shift->get_field('score');\n}\n\n=head2 score\n\nEquivalent to L<raw_score()|raw_score>\n\n\nsub score {\n    return shift->get_field('score');\n}\n\n=head2 significance\n\n Title   : significance\n Usage   : $significance = $hit->significance();\n Function: Used to obtain the E or P value of a hit, i.e. the probability that\n           this particular hit was obtained purely by random chance.  If\n           information is not available (nor calculatable from other\n           information sources), return undef.\n Returns : a scalar value or undef if unavailable\n Args    : none\n\n\nsub significance {\n    return shift->get_field('significance');\n}\n\n=head2 bits\n\n Usage     : $hit_object->bits();\n Purpose   : Gets the bit score of the best HSP for the current hit.\n Example   : $bits = $hit_object->bits();\n Returns   : Integer or double for FASTA reports\n Argument  : n/a\n Comments  : For BLAST1, the non-bit score is listed in the summary line.\n\nSee Also   : L<score()|score>\n\n\nsub bits {\n    return shift->get_field('bits');\n}\n\n=head2 next_hsp\n\n Title    : next_hsp\n Usage    : while( $hsp = $obj->next_hsp()) { ... }\n Function : Returns the next available High Scoring Pair\n Example  : \n Returns  : L<Bio::Search::HSP::HSPI> object or null if finished\n Args     : none\n\n\nsub next_hsp {\n    return shift->get_field('next_hsp');\n}\n\n=head2 hsps\n\n Usage     : $hit_object->hsps();\n Purpose   : Get a list containing all HSP objects.\n           : Get the numbers of HSPs for the current hit.\n Example   : @hsps = $hit_object->hsps();\n           : $num  = $hit_object->hsps();  # alternatively, use num_hsps()\n Returns   : Array context : list of L<Bio::Search::HSP::BlastHSP> objects.\n           : Scalar context: integer (number of HSPs).\n           :                 (Equivalent to num_hsps()).\n Argument  : n/a. Relies on wantarray\n Throws    : Exception if the HSPs have not been collected.\n\nSee Also   : L<hsp()|hsp>, L<num_hsps()|num_hsps>\n\n\nsub hsps {\n    return shift->get_field('hsps');\n}\n\n=head2 num_hsps\n\n Usage     : $hit_object->num_hsps();\n Purpose   : Get the number of HSPs for the present Blast hit.\n Example   : $nhsps = $hit_object->num_hsps();\n Returns   : Integer\n Argument  : n/a\n Throws    : Exception if the HSPs have not been collected.\n\nSee Also   : L<hsps()|hsps>\n\n\nsub num_hsps {\n    return shift->get_field('num_hsps');\n}\n\n#\n# HitI/ GenericHit methods that are unrelated to simply parsing information\n# directly out of a file, but need more complex calculation; mostly not\n# implemented here.\n#\n\n=head2 seq_inds\n\n Usage     : $hit->seq_inds( seq_type, class, collapse );\n Purpose   : Get a list of residue positions (indices) across all HSPs\n           : for identical or conserved residues in the query or sbjct sequence.\n Example   : @s_ind = $hit->seq_inds('query', 'identical');\n           : @h_ind = $hit->seq_inds('hit', 'conserved');\n           : @h_ind = $hit->seq_inds('hit', 'conserved', 1);\n Returns   : Array of integers \n           : May include ranges if collapse is non-zero.\n Argument  : [0] seq_type  = 'query' or 'hit' or 'sbjct'  (default = 'query')\n           :                 ('sbjct' is synonymous with 'hit')\n           : [1] class = 'identical' or 'conserved' or 'nomatch' or 'gap'\n\t\t   :         (default = 'identical')\n           :         (can be shortened to 'id' or 'cons')\n\t\t   :         Note that 'conserved' includes identical unless you use\n\t\t   :         'conserved-not-identical'\n           : [2] collapse = boolean, if non-zero, consecutive positions are\n           :             merged using a range notation, e.g.,\n           :             \"1 2 3 4 5 7 9 10 11\" collapses to \"1-5 7 9-11\". This\n           :             is useful for  consolidating long lists. Default = no\n           :             collapse.\n Throws    : n/a.\n\nSee Also   : L<Bio::Search::HSP::HSPI::seq_inds()|Bio::Search::HSP::HSPI>\n\n\nsub seq_inds {\n    my ($self, $seqType, $class, $collapse) = @_;\n    \n    $seqType  ||= 'query';\n    $class ||= 'identical';\n    $collapse ||= 0;\n    \n    $seqType = 'hit' if $seqType eq 'sbjct';\n    \n\tmy $storage_name = '_seq_inds_'.$seqType.'_'.$class;\n\tunless (defined $self->{$storage_name}) {\n\t\tmy @inds;    \n\t\tforeach my $hsp ($self->hsps) {\n\t\t\t# This will merge data for all HSPs together.\n\t\t\tpush @inds, $hsp->seq_inds($seqType, $class);\n\t\t}\n\t\t\n\t\t# Need to remove duplicates and sort the merged positions, unless gaps.\n\t\tif (@inds && $class ne 'gap') {\n\t\t\tmy %tmp = map { $_, 1 } @inds;\n\t\t\t@inds = sort {$a <=> $b} keys %tmp;\n\t\t}\n\t\t\n\t\t$self->{$storage_name} = \\@inds;\n\t}\n\t\n\tmy @inds = @{$self->{$storage_name}};\n    $collapse ? &Bio::Search::SearchUtils::collapse_nums(@inds) : @inds;\n}\n\n=head2 rewind\n\n Title   : rewind\n Usage   : $hit->rewind;\n Function: Allow one to reset the HSP iterator to the beginning if possible\n Returns : none\n Args    : none\n\n\nsub rewind {\n    shift->throw_not_implemented();\n}\n\n=head2 overlap\n\n Usage     : $hit_object->overlap( [integer] );\n Purpose   : Gets/Sets the allowable amount overlap between different HSP\n             sequences.\n Example   : $hit_object->overlap(5);\n           : $overlap = $hit_object->overlap;\n Returns   : Integer.\n Argument  : integer.\n Throws    : n/a\n Status    : Deprecated\n Comments  : This value isn't used for anything\n\n\nsub overlap {\n    my $self = shift;\n    if (@_) { $self->{_overlap} = shift }\n    return $self->{_overlap} || 0;\n}\n\n=head2 n\n\n Usage     : $hit_object->n();\n Purpose   : Gets the N number for the current Blast hit.\n           : This is the number of HSPs in the set which was ascribed\n           : the lowest P-value (listed on the description line).\n           : This number is not the same as the total number of HSPs.\n           : To get the total number of HSPs, use num_hsps().\n Example   : $n = $hit_object->n();\n Returns   : Integer\n Argument  : n/a\n Throws    : Exception if HSPs have not been set (BLAST2 reports).\n Comments  : Note that the N parameter is not reported in gapped BLAST2.\n           : Calling n() on such reports will result in a call to num_hsps().\n           : The num_hsps() method will count the actual number of\n           : HSPs in the alignment listing, which may exceed N in\n           : some cases.\n\nSee Also   : L<num_hsps()|num_hsps>\n\n\nsub n {\n    return shift->get_field('num_hsps');\n}\n\n=head2 p\n\n Usage     : $hit_object->p( [format] );\n Purpose   : Get the P-value for the best HSP of the given BLAST hit.\n           : (Note that P-values are not provided with NCBI Blast2 reports).\n Example   : $p =  $sbjct->p;\n           : $p =  $sbjct->p('exp');  # get exponent only.\n           : ($num, $exp) =  $sbjct->p('parts'); # split sci notation into parts\n Returns   : Float or scientific notation number (the raw P-value, DEFAULT).\n           : Integer if format == 'exp' (the magnitude of the base 10 exponent).\n           : 2-element list (float, int) if format == 'parts' and P-value\n           :                is in scientific notation (See Comments).\n Argument  : format: string of 'raw' | 'exp' | 'parts'\n           :    'raw' returns value given in report. Default. (1.2e-34)\n           :    'exp' returns exponent value only (34)\n           :    'parts' returns the decimal and exponent as a \n           :            2-element list (1.2, -34) (See Comments).\n Throws    : Warns if no P-value is defined. Uses expect instead.\n Comments  : Using the 'parts' argument is not recommended since it will not\n           : work as expected if the P-value is not in scientific notation.\n           : That is, floats are not converted into sci notation before\n           : splitting into parts.\n\nSee Also   : L<expect()|expect>, L<signif()|signif>,\n             L<Bio::Search::BlastUtils::get_exponent()|Bio::Search::BlastUtils>\n\n\nsub p {\n    shift->throw_not_implemented;\n}\n\n=head2 hsp\n\n Usage     : $hit_object->hsp( [string] );\n Purpose   : Get a single HSPI object for the present HitI object.\n Example   : $hspObj  = $hit_object->hsp;  # same as 'best'\n           : $hspObj  = $hit_object->hsp('best');\n           : $hspObj  = $hit_object->hsp('worst');\n Returns   : Object reference for a L<Bio::Search::HSP::HSPI> object.\n Argument  : String (or no argument).\n           :   No argument (default) = highest scoring HSP (same as 'best').\n           :   'best'  = highest scoring HSP.\n           :   'worst' = lowest scoring HSP.\n Throws    : Exception if an unrecognized argument is used.\n\nSee Also   : L<hsps()|hsps>, L<num_hsps>()\n\n\nsub hsp {\n    shift->throw_not_implemented;\n}\n\n=head2 logical_length\n\n Usage     : $hit_object->logical_length( [seq_type] );\n           : (mostly intended for internal use).\n Purpose   : Get the logical length of the hit sequence.\n           : If the Blast is a TBLASTN or TBLASTX, the returned length \n           : is the length of the would-be amino acid sequence (length/3).\n           : For all other BLAST flavors, this function is the same as length().\n Example   : $len    = $hit_object->logical_length();\n Returns   : Integer \n Argument  : seq_type = 'query' or 'hit' or 'sbjct' (default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  : This is important for functions like frac_aligned_query()\n           : which need to operate in amino acid coordinate space when dealing\n           : with [T]BLAST[NX] type reports.\n\nSee Also   : L<length()|length>, L<frac_aligned_query()|frac_aligned_query>,\n             L<frac_aligned_hit()|frac_aligned_hit>\n\n\nsub logical_length {\n    my ($self, $type) = @_;\n    $type ||= 'query';\n    $type = lc($type);\n\t$type = 'hit' if $type eq 'sbjct';\n    if ($type eq 'query') {\n        return $self->get_field('query_length');\n    }\n    elsif ($type eq 'hit') {\n        return $self->get_field('length');\n    }\n}\n\n=head2 rank\n\n Title   : rank\n Usage   : $obj->rank($newval)\n Function: Get/Set the rank of this Hit in the Query search list\n           i.e. this is the Nth hit for a specific query\n Returns : value of rank\n Args    : newvalue (optional)\n\n\nsub rank {\n    return shift->get_field('rank');\n}\n\n=head2 each_accession_number\n\n Title   : each_accession_number\n Usage   : $obj->each_accession_number\n Function: Get each accession number listed in the description of the hit.\n           If there are no alternatives, then only the primary accession will \n           be given (if there is one).\n Returns : list of all accession numbers in the description\n Args    : none\n\n\nsub each_accession_number {\n    my $self = shift;\n    my $accession = $self->get_field('accession') if $self->has_field('accession');\n    my $desc = $self->get_field('description') if $self->has_field('description');\n    return unless $accession || $desc;\n    \n    my @accnums;\n    push (@accnums, $accession) if $accession;\n    \n    if (defined $desc) { \n        while ($desc =~ /(\\b\\S+\\|\\S*\\|\\S*\\s?)/g) {\n            my $id = $1;\n            my $acc;\n            if ($id =~ /(?:gb|emb|dbj|sp|pdb|bbs|ref|tp[gde])\\|(.*)\\|(?:.*)/) {\n                ($acc) = split /\\./, $1; \n            }\n            elsif ($id =~ /(?:pir|prf|pat|gnl)\\|(?:.*)\\|(.*)/) {\n                ($acc) = split /\\./, $1;  \n            }\n            elsif ($id =~ /(?:gim|gi|bbm|bbs|lcl)\\|(?:\\d*)/) {\n                $acc = $id;\n            }\n            elsif ($id =~ /(?:oth)\\|(.*)\\|(?:.*)\\|(?:.*)/ ) { # discontinued...\n                $acc = $1;\n            }\n            else {\n                $acc = $id;\n            }\n            push(@accnums, $acc);\n        }\n    }\n    return @accnums;\n}\n\n=head2 tiled_hsps\n\n Usage     : $hit_object->tiled_hsps( [integer] );\n Purpose   : Gets/Sets an indicator for whether or not the HSPs in this Hit \n           : have been tiled.\n Example   : $hit_object->tiled_hsps(1);\n           : if( $hit_object->tiled_hsps ) { # do something }\n Returns   : Boolean (1 or 0) \n Argument  : integer (optional)\n Throws    : n/a\n Status    : Deprecated\n Notes     : This value is not used for anything\n\n\nsub tiled_hsps {\n    my $self = shift;\n    if (@_) { $self->{_hsps_are_tiled} = shift }\n    return $self->{_hsps_are_tiled} || 0;\n}\n\n=head2 strand\n\n Usage     : $sbjct->strand( [seq_type] );\n Purpose   : Gets the strand(s) for the query, sbjct, or both sequences\n           : in the best HSP of the BlastHit object after HSP tiling.\n           : Only valid for BLASTN, TBLASTX, BLASTX-query, TBLASTN-hit.\n Example   : $qstrand = $sbjct->strand('query');\n           : $sstrand = $sbjct->strand('hit');\n           : ($qstrand, $sstrand) = $sbjct->strand();\n Returns   : scalar context: integer '1', '-1', or '0'\n           : array context without args: list of two strings (queryStrand, sbjctStrand)\n           : Array context can be \"induced\" by providing an argument of 'list' or 'array'.\n Argument  : In scalar context: seq_type = 'query' or 'hit' or 'sbjct' (default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n           : If you don't want the tiled data, iterate through each HSP\n           : calling strand() on each (use hsps() to get all HSPs).\n           :\n           : Formerly (prior to 10/21/02), this method would return the\n           : string \"-1/1\" for hits with HSPs on both strands.\n           : However, now that strand and frame is properly being accounted\n           : for during HSP tiling, it makes more sense for strand()\n           : to return the strand data for the best HSP after tiling.\n           :\n           : If you really want to know about hits on opposite strands,\n           : you should be iterating through the HSPs using methods on the\n           : HSP objects.\n           :\n           : A possible use case where knowing whether a hit has HSPs \n           : on both strands would be when filtering via SearchIO for hits with \n           : this property. However, in this case it would be better to have a\n           : dedicated method such as $hit->hsps_on_both_strands(). Similarly\n           : for frame. This could be provided if there is interest.\n\nSee Also   : L<Bio::Search::HSP::HSPI::strand>()\n\n\nsub strand {\n    shift->throw_not_implemented;\n}\n\n=head2 frame\n\n Usage     : $hit_object->frame();\n Purpose   : Gets the reading frame for the best HSP after HSP tiling.\n           : This is only valid for BLASTX and TBLASTN/X type reports.\n Example   : $frame = $hit_object->frame();\n Returns   : Integer (-2 .. +2)\n Argument  : n/a\n Throws    : Exception if HSPs have not been set.\n Comments  : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n           : If you don't want the tiled data, iterate through each HSP\n           : calling frame() on each (use hsps() to get all HSPs).\n\nSee Also   : L<hsps()|hsps>\n\n\nsub frame {\n    shift->throw_not_implemented;\n}\n\n=head2 length_aln\n\n Usage     : $hit_object->length_aln( [seq_type] );\n Purpose   : Get the total length of the aligned region for query or sbjct seq.\n           : This number will include all HSPs, and excludes gaps.\n Example   : $len    = $hit_object->length_aln(); # default = query\n           : $lenAln = $hit_object->length_aln('query');\n Returns   : Integer \n Argument  : seq_Type = 'query' or 'hit' or 'sbjct' (Default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : Exception if the argument is not recognized.\n Comments  : This method will report the logical length of the alignment,\n           : meaning that for TBLAST[NX] reports, the length is reported\n           : using amino acid coordinate space (i.e., nucleotides / 3).\n\nSee Also   : L<length()|length>, L<frac_aligned_query()|frac_aligned_query>,\n             L<frac_aligned_hit()|frac_aligned_hit>, L<gaps()|gaps>,\n             L<Bio::Search::SearchUtils::tile_hsps()|Bio::Search::SearchUtils>,\n             L<Bio::Search::HSP::BlastHSP::length()|Bio::Search::HSP::BlastHSP>\n\n\nsub length_aln {\n    my ($self, $seqType) = @_;\n    $seqType ||= 'query';\n    $seqType = 'hit' if $seqType eq 'sbjct';\n    \n\tmy %non_gaps = map { $_, 1 } $self->seq_inds($seqType, 'conserved'),\n\t\t\t\t\t\t\t     $self->seq_inds($seqType, 'no_match');\n\treturn scalar(keys %non_gaps);\n}\n\n=head2 gaps\n\n Usage     : $hit_object->gaps( [seq_type] );\n Purpose   : Get the number of gaps in the aligned query, hit, or both sequences.\n           : Data is summed across all HSPs.\n Example   : $qgaps = $hit_object->gaps('query');\n           : $hgaps = $hit_object->gaps('hit');\n           : $tgaps = $hit_object->gaps();    # default = total (query + hit)\n Returns   : scalar context: integer\n           : array context without args: two-element list of integers  \n           :    (queryGaps, hitGaps)\n           : Array context can be forced by providing an argument of 'list' or\n\t\t   : 'array'.\n           :\n           : CAUTION: Calling this method within printf or sprintf is arrray\n\t\t   : context.\n           : So this function may not give you what you expect. For example:\n           :          printf \"Total gaps: %d\", $hit->gaps();\n           : Actually returns a two-element array, so what gets printed \n           : is the number of gaps in the query, not the total\n           :\n Argument  : seq_type: 'query' | 'hit' or 'sbjct' | 'total' | 'list'\n           : (default = 'total') ('sbjct' is synonymous with 'hit')\n Comments  : If you need data for each HSP, use hsps() and then interate\n           : through each HSP object.","parameters":[{"label":"$self"},{"label":"$seqType"}]},"detail":"($self,$seqType)","definition":"sub","containerName":"main::","range":{"end":{"character":9999,"line":824},"start":{"character":0,"line":809}},"name":"gaps"},{"range":{"start":{"character":0,"line":849},"end":{"line":892,"character":9999}},"name":"matches","children":[{"kind":13,"line":850,"containerName":"matches","definition":"my","name":"$self","localvar":"my"},{"line":850,"kind":13,"containerName":"matches","name":"$class"},{"containerName":"matches","name":"$seqType","kind":13,"line":850},{"kind":13,"line":855,"containerName":"matches","name":"$seqType"},{"containerName":"matches","name":"$seqType","kind":13,"line":856},{"line":856,"kind":13,"containerName":"matches","name":"$seqType"},{"containerName":"matches","name":"$self","line":858,"kind":13},{"containerName":"matches","name":"$self","kind":13,"line":859},{"containerName":"matches","name":"$self","kind":13,"line":859},{"kind":12,"line":859,"containerName":"matches","name":"seq_inds"},{"line":860,"kind":13,"name":"$self","containerName":"matches"},{"kind":13,"line":860,"name":"$self","containerName":"matches"},{"containerName":"matches","name":"seq_inds","line":860,"kind":12},{"name":"$self","containerName":"matches","kind":13,"line":862},{"kind":13,"line":863,"containerName":"matches","definition":"my","name":"$type","localvar":"my"},{"localvar":"my","containerName":"matches","definition":"my","name":"%identicals","line":866,"kind":13},{"kind":13,"line":866,"containerName":"matches","name":"$self"},{"kind":12,"line":866,"containerName":"matches","name":"seq_inds"},{"containerName":"matches","name":"$type","kind":13,"line":866},{"line":867,"kind":13,"localvar":"my","containerName":"matches","definition":"my","name":"@conserved"},{"line":867,"kind":13,"containerName":"matches","name":"$self"},{"name":"seq_inds","containerName":"matches","line":867,"kind":12},{"kind":13,"line":867,"containerName":"matches","name":"$type"},{"kind":13,"line":869,"containerName":"matches","name":"$real_conserved","definition":"my","localvar":"my"},{"kind":13,"line":870,"containerName":"matches","name":"@conserved"},{"containerName":"matches","name":"$identicals","kind":13,"line":871},{"line":872,"kind":13,"name":"$real_conserved","containerName":"matches"},{"line":875,"kind":13,"name":"$self","containerName":"matches"},{"containerName":"matches","name":"$type","line":875,"kind":13},{"containerName":"matches","name":"$real_conserved","line":875,"kind":13},{"kind":13,"line":880,"name":"$class","containerName":"matches"},{"containerName":"matches","name":"$self","kind":13,"line":881},{"kind":13,"line":881,"containerName":"matches","name":"$seqType"},{"line":881,"kind":13,"name":"$self","containerName":"matches"},{"line":881,"kind":13,"name":"$seqType","containerName":"matches"},{"containerName":"matches","name":"$class","kind":13,"line":884},{"line":885,"kind":13,"name":"$self","containerName":"matches"},{"name":"$seqType","containerName":"matches","kind":13,"line":885},{"containerName":"matches","name":"$self","line":888,"kind":13},{"name":"$seqType","containerName":"matches","line":888,"kind":13}],"line":849,"kind":12,"signature":{"parameters":[{"label":"$self"},{"label":"$class"},{"label":"$seqType"}],"documentation":"1;\n# $Id: PullHitI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Search::Hit::PullHitI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Hit::PullHitI - Bio::Search::Hit::HitI interface for pull parsers.\n\n=head1 SYNOPSIS\n\n\t# This is an interface and cannot be instantiated\n\n    # typically one gets HitI objects from a SearchIO stream via a ResultI\n    use Bio::SearchIO;\n    my $parser = Bio::SearchIO->new(-format => 'hmmer_pull',\n                                   -file => 't/data/hmmpfam.out');\n\n    my $result = $parser->next_result;\n    my $hit    = $result->next_hit;\n\n    $hit_name = $hit->name();\n\n    $desc = $hit->description();\n\n    $len = $hit->length\n\n    $alg = $hit->algorithm();\n\n    $score = $hit->raw_score();\n\n    $significance = $hit->significance();\n\n    $rank = $hit->rank(); # the Nth hit for a specific query\n\n    while( $hsp = $obj->next_hsp()) { ... } # process in iterator fashion\n\n    for my $hsp ( $obj->hsps()()) { ... } # process in list fashion\n\n=head1 DESCRIPTION\n\nThis object handles the hit data from a database sequence search.\n\nPullHitI is for fast implementations that only do parsing work on the hit\ndata when you actually request information by calling one of the HitI\nmethods.\n\nMany methods of HitI are implemented in a way suitable for inheriting classes\nthat use Bio::PullParserI. It only really makes sense for PullHit modules to be\ncreated by (and have as a -parent) PullResult modules.\n\nIn addition to the usual -chunk and -parent, -hit_data is all you should supply\nwhen making a PullHit object. This will store that data and make it accessible\nvia _raw_hit_data, which you can access in your subclass. It would be best to\nsimply provide the data as the input -chunk instead, if the raw data is large\nenough.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 COPYRIGHT\n\nCopyright (c) 2006 Sendu Bala. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::Hit::PullHitI;\n\nuse Bio::Search::SearchUtils;\n\nuse strict;\n\nuse base qw(Bio::PullParserI Bio::Search::Hit::HitI);\n\n=head2 _setup\n\n Title   : _setup\n Usage   : $self->_setup(@args)\n Function: Implementers should call this to setup common fields and deal with\n           common arguments to new().\n Returns : n/a\n Args    : @args received in new().\n\n\nsub _setup {\n    my ($self, @args) = @_;\n    \n    # fields most subclasses probably will want\n    $self->_fields( { ( next_hsp => undef,\n                        num_hsps => undef,\n                        hsps => undef,\n                        hit_start => undef,\n                        query_start => undef,\n                        hit_end => undef,\n                        query_end => undef,\n                        length => undef,\n\t\t\t\t\t\tname => undef ,\n\t\t\t\t\t\taccession => undef ) } );\n    \n    my ($parent, $chunk, $hit_data) = $self->_rearrange([qw(PARENT\n                                                            CHUNK\n                                                            HIT_DATA)], @args);\n    $self->throw(\"Need -parent or -chunk to be defined\") unless $parent || $chunk;\n    \n\t$self->parent($parent) if $parent;\n    \n    if ($chunk) {\n        my ($io, $start, $end) = (undef, 0, undef);\n        if (ref($chunk) eq 'ARRAY') {\n            ($io, $start, $end) = @{$chunk};\n        }\n        else {\n            $io = $chunk;\n        }\n        $self->chunk($io, -start => $start, -end => $end);\n    }\n    \n    $self->_raw_hit_data($hit_data) if $hit_data;\n}\n\nsub _raw_hit_data {\n\tmy $self = shift;\n\tif (@_) {\n\t\t$self->{_raw_hit_data} = shift;\n\t}\n\treturn $self->{_raw_hit_data};\n}\n\n#\n# Some of these methods are written explitely to avoid HitI throwing not\n# implemented; if it didn't do that then PullParserI AUTOLOAD would have\n# cought them.\n#\n\n=head2 name\n\n Title   : name\n Usage   : $hit_name = $hit->name();\n Function: returns the name of the Hit sequence\n Returns : a scalar string\n Args    : none\n\nThe B<name> of a hit is unique within a Result or within an Iteration.\n\n\nsub name {\n    return shift->get_field('name');\n}\n\n=head2 description\n\n Title   : description\n Usage   : $desc = $hit->description();\n Function: Retrieve the description for the hit\n Returns : a scalar string\n Args    : none\n\n\nsub description {\n    return shift->get_field('description');\n}\n\n=head2 accession\n\n Title   : accession\n Usage   : $acc = $hit->accession();\n Function: Retrieve the accession (if available) for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub accession {\n    return shift->get_field('accession');\n}\n\n=head2 locus\n\n Title   : locus\n Usage   : $acc = $hit->locus();\n Function: Retrieve the locus(if available) for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub locus {\n    return shift->get_field('locus');\n}\n\n=head2 length\n\n Title   : length\n Usage   : my $len = $hit->length\n Function: Returns the length of the hit \n Returns : integer\n Args    : none\n\n\nsub length {\n   return shift->get_field('length');\n}\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : $alg = $hit->algorithm();\n Function: Gets the algorithm specification that was used to obtain the hit\n           For BLAST, the algorithm denotes what type of sequence was aligned \n           against what (BLASTN: dna-dna, BLASTP prt-prt, BLASTX translated \n           dna-prt, TBLASTN prt-translated dna, TBLASTX translated \n           dna-translated dna).\n Returns : a scalar string \n Args    : none\n\n\nsub algorithm {\n    return shift->get_field('algorithm');\n}\n\n=head2 raw_score\n\n Title   : raw_score\n Usage   : $score = $hit->raw_score();\n Function: Gets the \"raw score\" generated by the algorithm.  What\n           this score is exactly will vary from algorithm to algorithm,\n           returning undef if unavailable.\n Returns : a scalar value\n Args    : none\n\n\nsub raw_score {\n    return shift->get_field('score');\n}\n\n=head2 score\n\nEquivalent to L<raw_score()|raw_score>\n\n\nsub score {\n    return shift->get_field('score');\n}\n\n=head2 significance\n\n Title   : significance\n Usage   : $significance = $hit->significance();\n Function: Used to obtain the E or P value of a hit, i.e. the probability that\n           this particular hit was obtained purely by random chance.  If\n           information is not available (nor calculatable from other\n           information sources), return undef.\n Returns : a scalar value or undef if unavailable\n Args    : none\n\n\nsub significance {\n    return shift->get_field('significance');\n}\n\n=head2 bits\n\n Usage     : $hit_object->bits();\n Purpose   : Gets the bit score of the best HSP for the current hit.\n Example   : $bits = $hit_object->bits();\n Returns   : Integer or double for FASTA reports\n Argument  : n/a\n Comments  : For BLAST1, the non-bit score is listed in the summary line.\n\nSee Also   : L<score()|score>\n\n\nsub bits {\n    return shift->get_field('bits');\n}\n\n=head2 next_hsp\n\n Title    : next_hsp\n Usage    : while( $hsp = $obj->next_hsp()) { ... }\n Function : Returns the next available High Scoring Pair\n Example  : \n Returns  : L<Bio::Search::HSP::HSPI> object or null if finished\n Args     : none\n\n\nsub next_hsp {\n    return shift->get_field('next_hsp');\n}\n\n=head2 hsps\n\n Usage     : $hit_object->hsps();\n Purpose   : Get a list containing all HSP objects.\n           : Get the numbers of HSPs for the current hit.\n Example   : @hsps = $hit_object->hsps();\n           : $num  = $hit_object->hsps();  # alternatively, use num_hsps()\n Returns   : Array context : list of L<Bio::Search::HSP::BlastHSP> objects.\n           : Scalar context: integer (number of HSPs).\n           :                 (Equivalent to num_hsps()).\n Argument  : n/a. Relies on wantarray\n Throws    : Exception if the HSPs have not been collected.\n\nSee Also   : L<hsp()|hsp>, L<num_hsps()|num_hsps>\n\n\nsub hsps {\n    return shift->get_field('hsps');\n}\n\n=head2 num_hsps\n\n Usage     : $hit_object->num_hsps();\n Purpose   : Get the number of HSPs for the present Blast hit.\n Example   : $nhsps = $hit_object->num_hsps();\n Returns   : Integer\n Argument  : n/a\n Throws    : Exception if the HSPs have not been collected.\n\nSee Also   : L<hsps()|hsps>\n\n\nsub num_hsps {\n    return shift->get_field('num_hsps');\n}\n\n#\n# HitI/ GenericHit methods that are unrelated to simply parsing information\n# directly out of a file, but need more complex calculation; mostly not\n# implemented here.\n#\n\n=head2 seq_inds\n\n Usage     : $hit->seq_inds( seq_type, class, collapse );\n Purpose   : Get a list of residue positions (indices) across all HSPs\n           : for identical or conserved residues in the query or sbjct sequence.\n Example   : @s_ind = $hit->seq_inds('query', 'identical');\n           : @h_ind = $hit->seq_inds('hit', 'conserved');\n           : @h_ind = $hit->seq_inds('hit', 'conserved', 1);\n Returns   : Array of integers \n           : May include ranges if collapse is non-zero.\n Argument  : [0] seq_type  = 'query' or 'hit' or 'sbjct'  (default = 'query')\n           :                 ('sbjct' is synonymous with 'hit')\n           : [1] class = 'identical' or 'conserved' or 'nomatch' or 'gap'\n\t\t   :         (default = 'identical')\n           :         (can be shortened to 'id' or 'cons')\n\t\t   :         Note that 'conserved' includes identical unless you use\n\t\t   :         'conserved-not-identical'\n           : [2] collapse = boolean, if non-zero, consecutive positions are\n           :             merged using a range notation, e.g.,\n           :             \"1 2 3 4 5 7 9 10 11\" collapses to \"1-5 7 9-11\". This\n           :             is useful for  consolidating long lists. Default = no\n           :             collapse.\n Throws    : n/a.\n\nSee Also   : L<Bio::Search::HSP::HSPI::seq_inds()|Bio::Search::HSP::HSPI>\n\n\nsub seq_inds {\n    my ($self, $seqType, $class, $collapse) = @_;\n    \n    $seqType  ||= 'query';\n    $class ||= 'identical';\n    $collapse ||= 0;\n    \n    $seqType = 'hit' if $seqType eq 'sbjct';\n    \n\tmy $storage_name = '_seq_inds_'.$seqType.'_'.$class;\n\tunless (defined $self->{$storage_name}) {\n\t\tmy @inds;    \n\t\tforeach my $hsp ($self->hsps) {\n\t\t\t# This will merge data for all HSPs together.\n\t\t\tpush @inds, $hsp->seq_inds($seqType, $class);\n\t\t}\n\t\t\n\t\t# Need to remove duplicates and sort the merged positions, unless gaps.\n\t\tif (@inds && $class ne 'gap') {\n\t\t\tmy %tmp = map { $_, 1 } @inds;\n\t\t\t@inds = sort {$a <=> $b} keys %tmp;\n\t\t}\n\t\t\n\t\t$self->{$storage_name} = \\@inds;\n\t}\n\t\n\tmy @inds = @{$self->{$storage_name}};\n    $collapse ? &Bio::Search::SearchUtils::collapse_nums(@inds) : @inds;\n}\n\n=head2 rewind\n\n Title   : rewind\n Usage   : $hit->rewind;\n Function: Allow one to reset the HSP iterator to the beginning if possible\n Returns : none\n Args    : none\n\n\nsub rewind {\n    shift->throw_not_implemented();\n}\n\n=head2 overlap\n\n Usage     : $hit_object->overlap( [integer] );\n Purpose   : Gets/Sets the allowable amount overlap between different HSP\n             sequences.\n Example   : $hit_object->overlap(5);\n           : $overlap = $hit_object->overlap;\n Returns   : Integer.\n Argument  : integer.\n Throws    : n/a\n Status    : Deprecated\n Comments  : This value isn't used for anything\n\n\nsub overlap {\n    my $self = shift;\n    if (@_) { $self->{_overlap} = shift }\n    return $self->{_overlap} || 0;\n}\n\n=head2 n\n\n Usage     : $hit_object->n();\n Purpose   : Gets the N number for the current Blast hit.\n           : This is the number of HSPs in the set which was ascribed\n           : the lowest P-value (listed on the description line).\n           : This number is not the same as the total number of HSPs.\n           : To get the total number of HSPs, use num_hsps().\n Example   : $n = $hit_object->n();\n Returns   : Integer\n Argument  : n/a\n Throws    : Exception if HSPs have not been set (BLAST2 reports).\n Comments  : Note that the N parameter is not reported in gapped BLAST2.\n           : Calling n() on such reports will result in a call to num_hsps().\n           : The num_hsps() method will count the actual number of\n           : HSPs in the alignment listing, which may exceed N in\n           : some cases.\n\nSee Also   : L<num_hsps()|num_hsps>\n\n\nsub n {\n    return shift->get_field('num_hsps');\n}\n\n=head2 p\n\n Usage     : $hit_object->p( [format] );\n Purpose   : Get the P-value for the best HSP of the given BLAST hit.\n           : (Note that P-values are not provided with NCBI Blast2 reports).\n Example   : $p =  $sbjct->p;\n           : $p =  $sbjct->p('exp');  # get exponent only.\n           : ($num, $exp) =  $sbjct->p('parts'); # split sci notation into parts\n Returns   : Float or scientific notation number (the raw P-value, DEFAULT).\n           : Integer if format == 'exp' (the magnitude of the base 10 exponent).\n           : 2-element list (float, int) if format == 'parts' and P-value\n           :                is in scientific notation (See Comments).\n Argument  : format: string of 'raw' | 'exp' | 'parts'\n           :    'raw' returns value given in report. Default. (1.2e-34)\n           :    'exp' returns exponent value only (34)\n           :    'parts' returns the decimal and exponent as a \n           :            2-element list (1.2, -34) (See Comments).\n Throws    : Warns if no P-value is defined. Uses expect instead.\n Comments  : Using the 'parts' argument is not recommended since it will not\n           : work as expected if the P-value is not in scientific notation.\n           : That is, floats are not converted into sci notation before\n           : splitting into parts.\n\nSee Also   : L<expect()|expect>, L<signif()|signif>,\n             L<Bio::Search::BlastUtils::get_exponent()|Bio::Search::BlastUtils>\n\n\nsub p {\n    shift->throw_not_implemented;\n}\n\n=head2 hsp\n\n Usage     : $hit_object->hsp( [string] );\n Purpose   : Get a single HSPI object for the present HitI object.\n Example   : $hspObj  = $hit_object->hsp;  # same as 'best'\n           : $hspObj  = $hit_object->hsp('best');\n           : $hspObj  = $hit_object->hsp('worst');\n Returns   : Object reference for a L<Bio::Search::HSP::HSPI> object.\n Argument  : String (or no argument).\n           :   No argument (default) = highest scoring HSP (same as 'best').\n           :   'best'  = highest scoring HSP.\n           :   'worst' = lowest scoring HSP.\n Throws    : Exception if an unrecognized argument is used.\n\nSee Also   : L<hsps()|hsps>, L<num_hsps>()\n\n\nsub hsp {\n    shift->throw_not_implemented;\n}\n\n=head2 logical_length\n\n Usage     : $hit_object->logical_length( [seq_type] );\n           : (mostly intended for internal use).\n Purpose   : Get the logical length of the hit sequence.\n           : If the Blast is a TBLASTN or TBLASTX, the returned length \n           : is the length of the would-be amino acid sequence (length/3).\n           : For all other BLAST flavors, this function is the same as length().\n Example   : $len    = $hit_object->logical_length();\n Returns   : Integer \n Argument  : seq_type = 'query' or 'hit' or 'sbjct' (default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  : This is important for functions like frac_aligned_query()\n           : which need to operate in amino acid coordinate space when dealing\n           : with [T]BLAST[NX] type reports.\n\nSee Also   : L<length()|length>, L<frac_aligned_query()|frac_aligned_query>,\n             L<frac_aligned_hit()|frac_aligned_hit>\n\n\nsub logical_length {\n    my ($self, $type) = @_;\n    $type ||= 'query';\n    $type = lc($type);\n\t$type = 'hit' if $type eq 'sbjct';\n    if ($type eq 'query') {\n        return $self->get_field('query_length');\n    }\n    elsif ($type eq 'hit') {\n        return $self->get_field('length');\n    }\n}\n\n=head2 rank\n\n Title   : rank\n Usage   : $obj->rank($newval)\n Function: Get/Set the rank of this Hit in the Query search list\n           i.e. this is the Nth hit for a specific query\n Returns : value of rank\n Args    : newvalue (optional)\n\n\nsub rank {\n    return shift->get_field('rank');\n}\n\n=head2 each_accession_number\n\n Title   : each_accession_number\n Usage   : $obj->each_accession_number\n Function: Get each accession number listed in the description of the hit.\n           If there are no alternatives, then only the primary accession will \n           be given (if there is one).\n Returns : list of all accession numbers in the description\n Args    : none\n\n\nsub each_accession_number {\n    my $self = shift;\n    my $accession = $self->get_field('accession') if $self->has_field('accession');\n    my $desc = $self->get_field('description') if $self->has_field('description');\n    return unless $accession || $desc;\n    \n    my @accnums;\n    push (@accnums, $accession) if $accession;\n    \n    if (defined $desc) { \n        while ($desc =~ /(\\b\\S+\\|\\S*\\|\\S*\\s?)/g) {\n            my $id = $1;\n            my $acc;\n            if ($id =~ /(?:gb|emb|dbj|sp|pdb|bbs|ref|tp[gde])\\|(.*)\\|(?:.*)/) {\n                ($acc) = split /\\./, $1; \n            }\n            elsif ($id =~ /(?:pir|prf|pat|gnl)\\|(?:.*)\\|(.*)/) {\n                ($acc) = split /\\./, $1;  \n            }\n            elsif ($id =~ /(?:gim|gi|bbm|bbs|lcl)\\|(?:\\d*)/) {\n                $acc = $id;\n            }\n            elsif ($id =~ /(?:oth)\\|(.*)\\|(?:.*)\\|(?:.*)/ ) { # discontinued...\n                $acc = $1;\n            }\n            else {\n                $acc = $id;\n            }\n            push(@accnums, $acc);\n        }\n    }\n    return @accnums;\n}\n\n=head2 tiled_hsps\n\n Usage     : $hit_object->tiled_hsps( [integer] );\n Purpose   : Gets/Sets an indicator for whether or not the HSPs in this Hit \n           : have been tiled.\n Example   : $hit_object->tiled_hsps(1);\n           : if( $hit_object->tiled_hsps ) { # do something }\n Returns   : Boolean (1 or 0) \n Argument  : integer (optional)\n Throws    : n/a\n Status    : Deprecated\n Notes     : This value is not used for anything\n\n\nsub tiled_hsps {\n    my $self = shift;\n    if (@_) { $self->{_hsps_are_tiled} = shift }\n    return $self->{_hsps_are_tiled} || 0;\n}\n\n=head2 strand\n\n Usage     : $sbjct->strand( [seq_type] );\n Purpose   : Gets the strand(s) for the query, sbjct, or both sequences\n           : in the best HSP of the BlastHit object after HSP tiling.\n           : Only valid for BLASTN, TBLASTX, BLASTX-query, TBLASTN-hit.\n Example   : $qstrand = $sbjct->strand('query');\n           : $sstrand = $sbjct->strand('hit');\n           : ($qstrand, $sstrand) = $sbjct->strand();\n Returns   : scalar context: integer '1', '-1', or '0'\n           : array context without args: list of two strings (queryStrand, sbjctStrand)\n           : Array context can be \"induced\" by providing an argument of 'list' or 'array'.\n Argument  : In scalar context: seq_type = 'query' or 'hit' or 'sbjct' (default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n           : If you don't want the tiled data, iterate through each HSP\n           : calling strand() on each (use hsps() to get all HSPs).\n           :\n           : Formerly (prior to 10/21/02), this method would return the\n           : string \"-1/1\" for hits with HSPs on both strands.\n           : However, now that strand and frame is properly being accounted\n           : for during HSP tiling, it makes more sense for strand()\n           : to return the strand data for the best HSP after tiling.\n           :\n           : If you really want to know about hits on opposite strands,\n           : you should be iterating through the HSPs using methods on the\n           : HSP objects.\n           :\n           : A possible use case where knowing whether a hit has HSPs \n           : on both strands would be when filtering via SearchIO for hits with \n           : this property. However, in this case it would be better to have a\n           : dedicated method such as $hit->hsps_on_both_strands(). Similarly\n           : for frame. This could be provided if there is interest.\n\nSee Also   : L<Bio::Search::HSP::HSPI::strand>()\n\n\nsub strand {\n    shift->throw_not_implemented;\n}\n\n=head2 frame\n\n Usage     : $hit_object->frame();\n Purpose   : Gets the reading frame for the best HSP after HSP tiling.\n           : This is only valid for BLASTX and TBLASTN/X type reports.\n Example   : $frame = $hit_object->frame();\n Returns   : Integer (-2 .. +2)\n Argument  : n/a\n Throws    : Exception if HSPs have not been set.\n Comments  : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n           : If you don't want the tiled data, iterate through each HSP\n           : calling frame() on each (use hsps() to get all HSPs).\n\nSee Also   : L<hsps()|hsps>\n\n\nsub frame {\n    shift->throw_not_implemented;\n}\n\n=head2 length_aln\n\n Usage     : $hit_object->length_aln( [seq_type] );\n Purpose   : Get the total length of the aligned region for query or sbjct seq.\n           : This number will include all HSPs, and excludes gaps.\n Example   : $len    = $hit_object->length_aln(); # default = query\n           : $lenAln = $hit_object->length_aln('query');\n Returns   : Integer \n Argument  : seq_Type = 'query' or 'hit' or 'sbjct' (Default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : Exception if the argument is not recognized.\n Comments  : This method will report the logical length of the alignment,\n           : meaning that for TBLAST[NX] reports, the length is reported\n           : using amino acid coordinate space (i.e., nucleotides / 3).\n\nSee Also   : L<length()|length>, L<frac_aligned_query()|frac_aligned_query>,\n             L<frac_aligned_hit()|frac_aligned_hit>, L<gaps()|gaps>,\n             L<Bio::Search::SearchUtils::tile_hsps()|Bio::Search::SearchUtils>,\n             L<Bio::Search::HSP::BlastHSP::length()|Bio::Search::HSP::BlastHSP>\n\n\nsub length_aln {\n    my ($self, $seqType) = @_;\n    $seqType ||= 'query';\n    $seqType = 'hit' if $seqType eq 'sbjct';\n    \n\tmy %non_gaps = map { $_, 1 } $self->seq_inds($seqType, 'conserved'),\n\t\t\t\t\t\t\t     $self->seq_inds($seqType, 'no_match');\n\treturn scalar(keys %non_gaps);\n}\n\n=head2 gaps\n\n Usage     : $hit_object->gaps( [seq_type] );\n Purpose   : Get the number of gaps in the aligned query, hit, or both sequences.\n           : Data is summed across all HSPs.\n Example   : $qgaps = $hit_object->gaps('query');\n           : $hgaps = $hit_object->gaps('hit');\n           : $tgaps = $hit_object->gaps();    # default = total (query + hit)\n Returns   : scalar context: integer\n           : array context without args: two-element list of integers  \n           :    (queryGaps, hitGaps)\n           : Array context can be forced by providing an argument of 'list' or\n\t\t   : 'array'.\n           :\n           : CAUTION: Calling this method within printf or sprintf is arrray\n\t\t   : context.\n           : So this function may not give you what you expect. For example:\n           :          printf \"Total gaps: %d\", $hit->gaps();\n           : Actually returns a two-element array, so what gets printed \n           : is the number of gaps in the query, not the total\n           :\n Argument  : seq_type: 'query' | 'hit' or 'sbjct' | 'total' | 'list'\n           : (default = 'total') ('sbjct' is synonymous with 'hit')\n Comments  : If you need data for each HSP, use hsps() and then interate\n           : through each HSP object.\n\n\nsub gaps {\n    my ($self, $seqType) = @_;\n    \n    $seqType ||= (wantarray ? 'list' : 'total');\n    $seqType = 'hit' if $seqType eq 'sbjct';\n    \n    if ($seqType =~ /list|array/i) {\n        return (scalar($self->seq_inds('query', 'gap')), scalar($self->seq_inds('hit', 'gap')));\n    }\n    elsif ($seqType eq 'total') {\n        return (scalar($self->seq_inds('query', 'gap')) + scalar($self->seq_inds('hit', 'gap'))) || 0;\n    }\n    else {\n        return scalar($self->seq_inds($seqType, 'gap')) || 0;\n    }\n}\n\n=head2 matches\n\n Usage     : $hit_object->matches( [class] );\n Purpose   : Get the total number of identical or conserved matches \n           : (or both) across all HSPs.\n           : (Note: 'conservative' matches are indicated as 'positives' \n           :         in BLAST reports.)\n Example   : ($id,$cons) = $hit_object->matches(); # no argument\n           : $id = $hit_object->matches('id');\n           : $cons = $hit_object->matches('cons'); \n Returns   : Integer or a 2-element array of integers \n Argument  : [0] class = 'id' | 'cons' OR none.\n           : [1] seq_type  = 'query' or 'hit' or 'sbjct'  (default = 'query')\n           :                 ('sbjct' is synonymous with 'hit')\n           : If no argument is provided, both identical and conservative \n           : numbers are returned in a two element list.\n           : (Other terms can be used to refer to the conservative\n           :  matches, e.g., 'positive'. All that is checked is whether or\n           :  not the supplied string starts with 'id'. If not, the \n           : conservative matches are returned.)","label":"matches($self,$class,$seqType)"},"detail":"($self,$class,$seqType)","definition":"sub","containerName":"main::"},{"name":"_id_matches","line":858,"kind":12},{"line":859,"kind":12,"name":"_id_matches"},{"name":"hit","line":859,"kind":12},{"line":860,"kind":12,"name":"_id_matches"},{"name":"query","line":860,"kind":12},{"kind":12,"line":862,"name":"_con_matches"},{"line":875,"kind":12,"name":"_con_matches"},{"name":"_id_matches","line":881,"kind":12},{"kind":12,"line":881,"name":"_con_matches"},{"name":"_id_matches","line":885,"kind":12},{"name":"_con_matches","kind":12,"line":888},{"kind":12,"line":913,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"start","line":914,"kind":13},{"kind":13,"line":914,"containerName":"start","name":"$seqType"},{"line":916,"kind":13,"name":"$self","containerName":"start"},{"name":"get_field","containerName":"start","line":916,"kind":12},{"containerName":"start","name":"$self","kind":13,"line":917},{"line":921,"kind":13,"name":"$seqType","containerName":"start"},{"name":"$seqType","containerName":"start","kind":13,"line":922},{"line":922,"kind":13,"name":"$seqType","containerName":"start"},{"name":"$seqType","containerName":"start","kind":13,"line":924},{"name":"$self","containerName":"start","line":925,"kind":13},{"kind":12,"line":925,"containerName":"start","name":"get_field"},{"containerName":"start","name":"$self","line":925,"kind":13},{"kind":12,"line":925,"name":"get_field","containerName":"start"},{"containerName":"start","name":"$seqType","line":927,"kind":13},{"kind":13,"line":928,"containerName":"start","name":"$self"},{"containerName":"start","name":"get_field","kind":12,"line":928},{"kind":13,"line":930,"containerName":"start","name":"$seqType"},{"containerName":"start","name":"$self","line":931,"kind":13},{"containerName":"start","name":"get_field","kind":12,"line":931},{"containerName":"start","name":"$self","line":934,"kind":13},{"line":934,"kind":12,"containerName":"start","name":"throw"}],"containerName":"main::","definition":"sub","detail":"($self,$seqType)","signature":{"label":"start($self,$seqType)","parameters":[{"label":"$self"},{"label":"$seqType"}],"documentation":"1;\n# $Id: PullHitI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Search::Hit::PullHitI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Hit::PullHitI - Bio::Search::Hit::HitI interface for pull parsers.\n\n=head1 SYNOPSIS\n\n\t# This is an interface and cannot be instantiated\n\n    # typically one gets HitI objects from a SearchIO stream via a ResultI\n    use Bio::SearchIO;\n    my $parser = Bio::SearchIO->new(-format => 'hmmer_pull',\n                                   -file => 't/data/hmmpfam.out');\n\n    my $result = $parser->next_result;\n    my $hit    = $result->next_hit;\n\n    $hit_name = $hit->name();\n\n    $desc = $hit->description();\n\n    $len = $hit->length\n\n    $alg = $hit->algorithm();\n\n    $score = $hit->raw_score();\n\n    $significance = $hit->significance();\n\n    $rank = $hit->rank(); # the Nth hit for a specific query\n\n    while( $hsp = $obj->next_hsp()) { ... } # process in iterator fashion\n\n    for my $hsp ( $obj->hsps()()) { ... } # process in list fashion\n\n=head1 DESCRIPTION\n\nThis object handles the hit data from a database sequence search.\n\nPullHitI is for fast implementations that only do parsing work on the hit\ndata when you actually request information by calling one of the HitI\nmethods.\n\nMany methods of HitI are implemented in a way suitable for inheriting classes\nthat use Bio::PullParserI. It only really makes sense for PullHit modules to be\ncreated by (and have as a -parent) PullResult modules.\n\nIn addition to the usual -chunk and -parent, -hit_data is all you should supply\nwhen making a PullHit object. This will store that data and make it accessible\nvia _raw_hit_data, which you can access in your subclass. It would be best to\nsimply provide the data as the input -chunk instead, if the raw data is large\nenough.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 COPYRIGHT\n\nCopyright (c) 2006 Sendu Bala. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::Hit::PullHitI;\n\nuse Bio::Search::SearchUtils;\n\nuse strict;\n\nuse base qw(Bio::PullParserI Bio::Search::Hit::HitI);\n\n=head2 _setup\n\n Title   : _setup\n Usage   : $self->_setup(@args)\n Function: Implementers should call this to setup common fields and deal with\n           common arguments to new().\n Returns : n/a\n Args    : @args received in new().\n\n\nsub _setup {\n    my ($self, @args) = @_;\n    \n    # fields most subclasses probably will want\n    $self->_fields( { ( next_hsp => undef,\n                        num_hsps => undef,\n                        hsps => undef,\n                        hit_start => undef,\n                        query_start => undef,\n                        hit_end => undef,\n                        query_end => undef,\n                        length => undef,\n\t\t\t\t\t\tname => undef ,\n\t\t\t\t\t\taccession => undef ) } );\n    \n    my ($parent, $chunk, $hit_data) = $self->_rearrange([qw(PARENT\n                                                            CHUNK\n                                                            HIT_DATA)], @args);\n    $self->throw(\"Need -parent or -chunk to be defined\") unless $parent || $chunk;\n    \n\t$self->parent($parent) if $parent;\n    \n    if ($chunk) {\n        my ($io, $start, $end) = (undef, 0, undef);\n        if (ref($chunk) eq 'ARRAY') {\n            ($io, $start, $end) = @{$chunk};\n        }\n        else {\n            $io = $chunk;\n        }\n        $self->chunk($io, -start => $start, -end => $end);\n    }\n    \n    $self->_raw_hit_data($hit_data) if $hit_data;\n}\n\nsub _raw_hit_data {\n\tmy $self = shift;\n\tif (@_) {\n\t\t$self->{_raw_hit_data} = shift;\n\t}\n\treturn $self->{_raw_hit_data};\n}\n\n#\n# Some of these methods are written explitely to avoid HitI throwing not\n# implemented; if it didn't do that then PullParserI AUTOLOAD would have\n# cought them.\n#\n\n=head2 name\n\n Title   : name\n Usage   : $hit_name = $hit->name();\n Function: returns the name of the Hit sequence\n Returns : a scalar string\n Args    : none\n\nThe B<name> of a hit is unique within a Result or within an Iteration.\n\n\nsub name {\n    return shift->get_field('name');\n}\n\n=head2 description\n\n Title   : description\n Usage   : $desc = $hit->description();\n Function: Retrieve the description for the hit\n Returns : a scalar string\n Args    : none\n\n\nsub description {\n    return shift->get_field('description');\n}\n\n=head2 accession\n\n Title   : accession\n Usage   : $acc = $hit->accession();\n Function: Retrieve the accession (if available) for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub accession {\n    return shift->get_field('accession');\n}\n\n=head2 locus\n\n Title   : locus\n Usage   : $acc = $hit->locus();\n Function: Retrieve the locus(if available) for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub locus {\n    return shift->get_field('locus');\n}\n\n=head2 length\n\n Title   : length\n Usage   : my $len = $hit->length\n Function: Returns the length of the hit \n Returns : integer\n Args    : none\n\n\nsub length {\n   return shift->get_field('length');\n}\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : $alg = $hit->algorithm();\n Function: Gets the algorithm specification that was used to obtain the hit\n           For BLAST, the algorithm denotes what type of sequence was aligned \n           against what (BLASTN: dna-dna, BLASTP prt-prt, BLASTX translated \n           dna-prt, TBLASTN prt-translated dna, TBLASTX translated \n           dna-translated dna).\n Returns : a scalar string \n Args    : none\n\n\nsub algorithm {\n    return shift->get_field('algorithm');\n}\n\n=head2 raw_score\n\n Title   : raw_score\n Usage   : $score = $hit->raw_score();\n Function: Gets the \"raw score\" generated by the algorithm.  What\n           this score is exactly will vary from algorithm to algorithm,\n           returning undef if unavailable.\n Returns : a scalar value\n Args    : none\n\n\nsub raw_score {\n    return shift->get_field('score');\n}\n\n=head2 score\n\nEquivalent to L<raw_score()|raw_score>\n\n\nsub score {\n    return shift->get_field('score');\n}\n\n=head2 significance\n\n Title   : significance\n Usage   : $significance = $hit->significance();\n Function: Used to obtain the E or P value of a hit, i.e. the probability that\n           this particular hit was obtained purely by random chance.  If\n           information is not available (nor calculatable from other\n           information sources), return undef.\n Returns : a scalar value or undef if unavailable\n Args    : none\n\n\nsub significance {\n    return shift->get_field('significance');\n}\n\n=head2 bits\n\n Usage     : $hit_object->bits();\n Purpose   : Gets the bit score of the best HSP for the current hit.\n Example   : $bits = $hit_object->bits();\n Returns   : Integer or double for FASTA reports\n Argument  : n/a\n Comments  : For BLAST1, the non-bit score is listed in the summary line.\n\nSee Also   : L<score()|score>\n\n\nsub bits {\n    return shift->get_field('bits');\n}\n\n=head2 next_hsp\n\n Title    : next_hsp\n Usage    : while( $hsp = $obj->next_hsp()) { ... }\n Function : Returns the next available High Scoring Pair\n Example  : \n Returns  : L<Bio::Search::HSP::HSPI> object or null if finished\n Args     : none\n\n\nsub next_hsp {\n    return shift->get_field('next_hsp');\n}\n\n=head2 hsps\n\n Usage     : $hit_object->hsps();\n Purpose   : Get a list containing all HSP objects.\n           : Get the numbers of HSPs for the current hit.\n Example   : @hsps = $hit_object->hsps();\n           : $num  = $hit_object->hsps();  # alternatively, use num_hsps()\n Returns   : Array context : list of L<Bio::Search::HSP::BlastHSP> objects.\n           : Scalar context: integer (number of HSPs).\n           :                 (Equivalent to num_hsps()).\n Argument  : n/a. Relies on wantarray\n Throws    : Exception if the HSPs have not been collected.\n\nSee Also   : L<hsp()|hsp>, L<num_hsps()|num_hsps>\n\n\nsub hsps {\n    return shift->get_field('hsps');\n}\n\n=head2 num_hsps\n\n Usage     : $hit_object->num_hsps();\n Purpose   : Get the number of HSPs for the present Blast hit.\n Example   : $nhsps = $hit_object->num_hsps();\n Returns   : Integer\n Argument  : n/a\n Throws    : Exception if the HSPs have not been collected.\n\nSee Also   : L<hsps()|hsps>\n\n\nsub num_hsps {\n    return shift->get_field('num_hsps');\n}\n\n#\n# HitI/ GenericHit methods that are unrelated to simply parsing information\n# directly out of a file, but need more complex calculation; mostly not\n# implemented here.\n#\n\n=head2 seq_inds\n\n Usage     : $hit->seq_inds( seq_type, class, collapse );\n Purpose   : Get a list of residue positions (indices) across all HSPs\n           : for identical or conserved residues in the query or sbjct sequence.\n Example   : @s_ind = $hit->seq_inds('query', 'identical');\n           : @h_ind = $hit->seq_inds('hit', 'conserved');\n           : @h_ind = $hit->seq_inds('hit', 'conserved', 1);\n Returns   : Array of integers \n           : May include ranges if collapse is non-zero.\n Argument  : [0] seq_type  = 'query' or 'hit' or 'sbjct'  (default = 'query')\n           :                 ('sbjct' is synonymous with 'hit')\n           : [1] class = 'identical' or 'conserved' or 'nomatch' or 'gap'\n\t\t   :         (default = 'identical')\n           :         (can be shortened to 'id' or 'cons')\n\t\t   :         Note that 'conserved' includes identical unless you use\n\t\t   :         'conserved-not-identical'\n           : [2] collapse = boolean, if non-zero, consecutive positions are\n           :             merged using a range notation, e.g.,\n           :             \"1 2 3 4 5 7 9 10 11\" collapses to \"1-5 7 9-11\". This\n           :             is useful for  consolidating long lists. Default = no\n           :             collapse.\n Throws    : n/a.\n\nSee Also   : L<Bio::Search::HSP::HSPI::seq_inds()|Bio::Search::HSP::HSPI>\n\n\nsub seq_inds {\n    my ($self, $seqType, $class, $collapse) = @_;\n    \n    $seqType  ||= 'query';\n    $class ||= 'identical';\n    $collapse ||= 0;\n    \n    $seqType = 'hit' if $seqType eq 'sbjct';\n    \n\tmy $storage_name = '_seq_inds_'.$seqType.'_'.$class;\n\tunless (defined $self->{$storage_name}) {\n\t\tmy @inds;    \n\t\tforeach my $hsp ($self->hsps) {\n\t\t\t# This will merge data for all HSPs together.\n\t\t\tpush @inds, $hsp->seq_inds($seqType, $class);\n\t\t}\n\t\t\n\t\t# Need to remove duplicates and sort the merged positions, unless gaps.\n\t\tif (@inds && $class ne 'gap') {\n\t\t\tmy %tmp = map { $_, 1 } @inds;\n\t\t\t@inds = sort {$a <=> $b} keys %tmp;\n\t\t}\n\t\t\n\t\t$self->{$storage_name} = \\@inds;\n\t}\n\t\n\tmy @inds = @{$self->{$storage_name}};\n    $collapse ? &Bio::Search::SearchUtils::collapse_nums(@inds) : @inds;\n}\n\n=head2 rewind\n\n Title   : rewind\n Usage   : $hit->rewind;\n Function: Allow one to reset the HSP iterator to the beginning if possible\n Returns : none\n Args    : none\n\n\nsub rewind {\n    shift->throw_not_implemented();\n}\n\n=head2 overlap\n\n Usage     : $hit_object->overlap( [integer] );\n Purpose   : Gets/Sets the allowable amount overlap between different HSP\n             sequences.\n Example   : $hit_object->overlap(5);\n           : $overlap = $hit_object->overlap;\n Returns   : Integer.\n Argument  : integer.\n Throws    : n/a\n Status    : Deprecated\n Comments  : This value isn't used for anything\n\n\nsub overlap {\n    my $self = shift;\n    if (@_) { $self->{_overlap} = shift }\n    return $self->{_overlap} || 0;\n}\n\n=head2 n\n\n Usage     : $hit_object->n();\n Purpose   : Gets the N number for the current Blast hit.\n           : This is the number of HSPs in the set which was ascribed\n           : the lowest P-value (listed on the description line).\n           : This number is not the same as the total number of HSPs.\n           : To get the total number of HSPs, use num_hsps().\n Example   : $n = $hit_object->n();\n Returns   : Integer\n Argument  : n/a\n Throws    : Exception if HSPs have not been set (BLAST2 reports).\n Comments  : Note that the N parameter is not reported in gapped BLAST2.\n           : Calling n() on such reports will result in a call to num_hsps().\n           : The num_hsps() method will count the actual number of\n           : HSPs in the alignment listing, which may exceed N in\n           : some cases.\n\nSee Also   : L<num_hsps()|num_hsps>\n\n\nsub n {\n    return shift->get_field('num_hsps');\n}\n\n=head2 p\n\n Usage     : $hit_object->p( [format] );\n Purpose   : Get the P-value for the best HSP of the given BLAST hit.\n           : (Note that P-values are not provided with NCBI Blast2 reports).\n Example   : $p =  $sbjct->p;\n           : $p =  $sbjct->p('exp');  # get exponent only.\n           : ($num, $exp) =  $sbjct->p('parts'); # split sci notation into parts\n Returns   : Float or scientific notation number (the raw P-value, DEFAULT).\n           : Integer if format == 'exp' (the magnitude of the base 10 exponent).\n           : 2-element list (float, int) if format == 'parts' and P-value\n           :                is in scientific notation (See Comments).\n Argument  : format: string of 'raw' | 'exp' | 'parts'\n           :    'raw' returns value given in report. Default. (1.2e-34)\n           :    'exp' returns exponent value only (34)\n           :    'parts' returns the decimal and exponent as a \n           :            2-element list (1.2, -34) (See Comments).\n Throws    : Warns if no P-value is defined. Uses expect instead.\n Comments  : Using the 'parts' argument is not recommended since it will not\n           : work as expected if the P-value is not in scientific notation.\n           : That is, floats are not converted into sci notation before\n           : splitting into parts.\n\nSee Also   : L<expect()|expect>, L<signif()|signif>,\n             L<Bio::Search::BlastUtils::get_exponent()|Bio::Search::BlastUtils>\n\n\nsub p {\n    shift->throw_not_implemented;\n}\n\n=head2 hsp\n\n Usage     : $hit_object->hsp( [string] );\n Purpose   : Get a single HSPI object for the present HitI object.\n Example   : $hspObj  = $hit_object->hsp;  # same as 'best'\n           : $hspObj  = $hit_object->hsp('best');\n           : $hspObj  = $hit_object->hsp('worst');\n Returns   : Object reference for a L<Bio::Search::HSP::HSPI> object.\n Argument  : String (or no argument).\n           :   No argument (default) = highest scoring HSP (same as 'best').\n           :   'best'  = highest scoring HSP.\n           :   'worst' = lowest scoring HSP.\n Throws    : Exception if an unrecognized argument is used.\n\nSee Also   : L<hsps()|hsps>, L<num_hsps>()\n\n\nsub hsp {\n    shift->throw_not_implemented;\n}\n\n=head2 logical_length\n\n Usage     : $hit_object->logical_length( [seq_type] );\n           : (mostly intended for internal use).\n Purpose   : Get the logical length of the hit sequence.\n           : If the Blast is a TBLASTN or TBLASTX, the returned length \n           : is the length of the would-be amino acid sequence (length/3).\n           : For all other BLAST flavors, this function is the same as length().\n Example   : $len    = $hit_object->logical_length();\n Returns   : Integer \n Argument  : seq_type = 'query' or 'hit' or 'sbjct' (default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  : This is important for functions like frac_aligned_query()\n           : which need to operate in amino acid coordinate space when dealing\n           : with [T]BLAST[NX] type reports.\n\nSee Also   : L<length()|length>, L<frac_aligned_query()|frac_aligned_query>,\n             L<frac_aligned_hit()|frac_aligned_hit>\n\n\nsub logical_length {\n    my ($self, $type) = @_;\n    $type ||= 'query';\n    $type = lc($type);\n\t$type = 'hit' if $type eq 'sbjct';\n    if ($type eq 'query') {\n        return $self->get_field('query_length');\n    }\n    elsif ($type eq 'hit') {\n        return $self->get_field('length');\n    }\n}\n\n=head2 rank\n\n Title   : rank\n Usage   : $obj->rank($newval)\n Function: Get/Set the rank of this Hit in the Query search list\n           i.e. this is the Nth hit for a specific query\n Returns : value of rank\n Args    : newvalue (optional)\n\n\nsub rank {\n    return shift->get_field('rank');\n}\n\n=head2 each_accession_number\n\n Title   : each_accession_number\n Usage   : $obj->each_accession_number\n Function: Get each accession number listed in the description of the hit.\n           If there are no alternatives, then only the primary accession will \n           be given (if there is one).\n Returns : list of all accession numbers in the description\n Args    : none\n\n\nsub each_accession_number {\n    my $self = shift;\n    my $accession = $self->get_field('accession') if $self->has_field('accession');\n    my $desc = $self->get_field('description') if $self->has_field('description');\n    return unless $accession || $desc;\n    \n    my @accnums;\n    push (@accnums, $accession) if $accession;\n    \n    if (defined $desc) { \n        while ($desc =~ /(\\b\\S+\\|\\S*\\|\\S*\\s?)/g) {\n            my $id = $1;\n            my $acc;\n            if ($id =~ /(?:gb|emb|dbj|sp|pdb|bbs|ref|tp[gde])\\|(.*)\\|(?:.*)/) {\n                ($acc) = split /\\./, $1; \n            }\n            elsif ($id =~ /(?:pir|prf|pat|gnl)\\|(?:.*)\\|(.*)/) {\n                ($acc) = split /\\./, $1;  \n            }\n            elsif ($id =~ /(?:gim|gi|bbm|bbs|lcl)\\|(?:\\d*)/) {\n                $acc = $id;\n            }\n            elsif ($id =~ /(?:oth)\\|(.*)\\|(?:.*)\\|(?:.*)/ ) { # discontinued...\n                $acc = $1;\n            }\n            else {\n                $acc = $id;\n            }\n            push(@accnums, $acc);\n        }\n    }\n    return @accnums;\n}\n\n=head2 tiled_hsps\n\n Usage     : $hit_object->tiled_hsps( [integer] );\n Purpose   : Gets/Sets an indicator for whether or not the HSPs in this Hit \n           : have been tiled.\n Example   : $hit_object->tiled_hsps(1);\n           : if( $hit_object->tiled_hsps ) { # do something }\n Returns   : Boolean (1 or 0) \n Argument  : integer (optional)\n Throws    : n/a\n Status    : Deprecated\n Notes     : This value is not used for anything\n\n\nsub tiled_hsps {\n    my $self = shift;\n    if (@_) { $self->{_hsps_are_tiled} = shift }\n    return $self->{_hsps_are_tiled} || 0;\n}\n\n=head2 strand\n\n Usage     : $sbjct->strand( [seq_type] );\n Purpose   : Gets the strand(s) for the query, sbjct, or both sequences\n           : in the best HSP of the BlastHit object after HSP tiling.\n           : Only valid for BLASTN, TBLASTX, BLASTX-query, TBLASTN-hit.\n Example   : $qstrand = $sbjct->strand('query');\n           : $sstrand = $sbjct->strand('hit');\n           : ($qstrand, $sstrand) = $sbjct->strand();\n Returns   : scalar context: integer '1', '-1', or '0'\n           : array context without args: list of two strings (queryStrand, sbjctStrand)\n           : Array context can be \"induced\" by providing an argument of 'list' or 'array'.\n Argument  : In scalar context: seq_type = 'query' or 'hit' or 'sbjct' (default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n           : If you don't want the tiled data, iterate through each HSP\n           : calling strand() on each (use hsps() to get all HSPs).\n           :\n           : Formerly (prior to 10/21/02), this method would return the\n           : string \"-1/1\" for hits with HSPs on both strands.\n           : However, now that strand and frame is properly being accounted\n           : for during HSP tiling, it makes more sense for strand()\n           : to return the strand data for the best HSP after tiling.\n           :\n           : If you really want to know about hits on opposite strands,\n           : you should be iterating through the HSPs using methods on the\n           : HSP objects.\n           :\n           : A possible use case where knowing whether a hit has HSPs \n           : on both strands would be when filtering via SearchIO for hits with \n           : this property. However, in this case it would be better to have a\n           : dedicated method such as $hit->hsps_on_both_strands(). Similarly\n           : for frame. This could be provided if there is interest.\n\nSee Also   : L<Bio::Search::HSP::HSPI::strand>()\n\n\nsub strand {\n    shift->throw_not_implemented;\n}\n\n=head2 frame\n\n Usage     : $hit_object->frame();\n Purpose   : Gets the reading frame for the best HSP after HSP tiling.\n           : This is only valid for BLASTX and TBLASTN/X type reports.\n Example   : $frame = $hit_object->frame();\n Returns   : Integer (-2 .. +2)\n Argument  : n/a\n Throws    : Exception if HSPs have not been set.\n Comments  : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n           : If you don't want the tiled data, iterate through each HSP\n           : calling frame() on each (use hsps() to get all HSPs).\n\nSee Also   : L<hsps()|hsps>\n\n\nsub frame {\n    shift->throw_not_implemented;\n}\n\n=head2 length_aln\n\n Usage     : $hit_object->length_aln( [seq_type] );\n Purpose   : Get the total length of the aligned region for query or sbjct seq.\n           : This number will include all HSPs, and excludes gaps.\n Example   : $len    = $hit_object->length_aln(); # default = query\n           : $lenAln = $hit_object->length_aln('query');\n Returns   : Integer \n Argument  : seq_Type = 'query' or 'hit' or 'sbjct' (Default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : Exception if the argument is not recognized.\n Comments  : This method will report the logical length of the alignment,\n           : meaning that for TBLAST[NX] reports, the length is reported\n           : using amino acid coordinate space (i.e., nucleotides / 3).\n\nSee Also   : L<length()|length>, L<frac_aligned_query()|frac_aligned_query>,\n             L<frac_aligned_hit()|frac_aligned_hit>, L<gaps()|gaps>,\n             L<Bio::Search::SearchUtils::tile_hsps()|Bio::Search::SearchUtils>,\n             L<Bio::Search::HSP::BlastHSP::length()|Bio::Search::HSP::BlastHSP>\n\n\nsub length_aln {\n    my ($self, $seqType) = @_;\n    $seqType ||= 'query';\n    $seqType = 'hit' if $seqType eq 'sbjct';\n    \n\tmy %non_gaps = map { $_, 1 } $self->seq_inds($seqType, 'conserved'),\n\t\t\t\t\t\t\t     $self->seq_inds($seqType, 'no_match');\n\treturn scalar(keys %non_gaps);\n}\n\n=head2 gaps\n\n Usage     : $hit_object->gaps( [seq_type] );\n Purpose   : Get the number of gaps in the aligned query, hit, or both sequences.\n           : Data is summed across all HSPs.\n Example   : $qgaps = $hit_object->gaps('query');\n           : $hgaps = $hit_object->gaps('hit');\n           : $tgaps = $hit_object->gaps();    # default = total (query + hit)\n Returns   : scalar context: integer\n           : array context without args: two-element list of integers  \n           :    (queryGaps, hitGaps)\n           : Array context can be forced by providing an argument of 'list' or\n\t\t   : 'array'.\n           :\n           : CAUTION: Calling this method within printf or sprintf is arrray\n\t\t   : context.\n           : So this function may not give you what you expect. For example:\n           :          printf \"Total gaps: %d\", $hit->gaps();\n           : Actually returns a two-element array, so what gets printed \n           : is the number of gaps in the query, not the total\n           :\n Argument  : seq_type: 'query' | 'hit' or 'sbjct' | 'total' | 'list'\n           : (default = 'total') ('sbjct' is synonymous with 'hit')\n Comments  : If you need data for each HSP, use hsps() and then interate\n           : through each HSP object.\n\n\nsub gaps {\n    my ($self, $seqType) = @_;\n    \n    $seqType ||= (wantarray ? 'list' : 'total');\n    $seqType = 'hit' if $seqType eq 'sbjct';\n    \n    if ($seqType =~ /list|array/i) {\n        return (scalar($self->seq_inds('query', 'gap')), scalar($self->seq_inds('hit', 'gap')));\n    }\n    elsif ($seqType eq 'total') {\n        return (scalar($self->seq_inds('query', 'gap')) + scalar($self->seq_inds('hit', 'gap'))) || 0;\n    }\n    else {\n        return scalar($self->seq_inds($seqType, 'gap')) || 0;\n    }\n}\n\n=head2 matches\n\n Usage     : $hit_object->matches( [class] );\n Purpose   : Get the total number of identical or conserved matches \n           : (or both) across all HSPs.\n           : (Note: 'conservative' matches are indicated as 'positives' \n           :         in BLAST reports.)\n Example   : ($id,$cons) = $hit_object->matches(); # no argument\n           : $id = $hit_object->matches('id');\n           : $cons = $hit_object->matches('cons'); \n Returns   : Integer or a 2-element array of integers \n Argument  : [0] class = 'id' | 'cons' OR none.\n           : [1] seq_type  = 'query' or 'hit' or 'sbjct'  (default = 'query')\n           :                 ('sbjct' is synonymous with 'hit')\n           : If no argument is provided, both identical and conservative \n           : numbers are returned in a two element list.\n           : (Other terms can be used to refer to the conservative\n           :  matches, e.g., 'positive'. All that is checked is whether or\n           :  not the supplied string starts with 'id'. If not, the \n           : conservative matches are returned.)\n\n\nsub matches {\n    my ($self, $class, $seqType) = @_;\n    \n\t# no query/hit choice? The answer differs depending on sequence, since\n\t# hsps could overlap on one sequence and not the other. Added an option,\n\t# but otherwise will assume 'hit'\n\t$seqType ||= 'hit';\n\t$seqType = 'hit' if $seqType eq 'sbjct';\n\t\n\tunless (exists $self->{_id_matches}) {\n\t\t$self->{_id_matches}->{hit} = scalar($self->seq_inds('hit', 'identical'));\n\t\t$self->{_id_matches}->{query} = scalar($self->seq_inds('query', 'identical'));\n\t}\n\tunless (exists $self->{_con_matches}) {\n\t\tforeach my $type ('hit', 'query') {\n\t\t\t# 'conserved-not-identical' can give us 'identical' matches if hsps\n\t\t\t# overlapped so have to get the difference\n\t\t\tmy %identicals = map { $_ => 1 } $self->seq_inds($type, 'identical');\n\t\t\tmy @conserved = $self->seq_inds($type, 'conserved-not-identical');\n\t\t\t\n\t\t\tmy $real_conserved;\n\t\t\tforeach (@conserved) {\n\t\t\t\tunless (exists $identicals{$_}) {\n\t\t\t\t\t$real_conserved++;\n\t\t\t\t}\n\t\t\t}\n\t\t\t$self->{_con_matches}->{$type} = $real_conserved;\n\t\t}\n\t}\n\t\n\t\n    unless ($class) {\n        return ($self->{_id_matches}->{$seqType}, $self->{_con_matches}->{$seqType});\n    }\n    else {\n\t\tif ($class =~ /^id/i) { \n            return $self->{_id_matches}->{$seqType};\n        }\n        else {\n            return $self->{_con_matches}->{$seqType};\n        }\n    }\n    return;\n}\n\n=head2 start\n\n Usage     : $sbjct->start( [seq_type] );\n Purpose   : Gets the start coordinate for the query, sbjct, or both sequences\n           : in the object. If there is more than one HSP, the lowest start\n           : value of all HSPs is returned.\n Example   : $qbeg = $sbjct->start('query');\n           : $sbeg = $sbjct->start('hit');\n           : ($qbeg, $sbeg) = $sbjct->start();\n Returns   : scalar context: integer \n           : array context without args: list of two integers (queryStart,\n           : sbjctStart)\n           : Array context can be \"induced\" by providing an argument of 'list'\n           : or 'array'.\n Argument  : 'query' or 'hit' or 'sbjct' (default = 'query') ('sbjct' is\n             synonymous with 'hit')"},"name":"start","range":{"start":{"line":913,"character":0},"end":{"line":936,"character":9999}}},{"line":917,"kind":12,"name":"Bio","containerName":"Search::SearchUtils::_warn_about_no_hsps"},{"detail":"($self,$seqType)","signature":{"label":"end($self,$seqType)","parameters":[{"label":"$self"},{"label":"$seqType"}],"documentation":"1;\n# $Id: PullHitI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Search::Hit::PullHitI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Hit::PullHitI - Bio::Search::Hit::HitI interface for pull parsers.\n\n=head1 SYNOPSIS\n\n\t# This is an interface and cannot be instantiated\n\n    # typically one gets HitI objects from a SearchIO stream via a ResultI\n    use Bio::SearchIO;\n    my $parser = Bio::SearchIO->new(-format => 'hmmer_pull',\n                                   -file => 't/data/hmmpfam.out');\n\n    my $result = $parser->next_result;\n    my $hit    = $result->next_hit;\n\n    $hit_name = $hit->name();\n\n    $desc = $hit->description();\n\n    $len = $hit->length\n\n    $alg = $hit->algorithm();\n\n    $score = $hit->raw_score();\n\n    $significance = $hit->significance();\n\n    $rank = $hit->rank(); # the Nth hit for a specific query\n\n    while( $hsp = $obj->next_hsp()) { ... } # process in iterator fashion\n\n    for my $hsp ( $obj->hsps()()) { ... } # process in list fashion\n\n=head1 DESCRIPTION\n\nThis object handles the hit data from a database sequence search.\n\nPullHitI is for fast implementations that only do parsing work on the hit\ndata when you actually request information by calling one of the HitI\nmethods.\n\nMany methods of HitI are implemented in a way suitable for inheriting classes\nthat use Bio::PullParserI. It only really makes sense for PullHit modules to be\ncreated by (and have as a -parent) PullResult modules.\n\nIn addition to the usual -chunk and -parent, -hit_data is all you should supply\nwhen making a PullHit object. This will store that data and make it accessible\nvia _raw_hit_data, which you can access in your subclass. It would be best to\nsimply provide the data as the input -chunk instead, if the raw data is large\nenough.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 COPYRIGHT\n\nCopyright (c) 2006 Sendu Bala. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::Hit::PullHitI;\n\nuse Bio::Search::SearchUtils;\n\nuse strict;\n\nuse base qw(Bio::PullParserI Bio::Search::Hit::HitI);\n\n=head2 _setup\n\n Title   : _setup\n Usage   : $self->_setup(@args)\n Function: Implementers should call this to setup common fields and deal with\n           common arguments to new().\n Returns : n/a\n Args    : @args received in new().\n\n\nsub _setup {\n    my ($self, @args) = @_;\n    \n    # fields most subclasses probably will want\n    $self->_fields( { ( next_hsp => undef,\n                        num_hsps => undef,\n                        hsps => undef,\n                        hit_start => undef,\n                        query_start => undef,\n                        hit_end => undef,\n                        query_end => undef,\n                        length => undef,\n\t\t\t\t\t\tname => undef ,\n\t\t\t\t\t\taccession => undef ) } );\n    \n    my ($parent, $chunk, $hit_data) = $self->_rearrange([qw(PARENT\n                                                            CHUNK\n                                                            HIT_DATA)], @args);\n    $self->throw(\"Need -parent or -chunk to be defined\") unless $parent || $chunk;\n    \n\t$self->parent($parent) if $parent;\n    \n    if ($chunk) {\n        my ($io, $start, $end) = (undef, 0, undef);\n        if (ref($chunk) eq 'ARRAY') {\n            ($io, $start, $end) = @{$chunk};\n        }\n        else {\n            $io = $chunk;\n        }\n        $self->chunk($io, -start => $start, -end => $end);\n    }\n    \n    $self->_raw_hit_data($hit_data) if $hit_data;\n}\n\nsub _raw_hit_data {\n\tmy $self = shift;\n\tif (@_) {\n\t\t$self->{_raw_hit_data} = shift;\n\t}\n\treturn $self->{_raw_hit_data};\n}\n\n#\n# Some of these methods are written explitely to avoid HitI throwing not\n# implemented; if it didn't do that then PullParserI AUTOLOAD would have\n# cought them.\n#\n\n=head2 name\n\n Title   : name\n Usage   : $hit_name = $hit->name();\n Function: returns the name of the Hit sequence\n Returns : a scalar string\n Args    : none\n\nThe B<name> of a hit is unique within a Result or within an Iteration.\n\n\nsub name {\n    return shift->get_field('name');\n}\n\n=head2 description\n\n Title   : description\n Usage   : $desc = $hit->description();\n Function: Retrieve the description for the hit\n Returns : a scalar string\n Args    : none\n\n\nsub description {\n    return shift->get_field('description');\n}\n\n=head2 accession\n\n Title   : accession\n Usage   : $acc = $hit->accession();\n Function: Retrieve the accession (if available) for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub accession {\n    return shift->get_field('accession');\n}\n\n=head2 locus\n\n Title   : locus\n Usage   : $acc = $hit->locus();\n Function: Retrieve the locus(if available) for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub locus {\n    return shift->get_field('locus');\n}\n\n=head2 length\n\n Title   : length\n Usage   : my $len = $hit->length\n Function: Returns the length of the hit \n Returns : integer\n Args    : none\n\n\nsub length {\n   return shift->get_field('length');\n}\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : $alg = $hit->algorithm();\n Function: Gets the algorithm specification that was used to obtain the hit\n           For BLAST, the algorithm denotes what type of sequence was aligned \n           against what (BLASTN: dna-dna, BLASTP prt-prt, BLASTX translated \n           dna-prt, TBLASTN prt-translated dna, TBLASTX translated \n           dna-translated dna).\n Returns : a scalar string \n Args    : none\n\n\nsub algorithm {\n    return shift->get_field('algorithm');\n}\n\n=head2 raw_score\n\n Title   : raw_score\n Usage   : $score = $hit->raw_score();\n Function: Gets the \"raw score\" generated by the algorithm.  What\n           this score is exactly will vary from algorithm to algorithm,\n           returning undef if unavailable.\n Returns : a scalar value\n Args    : none\n\n\nsub raw_score {\n    return shift->get_field('score');\n}\n\n=head2 score\n\nEquivalent to L<raw_score()|raw_score>\n\n\nsub score {\n    return shift->get_field('score');\n}\n\n=head2 significance\n\n Title   : significance\n Usage   : $significance = $hit->significance();\n Function: Used to obtain the E or P value of a hit, i.e. the probability that\n           this particular hit was obtained purely by random chance.  If\n           information is not available (nor calculatable from other\n           information sources), return undef.\n Returns : a scalar value or undef if unavailable\n Args    : none\n\n\nsub significance {\n    return shift->get_field('significance');\n}\n\n=head2 bits\n\n Usage     : $hit_object->bits();\n Purpose   : Gets the bit score of the best HSP for the current hit.\n Example   : $bits = $hit_object->bits();\n Returns   : Integer or double for FASTA reports\n Argument  : n/a\n Comments  : For BLAST1, the non-bit score is listed in the summary line.\n\nSee Also   : L<score()|score>\n\n\nsub bits {\n    return shift->get_field('bits');\n}\n\n=head2 next_hsp\n\n Title    : next_hsp\n Usage    : while( $hsp = $obj->next_hsp()) { ... }\n Function : Returns the next available High Scoring Pair\n Example  : \n Returns  : L<Bio::Search::HSP::HSPI> object or null if finished\n Args     : none\n\n\nsub next_hsp {\n    return shift->get_field('next_hsp');\n}\n\n=head2 hsps\n\n Usage     : $hit_object->hsps();\n Purpose   : Get a list containing all HSP objects.\n           : Get the numbers of HSPs for the current hit.\n Example   : @hsps = $hit_object->hsps();\n           : $num  = $hit_object->hsps();  # alternatively, use num_hsps()\n Returns   : Array context : list of L<Bio::Search::HSP::BlastHSP> objects.\n           : Scalar context: integer (number of HSPs).\n           :                 (Equivalent to num_hsps()).\n Argument  : n/a. Relies on wantarray\n Throws    : Exception if the HSPs have not been collected.\n\nSee Also   : L<hsp()|hsp>, L<num_hsps()|num_hsps>\n\n\nsub hsps {\n    return shift->get_field('hsps');\n}\n\n=head2 num_hsps\n\n Usage     : $hit_object->num_hsps();\n Purpose   : Get the number of HSPs for the present Blast hit.\n Example   : $nhsps = $hit_object->num_hsps();\n Returns   : Integer\n Argument  : n/a\n Throws    : Exception if the HSPs have not been collected.\n\nSee Also   : L<hsps()|hsps>\n\n\nsub num_hsps {\n    return shift->get_field('num_hsps');\n}\n\n#\n# HitI/ GenericHit methods that are unrelated to simply parsing information\n# directly out of a file, but need more complex calculation; mostly not\n# implemented here.\n#\n\n=head2 seq_inds\n\n Usage     : $hit->seq_inds( seq_type, class, collapse );\n Purpose   : Get a list of residue positions (indices) across all HSPs\n           : for identical or conserved residues in the query or sbjct sequence.\n Example   : @s_ind = $hit->seq_inds('query', 'identical');\n           : @h_ind = $hit->seq_inds('hit', 'conserved');\n           : @h_ind = $hit->seq_inds('hit', 'conserved', 1);\n Returns   : Array of integers \n           : May include ranges if collapse is non-zero.\n Argument  : [0] seq_type  = 'query' or 'hit' or 'sbjct'  (default = 'query')\n           :                 ('sbjct' is synonymous with 'hit')\n           : [1] class = 'identical' or 'conserved' or 'nomatch' or 'gap'\n\t\t   :         (default = 'identical')\n           :         (can be shortened to 'id' or 'cons')\n\t\t   :         Note that 'conserved' includes identical unless you use\n\t\t   :         'conserved-not-identical'\n           : [2] collapse = boolean, if non-zero, consecutive positions are\n           :             merged using a range notation, e.g.,\n           :             \"1 2 3 4 5 7 9 10 11\" collapses to \"1-5 7 9-11\". This\n           :             is useful for  consolidating long lists. Default = no\n           :             collapse.\n Throws    : n/a.\n\nSee Also   : L<Bio::Search::HSP::HSPI::seq_inds()|Bio::Search::HSP::HSPI>\n\n\nsub seq_inds {\n    my ($self, $seqType, $class, $collapse) = @_;\n    \n    $seqType  ||= 'query';\n    $class ||= 'identical';\n    $collapse ||= 0;\n    \n    $seqType = 'hit' if $seqType eq 'sbjct';\n    \n\tmy $storage_name = '_seq_inds_'.$seqType.'_'.$class;\n\tunless (defined $self->{$storage_name}) {\n\t\tmy @inds;    \n\t\tforeach my $hsp ($self->hsps) {\n\t\t\t# This will merge data for all HSPs together.\n\t\t\tpush @inds, $hsp->seq_inds($seqType, $class);\n\t\t}\n\t\t\n\t\t# Need to remove duplicates and sort the merged positions, unless gaps.\n\t\tif (@inds && $class ne 'gap') {\n\t\t\tmy %tmp = map { $_, 1 } @inds;\n\t\t\t@inds = sort {$a <=> $b} keys %tmp;\n\t\t}\n\t\t\n\t\t$self->{$storage_name} = \\@inds;\n\t}\n\t\n\tmy @inds = @{$self->{$storage_name}};\n    $collapse ? &Bio::Search::SearchUtils::collapse_nums(@inds) : @inds;\n}\n\n=head2 rewind\n\n Title   : rewind\n Usage   : $hit->rewind;\n Function: Allow one to reset the HSP iterator to the beginning if possible\n Returns : none\n Args    : none\n\n\nsub rewind {\n    shift->throw_not_implemented();\n}\n\n=head2 overlap\n\n Usage     : $hit_object->overlap( [integer] );\n Purpose   : Gets/Sets the allowable amount overlap between different HSP\n             sequences.\n Example   : $hit_object->overlap(5);\n           : $overlap = $hit_object->overlap;\n Returns   : Integer.\n Argument  : integer.\n Throws    : n/a\n Status    : Deprecated\n Comments  : This value isn't used for anything\n\n\nsub overlap {\n    my $self = shift;\n    if (@_) { $self->{_overlap} = shift }\n    return $self->{_overlap} || 0;\n}\n\n=head2 n\n\n Usage     : $hit_object->n();\n Purpose   : Gets the N number for the current Blast hit.\n           : This is the number of HSPs in the set which was ascribed\n           : the lowest P-value (listed on the description line).\n           : This number is not the same as the total number of HSPs.\n           : To get the total number of HSPs, use num_hsps().\n Example   : $n = $hit_object->n();\n Returns   : Integer\n Argument  : n/a\n Throws    : Exception if HSPs have not been set (BLAST2 reports).\n Comments  : Note that the N parameter is not reported in gapped BLAST2.\n           : Calling n() on such reports will result in a call to num_hsps().\n           : The num_hsps() method will count the actual number of\n           : HSPs in the alignment listing, which may exceed N in\n           : some cases.\n\nSee Also   : L<num_hsps()|num_hsps>\n\n\nsub n {\n    return shift->get_field('num_hsps');\n}\n\n=head2 p\n\n Usage     : $hit_object->p( [format] );\n Purpose   : Get the P-value for the best HSP of the given BLAST hit.\n           : (Note that P-values are not provided with NCBI Blast2 reports).\n Example   : $p =  $sbjct->p;\n           : $p =  $sbjct->p('exp');  # get exponent only.\n           : ($num, $exp) =  $sbjct->p('parts'); # split sci notation into parts\n Returns   : Float or scientific notation number (the raw P-value, DEFAULT).\n           : Integer if format == 'exp' (the magnitude of the base 10 exponent).\n           : 2-element list (float, int) if format == 'parts' and P-value\n           :                is in scientific notation (See Comments).\n Argument  : format: string of 'raw' | 'exp' | 'parts'\n           :    'raw' returns value given in report. Default. (1.2e-34)\n           :    'exp' returns exponent value only (34)\n           :    'parts' returns the decimal and exponent as a \n           :            2-element list (1.2, -34) (See Comments).\n Throws    : Warns if no P-value is defined. Uses expect instead.\n Comments  : Using the 'parts' argument is not recommended since it will not\n           : work as expected if the P-value is not in scientific notation.\n           : That is, floats are not converted into sci notation before\n           : splitting into parts.\n\nSee Also   : L<expect()|expect>, L<signif()|signif>,\n             L<Bio::Search::BlastUtils::get_exponent()|Bio::Search::BlastUtils>\n\n\nsub p {\n    shift->throw_not_implemented;\n}\n\n=head2 hsp\n\n Usage     : $hit_object->hsp( [string] );\n Purpose   : Get a single HSPI object for the present HitI object.\n Example   : $hspObj  = $hit_object->hsp;  # same as 'best'\n           : $hspObj  = $hit_object->hsp('best');\n           : $hspObj  = $hit_object->hsp('worst');\n Returns   : Object reference for a L<Bio::Search::HSP::HSPI> object.\n Argument  : String (or no argument).\n           :   No argument (default) = highest scoring HSP (same as 'best').\n           :   'best'  = highest scoring HSP.\n           :   'worst' = lowest scoring HSP.\n Throws    : Exception if an unrecognized argument is used.\n\nSee Also   : L<hsps()|hsps>, L<num_hsps>()\n\n\nsub hsp {\n    shift->throw_not_implemented;\n}\n\n=head2 logical_length\n\n Usage     : $hit_object->logical_length( [seq_type] );\n           : (mostly intended for internal use).\n Purpose   : Get the logical length of the hit sequence.\n           : If the Blast is a TBLASTN or TBLASTX, the returned length \n           : is the length of the would-be amino acid sequence (length/3).\n           : For all other BLAST flavors, this function is the same as length().\n Example   : $len    = $hit_object->logical_length();\n Returns   : Integer \n Argument  : seq_type = 'query' or 'hit' or 'sbjct' (default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  : This is important for functions like frac_aligned_query()\n           : which need to operate in amino acid coordinate space when dealing\n           : with [T]BLAST[NX] type reports.\n\nSee Also   : L<length()|length>, L<frac_aligned_query()|frac_aligned_query>,\n             L<frac_aligned_hit()|frac_aligned_hit>\n\n\nsub logical_length {\n    my ($self, $type) = @_;\n    $type ||= 'query';\n    $type = lc($type);\n\t$type = 'hit' if $type eq 'sbjct';\n    if ($type eq 'query') {\n        return $self->get_field('query_length');\n    }\n    elsif ($type eq 'hit') {\n        return $self->get_field('length');\n    }\n}\n\n=head2 rank\n\n Title   : rank\n Usage   : $obj->rank($newval)\n Function: Get/Set the rank of this Hit in the Query search list\n           i.e. this is the Nth hit for a specific query\n Returns : value of rank\n Args    : newvalue (optional)\n\n\nsub rank {\n    return shift->get_field('rank');\n}\n\n=head2 each_accession_number\n\n Title   : each_accession_number\n Usage   : $obj->each_accession_number\n Function: Get each accession number listed in the description of the hit.\n           If there are no alternatives, then only the primary accession will \n           be given (if there is one).\n Returns : list of all accession numbers in the description\n Args    : none\n\n\nsub each_accession_number {\n    my $self = shift;\n    my $accession = $self->get_field('accession') if $self->has_field('accession');\n    my $desc = $self->get_field('description') if $self->has_field('description');\n    return unless $accession || $desc;\n    \n    my @accnums;\n    push (@accnums, $accession) if $accession;\n    \n    if (defined $desc) { \n        while ($desc =~ /(\\b\\S+\\|\\S*\\|\\S*\\s?)/g) {\n            my $id = $1;\n            my $acc;\n            if ($id =~ /(?:gb|emb|dbj|sp|pdb|bbs|ref|tp[gde])\\|(.*)\\|(?:.*)/) {\n                ($acc) = split /\\./, $1; \n            }\n            elsif ($id =~ /(?:pir|prf|pat|gnl)\\|(?:.*)\\|(.*)/) {\n                ($acc) = split /\\./, $1;  \n            }\n            elsif ($id =~ /(?:gim|gi|bbm|bbs|lcl)\\|(?:\\d*)/) {\n                $acc = $id;\n            }\n            elsif ($id =~ /(?:oth)\\|(.*)\\|(?:.*)\\|(?:.*)/ ) { # discontinued...\n                $acc = $1;\n            }\n            else {\n                $acc = $id;\n            }\n            push(@accnums, $acc);\n        }\n    }\n    return @accnums;\n}\n\n=head2 tiled_hsps\n\n Usage     : $hit_object->tiled_hsps( [integer] );\n Purpose   : Gets/Sets an indicator for whether or not the HSPs in this Hit \n           : have been tiled.\n Example   : $hit_object->tiled_hsps(1);\n           : if( $hit_object->tiled_hsps ) { # do something }\n Returns   : Boolean (1 or 0) \n Argument  : integer (optional)\n Throws    : n/a\n Status    : Deprecated\n Notes     : This value is not used for anything\n\n\nsub tiled_hsps {\n    my $self = shift;\n    if (@_) { $self->{_hsps_are_tiled} = shift }\n    return $self->{_hsps_are_tiled} || 0;\n}\n\n=head2 strand\n\n Usage     : $sbjct->strand( [seq_type] );\n Purpose   : Gets the strand(s) for the query, sbjct, or both sequences\n           : in the best HSP of the BlastHit object after HSP tiling.\n           : Only valid for BLASTN, TBLASTX, BLASTX-query, TBLASTN-hit.\n Example   : $qstrand = $sbjct->strand('query');\n           : $sstrand = $sbjct->strand('hit');\n           : ($qstrand, $sstrand) = $sbjct->strand();\n Returns   : scalar context: integer '1', '-1', or '0'\n           : array context without args: list of two strings (queryStrand, sbjctStrand)\n           : Array context can be \"induced\" by providing an argument of 'list' or 'array'.\n Argument  : In scalar context: seq_type = 'query' or 'hit' or 'sbjct' (default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n           : If you don't want the tiled data, iterate through each HSP\n           : calling strand() on each (use hsps() to get all HSPs).\n           :\n           : Formerly (prior to 10/21/02), this method would return the\n           : string \"-1/1\" for hits with HSPs on both strands.\n           : However, now that strand and frame is properly being accounted\n           : for during HSP tiling, it makes more sense for strand()\n           : to return the strand data for the best HSP after tiling.\n           :\n           : If you really want to know about hits on opposite strands,\n           : you should be iterating through the HSPs using methods on the\n           : HSP objects.\n           :\n           : A possible use case where knowing whether a hit has HSPs \n           : on both strands would be when filtering via SearchIO for hits with \n           : this property. However, in this case it would be better to have a\n           : dedicated method such as $hit->hsps_on_both_strands(). Similarly\n           : for frame. This could be provided if there is interest.\n\nSee Also   : L<Bio::Search::HSP::HSPI::strand>()\n\n\nsub strand {\n    shift->throw_not_implemented;\n}\n\n=head2 frame\n\n Usage     : $hit_object->frame();\n Purpose   : Gets the reading frame for the best HSP after HSP tiling.\n           : This is only valid for BLASTX and TBLASTN/X type reports.\n Example   : $frame = $hit_object->frame();\n Returns   : Integer (-2 .. +2)\n Argument  : n/a\n Throws    : Exception if HSPs have not been set.\n Comments  : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n           : If you don't want the tiled data, iterate through each HSP\n           : calling frame() on each (use hsps() to get all HSPs).\n\nSee Also   : L<hsps()|hsps>\n\n\nsub frame {\n    shift->throw_not_implemented;\n}\n\n=head2 length_aln\n\n Usage     : $hit_object->length_aln( [seq_type] );\n Purpose   : Get the total length of the aligned region for query or sbjct seq.\n           : This number will include all HSPs, and excludes gaps.\n Example   : $len    = $hit_object->length_aln(); # default = query\n           : $lenAln = $hit_object->length_aln('query');\n Returns   : Integer \n Argument  : seq_Type = 'query' or 'hit' or 'sbjct' (Default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : Exception if the argument is not recognized.\n Comments  : This method will report the logical length of the alignment,\n           : meaning that for TBLAST[NX] reports, the length is reported\n           : using amino acid coordinate space (i.e., nucleotides / 3).\n\nSee Also   : L<length()|length>, L<frac_aligned_query()|frac_aligned_query>,\n             L<frac_aligned_hit()|frac_aligned_hit>, L<gaps()|gaps>,\n             L<Bio::Search::SearchUtils::tile_hsps()|Bio::Search::SearchUtils>,\n             L<Bio::Search::HSP::BlastHSP::length()|Bio::Search::HSP::BlastHSP>\n\n\nsub length_aln {\n    my ($self, $seqType) = @_;\n    $seqType ||= 'query';\n    $seqType = 'hit' if $seqType eq 'sbjct';\n    \n\tmy %non_gaps = map { $_, 1 } $self->seq_inds($seqType, 'conserved'),\n\t\t\t\t\t\t\t     $self->seq_inds($seqType, 'no_match');\n\treturn scalar(keys %non_gaps);\n}\n\n=head2 gaps\n\n Usage     : $hit_object->gaps( [seq_type] );\n Purpose   : Get the number of gaps in the aligned query, hit, or both sequences.\n           : Data is summed across all HSPs.\n Example   : $qgaps = $hit_object->gaps('query');\n           : $hgaps = $hit_object->gaps('hit');\n           : $tgaps = $hit_object->gaps();    # default = total (query + hit)\n Returns   : scalar context: integer\n           : array context without args: two-element list of integers  \n           :    (queryGaps, hitGaps)\n           : Array context can be forced by providing an argument of 'list' or\n\t\t   : 'array'.\n           :\n           : CAUTION: Calling this method within printf or sprintf is arrray\n\t\t   : context.\n           : So this function may not give you what you expect. For example:\n           :          printf \"Total gaps: %d\", $hit->gaps();\n           : Actually returns a two-element array, so what gets printed \n           : is the number of gaps in the query, not the total\n           :\n Argument  : seq_type: 'query' | 'hit' or 'sbjct' | 'total' | 'list'\n           : (default = 'total') ('sbjct' is synonymous with 'hit')\n Comments  : If you need data for each HSP, use hsps() and then interate\n           : through each HSP object.\n\n\nsub gaps {\n    my ($self, $seqType) = @_;\n    \n    $seqType ||= (wantarray ? 'list' : 'total');\n    $seqType = 'hit' if $seqType eq 'sbjct';\n    \n    if ($seqType =~ /list|array/i) {\n        return (scalar($self->seq_inds('query', 'gap')), scalar($self->seq_inds('hit', 'gap')));\n    }\n    elsif ($seqType eq 'total') {\n        return (scalar($self->seq_inds('query', 'gap')) + scalar($self->seq_inds('hit', 'gap'))) || 0;\n    }\n    else {\n        return scalar($self->seq_inds($seqType, 'gap')) || 0;\n    }\n}\n\n=head2 matches\n\n Usage     : $hit_object->matches( [class] );\n Purpose   : Get the total number of identical or conserved matches \n           : (or both) across all HSPs.\n           : (Note: 'conservative' matches are indicated as 'positives' \n           :         in BLAST reports.)\n Example   : ($id,$cons) = $hit_object->matches(); # no argument\n           : $id = $hit_object->matches('id');\n           : $cons = $hit_object->matches('cons'); \n Returns   : Integer or a 2-element array of integers \n Argument  : [0] class = 'id' | 'cons' OR none.\n           : [1] seq_type  = 'query' or 'hit' or 'sbjct'  (default = 'query')\n           :                 ('sbjct' is synonymous with 'hit')\n           : If no argument is provided, both identical and conservative \n           : numbers are returned in a two element list.\n           : (Other terms can be used to refer to the conservative\n           :  matches, e.g., 'positive'. All that is checked is whether or\n           :  not the supplied string starts with 'id'. If not, the \n           : conservative matches are returned.)\n\n\nsub matches {\n    my ($self, $class, $seqType) = @_;\n    \n\t# no query/hit choice? The answer differs depending on sequence, since\n\t# hsps could overlap on one sequence and not the other. Added an option,\n\t# but otherwise will assume 'hit'\n\t$seqType ||= 'hit';\n\t$seqType = 'hit' if $seqType eq 'sbjct';\n\t\n\tunless (exists $self->{_id_matches}) {\n\t\t$self->{_id_matches}->{hit} = scalar($self->seq_inds('hit', 'identical'));\n\t\t$self->{_id_matches}->{query} = scalar($self->seq_inds('query', 'identical'));\n\t}\n\tunless (exists $self->{_con_matches}) {\n\t\tforeach my $type ('hit', 'query') {\n\t\t\t# 'conserved-not-identical' can give us 'identical' matches if hsps\n\t\t\t# overlapped so have to get the difference\n\t\t\tmy %identicals = map { $_ => 1 } $self->seq_inds($type, 'identical');\n\t\t\tmy @conserved = $self->seq_inds($type, 'conserved-not-identical');\n\t\t\t\n\t\t\tmy $real_conserved;\n\t\t\tforeach (@conserved) {\n\t\t\t\tunless (exists $identicals{$_}) {\n\t\t\t\t\t$real_conserved++;\n\t\t\t\t}\n\t\t\t}\n\t\t\t$self->{_con_matches}->{$type} = $real_conserved;\n\t\t}\n\t}\n\t\n\t\n    unless ($class) {\n        return ($self->{_id_matches}->{$seqType}, $self->{_con_matches}->{$seqType});\n    }\n    else {\n\t\tif ($class =~ /^id/i) { \n            return $self->{_id_matches}->{$seqType};\n        }\n        else {\n            return $self->{_con_matches}->{$seqType};\n        }\n    }\n    return;\n}\n\n=head2 start\n\n Usage     : $sbjct->start( [seq_type] );\n Purpose   : Gets the start coordinate for the query, sbjct, or both sequences\n           : in the object. If there is more than one HSP, the lowest start\n           : value of all HSPs is returned.\n Example   : $qbeg = $sbjct->start('query');\n           : $sbeg = $sbjct->start('hit');\n           : ($qbeg, $sbeg) = $sbjct->start();\n Returns   : scalar context: integer \n           : array context without args: list of two integers (queryStart,\n           : sbjctStart)\n           : Array context can be \"induced\" by providing an argument of 'list'\n           : or 'array'.\n Argument  : 'query' or 'hit' or 'sbjct' (default = 'query') ('sbjct' is\n             synonymous with 'hit')\n\n\nsub start {\n    my ($self, $seqType) = @_;\n    \n    unless ($self->get_field('num_hsps')) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        return;\n    }\n    \n    $seqType ||= (wantarray ? 'list' : 'query');\n    $seqType = 'hit' if $seqType eq 'sbjct';\n    \n    if ($seqType =~ /list|array/i) {\n\t    return ($self->get_field('query_start'), $self->get_field('hit_start'));\n\t}\n    elsif ($seqType eq 'hit') {\n        return $self->get_field('hit_start');\n\t}\n    elsif ($seqType eq 'query') {\n        return $self->get_field('query_start');\n    }\n    else {\n        $self->throw(\"Unknown sequence type '$seqType'\");\n    }\n}\n\n=head2 end\n\n Usage     : $sbjct->end( [seq_type] );\n Purpose   : Gets the end coordinate for the query, sbjct, or both sequences\n           : in the object. If there is more than one HSP, the largest end\n           : value of all HSPs is returned.\n Example   : $qend = $sbjct->end('query');\n           : $send = $sbjct->end('hit');\n           : ($qend, $send) = $sbjct->end();\n Returns   : scalar context: integer\n           : array context without args: list of two integers \n           : (queryEnd, sbjctEnd)\n           : Array context can be \"induced\" by providing an argument \n           : of 'list' or 'array'.\n Argument  : 'query' or 'hit' or 'sbjct' (default = 'query') ('sbjct' is\n             synonymous with 'hit')"},"containerName":"main::","definition":"sub","line":957,"children":[{"kind":13,"line":958,"containerName":"end","definition":"my","name":"$self","localvar":"my"},{"containerName":"end","name":"$seqType","line":958,"kind":13},{"line":960,"kind":13,"containerName":"end","name":"$self"},{"line":960,"kind":12,"containerName":"end","name":"get_field"},{"line":961,"kind":13,"name":"$self","containerName":"end"},{"containerName":"end","name":"$seqType","kind":13,"line":965},{"kind":13,"line":966,"name":"$seqType","containerName":"end"},{"containerName":"end","name":"$seqType","line":966,"kind":13},{"kind":13,"line":968,"name":"$seqType","containerName":"end"},{"line":969,"kind":13,"containerName":"end","name":"$self"},{"kind":12,"line":969,"containerName":"end","name":"get_field"},{"kind":13,"line":969,"containerName":"end","name":"$self"},{"name":"get_field","containerName":"end","line":969,"kind":12},{"containerName":"end","name":"$seqType","line":971,"kind":13},{"name":"$self","containerName":"end","kind":13,"line":972},{"kind":12,"line":972,"name":"get_field","containerName":"end"},{"line":974,"kind":13,"containerName":"end","name":"$seqType"},{"kind":13,"line":975,"containerName":"end","name":"$self"},{"name":"get_field","containerName":"end","kind":12,"line":975},{"name":"$self","containerName":"end","kind":13,"line":978},{"kind":12,"line":978,"containerName":"end","name":"throw"}],"kind":12,"range":{"end":{"line":980,"character":9999},"start":{"line":957,"character":0}},"name":"end"},{"line":961,"kind":12,"name":"Bio","containerName":"Search::SearchUtils::_warn_about_no_hsps"},{"range":{"end":{"character":9999,"line":1003},"start":{"character":0,"line":998}},"name":"range","children":[{"localvar":"my","definition":"my","name":"$self","containerName":"range","line":999,"kind":13},{"containerName":"range","name":"$seqType","kind":13,"line":999},{"containerName":"range","name":"$seqType","kind":13,"line":1000},{"containerName":"range","name":"$seqType","line":1001,"kind":13},{"line":1001,"kind":13,"containerName":"range","name":"$seqType"},{"kind":13,"line":1002,"containerName":"range","name":"$self"},{"line":1002,"kind":12,"containerName":"range","name":"start"},{"line":1002,"kind":13,"containerName":"range","name":"$seqType"},{"line":1002,"kind":13,"containerName":"range","name":"$self"},{"name":"end","containerName":"range","kind":12,"line":1002},{"line":1002,"kind":13,"containerName":"range","name":"$seqType"}],"line":998,"kind":12,"signature":{"parameters":[{"label":"$self"},{"label":"$seqType"}],"documentation":"1;\n# $Id: PullHitI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Search::Hit::PullHitI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Hit::PullHitI - Bio::Search::Hit::HitI interface for pull parsers.\n\n=head1 SYNOPSIS\n\n\t# This is an interface and cannot be instantiated\n\n    # typically one gets HitI objects from a SearchIO stream via a ResultI\n    use Bio::SearchIO;\n    my $parser = Bio::SearchIO->new(-format => 'hmmer_pull',\n                                   -file => 't/data/hmmpfam.out');\n\n    my $result = $parser->next_result;\n    my $hit    = $result->next_hit;\n\n    $hit_name = $hit->name();\n\n    $desc = $hit->description();\n\n    $len = $hit->length\n\n    $alg = $hit->algorithm();\n\n    $score = $hit->raw_score();\n\n    $significance = $hit->significance();\n\n    $rank = $hit->rank(); # the Nth hit for a specific query\n\n    while( $hsp = $obj->next_hsp()) { ... } # process in iterator fashion\n\n    for my $hsp ( $obj->hsps()()) { ... } # process in list fashion\n\n=head1 DESCRIPTION\n\nThis object handles the hit data from a database sequence search.\n\nPullHitI is for fast implementations that only do parsing work on the hit\ndata when you actually request information by calling one of the HitI\nmethods.\n\nMany methods of HitI are implemented in a way suitable for inheriting classes\nthat use Bio::PullParserI. It only really makes sense for PullHit modules to be\ncreated by (and have as a -parent) PullResult modules.\n\nIn addition to the usual -chunk and -parent, -hit_data is all you should supply\nwhen making a PullHit object. This will store that data and make it accessible\nvia _raw_hit_data, which you can access in your subclass. It would be best to\nsimply provide the data as the input -chunk instead, if the raw data is large\nenough.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 COPYRIGHT\n\nCopyright (c) 2006 Sendu Bala. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::Hit::PullHitI;\n\nuse Bio::Search::SearchUtils;\n\nuse strict;\n\nuse base qw(Bio::PullParserI Bio::Search::Hit::HitI);\n\n=head2 _setup\n\n Title   : _setup\n Usage   : $self->_setup(@args)\n Function: Implementers should call this to setup common fields and deal with\n           common arguments to new().\n Returns : n/a\n Args    : @args received in new().\n\n\nsub _setup {\n    my ($self, @args) = @_;\n    \n    # fields most subclasses probably will want\n    $self->_fields( { ( next_hsp => undef,\n                        num_hsps => undef,\n                        hsps => undef,\n                        hit_start => undef,\n                        query_start => undef,\n                        hit_end => undef,\n                        query_end => undef,\n                        length => undef,\n\t\t\t\t\t\tname => undef ,\n\t\t\t\t\t\taccession => undef ) } );\n    \n    my ($parent, $chunk, $hit_data) = $self->_rearrange([qw(PARENT\n                                                            CHUNK\n                                                            HIT_DATA)], @args);\n    $self->throw(\"Need -parent or -chunk to be defined\") unless $parent || $chunk;\n    \n\t$self->parent($parent) if $parent;\n    \n    if ($chunk) {\n        my ($io, $start, $end) = (undef, 0, undef);\n        if (ref($chunk) eq 'ARRAY') {\n            ($io, $start, $end) = @{$chunk};\n        }\n        else {\n            $io = $chunk;\n        }\n        $self->chunk($io, -start => $start, -end => $end);\n    }\n    \n    $self->_raw_hit_data($hit_data) if $hit_data;\n}\n\nsub _raw_hit_data {\n\tmy $self = shift;\n\tif (@_) {\n\t\t$self->{_raw_hit_data} = shift;\n\t}\n\treturn $self->{_raw_hit_data};\n}\n\n#\n# Some of these methods are written explitely to avoid HitI throwing not\n# implemented; if it didn't do that then PullParserI AUTOLOAD would have\n# cought them.\n#\n\n=head2 name\n\n Title   : name\n Usage   : $hit_name = $hit->name();\n Function: returns the name of the Hit sequence\n Returns : a scalar string\n Args    : none\n\nThe B<name> of a hit is unique within a Result or within an Iteration.\n\n\nsub name {\n    return shift->get_field('name');\n}\n\n=head2 description\n\n Title   : description\n Usage   : $desc = $hit->description();\n Function: Retrieve the description for the hit\n Returns : a scalar string\n Args    : none\n\n\nsub description {\n    return shift->get_field('description');\n}\n\n=head2 accession\n\n Title   : accession\n Usage   : $acc = $hit->accession();\n Function: Retrieve the accession (if available) for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub accession {\n    return shift->get_field('accession');\n}\n\n=head2 locus\n\n Title   : locus\n Usage   : $acc = $hit->locus();\n Function: Retrieve the locus(if available) for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub locus {\n    return shift->get_field('locus');\n}\n\n=head2 length\n\n Title   : length\n Usage   : my $len = $hit->length\n Function: Returns the length of the hit \n Returns : integer\n Args    : none\n\n\nsub length {\n   return shift->get_field('length');\n}\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : $alg = $hit->algorithm();\n Function: Gets the algorithm specification that was used to obtain the hit\n           For BLAST, the algorithm denotes what type of sequence was aligned \n           against what (BLASTN: dna-dna, BLASTP prt-prt, BLASTX translated \n           dna-prt, TBLASTN prt-translated dna, TBLASTX translated \n           dna-translated dna).\n Returns : a scalar string \n Args    : none\n\n\nsub algorithm {\n    return shift->get_field('algorithm');\n}\n\n=head2 raw_score\n\n Title   : raw_score\n Usage   : $score = $hit->raw_score();\n Function: Gets the \"raw score\" generated by the algorithm.  What\n           this score is exactly will vary from algorithm to algorithm,\n           returning undef if unavailable.\n Returns : a scalar value\n Args    : none\n\n\nsub raw_score {\n    return shift->get_field('score');\n}\n\n=head2 score\n\nEquivalent to L<raw_score()|raw_score>\n\n\nsub score {\n    return shift->get_field('score');\n}\n\n=head2 significance\n\n Title   : significance\n Usage   : $significance = $hit->significance();\n Function: Used to obtain the E or P value of a hit, i.e. the probability that\n           this particular hit was obtained purely by random chance.  If\n           information is not available (nor calculatable from other\n           information sources), return undef.\n Returns : a scalar value or undef if unavailable\n Args    : none\n\n\nsub significance {\n    return shift->get_field('significance');\n}\n\n=head2 bits\n\n Usage     : $hit_object->bits();\n Purpose   : Gets the bit score of the best HSP for the current hit.\n Example   : $bits = $hit_object->bits();\n Returns   : Integer or double for FASTA reports\n Argument  : n/a\n Comments  : For BLAST1, the non-bit score is listed in the summary line.\n\nSee Also   : L<score()|score>\n\n\nsub bits {\n    return shift->get_field('bits');\n}\n\n=head2 next_hsp\n\n Title    : next_hsp\n Usage    : while( $hsp = $obj->next_hsp()) { ... }\n Function : Returns the next available High Scoring Pair\n Example  : \n Returns  : L<Bio::Search::HSP::HSPI> object or null if finished\n Args     : none\n\n\nsub next_hsp {\n    return shift->get_field('next_hsp');\n}\n\n=head2 hsps\n\n Usage     : $hit_object->hsps();\n Purpose   : Get a list containing all HSP objects.\n           : Get the numbers of HSPs for the current hit.\n Example   : @hsps = $hit_object->hsps();\n           : $num  = $hit_object->hsps();  # alternatively, use num_hsps()\n Returns   : Array context : list of L<Bio::Search::HSP::BlastHSP> objects.\n           : Scalar context: integer (number of HSPs).\n           :                 (Equivalent to num_hsps()).\n Argument  : n/a. Relies on wantarray\n Throws    : Exception if the HSPs have not been collected.\n\nSee Also   : L<hsp()|hsp>, L<num_hsps()|num_hsps>\n\n\nsub hsps {\n    return shift->get_field('hsps');\n}\n\n=head2 num_hsps\n\n Usage     : $hit_object->num_hsps();\n Purpose   : Get the number of HSPs for the present Blast hit.\n Example   : $nhsps = $hit_object->num_hsps();\n Returns   : Integer\n Argument  : n/a\n Throws    : Exception if the HSPs have not been collected.\n\nSee Also   : L<hsps()|hsps>\n\n\nsub num_hsps {\n    return shift->get_field('num_hsps');\n}\n\n#\n# HitI/ GenericHit methods that are unrelated to simply parsing information\n# directly out of a file, but need more complex calculation; mostly not\n# implemented here.\n#\n\n=head2 seq_inds\n\n Usage     : $hit->seq_inds( seq_type, class, collapse );\n Purpose   : Get a list of residue positions (indices) across all HSPs\n           : for identical or conserved residues in the query or sbjct sequence.\n Example   : @s_ind = $hit->seq_inds('query', 'identical');\n           : @h_ind = $hit->seq_inds('hit', 'conserved');\n           : @h_ind = $hit->seq_inds('hit', 'conserved', 1);\n Returns   : Array of integers \n           : May include ranges if collapse is non-zero.\n Argument  : [0] seq_type  = 'query' or 'hit' or 'sbjct'  (default = 'query')\n           :                 ('sbjct' is synonymous with 'hit')\n           : [1] class = 'identical' or 'conserved' or 'nomatch' or 'gap'\n\t\t   :         (default = 'identical')\n           :         (can be shortened to 'id' or 'cons')\n\t\t   :         Note that 'conserved' includes identical unless you use\n\t\t   :         'conserved-not-identical'\n           : [2] collapse = boolean, if non-zero, consecutive positions are\n           :             merged using a range notation, e.g.,\n           :             \"1 2 3 4 5 7 9 10 11\" collapses to \"1-5 7 9-11\". This\n           :             is useful for  consolidating long lists. Default = no\n           :             collapse.\n Throws    : n/a.\n\nSee Also   : L<Bio::Search::HSP::HSPI::seq_inds()|Bio::Search::HSP::HSPI>\n\n\nsub seq_inds {\n    my ($self, $seqType, $class, $collapse) = @_;\n    \n    $seqType  ||= 'query';\n    $class ||= 'identical';\n    $collapse ||= 0;\n    \n    $seqType = 'hit' if $seqType eq 'sbjct';\n    \n\tmy $storage_name = '_seq_inds_'.$seqType.'_'.$class;\n\tunless (defined $self->{$storage_name}) {\n\t\tmy @inds;    \n\t\tforeach my $hsp ($self->hsps) {\n\t\t\t# This will merge data for all HSPs together.\n\t\t\tpush @inds, $hsp->seq_inds($seqType, $class);\n\t\t}\n\t\t\n\t\t# Need to remove duplicates and sort the merged positions, unless gaps.\n\t\tif (@inds && $class ne 'gap') {\n\t\t\tmy %tmp = map { $_, 1 } @inds;\n\t\t\t@inds = sort {$a <=> $b} keys %tmp;\n\t\t}\n\t\t\n\t\t$self->{$storage_name} = \\@inds;\n\t}\n\t\n\tmy @inds = @{$self->{$storage_name}};\n    $collapse ? &Bio::Search::SearchUtils::collapse_nums(@inds) : @inds;\n}\n\n=head2 rewind\n\n Title   : rewind\n Usage   : $hit->rewind;\n Function: Allow one to reset the HSP iterator to the beginning if possible\n Returns : none\n Args    : none\n\n\nsub rewind {\n    shift->throw_not_implemented();\n}\n\n=head2 overlap\n\n Usage     : $hit_object->overlap( [integer] );\n Purpose   : Gets/Sets the allowable amount overlap between different HSP\n             sequences.\n Example   : $hit_object->overlap(5);\n           : $overlap = $hit_object->overlap;\n Returns   : Integer.\n Argument  : integer.\n Throws    : n/a\n Status    : Deprecated\n Comments  : This value isn't used for anything\n\n\nsub overlap {\n    my $self = shift;\n    if (@_) { $self->{_overlap} = shift }\n    return $self->{_overlap} || 0;\n}\n\n=head2 n\n\n Usage     : $hit_object->n();\n Purpose   : Gets the N number for the current Blast hit.\n           : This is the number of HSPs in the set which was ascribed\n           : the lowest P-value (listed on the description line).\n           : This number is not the same as the total number of HSPs.\n           : To get the total number of HSPs, use num_hsps().\n Example   : $n = $hit_object->n();\n Returns   : Integer\n Argument  : n/a\n Throws    : Exception if HSPs have not been set (BLAST2 reports).\n Comments  : Note that the N parameter is not reported in gapped BLAST2.\n           : Calling n() on such reports will result in a call to num_hsps().\n           : The num_hsps() method will count the actual number of\n           : HSPs in the alignment listing, which may exceed N in\n           : some cases.\n\nSee Also   : L<num_hsps()|num_hsps>\n\n\nsub n {\n    return shift->get_field('num_hsps');\n}\n\n=head2 p\n\n Usage     : $hit_object->p( [format] );\n Purpose   : Get the P-value for the best HSP of the given BLAST hit.\n           : (Note that P-values are not provided with NCBI Blast2 reports).\n Example   : $p =  $sbjct->p;\n           : $p =  $sbjct->p('exp');  # get exponent only.\n           : ($num, $exp) =  $sbjct->p('parts'); # split sci notation into parts\n Returns   : Float or scientific notation number (the raw P-value, DEFAULT).\n           : Integer if format == 'exp' (the magnitude of the base 10 exponent).\n           : 2-element list (float, int) if format == 'parts' and P-value\n           :                is in scientific notation (See Comments).\n Argument  : format: string of 'raw' | 'exp' | 'parts'\n           :    'raw' returns value given in report. Default. (1.2e-34)\n           :    'exp' returns exponent value only (34)\n           :    'parts' returns the decimal and exponent as a \n           :            2-element list (1.2, -34) (See Comments).\n Throws    : Warns if no P-value is defined. Uses expect instead.\n Comments  : Using the 'parts' argument is not recommended since it will not\n           : work as expected if the P-value is not in scientific notation.\n           : That is, floats are not converted into sci notation before\n           : splitting into parts.\n\nSee Also   : L<expect()|expect>, L<signif()|signif>,\n             L<Bio::Search::BlastUtils::get_exponent()|Bio::Search::BlastUtils>\n\n\nsub p {\n    shift->throw_not_implemented;\n}\n\n=head2 hsp\n\n Usage     : $hit_object->hsp( [string] );\n Purpose   : Get a single HSPI object for the present HitI object.\n Example   : $hspObj  = $hit_object->hsp;  # same as 'best'\n           : $hspObj  = $hit_object->hsp('best');\n           : $hspObj  = $hit_object->hsp('worst');\n Returns   : Object reference for a L<Bio::Search::HSP::HSPI> object.\n Argument  : String (or no argument).\n           :   No argument (default) = highest scoring HSP (same as 'best').\n           :   'best'  = highest scoring HSP.\n           :   'worst' = lowest scoring HSP.\n Throws    : Exception if an unrecognized argument is used.\n\nSee Also   : L<hsps()|hsps>, L<num_hsps>()\n\n\nsub hsp {\n    shift->throw_not_implemented;\n}\n\n=head2 logical_length\n\n Usage     : $hit_object->logical_length( [seq_type] );\n           : (mostly intended for internal use).\n Purpose   : Get the logical length of the hit sequence.\n           : If the Blast is a TBLASTN or TBLASTX, the returned length \n           : is the length of the would-be amino acid sequence (length/3).\n           : For all other BLAST flavors, this function is the same as length().\n Example   : $len    = $hit_object->logical_length();\n Returns   : Integer \n Argument  : seq_type = 'query' or 'hit' or 'sbjct' (default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  : This is important for functions like frac_aligned_query()\n           : which need to operate in amino acid coordinate space when dealing\n           : with [T]BLAST[NX] type reports.\n\nSee Also   : L<length()|length>, L<frac_aligned_query()|frac_aligned_query>,\n             L<frac_aligned_hit()|frac_aligned_hit>\n\n\nsub logical_length {\n    my ($self, $type) = @_;\n    $type ||= 'query';\n    $type = lc($type);\n\t$type = 'hit' if $type eq 'sbjct';\n    if ($type eq 'query') {\n        return $self->get_field('query_length');\n    }\n    elsif ($type eq 'hit') {\n        return $self->get_field('length');\n    }\n}\n\n=head2 rank\n\n Title   : rank\n Usage   : $obj->rank($newval)\n Function: Get/Set the rank of this Hit in the Query search list\n           i.e. this is the Nth hit for a specific query\n Returns : value of rank\n Args    : newvalue (optional)\n\n\nsub rank {\n    return shift->get_field('rank');\n}\n\n=head2 each_accession_number\n\n Title   : each_accession_number\n Usage   : $obj->each_accession_number\n Function: Get each accession number listed in the description of the hit.\n           If there are no alternatives, then only the primary accession will \n           be given (if there is one).\n Returns : list of all accession numbers in the description\n Args    : none\n\n\nsub each_accession_number {\n    my $self = shift;\n    my $accession = $self->get_field('accession') if $self->has_field('accession');\n    my $desc = $self->get_field('description') if $self->has_field('description');\n    return unless $accession || $desc;\n    \n    my @accnums;\n    push (@accnums, $accession) if $accession;\n    \n    if (defined $desc) { \n        while ($desc =~ /(\\b\\S+\\|\\S*\\|\\S*\\s?)/g) {\n            my $id = $1;\n            my $acc;\n            if ($id =~ /(?:gb|emb|dbj|sp|pdb|bbs|ref|tp[gde])\\|(.*)\\|(?:.*)/) {\n                ($acc) = split /\\./, $1; \n            }\n            elsif ($id =~ /(?:pir|prf|pat|gnl)\\|(?:.*)\\|(.*)/) {\n                ($acc) = split /\\./, $1;  \n            }\n            elsif ($id =~ /(?:gim|gi|bbm|bbs|lcl)\\|(?:\\d*)/) {\n                $acc = $id;\n            }\n            elsif ($id =~ /(?:oth)\\|(.*)\\|(?:.*)\\|(?:.*)/ ) { # discontinued...\n                $acc = $1;\n            }\n            else {\n                $acc = $id;\n            }\n            push(@accnums, $acc);\n        }\n    }\n    return @accnums;\n}\n\n=head2 tiled_hsps\n\n Usage     : $hit_object->tiled_hsps( [integer] );\n Purpose   : Gets/Sets an indicator for whether or not the HSPs in this Hit \n           : have been tiled.\n Example   : $hit_object->tiled_hsps(1);\n           : if( $hit_object->tiled_hsps ) { # do something }\n Returns   : Boolean (1 or 0) \n Argument  : integer (optional)\n Throws    : n/a\n Status    : Deprecated\n Notes     : This value is not used for anything\n\n\nsub tiled_hsps {\n    my $self = shift;\n    if (@_) { $self->{_hsps_are_tiled} = shift }\n    return $self->{_hsps_are_tiled} || 0;\n}\n\n=head2 strand\n\n Usage     : $sbjct->strand( [seq_type] );\n Purpose   : Gets the strand(s) for the query, sbjct, or both sequences\n           : in the best HSP of the BlastHit object after HSP tiling.\n           : Only valid for BLASTN, TBLASTX, BLASTX-query, TBLASTN-hit.\n Example   : $qstrand = $sbjct->strand('query');\n           : $sstrand = $sbjct->strand('hit');\n           : ($qstrand, $sstrand) = $sbjct->strand();\n Returns   : scalar context: integer '1', '-1', or '0'\n           : array context without args: list of two strings (queryStrand, sbjctStrand)\n           : Array context can be \"induced\" by providing an argument of 'list' or 'array'.\n Argument  : In scalar context: seq_type = 'query' or 'hit' or 'sbjct' (default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n           : If you don't want the tiled data, iterate through each HSP\n           : calling strand() on each (use hsps() to get all HSPs).\n           :\n           : Formerly (prior to 10/21/02), this method would return the\n           : string \"-1/1\" for hits with HSPs on both strands.\n           : However, now that strand and frame is properly being accounted\n           : for during HSP tiling, it makes more sense for strand()\n           : to return the strand data for the best HSP after tiling.\n           :\n           : If you really want to know about hits on opposite strands,\n           : you should be iterating through the HSPs using methods on the\n           : HSP objects.\n           :\n           : A possible use case where knowing whether a hit has HSPs \n           : on both strands would be when filtering via SearchIO for hits with \n           : this property. However, in this case it would be better to have a\n           : dedicated method such as $hit->hsps_on_both_strands(). Similarly\n           : for frame. This could be provided if there is interest.\n\nSee Also   : L<Bio::Search::HSP::HSPI::strand>()\n\n\nsub strand {\n    shift->throw_not_implemented;\n}\n\n=head2 frame\n\n Usage     : $hit_object->frame();\n Purpose   : Gets the reading frame for the best HSP after HSP tiling.\n           : This is only valid for BLASTX and TBLASTN/X type reports.\n Example   : $frame = $hit_object->frame();\n Returns   : Integer (-2 .. +2)\n Argument  : n/a\n Throws    : Exception if HSPs have not been set.\n Comments  : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n           : If you don't want the tiled data, iterate through each HSP\n           : calling frame() on each (use hsps() to get all HSPs).\n\nSee Also   : L<hsps()|hsps>\n\n\nsub frame {\n    shift->throw_not_implemented;\n}\n\n=head2 length_aln\n\n Usage     : $hit_object->length_aln( [seq_type] );\n Purpose   : Get the total length of the aligned region for query or sbjct seq.\n           : This number will include all HSPs, and excludes gaps.\n Example   : $len    = $hit_object->length_aln(); # default = query\n           : $lenAln = $hit_object->length_aln('query');\n Returns   : Integer \n Argument  : seq_Type = 'query' or 'hit' or 'sbjct' (Default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : Exception if the argument is not recognized.\n Comments  : This method will report the logical length of the alignment,\n           : meaning that for TBLAST[NX] reports, the length is reported\n           : using amino acid coordinate space (i.e., nucleotides / 3).\n\nSee Also   : L<length()|length>, L<frac_aligned_query()|frac_aligned_query>,\n             L<frac_aligned_hit()|frac_aligned_hit>, L<gaps()|gaps>,\n             L<Bio::Search::SearchUtils::tile_hsps()|Bio::Search::SearchUtils>,\n             L<Bio::Search::HSP::BlastHSP::length()|Bio::Search::HSP::BlastHSP>\n\n\nsub length_aln {\n    my ($self, $seqType) = @_;\n    $seqType ||= 'query';\n    $seqType = 'hit' if $seqType eq 'sbjct';\n    \n\tmy %non_gaps = map { $_, 1 } $self->seq_inds($seqType, 'conserved'),\n\t\t\t\t\t\t\t     $self->seq_inds($seqType, 'no_match');\n\treturn scalar(keys %non_gaps);\n}\n\n=head2 gaps\n\n Usage     : $hit_object->gaps( [seq_type] );\n Purpose   : Get the number of gaps in the aligned query, hit, or both sequences.\n           : Data is summed across all HSPs.\n Example   : $qgaps = $hit_object->gaps('query');\n           : $hgaps = $hit_object->gaps('hit');\n           : $tgaps = $hit_object->gaps();    # default = total (query + hit)\n Returns   : scalar context: integer\n           : array context without args: two-element list of integers  \n           :    (queryGaps, hitGaps)\n           : Array context can be forced by providing an argument of 'list' or\n\t\t   : 'array'.\n           :\n           : CAUTION: Calling this method within printf or sprintf is arrray\n\t\t   : context.\n           : So this function may not give you what you expect. For example:\n           :          printf \"Total gaps: %d\", $hit->gaps();\n           : Actually returns a two-element array, so what gets printed \n           : is the number of gaps in the query, not the total\n           :\n Argument  : seq_type: 'query' | 'hit' or 'sbjct' | 'total' | 'list'\n           : (default = 'total') ('sbjct' is synonymous with 'hit')\n Comments  : If you need data for each HSP, use hsps() and then interate\n           : through each HSP object.\n\n\nsub gaps {\n    my ($self, $seqType) = @_;\n    \n    $seqType ||= (wantarray ? 'list' : 'total');\n    $seqType = 'hit' if $seqType eq 'sbjct';\n    \n    if ($seqType =~ /list|array/i) {\n        return (scalar($self->seq_inds('query', 'gap')), scalar($self->seq_inds('hit', 'gap')));\n    }\n    elsif ($seqType eq 'total') {\n        return (scalar($self->seq_inds('query', 'gap')) + scalar($self->seq_inds('hit', 'gap'))) || 0;\n    }\n    else {\n        return scalar($self->seq_inds($seqType, 'gap')) || 0;\n    }\n}\n\n=head2 matches\n\n Usage     : $hit_object->matches( [class] );\n Purpose   : Get the total number of identical or conserved matches \n           : (or both) across all HSPs.\n           : (Note: 'conservative' matches are indicated as 'positives' \n           :         in BLAST reports.)\n Example   : ($id,$cons) = $hit_object->matches(); # no argument\n           : $id = $hit_object->matches('id');\n           : $cons = $hit_object->matches('cons'); \n Returns   : Integer or a 2-element array of integers \n Argument  : [0] class = 'id' | 'cons' OR none.\n           : [1] seq_type  = 'query' or 'hit' or 'sbjct'  (default = 'query')\n           :                 ('sbjct' is synonymous with 'hit')\n           : If no argument is provided, both identical and conservative \n           : numbers are returned in a two element list.\n           : (Other terms can be used to refer to the conservative\n           :  matches, e.g., 'positive'. All that is checked is whether or\n           :  not the supplied string starts with 'id'. If not, the \n           : conservative matches are returned.)\n\n\nsub matches {\n    my ($self, $class, $seqType) = @_;\n    \n\t# no query/hit choice? The answer differs depending on sequence, since\n\t# hsps could overlap on one sequence and not the other. Added an option,\n\t# but otherwise will assume 'hit'\n\t$seqType ||= 'hit';\n\t$seqType = 'hit' if $seqType eq 'sbjct';\n\t\n\tunless (exists $self->{_id_matches}) {\n\t\t$self->{_id_matches}->{hit} = scalar($self->seq_inds('hit', 'identical'));\n\t\t$self->{_id_matches}->{query} = scalar($self->seq_inds('query', 'identical'));\n\t}\n\tunless (exists $self->{_con_matches}) {\n\t\tforeach my $type ('hit', 'query') {\n\t\t\t# 'conserved-not-identical' can give us 'identical' matches if hsps\n\t\t\t# overlapped so have to get the difference\n\t\t\tmy %identicals = map { $_ => 1 } $self->seq_inds($type, 'identical');\n\t\t\tmy @conserved = $self->seq_inds($type, 'conserved-not-identical');\n\t\t\t\n\t\t\tmy $real_conserved;\n\t\t\tforeach (@conserved) {\n\t\t\t\tunless (exists $identicals{$_}) {\n\t\t\t\t\t$real_conserved++;\n\t\t\t\t}\n\t\t\t}\n\t\t\t$self->{_con_matches}->{$type} = $real_conserved;\n\t\t}\n\t}\n\t\n\t\n    unless ($class) {\n        return ($self->{_id_matches}->{$seqType}, $self->{_con_matches}->{$seqType});\n    }\n    else {\n\t\tif ($class =~ /^id/i) { \n            return $self->{_id_matches}->{$seqType};\n        }\n        else {\n            return $self->{_con_matches}->{$seqType};\n        }\n    }\n    return;\n}\n\n=head2 start\n\n Usage     : $sbjct->start( [seq_type] );\n Purpose   : Gets the start coordinate for the query, sbjct, or both sequences\n           : in the object. If there is more than one HSP, the lowest start\n           : value of all HSPs is returned.\n Example   : $qbeg = $sbjct->start('query');\n           : $sbeg = $sbjct->start('hit');\n           : ($qbeg, $sbeg) = $sbjct->start();\n Returns   : scalar context: integer \n           : array context without args: list of two integers (queryStart,\n           : sbjctStart)\n           : Array context can be \"induced\" by providing an argument of 'list'\n           : or 'array'.\n Argument  : 'query' or 'hit' or 'sbjct' (default = 'query') ('sbjct' is\n             synonymous with 'hit')\n\n\nsub start {\n    my ($self, $seqType) = @_;\n    \n    unless ($self->get_field('num_hsps')) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        return;\n    }\n    \n    $seqType ||= (wantarray ? 'list' : 'query');\n    $seqType = 'hit' if $seqType eq 'sbjct';\n    \n    if ($seqType =~ /list|array/i) {\n\t    return ($self->get_field('query_start'), $self->get_field('hit_start'));\n\t}\n    elsif ($seqType eq 'hit') {\n        return $self->get_field('hit_start');\n\t}\n    elsif ($seqType eq 'query') {\n        return $self->get_field('query_start');\n    }\n    else {\n        $self->throw(\"Unknown sequence type '$seqType'\");\n    }\n}\n\n=head2 end\n\n Usage     : $sbjct->end( [seq_type] );\n Purpose   : Gets the end coordinate for the query, sbjct, or both sequences\n           : in the object. If there is more than one HSP, the largest end\n           : value of all HSPs is returned.\n Example   : $qend = $sbjct->end('query');\n           : $send = $sbjct->end('hit');\n           : ($qend, $send) = $sbjct->end();\n Returns   : scalar context: integer\n           : array context without args: list of two integers \n           : (queryEnd, sbjctEnd)\n           : Array context can be \"induced\" by providing an argument \n           : of 'list' or 'array'.\n Argument  : 'query' or 'hit' or 'sbjct' (default = 'query') ('sbjct' is\n             synonymous with 'hit')\n\n\nsub end {\n    my ($self, $seqType) = @_;\n    \n    unless ($self->get_field('num_hsps')) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        return;\n    }\n    \n    $seqType ||= (wantarray ? 'list' : 'query');\n    $seqType = 'hit' if $seqType eq 'sbjct';\n    \n    if ($seqType =~ /list|array/i) {\n\t    return ($self->get_field('query_end'), $self->get_field('hit_end'));\n\t}\n    elsif ($seqType eq 'hit') {\n        return $self->get_field('hit_end');\n\t}\n    elsif ($seqType eq 'query') {\n        return $self->get_field('query_end');\n    }\n    else {\n        $self->throw(\"Unknown sequence type '$seqType'\");\n    }\n}\n\n=head2 range\n\n Usage     : $sbjct->range( [seq_type] );\n Purpose   : Gets the (start, end) coordinates for the query or sbjct sequence\n           : in the HSP alignment.\n Example   : ($qbeg, $qend) = $sbjct->range('query');\n           : ($sbeg, $send) = $sbjct->range('hit');\n Returns   : Two-element array of integers \n Argument  : seq_type = string, 'query' or 'hit' or 'sbjct'  (default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n\nSee Also   : L<start()|start>, L<end()|end>","label":"range($self,$seqType)"},"detail":"($self,$seqType)","definition":"sub","containerName":"main::"},{"range":{"end":{"character":9999,"line":1033},"start":{"character":0,"line":1019}},"name":"frac_identical","detail":"($self,$seqType)","signature":{"label":"frac_identical($self,$seqType)","parameters":[{"label":"$self"},{"label":"$seqType"}],"documentation":"1;\n# $Id: PullHitI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Search::Hit::PullHitI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Hit::PullHitI - Bio::Search::Hit::HitI interface for pull parsers.\n\n=head1 SYNOPSIS\n\n\t# This is an interface and cannot be instantiated\n\n    # typically one gets HitI objects from a SearchIO stream via a ResultI\n    use Bio::SearchIO;\n    my $parser = Bio::SearchIO->new(-format => 'hmmer_pull',\n                                   -file => 't/data/hmmpfam.out');\n\n    my $result = $parser->next_result;\n    my $hit    = $result->next_hit;\n\n    $hit_name = $hit->name();\n\n    $desc = $hit->description();\n\n    $len = $hit->length\n\n    $alg = $hit->algorithm();\n\n    $score = $hit->raw_score();\n\n    $significance = $hit->significance();\n\n    $rank = $hit->rank(); # the Nth hit for a specific query\n\n    while( $hsp = $obj->next_hsp()) { ... } # process in iterator fashion\n\n    for my $hsp ( $obj->hsps()()) { ... } # process in list fashion\n\n=head1 DESCRIPTION\n\nThis object handles the hit data from a database sequence search.\n\nPullHitI is for fast implementations that only do parsing work on the hit\ndata when you actually request information by calling one of the HitI\nmethods.\n\nMany methods of HitI are implemented in a way suitable for inheriting classes\nthat use Bio::PullParserI. It only really makes sense for PullHit modules to be\ncreated by (and have as a -parent) PullResult modules.\n\nIn addition to the usual -chunk and -parent, -hit_data is all you should supply\nwhen making a PullHit object. This will store that data and make it accessible\nvia _raw_hit_data, which you can access in your subclass. It would be best to\nsimply provide the data as the input -chunk instead, if the raw data is large\nenough.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 COPYRIGHT\n\nCopyright (c) 2006 Sendu Bala. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::Hit::PullHitI;\n\nuse Bio::Search::SearchUtils;\n\nuse strict;\n\nuse base qw(Bio::PullParserI Bio::Search::Hit::HitI);\n\n=head2 _setup\n\n Title   : _setup\n Usage   : $self->_setup(@args)\n Function: Implementers should call this to setup common fields and deal with\n           common arguments to new().\n Returns : n/a\n Args    : @args received in new().\n\n\nsub _setup {\n    my ($self, @args) = @_;\n    \n    # fields most subclasses probably will want\n    $self->_fields( { ( next_hsp => undef,\n                        num_hsps => undef,\n                        hsps => undef,\n                        hit_start => undef,\n                        query_start => undef,\n                        hit_end => undef,\n                        query_end => undef,\n                        length => undef,\n\t\t\t\t\t\tname => undef ,\n\t\t\t\t\t\taccession => undef ) } );\n    \n    my ($parent, $chunk, $hit_data) = $self->_rearrange([qw(PARENT\n                                                            CHUNK\n                                                            HIT_DATA)], @args);\n    $self->throw(\"Need -parent or -chunk to be defined\") unless $parent || $chunk;\n    \n\t$self->parent($parent) if $parent;\n    \n    if ($chunk) {\n        my ($io, $start, $end) = (undef, 0, undef);\n        if (ref($chunk) eq 'ARRAY') {\n            ($io, $start, $end) = @{$chunk};\n        }\n        else {\n            $io = $chunk;\n        }\n        $self->chunk($io, -start => $start, -end => $end);\n    }\n    \n    $self->_raw_hit_data($hit_data) if $hit_data;\n}\n\nsub _raw_hit_data {\n\tmy $self = shift;\n\tif (@_) {\n\t\t$self->{_raw_hit_data} = shift;\n\t}\n\treturn $self->{_raw_hit_data};\n}\n\n#\n# Some of these methods are written explitely to avoid HitI throwing not\n# implemented; if it didn't do that then PullParserI AUTOLOAD would have\n# cought them.\n#\n\n=head2 name\n\n Title   : name\n Usage   : $hit_name = $hit->name();\n Function: returns the name of the Hit sequence\n Returns : a scalar string\n Args    : none\n\nThe B<name> of a hit is unique within a Result or within an Iteration.\n\n\nsub name {\n    return shift->get_field('name');\n}\n\n=head2 description\n\n Title   : description\n Usage   : $desc = $hit->description();\n Function: Retrieve the description for the hit\n Returns : a scalar string\n Args    : none\n\n\nsub description {\n    return shift->get_field('description');\n}\n\n=head2 accession\n\n Title   : accession\n Usage   : $acc = $hit->accession();\n Function: Retrieve the accession (if available) for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub accession {\n    return shift->get_field('accession');\n}\n\n=head2 locus\n\n Title   : locus\n Usage   : $acc = $hit->locus();\n Function: Retrieve the locus(if available) for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub locus {\n    return shift->get_field('locus');\n}\n\n=head2 length\n\n Title   : length\n Usage   : my $len = $hit->length\n Function: Returns the length of the hit \n Returns : integer\n Args    : none\n\n\nsub length {\n   return shift->get_field('length');\n}\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : $alg = $hit->algorithm();\n Function: Gets the algorithm specification that was used to obtain the hit\n           For BLAST, the algorithm denotes what type of sequence was aligned \n           against what (BLASTN: dna-dna, BLASTP prt-prt, BLASTX translated \n           dna-prt, TBLASTN prt-translated dna, TBLASTX translated \n           dna-translated dna).\n Returns : a scalar string \n Args    : none\n\n\nsub algorithm {\n    return shift->get_field('algorithm');\n}\n\n=head2 raw_score\n\n Title   : raw_score\n Usage   : $score = $hit->raw_score();\n Function: Gets the \"raw score\" generated by the algorithm.  What\n           this score is exactly will vary from algorithm to algorithm,\n           returning undef if unavailable.\n Returns : a scalar value\n Args    : none\n\n\nsub raw_score {\n    return shift->get_field('score');\n}\n\n=head2 score\n\nEquivalent to L<raw_score()|raw_score>\n\n\nsub score {\n    return shift->get_field('score');\n}\n\n=head2 significance\n\n Title   : significance\n Usage   : $significance = $hit->significance();\n Function: Used to obtain the E or P value of a hit, i.e. the probability that\n           this particular hit was obtained purely by random chance.  If\n           information is not available (nor calculatable from other\n           information sources), return undef.\n Returns : a scalar value or undef if unavailable\n Args    : none\n\n\nsub significance {\n    return shift->get_field('significance');\n}\n\n=head2 bits\n\n Usage     : $hit_object->bits();\n Purpose   : Gets the bit score of the best HSP for the current hit.\n Example   : $bits = $hit_object->bits();\n Returns   : Integer or double for FASTA reports\n Argument  : n/a\n Comments  : For BLAST1, the non-bit score is listed in the summary line.\n\nSee Also   : L<score()|score>\n\n\nsub bits {\n    return shift->get_field('bits');\n}\n\n=head2 next_hsp\n\n Title    : next_hsp\n Usage    : while( $hsp = $obj->next_hsp()) { ... }\n Function : Returns the next available High Scoring Pair\n Example  : \n Returns  : L<Bio::Search::HSP::HSPI> object or null if finished\n Args     : none\n\n\nsub next_hsp {\n    return shift->get_field('next_hsp');\n}\n\n=head2 hsps\n\n Usage     : $hit_object->hsps();\n Purpose   : Get a list containing all HSP objects.\n           : Get the numbers of HSPs for the current hit.\n Example   : @hsps = $hit_object->hsps();\n           : $num  = $hit_object->hsps();  # alternatively, use num_hsps()\n Returns   : Array context : list of L<Bio::Search::HSP::BlastHSP> objects.\n           : Scalar context: integer (number of HSPs).\n           :                 (Equivalent to num_hsps()).\n Argument  : n/a. Relies on wantarray\n Throws    : Exception if the HSPs have not been collected.\n\nSee Also   : L<hsp()|hsp>, L<num_hsps()|num_hsps>\n\n\nsub hsps {\n    return shift->get_field('hsps');\n}\n\n=head2 num_hsps\n\n Usage     : $hit_object->num_hsps();\n Purpose   : Get the number of HSPs for the present Blast hit.\n Example   : $nhsps = $hit_object->num_hsps();\n Returns   : Integer\n Argument  : n/a\n Throws    : Exception if the HSPs have not been collected.\n\nSee Also   : L<hsps()|hsps>\n\n\nsub num_hsps {\n    return shift->get_field('num_hsps');\n}\n\n#\n# HitI/ GenericHit methods that are unrelated to simply parsing information\n# directly out of a file, but need more complex calculation; mostly not\n# implemented here.\n#\n\n=head2 seq_inds\n\n Usage     : $hit->seq_inds( seq_type, class, collapse );\n Purpose   : Get a list of residue positions (indices) across all HSPs\n           : for identical or conserved residues in the query or sbjct sequence.\n Example   : @s_ind = $hit->seq_inds('query', 'identical');\n           : @h_ind = $hit->seq_inds('hit', 'conserved');\n           : @h_ind = $hit->seq_inds('hit', 'conserved', 1);\n Returns   : Array of integers \n           : May include ranges if collapse is non-zero.\n Argument  : [0] seq_type  = 'query' or 'hit' or 'sbjct'  (default = 'query')\n           :                 ('sbjct' is synonymous with 'hit')\n           : [1] class = 'identical' or 'conserved' or 'nomatch' or 'gap'\n\t\t   :         (default = 'identical')\n           :         (can be shortened to 'id' or 'cons')\n\t\t   :         Note that 'conserved' includes identical unless you use\n\t\t   :         'conserved-not-identical'\n           : [2] collapse = boolean, if non-zero, consecutive positions are\n           :             merged using a range notation, e.g.,\n           :             \"1 2 3 4 5 7 9 10 11\" collapses to \"1-5 7 9-11\". This\n           :             is useful for  consolidating long lists. Default = no\n           :             collapse.\n Throws    : n/a.\n\nSee Also   : L<Bio::Search::HSP::HSPI::seq_inds()|Bio::Search::HSP::HSPI>\n\n\nsub seq_inds {\n    my ($self, $seqType, $class, $collapse) = @_;\n    \n    $seqType  ||= 'query';\n    $class ||= 'identical';\n    $collapse ||= 0;\n    \n    $seqType = 'hit' if $seqType eq 'sbjct';\n    \n\tmy $storage_name = '_seq_inds_'.$seqType.'_'.$class;\n\tunless (defined $self->{$storage_name}) {\n\t\tmy @inds;    \n\t\tforeach my $hsp ($self->hsps) {\n\t\t\t# This will merge data for all HSPs together.\n\t\t\tpush @inds, $hsp->seq_inds($seqType, $class);\n\t\t}\n\t\t\n\t\t# Need to remove duplicates and sort the merged positions, unless gaps.\n\t\tif (@inds && $class ne 'gap') {\n\t\t\tmy %tmp = map { $_, 1 } @inds;\n\t\t\t@inds = sort {$a <=> $b} keys %tmp;\n\t\t}\n\t\t\n\t\t$self->{$storage_name} = \\@inds;\n\t}\n\t\n\tmy @inds = @{$self->{$storage_name}};\n    $collapse ? &Bio::Search::SearchUtils::collapse_nums(@inds) : @inds;\n}\n\n=head2 rewind\n\n Title   : rewind\n Usage   : $hit->rewind;\n Function: Allow one to reset the HSP iterator to the beginning if possible\n Returns : none\n Args    : none\n\n\nsub rewind {\n    shift->throw_not_implemented();\n}\n\n=head2 overlap\n\n Usage     : $hit_object->overlap( [integer] );\n Purpose   : Gets/Sets the allowable amount overlap between different HSP\n             sequences.\n Example   : $hit_object->overlap(5);\n           : $overlap = $hit_object->overlap;\n Returns   : Integer.\n Argument  : integer.\n Throws    : n/a\n Status    : Deprecated\n Comments  : This value isn't used for anything\n\n\nsub overlap {\n    my $self = shift;\n    if (@_) { $self->{_overlap} = shift }\n    return $self->{_overlap} || 0;\n}\n\n=head2 n\n\n Usage     : $hit_object->n();\n Purpose   : Gets the N number for the current Blast hit.\n           : This is the number of HSPs in the set which was ascribed\n           : the lowest P-value (listed on the description line).\n           : This number is not the same as the total number of HSPs.\n           : To get the total number of HSPs, use num_hsps().\n Example   : $n = $hit_object->n();\n Returns   : Integer\n Argument  : n/a\n Throws    : Exception if HSPs have not been set (BLAST2 reports).\n Comments  : Note that the N parameter is not reported in gapped BLAST2.\n           : Calling n() on such reports will result in a call to num_hsps().\n           : The num_hsps() method will count the actual number of\n           : HSPs in the alignment listing, which may exceed N in\n           : some cases.\n\nSee Also   : L<num_hsps()|num_hsps>\n\n\nsub n {\n    return shift->get_field('num_hsps');\n}\n\n=head2 p\n\n Usage     : $hit_object->p( [format] );\n Purpose   : Get the P-value for the best HSP of the given BLAST hit.\n           : (Note that P-values are not provided with NCBI Blast2 reports).\n Example   : $p =  $sbjct->p;\n           : $p =  $sbjct->p('exp');  # get exponent only.\n           : ($num, $exp) =  $sbjct->p('parts'); # split sci notation into parts\n Returns   : Float or scientific notation number (the raw P-value, DEFAULT).\n           : Integer if format == 'exp' (the magnitude of the base 10 exponent).\n           : 2-element list (float, int) if format == 'parts' and P-value\n           :                is in scientific notation (See Comments).\n Argument  : format: string of 'raw' | 'exp' | 'parts'\n           :    'raw' returns value given in report. Default. (1.2e-34)\n           :    'exp' returns exponent value only (34)\n           :    'parts' returns the decimal and exponent as a \n           :            2-element list (1.2, -34) (See Comments).\n Throws    : Warns if no P-value is defined. Uses expect instead.\n Comments  : Using the 'parts' argument is not recommended since it will not\n           : work as expected if the P-value is not in scientific notation.\n           : That is, floats are not converted into sci notation before\n           : splitting into parts.\n\nSee Also   : L<expect()|expect>, L<signif()|signif>,\n             L<Bio::Search::BlastUtils::get_exponent()|Bio::Search::BlastUtils>\n\n\nsub p {\n    shift->throw_not_implemented;\n}\n\n=head2 hsp\n\n Usage     : $hit_object->hsp( [string] );\n Purpose   : Get a single HSPI object for the present HitI object.\n Example   : $hspObj  = $hit_object->hsp;  # same as 'best'\n           : $hspObj  = $hit_object->hsp('best');\n           : $hspObj  = $hit_object->hsp('worst');\n Returns   : Object reference for a L<Bio::Search::HSP::HSPI> object.\n Argument  : String (or no argument).\n           :   No argument (default) = highest scoring HSP (same as 'best').\n           :   'best'  = highest scoring HSP.\n           :   'worst' = lowest scoring HSP.\n Throws    : Exception if an unrecognized argument is used.\n\nSee Also   : L<hsps()|hsps>, L<num_hsps>()\n\n\nsub hsp {\n    shift->throw_not_implemented;\n}\n\n=head2 logical_length\n\n Usage     : $hit_object->logical_length( [seq_type] );\n           : (mostly intended for internal use).\n Purpose   : Get the logical length of the hit sequence.\n           : If the Blast is a TBLASTN or TBLASTX, the returned length \n           : is the length of the would-be amino acid sequence (length/3).\n           : For all other BLAST flavors, this function is the same as length().\n Example   : $len    = $hit_object->logical_length();\n Returns   : Integer \n Argument  : seq_type = 'query' or 'hit' or 'sbjct' (default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  : This is important for functions like frac_aligned_query()\n           : which need to operate in amino acid coordinate space when dealing\n           : with [T]BLAST[NX] type reports.\n\nSee Also   : L<length()|length>, L<frac_aligned_query()|frac_aligned_query>,\n             L<frac_aligned_hit()|frac_aligned_hit>\n\n\nsub logical_length {\n    my ($self, $type) = @_;\n    $type ||= 'query';\n    $type = lc($type);\n\t$type = 'hit' if $type eq 'sbjct';\n    if ($type eq 'query') {\n        return $self->get_field('query_length');\n    }\n    elsif ($type eq 'hit') {\n        return $self->get_field('length');\n    }\n}\n\n=head2 rank\n\n Title   : rank\n Usage   : $obj->rank($newval)\n Function: Get/Set the rank of this Hit in the Query search list\n           i.e. this is the Nth hit for a specific query\n Returns : value of rank\n Args    : newvalue (optional)\n\n\nsub rank {\n    return shift->get_field('rank');\n}\n\n=head2 each_accession_number\n\n Title   : each_accession_number\n Usage   : $obj->each_accession_number\n Function: Get each accession number listed in the description of the hit.\n           If there are no alternatives, then only the primary accession will \n           be given (if there is one).\n Returns : list of all accession numbers in the description\n Args    : none\n\n\nsub each_accession_number {\n    my $self = shift;\n    my $accession = $self->get_field('accession') if $self->has_field('accession');\n    my $desc = $self->get_field('description') if $self->has_field('description');\n    return unless $accession || $desc;\n    \n    my @accnums;\n    push (@accnums, $accession) if $accession;\n    \n    if (defined $desc) { \n        while ($desc =~ /(\\b\\S+\\|\\S*\\|\\S*\\s?)/g) {\n            my $id = $1;\n            my $acc;\n            if ($id =~ /(?:gb|emb|dbj|sp|pdb|bbs|ref|tp[gde])\\|(.*)\\|(?:.*)/) {\n                ($acc) = split /\\./, $1; \n            }\n            elsif ($id =~ /(?:pir|prf|pat|gnl)\\|(?:.*)\\|(.*)/) {\n                ($acc) = split /\\./, $1;  \n            }\n            elsif ($id =~ /(?:gim|gi|bbm|bbs|lcl)\\|(?:\\d*)/) {\n                $acc = $id;\n            }\n            elsif ($id =~ /(?:oth)\\|(.*)\\|(?:.*)\\|(?:.*)/ ) { # discontinued...\n                $acc = $1;\n            }\n            else {\n                $acc = $id;\n            }\n            push(@accnums, $acc);\n        }\n    }\n    return @accnums;\n}\n\n=head2 tiled_hsps\n\n Usage     : $hit_object->tiled_hsps( [integer] );\n Purpose   : Gets/Sets an indicator for whether or not the HSPs in this Hit \n           : have been tiled.\n Example   : $hit_object->tiled_hsps(1);\n           : if( $hit_object->tiled_hsps ) { # do something }\n Returns   : Boolean (1 or 0) \n Argument  : integer (optional)\n Throws    : n/a\n Status    : Deprecated\n Notes     : This value is not used for anything\n\n\nsub tiled_hsps {\n    my $self = shift;\n    if (@_) { $self->{_hsps_are_tiled} = shift }\n    return $self->{_hsps_are_tiled} || 0;\n}\n\n=head2 strand\n\n Usage     : $sbjct->strand( [seq_type] );\n Purpose   : Gets the strand(s) for the query, sbjct, or both sequences\n           : in the best HSP of the BlastHit object after HSP tiling.\n           : Only valid for BLASTN, TBLASTX, BLASTX-query, TBLASTN-hit.\n Example   : $qstrand = $sbjct->strand('query');\n           : $sstrand = $sbjct->strand('hit');\n           : ($qstrand, $sstrand) = $sbjct->strand();\n Returns   : scalar context: integer '1', '-1', or '0'\n           : array context without args: list of two strings (queryStrand, sbjctStrand)\n           : Array context can be \"induced\" by providing an argument of 'list' or 'array'.\n Argument  : In scalar context: seq_type = 'query' or 'hit' or 'sbjct' (default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n           : If you don't want the tiled data, iterate through each HSP\n           : calling strand() on each (use hsps() to get all HSPs).\n           :\n           : Formerly (prior to 10/21/02), this method would return the\n           : string \"-1/1\" for hits with HSPs on both strands.\n           : However, now that strand and frame is properly being accounted\n           : for during HSP tiling, it makes more sense for strand()\n           : to return the strand data for the best HSP after tiling.\n           :\n           : If you really want to know about hits on opposite strands,\n           : you should be iterating through the HSPs using methods on the\n           : HSP objects.\n           :\n           : A possible use case where knowing whether a hit has HSPs \n           : on both strands would be when filtering via SearchIO for hits with \n           : this property. However, in this case it would be better to have a\n           : dedicated method such as $hit->hsps_on_both_strands(). Similarly\n           : for frame. This could be provided if there is interest.\n\nSee Also   : L<Bio::Search::HSP::HSPI::strand>()\n\n\nsub strand {\n    shift->throw_not_implemented;\n}\n\n=head2 frame\n\n Usage     : $hit_object->frame();\n Purpose   : Gets the reading frame for the best HSP after HSP tiling.\n           : This is only valid for BLASTX and TBLASTN/X type reports.\n Example   : $frame = $hit_object->frame();\n Returns   : Integer (-2 .. +2)\n Argument  : n/a\n Throws    : Exception if HSPs have not been set.\n Comments  : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n           : If you don't want the tiled data, iterate through each HSP\n           : calling frame() on each (use hsps() to get all HSPs).\n\nSee Also   : L<hsps()|hsps>\n\n\nsub frame {\n    shift->throw_not_implemented;\n}\n\n=head2 length_aln\n\n Usage     : $hit_object->length_aln( [seq_type] );\n Purpose   : Get the total length of the aligned region for query or sbjct seq.\n           : This number will include all HSPs, and excludes gaps.\n Example   : $len    = $hit_object->length_aln(); # default = query\n           : $lenAln = $hit_object->length_aln('query');\n Returns   : Integer \n Argument  : seq_Type = 'query' or 'hit' or 'sbjct' (Default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : Exception if the argument is not recognized.\n Comments  : This method will report the logical length of the alignment,\n           : meaning that for TBLAST[NX] reports, the length is reported\n           : using amino acid coordinate space (i.e., nucleotides / 3).\n\nSee Also   : L<length()|length>, L<frac_aligned_query()|frac_aligned_query>,\n             L<frac_aligned_hit()|frac_aligned_hit>, L<gaps()|gaps>,\n             L<Bio::Search::SearchUtils::tile_hsps()|Bio::Search::SearchUtils>,\n             L<Bio::Search::HSP::BlastHSP::length()|Bio::Search::HSP::BlastHSP>\n\n\nsub length_aln {\n    my ($self, $seqType) = @_;\n    $seqType ||= 'query';\n    $seqType = 'hit' if $seqType eq 'sbjct';\n    \n\tmy %non_gaps = map { $_, 1 } $self->seq_inds($seqType, 'conserved'),\n\t\t\t\t\t\t\t     $self->seq_inds($seqType, 'no_match');\n\treturn scalar(keys %non_gaps);\n}\n\n=head2 gaps\n\n Usage     : $hit_object->gaps( [seq_type] );\n Purpose   : Get the number of gaps in the aligned query, hit, or both sequences.\n           : Data is summed across all HSPs.\n Example   : $qgaps = $hit_object->gaps('query');\n           : $hgaps = $hit_object->gaps('hit');\n           : $tgaps = $hit_object->gaps();    # default = total (query + hit)\n Returns   : scalar context: integer\n           : array context without args: two-element list of integers  \n           :    (queryGaps, hitGaps)\n           : Array context can be forced by providing an argument of 'list' or\n\t\t   : 'array'.\n           :\n           : CAUTION: Calling this method within printf or sprintf is arrray\n\t\t   : context.\n           : So this function may not give you what you expect. For example:\n           :          printf \"Total gaps: %d\", $hit->gaps();\n           : Actually returns a two-element array, so what gets printed \n           : is the number of gaps in the query, not the total\n           :\n Argument  : seq_type: 'query' | 'hit' or 'sbjct' | 'total' | 'list'\n           : (default = 'total') ('sbjct' is synonymous with 'hit')\n Comments  : If you need data for each HSP, use hsps() and then interate\n           : through each HSP object.\n\n\nsub gaps {\n    my ($self, $seqType) = @_;\n    \n    $seqType ||= (wantarray ? 'list' : 'total');\n    $seqType = 'hit' if $seqType eq 'sbjct';\n    \n    if ($seqType =~ /list|array/i) {\n        return (scalar($self->seq_inds('query', 'gap')), scalar($self->seq_inds('hit', 'gap')));\n    }\n    elsif ($seqType eq 'total') {\n        return (scalar($self->seq_inds('query', 'gap')) + scalar($self->seq_inds('hit', 'gap'))) || 0;\n    }\n    else {\n        return scalar($self->seq_inds($seqType, 'gap')) || 0;\n    }\n}\n\n=head2 matches\n\n Usage     : $hit_object->matches( [class] );\n Purpose   : Get the total number of identical or conserved matches \n           : (or both) across all HSPs.\n           : (Note: 'conservative' matches are indicated as 'positives' \n           :         in BLAST reports.)\n Example   : ($id,$cons) = $hit_object->matches(); # no argument\n           : $id = $hit_object->matches('id');\n           : $cons = $hit_object->matches('cons'); \n Returns   : Integer or a 2-element array of integers \n Argument  : [0] class = 'id' | 'cons' OR none.\n           : [1] seq_type  = 'query' or 'hit' or 'sbjct'  (default = 'query')\n           :                 ('sbjct' is synonymous with 'hit')\n           : If no argument is provided, both identical and conservative \n           : numbers are returned in a two element list.\n           : (Other terms can be used to refer to the conservative\n           :  matches, e.g., 'positive'. All that is checked is whether or\n           :  not the supplied string starts with 'id'. If not, the \n           : conservative matches are returned.)\n\n\nsub matches {\n    my ($self, $class, $seqType) = @_;\n    \n\t# no query/hit choice? The answer differs depending on sequence, since\n\t# hsps could overlap on one sequence and not the other. Added an option,\n\t# but otherwise will assume 'hit'\n\t$seqType ||= 'hit';\n\t$seqType = 'hit' if $seqType eq 'sbjct';\n\t\n\tunless (exists $self->{_id_matches}) {\n\t\t$self->{_id_matches}->{hit} = scalar($self->seq_inds('hit', 'identical'));\n\t\t$self->{_id_matches}->{query} = scalar($self->seq_inds('query', 'identical'));\n\t}\n\tunless (exists $self->{_con_matches}) {\n\t\tforeach my $type ('hit', 'query') {\n\t\t\t# 'conserved-not-identical' can give us 'identical' matches if hsps\n\t\t\t# overlapped so have to get the difference\n\t\t\tmy %identicals = map { $_ => 1 } $self->seq_inds($type, 'identical');\n\t\t\tmy @conserved = $self->seq_inds($type, 'conserved-not-identical');\n\t\t\t\n\t\t\tmy $real_conserved;\n\t\t\tforeach (@conserved) {\n\t\t\t\tunless (exists $identicals{$_}) {\n\t\t\t\t\t$real_conserved++;\n\t\t\t\t}\n\t\t\t}\n\t\t\t$self->{_con_matches}->{$type} = $real_conserved;\n\t\t}\n\t}\n\t\n\t\n    unless ($class) {\n        return ($self->{_id_matches}->{$seqType}, $self->{_con_matches}->{$seqType});\n    }\n    else {\n\t\tif ($class =~ /^id/i) { \n            return $self->{_id_matches}->{$seqType};\n        }\n        else {\n            return $self->{_con_matches}->{$seqType};\n        }\n    }\n    return;\n}\n\n=head2 start\n\n Usage     : $sbjct->start( [seq_type] );\n Purpose   : Gets the start coordinate for the query, sbjct, or both sequences\n           : in the object. If there is more than one HSP, the lowest start\n           : value of all HSPs is returned.\n Example   : $qbeg = $sbjct->start('query');\n           : $sbeg = $sbjct->start('hit');\n           : ($qbeg, $sbeg) = $sbjct->start();\n Returns   : scalar context: integer \n           : array context without args: list of two integers (queryStart,\n           : sbjctStart)\n           : Array context can be \"induced\" by providing an argument of 'list'\n           : or 'array'.\n Argument  : 'query' or 'hit' or 'sbjct' (default = 'query') ('sbjct' is\n             synonymous with 'hit')\n\n\nsub start {\n    my ($self, $seqType) = @_;\n    \n    unless ($self->get_field('num_hsps')) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        return;\n    }\n    \n    $seqType ||= (wantarray ? 'list' : 'query');\n    $seqType = 'hit' if $seqType eq 'sbjct';\n    \n    if ($seqType =~ /list|array/i) {\n\t    return ($self->get_field('query_start'), $self->get_field('hit_start'));\n\t}\n    elsif ($seqType eq 'hit') {\n        return $self->get_field('hit_start');\n\t}\n    elsif ($seqType eq 'query') {\n        return $self->get_field('query_start');\n    }\n    else {\n        $self->throw(\"Unknown sequence type '$seqType'\");\n    }\n}\n\n=head2 end\n\n Usage     : $sbjct->end( [seq_type] );\n Purpose   : Gets the end coordinate for the query, sbjct, or both sequences\n           : in the object. If there is more than one HSP, the largest end\n           : value of all HSPs is returned.\n Example   : $qend = $sbjct->end('query');\n           : $send = $sbjct->end('hit');\n           : ($qend, $send) = $sbjct->end();\n Returns   : scalar context: integer\n           : array context without args: list of two integers \n           : (queryEnd, sbjctEnd)\n           : Array context can be \"induced\" by providing an argument \n           : of 'list' or 'array'.\n Argument  : 'query' or 'hit' or 'sbjct' (default = 'query') ('sbjct' is\n             synonymous with 'hit')\n\n\nsub end {\n    my ($self, $seqType) = @_;\n    \n    unless ($self->get_field('num_hsps')) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        return;\n    }\n    \n    $seqType ||= (wantarray ? 'list' : 'query');\n    $seqType = 'hit' if $seqType eq 'sbjct';\n    \n    if ($seqType =~ /list|array/i) {\n\t    return ($self->get_field('query_end'), $self->get_field('hit_end'));\n\t}\n    elsif ($seqType eq 'hit') {\n        return $self->get_field('hit_end');\n\t}\n    elsif ($seqType eq 'query') {\n        return $self->get_field('query_end');\n    }\n    else {\n        $self->throw(\"Unknown sequence type '$seqType'\");\n    }\n}\n\n=head2 range\n\n Usage     : $sbjct->range( [seq_type] );\n Purpose   : Gets the (start, end) coordinates for the query or sbjct sequence\n           : in the HSP alignment.\n Example   : ($qbeg, $qend) = $sbjct->range('query');\n           : ($sbeg, $send) = $sbjct->range('hit');\n Returns   : Two-element array of integers \n Argument  : seq_type = string, 'query' or 'hit' or 'sbjct'  (default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n\nSee Also   : L<start()|start>, L<end()|end>\n\n\nsub range {\n    my ($self, $seqType) = @_;\n    $seqType ||= 'query';\n    $seqType = 'hit' if $seqType eq 'sbjct';\n    return ($self->start($seqType), $self->end($seqType));\n}\n\n=head2 frac_identical\n\n Usage     : $hit_object->frac_identical( [seq_type] );\n Purpose   : Get the overall fraction of identical positions across all HSPs.\n           : The number refers to only the aligned regions and does not\n           : account for unaligned regions in between the HSPs, if any.\n Example   : $frac_iden = $hit_object->frac_identical('query');\n Returns   : Float (2-decimal precision, e.g., 0.75).\n Argument  : seq_type: 'query' | 'hit' or 'sbjct' | 'total'\n           : default = 'query' (but see comments below).\n           : ('sbjct' is synonymous with 'hit')"},"containerName":"main::","definition":"sub","line":1019,"children":[{"localvar":"my","containerName":"frac_identical","name":"$self","definition":"my","line":1020,"kind":13},{"containerName":"frac_identical","name":"$seqType","kind":13,"line":1020},{"name":"$seqType","containerName":"frac_identical","line":1021,"kind":13},{"name":"$seqType","containerName":"frac_identical","kind":13,"line":1022},{"line":1022,"kind":13,"containerName":"frac_identical","name":"$seqType"},{"kind":13,"line":1023,"containerName":"frac_identical","name":"$seqType"},{"kind":13,"line":1023,"containerName":"frac_identical","name":"$seqType"},{"line":1025,"kind":13,"localvar":"my","containerName":"frac_identical","name":"$ident","definition":"my"},{"name":"$self","containerName":"frac_identical","line":1025,"kind":13},{"kind":12,"line":1025,"containerName":"frac_identical","name":"matches"},{"containerName":"frac_identical","name":"$seqType","kind":13,"line":1025},{"line":1026,"kind":13,"localvar":"my","containerName":"frac_identical","definition":"my","name":"$total"},{"containerName":"frac_identical","name":"$self","line":1026,"kind":13},{"name":"length_aln","containerName":"frac_identical","kind":12,"line":1026},{"line":1026,"kind":13,"containerName":"frac_identical","name":"$seqType"},{"kind":13,"line":1027,"containerName":"frac_identical","definition":"my","name":"$ratio","localvar":"my"},{"kind":13,"line":1027,"containerName":"frac_identical","name":"$ident"},{"containerName":"frac_identical","name":"$total","line":1027,"kind":13},{"kind":13,"line":1028,"containerName":"frac_identical","definition":"my","name":"$ratio_rounded","localvar":"my"},{"line":1028,"kind":13,"containerName":"frac_identical","name":"$ratio"},{"containerName":"frac_identical","name":"$ratio_rounded","line":1031,"kind":13},{"line":1031,"kind":13,"containerName":"frac_identical","name":"$ratio_rounded"},{"name":"$ratio","containerName":"frac_identical","kind":13,"line":1031},{"line":1032,"kind":13,"name":"$ratio_rounded","containerName":"frac_identical"}],"kind":12},{"name":"frac_conserved","range":{"end":{"line":1063,"character":9999},"start":{"character":0,"line":1049}},"definition":"sub","containerName":"main::","signature":{"documentation":"1;\n# $Id: PullHitI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Search::Hit::PullHitI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Hit::PullHitI - Bio::Search::Hit::HitI interface for pull parsers.\n\n=head1 SYNOPSIS\n\n\t# This is an interface and cannot be instantiated\n\n    # typically one gets HitI objects from a SearchIO stream via a ResultI\n    use Bio::SearchIO;\n    my $parser = Bio::SearchIO->new(-format => 'hmmer_pull',\n                                   -file => 't/data/hmmpfam.out');\n\n    my $result = $parser->next_result;\n    my $hit    = $result->next_hit;\n\n    $hit_name = $hit->name();\n\n    $desc = $hit->description();\n\n    $len = $hit->length\n\n    $alg = $hit->algorithm();\n\n    $score = $hit->raw_score();\n\n    $significance = $hit->significance();\n\n    $rank = $hit->rank(); # the Nth hit for a specific query\n\n    while( $hsp = $obj->next_hsp()) { ... } # process in iterator fashion\n\n    for my $hsp ( $obj->hsps()()) { ... } # process in list fashion\n\n=head1 DESCRIPTION\n\nThis object handles the hit data from a database sequence search.\n\nPullHitI is for fast implementations that only do parsing work on the hit\ndata when you actually request information by calling one of the HitI\nmethods.\n\nMany methods of HitI are implemented in a way suitable for inheriting classes\nthat use Bio::PullParserI. It only really makes sense for PullHit modules to be\ncreated by (and have as a -parent) PullResult modules.\n\nIn addition to the usual -chunk and -parent, -hit_data is all you should supply\nwhen making a PullHit object. This will store that data and make it accessible\nvia _raw_hit_data, which you can access in your subclass. It would be best to\nsimply provide the data as the input -chunk instead, if the raw data is large\nenough.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 COPYRIGHT\n\nCopyright (c) 2006 Sendu Bala. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::Hit::PullHitI;\n\nuse Bio::Search::SearchUtils;\n\nuse strict;\n\nuse base qw(Bio::PullParserI Bio::Search::Hit::HitI);\n\n=head2 _setup\n\n Title   : _setup\n Usage   : $self->_setup(@args)\n Function: Implementers should call this to setup common fields and deal with\n           common arguments to new().\n Returns : n/a\n Args    : @args received in new().\n\n\nsub _setup {\n    my ($self, @args) = @_;\n    \n    # fields most subclasses probably will want\n    $self->_fields( { ( next_hsp => undef,\n                        num_hsps => undef,\n                        hsps => undef,\n                        hit_start => undef,\n                        query_start => undef,\n                        hit_end => undef,\n                        query_end => undef,\n                        length => undef,\n\t\t\t\t\t\tname => undef ,\n\t\t\t\t\t\taccession => undef ) } );\n    \n    my ($parent, $chunk, $hit_data) = $self->_rearrange([qw(PARENT\n                                                            CHUNK\n                                                            HIT_DATA)], @args);\n    $self->throw(\"Need -parent or -chunk to be defined\") unless $parent || $chunk;\n    \n\t$self->parent($parent) if $parent;\n    \n    if ($chunk) {\n        my ($io, $start, $end) = (undef, 0, undef);\n        if (ref($chunk) eq 'ARRAY') {\n            ($io, $start, $end) = @{$chunk};\n        }\n        else {\n            $io = $chunk;\n        }\n        $self->chunk($io, -start => $start, -end => $end);\n    }\n    \n    $self->_raw_hit_data($hit_data) if $hit_data;\n}\n\nsub _raw_hit_data {\n\tmy $self = shift;\n\tif (@_) {\n\t\t$self->{_raw_hit_data} = shift;\n\t}\n\treturn $self->{_raw_hit_data};\n}\n\n#\n# Some of these methods are written explitely to avoid HitI throwing not\n# implemented; if it didn't do that then PullParserI AUTOLOAD would have\n# cought them.\n#\n\n=head2 name\n\n Title   : name\n Usage   : $hit_name = $hit->name();\n Function: returns the name of the Hit sequence\n Returns : a scalar string\n Args    : none\n\nThe B<name> of a hit is unique within a Result or within an Iteration.\n\n\nsub name {\n    return shift->get_field('name');\n}\n\n=head2 description\n\n Title   : description\n Usage   : $desc = $hit->description();\n Function: Retrieve the description for the hit\n Returns : a scalar string\n Args    : none\n\n\nsub description {\n    return shift->get_field('description');\n}\n\n=head2 accession\n\n Title   : accession\n Usage   : $acc = $hit->accession();\n Function: Retrieve the accession (if available) for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub accession {\n    return shift->get_field('accession');\n}\n\n=head2 locus\n\n Title   : locus\n Usage   : $acc = $hit->locus();\n Function: Retrieve the locus(if available) for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub locus {\n    return shift->get_field('locus');\n}\n\n=head2 length\n\n Title   : length\n Usage   : my $len = $hit->length\n Function: Returns the length of the hit \n Returns : integer\n Args    : none\n\n\nsub length {\n   return shift->get_field('length');\n}\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : $alg = $hit->algorithm();\n Function: Gets the algorithm specification that was used to obtain the hit\n           For BLAST, the algorithm denotes what type of sequence was aligned \n           against what (BLASTN: dna-dna, BLASTP prt-prt, BLASTX translated \n           dna-prt, TBLASTN prt-translated dna, TBLASTX translated \n           dna-translated dna).\n Returns : a scalar string \n Args    : none\n\n\nsub algorithm {\n    return shift->get_field('algorithm');\n}\n\n=head2 raw_score\n\n Title   : raw_score\n Usage   : $score = $hit->raw_score();\n Function: Gets the \"raw score\" generated by the algorithm.  What\n           this score is exactly will vary from algorithm to algorithm,\n           returning undef if unavailable.\n Returns : a scalar value\n Args    : none\n\n\nsub raw_score {\n    return shift->get_field('score');\n}\n\n=head2 score\n\nEquivalent to L<raw_score()|raw_score>\n\n\nsub score {\n    return shift->get_field('score');\n}\n\n=head2 significance\n\n Title   : significance\n Usage   : $significance = $hit->significance();\n Function: Used to obtain the E or P value of a hit, i.e. the probability that\n           this particular hit was obtained purely by random chance.  If\n           information is not available (nor calculatable from other\n           information sources), return undef.\n Returns : a scalar value or undef if unavailable\n Args    : none\n\n\nsub significance {\n    return shift->get_field('significance');\n}\n\n=head2 bits\n\n Usage     : $hit_object->bits();\n Purpose   : Gets the bit score of the best HSP for the current hit.\n Example   : $bits = $hit_object->bits();\n Returns   : Integer or double for FASTA reports\n Argument  : n/a\n Comments  : For BLAST1, the non-bit score is listed in the summary line.\n\nSee Also   : L<score()|score>\n\n\nsub bits {\n    return shift->get_field('bits');\n}\n\n=head2 next_hsp\n\n Title    : next_hsp\n Usage    : while( $hsp = $obj->next_hsp()) { ... }\n Function : Returns the next available High Scoring Pair\n Example  : \n Returns  : L<Bio::Search::HSP::HSPI> object or null if finished\n Args     : none\n\n\nsub next_hsp {\n    return shift->get_field('next_hsp');\n}\n\n=head2 hsps\n\n Usage     : $hit_object->hsps();\n Purpose   : Get a list containing all HSP objects.\n           : Get the numbers of HSPs for the current hit.\n Example   : @hsps = $hit_object->hsps();\n           : $num  = $hit_object->hsps();  # alternatively, use num_hsps()\n Returns   : Array context : list of L<Bio::Search::HSP::BlastHSP> objects.\n           : Scalar context: integer (number of HSPs).\n           :                 (Equivalent to num_hsps()).\n Argument  : n/a. Relies on wantarray\n Throws    : Exception if the HSPs have not been collected.\n\nSee Also   : L<hsp()|hsp>, L<num_hsps()|num_hsps>\n\n\nsub hsps {\n    return shift->get_field('hsps');\n}\n\n=head2 num_hsps\n\n Usage     : $hit_object->num_hsps();\n Purpose   : Get the number of HSPs for the present Blast hit.\n Example   : $nhsps = $hit_object->num_hsps();\n Returns   : Integer\n Argument  : n/a\n Throws    : Exception if the HSPs have not been collected.\n\nSee Also   : L<hsps()|hsps>\n\n\nsub num_hsps {\n    return shift->get_field('num_hsps');\n}\n\n#\n# HitI/ GenericHit methods that are unrelated to simply parsing information\n# directly out of a file, but need more complex calculation; mostly not\n# implemented here.\n#\n\n=head2 seq_inds\n\n Usage     : $hit->seq_inds( seq_type, class, collapse );\n Purpose   : Get a list of residue positions (indices) across all HSPs\n           : for identical or conserved residues in the query or sbjct sequence.\n Example   : @s_ind = $hit->seq_inds('query', 'identical');\n           : @h_ind = $hit->seq_inds('hit', 'conserved');\n           : @h_ind = $hit->seq_inds('hit', 'conserved', 1);\n Returns   : Array of integers \n           : May include ranges if collapse is non-zero.\n Argument  : [0] seq_type  = 'query' or 'hit' or 'sbjct'  (default = 'query')\n           :                 ('sbjct' is synonymous with 'hit')\n           : [1] class = 'identical' or 'conserved' or 'nomatch' or 'gap'\n\t\t   :         (default = 'identical')\n           :         (can be shortened to 'id' or 'cons')\n\t\t   :         Note that 'conserved' includes identical unless you use\n\t\t   :         'conserved-not-identical'\n           : [2] collapse = boolean, if non-zero, consecutive positions are\n           :             merged using a range notation, e.g.,\n           :             \"1 2 3 4 5 7 9 10 11\" collapses to \"1-5 7 9-11\". This\n           :             is useful for  consolidating long lists. Default = no\n           :             collapse.\n Throws    : n/a.\n\nSee Also   : L<Bio::Search::HSP::HSPI::seq_inds()|Bio::Search::HSP::HSPI>\n\n\nsub seq_inds {\n    my ($self, $seqType, $class, $collapse) = @_;\n    \n    $seqType  ||= 'query';\n    $class ||= 'identical';\n    $collapse ||= 0;\n    \n    $seqType = 'hit' if $seqType eq 'sbjct';\n    \n\tmy $storage_name = '_seq_inds_'.$seqType.'_'.$class;\n\tunless (defined $self->{$storage_name}) {\n\t\tmy @inds;    \n\t\tforeach my $hsp ($self->hsps) {\n\t\t\t# This will merge data for all HSPs together.\n\t\t\tpush @inds, $hsp->seq_inds($seqType, $class);\n\t\t}\n\t\t\n\t\t# Need to remove duplicates and sort the merged positions, unless gaps.\n\t\tif (@inds && $class ne 'gap') {\n\t\t\tmy %tmp = map { $_, 1 } @inds;\n\t\t\t@inds = sort {$a <=> $b} keys %tmp;\n\t\t}\n\t\t\n\t\t$self->{$storage_name} = \\@inds;\n\t}\n\t\n\tmy @inds = @{$self->{$storage_name}};\n    $collapse ? &Bio::Search::SearchUtils::collapse_nums(@inds) : @inds;\n}\n\n=head2 rewind\n\n Title   : rewind\n Usage   : $hit->rewind;\n Function: Allow one to reset the HSP iterator to the beginning if possible\n Returns : none\n Args    : none\n\n\nsub rewind {\n    shift->throw_not_implemented();\n}\n\n=head2 overlap\n\n Usage     : $hit_object->overlap( [integer] );\n Purpose   : Gets/Sets the allowable amount overlap between different HSP\n             sequences.\n Example   : $hit_object->overlap(5);\n           : $overlap = $hit_object->overlap;\n Returns   : Integer.\n Argument  : integer.\n Throws    : n/a\n Status    : Deprecated\n Comments  : This value isn't used for anything\n\n\nsub overlap {\n    my $self = shift;\n    if (@_) { $self->{_overlap} = shift }\n    return $self->{_overlap} || 0;\n}\n\n=head2 n\n\n Usage     : $hit_object->n();\n Purpose   : Gets the N number for the current Blast hit.\n           : This is the number of HSPs in the set which was ascribed\n           : the lowest P-value (listed on the description line).\n           : This number is not the same as the total number of HSPs.\n           : To get the total number of HSPs, use num_hsps().\n Example   : $n = $hit_object->n();\n Returns   : Integer\n Argument  : n/a\n Throws    : Exception if HSPs have not been set (BLAST2 reports).\n Comments  : Note that the N parameter is not reported in gapped BLAST2.\n           : Calling n() on such reports will result in a call to num_hsps().\n           : The num_hsps() method will count the actual number of\n           : HSPs in the alignment listing, which may exceed N in\n           : some cases.\n\nSee Also   : L<num_hsps()|num_hsps>\n\n\nsub n {\n    return shift->get_field('num_hsps');\n}\n\n=head2 p\n\n Usage     : $hit_object->p( [format] );\n Purpose   : Get the P-value for the best HSP of the given BLAST hit.\n           : (Note that P-values are not provided with NCBI Blast2 reports).\n Example   : $p =  $sbjct->p;\n           : $p =  $sbjct->p('exp');  # get exponent only.\n           : ($num, $exp) =  $sbjct->p('parts'); # split sci notation into parts\n Returns   : Float or scientific notation number (the raw P-value, DEFAULT).\n           : Integer if format == 'exp' (the magnitude of the base 10 exponent).\n           : 2-element list (float, int) if format == 'parts' and P-value\n           :                is in scientific notation (See Comments).\n Argument  : format: string of 'raw' | 'exp' | 'parts'\n           :    'raw' returns value given in report. Default. (1.2e-34)\n           :    'exp' returns exponent value only (34)\n           :    'parts' returns the decimal and exponent as a \n           :            2-element list (1.2, -34) (See Comments).\n Throws    : Warns if no P-value is defined. Uses expect instead.\n Comments  : Using the 'parts' argument is not recommended since it will not\n           : work as expected if the P-value is not in scientific notation.\n           : That is, floats are not converted into sci notation before\n           : splitting into parts.\n\nSee Also   : L<expect()|expect>, L<signif()|signif>,\n             L<Bio::Search::BlastUtils::get_exponent()|Bio::Search::BlastUtils>\n\n\nsub p {\n    shift->throw_not_implemented;\n}\n\n=head2 hsp\n\n Usage     : $hit_object->hsp( [string] );\n Purpose   : Get a single HSPI object for the present HitI object.\n Example   : $hspObj  = $hit_object->hsp;  # same as 'best'\n           : $hspObj  = $hit_object->hsp('best');\n           : $hspObj  = $hit_object->hsp('worst');\n Returns   : Object reference for a L<Bio::Search::HSP::HSPI> object.\n Argument  : String (or no argument).\n           :   No argument (default) = highest scoring HSP (same as 'best').\n           :   'best'  = highest scoring HSP.\n           :   'worst' = lowest scoring HSP.\n Throws    : Exception if an unrecognized argument is used.\n\nSee Also   : L<hsps()|hsps>, L<num_hsps>()\n\n\nsub hsp {\n    shift->throw_not_implemented;\n}\n\n=head2 logical_length\n\n Usage     : $hit_object->logical_length( [seq_type] );\n           : (mostly intended for internal use).\n Purpose   : Get the logical length of the hit sequence.\n           : If the Blast is a TBLASTN or TBLASTX, the returned length \n           : is the length of the would-be amino acid sequence (length/3).\n           : For all other BLAST flavors, this function is the same as length().\n Example   : $len    = $hit_object->logical_length();\n Returns   : Integer \n Argument  : seq_type = 'query' or 'hit' or 'sbjct' (default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  : This is important for functions like frac_aligned_query()\n           : which need to operate in amino acid coordinate space when dealing\n           : with [T]BLAST[NX] type reports.\n\nSee Also   : L<length()|length>, L<frac_aligned_query()|frac_aligned_query>,\n             L<frac_aligned_hit()|frac_aligned_hit>\n\n\nsub logical_length {\n    my ($self, $type) = @_;\n    $type ||= 'query';\n    $type = lc($type);\n\t$type = 'hit' if $type eq 'sbjct';\n    if ($type eq 'query') {\n        return $self->get_field('query_length');\n    }\n    elsif ($type eq 'hit') {\n        return $self->get_field('length');\n    }\n}\n\n=head2 rank\n\n Title   : rank\n Usage   : $obj->rank($newval)\n Function: Get/Set the rank of this Hit in the Query search list\n           i.e. this is the Nth hit for a specific query\n Returns : value of rank\n Args    : newvalue (optional)\n\n\nsub rank {\n    return shift->get_field('rank');\n}\n\n=head2 each_accession_number\n\n Title   : each_accession_number\n Usage   : $obj->each_accession_number\n Function: Get each accession number listed in the description of the hit.\n           If there are no alternatives, then only the primary accession will \n           be given (if there is one).\n Returns : list of all accession numbers in the description\n Args    : none\n\n\nsub each_accession_number {\n    my $self = shift;\n    my $accession = $self->get_field('accession') if $self->has_field('accession');\n    my $desc = $self->get_field('description') if $self->has_field('description');\n    return unless $accession || $desc;\n    \n    my @accnums;\n    push (@accnums, $accession) if $accession;\n    \n    if (defined $desc) { \n        while ($desc =~ /(\\b\\S+\\|\\S*\\|\\S*\\s?)/g) {\n            my $id = $1;\n            my $acc;\n            if ($id =~ /(?:gb|emb|dbj|sp|pdb|bbs|ref|tp[gde])\\|(.*)\\|(?:.*)/) {\n                ($acc) = split /\\./, $1; \n            }\n            elsif ($id =~ /(?:pir|prf|pat|gnl)\\|(?:.*)\\|(.*)/) {\n                ($acc) = split /\\./, $1;  \n            }\n            elsif ($id =~ /(?:gim|gi|bbm|bbs|lcl)\\|(?:\\d*)/) {\n                $acc = $id;\n            }\n            elsif ($id =~ /(?:oth)\\|(.*)\\|(?:.*)\\|(?:.*)/ ) { # discontinued...\n                $acc = $1;\n            }\n            else {\n                $acc = $id;\n            }\n            push(@accnums, $acc);\n        }\n    }\n    return @accnums;\n}\n\n=head2 tiled_hsps\n\n Usage     : $hit_object->tiled_hsps( [integer] );\n Purpose   : Gets/Sets an indicator for whether or not the HSPs in this Hit \n           : have been tiled.\n Example   : $hit_object->tiled_hsps(1);\n           : if( $hit_object->tiled_hsps ) { # do something }\n Returns   : Boolean (1 or 0) \n Argument  : integer (optional)\n Throws    : n/a\n Status    : Deprecated\n Notes     : This value is not used for anything\n\n\nsub tiled_hsps {\n    my $self = shift;\n    if (@_) { $self->{_hsps_are_tiled} = shift }\n    return $self->{_hsps_are_tiled} || 0;\n}\n\n=head2 strand\n\n Usage     : $sbjct->strand( [seq_type] );\n Purpose   : Gets the strand(s) for the query, sbjct, or both sequences\n           : in the best HSP of the BlastHit object after HSP tiling.\n           : Only valid for BLASTN, TBLASTX, BLASTX-query, TBLASTN-hit.\n Example   : $qstrand = $sbjct->strand('query');\n           : $sstrand = $sbjct->strand('hit');\n           : ($qstrand, $sstrand) = $sbjct->strand();\n Returns   : scalar context: integer '1', '-1', or '0'\n           : array context without args: list of two strings (queryStrand, sbjctStrand)\n           : Array context can be \"induced\" by providing an argument of 'list' or 'array'.\n Argument  : In scalar context: seq_type = 'query' or 'hit' or 'sbjct' (default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n           : If you don't want the tiled data, iterate through each HSP\n           : calling strand() on each (use hsps() to get all HSPs).\n           :\n           : Formerly (prior to 10/21/02), this method would return the\n           : string \"-1/1\" for hits with HSPs on both strands.\n           : However, now that strand and frame is properly being accounted\n           : for during HSP tiling, it makes more sense for strand()\n           : to return the strand data for the best HSP after tiling.\n           :\n           : If you really want to know about hits on opposite strands,\n           : you should be iterating through the HSPs using methods on the\n           : HSP objects.\n           :\n           : A possible use case where knowing whether a hit has HSPs \n           : on both strands would be when filtering via SearchIO for hits with \n           : this property. However, in this case it would be better to have a\n           : dedicated method such as $hit->hsps_on_both_strands(). Similarly\n           : for frame. This could be provided if there is interest.\n\nSee Also   : L<Bio::Search::HSP::HSPI::strand>()\n\n\nsub strand {\n    shift->throw_not_implemented;\n}\n\n=head2 frame\n\n Usage     : $hit_object->frame();\n Purpose   : Gets the reading frame for the best HSP after HSP tiling.\n           : This is only valid for BLASTX and TBLASTN/X type reports.\n Example   : $frame = $hit_object->frame();\n Returns   : Integer (-2 .. +2)\n Argument  : n/a\n Throws    : Exception if HSPs have not been set.\n Comments  : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n           : If you don't want the tiled data, iterate through each HSP\n           : calling frame() on each (use hsps() to get all HSPs).\n\nSee Also   : L<hsps()|hsps>\n\n\nsub frame {\n    shift->throw_not_implemented;\n}\n\n=head2 length_aln\n\n Usage     : $hit_object->length_aln( [seq_type] );\n Purpose   : Get the total length of the aligned region for query or sbjct seq.\n           : This number will include all HSPs, and excludes gaps.\n Example   : $len    = $hit_object->length_aln(); # default = query\n           : $lenAln = $hit_object->length_aln('query');\n Returns   : Integer \n Argument  : seq_Type = 'query' or 'hit' or 'sbjct' (Default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : Exception if the argument is not recognized.\n Comments  : This method will report the logical length of the alignment,\n           : meaning that for TBLAST[NX] reports, the length is reported\n           : using amino acid coordinate space (i.e., nucleotides / 3).\n\nSee Also   : L<length()|length>, L<frac_aligned_query()|frac_aligned_query>,\n             L<frac_aligned_hit()|frac_aligned_hit>, L<gaps()|gaps>,\n             L<Bio::Search::SearchUtils::tile_hsps()|Bio::Search::SearchUtils>,\n             L<Bio::Search::HSP::BlastHSP::length()|Bio::Search::HSP::BlastHSP>\n\n\nsub length_aln {\n    my ($self, $seqType) = @_;\n    $seqType ||= 'query';\n    $seqType = 'hit' if $seqType eq 'sbjct';\n    \n\tmy %non_gaps = map { $_, 1 } $self->seq_inds($seqType, 'conserved'),\n\t\t\t\t\t\t\t     $self->seq_inds($seqType, 'no_match');\n\treturn scalar(keys %non_gaps);\n}\n\n=head2 gaps\n\n Usage     : $hit_object->gaps( [seq_type] );\n Purpose   : Get the number of gaps in the aligned query, hit, or both sequences.\n           : Data is summed across all HSPs.\n Example   : $qgaps = $hit_object->gaps('query');\n           : $hgaps = $hit_object->gaps('hit');\n           : $tgaps = $hit_object->gaps();    # default = total (query + hit)\n Returns   : scalar context: integer\n           : array context without args: two-element list of integers  \n           :    (queryGaps, hitGaps)\n           : Array context can be forced by providing an argument of 'list' or\n\t\t   : 'array'.\n           :\n           : CAUTION: Calling this method within printf or sprintf is arrray\n\t\t   : context.\n           : So this function may not give you what you expect. For example:\n           :          printf \"Total gaps: %d\", $hit->gaps();\n           : Actually returns a two-element array, so what gets printed \n           : is the number of gaps in the query, not the total\n           :\n Argument  : seq_type: 'query' | 'hit' or 'sbjct' | 'total' | 'list'\n           : (default = 'total') ('sbjct' is synonymous with 'hit')\n Comments  : If you need data for each HSP, use hsps() and then interate\n           : through each HSP object.\n\n\nsub gaps {\n    my ($self, $seqType) = @_;\n    \n    $seqType ||= (wantarray ? 'list' : 'total');\n    $seqType = 'hit' if $seqType eq 'sbjct';\n    \n    if ($seqType =~ /list|array/i) {\n        return (scalar($self->seq_inds('query', 'gap')), scalar($self->seq_inds('hit', 'gap')));\n    }\n    elsif ($seqType eq 'total') {\n        return (scalar($self->seq_inds('query', 'gap')) + scalar($self->seq_inds('hit', 'gap'))) || 0;\n    }\n    else {\n        return scalar($self->seq_inds($seqType, 'gap')) || 0;\n    }\n}\n\n=head2 matches\n\n Usage     : $hit_object->matches( [class] );\n Purpose   : Get the total number of identical or conserved matches \n           : (or both) across all HSPs.\n           : (Note: 'conservative' matches are indicated as 'positives' \n           :         in BLAST reports.)\n Example   : ($id,$cons) = $hit_object->matches(); # no argument\n           : $id = $hit_object->matches('id');\n           : $cons = $hit_object->matches('cons'); \n Returns   : Integer or a 2-element array of integers \n Argument  : [0] class = 'id' | 'cons' OR none.\n           : [1] seq_type  = 'query' or 'hit' or 'sbjct'  (default = 'query')\n           :                 ('sbjct' is synonymous with 'hit')\n           : If no argument is provided, both identical and conservative \n           : numbers are returned in a two element list.\n           : (Other terms can be used to refer to the conservative\n           :  matches, e.g., 'positive'. All that is checked is whether or\n           :  not the supplied string starts with 'id'. If not, the \n           : conservative matches are returned.)\n\n\nsub matches {\n    my ($self, $class, $seqType) = @_;\n    \n\t# no query/hit choice? The answer differs depending on sequence, since\n\t# hsps could overlap on one sequence and not the other. Added an option,\n\t# but otherwise will assume 'hit'\n\t$seqType ||= 'hit';\n\t$seqType = 'hit' if $seqType eq 'sbjct';\n\t\n\tunless (exists $self->{_id_matches}) {\n\t\t$self->{_id_matches}->{hit} = scalar($self->seq_inds('hit', 'identical'));\n\t\t$self->{_id_matches}->{query} = scalar($self->seq_inds('query', 'identical'));\n\t}\n\tunless (exists $self->{_con_matches}) {\n\t\tforeach my $type ('hit', 'query') {\n\t\t\t# 'conserved-not-identical' can give us 'identical' matches if hsps\n\t\t\t# overlapped so have to get the difference\n\t\t\tmy %identicals = map { $_ => 1 } $self->seq_inds($type, 'identical');\n\t\t\tmy @conserved = $self->seq_inds($type, 'conserved-not-identical');\n\t\t\t\n\t\t\tmy $real_conserved;\n\t\t\tforeach (@conserved) {\n\t\t\t\tunless (exists $identicals{$_}) {\n\t\t\t\t\t$real_conserved++;\n\t\t\t\t}\n\t\t\t}\n\t\t\t$self->{_con_matches}->{$type} = $real_conserved;\n\t\t}\n\t}\n\t\n\t\n    unless ($class) {\n        return ($self->{_id_matches}->{$seqType}, $self->{_con_matches}->{$seqType});\n    }\n    else {\n\t\tif ($class =~ /^id/i) { \n            return $self->{_id_matches}->{$seqType};\n        }\n        else {\n            return $self->{_con_matches}->{$seqType};\n        }\n    }\n    return;\n}\n\n=head2 start\n\n Usage     : $sbjct->start( [seq_type] );\n Purpose   : Gets the start coordinate for the query, sbjct, or both sequences\n           : in the object. If there is more than one HSP, the lowest start\n           : value of all HSPs is returned.\n Example   : $qbeg = $sbjct->start('query');\n           : $sbeg = $sbjct->start('hit');\n           : ($qbeg, $sbeg) = $sbjct->start();\n Returns   : scalar context: integer \n           : array context without args: list of two integers (queryStart,\n           : sbjctStart)\n           : Array context can be \"induced\" by providing an argument of 'list'\n           : or 'array'.\n Argument  : 'query' or 'hit' or 'sbjct' (default = 'query') ('sbjct' is\n             synonymous with 'hit')\n\n\nsub start {\n    my ($self, $seqType) = @_;\n    \n    unless ($self->get_field('num_hsps')) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        return;\n    }\n    \n    $seqType ||= (wantarray ? 'list' : 'query');\n    $seqType = 'hit' if $seqType eq 'sbjct';\n    \n    if ($seqType =~ /list|array/i) {\n\t    return ($self->get_field('query_start'), $self->get_field('hit_start'));\n\t}\n    elsif ($seqType eq 'hit') {\n        return $self->get_field('hit_start');\n\t}\n    elsif ($seqType eq 'query') {\n        return $self->get_field('query_start');\n    }\n    else {\n        $self->throw(\"Unknown sequence type '$seqType'\");\n    }\n}\n\n=head2 end\n\n Usage     : $sbjct->end( [seq_type] );\n Purpose   : Gets the end coordinate for the query, sbjct, or both sequences\n           : in the object. If there is more than one HSP, the largest end\n           : value of all HSPs is returned.\n Example   : $qend = $sbjct->end('query');\n           : $send = $sbjct->end('hit');\n           : ($qend, $send) = $sbjct->end();\n Returns   : scalar context: integer\n           : array context without args: list of two integers \n           : (queryEnd, sbjctEnd)\n           : Array context can be \"induced\" by providing an argument \n           : of 'list' or 'array'.\n Argument  : 'query' or 'hit' or 'sbjct' (default = 'query') ('sbjct' is\n             synonymous with 'hit')\n\n\nsub end {\n    my ($self, $seqType) = @_;\n    \n    unless ($self->get_field('num_hsps')) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        return;\n    }\n    \n    $seqType ||= (wantarray ? 'list' : 'query');\n    $seqType = 'hit' if $seqType eq 'sbjct';\n    \n    if ($seqType =~ /list|array/i) {\n\t    return ($self->get_field('query_end'), $self->get_field('hit_end'));\n\t}\n    elsif ($seqType eq 'hit') {\n        return $self->get_field('hit_end');\n\t}\n    elsif ($seqType eq 'query') {\n        return $self->get_field('query_end');\n    }\n    else {\n        $self->throw(\"Unknown sequence type '$seqType'\");\n    }\n}\n\n=head2 range\n\n Usage     : $sbjct->range( [seq_type] );\n Purpose   : Gets the (start, end) coordinates for the query or sbjct sequence\n           : in the HSP alignment.\n Example   : ($qbeg, $qend) = $sbjct->range('query');\n           : ($sbeg, $send) = $sbjct->range('hit');\n Returns   : Two-element array of integers \n Argument  : seq_type = string, 'query' or 'hit' or 'sbjct'  (default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n\nSee Also   : L<start()|start>, L<end()|end>\n\n\nsub range {\n    my ($self, $seqType) = @_;\n    $seqType ||= 'query';\n    $seqType = 'hit' if $seqType eq 'sbjct';\n    return ($self->start($seqType), $self->end($seqType));\n}\n\n=head2 frac_identical\n\n Usage     : $hit_object->frac_identical( [seq_type] );\n Purpose   : Get the overall fraction of identical positions across all HSPs.\n           : The number refers to only the aligned regions and does not\n           : account for unaligned regions in between the HSPs, if any.\n Example   : $frac_iden = $hit_object->frac_identical('query');\n Returns   : Float (2-decimal precision, e.g., 0.75).\n Argument  : seq_type: 'query' | 'hit' or 'sbjct' | 'total'\n           : default = 'query' (but see comments below).\n           : ('sbjct' is synonymous with 'hit')\n\n\nsub frac_identical {\n    my ($self, $seqType) = @_;\n    $seqType ||= 'query';\n    $seqType = lc($seqType);\n    $seqType = 'hit' if $seqType eq 'sbjct';\n    \n    my $ident = $self->matches('id', $seqType);\n    my $total = $self->length_aln($seqType);\n    my $ratio = $ident / $total;\n    my $ratio_rounded = sprintf( \"%.3f\", $ratio);\n    \n    # Round down if normal rounding yields 1 (just like blast)\n    $ratio_rounded = 0.999 if (($ratio_rounded == 1) && ($ratio < 1));\n    return $ratio_rounded;\n}\n\n=head2 frac_conserved\n\n Usage     : $hit_object->frac_conserved( [seq_type] );\n Purpose   : Get the overall fraction of conserved positions across all HSPs.\n           : The number refers to only the aligned regions and does not\n           : account for unaligned regions in between the HSPs, if any.\n Example   : $frac_cons = $hit_object->frac_conserved('hit');\n Returns   : Float (2-decimal precision, e.g., 0.75).\n Argument  : seq_type: 'query' | 'hit' or 'sbjct' | 'total'\n           : default = 'query' (but see comments below).\n           : ('sbjct' is synonymous with 'hit')","parameters":[{"label":"$self"},{"label":"$seqType"}],"label":"frac_conserved($self,$seqType)"},"detail":"($self,$seqType)","kind":12,"children":[{"containerName":"frac_conserved","name":"$self","definition":"my","localvar":"my","kind":13,"line":1050},{"name":"$seqType","containerName":"frac_conserved","kind":13,"line":1050},{"name":"$seqType","containerName":"frac_conserved","line":1051,"kind":13},{"name":"$seqType","containerName":"frac_conserved","line":1052,"kind":13},{"line":1052,"kind":13,"containerName":"frac_conserved","name":"$seqType"},{"kind":13,"line":1053,"name":"$seqType","containerName":"frac_conserved"},{"line":1053,"kind":13,"name":"$seqType","containerName":"frac_conserved"},{"containerName":"frac_conserved","definition":"my","name":"$consv","localvar":"my","kind":13,"line":1055},{"name":"$self","containerName":"frac_conserved","line":1055,"kind":13},{"kind":12,"line":1055,"containerName":"frac_conserved","name":"matches"},{"definition":"my","name":"$total","containerName":"frac_conserved","localvar":"my","kind":13,"line":1056},{"line":1056,"kind":13,"name":"$self","containerName":"frac_conserved"},{"name":"length_aln","containerName":"frac_conserved","line":1056,"kind":12},{"containerName":"frac_conserved","name":"$seqType","line":1056,"kind":13},{"line":1057,"kind":13,"localvar":"my","name":"$ratio","definition":"my","containerName":"frac_conserved"},{"kind":13,"line":1057,"containerName":"frac_conserved","name":"$consv"},{"containerName":"frac_conserved","name":"$total","kind":13,"line":1057},{"kind":13,"line":1058,"containerName":"frac_conserved","definition":"my","name":"$ratio_rounded","localvar":"my"},{"name":"$ratio","containerName":"frac_conserved","kind":13,"line":1058},{"line":1061,"kind":13,"containerName":"frac_conserved","name":"$ratio_rounded"},{"kind":13,"line":1061,"name":"$ratio_rounded","containerName":"frac_conserved"},{"containerName":"frac_conserved","name":"$ratio","line":1061,"kind":13},{"name":"$ratio_rounded","containerName":"frac_conserved","kind":13,"line":1062}],"line":1049},{"line":1079,"children":[{"localvar":"my","containerName":"frac_aligned_query","definition":"my","name":"$self","line":1080,"kind":13},{"line":1081,"kind":13,"name":"$self","containerName":"frac_aligned_query"},{"kind":12,"line":1081,"containerName":"frac_aligned_query","name":"length_aln"},{"containerName":"frac_aligned_query","name":"$self","line":1081,"kind":13},{"line":1081,"kind":12,"name":"logical_length","containerName":"frac_aligned_query"}],"kind":12,"range":{"start":{"character":0,"line":1079},"end":{"line":1082,"character":9999}},"containerName":"main::","definition":"sub","name":"frac_aligned_query"},{"definition":"sub","name":"frac_aligned_hit","containerName":"main::","range":{"start":{"line":1098,"character":0},"end":{"line":1101,"character":9999}},"kind":12,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"frac_aligned_hit","line":1099,"kind":13},{"line":1100,"kind":13,"name":"$self","containerName":"frac_aligned_hit"},{"name":"length_aln","containerName":"frac_aligned_hit","kind":12,"line":1100},{"kind":13,"line":1100,"containerName":"frac_aligned_hit","name":"$self"},{"kind":12,"line":1100,"name":"logical_length","containerName":"frac_aligned_hit"}],"line":1098},{"range":{"start":{"line":1116,"character":0},"end":{"line":1120,"character":9999}},"name":"num_unaligned_hit","definition":"sub","containerName":"main::","children":[{"definition":"my","name":"$self","containerName":"num_unaligned_hit","localvar":"my","kind":13,"line":1117},{"line":1119,"kind":13,"name":"$self","containerName":"num_unaligned_hit"},{"line":1119,"kind":12,"containerName":"num_unaligned_hit","name":"gaps"}],"line":1116,"kind":12},{"definition":"sub","name":"num_unaligned_query","containerName":"main::","range":{"start":{"character":0,"line":1135},"end":{"character":9999,"line":1139}},"kind":12,"children":[{"line":1136,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"num_unaligned_query"},{"kind":13,"line":1138,"containerName":"num_unaligned_query","name":"$self"},{"containerName":"num_unaligned_query","name":"gaps","kind":12,"line":1138}],"line":1135}],"version":5}