{"version":5,"vars":[{"kind":2,"line":86,"name":"vars","containerName":""},{"containerName":"","name":"base","kind":2,"line":89},{"kind":13,"line":91,"name":"@AUTOLOAD_OK","definition":"my","containerName":null,"localvar":"my"},{"containerName":null,"name":"%AUTOLOAD_OK","definition":"my","localvar":"my","kind":13,"line":93},{"name":"@AUTOLOAD_OK","containerName":null,"kind":13,"line":94},{"line":94,"kind":13,"containerName":null,"name":"@AUTOLOAD_OK"},{"kind":13,"line":94,"containerName":null,"name":"@AUTOLOAD_OK"},{"range":{"end":{"character":9999,"line":113},"start":{"character":0,"line":102}},"name":"_initialize","detail":"($self,%args)","signature":{"parameters":[{"label":"$self"},{"label":"%args"}],"documentation":"1;\n# $Id: Fasta.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Hit::Fasta\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Aaron Mackey <amackey@virginia.edu>\n#\n# Copyright Aaron Mackey\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Hit::Fasta - Hit object specific for Fasta-generated hits\n\n=head1 SYNOPSIS\n\n  # You wouldn't normally create these manually; \n  # instead they would be produced by Bio::SearchIO::fasta\n\n  use Bio::Search::Hit::Fasta;\n  my $hit = Bio::Search::Hit::Fasta->new(id=>'LBL_6321', desc=>'lipoprotein', e_val=>0.01);\n\n=head1 DESCRIPTION\n\nL<Bio::Search::Hit::HitI> objects are data structures that contain information\nabout specific hits obtained during a library search.  Some information will\nbe algorithm-specific, but others will be generally defined, such as the\nability to obtain alignment objects corresponding to each hit.\n\n=head1 SEE ALSO\n\nL<Bio::Search::Hit::HitI>,\nL<Bio::Search::Hit::GenericHit>,\nL<Bio::SearchIO::fasta>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\n to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Aaron Mackey\n\nEmail amackey-at-virginia.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n#'\n# Let the code begin...\n\npackage Bio::Search::Hit::Fasta;\n\nuse vars qw($AUTOLOAD);\nuse strict;\n\nuse base qw(Bio::Search::Hit::HitI);\n\nmy @AUTOLOAD_OK = qw(_ID _DESC _SIZE _INITN _INIT1 _OPT _ZSC _E_VAL);\n\nmy %AUTOLOAD_OK = ();\n@AUTOLOAD_OK{@AUTOLOAD_OK} = (1) x @AUTOLOAD_OK;\n\n=head2 _initialize\n\n Function: where the heavy stuff will happen when new is called","label":"_initialize($self,%args)"},"containerName":"main::","definition":"sub","line":102,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"_initialize","line":103,"kind":13},{"name":"%args","containerName":"_initialize","line":103,"kind":13},{"line":105,"kind":13,"localvar":"my","containerName":"_initialize","definition":"my","name":"$make"},{"name":"$self","containerName":"_initialize","kind":13,"line":105},{"line":105,"kind":13,"name":"%args","containerName":"_initialize"},{"line":107,"kind":13,"localvar":"my","name":"$key","definition":"my","containerName":"_initialize"},{"line":107,"kind":13,"containerName":"_initialize","name":"$val"},{"kind":13,"line":107,"name":"%args","containerName":"_initialize"},{"containerName":"_initialize","name":"$key","kind":13,"line":108},{"line":108,"kind":13,"name":"$key","containerName":"_initialize"},{"line":109,"kind":13,"containerName":"_initialize","name":"$self"},{"line":109,"kind":13,"name":"$key","containerName":"_initialize"},{"name":"$val","containerName":"_initialize","line":109,"kind":13},{"name":"$make","containerName":"_initialize","line":112,"kind":13}],"kind":12},{"name":"SUPER","containerName":"_initialize","line":105,"kind":12},{"name":"AUTOLOAD","range":{"end":{"line":132,"character":9999},"start":{"character":0,"line":121}},"containerName":"main::","definition":"sub","detail":"($self,$val)","signature":{"documentation":"1;\n# $Id: Fasta.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Hit::Fasta\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Aaron Mackey <amackey@virginia.edu>\n#\n# Copyright Aaron Mackey\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Hit::Fasta - Hit object specific for Fasta-generated hits\n\n=head1 SYNOPSIS\n\n  # You wouldn't normally create these manually; \n  # instead they would be produced by Bio::SearchIO::fasta\n\n  use Bio::Search::Hit::Fasta;\n  my $hit = Bio::Search::Hit::Fasta->new(id=>'LBL_6321', desc=>'lipoprotein', e_val=>0.01);\n\n=head1 DESCRIPTION\n\nL<Bio::Search::Hit::HitI> objects are data structures that contain information\nabout specific hits obtained during a library search.  Some information will\nbe algorithm-specific, but others will be generally defined, such as the\nability to obtain alignment objects corresponding to each hit.\n\n=head1 SEE ALSO\n\nL<Bio::Search::Hit::HitI>,\nL<Bio::Search::Hit::GenericHit>,\nL<Bio::SearchIO::fasta>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\n to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Aaron Mackey\n\nEmail amackey-at-virginia.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n#'\n# Let the code begin...\n\npackage Bio::Search::Hit::Fasta;\n\nuse vars qw($AUTOLOAD);\nuse strict;\n\nuse base qw(Bio::Search::Hit::HitI);\n\nmy @AUTOLOAD_OK = qw(_ID _DESC _SIZE _INITN _INIT1 _OPT _ZSC _E_VAL);\n\nmy %AUTOLOAD_OK = ();\n@AUTOLOAD_OK{@AUTOLOAD_OK} = (1) x @AUTOLOAD_OK;\n\n=head2 _initialize\n\n Function: where the heavy stuff will happen when new is called\n\n\nsub _initialize {\n    my($self, %args) = @_;\n\n    my $make = $self->SUPER::_initialize(%args);\n\n    while (my ($key, $val) = each %args) {\n\t$key = '_' . uc($key);\n\t$self->$key($val);\n    }\n\n    return $make; # success - we hope!\n}\n\n=head2 AUTOLOAD\n\n Function: Provide getter/setters for ID,DESC,SIZE,INITN,INIT1,OPT,ZSC,E_VAL","parameters":[{"label":"$self"},{"label":"$val"}],"label":"AUTOLOAD($self,$val)"},"kind":12,"line":121,"children":[{"definition":"my","name":"$self","containerName":"AUTOLOAD","localvar":"my","kind":13,"line":122},{"name":"$val","containerName":"AUTOLOAD","line":122,"kind":13},{"line":124,"kind":13,"name":"$AUTOLOAD","containerName":"AUTOLOAD"},{"line":126,"kind":13,"containerName":"AUTOLOAD","name":"$AUTOLOAD_OK"},{"kind":13,"line":126,"containerName":"AUTOLOAD","name":"$AUTOLOAD"},{"kind":13,"line":127,"containerName":"AUTOLOAD","name":"$self"},{"line":127,"kind":13,"name":"$AUTOLOAD","containerName":"AUTOLOAD"},{"name":"$val","containerName":"AUTOLOAD","line":127,"kind":13},{"kind":13,"line":127,"containerName":"AUTOLOAD","name":"$val"},{"containerName":"AUTOLOAD","name":"$self","line":128,"kind":13},{"name":"$AUTOLOAD","containerName":"AUTOLOAD","line":128,"kind":13},{"name":"$self","containerName":"AUTOLOAD","kind":13,"line":130},{"kind":12,"line":130,"name":"throw","containerName":"AUTOLOAD"}]}]}