{"version":5,"vars":[{"name":"base","containerName":"","kind":2,"line":88},{"name":"new","range":{"end":{"line":126,"character":9999},"start":{"line":109,"character":0}},"containerName":"main::","definition":"sub","detail":"($class,@args)","signature":{"label":"new($class,@args)","documentation":"1;\n# $Id: HmmpfamHSP.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::HSP::HmmpfamHSP\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::HSP::HmmpfamHSP - A parser and HSP object for hmmpfam hsps\n\n=head1 SYNOPSIS\n\n    # generally we use Bio::SearchIO to build these objects\n    use Bio::SearchIO;\n    my $in = Bio::SearchIO->new(-format => 'hmmer_pull',\n\t\t\t\t\t\t\t   -file   => 'result.hmmer');\n\n    while (my $result = $in->next_result) {\n\t\twhile (my $hit = $result->next_hit) {\n\t\t\tprint $hit->name, \"\\n\";\n\t\t\tprint $hit->score, \"\\n\";\n\t\t\tprint $hit->significance, \"\\n\";\n\n\t\t\twhile (my $hsp = $hit->next_hsp) {\n\t\t\t\t# process HSPI objects\n\t\t\t}\n\t\t}\n    }\n\n=head1 DESCRIPTION\n\nThis object implements a parser for hmmpfam hsp output, a program in the HMMER\npackage.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::HSP::HmmpfamHSP;\n\nuse strict;\nuse base qw(Bio::Search::HSP::PullHSPI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::HSP::HmmpfamHSP->new();\n Function: Builds a new Bio::Search::HSP::HmmpfamHSP object.\n Returns : Bio::Search::HSP::HmmpfamHSP\n Args    : -chunk  => [Bio::Root::IO, $start, $end] (required if no -parent)\n           -parent => Bio::PullParserI object (required if no -chunk)\n           -hsp_data => array ref with [rank query_start query_end hit_start\n\t\t\t\t\t\t\t\t\t\thit_end score evalue]\n\n           where the array ref provided to -chunk contains an IO object\n           for a filehandle to something representing the raw data of the\n           hsp, and $start and $end define the tell() position within the\n           filehandle that the hsp data starts and ends (optional; defaults\n           to start and end of the entire thing described by the filehandle)","parameters":[{"label":"$class"},{"label":"@args"}]},"kind":12,"line":109,"children":[{"kind":13,"line":110,"containerName":"new","name":"$class","definition":"my","localvar":"my"},{"name":"@args","containerName":"new","line":110,"kind":13},{"kind":13,"line":111,"name":"$self","definition":"my","containerName":"new","localvar":"my"},{"line":111,"kind":13,"containerName":"new","name":"$class"},{"line":111,"kind":13,"containerName":"new","name":"@args"},{"containerName":"new","name":"$self","line":113,"kind":13},{"containerName":"new","name":"_setup","line":113,"kind":12},{"line":113,"kind":13,"name":"@args","containerName":"new"},{"kind":13,"line":115,"containerName":"new","name":"$fields","definition":"my","localvar":"my"},{"containerName":"new","name":"$self","kind":13,"line":115},{"name":"_fields","containerName":"new","kind":12,"line":115},{"line":116,"kind":13,"localvar":"my","containerName":"new","definition":"my","name":"$field"},{"containerName":"new","name":"$fields","kind":13,"line":117},{"kind":13,"line":117,"containerName":"new","name":"$field"},{"localvar":"my","containerName":"new","name":"$hsp_data","definition":"my","line":120,"kind":13},{"name":"$self","containerName":"new","line":120,"kind":13},{"kind":12,"line":120,"containerName":"new","name":"_raw_hsp_data"},{"containerName":"new","name":"$hsp_data","kind":13,"line":121},{"name":"$hsp_data","containerName":"new","kind":13,"line":121},{"line":122,"kind":13,"localvar":"my","containerName":"new","name":"@hsp_data","definition":"my"},{"line":122,"kind":13,"containerName":"new","name":"$hsp_data"},{"containerName":"new","definition":"my","name":"$field","localvar":"my","kind":13,"line":123},{"kind":13,"line":124,"name":"$fields","containerName":"new"},{"kind":13,"line":124,"containerName":"new","name":"$field"},{"kind":13,"line":124,"containerName":"new","name":"@hsp_data"}]},{"kind":12,"line":111,"name":"SUPER","containerName":"new"},{"name":"$self","containerName":null,"kind":13,"line":128},{"kind":12,"line":128,"containerName":"main::","name":"_dependencies"},{"name":"query_string","kind":12,"line":128},{"name":"hit_string","line":129,"kind":12},{"line":130,"kind":12,"name":"homology_string"},{"line":131,"kind":12,"name":"hit_identical_inds"},{"line":132,"kind":12,"name":"hit_conserved_inds"},{"name":"hit_nomatch_inds","kind":12,"line":133},{"kind":12,"line":134,"name":"hit_gap_inds"},{"name":"query_identical_inds","line":135,"kind":12},{"name":"query_conserved_inds","line":136,"kind":12},{"kind":12,"line":137,"name":"query_nomatch_inds"},{"line":138,"kind":12,"name":"query_gap_inds"},{"kind":13,"line":140,"containerName":null,"name":"$self"},{"kind":12,"line":147,"children":[{"kind":13,"line":148,"definition":"my","name":"$self","containerName":"_discover_alignment","localvar":"my"},{"line":149,"kind":13,"localvar":"my","name":"$alignments_hash","definition":"my","containerName":"_discover_alignment"},{"line":149,"kind":13,"name":"$self","containerName":"_discover_alignment"},{"name":"get_field","containerName":"_discover_alignment","kind":12,"line":149},{"kind":13,"line":151,"containerName":"_discover_alignment","name":"$identifier","definition":"my","localvar":"my"},{"name":"$self","containerName":"_discover_alignment","line":151,"kind":13},{"name":"get_field","containerName":"_discover_alignment","kind":12,"line":151},{"line":151,"kind":13,"name":"$self","containerName":"_discover_alignment"},{"containerName":"_discover_alignment","name":"get_field","line":151,"kind":12},{"kind":13,"line":153,"name":"$alignments_hash","containerName":"_discover_alignment"},{"name":"$identifier","containerName":"_discover_alignment","kind":13,"line":153},{"containerName":"_discover_alignment","name":"$self","kind":13,"line":154},{"containerName":"_discover_alignment","name":"parent","line":154,"kind":12},{"kind":12,"line":154,"name":"parent","containerName":"_discover_alignment"},{"kind":12,"line":154,"containerName":"_discover_alignment","name":"_next_alignment"},{"localvar":"my","definition":"my","name":"$alignment","containerName":"_discover_alignment","line":156,"kind":13},{"kind":13,"line":156,"containerName":"_discover_alignment","name":"$alignments_hash"},{"line":156,"kind":13,"name":"$identifier","containerName":"_discover_alignment"},{"line":158,"kind":13,"containerName":"_discover_alignment","name":"$alignment"},{"localvar":"my","name":"$query_string","definition":"my","containerName":"_discover_alignment","line":163,"kind":13},{"name":"$hit_string","containerName":"_discover_alignment","line":163,"kind":13},{"name":"$homology_string","containerName":"_discover_alignment","line":163,"kind":13},{"containerName":"_discover_alignment","name":"$alignment","kind":13,"line":164},{"localvar":"my","containerName":"_discover_alignment","name":"$hi","definition":"my","line":165,"kind":13},{"line":166,"kind":13,"localvar":"my","containerName":"_discover_alignment","definition":"my","name":"$ho"},{"name":"$query_string","containerName":"_discover_alignment","line":167,"kind":13},{"kind":13,"line":169,"name":"$hi","containerName":"_discover_alignment"},{"containerName":"_discover_alignment","name":"$ho","kind":13,"line":170},{"line":170,"kind":13,"containerName":"_discover_alignment","name":"$hi"},{"containerName":"_discover_alignment","name":"$ho","kind":13,"line":170},{"line":170,"kind":13,"name":"$ho","containerName":"_discover_alignment"},{"containerName":"_discover_alignment","name":"$hi","kind":13,"line":171},{"name":"$hit_string","containerName":"_discover_alignment","kind":13,"line":173},{"line":173,"kind":13,"containerName":"_discover_alignment","name":"$hi"},{"kind":13,"line":174,"containerName":"_discover_alignment","name":"$homology_string"},{"name":"$ho","containerName":"_discover_alignment","kind":13,"line":174},{"name":"$self","containerName":"_discover_alignment","line":177,"kind":13},{"kind":12,"line":177,"name":"_fields","containerName":"_discover_alignment"},{"line":177,"kind":13,"containerName":"_discover_alignment","name":"$query_string"},{"name":"$self","containerName":"_discover_alignment","kind":13,"line":178},{"line":178,"kind":12,"containerName":"_discover_alignment","name":"_fields"},{"kind":13,"line":178,"name":"$hit_string","containerName":"_discover_alignment"},{"name":"$homology_string","containerName":"_discover_alignment","kind":13,"line":179},{"name":"$self","containerName":"_discover_alignment","line":180,"kind":13},{"kind":12,"line":180,"containerName":"_discover_alignment","name":"_fields"},{"containerName":"_discover_alignment","name":"$homology_string","line":180,"kind":13},{"line":182,"kind":13,"name":"$self","containerName":"_discover_alignment"},{"containerName":"_discover_alignment","name":"$query_string","line":182,"kind":13},{"containerName":"_discover_alignment","name":"$self","line":183,"kind":13},{"kind":13,"line":183,"name":"$hit_string","containerName":"_discover_alignment"},{"kind":13,"line":184,"name":"$self","containerName":"_discover_alignment"},{"kind":13,"line":184,"containerName":"_discover_alignment","name":"$self"},{"kind":13,"line":184,"containerName":"_discover_alignment","name":"$self"},{"kind":13,"line":187,"containerName":"_discover_alignment","name":"$self"},{"kind":12,"line":187,"containerName":"_discover_alignment","name":"_fields"}],"containerName":"main::","definition":"sub","name":"_discover_alignment","range":{"start":{"character":0,"line":147},"end":{"line":188,"character":9999}}},{"name":"query_string","line":177,"kind":12},{"kind":12,"line":178,"name":"hit_string"},{"kind":12,"line":180,"name":"homology_string"},{"kind":12,"line":182,"name":"_query_gaps"},{"name":"_hit_gaps","kind":12,"line":183},{"kind":12,"line":184,"name":"_total_gaps"},{"name":"_query_gaps","kind":12,"line":184},{"name":"_hit_gaps","kind":12,"line":184},{"name":"alignment","kind":12,"line":187},{"kind":12,"children":[{"name":"$self","definition":"my","containerName":"_discover_seq_inds","localvar":"my","kind":13,"line":192},{"containerName":"_discover_seq_inds","name":"$seqString","definition":"my","localvar":"my","kind":13,"line":193},{"name":"$qseq","containerName":"_discover_seq_inds","line":193,"kind":13},{"containerName":"_discover_seq_inds","name":"$sseq","kind":13,"line":193},{"line":193,"kind":13,"name":"$self","containerName":"_discover_seq_inds"},{"kind":12,"line":193,"name":"get_field","containerName":"_discover_seq_inds"},{"kind":13,"line":194,"name":"$self","containerName":"_discover_seq_inds"},{"name":"get_field","containerName":"_discover_seq_inds","line":194,"kind":12},{"containerName":"_discover_seq_inds","name":"$self","kind":13,"line":195},{"containerName":"_discover_seq_inds","name":"get_field","line":195,"kind":12},{"definition":"my","name":"%identicalList_query","containerName":"_discover_seq_inds","localvar":"my","kind":13,"line":200},{"kind":13,"line":201,"containerName":"_discover_seq_inds","name":"%identicalList_sbjct","definition":"my","localvar":"my"},{"line":202,"kind":13,"localvar":"my","containerName":"_discover_seq_inds","name":"%conservedList_query","definition":"my"},{"containerName":"_discover_seq_inds","name":"%conservedList_sbjct","definition":"my","localvar":"my","kind":13,"line":203},{"line":204,"kind":13,"localvar":"my","containerName":"_discover_seq_inds","definition":"my","name":"@gapList_query"},{"localvar":"my","name":"@gapList_sbjct","definition":"my","containerName":"_discover_seq_inds","line":205,"kind":13},{"line":206,"kind":13,"localvar":"my","containerName":"_discover_seq_inds","definition":"my","name":"%nomatchList_query"},{"line":207,"kind":13,"localvar":"my","name":"%nomatchList_sbjct","definition":"my","containerName":"_discover_seq_inds"},{"line":209,"kind":13,"localvar":"my","name":"$resCount_query","definition":"my","containerName":"_discover_seq_inds"},{"name":"$self","containerName":"_discover_seq_inds","kind":13,"line":209},{"name":"get_field","containerName":"_discover_seq_inds","kind":12,"line":209},{"kind":13,"line":210,"definition":"my","name":"$resCount_sbjct","containerName":"_discover_seq_inds","localvar":"my"},{"name":"$self","containerName":"_discover_seq_inds","line":210,"kind":13},{"kind":12,"line":210,"containerName":"_discover_seq_inds","name":"get_field"},{"localvar":"my","containerName":"_discover_seq_inds","name":"$mchar","definition":"my","line":212,"kind":13},{"line":212,"kind":13,"containerName":"_discover_seq_inds","name":"$schar"},{"name":"$qchar","containerName":"_discover_seq_inds","kind":13,"line":212},{"line":213,"kind":13,"containerName":"_discover_seq_inds","name":"$mchar"},{"line":213,"kind":13,"name":"$seqString","containerName":"_discover_seq_inds"},{"containerName":"_discover_seq_inds","name":"$qchar","line":214,"kind":13},{"line":214,"kind":13,"containerName":"_discover_seq_inds","name":"$schar"},{"name":"$qseq","containerName":"_discover_seq_inds","line":214,"kind":13},{"line":214,"kind":13,"containerName":"_discover_seq_inds","name":"$sseq"},{"name":"$mchar","containerName":"_discover_seq_inds","kind":13,"line":216},{"containerName":"_discover_seq_inds","name":"$mchar","kind":13,"line":216},{"kind":13,"line":216,"name":"$mchar","containerName":"_discover_seq_inds"},{"kind":13,"line":217,"name":"$conservedList_query","containerName":"_discover_seq_inds"},{"kind":13,"line":217,"name":"$resCount_query","containerName":"_discover_seq_inds"},{"line":218,"kind":13,"containerName":"_discover_seq_inds","name":"$conservedList_sbjct"},{"name":"$resCount_sbjct","containerName":"_discover_seq_inds","kind":13,"line":218},{"containerName":"_discover_seq_inds","name":"$mchar","kind":13,"line":220},{"line":221,"kind":13,"name":"$nomatchList_query","containerName":"_discover_seq_inds"},{"name":"$resCount_query","containerName":"_discover_seq_inds","kind":13,"line":221},{"kind":13,"line":222,"name":"$nomatchList_sbjct","containerName":"_discover_seq_inds"},{"kind":13,"line":222,"name":"$resCount_sbjct","containerName":"_discover_seq_inds"},{"containerName":"_discover_seq_inds","name":"$identicalList_query","kind":13,"line":225},{"name":"$resCount_query","containerName":"_discover_seq_inds","kind":13,"line":225},{"containerName":"_discover_seq_inds","name":"$identicalList_sbjct","line":226,"kind":13},{"containerName":"_discover_seq_inds","name":"$resCount_sbjct","line":226,"kind":13},{"name":"$qchar","containerName":"_discover_seq_inds","line":229,"kind":13},{"line":230,"kind":13,"name":"@gapList_query","containerName":"_discover_seq_inds"},{"name":"$resCount_query","containerName":"_discover_seq_inds","kind":13,"line":230},{"name":"$resCount_query","containerName":"_discover_seq_inds","kind":13,"line":233},{"kind":13,"line":235,"name":"$schar","containerName":"_discover_seq_inds"},{"containerName":"_discover_seq_inds","name":"@gapList_sbjct","kind":13,"line":236},{"line":236,"kind":13,"name":"$resCount_sbjct","containerName":"_discover_seq_inds"},{"kind":13,"line":239,"containerName":"_discover_seq_inds","name":"$resCount_sbjct"},{"line":243,"kind":13,"localvar":"my","containerName":"_discover_seq_inds","name":"$fields","definition":"my"},{"line":243,"kind":13,"name":"$self","containerName":"_discover_seq_inds"},{"name":"_fields","containerName":"_discover_seq_inds","kind":12,"line":243},{"kind":13,"line":244,"name":"$fields","containerName":"_discover_seq_inds"},{"containerName":"_discover_seq_inds","name":"$a","line":244,"kind":13},{"containerName":"_discover_seq_inds","name":"$b","line":244,"kind":13},{"kind":13,"line":244,"name":"%identicalList_sbjct","containerName":"_discover_seq_inds"},{"name":"$fields","containerName":"_discover_seq_inds","kind":13,"line":245},{"name":"$a","containerName":"_discover_seq_inds","kind":13,"line":245},{"name":"$b","containerName":"_discover_seq_inds","line":245,"kind":13},{"line":245,"kind":13,"containerName":"_discover_seq_inds","name":"%conservedList_sbjct"},{"containerName":"_discover_seq_inds","name":"$fields","kind":13,"line":246},{"kind":13,"line":246,"containerName":"_discover_seq_inds","name":"$a"},{"kind":13,"line":246,"containerName":"_discover_seq_inds","name":"$b"},{"containerName":"_discover_seq_inds","name":"%nomatchList_sbjct","kind":13,"line":246},{"kind":13,"line":247,"containerName":"_discover_seq_inds","name":"$fields"},{"name":"@gapList_sbjct","containerName":"_discover_seq_inds","line":247,"kind":13},{"name":"$fields","containerName":"_discover_seq_inds","kind":13,"line":248},{"kind":13,"line":248,"containerName":"_discover_seq_inds","name":"$a"},{"name":"$b","containerName":"_discover_seq_inds","line":248,"kind":13},{"kind":13,"line":248,"name":"%identicalList_query","containerName":"_discover_seq_inds"},{"line":249,"kind":13,"name":"$fields","containerName":"_discover_seq_inds"},{"name":"$a","containerName":"_discover_seq_inds","kind":13,"line":249},{"containerName":"_discover_seq_inds","name":"$b","kind":13,"line":249},{"line":249,"kind":13,"containerName":"_discover_seq_inds","name":"%conservedList_query"},{"kind":13,"line":250,"containerName":"_discover_seq_inds","name":"$fields"},{"name":"$a","containerName":"_discover_seq_inds","line":250,"kind":13},{"containerName":"_discover_seq_inds","name":"$b","kind":13,"line":250},{"containerName":"_discover_seq_inds","name":"%nomatchList_query","line":250,"kind":13},{"line":251,"kind":13,"containerName":"_discover_seq_inds","name":"$fields"},{"name":"@gapList_query","containerName":"_discover_seq_inds","kind":13,"line":251},{"kind":13,"line":253,"containerName":"_discover_seq_inds","name":"$fields"}],"line":191,"name":"_discover_seq_inds","definition":"sub","containerName":"main::","range":{"start":{"character":0,"line":191},"end":{"character":9999,"line":254}}},{"line":244,"kind":12,"name":"hit_identical_inds"},{"kind":12,"line":245,"name":"hit_conserved_inds"},{"kind":12,"line":246,"name":"hit_nomatch_inds"},{"kind":12,"line":247,"name":"hit_gap_inds"},{"name":"query_identical_inds","kind":12,"line":248},{"kind":12,"line":249,"name":"query_conserved_inds"},{"line":250,"kind":12,"name":"query_nomatch_inds"},{"name":"query_gap_inds","line":251,"kind":12},{"line":253,"kind":12,"name":"seq_inds"},{"children":[{"name":"$self","definition":"my","containerName":"query","localvar":"my","kind":13,"line":267},{"line":268,"kind":13,"containerName":"query","name":"$self"},{"name":"$self","containerName":"query","line":269,"kind":13},{"kind":13,"line":270,"containerName":"query","name":"$self"},{"name":"primary_tag","containerName":"query","line":270,"kind":12},{"containerName":"query","name":"$self","line":271,"kind":13},{"line":271,"kind":12,"name":"get_field","containerName":"query"},{"name":"$self","containerName":"query","kind":13,"line":272},{"line":272,"kind":12,"name":"get_field","containerName":"query"},{"containerName":"query","name":"$self","kind":13,"line":273},{"name":"get_field","containerName":"query","line":273,"kind":12},{"containerName":"query","name":"$self","kind":13,"line":274},{"kind":12,"line":274,"name":"get_field","containerName":"query"},{"kind":13,"line":276,"name":"$self","containerName":"query"},{"name":"get_field","containerName":"query","line":276,"kind":12},{"name":"$self","containerName":"query","kind":13,"line":278},{"name":"get_field","containerName":"query","kind":12,"line":278},{"containerName":"query","name":"$self","line":279,"kind":13},{"kind":12,"line":279,"containerName":"query","name":"get_field"},{"kind":13,"line":281,"containerName":"query","name":"$self"},{"name":"$self","containerName":"query","kind":13,"line":283}],"line":266,"kind":12,"range":{"end":{"line":284,"character":9999},"start":{"character":0,"line":266}},"name":"query","definition":"sub","containerName":"main::"},{"name":"_created_query","kind":12,"line":268},{"kind":12,"line":269,"containerName":"query","name":"SUPER"},{"name":"Bio","containerName":"SeqFeature::Similarity","line":270,"kind":12},{"line":281,"kind":12,"name":"_created_query"},{"name":"SUPER","containerName":"query","kind":12,"line":283},{"kind":12,"children":[{"containerName":"hit","name":"$self","definition":"my","localvar":"my","kind":13,"line":297},{"kind":13,"line":298,"containerName":"hit","name":"$self"},{"kind":13,"line":301,"definition":"my","name":"$verbose","containerName":"hit","localvar":"my"},{"name":"$self","containerName":"hit","line":301,"kind":13},{"name":"parent","containerName":"hit","line":301,"kind":12},{"kind":12,"line":301,"containerName":"hit","name":"parent"},{"containerName":"hit","name":"parent","line":301,"kind":12},{"containerName":"hit","name":"verbose","kind":12,"line":301},{"kind":13,"line":302,"containerName":"hit","name":"$self"},{"line":302,"kind":12,"name":"parent","containerName":"hit"},{"name":"parent","containerName":"hit","kind":12,"line":302},{"line":302,"kind":12,"containerName":"hit","name":"parent"},{"name":"verbose","containerName":"hit","line":302,"kind":12},{"localvar":"my","name":"$seq_length","definition":"my","containerName":"hit","line":303,"kind":13},{"kind":13,"line":303,"name":"$self","containerName":"hit"},{"kind":12,"line":303,"name":"get_field","containerName":"hit"},{"containerName":"hit","name":"$self","kind":13,"line":304},{"line":304,"kind":12,"containerName":"hit","name":"parent"},{"containerName":"hit","name":"parent","line":304,"kind":12},{"line":304,"kind":12,"containerName":"hit","name":"parent"},{"containerName":"hit","name":"verbose","kind":12,"line":304},{"kind":13,"line":304,"name":"$verbose","containerName":"hit"},{"name":"$self","containerName":"hit","kind":13,"line":306},{"containerName":"hit","name":"$self","kind":13,"line":307},{"containerName":"hit","name":"primary_tag","line":307,"kind":12},{"kind":13,"line":308,"containerName":"hit","name":"$self"},{"line":308,"kind":12,"name":"get_field","containerName":"hit"},{"containerName":"hit","name":"$self","kind":13,"line":309},{"containerName":"hit","name":"get_field","line":309,"kind":12},{"containerName":"hit","name":"$self","line":310,"kind":13},{"line":310,"kind":12,"containerName":"hit","name":"get_field"},{"kind":13,"line":311,"containerName":"hit","name":"$self"},{"kind":12,"line":311,"name":"get_field","containerName":"hit"},{"kind":13,"line":313,"name":"$self","containerName":"hit"},{"kind":12,"line":313,"name":"get_field","containerName":"hit"},{"line":314,"kind":13,"containerName":"hit","name":"$seq_length"},{"name":"$seq_length","containerName":"hit","kind":13,"line":314},{"line":315,"kind":13,"containerName":"hit","name":"$self"},{"line":315,"kind":12,"name":"get_field","containerName":"hit"},{"line":316,"kind":13,"containerName":"hit","name":"$self"},{"name":"get_field","containerName":"hit","kind":12,"line":316},{"kind":13,"line":318,"name":"$self","containerName":"hit"},{"line":320,"kind":13,"containerName":"hit","name":"$self"}],"line":296,"name":"hit","definition":"sub","containerName":"main::","range":{"end":{"line":321,"character":9999},"start":{"line":296,"character":0}}},{"name":"_created_hit","line":298,"kind":12},{"line":306,"kind":12,"containerName":"hit","name":"SUPER"},{"line":307,"kind":12,"name":"Bio","containerName":"SeqFeature::Similarity"},{"name":"_created_hit","kind":12,"line":318},{"containerName":"hit","name":"SUPER","line":320,"kind":12},{"range":{"start":{"line":336,"character":0},"end":{"line":346,"character":9999}},"name":"gaps","line":336,"children":[{"line":337,"kind":13,"localvar":"my","containerName":"gaps","definition":"my","name":"$self"},{"kind":13,"line":337,"containerName":"gaps","name":"$type"},{"line":339,"kind":13,"containerName":"gaps","name":"$type"},{"name":"$type","containerName":"gaps","line":339,"kind":13},{"kind":13,"line":339,"containerName":"gaps","name":"$type"},{"kind":13,"line":340,"name":"$type","containerName":"gaps"},{"containerName":"gaps","name":"$type","kind":13,"line":340},{"containerName":"gaps","name":"$type","kind":13,"line":340},{"line":340,"kind":13,"name":"$type","containerName":"gaps"},{"containerName":"gaps","name":"$type","line":341,"kind":13},{"kind":13,"line":341,"name":"$type","containerName":"gaps"},{"containerName":"gaps","name":"$self","line":343,"kind":13},{"kind":12,"line":343,"containerName":"gaps","name":"get_field"},{"containerName":"gaps","name":"$self","line":345,"kind":13},{"name":"$type","containerName":"gaps","kind":13,"line":345}],"kind":12,"detail":"($self,$type)","signature":{"parameters":[{"label":"$self"},{"label":"$type"}],"documentation":"1;\n# $Id: HmmpfamHSP.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::HSP::HmmpfamHSP\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::HSP::HmmpfamHSP - A parser and HSP object for hmmpfam hsps\n\n=head1 SYNOPSIS\n\n    # generally we use Bio::SearchIO to build these objects\n    use Bio::SearchIO;\n    my $in = Bio::SearchIO->new(-format => 'hmmer_pull',\n\t\t\t\t\t\t\t   -file   => 'result.hmmer');\n\n    while (my $result = $in->next_result) {\n\t\twhile (my $hit = $result->next_hit) {\n\t\t\tprint $hit->name, \"\\n\";\n\t\t\tprint $hit->score, \"\\n\";\n\t\t\tprint $hit->significance, \"\\n\";\n\n\t\t\twhile (my $hsp = $hit->next_hsp) {\n\t\t\t\t# process HSPI objects\n\t\t\t}\n\t\t}\n    }\n\n=head1 DESCRIPTION\n\nThis object implements a parser for hmmpfam hsp output, a program in the HMMER\npackage.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::HSP::HmmpfamHSP;\n\nuse strict;\nuse base qw(Bio::Search::HSP::PullHSPI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::HSP::HmmpfamHSP->new();\n Function: Builds a new Bio::Search::HSP::HmmpfamHSP object.\n Returns : Bio::Search::HSP::HmmpfamHSP\n Args    : -chunk  => [Bio::Root::IO, $start, $end] (required if no -parent)\n           -parent => Bio::PullParserI object (required if no -chunk)\n           -hsp_data => array ref with [rank query_start query_end hit_start\n\t\t\t\t\t\t\t\t\t\thit_end score evalue]\n\n           where the array ref provided to -chunk contains an IO object\n           for a filehandle to something representing the raw data of the\n           hsp, and $start and $end define the tell() position within the\n           filehandle that the hsp data starts and ends (optional; defaults\n           to start and end of the entire thing described by the filehandle)\n\n\nsub new {\n    my ($class, @args) = @_;\n\tmy $self = $class->SUPER::new(@args);\n\t\n\t$self->_setup(@args);\n\t\n\tmy $fields = $self->_fields;\n\tforeach my $field (qw( alignment )) {\n\t\t$fields->{$field} = undef;\n\t}\n\t\n\tmy $hsp_data = $self->_raw_hsp_data;\n\tif ($hsp_data && ref($hsp_data) eq 'ARRAY') {\n\t\tmy @hsp_data = @{$hsp_data}; # don't alter the reference\n\t\tforeach my $field (qw(rank query_start query_end hit_start hit_end score evalue)) {\n\t\t\t$fields->{$field} = shift(@hsp_data);\n\t\t}\n\t}\n\t\n\t$self->_dependencies( { ( query_string => 'alignment',\n                              hit_string => 'alignment',\n                              homology_string => 'alignment',\n                              hit_identical_inds => 'seq_inds',\n\t\t\t\t\t\t\t  hit_conserved_inds => 'seq_inds',\n\t\t\t\t\t\t\t  hit_nomatch_inds => 'seq_inds',\n                              hit_gap_inds => 'seq_inds',\n                              query_identical_inds => 'seq_inds',\n\t\t\t\t\t\t\t  query_conserved_inds => 'seq_inds',\n\t\t\t\t\t\t\t  query_nomatch_inds => 'seq_inds',\n\t\t\t\t\t\t\t  query_gap_inds => 'seq_inds' ) } );\n\t\n    return $self;\n}\n\n#\n# PullParserI discovery methods so we can answer all HitI questions\n#\n\nsub _discover_alignment {\n    my $self = shift;\n    my $alignments_hash = $self->get_field('alignments');\n\t\n    my $identifier = $self->get_field('name').'~~~~'.$self->get_field('rank');\n\t\n    while (! defined $alignments_hash->{$identifier}) {\n\t\tlast unless $self->parent->parent->_next_alignment;\n    }\n    my $alignment = $alignments_hash->{$identifier};\n\t\n    if ($alignment) {\n\t\t# work out query, hit and homology strings, and some stats\n        # (quicker to do this all at once instead of each method working on\n        # $alignment string itself)\n        \n        my ($query_string, $hit_string, $homology_string);\n        while ($alignment =~ /\\s+(\\S+)\\n\\s+(\\S.+)\\n\\s+\\S+\\s+\\d+\\s+(\\S+)\\s+\\d/gm) {\n            my $hi = $1;\n            my $ho = $2;\n            $query_string .= $3;\n            \n            $hi =~ s/\\*\\-\\>//;\n            $ho = ' 'x(length($hi) - length($ho)).$ho;\n\t\t\t$hi =~ s/\\<\\-\\*//;\n            \n            $hit_string .= $hi;\n            $homology_string .= $ho;\n        }\n        \n        $self->_fields->{query_string} = $query_string;\n        $self->_fields->{hit_string} = $hit_string;\n        $homology_string =~ s/   $//;\n        $self->_fields->{homology_string} = $homology_string;\n        \n        ($self->{_query_gaps}) = $query_string =~ tr/-//;\n        ($self->{_hit_gaps}) = $hit_string =~ tr/.//;\n        ($self->{_total_gaps}) = $self->{_query_gaps} + $self->{_hit_gaps};\n    }\n    \n    $self->_fields->{alignment} = 1; # stop this method being called again\n}\n\n# seq_inds related methods, all just need seq_inds field to have been gotten\nsub _discover_seq_inds {\n    my $self = shift;\n    my ($seqString, $qseq, $sseq) = ( $self->get_field('homology_string'),\n                                      $self->get_field('query_string'),\n                                      $self->get_field('hit_string') );\n    \n    # (code largely lifted from GenericHSP)\n    \n    # Using hashes to avoid saving duplicate residue numbers.\n    my %identicalList_query = ();\n    my %identicalList_sbjct = ();\n    my %conservedList_query = ();\n    my %conservedList_sbjct = ();\n    my @gapList_query = ();\n    my @gapList_sbjct = ();\n    my %nomatchList_query = ();\n    my %nomatchList_sbjct = ();\n    \n    my $resCount_query = $self->get_field('query_end');\n    my $resCount_sbjct = $self->get_field('hit_end');\n    \n    my ($mchar, $schar, $qchar);\n    while ($mchar = chop($seqString) ) {\n        ($qchar, $schar) = (chop($qseq), chop($sseq));\n        \n        if ($mchar eq '+' || $mchar eq '.' || $mchar eq ':') { \n            $conservedList_query{ $resCount_query } = 1; \n            $conservedList_sbjct{ $resCount_sbjct } = 1;\n        }\n        elsif ($mchar eq ' ') { \n            $nomatchList_query{ $resCount_query } = 1;\n            $nomatchList_sbjct{ $resCount_sbjct } = 1;\n        }\n        else { \n            $identicalList_query{ $resCount_query } = 1; \n            $identicalList_sbjct{ $resCount_sbjct } = 1;\n        }\n        \n        if ($qchar eq '-') {\n            push(@gapList_query, $resCount_query);\n        }\n        else { \t    \n            $resCount_query -= 1;\n        }\n        if ($schar eq '.') {\n            push(@gapList_sbjct, $resCount_sbjct);\n        }\n        else { \t    \n            $resCount_sbjct -= 1;\n        }\n    }\n    \n    my $fields = $self->_fields;\n    $fields->{hit_identical_inds} = [ sort { $a <=> $b } keys %identicalList_sbjct ];\n    $fields->{hit_conserved_inds} = [ sort { $a <=> $b } keys %conservedList_sbjct ];\n    $fields->{hit_nomatch_inds} = [ sort { $a <=> $b } keys %nomatchList_sbjct ];\n    $fields->{hit_gap_inds} = [ reverse @gapList_sbjct ];\n    $fields->{query_identical_inds} = [ sort { $a <=> $b } keys %identicalList_query ];\n    $fields->{query_conserved_inds} = [ sort { $a <=> $b } keys %conservedList_query ];\n    $fields->{query_nomatch_inds} = [ sort { $a <=> $b } keys %nomatchList_query ];\n    $fields->{query_gap_inds} = [ reverse @gapList_query ];\n    \n    $fields->{seq_inds} = 1;\n}\n\n=head2 query\n\n Title   : query\n Usage   : my $query = $hsp->query\n Function: Returns a SeqFeature representing the query in the HSP\n Returns : L<Bio::SeqFeature::Similarity>\n Args    : none\n\n\nsub query {\n    my $self = shift;\n    unless ($self->{_created_query}) {\n        $self->SUPER::query( new  Bio::SeqFeature::Similarity\n                  ('-primary'  => $self->primary_tag,\n                   '-start'    => $self->get_field('query_start'),\n                   '-end'      => $self->get_field('query_end'),\n                   '-expect'   => $self->get_field('evalue'),\n                   '-score'    => $self->get_field('score'),\n                   '-strand'   => 1,\n                   '-seq_id'   => $self->get_field('query_name'),\n                   #'-seqlength'=> $self->get_field('query_length'),  (not known)\n                   '-source'   => $self->get_field('algorithm'),\n                   '-seqdesc'  => $self->get_field('query_description')\n                   ) );\n\t\t$self->{_created_query} = 1;\n    }\n    return $self->SUPER::query(@_);\n}\n\n=head2 hit\n\n Title   : hit\n Usage   : my $hit = $hsp->hit\n Function: Returns a SeqFeature representing the hit in the HSP\n Returns : L<Bio::SeqFeature::Similarity>\n Args    : [optional] new value to set\n\n\nsub hit {\n    my $self = shift;\n    unless ($self->{_created_hit}) {\n\t\t# the full length isn't always known (given in the report), but don't\n\t\t# warn about the missing info all the time\n\t\tmy $verbose = $self->parent->parent->parent->verbose;\n\t\t$self->parent->parent->parent->verbose(-1);\n\t\tmy $seq_length = $self->get_field('length');\n\t\t$self->parent->parent->parent->verbose($verbose);\n\t\t\n        $self->SUPER::hit( new  Bio::SeqFeature::Similarity\n                  ('-primary'  => $self->primary_tag,\n                   '-start'    => $self->get_field('hit_start'),\n                   '-end'      => $self->get_field('hit_end'),\n                   '-expect'   => $self->get_field('evalue'),\n                   '-score'    => $self->get_field('score'),\n                   '-strand'   => 1,\n                   '-seq_id'   => $self->get_field('name'),\n                   $seq_length ? ('-seqlength' => $seq_length) : (),\n                   '-source'   => $self->get_field('algorithm'),\n                   '-seqdesc'  => $self->get_field('description')\n                   ) );\n\t\t$self->{_created_hit} = 1;\n    }\n    return $self->SUPER::hit(@_);\n}\n\n=head2 gaps\n\n Title    : gaps\n Usage    : my $gaps = $hsp->gaps( ['query'|'hit'|'total'] );\n Function : Get the number of gaps in the query, hit, or total alignment.\n Returns  : Integer, number of gaps or 0 if none\n Args     : 'query' = num conserved / length of query seq (without gaps)\n            'hit'   = num conserved / length of hit seq (without gaps)\n            'total' = num conserved / length of alignment (with gaps)\n            default = 'total' ","label":"gaps($self,$type)"},"containerName":"main::","definition":"sub"},{"range":{"start":{"line":359,"character":0},"end":{"line":359,"character":9999}},"containerName":"main::","definition":"sub","name":"pvalue","line":359,"children":[],"kind":12}]}