{"version":5,"vars":[{"name":"vars","containerName":"","kind":2,"line":79},{"containerName":"","name":"base","line":83,"kind":2},{"containerName":null,"name":"$DEFAULT_TYPE","line":86,"kind":13},{"containerName":"main::","definition":"sub","detail":"($class,@args)","signature":{"label":"new($class,@args)","parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: HSPFactory.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::HSP::HSPFactory\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::HSP::HSPFactory - A factory to create Bio::Search::HSP::HSPI objects \n\n=head1 SYNOPSIS\n\n    use Bio::Search::HSP::HSPFactory;\n    my $factory = Bio::Search::HSP::HSPFactory->new();\n    my $resultobj = $factory->create(@args);\n\n=head1 DESCRIPTION\n\n\nThis is a general way of hiding the object creation process so that we\ncan dynamically change the objects that are created by the SearchIO\nparser depending on what format report we are parsing.\n\nThis object is for creating new HSPs.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::HSP::HSPFactory;\nuse vars qw($DEFAULT_TYPE);\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Factory::ObjectFactoryI);\n\nBEGIN { \n    $DEFAULT_TYPE = 'Bio::Search::HSP::GenericHSP'; \n}\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::HSP::HSPFactory->new();\n Function: Builds a new Bio::Search::HSP::HSPFactory object \n Returns : Bio::Search::HSP::HSPFactory\n Args    :"},"kind":12,"line":100,"children":[{"line":101,"kind":13,"localvar":"my","definition":"my","name":"$class","containerName":"new"},{"line":101,"kind":13,"containerName":"new","name":"@args"},{"containerName":"new","name":"$self","definition":"my","localvar":"my","kind":13,"line":103},{"kind":13,"line":103,"name":"$class","containerName":"new"},{"kind":13,"line":103,"containerName":"new","name":"@args"},{"localvar":"my","containerName":"new","name":"$type","definition":"my","line":104,"kind":13},{"name":"$self","containerName":"new","kind":13,"line":104},{"line":104,"kind":12,"containerName":"new","name":"_rearrange"},{"line":104,"kind":13,"containerName":"new","name":"@args"},{"name":"$self","containerName":"new","line":105,"kind":13},{"containerName":"new","name":"type","line":105,"kind":12},{"kind":13,"line":105,"name":"$type","containerName":"new"},{"kind":13,"line":105,"name":"$type","containerName":"new"},{"kind":13,"line":106,"name":"$self","containerName":"new"}],"name":"new","range":{"end":{"line":107,"character":9999},"start":{"character":0,"line":100}}},{"line":103,"kind":12,"containerName":"new","name":"SUPER"},{"detail":"($self,@args)","signature":{"label":"create($self,@args)","documentation":"1;\n# $Id: HSPFactory.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::HSP::HSPFactory\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::HSP::HSPFactory - A factory to create Bio::Search::HSP::HSPI objects \n\n=head1 SYNOPSIS\n\n    use Bio::Search::HSP::HSPFactory;\n    my $factory = Bio::Search::HSP::HSPFactory->new();\n    my $resultobj = $factory->create(@args);\n\n=head1 DESCRIPTION\n\n\nThis is a general way of hiding the object creation process so that we\ncan dynamically change the objects that are created by the SearchIO\nparser depending on what format report we are parsing.\n\nThis object is for creating new HSPs.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::HSP::HSPFactory;\nuse vars qw($DEFAULT_TYPE);\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Factory::ObjectFactoryI);\n\nBEGIN { \n    $DEFAULT_TYPE = 'Bio::Search::HSP::GenericHSP'; \n}\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::HSP::HSPFactory->new();\n Function: Builds a new Bio::Search::HSP::HSPFactory object \n Returns : Bio::Search::HSP::HSPFactory\n Args    :\n\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($type) = $self->_rearrange([qw(TYPE)],@args);\n  $self->type($type) if defined $type;\n  return $self;\n}\n\n=head2 create\n\n Title   : create\n Usage   : $factory->create(%args)\n Function: Create a new L<Bio::Search::HSP::HSPI> object  \n Returns : L<Bio::Search::HSP::HSPI>\n Args    : hash of initialization parameters","parameters":[{"label":"$self"},{"label":"@args"}]},"containerName":"main::","definition":"sub","line":120,"children":[{"kind":13,"line":121,"name":"$self","definition":"my","containerName":"create","localvar":"my"},{"line":121,"kind":13,"name":"@args","containerName":"create"},{"kind":13,"line":122,"containerName":"create","name":"$type","definition":"my","localvar":"my"},{"name":"$self","containerName":"create","line":122,"kind":13},{"name":"type","containerName":"create","line":122,"kind":12},{"name":"$self","containerName":"create","line":123,"kind":13},{"kind":12,"line":123,"containerName":"create","name":"_load_module"},{"line":123,"kind":13,"containerName":"create","name":"$type"},{"containerName":"create","name":"$self","kind":13,"line":124},{"kind":12,"line":124,"containerName":"create","name":"throw"},{"kind":13,"line":125,"name":"$type","containerName":"create"},{"name":"new","containerName":"create","kind":12,"line":125},{"line":125,"kind":13,"containerName":"create","name":"@args"}],"kind":12,"range":{"start":{"character":0,"line":120},"end":{"line":126,"character":9999}},"name":"create"},{"kind":12,"line":139,"children":[{"containerName":"type","name":"$self","definition":"my","localvar":"my","kind":13,"line":140},{"containerName":"type","name":"$type","kind":13,"line":140},{"containerName":"type","name":"$type","line":141,"kind":13},{"name":"$self","containerName":"type","kind":13,"line":145},{"line":145,"kind":12,"containerName":"type","name":"_load_module"},{"containerName":"type","name":"$type","kind":13,"line":145},{"name":"$self","containerName":"type","line":146,"kind":13},{"line":146,"kind":12,"name":"warn","containerName":"type"},{"line":147,"kind":13,"containerName":"type","name":"$self"},{"kind":13,"line":147,"containerName":"type","name":"$type"},{"containerName":"type","name":"$self","kind":13,"line":149},{"line":149,"kind":13,"containerName":"type","name":"$DEFAULT_TYPE"}],"containerName":"main::","definition":"sub","detail":"($self,$type)","signature":{"label":"type($self,$type)","parameters":[{"label":"$self"},{"label":"$type"}],"documentation":"1;\n# $Id: HSPFactory.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::HSP::HSPFactory\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::HSP::HSPFactory - A factory to create Bio::Search::HSP::HSPI objects \n\n=head1 SYNOPSIS\n\n    use Bio::Search::HSP::HSPFactory;\n    my $factory = Bio::Search::HSP::HSPFactory->new();\n    my $resultobj = $factory->create(@args);\n\n=head1 DESCRIPTION\n\n\nThis is a general way of hiding the object creation process so that we\ncan dynamically change the objects that are created by the SearchIO\nparser depending on what format report we are parsing.\n\nThis object is for creating new HSPs.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::HSP::HSPFactory;\nuse vars qw($DEFAULT_TYPE);\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Factory::ObjectFactoryI);\n\nBEGIN { \n    $DEFAULT_TYPE = 'Bio::Search::HSP::GenericHSP'; \n}\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::HSP::HSPFactory->new();\n Function: Builds a new Bio::Search::HSP::HSPFactory object \n Returns : Bio::Search::HSP::HSPFactory\n Args    :\n\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($type) = $self->_rearrange([qw(TYPE)],@args);\n  $self->type($type) if defined $type;\n  return $self;\n}\n\n=head2 create\n\n Title   : create\n Usage   : $factory->create(%args)\n Function: Create a new L<Bio::Search::HSP::HSPI> object  \n Returns : L<Bio::Search::HSP::HSPI>\n Args    : hash of initialization parameters\n\n\n\nsub create{\n   my ($self,@args) = @_;\n   my $type = $self->type;\n   eval { $self->_load_module($type) };\n   if( $@ ) { $self->throw(\"Unable to load module $type\"); }\n   return $type->new(@args);\n}\n\n\n=head2 type\n\n Title   : type\n Usage   : $factory->type('Bio::Search::HSP::GenericHSP');\n Function: Get/Set the HSP creation type\n Returns : string\n Args    : [optional] string to set "},"name":"type","range":{"end":{"character":9999,"line":150},"start":{"character":0,"line":139}}}]}